/* SPDX-License-Identifier: GPL-2.0-or-later */
/*
 * Linux hotkey driver for Uniwill notebooks.
 *
 * Copyright (C) 2025 Armin Wolf <W_Armin@gmx.de>
 */

#ifndef UNIWILL_WMI_H
#define UNIWILL_WMI_H

#include <linux/init.h>

#define UNIWILL_OSD_CAPSLOCK			0x01
#define UNIWILL_OSD_NUMLOCK			0x02
#define UNIWILL_OSD_SCROLLLOCK			0x03

#define UNIWILL_OSD_TOUCHPAD_ON			0x04
#define UNIWILL_OSD_TOUCHPAD_OFF		0x05

#define UNIWILL_OSD_SILENT_MODE_ON		0x06
#define UNIWILL_OSD_SILENT_MODE_OFF		0x07

#define UNIWILL_OSD_WLAN_ON			0x08
#define UNIWILL_OSD_WLAN_OFF			0x09

#define UNIWILL_OSD_WIMAX_ON			0x0A
#define UNIWILL_OSD_WIMAX_OFF			0x0B

#define UNIWILL_OSD_BLUETOOTH_ON		0x0C
#define UNIWILL_OSD_BLUETOOTH_OFF		0x0D

#define UNIWILL_OSD_RF_ON			0x0E
#define UNIWILL_OSD_RF_OFF			0x0F

#define UNIWILL_OSD_3G_ON			0x10
#define UNIWILL_OSD_3G_OFF			0x11

#define UNIWILL_OSD_WEBCAM_ON			0x12
#define UNIWILL_OSD_WEBCAM_OFF			0x13

#define UNIWILL_OSD_BRIGHTNESSUP		0x14
#define UNIWILL_OSD_BRIGHTNESSDOWN		0x15

#define UNIWILL_OSD_RADIOON			0x1A
#define UNIWILL_OSD_RADIOOFF			0x1B

#define UNIWILL_OSD_POWERSAVE_ON		0x31
#define UNIWILL_OSD_POWERSAVE_OFF		0x32

#define UNIWILL_OSD_MENU			0x34

#define UNIWILL_OSD_MUTE			0x35
#define UNIWILL_OSD_VOLUMEDOWN			0x36
#define UNIWILL_OSD_VOLUMEUP			0x37

#define UNIWILL_OSD_MENU_2			0x38

#define UNIWILL_OSD_LIGHTBAR_ON			0x39
#define UNIWILL_OSD_LIGHTBAR_OFF		0x3A

#define UNIWILL_OSD_KB_LED_LEVEL0		0x3B
#define UNIWILL_OSD_KB_LED_LEVEL1		0x3C
#define UNIWILL_OSD_KB_LED_LEVEL2		0x3D
#define UNIWILL_OSD_KB_LED_LEVEL3		0x3E
#define UNIWILL_OSD_KB_LED_LEVEL4		0x3F

#define UNIWILL_OSD_SUPER_KEY_LOCK_ENABLE	0x40
#define UNIWILL_OSD_SUPER_KEY_LOCK_DISABLE	0x41

#define UNIWILL_OSD_MENU_JP			0x42

#define UNIWILL_OSD_CAMERA_ON			0x90
#define UNIWILL_OSD_CAMERA_OFF			0x91

#define UNIWILL_OSD_RFKILL			0xA4

#define UNIWILL_OSD_SUPER_KEY_LOCK_CHANGED	0xA5

#define UNIWILL_OSD_LIGHTBAR_STATE_CHANGED	0xA6

#define UNIWILL_OSD_FAN_BOOST_STATE_CHANGED	0xA7

#define UNIWILL_OSD_LCD_SW			0xA9

#define UNIWILL_OSD_FAN_OVERTEMP		0xAA

#define UNIWILL_OSD_DC_ADAPTER_CHANGED		0xAB

#define UNIWILL_OSD_BAT_HP_OFF			0xAC

#define UNIWILL_OSD_FAN_DOWN_TEMP		0xAD

#define UNIWILL_OSD_BATTERY_ALERT		0xAE

#define UNIWILL_OSD_TIMAP_HAIERLB_SW		0xAF

#define UNIWILL_OSD_PERFORMANCE_MODE_TOGGLE	0xB0

#define UNIWILL_OSD_KBDILLUMDOWN		0xB1
#define UNIWILL_OSD_KBDILLUMUP			0xB2

#define UNIWILL_OSD_BACKLIGHT_LEVEL_CHANGE	0xB3
#define UNIWILL_OSD_BACKLIGHT_POWER_CHANGE	0xB4

#define UNIWILL_OSD_MIC_MUTE			0xB7

#define UNIWILL_OSD_FN_LOCK			0xB8
#define UNIWILL_OSD_KBDILLUMTOGGLE		0xB9

#define UNIWILL_OSD_BAT_CHARGE_FULL_24_H	0xBE

#define UNIWILL_OSD_BAT_ERM_UPDATE		0xBF

#define UNIWILL_OSD_BENCHMARK_MODE_TOGGLE	0xC0

#define UNIWILL_OSD_WEBCAM_TOGGLE		0xCF

#define UNIWILL_OSD_KBD_BACKLIGHT_CHANGED	0xF0

struct device;
struct notifier_block;

int devm_uniwill_wmi_register_notifier(struct device *dev, struct notifier_block *nb);

int __init uniwill_wmi_register_driver(void);

void __exit uniwill_wmi_unregister_driver(void);

#endif /* UNIWILL_WMI_H */
