/* (C) 2026 by Timur Davydov <dtv.comp@gmail.com>
 * All Rights Reserved
 *
 * SPDX-License-Identifier: GPL-2.0+
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <sys/socket.h>
#include <netinet/in.h>
#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <osmocom/core/msgb.h>
#include <osmocom/core/socket.h>
#include <osmocom/core/talloc.h>
#include <osmocom/core/logging.h>
#include <osmocom/core/signal.h>

#include <osmocom/vty/telnet_interface.h>
#include <osmocom/vty/buffer.h>
#include <osmocom/vty/command.h>

/*! \file telnet_interface_dummy.c
 *  Telnet interface towards Osmocom VTY
 *
 *  This module contains the dummy code implementing a telnet server for VTY
 *  access.
 */

int telnet_init(void *tall_ctx, void *priv, int port)
{
	return 0;
}

int telnet_init_dynif(void *tall_ctx, void *priv, const char *ip, int port)
{
	return 0;
}

int telnet_init_default(void *tall_ctx, void *priv, int default_port)
{
	return 0;
}


/*! close a telnet connection */
int telnet_close_client(struct osmo_fd *fd)
{
	return 0;
}

bool vty_is_active(struct vty *vty)
{
	return false;
}

/*! callback from core VTY code about VTY related events */
void vty_event(enum event event, int sock, struct vty *vty)
{
}

/*! Close all telnet connections and release the telnet socket */
void telnet_exit(void)
{
}
