// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "RSL_Types.hh"

namespace RSL__Types {

/* Member functions of C++ classes */

RSL__IE__MS__Power__Parameters::RSL__IE__MS__Power__Parameters()
{
}

RSL__IE__MS__Power__Parameters::RSL__IE__MS__Power__Parameters(const INTEGER& par_len,
    const OCTETSTRING& par_params)
  :   field_len(par_len),
  field_params(par_params)
{
}

RSL__IE__MS__Power__Parameters::RSL__IE__MS__Power__Parameters(const RSL__IE__MS__Power__Parameters& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_MS_Power_Parameters.");
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.params().is_bound()) field_params = other_value.params();
else field_params.clean_up();
}

void RSL__IE__MS__Power__Parameters::clean_up()
{
field_len.clean_up();
field_params.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__MS__Power__Parameters::get_descriptor() const { return &RSL__IE__MS__Power__Parameters_descr_; }
RSL__IE__MS__Power__Parameters& RSL__IE__MS__Power__Parameters::operator=(const RSL__IE__MS__Power__Parameters& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_MS_Power_Parameters.");
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.params().is_bound()) field_params = other_value.params();
  else field_params.clean_up();
}
return *this;
}

boolean RSL__IE__MS__Power__Parameters::operator==(const RSL__IE__MS__Power__Parameters& other_value) const
{
return field_len==other_value.field_len
  && field_params==other_value.field_params;
}

boolean RSL__IE__MS__Power__Parameters::is_bound() const
{
return (field_len.is_bound())
  || (field_params.is_bound());
}
boolean RSL__IE__MS__Power__Parameters::is_value() const
{
return field_len.is_value()
  && field_params.is_value();
}
void RSL__IE__MS__Power__Parameters::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len := ");
field_len.log();
TTCN_Logger::log_event_str(", params := ");
field_params.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__MS__Power__Parameters::set_implicit_omit()
{
if (len().is_bound()) len().set_implicit_omit();
if (params().is_bound()) params().set_implicit_omit();
}

void RSL__IE__MS__Power__Parameters::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_MS_Power_Parameters has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) params().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "params")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          params().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_MS_Power_Parameters: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_MS_Power_Parameters");
  }
}

void RSL__IE__MS__Power__Parameters::encode_text(Text_Buf& text_buf) const
{
field_len.encode_text(text_buf);
field_params.encode_text(text_buf);
}

void RSL__IE__MS__Power__Parameters::decode_text(Text_Buf& text_buf)
{
field_len.decode_text(text_buf);
field_params.decode_text(text_buf);
}

void RSL__IE__MS__Power__Parameters::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__MS__Power__Parameters::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__MS__Power__Parameters::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__MS__Power__Parameters_len_descr_.raw->forceomit);
  decoded_field_length = field_len.RAW_decode(RSL__IE__MS__Power__Parameters_len_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_len.convert_to_Integer(RSL__IE__MS__Power__Parameters_len_descr_);
  field_len = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__MS__Power__Parameters_params_descr_.raw->forceomit);
  decoded_field_length = field_params.RAW_decode(RSL__IE__MS__Power__Parameters_params_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__MS__Power__Parameters::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__MS__Power__Parameters_len_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__MS__Power__Parameters_params_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &RSL__IE__MS__Power__Parameters_len_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  encoded_length += field_params.RAW_encode(RSL__IE__MS__Power__Parameters_params_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__MS__Power__Parameters_template::single_value_struct {
INTEGER_template field_len;
OCTETSTRING_template field_params;
};

void RSL__IE__MS__Power__Parameters_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_len = ANY_VALUE;
single_value->field_params = ANY_VALUE;
}
}
}

void RSL__IE__MS__Power__Parameters_template::copy_value(const RSL__IE__MS__Power__Parameters& other_value)
{
single_value = new single_value_struct;
if (other_value.len().is_bound()) {
  single_value->field_len = other_value.len();
} else {
  single_value->field_len.clean_up();
}
if (other_value.params().is_bound()) {
  single_value->field_params = other_value.params();
} else {
  single_value->field_params.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__MS__Power__Parameters_template::copy_template(const RSL__IE__MS__Power__Parameters_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.len().get_selection()) {
single_value->field_len = other_value.len();
} else {
single_value->field_len.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.params().get_selection()) {
single_value->field_params = other_value.params();
} else {
single_value->field_params.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__MS__Power__Parameters_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__MS__Power__Parameters_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__MS__Power__Parameters_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_MS_Power_Parameters.");
break;
}
set_selection(other_value);
}

RSL__IE__MS__Power__Parameters_template::RSL__IE__MS__Power__Parameters_template()
{
}

RSL__IE__MS__Power__Parameters_template::RSL__IE__MS__Power__Parameters_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__MS__Power__Parameters_template::RSL__IE__MS__Power__Parameters_template(const RSL__IE__MS__Power__Parameters& other_value)
{
copy_value(other_value);
}

RSL__IE__MS__Power__Parameters_template::RSL__IE__MS__Power__Parameters_template(const OPTIONAL<RSL__IE__MS__Power__Parameters>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__MS__Power__Parameters&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_MS_Power_Parameters from an unbound optional field.");
}
}

RSL__IE__MS__Power__Parameters_template::RSL__IE__MS__Power__Parameters_template(RSL__IE__MS__Power__Parameters_template* p_precondition, RSL__IE__MS__Power__Parameters_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__MS__Power__Parameters_template::RSL__IE__MS__Power__Parameters_template(Dynamic_Match_Interface<RSL__IE__MS__Power__Parameters>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__MS__Power__Parameters>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__MS__Power__Parameters_template::RSL__IE__MS__Power__Parameters_template(const RSL__IE__MS__Power__Parameters_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__MS__Power__Parameters_template::~RSL__IE__MS__Power__Parameters_template()
{
clean_up();
}

RSL__IE__MS__Power__Parameters_template& RSL__IE__MS__Power__Parameters_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__MS__Power__Parameters_template& RSL__IE__MS__Power__Parameters_template::operator=(const RSL__IE__MS__Power__Parameters& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__MS__Power__Parameters_template& RSL__IE__MS__Power__Parameters_template::operator=(const OPTIONAL<RSL__IE__MS__Power__Parameters>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__MS__Power__Parameters&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_MS_Power_Parameters.");
}
return *this;
}

RSL__IE__MS__Power__Parameters_template& RSL__IE__MS__Power__Parameters_template::operator=(const RSL__IE__MS__Power__Parameters_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__MS__Power__Parameters_template::match(const RSL__IE__MS__Power__Parameters& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.len().is_bound()) return FALSE;
if(!single_value->field_len.match(other_value.len(), legacy))return FALSE;
if(!other_value.params().is_bound()) return FALSE;
if(!single_value->field_params.match(other_value.params(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_MS_Power_Parameters.");
}
return FALSE;
}

boolean RSL__IE__MS__Power__Parameters_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_len.is_bound()
 || single_value->field_params.is_bound();
}

boolean RSL__IE__MS__Power__Parameters_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_len.is_value()
 && single_value->field_params.is_value();
}

void RSL__IE__MS__Power__Parameters_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__MS__Power__Parameters RSL__IE__MS__Power__Parameters_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_MS_Power_Parameters.");
RSL__IE__MS__Power__Parameters ret_val;
if (single_value->field_len.is_bound()) {
ret_val.len() = single_value->field_len.valueof();
}
if (single_value->field_params.is_bound()) {
ret_val.params() = single_value->field_params.valueof();
}
return ret_val;
}

void RSL__IE__MS__Power__Parameters_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_MS_Power_Parameters.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__MS__Power__Parameters_template[list_length];
}

RSL__IE__MS__Power__Parameters_template& RSL__IE__MS__Power__Parameters_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_MS_Power_Parameters.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_MS_Power_Parameters.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__MS__Power__Parameters_template::len()
{
set_specific();
return single_value->field_len;
}

const INTEGER_template& RSL__IE__MS__Power__Parameters_template::len() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len of a non-specific template of type @RSL_Types.RSL_IE_MS_Power_Parameters.");
return single_value->field_len;
}

OCTETSTRING_template& RSL__IE__MS__Power__Parameters_template::params()
{
set_specific();
return single_value->field_params;
}

const OCTETSTRING_template& RSL__IE__MS__Power__Parameters_template::params() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field params of a non-specific template of type @RSL_Types.RSL_IE_MS_Power_Parameters.");
return single_value->field_params;
}

int RSL__IE__MS__Power__Parameters_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MS_Power_Parameters which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MS_Power_Parameters containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MS_Power_Parameters containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MS_Power_Parameters containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MS_Power_Parameters containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MS_Power_Parameters containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MS_Power_Parameters containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MS_Power_Parameters containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MS_Power_Parameters containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_MS_Power_Parameters.");
  }
  return 0;
}

void RSL__IE__MS__Power__Parameters_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log();
TTCN_Logger::log_event_str(", params := ");
single_value->field_params.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__MS__Power__Parameters_template::log_match(const RSL__IE__MS__Power__Parameters& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_len.match(match_value.len(), legacy)){
TTCN_Logger::log_logmatch_info(".len");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_params.match(match_value.params(), legacy)){
TTCN_Logger::log_logmatch_info(".params");
single_value->field_params.log_match(match_value.params(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::log_event_str(", params := ");
single_value->field_params.log_match(match_value.params(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__MS__Power__Parameters_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (len().is_bound()) len().set_implicit_omit();
if (params().is_bound()) params().set_implicit_omit();
}

void RSL__IE__MS__Power__Parameters_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_len.encode_text(text_buf);
single_value->field_params.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_MS_Power_Parameters.");
}
}

void RSL__IE__MS__Power__Parameters_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_len.decode_text(text_buf);
single_value->field_params.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__MS__Power__Parameters_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_MS_Power_Parameters.");
}
}

void RSL__IE__MS__Power__Parameters_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__MS__Power__Parameters_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_MS_Power_Parameters has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) params().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "params")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          params().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_MS_Power_Parameters: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__MS__Power__Parameters_template* precondition = new RSL__IE__MS__Power__Parameters_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__MS__Power__Parameters_template* implied_template = new RSL__IE__MS__Power__Parameters_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__MS__Power__Parameters_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_MS_Power_Parameters");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__MS__Power__Parameters_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_len.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MS_Power_Parameters");
single_value->field_params.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MS_Power_Parameters");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_MS_Power_Parameters");
}

boolean RSL__IE__MS__Power__Parameters_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__MS__Power__Parameters_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__ChanNeeded::RSL__ChanNeeded()
{
enum_value = UNBOUND_VALUE;
}

RSL__ChanNeeded::RSL__ChanNeeded(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @RSL_Types.RSL_ChanNeeded with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

RSL__ChanNeeded::RSL__ChanNeeded(enum_type other_value)
{
enum_value = other_value;
}

RSL__ChanNeeded::RSL__ChanNeeded(const RSL__ChanNeeded& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @RSL_Types.RSL_ChanNeeded.");
enum_value = other_value.enum_value;
}

RSL__ChanNeeded& RSL__ChanNeeded::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @RSL_Types.RSL_ChanNeeded.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

RSL__ChanNeeded& RSL__ChanNeeded::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

RSL__ChanNeeded& RSL__ChanNeeded::operator=(const RSL__ChanNeeded& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_ChanNeeded.");
enum_value = other_value.enum_value;
return *this;
}

boolean RSL__ChanNeeded::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_ChanNeeded.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_ChanNeeded comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean RSL__ChanNeeded::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_ChanNeeded.");
return enum_value == other_value;
}

boolean RSL__ChanNeeded::operator==(const RSL__ChanNeeded& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_ChanNeeded.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_ChanNeeded.");
return enum_value == other_value.enum_value;
}

boolean RSL__ChanNeeded::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_ChanNeeded.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_ChanNeeded comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean RSL__ChanNeeded::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_ChanNeeded.");
return enum_value < other_value;
}

boolean RSL__ChanNeeded::operator<(const RSL__ChanNeeded& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_ChanNeeded.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_ChanNeeded.");
return enum_value < other_value.enum_value;
}

boolean RSL__ChanNeeded::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_ChanNeeded.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_ChanNeeded comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean RSL__ChanNeeded::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_ChanNeeded.");
return enum_value > other_value;
}

boolean RSL__ChanNeeded::operator>(const RSL__ChanNeeded& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_ChanNeeded.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_ChanNeeded.");
return enum_value > other_value.enum_value;
}

const char *RSL__ChanNeeded::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case RSL__CHANNEED__ANY: return "RSL_CHANNEED_ANY";
case RSL__CHANNEED__SDCCH: return "RSL_CHANNEED_SDCCH";
case RSL__CHANNEED__TCH__F: return "RSL_CHANNEED_TCH_F";
case RSL__CHANNEED__TCH__ForH: return "RSL_CHANNEED_TCH_ForH";
default:
return "<unknown>";
}
}

RSL__ChanNeeded::enum_type RSL__ChanNeeded::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "RSL_CHANNEED_ANY")) return RSL__CHANNEED__ANY;
if (!strcmp(str_par, "RSL_CHANNEED_SDCCH")) return RSL__CHANNEED__SDCCH;
if (!strcmp(str_par, "RSL_CHANNEED_TCH_F")) return RSL__CHANNEED__TCH__F;
if (!strcmp(str_par, "RSL_CHANNEED_TCH_ForH")) return RSL__CHANNEED__TCH__ForH;
}
return UNKNOWN_VALUE;
}

boolean RSL__ChanNeeded::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
return TRUE;
default:
return FALSE;
}
}

int RSL__ChanNeeded::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_ChanNeeded.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int RSL__ChanNeeded::enum2int(const RSL__ChanNeeded& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_ChanNeeded.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void RSL__ChanNeeded::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @RSL_Types.RSL_ChanNeeded.", int_val);
enum_value = (enum_type)int_val;
}

RSL__ChanNeeded::operator RSL__ChanNeeded::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @RSL_Types.RSL_ChanNeeded.");
return enum_value;
}

void RSL__ChanNeeded::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void RSL__ChanNeeded::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@RSL_Types.RSL_ChanNeeded");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @RSL_Types.RSL_ChanNeeded.");
  }
}

void RSL__ChanNeeded::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @RSL_Types.RSL_ChanNeeded.");
text_buf.push_int(enum_value);
}

void RSL__ChanNeeded::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @RSL_Types.RSL_ChanNeeded.", enum_value);
}

void RSL__ChanNeeded::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__ChanNeeded::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__ChanNeeded::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 3, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int RSL__ChanNeeded::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 3);
}

void RSL__ChanNeeded_template::copy_template(const RSL__ChanNeeded_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__ChanNeeded_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__ChanNeeded_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__ChanNeeded_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_ChanNeeded.");
}
}

RSL__ChanNeeded_template::RSL__ChanNeeded_template()
{
}

RSL__ChanNeeded_template::RSL__ChanNeeded_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__ChanNeeded_template::RSL__ChanNeeded_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!RSL__ChanNeeded::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @RSL_Types.RSL_ChanNeeded with unknown numeric value %d.", other_value);
single_value = (RSL__ChanNeeded::enum_type)other_value;
}

RSL__ChanNeeded_template::RSL__ChanNeeded_template(RSL__ChanNeeded::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

RSL__ChanNeeded_template::RSL__ChanNeeded_template(const RSL__ChanNeeded& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == RSL__ChanNeeded::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @RSL_Types.RSL_ChanNeeded.");
single_value = other_value.enum_value;
}

RSL__ChanNeeded_template::RSL__ChanNeeded_template(const OPTIONAL<RSL__ChanNeeded>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__ChanNeeded::enum_type)(const RSL__ChanNeeded&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @RSL_Types.RSL_ChanNeeded from an unbound optional field.");
}
}

RSL__ChanNeeded_template::RSL__ChanNeeded_template(RSL__ChanNeeded_template* p_precondition, RSL__ChanNeeded_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__ChanNeeded_template::RSL__ChanNeeded_template(Dynamic_Match_Interface<RSL__ChanNeeded>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__ChanNeeded>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__ChanNeeded_template::RSL__ChanNeeded_template(const RSL__ChanNeeded_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

RSL__ChanNeeded_template::~RSL__ChanNeeded_template()
{
clean_up();
}

boolean RSL__ChanNeeded_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean RSL__ChanNeeded_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != RSL__ChanNeeded::UNBOUND_VALUE;
}

void RSL__ChanNeeded_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__ChanNeeded_template& RSL__ChanNeeded_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__ChanNeeded_template& RSL__ChanNeeded_template::operator=(int other_value)
{
if (!RSL__ChanNeeded::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @RSL_Types.RSL_ChanNeeded.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (RSL__ChanNeeded::enum_type)other_value;
return *this;
}

RSL__ChanNeeded_template& RSL__ChanNeeded_template::operator=(RSL__ChanNeeded::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

RSL__ChanNeeded_template& RSL__ChanNeeded_template::operator=(const RSL__ChanNeeded& other_value)
{
if (other_value.enum_value == RSL__ChanNeeded::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_ChanNeeded to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

RSL__ChanNeeded_template& RSL__ChanNeeded_template::operator=(const OPTIONAL<RSL__ChanNeeded>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__ChanNeeded::enum_type)(const RSL__ChanNeeded&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @RSL_Types.RSL_ChanNeeded.");
}
return *this;
}

RSL__ChanNeeded_template& RSL__ChanNeeded_template::operator=(const RSL__ChanNeeded_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__ChanNeeded_template::match(RSL__ChanNeeded::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_ChanNeeded.");
}
return FALSE;
}

boolean RSL__ChanNeeded_template::match(const RSL__ChanNeeded& other_value, boolean) const
{
if (other_value.enum_value == RSL__ChanNeeded::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @RSL_Types.RSL_ChanNeeded with an unbound value.");
return match(other_value.enum_value);
}

RSL__ChanNeeded::enum_type RSL__ChanNeeded_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @RSL_Types.RSL_ChanNeeded.");
return single_value;
}

void RSL__ChanNeeded_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__ChanNeeded_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @RSL_Types.RSL_ChanNeeded.");
}
}

RSL__ChanNeeded_template& RSL__ChanNeeded_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @RSL_Types.RSL_ChanNeeded.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @RSL_Types.RSL_ChanNeeded.");
return value_list.list_value[list_index];
}

void RSL__ChanNeeded_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(RSL__ChanNeeded::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__ChanNeeded_template::log_match(const RSL__ChanNeeded& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void RSL__ChanNeeded_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_ChanNeeded.");
}
}

void RSL__ChanNeeded_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (RSL__ChanNeeded::enum_type)text_buf.pull_int().get_val();
if (!RSL__ChanNeeded::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @RSL_Types.RSL_ChanNeeded.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__ChanNeeded_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @RSL_Types.RSL_ChanNeeded.");
}
}

boolean RSL__ChanNeeded_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__ChanNeeded_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RSL__ChanNeeded_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__ChanNeeded_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    RSL__ChanNeeded::enum_type enum_val = RSL__ChanNeeded::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!RSL__ChanNeeded::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @RSL_Types.RSL_ChanNeeded.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__ChanNeeded_template* precondition = new RSL__ChanNeeded_template;
    precondition->set_param(*m_p->get_elem(0));
    RSL__ChanNeeded_template* implied_template = new RSL__ChanNeeded_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = RSL__ChanNeeded_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@RSL_Types.RSL_ChanNeeded");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__ChanNeeded_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_ChanNeeded");
}

RSL__IE__ChanNeeded::RSL__IE__ChanNeeded()
{
}

RSL__IE__ChanNeeded::RSL__IE__ChanNeeded(const INTEGER& par_reserved,
    const RSL__ChanNeeded& par_chan__needed)
  :   field_reserved(par_reserved),
  field_chan__needed(par_chan__needed)
{
}

RSL__IE__ChanNeeded::RSL__IE__ChanNeeded(const RSL__IE__ChanNeeded& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_ChanNeeded.");
if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
else field_reserved.clean_up();
if (other_value.chan__needed().is_bound()) field_chan__needed = other_value.chan__needed();
else field_chan__needed.clean_up();
}

void RSL__IE__ChanNeeded::clean_up()
{
field_reserved.clean_up();
field_chan__needed.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__ChanNeeded::get_descriptor() const { return &RSL__IE__ChanNeeded_descr_; }
RSL__IE__ChanNeeded& RSL__IE__ChanNeeded::operator=(const RSL__IE__ChanNeeded& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_ChanNeeded.");
  if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
  else field_reserved.clean_up();
  if (other_value.chan__needed().is_bound()) field_chan__needed = other_value.chan__needed();
  else field_chan__needed.clean_up();
}
return *this;
}

boolean RSL__IE__ChanNeeded::operator==(const RSL__IE__ChanNeeded& other_value) const
{
return field_reserved==other_value.field_reserved
  && field_chan__needed==other_value.field_chan__needed;
}

boolean RSL__IE__ChanNeeded::is_bound() const
{
return (field_reserved.is_bound())
  || (field_chan__needed.is_bound());
}
boolean RSL__IE__ChanNeeded::is_value() const
{
return field_reserved.is_value()
  && field_chan__needed.is_value();
}
void RSL__IE__ChanNeeded::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ reserved := ");
field_reserved.log();
TTCN_Logger::log_event_str(", chan_needed := ");
field_chan__needed.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__ChanNeeded::set_implicit_omit()
{
if (reserved().is_bound()) reserved().set_implicit_omit();
if (chan__needed().is_bound()) chan__needed().set_implicit_omit();
}

void RSL__IE__ChanNeeded::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_ChanNeeded has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) chan__needed().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "chan_needed")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          chan__needed().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_ChanNeeded: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_ChanNeeded");
  }
}

void RSL__IE__ChanNeeded::encode_text(Text_Buf& text_buf) const
{
field_reserved.encode_text(text_buf);
field_chan__needed.encode_text(text_buf);
}

void RSL__IE__ChanNeeded::decode_text(Text_Buf& text_buf)
{
field_reserved.decode_text(text_buf);
field_chan__needed.decode_text(text_buf);
}

void RSL__IE__ChanNeeded::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__ChanNeeded::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__ChanNeeded::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__ChanNeeded_reserved_descr_.raw->forceomit);
  decoded_field_length = field_reserved.RAW_decode(RSL__IE__ChanNeeded_reserved_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__ChanNeeded_chan__needed_descr_.raw->forceomit);
  decoded_field_length = field_chan__needed.RAW_decode(RSL__IE__ChanNeeded_chan__needed_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__ChanNeeded::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__ChanNeeded_reserved_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__ChanNeeded_chan__needed_descr_.raw);
  encoded_length += field_reserved.RAW_encode(RSL__IE__ChanNeeded_reserved_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_chan__needed.RAW_encode(RSL__IE__ChanNeeded_chan__needed_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__ChanNeeded_template::single_value_struct {
INTEGER_template field_reserved;
RSL__ChanNeeded_template field_chan__needed;
};

void RSL__IE__ChanNeeded_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_reserved = ANY_VALUE;
single_value->field_chan__needed = ANY_VALUE;
}
}
}

void RSL__IE__ChanNeeded_template::copy_value(const RSL__IE__ChanNeeded& other_value)
{
single_value = new single_value_struct;
if (other_value.reserved().is_bound()) {
  single_value->field_reserved = other_value.reserved();
} else {
  single_value->field_reserved.clean_up();
}
if (other_value.chan__needed().is_bound()) {
  single_value->field_chan__needed = other_value.chan__needed();
} else {
  single_value->field_chan__needed.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__ChanNeeded_template::copy_template(const RSL__IE__ChanNeeded_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.reserved().get_selection()) {
single_value->field_reserved = other_value.reserved();
} else {
single_value->field_reserved.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.chan__needed().get_selection()) {
single_value->field_chan__needed = other_value.chan__needed();
} else {
single_value->field_chan__needed.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__ChanNeeded_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__ChanNeeded_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__ChanNeeded_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_ChanNeeded.");
break;
}
set_selection(other_value);
}

RSL__IE__ChanNeeded_template::RSL__IE__ChanNeeded_template()
{
}

RSL__IE__ChanNeeded_template::RSL__IE__ChanNeeded_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__ChanNeeded_template::RSL__IE__ChanNeeded_template(const RSL__IE__ChanNeeded& other_value)
{
copy_value(other_value);
}

RSL__IE__ChanNeeded_template::RSL__IE__ChanNeeded_template(const OPTIONAL<RSL__IE__ChanNeeded>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__ChanNeeded&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_ChanNeeded from an unbound optional field.");
}
}

RSL__IE__ChanNeeded_template::RSL__IE__ChanNeeded_template(RSL__IE__ChanNeeded_template* p_precondition, RSL__IE__ChanNeeded_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__ChanNeeded_template::RSL__IE__ChanNeeded_template(Dynamic_Match_Interface<RSL__IE__ChanNeeded>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__ChanNeeded>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__ChanNeeded_template::RSL__IE__ChanNeeded_template(const RSL__IE__ChanNeeded_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__ChanNeeded_template::~RSL__IE__ChanNeeded_template()
{
clean_up();
}

RSL__IE__ChanNeeded_template& RSL__IE__ChanNeeded_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__ChanNeeded_template& RSL__IE__ChanNeeded_template::operator=(const RSL__IE__ChanNeeded& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__ChanNeeded_template& RSL__IE__ChanNeeded_template::operator=(const OPTIONAL<RSL__IE__ChanNeeded>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__ChanNeeded&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_ChanNeeded.");
}
return *this;
}

RSL__IE__ChanNeeded_template& RSL__IE__ChanNeeded_template::operator=(const RSL__IE__ChanNeeded_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__ChanNeeded_template::match(const RSL__IE__ChanNeeded& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.reserved().is_bound()) return FALSE;
if(!single_value->field_reserved.match(other_value.reserved(), legacy))return FALSE;
if(!other_value.chan__needed().is_bound()) return FALSE;
if(!single_value->field_chan__needed.match(other_value.chan__needed(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_ChanNeeded.");
}
return FALSE;
}

boolean RSL__IE__ChanNeeded_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_reserved.is_bound()
 || single_value->field_chan__needed.is_bound();
}

boolean RSL__IE__ChanNeeded_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_reserved.is_value()
 && single_value->field_chan__needed.is_value();
}

void RSL__IE__ChanNeeded_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__ChanNeeded RSL__IE__ChanNeeded_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_ChanNeeded.");
RSL__IE__ChanNeeded ret_val;
if (single_value->field_reserved.is_bound()) {
ret_val.reserved() = single_value->field_reserved.valueof();
}
if (single_value->field_chan__needed.is_bound()) {
ret_val.chan__needed() = single_value->field_chan__needed.valueof();
}
return ret_val;
}

void RSL__IE__ChanNeeded_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_ChanNeeded.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__ChanNeeded_template[list_length];
}

RSL__IE__ChanNeeded_template& RSL__IE__ChanNeeded_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_ChanNeeded.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_ChanNeeded.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__ChanNeeded_template::reserved()
{
set_specific();
return single_value->field_reserved;
}

const INTEGER_template& RSL__IE__ChanNeeded_template::reserved() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reserved of a non-specific template of type @RSL_Types.RSL_IE_ChanNeeded.");
return single_value->field_reserved;
}

RSL__ChanNeeded_template& RSL__IE__ChanNeeded_template::chan__needed()
{
set_specific();
return single_value->field_chan__needed;
}

const RSL__ChanNeeded_template& RSL__IE__ChanNeeded_template::chan__needed() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field chan_needed of a non-specific template of type @RSL_Types.RSL_IE_ChanNeeded.");
return single_value->field_chan__needed;
}

int RSL__IE__ChanNeeded_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_ChanNeeded which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_ChanNeeded containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_ChanNeeded containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_ChanNeeded containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_ChanNeeded containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_ChanNeeded containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_ChanNeeded containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_ChanNeeded containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_ChanNeeded containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_ChanNeeded.");
  }
  return 0;
}

void RSL__IE__ChanNeeded_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ reserved := ");
single_value->field_reserved.log();
TTCN_Logger::log_event_str(", chan_needed := ");
single_value->field_chan__needed.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__ChanNeeded_template::log_match(const RSL__IE__ChanNeeded& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_reserved.match(match_value.reserved(), legacy)){
TTCN_Logger::log_logmatch_info(".reserved");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_chan__needed.match(match_value.chan__needed(), legacy)){
TTCN_Logger::log_logmatch_info(".chan_needed");
single_value->field_chan__needed.log_match(match_value.chan__needed(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ reserved := ");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::log_event_str(", chan_needed := ");
single_value->field_chan__needed.log_match(match_value.chan__needed(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__ChanNeeded_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (reserved().is_bound()) reserved().set_implicit_omit();
if (chan__needed().is_bound()) chan__needed().set_implicit_omit();
}

void RSL__IE__ChanNeeded_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_reserved.encode_text(text_buf);
single_value->field_chan__needed.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_ChanNeeded.");
}
}

void RSL__IE__ChanNeeded_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_reserved.decode_text(text_buf);
single_value->field_chan__needed.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__ChanNeeded_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_ChanNeeded.");
}
}

void RSL__IE__ChanNeeded_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__ChanNeeded_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_ChanNeeded has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) chan__needed().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "chan_needed")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          chan__needed().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_ChanNeeded: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__ChanNeeded_template* precondition = new RSL__IE__ChanNeeded_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__ChanNeeded_template* implied_template = new RSL__IE__ChanNeeded_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__ChanNeeded_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_ChanNeeded");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__ChanNeeded_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_reserved.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_ChanNeeded");
single_value->field_chan__needed.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_ChanNeeded");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_ChanNeeded");
}

boolean RSL__IE__ChanNeeded_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__ChanNeeded_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__CbCommand::RSL__CbCommand()
{
enum_value = UNBOUND_VALUE;
}

RSL__CbCommand::RSL__CbCommand(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @RSL_Types.RSL_CbCommand with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

RSL__CbCommand::RSL__CbCommand(enum_type other_value)
{
enum_value = other_value;
}

RSL__CbCommand::RSL__CbCommand(const RSL__CbCommand& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @RSL_Types.RSL_CbCommand.");
enum_value = other_value.enum_value;
}

RSL__CbCommand& RSL__CbCommand::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @RSL_Types.RSL_CbCommand.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

RSL__CbCommand& RSL__CbCommand::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

RSL__CbCommand& RSL__CbCommand::operator=(const RSL__CbCommand& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_CbCommand.");
enum_value = other_value.enum_value;
return *this;
}

boolean RSL__CbCommand::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CbCommand.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_CbCommand comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean RSL__CbCommand::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CbCommand.");
return enum_value == other_value;
}

boolean RSL__CbCommand::operator==(const RSL__CbCommand& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CbCommand.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CbCommand.");
return enum_value == other_value.enum_value;
}

boolean RSL__CbCommand::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CbCommand.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_CbCommand comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean RSL__CbCommand::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CbCommand.");
return enum_value < other_value;
}

boolean RSL__CbCommand::operator<(const RSL__CbCommand& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CbCommand.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CbCommand.");
return enum_value < other_value.enum_value;
}

boolean RSL__CbCommand::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CbCommand.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_CbCommand comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean RSL__CbCommand::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CbCommand.");
return enum_value > other_value;
}

boolean RSL__CbCommand::operator>(const RSL__CbCommand& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CbCommand.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CbCommand.");
return enum_value > other_value.enum_value;
}

const char *RSL__CbCommand::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case RSL__CB__CMD__NORMAL: return "RSL_CB_CMD_NORMAL";
case RSL__CB__CMD__SCHEDULE: return "RSL_CB_CMD_SCHEDULE";
case RSL__CB__CMD__DEFAULT: return "RSL_CB_CMD_DEFAULT";
case RSL__CB__CMD__NULL: return "RSL_CB_CMD_NULL";
default:
return "<unknown>";
}
}

RSL__CbCommand::enum_type RSL__CbCommand::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "RSL_CB_CMD_NORMAL")) return RSL__CB__CMD__NORMAL;
if (!strcmp(str_par, "RSL_CB_CMD_SCHEDULE")) return RSL__CB__CMD__SCHEDULE;
if (!strcmp(str_par, "RSL_CB_CMD_DEFAULT")) return RSL__CB__CMD__DEFAULT;
if (!strcmp(str_par, "RSL_CB_CMD_NULL")) return RSL__CB__CMD__NULL;
}
return UNKNOWN_VALUE;
}

boolean RSL__CbCommand::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 8:
case 14:
case 15:
return TRUE;
default:
return FALSE;
}
}

int RSL__CbCommand::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_CbCommand.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int RSL__CbCommand::enum2int(const RSL__CbCommand& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_CbCommand.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void RSL__CbCommand::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @RSL_Types.RSL_CbCommand.", int_val);
enum_value = (enum_type)int_val;
}

RSL__CbCommand::operator RSL__CbCommand::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @RSL_Types.RSL_CbCommand.");
return enum_value;
}

void RSL__CbCommand::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void RSL__CbCommand::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@RSL_Types.RSL_CbCommand");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @RSL_Types.RSL_CbCommand.");
  }
}

void RSL__CbCommand::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @RSL_Types.RSL_CbCommand.");
text_buf.push_int(enum_value);
}

void RSL__CbCommand::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @RSL_Types.RSL_CbCommand.", enum_value);
}

void RSL__CbCommand::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__CbCommand::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__CbCommand::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 4, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int RSL__CbCommand::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 4);
}

void RSL__CbCommand_template::copy_template(const RSL__CbCommand_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__CbCommand_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__CbCommand_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__CbCommand_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_CbCommand.");
}
}

RSL__CbCommand_template::RSL__CbCommand_template()
{
}

RSL__CbCommand_template::RSL__CbCommand_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__CbCommand_template::RSL__CbCommand_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!RSL__CbCommand::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @RSL_Types.RSL_CbCommand with unknown numeric value %d.", other_value);
single_value = (RSL__CbCommand::enum_type)other_value;
}

RSL__CbCommand_template::RSL__CbCommand_template(RSL__CbCommand::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

RSL__CbCommand_template::RSL__CbCommand_template(const RSL__CbCommand& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == RSL__CbCommand::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @RSL_Types.RSL_CbCommand.");
single_value = other_value.enum_value;
}

RSL__CbCommand_template::RSL__CbCommand_template(const OPTIONAL<RSL__CbCommand>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__CbCommand::enum_type)(const RSL__CbCommand&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @RSL_Types.RSL_CbCommand from an unbound optional field.");
}
}

RSL__CbCommand_template::RSL__CbCommand_template(RSL__CbCommand_template* p_precondition, RSL__CbCommand_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__CbCommand_template::RSL__CbCommand_template(Dynamic_Match_Interface<RSL__CbCommand>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__CbCommand>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__CbCommand_template::RSL__CbCommand_template(const RSL__CbCommand_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

RSL__CbCommand_template::~RSL__CbCommand_template()
{
clean_up();
}

boolean RSL__CbCommand_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean RSL__CbCommand_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != RSL__CbCommand::UNBOUND_VALUE;
}

void RSL__CbCommand_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__CbCommand_template& RSL__CbCommand_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__CbCommand_template& RSL__CbCommand_template::operator=(int other_value)
{
if (!RSL__CbCommand::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @RSL_Types.RSL_CbCommand.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (RSL__CbCommand::enum_type)other_value;
return *this;
}

RSL__CbCommand_template& RSL__CbCommand_template::operator=(RSL__CbCommand::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

RSL__CbCommand_template& RSL__CbCommand_template::operator=(const RSL__CbCommand& other_value)
{
if (other_value.enum_value == RSL__CbCommand::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_CbCommand to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

RSL__CbCommand_template& RSL__CbCommand_template::operator=(const OPTIONAL<RSL__CbCommand>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__CbCommand::enum_type)(const RSL__CbCommand&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @RSL_Types.RSL_CbCommand.");
}
return *this;
}

RSL__CbCommand_template& RSL__CbCommand_template::operator=(const RSL__CbCommand_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__CbCommand_template::match(RSL__CbCommand::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_CbCommand.");
}
return FALSE;
}

boolean RSL__CbCommand_template::match(const RSL__CbCommand& other_value, boolean) const
{
if (other_value.enum_value == RSL__CbCommand::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @RSL_Types.RSL_CbCommand with an unbound value.");
return match(other_value.enum_value);
}

RSL__CbCommand::enum_type RSL__CbCommand_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @RSL_Types.RSL_CbCommand.");
return single_value;
}

void RSL__CbCommand_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__CbCommand_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @RSL_Types.RSL_CbCommand.");
}
}

RSL__CbCommand_template& RSL__CbCommand_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @RSL_Types.RSL_CbCommand.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @RSL_Types.RSL_CbCommand.");
return value_list.list_value[list_index];
}

void RSL__CbCommand_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(RSL__CbCommand::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__CbCommand_template::log_match(const RSL__CbCommand& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void RSL__CbCommand_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_CbCommand.");
}
}

void RSL__CbCommand_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (RSL__CbCommand::enum_type)text_buf.pull_int().get_val();
if (!RSL__CbCommand::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @RSL_Types.RSL_CbCommand.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__CbCommand_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @RSL_Types.RSL_CbCommand.");
}
}

boolean RSL__CbCommand_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__CbCommand_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RSL__CbCommand_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__CbCommand_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    RSL__CbCommand::enum_type enum_val = RSL__CbCommand::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!RSL__CbCommand::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @RSL_Types.RSL_CbCommand.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__CbCommand_template* precondition = new RSL__CbCommand_template;
    precondition->set_param(*m_p->get_elem(0));
    RSL__CbCommand_template* implied_template = new RSL__CbCommand_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = RSL__CbCommand_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@RSL_Types.RSL_CbCommand");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__CbCommand_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_CbCommand");
}

RSL__IE__CbCommandType::RSL__IE__CbCommandType()
{
}

RSL__IE__CbCommandType::RSL__IE__CbCommandType(const RSL__CbCommand& par_command,
    const BOOLEAN& par_default__bcast__null,
    const BITSTRING& par_spare,
    const INTEGER& par_last__block)
  :   field_command(par_command),
  field_default__bcast__null(par_default__bcast__null),
  field_spare(par_spare),
  field_last__block(par_last__block)
{
}

RSL__IE__CbCommandType::RSL__IE__CbCommandType(const RSL__IE__CbCommandType& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_CbCommandType.");
if (other_value.command().is_bound()) field_command = other_value.command();
else field_command.clean_up();
if (other_value.default__bcast__null().is_bound()) field_default__bcast__null = other_value.default__bcast__null();
else field_default__bcast__null.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.last__block().is_bound()) field_last__block = other_value.last__block();
else field_last__block.clean_up();
}

void RSL__IE__CbCommandType::clean_up()
{
field_command.clean_up();
field_default__bcast__null.clean_up();
field_spare.clean_up();
field_last__block.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__CbCommandType::get_descriptor() const { return &RSL__IE__CbCommandType_descr_; }
RSL__IE__CbCommandType& RSL__IE__CbCommandType::operator=(const RSL__IE__CbCommandType& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_CbCommandType.");
  if (other_value.command().is_bound()) field_command = other_value.command();
  else field_command.clean_up();
  if (other_value.default__bcast__null().is_bound()) field_default__bcast__null = other_value.default__bcast__null();
  else field_default__bcast__null.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.last__block().is_bound()) field_last__block = other_value.last__block();
  else field_last__block.clean_up();
}
return *this;
}

boolean RSL__IE__CbCommandType::operator==(const RSL__IE__CbCommandType& other_value) const
{
return field_command==other_value.field_command
  && field_default__bcast__null==other_value.field_default__bcast__null
  && field_spare==other_value.field_spare
  && field_last__block==other_value.field_last__block;
}

boolean RSL__IE__CbCommandType::is_bound() const
{
return (field_command.is_bound())
  || (field_default__bcast__null.is_bound())
  || (field_spare.is_bound())
  || (field_last__block.is_bound());
}
boolean RSL__IE__CbCommandType::is_value() const
{
return field_command.is_value()
  && field_default__bcast__null.is_value()
  && field_spare.is_value()
  && field_last__block.is_value();
}
void RSL__IE__CbCommandType::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ command := ");
field_command.log();
TTCN_Logger::log_event_str(", default_bcast_null := ");
field_default__bcast__null.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", last_block := ");
field_last__block.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__CbCommandType::set_implicit_omit()
{
if (command().is_bound()) command().set_implicit_omit();
if (default__bcast__null().is_bound()) default__bcast__null().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (last__block().is_bound()) last__block().set_implicit_omit();
}

void RSL__IE__CbCommandType::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_CbCommandType has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) command().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) default__bcast__null().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) last__block().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "command")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          command().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "default_bcast_null")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          default__bcast__null().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "last_block")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          last__block().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_CbCommandType: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_CbCommandType");
  }
}

void RSL__IE__CbCommandType::encode_text(Text_Buf& text_buf) const
{
field_command.encode_text(text_buf);
field_default__bcast__null.encode_text(text_buf);
field_spare.encode_text(text_buf);
field_last__block.encode_text(text_buf);
}

void RSL__IE__CbCommandType::decode_text(Text_Buf& text_buf)
{
field_command.decode_text(text_buf);
field_default__bcast__null.decode_text(text_buf);
field_spare.decode_text(text_buf);
field_last__block.decode_text(text_buf);
}

void RSL__IE__CbCommandType::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__CbCommandType::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__CbCommandType::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__CbCommandType_command_descr_.raw->forceomit);
  decoded_field_length = field_command.RAW_decode(RSL__IE__CbCommandType_command_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__CbCommandType_default__bcast__null_descr_.raw->forceomit);
  decoded_field_length = field_default__bcast__null.RAW_decode(RSL__IE__CbCommandType_default__bcast__null_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, RSL__IE__CbCommandType_spare_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(RSL__IE__CbCommandType_spare_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, RSL__IE__CbCommandType_last__block_descr_.raw->forceomit);
  decoded_field_length = field_last__block.RAW_decode(RSL__IE__CbCommandType_last__block_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__CbCommandType::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__CbCommandType_command_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__CbCommandType_default__bcast__null_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RSL__IE__CbCommandType_spare_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, RSL__IE__CbCommandType_last__block_descr_.raw);
  encoded_length += field_command.RAW_encode(RSL__IE__CbCommandType_command_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_default__bcast__null.RAW_encode(RSL__IE__CbCommandType_default__bcast__null_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_spare.RAW_encode(RSL__IE__CbCommandType_spare_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_last__block.RAW_encode(RSL__IE__CbCommandType_last__block_descr_, *myleaf.body.node.nodes[3]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__CbCommandType_template::single_value_struct {
RSL__CbCommand_template field_command;
BOOLEAN_template field_default__bcast__null;
BITSTRING_template field_spare;
INTEGER_template field_last__block;
};

void RSL__IE__CbCommandType_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_command = ANY_VALUE;
single_value->field_default__bcast__null = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
single_value->field_last__block = ANY_VALUE;
}
}
}

void RSL__IE__CbCommandType_template::copy_value(const RSL__IE__CbCommandType& other_value)
{
single_value = new single_value_struct;
if (other_value.command().is_bound()) {
  single_value->field_command = other_value.command();
} else {
  single_value->field_command.clean_up();
}
if (other_value.default__bcast__null().is_bound()) {
  single_value->field_default__bcast__null = other_value.default__bcast__null();
} else {
  single_value->field_default__bcast__null.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.last__block().is_bound()) {
  single_value->field_last__block = other_value.last__block();
} else {
  single_value->field_last__block.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__CbCommandType_template::copy_template(const RSL__IE__CbCommandType_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.command().get_selection()) {
single_value->field_command = other_value.command();
} else {
single_value->field_command.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.default__bcast__null().get_selection()) {
single_value->field_default__bcast__null = other_value.default__bcast__null();
} else {
single_value->field_default__bcast__null.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.last__block().get_selection()) {
single_value->field_last__block = other_value.last__block();
} else {
single_value->field_last__block.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__CbCommandType_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__CbCommandType_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__CbCommandType_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_CbCommandType.");
break;
}
set_selection(other_value);
}

RSL__IE__CbCommandType_template::RSL__IE__CbCommandType_template()
{
}

RSL__IE__CbCommandType_template::RSL__IE__CbCommandType_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__CbCommandType_template::RSL__IE__CbCommandType_template(const RSL__IE__CbCommandType& other_value)
{
copy_value(other_value);
}

RSL__IE__CbCommandType_template::RSL__IE__CbCommandType_template(const OPTIONAL<RSL__IE__CbCommandType>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__CbCommandType&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_CbCommandType from an unbound optional field.");
}
}

RSL__IE__CbCommandType_template::RSL__IE__CbCommandType_template(RSL__IE__CbCommandType_template* p_precondition, RSL__IE__CbCommandType_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__CbCommandType_template::RSL__IE__CbCommandType_template(Dynamic_Match_Interface<RSL__IE__CbCommandType>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__CbCommandType>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__CbCommandType_template::RSL__IE__CbCommandType_template(const RSL__IE__CbCommandType_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__CbCommandType_template::~RSL__IE__CbCommandType_template()
{
clean_up();
}

RSL__IE__CbCommandType_template& RSL__IE__CbCommandType_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__CbCommandType_template& RSL__IE__CbCommandType_template::operator=(const RSL__IE__CbCommandType& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__CbCommandType_template& RSL__IE__CbCommandType_template::operator=(const OPTIONAL<RSL__IE__CbCommandType>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__CbCommandType&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_CbCommandType.");
}
return *this;
}

RSL__IE__CbCommandType_template& RSL__IE__CbCommandType_template::operator=(const RSL__IE__CbCommandType_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__CbCommandType_template::match(const RSL__IE__CbCommandType& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.command().is_bound()) return FALSE;
if(!single_value->field_command.match(other_value.command(), legacy))return FALSE;
if(!other_value.default__bcast__null().is_bound()) return FALSE;
if(!single_value->field_default__bcast__null.match(other_value.default__bcast__null(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.last__block().is_bound()) return FALSE;
if(!single_value->field_last__block.match(other_value.last__block(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_CbCommandType.");
}
return FALSE;
}

boolean RSL__IE__CbCommandType_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_command.is_bound()
 || single_value->field_default__bcast__null.is_bound()
 || single_value->field_spare.is_bound()
 || single_value->field_last__block.is_bound();
}

boolean RSL__IE__CbCommandType_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_command.is_value()
 && single_value->field_default__bcast__null.is_value()
 && single_value->field_spare.is_value()
 && single_value->field_last__block.is_value();
}

void RSL__IE__CbCommandType_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__CbCommandType RSL__IE__CbCommandType_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_CbCommandType.");
RSL__IE__CbCommandType ret_val;
if (single_value->field_command.is_bound()) {
ret_val.command() = single_value->field_command.valueof();
}
if (single_value->field_default__bcast__null.is_bound()) {
ret_val.default__bcast__null() = single_value->field_default__bcast__null.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_last__block.is_bound()) {
ret_val.last__block() = single_value->field_last__block.valueof();
}
return ret_val;
}

void RSL__IE__CbCommandType_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_CbCommandType.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__CbCommandType_template[list_length];
}

RSL__IE__CbCommandType_template& RSL__IE__CbCommandType_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_CbCommandType.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_CbCommandType.");
return value_list.list_value[list_index];
}

RSL__CbCommand_template& RSL__IE__CbCommandType_template::command()
{
set_specific();
return single_value->field_command;
}

const RSL__CbCommand_template& RSL__IE__CbCommandType_template::command() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field command of a non-specific template of type @RSL_Types.RSL_IE_CbCommandType.");
return single_value->field_command;
}

BOOLEAN_template& RSL__IE__CbCommandType_template::default__bcast__null()
{
set_specific();
return single_value->field_default__bcast__null;
}

const BOOLEAN_template& RSL__IE__CbCommandType_template::default__bcast__null() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field default_bcast_null of a non-specific template of type @RSL_Types.RSL_IE_CbCommandType.");
return single_value->field_default__bcast__null;
}

BITSTRING_template& RSL__IE__CbCommandType_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& RSL__IE__CbCommandType_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @RSL_Types.RSL_IE_CbCommandType.");
return single_value->field_spare;
}

INTEGER_template& RSL__IE__CbCommandType_template::last__block()
{
set_specific();
return single_value->field_last__block;
}

const INTEGER_template& RSL__IE__CbCommandType_template::last__block() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field last_block of a non-specific template of type @RSL_Types.RSL_IE_CbCommandType.");
return single_value->field_last__block;
}

int RSL__IE__CbCommandType_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CbCommandType which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CbCommandType containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CbCommandType containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CbCommandType containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CbCommandType containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CbCommandType containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CbCommandType containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CbCommandType containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CbCommandType containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_CbCommandType.");
  }
  return 0;
}

void RSL__IE__CbCommandType_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ command := ");
single_value->field_command.log();
TTCN_Logger::log_event_str(", default_bcast_null := ");
single_value->field_default__bcast__null.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", last_block := ");
single_value->field_last__block.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__CbCommandType_template::log_match(const RSL__IE__CbCommandType& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_command.match(match_value.command(), legacy)){
TTCN_Logger::log_logmatch_info(".command");
single_value->field_command.log_match(match_value.command(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_default__bcast__null.match(match_value.default__bcast__null(), legacy)){
TTCN_Logger::log_logmatch_info(".default_bcast_null");
single_value->field_default__bcast__null.log_match(match_value.default__bcast__null(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_last__block.match(match_value.last__block(), legacy)){
TTCN_Logger::log_logmatch_info(".last_block");
single_value->field_last__block.log_match(match_value.last__block(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ command := ");
single_value->field_command.log_match(match_value.command(), legacy);
TTCN_Logger::log_event_str(", default_bcast_null := ");
single_value->field_default__bcast__null.log_match(match_value.default__bcast__null(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", last_block := ");
single_value->field_last__block.log_match(match_value.last__block(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__CbCommandType_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (command().is_bound()) command().set_implicit_omit();
if (default__bcast__null().is_bound()) default__bcast__null().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (last__block().is_bound()) last__block().set_implicit_omit();
}

void RSL__IE__CbCommandType_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_command.encode_text(text_buf);
single_value->field_default__bcast__null.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
single_value->field_last__block.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_CbCommandType.");
}
}

void RSL__IE__CbCommandType_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_command.decode_text(text_buf);
single_value->field_default__bcast__null.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
single_value->field_last__block.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__CbCommandType_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_CbCommandType.");
}
}

void RSL__IE__CbCommandType_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__CbCommandType_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_CbCommandType has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) command().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) default__bcast__null().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) last__block().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "command")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          command().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "default_bcast_null")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          default__bcast__null().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "last_block")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          last__block().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_CbCommandType: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__CbCommandType_template* precondition = new RSL__IE__CbCommandType_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__CbCommandType_template* implied_template = new RSL__IE__CbCommandType_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__CbCommandType_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_CbCommandType");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__CbCommandType_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_command.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_CbCommandType");
single_value->field_default__bcast__null.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_CbCommandType");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_CbCommandType");
single_value->field_last__block.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_CbCommandType");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_CbCommandType");
}

boolean RSL__IE__CbCommandType_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__CbCommandType_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IE__CbchLoadInfo::RSL__IE__CbchLoadInfo()
{
}

RSL__IE__CbchLoadInfo::RSL__IE__CbchLoadInfo(const BOOLEAN& par_overflow,
    const BITSTRING& par_spare,
    const INTEGER& par_slot__count)
  :   field_overflow(par_overflow),
  field_spare(par_spare),
  field_slot__count(par_slot__count)
{
}

RSL__IE__CbchLoadInfo::RSL__IE__CbchLoadInfo(const RSL__IE__CbchLoadInfo& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_CbchLoadInfo.");
if (other_value.overflow().is_bound()) field_overflow = other_value.overflow();
else field_overflow.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.slot__count().is_bound()) field_slot__count = other_value.slot__count();
else field_slot__count.clean_up();
}

void RSL__IE__CbchLoadInfo::clean_up()
{
field_overflow.clean_up();
field_spare.clean_up();
field_slot__count.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__CbchLoadInfo::get_descriptor() const { return &RSL__IE__CbchLoadInfo_descr_; }
RSL__IE__CbchLoadInfo& RSL__IE__CbchLoadInfo::operator=(const RSL__IE__CbchLoadInfo& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_CbchLoadInfo.");
  if (other_value.overflow().is_bound()) field_overflow = other_value.overflow();
  else field_overflow.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.slot__count().is_bound()) field_slot__count = other_value.slot__count();
  else field_slot__count.clean_up();
}
return *this;
}

boolean RSL__IE__CbchLoadInfo::operator==(const RSL__IE__CbchLoadInfo& other_value) const
{
return field_overflow==other_value.field_overflow
  && field_spare==other_value.field_spare
  && field_slot__count==other_value.field_slot__count;
}

boolean RSL__IE__CbchLoadInfo::is_bound() const
{
return (field_overflow.is_bound())
  || (field_spare.is_bound())
  || (field_slot__count.is_bound());
}
boolean RSL__IE__CbchLoadInfo::is_value() const
{
return field_overflow.is_value()
  && field_spare.is_value()
  && field_slot__count.is_value();
}
void RSL__IE__CbchLoadInfo::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ overflow := ");
field_overflow.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", slot_count := ");
field_slot__count.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__CbchLoadInfo::set_implicit_omit()
{
if (overflow().is_bound()) overflow().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (slot__count().is_bound()) slot__count().set_implicit_omit();
}

void RSL__IE__CbchLoadInfo::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_CbchLoadInfo has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) overflow().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) slot__count().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "overflow")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          overflow().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "slot_count")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          slot__count().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_CbchLoadInfo: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_CbchLoadInfo");
  }
}

void RSL__IE__CbchLoadInfo::encode_text(Text_Buf& text_buf) const
{
field_overflow.encode_text(text_buf);
field_spare.encode_text(text_buf);
field_slot__count.encode_text(text_buf);
}

void RSL__IE__CbchLoadInfo::decode_text(Text_Buf& text_buf)
{
field_overflow.decode_text(text_buf);
field_spare.decode_text(text_buf);
field_slot__count.decode_text(text_buf);
}

void RSL__IE__CbchLoadInfo::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__CbchLoadInfo::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__CbchLoadInfo::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__CbchLoadInfo_overflow_descr_.raw->forceomit);
  decoded_field_length = field_overflow.RAW_decode(RSL__IE__CbchLoadInfo_overflow_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__CbchLoadInfo_spare_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(RSL__IE__CbchLoadInfo_spare_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, RSL__IE__CbchLoadInfo_slot__count_descr_.raw->forceomit);
  decoded_field_length = field_slot__count.RAW_decode(RSL__IE__CbchLoadInfo_slot__count_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__CbchLoadInfo::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__CbchLoadInfo_overflow_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__CbchLoadInfo_spare_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RSL__IE__CbchLoadInfo_slot__count_descr_.raw);
  encoded_length += field_overflow.RAW_encode(RSL__IE__CbchLoadInfo_overflow_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_spare.RAW_encode(RSL__IE__CbchLoadInfo_spare_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_slot__count.RAW_encode(RSL__IE__CbchLoadInfo_slot__count_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__CbchLoadInfo_template::single_value_struct {
BOOLEAN_template field_overflow;
BITSTRING_template field_spare;
INTEGER_template field_slot__count;
};

void RSL__IE__CbchLoadInfo_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_overflow = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
single_value->field_slot__count = ANY_VALUE;
}
}
}

void RSL__IE__CbchLoadInfo_template::copy_value(const RSL__IE__CbchLoadInfo& other_value)
{
single_value = new single_value_struct;
if (other_value.overflow().is_bound()) {
  single_value->field_overflow = other_value.overflow();
} else {
  single_value->field_overflow.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.slot__count().is_bound()) {
  single_value->field_slot__count = other_value.slot__count();
} else {
  single_value->field_slot__count.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__CbchLoadInfo_template::copy_template(const RSL__IE__CbchLoadInfo_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.overflow().get_selection()) {
single_value->field_overflow = other_value.overflow();
} else {
single_value->field_overflow.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.slot__count().get_selection()) {
single_value->field_slot__count = other_value.slot__count();
} else {
single_value->field_slot__count.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__CbchLoadInfo_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__CbchLoadInfo_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__CbchLoadInfo_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_CbchLoadInfo.");
break;
}
set_selection(other_value);
}

RSL__IE__CbchLoadInfo_template::RSL__IE__CbchLoadInfo_template()
{
}

RSL__IE__CbchLoadInfo_template::RSL__IE__CbchLoadInfo_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__CbchLoadInfo_template::RSL__IE__CbchLoadInfo_template(const RSL__IE__CbchLoadInfo& other_value)
{
copy_value(other_value);
}

RSL__IE__CbchLoadInfo_template::RSL__IE__CbchLoadInfo_template(const OPTIONAL<RSL__IE__CbchLoadInfo>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__CbchLoadInfo&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_CbchLoadInfo from an unbound optional field.");
}
}

RSL__IE__CbchLoadInfo_template::RSL__IE__CbchLoadInfo_template(RSL__IE__CbchLoadInfo_template* p_precondition, RSL__IE__CbchLoadInfo_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__CbchLoadInfo_template::RSL__IE__CbchLoadInfo_template(Dynamic_Match_Interface<RSL__IE__CbchLoadInfo>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__CbchLoadInfo>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__CbchLoadInfo_template::RSL__IE__CbchLoadInfo_template(const RSL__IE__CbchLoadInfo_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__CbchLoadInfo_template::~RSL__IE__CbchLoadInfo_template()
{
clean_up();
}

RSL__IE__CbchLoadInfo_template& RSL__IE__CbchLoadInfo_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__CbchLoadInfo_template& RSL__IE__CbchLoadInfo_template::operator=(const RSL__IE__CbchLoadInfo& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__CbchLoadInfo_template& RSL__IE__CbchLoadInfo_template::operator=(const OPTIONAL<RSL__IE__CbchLoadInfo>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__CbchLoadInfo&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_CbchLoadInfo.");
}
return *this;
}

RSL__IE__CbchLoadInfo_template& RSL__IE__CbchLoadInfo_template::operator=(const RSL__IE__CbchLoadInfo_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__CbchLoadInfo_template::match(const RSL__IE__CbchLoadInfo& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.overflow().is_bound()) return FALSE;
if(!single_value->field_overflow.match(other_value.overflow(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.slot__count().is_bound()) return FALSE;
if(!single_value->field_slot__count.match(other_value.slot__count(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_CbchLoadInfo.");
}
return FALSE;
}

boolean RSL__IE__CbchLoadInfo_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_overflow.is_bound()
 || single_value->field_spare.is_bound()
 || single_value->field_slot__count.is_bound();
}

boolean RSL__IE__CbchLoadInfo_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_overflow.is_value()
 && single_value->field_spare.is_value()
 && single_value->field_slot__count.is_value();
}

void RSL__IE__CbchLoadInfo_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__CbchLoadInfo RSL__IE__CbchLoadInfo_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_CbchLoadInfo.");
RSL__IE__CbchLoadInfo ret_val;
if (single_value->field_overflow.is_bound()) {
ret_val.overflow() = single_value->field_overflow.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_slot__count.is_bound()) {
ret_val.slot__count() = single_value->field_slot__count.valueof();
}
return ret_val;
}

void RSL__IE__CbchLoadInfo_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_CbchLoadInfo.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__CbchLoadInfo_template[list_length];
}

RSL__IE__CbchLoadInfo_template& RSL__IE__CbchLoadInfo_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_CbchLoadInfo.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_CbchLoadInfo.");
return value_list.list_value[list_index];
}

BOOLEAN_template& RSL__IE__CbchLoadInfo_template::overflow()
{
set_specific();
return single_value->field_overflow;
}

const BOOLEAN_template& RSL__IE__CbchLoadInfo_template::overflow() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field overflow of a non-specific template of type @RSL_Types.RSL_IE_CbchLoadInfo.");
return single_value->field_overflow;
}

BITSTRING_template& RSL__IE__CbchLoadInfo_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& RSL__IE__CbchLoadInfo_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @RSL_Types.RSL_IE_CbchLoadInfo.");
return single_value->field_spare;
}

INTEGER_template& RSL__IE__CbchLoadInfo_template::slot__count()
{
set_specific();
return single_value->field_slot__count;
}

const INTEGER_template& RSL__IE__CbchLoadInfo_template::slot__count() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field slot_count of a non-specific template of type @RSL_Types.RSL_IE_CbchLoadInfo.");
return single_value->field_slot__count;
}

int RSL__IE__CbchLoadInfo_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CbchLoadInfo which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CbchLoadInfo containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CbchLoadInfo containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CbchLoadInfo containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CbchLoadInfo containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CbchLoadInfo containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CbchLoadInfo containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CbchLoadInfo containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CbchLoadInfo containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_CbchLoadInfo.");
  }
  return 0;
}

void RSL__IE__CbchLoadInfo_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ overflow := ");
single_value->field_overflow.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", slot_count := ");
single_value->field_slot__count.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__CbchLoadInfo_template::log_match(const RSL__IE__CbchLoadInfo& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_overflow.match(match_value.overflow(), legacy)){
TTCN_Logger::log_logmatch_info(".overflow");
single_value->field_overflow.log_match(match_value.overflow(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_slot__count.match(match_value.slot__count(), legacy)){
TTCN_Logger::log_logmatch_info(".slot_count");
single_value->field_slot__count.log_match(match_value.slot__count(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ overflow := ");
single_value->field_overflow.log_match(match_value.overflow(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", slot_count := ");
single_value->field_slot__count.log_match(match_value.slot__count(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__CbchLoadInfo_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (overflow().is_bound()) overflow().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (slot__count().is_bound()) slot__count().set_implicit_omit();
}

void RSL__IE__CbchLoadInfo_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_overflow.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
single_value->field_slot__count.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_CbchLoadInfo.");
}
}

void RSL__IE__CbchLoadInfo_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_overflow.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
single_value->field_slot__count.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__CbchLoadInfo_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_CbchLoadInfo.");
}
}

void RSL__IE__CbchLoadInfo_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__CbchLoadInfo_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_CbchLoadInfo has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) overflow().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) slot__count().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "overflow")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          overflow().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "slot_count")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          slot__count().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_CbchLoadInfo: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__CbchLoadInfo_template* precondition = new RSL__IE__CbchLoadInfo_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__CbchLoadInfo_template* implied_template = new RSL__IE__CbchLoadInfo_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__CbchLoadInfo_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_CbchLoadInfo");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__CbchLoadInfo_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_overflow.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_CbchLoadInfo");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_CbchLoadInfo");
single_value->field_slot__count.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_CbchLoadInfo");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_CbchLoadInfo");
}

boolean RSL__IE__CbchLoadInfo_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__CbchLoadInfo_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IE__GroupCallReference::RSL__IE__GroupCallReference()
{
}

RSL__IE__GroupCallReference::RSL__IE__GroupCallReference(const INTEGER& par_len,
    const OCTETSTRING& par_group__or__bcast__call__ref)
  :   field_len(par_len),
  field_group__or__bcast__call__ref(par_group__or__bcast__call__ref)
{
}

RSL__IE__GroupCallReference::RSL__IE__GroupCallReference(const RSL__IE__GroupCallReference& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_GroupCallReference.");
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.group__or__bcast__call__ref().is_bound()) field_group__or__bcast__call__ref = other_value.group__or__bcast__call__ref();
else field_group__or__bcast__call__ref.clean_up();
}

void RSL__IE__GroupCallReference::clean_up()
{
field_len.clean_up();
field_group__or__bcast__call__ref.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__GroupCallReference::get_descriptor() const { return &RSL__IE__GroupCallReference_descr_; }
RSL__IE__GroupCallReference& RSL__IE__GroupCallReference::operator=(const RSL__IE__GroupCallReference& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_GroupCallReference.");
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.group__or__bcast__call__ref().is_bound()) field_group__or__bcast__call__ref = other_value.group__or__bcast__call__ref();
  else field_group__or__bcast__call__ref.clean_up();
}
return *this;
}

boolean RSL__IE__GroupCallReference::operator==(const RSL__IE__GroupCallReference& other_value) const
{
return field_len==other_value.field_len
  && field_group__or__bcast__call__ref==other_value.field_group__or__bcast__call__ref;
}

boolean RSL__IE__GroupCallReference::is_bound() const
{
return (field_len.is_bound())
  || (field_group__or__bcast__call__ref.is_bound());
}
boolean RSL__IE__GroupCallReference::is_value() const
{
return field_len.is_value()
  && field_group__or__bcast__call__ref.is_value();
}
void RSL__IE__GroupCallReference::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len := ");
field_len.log();
TTCN_Logger::log_event_str(", group_or_bcast_call_ref := ");
field_group__or__bcast__call__ref.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__GroupCallReference::set_implicit_omit()
{
if (len().is_bound()) len().set_implicit_omit();
if (group__or__bcast__call__ref().is_bound()) group__or__bcast__call__ref().set_implicit_omit();
}

void RSL__IE__GroupCallReference::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_GroupCallReference has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) group__or__bcast__call__ref().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "group_or_bcast_call_ref")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          group__or__bcast__call__ref().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_GroupCallReference: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_GroupCallReference");
  }
}

void RSL__IE__GroupCallReference::encode_text(Text_Buf& text_buf) const
{
field_len.encode_text(text_buf);
field_group__or__bcast__call__ref.encode_text(text_buf);
}

void RSL__IE__GroupCallReference::decode_text(Text_Buf& text_buf)
{
field_len.decode_text(text_buf);
field_group__or__bcast__call__ref.decode_text(text_buf);
}

void RSL__IE__GroupCallReference::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__GroupCallReference::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__GroupCallReference::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__GroupCallReference_len_descr_.raw->forceomit);
  decoded_field_length = field_len.RAW_decode(RSL__IE__GroupCallReference_len_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_len.convert_to_Integer(RSL__IE__GroupCallReference_len_descr_);
  field_len = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__GroupCallReference_group__or__bcast__call__ref_descr_.raw->forceomit);
  decoded_field_length = field_group__or__bcast__call__ref.RAW_decode(RSL__IE__GroupCallReference_group__or__bcast__call__ref_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__GroupCallReference::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__GroupCallReference_len_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__GroupCallReference_group__or__bcast__call__ref_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &RSL__IE__GroupCallReference_len_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  encoded_length += field_group__or__bcast__call__ref.RAW_encode(RSL__IE__GroupCallReference_group__or__bcast__call__ref_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__GroupCallReference_template::single_value_struct {
INTEGER_template field_len;
OCTETSTRING_template field_group__or__bcast__call__ref;
};

void RSL__IE__GroupCallReference_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_len = ANY_VALUE;
single_value->field_group__or__bcast__call__ref = ANY_VALUE;
}
}
}

void RSL__IE__GroupCallReference_template::copy_value(const RSL__IE__GroupCallReference& other_value)
{
single_value = new single_value_struct;
if (other_value.len().is_bound()) {
  single_value->field_len = other_value.len();
} else {
  single_value->field_len.clean_up();
}
if (other_value.group__or__bcast__call__ref().is_bound()) {
  single_value->field_group__or__bcast__call__ref = other_value.group__or__bcast__call__ref();
} else {
  single_value->field_group__or__bcast__call__ref.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__GroupCallReference_template::copy_template(const RSL__IE__GroupCallReference_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.len().get_selection()) {
single_value->field_len = other_value.len();
} else {
single_value->field_len.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.group__or__bcast__call__ref().get_selection()) {
single_value->field_group__or__bcast__call__ref = other_value.group__or__bcast__call__ref();
} else {
single_value->field_group__or__bcast__call__ref.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__GroupCallReference_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__GroupCallReference_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__GroupCallReference_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_GroupCallReference.");
break;
}
set_selection(other_value);
}

RSL__IE__GroupCallReference_template::RSL__IE__GroupCallReference_template()
{
}

RSL__IE__GroupCallReference_template::RSL__IE__GroupCallReference_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__GroupCallReference_template::RSL__IE__GroupCallReference_template(const RSL__IE__GroupCallReference& other_value)
{
copy_value(other_value);
}

RSL__IE__GroupCallReference_template::RSL__IE__GroupCallReference_template(const OPTIONAL<RSL__IE__GroupCallReference>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__GroupCallReference&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_GroupCallReference from an unbound optional field.");
}
}

RSL__IE__GroupCallReference_template::RSL__IE__GroupCallReference_template(RSL__IE__GroupCallReference_template* p_precondition, RSL__IE__GroupCallReference_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__GroupCallReference_template::RSL__IE__GroupCallReference_template(Dynamic_Match_Interface<RSL__IE__GroupCallReference>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__GroupCallReference>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__GroupCallReference_template::RSL__IE__GroupCallReference_template(const RSL__IE__GroupCallReference_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__GroupCallReference_template::~RSL__IE__GroupCallReference_template()
{
clean_up();
}

RSL__IE__GroupCallReference_template& RSL__IE__GroupCallReference_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__GroupCallReference_template& RSL__IE__GroupCallReference_template::operator=(const RSL__IE__GroupCallReference& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__GroupCallReference_template& RSL__IE__GroupCallReference_template::operator=(const OPTIONAL<RSL__IE__GroupCallReference>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__GroupCallReference&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_GroupCallReference.");
}
return *this;
}

RSL__IE__GroupCallReference_template& RSL__IE__GroupCallReference_template::operator=(const RSL__IE__GroupCallReference_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__GroupCallReference_template::match(const RSL__IE__GroupCallReference& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.len().is_bound()) return FALSE;
if(!single_value->field_len.match(other_value.len(), legacy))return FALSE;
if(!other_value.group__or__bcast__call__ref().is_bound()) return FALSE;
if(!single_value->field_group__or__bcast__call__ref.match(other_value.group__or__bcast__call__ref(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_GroupCallReference.");
}
return FALSE;
}

boolean RSL__IE__GroupCallReference_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_len.is_bound()
 || single_value->field_group__or__bcast__call__ref.is_bound();
}

boolean RSL__IE__GroupCallReference_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_len.is_value()
 && single_value->field_group__or__bcast__call__ref.is_value();
}

void RSL__IE__GroupCallReference_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__GroupCallReference RSL__IE__GroupCallReference_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_GroupCallReference.");
RSL__IE__GroupCallReference ret_val;
if (single_value->field_len.is_bound()) {
ret_val.len() = single_value->field_len.valueof();
}
if (single_value->field_group__or__bcast__call__ref.is_bound()) {
ret_val.group__or__bcast__call__ref() = single_value->field_group__or__bcast__call__ref.valueof();
}
return ret_val;
}

void RSL__IE__GroupCallReference_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_GroupCallReference.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__GroupCallReference_template[list_length];
}

RSL__IE__GroupCallReference_template& RSL__IE__GroupCallReference_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_GroupCallReference.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_GroupCallReference.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__GroupCallReference_template::len()
{
set_specific();
return single_value->field_len;
}

const INTEGER_template& RSL__IE__GroupCallReference_template::len() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len of a non-specific template of type @RSL_Types.RSL_IE_GroupCallReference.");
return single_value->field_len;
}

OCTETSTRING_template& RSL__IE__GroupCallReference_template::group__or__bcast__call__ref()
{
set_specific();
return single_value->field_group__or__bcast__call__ref;
}

const OCTETSTRING_template& RSL__IE__GroupCallReference_template::group__or__bcast__call__ref() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field group_or_bcast_call_ref of a non-specific template of type @RSL_Types.RSL_IE_GroupCallReference.");
return single_value->field_group__or__bcast__call__ref;
}

int RSL__IE__GroupCallReference_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupCallReference which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupCallReference containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupCallReference containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupCallReference containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupCallReference containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupCallReference containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupCallReference containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupCallReference containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupCallReference containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_GroupCallReference.");
  }
  return 0;
}

void RSL__IE__GroupCallReference_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log();
TTCN_Logger::log_event_str(", group_or_bcast_call_ref := ");
single_value->field_group__or__bcast__call__ref.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__GroupCallReference_template::log_match(const RSL__IE__GroupCallReference& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_len.match(match_value.len(), legacy)){
TTCN_Logger::log_logmatch_info(".len");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_group__or__bcast__call__ref.match(match_value.group__or__bcast__call__ref(), legacy)){
TTCN_Logger::log_logmatch_info(".group_or_bcast_call_ref");
single_value->field_group__or__bcast__call__ref.log_match(match_value.group__or__bcast__call__ref(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::log_event_str(", group_or_bcast_call_ref := ");
single_value->field_group__or__bcast__call__ref.log_match(match_value.group__or__bcast__call__ref(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__GroupCallReference_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (len().is_bound()) len().set_implicit_omit();
if (group__or__bcast__call__ref().is_bound()) group__or__bcast__call__ref().set_implicit_omit();
}

void RSL__IE__GroupCallReference_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_len.encode_text(text_buf);
single_value->field_group__or__bcast__call__ref.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_GroupCallReference.");
}
}

void RSL__IE__GroupCallReference_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_len.decode_text(text_buf);
single_value->field_group__or__bcast__call__ref.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__GroupCallReference_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_GroupCallReference.");
}
}

void RSL__IE__GroupCallReference_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__GroupCallReference_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_GroupCallReference has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) group__or__bcast__call__ref().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "group_or_bcast_call_ref")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          group__or__bcast__call__ref().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_GroupCallReference: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__GroupCallReference_template* precondition = new RSL__IE__GroupCallReference_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__GroupCallReference_template* implied_template = new RSL__IE__GroupCallReference_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__GroupCallReference_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_GroupCallReference");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__GroupCallReference_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_len.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_GroupCallReference");
single_value->field_group__or__bcast__call__ref.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_GroupCallReference");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_GroupCallReference");
}

boolean RSL__IE__GroupCallReference_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__GroupCallReference_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IE__GroupChannelDescription::RSL__IE__GroupChannelDescription()
{
}

RSL__IE__GroupChannelDescription::RSL__IE__GroupChannelDescription(const INTEGER& par_len,
    const OCTETSTRING& par_chan__desc)
  :   field_len(par_len),
  field_chan__desc(par_chan__desc)
{
}

RSL__IE__GroupChannelDescription::RSL__IE__GroupChannelDescription(const RSL__IE__GroupChannelDescription& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_GroupChannelDescription.");
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.chan__desc().is_bound()) field_chan__desc = other_value.chan__desc();
else field_chan__desc.clean_up();
}

void RSL__IE__GroupChannelDescription::clean_up()
{
field_len.clean_up();
field_chan__desc.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__GroupChannelDescription::get_descriptor() const { return &RSL__IE__GroupChannelDescription_descr_; }
RSL__IE__GroupChannelDescription& RSL__IE__GroupChannelDescription::operator=(const RSL__IE__GroupChannelDescription& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_GroupChannelDescription.");
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.chan__desc().is_bound()) field_chan__desc = other_value.chan__desc();
  else field_chan__desc.clean_up();
}
return *this;
}

boolean RSL__IE__GroupChannelDescription::operator==(const RSL__IE__GroupChannelDescription& other_value) const
{
return field_len==other_value.field_len
  && field_chan__desc==other_value.field_chan__desc;
}

boolean RSL__IE__GroupChannelDescription::is_bound() const
{
return (field_len.is_bound())
  || (field_chan__desc.is_bound());
}
boolean RSL__IE__GroupChannelDescription::is_value() const
{
return field_len.is_value()
  && field_chan__desc.is_value();
}
void RSL__IE__GroupChannelDescription::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len := ");
field_len.log();
TTCN_Logger::log_event_str(", chan_desc := ");
field_chan__desc.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__GroupChannelDescription::set_implicit_omit()
{
if (len().is_bound()) len().set_implicit_omit();
if (chan__desc().is_bound()) chan__desc().set_implicit_omit();
}

void RSL__IE__GroupChannelDescription::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_GroupChannelDescription has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) chan__desc().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "chan_desc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          chan__desc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_GroupChannelDescription: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_GroupChannelDescription");
  }
}

void RSL__IE__GroupChannelDescription::encode_text(Text_Buf& text_buf) const
{
field_len.encode_text(text_buf);
field_chan__desc.encode_text(text_buf);
}

void RSL__IE__GroupChannelDescription::decode_text(Text_Buf& text_buf)
{
field_len.decode_text(text_buf);
field_chan__desc.decode_text(text_buf);
}

void RSL__IE__GroupChannelDescription::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__GroupChannelDescription::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__GroupChannelDescription::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__GroupChannelDescription_len_descr_.raw->forceomit);
  decoded_field_length = field_len.RAW_decode(RSL__IE__GroupChannelDescription_len_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_len.convert_to_Integer(RSL__IE__GroupChannelDescription_len_descr_);
  field_len = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__GroupChannelDescription_chan__desc_descr_.raw->forceomit);
  decoded_field_length = field_chan__desc.RAW_decode(RSL__IE__GroupChannelDescription_chan__desc_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__GroupChannelDescription::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__GroupChannelDescription_len_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__GroupChannelDescription_chan__desc_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &RSL__IE__GroupChannelDescription_len_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  encoded_length += field_chan__desc.RAW_encode(RSL__IE__GroupChannelDescription_chan__desc_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__GroupChannelDescription_template::single_value_struct {
INTEGER_template field_len;
OCTETSTRING_template field_chan__desc;
};

void RSL__IE__GroupChannelDescription_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_len = ANY_VALUE;
single_value->field_chan__desc = ANY_VALUE;
}
}
}

void RSL__IE__GroupChannelDescription_template::copy_value(const RSL__IE__GroupChannelDescription& other_value)
{
single_value = new single_value_struct;
if (other_value.len().is_bound()) {
  single_value->field_len = other_value.len();
} else {
  single_value->field_len.clean_up();
}
if (other_value.chan__desc().is_bound()) {
  single_value->field_chan__desc = other_value.chan__desc();
} else {
  single_value->field_chan__desc.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__GroupChannelDescription_template::copy_template(const RSL__IE__GroupChannelDescription_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.len().get_selection()) {
single_value->field_len = other_value.len();
} else {
single_value->field_len.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.chan__desc().get_selection()) {
single_value->field_chan__desc = other_value.chan__desc();
} else {
single_value->field_chan__desc.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__GroupChannelDescription_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__GroupChannelDescription_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__GroupChannelDescription_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
break;
}
set_selection(other_value);
}

RSL__IE__GroupChannelDescription_template::RSL__IE__GroupChannelDescription_template()
{
}

RSL__IE__GroupChannelDescription_template::RSL__IE__GroupChannelDescription_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__GroupChannelDescription_template::RSL__IE__GroupChannelDescription_template(const RSL__IE__GroupChannelDescription& other_value)
{
copy_value(other_value);
}

RSL__IE__GroupChannelDescription_template::RSL__IE__GroupChannelDescription_template(const OPTIONAL<RSL__IE__GroupChannelDescription>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__GroupChannelDescription&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_GroupChannelDescription from an unbound optional field.");
}
}

RSL__IE__GroupChannelDescription_template::RSL__IE__GroupChannelDescription_template(RSL__IE__GroupChannelDescription_template* p_precondition, RSL__IE__GroupChannelDescription_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__GroupChannelDescription_template::RSL__IE__GroupChannelDescription_template(Dynamic_Match_Interface<RSL__IE__GroupChannelDescription>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__GroupChannelDescription>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__GroupChannelDescription_template::RSL__IE__GroupChannelDescription_template(const RSL__IE__GroupChannelDescription_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__GroupChannelDescription_template::~RSL__IE__GroupChannelDescription_template()
{
clean_up();
}

RSL__IE__GroupChannelDescription_template& RSL__IE__GroupChannelDescription_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__GroupChannelDescription_template& RSL__IE__GroupChannelDescription_template::operator=(const RSL__IE__GroupChannelDescription& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__GroupChannelDescription_template& RSL__IE__GroupChannelDescription_template::operator=(const OPTIONAL<RSL__IE__GroupChannelDescription>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__GroupChannelDescription&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
}
return *this;
}

RSL__IE__GroupChannelDescription_template& RSL__IE__GroupChannelDescription_template::operator=(const RSL__IE__GroupChannelDescription_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__GroupChannelDescription_template::match(const RSL__IE__GroupChannelDescription& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.len().is_bound()) return FALSE;
if(!single_value->field_len.match(other_value.len(), legacy))return FALSE;
if(!other_value.chan__desc().is_bound()) return FALSE;
if(!single_value->field_chan__desc.match(other_value.chan__desc(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
}
return FALSE;
}

boolean RSL__IE__GroupChannelDescription_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_len.is_bound()
 || single_value->field_chan__desc.is_bound();
}

boolean RSL__IE__GroupChannelDescription_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_len.is_value()
 && single_value->field_chan__desc.is_value();
}

void RSL__IE__GroupChannelDescription_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__GroupChannelDescription RSL__IE__GroupChannelDescription_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
RSL__IE__GroupChannelDescription ret_val;
if (single_value->field_len.is_bound()) {
ret_val.len() = single_value->field_len.valueof();
}
if (single_value->field_chan__desc.is_bound()) {
ret_val.chan__desc() = single_value->field_chan__desc.valueof();
}
return ret_val;
}

void RSL__IE__GroupChannelDescription_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__GroupChannelDescription_template[list_length];
}

RSL__IE__GroupChannelDescription_template& RSL__IE__GroupChannelDescription_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__GroupChannelDescription_template::len()
{
set_specific();
return single_value->field_len;
}

const INTEGER_template& RSL__IE__GroupChannelDescription_template::len() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len of a non-specific template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
return single_value->field_len;
}

OCTETSTRING_template& RSL__IE__GroupChannelDescription_template::chan__desc()
{
set_specific();
return single_value->field_chan__desc;
}

const OCTETSTRING_template& RSL__IE__GroupChannelDescription_template::chan__desc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field chan_desc of a non-specific template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
return single_value->field_chan__desc;
}

int RSL__IE__GroupChannelDescription_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupChannelDescription which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupChannelDescription containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupChannelDescription containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupChannelDescription containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupChannelDescription containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupChannelDescription containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupChannelDescription containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupChannelDescription containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupChannelDescription containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
  }
  return 0;
}

void RSL__IE__GroupChannelDescription_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log();
TTCN_Logger::log_event_str(", chan_desc := ");
single_value->field_chan__desc.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__GroupChannelDescription_template::log_match(const RSL__IE__GroupChannelDescription& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_len.match(match_value.len(), legacy)){
TTCN_Logger::log_logmatch_info(".len");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_chan__desc.match(match_value.chan__desc(), legacy)){
TTCN_Logger::log_logmatch_info(".chan_desc");
single_value->field_chan__desc.log_match(match_value.chan__desc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::log_event_str(", chan_desc := ");
single_value->field_chan__desc.log_match(match_value.chan__desc(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__GroupChannelDescription_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (len().is_bound()) len().set_implicit_omit();
if (chan__desc().is_bound()) chan__desc().set_implicit_omit();
}

void RSL__IE__GroupChannelDescription_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_len.encode_text(text_buf);
single_value->field_chan__desc.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
}
}

void RSL__IE__GroupChannelDescription_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_len.decode_text(text_buf);
single_value->field_chan__desc.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__GroupChannelDescription_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
}
}

void RSL__IE__GroupChannelDescription_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__GroupChannelDescription_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_GroupChannelDescription has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) chan__desc().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "chan_desc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          chan__desc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_GroupChannelDescription: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__GroupChannelDescription_template* precondition = new RSL__IE__GroupChannelDescription_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__GroupChannelDescription_template* implied_template = new RSL__IE__GroupChannelDescription_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__GroupChannelDescription_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_GroupChannelDescription");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__GroupChannelDescription_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_len.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_GroupChannelDescription");
single_value->field_chan__desc.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_GroupChannelDescription");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_GroupChannelDescription");
}

boolean RSL__IE__GroupChannelDescription_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__GroupChannelDescription_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IE__NchDrxInformation::RSL__IE__NchDrxInformation()
{
}

RSL__IE__NchDrxInformation::RSL__IE__NchDrxInformation(const INTEGER& par_len,
    const BITSTRING& par_spare,
    const BITSTRING& par_nln__status,
    const BITSTRING& par_emlpp__priority,
    const BITSTRING& par_nln)
  :   field_len(par_len),
  field_spare(par_spare),
  field_nln__status(par_nln__status),
  field_emlpp__priority(par_emlpp__priority),
  field_nln(par_nln)
{
}

RSL__IE__NchDrxInformation::RSL__IE__NchDrxInformation(const RSL__IE__NchDrxInformation& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_NchDrxInformation.");
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.nln__status().is_bound()) field_nln__status = other_value.nln__status();
else field_nln__status.clean_up();
if (other_value.emlpp__priority().is_bound()) field_emlpp__priority = other_value.emlpp__priority();
else field_emlpp__priority.clean_up();
if (other_value.nln().is_bound()) field_nln = other_value.nln();
else field_nln.clean_up();
}

void RSL__IE__NchDrxInformation::clean_up()
{
field_len.clean_up();
field_spare.clean_up();
field_nln__status.clean_up();
field_emlpp__priority.clean_up();
field_nln.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__NchDrxInformation::get_descriptor() const { return &RSL__IE__NchDrxInformation_descr_; }
RSL__IE__NchDrxInformation& RSL__IE__NchDrxInformation::operator=(const RSL__IE__NchDrxInformation& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_NchDrxInformation.");
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.nln__status().is_bound()) field_nln__status = other_value.nln__status();
  else field_nln__status.clean_up();
  if (other_value.emlpp__priority().is_bound()) field_emlpp__priority = other_value.emlpp__priority();
  else field_emlpp__priority.clean_up();
  if (other_value.nln().is_bound()) field_nln = other_value.nln();
  else field_nln.clean_up();
}
return *this;
}

boolean RSL__IE__NchDrxInformation::operator==(const RSL__IE__NchDrxInformation& other_value) const
{
return field_len==other_value.field_len
  && field_spare==other_value.field_spare
  && field_nln__status==other_value.field_nln__status
  && field_emlpp__priority==other_value.field_emlpp__priority
  && field_nln==other_value.field_nln;
}

boolean RSL__IE__NchDrxInformation::is_bound() const
{
return (field_len.is_bound())
  || (field_spare.is_bound())
  || (field_nln__status.is_bound())
  || (field_emlpp__priority.is_bound())
  || (field_nln.is_bound());
}
boolean RSL__IE__NchDrxInformation::is_value() const
{
return field_len.is_value()
  && field_spare.is_value()
  && field_nln__status.is_value()
  && field_emlpp__priority.is_value()
  && field_nln.is_value();
}
void RSL__IE__NchDrxInformation::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len := ");
field_len.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", nln_status := ");
field_nln__status.log();
TTCN_Logger::log_event_str(", emlpp_priority := ");
field_emlpp__priority.log();
TTCN_Logger::log_event_str(", nln := ");
field_nln.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__NchDrxInformation::set_implicit_omit()
{
if (len().is_bound()) len().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (nln__status().is_bound()) nln__status().set_implicit_omit();
if (emlpp__priority().is_bound()) emlpp__priority().set_implicit_omit();
if (nln().is_bound()) nln().set_implicit_omit();
}

void RSL__IE__NchDrxInformation::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_NchDrxInformation has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) nln__status().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) emlpp__priority().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) nln().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nln_status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nln__status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "emlpp_priority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          emlpp__priority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nln")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nln().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_NchDrxInformation: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_NchDrxInformation");
  }
}

void RSL__IE__NchDrxInformation::encode_text(Text_Buf& text_buf) const
{
field_len.encode_text(text_buf);
field_spare.encode_text(text_buf);
field_nln__status.encode_text(text_buf);
field_emlpp__priority.encode_text(text_buf);
field_nln.encode_text(text_buf);
}

void RSL__IE__NchDrxInformation::decode_text(Text_Buf& text_buf)
{
field_len.decode_text(text_buf);
field_spare.decode_text(text_buf);
field_nln__status.decode_text(text_buf);
field_emlpp__priority.decode_text(text_buf);
field_nln.decode_text(text_buf);
}

void RSL__IE__NchDrxInformation::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__NchDrxInformation::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__NchDrxInformation::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__NchDrxInformation_len_descr_.raw->forceomit);
  decoded_field_length = field_len.RAW_decode(RSL__IE__NchDrxInformation_len_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_len.convert_to_Integer(RSL__IE__NchDrxInformation_len_descr_);
  field_len = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__NchDrxInformation_spare_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(RSL__IE__NchDrxInformation_spare_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RSL__IE__NchDrxInformation_nln__status_descr_.raw->forceomit);
  decoded_field_length = field_nln__status.RAW_decode(RSL__IE__NchDrxInformation_nln__status_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, RSL__IE__NchDrxInformation_emlpp__priority_descr_.raw->forceomit);
  decoded_field_length = field_emlpp__priority.RAW_decode(RSL__IE__NchDrxInformation_emlpp__priority_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, RSL__IE__NchDrxInformation_nln_descr_.raw->forceomit);
  decoded_field_length = field_nln.RAW_decode(RSL__IE__NchDrxInformation_nln_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__NchDrxInformation::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__NchDrxInformation_len_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__NchDrxInformation_spare_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RSL__IE__NchDrxInformation_nln__status_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, RSL__IE__NchDrxInformation_emlpp__priority_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, RSL__IE__NchDrxInformation_nln_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &RSL__IE__NchDrxInformation_len_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 4;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(4);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  encoded_length += field_spare.RAW_encode(RSL__IE__NchDrxInformation_spare_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_nln__status.RAW_encode(RSL__IE__NchDrxInformation_nln__status_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_emlpp__priority.RAW_encode(RSL__IE__NchDrxInformation_emlpp__priority_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_nln.RAW_encode(RSL__IE__NchDrxInformation_nln_descr_, *myleaf.body.node.nodes[4]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__NchDrxInformation_template::single_value_struct {
INTEGER_template field_len;
BITSTRING_template field_spare;
BITSTRING_template field_nln__status;
BITSTRING_template field_emlpp__priority;
BITSTRING_template field_nln;
};

void RSL__IE__NchDrxInformation_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_len = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
single_value->field_nln__status = ANY_VALUE;
single_value->field_emlpp__priority = ANY_VALUE;
single_value->field_nln = ANY_VALUE;
}
}
}

void RSL__IE__NchDrxInformation_template::copy_value(const RSL__IE__NchDrxInformation& other_value)
{
single_value = new single_value_struct;
if (other_value.len().is_bound()) {
  single_value->field_len = other_value.len();
} else {
  single_value->field_len.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.nln__status().is_bound()) {
  single_value->field_nln__status = other_value.nln__status();
} else {
  single_value->field_nln__status.clean_up();
}
if (other_value.emlpp__priority().is_bound()) {
  single_value->field_emlpp__priority = other_value.emlpp__priority();
} else {
  single_value->field_emlpp__priority.clean_up();
}
if (other_value.nln().is_bound()) {
  single_value->field_nln = other_value.nln();
} else {
  single_value->field_nln.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__NchDrxInformation_template::copy_template(const RSL__IE__NchDrxInformation_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.len().get_selection()) {
single_value->field_len = other_value.len();
} else {
single_value->field_len.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nln__status().get_selection()) {
single_value->field_nln__status = other_value.nln__status();
} else {
single_value->field_nln__status.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.emlpp__priority().get_selection()) {
single_value->field_emlpp__priority = other_value.emlpp__priority();
} else {
single_value->field_emlpp__priority.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nln().get_selection()) {
single_value->field_nln = other_value.nln();
} else {
single_value->field_nln.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__NchDrxInformation_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__NchDrxInformation_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__NchDrxInformation_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_NchDrxInformation.");
break;
}
set_selection(other_value);
}

RSL__IE__NchDrxInformation_template::RSL__IE__NchDrxInformation_template()
{
}

RSL__IE__NchDrxInformation_template::RSL__IE__NchDrxInformation_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__NchDrxInformation_template::RSL__IE__NchDrxInformation_template(const RSL__IE__NchDrxInformation& other_value)
{
copy_value(other_value);
}

RSL__IE__NchDrxInformation_template::RSL__IE__NchDrxInformation_template(const OPTIONAL<RSL__IE__NchDrxInformation>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__NchDrxInformation&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_NchDrxInformation from an unbound optional field.");
}
}

RSL__IE__NchDrxInformation_template::RSL__IE__NchDrxInformation_template(RSL__IE__NchDrxInformation_template* p_precondition, RSL__IE__NchDrxInformation_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__NchDrxInformation_template::RSL__IE__NchDrxInformation_template(Dynamic_Match_Interface<RSL__IE__NchDrxInformation>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__NchDrxInformation>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__NchDrxInformation_template::RSL__IE__NchDrxInformation_template(const RSL__IE__NchDrxInformation_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__NchDrxInformation_template::~RSL__IE__NchDrxInformation_template()
{
clean_up();
}

RSL__IE__NchDrxInformation_template& RSL__IE__NchDrxInformation_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__NchDrxInformation_template& RSL__IE__NchDrxInformation_template::operator=(const RSL__IE__NchDrxInformation& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__NchDrxInformation_template& RSL__IE__NchDrxInformation_template::operator=(const OPTIONAL<RSL__IE__NchDrxInformation>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__NchDrxInformation&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_NchDrxInformation.");
}
return *this;
}

RSL__IE__NchDrxInformation_template& RSL__IE__NchDrxInformation_template::operator=(const RSL__IE__NchDrxInformation_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__NchDrxInformation_template::match(const RSL__IE__NchDrxInformation& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.len().is_bound()) return FALSE;
if(!single_value->field_len.match(other_value.len(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.nln__status().is_bound()) return FALSE;
if(!single_value->field_nln__status.match(other_value.nln__status(), legacy))return FALSE;
if(!other_value.emlpp__priority().is_bound()) return FALSE;
if(!single_value->field_emlpp__priority.match(other_value.emlpp__priority(), legacy))return FALSE;
if(!other_value.nln().is_bound()) return FALSE;
if(!single_value->field_nln.match(other_value.nln(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_NchDrxInformation.");
}
return FALSE;
}

boolean RSL__IE__NchDrxInformation_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_len.is_bound()
 || single_value->field_spare.is_bound()
 || single_value->field_nln__status.is_bound()
 || single_value->field_emlpp__priority.is_bound()
 || single_value->field_nln.is_bound();
}

boolean RSL__IE__NchDrxInformation_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_len.is_value()
 && single_value->field_spare.is_value()
 && single_value->field_nln__status.is_value()
 && single_value->field_emlpp__priority.is_value()
 && single_value->field_nln.is_value();
}

void RSL__IE__NchDrxInformation_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__NchDrxInformation RSL__IE__NchDrxInformation_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_NchDrxInformation.");
RSL__IE__NchDrxInformation ret_val;
if (single_value->field_len.is_bound()) {
ret_val.len() = single_value->field_len.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_nln__status.is_bound()) {
ret_val.nln__status() = single_value->field_nln__status.valueof();
}
if (single_value->field_emlpp__priority.is_bound()) {
ret_val.emlpp__priority() = single_value->field_emlpp__priority.valueof();
}
if (single_value->field_nln.is_bound()) {
ret_val.nln() = single_value->field_nln.valueof();
}
return ret_val;
}

void RSL__IE__NchDrxInformation_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_NchDrxInformation.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__NchDrxInformation_template[list_length];
}

RSL__IE__NchDrxInformation_template& RSL__IE__NchDrxInformation_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_NchDrxInformation.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_NchDrxInformation.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__NchDrxInformation_template::len()
{
set_specific();
return single_value->field_len;
}

const INTEGER_template& RSL__IE__NchDrxInformation_template::len() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len of a non-specific template of type @RSL_Types.RSL_IE_NchDrxInformation.");
return single_value->field_len;
}

BITSTRING_template& RSL__IE__NchDrxInformation_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& RSL__IE__NchDrxInformation_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @RSL_Types.RSL_IE_NchDrxInformation.");
return single_value->field_spare;
}

BITSTRING_template& RSL__IE__NchDrxInformation_template::nln__status()
{
set_specific();
return single_value->field_nln__status;
}

const BITSTRING_template& RSL__IE__NchDrxInformation_template::nln__status() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nln_status of a non-specific template of type @RSL_Types.RSL_IE_NchDrxInformation.");
return single_value->field_nln__status;
}

BITSTRING_template& RSL__IE__NchDrxInformation_template::emlpp__priority()
{
set_specific();
return single_value->field_emlpp__priority;
}

const BITSTRING_template& RSL__IE__NchDrxInformation_template::emlpp__priority() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field emlpp_priority of a non-specific template of type @RSL_Types.RSL_IE_NchDrxInformation.");
return single_value->field_emlpp__priority;
}

BITSTRING_template& RSL__IE__NchDrxInformation_template::nln()
{
set_specific();
return single_value->field_nln;
}

const BITSTRING_template& RSL__IE__NchDrxInformation_template::nln() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nln of a non-specific template of type @RSL_Types.RSL_IE_NchDrxInformation.");
return single_value->field_nln;
}

int RSL__IE__NchDrxInformation_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_NchDrxInformation which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_NchDrxInformation containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_NchDrxInformation containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_NchDrxInformation containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_NchDrxInformation containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_NchDrxInformation containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_NchDrxInformation containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_NchDrxInformation containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_NchDrxInformation containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_NchDrxInformation.");
  }
  return 0;
}

void RSL__IE__NchDrxInformation_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", nln_status := ");
single_value->field_nln__status.log();
TTCN_Logger::log_event_str(", emlpp_priority := ");
single_value->field_emlpp__priority.log();
TTCN_Logger::log_event_str(", nln := ");
single_value->field_nln.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__NchDrxInformation_template::log_match(const RSL__IE__NchDrxInformation& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_len.match(match_value.len(), legacy)){
TTCN_Logger::log_logmatch_info(".len");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nln__status.match(match_value.nln__status(), legacy)){
TTCN_Logger::log_logmatch_info(".nln_status");
single_value->field_nln__status.log_match(match_value.nln__status(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_emlpp__priority.match(match_value.emlpp__priority(), legacy)){
TTCN_Logger::log_logmatch_info(".emlpp_priority");
single_value->field_emlpp__priority.log_match(match_value.emlpp__priority(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nln.match(match_value.nln(), legacy)){
TTCN_Logger::log_logmatch_info(".nln");
single_value->field_nln.log_match(match_value.nln(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", nln_status := ");
single_value->field_nln__status.log_match(match_value.nln__status(), legacy);
TTCN_Logger::log_event_str(", emlpp_priority := ");
single_value->field_emlpp__priority.log_match(match_value.emlpp__priority(), legacy);
TTCN_Logger::log_event_str(", nln := ");
single_value->field_nln.log_match(match_value.nln(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__NchDrxInformation_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (len().is_bound()) len().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (nln__status().is_bound()) nln__status().set_implicit_omit();
if (emlpp__priority().is_bound()) emlpp__priority().set_implicit_omit();
if (nln().is_bound()) nln().set_implicit_omit();
}

void RSL__IE__NchDrxInformation_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_len.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
single_value->field_nln__status.encode_text(text_buf);
single_value->field_emlpp__priority.encode_text(text_buf);
single_value->field_nln.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_NchDrxInformation.");
}
}

void RSL__IE__NchDrxInformation_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_len.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
single_value->field_nln__status.decode_text(text_buf);
single_value->field_emlpp__priority.decode_text(text_buf);
single_value->field_nln.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__NchDrxInformation_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_NchDrxInformation.");
}
}

void RSL__IE__NchDrxInformation_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__NchDrxInformation_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_NchDrxInformation has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) nln__status().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) emlpp__priority().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) nln().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nln_status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nln__status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "emlpp_priority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          emlpp__priority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nln")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nln().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_NchDrxInformation: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__NchDrxInformation_template* precondition = new RSL__IE__NchDrxInformation_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__NchDrxInformation_template* implied_template = new RSL__IE__NchDrxInformation_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__NchDrxInformation_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_NchDrxInformation");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__NchDrxInformation_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_len.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_NchDrxInformation");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_NchDrxInformation");
single_value->field_nln__status.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_NchDrxInformation");
single_value->field_emlpp__priority.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_NchDrxInformation");
single_value->field_nln.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_NchDrxInformation");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_NchDrxInformation");
}

boolean RSL__IE__NchDrxInformation_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__NchDrxInformation_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__CommandIndicator::RSL__CommandIndicator()
{
enum_value = UNBOUND_VALUE;
}

RSL__CommandIndicator::RSL__CommandIndicator(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @RSL_Types.RSL_CommandIndicator with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

RSL__CommandIndicator::RSL__CommandIndicator(enum_type other_value)
{
enum_value = other_value;
}

RSL__CommandIndicator::RSL__CommandIndicator(const RSL__CommandIndicator& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
enum_value = other_value.enum_value;
}

RSL__CommandIndicator& RSL__CommandIndicator::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @RSL_Types.RSL_CommandIndicator.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

RSL__CommandIndicator& RSL__CommandIndicator::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

RSL__CommandIndicator& RSL__CommandIndicator::operator=(const RSL__CommandIndicator& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
enum_value = other_value.enum_value;
return *this;
}

boolean RSL__CommandIndicator::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_CommandIndicator comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean RSL__CommandIndicator::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
return enum_value == other_value;
}

boolean RSL__CommandIndicator::operator==(const RSL__CommandIndicator& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
return enum_value == other_value.enum_value;
}

boolean RSL__CommandIndicator::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_CommandIndicator comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean RSL__CommandIndicator::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
return enum_value < other_value;
}

boolean RSL__CommandIndicator::operator<(const RSL__CommandIndicator& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
return enum_value < other_value.enum_value;
}

boolean RSL__CommandIndicator::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_CommandIndicator comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean RSL__CommandIndicator::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
return enum_value > other_value;
}

boolean RSL__CommandIndicator::operator>(const RSL__CommandIndicator& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
return enum_value > other_value.enum_value;
}

const char *RSL__CommandIndicator::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case CMD__IND__START: return "CMD_IND_START";
case CMD__IND__STOP: return "CMD_IND_STOP";
default:
return "<unknown>";
}
}

RSL__CommandIndicator::enum_type RSL__CommandIndicator::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "CMD_IND_START")) return CMD__IND__START;
if (!strcmp(str_par, "CMD_IND_STOP")) return CMD__IND__STOP;
}
return UNKNOWN_VALUE;
}

boolean RSL__CommandIndicator::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
return TRUE;
default:
return FALSE;
}
}

int RSL__CommandIndicator::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_CommandIndicator.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int RSL__CommandIndicator::enum2int(const RSL__CommandIndicator& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_CommandIndicator.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void RSL__CommandIndicator::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @RSL_Types.RSL_CommandIndicator.", int_val);
enum_value = (enum_type)int_val;
}

RSL__CommandIndicator::operator RSL__CommandIndicator::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @RSL_Types.RSL_CommandIndicator.");
return enum_value;
}

void RSL__CommandIndicator::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void RSL__CommandIndicator::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@RSL_Types.RSL_CommandIndicator");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @RSL_Types.RSL_CommandIndicator.");
  }
}

void RSL__CommandIndicator::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
text_buf.push_int(enum_value);
}

void RSL__CommandIndicator::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @RSL_Types.RSL_CommandIndicator.", enum_value);
}

void RSL__CommandIndicator::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__CommandIndicator::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__CommandIndicator::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int RSL__CommandIndicator::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void RSL__CommandIndicator_template::copy_template(const RSL__CommandIndicator_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__CommandIndicator_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__CommandIndicator_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__CommandIndicator_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_CommandIndicator.");
}
}

RSL__CommandIndicator_template::RSL__CommandIndicator_template()
{
}

RSL__CommandIndicator_template::RSL__CommandIndicator_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__CommandIndicator_template::RSL__CommandIndicator_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!RSL__CommandIndicator::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @RSL_Types.RSL_CommandIndicator with unknown numeric value %d.", other_value);
single_value = (RSL__CommandIndicator::enum_type)other_value;
}

RSL__CommandIndicator_template::RSL__CommandIndicator_template(RSL__CommandIndicator::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

RSL__CommandIndicator_template::RSL__CommandIndicator_template(const RSL__CommandIndicator& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == RSL__CommandIndicator::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
single_value = other_value.enum_value;
}

RSL__CommandIndicator_template::RSL__CommandIndicator_template(const OPTIONAL<RSL__CommandIndicator>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__CommandIndicator::enum_type)(const RSL__CommandIndicator&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @RSL_Types.RSL_CommandIndicator from an unbound optional field.");
}
}

RSL__CommandIndicator_template::RSL__CommandIndicator_template(RSL__CommandIndicator_template* p_precondition, RSL__CommandIndicator_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__CommandIndicator_template::RSL__CommandIndicator_template(Dynamic_Match_Interface<RSL__CommandIndicator>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__CommandIndicator>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__CommandIndicator_template::RSL__CommandIndicator_template(const RSL__CommandIndicator_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

RSL__CommandIndicator_template::~RSL__CommandIndicator_template()
{
clean_up();
}

boolean RSL__CommandIndicator_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean RSL__CommandIndicator_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != RSL__CommandIndicator::UNBOUND_VALUE;
}

void RSL__CommandIndicator_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__CommandIndicator_template& RSL__CommandIndicator_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__CommandIndicator_template& RSL__CommandIndicator_template::operator=(int other_value)
{
if (!RSL__CommandIndicator::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @RSL_Types.RSL_CommandIndicator.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (RSL__CommandIndicator::enum_type)other_value;
return *this;
}

RSL__CommandIndicator_template& RSL__CommandIndicator_template::operator=(RSL__CommandIndicator::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

RSL__CommandIndicator_template& RSL__CommandIndicator_template::operator=(const RSL__CommandIndicator& other_value)
{
if (other_value.enum_value == RSL__CommandIndicator::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

RSL__CommandIndicator_template& RSL__CommandIndicator_template::operator=(const OPTIONAL<RSL__CommandIndicator>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__CommandIndicator::enum_type)(const RSL__CommandIndicator&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @RSL_Types.RSL_CommandIndicator.");
}
return *this;
}

RSL__CommandIndicator_template& RSL__CommandIndicator_template::operator=(const RSL__CommandIndicator_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__CommandIndicator_template::match(RSL__CommandIndicator::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_CommandIndicator.");
}
return FALSE;
}

boolean RSL__CommandIndicator_template::match(const RSL__CommandIndicator& other_value, boolean) const
{
if (other_value.enum_value == RSL__CommandIndicator::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @RSL_Types.RSL_CommandIndicator with an unbound value.");
return match(other_value.enum_value);
}

RSL__CommandIndicator::enum_type RSL__CommandIndicator_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @RSL_Types.RSL_CommandIndicator.");
return single_value;
}

void RSL__CommandIndicator_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__CommandIndicator_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @RSL_Types.RSL_CommandIndicator.");
}
}

RSL__CommandIndicator_template& RSL__CommandIndicator_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @RSL_Types.RSL_CommandIndicator.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @RSL_Types.RSL_CommandIndicator.");
return value_list.list_value[list_index];
}

void RSL__CommandIndicator_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(RSL__CommandIndicator::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__CommandIndicator_template::log_match(const RSL__CommandIndicator& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void RSL__CommandIndicator_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_CommandIndicator.");
}
}

void RSL__CommandIndicator_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (RSL__CommandIndicator::enum_type)text_buf.pull_int().get_val();
if (!RSL__CommandIndicator::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @RSL_Types.RSL_CommandIndicator.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__CommandIndicator_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @RSL_Types.RSL_CommandIndicator.");
}
}

boolean RSL__CommandIndicator_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__CommandIndicator_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RSL__CommandIndicator_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__CommandIndicator_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    RSL__CommandIndicator::enum_type enum_val = RSL__CommandIndicator::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!RSL__CommandIndicator::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @RSL_Types.RSL_CommandIndicator.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__CommandIndicator_template* precondition = new RSL__CommandIndicator_template;
    precondition->set_param(*m_p->get_elem(0));
    RSL__CommandIndicator_template* implied_template = new RSL__CommandIndicator_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = RSL__CommandIndicator_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@RSL_Types.RSL_CommandIndicator");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__CommandIndicator_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_CommandIndicator");
}

RSL__IE__CommandIndicator::RSL__IE__CommandIndicator()
{
}

RSL__IE__CommandIndicator::RSL__IE__CommandIndicator(const INTEGER& par_len,
    const RSL__CommandIndicator& par_command__value)
  :   field_len(par_len),
  field_command__value(par_command__value)
{
}

RSL__IE__CommandIndicator::RSL__IE__CommandIndicator(const RSL__IE__CommandIndicator& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_CommandIndicator.");
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.command__value().is_bound()) field_command__value = other_value.command__value();
else field_command__value.clean_up();
}

void RSL__IE__CommandIndicator::clean_up()
{
field_len.clean_up();
field_command__value.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__CommandIndicator::get_descriptor() const { return &RSL__IE__CommandIndicator_descr_; }
RSL__IE__CommandIndicator& RSL__IE__CommandIndicator::operator=(const RSL__IE__CommandIndicator& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_CommandIndicator.");
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.command__value().is_bound()) field_command__value = other_value.command__value();
  else field_command__value.clean_up();
}
return *this;
}

boolean RSL__IE__CommandIndicator::operator==(const RSL__IE__CommandIndicator& other_value) const
{
return field_len==other_value.field_len
  && field_command__value==other_value.field_command__value;
}

boolean RSL__IE__CommandIndicator::is_bound() const
{
return (field_len.is_bound())
  || (field_command__value.is_bound());
}
boolean RSL__IE__CommandIndicator::is_value() const
{
return field_len.is_value()
  && field_command__value.is_value();
}
void RSL__IE__CommandIndicator::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len := ");
field_len.log();
TTCN_Logger::log_event_str(", command_value := ");
field_command__value.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__CommandIndicator::set_implicit_omit()
{
if (len().is_bound()) len().set_implicit_omit();
if (command__value().is_bound()) command__value().set_implicit_omit();
}

void RSL__IE__CommandIndicator::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_CommandIndicator has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) command__value().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "command_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          command__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_CommandIndicator: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_CommandIndicator");
  }
}

void RSL__IE__CommandIndicator::encode_text(Text_Buf& text_buf) const
{
field_len.encode_text(text_buf);
field_command__value.encode_text(text_buf);
}

void RSL__IE__CommandIndicator::decode_text(Text_Buf& text_buf)
{
field_len.decode_text(text_buf);
field_command__value.decode_text(text_buf);
}

void RSL__IE__CommandIndicator::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__CommandIndicator::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__CommandIndicator::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__CommandIndicator_len_descr_.raw->forceomit);
  decoded_field_length = field_len.RAW_decode(RSL__IE__CommandIndicator_len_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_len.convert_to_Integer(RSL__IE__CommandIndicator_len_descr_);
  field_len = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__CommandIndicator_command__value_descr_.raw->forceomit);
  decoded_field_length = field_command__value.RAW_decode(RSL__IE__CommandIndicator_command__value_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__CommandIndicator::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__CommandIndicator_len_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__CommandIndicator_command__value_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &RSL__IE__CommandIndicator_len_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  encoded_length += field_command__value.RAW_encode(RSL__IE__CommandIndicator_command__value_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__CommandIndicator_template::single_value_struct {
INTEGER_template field_len;
RSL__CommandIndicator_template field_command__value;
};

void RSL__IE__CommandIndicator_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_len = ANY_VALUE;
single_value->field_command__value = ANY_VALUE;
}
}
}

void RSL__IE__CommandIndicator_template::copy_value(const RSL__IE__CommandIndicator& other_value)
{
single_value = new single_value_struct;
if (other_value.len().is_bound()) {
  single_value->field_len = other_value.len();
} else {
  single_value->field_len.clean_up();
}
if (other_value.command__value().is_bound()) {
  single_value->field_command__value = other_value.command__value();
} else {
  single_value->field_command__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__CommandIndicator_template::copy_template(const RSL__IE__CommandIndicator_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.len().get_selection()) {
single_value->field_len = other_value.len();
} else {
single_value->field_len.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.command__value().get_selection()) {
single_value->field_command__value = other_value.command__value();
} else {
single_value->field_command__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__CommandIndicator_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__CommandIndicator_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__CommandIndicator_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_CommandIndicator.");
break;
}
set_selection(other_value);
}

RSL__IE__CommandIndicator_template::RSL__IE__CommandIndicator_template()
{
}

RSL__IE__CommandIndicator_template::RSL__IE__CommandIndicator_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__CommandIndicator_template::RSL__IE__CommandIndicator_template(const RSL__IE__CommandIndicator& other_value)
{
copy_value(other_value);
}

RSL__IE__CommandIndicator_template::RSL__IE__CommandIndicator_template(const OPTIONAL<RSL__IE__CommandIndicator>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__CommandIndicator&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_CommandIndicator from an unbound optional field.");
}
}

RSL__IE__CommandIndicator_template::RSL__IE__CommandIndicator_template(RSL__IE__CommandIndicator_template* p_precondition, RSL__IE__CommandIndicator_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__CommandIndicator_template::RSL__IE__CommandIndicator_template(Dynamic_Match_Interface<RSL__IE__CommandIndicator>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__CommandIndicator>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__CommandIndicator_template::RSL__IE__CommandIndicator_template(const RSL__IE__CommandIndicator_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__CommandIndicator_template::~RSL__IE__CommandIndicator_template()
{
clean_up();
}

RSL__IE__CommandIndicator_template& RSL__IE__CommandIndicator_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__CommandIndicator_template& RSL__IE__CommandIndicator_template::operator=(const RSL__IE__CommandIndicator& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__CommandIndicator_template& RSL__IE__CommandIndicator_template::operator=(const OPTIONAL<RSL__IE__CommandIndicator>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__CommandIndicator&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_CommandIndicator.");
}
return *this;
}

RSL__IE__CommandIndicator_template& RSL__IE__CommandIndicator_template::operator=(const RSL__IE__CommandIndicator_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__CommandIndicator_template::match(const RSL__IE__CommandIndicator& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.len().is_bound()) return FALSE;
if(!single_value->field_len.match(other_value.len(), legacy))return FALSE;
if(!other_value.command__value().is_bound()) return FALSE;
if(!single_value->field_command__value.match(other_value.command__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_CommandIndicator.");
}
return FALSE;
}

boolean RSL__IE__CommandIndicator_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_len.is_bound()
 || single_value->field_command__value.is_bound();
}

boolean RSL__IE__CommandIndicator_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_len.is_value()
 && single_value->field_command__value.is_value();
}

void RSL__IE__CommandIndicator_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__CommandIndicator RSL__IE__CommandIndicator_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_CommandIndicator.");
RSL__IE__CommandIndicator ret_val;
if (single_value->field_len.is_bound()) {
ret_val.len() = single_value->field_len.valueof();
}
if (single_value->field_command__value.is_bound()) {
ret_val.command__value() = single_value->field_command__value.valueof();
}
return ret_val;
}

void RSL__IE__CommandIndicator_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_CommandIndicator.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__CommandIndicator_template[list_length];
}

RSL__IE__CommandIndicator_template& RSL__IE__CommandIndicator_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_CommandIndicator.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_CommandIndicator.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__CommandIndicator_template::len()
{
set_specific();
return single_value->field_len;
}

const INTEGER_template& RSL__IE__CommandIndicator_template::len() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len of a non-specific template of type @RSL_Types.RSL_IE_CommandIndicator.");
return single_value->field_len;
}

RSL__CommandIndicator_template& RSL__IE__CommandIndicator_template::command__value()
{
set_specific();
return single_value->field_command__value;
}

const RSL__CommandIndicator_template& RSL__IE__CommandIndicator_template::command__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field command_value of a non-specific template of type @RSL_Types.RSL_IE_CommandIndicator.");
return single_value->field_command__value;
}

int RSL__IE__CommandIndicator_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CommandIndicator which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CommandIndicator containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CommandIndicator containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CommandIndicator containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CommandIndicator containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CommandIndicator containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CommandIndicator containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CommandIndicator containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CommandIndicator containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_CommandIndicator.");
  }
  return 0;
}

void RSL__IE__CommandIndicator_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log();
TTCN_Logger::log_event_str(", command_value := ");
single_value->field_command__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__CommandIndicator_template::log_match(const RSL__IE__CommandIndicator& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_len.match(match_value.len(), legacy)){
TTCN_Logger::log_logmatch_info(".len");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_command__value.match(match_value.command__value(), legacy)){
TTCN_Logger::log_logmatch_info(".command_value");
single_value->field_command__value.log_match(match_value.command__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::log_event_str(", command_value := ");
single_value->field_command__value.log_match(match_value.command__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__CommandIndicator_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (len().is_bound()) len().set_implicit_omit();
if (command__value().is_bound()) command__value().set_implicit_omit();
}

void RSL__IE__CommandIndicator_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_len.encode_text(text_buf);
single_value->field_command__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_CommandIndicator.");
}
}

void RSL__IE__CommandIndicator_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_len.decode_text(text_buf);
single_value->field_command__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__CommandIndicator_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_CommandIndicator.");
}
}

void RSL__IE__CommandIndicator_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__CommandIndicator_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_CommandIndicator has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) command__value().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "command_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          command__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_CommandIndicator: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__CommandIndicator_template* precondition = new RSL__IE__CommandIndicator_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__CommandIndicator_template* implied_template = new RSL__IE__CommandIndicator_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__CommandIndicator_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_CommandIndicator");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__CommandIndicator_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_len.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_CommandIndicator");
single_value->field_command__value.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_CommandIndicator");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_CommandIndicator");
}

boolean RSL__IE__CommandIndicator_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__CommandIndicator_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IE__Uic::RSL__IE__Uic()
{
}

RSL__IE__Uic::RSL__IE__Uic(const INTEGER& par_len,
    const BITSTRING& par_spare,
    const INTEGER& par_uic)
  :   field_len(par_len),
  field_spare(par_spare),
  field_uic(par_uic)
{
}

RSL__IE__Uic::RSL__IE__Uic(const RSL__IE__Uic& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_Uic.");
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.uic().is_bound()) field_uic = other_value.uic();
else field_uic.clean_up();
}

void RSL__IE__Uic::clean_up()
{
field_len.clean_up();
field_spare.clean_up();
field_uic.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__Uic::get_descriptor() const { return &RSL__IE__Uic_descr_; }
RSL__IE__Uic& RSL__IE__Uic::operator=(const RSL__IE__Uic& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_Uic.");
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.uic().is_bound()) field_uic = other_value.uic();
  else field_uic.clean_up();
}
return *this;
}

boolean RSL__IE__Uic::operator==(const RSL__IE__Uic& other_value) const
{
return field_len==other_value.field_len
  && field_spare==other_value.field_spare
  && field_uic==other_value.field_uic;
}

boolean RSL__IE__Uic::is_bound() const
{
return (field_len.is_bound())
  || (field_spare.is_bound())
  || (field_uic.is_bound());
}
boolean RSL__IE__Uic::is_value() const
{
return field_len.is_value()
  && field_spare.is_value()
  && field_uic.is_value();
}
void RSL__IE__Uic::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len := ");
field_len.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", uic := ");
field_uic.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__Uic::set_implicit_omit()
{
if (len().is_bound()) len().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (uic().is_bound()) uic().set_implicit_omit();
}

void RSL__IE__Uic::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_Uic has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) uic().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "uic")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          uic().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_Uic: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_Uic");
  }
}

void RSL__IE__Uic::encode_text(Text_Buf& text_buf) const
{
field_len.encode_text(text_buf);
field_spare.encode_text(text_buf);
field_uic.encode_text(text_buf);
}

void RSL__IE__Uic::decode_text(Text_Buf& text_buf)
{
field_len.decode_text(text_buf);
field_spare.decode_text(text_buf);
field_uic.decode_text(text_buf);
}

void RSL__IE__Uic::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__Uic::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__Uic::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__Uic_len_descr_.raw->forceomit);
  decoded_field_length = field_len.RAW_decode(RSL__IE__Uic_len_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_len.convert_to_Integer(RSL__IE__Uic_len_descr_);
  field_len = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__Uic_spare_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(RSL__IE__Uic_spare_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RSL__IE__Uic_uic_descr_.raw->forceomit);
  decoded_field_length = field_uic.RAW_decode(RSL__IE__Uic_uic_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__Uic::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__Uic_len_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__Uic_spare_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RSL__IE__Uic_uic_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &RSL__IE__Uic_len_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 2;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(2);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_spare.RAW_encode(RSL__IE__Uic_spare_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_uic.RAW_encode(RSL__IE__Uic_uic_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__Uic_template::single_value_struct {
INTEGER_template field_len;
BITSTRING_template field_spare;
INTEGER_template field_uic;
};

void RSL__IE__Uic_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_len = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
single_value->field_uic = ANY_VALUE;
}
}
}

void RSL__IE__Uic_template::copy_value(const RSL__IE__Uic& other_value)
{
single_value = new single_value_struct;
if (other_value.len().is_bound()) {
  single_value->field_len = other_value.len();
} else {
  single_value->field_len.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.uic().is_bound()) {
  single_value->field_uic = other_value.uic();
} else {
  single_value->field_uic.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__Uic_template::copy_template(const RSL__IE__Uic_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.len().get_selection()) {
single_value->field_len = other_value.len();
} else {
single_value->field_len.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.uic().get_selection()) {
single_value->field_uic = other_value.uic();
} else {
single_value->field_uic.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__Uic_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__Uic_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__Uic_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_Uic.");
break;
}
set_selection(other_value);
}

RSL__IE__Uic_template::RSL__IE__Uic_template()
{
}

RSL__IE__Uic_template::RSL__IE__Uic_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__Uic_template::RSL__IE__Uic_template(const RSL__IE__Uic& other_value)
{
copy_value(other_value);
}

RSL__IE__Uic_template::RSL__IE__Uic_template(const OPTIONAL<RSL__IE__Uic>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__Uic&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_Uic from an unbound optional field.");
}
}

RSL__IE__Uic_template::RSL__IE__Uic_template(RSL__IE__Uic_template* p_precondition, RSL__IE__Uic_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__Uic_template::RSL__IE__Uic_template(Dynamic_Match_Interface<RSL__IE__Uic>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__Uic>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__Uic_template::RSL__IE__Uic_template(const RSL__IE__Uic_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__Uic_template::~RSL__IE__Uic_template()
{
clean_up();
}

RSL__IE__Uic_template& RSL__IE__Uic_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__Uic_template& RSL__IE__Uic_template::operator=(const RSL__IE__Uic& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__Uic_template& RSL__IE__Uic_template::operator=(const OPTIONAL<RSL__IE__Uic>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__Uic&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_Uic.");
}
return *this;
}

RSL__IE__Uic_template& RSL__IE__Uic_template::operator=(const RSL__IE__Uic_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__Uic_template::match(const RSL__IE__Uic& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.len().is_bound()) return FALSE;
if(!single_value->field_len.match(other_value.len(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.uic().is_bound()) return FALSE;
if(!single_value->field_uic.match(other_value.uic(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_Uic.");
}
return FALSE;
}

boolean RSL__IE__Uic_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_len.is_bound()
 || single_value->field_spare.is_bound()
 || single_value->field_uic.is_bound();
}

boolean RSL__IE__Uic_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_len.is_value()
 && single_value->field_spare.is_value()
 && single_value->field_uic.is_value();
}

void RSL__IE__Uic_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__Uic RSL__IE__Uic_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_Uic.");
RSL__IE__Uic ret_val;
if (single_value->field_len.is_bound()) {
ret_val.len() = single_value->field_len.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_uic.is_bound()) {
ret_val.uic() = single_value->field_uic.valueof();
}
return ret_val;
}

void RSL__IE__Uic_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_Uic.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__Uic_template[list_length];
}

RSL__IE__Uic_template& RSL__IE__Uic_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_Uic.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_Uic.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__Uic_template::len()
{
set_specific();
return single_value->field_len;
}

const INTEGER_template& RSL__IE__Uic_template::len() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len of a non-specific template of type @RSL_Types.RSL_IE_Uic.");
return single_value->field_len;
}

BITSTRING_template& RSL__IE__Uic_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& RSL__IE__Uic_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @RSL_Types.RSL_IE_Uic.");
return single_value->field_spare;
}

INTEGER_template& RSL__IE__Uic_template::uic()
{
set_specific();
return single_value->field_uic;
}

const INTEGER_template& RSL__IE__Uic_template::uic() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field uic of a non-specific template of type @RSL_Types.RSL_IE_Uic.");
return single_value->field_uic;
}

int RSL__IE__Uic_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_Uic which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_Uic containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_Uic containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_Uic containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_Uic containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_Uic containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_Uic containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_Uic containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_Uic containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_Uic.");
  }
  return 0;
}

void RSL__IE__Uic_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", uic := ");
single_value->field_uic.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__Uic_template::log_match(const RSL__IE__Uic& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_len.match(match_value.len(), legacy)){
TTCN_Logger::log_logmatch_info(".len");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_uic.match(match_value.uic(), legacy)){
TTCN_Logger::log_logmatch_info(".uic");
single_value->field_uic.log_match(match_value.uic(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", uic := ");
single_value->field_uic.log_match(match_value.uic(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__Uic_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (len().is_bound()) len().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (uic().is_bound()) uic().set_implicit_omit();
}

void RSL__IE__Uic_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_len.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
single_value->field_uic.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_Uic.");
}
}

void RSL__IE__Uic_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_len.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
single_value->field_uic.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__Uic_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_Uic.");
}
}

void RSL__IE__Uic_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__Uic_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_Uic has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) uic().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "uic")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          uic().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_Uic: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__Uic_template* precondition = new RSL__IE__Uic_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__Uic_template* implied_template = new RSL__IE__Uic_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__Uic_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_Uic");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__Uic_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_len.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_Uic");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_Uic");
single_value->field_uic.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_Uic");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_Uic");
}

boolean RSL__IE__Uic_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__Uic_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IE__MultirateCfg::RSL__IE__MultirateCfg()
{
}

RSL__IE__MultirateCfg::RSL__IE__MultirateCfg(const INTEGER& par_len,
    const INTEGER& par_mr__speech__ver,
    const BOOLEAN& par_nscb,
    const BOOLEAN& par_icmi,
    const BITSTRING& par_spare,
    const INTEGER& par_start__mode,
    const BITSTRING& par_codec__modes,
    const OCTETSTRING& par_parameters)
  :   field_len(par_len),
  field_mr__speech__ver(par_mr__speech__ver),
  field_nscb(par_nscb),
  field_icmi(par_icmi),
  field_spare(par_spare),
  field_start__mode(par_start__mode),
  field_codec__modes(par_codec__modes),
  field_parameters(par_parameters)
{
}

RSL__IE__MultirateCfg::RSL__IE__MultirateCfg(const RSL__IE__MultirateCfg& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_MultirateCfg.");
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.mr__speech__ver().is_bound()) field_mr__speech__ver = other_value.mr__speech__ver();
else field_mr__speech__ver.clean_up();
if (other_value.nscb().is_bound()) field_nscb = other_value.nscb();
else field_nscb.clean_up();
if (other_value.icmi().is_bound()) field_icmi = other_value.icmi();
else field_icmi.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.start__mode().is_bound()) field_start__mode = other_value.start__mode();
else field_start__mode.clean_up();
if (other_value.codec__modes().is_bound()) field_codec__modes = other_value.codec__modes();
else field_codec__modes.clean_up();
if (other_value.parameters().is_bound()) field_parameters = other_value.parameters();
else field_parameters.clean_up();
}

void RSL__IE__MultirateCfg::clean_up()
{
field_len.clean_up();
field_mr__speech__ver.clean_up();
field_nscb.clean_up();
field_icmi.clean_up();
field_spare.clean_up();
field_start__mode.clean_up();
field_codec__modes.clean_up();
field_parameters.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__MultirateCfg::get_descriptor() const { return &RSL__IE__MultirateCfg_descr_; }
RSL__IE__MultirateCfg& RSL__IE__MultirateCfg::operator=(const RSL__IE__MultirateCfg& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_MultirateCfg.");
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.mr__speech__ver().is_bound()) field_mr__speech__ver = other_value.mr__speech__ver();
  else field_mr__speech__ver.clean_up();
  if (other_value.nscb().is_bound()) field_nscb = other_value.nscb();
  else field_nscb.clean_up();
  if (other_value.icmi().is_bound()) field_icmi = other_value.icmi();
  else field_icmi.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.start__mode().is_bound()) field_start__mode = other_value.start__mode();
  else field_start__mode.clean_up();
  if (other_value.codec__modes().is_bound()) field_codec__modes = other_value.codec__modes();
  else field_codec__modes.clean_up();
  if (other_value.parameters().is_bound()) field_parameters = other_value.parameters();
  else field_parameters.clean_up();
}
return *this;
}

boolean RSL__IE__MultirateCfg::operator==(const RSL__IE__MultirateCfg& other_value) const
{
return field_len==other_value.field_len
  && field_mr__speech__ver==other_value.field_mr__speech__ver
  && field_nscb==other_value.field_nscb
  && field_icmi==other_value.field_icmi
  && field_spare==other_value.field_spare
  && field_start__mode==other_value.field_start__mode
  && field_codec__modes==other_value.field_codec__modes
  && field_parameters==other_value.field_parameters;
}

boolean RSL__IE__MultirateCfg::is_bound() const
{
return (field_len.is_bound())
  || (field_mr__speech__ver.is_bound())
  || (field_nscb.is_bound())
  || (field_icmi.is_bound())
  || (field_spare.is_bound())
  || (field_start__mode.is_bound())
  || (field_codec__modes.is_bound())
  || (field_parameters.is_bound());
}
boolean RSL__IE__MultirateCfg::is_value() const
{
return field_len.is_value()
  && field_mr__speech__ver.is_value()
  && field_nscb.is_value()
  && field_icmi.is_value()
  && field_spare.is_value()
  && field_start__mode.is_value()
  && field_codec__modes.is_value()
  && field_parameters.is_value();
}
void RSL__IE__MultirateCfg::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len := ");
field_len.log();
TTCN_Logger::log_event_str(", mr_speech_ver := ");
field_mr__speech__ver.log();
TTCN_Logger::log_event_str(", nscb := ");
field_nscb.log();
TTCN_Logger::log_event_str(", icmi := ");
field_icmi.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", start_mode := ");
field_start__mode.log();
TTCN_Logger::log_event_str(", codec_modes := ");
field_codec__modes.log();
TTCN_Logger::log_event_str(", parameters := ");
field_parameters.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__MultirateCfg::set_implicit_omit()
{
if (len().is_bound()) len().set_implicit_omit();
if (mr__speech__ver().is_bound()) mr__speech__ver().set_implicit_omit();
if (nscb().is_bound()) nscb().set_implicit_omit();
if (icmi().is_bound()) icmi().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (start__mode().is_bound()) start__mode().set_implicit_omit();
if (codec__modes().is_bound()) codec__modes().set_implicit_omit();
if (parameters().is_bound()) parameters().set_implicit_omit();
}

void RSL__IE__MultirateCfg::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_MultirateCfg has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) mr__speech__ver().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) nscb().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) icmi().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) start__mode().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) codec__modes().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) parameters().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mr_speech_ver")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mr__speech__ver().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nscb")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nscb().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "icmi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          icmi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "start_mode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          start__mode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "codec_modes")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          codec__modes().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "parameters")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          parameters().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_MultirateCfg: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_MultirateCfg");
  }
}

void RSL__IE__MultirateCfg::encode_text(Text_Buf& text_buf) const
{
field_len.encode_text(text_buf);
field_mr__speech__ver.encode_text(text_buf);
field_nscb.encode_text(text_buf);
field_icmi.encode_text(text_buf);
field_spare.encode_text(text_buf);
field_start__mode.encode_text(text_buf);
field_codec__modes.encode_text(text_buf);
field_parameters.encode_text(text_buf);
}

void RSL__IE__MultirateCfg::decode_text(Text_Buf& text_buf)
{
field_len.decode_text(text_buf);
field_mr__speech__ver.decode_text(text_buf);
field_nscb.decode_text(text_buf);
field_icmi.decode_text(text_buf);
field_spare.decode_text(text_buf);
field_start__mode.decode_text(text_buf);
field_codec__modes.decode_text(text_buf);
field_parameters.decode_text(text_buf);
}

void RSL__IE__MultirateCfg::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__MultirateCfg::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__MultirateCfg::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__MultirateCfg_len_descr_.raw->forceomit);
  decoded_field_length = field_len.RAW_decode(RSL__IE__MultirateCfg_len_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_len.convert_to_Integer(RSL__IE__MultirateCfg_len_descr_);
  field_len = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__MultirateCfg_mr__speech__ver_descr_.raw->forceomit);
  decoded_field_length = field_mr__speech__ver.RAW_decode(RSL__IE__MultirateCfg_mr__speech__ver_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RSL__IE__MultirateCfg_nscb_descr_.raw->forceomit);
  decoded_field_length = field_nscb.RAW_decode(RSL__IE__MultirateCfg_nscb_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, RSL__IE__MultirateCfg_icmi_descr_.raw->forceomit);
  decoded_field_length = field_icmi.RAW_decode(RSL__IE__MultirateCfg_icmi_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, RSL__IE__MultirateCfg_spare_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(RSL__IE__MultirateCfg_spare_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_5_force_omit(5, force_omit, RSL__IE__MultirateCfg_start__mode_descr_.raw->forceomit);
  decoded_field_length = field_start__mode.RAW_decode(RSL__IE__MultirateCfg_start__mode_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_6_force_omit(6, force_omit, RSL__IE__MultirateCfg_codec__modes_descr_.raw->forceomit);
  decoded_field_length = field_codec__modes.RAW_decode(RSL__IE__MultirateCfg_codec__modes_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_7_force_omit(7, force_omit, RSL__IE__MultirateCfg_parameters_descr_.raw->forceomit);
  decoded_field_length = field_parameters.RAW_decode(RSL__IE__MultirateCfg_parameters_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__MultirateCfg::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 8;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(8);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__MultirateCfg_len_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__MultirateCfg_mr__speech__ver_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RSL__IE__MultirateCfg_nscb_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, RSL__IE__MultirateCfg_icmi_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, RSL__IE__MultirateCfg_spare_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, RSL__IE__MultirateCfg_start__mode_descr_.raw);
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, RSL__IE__MultirateCfg_codec__modes_descr_.raw);
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, RSL__IE__MultirateCfg_parameters_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &RSL__IE__MultirateCfg_len_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 7;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(7);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[4].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[4].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[5].level = myleaf.body.node.nodes[6]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[5].pos = myleaf.body.node.nodes[6]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[6].level = myleaf.body.node.nodes[7]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[6].pos = myleaf.body.node.nodes[7]->curr_pos.pos;
  encoded_length += field_mr__speech__ver.RAW_encode(RSL__IE__MultirateCfg_mr__speech__ver_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_nscb.RAW_encode(RSL__IE__MultirateCfg_nscb_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_icmi.RAW_encode(RSL__IE__MultirateCfg_icmi_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_spare.RAW_encode(RSL__IE__MultirateCfg_spare_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_start__mode.RAW_encode(RSL__IE__MultirateCfg_start__mode_descr_, *myleaf.body.node.nodes[5]);
  encoded_length += field_codec__modes.RAW_encode(RSL__IE__MultirateCfg_codec__modes_descr_, *myleaf.body.node.nodes[6]);
  encoded_length += field_parameters.RAW_encode(RSL__IE__MultirateCfg_parameters_descr_, *myleaf.body.node.nodes[7]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__MultirateCfg_template::single_value_struct {
INTEGER_template field_len;
INTEGER_template field_mr__speech__ver;
BOOLEAN_template field_nscb;
BOOLEAN_template field_icmi;
BITSTRING_template field_spare;
INTEGER_template field_start__mode;
BITSTRING_template field_codec__modes;
OCTETSTRING_template field_parameters;
};

void RSL__IE__MultirateCfg_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_len = ANY_VALUE;
single_value->field_mr__speech__ver = ANY_VALUE;
single_value->field_nscb = ANY_VALUE;
single_value->field_icmi = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
single_value->field_start__mode = ANY_VALUE;
single_value->field_codec__modes = ANY_VALUE;
single_value->field_parameters = ANY_VALUE;
}
}
}

void RSL__IE__MultirateCfg_template::copy_value(const RSL__IE__MultirateCfg& other_value)
{
single_value = new single_value_struct;
if (other_value.len().is_bound()) {
  single_value->field_len = other_value.len();
} else {
  single_value->field_len.clean_up();
}
if (other_value.mr__speech__ver().is_bound()) {
  single_value->field_mr__speech__ver = other_value.mr__speech__ver();
} else {
  single_value->field_mr__speech__ver.clean_up();
}
if (other_value.nscb().is_bound()) {
  single_value->field_nscb = other_value.nscb();
} else {
  single_value->field_nscb.clean_up();
}
if (other_value.icmi().is_bound()) {
  single_value->field_icmi = other_value.icmi();
} else {
  single_value->field_icmi.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.start__mode().is_bound()) {
  single_value->field_start__mode = other_value.start__mode();
} else {
  single_value->field_start__mode.clean_up();
}
if (other_value.codec__modes().is_bound()) {
  single_value->field_codec__modes = other_value.codec__modes();
} else {
  single_value->field_codec__modes.clean_up();
}
if (other_value.parameters().is_bound()) {
  single_value->field_parameters = other_value.parameters();
} else {
  single_value->field_parameters.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__MultirateCfg_template::copy_template(const RSL__IE__MultirateCfg_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.len().get_selection()) {
single_value->field_len = other_value.len();
} else {
single_value->field_len.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mr__speech__ver().get_selection()) {
single_value->field_mr__speech__ver = other_value.mr__speech__ver();
} else {
single_value->field_mr__speech__ver.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nscb().get_selection()) {
single_value->field_nscb = other_value.nscb();
} else {
single_value->field_nscb.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.icmi().get_selection()) {
single_value->field_icmi = other_value.icmi();
} else {
single_value->field_icmi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.start__mode().get_selection()) {
single_value->field_start__mode = other_value.start__mode();
} else {
single_value->field_start__mode.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.codec__modes().get_selection()) {
single_value->field_codec__modes = other_value.codec__modes();
} else {
single_value->field_codec__modes.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.parameters().get_selection()) {
single_value->field_parameters = other_value.parameters();
} else {
single_value->field_parameters.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__MultirateCfg_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__MultirateCfg_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__MultirateCfg_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_MultirateCfg.");
break;
}
set_selection(other_value);
}

RSL__IE__MultirateCfg_template::RSL__IE__MultirateCfg_template()
{
}

RSL__IE__MultirateCfg_template::RSL__IE__MultirateCfg_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__MultirateCfg_template::RSL__IE__MultirateCfg_template(const RSL__IE__MultirateCfg& other_value)
{
copy_value(other_value);
}

RSL__IE__MultirateCfg_template::RSL__IE__MultirateCfg_template(const OPTIONAL<RSL__IE__MultirateCfg>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__MultirateCfg&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_MultirateCfg from an unbound optional field.");
}
}

RSL__IE__MultirateCfg_template::RSL__IE__MultirateCfg_template(RSL__IE__MultirateCfg_template* p_precondition, RSL__IE__MultirateCfg_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__MultirateCfg_template::RSL__IE__MultirateCfg_template(Dynamic_Match_Interface<RSL__IE__MultirateCfg>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__MultirateCfg>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__MultirateCfg_template::RSL__IE__MultirateCfg_template(const RSL__IE__MultirateCfg_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__MultirateCfg_template::~RSL__IE__MultirateCfg_template()
{
clean_up();
}

RSL__IE__MultirateCfg_template& RSL__IE__MultirateCfg_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__MultirateCfg_template& RSL__IE__MultirateCfg_template::operator=(const RSL__IE__MultirateCfg& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__MultirateCfg_template& RSL__IE__MultirateCfg_template::operator=(const OPTIONAL<RSL__IE__MultirateCfg>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__MultirateCfg&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_MultirateCfg.");
}
return *this;
}

RSL__IE__MultirateCfg_template& RSL__IE__MultirateCfg_template::operator=(const RSL__IE__MultirateCfg_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__MultirateCfg_template::match(const RSL__IE__MultirateCfg& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.len().is_bound()) return FALSE;
if(!single_value->field_len.match(other_value.len(), legacy))return FALSE;
if(!other_value.mr__speech__ver().is_bound()) return FALSE;
if(!single_value->field_mr__speech__ver.match(other_value.mr__speech__ver(), legacy))return FALSE;
if(!other_value.nscb().is_bound()) return FALSE;
if(!single_value->field_nscb.match(other_value.nscb(), legacy))return FALSE;
if(!other_value.icmi().is_bound()) return FALSE;
if(!single_value->field_icmi.match(other_value.icmi(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.start__mode().is_bound()) return FALSE;
if(!single_value->field_start__mode.match(other_value.start__mode(), legacy))return FALSE;
if(!other_value.codec__modes().is_bound()) return FALSE;
if(!single_value->field_codec__modes.match(other_value.codec__modes(), legacy))return FALSE;
if(!other_value.parameters().is_bound()) return FALSE;
if(!single_value->field_parameters.match(other_value.parameters(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_MultirateCfg.");
}
return FALSE;
}

boolean RSL__IE__MultirateCfg_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_len.is_bound()
 || single_value->field_mr__speech__ver.is_bound()
 || single_value->field_nscb.is_bound()
 || single_value->field_icmi.is_bound()
 || single_value->field_spare.is_bound()
 || single_value->field_start__mode.is_bound()
 || single_value->field_codec__modes.is_bound()
 || single_value->field_parameters.is_bound();
}

boolean RSL__IE__MultirateCfg_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_len.is_value()
 && single_value->field_mr__speech__ver.is_value()
 && single_value->field_nscb.is_value()
 && single_value->field_icmi.is_value()
 && single_value->field_spare.is_value()
 && single_value->field_start__mode.is_value()
 && single_value->field_codec__modes.is_value()
 && single_value->field_parameters.is_value();
}

void RSL__IE__MultirateCfg_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__MultirateCfg RSL__IE__MultirateCfg_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_MultirateCfg.");
RSL__IE__MultirateCfg ret_val;
if (single_value->field_len.is_bound()) {
ret_val.len() = single_value->field_len.valueof();
}
if (single_value->field_mr__speech__ver.is_bound()) {
ret_val.mr__speech__ver() = single_value->field_mr__speech__ver.valueof();
}
if (single_value->field_nscb.is_bound()) {
ret_val.nscb() = single_value->field_nscb.valueof();
}
if (single_value->field_icmi.is_bound()) {
ret_val.icmi() = single_value->field_icmi.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_start__mode.is_bound()) {
ret_val.start__mode() = single_value->field_start__mode.valueof();
}
if (single_value->field_codec__modes.is_bound()) {
ret_val.codec__modes() = single_value->field_codec__modes.valueof();
}
if (single_value->field_parameters.is_bound()) {
ret_val.parameters() = single_value->field_parameters.valueof();
}
return ret_val;
}

void RSL__IE__MultirateCfg_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_MultirateCfg.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__MultirateCfg_template[list_length];
}

RSL__IE__MultirateCfg_template& RSL__IE__MultirateCfg_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_MultirateCfg.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_MultirateCfg.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__MultirateCfg_template::len()
{
set_specific();
return single_value->field_len;
}

const INTEGER_template& RSL__IE__MultirateCfg_template::len() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len of a non-specific template of type @RSL_Types.RSL_IE_MultirateCfg.");
return single_value->field_len;
}

INTEGER_template& RSL__IE__MultirateCfg_template::mr__speech__ver()
{
set_specific();
return single_value->field_mr__speech__ver;
}

const INTEGER_template& RSL__IE__MultirateCfg_template::mr__speech__ver() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mr_speech_ver of a non-specific template of type @RSL_Types.RSL_IE_MultirateCfg.");
return single_value->field_mr__speech__ver;
}

BOOLEAN_template& RSL__IE__MultirateCfg_template::nscb()
{
set_specific();
return single_value->field_nscb;
}

const BOOLEAN_template& RSL__IE__MultirateCfg_template::nscb() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nscb of a non-specific template of type @RSL_Types.RSL_IE_MultirateCfg.");
return single_value->field_nscb;
}

BOOLEAN_template& RSL__IE__MultirateCfg_template::icmi()
{
set_specific();
return single_value->field_icmi;
}

const BOOLEAN_template& RSL__IE__MultirateCfg_template::icmi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field icmi of a non-specific template of type @RSL_Types.RSL_IE_MultirateCfg.");
return single_value->field_icmi;
}

BITSTRING_template& RSL__IE__MultirateCfg_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& RSL__IE__MultirateCfg_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @RSL_Types.RSL_IE_MultirateCfg.");
return single_value->field_spare;
}

INTEGER_template& RSL__IE__MultirateCfg_template::start__mode()
{
set_specific();
return single_value->field_start__mode;
}

const INTEGER_template& RSL__IE__MultirateCfg_template::start__mode() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field start_mode of a non-specific template of type @RSL_Types.RSL_IE_MultirateCfg.");
return single_value->field_start__mode;
}

BITSTRING_template& RSL__IE__MultirateCfg_template::codec__modes()
{
set_specific();
return single_value->field_codec__modes;
}

const BITSTRING_template& RSL__IE__MultirateCfg_template::codec__modes() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field codec_modes of a non-specific template of type @RSL_Types.RSL_IE_MultirateCfg.");
return single_value->field_codec__modes;
}

OCTETSTRING_template& RSL__IE__MultirateCfg_template::parameters()
{
set_specific();
return single_value->field_parameters;
}

const OCTETSTRING_template& RSL__IE__MultirateCfg_template::parameters() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field parameters of a non-specific template of type @RSL_Types.RSL_IE_MultirateCfg.");
return single_value->field_parameters;
}

int RSL__IE__MultirateCfg_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCfg which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 8;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCfg containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCfg containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCfg containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCfg containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCfg containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCfg containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCfg containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCfg containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_MultirateCfg.");
  }
  return 0;
}

void RSL__IE__MultirateCfg_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log();
TTCN_Logger::log_event_str(", mr_speech_ver := ");
single_value->field_mr__speech__ver.log();
TTCN_Logger::log_event_str(", nscb := ");
single_value->field_nscb.log();
TTCN_Logger::log_event_str(", icmi := ");
single_value->field_icmi.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", start_mode := ");
single_value->field_start__mode.log();
TTCN_Logger::log_event_str(", codec_modes := ");
single_value->field_codec__modes.log();
TTCN_Logger::log_event_str(", parameters := ");
single_value->field_parameters.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__MultirateCfg_template::log_match(const RSL__IE__MultirateCfg& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_len.match(match_value.len(), legacy)){
TTCN_Logger::log_logmatch_info(".len");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_mr__speech__ver.match(match_value.mr__speech__ver(), legacy)){
TTCN_Logger::log_logmatch_info(".mr_speech_ver");
single_value->field_mr__speech__ver.log_match(match_value.mr__speech__ver(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nscb.match(match_value.nscb(), legacy)){
TTCN_Logger::log_logmatch_info(".nscb");
single_value->field_nscb.log_match(match_value.nscb(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_icmi.match(match_value.icmi(), legacy)){
TTCN_Logger::log_logmatch_info(".icmi");
single_value->field_icmi.log_match(match_value.icmi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_start__mode.match(match_value.start__mode(), legacy)){
TTCN_Logger::log_logmatch_info(".start_mode");
single_value->field_start__mode.log_match(match_value.start__mode(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_codec__modes.match(match_value.codec__modes(), legacy)){
TTCN_Logger::log_logmatch_info(".codec_modes");
single_value->field_codec__modes.log_match(match_value.codec__modes(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_parameters.match(match_value.parameters(), legacy)){
TTCN_Logger::log_logmatch_info(".parameters");
single_value->field_parameters.log_match(match_value.parameters(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::log_event_str(", mr_speech_ver := ");
single_value->field_mr__speech__ver.log_match(match_value.mr__speech__ver(), legacy);
TTCN_Logger::log_event_str(", nscb := ");
single_value->field_nscb.log_match(match_value.nscb(), legacy);
TTCN_Logger::log_event_str(", icmi := ");
single_value->field_icmi.log_match(match_value.icmi(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", start_mode := ");
single_value->field_start__mode.log_match(match_value.start__mode(), legacy);
TTCN_Logger::log_event_str(", codec_modes := ");
single_value->field_codec__modes.log_match(match_value.codec__modes(), legacy);
TTCN_Logger::log_event_str(", parameters := ");
single_value->field_parameters.log_match(match_value.parameters(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__MultirateCfg_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (len().is_bound()) len().set_implicit_omit();
if (mr__speech__ver().is_bound()) mr__speech__ver().set_implicit_omit();
if (nscb().is_bound()) nscb().set_implicit_omit();
if (icmi().is_bound()) icmi().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (start__mode().is_bound()) start__mode().set_implicit_omit();
if (codec__modes().is_bound()) codec__modes().set_implicit_omit();
if (parameters().is_bound()) parameters().set_implicit_omit();
}

void RSL__IE__MultirateCfg_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_len.encode_text(text_buf);
single_value->field_mr__speech__ver.encode_text(text_buf);
single_value->field_nscb.encode_text(text_buf);
single_value->field_icmi.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
single_value->field_start__mode.encode_text(text_buf);
single_value->field_codec__modes.encode_text(text_buf);
single_value->field_parameters.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_MultirateCfg.");
}
}

void RSL__IE__MultirateCfg_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_len.decode_text(text_buf);
single_value->field_mr__speech__ver.decode_text(text_buf);
single_value->field_nscb.decode_text(text_buf);
single_value->field_icmi.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
single_value->field_start__mode.decode_text(text_buf);
single_value->field_codec__modes.decode_text(text_buf);
single_value->field_parameters.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__MultirateCfg_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_MultirateCfg.");
}
}

void RSL__IE__MultirateCfg_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__MultirateCfg_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_MultirateCfg has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) mr__speech__ver().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) nscb().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) icmi().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) start__mode().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) codec__modes().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) parameters().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mr_speech_ver")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mr__speech__ver().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nscb")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nscb().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "icmi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          icmi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "start_mode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          start__mode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "codec_modes")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          codec__modes().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "parameters")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          parameters().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_MultirateCfg: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__MultirateCfg_template* precondition = new RSL__IE__MultirateCfg_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__MultirateCfg_template* implied_template = new RSL__IE__MultirateCfg_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__MultirateCfg_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_MultirateCfg");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__MultirateCfg_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_len.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCfg");
single_value->field_mr__speech__ver.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCfg");
single_value->field_nscb.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCfg");
single_value->field_icmi.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCfg");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCfg");
single_value->field_start__mode.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCfg");
single_value->field_codec__modes.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCfg");
single_value->field_parameters.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCfg");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCfg");
}

boolean RSL__IE__MultirateCfg_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__MultirateCfg_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IE__MultirateCtrl::RSL__IE__MultirateCtrl()
{
}

RSL__IE__MultirateCtrl::RSL__IE__MultirateCtrl(const INTEGER& par_spare,
    const BOOLEAN& par_od,
    const BOOLEAN& par_pre,
    const INTEGER& par_rae,
    const BOOLEAN& par_tfo)
  :   field_spare(par_spare),
  field_od(par_od),
  field_pre(par_pre),
  field_rae(par_rae),
  field_tfo(par_tfo)
{
}

RSL__IE__MultirateCtrl::RSL__IE__MultirateCtrl(const RSL__IE__MultirateCtrl& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_MultirateCtrl.");
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.od().is_bound()) field_od = other_value.od();
else field_od.clean_up();
if (other_value.pre().is_bound()) field_pre = other_value.pre();
else field_pre.clean_up();
if (other_value.rae().is_bound()) field_rae = other_value.rae();
else field_rae.clean_up();
if (other_value.tfo().is_bound()) field_tfo = other_value.tfo();
else field_tfo.clean_up();
}

void RSL__IE__MultirateCtrl::clean_up()
{
field_spare.clean_up();
field_od.clean_up();
field_pre.clean_up();
field_rae.clean_up();
field_tfo.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__MultirateCtrl::get_descriptor() const { return &RSL__IE__MultirateCtrl_descr_; }
RSL__IE__MultirateCtrl& RSL__IE__MultirateCtrl::operator=(const RSL__IE__MultirateCtrl& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_MultirateCtrl.");
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.od().is_bound()) field_od = other_value.od();
  else field_od.clean_up();
  if (other_value.pre().is_bound()) field_pre = other_value.pre();
  else field_pre.clean_up();
  if (other_value.rae().is_bound()) field_rae = other_value.rae();
  else field_rae.clean_up();
  if (other_value.tfo().is_bound()) field_tfo = other_value.tfo();
  else field_tfo.clean_up();
}
return *this;
}

boolean RSL__IE__MultirateCtrl::operator==(const RSL__IE__MultirateCtrl& other_value) const
{
return field_spare==other_value.field_spare
  && field_od==other_value.field_od
  && field_pre==other_value.field_pre
  && field_rae==other_value.field_rae
  && field_tfo==other_value.field_tfo;
}

boolean RSL__IE__MultirateCtrl::is_bound() const
{
return (field_spare.is_bound())
  || (field_od.is_bound())
  || (field_pre.is_bound())
  || (field_rae.is_bound())
  || (field_tfo.is_bound());
}
boolean RSL__IE__MultirateCtrl::is_value() const
{
return field_spare.is_value()
  && field_od.is_value()
  && field_pre.is_value()
  && field_rae.is_value()
  && field_tfo.is_value();
}
void RSL__IE__MultirateCtrl::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", od := ");
field_od.log();
TTCN_Logger::log_event_str(", pre := ");
field_pre.log();
TTCN_Logger::log_event_str(", rae := ");
field_rae.log();
TTCN_Logger::log_event_str(", tfo := ");
field_tfo.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__MultirateCtrl::set_implicit_omit()
{
if (spare().is_bound()) spare().set_implicit_omit();
if (od().is_bound()) od().set_implicit_omit();
if (pre().is_bound()) pre().set_implicit_omit();
if (rae().is_bound()) rae().set_implicit_omit();
if (tfo().is_bound()) tfo().set_implicit_omit();
}

void RSL__IE__MultirateCtrl::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_MultirateCtrl has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) od().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) pre().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rae().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) tfo().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "od")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          od().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pre")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pre().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rae")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rae().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tfo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tfo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_MultirateCtrl: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_MultirateCtrl");
  }
}

void RSL__IE__MultirateCtrl::encode_text(Text_Buf& text_buf) const
{
field_spare.encode_text(text_buf);
field_od.encode_text(text_buf);
field_pre.encode_text(text_buf);
field_rae.encode_text(text_buf);
field_tfo.encode_text(text_buf);
}

void RSL__IE__MultirateCtrl::decode_text(Text_Buf& text_buf)
{
field_spare.decode_text(text_buf);
field_od.decode_text(text_buf);
field_pre.decode_text(text_buf);
field_rae.decode_text(text_buf);
field_tfo.decode_text(text_buf);
}

void RSL__IE__MultirateCtrl::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__MultirateCtrl::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__MultirateCtrl::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__MultirateCtrl_spare_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(RSL__IE__MultirateCtrl_spare_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__MultirateCtrl_od_descr_.raw->forceomit);
  decoded_field_length = field_od.RAW_decode(RSL__IE__MultirateCtrl_od_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, RSL__IE__MultirateCtrl_pre_descr_.raw->forceomit);
  decoded_field_length = field_pre.RAW_decode(RSL__IE__MultirateCtrl_pre_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, RSL__IE__MultirateCtrl_rae_descr_.raw->forceomit);
  decoded_field_length = field_rae.RAW_decode(RSL__IE__MultirateCtrl_rae_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_4_force_omit(4, force_omit, RSL__IE__MultirateCtrl_tfo_descr_.raw->forceomit);
  decoded_field_length = field_tfo.RAW_decode(RSL__IE__MultirateCtrl_tfo_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__MultirateCtrl::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__MultirateCtrl_spare_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__MultirateCtrl_od_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RSL__IE__MultirateCtrl_pre_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, RSL__IE__MultirateCtrl_rae_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, RSL__IE__MultirateCtrl_tfo_descr_.raw);
  encoded_length += field_spare.RAW_encode(RSL__IE__MultirateCtrl_spare_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_od.RAW_encode(RSL__IE__MultirateCtrl_od_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_pre.RAW_encode(RSL__IE__MultirateCtrl_pre_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_rae.RAW_encode(RSL__IE__MultirateCtrl_rae_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_tfo.RAW_encode(RSL__IE__MultirateCtrl_tfo_descr_, *myleaf.body.node.nodes[4]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__MultirateCtrl_template::single_value_struct {
INTEGER_template field_spare;
BOOLEAN_template field_od;
BOOLEAN_template field_pre;
INTEGER_template field_rae;
BOOLEAN_template field_tfo;
};

void RSL__IE__MultirateCtrl_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_spare = ANY_VALUE;
single_value->field_od = ANY_VALUE;
single_value->field_pre = ANY_VALUE;
single_value->field_rae = ANY_VALUE;
single_value->field_tfo = ANY_VALUE;
}
}
}

void RSL__IE__MultirateCtrl_template::copy_value(const RSL__IE__MultirateCtrl& other_value)
{
single_value = new single_value_struct;
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.od().is_bound()) {
  single_value->field_od = other_value.od();
} else {
  single_value->field_od.clean_up();
}
if (other_value.pre().is_bound()) {
  single_value->field_pre = other_value.pre();
} else {
  single_value->field_pre.clean_up();
}
if (other_value.rae().is_bound()) {
  single_value->field_rae = other_value.rae();
} else {
  single_value->field_rae.clean_up();
}
if (other_value.tfo().is_bound()) {
  single_value->field_tfo = other_value.tfo();
} else {
  single_value->field_tfo.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__MultirateCtrl_template::copy_template(const RSL__IE__MultirateCtrl_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.od().get_selection()) {
single_value->field_od = other_value.od();
} else {
single_value->field_od.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pre().get_selection()) {
single_value->field_pre = other_value.pre();
} else {
single_value->field_pre.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rae().get_selection()) {
single_value->field_rae = other_value.rae();
} else {
single_value->field_rae.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tfo().get_selection()) {
single_value->field_tfo = other_value.tfo();
} else {
single_value->field_tfo.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__MultirateCtrl_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__MultirateCtrl_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__MultirateCtrl_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_MultirateCtrl.");
break;
}
set_selection(other_value);
}

RSL__IE__MultirateCtrl_template::RSL__IE__MultirateCtrl_template()
{
}

RSL__IE__MultirateCtrl_template::RSL__IE__MultirateCtrl_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__MultirateCtrl_template::RSL__IE__MultirateCtrl_template(const RSL__IE__MultirateCtrl& other_value)
{
copy_value(other_value);
}

RSL__IE__MultirateCtrl_template::RSL__IE__MultirateCtrl_template(const OPTIONAL<RSL__IE__MultirateCtrl>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__MultirateCtrl&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_MultirateCtrl from an unbound optional field.");
}
}

RSL__IE__MultirateCtrl_template::RSL__IE__MultirateCtrl_template(RSL__IE__MultirateCtrl_template* p_precondition, RSL__IE__MultirateCtrl_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__MultirateCtrl_template::RSL__IE__MultirateCtrl_template(Dynamic_Match_Interface<RSL__IE__MultirateCtrl>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__MultirateCtrl>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__MultirateCtrl_template::RSL__IE__MultirateCtrl_template(const RSL__IE__MultirateCtrl_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__MultirateCtrl_template::~RSL__IE__MultirateCtrl_template()
{
clean_up();
}

RSL__IE__MultirateCtrl_template& RSL__IE__MultirateCtrl_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__MultirateCtrl_template& RSL__IE__MultirateCtrl_template::operator=(const RSL__IE__MultirateCtrl& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__MultirateCtrl_template& RSL__IE__MultirateCtrl_template::operator=(const OPTIONAL<RSL__IE__MultirateCtrl>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__MultirateCtrl&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_MultirateCtrl.");
}
return *this;
}

RSL__IE__MultirateCtrl_template& RSL__IE__MultirateCtrl_template::operator=(const RSL__IE__MultirateCtrl_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__MultirateCtrl_template::match(const RSL__IE__MultirateCtrl& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.od().is_bound()) return FALSE;
if(!single_value->field_od.match(other_value.od(), legacy))return FALSE;
if(!other_value.pre().is_bound()) return FALSE;
if(!single_value->field_pre.match(other_value.pre(), legacy))return FALSE;
if(!other_value.rae().is_bound()) return FALSE;
if(!single_value->field_rae.match(other_value.rae(), legacy))return FALSE;
if(!other_value.tfo().is_bound()) return FALSE;
if(!single_value->field_tfo.match(other_value.tfo(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_MultirateCtrl.");
}
return FALSE;
}

boolean RSL__IE__MultirateCtrl_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_spare.is_bound()
 || single_value->field_od.is_bound()
 || single_value->field_pre.is_bound()
 || single_value->field_rae.is_bound()
 || single_value->field_tfo.is_bound();
}

boolean RSL__IE__MultirateCtrl_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_spare.is_value()
 && single_value->field_od.is_value()
 && single_value->field_pre.is_value()
 && single_value->field_rae.is_value()
 && single_value->field_tfo.is_value();
}

void RSL__IE__MultirateCtrl_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__MultirateCtrl RSL__IE__MultirateCtrl_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_MultirateCtrl.");
RSL__IE__MultirateCtrl ret_val;
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_od.is_bound()) {
ret_val.od() = single_value->field_od.valueof();
}
if (single_value->field_pre.is_bound()) {
ret_val.pre() = single_value->field_pre.valueof();
}
if (single_value->field_rae.is_bound()) {
ret_val.rae() = single_value->field_rae.valueof();
}
if (single_value->field_tfo.is_bound()) {
ret_val.tfo() = single_value->field_tfo.valueof();
}
return ret_val;
}

void RSL__IE__MultirateCtrl_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_MultirateCtrl.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__MultirateCtrl_template[list_length];
}

RSL__IE__MultirateCtrl_template& RSL__IE__MultirateCtrl_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_MultirateCtrl.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_MultirateCtrl.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__MultirateCtrl_template::spare()
{
set_specific();
return single_value->field_spare;
}

const INTEGER_template& RSL__IE__MultirateCtrl_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @RSL_Types.RSL_IE_MultirateCtrl.");
return single_value->field_spare;
}

BOOLEAN_template& RSL__IE__MultirateCtrl_template::od()
{
set_specific();
return single_value->field_od;
}

const BOOLEAN_template& RSL__IE__MultirateCtrl_template::od() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field od of a non-specific template of type @RSL_Types.RSL_IE_MultirateCtrl.");
return single_value->field_od;
}

BOOLEAN_template& RSL__IE__MultirateCtrl_template::pre()
{
set_specific();
return single_value->field_pre;
}

const BOOLEAN_template& RSL__IE__MultirateCtrl_template::pre() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pre of a non-specific template of type @RSL_Types.RSL_IE_MultirateCtrl.");
return single_value->field_pre;
}

INTEGER_template& RSL__IE__MultirateCtrl_template::rae()
{
set_specific();
return single_value->field_rae;
}

const INTEGER_template& RSL__IE__MultirateCtrl_template::rae() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rae of a non-specific template of type @RSL_Types.RSL_IE_MultirateCtrl.");
return single_value->field_rae;
}

BOOLEAN_template& RSL__IE__MultirateCtrl_template::tfo()
{
set_specific();
return single_value->field_tfo;
}

const BOOLEAN_template& RSL__IE__MultirateCtrl_template::tfo() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tfo of a non-specific template of type @RSL_Types.RSL_IE_MultirateCtrl.");
return single_value->field_tfo;
}

int RSL__IE__MultirateCtrl_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCtrl which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCtrl containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCtrl containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCtrl containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCtrl containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCtrl containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCtrl containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCtrl containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCtrl containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_MultirateCtrl.");
  }
  return 0;
}

void RSL__IE__MultirateCtrl_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", od := ");
single_value->field_od.log();
TTCN_Logger::log_event_str(", pre := ");
single_value->field_pre.log();
TTCN_Logger::log_event_str(", rae := ");
single_value->field_rae.log();
TTCN_Logger::log_event_str(", tfo := ");
single_value->field_tfo.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__MultirateCtrl_template::log_match(const RSL__IE__MultirateCtrl& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_od.match(match_value.od(), legacy)){
TTCN_Logger::log_logmatch_info(".od");
single_value->field_od.log_match(match_value.od(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_pre.match(match_value.pre(), legacy)){
TTCN_Logger::log_logmatch_info(".pre");
single_value->field_pre.log_match(match_value.pre(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rae.match(match_value.rae(), legacy)){
TTCN_Logger::log_logmatch_info(".rae");
single_value->field_rae.log_match(match_value.rae(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_tfo.match(match_value.tfo(), legacy)){
TTCN_Logger::log_logmatch_info(".tfo");
single_value->field_tfo.log_match(match_value.tfo(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", od := ");
single_value->field_od.log_match(match_value.od(), legacy);
TTCN_Logger::log_event_str(", pre := ");
single_value->field_pre.log_match(match_value.pre(), legacy);
TTCN_Logger::log_event_str(", rae := ");
single_value->field_rae.log_match(match_value.rae(), legacy);
TTCN_Logger::log_event_str(", tfo := ");
single_value->field_tfo.log_match(match_value.tfo(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__MultirateCtrl_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (spare().is_bound()) spare().set_implicit_omit();
if (od().is_bound()) od().set_implicit_omit();
if (pre().is_bound()) pre().set_implicit_omit();
if (rae().is_bound()) rae().set_implicit_omit();
if (tfo().is_bound()) tfo().set_implicit_omit();
}

void RSL__IE__MultirateCtrl_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_spare.encode_text(text_buf);
single_value->field_od.encode_text(text_buf);
single_value->field_pre.encode_text(text_buf);
single_value->field_rae.encode_text(text_buf);
single_value->field_tfo.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_MultirateCtrl.");
}
}

void RSL__IE__MultirateCtrl_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_spare.decode_text(text_buf);
single_value->field_od.decode_text(text_buf);
single_value->field_pre.decode_text(text_buf);
single_value->field_rae.decode_text(text_buf);
single_value->field_tfo.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__MultirateCtrl_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_MultirateCtrl.");
}
}

void RSL__IE__MultirateCtrl_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__MultirateCtrl_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_MultirateCtrl has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) od().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) pre().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rae().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) tfo().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "od")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          od().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pre")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pre().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rae")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rae().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tfo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tfo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_MultirateCtrl: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__MultirateCtrl_template* precondition = new RSL__IE__MultirateCtrl_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__MultirateCtrl_template* implied_template = new RSL__IE__MultirateCtrl_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__MultirateCtrl_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_MultirateCtrl");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__MultirateCtrl_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCtrl");
single_value->field_od.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCtrl");
single_value->field_pre.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCtrl");
single_value->field_rae.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCtrl");
single_value->field_tfo.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCtrl");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCtrl");
}

boolean RSL__IE__MultirateCtrl_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__MultirateCtrl_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IE__IPA__ConnectionStats::RSL__IE__IPA__ConnectionStats()
{
}

RSL__IE__IPA__ConnectionStats::RSL__IE__IPA__ConnectionStats(const INTEGER& par_len,
    const INTEGER& par_tx__packets,
    const INTEGER& par_tx__octets,
    const INTEGER& par_rx__packets,
    const INTEGER& par_rx__octets,
    const INTEGER& par_lost__packets,
    const INTEGER& par_jitter,
    const INTEGER& par_avg__delay)
  :   field_len(par_len),
  field_tx__packets(par_tx__packets),
  field_tx__octets(par_tx__octets),
  field_rx__packets(par_rx__packets),
  field_rx__octets(par_rx__octets),
  field_lost__packets(par_lost__packets),
  field_jitter(par_jitter),
  field_avg__delay(par_avg__delay)
{
}

RSL__IE__IPA__ConnectionStats::RSL__IE__IPA__ConnectionStats(const RSL__IE__IPA__ConnectionStats& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.tx__packets().is_bound()) field_tx__packets = other_value.tx__packets();
else field_tx__packets.clean_up();
if (other_value.tx__octets().is_bound()) field_tx__octets = other_value.tx__octets();
else field_tx__octets.clean_up();
if (other_value.rx__packets().is_bound()) field_rx__packets = other_value.rx__packets();
else field_rx__packets.clean_up();
if (other_value.rx__octets().is_bound()) field_rx__octets = other_value.rx__octets();
else field_rx__octets.clean_up();
if (other_value.lost__packets().is_bound()) field_lost__packets = other_value.lost__packets();
else field_lost__packets.clean_up();
if (other_value.jitter().is_bound()) field_jitter = other_value.jitter();
else field_jitter.clean_up();
if (other_value.avg__delay().is_bound()) field_avg__delay = other_value.avg__delay();
else field_avg__delay.clean_up();
}

void RSL__IE__IPA__ConnectionStats::clean_up()
{
field_len.clean_up();
field_tx__packets.clean_up();
field_tx__octets.clean_up();
field_rx__packets.clean_up();
field_rx__octets.clean_up();
field_lost__packets.clean_up();
field_jitter.clean_up();
field_avg__delay.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__IPA__ConnectionStats::get_descriptor() const { return &RSL__IE__IPA__ConnectionStats_descr_; }
RSL__IE__IPA__ConnectionStats& RSL__IE__IPA__ConnectionStats::operator=(const RSL__IE__IPA__ConnectionStats& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.tx__packets().is_bound()) field_tx__packets = other_value.tx__packets();
  else field_tx__packets.clean_up();
  if (other_value.tx__octets().is_bound()) field_tx__octets = other_value.tx__octets();
  else field_tx__octets.clean_up();
  if (other_value.rx__packets().is_bound()) field_rx__packets = other_value.rx__packets();
  else field_rx__packets.clean_up();
  if (other_value.rx__octets().is_bound()) field_rx__octets = other_value.rx__octets();
  else field_rx__octets.clean_up();
  if (other_value.lost__packets().is_bound()) field_lost__packets = other_value.lost__packets();
  else field_lost__packets.clean_up();
  if (other_value.jitter().is_bound()) field_jitter = other_value.jitter();
  else field_jitter.clean_up();
  if (other_value.avg__delay().is_bound()) field_avg__delay = other_value.avg__delay();
  else field_avg__delay.clean_up();
}
return *this;
}

boolean RSL__IE__IPA__ConnectionStats::operator==(const RSL__IE__IPA__ConnectionStats& other_value) const
{
return field_len==other_value.field_len
  && field_tx__packets==other_value.field_tx__packets
  && field_tx__octets==other_value.field_tx__octets
  && field_rx__packets==other_value.field_rx__packets
  && field_rx__octets==other_value.field_rx__octets
  && field_lost__packets==other_value.field_lost__packets
  && field_jitter==other_value.field_jitter
  && field_avg__delay==other_value.field_avg__delay;
}

boolean RSL__IE__IPA__ConnectionStats::is_bound() const
{
return (field_len.is_bound())
  || (field_tx__packets.is_bound())
  || (field_tx__octets.is_bound())
  || (field_rx__packets.is_bound())
  || (field_rx__octets.is_bound())
  || (field_lost__packets.is_bound())
  || (field_jitter.is_bound())
  || (field_avg__delay.is_bound());
}
boolean RSL__IE__IPA__ConnectionStats::is_value() const
{
return field_len.is_value()
  && field_tx__packets.is_value()
  && field_tx__octets.is_value()
  && field_rx__packets.is_value()
  && field_rx__octets.is_value()
  && field_lost__packets.is_value()
  && field_jitter.is_value()
  && field_avg__delay.is_value();
}
void RSL__IE__IPA__ConnectionStats::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len := ");
field_len.log();
TTCN_Logger::log_event_str(", tx_packets := ");
field_tx__packets.log();
TTCN_Logger::log_event_str(", tx_octets := ");
field_tx__octets.log();
TTCN_Logger::log_event_str(", rx_packets := ");
field_rx__packets.log();
TTCN_Logger::log_event_str(", rx_octets := ");
field_rx__octets.log();
TTCN_Logger::log_event_str(", lost_packets := ");
field_lost__packets.log();
TTCN_Logger::log_event_str(", jitter := ");
field_jitter.log();
TTCN_Logger::log_event_str(", avg_delay := ");
field_avg__delay.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__IPA__ConnectionStats::set_implicit_omit()
{
if (len().is_bound()) len().set_implicit_omit();
if (tx__packets().is_bound()) tx__packets().set_implicit_omit();
if (tx__octets().is_bound()) tx__octets().set_implicit_omit();
if (rx__packets().is_bound()) rx__packets().set_implicit_omit();
if (rx__octets().is_bound()) rx__octets().set_implicit_omit();
if (lost__packets().is_bound()) lost__packets().set_implicit_omit();
if (jitter().is_bound()) jitter().set_implicit_omit();
if (avg__delay().is_bound()) avg__delay().set_implicit_omit();
}

void RSL__IE__IPA__ConnectionStats::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_IPA_ConnectionStats has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) tx__packets().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) tx__octets().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rx__packets().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) rx__octets().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) lost__packets().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) jitter().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) avg__delay().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tx_packets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tx__packets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tx_octets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tx__octets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rx_packets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rx__packets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rx_octets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rx__octets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lost_packets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lost__packets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "jitter")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          jitter().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "avg_delay")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          avg__delay().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_IPA_ConnectionStats: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_IPA_ConnectionStats");
  }
}

void RSL__IE__IPA__ConnectionStats::encode_text(Text_Buf& text_buf) const
{
field_len.encode_text(text_buf);
field_tx__packets.encode_text(text_buf);
field_tx__octets.encode_text(text_buf);
field_rx__packets.encode_text(text_buf);
field_rx__octets.encode_text(text_buf);
field_lost__packets.encode_text(text_buf);
field_jitter.encode_text(text_buf);
field_avg__delay.encode_text(text_buf);
}

void RSL__IE__IPA__ConnectionStats::decode_text(Text_Buf& text_buf)
{
field_len.decode_text(text_buf);
field_tx__packets.decode_text(text_buf);
field_tx__octets.decode_text(text_buf);
field_rx__packets.decode_text(text_buf);
field_rx__octets.decode_text(text_buf);
field_lost__packets.decode_text(text_buf);
field_jitter.decode_text(text_buf);
field_avg__delay.decode_text(text_buf);
}

void RSL__IE__IPA__ConnectionStats::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__IPA__ConnectionStats::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__IPA__ConnectionStats::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__IPA__ConnectionStats_len_descr_.raw->forceomit);
  decoded_field_length = field_len.RAW_decode(RSL__IE__IPA__ConnectionStats_len_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_len.convert_to_Integer(RSL__IE__IPA__ConnectionStats_len_descr_);
  field_len = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__IPA__ConnectionStats_tx__packets_descr_.raw->forceomit);
  decoded_field_length = field_tx__packets.RAW_decode(RSL__IE__IPA__ConnectionStats_tx__packets_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RSL__IE__IPA__ConnectionStats_tx__octets_descr_.raw->forceomit);
  decoded_field_length = field_tx__octets.RAW_decode(RSL__IE__IPA__ConnectionStats_tx__octets_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, RSL__IE__IPA__ConnectionStats_rx__packets_descr_.raw->forceomit);
  decoded_field_length = field_rx__packets.RAW_decode(RSL__IE__IPA__ConnectionStats_rx__packets_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, RSL__IE__IPA__ConnectionStats_rx__octets_descr_.raw->forceomit);
  decoded_field_length = field_rx__octets.RAW_decode(RSL__IE__IPA__ConnectionStats_rx__octets_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_5_force_omit(5, force_omit, RSL__IE__IPA__ConnectionStats_lost__packets_descr_.raw->forceomit);
  decoded_field_length = field_lost__packets.RAW_decode(RSL__IE__IPA__ConnectionStats_lost__packets_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_6_force_omit(6, force_omit, RSL__IE__IPA__ConnectionStats_jitter_descr_.raw->forceomit);
  decoded_field_length = field_jitter.RAW_decode(RSL__IE__IPA__ConnectionStats_jitter_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_7_force_omit(7, force_omit, RSL__IE__IPA__ConnectionStats_avg__delay_descr_.raw->forceomit);
  decoded_field_length = field_avg__delay.RAW_decode(RSL__IE__IPA__ConnectionStats_avg__delay_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__IPA__ConnectionStats::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 8;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(8);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__IPA__ConnectionStats_len_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__IPA__ConnectionStats_tx__packets_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RSL__IE__IPA__ConnectionStats_tx__octets_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, RSL__IE__IPA__ConnectionStats_rx__packets_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, RSL__IE__IPA__ConnectionStats_rx__octets_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, RSL__IE__IPA__ConnectionStats_lost__packets_descr_.raw);
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, RSL__IE__IPA__ConnectionStats_jitter_descr_.raw);
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, RSL__IE__IPA__ConnectionStats_avg__delay_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &RSL__IE__IPA__ConnectionStats_len_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 7;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(7);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[4].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[4].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[5].level = myleaf.body.node.nodes[6]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[5].pos = myleaf.body.node.nodes[6]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[6].level = myleaf.body.node.nodes[7]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[6].pos = myleaf.body.node.nodes[7]->curr_pos.pos;
  encoded_length += field_tx__packets.RAW_encode(RSL__IE__IPA__ConnectionStats_tx__packets_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_tx__octets.RAW_encode(RSL__IE__IPA__ConnectionStats_tx__octets_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_rx__packets.RAW_encode(RSL__IE__IPA__ConnectionStats_rx__packets_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_rx__octets.RAW_encode(RSL__IE__IPA__ConnectionStats_rx__octets_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_lost__packets.RAW_encode(RSL__IE__IPA__ConnectionStats_lost__packets_descr_, *myleaf.body.node.nodes[5]);
  encoded_length += field_jitter.RAW_encode(RSL__IE__IPA__ConnectionStats_jitter_descr_, *myleaf.body.node.nodes[6]);
  encoded_length += field_avg__delay.RAW_encode(RSL__IE__IPA__ConnectionStats_avg__delay_descr_, *myleaf.body.node.nodes[7]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__IPA__ConnectionStats_template::single_value_struct {
INTEGER_template field_len;
INTEGER_template field_tx__packets;
INTEGER_template field_tx__octets;
INTEGER_template field_rx__packets;
INTEGER_template field_rx__octets;
INTEGER_template field_lost__packets;
INTEGER_template field_jitter;
INTEGER_template field_avg__delay;
};

void RSL__IE__IPA__ConnectionStats_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_len = ANY_VALUE;
single_value->field_tx__packets = ANY_VALUE;
single_value->field_tx__octets = ANY_VALUE;
single_value->field_rx__packets = ANY_VALUE;
single_value->field_rx__octets = ANY_VALUE;
single_value->field_lost__packets = ANY_VALUE;
single_value->field_jitter = ANY_VALUE;
single_value->field_avg__delay = ANY_VALUE;
}
}
}

void RSL__IE__IPA__ConnectionStats_template::copy_value(const RSL__IE__IPA__ConnectionStats& other_value)
{
single_value = new single_value_struct;
if (other_value.len().is_bound()) {
  single_value->field_len = other_value.len();
} else {
  single_value->field_len.clean_up();
}
if (other_value.tx__packets().is_bound()) {
  single_value->field_tx__packets = other_value.tx__packets();
} else {
  single_value->field_tx__packets.clean_up();
}
if (other_value.tx__octets().is_bound()) {
  single_value->field_tx__octets = other_value.tx__octets();
} else {
  single_value->field_tx__octets.clean_up();
}
if (other_value.rx__packets().is_bound()) {
  single_value->field_rx__packets = other_value.rx__packets();
} else {
  single_value->field_rx__packets.clean_up();
}
if (other_value.rx__octets().is_bound()) {
  single_value->field_rx__octets = other_value.rx__octets();
} else {
  single_value->field_rx__octets.clean_up();
}
if (other_value.lost__packets().is_bound()) {
  single_value->field_lost__packets = other_value.lost__packets();
} else {
  single_value->field_lost__packets.clean_up();
}
if (other_value.jitter().is_bound()) {
  single_value->field_jitter = other_value.jitter();
} else {
  single_value->field_jitter.clean_up();
}
if (other_value.avg__delay().is_bound()) {
  single_value->field_avg__delay = other_value.avg__delay();
} else {
  single_value->field_avg__delay.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__IPA__ConnectionStats_template::copy_template(const RSL__IE__IPA__ConnectionStats_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.len().get_selection()) {
single_value->field_len = other_value.len();
} else {
single_value->field_len.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tx__packets().get_selection()) {
single_value->field_tx__packets = other_value.tx__packets();
} else {
single_value->field_tx__packets.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tx__octets().get_selection()) {
single_value->field_tx__octets = other_value.tx__octets();
} else {
single_value->field_tx__octets.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rx__packets().get_selection()) {
single_value->field_rx__packets = other_value.rx__packets();
} else {
single_value->field_rx__packets.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rx__octets().get_selection()) {
single_value->field_rx__octets = other_value.rx__octets();
} else {
single_value->field_rx__octets.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lost__packets().get_selection()) {
single_value->field_lost__packets = other_value.lost__packets();
} else {
single_value->field_lost__packets.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.jitter().get_selection()) {
single_value->field_jitter = other_value.jitter();
} else {
single_value->field_jitter.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.avg__delay().get_selection()) {
single_value->field_avg__delay = other_value.avg__delay();
} else {
single_value->field_avg__delay.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__IPA__ConnectionStats_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__IPA__ConnectionStats_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__IPA__ConnectionStats_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
break;
}
set_selection(other_value);
}

RSL__IE__IPA__ConnectionStats_template::RSL__IE__IPA__ConnectionStats_template()
{
}

RSL__IE__IPA__ConnectionStats_template::RSL__IE__IPA__ConnectionStats_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__IPA__ConnectionStats_template::RSL__IE__IPA__ConnectionStats_template(const RSL__IE__IPA__ConnectionStats& other_value)
{
copy_value(other_value);
}

RSL__IE__IPA__ConnectionStats_template::RSL__IE__IPA__ConnectionStats_template(const OPTIONAL<RSL__IE__IPA__ConnectionStats>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__IPA__ConnectionStats&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats from an unbound optional field.");
}
}

RSL__IE__IPA__ConnectionStats_template::RSL__IE__IPA__ConnectionStats_template(RSL__IE__IPA__ConnectionStats_template* p_precondition, RSL__IE__IPA__ConnectionStats_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__IPA__ConnectionStats_template::RSL__IE__IPA__ConnectionStats_template(Dynamic_Match_Interface<RSL__IE__IPA__ConnectionStats>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__IPA__ConnectionStats>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__IPA__ConnectionStats_template::RSL__IE__IPA__ConnectionStats_template(const RSL__IE__IPA__ConnectionStats_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__IPA__ConnectionStats_template::~RSL__IE__IPA__ConnectionStats_template()
{
clean_up();
}

RSL__IE__IPA__ConnectionStats_template& RSL__IE__IPA__ConnectionStats_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__IPA__ConnectionStats_template& RSL__IE__IPA__ConnectionStats_template::operator=(const RSL__IE__IPA__ConnectionStats& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__IPA__ConnectionStats_template& RSL__IE__IPA__ConnectionStats_template::operator=(const OPTIONAL<RSL__IE__IPA__ConnectionStats>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__IPA__ConnectionStats&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
}
return *this;
}

RSL__IE__IPA__ConnectionStats_template& RSL__IE__IPA__ConnectionStats_template::operator=(const RSL__IE__IPA__ConnectionStats_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__IPA__ConnectionStats_template::match(const RSL__IE__IPA__ConnectionStats& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.len().is_bound()) return FALSE;
if(!single_value->field_len.match(other_value.len(), legacy))return FALSE;
if(!other_value.tx__packets().is_bound()) return FALSE;
if(!single_value->field_tx__packets.match(other_value.tx__packets(), legacy))return FALSE;
if(!other_value.tx__octets().is_bound()) return FALSE;
if(!single_value->field_tx__octets.match(other_value.tx__octets(), legacy))return FALSE;
if(!other_value.rx__packets().is_bound()) return FALSE;
if(!single_value->field_rx__packets.match(other_value.rx__packets(), legacy))return FALSE;
if(!other_value.rx__octets().is_bound()) return FALSE;
if(!single_value->field_rx__octets.match(other_value.rx__octets(), legacy))return FALSE;
if(!other_value.lost__packets().is_bound()) return FALSE;
if(!single_value->field_lost__packets.match(other_value.lost__packets(), legacy))return FALSE;
if(!other_value.jitter().is_bound()) return FALSE;
if(!single_value->field_jitter.match(other_value.jitter(), legacy))return FALSE;
if(!other_value.avg__delay().is_bound()) return FALSE;
if(!single_value->field_avg__delay.match(other_value.avg__delay(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
}
return FALSE;
}

boolean RSL__IE__IPA__ConnectionStats_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_len.is_bound()
 || single_value->field_tx__packets.is_bound()
 || single_value->field_tx__octets.is_bound()
 || single_value->field_rx__packets.is_bound()
 || single_value->field_rx__octets.is_bound()
 || single_value->field_lost__packets.is_bound()
 || single_value->field_jitter.is_bound()
 || single_value->field_avg__delay.is_bound();
}

boolean RSL__IE__IPA__ConnectionStats_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_len.is_value()
 && single_value->field_tx__packets.is_value()
 && single_value->field_tx__octets.is_value()
 && single_value->field_rx__packets.is_value()
 && single_value->field_rx__octets.is_value()
 && single_value->field_lost__packets.is_value()
 && single_value->field_jitter.is_value()
 && single_value->field_avg__delay.is_value();
}

void RSL__IE__IPA__ConnectionStats_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__IPA__ConnectionStats RSL__IE__IPA__ConnectionStats_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
RSL__IE__IPA__ConnectionStats ret_val;
if (single_value->field_len.is_bound()) {
ret_val.len() = single_value->field_len.valueof();
}
if (single_value->field_tx__packets.is_bound()) {
ret_val.tx__packets() = single_value->field_tx__packets.valueof();
}
if (single_value->field_tx__octets.is_bound()) {
ret_val.tx__octets() = single_value->field_tx__octets.valueof();
}
if (single_value->field_rx__packets.is_bound()) {
ret_val.rx__packets() = single_value->field_rx__packets.valueof();
}
if (single_value->field_rx__octets.is_bound()) {
ret_val.rx__octets() = single_value->field_rx__octets.valueof();
}
if (single_value->field_lost__packets.is_bound()) {
ret_val.lost__packets() = single_value->field_lost__packets.valueof();
}
if (single_value->field_jitter.is_bound()) {
ret_val.jitter() = single_value->field_jitter.valueof();
}
if (single_value->field_avg__delay.is_bound()) {
ret_val.avg__delay() = single_value->field_avg__delay.valueof();
}
return ret_val;
}

void RSL__IE__IPA__ConnectionStats_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__IPA__ConnectionStats_template[list_length];
}

RSL__IE__IPA__ConnectionStats_template& RSL__IE__IPA__ConnectionStats_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__IPA__ConnectionStats_template::len()
{
set_specific();
return single_value->field_len;
}

const INTEGER_template& RSL__IE__IPA__ConnectionStats_template::len() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len of a non-specific template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
return single_value->field_len;
}

INTEGER_template& RSL__IE__IPA__ConnectionStats_template::tx__packets()
{
set_specific();
return single_value->field_tx__packets;
}

const INTEGER_template& RSL__IE__IPA__ConnectionStats_template::tx__packets() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tx_packets of a non-specific template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
return single_value->field_tx__packets;
}

INTEGER_template& RSL__IE__IPA__ConnectionStats_template::tx__octets()
{
set_specific();
return single_value->field_tx__octets;
}

const INTEGER_template& RSL__IE__IPA__ConnectionStats_template::tx__octets() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tx_octets of a non-specific template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
return single_value->field_tx__octets;
}

INTEGER_template& RSL__IE__IPA__ConnectionStats_template::rx__packets()
{
set_specific();
return single_value->field_rx__packets;
}

const INTEGER_template& RSL__IE__IPA__ConnectionStats_template::rx__packets() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rx_packets of a non-specific template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
return single_value->field_rx__packets;
}

INTEGER_template& RSL__IE__IPA__ConnectionStats_template::rx__octets()
{
set_specific();
return single_value->field_rx__octets;
}

const INTEGER_template& RSL__IE__IPA__ConnectionStats_template::rx__octets() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rx_octets of a non-specific template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
return single_value->field_rx__octets;
}

INTEGER_template& RSL__IE__IPA__ConnectionStats_template::lost__packets()
{
set_specific();
return single_value->field_lost__packets;
}

const INTEGER_template& RSL__IE__IPA__ConnectionStats_template::lost__packets() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lost_packets of a non-specific template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
return single_value->field_lost__packets;
}

INTEGER_template& RSL__IE__IPA__ConnectionStats_template::jitter()
{
set_specific();
return single_value->field_jitter;
}

const INTEGER_template& RSL__IE__IPA__ConnectionStats_template::jitter() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field jitter of a non-specific template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
return single_value->field_jitter;
}

INTEGER_template& RSL__IE__IPA__ConnectionStats_template::avg__delay()
{
set_specific();
return single_value->field_avg__delay;
}

const INTEGER_template& RSL__IE__IPA__ConnectionStats_template::avg__delay() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field avg_delay of a non-specific template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
return single_value->field_avg__delay;
}

int RSL__IE__IPA__ConnectionStats_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 8;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
  }
  return 0;
}

void RSL__IE__IPA__ConnectionStats_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log();
TTCN_Logger::log_event_str(", tx_packets := ");
single_value->field_tx__packets.log();
TTCN_Logger::log_event_str(", tx_octets := ");
single_value->field_tx__octets.log();
TTCN_Logger::log_event_str(", rx_packets := ");
single_value->field_rx__packets.log();
TTCN_Logger::log_event_str(", rx_octets := ");
single_value->field_rx__octets.log();
TTCN_Logger::log_event_str(", lost_packets := ");
single_value->field_lost__packets.log();
TTCN_Logger::log_event_str(", jitter := ");
single_value->field_jitter.log();
TTCN_Logger::log_event_str(", avg_delay := ");
single_value->field_avg__delay.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__IPA__ConnectionStats_template::log_match(const RSL__IE__IPA__ConnectionStats& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_len.match(match_value.len(), legacy)){
TTCN_Logger::log_logmatch_info(".len");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_tx__packets.match(match_value.tx__packets(), legacy)){
TTCN_Logger::log_logmatch_info(".tx_packets");
single_value->field_tx__packets.log_match(match_value.tx__packets(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_tx__octets.match(match_value.tx__octets(), legacy)){
TTCN_Logger::log_logmatch_info(".tx_octets");
single_value->field_tx__octets.log_match(match_value.tx__octets(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rx__packets.match(match_value.rx__packets(), legacy)){
TTCN_Logger::log_logmatch_info(".rx_packets");
single_value->field_rx__packets.log_match(match_value.rx__packets(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rx__octets.match(match_value.rx__octets(), legacy)){
TTCN_Logger::log_logmatch_info(".rx_octets");
single_value->field_rx__octets.log_match(match_value.rx__octets(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lost__packets.match(match_value.lost__packets(), legacy)){
TTCN_Logger::log_logmatch_info(".lost_packets");
single_value->field_lost__packets.log_match(match_value.lost__packets(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_jitter.match(match_value.jitter(), legacy)){
TTCN_Logger::log_logmatch_info(".jitter");
single_value->field_jitter.log_match(match_value.jitter(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_avg__delay.match(match_value.avg__delay(), legacy)){
TTCN_Logger::log_logmatch_info(".avg_delay");
single_value->field_avg__delay.log_match(match_value.avg__delay(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::log_event_str(", tx_packets := ");
single_value->field_tx__packets.log_match(match_value.tx__packets(), legacy);
TTCN_Logger::log_event_str(", tx_octets := ");
single_value->field_tx__octets.log_match(match_value.tx__octets(), legacy);
TTCN_Logger::log_event_str(", rx_packets := ");
single_value->field_rx__packets.log_match(match_value.rx__packets(), legacy);
TTCN_Logger::log_event_str(", rx_octets := ");
single_value->field_rx__octets.log_match(match_value.rx__octets(), legacy);
TTCN_Logger::log_event_str(", lost_packets := ");
single_value->field_lost__packets.log_match(match_value.lost__packets(), legacy);
TTCN_Logger::log_event_str(", jitter := ");
single_value->field_jitter.log_match(match_value.jitter(), legacy);
TTCN_Logger::log_event_str(", avg_delay := ");
single_value->field_avg__delay.log_match(match_value.avg__delay(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__IPA__ConnectionStats_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (len().is_bound()) len().set_implicit_omit();
if (tx__packets().is_bound()) tx__packets().set_implicit_omit();
if (tx__octets().is_bound()) tx__octets().set_implicit_omit();
if (rx__packets().is_bound()) rx__packets().set_implicit_omit();
if (rx__octets().is_bound()) rx__octets().set_implicit_omit();
if (lost__packets().is_bound()) lost__packets().set_implicit_omit();
if (jitter().is_bound()) jitter().set_implicit_omit();
if (avg__delay().is_bound()) avg__delay().set_implicit_omit();
}

void RSL__IE__IPA__ConnectionStats_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_len.encode_text(text_buf);
single_value->field_tx__packets.encode_text(text_buf);
single_value->field_tx__octets.encode_text(text_buf);
single_value->field_rx__packets.encode_text(text_buf);
single_value->field_rx__octets.encode_text(text_buf);
single_value->field_lost__packets.encode_text(text_buf);
single_value->field_jitter.encode_text(text_buf);
single_value->field_avg__delay.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
}
}

void RSL__IE__IPA__ConnectionStats_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_len.decode_text(text_buf);
single_value->field_tx__packets.decode_text(text_buf);
single_value->field_tx__octets.decode_text(text_buf);
single_value->field_rx__packets.decode_text(text_buf);
single_value->field_rx__octets.decode_text(text_buf);
single_value->field_lost__packets.decode_text(text_buf);
single_value->field_jitter.decode_text(text_buf);
single_value->field_avg__delay.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__IPA__ConnectionStats_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
}
}

void RSL__IE__IPA__ConnectionStats_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__IPA__ConnectionStats_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_IPA_ConnectionStats has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) tx__packets().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) tx__octets().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rx__packets().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) rx__octets().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) lost__packets().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) jitter().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) avg__delay().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tx_packets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tx__packets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tx_octets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tx__octets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rx_packets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rx__packets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rx_octets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rx__octets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lost_packets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lost__packets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "jitter")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          jitter().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "avg_delay")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          avg__delay().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_IPA_ConnectionStats: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__IPA__ConnectionStats_template* precondition = new RSL__IE__IPA__ConnectionStats_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__IPA__ConnectionStats_template* implied_template = new RSL__IE__IPA__ConnectionStats_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__IPA__ConnectionStats_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_IPA_ConnectionStats");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__IPA__ConnectionStats_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_len.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_ConnectionStats");
single_value->field_tx__packets.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_ConnectionStats");
single_value->field_tx__octets.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_ConnectionStats");
single_value->field_rx__packets.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_ConnectionStats");
single_value->field_rx__octets.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_ConnectionStats");
single_value->field_lost__packets.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_ConnectionStats");
single_value->field_jitter.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_ConnectionStats");
single_value->field_avg__delay.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_ConnectionStats");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_IPA_ConnectionStats");
}

boolean RSL__IE__IPA__ConnectionStats_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__IPA__ConnectionStats_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IPA__SpeechMode::RSL__IPA__SpeechMode()
{
enum_value = UNBOUND_VALUE;
}

RSL__IPA__SpeechMode::RSL__IPA__SpeechMode(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @RSL_Types.RSL_IPA_SpeechMode with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

RSL__IPA__SpeechMode::RSL__IPA__SpeechMode(enum_type other_value)
{
enum_value = other_value;
}

RSL__IPA__SpeechMode::RSL__IPA__SpeechMode(const RSL__IPA__SpeechMode& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
enum_value = other_value.enum_value;
}

RSL__IPA__SpeechMode& RSL__IPA__SpeechMode::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @RSL_Types.RSL_IPA_SpeechMode.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

RSL__IPA__SpeechMode& RSL__IPA__SpeechMode::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

RSL__IPA__SpeechMode& RSL__IPA__SpeechMode::operator=(const RSL__IPA__SpeechMode& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
enum_value = other_value.enum_value;
return *this;
}

boolean RSL__IPA__SpeechMode::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_SpeechMode comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean RSL__IPA__SpeechMode::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
return enum_value == other_value;
}

boolean RSL__IPA__SpeechMode::operator==(const RSL__IPA__SpeechMode& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
return enum_value == other_value.enum_value;
}

boolean RSL__IPA__SpeechMode::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_SpeechMode comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean RSL__IPA__SpeechMode::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
return enum_value < other_value;
}

boolean RSL__IPA__SpeechMode::operator<(const RSL__IPA__SpeechMode& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
return enum_value < other_value.enum_value;
}

boolean RSL__IPA__SpeechMode::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_SpeechMode comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean RSL__IPA__SpeechMode::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
return enum_value > other_value;
}

boolean RSL__IPA__SpeechMode::operator>(const RSL__IPA__SpeechMode& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
return enum_value > other_value.enum_value;
}

const char *RSL__IPA__SpeechMode::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case RSL__IPA__SPM__SENDRECV: return "RSL_IPA_SPM_SENDRECV";
case RSL__IPA__SPM__RECVONLY: return "RSL_IPA_SPM_RECVONLY";
case RSL__IPA__SPM__SENDONLY: return "RSL_IPA_SPM_SENDONLY";
case RSL__IPA__SPM__RESERVED: return "RSL_IPA_SPM_RESERVED";
default:
return "<unknown>";
}
}

RSL__IPA__SpeechMode::enum_type RSL__IPA__SpeechMode::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "RSL_IPA_SPM_SENDRECV")) return RSL__IPA__SPM__SENDRECV;
if (!strcmp(str_par, "RSL_IPA_SPM_RECVONLY")) return RSL__IPA__SPM__RECVONLY;
if (!strcmp(str_par, "RSL_IPA_SPM_SENDONLY")) return RSL__IPA__SPM__SENDONLY;
if (!strcmp(str_par, "RSL_IPA_SPM_RESERVED")) return RSL__IPA__SPM__RESERVED;
}
return UNKNOWN_VALUE;
}

boolean RSL__IPA__SpeechMode::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
return TRUE;
default:
return FALSE;
}
}

int RSL__IPA__SpeechMode::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int RSL__IPA__SpeechMode::enum2int(const RSL__IPA__SpeechMode& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void RSL__IPA__SpeechMode::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @RSL_Types.RSL_IPA_SpeechMode.", int_val);
enum_value = (enum_type)int_val;
}

RSL__IPA__SpeechMode::operator RSL__IPA__SpeechMode::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
return enum_value;
}

void RSL__IPA__SpeechMode::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void RSL__IPA__SpeechMode::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@RSL_Types.RSL_IPA_SpeechMode");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @RSL_Types.RSL_IPA_SpeechMode.");
  }
}

void RSL__IPA__SpeechMode::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
text_buf.push_int(enum_value);
}

void RSL__IPA__SpeechMode::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @RSL_Types.RSL_IPA_SpeechMode.", enum_value);
}

void RSL__IPA__SpeechMode::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IPA__SpeechMode::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IPA__SpeechMode::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 3, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int RSL__IPA__SpeechMode::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 3);
}

void RSL__IPA__SpeechMode_template::copy_template(const RSL__IPA__SpeechMode_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IPA__SpeechMode_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IPA__SpeechMode_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IPA__SpeechMode_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
}
}

RSL__IPA__SpeechMode_template::RSL__IPA__SpeechMode_template()
{
}

RSL__IPA__SpeechMode_template::RSL__IPA__SpeechMode_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IPA__SpeechMode_template::RSL__IPA__SpeechMode_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!RSL__IPA__SpeechMode::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @RSL_Types.RSL_IPA_SpeechMode with unknown numeric value %d.", other_value);
single_value = (RSL__IPA__SpeechMode::enum_type)other_value;
}

RSL__IPA__SpeechMode_template::RSL__IPA__SpeechMode_template(RSL__IPA__SpeechMode::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

RSL__IPA__SpeechMode_template::RSL__IPA__SpeechMode_template(const RSL__IPA__SpeechMode& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == RSL__IPA__SpeechMode::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
single_value = other_value.enum_value;
}

RSL__IPA__SpeechMode_template::RSL__IPA__SpeechMode_template(const OPTIONAL<RSL__IPA__SpeechMode>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__SpeechMode::enum_type)(const RSL__IPA__SpeechMode&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @RSL_Types.RSL_IPA_SpeechMode from an unbound optional field.");
}
}

RSL__IPA__SpeechMode_template::RSL__IPA__SpeechMode_template(RSL__IPA__SpeechMode_template* p_precondition, RSL__IPA__SpeechMode_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IPA__SpeechMode_template::RSL__IPA__SpeechMode_template(Dynamic_Match_Interface<RSL__IPA__SpeechMode>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IPA__SpeechMode>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IPA__SpeechMode_template::RSL__IPA__SpeechMode_template(const RSL__IPA__SpeechMode_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

RSL__IPA__SpeechMode_template::~RSL__IPA__SpeechMode_template()
{
clean_up();
}

boolean RSL__IPA__SpeechMode_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean RSL__IPA__SpeechMode_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != RSL__IPA__SpeechMode::UNBOUND_VALUE;
}

void RSL__IPA__SpeechMode_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IPA__SpeechMode_template& RSL__IPA__SpeechMode_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IPA__SpeechMode_template& RSL__IPA__SpeechMode_template::operator=(int other_value)
{
if (!RSL__IPA__SpeechMode::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @RSL_Types.RSL_IPA_SpeechMode.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__SpeechMode::enum_type)other_value;
return *this;
}

RSL__IPA__SpeechMode_template& RSL__IPA__SpeechMode_template::operator=(RSL__IPA__SpeechMode::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

RSL__IPA__SpeechMode_template& RSL__IPA__SpeechMode_template::operator=(const RSL__IPA__SpeechMode& other_value)
{
if (other_value.enum_value == RSL__IPA__SpeechMode::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

RSL__IPA__SpeechMode_template& RSL__IPA__SpeechMode_template::operator=(const OPTIONAL<RSL__IPA__SpeechMode>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__SpeechMode::enum_type)(const RSL__IPA__SpeechMode&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
}
return *this;
}

RSL__IPA__SpeechMode_template& RSL__IPA__SpeechMode_template::operator=(const RSL__IPA__SpeechMode_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IPA__SpeechMode_template::match(RSL__IPA__SpeechMode::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
}
return FALSE;
}

boolean RSL__IPA__SpeechMode_template::match(const RSL__IPA__SpeechMode& other_value, boolean) const
{
if (other_value.enum_value == RSL__IPA__SpeechMode::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @RSL_Types.RSL_IPA_SpeechMode with an unbound value.");
return match(other_value.enum_value);
}

RSL__IPA__SpeechMode::enum_type RSL__IPA__SpeechMode_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
return single_value;
}

void RSL__IPA__SpeechMode_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IPA__SpeechMode_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
}
}

RSL__IPA__SpeechMode_template& RSL__IPA__SpeechMode_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
return value_list.list_value[list_index];
}

void RSL__IPA__SpeechMode_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(RSL__IPA__SpeechMode::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IPA__SpeechMode_template::log_match(const RSL__IPA__SpeechMode& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void RSL__IPA__SpeechMode_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
}
}

void RSL__IPA__SpeechMode_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (RSL__IPA__SpeechMode::enum_type)text_buf.pull_int().get_val();
if (!RSL__IPA__SpeechMode::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @RSL_Types.RSL_IPA_SpeechMode.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IPA__SpeechMode_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
}
}

boolean RSL__IPA__SpeechMode_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IPA__SpeechMode_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RSL__IPA__SpeechMode_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IPA__SpeechMode_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    RSL__IPA__SpeechMode::enum_type enum_val = RSL__IPA__SpeechMode::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!RSL__IPA__SpeechMode::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @RSL_Types.RSL_IPA_SpeechMode.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IPA__SpeechMode_template* precondition = new RSL__IPA__SpeechMode_template;
    precondition->set_param(*m_p->get_elem(0));
    RSL__IPA__SpeechMode_template* implied_template = new RSL__IPA__SpeechMode_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = RSL__IPA__SpeechMode_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@RSL_Types.RSL_IPA_SpeechMode");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IPA__SpeechMode_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IPA_SpeechMode");
}

RSL__IPA__Codec::RSL__IPA__Codec()
{
enum_value = UNBOUND_VALUE;
}

RSL__IPA__Codec::RSL__IPA__Codec(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @RSL_Types.RSL_IPA_Codec with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

RSL__IPA__Codec::RSL__IPA__Codec(enum_type other_value)
{
enum_value = other_value;
}

RSL__IPA__Codec::RSL__IPA__Codec(const RSL__IPA__Codec& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
enum_value = other_value.enum_value;
}

RSL__IPA__Codec& RSL__IPA__Codec::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @RSL_Types.RSL_IPA_Codec.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

RSL__IPA__Codec& RSL__IPA__Codec::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

RSL__IPA__Codec& RSL__IPA__Codec::operator=(const RSL__IPA__Codec& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
enum_value = other_value.enum_value;
return *this;
}

boolean RSL__IPA__Codec::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_Codec comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean RSL__IPA__Codec::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
return enum_value == other_value;
}

boolean RSL__IPA__Codec::operator==(const RSL__IPA__Codec& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
return enum_value == other_value.enum_value;
}

boolean RSL__IPA__Codec::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_Codec comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean RSL__IPA__Codec::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
return enum_value < other_value;
}

boolean RSL__IPA__Codec::operator<(const RSL__IPA__Codec& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
return enum_value < other_value.enum_value;
}

boolean RSL__IPA__Codec::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_Codec comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean RSL__IPA__Codec::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
return enum_value > other_value;
}

boolean RSL__IPA__Codec::operator>(const RSL__IPA__Codec& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
return enum_value > other_value.enum_value;
}

const char *RSL__IPA__Codec::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case RSL__IPA__CODEC__FR: return "RSL_IPA_CODEC_FR";
case RSL__IPA__CODEC__EFR: return "RSL_IPA_CODEC_EFR";
case RSL__IPA__CODEC__AMR__F: return "RSL_IPA_CODEC_AMR_F";
case RSL__IPA__CODEC__HR: return "RSL_IPA_CODEC_HR";
case RSL__IPA__CODEC__AMR__H: return "RSL_IPA_CODEC_AMR_H";
case RSL__IPA__CODEC__RTP__PT: return "RSL_IPA_CODEC_RTP_PT";
default:
return "<unknown>";
}
}

RSL__IPA__Codec::enum_type RSL__IPA__Codec::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "RSL_IPA_CODEC_FR")) return RSL__IPA__CODEC__FR;
if (!strcmp(str_par, "RSL_IPA_CODEC_EFR")) return RSL__IPA__CODEC__EFR;
if (!strcmp(str_par, "RSL_IPA_CODEC_AMR_F")) return RSL__IPA__CODEC__AMR__F;
if (!strcmp(str_par, "RSL_IPA_CODEC_HR")) return RSL__IPA__CODEC__HR;
if (!strcmp(str_par, "RSL_IPA_CODEC_AMR_H")) return RSL__IPA__CODEC__AMR__H;
if (!strcmp(str_par, "RSL_IPA_CODEC_RTP_PT")) return RSL__IPA__CODEC__RTP__PT;
}
return UNKNOWN_VALUE;
}

boolean RSL__IPA__Codec::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
case 5:
case 15:
return TRUE;
default:
return FALSE;
}
}

int RSL__IPA__Codec::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_IPA_Codec.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int RSL__IPA__Codec::enum2int(const RSL__IPA__Codec& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_IPA_Codec.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void RSL__IPA__Codec::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @RSL_Types.RSL_IPA_Codec.", int_val);
enum_value = (enum_type)int_val;
}

RSL__IPA__Codec::operator RSL__IPA__Codec::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @RSL_Types.RSL_IPA_Codec.");
return enum_value;
}

void RSL__IPA__Codec::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void RSL__IPA__Codec::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@RSL_Types.RSL_IPA_Codec");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @RSL_Types.RSL_IPA_Codec.");
  }
}

void RSL__IPA__Codec::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
text_buf.push_int(enum_value);
}

void RSL__IPA__Codec::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @RSL_Types.RSL_IPA_Codec.", enum_value);
}

void RSL__IPA__Codec::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IPA__Codec::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IPA__Codec::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 4, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int RSL__IPA__Codec::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 4);
}

void RSL__IPA__Codec_template::copy_template(const RSL__IPA__Codec_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IPA__Codec_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IPA__Codec_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IPA__Codec_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_Codec.");
}
}

RSL__IPA__Codec_template::RSL__IPA__Codec_template()
{
}

RSL__IPA__Codec_template::RSL__IPA__Codec_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IPA__Codec_template::RSL__IPA__Codec_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!RSL__IPA__Codec::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @RSL_Types.RSL_IPA_Codec with unknown numeric value %d.", other_value);
single_value = (RSL__IPA__Codec::enum_type)other_value;
}

RSL__IPA__Codec_template::RSL__IPA__Codec_template(RSL__IPA__Codec::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

RSL__IPA__Codec_template::RSL__IPA__Codec_template(const RSL__IPA__Codec& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == RSL__IPA__Codec::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
single_value = other_value.enum_value;
}

RSL__IPA__Codec_template::RSL__IPA__Codec_template(const OPTIONAL<RSL__IPA__Codec>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__Codec::enum_type)(const RSL__IPA__Codec&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @RSL_Types.RSL_IPA_Codec from an unbound optional field.");
}
}

RSL__IPA__Codec_template::RSL__IPA__Codec_template(RSL__IPA__Codec_template* p_precondition, RSL__IPA__Codec_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IPA__Codec_template::RSL__IPA__Codec_template(Dynamic_Match_Interface<RSL__IPA__Codec>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IPA__Codec>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IPA__Codec_template::RSL__IPA__Codec_template(const RSL__IPA__Codec_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

RSL__IPA__Codec_template::~RSL__IPA__Codec_template()
{
clean_up();
}

boolean RSL__IPA__Codec_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean RSL__IPA__Codec_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != RSL__IPA__Codec::UNBOUND_VALUE;
}

void RSL__IPA__Codec_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IPA__Codec_template& RSL__IPA__Codec_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IPA__Codec_template& RSL__IPA__Codec_template::operator=(int other_value)
{
if (!RSL__IPA__Codec::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @RSL_Types.RSL_IPA_Codec.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__Codec::enum_type)other_value;
return *this;
}

RSL__IPA__Codec_template& RSL__IPA__Codec_template::operator=(RSL__IPA__Codec::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

RSL__IPA__Codec_template& RSL__IPA__Codec_template::operator=(const RSL__IPA__Codec& other_value)
{
if (other_value.enum_value == RSL__IPA__Codec::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

RSL__IPA__Codec_template& RSL__IPA__Codec_template::operator=(const OPTIONAL<RSL__IPA__Codec>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__Codec::enum_type)(const RSL__IPA__Codec&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @RSL_Types.RSL_IPA_Codec.");
}
return *this;
}

RSL__IPA__Codec_template& RSL__IPA__Codec_template::operator=(const RSL__IPA__Codec_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IPA__Codec_template::match(RSL__IPA__Codec::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_Codec.");
}
return FALSE;
}

boolean RSL__IPA__Codec_template::match(const RSL__IPA__Codec& other_value, boolean) const
{
if (other_value.enum_value == RSL__IPA__Codec::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @RSL_Types.RSL_IPA_Codec with an unbound value.");
return match(other_value.enum_value);
}

RSL__IPA__Codec::enum_type RSL__IPA__Codec_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @RSL_Types.RSL_IPA_Codec.");
return single_value;
}

void RSL__IPA__Codec_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IPA__Codec_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @RSL_Types.RSL_IPA_Codec.");
}
}

RSL__IPA__Codec_template& RSL__IPA__Codec_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @RSL_Types.RSL_IPA_Codec.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @RSL_Types.RSL_IPA_Codec.");
return value_list.list_value[list_index];
}

void RSL__IPA__Codec_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(RSL__IPA__Codec::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IPA__Codec_template::log_match(const RSL__IPA__Codec& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void RSL__IPA__Codec_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_Codec.");
}
}

void RSL__IPA__Codec_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (RSL__IPA__Codec::enum_type)text_buf.pull_int().get_val();
if (!RSL__IPA__Codec::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @RSL_Types.RSL_IPA_Codec.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IPA__Codec_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @RSL_Types.RSL_IPA_Codec.");
}
}

boolean RSL__IPA__Codec_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IPA__Codec_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RSL__IPA__Codec_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IPA__Codec_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    RSL__IPA__Codec::enum_type enum_val = RSL__IPA__Codec::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!RSL__IPA__Codec::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @RSL_Types.RSL_IPA_Codec.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IPA__Codec_template* precondition = new RSL__IPA__Codec_template;
    precondition->set_param(*m_p->get_elem(0));
    RSL__IPA__Codec_template* implied_template = new RSL__IPA__Codec_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = RSL__IPA__Codec_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@RSL_Types.RSL_IPA_Codec");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IPA__Codec_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IPA_Codec");
}

RSL__IE__IPA__SpeechMode::RSL__IE__IPA__SpeechMode()
{
}

RSL__IE__IPA__SpeechMode::RSL__IE__IPA__SpeechMode(const BITSTRING& par_reserved,
    const RSL__IPA__SpeechMode& par_mode,
    const RSL__IPA__Codec& par_codec)
  :   field_reserved(par_reserved),
  field_mode(par_mode),
  field_codec(par_codec)
{
}

RSL__IE__IPA__SpeechMode::RSL__IE__IPA__SpeechMode(const RSL__IE__IPA__SpeechMode& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
else field_reserved.clean_up();
if (other_value.mode().is_bound()) field_mode = other_value.mode();
else field_mode.clean_up();
if (other_value.codec().is_bound()) field_codec = other_value.codec();
else field_codec.clean_up();
}

void RSL__IE__IPA__SpeechMode::clean_up()
{
field_reserved.clean_up();
field_mode.clean_up();
field_codec.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__IPA__SpeechMode::get_descriptor() const { return &RSL__IE__IPA__SpeechMode_descr_; }
RSL__IE__IPA__SpeechMode& RSL__IE__IPA__SpeechMode::operator=(const RSL__IE__IPA__SpeechMode& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
  if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
  else field_reserved.clean_up();
  if (other_value.mode().is_bound()) field_mode = other_value.mode();
  else field_mode.clean_up();
  if (other_value.codec().is_bound()) field_codec = other_value.codec();
  else field_codec.clean_up();
}
return *this;
}

boolean RSL__IE__IPA__SpeechMode::operator==(const RSL__IE__IPA__SpeechMode& other_value) const
{
return field_reserved==other_value.field_reserved
  && field_mode==other_value.field_mode
  && field_codec==other_value.field_codec;
}

boolean RSL__IE__IPA__SpeechMode::is_bound() const
{
return (field_reserved.is_bound())
  || (field_mode.is_bound())
  || (field_codec.is_bound());
}
boolean RSL__IE__IPA__SpeechMode::is_value() const
{
return field_reserved.is_value()
  && field_mode.is_value()
  && field_codec.is_value();
}
void RSL__IE__IPA__SpeechMode::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ reserved := ");
field_reserved.log();
TTCN_Logger::log_event_str(", mode := ");
field_mode.log();
TTCN_Logger::log_event_str(", codec := ");
field_codec.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__IPA__SpeechMode::set_implicit_omit()
{
if (reserved().is_bound()) reserved().set_implicit_omit();
if (mode().is_bound()) mode().set_implicit_omit();
if (codec().is_bound()) codec().set_implicit_omit();
}

void RSL__IE__IPA__SpeechMode::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_IPA_SpeechMode has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) mode().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) codec().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "codec")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          codec().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_IPA_SpeechMode: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_IPA_SpeechMode");
  }
}

void RSL__IE__IPA__SpeechMode::encode_text(Text_Buf& text_buf) const
{
field_reserved.encode_text(text_buf);
field_mode.encode_text(text_buf);
field_codec.encode_text(text_buf);
}

void RSL__IE__IPA__SpeechMode::decode_text(Text_Buf& text_buf)
{
field_reserved.decode_text(text_buf);
field_mode.decode_text(text_buf);
field_codec.decode_text(text_buf);
}

void RSL__IE__IPA__SpeechMode::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__IPA__SpeechMode::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__IPA__SpeechMode::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__IPA__SpeechMode_reserved_descr_.raw->forceomit);
  decoded_field_length = field_reserved.RAW_decode(RSL__IE__IPA__SpeechMode_reserved_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__IPA__SpeechMode_mode_descr_.raw->forceomit);
  decoded_field_length = field_mode.RAW_decode(RSL__IE__IPA__SpeechMode_mode_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, RSL__IE__IPA__SpeechMode_codec_descr_.raw->forceomit);
  decoded_field_length = field_codec.RAW_decode(RSL__IE__IPA__SpeechMode_codec_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__IPA__SpeechMode::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__IPA__SpeechMode_reserved_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__IPA__SpeechMode_mode_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RSL__IE__IPA__SpeechMode_codec_descr_.raw);
  encoded_length += field_reserved.RAW_encode(RSL__IE__IPA__SpeechMode_reserved_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_mode.RAW_encode(RSL__IE__IPA__SpeechMode_mode_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_codec.RAW_encode(RSL__IE__IPA__SpeechMode_codec_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__IPA__SpeechMode_template::single_value_struct {
BITSTRING_template field_reserved;
RSL__IPA__SpeechMode_template field_mode;
RSL__IPA__Codec_template field_codec;
};

void RSL__IE__IPA__SpeechMode_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_reserved = ANY_VALUE;
single_value->field_mode = ANY_VALUE;
single_value->field_codec = ANY_VALUE;
}
}
}

void RSL__IE__IPA__SpeechMode_template::copy_value(const RSL__IE__IPA__SpeechMode& other_value)
{
single_value = new single_value_struct;
if (other_value.reserved().is_bound()) {
  single_value->field_reserved = other_value.reserved();
} else {
  single_value->field_reserved.clean_up();
}
if (other_value.mode().is_bound()) {
  single_value->field_mode = other_value.mode();
} else {
  single_value->field_mode.clean_up();
}
if (other_value.codec().is_bound()) {
  single_value->field_codec = other_value.codec();
} else {
  single_value->field_codec.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__IPA__SpeechMode_template::copy_template(const RSL__IE__IPA__SpeechMode_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.reserved().get_selection()) {
single_value->field_reserved = other_value.reserved();
} else {
single_value->field_reserved.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mode().get_selection()) {
single_value->field_mode = other_value.mode();
} else {
single_value->field_mode.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.codec().get_selection()) {
single_value->field_codec = other_value.codec();
} else {
single_value->field_codec.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__IPA__SpeechMode_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__IPA__SpeechMode_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__IPA__SpeechMode_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
break;
}
set_selection(other_value);
}

RSL__IE__IPA__SpeechMode_template::RSL__IE__IPA__SpeechMode_template()
{
}

RSL__IE__IPA__SpeechMode_template::RSL__IE__IPA__SpeechMode_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__IPA__SpeechMode_template::RSL__IE__IPA__SpeechMode_template(const RSL__IE__IPA__SpeechMode& other_value)
{
copy_value(other_value);
}

RSL__IE__IPA__SpeechMode_template::RSL__IE__IPA__SpeechMode_template(const OPTIONAL<RSL__IE__IPA__SpeechMode>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__IPA__SpeechMode&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_IPA_SpeechMode from an unbound optional field.");
}
}

RSL__IE__IPA__SpeechMode_template::RSL__IE__IPA__SpeechMode_template(RSL__IE__IPA__SpeechMode_template* p_precondition, RSL__IE__IPA__SpeechMode_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__IPA__SpeechMode_template::RSL__IE__IPA__SpeechMode_template(Dynamic_Match_Interface<RSL__IE__IPA__SpeechMode>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__IPA__SpeechMode>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__IPA__SpeechMode_template::RSL__IE__IPA__SpeechMode_template(const RSL__IE__IPA__SpeechMode_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__IPA__SpeechMode_template::~RSL__IE__IPA__SpeechMode_template()
{
clean_up();
}

RSL__IE__IPA__SpeechMode_template& RSL__IE__IPA__SpeechMode_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__IPA__SpeechMode_template& RSL__IE__IPA__SpeechMode_template::operator=(const RSL__IE__IPA__SpeechMode& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__IPA__SpeechMode_template& RSL__IE__IPA__SpeechMode_template::operator=(const OPTIONAL<RSL__IE__IPA__SpeechMode>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__IPA__SpeechMode&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
}
return *this;
}

RSL__IE__IPA__SpeechMode_template& RSL__IE__IPA__SpeechMode_template::operator=(const RSL__IE__IPA__SpeechMode_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__IPA__SpeechMode_template::match(const RSL__IE__IPA__SpeechMode& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.reserved().is_bound()) return FALSE;
if(!single_value->field_reserved.match(other_value.reserved(), legacy))return FALSE;
if(!other_value.mode().is_bound()) return FALSE;
if(!single_value->field_mode.match(other_value.mode(), legacy))return FALSE;
if(!other_value.codec().is_bound()) return FALSE;
if(!single_value->field_codec.match(other_value.codec(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
}
return FALSE;
}

boolean RSL__IE__IPA__SpeechMode_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_reserved.is_bound()
 || single_value->field_mode.is_bound()
 || single_value->field_codec.is_bound();
}

boolean RSL__IE__IPA__SpeechMode_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_reserved.is_value()
 && single_value->field_mode.is_value()
 && single_value->field_codec.is_value();
}

void RSL__IE__IPA__SpeechMode_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__IPA__SpeechMode RSL__IE__IPA__SpeechMode_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
RSL__IE__IPA__SpeechMode ret_val;
if (single_value->field_reserved.is_bound()) {
ret_val.reserved() = single_value->field_reserved.valueof();
}
if (single_value->field_mode.is_bound()) {
ret_val.mode() = single_value->field_mode.valueof();
}
if (single_value->field_codec.is_bound()) {
ret_val.codec() = single_value->field_codec.valueof();
}
return ret_val;
}

void RSL__IE__IPA__SpeechMode_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__IPA__SpeechMode_template[list_length];
}

RSL__IE__IPA__SpeechMode_template& RSL__IE__IPA__SpeechMode_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
return value_list.list_value[list_index];
}

BITSTRING_template& RSL__IE__IPA__SpeechMode_template::reserved()
{
set_specific();
return single_value->field_reserved;
}

const BITSTRING_template& RSL__IE__IPA__SpeechMode_template::reserved() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reserved of a non-specific template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
return single_value->field_reserved;
}

RSL__IPA__SpeechMode_template& RSL__IE__IPA__SpeechMode_template::mode()
{
set_specific();
return single_value->field_mode;
}

const RSL__IPA__SpeechMode_template& RSL__IE__IPA__SpeechMode_template::mode() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mode of a non-specific template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
return single_value->field_mode;
}

RSL__IPA__Codec_template& RSL__IE__IPA__SpeechMode_template::codec()
{
set_specific();
return single_value->field_codec;
}

const RSL__IPA__Codec_template& RSL__IE__IPA__SpeechMode_template::codec() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field codec of a non-specific template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
return single_value->field_codec;
}

int RSL__IE__IPA__SpeechMode_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_SpeechMode which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_SpeechMode containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_SpeechMode containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_SpeechMode containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_SpeechMode containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_SpeechMode containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_SpeechMode containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_SpeechMode containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_SpeechMode containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
  }
  return 0;
}

void RSL__IE__IPA__SpeechMode_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ reserved := ");
single_value->field_reserved.log();
TTCN_Logger::log_event_str(", mode := ");
single_value->field_mode.log();
TTCN_Logger::log_event_str(", codec := ");
single_value->field_codec.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__IPA__SpeechMode_template::log_match(const RSL__IE__IPA__SpeechMode& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_reserved.match(match_value.reserved(), legacy)){
TTCN_Logger::log_logmatch_info(".reserved");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_mode.match(match_value.mode(), legacy)){
TTCN_Logger::log_logmatch_info(".mode");
single_value->field_mode.log_match(match_value.mode(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_codec.match(match_value.codec(), legacy)){
TTCN_Logger::log_logmatch_info(".codec");
single_value->field_codec.log_match(match_value.codec(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ reserved := ");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::log_event_str(", mode := ");
single_value->field_mode.log_match(match_value.mode(), legacy);
TTCN_Logger::log_event_str(", codec := ");
single_value->field_codec.log_match(match_value.codec(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__IPA__SpeechMode_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (reserved().is_bound()) reserved().set_implicit_omit();
if (mode().is_bound()) mode().set_implicit_omit();
if (codec().is_bound()) codec().set_implicit_omit();
}

void RSL__IE__IPA__SpeechMode_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_reserved.encode_text(text_buf);
single_value->field_mode.encode_text(text_buf);
single_value->field_codec.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
}
}

void RSL__IE__IPA__SpeechMode_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_reserved.decode_text(text_buf);
single_value->field_mode.decode_text(text_buf);
single_value->field_codec.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__IPA__SpeechMode_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
}
}

void RSL__IE__IPA__SpeechMode_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__IPA__SpeechMode_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_IPA_SpeechMode has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) mode().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) codec().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "codec")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          codec().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_IPA_SpeechMode: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__IPA__SpeechMode_template* precondition = new RSL__IE__IPA__SpeechMode_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__IPA__SpeechMode_template* implied_template = new RSL__IE__IPA__SpeechMode_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__IPA__SpeechMode_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_IPA_SpeechMode");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__IPA__SpeechMode_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_reserved.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_SpeechMode");
single_value->field_mode.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_SpeechMode");
single_value->field_codec.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_SpeechMode");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_IPA_SpeechMode");
}

boolean RSL__IE__IPA__SpeechMode_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__IPA__SpeechMode_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IPA__RTP__CSD__FMT__D::RSL__IPA__RTP__CSD__FMT__D()
{
enum_value = UNBOUND_VALUE;
}

RSL__IPA__RTP__CSD__FMT__D::RSL__IPA__RTP__CSD__FMT__D(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

RSL__IPA__RTP__CSD__FMT__D::RSL__IPA__RTP__CSD__FMT__D(enum_type other_value)
{
enum_value = other_value;
}

RSL__IPA__RTP__CSD__FMT__D::RSL__IPA__RTP__CSD__FMT__D(const RSL__IPA__RTP__CSD__FMT__D& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
enum_value = other_value.enum_value;
}

RSL__IPA__RTP__CSD__FMT__D& RSL__IPA__RTP__CSD__FMT__D::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

RSL__IPA__RTP__CSD__FMT__D& RSL__IPA__RTP__CSD__FMT__D::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

RSL__IPA__RTP__CSD__FMT__D& RSL__IPA__RTP__CSD__FMT__D::operator=(const RSL__IPA__RTP__CSD__FMT__D& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
enum_value = other_value.enum_value;
return *this;
}

boolean RSL__IPA__RTP__CSD__FMT__D::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__D::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
return enum_value == other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__D::operator==(const RSL__IPA__RTP__CSD__FMT__D& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
return enum_value == other_value.enum_value;
}

boolean RSL__IPA__RTP__CSD__FMT__D::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__D::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
return enum_value < other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__D::operator<(const RSL__IPA__RTP__CSD__FMT__D& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
return enum_value < other_value.enum_value;
}

boolean RSL__IPA__RTP__CSD__FMT__D::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__D::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
return enum_value > other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__D::operator>(const RSL__IPA__RTP__CSD__FMT__D& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
return enum_value > other_value.enum_value;
}

const char *RSL__IPA__RTP__CSD__FMT__D::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case RSL__IPA__RTP__CSD__EXT__TRAU: return "RSL_IPA_RTP_CSD_EXT_TRAU";
case RSL__IPA__RTP__CSD__NON__TRAU: return "RSL_IPA_RTP_CSD_NON_TRAU";
case RSL__IPA__RTP__CSD__TRAU__BTS: return "RSL_IPA_RTP_CSD_TRAU_BTS";
case RSL__IPA__RTP__CSD__IWF__FREE: return "RSL_IPA_RTP_CSD_IWF_FREE";
default:
return "<unknown>";
}
}

RSL__IPA__RTP__CSD__FMT__D::enum_type RSL__IPA__RTP__CSD__FMT__D::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "RSL_IPA_RTP_CSD_EXT_TRAU")) return RSL__IPA__RTP__CSD__EXT__TRAU;
if (!strcmp(str_par, "RSL_IPA_RTP_CSD_NON_TRAU")) return RSL__IPA__RTP__CSD__NON__TRAU;
if (!strcmp(str_par, "RSL_IPA_RTP_CSD_TRAU_BTS")) return RSL__IPA__RTP__CSD__TRAU__BTS;
if (!strcmp(str_par, "RSL_IPA_RTP_CSD_IWF_FREE")) return RSL__IPA__RTP__CSD__IWF__FREE;
}
return UNKNOWN_VALUE;
}

boolean RSL__IPA__RTP__CSD__FMT__D::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
return TRUE;
default:
return FALSE;
}
}

int RSL__IPA__RTP__CSD__FMT__D::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int RSL__IPA__RTP__CSD__FMT__D::enum2int(const RSL__IPA__RTP__CSD__FMT__D& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void RSL__IPA__RTP__CSD__FMT__D::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.", int_val);
enum_value = (enum_type)int_val;
}

RSL__IPA__RTP__CSD__FMT__D::operator RSL__IPA__RTP__CSD__FMT__D::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
return enum_value;
}

void RSL__IPA__RTP__CSD__FMT__D::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void RSL__IPA__RTP__CSD__FMT__D::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@RSL_Types.RSL_IPA_RTP_CSD_FMT_D");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
  }
}

void RSL__IPA__RTP__CSD__FMT__D::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
text_buf.push_int(enum_value);
}

void RSL__IPA__RTP__CSD__FMT__D::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.", enum_value);
}

void RSL__IPA__RTP__CSD__FMT__D::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IPA__RTP__CSD__FMT__D::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IPA__RTP__CSD__FMT__D::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 3, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int RSL__IPA__RTP__CSD__FMT__D::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 3);
}

void RSL__IPA__RTP__CSD__FMT__D_template::copy_template(const RSL__IPA__RTP__CSD__FMT__D_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IPA__RTP__CSD__FMT__D_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IPA__RTP__CSD__FMT__D_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IPA__RTP__CSD__FMT__D_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
}
}

RSL__IPA__RTP__CSD__FMT__D_template::RSL__IPA__RTP__CSD__FMT__D_template()
{
}

RSL__IPA__RTP__CSD__FMT__D_template::RSL__IPA__RTP__CSD__FMT__D_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IPA__RTP__CSD__FMT__D_template::RSL__IPA__RTP__CSD__FMT__D_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!RSL__IPA__RTP__CSD__FMT__D::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D with unknown numeric value %d.", other_value);
single_value = (RSL__IPA__RTP__CSD__FMT__D::enum_type)other_value;
}

RSL__IPA__RTP__CSD__FMT__D_template::RSL__IPA__RTP__CSD__FMT__D_template(RSL__IPA__RTP__CSD__FMT__D::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

RSL__IPA__RTP__CSD__FMT__D_template::RSL__IPA__RTP__CSD__FMT__D_template(const RSL__IPA__RTP__CSD__FMT__D& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == RSL__IPA__RTP__CSD__FMT__D::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
single_value = other_value.enum_value;
}

RSL__IPA__RTP__CSD__FMT__D_template::RSL__IPA__RTP__CSD__FMT__D_template(const OPTIONAL<RSL__IPA__RTP__CSD__FMT__D>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__RTP__CSD__FMT__D::enum_type)(const RSL__IPA__RTP__CSD__FMT__D&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D from an unbound optional field.");
}
}

RSL__IPA__RTP__CSD__FMT__D_template::RSL__IPA__RTP__CSD__FMT__D_template(RSL__IPA__RTP__CSD__FMT__D_template* p_precondition, RSL__IPA__RTP__CSD__FMT__D_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IPA__RTP__CSD__FMT__D_template::RSL__IPA__RTP__CSD__FMT__D_template(Dynamic_Match_Interface<RSL__IPA__RTP__CSD__FMT__D>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IPA__RTP__CSD__FMT__D>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IPA__RTP__CSD__FMT__D_template::RSL__IPA__RTP__CSD__FMT__D_template(const RSL__IPA__RTP__CSD__FMT__D_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

RSL__IPA__RTP__CSD__FMT__D_template::~RSL__IPA__RTP__CSD__FMT__D_template()
{
clean_up();
}

boolean RSL__IPA__RTP__CSD__FMT__D_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean RSL__IPA__RTP__CSD__FMT__D_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != RSL__IPA__RTP__CSD__FMT__D::UNBOUND_VALUE;
}

void RSL__IPA__RTP__CSD__FMT__D_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IPA__RTP__CSD__FMT__D_template& RSL__IPA__RTP__CSD__FMT__D_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IPA__RTP__CSD__FMT__D_template& RSL__IPA__RTP__CSD__FMT__D_template::operator=(int other_value)
{
if (!RSL__IPA__RTP__CSD__FMT__D::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__RTP__CSD__FMT__D::enum_type)other_value;
return *this;
}

RSL__IPA__RTP__CSD__FMT__D_template& RSL__IPA__RTP__CSD__FMT__D_template::operator=(RSL__IPA__RTP__CSD__FMT__D::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

RSL__IPA__RTP__CSD__FMT__D_template& RSL__IPA__RTP__CSD__FMT__D_template::operator=(const RSL__IPA__RTP__CSD__FMT__D& other_value)
{
if (other_value.enum_value == RSL__IPA__RTP__CSD__FMT__D::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

RSL__IPA__RTP__CSD__FMT__D_template& RSL__IPA__RTP__CSD__FMT__D_template::operator=(const OPTIONAL<RSL__IPA__RTP__CSD__FMT__D>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__RTP__CSD__FMT__D::enum_type)(const RSL__IPA__RTP__CSD__FMT__D&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
}
return *this;
}

RSL__IPA__RTP__CSD__FMT__D_template& RSL__IPA__RTP__CSD__FMT__D_template::operator=(const RSL__IPA__RTP__CSD__FMT__D_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IPA__RTP__CSD__FMT__D_template::match(RSL__IPA__RTP__CSD__FMT__D::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
}
return FALSE;
}

boolean RSL__IPA__RTP__CSD__FMT__D_template::match(const RSL__IPA__RTP__CSD__FMT__D& other_value, boolean) const
{
if (other_value.enum_value == RSL__IPA__RTP__CSD__FMT__D::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D with an unbound value.");
return match(other_value.enum_value);
}

RSL__IPA__RTP__CSD__FMT__D::enum_type RSL__IPA__RTP__CSD__FMT__D_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
return single_value;
}

void RSL__IPA__RTP__CSD__FMT__D_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IPA__RTP__CSD__FMT__D_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
}
}

RSL__IPA__RTP__CSD__FMT__D_template& RSL__IPA__RTP__CSD__FMT__D_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
return value_list.list_value[list_index];
}

void RSL__IPA__RTP__CSD__FMT__D_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(RSL__IPA__RTP__CSD__FMT__D::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IPA__RTP__CSD__FMT__D_template::log_match(const RSL__IPA__RTP__CSD__FMT__D& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void RSL__IPA__RTP__CSD__FMT__D_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
}
}

void RSL__IPA__RTP__CSD__FMT__D_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (RSL__IPA__RTP__CSD__FMT__D::enum_type)text_buf.pull_int().get_val();
if (!RSL__IPA__RTP__CSD__FMT__D::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IPA__RTP__CSD__FMT__D_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
}
}

boolean RSL__IPA__RTP__CSD__FMT__D_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IPA__RTP__CSD__FMT__D_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RSL__IPA__RTP__CSD__FMT__D_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IPA__RTP__CSD__FMT__D_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    RSL__IPA__RTP__CSD__FMT__D::enum_type enum_val = RSL__IPA__RTP__CSD__FMT__D::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!RSL__IPA__RTP__CSD__FMT__D::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IPA__RTP__CSD__FMT__D_template* precondition = new RSL__IPA__RTP__CSD__FMT__D_template;
    precondition->set_param(*m_p->get_elem(0));
    RSL__IPA__RTP__CSD__FMT__D_template* implied_template = new RSL__IPA__RTP__CSD__FMT__D_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = RSL__IPA__RTP__CSD__FMT__D_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@RSL_Types.RSL_IPA_RTP_CSD_FMT_D");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IPA__RTP__CSD__FMT__D_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IPA_RTP_CSD_FMT_D");
}

RSL__IPA__RTP__CSD__FMT__IR::RSL__IPA__RTP__CSD__FMT__IR()
{
enum_value = UNBOUND_VALUE;
}

RSL__IPA__RTP__CSD__FMT__IR::RSL__IPA__RTP__CSD__FMT__IR(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

RSL__IPA__RTP__CSD__FMT__IR::RSL__IPA__RTP__CSD__FMT__IR(enum_type other_value)
{
enum_value = other_value;
}

RSL__IPA__RTP__CSD__FMT__IR::RSL__IPA__RTP__CSD__FMT__IR(const RSL__IPA__RTP__CSD__FMT__IR& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
enum_value = other_value.enum_value;
}

RSL__IPA__RTP__CSD__FMT__IR& RSL__IPA__RTP__CSD__FMT__IR::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

RSL__IPA__RTP__CSD__FMT__IR& RSL__IPA__RTP__CSD__FMT__IR::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

RSL__IPA__RTP__CSD__FMT__IR& RSL__IPA__RTP__CSD__FMT__IR::operator=(const RSL__IPA__RTP__CSD__FMT__IR& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
enum_value = other_value.enum_value;
return *this;
}

boolean RSL__IPA__RTP__CSD__FMT__IR::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__IR::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
return enum_value == other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__IR::operator==(const RSL__IPA__RTP__CSD__FMT__IR& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
return enum_value == other_value.enum_value;
}

boolean RSL__IPA__RTP__CSD__FMT__IR::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__IR::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
return enum_value < other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__IR::operator<(const RSL__IPA__RTP__CSD__FMT__IR& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
return enum_value < other_value.enum_value;
}

boolean RSL__IPA__RTP__CSD__FMT__IR::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__IR::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
return enum_value > other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__IR::operator>(const RSL__IPA__RTP__CSD__FMT__IR& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
return enum_value > other_value.enum_value;
}

const char *RSL__IPA__RTP__CSD__FMT__IR::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case RSL__IPA__RTP__CSD__8k: return "RSL_IPA_RTP_CSD_8k";
case RSL__IPA__RTP__CSD__16k: return "RSL_IPA_RTP_CSD_16k";
case RSL__IPA__RTP__CSD__32k: return "RSL_IPA_RTP_CSD_32k";
case RSL__IPA__RTP__CSD__64: return "RSL_IPA_RTP_CSD_64";
default:
return "<unknown>";
}
}

RSL__IPA__RTP__CSD__FMT__IR::enum_type RSL__IPA__RTP__CSD__FMT__IR::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "RSL_IPA_RTP_CSD_8k")) return RSL__IPA__RTP__CSD__8k;
if (!strcmp(str_par, "RSL_IPA_RTP_CSD_16k")) return RSL__IPA__RTP__CSD__16k;
if (!strcmp(str_par, "RSL_IPA_RTP_CSD_32k")) return RSL__IPA__RTP__CSD__32k;
if (!strcmp(str_par, "RSL_IPA_RTP_CSD_64")) return RSL__IPA__RTP__CSD__64;
}
return UNKNOWN_VALUE;
}

boolean RSL__IPA__RTP__CSD__FMT__IR::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
return TRUE;
default:
return FALSE;
}
}

int RSL__IPA__RTP__CSD__FMT__IR::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int RSL__IPA__RTP__CSD__FMT__IR::enum2int(const RSL__IPA__RTP__CSD__FMT__IR& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void RSL__IPA__RTP__CSD__FMT__IR::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.", int_val);
enum_value = (enum_type)int_val;
}

RSL__IPA__RTP__CSD__FMT__IR::operator RSL__IPA__RTP__CSD__FMT__IR::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
return enum_value;
}

void RSL__IPA__RTP__CSD__FMT__IR::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void RSL__IPA__RTP__CSD__FMT__IR::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@RSL_Types.RSL_IPA_RTP_CSD_FMT_IR");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
  }
}

void RSL__IPA__RTP__CSD__FMT__IR::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
text_buf.push_int(enum_value);
}

void RSL__IPA__RTP__CSD__FMT__IR::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.", enum_value);
}

void RSL__IPA__RTP__CSD__FMT__IR::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IPA__RTP__CSD__FMT__IR::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IPA__RTP__CSD__FMT__IR::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 3, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int RSL__IPA__RTP__CSD__FMT__IR::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 3);
}

void RSL__IPA__RTP__CSD__FMT__IR_template::copy_template(const RSL__IPA__RTP__CSD__FMT__IR_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IPA__RTP__CSD__FMT__IR_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IPA__RTP__CSD__FMT__IR_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IPA__RTP__CSD__FMT__IR_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
}
}

RSL__IPA__RTP__CSD__FMT__IR_template::RSL__IPA__RTP__CSD__FMT__IR_template()
{
}

RSL__IPA__RTP__CSD__FMT__IR_template::RSL__IPA__RTP__CSD__FMT__IR_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IPA__RTP__CSD__FMT__IR_template::RSL__IPA__RTP__CSD__FMT__IR_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!RSL__IPA__RTP__CSD__FMT__IR::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR with unknown numeric value %d.", other_value);
single_value = (RSL__IPA__RTP__CSD__FMT__IR::enum_type)other_value;
}

RSL__IPA__RTP__CSD__FMT__IR_template::RSL__IPA__RTP__CSD__FMT__IR_template(RSL__IPA__RTP__CSD__FMT__IR::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

RSL__IPA__RTP__CSD__FMT__IR_template::RSL__IPA__RTP__CSD__FMT__IR_template(const RSL__IPA__RTP__CSD__FMT__IR& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == RSL__IPA__RTP__CSD__FMT__IR::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
single_value = other_value.enum_value;
}

RSL__IPA__RTP__CSD__FMT__IR_template::RSL__IPA__RTP__CSD__FMT__IR_template(const OPTIONAL<RSL__IPA__RTP__CSD__FMT__IR>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__RTP__CSD__FMT__IR::enum_type)(const RSL__IPA__RTP__CSD__FMT__IR&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR from an unbound optional field.");
}
}

RSL__IPA__RTP__CSD__FMT__IR_template::RSL__IPA__RTP__CSD__FMT__IR_template(RSL__IPA__RTP__CSD__FMT__IR_template* p_precondition, RSL__IPA__RTP__CSD__FMT__IR_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IPA__RTP__CSD__FMT__IR_template::RSL__IPA__RTP__CSD__FMT__IR_template(Dynamic_Match_Interface<RSL__IPA__RTP__CSD__FMT__IR>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IPA__RTP__CSD__FMT__IR>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IPA__RTP__CSD__FMT__IR_template::RSL__IPA__RTP__CSD__FMT__IR_template(const RSL__IPA__RTP__CSD__FMT__IR_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

RSL__IPA__RTP__CSD__FMT__IR_template::~RSL__IPA__RTP__CSD__FMT__IR_template()
{
clean_up();
}

boolean RSL__IPA__RTP__CSD__FMT__IR_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean RSL__IPA__RTP__CSD__FMT__IR_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != RSL__IPA__RTP__CSD__FMT__IR::UNBOUND_VALUE;
}

void RSL__IPA__RTP__CSD__FMT__IR_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IPA__RTP__CSD__FMT__IR_template& RSL__IPA__RTP__CSD__FMT__IR_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IPA__RTP__CSD__FMT__IR_template& RSL__IPA__RTP__CSD__FMT__IR_template::operator=(int other_value)
{
if (!RSL__IPA__RTP__CSD__FMT__IR::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__RTP__CSD__FMT__IR::enum_type)other_value;
return *this;
}

RSL__IPA__RTP__CSD__FMT__IR_template& RSL__IPA__RTP__CSD__FMT__IR_template::operator=(RSL__IPA__RTP__CSD__FMT__IR::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

RSL__IPA__RTP__CSD__FMT__IR_template& RSL__IPA__RTP__CSD__FMT__IR_template::operator=(const RSL__IPA__RTP__CSD__FMT__IR& other_value)
{
if (other_value.enum_value == RSL__IPA__RTP__CSD__FMT__IR::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

RSL__IPA__RTP__CSD__FMT__IR_template& RSL__IPA__RTP__CSD__FMT__IR_template::operator=(const OPTIONAL<RSL__IPA__RTP__CSD__FMT__IR>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__RTP__CSD__FMT__IR::enum_type)(const RSL__IPA__RTP__CSD__FMT__IR&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
}
return *this;
}

RSL__IPA__RTP__CSD__FMT__IR_template& RSL__IPA__RTP__CSD__FMT__IR_template::operator=(const RSL__IPA__RTP__CSD__FMT__IR_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IPA__RTP__CSD__FMT__IR_template::match(RSL__IPA__RTP__CSD__FMT__IR::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
}
return FALSE;
}

boolean RSL__IPA__RTP__CSD__FMT__IR_template::match(const RSL__IPA__RTP__CSD__FMT__IR& other_value, boolean) const
{
if (other_value.enum_value == RSL__IPA__RTP__CSD__FMT__IR::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR with an unbound value.");
return match(other_value.enum_value);
}

RSL__IPA__RTP__CSD__FMT__IR::enum_type RSL__IPA__RTP__CSD__FMT__IR_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
return single_value;
}

void RSL__IPA__RTP__CSD__FMT__IR_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IPA__RTP__CSD__FMT__IR_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
}
}

RSL__IPA__RTP__CSD__FMT__IR_template& RSL__IPA__RTP__CSD__FMT__IR_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
return value_list.list_value[list_index];
}

void RSL__IPA__RTP__CSD__FMT__IR_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(RSL__IPA__RTP__CSD__FMT__IR::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IPA__RTP__CSD__FMT__IR_template::log_match(const RSL__IPA__RTP__CSD__FMT__IR& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void RSL__IPA__RTP__CSD__FMT__IR_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
}
}

void RSL__IPA__RTP__CSD__FMT__IR_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (RSL__IPA__RTP__CSD__FMT__IR::enum_type)text_buf.pull_int().get_val();
if (!RSL__IPA__RTP__CSD__FMT__IR::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IPA__RTP__CSD__FMT__IR_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
}
}

boolean RSL__IPA__RTP__CSD__FMT__IR_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IPA__RTP__CSD__FMT__IR_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RSL__IPA__RTP__CSD__FMT__IR_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IPA__RTP__CSD__FMT__IR_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    RSL__IPA__RTP__CSD__FMT__IR::enum_type enum_val = RSL__IPA__RTP__CSD__FMT__IR::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!RSL__IPA__RTP__CSD__FMT__IR::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IPA__RTP__CSD__FMT__IR_template* precondition = new RSL__IPA__RTP__CSD__FMT__IR_template;
    precondition->set_param(*m_p->get_elem(0));
    RSL__IPA__RTP__CSD__FMT__IR_template* implied_template = new RSL__IPA__RTP__CSD__FMT__IR_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = RSL__IPA__RTP__CSD__FMT__IR_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@RSL_Types.RSL_IPA_RTP_CSD_FMT_IR");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IPA__RTP__CSD__FMT__IR_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IPA_RTP_CSD_FMT_IR");
}

RSL__IE__IPA__RTP__CSD__FMT::RSL__IE__IPA__RTP__CSD__FMT()
{
}

RSL__IE__IPA__RTP__CSD__FMT::RSL__IE__IPA__RTP__CSD__FMT(const RSL__IPA__RTP__CSD__FMT__IR& par_ir,
    const RSL__IPA__RTP__CSD__FMT__D& par_d)
  :   field_ir(par_ir),
  field_d(par_d)
{
}

RSL__IE__IPA__RTP__CSD__FMT::RSL__IE__IPA__RTP__CSD__FMT(const RSL__IE__IPA__RTP__CSD__FMT& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
if (other_value.ir().is_bound()) field_ir = other_value.ir();
else field_ir.clean_up();
if (other_value.d().is_bound()) field_d = other_value.d();
else field_d.clean_up();
}

void RSL__IE__IPA__RTP__CSD__FMT::clean_up()
{
field_ir.clean_up();
field_d.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__IPA__RTP__CSD__FMT::get_descriptor() const { return &RSL__IE__IPA__RTP__CSD__FMT_descr_; }
RSL__IE__IPA__RTP__CSD__FMT& RSL__IE__IPA__RTP__CSD__FMT::operator=(const RSL__IE__IPA__RTP__CSD__FMT& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
  if (other_value.ir().is_bound()) field_ir = other_value.ir();
  else field_ir.clean_up();
  if (other_value.d().is_bound()) field_d = other_value.d();
  else field_d.clean_up();
}
return *this;
}

boolean RSL__IE__IPA__RTP__CSD__FMT::operator==(const RSL__IE__IPA__RTP__CSD__FMT& other_value) const
{
return field_ir==other_value.field_ir
  && field_d==other_value.field_d;
}

boolean RSL__IE__IPA__RTP__CSD__FMT::is_bound() const
{
return (field_ir.is_bound())
  || (field_d.is_bound());
}
boolean RSL__IE__IPA__RTP__CSD__FMT::is_value() const
{
return field_ir.is_value()
  && field_d.is_value();
}
void RSL__IE__IPA__RTP__CSD__FMT::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ ir := ");
field_ir.log();
TTCN_Logger::log_event_str(", d := ");
field_d.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__IPA__RTP__CSD__FMT::set_implicit_omit()
{
if (ir().is_bound()) ir().set_implicit_omit();
if (d().is_bound()) d().set_implicit_omit();
}

void RSL__IE__IPA__RTP__CSD__FMT::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) ir().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) d().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ir")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ir().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "d")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          d().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_IPA_RTP_CSD_FMT");
  }
}

void RSL__IE__IPA__RTP__CSD__FMT::encode_text(Text_Buf& text_buf) const
{
field_ir.encode_text(text_buf);
field_d.encode_text(text_buf);
}

void RSL__IE__IPA__RTP__CSD__FMT::decode_text(Text_Buf& text_buf)
{
field_ir.decode_text(text_buf);
field_d.decode_text(text_buf);
}

void RSL__IE__IPA__RTP__CSD__FMT::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__IPA__RTP__CSD__FMT::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__IPA__RTP__CSD__FMT::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__IPA__RTP__CSD__FMT_ir_descr_.raw->forceomit);
  decoded_field_length = field_ir.RAW_decode(RSL__IE__IPA__RTP__CSD__FMT_ir_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__IPA__RTP__CSD__FMT_d_descr_.raw->forceomit);
  decoded_field_length = field_d.RAW_decode(RSL__IE__IPA__RTP__CSD__FMT_d_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__IPA__RTP__CSD__FMT::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__IPA__RTP__CSD__FMT_ir_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__IPA__RTP__CSD__FMT_d_descr_.raw);
  encoded_length += field_ir.RAW_encode(RSL__IE__IPA__RTP__CSD__FMT_ir_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_d.RAW_encode(RSL__IE__IPA__RTP__CSD__FMT_d_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__IPA__RTP__CSD__FMT_template::single_value_struct {
RSL__IPA__RTP__CSD__FMT__IR_template field_ir;
RSL__IPA__RTP__CSD__FMT__D_template field_d;
};

void RSL__IE__IPA__RTP__CSD__FMT_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_ir = ANY_VALUE;
single_value->field_d = ANY_VALUE;
}
}
}

void RSL__IE__IPA__RTP__CSD__FMT_template::copy_value(const RSL__IE__IPA__RTP__CSD__FMT& other_value)
{
single_value = new single_value_struct;
if (other_value.ir().is_bound()) {
  single_value->field_ir = other_value.ir();
} else {
  single_value->field_ir.clean_up();
}
if (other_value.d().is_bound()) {
  single_value->field_d = other_value.d();
} else {
  single_value->field_d.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__IPA__RTP__CSD__FMT_template::copy_template(const RSL__IE__IPA__RTP__CSD__FMT_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.ir().get_selection()) {
single_value->field_ir = other_value.ir();
} else {
single_value->field_ir.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.d().get_selection()) {
single_value->field_d = other_value.d();
} else {
single_value->field_d.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__IPA__RTP__CSD__FMT_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__IPA__RTP__CSD__FMT_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__IPA__RTP__CSD__FMT_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
break;
}
set_selection(other_value);
}

RSL__IE__IPA__RTP__CSD__FMT_template::RSL__IE__IPA__RTP__CSD__FMT_template()
{
}

RSL__IE__IPA__RTP__CSD__FMT_template::RSL__IE__IPA__RTP__CSD__FMT_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__IPA__RTP__CSD__FMT_template::RSL__IE__IPA__RTP__CSD__FMT_template(const RSL__IE__IPA__RTP__CSD__FMT& other_value)
{
copy_value(other_value);
}

RSL__IE__IPA__RTP__CSD__FMT_template::RSL__IE__IPA__RTP__CSD__FMT_template(const OPTIONAL<RSL__IE__IPA__RTP__CSD__FMT>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__IPA__RTP__CSD__FMT&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT from an unbound optional field.");
}
}

RSL__IE__IPA__RTP__CSD__FMT_template::RSL__IE__IPA__RTP__CSD__FMT_template(RSL__IE__IPA__RTP__CSD__FMT_template* p_precondition, RSL__IE__IPA__RTP__CSD__FMT_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__IPA__RTP__CSD__FMT_template::RSL__IE__IPA__RTP__CSD__FMT_template(Dynamic_Match_Interface<RSL__IE__IPA__RTP__CSD__FMT>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__IPA__RTP__CSD__FMT>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__IPA__RTP__CSD__FMT_template::RSL__IE__IPA__RTP__CSD__FMT_template(const RSL__IE__IPA__RTP__CSD__FMT_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__IPA__RTP__CSD__FMT_template::~RSL__IE__IPA__RTP__CSD__FMT_template()
{
clean_up();
}

RSL__IE__IPA__RTP__CSD__FMT_template& RSL__IE__IPA__RTP__CSD__FMT_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__IPA__RTP__CSD__FMT_template& RSL__IE__IPA__RTP__CSD__FMT_template::operator=(const RSL__IE__IPA__RTP__CSD__FMT& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__IPA__RTP__CSD__FMT_template& RSL__IE__IPA__RTP__CSD__FMT_template::operator=(const OPTIONAL<RSL__IE__IPA__RTP__CSD__FMT>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__IPA__RTP__CSD__FMT&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
}
return *this;
}

RSL__IE__IPA__RTP__CSD__FMT_template& RSL__IE__IPA__RTP__CSD__FMT_template::operator=(const RSL__IE__IPA__RTP__CSD__FMT_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__IPA__RTP__CSD__FMT_template::match(const RSL__IE__IPA__RTP__CSD__FMT& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.ir().is_bound()) return FALSE;
if(!single_value->field_ir.match(other_value.ir(), legacy))return FALSE;
if(!other_value.d().is_bound()) return FALSE;
if(!single_value->field_d.match(other_value.d(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
}
return FALSE;
}

boolean RSL__IE__IPA__RTP__CSD__FMT_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_ir.is_bound()
 || single_value->field_d.is_bound();
}

boolean RSL__IE__IPA__RTP__CSD__FMT_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_ir.is_value()
 && single_value->field_d.is_value();
}

void RSL__IE__IPA__RTP__CSD__FMT_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__IPA__RTP__CSD__FMT RSL__IE__IPA__RTP__CSD__FMT_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
RSL__IE__IPA__RTP__CSD__FMT ret_val;
if (single_value->field_ir.is_bound()) {
ret_val.ir() = single_value->field_ir.valueof();
}
if (single_value->field_d.is_bound()) {
ret_val.d() = single_value->field_d.valueof();
}
return ret_val;
}

void RSL__IE__IPA__RTP__CSD__FMT_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__IPA__RTP__CSD__FMT_template[list_length];
}

RSL__IE__IPA__RTP__CSD__FMT_template& RSL__IE__IPA__RTP__CSD__FMT_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
return value_list.list_value[list_index];
}

RSL__IPA__RTP__CSD__FMT__IR_template& RSL__IE__IPA__RTP__CSD__FMT_template::ir()
{
set_specific();
return single_value->field_ir;
}

const RSL__IPA__RTP__CSD__FMT__IR_template& RSL__IE__IPA__RTP__CSD__FMT_template::ir() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ir of a non-specific template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
return single_value->field_ir;
}

RSL__IPA__RTP__CSD__FMT__D_template& RSL__IE__IPA__RTP__CSD__FMT_template::d()
{
set_specific();
return single_value->field_d;
}

const RSL__IPA__RTP__CSD__FMT__D_template& RSL__IE__IPA__RTP__CSD__FMT_template::d() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field d of a non-specific template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
return single_value->field_d;
}

int RSL__IE__IPA__RTP__CSD__FMT_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
  }
  return 0;
}

void RSL__IE__IPA__RTP__CSD__FMT_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ ir := ");
single_value->field_ir.log();
TTCN_Logger::log_event_str(", d := ");
single_value->field_d.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__IPA__RTP__CSD__FMT_template::log_match(const RSL__IE__IPA__RTP__CSD__FMT& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_ir.match(match_value.ir(), legacy)){
TTCN_Logger::log_logmatch_info(".ir");
single_value->field_ir.log_match(match_value.ir(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_d.match(match_value.d(), legacy)){
TTCN_Logger::log_logmatch_info(".d");
single_value->field_d.log_match(match_value.d(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ ir := ");
single_value->field_ir.log_match(match_value.ir(), legacy);
TTCN_Logger::log_event_str(", d := ");
single_value->field_d.log_match(match_value.d(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__IPA__RTP__CSD__FMT_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (ir().is_bound()) ir().set_implicit_omit();
if (d().is_bound()) d().set_implicit_omit();
}

void RSL__IE__IPA__RTP__CSD__FMT_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_ir.encode_text(text_buf);
single_value->field_d.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
}
}

void RSL__IE__IPA__RTP__CSD__FMT_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_ir.decode_text(text_buf);
single_value->field_d.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__IPA__RTP__CSD__FMT_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
}
}

void RSL__IE__IPA__RTP__CSD__FMT_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__IPA__RTP__CSD__FMT_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) ir().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) d().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ir")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ir().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "d")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          d().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__IPA__RTP__CSD__FMT_template* precondition = new RSL__IE__IPA__RTP__CSD__FMT_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__IPA__RTP__CSD__FMT_template* implied_template = new RSL__IE__IPA__RTP__CSD__FMT_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__IPA__RTP__CSD__FMT_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_IPA_RTP_CSD_FMT");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__IPA__RTP__CSD__FMT_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_ir.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_RTP_CSD_FMT");
single_value->field_d.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_RTP_CSD_FMT");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_IPA_RTP_CSD_FMT");
}

boolean RSL__IE__IPA__RTP__CSD__FMT_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__IPA__RTP__CSD__FMT_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IE__ReleaseMode::RSL__IE__ReleaseMode()
{
enum_value = UNBOUND_VALUE;
}

RSL__IE__ReleaseMode::RSL__IE__ReleaseMode(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @RSL_Types.RSL_IE_ReleaseMode with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

RSL__IE__ReleaseMode::RSL__IE__ReleaseMode(enum_type other_value)
{
enum_value = other_value;
}

RSL__IE__ReleaseMode::RSL__IE__ReleaseMode(const RSL__IE__ReleaseMode& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
enum_value = other_value.enum_value;
}

RSL__IE__ReleaseMode& RSL__IE__ReleaseMode::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @RSL_Types.RSL_IE_ReleaseMode.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

RSL__IE__ReleaseMode& RSL__IE__ReleaseMode::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

RSL__IE__ReleaseMode& RSL__IE__ReleaseMode::operator=(const RSL__IE__ReleaseMode& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
enum_value = other_value.enum_value;
return *this;
}

boolean RSL__IE__ReleaseMode::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IE_ReleaseMode comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean RSL__IE__ReleaseMode::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
return enum_value == other_value;
}

boolean RSL__IE__ReleaseMode::operator==(const RSL__IE__ReleaseMode& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
return enum_value == other_value.enum_value;
}

boolean RSL__IE__ReleaseMode::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IE_ReleaseMode comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean RSL__IE__ReleaseMode::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
return enum_value < other_value;
}

boolean RSL__IE__ReleaseMode::operator<(const RSL__IE__ReleaseMode& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
return enum_value < other_value.enum_value;
}

boolean RSL__IE__ReleaseMode::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IE_ReleaseMode comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean RSL__IE__ReleaseMode::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
return enum_value > other_value;
}

boolean RSL__IE__ReleaseMode::operator>(const RSL__IE__ReleaseMode& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
return enum_value > other_value.enum_value;
}

const char *RSL__IE__ReleaseMode::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case RSL__REL__MODE__NORMAL: return "RSL_REL_MODE_NORMAL";
case RSL__REL__MODE__LOCAL: return "RSL_REL_MODE_LOCAL";
default:
return "<unknown>";
}
}

RSL__IE__ReleaseMode::enum_type RSL__IE__ReleaseMode::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "RSL_REL_MODE_NORMAL")) return RSL__REL__MODE__NORMAL;
if (!strcmp(str_par, "RSL_REL_MODE_LOCAL")) return RSL__REL__MODE__LOCAL;
}
return UNKNOWN_VALUE;
}

boolean RSL__IE__ReleaseMode::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
return TRUE;
default:
return FALSE;
}
}

int RSL__IE__ReleaseMode::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int RSL__IE__ReleaseMode::enum2int(const RSL__IE__ReleaseMode& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void RSL__IE__ReleaseMode::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @RSL_Types.RSL_IE_ReleaseMode.", int_val);
enum_value = (enum_type)int_val;
}

RSL__IE__ReleaseMode::operator RSL__IE__ReleaseMode::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
return enum_value;
}

void RSL__IE__ReleaseMode::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void RSL__IE__ReleaseMode::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@RSL_Types.RSL_IE_ReleaseMode");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @RSL_Types.RSL_IE_ReleaseMode.");
  }
}

void RSL__IE__ReleaseMode::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
text_buf.push_int(enum_value);
}

void RSL__IE__ReleaseMode::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @RSL_Types.RSL_IE_ReleaseMode.", enum_value);
}

void RSL__IE__ReleaseMode::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__ReleaseMode::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__ReleaseMode::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int RSL__IE__ReleaseMode::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void RSL__IE__ReleaseMode_template::copy_template(const RSL__IE__ReleaseMode_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__ReleaseMode_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__ReleaseMode_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__ReleaseMode_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
}
}

RSL__IE__ReleaseMode_template::RSL__IE__ReleaseMode_template()
{
}

RSL__IE__ReleaseMode_template::RSL__IE__ReleaseMode_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__ReleaseMode_template::RSL__IE__ReleaseMode_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!RSL__IE__ReleaseMode::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @RSL_Types.RSL_IE_ReleaseMode with unknown numeric value %d.", other_value);
single_value = (RSL__IE__ReleaseMode::enum_type)other_value;
}

RSL__IE__ReleaseMode_template::RSL__IE__ReleaseMode_template(RSL__IE__ReleaseMode::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

RSL__IE__ReleaseMode_template::RSL__IE__ReleaseMode_template(const RSL__IE__ReleaseMode& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == RSL__IE__ReleaseMode::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
single_value = other_value.enum_value;
}

RSL__IE__ReleaseMode_template::RSL__IE__ReleaseMode_template(const OPTIONAL<RSL__IE__ReleaseMode>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IE__ReleaseMode::enum_type)(const RSL__IE__ReleaseMode&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @RSL_Types.RSL_IE_ReleaseMode from an unbound optional field.");
}
}

RSL__IE__ReleaseMode_template::RSL__IE__ReleaseMode_template(RSL__IE__ReleaseMode_template* p_precondition, RSL__IE__ReleaseMode_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__ReleaseMode_template::RSL__IE__ReleaseMode_template(Dynamic_Match_Interface<RSL__IE__ReleaseMode>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__ReleaseMode>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__ReleaseMode_template::RSL__IE__ReleaseMode_template(const RSL__IE__ReleaseMode_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

RSL__IE__ReleaseMode_template::~RSL__IE__ReleaseMode_template()
{
clean_up();
}

boolean RSL__IE__ReleaseMode_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean RSL__IE__ReleaseMode_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != RSL__IE__ReleaseMode::UNBOUND_VALUE;
}

void RSL__IE__ReleaseMode_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__ReleaseMode_template& RSL__IE__ReleaseMode_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__ReleaseMode_template& RSL__IE__ReleaseMode_template::operator=(int other_value)
{
if (!RSL__IE__ReleaseMode::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @RSL_Types.RSL_IE_ReleaseMode.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IE__ReleaseMode::enum_type)other_value;
return *this;
}

RSL__IE__ReleaseMode_template& RSL__IE__ReleaseMode_template::operator=(RSL__IE__ReleaseMode::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

RSL__IE__ReleaseMode_template& RSL__IE__ReleaseMode_template::operator=(const RSL__IE__ReleaseMode& other_value)
{
if (other_value.enum_value == RSL__IE__ReleaseMode::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

RSL__IE__ReleaseMode_template& RSL__IE__ReleaseMode_template::operator=(const OPTIONAL<RSL__IE__ReleaseMode>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IE__ReleaseMode::enum_type)(const RSL__IE__ReleaseMode&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
}
return *this;
}

RSL__IE__ReleaseMode_template& RSL__IE__ReleaseMode_template::operator=(const RSL__IE__ReleaseMode_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__ReleaseMode_template::match(RSL__IE__ReleaseMode::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
}
return FALSE;
}

boolean RSL__IE__ReleaseMode_template::match(const RSL__IE__ReleaseMode& other_value, boolean) const
{
if (other_value.enum_value == RSL__IE__ReleaseMode::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @RSL_Types.RSL_IE_ReleaseMode with an unbound value.");
return match(other_value.enum_value);
}

RSL__IE__ReleaseMode::enum_type RSL__IE__ReleaseMode_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
return single_value;
}

void RSL__IE__ReleaseMode_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__ReleaseMode_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
}
}

RSL__IE__ReleaseMode_template& RSL__IE__ReleaseMode_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
return value_list.list_value[list_index];
}

void RSL__IE__ReleaseMode_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(RSL__IE__ReleaseMode::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__ReleaseMode_template::log_match(const RSL__IE__ReleaseMode& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void RSL__IE__ReleaseMode_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
}
}

void RSL__IE__ReleaseMode_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (RSL__IE__ReleaseMode::enum_type)text_buf.pull_int().get_val();
if (!RSL__IE__ReleaseMode::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @RSL_Types.RSL_IE_ReleaseMode.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__ReleaseMode_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
}
}

boolean RSL__IE__ReleaseMode_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__ReleaseMode_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RSL__IE__ReleaseMode_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__ReleaseMode_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    RSL__IE__ReleaseMode::enum_type enum_val = RSL__IE__ReleaseMode::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!RSL__IE__ReleaseMode::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @RSL_Types.RSL_IE_ReleaseMode.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__ReleaseMode_template* precondition = new RSL__IE__ReleaseMode_template;
    precondition->set_param(*m_p->get_elem(0));
    RSL__IE__ReleaseMode_template* implied_template = new RSL__IE__ReleaseMode_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = RSL__IE__ReleaseMode_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@RSL_Types.RSL_IE_ReleaseMode");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__ReleaseMode_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_ReleaseMode");
}

RSL__IE__OSMO__TrainingSequence::RSL__IE__OSMO__TrainingSequence()
{
}

RSL__IE__OSMO__TrainingSequence::RSL__IE__OSMO__TrainingSequence(const INTEGER& par_len,
    const INTEGER& par_tsc__set,
    const INTEGER& par_tsc)
  :   field_len(par_len),
  field_tsc__set(par_tsc__set),
  field_tsc(par_tsc)
{
}

RSL__IE__OSMO__TrainingSequence::RSL__IE__OSMO__TrainingSequence(const RSL__IE__OSMO__TrainingSequence& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.tsc__set().is_bound()) field_tsc__set = other_value.tsc__set();
else field_tsc__set.clean_up();
if (other_value.tsc().is_bound()) field_tsc = other_value.tsc();
else field_tsc.clean_up();
}

void RSL__IE__OSMO__TrainingSequence::clean_up()
{
field_len.clean_up();
field_tsc__set.clean_up();
field_tsc.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__OSMO__TrainingSequence::get_descriptor() const { return &RSL__IE__OSMO__TrainingSequence_descr_; }
RSL__IE__OSMO__TrainingSequence& RSL__IE__OSMO__TrainingSequence::operator=(const RSL__IE__OSMO__TrainingSequence& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.tsc__set().is_bound()) field_tsc__set = other_value.tsc__set();
  else field_tsc__set.clean_up();
  if (other_value.tsc().is_bound()) field_tsc = other_value.tsc();
  else field_tsc.clean_up();
}
return *this;
}

boolean RSL__IE__OSMO__TrainingSequence::operator==(const RSL__IE__OSMO__TrainingSequence& other_value) const
{
return field_len==other_value.field_len
  && field_tsc__set==other_value.field_tsc__set
  && field_tsc==other_value.field_tsc;
}

boolean RSL__IE__OSMO__TrainingSequence::is_bound() const
{
return (field_len.is_bound())
  || (field_tsc__set.is_bound())
  || (field_tsc.is_bound());
}
boolean RSL__IE__OSMO__TrainingSequence::is_value() const
{
return field_len.is_value()
  && field_tsc__set.is_value()
  && field_tsc.is_value();
}
void RSL__IE__OSMO__TrainingSequence::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len := ");
field_len.log();
TTCN_Logger::log_event_str(", tsc_set := ");
field_tsc__set.log();
TTCN_Logger::log_event_str(", tsc := ");
field_tsc.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__OSMO__TrainingSequence::set_implicit_omit()
{
if (len().is_bound()) len().set_implicit_omit();
if (tsc__set().is_bound()) tsc__set().set_implicit_omit();
if (tsc().is_bound()) tsc().set_implicit_omit();
}

void RSL__IE__OSMO__TrainingSequence::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_OSMO_TrainingSequence has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) tsc__set().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) tsc().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tsc_set")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tsc__set().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tsc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tsc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_OSMO_TrainingSequence: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_OSMO_TrainingSequence");
  }
}

void RSL__IE__OSMO__TrainingSequence::encode_text(Text_Buf& text_buf) const
{
field_len.encode_text(text_buf);
field_tsc__set.encode_text(text_buf);
field_tsc.encode_text(text_buf);
}

void RSL__IE__OSMO__TrainingSequence::decode_text(Text_Buf& text_buf)
{
field_len.decode_text(text_buf);
field_tsc__set.decode_text(text_buf);
field_tsc.decode_text(text_buf);
}

void RSL__IE__OSMO__TrainingSequence::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__OSMO__TrainingSequence::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__OSMO__TrainingSequence::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__OSMO__TrainingSequence_len_descr_.raw->forceomit);
  decoded_field_length = field_len.RAW_decode(RSL__IE__OSMO__TrainingSequence_len_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_len.convert_to_Integer(RSL__IE__OSMO__TrainingSequence_len_descr_);
  field_len = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__OSMO__TrainingSequence_tsc__set_descr_.raw->forceomit);
  decoded_field_length = field_tsc__set.RAW_decode(RSL__IE__OSMO__TrainingSequence_tsc__set_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RSL__IE__OSMO__TrainingSequence_tsc_descr_.raw->forceomit);
  decoded_field_length = field_tsc.RAW_decode(RSL__IE__OSMO__TrainingSequence_tsc_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__OSMO__TrainingSequence::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__OSMO__TrainingSequence_len_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__OSMO__TrainingSequence_tsc__set_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RSL__IE__OSMO__TrainingSequence_tsc_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &RSL__IE__OSMO__TrainingSequence_len_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 2;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(2);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_tsc__set.RAW_encode(RSL__IE__OSMO__TrainingSequence_tsc__set_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_tsc.RAW_encode(RSL__IE__OSMO__TrainingSequence_tsc_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__OSMO__TrainingSequence_template::single_value_struct {
INTEGER_template field_len;
INTEGER_template field_tsc__set;
INTEGER_template field_tsc;
};

void RSL__IE__OSMO__TrainingSequence_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_len = ANY_VALUE;
single_value->field_tsc__set = ANY_VALUE;
single_value->field_tsc = ANY_VALUE;
}
}
}

void RSL__IE__OSMO__TrainingSequence_template::copy_value(const RSL__IE__OSMO__TrainingSequence& other_value)
{
single_value = new single_value_struct;
if (other_value.len().is_bound()) {
  single_value->field_len = other_value.len();
} else {
  single_value->field_len.clean_up();
}
if (other_value.tsc__set().is_bound()) {
  single_value->field_tsc__set = other_value.tsc__set();
} else {
  single_value->field_tsc__set.clean_up();
}
if (other_value.tsc().is_bound()) {
  single_value->field_tsc = other_value.tsc();
} else {
  single_value->field_tsc.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__OSMO__TrainingSequence_template::copy_template(const RSL__IE__OSMO__TrainingSequence_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.len().get_selection()) {
single_value->field_len = other_value.len();
} else {
single_value->field_len.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tsc__set().get_selection()) {
single_value->field_tsc__set = other_value.tsc__set();
} else {
single_value->field_tsc__set.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tsc().get_selection()) {
single_value->field_tsc = other_value.tsc();
} else {
single_value->field_tsc.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__OSMO__TrainingSequence_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__OSMO__TrainingSequence_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__OSMO__TrainingSequence_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
break;
}
set_selection(other_value);
}

RSL__IE__OSMO__TrainingSequence_template::RSL__IE__OSMO__TrainingSequence_template()
{
}

RSL__IE__OSMO__TrainingSequence_template::RSL__IE__OSMO__TrainingSequence_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__OSMO__TrainingSequence_template::RSL__IE__OSMO__TrainingSequence_template(const RSL__IE__OSMO__TrainingSequence& other_value)
{
copy_value(other_value);
}

RSL__IE__OSMO__TrainingSequence_template::RSL__IE__OSMO__TrainingSequence_template(const OPTIONAL<RSL__IE__OSMO__TrainingSequence>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__OSMO__TrainingSequence&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence from an unbound optional field.");
}
}

RSL__IE__OSMO__TrainingSequence_template::RSL__IE__OSMO__TrainingSequence_template(RSL__IE__OSMO__TrainingSequence_template* p_precondition, RSL__IE__OSMO__TrainingSequence_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__OSMO__TrainingSequence_template::RSL__IE__OSMO__TrainingSequence_template(Dynamic_Match_Interface<RSL__IE__OSMO__TrainingSequence>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__OSMO__TrainingSequence>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__OSMO__TrainingSequence_template::RSL__IE__OSMO__TrainingSequence_template(const RSL__IE__OSMO__TrainingSequence_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__OSMO__TrainingSequence_template::~RSL__IE__OSMO__TrainingSequence_template()
{
clean_up();
}

RSL__IE__OSMO__TrainingSequence_template& RSL__IE__OSMO__TrainingSequence_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__OSMO__TrainingSequence_template& RSL__IE__OSMO__TrainingSequence_template::operator=(const RSL__IE__OSMO__TrainingSequence& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__OSMO__TrainingSequence_template& RSL__IE__OSMO__TrainingSequence_template::operator=(const OPTIONAL<RSL__IE__OSMO__TrainingSequence>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__OSMO__TrainingSequence&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
}
return *this;
}

RSL__IE__OSMO__TrainingSequence_template& RSL__IE__OSMO__TrainingSequence_template::operator=(const RSL__IE__OSMO__TrainingSequence_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__OSMO__TrainingSequence_template::match(const RSL__IE__OSMO__TrainingSequence& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.len().is_bound()) return FALSE;
if(!single_value->field_len.match(other_value.len(), legacy))return FALSE;
if(!other_value.tsc__set().is_bound()) return FALSE;
if(!single_value->field_tsc__set.match(other_value.tsc__set(), legacy))return FALSE;
if(!other_value.tsc().is_bound()) return FALSE;
if(!single_value->field_tsc.match(other_value.tsc(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
}
return FALSE;
}

boolean RSL__IE__OSMO__TrainingSequence_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_len.is_bound()
 || single_value->field_tsc__set.is_bound()
 || single_value->field_tsc.is_bound();
}

boolean RSL__IE__OSMO__TrainingSequence_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_len.is_value()
 && single_value->field_tsc__set.is_value()
 && single_value->field_tsc.is_value();
}

void RSL__IE__OSMO__TrainingSequence_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__OSMO__TrainingSequence RSL__IE__OSMO__TrainingSequence_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
RSL__IE__OSMO__TrainingSequence ret_val;
if (single_value->field_len.is_bound()) {
ret_val.len() = single_value->field_len.valueof();
}
if (single_value->field_tsc__set.is_bound()) {
ret_val.tsc__set() = single_value->field_tsc__set.valueof();
}
if (single_value->field_tsc.is_bound()) {
ret_val.tsc() = single_value->field_tsc.valueof();
}
return ret_val;
}

void RSL__IE__OSMO__TrainingSequence_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__OSMO__TrainingSequence_template[list_length];
}

RSL__IE__OSMO__TrainingSequence_template& RSL__IE__OSMO__TrainingSequence_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__OSMO__TrainingSequence_template::len()
{
set_specific();
return single_value->field_len;
}

const INTEGER_template& RSL__IE__OSMO__TrainingSequence_template::len() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len of a non-specific template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
return single_value->field_len;
}

INTEGER_template& RSL__IE__OSMO__TrainingSequence_template::tsc__set()
{
set_specific();
return single_value->field_tsc__set;
}

const INTEGER_template& RSL__IE__OSMO__TrainingSequence_template::tsc__set() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tsc_set of a non-specific template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
return single_value->field_tsc__set;
}

INTEGER_template& RSL__IE__OSMO__TrainingSequence_template::tsc()
{
set_specific();
return single_value->field_tsc;
}

const INTEGER_template& RSL__IE__OSMO__TrainingSequence_template::tsc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tsc of a non-specific template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
return single_value->field_tsc;
}

int RSL__IE__OSMO__TrainingSequence_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
  }
  return 0;
}

void RSL__IE__OSMO__TrainingSequence_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log();
TTCN_Logger::log_event_str(", tsc_set := ");
single_value->field_tsc__set.log();
TTCN_Logger::log_event_str(", tsc := ");
single_value->field_tsc.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__OSMO__TrainingSequence_template::log_match(const RSL__IE__OSMO__TrainingSequence& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_len.match(match_value.len(), legacy)){
TTCN_Logger::log_logmatch_info(".len");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_tsc__set.match(match_value.tsc__set(), legacy)){
TTCN_Logger::log_logmatch_info(".tsc_set");
single_value->field_tsc__set.log_match(match_value.tsc__set(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_tsc.match(match_value.tsc(), legacy)){
TTCN_Logger::log_logmatch_info(".tsc");
single_value->field_tsc.log_match(match_value.tsc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::log_event_str(", tsc_set := ");
single_value->field_tsc__set.log_match(match_value.tsc__set(), legacy);
TTCN_Logger::log_event_str(", tsc := ");
single_value->field_tsc.log_match(match_value.tsc(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__OSMO__TrainingSequence_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (len().is_bound()) len().set_implicit_omit();
if (tsc__set().is_bound()) tsc__set().set_implicit_omit();
if (tsc().is_bound()) tsc().set_implicit_omit();
}

void RSL__IE__OSMO__TrainingSequence_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_len.encode_text(text_buf);
single_value->field_tsc__set.encode_text(text_buf);
single_value->field_tsc.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
}
}

void RSL__IE__OSMO__TrainingSequence_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_len.decode_text(text_buf);
single_value->field_tsc__set.decode_text(text_buf);
single_value->field_tsc.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__OSMO__TrainingSequence_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
}
}

void RSL__IE__OSMO__TrainingSequence_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__OSMO__TrainingSequence_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) tsc__set().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) tsc().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tsc_set")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tsc__set().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tsc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tsc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_OSMO_TrainingSequence: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__OSMO__TrainingSequence_template* precondition = new RSL__IE__OSMO__TrainingSequence_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__OSMO__TrainingSequence_template* implied_template = new RSL__IE__OSMO__TrainingSequence_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__OSMO__TrainingSequence_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_OSMO_TrainingSequence");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__OSMO__TrainingSequence_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_len.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_TrainingSequence");
single_value->field_tsc__set.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_TrainingSequence");
single_value->field_tsc.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_TrainingSequence");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_TrainingSequence");
}

boolean RSL__IE__OSMO__TrainingSequence_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__OSMO__TrainingSequence_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IE__OSMO__RepAcchCap::RSL__IE__OSMO__RepAcchCap()
{
}

RSL__IE__OSMO__RepAcchCap::RSL__IE__OSMO__RepAcchCap(const INTEGER& par_len,
    const BITSTRING& par_rfu,
    const INTEGER& par_rxqual,
    const BOOLEAN& par_ul__sacch,
    const BOOLEAN& par_dl__sacch,
    const BOOLEAN& par_dl__facch__all,
    const BOOLEAN& par_dl__facch__cmd)
  :   field_len(par_len),
  field_rfu(par_rfu),
  field_rxqual(par_rxqual),
  field_ul__sacch(par_ul__sacch),
  field_dl__sacch(par_dl__sacch),
  field_dl__facch__all(par_dl__facch__all),
  field_dl__facch__cmd(par_dl__facch__cmd)
{
}

RSL__IE__OSMO__RepAcchCap::RSL__IE__OSMO__RepAcchCap(const RSL__IE__OSMO__RepAcchCap& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.rfu().is_bound()) field_rfu = other_value.rfu();
else field_rfu.clean_up();
if (other_value.rxqual().is_bound()) field_rxqual = other_value.rxqual();
else field_rxqual.clean_up();
if (other_value.ul__sacch().is_bound()) field_ul__sacch = other_value.ul__sacch();
else field_ul__sacch.clean_up();
if (other_value.dl__sacch().is_bound()) field_dl__sacch = other_value.dl__sacch();
else field_dl__sacch.clean_up();
if (other_value.dl__facch__all().is_bound()) field_dl__facch__all = other_value.dl__facch__all();
else field_dl__facch__all.clean_up();
if (other_value.dl__facch__cmd().is_bound()) field_dl__facch__cmd = other_value.dl__facch__cmd();
else field_dl__facch__cmd.clean_up();
}

void RSL__IE__OSMO__RepAcchCap::clean_up()
{
field_len.clean_up();
field_rfu.clean_up();
field_rxqual.clean_up();
field_ul__sacch.clean_up();
field_dl__sacch.clean_up();
field_dl__facch__all.clean_up();
field_dl__facch__cmd.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__OSMO__RepAcchCap::get_descriptor() const { return &RSL__IE__OSMO__RepAcchCap_descr_; }
RSL__IE__OSMO__RepAcchCap& RSL__IE__OSMO__RepAcchCap::operator=(const RSL__IE__OSMO__RepAcchCap& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.rfu().is_bound()) field_rfu = other_value.rfu();
  else field_rfu.clean_up();
  if (other_value.rxqual().is_bound()) field_rxqual = other_value.rxqual();
  else field_rxqual.clean_up();
  if (other_value.ul__sacch().is_bound()) field_ul__sacch = other_value.ul__sacch();
  else field_ul__sacch.clean_up();
  if (other_value.dl__sacch().is_bound()) field_dl__sacch = other_value.dl__sacch();
  else field_dl__sacch.clean_up();
  if (other_value.dl__facch__all().is_bound()) field_dl__facch__all = other_value.dl__facch__all();
  else field_dl__facch__all.clean_up();
  if (other_value.dl__facch__cmd().is_bound()) field_dl__facch__cmd = other_value.dl__facch__cmd();
  else field_dl__facch__cmd.clean_up();
}
return *this;
}

boolean RSL__IE__OSMO__RepAcchCap::operator==(const RSL__IE__OSMO__RepAcchCap& other_value) const
{
return field_len==other_value.field_len
  && field_rfu==other_value.field_rfu
  && field_rxqual==other_value.field_rxqual
  && field_ul__sacch==other_value.field_ul__sacch
  && field_dl__sacch==other_value.field_dl__sacch
  && field_dl__facch__all==other_value.field_dl__facch__all
  && field_dl__facch__cmd==other_value.field_dl__facch__cmd;
}

boolean RSL__IE__OSMO__RepAcchCap::is_bound() const
{
return (field_len.is_bound())
  || (field_rfu.is_bound())
  || (field_rxqual.is_bound())
  || (field_ul__sacch.is_bound())
  || (field_dl__sacch.is_bound())
  || (field_dl__facch__all.is_bound())
  || (field_dl__facch__cmd.is_bound());
}
boolean RSL__IE__OSMO__RepAcchCap::is_value() const
{
return field_len.is_value()
  && field_rfu.is_value()
  && field_rxqual.is_value()
  && field_ul__sacch.is_value()
  && field_dl__sacch.is_value()
  && field_dl__facch__all.is_value()
  && field_dl__facch__cmd.is_value();
}
void RSL__IE__OSMO__RepAcchCap::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len := ");
field_len.log();
TTCN_Logger::log_event_str(", rfu := ");
field_rfu.log();
TTCN_Logger::log_event_str(", rxqual := ");
field_rxqual.log();
TTCN_Logger::log_event_str(", ul_sacch := ");
field_ul__sacch.log();
TTCN_Logger::log_event_str(", dl_sacch := ");
field_dl__sacch.log();
TTCN_Logger::log_event_str(", dl_facch_all := ");
field_dl__facch__all.log();
TTCN_Logger::log_event_str(", dl_facch_cmd := ");
field_dl__facch__cmd.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__OSMO__RepAcchCap::set_implicit_omit()
{
if (len().is_bound()) len().set_implicit_omit();
if (rfu().is_bound()) rfu().set_implicit_omit();
if (rxqual().is_bound()) rxqual().set_implicit_omit();
if (ul__sacch().is_bound()) ul__sacch().set_implicit_omit();
if (dl__sacch().is_bound()) dl__sacch().set_implicit_omit();
if (dl__facch__all().is_bound()) dl__facch__all().set_implicit_omit();
if (dl__facch__cmd().is_bound()) dl__facch__cmd().set_implicit_omit();
}

void RSL__IE__OSMO__RepAcchCap::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (7<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_OSMO_RepAcchCap has 7 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) rfu().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) rxqual().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) ul__sacch().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) dl__sacch().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) dl__facch__all().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) dl__facch__cmd().set_param(*param.get_elem(6));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rfu")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rfu().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rxqual")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rxqual().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ul_sacch")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ul__sacch().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dl_sacch")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dl__sacch().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dl_facch_all")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dl__facch__all().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dl_facch_cmd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dl__facch__cmd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_OSMO_RepAcchCap: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_OSMO_RepAcchCap");
  }
}

void RSL__IE__OSMO__RepAcchCap::encode_text(Text_Buf& text_buf) const
{
field_len.encode_text(text_buf);
field_rfu.encode_text(text_buf);
field_rxqual.encode_text(text_buf);
field_ul__sacch.encode_text(text_buf);
field_dl__sacch.encode_text(text_buf);
field_dl__facch__all.encode_text(text_buf);
field_dl__facch__cmd.encode_text(text_buf);
}

void RSL__IE__OSMO__RepAcchCap::decode_text(Text_Buf& text_buf)
{
field_len.decode_text(text_buf);
field_rfu.decode_text(text_buf);
field_rxqual.decode_text(text_buf);
field_ul__sacch.decode_text(text_buf);
field_dl__sacch.decode_text(text_buf);
field_dl__facch__all.decode_text(text_buf);
field_dl__facch__cmd.decode_text(text_buf);
}

void RSL__IE__OSMO__RepAcchCap::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__OSMO__RepAcchCap::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__OSMO__RepAcchCap::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__OSMO__RepAcchCap_len_descr_.raw->forceomit);
  decoded_field_length = field_len.RAW_decode(RSL__IE__OSMO__RepAcchCap_len_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_len.convert_to_Integer(RSL__IE__OSMO__RepAcchCap_len_descr_);
  field_len = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__OSMO__RepAcchCap_rfu_descr_.raw->forceomit);
  decoded_field_length = field_rfu.RAW_decode(RSL__IE__OSMO__RepAcchCap_rfu_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RSL__IE__OSMO__RepAcchCap_rxqual_descr_.raw->forceomit);
  decoded_field_length = field_rxqual.RAW_decode(RSL__IE__OSMO__RepAcchCap_rxqual_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, RSL__IE__OSMO__RepAcchCap_ul__sacch_descr_.raw->forceomit);
  decoded_field_length = field_ul__sacch.RAW_decode(RSL__IE__OSMO__RepAcchCap_ul__sacch_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, RSL__IE__OSMO__RepAcchCap_dl__sacch_descr_.raw->forceomit);
  decoded_field_length = field_dl__sacch.RAW_decode(RSL__IE__OSMO__RepAcchCap_dl__sacch_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_5_force_omit(5, force_omit, RSL__IE__OSMO__RepAcchCap_dl__facch__all_descr_.raw->forceomit);
  decoded_field_length = field_dl__facch__all.RAW_decode(RSL__IE__OSMO__RepAcchCap_dl__facch__all_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_6_force_omit(6, force_omit, RSL__IE__OSMO__RepAcchCap_dl__facch__cmd_descr_.raw->forceomit);
  decoded_field_length = field_dl__facch__cmd.RAW_decode(RSL__IE__OSMO__RepAcchCap_dl__facch__cmd_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__OSMO__RepAcchCap::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 7;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(7);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__OSMO__RepAcchCap_len_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__OSMO__RepAcchCap_rfu_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RSL__IE__OSMO__RepAcchCap_rxqual_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, RSL__IE__OSMO__RepAcchCap_ul__sacch_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, RSL__IE__OSMO__RepAcchCap_dl__sacch_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, RSL__IE__OSMO__RepAcchCap_dl__facch__all_descr_.raw);
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, RSL__IE__OSMO__RepAcchCap_dl__facch__cmd_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &RSL__IE__OSMO__RepAcchCap_len_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 6;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(6);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[4].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[4].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[5].level = myleaf.body.node.nodes[6]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[5].pos = myleaf.body.node.nodes[6]->curr_pos.pos;
  encoded_length += field_rfu.RAW_encode(RSL__IE__OSMO__RepAcchCap_rfu_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_rxqual.RAW_encode(RSL__IE__OSMO__RepAcchCap_rxqual_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_ul__sacch.RAW_encode(RSL__IE__OSMO__RepAcchCap_ul__sacch_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_dl__sacch.RAW_encode(RSL__IE__OSMO__RepAcchCap_dl__sacch_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_dl__facch__all.RAW_encode(RSL__IE__OSMO__RepAcchCap_dl__facch__all_descr_, *myleaf.body.node.nodes[5]);
  encoded_length += field_dl__facch__cmd.RAW_encode(RSL__IE__OSMO__RepAcchCap_dl__facch__cmd_descr_, *myleaf.body.node.nodes[6]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__OSMO__RepAcchCap_template::single_value_struct {
INTEGER_template field_len;
BITSTRING_template field_rfu;
INTEGER_template field_rxqual;
BOOLEAN_template field_ul__sacch;
BOOLEAN_template field_dl__sacch;
BOOLEAN_template field_dl__facch__all;
BOOLEAN_template field_dl__facch__cmd;
};

void RSL__IE__OSMO__RepAcchCap_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_len = ANY_VALUE;
single_value->field_rfu = ANY_VALUE;
single_value->field_rxqual = ANY_VALUE;
single_value->field_ul__sacch = ANY_VALUE;
single_value->field_dl__sacch = ANY_VALUE;
single_value->field_dl__facch__all = ANY_VALUE;
single_value->field_dl__facch__cmd = ANY_VALUE;
}
}
}

void RSL__IE__OSMO__RepAcchCap_template::copy_value(const RSL__IE__OSMO__RepAcchCap& other_value)
{
single_value = new single_value_struct;
if (other_value.len().is_bound()) {
  single_value->field_len = other_value.len();
} else {
  single_value->field_len.clean_up();
}
if (other_value.rfu().is_bound()) {
  single_value->field_rfu = other_value.rfu();
} else {
  single_value->field_rfu.clean_up();
}
if (other_value.rxqual().is_bound()) {
  single_value->field_rxqual = other_value.rxqual();
} else {
  single_value->field_rxqual.clean_up();
}
if (other_value.ul__sacch().is_bound()) {
  single_value->field_ul__sacch = other_value.ul__sacch();
} else {
  single_value->field_ul__sacch.clean_up();
}
if (other_value.dl__sacch().is_bound()) {
  single_value->field_dl__sacch = other_value.dl__sacch();
} else {
  single_value->field_dl__sacch.clean_up();
}
if (other_value.dl__facch__all().is_bound()) {
  single_value->field_dl__facch__all = other_value.dl__facch__all();
} else {
  single_value->field_dl__facch__all.clean_up();
}
if (other_value.dl__facch__cmd().is_bound()) {
  single_value->field_dl__facch__cmd = other_value.dl__facch__cmd();
} else {
  single_value->field_dl__facch__cmd.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__OSMO__RepAcchCap_template::copy_template(const RSL__IE__OSMO__RepAcchCap_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.len().get_selection()) {
single_value->field_len = other_value.len();
} else {
single_value->field_len.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rfu().get_selection()) {
single_value->field_rfu = other_value.rfu();
} else {
single_value->field_rfu.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rxqual().get_selection()) {
single_value->field_rxqual = other_value.rxqual();
} else {
single_value->field_rxqual.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ul__sacch().get_selection()) {
single_value->field_ul__sacch = other_value.ul__sacch();
} else {
single_value->field_ul__sacch.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.dl__sacch().get_selection()) {
single_value->field_dl__sacch = other_value.dl__sacch();
} else {
single_value->field_dl__sacch.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.dl__facch__all().get_selection()) {
single_value->field_dl__facch__all = other_value.dl__facch__all();
} else {
single_value->field_dl__facch__all.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.dl__facch__cmd().get_selection()) {
single_value->field_dl__facch__cmd = other_value.dl__facch__cmd();
} else {
single_value->field_dl__facch__cmd.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__OSMO__RepAcchCap_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__OSMO__RepAcchCap_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__OSMO__RepAcchCap_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
break;
}
set_selection(other_value);
}

RSL__IE__OSMO__RepAcchCap_template::RSL__IE__OSMO__RepAcchCap_template()
{
}

RSL__IE__OSMO__RepAcchCap_template::RSL__IE__OSMO__RepAcchCap_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__OSMO__RepAcchCap_template::RSL__IE__OSMO__RepAcchCap_template(const RSL__IE__OSMO__RepAcchCap& other_value)
{
copy_value(other_value);
}

RSL__IE__OSMO__RepAcchCap_template::RSL__IE__OSMO__RepAcchCap_template(const OPTIONAL<RSL__IE__OSMO__RepAcchCap>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__OSMO__RepAcchCap&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap from an unbound optional field.");
}
}

RSL__IE__OSMO__RepAcchCap_template::RSL__IE__OSMO__RepAcchCap_template(RSL__IE__OSMO__RepAcchCap_template* p_precondition, RSL__IE__OSMO__RepAcchCap_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__OSMO__RepAcchCap_template::RSL__IE__OSMO__RepAcchCap_template(Dynamic_Match_Interface<RSL__IE__OSMO__RepAcchCap>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__OSMO__RepAcchCap>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__OSMO__RepAcchCap_template::RSL__IE__OSMO__RepAcchCap_template(const RSL__IE__OSMO__RepAcchCap_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__OSMO__RepAcchCap_template::~RSL__IE__OSMO__RepAcchCap_template()
{
clean_up();
}

RSL__IE__OSMO__RepAcchCap_template& RSL__IE__OSMO__RepAcchCap_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__OSMO__RepAcchCap_template& RSL__IE__OSMO__RepAcchCap_template::operator=(const RSL__IE__OSMO__RepAcchCap& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__OSMO__RepAcchCap_template& RSL__IE__OSMO__RepAcchCap_template::operator=(const OPTIONAL<RSL__IE__OSMO__RepAcchCap>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__OSMO__RepAcchCap&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
}
return *this;
}

RSL__IE__OSMO__RepAcchCap_template& RSL__IE__OSMO__RepAcchCap_template::operator=(const RSL__IE__OSMO__RepAcchCap_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__OSMO__RepAcchCap_template::match(const RSL__IE__OSMO__RepAcchCap& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.len().is_bound()) return FALSE;
if(!single_value->field_len.match(other_value.len(), legacy))return FALSE;
if(!other_value.rfu().is_bound()) return FALSE;
if(!single_value->field_rfu.match(other_value.rfu(), legacy))return FALSE;
if(!other_value.rxqual().is_bound()) return FALSE;
if(!single_value->field_rxqual.match(other_value.rxqual(), legacy))return FALSE;
if(!other_value.ul__sacch().is_bound()) return FALSE;
if(!single_value->field_ul__sacch.match(other_value.ul__sacch(), legacy))return FALSE;
if(!other_value.dl__sacch().is_bound()) return FALSE;
if(!single_value->field_dl__sacch.match(other_value.dl__sacch(), legacy))return FALSE;
if(!other_value.dl__facch__all().is_bound()) return FALSE;
if(!single_value->field_dl__facch__all.match(other_value.dl__facch__all(), legacy))return FALSE;
if(!other_value.dl__facch__cmd().is_bound()) return FALSE;
if(!single_value->field_dl__facch__cmd.match(other_value.dl__facch__cmd(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
}
return FALSE;
}

boolean RSL__IE__OSMO__RepAcchCap_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_len.is_bound()
 || single_value->field_rfu.is_bound()
 || single_value->field_rxqual.is_bound()
 || single_value->field_ul__sacch.is_bound()
 || single_value->field_dl__sacch.is_bound()
 || single_value->field_dl__facch__all.is_bound()
 || single_value->field_dl__facch__cmd.is_bound();
}

boolean RSL__IE__OSMO__RepAcchCap_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_len.is_value()
 && single_value->field_rfu.is_value()
 && single_value->field_rxqual.is_value()
 && single_value->field_ul__sacch.is_value()
 && single_value->field_dl__sacch.is_value()
 && single_value->field_dl__facch__all.is_value()
 && single_value->field_dl__facch__cmd.is_value();
}

void RSL__IE__OSMO__RepAcchCap_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__OSMO__RepAcchCap RSL__IE__OSMO__RepAcchCap_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
RSL__IE__OSMO__RepAcchCap ret_val;
if (single_value->field_len.is_bound()) {
ret_val.len() = single_value->field_len.valueof();
}
if (single_value->field_rfu.is_bound()) {
ret_val.rfu() = single_value->field_rfu.valueof();
}
if (single_value->field_rxqual.is_bound()) {
ret_val.rxqual() = single_value->field_rxqual.valueof();
}
if (single_value->field_ul__sacch.is_bound()) {
ret_val.ul__sacch() = single_value->field_ul__sacch.valueof();
}
if (single_value->field_dl__sacch.is_bound()) {
ret_val.dl__sacch() = single_value->field_dl__sacch.valueof();
}
if (single_value->field_dl__facch__all.is_bound()) {
ret_val.dl__facch__all() = single_value->field_dl__facch__all.valueof();
}
if (single_value->field_dl__facch__cmd.is_bound()) {
ret_val.dl__facch__cmd() = single_value->field_dl__facch__cmd.valueof();
}
return ret_val;
}

void RSL__IE__OSMO__RepAcchCap_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__OSMO__RepAcchCap_template[list_length];
}

RSL__IE__OSMO__RepAcchCap_template& RSL__IE__OSMO__RepAcchCap_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__OSMO__RepAcchCap_template::len()
{
set_specific();
return single_value->field_len;
}

const INTEGER_template& RSL__IE__OSMO__RepAcchCap_template::len() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len of a non-specific template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
return single_value->field_len;
}

BITSTRING_template& RSL__IE__OSMO__RepAcchCap_template::rfu()
{
set_specific();
return single_value->field_rfu;
}

const BITSTRING_template& RSL__IE__OSMO__RepAcchCap_template::rfu() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rfu of a non-specific template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
return single_value->field_rfu;
}

INTEGER_template& RSL__IE__OSMO__RepAcchCap_template::rxqual()
{
set_specific();
return single_value->field_rxqual;
}

const INTEGER_template& RSL__IE__OSMO__RepAcchCap_template::rxqual() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rxqual of a non-specific template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
return single_value->field_rxqual;
}

BOOLEAN_template& RSL__IE__OSMO__RepAcchCap_template::ul__sacch()
{
set_specific();
return single_value->field_ul__sacch;
}

const BOOLEAN_template& RSL__IE__OSMO__RepAcchCap_template::ul__sacch() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ul_sacch of a non-specific template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
return single_value->field_ul__sacch;
}

BOOLEAN_template& RSL__IE__OSMO__RepAcchCap_template::dl__sacch()
{
set_specific();
return single_value->field_dl__sacch;
}

const BOOLEAN_template& RSL__IE__OSMO__RepAcchCap_template::dl__sacch() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field dl_sacch of a non-specific template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
return single_value->field_dl__sacch;
}

BOOLEAN_template& RSL__IE__OSMO__RepAcchCap_template::dl__facch__all()
{
set_specific();
return single_value->field_dl__facch__all;
}

const BOOLEAN_template& RSL__IE__OSMO__RepAcchCap_template::dl__facch__all() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field dl_facch_all of a non-specific template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
return single_value->field_dl__facch__all;
}

BOOLEAN_template& RSL__IE__OSMO__RepAcchCap_template::dl__facch__cmd()
{
set_specific();
return single_value->field_dl__facch__cmd;
}

const BOOLEAN_template& RSL__IE__OSMO__RepAcchCap_template::dl__facch__cmd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field dl_facch_cmd of a non-specific template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
return single_value->field_dl__facch__cmd;
}

int RSL__IE__OSMO__RepAcchCap_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 7;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
  }
  return 0;
}

void RSL__IE__OSMO__RepAcchCap_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log();
TTCN_Logger::log_event_str(", rfu := ");
single_value->field_rfu.log();
TTCN_Logger::log_event_str(", rxqual := ");
single_value->field_rxqual.log();
TTCN_Logger::log_event_str(", ul_sacch := ");
single_value->field_ul__sacch.log();
TTCN_Logger::log_event_str(", dl_sacch := ");
single_value->field_dl__sacch.log();
TTCN_Logger::log_event_str(", dl_facch_all := ");
single_value->field_dl__facch__all.log();
TTCN_Logger::log_event_str(", dl_facch_cmd := ");
single_value->field_dl__facch__cmd.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__OSMO__RepAcchCap_template::log_match(const RSL__IE__OSMO__RepAcchCap& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_len.match(match_value.len(), legacy)){
TTCN_Logger::log_logmatch_info(".len");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rfu.match(match_value.rfu(), legacy)){
TTCN_Logger::log_logmatch_info(".rfu");
single_value->field_rfu.log_match(match_value.rfu(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rxqual.match(match_value.rxqual(), legacy)){
TTCN_Logger::log_logmatch_info(".rxqual");
single_value->field_rxqual.log_match(match_value.rxqual(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ul__sacch.match(match_value.ul__sacch(), legacy)){
TTCN_Logger::log_logmatch_info(".ul_sacch");
single_value->field_ul__sacch.log_match(match_value.ul__sacch(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_dl__sacch.match(match_value.dl__sacch(), legacy)){
TTCN_Logger::log_logmatch_info(".dl_sacch");
single_value->field_dl__sacch.log_match(match_value.dl__sacch(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_dl__facch__all.match(match_value.dl__facch__all(), legacy)){
TTCN_Logger::log_logmatch_info(".dl_facch_all");
single_value->field_dl__facch__all.log_match(match_value.dl__facch__all(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_dl__facch__cmd.match(match_value.dl__facch__cmd(), legacy)){
TTCN_Logger::log_logmatch_info(".dl_facch_cmd");
single_value->field_dl__facch__cmd.log_match(match_value.dl__facch__cmd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::log_event_str(", rfu := ");
single_value->field_rfu.log_match(match_value.rfu(), legacy);
TTCN_Logger::log_event_str(", rxqual := ");
single_value->field_rxqual.log_match(match_value.rxqual(), legacy);
TTCN_Logger::log_event_str(", ul_sacch := ");
single_value->field_ul__sacch.log_match(match_value.ul__sacch(), legacy);
TTCN_Logger::log_event_str(", dl_sacch := ");
single_value->field_dl__sacch.log_match(match_value.dl__sacch(), legacy);
TTCN_Logger::log_event_str(", dl_facch_all := ");
single_value->field_dl__facch__all.log_match(match_value.dl__facch__all(), legacy);
TTCN_Logger::log_event_str(", dl_facch_cmd := ");
single_value->field_dl__facch__cmd.log_match(match_value.dl__facch__cmd(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__OSMO__RepAcchCap_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (len().is_bound()) len().set_implicit_omit();
if (rfu().is_bound()) rfu().set_implicit_omit();
if (rxqual().is_bound()) rxqual().set_implicit_omit();
if (ul__sacch().is_bound()) ul__sacch().set_implicit_omit();
if (dl__sacch().is_bound()) dl__sacch().set_implicit_omit();
if (dl__facch__all().is_bound()) dl__facch__all().set_implicit_omit();
if (dl__facch__cmd().is_bound()) dl__facch__cmd().set_implicit_omit();
}

void RSL__IE__OSMO__RepAcchCap_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_len.encode_text(text_buf);
single_value->field_rfu.encode_text(text_buf);
single_value->field_rxqual.encode_text(text_buf);
single_value->field_ul__sacch.encode_text(text_buf);
single_value->field_dl__sacch.encode_text(text_buf);
single_value->field_dl__facch__all.encode_text(text_buf);
single_value->field_dl__facch__cmd.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
}
}

void RSL__IE__OSMO__RepAcchCap_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_len.decode_text(text_buf);
single_value->field_rfu.decode_text(text_buf);
single_value->field_rxqual.decode_text(text_buf);
single_value->field_ul__sacch.decode_text(text_buf);
single_value->field_dl__sacch.decode_text(text_buf);
single_value->field_dl__facch__all.decode_text(text_buf);
single_value->field_dl__facch__cmd.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__OSMO__RepAcchCap_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
}
}

void RSL__IE__OSMO__RepAcchCap_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__OSMO__RepAcchCap_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (7<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap has 7 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) rfu().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) rxqual().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) ul__sacch().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) dl__sacch().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) dl__facch__all().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) dl__facch__cmd().set_param(*param.get_elem(6));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rfu")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rfu().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rxqual")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rxqual().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ul_sacch")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ul__sacch().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dl_sacch")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dl__sacch().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dl_facch_all")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dl__facch__all().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dl_facch_cmd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dl__facch__cmd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_OSMO_RepAcchCap: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__OSMO__RepAcchCap_template* precondition = new RSL__IE__OSMO__RepAcchCap_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__OSMO__RepAcchCap_template* implied_template = new RSL__IE__OSMO__RepAcchCap_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__OSMO__RepAcchCap_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_OSMO_RepAcchCap");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__OSMO__RepAcchCap_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_len.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_RepAcchCap");
single_value->field_rfu.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_RepAcchCap");
single_value->field_rxqual.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_RepAcchCap");
single_value->field_ul__sacch.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_RepAcchCap");
single_value->field_dl__sacch.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_RepAcchCap");
single_value->field_dl__facch__all.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_RepAcchCap");
single_value->field_dl__facch__cmd.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_RepAcchCap");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_RepAcchCap");
}

boolean RSL__IE__OSMO__RepAcchCap_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__OSMO__RepAcchCap_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IE__OSMO__TopAcchCap::RSL__IE__OSMO__TopAcchCap()
{
}

RSL__IE__OSMO__TopAcchCap::RSL__IE__OSMO__TopAcchCap(const INTEGER& par_len,
    const BOOLEAN& par_sacch__enable,
    const BOOLEAN& par_facch__enable,
    const INTEGER& par_rxqual,
    const INTEGER& par_overpower__db)
  :   field_len(par_len),
  field_sacch__enable(par_sacch__enable),
  field_facch__enable(par_facch__enable),
  field_rxqual(par_rxqual),
  field_overpower__db(par_overpower__db)
{
}

RSL__IE__OSMO__TopAcchCap::RSL__IE__OSMO__TopAcchCap(const RSL__IE__OSMO__TopAcchCap& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.sacch__enable().is_bound()) field_sacch__enable = other_value.sacch__enable();
else field_sacch__enable.clean_up();
if (other_value.facch__enable().is_bound()) field_facch__enable = other_value.facch__enable();
else field_facch__enable.clean_up();
if (other_value.rxqual().is_bound()) field_rxqual = other_value.rxqual();
else field_rxqual.clean_up();
if (other_value.overpower__db().is_bound()) field_overpower__db = other_value.overpower__db();
else field_overpower__db.clean_up();
}

void RSL__IE__OSMO__TopAcchCap::clean_up()
{
field_len.clean_up();
field_sacch__enable.clean_up();
field_facch__enable.clean_up();
field_rxqual.clean_up();
field_overpower__db.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__OSMO__TopAcchCap::get_descriptor() const { return &RSL__IE__OSMO__TopAcchCap_descr_; }
RSL__IE__OSMO__TopAcchCap& RSL__IE__OSMO__TopAcchCap::operator=(const RSL__IE__OSMO__TopAcchCap& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.sacch__enable().is_bound()) field_sacch__enable = other_value.sacch__enable();
  else field_sacch__enable.clean_up();
  if (other_value.facch__enable().is_bound()) field_facch__enable = other_value.facch__enable();
  else field_facch__enable.clean_up();
  if (other_value.rxqual().is_bound()) field_rxqual = other_value.rxqual();
  else field_rxqual.clean_up();
  if (other_value.overpower__db().is_bound()) field_overpower__db = other_value.overpower__db();
  else field_overpower__db.clean_up();
}
return *this;
}

boolean RSL__IE__OSMO__TopAcchCap::operator==(const RSL__IE__OSMO__TopAcchCap& other_value) const
{
return field_len==other_value.field_len
  && field_sacch__enable==other_value.field_sacch__enable
  && field_facch__enable==other_value.field_facch__enable
  && field_rxqual==other_value.field_rxqual
  && field_overpower__db==other_value.field_overpower__db;
}

boolean RSL__IE__OSMO__TopAcchCap::is_bound() const
{
return (field_len.is_bound())
  || (field_sacch__enable.is_bound())
  || (field_facch__enable.is_bound())
  || (field_rxqual.is_bound())
  || (field_overpower__db.is_bound());
}
boolean RSL__IE__OSMO__TopAcchCap::is_value() const
{
return field_len.is_value()
  && field_sacch__enable.is_value()
  && field_facch__enable.is_value()
  && field_rxqual.is_value()
  && field_overpower__db.is_value();
}
void RSL__IE__OSMO__TopAcchCap::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len := ");
field_len.log();
TTCN_Logger::log_event_str(", sacch_enable := ");
field_sacch__enable.log();
TTCN_Logger::log_event_str(", facch_enable := ");
field_facch__enable.log();
TTCN_Logger::log_event_str(", rxqual := ");
field_rxqual.log();
TTCN_Logger::log_event_str(", overpower_db := ");
field_overpower__db.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__OSMO__TopAcchCap::set_implicit_omit()
{
if (len().is_bound()) len().set_implicit_omit();
if (sacch__enable().is_bound()) sacch__enable().set_implicit_omit();
if (facch__enable().is_bound()) facch__enable().set_implicit_omit();
if (rxqual().is_bound()) rxqual().set_implicit_omit();
if (overpower__db().is_bound()) overpower__db().set_implicit_omit();
}

void RSL__IE__OSMO__TopAcchCap::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_OSMO_TopAcchCap has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) sacch__enable().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) facch__enable().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rxqual().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) overpower__db().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sacch_enable")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sacch__enable().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "facch_enable")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          facch__enable().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rxqual")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rxqual().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "overpower_db")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          overpower__db().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_OSMO_TopAcchCap: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_OSMO_TopAcchCap");
  }
}

void RSL__IE__OSMO__TopAcchCap::encode_text(Text_Buf& text_buf) const
{
field_len.encode_text(text_buf);
field_sacch__enable.encode_text(text_buf);
field_facch__enable.encode_text(text_buf);
field_rxqual.encode_text(text_buf);
field_overpower__db.encode_text(text_buf);
}

void RSL__IE__OSMO__TopAcchCap::decode_text(Text_Buf& text_buf)
{
field_len.decode_text(text_buf);
field_sacch__enable.decode_text(text_buf);
field_facch__enable.decode_text(text_buf);
field_rxqual.decode_text(text_buf);
field_overpower__db.decode_text(text_buf);
}

void RSL__IE__OSMO__TopAcchCap::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__OSMO__TopAcchCap::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__OSMO__TopAcchCap::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__OSMO__TopAcchCap_len_descr_.raw->forceomit);
  decoded_field_length = field_len.RAW_decode(RSL__IE__OSMO__TopAcchCap_len_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_len.convert_to_Integer(RSL__IE__OSMO__TopAcchCap_len_descr_);
  field_len = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__OSMO__TopAcchCap_sacch__enable_descr_.raw->forceomit);
  decoded_field_length = field_sacch__enable.RAW_decode(RSL__IE__OSMO__TopAcchCap_sacch__enable_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RSL__IE__OSMO__TopAcchCap_facch__enable_descr_.raw->forceomit);
  decoded_field_length = field_facch__enable.RAW_decode(RSL__IE__OSMO__TopAcchCap_facch__enable_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, RSL__IE__OSMO__TopAcchCap_rxqual_descr_.raw->forceomit);
  decoded_field_length = field_rxqual.RAW_decode(RSL__IE__OSMO__TopAcchCap_rxqual_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, RSL__IE__OSMO__TopAcchCap_overpower__db_descr_.raw->forceomit);
  decoded_field_length = field_overpower__db.RAW_decode(RSL__IE__OSMO__TopAcchCap_overpower__db_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__OSMO__TopAcchCap::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__OSMO__TopAcchCap_len_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__OSMO__TopAcchCap_sacch__enable_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RSL__IE__OSMO__TopAcchCap_facch__enable_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, RSL__IE__OSMO__TopAcchCap_rxqual_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, RSL__IE__OSMO__TopAcchCap_overpower__db_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &RSL__IE__OSMO__TopAcchCap_len_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 4;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(4);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  encoded_length += field_sacch__enable.RAW_encode(RSL__IE__OSMO__TopAcchCap_sacch__enable_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_facch__enable.RAW_encode(RSL__IE__OSMO__TopAcchCap_facch__enable_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_rxqual.RAW_encode(RSL__IE__OSMO__TopAcchCap_rxqual_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_overpower__db.RAW_encode(RSL__IE__OSMO__TopAcchCap_overpower__db_descr_, *myleaf.body.node.nodes[4]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__OSMO__TopAcchCap_template::single_value_struct {
INTEGER_template field_len;
BOOLEAN_template field_sacch__enable;
BOOLEAN_template field_facch__enable;
INTEGER_template field_rxqual;
INTEGER_template field_overpower__db;
};

void RSL__IE__OSMO__TopAcchCap_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_len = ANY_VALUE;
single_value->field_sacch__enable = ANY_VALUE;
single_value->field_facch__enable = ANY_VALUE;
single_value->field_rxqual = ANY_VALUE;
single_value->field_overpower__db = ANY_VALUE;
}
}
}

void RSL__IE__OSMO__TopAcchCap_template::copy_value(const RSL__IE__OSMO__TopAcchCap& other_value)
{
single_value = new single_value_struct;
if (other_value.len().is_bound()) {
  single_value->field_len = other_value.len();
} else {
  single_value->field_len.clean_up();
}
if (other_value.sacch__enable().is_bound()) {
  single_value->field_sacch__enable = other_value.sacch__enable();
} else {
  single_value->field_sacch__enable.clean_up();
}
if (other_value.facch__enable().is_bound()) {
  single_value->field_facch__enable = other_value.facch__enable();
} else {
  single_value->field_facch__enable.clean_up();
}
if (other_value.rxqual().is_bound()) {
  single_value->field_rxqual = other_value.rxqual();
} else {
  single_value->field_rxqual.clean_up();
}
if (other_value.overpower__db().is_bound()) {
  single_value->field_overpower__db = other_value.overpower__db();
} else {
  single_value->field_overpower__db.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__OSMO__TopAcchCap_template::copy_template(const RSL__IE__OSMO__TopAcchCap_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.len().get_selection()) {
single_value->field_len = other_value.len();
} else {
single_value->field_len.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sacch__enable().get_selection()) {
single_value->field_sacch__enable = other_value.sacch__enable();
} else {
single_value->field_sacch__enable.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.facch__enable().get_selection()) {
single_value->field_facch__enable = other_value.facch__enable();
} else {
single_value->field_facch__enable.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rxqual().get_selection()) {
single_value->field_rxqual = other_value.rxqual();
} else {
single_value->field_rxqual.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.overpower__db().get_selection()) {
single_value->field_overpower__db = other_value.overpower__db();
} else {
single_value->field_overpower__db.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__OSMO__TopAcchCap_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__OSMO__TopAcchCap_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__OSMO__TopAcchCap_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
break;
}
set_selection(other_value);
}

RSL__IE__OSMO__TopAcchCap_template::RSL__IE__OSMO__TopAcchCap_template()
{
}

RSL__IE__OSMO__TopAcchCap_template::RSL__IE__OSMO__TopAcchCap_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__OSMO__TopAcchCap_template::RSL__IE__OSMO__TopAcchCap_template(const RSL__IE__OSMO__TopAcchCap& other_value)
{
copy_value(other_value);
}

RSL__IE__OSMO__TopAcchCap_template::RSL__IE__OSMO__TopAcchCap_template(const OPTIONAL<RSL__IE__OSMO__TopAcchCap>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__OSMO__TopAcchCap&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap from an unbound optional field.");
}
}

RSL__IE__OSMO__TopAcchCap_template::RSL__IE__OSMO__TopAcchCap_template(RSL__IE__OSMO__TopAcchCap_template* p_precondition, RSL__IE__OSMO__TopAcchCap_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__OSMO__TopAcchCap_template::RSL__IE__OSMO__TopAcchCap_template(Dynamic_Match_Interface<RSL__IE__OSMO__TopAcchCap>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__OSMO__TopAcchCap>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__OSMO__TopAcchCap_template::RSL__IE__OSMO__TopAcchCap_template(const RSL__IE__OSMO__TopAcchCap_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__OSMO__TopAcchCap_template::~RSL__IE__OSMO__TopAcchCap_template()
{
clean_up();
}

RSL__IE__OSMO__TopAcchCap_template& RSL__IE__OSMO__TopAcchCap_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__OSMO__TopAcchCap_template& RSL__IE__OSMO__TopAcchCap_template::operator=(const RSL__IE__OSMO__TopAcchCap& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__OSMO__TopAcchCap_template& RSL__IE__OSMO__TopAcchCap_template::operator=(const OPTIONAL<RSL__IE__OSMO__TopAcchCap>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__OSMO__TopAcchCap&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
}
return *this;
}

RSL__IE__OSMO__TopAcchCap_template& RSL__IE__OSMO__TopAcchCap_template::operator=(const RSL__IE__OSMO__TopAcchCap_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__OSMO__TopAcchCap_template::match(const RSL__IE__OSMO__TopAcchCap& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.len().is_bound()) return FALSE;
if(!single_value->field_len.match(other_value.len(), legacy))return FALSE;
if(!other_value.sacch__enable().is_bound()) return FALSE;
if(!single_value->field_sacch__enable.match(other_value.sacch__enable(), legacy))return FALSE;
if(!other_value.facch__enable().is_bound()) return FALSE;
if(!single_value->field_facch__enable.match(other_value.facch__enable(), legacy))return FALSE;
if(!other_value.rxqual().is_bound()) return FALSE;
if(!single_value->field_rxqual.match(other_value.rxqual(), legacy))return FALSE;
if(!other_value.overpower__db().is_bound()) return FALSE;
if(!single_value->field_overpower__db.match(other_value.overpower__db(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
}
return FALSE;
}

boolean RSL__IE__OSMO__TopAcchCap_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_len.is_bound()
 || single_value->field_sacch__enable.is_bound()
 || single_value->field_facch__enable.is_bound()
 || single_value->field_rxqual.is_bound()
 || single_value->field_overpower__db.is_bound();
}

boolean RSL__IE__OSMO__TopAcchCap_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_len.is_value()
 && single_value->field_sacch__enable.is_value()
 && single_value->field_facch__enable.is_value()
 && single_value->field_rxqual.is_value()
 && single_value->field_overpower__db.is_value();
}

void RSL__IE__OSMO__TopAcchCap_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__OSMO__TopAcchCap RSL__IE__OSMO__TopAcchCap_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
RSL__IE__OSMO__TopAcchCap ret_val;
if (single_value->field_len.is_bound()) {
ret_val.len() = single_value->field_len.valueof();
}
if (single_value->field_sacch__enable.is_bound()) {
ret_val.sacch__enable() = single_value->field_sacch__enable.valueof();
}
if (single_value->field_facch__enable.is_bound()) {
ret_val.facch__enable() = single_value->field_facch__enable.valueof();
}
if (single_value->field_rxqual.is_bound()) {
ret_val.rxqual() = single_value->field_rxqual.valueof();
}
if (single_value->field_overpower__db.is_bound()) {
ret_val.overpower__db() = single_value->field_overpower__db.valueof();
}
return ret_val;
}

void RSL__IE__OSMO__TopAcchCap_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__OSMO__TopAcchCap_template[list_length];
}

RSL__IE__OSMO__TopAcchCap_template& RSL__IE__OSMO__TopAcchCap_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__OSMO__TopAcchCap_template::len()
{
set_specific();
return single_value->field_len;
}

const INTEGER_template& RSL__IE__OSMO__TopAcchCap_template::len() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len of a non-specific template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
return single_value->field_len;
}

BOOLEAN_template& RSL__IE__OSMO__TopAcchCap_template::sacch__enable()
{
set_specific();
return single_value->field_sacch__enable;
}

const BOOLEAN_template& RSL__IE__OSMO__TopAcchCap_template::sacch__enable() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sacch_enable of a non-specific template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
return single_value->field_sacch__enable;
}

BOOLEAN_template& RSL__IE__OSMO__TopAcchCap_template::facch__enable()
{
set_specific();
return single_value->field_facch__enable;
}

const BOOLEAN_template& RSL__IE__OSMO__TopAcchCap_template::facch__enable() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field facch_enable of a non-specific template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
return single_value->field_facch__enable;
}

INTEGER_template& RSL__IE__OSMO__TopAcchCap_template::rxqual()
{
set_specific();
return single_value->field_rxqual;
}

const INTEGER_template& RSL__IE__OSMO__TopAcchCap_template::rxqual() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rxqual of a non-specific template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
return single_value->field_rxqual;
}

INTEGER_template& RSL__IE__OSMO__TopAcchCap_template::overpower__db()
{
set_specific();
return single_value->field_overpower__db;
}

const INTEGER_template& RSL__IE__OSMO__TopAcchCap_template::overpower__db() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field overpower_db of a non-specific template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
return single_value->field_overpower__db;
}

int RSL__IE__OSMO__TopAcchCap_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
  }
  return 0;
}

void RSL__IE__OSMO__TopAcchCap_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log();
TTCN_Logger::log_event_str(", sacch_enable := ");
single_value->field_sacch__enable.log();
TTCN_Logger::log_event_str(", facch_enable := ");
single_value->field_facch__enable.log();
TTCN_Logger::log_event_str(", rxqual := ");
single_value->field_rxqual.log();
TTCN_Logger::log_event_str(", overpower_db := ");
single_value->field_overpower__db.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__OSMO__TopAcchCap_template::log_match(const RSL__IE__OSMO__TopAcchCap& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_len.match(match_value.len(), legacy)){
TTCN_Logger::log_logmatch_info(".len");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sacch__enable.match(match_value.sacch__enable(), legacy)){
TTCN_Logger::log_logmatch_info(".sacch_enable");
single_value->field_sacch__enable.log_match(match_value.sacch__enable(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_facch__enable.match(match_value.facch__enable(), legacy)){
TTCN_Logger::log_logmatch_info(".facch_enable");
single_value->field_facch__enable.log_match(match_value.facch__enable(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rxqual.match(match_value.rxqual(), legacy)){
TTCN_Logger::log_logmatch_info(".rxqual");
single_value->field_rxqual.log_match(match_value.rxqual(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_overpower__db.match(match_value.overpower__db(), legacy)){
TTCN_Logger::log_logmatch_info(".overpower_db");
single_value->field_overpower__db.log_match(match_value.overpower__db(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::log_event_str(", sacch_enable := ");
single_value->field_sacch__enable.log_match(match_value.sacch__enable(), legacy);
TTCN_Logger::log_event_str(", facch_enable := ");
single_value->field_facch__enable.log_match(match_value.facch__enable(), legacy);
TTCN_Logger::log_event_str(", rxqual := ");
single_value->field_rxqual.log_match(match_value.rxqual(), legacy);
TTCN_Logger::log_event_str(", overpower_db := ");
single_value->field_overpower__db.log_match(match_value.overpower__db(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__OSMO__TopAcchCap_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (len().is_bound()) len().set_implicit_omit();
if (sacch__enable().is_bound()) sacch__enable().set_implicit_omit();
if (facch__enable().is_bound()) facch__enable().set_implicit_omit();
if (rxqual().is_bound()) rxqual().set_implicit_omit();
if (overpower__db().is_bound()) overpower__db().set_implicit_omit();
}

void RSL__IE__OSMO__TopAcchCap_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_len.encode_text(text_buf);
single_value->field_sacch__enable.encode_text(text_buf);
single_value->field_facch__enable.encode_text(text_buf);
single_value->field_rxqual.encode_text(text_buf);
single_value->field_overpower__db.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
}
}

void RSL__IE__OSMO__TopAcchCap_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_len.decode_text(text_buf);
single_value->field_sacch__enable.decode_text(text_buf);
single_value->field_facch__enable.decode_text(text_buf);
single_value->field_rxqual.decode_text(text_buf);
single_value->field_overpower__db.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__OSMO__TopAcchCap_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
}
}

void RSL__IE__OSMO__TopAcchCap_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__OSMO__TopAcchCap_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) sacch__enable().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) facch__enable().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rxqual().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) overpower__db().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sacch_enable")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sacch__enable().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "facch_enable")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          facch__enable().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rxqual")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rxqual().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "overpower_db")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          overpower__db().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_OSMO_TopAcchCap: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__OSMO__TopAcchCap_template* precondition = new RSL__IE__OSMO__TopAcchCap_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__OSMO__TopAcchCap_template* implied_template = new RSL__IE__OSMO__TopAcchCap_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__OSMO__TopAcchCap_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_OSMO_TopAcchCap");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__OSMO__TopAcchCap_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_len.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_TopAcchCap");
single_value->field_sacch__enable.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_TopAcchCap");
single_value->field_facch__enable.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_TopAcchCap");
single_value->field_rxqual.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_TopAcchCap");
single_value->field_overpower__db.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_TopAcchCap");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_TopAcchCap");
}

boolean RSL__IE__OSMO__TopAcchCap_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__OSMO__TopAcchCap_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IE__OSMO__Osmux__CID::RSL__IE__OSMO__Osmux__CID()
{
}

RSL__IE__OSMO__Osmux__CID::RSL__IE__OSMO__Osmux__CID(const INTEGER& par_len,
    const INTEGER& par_cid)
  :   field_len(par_len),
  field_cid(par_cid)
{
}

RSL__IE__OSMO__Osmux__CID::RSL__IE__OSMO__Osmux__CID(const RSL__IE__OSMO__Osmux__CID& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_OSMO_Osmux_CID.");
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.cid().is_bound()) field_cid = other_value.cid();
else field_cid.clean_up();
}

void RSL__IE__OSMO__Osmux__CID::clean_up()
{
field_len.clean_up();
field_cid.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__OSMO__Osmux__CID::get_descriptor() const { return &RSL__IE__OSMO__Osmux__CID_descr_; }
RSL__IE__OSMO__Osmux__CID& RSL__IE__OSMO__Osmux__CID::operator=(const RSL__IE__OSMO__Osmux__CID& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_OSMO_Osmux_CID.");
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.cid().is_bound()) field_cid = other_value.cid();
  else field_cid.clean_up();
}
return *this;
}

boolean RSL__IE__OSMO__Osmux__CID::operator==(const RSL__IE__OSMO__Osmux__CID& other_value) const
{
return field_len==other_value.field_len
  && field_cid==other_value.field_cid;
}

boolean RSL__IE__OSMO__Osmux__CID::is_bound() const
{
return (field_len.is_bound())
  || (field_cid.is_bound());
}
boolean RSL__IE__OSMO__Osmux__CID::is_value() const
{
return field_len.is_value()
  && field_cid.is_value();
}
void RSL__IE__OSMO__Osmux__CID::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len := ");
field_len.log();
TTCN_Logger::log_event_str(", cid := ");
field_cid.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__OSMO__Osmux__CID::set_implicit_omit()
{
if (len().is_bound()) len().set_implicit_omit();
if (cid().is_bound()) cid().set_implicit_omit();
}

void RSL__IE__OSMO__Osmux__CID::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_OSMO_Osmux_CID has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cid().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cid")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cid().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_OSMO_Osmux_CID: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_OSMO_Osmux_CID");
  }
}

void RSL__IE__OSMO__Osmux__CID::encode_text(Text_Buf& text_buf) const
{
field_len.encode_text(text_buf);
field_cid.encode_text(text_buf);
}

void RSL__IE__OSMO__Osmux__CID::decode_text(Text_Buf& text_buf)
{
field_len.decode_text(text_buf);
field_cid.decode_text(text_buf);
}

void RSL__IE__OSMO__Osmux__CID::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__OSMO__Osmux__CID::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::