// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "BSSAP_Types.hh"

namespace BSSAP__Types {

/* Member functions of C++ classes */

BSSMAP__IE__ResponseRequest::BSSMAP__IE__ResponseRequest()
{
}

BSSMAP__IE__ResponseRequest::BSSMAP__IE__ResponseRequest(const OCTETSTRING& par_elementIdentifier)
  :   field_elementIdentifier(par_elementIdentifier)
{
}

BSSMAP__IE__ResponseRequest::BSSMAP__IE__ResponseRequest(const BSSMAP__IE__ResponseRequest& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_ResponseRequest.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
}

void BSSMAP__IE__ResponseRequest::clean_up()
{
field_elementIdentifier.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__ResponseRequest::get_descriptor() const { return &BSSMAP__IE__ResponseRequest_descr_; }
BSSMAP__IE__ResponseRequest& BSSMAP__IE__ResponseRequest::operator=(const BSSMAP__IE__ResponseRequest& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_ResponseRequest.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
}
return *this;
}

boolean BSSMAP__IE__ResponseRequest::operator==(const BSSMAP__IE__ResponseRequest& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier;
}

boolean BSSMAP__IE__ResponseRequest::is_bound() const
{
return (field_elementIdentifier.is_bound());
}
boolean BSSMAP__IE__ResponseRequest::is_value() const
{
return field_elementIdentifier.is_value();
}
void BSSMAP__IE__ResponseRequest::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__ResponseRequest::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
}

void BSSMAP__IE__ResponseRequest::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_ResponseRequest has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_ResponseRequest: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_ResponseRequest");
  }
}

void BSSMAP__IE__ResponseRequest::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
}

void BSSMAP__IE__ResponseRequest::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
}

void BSSMAP__IE__ResponseRequest::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__ResponseRequest::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__ResponseRequest::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_elementIdentifier !=  os_75) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__ResponseRequest::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 1;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(1);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  if (field_elementIdentifier !=  os_75) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_75.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__ResponseRequest_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
};

void BSSMAP__IE__ResponseRequest_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
}
}
}

void BSSMAP__IE__ResponseRequest_template::copy_value(const BSSMAP__IE__ResponseRequest& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__ResponseRequest_template::copy_template(const BSSMAP__IE__ResponseRequest_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__ResponseRequest_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__ResponseRequest_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__ResponseRequest_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ResponseRequest.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__ResponseRequest_template::BSSMAP__IE__ResponseRequest_template()
{
}

BSSMAP__IE__ResponseRequest_template::BSSMAP__IE__ResponseRequest_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__ResponseRequest_template::BSSMAP__IE__ResponseRequest_template(const BSSMAP__IE__ResponseRequest& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__ResponseRequest_template::BSSMAP__IE__ResponseRequest_template(const OPTIONAL<BSSMAP__IE__ResponseRequest>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__ResponseRequest&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_ResponseRequest from an unbound optional field.");
}
}

BSSMAP__IE__ResponseRequest_template::BSSMAP__IE__ResponseRequest_template(BSSMAP__IE__ResponseRequest_template* p_precondition, BSSMAP__IE__ResponseRequest_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__ResponseRequest_template::BSSMAP__IE__ResponseRequest_template(Dynamic_Match_Interface<BSSMAP__IE__ResponseRequest>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__ResponseRequest>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__ResponseRequest_template::BSSMAP__IE__ResponseRequest_template(const BSSMAP__IE__ResponseRequest_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__ResponseRequest_template::~BSSMAP__IE__ResponseRequest_template()
{
clean_up();
}

BSSMAP__IE__ResponseRequest_template& BSSMAP__IE__ResponseRequest_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__ResponseRequest_template& BSSMAP__IE__ResponseRequest_template::operator=(const BSSMAP__IE__ResponseRequest& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__ResponseRequest_template& BSSMAP__IE__ResponseRequest_template::operator=(const OPTIONAL<BSSMAP__IE__ResponseRequest>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__ResponseRequest&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_ResponseRequest.");
}
return *this;
}

BSSMAP__IE__ResponseRequest_template& BSSMAP__IE__ResponseRequest_template::operator=(const BSSMAP__IE__ResponseRequest_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__ResponseRequest_template::match(const BSSMAP__IE__ResponseRequest& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ResponseRequest.");
}
return FALSE;
}

boolean BSSMAP__IE__ResponseRequest_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound();
}

boolean BSSMAP__IE__ResponseRequest_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value();
}

void BSSMAP__IE__ResponseRequest_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__ResponseRequest BSSMAP__IE__ResponseRequest_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_ResponseRequest.");
BSSMAP__IE__ResponseRequest ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
return ret_val;
}

void BSSMAP__IE__ResponseRequest_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_ResponseRequest.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__ResponseRequest_template[list_length];
}

BSSMAP__IE__ResponseRequest_template& BSSMAP__IE__ResponseRequest_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_ResponseRequest.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_ResponseRequest.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__ResponseRequest_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__ResponseRequest_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ResponseRequest.");
return single_value->field_elementIdentifier;
}

int BSSMAP__IE__ResponseRequest_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ResponseRequest which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ResponseRequest containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ResponseRequest containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ResponseRequest containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ResponseRequest containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ResponseRequest containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ResponseRequest containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ResponseRequest containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ResponseRequest containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ResponseRequest.");
  }
  return 0;
}

void BSSMAP__IE__ResponseRequest_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__ResponseRequest_template::log_match(const BSSMAP__IE__ResponseRequest& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__ResponseRequest_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
}

void BSSMAP__IE__ResponseRequest_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ResponseRequest.");
}
}

void BSSMAP__IE__ResponseRequest_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__ResponseRequest_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_ResponseRequest.");
}
}

void BSSMAP__IE__ResponseRequest_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__ResponseRequest_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_ResponseRequest has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_ResponseRequest: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__ResponseRequest_template* precondition = new BSSMAP__IE__ResponseRequest_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__ResponseRequest_template* implied_template = new BSSMAP__IE__ResponseRequest_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__ResponseRequest_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_ResponseRequest");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__ResponseRequest_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ResponseRequest");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ResponseRequest");
}

boolean BSSMAP__IE__ResponseRequest_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__ResponseRequest_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__ResourceIndMethod::BSSMAP__IE__ResourceIndMethod()
{
}

BSSMAP__IE__ResourceIndMethod::BSSMAP__IE__ResourceIndMethod(const OCTETSTRING& par_elementIdentifier,
    const BITSTRING& par_resourceIndMethod,
    const BITSTRING& par_spare)
  :   field_elementIdentifier(par_elementIdentifier),
  field_resourceIndMethod(par_resourceIndMethod),
  field_spare(par_spare)
{
}

BSSMAP__IE__ResourceIndMethod::BSSMAP__IE__ResourceIndMethod(const BSSMAP__IE__ResourceIndMethod& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.resourceIndMethod().is_bound()) field_resourceIndMethod = other_value.resourceIndMethod();
else field_resourceIndMethod.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void BSSMAP__IE__ResourceIndMethod::clean_up()
{
field_elementIdentifier.clean_up();
field_resourceIndMethod.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__ResourceIndMethod::get_descriptor() const { return &BSSMAP__IE__ResourceIndMethod_descr_; }
BSSMAP__IE__ResourceIndMethod& BSSMAP__IE__ResourceIndMethod::operator=(const BSSMAP__IE__ResourceIndMethod& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.resourceIndMethod().is_bound()) field_resourceIndMethod = other_value.resourceIndMethod();
  else field_resourceIndMethod.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean BSSMAP__IE__ResourceIndMethod::operator==(const BSSMAP__IE__ResourceIndMethod& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_resourceIndMethod==other_value.field_resourceIndMethod
  && field_spare==other_value.field_spare;
}

boolean BSSMAP__IE__ResourceIndMethod::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_resourceIndMethod.is_bound())
  || (field_spare.is_bound());
}
boolean BSSMAP__IE__ResourceIndMethod::is_value() const
{
return field_elementIdentifier.is_value()
  && field_resourceIndMethod.is_value()
  && field_spare.is_value();
}
void BSSMAP__IE__ResourceIndMethod::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", resourceIndMethod := ");
field_resourceIndMethod.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__ResourceIndMethod::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (resourceIndMethod().is_bound()) resourceIndMethod().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void BSSMAP__IE__ResourceIndMethod::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) resourceIndMethod().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "resourceIndMethod")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          resourceIndMethod().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_ResourceIndMethod");
  }
}

void BSSMAP__IE__ResourceIndMethod::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_resourceIndMethod.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void BSSMAP__IE__ResourceIndMethod::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_resourceIndMethod.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void BSSMAP__IE__ResourceIndMethod::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__ResourceIndMethod::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__ResourceIndMethod::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_resourceIndMethod.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__ResourceIndMethod::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT4_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_resourceIndMethod.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__ResourceIndMethod_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
BITSTRING_template field_resourceIndMethod;
BITSTRING_template field_spare;
};

void BSSMAP__IE__ResourceIndMethod_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_resourceIndMethod = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void BSSMAP__IE__ResourceIndMethod_template::copy_value(const BSSMAP__IE__ResourceIndMethod& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.resourceIndMethod().is_bound()) {
  single_value->field_resourceIndMethod = other_value.resourceIndMethod();
} else {
  single_value->field_resourceIndMethod.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__ResourceIndMethod_template::copy_template(const BSSMAP__IE__ResourceIndMethod_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.resourceIndMethod().get_selection()) {
single_value->field_resourceIndMethod = other_value.resourceIndMethod();
} else {
single_value->field_resourceIndMethod.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__ResourceIndMethod_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__ResourceIndMethod_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__ResourceIndMethod_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__ResourceIndMethod_template::BSSMAP__IE__ResourceIndMethod_template()
{
}

BSSMAP__IE__ResourceIndMethod_template::BSSMAP__IE__ResourceIndMethod_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__ResourceIndMethod_template::BSSMAP__IE__ResourceIndMethod_template(const BSSMAP__IE__ResourceIndMethod& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__ResourceIndMethod_template::BSSMAP__IE__ResourceIndMethod_template(const OPTIONAL<BSSMAP__IE__ResourceIndMethod>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__ResourceIndMethod&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod from an unbound optional field.");
}
}

BSSMAP__IE__ResourceIndMethod_template::BSSMAP__IE__ResourceIndMethod_template(BSSMAP__IE__ResourceIndMethod_template* p_precondition, BSSMAP__IE__ResourceIndMethod_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__ResourceIndMethod_template::BSSMAP__IE__ResourceIndMethod_template(Dynamic_Match_Interface<BSSMAP__IE__ResourceIndMethod>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__ResourceIndMethod>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__ResourceIndMethod_template::BSSMAP__IE__ResourceIndMethod_template(const BSSMAP__IE__ResourceIndMethod_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__ResourceIndMethod_template::~BSSMAP__IE__ResourceIndMethod_template()
{
clean_up();
}

BSSMAP__IE__ResourceIndMethod_template& BSSMAP__IE__ResourceIndMethod_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__ResourceIndMethod_template& BSSMAP__IE__ResourceIndMethod_template::operator=(const BSSMAP__IE__ResourceIndMethod& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__ResourceIndMethod_template& BSSMAP__IE__ResourceIndMethod_template::operator=(const OPTIONAL<BSSMAP__IE__ResourceIndMethod>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__ResourceIndMethod&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod.");
}
return *this;
}

BSSMAP__IE__ResourceIndMethod_template& BSSMAP__IE__ResourceIndMethod_template::operator=(const BSSMAP__IE__ResourceIndMethod_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__ResourceIndMethod_template::match(const BSSMAP__IE__ResourceIndMethod& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.resourceIndMethod().is_bound()) return FALSE;
if(!single_value->field_resourceIndMethod.match(other_value.resourceIndMethod(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod.");
}
return FALSE;
}

boolean BSSMAP__IE__ResourceIndMethod_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_resourceIndMethod.is_bound()
 || single_value->field_spare.is_bound();
}

boolean BSSMAP__IE__ResourceIndMethod_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_resourceIndMethod.is_value()
 && single_value->field_spare.is_value();
}

void BSSMAP__IE__ResourceIndMethod_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__ResourceIndMethod BSSMAP__IE__ResourceIndMethod_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod.");
BSSMAP__IE__ResourceIndMethod ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_resourceIndMethod.is_bound()) {
ret_val.resourceIndMethod() = single_value->field_resourceIndMethod.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void BSSMAP__IE__ResourceIndMethod_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__ResourceIndMethod_template[list_length];
}

BSSMAP__IE__ResourceIndMethod_template& BSSMAP__IE__ResourceIndMethod_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__ResourceIndMethod_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__ResourceIndMethod_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod.");
return single_value->field_elementIdentifier;
}

BITSTRING_template& BSSMAP__IE__ResourceIndMethod_template::resourceIndMethod()
{
set_specific();
return single_value->field_resourceIndMethod;
}

const BITSTRING_template& BSSMAP__IE__ResourceIndMethod_template::resourceIndMethod() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field resourceIndMethod of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod.");
return single_value->field_resourceIndMethod;
}

BITSTRING_template& BSSMAP__IE__ResourceIndMethod_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& BSSMAP__IE__ResourceIndMethod_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod.");
return single_value->field_spare;
}

int BSSMAP__IE__ResourceIndMethod_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod.");
  }
  return 0;
}

void BSSMAP__IE__ResourceIndMethod_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", resourceIndMethod := ");
single_value->field_resourceIndMethod.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__ResourceIndMethod_template::log_match(const BSSMAP__IE__ResourceIndMethod& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_resourceIndMethod.match(match_value.resourceIndMethod(), legacy)){
TTCN_Logger::log_logmatch_info(".resourceIndMethod");
single_value->field_resourceIndMethod.log_match(match_value.resourceIndMethod(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", resourceIndMethod := ");
single_value->field_resourceIndMethod.log_match(match_value.resourceIndMethod(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__ResourceIndMethod_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (resourceIndMethod().is_bound()) resourceIndMethod().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void BSSMAP__IE__ResourceIndMethod_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_resourceIndMethod.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod.");
}
}

void BSSMAP__IE__ResourceIndMethod_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_resourceIndMethod.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__ResourceIndMethod_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod.");
}
}

void BSSMAP__IE__ResourceIndMethod_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__ResourceIndMethod_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) resourceIndMethod().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "resourceIndMethod")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          resourceIndMethod().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_ResourceIndMethod: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__ResourceIndMethod_template* precondition = new BSSMAP__IE__ResourceIndMethod_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__ResourceIndMethod_template* implied_template = new BSSMAP__IE__ResourceIndMethod_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__ResourceIndMethod_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_ResourceIndMethod");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__ResourceIndMethod_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ResourceIndMethod");
single_value->field_resourceIndMethod.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ResourceIndMethod");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ResourceIndMethod");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ResourceIndMethod");
}

boolean BSSMAP__IE__ResourceIndMethod_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__ResourceIndMethod_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__ClassmarkInformationType1::BSSMAP__IE__ClassmarkInformationType1()
{
}

BSSMAP__IE__ClassmarkInformationType1::BSSMAP__IE__ClassmarkInformationType1(const OCTETSTRING& par_elementIdentifier,
    const BITSTRING& par_rf__PowerCapability,
    const BITSTRING& par_a5__1,
    const BITSTRING& par_esind,
    const BITSTRING& par_revisionLevel,
    const BITSTRING& par_spare1__1)
  :   field_elementIdentifier(par_elementIdentifier),
  field_rf__PowerCapability(par_rf__PowerCapability),
  field_a5__1(par_a5__1),
  field_esind(par_esind),
  field_revisionLevel(par_revisionLevel),
  field_spare1__1(par_spare1__1)
{
}

BSSMAP__IE__ClassmarkInformationType1::BSSMAP__IE__ClassmarkInformationType1(const BSSMAP__IE__ClassmarkInformationType1& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.rf__PowerCapability().is_bound()) field_rf__PowerCapability = other_value.rf__PowerCapability();
else field_rf__PowerCapability.clean_up();
if (other_value.a5__1().is_bound()) field_a5__1 = other_value.a5__1();
else field_a5__1.clean_up();
if (other_value.esind().is_bound()) field_esind = other_value.esind();
else field_esind.clean_up();
if (other_value.revisionLevel().is_bound()) field_revisionLevel = other_value.revisionLevel();
else field_revisionLevel.clean_up();
if (other_value.spare1__1().is_bound()) field_spare1__1 = other_value.spare1__1();
else field_spare1__1.clean_up();
}

void BSSMAP__IE__ClassmarkInformationType1::clean_up()
{
field_elementIdentifier.clean_up();
field_rf__PowerCapability.clean_up();
field_a5__1.clean_up();
field_esind.clean_up();
field_revisionLevel.clean_up();
field_spare1__1.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__ClassmarkInformationType1::get_descriptor() const { return &BSSMAP__IE__ClassmarkInformationType1_descr_; }
BSSMAP__IE__ClassmarkInformationType1& BSSMAP__IE__ClassmarkInformationType1::operator=(const BSSMAP__IE__ClassmarkInformationType1& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.rf__PowerCapability().is_bound()) field_rf__PowerCapability = other_value.rf__PowerCapability();
  else field_rf__PowerCapability.clean_up();
  if (other_value.a5__1().is_bound()) field_a5__1 = other_value.a5__1();
  else field_a5__1.clean_up();
  if (other_value.esind().is_bound()) field_esind = other_value.esind();
  else field_esind.clean_up();
  if (other_value.revisionLevel().is_bound()) field_revisionLevel = other_value.revisionLevel();
  else field_revisionLevel.clean_up();
  if (other_value.spare1__1().is_bound()) field_spare1__1 = other_value.spare1__1();
  else field_spare1__1.clean_up();
}
return *this;
}

boolean BSSMAP__IE__ClassmarkInformationType1::operator==(const BSSMAP__IE__ClassmarkInformationType1& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_rf__PowerCapability==other_value.field_rf__PowerCapability
  && field_a5__1==other_value.field_a5__1
  && field_esind==other_value.field_esind
  && field_revisionLevel==other_value.field_revisionLevel
  && field_spare1__1==other_value.field_spare1__1;
}

boolean BSSMAP__IE__ClassmarkInformationType1::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_rf__PowerCapability.is_bound())
  || (field_a5__1.is_bound())
  || (field_esind.is_bound())
  || (field_revisionLevel.is_bound())
  || (field_spare1__1.is_bound());
}
boolean BSSMAP__IE__ClassmarkInformationType1::is_value() const
{
return field_elementIdentifier.is_value()
  && field_rf__PowerCapability.is_value()
  && field_a5__1.is_value()
  && field_esind.is_value()
  && field_revisionLevel.is_value()
  && field_spare1__1.is_value();
}
void BSSMAP__IE__ClassmarkInformationType1::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", rf_PowerCapability := ");
field_rf__PowerCapability.log();
TTCN_Logger::log_event_str(", a5_1 := ");
field_a5__1.log();
TTCN_Logger::log_event_str(", esind := ");
field_esind.log();
TTCN_Logger::log_event_str(", revisionLevel := ");
field_revisionLevel.log();
TTCN_Logger::log_event_str(", spare1_1 := ");
field_spare1__1.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__ClassmarkInformationType1::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (rf__PowerCapability().is_bound()) rf__PowerCapability().set_implicit_omit();
if (a5__1().is_bound()) a5__1().set_implicit_omit();
if (esind().is_bound()) esind().set_implicit_omit();
if (revisionLevel().is_bound()) revisionLevel().set_implicit_omit();
if (spare1__1().is_bound()) spare1__1().set_implicit_omit();
}

void BSSMAP__IE__ClassmarkInformationType1::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1 has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) rf__PowerCapability().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) a5__1().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) esind().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) revisionLevel().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) spare1__1().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rf_PowerCapability")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rf__PowerCapability().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "a5_1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          a5__1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "esind")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          esind().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "revisionLevel")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          revisionLevel().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare1_1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare1__1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1");
  }
}

void BSSMAP__IE__ClassmarkInformationType1::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_rf__PowerCapability.encode_text(text_buf);
field_a5__1.encode_text(text_buf);
field_esind.encode_text(text_buf);
field_revisionLevel.encode_text(text_buf);
field_spare1__1.encode_text(text_buf);
}

void BSSMAP__IE__ClassmarkInformationType1::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_rf__PowerCapability.decode_text(text_buf);
field_a5__1.decode_text(text_buf);
field_esind.decode_text(text_buf);
field_revisionLevel.decode_text(text_buf);
field_spare1__1.decode_text(text_buf);
}

void BSSMAP__IE__ClassmarkInformationType1::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__ClassmarkInformationType1::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__ClassmarkInformationType1::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT3_descr_.raw->forceomit);
  decoded_field_length = field_rf__PowerCapability.RAW_decode(General__Types::BIT3_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_a5__1.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_esind.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_revisionLevel.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_5_force_omit(5, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_spare1__1.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_elementIdentifier !=  os_78) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__ClassmarkInformationType1::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 6;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(6);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT3_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::BIT2_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, General__Types::BIT1_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_rf__PowerCapability.RAW_encode(General__Types::BIT3_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_a5__1.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_esind.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_revisionLevel.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_spare1__1.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[5]);
  if (field_elementIdentifier !=  os_78) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_78.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__ClassmarkInformationType1_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
BITSTRING_template field_rf__PowerCapability;
BITSTRING_template field_a5__1;
BITSTRING_template field_esind;
BITSTRING_template field_revisionLevel;
BITSTRING_template field_spare1__1;
};

void BSSMAP__IE__ClassmarkInformationType1_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_rf__PowerCapability = ANY_VALUE;
single_value->field_a5__1 = ANY_VALUE;
single_value->field_esind = ANY_VALUE;
single_value->field_revisionLevel = ANY_VALUE;
single_value->field_spare1__1 = ANY_VALUE;
}
}
}

void BSSMAP__IE__ClassmarkInformationType1_template::copy_value(const BSSMAP__IE__ClassmarkInformationType1& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.rf__PowerCapability().is_bound()) {
  single_value->field_rf__PowerCapability = other_value.rf__PowerCapability();
} else {
  single_value->field_rf__PowerCapability.clean_up();
}
if (other_value.a5__1().is_bound()) {
  single_value->field_a5__1 = other_value.a5__1();
} else {
  single_value->field_a5__1.clean_up();
}
if (other_value.esind().is_bound()) {
  single_value->field_esind = other_value.esind();
} else {
  single_value->field_esind.clean_up();
}
if (other_value.revisionLevel().is_bound()) {
  single_value->field_revisionLevel = other_value.revisionLevel();
} else {
  single_value->field_revisionLevel.clean_up();
}
if (other_value.spare1__1().is_bound()) {
  single_value->field_spare1__1 = other_value.spare1__1();
} else {
  single_value->field_spare1__1.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__ClassmarkInformationType1_template::copy_template(const BSSMAP__IE__ClassmarkInformationType1_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rf__PowerCapability().get_selection()) {
single_value->field_rf__PowerCapability = other_value.rf__PowerCapability();
} else {
single_value->field_rf__PowerCapability.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.a5__1().get_selection()) {
single_value->field_a5__1 = other_value.a5__1();
} else {
single_value->field_a5__1.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.esind().get_selection()) {
single_value->field_esind = other_value.esind();
} else {
single_value->field_esind.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.revisionLevel().get_selection()) {
single_value->field_revisionLevel = other_value.revisionLevel();
} else {
single_value->field_revisionLevel.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare1__1().get_selection()) {
single_value->field_spare1__1 = other_value.spare1__1();
} else {
single_value->field_spare1__1.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__ClassmarkInformationType1_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__ClassmarkInformationType1_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__ClassmarkInformationType1_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__ClassmarkInformationType1_template::BSSMAP__IE__ClassmarkInformationType1_template()
{
}

BSSMAP__IE__ClassmarkInformationType1_template::BSSMAP__IE__ClassmarkInformationType1_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__ClassmarkInformationType1_template::BSSMAP__IE__ClassmarkInformationType1_template(const BSSMAP__IE__ClassmarkInformationType1& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__ClassmarkInformationType1_template::BSSMAP__IE__ClassmarkInformationType1_template(const OPTIONAL<BSSMAP__IE__ClassmarkInformationType1>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__ClassmarkInformationType1&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1 from an unbound optional field.");
}
}

BSSMAP__IE__ClassmarkInformationType1_template::BSSMAP__IE__ClassmarkInformationType1_template(BSSMAP__IE__ClassmarkInformationType1_template* p_precondition, BSSMAP__IE__ClassmarkInformationType1_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__ClassmarkInformationType1_template::BSSMAP__IE__ClassmarkInformationType1_template(Dynamic_Match_Interface<BSSMAP__IE__ClassmarkInformationType1>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__ClassmarkInformationType1>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__ClassmarkInformationType1_template::BSSMAP__IE__ClassmarkInformationType1_template(const BSSMAP__IE__ClassmarkInformationType1_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__ClassmarkInformationType1_template::~BSSMAP__IE__ClassmarkInformationType1_template()
{
clean_up();
}

BSSMAP__IE__ClassmarkInformationType1_template& BSSMAP__IE__ClassmarkInformationType1_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__ClassmarkInformationType1_template& BSSMAP__IE__ClassmarkInformationType1_template::operator=(const BSSMAP__IE__ClassmarkInformationType1& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__ClassmarkInformationType1_template& BSSMAP__IE__ClassmarkInformationType1_template::operator=(const OPTIONAL<BSSMAP__IE__ClassmarkInformationType1>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__ClassmarkInformationType1&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1.");
}
return *this;
}

BSSMAP__IE__ClassmarkInformationType1_template& BSSMAP__IE__ClassmarkInformationType1_template::operator=(const BSSMAP__IE__ClassmarkInformationType1_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__ClassmarkInformationType1_template::match(const BSSMAP__IE__ClassmarkInformationType1& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.rf__PowerCapability().is_bound()) return FALSE;
if(!single_value->field_rf__PowerCapability.match(other_value.rf__PowerCapability(), legacy))return FALSE;
if(!other_value.a5__1().is_bound()) return FALSE;
if(!single_value->field_a5__1.match(other_value.a5__1(), legacy))return FALSE;
if(!other_value.esind().is_bound()) return FALSE;
if(!single_value->field_esind.match(other_value.esind(), legacy))return FALSE;
if(!other_value.revisionLevel().is_bound()) return FALSE;
if(!single_value->field_revisionLevel.match(other_value.revisionLevel(), legacy))return FALSE;
if(!other_value.spare1__1().is_bound()) return FALSE;
if(!single_value->field_spare1__1.match(other_value.spare1__1(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1.");
}
return FALSE;
}

boolean BSSMAP__IE__ClassmarkInformationType1_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_rf__PowerCapability.is_bound()
 || single_value->field_a5__1.is_bound()
 || single_value->field_esind.is_bound()
 || single_value->field_revisionLevel.is_bound()
 || single_value->field_spare1__1.is_bound();
}

boolean BSSMAP__IE__ClassmarkInformationType1_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_rf__PowerCapability.is_value()
 && single_value->field_a5__1.is_value()
 && single_value->field_esind.is_value()
 && single_value->field_revisionLevel.is_value()
 && single_value->field_spare1__1.is_value();
}

void BSSMAP__IE__ClassmarkInformationType1_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__ClassmarkInformationType1 BSSMAP__IE__ClassmarkInformationType1_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1.");
BSSMAP__IE__ClassmarkInformationType1 ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_rf__PowerCapability.is_bound()) {
ret_val.rf__PowerCapability() = single_value->field_rf__PowerCapability.valueof();
}
if (single_value->field_a5__1.is_bound()) {
ret_val.a5__1() = single_value->field_a5__1.valueof();
}
if (single_value->field_esind.is_bound()) {
ret_val.esind() = single_value->field_esind.valueof();
}
if (single_value->field_revisionLevel.is_bound()) {
ret_val.revisionLevel() = single_value->field_revisionLevel.valueof();
}
if (single_value->field_spare1__1.is_bound()) {
ret_val.spare1__1() = single_value->field_spare1__1.valueof();
}
return ret_val;
}

void BSSMAP__IE__ClassmarkInformationType1_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__ClassmarkInformationType1_template[list_length];
}

BSSMAP__IE__ClassmarkInformationType1_template& BSSMAP__IE__ClassmarkInformationType1_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__ClassmarkInformationType1_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__ClassmarkInformationType1_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1.");
return single_value->field_elementIdentifier;
}

BITSTRING_template& BSSMAP__IE__ClassmarkInformationType1_template::rf__PowerCapability()
{
set_specific();
return single_value->field_rf__PowerCapability;
}

const BITSTRING_template& BSSMAP__IE__ClassmarkInformationType1_template::rf__PowerCapability() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rf_PowerCapability of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1.");
return single_value->field_rf__PowerCapability;
}

BITSTRING_template& BSSMAP__IE__ClassmarkInformationType1_template::a5__1()
{
set_specific();
return single_value->field_a5__1;
}

const BITSTRING_template& BSSMAP__IE__ClassmarkInformationType1_template::a5__1() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field a5_1 of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1.");
return single_value->field_a5__1;
}

BITSTRING_template& BSSMAP__IE__ClassmarkInformationType1_template::esind()
{
set_specific();
return single_value->field_esind;
}

const BITSTRING_template& BSSMAP__IE__ClassmarkInformationType1_template::esind() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field esind of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1.");
return single_value->field_esind;
}

BITSTRING_template& BSSMAP__IE__ClassmarkInformationType1_template::revisionLevel()
{
set_specific();
return single_value->field_revisionLevel;
}

const BITSTRING_template& BSSMAP__IE__ClassmarkInformationType1_template::revisionLevel() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field revisionLevel of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1.");
return single_value->field_revisionLevel;
}

BITSTRING_template& BSSMAP__IE__ClassmarkInformationType1_template::spare1__1()
{
set_specific();
return single_value->field_spare1__1;
}

const BITSTRING_template& BSSMAP__IE__ClassmarkInformationType1_template::spare1__1() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare1_1 of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1.");
return single_value->field_spare1__1;
}

int BSSMAP__IE__ClassmarkInformationType1_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1 which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 6;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1 containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1 containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1 containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1 containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1 containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1 containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1 containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1 containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1.");
  }
  return 0;
}

void BSSMAP__IE__ClassmarkInformationType1_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", rf_PowerCapability := ");
single_value->field_rf__PowerCapability.log();
TTCN_Logger::log_event_str(", a5_1 := ");
single_value->field_a5__1.log();
TTCN_Logger::log_event_str(", esind := ");
single_value->field_esind.log();
TTCN_Logger::log_event_str(", revisionLevel := ");
single_value->field_revisionLevel.log();
TTCN_Logger::log_event_str(", spare1_1 := ");
single_value->field_spare1__1.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__ClassmarkInformationType1_template::log_match(const BSSMAP__IE__ClassmarkInformationType1& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rf__PowerCapability.match(match_value.rf__PowerCapability(), legacy)){
TTCN_Logger::log_logmatch_info(".rf_PowerCapability");
single_value->field_rf__PowerCapability.log_match(match_value.rf__PowerCapability(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_a5__1.match(match_value.a5__1(), legacy)){
TTCN_Logger::log_logmatch_info(".a5_1");
single_value->field_a5__1.log_match(match_value.a5__1(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_esind.match(match_value.esind(), legacy)){
TTCN_Logger::log_logmatch_info(".esind");
single_value->field_esind.log_match(match_value.esind(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_revisionLevel.match(match_value.revisionLevel(), legacy)){
TTCN_Logger::log_logmatch_info(".revisionLevel");
single_value->field_revisionLevel.log_match(match_value.revisionLevel(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare1__1.match(match_value.spare1__1(), legacy)){
TTCN_Logger::log_logmatch_info(".spare1_1");
single_value->field_spare1__1.log_match(match_value.spare1__1(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", rf_PowerCapability := ");
single_value->field_rf__PowerCapability.log_match(match_value.rf__PowerCapability(), legacy);
TTCN_Logger::log_event_str(", a5_1 := ");
single_value->field_a5__1.log_match(match_value.a5__1(), legacy);
TTCN_Logger::log_event_str(", esind := ");
single_value->field_esind.log_match(match_value.esind(), legacy);
TTCN_Logger::log_event_str(", revisionLevel := ");
single_value->field_revisionLevel.log_match(match_value.revisionLevel(), legacy);
TTCN_Logger::log_event_str(", spare1_1 := ");
single_value->field_spare1__1.log_match(match_value.spare1__1(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__ClassmarkInformationType1_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (rf__PowerCapability().is_bound()) rf__PowerCapability().set_implicit_omit();
if (a5__1().is_bound()) a5__1().set_implicit_omit();
if (esind().is_bound()) esind().set_implicit_omit();
if (revisionLevel().is_bound()) revisionLevel().set_implicit_omit();
if (spare1__1().is_bound()) spare1__1().set_implicit_omit();
}

void BSSMAP__IE__ClassmarkInformationType1_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_rf__PowerCapability.encode_text(text_buf);
single_value->field_a5__1.encode_text(text_buf);
single_value->field_esind.encode_text(text_buf);
single_value->field_revisionLevel.encode_text(text_buf);
single_value->field_spare1__1.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1.");
}
}

void BSSMAP__IE__ClassmarkInformationType1_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_rf__PowerCapability.decode_text(text_buf);
single_value->field_a5__1.decode_text(text_buf);
single_value->field_esind.decode_text(text_buf);
single_value->field_revisionLevel.decode_text(text_buf);
single_value->field_spare1__1.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__ClassmarkInformationType1_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1.");
}
}

void BSSMAP__IE__ClassmarkInformationType1_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__ClassmarkInformationType1_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1 has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) rf__PowerCapability().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) a5__1().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) esind().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) revisionLevel().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) spare1__1().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rf_PowerCapability")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rf__PowerCapability().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "a5_1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          a5__1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "esind")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          esind().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "revisionLevel")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          revisionLevel().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare1_1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare1__1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__ClassmarkInformationType1_template* precondition = new BSSMAP__IE__ClassmarkInformationType1_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__ClassmarkInformationType1_template* implied_template = new BSSMAP__IE__ClassmarkInformationType1_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__ClassmarkInformationType1_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__ClassmarkInformationType1_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1");
single_value->field_rf__PowerCapability.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1");
single_value->field_a5__1.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1");
single_value->field_esind.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1");
single_value->field_revisionLevel.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1");
single_value->field_spare1__1.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ClassmarkInformationType1");
}

boolean BSSMAP__IE__ClassmarkInformationType1_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__ClassmarkInformationType1_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__CircuitIdentityCodeList::BSSMAP__IE__CircuitIdentityCodeList()
{
}

BSSMAP__IE__CircuitIdentityCodeList::BSSMAP__IE__CircuitIdentityCodeList(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_range,
    const OCTETSTRING& par_status)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_range(par_range),
  field_status(par_status)
{
}

BSSMAP__IE__CircuitIdentityCodeList::BSSMAP__IE__CircuitIdentityCodeList(const BSSMAP__IE__CircuitIdentityCodeList& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.range().is_bound()) field_range = other_value.range();
else field_range.clean_up();
if (other_value.status().is_bound()) field_status = other_value.status();
else field_status.clean_up();
}

void BSSMAP__IE__CircuitIdentityCodeList::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_range.clean_up();
field_status.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__CircuitIdentityCodeList::get_descriptor() const { return &BSSMAP__IE__CircuitIdentityCodeList_descr_; }
BSSMAP__IE__CircuitIdentityCodeList& BSSMAP__IE__CircuitIdentityCodeList::operator=(const BSSMAP__IE__CircuitIdentityCodeList& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.range().is_bound()) field_range = other_value.range();
  else field_range.clean_up();
  if (other_value.status().is_bound()) field_status = other_value.status();
  else field_status.clean_up();
}
return *this;
}

boolean BSSMAP__IE__CircuitIdentityCodeList::operator==(const BSSMAP__IE__CircuitIdentityCodeList& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_range==other_value.field_range
  && field_status==other_value.field_status;
}

boolean BSSMAP__IE__CircuitIdentityCodeList::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_range.is_bound())
  || (field_status.is_bound());
}
boolean BSSMAP__IE__CircuitIdentityCodeList::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_range.is_value()
  && field_status.is_value();
}
void BSSMAP__IE__CircuitIdentityCodeList::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", range := ");
field_range.log();
TTCN_Logger::log_event_str(", status := ");
field_status.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__CircuitIdentityCodeList::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (range().is_bound()) range().set_implicit_omit();
if (status().is_bound()) status().set_implicit_omit();
}

void BSSMAP__IE__CircuitIdentityCodeList::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) range().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) status().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "range")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          range().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList");
  }
}

void BSSMAP__IE__CircuitIdentityCodeList::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_range.encode_text(text_buf);
field_status.encode_text(text_buf);
}

void BSSMAP__IE__CircuitIdentityCodeList::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_range.decode_text(text_buf);
field_status.decode_text(text_buf);
}

void BSSMAP__IE__CircuitIdentityCodeList::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__CircuitIdentityCodeList::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__CircuitIdentityCodeList::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__CircuitIdentityCodeList_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__CircuitIdentityCodeList_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__CircuitIdentityCodeList_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_range.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::OCTN_descr_.raw->forceomit);
  decoded_field_length = field_status.RAW_decode(General__Types::OCTN_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_51) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__CircuitIdentityCodeList::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__CircuitIdentityCodeList_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::OCTN_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__CircuitIdentityCodeList_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 2;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(2);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  encoded_length += field_range.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_status.RAW_encode(General__Types::OCTN_descr_, *myleaf.body.node.nodes[3]);
  if (field_elementIdentifier !=  os_51) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_51.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__CircuitIdentityCodeList_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_range;
OCTETSTRING_template field_status;
};

void BSSMAP__IE__CircuitIdentityCodeList_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_range = ANY_VALUE;
single_value->field_status = ANY_VALUE;
}
}
}

void BSSMAP__IE__CircuitIdentityCodeList_template::copy_value(const BSSMAP__IE__CircuitIdentityCodeList& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.range().is_bound()) {
  single_value->field_range = other_value.range();
} else {
  single_value->field_range.clean_up();
}
if (other_value.status().is_bound()) {
  single_value->field_status = other_value.status();
} else {
  single_value->field_status.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__CircuitIdentityCodeList_template::copy_template(const BSSMAP__IE__CircuitIdentityCodeList_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.range().get_selection()) {
single_value->field_range = other_value.range();
} else {
single_value->field_range.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.status().get_selection()) {
single_value->field_status = other_value.status();
} else {
single_value->field_status.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__CircuitIdentityCodeList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__CircuitIdentityCodeList_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__CircuitIdentityCodeList_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__CircuitIdentityCodeList_template::BSSMAP__IE__CircuitIdentityCodeList_template()
{
}

BSSMAP__IE__CircuitIdentityCodeList_template::BSSMAP__IE__CircuitIdentityCodeList_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__CircuitIdentityCodeList_template::BSSMAP__IE__CircuitIdentityCodeList_template(const BSSMAP__IE__CircuitIdentityCodeList& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__CircuitIdentityCodeList_template::BSSMAP__IE__CircuitIdentityCodeList_template(const OPTIONAL<BSSMAP__IE__CircuitIdentityCodeList>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__CircuitIdentityCodeList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList from an unbound optional field.");
}
}

BSSMAP__IE__CircuitIdentityCodeList_template::BSSMAP__IE__CircuitIdentityCodeList_template(BSSMAP__IE__CircuitIdentityCodeList_template* p_precondition, BSSMAP__IE__CircuitIdentityCodeList_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__CircuitIdentityCodeList_template::BSSMAP__IE__CircuitIdentityCodeList_template(Dynamic_Match_Interface<BSSMAP__IE__CircuitIdentityCodeList>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__CircuitIdentityCodeList>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__CircuitIdentityCodeList_template::BSSMAP__IE__CircuitIdentityCodeList_template(const BSSMAP__IE__CircuitIdentityCodeList_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__CircuitIdentityCodeList_template::~BSSMAP__IE__CircuitIdentityCodeList_template()
{
clean_up();
}

BSSMAP__IE__CircuitIdentityCodeList_template& BSSMAP__IE__CircuitIdentityCodeList_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__CircuitIdentityCodeList_template& BSSMAP__IE__CircuitIdentityCodeList_template::operator=(const BSSMAP__IE__CircuitIdentityCodeList& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__CircuitIdentityCodeList_template& BSSMAP__IE__CircuitIdentityCodeList_template::operator=(const OPTIONAL<BSSMAP__IE__CircuitIdentityCodeList>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__CircuitIdentityCodeList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList.");
}
return *this;
}

BSSMAP__IE__CircuitIdentityCodeList_template& BSSMAP__IE__CircuitIdentityCodeList_template::operator=(const BSSMAP__IE__CircuitIdentityCodeList_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__CircuitIdentityCodeList_template::match(const BSSMAP__IE__CircuitIdentityCodeList& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.range().is_bound()) return FALSE;
if(!single_value->field_range.match(other_value.range(), legacy))return FALSE;
if(!other_value.status().is_bound()) return FALSE;
if(!single_value->field_status.match(other_value.status(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList.");
}
return FALSE;
}

boolean BSSMAP__IE__CircuitIdentityCodeList_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_range.is_bound()
 || single_value->field_status.is_bound();
}

boolean BSSMAP__IE__CircuitIdentityCodeList_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_range.is_value()
 && single_value->field_status.is_value();
}

void BSSMAP__IE__CircuitIdentityCodeList_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__CircuitIdentityCodeList BSSMAP__IE__CircuitIdentityCodeList_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList.");
BSSMAP__IE__CircuitIdentityCodeList ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_range.is_bound()) {
ret_val.range() = single_value->field_range.valueof();
}
if (single_value->field_status.is_bound()) {
ret_val.status() = single_value->field_status.valueof();
}
return ret_val;
}

void BSSMAP__IE__CircuitIdentityCodeList_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__CircuitIdentityCodeList_template[list_length];
}

BSSMAP__IE__CircuitIdentityCodeList_template& BSSMAP__IE__CircuitIdentityCodeList_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__CircuitIdentityCodeList_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__CircuitIdentityCodeList_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__CircuitIdentityCodeList_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__CircuitIdentityCodeList_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& BSSMAP__IE__CircuitIdentityCodeList_template::range()
{
set_specific();
return single_value->field_range;
}

const OCTETSTRING_template& BSSMAP__IE__CircuitIdentityCodeList_template::range() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field range of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList.");
return single_value->field_range;
}

OCTETSTRING_template& BSSMAP__IE__CircuitIdentityCodeList_template::status()
{
set_specific();
return single_value->field_status;
}

const OCTETSTRING_template& BSSMAP__IE__CircuitIdentityCodeList_template::status() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field status of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList.");
return single_value->field_status;
}

int BSSMAP__IE__CircuitIdentityCodeList_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList.");
  }
  return 0;
}

void BSSMAP__IE__CircuitIdentityCodeList_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", range := ");
single_value->field_range.log();
TTCN_Logger::log_event_str(", status := ");
single_value->field_status.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__CircuitIdentityCodeList_template::log_match(const BSSMAP__IE__CircuitIdentityCodeList& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_range.match(match_value.range(), legacy)){
TTCN_Logger::log_logmatch_info(".range");
single_value->field_range.log_match(match_value.range(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_status.match(match_value.status(), legacy)){
TTCN_Logger::log_logmatch_info(".status");
single_value->field_status.log_match(match_value.status(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", range := ");
single_value->field_range.log_match(match_value.range(), legacy);
TTCN_Logger::log_event_str(", status := ");
single_value->field_status.log_match(match_value.status(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__CircuitIdentityCodeList_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (range().is_bound()) range().set_implicit_omit();
if (status().is_bound()) status().set_implicit_omit();
}

void BSSMAP__IE__CircuitIdentityCodeList_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_range.encode_text(text_buf);
single_value->field_status.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList.");
}
}

void BSSMAP__IE__CircuitIdentityCodeList_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_range.decode_text(text_buf);
single_value->field_status.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__CircuitIdentityCodeList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList.");
}
}

void BSSMAP__IE__CircuitIdentityCodeList_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__CircuitIdentityCodeList_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) range().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) status().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "range")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          range().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__CircuitIdentityCodeList_template* precondition = new BSSMAP__IE__CircuitIdentityCodeList_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__CircuitIdentityCodeList_template* implied_template = new BSSMAP__IE__CircuitIdentityCodeList_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__CircuitIdentityCodeList_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__CircuitIdentityCodeList_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList");
single_value->field_range.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList");
single_value->field_status.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CircuitIdentityCodeList");
}

boolean BSSMAP__IE__CircuitIdentityCodeList_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__CircuitIdentityCodeList_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__Diagnostics::BSSMAP__IE__Diagnostics()
{
}

BSSMAP__IE__Diagnostics::BSSMAP__IE__Diagnostics(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_errorLocation,
    const BITSTRING& par_bitPointer,
    const BITSTRING& par_spare,
    const OCTETSTRING& par_messageReceived)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_errorLocation(par_errorLocation),
  field_bitPointer(par_bitPointer),
  field_spare(par_spare),
  field_messageReceived(par_messageReceived)
{
}

BSSMAP__IE__Diagnostics::BSSMAP__IE__Diagnostics(const BSSMAP__IE__Diagnostics& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_Diagnostics.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.errorLocation().is_bound()) field_errorLocation = other_value.errorLocation();
else field_errorLocation.clean_up();
if (other_value.bitPointer().is_bound()) field_bitPointer = other_value.bitPointer();
else field_bitPointer.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.messageReceived().is_bound()) field_messageReceived = other_value.messageReceived();
else field_messageReceived.clean_up();
}

void BSSMAP__IE__Diagnostics::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_errorLocation.clean_up();
field_bitPointer.clean_up();
field_spare.clean_up();
field_messageReceived.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__Diagnostics::get_descriptor() const { return &BSSMAP__IE__Diagnostics_descr_; }
BSSMAP__IE__Diagnostics& BSSMAP__IE__Diagnostics::operator=(const BSSMAP__IE__Diagnostics& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_Diagnostics.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.errorLocation().is_bound()) field_errorLocation = other_value.errorLocation();
  else field_errorLocation.clean_up();
  if (other_value.bitPointer().is_bound()) field_bitPointer = other_value.bitPointer();
  else field_bitPointer.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.messageReceived().is_bound()) field_messageReceived = other_value.messageReceived();
  else field_messageReceived.clean_up();
}
return *this;
}

boolean BSSMAP__IE__Diagnostics::operator==(const BSSMAP__IE__Diagnostics& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_errorLocation==other_value.field_errorLocation
  && field_bitPointer==other_value.field_bitPointer
  && field_spare==other_value.field_spare
  && field_messageReceived==other_value.field_messageReceived;
}

boolean BSSMAP__IE__Diagnostics::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_errorLocation.is_bound())
  || (field_bitPointer.is_bound())
  || (field_spare.is_bound())
  || (field_messageReceived.is_bound());
}
boolean BSSMAP__IE__Diagnostics::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_errorLocation.is_value()
  && field_bitPointer.is_value()
  && field_spare.is_value()
  && field_messageReceived.is_value();
}
void BSSMAP__IE__Diagnostics::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", errorLocation := ");
field_errorLocation.log();
TTCN_Logger::log_event_str(", bitPointer := ");
field_bitPointer.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", messageReceived := ");
field_messageReceived.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__Diagnostics::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (errorLocation().is_bound()) errorLocation().set_implicit_omit();
if (bitPointer().is_bound()) bitPointer().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (messageReceived().is_bound()) messageReceived().set_implicit_omit();
}

void BSSMAP__IE__Diagnostics::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_Diagnostics has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) errorLocation().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) bitPointer().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) messageReceived().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "errorLocation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          errorLocation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bitPointer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bitPointer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageReceived")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageReceived().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_Diagnostics: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_Diagnostics");
  }
}

void BSSMAP__IE__Diagnostics::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_errorLocation.encode_text(text_buf);
field_bitPointer.encode_text(text_buf);
field_spare.encode_text(text_buf);
field_messageReceived.encode_text(text_buf);
}

void BSSMAP__IE__Diagnostics::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_errorLocation.decode_text(text_buf);
field_bitPointer.decode_text(text_buf);
field_spare.decode_text(text_buf);
field_messageReceived.decode_text(text_buf);
}

void BSSMAP__IE__Diagnostics::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__Diagnostics::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__Diagnostics::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__Diagnostics_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__Diagnostics_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__Diagnostics_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_errorLocation.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_bitPointer.RAW_decode(General__Types::BIT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_5_force_omit(5, force_omit, General__Types::OCTN_descr_.raw->forceomit);
  decoded_field_length = field_messageReceived.RAW_decode(General__Types::OCTN_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__Diagnostics::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 6;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(6);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__Diagnostics_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, General__Types::OCTN_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__Diagnostics_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 4;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(4);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  encoded_length += field_errorLocation.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_bitPointer.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_messageReceived.RAW_encode(General__Types::OCTN_descr_, *myleaf.body.node.nodes[5]);
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__Diagnostics_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_errorLocation;
BITSTRING_template field_bitPointer;
BITSTRING_template field_spare;
OCTETSTRING_template field_messageReceived;
};

void BSSMAP__IE__Diagnostics_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_errorLocation = ANY_VALUE;
single_value->field_bitPointer = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
single_value->field_messageReceived = ANY_VALUE;
}
}
}

void BSSMAP__IE__Diagnostics_template::copy_value(const BSSMAP__IE__Diagnostics& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.errorLocation().is_bound()) {
  single_value->field_errorLocation = other_value.errorLocation();
} else {
  single_value->field_errorLocation.clean_up();
}
if (other_value.bitPointer().is_bound()) {
  single_value->field_bitPointer = other_value.bitPointer();
} else {
  single_value->field_bitPointer.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.messageReceived().is_bound()) {
  single_value->field_messageReceived = other_value.messageReceived();
} else {
  single_value->field_messageReceived.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__Diagnostics_template::copy_template(const BSSMAP__IE__Diagnostics_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.errorLocation().get_selection()) {
single_value->field_errorLocation = other_value.errorLocation();
} else {
single_value->field_errorLocation.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.bitPointer().get_selection()) {
single_value->field_bitPointer = other_value.bitPointer();
} else {
single_value->field_bitPointer.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.messageReceived().get_selection()) {
single_value->field_messageReceived = other_value.messageReceived();
} else {
single_value->field_messageReceived.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__Diagnostics_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__Diagnostics_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__Diagnostics_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_Diagnostics.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__Diagnostics_template::BSSMAP__IE__Diagnostics_template()
{
}

BSSMAP__IE__Diagnostics_template::BSSMAP__IE__Diagnostics_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__Diagnostics_template::BSSMAP__IE__Diagnostics_template(const BSSMAP__IE__Diagnostics& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__Diagnostics_template::BSSMAP__IE__Diagnostics_template(const OPTIONAL<BSSMAP__IE__Diagnostics>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__Diagnostics&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_Diagnostics from an unbound optional field.");
}
}

BSSMAP__IE__Diagnostics_template::BSSMAP__IE__Diagnostics_template(BSSMAP__IE__Diagnostics_template* p_precondition, BSSMAP__IE__Diagnostics_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__Diagnostics_template::BSSMAP__IE__Diagnostics_template(Dynamic_Match_Interface<BSSMAP__IE__Diagnostics>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__Diagnostics>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__Diagnostics_template::BSSMAP__IE__Diagnostics_template(const BSSMAP__IE__Diagnostics_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__Diagnostics_template::~BSSMAP__IE__Diagnostics_template()
{
clean_up();
}

BSSMAP__IE__Diagnostics_template& BSSMAP__IE__Diagnostics_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__Diagnostics_template& BSSMAP__IE__Diagnostics_template::operator=(const BSSMAP__IE__Diagnostics& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__Diagnostics_template& BSSMAP__IE__Diagnostics_template::operator=(const OPTIONAL<BSSMAP__IE__Diagnostics>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__Diagnostics&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_Diagnostics.");
}
return *this;
}

BSSMAP__IE__Diagnostics_template& BSSMAP__IE__Diagnostics_template::operator=(const BSSMAP__IE__Diagnostics_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__Diagnostics_template::match(const BSSMAP__IE__Diagnostics& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.errorLocation().is_bound()) return FALSE;
if(!single_value->field_errorLocation.match(other_value.errorLocation(), legacy))return FALSE;
if(!other_value.bitPointer().is_bound()) return FALSE;
if(!single_value->field_bitPointer.match(other_value.bitPointer(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.messageReceived().is_bound()) return FALSE;
if(!single_value->field_messageReceived.match(other_value.messageReceived(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_Diagnostics.");
}
return FALSE;
}

boolean BSSMAP__IE__Diagnostics_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_errorLocation.is_bound()
 || single_value->field_bitPointer.is_bound()
 || single_value->field_spare.is_bound()
 || single_value->field_messageReceived.is_bound();
}

boolean BSSMAP__IE__Diagnostics_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_errorLocation.is_value()
 && single_value->field_bitPointer.is_value()
 && single_value->field_spare.is_value()
 && single_value->field_messageReceived.is_value();
}

void BSSMAP__IE__Diagnostics_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__Diagnostics BSSMAP__IE__Diagnostics_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_Diagnostics.");
BSSMAP__IE__Diagnostics ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_errorLocation.is_bound()) {
ret_val.errorLocation() = single_value->field_errorLocation.valueof();
}
if (single_value->field_bitPointer.is_bound()) {
ret_val.bitPointer() = single_value->field_bitPointer.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_messageReceived.is_bound()) {
ret_val.messageReceived() = single_value->field_messageReceived.valueof();
}
return ret_val;
}

void BSSMAP__IE__Diagnostics_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_Diagnostics.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__Diagnostics_template[list_length];
}

BSSMAP__IE__Diagnostics_template& BSSMAP__IE__Diagnostics_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_Diagnostics.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_Diagnostics.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__Diagnostics_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__Diagnostics_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_Diagnostics.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__Diagnostics_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__Diagnostics_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_Diagnostics.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& BSSMAP__IE__Diagnostics_template::errorLocation()
{
set_specific();
return single_value->field_errorLocation;
}

const OCTETSTRING_template& BSSMAP__IE__Diagnostics_template::errorLocation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field errorLocation of a non-specific template of type @BSSAP_Types.BSSMAP_IE_Diagnostics.");
return single_value->field_errorLocation;
}

BITSTRING_template& BSSMAP__IE__Diagnostics_template::bitPointer()
{
set_specific();
return single_value->field_bitPointer;
}

const BITSTRING_template& BSSMAP__IE__Diagnostics_template::bitPointer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bitPointer of a non-specific template of type @BSSAP_Types.BSSMAP_IE_Diagnostics.");
return single_value->field_bitPointer;
}

BITSTRING_template& BSSMAP__IE__Diagnostics_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& BSSMAP__IE__Diagnostics_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @BSSAP_Types.BSSMAP_IE_Diagnostics.");
return single_value->field_spare;
}

OCTETSTRING_template& BSSMAP__IE__Diagnostics_template::messageReceived()
{
set_specific();
return single_value->field_messageReceived;
}

const OCTETSTRING_template& BSSMAP__IE__Diagnostics_template::messageReceived() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageReceived of a non-specific template of type @BSSAP_Types.BSSMAP_IE_Diagnostics.");
return single_value->field_messageReceived;
}

int BSSMAP__IE__Diagnostics_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Diagnostics which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 6;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Diagnostics containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Diagnostics containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Diagnostics containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Diagnostics containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Diagnostics containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Diagnostics containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Diagnostics containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Diagnostics containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_Diagnostics.");
  }
  return 0;
}

void BSSMAP__IE__Diagnostics_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", errorLocation := ");
single_value->field_errorLocation.log();
TTCN_Logger::log_event_str(", bitPointer := ");
single_value->field_bitPointer.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", messageReceived := ");
single_value->field_messageReceived.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__Diagnostics_template::log_match(const BSSMAP__IE__Diagnostics& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_errorLocation.match(match_value.errorLocation(), legacy)){
TTCN_Logger::log_logmatch_info(".errorLocation");
single_value->field_errorLocation.log_match(match_value.errorLocation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_bitPointer.match(match_value.bitPointer(), legacy)){
TTCN_Logger::log_logmatch_info(".bitPointer");
single_value->field_bitPointer.log_match(match_value.bitPointer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_messageReceived.match(match_value.messageReceived(), legacy)){
TTCN_Logger::log_logmatch_info(".messageReceived");
single_value->field_messageReceived.log_match(match_value.messageReceived(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", errorLocation := ");
single_value->field_errorLocation.log_match(match_value.errorLocation(), legacy);
TTCN_Logger::log_event_str(", bitPointer := ");
single_value->field_bitPointer.log_match(match_value.bitPointer(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", messageReceived := ");
single_value->field_messageReceived.log_match(match_value.messageReceived(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__Diagnostics_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (errorLocation().is_bound()) errorLocation().set_implicit_omit();
if (bitPointer().is_bound()) bitPointer().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (messageReceived().is_bound()) messageReceived().set_implicit_omit();
}

void BSSMAP__IE__Diagnostics_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_errorLocation.encode_text(text_buf);
single_value->field_bitPointer.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
single_value->field_messageReceived.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_Diagnostics.");
}
}

void BSSMAP__IE__Diagnostics_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_errorLocation.decode_text(text_buf);
single_value->field_bitPointer.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
single_value->field_messageReceived.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__Diagnostics_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_Diagnostics.");
}
}

void BSSMAP__IE__Diagnostics_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__Diagnostics_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_Diagnostics has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) errorLocation().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) bitPointer().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) messageReceived().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "errorLocation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          errorLocation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bitPointer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bitPointer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageReceived")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageReceived().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_Diagnostics: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__Diagnostics_template* precondition = new BSSMAP__IE__Diagnostics_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__Diagnostics_template* implied_template = new BSSMAP__IE__Diagnostics_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__Diagnostics_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_Diagnostics");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__Diagnostics_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_Diagnostics");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_Diagnostics");
single_value->field_errorLocation.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_Diagnostics");
single_value->field_bitPointer.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_Diagnostics");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_Diagnostics");
single_value->field_messageReceived.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_Diagnostics");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_Diagnostics");
}

boolean BSSMAP__IE__Diagnostics_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__Diagnostics_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__ChosenChannel::BSSMAP__IE__ChosenChannel()
{
}

BSSMAP__IE__ChosenChannel::BSSMAP__IE__ChosenChannel(const OCTETSTRING& par_elementIdentifier,
    const BITSTRING& par_channel,
    const BITSTRING& par_channelMode)
  :   field_elementIdentifier(par_elementIdentifier),
  field_channel(par_channel),
  field_channelMode(par_channelMode)
{
}

BSSMAP__IE__ChosenChannel::BSSMAP__IE__ChosenChannel(const BSSMAP__IE__ChosenChannel& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_ChosenChannel.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.channel().is_bound()) field_channel = other_value.channel();
else field_channel.clean_up();
if (other_value.channelMode().is_bound()) field_channelMode = other_value.channelMode();
else field_channelMode.clean_up();
}

void BSSMAP__IE__ChosenChannel::clean_up()
{
field_elementIdentifier.clean_up();
field_channel.clean_up();
field_channelMode.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__ChosenChannel::get_descriptor() const { return &BSSMAP__IE__ChosenChannel_descr_; }
BSSMAP__IE__ChosenChannel& BSSMAP__IE__ChosenChannel::operator=(const BSSMAP__IE__ChosenChannel& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_ChosenChannel.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.channel().is_bound()) field_channel = other_value.channel();
  else field_channel.clean_up();
  if (other_value.channelMode().is_bound()) field_channelMode = other_value.channelMode();
  else field_channelMode.clean_up();
}
return *this;
}

boolean BSSMAP__IE__ChosenChannel::operator==(const BSSMAP__IE__ChosenChannel& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_channel==other_value.field_channel
  && field_channelMode==other_value.field_channelMode;
}

boolean BSSMAP__IE__ChosenChannel::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_channel.is_bound())
  || (field_channelMode.is_bound());
}
boolean BSSMAP__IE__ChosenChannel::is_value() const
{
return field_elementIdentifier.is_value()
  && field_channel.is_value()
  && field_channelMode.is_value();
}
void BSSMAP__IE__ChosenChannel::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", channel := ");
field_channel.log();
TTCN_Logger::log_event_str(", channelMode := ");
field_channelMode.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__ChosenChannel::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (channel().is_bound()) channel().set_implicit_omit();
if (channelMode().is_bound()) channelMode().set_implicit_omit();
}

void BSSMAP__IE__ChosenChannel::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_ChosenChannel has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) channel().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) channelMode().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "channel")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          channel().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "channelMode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          channelMode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_ChosenChannel: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_ChosenChannel");
  }
}

void BSSMAP__IE__ChosenChannel::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_channel.encode_text(text_buf);
field_channelMode.encode_text(text_buf);
}

void BSSMAP__IE__ChosenChannel::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_channel.decode_text(text_buf);
field_channelMode.decode_text(text_buf);
}

void BSSMAP__IE__ChosenChannel::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__ChosenChannel::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__ChosenChannel::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_channel.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_channelMode.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_elementIdentifier !=  os_25) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__ChosenChannel::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT4_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_channel.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_channelMode.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier !=  os_25) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_25.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__ChosenChannel_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
BITSTRING_template field_channel;
BITSTRING_template field_channelMode;
};

void BSSMAP__IE__ChosenChannel_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_channel = ANY_VALUE;
single_value->field_channelMode = ANY_VALUE;
}
}
}

void BSSMAP__IE__ChosenChannel_template::copy_value(const BSSMAP__IE__ChosenChannel& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.channel().is_bound()) {
  single_value->field_channel = other_value.channel();
} else {
  single_value->field_channel.clean_up();
}
if (other_value.channelMode().is_bound()) {
  single_value->field_channelMode = other_value.channelMode();
} else {
  single_value->field_channelMode.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__ChosenChannel_template::copy_template(const BSSMAP__IE__ChosenChannel_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.channel().get_selection()) {
single_value->field_channel = other_value.channel();
} else {
single_value->field_channel.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.channelMode().get_selection()) {
single_value->field_channelMode = other_value.channelMode();
} else {
single_value->field_channelMode.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__ChosenChannel_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__ChosenChannel_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__ChosenChannel_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__ChosenChannel_template::BSSMAP__IE__ChosenChannel_template()
{
}

BSSMAP__IE__ChosenChannel_template::BSSMAP__IE__ChosenChannel_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__ChosenChannel_template::BSSMAP__IE__ChosenChannel_template(const BSSMAP__IE__ChosenChannel& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__ChosenChannel_template::BSSMAP__IE__ChosenChannel_template(const OPTIONAL<BSSMAP__IE__ChosenChannel>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__ChosenChannel&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel from an unbound optional field.");
}
}

BSSMAP__IE__ChosenChannel_template::BSSMAP__IE__ChosenChannel_template(BSSMAP__IE__ChosenChannel_template* p_precondition, BSSMAP__IE__ChosenChannel_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__ChosenChannel_template::BSSMAP__IE__ChosenChannel_template(Dynamic_Match_Interface<BSSMAP__IE__ChosenChannel>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__ChosenChannel>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__ChosenChannel_template::BSSMAP__IE__ChosenChannel_template(const BSSMAP__IE__ChosenChannel_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__ChosenChannel_template::~BSSMAP__IE__ChosenChannel_template()
{
clean_up();
}

BSSMAP__IE__ChosenChannel_template& BSSMAP__IE__ChosenChannel_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__ChosenChannel_template& BSSMAP__IE__ChosenChannel_template::operator=(const BSSMAP__IE__ChosenChannel& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__ChosenChannel_template& BSSMAP__IE__ChosenChannel_template::operator=(const OPTIONAL<BSSMAP__IE__ChosenChannel>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__ChosenChannel&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel.");
}
return *this;
}

BSSMAP__IE__ChosenChannel_template& BSSMAP__IE__ChosenChannel_template::operator=(const BSSMAP__IE__ChosenChannel_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__ChosenChannel_template::match(const BSSMAP__IE__ChosenChannel& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.channel().is_bound()) return FALSE;
if(!single_value->field_channel.match(other_value.channel(), legacy))return FALSE;
if(!other_value.channelMode().is_bound()) return FALSE;
if(!single_value->field_channelMode.match(other_value.channelMode(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel.");
}
return FALSE;
}

boolean BSSMAP__IE__ChosenChannel_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_channel.is_bound()
 || single_value->field_channelMode.is_bound();
}

boolean BSSMAP__IE__ChosenChannel_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_channel.is_value()
 && single_value->field_channelMode.is_value();
}

void BSSMAP__IE__ChosenChannel_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__ChosenChannel BSSMAP__IE__ChosenChannel_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel.");
BSSMAP__IE__ChosenChannel ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_channel.is_bound()) {
ret_val.channel() = single_value->field_channel.valueof();
}
if (single_value->field_channelMode.is_bound()) {
ret_val.channelMode() = single_value->field_channelMode.valueof();
}
return ret_val;
}

void BSSMAP__IE__ChosenChannel_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__ChosenChannel_template[list_length];
}

BSSMAP__IE__ChosenChannel_template& BSSMAP__IE__ChosenChannel_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__ChosenChannel_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__ChosenChannel_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel.");
return single_value->field_elementIdentifier;
}

BITSTRING_template& BSSMAP__IE__ChosenChannel_template::channel()
{
set_specific();
return single_value->field_channel;
}

const BITSTRING_template& BSSMAP__IE__ChosenChannel_template::channel() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field channel of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel.");
return single_value->field_channel;
}

BITSTRING_template& BSSMAP__IE__ChosenChannel_template::channelMode()
{
set_specific();
return single_value->field_channelMode;
}

const BITSTRING_template& BSSMAP__IE__ChosenChannel_template::channelMode() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field channelMode of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel.");
return single_value->field_channelMode;
}

int BSSMAP__IE__ChosenChannel_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel.");
  }
  return 0;
}

void BSSMAP__IE__ChosenChannel_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", channel := ");
single_value->field_channel.log();
TTCN_Logger::log_event_str(", channelMode := ");
single_value->field_channelMode.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__ChosenChannel_template::log_match(const BSSMAP__IE__ChosenChannel& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_channel.match(match_value.channel(), legacy)){
TTCN_Logger::log_logmatch_info(".channel");
single_value->field_channel.log_match(match_value.channel(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_channelMode.match(match_value.channelMode(), legacy)){
TTCN_Logger::log_logmatch_info(".channelMode");
single_value->field_channelMode.log_match(match_value.channelMode(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", channel := ");
single_value->field_channel.log_match(match_value.channel(), legacy);
TTCN_Logger::log_event_str(", channelMode := ");
single_value->field_channelMode.log_match(match_value.channelMode(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__ChosenChannel_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (channel().is_bound()) channel().set_implicit_omit();
if (channelMode().is_bound()) channelMode().set_implicit_omit();
}

void BSSMAP__IE__ChosenChannel_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_channel.encode_text(text_buf);
single_value->field_channelMode.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel.");
}
}

void BSSMAP__IE__ChosenChannel_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_channel.decode_text(text_buf);
single_value->field_channelMode.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__ChosenChannel_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel.");
}
}

void BSSMAP__IE__ChosenChannel_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__ChosenChannel_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_ChosenChannel has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) channel().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) channelMode().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "channel")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          channel().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "channelMode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          channelMode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_ChosenChannel: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__ChosenChannel_template* precondition = new BSSMAP__IE__ChosenChannel_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__ChosenChannel_template* implied_template = new BSSMAP__IE__ChosenChannel_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__ChosenChannel_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_ChosenChannel");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__ChosenChannel_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ChosenChannel");
single_value->field_channel.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ChosenChannel");
single_value->field_channelMode.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ChosenChannel");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ChosenChannel");
}

boolean BSSMAP__IE__ChosenChannel_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__ChosenChannel_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__CipherResponseMode::BSSMAP__IE__CipherResponseMode()
{
}

BSSMAP__IE__CipherResponseMode::BSSMAP__IE__CipherResponseMode(const OCTETSTRING& par_elementIdentifier,
    const BITSTRING& par_cipherResponseModeInfo,
    const BITSTRING& par_spare1__7)
  :   field_elementIdentifier(par_elementIdentifier),
  field_cipherResponseModeInfo(par_cipherResponseModeInfo),
  field_spare1__7(par_spare1__7)
{
}

BSSMAP__IE__CipherResponseMode::BSSMAP__IE__CipherResponseMode(const BSSMAP__IE__CipherResponseMode& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.cipherResponseModeInfo().is_bound()) field_cipherResponseModeInfo = other_value.cipherResponseModeInfo();
else field_cipherResponseModeInfo.clean_up();
if (other_value.spare1__7().is_bound()) field_spare1__7 = other_value.spare1__7();
else field_spare1__7.clean_up();
}

void BSSMAP__IE__CipherResponseMode::clean_up()
{
field_elementIdentifier.clean_up();
field_cipherResponseModeInfo.clean_up();
field_spare1__7.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__CipherResponseMode::get_descriptor() const { return &BSSMAP__IE__CipherResponseMode_descr_; }
BSSMAP__IE__CipherResponseMode& BSSMAP__IE__CipherResponseMode::operator=(const BSSMAP__IE__CipherResponseMode& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.cipherResponseModeInfo().is_bound()) field_cipherResponseModeInfo = other_value.cipherResponseModeInfo();
  else field_cipherResponseModeInfo.clean_up();
  if (other_value.spare1__7().is_bound()) field_spare1__7 = other_value.spare1__7();
  else field_spare1__7.clean_up();
}
return *this;
}

boolean BSSMAP__IE__CipherResponseMode::operator==(const BSSMAP__IE__CipherResponseMode& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_cipherResponseModeInfo==other_value.field_cipherResponseModeInfo
  && field_spare1__7==other_value.field_spare1__7;
}

boolean BSSMAP__IE__CipherResponseMode::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_cipherResponseModeInfo.is_bound())
  || (field_spare1__7.is_bound());
}
boolean BSSMAP__IE__CipherResponseMode::is_value() const
{
return field_elementIdentifier.is_value()
  && field_cipherResponseModeInfo.is_value()
  && field_spare1__7.is_value();
}
void BSSMAP__IE__CipherResponseMode::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", cipherResponseModeInfo := ");
field_cipherResponseModeInfo.log();
TTCN_Logger::log_event_str(", spare1_7 := ");
field_spare1__7.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__CipherResponseMode::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (cipherResponseModeInfo().is_bound()) cipherResponseModeInfo().set_implicit_omit();
if (spare1__7().is_bound()) spare1__7().set_implicit_omit();
}

void BSSMAP__IE__CipherResponseMode::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cipherResponseModeInfo().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare1__7().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cipherResponseModeInfo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cipherResponseModeInfo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare1_7")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare1__7().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_CipherResponseMode: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_CipherResponseMode");
  }
}

void BSSMAP__IE__CipherResponseMode::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_cipherResponseModeInfo.encode_text(text_buf);
field_spare1__7.encode_text(text_buf);
}

void BSSMAP__IE__CipherResponseMode::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_cipherResponseModeInfo.decode_text(text_buf);
field_spare1__7.decode_text(text_buf);
}

void BSSMAP__IE__CipherResponseMode::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__CipherResponseMode::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__CipherResponseMode::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_cipherResponseModeInfo.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT7_descr_.raw->forceomit);
  decoded_field_length = field_spare1__7.RAW_decode(General__Types::BIT7_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_elementIdentifier !=  os_46) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__CipherResponseMode::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT7_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_cipherResponseModeInfo.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_spare1__7.RAW_encode(General__Types::BIT7_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier !=  os_46) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_46.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__CipherResponseMode_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
BITSTRING_template field_cipherResponseModeInfo;
BITSTRING_template field_spare1__7;
};

void BSSMAP__IE__CipherResponseMode_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_cipherResponseModeInfo = ANY_VALUE;
single_value->field_spare1__7 = ANY_VALUE;
}
}
}

void BSSMAP__IE__CipherResponseMode_template::copy_value(const BSSMAP__IE__CipherResponseMode& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.cipherResponseModeInfo().is_bound()) {
  single_value->field_cipherResponseModeInfo = other_value.cipherResponseModeInfo();
} else {
  single_value->field_cipherResponseModeInfo.clean_up();
}
if (other_value.spare1__7().is_bound()) {
  single_value->field_spare1__7 = other_value.spare1__7();
} else {
  single_value->field_spare1__7.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__CipherResponseMode_template::copy_template(const BSSMAP__IE__CipherResponseMode_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cipherResponseModeInfo().get_selection()) {
single_value->field_cipherResponseModeInfo = other_value.cipherResponseModeInfo();
} else {
single_value->field_cipherResponseModeInfo.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare1__7().get_selection()) {
single_value->field_spare1__7 = other_value.spare1__7();
} else {
single_value->field_spare1__7.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__CipherResponseMode_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__CipherResponseMode_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__CipherResponseMode_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__CipherResponseMode_template::BSSMAP__IE__CipherResponseMode_template()
{
}

BSSMAP__IE__CipherResponseMode_template::BSSMAP__IE__CipherResponseMode_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__CipherResponseMode_template::BSSMAP__IE__CipherResponseMode_template(const BSSMAP__IE__CipherResponseMode& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__CipherResponseMode_template::BSSMAP__IE__CipherResponseMode_template(const OPTIONAL<BSSMAP__IE__CipherResponseMode>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__CipherResponseMode&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode from an unbound optional field.");
}
}

BSSMAP__IE__CipherResponseMode_template::BSSMAP__IE__CipherResponseMode_template(BSSMAP__IE__CipherResponseMode_template* p_precondition, BSSMAP__IE__CipherResponseMode_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__CipherResponseMode_template::BSSMAP__IE__CipherResponseMode_template(Dynamic_Match_Interface<BSSMAP__IE__CipherResponseMode>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__CipherResponseMode>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__CipherResponseMode_template::BSSMAP__IE__CipherResponseMode_template(const BSSMAP__IE__CipherResponseMode_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__CipherResponseMode_template::~BSSMAP__IE__CipherResponseMode_template()
{
clean_up();
}

BSSMAP__IE__CipherResponseMode_template& BSSMAP__IE__CipherResponseMode_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__CipherResponseMode_template& BSSMAP__IE__CipherResponseMode_template::operator=(const BSSMAP__IE__CipherResponseMode& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__CipherResponseMode_template& BSSMAP__IE__CipherResponseMode_template::operator=(const OPTIONAL<BSSMAP__IE__CipherResponseMode>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__CipherResponseMode&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode.");
}
return *this;
}

BSSMAP__IE__CipherResponseMode_template& BSSMAP__IE__CipherResponseMode_template::operator=(const BSSMAP__IE__CipherResponseMode_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__CipherResponseMode_template::match(const BSSMAP__IE__CipherResponseMode& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.cipherResponseModeInfo().is_bound()) return FALSE;
if(!single_value->field_cipherResponseModeInfo.match(other_value.cipherResponseModeInfo(), legacy))return FALSE;
if(!other_value.spare1__7().is_bound()) return FALSE;
if(!single_value->field_spare1__7.match(other_value.spare1__7(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode.");
}
return FALSE;
}

boolean BSSMAP__IE__CipherResponseMode_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_cipherResponseModeInfo.is_bound()
 || single_value->field_spare1__7.is_bound();
}

boolean BSSMAP__IE__CipherResponseMode_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_cipherResponseModeInfo.is_value()
 && single_value->field_spare1__7.is_value();
}

void BSSMAP__IE__CipherResponseMode_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__CipherResponseMode BSSMAP__IE__CipherResponseMode_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode.");
BSSMAP__IE__CipherResponseMode ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_cipherResponseModeInfo.is_bound()) {
ret_val.cipherResponseModeInfo() = single_value->field_cipherResponseModeInfo.valueof();
}
if (single_value->field_spare1__7.is_bound()) {
ret_val.spare1__7() = single_value->field_spare1__7.valueof();
}
return ret_val;
}

void BSSMAP__IE__CipherResponseMode_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__CipherResponseMode_template[list_length];
}

BSSMAP__IE__CipherResponseMode_template& BSSMAP__IE__CipherResponseMode_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__CipherResponseMode_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__CipherResponseMode_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode.");
return single_value->field_elementIdentifier;
}

BITSTRING_template& BSSMAP__IE__CipherResponseMode_template::cipherResponseModeInfo()
{
set_specific();
return single_value->field_cipherResponseModeInfo;
}

const BITSTRING_template& BSSMAP__IE__CipherResponseMode_template::cipherResponseModeInfo() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cipherResponseModeInfo of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode.");
return single_value->field_cipherResponseModeInfo;
}

BITSTRING_template& BSSMAP__IE__CipherResponseMode_template::spare1__7()
{
set_specific();
return single_value->field_spare1__7;
}

const BITSTRING_template& BSSMAP__IE__CipherResponseMode_template::spare1__7() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare1_7 of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode.");
return single_value->field_spare1__7;
}

int BSSMAP__IE__CipherResponseMode_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode.");
  }
  return 0;
}

void BSSMAP__IE__CipherResponseMode_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", cipherResponseModeInfo := ");
single_value->field_cipherResponseModeInfo.log();
TTCN_Logger::log_event_str(", spare1_7 := ");
single_value->field_spare1__7.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__CipherResponseMode_template::log_match(const BSSMAP__IE__CipherResponseMode& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cipherResponseModeInfo.match(match_value.cipherResponseModeInfo(), legacy)){
TTCN_Logger::log_logmatch_info(".cipherResponseModeInfo");
single_value->field_cipherResponseModeInfo.log_match(match_value.cipherResponseModeInfo(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare1__7.match(match_value.spare1__7(), legacy)){
TTCN_Logger::log_logmatch_info(".spare1_7");
single_value->field_spare1__7.log_match(match_value.spare1__7(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", cipherResponseModeInfo := ");
single_value->field_cipherResponseModeInfo.log_match(match_value.cipherResponseModeInfo(), legacy);
TTCN_Logger::log_event_str(", spare1_7 := ");
single_value->field_spare1__7.log_match(match_value.spare1__7(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__CipherResponseMode_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (cipherResponseModeInfo().is_bound()) cipherResponseModeInfo().set_implicit_omit();
if (spare1__7().is_bound()) spare1__7().set_implicit_omit();
}

void BSSMAP__IE__CipherResponseMode_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_cipherResponseModeInfo.encode_text(text_buf);
single_value->field_spare1__7.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode.");
}
}

void BSSMAP__IE__CipherResponseMode_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_cipherResponseModeInfo.decode_text(text_buf);
single_value->field_spare1__7.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__CipherResponseMode_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode.");
}
}

void BSSMAP__IE__CipherResponseMode_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__CipherResponseMode_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_CipherResponseMode has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cipherResponseModeInfo().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare1__7().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cipherResponseModeInfo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cipherResponseModeInfo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare1_7")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare1__7().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_CipherResponseMode: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__CipherResponseMode_template* precondition = new BSSMAP__IE__CipherResponseMode_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__CipherResponseMode_template* implied_template = new BSSMAP__IE__CipherResponseMode_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__CipherResponseMode_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_CipherResponseMode");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__CipherResponseMode_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CipherResponseMode");
single_value->field_cipherResponseModeInfo.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CipherResponseMode");
single_value->field_spare1__7.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CipherResponseMode");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CipherResponseMode");
}

boolean BSSMAP__IE__CipherResponseMode_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__CipherResponseMode_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__Layer3MessageContents::BSSMAP__IE__Layer3MessageContents()
{
}

BSSMAP__IE__Layer3MessageContents::BSSMAP__IE__Layer3MessageContents(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_layer3MsgConents)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_layer3MsgConents(par_layer3MsgConents)
{
}

BSSMAP__IE__Layer3MessageContents::BSSMAP__IE__Layer3MessageContents(const BSSMAP__IE__Layer3MessageContents& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.layer3MsgConents().is_bound()) field_layer3MsgConents = other_value.layer3MsgConents();
else field_layer3MsgConents.clean_up();
}

void BSSMAP__IE__Layer3MessageContents::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_layer3MsgConents.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__Layer3MessageContents::get_descriptor() const { return &BSSMAP__IE__Layer3MessageContents_descr_; }
BSSMAP__IE__Layer3MessageContents& BSSMAP__IE__Layer3MessageContents::operator=(const BSSMAP__IE__Layer3MessageContents& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.layer3MsgConents().is_bound()) field_layer3MsgConents = other_value.layer3MsgConents();
  else field_layer3MsgConents.clean_up();
}
return *this;
}

boolean BSSMAP__IE__Layer3MessageContents::operator==(const BSSMAP__IE__Layer3MessageContents& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_layer3MsgConents==other_value.field_layer3MsgConents;
}

boolean BSSMAP__IE__Layer3MessageContents::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_layer3MsgConents.is_bound());
}
boolean BSSMAP__IE__Layer3MessageContents::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_layer3MsgConents.is_value();
}
void BSSMAP__IE__Layer3MessageContents::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", layer3MsgConents := ");
field_layer3MsgConents.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__Layer3MessageContents::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (layer3MsgConents().is_bound()) layer3MsgConents().set_implicit_omit();
}

void BSSMAP__IE__Layer3MessageContents::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) layer3MsgConents().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "layer3MsgConents")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          layer3MsgConents().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_Layer3MessageContents");
  }
}

void BSSMAP__IE__Layer3MessageContents::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_layer3MsgConents.encode_text(text_buf);
}

void BSSMAP__IE__Layer3MessageContents::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_layer3MsgConents.decode_text(text_buf);
}

void BSSMAP__IE__Layer3MessageContents::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__Layer3MessageContents::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__Layer3MessageContents::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__Layer3MessageContents_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__Layer3MessageContents_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__Layer3MessageContents_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_layer3MsgConents.RAW_decode(OCTETSTRING_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_48) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__Layer3MessageContents::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__Layer3MessageContents_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, OCTETSTRING_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__Layer3MessageContents_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_layer3MsgConents.RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier !=  os_48) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_48.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__Layer3MessageContents_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_layer3MsgConents;
};

void BSSMAP__IE__Layer3MessageContents_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_layer3MsgConents = ANY_VALUE;
}
}
}

void BSSMAP__IE__Layer3MessageContents_template::copy_value(const BSSMAP__IE__Layer3MessageContents& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.layer3MsgConents().is_bound()) {
  single_value->field_layer3MsgConents = other_value.layer3MsgConents();
} else {
  single_value->field_layer3MsgConents.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__Layer3MessageContents_template::copy_template(const BSSMAP__IE__Layer3MessageContents_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.layer3MsgConents().get_selection()) {
single_value->field_layer3MsgConents = other_value.layer3MsgConents();
} else {
single_value->field_layer3MsgConents.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__Layer3MessageContents_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__Layer3MessageContents_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__Layer3MessageContents_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__Layer3MessageContents_template::BSSMAP__IE__Layer3MessageContents_template()
{
}

BSSMAP__IE__Layer3MessageContents_template::BSSMAP__IE__Layer3MessageContents_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__Layer3MessageContents_template::BSSMAP__IE__Layer3MessageContents_template(const BSSMAP__IE__Layer3MessageContents& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__Layer3MessageContents_template::BSSMAP__IE__Layer3MessageContents_template(const OPTIONAL<BSSMAP__IE__Layer3MessageContents>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__Layer3MessageContents&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents from an unbound optional field.");
}
}

BSSMAP__IE__Layer3MessageContents_template::BSSMAP__IE__Layer3MessageContents_template(BSSMAP__IE__Layer3MessageContents_template* p_precondition, BSSMAP__IE__Layer3MessageContents_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__Layer3MessageContents_template::BSSMAP__IE__Layer3MessageContents_template(Dynamic_Match_Interface<BSSMAP__IE__Layer3MessageContents>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__Layer3MessageContents>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__Layer3MessageContents_template::BSSMAP__IE__Layer3MessageContents_template(const BSSMAP__IE__Layer3MessageContents_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__Layer3MessageContents_template::~BSSMAP__IE__Layer3MessageContents_template()
{
clean_up();
}

BSSMAP__IE__Layer3MessageContents_template& BSSMAP__IE__Layer3MessageContents_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__Layer3MessageContents_template& BSSMAP__IE__Layer3MessageContents_template::operator=(const BSSMAP__IE__Layer3MessageContents& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__Layer3MessageContents_template& BSSMAP__IE__Layer3MessageContents_template::operator=(const OPTIONAL<BSSMAP__IE__Layer3MessageContents>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__Layer3MessageContents&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents.");
}
return *this;
}

BSSMAP__IE__Layer3MessageContents_template& BSSMAP__IE__Layer3MessageContents_template::operator=(const BSSMAP__IE__Layer3MessageContents_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__Layer3MessageContents_template::match(const BSSMAP__IE__Layer3MessageContents& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.layer3MsgConents().is_bound()) return FALSE;
if(!single_value->field_layer3MsgConents.match(other_value.layer3MsgConents(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents.");
}
return FALSE;
}

boolean BSSMAP__IE__Layer3MessageContents_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_layer3MsgConents.is_bound();
}

boolean BSSMAP__IE__Layer3MessageContents_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_layer3MsgConents.is_value();
}

void BSSMAP__IE__Layer3MessageContents_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__Layer3MessageContents BSSMAP__IE__Layer3MessageContents_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents.");
BSSMAP__IE__Layer3MessageContents ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_layer3MsgConents.is_bound()) {
ret_val.layer3MsgConents() = single_value->field_layer3MsgConents.valueof();
}
return ret_val;
}

void BSSMAP__IE__Layer3MessageContents_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__Layer3MessageContents_template[list_length];
}

BSSMAP__IE__Layer3MessageContents_template& BSSMAP__IE__Layer3MessageContents_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__Layer3MessageContents_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__Layer3MessageContents_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__Layer3MessageContents_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__Layer3MessageContents_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& BSSMAP__IE__Layer3MessageContents_template::layer3MsgConents()
{
set_specific();
return single_value->field_layer3MsgConents;
}

const OCTETSTRING_template& BSSMAP__IE__Layer3MessageContents_template::layer3MsgConents() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field layer3MsgConents of a non-specific template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents.");
return single_value->field_layer3MsgConents;
}

int BSSMAP__IE__Layer3MessageContents_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents.");
  }
  return 0;
}

void BSSMAP__IE__Layer3MessageContents_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", layer3MsgConents := ");
single_value->field_layer3MsgConents.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__Layer3MessageContents_template::log_match(const BSSMAP__IE__Layer3MessageContents& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_layer3MsgConents.match(match_value.layer3MsgConents(), legacy)){
TTCN_Logger::log_logmatch_info(".layer3MsgConents");
single_value->field_layer3MsgConents.log_match(match_value.layer3MsgConents(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", layer3MsgConents := ");
single_value->field_layer3MsgConents.log_match(match_value.layer3MsgConents(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__Layer3MessageContents_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (layer3MsgConents().is_bound()) layer3MsgConents().set_implicit_omit();
}

void BSSMAP__IE__Layer3MessageContents_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_layer3MsgConents.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents.");
}
}

void BSSMAP__IE__Layer3MessageContents_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_layer3MsgConents.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__Layer3MessageContents_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents.");
}
}

void BSSMAP__IE__Layer3MessageContents_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__Layer3MessageContents_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) layer3MsgConents().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "layer3MsgConents")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          layer3MsgConents().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_Layer3MessageContents: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__Layer3MessageContents_template* precondition = new BSSMAP__IE__Layer3MessageContents_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__Layer3MessageContents_template* implied_template = new BSSMAP__IE__Layer3MessageContents_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__Layer3MessageContents_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_Layer3MessageContents");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__Layer3MessageContents_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_Layer3MessageContents");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_Layer3MessageContents");
single_value->field_layer3MsgConents.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_Layer3MessageContents");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_Layer3MessageContents");
}

boolean BSSMAP__IE__Layer3MessageContents_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__Layer3MessageContents_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__ChannelNeeded::BSSMAP__IE__ChannelNeeded()
{
}

BSSMAP__IE__ChannelNeeded::BSSMAP__IE__ChannelNeeded(const OCTETSTRING& par_elementIdentifier,
    const BITSTRING& par_channel,
    const BITSTRING& par_spare)
  :   field_elementIdentifier(par_elementIdentifier),
  field_channel(par_channel),
  field_spare(par_spare)
{
}

BSSMAP__IE__ChannelNeeded::BSSMAP__IE__ChannelNeeded(const BSSMAP__IE__ChannelNeeded& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.channel().is_bound()) field_channel = other_value.channel();
else field_channel.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void BSSMAP__IE__ChannelNeeded::clean_up()
{
field_elementIdentifier.clean_up();
field_channel.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__ChannelNeeded::get_descriptor() const { return &BSSMAP__IE__ChannelNeeded_descr_; }
BSSMAP__IE__ChannelNeeded& BSSMAP__IE__ChannelNeeded::operator=(const BSSMAP__IE__ChannelNeeded& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.channel().is_bound()) field_channel = other_value.channel();
  else field_channel.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean BSSMAP__IE__ChannelNeeded::operator==(const BSSMAP__IE__ChannelNeeded& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_channel==other_value.field_channel
  && field_spare==other_value.field_spare;
}

boolean BSSMAP__IE__ChannelNeeded::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_channel.is_bound())
  || (field_spare.is_bound());
}
boolean BSSMAP__IE__ChannelNeeded::is_value() const
{
return field_elementIdentifier.is_value()
  && field_channel.is_value()
  && field_spare.is_value();
}
void BSSMAP__IE__ChannelNeeded::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", channel := ");
field_channel.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__ChannelNeeded::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (channel().is_bound()) channel().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void BSSMAP__IE__ChannelNeeded::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) channel().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "channel")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          channel().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_ChannelNeeded: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_ChannelNeeded");
  }
}

void BSSMAP__IE__ChannelNeeded::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_channel.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void BSSMAP__IE__ChannelNeeded::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_channel.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void BSSMAP__IE__ChannelNeeded::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__ChannelNeeded::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__ChannelNeeded::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_channel.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT6_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT6_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_elementIdentifier !=  os_91) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__ChannelNeeded::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT6_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_channel.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT6_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier !=  os_91) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_91.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__ChannelNeeded_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
BITSTRING_template field_channel;
BITSTRING_template field_spare;
};

void BSSMAP__IE__ChannelNeeded_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_channel = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void BSSMAP__IE__ChannelNeeded_template::copy_value(const BSSMAP__IE__ChannelNeeded& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.channel().is_bound()) {
  single_value->field_channel = other_value.channel();
} else {
  single_value->field_channel.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__ChannelNeeded_template::copy_template(const BSSMAP__IE__ChannelNeeded_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.channel().get_selection()) {
single_value->field_channel = other_value.channel();
} else {
single_value->field_channel.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__ChannelNeeded_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__ChannelNeeded_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__ChannelNeeded_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__ChannelNeeded_template::BSSMAP__IE__ChannelNeeded_template()
{
}

BSSMAP__IE__ChannelNeeded_template::BSSMAP__IE__ChannelNeeded_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__ChannelNeeded_template::BSSMAP__IE__ChannelNeeded_template(const BSSMAP__IE__ChannelNeeded& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__ChannelNeeded_template::BSSMAP__IE__ChannelNeeded_template(const OPTIONAL<BSSMAP__IE__ChannelNeeded>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__ChannelNeeded&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded from an unbound optional field.");
}
}

BSSMAP__IE__ChannelNeeded_template::BSSMAP__IE__ChannelNeeded_template(BSSMAP__IE__ChannelNeeded_template* p_precondition, BSSMAP__IE__ChannelNeeded_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__ChannelNeeded_template::BSSMAP__IE__ChannelNeeded_template(Dynamic_Match_Interface<BSSMAP__IE__ChannelNeeded>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__ChannelNeeded>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__ChannelNeeded_template::BSSMAP__IE__ChannelNeeded_template(const BSSMAP__IE__ChannelNeeded_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__ChannelNeeded_template::~BSSMAP__IE__ChannelNeeded_template()
{
clean_up();
}

BSSMAP__IE__ChannelNeeded_template& BSSMAP__IE__ChannelNeeded_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__ChannelNeeded_template& BSSMAP__IE__ChannelNeeded_template::operator=(const BSSMAP__IE__ChannelNeeded& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__ChannelNeeded_template& BSSMAP__IE__ChannelNeeded_template::operator=(const OPTIONAL<BSSMAP__IE__ChannelNeeded>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__ChannelNeeded&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded.");
}
return *this;
}

BSSMAP__IE__ChannelNeeded_template& BSSMAP__IE__ChannelNeeded_template::operator=(const BSSMAP__IE__ChannelNeeded_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__ChannelNeeded_template::match(const BSSMAP__IE__ChannelNeeded& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.channel().is_bound()) return FALSE;
if(!single_value->field_channel.match(other_value.channel(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded.");
}
return FALSE;
}

boolean BSSMAP__IE__ChannelNeeded_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_channel.is_bound()
 || single_value->field_spare.is_bound();
}

boolean BSSMAP__IE__ChannelNeeded_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_channel.is_value()
 && single_value->field_spare.is_value();
}

void BSSMAP__IE__ChannelNeeded_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__ChannelNeeded BSSMAP__IE__ChannelNeeded_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded.");
BSSMAP__IE__ChannelNeeded ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_channel.is_bound()) {
ret_val.channel() = single_value->field_channel.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void BSSMAP__IE__ChannelNeeded_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__ChannelNeeded_template[list_length];
}

BSSMAP__IE__ChannelNeeded_template& BSSMAP__IE__ChannelNeeded_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__ChannelNeeded_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__ChannelNeeded_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded.");
return single_value->field_elementIdentifier;
}

BITSTRING_template& BSSMAP__IE__ChannelNeeded_template::channel()
{
set_specific();
return single_value->field_channel;
}

const BITSTRING_template& BSSMAP__IE__ChannelNeeded_template::channel() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field channel of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded.");
return single_value->field_channel;
}

BITSTRING_template& BSSMAP__IE__ChannelNeeded_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& BSSMAP__IE__ChannelNeeded_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded.");
return single_value->field_spare;
}

int BSSMAP__IE__ChannelNeeded_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded.");
  }
  return 0;
}

void BSSMAP__IE__ChannelNeeded_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", channel := ");
single_value->field_channel.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__ChannelNeeded_template::log_match(const BSSMAP__IE__ChannelNeeded& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_channel.match(match_value.channel(), legacy)){
TTCN_Logger::log_logmatch_info(".channel");
single_value->field_channel.log_match(match_value.channel(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", channel := ");
single_value->field_channel.log_match(match_value.channel(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__ChannelNeeded_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (channel().is_bound()) channel().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void BSSMAP__IE__ChannelNeeded_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_channel.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded.");
}
}

void BSSMAP__IE__ChannelNeeded_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_channel.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__ChannelNeeded_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded.");
}
}

void BSSMAP__IE__ChannelNeeded_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__ChannelNeeded_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_ChannelNeeded has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) channel().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "channel")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          channel().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_ChannelNeeded: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__ChannelNeeded_template* precondition = new BSSMAP__IE__ChannelNeeded_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__ChannelNeeded_template* implied_template = new BSSMAP__IE__ChannelNeeded_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__ChannelNeeded_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_ChannelNeeded");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__ChannelNeeded_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ChannelNeeded");
single_value->field_channel.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ChannelNeeded");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ChannelNeeded");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ChannelNeeded");
}

boolean BSSMAP__IE__ChannelNeeded_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__ChannelNeeded_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__TraceType::BSSMAP__IE__TraceType()
{
}

BSSMAP__IE__TraceType::BSSMAP__IE__TraceType(const OCTETSTRING& par_elementIdentifier,
    const BITSTRING& par_e,
    const BITSTRING& par_d,
    const BITSTRING& par_c,
    const BITSTRING& par_b,
    const BITSTRING& par_a)
  :   field_elementIdentifier(par_elementIdentifier),
  field_e(par_e),
  field_d(par_d),
  field_c(par_c),
  field_b(par_b),
  field_a(par_a)
{
}

BSSMAP__IE__TraceType::BSSMAP__IE__TraceType(const BSSMAP__IE__TraceType& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_TraceType.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.e().is_bound()) field_e = other_value.e();
else field_e.clean_up();
if (other_value.d().is_bound()) field_d = other_value.d();
else field_d.clean_up();
if (other_value.c().is_bound()) field_c = other_value.c();
else field_c.clean_up();
if (other_value.b().is_bound()) field_b = other_value.b();
else field_b.clean_up();
if (other_value.a().is_bound()) field_a = other_value.a();
else field_a.clean_up();
}

void BSSMAP__IE__TraceType::clean_up()
{
field_elementIdentifier.clean_up();
field_e.clean_up();
field_d.clean_up();
field_c.clean_up();
field_b.clean_up();
field_a.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__TraceType::get_descriptor() const { return &BSSMAP__IE__TraceType_descr_; }
BSSMAP__IE__TraceType& BSSMAP__IE__TraceType::operator=(const BSSMAP__IE__TraceType& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_TraceType.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.e().is_bound()) field_e = other_value.e();
  else field_e.clean_up();
  if (other_value.d().is_bound()) field_d = other_value.d();
  else field_d.clean_up();
  if (other_value.c().is_bound()) field_c = other_value.c();
  else field_c.clean_up();
  if (other_value.b().is_bound()) field_b = other_value.b();
  else field_b.clean_up();
  if (other_value.a().is_bound()) field_a = other_value.a();
  else field_a.clean_up();
}
return *this;
}

boolean BSSMAP__IE__TraceType::operator==(const BSSMAP__IE__TraceType& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_e==other_value.field_e
  && field_d==other_value.field_d
  && field_c==other_value.field_c
  && field_b==other_value.field_b
  && field_a==other_value.field_a;
}

boolean BSSMAP__IE__TraceType::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_e.is_bound())
  || (field_d.is_bound())
  || (field_c.is_bound())
  || (field_b.is_bound())
  || (field_a.is_bound());
}
boolean BSSMAP__IE__TraceType::is_value() const
{
return field_elementIdentifier.is_value()
  && field_e.is_value()
  && field_d.is_value()
  && field_c.is_value()
  && field_b.is_value()
  && field_a.is_value();
}
void BSSMAP__IE__TraceType::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", e := ");
field_e.log();
TTCN_Logger::log_event_str(", d := ");
field_d.log();
TTCN_Logger::log_event_str(", c := ");
field_c.log();
TTCN_Logger::log_event_str(", b := ");
field_b.log();
TTCN_Logger::log_event_str(", a := ");
field_a.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__TraceType::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (e().is_bound()) e().set_implicit_omit();
if (d().is_bound()) d().set_implicit_omit();
if (c().is_bound()) c().set_implicit_omit();
if (b().is_bound()) b().set_implicit_omit();
if (a().is_bound()) a().set_implicit_omit();
}

void BSSMAP__IE__TraceType::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_TraceType has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) e().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) d().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) c().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) b().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) a().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "e")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          e().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "d")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          d().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "c")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          c().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "b")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          b().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "a")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          a().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_TraceType: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_TraceType");
  }
}

void BSSMAP__IE__TraceType::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_e.encode_text(text_buf);
field_d.encode_text(text_buf);
field_c.encode_text(text_buf);
field_b.encode_text(text_buf);
field_a.encode_text(text_buf);
}

void BSSMAP__IE__TraceType::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_e.decode_text(text_buf);
field_d.decode_text(text_buf);
field_c.decode_text(text_buf);
field_b.decode_text(text_buf);
field_a.decode_text(text_buf);
}

void BSSMAP__IE__TraceType::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__TraceType::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__TraceType::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_e.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_d.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_c.RAW_decode(General__Types::BIT2_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_b.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_5_force_omit(5, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_a.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__TraceType::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 6;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(6);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT2_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT2_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT2_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, General__Types::BIT1_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_e.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_d.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_c.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_b.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_a.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[5]);
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__TraceType_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
BITSTRING_template field_e;
BITSTRING_template field_d;
BITSTRING_template field_c;
BITSTRING_template field_b;
BITSTRING_template field_a;
};

void BSSMAP__IE__TraceType_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_e = ANY_VALUE;
single_value->field_d = ANY_VALUE;
single_value->field_c = ANY_VALUE;
single_value->field_b = ANY_VALUE;
single_value->field_a = ANY_VALUE;
}
}
}

void BSSMAP__IE__TraceType_template::copy_value(const BSSMAP__IE__TraceType& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.e().is_bound()) {
  single_value->field_e = other_value.e();
} else {
  single_value->field_e.clean_up();
}
if (other_value.d().is_bound()) {
  single_value->field_d = other_value.d();
} else {
  single_value->field_d.clean_up();
}
if (other_value.c().is_bound()) {
  single_value->field_c = other_value.c();
} else {
  single_value->field_c.clean_up();
}
if (other_value.b().is_bound()) {
  single_value->field_b = other_value.b();
} else {
  single_value->field_b.clean_up();
}
if (other_value.a().is_bound()) {
  single_value->field_a = other_value.a();
} else {
  single_value->field_a.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__TraceType_template::copy_template(const BSSMAP__IE__TraceType_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.e().get_selection()) {
single_value->field_e = other_value.e();
} else {
single_value->field_e.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.d().get_selection()) {
single_value->field_d = other_value.d();
} else {
single_value->field_d.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.c().get_selection()) {
single_value->field_c = other_value.c();
} else {
single_value->field_c.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.b().get_selection()) {
single_value->field_b = other_value.b();
} else {
single_value->field_b.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.a().get_selection()) {
single_value->field_a = other_value.a();
} else {
single_value->field_a.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__TraceType_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__TraceType_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__TraceType_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_TraceType.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__TraceType_template::BSSMAP__IE__TraceType_template()
{
}

BSSMAP__IE__TraceType_template::BSSMAP__IE__TraceType_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__TraceType_template::BSSMAP__IE__TraceType_template(const BSSMAP__IE__TraceType& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__TraceType_template::BSSMAP__IE__TraceType_template(const OPTIONAL<BSSMAP__IE__TraceType>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__TraceType&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_TraceType from an unbound optional field.");
}
}

BSSMAP__IE__TraceType_template::BSSMAP__IE__TraceType_template(BSSMAP__IE__TraceType_template* p_precondition, BSSMAP__IE__TraceType_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__TraceType_template::BSSMAP__IE__TraceType_template(Dynamic_Match_Interface<BSSMAP__IE__TraceType>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__TraceType>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__TraceType_template::BSSMAP__IE__TraceType_template(const BSSMAP__IE__TraceType_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__TraceType_template::~BSSMAP__IE__TraceType_template()
{
clean_up();
}

BSSMAP__IE__TraceType_template& BSSMAP__IE__TraceType_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__TraceType_template& BSSMAP__IE__TraceType_template::operator=(const BSSMAP__IE__TraceType& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__TraceType_template& BSSMAP__IE__TraceType_template::operator=(const OPTIONAL<BSSMAP__IE__TraceType>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__TraceType&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_TraceType.");
}
return *this;
}

BSSMAP__IE__TraceType_template& BSSMAP__IE__TraceType_template::operator=(const BSSMAP__IE__TraceType_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__TraceType_template::match(const BSSMAP__IE__TraceType& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.e().is_bound()) return FALSE;
if(!single_value->field_e.match(other_value.e(), legacy))return FALSE;
if(!other_value.d().is_bound()) return FALSE;
if(!single_value->field_d.match(other_value.d(), legacy))return FALSE;
if(!other_value.c().is_bound()) return FALSE;
if(!single_value->field_c.match(other_value.c(), legacy))return FALSE;
if(!other_value.b().is_bound()) return FALSE;
if(!single_value->field_b.match(other_value.b(), legacy))return FALSE;
if(!other_value.a().is_bound()) return FALSE;
if(!single_value->field_a.match(other_value.a(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_TraceType.");
}
return FALSE;
}

boolean BSSMAP__IE__TraceType_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_e.is_bound()
 || single_value->field_d.is_bound()
 || single_value->field_c.is_bound()
 || single_value->field_b.is_bound()
 || single_value->field_a.is_bound();
}

boolean BSSMAP__IE__TraceType_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_e.is_value()
 && single_value->field_d.is_value()
 && single_value->field_c.is_value()
 && single_value->field_b.is_value()
 && single_value->field_a.is_value();
}

void BSSMAP__IE__TraceType_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__TraceType BSSMAP__IE__TraceType_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_TraceType.");
BSSMAP__IE__TraceType ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_e.is_bound()) {
ret_val.e() = single_value->field_e.valueof();
}
if (single_value->field_d.is_bound()) {
ret_val.d() = single_value->field_d.valueof();
}
if (single_value->field_c.is_bound()) {
ret_val.c() = single_value->field_c.valueof();
}
if (single_value->field_b.is_bound()) {
ret_val.b() = single_value->field_b.valueof();
}
if (single_value->field_a.is_bound()) {
ret_val.a() = single_value->field_a.valueof();
}
return ret_val;
}

void BSSMAP__IE__TraceType_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_TraceType.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__TraceType_template[list_length];
}

BSSMAP__IE__TraceType_template& BSSMAP__IE__TraceType_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_TraceType.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_TraceType.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__TraceType_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__TraceType_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_TraceType.");
return single_value->field_elementIdentifier;
}

BITSTRING_template& BSSMAP__IE__TraceType_template::e()
{
set_specific();
return single_value->field_e;
}

const BITSTRING_template& BSSMAP__IE__TraceType_template::e() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field e of a non-specific template of type @BSSAP_Types.BSSMAP_IE_TraceType.");
return single_value->field_e;
}

BITSTRING_template& BSSMAP__IE__TraceType_template::d()
{
set_specific();
return single_value->field_d;
}

const BITSTRING_template& BSSMAP__IE__TraceType_template::d() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field d of a non-specific template of type @BSSAP_Types.BSSMAP_IE_TraceType.");
return single_value->field_d;
}

BITSTRING_template& BSSMAP__IE__TraceType_template::c()
{
set_specific();
return single_value->field_c;
}

const BITSTRING_template& BSSMAP__IE__TraceType_template::c() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field c of a non-specific template of type @BSSAP_Types.BSSMAP_IE_TraceType.");
return single_value->field_c;
}

BITSTRING_template& BSSMAP__IE__TraceType_template::b()
{
set_specific();
return single_value->field_b;
}

const BITSTRING_template& BSSMAP__IE__TraceType_template::b() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field b of a non-specific template of type @BSSAP_Types.BSSMAP_IE_TraceType.");
return single_value->field_b;
}

BITSTRING_template& BSSMAP__IE__TraceType_template::a()
{
set_specific();
return single_value->field_a;
}

const BITSTRING_template& BSSMAP__IE__TraceType_template::a() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field a of a non-specific template of type @BSSAP_Types.BSSMAP_IE_TraceType.");
return single_value->field_a;
}

int BSSMAP__IE__TraceType_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TraceType which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 6;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TraceType containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TraceType containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TraceType containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TraceType containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TraceType containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TraceType containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TraceType containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TraceType containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_TraceType.");
  }
  return 0;
}

void BSSMAP__IE__TraceType_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", e := ");
single_value->field_e.log();
TTCN_Logger::log_event_str(", d := ");
single_value->field_d.log();
TTCN_Logger::log_event_str(", c := ");
single_value->field_c.log();
TTCN_Logger::log_event_str(", b := ");
single_value->field_b.log();
TTCN_Logger::log_event_str(", a := ");
single_value->field_a.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__TraceType_template::log_match(const BSSMAP__IE__TraceType& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_e.match(match_value.e(), legacy)){
TTCN_Logger::log_logmatch_info(".e");
single_value->field_e.log_match(match_value.e(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_d.match(match_value.d(), legacy)){
TTCN_Logger::log_logmatch_info(".d");
single_value->field_d.log_match(match_value.d(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_c.match(match_value.c(), legacy)){
TTCN_Logger::log_logmatch_info(".c");
single_value->field_c.log_match(match_value.c(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_b.match(match_value.b(), legacy)){
TTCN_Logger::log_logmatch_info(".b");
single_value->field_b.log_match(match_value.b(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_a.match(match_value.a(), legacy)){
TTCN_Logger::log_logmatch_info(".a");
single_value->field_a.log_match(match_value.a(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", e := ");
single_value->field_e.log_match(match_value.e(), legacy);
TTCN_Logger::log_event_str(", d := ");
single_value->field_d.log_match(match_value.d(), legacy);
TTCN_Logger::log_event_str(", c := ");
single_value->field_c.log_match(match_value.c(), legacy);
TTCN_Logger::log_event_str(", b := ");
single_value->field_b.log_match(match_value.b(), legacy);
TTCN_Logger::log_event_str(", a := ");
single_value->field_a.log_match(match_value.a(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__TraceType_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (e().is_bound()) e().set_implicit_omit();
if (d().is_bound()) d().set_implicit_omit();
if (c().is_bound()) c().set_implicit_omit();
if (b().is_bound()) b().set_implicit_omit();
if (a().is_bound()) a().set_implicit_omit();
}

void BSSMAP__IE__TraceType_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_e.encode_text(text_buf);
single_value->field_d.encode_text(text_buf);
single_value->field_c.encode_text(text_buf);
single_value->field_b.encode_text(text_buf);
single_value->field_a.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_TraceType.");
}
}

void BSSMAP__IE__TraceType_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_e.decode_text(text_buf);
single_value->field_d.decode_text(text_buf);
single_value->field_c.decode_text(text_buf);
single_value->field_b.decode_text(text_buf);
single_value->field_a.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__TraceType_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_TraceType.");
}
}

void BSSMAP__IE__TraceType_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__TraceType_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_TraceType has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) e().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) d().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) c().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) b().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) a().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "e")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          e().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "d")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          d().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "c")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          c().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "b")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          b().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "a")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          a().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_TraceType: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__TraceType_template* precondition = new BSSMAP__IE__TraceType_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__TraceType_template* implied_template = new BSSMAP__IE__TraceType_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__TraceType_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_TraceType");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__TraceType_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_TraceType");
single_value->field_e.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_TraceType");
single_value->field_d.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_TraceType");
single_value->field_c.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_TraceType");
single_value->field_b.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_TraceType");
single_value->field_a.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_TraceType");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_TraceType");
}

boolean BSSMAP__IE__TraceType_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__TraceType_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__TriggerId::BSSMAP__IE__TriggerId()
{
}

BSSMAP__IE__TriggerId::BSSMAP__IE__TriggerId(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_entityIdentity)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_entityIdentity(par_entityIdentity)
{
}

BSSMAP__IE__TriggerId::BSSMAP__IE__TriggerId(const BSSMAP__IE__TriggerId& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_TriggerId.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.entityIdentity().is_bound()) field_entityIdentity = other_value.entityIdentity();
else field_entityIdentity.clean_up();
}

void BSSMAP__IE__TriggerId::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_entityIdentity.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__TriggerId::get_descriptor() const { return &BSSMAP__IE__TriggerId_descr_; }
BSSMAP__IE__TriggerId& BSSMAP__IE__TriggerId::operator=(const BSSMAP__IE__TriggerId& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_TriggerId.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.entityIdentity().is_bound()) field_entityIdentity = other_value.entityIdentity();
  else field_entityIdentity.clean_up();
}
return *this;
}

boolean BSSMAP__IE__TriggerId::operator==(const BSSMAP__IE__TriggerId& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_entityIdentity==other_value.field_entityIdentity;
}

boolean BSSMAP__IE__TriggerId::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_entityIdentity.is_bound());
}
boolean BSSMAP__IE__TriggerId::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_entityIdentity.is_value();
}
void BSSMAP__IE__TriggerId::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", entityIdentity := ");
field_entityIdentity.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__TriggerId::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (entityIdentity().is_bound()) entityIdentity().set_implicit_omit();
}

void BSSMAP__IE__TriggerId::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_TriggerId has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) entityIdentity().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "entityIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          entityIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_TriggerId: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_TriggerId");
  }
}

void BSSMAP__IE__TriggerId::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_entityIdentity.encode_text(text_buf);
}

void BSSMAP__IE__TriggerId::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_entityIdentity.decode_text(text_buf);
}

void BSSMAP__IE__TriggerId::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__TriggerId::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__TriggerId::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__TriggerId_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__TriggerId_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__TriggerId_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_entityIdentity.RAW_decode(OCTETSTRING_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_40) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__TriggerId::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__TriggerId_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, OCTETSTRING_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__TriggerId_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_entityIdentity.RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier !=  os_40) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_40.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__TriggerId_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_entityIdentity;
};

void BSSMAP__IE__TriggerId_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_entityIdentity = ANY_VALUE;
}
}
}

void BSSMAP__IE__TriggerId_template::copy_value(const BSSMAP__IE__TriggerId& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.entityIdentity().is_bound()) {
  single_value->field_entityIdentity = other_value.entityIdentity();
} else {
  single_value->field_entityIdentity.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__TriggerId_template::copy_template(const BSSMAP__IE__TriggerId_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.entityIdentity().get_selection()) {
single_value->field_entityIdentity = other_value.entityIdentity();
} else {
single_value->field_entityIdentity.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__TriggerId_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__TriggerId_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__TriggerId_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_TriggerId.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__TriggerId_template::BSSMAP__IE__TriggerId_template()
{
}

BSSMAP__IE__TriggerId_template::BSSMAP__IE__TriggerId_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__TriggerId_template::BSSMAP__IE__TriggerId_template(const BSSMAP__IE__TriggerId& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__TriggerId_template::BSSMAP__IE__TriggerId_template(const OPTIONAL<BSSMAP__IE__TriggerId>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__TriggerId&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_TriggerId from an unbound optional field.");
}
}

BSSMAP__IE__TriggerId_template::BSSMAP__IE__TriggerId_template(BSSMAP__IE__TriggerId_template* p_precondition, BSSMAP__IE__TriggerId_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__TriggerId_template::BSSMAP__IE__TriggerId_template(Dynamic_Match_Interface<BSSMAP__IE__TriggerId>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__TriggerId>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__TriggerId_template::BSSMAP__IE__TriggerId_template(const BSSMAP__IE__TriggerId_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__TriggerId_template::~BSSMAP__IE__TriggerId_template()
{
clean_up();
}

BSSMAP__IE__TriggerId_template& BSSMAP__IE__TriggerId_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__TriggerId_template& BSSMAP__IE__TriggerId_template::operator=(const BSSMAP__IE__TriggerId& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__TriggerId_template& BSSMAP__IE__TriggerId_template::operator=(const OPTIONAL<BSSMAP__IE__TriggerId>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__TriggerId&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_TriggerId.");
}
return *this;
}

BSSMAP__IE__TriggerId_template& BSSMAP__IE__TriggerId_template::operator=(const BSSMAP__IE__TriggerId_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__TriggerId_template::match(const BSSMAP__IE__TriggerId& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.entityIdentity().is_bound()) return FALSE;
if(!single_value->field_entityIdentity.match(other_value.entityIdentity(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_TriggerId.");
}
return FALSE;
}

boolean BSSMAP__IE__TriggerId_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_entityIdentity.is_bound();
}

boolean BSSMAP__IE__TriggerId_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_entityIdentity.is_value();
}

void BSSMAP__IE__TriggerId_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__TriggerId BSSMAP__IE__TriggerId_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_TriggerId.");
BSSMAP__IE__TriggerId ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_entityIdentity.is_bound()) {
ret_val.entityIdentity() = single_value->field_entityIdentity.valueof();
}
return ret_val;
}

void BSSMAP__IE__TriggerId_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_TriggerId.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__TriggerId_template[list_length];
}

BSSMAP__IE__TriggerId_template& BSSMAP__IE__TriggerId_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_TriggerId.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_TriggerId.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__TriggerId_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__TriggerId_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_TriggerId.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__TriggerId_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__TriggerId_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_TriggerId.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& BSSMAP__IE__TriggerId_template::entityIdentity()
{
set_specific();
return single_value->field_entityIdentity;
}

const OCTETSTRING_template& BSSMAP__IE__TriggerId_template::entityIdentity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field entityIdentity of a non-specific template of type @BSSAP_Types.BSSMAP_IE_TriggerId.");
return single_value->field_entityIdentity;
}

int BSSMAP__IE__TriggerId_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TriggerId which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TriggerId containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TriggerId containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TriggerId containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TriggerId containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TriggerId containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TriggerId containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TriggerId containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TriggerId containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_TriggerId.");
  }
  return 0;
}

void BSSMAP__IE__TriggerId_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", entityIdentity := ");
single_value->field_entityIdentity.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__TriggerId_template::log_match(const BSSMAP__IE__TriggerId& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_entityIdentity.match(match_value.entityIdentity(), legacy)){
TTCN_Logger::log_logmatch_info(".entityIdentity");
single_value->field_entityIdentity.log_match(match_value.entityIdentity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", entityIdentity := ");
single_value->field_entityIdentity.log_match(match_value.entityIdentity(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__TriggerId_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (entityIdentity().is_bound()) entityIdentity().set_implicit_omit();
}

void BSSMAP__IE__TriggerId_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_entityIdentity.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_TriggerId.");
}
}

void BSSMAP__IE__TriggerId_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_entityIdentity.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__TriggerId_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_TriggerId.");
}
}

void BSSMAP__IE__TriggerId_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__TriggerId_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_TriggerId has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) entityIdentity().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "entityIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          entityIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_TriggerId: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__TriggerId_template* precondition = new BSSMAP__IE__TriggerId_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__TriggerId_template* implied_template = new BSSMAP__IE__TriggerId_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__TriggerId_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_TriggerId");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__TriggerId_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_TriggerId");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_TriggerId");
single_value->field_entityIdentity.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_TriggerId");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_TriggerId");
}

boolean BSSMAP__IE__TriggerId_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__TriggerId_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__TraceReference::BSSMAP__IE__TraceReference()
{
}

BSSMAP__IE__TraceReference::BSSMAP__IE__TraceReference(const OCTETSTRING& par_elementIdentifier,
    const OCTETSTRING& par_msb__TraceReference,
    const OCTETSTRING& par_lsb__TraceReference)
  :   field_elementIdentifier(par_elementIdentifier),
  field_msb__TraceReference(par_msb__TraceReference),
  field_lsb__TraceReference(par_lsb__TraceReference)
{
}

BSSMAP__IE__TraceReference::BSSMAP__IE__TraceReference(const BSSMAP__IE__TraceReference& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_TraceReference.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.msb__TraceReference().is_bound()) field_msb__TraceReference = other_value.msb__TraceReference();
else field_msb__TraceReference.clean_up();
if (other_value.lsb__TraceReference().is_bound()) field_lsb__TraceReference = other_value.lsb__TraceReference();
else field_lsb__TraceReference.clean_up();
}

void BSSMAP__IE__TraceReference::clean_up()
{
field_elementIdentifier.clean_up();
field_msb__TraceReference.clean_up();
field_lsb__TraceReference.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__TraceReference::get_descriptor() const { return &BSSMAP__IE__TraceReference_descr_; }
BSSMAP__IE__TraceReference& BSSMAP__IE__TraceReference::operator=(const BSSMAP__IE__TraceReference& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_TraceReference.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.msb__TraceReference().is_bound()) field_msb__TraceReference = other_value.msb__TraceReference();
  else field_msb__TraceReference.clean_up();
  if (other_value.lsb__TraceReference().is_bound()) field_lsb__TraceReference = other_value.lsb__TraceReference();
  else field_lsb__TraceReference.clean_up();
}
return *this;
}

boolean BSSMAP__IE__TraceReference::operator==(const BSSMAP__IE__TraceReference& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_msb__TraceReference==other_value.field_msb__TraceReference
  && field_lsb__TraceReference==other_value.field_lsb__TraceReference;
}

boolean BSSMAP__IE__TraceReference::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_msb__TraceReference.is_bound())
  || (field_lsb__TraceReference.is_bound());
}
boolean BSSMAP__IE__TraceReference::is_value() const
{
return field_elementIdentifier.is_value()
  && field_msb__TraceReference.is_value()
  && field_lsb__TraceReference.is_value();
}
void BSSMAP__IE__TraceReference::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", msb_TraceReference := ");
field_msb__TraceReference.log();
TTCN_Logger::log_event_str(", lsb_TraceReference := ");
field_lsb__TraceReference.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__TraceReference::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (msb__TraceReference().is_bound()) msb__TraceReference().set_implicit_omit();
if (lsb__TraceReference().is_bound()) lsb__TraceReference().set_implicit_omit();
}

void BSSMAP__IE__TraceReference::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_TraceReference has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) msb__TraceReference().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lsb__TraceReference().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "msb_TraceReference")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          msb__TraceReference().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lsb_TraceReference")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lsb__TraceReference().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_TraceReference: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_TraceReference");
  }
}

void BSSMAP__IE__TraceReference::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_msb__TraceReference.encode_text(text_buf);
field_lsb__TraceReference.encode_text(text_buf);
}

void BSSMAP__IE__TraceReference::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_msb__TraceReference.decode_text(text_buf);
field_lsb__TraceReference.decode_text(text_buf);
}

void BSSMAP__IE__TraceReference::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__TraceReference::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__TraceReference::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_msb__TraceReference.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_lsb__TraceReference.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_elementIdentifier !=  os_41) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__TraceReference::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT1_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_msb__TraceReference.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_lsb__TraceReference.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier !=  os_41) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_41.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__TraceReference_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
OCTETSTRING_template field_msb__TraceReference;
OCTETSTRING_template field_lsb__TraceReference;
};

void BSSMAP__IE__TraceReference_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_msb__TraceReference = ANY_VALUE;
single_value->field_lsb__TraceReference = ANY_VALUE;
}
}
}

void BSSMAP__IE__TraceReference_template::copy_value(const BSSMAP__IE__TraceReference& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.msb__TraceReference().is_bound()) {
  single_value->field_msb__TraceReference = other_value.msb__TraceReference();
} else {
  single_value->field_msb__TraceReference.clean_up();
}
if (other_value.lsb__TraceReference().is_bound()) {
  single_value->field_lsb__TraceReference = other_value.lsb__TraceReference();
} else {
  single_value->field_lsb__TraceReference.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__TraceReference_template::copy_template(const BSSMAP__IE__TraceReference_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.msb__TraceReference().get_selection()) {
single_value->field_msb__TraceReference = other_value.msb__TraceReference();
} else {
single_value->field_msb__TraceReference.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lsb__TraceReference().get_selection()) {
single_value->field_lsb__TraceReference = other_value.lsb__TraceReference();
} else {
single_value->field_lsb__TraceReference.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__TraceReference_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__TraceReference_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__TraceReference_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_TraceReference.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__TraceReference_template::BSSMAP__IE__TraceReference_template()
{
}

BSSMAP__IE__TraceReference_template::BSSMAP__IE__TraceReference_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__TraceReference_template::BSSMAP__IE__TraceReference_template(const BSSMAP__IE__TraceReference& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__TraceReference_template::BSSMAP__IE__TraceReference_template(const OPTIONAL<BSSMAP__IE__TraceReference>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__TraceReference&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_TraceReference from an unbound optional field.");
}
}

BSSMAP__IE__TraceReference_template::BSSMAP__IE__TraceReference_template(BSSMAP__IE__TraceReference_template* p_precondition, BSSMAP__IE__TraceReference_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__TraceReference_template::BSSMAP__IE__TraceReference_template(Dynamic_Match_Interface<BSSMAP__IE__TraceReference>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__TraceReference>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__TraceReference_template::BSSMAP__IE__TraceReference_template(const BSSMAP__IE__TraceReference_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__TraceReference_template::~BSSMAP__IE__TraceReference_template()
{
clean_up();
}

BSSMAP__IE__TraceReference_template& BSSMAP__IE__TraceReference_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__TraceReference_template& BSSMAP__IE__TraceReference_template::operator=(const BSSMAP__IE__TraceReference& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__TraceReference_template& BSSMAP__IE__TraceReference_template::operator=(const OPTIONAL<BSSMAP__IE__TraceReference>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__TraceReference&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_TraceReference.");
}
return *this;
}

BSSMAP__IE__TraceReference_template& BSSMAP__IE__TraceReference_template::operator=(const BSSMAP__IE__TraceReference_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__TraceReference_template::match(const BSSMAP__IE__TraceReference& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.msb__TraceReference().is_bound()) return FALSE;
if(!single_value->field_msb__TraceReference.match(other_value.msb__TraceReference(), legacy))return FALSE;
if(!other_value.lsb__TraceReference().is_bound()) return FALSE;
if(!single_value->field_lsb__TraceReference.match(other_value.lsb__TraceReference(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_TraceReference.");
}
return FALSE;
}

boolean BSSMAP__IE__TraceReference_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_msb__TraceReference.is_bound()
 || single_value->field_lsb__TraceReference.is_bound();
}

boolean BSSMAP__IE__TraceReference_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_msb__TraceReference.is_value()
 && single_value->field_lsb__TraceReference.is_value();
}

void BSSMAP__IE__TraceReference_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__TraceReference BSSMAP__IE__TraceReference_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_TraceReference.");
BSSMAP__IE__TraceReference ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_msb__TraceReference.is_bound()) {
ret_val.msb__TraceReference() = single_value->field_msb__TraceReference.valueof();
}
if (single_value->field_lsb__TraceReference.is_bound()) {
ret_val.lsb__TraceReference() = single_value->field_lsb__TraceReference.valueof();
}
return ret_val;
}

void BSSMAP__IE__TraceReference_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_TraceReference.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__TraceReference_template[list_length];
}

BSSMAP__IE__TraceReference_template& BSSMAP__IE__TraceReference_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_TraceReference.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_TraceReference.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__TraceReference_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__TraceReference_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_TraceReference.");
return single_value->field_elementIdentifier;
}

OCTETSTRING_template& BSSMAP__IE__TraceReference_template::msb__TraceReference()
{
set_specific();
return single_value->field_msb__TraceReference;
}

const OCTETSTRING_template& BSSMAP__IE__TraceReference_template::msb__TraceReference() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field msb_TraceReference of a non-specific template of type @BSSAP_Types.BSSMAP_IE_TraceReference.");
return single_value->field_msb__TraceReference;
}

OCTETSTRING_template& BSSMAP__IE__TraceReference_template::lsb__TraceReference()
{
set_specific();
return single_value->field_lsb__TraceReference;
}

const OCTETSTRING_template& BSSMAP__IE__TraceReference_template::lsb__TraceReference() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lsb_TraceReference of a non-specific template of type @BSSAP_Types.BSSMAP_IE_TraceReference.");
return single_value->field_lsb__TraceReference;
}

int BSSMAP__IE__TraceReference_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TraceReference which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TraceReference containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TraceReference containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TraceReference containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TraceReference containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TraceReference containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TraceReference containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TraceReference containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TraceReference containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_TraceReference.");
  }
  return 0;
}

void BSSMAP__IE__TraceReference_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", msb_TraceReference := ");
single_value->field_msb__TraceReference.log();
TTCN_Logger::log_event_str(", lsb_TraceReference := ");
single_value->field_lsb__TraceReference.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__TraceReference_template::log_match(const BSSMAP__IE__TraceReference& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_msb__TraceReference.match(match_value.msb__TraceReference(), legacy)){
TTCN_Logger::log_logmatch_info(".msb_TraceReference");
single_value->field_msb__TraceReference.log_match(match_value.msb__TraceReference(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lsb__TraceReference.match(match_value.lsb__TraceReference(), legacy)){
TTCN_Logger::log_logmatch_info(".lsb_TraceReference");
single_value->field_lsb__TraceReference.log_match(match_value.lsb__TraceReference(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", msb_TraceReference := ");
single_value->field_msb__TraceReference.log_match(match_value.msb__TraceReference(), legacy);
TTCN_Logger::log_event_str(", lsb_TraceReference := ");
single_value->field_lsb__TraceReference.log_match(match_value.lsb__TraceReference(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__TraceReference_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (msb__TraceReference().is_bound()) msb__TraceReference().set_implicit_omit();
if (lsb__TraceReference().is_bound()) lsb__TraceReference().set_implicit_omit();
}

void BSSMAP__IE__TraceReference_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_msb__TraceReference.encode_text(text_buf);
single_value->field_lsb__TraceReference.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_TraceReference.");
}
}

void BSSMAP__IE__TraceReference_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_msb__TraceReference.decode_text(text_buf);
single_value->field_lsb__TraceReference.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__TraceReference_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_TraceReference.");
}
}

void BSSMAP__IE__TraceReference_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__TraceReference_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_TraceReference has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) msb__TraceReference().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lsb__TraceReference().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "msb_TraceReference")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          msb__TraceReference().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lsb_TraceReference")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lsb__TraceReference().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_TraceReference: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__TraceReference_template* precondition = new BSSMAP__IE__TraceReference_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__TraceReference_template* implied_template = new BSSMAP__IE__TraceReference_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__TraceReference_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_TraceReference");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__TraceReference_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_TraceReference");
single_value->field_msb__TraceReference.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_TraceReference");
single_value->field_lsb__TraceReference.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_TraceReference");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_TraceReference");
}

boolean BSSMAP__IE__TraceReference_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__TraceReference_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__TransactionId::BSSMAP__IE__TransactionId()
{
}

BSSMAP__IE__TransactionId::BSSMAP__IE__TransactionId(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_transactionNumber)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_transactionNumber(par_transactionNumber)
{
}

BSSMAP__IE__TransactionId::BSSMAP__IE__TransactionId(const BSSMAP__IE__TransactionId& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_TransactionId.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.transactionNumber().is_bound()) field_transactionNumber = other_value.transactionNumber();
else field_transactionNumber.clean_up();
}

void BSSMAP__IE__TransactionId::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_transactionNumber.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__TransactionId::get_descriptor() const { return &BSSMAP__IE__TransactionId_descr_; }
BSSMAP__IE__TransactionId& BSSMAP__IE__TransactionId::operator=(const BSSMAP__IE__TransactionId& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_TransactionId.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.transactionNumber().is_bound()) field_transactionNumber = other_value.transactionNumber();
  else field_transactionNumber.clean_up();
}
return *this;
}

boolean BSSMAP__IE__TransactionId::operator==(const BSSMAP__IE__TransactionId& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_transactionNumber==other_value.field_transactionNumber;
}

boolean BSSMAP__IE__TransactionId::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_transactionNumber.is_bound());
}
boolean BSSMAP__IE__TransactionId::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_transactionNumber.is_value();
}
void BSSMAP__IE__TransactionId::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", transactionNumber := ");
field_transactionNumber.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__TransactionId::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (transactionNumber().is_bound()) transactionNumber().set_implicit_omit();
}

void BSSMAP__IE__TransactionId::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_TransactionId has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) transactionNumber().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "transactionNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          transactionNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_TransactionId: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_TransactionId");
  }
}

void BSSMAP__IE__TransactionId::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_transactionNumber.encode_text(text_buf);
}

void BSSMAP__IE__TransactionId::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_transactionNumber.decode_text(text_buf);
}

void BSSMAP__IE__TransactionId::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__TransactionId::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__TransactionId::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__TransactionId_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__TransactionId_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__TransactionId_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_transactionNumber.RAW_decode(OCTETSTRING_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_42) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__TransactionId::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__TransactionId_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, OCTETSTRING_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__TransactionId_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_transactionNumber.RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier !=  os_42) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_42.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__TransactionId_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_transactionNumber;
};

void BSSMAP__IE__TransactionId_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_transactionNumber = ANY_VALUE;
}
}
}

void BSSMAP__IE__TransactionId_template::copy_value(const BSSMAP__IE__TransactionId& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.transactionNumber().is_bound()) {
  single_value->field_transactionNumber = other_value.transactionNumber();
} else {
  single_value->field_transactionNumber.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__TransactionId_template::copy_template(const BSSMAP__IE__TransactionId_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.transactionNumber().get_selection()) {
single_value->field_transactionNumber = other_value.transactionNumber();
} else {
single_value->field_transactionNumber.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__TransactionId_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__TransactionId_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__TransactionId_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_TransactionId.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__TransactionId_template::BSSMAP__IE__TransactionId_template()
{
}

BSSMAP__IE__TransactionId_template::BSSMAP__IE__TransactionId_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__TransactionId_template::BSSMAP__IE__TransactionId_template(const BSSMAP__IE__TransactionId& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__TransactionId_template::BSSMAP__IE__TransactionId_template(const OPTIONAL<BSSMAP__IE__TransactionId>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__TransactionId&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_TransactionId from an unbound optional field.");
}
}

BSSMAP__IE__TransactionId_template::BSSMAP__IE__TransactionId_template(BSSMAP__IE__TransactionId_template* p_precondition, BSSMAP__IE__TransactionId_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__TransactionId_template::BSSMAP__IE__TransactionId_template(Dynamic_Match_Interface<BSSMAP__IE__TransactionId>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__TransactionId>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__TransactionId_template::BSSMAP__IE__TransactionId_template(const BSSMAP__IE__TransactionId_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__TransactionId_template::~BSSMAP__IE__TransactionId_template()
{
clean_up();
}

BSSMAP__IE__TransactionId_template& BSSMAP__IE__TransactionId_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__TransactionId_template& BSSMAP__IE__TransactionId_template::operator=(const BSSMAP__IE__TransactionId& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__TransactionId_template& BSSMAP__IE__TransactionId_template::operator=(const OPTIONAL<BSSMAP__IE__TransactionId>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__TransactionId&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_TransactionId.");
}
return *this;
}

BSSMAP__IE__TransactionId_template& BSSMAP__IE__TransactionId_template::operator=(const BSSMAP__IE__TransactionId_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__TransactionId_template::match(const BSSMAP__IE__TransactionId& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.transactionNumber().is_bound()) return FALSE;
if(!single_value->field_transactionNumber.match(other_value.transactionNumber(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_TransactionId.");
}
return FALSE;
}

boolean BSSMAP__IE__TransactionId_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_transactionNumber.is_bound();
}

boolean BSSMAP__IE__TransactionId_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_transactionNumber.is_value();
}

void BSSMAP__IE__TransactionId_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__TransactionId BSSMAP__IE__TransactionId_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_TransactionId.");
BSSMAP__IE__TransactionId ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_transactionNumber.is_bound()) {
ret_val.transactionNumber() = single_value->field_transactionNumber.valueof();
}
return ret_val;
}

void BSSMAP__IE__TransactionId_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_TransactionId.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__TransactionId_template[list_length];
}

BSSMAP__IE__TransactionId_template& BSSMAP__IE__TransactionId_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_TransactionId.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_TransactionId.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__TransactionId_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__TransactionId_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_TransactionId.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__TransactionId_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__TransactionId_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_TransactionId.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& BSSMAP__IE__TransactionId_template::transactionNumber()
{
set_specific();
return single_value->field_transactionNumber;
}

const OCTETSTRING_template& BSSMAP__IE__TransactionId_template::transactionNumber() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field transactionNumber of a non-specific template of type @BSSAP_Types.BSSMAP_IE_TransactionId.");
return single_value->field_transactionNumber;
}

int BSSMAP__IE__TransactionId_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TransactionId which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TransactionId containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TransactionId containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TransactionId containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TransactionId containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TransactionId containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TransactionId containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TransactionId containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TransactionId containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_TransactionId.");
  }
  return 0;
}

void BSSMAP__IE__TransactionId_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", transactionNumber := ");
single_value->field_transactionNumber.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__TransactionId_template::log_match(const BSSMAP__IE__TransactionId& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_transactionNumber.match(match_value.transactionNumber(), legacy)){
TTCN_Logger::log_logmatch_info(".transactionNumber");
single_value->field_transactionNumber.log_match(match_value.transactionNumber(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", transactionNumber := ");
single_value->field_transactionNumber.log_match(match_value.transactionNumber(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__TransactionId_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (transactionNumber().is_bound()) transactionNumber().set_implicit_omit();
}

void BSSMAP__IE__TransactionId_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_transactionNumber.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_TransactionId.");
}
}

void BSSMAP__IE__TransactionId_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_transactionNumber.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__TransactionId_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_TransactionId.");
}
}

void BSSMAP__IE__TransactionId_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__TransactionId_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_TransactionId has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) transactionNumber().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "transactionNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          transactionNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_TransactionId: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__TransactionId_template* precondition = new BSSMAP__IE__TransactionId_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__TransactionId_template* implied_template = new BSSMAP__IE__TransactionId_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__TransactionId_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_TransactionId");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__TransactionId_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_TransactionId");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_TransactionId");
single_value->field_transactionNumber.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_TransactionId");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_TransactionId");
}

boolean BSSMAP__IE__TransactionId_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__TransactionId_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__MobileIdentity::BSSMAP__IE__MobileIdentity()
{
}

BSSMAP__IE__MobileIdentity::BSSMAP__IE__MobileIdentity(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const BITSTRING& par_typeOfIdentity,
    const BITSTRING& par_oddEvenIndicator,
    const HEXSTRING& par_digits)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_typeOfIdentity(par_typeOfIdentity),
  field_oddEvenIndicator(par_oddEvenIndicator),
  field_digits(par_digits)
{
}

BSSMAP__IE__MobileIdentity::BSSMAP__IE__MobileIdentity(const BSSMAP__IE__MobileIdentity& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_MobileIdentity.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.typeOfIdentity().is_bound()) field_typeOfIdentity = other_value.typeOfIdentity();
else field_typeOfIdentity.clean_up();
if (other_value.oddEvenIndicator().is_bound()) field_oddEvenIndicator = other_value.oddEvenIndicator();
else field_oddEvenIndicator.clean_up();
if (other_value.digits().is_bound()) field_digits = other_value.digits();
else field_digits.clean_up();
}

void BSSMAP__IE__MobileIdentity::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_typeOfIdentity.clean_up();
field_oddEvenIndicator.clean_up();
field_digits.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__MobileIdentity::get_descriptor() const { return &BSSMAP__IE__MobileIdentity_descr_; }
BSSMAP__IE__MobileIdentity& BSSMAP__IE__MobileIdentity::operator=(const BSSMAP__IE__MobileIdentity& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_MobileIdentity.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.typeOfIdentity().is_bound()) field_typeOfIdentity = other_value.typeOfIdentity();
  else field_typeOfIdentity.clean_up();
  if (other_value.oddEvenIndicator().is_bound()) field_oddEvenIndicator = other_value.oddEvenIndicator();
  else field_oddEvenIndicator.clean_up();
  if (other_value.digits().is_bound()) field_digits = other_value.digits();
  else field_digits.clean_up();
}
return *this;
}

boolean BSSMAP__IE__MobileIdentity::operator==(const BSSMAP__IE__MobileIdentity& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_typeOfIdentity==other_value.field_typeOfIdentity
  && field_oddEvenIndicator==other_value.field_oddEvenIndicator
  && field_digits==other_value.field_digits;
}

boolean BSSMAP__IE__MobileIdentity::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_typeOfIdentity.is_bound())
  || (field_oddEvenIndicator.is_bound())
  || (field_digits.is_bound());
}
boolean BSSMAP__IE__MobileIdentity::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_typeOfIdentity.is_value()
  && field_oddEvenIndicator.is_value()
  && field_digits.is_value();
}
void BSSMAP__IE__MobileIdentity::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", typeOfIdentity := ");
field_typeOfIdentity.log();
TTCN_Logger::log_event_str(", oddEvenIndicator := ");
field_oddEvenIndicator.log();
TTCN_Logger::log_event_str(", digits := ");
field_digits.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__MobileIdentity::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (typeOfIdentity().is_bound()) typeOfIdentity().set_implicit_omit();
if (oddEvenIndicator().is_bound()) oddEvenIndicator().set_implicit_omit();
if (digits().is_bound()) digits().set_implicit_omit();
}

void BSSMAP__IE__MobileIdentity::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_MobileIdentity has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) typeOfIdentity().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) oddEvenIndicator().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) digits().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "typeOfIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          typeOfIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "oddEvenIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          oddEvenIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "digits")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          digits().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_MobileIdentity: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_MobileIdentity");
  }
}

void BSSMAP__IE__MobileIdentity::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_typeOfIdentity.encode_text(text_buf);
field_oddEvenIndicator.encode_text(text_buf);
field_digits.encode_text(text_buf);
}

void BSSMAP__IE__MobileIdentity::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_typeOfIdentity.decode_text(text_buf);
field_oddEvenIndicator.decode_text(text_buf);
field_digits.decode_text(text_buf);
}

void BSSMAP__IE__MobileIdentity::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__MobileIdentity::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__MobileIdentity::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__MobileIdentity_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__MobileIdentity_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__MobileIdentity_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT3_descr_.raw->forceomit);
  decoded_field_length = field_typeOfIdentity.RAW_decode(General__Types::BIT3_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_oddEvenIndicator.RAW_decode(General__Types::BIT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::HEX5__16_descr_.raw->forceomit);
  decoded_field_length = field_digits.RAW_decode(General__Types::HEX5__16_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_89) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__MobileIdentity::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__MobileIdentity_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT3_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::HEX5__16_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__MobileIdentity_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  encoded_length += field_typeOfIdentity.RAW_encode(General__Types::BIT3_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_oddEvenIndicator.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_digits.RAW_encode(General__Types::HEX5__16_descr_, *myleaf.body.node.nodes[4]);
  if (field_elementIdentifier !=  os_89) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_89.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__MobileIdentity_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
BITSTRING_template field_typeOfIdentity;
BITSTRING_template field_oddEvenIndicator;
HEXSTRING_template field_digits;
};

void BSSMAP__IE__MobileIdentity_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_typeOfIdentity = ANY_VALUE;
single_value->field_oddEvenIndicator = ANY_VALUE;
single_value->field_digits = ANY_VALUE;
}
}
}

void BSSMAP__IE__MobileIdentity_template::copy_value(const BSSMAP__IE__MobileIdentity& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.typeOfIdentity().is_bound()) {
  single_value->field_typeOfIdentity = other_value.typeOfIdentity();
} else {
  single_value->field_typeOfIdentity.clean_up();
}
if (other_value.oddEvenIndicator().is_bound()) {
  single_value->field_oddEvenIndicator = other_value.oddEvenIndicator();
} else {
  single_value->field_oddEvenIndicator.clean_up();
}
if (other_value.digits().is_bound()) {
  single_value->field_digits = other_value.digits();
} else {
  single_value->field_digits.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__MobileIdentity_template::copy_template(const BSSMAP__IE__MobileIdentity_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.typeOfIdentity().get_selection()) {
single_value->field_typeOfIdentity = other_value.typeOfIdentity();
} else {
single_value->field_typeOfIdentity.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.oddEvenIndicator().get_selection()) {
single_value->field_oddEvenIndicator = other_value.oddEvenIndicator();
} else {
single_value->field_oddEvenIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.digits().get_selection()) {
single_value->field_digits = other_value.digits();
} else {
single_value->field_digits.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__MobileIdentity_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__MobileIdentity_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__MobileIdentity_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__MobileIdentity_template::BSSMAP__IE__MobileIdentity_template()
{
}

BSSMAP__IE__MobileIdentity_template::BSSMAP__IE__MobileIdentity_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__MobileIdentity_template::BSSMAP__IE__MobileIdentity_template(const BSSMAP__IE__MobileIdentity& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__MobileIdentity_template::BSSMAP__IE__MobileIdentity_template(const OPTIONAL<BSSMAP__IE__MobileIdentity>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__MobileIdentity&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity from an unbound optional field.");
}
}

BSSMAP__IE__MobileIdentity_template::BSSMAP__IE__MobileIdentity_template(BSSMAP__IE__MobileIdentity_template* p_precondition, BSSMAP__IE__MobileIdentity_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__MobileIdentity_template::BSSMAP__IE__MobileIdentity_template(Dynamic_Match_Interface<BSSMAP__IE__MobileIdentity>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__MobileIdentity>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__MobileIdentity_template::BSSMAP__IE__MobileIdentity_template(const BSSMAP__IE__MobileIdentity_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__MobileIdentity_template::~BSSMAP__IE__MobileIdentity_template()
{
clean_up();
}

BSSMAP__IE__MobileIdentity_template& BSSMAP__IE__MobileIdentity_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__MobileIdentity_template& BSSMAP__IE__MobileIdentity_template::operator=(const BSSMAP__IE__MobileIdentity& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__MobileIdentity_template& BSSMAP__IE__MobileIdentity_template::operator=(const OPTIONAL<BSSMAP__IE__MobileIdentity>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__MobileIdentity&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity.");
}
return *this;
}

BSSMAP__IE__MobileIdentity_template& BSSMAP__IE__MobileIdentity_template::operator=(const BSSMAP__IE__MobileIdentity_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__MobileIdentity_template::match(const BSSMAP__IE__MobileIdentity& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.typeOfIdentity().is_bound()) return FALSE;
if(!single_value->field_typeOfIdentity.match(other_value.typeOfIdentity(), legacy))return FALSE;
if(!other_value.oddEvenIndicator().is_bound()) return FALSE;
if(!single_value->field_oddEvenIndicator.match(other_value.oddEvenIndicator(), legacy))return FALSE;
if(!other_value.digits().is_bound()) return FALSE;
if(!single_value->field_digits.match(other_value.digits(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity.");
}
return FALSE;
}

boolean BSSMAP__IE__MobileIdentity_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_typeOfIdentity.is_bound()
 || single_value->field_oddEvenIndicator.is_bound()
 || single_value->field_digits.is_bound();
}

boolean BSSMAP__IE__MobileIdentity_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_typeOfIdentity.is_value()
 && single_value->field_oddEvenIndicator.is_value()
 && single_value->field_digits.is_value();
}

void BSSMAP__IE__MobileIdentity_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__MobileIdentity BSSMAP__IE__MobileIdentity_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity.");
BSSMAP__IE__MobileIdentity ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_typeOfIdentity.is_bound()) {
ret_val.typeOfIdentity() = single_value->field_typeOfIdentity.valueof();
}
if (single_value->field_oddEvenIndicator.is_bound()) {
ret_val.oddEvenIndicator() = single_value->field_oddEvenIndicator.valueof();
}
if (single_value->field_digits.is_bound()) {
ret_val.digits() = single_value->field_digits.valueof();
}
return ret_val;
}

void BSSMAP__IE__MobileIdentity_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__MobileIdentity_template[list_length];
}

BSSMAP__IE__MobileIdentity_template& BSSMAP__IE__MobileIdentity_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__MobileIdentity_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__MobileIdentity_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__MobileIdentity_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__MobileIdentity_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& BSSMAP__IE__MobileIdentity_template::typeOfIdentity()
{
set_specific();
return single_value->field_typeOfIdentity;
}

const BITSTRING_template& BSSMAP__IE__MobileIdentity_template::typeOfIdentity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field typeOfIdentity of a non-specific template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity.");
return single_value->field_typeOfIdentity;
}

BITSTRING_template& BSSMAP__IE__MobileIdentity_template::oddEvenIndicator()
{
set_specific();
return single_value->field_oddEvenIndicator;
}

const BITSTRING_template& BSSMAP__IE__MobileIdentity_template::oddEvenIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field oddEvenIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity.");
return single_value->field_oddEvenIndicator;
}

HEXSTRING_template& BSSMAP__IE__MobileIdentity_template::digits()
{
set_specific();
return single_value->field_digits;
}

const HEXSTRING_template& BSSMAP__IE__MobileIdentity_template::digits() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field digits of a non-specific template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity.");
return single_value->field_digits;
}

int BSSMAP__IE__MobileIdentity_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity.");
  }
  return 0;
}

void BSSMAP__IE__MobileIdentity_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", typeOfIdentity := ");
single_value->field_typeOfIdentity.log();
TTCN_Logger::log_event_str(", oddEvenIndicator := ");
single_value->field_oddEvenIndicator.log();
TTCN_Logger::log_event_str(", digits := ");
single_value->field_digits.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__MobileIdentity_template::log_match(const BSSMAP__IE__MobileIdentity& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_typeOfIdentity.match(match_value.typeOfIdentity(), legacy)){
TTCN_Logger::log_logmatch_info(".typeOfIdentity");
single_value->field_typeOfIdentity.log_match(match_value.typeOfIdentity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_oddEvenIndicator.match(match_value.oddEvenIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".oddEvenIndicator");
single_value->field_oddEvenIndicator.log_match(match_value.oddEvenIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_digits.match(match_value.digits(), legacy)){
TTCN_Logger::log_logmatch_info(".digits");
single_value->field_digits.log_match(match_value.digits(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", typeOfIdentity := ");
single_value->field_typeOfIdentity.log_match(match_value.typeOfIdentity(), legacy);
TTCN_Logger::log_event_str(", oddEvenIndicator := ");
single_value->field_oddEvenIndicator.log_match(match_value.oddEvenIndicator(), legacy);
TTCN_Logger::log_event_str(", digits := ");
single_value->field_digits.log_match(match_value.digits(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__MobileIdentity_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (typeOfIdentity().is_bound()) typeOfIdentity().set_implicit_omit();
if (oddEvenIndicator().is_bound()) oddEvenIndicator().set_implicit_omit();
if (digits().is_bound()) digits().set_implicit_omit();
}

void BSSMAP__IE__MobileIdentity_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_typeOfIdentity.encode_text(text_buf);
single_value->field_oddEvenIndicator.encode_text(text_buf);
single_value->field_digits.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity.");
}
}

void BSSMAP__IE__MobileIdentity_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_typeOfIdentity.decode_text(text_buf);
single_value->field_oddEvenIndicator.decode_text(text_buf);
single_value->field_digits.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__MobileIdentity_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity.");
}
}

void BSSMAP__IE__MobileIdentity_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__MobileIdentity_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_MobileIdentity has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) typeOfIdentity().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) oddEvenIndicator().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) digits().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "typeOfIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          typeOfIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "oddEvenIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          oddEvenIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "digits")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          digits().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_MobileIdentity: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__MobileIdentity_template* precondition = new BSSMAP__IE__MobileIdentity_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__MobileIdentity_template* implied_template = new BSSMAP__IE__MobileIdentity_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__MobileIdentity_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_MobileIdentity");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__MobileIdentity_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_MobileIdentity");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_MobileIdentity");
single_value->field_typeOfIdentity.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_MobileIdentity");
single_value->field_oddEvenIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_MobileIdentity");
single_value->field_digits.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_MobileIdentity");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_MobileIdentity");
}

boolean BSSMAP__IE__MobileIdentity_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__MobileIdentity_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__OMCId::BSSMAP__IE__OMCId()
{
}

BSSMAP__IE__OMCId::BSSMAP__IE__OMCId(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const BITSTRING& par_numberingPlanind,
    const BITSTRING& par_natureOfAddress,
    const BITSTRING& par_ext,
    const OCTETSTRING& par_digits)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_numberingPlanind(par_numberingPlanind),
  field_natureOfAddress(par_natureOfAddress),
  field_ext(par_ext),
  field_digits(par_digits)
{
}

BSSMAP__IE__OMCId::BSSMAP__IE__OMCId(const BSSMAP__IE__OMCId& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_OMCId.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.numberingPlanind().is_bound()) field_numberingPlanind = other_value.numberingPlanind();
else field_numberingPlanind.clean_up();
if (other_value.natureOfAddress().is_bound()) field_natureOfAddress = other_value.natureOfAddress();
else field_natureOfAddress.clean_up();
if (other_value.ext().is_bound()) field_ext = other_value.ext();
else field_ext.clean_up();
if (other_value.digits().is_bound()) field_digits = other_value.digits();
else field_digits.clean_up();
}

void BSSMAP__IE__OMCId::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_numberingPlanind.clean_up();
field_natureOfAddress.clean_up();
field_ext.clean_up();
field_digits.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__OMCId::get_descriptor() const { return &BSSMAP__IE__OMCId_descr_; }
BSSMAP__IE__OMCId& BSSMAP__IE__OMCId::operator=(const BSSMAP__IE__OMCId& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_OMCId.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.numberingPlanind().is_bound()) field_numberingPlanind = other_value.numberingPlanind();
  else field_numberingPlanind.clean_up();
  if (other_value.natureOfAddress().is_bound()) field_natureOfAddress = other_value.natureOfAddress();
  else field_natureOfAddress.clean_up();
  if (other_value.ext().is_bound()) field_ext = other_value.ext();
  else field_ext.clean_up();
  if (other_value.digits().is_bound()) field_digits = other_value.digits();
  else field_digits.clean_up();
}
return *this;
}

boolean BSSMAP__IE__OMCId::operator==(const BSSMAP__IE__OMCId& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_numberingPlanind==other_value.field_numberingPlanind
  && field_natureOfAddress==other_value.field_natureOfAddress
  && field_ext==other_value.field_ext
  && field_digits==other_value.field_digits;
}

boolean BSSMAP__IE__OMCId::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_numberingPlanind.is_bound())
  || (field_natureOfAddress.is_bound())
  || (field_ext.is_bound())
  || (field_digits.is_bound());
}
boolean BSSMAP__IE__OMCId::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_numberingPlanind.is_value()
  && field_natureOfAddress.is_value()
  && field_ext.is_value()
  && field_digits.is_value();
}
void BSSMAP__IE__OMCId::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", numberingPlanind := ");
field_numberingPlanind.log();
TTCN_Logger::log_event_str(", natureOfAddress := ");
field_natureOfAddress.log();
TTCN_Logger::log_event_str(", ext := ");
field_ext.log();
TTCN_Logger::log_event_str(", digits := ");
field_digits.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__OMCId::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (numberingPlanind().is_bound()) numberingPlanind().set_implicit_omit();
if (natureOfAddress().is_bound()) natureOfAddress().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (digits().is_bound()) digits().set_implicit_omit();
}

void BSSMAP__IE__OMCId::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_OMCId has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) numberingPlanind().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) natureOfAddress().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) digits().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "numberingPlanind")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          numberingPlanind().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "natureOfAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          natureOfAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "digits")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          digits().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_OMCId: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_OMCId");
  }
}

void BSSMAP__IE__OMCId::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_numberingPlanind.encode_text(text_buf);
field_natureOfAddress.encode_text(text_buf);
field_ext.encode_text(text_buf);
field_digits.encode_text(text_buf);
}

void BSSMAP__IE__OMCId::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_numberingPlanind.decode_text(text_buf);
field_natureOfAddress.decode_text(text_buf);
field_ext.decode_text(text_buf);
field_digits.decode_text(text_buf);
}

void BSSMAP__IE__OMCId::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__OMCId::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__OMCId::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__OMCId_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__OMCId_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__OMCId_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_numberingPlanind.RAW_decode(General__Types::BIT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT3_descr_.raw->forceomit);
  decoded_field_length = field_natureOfAddress.RAW_decode(General__Types::BIT3_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_ext.RAW_decode(General__Types::BIT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_5_force_omit(5, force_omit, General__Types::OCTN_descr_.raw->forceomit);
  decoded_field_length = field_digits.RAW_decode(General__Types::OCTN_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_43) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__OMCId::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 6;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(6);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__OMCId_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT3_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, General__Types::OCTN_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__OMCId_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 4;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(4);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  encoded_length += field_numberingPlanind.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_natureOfAddress.RAW_encode(General__Types::BIT3_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_ext.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_digits.RAW_encode(General__Types::OCTN_descr_, *myleaf.body.node.nodes[5]);
  if (field_elementIdentifier !=  os_43) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_43.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__OMCId_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
BITSTRING_template field_numberingPlanind;
BITSTRING_template field_natureOfAddress;
BITSTRING_template field_ext;
OCTETSTRING_template field_digits;
};

void BSSMAP__IE__OMCId_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_numberingPlanind = ANY_VALUE;
single_value->field_natureOfAddress = ANY_VALUE;
single_value->field_ext = ANY_VALUE;
single_value->field_digits = ANY_VALUE;
}
}
}

void BSSMAP__IE__OMCId_template::copy_value(const BSSMAP__IE__OMCId& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.numberingPlanind().is_bound()) {
  single_value->field_numberingPlanind = other_value.numberingPlanind();
} else {
  single_value->field_numberingPlanind.clean_up();
}
if (other_value.natureOfAddress().is_bound()) {
  single_value->field_natureOfAddress = other_value.natureOfAddress();
} else {
  single_value->field_natureOfAddress.clean_up();
}
if (other_value.ext().is_bound()) {
  single_value->field_ext = other_value.ext();
} else {
  single_value->field_ext.clean_up();
}
if (other_value.digits().is_bound()) {
  single_value->field_digits = other_value.digits();
} else {
  single_value->field_digits.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__OMCId_template::copy_template(const BSSMAP__IE__OMCId_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.numberingPlanind().get_selection()) {
single_value->field_numberingPlanind = other_value.numberingPlanind();
} else {
single_value->field_numberingPlanind.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.natureOfAddress().get_selection()) {
single_value->field_natureOfAddress = other_value.natureOfAddress();
} else {
single_value->field_natureOfAddress.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ext().get_selection()) {
single_value->field_ext = other_value.ext();
} else {
single_value->field_ext.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.digits().get_selection()) {
single_value->field_digits = other_value.digits();
} else {
single_value->field_digits.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__OMCId_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__OMCId_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__OMCId_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_OMCId.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__OMCId_template::BSSMAP__IE__OMCId_template()
{
}

BSSMAP__IE__OMCId_template::BSSMAP__IE__OMCId_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__OMCId_template::BSSMAP__IE__OMCId_template(const BSSMAP__IE__OMCId& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__OMCId_template::BSSMAP__IE__OMCId_template(const OPTIONAL<BSSMAP__IE__OMCId>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__OMCId&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_OMCId from an unbound optional field.");
}
}

BSSMAP__IE__OMCId_template::BSSMAP__IE__OMCId_template(BSSMAP__IE__OMCId_template* p_precondition, BSSMAP__IE__OMCId_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__OMCId_template::BSSMAP__IE__OMCId_template(Dynamic_Match_Interface<BSSMAP__IE__OMCId>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__OMCId>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__OMCId_template::BSSMAP__IE__OMCId_template(const BSSMAP__IE__OMCId_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__OMCId_template::~BSSMAP__IE__OMCId_template()
{
clean_up();
}

BSSMAP__IE__OMCId_template& BSSMAP__IE__OMCId_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__OMCId_template& BSSMAP__IE__OMCId_template::operator=(const BSSMAP__IE__OMCId& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__OMCId_template& BSSMAP__IE__OMCId_template::operator=(const OPTIONAL<BSSMAP__IE__OMCId>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__OMCId&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_OMCId.");
}
return *this;
}

BSSMAP__IE__OMCId_template& BSSMAP__IE__OMCId_template::operator=(const BSSMAP__IE__OMCId_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__OMCId_template::match(const BSSMAP__IE__OMCId& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.numberingPlanind().is_bound()) return FALSE;
if(!single_value->field_numberingPlanind.match(other_value.numberingPlanind(), legacy))return FALSE;
if(!other_value.natureOfAddress().is_bound()) return FALSE;
if(!single_value->field_natureOfAddress.match(other_value.natureOfAddress(), legacy))return FALSE;
if(!other_value.ext().is_bound()) return FALSE;
if(!single_value->field_ext.match(other_value.ext(), legacy))return FALSE;
if(!other_value.digits().is_bound()) return FALSE;
if(!single_value->field_digits.match(other_value.digits(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_OMCId.");
}
return FALSE;
}

boolean BSSMAP__IE__OMCId_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_numberingPlanind.is_bound()
 || single_value->field_natureOfAddress.is_bound()
 || single_value->field_ext.is_bound()
 || single_value->field_digits.is_bound();
}

boolean BSSMAP__IE__OMCId_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_numberingPlanind.is_value()
 && single_value->field_natureOfAddress.is_value()
 && single_value->field_ext.is_value()
 && single_value->field_digits.is_value();
}

void BSSMAP__IE__OMCId_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__OMCId BSSMAP__IE__OMCId_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_OMCId.");
BSSMAP__IE__OMCId ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_numberingPlanind.is_bound()) {
ret_val.numberingPlanind() = single_value->field_numberingPlanind.valueof();
}
if (single_value->field_natureOfAddress.is_bound()) {
ret_val.natureOfAddress() = single_value->field_natureOfAddress.valueof();
}
if (single_value->field_ext.is_bound()) {
ret_val.ext() = single_value->field_ext.valueof();
}
if (single_value->field_digits.is_bound()) {
ret_val.digits() = single_value->field_digits.valueof();
}
return ret_val;
}

void BSSMAP__IE__OMCId_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_OMCId.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__OMCId_template[list_length];
}

BSSMAP__IE__OMCId_template& BSSMAP__IE__OMCId_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_OMCId.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_OMCId.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__OMCId_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__OMCId_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_OMCId.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__OMCId_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__OMCId_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_OMCId.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& BSSMAP__IE__OMCId_template::numberingPlanind()
{
set_specific();
return single_value->field_numberingPlanind;
}

const BITSTRING_template& BSSMAP__IE__OMCId_template::numberingPlanind() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field numberingPlanind of a non-specific template of type @BSSAP_Types.BSSMAP_IE_OMCId.");
return single_value->field_numberingPlanind;
}

BITSTRING_template& BSSMAP__IE__OMCId_template::natureOfAddress()
{
set_specific();
return single_value->field_natureOfAddress;
}

const BITSTRING_template& BSSMAP__IE__OMCId_template::natureOfAddress() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field natureOfAddress of a non-specific template of type @BSSAP_Types.BSSMAP_IE_OMCId.");
return single_value->field_natureOfAddress;
}

BITSTRING_template& BSSMAP__IE__OMCId_template::ext()
{
set_specific();
return single_value->field_ext;
}

const BITSTRING_template& BSSMAP__IE__OMCId_template::ext() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ext of a non-specific template of type @BSSAP_Types.BSSMAP_IE_OMCId.");
return single_value->field_ext;
}

OCTETSTRING_template& BSSMAP__IE__OMCId_template::digits()
{
set_specific();
return single_value->field_digits;
}

const OCTETSTRING_template& BSSMAP__IE__OMCId_template::digits() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field digits of a non-specific template of type @BSSAP_Types.BSSMAP_IE_OMCId.");
return single_value->field_digits;
}

int BSSMAP__IE__OMCId_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_OMCId which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 6;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_OMCId containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_OMCId containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_OMCId containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_OMCId containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_OMCId containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_OMCId containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_OMCId containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_OMCId containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_OMCId.");
  }
  return 0;
}

void BSSMAP__IE__OMCId_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", numberingPlanind := ");
single_value->field_numberingPlanind.log();
TTCN_Logger::log_event_str(", natureOfAddress := ");
single_value->field_natureOfAddress.log();
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log();
TTCN_Logger::log_event_str(", digits := ");
single_value->field_digits.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__OMCId_template::log_match(const BSSMAP__IE__OMCId& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_numberingPlanind.match(match_value.numberingPlanind(), legacy)){
TTCN_Logger::log_logmatch_info(".numberingPlanind");
single_value->field_numberingPlanind.log_match(match_value.numberingPlanind(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_natureOfAddress.match(match_value.natureOfAddress(), legacy)){
TTCN_Logger::log_logmatch_info(".natureOfAddress");
single_value->field_natureOfAddress.log_match(match_value.natureOfAddress(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ext.match(match_value.ext(), legacy)){
TTCN_Logger::log_logmatch_info(".ext");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_digits.match(match_value.digits(), legacy)){
TTCN_Logger::log_logmatch_info(".digits");
single_value->field_digits.log_match(match_value.digits(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", numberingPlanind := ");
single_value->field_numberingPlanind.log_match(match_value.numberingPlanind(), legacy);
TTCN_Logger::log_event_str(", natureOfAddress := ");
single_value->field_natureOfAddress.log_match(match_value.natureOfAddress(), legacy);
TTCN_Logger::log_event_str(", ext := ");
single_value->field_ext.log_match(match_value.ext(), legacy);
TTCN_Logger::log_event_str(", digits := ");
single_value->field_digits.log_match(match_value.digits(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__OMCId_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (numberingPlanind().is_bound()) numberingPlanind().set_implicit_omit();
if (natureOfAddress().is_bound()) natureOfAddress().set_implicit_omit();
if (ext().is_bound()) ext().set_implicit_omit();
if (digits().is_bound()) digits().set_implicit_omit();
}

void BSSMAP__IE__OMCId_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_numberingPlanind.encode_text(text_buf);
single_value->field_natureOfAddress.encode_text(text_buf);
single_value->field_ext.encode_text(text_buf);
single_value->field_digits.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_OMCId.");
}
}

void BSSMAP__IE__OMCId_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_numberingPlanind.decode_text(text_buf);
single_value->field_natureOfAddress.decode_text(text_buf);
single_value->field_ext.decode_text(text_buf);
single_value->field_digits.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__OMCId_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_OMCId.");
}
}

void BSSMAP__IE__OMCId_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__OMCId_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_OMCId has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) numberingPlanind().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) natureOfAddress().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) ext().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) digits().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "numberingPlanind")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          numberingPlanind().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "natureOfAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          natureOfAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ext")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ext().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "digits")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          digits().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_OMCId: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__OMCId_template* precondition = new BSSMAP__IE__OMCId_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__OMCId_template* implied_template = new BSSMAP__IE__OMCId_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__OMCId_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_OMCId");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__OMCId_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_OMCId");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_OMCId");
single_value->field_numberingPlanind.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_OMCId");
single_value->field_natureOfAddress.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_OMCId");
single_value->field_ext.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_OMCId");
single_value->field_digits.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_OMCId");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_OMCId");
}

boolean BSSMAP__IE__OMCId_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__OMCId_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__ForwardIndicator::BSSMAP__IE__ForwardIndicator()
{
}

BSSMAP__IE__ForwardIndicator::BSSMAP__IE__ForwardIndicator(const OCTETSTRING& par_elementIdentifier,
    const BITSTRING& par_forwardIndicator,
    const BITSTRING& par_spare)
  :   field_elementIdentifier(par_elementIdentifier),
  field_forwardIndicator(par_forwardIndicator),
  field_spare(par_spare)
{
}

BSSMAP__IE__ForwardIndicator::BSSMAP__IE__ForwardIndicator(const BSSMAP__IE__ForwardIndicator& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.forwardIndicator().is_bound()) field_forwardIndicator = other_value.forwardIndicator();
else field_forwardIndicator.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void BSSMAP__IE__ForwardIndicator::clean_up()
{
field_elementIdentifier.clean_up();
field_forwardIndicator.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__ForwardIndicator::get_descriptor() const { return &BSSMAP__IE__ForwardIndicator_descr_; }
BSSMAP__IE__ForwardIndicator& BSSMAP__IE__ForwardIndicator::operator=(const BSSMAP__IE__ForwardIndicator& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.forwardIndicator().is_bound()) field_forwardIndicator = other_value.forwardIndicator();
  else field_forwardIndicator.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean BSSMAP__IE__ForwardIndicator::operator==(const BSSMAP__IE__ForwardIndicator& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_forwardIndicator==other_value.field_forwardIndicator
  && field_spare==other_value.field_spare;
}

boolean BSSMAP__IE__ForwardIndicator::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_forwardIndicator.is_bound())
  || (field_spare.is_bound());
}
boolean BSSMAP__IE__ForwardIndicator::is_value() const
{
return field_elementIdentifier.is_value()
  && field_forwardIndicator.is_value()
  && field_spare.is_value();
}
void BSSMAP__IE__ForwardIndicator::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", forwardIndicator := ");
field_forwardIndicator.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__ForwardIndicator::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (forwardIndicator().is_bound()) forwardIndicator().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void BSSMAP__IE__ForwardIndicator::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) forwardIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "forwardIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          forwardIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_ForwardIndicator: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_ForwardIndicator");
  }
}

void BSSMAP__IE__ForwardIndicator::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_forwardIndicator.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void BSSMAP__IE__ForwardIndicator::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_forwardIndicator.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void BSSMAP__IE__ForwardIndicator::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__ForwardIndicator::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__ForwardIndicator::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_forwardIndicator.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_elementIdentifier !=  os_39) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__ForwardIndicator::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT4_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_forwardIndicator.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier !=  os_39) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_39.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__ForwardIndicator_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
BITSTRING_template field_forwardIndicator;
BITSTRING_template field_spare;
};

void BSSMAP__IE__ForwardIndicator_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_forwardIndicator = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void BSSMAP__IE__ForwardIndicator_template::copy_value(const BSSMAP__IE__ForwardIndicator& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.forwardIndicator().is_bound()) {
  single_value->field_forwardIndicator = other_value.forwardIndicator();
} else {
  single_value->field_forwardIndicator.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__ForwardIndicator_template::copy_template(const BSSMAP__IE__ForwardIndicator_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.forwardIndicator().get_selection()) {
single_value->field_forwardIndicator = other_value.forwardIndicator();
} else {
single_value->field_forwardIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__ForwardIndicator_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__ForwardIndicator_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__ForwardIndicator_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__ForwardIndicator_template::BSSMAP__IE__ForwardIndicator_template()
{
}

BSSMAP__IE__ForwardIndicator_template::BSSMAP__IE__ForwardIndicator_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__ForwardIndicator_template::BSSMAP__IE__ForwardIndicator_template(const BSSMAP__IE__ForwardIndicator& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__ForwardIndicator_template::BSSMAP__IE__ForwardIndicator_template(const OPTIONAL<BSSMAP__IE__ForwardIndicator>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__ForwardIndicator&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator from an unbound optional field.");
}
}

BSSMAP__IE__ForwardIndicator_template::BSSMAP__IE__ForwardIndicator_template(BSSMAP__IE__ForwardIndicator_template* p_precondition, BSSMAP__IE__ForwardIndicator_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__ForwardIndicator_template::BSSMAP__IE__ForwardIndicator_template(Dynamic_Match_Interface<BSSMAP__IE__ForwardIndicator>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__ForwardIndicator>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__ForwardIndicator_template::BSSMAP__IE__ForwardIndicator_template(const BSSMAP__IE__ForwardIndicator_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__ForwardIndicator_template::~BSSMAP__IE__ForwardIndicator_template()
{
clean_up();
}

BSSMAP__IE__ForwardIndicator_template& BSSMAP__IE__ForwardIndicator_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__ForwardIndicator_template& BSSMAP__IE__ForwardIndicator_template::operator=(const BSSMAP__IE__ForwardIndicator& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__ForwardIndicator_template& BSSMAP__IE__ForwardIndicator_template::operator=(const OPTIONAL<BSSMAP__IE__ForwardIndicator>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__ForwardIndicator&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator.");
}
return *this;
}

BSSMAP__IE__ForwardIndicator_template& BSSMAP__IE__ForwardIndicator_template::operator=(const BSSMAP__IE__ForwardIndicator_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__ForwardIndicator_template::match(const BSSMAP__IE__ForwardIndicator& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.forwardIndicator().is_bound()) return FALSE;
if(!single_value->field_forwardIndicator.match(other_value.forwardIndicator(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator.");
}
return FALSE;
}

boolean BSSMAP__IE__ForwardIndicator_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_forwardIndicator.is_bound()
 || single_value->field_spare.is_bound();
}

boolean BSSMAP__IE__ForwardIndicator_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_forwardIndicator.is_value()
 && single_value->field_spare.is_value();
}

void BSSMAP__IE__ForwardIndicator_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__ForwardIndicator BSSMAP__IE__ForwardIndicator_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator.");
BSSMAP__IE__ForwardIndicator ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_forwardIndicator.is_bound()) {
ret_val.forwardIndicator() = single_value->field_forwardIndicator.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void BSSMAP__IE__ForwardIndicator_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__ForwardIndicator_template[list_length];
}

BSSMAP__IE__ForwardIndicator_template& BSSMAP__IE__ForwardIndicator_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__ForwardIndicator_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__ForwardIndicator_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator.");
return single_value->field_elementIdentifier;
}

BITSTRING_template& BSSMAP__IE__ForwardIndicator_template::forwardIndicator()
{
set_specific();
return single_value->field_forwardIndicator;
}

const BITSTRING_template& BSSMAP__IE__ForwardIndicator_template::forwardIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field forwardIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator.");
return single_value->field_forwardIndicator;
}

BITSTRING_template& BSSMAP__IE__ForwardIndicator_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& BSSMAP__IE__ForwardIndicator_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator.");
return single_value->field_spare;
}

int BSSMAP__IE__ForwardIndicator_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator.");
  }
  return 0;
}

void BSSMAP__IE__ForwardIndicator_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", forwardIndicator := ");
single_value->field_forwardIndicator.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__ForwardIndicator_template::log_match(const BSSMAP__IE__ForwardIndicator& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_forwardIndicator.match(match_value.forwardIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".forwardIndicator");
single_value->field_forwardIndicator.log_match(match_value.forwardIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", forwardIndicator := ");
single_value->field_forwardIndicator.log_match(match_value.forwardIndicator(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__ForwardIndicator_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (forwardIndicator().is_bound()) forwardIndicator().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void BSSMAP__IE__ForwardIndicator_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_forwardIndicator.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator.");
}
}

void BSSMAP__IE__ForwardIndicator_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_forwardIndicator.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__ForwardIndicator_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator.");
}
}

void BSSMAP__IE__ForwardIndicator_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__ForwardIndicator_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_ForwardIndicator has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) forwardIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "forwardIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          forwardIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_ForwardIndicator: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__ForwardIndicator_template* precondition = new BSSMAP__IE__ForwardIndicator_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__ForwardIndicator_template* implied_template = new BSSMAP__IE__ForwardIndicator_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__ForwardIndicator_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_ForwardIndicator");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__ForwardIndicator_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ForwardIndicator");
single_value->field_forwardIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ForwardIndicator");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ForwardIndicator");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ForwardIndicator");
}

boolean BSSMAP__IE__ForwardIndicator_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__ForwardIndicator_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__ChosenEncryptionAlgorithm::BSSMAP__IE__ChosenEncryptionAlgorithm()
{
}

BSSMAP__IE__ChosenEncryptionAlgorithm::BSSMAP__IE__ChosenEncryptionAlgorithm(const OCTETSTRING& par_elementIdentifier,
    const OCTETSTRING& par_algorithmIdentifier)
  :   field_elementIdentifier(par_elementIdentifier),
  field_algorithmIdentifier(par_algorithmIdentifier)
{
}

BSSMAP__IE__ChosenEncryptionAlgorithm::BSSMAP__IE__ChosenEncryptionAlgorithm(const BSSMAP__IE__ChosenEncryptionAlgorithm& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.algorithmIdentifier().is_bound()) field_algorithmIdentifier = other_value.algorithmIdentifier();
else field_algorithmIdentifier.clean_up();
}

void BSSMAP__IE__ChosenEncryptionAlgorithm::clean_up()
{
field_elementIdentifier.clean_up();
field_algorithmIdentifier.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__ChosenEncryptionAlgorithm::get_descriptor() const { return &BSSMAP__IE__ChosenEncryptionAlgorithm_descr_; }
BSSMAP__IE__ChosenEncryptionAlgorithm& BSSMAP__IE__ChosenEncryptionAlgorithm::operator=(const BSSMAP__IE__ChosenEncryptionAlgorithm& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.algorithmIdentifier().is_bound()) field_algorithmIdentifier = other_value.algorithmIdentifier();
  else field_algorithmIdentifier.clean_up();
}
return *this;
}

boolean BSSMAP__IE__ChosenEncryptionAlgorithm::operator==(const BSSMAP__IE__ChosenEncryptionAlgorithm& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_algorithmIdentifier==other_value.field_algorithmIdentifier;
}

boolean BSSMAP__IE__ChosenEncryptionAlgorithm::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_algorithmIdentifier.is_bound());
}
boolean BSSMAP__IE__ChosenEncryptionAlgorithm::is_value() const
{
return field_elementIdentifier.is_value()
  && field_algorithmIdentifier.is_value();
}
void BSSMAP__IE__ChosenEncryptionAlgorithm::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", algorithmIdentifier := ");
field_algorithmIdentifier.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__ChosenEncryptionAlgorithm::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (algorithmIdentifier().is_bound()) algorithmIdentifier().set_implicit_omit();
}

void BSSMAP__IE__ChosenEncryptionAlgorithm::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) algorithmIdentifier().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "algorithmIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          algorithmIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm");
  }
}

void BSSMAP__IE__ChosenEncryptionAlgorithm::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_algorithmIdentifier.encode_text(text_buf);
}

void BSSMAP__IE__ChosenEncryptionAlgorithm::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_algorithmIdentifier.decode_text(text_buf);
}

void BSSMAP__IE__ChosenEncryptionAlgorithm::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__ChosenEncryptionAlgorithm::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__ChosenEncryptionAlgorithm::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_algorithmIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_elementIdentifier !=  os_26) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__ChosenEncryptionAlgorithm::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::OCT1_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_algorithmIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[1]);
  if (field_elementIdentifier !=  os_26) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_26.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__ChosenEncryptionAlgorithm_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
OCTETSTRING_template field_algorithmIdentifier;
};

void BSSMAP__IE__ChosenEncryptionAlgorithm_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_algorithmIdentifier = ANY_VALUE;
}
}
}

void BSSMAP__IE__ChosenEncryptionAlgorithm_template::copy_value(const BSSMAP__IE__ChosenEncryptionAlgorithm& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.algorithmIdentifier().is_bound()) {
  single_value->field_algorithmIdentifier = other_value.algorithmIdentifier();
} else {
  single_value->field_algorithmIdentifier.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__ChosenEncryptionAlgorithm_template::copy_template(const BSSMAP__IE__ChosenEncryptionAlgorithm_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.algorithmIdentifier().get_selection()) {
single_value->field_algorithmIdentifier = other_value.algorithmIdentifier();
} else {
single_value->field_algorithmIdentifier.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__ChosenEncryptionAlgorithm_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__ChosenEncryptionAlgorithm_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__ChosenEncryptionAlgorithm_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__ChosenEncryptionAlgorithm_template::BSSMAP__IE__ChosenEncryptionAlgorithm_template()
{
}

BSSMAP__IE__ChosenEncryptionAlgorithm_template::BSSMAP__IE__ChosenEncryptionAlgorithm_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__ChosenEncryptionAlgorithm_template::BSSMAP__IE__ChosenEncryptionAlgorithm_template(const BSSMAP__IE__ChosenEncryptionAlgorithm& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__ChosenEncryptionAlgorithm_template::BSSMAP__IE__ChosenEncryptionAlgorithm_template(const OPTIONAL<BSSMAP__IE__ChosenEncryptionAlgorithm>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__ChosenEncryptionAlgorithm&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm from an unbound optional field.");
}
}

BSSMAP__IE__ChosenEncryptionAlgorithm_template::BSSMAP__IE__ChosenEncryptionAlgorithm_template(BSSMAP__IE__ChosenEncryptionAlgorithm_template* p_precondition, BSSMAP__IE__ChosenEncryptionAlgorithm_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__ChosenEncryptionAlgorithm_template::BSSMAP__IE__ChosenEncryptionAlgorithm_template(Dynamic_Match_Interface<BSSMAP__IE__ChosenEncryptionAlgorithm>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__ChosenEncryptionAlgorithm>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__ChosenEncryptionAlgorithm_template::BSSMAP__IE__ChosenEncryptionAlgorithm_template(const BSSMAP__IE__ChosenEncryptionAlgorithm_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__ChosenEncryptionAlgorithm_template::~BSSMAP__IE__ChosenEncryptionAlgorithm_template()
{
clean_up();
}

BSSMAP__IE__ChosenEncryptionAlgorithm_template& BSSMAP__IE__ChosenEncryptionAlgorithm_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__ChosenEncryptionAlgorithm_template& BSSMAP__IE__ChosenEncryptionAlgorithm_template::operator=(const BSSMAP__IE__ChosenEncryptionAlgorithm& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__ChosenEncryptionAlgorithm_template& BSSMAP__IE__ChosenEncryptionAlgorithm_template::operator=(const OPTIONAL<BSSMAP__IE__ChosenEncryptionAlgorithm>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__ChosenEncryptionAlgorithm&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm.");
}
return *this;
}

BSSMAP__IE__ChosenEncryptionAlgorithm_template& BSSMAP__IE__ChosenEncryptionAlgorithm_template::operator=(const BSSMAP__IE__ChosenEncryptionAlgorithm_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__ChosenEncryptionAlgorithm_template::match(const BSSMAP__IE__ChosenEncryptionAlgorithm& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.algorithmIdentifier().is_bound()) return FALSE;
if(!single_value->field_algorithmIdentifier.match(other_value.algorithmIdentifier(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm.");
}
return FALSE;
}

boolean BSSMAP__IE__ChosenEncryptionAlgorithm_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_algorithmIdentifier.is_bound();
}

boolean BSSMAP__IE__ChosenEncryptionAlgorithm_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_algorithmIdentifier.is_value();
}

void BSSMAP__IE__ChosenEncryptionAlgorithm_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__ChosenEncryptionAlgorithm BSSMAP__IE__ChosenEncryptionAlgorithm_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm.");
BSSMAP__IE__ChosenEncryptionAlgorithm ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_algorithmIdentifier.is_bound()) {
ret_val.algorithmIdentifier() = single_value->field_algorithmIdentifier.valueof();
}
return ret_val;
}

void BSSMAP__IE__ChosenEncryptionAlgorithm_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__ChosenEncryptionAlgorithm_template[list_length];
}

BSSMAP__IE__ChosenEncryptionAlgorithm_template& BSSMAP__IE__ChosenEncryptionAlgorithm_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__ChosenEncryptionAlgorithm_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__ChosenEncryptionAlgorithm_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm.");
return single_value->field_elementIdentifier;
}

OCTETSTRING_template& BSSMAP__IE__ChosenEncryptionAlgorithm_template::algorithmIdentifier()
{
set_specific();
return single_value->field_algorithmIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__ChosenEncryptionAlgorithm_template::algorithmIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field algorithmIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm.");
return single_value->field_algorithmIdentifier;
}

int BSSMAP__IE__ChosenEncryptionAlgorithm_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm.");
  }
  return 0;
}

void BSSMAP__IE__ChosenEncryptionAlgorithm_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", algorithmIdentifier := ");
single_value->field_algorithmIdentifier.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__ChosenEncryptionAlgorithm_template::log_match(const BSSMAP__IE__ChosenEncryptionAlgorithm& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_algorithmIdentifier.match(match_value.algorithmIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".algorithmIdentifier");
single_value->field_algorithmIdentifier.log_match(match_value.algorithmIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", algorithmIdentifier := ");
single_value->field_algorithmIdentifier.log_match(match_value.algorithmIdentifier(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__ChosenEncryptionAlgorithm_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (algorithmIdentifier().is_bound()) algorithmIdentifier().set_implicit_omit();
}

void BSSMAP__IE__ChosenEncryptionAlgorithm_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_algorithmIdentifier.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm.");
}
}

void BSSMAP__IE__ChosenEncryptionAlgorithm_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_algorithmIdentifier.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__ChosenEncryptionAlgorithm_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm.");
}
}

void BSSMAP__IE__ChosenEncryptionAlgorithm_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__ChosenEncryptionAlgorithm_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) algorithmIdentifier().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "algorithmIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          algorithmIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__ChosenEncryptionAlgorithm_template* precondition = new BSSMAP__IE__ChosenEncryptionAlgorithm_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__ChosenEncryptionAlgorithm_template* implied_template = new BSSMAP__IE__ChosenEncryptionAlgorithm_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__ChosenEncryptionAlgorithm_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__ChosenEncryptionAlgorithm_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm");
single_value->field_algorithmIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ChosenEncryptionAlgorithm");
}

boolean BSSMAP__IE__ChosenEncryptionAlgorithm_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__ChosenEncryptionAlgorithm_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__CircuitPool::BSSMAP__IE__CircuitPool()
{
}

BSSMAP__IE__CircuitPool::BSSMAP__IE__CircuitPool(const OCTETSTRING& par_elementIdentifier,
    const OCTETSTRING& par_circuitPoolNumber)
  :   field_elementIdentifier(par_elementIdentifier),
  field_circuitPoolNumber(par_circuitPoolNumber)
{
}

BSSMAP__IE__CircuitPool::BSSMAP__IE__CircuitPool(const BSSMAP__IE__CircuitPool& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_CircuitPool.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.circuitPoolNumber().is_bound()) field_circuitPoolNumber = other_value.circuitPoolNumber();
else field_circuitPoolNumber.clean_up();
}

void BSSMAP__IE__CircuitPool::clean_up()
{
field_elementIdentifier.clean_up();
field_circuitPoolNumber.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__CircuitPool::get_descriptor() const { return &BSSMAP__IE__CircuitPool_descr_; }
BSSMAP__IE__CircuitPool& BSSMAP__IE__CircuitPool::operator=(const BSSMAP__IE__CircuitPool& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_CircuitPool.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.circuitPoolNumber().is_bound()) field_circuitPoolNumber = other_value.circuitPoolNumber();
  else field_circuitPoolNumber.clean_up();
}
return *this;
}

boolean BSSMAP__IE__CircuitPool::operator==(const BSSMAP__IE__CircuitPool& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_circuitPoolNumber==other_value.field_circuitPoolNumber;
}

boolean BSSMAP__IE__CircuitPool::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_circuitPoolNumber.is_bound());
}
boolean BSSMAP__IE__CircuitPool::is_value() const
{
return field_elementIdentifier.is_value()
  && field_circuitPoolNumber.is_value();
}
void BSSMAP__IE__CircuitPool::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", circuitPoolNumber := ");
field_circuitPoolNumber.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__CircuitPool::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (circuitPoolNumber().is_bound()) circuitPoolNumber().set_implicit_omit();
}

void BSSMAP__IE__CircuitPool::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_CircuitPool has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) circuitPoolNumber().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "circuitPoolNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          circuitPoolNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_CircuitPool: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_CircuitPool");
  }
}

void BSSMAP__IE__CircuitPool::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_circuitPoolNumber.encode_text(text_buf);
}

void BSSMAP__IE__CircuitPool::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_circuitPoolNumber.decode_text(text_buf);
}

void BSSMAP__IE__CircuitPool::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__CircuitPool::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__CircuitPool::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_circuitPoolNumber.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_elementIdentifier !=  os_27) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__CircuitPool::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::OCT1_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_circuitPoolNumber.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[1]);
  if (field_elementIdentifier !=  os_27) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_27.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__CircuitPool_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
OCTETSTRING_template field_circuitPoolNumber;
};

void BSSMAP__IE__CircuitPool_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_circuitPoolNumber = ANY_VALUE;
}
}
}

void BSSMAP__IE__CircuitPool_template::copy_value(const BSSMAP__IE__CircuitPool& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.circuitPoolNumber().is_bound()) {
  single_value->field_circuitPoolNumber = other_value.circuitPoolNumber();
} else {
  single_value->field_circuitPoolNumber.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__CircuitPool_template::copy_template(const BSSMAP__IE__CircuitPool_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.circuitPoolNumber().get_selection()) {
single_value->field_circuitPoolNumber = other_value.circuitPoolNumber();
} else {
single_value->field_circuitPoolNumber.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__CircuitPool_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__CircuitPool_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__CircuitPool_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CircuitPool.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__CircuitPool_template::BSSMAP__IE__CircuitPool_template()
{
}

BSSMAP__IE__CircuitPool_template::BSSMAP__IE__CircuitPool_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__CircuitPool_template::BSSMAP__IE__CircuitPool_template(const BSSMAP__IE__CircuitPool& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__CircuitPool_template::BSSMAP__IE__CircuitPool_template(const OPTIONAL<BSSMAP__IE__CircuitPool>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__CircuitPool&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_CircuitPool from an unbound optional field.");
}
}

BSSMAP__IE__CircuitPool_template::BSSMAP__IE__CircuitPool_template(BSSMAP__IE__CircuitPool_template* p_precondition, BSSMAP__IE__CircuitPool_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__CircuitPool_template::BSSMAP__IE__CircuitPool_template(Dynamic_Match_Interface<BSSMAP__IE__CircuitPool>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__CircuitPool>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__CircuitPool_template::BSSMAP__IE__CircuitPool_template(const BSSMAP__IE__CircuitPool_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__CircuitPool_template::~BSSMAP__IE__CircuitPool_template()
{
clean_up();
}

BSSMAP__IE__CircuitPool_template& BSSMAP__IE__CircuitPool_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__CircuitPool_template& BSSMAP__IE__CircuitPool_template::operator=(const BSSMAP__IE__CircuitPool& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__CircuitPool_template& BSSMAP__IE__CircuitPool_template::operator=(const OPTIONAL<BSSMAP__IE__CircuitPool>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__CircuitPool&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_CircuitPool.");
}
return *this;
}

BSSMAP__IE__CircuitPool_template& BSSMAP__IE__CircuitPool_template::operator=(const BSSMAP__IE__CircuitPool_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__CircuitPool_template::match(const BSSMAP__IE__CircuitPool& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.circuitPoolNumber().is_bound()) return FALSE;
if(!single_value->field_circuitPoolNumber.match(other_value.circuitPoolNumber(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CircuitPool.");
}
return FALSE;
}

boolean BSSMAP__IE__CircuitPool_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_circuitPoolNumber.is_bound();
}

boolean BSSMAP__IE__CircuitPool_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_circuitPoolNumber.is_value();
}

void BSSMAP__IE__CircuitPool_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__CircuitPool BSSMAP__IE__CircuitPool_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_CircuitPool.");
BSSMAP__IE__CircuitPool ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_circuitPoolNumber.is_bound()) {
ret_val.circuitPoolNumber() = single_value->field_circuitPoolNumber.valueof();
}
return ret_val;
}

void BSSMAP__IE__CircuitPool_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_CircuitPool.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__CircuitPool_template[list_length];
}

BSSMAP__IE__CircuitPool_template& BSSMAP__IE__CircuitPool_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_CircuitPool.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_CircuitPool.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__CircuitPool_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__CircuitPool_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CircuitPool.");
return single_value->field_elementIdentifier;
}

OCTETSTRING_template& BSSMAP__IE__CircuitPool_template::circuitPoolNumber()
{
set_specific();
return single_value->field_circuitPoolNumber;
}

const OCTETSTRING_template& BSSMAP__IE__CircuitPool_template::circuitPoolNumber() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field circuitPoolNumber of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CircuitPool.");
return single_value->field_circuitPoolNumber;
}

int BSSMAP__IE__CircuitPool_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitPool which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitPool containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitPool containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitPool containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitPool containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitPool containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitPool containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitPool containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitPool containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CircuitPool.");
  }
  return 0;
}

void BSSMAP__IE__CircuitPool_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", circuitPoolNumber := ");
single_value->field_circuitPoolNumber.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__CircuitPool_template::log_match(const BSSMAP__IE__CircuitPool& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_circuitPoolNumber.match(match_value.circuitPoolNumber(), legacy)){
TTCN_Logger::log_logmatch_info(".circuitPoolNumber");
single_value->field_circuitPoolNumber.log_match(match_value.circuitPoolNumber(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", circuitPoolNumber := ");
single_value->field_circuitPoolNumber.log_match(match_value.circuitPoolNumber(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__CircuitPool_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (circuitPoolNumber().is_bound()) circuitPoolNumber().set_implicit_omit();
}

void BSSMAP__IE__CircuitPool_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_circuitPoolNumber.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CircuitPool.");
}
}

void BSSMAP__IE__CircuitPool_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_circuitPoolNumber.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__CircuitPool_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_CircuitPool.");
}
}

void BSSMAP__IE__CircuitPool_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__CircuitPool_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_CircuitPool has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) circuitPoolNumber().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "circuitPoolNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          circuitPoolNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_CircuitPool: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__CircuitPool_template* precondition = new BSSMAP__IE__CircuitPool_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__CircuitPool_template* implied_template = new BSSMAP__IE__CircuitPool_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__CircuitPool_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_CircuitPool");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__CircuitPool_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CircuitPool");
single_value->field_circuitPoolNumber.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CircuitPool");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CircuitPool");
}

boolean BSSMAP__IE__CircuitPool_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__CircuitPool_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__CircuitPoolList::BSSMAP__IE__CircuitPoolList()
{
}

BSSMAP__IE__CircuitPoolList::BSSMAP__IE__CircuitPoolList(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_circuitPoolNumber)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_circuitPoolNumber(par_circuitPoolNumber)
{
}

BSSMAP__IE__CircuitPoolList::BSSMAP__IE__CircuitPoolList(const BSSMAP__IE__CircuitPoolList& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.circuitPoolNumber().is_bound()) field_circuitPoolNumber = other_value.circuitPoolNumber();
else field_circuitPoolNumber.clean_up();
}

void BSSMAP__IE__CircuitPoolList::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_circuitPoolNumber.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__CircuitPoolList::get_descriptor() const { return &BSSMAP__IE__CircuitPoolList_descr_; }
BSSMAP__IE__CircuitPoolList& BSSMAP__IE__CircuitPoolList::operator=(const BSSMAP__IE__CircuitPoolList& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.circuitPoolNumber().is_bound()) field_circuitPoolNumber = other_value.circuitPoolNumber();
  else field_circuitPoolNumber.clean_up();
}
return *this;
}

boolean BSSMAP__IE__CircuitPoolList::operator==(const BSSMAP__IE__CircuitPoolList& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_circuitPoolNumber==other_value.field_circuitPoolNumber;
}

boolean BSSMAP__IE__CircuitPoolList::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_circuitPoolNumber.is_bound());
}
boolean BSSMAP__IE__CircuitPoolList::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_circuitPoolNumber.is_value();
}
void BSSMAP__IE__CircuitPoolList::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", circuitPoolNumber := ");
field_circuitPoolNumber.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__CircuitPoolList::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (circuitPoolNumber().is_bound()) circuitPoolNumber().set_implicit_omit();
}

void BSSMAP__IE__CircuitPoolList::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) circuitPoolNumber().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "circuitPoolNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          circuitPoolNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_CircuitPoolList: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_CircuitPoolList");
  }
}

void BSSMAP__IE__CircuitPoolList::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_circuitPoolNumber.encode_text(text_buf);
}

void BSSMAP__IE__CircuitPoolList::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_circuitPoolNumber.decode_text(text_buf);
}

void BSSMAP__IE__CircuitPoolList::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__CircuitPoolList::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__CircuitPoolList::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__CircuitPoolList_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__CircuitPoolList_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__CircuitPoolList_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_circuitPoolNumber.RAW_decode(OCTETSTRING_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_34) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__CircuitPoolList::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__CircuitPoolList_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, OCTETSTRING_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__CircuitPoolList_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_circuitPoolNumber.RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier !=  os_34) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_34.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__CircuitPoolList_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_circuitPoolNumber;
};

void BSSMAP__IE__CircuitPoolList_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_circuitPoolNumber = ANY_VALUE;
}
}
}

void BSSMAP__IE__CircuitPoolList_template::copy_value(const BSSMAP__IE__CircuitPoolList& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.circuitPoolNumber().is_bound()) {
  single_value->field_circuitPoolNumber = other_value.circuitPoolNumber();
} else {
  single_value->field_circuitPoolNumber.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__CircuitPoolList_template::copy_template(const BSSMAP__IE__CircuitPoolList_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.circuitPoolNumber().get_selection()) {
single_value->field_circuitPoolNumber = other_value.circuitPoolNumber();
} else {
single_value->field_circuitPoolNumber.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__CircuitPoolList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__CircuitPoolList_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__CircuitPoolList_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__CircuitPoolList_template::BSSMAP__IE__CircuitPoolList_template()
{
}

BSSMAP__IE__CircuitPoolList_template::BSSMAP__IE__CircuitPoolList_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__CircuitPoolList_template::BSSMAP__IE__CircuitPoolList_template(const BSSMAP__IE__CircuitPoolList& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__CircuitPoolList_template::BSSMAP__IE__CircuitPoolList_template(const OPTIONAL<BSSMAP__IE__CircuitPoolList>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__CircuitPoolList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList from an unbound optional field.");
}
}

BSSMAP__IE__CircuitPoolList_template::BSSMAP__IE__CircuitPoolList_template(BSSMAP__IE__CircuitPoolList_template* p_precondition, BSSMAP__IE__CircuitPoolList_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__CircuitPoolList_template::BSSMAP__IE__CircuitPoolList_template(Dynamic_Match_Interface<BSSMAP__IE__CircuitPoolList>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__CircuitPoolList>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__CircuitPoolList_template::BSSMAP__IE__CircuitPoolList_template(const BSSMAP__IE__CircuitPoolList_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__CircuitPoolList_template::~BSSMAP__IE__CircuitPoolList_template()
{
clean_up();
}

BSSMAP__IE__CircuitPoolList_template& BSSMAP__IE__CircuitPoolList_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__CircuitPoolList_template& BSSMAP__IE__CircuitPoolList_template::operator=(const BSSMAP__IE__CircuitPoolList& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__CircuitPoolList_template& BSSMAP__IE__CircuitPoolList_template::operator=(const OPTIONAL<BSSMAP__IE__CircuitPoolList>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__CircuitPoolList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList.");
}
return *this;
}

BSSMAP__IE__CircuitPoolList_template& BSSMAP__IE__CircuitPoolList_template::operator=(const BSSMAP__IE__CircuitPoolList_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__CircuitPoolList_template::match(const BSSMAP__IE__CircuitPoolList& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.circuitPoolNumber().is_bound()) return FALSE;
if(!single_value->field_circuitPoolNumber.match(other_value.circuitPoolNumber(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList.");
}
return FALSE;
}

boolean BSSMAP__IE__CircuitPoolList_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_circuitPoolNumber.is_bound();
}

boolean BSSMAP__IE__CircuitPoolList_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_circuitPoolNumber.is_value();
}

void BSSMAP__IE__CircuitPoolList_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__CircuitPoolList BSSMAP__IE__CircuitPoolList_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList.");
BSSMAP__IE__CircuitPoolList ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_circuitPoolNumber.is_bound()) {
ret_val.circuitPoolNumber() = single_value->field_circuitPoolNumber.valueof();
}
return ret_val;
}

void BSSMAP__IE__CircuitPoolList_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__CircuitPoolList_template[list_length];
}

BSSMAP__IE__CircuitPoolList_template& BSSMAP__IE__CircuitPoolList_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__CircuitPoolList_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__CircuitPoolList_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__CircuitPoolList_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__CircuitPoolList_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& BSSMAP__IE__CircuitPoolList_template::circuitPoolNumber()
{
set_specific();
return single_value->field_circuitPoolNumber;
}

const OCTETSTRING_template& BSSMAP__IE__CircuitPoolList_template::circuitPoolNumber() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field circuitPoolNumber of a non-specific template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList.");
return single_value->field_circuitPoolNumber;
}

int BSSMAP__IE__CircuitPoolList_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList.");
  }
  return 0;
}

void BSSMAP__IE__CircuitPoolList_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", circuitPoolNumber := ");
single_value->field_circuitPoolNumber.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__CircuitPoolList_template::log_match(const BSSMAP__IE__CircuitPoolList& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_circuitPoolNumber.match(match_value.circuitPoolNumber(), legacy)){
TTCN_Logger::log_logmatch_info(".circuitPoolNumber");
single_value->field_circuitPoolNumber.log_match(match_value.circuitPoolNumber(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", circuitPoolNumber := ");
single_value->field_circuitPoolNumber.log_match(match_value.circuitPoolNumber(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__CircuitPoolList_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (circuitPoolNumber().is_bound()) circuitPoolNumber().set_implicit_omit();
}

void BSSMAP__IE__CircuitPoolList_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_circuitPoolNumber.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList.");
}
}

void BSSMAP__IE__CircuitPoolList_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_circuitPoolNumber.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__CircuitPoolList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList.");
}
}

void BSSMAP__IE__CircuitPoolList_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__CircuitPoolList_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_CircuitPoolList has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) circuitPoolNumber().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "circuitPoolNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          circuitPoolNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_CircuitPoolList: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__CircuitPoolList_template* precondition = new BSSMAP__IE__CircuitPoolList_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__CircuitPoolList_template* implied_template = new BSSMAP__IE__CircuitPoolList_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__CircuitPoolList_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_CircuitPoolList");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__CircuitPoolList_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CircuitPoolList");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CircuitPoolList");
single_value->field_circuitPoolNumber.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CircuitPoolList");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_CircuitPoolList");
}

boolean BSSMAP__IE__CircuitPoolList_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__CircuitPoolList_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__TimeIndication::BSSMAP__IE__TimeIndication()
{
}

BSSMAP__IE__TimeIndication::BSSMAP__IE__TimeIndication(const OCTETSTRING& par_elementIdentifier,
    const OCTETSTRING& par_time)
  :   field_elementIdentifier(par_elementIdentifier),
  field_time(par_time)
{
}

BSSMAP__IE__TimeIndication::BSSMAP__IE__TimeIndication(const BSSMAP__IE__TimeIndication& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_TimeIndication.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.time().is_bound()) field_time = other_value.time();
else field_time.clean_up();
}

void BSSMAP__IE__TimeIndication::clean_up()
{
field_elementIdentifier.clean_up();
field_time.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__TimeIndication::get_descriptor() const { return &BSSMAP__IE__TimeIndication_descr_; }
BSSMAP__IE__TimeIndication& BSSMAP__IE__TimeIndication::operator=(const BSSMAP__IE__TimeIndication& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_TimeIndication.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.time().is_bound()) field_time = other_value.time();
  else field_time.clean_up();
}
return *this;
}

boolean BSSMAP__IE__TimeIndication::operator==(const BSSMAP__IE__TimeIndication& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_time==other_value.field_time;
}

boolean BSSMAP__IE__TimeIndication::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_time.is_bound());
}
boolean BSSMAP__IE__TimeIndication::is_value() const
{
return field_elementIdentifier.is_value()
  && field_time.is_value();
}
void BSSMAP__IE__TimeIndication::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", time := ");
field_time.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__TimeIndication::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (time().is_bound()) time().set_implicit_omit();
}

void BSSMAP__IE__TimeIndication::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_TimeIndication has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) time().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "time")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          time().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_TimeIndication: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_TimeIndication");
  }
}

void BSSMAP__IE__TimeIndication::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_time.encode_text(text_buf);
}

void BSSMAP__IE__TimeIndication::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_time.decode_text(text_buf);
}

void BSSMAP__IE__TimeIndication::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__TimeIndication::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__TimeIndication::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_time.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__TimeIndication::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::OCT1_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_time.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__TimeIndication_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
OCTETSTRING_template field_time;
};

void BSSMAP__IE__TimeIndication_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_time = ANY_VALUE;
}
}
}

void BSSMAP__IE__TimeIndication_template::copy_value(const BSSMAP__IE__TimeIndication& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.time().is_bound()) {
  single_value->field_time = other_value.time();
} else {
  single_value->field_time.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__TimeIndication_template::copy_template(const BSSMAP__IE__TimeIndication_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.time().get_selection()) {
single_value->field_time = other_value.time();
} else {
single_value->field_time.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__TimeIndication_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__TimeIndication_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__TimeIndication_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_TimeIndication.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__TimeIndication_template::BSSMAP__IE__TimeIndication_template()
{
}

BSSMAP__IE__TimeIndication_template::BSSMAP__IE__TimeIndication_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__TimeIndication_template::BSSMAP__IE__TimeIndication_template(const BSSMAP__IE__TimeIndication& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__TimeIndication_template::BSSMAP__IE__TimeIndication_template(const OPTIONAL<BSSMAP__IE__TimeIndication>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__TimeIndication&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_TimeIndication from an unbound optional field.");
}
}

BSSMAP__IE__TimeIndication_template::BSSMAP__IE__TimeIndication_template(BSSMAP__IE__TimeIndication_template* p_precondition, BSSMAP__IE__TimeIndication_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__TimeIndication_template::BSSMAP__IE__TimeIndication_template(Dynamic_Match_Interface<BSSMAP__IE__TimeIndication>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__TimeIndication>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__TimeIndication_template::BSSMAP__IE__TimeIndication_template(const BSSMAP__IE__TimeIndication_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__TimeIndication_template::~BSSMAP__IE__TimeIndication_template()
{
clean_up();
}

BSSMAP__IE__TimeIndication_template& BSSMAP__IE__TimeIndication_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__TimeIndication_template& BSSMAP__IE__TimeIndication_template::operator=(const BSSMAP__IE__TimeIndication& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__TimeIndication_template& BSSMAP__IE__TimeIndication_template::operator=(const OPTIONAL<BSSMAP__IE__TimeIndication>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__TimeIndication&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_TimeIndication.");
}
return *this;
}

BSSMAP__IE__TimeIndication_template& BSSMAP__IE__TimeIndication_template::operator=(const BSSMAP__IE__TimeIndication_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__TimeIndication_template::match(const BSSMAP__IE__TimeIndication& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.time().is_bound()) return FALSE;
if(!single_value->field_time.match(other_value.time(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_TimeIndication.");
}
return FALSE;
}

boolean BSSMAP__IE__TimeIndication_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_time.is_bound();
}

boolean BSSMAP__IE__TimeIndication_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_time.is_value();
}

void BSSMAP__IE__TimeIndication_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__TimeIndication BSSMAP__IE__TimeIndication_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_TimeIndication.");
BSSMAP__IE__TimeIndication ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_time.is_bound()) {
ret_val.time() = single_value->field_time.valueof();
}
return ret_val;
}

void BSSMAP__IE__TimeIndication_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_TimeIndication.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__TimeIndication_template[list_length];
}

BSSMAP__IE__TimeIndication_template& BSSMAP__IE__TimeIndication_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_TimeIndication.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_TimeIndication.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__TimeIndication_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__TimeIndication_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_TimeIndication.");
return single_value->field_elementIdentifier;
}

OCTETSTRING_template& BSSMAP__IE__TimeIndication_template::time()
{
set_specific();
return single_value->field_time;
}

const OCTETSTRING_template& BSSMAP__IE__TimeIndication_template::time() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field time of a non-specific template of type @BSSAP_Types.BSSMAP_IE_TimeIndication.");
return single_value->field_time;
}

int BSSMAP__IE__TimeIndication_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TimeIndication which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TimeIndication containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TimeIndication containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TimeIndication containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TimeIndication containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TimeIndication containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TimeIndication containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TimeIndication containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_TimeIndication containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_TimeIndication.");
  }
  return 0;
}

void BSSMAP__IE__TimeIndication_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", time := ");
single_value->field_time.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__TimeIndication_template::log_match(const BSSMAP__IE__TimeIndication& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_time.match(match_value.time(), legacy)){
TTCN_Logger::log_logmatch_info(".time");
single_value->field_time.log_match(match_value.time(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", time := ");
single_value->field_time.log_match(match_value.time(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__TimeIndication_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (time().is_bound()) time().set_implicit_omit();
}

void BSSMAP__IE__TimeIndication_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_time.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_TimeIndication.");
}
}

void BSSMAP__IE__TimeIndication_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_time.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__TimeIndication_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_TimeIndication.");
}
}

void BSSMAP__IE__TimeIndication_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__TimeIndication_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_TimeIndication has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) time().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "time")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          time().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_TimeIndication: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__TimeIndication_template* precondition = new BSSMAP__IE__TimeIndication_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__TimeIndication_template* implied_template = new BSSMAP__IE__TimeIndication_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__TimeIndication_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_TimeIndication");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__TimeIndication_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_TimeIndication");
single_value->field_time.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_TimeIndication");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_TimeIndication");
}

boolean BSSMAP__IE__TimeIndication_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__TimeIndication_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const BSSMAP__FIELD__Resource BSSMAP__FIELD__ResourceList::UNBOUND_ELEM;
BSSMAP__FIELD__ResourceList::BSSMAP__FIELD__ResourceList()
{
val_ptr = NULL;
}

BSSMAP__FIELD__ResourceList::BSSMAP__FIELD__ResourceList(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

BSSMAP__FIELD__ResourceList::BSSMAP__FIELD__ResourceList(const BSSMAP__FIELD__ResourceList& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

BSSMAP__FIELD__ResourceList::~BSSMAP__FIELD__ResourceList()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void BSSMAP__FIELD__ResourceList::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

BSSMAP__FIELD__ResourceList& BSSMAP__FIELD__ResourceList::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

BSSMAP__FIELD__ResourceList& BSSMAP__FIELD__ResourceList::operator=(const BSSMAP__FIELD__ResourceList& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean BSSMAP__FIELD__ResourceList::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
return val_ptr->n_elements == 0 ;
}

boolean BSSMAP__FIELD__ResourceList::operator==(const BSSMAP__FIELD__ResourceList& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

BSSMAP__FIELD__Resource& BSSMAP__FIELD__ResourceList::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @BSSAP_Types.BSSMAP_FIELD_ResourceList using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (BSSMAP__FIELD__Resource**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new BSSMAP__FIELD__Resource(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new BSSMAP__FIELD__Resource;
}
return *val_ptr->value_elements[index_value];
}

BSSMAP__FIELD__Resource& BSSMAP__FIELD__ResourceList::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
return (*this)[(int)index_value];
}

const BSSMAP__FIELD__Resource& BSSMAP__FIELD__ResourceList::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
if (index_value < 0) TTCN_error("Accessing an element of type @BSSAP_Types.BSSMAP_FIELD_ResourceList using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @BSSAP_Types.BSSMAP_FIELD_ResourceList: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const BSSMAP__FIELD__Resource& BSSMAP__FIELD__ResourceList::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
return (*this)[(int)index_value];
}

BSSMAP__FIELD__ResourceList BSSMAP__FIELD__ResourceList::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

BSSMAP__FIELD__ResourceList BSSMAP__FIELD__ResourceList::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

BSSMAP__FIELD__ResourceList BSSMAP__FIELD__ResourceList::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

BSSMAP__FIELD__ResourceList BSSMAP__FIELD__ResourceList::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
BSSMAP__FIELD__ResourceList ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new BSSMAP__FIELD__Resource(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

BSSMAP__FIELD__ResourceList BSSMAP__FIELD__ResourceList::operator+(const BSSMAP__FIELD__ResourceList& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @BSSAP_Types.BSSMAP_FIELD_ResourceList concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
BSSMAP__FIELD__ResourceList ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new BSSMAP__FIELD__Resource(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new BSSMAP__FIELD__Resource(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

BSSMAP__FIELD__ResourceList BSSMAP__FIELD__ResourceList::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@BSSAP_Types.BSSMAP_FIELD_ResourceList","element");
BSSMAP__FIELD__ResourceList ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new BSSMAP__FIELD__Resource(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

BSSMAP__FIELD__ResourceList BSSMAP__FIELD__ResourceList::replace(int index, int len, const BSSMAP__FIELD__ResourceList& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
check_replace_arguments(val_ptr->n_elements, index, len, "@BSSAP_Types.BSSMAP_FIELD_ResourceList","element");
BSSMAP__FIELD__ResourceList ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new BSSMAP__FIELD__Resource(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new BSSMAP__FIELD__Resource(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new BSSMAP__FIELD__Resource(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

BSSMAP__FIELD__ResourceList BSSMAP__FIELD__ResourceList::replace(int index, int len, const BSSMAP__FIELD__ResourceList_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void BSSMAP__FIELD__ResourceList::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (BSSMAP__FIELD__Resource**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new BSSMAP__FIELD__Resource(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (BSSMAP__FIELD__Resource**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @BSSAP_Types.BSSMAP_FIELD_ResourceList: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (BSSMAP__FIELD__Resource**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean BSSMAP__FIELD__ResourceList::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int BSSMAP__FIELD__ResourceList::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
return val_ptr->n_elements;
}

int BSSMAP__FIELD__ResourceList::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void BSSMAP__FIELD__ResourceList::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void BSSMAP__FIELD__ResourceList::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void BSSMAP__FIELD__ResourceList::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@BSSAP_Types.BSSMAP_FIELD_ResourceList");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@BSSAP_Types.BSSMAP_FIELD_ResourceList");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void BSSMAP__FIELD__ResourceList::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void BSSMAP__FIELD__ResourceList::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
val_ptr->value_elements = (BSSMAP__FIELD__Resource**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new BSSMAP__FIELD__Resource;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void BSSMAP__FIELD__ResourceList::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__FIELD__ResourceList::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__FIELD__ResourceList::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int BSSMAP__FIELD__ResourceList::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void BSSMAP__FIELD__ResourceList_template::copy_value(const BSSMAP__FIELD__ResourceList& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (BSSMAP__FIELD__Resource_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__Resource_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__Resource_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__FIELD__ResourceList_template::copy_template(const BSSMAP__FIELD__ResourceList_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (BSSMAP__FIELD__Resource_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__Resource_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__Resource_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__FIELD__ResourceList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__FIELD__ResourceList_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__FIELD__ResourceList_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
break;
}
set_selection(other_value);
}

boolean BSSMAP__FIELD__ResourceList_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const BSSMAP__FIELD__ResourceList_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const BSSMAP__FIELD__ResourceList*)value_ptr)[value_index], legacy);
else return ((const BSSMAP__FIELD__ResourceList_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

BSSMAP__FIELD__ResourceList_template::BSSMAP__FIELD__ResourceList_template()
{
}

BSSMAP__FIELD__ResourceList_template::BSSMAP__FIELD__ResourceList_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__FIELD__ResourceList_template::BSSMAP__FIELD__ResourceList_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

BSSMAP__FIELD__ResourceList_template::BSSMAP__FIELD__ResourceList_template(const BSSMAP__FIELD__ResourceList& other_value)
{
copy_value(other_value);
}

BSSMAP__FIELD__ResourceList_template::BSSMAP__FIELD__ResourceList_template(const OPTIONAL<BSSMAP__FIELD__ResourceList>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__ResourceList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList from an unbound optional field.");
}
}

BSSMAP__FIELD__ResourceList_template::BSSMAP__FIELD__ResourceList_template(BSSMAP__FIELD__ResourceList_template* p_precondition, BSSMAP__FIELD__ResourceList_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__FIELD__ResourceList_template::BSSMAP__FIELD__ResourceList_template(Dynamic_Match_Interface<BSSMAP__FIELD__ResourceList>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__FIELD__ResourceList>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__FIELD__ResourceList_template::BSSMAP__FIELD__ResourceList_template(const BSSMAP__FIELD__ResourceList_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

BSSMAP__FIELD__ResourceList_template::~BSSMAP__FIELD__ResourceList_template()
{
clean_up();
}

void BSSMAP__FIELD__ResourceList_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__FIELD__ResourceList_template& BSSMAP__FIELD__ResourceList_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__FIELD__ResourceList_template& BSSMAP__FIELD__ResourceList_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

BSSMAP__FIELD__ResourceList_template& BSSMAP__FIELD__ResourceList_template::operator=(const BSSMAP__FIELD__ResourceList& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__FIELD__ResourceList_template& BSSMAP__FIELD__ResourceList_template::operator=(const OPTIONAL<BSSMAP__FIELD__ResourceList>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__ResourceList&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
}
return *this;
}

BSSMAP__FIELD__ResourceList_template& BSSMAP__FIELD__ResourceList_template::operator=(const BSSMAP__FIELD__ResourceList_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

BSSMAP__FIELD__Resource_template& BSSMAP__FIELD__ResourceList_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @BSSAP_Types.BSSMAP_FIELD_ResourceList using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
    break;
}
return *single_value.value_elements[index_value];
}

BSSMAP__FIELD__Resource_template& BSSMAP__FIELD__ResourceList_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
return (*this)[(int)index_value];
}

const BSSMAP__FIELD__Resource_template& BSSMAP__FIELD__ResourceList_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @BSSAP_Types.BSSMAP_FIELD_ResourceList using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const BSSMAP__FIELD__Resource_template& BSSMAP__FIELD__ResourceList_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
return (*this)[(int)index_value];
}

void BSSMAP__FIELD__ResourceList_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (BSSMAP__FIELD__Resource_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new BSSMAP__FIELD__Resource_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new BSSMAP__FIELD__Resource_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (BSSMAP__FIELD__Resource_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int BSSMAP__FIELD__ResourceList_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int BSSMAP__FIELD__ResourceList_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList");
}

boolean BSSMAP__FIELD__ResourceList_template::match(const BSSMAP__FIELD__ResourceList& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
}
return FALSE;
}

boolean BSSMAP__FIELD__ResourceList_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

BSSMAP__FIELD__ResourceList BSSMAP__FIELD__ResourceList_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
BSSMAP__FIELD__ResourceList ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

BSSMAP__FIELD__ResourceList BSSMAP__FIELD__ResourceList_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

BSSMAP__FIELD__ResourceList BSSMAP__FIELD__ResourceList_template::replace(int index, int len, const BSSMAP__FIELD__ResourceList_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

BSSMAP__FIELD__ResourceList BSSMAP__FIELD__ResourceList_template::replace(int index, int len, const BSSMAP__FIELD__ResourceList& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void BSSMAP__FIELD__ResourceList_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__FIELD__ResourceList_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
}
set_selection(template_type);
}

BSSMAP__FIELD__ResourceList_template& BSSMAP__FIELD__ResourceList_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
return value_list.list_value[list_index];
}

void BSSMAP__FIELD__ResourceList_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void BSSMAP__FIELD__ResourceList_template::log_match(const BSSMAP__FIELD__ResourceList& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__FIELD__ResourceList_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
}
}

void BSSMAP__FIELD__ResourceList_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
single_value.value_elements = (BSSMAP__FIELD__Resource_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new BSSMAP__FIELD__Resource_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__FIELD__ResourceList_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @BSSAP_Types.BSSMAP_FIELD_ResourceList.");
}
}

boolean BSSMAP__FIELD__ResourceList_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__FIELD__ResourceList_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void BSSMAP__FIELD__ResourceList_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void BSSMAP__FIELD__ResourceList_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__FIELD__ResourceList_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__FIELD__ResourceList_template* precondition = new BSSMAP__FIELD__ResourceList_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__FIELD__ResourceList_template* implied_template = new BSSMAP__FIELD__ResourceList_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__FIELD__ResourceList_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@BSSAP_Types.BSSMAP_FIELD_ResourceList");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void BSSMAP__FIELD__ResourceList_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_ResourceList");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_ResourceList");
}

boolean BSSMAP__FIELD__ResourceList_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
BSSMAP__FIELD__Resource::BSSMAP__FIELD__Resource()
{
}

BSSMAP__FIELD__Resource::BSSMAP__FIELD__Resource(const BITSTRING& par_channelType,
    const BITSTRING& par_resourceAndBandInd,
    const OCTETSTRING& par_nrOfChannels,
    const OPTIONAL< OCTETSTRING >& par_nrOfChannels7__15)
  :   field_channelType(par_channelType),
  field_resourceAndBandInd(par_resourceAndBandInd),
  field_nrOfChannels(par_nrOfChannels),
  field_nrOfChannels7__15(par_nrOfChannels7__15)
{
}

BSSMAP__FIELD__Resource::BSSMAP__FIELD__Resource(const BSSMAP__FIELD__Resource& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_FIELD_Resource.");
if (other_value.channelType().is_bound()) field_channelType = other_value.channelType();
else field_channelType.clean_up();
if (other_value.resourceAndBandInd().is_bound()) field_resourceAndBandInd = other_value.resourceAndBandInd();
else field_resourceAndBandInd.clean_up();
if (other_value.nrOfChannels().is_bound()) field_nrOfChannels = other_value.nrOfChannels();
else field_nrOfChannels.clean_up();
if (other_value.nrOfChannels7__15().is_bound()) field_nrOfChannels7__15 = other_value.nrOfChannels7__15();
else field_nrOfChannels7__15.clean_up();
}

void BSSMAP__FIELD__Resource::clean_up()
{
field_channelType.clean_up();
field_resourceAndBandInd.clean_up();
field_nrOfChannels.clean_up();
field_nrOfChannels7__15.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__FIELD__Resource::get_descriptor() const { return &BSSMAP__FIELD__Resource_descr_; }
BSSMAP__FIELD__Resource& BSSMAP__FIELD__Resource::operator=(const BSSMAP__FIELD__Resource& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_FIELD_Resource.");
  if (other_value.channelType().is_bound()) field_channelType = other_value.channelType();
  else field_channelType.clean_up();
  if (other_value.resourceAndBandInd().is_bound()) field_resourceAndBandInd = other_value.resourceAndBandInd();
  else field_resourceAndBandInd.clean_up();
  if (other_value.nrOfChannels().is_bound()) field_nrOfChannels = other_value.nrOfChannels();
  else field_nrOfChannels.clean_up();
  if (other_value.nrOfChannels7__15().is_bound()) field_nrOfChannels7__15 = other_value.nrOfChannels7__15();
  else field_nrOfChannels7__15.clean_up();
}
return *this;
}

boolean BSSMAP__FIELD__Resource::operator==(const BSSMAP__FIELD__Resource& other_value) const
{
return field_channelType==other_value.field_channelType
  && field_resourceAndBandInd==other_value.field_resourceAndBandInd
  && field_nrOfChannels==other_value.field_nrOfChannels
  && field_nrOfChannels7__15==other_value.field_nrOfChannels7__15;
}

boolean BSSMAP__FIELD__Resource::is_bound() const
{
return (field_channelType.is_bound())
  || (field_resourceAndBandInd.is_bound())
  || (field_nrOfChannels.is_bound())
  || (OPTIONAL_OMIT == field_nrOfChannels7__15.get_selection() || field_nrOfChannels7__15.is_bound());
}
boolean BSSMAP__FIELD__Resource::is_value() const
{
return field_channelType.is_value()
  && field_resourceAndBandInd.is_value()
  && field_nrOfChannels.is_value()
  && (OPTIONAL_OMIT == field_nrOfChannels7__15.get_selection() || field_nrOfChannels7__15.is_value());
}
int BSSMAP__FIELD__Resource::size_of() const
{
  int ret_val = 3;
  if (field_nrOfChannels7__15.ispresent()) ret_val++;
  return ret_val;
}

void BSSMAP__FIELD__Resource::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ channelType := ");
field_channelType.log();
TTCN_Logger::log_event_str(", resourceAndBandInd := ");
field_resourceAndBandInd.log();
TTCN_Logger::log_event_str(", nrOfChannels := ");
field_nrOfChannels.log();
TTCN_Logger::log_event_str(", nrOfChannels7_15 := ");
field_nrOfChannels7__15.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__FIELD__Resource::set_implicit_omit()
{
if (channelType().is_bound()) channelType().set_implicit_omit();
if (resourceAndBandInd().is_bound()) resourceAndBandInd().set_implicit_omit();
if (nrOfChannels().is_bound()) nrOfChannels().set_implicit_omit();
if (!nrOfChannels7__15().is_bound()) nrOfChannels7__15() = OMIT_VALUE;
else nrOfChannels7__15().set_implicit_omit();
}

void BSSMAP__FIELD__Resource::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_FIELD_Resource has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) channelType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) resourceAndBandInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) nrOfChannels().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) nrOfChannels7__15().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "channelType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          channelType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "resourceAndBandInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          resourceAndBandInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nrOfChannels")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nrOfChannels().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nrOfChannels7_15")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nrOfChannels7__15().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_FIELD_Resource: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_FIELD_Resource");
  }
}

void BSSMAP__FIELD__Resource::encode_text(Text_Buf& text_buf) const
{
field_channelType.encode_text(text_buf);
field_resourceAndBandInd.encode_text(text_buf);
field_nrOfChannels.encode_text(text_buf);
field_nrOfChannels7__15.encode_text(text_buf);
}

void BSSMAP__FIELD__Resource::decode_text(Text_Buf& text_buf)
{
field_channelType.decode_text(text_buf);
field_resourceAndBandInd.decode_text(text_buf);
field_nrOfChannels.decode_text(text_buf);
field_nrOfChannels7__15.decode_text(text_buf);
}

void BSSMAP__FIELD__Resource::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__FIELD__Resource::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__FIELD__Resource::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_channelType.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_resourceAndBandInd.RAW_decode(General__Types::BIT4_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, BSSMAP__FIELD__Resource_nrOfChannels_descr_.raw->forceomit);
  decoded_field_length = field_nrOfChannels.RAW_decode(BSSMAP__FIELD__Resource_nrOfChannels_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_nrOfChannels7__15 = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_nrOfChannels7__15().RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_nrOfChannels7__15 = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_nrOfChannels7__15=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__FIELD__Resource::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, BSSMAP__FIELD__Resource_nrOfChannels_descr_.raw);
  if (field_nrOfChannels7__15.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::OCT1_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  encoded_length += field_channelType.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_resourceAndBandInd.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_nrOfChannels.RAW_encode(BSSMAP__FIELD__Resource_nrOfChannels_descr_, *myleaf.body.node.nodes[2]);
  if (field_nrOfChannels7__15.ispresent()) {
  encoded_length += field_nrOfChannels7__15().RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[3]);
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__FIELD__Resource_template::single_value_struct {
BITSTRING_template field_channelType;
BITSTRING_template field_resourceAndBandInd;
OCTETSTRING_template field_nrOfChannels;
OCTETSTRING_template field_nrOfChannels7__15;
};

void BSSMAP__FIELD__Resource_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_channelType = ANY_VALUE;
single_value->field_resourceAndBandInd = ANY_VALUE;
single_value->field_nrOfChannels = ANY_VALUE;
single_value->field_nrOfChannels7__15 = ANY_OR_OMIT;
}
}
}

void BSSMAP__FIELD__Resource_template::copy_value(const BSSMAP__FIELD__Resource& other_value)
{
single_value = new single_value_struct;
if (other_value.channelType().is_bound()) {
  single_value->field_channelType = other_value.channelType();
} else {
  single_value->field_channelType.clean_up();
}
if (other_value.resourceAndBandInd().is_bound()) {
  single_value->field_resourceAndBandInd = other_value.resourceAndBandInd();
} else {
  single_value->field_resourceAndBandInd.clean_up();
}
if (other_value.nrOfChannels().is_bound()) {
  single_value->field_nrOfChannels = other_value.nrOfChannels();
} else {
  single_value->field_nrOfChannels.clean_up();
}
if (other_value.nrOfChannels7__15().is_bound()) {
  if (other_value.nrOfChannels7__15().ispresent()) single_value->field_nrOfChannels7__15 = other_value.nrOfChannels7__15()();
  else single_value->field_nrOfChannels7__15 = OMIT_VALUE;
} else {
  single_value->field_nrOfChannels7__15.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__FIELD__Resource_template::copy_template(const BSSMAP__FIELD__Resource_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.channelType().get_selection()) {
single_value->field_channelType = other_value.channelType();
} else {
single_value->field_channelType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.resourceAndBandInd().get_selection()) {
single_value->field_resourceAndBandInd = other_value.resourceAndBandInd();
} else {
single_value->field_resourceAndBandInd.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nrOfChannels().get_selection()) {
single_value->field_nrOfChannels = other_value.nrOfChannels();
} else {
single_value->field_nrOfChannels.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nrOfChannels7__15().get_selection()) {
single_value->field_nrOfChannels7__15 = other_value.nrOfChannels7__15();
} else {
single_value->field_nrOfChannels7__15.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__FIELD__Resource_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__FIELD__Resource_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__FIELD__Resource_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_Resource.");
break;
}
set_selection(other_value);
}

BSSMAP__FIELD__Resource_template::BSSMAP__FIELD__Resource_template()
{
}

BSSMAP__FIELD__Resource_template::BSSMAP__FIELD__Resource_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__FIELD__Resource_template::BSSMAP__FIELD__Resource_template(const BSSMAP__FIELD__Resource& other_value)
{
copy_value(other_value);
}

BSSMAP__FIELD__Resource_template::BSSMAP__FIELD__Resource_template(const OPTIONAL<BSSMAP__FIELD__Resource>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__Resource&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_FIELD_Resource from an unbound optional field.");
}
}

BSSMAP__FIELD__Resource_template::BSSMAP__FIELD__Resource_template(BSSMAP__FIELD__Resource_template* p_precondition, BSSMAP__FIELD__Resource_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__FIELD__Resource_template::BSSMAP__FIELD__Resource_template(Dynamic_Match_Interface<BSSMAP__FIELD__Resource>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__FIELD__Resource>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__FIELD__Resource_template::BSSMAP__FIELD__Resource_template(const BSSMAP__FIELD__Resource_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__FIELD__Resource_template::~BSSMAP__FIELD__Resource_template()
{
clean_up();
}

BSSMAP__FIELD__Resource_template& BSSMAP__FIELD__Resource_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__FIELD__Resource_template& BSSMAP__FIELD__Resource_template::operator=(const BSSMAP__FIELD__Resource& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__FIELD__Resource_template& BSSMAP__FIELD__Resource_template::operator=(const OPTIONAL<BSSMAP__FIELD__Resource>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__FIELD__Resource&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_FIELD_Resource.");
}
return *this;
}

BSSMAP__FIELD__Resource_template& BSSMAP__FIELD__Resource_template::operator=(const BSSMAP__FIELD__Resource_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__FIELD__Resource_template::match(const BSSMAP__FIELD__Resource& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.channelType().is_bound()) return FALSE;
if(!single_value->field_channelType.match(other_value.channelType(), legacy))return FALSE;
if(!other_value.resourceAndBandInd().is_bound()) return FALSE;
if(!single_value->field_resourceAndBandInd.match(other_value.resourceAndBandInd(), legacy))return FALSE;
if(!other_value.nrOfChannels().is_bound()) return FALSE;
if(!single_value->field_nrOfChannels.match(other_value.nrOfChannels(), legacy))return FALSE;
if(!other_value.nrOfChannels7__15().is_bound()) return FALSE;
if((other_value.nrOfChannels7__15().ispresent() ? !single_value->field_nrOfChannels7__15.match((const OCTETSTRING&)other_value.nrOfChannels7__15(), legacy) : !single_value->field_nrOfChannels7__15.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_Resource.");
}
return FALSE;
}

boolean BSSMAP__FIELD__Resource_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_channelType.is_bound()
 || single_value->field_resourceAndBandInd.is_bound()
 || single_value->field_nrOfChannels.is_bound()
 || (single_value->field_nrOfChannels7__15.is_omit() || single_value->field_nrOfChannels7__15.is_bound());
}

boolean BSSMAP__FIELD__Resource_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_channelType.is_value()
 && single_value->field_resourceAndBandInd.is_value()
 && single_value->field_nrOfChannels.is_value()
 && (single_value->field_nrOfChannels7__15.is_omit() || single_value->field_nrOfChannels7__15.is_value());
}

void BSSMAP__FIELD__Resource_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__FIELD__Resource BSSMAP__FIELD__Resource_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_Resource.");
BSSMAP__FIELD__Resource ret_val;
if (single_value->field_channelType.is_bound()) {
ret_val.channelType() = single_value->field_channelType.valueof();
}
if (single_value->field_resourceAndBandInd.is_bound()) {
ret_val.resourceAndBandInd() = single_value->field_resourceAndBandInd.valueof();
}
if (single_value->field_nrOfChannels.is_bound()) {
ret_val.nrOfChannels() = single_value->field_nrOfChannels.valueof();
}
if (single_value->field_nrOfChannels7__15.is_omit()) ret_val.nrOfChannels7__15() = OMIT_VALUE;
else if (single_value->field_nrOfChannels7__15.is_bound()) {
ret_val.nrOfChannels7__15() = single_value->field_nrOfChannels7__15.valueof();
}
return ret_val;
}

void BSSMAP__FIELD__Resource_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_FIELD_Resource.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__FIELD__Resource_template[list_length];
}

BSSMAP__FIELD__Resource_template& BSSMAP__FIELD__Resource_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_FIELD_Resource.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_FIELD_Resource.");
return value_list.list_value[list_index];
}

BITSTRING_template& BSSMAP__FIELD__Resource_template::channelType()
{
set_specific();
return single_value->field_channelType;
}

const BITSTRING_template& BSSMAP__FIELD__Resource_template::channelType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field channelType of a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_Resource.");
return single_value->field_channelType;
}

BITSTRING_template& BSSMAP__FIELD__Resource_template::resourceAndBandInd()
{
set_specific();
return single_value->field_resourceAndBandInd;
}

const BITSTRING_template& BSSMAP__FIELD__Resource_template::resourceAndBandInd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field resourceAndBandInd of a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_Resource.");
return single_value->field_resourceAndBandInd;
}

OCTETSTRING_template& BSSMAP__FIELD__Resource_template::nrOfChannels()
{
set_specific();
return single_value->field_nrOfChannels;
}

const OCTETSTRING_template& BSSMAP__FIELD__Resource_template::nrOfChannels() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nrOfChannels of a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_Resource.");
return single_value->field_nrOfChannels;
}

OCTETSTRING_template& BSSMAP__FIELD__Resource_template::nrOfChannels7__15()
{
set_specific();
return single_value->field_nrOfChannels7__15;
}

const OCTETSTRING_template& BSSMAP__FIELD__Resource_template::nrOfChannels7__15() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nrOfChannels7_15 of a non-specific template of type @BSSAP_Types.BSSMAP_FIELD_Resource.");
return single_value->field_nrOfChannels7__15;
}

int BSSMAP__FIELD__Resource_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_Resource which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 3;
      if (single_value->field_nrOfChannels7__15.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_Resource containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_Resource containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_Resource containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_Resource containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_Resource containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_Resource containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_Resource containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_FIELD_Resource containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_Resource.");
  }
  return 0;
}

void BSSMAP__FIELD__Resource_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ channelType := ");
single_value->field_channelType.log();
TTCN_Logger::log_event_str(", resourceAndBandInd := ");
single_value->field_resourceAndBandInd.log();
TTCN_Logger::log_event_str(", nrOfChannels := ");
single_value->field_nrOfChannels.log();
TTCN_Logger::log_event_str(", nrOfChannels7_15 := ");
single_value->field_nrOfChannels7__15.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__FIELD__Resource_template::log_match(const BSSMAP__FIELD__Resource& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_channelType.match(match_value.channelType(), legacy)){
TTCN_Logger::log_logmatch_info(".channelType");
single_value->field_channelType.log_match(match_value.channelType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_resourceAndBandInd.match(match_value.resourceAndBandInd(), legacy)){
TTCN_Logger::log_logmatch_info(".resourceAndBandInd");
single_value->field_resourceAndBandInd.log_match(match_value.resourceAndBandInd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nrOfChannels.match(match_value.nrOfChannels(), legacy)){
TTCN_Logger::log_logmatch_info(".nrOfChannels");
single_value->field_nrOfChannels.log_match(match_value.nrOfChannels(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.nrOfChannels7__15().ispresent()){
if(!single_value->field_nrOfChannels7__15.match(match_value.nrOfChannels7__15(), legacy)){
TTCN_Logger::log_logmatch_info(".nrOfChannels7_15");
single_value->field_nrOfChannels7__15.log_match(match_value.nrOfChannels7__15(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_nrOfChannels7__15.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".nrOfChannels7_15 := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_nrOfChannels7__15.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ channelType := ");
single_value->field_channelType.log_match(match_value.channelType(), legacy);
TTCN_Logger::log_event_str(", resourceAndBandInd := ");
single_value->field_resourceAndBandInd.log_match(match_value.resourceAndBandInd(), legacy);
TTCN_Logger::log_event_str(", nrOfChannels := ");
single_value->field_nrOfChannels.log_match(match_value.nrOfChannels(), legacy);
TTCN_Logger::log_event_str(", nrOfChannels7_15 := ");
if (match_value.nrOfChannels7__15().ispresent()) {
single_value->field_nrOfChannels7__15.log_match(match_value.nrOfChannels7__15(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_nrOfChannels7__15.log();
if (single_value->field_nrOfChannels7__15.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__FIELD__Resource_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (channelType().is_bound()) channelType().set_implicit_omit();
if (resourceAndBandInd().is_bound()) resourceAndBandInd().set_implicit_omit();
if (nrOfChannels().is_bound()) nrOfChannels().set_implicit_omit();
if (!nrOfChannels7__15().is_bound()) nrOfChannels7__15() = OMIT_VALUE;
else nrOfChannels7__15().set_implicit_omit();
}

void BSSMAP__FIELD__Resource_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_channelType.encode_text(text_buf);
single_value->field_resourceAndBandInd.encode_text(text_buf);
single_value->field_nrOfChannels.encode_text(text_buf);
single_value->field_nrOfChannels7__15.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_FIELD_Resource.");
}
}

void BSSMAP__FIELD__Resource_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_channelType.decode_text(text_buf);
single_value->field_resourceAndBandInd.decode_text(text_buf);
single_value->field_nrOfChannels.decode_text(text_buf);
single_value->field_nrOfChannels7__15.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__FIELD__Resource_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_FIELD_Resource.");
}
}

void BSSMAP__FIELD__Resource_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__FIELD__Resource_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_FIELD_Resource has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) channelType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) resourceAndBandInd().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) nrOfChannels().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) nrOfChannels7__15().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "channelType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          channelType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "resourceAndBandInd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          resourceAndBandInd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nrOfChannels")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nrOfChannels().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nrOfChannels7_15")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nrOfChannels7__15().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_FIELD_Resource: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__FIELD__Resource_template* precondition = new BSSMAP__FIELD__Resource_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__FIELD__Resource_template* implied_template = new BSSMAP__FIELD__Resource_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__FIELD__Resource_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_FIELD_Resource");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__FIELD__Resource_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_channelType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_Resource");
single_value->field_resourceAndBandInd.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_Resource");
single_value->field_nrOfChannels.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_Resource");
single_value->field_nrOfChannels7__15.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_Resource");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_FIELD_Resource");
}

boolean BSSMAP__FIELD__Resource_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__FIELD__Resource_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__ResourceSituation::BSSMAP__IE__ResourceSituation()
{
}

BSSMAP__IE__ResourceSituation::BSSMAP__IE__ResourceSituation(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const BSSMAP__FIELD__ResourceList& par_resourceList)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_resourceList(par_resourceList)
{
}

BSSMAP__IE__ResourceSituation::BSSMAP__IE__ResourceSituation(const BSSMAP__IE__ResourceSituation& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_ResourceSituation.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.resourceList().is_bound()) field_resourceList = other_value.resourceList();
else field_resourceList.clean_up();
}

void BSSMAP__IE__ResourceSituation::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_resourceList.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__ResourceSituation::get_descriptor() const { return &BSSMAP__IE__ResourceSituation_descr_; }
BSSMAP__IE__ResourceSituation& BSSMAP__IE__ResourceSituation::operator=(const BSSMAP__IE__ResourceSituation& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_ResourceSituation.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.resourceList().is_bound()) field_resourceList = other_value.resourceList();
  else field_resourceList.clean_up();
}
return *this;
}

boolean BSSMAP__IE__ResourceSituation::operator==(const BSSMAP__IE__ResourceSituation& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_resourceList==other_value.field_resourceList;
}

boolean BSSMAP__IE__ResourceSituation::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_resourceList.is_bound());
}
boolean BSSMAP__IE__ResourceSituation::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_resourceList.is_value();
}
void BSSMAP__IE__ResourceSituation::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", resourceList := ");
field_resourceList.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__ResourceSituation::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (resourceList().is_bound()) resourceList().set_implicit_omit();
}

void BSSMAP__IE__ResourceSituation::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_ResourceSituation has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) resourceList().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "resourceList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          resourceList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_ResourceSituation: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_ResourceSituation");
  }
}

void BSSMAP__IE__ResourceSituation::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_resourceList.encode_text(text_buf);
}

void BSSMAP__IE__ResourceSituation::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_resourceList.decode_text(text_buf);
}

void BSSMAP__IE__ResourceSituation::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__ResourceSituation::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__ResourceSituation::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__ResourceSituation_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__ResourceSituation_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__ResourceSituation_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, BSSMAP__FIELD__ResourceList_descr_.raw->forceomit);
  decoded_field_length = field_resourceList.RAW_decode(BSSMAP__FIELD__ResourceList_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_87) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__ResourceSituation::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__ResourceSituation_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, BSSMAP__FIELD__ResourceList_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__ResourceSituation_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_resourceList.RAW_encode(BSSMAP__FIELD__ResourceList_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier !=  os_87) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_87.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__ResourceSituation_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
BSSMAP__FIELD__ResourceList_template field_resourceList;
};

void BSSMAP__IE__ResourceSituation_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_resourceList = ANY_VALUE;
}
}
}

void BSSMAP__IE__ResourceSituation_template::copy_value(const BSSMAP__IE__ResourceSituation& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.resourceList().is_bound()) {
  single_value->field_resourceList = other_value.resourceList();
} else {
  single_value->field_resourceList.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__ResourceSituation_template::copy_template(const BSSMAP__IE__ResourceSituation_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.resourceList().get_selection()) {
single_value->field_resourceList = other_value.resourceList();
} else {
single_value->field_resourceList.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__ResourceSituation_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__ResourceSituation_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__ResourceSituation_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ResourceSituation.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__ResourceSituation_template::BSSMAP__IE__ResourceSituation_template()
{
}

BSSMAP__IE__ResourceSituation_template::BSSMAP__IE__ResourceSituation_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__ResourceSituation_template::BSSMAP__IE__ResourceSituation_template(const BSSMAP__IE__ResourceSituation& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__ResourceSituation_template::BSSMAP__IE__ResourceSituation_template(const OPTIONAL<BSSMAP__IE__ResourceSituation>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__ResourceSituation&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_ResourceSituation from an unbound optional field.");
}
}

BSSMAP__IE__ResourceSituation_template::BSSMAP__IE__ResourceSituation_template(BSSMAP__IE__ResourceSituation_template* p_precondition, BSSMAP__IE__ResourceSituation_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__ResourceSituation_template::BSSMAP__IE__ResourceSituation_template(Dynamic_Match_Interface<BSSMAP__IE__ResourceSituation>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__ResourceSituation>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__ResourceSituation_template::BSSMAP__IE__ResourceSituation_template(const BSSMAP__IE__ResourceSituation_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__ResourceSituation_template::~BSSMAP__IE__ResourceSituation_template()
{
clean_up();
}

BSSMAP__IE__ResourceSituation_template& BSSMAP__IE__ResourceSituation_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__ResourceSituation_template& BSSMAP__IE__ResourceSituation_template::operator=(const BSSMAP__IE__ResourceSituation& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__ResourceSituation_template& BSSMAP__IE__ResourceSituation_template::operator=(const OPTIONAL<BSSMAP__IE__ResourceSituation>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
ca