// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "BSSAP_Types.hh"

namespace BSSAP__Types {

/* Member functions of C++ classes */

BSSMAP__IE__APDU::BSSMAP__IE__APDU()
{
}

BSSMAP__IE__APDU::BSSMAP__IE__APDU(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const OPTIONAL< BITSTRING >& par_protocolID,
    const OPTIONAL< BITSTRING >& par_spare__1__1,
    const OPTIONAL< OCTETSTRING >& par_embeddedMessage)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_protocolID(par_protocolID),
  field_spare__1__1(par_spare__1__1),
  field_embeddedMessage(par_embeddedMessage)
{
}

BSSMAP__IE__APDU::BSSMAP__IE__APDU(const BSSMAP__IE__APDU& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_APDU.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.protocolID().is_bound()) field_protocolID = other_value.protocolID();
else field_protocolID.clean_up();
if (other_value.spare__1__1().is_bound()) field_spare__1__1 = other_value.spare__1__1();
else field_spare__1__1.clean_up();
if (other_value.embeddedMessage().is_bound()) field_embeddedMessage = other_value.embeddedMessage();
else field_embeddedMessage.clean_up();
}

void BSSMAP__IE__APDU::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_protocolID.clean_up();
field_spare__1__1.clean_up();
field_embeddedMessage.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__APDU::get_descriptor() const { return &BSSMAP__IE__APDU_descr_; }
BSSMAP__IE__APDU& BSSMAP__IE__APDU::operator=(const BSSMAP__IE__APDU& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_APDU.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.protocolID().is_bound()) field_protocolID = other_value.protocolID();
  else field_protocolID.clean_up();
  if (other_value.spare__1__1().is_bound()) field_spare__1__1 = other_value.spare__1__1();
  else field_spare__1__1.clean_up();
  if (other_value.embeddedMessage().is_bound()) field_embeddedMessage = other_value.embeddedMessage();
  else field_embeddedMessage.clean_up();
}
return *this;
}

boolean BSSMAP__IE__APDU::operator==(const BSSMAP__IE__APDU& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_protocolID==other_value.field_protocolID
  && field_spare__1__1==other_value.field_spare__1__1
  && field_embeddedMessage==other_value.field_embeddedMessage;
}

boolean BSSMAP__IE__APDU::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (OPTIONAL_OMIT == field_protocolID.get_selection() || field_protocolID.is_bound())
  || (OPTIONAL_OMIT == field_spare__1__1.get_selection() || field_spare__1__1.is_bound())
  || (OPTIONAL_OMIT == field_embeddedMessage.get_selection() || field_embeddedMessage.is_bound());
}
boolean BSSMAP__IE__APDU::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && (OPTIONAL_OMIT == field_protocolID.get_selection() || field_protocolID.is_value())
  && (OPTIONAL_OMIT == field_spare__1__1.get_selection() || field_spare__1__1.is_value())
  && (OPTIONAL_OMIT == field_embeddedMessage.get_selection() || field_embeddedMessage.is_value());
}
int BSSMAP__IE__APDU::size_of() const
{
  int ret_val = 2;
  if (field_protocolID.ispresent()) ret_val++;
  if (field_spare__1__1.ispresent()) ret_val++;
  if (field_embeddedMessage.ispresent()) ret_val++;
  return ret_val;
}

void BSSMAP__IE__APDU::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", protocolID := ");
field_protocolID.log();
TTCN_Logger::log_event_str(", spare_1_1 := ");
field_spare__1__1.log();
TTCN_Logger::log_event_str(", embeddedMessage := ");
field_embeddedMessage.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__APDU::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (!protocolID().is_bound()) protocolID() = OMIT_VALUE;
else protocolID().set_implicit_omit();
if (!spare__1__1().is_bound()) spare__1__1() = OMIT_VALUE;
else spare__1__1().set_implicit_omit();
if (!embeddedMessage().is_bound()) embeddedMessage() = OMIT_VALUE;
else embeddedMessage().set_implicit_omit();
}

void BSSMAP__IE__APDU::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_APDU has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) protocolID().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare__1__1().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) embeddedMessage().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare_1_1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare__1__1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "embeddedMessage")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          embeddedMessage().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_APDU: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_APDU");
  }
}

void BSSMAP__IE__APDU::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_protocolID.encode_text(text_buf);
field_spare__1__1.encode_text(text_buf);
field_embeddedMessage.encode_text(text_buf);
}

void BSSMAP__IE__APDU::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_protocolID.decode_text(text_buf);
field_spare__1__1.decode_text(text_buf);
field_embeddedMessage.decode_text(text_buf);
}

void BSSMAP__IE__APDU::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__APDU::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__APDU::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__APDU_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__APDU_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__APDU_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  if (limit > 0 && value_of_length_field1 > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_protocolID = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT7_descr_.raw->forceomit);
  decoded_field_length = field_protocolID().RAW_decode(General__Types::BIT7_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_protocolID = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  }
  }
  }
  else field_protocolID=OMIT_VALUE;
  if (limit > 0 && value_of_length_field1 > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_spare__1__1 = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_spare__1__1().RAW_decode(General__Types::BIT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_spare__1__1 = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  }
  }
  }
  else field_spare__1__1=OMIT_VALUE;
  if (limit > 0 && value_of_length_field1 > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_embeddedMessage = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_embeddedMessage().RAW_decode(OCTETSTRING_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_embeddedMessage = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  }
  }
  }
  else field_embeddedMessage=OMIT_VALUE;
  if (field_elementIdentifier !=  os_66) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__APDU::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__APDU_lengthIndicator_descr_.raw);
  if (field_protocolID.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT7_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_spare__1__1.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT1_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_embeddedMessage.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, OCTETSTRING_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 16;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__APDU_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 16;
  if (field_protocolID.ispresent()) {
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  } else {
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = 0;
  }
  if (field_spare__1__1.ispresent()) {
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  } else {
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = 0;
  }
  if (field_embeddedMessage.ispresent()) {
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  } else {
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = 0;
  }
  if (field_protocolID.ispresent()) {
  encoded_length += field_protocolID().RAW_encode(General__Types::BIT7_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_spare__1__1.ispresent()) {
  encoded_length += field_spare__1__1().RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_embeddedMessage.ispresent()) {
  encoded_length += field_embeddedMessage().RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_elementIdentifier !=  os_66) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_66.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__APDU_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
BITSTRING_template field_protocolID;
BITSTRING_template field_spare__1__1;
OCTETSTRING_template field_embeddedMessage;
};

void BSSMAP__IE__APDU_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_protocolID = ANY_OR_OMIT;
single_value->field_spare__1__1 = ANY_OR_OMIT;
single_value->field_embeddedMessage = ANY_OR_OMIT;
}
}
}

void BSSMAP__IE__APDU_template::copy_value(const BSSMAP__IE__APDU& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.protocolID().is_bound()) {
  if (other_value.protocolID().ispresent()) single_value->field_protocolID = other_value.protocolID()();
  else single_value->field_protocolID = OMIT_VALUE;
} else {
  single_value->field_protocolID.clean_up();
}
if (other_value.spare__1__1().is_bound()) {
  if (other_value.spare__1__1().ispresent()) single_value->field_spare__1__1 = other_value.spare__1__1()();
  else single_value->field_spare__1__1 = OMIT_VALUE;
} else {
  single_value->field_spare__1__1.clean_up();
}
if (other_value.embeddedMessage().is_bound()) {
  if (other_value.embeddedMessage().ispresent()) single_value->field_embeddedMessage = other_value.embeddedMessage()();
  else single_value->field_embeddedMessage = OMIT_VALUE;
} else {
  single_value->field_embeddedMessage.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__APDU_template::copy_template(const BSSMAP__IE__APDU_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.protocolID().get_selection()) {
single_value->field_protocolID = other_value.protocolID();
} else {
single_value->field_protocolID.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare__1__1().get_selection()) {
single_value->field_spare__1__1 = other_value.spare__1__1();
} else {
single_value->field_spare__1__1.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.embeddedMessage().get_selection()) {
single_value->field_embeddedMessage = other_value.embeddedMessage();
} else {
single_value->field_embeddedMessage.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__APDU_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__APDU_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__APDU_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_APDU.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__APDU_template::BSSMAP__IE__APDU_template()
{
}

BSSMAP__IE__APDU_template::BSSMAP__IE__APDU_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__APDU_template::BSSMAP__IE__APDU_template(const BSSMAP__IE__APDU& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__APDU_template::BSSMAP__IE__APDU_template(const OPTIONAL<BSSMAP__IE__APDU>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__APDU&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_APDU from an unbound optional field.");
}
}

BSSMAP__IE__APDU_template::BSSMAP__IE__APDU_template(BSSMAP__IE__APDU_template* p_precondition, BSSMAP__IE__APDU_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__APDU_template::BSSMAP__IE__APDU_template(Dynamic_Match_Interface<BSSMAP__IE__APDU>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__APDU>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__APDU_template::BSSMAP__IE__APDU_template(const BSSMAP__IE__APDU_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__APDU_template::~BSSMAP__IE__APDU_template()
{
clean_up();
}

BSSMAP__IE__APDU_template& BSSMAP__IE__APDU_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__APDU_template& BSSMAP__IE__APDU_template::operator=(const BSSMAP__IE__APDU& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__APDU_template& BSSMAP__IE__APDU_template::operator=(const OPTIONAL<BSSMAP__IE__APDU>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__APDU&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_APDU.");
}
return *this;
}

BSSMAP__IE__APDU_template& BSSMAP__IE__APDU_template::operator=(const BSSMAP__IE__APDU_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__APDU_template::match(const BSSMAP__IE__APDU& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.protocolID().is_bound()) return FALSE;
if((other_value.protocolID().ispresent() ? !single_value->field_protocolID.match((const BITSTRING&)other_value.protocolID(), legacy) : !single_value->field_protocolID.match_omit(legacy)))return FALSE;
if(!other_value.spare__1__1().is_bound()) return FALSE;
if((other_value.spare__1__1().ispresent() ? !single_value->field_spare__1__1.match((const BITSTRING&)other_value.spare__1__1(), legacy) : !single_value->field_spare__1__1.match_omit(legacy)))return FALSE;
if(!other_value.embeddedMessage().is_bound()) return FALSE;
if((other_value.embeddedMessage().ispresent() ? !single_value->field_embeddedMessage.match((const OCTETSTRING&)other_value.embeddedMessage(), legacy) : !single_value->field_embeddedMessage.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_APDU.");
}
return FALSE;
}

boolean BSSMAP__IE__APDU_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || (single_value->field_protocolID.is_omit() || single_value->field_protocolID.is_bound())
 || (single_value->field_spare__1__1.is_omit() || single_value->field_spare__1__1.is_bound())
 || (single_value->field_embeddedMessage.is_omit() || single_value->field_embeddedMessage.is_bound());
}

boolean BSSMAP__IE__APDU_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && (single_value->field_protocolID.is_omit() || single_value->field_protocolID.is_value())
 && (single_value->field_spare__1__1.is_omit() || single_value->field_spare__1__1.is_value())
 && (single_value->field_embeddedMessage.is_omit() || single_value->field_embeddedMessage.is_value());
}

void BSSMAP__IE__APDU_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__APDU BSSMAP__IE__APDU_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_APDU.");
BSSMAP__IE__APDU ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_protocolID.is_omit()) ret_val.protocolID() = OMIT_VALUE;
else if (single_value->field_protocolID.is_bound()) {
ret_val.protocolID() = single_value->field_protocolID.valueof();
}
if (single_value->field_spare__1__1.is_omit()) ret_val.spare__1__1() = OMIT_VALUE;
else if (single_value->field_spare__1__1.is_bound()) {
ret_val.spare__1__1() = single_value->field_spare__1__1.valueof();
}
if (single_value->field_embeddedMessage.is_omit()) ret_val.embeddedMessage() = OMIT_VALUE;
else if (single_value->field_embeddedMessage.is_bound()) {
ret_val.embeddedMessage() = single_value->field_embeddedMessage.valueof();
}
return ret_val;
}

void BSSMAP__IE__APDU_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_APDU.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__APDU_template[list_length];
}

BSSMAP__IE__APDU_template& BSSMAP__IE__APDU_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_APDU.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_APDU.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__APDU_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__APDU_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_APDU.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__APDU_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__APDU_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_APDU.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& BSSMAP__IE__APDU_template::protocolID()
{
set_specific();
return single_value->field_protocolID;
}

const BITSTRING_template& BSSMAP__IE__APDU_template::protocolID() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field protocolID of a non-specific template of type @BSSAP_Types.BSSMAP_IE_APDU.");
return single_value->field_protocolID;
}

BITSTRING_template& BSSMAP__IE__APDU_template::spare__1__1()
{
set_specific();
return single_value->field_spare__1__1;
}

const BITSTRING_template& BSSMAP__IE__APDU_template::spare__1__1() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare_1_1 of a non-specific template of type @BSSAP_Types.BSSMAP_IE_APDU.");
return single_value->field_spare__1__1;
}

OCTETSTRING_template& BSSMAP__IE__APDU_template::embeddedMessage()
{
set_specific();
return single_value->field_embeddedMessage;
}

const OCTETSTRING_template& BSSMAP__IE__APDU_template::embeddedMessage() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field embeddedMessage of a non-specific template of type @BSSAP_Types.BSSMAP_IE_APDU.");
return single_value->field_embeddedMessage;
}

int BSSMAP__IE__APDU_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_APDU which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_protocolID.is_present()) ret_val++;
      if (single_value->field_spare__1__1.is_present()) ret_val++;
      if (single_value->field_embeddedMessage.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_APDU containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_APDU containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_APDU containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_APDU containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_APDU containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_APDU containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_APDU containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_APDU containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_APDU.");
  }
  return 0;
}

void BSSMAP__IE__APDU_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", protocolID := ");
single_value->field_protocolID.log();
TTCN_Logger::log_event_str(", spare_1_1 := ");
single_value->field_spare__1__1.log();
TTCN_Logger::log_event_str(", embeddedMessage := ");
single_value->field_embeddedMessage.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__APDU_template::log_match(const BSSMAP__IE__APDU& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.protocolID().ispresent()){
if(!single_value->field_protocolID.match(match_value.protocolID(), legacy)){
TTCN_Logger::log_logmatch_info(".protocolID");
single_value->field_protocolID.log_match(match_value.protocolID(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_protocolID.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".protocolID := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_protocolID.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.spare__1__1().ispresent()){
if(!single_value->field_spare__1__1.match(match_value.spare__1__1(), legacy)){
TTCN_Logger::log_logmatch_info(".spare_1_1");
single_value->field_spare__1__1.log_match(match_value.spare__1__1(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_spare__1__1.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".spare_1_1 := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_spare__1__1.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.embeddedMessage().ispresent()){
if(!single_value->field_embeddedMessage.match(match_value.embeddedMessage(), legacy)){
TTCN_Logger::log_logmatch_info(".embeddedMessage");
single_value->field_embeddedMessage.log_match(match_value.embeddedMessage(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_embeddedMessage.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".embeddedMessage := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_embeddedMessage.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", protocolID := ");
if (match_value.protocolID().ispresent()) {
single_value->field_protocolID.log_match(match_value.protocolID(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_protocolID.log();
if (single_value->field_protocolID.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", spare_1_1 := ");
if (match_value.spare__1__1().ispresent()) {
single_value->field_spare__1__1.log_match(match_value.spare__1__1(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_spare__1__1.log();
if (single_value->field_spare__1__1.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", embeddedMessage := ");
if (match_value.embeddedMessage().ispresent()) {
single_value->field_embeddedMessage.log_match(match_value.embeddedMessage(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_embeddedMessage.log();
if (single_value->field_embeddedMessage.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__APDU_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (!protocolID().is_bound()) protocolID() = OMIT_VALUE;
else protocolID().set_implicit_omit();
if (!spare__1__1().is_bound()) spare__1__1() = OMIT_VALUE;
else spare__1__1().set_implicit_omit();
if (!embeddedMessage().is_bound()) embeddedMessage() = OMIT_VALUE;
else embeddedMessage().set_implicit_omit();
}

void BSSMAP__IE__APDU_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_protocolID.encode_text(text_buf);
single_value->field_spare__1__1.encode_text(text_buf);
single_value->field_embeddedMessage.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_APDU.");
}
}

void BSSMAP__IE__APDU_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_protocolID.decode_text(text_buf);
single_value->field_spare__1__1.decode_text(text_buf);
single_value->field_embeddedMessage.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__APDU_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_APDU.");
}
}

void BSSMAP__IE__APDU_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__APDU_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_APDU has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) protocolID().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare__1__1().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) embeddedMessage().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protocolID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protocolID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare_1_1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare__1__1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "embeddedMessage")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          embeddedMessage().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_APDU: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__APDU_template* precondition = new BSSMAP__IE__APDU_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__APDU_template* implied_template = new BSSMAP__IE__APDU_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__APDU_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_APDU");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__APDU_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_APDU");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_APDU");
single_value->field_protocolID.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_APDU");
single_value->field_spare__1__1.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_APDU");
single_value->field_embeddedMessage.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_APDU");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_APDU");
}

boolean BSSMAP__IE__APDU_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__APDU_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__NetworkElementIdentity::BSSMAP__IE__NetworkElementIdentity()
{
}

BSSMAP__IE__NetworkElementIdentity::BSSMAP__IE__NetworkElementIdentity(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const BITSTRING& par_iDDiscriminator,
    const BITSTRING& par_spare,
    const OCTETSTRING& par_networkElementIdentity)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_iDDiscriminator(par_iDDiscriminator),
  field_spare(par_spare),
  field_networkElementIdentity(par_networkElementIdentity)
{
}

BSSMAP__IE__NetworkElementIdentity::BSSMAP__IE__NetworkElementIdentity(const BSSMAP__IE__NetworkElementIdentity& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.iDDiscriminator().is_bound()) field_iDDiscriminator = other_value.iDDiscriminator();
else field_iDDiscriminator.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.networkElementIdentity().is_bound()) field_networkElementIdentity = other_value.networkElementIdentity();
else field_networkElementIdentity.clean_up();
}

void BSSMAP__IE__NetworkElementIdentity::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_iDDiscriminator.clean_up();
field_spare.clean_up();
field_networkElementIdentity.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__NetworkElementIdentity::get_descriptor() const { return &BSSMAP__IE__NetworkElementIdentity_descr_; }
BSSMAP__IE__NetworkElementIdentity& BSSMAP__IE__NetworkElementIdentity::operator=(const BSSMAP__IE__NetworkElementIdentity& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.iDDiscriminator().is_bound()) field_iDDiscriminator = other_value.iDDiscriminator();
  else field_iDDiscriminator.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.networkElementIdentity().is_bound()) field_networkElementIdentity = other_value.networkElementIdentity();
  else field_networkElementIdentity.clean_up();
}
return *this;
}

boolean BSSMAP__IE__NetworkElementIdentity::operator==(const BSSMAP__IE__NetworkElementIdentity& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_iDDiscriminator==other_value.field_iDDiscriminator
  && field_spare==other_value.field_spare
  && field_networkElementIdentity==other_value.field_networkElementIdentity;
}

boolean BSSMAP__IE__NetworkElementIdentity::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_iDDiscriminator.is_bound())
  || (field_spare.is_bound())
  || (field_networkElementIdentity.is_bound());
}
boolean BSSMAP__IE__NetworkElementIdentity::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_iDDiscriminator.is_value()
  && field_spare.is_value()
  && field_networkElementIdentity.is_value();
}
void BSSMAP__IE__NetworkElementIdentity::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", iDDiscriminator := ");
field_iDDiscriminator.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", networkElementIdentity := ");
field_networkElementIdentity.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__NetworkElementIdentity::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (iDDiscriminator().is_bound()) iDDiscriminator().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (networkElementIdentity().is_bound()) networkElementIdentity().set_implicit_omit();
}

void BSSMAP__IE__NetworkElementIdentity::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) iDDiscriminator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) networkElementIdentity().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iDDiscriminator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iDDiscriminator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "networkElementIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          networkElementIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_NetworkElementIdentity");
  }
}

void BSSMAP__IE__NetworkElementIdentity::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_iDDiscriminator.encode_text(text_buf);
field_spare.encode_text(text_buf);
field_networkElementIdentity.encode_text(text_buf);
}

void BSSMAP__IE__NetworkElementIdentity::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_iDDiscriminator.decode_text(text_buf);
field_spare.decode_text(text_buf);
field_networkElementIdentity.decode_text(text_buf);
}

void BSSMAP__IE__NetworkElementIdentity::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__NetworkElementIdentity::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__NetworkElementIdentity::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__NetworkElementIdentity_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__NetworkElementIdentity_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__NetworkElementIdentity_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_iDDiscriminator.RAW_decode(General__Types::BIT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::OCTN_descr_.raw->forceomit);
  decoded_field_length = field_networkElementIdentity.RAW_decode(General__Types::OCTN_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__NetworkElementIdentity::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__NetworkElementIdentity_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::OCTN_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__NetworkElementIdentity_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  encoded_length += field_iDDiscriminator.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_networkElementIdentity.RAW_encode(General__Types::OCTN_descr_, *myleaf.body.node.nodes[4]);
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__NetworkElementIdentity_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
BITSTRING_template field_iDDiscriminator;
BITSTRING_template field_spare;
OCTETSTRING_template field_networkElementIdentity;
};

void BSSMAP__IE__NetworkElementIdentity_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_iDDiscriminator = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
single_value->field_networkElementIdentity = ANY_VALUE;
}
}
}

void BSSMAP__IE__NetworkElementIdentity_template::copy_value(const BSSMAP__IE__NetworkElementIdentity& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.iDDiscriminator().is_bound()) {
  single_value->field_iDDiscriminator = other_value.iDDiscriminator();
} else {
  single_value->field_iDDiscriminator.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.networkElementIdentity().is_bound()) {
  single_value->field_networkElementIdentity = other_value.networkElementIdentity();
} else {
  single_value->field_networkElementIdentity.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__NetworkElementIdentity_template::copy_template(const BSSMAP__IE__NetworkElementIdentity_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.iDDiscriminator().get_selection()) {
single_value->field_iDDiscriminator = other_value.iDDiscriminator();
} else {
single_value->field_iDDiscriminator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.networkElementIdentity().get_selection()) {
single_value->field_networkElementIdentity = other_value.networkElementIdentity();
} else {
single_value->field_networkElementIdentity.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__NetworkElementIdentity_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__NetworkElementIdentity_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__NetworkElementIdentity_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__NetworkElementIdentity_template::BSSMAP__IE__NetworkElementIdentity_template()
{
}

BSSMAP__IE__NetworkElementIdentity_template::BSSMAP__IE__NetworkElementIdentity_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__NetworkElementIdentity_template::BSSMAP__IE__NetworkElementIdentity_template(const BSSMAP__IE__NetworkElementIdentity& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__NetworkElementIdentity_template::BSSMAP__IE__NetworkElementIdentity_template(const OPTIONAL<BSSMAP__IE__NetworkElementIdentity>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__NetworkElementIdentity&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity from an unbound optional field.");
}
}

BSSMAP__IE__NetworkElementIdentity_template::BSSMAP__IE__NetworkElementIdentity_template(BSSMAP__IE__NetworkElementIdentity_template* p_precondition, BSSMAP__IE__NetworkElementIdentity_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__NetworkElementIdentity_template::BSSMAP__IE__NetworkElementIdentity_template(Dynamic_Match_Interface<BSSMAP__IE__NetworkElementIdentity>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__NetworkElementIdentity>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__NetworkElementIdentity_template::BSSMAP__IE__NetworkElementIdentity_template(const BSSMAP__IE__NetworkElementIdentity_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__NetworkElementIdentity_template::~BSSMAP__IE__NetworkElementIdentity_template()
{
clean_up();
}

BSSMAP__IE__NetworkElementIdentity_template& BSSMAP__IE__NetworkElementIdentity_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__NetworkElementIdentity_template& BSSMAP__IE__NetworkElementIdentity_template::operator=(const BSSMAP__IE__NetworkElementIdentity& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__NetworkElementIdentity_template& BSSMAP__IE__NetworkElementIdentity_template::operator=(const OPTIONAL<BSSMAP__IE__NetworkElementIdentity>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__NetworkElementIdentity&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity.");
}
return *this;
}

BSSMAP__IE__NetworkElementIdentity_template& BSSMAP__IE__NetworkElementIdentity_template::operator=(const BSSMAP__IE__NetworkElementIdentity_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__NetworkElementIdentity_template::match(const BSSMAP__IE__NetworkElementIdentity& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.iDDiscriminator().is_bound()) return FALSE;
if(!single_value->field_iDDiscriminator.match(other_value.iDDiscriminator(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.networkElementIdentity().is_bound()) return FALSE;
if(!single_value->field_networkElementIdentity.match(other_value.networkElementIdentity(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity.");
}
return FALSE;
}

boolean BSSMAP__IE__NetworkElementIdentity_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_iDDiscriminator.is_bound()
 || single_value->field_spare.is_bound()
 || single_value->field_networkElementIdentity.is_bound();
}

boolean BSSMAP__IE__NetworkElementIdentity_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_iDDiscriminator.is_value()
 && single_value->field_spare.is_value()
 && single_value->field_networkElementIdentity.is_value();
}

void BSSMAP__IE__NetworkElementIdentity_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__NetworkElementIdentity BSSMAP__IE__NetworkElementIdentity_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity.");
BSSMAP__IE__NetworkElementIdentity ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_iDDiscriminator.is_bound()) {
ret_val.iDDiscriminator() = single_value->field_iDDiscriminator.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_networkElementIdentity.is_bound()) {
ret_val.networkElementIdentity() = single_value->field_networkElementIdentity.valueof();
}
return ret_val;
}

void BSSMAP__IE__NetworkElementIdentity_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__NetworkElementIdentity_template[list_length];
}

BSSMAP__IE__NetworkElementIdentity_template& BSSMAP__IE__NetworkElementIdentity_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__NetworkElementIdentity_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__NetworkElementIdentity_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__NetworkElementIdentity_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__NetworkElementIdentity_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& BSSMAP__IE__NetworkElementIdentity_template::iDDiscriminator()
{
set_specific();
return single_value->field_iDDiscriminator;
}

const BITSTRING_template& BSSMAP__IE__NetworkElementIdentity_template::iDDiscriminator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iDDiscriminator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity.");
return single_value->field_iDDiscriminator;
}

BITSTRING_template& BSSMAP__IE__NetworkElementIdentity_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& BSSMAP__IE__NetworkElementIdentity_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity.");
return single_value->field_spare;
}

OCTETSTRING_template& BSSMAP__IE__NetworkElementIdentity_template::networkElementIdentity()
{
set_specific();
return single_value->field_networkElementIdentity;
}

const OCTETSTRING_template& BSSMAP__IE__NetworkElementIdentity_template::networkElementIdentity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field networkElementIdentity of a non-specific template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity.");
return single_value->field_networkElementIdentity;
}

int BSSMAP__IE__NetworkElementIdentity_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity.");
  }
  return 0;
}

void BSSMAP__IE__NetworkElementIdentity_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", iDDiscriminator := ");
single_value->field_iDDiscriminator.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", networkElementIdentity := ");
single_value->field_networkElementIdentity.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__NetworkElementIdentity_template::log_match(const BSSMAP__IE__NetworkElementIdentity& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_iDDiscriminator.match(match_value.iDDiscriminator(), legacy)){
TTCN_Logger::log_logmatch_info(".iDDiscriminator");
single_value->field_iDDiscriminator.log_match(match_value.iDDiscriminator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_networkElementIdentity.match(match_value.networkElementIdentity(), legacy)){
TTCN_Logger::log_logmatch_info(".networkElementIdentity");
single_value->field_networkElementIdentity.log_match(match_value.networkElementIdentity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", iDDiscriminator := ");
single_value->field_iDDiscriminator.log_match(match_value.iDDiscriminator(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", networkElementIdentity := ");
single_value->field_networkElementIdentity.log_match(match_value.networkElementIdentity(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__NetworkElementIdentity_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (iDDiscriminator().is_bound()) iDDiscriminator().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (networkElementIdentity().is_bound()) networkElementIdentity().set_implicit_omit();
}

void BSSMAP__IE__NetworkElementIdentity_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_iDDiscriminator.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
single_value->field_networkElementIdentity.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity.");
}
}

void BSSMAP__IE__NetworkElementIdentity_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_iDDiscriminator.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
single_value->field_networkElementIdentity.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__NetworkElementIdentity_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity.");
}
}

void BSSMAP__IE__NetworkElementIdentity_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__NetworkElementIdentity_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) iDDiscriminator().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) networkElementIdentity().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iDDiscriminator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iDDiscriminator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "networkElementIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          networkElementIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_NetworkElementIdentity: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__NetworkElementIdentity_template* precondition = new BSSMAP__IE__NetworkElementIdentity_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__NetworkElementIdentity_template* implied_template = new BSSMAP__IE__NetworkElementIdentity_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__NetworkElementIdentity_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_NetworkElementIdentity");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__NetworkElementIdentity_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_NetworkElementIdentity");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_NetworkElementIdentity");
single_value->field_iDDiscriminator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_NetworkElementIdentity");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_NetworkElementIdentity");
single_value->field_networkElementIdentity.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_NetworkElementIdentity");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_NetworkElementIdentity");
}

boolean BSSMAP__IE__NetworkElementIdentity_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__NetworkElementIdentity_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__GPSAssistanceData::BSSMAP__IE__GPSAssistanceData()
{
}

BSSMAP__IE__GPSAssistanceData::BSSMAP__IE__GPSAssistanceData(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_a__to__h,
    const OCTETSTRING& par_i__to__p,
    const OCTETSTRING& par_satellite__related__data)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_a__to__h(par_a__to__h),
  field_i__to__p(par_i__to__p),
  field_satellite__related__data(par_satellite__related__data)
{
}

BSSMAP__IE__GPSAssistanceData::BSSMAP__IE__GPSAssistanceData(const BSSMAP__IE__GPSAssistanceData& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.a__to__h().is_bound()) field_a__to__h = other_value.a__to__h();
else field_a__to__h.clean_up();
if (other_value.i__to__p().is_bound()) field_i__to__p = other_value.i__to__p();
else field_i__to__p.clean_up();
if (other_value.satellite__related__data().is_bound()) field_satellite__related__data = other_value.satellite__related__data();
else field_satellite__related__data.clean_up();
}

void BSSMAP__IE__GPSAssistanceData::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_a__to__h.clean_up();
field_i__to__p.clean_up();
field_satellite__related__data.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__GPSAssistanceData::get_descriptor() const { return &BSSMAP__IE__GPSAssistanceData_descr_; }
BSSMAP__IE__GPSAssistanceData& BSSMAP__IE__GPSAssistanceData::operator=(const BSSMAP__IE__GPSAssistanceData& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.a__to__h().is_bound()) field_a__to__h = other_value.a__to__h();
  else field_a__to__h.clean_up();
  if (other_value.i__to__p().is_bound()) field_i__to__p = other_value.i__to__p();
  else field_i__to__p.clean_up();
  if (other_value.satellite__related__data().is_bound()) field_satellite__related__data = other_value.satellite__related__data();
  else field_satellite__related__data.clean_up();
}
return *this;
}

boolean BSSMAP__IE__GPSAssistanceData::operator==(const BSSMAP__IE__GPSAssistanceData& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_a__to__h==other_value.field_a__to__h
  && field_i__to__p==other_value.field_i__to__p
  && field_satellite__related__data==other_value.field_satellite__related__data;
}

boolean BSSMAP__IE__GPSAssistanceData::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_a__to__h.is_bound())
  || (field_i__to__p.is_bound())
  || (field_satellite__related__data.is_bound());
}
boolean BSSMAP__IE__GPSAssistanceData::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_a__to__h.is_value()
  && field_i__to__p.is_value()
  && field_satellite__related__data.is_value();
}
void BSSMAP__IE__GPSAssistanceData::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", a_to_h := ");
field_a__to__h.log();
TTCN_Logger::log_event_str(", i_to_p := ");
field_i__to__p.log();
TTCN_Logger::log_event_str(", satellite_related_data := ");
field_satellite__related__data.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__GPSAssistanceData::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (a__to__h().is_bound()) a__to__h().set_implicit_omit();
if (i__to__p().is_bound()) i__to__p().set_implicit_omit();
if (satellite__related__data().is_bound()) satellite__related__data().set_implicit_omit();
}

void BSSMAP__IE__GPSAssistanceData::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) a__to__h().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) i__to__p().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) satellite__related__data().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "a_to_h")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          a__to__h().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "i_to_p")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          i__to__p().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "satellite_related_data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          satellite__related__data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_GPSAssistanceData");
  }
}

void BSSMAP__IE__GPSAssistanceData::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_a__to__h.encode_text(text_buf);
field_i__to__p.encode_text(text_buf);
field_satellite__related__data.encode_text(text_buf);
}

void BSSMAP__IE__GPSAssistanceData::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_a__to__h.decode_text(text_buf);
field_i__to__p.decode_text(text_buf);
field_satellite__related__data.decode_text(text_buf);
}

void BSSMAP__IE__GPSAssistanceData::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__GPSAssistanceData::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__GPSAssistanceData::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__GPSAssistanceData_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__GPSAssistanceData_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__GPSAssistanceData_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_a__to__h.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_i__to__p.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::OCTN_descr_.raw->forceomit);
  decoded_field_length = field_satellite__related__data.RAW_decode(General__Types::OCTN_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_97) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__GPSAssistanceData::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__GPSAssistanceData_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::OCTN_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__GPSAssistanceData_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  encoded_length += field_a__to__h.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_i__to__p.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_satellite__related__data.RAW_encode(General__Types::OCTN_descr_, *myleaf.body.node.nodes[4]);
  if (field_elementIdentifier !=  os_97) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_97.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__GPSAssistanceData_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_a__to__h;
OCTETSTRING_template field_i__to__p;
OCTETSTRING_template field_satellite__related__data;
};

void BSSMAP__IE__GPSAssistanceData_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_a__to__h = ANY_VALUE;
single_value->field_i__to__p = ANY_VALUE;
single_value->field_satellite__related__data = ANY_VALUE;
}
}
}

void BSSMAP__IE__GPSAssistanceData_template::copy_value(const BSSMAP__IE__GPSAssistanceData& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.a__to__h().is_bound()) {
  single_value->field_a__to__h = other_value.a__to__h();
} else {
  single_value->field_a__to__h.clean_up();
}
if (other_value.i__to__p().is_bound()) {
  single_value->field_i__to__p = other_value.i__to__p();
} else {
  single_value->field_i__to__p.clean_up();
}
if (other_value.satellite__related__data().is_bound()) {
  single_value->field_satellite__related__data = other_value.satellite__related__data();
} else {
  single_value->field_satellite__related__data.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__GPSAssistanceData_template::copy_template(const BSSMAP__IE__GPSAssistanceData_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.a__to__h().get_selection()) {
single_value->field_a__to__h = other_value.a__to__h();
} else {
single_value->field_a__to__h.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.i__to__p().get_selection()) {
single_value->field_i__to__p = other_value.i__to__p();
} else {
single_value->field_i__to__p.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.satellite__related__data().get_selection()) {
single_value->field_satellite__related__data = other_value.satellite__related__data();
} else {
single_value->field_satellite__related__data.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__GPSAssistanceData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__GPSAssistanceData_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__GPSAssistanceData_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__GPSAssistanceData_template::BSSMAP__IE__GPSAssistanceData_template()
{
}

BSSMAP__IE__GPSAssistanceData_template::BSSMAP__IE__GPSAssistanceData_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__GPSAssistanceData_template::BSSMAP__IE__GPSAssistanceData_template(const BSSMAP__IE__GPSAssistanceData& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__GPSAssistanceData_template::BSSMAP__IE__GPSAssistanceData_template(const OPTIONAL<BSSMAP__IE__GPSAssistanceData>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__GPSAssistanceData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData from an unbound optional field.");
}
}

BSSMAP__IE__GPSAssistanceData_template::BSSMAP__IE__GPSAssistanceData_template(BSSMAP__IE__GPSAssistanceData_template* p_precondition, BSSMAP__IE__GPSAssistanceData_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__GPSAssistanceData_template::BSSMAP__IE__GPSAssistanceData_template(Dynamic_Match_Interface<BSSMAP__IE__GPSAssistanceData>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__GPSAssistanceData>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__GPSAssistanceData_template::BSSMAP__IE__GPSAssistanceData_template(const BSSMAP__IE__GPSAssistanceData_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__GPSAssistanceData_template::~BSSMAP__IE__GPSAssistanceData_template()
{
clean_up();
}

BSSMAP__IE__GPSAssistanceData_template& BSSMAP__IE__GPSAssistanceData_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__GPSAssistanceData_template& BSSMAP__IE__GPSAssistanceData_template::operator=(const BSSMAP__IE__GPSAssistanceData& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__GPSAssistanceData_template& BSSMAP__IE__GPSAssistanceData_template::operator=(const OPTIONAL<BSSMAP__IE__GPSAssistanceData>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__GPSAssistanceData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData.");
}
return *this;
}

BSSMAP__IE__GPSAssistanceData_template& BSSMAP__IE__GPSAssistanceData_template::operator=(const BSSMAP__IE__GPSAssistanceData_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__GPSAssistanceData_template::match(const BSSMAP__IE__GPSAssistanceData& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.a__to__h().is_bound()) return FALSE;
if(!single_value->field_a__to__h.match(other_value.a__to__h(), legacy))return FALSE;
if(!other_value.i__to__p().is_bound()) return FALSE;
if(!single_value->field_i__to__p.match(other_value.i__to__p(), legacy))return FALSE;
if(!other_value.satellite__related__data().is_bound()) return FALSE;
if(!single_value->field_satellite__related__data.match(other_value.satellite__related__data(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData.");
}
return FALSE;
}

boolean BSSMAP__IE__GPSAssistanceData_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_a__to__h.is_bound()
 || single_value->field_i__to__p.is_bound()
 || single_value->field_satellite__related__data.is_bound();
}

boolean BSSMAP__IE__GPSAssistanceData_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_a__to__h.is_value()
 && single_value->field_i__to__p.is_value()
 && single_value->field_satellite__related__data.is_value();
}

void BSSMAP__IE__GPSAssistanceData_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__GPSAssistanceData BSSMAP__IE__GPSAssistanceData_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData.");
BSSMAP__IE__GPSAssistanceData ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_a__to__h.is_bound()) {
ret_val.a__to__h() = single_value->field_a__to__h.valueof();
}
if (single_value->field_i__to__p.is_bound()) {
ret_val.i__to__p() = single_value->field_i__to__p.valueof();
}
if (single_value->field_satellite__related__data.is_bound()) {
ret_val.satellite__related__data() = single_value->field_satellite__related__data.valueof();
}
return ret_val;
}

void BSSMAP__IE__GPSAssistanceData_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__GPSAssistanceData_template[list_length];
}

BSSMAP__IE__GPSAssistanceData_template& BSSMAP__IE__GPSAssistanceData_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__GPSAssistanceData_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__GPSAssistanceData_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__GPSAssistanceData_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__GPSAssistanceData_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& BSSMAP__IE__GPSAssistanceData_template::a__to__h()
{
set_specific();
return single_value->field_a__to__h;
}

const OCTETSTRING_template& BSSMAP__IE__GPSAssistanceData_template::a__to__h() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field a_to_h of a non-specific template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData.");
return single_value->field_a__to__h;
}

OCTETSTRING_template& BSSMAP__IE__GPSAssistanceData_template::i__to__p()
{
set_specific();
return single_value->field_i__to__p;
}

const OCTETSTRING_template& BSSMAP__IE__GPSAssistanceData_template::i__to__p() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field i_to_p of a non-specific template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData.");
return single_value->field_i__to__p;
}

OCTETSTRING_template& BSSMAP__IE__GPSAssistanceData_template::satellite__related__data()
{
set_specific();
return single_value->field_satellite__related__data;
}

const OCTETSTRING_template& BSSMAP__IE__GPSAssistanceData_template::satellite__related__data() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field satellite_related_data of a non-specific template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData.");
return single_value->field_satellite__related__data;
}

int BSSMAP__IE__GPSAssistanceData_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData.");
  }
  return 0;
}

void BSSMAP__IE__GPSAssistanceData_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", a_to_h := ");
single_value->field_a__to__h.log();
TTCN_Logger::log_event_str(", i_to_p := ");
single_value->field_i__to__p.log();
TTCN_Logger::log_event_str(", satellite_related_data := ");
single_value->field_satellite__related__data.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__GPSAssistanceData_template::log_match(const BSSMAP__IE__GPSAssistanceData& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_a__to__h.match(match_value.a__to__h(), legacy)){
TTCN_Logger::log_logmatch_info(".a_to_h");
single_value->field_a__to__h.log_match(match_value.a__to__h(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_i__to__p.match(match_value.i__to__p(), legacy)){
TTCN_Logger::log_logmatch_info(".i_to_p");
single_value->field_i__to__p.log_match(match_value.i__to__p(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_satellite__related__data.match(match_value.satellite__related__data(), legacy)){
TTCN_Logger::log_logmatch_info(".satellite_related_data");
single_value->field_satellite__related__data.log_match(match_value.satellite__related__data(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", a_to_h := ");
single_value->field_a__to__h.log_match(match_value.a__to__h(), legacy);
TTCN_Logger::log_event_str(", i_to_p := ");
single_value->field_i__to__p.log_match(match_value.i__to__p(), legacy);
TTCN_Logger::log_event_str(", satellite_related_data := ");
single_value->field_satellite__related__data.log_match(match_value.satellite__related__data(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__GPSAssistanceData_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (a__to__h().is_bound()) a__to__h().set_implicit_omit();
if (i__to__p().is_bound()) i__to__p().set_implicit_omit();
if (satellite__related__data().is_bound()) satellite__related__data().set_implicit_omit();
}

void BSSMAP__IE__GPSAssistanceData_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_a__to__h.encode_text(text_buf);
single_value->field_i__to__p.encode_text(text_buf);
single_value->field_satellite__related__data.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData.");
}
}

void BSSMAP__IE__GPSAssistanceData_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_a__to__h.decode_text(text_buf);
single_value->field_i__to__p.decode_text(text_buf);
single_value->field_satellite__related__data.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__GPSAssistanceData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData.");
}
}

void BSSMAP__IE__GPSAssistanceData_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__GPSAssistanceData_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) a__to__h().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) i__to__p().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) satellite__related__data().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "a_to_h")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          a__to__h().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "i_to_p")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          i__to__p().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "satellite_related_data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          satellite__related__data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_GPSAssistanceData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__GPSAssistanceData_template* precondition = new BSSMAP__IE__GPSAssistanceData_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__GPSAssistanceData_template* implied_template = new BSSMAP__IE__GPSAssistanceData_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__GPSAssistanceData_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_GPSAssistanceData");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__GPSAssistanceData_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_GPSAssistanceData");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_GPSAssistanceData");
single_value->field_a__to__h.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_GPSAssistanceData");
single_value->field_i__to__p.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_GPSAssistanceData");
single_value->field_satellite__related__data.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_GPSAssistanceData");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_GPSAssistanceData");
}

boolean BSSMAP__IE__GPSAssistanceData_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__GPSAssistanceData_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__DecipheringKeys::BSSMAP__IE__DecipheringKeys()
{
}

BSSMAP__IE__DecipheringKeys::BSSMAP__IE__DecipheringKeys(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const BITSTRING& par_cipheringKeyFlag,
    const BITSTRING& par_currentdecipheringKeyValue,
    const OPTIONAL< BITSTRING >& par_nextdecipheringKeyValue)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_cipheringKeyFlag(par_cipheringKeyFlag),
  field_currentdecipheringKeyValue(par_currentdecipheringKeyValue),
  field_nextdecipheringKeyValue(par_nextdecipheringKeyValue)
{
}

BSSMAP__IE__DecipheringKeys::BSSMAP__IE__DecipheringKeys(const BSSMAP__IE__DecipheringKeys& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.cipheringKeyFlag().is_bound()) field_cipheringKeyFlag = other_value.cipheringKeyFlag();
else field_cipheringKeyFlag.clean_up();
if (other_value.currentdecipheringKeyValue().is_bound()) field_currentdecipheringKeyValue = other_value.currentdecipheringKeyValue();
else field_currentdecipheringKeyValue.clean_up();
if (other_value.nextdecipheringKeyValue().is_bound()) field_nextdecipheringKeyValue = other_value.nextdecipheringKeyValue();
else field_nextdecipheringKeyValue.clean_up();
}

void BSSMAP__IE__DecipheringKeys::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_cipheringKeyFlag.clean_up();
field_currentdecipheringKeyValue.clean_up();
field_nextdecipheringKeyValue.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__DecipheringKeys::get_descriptor() const { return &BSSMAP__IE__DecipheringKeys_descr_; }
BSSMAP__IE__DecipheringKeys& BSSMAP__IE__DecipheringKeys::operator=(const BSSMAP__IE__DecipheringKeys& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.cipheringKeyFlag().is_bound()) field_cipheringKeyFlag = other_value.cipheringKeyFlag();
  else field_cipheringKeyFlag.clean_up();
  if (other_value.currentdecipheringKeyValue().is_bound()) field_currentdecipheringKeyValue = other_value.currentdecipheringKeyValue();
  else field_currentdecipheringKeyValue.clean_up();
  if (other_value.nextdecipheringKeyValue().is_bound()) field_nextdecipheringKeyValue = other_value.nextdecipheringKeyValue();
  else field_nextdecipheringKeyValue.clean_up();
}
return *this;
}

boolean BSSMAP__IE__DecipheringKeys::operator==(const BSSMAP__IE__DecipheringKeys& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_cipheringKeyFlag==other_value.field_cipheringKeyFlag
  && field_currentdecipheringKeyValue==other_value.field_currentdecipheringKeyValue
  && field_nextdecipheringKeyValue==other_value.field_nextdecipheringKeyValue;
}

boolean BSSMAP__IE__DecipheringKeys::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_cipheringKeyFlag.is_bound())
  || (field_currentdecipheringKeyValue.is_bound())
  || (OPTIONAL_OMIT == field_nextdecipheringKeyValue.get_selection() || field_nextdecipheringKeyValue.is_bound());
}
boolean BSSMAP__IE__DecipheringKeys::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_cipheringKeyFlag.is_value()
  && field_currentdecipheringKeyValue.is_value()
  && (OPTIONAL_OMIT == field_nextdecipheringKeyValue.get_selection() || field_nextdecipheringKeyValue.is_value());
}
int BSSMAP__IE__DecipheringKeys::size_of() const
{
  int ret_val = 4;
  if (field_nextdecipheringKeyValue.ispresent()) ret_val++;
  return ret_val;
}

void BSSMAP__IE__DecipheringKeys::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", cipheringKeyFlag := ");
field_cipheringKeyFlag.log();
TTCN_Logger::log_event_str(", currentdecipheringKeyValue := ");
field_currentdecipheringKeyValue.log();
TTCN_Logger::log_event_str(", nextdecipheringKeyValue := ");
field_nextdecipheringKeyValue.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__DecipheringKeys::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (cipheringKeyFlag().is_bound()) cipheringKeyFlag().set_implicit_omit();
if (currentdecipheringKeyValue().is_bound()) currentdecipheringKeyValue().set_implicit_omit();
if (!nextdecipheringKeyValue().is_bound()) nextdecipheringKeyValue() = OMIT_VALUE;
else nextdecipheringKeyValue().set_implicit_omit();
}

void BSSMAP__IE__DecipheringKeys::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cipheringKeyFlag().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) currentdecipheringKeyValue().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) nextdecipheringKeyValue().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cipheringKeyFlag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cipheringKeyFlag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "currentdecipheringKeyValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          currentdecipheringKeyValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nextdecipheringKeyValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nextdecipheringKeyValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_DecipheringKeys: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_DecipheringKeys");
  }
}

void BSSMAP__IE__DecipheringKeys::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_cipheringKeyFlag.encode_text(text_buf);
field_currentdecipheringKeyValue.encode_text(text_buf);
field_nextdecipheringKeyValue.encode_text(text_buf);
}

void BSSMAP__IE__DecipheringKeys::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_cipheringKeyFlag.decode_text(text_buf);
field_currentdecipheringKeyValue.decode_text(text_buf);
field_nextdecipheringKeyValue.decode_text(text_buf);
}

void BSSMAP__IE__DecipheringKeys::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__DecipheringKeys::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__DecipheringKeys::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__DecipheringKeys_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__DecipheringKeys_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__DecipheringKeys_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT8_descr_.raw->forceomit);
  decoded_field_length = field_cipheringKeyFlag.RAW_decode(General__Types::BIT8_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT56_descr_.raw->forceomit);
  decoded_field_length = field_currentdecipheringKeyValue.RAW_decode(General__Types::BIT56_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (limit > 0 && value_of_length_field1 > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_nextdecipheringKeyValue = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::BIT56_descr_.raw->forceomit);
  decoded_field_length = field_nextdecipheringKeyValue().RAW_decode(General__Types::BIT56_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_nextdecipheringKeyValue = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  }
  }
  }
  else field_nextdecipheringKeyValue=OMIT_VALUE;
  if (field_elementIdentifier !=  os_101) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__DecipheringKeys::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__DecipheringKeys_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT8_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT56_descr_.raw);
  if (field_nextdecipheringKeyValue.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::BIT56_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__DecipheringKeys_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  if (field_nextdecipheringKeyValue.ispresent()) {
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  } else {
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = 0;
  }
  encoded_length += field_cipheringKeyFlag.RAW_encode(General__Types::BIT8_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_currentdecipheringKeyValue.RAW_encode(General__Types::BIT56_descr_, *myleaf.body.node.nodes[3]);
  if (field_nextdecipheringKeyValue.ispresent()) {
  encoded_length += field_nextdecipheringKeyValue().RAW_encode(General__Types::BIT56_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_elementIdentifier !=  os_101) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_101.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__DecipheringKeys_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
BITSTRING_template field_cipheringKeyFlag;
BITSTRING_template field_currentdecipheringKeyValue;
BITSTRING_template field_nextdecipheringKeyValue;
};

void BSSMAP__IE__DecipheringKeys_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_cipheringKeyFlag = ANY_VALUE;
single_value->field_currentdecipheringKeyValue = ANY_VALUE;
single_value->field_nextdecipheringKeyValue = ANY_OR_OMIT;
}
}
}

void BSSMAP__IE__DecipheringKeys_template::copy_value(const BSSMAP__IE__DecipheringKeys& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.cipheringKeyFlag().is_bound()) {
  single_value->field_cipheringKeyFlag = other_value.cipheringKeyFlag();
} else {
  single_value->field_cipheringKeyFlag.clean_up();
}
if (other_value.currentdecipheringKeyValue().is_bound()) {
  single_value->field_currentdecipheringKeyValue = other_value.currentdecipheringKeyValue();
} else {
  single_value->field_currentdecipheringKeyValue.clean_up();
}
if (other_value.nextdecipheringKeyValue().is_bound()) {
  if (other_value.nextdecipheringKeyValue().ispresent()) single_value->field_nextdecipheringKeyValue = other_value.nextdecipheringKeyValue()();
  else single_value->field_nextdecipheringKeyValue = OMIT_VALUE;
} else {
  single_value->field_nextdecipheringKeyValue.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__DecipheringKeys_template::copy_template(const BSSMAP__IE__DecipheringKeys_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cipheringKeyFlag().get_selection()) {
single_value->field_cipheringKeyFlag = other_value.cipheringKeyFlag();
} else {
single_value->field_cipheringKeyFlag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.currentdecipheringKeyValue().get_selection()) {
single_value->field_currentdecipheringKeyValue = other_value.currentdecipheringKeyValue();
} else {
single_value->field_currentdecipheringKeyValue.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nextdecipheringKeyValue().get_selection()) {
single_value->field_nextdecipheringKeyValue = other_value.nextdecipheringKeyValue();
} else {
single_value->field_nextdecipheringKeyValue.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__DecipheringKeys_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__DecipheringKeys_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__DecipheringKeys_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__DecipheringKeys_template::BSSMAP__IE__DecipheringKeys_template()
{
}

BSSMAP__IE__DecipheringKeys_template::BSSMAP__IE__DecipheringKeys_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__DecipheringKeys_template::BSSMAP__IE__DecipheringKeys_template(const BSSMAP__IE__DecipheringKeys& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__DecipheringKeys_template::BSSMAP__IE__DecipheringKeys_template(const OPTIONAL<BSSMAP__IE__DecipheringKeys>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__DecipheringKeys&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys from an unbound optional field.");
}
}

BSSMAP__IE__DecipheringKeys_template::BSSMAP__IE__DecipheringKeys_template(BSSMAP__IE__DecipheringKeys_template* p_precondition, BSSMAP__IE__DecipheringKeys_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__DecipheringKeys_template::BSSMAP__IE__DecipheringKeys_template(Dynamic_Match_Interface<BSSMAP__IE__DecipheringKeys>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__DecipheringKeys>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__DecipheringKeys_template::BSSMAP__IE__DecipheringKeys_template(const BSSMAP__IE__DecipheringKeys_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__DecipheringKeys_template::~BSSMAP__IE__DecipheringKeys_template()
{
clean_up();
}

BSSMAP__IE__DecipheringKeys_template& BSSMAP__IE__DecipheringKeys_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__DecipheringKeys_template& BSSMAP__IE__DecipheringKeys_template::operator=(const BSSMAP__IE__DecipheringKeys& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__DecipheringKeys_template& BSSMAP__IE__DecipheringKeys_template::operator=(const OPTIONAL<BSSMAP__IE__DecipheringKeys>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__DecipheringKeys&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys.");
}
return *this;
}

BSSMAP__IE__DecipheringKeys_template& BSSMAP__IE__DecipheringKeys_template::operator=(const BSSMAP__IE__DecipheringKeys_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__DecipheringKeys_template::match(const BSSMAP__IE__DecipheringKeys& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.cipheringKeyFlag().is_bound()) return FALSE;
if(!single_value->field_cipheringKeyFlag.match(other_value.cipheringKeyFlag(), legacy))return FALSE;
if(!other_value.currentdecipheringKeyValue().is_bound()) return FALSE;
if(!single_value->field_currentdecipheringKeyValue.match(other_value.currentdecipheringKeyValue(), legacy))return FALSE;
if(!other_value.nextdecipheringKeyValue().is_bound()) return FALSE;
if((other_value.nextdecipheringKeyValue().ispresent() ? !single_value->field_nextdecipheringKeyValue.match((const BITSTRING&)other_value.nextdecipheringKeyValue(), legacy) : !single_value->field_nextdecipheringKeyValue.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys.");
}
return FALSE;
}

boolean BSSMAP__IE__DecipheringKeys_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_cipheringKeyFlag.is_bound()
 || single_value->field_currentdecipheringKeyValue.is_bound()
 || (single_value->field_nextdecipheringKeyValue.is_omit() || single_value->field_nextdecipheringKeyValue.is_bound());
}

boolean BSSMAP__IE__DecipheringKeys_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_cipheringKeyFlag.is_value()
 && single_value->field_currentdecipheringKeyValue.is_value()
 && (single_value->field_nextdecipheringKeyValue.is_omit() || single_value->field_nextdecipheringKeyValue.is_value());
}

void BSSMAP__IE__DecipheringKeys_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__DecipheringKeys BSSMAP__IE__DecipheringKeys_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys.");
BSSMAP__IE__DecipheringKeys ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_cipheringKeyFlag.is_bound()) {
ret_val.cipheringKeyFlag() = single_value->field_cipheringKeyFlag.valueof();
}
if (single_value->field_currentdecipheringKeyValue.is_bound()) {
ret_val.currentdecipheringKeyValue() = single_value->field_currentdecipheringKeyValue.valueof();
}
if (single_value->field_nextdecipheringKeyValue.is_omit()) ret_val.nextdecipheringKeyValue() = OMIT_VALUE;
else if (single_value->field_nextdecipheringKeyValue.is_bound()) {
ret_val.nextdecipheringKeyValue() = single_value->field_nextdecipheringKeyValue.valueof();
}
return ret_val;
}

void BSSMAP__IE__DecipheringKeys_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__DecipheringKeys_template[list_length];
}

BSSMAP__IE__DecipheringKeys_template& BSSMAP__IE__DecipheringKeys_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__DecipheringKeys_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__DecipheringKeys_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__DecipheringKeys_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__DecipheringKeys_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& BSSMAP__IE__DecipheringKeys_template::cipheringKeyFlag()
{
set_specific();
return single_value->field_cipheringKeyFlag;
}

const BITSTRING_template& BSSMAP__IE__DecipheringKeys_template::cipheringKeyFlag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cipheringKeyFlag of a non-specific template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys.");
return single_value->field_cipheringKeyFlag;
}

BITSTRING_template& BSSMAP__IE__DecipheringKeys_template::currentdecipheringKeyValue()
{
set_specific();
return single_value->field_currentdecipheringKeyValue;
}

const BITSTRING_template& BSSMAP__IE__DecipheringKeys_template::currentdecipheringKeyValue() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field currentdecipheringKeyValue of a non-specific template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys.");
return single_value->field_currentdecipheringKeyValue;
}

BITSTRING_template& BSSMAP__IE__DecipheringKeys_template::nextdecipheringKeyValue()
{
set_specific();
return single_value->field_nextdecipheringKeyValue;
}

const BITSTRING_template& BSSMAP__IE__DecipheringKeys_template::nextdecipheringKeyValue() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nextdecipheringKeyValue of a non-specific template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys.");
return single_value->field_nextdecipheringKeyValue;
}

int BSSMAP__IE__DecipheringKeys_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 4;
      if (single_value->field_nextdecipheringKeyValue.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys.");
  }
  return 0;
}

void BSSMAP__IE__DecipheringKeys_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", cipheringKeyFlag := ");
single_value->field_cipheringKeyFlag.log();
TTCN_Logger::log_event_str(", currentdecipheringKeyValue := ");
single_value->field_currentdecipheringKeyValue.log();
TTCN_Logger::log_event_str(", nextdecipheringKeyValue := ");
single_value->field_nextdecipheringKeyValue.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__DecipheringKeys_template::log_match(const BSSMAP__IE__DecipheringKeys& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cipheringKeyFlag.match(match_value.cipheringKeyFlag(), legacy)){
TTCN_Logger::log_logmatch_info(".cipheringKeyFlag");
single_value->field_cipheringKeyFlag.log_match(match_value.cipheringKeyFlag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_currentdecipheringKeyValue.match(match_value.currentdecipheringKeyValue(), legacy)){
TTCN_Logger::log_logmatch_info(".currentdecipheringKeyValue");
single_value->field_currentdecipheringKeyValue.log_match(match_value.currentdecipheringKeyValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.nextdecipheringKeyValue().ispresent()){
if(!single_value->field_nextdecipheringKeyValue.match(match_value.nextdecipheringKeyValue(), legacy)){
TTCN_Logger::log_logmatch_info(".nextdecipheringKeyValue");
single_value->field_nextdecipheringKeyValue.log_match(match_value.nextdecipheringKeyValue(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_nextdecipheringKeyValue.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".nextdecipheringKeyValue := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_nextdecipheringKeyValue.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", cipheringKeyFlag := ");
single_value->field_cipheringKeyFlag.log_match(match_value.cipheringKeyFlag(), legacy);
TTCN_Logger::log_event_str(", currentdecipheringKeyValue := ");
single_value->field_currentdecipheringKeyValue.log_match(match_value.currentdecipheringKeyValue(), legacy);
TTCN_Logger::log_event_str(", nextdecipheringKeyValue := ");
if (match_value.nextdecipheringKeyValue().ispresent()) {
single_value->field_nextdecipheringKeyValue.log_match(match_value.nextdecipheringKeyValue(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_nextdecipheringKeyValue.log();
if (single_value->field_nextdecipheringKeyValue.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__DecipheringKeys_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (cipheringKeyFlag().is_bound()) cipheringKeyFlag().set_implicit_omit();
if (currentdecipheringKeyValue().is_bound()) currentdecipheringKeyValue().set_implicit_omit();
if (!nextdecipheringKeyValue().is_bound()) nextdecipheringKeyValue() = OMIT_VALUE;
else nextdecipheringKeyValue().set_implicit_omit();
}

void BSSMAP__IE__DecipheringKeys_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_cipheringKeyFlag.encode_text(text_buf);
single_value->field_currentdecipheringKeyValue.encode_text(text_buf);
single_value->field_nextdecipheringKeyValue.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys.");
}
}

void BSSMAP__IE__DecipheringKeys_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_cipheringKeyFlag.decode_text(text_buf);
single_value->field_currentdecipheringKeyValue.decode_text(text_buf);
single_value->field_nextdecipheringKeyValue.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__DecipheringKeys_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys.");
}
}

void BSSMAP__IE__DecipheringKeys_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__DecipheringKeys_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_DecipheringKeys has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cipheringKeyFlag().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) currentdecipheringKeyValue().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) nextdecipheringKeyValue().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cipheringKeyFlag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cipheringKeyFlag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "currentdecipheringKeyValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          currentdecipheringKeyValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nextdecipheringKeyValue")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nextdecipheringKeyValue().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_DecipheringKeys: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__DecipheringKeys_template* precondition = new BSSMAP__IE__DecipheringKeys_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__DecipheringKeys_template* implied_template = new BSSMAP__IE__DecipheringKeys_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__DecipheringKeys_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_DecipheringKeys");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__DecipheringKeys_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_DecipheringKeys");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_DecipheringKeys");
single_value->field_cipheringKeyFlag.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_DecipheringKeys");
single_value->field_currentdecipheringKeyValue.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_DecipheringKeys");
single_value->field_nextdecipheringKeyValue.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_DecipheringKeys");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_DecipheringKeys");
}

boolean BSSMAP__IE__DecipheringKeys_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__DecipheringKeys_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__ReturnErrorRequest::BSSMAP__IE__ReturnErrorRequest()
{
}

BSSMAP__IE__ReturnErrorRequest::BSSMAP__IE__ReturnErrorRequest(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_returnErrorType)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_returnErrorType(par_returnErrorType)
{
}

BSSMAP__IE__ReturnErrorRequest::BSSMAP__IE__ReturnErrorRequest(const BSSMAP__IE__ReturnErrorRequest& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.returnErrorType().is_bound()) field_returnErrorType = other_value.returnErrorType();
else field_returnErrorType.clean_up();
}

void BSSMAP__IE__ReturnErrorRequest::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_returnErrorType.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__ReturnErrorRequest::get_descriptor() const { return &BSSMAP__IE__ReturnErrorRequest_descr_; }
BSSMAP__IE__ReturnErrorRequest& BSSMAP__IE__ReturnErrorRequest::operator=(const BSSMAP__IE__ReturnErrorRequest& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.returnErrorType().is_bound()) field_returnErrorType = other_value.returnErrorType();
  else field_returnErrorType.clean_up();
}
return *this;
}

boolean BSSMAP__IE__ReturnErrorRequest::operator==(const BSSMAP__IE__ReturnErrorRequest& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_returnErrorType==other_value.field_returnErrorType;
}

boolean BSSMAP__IE__ReturnErrorRequest::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_returnErrorType.is_bound());
}
boolean BSSMAP__IE__ReturnErrorRequest::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_returnErrorType.is_value();
}
void BSSMAP__IE__ReturnErrorRequest::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", returnErrorType := ");
field_returnErrorType.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__ReturnErrorRequest::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (returnErrorType().is_bound()) returnErrorType().set_implicit_omit();
}

void BSSMAP__IE__ReturnErrorRequest::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) returnErrorType().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "returnErrorType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          returnErrorType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_ReturnErrorRequest");
  }
}

void BSSMAP__IE__ReturnErrorRequest::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_returnErrorType.encode_text(text_buf);
}

void BSSMAP__IE__ReturnErrorRequest::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_returnErrorType.decode_text(text_buf);
}

void BSSMAP__IE__ReturnErrorRequest::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__ReturnErrorRequest::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__ReturnErrorRequest::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__ReturnErrorRequest_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__ReturnErrorRequest_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__ReturnErrorRequest_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_returnErrorType.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_70) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__ReturnErrorRequest::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__ReturnErrorRequest_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT1_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__ReturnErrorRequest_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_returnErrorType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier !=  os_70) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_70.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__ReturnErrorRequest_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_returnErrorType;
};

void BSSMAP__IE__ReturnErrorRequest_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_returnErrorType = ANY_VALUE;
}
}
}

void BSSMAP__IE__ReturnErrorRequest_template::copy_value(const BSSMAP__IE__ReturnErrorRequest& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.returnErrorType().is_bound()) {
  single_value->field_returnErrorType = other_value.returnErrorType();
} else {
  single_value->field_returnErrorType.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__ReturnErrorRequest_template::copy_template(const BSSMAP__IE__ReturnErrorRequest_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.returnErrorType().get_selection()) {
single_value->field_returnErrorType = other_value.returnErrorType();
} else {
single_value->field_returnErrorType.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__ReturnErrorRequest_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__ReturnErrorRequest_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__ReturnErrorRequest_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__ReturnErrorRequest_template::BSSMAP__IE__ReturnErrorRequest_template()
{
}

BSSMAP__IE__ReturnErrorRequest_template::BSSMAP__IE__ReturnErrorRequest_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__ReturnErrorRequest_template::BSSMAP__IE__ReturnErrorRequest_template(const BSSMAP__IE__ReturnErrorRequest& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__ReturnErrorRequest_template::BSSMAP__IE__ReturnErrorRequest_template(const OPTIONAL<BSSMAP__IE__ReturnErrorRequest>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__ReturnErrorRequest&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest from an unbound optional field.");
}
}

BSSMAP__IE__ReturnErrorRequest_template::BSSMAP__IE__ReturnErrorRequest_template(BSSMAP__IE__ReturnErrorRequest_template* p_precondition, BSSMAP__IE__ReturnErrorRequest_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__ReturnErrorRequest_template::BSSMAP__IE__ReturnErrorRequest_template(Dynamic_Match_Interface<BSSMAP__IE__ReturnErrorRequest>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__ReturnErrorRequest>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__ReturnErrorRequest_template::BSSMAP__IE__ReturnErrorRequest_template(const BSSMAP__IE__ReturnErrorRequest_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__ReturnErrorRequest_template::~BSSMAP__IE__ReturnErrorRequest_template()
{
clean_up();
}

BSSMAP__IE__ReturnErrorRequest_template& BSSMAP__IE__ReturnErrorRequest_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__ReturnErrorRequest_template& BSSMAP__IE__ReturnErrorRequest_template::operator=(const BSSMAP__IE__ReturnErrorRequest& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__ReturnErrorRequest_template& BSSMAP__IE__ReturnErrorRequest_template::operator=(const OPTIONAL<BSSMAP__IE__ReturnErrorRequest>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__ReturnErrorRequest&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest.");
}
return *this;
}

BSSMAP__IE__ReturnErrorRequest_template& BSSMAP__IE__ReturnErrorRequest_template::operator=(const BSSMAP__IE__ReturnErrorRequest_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__ReturnErrorRequest_template::match(const BSSMAP__IE__ReturnErrorRequest& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.returnErrorType().is_bound()) return FALSE;
if(!single_value->field_returnErrorType.match(other_value.returnErrorType(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest.");
}
return FALSE;
}

boolean BSSMAP__IE__ReturnErrorRequest_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_returnErrorType.is_bound();
}

boolean BSSMAP__IE__ReturnErrorRequest_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_returnErrorType.is_value();
}

void BSSMAP__IE__ReturnErrorRequest_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__ReturnErrorRequest BSSMAP__IE__ReturnErrorRequest_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest.");
BSSMAP__IE__ReturnErrorRequest ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_returnErrorType.is_bound()) {
ret_val.returnErrorType() = single_value->field_returnErrorType.valueof();
}
return ret_val;
}

void BSSMAP__IE__ReturnErrorRequest_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__ReturnErrorRequest_template[list_length];
}

BSSMAP__IE__ReturnErrorRequest_template& BSSMAP__IE__ReturnErrorRequest_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__ReturnErrorRequest_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__ReturnErrorRequest_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__ReturnErrorRequest_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__ReturnErrorRequest_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& BSSMAP__IE__ReturnErrorRequest_template::returnErrorType()
{
set_specific();
return single_value->field_returnErrorType;
}

const OCTETSTRING_template& BSSMAP__IE__ReturnErrorRequest_template::returnErrorType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field returnErrorType of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest.");
return single_value->field_returnErrorType;
}

int BSSMAP__IE__ReturnErrorRequest_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest.");
  }
  return 0;
}

void BSSMAP__IE__ReturnErrorRequest_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", returnErrorType := ");
single_value->field_returnErrorType.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__ReturnErrorRequest_template::log_match(const BSSMAP__IE__ReturnErrorRequest& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_returnErrorType.match(match_value.returnErrorType(), legacy)){
TTCN_Logger::log_logmatch_info(".returnErrorType");
single_value->field_returnErrorType.log_match(match_value.returnErrorType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", returnErrorType := ");
single_value->field_returnErrorType.log_match(match_value.returnErrorType(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__ReturnErrorRequest_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (returnErrorType().is_bound()) returnErrorType().set_implicit_omit();
}

void BSSMAP__IE__ReturnErrorRequest_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_returnErrorType.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest.");
}
}

void BSSMAP__IE__ReturnErrorRequest_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_returnErrorType.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__ReturnErrorRequest_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest.");
}
}

void BSSMAP__IE__ReturnErrorRequest_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__ReturnErrorRequest_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) returnErrorType().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "returnErrorType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          returnErrorType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_ReturnErrorRequest: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__ReturnErrorRequest_template* precondition = new BSSMAP__IE__ReturnErrorRequest_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__ReturnErrorRequest_template* implied_template = new BSSMAP__IE__ReturnErrorRequest_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__ReturnErrorRequest_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_ReturnErrorRequest");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__ReturnErrorRequest_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ReturnErrorRequest");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ReturnErrorRequest");
single_value->field_returnErrorType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ReturnErrorRequest");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ReturnErrorRequest");
}

boolean BSSMAP__IE__ReturnErrorRequest_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__ReturnErrorRequest_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__ReturnErrorCause::BSSMAP__IE__ReturnErrorCause()
{
}

BSSMAP__IE__ReturnErrorCause::BSSMAP__IE__ReturnErrorCause(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_returnErrorCause)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_returnErrorCause(par_returnErrorCause)
{
}

BSSMAP__IE__ReturnErrorCause::BSSMAP__IE__ReturnErrorCause(const BSSMAP__IE__ReturnErrorCause& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.returnErrorCause().is_bound()) field_returnErrorCause = other_value.returnErrorCause();
else field_returnErrorCause.clean_up();
}

void BSSMAP__IE__ReturnErrorCause::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_returnErrorCause.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__ReturnErrorCause::get_descriptor() const { return &BSSMAP__IE__ReturnErrorCause_descr_; }
BSSMAP__IE__ReturnErrorCause& BSSMAP__IE__ReturnErrorCause::operator=(const BSSMAP__IE__ReturnErrorCause& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.returnErrorCause().is_bound()) field_returnErrorCause = other_value.returnErrorCause();
  else field_returnErrorCause.clean_up();
}
return *this;
}

boolean BSSMAP__IE__ReturnErrorCause::operator==(const BSSMAP__IE__ReturnErrorCause& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_returnErrorCause==other_value.field_returnErrorCause;
}

boolean BSSMAP__IE__ReturnErrorCause::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_returnErrorCause.is_bound());
}
boolean BSSMAP__IE__ReturnErrorCause::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_returnErrorCause.is_value();
}
void BSSMAP__IE__ReturnErrorCause::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", returnErrorCause := ");
field_returnErrorCause.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__ReturnErrorCause::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (returnErrorCause().is_bound()) returnErrorCause().set_implicit_omit();
}

void BSSMAP__IE__ReturnErrorCause::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) returnErrorCause().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "returnErrorCause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          returnErrorCause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_ReturnErrorCause");
  }
}

void BSSMAP__IE__ReturnErrorCause::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_returnErrorCause.encode_text(text_buf);
}

void BSSMAP__IE__ReturnErrorCause::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_returnErrorCause.decode_text(text_buf);
}

void BSSMAP__IE__ReturnErrorCause::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__ReturnErrorCause::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__ReturnErrorCause::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__ReturnErrorCause_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__ReturnErrorCause_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__ReturnErrorCause_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_returnErrorCause.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_44) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__ReturnErrorCause::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__ReturnErrorCause_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT1_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__ReturnErrorCause_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_returnErrorCause.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier !=  os_44) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_44.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__ReturnErrorCause_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_returnErrorCause;
};

void BSSMAP__IE__ReturnErrorCause_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_returnErrorCause = ANY_VALUE;
}
}
}

void BSSMAP__IE__ReturnErrorCause_template::copy_value(const BSSMAP__IE__ReturnErrorCause& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.returnErrorCause().is_bound()) {
  single_value->field_returnErrorCause = other_value.returnErrorCause();
} else {
  single_value->field_returnErrorCause.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__ReturnErrorCause_template::copy_template(const BSSMAP__IE__ReturnErrorCause_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.returnErrorCause().get_selection()) {
single_value->field_returnErrorCause = other_value.returnErrorCause();
} else {
single_value->field_returnErrorCause.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__ReturnErrorCause_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__ReturnErrorCause_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__ReturnErrorCause_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__ReturnErrorCause_template::BSSMAP__IE__ReturnErrorCause_template()
{
}

BSSMAP__IE__ReturnErrorCause_template::BSSMAP__IE__ReturnErrorCause_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__ReturnErrorCause_template::BSSMAP__IE__ReturnErrorCause_template(const BSSMAP__IE__ReturnErrorCause& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__ReturnErrorCause_template::BSSMAP__IE__ReturnErrorCause_template(const OPTIONAL<BSSMAP__IE__ReturnErrorCause>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__ReturnErrorCause&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause from an unbound optional field.");
}
}

BSSMAP__IE__ReturnErrorCause_template::BSSMAP__IE__ReturnErrorCause_template(BSSMAP__IE__ReturnErrorCause_template* p_precondition, BSSMAP__IE__ReturnErrorCause_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__ReturnErrorCause_template::BSSMAP__IE__ReturnErrorCause_template(Dynamic_Match_Interface<BSSMAP__IE__ReturnErrorCause>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__ReturnErrorCause>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__ReturnErrorCause_template::BSSMAP__IE__ReturnErrorCause_template(const BSSMAP__IE__ReturnErrorCause_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__ReturnErrorCause_template::~BSSMAP__IE__ReturnErrorCause_template()
{
clean_up();
}

BSSMAP__IE__ReturnErrorCause_template& BSSMAP__IE__ReturnErrorCause_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__ReturnErrorCause_template& BSSMAP__IE__ReturnErrorCause_template::operator=(const BSSMAP__IE__ReturnErrorCause& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__ReturnErrorCause_template& BSSMAP__IE__ReturnErrorCause_template::operator=(const OPTIONAL<BSSMAP__IE__ReturnErrorCause>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__ReturnErrorCause&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause.");
}
return *this;
}

BSSMAP__IE__ReturnErrorCause_template& BSSMAP__IE__ReturnErrorCause_template::operator=(const BSSMAP__IE__ReturnErrorCause_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__ReturnErrorCause_template::match(const BSSMAP__IE__ReturnErrorCause& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.returnErrorCause().is_bound()) return FALSE;
if(!single_value->field_returnErrorCause.match(other_value.returnErrorCause(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause.");
}
return FALSE;
}

boolean BSSMAP__IE__ReturnErrorCause_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_returnErrorCause.is_bound();
}

boolean BSSMAP__IE__ReturnErrorCause_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_returnErrorCause.is_value();
}

void BSSMAP__IE__ReturnErrorCause_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__ReturnErrorCause BSSMAP__IE__ReturnErrorCause_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause.");
BSSMAP__IE__ReturnErrorCause ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_returnErrorCause.is_bound()) {
ret_val.returnErrorCause() = single_value->field_returnErrorCause.valueof();
}
return ret_val;
}

void BSSMAP__IE__ReturnErrorCause_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__ReturnErrorCause_template[list_length];
}

BSSMAP__IE__ReturnErrorCause_template& BSSMAP__IE__ReturnErrorCause_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__ReturnErrorCause_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__ReturnErrorCause_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__ReturnErrorCause_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__ReturnErrorCause_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& BSSMAP__IE__ReturnErrorCause_template::returnErrorCause()
{
set_specific();
return single_value->field_returnErrorCause;
}

const OCTETSTRING_template& BSSMAP__IE__ReturnErrorCause_template::returnErrorCause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field returnErrorCause of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause.");
return single_value->field_returnErrorCause;
}

int BSSMAP__IE__ReturnErrorCause_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause.");
  }
  return 0;
}

void BSSMAP__IE__ReturnErrorCause_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", returnErrorCause := ");
single_value->field_returnErrorCause.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__ReturnErrorCause_template::log_match(const BSSMAP__IE__ReturnErrorCause& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_returnErrorCause.match(match_value.returnErrorCause(), legacy)){
TTCN_Logger::log_logmatch_info(".returnErrorCause");
single_value->field_returnErrorCause.log_match(match_value.returnErrorCause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", returnErrorCause := ");
single_value->field_returnErrorCause.log_match(match_value.returnErrorCause(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__ReturnErrorCause_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (returnErrorCause().is_bound()) returnErrorCause().set_implicit_omit();
}

void BSSMAP__IE__ReturnErrorCause_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_returnErrorCause.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause.");
}
}

void BSSMAP__IE__ReturnErrorCause_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_returnErrorCause.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__ReturnErrorCause_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause.");
}
}

void BSSMAP__IE__ReturnErrorCause_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__ReturnErrorCause_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) returnErrorCause().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "returnErrorCause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          returnErrorCause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_ReturnErrorCause: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__ReturnErrorCause_template* precondition = new BSSMAP__IE__ReturnErrorCause_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__ReturnErrorCause_template* implied_template = new BSSMAP__IE__ReturnErrorCause_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__ReturnErrorCause_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_ReturnErrorCause");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__ReturnErrorCause_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ReturnErrorCause");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ReturnErrorCause");
single_value->field_returnErrorCause.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ReturnErrorCause");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ReturnErrorCause");
}

boolean BSSMAP__IE__ReturnErrorCause_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__ReturnErrorCause_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__Segmentation::BSSMAP__IE__Segmentation()
{
}

BSSMAP__IE__Segmentation::BSSMAP__IE__Segmentation(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const BITSTRING& par_segmentationNumber,
    const BITSTRING& par_segmentationBit,
    const BITSTRING& par_spare,
    const OPTIONAL< OCTETSTRING >& par_messageID)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_segmentationNumber(par_segmentationNumber),
  field_segmentationBit(par_segmentationBit),
  field_spare(par_spare),
  field_messageID(par_messageID)
{
}

BSSMAP__IE__Segmentation::BSSMAP__IE__Segmentation(const BSSMAP__IE__Segmentation& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_Segmentation.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.segmentationNumber().is_bound()) field_segmentationNumber = other_value.segmentationNumber();
else field_segmentationNumber.clean_up();
if (other_value.segmentationBit().is_bound()) field_segmentationBit = other_value.segmentationBit();
else field_segmentationBit.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.messageID().is_bound()) field_messageID = other_value.messageID();
else field_messageID.clean_up();
}

void BSSMAP__IE__Segmentation::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_segmentationNumber.clean_up();
field_segmentationBit.clean_up();
field_spare.clean_up();
field_messageID.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__Segmentation::get_descriptor() const { return &BSSMAP__IE__Segmentation_descr_; }
BSSMAP__IE__Segmentation& BSSMAP__IE__Segmentation::operator=(const BSSMAP__IE__Segmentation& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_Segmentation.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.segmentationNumber().is_bound()) field_segmentationNumber = other_value.segmentationNumber();
  else field_segmentationNumber.clean_up();
  if (other_value.segmentationBit().is_bound()) field_segmentationBit = other_value.segmentationBit();
  else field_segmentationBit.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.messageID().is_bound()) field_messageID = other_value.messageID();
  else field_messageID.clean_up();
}
return *this;
}

boolean BSSMAP__IE__Segmentation::operator==(const BSSMAP__IE__Segmentation& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_segmentationNumber==other_value.field_segmentationNumber
  && field_segmentationBit==other_value.field_segmentationBit
  && field_spare==other_value.field_spare
  && field_messageID==other_value.field_messageID;
}

boolean BSSMAP__IE__Segmentation::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_segmentationNumber.is_bound())
  || (field_segmentationBit.is_bound())
  || (field_spare.is_bound())
  || (OPTIONAL_OMIT == field_messageID.get_selection() || field_messageID.is_bound());
}
boolean BSSMAP__IE__Segmentation::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_segmentationNumber.is_value()
  && field_segmentationBit.is_value()
  && field_spare.is_value()
  && (OPTIONAL_OMIT == field_messageID.get_selection() || field_messageID.is_value());
}
int BSSMAP__IE__Segmentation::size_of() const
{
  int ret_val = 5;
  if (field_messageID.ispresent()) ret_val++;
  return ret_val;
}

void BSSMAP__IE__Segmentation::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", segmentationNumber := ");
field_segmentationNumber.log();
TTCN_Logger::log_event_str(", segmentationBit := ");
field_segmentationBit.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", messageID := ");
field_messageID.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__Segmentation::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (segmentationNumber().is_bound()) segmentationNumber().set_implicit_omit();
if (segmentationBit().is_bound()) segmentationBit().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (!messageID().is_bound()) messageID() = OMIT_VALUE;
else messageID().set_implicit_omit();
}

void BSSMAP__IE__Segmentation::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_Segmentation has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) segmentationNumber().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) segmentationBit().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) messageID().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "segmentationNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          segmentationNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "segmentationBit")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          segmentationBit().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_Segmentation: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_Segmentation");
  }
}

void BSSMAP__IE__Segmentation::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_segmentationNumber.encode_text(text_buf);
field_segmentationBit.encode_text(text_buf);
field_spare.encode_text(text_buf);
field_messageID.encode_text(text_buf);
}

void BSSMAP__IE__Segmentation::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_segmentationNumber.decode_text(text_buf);
field_segmentationBit.decode_text(text_buf);
field_spare.decode_text(text_buf);
field_messageID.decode_text(text_buf);
}

void BSSMAP__IE__Segmentation::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__Segmentation::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__Segmentation::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__Segmentation_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__Segmentation_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__Segmentation_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_segmentationNumber.RAW_decode(General__Types::BIT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_segmentationBit.RAW_decode(General__Types::BIT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::BIT3_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT3_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (limit > 0 && value_of_length_field1 > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_messageID = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_messageID().RAW_decode(General__Types::OCT2_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_messageID = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  }
  }
  }
  else field_messageID=OMIT_VALUE;
  if (field_elementIdentifier !=  os_45) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__Segmentation::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 6;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(6);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__Segmentation_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::BIT3_descr_.raw);
  if (field_messageID.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, General__Types::OCT2_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__Segmentation_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 4;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(4);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  if (field_messageID.ispresent()) {
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  } else {
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].level = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].pos = 0;
  }
  encoded_length += field_segmentationNumber.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_segmentationBit.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT3_descr_, *myleaf.body.node.nodes[4]);
  if (field_messageID.ispresent()) {
  encoded_length += field_messageID().RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_elementIdentifier !=  os_45) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_45.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__Segmentation_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
BITSTRING_template field_segmentationNumber;
BITSTRING_template field_segmentationBit;
BITSTRING_template field_spare;
OCTETSTRING_template field_messageID;
};

void BSSMAP__IE__Segmentation_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_segmentationNumber = ANY_VALUE;
single_value->field_segmentationBit = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
single_value->field_messageID = ANY_OR_OMIT;
}
}
}

void BSSMAP__IE__Segmentation_template::copy_value(const BSSMAP__IE__Segmentation& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.segmentationNumber().is_bound()) {
  single_value->field_segmentationNumber = other_value.segmentationNumber();
} else {
  single_value->field_segmentationNumber.clean_up();
}
if (other_value.segmentationBit().is_bound()) {
  single_value->field_segmentationBit = other_value.segmentationBit();
} else {
  single_value->field_segmentationBit.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.messageID().is_bound()) {
  if (other_value.messageID().ispresent()) single_value->field_messageID = other_value.messageID()();
  else single_value->field_messageID = OMIT_VALUE;
} else {
  single_value->field_messageID.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__Segmentation_template::copy_template(const BSSMAP__IE__Segmentation_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.segmentationNumber().get_selection()) {
single_value->field_segmentationNumber = other_value.segmentationNumber();
} else {
single_value->field_segmentationNumber.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.segmentationBit().get_selection()) {
single_value->field_segmentationBit = other_value.segmentationBit();
} else {
single_value->field_segmentationBit.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.messageID().get_selection()) {
single_value->field_messageID = other_value.messageID();
} else {
single_value->field_messageID.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__Segmentation_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__Segmentation_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__Segmentation_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_Segmentation.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__Segmentation_template::BSSMAP__IE__Segmentation_template()
{
}

BSSMAP__IE__Segmentation_template::BSSMAP__IE__Segmentation_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__Segmentation_template::BSSMAP__IE__Segmentation_template(const BSSMAP__IE__Segmentation& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__Segmentation_template::BSSMAP__IE__Segmentation_template(const OPTIONAL<BSSMAP__IE__Segmentation>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__Segmentation&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_Segmentation from an unbound optional field.");
}
}

BSSMAP__IE__Segmentation_template::BSSMAP__IE__Segmentation_template(BSSMAP__IE__Segmentation_template* p_precondition, BSSMAP__IE__Segmentation_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__Segmentation_template::BSSMAP__IE__Segmentation_template(Dynamic_Match_Interface<BSSMAP__IE__Segmentation>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__Segmentation>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__Segmentation_template::BSSMAP__IE__Segmentation_template(const BSSMAP__IE__Segmentation_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__Segmentation_template::~BSSMAP__IE__Segmentation_template()
{
clean_up();
}

BSSMAP__IE__Segmentation_template& BSSMAP__IE__Segmentation_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__Segmentation_template& BSSMAP__IE__Segmentation_template::operator=(const BSSMAP__IE__Segmentation& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__Segmentation_template& BSSMAP__IE__Segmentation_template::operator=(const OPTIONAL<BSSMAP__IE__Segmentation>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__Segmentation&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_Segmentation.");
}
return *this;
}

BSSMAP__IE__Segmentation_template& BSSMAP__IE__Segmentation_template::operator=(const BSSMAP__IE__Segmentation_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__Segmentation_template::match(const BSSMAP__IE__Segmentation& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.segmentationNumber().is_bound()) return FALSE;
if(!single_value->field_segmentationNumber.match(other_value.segmentationNumber(), legacy))return FALSE;
if(!other_value.segmentationBit().is_bound()) return FALSE;
if(!single_value->field_segmentationBit.match(other_value.segmentationBit(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.messageID().is_bound()) return FALSE;
if((other_value.messageID().ispresent() ? !single_value->field_messageID.match((const OCTETSTRING&)other_value.messageID(), legacy) : !single_value->field_messageID.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_Segmentation.");
}
return FALSE;
}

boolean BSSMAP__IE__Segmentation_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_segmentationNumber.is_bound()
 || single_value->field_segmentationBit.is_bound()
 || single_value->field_spare.is_bound()
 || (single_value->field_messageID.is_omit() || single_value->field_messageID.is_bound());
}

boolean BSSMAP__IE__Segmentation_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_segmentationNumber.is_value()
 && single_value->field_segmentationBit.is_value()
 && single_value->field_spare.is_value()
 && (single_value->field_messageID.is_omit() || single_value->field_messageID.is_value());
}

void BSSMAP__IE__Segmentation_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__Segmentation BSSMAP__IE__Segmentation_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_Segmentation.");
BSSMAP__IE__Segmentation ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_segmentationNumber.is_bound()) {
ret_val.segmentationNumber() = single_value->field_segmentationNumber.valueof();
}
if (single_value->field_segmentationBit.is_bound()) {
ret_val.segmentationBit() = single_value->field_segmentationBit.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_messageID.is_omit()) ret_val.messageID() = OMIT_VALUE;
else if (single_value->field_messageID.is_bound()) {
ret_val.messageID() = single_value->field_messageID.valueof();
}
return ret_val;
}

void BSSMAP__IE__Segmentation_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_Segmentation.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__Segmentation_template[list_length];
}

BSSMAP__IE__Segmentation_template& BSSMAP__IE__Segmentation_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_Segmentation.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_Segmentation.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__Segmentation_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__Segmentation_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_Segmentation.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__Segmentation_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__Segmentation_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_Segmentation.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& BSSMAP__IE__Segmentation_template::segmentationNumber()
{
set_specific();
return single_value->field_segmentationNumber;
}

const BITSTRING_template& BSSMAP__IE__Segmentation_template::segmentationNumber() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field segmentationNumber of a non-specific template of type @BSSAP_Types.BSSMAP_IE_Segmentation.");
return single_value->field_segmentationNumber;
}

BITSTRING_template& BSSMAP__IE__Segmentation_template::segmentationBit()
{
set_specific();
return single_value->field_segmentationBit;
}

const BITSTRING_template& BSSMAP__IE__Segmentation_template::segmentationBit() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field segmentationBit of a non-specific template of type @BSSAP_Types.BSSMAP_IE_Segmentation.");
return single_value->field_segmentationBit;
}

BITSTRING_template& BSSMAP__IE__Segmentation_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& BSSMAP__IE__Segmentation_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @BSSAP_Types.BSSMAP_IE_Segmentation.");
return single_value->field_spare;
}

OCTETSTRING_template& BSSMAP__IE__Segmentation_template::messageID()
{
set_specific();
return single_value->field_messageID;
}

const OCTETSTRING_template& BSSMAP__IE__Segmentation_template::messageID() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageID of a non-specific template of type @BSSAP_Types.BSSMAP_IE_Segmentation.");
return single_value->field_messageID;
}

int BSSMAP__IE__Segmentation_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Segmentation which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 5;
      if (single_value->field_messageID.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Segmentation containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Segmentation containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Segmentation containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Segmentation containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Segmentation containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Segmentation containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Segmentation containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_Segmentation containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_Segmentation.");
  }
  return 0;
}

void BSSMAP__IE__Segmentation_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", segmentationNumber := ");
single_value->field_segmentationNumber.log();
TTCN_Logger::log_event_str(", segmentationBit := ");
single_value->field_segmentationBit.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", messageID := ");
single_value->field_messageID.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__Segmentation_template::log_match(const BSSMAP__IE__Segmentation& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_segmentationNumber.match(match_value.segmentationNumber(), legacy)){
TTCN_Logger::log_logmatch_info(".segmentationNumber");
single_value->field_segmentationNumber.log_match(match_value.segmentationNumber(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_segmentationBit.match(match_value.segmentationBit(), legacy)){
TTCN_Logger::log_logmatch_info(".segmentationBit");
single_value->field_segmentationBit.log_match(match_value.segmentationBit(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.messageID().ispresent()){
if(!single_value->field_messageID.match(match_value.messageID(), legacy)){
TTCN_Logger::log_logmatch_info(".messageID");
single_value->field_messageID.log_match(match_value.messageID(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_messageID.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".messageID := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_messageID.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", segmentationNumber := ");
single_value->field_segmentationNumber.log_match(match_value.segmentationNumber(), legacy);
TTCN_Logger::log_event_str(", segmentationBit := ");
single_value->field_segmentationBit.log_match(match_value.segmentationBit(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", messageID := ");
if (match_value.messageID().ispresent()) {
single_value->field_messageID.log_match(match_value.messageID(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_messageID.log();
if (single_value->field_messageID.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__Segmentation_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (segmentationNumber().is_bound()) segmentationNumber().set_implicit_omit();
if (segmentationBit().is_bound()) segmentationBit().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (!messageID().is_bound()) messageID() = OMIT_VALUE;
else messageID().set_implicit_omit();
}

void BSSMAP__IE__Segmentation_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_segmentationNumber.encode_text(text_buf);
single_value->field_segmentationBit.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
single_value->field_messageID.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_Segmentation.");
}
}

void BSSMAP__IE__Segmentation_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_segmentationNumber.decode_text(text_buf);
single_value->field_segmentationBit.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
single_value->field_messageID.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__Segmentation_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_Segmentation.");
}
}

void BSSMAP__IE__Segmentation_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__Segmentation_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_Segmentation has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) segmentationNumber().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) segmentationBit().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) messageID().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "segmentationNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          segmentationNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "segmentationBit")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          segmentationBit().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_Segmentation: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__Segmentation_template* precondition = new BSSMAP__IE__Segmentation_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__Segmentation_template* implied_template = new BSSMAP__IE__Segmentation_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__Segmentation_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_Segmentation");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__Segmentation_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_Segmentation");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_Segmentation");
single_value->field_segmentationNumber.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_Segmentation");
single_value->field_segmentationBit.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_Segmentation");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_Segmentation");
single_value->field_messageID.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_Segmentation");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_Segmentation");
}

boolean BSSMAP__IE__Segmentation_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__Segmentation_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__ServiceHandover::BSSMAP__IE__ServiceHandover()
{
}

BSSMAP__IE__ServiceHandover::BSSMAP__IE__ServiceHandover(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const BITSTRING& par_serviceHandoverInfo,
    const BITSTRING& par_spare)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_serviceHandoverInfo(par_serviceHandoverInfo),
  field_spare(par_spare)
{
}

BSSMAP__IE__ServiceHandover::BSSMAP__IE__ServiceHandover(const BSSMAP__IE__ServiceHandover& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_ServiceHandover.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.serviceHandoverInfo().is_bound()) field_serviceHandoverInfo = other_value.serviceHandoverInfo();
else field_serviceHandoverInfo.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void BSSMAP__IE__ServiceHandover::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_serviceHandoverInfo.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__ServiceHandover::get_descriptor() const { return &BSSMAP__IE__ServiceHandover_descr_; }
BSSMAP__IE__ServiceHandover& BSSMAP__IE__ServiceHandover::operator=(const BSSMAP__IE__ServiceHandover& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_ServiceHandover.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.serviceHandoverInfo().is_bound()) field_serviceHandoverInfo = other_value.serviceHandoverInfo();
  else field_serviceHandoverInfo.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean BSSMAP__IE__ServiceHandover::operator==(const BSSMAP__IE__ServiceHandover& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_serviceHandoverInfo==other_value.field_serviceHandoverInfo
  && field_spare==other_value.field_spare;
}

boolean BSSMAP__IE__ServiceHandover::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_serviceHandoverInfo.is_bound())
  || (field_spare.is_bound());
}
boolean BSSMAP__IE__ServiceHandover::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_serviceHandoverInfo.is_value()
  && field_spare.is_value();
}
void BSSMAP__IE__ServiceHandover::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", serviceHandoverInfo := ");
field_serviceHandoverInfo.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__ServiceHandover::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (serviceHandoverInfo().is_bound()) serviceHandoverInfo().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void BSSMAP__IE__ServiceHandover::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_ServiceHandover has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) serviceHandoverInfo().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "serviceHandoverInfo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          serviceHandoverInfo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_ServiceHandover: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_ServiceHandover");
  }
}

void BSSMAP__IE__ServiceHandover::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_serviceHandoverInfo.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void BSSMAP__IE__ServiceHandover::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_serviceHandoverInfo.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void BSSMAP__IE__ServiceHandover::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__ServiceHandover::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__ServiceHandover::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__ServiceHandover_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__ServiceHandover_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__ServiceHandover_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT3_descr_.raw->forceomit);
  decoded_field_length = field_serviceHandoverInfo.RAW_decode(General__Types::BIT3_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT5_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT5_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_10) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__ServiceHandover::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__ServiceHandover_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT3_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT5_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__ServiceHandover_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 2;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(2);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  encoded_length += field_serviceHandoverInfo.RAW_encode(General__Types::BIT3_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT5_descr_, *myleaf.body.node.nodes[3]);
  if (field_elementIdentifier !=  os_10) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_10.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__ServiceHandover_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
BITSTRING_template field_serviceHandoverInfo;
BITSTRING_template field_spare;
};

void BSSMAP__IE__ServiceHandover_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_serviceHandoverInfo = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void BSSMAP__IE__ServiceHandover_template::copy_value(const BSSMAP__IE__ServiceHandover& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.serviceHandoverInfo().is_bound()) {
  single_value->field_serviceHandoverInfo = other_value.serviceHandoverInfo();
} else {
  single_value->field_serviceHandoverInfo.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__ServiceHandover_template::copy_template(const BSSMAP__IE__ServiceHandover_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.serviceHandoverInfo().get_selection()) {
single_value->field_serviceHandoverInfo = other_value.serviceHandoverInfo();
} else {
single_value->field_serviceHandoverInfo.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__ServiceHandover_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__ServiceHandover_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__ServiceHandover_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__ServiceHandover_template::BSSMAP__IE__ServiceHandover_template()
{
}

BSSMAP__IE__ServiceHandover_template::BSSMAP__IE__ServiceHandover_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__ServiceHandover_template::BSSMAP__IE__ServiceHandover_template(const BSSMAP__IE__ServiceHandover& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__ServiceHandover_template::BSSMAP__IE__ServiceHandover_template(const OPTIONAL<BSSMAP__IE__ServiceHandover>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__ServiceHandover&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover from an unbound optional field.");
}
}

BSSMAP__IE__ServiceHandover_template::BSSMAP__IE__ServiceHandover_template(BSSMAP__IE__ServiceHandover_template* p_precondition, BSSMAP__IE__ServiceHandover_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__ServiceHandover_template::BSSMAP__IE__ServiceHandover_template(Dynamic_Match_Interface<BSSMAP__IE__ServiceHandover>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__ServiceHandover>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__ServiceHandover_template::BSSMAP__IE__ServiceHandover_template(const BSSMAP__IE__ServiceHandover_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__ServiceHandover_template::~BSSMAP__IE__ServiceHandover_template()
{
clean_up();
}

BSSMAP__IE__ServiceHandover_template& BSSMAP__IE__ServiceHandover_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__ServiceHandover_template& BSSMAP__IE__ServiceHandover_template::operator=(const BSSMAP__IE__ServiceHandover& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__ServiceHandover_template& BSSMAP__IE__ServiceHandover_template::operator=(const OPTIONAL<BSSMAP__IE__ServiceHandover>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__ServiceHandover&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover.");
}
return *this;
}

BSSMAP__IE__ServiceHandover_template& BSSMAP__IE__ServiceHandover_template::operator=(const BSSMAP__IE__ServiceHandover_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__ServiceHandover_template::match(const BSSMAP__IE__ServiceHandover& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.serviceHandoverInfo().is_bound()) return FALSE;
if(!single_value->field_serviceHandoverInfo.match(other_value.serviceHandoverInfo(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover.");
}
return FALSE;
}

boolean BSSMAP__IE__ServiceHandover_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_serviceHandoverInfo.is_bound()
 || single_value->field_spare.is_bound();
}

boolean BSSMAP__IE__ServiceHandover_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_serviceHandoverInfo.is_value()
 && single_value->field_spare.is_value();
}

void BSSMAP__IE__ServiceHandover_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__ServiceHandover BSSMAP__IE__ServiceHandover_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover.");
BSSMAP__IE__ServiceHandover ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_serviceHandoverInfo.is_bound()) {
ret_val.serviceHandoverInfo() = single_value->field_serviceHandoverInfo.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void BSSMAP__IE__ServiceHandover_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__ServiceHandover_template[list_length];
}

BSSMAP__IE__ServiceHandover_template& BSSMAP__IE__ServiceHandover_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__ServiceHandover_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__ServiceHandover_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__ServiceHandover_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__ServiceHandover_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& BSSMAP__IE__ServiceHandover_template::serviceHandoverInfo()
{
set_specific();
return single_value->field_serviceHandoverInfo;
}

const BITSTRING_template& BSSMAP__IE__ServiceHandover_template::serviceHandoverInfo() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field serviceHandoverInfo of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover.");
return single_value->field_serviceHandoverInfo;
}

BITSTRING_template& BSSMAP__IE__ServiceHandover_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& BSSMAP__IE__ServiceHandover_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover.");
return single_value->field_spare;
}

int BSSMAP__IE__ServiceHandover_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover.");
  }
  return 0;
}

void BSSMAP__IE__ServiceHandover_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", serviceHandoverInfo := ");
single_value->field_serviceHandoverInfo.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__ServiceHandover_template::log_match(const BSSMAP__IE__ServiceHandover& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_serviceHandoverInfo.match(match_value.serviceHandoverInfo(), legacy)){
TTCN_Logger::log_logmatch_info(".serviceHandoverInfo");
single_value->field_serviceHandoverInfo.log_match(match_value.serviceHandoverInfo(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", serviceHandoverInfo := ");
single_value->field_serviceHandoverInfo.log_match(match_value.serviceHandoverInfo(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__ServiceHandover_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (serviceHandoverInfo().is_bound()) serviceHandoverInfo().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void BSSMAP__IE__ServiceHandover_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_serviceHandoverInfo.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover.");
}
}

void BSSMAP__IE__ServiceHandover_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_serviceHandoverInfo.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__ServiceHandover_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover.");
}
}

void BSSMAP__IE__ServiceHandover_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__ServiceHandover_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_ServiceHandover has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) serviceHandoverInfo().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "serviceHandoverInfo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          serviceHandoverInfo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_ServiceHandover: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__ServiceHandover_template* precondition = new BSSMAP__IE__ServiceHandover_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__ServiceHandover_template* implied_template = new BSSMAP__IE__ServiceHandover_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__ServiceHandover_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_ServiceHandover");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__ServiceHandover_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ServiceHandover");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ServiceHandover");
single_value->field_serviceHandoverInfo.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ServiceHandover");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ServiceHandover");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_ServiceHandover");
}

boolean BSSMAP__IE__ServiceHandover_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__ServiceHandover_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__SourceToTargetRNCTransparentInfo::BSSMAP__IE__SourceToTargetRNCTransparentInfo()
{
}

BSSMAP__IE__SourceToTargetRNCTransparentInfo::BSSMAP__IE__SourceToTargetRNCTransparentInfo(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_informationcontainer)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_informationcontainer(par_informationcontainer)
{
}

BSSMAP__IE__SourceToTargetRNCTransparentInfo::BSSMAP__IE__SourceToTargetRNCTransparentInfo(const BSSMAP__IE__SourceToTargetRNCTransparentInfo& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.informationcontainer().is_bound()) field_informationcontainer = other_value.informationcontainer();
else field_informationcontainer.clean_up();
}

void BSSMAP__IE__SourceToTargetRNCTransparentInfo::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_informationcontainer.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__SourceToTargetRNCTransparentInfo::get_descriptor() const { return &BSSMAP__IE__SourceToTargetRNCTransparentInfo_descr_; }
BSSMAP__IE__SourceToTargetRNCTransparentInfo& BSSMAP__IE__SourceToTargetRNCTransparentInfo::operator=(const BSSMAP__IE__SourceToTargetRNCTransparentInfo& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.informationcontainer().is_bound()) field_informationcontainer = other_value.informationcontainer();
  else field_informationcontainer.clean_up();
}
return *this;
}

boolean BSSMAP__IE__SourceToTargetRNCTransparentInfo::operator==(const BSSMAP__IE__SourceToTargetRNCTransparentInfo& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_informationcontainer==other_value.field_informationcontainer;
}

boolean BSSMAP__IE__SourceToTargetRNCTransparentInfo::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_informationcontainer.is_bound());
}
boolean BSSMAP__IE__SourceToTargetRNCTransparentInfo::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_informationcontainer.is_value();
}
void BSSMAP__IE__SourceToTargetRNCTransparentInfo::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", informationcontainer := ");
field_informationcontainer.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__SourceToTargetRNCTransparentInfo::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (informationcontainer().is_bound()) informationcontainer().set_implicit_omit();
}

void BSSMAP__IE__SourceToTargetRNCTransparentInfo::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) informationcontainer().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "informationcontainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          informationcontainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo");
  }
}

void BSSMAP__IE__SourceToTargetRNCTransparentInfo::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_informationcontainer.encode_text(text_buf);
}

void BSSMAP__IE__SourceToTargetRNCTransparentInfo::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_informationcontainer.decode_text(text_buf);
}

void BSSMAP__IE__SourceToTargetRNCTransparentInfo::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__SourceToTargetRNCTransparentInfo::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__SourceToTargetRNCTransparentInfo::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__SourceToTargetRNCTransparentInfo_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__SourceToTargetRNCTransparentInfo_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__SourceToTargetRNCTransparentInfo_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_informationcontainer.RAW_decode(OCTETSTRING_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__SourceToTargetRNCTransparentInfo::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__SourceToTargetRNCTransparentInfo_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, OCTETSTRING_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__SourceToTargetRNCTransparentInfo_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_informationcontainer.RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_informationcontainer;
};

void BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_informationcontainer = ANY_VALUE;
}
}
}

void BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::copy_value(const BSSMAP__IE__SourceToTargetRNCTransparentInfo& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.informationcontainer().is_bound()) {
  single_value->field_informationcontainer = other_value.informationcontainer();
} else {
  single_value->field_informationcontainer.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::copy_template(const BSSMAP__IE__SourceToTargetRNCTransparentInfo_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.informationcontainer().get_selection()) {
single_value->field_informationcontainer = other_value.informationcontainer();
} else {
single_value->field_informationcontainer.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__SourceToTargetRNCTransparentInfo_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__SourceToTargetRNCTransparentInfo_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__SourceToTargetRNCTransparentInfo_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::BSSMAP__IE__SourceToTargetRNCTransparentInfo_template()
{
}

BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::BSSMAP__IE__SourceToTargetRNCTransparentInfo_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::BSSMAP__IE__SourceToTargetRNCTransparentInfo_template(const BSSMAP__IE__SourceToTargetRNCTransparentInfo& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::BSSMAP__IE__SourceToTargetRNCTransparentInfo_template(const OPTIONAL<BSSMAP__IE__SourceToTargetRNCTransparentInfo>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__SourceToTargetRNCTransparentInfo&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo from an unbound optional field.");
}
}

BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::BSSMAP__IE__SourceToTargetRNCTransparentInfo_template(BSSMAP__IE__SourceToTargetRNCTransparentInfo_template* p_precondition, BSSMAP__IE__SourceToTargetRNCTransparentInfo_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::BSSMAP__IE__SourceToTargetRNCTransparentInfo_template(Dynamic_Match_Interface<BSSMAP__IE__SourceToTargetRNCTransparentInfo>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__SourceToTargetRNCTransparentInfo>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::BSSMAP__IE__SourceToTargetRNCTransparentInfo_template(const BSSMAP__IE__SourceToTargetRNCTransparentInfo_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::~BSSMAP__IE__SourceToTargetRNCTransparentInfo_template()
{
clean_up();
}

BSSMAP__IE__SourceToTargetRNCTransparentInfo_template& BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__SourceToTargetRNCTransparentInfo_template& BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::operator=(const BSSMAP__IE__SourceToTargetRNCTransparentInfo& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__SourceToTargetRNCTransparentInfo_template& BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::operator=(const OPTIONAL<BSSMAP__IE__SourceToTargetRNCTransparentInfo>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__SourceToTargetRNCTransparentInfo&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo.");
}
return *this;
}

BSSMAP__IE__SourceToTargetRNCTransparentInfo_template& BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::operator=(const BSSMAP__IE__SourceToTargetRNCTransparentInfo_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::match(const BSSMAP__IE__SourceToTargetRNCTransparentInfo& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.informationcontainer().is_bound()) return FALSE;
if(!single_value->field_informationcontainer.match(other_value.informationcontainer(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo.");
}
return FALSE;
}

boolean BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_informationcontainer.is_bound();
}

boolean BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_informationcontainer.is_value();
}

void BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__SourceToTargetRNCTransparentInfo BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo.");
BSSMAP__IE__SourceToTargetRNCTransparentInfo ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_informationcontainer.is_bound()) {
ret_val.informationcontainer() = single_value->field_informationcontainer.valueof();
}
return ret_val;
}

void BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__SourceToTargetRNCTransparentInfo_template[list_length];
}

BSSMAP__IE__SourceToTargetRNCTransparentInfo_template& BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::informationcontainer()
{
set_specific();
return single_value->field_informationcontainer;
}

const OCTETSTRING_template& BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::informationcontainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field informationcontainer of a non-specific template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo.");
return single_value->field_informationcontainer;
}

int BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo.");
  }
  return 0;
}

void BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", informationcontainer := ");
single_value->field_informationcontainer.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::log_match(const BSSMAP__IE__SourceToTargetRNCTransparentInfo& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_informationcontainer.match(match_value.informationcontainer(), legacy)){
TTCN_Logger::log_logmatch_info(".informationcontainer");
single_value->field_informationcontainer.log_match(match_value.informationcontainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", informationcontainer := ");
single_value->field_informationcontainer.log_match(match_value.informationcontainer(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (informationcontainer().is_bound()) informationcontainer().set_implicit_omit();
}

void BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_informationcontainer.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo.");
}
}

void BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_informationcontainer.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__SourceToTargetRNCTransparentInfo_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo.");
}
}

void BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__SourceToTargetRNCTransparentInfo_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) informationcontainer().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "informationcontainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          informationcontainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__SourceToTargetRNCTransparentInfo_template* precondition = new BSSMAP__IE__SourceToTargetRNCTransparentInfo_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__SourceToTargetRNCTransparentInfo_template* implied_template = new BSSMAP__IE__SourceToTargetRNCTransparentInfo_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__SourceToTargetRNCTransparentInfo_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo");
single_value->field_informationcontainer.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_SourceToTargetRNCTransparentInfo");
}

boolean BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__SourceToTargetRNCTransparentInfo_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__GERANClassmark::BSSMAP__IE__GERANClassmark()
{
}

BSSMAP__IE__GERANClassmark::BSSMAP__IE__GERANClassmark(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_GERANClassmark)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_GERANClassmark(par_GERANClassmark)
{
}

BSSMAP__IE__GERANClassmark::BSSMAP__IE__GERANClassmark(const BSSMAP__IE__GERANClassmark& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_GERANClassmark.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.GERANClassmark().is_bound()) field_GERANClassmark = other_value.GERANClassmark();
else field_GERANClassmark.clean_up();
}

void BSSMAP__IE__GERANClassmark::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_GERANClassmark.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__GERANClassmark::get_descriptor() const { return &BSSMAP__IE__GERANClassmark_descr_; }
BSSMAP__IE__GERANClassmark& BSSMAP__IE__GERANClassmark::operator=(const BSSMAP__IE__GERANClassmark& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_GERANClassmark.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.GERANClassmark().is_bound()) field_GERANClassmark = other_value.GERANClassmark();
  else field_GERANClassmark.clean_up();
}
return *this;
}

boolean BSSMAP__IE__GERANClassmark::operator==(const BSSMAP__IE__GERANClassmark& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_GERANClassmark==other_value.field_GERANClassmark;
}

boolean BSSMAP__IE__GERANClassmark::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_GERANClassmark.is_bound());
}
boolean BSSMAP__IE__GERANClassmark::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_GERANClassmark.is_value();
}
void BSSMAP__IE__GERANClassmark::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", GERANClassmark := ");
field_GERANClassmark.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__GERANClassmark::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (GERANClassmark().is_bound()) GERANClassmark().set_implicit_omit();
}

void BSSMAP__IE__GERANClassmark::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_GERANClassmark has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) GERANClassmark().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "GERANClassmark")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          GERANClassmark().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_GERANClassmark: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_GERANClassmark");
  }
}

void BSSMAP__IE__GERANClassmark::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_GERANClassmark.encode_text(text_buf);
}

void BSSMAP__IE__GERANClassmark::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_GERANClassmark.decode_text(text_buf);
}

void BSSMAP__IE__GERANClassmark::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__GERANClassmark::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__GERANClassmark::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__GERANClassmark_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__GERANClassmark_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__GERANClassmark_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCTN_descr_.raw->forceomit);
  decoded_field_length = field_GERANClassmark.RAW_decode(General__Types::OCTN_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_47) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__GERANClassmark::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__GERANClassmark_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCTN_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__GERANClassmark_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_GERANClassmark.RAW_encode(General__Types::OCTN_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier !=  os_47) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_47.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__GERANClassmark_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_GERANClassmark;
};

void BSSMAP__IE__GERANClassmark_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_GERANClassmark = ANY_VALUE;
}
}
}

void BSSMAP__IE__GERANClassmark_template::copy_value(const BSSMAP__IE__GERANClassmark& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.GERANClassmark().is_bound()) {
  single_value->field_GERANClassmark = other_value.GERANClassmark();
} else {
  single_value->field_GERANClassmark.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__GERANClassmark_template::copy_template(const BSSMAP__IE__GERANClassmark_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.GERANClassmark().get_selection()) {
single_value->field_GERANClassmark = other_value.GERANClassmark();
} else {
single_value->field_GERANClassmark.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__GERANClassmark_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__GERANClassmark_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__GERANClassmark_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__GERANClassmark_template::BSSMAP__IE__GERANClassmark_template()
{
}

BSSMAP__IE__GERANClassmark_template::BSSMAP__IE__GERANClassmark_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__GERANClassmark_template::BSSMAP__IE__GERANClassmark_template(const BSSMAP__IE__GERANClassmark& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__GERANClassmark_template::BSSMAP__IE__GERANClassmark_template(const OPTIONAL<BSSMAP__IE__GERANClassmark>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__GERANClassmark&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark from an unbound optional field.");
}
}

BSSMAP__IE__GERANClassmark_template::BSSMAP__IE__GERANClassmark_template(BSSMAP__IE__GERANClassmark_template* p_precondition, BSSMAP__IE__GERANClassmark_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__GERANClassmark_template::BSSMAP__IE__GERANClassmark_template(Dynamic_Match_Interface<BSSMAP__IE__GERANClassmark>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__GERANClassmark>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__GERANClassmark_template::BSSMAP__IE__GERANClassmark_template(const BSSMAP__IE__GERANClassmark_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__GERANClassmark_template::~BSSMAP__IE__GERANClassmark_template()
{
clean_up();
}

BSSMAP__IE__GERANClassmark_template& BSSMAP__IE__GERANClassmark_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__GERANClassmark_template& BSSMAP__IE__GERANClassmark_template::operator=(const BSSMAP__IE__GERANClassmark& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__GERANClassmark_template& BSSMAP__IE__GERANClassmark_template::operator=(const OPTIONAL<BSSMAP__IE__GERANClassmark>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__GERANClassmark&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark.");
}
return *this;
}

BSSMAP__IE__GERANClassmark_template& BSSMAP__IE__GERANClassmark_template::operator=(const BSSMAP__IE__GERANClassmark_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__GERANClassmark_template::match(const BSSMAP__IE__GERANClassmark& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.GERANClassmark().is_bound()) return FALSE;
if(!single_value->field_GERANClassmark.match(other_value.GERANClassmark(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark.");
}
return FALSE;
}

boolean BSSMAP__IE__GERANClassmark_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_GERANClassmark.is_bound();
}

boolean BSSMAP__IE__GERANClassmark_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_GERANClassmark.is_value();
}

void BSSMAP__IE__GERANClassmark_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__GERANClassmark BSSMAP__IE__GERANClassmark_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark.");
BSSMAP__IE__GERANClassmark ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_GERANClassmark.is_bound()) {
ret_val.GERANClassmark() = single_value->field_GERANClassmark.valueof();
}
return ret_val;
}

void BSSMAP__IE__GERANClassmark_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__GERANClassmark_template[list_length];
}

BSSMAP__IE__GERANClassmark_template& BSSMAP__IE__GERANClassmark_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__GERANClassmark_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__GERANClassmark_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__GERANClassmark_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__GERANClassmark_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& BSSMAP__IE__GERANClassmark_template::GERANClassmark()
{
set_specific();
return single_value->field_GERANClassmark;
}

const OCTETSTRING_template& BSSMAP__IE__GERANClassmark_template::GERANClassmark() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field GERANClassmark of a non-specific template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark.");
return single_value->field_GERANClassmark;
}

int BSSMAP__IE__GERANClassmark_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark.");
  }
  return 0;
}

void BSSMAP__IE__GERANClassmark_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", GERANClassmark := ");
single_value->field_GERANClassmark.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__GERANClassmark_template::log_match(const BSSMAP__IE__GERANClassmark& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_GERANClassmark.match(match_value.GERANClassmark(), legacy)){
TTCN_Logger::log_logmatch_info(".GERANClassmark");
single_value->field_GERANClassmark.log_match(match_value.GERANClassmark(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", GERANClassmark := ");
single_value->field_GERANClassmark.log_match(match_value.GERANClassmark(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__GERANClassmark_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (GERANClassmark().is_bound()) GERANClassmark().set_implicit_omit();
}

void BSSMAP__IE__GERANClassmark_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_GERANClassmark.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark.");
}
}

void BSSMAP__IE__GERANClassmark_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_GERANClassmark.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__GERANClassmark_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark.");
}
}

void BSSMAP__IE__GERANClassmark_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__GERANClassmark_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_GERANClassmark has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) GERANClassmark().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "GERANClassmark")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          GERANClassmark().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_GERANClassmark: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__GERANClassmark_template* precondition = new BSSMAP__IE__GERANClassmark_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__GERANClassmark_template* implied_template = new BSSMAP__IE__GERANClassmark_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__GERANClassmark_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_GERANClassmark");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__GERANClassmark_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_GERANClassmark");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_GERANClassmark");
single_value->field_GERANClassmark.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_GERANClassmark");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_GERANClassmark");
}

boolean BSSMAP__IE__GERANClassmark_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__GERANClassmark_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__GERANBSCContainer::BSSMAP__IE__GERANBSCContainer()
{
}

BSSMAP__IE__GERANBSCContainer::BSSMAP__IE__GERANBSCContainer(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_codecType,
    const BITSTRING& par_maxNrofTCH,
    const BITSTRING& par_allowedRadioIFRates)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_codecType(par_codecType),
  field_maxNrofTCH(par_maxNrofTCH),
  field_allowedRadioIFRates(par_allowedRadioIFRates)
{
}

BSSMAP__IE__GERANBSCContainer::BSSMAP__IE__GERANBSCContainer(const BSSMAP__IE__GERANBSCContainer& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.codecType().is_bound()) field_codecType = other_value.codecType();
else field_codecType.clean_up();
if (other_value.maxNrofTCH().is_bound()) field_maxNrofTCH = other_value.maxNrofTCH();
else field_maxNrofTCH.clean_up();
if (other_value.allowedRadioIFRates().is_bound()) field_allowedRadioIFRates = other_value.allowedRadioIFRates();
else field_allowedRadioIFRates.clean_up();
}

void BSSMAP__IE__GERANBSCContainer::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_codecType.clean_up();
field_maxNrofTCH.clean_up();
field_allowedRadioIFRates.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__GERANBSCContainer::get_descriptor() const { return &BSSMAP__IE__GERANBSCContainer_descr_; }
BSSMAP__IE__GERANBSCContainer& BSSMAP__IE__GERANBSCContainer::operator=(const BSSMAP__IE__GERANBSCContainer& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.codecType().is_bound()) field_codecType = other_value.codecType();
  else field_codecType.clean_up();
  if (other_value.maxNrofTCH().is_bound()) field_maxNrofTCH = other_value.maxNrofTCH();
  else field_maxNrofTCH.clean_up();
  if (other_value.allowedRadioIFRates().is_bound()) field_allowedRadioIFRates = other_value.allowedRadioIFRates();
  else field_allowedRadioIFRates.clean_up();
}
return *this;
}

boolean BSSMAP__IE__GERANBSCContainer::operator==(const BSSMAP__IE__GERANBSCContainer& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_codecType==other_value.field_codecType
  && field_maxNrofTCH==other_value.field_maxNrofTCH
  && field_allowedRadioIFRates==other_value.field_allowedRadioIFRates;
}

boolean BSSMAP__IE__GERANBSCContainer::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_codecType.is_bound())
  || (field_maxNrofTCH.is_bound())
  || (field_allowedRadioIFRates.is_bound());
}
boolean BSSMAP__IE__GERANBSCContainer::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_codecType.is_value()
  && field_maxNrofTCH.is_value()
  && field_allowedRadioIFRates.is_value();
}
void BSSMAP__IE__GERANBSCContainer::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", codecType := ");
field_codecType.log();
TTCN_Logger::log_event_str(", maxNrofTCH := ");
field_maxNrofTCH.log();
TTCN_Logger::log_event_str(", allowedRadioIFRates := ");
field_allowedRadioIFRates.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__GERANBSCContainer::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (codecType().is_bound()) codecType().set_implicit_omit();
if (maxNrofTCH().is_bound()) maxNrofTCH().set_implicit_omit();
if (allowedRadioIFRates().is_bound()) allowedRadioIFRates().set_implicit_omit();
}

void BSSMAP__IE__GERANBSCContainer::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) codecType().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) maxNrofTCH().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) allowedRadioIFRates().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "codecType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          codecType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "maxNrofTCH")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          maxNrofTCH().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "allowedRadioIFRates")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          allowedRadioIFRates().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_GERANBSCContainer");
  }
}

void BSSMAP__IE__GERANBSCContainer::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_codecType.encode_text(text_buf);
field_maxNrofTCH.encode_text(text_buf);
field_allowedRadioIFRates.encode_text(text_buf);
}

void BSSMAP__IE__GERANBSCContainer::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_codecType.decode_text(text_buf);
field_maxNrofTCH.decode_text(text_buf);
field_allowedRadioIFRates.decode_text(text_buf);
}

void BSSMAP__IE__GERANBSCContainer::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__GERANBSCContainer::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__GERANBSCContainer::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__GERANBSCContainer_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__GERANBSCContainer_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__GERANBSCContainer_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_codecType.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT3_descr_.raw->forceomit);
  decoded_field_length = field_maxNrofTCH.RAW_decode(General__Types::BIT3_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::BIT5_descr_.raw->forceomit);
  decoded_field_length = field_allowedRadioIFRates.RAW_decode(General__Types::BIT5_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__GERANBSCContainer::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__GERANBSCContainer_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT3_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::BIT5_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__GERANBSCContainer_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  encoded_length += field_codecType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_maxNrofTCH.RAW_encode(General__Types::BIT3_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_allowedRadioIFRates.RAW_encode(General__Types::BIT5_descr_, *myleaf.body.node.nodes[4]);
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__GERANBSCContainer_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_codecType;
BITSTRING_template field_maxNrofTCH;
BITSTRING_template field_allowedRadioIFRates;
};

void BSSMAP__IE__GERANBSCContainer_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_codecType = ANY_VALUE;
single_value->field_maxNrofTCH = ANY_VALUE;
single_value->field_allowedRadioIFRates = ANY_VALUE;
}
}
}

void BSSMAP__IE__GERANBSCContainer_template::copy_value(const BSSMAP__IE__GERANBSCContainer& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.codecType().is_bound()) {
  single_value->field_codecType = other_value.codecType();
} else {
  single_value->field_codecType.clean_up();
}
if (other_value.maxNrofTCH().is_bound()) {
  single_value->field_maxNrofTCH = other_value.maxNrofTCH();
} else {
  single_value->field_maxNrofTCH.clean_up();
}
if (other_value.allowedRadioIFRates().is_bound()) {
  single_value->field_allowedRadioIFRates = other_value.allowedRadioIFRates();
} else {
  single_value->field_allowedRadioIFRates.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__GERANBSCContainer_template::copy_template(const BSSMAP__IE__GERANBSCContainer_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.codecType().get_selection()) {
single_value->field_codecType = other_value.codecType();
} else {
single_value->field_codecType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.maxNrofTCH().get_selection()) {
single_value->field_maxNrofTCH = other_value.maxNrofTCH();
} else {
single_value->field_maxNrofTCH.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.allowedRadioIFRates().get_selection()) {
single_value->field_allowedRadioIFRates = other_value.allowedRadioIFRates();
} else {
single_value->field_allowedRadioIFRates.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__GERANBSCContainer_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__GERANBSCContainer_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__GERANBSCContainer_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__GERANBSCContainer_template::BSSMAP__IE__GERANBSCContainer_template()
{
}

BSSMAP__IE__GERANBSCContainer_template::BSSMAP__IE__GERANBSCContainer_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__GERANBSCContainer_template::BSSMAP__IE__GERANBSCContainer_template(const BSSMAP__IE__GERANBSCContainer& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__GERANBSCContainer_template::BSSMAP__IE__GERANBSCContainer_template(const OPTIONAL<BSSMAP__IE__GERANBSCContainer>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__GERANBSCContainer&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer from an unbound optional field.");
}
}

BSSMAP__IE__GERANBSCContainer_template::BSSMAP__IE__GERANBSCContainer_template(BSSMAP__IE__GERANBSCContainer_template* p_precondition, BSSMAP__IE__GERANBSCContainer_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__GERANBSCContainer_template::BSSMAP__IE__GERANBSCContainer_template(Dynamic_Match_Interface<BSSMAP__IE__GERANBSCContainer>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__GERANBSCContainer>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__GERANBSCContainer_template::BSSMAP__IE__GERANBSCContainer_template(const BSSMAP__IE__GERANBSCContainer_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__GERANBSCContainer_template::~BSSMAP__IE__GERANBSCContainer_template()
{
clean_up();
}

BSSMAP__IE__GERANBSCContainer_template& BSSMAP__IE__GERANBSCContainer_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__GERANBSCContainer_template& BSSMAP__IE__GERANBSCContainer_template::operator=(const BSSMAP__IE__GERANBSCContainer& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__GERANBSCContainer_template& BSSMAP__IE__GERANBSCContainer_template::operator=(const OPTIONAL<BSSMAP__IE__GERANBSCContainer>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__GERANBSCContainer&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer.");
}
return *this;
}

BSSMAP__IE__GERANBSCContainer_template& BSSMAP__IE__GERANBSCContainer_template::operator=(const BSSMAP__IE__GERANBSCContainer_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__GERANBSCContainer_template::match(const BSSMAP__IE__GERANBSCContainer& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.codecType().is_bound()) return FALSE;
if(!single_value->field_codecType.match(other_value.codecType(), legacy))return FALSE;
if(!other_value.maxNrofTCH().is_bound()) return FALSE;
if(!single_value->field_maxNrofTCH.match(other_value.maxNrofTCH(), legacy))return FALSE;
if(!other_value.allowedRadioIFRates().is_bound()) return FALSE;
if(!single_value->field_allowedRadioIFRates.match(other_value.allowedRadioIFRates(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer.");
}
return FALSE;
}

boolean BSSMAP__IE__GERANBSCContainer_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_codecType.is_bound()
 || single_value->field_maxNrofTCH.is_bound()
 || single_value->field_allowedRadioIFRates.is_bound();
}

boolean BSSMAP__IE__GERANBSCContainer_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_codecType.is_value()
 && single_value->field_maxNrofTCH.is_value()
 && single_value->field_allowedRadioIFRates.is_value();
}

void BSSMAP__IE__GERANBSCContainer_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__GERANBSCContainer BSSMAP__IE__GERANBSCContainer_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer.");
BSSMAP__IE__GERANBSCContainer ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_codecType.is_bound()) {
ret_val.codecType() = single_value->field_codecType.valueof();
}
if (single_value->field_maxNrofTCH.is_bound()) {
ret_val.maxNrofTCH() = single_value->field_maxNrofTCH.valueof();
}
if (single_value->field_allowedRadioIFRates.is_bound()) {
ret_val.allowedRadioIFRates() = single_value->field_allowedRadioIFRates.valueof();
}
return ret_val;
}

void BSSMAP__IE__GERANBSCContainer_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__GERANBSCContainer_template[list_length];
}

BSSMAP__IE__GERANBSCContainer_template& BSSMAP__IE__GERANBSCContainer_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__GERANBSCContainer_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__GERANBSCContainer_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__GERANBSCContainer_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__GERANBSCContainer_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& BSSMAP__IE__GERANBSCContainer_template::codecType()
{
set_specific();
return single_value->field_codecType;
}

const OCTETSTRING_template& BSSMAP__IE__GERANBSCContainer_template::codecType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field codecType of a non-specific template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer.");
return single_value->field_codecType;
}

BITSTRING_template& BSSMAP__IE__GERANBSCContainer_template::maxNrofTCH()
{
set_specific();
return single_value->field_maxNrofTCH;
}

const BITSTRING_template& BSSMAP__IE__GERANBSCContainer_template::maxNrofTCH() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field maxNrofTCH of a non-specific template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer.");
return single_value->field_maxNrofTCH;
}

BITSTRING_template& BSSMAP__IE__GERANBSCContainer_template::allowedRadioIFRates()
{
set_specific();
return single_value->field_allowedRadioIFRates;
}

const BITSTRING_template& BSSMAP__IE__GERANBSCContainer_template::allowedRadioIFRates() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field allowedRadioIFRates of a non-specific template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer.");
return single_value->field_allowedRadioIFRates;
}

int BSSMAP__IE__GERANBSCContainer_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer.");
  }
  return 0;
}

void BSSMAP__IE__GERANBSCContainer_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", codecType := ");
single_value->field_codecType.log();
TTCN_Logger::log_event_str(", maxNrofTCH := ");
single_value->field_maxNrofTCH.log();
TTCN_Logger::log_event_str(", allowedRadioIFRates := ");
single_value->field_allowedRadioIFRates.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__GERANBSCContainer_template::log_match(const BSSMAP__IE__GERANBSCContainer& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_codecType.match(match_value.codecType(), legacy)){
TTCN_Logger::log_logmatch_info(".codecType");
single_value->field_codecType.log_match(match_value.codecType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_maxNrofTCH.match(match_value.maxNrofTCH(), legacy)){
TTCN_Logger::log_logmatch_info(".maxNrofTCH");
single_value->field_maxNrofTCH.log_match(match_value.maxNrofTCH(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_allowedRadioIFRates.match(match_value.allowedRadioIFRates(), legacy)){
TTCN_Logger::log_logmatch_info(".allowedRadioIFRates");
single_value->field_allowedRadioIFRates.log_match(match_value.allowedRadioIFRates(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", codecType := ");
single_value->field_codecType.log_match(match_value.codecType(), legacy);
TTCN_Logger::log_event_str(", maxNrofTCH := ");
single_value->field_maxNrofTCH.log_match(match_value.maxNrofTCH(), legacy);
TTCN_Logger::log_event_str(", allowedRadioIFRates := ");
single_value->field_allowedRadioIFRates.log_match(match_value.allowedRadioIFRates(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__GERANBSCContainer_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (codecType().is_bound()) codecType().set_implicit_omit();
if (maxNrofTCH().is_bound()) maxNrofTCH().set_implicit_omit();
if (allowedRadioIFRates().is_bound()) allowedRadioIFRates().set_implicit_omit();
}

void BSSMAP__IE__GERANBSCContainer_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_codecType.encode_text(text_buf);
single_value->field_maxNrofTCH.encode_text(text_buf);
single_value->field_allowedRadioIFRates.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer.");
}
}

void BSSMAP__IE__GERANBSCContainer_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_codecType.decode_text(text_buf);
single_value->field_maxNrofTCH.decode_text(text_buf);
single_value->field_allowedRadioIFRates.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__GERANBSCContainer_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer.");
}
}

void BSSMAP__IE__GERANBSCContainer_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__GERANBSCContainer_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) codecType().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) maxNrofTCH().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) allowedRadioIFRates().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "codecType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          codecType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "maxNrofTCH")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          maxNrofTCH().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "allowedRadioIFRates")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          allowedRadioIFRates().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_GERANBSCContainer: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__GERANBSCContainer_template* precondition = new BSSMAP__IE__GERANBSCContainer_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__GERANBSCContainer_template* implied_template = new BSSMAP__IE__GERANBSCContainer_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__GERANBSCContainer_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_GERANBSCContainer");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__GERANBSCContainer_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_GERANBSCContainer");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_GERANBSCContainer");
single_value->field_codecType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_GERANBSCContainer");
single_value->field_maxNrofTCH.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_GERANBSCContainer");
single_value->field_allowedRadioIFRates.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_GERANBSCContainer");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_GERANBSCContainer");
}

boolean BSSMAP__IE__GERANBSCContainer_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__GERANBSCContainer_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__NewBSSToOldBSSInfo::BSSMAP__IE__NewBSSToOldBSSInfo()
{
}

BSSMAP__IE__NewBSSToOldBSSInfo::BSSMAP__IE__NewBSSToOldBSSInfo(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const OPTIONAL< OCTETSTRING >& par_newBSSToOldBSSIE)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_newBSSToOldBSSIE(par_newBSSToOldBSSIE)
{
}

BSSMAP__IE__NewBSSToOldBSSInfo::BSSMAP__IE__NewBSSToOldBSSInfo(const BSSMAP__IE__NewBSSToOldBSSInfo& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.newBSSToOldBSSIE().is_bound()) field_newBSSToOldBSSIE = other_value.newBSSToOldBSSIE();
else field_newBSSToOldBSSIE.clean_up();
}

void BSSMAP__IE__NewBSSToOldBSSInfo::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_newBSSToOldBSSIE.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__NewBSSToOldBSSInfo::get_descriptor() const { return &BSSMAP__IE__NewBSSToOldBSSInfo_descr_; }
BSSMAP__IE__NewBSSToOldBSSInfo& BSSMAP__IE__NewBSSToOldBSSInfo::operator=(const BSSMAP__IE__NewBSSToOldBSSInfo& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.newBSSToOldBSSIE().is_bound()) field_newBSSToOldBSSIE = other_value.newBSSToOldBSSIE();
  else field_newBSSToOldBSSIE.clean_up();
}
return *this;
}

boolean BSSMAP__IE__NewBSSToOldBSSInfo::operator==(const BSSMAP__IE__NewBSSToOldBSSInfo& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_newBSSToOldBSSIE==other_value.field_newBSSToOldBSSIE;
}

boolean BSSMAP__IE__NewBSSToOldBSSInfo::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (OPTIONAL_OMIT == field_newBSSToOldBSSIE.get_selection() || field_newBSSToOldBSSIE.is_bound());
}
boolean BSSMAP__IE__NewBSSToOldBSSInfo::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && (OPTIONAL_OMIT == field_newBSSToOldBSSIE.get_selection() || field_newBSSToOldBSSIE.is_value());
}
int BSSMAP__IE__NewBSSToOldBSSInfo::size_of() const
{
  int ret_val = 2;
  if (field_newBSSToOldBSSIE.ispresent()) ret_val++;
  return ret_val;
}

void BSSMAP__IE__NewBSSToOldBSSInfo::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", newBSSToOldBSSIE := ");
field_newBSSToOldBSSIE.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__NewBSSToOldBSSInfo::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (!newBSSToOldBSSIE().is_bound()) newBSSToOldBSSIE() = OMIT_VALUE;
else newBSSToOldBSSIE().set_implicit_omit();
}

void BSSMAP__IE__NewBSSToOldBSSInfo::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) newBSSToOldBSSIE().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "newBSSToOldBSSIE")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          newBSSToOldBSSIE().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo");
  }
}

void BSSMAP__IE__NewBSSToOldBSSInfo::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_newBSSToOldBSSIE.encode_text(text_buf);
}

void BSSMAP__IE__NewBSSToOldBSSInfo::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_newBSSToOldBSSIE.decode_text(text_buf);
}

void BSSMAP__IE__NewBSSToOldBSSInfo::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__NewBSSToOldBSSInfo::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__NewBSSToOldBSSInfo::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__NewBSSToOldBSSInfo_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__NewBSSToOldBSSInfo_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__NewBSSToOldBSSInfo_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  if (limit > 0 && value_of_length_field1 > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_newBSSToOldBSSIE = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCTN_descr_.raw->forceomit);
  decoded_field_length = field_newBSSToOldBSSIE().RAW_decode(General__Types::OCTN_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_newBSSToOldBSSIE = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  }
  }
  }
  else field_newBSSToOldBSSIE=OMIT_VALUE;
  if (field_elementIdentifier !=  os_74) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__NewBSSToOldBSSInfo::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__NewBSSToOldBSSInfo_lengthIndicator_descr_.raw);
  if (field_newBSSToOldBSSIE.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCTN_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__NewBSSToOldBSSInfo_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  if (field_newBSSToOldBSSIE.ispresent()) {
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  } else {
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = 0;
  }
  if (field_newBSSToOldBSSIE.ispresent()) {
  encoded_length += field_newBSSToOldBSSIE().RAW_encode(General__Types::OCTN_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_elementIdentifier !=  os_74) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_74.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__NewBSSToOldBSSInfo_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_newBSSToOldBSSIE;
};

void BSSMAP__IE__NewBSSToOldBSSInfo_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_newBSSToOldBSSIE = ANY_OR_OMIT;
}
}
}

void BSSMAP__IE__NewBSSToOldBSSInfo_template::copy_value(const BSSMAP__IE__NewBSSToOldBSSInfo& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.newBSSToOldBSSIE().is_bound()) {
  if (other_value.newBSSToOldBSSIE().ispresent()) single_value->field_newBSSToOldBSSIE = other_value.newBSSToOldBSSIE()();
  else single_value->field_newBSSToOldBSSIE = OMIT_VALUE;
} else {
  single_value->field_newBSSToOldBSSIE.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__NewBSSToOldBSSInfo_template::copy_template(const BSSMAP__IE__NewBSSToOldBSSInfo_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.newBSSToOldBSSIE().get_selection()) {
single_value->field_newBSSToOldBSSIE = other_value.newBSSToOldBSSIE();
} else {
single_value->field_newBSSToOldBSSIE.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__NewBSSToOldBSSInfo_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__NewBSSToOldBSSInfo_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__NewBSSToOldBSSInfo_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__NewBSSToOldBSSInfo_template::BSSMAP__IE__NewBSSToOldBSSInfo_template()
{
}

BSSMAP__IE__NewBSSToOldBSSInfo_template::BSSMAP__IE__NewBSSToOldBSSInfo_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__NewBSSToOldBSSInfo_template::BSSMAP__IE__NewBSSToOldBSSInfo_template(const BSSMAP__IE__NewBSSToOldBSSInfo& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__NewBSSToOldBSSInfo_template::BSSMAP__IE__NewBSSToOldBSSInfo_template(const OPTIONAL<BSSMAP__IE__NewBSSToOldBSSInfo>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__NewBSSToOldBSSInfo&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo from an unbound optional field.");
}
}

BSSMAP__IE__NewBSSToOldBSSInfo_template::BSSMAP__IE__NewBSSToOldBSSInfo_template(BSSMAP__IE__NewBSSToOldBSSInfo_template* p_precondition, BSSMAP__IE__NewBSSToOldBSSInfo_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__NewBSSToOldBSSInfo_template::BSSMAP__IE__NewBSSToOldBSSInfo_template(Dynamic_Match_Interface<BSSMAP__IE__NewBSSToOldBSSInfo>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__NewBSSToOldBSSInfo>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__NewBSSToOldBSSInfo_template::BSSMAP__IE__NewBSSToOldBSSInfo_template(const BSSMAP__IE__NewBSSToOldBSSInfo_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__NewBSSToOldBSSInfo_template::~BSSMAP__IE__NewBSSToOldBSSInfo_template()
{
clean_up();
}

BSSMAP__IE__NewBSSToOldBSSInfo_template& BSSMAP__IE__NewBSSToOldBSSInfo_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__NewBSSToOldBSSInfo_template& BSSMAP__IE__NewBSSToOldBSSInfo_template::operator=(const BSSMAP__IE__NewBSSToOldBSSInfo& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__NewBSSToOldBSSInfo_template& BSSMAP__IE__NewBSSToOldBSSInfo_template::operator=(const OPTIONAL<BSSMAP__IE__NewBSSToOldBSSInfo>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__NewBSSToOldBSSInfo&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo.");
}
return *this;
}

BSSMAP__IE__NewBSSToOldBSSInfo_template& BSSMAP__IE__NewBSSToOldBSSInfo_template::operator=(const BSSMAP__IE__NewBSSToOldBSSInfo_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__NewBSSToOldBSSInfo_template::match(const BSSMAP__IE__NewBSSToOldBSSInfo& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.newBSSToOldBSSIE().is_bound()) return FALSE;
if((other_value.newBSSToOldBSSIE().ispresent() ? !single_value->field_newBSSToOldBSSIE.match((const OCTETSTRING&)other_value.newBSSToOldBSSIE(), legacy) : !single_value->field_newBSSToOldBSSIE.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo.");
}
return FALSE;
}

boolean BSSMAP__IE__NewBSSToOldBSSInfo_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || (single_value->field_newBSSToOldBSSIE.is_omit() || single_value->field_newBSSToOldBSSIE.is_bound());
}

boolean BSSMAP__IE__NewBSSToOldBSSInfo_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && (single_value->field_newBSSToOldBSSIE.is_omit() || single_value->field_newBSSToOldBSSIE.is_value());
}

void BSSMAP__IE__NewBSSToOldBSSInfo_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__NewBSSToOldBSSInfo BSSMAP__IE__NewBSSToOldBSSInfo_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo.");
BSSMAP__IE__NewBSSToOldBSSInfo ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_newBSSToOldBSSIE.is_omit()) ret_val.newBSSToOldBSSIE() = OMIT_VALUE;
else if (single_value->field_newBSSToOldBSSIE.is_bound()) {
ret_val.newBSSToOldBSSIE() = single_value->field_newBSSToOldBSSIE.valueof();
}
return ret_val;
}

void BSSMAP__IE__NewBSSToOldBSSInfo_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__NewBSSToOldBSSInfo_template[list_length];
}

BSSMAP__IE__NewBSSToOldBSSInfo_template& BSSMAP__IE__NewBSSToOldBSSInfo_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__NewBSSToOldBSSInfo_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__NewBSSToOldBSSInfo_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__NewBSSToOldBSSInfo_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__NewBSSToOldBSSInfo_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& BSSMAP__IE__NewBSSToOldBSSInfo_template::newBSSToOldBSSIE()
{
set_specific();
return single_value->field_newBSSToOldBSSIE;
}

const OCTETSTRING_template& BSSMAP__IE__NewBSSToOldBSSInfo_template::newBSSToOldBSSIE() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field newBSSToOldBSSIE of a non-specific template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo.");
return single_value->field_newBSSToOldBSSIE;
}

int BSSMAP__IE__NewBSSToOldBSSInfo_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_newBSSToOldBSSIE.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo.");
  }
  return 0;
}

void BSSMAP__IE__NewBSSToOldBSSInfo_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", newBSSToOldBSSIE := ");
single_value->field_newBSSToOldBSSIE.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__NewBSSToOldBSSInfo_template::log_match(const BSSMAP__IE__NewBSSToOldBSSInfo& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.newBSSToOldBSSIE().ispresent()){
if(!single_value->field_newBSSToOldBSSIE.match(match_value.newBSSToOldBSSIE(), legacy)){
TTCN_Logger::log_logmatch_info(".newBSSToOldBSSIE");
single_value->field_newBSSToOldBSSIE.log_match(match_value.newBSSToOldBSSIE(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_newBSSToOldBSSIE.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".newBSSToOldBSSIE := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_newBSSToOldBSSIE.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", newBSSToOldBSSIE := ");
if (match_value.newBSSToOldBSSIE().ispresent()) {
single_value->field_newBSSToOldBSSIE.log_match(match_value.newBSSToOldBSSIE(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_newBSSToOldBSSIE.log();
if (single_value->field_newBSSToOldBSSIE.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__NewBSSToOldBSSInfo_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (!newBSSToOldBSSIE().is_bound()) newBSSToOldBSSIE() = OMIT_VALUE;
else newBSSToOldBSSIE().set_implicit_omit();
}

void BSSMAP__IE__NewBSSToOldBSSInfo_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_newBSSToOldBSSIE.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo.");
}
}

void BSSMAP__IE__NewBSSToOldBSSInfo_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_newBSSToOldBSSIE.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__NewBSSToOldBSSInfo_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo.");
}
}

void BSSMAP__IE__NewBSSToOldBSSInfo_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__NewBSSToOldBSSInfo_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) newBSSToOldBSSIE().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "newBSSToOldBSSIE")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          newBSSToOldBSSIE().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__NewBSSToOldBSSInfo_template* precondition = new BSSMAP__IE__NewBSSToOldBSSInfo_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__NewBSSToOldBSSInfo_template* implied_template = new BSSMAP__IE__NewBSSToOldBSSInfo_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__NewBSSToOldBSSInfo_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__NewBSSToOldBSSInfo_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo");
single_value->field_newBSSToOldBSSIE.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_NewBSSToOldBSSInfo");
}

boolean BSSMAP__IE__NewBSSToOldBSSInfo_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__NewBSSToOldBSSInfo_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__InterSystemInfo::BSSMAP__IE__InterSystemInfo()
{
}

BSSMAP__IE__InterSystemInfo::BSSMAP__IE__InterSystemInfo(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_interSystemInfoTranspCont)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_interSystemInfoTranspCont(par_interSystemInfoTranspCont)
{
}

BSSMAP__IE__InterSystemInfo::BSSMAP__IE__InterSystemInfo(const BSSMAP__IE__InterSystemInfo& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.interSystemInfoTranspCont().is_bound()) field_interSystemInfoTranspCont = other_value.interSystemInfoTranspCont();
else field_interSystemInfoTranspCont.clean_up();
}

void BSSMAP__IE__InterSystemInfo::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_interSystemInfoTranspCont.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__InterSystemInfo::get_descriptor() const { return &BSSMAP__IE__InterSystemInfo_descr_; }
BSSMAP__IE__InterSystemInfo& BSSMAP__IE__InterSystemInfo::operator=(const BSSMAP__IE__InterSystemInfo& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.interSystemInfoTranspCont().is_bound()) field_interSystemInfoTranspCont = other_value.interSystemInfoTranspCont();
  else field_interSystemInfoTranspCont.clean_up();
}
return *this;
}

boolean BSSMAP__IE__InterSystemInfo::operator==(const BSSMAP__IE__InterSystemInfo& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_interSystemInfoTranspCont==other_value.field_interSystemInfoTranspCont;
}

boolean BSSMAP__IE__InterSystemInfo::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_interSystemInfoTranspCont.is_bound());
}
boolean BSSMAP__IE__InterSystemInfo::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_interSystemInfoTranspCont.is_value();
}
void BSSMAP__IE__InterSystemInfo::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", interSystemInfoTranspCont := ");
field_interSystemInfoTranspCont.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__InterSystemInfo::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (interSystemInfoTranspCont().is_bound()) interSystemInfoTranspCont().set_implicit_omit();
}

void BSSMAP__IE__InterSystemInfo::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) interSystemInfoTranspCont().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "interSystemInfoTranspCont")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          interSystemInfoTranspCont().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_InterSystemInfo: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_InterSystemInfo");
  }
}

void BSSMAP__IE__InterSystemInfo::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_interSystemInfoTranspCont.encode_text(text_buf);
}

void BSSMAP__IE__InterSystemInfo::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_interSystemInfoTranspCont.decode_text(text_buf);
}

void BSSMAP__IE__InterSystemInfo::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__InterSystemInfo::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__InterSystemInfo::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__InterSystemInfo_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__InterSystemInfo_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__InterSystemInfo_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCTN_descr_.raw->forceomit);
  decoded_field_length = field_interSystemInfoTranspCont.RAW_decode(General__Types::OCTN_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_76) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__InterSystemInfo::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__InterSystemInfo_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCTN_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__InterSystemInfo_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_interSystemInfoTranspCont.RAW_encode(General__Types::OCTN_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier !=  os_76) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_76.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__InterSystemInfo_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_interSystemInfoTranspCont;
};

void BSSMAP__IE__InterSystemInfo_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_interSystemInfoTranspCont = ANY_VALUE;
}
}
}

void BSSMAP__IE__InterSystemInfo_template::copy_value(const BSSMAP__IE__InterSystemInfo& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.interSystemInfoTranspCont().is_bound()) {
  single_value->field_interSystemInfoTranspCont = other_value.interSystemInfoTranspCont();
} else {
  single_value->field_interSystemInfoTranspCont.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__InterSystemInfo_template::copy_template(const BSSMAP__IE__InterSystemInfo_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.interSystemInfoTranspCont().get_selection()) {
single_value->field_interSystemInfoTranspCont = other_value.interSystemInfoTranspCont();
} else {
single_value->field_interSystemInfoTranspCont.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__InterSystemInfo_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__InterSystemInfo_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__InterSystemInfo_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__InterSystemInfo_template::BSSMAP__IE__InterSystemInfo_template()
{
}

BSSMAP__IE__InterSystemInfo_template::BSSMAP__IE__InterSystemInfo_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__InterSystemInfo_template::BSSMAP__IE__InterSystemInfo_template(const BSSMAP__IE__InterSystemInfo& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__InterSystemInfo_template::BSSMAP__IE__InterSystemInfo_template(const OPTIONAL<BSSMAP__IE__InterSystemInfo>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__InterSystemInfo&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo from an unbound optional field.");
}
}

BSSMAP__IE__InterSystemInfo_template::BSSMAP__IE__InterSystemInfo_template(BSSMAP__IE__InterSystemInfo_template* p_precondition, BSSMAP__IE__InterSystemInfo_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__InterSystemInfo_template::BSSMAP__IE__InterSystemInfo_template(Dynamic_Match_Interface<BSSMAP__IE__InterSystemInfo>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__InterSystemInfo>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__InterSystemInfo_template::BSSMAP__IE__InterSystemInfo_template(const BSSMAP__IE__InterSystemInfo_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__InterSystemInfo_template::~BSSMAP__IE__InterSystemInfo_template()
{
clean_up();
}

BSSMAP__IE__InterSystemInfo_template& BSSMAP__IE__InterSystemInfo_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__InterSystemInfo_template& BSSMAP__IE__InterSystemInfo_template::operator=(const BSSMAP__IE__InterSystemInfo& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__InterSystemInfo_template& BSSMAP__IE__InterSystemInfo_template::operator=(const OPTIONAL<BSSMAP__IE__InterSystemInfo>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__InterSystemInfo&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo.");
}
return *this;
}

BSSMAP__IE__InterSystemInfo_template& BSSMAP__IE__InterSystemInfo_template::operator=(const BSSMAP__IE__InterSystemInfo_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__InterSystemInfo_template::match(const BSSMAP__IE__InterSystemInfo& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.interSystemInfoTranspCont().is_bound()) return FALSE;
if(!single_value->field_interSystemInfoTranspCont.match(other_value.interSystemInfoTranspCont(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo.");
}
return FALSE;
}

boolean BSSMAP__IE__InterSystemInfo_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_interSystemInfoTranspCont.is_bound();
}

boolean BSSMAP__IE__InterSystemInfo_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_interSystemInfoTranspCont.is_value();
}

void BSSMAP__IE__InterSystemInfo_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__InterSystemInfo BSSMAP__IE__InterSystemInfo_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo.");
BSSMAP__IE__InterSystemInfo ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_interSystemInfoTranspCont.is_bound()) {
ret_val.interSystemInfoTranspCont() = single_value->field_interSystemInfoTranspCont.valueof();
}
return ret_val;
}

void BSSMAP__IE__InterSystemInfo_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__InterSystemInfo_template[list_length];
}

BSSMAP__IE__InterSystemInfo_template& BSSMAP__IE__InterSystemInfo_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__InterSystemInfo_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__InterSystemInfo_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__InterSystemInfo_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__InterSystemInfo_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& BSSMAP__IE__InterSystemInfo_template::interSystemInfoTranspCont()
{
set_specific();
return single_value->field_interSystemInfoTranspCont;
}

const OCTETSTRING_template& BSSMAP__IE__InterSystemInfo_template::interSystemInfoTranspCont() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field interSystemInfoTranspCont of a non-specific template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo.");
return single_value->field_interSystemInfoTranspCont;
}

int BSSMAP__IE__InterSystemInfo_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo.");
  }
  return 0;
}

void BSSMAP__IE__InterSystemInfo_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", interSystemInfoTranspCont := ");
single_value->field_interSystemInfoTranspCont.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__InterSystemInfo_template::log_match(const BSSMAP__IE__InterSystemInfo& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_interSystemInfoTranspCont.match(match_value.interSystemInfoTranspCont(), legacy)){
TTCN_Logger::log_logmatch_info(".interSystemInfoTranspCont");
single_value->field_interSystemInfoTranspCont.log_match(match_value.interSystemInfoTranspCont(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", interSystemInfoTranspCont := ");
single_value->field_interSystemInfoTranspCont.log_match(match_value.interSystemInfoTranspCont(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__InterSystemInfo_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (interSystemInfoTranspCont().is_bound()) interSystemInfoTranspCont().set_implicit_omit();
}

void BSSMAP__IE__InterSystemInfo_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_interSystemInfoTranspCont.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo.");
}
}

void BSSMAP__IE__InterSystemInfo_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_interSystemInfoTranspCont.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__InterSystemInfo_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo.");
}
}

void BSSMAP__IE__InterSystemInfo_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__InterSystemInfo_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_InterSystemInfo has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) interSystemInfoTranspCont().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "interSystemInfoTranspCont")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          interSystemInfoTranspCont().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_InterSystemInfo: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__InterSystemInfo_template* precondition = new BSSMAP__IE__InterSystemInfo_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__InterSystemInfo_template* implied_template = new BSSMAP__IE__InterSystemInfo_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__InterSystemInfo_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_InterSystemInfo");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__InterSystemInfo_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_InterSystemInfo");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_InterSystemInfo");
single_value->field_interSystemInfoTranspCont.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_InterSystemInfo");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_InterSystemInfo");
}

boolean BSSMAP__IE__InterSystemInfo_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__InterSystemInfo_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


const AuthorisedPLMN AuthorisedPLMN__List::UNBOUND_ELEM;
AuthorisedPLMN__List::AuthorisedPLMN__List()
{
val_ptr = NULL;
}

AuthorisedPLMN__List::AuthorisedPLMN__List(null_type)
{
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
}

AuthorisedPLMN__List::AuthorisedPLMN__List(const AuthorisedPLMN__List& other_value)
{
if (!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.AuthorisedPLMN_List.");
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}

AuthorisedPLMN__List::~AuthorisedPLMN__List()
{
clean_up();
if (val_ptr != NULL) val_ptr = NULL;
}

void AuthorisedPLMN__List::clean_up()
{
if (val_ptr != NULL) {
if (val_ptr->ref_count > 1) {
val_ptr->ref_count--;
val_ptr = NULL;
}
else if (val_ptr->ref_count == 1) {
for (int elem_count = 0; elem_count < val_ptr->n_elements;
elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)
delete val_ptr->value_elements[elem_count];
free_pointers((void**)val_ptr->value_elements);
delete val_ptr;
val_ptr = NULL;
}
else
TTCN_error("Internal error: Invalid reference counter in a record of/set of value.");
}
}

AuthorisedPLMN__List& AuthorisedPLMN__List::operator=(null_type)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
return *this;
}

AuthorisedPLMN__List& AuthorisedPLMN__List::operator=(const AuthorisedPLMN__List& other_value)
{
if (other_value.val_ptr == NULL) TTCN_error("Assigning an unbound value of type @BSSAP_Types.AuthorisedPLMN_List.");
if (this != &other_value) {
clean_up();
val_ptr = other_value.val_ptr;
val_ptr->ref_count++;
}
return *this;
}

boolean AuthorisedPLMN__List::operator==(null_type) const
{
if (val_ptr == NULL)
TTCN_error("The left operand of comparison is an unbound value of type @BSSAP_Types.AuthorisedPLMN_List.");
return val_ptr->n_elements == 0 ;
}

boolean AuthorisedPLMN__List::operator==(const AuthorisedPLMN__List& other_value) const
{
if (val_ptr == NULL) TTCN_error("The left operand of comparison is an unbound value of type @BSSAP_Types.AuthorisedPLMN_List.");
if (other_value.val_ptr == NULL) TTCN_error("The right operand of comparison is an unbound value of type @BSSAP_Types.AuthorisedPLMN_List.");
if (val_ptr == other_value.val_ptr) return TRUE;
if (val_ptr->n_elements != (other_value.val_ptr)->n_elements)
return FALSE;
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
if ((other_value.val_ptr)->value_elements[elem_count] != NULL){
  if (*val_ptr->value_elements[elem_count] != *(other_value.val_ptr)->value_elements[elem_count]) return FALSE;
} else return FALSE;
} else {
if ((other_value.val_ptr)->value_elements[elem_count] != NULL) return FALSE;
}
}
return TRUE;
}

AuthorisedPLMN& AuthorisedPLMN__List::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of type @BSSAP_Types.AuthorisedPLMN_List using a negative index: %d.", index_value);
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (index_value >= val_ptr->n_elements) ? index_value + 1 : val_ptr->n_elements;
new_val_ptr->value_elements = (AuthorisedPLMN**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++){
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new AuthorisedPLMN(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (index_value >= val_ptr->n_elements) set_size(index_value + 1);
if (val_ptr->value_elements[index_value] == NULL) {
val_ptr->value_elements[index_value] = new AuthorisedPLMN;
}
return *val_ptr->value_elements[index_value];
}

AuthorisedPLMN& AuthorisedPLMN__List::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @BSSAP_Types.AuthorisedPLMN_List.");
return (*this)[(int)index_value];
}

const AuthorisedPLMN& AuthorisedPLMN__List::operator[](int index_value) const
{
if (val_ptr == NULL)
TTCN_error("Accessing an element in an unbound value of type @BSSAP_Types.AuthorisedPLMN_List.");
if (index_value < 0) TTCN_error("Accessing an element of type @BSSAP_Types.AuthorisedPLMN_List using a negative index: %d.", index_value);
if (index_value >= val_ptr->n_elements) TTCN_error("Index overflow in a value of type @BSSAP_Types.AuthorisedPLMN_List: The index is %d, but the value has only %d elements.", index_value, val_ptr->n_elements);
return (val_ptr->value_elements[index_value] == NULL) ?
UNBOUND_ELEM : *val_ptr->value_elements[index_value];
}

const AuthorisedPLMN& AuthorisedPLMN__List::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a value of type @BSSAP_Types.AuthorisedPLMN_List.");
return (*this)[(int)index_value];
}

AuthorisedPLMN__List AuthorisedPLMN__List::operator<<=(int rotate_count) const
{
return *this >>= (-rotate_count);
}

AuthorisedPLMN__List AuthorisedPLMN__List::operator<<=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate left operator.");
return *this >>= (int)(-rotate_count);
}

AuthorisedPLMN__List AuthorisedPLMN__List::operator>>=(const INTEGER& rotate_count) const
{
rotate_count.must_bound("Unbound integer operand of rotate right operator.");
return *this >>= (int)rotate_count;
}

AuthorisedPLMN__List AuthorisedPLMN__List::operator>>=(int rotate_count) const
{
if (val_ptr == NULL) TTCN_error("Performing rotation operation on an unbound value of type @BSSAP_Types.AuthorisedPLMN_List.");
if (val_ptr->n_elements == 0) return *this;
int rc;
if (rotate_count>=0) rc = rotate_count % val_ptr->n_elements;
else rc = val_ptr->n_elements - ((-rotate_count) % val_ptr->n_elements);
if (rc == 0) return *this;
AuthorisedPLMN__List ret_val;
ret_val.set_size(val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[(i+rc)%val_ptr->n_elements] =new AuthorisedPLMN(*val_ptr->value_elements[i]);
}
}
return ret_val;
}

AuthorisedPLMN__List AuthorisedPLMN__List::operator+(const AuthorisedPLMN__List& other_value) const
{
if (val_ptr == NULL || other_value.val_ptr == NULL) TTCN_error("Unbound operand of @BSSAP_Types.AuthorisedPLMN_List concatenation.");
if (val_ptr->n_elements == 0) return other_value;
if (other_value.val_ptr->n_elements == 0) return *this;
AuthorisedPLMN__List ret_val;
ret_val.set_size(val_ptr->n_elements+other_value.val_ptr->n_elements);
for (int i=0; i<val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new AuthorisedPLMN(*val_ptr->value_elements[i]);
}
}
for (int i=0; i<other_value.val_ptr->n_elements; i++) {
if (other_value.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+val_ptr->n_elements] = new AuthorisedPLMN(*other_value.val_ptr->value_elements[i]);
}
}
return ret_val;
}

AuthorisedPLMN__List AuthorisedPLMN__List::substr(int index, int returncount) const
{
if (val_ptr == NULL) TTCN_error("The first argument of substr() is an unbound value of type @BSSAP_Types.AuthorisedPLMN_List.");
check_substr_arguments(val_ptr->n_elements, index, returncount, "@BSSAP_Types.AuthorisedPLMN_List","element");
AuthorisedPLMN__List ret_val;
ret_val.set_size(returncount);
for (int i=0; i<returncount; i++) {
if (val_ptr->value_elements[i+index] != NULL) {
ret_val.val_ptr->value_elements[i] = new AuthorisedPLMN(*val_ptr->value_elements[i+index]);
}
}
return ret_val;
}

AuthorisedPLMN__List AuthorisedPLMN__List::replace(int index, int len, const AuthorisedPLMN__List& repl) const
{
if (val_ptr == NULL) TTCN_error("The first argument of replace() is an unbound value of type @BSSAP_Types.AuthorisedPLMN_List.");
if (repl.val_ptr == NULL) TTCN_error("The fourth argument of replace() is an unbound value of type @BSSAP_Types.AuthorisedPLMN_List.");
check_replace_arguments(val_ptr->n_elements, index, len, "@BSSAP_Types.AuthorisedPLMN_List","element");
AuthorisedPLMN__List ret_val;
ret_val.set_size(val_ptr->n_elements + repl.val_ptr->n_elements - len);
for (int i = 0; i < index; i++) {
if (val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i] = new AuthorisedPLMN(*val_ptr->value_elements[i]);
}
}
for (int i = 0; i < repl.val_ptr->n_elements; i++) {
if (repl.val_ptr->value_elements[i] != NULL) {
ret_val.val_ptr->value_elements[i+index] = new AuthorisedPLMN(*repl.val_ptr->value_elements[i]);
}
}
for (int i = 0; i < val_ptr->n_elements - index - len; i++) {
if (val_ptr->value_elements[index+i+len] != NULL) {
ret_val.val_ptr->value_elements[index+i+repl.val_ptr->n_elements] = new AuthorisedPLMN(*val_ptr->value_elements[index+i+len]);
}
}
return ret_val;
}

AuthorisedPLMN__List AuthorisedPLMN__List::replace(int index, int len, const AuthorisedPLMN__List_template& repl) const
{
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return replace(index, len, repl.valueof());
}

void AuthorisedPLMN__List::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a value of type @BSSAP_Types.AuthorisedPLMN_List.");
if (val_ptr == NULL) {
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = 0;
val_ptr->value_elements = NULL;
} else if (val_ptr->ref_count > 1) {
struct recordof_setof_struct *new_val_ptr = new recordof_setof_struct;
new_val_ptr->ref_count = 1;
new_val_ptr->n_elements = (new_size < val_ptr->n_elements) ? new_size : val_ptr->n_elements;
new_val_ptr->value_elements = (AuthorisedPLMN**)allocate_pointers(new_val_ptr->n_elements);
for (int elem_count = 0; elem_count < new_val_ptr->n_elements; elem_count++) {
if (val_ptr->value_elements[elem_count] != NULL){
new_val_ptr->value_elements[elem_count] = new AuthorisedPLMN(*(val_ptr->value_elements[elem_count]));
}
}
clean_up();
val_ptr = new_val_ptr;
}
if (new_size > val_ptr->n_elements) {
val_ptr->value_elements = (AuthorisedPLMN**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
#ifdef TITAN_MEMORY_DEBUG_SET_RECORD_OF
if((val_ptr->n_elements/1000)!=(new_size/1000)) TTCN_warning("New size of type @BSSAP_Types.AuthorisedPLMN_List: %d",new_size);
#endif
val_ptr->n_elements = new_size;
} else if (new_size < val_ptr->n_elements) {
for (int elem_count = new_size; elem_count < val_ptr->n_elements; elem_count++)
if (val_ptr->value_elements[elem_count] != NULL)delete val_ptr->value_elements[elem_count];
val_ptr->value_elements = (AuthorisedPLMN**)reallocate_pointers((void**)val_ptr->value_elements, val_ptr->n_elements, new_size);
val_ptr->n_elements = new_size;
}
}

boolean AuthorisedPLMN__List::is_value() const
{
if (val_ptr == NULL) return FALSE;
for(int i = 0; i < val_ptr->n_elements; ++i) {
if (val_ptr->value_elements[i] == NULL || !val_ptr->value_elements[i]->is_value()) return FALSE;
}
return TRUE;
}

int AuthorisedPLMN__List::size_of() const
{
if (val_ptr == NULL) TTCN_error("Performing sizeof operation on an unbound value of type @BSSAP_Types.AuthorisedPLMN_List.");
return val_ptr->n_elements;
}

int AuthorisedPLMN__List::lengthof() const
{
if (val_ptr == NULL) TTCN_error("Performing lengthof operation on an unbound value of type @BSSAP_Types.AuthorisedPLMN_List.");
for (int my_length=val_ptr->n_elements; my_length>0; my_length--) if (val_ptr->value_elements[my_length-1] != NULL) return my_length;
return 0;
}

void AuthorisedPLMN__List::log() const
{
if (val_ptr == NULL) {;
TTCN_Logger::log_event_unbound();
return;
}
switch (val_ptr->n_elements) {
case 0:
TTCN_Logger::log_event_str("{ }");
break;
default:
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
(*this)[elem_count].log();
}
TTCN_Logger::log_event_str(" }");
}
}

void AuthorisedPLMN__List::set_implicit_omit()
{
if (val_ptr == NULL) return;
for (int i = 0; i < val_ptr->n_elements; i++) {
if (val_ptr->value_elements[i] != NULL) val_ptr->value_elements[i]->set_implicit_omit();
}
}

void AuthorisedPLMN__List::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE|Module_Param::BC_LIST, "record of value");
  switch (param.get_operation_type()) {
  case Module_Param::OT_ASSIGN:
    if (param.get_type()==Module_Param::MP_Value_List && param.get_size()==0) {
      *this = NULL_VALUE;
      return;
    }
    switch (param.get_type()) {
    case Module_Param::MP_Value_List:
      set_size(param.get_size());
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if (curr->get_type()!=Module_Param::MP_NotUsed) {
          (*this)[i].set_param(*curr);
          if (!(*this)[i].is_bound()) {
            delete val_ptr->value_elements[i];
            val_ptr->value_elements[i] = NULL;
          }
        }
      }
      break;
    case Module_Param::MP_Indexed_List:
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        (*this)[curr->get_id()->get_index()].set_param(*curr);
        if (!(*this)[curr->get_id()->get_index()].is_bound()) {
          delete val_ptr->value_elements[curr->get_id()->get_index()];
          val_ptr->value_elements[curr->get_id()->get_index()] = NULL;
        }
      }
      break;
    default:
      param.type_error("record of value", "@BSSAP_Types.AuthorisedPLMN_List");
    }
    break;
  case Module_Param::OT_CONCAT:
    switch (param.get_type()) {
    case Module_Param::MP_Value_List: {
      if (!is_bound()) *this = NULL_VALUE;
      int start_idx = lengthof();
      for (size_t i=0; i<param.get_size(); ++i) {
        Module_Param* const curr = param.get_elem(i);
        if ((curr->get_type()!=Module_Param::MP_NotUsed)) {
          (*this)[start_idx+(int)i].set_param(*curr);
        }
      }
    } break;
    case Module_Param::MP_Indexed_List:
      param.error("Cannot concatenate an indexed value list");
      break;
    default:
      param.type_error("record of value", "@BSSAP_Types.AuthorisedPLMN_List");
    }
    break;
  default:
    TTCN_error("Internal error: Unknown operation type.");
  }
}

void AuthorisedPLMN__List::encode_text(Text_Buf& text_buf) const
{
if (val_ptr == NULL) TTCN_error("Text encoder: Encoding an unbound value of type @BSSAP_Types.AuthorisedPLMN_List.");
text_buf.push_int(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++)
(*this)[elem_count].encode_text(text_buf);
}

void AuthorisedPLMN__List::decode_text(Text_Buf& text_buf)
{
clean_up();
val_ptr = new recordof_setof_struct;
val_ptr->ref_count = 1;
val_ptr->n_elements = text_buf.pull_int().get_val();
if (val_ptr->n_elements < 0) TTCN_error("Text decoder: Negative size was received for a value of type @BSSAP_Types.AuthorisedPLMN_List.");
val_ptr->value_elements = (AuthorisedPLMN**)allocate_pointers(val_ptr->n_elements);
for (int elem_count = 0; elem_count < val_ptr->n_elements; elem_count++) {
val_ptr->value_elements[elem_count] = new AuthorisedPLMN;
val_ptr->value_elements[elem_count]->decode_text(text_buf);
}
}

void AuthorisedPLMN__List::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void AuthorisedPLMN__List::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int AuthorisedPLMN__List::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean /*no_err*/, int sel_field, boolean first_call, const RAW_Force_Omit*){
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int decoded_field_length=0;
  size_t start_of_field=0;
  if(first_call) {
    clean_up();
    val_ptr=new recordof_setof_struct;
    val_ptr->ref_count=1;
    val_ptr->n_elements=0;
    val_ptr->value_elements=NULL;
  }
  int start_field=val_ptr->n_elements;
  if(p_td.raw->fieldlength || sel_field!=-1){
    int a=0;
    if(sel_field==-1) sel_field=p_td.raw->fieldlength;
    start_of_field=p_buf.get_pos_bit();
    for(a=0;a<sel_field;a++){
      decoded_field_length=(*this)[a+start_field].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        while(a>=0){
          delete &(*this)[a+start_field];
          a--;
          val_ptr->n_elements--;
        }
        p_buf.set_pos_bit(start_of_field);
        return decoded_field_length;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
    }
    if(a==0) val_ptr->n_elements=0;
  } else {
    if(limit==0){
      if(!first_call) return -1;
      val_ptr->n_elements=0;
      return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
    }
    int a=start_field;
    while(limit>0){
      start_of_field=p_buf.get_pos_bit();
      decoded_field_length=(*this)[a].RAW_decode(*p_td.oftype_descr,p_buf,limit,top_bit_ord,TRUE);
      if(decoded_field_length < 0){
        delete &(*this)[a];
        val_ptr->n_elements--;
        p_buf.set_pos_bit(start_of_field);
        if(a>start_field){
        return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
        } else return -1;
      }
      decoded_length+=decoded_field_length;
      limit-=decoded_field_length;
      a++;
    }
  }
 return decoded_length+p_buf.increase_pos_padd(p_td.raw->padding)+prepaddlength;
}

int AuthorisedPLMN__List::RAW_encode(const TTCN_Typedescriptor_t& p_td,RAW_enc_tree& myleaf) const{
  int encoded_length=0;
  int encoded_num_of_records=p_td.raw->fieldlength?smaller(val_ptr->n_elements, p_td.raw->fieldlength):val_ptr->n_elements;
  myleaf.isleaf=FALSE;
  myleaf.rec_of=TRUE;
  myleaf.body.node.num_of_nodes=encoded_num_of_records;
  myleaf.body.node.nodes=init_nodes_of_enc_tree(encoded_num_of_records);
  for(int a=0;a<encoded_num_of_records;a++){
    myleaf.body.node.nodes[a]=new RAW_enc_tree(TRUE,&myleaf,&(myleaf.curr_pos),a,p_td.oftype_descr->raw);
    encoded_length+=(*this)[a].RAW_encode(*p_td.oftype_descr,*myleaf.body.node.nodes[a]);
  }
 return myleaf.length=encoded_length;
}

void AuthorisedPLMN__List_template::copy_value(const AuthorisedPLMN__List& other_value)
{
if (!other_value.is_bound()) TTCN_error("Initialization of a template of type @BSSAP_Types.AuthorisedPLMN_List with an unbound value.");
single_value.n_elements = other_value.size_of();
single_value.value_elements = (AuthorisedPLMN_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (other_value[elem_count].is_bound()) {
single_value.value_elements[elem_count] = new AuthorisedPLMN_template(other_value[elem_count]);
} else {
single_value.value_elements[elem_count] = new AuthorisedPLMN_template;
}
}
set_selection(SPECIFIC_VALUE);
}

void AuthorisedPLMN__List_template::copy_template(const AuthorisedPLMN__List_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = other_value.single_value.n_elements;
single_value.value_elements = (AuthorisedPLMN_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (UNINITIALIZED_TEMPLATE != other_value.single_value.value_elements[elem_count]->get_selection()) {
single_value.value_elements[elem_count] = new AuthorisedPLMN_template(*other_value.single_value.value_elements[elem_count]);
} else {
single_value.value_elements[elem_count] = new AuthorisedPLMN_template;
}
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new AuthorisedPLMN__List_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new AuthorisedPLMN__List_template(*other_value.implication_.precondition);
implication_.implied_template = new AuthorisedPLMN__List_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.AuthorisedPLMN_List.");
break;
}
set_selection(other_value);
}

boolean AuthorisedPLMN__List_template::match_function_specific(const Base_Type *value_ptr, int value_index, const Restricted_Length_Template *template_ptr, int template_index, boolean legacy)
{
if (value_index >= 0) return ((const AuthorisedPLMN__List_template*)template_ptr)->single_value.value_elements[template_index]->match((*(const AuthorisedPLMN__List*)value_ptr)[value_index], legacy);
else return ((const AuthorisedPLMN__List_template*)template_ptr)->single_value.value_elements[template_index]->is_any_or_omit();
}

AuthorisedPLMN__List_template::AuthorisedPLMN__List_template()
{
}

AuthorisedPLMN__List_template::AuthorisedPLMN__List_template(template_sel other_value)
 : Base_Record_Of_Template(other_value)
{
check_single_selection(other_value);
}

AuthorisedPLMN__List_template::AuthorisedPLMN__List_template(null_type)
 : Base_Record_Of_Template(SPECIFIC_VALUE)
{
single_value.n_elements = 0;
single_value.value_elements = NULL;
}

AuthorisedPLMN__List_template::AuthorisedPLMN__List_template(const AuthorisedPLMN__List& other_value)
{
copy_value(other_value);
}

AuthorisedPLMN__List_template::AuthorisedPLMN__List_template(const OPTIONAL<AuthorisedPLMN__List>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const AuthorisedPLMN__List&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.AuthorisedPLMN_List from an unbound optional field.");
}
}

AuthorisedPLMN__List_template::AuthorisedPLMN__List_template(AuthorisedPLMN__List_template* p_precondition, AuthorisedPLMN__List_template* p_implied_template)
 : Base_Record_Of_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

AuthorisedPLMN__List_template::AuthorisedPLMN__List_template(Dynamic_Match_Interface<AuthorisedPLMN__List>* p_dyn_match)
 : Base_Record_Of_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<AuthorisedPLMN__List>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

AuthorisedPLMN__List_template::AuthorisedPLMN__List_template(const AuthorisedPLMN__List_template& other_value)
 : Base_Record_Of_Template()
{
copy_template(other_value);
}

AuthorisedPLMN__List_template::~AuthorisedPLMN__List_template()
{
clean_up();
}

void AuthorisedPLMN__List_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
free_pointers((void**)single_value.value_elements);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

AuthorisedPLMN__List_template& AuthorisedPLMN__List_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

AuthorisedPLMN__List_template& AuthorisedPLMN__List_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
return *this;
}

AuthorisedPLMN__List_template& AuthorisedPLMN__List_template::operator=(const AuthorisedPLMN__List& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

AuthorisedPLMN__List_template& AuthorisedPLMN__List_template::operator=(const OPTIONAL<AuthorisedPLMN__List>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const AuthorisedPLMN__List&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.AuthorisedPLMN_List.");
}
return *this;
}

AuthorisedPLMN__List_template& AuthorisedPLMN__List_template::operator=(const AuthorisedPLMN__List_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

AuthorisedPLMN_template& AuthorisedPLMN__List_template::operator[](int index_value)
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @BSSAP_Types.AuthorisedPLMN_List using a negative index: %d.", index_value);
switch (template_selection)
{
  case SPECIFIC_VALUE:
    if(index_value < single_value.n_elements) break;
    // no break
  case OMIT_VALUE:
  case ANY_VALUE:
  case ANY_OR_OMIT:
  case UNINITIALIZED_TEMPLATE:
    set_size(index_value + 1);
    break;
  default:
    TTCN_error("Accessing an element of a non-specific template for type @BSSAP_Types.AuthorisedPLMN_List.");
    break;
}
return *single_value.value_elements[index_value];
}

AuthorisedPLMN_template& AuthorisedPLMN__List_template::operator[](const INTEGER& index_value)
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @BSSAP_Types.AuthorisedPLMN_List.");
return (*this)[(int)index_value];
}

const AuthorisedPLMN_template& AuthorisedPLMN__List_template::operator[](int index_value) const
{
if (index_value < 0) TTCN_error("Accessing an element of a template for type @BSSAP_Types.AuthorisedPLMN_List using a negative index: %d.", index_value);
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing an element of a non-specific template for type @BSSAP_Types.AuthorisedPLMN_List.");
if (index_value >= single_value.n_elements) TTCN_error("Index overflow in a template of type @BSSAP_Types.AuthorisedPLMN_List: The index is %d, but the template has only %d elements.", index_value, single_value.n_elements);
return *single_value.value_elements[index_value];
}

const AuthorisedPLMN_template& AuthorisedPLMN__List_template::operator[](const INTEGER& index_value) const
{
index_value.must_bound("Using an unbound integer value for indexing a template of type @BSSAP_Types.AuthorisedPLMN_List.");
return (*this)[(int)index_value];
}

void AuthorisedPLMN__List_template::set_size(int new_size)
{
if (new_size < 0) TTCN_error("Internal error: Setting a negative size for a template of type @BSSAP_Types.AuthorisedPLMN_List.");
template_sel old_selection = template_selection;
if (old_selection != SPECIFIC_VALUE) {
clean_up();
set_selection(SPECIFIC_VALUE);
single_value.n_elements = 0;
single_value.value_elements = NULL;
}
if (new_size > single_value.n_elements) {
single_value.value_elements = (AuthorisedPLMN_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new AuthorisedPLMN_template(ANY_VALUE);
} else {
for (int elem_count = single_value.n_elements; elem_count < new_size; elem_count++)
single_value.value_elements[elem_count] = new AuthorisedPLMN_template;
}
single_value.n_elements = new_size;
} else if (new_size < single_value.n_elements) {
for (int elem_count = new_size; elem_count < single_value.n_elements; elem_count++)
delete single_value.value_elements[elem_count];
single_value.value_elements = (AuthorisedPLMN_template**)reallocate_pointers((void**)single_value.value_elements, single_value.n_elements, new_size);
single_value.n_elements = new_size;
}
}

int AuthorisedPLMN__List_template::n_elem() const
{
  switch (template_selection) {
  case SPECIFIC_VALUE:
    return single_value.n_elements;
    break;
  case VALUE_LIST:
    return value_list.n_values;
    break;
  default:
    TTCN_error("Performing n_elem");
  }
}

int AuthorisedPLMN__List_template::size_of(boolean is_size) const
{
const char* op_name = is_size ? "size" : "length";
int min_size;
boolean has_any_or_none;
if (is_ifpresent) TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.AuthorisedPLMN_List which has an ifpresent attribute.", op_name);
switch (template_selection)
{
case SPECIFIC_VALUE: {
  min_size = 0;
  has_any_or_none = FALSE;
  int elem_count = single_value.n_elements;
  if (!is_size) { while (elem_count>0 && !single_value.value_elements[elem_count-1]->is_bound()) elem_count--; }
  for (int i=0; i<elem_count; i++) {
    switch (single_value.value_elements[i]->get_selection()) {
    case OMIT_VALUE:
      TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.AuthorisedPLMN_List containing omit element.", op_name);
    case ANY_OR_OMIT:
      has_any_or_none = TRUE;
      break;
    default:
      min_size++;
      break;
    }
  }
} break;
case OMIT_VALUE:
  TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.AuthorisedPLMN_List containing omit value.", op_name);
case ANY_VALUE:
case ANY_OR_OMIT:
  min_size = 0;
  has_any_or_none = TRUE;
  break;
case VALUE_LIST:
{
  if (value_list.n_values<1)
    TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.AuthorisedPLMN_List containing an empty list.", op_name);
  int item_size = value_list.list_value[0].size_of(is_size);
  for (unsigned int i = 1; i < value_list.n_values; i++) {
    if (value_list.list_value[i].size_of(is_size)!=item_size)
      TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.AuthorisedPLMN_List containing a value list with different sizes.", op_name);
  }
  min_size = item_size;
  has_any_or_none = FALSE;
  break;
}
case COMPLEMENTED_LIST:
  TTCN_error("Performing %sof() operation on a template of type @BSSAP_Types.AuthorisedPLMN_List containing complemented list.", op_name);
default:
  TTCN_error("Performing %sof() operation on an uninitialized/unsupported template of type @BSSAP_Types.AuthorisedPLMN_List.", op_name);
}
return check_section_is_single(min_size, has_any_or_none, op_name, "a", "template of type @BSSAP_Types.AuthorisedPLMN_List");
}

boolean AuthorisedPLMN__List_template::match(const AuthorisedPLMN__List& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
int value_length = other_value.size_of();
if (!match_length(value_length)) return FALSE;
switch (template_selection) {
case SPECIFIC_VALUE:
return match_record_of(&other_value, value_length, this, single_value.n_elements, match_function_specific, legacy);
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching with an uninitialized/unsupported template of type @BSSAP_Types.AuthorisedPLMN_List.");
}
return FALSE;
}

boolean AuthorisedPLMN__List_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (!single_value.value_elements[elem_count]->is_value()) return FALSE;
return TRUE;
}

AuthorisedPLMN__List AuthorisedPLMN__List_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.AuthorisedPLMN_List.");
AuthorisedPLMN__List ret_val;
ret_val.set_size(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
if (single_value.value_elements[elem_count]->is_bound()) {
ret_val[elem_count] = single_value.value_elements[elem_count]->valueof();
}
return ret_val;
}

AuthorisedPLMN__List AuthorisedPLMN__List_template::substr(int index, int returncount) const
{
if (!is_value()) TTCN_error("The first argument of function substr() is a template with non-specific value.");
return valueof().substr(index, returncount);
}

AuthorisedPLMN__List AuthorisedPLMN__List_template::replace(int index, int len, const AuthorisedPLMN__List_template& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
if (!repl.is_value()) TTCN_error("The fourth argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl.valueof());
}

AuthorisedPLMN__List AuthorisedPLMN__List_template::replace(int index, int len, const AuthorisedPLMN__List& repl) const
{
if (!is_value()) TTCN_error("The first argument of function replace() is a template with non-specific value.");
return valueof().replace(index, len, repl);
}

void AuthorisedPLMN__List_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = list_length;
value_list.list_value = new AuthorisedPLMN__List_template[list_length];
break;
default:
TTCN_error("Internal error: Setting an invalid type for a template of type @BSSAP_Types.AuthorisedPLMN_List.");
}
set_selection(template_type);
}

AuthorisedPLMN__List_template& AuthorisedPLMN__List_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of type @BSSAP_Types.AuthorisedPLMN_List.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of type @BSSAP_Types.AuthorisedPLMN_List.");
return value_list.list_value[list_index];
}

void AuthorisedPLMN__List_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.n_elements > 0) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
if (permutation_starts_at(elem_count)) TTCN_Logger::log_event_str("permutation(");
single_value.value_elements[elem_count]->log();
if (permutation_ends_at(elem_count)) TTCN_Logger::log_char(')');
}
TTCN_Logger::log_event_str(" }");
} else TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_restricted();
log_ifpresent();
}

void AuthorisedPLMN__List_template::log_match(const AuthorisedPLMN__List& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
}else{
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if(!single_value.value_elements[elem_count]->match(match_value[elem_count], legacy)){
TTCN_Logger::log_logmatch_info("[%d]", elem_count);
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
log_match_length(single_value.n_elements);
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.n_elements > 0 && get_number_of_permutations() == 0 && single_value.n_elements == match_value.size_of()) {
TTCN_Logger::log_event_str("{ ");
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
single_value.value_elements[elem_count]->log_match(match_value[elem_count], legacy);
}
TTCN_Logger::log_event_str(" }");
log_match_length(single_value.n_elements);
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void AuthorisedPLMN__List_template::encode_text(Text_Buf& text_buf) const
{
encode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++)
single_value.value_elements[elem_count]->encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.AuthorisedPLMN_List.");
}
}

void AuthorisedPLMN__List_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_permutation(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value.n_elements = text_buf.pull_int().get_val();
if (single_value.n_elements < 0) TTCN_error("Text decoder: Negative size was received for a template of type @BSSAP_Types.AuthorisedPLMN_List.");
single_value.value_elements = (AuthorisedPLMN_template**)allocate_pointers(single_value.n_elements);
for (int elem_count = 0; elem_count < single_value.n_elements; elem_count++) {
single_value.value_elements[elem_count] = new AuthorisedPLMN_template;
single_value.value_elements[elem_count]->decode_text(text_buf);
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new AuthorisedPLMN__List_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of type @BSSAP_Types.AuthorisedPLMN_List.");
}
}

boolean AuthorisedPLMN__List_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean AuthorisedPLMN__List_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void AuthorisedPLMN__List_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
for (int i = 0; i < single_value.n_elements; i++) {
if (single_value.value_elements[i] != NULL) single_value.value_elements[i]->set_implicit_omit();
}
}

void AuthorisedPLMN__List_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE|Module_Param::BC_LIST, "record of template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    AuthorisedPLMN__List_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Indexed_List:
    if (template_selection!=SPECIFIC_VALUE) set_size(0);
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      (*this)[(int)(param.get_elem(p_i)->get_id()->get_index())].set_param(*param.get_elem(p_i));
    }
    break;
  case Module_Param::MP_Value_List: {
    set_size(param.get_size());
    int curr_idx = 0;
    for (size_t p_i=0; p_i<param.get_size(); ++p_i) {
      switch (param.get_elem(p_i)->get_type()) {
      case Module_Param::MP_NotUsed:
        curr_idx++;
        break;
      case Module_Param::MP_Permutation_Template: {
        int perm_start_idx = curr_idx;
        Module_Param* param_i = param.get_elem(p_i);
        for (size_t perm_i=0; perm_i<param_i->get_size(); perm_i++) {
          (*this)[curr_idx].set_param(*(param_i->get_elem(perm_i)));
          curr_idx++;
        }
        int perm_end_idx = curr_idx - 1;
        add_permutation(perm_start_idx, perm_end_idx);
      } break;
      default:
        (*this)[curr_idx].set_param(*param.get_elem(p_i));
        curr_idx++;
      }
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    AuthorisedPLMN__List_template* precondition = new AuthorisedPLMN__List_template;
    precondition->set_param(*param.get_elem(0));
    AuthorisedPLMN__List_template* implied_template = new AuthorisedPLMN__List_template;
    implied_template->set_param(*param.get_elem(1));
    *this = AuthorisedPLMN__List_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record of template", "@BSSAP_Types.AuthorisedPLMN_List");
  }
  is_ifpresent = param.get_ifpresent();
  set_length_range(param);
}

void AuthorisedPLMN__List_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
for (int i=0; i<single_value.n_elements; i++) single_value.value_elements[i]->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.AuthorisedPLMN_List");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.AuthorisedPLMN_List");
}

boolean AuthorisedPLMN__List_template::get_istemplate_kind(const char* type) const {
if (!strcmp(type, "AnyElement")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_VALUE) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "AnyElementsOrNone")) {
  if (template_selection != SPECIFIC_VALUE) {
    return FALSE;
  }
  for (int i = 0; i < single_value.n_elements; i++) {
    if (single_value.value_elements[i]->get_selection() == ANY_OR_OMIT) {
      return TRUE;
    }
  }
  return FALSE;
} else if (!strcmp(type, "permutation")) {
  return number_of_permutations;
} else if (!strcmp(type, "length")) {
  return length_restriction_type != NO_LENGTH_RESTRICTION;
} else {
  return Base_Template::get_istemplate_kind(type);
}
}
AuthorisedPLMN::AuthorisedPLMN()
{
}

AuthorisedPLMN::AuthorisedPLMN(const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_mcc__mnc,
    const OPTIONAL< RecordOfOCT2 >& par_authorisedSNA)
  :   field_lengthIndicator(par_lengthIndicator),
  field_mcc__mnc(par_mcc__mnc),
  field_authorisedSNA(par_authorisedSNA)
{
}

AuthorisedPLMN::AuthorisedPLMN(const AuthorisedPLMN& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.AuthorisedPLMN.");
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.mcc__mnc().is_bound()) field_mcc__mnc = other_value.mcc__mnc();
else field_mcc__mnc.clean_up();
if (other_value.authorisedSNA().is_bound()) field_authorisedSNA = other_value.authorisedSNA();
else field_authorisedSNA.clean_up();
}

void AuthorisedPLMN::clean_up()
{
field_lengthIndicator.clean_up();
field_mcc__mnc.clean_up();
field_authorisedSNA.clean_up();
}

const TTCN_Typedescriptor_t* AuthorisedPLMN::get_descriptor() const { return &AuthorisedPLMN_descr_; }
AuthorisedPLMN& AuthorisedPLMN::operator=(const AuthorisedPLMN& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.AuthorisedPLMN.");
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.mcc__mnc().is_bound()) field_mcc__mnc = other_value.mcc__mnc();
  else field_mcc__mnc.clean_up();
  if (other_value.authorisedSNA().is_bound()) field_authorisedSNA = other_value.authorisedSNA();
  else field_authorisedSNA.clean_up();
}
return *this;
}

boolean AuthorisedPLMN::operator==(const AuthorisedPLMN& other_value) const
{
return field_lengthIndicator==other_value.field_lengthIndicator
  && field_mcc__mnc==other_value.field_mcc__mnc
  && field_authorisedSNA==other_value.field_authorisedSNA;
}

boolean AuthorisedPLMN::is_bound() const
{
return (field_lengthIndicator.is_bound())
  || (field_mcc__mnc.is_bound())
  || (OPTIONAL_OMIT == field_authorisedSNA.get_selection() || field_authorisedSNA.is_bound());
}
boolean AuthorisedPLMN::is_value() const
{
return field_lengthIndicator.is_value()
  && field_mcc__mnc.is_value()
  && (OPTIONAL_OMIT == field_authorisedSNA.get_selection() || field_authorisedSNA.is_value());
}
int AuthorisedPLMN::size_of() const
{
  int ret_val = 2;
  if (field_authorisedSNA.ispresent()) ret_val++;
  return ret_val;
}

void AuthorisedPLMN::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", mcc_mnc := ");
field_mcc__mnc.log();
TTCN_Logger::log_event_str(", authorisedSNA := ");
field_authorisedSNA.log();
TTCN_Logger::log_event_str(" }");
}

void AuthorisedPLMN::set_implicit_omit()
{
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (mcc__mnc().is_bound()) mcc__mnc().set_implicit_omit();
if (!authorisedSNA().is_bound()) authorisedSNA() = OMIT_VALUE;
else authorisedSNA().set_implicit_omit();
}

void AuthorisedPLMN::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.AuthorisedPLMN has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) mcc__mnc().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) authorisedSNA().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mcc_mnc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mcc__mnc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "authorisedSNA")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          authorisedSNA().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.AuthorisedPLMN: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.AuthorisedPLMN");
  }
}

void AuthorisedPLMN::encode_text(Text_Buf& text_buf) const
{
field_lengthIndicator.encode_text(text_buf);
field_mcc__mnc.encode_text(text_buf);
field_authorisedSNA.encode_text(text_buf);
}

void AuthorisedPLMN::decode_text(Text_Buf& text_buf)
{
field_lengthIndicator.decode_text(text_buf);
field_mcc__mnc.decode_text(text_buf);
field_authorisedSNA.decode_text(text_buf);
}

void AuthorisedPLMN::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void AuthorisedPLMN::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int AuthorisedPLMN::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, AuthorisedPLMN_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(AuthorisedPLMN_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_lengthIndicator.convert_to_Integer(AuthorisedPLMN_lengthIndicator_descr_);
  field_lengthIndicator = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::OCT3_descr_.raw->forceomit);
  decoded_field_length = field_mcc__mnc.RAW_decode(General__Types::OCT3_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  if (limit > 0 && value_of_length_field0 > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_authorisedSNA = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, RecordOfOCT2_descr_.raw->forceomit);
  decoded_field_length = field_authorisedSNA().RAW_decode(RecordOfOCT2_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_authorisedSNA = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  }
  }
  }
  else field_authorisedSNA=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int AuthorisedPLMN::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, AuthorisedPLMN_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::OCT3_descr_.raw);
  if (field_authorisedSNA.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RecordOfOCT2_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &AuthorisedPLMN_lengthIndicator_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 2;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(2);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  if (field_authorisedSNA.ispresent()) {
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  } else {
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].level = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].pos = 0;
  }
  encoded_length += field_mcc__mnc.RAW_encode(General__Types::OCT3_descr_, *myleaf.body.node.nodes[1]);
  if (field_authorisedSNA.ispresent()) {
  encoded_length += field_authorisedSNA().RAW_encode(RecordOfOCT2_descr_, *myleaf.body.node.nodes[2]);
  }
  return myleaf.length = encoded_length;
}

struct AuthorisedPLMN_template::single_value_struct {
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_mcc__mnc;
RecordOfOCT2_template field_authorisedSNA;
};

void AuthorisedPLMN_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_mcc__mnc = ANY_VALUE;
single_value->field_authorisedSNA = ANY_OR_OMIT;
}
}
}

void AuthorisedPLMN_template::copy_value(const AuthorisedPLMN& other_value)
{
single_value = new single_value_struct;
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.mcc__mnc().is_bound()) {
  single_value->field_mcc__mnc = other_value.mcc__mnc();
} else {
  single_value->field_mcc__mnc.clean_up();
}
if (other_value.authorisedSNA().is_bound()) {
  if (other_value.authorisedSNA().ispresent()) single_value->field_authorisedSNA = other_value.authorisedSNA()();
  else single_value->field_authorisedSNA = OMIT_VALUE;
} else {
  single_value->field_authorisedSNA.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void AuthorisedPLMN_template::copy_template(const AuthorisedPLMN_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mcc__mnc().get_selection()) {
single_value->field_mcc__mnc = other_value.mcc__mnc();
} else {
single_value->field_mcc__mnc.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.authorisedSNA().get_selection()) {
single_value->field_authorisedSNA = other_value.authorisedSNA();
} else {
single_value->field_authorisedSNA.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new AuthorisedPLMN_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new AuthorisedPLMN_template(*other_value.implication_.precondition);
implication_.implied_template = new AuthorisedPLMN_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.AuthorisedPLMN.");
break;
}
set_selection(other_value);
}

AuthorisedPLMN_template::AuthorisedPLMN_template()
{
}

AuthorisedPLMN_template::AuthorisedPLMN_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

AuthorisedPLMN_template::AuthorisedPLMN_template(const AuthorisedPLMN& other_value)
{
copy_value(other_value);
}

AuthorisedPLMN_template::AuthorisedPLMN_template(const OPTIONAL<AuthorisedPLMN>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const AuthorisedPLMN&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.AuthorisedPLMN from an unbound optional field.");
}
}

AuthorisedPLMN_template::AuthorisedPLMN_template(AuthorisedPLMN_template* p_precondition, AuthorisedPLMN_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

AuthorisedPLMN_template::AuthorisedPLMN_template(Dynamic_Match_Interface<AuthorisedPLMN>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<AuthorisedPLMN>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

AuthorisedPLMN_template::AuthorisedPLMN_template(const AuthorisedPLMN_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

AuthorisedPLMN_template::~AuthorisedPLMN_template()
{
clean_up();
}

AuthorisedPLMN_template& AuthorisedPLMN_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

AuthorisedPLMN_template& AuthorisedPLMN_template::operator=(const AuthorisedPLMN& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

AuthorisedPLMN_template& AuthorisedPLMN_template::operator=(const OPTIONAL<AuthorisedPLMN>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const AuthorisedPLMN&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.AuthorisedPLMN.");
}
return *this;
}

AuthorisedPLMN_template& AuthorisedPLMN_template::operator=(const AuthorisedPLMN_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean AuthorisedPLMN_template::match(const AuthorisedPLMN& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.mcc__mnc().is_bound()) return FALSE;
if(!single_value->field_mcc__mnc.match(other_value.mcc__mnc(), legacy))return FALSE;
if(!other_value.authorisedSNA().is_bound()) return FALSE;
if((other_value.authorisedSNA().ispresent() ? !single_value->field_authorisedSNA.match((const RecordOfOCT2&)other_value.authorisedSNA(), legacy) : !single_value->field_authorisedSNA.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.AuthorisedPLMN.");
}
return FALSE;
}

boolean AuthorisedPLMN_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_lengthIndicator.is_bound()
 || single_value->field_mcc__mnc.is_bound()
 || (single_value->field_authorisedSNA.is_omit() || single_value->field_authorisedSNA.is_bound());
}

boolean AuthorisedPLMN_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_lengthIndicator.is_value()
 && single_value->field_mcc__mnc.is_value()
 && (single_value->field_authorisedSNA.is_omit() || single_value->field_authorisedSNA.is_value());
}

void AuthorisedPLMN_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

AuthorisedPLMN AuthorisedPLMN_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.AuthorisedPLMN.");
AuthorisedPLMN ret_val;
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_mcc__mnc.is_bound()) {
ret_val.mcc__mnc() = single_value->field_mcc__mnc.valueof();
}
if (single_value->field_authorisedSNA.is_omit()) ret_val.authorisedSNA() = OMIT_VALUE;
else if (single_value->field_authorisedSNA.is_bound()) {
ret_val.authorisedSNA() = single_value->field_authorisedSNA.valueof();
}
return ret_val;
}

void AuthorisedPLMN_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.AuthorisedPLMN.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new AuthorisedPLMN_template[list_length];
}

AuthorisedPLMN_template& AuthorisedPLMN_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.AuthorisedPLMN.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.AuthorisedPLMN.");
return value_list.list_value[list_index];
}

INTEGER_template& AuthorisedPLMN_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& AuthorisedPLMN_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.AuthorisedPLMN.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& AuthorisedPLMN_template::mcc__mnc()
{
set_specific();
return single_value->field_mcc__mnc;
}

const OCTETSTRING_template& AuthorisedPLMN_template::mcc__mnc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mcc_mnc of a non-specific template of type @BSSAP_Types.AuthorisedPLMN.");
return single_value->field_mcc__mnc;
}

RecordOfOCT2_template& AuthorisedPLMN_template::authorisedSNA()
{
set_specific();
return single_value->field_authorisedSNA;
}

const RecordOfOCT2_template& AuthorisedPLMN_template::authorisedSNA() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field authorisedSNA of a non-specific template of type @BSSAP_Types.AuthorisedPLMN.");
return single_value->field_authorisedSNA;
}

int AuthorisedPLMN_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.AuthorisedPLMN which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_authorisedSNA.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.AuthorisedPLMN containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.AuthorisedPLMN containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.AuthorisedPLMN containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.AuthorisedPLMN containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.AuthorisedPLMN containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.AuthorisedPLMN containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.AuthorisedPLMN containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.AuthorisedPLMN containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.AuthorisedPLMN.");
  }
  return 0;
}

void AuthorisedPLMN_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", mcc_mnc := ");
single_value->field_mcc__mnc.log();
TTCN_Logger::log_event_str(", authorisedSNA := ");
single_value->field_authorisedSNA.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void AuthorisedPLMN_template::log_match(const AuthorisedPLMN& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_mcc__mnc.match(match_value.mcc__mnc(), legacy)){
TTCN_Logger::log_logmatch_info(".mcc_mnc");
single_value->field_mcc__mnc.log_match(match_value.mcc__mnc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.authorisedSNA().ispresent()){
if(!single_value->field_authorisedSNA.match(match_value.authorisedSNA(), legacy)){
TTCN_Logger::log_logmatch_info(".authorisedSNA");
single_value->field_authorisedSNA.log_match(match_value.authorisedSNA(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_authorisedSNA.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".authorisedSNA := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_authorisedSNA.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", mcc_mnc := ");
single_value->field_mcc__mnc.log_match(match_value.mcc__mnc(), legacy);
TTCN_Logger::log_event_str(", authorisedSNA := ");
if (match_value.authorisedSNA().ispresent()) {
single_value->field_authorisedSNA.log_match(match_value.authorisedSNA(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_authorisedSNA.log();
if (single_value->field_authorisedSNA.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void AuthorisedPLMN_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (mcc__mnc().is_bound()) mcc__mnc().set_implicit_omit();
if (!authorisedSNA().is_bound()) authorisedSNA() = OMIT_VALUE;
else authorisedSNA().set_implicit_omit();
}

void AuthorisedPLMN_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_mcc__mnc.encode_text(text_buf);
single_value->field_authorisedSNA.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.AuthorisedPLMN.");
}
}

void AuthorisedPLMN_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_mcc__mnc.decode_text(text_buf);
single_value->field_authorisedSNA.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new AuthorisedPLMN_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.AuthorisedPLMN.");
}
}

void AuthorisedPLMN_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    AuthorisedPLMN_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.AuthorisedPLMN has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) mcc__mnc().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) authorisedSNA().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mcc_mnc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mcc__mnc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "authorisedSNA")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          authorisedSNA().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.AuthorisedPLMN: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    AuthorisedPLMN_template* precondition = new AuthorisedPLMN_template;
    precondition->set_param(*param.get_elem(0));
    AuthorisedPLMN_template* implied_template = new AuthorisedPLMN_template;
    implied_template->set_param(*param.get_elem(1));
    *this = AuthorisedPLMN_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.AuthorisedPLMN");
  }
  is_ifpresent = param.get_ifpresent();
}

void AuthorisedPLMN_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.AuthorisedPLMN");
single_value->field_mcc__mnc.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.AuthorisedPLMN");
single_value->field_authorisedSNA.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.AuthorisedPLMN");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.AuthorisedPLMN");
}

boolean AuthorisedPLMN_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean AuthorisedPLMN_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__SNAAccessInfo::BSSMAP__IE__SNAAccessInfo()
{
}

BSSMAP__IE__SNAAccessInfo::BSSMAP__IE__SNAAccessInfo(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const AuthorisedPLMN__List& par_sNAAccessInfo)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_sNAAccessInfo(par_sNAAccessInfo)
{
}

BSSMAP__IE__SNAAccessInfo::BSSMAP__IE__SNAAccessInfo(const BSSMAP__IE__SNAAccessInfo& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.sNAAccessInfo().is_bound()) field_sNAAccessInfo = other_value.sNAAccessInfo();
else field_sNAAccessInfo.clean_up();
}

void BSSMAP__IE__SNAAccessInfo::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_sNAAccessInfo.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__SNAAccessInfo::get_descriptor() const { return &BSSMAP__IE__SNAAccessInfo_descr_; }
BSSMAP__IE__SNAAccessInfo& BSSMAP__IE__SNAAccessInfo::operator=(const BSSMAP__IE__SNAAccessInfo& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.sNAAccessInfo().is_bound()) field_sNAAccessInfo = other_value.sNAAccessInfo();
  else field_sNAAccessInfo.clean_up();
}
return *this;
}

boolean BSSMAP__IE__SNAAccessInfo::operator==(const BSSMAP__IE__SNAAccessInfo& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_sNAAccessInfo==other_value.field_sNAAccessInfo;
}

boolean BSSMAP__IE__SNAAccessInfo::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_sNAAccessInfo.is_bound());
}
boolean BSSMAP__IE__SNAAccessInfo::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_sNAAccessInfo.is_value();
}
void BSSMAP__IE__SNAAccessInfo::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", sNAAccessInfo := ");
field_sNAAccessInfo.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__SNAAccessInfo::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (sNAAccessInfo().is_bound()) sNAAccessInfo().set_implicit_omit();
}

void BSSMAP__IE__SNAAccessInfo::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) sNAAccessInfo().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sNAAccessInfo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sNAAccessInfo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_SNAAccessInfo");
  }
}

void BSSMAP__IE__SNAAccessInfo::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_sNAAccessInfo.encode_text(text_buf);
}

void BSSMAP__IE__SNAAccessInfo::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_sNAAccessInfo.decode_text(text_buf);
}

void BSSMAP__IE__SNAAccessInfo::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__SNAAccessInfo::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__SNAAccessInfo::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__SNAAccessInfo_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__SNAAccessInfo_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__SNAAccessInfo_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, AuthorisedPLMN__List_descr_.raw->forceomit);
  decoded_field_length = field_sNAAccessInfo.RAW_decode(AuthorisedPLMN__List_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_61) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__SNAAccessInfo::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__SNAAccessInfo_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, AuthorisedPLMN__List_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__SNAAccessInfo_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_sNAAccessInfo.RAW_encode(AuthorisedPLMN__List_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier !=  os_61) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_61.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__SNAAccessInfo_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
AuthorisedPLMN__List_template field_sNAAccessInfo;
};

void BSSMAP__IE__SNAAccessInfo_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_sNAAccessInfo = ANY_VALUE;
}
}
}

void BSSMAP__IE__SNAAccessInfo_template::copy_value(const BSSMAP__IE__SNAAccessInfo& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.sNAAccessInfo().is_bound()) {
  single_value->field_sNAAccessInfo = other_value.sNAAccessInfo();
} else {
  single_value->field_sNAAccessInfo.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__SNAAccessInfo_template::copy_template(const BSSMAP__IE__SNAAccessInfo_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sNAAccessInfo().get_selection()) {
single_value->field_sNAAccessInfo = other_value.sNAAccessInfo();
} else {
single_value->field_sNAAccessInfo.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__SNAAccessInfo_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__SNAAccessInfo_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__SNAAccessInfo_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__SNAAccessInfo_template::BSSMAP__IE__SNAAccessInfo_template()
{
}

BSSMAP__IE__SNAAccessInfo_template::BSSMAP__IE__SNAAccessInfo_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__SNAAccessInfo_template::BSSMAP__IE__SNAAccessInfo_template(const BSSMAP__IE__SNAAccessInfo& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__SNAAccessInfo_template::BSSMAP__IE__SNAAccessInfo_template(const OPTIONAL<BSSMAP__IE__SNAAccessInfo>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__SNAAccessInfo&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo from an unbound optional field.");
}
}

BSSMAP__IE__SNAAccessInfo_template::BSSMAP__IE__SNAAccessInfo_template(BSSMAP__IE__SNAAccessInfo_template* p_precondition, BSSMAP__IE__SNAAccessInfo_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__SNAAccessInfo_template::BSSMAP__IE__SNAAccessInfo_template(Dynamic_Match_Interface<BSSMAP__IE__SNAAccessInfo>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__SNAAccessInfo>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__SNAAccessInfo_template::BSSMAP__IE__SNAAccessInfo_template(const BSSMAP__IE__SNAAccessInfo_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__SNAAccessInfo_template::~BSSMAP__IE__SNAAccessInfo_template()
{
clean_up();
}

BSSMAP__IE__SNAAccessInfo_template& BSSMAP__IE__SNAAccessInfo_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__SNAAccessInfo_template& BSSMAP__IE__SNAAccessInfo_template::operator=(const BSSMAP__IE__SNAAccessInfo& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__SNAAccessInfo_template& BSSMAP__IE__SNAAccessInfo_template::operator=(const OPTIONAL<BSSMAP__IE__SNAAccessInfo>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__SNAAccessInfo&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo.");
}
return *this;
}

BSSMAP__IE__SNAAccessInfo_template& BSSMAP__IE__SNAAccessInfo_template::operator=(const BSSMAP__IE__SNAAccessInfo_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__SNAAccessInfo_template::match(const BSSMAP__IE__SNAAccessInfo& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.sNAAccessInfo().is_bound()) return FALSE;
if(!single_value->field_sNAAccessInfo.match(other_value.sNAAccessInfo(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo.");
}
return FALSE;
}

boolean BSSMAP__IE__SNAAccessInfo_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_sNAAccessInfo.is_bound();
}

boolean BSSMAP__IE__SNAAccessInfo_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_sNAAccessInfo.is_value();
}

void BSSMAP__IE__SNAAccessInfo_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__SNAAccessInfo BSSMAP__IE__SNAAccessInfo_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo.");
BSSMAP__IE__SNAAccessInfo ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_sNAAccessInfo.is_bound()) {
ret_val.sNAAccessInfo() = single_value->field_sNAAccessInfo.valueof();
}
return ret_val;
}

void BSSMAP__IE__SNAAccessInfo_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__SNAAccessInfo_template[list_length];
}

BSSMAP__IE__SNAAccessInfo_template& BSSMAP__IE__SNAAccessInfo_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__SNAAccessInfo_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__SNAAccessInfo_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__SNAAccessInfo_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__SNAAccessInfo_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo.");
return single_value->field_lengthIndicator;
}

AuthorisedPLMN__List_template& BSSMAP__IE__SNAAccessInfo_template::sNAAccessInfo()
{
set_specific();
return single_value->field_sNAAccessInfo;
}

const AuthorisedPLMN__List_template& BSSMAP__IE__SNAAccessInfo_template::sNAAccessInfo() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sNAAccessInfo of a non-specific template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo.");
return single_value->field_sNAAccessInfo;
}

int BSSMAP__IE__SNAAccessInfo_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo.");
  }
  return 0;
}

void BSSMAP__IE__SNAAccessInfo_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", sNAAccessInfo := ");
single_value->field_sNAAccessInfo.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__SNAAccessInfo_template::log_match(const BSSMAP__IE__SNAAccessInfo& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sNAAccessInfo.match(match_value.sNAAccessInfo(), legacy)){
TTCN_Logger::log_logmatch_info(".sNAAccessInfo");
single_value->field_sNAAccessInfo.log_match(match_value.sNAAccessInfo(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", sNAAccessInfo := ");
single_value->field_sNAAccessInfo.log_match(match_value.sNAAccessInfo(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__SNAAccessInfo_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (sNAAccessInfo().is_bound()) sNAAccessInfo().set_implicit_omit();
}

void BSSMAP__IE__SNAAccessInfo_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_sNAAccessInfo.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo.");
}
}

void BSSMAP__IE__SNAAccessInfo_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_sNAAccessInfo.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__SNAAccessInfo_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo.");
}
}

void BSSMAP__IE__SNAAccessInfo_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__SNAAccessInfo_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) sNAAccessInfo().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sNAAccessInfo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sNAAccessInfo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_SNAAccessInfo: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__SNAAccessInfo_template* precondition = new BSSMAP__IE__SNAAccessInfo_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__SNAAccessInfo_template* implied_template = new BSSMAP__IE__SNAAccessInfo_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__SNAAccessInfo_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_SNAAccessInfo");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__SNAAccessInfo_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_SNAAccessInfo");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_SNAAccessInfo");
single_value->field_sNAAccessInfo.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_SNAAccessInfo");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_SNAAccessInfo");
}

boolean BSSMAP__IE__SNAAccessInfo_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__SNAAccessInfo_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__VSTK__RAND::BSSMAP__IE__VSTK__RAND()
{
}

BSSMAP__IE__VSTK__RAND::BSSMAP__IE__VSTK__RAND(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_VSTK__RAND__1,
    const OCTETSTRING& par_VSTK__RAND__2,
    const OCTETSTRING& par_VSTK__RAND__3,
    const OCTETSTRING& par_VSTK__RAND__4,
    const BITSTRING& par_spare,
    const BITSTRING& par_VSTK__RAND__5)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_VSTK__RAND__1(par_VSTK__RAND__1),
  field_VSTK__RAND__2(par_VSTK__RAND__2),
  field_VSTK__RAND__3(par_VSTK__RAND__3),
  field_VSTK__RAND__4(par_VSTK__RAND__4),
  field_spare(par_spare),
  field_VSTK__RAND__5(par_VSTK__RAND__5)
{
}

BSSMAP__IE__VSTK__RAND::BSSMAP__IE__VSTK__RAND(const BSSMAP__IE__VSTK__RAND& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.VSTK__RAND__1().is_bound()) field_VSTK__RAND__1 = other_value.VSTK__RAND__1();
else field_VSTK__RAND__1.clean_up();
if (other_value.VSTK__RAND__2().is_bound()) field_VSTK__RAND__2 = other_value.VSTK__RAND__2();
else field_VSTK__RAND__2.clean_up();
if (other_value.VSTK__RAND__3().is_bound()) field_VSTK__RAND__3 = other_value.VSTK__RAND__3();
else field_VSTK__RAND__3.clean_up();
if (other_value.VSTK__RAND__4().is_bound()) field_VSTK__RAND__4 = other_value.VSTK__RAND__4();
else field_VSTK__RAND__4.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.VSTK__RAND__5().is_bound()) field_VSTK__RAND__5 = other_value.VSTK__RAND__5();
else field_VSTK__RAND__5.clean_up();
}

void BSSMAP__IE__VSTK__RAND::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_VSTK__RAND__1.clean_up();
field_VSTK__RAND__2.clean_up();
field_VSTK__RAND__3.clean_up();
field_VSTK__RAND__4.clean_up();
field_spare.clean_up();
field_VSTK__RAND__5.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__VSTK__RAND::get_descriptor() const { return &BSSMAP__IE__VSTK__RAND_descr_; }
BSSMAP__IE__VSTK__RAND& BSSMAP__IE__VSTK__RAND::operator=(const BSSMAP__IE__VSTK__RAND& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.VSTK__RAND__1().is_bound()) field_VSTK__RAND__1 = other_value.VSTK__RAND__1();
  else field_VSTK__RAND__1.clean_up();
  if (other_value.VSTK__RAND__2().is_bound()) field_VSTK__RAND__2 = other_value.VSTK__RAND__2();
  else field_VSTK__RAND__2.clean_up();
  if (other_value.VSTK__RAND__3().is_bound()) field_VSTK__RAND__3 = other_value.VSTK__RAND__3();
  else field_VSTK__RAND__3.clean_up();
  if (other_value.VSTK__RAND__4().is_bound()) field_VSTK__RAND__4 = other_value.VSTK__RAND__4();
  else field_VSTK__RAND__4.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.VSTK__RAND__5().is_bound()) field_VSTK__RAND__5 = other_value.VSTK__RAND__5();
  else field_VSTK__RAND__5.clean_up();
}
return *this;
}

boolean BSSMAP__IE__VSTK__RAND::operator==(const BSSMAP__IE__VSTK__RAND& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_VSTK__RAND__1==other_value.field_VSTK__RAND__1
  && field_VSTK__RAND__2==other_value.field_VSTK__RAND__2
  && field_VSTK__RAND__3==other_value.field_VSTK__RAND__3
  && field_VSTK__RAND__4==other_value.field_VSTK__RAND__4
  && field_spare==other_value.field_spare
  && field_VSTK__RAND__5==other_value.field_VSTK__RAND__5;
}

boolean BSSMAP__IE__VSTK__RAND::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_VSTK__RAND__1.is_bound())
  || (field_VSTK__RAND__2.is_bound())
  || (field_VSTK__RAND__3.is_bound())
  || (field_VSTK__RAND__4.is_bound())
  || (field_spare.is_bound())
  || (field_VSTK__RAND__5.is_bound());
}
boolean BSSMAP__IE__VSTK__RAND::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_VSTK__RAND__1.is_value()
  && field_VSTK__RAND__2.is_value()
  && field_VSTK__RAND__3.is_value()
  && field_VSTK__RAND__4.is_value()
  && field_spare.is_value()
  && field_VSTK__RAND__5.is_value();
}
void BSSMAP__IE__VSTK__RAND::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", VSTK_RAND_1 := ");
field_VSTK__RAND__1.log();
TTCN_Logger::log_event_str(", VSTK_RAND_2 := ");
field_VSTK__RAND__2.log();
TTCN_Logger::log_event_str(", VSTK_RAND_3 := ");
field_VSTK__RAND__3.log();
TTCN_Logger::log_event_str(", VSTK_RAND_4 := ");
field_VSTK__RAND__4.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", VSTK_RAND_5 := ");
field_VSTK__RAND__5.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__VSTK__RAND::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (VSTK__RAND__1().is_bound()) VSTK__RAND__1().set_implicit_omit();
if (VSTK__RAND__2().is_bound()) VSTK__RAND__2().set_implicit_omit();
if (VSTK__RAND__3().is_bound()) VSTK__RAND__3().set_implicit_omit();
if (VSTK__RAND__4().is_bound()) VSTK__RAND__4().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (VSTK__RAND__5().is_bound()) VSTK__RAND__5().set_implicit_omit();
}

void BSSMAP__IE__VSTK__RAND::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) VSTK__RAND__1().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) VSTK__RAND__2().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) VSTK__RAND__3().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) VSTK__RAND__4().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) VSTK__RAND__5().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "VSTK_RAND_1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          VSTK__RAND__1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "VSTK_RAND_2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          VSTK__RAND__2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "VSTK_RAND_3")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          VSTK__RAND__3().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "VSTK_RAND_4")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          VSTK__RAND__4().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "VSTK_RAND_5")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          VSTK__RAND__5().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_VSTK_RAND: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_VSTK_RAND");
  }
}

void BSSMAP__IE__VSTK__RAND::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_VSTK__RAND__1.encode_text(text_buf);
field_VSTK__RAND__2.encode_text(text_buf);
field_VSTK__RAND__3.encode_text(text_buf);
field_VSTK__RAND__4.encode_text(text_buf);
field_spare.encode_text(text_buf);
field_VSTK__RAND__5.encode_text(text_buf);
}

void BSSMAP__IE__VSTK__RAND::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_VSTK__RAND__1.decode_text(text_buf);
field_VSTK__RAND__2.decode_text(text_buf);
field_VSTK__RAND__3.decode_text(text_buf);
field_VSTK__RAND__4.decode_text(text_buf);
field_spare.decode_text(text_buf);
field_VSTK__RAND__5.decode_text(text_buf);
}

void BSSMAP__IE__VSTK__RAND::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__VSTK__RAND::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__VSTK__RAND::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__VSTK__RAND_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__VSTK__RAND_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__VSTK__RAND_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_VSTK__RAND__1.RAW_decode(General__Types::OCT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::OCT2_descr_.raw->forceomit);
  decoded_field_length = field_VSTK__RAND__2.RAW_decode(General__Types::OCT2_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::OCT3_descr_.raw->forceomit);
  decoded_field_length = field_VSTK__RAND__3.RAW_decode(General__Types::OCT3_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_5_force_omit(5, force_omit, General__Types::OCT4_descr_.raw->forceomit);
  decoded_field_length = field_VSTK__RAND__4.RAW_decode(General__Types::OCT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_6_force_omit(6, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_7_force_omit(7, force_omit, General__Types::BIT4_descr_.raw->forceomit);
  decoded_field_length = field_VSTK__RAND__5.RAW_decode(General__Types::BIT4_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_116) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__VSTK__RAND::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 8;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(8);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__VSTK__RAND_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::OCT2_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::OCT3_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, General__Types::OCT4_descr_.raw);
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, General__Types::BIT4_descr_.raw);
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, General__Types::BIT4_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__VSTK__RAND_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 6;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(6);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[4].level = myleaf.body.node.nodes[6]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[4].pos = myleaf.body.node.nodes[6]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[5].level = myleaf.body.node.nodes[7]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[5].pos = myleaf.body.node.nodes[7]->curr_pos.pos;
  encoded_length += field_VSTK__RAND__1.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_VSTK__RAND__2.RAW_encode(General__Types::OCT2_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_VSTK__RAND__3.RAW_encode(General__Types::OCT3_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_VSTK__RAND__4.RAW_encode(General__Types::OCT4_descr_, *myleaf.body.node.nodes[5]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[6]);
  encoded_length += field_VSTK__RAND__5.RAW_encode(General__Types::BIT4_descr_, *myleaf.body.node.nodes[7]);
  if (field_elementIdentifier !=  os_116) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_116.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__VSTK__RAND_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_VSTK__RAND__1;
OCTETSTRING_template field_VSTK__RAND__2;
OCTETSTRING_template field_VSTK__RAND__3;
OCTETSTRING_template field_VSTK__RAND__4;
BITSTRING_template field_spare;
BITSTRING_template field_VSTK__RAND__5;
};

void BSSMAP__IE__VSTK__RAND_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_VSTK__RAND__1 = ANY_VALUE;
single_value->field_VSTK__RAND__2 = ANY_VALUE;
single_value->field_VSTK__RAND__3 = ANY_VALUE;
single_value->field_VSTK__RAND__4 = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
single_value->field_VSTK__RAND__5 = ANY_VALUE;
}
}
}

void BSSMAP__IE__VSTK__RAND_template::copy_value(const BSSMAP__IE__VSTK__RAND& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.VSTK__RAND__1().is_bound()) {
  single_value->field_VSTK__RAND__1 = other_value.VSTK__RAND__1();
} else {
  single_value->field_VSTK__RAND__1.clean_up();
}
if (other_value.VSTK__RAND__2().is_bound()) {
  single_value->field_VSTK__RAND__2 = other_value.VSTK__RAND__2();
} else {
  single_value->field_VSTK__RAND__2.clean_up();
}
if (other_value.VSTK__RAND__3().is_bound()) {
  single_value->field_VSTK__RAND__3 = other_value.VSTK__RAND__3();
} else {
  single_value->field_VSTK__RAND__3.clean_up();
}
if (other_value.VSTK__RAND__4().is_bound()) {
  single_value->field_VSTK__RAND__4 = other_value.VSTK__RAND__4();
} else {
  single_value->field_VSTK__RAND__4.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.VSTK__RAND__5().is_bound()) {
  single_value->field_VSTK__RAND__5 = other_value.VSTK__RAND__5();
} else {
  single_value->field_VSTK__RAND__5.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__VSTK__RAND_template::copy_template(const BSSMAP__IE__VSTK__RAND_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.VSTK__RAND__1().get_selection()) {
single_value->field_VSTK__RAND__1 = other_value.VSTK__RAND__1();
} else {
single_value->field_VSTK__RAND__1.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.VSTK__RAND__2().get_selection()) {
single_value->field_VSTK__RAND__2 = other_value.VSTK__RAND__2();
} else {
single_value->field_VSTK__RAND__2.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.VSTK__RAND__3().get_selection()) {
single_value->field_VSTK__RAND__3 = other_value.VSTK__RAND__3();
} else {
single_value->field_VSTK__RAND__3.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.VSTK__RAND__4().get_selection()) {
single_value->field_VSTK__RAND__4 = other_value.VSTK__RAND__4();
} else {
single_value->field_VSTK__RAND__4.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.VSTK__RAND__5().get_selection()) {
single_value->field_VSTK__RAND__5 = other_value.VSTK__RAND__5();
} else {
single_value->field_VSTK__RAND__5.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__VSTK__RAND_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__VSTK__RAND_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__VSTK__RAND_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__VSTK__RAND_template::BSSMAP__IE__VSTK__RAND_template()
{
}

BSSMAP__IE__VSTK__RAND_template::BSSMAP__IE__VSTK__RAND_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__VSTK__RAND_template::BSSMAP__IE__VSTK__RAND_template(const BSSMAP__IE__VSTK__RAND& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__VSTK__RAND_template::BSSMAP__IE__VSTK__RAND_template(const OPTIONAL<BSSMAP__IE__VSTK__RAND>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__VSTK__RAND&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND from an unbound optional field.");
}
}

BSSMAP__IE__VSTK__RAND_template::BSSMAP__IE__VSTK__RAND_template(BSSMAP__IE__VSTK__RAND_template* p_precondition, BSSMAP__IE__VSTK__RAND_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__VSTK__RAND_template::BSSMAP__IE__VSTK__RAND_template(Dynamic_Match_Interface<BSSMAP__IE__VSTK__RAND>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__VSTK__RAND>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__VSTK__RAND_template::BSSMAP__IE__VSTK__RAND_template(const BSSMAP__IE__VSTK__RAND_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__VSTK__RAND_template::~BSSMAP__IE__VSTK__RAND_template()
{
clean_up();
}

BSSMAP__IE__VSTK__RAND_template& BSSMAP__IE__VSTK__RAND_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__VSTK__RAND_template& BSSMAP__IE__VSTK__RAND_template::operator=(const BSSMAP__IE__VSTK__RAND& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__VSTK__RAND_template& BSSMAP__IE__VSTK__RAND_template::operator=(const OPTIONAL<BSSMAP__IE__VSTK__RAND>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__VSTK__RAND&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND.");
}
return *this;
}

BSSMAP__IE__VSTK__RAND_template& BSSMAP__IE__VSTK__RAND_template::operator=(const BSSMAP__IE__VSTK__RAND_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__VSTK__RAND_template::match(const BSSMAP__IE__VSTK__RAND& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.VSTK__RAND__1().is_bound()) return FALSE;
if(!single_value->field_VSTK__RAND__1.match(other_value.VSTK__RAND__1(), legacy))return FALSE;
if(!other_value.VSTK__RAND__2().is_bound()) return FALSE;
if(!single_value->field_VSTK__RAND__2.match(other_value.VSTK__RAND__2(), legacy))return FALSE;
if(!other_value.VSTK__RAND__3().is_bound()) return FALSE;
if(!single_value->field_VSTK__RAND__3.match(other_value.VSTK__RAND__3(), legacy))return FALSE;
if(!other_value.VSTK__RAND__4().is_bound()) return FALSE;
if(!single_value->field_VSTK__RAND__4.match(other_value.VSTK__RAND__4(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.VSTK__RAND__5().is_bound()) return FALSE;
if(!single_value->field_VSTK__RAND__5.match(other_value.VSTK__RAND__5(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND.");
}
return FALSE;
}

boolean BSSMAP__IE__VSTK__RAND_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_VSTK__RAND__1.is_bound()
 || single_value->field_VSTK__RAND__2.is_bound()
 || single_value->field_VSTK__RAND__3.is_bound()
 || single_value->field_VSTK__RAND__4.is_bound()
 || single_value->field_spare.is_bound()
 || single_value->field_VSTK__RAND__5.is_bound();
}

boolean BSSMAP__IE__VSTK__RAND_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_VSTK__RAND__1.is_value()
 && single_value->field_VSTK__RAND__2.is_value()
 && single_value->field_VSTK__RAND__3.is_value()
 && single_value->field_VSTK__RAND__4.is_value()
 && single_value->field_spare.is_value()
 && single_value->field_VSTK__RAND__5.is_value();
}

void BSSMAP__IE__VSTK__RAND_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__VSTK__RAND BSSMAP__IE__VSTK__RAND_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND.");
BSSMAP__IE__VSTK__RAND ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_VSTK__RAND__1.is_bound()) {
ret_val.VSTK__RAND__1() = single_value->field_VSTK__RAND__1.valueof();
}
if (single_value->field_VSTK__RAND__2.is_bound()) {
ret_val.VSTK__RAND__2() = single_value->field_VSTK__RAND__2.valueof();
}
if (single_value->field_VSTK__RAND__3.is_bound()) {
ret_val.VSTK__RAND__3() = single_value->field_VSTK__RAND__3.valueof();
}
if (single_value->field_VSTK__RAND__4.is_bound()) {
ret_val.VSTK__RAND__4() = single_value->field_VSTK__RAND__4.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_VSTK__RAND__5.is_bound()) {
ret_val.VSTK__RAND__5() = single_value->field_VSTK__RAND__5.valueof();
}
return ret_val;
}

void BSSMAP__IE__VSTK__RAND_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__VSTK__RAND_template[list_length];
}

BSSMAP__IE__VSTK__RAND_template& BSSMAP__IE__VSTK__RAND_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__VSTK__RAND_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__VSTK__RAND_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__VSTK__RAND_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__VSTK__RAND_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& BSSMAP__IE__VSTK__RAND_template::VSTK__RAND__1()
{
set_specific();
return single_value->field_VSTK__RAND__1;
}

const OCTETSTRING_template& BSSMAP__IE__VSTK__RAND_template::VSTK__RAND__1() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field VSTK_RAND_1 of a non-specific template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND.");
return single_value->field_VSTK__RAND__1;
}

OCTETSTRING_template& BSSMAP__IE__VSTK__RAND_template::VSTK__RAND__2()
{
set_specific();
return single_value->field_VSTK__RAND__2;
}

const OCTETSTRING_template& BSSMAP__IE__VSTK__RAND_template::VSTK__RAND__2() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field VSTK_RAND_2 of a non-specific template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND.");
return single_value->field_VSTK__RAND__2;
}

OCTETSTRING_template& BSSMAP__IE__VSTK__RAND_template::VSTK__RAND__3()
{
set_specific();
return single_value->field_VSTK__RAND__3;
}

const OCTETSTRING_template& BSSMAP__IE__VSTK__RAND_template::VSTK__RAND__3() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field VSTK_RAND_3 of a non-specific template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND.");
return single_value->field_VSTK__RAND__3;
}

OCTETSTRING_template& BSSMAP__IE__VSTK__RAND_template::VSTK__RAND__4()
{
set_specific();
return single_value->field_VSTK__RAND__4;
}

const OCTETSTRING_template& BSSMAP__IE__VSTK__RAND_template::VSTK__RAND__4() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field VSTK_RAND_4 of a non-specific template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND.");
return single_value->field_VSTK__RAND__4;
}

BITSTRING_template& BSSMAP__IE__VSTK__RAND_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& BSSMAP__IE__VSTK__RAND_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND.");
return single_value->field_spare;
}

BITSTRING_template& BSSMAP__IE__VSTK__RAND_template::VSTK__RAND__5()
{
set_specific();
return single_value->field_VSTK__RAND__5;
}

const BITSTRING_template& BSSMAP__IE__VSTK__RAND_template::VSTK__RAND__5() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field VSTK_RAND_5 of a non-specific template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND.");
return single_value->field_VSTK__RAND__5;
}

int BSSMAP__IE__VSTK__RAND_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 8;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND.");
  }
  return 0;
}

void BSSMAP__IE__VSTK__RAND_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", VSTK_RAND_1 := ");
single_value->field_VSTK__RAND__1.log();
TTCN_Logger::log_event_str(", VSTK_RAND_2 := ");
single_value->field_VSTK__RAND__2.log();
TTCN_Logger::log_event_str(", VSTK_RAND_3 := ");
single_value->field_VSTK__RAND__3.log();
TTCN_Logger::log_event_str(", VSTK_RAND_4 := ");
single_value->field_VSTK__RAND__4.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", VSTK_RAND_5 := ");
single_value->field_VSTK__RAND__5.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__VSTK__RAND_template::log_match(const BSSMAP__IE__VSTK__RAND& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_VSTK__RAND__1.match(match_value.VSTK__RAND__1(), legacy)){
TTCN_Logger::log_logmatch_info(".VSTK_RAND_1");
single_value->field_VSTK__RAND__1.log_match(match_value.VSTK__RAND__1(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_VSTK__RAND__2.match(match_value.VSTK__RAND__2(), legacy)){
TTCN_Logger::log_logmatch_info(".VSTK_RAND_2");
single_value->field_VSTK__RAND__2.log_match(match_value.VSTK__RAND__2(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_VSTK__RAND__3.match(match_value.VSTK__RAND__3(), legacy)){
TTCN_Logger::log_logmatch_info(".VSTK_RAND_3");
single_value->field_VSTK__RAND__3.log_match(match_value.VSTK__RAND__3(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_VSTK__RAND__4.match(match_value.VSTK__RAND__4(), legacy)){
TTCN_Logger::log_logmatch_info(".VSTK_RAND_4");
single_value->field_VSTK__RAND__4.log_match(match_value.VSTK__RAND__4(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_VSTK__RAND__5.match(match_value.VSTK__RAND__5(), legacy)){
TTCN_Logger::log_logmatch_info(".VSTK_RAND_5");
single_value->field_VSTK__RAND__5.log_match(match_value.VSTK__RAND__5(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", VSTK_RAND_1 := ");
single_value->field_VSTK__RAND__1.log_match(match_value.VSTK__RAND__1(), legacy);
TTCN_Logger::log_event_str(", VSTK_RAND_2 := ");
single_value->field_VSTK__RAND__2.log_match(match_value.VSTK__RAND__2(), legacy);
TTCN_Logger::log_event_str(", VSTK_RAND_3 := ");
single_value->field_VSTK__RAND__3.log_match(match_value.VSTK__RAND__3(), legacy);
TTCN_Logger::log_event_str(", VSTK_RAND_4 := ");
single_value->field_VSTK__RAND__4.log_match(match_value.VSTK__RAND__4(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", VSTK_RAND_5 := ");
single_value->field_VSTK__RAND__5.log_match(match_value.VSTK__RAND__5(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__VSTK__RAND_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (VSTK__RAND__1().is_bound()) VSTK__RAND__1().set_implicit_omit();
if (VSTK__RAND__2().is_bound()) VSTK__RAND__2().set_implicit_omit();
if (VSTK__RAND__3().is_bound()) VSTK__RAND__3().set_implicit_omit();
if (VSTK__RAND__4().is_bound()) VSTK__RAND__4().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (VSTK__RAND__5().is_bound()) VSTK__RAND__5().set_implicit_omit();
}

void BSSMAP__IE__VSTK__RAND_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_VSTK__RAND__1.encode_text(text_buf);
single_value->field_VSTK__RAND__2.encode_text(text_buf);
single_value->field_VSTK__RAND__3.encode_text(text_buf);
single_value->field_VSTK__RAND__4.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
single_value->field_VSTK__RAND__5.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND.");
}
}

void BSSMAP__IE__VSTK__RAND_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_VSTK__RAND__1.decode_text(text_buf);
single_value->field_VSTK__RAND__2.decode_text(text_buf);
single_value->field_VSTK__RAND__3.decode_text(text_buf);
single_value->field_VSTK__RAND__4.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
single_value->field_VSTK__RAND__5.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__VSTK__RAND_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND.");
}
}

void BSSMAP__IE__VSTK__RAND_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__VSTK__RAND_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_VSTK_RAND has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) VSTK__RAND__1().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) VSTK__RAND__2().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) VSTK__RAND__3().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) VSTK__RAND__4().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) VSTK__RAND__5().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "VSTK_RAND_1")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          VSTK__RAND__1().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "VSTK_RAND_2")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          VSTK__RAND__2().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "VSTK_RAND_3")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          VSTK__RAND__3().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "VSTK_RAND_4")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          VSTK__RAND__4().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "VSTK_RAND_5")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          VSTK__RAND__5().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_VSTK_RAND: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__VSTK__RAND_template* precondition = new BSSMAP__IE__VSTK__RAND_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__VSTK__RAND_template* implied_template = new BSSMAP__IE__VSTK__RAND_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__VSTK__RAND_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_VSTK_RAND");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__VSTK__RAND_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_VSTK_RAND");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_VSTK_RAND");
single_value->field_VSTK__RAND__1.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_VSTK_RAND");
single_value->field_VSTK__RAND__2.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_VSTK_RAND");
single_value->field_VSTK__RAND__3.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_VSTK_RAND");
single_value->field_VSTK__RAND__4.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_VSTK_RAND");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_VSTK_RAND");
single_value->field_VSTK__RAND__5.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_VSTK_RAND");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_VSTK_RAND");
}

boolean BSSMAP__IE__VSTK__RAND_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__VSTK__RAND_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__VSTK::BSSMAP__IE__VSTK()
{
}

BSSMAP__IE__VSTK::BSSMAP__IE__VSTK(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_VSTK)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_VSTK(par_VSTK)
{
}

BSSMAP__IE__VSTK::BSSMAP__IE__VSTK(const BSSMAP__IE__VSTK& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_VSTK.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.VSTK().is_bound()) field_VSTK = other_value.VSTK();
else field_VSTK.clean_up();
}

void BSSMAP__IE__VSTK::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_VSTK.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__VSTK::get_descriptor() const { return &BSSMAP__IE__VSTK_descr_; }
BSSMAP__IE__VSTK& BSSMAP__IE__VSTK::operator=(const BSSMAP__IE__VSTK& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_VSTK.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.VSTK().is_bound()) field_VSTK = other_value.VSTK();
  else field_VSTK.clean_up();
}
return *this;
}

boolean BSSMAP__IE__VSTK::operator==(const BSSMAP__IE__VSTK& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_VSTK==other_value.field_VSTK;
}

boolean BSSMAP__IE__VSTK::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_VSTK.is_bound());
}
boolean BSSMAP__IE__VSTK::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_VSTK.is_value();
}
void BSSMAP__IE__VSTK::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", VSTK := ");
field_VSTK.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__VSTK::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (VSTK().is_bound()) VSTK().set_implicit_omit();
}

void BSSMAP__IE__VSTK::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_VSTK has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) VSTK().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "VSTK")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          VSTK().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_VSTK: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_VSTK");
  }
}

void BSSMAP__IE__VSTK::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_VSTK.encode_text(text_buf);
}

void BSSMAP__IE__VSTK::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_VSTK.decode_text(text_buf);
}

void BSSMAP__IE__VSTK::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__VSTK::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__VSTK::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__VSTK_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__VSTK_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__VSTK_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCT16_descr_.raw->forceomit);
  decoded_field_length = field_VSTK.RAW_decode(General__Types::OCT16_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_117) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__VSTK::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__VSTK_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCT16_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__VSTK_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_VSTK.RAW_encode(General__Types::OCT16_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier !=  os_117) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_117.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__VSTK_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_VSTK;
};

void BSSMAP__IE__VSTK_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_VSTK = ANY_VALUE;
}
}
}

void BSSMAP__IE__VSTK_template::copy_value(const BSSMAP__IE__VSTK& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.VSTK().is_bound()) {
  single_value->field_VSTK = other_value.VSTK();
} else {
  single_value->field_VSTK.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__VSTK_template::copy_template(const BSSMAP__IE__VSTK_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.VSTK().get_selection()) {
single_value->field_VSTK = other_value.VSTK();
} else {
single_value->field_VSTK.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__VSTK_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__VSTK_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__VSTK_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_VSTK.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__VSTK_template::BSSMAP__IE__VSTK_template()
{
}

BSSMAP__IE__VSTK_template::BSSMAP__IE__VSTK_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__VSTK_template::BSSMAP__IE__VSTK_template(const BSSMAP__IE__VSTK& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__VSTK_template::BSSMAP__IE__VSTK_template(const OPTIONAL<BSSMAP__IE__VSTK>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__VSTK&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_VSTK from an unbound optional field.");
}
}

BSSMAP__IE__VSTK_template::BSSMAP__IE__VSTK_template(BSSMAP__IE__VSTK_template* p_precondition, BSSMAP__IE__VSTK_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__VSTK_template::BSSMAP__IE__VSTK_template(Dynamic_Match_Interface<BSSMAP__IE__VSTK>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__VSTK>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__VSTK_template::BSSMAP__IE__VSTK_template(const BSSMAP__IE__VSTK_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__VSTK_template::~BSSMAP__IE__VSTK_template()
{
clean_up();
}

BSSMAP__IE__VSTK_template& BSSMAP__IE__VSTK_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__VSTK_template& BSSMAP__IE__VSTK_template::operator=(const BSSMAP__IE__VSTK& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__VSTK_template& BSSMAP__IE__VSTK_template::operator=(const OPTIONAL<BSSMAP__IE__VSTK>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__VSTK&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_VSTK.");
}
return *this;
}

BSSMAP__IE__VSTK_template& BSSMAP__IE__VSTK_template::operator=(const BSSMAP__IE__VSTK_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__VSTK_template::match(const BSSMAP__IE__VSTK& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.VSTK().is_bound()) return FALSE;
if(!single_value->field_VSTK.match(other_value.VSTK(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_VSTK.");
}
return FALSE;
}

boolean BSSMAP__IE__VSTK_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_VSTK.is_bound();
}

boolean BSSMAP__IE__VSTK_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_VSTK.is_value();
}

void BSSMAP__IE__VSTK_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__VSTK BSSMAP__IE__VSTK_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_VSTK.");
BSSMAP__IE__VSTK ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_VSTK.is_bound()) {
ret_val.VSTK() = single_value->field_VSTK.valueof();
}
return ret_val;
}

void BSSMAP__IE__VSTK_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_VSTK.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__VSTK_template[list_length];
}

BSSMAP__IE__VSTK_template& BSSMAP__IE__VSTK_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_VSTK.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_VSTK.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__VSTK_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__VSTK_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_VSTK.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__VSTK_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__VSTK_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_VSTK.");
return single_value->field_lengthIndicator;
}

OCTETSTRING_template& BSSMAP__IE__VSTK_template::VSTK()
{
set_specific();
return single_value->field_VSTK;
}

const OCTETSTRING_template& BSSMAP__IE__VSTK_template::VSTK() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field VSTK of a non-specific template of type @BSSAP_Types.BSSMAP_IE_VSTK.");
return single_value->field_VSTK;
}

int BSSMAP__IE__VSTK_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_VSTK which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_VSTK containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_VSTK containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_VSTK containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_VSTK containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_VSTK containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_VSTK containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_VSTK containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_VSTK containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_VSTK.");
  }
  return 0;
}

void BSSMAP__IE__VSTK_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", VSTK := ");
single_value->field_VSTK.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__VSTK_template::log_match(const BSSMAP__IE__VSTK& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_VSTK.match(match_value.VSTK(), legacy)){
TTCN_Logger::log_logmatch_info(".VSTK");
single_value->field_VSTK.log_match(match_value.VSTK(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", VSTK := ");
single_value->field_VSTK.log_match(match_value.VSTK(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__VSTK_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (VSTK().is_bound()) VSTK().set_implicit_omit();
}

void BSSMAP__IE__VSTK_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_VSTK.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_VSTK.");
}
}

void BSSMAP__IE__VSTK_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_VSTK.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__VSTK_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_VSTK.");
}
}

void BSSMAP__IE__VSTK_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__VSTK_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_VSTK has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) VSTK().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "VSTK")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          VSTK().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_VSTK: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__VSTK_template* precondition = new BSSMAP__IE__VSTK_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__VSTK_template* implied_template = new BSSMAP__IE__VSTK_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__VSTK_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_VSTK");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__VSTK_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_VSTK");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_VSTK");
single_value->field_VSTK.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_VSTK");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_VSTK");
}

boolean BSSMAP__IE__VSTK_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__VSTK_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__PagingInformation::BSSMAP__IE__PagingInformation()
{
}

BSSMAP__IE__PagingInformation::BSSMAP__IE__PagingInformation(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const BITSTRING& par_VGCS__or__VBS,
    const BITSTRING& par_pagingCause,
    const BITSTRING& par_spare)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_VGCS__or__VBS(par_VGCS__or__VBS),
  field_pagingCause(par_pagingCause),
  field_spare(par_spare)
{
}

BSSMAP__IE__PagingInformation::BSSMAP__IE__PagingInformation(const BSSMAP__IE__PagingInformation& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_PagingInformation.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.VGCS__or__VBS().is_bound()) field_VGCS__or__VBS = other_value.VGCS__or__VBS();
else field_VGCS__or__VBS.clean_up();
if (other_value.pagingCause().is_bound()) field_pagingCause = other_value.pagingCause();
else field_pagingCause.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
}

void BSSMAP__IE__PagingInformation::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_VGCS__or__VBS.clean_up();
field_pagingCause.clean_up();
field_spare.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__PagingInformation::get_descriptor() const { return &BSSMAP__IE__PagingInformation_descr_; }
BSSMAP__IE__PagingInformation& BSSMAP__IE__PagingInformation::operator=(const BSSMAP__IE__PagingInformation& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_PagingInformation.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.VGCS__or__VBS().is_bound()) field_VGCS__or__VBS = other_value.VGCS__or__VBS();
  else field_VGCS__or__VBS.clean_up();
  if (other_value.pagingCause().is_bound()) field_pagingCause = other_value.pagingCause();
  else field_pagingCause.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
}
return *this;
}

boolean BSSMAP__IE__PagingInformation::operator==(const BSSMAP__IE__PagingInformation& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_VGCS__or__VBS==other_value.field_VGCS__or__VBS
  && field_pagingCause==other_value.field_pagingCause
  && field_spare==other_value.field_spare;
}

boolean BSSMAP__IE__PagingInformation::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_VGCS__or__VBS.is_bound())
  || (field_pagingCause.is_bound())
  || (field_spare.is_bound());
}
boolean BSSMAP__IE__PagingInformation::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_VGCS__or__VBS.is_value()
  && field_pagingCause.is_value()
  && field_spare.is_value();
}
void BSSMAP__IE__PagingInformation::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", VGCS_or_VBS := ");
field_VGCS__or__VBS.log();
TTCN_Logger::log_event_str(", pagingCause := ");
field_pagingCause.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__PagingInformation::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (VGCS__or__VBS().is_bound()) VGCS__or__VBS().set_implicit_omit();
if (pagingCause().is_bound()) pagingCause().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void BSSMAP__IE__PagingInformation::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_PagingInformation has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) VGCS__or__VBS().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) pagingCause().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "VGCS_or_VBS")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          VGCS__or__VBS().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pagingCause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pagingCause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_PagingInformation: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_PagingInformation");
  }
}

void BSSMAP__IE__PagingInformation::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_VGCS__or__VBS.encode_text(text_buf);
field_pagingCause.encode_text(text_buf);
field_spare.encode_text(text_buf);
}

void BSSMAP__IE__PagingInformation::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_VGCS__or__VBS.decode_text(text_buf);
field_pagingCause.decode_text(text_buf);
field_spare.decode_text(text_buf);
}

void BSSMAP__IE__PagingInformation::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__PagingInformation::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__PagingInformation::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__PagingInformation_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__PagingInformation_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__PagingInformation_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_VGCS__or__VBS.RAW_decode(General__Types::BIT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT2_descr_.raw->forceomit);
  decoded_field_length = field_pagingCause.RAW_decode(General__Types::BIT2_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::BIT5_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT5_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_93) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__PagingInformation::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__PagingInformation_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT2_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::BIT5_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__PagingInformation_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  encoded_length += field_VGCS__or__VBS.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_pagingCause.RAW_encode(General__Types::BIT2_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT5_descr_, *myleaf.body.node.nodes[4]);
  if (field_elementIdentifier !=  os_93) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_93.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__PagingInformation_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
BITSTRING_template field_VGCS__or__VBS;
BITSTRING_template field_pagingCause;
BITSTRING_template field_spare;
};

void BSSMAP__IE__PagingInformation_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_VGCS__or__VBS = ANY_VALUE;
single_value->field_pagingCause = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
}
}
}

void BSSMAP__IE__PagingInformation_template::copy_value(const BSSMAP__IE__PagingInformation& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.VGCS__or__VBS().is_bound()) {
  single_value->field_VGCS__or__VBS = other_value.VGCS__or__VBS();
} else {
  single_value->field_VGCS__or__VBS.clean_up();
}
if (other_value.pagingCause().is_bound()) {
  single_value->field_pagingCause = other_value.pagingCause();
} else {
  single_value->field_pagingCause.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__PagingInformation_template::copy_template(const BSSMAP__IE__PagingInformation_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.VGCS__or__VBS().get_selection()) {
single_value->field_VGCS__or__VBS = other_value.VGCS__or__VBS();
} else {
single_value->field_VGCS__or__VBS.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pagingCause().get_selection()) {
single_value->field_pagingCause = other_value.pagingCause();
} else {
single_value->field_pagingCause.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__PagingInformation_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__PagingInformation_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__PagingInformation_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_PagingInformation.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__PagingInformation_template::BSSMAP__IE__PagingInformation_template()
{
}

BSSMAP__IE__PagingInformation_template::BSSMAP__IE__PagingInformation_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__PagingInformation_template::BSSMAP__IE__PagingInformation_template(const BSSMAP__IE__PagingInformation& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__PagingInformation_template::BSSMAP__IE__PagingInformation_template(const OPTIONAL<BSSMAP__IE__PagingInformation>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__PagingInformation&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_PagingInformation from an unbound optional field.");
}
}

BSSMAP__IE__PagingInformation_template::BSSMAP__IE__PagingInformation_template(BSSMAP__IE__PagingInformation_template* p_precondition, BSSMAP__IE__PagingInformation_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__PagingInformation_template::BSSMAP__IE__PagingInformation_template(Dynamic_Match_Interface<BSSMAP__IE__PagingInformation>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__PagingInformation>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__PagingInformation_template::BSSMAP__IE__PagingInformation_template(const BSSMAP__IE__PagingInformation_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__PagingInformation_template::~BSSMAP__IE__PagingInformation_template()
{
clean_up();
}

BSSMAP__IE__PagingInformation_template& BSSMAP__IE__PagingInformation_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__PagingInformation_template& BSSMAP__IE__PagingInformation_template::operator=(const BSSMAP__IE__PagingInformation& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__PagingInformation_template& BSSMAP__IE__PagingInformation_template::operator=(const OPTIONAL<BSSMAP__IE__PagingInformation>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__PagingInformation&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_PagingInformation.");
}
return *this;
}

BSSMAP__IE__PagingInformation_template& BSSMAP__IE__PagingInformation_template::operator=(const BSSMAP__IE__PagingInformation_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__PagingInformation_template::match(const BSSMAP__IE__PagingInformation& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.VGCS__or__VBS().is_bound()) return FALSE;
if(!single_value->field_VGCS__or__VBS.match(other_value.VGCS__or__VBS(), legacy))return FALSE;
if(!other_value.pagingCause().is_bound()) return FALSE;
if(!single_value->field_pagingCause.match(other_value.pagingCause(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_PagingInformation.");
}
return FALSE;
}

boolean BSSMAP__IE__PagingInformation_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_VGCS__or__VBS.is_bound()
 || single_value->field_pagingCause.is_bound()
 || single_value->field_spare.is_bound();
}

boolean BSSMAP__IE__PagingInformation_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_VGCS__or__VBS.is_value()
 && single_value->field_pagingCause.is_value()
 && single_value->field_spare.is_value();
}

void BSSMAP__IE__PagingInformation_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__PagingInformation BSSMAP__IE__PagingInformation_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_PagingInformation.");
BSSMAP__IE__PagingInformation ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_VGCS__or__VBS.is_bound()) {
ret_val.VGCS__or__VBS() = single_value->field_VGCS__or__VBS.valueof();
}
if (single_value->field_pagingCause.is_bound()) {
ret_val.pagingCause() = single_value->field_pagingCause.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
return ret_val;
}

void BSSMAP__IE__PagingInformation_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_PagingInformation.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__PagingInformation_template[list_length];
}

BSSMAP__IE__PagingInformation_template& BSSMAP__IE__PagingInformation_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_PagingInformation.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_PagingInformation.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__PagingInformation_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__PagingInformation_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_PagingInformation.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__PagingInformation_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__PagingInformation_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_PagingInformation.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& BSSMAP__IE__PagingInformation_template::VGCS__or__VBS()
{
set_specific();
return single_value->field_VGCS__or__VBS;
}

const BITSTRING_template& BSSMAP__IE__PagingInformation_template::VGCS__or__VBS() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field VGCS_or_VBS of a non-specific template of type @BSSAP_Types.BSSMAP_IE_PagingInformation.");
return single_value->field_VGCS__or__VBS;
}

BITSTRING_template& BSSMAP__IE__PagingInformation_template::pagingCause()
{
set_specific();
return single_value->field_pagingCause;
}

const BITSTRING_template& BSSMAP__IE__PagingInformation_template::pagingCause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pagingCause of a non-specific template of type @BSSAP_Types.BSSMAP_IE_PagingInformation.");
return single_value->field_pagingCause;
}

BITSTRING_template& BSSMAP__IE__PagingInformation_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& BSSMAP__IE__PagingInformation_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @BSSAP_Types.BSSMAP_IE_PagingInformation.");
return single_value->field_spare;
}

int BSSMAP__IE__PagingInformation_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_PagingInformation which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_PagingInformation containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_PagingInformation containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_PagingInformation containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_PagingInformation containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_PagingInformation containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_PagingInformation containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_PagingInformation containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_PagingInformation containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_PagingInformation.");
  }
  return 0;
}

void BSSMAP__IE__PagingInformation_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", VGCS_or_VBS := ");
single_value->field_VGCS__or__VBS.log();
TTCN_Logger::log_event_str(", pagingCause := ");
single_value->field_pagingCause.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__PagingInformation_template::log_match(const BSSMAP__IE__PagingInformation& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_VGCS__or__VBS.match(match_value.VGCS__or__VBS(), legacy)){
TTCN_Logger::log_logmatch_info(".VGCS_or_VBS");
single_value->field_VGCS__or__VBS.log_match(match_value.VGCS__or__VBS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_pagingCause.match(match_value.pagingCause(), legacy)){
TTCN_Logger::log_logmatch_info(".pagingCause");
single_value->field_pagingCause.log_match(match_value.pagingCause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", VGCS_or_VBS := ");
single_value->field_VGCS__or__VBS.log_match(match_value.VGCS__or__VBS(), legacy);
TTCN_Logger::log_event_str(", pagingCause := ");
single_value->field_pagingCause.log_match(match_value.pagingCause(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__PagingInformation_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (VGCS__or__VBS().is_bound()) VGCS__or__VBS().set_implicit_omit();
if (pagingCause().is_bound()) pagingCause().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
}

void BSSMAP__IE__PagingInformation_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_VGCS__or__VBS.encode_text(text_buf);
single_value->field_pagingCause.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_PagingInformation.");
}
}

void BSSMAP__IE__PagingInformation_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_VGCS__or__VBS.decode_text(text_buf);
single_value->field_pagingCause.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__PagingInformation_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_PagingInformation.");
}
}

void BSSMAP__IE__PagingInformation_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__PagingInformation_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_PagingInformation has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) VGCS__or__VBS().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) pagingCause().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "VGCS_or_VBS")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          VGCS__or__VBS().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pagingCause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pagingCause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_PagingInformation: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__PagingInformation_template* precondition = new BSSMAP__IE__PagingInformation_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__PagingInformation_template* implied_template = new BSSMAP__IE__PagingInformation_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__PagingInformation_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_PagingInformation");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__PagingInformation_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_PagingInformation");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_PagingInformation");
single_value->field_VGCS__or__VBS.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_PagingInformation");
single_value->field_pagingCause.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_PagingInformation");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_PagingInformation");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_PagingInformation");
}

boolean BSSMAP__IE__PagingInformation_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__PagingInformation_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__IMEI::BSSMAP__IE__IMEI()
{
}

BSSMAP__IE__IMEI::BSSMAP__IE__IMEI(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const BITSTRING& par_typeOfIdentity,
    const BITSTRING& par_oddEvenIndicator,
    const HEXSTRING& par_digits)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_typeOfIdentity(par_typeOfIdentity),
  field_oddEvenIndicator(par_oddEvenIndicator),
  field_digits(par_digits)
{
}

BSSMAP__IE__IMEI::BSSMAP__IE__IMEI(const BSSMAP__IE__IMEI& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_IMEI.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.typeOfIdentity().is_bound()) field_typeOfIdentity = other_value.typeOfIdentity();
else field_typeOfIdentity.clean_up();
if (other_value.oddEvenIndicator().is_bound()) field_oddEvenIndicator = other_value.oddEvenIndicator();
else field_oddEvenIndicator.clean_up();
if (other_value.digits().is_bound()) field_digits = other_value.digits();
else field_digits.clean_up();
}

void BSSMAP__IE__IMEI::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_typeOfIdentity.clean_up();
field_oddEvenIndicator.clean_up();
field_digits.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__IMEI::get_descriptor() const { return &BSSMAP__IE__IMEI_descr_; }
BSSMAP__IE__IMEI& BSSMAP__IE__IMEI::operator=(const BSSMAP__IE__IMEI& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_IMEI.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.typeOfIdentity().is_bound()) field_typeOfIdentity = other_value.typeOfIdentity();
  else field_typeOfIdentity.clean_up();
  if (other_value.oddEvenIndicator().is_bound()) field_oddEvenIndicator = other_value.oddEvenIndicator();
  else field_oddEvenIndicator.clean_up();
  if (other_value.digits().is_bound()) field_digits = other_value.digits();
  else field_digits.clean_up();
}
return *this;
}

boolean BSSMAP__IE__IMEI::operator==(const BSSMAP__IE__IMEI& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_typeOfIdentity==other_value.field_typeOfIdentity
  && field_oddEvenIndicator==other_value.field_oddEvenIndicator
  && field_digits==other_value.field_digits;
}

boolean BSSMAP__IE__IMEI::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_typeOfIdentity.is_bound())
  || (field_oddEvenIndicator.is_bound())
  || (field_digits.is_bound());
}
boolean BSSMAP__IE__IMEI::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_typeOfIdentity.is_value()
  && field_oddEvenIndicator.is_value()
  && field_digits.is_value();
}
void BSSMAP__IE__IMEI::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", typeOfIdentity := ");
field_typeOfIdentity.log();
TTCN_Logger::log_event_str(", oddEvenIndicator := ");
field_oddEvenIndicator.log();
TTCN_Logger::log_event_str(", digits := ");
field_digits.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__IMEI::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (typeOfIdentity().is_bound()) typeOfIdentity().set_implicit_omit();
if (oddEvenIndicator().is_bound()) oddEvenIndicator().set_implicit_omit();
if (digits().is_bound()) digits().set_implicit_omit();
}

void BSSMAP__IE__IMEI::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_IMEI has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) typeOfIdentity().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) oddEvenIndicator().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) digits().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "typeOfIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          typeOfIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "oddEvenIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          oddEvenIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "digits")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          digits().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_IMEI: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_IMEI");
  }
}

void BSSMAP__IE__IMEI::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_typeOfIdentity.encode_text(text_buf);
field_oddEvenIndicator.encode_text(text_buf);
field_digits.encode_text(text_buf);
}

void BSSMAP__IE__IMEI::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_typeOfIdentity.decode_text(text_buf);
field_oddEvenIndicator.decode_text(text_buf);
field_digits.decode_text(text_buf);
}

void BSSMAP__IE__IMEI::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__IMEI::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__IMEI::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__IMEI_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__IMEI_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__IMEI_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::BIT3_descr_.raw->forceomit);
  decoded_field_length = field_typeOfIdentity.RAW_decode(General__Types::BIT3_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_oddEvenIndicator.RAW_decode(General__Types::BIT1_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, General__Types::HEX5__16_descr_.raw->forceomit);
  decoded_field_length = field_digits.RAW_decode(General__Types::HEX5__16_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_98) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__IMEI::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__IMEI_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::BIT3_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, General__Types::HEX5__16_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__IMEI_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 3;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(3);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  encoded_length += field_typeOfIdentity.RAW_encode(General__Types::BIT3_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_oddEvenIndicator.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_digits.RAW_encode(General__Types::HEX5__16_descr_, *myleaf.body.node.nodes[4]);
  if (field_elementIdentifier !=  os_98) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_98.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__IMEI_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
BITSTRING_template field_typeOfIdentity;
BITSTRING_template field_oddEvenIndicator;
HEXSTRING_template field_digits;
};

void BSSMAP__IE__IMEI_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_typeOfIdentity = ANY_VALUE;
single_value->field_oddEvenIndicator = ANY_VALUE;
single_value->field_digits = ANY_VALUE;
}
}
}

void BSSMAP__IE__IMEI_template::copy_value(const BSSMAP__IE__IMEI& other_value)
{
single_value = new single_value_struct;
if (other_value.elementIdentifier().is_bound()) {
  single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
  single_value->field_elementIdentifier.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.typeOfIdentity().is_bound()) {
  single_value->field_typeOfIdentity = other_value.typeOfIdentity();
} else {
  single_value->field_typeOfIdentity.clean_up();
}
if (other_value.oddEvenIndicator().is_bound()) {
  single_value->field_oddEvenIndicator = other_value.oddEvenIndicator();
} else {
  single_value->field_oddEvenIndicator.clean_up();
}
if (other_value.digits().is_bound()) {
  single_value->field_digits = other_value.digits();
} else {
  single_value->field_digits.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAP__IE__IMEI_template::copy_template(const BSSMAP__IE__IMEI_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.elementIdentifier().get_selection()) {
single_value->field_elementIdentifier = other_value.elementIdentifier();
} else {
single_value->field_elementIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.typeOfIdentity().get_selection()) {
single_value->field_typeOfIdentity = other_value.typeOfIdentity();
} else {
single_value->field_typeOfIdentity.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.oddEvenIndicator().get_selection()) {
single_value->field_oddEvenIndicator = other_value.oddEvenIndicator();
} else {
single_value->field_oddEvenIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.digits().get_selection()) {
single_value->field_digits = other_value.digits();
} else {
single_value->field_digits.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAP__IE__IMEI_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAP__IE__IMEI_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAP__IE__IMEI_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_IMEI.");
break;
}
set_selection(other_value);
}

BSSMAP__IE__IMEI_template::BSSMAP__IE__IMEI_template()
{
}

BSSMAP__IE__IMEI_template::BSSMAP__IE__IMEI_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAP__IE__IMEI_template::BSSMAP__IE__IMEI_template(const BSSMAP__IE__IMEI& other_value)
{
copy_value(other_value);
}

BSSMAP__IE__IMEI_template::BSSMAP__IE__IMEI_template(const OPTIONAL<BSSMAP__IE__IMEI>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__IMEI&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.BSSMAP_IE_IMEI from an unbound optional field.");
}
}

BSSMAP__IE__IMEI_template::BSSMAP__IE__IMEI_template(BSSMAP__IE__IMEI_template* p_precondition, BSSMAP__IE__IMEI_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAP__IE__IMEI_template::BSSMAP__IE__IMEI_template(Dynamic_Match_Interface<BSSMAP__IE__IMEI>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAP__IE__IMEI>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAP__IE__IMEI_template::BSSMAP__IE__IMEI_template(const BSSMAP__IE__IMEI_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

BSSMAP__IE__IMEI_template::~BSSMAP__IE__IMEI_template()
{
clean_up();
}

BSSMAP__IE__IMEI_template& BSSMAP__IE__IMEI_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAP__IE__IMEI_template& BSSMAP__IE__IMEI_template::operator=(const BSSMAP__IE__IMEI& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAP__IE__IMEI_template& BSSMAP__IE__IMEI_template::operator=(const OPTIONAL<BSSMAP__IE__IMEI>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAP__IE__IMEI&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.BSSMAP_IE_IMEI.");
}
return *this;
}

BSSMAP__IE__IMEI_template& BSSMAP__IE__IMEI_template::operator=(const BSSMAP__IE__IMEI_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAP__IE__IMEI_template::match(const BSSMAP__IE__IMEI& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.elementIdentifier().is_bound()) return FALSE;
if(!single_value->field_elementIdentifier.match(other_value.elementIdentifier(), legacy))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.typeOfIdentity().is_bound()) return FALSE;
if(!single_value->field_typeOfIdentity.match(other_value.typeOfIdentity(), legacy))return FALSE;
if(!other_value.oddEvenIndicator().is_bound()) return FALSE;
if(!single_value->field_oddEvenIndicator.match(other_value.oddEvenIndicator(), legacy))return FALSE;
if(!other_value.digits().is_bound()) return FALSE;
if(!single_value->field_digits.match(other_value.digits(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_IMEI.");
}
return FALSE;
}

boolean BSSMAP__IE__IMEI_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_elementIdentifier.is_bound()
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_typeOfIdentity.is_bound()
 || single_value->field_oddEvenIndicator.is_bound()
 || single_value->field_digits.is_bound();
}

boolean BSSMAP__IE__IMEI_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_elementIdentifier.is_value()
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_typeOfIdentity.is_value()
 && single_value->field_oddEvenIndicator.is_value()
 && single_value->field_digits.is_value();
}

void BSSMAP__IE__IMEI_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAP__IE__IMEI BSSMAP__IE__IMEI_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.BSSMAP_IE_IMEI.");
BSSMAP__IE__IMEI ret_val;
if (single_value->field_elementIdentifier.is_bound()) {
ret_val.elementIdentifier() = single_value->field_elementIdentifier.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_typeOfIdentity.is_bound()) {
ret_val.typeOfIdentity() = single_value->field_typeOfIdentity.valueof();
}
if (single_value->field_oddEvenIndicator.is_bound()) {
ret_val.oddEvenIndicator() = single_value->field_oddEvenIndicator.valueof();
}
if (single_value->field_digits.is_bound()) {
ret_val.digits() = single_value->field_digits.valueof();
}
return ret_val;
}

void BSSMAP__IE__IMEI_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.BSSMAP_IE_IMEI.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAP__IE__IMEI_template[list_length];
}

BSSMAP__IE__IMEI_template& BSSMAP__IE__IMEI_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.BSSMAP_IE_IMEI.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.BSSMAP_IE_IMEI.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& BSSMAP__IE__IMEI_template::elementIdentifier()
{
set_specific();
return single_value->field_elementIdentifier;
}

const OCTETSTRING_template& BSSMAP__IE__IMEI_template::elementIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field elementIdentifier of a non-specific template of type @BSSAP_Types.BSSMAP_IE_IMEI.");
return single_value->field_elementIdentifier;
}

INTEGER_template& BSSMAP__IE__IMEI_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& BSSMAP__IE__IMEI_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_IMEI.");
return single_value->field_lengthIndicator;
}

BITSTRING_template& BSSMAP__IE__IMEI_template::typeOfIdentity()
{
set_specific();
return single_value->field_typeOfIdentity;
}

const BITSTRING_template& BSSMAP__IE__IMEI_template::typeOfIdentity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field typeOfIdentity of a non-specific template of type @BSSAP_Types.BSSMAP_IE_IMEI.");
return single_value->field_typeOfIdentity;
}

BITSTRING_template& BSSMAP__IE__IMEI_template::oddEvenIndicator()
{
set_specific();
return single_value->field_oddEvenIndicator;
}

const BITSTRING_template& BSSMAP__IE__IMEI_template::oddEvenIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field oddEvenIndicator of a non-specific template of type @BSSAP_Types.BSSMAP_IE_IMEI.");
return single_value->field_oddEvenIndicator;
}

HEXSTRING_template& BSSMAP__IE__IMEI_template::digits()
{
set_specific();
return single_value->field_digits;
}

const HEXSTRING_template& BSSMAP__IE__IMEI_template::digits() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field digits of a non-specific template of type @BSSAP_Types.BSSMAP_IE_IMEI.");
return single_value->field_digits;
}

int BSSMAP__IE__IMEI_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_IMEI which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_IMEI containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_IMEI containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_IMEI containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_IMEI containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_IMEI containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_IMEI containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_IMEI containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.BSSMAP_IE_IMEI containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_IMEI.");
  }
  return 0;
}

void BSSMAP__IE__IMEI_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", typeOfIdentity := ");
single_value->field_typeOfIdentity.log();
TTCN_Logger::log_event_str(", oddEvenIndicator := ");
single_value->field_oddEvenIndicator.log();
TTCN_Logger::log_event_str(", digits := ");
single_value->field_digits.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAP__IE__IMEI_template::log_match(const BSSMAP__IE__IMEI& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_elementIdentifier.match(match_value.elementIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".elementIdentifier");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_typeOfIdentity.match(match_value.typeOfIdentity(), legacy)){
TTCN_Logger::log_logmatch_info(".typeOfIdentity");
single_value->field_typeOfIdentity.log_match(match_value.typeOfIdentity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_oddEvenIndicator.match(match_value.oddEvenIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".oddEvenIndicator");
single_value->field_oddEvenIndicator.log_match(match_value.oddEvenIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_digits.match(match_value.digits(), legacy)){
TTCN_Logger::log_logmatch_info(".digits");
single_value->field_digits.log_match(match_value.digits(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ elementIdentifier := ");
single_value->field_elementIdentifier.log_match(match_value.elementIdentifier(), legacy);
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", typeOfIdentity := ");
single_value->field_typeOfIdentity.log_match(match_value.typeOfIdentity(), legacy);
TTCN_Logger::log_event_str(", oddEvenIndicator := ");
single_value->field_oddEvenIndicator.log_match(match_value.oddEvenIndicator(), legacy);
TTCN_Logger::log_event_str(", digits := ");
single_value->field_digits.log_match(match_value.digits(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAP__IE__IMEI_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (typeOfIdentity().is_bound()) typeOfIdentity().set_implicit_omit();
if (oddEvenIndicator().is_bound()) oddEvenIndicator().set_implicit_omit();
if (digits().is_bound()) digits().set_implicit_omit();
}

void BSSMAP__IE__IMEI_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_elementIdentifier.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_typeOfIdentity.encode_text(text_buf);
single_value->field_oddEvenIndicator.encode_text(text_buf);
single_value->field_digits.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.BSSMAP_IE_IMEI.");
}
}

void BSSMAP__IE__IMEI_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_elementIdentifier.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_typeOfIdentity.decode_text(text_buf);
single_value->field_oddEvenIndicator.decode_text(text_buf);
single_value->field_digits.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAP__IE__IMEI_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.BSSMAP_IE_IMEI.");
}
}

void BSSMAP__IE__IMEI_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAP__IE__IMEI_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @BSSAP_Types.BSSMAP_IE_IMEI has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) typeOfIdentity().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) oddEvenIndicator().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) digits().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "typeOfIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          typeOfIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "oddEvenIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          oddEvenIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "digits")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          digits().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_IMEI: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAP__IE__IMEI_template* precondition = new BSSMAP__IE__IMEI_template;
    precondition->set_param(*param.get_elem(0));
    BSSMAP__IE__IMEI_template* implied_template = new BSSMAP__IE__IMEI_template;
    implied_template->set_param(*param.get_elem(1));
    *this = BSSMAP__IE__IMEI_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.BSSMAP_IE_IMEI");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAP__IE__IMEI_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_elementIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_IMEI");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_IMEI");
single_value->field_typeOfIdentity.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_IMEI");
single_value->field_oddEvenIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_IMEI");
single_value->field_digits.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_IMEI");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAP_IE_IMEI");
}

boolean BSSMAP__IE__IMEI_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAP__IE__IMEI_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

BSSMAP__IE__VelocityEstimate::BSSMAP__IE__VelocityEstimate()
{
}

BSSMAP__IE__VelocityEstimate::BSSMAP__IE__VelocityEstimate(const OCTETSTRING& par_elementIdentifier,
    const INTEGER& par_lengthIndicator,
    const OCTETSTRING& par_velocityEstimate)
  :   field_elementIdentifier(par_elementIdentifier),
  field_lengthIndicator(par_lengthIndicator),
  field_velocityEstimate(par_velocityEstimate)
{
}

BSSMAP__IE__VelocityEstimate::BSSMAP__IE__VelocityEstimate(const BSSMAP__IE__VelocityEstimate& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.BSSMAP_IE_VelocityEstimate.");
if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
else field_elementIdentifier.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.velocityEstimate().is_bound()) field_velocityEstimate = other_value.velocityEstimate();
else field_velocityEstimate.clean_up();
}

void BSSMAP__IE__VelocityEstimate::clean_up()
{
field_elementIdentifier.clean_up();
field_lengthIndicator.clean_up();
field_velocityEstimate.clean_up();
}

const TTCN_Typedescriptor_t* BSSMAP__IE__VelocityEstimate::get_descriptor() const { return &BSSMAP__IE__VelocityEstimate_descr_; }
BSSMAP__IE__VelocityEstimate& BSSMAP__IE__VelocityEstimate::operator=(const BSSMAP__IE__VelocityEstimate& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.BSSMAP_IE_VelocityEstimate.");
  if (other_value.elementIdentifier().is_bound()) field_elementIdentifier = other_value.elementIdentifier();
  else field_elementIdentifier.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.velocityEstimate().is_bound()) field_velocityEstimate = other_value.velocityEstimate();
  else field_velocityEstimate.clean_up();
}
return *this;
}

boolean BSSMAP__IE__VelocityEstimate::operator==(const BSSMAP__IE__VelocityEstimate& other_value) const
{
return field_elementIdentifier==other_value.field_elementIdentifier
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_velocityEstimate==other_value.field_velocityEstimate;
}

boolean BSSMAP__IE__VelocityEstimate::is_bound() const
{
return (field_elementIdentifier.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_velocityEstimate.is_bound());
}
boolean BSSMAP__IE__VelocityEstimate::is_value() const
{
return field_elementIdentifier.is_value()
  && field_lengthIndicator.is_value()
  && field_velocityEstimate.is_value();
}
void BSSMAP__IE__VelocityEstimate::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ elementIdentifier := ");
field_elementIdentifier.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", velocityEstimate := ");
field_velocityEstimate.log();
TTCN_Logger::log_event_str(" }");
}

void BSSMAP__IE__VelocityEstimate::set_implicit_omit()
{
if (elementIdentifier().is_bound()) elementIdentifier().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (velocityEstimate().is_bound()) velocityEstimate().set_implicit_omit();
}

void BSSMAP__IE__VelocityEstimate::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.BSSMAP_IE_VelocityEstimate has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) elementIdentifier().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) velocityEstimate().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "elementIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          elementIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "velocityEstimate")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          velocityEstimate().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.BSSMAP_IE_VelocityEstimate: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.BSSMAP_IE_VelocityEstimate");
  }
}

void BSSMAP__IE__VelocityEstimate::encode_text(Text_Buf& text_buf) const
{
field_elementIdentifier.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_velocityEstimate.encode_text(text_buf);
}

void BSSMAP__IE__VelocityEstimate::decode_text(Text_Buf& text_buf)
{
field_elementIdentifier.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_velocityEstimate.decode_text(text_buf);
}

void BSSMAP__IE__VelocityEstimate::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAP__IE__VelocityEstimate::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAP__IE__VelocityEstimate::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field1 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_elementIdentifier.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__VelocityEstimate_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(BSSMAP__IE__VelocityEstimate_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp1 = field_lengthIndicator.convert_to_Integer(BSSMAP__IE__VelocityEstimate_lengthIndicator_descr_);
  field_lengthIndicator = tmp1;
  value_of_length_field1 += tmp1.get_long_long_val() * 8;
  RAW_Force_Omit field_2_force_omit(2, force_omit, General__Types::OCTN_descr_.raw->forceomit);
  decoded_field_length = field_velocityEstimate.RAW_decode(General__Types::OCTN_descr_, p_buf, min_of_ints(2, limit, value_of_length_field1), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field1 -= decoded_field_length;
  if (field_elementIdentifier !=  os_49) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int BSSMAP__IE__VelocityEstimate::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__VelocityEstimate_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, General__Types::OCTN_descr_.raw);
  encoded_length += field_elementIdentifier.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += 8;
  myleaf.body.node.nodes[1]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[1]->coding_descr = &BSSMAP__IE__VelocityEstimate_lengthIndicator_descr_;
  myleaf.body.node.nodes[1]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[1]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[1]->length = 8;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[1]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_velocityEstimate.RAW_encode(General__Types::OCTN_descr_, *myleaf.body.node.nodes[2]);
  if (field_elementIdentifier !=  os_49) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_49.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct BSSMAP__IE__VelocityEstimate_template::single_value_struct {
OCTETSTRING_template field_elementIdentifier;
INTEGER_template field_lengthIndicator;
OCTETSTRING_template field_velocityEstimate;
};

void BSSMAP__IE__VelocityEstimate_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_elementIdentifier = ANY_VALUE;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_velocityEstimate = ANY_VALUE;
}
}
}

void BSSMAP__IE__VelocityEstimate_template::copy_value(const BSSMAP__IE__VelocityEstimate& other_value)
{
single_value = new single_value_struct;
if (other_value.