// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "BSSAP_Types.hh"

namespace BSSAP__Types {

/* Member functions of C++ classes */

PDU__BSSMAP__CipherModeReject::PDU__BSSMAP__CipherModeReject()
{
}

PDU__BSSMAP__CipherModeReject::PDU__BSSMAP__CipherModeReject(const OCTETSTRING& par_messageType,
    const BSSMAP__IE__Cause& par_cause)
  :   field_messageType(par_messageType),
  field_cause(par_cause)
{
}

PDU__BSSMAP__CipherModeReject::PDU__BSSMAP__CipherModeReject(const PDU__BSSMAP__CipherModeReject& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.cause().is_bound()) field_cause = other_value.cause();
else field_cause.clean_up();
}

void PDU__BSSMAP__CipherModeReject::clean_up()
{
field_messageType.clean_up();
field_cause.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__CipherModeReject::get_descriptor() const { return &PDU__BSSMAP__CipherModeReject_descr_; }
PDU__BSSMAP__CipherModeReject& PDU__BSSMAP__CipherModeReject::operator=(const PDU__BSSMAP__CipherModeReject& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.cause().is_bound()) field_cause = other_value.cause();
  else field_cause.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__CipherModeReject::operator==(const PDU__BSSMAP__CipherModeReject& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_cause==other_value.field_cause;
}

boolean PDU__BSSMAP__CipherModeReject::is_bound() const
{
return (field_messageType.is_bound())
  || (field_cause.is_bound());
}
boolean PDU__BSSMAP__CipherModeReject::is_value() const
{
return field_messageType.is_value()
  && field_cause.is_value();
}
void PDU__BSSMAP__CipherModeReject::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", cause := ");
field_cause.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__CipherModeReject::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (cause().is_bound()) cause().set_implicit_omit();
}

void PDU__BSSMAP__CipherModeReject::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_CipherModeReject: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_CipherModeReject");
  }
}

void PDU__BSSMAP__CipherModeReject::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_cause.encode_text(text_buf);
}

void PDU__BSSMAP__CipherModeReject::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_cause.decode_text(text_buf);
}

void PDU__BSSMAP__CipherModeReject::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__CipherModeReject::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__CipherModeReject::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__Cause_descr_.raw->forceomit);
  decoded_field_length = field_cause.RAW_decode(BSSMAP__IE__Cause_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_messageType !=  os_50) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__CipherModeReject::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__Cause_descr_.raw);
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_cause.RAW_encode(BSSMAP__IE__Cause_descr_, *myleaf.body.node.nodes[1]);
  if (field_messageType !=  os_50) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_50.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__CipherModeReject_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__Cause_template field_cause;
};

void PDU__BSSMAP__CipherModeReject_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_cause = ANY_VALUE;
}
}
}

void PDU__BSSMAP__CipherModeReject_template::copy_value(const PDU__BSSMAP__CipherModeReject& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.cause().is_bound()) {
  single_value->field_cause = other_value.cause();
} else {
  single_value->field_cause.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__CipherModeReject_template::copy_template(const PDU__BSSMAP__CipherModeReject_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cause().get_selection()) {
single_value->field_cause = other_value.cause();
} else {
single_value->field_cause.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__CipherModeReject_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__CipherModeReject_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__CipherModeReject_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__CipherModeReject_template::PDU__BSSMAP__CipherModeReject_template()
{
}

PDU__BSSMAP__CipherModeReject_template::PDU__BSSMAP__CipherModeReject_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__CipherModeReject_template::PDU__BSSMAP__CipherModeReject_template(const PDU__BSSMAP__CipherModeReject& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__CipherModeReject_template::PDU__BSSMAP__CipherModeReject_template(const OPTIONAL<PDU__BSSMAP__CipherModeReject>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__CipherModeReject&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject from an unbound optional field.");
}
}

PDU__BSSMAP__CipherModeReject_template::PDU__BSSMAP__CipherModeReject_template(PDU__BSSMAP__CipherModeReject_template* p_precondition, PDU__BSSMAP__CipherModeReject_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__CipherModeReject_template::PDU__BSSMAP__CipherModeReject_template(Dynamic_Match_Interface<PDU__BSSMAP__CipherModeReject>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__CipherModeReject>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__CipherModeReject_template::PDU__BSSMAP__CipherModeReject_template(const PDU__BSSMAP__CipherModeReject_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__CipherModeReject_template::~PDU__BSSMAP__CipherModeReject_template()
{
clean_up();
}

PDU__BSSMAP__CipherModeReject_template& PDU__BSSMAP__CipherModeReject_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__CipherModeReject_template& PDU__BSSMAP__CipherModeReject_template::operator=(const PDU__BSSMAP__CipherModeReject& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__CipherModeReject_template& PDU__BSSMAP__CipherModeReject_template::operator=(const OPTIONAL<PDU__BSSMAP__CipherModeReject>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__CipherModeReject&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject.");
}
return *this;
}

PDU__BSSMAP__CipherModeReject_template& PDU__BSSMAP__CipherModeReject_template::operator=(const PDU__BSSMAP__CipherModeReject_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__CipherModeReject_template::match(const PDU__BSSMAP__CipherModeReject& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.cause().is_bound()) return FALSE;
if(!single_value->field_cause.match(other_value.cause(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject.");
}
return FALSE;
}

boolean PDU__BSSMAP__CipherModeReject_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_cause.is_bound();
}

boolean PDU__BSSMAP__CipherModeReject_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_cause.is_value();
}

void PDU__BSSMAP__CipherModeReject_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__CipherModeReject PDU__BSSMAP__CipherModeReject_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject.");
PDU__BSSMAP__CipherModeReject ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_cause.is_bound()) {
ret_val.cause() = single_value->field_cause.valueof();
}
return ret_val;
}

void PDU__BSSMAP__CipherModeReject_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__CipherModeReject_template[list_length];
}

PDU__BSSMAP__CipherModeReject_template& PDU__BSSMAP__CipherModeReject_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__CipherModeReject_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__CipherModeReject_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject.");
return single_value->field_messageType;
}

BSSMAP__IE__Cause_template& PDU__BSSMAP__CipherModeReject_template::cause()
{
set_specific();
return single_value->field_cause;
}

const BSSMAP__IE__Cause_template& PDU__BSSMAP__CipherModeReject_template::cause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cause of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject.");
return single_value->field_cause;
}

int PDU__BSSMAP__CipherModeReject_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject.");
  }
  return 0;
}

void PDU__BSSMAP__CipherModeReject_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__CipherModeReject_template::log_match(const PDU__BSSMAP__CipherModeReject& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cause.match(match_value.cause(), legacy)){
TTCN_Logger::log_logmatch_info(".cause");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__CipherModeReject_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (cause().is_bound()) cause().set_implicit_omit();
}

void PDU__BSSMAP__CipherModeReject_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_cause.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject.");
}
}

void PDU__BSSMAP__CipherModeReject_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_cause.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__CipherModeReject_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject.");
}
}

void PDU__BSSMAP__CipherModeReject_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__CipherModeReject_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_CipherModeReject has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_CipherModeReject: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__CipherModeReject_template* precondition = new PDU__BSSMAP__CipherModeReject_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__CipherModeReject_template* implied_template = new PDU__BSSMAP__CipherModeReject_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__CipherModeReject_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_CipherModeReject");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__CipherModeReject_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_CipherModeReject");
single_value->field_cause.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_CipherModeReject");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_CipherModeReject");
}

boolean PDU__BSSMAP__CipherModeReject_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__CipherModeReject_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__LoadIndication::PDU__BSSMAP__LoadIndication()
{
}

PDU__BSSMAP__LoadIndication::PDU__BSSMAP__LoadIndication(const OCTETSTRING& par_messageType,
    const BSSMAP__IE__TimeIndication& par_timeIndication,
    const BSSMAP__IE__CellIdentifier& par_cellIdentifier,
    const BSSMAP__IE__CellIdentifierList& par_cellIdentifierList,
    const OPTIONAL< BSSMAP__IE__ResourceSituation >& par_resourceSitation,
    const OPTIONAL< BSSMAP__IE__Cause >& par_cause)
  :   field_messageType(par_messageType),
  field_timeIndication(par_timeIndication),
  field_cellIdentifier(par_cellIdentifier),
  field_cellIdentifierList(par_cellIdentifierList),
  field_resourceSitation(par_resourceSitation),
  field_cause(par_cause)
{
}

PDU__BSSMAP__LoadIndication::PDU__BSSMAP__LoadIndication(const PDU__BSSMAP__LoadIndication& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_LoadIndication.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.timeIndication().is_bound()) field_timeIndication = other_value.timeIndication();
else field_timeIndication.clean_up();
if (other_value.cellIdentifier().is_bound()) field_cellIdentifier = other_value.cellIdentifier();
else field_cellIdentifier.clean_up();
if (other_value.cellIdentifierList().is_bound()) field_cellIdentifierList = other_value.cellIdentifierList();
else field_cellIdentifierList.clean_up();
if (other_value.resourceSitation().is_bound()) field_resourceSitation = other_value.resourceSitation();
else field_resourceSitation.clean_up();
if (other_value.cause().is_bound()) field_cause = other_value.cause();
else field_cause.clean_up();
}

void PDU__BSSMAP__LoadIndication::clean_up()
{
field_messageType.clean_up();
field_timeIndication.clean_up();
field_cellIdentifier.clean_up();
field_cellIdentifierList.clean_up();
field_resourceSitation.clean_up();
field_cause.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__LoadIndication::get_descriptor() const { return &PDU__BSSMAP__LoadIndication_descr_; }
PDU__BSSMAP__LoadIndication& PDU__BSSMAP__LoadIndication::operator=(const PDU__BSSMAP__LoadIndication& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_LoadIndication.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.timeIndication().is_bound()) field_timeIndication = other_value.timeIndication();
  else field_timeIndication.clean_up();
  if (other_value.cellIdentifier().is_bound()) field_cellIdentifier = other_value.cellIdentifier();
  else field_cellIdentifier.clean_up();
  if (other_value.cellIdentifierList().is_bound()) field_cellIdentifierList = other_value.cellIdentifierList();
  else field_cellIdentifierList.clean_up();
  if (other_value.resourceSitation().is_bound()) field_resourceSitation = other_value.resourceSitation();
  else field_resourceSitation.clean_up();
  if (other_value.cause().is_bound()) field_cause = other_value.cause();
  else field_cause.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__LoadIndication::operator==(const PDU__BSSMAP__LoadIndication& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_timeIndication==other_value.field_timeIndication
  && field_cellIdentifier==other_value.field_cellIdentifier
  && field_cellIdentifierList==other_value.field_cellIdentifierList
  && field_resourceSitation==other_value.field_resourceSitation
  && field_cause==other_value.field_cause;
}

boolean PDU__BSSMAP__LoadIndication::is_bound() const
{
return (field_messageType.is_bound())
  || (field_timeIndication.is_bound())
  || (field_cellIdentifier.is_bound())
  || (field_cellIdentifierList.is_bound())
  || (OPTIONAL_OMIT == field_resourceSitation.get_selection() || field_resourceSitation.is_bound())
  || (OPTIONAL_OMIT == field_cause.get_selection() || field_cause.is_bound());
}
boolean PDU__BSSMAP__LoadIndication::is_value() const
{
return field_messageType.is_value()
  && field_timeIndication.is_value()
  && field_cellIdentifier.is_value()
  && field_cellIdentifierList.is_value()
  && (OPTIONAL_OMIT == field_resourceSitation.get_selection() || field_resourceSitation.is_value())
  && (OPTIONAL_OMIT == field_cause.get_selection() || field_cause.is_value());
}
int PDU__BSSMAP__LoadIndication::size_of() const
{
  int ret_val = 4;
  if (field_resourceSitation.ispresent()) ret_val++;
  if (field_cause.ispresent()) ret_val++;
  return ret_val;
}

void PDU__BSSMAP__LoadIndication::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", timeIndication := ");
field_timeIndication.log();
TTCN_Logger::log_event_str(", cellIdentifier := ");
field_cellIdentifier.log();
TTCN_Logger::log_event_str(", cellIdentifierList := ");
field_cellIdentifierList.log();
TTCN_Logger::log_event_str(", resourceSitation := ");
field_resourceSitation.log();
TTCN_Logger::log_event_str(", cause := ");
field_cause.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__LoadIndication::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (timeIndication().is_bound()) timeIndication().set_implicit_omit();
if (cellIdentifier().is_bound()) cellIdentifier().set_implicit_omit();
if (cellIdentifierList().is_bound()) cellIdentifierList().set_implicit_omit();
if (!resourceSitation().is_bound()) resourceSitation() = OMIT_VALUE;
else resourceSitation().set_implicit_omit();
if (!cause().is_bound()) cause() = OMIT_VALUE;
else cause().set_implicit_omit();
}

void PDU__BSSMAP__LoadIndication::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_LoadIndication has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) timeIndication().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cellIdentifier().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) cellIdentifierList().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) resourceSitation().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "timeIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          timeIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentifierList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentifierList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "resourceSitation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          resourceSitation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_LoadIndication: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_LoadIndication");
  }
}

void PDU__BSSMAP__LoadIndication::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_timeIndication.encode_text(text_buf);
field_cellIdentifier.encode_text(text_buf);
field_cellIdentifierList.encode_text(text_buf);
field_resourceSitation.encode_text(text_buf);
field_cause.encode_text(text_buf);
}

void PDU__BSSMAP__LoadIndication::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_timeIndication.decode_text(text_buf);
field_cellIdentifier.decode_text(text_buf);
field_cellIdentifierList.decode_text(text_buf);
field_resourceSitation.decode_text(text_buf);
field_cause.decode_text(text_buf);
}

void PDU__BSSMAP__LoadIndication::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__LoadIndication::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__LoadIndication::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__TimeIndication_descr_.raw->forceomit);
  decoded_field_length = field_timeIndication.RAW_decode(BSSMAP__IE__TimeIndication_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, BSSMAP__IE__CellIdentifier_descr_.raw->forceomit);
  decoded_field_length = field_cellIdentifier.RAW_decode(BSSMAP__IE__CellIdentifier_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, BSSMAP__IE__CellIdentifierList_descr_.raw->forceomit);
  decoded_field_length = field_cellIdentifierList.RAW_decode(BSSMAP__IE__CellIdentifierList_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_resourceSitation = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, BSSMAP__IE__ResourceSituation_descr_.raw->forceomit);
  decoded_field_length = field_resourceSitation().RAW_decode(BSSMAP__IE__ResourceSituation_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_resourceSitation = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_resourceSitation=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_cause = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, BSSMAP__IE__Cause_descr_.raw->forceomit);
  decoded_field_length = field_cause().RAW_decode(BSSMAP__IE__Cause_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_cause = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_cause=OMIT_VALUE;
  if (field_messageType !=  os_88) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__LoadIndication::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 6;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(6);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__TimeIndication_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, BSSMAP__IE__CellIdentifier_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, BSSMAP__IE__CellIdentifierList_descr_.raw);
  if (field_resourceSitation.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, BSSMAP__IE__ResourceSituation_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  if (field_cause.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, BSSMAP__IE__Cause_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_timeIndication.RAW_encode(BSSMAP__IE__TimeIndication_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_cellIdentifier.RAW_encode(BSSMAP__IE__CellIdentifier_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_cellIdentifierList.RAW_encode(BSSMAP__IE__CellIdentifierList_descr_, *myleaf.body.node.nodes[3]);
  if (field_resourceSitation.ispresent()) {
  encoded_length += field_resourceSitation().RAW_encode(BSSMAP__IE__ResourceSituation_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_cause.ispresent()) {
  encoded_length += field_cause().RAW_encode(BSSMAP__IE__Cause_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_messageType !=  os_88) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_88.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__LoadIndication_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__TimeIndication_template field_timeIndication;
BSSMAP__IE__CellIdentifier_template field_cellIdentifier;
BSSMAP__IE__CellIdentifierList_template field_cellIdentifierList;
BSSMAP__IE__ResourceSituation_template field_resourceSitation;
BSSMAP__IE__Cause_template field_cause;
};

void PDU__BSSMAP__LoadIndication_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_timeIndication = ANY_VALUE;
single_value->field_cellIdentifier = ANY_VALUE;
single_value->field_cellIdentifierList = ANY_VALUE;
single_value->field_resourceSitation = ANY_OR_OMIT;
single_value->field_cause = ANY_OR_OMIT;
}
}
}

void PDU__BSSMAP__LoadIndication_template::copy_value(const PDU__BSSMAP__LoadIndication& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.timeIndication().is_bound()) {
  single_value->field_timeIndication = other_value.timeIndication();
} else {
  single_value->field_timeIndication.clean_up();
}
if (other_value.cellIdentifier().is_bound()) {
  single_value->field_cellIdentifier = other_value.cellIdentifier();
} else {
  single_value->field_cellIdentifier.clean_up();
}
if (other_value.cellIdentifierList().is_bound()) {
  single_value->field_cellIdentifierList = other_value.cellIdentifierList();
} else {
  single_value->field_cellIdentifierList.clean_up();
}
if (other_value.resourceSitation().is_bound()) {
  if (other_value.resourceSitation().ispresent()) single_value->field_resourceSitation = other_value.resourceSitation()();
  else single_value->field_resourceSitation = OMIT_VALUE;
} else {
  single_value->field_resourceSitation.clean_up();
}
if (other_value.cause().is_bound()) {
  if (other_value.cause().ispresent()) single_value->field_cause = other_value.cause()();
  else single_value->field_cause = OMIT_VALUE;
} else {
  single_value->field_cause.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__LoadIndication_template::copy_template(const PDU__BSSMAP__LoadIndication_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.timeIndication().get_selection()) {
single_value->field_timeIndication = other_value.timeIndication();
} else {
single_value->field_timeIndication.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cellIdentifier().get_selection()) {
single_value->field_cellIdentifier = other_value.cellIdentifier();
} else {
single_value->field_cellIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cellIdentifierList().get_selection()) {
single_value->field_cellIdentifierList = other_value.cellIdentifierList();
} else {
single_value->field_cellIdentifierList.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.resourceSitation().get_selection()) {
single_value->field_resourceSitation = other_value.resourceSitation();
} else {
single_value->field_resourceSitation.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cause().get_selection()) {
single_value->field_cause = other_value.cause();
} else {
single_value->field_cause.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__LoadIndication_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__LoadIndication_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__LoadIndication_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__LoadIndication_template::PDU__BSSMAP__LoadIndication_template()
{
}

PDU__BSSMAP__LoadIndication_template::PDU__BSSMAP__LoadIndication_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__LoadIndication_template::PDU__BSSMAP__LoadIndication_template(const PDU__BSSMAP__LoadIndication& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__LoadIndication_template::PDU__BSSMAP__LoadIndication_template(const OPTIONAL<PDU__BSSMAP__LoadIndication>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__LoadIndication&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication from an unbound optional field.");
}
}

PDU__BSSMAP__LoadIndication_template::PDU__BSSMAP__LoadIndication_template(PDU__BSSMAP__LoadIndication_template* p_precondition, PDU__BSSMAP__LoadIndication_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__LoadIndication_template::PDU__BSSMAP__LoadIndication_template(Dynamic_Match_Interface<PDU__BSSMAP__LoadIndication>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__LoadIndication>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__LoadIndication_template::PDU__BSSMAP__LoadIndication_template(const PDU__BSSMAP__LoadIndication_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__LoadIndication_template::~PDU__BSSMAP__LoadIndication_template()
{
clean_up();
}

PDU__BSSMAP__LoadIndication_template& PDU__BSSMAP__LoadIndication_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__LoadIndication_template& PDU__BSSMAP__LoadIndication_template::operator=(const PDU__BSSMAP__LoadIndication& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__LoadIndication_template& PDU__BSSMAP__LoadIndication_template::operator=(const OPTIONAL<PDU__BSSMAP__LoadIndication>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__LoadIndication&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication.");
}
return *this;
}

PDU__BSSMAP__LoadIndication_template& PDU__BSSMAP__LoadIndication_template::operator=(const PDU__BSSMAP__LoadIndication_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__LoadIndication_template::match(const PDU__BSSMAP__LoadIndication& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.timeIndication().is_bound()) return FALSE;
if(!single_value->field_timeIndication.match(other_value.timeIndication(), legacy))return FALSE;
if(!other_value.cellIdentifier().is_bound()) return FALSE;
if(!single_value->field_cellIdentifier.match(other_value.cellIdentifier(), legacy))return FALSE;
if(!other_value.cellIdentifierList().is_bound()) return FALSE;
if(!single_value->field_cellIdentifierList.match(other_value.cellIdentifierList(), legacy))return FALSE;
if(!other_value.resourceSitation().is_bound()) return FALSE;
if((other_value.resourceSitation().ispresent() ? !single_value->field_resourceSitation.match((const BSSMAP__IE__ResourceSituation&)other_value.resourceSitation(), legacy) : !single_value->field_resourceSitation.match_omit(legacy)))return FALSE;
if(!other_value.cause().is_bound()) return FALSE;
if((other_value.cause().ispresent() ? !single_value->field_cause.match((const BSSMAP__IE__Cause&)other_value.cause(), legacy) : !single_value->field_cause.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication.");
}
return FALSE;
}

boolean PDU__BSSMAP__LoadIndication_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_timeIndication.is_bound()
 || single_value->field_cellIdentifier.is_bound()
 || single_value->field_cellIdentifierList.is_bound()
 || (single_value->field_resourceSitation.is_omit() || single_value->field_resourceSitation.is_bound())
 || (single_value->field_cause.is_omit() || single_value->field_cause.is_bound());
}

boolean PDU__BSSMAP__LoadIndication_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_timeIndication.is_value()
 && single_value->field_cellIdentifier.is_value()
 && single_value->field_cellIdentifierList.is_value()
 && (single_value->field_resourceSitation.is_omit() || single_value->field_resourceSitation.is_value())
 && (single_value->field_cause.is_omit() || single_value->field_cause.is_value());
}

void PDU__BSSMAP__LoadIndication_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__LoadIndication PDU__BSSMAP__LoadIndication_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication.");
PDU__BSSMAP__LoadIndication ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_timeIndication.is_bound()) {
ret_val.timeIndication() = single_value->field_timeIndication.valueof();
}
if (single_value->field_cellIdentifier.is_bound()) {
ret_val.cellIdentifier() = single_value->field_cellIdentifier.valueof();
}
if (single_value->field_cellIdentifierList.is_bound()) {
ret_val.cellIdentifierList() = single_value->field_cellIdentifierList.valueof();
}
if (single_value->field_resourceSitation.is_omit()) ret_val.resourceSitation() = OMIT_VALUE;
else if (single_value->field_resourceSitation.is_bound()) {
ret_val.resourceSitation() = single_value->field_resourceSitation.valueof();
}
if (single_value->field_cause.is_omit()) ret_val.cause() = OMIT_VALUE;
else if (single_value->field_cause.is_bound()) {
ret_val.cause() = single_value->field_cause.valueof();
}
return ret_val;
}

void PDU__BSSMAP__LoadIndication_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__LoadIndication_template[list_length];
}

PDU__BSSMAP__LoadIndication_template& PDU__BSSMAP__LoadIndication_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__LoadIndication_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__LoadIndication_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication.");
return single_value->field_messageType;
}

BSSMAP__IE__TimeIndication_template& PDU__BSSMAP__LoadIndication_template::timeIndication()
{
set_specific();
return single_value->field_timeIndication;
}

const BSSMAP__IE__TimeIndication_template& PDU__BSSMAP__LoadIndication_template::timeIndication() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field timeIndication of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication.");
return single_value->field_timeIndication;
}

BSSMAP__IE__CellIdentifier_template& PDU__BSSMAP__LoadIndication_template::cellIdentifier()
{
set_specific();
return single_value->field_cellIdentifier;
}

const BSSMAP__IE__CellIdentifier_template& PDU__BSSMAP__LoadIndication_template::cellIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cellIdentifier of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication.");
return single_value->field_cellIdentifier;
}

BSSMAP__IE__CellIdentifierList_template& PDU__BSSMAP__LoadIndication_template::cellIdentifierList()
{
set_specific();
return single_value->field_cellIdentifierList;
}

const BSSMAP__IE__CellIdentifierList_template& PDU__BSSMAP__LoadIndication_template::cellIdentifierList() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cellIdentifierList of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication.");
return single_value->field_cellIdentifierList;
}

BSSMAP__IE__ResourceSituation_template& PDU__BSSMAP__LoadIndication_template::resourceSitation()
{
set_specific();
return single_value->field_resourceSitation;
}

const BSSMAP__IE__ResourceSituation_template& PDU__BSSMAP__LoadIndication_template::resourceSitation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field resourceSitation of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication.");
return single_value->field_resourceSitation;
}

BSSMAP__IE__Cause_template& PDU__BSSMAP__LoadIndication_template::cause()
{
set_specific();
return single_value->field_cause;
}

const BSSMAP__IE__Cause_template& PDU__BSSMAP__LoadIndication_template::cause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cause of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication.");
return single_value->field_cause;
}

int PDU__BSSMAP__LoadIndication_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 4;
      if (single_value->field_resourceSitation.is_present()) ret_val++;
      if (single_value->field_cause.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication.");
  }
  return 0;
}

void PDU__BSSMAP__LoadIndication_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", timeIndication := ");
single_value->field_timeIndication.log();
TTCN_Logger::log_event_str(", cellIdentifier := ");
single_value->field_cellIdentifier.log();
TTCN_Logger::log_event_str(", cellIdentifierList := ");
single_value->field_cellIdentifierList.log();
TTCN_Logger::log_event_str(", resourceSitation := ");
single_value->field_resourceSitation.log();
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__LoadIndication_template::log_match(const PDU__BSSMAP__LoadIndication& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_timeIndication.match(match_value.timeIndication(), legacy)){
TTCN_Logger::log_logmatch_info(".timeIndication");
single_value->field_timeIndication.log_match(match_value.timeIndication(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cellIdentifier.match(match_value.cellIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".cellIdentifier");
single_value->field_cellIdentifier.log_match(match_value.cellIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cellIdentifierList.match(match_value.cellIdentifierList(), legacy)){
TTCN_Logger::log_logmatch_info(".cellIdentifierList");
single_value->field_cellIdentifierList.log_match(match_value.cellIdentifierList(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.resourceSitation().ispresent()){
if(!single_value->field_resourceSitation.match(match_value.resourceSitation(), legacy)){
TTCN_Logger::log_logmatch_info(".resourceSitation");
single_value->field_resourceSitation.log_match(match_value.resourceSitation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_resourceSitation.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".resourceSitation := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_resourceSitation.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.cause().ispresent()){
if(!single_value->field_cause.match(match_value.cause(), legacy)){
TTCN_Logger::log_logmatch_info(".cause");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_cause.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".cause := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_cause.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", timeIndication := ");
single_value->field_timeIndication.log_match(match_value.timeIndication(), legacy);
TTCN_Logger::log_event_str(", cellIdentifier := ");
single_value->field_cellIdentifier.log_match(match_value.cellIdentifier(), legacy);
TTCN_Logger::log_event_str(", cellIdentifierList := ");
single_value->field_cellIdentifierList.log_match(match_value.cellIdentifierList(), legacy);
TTCN_Logger::log_event_str(", resourceSitation := ");
if (match_value.resourceSitation().ispresent()) {
single_value->field_resourceSitation.log_match(match_value.resourceSitation(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_resourceSitation.log();
if (single_value->field_resourceSitation.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", cause := ");
if (match_value.cause().ispresent()) {
single_value->field_cause.log_match(match_value.cause(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_cause.log();
if (single_value->field_cause.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__LoadIndication_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (timeIndication().is_bound()) timeIndication().set_implicit_omit();
if (cellIdentifier().is_bound()) cellIdentifier().set_implicit_omit();
if (cellIdentifierList().is_bound()) cellIdentifierList().set_implicit_omit();
if (!resourceSitation().is_bound()) resourceSitation() = OMIT_VALUE;
else resourceSitation().set_implicit_omit();
if (!cause().is_bound()) cause() = OMIT_VALUE;
else cause().set_implicit_omit();
}

void PDU__BSSMAP__LoadIndication_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_timeIndication.encode_text(text_buf);
single_value->field_cellIdentifier.encode_text(text_buf);
single_value->field_cellIdentifierList.encode_text(text_buf);
single_value->field_resourceSitation.encode_text(text_buf);
single_value->field_cause.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication.");
}
}

void PDU__BSSMAP__LoadIndication_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_timeIndication.decode_text(text_buf);
single_value->field_cellIdentifier.decode_text(text_buf);
single_value->field_cellIdentifierList.decode_text(text_buf);
single_value->field_resourceSitation.decode_text(text_buf);
single_value->field_cause.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__LoadIndication_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication.");
}
}

void PDU__BSSMAP__LoadIndication_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__LoadIndication_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_LoadIndication has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) timeIndication().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cellIdentifier().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) cellIdentifierList().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) resourceSitation().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "timeIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          timeIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentifierList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentifierList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "resourceSitation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          resourceSitation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_LoadIndication: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__LoadIndication_template* precondition = new PDU__BSSMAP__LoadIndication_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__LoadIndication_template* implied_template = new PDU__BSSMAP__LoadIndication_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__LoadIndication_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_LoadIndication");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__LoadIndication_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_LoadIndication");
single_value->field_timeIndication.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_LoadIndication");
single_value->field_cellIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_LoadIndication");
single_value->field_cellIdentifierList.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_LoadIndication");
single_value->field_resourceSitation.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_LoadIndication");
single_value->field_cause.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_LoadIndication");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_LoadIndication");
}

boolean PDU__BSSMAP__LoadIndication_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__LoadIndication_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__VGCS__VBSSetup::PDU__BSSMAP__VGCS__VBSSetup()
{
}

PDU__BSSMAP__VGCS__VBSSetup::PDU__BSSMAP__VGCS__VBSSetup(const OCTETSTRING& par_messageType,
    const BSSMAP__IE__GroupCallReference& par_groupCallReference,
    const OPTIONAL< BSSMAP__IE__Priority >& par_priority,
    const OPTIONAL< BSSMAP__IE__VGCS__FeatureFlags >& par_vGCS__FeatureFlags)
  :   field_messageType(par_messageType),
  field_groupCallReference(par_groupCallReference),
  field_priority(par_priority),
  field_vGCS__FeatureFlags(par_vGCS__FeatureFlags)
{
}

PDU__BSSMAP__VGCS__VBSSetup::PDU__BSSMAP__VGCS__VBSSetup(const PDU__BSSMAP__VGCS__VBSSetup& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.groupCallReference().is_bound()) field_groupCallReference = other_value.groupCallReference();
else field_groupCallReference.clean_up();
if (other_value.priority().is_bound()) field_priority = other_value.priority();
else field_priority.clean_up();
if (other_value.vGCS__FeatureFlags().is_bound()) field_vGCS__FeatureFlags = other_value.vGCS__FeatureFlags();
else field_vGCS__FeatureFlags.clean_up();
}

void PDU__BSSMAP__VGCS__VBSSetup::clean_up()
{
field_messageType.clean_up();
field_groupCallReference.clean_up();
field_priority.clean_up();
field_vGCS__FeatureFlags.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__VGCS__VBSSetup::get_descriptor() const { return &PDU__BSSMAP__VGCS__VBSSetup_descr_; }
PDU__BSSMAP__VGCS__VBSSetup& PDU__BSSMAP__VGCS__VBSSetup::operator=(const PDU__BSSMAP__VGCS__VBSSetup& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.groupCallReference().is_bound()) field_groupCallReference = other_value.groupCallReference();
  else field_groupCallReference.clean_up();
  if (other_value.priority().is_bound()) field_priority = other_value.priority();
  else field_priority.clean_up();
  if (other_value.vGCS__FeatureFlags().is_bound()) field_vGCS__FeatureFlags = other_value.vGCS__FeatureFlags();
  else field_vGCS__FeatureFlags.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__VGCS__VBSSetup::operator==(const PDU__BSSMAP__VGCS__VBSSetup& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_groupCallReference==other_value.field_groupCallReference
  && field_priority==other_value.field_priority
  && field_vGCS__FeatureFlags==other_value.field_vGCS__FeatureFlags;
}

boolean PDU__BSSMAP__VGCS__VBSSetup::is_bound() const
{
return (field_messageType.is_bound())
  || (field_groupCallReference.is_bound())
  || (OPTIONAL_OMIT == field_priority.get_selection() || field_priority.is_bound())
  || (OPTIONAL_OMIT == field_vGCS__FeatureFlags.get_selection() || field_vGCS__FeatureFlags.is_bound());
}
boolean PDU__BSSMAP__VGCS__VBSSetup::is_value() const
{
return field_messageType.is_value()
  && field_groupCallReference.is_value()
  && (OPTIONAL_OMIT == field_priority.get_selection() || field_priority.is_value())
  && (OPTIONAL_OMIT == field_vGCS__FeatureFlags.get_selection() || field_vGCS__FeatureFlags.is_value());
}
int PDU__BSSMAP__VGCS__VBSSetup::size_of() const
{
  int ret_val = 2;
  if (field_priority.ispresent()) ret_val++;
  if (field_vGCS__FeatureFlags.ispresent()) ret_val++;
  return ret_val;
}

void PDU__BSSMAP__VGCS__VBSSetup::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", groupCallReference := ");
field_groupCallReference.log();
TTCN_Logger::log_event_str(", priority := ");
field_priority.log();
TTCN_Logger::log_event_str(", vGCS_FeatureFlags := ");
field_vGCS__FeatureFlags.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__VGCS__VBSSetup::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (groupCallReference().is_bound()) groupCallReference().set_implicit_omit();
if (!priority().is_bound()) priority() = OMIT_VALUE;
else priority().set_implicit_omit();
if (!vGCS__FeatureFlags().is_bound()) vGCS__FeatureFlags() = OMIT_VALUE;
else vGCS__FeatureFlags().set_implicit_omit();
}

void PDU__BSSMAP__VGCS__VBSSetup::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) groupCallReference().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) priority().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) vGCS__FeatureFlags().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "groupCallReference")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          groupCallReference().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "priority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          priority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vGCS_FeatureFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vGCS__FeatureFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup");
  }
}

void PDU__BSSMAP__VGCS__VBSSetup::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_groupCallReference.encode_text(text_buf);
field_priority.encode_text(text_buf);
field_vGCS__FeatureFlags.encode_text(text_buf);
}

void PDU__BSSMAP__VGCS__VBSSetup::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_groupCallReference.decode_text(text_buf);
field_priority.decode_text(text_buf);
field_vGCS__FeatureFlags.decode_text(text_buf);
}

void PDU__BSSMAP__VGCS__VBSSetup::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__VGCS__VBSSetup::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__VGCS__VBSSetup::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__GroupCallReference_descr_.raw->forceomit);
  decoded_field_length = field_groupCallReference.RAW_decode(BSSMAP__IE__GroupCallReference_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_priority = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, BSSMAP__IE__Priority_descr_.raw->forceomit);
  decoded_field_length = field_priority().RAW_decode(BSSMAP__IE__Priority_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_priority = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_priority=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_vGCS__FeatureFlags = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, BSSMAP__IE__VGCS__FeatureFlags_descr_.raw->forceomit);
  decoded_field_length = field_vGCS__FeatureFlags().RAW_decode(BSSMAP__IE__VGCS__FeatureFlags_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_vGCS__FeatureFlags = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_vGCS__FeatureFlags=OMIT_VALUE;
  if (field_messageType !=  os_33) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__VGCS__VBSSetup::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__GroupCallReference_descr_.raw);
  if (field_priority.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, BSSMAP__IE__Priority_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_vGCS__FeatureFlags.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, BSSMAP__IE__VGCS__FeatureFlags_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_groupCallReference.RAW_encode(BSSMAP__IE__GroupCallReference_descr_, *myleaf.body.node.nodes[1]);
  if (field_priority.ispresent()) {
  encoded_length += field_priority().RAW_encode(BSSMAP__IE__Priority_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_vGCS__FeatureFlags.ispresent()) {
  encoded_length += field_vGCS__FeatureFlags().RAW_encode(BSSMAP__IE__VGCS__FeatureFlags_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_messageType !=  os_33) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_33.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__VGCS__VBSSetup_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__GroupCallReference_template field_groupCallReference;
BSSMAP__IE__Priority_template field_priority;
BSSMAP__IE__VGCS__FeatureFlags_template field_vGCS__FeatureFlags;
};

void PDU__BSSMAP__VGCS__VBSSetup_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_groupCallReference = ANY_VALUE;
single_value->field_priority = ANY_OR_OMIT;
single_value->field_vGCS__FeatureFlags = ANY_OR_OMIT;
}
}
}

void PDU__BSSMAP__VGCS__VBSSetup_template::copy_value(const PDU__BSSMAP__VGCS__VBSSetup& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.groupCallReference().is_bound()) {
  single_value->field_groupCallReference = other_value.groupCallReference();
} else {
  single_value->field_groupCallReference.clean_up();
}
if (other_value.priority().is_bound()) {
  if (other_value.priority().ispresent()) single_value->field_priority = other_value.priority()();
  else single_value->field_priority = OMIT_VALUE;
} else {
  single_value->field_priority.clean_up();
}
if (other_value.vGCS__FeatureFlags().is_bound()) {
  if (other_value.vGCS__FeatureFlags().ispresent()) single_value->field_vGCS__FeatureFlags = other_value.vGCS__FeatureFlags()();
  else single_value->field_vGCS__FeatureFlags = OMIT_VALUE;
} else {
  single_value->field_vGCS__FeatureFlags.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__VGCS__VBSSetup_template::copy_template(const PDU__BSSMAP__VGCS__VBSSetup_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.groupCallReference().get_selection()) {
single_value->field_groupCallReference = other_value.groupCallReference();
} else {
single_value->field_groupCallReference.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.priority().get_selection()) {
single_value->field_priority = other_value.priority();
} else {
single_value->field_priority.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.vGCS__FeatureFlags().get_selection()) {
single_value->field_vGCS__FeatureFlags = other_value.vGCS__FeatureFlags();
} else {
single_value->field_vGCS__FeatureFlags.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__VGCS__VBSSetup_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__VGCS__VBSSetup_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__VGCS__VBSSetup_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__VGCS__VBSSetup_template::PDU__BSSMAP__VGCS__VBSSetup_template()
{
}

PDU__BSSMAP__VGCS__VBSSetup_template::PDU__BSSMAP__VGCS__VBSSetup_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__VGCS__VBSSetup_template::PDU__BSSMAP__VGCS__VBSSetup_template(const PDU__BSSMAP__VGCS__VBSSetup& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__VGCS__VBSSetup_template::PDU__BSSMAP__VGCS__VBSSetup_template(const OPTIONAL<PDU__BSSMAP__VGCS__VBSSetup>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__VGCS__VBSSetup&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup from an unbound optional field.");
}
}

PDU__BSSMAP__VGCS__VBSSetup_template::PDU__BSSMAP__VGCS__VBSSetup_template(PDU__BSSMAP__VGCS__VBSSetup_template* p_precondition, PDU__BSSMAP__VGCS__VBSSetup_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__VGCS__VBSSetup_template::PDU__BSSMAP__VGCS__VBSSetup_template(Dynamic_Match_Interface<PDU__BSSMAP__VGCS__VBSSetup>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__VGCS__VBSSetup>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__VGCS__VBSSetup_template::PDU__BSSMAP__VGCS__VBSSetup_template(const PDU__BSSMAP__VGCS__VBSSetup_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__VGCS__VBSSetup_template::~PDU__BSSMAP__VGCS__VBSSetup_template()
{
clean_up();
}

PDU__BSSMAP__VGCS__VBSSetup_template& PDU__BSSMAP__VGCS__VBSSetup_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__VGCS__VBSSetup_template& PDU__BSSMAP__VGCS__VBSSetup_template::operator=(const PDU__BSSMAP__VGCS__VBSSetup& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__VGCS__VBSSetup_template& PDU__BSSMAP__VGCS__VBSSetup_template::operator=(const OPTIONAL<PDU__BSSMAP__VGCS__VBSSetup>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__VGCS__VBSSetup&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup.");
}
return *this;
}

PDU__BSSMAP__VGCS__VBSSetup_template& PDU__BSSMAP__VGCS__VBSSetup_template::operator=(const PDU__BSSMAP__VGCS__VBSSetup_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__VGCS__VBSSetup_template::match(const PDU__BSSMAP__VGCS__VBSSetup& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.groupCallReference().is_bound()) return FALSE;
if(!single_value->field_groupCallReference.match(other_value.groupCallReference(), legacy))return FALSE;
if(!other_value.priority().is_bound()) return FALSE;
if((other_value.priority().ispresent() ? !single_value->field_priority.match((const BSSMAP__IE__Priority&)other_value.priority(), legacy) : !single_value->field_priority.match_omit(legacy)))return FALSE;
if(!other_value.vGCS__FeatureFlags().is_bound()) return FALSE;
if((other_value.vGCS__FeatureFlags().ispresent() ? !single_value->field_vGCS__FeatureFlags.match((const BSSMAP__IE__VGCS__FeatureFlags&)other_value.vGCS__FeatureFlags(), legacy) : !single_value->field_vGCS__FeatureFlags.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup.");
}
return FALSE;
}

boolean PDU__BSSMAP__VGCS__VBSSetup_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_groupCallReference.is_bound()
 || (single_value->field_priority.is_omit() || single_value->field_priority.is_bound())
 || (single_value->field_vGCS__FeatureFlags.is_omit() || single_value->field_vGCS__FeatureFlags.is_bound());
}

boolean PDU__BSSMAP__VGCS__VBSSetup_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_groupCallReference.is_value()
 && (single_value->field_priority.is_omit() || single_value->field_priority.is_value())
 && (single_value->field_vGCS__FeatureFlags.is_omit() || single_value->field_vGCS__FeatureFlags.is_value());
}

void PDU__BSSMAP__VGCS__VBSSetup_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__VGCS__VBSSetup PDU__BSSMAP__VGCS__VBSSetup_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup.");
PDU__BSSMAP__VGCS__VBSSetup ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_groupCallReference.is_bound()) {
ret_val.groupCallReference() = single_value->field_groupCallReference.valueof();
}
if (single_value->field_priority.is_omit()) ret_val.priority() = OMIT_VALUE;
else if (single_value->field_priority.is_bound()) {
ret_val.priority() = single_value->field_priority.valueof();
}
if (single_value->field_vGCS__FeatureFlags.is_omit()) ret_val.vGCS__FeatureFlags() = OMIT_VALUE;
else if (single_value->field_vGCS__FeatureFlags.is_bound()) {
ret_val.vGCS__FeatureFlags() = single_value->field_vGCS__FeatureFlags.valueof();
}
return ret_val;
}

void PDU__BSSMAP__VGCS__VBSSetup_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__VGCS__VBSSetup_template[list_length];
}

PDU__BSSMAP__VGCS__VBSSetup_template& PDU__BSSMAP__VGCS__VBSSetup_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__VGCS__VBSSetup_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__VGCS__VBSSetup_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup.");
return single_value->field_messageType;
}

BSSMAP__IE__GroupCallReference_template& PDU__BSSMAP__VGCS__VBSSetup_template::groupCallReference()
{
set_specific();
return single_value->field_groupCallReference;
}

const BSSMAP__IE__GroupCallReference_template& PDU__BSSMAP__VGCS__VBSSetup_template::groupCallReference() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field groupCallReference of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup.");
return single_value->field_groupCallReference;
}

BSSMAP__IE__Priority_template& PDU__BSSMAP__VGCS__VBSSetup_template::priority()
{
set_specific();
return single_value->field_priority;
}

const BSSMAP__IE__Priority_template& PDU__BSSMAP__VGCS__VBSSetup_template::priority() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field priority of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup.");
return single_value->field_priority;
}

BSSMAP__IE__VGCS__FeatureFlags_template& PDU__BSSMAP__VGCS__VBSSetup_template::vGCS__FeatureFlags()
{
set_specific();
return single_value->field_vGCS__FeatureFlags;
}

const BSSMAP__IE__VGCS__FeatureFlags_template& PDU__BSSMAP__VGCS__VBSSetup_template::vGCS__FeatureFlags() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field vGCS_FeatureFlags of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup.");
return single_value->field_vGCS__FeatureFlags;
}

int PDU__BSSMAP__VGCS__VBSSetup_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_priority.is_present()) ret_val++;
      if (single_value->field_vGCS__FeatureFlags.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup.");
  }
  return 0;
}

void PDU__BSSMAP__VGCS__VBSSetup_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", groupCallReference := ");
single_value->field_groupCallReference.log();
TTCN_Logger::log_event_str(", priority := ");
single_value->field_priority.log();
TTCN_Logger::log_event_str(", vGCS_FeatureFlags := ");
single_value->field_vGCS__FeatureFlags.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__VGCS__VBSSetup_template::log_match(const PDU__BSSMAP__VGCS__VBSSetup& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_groupCallReference.match(match_value.groupCallReference(), legacy)){
TTCN_Logger::log_logmatch_info(".groupCallReference");
single_value->field_groupCallReference.log_match(match_value.groupCallReference(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.priority().ispresent()){
if(!single_value->field_priority.match(match_value.priority(), legacy)){
TTCN_Logger::log_logmatch_info(".priority");
single_value->field_priority.log_match(match_value.priority(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_priority.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".priority := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_priority.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.vGCS__FeatureFlags().ispresent()){
if(!single_value->field_vGCS__FeatureFlags.match(match_value.vGCS__FeatureFlags(), legacy)){
TTCN_Logger::log_logmatch_info(".vGCS_FeatureFlags");
single_value->field_vGCS__FeatureFlags.log_match(match_value.vGCS__FeatureFlags(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_vGCS__FeatureFlags.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".vGCS_FeatureFlags := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_vGCS__FeatureFlags.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", groupCallReference := ");
single_value->field_groupCallReference.log_match(match_value.groupCallReference(), legacy);
TTCN_Logger::log_event_str(", priority := ");
if (match_value.priority().ispresent()) {
single_value->field_priority.log_match(match_value.priority(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_priority.log();
if (single_value->field_priority.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", vGCS_FeatureFlags := ");
if (match_value.vGCS__FeatureFlags().ispresent()) {
single_value->field_vGCS__FeatureFlags.log_match(match_value.vGCS__FeatureFlags(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_vGCS__FeatureFlags.log();
if (single_value->field_vGCS__FeatureFlags.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__VGCS__VBSSetup_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (groupCallReference().is_bound()) groupCallReference().set_implicit_omit();
if (!priority().is_bound()) priority() = OMIT_VALUE;
else priority().set_implicit_omit();
if (!vGCS__FeatureFlags().is_bound()) vGCS__FeatureFlags() = OMIT_VALUE;
else vGCS__FeatureFlags().set_implicit_omit();
}

void PDU__BSSMAP__VGCS__VBSSetup_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_groupCallReference.encode_text(text_buf);
single_value->field_priority.encode_text(text_buf);
single_value->field_vGCS__FeatureFlags.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup.");
}
}

void PDU__BSSMAP__VGCS__VBSSetup_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_groupCallReference.decode_text(text_buf);
single_value->field_priority.decode_text(text_buf);
single_value->field_vGCS__FeatureFlags.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__VGCS__VBSSetup_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup.");
}
}

void PDU__BSSMAP__VGCS__VBSSetup_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__VGCS__VBSSetup_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) groupCallReference().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) priority().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) vGCS__FeatureFlags().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "groupCallReference")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          groupCallReference().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "priority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          priority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vGCS_FeatureFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vGCS__FeatureFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__VGCS__VBSSetup_template* precondition = new PDU__BSSMAP__VGCS__VBSSetup_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__VGCS__VBSSetup_template* implied_template = new PDU__BSSMAP__VGCS__VBSSetup_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__VGCS__VBSSetup_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__VGCS__VBSSetup_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup");
single_value->field_groupCallReference.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup");
single_value->field_priority.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup");
single_value->field_vGCS__FeatureFlags.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetup");
}

boolean PDU__BSSMAP__VGCS__VBSSetup_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__VGCS__VBSSetup_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__VGCS__VBSSetupAck::PDU__BSSMAP__VGCS__VBSSetupAck()
{
}

PDU__BSSMAP__VGCS__VBSSetupAck::PDU__BSSMAP__VGCS__VBSSetupAck(const OCTETSTRING& par_messageType,
    const OPTIONAL< BSSMAP__IE__VGCS__FeatureFlags >& par_vGCS__FeatureFlags)
  :   field_messageType(par_messageType),
  field_vGCS__FeatureFlags(par_vGCS__FeatureFlags)
{
}

PDU__BSSMAP__VGCS__VBSSetupAck::PDU__BSSMAP__VGCS__VBSSetupAck(const PDU__BSSMAP__VGCS__VBSSetupAck& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.vGCS__FeatureFlags().is_bound()) field_vGCS__FeatureFlags = other_value.vGCS__FeatureFlags();
else field_vGCS__FeatureFlags.clean_up();
}

void PDU__BSSMAP__VGCS__VBSSetupAck::clean_up()
{
field_messageType.clean_up();
field_vGCS__FeatureFlags.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__VGCS__VBSSetupAck::get_descriptor() const { return &PDU__BSSMAP__VGCS__VBSSetupAck_descr_; }
PDU__BSSMAP__VGCS__VBSSetupAck& PDU__BSSMAP__VGCS__VBSSetupAck::operator=(const PDU__BSSMAP__VGCS__VBSSetupAck& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.vGCS__FeatureFlags().is_bound()) field_vGCS__FeatureFlags = other_value.vGCS__FeatureFlags();
  else field_vGCS__FeatureFlags.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__VGCS__VBSSetupAck::operator==(const PDU__BSSMAP__VGCS__VBSSetupAck& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_vGCS__FeatureFlags==other_value.field_vGCS__FeatureFlags;
}

boolean PDU__BSSMAP__VGCS__VBSSetupAck::is_bound() const
{
return (field_messageType.is_bound())
  || (OPTIONAL_OMIT == field_vGCS__FeatureFlags.get_selection() || field_vGCS__FeatureFlags.is_bound());
}
boolean PDU__BSSMAP__VGCS__VBSSetupAck::is_value() const
{
return field_messageType.is_value()
  && (OPTIONAL_OMIT == field_vGCS__FeatureFlags.get_selection() || field_vGCS__FeatureFlags.is_value());
}
int PDU__BSSMAP__VGCS__VBSSetupAck::size_of() const
{
  int ret_val = 1;
  if (field_vGCS__FeatureFlags.ispresent()) ret_val++;
  return ret_val;
}

void PDU__BSSMAP__VGCS__VBSSetupAck::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", vGCS_FeatureFlags := ");
field_vGCS__FeatureFlags.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__VGCS__VBSSetupAck::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (!vGCS__FeatureFlags().is_bound()) vGCS__FeatureFlags() = OMIT_VALUE;
else vGCS__FeatureFlags().set_implicit_omit();
}

void PDU__BSSMAP__VGCS__VBSSetupAck::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) vGCS__FeatureFlags().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vGCS_FeatureFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vGCS__FeatureFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck");
  }
}

void PDU__BSSMAP__VGCS__VBSSetupAck::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_vGCS__FeatureFlags.encode_text(text_buf);
}

void PDU__BSSMAP__VGCS__VBSSetupAck::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_vGCS__FeatureFlags.decode_text(text_buf);
}

void PDU__BSSMAP__VGCS__VBSSetupAck::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__VGCS__VBSSetupAck::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__VGCS__VBSSetupAck::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_vGCS__FeatureFlags = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__VGCS__FeatureFlags_descr_.raw->forceomit);
  decoded_field_length = field_vGCS__FeatureFlags().RAW_decode(BSSMAP__IE__VGCS__FeatureFlags_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_vGCS__FeatureFlags = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_vGCS__FeatureFlags=OMIT_VALUE;
  if (field_messageType !=  os_24) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__VGCS__VBSSetupAck::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  if (field_vGCS__FeatureFlags.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__VGCS__FeatureFlags_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  if (field_vGCS__FeatureFlags.ispresent()) {
  encoded_length += field_vGCS__FeatureFlags().RAW_encode(BSSMAP__IE__VGCS__FeatureFlags_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_messageType !=  os_24) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_24.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__VGCS__VBSSetupAck_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__VGCS__FeatureFlags_template field_vGCS__FeatureFlags;
};

void PDU__BSSMAP__VGCS__VBSSetupAck_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_vGCS__FeatureFlags = ANY_OR_OMIT;
}
}
}

void PDU__BSSMAP__VGCS__VBSSetupAck_template::copy_value(const PDU__BSSMAP__VGCS__VBSSetupAck& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.vGCS__FeatureFlags().is_bound()) {
  if (other_value.vGCS__FeatureFlags().ispresent()) single_value->field_vGCS__FeatureFlags = other_value.vGCS__FeatureFlags()();
  else single_value->field_vGCS__FeatureFlags = OMIT_VALUE;
} else {
  single_value->field_vGCS__FeatureFlags.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__VGCS__VBSSetupAck_template::copy_template(const PDU__BSSMAP__VGCS__VBSSetupAck_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.vGCS__FeatureFlags().get_selection()) {
single_value->field_vGCS__FeatureFlags = other_value.vGCS__FeatureFlags();
} else {
single_value->field_vGCS__FeatureFlags.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__VGCS__VBSSetupAck_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__VGCS__VBSSetupAck_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__VGCS__VBSSetupAck_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__VGCS__VBSSetupAck_template::PDU__BSSMAP__VGCS__VBSSetupAck_template()
{
}

PDU__BSSMAP__VGCS__VBSSetupAck_template::PDU__BSSMAP__VGCS__VBSSetupAck_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__VGCS__VBSSetupAck_template::PDU__BSSMAP__VGCS__VBSSetupAck_template(const PDU__BSSMAP__VGCS__VBSSetupAck& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__VGCS__VBSSetupAck_template::PDU__BSSMAP__VGCS__VBSSetupAck_template(const OPTIONAL<PDU__BSSMAP__VGCS__VBSSetupAck>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__VGCS__VBSSetupAck&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck from an unbound optional field.");
}
}

PDU__BSSMAP__VGCS__VBSSetupAck_template::PDU__BSSMAP__VGCS__VBSSetupAck_template(PDU__BSSMAP__VGCS__VBSSetupAck_template* p_precondition, PDU__BSSMAP__VGCS__VBSSetupAck_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__VGCS__VBSSetupAck_template::PDU__BSSMAP__VGCS__VBSSetupAck_template(Dynamic_Match_Interface<PDU__BSSMAP__VGCS__VBSSetupAck>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__VGCS__VBSSetupAck>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__VGCS__VBSSetupAck_template::PDU__BSSMAP__VGCS__VBSSetupAck_template(const PDU__BSSMAP__VGCS__VBSSetupAck_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__VGCS__VBSSetupAck_template::~PDU__BSSMAP__VGCS__VBSSetupAck_template()
{
clean_up();
}

PDU__BSSMAP__VGCS__VBSSetupAck_template& PDU__BSSMAP__VGCS__VBSSetupAck_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__VGCS__VBSSetupAck_template& PDU__BSSMAP__VGCS__VBSSetupAck_template::operator=(const PDU__BSSMAP__VGCS__VBSSetupAck& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__VGCS__VBSSetupAck_template& PDU__BSSMAP__VGCS__VBSSetupAck_template::operator=(const OPTIONAL<PDU__BSSMAP__VGCS__VBSSetupAck>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__VGCS__VBSSetupAck&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck.");
}
return *this;
}

PDU__BSSMAP__VGCS__VBSSetupAck_template& PDU__BSSMAP__VGCS__VBSSetupAck_template::operator=(const PDU__BSSMAP__VGCS__VBSSetupAck_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__VGCS__VBSSetupAck_template::match(const PDU__BSSMAP__VGCS__VBSSetupAck& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.vGCS__FeatureFlags().is_bound()) return FALSE;
if((other_value.vGCS__FeatureFlags().ispresent() ? !single_value->field_vGCS__FeatureFlags.match((const BSSMAP__IE__VGCS__FeatureFlags&)other_value.vGCS__FeatureFlags(), legacy) : !single_value->field_vGCS__FeatureFlags.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck.");
}
return FALSE;
}

boolean PDU__BSSMAP__VGCS__VBSSetupAck_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || (single_value->field_vGCS__FeatureFlags.is_omit() || single_value->field_vGCS__FeatureFlags.is_bound());
}

boolean PDU__BSSMAP__VGCS__VBSSetupAck_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && (single_value->field_vGCS__FeatureFlags.is_omit() || single_value->field_vGCS__FeatureFlags.is_value());
}

void PDU__BSSMAP__VGCS__VBSSetupAck_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__VGCS__VBSSetupAck PDU__BSSMAP__VGCS__VBSSetupAck_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck.");
PDU__BSSMAP__VGCS__VBSSetupAck ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_vGCS__FeatureFlags.is_omit()) ret_val.vGCS__FeatureFlags() = OMIT_VALUE;
else if (single_value->field_vGCS__FeatureFlags.is_bound()) {
ret_val.vGCS__FeatureFlags() = single_value->field_vGCS__FeatureFlags.valueof();
}
return ret_val;
}

void PDU__BSSMAP__VGCS__VBSSetupAck_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__VGCS__VBSSetupAck_template[list_length];
}

PDU__BSSMAP__VGCS__VBSSetupAck_template& PDU__BSSMAP__VGCS__VBSSetupAck_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__VGCS__VBSSetupAck_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__VGCS__VBSSetupAck_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck.");
return single_value->field_messageType;
}

BSSMAP__IE__VGCS__FeatureFlags_template& PDU__BSSMAP__VGCS__VBSSetupAck_template::vGCS__FeatureFlags()
{
set_specific();
return single_value->field_vGCS__FeatureFlags;
}

const BSSMAP__IE__VGCS__FeatureFlags_template& PDU__BSSMAP__VGCS__VBSSetupAck_template::vGCS__FeatureFlags() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field vGCS_FeatureFlags of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck.");
return single_value->field_vGCS__FeatureFlags;
}

int PDU__BSSMAP__VGCS__VBSSetupAck_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_vGCS__FeatureFlags.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck.");
  }
  return 0;
}

void PDU__BSSMAP__VGCS__VBSSetupAck_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", vGCS_FeatureFlags := ");
single_value->field_vGCS__FeatureFlags.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__VGCS__VBSSetupAck_template::log_match(const PDU__BSSMAP__VGCS__VBSSetupAck& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.vGCS__FeatureFlags().ispresent()){
if(!single_value->field_vGCS__FeatureFlags.match(match_value.vGCS__FeatureFlags(), legacy)){
TTCN_Logger::log_logmatch_info(".vGCS_FeatureFlags");
single_value->field_vGCS__FeatureFlags.log_match(match_value.vGCS__FeatureFlags(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_vGCS__FeatureFlags.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".vGCS_FeatureFlags := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_vGCS__FeatureFlags.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", vGCS_FeatureFlags := ");
if (match_value.vGCS__FeatureFlags().ispresent()) {
single_value->field_vGCS__FeatureFlags.log_match(match_value.vGCS__FeatureFlags(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_vGCS__FeatureFlags.log();
if (single_value->field_vGCS__FeatureFlags.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__VGCS__VBSSetupAck_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (!vGCS__FeatureFlags().is_bound()) vGCS__FeatureFlags() = OMIT_VALUE;
else vGCS__FeatureFlags().set_implicit_omit();
}

void PDU__BSSMAP__VGCS__VBSSetupAck_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_vGCS__FeatureFlags.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck.");
}
}

void PDU__BSSMAP__VGCS__VBSSetupAck_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_vGCS__FeatureFlags.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__VGCS__VBSSetupAck_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck.");
}
}

void PDU__BSSMAP__VGCS__VBSSetupAck_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__VGCS__VBSSetupAck_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) vGCS__FeatureFlags().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vGCS_FeatureFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vGCS__FeatureFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__VGCS__VBSSetupAck_template* precondition = new PDU__BSSMAP__VGCS__VBSSetupAck_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__VGCS__VBSSetupAck_template* implied_template = new PDU__BSSMAP__VGCS__VBSSetupAck_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__VGCS__VBSSetupAck_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__VGCS__VBSSetupAck_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck");
single_value->field_vGCS__FeatureFlags.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupAck");
}

boolean PDU__BSSMAP__VGCS__VBSSetupAck_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__VGCS__VBSSetupAck_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__VGCS__VBSSetupRefuse::PDU__BSSMAP__VGCS__VBSSetupRefuse()
{
}

PDU__BSSMAP__VGCS__VBSSetupRefuse::PDU__BSSMAP__VGCS__VBSSetupRefuse(const OCTETSTRING& par_messageType,
    const BSSMAP__IE__Cause& par_cause)
  :   field_messageType(par_messageType),
  field_cause(par_cause)
{
}

PDU__BSSMAP__VGCS__VBSSetupRefuse::PDU__BSSMAP__VGCS__VBSSetupRefuse(const PDU__BSSMAP__VGCS__VBSSetupRefuse& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.cause().is_bound()) field_cause = other_value.cause();
else field_cause.clean_up();
}

void PDU__BSSMAP__VGCS__VBSSetupRefuse::clean_up()
{
field_messageType.clean_up();
field_cause.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__VGCS__VBSSetupRefuse::get_descriptor() const { return &PDU__BSSMAP__VGCS__VBSSetupRefuse_descr_; }
PDU__BSSMAP__VGCS__VBSSetupRefuse& PDU__BSSMAP__VGCS__VBSSetupRefuse::operator=(const PDU__BSSMAP__VGCS__VBSSetupRefuse& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.cause().is_bound()) field_cause = other_value.cause();
  else field_cause.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__VGCS__VBSSetupRefuse::operator==(const PDU__BSSMAP__VGCS__VBSSetupRefuse& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_cause==other_value.field_cause;
}

boolean PDU__BSSMAP__VGCS__VBSSetupRefuse::is_bound() const
{
return (field_messageType.is_bound())
  || (field_cause.is_bound());
}
boolean PDU__BSSMAP__VGCS__VBSSetupRefuse::is_value() const
{
return field_messageType.is_value()
  && field_cause.is_value();
}
void PDU__BSSMAP__VGCS__VBSSetupRefuse::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", cause := ");
field_cause.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__VGCS__VBSSetupRefuse::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (cause().is_bound()) cause().set_implicit_omit();
}

void PDU__BSSMAP__VGCS__VBSSetupRefuse::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse");
  }
}

void PDU__BSSMAP__VGCS__VBSSetupRefuse::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_cause.encode_text(text_buf);
}

void PDU__BSSMAP__VGCS__VBSSetupRefuse::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_cause.decode_text(text_buf);
}

void PDU__BSSMAP__VGCS__VBSSetupRefuse::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__VGCS__VBSSetupRefuse::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__VGCS__VBSSetupRefuse::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__Cause_descr_.raw->forceomit);
  decoded_field_length = field_cause.RAW_decode(BSSMAP__IE__Cause_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_messageType !=  os_1) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__VGCS__VBSSetupRefuse::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__Cause_descr_.raw);
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_cause.RAW_encode(BSSMAP__IE__Cause_descr_, *myleaf.body.node.nodes[1]);
  if (field_messageType !=  os_1) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_1.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__VGCS__VBSSetupRefuse_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__Cause_template field_cause;
};

void PDU__BSSMAP__VGCS__VBSSetupRefuse_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_cause = ANY_VALUE;
}
}
}

void PDU__BSSMAP__VGCS__VBSSetupRefuse_template::copy_value(const PDU__BSSMAP__VGCS__VBSSetupRefuse& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.cause().is_bound()) {
  single_value->field_cause = other_value.cause();
} else {
  single_value->field_cause.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__VGCS__VBSSetupRefuse_template::copy_template(const PDU__BSSMAP__VGCS__VBSSetupRefuse_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cause().get_selection()) {
single_value->field_cause = other_value.cause();
} else {
single_value->field_cause.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__VGCS__VBSSetupRefuse_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__VGCS__VBSSetupRefuse_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__VGCS__VBSSetupRefuse_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__VGCS__VBSSetupRefuse_template::PDU__BSSMAP__VGCS__VBSSetupRefuse_template()
{
}

PDU__BSSMAP__VGCS__VBSSetupRefuse_template::PDU__BSSMAP__VGCS__VBSSetupRefuse_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__VGCS__VBSSetupRefuse_template::PDU__BSSMAP__VGCS__VBSSetupRefuse_template(const PDU__BSSMAP__VGCS__VBSSetupRefuse& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__VGCS__VBSSetupRefuse_template::PDU__BSSMAP__VGCS__VBSSetupRefuse_template(const OPTIONAL<PDU__BSSMAP__VGCS__VBSSetupRefuse>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__VGCS__VBSSetupRefuse&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse from an unbound optional field.");
}
}

PDU__BSSMAP__VGCS__VBSSetupRefuse_template::PDU__BSSMAP__VGCS__VBSSetupRefuse_template(PDU__BSSMAP__VGCS__VBSSetupRefuse_template* p_precondition, PDU__BSSMAP__VGCS__VBSSetupRefuse_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__VGCS__VBSSetupRefuse_template::PDU__BSSMAP__VGCS__VBSSetupRefuse_template(Dynamic_Match_Interface<PDU__BSSMAP__VGCS__VBSSetupRefuse>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__VGCS__VBSSetupRefuse>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__VGCS__VBSSetupRefuse_template::PDU__BSSMAP__VGCS__VBSSetupRefuse_template(const PDU__BSSMAP__VGCS__VBSSetupRefuse_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__VGCS__VBSSetupRefuse_template::~PDU__BSSMAP__VGCS__VBSSetupRefuse_template()
{
clean_up();
}

PDU__BSSMAP__VGCS__VBSSetupRefuse_template& PDU__BSSMAP__VGCS__VBSSetupRefuse_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__VGCS__VBSSetupRefuse_template& PDU__BSSMAP__VGCS__VBSSetupRefuse_template::operator=(const PDU__BSSMAP__VGCS__VBSSetupRefuse& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__VGCS__VBSSetupRefuse_template& PDU__BSSMAP__VGCS__VBSSetupRefuse_template::operator=(const OPTIONAL<PDU__BSSMAP__VGCS__VBSSetupRefuse>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__VGCS__VBSSetupRefuse&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse.");
}
return *this;
}

PDU__BSSMAP__VGCS__VBSSetupRefuse_template& PDU__BSSMAP__VGCS__VBSSetupRefuse_template::operator=(const PDU__BSSMAP__VGCS__VBSSetupRefuse_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__VGCS__VBSSetupRefuse_template::match(const PDU__BSSMAP__VGCS__VBSSetupRefuse& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.cause().is_bound()) return FALSE;
if(!single_value->field_cause.match(other_value.cause(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse.");
}
return FALSE;
}

boolean PDU__BSSMAP__VGCS__VBSSetupRefuse_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_cause.is_bound();
}

boolean PDU__BSSMAP__VGCS__VBSSetupRefuse_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_cause.is_value();
}

void PDU__BSSMAP__VGCS__VBSSetupRefuse_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__VGCS__VBSSetupRefuse PDU__BSSMAP__VGCS__VBSSetupRefuse_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse.");
PDU__BSSMAP__VGCS__VBSSetupRefuse ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_cause.is_bound()) {
ret_val.cause() = single_value->field_cause.valueof();
}
return ret_val;
}

void PDU__BSSMAP__VGCS__VBSSetupRefuse_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__VGCS__VBSSetupRefuse_template[list_length];
}

PDU__BSSMAP__VGCS__VBSSetupRefuse_template& PDU__BSSMAP__VGCS__VBSSetupRefuse_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__VGCS__VBSSetupRefuse_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__VGCS__VBSSetupRefuse_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse.");
return single_value->field_messageType;
}

BSSMAP__IE__Cause_template& PDU__BSSMAP__VGCS__VBSSetupRefuse_template::cause()
{
set_specific();
return single_value->field_cause;
}

const BSSMAP__IE__Cause_template& PDU__BSSMAP__VGCS__VBSSetupRefuse_template::cause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cause of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse.");
return single_value->field_cause;
}

int PDU__BSSMAP__VGCS__VBSSetupRefuse_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse.");
  }
  return 0;
}

void PDU__BSSMAP__VGCS__VBSSetupRefuse_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__VGCS__VBSSetupRefuse_template::log_match(const PDU__BSSMAP__VGCS__VBSSetupRefuse& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cause.match(match_value.cause(), legacy)){
TTCN_Logger::log_logmatch_info(".cause");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__VGCS__VBSSetupRefuse_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (cause().is_bound()) cause().set_implicit_omit();
}

void PDU__BSSMAP__VGCS__VBSSetupRefuse_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_cause.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse.");
}
}

void PDU__BSSMAP__VGCS__VBSSetupRefuse_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_cause.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__VGCS__VBSSetupRefuse_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse.");
}
}

void PDU__BSSMAP__VGCS__VBSSetupRefuse_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__VGCS__VBSSetupRefuse_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__VGCS__VBSSetupRefuse_template* precondition = new PDU__BSSMAP__VGCS__VBSSetupRefuse_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__VGCS__VBSSetupRefuse_template* implied_template = new PDU__BSSMAP__VGCS__VBSSetupRefuse_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__VGCS__VBSSetupRefuse_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__VGCS__VBSSetupRefuse_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse");
single_value->field_cause.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSSetupRefuse");
}

boolean PDU__BSSMAP__VGCS__VBSSetupRefuse_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__VGCS__VBSSetupRefuse_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__VGCS__VBSAssignmentRequest::PDU__BSSMAP__VGCS__VBSAssignmentRequest()
{
}

PDU__BSSMAP__VGCS__VBSAssignmentRequest::PDU__BSSMAP__VGCS__VBSAssignmentRequest(const OCTETSTRING& par_messageType,
    const BSSMAP__IE__ChannelType& par_channelType,
    const BSSMAP__IE__AssignmentRequirement& par_assignmentRequirement,
    const BSSMAP__IE__CellIdentifier& par_cellIdentifier,
    const BSSMAP__IE__GroupCallReference& par_groupCallReference,
    const OPTIONAL< BSSMAP__IE__Priority >& par_priority,
    const OPTIONAL< BSSMAP__IE__CircuitIdentityCode >& par_circuitIdentityCode,
    const OPTIONAL< BSSMAP__IE__DownLinkDTXFlag >& par_downLinkDTX__Flag,
    const OPTIONAL< BSSMAP__IE__EncryptionInformation >& par_encryptionInformation,
    const OPTIONAL< BSSMAP__IE__VSTK__RAND >& par_vSTK__RAND,
    const OPTIONAL< BSSMAP__IE__VSTK >& par_vSTK,
    const OPTIONAL< BSSMAP__IE__CellIdentifierListSegment >& par_cellIdentifierListSegment,
    const OPTIONAL< BSSMAP__IE__AoIP__TransportLayerAddress >& par_aoIPTransportLayer,
    const OPTIONAL< BSSMAP__IE__CallIdentifier >& par_callIdentifier,
    const OPTIONAL< BSSMAP__IE__SpeechCodecList >& par_codecList)
  :   field_messageType(par_messageType),
  field_channelType(par_channelType),
  field_assignmentRequirement(par_assignmentRequirement),
  field_cellIdentifier(par_cellIdentifier),
  field_groupCallReference(par_groupCallReference),
  field_priority(par_priority),
  field_circuitIdentityCode(par_circuitIdentityCode),
  field_downLinkDTX__Flag(par_downLinkDTX__Flag),
  field_encryptionInformation(par_encryptionInformation),
  field_vSTK__RAND(par_vSTK__RAND),
  field_vSTK(par_vSTK),
  field_cellIdentifierListSegment(par_cellIdentifierListSegment),
  field_aoIPTransportLayer(par_aoIPTransportLayer),
  field_callIdentifier(par_callIdentifier),
  field_codecList(par_codecList)
{
}

PDU__BSSMAP__VGCS__VBSAssignmentRequest::PDU__BSSMAP__VGCS__VBSAssignmentRequest(const PDU__BSSMAP__VGCS__VBSAssignmentRequest& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.channelType().is_bound()) field_channelType = other_value.channelType();
else field_channelType.clean_up();
if (other_value.assignmentRequirement().is_bound()) field_assignmentRequirement = other_value.assignmentRequirement();
else field_assignmentRequirement.clean_up();
if (other_value.cellIdentifier().is_bound()) field_cellIdentifier = other_value.cellIdentifier();
else field_cellIdentifier.clean_up();
if (other_value.groupCallReference().is_bound()) field_groupCallReference = other_value.groupCallReference();
else field_groupCallReference.clean_up();
if (other_value.priority().is_bound()) field_priority = other_value.priority();
else field_priority.clean_up();
if (other_value.circuitIdentityCode().is_bound()) field_circuitIdentityCode = other_value.circuitIdentityCode();
else field_circuitIdentityCode.clean_up();
if (other_value.downLinkDTX__Flag().is_bound()) field_downLinkDTX__Flag = other_value.downLinkDTX__Flag();
else field_downLinkDTX__Flag.clean_up();
if (other_value.encryptionInformation().is_bound()) field_encryptionInformation = other_value.encryptionInformation();
else field_encryptionInformation.clean_up();
if (other_value.vSTK__RAND().is_bound()) field_vSTK__RAND = other_value.vSTK__RAND();
else field_vSTK__RAND.clean_up();
if (other_value.vSTK().is_bound()) field_vSTK = other_value.vSTK();
else field_vSTK.clean_up();
if (other_value.cellIdentifierListSegment().is_bound()) field_cellIdentifierListSegment = other_value.cellIdentifierListSegment();
else field_cellIdentifierListSegment.clean_up();
if (other_value.aoIPTransportLayer().is_bound()) field_aoIPTransportLayer = other_value.aoIPTransportLayer();
else field_aoIPTransportLayer.clean_up();
if (other_value.callIdentifier().is_bound()) field_callIdentifier = other_value.callIdentifier();
else field_callIdentifier.clean_up();
if (other_value.codecList().is_bound()) field_codecList = other_value.codecList();
else field_codecList.clean_up();
}

void PDU__BSSMAP__VGCS__VBSAssignmentRequest::clean_up()
{
field_messageType.clean_up();
field_channelType.clean_up();
field_assignmentRequirement.clean_up();
field_cellIdentifier.clean_up();
field_groupCallReference.clean_up();
field_priority.clean_up();
field_circuitIdentityCode.clean_up();
field_downLinkDTX__Flag.clean_up();
field_encryptionInformation.clean_up();
field_vSTK__RAND.clean_up();
field_vSTK.clean_up();
field_cellIdentifierListSegment.clean_up();
field_aoIPTransportLayer.clean_up();
field_callIdentifier.clean_up();
field_codecList.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__VGCS__VBSAssignmentRequest::get_descriptor() const { return &PDU__BSSMAP__VGCS__VBSAssignmentRequest_descr_; }
PDU__BSSMAP__VGCS__VBSAssignmentRequest& PDU__BSSMAP__VGCS__VBSAssignmentRequest::operator=(const PDU__BSSMAP__VGCS__VBSAssignmentRequest& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.channelType().is_bound()) field_channelType = other_value.channelType();
  else field_channelType.clean_up();
  if (other_value.assignmentRequirement().is_bound()) field_assignmentRequirement = other_value.assignmentRequirement();
  else field_assignmentRequirement.clean_up();
  if (other_value.cellIdentifier().is_bound()) field_cellIdentifier = other_value.cellIdentifier();
  else field_cellIdentifier.clean_up();
  if (other_value.groupCallReference().is_bound()) field_groupCallReference = other_value.groupCallReference();
  else field_groupCallReference.clean_up();
  if (other_value.priority().is_bound()) field_priority = other_value.priority();
  else field_priority.clean_up();
  if (other_value.circuitIdentityCode().is_bound()) field_circuitIdentityCode = other_value.circuitIdentityCode();
  else field_circuitIdentityCode.clean_up();
  if (other_value.downLinkDTX__Flag().is_bound()) field_downLinkDTX__Flag = other_value.downLinkDTX__Flag();
  else field_downLinkDTX__Flag.clean_up();
  if (other_value.encryptionInformation().is_bound()) field_encryptionInformation = other_value.encryptionInformation();
  else field_encryptionInformation.clean_up();
  if (other_value.vSTK__RAND().is_bound()) field_vSTK__RAND = other_value.vSTK__RAND();
  else field_vSTK__RAND.clean_up();
  if (other_value.vSTK().is_bound()) field_vSTK = other_value.vSTK();
  else field_vSTK.clean_up();
  if (other_value.cellIdentifierListSegment().is_bound()) field_cellIdentifierListSegment = other_value.cellIdentifierListSegment();
  else field_cellIdentifierListSegment.clean_up();
  if (other_value.aoIPTransportLayer().is_bound()) field_aoIPTransportLayer = other_value.aoIPTransportLayer();
  else field_aoIPTransportLayer.clean_up();
  if (other_value.callIdentifier().is_bound()) field_callIdentifier = other_value.callIdentifier();
  else field_callIdentifier.clean_up();
  if (other_value.codecList().is_bound()) field_codecList = other_value.codecList();
  else field_codecList.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__VGCS__VBSAssignmentRequest::operator==(const PDU__BSSMAP__VGCS__VBSAssignmentRequest& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_channelType==other_value.field_channelType
  && field_assignmentRequirement==other_value.field_assignmentRequirement
  && field_cellIdentifier==other_value.field_cellIdentifier
  && field_groupCallReference==other_value.field_groupCallReference
  && field_priority==other_value.field_priority
  && field_circuitIdentityCode==other_value.field_circuitIdentityCode
  && field_downLinkDTX__Flag==other_value.field_downLinkDTX__Flag
  && field_encryptionInformation==other_value.field_encryptionInformation
  && field_vSTK__RAND==other_value.field_vSTK__RAND
  && field_vSTK==other_value.field_vSTK
  && field_cellIdentifierListSegment==other_value.field_cellIdentifierListSegment
  && field_aoIPTransportLayer==other_value.field_aoIPTransportLayer
  && field_callIdentifier==other_value.field_callIdentifier
  && field_codecList==other_value.field_codecList;
}

boolean PDU__BSSMAP__VGCS__VBSAssignmentRequest::is_bound() const
{
return (field_messageType.is_bound())
  || (field_channelType.is_bound())
  || (field_assignmentRequirement.is_bound())
  || (field_cellIdentifier.is_bound())
  || (field_groupCallReference.is_bound())
  || (OPTIONAL_OMIT == field_priority.get_selection() || field_priority.is_bound())
  || (OPTIONAL_OMIT == field_circuitIdentityCode.get_selection() || field_circuitIdentityCode.is_bound())
  || (OPTIONAL_OMIT == field_downLinkDTX__Flag.get_selection() || field_downLinkDTX__Flag.is_bound())
  || (OPTIONAL_OMIT == field_encryptionInformation.get_selection() || field_encryptionInformation.is_bound())
  || (OPTIONAL_OMIT == field_vSTK__RAND.get_selection() || field_vSTK__RAND.is_bound())
  || (OPTIONAL_OMIT == field_vSTK.get_selection() || field_vSTK.is_bound())
  || (OPTIONAL_OMIT == field_cellIdentifierListSegment.get_selection() || field_cellIdentifierListSegment.is_bound())
  || (OPTIONAL_OMIT == field_aoIPTransportLayer.get_selection() || field_aoIPTransportLayer.is_bound())
  || (OPTIONAL_OMIT == field_callIdentifier.get_selection() || field_callIdentifier.is_bound())
  || (OPTIONAL_OMIT == field_codecList.get_selection() || field_codecList.is_bound());
}
boolean PDU__BSSMAP__VGCS__VBSAssignmentRequest::is_value() const
{
return field_messageType.is_value()
  && field_channelType.is_value()
  && field_assignmentRequirement.is_value()
  && field_cellIdentifier.is_value()
  && field_groupCallReference.is_value()
  && (OPTIONAL_OMIT == field_priority.get_selection() || field_priority.is_value())
  && (OPTIONAL_OMIT == field_circuitIdentityCode.get_selection() || field_circuitIdentityCode.is_value())
  && (OPTIONAL_OMIT == field_downLinkDTX__Flag.get_selection() || field_downLinkDTX__Flag.is_value())
  && (OPTIONAL_OMIT == field_encryptionInformation.get_selection() || field_encryptionInformation.is_value())
  && (OPTIONAL_OMIT == field_vSTK__RAND.get_selection() || field_vSTK__RAND.is_value())
  && (OPTIONAL_OMIT == field_vSTK.get_selection() || field_vSTK.is_value())
  && (OPTIONAL_OMIT == field_cellIdentifierListSegment.get_selection() || field_cellIdentifierListSegment.is_value())
  && (OPTIONAL_OMIT == field_aoIPTransportLayer.get_selection() || field_aoIPTransportLayer.is_value())
  && (OPTIONAL_OMIT == field_callIdentifier.get_selection() || field_callIdentifier.is_value())
  && (OPTIONAL_OMIT == field_codecList.get_selection() || field_codecList.is_value());
}
int PDU__BSSMAP__VGCS__VBSAssignmentRequest::size_of() const
{
  int ret_val = 5;
  if (field_priority.ispresent()) ret_val++;
  if (field_circuitIdentityCode.ispresent()) ret_val++;
  if (field_downLinkDTX__Flag.ispresent()) ret_val++;
  if (field_encryptionInformation.ispresent()) ret_val++;
  if (field_vSTK__RAND.ispresent()) ret_val++;
  if (field_vSTK.ispresent()) ret_val++;
  if (field_cellIdentifierListSegment.ispresent()) ret_val++;
  if (field_aoIPTransportLayer.ispresent()) ret_val++;
  if (field_callIdentifier.ispresent()) ret_val++;
  if (field_codecList.ispresent()) ret_val++;
  return ret_val;
}

void PDU__BSSMAP__VGCS__VBSAssignmentRequest::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", channelType := ");
field_channelType.log();
TTCN_Logger::log_event_str(", assignmentRequirement := ");
field_assignmentRequirement.log();
TTCN_Logger::log_event_str(", cellIdentifier := ");
field_cellIdentifier.log();
TTCN_Logger::log_event_str(", groupCallReference := ");
field_groupCallReference.log();
TTCN_Logger::log_event_str(", priority := ");
field_priority.log();
TTCN_Logger::log_event_str(", circuitIdentityCode := ");
field_circuitIdentityCode.log();
TTCN_Logger::log_event_str(", downLinkDTX_Flag := ");
field_downLinkDTX__Flag.log();
TTCN_Logger::log_event_str(", encryptionInformation := ");
field_encryptionInformation.log();
TTCN_Logger::log_event_str(", vSTK_RAND := ");
field_vSTK__RAND.log();
TTCN_Logger::log_event_str(", vSTK := ");
field_vSTK.log();
TTCN_Logger::log_event_str(", cellIdentifierListSegment := ");
field_cellIdentifierListSegment.log();
TTCN_Logger::log_event_str(", aoIPTransportLayer := ");
field_aoIPTransportLayer.log();
TTCN_Logger::log_event_str(", callIdentifier := ");
field_callIdentifier.log();
TTCN_Logger::log_event_str(", codecList := ");
field_codecList.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__VGCS__VBSAssignmentRequest::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (channelType().is_bound()) channelType().set_implicit_omit();
if (assignmentRequirement().is_bound()) assignmentRequirement().set_implicit_omit();
if (cellIdentifier().is_bound()) cellIdentifier().set_implicit_omit();
if (groupCallReference().is_bound()) groupCallReference().set_implicit_omit();
if (!priority().is_bound()) priority() = OMIT_VALUE;
else priority().set_implicit_omit();
if (!circuitIdentityCode().is_bound()) circuitIdentityCode() = OMIT_VALUE;
else circuitIdentityCode().set_implicit_omit();
if (!downLinkDTX__Flag().is_bound()) downLinkDTX__Flag() = OMIT_VALUE;
else downLinkDTX__Flag().set_implicit_omit();
if (!encryptionInformation().is_bound()) encryptionInformation() = OMIT_VALUE;
else encryptionInformation().set_implicit_omit();
if (!vSTK__RAND().is_bound()) vSTK__RAND() = OMIT_VALUE;
else vSTK__RAND().set_implicit_omit();
if (!vSTK().is_bound()) vSTK() = OMIT_VALUE;
else vSTK().set_implicit_omit();
if (!cellIdentifierListSegment().is_bound()) cellIdentifierListSegment() = OMIT_VALUE;
else cellIdentifierListSegment().set_implicit_omit();
if (!aoIPTransportLayer().is_bound()) aoIPTransportLayer() = OMIT_VALUE;
else aoIPTransportLayer().set_implicit_omit();
if (!callIdentifier().is_bound()) callIdentifier() = OMIT_VALUE;
else callIdentifier().set_implicit_omit();
if (!codecList().is_bound()) codecList() = OMIT_VALUE;
else codecList().set_implicit_omit();
}

void PDU__BSSMAP__VGCS__VBSAssignmentRequest::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (15<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest has 15 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) channelType().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) assignmentRequirement().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) cellIdentifier().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) groupCallReference().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) priority().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) circuitIdentityCode().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) downLinkDTX__Flag().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) encryptionInformation().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) vSTK__RAND().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) vSTK().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) cellIdentifierListSegment().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) aoIPTransportLayer().set_param(*param.get_elem(12));
    if (param.get_size()>13 && param.get_elem(13)->get_type()!=Module_Param::MP_NotUsed) callIdentifier().set_param(*param.get_elem(13));
    if (param.get_size()>14 && param.get_elem(14)->get_type()!=Module_Param::MP_NotUsed) codecList().set_param(*param.get_elem(14));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "channelType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          channelType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "assignmentRequirement")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          assignmentRequirement().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "groupCallReference")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          groupCallReference().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "priority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          priority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "circuitIdentityCode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          circuitIdentityCode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "downLinkDTX_Flag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          downLinkDTX__Flag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "encryptionInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          encryptionInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vSTK_RAND")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vSTK__RAND().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vSTK")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vSTK().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentifierListSegment")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentifierListSegment().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aoIPTransportLayer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aoIPTransportLayer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "callIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          callIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "codecList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          codecList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest");
  }
}

void PDU__BSSMAP__VGCS__VBSAssignmentRequest::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_channelType.encode_text(text_buf);
field_assignmentRequirement.encode_text(text_buf);
field_cellIdentifier.encode_text(text_buf);
field_groupCallReference.encode_text(text_buf);
field_priority.encode_text(text_buf);
field_circuitIdentityCode.encode_text(text_buf);
field_downLinkDTX__Flag.encode_text(text_buf);
field_encryptionInformation.encode_text(text_buf);
field_vSTK__RAND.encode_text(text_buf);
field_vSTK.encode_text(text_buf);
field_cellIdentifierListSegment.encode_text(text_buf);
field_aoIPTransportLayer.encode_text(text_buf);
field_callIdentifier.encode_text(text_buf);
field_codecList.encode_text(text_buf);
}

void PDU__BSSMAP__VGCS__VBSAssignmentRequest::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_channelType.decode_text(text_buf);
field_assignmentRequirement.decode_text(text_buf);
field_cellIdentifier.decode_text(text_buf);
field_groupCallReference.decode_text(text_buf);
field_priority.decode_text(text_buf);
field_circuitIdentityCode.decode_text(text_buf);
field_downLinkDTX__Flag.decode_text(text_buf);
field_encryptionInformation.decode_text(text_buf);
field_vSTK__RAND.decode_text(text_buf);
field_vSTK.decode_text(text_buf);
field_cellIdentifierListSegment.decode_text(text_buf);
field_aoIPTransportLayer.decode_text(text_buf);
field_callIdentifier.decode_text(text_buf);
field_codecList.decode_text(text_buf);
}

void PDU__BSSMAP__VGCS__VBSAssignmentRequest::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__VGCS__VBSAssignmentRequest::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__VGCS__VBSAssignmentRequest::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__ChannelType_descr_.raw->forceomit);
  decoded_field_length = field_channelType.RAW_decode(BSSMAP__IE__ChannelType_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, BSSMAP__IE__AssignmentRequirement_descr_.raw->forceomit);
  decoded_field_length = field_assignmentRequirement.RAW_decode(BSSMAP__IE__AssignmentRequirement_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, BSSMAP__IE__CellIdentifier_descr_.raw->forceomit);
  decoded_field_length = field_cellIdentifier.RAW_decode(BSSMAP__IE__CellIdentifier_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_4_force_omit(4, force_omit, BSSMAP__IE__GroupCallReference_descr_.raw->forceomit);
  decoded_field_length = field_groupCallReference.RAW_decode(BSSMAP__IE__GroupCallReference_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_priority = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, BSSMAP__IE__Priority_descr_.raw->forceomit);
  decoded_field_length = field_priority().RAW_decode(BSSMAP__IE__Priority_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_priority = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_priority=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(6)) {
    field_circuitIdentityCode = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, BSSMAP__IE__CircuitIdentityCode_descr_.raw->forceomit);
  decoded_field_length = field_circuitIdentityCode().RAW_decode(BSSMAP__IE__CircuitIdentityCode_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_circuitIdentityCode = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_circuitIdentityCode=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(7)) {
    field_downLinkDTX__Flag = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_7_force_omit(7, force_omit, BSSMAP__IE__DownLinkDTXFlag_descr_.raw->forceomit);
  decoded_field_length = field_downLinkDTX__Flag().RAW_decode(BSSMAP__IE__DownLinkDTXFlag_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 1) {
  field_downLinkDTX__Flag = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_downLinkDTX__Flag=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(8)) {
    field_encryptionInformation = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_8_force_omit(8, force_omit, BSSMAP__IE__EncryptionInformation_descr_.raw->forceomit);
  decoded_field_length = field_encryptionInformation().RAW_decode(BSSMAP__IE__EncryptionInformation_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 1) {
  field_encryptionInformation = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_encryptionInformation=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(9)) {
    field_vSTK__RAND = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_9_force_omit(9, force_omit, BSSMAP__IE__VSTK__RAND_descr_.raw->forceomit);
  decoded_field_length = field_vSTK__RAND().RAW_decode(BSSMAP__IE__VSTK__RAND_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_9_force_omit);
  if (decoded_field_length < 1) {
  field_vSTK__RAND = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_vSTK__RAND=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(10)) {
    field_vSTK = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_10_force_omit(10, force_omit, BSSMAP__IE__VSTK_descr_.raw->forceomit);
  decoded_field_length = field_vSTK().RAW_decode(BSSMAP__IE__VSTK_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_10_force_omit);
  if (decoded_field_length < 1) {
  field_vSTK = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_vSTK=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(11)) {
    field_cellIdentifierListSegment = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_11_force_omit(11, force_omit, BSSMAP__IE__CellIdentifierListSegment_descr_.raw->forceomit);
  decoded_field_length = field_cellIdentifierListSegment().RAW_decode(BSSMAP__IE__CellIdentifierListSegment_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_11_force_omit);
  if (decoded_field_length < 1) {
  field_cellIdentifierListSegment = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_cellIdentifierListSegment=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(12)) {
    field_aoIPTransportLayer = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_12_force_omit(12, force_omit, BSSMAP__IE__AoIP__TransportLayerAddress_descr_.raw->forceomit);
  decoded_field_length = field_aoIPTransportLayer().RAW_decode(BSSMAP__IE__AoIP__TransportLayerAddress_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_12_force_omit);
  if (decoded_field_length < 1) {
  field_aoIPTransportLayer = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_aoIPTransportLayer=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(13)) {
    field_callIdentifier = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_13_force_omit(13, force_omit, BSSMAP__IE__CallIdentifier_descr_.raw->forceomit);
  decoded_field_length = field_callIdentifier().RAW_decode(BSSMAP__IE__CallIdentifier_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_13_force_omit);
  if (decoded_field_length < 1) {
  field_callIdentifier = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_callIdentifier=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(14)) {
    field_codecList = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_14_force_omit(14, force_omit, BSSMAP__IE__SpeechCodecList_descr_.raw->forceomit);
  decoded_field_length = field_codecList().RAW_decode(BSSMAP__IE__SpeechCodecList_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_14_force_omit);
  if (decoded_field_length < 1) {
  field_codecList = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_codecList=OMIT_VALUE;
  if (field_messageType !=  os_0) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__VGCS__VBSAssignmentRequest::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 15;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(15);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__ChannelType_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, BSSMAP__IE__AssignmentRequirement_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, BSSMAP__IE__CellIdentifier_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, BSSMAP__IE__GroupCallReference_descr_.raw);
  if (field_priority.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, BSSMAP__IE__Priority_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_circuitIdentityCode.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, BSSMAP__IE__CircuitIdentityCode_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  if (field_downLinkDTX__Flag.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, BSSMAP__IE__DownLinkDTXFlag_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  if (field_encryptionInformation.ispresent()) {
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, BSSMAP__IE__EncryptionInformation_descr_.raw);
  }
  else myleaf.body.node.nodes[8] = NULL;
  if (field_vSTK__RAND.ispresent()) {
  myleaf.body.node.nodes[9] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 9, BSSMAP__IE__VSTK__RAND_descr_.raw);
  }
  else myleaf.body.node.nodes[9] = NULL;
  if (field_vSTK.ispresent()) {
  myleaf.body.node.nodes[10] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 10, BSSMAP__IE__VSTK_descr_.raw);
  }
  else myleaf.body.node.nodes[10] = NULL;
  if (field_cellIdentifierListSegment.ispresent()) {
  myleaf.body.node.nodes[11] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 11, BSSMAP__IE__CellIdentifierListSegment_descr_.raw);
  }
  else myleaf.body.node.nodes[11] = NULL;
  if (field_aoIPTransportLayer.ispresent()) {
  myleaf.body.node.nodes[12] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 12, BSSMAP__IE__AoIP__TransportLayerAddress_descr_.raw);
  }
  else myleaf.body.node.nodes[12] = NULL;
  if (field_callIdentifier.ispresent()) {
  myleaf.body.node.nodes[13] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 13, BSSMAP__IE__CallIdentifier_descr_.raw);
  }
  else myleaf.body.node.nodes[13] = NULL;
  if (field_codecList.ispresent()) {
  myleaf.body.node.nodes[14] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 14, BSSMAP__IE__SpeechCodecList_descr_.raw);
  }
  else myleaf.body.node.nodes[14] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_channelType.RAW_encode(BSSMAP__IE__ChannelType_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_assignmentRequirement.RAW_encode(BSSMAP__IE__AssignmentRequirement_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_cellIdentifier.RAW_encode(BSSMAP__IE__CellIdentifier_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_groupCallReference.RAW_encode(BSSMAP__IE__GroupCallReference_descr_, *myleaf.body.node.nodes[4]);
  if (field_priority.ispresent()) {
  encoded_length += field_priority().RAW_encode(BSSMAP__IE__Priority_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_circuitIdentityCode.ispresent()) {
  encoded_length += field_circuitIdentityCode().RAW_encode(BSSMAP__IE__CircuitIdentityCode_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_downLinkDTX__Flag.ispresent()) {
  encoded_length += field_downLinkDTX__Flag().RAW_encode(BSSMAP__IE__DownLinkDTXFlag_descr_, *myleaf.body.node.nodes[7]);
  }
  if (field_encryptionInformation.ispresent()) {
  encoded_length += field_encryptionInformation().RAW_encode(BSSMAP__IE__EncryptionInformation_descr_, *myleaf.body.node.nodes[8]);
  }
  if (field_vSTK__RAND.ispresent()) {
  encoded_length += field_vSTK__RAND().RAW_encode(BSSMAP__IE__VSTK__RAND_descr_, *myleaf.body.node.nodes[9]);
  }
  if (field_vSTK.ispresent()) {
  encoded_length += field_vSTK().RAW_encode(BSSMAP__IE__VSTK_descr_, *myleaf.body.node.nodes[10]);
  }
  if (field_cellIdentifierListSegment.ispresent()) {
  encoded_length += field_cellIdentifierListSegment().RAW_encode(BSSMAP__IE__CellIdentifierListSegment_descr_, *myleaf.body.node.nodes[11]);
  }
  if (field_aoIPTransportLayer.ispresent()) {
  encoded_length += field_aoIPTransportLayer().RAW_encode(BSSMAP__IE__AoIP__TransportLayerAddress_descr_, *myleaf.body.node.nodes[12]);
  }
  if (field_callIdentifier.ispresent()) {
  encoded_length += field_callIdentifier().RAW_encode(BSSMAP__IE__CallIdentifier_descr_, *myleaf.body.node.nodes[13]);
  }
  if (field_codecList.ispresent()) {
  encoded_length += field_codecList().RAW_encode(BSSMAP__IE__SpeechCodecList_descr_, *myleaf.body.node.nodes[14]);
  }
  if (field_messageType !=  os_0) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_0.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__ChannelType_template field_channelType;
BSSMAP__IE__AssignmentRequirement_template field_assignmentRequirement;
BSSMAP__IE__CellIdentifier_template field_cellIdentifier;
BSSMAP__IE__GroupCallReference_template field_groupCallReference;
BSSMAP__IE__Priority_template field_priority;
BSSMAP__IE__CircuitIdentityCode_template field_circuitIdentityCode;
BSSMAP__IE__DownLinkDTXFlag_template field_downLinkDTX__Flag;
BSSMAP__IE__EncryptionInformation_template field_encryptionInformation;
BSSMAP__IE__VSTK__RAND_template field_vSTK__RAND;
BSSMAP__IE__VSTK_template field_vSTK;
BSSMAP__IE__CellIdentifierListSegment_template field_cellIdentifierListSegment;
BSSMAP__IE__AoIP__TransportLayerAddress_template field_aoIPTransportLayer;
BSSMAP__IE__CallIdentifier_template field_callIdentifier;
BSSMAP__IE__SpeechCodecList_template field_codecList;
};

void PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_channelType = ANY_VALUE;
single_value->field_assignmentRequirement = ANY_VALUE;
single_value->field_cellIdentifier = ANY_VALUE;
single_value->field_groupCallReference = ANY_VALUE;
single_value->field_priority = ANY_OR_OMIT;
single_value->field_circuitIdentityCode = ANY_OR_OMIT;
single_value->field_downLinkDTX__Flag = ANY_OR_OMIT;
single_value->field_encryptionInformation = ANY_OR_OMIT;
single_value->field_vSTK__RAND = ANY_OR_OMIT;
single_value->field_vSTK = ANY_OR_OMIT;
single_value->field_cellIdentifierListSegment = ANY_OR_OMIT;
single_value->field_aoIPTransportLayer = ANY_OR_OMIT;
single_value->field_callIdentifier = ANY_OR_OMIT;
single_value->field_codecList = ANY_OR_OMIT;
}
}
}

void PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::copy_value(const PDU__BSSMAP__VGCS__VBSAssignmentRequest& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.channelType().is_bound()) {
  single_value->field_channelType = other_value.channelType();
} else {
  single_value->field_channelType.clean_up();
}
if (other_value.assignmentRequirement().is_bound()) {
  single_value->field_assignmentRequirement = other_value.assignmentRequirement();
} else {
  single_value->field_assignmentRequirement.clean_up();
}
if (other_value.cellIdentifier().is_bound()) {
  single_value->field_cellIdentifier = other_value.cellIdentifier();
} else {
  single_value->field_cellIdentifier.clean_up();
}
if (other_value.groupCallReference().is_bound()) {
  single_value->field_groupCallReference = other_value.groupCallReference();
} else {
  single_value->field_groupCallReference.clean_up();
}
if (other_value.priority().is_bound()) {
  if (other_value.priority().ispresent()) single_value->field_priority = other_value.priority()();
  else single_value->field_priority = OMIT_VALUE;
} else {
  single_value->field_priority.clean_up();
}
if (other_value.circuitIdentityCode().is_bound()) {
  if (other_value.circuitIdentityCode().ispresent()) single_value->field_circuitIdentityCode = other_value.circuitIdentityCode()();
  else single_value->field_circuitIdentityCode = OMIT_VALUE;
} else {
  single_value->field_circuitIdentityCode.clean_up();
}
if (other_value.downLinkDTX__Flag().is_bound()) {
  if (other_value.downLinkDTX__Flag().ispresent()) single_value->field_downLinkDTX__Flag = other_value.downLinkDTX__Flag()();
  else single_value->field_downLinkDTX__Flag = OMIT_VALUE;
} else {
  single_value->field_downLinkDTX__Flag.clean_up();
}
if (other_value.encryptionInformation().is_bound()) {
  if (other_value.encryptionInformation().ispresent()) single_value->field_encryptionInformation = other_value.encryptionInformation()();
  else single_value->field_encryptionInformation = OMIT_VALUE;
} else {
  single_value->field_encryptionInformation.clean_up();
}
if (other_value.vSTK__RAND().is_bound()) {
  if (other_value.vSTK__RAND().ispresent()) single_value->field_vSTK__RAND = other_value.vSTK__RAND()();
  else single_value->field_vSTK__RAND = OMIT_VALUE;
} else {
  single_value->field_vSTK__RAND.clean_up();
}
if (other_value.vSTK().is_bound()) {
  if (other_value.vSTK().ispresent()) single_value->field_vSTK = other_value.vSTK()();
  else single_value->field_vSTK = OMIT_VALUE;
} else {
  single_value->field_vSTK.clean_up();
}
if (other_value.cellIdentifierListSegment().is_bound()) {
  if (other_value.cellIdentifierListSegment().ispresent()) single_value->field_cellIdentifierListSegment = other_value.cellIdentifierListSegment()();
  else single_value->field_cellIdentifierListSegment = OMIT_VALUE;
} else {
  single_value->field_cellIdentifierListSegment.clean_up();
}
if (other_value.aoIPTransportLayer().is_bound()) {
  if (other_value.aoIPTransportLayer().ispresent()) single_value->field_aoIPTransportLayer = other_value.aoIPTransportLayer()();
  else single_value->field_aoIPTransportLayer = OMIT_VALUE;
} else {
  single_value->field_aoIPTransportLayer.clean_up();
}
if (other_value.callIdentifier().is_bound()) {
  if (other_value.callIdentifier().ispresent()) single_value->field_callIdentifier = other_value.callIdentifier()();
  else single_value->field_callIdentifier = OMIT_VALUE;
} else {
  single_value->field_callIdentifier.clean_up();
}
if (other_value.codecList().is_bound()) {
  if (other_value.codecList().ispresent()) single_value->field_codecList = other_value.codecList()();
  else single_value->field_codecList = OMIT_VALUE;
} else {
  single_value->field_codecList.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::copy_template(const PDU__BSSMAP__VGCS__VBSAssignmentRequest_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.channelType().get_selection()) {
single_value->field_channelType = other_value.channelType();
} else {
single_value->field_channelType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.assignmentRequirement().get_selection()) {
single_value->field_assignmentRequirement = other_value.assignmentRequirement();
} else {
single_value->field_assignmentRequirement.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cellIdentifier().get_selection()) {
single_value->field_cellIdentifier = other_value.cellIdentifier();
} else {
single_value->field_cellIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.groupCallReference().get_selection()) {
single_value->field_groupCallReference = other_value.groupCallReference();
} else {
single_value->field_groupCallReference.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.priority().get_selection()) {
single_value->field_priority = other_value.priority();
} else {
single_value->field_priority.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.circuitIdentityCode().get_selection()) {
single_value->field_circuitIdentityCode = other_value.circuitIdentityCode();
} else {
single_value->field_circuitIdentityCode.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.downLinkDTX__Flag().get_selection()) {
single_value->field_downLinkDTX__Flag = other_value.downLinkDTX__Flag();
} else {
single_value->field_downLinkDTX__Flag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.encryptionInformation().get_selection()) {
single_value->field_encryptionInformation = other_value.encryptionInformation();
} else {
single_value->field_encryptionInformation.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.vSTK__RAND().get_selection()) {
single_value->field_vSTK__RAND = other_value.vSTK__RAND();
} else {
single_value->field_vSTK__RAND.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.vSTK().get_selection()) {
single_value->field_vSTK = other_value.vSTK();
} else {
single_value->field_vSTK.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cellIdentifierListSegment().get_selection()) {
single_value->field_cellIdentifierListSegment = other_value.cellIdentifierListSegment();
} else {
single_value->field_cellIdentifierListSegment.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.aoIPTransportLayer().get_selection()) {
single_value->field_aoIPTransportLayer = other_value.aoIPTransportLayer();
} else {
single_value->field_aoIPTransportLayer.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.callIdentifier().get_selection()) {
single_value->field_callIdentifier = other_value.callIdentifier();
} else {
single_value->field_callIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.codecList().get_selection()) {
single_value->field_codecList = other_value.codecList();
} else {
single_value->field_codecList.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__VGCS__VBSAssignmentRequest_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__VGCS__VBSAssignmentRequest_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__VGCS__VBSAssignmentRequest_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::PDU__BSSMAP__VGCS__VBSAssignmentRequest_template()
{
}

PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::PDU__BSSMAP__VGCS__VBSAssignmentRequest_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::PDU__BSSMAP__VGCS__VBSAssignmentRequest_template(const PDU__BSSMAP__VGCS__VBSAssignmentRequest& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::PDU__BSSMAP__VGCS__VBSAssignmentRequest_template(const OPTIONAL<PDU__BSSMAP__VGCS__VBSAssignmentRequest>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__VGCS__VBSAssignmentRequest&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest from an unbound optional field.");
}
}

PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::PDU__BSSMAP__VGCS__VBSAssignmentRequest_template(PDU__BSSMAP__VGCS__VBSAssignmentRequest_template* p_precondition, PDU__BSSMAP__VGCS__VBSAssignmentRequest_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::PDU__BSSMAP__VGCS__VBSAssignmentRequest_template(Dynamic_Match_Interface<PDU__BSSMAP__VGCS__VBSAssignmentRequest>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__VGCS__VBSAssignmentRequest>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::PDU__BSSMAP__VGCS__VBSAssignmentRequest_template(const PDU__BSSMAP__VGCS__VBSAssignmentRequest_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::~PDU__BSSMAP__VGCS__VBSAssignmentRequest_template()
{
clean_up();
}

PDU__BSSMAP__VGCS__VBSAssignmentRequest_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__VGCS__VBSAssignmentRequest_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::operator=(const PDU__BSSMAP__VGCS__VBSAssignmentRequest& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__VGCS__VBSAssignmentRequest_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::operator=(const OPTIONAL<PDU__BSSMAP__VGCS__VBSAssignmentRequest>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__VGCS__VBSAssignmentRequest&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
}
return *this;
}

PDU__BSSMAP__VGCS__VBSAssignmentRequest_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::operator=(const PDU__BSSMAP__VGCS__VBSAssignmentRequest_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::match(const PDU__BSSMAP__VGCS__VBSAssignmentRequest& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.channelType().is_bound()) return FALSE;
if(!single_value->field_channelType.match(other_value.channelType(), legacy))return FALSE;
if(!other_value.assignmentRequirement().is_bound()) return FALSE;
if(!single_value->field_assignmentRequirement.match(other_value.assignmentRequirement(), legacy))return FALSE;
if(!other_value.cellIdentifier().is_bound()) return FALSE;
if(!single_value->field_cellIdentifier.match(other_value.cellIdentifier(), legacy))return FALSE;
if(!other_value.groupCallReference().is_bound()) return FALSE;
if(!single_value->field_groupCallReference.match(other_value.groupCallReference(), legacy))return FALSE;
if(!other_value.priority().is_bound()) return FALSE;
if((other_value.priority().ispresent() ? !single_value->field_priority.match((const BSSMAP__IE__Priority&)other_value.priority(), legacy) : !single_value->field_priority.match_omit(legacy)))return FALSE;
if(!other_value.circuitIdentityCode().is_bound()) return FALSE;
if((other_value.circuitIdentityCode().ispresent() ? !single_value->field_circuitIdentityCode.match((const BSSMAP__IE__CircuitIdentityCode&)other_value.circuitIdentityCode(), legacy) : !single_value->field_circuitIdentityCode.match_omit(legacy)))return FALSE;
if(!other_value.downLinkDTX__Flag().is_bound()) return FALSE;
if((other_value.downLinkDTX__Flag().ispresent() ? !single_value->field_downLinkDTX__Flag.match((const BSSMAP__IE__DownLinkDTXFlag&)other_value.downLinkDTX__Flag(), legacy) : !single_value->field_downLinkDTX__Flag.match_omit(legacy)))return FALSE;
if(!other_value.encryptionInformation().is_bound()) return FALSE;
if((other_value.encryptionInformation().ispresent() ? !single_value->field_encryptionInformation.match((const BSSMAP__IE__EncryptionInformation&)other_value.encryptionInformation(), legacy) : !single_value->field_encryptionInformation.match_omit(legacy)))return FALSE;
if(!other_value.vSTK__RAND().is_bound()) return FALSE;
if((other_value.vSTK__RAND().ispresent() ? !single_value->field_vSTK__RAND.match((const BSSMAP__IE__VSTK__RAND&)other_value.vSTK__RAND(), legacy) : !single_value->field_vSTK__RAND.match_omit(legacy)))return FALSE;
if(!other_value.vSTK().is_bound()) return FALSE;
if((other_value.vSTK().ispresent() ? !single_value->field_vSTK.match((const BSSMAP__IE__VSTK&)other_value.vSTK(), legacy) : !single_value->field_vSTK.match_omit(legacy)))return FALSE;
if(!other_value.cellIdentifierListSegment().is_bound()) return FALSE;
if((other_value.cellIdentifierListSegment().ispresent() ? !single_value->field_cellIdentifierListSegment.match((const BSSMAP__IE__CellIdentifierListSegment&)other_value.cellIdentifierListSegment(), legacy) : !single_value->field_cellIdentifierListSegment.match_omit(legacy)))return FALSE;
if(!other_value.aoIPTransportLayer().is_bound()) return FALSE;
if((other_value.aoIPTransportLayer().ispresent() ? !single_value->field_aoIPTransportLayer.match((const BSSMAP__IE__AoIP__TransportLayerAddress&)other_value.aoIPTransportLayer(), legacy) : !single_value->field_aoIPTransportLayer.match_omit(legacy)))return FALSE;
if(!other_value.callIdentifier().is_bound()) return FALSE;
if((other_value.callIdentifier().ispresent() ? !single_value->field_callIdentifier.match((const BSSMAP__IE__CallIdentifier&)other_value.callIdentifier(), legacy) : !single_value->field_callIdentifier.match_omit(legacy)))return FALSE;
if(!other_value.codecList().is_bound()) return FALSE;
if((other_value.codecList().ispresent() ? !single_value->field_codecList.match((const BSSMAP__IE__SpeechCodecList&)other_value.codecList(), legacy) : !single_value->field_codecList.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
}
return FALSE;
}

boolean PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_channelType.is_bound()
 || single_value->field_assignmentRequirement.is_bound()
 || single_value->field_cellIdentifier.is_bound()
 || single_value->field_groupCallReference.is_bound()
 || (single_value->field_priority.is_omit() || single_value->field_priority.is_bound())
 || (single_value->field_circuitIdentityCode.is_omit() || single_value->field_circuitIdentityCode.is_bound())
 || (single_value->field_downLinkDTX__Flag.is_omit() || single_value->field_downLinkDTX__Flag.is_bound())
 || (single_value->field_encryptionInformation.is_omit() || single_value->field_encryptionInformation.is_bound())
 || (single_value->field_vSTK__RAND.is_omit() || single_value->field_vSTK__RAND.is_bound())
 || (single_value->field_vSTK.is_omit() || single_value->field_vSTK.is_bound())
 || (single_value->field_cellIdentifierListSegment.is_omit() || single_value->field_cellIdentifierListSegment.is_bound())
 || (single_value->field_aoIPTransportLayer.is_omit() || single_value->field_aoIPTransportLayer.is_bound())
 || (single_value->field_callIdentifier.is_omit() || single_value->field_callIdentifier.is_bound())
 || (single_value->field_codecList.is_omit() || single_value->field_codecList.is_bound());
}

boolean PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_channelType.is_value()
 && single_value->field_assignmentRequirement.is_value()
 && single_value->field_cellIdentifier.is_value()
 && single_value->field_groupCallReference.is_value()
 && (single_value->field_priority.is_omit() || single_value->field_priority.is_value())
 && (single_value->field_circuitIdentityCode.is_omit() || single_value->field_circuitIdentityCode.is_value())
 && (single_value->field_downLinkDTX__Flag.is_omit() || single_value->field_downLinkDTX__Flag.is_value())
 && (single_value->field_encryptionInformation.is_omit() || single_value->field_encryptionInformation.is_value())
 && (single_value->field_vSTK__RAND.is_omit() || single_value->field_vSTK__RAND.is_value())
 && (single_value->field_vSTK.is_omit() || single_value->field_vSTK.is_value())
 && (single_value->field_cellIdentifierListSegment.is_omit() || single_value->field_cellIdentifierListSegment.is_value())
 && (single_value->field_aoIPTransportLayer.is_omit() || single_value->field_aoIPTransportLayer.is_value())
 && (single_value->field_callIdentifier.is_omit() || single_value->field_callIdentifier.is_value())
 && (single_value->field_codecList.is_omit() || single_value->field_codecList.is_value());
}

void PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__VGCS__VBSAssignmentRequest PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
PDU__BSSMAP__VGCS__VBSAssignmentRequest ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_channelType.is_bound()) {
ret_val.channelType() = single_value->field_channelType.valueof();
}
if (single_value->field_assignmentRequirement.is_bound()) {
ret_val.assignmentRequirement() = single_value->field_assignmentRequirement.valueof();
}
if (single_value->field_cellIdentifier.is_bound()) {
ret_val.cellIdentifier() = single_value->field_cellIdentifier.valueof();
}
if (single_value->field_groupCallReference.is_bound()) {
ret_val.groupCallReference() = single_value->field_groupCallReference.valueof();
}
if (single_value->field_priority.is_omit()) ret_val.priority() = OMIT_VALUE;
else if (single_value->field_priority.is_bound()) {
ret_val.priority() = single_value->field_priority.valueof();
}
if (single_value->field_circuitIdentityCode.is_omit()) ret_val.circuitIdentityCode() = OMIT_VALUE;
else if (single_value->field_circuitIdentityCode.is_bound()) {
ret_val.circuitIdentityCode() = single_value->field_circuitIdentityCode.valueof();
}
if (single_value->field_downLinkDTX__Flag.is_omit()) ret_val.downLinkDTX__Flag() = OMIT_VALUE;
else if (single_value->field_downLinkDTX__Flag.is_bound()) {
ret_val.downLinkDTX__Flag() = single_value->field_downLinkDTX__Flag.valueof();
}
if (single_value->field_encryptionInformation.is_omit()) ret_val.encryptionInformation() = OMIT_VALUE;
else if (single_value->field_encryptionInformation.is_bound()) {
ret_val.encryptionInformation() = single_value->field_encryptionInformation.valueof();
}
if (single_value->field_vSTK__RAND.is_omit()) ret_val.vSTK__RAND() = OMIT_VALUE;
else if (single_value->field_vSTK__RAND.is_bound()) {
ret_val.vSTK__RAND() = single_value->field_vSTK__RAND.valueof();
}
if (single_value->field_vSTK.is_omit()) ret_val.vSTK() = OMIT_VALUE;
else if (single_value->field_vSTK.is_bound()) {
ret_val.vSTK() = single_value->field_vSTK.valueof();
}
if (single_value->field_cellIdentifierListSegment.is_omit()) ret_val.cellIdentifierListSegment() = OMIT_VALUE;
else if (single_value->field_cellIdentifierListSegment.is_bound()) {
ret_val.cellIdentifierListSegment() = single_value->field_cellIdentifierListSegment.valueof();
}
if (single_value->field_aoIPTransportLayer.is_omit()) ret_val.aoIPTransportLayer() = OMIT_VALUE;
else if (single_value->field_aoIPTransportLayer.is_bound()) {
ret_val.aoIPTransportLayer() = single_value->field_aoIPTransportLayer.valueof();
}
if (single_value->field_callIdentifier.is_omit()) ret_val.callIdentifier() = OMIT_VALUE;
else if (single_value->field_callIdentifier.is_bound()) {
ret_val.callIdentifier() = single_value->field_callIdentifier.valueof();
}
if (single_value->field_codecList.is_omit()) ret_val.codecList() = OMIT_VALUE;
else if (single_value->field_codecList.is_bound()) {
ret_val.codecList() = single_value->field_codecList.valueof();
}
return ret_val;
}

void PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__VGCS__VBSAssignmentRequest_template[list_length];
}

PDU__BSSMAP__VGCS__VBSAssignmentRequest_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
return single_value->field_messageType;
}

BSSMAP__IE__ChannelType_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::channelType()
{
set_specific();
return single_value->field_channelType;
}

const BSSMAP__IE__ChannelType_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::channelType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field channelType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
return single_value->field_channelType;
}

BSSMAP__IE__AssignmentRequirement_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::assignmentRequirement()
{
set_specific();
return single_value->field_assignmentRequirement;
}

const BSSMAP__IE__AssignmentRequirement_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::assignmentRequirement() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field assignmentRequirement of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
return single_value->field_assignmentRequirement;
}

BSSMAP__IE__CellIdentifier_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::cellIdentifier()
{
set_specific();
return single_value->field_cellIdentifier;
}

const BSSMAP__IE__CellIdentifier_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::cellIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cellIdentifier of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
return single_value->field_cellIdentifier;
}

BSSMAP__IE__GroupCallReference_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::groupCallReference()
{
set_specific();
return single_value->field_groupCallReference;
}

const BSSMAP__IE__GroupCallReference_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::groupCallReference() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field groupCallReference of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
return single_value->field_groupCallReference;
}

BSSMAP__IE__Priority_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::priority()
{
set_specific();
return single_value->field_priority;
}

const BSSMAP__IE__Priority_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::priority() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field priority of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
return single_value->field_priority;
}

BSSMAP__IE__CircuitIdentityCode_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::circuitIdentityCode()
{
set_specific();
return single_value->field_circuitIdentityCode;
}

const BSSMAP__IE__CircuitIdentityCode_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::circuitIdentityCode() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field circuitIdentityCode of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
return single_value->field_circuitIdentityCode;
}

BSSMAP__IE__DownLinkDTXFlag_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::downLinkDTX__Flag()
{
set_specific();
return single_value->field_downLinkDTX__Flag;
}

const BSSMAP__IE__DownLinkDTXFlag_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::downLinkDTX__Flag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field downLinkDTX_Flag of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
return single_value->field_downLinkDTX__Flag;
}

BSSMAP__IE__EncryptionInformation_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::encryptionInformation()
{
set_specific();
return single_value->field_encryptionInformation;
}

const BSSMAP__IE__EncryptionInformation_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::encryptionInformation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field encryptionInformation of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
return single_value->field_encryptionInformation;
}

BSSMAP__IE__VSTK__RAND_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::vSTK__RAND()
{
set_specific();
return single_value->field_vSTK__RAND;
}

const BSSMAP__IE__VSTK__RAND_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::vSTK__RAND() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field vSTK_RAND of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
return single_value->field_vSTK__RAND;
}

BSSMAP__IE__VSTK_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::vSTK()
{
set_specific();
return single_value->field_vSTK;
}

const BSSMAP__IE__VSTK_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::vSTK() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field vSTK of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
return single_value->field_vSTK;
}

BSSMAP__IE__CellIdentifierListSegment_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::cellIdentifierListSegment()
{
set_specific();
return single_value->field_cellIdentifierListSegment;
}

const BSSMAP__IE__CellIdentifierListSegment_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::cellIdentifierListSegment() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cellIdentifierListSegment of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
return single_value->field_cellIdentifierListSegment;
}

BSSMAP__IE__AoIP__TransportLayerAddress_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::aoIPTransportLayer()
{
set_specific();
return single_value->field_aoIPTransportLayer;
}

const BSSMAP__IE__AoIP__TransportLayerAddress_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::aoIPTransportLayer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field aoIPTransportLayer of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
return single_value->field_aoIPTransportLayer;
}

BSSMAP__IE__CallIdentifier_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::callIdentifier()
{
set_specific();
return single_value->field_callIdentifier;
}

const BSSMAP__IE__CallIdentifier_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::callIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field callIdentifier of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
return single_value->field_callIdentifier;
}

BSSMAP__IE__SpeechCodecList_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::codecList()
{
set_specific();
return single_value->field_codecList;
}

const BSSMAP__IE__SpeechCodecList_template& PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::codecList() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field codecList of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
return single_value->field_codecList;
}

int PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 5;
      if (single_value->field_priority.is_present()) ret_val++;
      if (single_value->field_circuitIdentityCode.is_present()) ret_val++;
      if (single_value->field_downLinkDTX__Flag.is_present()) ret_val++;
      if (single_value->field_encryptionInformation.is_present()) ret_val++;
      if (single_value->field_vSTK__RAND.is_present()) ret_val++;
      if (single_value->field_vSTK.is_present()) ret_val++;
      if (single_value->field_cellIdentifierListSegment.is_present()) ret_val++;
      if (single_value->field_aoIPTransportLayer.is_present()) ret_val++;
      if (single_value->field_callIdentifier.is_present()) ret_val++;
      if (single_value->field_codecList.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
  }
  return 0;
}

void PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", channelType := ");
single_value->field_channelType.log();
TTCN_Logger::log_event_str(", assignmentRequirement := ");
single_value->field_assignmentRequirement.log();
TTCN_Logger::log_event_str(", cellIdentifier := ");
single_value->field_cellIdentifier.log();
TTCN_Logger::log_event_str(", groupCallReference := ");
single_value->field_groupCallReference.log();
TTCN_Logger::log_event_str(", priority := ");
single_value->field_priority.log();
TTCN_Logger::log_event_str(", circuitIdentityCode := ");
single_value->field_circuitIdentityCode.log();
TTCN_Logger::log_event_str(", downLinkDTX_Flag := ");
single_value->field_downLinkDTX__Flag.log();
TTCN_Logger::log_event_str(", encryptionInformation := ");
single_value->field_encryptionInformation.log();
TTCN_Logger::log_event_str(", vSTK_RAND := ");
single_value->field_vSTK__RAND.log();
TTCN_Logger::log_event_str(", vSTK := ");
single_value->field_vSTK.log();
TTCN_Logger::log_event_str(", cellIdentifierListSegment := ");
single_value->field_cellIdentifierListSegment.log();
TTCN_Logger::log_event_str(", aoIPTransportLayer := ");
single_value->field_aoIPTransportLayer.log();
TTCN_Logger::log_event_str(", callIdentifier := ");
single_value->field_callIdentifier.log();
TTCN_Logger::log_event_str(", codecList := ");
single_value->field_codecList.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::log_match(const PDU__BSSMAP__VGCS__VBSAssignmentRequest& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_channelType.match(match_value.channelType(), legacy)){
TTCN_Logger::log_logmatch_info(".channelType");
single_value->field_channelType.log_match(match_value.channelType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_assignmentRequirement.match(match_value.assignmentRequirement(), legacy)){
TTCN_Logger::log_logmatch_info(".assignmentRequirement");
single_value->field_assignmentRequirement.log_match(match_value.assignmentRequirement(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cellIdentifier.match(match_value.cellIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".cellIdentifier");
single_value->field_cellIdentifier.log_match(match_value.cellIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_groupCallReference.match(match_value.groupCallReference(), legacy)){
TTCN_Logger::log_logmatch_info(".groupCallReference");
single_value->field_groupCallReference.log_match(match_value.groupCallReference(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.priority().ispresent()){
if(!single_value->field_priority.match(match_value.priority(), legacy)){
TTCN_Logger::log_logmatch_info(".priority");
single_value->field_priority.log_match(match_value.priority(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_priority.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".priority := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_priority.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.circuitIdentityCode().ispresent()){
if(!single_value->field_circuitIdentityCode.match(match_value.circuitIdentityCode(), legacy)){
TTCN_Logger::log_logmatch_info(".circuitIdentityCode");
single_value->field_circuitIdentityCode.log_match(match_value.circuitIdentityCode(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_circuitIdentityCode.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".circuitIdentityCode := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_circuitIdentityCode.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.downLinkDTX__Flag().ispresent()){
if(!single_value->field_downLinkDTX__Flag.match(match_value.downLinkDTX__Flag(), legacy)){
TTCN_Logger::log_logmatch_info(".downLinkDTX_Flag");
single_value->field_downLinkDTX__Flag.log_match(match_value.downLinkDTX__Flag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_downLinkDTX__Flag.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".downLinkDTX_Flag := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_downLinkDTX__Flag.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.encryptionInformation().ispresent()){
if(!single_value->field_encryptionInformation.match(match_value.encryptionInformation(), legacy)){
TTCN_Logger::log_logmatch_info(".encryptionInformation");
single_value->field_encryptionInformation.log_match(match_value.encryptionInformation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_encryptionInformation.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".encryptionInformation := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_encryptionInformation.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.vSTK__RAND().ispresent()){
if(!single_value->field_vSTK__RAND.match(match_value.vSTK__RAND(), legacy)){
TTCN_Logger::log_logmatch_info(".vSTK_RAND");
single_value->field_vSTK__RAND.log_match(match_value.vSTK__RAND(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_vSTK__RAND.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".vSTK_RAND := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_vSTK__RAND.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.vSTK().ispresent()){
if(!single_value->field_vSTK.match(match_value.vSTK(), legacy)){
TTCN_Logger::log_logmatch_info(".vSTK");
single_value->field_vSTK.log_match(match_value.vSTK(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_vSTK.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".vSTK := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_vSTK.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.cellIdentifierListSegment().ispresent()){
if(!single_value->field_cellIdentifierListSegment.match(match_value.cellIdentifierListSegment(), legacy)){
TTCN_Logger::log_logmatch_info(".cellIdentifierListSegment");
single_value->field_cellIdentifierListSegment.log_match(match_value.cellIdentifierListSegment(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_cellIdentifierListSegment.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".cellIdentifierListSegment := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_cellIdentifierListSegment.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.aoIPTransportLayer().ispresent()){
if(!single_value->field_aoIPTransportLayer.match(match_value.aoIPTransportLayer(), legacy)){
TTCN_Logger::log_logmatch_info(".aoIPTransportLayer");
single_value->field_aoIPTransportLayer.log_match(match_value.aoIPTransportLayer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_aoIPTransportLayer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".aoIPTransportLayer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_aoIPTransportLayer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.callIdentifier().ispresent()){
if(!single_value->field_callIdentifier.match(match_value.callIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".callIdentifier");
single_value->field_callIdentifier.log_match(match_value.callIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_callIdentifier.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".callIdentifier := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_callIdentifier.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.codecList().ispresent()){
if(!single_value->field_codecList.match(match_value.codecList(), legacy)){
TTCN_Logger::log_logmatch_info(".codecList");
single_value->field_codecList.log_match(match_value.codecList(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_codecList.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".codecList := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_codecList.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", channelType := ");
single_value->field_channelType.log_match(match_value.channelType(), legacy);
TTCN_Logger::log_event_str(", assignmentRequirement := ");
single_value->field_assignmentRequirement.log_match(match_value.assignmentRequirement(), legacy);
TTCN_Logger::log_event_str(", cellIdentifier := ");
single_value->field_cellIdentifier.log_match(match_value.cellIdentifier(), legacy);
TTCN_Logger::log_event_str(", groupCallReference := ");
single_value->field_groupCallReference.log_match(match_value.groupCallReference(), legacy);
TTCN_Logger::log_event_str(", priority := ");
if (match_value.priority().ispresent()) {
single_value->field_priority.log_match(match_value.priority(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_priority.log();
if (single_value->field_priority.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", circuitIdentityCode := ");
if (match_value.circuitIdentityCode().ispresent()) {
single_value->field_circuitIdentityCode.log_match(match_value.circuitIdentityCode(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_circuitIdentityCode.log();
if (single_value->field_circuitIdentityCode.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", downLinkDTX_Flag := ");
if (match_value.downLinkDTX__Flag().ispresent()) {
single_value->field_downLinkDTX__Flag.log_match(match_value.downLinkDTX__Flag(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_downLinkDTX__Flag.log();
if (single_value->field_downLinkDTX__Flag.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", encryptionInformation := ");
if (match_value.encryptionInformation().ispresent()) {
single_value->field_encryptionInformation.log_match(match_value.encryptionInformation(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_encryptionInformation.log();
if (single_value->field_encryptionInformation.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", vSTK_RAND := ");
if (match_value.vSTK__RAND().ispresent()) {
single_value->field_vSTK__RAND.log_match(match_value.vSTK__RAND(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_vSTK__RAND.log();
if (single_value->field_vSTK__RAND.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", vSTK := ");
if (match_value.vSTK().ispresent()) {
single_value->field_vSTK.log_match(match_value.vSTK(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_vSTK.log();
if (single_value->field_vSTK.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", cellIdentifierListSegment := ");
if (match_value.cellIdentifierListSegment().ispresent()) {
single_value->field_cellIdentifierListSegment.log_match(match_value.cellIdentifierListSegment(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_cellIdentifierListSegment.log();
if (single_value->field_cellIdentifierListSegment.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", aoIPTransportLayer := ");
if (match_value.aoIPTransportLayer().ispresent()) {
single_value->field_aoIPTransportLayer.log_match(match_value.aoIPTransportLayer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_aoIPTransportLayer.log();
if (single_value->field_aoIPTransportLayer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", callIdentifier := ");
if (match_value.callIdentifier().ispresent()) {
single_value->field_callIdentifier.log_match(match_value.callIdentifier(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_callIdentifier.log();
if (single_value->field_callIdentifier.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", codecList := ");
if (match_value.codecList().ispresent()) {
single_value->field_codecList.log_match(match_value.codecList(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_codecList.log();
if (single_value->field_codecList.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (channelType().is_bound()) channelType().set_implicit_omit();
if (assignmentRequirement().is_bound()) assignmentRequirement().set_implicit_omit();
if (cellIdentifier().is_bound()) cellIdentifier().set_implicit_omit();
if (groupCallReference().is_bound()) groupCallReference().set_implicit_omit();
if (!priority().is_bound()) priority() = OMIT_VALUE;
else priority().set_implicit_omit();
if (!circuitIdentityCode().is_bound()) circuitIdentityCode() = OMIT_VALUE;
else circuitIdentityCode().set_implicit_omit();
if (!downLinkDTX__Flag().is_bound()) downLinkDTX__Flag() = OMIT_VALUE;
else downLinkDTX__Flag().set_implicit_omit();
if (!encryptionInformation().is_bound()) encryptionInformation() = OMIT_VALUE;
else encryptionInformation().set_implicit_omit();
if (!vSTK__RAND().is_bound()) vSTK__RAND() = OMIT_VALUE;
else vSTK__RAND().set_implicit_omit();
if (!vSTK().is_bound()) vSTK() = OMIT_VALUE;
else vSTK().set_implicit_omit();
if (!cellIdentifierListSegment().is_bound()) cellIdentifierListSegment() = OMIT_VALUE;
else cellIdentifierListSegment().set_implicit_omit();
if (!aoIPTransportLayer().is_bound()) aoIPTransportLayer() = OMIT_VALUE;
else aoIPTransportLayer().set_implicit_omit();
if (!callIdentifier().is_bound()) callIdentifier() = OMIT_VALUE;
else callIdentifier().set_implicit_omit();
if (!codecList().is_bound()) codecList() = OMIT_VALUE;
else codecList().set_implicit_omit();
}

void PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_channelType.encode_text(text_buf);
single_value->field_assignmentRequirement.encode_text(text_buf);
single_value->field_cellIdentifier.encode_text(text_buf);
single_value->field_groupCallReference.encode_text(text_buf);
single_value->field_priority.encode_text(text_buf);
single_value->field_circuitIdentityCode.encode_text(text_buf);
single_value->field_downLinkDTX__Flag.encode_text(text_buf);
single_value->field_encryptionInformation.encode_text(text_buf);
single_value->field_vSTK__RAND.encode_text(text_buf);
single_value->field_vSTK.encode_text(text_buf);
single_value->field_cellIdentifierListSegment.encode_text(text_buf);
single_value->field_aoIPTransportLayer.encode_text(text_buf);
single_value->field_callIdentifier.encode_text(text_buf);
single_value->field_codecList.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
}
}

void PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_channelType.decode_text(text_buf);
single_value->field_assignmentRequirement.decode_text(text_buf);
single_value->field_cellIdentifier.decode_text(text_buf);
single_value->field_groupCallReference.decode_text(text_buf);
single_value->field_priority.decode_text(text_buf);
single_value->field_circuitIdentityCode.decode_text(text_buf);
single_value->field_downLinkDTX__Flag.decode_text(text_buf);
single_value->field_encryptionInformation.decode_text(text_buf);
single_value->field_vSTK__RAND.decode_text(text_buf);
single_value->field_vSTK.decode_text(text_buf);
single_value->field_cellIdentifierListSegment.decode_text(text_buf);
single_value->field_aoIPTransportLayer.decode_text(text_buf);
single_value->field_callIdentifier.decode_text(text_buf);
single_value->field_codecList.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__VGCS__VBSAssignmentRequest_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest.");
}
}

void PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__VGCS__VBSAssignmentRequest_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (15<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest has 15 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) channelType().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) assignmentRequirement().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) cellIdentifier().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) groupCallReference().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) priority().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) circuitIdentityCode().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) downLinkDTX__Flag().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) encryptionInformation().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) vSTK__RAND().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) vSTK().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) cellIdentifierListSegment().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) aoIPTransportLayer().set_param(*param.get_elem(12));
    if (param.get_size()>13 && param.get_elem(13)->get_type()!=Module_Param::MP_NotUsed) callIdentifier().set_param(*param.get_elem(13));
    if (param.get_size()>14 && param.get_elem(14)->get_type()!=Module_Param::MP_NotUsed) codecList().set_param(*param.get_elem(14));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "channelType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          channelType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "assignmentRequirement")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          assignmentRequirement().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "groupCallReference")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          groupCallReference().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "priority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          priority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "circuitIdentityCode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          circuitIdentityCode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "downLinkDTX_Flag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          downLinkDTX__Flag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "encryptionInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          encryptionInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vSTK_RAND")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vSTK__RAND().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vSTK")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vSTK().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentifierListSegment")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentifierListSegment().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aoIPTransportLayer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aoIPTransportLayer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "callIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          callIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "codecList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          codecList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__VGCS__VBSAssignmentRequest_template* precondition = new PDU__BSSMAP__VGCS__VBSAssignmentRequest_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__VGCS__VBSAssignmentRequest_template* implied_template = new PDU__BSSMAP__VGCS__VBSAssignmentRequest_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__VGCS__VBSAssignmentRequest_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest");
single_value->field_channelType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest");
single_value->field_assignmentRequirement.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest");
single_value->field_cellIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest");
single_value->field_groupCallReference.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest");
single_value->field_priority.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest");
single_value->field_circuitIdentityCode.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest");
single_value->field_downLinkDTX__Flag.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest");
single_value->field_encryptionInformation.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest");
single_value->field_vSTK__RAND.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest");
single_value->field_vSTK.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest");
single_value->field_cellIdentifierListSegment.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest");
single_value->field_aoIPTransportLayer.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest");
single_value->field_callIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest");
single_value->field_codecList.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentRequest");
}

boolean PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__VGCS__VBSAssignmentRequest_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__VGCS__VBSAssignmentResult::PDU__BSSMAP__VGCS__VBSAssignmentResult()
{
}

PDU__BSSMAP__VGCS__VBSAssignmentResult::PDU__BSSMAP__VGCS__VBSAssignmentResult(const OCTETSTRING& par_messageType,
    const BSSMAP__IE__ChannelType& par_channelType,
    const BSSMAP__IE__CellIdentifier& par_cellIdentifier,
    const OPTIONAL< BSSMAP__IE__ChosenChannel >& par_chosenChannel,
    const OPTIONAL< BSSMAP__IE__CircuitIdentityCode >& par_circuitIdentityCode,
    const OPTIONAL< BSSMAP__IE__CircuitPool >& par_circuitPool,
    const OPTIONAL< BSSMAP__IE__AoIP__TransportLayerAddress >& par_aoIPTransportLayer,
    const OPTIONAL< BSSMAP__IE__SpeechCodec >& par_speechCodec,
    const OPTIONAL< BSSMAP__IE__CallIdentifier >& par_callIdentifier)
  :   field_messageType(par_messageType),
  field_channelType(par_channelType),
  field_cellIdentifier(par_cellIdentifier),
  field_chosenChannel(par_chosenChannel),
  field_circuitIdentityCode(par_circuitIdentityCode),
  field_circuitPool(par_circuitPool),
  field_aoIPTransportLayer(par_aoIPTransportLayer),
  field_speechCodec(par_speechCodec),
  field_callIdentifier(par_callIdentifier)
{
}

PDU__BSSMAP__VGCS__VBSAssignmentResult::PDU__BSSMAP__VGCS__VBSAssignmentResult(const PDU__BSSMAP__VGCS__VBSAssignmentResult& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.channelType().is_bound()) field_channelType = other_value.channelType();
else field_channelType.clean_up();
if (other_value.cellIdentifier().is_bound()) field_cellIdentifier = other_value.cellIdentifier();
else field_cellIdentifier.clean_up();
if (other_value.chosenChannel().is_bound()) field_chosenChannel = other_value.chosenChannel();
else field_chosenChannel.clean_up();
if (other_value.circuitIdentityCode().is_bound()) field_circuitIdentityCode = other_value.circuitIdentityCode();
else field_circuitIdentityCode.clean_up();
if (other_value.circuitPool().is_bound()) field_circuitPool = other_value.circuitPool();
else field_circuitPool.clean_up();
if (other_value.aoIPTransportLayer().is_bound()) field_aoIPTransportLayer = other_value.aoIPTransportLayer();
else field_aoIPTransportLayer.clean_up();
if (other_value.speechCodec().is_bound()) field_speechCodec = other_value.speechCodec();
else field_speechCodec.clean_up();
if (other_value.callIdentifier().is_bound()) field_callIdentifier = other_value.callIdentifier();
else field_callIdentifier.clean_up();
}

void PDU__BSSMAP__VGCS__VBSAssignmentResult::clean_up()
{
field_messageType.clean_up();
field_channelType.clean_up();
field_cellIdentifier.clean_up();
field_chosenChannel.clean_up();
field_circuitIdentityCode.clean_up();
field_circuitPool.clean_up();
field_aoIPTransportLayer.clean_up();
field_speechCodec.clean_up();
field_callIdentifier.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__VGCS__VBSAssignmentResult::get_descriptor() const { return &PDU__BSSMAP__VGCS__VBSAssignmentResult_descr_; }
PDU__BSSMAP__VGCS__VBSAssignmentResult& PDU__BSSMAP__VGCS__VBSAssignmentResult::operator=(const PDU__BSSMAP__VGCS__VBSAssignmentResult& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.channelType().is_bound()) field_channelType = other_value.channelType();
  else field_channelType.clean_up();
  if (other_value.cellIdentifier().is_bound()) field_cellIdentifier = other_value.cellIdentifier();
  else field_cellIdentifier.clean_up();
  if (other_value.chosenChannel().is_bound()) field_chosenChannel = other_value.chosenChannel();
  else field_chosenChannel.clean_up();
  if (other_value.circuitIdentityCode().is_bound()) field_circuitIdentityCode = other_value.circuitIdentityCode();
  else field_circuitIdentityCode.clean_up();
  if (other_value.circuitPool().is_bound()) field_circuitPool = other_value.circuitPool();
  else field_circuitPool.clean_up();
  if (other_value.aoIPTransportLayer().is_bound()) field_aoIPTransportLayer = other_value.aoIPTransportLayer();
  else field_aoIPTransportLayer.clean_up();
  if (other_value.speechCodec().is_bound()) field_speechCodec = other_value.speechCodec();
  else field_speechCodec.clean_up();
  if (other_value.callIdentifier().is_bound()) field_callIdentifier = other_value.callIdentifier();
  else field_callIdentifier.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__VGCS__VBSAssignmentResult::operator==(const PDU__BSSMAP__VGCS__VBSAssignmentResult& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_channelType==other_value.field_channelType
  && field_cellIdentifier==other_value.field_cellIdentifier
  && field_chosenChannel==other_value.field_chosenChannel
  && field_circuitIdentityCode==other_value.field_circuitIdentityCode
  && field_circuitPool==other_value.field_circuitPool
  && field_aoIPTransportLayer==other_value.field_aoIPTransportLayer
  && field_speechCodec==other_value.field_speechCodec
  && field_callIdentifier==other_value.field_callIdentifier;
}

boolean PDU__BSSMAP__VGCS__VBSAssignmentResult::is_bound() const
{
return (field_messageType.is_bound())
  || (field_channelType.is_bound())
  || (field_cellIdentifier.is_bound())
  || (OPTIONAL_OMIT == field_chosenChannel.get_selection() || field_chosenChannel.is_bound())
  || (OPTIONAL_OMIT == field_circuitIdentityCode.get_selection() || field_circuitIdentityCode.is_bound())
  || (OPTIONAL_OMIT == field_circuitPool.get_selection() || field_circuitPool.is_bound())
  || (OPTIONAL_OMIT == field_aoIPTransportLayer.get_selection() || field_aoIPTransportLayer.is_bound())
  || (OPTIONAL_OMIT == field_speechCodec.get_selection() || field_speechCodec.is_bound())
  || (OPTIONAL_OMIT == field_callIdentifier.get_selection() || field_callIdentifier.is_bound());
}
boolean PDU__BSSMAP__VGCS__VBSAssignmentResult::is_value() const
{
return field_messageType.is_value()
  && field_channelType.is_value()
  && field_cellIdentifier.is_value()
  && (OPTIONAL_OMIT == field_chosenChannel.get_selection() || field_chosenChannel.is_value())
  && (OPTIONAL_OMIT == field_circuitIdentityCode.get_selection() || field_circuitIdentityCode.is_value())
  && (OPTIONAL_OMIT == field_circuitPool.get_selection() || field_circuitPool.is_value())
  && (OPTIONAL_OMIT == field_aoIPTransportLayer.get_selection() || field_aoIPTransportLayer.is_value())
  && (OPTIONAL_OMIT == field_speechCodec.get_selection() || field_speechCodec.is_value())
  && (OPTIONAL_OMIT == field_callIdentifier.get_selection() || field_callIdentifier.is_value());
}
int PDU__BSSMAP__VGCS__VBSAssignmentResult::size_of() const
{
  int ret_val = 3;
  if (field_chosenChannel.ispresent()) ret_val++;
  if (field_circuitIdentityCode.ispresent()) ret_val++;
  if (field_circuitPool.ispresent()) ret_val++;
  if (field_aoIPTransportLayer.ispresent()) ret_val++;
  if (field_speechCodec.ispresent()) ret_val++;
  if (field_callIdentifier.ispresent()) ret_val++;
  return ret_val;
}

void PDU__BSSMAP__VGCS__VBSAssignmentResult::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", channelType := ");
field_channelType.log();
TTCN_Logger::log_event_str(", cellIdentifier := ");
field_cellIdentifier.log();
TTCN_Logger::log_event_str(", chosenChannel := ");
field_chosenChannel.log();
TTCN_Logger::log_event_str(", circuitIdentityCode := ");
field_circuitIdentityCode.log();
TTCN_Logger::log_event_str(", circuitPool := ");
field_circuitPool.log();
TTCN_Logger::log_event_str(", aoIPTransportLayer := ");
field_aoIPTransportLayer.log();
TTCN_Logger::log_event_str(", speechCodec := ");
field_speechCodec.log();
TTCN_Logger::log_event_str(", callIdentifier := ");
field_callIdentifier.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__VGCS__VBSAssignmentResult::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (channelType().is_bound()) channelType().set_implicit_omit();
if (cellIdentifier().is_bound()) cellIdentifier().set_implicit_omit();
if (!chosenChannel().is_bound()) chosenChannel() = OMIT_VALUE;
else chosenChannel().set_implicit_omit();
if (!circuitIdentityCode().is_bound()) circuitIdentityCode() = OMIT_VALUE;
else circuitIdentityCode().set_implicit_omit();
if (!circuitPool().is_bound()) circuitPool() = OMIT_VALUE;
else circuitPool().set_implicit_omit();
if (!aoIPTransportLayer().is_bound()) aoIPTransportLayer() = OMIT_VALUE;
else aoIPTransportLayer().set_implicit_omit();
if (!speechCodec().is_bound()) speechCodec() = OMIT_VALUE;
else speechCodec().set_implicit_omit();
if (!callIdentifier().is_bound()) callIdentifier() = OMIT_VALUE;
else callIdentifier().set_implicit_omit();
}

void PDU__BSSMAP__VGCS__VBSAssignmentResult::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (9<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult has 9 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) channelType().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cellIdentifier().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) chosenChannel().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) circuitIdentityCode().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) circuitPool().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) aoIPTransportLayer().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) speechCodec().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) callIdentifier().set_param(*param.get_elem(8));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "channelType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          channelType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "chosenChannel")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          chosenChannel().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "circuitIdentityCode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          circuitIdentityCode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "circuitPool")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          circuitPool().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aoIPTransportLayer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aoIPTransportLayer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "speechCodec")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          speechCodec().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "callIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          callIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult");
  }
}

void PDU__BSSMAP__VGCS__VBSAssignmentResult::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_channelType.encode_text(text_buf);
field_cellIdentifier.encode_text(text_buf);
field_chosenChannel.encode_text(text_buf);
field_circuitIdentityCode.encode_text(text_buf);
field_circuitPool.encode_text(text_buf);
field_aoIPTransportLayer.encode_text(text_buf);
field_speechCodec.encode_text(text_buf);
field_callIdentifier.encode_text(text_buf);
}

void PDU__BSSMAP__VGCS__VBSAssignmentResult::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_channelType.decode_text(text_buf);
field_cellIdentifier.decode_text(text_buf);
field_chosenChannel.decode_text(text_buf);
field_circuitIdentityCode.decode_text(text_buf);
field_circuitPool.decode_text(text_buf);
field_aoIPTransportLayer.decode_text(text_buf);
field_speechCodec.decode_text(text_buf);
field_callIdentifier.decode_text(text_buf);
}

void PDU__BSSMAP__VGCS__VBSAssignmentResult::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__VGCS__VBSAssignmentResult::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__VGCS__VBSAssignmentResult::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__ChannelType_descr_.raw->forceomit);
  decoded_field_length = field_channelType.RAW_decode(BSSMAP__IE__ChannelType_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, BSSMAP__IE__CellIdentifier_descr_.raw->forceomit);
  decoded_field_length = field_cellIdentifier.RAW_decode(BSSMAP__IE__CellIdentifier_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_chosenChannel = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, BSSMAP__IE__ChosenChannel_descr_.raw->forceomit);
  decoded_field_length = field_chosenChannel().RAW_decode(BSSMAP__IE__ChosenChannel_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_chosenChannel = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_chosenChannel=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_circuitIdentityCode = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, BSSMAP__IE__CircuitIdentityCode_descr_.raw->forceomit);
  decoded_field_length = field_circuitIdentityCode().RAW_decode(BSSMAP__IE__CircuitIdentityCode_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_circuitIdentityCode = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_circuitIdentityCode=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_circuitPool = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, BSSMAP__IE__CircuitPool_descr_.raw->forceomit);
  decoded_field_length = field_circuitPool().RAW_decode(BSSMAP__IE__CircuitPool_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_circuitPool = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_circuitPool=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(6)) {
    field_aoIPTransportLayer = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, BSSMAP__IE__AoIP__TransportLayerAddress_descr_.raw->forceomit);
  decoded_field_length = field_aoIPTransportLayer().RAW_decode(BSSMAP__IE__AoIP__TransportLayerAddress_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_aoIPTransportLayer = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_aoIPTransportLayer=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(7)) {
    field_speechCodec = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_7_force_omit(7, force_omit, BSSMAP__IE__SpeechCodec_descr_.raw->forceomit);
  decoded_field_length = field_speechCodec().RAW_decode(BSSMAP__IE__SpeechCodec_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 1) {
  field_speechCodec = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_speechCodec=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(8)) {
    field_callIdentifier = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_8_force_omit(8, force_omit, BSSMAP__IE__CallIdentifier_descr_.raw->forceomit);
  decoded_field_length = field_callIdentifier().RAW_decode(BSSMAP__IE__CallIdentifier_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 1) {
  field_callIdentifier = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_callIdentifier=OMIT_VALUE;
  if (field_messageType !=  os_119) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__VGCS__VBSAssignmentResult::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 9;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(9);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__ChannelType_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, BSSMAP__IE__CellIdentifier_descr_.raw);
  if (field_chosenChannel.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, BSSMAP__IE__ChosenChannel_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_circuitIdentityCode.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, BSSMAP__IE__CircuitIdentityCode_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  if (field_circuitPool.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, BSSMAP__IE__CircuitPool_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_aoIPTransportLayer.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, BSSMAP__IE__AoIP__TransportLayerAddress_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  if (field_speechCodec.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, BSSMAP__IE__SpeechCodec_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  if (field_callIdentifier.ispresent()) {
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, BSSMAP__IE__CallIdentifier_descr_.raw);
  }
  else myleaf.body.node.nodes[8] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_channelType.RAW_encode(BSSMAP__IE__ChannelType_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_cellIdentifier.RAW_encode(BSSMAP__IE__CellIdentifier_descr_, *myleaf.body.node.nodes[2]);
  if (field_chosenChannel.ispresent()) {
  encoded_length += field_chosenChannel().RAW_encode(BSSMAP__IE__ChosenChannel_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_circuitIdentityCode.ispresent()) {
  encoded_length += field_circuitIdentityCode().RAW_encode(BSSMAP__IE__CircuitIdentityCode_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_circuitPool.ispresent()) {
  encoded_length += field_circuitPool().RAW_encode(BSSMAP__IE__CircuitPool_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_aoIPTransportLayer.ispresent()) {
  encoded_length += field_aoIPTransportLayer().RAW_encode(BSSMAP__IE__AoIP__TransportLayerAddress_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_speechCodec.ispresent()) {
  encoded_length += field_speechCodec().RAW_encode(BSSMAP__IE__SpeechCodec_descr_, *myleaf.body.node.nodes[7]);
  }
  if (field_callIdentifier.ispresent()) {
  encoded_length += field_callIdentifier().RAW_encode(BSSMAP__IE__CallIdentifier_descr_, *myleaf.body.node.nodes[8]);
  }
  if (field_messageType !=  os_119) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_119.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__VGCS__VBSAssignmentResult_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__ChannelType_template field_channelType;
BSSMAP__IE__CellIdentifier_template field_cellIdentifier;
BSSMAP__IE__ChosenChannel_template field_chosenChannel;
BSSMAP__IE__CircuitIdentityCode_template field_circuitIdentityCode;
BSSMAP__IE__CircuitPool_template field_circuitPool;
BSSMAP__IE__AoIP__TransportLayerAddress_template field_aoIPTransportLayer;
BSSMAP__IE__SpeechCodec_template field_speechCodec;
BSSMAP__IE__CallIdentifier_template field_callIdentifier;
};

void PDU__BSSMAP__VGCS__VBSAssignmentResult_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_channelType = ANY_VALUE;
single_value->field_cellIdentifier = ANY_VALUE;
single_value->field_chosenChannel = ANY_OR_OMIT;
single_value->field_circuitIdentityCode = ANY_OR_OMIT;
single_value->field_circuitPool = ANY_OR_OMIT;
single_value->field_aoIPTransportLayer = ANY_OR_OMIT;
single_value->field_speechCodec = ANY_OR_OMIT;
single_value->field_callIdentifier = ANY_OR_OMIT;
}
}
}

void PDU__BSSMAP__VGCS__VBSAssignmentResult_template::copy_value(const PDU__BSSMAP__VGCS__VBSAssignmentResult& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.channelType().is_bound()) {
  single_value->field_channelType = other_value.channelType();
} else {
  single_value->field_channelType.clean_up();
}
if (other_value.cellIdentifier().is_bound()) {
  single_value->field_cellIdentifier = other_value.cellIdentifier();
} else {
  single_value->field_cellIdentifier.clean_up();
}
if (other_value.chosenChannel().is_bound()) {
  if (other_value.chosenChannel().ispresent()) single_value->field_chosenChannel = other_value.chosenChannel()();
  else single_value->field_chosenChannel = OMIT_VALUE;
} else {
  single_value->field_chosenChannel.clean_up();
}
if (other_value.circuitIdentityCode().is_bound()) {
  if (other_value.circuitIdentityCode().ispresent()) single_value->field_circuitIdentityCode = other_value.circuitIdentityCode()();
  else single_value->field_circuitIdentityCode = OMIT_VALUE;
} else {
  single_value->field_circuitIdentityCode.clean_up();
}
if (other_value.circuitPool().is_bound()) {
  if (other_value.circuitPool().ispresent()) single_value->field_circuitPool = other_value.circuitPool()();
  else single_value->field_circuitPool = OMIT_VALUE;
} else {
  single_value->field_circuitPool.clean_up();
}
if (other_value.aoIPTransportLayer().is_bound()) {
  if (other_value.aoIPTransportLayer().ispresent()) single_value->field_aoIPTransportLayer = other_value.aoIPTransportLayer()();
  else single_value->field_aoIPTransportLayer = OMIT_VALUE;
} else {
  single_value->field_aoIPTransportLayer.clean_up();
}
if (other_value.speechCodec().is_bound()) {
  if (other_value.speechCodec().ispresent()) single_value->field_speechCodec = other_value.speechCodec()();
  else single_value->field_speechCodec = OMIT_VALUE;
} else {
  single_value->field_speechCodec.clean_up();
}
if (other_value.callIdentifier().is_bound()) {
  if (other_value.callIdentifier().ispresent()) single_value->field_callIdentifier = other_value.callIdentifier()();
  else single_value->field_callIdentifier = OMIT_VALUE;
} else {
  single_value->field_callIdentifier.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__VGCS__VBSAssignmentResult_template::copy_template(const PDU__BSSMAP__VGCS__VBSAssignmentResult_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.channelType().get_selection()) {
single_value->field_channelType = other_value.channelType();
} else {
single_value->field_channelType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cellIdentifier().get_selection()) {
single_value->field_cellIdentifier = other_value.cellIdentifier();
} else {
single_value->field_cellIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.chosenChannel().get_selection()) {
single_value->field_chosenChannel = other_value.chosenChannel();
} else {
single_value->field_chosenChannel.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.circuitIdentityCode().get_selection()) {
single_value->field_circuitIdentityCode = other_value.circuitIdentityCode();
} else {
single_value->field_circuitIdentityCode.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.circuitPool().get_selection()) {
single_value->field_circuitPool = other_value.circuitPool();
} else {
single_value->field_circuitPool.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.aoIPTransportLayer().get_selection()) {
single_value->field_aoIPTransportLayer = other_value.aoIPTransportLayer();
} else {
single_value->field_aoIPTransportLayer.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.speechCodec().get_selection()) {
single_value->field_speechCodec = other_value.speechCodec();
} else {
single_value->field_speechCodec.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.callIdentifier().get_selection()) {
single_value->field_callIdentifier = other_value.callIdentifier();
} else {
single_value->field_callIdentifier.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__VGCS__VBSAssignmentResult_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__VGCS__VBSAssignmentResult_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__VGCS__VBSAssignmentResult_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__VGCS__VBSAssignmentResult_template::PDU__BSSMAP__VGCS__VBSAssignmentResult_template()
{
}

PDU__BSSMAP__VGCS__VBSAssignmentResult_template::PDU__BSSMAP__VGCS__VBSAssignmentResult_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__VGCS__VBSAssignmentResult_template::PDU__BSSMAP__VGCS__VBSAssignmentResult_template(const PDU__BSSMAP__VGCS__VBSAssignmentResult& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__VGCS__VBSAssignmentResult_template::PDU__BSSMAP__VGCS__VBSAssignmentResult_template(const OPTIONAL<PDU__BSSMAP__VGCS__VBSAssignmentResult>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__VGCS__VBSAssignmentResult&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult from an unbound optional field.");
}
}

PDU__BSSMAP__VGCS__VBSAssignmentResult_template::PDU__BSSMAP__VGCS__VBSAssignmentResult_template(PDU__BSSMAP__VGCS__VBSAssignmentResult_template* p_precondition, PDU__BSSMAP__VGCS__VBSAssignmentResult_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__VGCS__VBSAssignmentResult_template::PDU__BSSMAP__VGCS__VBSAssignmentResult_template(Dynamic_Match_Interface<PDU__BSSMAP__VGCS__VBSAssignmentResult>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__VGCS__VBSAssignmentResult>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__VGCS__VBSAssignmentResult_template::PDU__BSSMAP__VGCS__VBSAssignmentResult_template(const PDU__BSSMAP__VGCS__VBSAssignmentResult_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__VGCS__VBSAssignmentResult_template::~PDU__BSSMAP__VGCS__VBSAssignmentResult_template()
{
clean_up();
}

PDU__BSSMAP__VGCS__VBSAssignmentResult_template& PDU__BSSMAP__VGCS__VBSAssignmentResult_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__VGCS__VBSAssignmentResult_template& PDU__BSSMAP__VGCS__VBSAssignmentResult_template::operator=(const PDU__BSSMAP__VGCS__VBSAssignmentResult& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__VGCS__VBSAssignmentResult_template& PDU__BSSMAP__VGCS__VBSAssignmentResult_template::operator=(const OPTIONAL<PDU__BSSMAP__VGCS__VBSAssignmentResult>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__VGCS__VBSAssignmentResult&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult.");
}
return *this;
}

PDU__BSSMAP__VGCS__VBSAssignmentResult_template& PDU__BSSMAP__VGCS__VBSAssignmentResult_template::operator=(const PDU__BSSMAP__VGCS__VBSAssignmentResult_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__VGCS__VBSAssignmentResult_template::match(const PDU__BSSMAP__VGCS__VBSAssignmentResult& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.channelType().is_bound()) return FALSE;
if(!single_value->field_channelType.match(other_value.channelType(), legacy))return FALSE;
if(!other_value.cellIdentifier().is_bound()) return FALSE;
if(!single_value->field_cellIdentifier.match(other_value.cellIdentifier(), legacy))return FALSE;
if(!other_value.chosenChannel().is_bound()) return FALSE;
if((other_value.chosenChannel().ispresent() ? !single_value->field_chosenChannel.match((const BSSMAP__IE__ChosenChannel&)other_value.chosenChannel(), legacy) : !single_value->field_chosenChannel.match_omit(legacy)))return FALSE;
if(!other_value.circuitIdentityCode().is_bound()) return FALSE;
if((other_value.circuitIdentityCode().ispresent() ? !single_value->field_circuitIdentityCode.match((const BSSMAP__IE__CircuitIdentityCode&)other_value.circuitIdentityCode(), legacy) : !single_value->field_circuitIdentityCode.match_omit(legacy)))return FALSE;
if(!other_value.circuitPool().is_bound()) return FALSE;
if((other_value.circuitPool().ispresent() ? !single_value->field_circuitPool.match((const BSSMAP__IE__CircuitPool&)other_value.circuitPool(), legacy) : !single_value->field_circuitPool.match_omit(legacy)))return FALSE;
if(!other_value.aoIPTransportLayer().is_bound()) return FALSE;
if((other_value.aoIPTransportLayer().ispresent() ? !single_value->field_aoIPTransportLayer.match((const BSSMAP__IE__AoIP__TransportLayerAddress&)other_value.aoIPTransportLayer(), legacy) : !single_value->field_aoIPTransportLayer.match_omit(legacy)))return FALSE;
if(!other_value.speechCodec().is_bound()) return FALSE;
if((other_value.speechCodec().ispresent() ? !single_value->field_speechCodec.match((const BSSMAP__IE__SpeechCodec&)other_value.speechCodec(), legacy) : !single_value->field_speechCodec.match_omit(legacy)))return FALSE;
if(!other_value.callIdentifier().is_bound()) return FALSE;
if((other_value.callIdentifier().ispresent() ? !single_value->field_callIdentifier.match((const BSSMAP__IE__CallIdentifier&)other_value.callIdentifier(), legacy) : !single_value->field_callIdentifier.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult.");
}
return FALSE;
}

boolean PDU__BSSMAP__VGCS__VBSAssignmentResult_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_channelType.is_bound()
 || single_value->field_cellIdentifier.is_bound()
 || (single_value->field_chosenChannel.is_omit() || single_value->field_chosenChannel.is_bound())
 || (single_value->field_circuitIdentityCode.is_omit() || single_value->field_circuitIdentityCode.is_bound())
 || (single_value->field_circuitPool.is_omit() || single_value->field_circuitPool.is_bound())
 || (single_value->field_aoIPTransportLayer.is_omit() || single_value->field_aoIPTransportLayer.is_bound())
 || (single_value->field_speechCodec.is_omit() || single_value->field_speechCodec.is_bound())
 || (single_value->field_callIdentifier.is_omit() || single_value->field_callIdentifier.is_bound());
}

boolean PDU__BSSMAP__VGCS__VBSAssignmentResult_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_channelType.is_value()
 && single_value->field_cellIdentifier.is_value()
 && (single_value->field_chosenChannel.is_omit() || single_value->field_chosenChannel.is_value())
 && (single_value->field_circuitIdentityCode.is_omit() || single_value->field_circuitIdentityCode.is_value())
 && (single_value->field_circuitPool.is_omit() || single_value->field_circuitPool.is_value())
 && (single_value->field_aoIPTransportLayer.is_omit() || single_value->field_aoIPTransportLayer.is_value())
 && (single_value->field_speechCodec.is_omit() || single_value->field_speechCodec.is_value())
 && (single_value->field_callIdentifier.is_omit() || single_value->field_callIdentifier.is_value());
}

void PDU__BSSMAP__VGCS__VBSAssignmentResult_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__VGCS__VBSAssignmentResult PDU__BSSMAP__VGCS__VBSAssignmentResult_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult.");
PDU__BSSMAP__VGCS__VBSAssignmentResult ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_channelType.is_bound()) {
ret_val.channelType() = single_value->field_channelType.valueof();
}
if (single_value->field_cellIdentifier.is_bound()) {
ret_val.cellIdentifier() = single_value->field_cellIdentifier.valueof();
}
if (single_value->field_chosenChannel.is_omit()) ret_val.chosenChannel() = OMIT_VALUE;
else if (single_value->field_chosenChannel.is_bound()) {
ret_val.chosenChannel() = single_value->field_chosenChannel.valueof();
}
if (single_value->field_circuitIdentityCode.is_omit()) ret_val.circuitIdentityCode() = OMIT_VALUE;
else if (single_value->field_circuitIdentityCode.is_bound()) {
ret_val.circuitIdentityCode() = single_value->field_circuitIdentityCode.valueof();
}
if (single_value->field_circuitPool.is_omit()) ret_val.circuitPool() = OMIT_VALUE;
else if (single_value->field_circuitPool.is_bound()) {
ret_val.circuitPool() = single_value->field_circuitPool.valueof();
}
if (single_value->field_aoIPTransportLayer.is_omit()) ret_val.aoIPTransportLayer() = OMIT_VALUE;
else if (single_value->field_aoIPTransportLayer.is_bound()) {
ret_val.aoIPTransportLayer() = single_value->field_aoIPTransportLayer.valueof();
}
if (single_value->field_speechCodec.is_omit()) ret_val.speechCodec() = OMIT_VALUE;
else if (single_value->field_speechCodec.is_bound()) {
ret_val.speechCodec() = single_value->field_speechCodec.valueof();
}
if (single_value->field_callIdentifier.is_omit()) ret_val.callIdentifier() = OMIT_VALUE;
else if (single_value->field_callIdentifier.is_bound()) {
ret_val.callIdentifier() = single_value->field_callIdentifier.valueof();
}
return ret_val;
}

void PDU__BSSMAP__VGCS__VBSAssignmentResult_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__VGCS__VBSAssignmentResult_template[list_length];
}

PDU__BSSMAP__VGCS__VBSAssignmentResult_template& PDU__BSSMAP__VGCS__VBSAssignmentResult_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__VGCS__VBSAssignmentResult_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__VGCS__VBSAssignmentResult_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult.");
return single_value->field_messageType;
}

BSSMAP__IE__ChannelType_template& PDU__BSSMAP__VGCS__VBSAssignmentResult_template::channelType()
{
set_specific();
return single_value->field_channelType;
}

const BSSMAP__IE__ChannelType_template& PDU__BSSMAP__VGCS__VBSAssignmentResult_template::channelType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field channelType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult.");
return single_value->field_channelType;
}

BSSMAP__IE__CellIdentifier_template& PDU__BSSMAP__VGCS__VBSAssignmentResult_template::cellIdentifier()
{
set_specific();
return single_value->field_cellIdentifier;
}

const BSSMAP__IE__CellIdentifier_template& PDU__BSSMAP__VGCS__VBSAssignmentResult_template::cellIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cellIdentifier of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult.");
return single_value->field_cellIdentifier;
}

BSSMAP__IE__ChosenChannel_template& PDU__BSSMAP__VGCS__VBSAssignmentResult_template::chosenChannel()
{
set_specific();
return single_value->field_chosenChannel;
}

const BSSMAP__IE__ChosenChannel_template& PDU__BSSMAP__VGCS__VBSAssignmentResult_template::chosenChannel() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field chosenChannel of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult.");
return single_value->field_chosenChannel;
}

BSSMAP__IE__CircuitIdentityCode_template& PDU__BSSMAP__VGCS__VBSAssignmentResult_template::circuitIdentityCode()
{
set_specific();
return single_value->field_circuitIdentityCode;
}

const BSSMAP__IE__CircuitIdentityCode_template& PDU__BSSMAP__VGCS__VBSAssignmentResult_template::circuitIdentityCode() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field circuitIdentityCode of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult.");
return single_value->field_circuitIdentityCode;
}

BSSMAP__IE__CircuitPool_template& PDU__BSSMAP__VGCS__VBSAssignmentResult_template::circuitPool()
{
set_specific();
return single_value->field_circuitPool;
}

const BSSMAP__IE__CircuitPool_template& PDU__BSSMAP__VGCS__VBSAssignmentResult_template::circuitPool() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field circuitPool of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult.");
return single_value->field_circuitPool;
}

BSSMAP__IE__AoIP__TransportLayerAddress_template& PDU__BSSMAP__VGCS__VBSAssignmentResult_template::aoIPTransportLayer()
{
set_specific();
return single_value->field_aoIPTransportLayer;
}

const BSSMAP__IE__AoIP__TransportLayerAddress_template& PDU__BSSMAP__VGCS__VBSAssignmentResult_template::aoIPTransportLayer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field aoIPTransportLayer of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult.");
return single_value->field_aoIPTransportLayer;
}

BSSMAP__IE__SpeechCodec_template& PDU__BSSMAP__VGCS__VBSAssignmentResult_template::speechCodec()
{
set_specific();
return single_value->field_speechCodec;
}

const BSSMAP__IE__SpeechCodec_template& PDU__BSSMAP__VGCS__VBSAssignmentResult_template::speechCodec() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field speechCodec of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult.");
return single_value->field_speechCodec;
}

BSSMAP__IE__CallIdentifier_template& PDU__BSSMAP__VGCS__VBSAssignmentResult_template::callIdentifier()
{
set_specific();
return single_value->field_callIdentifier;
}

const BSSMAP__IE__CallIdentifier_template& PDU__BSSMAP__VGCS__VBSAssignmentResult_template::callIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field callIdentifier of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult.");
return single_value->field_callIdentifier;
}

int PDU__BSSMAP__VGCS__VBSAssignmentResult_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 3;
      if (single_value->field_chosenChannel.is_present()) ret_val++;
      if (single_value->field_circuitIdentityCode.is_present()) ret_val++;
      if (single_value->field_circuitPool.is_present()) ret_val++;
      if (single_value->field_aoIPTransportLayer.is_present()) ret_val++;
      if (single_value->field_speechCodec.is_present()) ret_val++;
      if (single_value->field_callIdentifier.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult.");
  }
  return 0;
}

void PDU__BSSMAP__VGCS__VBSAssignmentResult_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", channelType := ");
single_value->field_channelType.log();
TTCN_Logger::log_event_str(", cellIdentifier := ");
single_value->field_cellIdentifier.log();
TTCN_Logger::log_event_str(", chosenChannel := ");
single_value->field_chosenChannel.log();
TTCN_Logger::log_event_str(", circuitIdentityCode := ");
single_value->field_circuitIdentityCode.log();
TTCN_Logger::log_event_str(", circuitPool := ");
single_value->field_circuitPool.log();
TTCN_Logger::log_event_str(", aoIPTransportLayer := ");
single_value->field_aoIPTransportLayer.log();
TTCN_Logger::log_event_str(", speechCodec := ");
single_value->field_speechCodec.log();
TTCN_Logger::log_event_str(", callIdentifier := ");
single_value->field_callIdentifier.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__VGCS__VBSAssignmentResult_template::log_match(const PDU__BSSMAP__VGCS__VBSAssignmentResult& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_channelType.match(match_value.channelType(), legacy)){
TTCN_Logger::log_logmatch_info(".channelType");
single_value->field_channelType.log_match(match_value.channelType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cellIdentifier.match(match_value.cellIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".cellIdentifier");
single_value->field_cellIdentifier.log_match(match_value.cellIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.chosenChannel().ispresent()){
if(!single_value->field_chosenChannel.match(match_value.chosenChannel(), legacy)){
TTCN_Logger::log_logmatch_info(".chosenChannel");
single_value->field_chosenChannel.log_match(match_value.chosenChannel(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_chosenChannel.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".chosenChannel := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_chosenChannel.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.circuitIdentityCode().ispresent()){
if(!single_value->field_circuitIdentityCode.match(match_value.circuitIdentityCode(), legacy)){
TTCN_Logger::log_logmatch_info(".circuitIdentityCode");
single_value->field_circuitIdentityCode.log_match(match_value.circuitIdentityCode(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_circuitIdentityCode.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".circuitIdentityCode := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_circuitIdentityCode.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.circuitPool().ispresent()){
if(!single_value->field_circuitPool.match(match_value.circuitPool(), legacy)){
TTCN_Logger::log_logmatch_info(".circuitPool");
single_value->field_circuitPool.log_match(match_value.circuitPool(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_circuitPool.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".circuitPool := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_circuitPool.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.aoIPTransportLayer().ispresent()){
if(!single_value->field_aoIPTransportLayer.match(match_value.aoIPTransportLayer(), legacy)){
TTCN_Logger::log_logmatch_info(".aoIPTransportLayer");
single_value->field_aoIPTransportLayer.log_match(match_value.aoIPTransportLayer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_aoIPTransportLayer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".aoIPTransportLayer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_aoIPTransportLayer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.speechCodec().ispresent()){
if(!single_value->field_speechCodec.match(match_value.speechCodec(), legacy)){
TTCN_Logger::log_logmatch_info(".speechCodec");
single_value->field_speechCodec.log_match(match_value.speechCodec(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_speechCodec.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".speechCodec := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_speechCodec.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.callIdentifier().ispresent()){
if(!single_value->field_callIdentifier.match(match_value.callIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".callIdentifier");
single_value->field_callIdentifier.log_match(match_value.callIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_callIdentifier.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".callIdentifier := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_callIdentifier.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", channelType := ");
single_value->field_channelType.log_match(match_value.channelType(), legacy);
TTCN_Logger::log_event_str(", cellIdentifier := ");
single_value->field_cellIdentifier.log_match(match_value.cellIdentifier(), legacy);
TTCN_Logger::log_event_str(", chosenChannel := ");
if (match_value.chosenChannel().ispresent()) {
single_value->field_chosenChannel.log_match(match_value.chosenChannel(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_chosenChannel.log();
if (single_value->field_chosenChannel.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", circuitIdentityCode := ");
if (match_value.circuitIdentityCode().ispresent()) {
single_value->field_circuitIdentityCode.log_match(match_value.circuitIdentityCode(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_circuitIdentityCode.log();
if (single_value->field_circuitIdentityCode.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", circuitPool := ");
if (match_value.circuitPool().ispresent()) {
single_value->field_circuitPool.log_match(match_value.circuitPool(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_circuitPool.log();
if (single_value->field_circuitPool.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", aoIPTransportLayer := ");
if (match_value.aoIPTransportLayer().ispresent()) {
single_value->field_aoIPTransportLayer.log_match(match_value.aoIPTransportLayer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_aoIPTransportLayer.log();
if (single_value->field_aoIPTransportLayer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", speechCodec := ");
if (match_value.speechCodec().ispresent()) {
single_value->field_speechCodec.log_match(match_value.speechCodec(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_speechCodec.log();
if (single_value->field_speechCodec.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", callIdentifier := ");
if (match_value.callIdentifier().ispresent()) {
single_value->field_callIdentifier.log_match(match_value.callIdentifier(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_callIdentifier.log();
if (single_value->field_callIdentifier.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__VGCS__VBSAssignmentResult_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (channelType().is_bound()) channelType().set_implicit_omit();
if (cellIdentifier().is_bound()) cellIdentifier().set_implicit_omit();
if (!chosenChannel().is_bound()) chosenChannel() = OMIT_VALUE;
else chosenChannel().set_implicit_omit();
if (!circuitIdentityCode().is_bound()) circuitIdentityCode() = OMIT_VALUE;
else circuitIdentityCode().set_implicit_omit();
if (!circuitPool().is_bound()) circuitPool() = OMIT_VALUE;
else circuitPool().set_implicit_omit();
if (!aoIPTransportLayer().is_bound()) aoIPTransportLayer() = OMIT_VALUE;
else aoIPTransportLayer().set_implicit_omit();
if (!speechCodec().is_bound()) speechCodec() = OMIT_VALUE;
else speechCodec().set_implicit_omit();
if (!callIdentifier().is_bound()) callIdentifier() = OMIT_VALUE;
else callIdentifier().set_implicit_omit();
}

void PDU__BSSMAP__VGCS__VBSAssignmentResult_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_channelType.encode_text(text_buf);
single_value->field_cellIdentifier.encode_text(text_buf);
single_value->field_chosenChannel.encode_text(text_buf);
single_value->field_circuitIdentityCode.encode_text(text_buf);
single_value->field_circuitPool.encode_text(text_buf);
single_value->field_aoIPTransportLayer.encode_text(text_buf);
single_value->field_speechCodec.encode_text(text_buf);
single_value->field_callIdentifier.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult.");
}
}

void PDU__BSSMAP__VGCS__VBSAssignmentResult_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_channelType.decode_text(text_buf);
single_value->field_cellIdentifier.decode_text(text_buf);
single_value->field_chosenChannel.decode_text(text_buf);
single_value->field_circuitIdentityCode.decode_text(text_buf);
single_value->field_circuitPool.decode_text(text_buf);
single_value->field_aoIPTransportLayer.decode_text(text_buf);
single_value->field_speechCodec.decode_text(text_buf);
single_value->field_callIdentifier.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__VGCS__VBSAssignmentResult_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult.");
}
}

void PDU__BSSMAP__VGCS__VBSAssignmentResult_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__VGCS__VBSAssignmentResult_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (9<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult has 9 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) channelType().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cellIdentifier().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) chosenChannel().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) circuitIdentityCode().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) circuitPool().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) aoIPTransportLayer().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) speechCodec().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) callIdentifier().set_param(*param.get_elem(8));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "channelType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          channelType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "chosenChannel")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          chosenChannel().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "circuitIdentityCode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          circuitIdentityCode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "circuitPool")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          circuitPool().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aoIPTransportLayer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aoIPTransportLayer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "speechCodec")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          speechCodec().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "callIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          callIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__VGCS__VBSAssignmentResult_template* precondition = new PDU__BSSMAP__VGCS__VBSAssignmentResult_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__VGCS__VBSAssignmentResult_template* implied_template = new PDU__BSSMAP__VGCS__VBSAssignmentResult_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__VGCS__VBSAssignmentResult_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__VGCS__VBSAssignmentResult_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult");
single_value->field_channelType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult");
single_value->field_cellIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult");
single_value->field_chosenChannel.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult");
single_value->field_circuitIdentityCode.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult");
single_value->field_circuitPool.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult");
single_value->field_aoIPTransportLayer.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult");
single_value->field_speechCodec.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult");
single_value->field_callIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentResult");
}

boolean PDU__BSSMAP__VGCS__VBSAssignmentResult_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__VGCS__VBSAssignmentResult_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__VGCS__VBSAssignmentFailure::PDU__BSSMAP__VGCS__VBSAssignmentFailure()
{
}

PDU__BSSMAP__VGCS__VBSAssignmentFailure::PDU__BSSMAP__VGCS__VBSAssignmentFailure(const OCTETSTRING& par_messageType,
    const BSSMAP__IE__Cause& par_cause,
    const OPTIONAL< BSSMAP__IE__CircuitPool >& par_circuitPool,
    const OPTIONAL< BSSMAP__IE__CircuitPoolList >& par_circuitPoolList,
    const OPTIONAL< BSSMAP__IE__SpeechCodecList >& par_codecList)
  :   field_messageType(par_messageType),
  field_cause(par_cause),
  field_circuitPool(par_circuitPool),
  field_circuitPoolList(par_circuitPoolList),
  field_codecList(par_codecList)
{
}

PDU__BSSMAP__VGCS__VBSAssignmentFailure::PDU__BSSMAP__VGCS__VBSAssignmentFailure(const PDU__BSSMAP__VGCS__VBSAssignmentFailure& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.cause().is_bound()) field_cause = other_value.cause();
else field_cause.clean_up();
if (other_value.circuitPool().is_bound()) field_circuitPool = other_value.circuitPool();
else field_circuitPool.clean_up();
if (other_value.circuitPoolList().is_bound()) field_circuitPoolList = other_value.circuitPoolList();
else field_circuitPoolList.clean_up();
if (other_value.codecList().is_bound()) field_codecList = other_value.codecList();
else field_codecList.clean_up();
}

void PDU__BSSMAP__VGCS__VBSAssignmentFailure::clean_up()
{
field_messageType.clean_up();
field_cause.clean_up();
field_circuitPool.clean_up();
field_circuitPoolList.clean_up();
field_codecList.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__VGCS__VBSAssignmentFailure::get_descriptor() const { return &PDU__BSSMAP__VGCS__VBSAssignmentFailure_descr_; }
PDU__BSSMAP__VGCS__VBSAssignmentFailure& PDU__BSSMAP__VGCS__VBSAssignmentFailure::operator=(const PDU__BSSMAP__VGCS__VBSAssignmentFailure& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.cause().is_bound()) field_cause = other_value.cause();
  else field_cause.clean_up();
  if (other_value.circuitPool().is_bound()) field_circuitPool = other_value.circuitPool();
  else field_circuitPool.clean_up();
  if (other_value.circuitPoolList().is_bound()) field_circuitPoolList = other_value.circuitPoolList();
  else field_circuitPoolList.clean_up();
  if (other_value.codecList().is_bound()) field_codecList = other_value.codecList();
  else field_codecList.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__VGCS__VBSAssignmentFailure::operator==(const PDU__BSSMAP__VGCS__VBSAssignmentFailure& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_cause==other_value.field_cause
  && field_circuitPool==other_value.field_circuitPool
  && field_circuitPoolList==other_value.field_circuitPoolList
  && field_codecList==other_value.field_codecList;
}

boolean PDU__BSSMAP__VGCS__VBSAssignmentFailure::is_bound() const
{
return (field_messageType.is_bound())
  || (field_cause.is_bound())
  || (OPTIONAL_OMIT == field_circuitPool.get_selection() || field_circuitPool.is_bound())
  || (OPTIONAL_OMIT == field_circuitPoolList.get_selection() || field_circuitPoolList.is_bound())
  || (OPTIONAL_OMIT == field_codecList.get_selection() || field_codecList.is_bound());
}
boolean PDU__BSSMAP__VGCS__VBSAssignmentFailure::is_value() const
{
return field_messageType.is_value()
  && field_cause.is_value()
  && (OPTIONAL_OMIT == field_circuitPool.get_selection() || field_circuitPool.is_value())
  && (OPTIONAL_OMIT == field_circuitPoolList.get_selection() || field_circuitPoolList.is_value())
  && (OPTIONAL_OMIT == field_codecList.get_selection() || field_codecList.is_value());
}
int PDU__BSSMAP__VGCS__VBSAssignmentFailure::size_of() const
{
  int ret_val = 2;
  if (field_circuitPool.ispresent()) ret_val++;
  if (field_circuitPoolList.ispresent()) ret_val++;
  if (field_codecList.ispresent()) ret_val++;
  return ret_val;
}

void PDU__BSSMAP__VGCS__VBSAssignmentFailure::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", cause := ");
field_cause.log();
TTCN_Logger::log_event_str(", circuitPool := ");
field_circuitPool.log();
TTCN_Logger::log_event_str(", circuitPoolList := ");
field_circuitPoolList.log();
TTCN_Logger::log_event_str(", codecList := ");
field_codecList.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__VGCS__VBSAssignmentFailure::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (cause().is_bound()) cause().set_implicit_omit();
if (!circuitPool().is_bound()) circuitPool() = OMIT_VALUE;
else circuitPool().set_implicit_omit();
if (!circuitPoolList().is_bound()) circuitPoolList() = OMIT_VALUE;
else circuitPoolList().set_implicit_omit();
if (!codecList().is_bound()) codecList() = OMIT_VALUE;
else codecList().set_implicit_omit();
}

void PDU__BSSMAP__VGCS__VBSAssignmentFailure::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) circuitPool().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) circuitPoolList().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) codecList().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "circuitPool")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          circuitPool().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "circuitPoolList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          circuitPoolList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "codecList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          codecList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure");
  }
}

void PDU__BSSMAP__VGCS__VBSAssignmentFailure::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_cause.encode_text(text_buf);
field_circuitPool.encode_text(text_buf);
field_circuitPoolList.encode_text(text_buf);
field_codecList.encode_text(text_buf);
}

void PDU__BSSMAP__VGCS__VBSAssignmentFailure::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_cause.decode_text(text_buf);
field_circuitPool.decode_text(text_buf);
field_circuitPoolList.decode_text(text_buf);
field_codecList.decode_text(text_buf);
}

void PDU__BSSMAP__VGCS__VBSAssignmentFailure::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__VGCS__VBSAssignmentFailure::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__VGCS__VBSAssignmentFailure::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__Cause_descr_.raw->forceomit);
  decoded_field_length = field_cause.RAW_decode(BSSMAP__IE__Cause_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_circuitPool = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, BSSMAP__IE__CircuitPool_descr_.raw->forceomit);
  decoded_field_length = field_circuitPool().RAW_decode(BSSMAP__IE__CircuitPool_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_circuitPool = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_circuitPool=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_circuitPoolList = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, BSSMAP__IE__CircuitPoolList_descr_.raw->forceomit);
  decoded_field_length = field_circuitPoolList().RAW_decode(BSSMAP__IE__CircuitPoolList_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_circuitPoolList = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_circuitPoolList=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_codecList = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, BSSMAP__IE__SpeechCodecList_descr_.raw->forceomit);
  decoded_field_length = field_codecList().RAW_decode(BSSMAP__IE__SpeechCodecList_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_codecList = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_codecList=OMIT_VALUE;
  if (field_messageType !=  os_78) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__VGCS__VBSAssignmentFailure::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__Cause_descr_.raw);
  if (field_circuitPool.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, BSSMAP__IE__CircuitPool_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_circuitPoolList.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, BSSMAP__IE__CircuitPoolList_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_codecList.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, BSSMAP__IE__SpeechCodecList_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_cause.RAW_encode(BSSMAP__IE__Cause_descr_, *myleaf.body.node.nodes[1]);
  if (field_circuitPool.ispresent()) {
  encoded_length += field_circuitPool().RAW_encode(BSSMAP__IE__CircuitPool_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_circuitPoolList.ispresent()) {
  encoded_length += field_circuitPoolList().RAW_encode(BSSMAP__IE__CircuitPoolList_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_codecList.ispresent()) {
  encoded_length += field_codecList().RAW_encode(BSSMAP__IE__SpeechCodecList_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_messageType !=  os_78) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_78.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__Cause_template field_cause;
BSSMAP__IE__CircuitPool_template field_circuitPool;
BSSMAP__IE__CircuitPoolList_template field_circuitPoolList;
BSSMAP__IE__SpeechCodecList_template field_codecList;
};

void PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_cause = ANY_VALUE;
single_value->field_circuitPool = ANY_OR_OMIT;
single_value->field_circuitPoolList = ANY_OR_OMIT;
single_value->field_codecList = ANY_OR_OMIT;
}
}
}

void PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::copy_value(const PDU__BSSMAP__VGCS__VBSAssignmentFailure& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.cause().is_bound()) {
  single_value->field_cause = other_value.cause();
} else {
  single_value->field_cause.clean_up();
}
if (other_value.circuitPool().is_bound()) {
  if (other_value.circuitPool().ispresent()) single_value->field_circuitPool = other_value.circuitPool()();
  else single_value->field_circuitPool = OMIT_VALUE;
} else {
  single_value->field_circuitPool.clean_up();
}
if (other_value.circuitPoolList().is_bound()) {
  if (other_value.circuitPoolList().ispresent()) single_value->field_circuitPoolList = other_value.circuitPoolList()();
  else single_value->field_circuitPoolList = OMIT_VALUE;
} else {
  single_value->field_circuitPoolList.clean_up();
}
if (other_value.codecList().is_bound()) {
  if (other_value.codecList().ispresent()) single_value->field_codecList = other_value.codecList()();
  else single_value->field_codecList = OMIT_VALUE;
} else {
  single_value->field_codecList.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::copy_template(const PDU__BSSMAP__VGCS__VBSAssignmentFailure_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cause().get_selection()) {
single_value->field_cause = other_value.cause();
} else {
single_value->field_cause.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.circuitPool().get_selection()) {
single_value->field_circuitPool = other_value.circuitPool();
} else {
single_value->field_circuitPool.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.circuitPoolList().get_selection()) {
single_value->field_circuitPoolList = other_value.circuitPoolList();
} else {
single_value->field_circuitPoolList.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.codecList().get_selection()) {
single_value->field_codecList = other_value.codecList();
} else {
single_value->field_codecList.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__VGCS__VBSAssignmentFailure_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__VGCS__VBSAssignmentFailure_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__VGCS__VBSAssignmentFailure_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::PDU__BSSMAP__VGCS__VBSAssignmentFailure_template()
{
}

PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::PDU__BSSMAP__VGCS__VBSAssignmentFailure_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::PDU__BSSMAP__VGCS__VBSAssignmentFailure_template(const PDU__BSSMAP__VGCS__VBSAssignmentFailure& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::PDU__BSSMAP__VGCS__VBSAssignmentFailure_template(const OPTIONAL<PDU__BSSMAP__VGCS__VBSAssignmentFailure>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__VGCS__VBSAssignmentFailure&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure from an unbound optional field.");
}
}

PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::PDU__BSSMAP__VGCS__VBSAssignmentFailure_template(PDU__BSSMAP__VGCS__VBSAssignmentFailure_template* p_precondition, PDU__BSSMAP__VGCS__VBSAssignmentFailure_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::PDU__BSSMAP__VGCS__VBSAssignmentFailure_template(Dynamic_Match_Interface<PDU__BSSMAP__VGCS__VBSAssignmentFailure>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__VGCS__VBSAssignmentFailure>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::PDU__BSSMAP__VGCS__VBSAssignmentFailure_template(const PDU__BSSMAP__VGCS__VBSAssignmentFailure_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::~PDU__BSSMAP__VGCS__VBSAssignmentFailure_template()
{
clean_up();
}

PDU__BSSMAP__VGCS__VBSAssignmentFailure_template& PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__VGCS__VBSAssignmentFailure_template& PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::operator=(const PDU__BSSMAP__VGCS__VBSAssignmentFailure& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__VGCS__VBSAssignmentFailure_template& PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::operator=(const OPTIONAL<PDU__BSSMAP__VGCS__VBSAssignmentFailure>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__VGCS__VBSAssignmentFailure&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure.");
}
return *this;
}

PDU__BSSMAP__VGCS__VBSAssignmentFailure_template& PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::operator=(const PDU__BSSMAP__VGCS__VBSAssignmentFailure_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::match(const PDU__BSSMAP__VGCS__VBSAssignmentFailure& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.cause().is_bound()) return FALSE;
if(!single_value->field_cause.match(other_value.cause(), legacy))return FALSE;
if(!other_value.circuitPool().is_bound()) return FALSE;
if((other_value.circuitPool().ispresent() ? !single_value->field_circuitPool.match((const BSSMAP__IE__CircuitPool&)other_value.circuitPool(), legacy) : !single_value->field_circuitPool.match_omit(legacy)))return FALSE;
if(!other_value.circuitPoolList().is_bound()) return FALSE;
if((other_value.circuitPoolList().ispresent() ? !single_value->field_circuitPoolList.match((const BSSMAP__IE__CircuitPoolList&)other_value.circuitPoolList(), legacy) : !single_value->field_circuitPoolList.match_omit(legacy)))return FALSE;
if(!other_value.codecList().is_bound()) return FALSE;
if((other_value.codecList().ispresent() ? !single_value->field_codecList.match((const BSSMAP__IE__SpeechCodecList&)other_value.codecList(), legacy) : !single_value->field_codecList.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure.");
}
return FALSE;
}

boolean PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_cause.is_bound()
 || (single_value->field_circuitPool.is_omit() || single_value->field_circuitPool.is_bound())
 || (single_value->field_circuitPoolList.is_omit() || single_value->field_circuitPoolList.is_bound())
 || (single_value->field_codecList.is_omit() || single_value->field_codecList.is_bound());
}

boolean PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_cause.is_value()
 && (single_value->field_circuitPool.is_omit() || single_value->field_circuitPool.is_value())
 && (single_value->field_circuitPoolList.is_omit() || single_value->field_circuitPoolList.is_value())
 && (single_value->field_codecList.is_omit() || single_value->field_codecList.is_value());
}

void PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__VGCS__VBSAssignmentFailure PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure.");
PDU__BSSMAP__VGCS__VBSAssignmentFailure ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_cause.is_bound()) {
ret_val.cause() = single_value->field_cause.valueof();
}
if (single_value->field_circuitPool.is_omit()) ret_val.circuitPool() = OMIT_VALUE;
else if (single_value->field_circuitPool.is_bound()) {
ret_val.circuitPool() = single_value->field_circuitPool.valueof();
}
if (single_value->field_circuitPoolList.is_omit()) ret_val.circuitPoolList() = OMIT_VALUE;
else if (single_value->field_circuitPoolList.is_bound()) {
ret_val.circuitPoolList() = single_value->field_circuitPoolList.valueof();
}
if (single_value->field_codecList.is_omit()) ret_val.codecList() = OMIT_VALUE;
else if (single_value->field_codecList.is_bound()) {
ret_val.codecList() = single_value->field_codecList.valueof();
}
return ret_val;
}

void PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__VGCS__VBSAssignmentFailure_template[list_length];
}

PDU__BSSMAP__VGCS__VBSAssignmentFailure_template& PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure.");
return single_value->field_messageType;
}

BSSMAP__IE__Cause_template& PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::cause()
{
set_specific();
return single_value->field_cause;
}

const BSSMAP__IE__Cause_template& PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::cause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cause of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure.");
return single_value->field_cause;
}

BSSMAP__IE__CircuitPool_template& PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::circuitPool()
{
set_specific();
return single_value->field_circuitPool;
}

const BSSMAP__IE__CircuitPool_template& PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::circuitPool() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field circuitPool of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure.");
return single_value->field_circuitPool;
}

BSSMAP__IE__CircuitPoolList_template& PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::circuitPoolList()
{
set_specific();
return single_value->field_circuitPoolList;
}

const BSSMAP__IE__CircuitPoolList_template& PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::circuitPoolList() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field circuitPoolList of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure.");
return single_value->field_circuitPoolList;
}

BSSMAP__IE__SpeechCodecList_template& PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::codecList()
{
set_specific();
return single_value->field_codecList;
}

const BSSMAP__IE__SpeechCodecList_template& PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::codecList() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field codecList of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure.");
return single_value->field_codecList;
}

int PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_circuitPool.is_present()) ret_val++;
      if (single_value->field_circuitPoolList.is_present()) ret_val++;
      if (single_value->field_codecList.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure.");
  }
  return 0;
}

void PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log();
TTCN_Logger::log_event_str(", circuitPool := ");
single_value->field_circuitPool.log();
TTCN_Logger::log_event_str(", circuitPoolList := ");
single_value->field_circuitPoolList.log();
TTCN_Logger::log_event_str(", codecList := ");
single_value->field_codecList.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::log_match(const PDU__BSSMAP__VGCS__VBSAssignmentFailure& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cause.match(match_value.cause(), legacy)){
TTCN_Logger::log_logmatch_info(".cause");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.circuitPool().ispresent()){
if(!single_value->field_circuitPool.match(match_value.circuitPool(), legacy)){
TTCN_Logger::log_logmatch_info(".circuitPool");
single_value->field_circuitPool.log_match(match_value.circuitPool(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_circuitPool.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".circuitPool := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_circuitPool.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.circuitPoolList().ispresent()){
if(!single_value->field_circuitPoolList.match(match_value.circuitPoolList(), legacy)){
TTCN_Logger::log_logmatch_info(".circuitPoolList");
single_value->field_circuitPoolList.log_match(match_value.circuitPoolList(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_circuitPoolList.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".circuitPoolList := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_circuitPoolList.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.codecList().ispresent()){
if(!single_value->field_codecList.match(match_value.codecList(), legacy)){
TTCN_Logger::log_logmatch_info(".codecList");
single_value->field_codecList.log_match(match_value.codecList(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_codecList.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".codecList := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_codecList.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::log_event_str(", circuitPool := ");
if (match_value.circuitPool().ispresent()) {
single_value->field_circuitPool.log_match(match_value.circuitPool(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_circuitPool.log();
if (single_value->field_circuitPool.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", circuitPoolList := ");
if (match_value.circuitPoolList().ispresent()) {
single_value->field_circuitPoolList.log_match(match_value.circuitPoolList(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_circuitPoolList.log();
if (single_value->field_circuitPoolList.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", codecList := ");
if (match_value.codecList().ispresent()) {
single_value->field_codecList.log_match(match_value.codecList(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_codecList.log();
if (single_value->field_codecList.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (cause().is_bound()) cause().set_implicit_omit();
if (!circuitPool().is_bound()) circuitPool() = OMIT_VALUE;
else circuitPool().set_implicit_omit();
if (!circuitPoolList().is_bound()) circuitPoolList() = OMIT_VALUE;
else circuitPoolList().set_implicit_omit();
if (!codecList().is_bound()) codecList() = OMIT_VALUE;
else codecList().set_implicit_omit();
}

void PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_cause.encode_text(text_buf);
single_value->field_circuitPool.encode_text(text_buf);
single_value->field_circuitPoolList.encode_text(text_buf);
single_value->field_codecList.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure.");
}
}

void PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_cause.decode_text(text_buf);
single_value->field_circuitPool.decode_text(text_buf);
single_value->field_circuitPoolList.decode_text(text_buf);
single_value->field_codecList.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__VGCS__VBSAssignmentFailure_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure.");
}
}

void PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__VGCS__VBSAssignmentFailure_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) circuitPool().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) circuitPoolList().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) codecList().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "circuitPool")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          circuitPool().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "circuitPoolList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          circuitPoolList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "codecList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          codecList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__VGCS__VBSAssignmentFailure_template* precondition = new PDU__BSSMAP__VGCS__VBSAssignmentFailure_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__VGCS__VBSAssignmentFailure_template* implied_template = new PDU__BSSMAP__VGCS__VBSAssignmentFailure_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__VGCS__VBSAssignmentFailure_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure");
single_value->field_cause.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure");
single_value->field_circuitPool.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure");
single_value->field_circuitPoolList.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure");
single_value->field_codecList.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSAssignmentFailure");
}

boolean PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__VGCS__VBSAssignmentFailure_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__VGCS__VBSQueuingIndication::PDU__BSSMAP__VGCS__VBSQueuingIndication()
{
}

PDU__BSSMAP__VGCS__VBSQueuingIndication::PDU__BSSMAP__VGCS__VBSQueuingIndication(const OCTETSTRING& par_messageType)
  :   field_messageType(par_messageType)
{
}

PDU__BSSMAP__VGCS__VBSQueuingIndication::PDU__BSSMAP__VGCS__VBSQueuingIndication(const PDU__BSSMAP__VGCS__VBSQueuingIndication& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
}

void PDU__BSSMAP__VGCS__VBSQueuingIndication::clean_up()
{
field_messageType.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__VGCS__VBSQueuingIndication::get_descriptor() const { return &PDU__BSSMAP__VGCS__VBSQueuingIndication_descr_; }
PDU__BSSMAP__VGCS__VBSQueuingIndication& PDU__BSSMAP__VGCS__VBSQueuingIndication::operator=(const PDU__BSSMAP__VGCS__VBSQueuingIndication& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__VGCS__VBSQueuingIndication::operator==(const PDU__BSSMAP__VGCS__VBSQueuingIndication& other_value) const
{
return field_messageType==other_value.field_messageType;
}

boolean PDU__BSSMAP__VGCS__VBSQueuingIndication::is_bound() const
{
return (field_messageType.is_bound());
}
boolean PDU__BSSMAP__VGCS__VBSQueuingIndication::is_value() const
{
return field_messageType.is_value();
}
void PDU__BSSMAP__VGCS__VBSQueuingIndication::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__VGCS__VBSQueuingIndication::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
}

void PDU__BSSMAP__VGCS__VBSQueuingIndication::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication");
  }
}

void PDU__BSSMAP__VGCS__VBSQueuingIndication::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
}

void PDU__BSSMAP__VGCS__VBSQueuingIndication::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
}

void PDU__BSSMAP__VGCS__VBSQueuingIndication::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__VGCS__VBSQueuingIndication::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__VGCS__VBSQueuingIndication::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_messageType !=  os_51) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__VGCS__VBSQueuingIndication::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 1;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(1);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  if (field_messageType !=  os_51) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_51.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__VGCS__VBSQueuingIndication_template::single_value_struct {
OCTETSTRING_template field_messageType;
};

void PDU__BSSMAP__VGCS__VBSQueuingIndication_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
}
}
}

void PDU__BSSMAP__VGCS__VBSQueuingIndication_template::copy_value(const PDU__BSSMAP__VGCS__VBSQueuingIndication& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__VGCS__VBSQueuingIndication_template::copy_template(const PDU__BSSMAP__VGCS__VBSQueuingIndication_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__VGCS__VBSQueuingIndication_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__VGCS__VBSQueuingIndication_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__VGCS__VBSQueuingIndication_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__VGCS__VBSQueuingIndication_template::PDU__BSSMAP__VGCS__VBSQueuingIndication_template()
{
}

PDU__BSSMAP__VGCS__VBSQueuingIndication_template::PDU__BSSMAP__VGCS__VBSQueuingIndication_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__VGCS__VBSQueuingIndication_template::PDU__BSSMAP__VGCS__VBSQueuingIndication_template(const PDU__BSSMAP__VGCS__VBSQueuingIndication& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__VGCS__VBSQueuingIndication_template::PDU__BSSMAP__VGCS__VBSQueuingIndication_template(const OPTIONAL<PDU__BSSMAP__VGCS__VBSQueuingIndication>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__VGCS__VBSQueuingIndication&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication from an unbound optional field.");
}
}

PDU__BSSMAP__VGCS__VBSQueuingIndication_template::PDU__BSSMAP__VGCS__VBSQueuingIndication_template(PDU__BSSMAP__VGCS__VBSQueuingIndication_template* p_precondition, PDU__BSSMAP__VGCS__VBSQueuingIndication_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__VGCS__VBSQueuingIndication_template::PDU__BSSMAP__VGCS__VBSQueuingIndication_template(Dynamic_Match_Interface<PDU__BSSMAP__VGCS__VBSQueuingIndication>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__VGCS__VBSQueuingIndication>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__VGCS__VBSQueuingIndication_template::PDU__BSSMAP__VGCS__VBSQueuingIndication_template(const PDU__BSSMAP__VGCS__VBSQueuingIndication_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__VGCS__VBSQueuingIndication_template::~PDU__BSSMAP__VGCS__VBSQueuingIndication_template()
{
clean_up();
}

PDU__BSSMAP__VGCS__VBSQueuingIndication_template& PDU__BSSMAP__VGCS__VBSQueuingIndication_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__VGCS__VBSQueuingIndication_template& PDU__BSSMAP__VGCS__VBSQueuingIndication_template::operator=(const PDU__BSSMAP__VGCS__VBSQueuingIndication& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__VGCS__VBSQueuingIndication_template& PDU__BSSMAP__VGCS__VBSQueuingIndication_template::operator=(const OPTIONAL<PDU__BSSMAP__VGCS__VBSQueuingIndication>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__VGCS__VBSQueuingIndication&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication.");
}
return *this;
}

PDU__BSSMAP__VGCS__VBSQueuingIndication_template& PDU__BSSMAP__VGCS__VBSQueuingIndication_template::operator=(const PDU__BSSMAP__VGCS__VBSQueuingIndication_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__VGCS__VBSQueuingIndication_template::match(const PDU__BSSMAP__VGCS__VBSQueuingIndication& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication.");
}
return FALSE;
}

boolean PDU__BSSMAP__VGCS__VBSQueuingIndication_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound();
}

boolean PDU__BSSMAP__VGCS__VBSQueuingIndication_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value();
}

void PDU__BSSMAP__VGCS__VBSQueuingIndication_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__VGCS__VBSQueuingIndication PDU__BSSMAP__VGCS__VBSQueuingIndication_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication.");
PDU__BSSMAP__VGCS__VBSQueuingIndication ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
return ret_val;
}

void PDU__BSSMAP__VGCS__VBSQueuingIndication_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__VGCS__VBSQueuingIndication_template[list_length];
}

PDU__BSSMAP__VGCS__VBSQueuingIndication_template& PDU__BSSMAP__VGCS__VBSQueuingIndication_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__VGCS__VBSQueuingIndication_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__VGCS__VBSQueuingIndication_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication.");
return single_value->field_messageType;
}

int PDU__BSSMAP__VGCS__VBSQueuingIndication_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication.");
  }
  return 0;
}

void PDU__BSSMAP__VGCS__VBSQueuingIndication_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__VGCS__VBSQueuingIndication_template::log_match(const PDU__BSSMAP__VGCS__VBSQueuingIndication& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__VGCS__VBSQueuingIndication_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
}

void PDU__BSSMAP__VGCS__VBSQueuingIndication_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication.");
}
}

void PDU__BSSMAP__VGCS__VBSQueuingIndication_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__VGCS__VBSQueuingIndication_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication.");
}
}

void PDU__BSSMAP__VGCS__VBSQueuingIndication_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__VGCS__VBSQueuingIndication_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__VGCS__VBSQueuingIndication_template* precondition = new PDU__BSSMAP__VGCS__VBSQueuingIndication_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__VGCS__VBSQueuingIndication_template* implied_template = new PDU__BSSMAP__VGCS__VBSQueuingIndication_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__VGCS__VBSQueuingIndication_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__VGCS__VBSQueuingIndication_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_VGCS_VBSQueuingIndication");
}

boolean PDU__BSSMAP__VGCS__VBSQueuingIndication_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__VGCS__VBSQueuingIndication_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__UplinkRequest::PDU__BSSMAP__UplinkRequest()
{
}

PDU__BSSMAP__UplinkRequest::PDU__BSSMAP__UplinkRequest(const OCTETSTRING& par_messageType,
    const OPTIONAL< BSSMAP__IE__TalkerPriority >& par_talkerPriority,
    const OPTIONAL< BSSMAP__IE__CellIdentifier >& par_cellIdentifier,
    const OPTIONAL< BSSMAP__IE__Layer3Information >& par_layer3Information,
    const OPTIONAL< BSSMAP__IE__MobileIdentity >& par_mobileIdentity)
  :   field_messageType(par_messageType),
  field_talkerPriority(par_talkerPriority),
  field_cellIdentifier(par_cellIdentifier),
  field_layer3Information(par_layer3Information),
  field_mobileIdentity(par_mobileIdentity)
{
}

PDU__BSSMAP__UplinkRequest::PDU__BSSMAP__UplinkRequest(const PDU__BSSMAP__UplinkRequest& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.talkerPriority().is_bound()) field_talkerPriority = other_value.talkerPriority();
else field_talkerPriority.clean_up();
if (other_value.cellIdentifier().is_bound()) field_cellIdentifier = other_value.cellIdentifier();
else field_cellIdentifier.clean_up();
if (other_value.layer3Information().is_bound()) field_layer3Information = other_value.layer3Information();
else field_layer3Information.clean_up();
if (other_value.mobileIdentity().is_bound()) field_mobileIdentity = other_value.mobileIdentity();
else field_mobileIdentity.clean_up();
}

void PDU__BSSMAP__UplinkRequest::clean_up()
{
field_messageType.clean_up();
field_talkerPriority.clean_up();
field_cellIdentifier.clean_up();
field_layer3Information.clean_up();
field_mobileIdentity.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__UplinkRequest::get_descriptor() const { return &PDU__BSSMAP__UplinkRequest_descr_; }
PDU__BSSMAP__UplinkRequest& PDU__BSSMAP__UplinkRequest::operator=(const PDU__BSSMAP__UplinkRequest& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.talkerPriority().is_bound()) field_talkerPriority = other_value.talkerPriority();
  else field_talkerPriority.clean_up();
  if (other_value.cellIdentifier().is_bound()) field_cellIdentifier = other_value.cellIdentifier();
  else field_cellIdentifier.clean_up();
  if (other_value.layer3Information().is_bound()) field_layer3Information = other_value.layer3Information();
  else field_layer3Information.clean_up();
  if (other_value.mobileIdentity().is_bound()) field_mobileIdentity = other_value.mobileIdentity();
  else field_mobileIdentity.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__UplinkRequest::operator==(const PDU__BSSMAP__UplinkRequest& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_talkerPriority==other_value.field_talkerPriority
  && field_cellIdentifier==other_value.field_cellIdentifier
  && field_layer3Information==other_value.field_layer3Information
  && field_mobileIdentity==other_value.field_mobileIdentity;
}

boolean PDU__BSSMAP__UplinkRequest::is_bound() const
{
return (field_messageType.is_bound())
  || (OPTIONAL_OMIT == field_talkerPriority.get_selection() || field_talkerPriority.is_bound())
  || (OPTIONAL_OMIT == field_cellIdentifier.get_selection() || field_cellIdentifier.is_bound())
  || (OPTIONAL_OMIT == field_layer3Information.get_selection() || field_layer3Information.is_bound())
  || (OPTIONAL_OMIT == field_mobileIdentity.get_selection() || field_mobileIdentity.is_bound());
}
boolean PDU__BSSMAP__UplinkRequest::is_value() const
{
return field_messageType.is_value()
  && (OPTIONAL_OMIT == field_talkerPriority.get_selection() || field_talkerPriority.is_value())
  && (OPTIONAL_OMIT == field_cellIdentifier.get_selection() || field_cellIdentifier.is_value())
  && (OPTIONAL_OMIT == field_layer3Information.get_selection() || field_layer3Information.is_value())
  && (OPTIONAL_OMIT == field_mobileIdentity.get_selection() || field_mobileIdentity.is_value());
}
int PDU__BSSMAP__UplinkRequest::size_of() const
{
  int ret_val = 1;
  if (field_talkerPriority.ispresent()) ret_val++;
  if (field_cellIdentifier.ispresent()) ret_val++;
  if (field_layer3Information.ispresent()) ret_val++;
  if (field_mobileIdentity.ispresent()) ret_val++;
  return ret_val;
}

void PDU__BSSMAP__UplinkRequest::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", talkerPriority := ");
field_talkerPriority.log();
TTCN_Logger::log_event_str(", cellIdentifier := ");
field_cellIdentifier.log();
TTCN_Logger::log_event_str(", layer3Information := ");
field_layer3Information.log();
TTCN_Logger::log_event_str(", mobileIdentity := ");
field_mobileIdentity.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__UplinkRequest::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (!talkerPriority().is_bound()) talkerPriority() = OMIT_VALUE;
else talkerPriority().set_implicit_omit();
if (!cellIdentifier().is_bound()) cellIdentifier() = OMIT_VALUE;
else cellIdentifier().set_implicit_omit();
if (!layer3Information().is_bound()) layer3Information() = OMIT_VALUE;
else layer3Information().set_implicit_omit();
if (!mobileIdentity().is_bound()) mobileIdentity() = OMIT_VALUE;
else mobileIdentity().set_implicit_omit();
}

void PDU__BSSMAP__UplinkRequest::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) talkerPriority().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cellIdentifier().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) layer3Information().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) mobileIdentity().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "talkerPriority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          talkerPriority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "layer3Information")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          layer3Information().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mobileIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mobileIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_UplinkRequest: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_UplinkRequest");
  }
}

void PDU__BSSMAP__UplinkRequest::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_talkerPriority.encode_text(text_buf);
field_cellIdentifier.encode_text(text_buf);
field_layer3Information.encode_text(text_buf);
field_mobileIdentity.encode_text(text_buf);
}

void PDU__BSSMAP__UplinkRequest::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_talkerPriority.decode_text(text_buf);
field_cellIdentifier.decode_text(text_buf);
field_layer3Information.decode_text(text_buf);
field_mobileIdentity.decode_text(text_buf);
}

void PDU__BSSMAP__UplinkRequest::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__UplinkRequest::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__UplinkRequest::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_talkerPriority = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__TalkerPriority_descr_.raw->forceomit);
  decoded_field_length = field_talkerPriority().RAW_decode(BSSMAP__IE__TalkerPriority_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_talkerPriority = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_talkerPriority=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_cellIdentifier = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, BSSMAP__IE__CellIdentifier_descr_.raw->forceomit);
  decoded_field_length = field_cellIdentifier().RAW_decode(BSSMAP__IE__CellIdentifier_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_cellIdentifier = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_cellIdentifier=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_layer3Information = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, BSSMAP__IE__Layer3Information_descr_.raw->forceomit);
  decoded_field_length = field_layer3Information().RAW_decode(BSSMAP__IE__Layer3Information_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_layer3Information = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_layer3Information=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_mobileIdentity = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, BSSMAP__IE__MobileIdentity_descr_.raw->forceomit);
  decoded_field_length = field_mobileIdentity().RAW_decode(BSSMAP__IE__MobileIdentity_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_mobileIdentity = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_mobileIdentity=OMIT_VALUE;
  if (field_messageType !=  os_110) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__UplinkRequest::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  if (field_talkerPriority.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__TalkerPriority_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  if (field_cellIdentifier.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, BSSMAP__IE__CellIdentifier_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_layer3Information.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, BSSMAP__IE__Layer3Information_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_mobileIdentity.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, BSSMAP__IE__MobileIdentity_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  if (field_talkerPriority.ispresent()) {
  encoded_length += field_talkerPriority().RAW_encode(BSSMAP__IE__TalkerPriority_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_cellIdentifier.ispresent()) {
  encoded_length += field_cellIdentifier().RAW_encode(BSSMAP__IE__CellIdentifier_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_layer3Information.ispresent()) {
  encoded_length += field_layer3Information().RAW_encode(BSSMAP__IE__Layer3Information_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_mobileIdentity.ispresent()) {
  encoded_length += field_mobileIdentity().RAW_encode(BSSMAP__IE__MobileIdentity_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_messageType !=  os_110) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_110.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__UplinkRequest_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__TalkerPriority_template field_talkerPriority;
BSSMAP__IE__CellIdentifier_template field_cellIdentifier;
BSSMAP__IE__Layer3Information_template field_layer3Information;
BSSMAP__IE__MobileIdentity_template field_mobileIdentity;
};

void PDU__BSSMAP__UplinkRequest_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_talkerPriority = ANY_OR_OMIT;
single_value->field_cellIdentifier = ANY_OR_OMIT;
single_value->field_layer3Information = ANY_OR_OMIT;
single_value->field_mobileIdentity = ANY_OR_OMIT;
}
}
}

void PDU__BSSMAP__UplinkRequest_template::copy_value(const PDU__BSSMAP__UplinkRequest& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.talkerPriority().is_bound()) {
  if (other_value.talkerPriority().ispresent()) single_value->field_talkerPriority = other_value.talkerPriority()();
  else single_value->field_talkerPriority = OMIT_VALUE;
} else {
  single_value->field_talkerPriority.clean_up();
}
if (other_value.cellIdentifier().is_bound()) {
  if (other_value.cellIdentifier().ispresent()) single_value->field_cellIdentifier = other_value.cellIdentifier()();
  else single_value->field_cellIdentifier = OMIT_VALUE;
} else {
  single_value->field_cellIdentifier.clean_up();
}
if (other_value.layer3Information().is_bound()) {
  if (other_value.layer3Information().ispresent()) single_value->field_layer3Information = other_value.layer3Information()();
  else single_value->field_layer3Information = OMIT_VALUE;
} else {
  single_value->field_layer3Information.clean_up();
}
if (other_value.mobileIdentity().is_bound()) {
  if (other_value.mobileIdentity().ispresent()) single_value->field_mobileIdentity = other_value.mobileIdentity()();
  else single_value->field_mobileIdentity = OMIT_VALUE;
} else {
  single_value->field_mobileIdentity.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__UplinkRequest_template::copy_template(const PDU__BSSMAP__UplinkRequest_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.talkerPriority().get_selection()) {
single_value->field_talkerPriority = other_value.talkerPriority();
} else {
single_value->field_talkerPriority.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cellIdentifier().get_selection()) {
single_value->field_cellIdentifier = other_value.cellIdentifier();
} else {
single_value->field_cellIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.layer3Information().get_selection()) {
single_value->field_layer3Information = other_value.layer3Information();
} else {
single_value->field_layer3Information.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mobileIdentity().get_selection()) {
single_value->field_mobileIdentity = other_value.mobileIdentity();
} else {
single_value->field_mobileIdentity.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__UplinkRequest_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__UplinkRequest_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__UplinkRequest_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__UplinkRequest_template::PDU__BSSMAP__UplinkRequest_template()
{
}

PDU__BSSMAP__UplinkRequest_template::PDU__BSSMAP__UplinkRequest_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__UplinkRequest_template::PDU__BSSMAP__UplinkRequest_template(const PDU__BSSMAP__UplinkRequest& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__UplinkRequest_template::PDU__BSSMAP__UplinkRequest_template(const OPTIONAL<PDU__BSSMAP__UplinkRequest>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__UplinkRequest&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest from an unbound optional field.");
}
}

PDU__BSSMAP__UplinkRequest_template::PDU__BSSMAP__UplinkRequest_template(PDU__BSSMAP__UplinkRequest_template* p_precondition, PDU__BSSMAP__UplinkRequest_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__UplinkRequest_template::PDU__BSSMAP__UplinkRequest_template(Dynamic_Match_Interface<PDU__BSSMAP__UplinkRequest>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__UplinkRequest>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__UplinkRequest_template::PDU__BSSMAP__UplinkRequest_template(const PDU__BSSMAP__UplinkRequest_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__UplinkRequest_template::~PDU__BSSMAP__UplinkRequest_template()
{
clean_up();
}

PDU__BSSMAP__UplinkRequest_template& PDU__BSSMAP__UplinkRequest_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__UplinkRequest_template& PDU__BSSMAP__UplinkRequest_template::operator=(const PDU__BSSMAP__UplinkRequest& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__UplinkRequest_template& PDU__BSSMAP__UplinkRequest_template::operator=(const OPTIONAL<PDU__BSSMAP__UplinkRequest>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__UplinkRequest&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest.");
}
return *this;
}

PDU__BSSMAP__UplinkRequest_template& PDU__BSSMAP__UplinkRequest_template::operator=(const PDU__BSSMAP__UplinkRequest_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__UplinkRequest_template::match(const PDU__BSSMAP__UplinkRequest& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.talkerPriority().is_bound()) return FALSE;
if((other_value.talkerPriority().ispresent() ? !single_value->field_talkerPriority.match((const BSSMAP__IE__TalkerPriority&)other_value.talkerPriority(), legacy) : !single_value->field_talkerPriority.match_omit(legacy)))return FALSE;
if(!other_value.cellIdentifier().is_bound()) return FALSE;
if((other_value.cellIdentifier().ispresent() ? !single_value->field_cellIdentifier.match((const BSSMAP__IE__CellIdentifier&)other_value.cellIdentifier(), legacy) : !single_value->field_cellIdentifier.match_omit(legacy)))return FALSE;
if(!other_value.layer3Information().is_bound()) return FALSE;
if((other_value.layer3Information().ispresent() ? !single_value->field_layer3Information.match((const BSSMAP__IE__Layer3Information&)other_value.layer3Information(), legacy) : !single_value->field_layer3Information.match_omit(legacy)))return FALSE;
if(!other_value.mobileIdentity().is_bound()) return FALSE;
if((other_value.mobileIdentity().ispresent() ? !single_value->field_mobileIdentity.match((const BSSMAP__IE__MobileIdentity&)other_value.mobileIdentity(), legacy) : !single_value->field_mobileIdentity.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest.");
}
return FALSE;
}

boolean PDU__BSSMAP__UplinkRequest_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || (single_value->field_talkerPriority.is_omit() || single_value->field_talkerPriority.is_bound())
 || (single_value->field_cellIdentifier.is_omit() || single_value->field_cellIdentifier.is_bound())
 || (single_value->field_layer3Information.is_omit() || single_value->field_layer3Information.is_bound())
 || (single_value->field_mobileIdentity.is_omit() || single_value->field_mobileIdentity.is_bound());
}

boolean PDU__BSSMAP__UplinkRequest_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && (single_value->field_talkerPriority.is_omit() || single_value->field_talkerPriority.is_value())
 && (single_value->field_cellIdentifier.is_omit() || single_value->field_cellIdentifier.is_value())
 && (single_value->field_layer3Information.is_omit() || single_value->field_layer3Information.is_value())
 && (single_value->field_mobileIdentity.is_omit() || single_value->field_mobileIdentity.is_value());
}

void PDU__BSSMAP__UplinkRequest_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__UplinkRequest PDU__BSSMAP__UplinkRequest_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest.");
PDU__BSSMAP__UplinkRequest ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_talkerPriority.is_omit()) ret_val.talkerPriority() = OMIT_VALUE;
else if (single_value->field_talkerPriority.is_bound()) {
ret_val.talkerPriority() = single_value->field_talkerPriority.valueof();
}
if (single_value->field_cellIdentifier.is_omit()) ret_val.cellIdentifier() = OMIT_VALUE;
else if (single_value->field_cellIdentifier.is_bound()) {
ret_val.cellIdentifier() = single_value->field_cellIdentifier.valueof();
}
if (single_value->field_layer3Information.is_omit()) ret_val.layer3Information() = OMIT_VALUE;
else if (single_value->field_layer3Information.is_bound()) {
ret_val.layer3Information() = single_value->field_layer3Information.valueof();
}
if (single_value->field_mobileIdentity.is_omit()) ret_val.mobileIdentity() = OMIT_VALUE;
else if (single_value->field_mobileIdentity.is_bound()) {
ret_val.mobileIdentity() = single_value->field_mobileIdentity.valueof();
}
return ret_val;
}

void PDU__BSSMAP__UplinkRequest_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__UplinkRequest_template[list_length];
}

PDU__BSSMAP__UplinkRequest_template& PDU__BSSMAP__UplinkRequest_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__UplinkRequest_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__UplinkRequest_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest.");
return single_value->field_messageType;
}

BSSMAP__IE__TalkerPriority_template& PDU__BSSMAP__UplinkRequest_template::talkerPriority()
{
set_specific();
return single_value->field_talkerPriority;
}

const BSSMAP__IE__TalkerPriority_template& PDU__BSSMAP__UplinkRequest_template::talkerPriority() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field talkerPriority of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest.");
return single_value->field_talkerPriority;
}

BSSMAP__IE__CellIdentifier_template& PDU__BSSMAP__UplinkRequest_template::cellIdentifier()
{
set_specific();
return single_value->field_cellIdentifier;
}

const BSSMAP__IE__CellIdentifier_template& PDU__BSSMAP__UplinkRequest_template::cellIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cellIdentifier of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest.");
return single_value->field_cellIdentifier;
}

BSSMAP__IE__Layer3Information_template& PDU__BSSMAP__UplinkRequest_template::layer3Information()
{
set_specific();
return single_value->field_layer3Information;
}

const BSSMAP__IE__Layer3Information_template& PDU__BSSMAP__UplinkRequest_template::layer3Information() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field layer3Information of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest.");
return single_value->field_layer3Information;
}

BSSMAP__IE__MobileIdentity_template& PDU__BSSMAP__UplinkRequest_template::mobileIdentity()
{
set_specific();
return single_value->field_mobileIdentity;
}

const BSSMAP__IE__MobileIdentity_template& PDU__BSSMAP__UplinkRequest_template::mobileIdentity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mobileIdentity of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest.");
return single_value->field_mobileIdentity;
}

int PDU__BSSMAP__UplinkRequest_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_talkerPriority.is_present()) ret_val++;
      if (single_value->field_cellIdentifier.is_present()) ret_val++;
      if (single_value->field_layer3Information.is_present()) ret_val++;
      if (single_value->field_mobileIdentity.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest.");
  }
  return 0;
}

void PDU__BSSMAP__UplinkRequest_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", talkerPriority := ");
single_value->field_talkerPriority.log();
TTCN_Logger::log_event_str(", cellIdentifier := ");
single_value->field_cellIdentifier.log();
TTCN_Logger::log_event_str(", layer3Information := ");
single_value->field_layer3Information.log();
TTCN_Logger::log_event_str(", mobileIdentity := ");
single_value->field_mobileIdentity.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__UplinkRequest_template::log_match(const PDU__BSSMAP__UplinkRequest& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.talkerPriority().ispresent()){
if(!single_value->field_talkerPriority.match(match_value.talkerPriority(), legacy)){
TTCN_Logger::log_logmatch_info(".talkerPriority");
single_value->field_talkerPriority.log_match(match_value.talkerPriority(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_talkerPriority.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".talkerPriority := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_talkerPriority.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.cellIdentifier().ispresent()){
if(!single_value->field_cellIdentifier.match(match_value.cellIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".cellIdentifier");
single_value->field_cellIdentifier.log_match(match_value.cellIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_cellIdentifier.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".cellIdentifier := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_cellIdentifier.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.layer3Information().ispresent()){
if(!single_value->field_layer3Information.match(match_value.layer3Information(), legacy)){
TTCN_Logger::log_logmatch_info(".layer3Information");
single_value->field_layer3Information.log_match(match_value.layer3Information(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_layer3Information.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".layer3Information := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_layer3Information.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.mobileIdentity().ispresent()){
if(!single_value->field_mobileIdentity.match(match_value.mobileIdentity(), legacy)){
TTCN_Logger::log_logmatch_info(".mobileIdentity");
single_value->field_mobileIdentity.log_match(match_value.mobileIdentity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_mobileIdentity.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".mobileIdentity := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_mobileIdentity.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", talkerPriority := ");
if (match_value.talkerPriority().ispresent()) {
single_value->field_talkerPriority.log_match(match_value.talkerPriority(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_talkerPriority.log();
if (single_value->field_talkerPriority.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", cellIdentifier := ");
if (match_value.cellIdentifier().ispresent()) {
single_value->field_cellIdentifier.log_match(match_value.cellIdentifier(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_cellIdentifier.log();
if (single_value->field_cellIdentifier.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", layer3Information := ");
if (match_value.layer3Information().ispresent()) {
single_value->field_layer3Information.log_match(match_value.layer3Information(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_layer3Information.log();
if (single_value->field_layer3Information.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", mobileIdentity := ");
if (match_value.mobileIdentity().ispresent()) {
single_value->field_mobileIdentity.log_match(match_value.mobileIdentity(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_mobileIdentity.log();
if (single_value->field_mobileIdentity.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__UplinkRequest_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (!talkerPriority().is_bound()) talkerPriority() = OMIT_VALUE;
else talkerPriority().set_implicit_omit();
if (!cellIdentifier().is_bound()) cellIdentifier() = OMIT_VALUE;
else cellIdentifier().set_implicit_omit();
if (!layer3Information().is_bound()) layer3Information() = OMIT_VALUE;
else layer3Information().set_implicit_omit();
if (!mobileIdentity().is_bound()) mobileIdentity() = OMIT_VALUE;
else mobileIdentity().set_implicit_omit();
}

void PDU__BSSMAP__UplinkRequest_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_talkerPriority.encode_text(text_buf);
single_value->field_cellIdentifier.encode_text(text_buf);
single_value->field_layer3Information.encode_text(text_buf);
single_value->field_mobileIdentity.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest.");
}
}

void PDU__BSSMAP__UplinkRequest_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_talkerPriority.decode_text(text_buf);
single_value->field_cellIdentifier.decode_text(text_buf);
single_value->field_layer3Information.decode_text(text_buf);
single_value->field_mobileIdentity.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__UplinkRequest_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest.");
}
}

void PDU__BSSMAP__UplinkRequest_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__UplinkRequest_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequest has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) talkerPriority().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) cellIdentifier().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) layer3Information().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) mobileIdentity().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "talkerPriority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          talkerPriority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "layer3Information")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          layer3Information().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mobileIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mobileIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_UplinkRequest: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__UplinkRequest_template* precondition = new PDU__BSSMAP__UplinkRequest_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__UplinkRequest_template* implied_template = new PDU__BSSMAP__UplinkRequest_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__UplinkRequest_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_UplinkRequest");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__UplinkRequest_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkRequest");
single_value->field_talkerPriority.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkRequest");
single_value->field_cellIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkRequest");
single_value->field_layer3Information.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkRequest");
single_value->field_mobileIdentity.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkRequest");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkRequest");
}

boolean PDU__BSSMAP__UplinkRequest_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__UplinkRequest_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__UplinkRequestAck::PDU__BSSMAP__UplinkRequestAck()
{
}

PDU__BSSMAP__UplinkRequestAck::PDU__BSSMAP__UplinkRequestAck(const OCTETSTRING& par_messageType,
    const OPTIONAL< BSSMAP__IE__TalkerPriority >& par_talkerPriority,
    const OPTIONAL< BSSMAP__IE__EmergencySetIndication >& par_emergencySetIndication,
    const OPTIONAL< BSSMAP__IE__TalkerIdentity >& par_talkerIdentity)
  :   field_messageType(par_messageType),
  field_talkerPriority(par_talkerPriority),
  field_emergencySetIndication(par_emergencySetIndication),
  field_talkerIdentity(par_talkerIdentity)
{
}

PDU__BSSMAP__UplinkRequestAck::PDU__BSSMAP__UplinkRequestAck(const PDU__BSSMAP__UplinkRequestAck& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.talkerPriority().is_bound()) field_talkerPriority = other_value.talkerPriority();
else field_talkerPriority.clean_up();
if (other_value.emergencySetIndication().is_bound()) field_emergencySetIndication = other_value.emergencySetIndication();
else field_emergencySetIndication.clean_up();
if (other_value.talkerIdentity().is_bound()) field_talkerIdentity = other_value.talkerIdentity();
else field_talkerIdentity.clean_up();
}

void PDU__BSSMAP__UplinkRequestAck::clean_up()
{
field_messageType.clean_up();
field_talkerPriority.clean_up();
field_emergencySetIndication.clean_up();
field_talkerIdentity.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__UplinkRequestAck::get_descriptor() const { return &PDU__BSSMAP__UplinkRequestAck_descr_; }
PDU__BSSMAP__UplinkRequestAck& PDU__BSSMAP__UplinkRequestAck::operator=(const PDU__BSSMAP__UplinkRequestAck& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.talkerPriority().is_bound()) field_talkerPriority = other_value.talkerPriority();
  else field_talkerPriority.clean_up();
  if (other_value.emergencySetIndication().is_bound()) field_emergencySetIndication = other_value.emergencySetIndication();
  else field_emergencySetIndication.clean_up();
  if (other_value.talkerIdentity().is_bound()) field_talkerIdentity = other_value.talkerIdentity();
  else field_talkerIdentity.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__UplinkRequestAck::operator==(const PDU__BSSMAP__UplinkRequestAck& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_talkerPriority==other_value.field_talkerPriority
  && field_emergencySetIndication==other_value.field_emergencySetIndication
  && field_talkerIdentity==other_value.field_talkerIdentity;
}

boolean PDU__BSSMAP__UplinkRequestAck::is_bound() const
{
return (field_messageType.is_bound())
  || (OPTIONAL_OMIT == field_talkerPriority.get_selection() || field_talkerPriority.is_bound())
  || (OPTIONAL_OMIT == field_emergencySetIndication.get_selection() || field_emergencySetIndication.is_bound())
  || (OPTIONAL_OMIT == field_talkerIdentity.get_selection() || field_talkerIdentity.is_bound());
}
boolean PDU__BSSMAP__UplinkRequestAck::is_value() const
{
return field_messageType.is_value()
  && (OPTIONAL_OMIT == field_talkerPriority.get_selection() || field_talkerPriority.is_value())
  && (OPTIONAL_OMIT == field_emergencySetIndication.get_selection() || field_emergencySetIndication.is_value())
  && (OPTIONAL_OMIT == field_talkerIdentity.get_selection() || field_talkerIdentity.is_value());
}
int PDU__BSSMAP__UplinkRequestAck::size_of() const
{
  int ret_val = 1;
  if (field_talkerPriority.ispresent()) ret_val++;
  if (field_emergencySetIndication.ispresent()) ret_val++;
  if (field_talkerIdentity.ispresent()) ret_val++;
  return ret_val;
}

void PDU__BSSMAP__UplinkRequestAck::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", talkerPriority := ");
field_talkerPriority.log();
TTCN_Logger::log_event_str(", emergencySetIndication := ");
field_emergencySetIndication.log();
TTCN_Logger::log_event_str(", talkerIdentity := ");
field_talkerIdentity.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__UplinkRequestAck::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (!talkerPriority().is_bound()) talkerPriority() = OMIT_VALUE;
else talkerPriority().set_implicit_omit();
if (!emergencySetIndication().is_bound()) emergencySetIndication() = OMIT_VALUE;
else emergencySetIndication().set_implicit_omit();
if (!talkerIdentity().is_bound()) talkerIdentity() = OMIT_VALUE;
else talkerIdentity().set_implicit_omit();
}

void PDU__BSSMAP__UplinkRequestAck::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) talkerPriority().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) emergencySetIndication().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) talkerIdentity().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "talkerPriority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          talkerPriority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "emergencySetIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          emergencySetIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "talkerIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          talkerIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_UplinkRequestAck");
  }
}

void PDU__BSSMAP__UplinkRequestAck::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_talkerPriority.encode_text(text_buf);
field_emergencySetIndication.encode_text(text_buf);
field_talkerIdentity.encode_text(text_buf);
}

void PDU__BSSMAP__UplinkRequestAck::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_talkerPriority.decode_text(text_buf);
field_emergencySetIndication.decode_text(text_buf);
field_talkerIdentity.decode_text(text_buf);
}

void PDU__BSSMAP__UplinkRequestAck::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__UplinkRequestAck::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__UplinkRequestAck::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_talkerPriority = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__TalkerPriority_descr_.raw->forceomit);
  decoded_field_length = field_talkerPriority().RAW_decode(BSSMAP__IE__TalkerPriority_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_talkerPriority = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_talkerPriority=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_emergencySetIndication = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, BSSMAP__IE__EmergencySetIndication_descr_.raw->forceomit);
  decoded_field_length = field_emergencySetIndication().RAW_decode(BSSMAP__IE__EmergencySetIndication_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_emergencySetIndication = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_emergencySetIndication=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_talkerIdentity = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, BSSMAP__IE__TalkerIdentity_descr_.raw->forceomit);
  decoded_field_length = field_talkerIdentity().RAW_decode(BSSMAP__IE__TalkerIdentity_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_talkerIdentity = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_talkerIdentity=OMIT_VALUE;
  if (field_messageType !=  os_41) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__UplinkRequestAck::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  if (field_talkerPriority.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__TalkerPriority_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  if (field_emergencySetIndication.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, BSSMAP__IE__EmergencySetIndication_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_talkerIdentity.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, BSSMAP__IE__TalkerIdentity_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  if (field_talkerPriority.ispresent()) {
  encoded_length += field_talkerPriority().RAW_encode(BSSMAP__IE__TalkerPriority_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_emergencySetIndication.ispresent()) {
  encoded_length += field_emergencySetIndication().RAW_encode(BSSMAP__IE__EmergencySetIndication_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_talkerIdentity.ispresent()) {
  encoded_length += field_talkerIdentity().RAW_encode(BSSMAP__IE__TalkerIdentity_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_messageType !=  os_41) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_41.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__UplinkRequestAck_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__TalkerPriority_template field_talkerPriority;
BSSMAP__IE__EmergencySetIndication_template field_emergencySetIndication;
BSSMAP__IE__TalkerIdentity_template field_talkerIdentity;
};

void PDU__BSSMAP__UplinkRequestAck_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_talkerPriority = ANY_OR_OMIT;
single_value->field_emergencySetIndication = ANY_OR_OMIT;
single_value->field_talkerIdentity = ANY_OR_OMIT;
}
}
}

void PDU__BSSMAP__UplinkRequestAck_template::copy_value(const PDU__BSSMAP__UplinkRequestAck& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.talkerPriority().is_bound()) {
  if (other_value.talkerPriority().ispresent()) single_value->field_talkerPriority = other_value.talkerPriority()();
  else single_value->field_talkerPriority = OMIT_VALUE;
} else {
  single_value->field_talkerPriority.clean_up();
}
if (other_value.emergencySetIndication().is_bound()) {
  if (other_value.emergencySetIndication().ispresent()) single_value->field_emergencySetIndication = other_value.emergencySetIndication()();
  else single_value->field_emergencySetIndication = OMIT_VALUE;
} else {
  single_value->field_emergencySetIndication.clean_up();
}
if (other_value.talkerIdentity().is_bound()) {
  if (other_value.talkerIdentity().ispresent()) single_value->field_talkerIdentity = other_value.talkerIdentity()();
  else single_value->field_talkerIdentity = OMIT_VALUE;
} else {
  single_value->field_talkerIdentity.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__UplinkRequestAck_template::copy_template(const PDU__BSSMAP__UplinkRequestAck_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.talkerPriority().get_selection()) {
single_value->field_talkerPriority = other_value.talkerPriority();
} else {
single_value->field_talkerPriority.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.emergencySetIndication().get_selection()) {
single_value->field_emergencySetIndication = other_value.emergencySetIndication();
} else {
single_value->field_emergencySetIndication.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.talkerIdentity().get_selection()) {
single_value->field_talkerIdentity = other_value.talkerIdentity();
} else {
single_value->field_talkerIdentity.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__UplinkRequestAck_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__UplinkRequestAck_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__UplinkRequestAck_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__UplinkRequestAck_template::PDU__BSSMAP__UplinkRequestAck_template()
{
}

PDU__BSSMAP__UplinkRequestAck_template::PDU__BSSMAP__UplinkRequestAck_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__UplinkRequestAck_template::PDU__BSSMAP__UplinkRequestAck_template(const PDU__BSSMAP__UplinkRequestAck& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__UplinkRequestAck_template::PDU__BSSMAP__UplinkRequestAck_template(const OPTIONAL<PDU__BSSMAP__UplinkRequestAck>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__UplinkRequestAck&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck from an unbound optional field.");
}
}

PDU__BSSMAP__UplinkRequestAck_template::PDU__BSSMAP__UplinkRequestAck_template(PDU__BSSMAP__UplinkRequestAck_template* p_precondition, PDU__BSSMAP__UplinkRequestAck_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__UplinkRequestAck_template::PDU__BSSMAP__UplinkRequestAck_template(Dynamic_Match_Interface<PDU__BSSMAP__UplinkRequestAck>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__UplinkRequestAck>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__UplinkRequestAck_template::PDU__BSSMAP__UplinkRequestAck_template(const PDU__BSSMAP__UplinkRequestAck_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__UplinkRequestAck_template::~PDU__BSSMAP__UplinkRequestAck_template()
{
clean_up();
}

PDU__BSSMAP__UplinkRequestAck_template& PDU__BSSMAP__UplinkRequestAck_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__UplinkRequestAck_template& PDU__BSSMAP__UplinkRequestAck_template::operator=(const PDU__BSSMAP__UplinkRequestAck& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__UplinkRequestAck_template& PDU__BSSMAP__UplinkRequestAck_template::operator=(const OPTIONAL<PDU__BSSMAP__UplinkRequestAck>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__UplinkRequestAck&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck.");
}
return *this;
}

PDU__BSSMAP__UplinkRequestAck_template& PDU__BSSMAP__UplinkRequestAck_template::operator=(const PDU__BSSMAP__UplinkRequestAck_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__UplinkRequestAck_template::match(const PDU__BSSMAP__UplinkRequestAck& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.talkerPriority().is_bound()) return FALSE;
if((other_value.talkerPriority().ispresent() ? !single_value->field_talkerPriority.match((const BSSMAP__IE__TalkerPriority&)other_value.talkerPriority(), legacy) : !single_value->field_talkerPriority.match_omit(legacy)))return FALSE;
if(!other_value.emergencySetIndication().is_bound()) return FALSE;
if((other_value.emergencySetIndication().ispresent() ? !single_value->field_emergencySetIndication.match((const BSSMAP__IE__EmergencySetIndication&)other_value.emergencySetIndication(), legacy) : !single_value->field_emergencySetIndication.match_omit(legacy)))return FALSE;
if(!other_value.talkerIdentity().is_bound()) return FALSE;
if((other_value.talkerIdentity().ispresent() ? !single_value->field_talkerIdentity.match((const BSSMAP__IE__TalkerIdentity&)other_value.talkerIdentity(), legacy) : !single_value->field_talkerIdentity.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck.");
}
return FALSE;
}

boolean PDU__BSSMAP__UplinkRequestAck_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || (single_value->field_talkerPriority.is_omit() || single_value->field_talkerPriority.is_bound())
 || (single_value->field_emergencySetIndication.is_omit() || single_value->field_emergencySetIndication.is_bound())
 || (single_value->field_talkerIdentity.is_omit() || single_value->field_talkerIdentity.is_bound());
}

boolean PDU__BSSMAP__UplinkRequestAck_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && (single_value->field_talkerPriority.is_omit() || single_value->field_talkerPriority.is_value())
 && (single_value->field_emergencySetIndication.is_omit() || single_value->field_emergencySetIndication.is_value())
 && (single_value->field_talkerIdentity.is_omit() || single_value->field_talkerIdentity.is_value());
}

void PDU__BSSMAP__UplinkRequestAck_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__UplinkRequestAck PDU__BSSMAP__UplinkRequestAck_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck.");
PDU__BSSMAP__UplinkRequestAck ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_talkerPriority.is_omit()) ret_val.talkerPriority() = OMIT_VALUE;
else if (single_value->field_talkerPriority.is_bound()) {
ret_val.talkerPriority() = single_value->field_talkerPriority.valueof();
}
if (single_value->field_emergencySetIndication.is_omit()) ret_val.emergencySetIndication() = OMIT_VALUE;
else if (single_value->field_emergencySetIndication.is_bound()) {
ret_val.emergencySetIndication() = single_value->field_emergencySetIndication.valueof();
}
if (single_value->field_talkerIdentity.is_omit()) ret_val.talkerIdentity() = OMIT_VALUE;
else if (single_value->field_talkerIdentity.is_bound()) {
ret_val.talkerIdentity() = single_value->field_talkerIdentity.valueof();
}
return ret_val;
}

void PDU__BSSMAP__UplinkRequestAck_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__UplinkRequestAck_template[list_length];
}

PDU__BSSMAP__UplinkRequestAck_template& PDU__BSSMAP__UplinkRequestAck_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__UplinkRequestAck_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__UplinkRequestAck_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck.");
return single_value->field_messageType;
}

BSSMAP__IE__TalkerPriority_template& PDU__BSSMAP__UplinkRequestAck_template::talkerPriority()
{
set_specific();
return single_value->field_talkerPriority;
}

const BSSMAP__IE__TalkerPriority_template& PDU__BSSMAP__UplinkRequestAck_template::talkerPriority() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field talkerPriority of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck.");
return single_value->field_talkerPriority;
}

BSSMAP__IE__EmergencySetIndication_template& PDU__BSSMAP__UplinkRequestAck_template::emergencySetIndication()
{
set_specific();
return single_value->field_emergencySetIndication;
}

const BSSMAP__IE__EmergencySetIndication_template& PDU__BSSMAP__UplinkRequestAck_template::emergencySetIndication() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field emergencySetIndication of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck.");
return single_value->field_emergencySetIndication;
}

BSSMAP__IE__TalkerIdentity_template& PDU__BSSMAP__UplinkRequestAck_template::talkerIdentity()
{
set_specific();
return single_value->field_talkerIdentity;
}

const BSSMAP__IE__TalkerIdentity_template& PDU__BSSMAP__UplinkRequestAck_template::talkerIdentity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field talkerIdentity of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck.");
return single_value->field_talkerIdentity;
}

int PDU__BSSMAP__UplinkRequestAck_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_talkerPriority.is_present()) ret_val++;
      if (single_value->field_emergencySetIndication.is_present()) ret_val++;
      if (single_value->field_talkerIdentity.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck.");
  }
  return 0;
}

void PDU__BSSMAP__UplinkRequestAck_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", talkerPriority := ");
single_value->field_talkerPriority.log();
TTCN_Logger::log_event_str(", emergencySetIndication := ");
single_value->field_emergencySetIndication.log();
TTCN_Logger::log_event_str(", talkerIdentity := ");
single_value->field_talkerIdentity.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__UplinkRequestAck_template::log_match(const PDU__BSSMAP__UplinkRequestAck& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.talkerPriority().ispresent()){
if(!single_value->field_talkerPriority.match(match_value.talkerPriority(), legacy)){
TTCN_Logger::log_logmatch_info(".talkerPriority");
single_value->field_talkerPriority.log_match(match_value.talkerPriority(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_talkerPriority.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".talkerPriority := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_talkerPriority.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.emergencySetIndication().ispresent()){
if(!single_value->field_emergencySetIndication.match(match_value.emergencySetIndication(), legacy)){
TTCN_Logger::log_logmatch_info(".emergencySetIndication");
single_value->field_emergencySetIndication.log_match(match_value.emergencySetIndication(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_emergencySetIndication.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".emergencySetIndication := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_emergencySetIndication.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.talkerIdentity().ispresent()){
if(!single_value->field_talkerIdentity.match(match_value.talkerIdentity(), legacy)){
TTCN_Logger::log_logmatch_info(".talkerIdentity");
single_value->field_talkerIdentity.log_match(match_value.talkerIdentity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_talkerIdentity.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".talkerIdentity := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_talkerIdentity.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", talkerPriority := ");
if (match_value.talkerPriority().ispresent()) {
single_value->field_talkerPriority.log_match(match_value.talkerPriority(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_talkerPriority.log();
if (single_value->field_talkerPriority.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", emergencySetIndication := ");
if (match_value.emergencySetIndication().ispresent()) {
single_value->field_emergencySetIndication.log_match(match_value.emergencySetIndication(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_emergencySetIndication.log();
if (single_value->field_emergencySetIndication.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", talkerIdentity := ");
if (match_value.talkerIdentity().ispresent()) {
single_value->field_talkerIdentity.log_match(match_value.talkerIdentity(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_talkerIdentity.log();
if (single_value->field_talkerIdentity.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__UplinkRequestAck_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (!talkerPriority().is_bound()) talkerPriority() = OMIT_VALUE;
else talkerPriority().set_implicit_omit();
if (!emergencySetIndication().is_bound()) emergencySetIndication() = OMIT_VALUE;
else emergencySetIndication().set_implicit_omit();
if (!talkerIdentity().is_bound()) talkerIdentity() = OMIT_VALUE;
else talkerIdentity().set_implicit_omit();
}

void PDU__BSSMAP__UplinkRequestAck_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_talkerPriority.encode_text(text_buf);
single_value->field_emergencySetIndication.encode_text(text_buf);
single_value->field_talkerIdentity.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck.");
}
}

void PDU__BSSMAP__UplinkRequestAck_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_talkerPriority.decode_text(text_buf);
single_value->field_emergencySetIndication.decode_text(text_buf);
single_value->field_talkerIdentity.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__UplinkRequestAck_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck.");
}
}

void PDU__BSSMAP__UplinkRequestAck_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__UplinkRequestAck_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) talkerPriority().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) emergencySetIndication().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) talkerIdentity().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "talkerPriority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          talkerPriority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "emergencySetIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          emergencySetIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "talkerIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          talkerIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_UplinkRequestAck: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__UplinkRequestAck_template* precondition = new PDU__BSSMAP__UplinkRequestAck_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__UplinkRequestAck_template* implied_template = new PDU__BSSMAP__UplinkRequestAck_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__UplinkRequestAck_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_UplinkRequestAck");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__UplinkRequestAck_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkRequestAck");
single_value->field_talkerPriority.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkRequestAck");
single_value->field_emergencySetIndication.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkRequestAck");
single_value->field_talkerIdentity.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkRequestAck");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkRequestAck");
}

boolean PDU__BSSMAP__UplinkRequestAck_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__UplinkRequestAck_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__UplinkRequestConfirmation::PDU__BSSMAP__UplinkRequestConfirmation()
{
}

PDU__BSSMAP__UplinkRequestConfirmation::PDU__BSSMAP__UplinkRequestConfirmation(const OCTETSTRING& par_messageType,
    const BSSMAP__IE__CellIdentifier& par_cellIdentifier,
    const OPTIONAL< BSSMAP__IE__TalkerIdentity >& par_talkerIdentity,
    const BSSMAP__IE__Layer3Information& par_layer3Information)
  :   field_messageType(par_messageType),
  field_cellIdentifier(par_cellIdentifier),
  field_talkerIdentity(par_talkerIdentity),
  field_layer3Information(par_layer3Information)
{
}

PDU__BSSMAP__UplinkRequestConfirmation::PDU__BSSMAP__UplinkRequestConfirmation(const PDU__BSSMAP__UplinkRequestConfirmation& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.cellIdentifier().is_bound()) field_cellIdentifier = other_value.cellIdentifier();
else field_cellIdentifier.clean_up();
if (other_value.talkerIdentity().is_bound()) field_talkerIdentity = other_value.talkerIdentity();
else field_talkerIdentity.clean_up();
if (other_value.layer3Information().is_bound()) field_layer3Information = other_value.layer3Information();
else field_layer3Information.clean_up();
}

void PDU__BSSMAP__UplinkRequestConfirmation::clean_up()
{
field_messageType.clean_up();
field_cellIdentifier.clean_up();
field_talkerIdentity.clean_up();
field_layer3Information.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__UplinkRequestConfirmation::get_descriptor() const { return &PDU__BSSMAP__UplinkRequestConfirmation_descr_; }
PDU__BSSMAP__UplinkRequestConfirmation& PDU__BSSMAP__UplinkRequestConfirmation::operator=(const PDU__BSSMAP__UplinkRequestConfirmation& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.cellIdentifier().is_bound()) field_cellIdentifier = other_value.cellIdentifier();
  else field_cellIdentifier.clean_up();
  if (other_value.talkerIdentity().is_bound()) field_talkerIdentity = other_value.talkerIdentity();
  else field_talkerIdentity.clean_up();
  if (other_value.layer3Information().is_bound()) field_layer3Information = other_value.layer3Information();
  else field_layer3Information.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__UplinkRequestConfirmation::operator==(const PDU__BSSMAP__UplinkRequestConfirmation& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_cellIdentifier==other_value.field_cellIdentifier
  && field_talkerIdentity==other_value.field_talkerIdentity
  && field_layer3Information==other_value.field_layer3Information;
}

boolean PDU__BSSMAP__UplinkRequestConfirmation::is_bound() const
{
return (field_messageType.is_bound())
  || (field_cellIdentifier.is_bound())
  || (OPTIONAL_OMIT == field_talkerIdentity.get_selection() || field_talkerIdentity.is_bound())
  || (field_layer3Information.is_bound());
}
boolean PDU__BSSMAP__UplinkRequestConfirmation::is_value() const
{
return field_messageType.is_value()
  && field_cellIdentifier.is_value()
  && (OPTIONAL_OMIT == field_talkerIdentity.get_selection() || field_talkerIdentity.is_value())
  && field_layer3Information.is_value();
}
int PDU__BSSMAP__UplinkRequestConfirmation::size_of() const
{
  int ret_val = 3;
  if (field_talkerIdentity.ispresent()) ret_val++;
  return ret_val;
}

void PDU__BSSMAP__UplinkRequestConfirmation::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", cellIdentifier := ");
field_cellIdentifier.log();
TTCN_Logger::log_event_str(", talkerIdentity := ");
field_talkerIdentity.log();
TTCN_Logger::log_event_str(", layer3Information := ");
field_layer3Information.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__UplinkRequestConfirmation::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (cellIdentifier().is_bound()) cellIdentifier().set_implicit_omit();
if (!talkerIdentity().is_bound()) talkerIdentity() = OMIT_VALUE;
else talkerIdentity().set_implicit_omit();
if (layer3Information().is_bound()) layer3Information().set_implicit_omit();
}

void PDU__BSSMAP__UplinkRequestConfirmation::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cellIdentifier().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) talkerIdentity().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) layer3Information().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "talkerIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          talkerIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "layer3Information")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          layer3Information().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation");
  }
}

void PDU__BSSMAP__UplinkRequestConfirmation::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_cellIdentifier.encode_text(text_buf);
field_talkerIdentity.encode_text(text_buf);
field_layer3Information.encode_text(text_buf);
}

void PDU__BSSMAP__UplinkRequestConfirmation::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_cellIdentifier.decode_text(text_buf);
field_talkerIdentity.decode_text(text_buf);
field_layer3Information.decode_text(text_buf);
}

void PDU__BSSMAP__UplinkRequestConfirmation::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__UplinkRequestConfirmation::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__UplinkRequestConfirmation::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__CellIdentifier_descr_.raw->forceomit);
  decoded_field_length = field_cellIdentifier.RAW_decode(BSSMAP__IE__CellIdentifier_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_talkerIdentity = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, BSSMAP__IE__TalkerIdentity_descr_.raw->forceomit);
  decoded_field_length = field_talkerIdentity().RAW_decode(BSSMAP__IE__TalkerIdentity_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_talkerIdentity = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_talkerIdentity=OMIT_VALUE;
  RAW_Force_Omit field_3_force_omit(3, force_omit, BSSMAP__IE__Layer3Information_descr_.raw->forceomit);
  decoded_field_length = field_layer3Information.RAW_decode(BSSMAP__IE__Layer3Information_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_messageType !=  os_66) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__UplinkRequestConfirmation::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__CellIdentifier_descr_.raw);
  if (field_talkerIdentity.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, BSSMAP__IE__TalkerIdentity_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, BSSMAP__IE__Layer3Information_descr_.raw);
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_cellIdentifier.RAW_encode(BSSMAP__IE__CellIdentifier_descr_, *myleaf.body.node.nodes[1]);
  if (field_talkerIdentity.ispresent()) {
  encoded_length += field_talkerIdentity().RAW_encode(BSSMAP__IE__TalkerIdentity_descr_, *myleaf.body.node.nodes[2]);
  }
  encoded_length += field_layer3Information.RAW_encode(BSSMAP__IE__Layer3Information_descr_, *myleaf.body.node.nodes[3]);
  if (field_messageType !=  os_66) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_66.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__UplinkRequestConfirmation_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__CellIdentifier_template field_cellIdentifier;
BSSMAP__IE__TalkerIdentity_template field_talkerIdentity;
BSSMAP__IE__Layer3Information_template field_layer3Information;
};

void PDU__BSSMAP__UplinkRequestConfirmation_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_cellIdentifier = ANY_VALUE;
single_value->field_talkerIdentity = ANY_OR_OMIT;
single_value->field_layer3Information = ANY_VALUE;
}
}
}

void PDU__BSSMAP__UplinkRequestConfirmation_template::copy_value(const PDU__BSSMAP__UplinkRequestConfirmation& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.cellIdentifier().is_bound()) {
  single_value->field_cellIdentifier = other_value.cellIdentifier();
} else {
  single_value->field_cellIdentifier.clean_up();
}
if (other_value.talkerIdentity().is_bound()) {
  if (other_value.talkerIdentity().ispresent()) single_value->field_talkerIdentity = other_value.talkerIdentity()();
  else single_value->field_talkerIdentity = OMIT_VALUE;
} else {
  single_value->field_talkerIdentity.clean_up();
}
if (other_value.layer3Information().is_bound()) {
  single_value->field_layer3Information = other_value.layer3Information();
} else {
  single_value->field_layer3Information.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__UplinkRequestConfirmation_template::copy_template(const PDU__BSSMAP__UplinkRequestConfirmation_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cellIdentifier().get_selection()) {
single_value->field_cellIdentifier = other_value.cellIdentifier();
} else {
single_value->field_cellIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.talkerIdentity().get_selection()) {
single_value->field_talkerIdentity = other_value.talkerIdentity();
} else {
single_value->field_talkerIdentity.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.layer3Information().get_selection()) {
single_value->field_layer3Information = other_value.layer3Information();
} else {
single_value->field_layer3Information.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__UplinkRequestConfirmation_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__UplinkRequestConfirmation_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__UplinkRequestConfirmation_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__UplinkRequestConfirmation_template::PDU__BSSMAP__UplinkRequestConfirmation_template()
{
}

PDU__BSSMAP__UplinkRequestConfirmation_template::PDU__BSSMAP__UplinkRequestConfirmation_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__UplinkRequestConfirmation_template::PDU__BSSMAP__UplinkRequestConfirmation_template(const PDU__BSSMAP__UplinkRequestConfirmation& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__UplinkRequestConfirmation_template::PDU__BSSMAP__UplinkRequestConfirmation_template(const OPTIONAL<PDU__BSSMAP__UplinkRequestConfirmation>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__UplinkRequestConfirmation&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation from an unbound optional field.");
}
}

PDU__BSSMAP__UplinkRequestConfirmation_template::PDU__BSSMAP__UplinkRequestConfirmation_template(PDU__BSSMAP__UplinkRequestConfirmation_template* p_precondition, PDU__BSSMAP__UplinkRequestConfirmation_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__UplinkRequestConfirmation_template::PDU__BSSMAP__UplinkRequestConfirmation_template(Dynamic_Match_Interface<PDU__BSSMAP__UplinkRequestConfirmation>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__UplinkRequestConfirmation>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__UplinkRequestConfirmation_template::PDU__BSSMAP__UplinkRequestConfirmation_template(const PDU__BSSMAP__UplinkRequestConfirmation_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__UplinkRequestConfirmation_template::~PDU__BSSMAP__UplinkRequestConfirmation_template()
{
clean_up();
}

PDU__BSSMAP__UplinkRequestConfirmation_template& PDU__BSSMAP__UplinkRequestConfirmation_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__UplinkRequestConfirmation_template& PDU__BSSMAP__UplinkRequestConfirmation_template::operator=(const PDU__BSSMAP__UplinkRequestConfirmation& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__UplinkRequestConfirmation_template& PDU__BSSMAP__UplinkRequestConfirmation_template::operator=(const OPTIONAL<PDU__BSSMAP__UplinkRequestConfirmation>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__UplinkRequestConfirmation&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation.");
}
return *this;
}

PDU__BSSMAP__UplinkRequestConfirmation_template& PDU__BSSMAP__UplinkRequestConfirmation_template::operator=(const PDU__BSSMAP__UplinkRequestConfirmation_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__UplinkRequestConfirmation_template::match(const PDU__BSSMAP__UplinkRequestConfirmation& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.cellIdentifier().is_bound()) return FALSE;
if(!single_value->field_cellIdentifier.match(other_value.cellIdentifier(), legacy))return FALSE;
if(!other_value.talkerIdentity().is_bound()) return FALSE;
if((other_value.talkerIdentity().ispresent() ? !single_value->field_talkerIdentity.match((const BSSMAP__IE__TalkerIdentity&)other_value.talkerIdentity(), legacy) : !single_value->field_talkerIdentity.match_omit(legacy)))return FALSE;
if(!other_value.layer3Information().is_bound()) return FALSE;
if(!single_value->field_layer3Information.match(other_value.layer3Information(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation.");
}
return FALSE;
}

boolean PDU__BSSMAP__UplinkRequestConfirmation_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_cellIdentifier.is_bound()
 || (single_value->field_talkerIdentity.is_omit() || single_value->field_talkerIdentity.is_bound())
 || single_value->field_layer3Information.is_bound();
}

boolean PDU__BSSMAP__UplinkRequestConfirmation_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_cellIdentifier.is_value()
 && (single_value->field_talkerIdentity.is_omit() || single_value->field_talkerIdentity.is_value())
 && single_value->field_layer3Information.is_value();
}

void PDU__BSSMAP__UplinkRequestConfirmation_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__UplinkRequestConfirmation PDU__BSSMAP__UplinkRequestConfirmation_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation.");
PDU__BSSMAP__UplinkRequestConfirmation ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_cellIdentifier.is_bound()) {
ret_val.cellIdentifier() = single_value->field_cellIdentifier.valueof();
}
if (single_value->field_talkerIdentity.is_omit()) ret_val.talkerIdentity() = OMIT_VALUE;
else if (single_value->field_talkerIdentity.is_bound()) {
ret_val.talkerIdentity() = single_value->field_talkerIdentity.valueof();
}
if (single_value->field_layer3Information.is_bound()) {
ret_val.layer3Information() = single_value->field_layer3Information.valueof();
}
return ret_val;
}

void PDU__BSSMAP__UplinkRequestConfirmation_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__UplinkRequestConfirmation_template[list_length];
}

PDU__BSSMAP__UplinkRequestConfirmation_template& PDU__BSSMAP__UplinkRequestConfirmation_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__UplinkRequestConfirmation_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__UplinkRequestConfirmation_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation.");
return single_value->field_messageType;
}

BSSMAP__IE__CellIdentifier_template& PDU__BSSMAP__UplinkRequestConfirmation_template::cellIdentifier()
{
set_specific();
return single_value->field_cellIdentifier;
}

const BSSMAP__IE__CellIdentifier_template& PDU__BSSMAP__UplinkRequestConfirmation_template::cellIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cellIdentifier of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation.");
return single_value->field_cellIdentifier;
}

BSSMAP__IE__TalkerIdentity_template& PDU__BSSMAP__UplinkRequestConfirmation_template::talkerIdentity()
{
set_specific();
return single_value->field_talkerIdentity;
}

const BSSMAP__IE__TalkerIdentity_template& PDU__BSSMAP__UplinkRequestConfirmation_template::talkerIdentity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field talkerIdentity of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation.");
return single_value->field_talkerIdentity;
}

BSSMAP__IE__Layer3Information_template& PDU__BSSMAP__UplinkRequestConfirmation_template::layer3Information()
{
set_specific();
return single_value->field_layer3Information;
}

const BSSMAP__IE__Layer3Information_template& PDU__BSSMAP__UplinkRequestConfirmation_template::layer3Information() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field layer3Information of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation.");
return single_value->field_layer3Information;
}

int PDU__BSSMAP__UplinkRequestConfirmation_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 3;
      if (single_value->field_talkerIdentity.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation.");
  }
  return 0;
}

void PDU__BSSMAP__UplinkRequestConfirmation_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", cellIdentifier := ");
single_value->field_cellIdentifier.log();
TTCN_Logger::log_event_str(", talkerIdentity := ");
single_value->field_talkerIdentity.log();
TTCN_Logger::log_event_str(", layer3Information := ");
single_value->field_layer3Information.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__UplinkRequestConfirmation_template::log_match(const PDU__BSSMAP__UplinkRequestConfirmation& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cellIdentifier.match(match_value.cellIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".cellIdentifier");
single_value->field_cellIdentifier.log_match(match_value.cellIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.talkerIdentity().ispresent()){
if(!single_value->field_talkerIdentity.match(match_value.talkerIdentity(), legacy)){
TTCN_Logger::log_logmatch_info(".talkerIdentity");
single_value->field_talkerIdentity.log_match(match_value.talkerIdentity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_talkerIdentity.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".talkerIdentity := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_talkerIdentity.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_layer3Information.match(match_value.layer3Information(), legacy)){
TTCN_Logger::log_logmatch_info(".layer3Information");
single_value->field_layer3Information.log_match(match_value.layer3Information(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", cellIdentifier := ");
single_value->field_cellIdentifier.log_match(match_value.cellIdentifier(), legacy);
TTCN_Logger::log_event_str(", talkerIdentity := ");
if (match_value.talkerIdentity().ispresent()) {
single_value->field_talkerIdentity.log_match(match_value.talkerIdentity(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_talkerIdentity.log();
if (single_value->field_talkerIdentity.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", layer3Information := ");
single_value->field_layer3Information.log_match(match_value.layer3Information(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__UplinkRequestConfirmation_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (cellIdentifier().is_bound()) cellIdentifier().set_implicit_omit();
if (!talkerIdentity().is_bound()) talkerIdentity() = OMIT_VALUE;
else talkerIdentity().set_implicit_omit();
if (layer3Information().is_bound()) layer3Information().set_implicit_omit();
}

void PDU__BSSMAP__UplinkRequestConfirmation_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_cellIdentifier.encode_text(text_buf);
single_value->field_talkerIdentity.encode_text(text_buf);
single_value->field_layer3Information.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation.");
}
}

void PDU__BSSMAP__UplinkRequestConfirmation_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_cellIdentifier.decode_text(text_buf);
single_value->field_talkerIdentity.decode_text(text_buf);
single_value->field_layer3Information.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__UplinkRequestConfirmation_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation.");
}
}

void PDU__BSSMAP__UplinkRequestConfirmation_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__UplinkRequestConfirmation_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cellIdentifier().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) talkerIdentity().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) layer3Information().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "talkerIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          talkerIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "layer3Information")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          layer3Information().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__UplinkRequestConfirmation_template* precondition = new PDU__BSSMAP__UplinkRequestConfirmation_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__UplinkRequestConfirmation_template* implied_template = new PDU__BSSMAP__UplinkRequestConfirmation_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__UplinkRequestConfirmation_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__UplinkRequestConfirmation_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation");
single_value->field_cellIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation");
single_value->field_talkerIdentity.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation");
single_value->field_layer3Information.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkRequestConfirmation");
}

boolean PDU__BSSMAP__UplinkRequestConfirmation_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__UplinkRequestConfirmation_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__UplinkApplicationData::PDU__BSSMAP__UplinkApplicationData()
{
}

PDU__BSSMAP__UplinkApplicationData::PDU__BSSMAP__UplinkApplicationData(const OCTETSTRING& par_messageType,
    const BSSMAP__IE__CellIdentifier& par_cellIdentifier,
    const BSSMAP__IE__Layer3Information& par_layer3Information,
    const BSSMAP__IE__ApplicationDataInformation& par_applicationDataInformation)
  :   field_messageType(par_messageType),
  field_cellIdentifier(par_cellIdentifier),
  field_layer3Information(par_layer3Information),
  field_applicationDataInformation(par_applicationDataInformation)
{
}

PDU__BSSMAP__UplinkApplicationData::PDU__BSSMAP__UplinkApplicationData(const PDU__BSSMAP__UplinkApplicationData& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.cellIdentifier().is_bound()) field_cellIdentifier = other_value.cellIdentifier();
else field_cellIdentifier.clean_up();
if (other_value.layer3Information().is_bound()) field_layer3Information = other_value.layer3Information();
else field_layer3Information.clean_up();
if (other_value.applicationDataInformation().is_bound()) field_applicationDataInformation = other_value.applicationDataInformation();
else field_applicationDataInformation.clean_up();
}

void PDU__BSSMAP__UplinkApplicationData::clean_up()
{
field_messageType.clean_up();
field_cellIdentifier.clean_up();
field_layer3Information.clean_up();
field_applicationDataInformation.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__UplinkApplicationData::get_descriptor() const { return &PDU__BSSMAP__UplinkApplicationData_descr_; }
PDU__BSSMAP__UplinkApplicationData& PDU__BSSMAP__UplinkApplicationData::operator=(const PDU__BSSMAP__UplinkApplicationData& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.cellIdentifier().is_bound()) field_cellIdentifier = other_value.cellIdentifier();
  else field_cellIdentifier.clean_up();
  if (other_value.layer3Information().is_bound()) field_layer3Information = other_value.layer3Information();
  else field_layer3Information.clean_up();
  if (other_value.applicationDataInformation().is_bound()) field_applicationDataInformation = other_value.applicationDataInformation();
  else field_applicationDataInformation.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__UplinkApplicationData::operator==(const PDU__BSSMAP__UplinkApplicationData& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_cellIdentifier==other_value.field_cellIdentifier
  && field_layer3Information==other_value.field_layer3Information
  && field_applicationDataInformation==other_value.field_applicationDataInformation;
}

boolean PDU__BSSMAP__UplinkApplicationData::is_bound() const
{
return (field_messageType.is_bound())
  || (field_cellIdentifier.is_bound())
  || (field_layer3Information.is_bound())
  || (field_applicationDataInformation.is_bound());
}
boolean PDU__BSSMAP__UplinkApplicationData::is_value() const
{
return field_messageType.is_value()
  && field_cellIdentifier.is_value()
  && field_layer3Information.is_value()
  && field_applicationDataInformation.is_value();
}
void PDU__BSSMAP__UplinkApplicationData::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", cellIdentifier := ");
field_cellIdentifier.log();
TTCN_Logger::log_event_str(", layer3Information := ");
field_layer3Information.log();
TTCN_Logger::log_event_str(", applicationDataInformation := ");
field_applicationDataInformation.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__UplinkApplicationData::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (cellIdentifier().is_bound()) cellIdentifier().set_implicit_omit();
if (layer3Information().is_bound()) layer3Information().set_implicit_omit();
if (applicationDataInformation().is_bound()) applicationDataInformation().set_implicit_omit();
}

void PDU__BSSMAP__UplinkApplicationData::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cellIdentifier().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) layer3Information().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) applicationDataInformation().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "layer3Information")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          layer3Information().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "applicationDataInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          applicationDataInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_UplinkApplicationData");
  }
}

void PDU__BSSMAP__UplinkApplicationData::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_cellIdentifier.encode_text(text_buf);
field_layer3Information.encode_text(text_buf);
field_applicationDataInformation.encode_text(text_buf);
}

void PDU__BSSMAP__UplinkApplicationData::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_cellIdentifier.decode_text(text_buf);
field_layer3Information.decode_text(text_buf);
field_applicationDataInformation.decode_text(text_buf);
}

void PDU__BSSMAP__UplinkApplicationData::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__UplinkApplicationData::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__UplinkApplicationData::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__CellIdentifier_descr_.raw->forceomit);
  decoded_field_length = field_cellIdentifier.RAW_decode(BSSMAP__IE__CellIdentifier_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, BSSMAP__IE__Layer3Information_descr_.raw->forceomit);
  decoded_field_length = field_layer3Information.RAW_decode(BSSMAP__IE__Layer3Information_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, BSSMAP__IE__ApplicationDataInformation_descr_.raw->forceomit);
  decoded_field_length = field_applicationDataInformation.RAW_decode(BSSMAP__IE__ApplicationDataInformation_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_messageType !=  os_76) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__UplinkApplicationData::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 4;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(4);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__CellIdentifier_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, BSSMAP__IE__Layer3Information_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, BSSMAP__IE__ApplicationDataInformation_descr_.raw);
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_cellIdentifier.RAW_encode(BSSMAP__IE__CellIdentifier_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_layer3Information.RAW_encode(BSSMAP__IE__Layer3Information_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_applicationDataInformation.RAW_encode(BSSMAP__IE__ApplicationDataInformation_descr_, *myleaf.body.node.nodes[3]);
  if (field_messageType !=  os_76) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_76.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__UplinkApplicationData_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__CellIdentifier_template field_cellIdentifier;
BSSMAP__IE__Layer3Information_template field_layer3Information;
BSSMAP__IE__ApplicationDataInformation_template field_applicationDataInformation;
};

void PDU__BSSMAP__UplinkApplicationData_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_cellIdentifier = ANY_VALUE;
single_value->field_layer3Information = ANY_VALUE;
single_value->field_applicationDataInformation = ANY_VALUE;
}
}
}

void PDU__BSSMAP__UplinkApplicationData_template::copy_value(const PDU__BSSMAP__UplinkApplicationData& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.cellIdentifier().is_bound()) {
  single_value->field_cellIdentifier = other_value.cellIdentifier();
} else {
  single_value->field_cellIdentifier.clean_up();
}
if (other_value.layer3Information().is_bound()) {
  single_value->field_layer3Information = other_value.layer3Information();
} else {
  single_value->field_layer3Information.clean_up();
}
if (other_value.applicationDataInformation().is_bound()) {
  single_value->field_applicationDataInformation = other_value.applicationDataInformation();
} else {
  single_value->field_applicationDataInformation.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__UplinkApplicationData_template::copy_template(const PDU__BSSMAP__UplinkApplicationData_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cellIdentifier().get_selection()) {
single_value->field_cellIdentifier = other_value.cellIdentifier();
} else {
single_value->field_cellIdentifier.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.layer3Information().get_selection()) {
single_value->field_layer3Information = other_value.layer3Information();
} else {
single_value->field_layer3Information.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.applicationDataInformation().get_selection()) {
single_value->field_applicationDataInformation = other_value.applicationDataInformation();
} else {
single_value->field_applicationDataInformation.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__UplinkApplicationData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__UplinkApplicationData_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__UplinkApplicationData_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__UplinkApplicationData_template::PDU__BSSMAP__UplinkApplicationData_template()
{
}

PDU__BSSMAP__UplinkApplicationData_template::PDU__BSSMAP__UplinkApplicationData_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__UplinkApplicationData_template::PDU__BSSMAP__UplinkApplicationData_template(const PDU__BSSMAP__UplinkApplicationData& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__UplinkApplicationData_template::PDU__BSSMAP__UplinkApplicationData_template(const OPTIONAL<PDU__BSSMAP__UplinkApplicationData>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__UplinkApplicationData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData from an unbound optional field.");
}
}

PDU__BSSMAP__UplinkApplicationData_template::PDU__BSSMAP__UplinkApplicationData_template(PDU__BSSMAP__UplinkApplicationData_template* p_precondition, PDU__BSSMAP__UplinkApplicationData_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__UplinkApplicationData_template::PDU__BSSMAP__UplinkApplicationData_template(Dynamic_Match_Interface<PDU__BSSMAP__UplinkApplicationData>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__UplinkApplicationData>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__UplinkApplicationData_template::PDU__BSSMAP__UplinkApplicationData_template(const PDU__BSSMAP__UplinkApplicationData_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__UplinkApplicationData_template::~PDU__BSSMAP__UplinkApplicationData_template()
{
clean_up();
}

PDU__BSSMAP__UplinkApplicationData_template& PDU__BSSMAP__UplinkApplicationData_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__UplinkApplicationData_template& PDU__BSSMAP__UplinkApplicationData_template::operator=(const PDU__BSSMAP__UplinkApplicationData& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__UplinkApplicationData_template& PDU__BSSMAP__UplinkApplicationData_template::operator=(const OPTIONAL<PDU__BSSMAP__UplinkApplicationData>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__UplinkApplicationData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData.");
}
return *this;
}

PDU__BSSMAP__UplinkApplicationData_template& PDU__BSSMAP__UplinkApplicationData_template::operator=(const PDU__BSSMAP__UplinkApplicationData_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__UplinkApplicationData_template::match(const PDU__BSSMAP__UplinkApplicationData& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.cellIdentifier().is_bound()) return FALSE;
if(!single_value->field_cellIdentifier.match(other_value.cellIdentifier(), legacy))return FALSE;
if(!other_value.layer3Information().is_bound()) return FALSE;
if(!single_value->field_layer3Information.match(other_value.layer3Information(), legacy))return FALSE;
if(!other_value.applicationDataInformation().is_bound()) return FALSE;
if(!single_value->field_applicationDataInformation.match(other_value.applicationDataInformation(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData.");
}
return FALSE;
}

boolean PDU__BSSMAP__UplinkApplicationData_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_cellIdentifier.is_bound()
 || single_value->field_layer3Information.is_bound()
 || single_value->field_applicationDataInformation.is_bound();
}

boolean PDU__BSSMAP__UplinkApplicationData_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_cellIdentifier.is_value()
 && single_value->field_layer3Information.is_value()
 && single_value->field_applicationDataInformation.is_value();
}

void PDU__BSSMAP__UplinkApplicationData_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__UplinkApplicationData PDU__BSSMAP__UplinkApplicationData_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData.");
PDU__BSSMAP__UplinkApplicationData ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_cellIdentifier.is_bound()) {
ret_val.cellIdentifier() = single_value->field_cellIdentifier.valueof();
}
if (single_value->field_layer3Information.is_bound()) {
ret_val.layer3Information() = single_value->field_layer3Information.valueof();
}
if (single_value->field_applicationDataInformation.is_bound()) {
ret_val.applicationDataInformation() = single_value->field_applicationDataInformation.valueof();
}
return ret_val;
}

void PDU__BSSMAP__UplinkApplicationData_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__UplinkApplicationData_template[list_length];
}

PDU__BSSMAP__UplinkApplicationData_template& PDU__BSSMAP__UplinkApplicationData_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__UplinkApplicationData_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__UplinkApplicationData_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData.");
return single_value->field_messageType;
}

BSSMAP__IE__CellIdentifier_template& PDU__BSSMAP__UplinkApplicationData_template::cellIdentifier()
{
set_specific();
return single_value->field_cellIdentifier;
}

const BSSMAP__IE__CellIdentifier_template& PDU__BSSMAP__UplinkApplicationData_template::cellIdentifier() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cellIdentifier of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData.");
return single_value->field_cellIdentifier;
}

BSSMAP__IE__Layer3Information_template& PDU__BSSMAP__UplinkApplicationData_template::layer3Information()
{
set_specific();
return single_value->field_layer3Information;
}

const BSSMAP__IE__Layer3Information_template& PDU__BSSMAP__UplinkApplicationData_template::layer3Information() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field layer3Information of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData.");
return single_value->field_layer3Information;
}

BSSMAP__IE__ApplicationDataInformation_template& PDU__BSSMAP__UplinkApplicationData_template::applicationDataInformation()
{
set_specific();
return single_value->field_applicationDataInformation;
}

const BSSMAP__IE__ApplicationDataInformation_template& PDU__BSSMAP__UplinkApplicationData_template::applicationDataInformation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field applicationDataInformation of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData.");
return single_value->field_applicationDataInformation;
}

int PDU__BSSMAP__UplinkApplicationData_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 4;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData.");
  }
  return 0;
}

void PDU__BSSMAP__UplinkApplicationData_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", cellIdentifier := ");
single_value->field_cellIdentifier.log();
TTCN_Logger::log_event_str(", layer3Information := ");
single_value->field_layer3Information.log();
TTCN_Logger::log_event_str(", applicationDataInformation := ");
single_value->field_applicationDataInformation.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__UplinkApplicationData_template::log_match(const PDU__BSSMAP__UplinkApplicationData& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cellIdentifier.match(match_value.cellIdentifier(), legacy)){
TTCN_Logger::log_logmatch_info(".cellIdentifier");
single_value->field_cellIdentifier.log_match(match_value.cellIdentifier(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_layer3Information.match(match_value.layer3Information(), legacy)){
TTCN_Logger::log_logmatch_info(".layer3Information");
single_value->field_layer3Information.log_match(match_value.layer3Information(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_applicationDataInformation.match(match_value.applicationDataInformation(), legacy)){
TTCN_Logger::log_logmatch_info(".applicationDataInformation");
single_value->field_applicationDataInformation.log_match(match_value.applicationDataInformation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", cellIdentifier := ");
single_value->field_cellIdentifier.log_match(match_value.cellIdentifier(), legacy);
TTCN_Logger::log_event_str(", layer3Information := ");
single_value->field_layer3Information.log_match(match_value.layer3Information(), legacy);
TTCN_Logger::log_event_str(", applicationDataInformation := ");
single_value->field_applicationDataInformation.log_match(match_value.applicationDataInformation(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__UplinkApplicationData_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (cellIdentifier().is_bound()) cellIdentifier().set_implicit_omit();
if (layer3Information().is_bound()) layer3Information().set_implicit_omit();
if (applicationDataInformation().is_bound()) applicationDataInformation().set_implicit_omit();
}

void PDU__BSSMAP__UplinkApplicationData_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_cellIdentifier.encode_text(text_buf);
single_value->field_layer3Information.encode_text(text_buf);
single_value->field_applicationDataInformation.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData.");
}
}

void PDU__BSSMAP__UplinkApplicationData_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_cellIdentifier.decode_text(text_buf);
single_value->field_layer3Information.decode_text(text_buf);
single_value->field_applicationDataInformation.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__UplinkApplicationData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData.");
}
}

void PDU__BSSMAP__UplinkApplicationData_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__UplinkApplicationData_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cellIdentifier().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) layer3Information().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) applicationDataInformation().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cellIdentifier")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cellIdentifier().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "layer3Information")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          layer3Information().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "applicationDataInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          applicationDataInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_UplinkApplicationData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__UplinkApplicationData_template* precondition = new PDU__BSSMAP__UplinkApplicationData_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__UplinkApplicationData_template* implied_template = new PDU__BSSMAP__UplinkApplicationData_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__UplinkApplicationData_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_UplinkApplicationData");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__UplinkApplicationData_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkApplicationData");
single_value->field_cellIdentifier.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkApplicationData");
single_value->field_layer3Information.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkApplicationData");
single_value->field_applicationDataInformation.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkApplicationData");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkApplicationData");
}

boolean PDU__BSSMAP__UplinkApplicationData_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__UplinkApplicationData_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__UplinkReleaseIndication::PDU__BSSMAP__UplinkReleaseIndication()
{
}

PDU__BSSMAP__UplinkReleaseIndication::PDU__BSSMAP__UplinkReleaseIndication(const OCTETSTRING& par_messageType,
    const BSSMAP__IE__Cause& par_cause,
    const OPTIONAL< BSSMAP__IE__TalkerPriority >& par_talkerPriority)
  :   field_messageType(par_messageType),
  field_cause(par_cause),
  field_talkerPriority(par_talkerPriority)
{
}

PDU__BSSMAP__UplinkReleaseIndication::PDU__BSSMAP__UplinkReleaseIndication(const PDU__BSSMAP__UplinkReleaseIndication& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.cause().is_bound()) field_cause = other_value.cause();
else field_cause.clean_up();
if (other_value.talkerPriority().is_bound()) field_talkerPriority = other_value.talkerPriority();
else field_talkerPriority.clean_up();
}

void PDU__BSSMAP__UplinkReleaseIndication::clean_up()
{
field_messageType.clean_up();
field_cause.clean_up();
field_talkerPriority.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__UplinkReleaseIndication::get_descriptor() const { return &PDU__BSSMAP__UplinkReleaseIndication_descr_; }
PDU__BSSMAP__UplinkReleaseIndication& PDU__BSSMAP__UplinkReleaseIndication::operator=(const PDU__BSSMAP__UplinkReleaseIndication& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.cause().is_bound()) field_cause = other_value.cause();
  else field_cause.clean_up();
  if (other_value.talkerPriority().is_bound()) field_talkerPriority = other_value.talkerPriority();
  else field_talkerPriority.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__UplinkReleaseIndication::operator==(const PDU__BSSMAP__UplinkReleaseIndication& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_cause==other_value.field_cause
  && field_talkerPriority==other_value.field_talkerPriority;
}

boolean PDU__BSSMAP__UplinkReleaseIndication::is_bound() const
{
return (field_messageType.is_bound())
  || (field_cause.is_bound())
  || (OPTIONAL_OMIT == field_talkerPriority.get_selection() || field_talkerPriority.is_bound());
}
boolean PDU__BSSMAP__UplinkReleaseIndication::is_value() const
{
return field_messageType.is_value()
  && field_cause.is_value()
  && (OPTIONAL_OMIT == field_talkerPriority.get_selection() || field_talkerPriority.is_value());
}
int PDU__BSSMAP__UplinkReleaseIndication::size_of() const
{
  int ret_val = 2;
  if (field_talkerPriority.ispresent()) ret_val++;
  return ret_val;
}

void PDU__BSSMAP__UplinkReleaseIndication::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", cause := ");
field_cause.log();
TTCN_Logger::log_event_str(", talkerPriority := ");
field_talkerPriority.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__UplinkReleaseIndication::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (cause().is_bound()) cause().set_implicit_omit();
if (!talkerPriority().is_bound()) talkerPriority() = OMIT_VALUE;
else talkerPriority().set_implicit_omit();
}

void PDU__BSSMAP__UplinkReleaseIndication::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) talkerPriority().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "talkerPriority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          talkerPriority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication");
  }
}

void PDU__BSSMAP__UplinkReleaseIndication::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_cause.encode_text(text_buf);
field_talkerPriority.encode_text(text_buf);
}

void PDU__BSSMAP__UplinkReleaseIndication::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_cause.decode_text(text_buf);
field_talkerPriority.decode_text(text_buf);
}

void PDU__BSSMAP__UplinkReleaseIndication::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__UplinkReleaseIndication::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__UplinkReleaseIndication::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__Cause_descr_.raw->forceomit);
  decoded_field_length = field_cause.RAW_decode(BSSMAP__IE__Cause_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_talkerPriority = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, BSSMAP__IE__TalkerPriority_descr_.raw->forceomit);
  decoded_field_length = field_talkerPriority().RAW_decode(BSSMAP__IE__TalkerPriority_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_talkerPriority = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_talkerPriority=OMIT_VALUE;
  if (field_messageType !=  os_113) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__UplinkReleaseIndication::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__Cause_descr_.raw);
  if (field_talkerPriority.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, BSSMAP__IE__TalkerPriority_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_cause.RAW_encode(BSSMAP__IE__Cause_descr_, *myleaf.body.node.nodes[1]);
  if (field_talkerPriority.ispresent()) {
  encoded_length += field_talkerPriority().RAW_encode(BSSMAP__IE__TalkerPriority_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_messageType !=  os_113) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_113.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__UplinkReleaseIndication_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__Cause_template field_cause;
BSSMAP__IE__TalkerPriority_template field_talkerPriority;
};

void PDU__BSSMAP__UplinkReleaseIndication_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_cause = ANY_VALUE;
single_value->field_talkerPriority = ANY_OR_OMIT;
}
}
}

void PDU__BSSMAP__UplinkReleaseIndication_template::copy_value(const PDU__BSSMAP__UplinkReleaseIndication& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.cause().is_bound()) {
  single_value->field_cause = other_value.cause();
} else {
  single_value->field_cause.clean_up();
}
if (other_value.talkerPriority().is_bound()) {
  if (other_value.talkerPriority().ispresent()) single_value->field_talkerPriority = other_value.talkerPriority()();
  else single_value->field_talkerPriority = OMIT_VALUE;
} else {
  single_value->field_talkerPriority.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__UplinkReleaseIndication_template::copy_template(const PDU__BSSMAP__UplinkReleaseIndication_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cause().get_selection()) {
single_value->field_cause = other_value.cause();
} else {
single_value->field_cause.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.talkerPriority().get_selection()) {
single_value->field_talkerPriority = other_value.talkerPriority();
} else {
single_value->field_talkerPriority.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__UplinkReleaseIndication_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__UplinkReleaseIndication_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__UplinkReleaseIndication_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__UplinkReleaseIndication_template::PDU__BSSMAP__UplinkReleaseIndication_template()
{
}

PDU__BSSMAP__UplinkReleaseIndication_template::PDU__BSSMAP__UplinkReleaseIndication_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__UplinkReleaseIndication_template::PDU__BSSMAP__UplinkReleaseIndication_template(const PDU__BSSMAP__UplinkReleaseIndication& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__UplinkReleaseIndication_template::PDU__BSSMAP__UplinkReleaseIndication_template(const OPTIONAL<PDU__BSSMAP__UplinkReleaseIndication>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__UplinkReleaseIndication&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication from an unbound optional field.");
}
}

PDU__BSSMAP__UplinkReleaseIndication_template::PDU__BSSMAP__UplinkReleaseIndication_template(PDU__BSSMAP__UplinkReleaseIndication_template* p_precondition, PDU__BSSMAP__UplinkReleaseIndication_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__UplinkReleaseIndication_template::PDU__BSSMAP__UplinkReleaseIndication_template(Dynamic_Match_Interface<PDU__BSSMAP__UplinkReleaseIndication>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__UplinkReleaseIndication>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__UplinkReleaseIndication_template::PDU__BSSMAP__UplinkReleaseIndication_template(const PDU__BSSMAP__UplinkReleaseIndication_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__UplinkReleaseIndication_template::~PDU__BSSMAP__UplinkReleaseIndication_template()
{
clean_up();
}

PDU__BSSMAP__UplinkReleaseIndication_template& PDU__BSSMAP__UplinkReleaseIndication_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__UplinkReleaseIndication_template& PDU__BSSMAP__UplinkReleaseIndication_template::operator=(const PDU__BSSMAP__UplinkReleaseIndication& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__UplinkReleaseIndication_template& PDU__BSSMAP__UplinkReleaseIndication_template::operator=(const OPTIONAL<PDU__BSSMAP__UplinkReleaseIndication>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__UplinkReleaseIndication&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication.");
}
return *this;
}

PDU__BSSMAP__UplinkReleaseIndication_template& PDU__BSSMAP__UplinkReleaseIndication_template::operator=(const PDU__BSSMAP__UplinkReleaseIndication_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__UplinkReleaseIndication_template::match(const PDU__BSSMAP__UplinkReleaseIndication& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.cause().is_bound()) return FALSE;
if(!single_value->field_cause.match(other_value.cause(), legacy))return FALSE;
if(!other_value.talkerPriority().is_bound()) return FALSE;
if((other_value.talkerPriority().ispresent() ? !single_value->field_talkerPriority.match((const BSSMAP__IE__TalkerPriority&)other_value.talkerPriority(), legacy) : !single_value->field_talkerPriority.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication.");
}
return FALSE;
}

boolean PDU__BSSMAP__UplinkReleaseIndication_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_cause.is_bound()
 || (single_value->field_talkerPriority.is_omit() || single_value->field_talkerPriority.is_bound());
}

boolean PDU__BSSMAP__UplinkReleaseIndication_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_cause.is_value()
 && (single_value->field_talkerPriority.is_omit() || single_value->field_talkerPriority.is_value());
}

void PDU__BSSMAP__UplinkReleaseIndication_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__UplinkReleaseIndication PDU__BSSMAP__UplinkReleaseIndication_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication.");
PDU__BSSMAP__UplinkReleaseIndication ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_cause.is_bound()) {
ret_val.cause() = single_value->field_cause.valueof();
}
if (single_value->field_talkerPriority.is_omit()) ret_val.talkerPriority() = OMIT_VALUE;
else if (single_value->field_talkerPriority.is_bound()) {
ret_val.talkerPriority() = single_value->field_talkerPriority.valueof();
}
return ret_val;
}

void PDU__BSSMAP__UplinkReleaseIndication_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__UplinkReleaseIndication_template[list_length];
}

PDU__BSSMAP__UplinkReleaseIndication_template& PDU__BSSMAP__UplinkReleaseIndication_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__UplinkReleaseIndication_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__UplinkReleaseIndication_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication.");
return single_value->field_messageType;
}

BSSMAP__IE__Cause_template& PDU__BSSMAP__UplinkReleaseIndication_template::cause()
{
set_specific();
return single_value->field_cause;
}

const BSSMAP__IE__Cause_template& PDU__BSSMAP__UplinkReleaseIndication_template::cause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cause of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication.");
return single_value->field_cause;
}

BSSMAP__IE__TalkerPriority_template& PDU__BSSMAP__UplinkReleaseIndication_template::talkerPriority()
{
set_specific();
return single_value->field_talkerPriority;
}

const BSSMAP__IE__TalkerPriority_template& PDU__BSSMAP__UplinkReleaseIndication_template::talkerPriority() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field talkerPriority of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication.");
return single_value->field_talkerPriority;
}

int PDU__BSSMAP__UplinkReleaseIndication_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_talkerPriority.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication.");
  }
  return 0;
}

void PDU__BSSMAP__UplinkReleaseIndication_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log();
TTCN_Logger::log_event_str(", talkerPriority := ");
single_value->field_talkerPriority.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__UplinkReleaseIndication_template::log_match(const PDU__BSSMAP__UplinkReleaseIndication& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cause.match(match_value.cause(), legacy)){
TTCN_Logger::log_logmatch_info(".cause");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.talkerPriority().ispresent()){
if(!single_value->field_talkerPriority.match(match_value.talkerPriority(), legacy)){
TTCN_Logger::log_logmatch_info(".talkerPriority");
single_value->field_talkerPriority.log_match(match_value.talkerPriority(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_talkerPriority.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".talkerPriority := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_talkerPriority.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::log_event_str(", talkerPriority := ");
if (match_value.talkerPriority().ispresent()) {
single_value->field_talkerPriority.log_match(match_value.talkerPriority(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_talkerPriority.log();
if (single_value->field_talkerPriority.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__UplinkReleaseIndication_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (cause().is_bound()) cause().set_implicit_omit();
if (!talkerPriority().is_bound()) talkerPriority() = OMIT_VALUE;
else talkerPriority().set_implicit_omit();
}

void PDU__BSSMAP__UplinkReleaseIndication_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_cause.encode_text(text_buf);
single_value->field_talkerPriority.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication.");
}
}

void PDU__BSSMAP__UplinkReleaseIndication_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_cause.decode_text(text_buf);
single_value->field_talkerPriority.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__UplinkReleaseIndication_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication.");
}
}

void PDU__BSSMAP__UplinkReleaseIndication_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__UplinkReleaseIndication_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) talkerPriority().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "talkerPriority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          talkerPriority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__UplinkReleaseIndication_template* precondition = new PDU__BSSMAP__UplinkReleaseIndication_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__UplinkReleaseIndication_template* implied_template = new PDU__BSSMAP__UplinkReleaseIndication_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__UplinkReleaseIndication_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__UplinkReleaseIndication_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication");
single_value->field_cause.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication");
single_value->field_talkerPriority.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkReleaseIndication");
}

boolean PDU__BSSMAP__UplinkReleaseIndication_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__UplinkReleaseIndication_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__UplinkRejectCommand::PDU__BSSMAP__UplinkRejectCommand()
{
}

PDU__BSSMAP__UplinkRejectCommand::PDU__BSSMAP__UplinkRejectCommand(const OCTETSTRING& par_messageType,
    const BSSMAP__IE__Cause& par_cause,
    const OPTIONAL< BSSMAP__IE__TalkerPriority >& par_currentTalkerPriority,
    const OPTIONAL< BSSMAP__IE__TalkerPriority >& par_rejectedTalkerPriority,
    const OPTIONAL< BSSMAP__IE__TalkerIdentity >& par_talkerIdentity)
  :   field_messageType(par_messageType),
  field_cause(par_cause),
  field_currentTalkerPriority(par_currentTalkerPriority),
  field_rejectedTalkerPriority(par_rejectedTalkerPriority),
  field_talkerIdentity(par_talkerIdentity)
{
}

PDU__BSSMAP__UplinkRejectCommand::PDU__BSSMAP__UplinkRejectCommand(const PDU__BSSMAP__UplinkRejectCommand& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.cause().is_bound()) field_cause = other_value.cause();
else field_cause.clean_up();
if (other_value.currentTalkerPriority().is_bound()) field_currentTalkerPriority = other_value.currentTalkerPriority();
else field_currentTalkerPriority.clean_up();
if (other_value.rejectedTalkerPriority().is_bound()) field_rejectedTalkerPriority = other_value.rejectedTalkerPriority();
else field_rejectedTalkerPriority.clean_up();
if (other_value.talkerIdentity().is_bound()) field_talkerIdentity = other_value.talkerIdentity();
else field_talkerIdentity.clean_up();
}

void PDU__BSSMAP__UplinkRejectCommand::clean_up()
{
field_messageType.clean_up();
field_cause.clean_up();
field_currentTalkerPriority.clean_up();
field_rejectedTalkerPriority.clean_up();
field_talkerIdentity.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__UplinkRejectCommand::get_descriptor() const { return &PDU__BSSMAP__UplinkRejectCommand_descr_; }
PDU__BSSMAP__UplinkRejectCommand& PDU__BSSMAP__UplinkRejectCommand::operator=(const PDU__BSSMAP__UplinkRejectCommand& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.cause().is_bound()) field_cause = other_value.cause();
  else field_cause.clean_up();
  if (other_value.currentTalkerPriority().is_bound()) field_currentTalkerPriority = other_value.currentTalkerPriority();
  else field_currentTalkerPriority.clean_up();
  if (other_value.rejectedTalkerPriority().is_bound()) field_rejectedTalkerPriority = other_value.rejectedTalkerPriority();
  else field_rejectedTalkerPriority.clean_up();
  if (other_value.talkerIdentity().is_bound()) field_talkerIdentity = other_value.talkerIdentity();
  else field_talkerIdentity.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__UplinkRejectCommand::operator==(const PDU__BSSMAP__UplinkRejectCommand& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_cause==other_value.field_cause
  && field_currentTalkerPriority==other_value.field_currentTalkerPriority
  && field_rejectedTalkerPriority==other_value.field_rejectedTalkerPriority
  && field_talkerIdentity==other_value.field_talkerIdentity;
}

boolean PDU__BSSMAP__UplinkRejectCommand::is_bound() const
{
return (field_messageType.is_bound())
  || (field_cause.is_bound())
  || (OPTIONAL_OMIT == field_currentTalkerPriority.get_selection() || field_currentTalkerPriority.is_bound())
  || (OPTIONAL_OMIT == field_rejectedTalkerPriority.get_selection() || field_rejectedTalkerPriority.is_bound())
  || (OPTIONAL_OMIT == field_talkerIdentity.get_selection() || field_talkerIdentity.is_bound());
}
boolean PDU__BSSMAP__UplinkRejectCommand::is_value() const
{
return field_messageType.is_value()
  && field_cause.is_value()
  && (OPTIONAL_OMIT == field_currentTalkerPriority.get_selection() || field_currentTalkerPriority.is_value())
  && (OPTIONAL_OMIT == field_rejectedTalkerPriority.get_selection() || field_rejectedTalkerPriority.is_value())
  && (OPTIONAL_OMIT == field_talkerIdentity.get_selection() || field_talkerIdentity.is_value());
}
int PDU__BSSMAP__UplinkRejectCommand::size_of() const
{
  int ret_val = 2;
  if (field_currentTalkerPriority.ispresent()) ret_val++;
  if (field_rejectedTalkerPriority.ispresent()) ret_val++;
  if (field_talkerIdentity.ispresent()) ret_val++;
  return ret_val;
}

void PDU__BSSMAP__UplinkRejectCommand::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", cause := ");
field_cause.log();
TTCN_Logger::log_event_str(", currentTalkerPriority := ");
field_currentTalkerPriority.log();
TTCN_Logger::log_event_str(", rejectedTalkerPriority := ");
field_rejectedTalkerPriority.log();
TTCN_Logger::log_event_str(", talkerIdentity := ");
field_talkerIdentity.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__UplinkRejectCommand::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (cause().is_bound()) cause().set_implicit_omit();
if (!currentTalkerPriority().is_bound()) currentTalkerPriority() = OMIT_VALUE;
else currentTalkerPriority().set_implicit_omit();
if (!rejectedTalkerPriority().is_bound()) rejectedTalkerPriority() = OMIT_VALUE;
else rejectedTalkerPriority().set_implicit_omit();
if (!talkerIdentity().is_bound()) talkerIdentity() = OMIT_VALUE;
else talkerIdentity().set_implicit_omit();
}

void PDU__BSSMAP__UplinkRejectCommand::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) currentTalkerPriority().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rejectedTalkerPriority().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) talkerIdentity().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "currentTalkerPriority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          currentTalkerPriority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rejectedTalkerPriority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rejectedTalkerPriority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "talkerIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          talkerIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand");
  }
}

void PDU__BSSMAP__UplinkRejectCommand::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_cause.encode_text(text_buf);
field_currentTalkerPriority.encode_text(text_buf);
field_rejectedTalkerPriority.encode_text(text_buf);
field_talkerIdentity.encode_text(text_buf);
}

void PDU__BSSMAP__UplinkRejectCommand::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_cause.decode_text(text_buf);
field_currentTalkerPriority.decode_text(text_buf);
field_rejectedTalkerPriority.decode_text(text_buf);
field_talkerIdentity.decode_text(text_buf);
}

void PDU__BSSMAP__UplinkRejectCommand::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__UplinkRejectCommand::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__UplinkRejectCommand::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__Cause_descr_.raw->forceomit);
  decoded_field_length = field_cause.RAW_decode(BSSMAP__IE__Cause_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_currentTalkerPriority = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, BSSMAP__IE__TalkerPriority_descr_.raw->forceomit);
  decoded_field_length = field_currentTalkerPriority().RAW_decode(BSSMAP__IE__TalkerPriority_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_currentTalkerPriority = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_currentTalkerPriority=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_rejectedTalkerPriority = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, BSSMAP__IE__TalkerPriority_descr_.raw->forceomit);
  decoded_field_length = field_rejectedTalkerPriority().RAW_decode(BSSMAP__IE__TalkerPriority_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_rejectedTalkerPriority = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_rejectedTalkerPriority=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_talkerIdentity = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, BSSMAP__IE__TalkerIdentity_descr_.raw->forceomit);
  decoded_field_length = field_talkerIdentity().RAW_decode(BSSMAP__IE__TalkerIdentity_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_talkerIdentity = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_talkerIdentity=OMIT_VALUE;
  if (field_messageType !=  os_97) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__UplinkRejectCommand::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__Cause_descr_.raw);
  if (field_currentTalkerPriority.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, BSSMAP__IE__TalkerPriority_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_rejectedTalkerPriority.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, BSSMAP__IE__TalkerPriority_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_talkerIdentity.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, BSSMAP__IE__TalkerIdentity_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_cause.RAW_encode(BSSMAP__IE__Cause_descr_, *myleaf.body.node.nodes[1]);
  if (field_currentTalkerPriority.ispresent()) {
  encoded_length += field_currentTalkerPriority().RAW_encode(BSSMAP__IE__TalkerPriority_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_rejectedTalkerPriority.ispresent()) {
  encoded_length += field_rejectedTalkerPriority().RAW_encode(BSSMAP__IE__TalkerPriority_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_talkerIdentity.ispresent()) {
  encoded_length += field_talkerIdentity().RAW_encode(BSSMAP__IE__TalkerIdentity_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_messageType !=  os_97) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_97.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__UplinkRejectCommand_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__Cause_template field_cause;
BSSMAP__IE__TalkerPriority_template field_currentTalkerPriority;
BSSMAP__IE__TalkerPriority_template field_rejectedTalkerPriority;
BSSMAP__IE__TalkerIdentity_template field_talkerIdentity;
};

void PDU__BSSMAP__UplinkRejectCommand_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_cause = ANY_VALUE;
single_value->field_currentTalkerPriority = ANY_OR_OMIT;
single_value->field_rejectedTalkerPriority = ANY_OR_OMIT;
single_value->field_talkerIdentity = ANY_OR_OMIT;
}
}
}

void PDU__BSSMAP__UplinkRejectCommand_template::copy_value(const PDU__BSSMAP__UplinkRejectCommand& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.cause().is_bound()) {
  single_value->field_cause = other_value.cause();
} else {
  single_value->field_cause.clean_up();
}
if (other_value.currentTalkerPriority().is_bound()) {
  if (other_value.currentTalkerPriority().ispresent()) single_value->field_currentTalkerPriority = other_value.currentTalkerPriority()();
  else single_value->field_currentTalkerPriority = OMIT_VALUE;
} else {
  single_value->field_currentTalkerPriority.clean_up();
}
if (other_value.rejectedTalkerPriority().is_bound()) {
  if (other_value.rejectedTalkerPriority().ispresent()) single_value->field_rejectedTalkerPriority = other_value.rejectedTalkerPriority()();
  else single_value->field_rejectedTalkerPriority = OMIT_VALUE;
} else {
  single_value->field_rejectedTalkerPriority.clean_up();
}
if (other_value.talkerIdentity().is_bound()) {
  if (other_value.talkerIdentity().ispresent()) single_value->field_talkerIdentity = other_value.talkerIdentity()();
  else single_value->field_talkerIdentity = OMIT_VALUE;
} else {
  single_value->field_talkerIdentity.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__UplinkRejectCommand_template::copy_template(const PDU__BSSMAP__UplinkRejectCommand_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cause().get_selection()) {
single_value->field_cause = other_value.cause();
} else {
single_value->field_cause.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.currentTalkerPriority().get_selection()) {
single_value->field_currentTalkerPriority = other_value.currentTalkerPriority();
} else {
single_value->field_currentTalkerPriority.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rejectedTalkerPriority().get_selection()) {
single_value->field_rejectedTalkerPriority = other_value.rejectedTalkerPriority();
} else {
single_value->field_rejectedTalkerPriority.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.talkerIdentity().get_selection()) {
single_value->field_talkerIdentity = other_value.talkerIdentity();
} else {
single_value->field_talkerIdentity.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__UplinkRejectCommand_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__UplinkRejectCommand_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__UplinkRejectCommand_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__UplinkRejectCommand_template::PDU__BSSMAP__UplinkRejectCommand_template()
{
}

PDU__BSSMAP__UplinkRejectCommand_template::PDU__BSSMAP__UplinkRejectCommand_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__UplinkRejectCommand_template::PDU__BSSMAP__UplinkRejectCommand_template(const PDU__BSSMAP__UplinkRejectCommand& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__UplinkRejectCommand_template::PDU__BSSMAP__UplinkRejectCommand_template(const OPTIONAL<PDU__BSSMAP__UplinkRejectCommand>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__UplinkRejectCommand&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand from an unbound optional field.");
}
}

PDU__BSSMAP__UplinkRejectCommand_template::PDU__BSSMAP__UplinkRejectCommand_template(PDU__BSSMAP__UplinkRejectCommand_template* p_precondition, PDU__BSSMAP__UplinkRejectCommand_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__UplinkRejectCommand_template::PDU__BSSMAP__UplinkRejectCommand_template(Dynamic_Match_Interface<PDU__BSSMAP__UplinkRejectCommand>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__UplinkRejectCommand>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__UplinkRejectCommand_template::PDU__BSSMAP__UplinkRejectCommand_template(const PDU__BSSMAP__UplinkRejectCommand_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__UplinkRejectCommand_template::~PDU__BSSMAP__UplinkRejectCommand_template()
{
clean_up();
}

PDU__BSSMAP__UplinkRejectCommand_template& PDU__BSSMAP__UplinkRejectCommand_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__UplinkRejectCommand_template& PDU__BSSMAP__UplinkRejectCommand_template::operator=(const PDU__BSSMAP__UplinkRejectCommand& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__UplinkRejectCommand_template& PDU__BSSMAP__UplinkRejectCommand_template::operator=(const OPTIONAL<PDU__BSSMAP__UplinkRejectCommand>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__UplinkRejectCommand&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand.");
}
return *this;
}

PDU__BSSMAP__UplinkRejectCommand_template& PDU__BSSMAP__UplinkRejectCommand_template::operator=(const PDU__BSSMAP__UplinkRejectCommand_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__UplinkRejectCommand_template::match(const PDU__BSSMAP__UplinkRejectCommand& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.cause().is_bound()) return FALSE;
if(!single_value->field_cause.match(other_value.cause(), legacy))return FALSE;
if(!other_value.currentTalkerPriority().is_bound()) return FALSE;
if((other_value.currentTalkerPriority().ispresent() ? !single_value->field_currentTalkerPriority.match((const BSSMAP__IE__TalkerPriority&)other_value.currentTalkerPriority(), legacy) : !single_value->field_currentTalkerPriority.match_omit(legacy)))return FALSE;
if(!other_value.rejectedTalkerPriority().is_bound()) return FALSE;
if((other_value.rejectedTalkerPriority().ispresent() ? !single_value->field_rejectedTalkerPriority.match((const BSSMAP__IE__TalkerPriority&)other_value.rejectedTalkerPriority(), legacy) : !single_value->field_rejectedTalkerPriority.match_omit(legacy)))return FALSE;
if(!other_value.talkerIdentity().is_bound()) return FALSE;
if((other_value.talkerIdentity().ispresent() ? !single_value->field_talkerIdentity.match((const BSSMAP__IE__TalkerIdentity&)other_value.talkerIdentity(), legacy) : !single_value->field_talkerIdentity.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand.");
}
return FALSE;
}

boolean PDU__BSSMAP__UplinkRejectCommand_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_cause.is_bound()
 || (single_value->field_currentTalkerPriority.is_omit() || single_value->field_currentTalkerPriority.is_bound())
 || (single_value->field_rejectedTalkerPriority.is_omit() || single_value->field_rejectedTalkerPriority.is_bound())
 || (single_value->field_talkerIdentity.is_omit() || single_value->field_talkerIdentity.is_bound());
}

boolean PDU__BSSMAP__UplinkRejectCommand_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_cause.is_value()
 && (single_value->field_currentTalkerPriority.is_omit() || single_value->field_currentTalkerPriority.is_value())
 && (single_value->field_rejectedTalkerPriority.is_omit() || single_value->field_rejectedTalkerPriority.is_value())
 && (single_value->field_talkerIdentity.is_omit() || single_value->field_talkerIdentity.is_value());
}

void PDU__BSSMAP__UplinkRejectCommand_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__UplinkRejectCommand PDU__BSSMAP__UplinkRejectCommand_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand.");
PDU__BSSMAP__UplinkRejectCommand ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_cause.is_bound()) {
ret_val.cause() = single_value->field_cause.valueof();
}
if (single_value->field_currentTalkerPriority.is_omit()) ret_val.currentTalkerPriority() = OMIT_VALUE;
else if (single_value->field_currentTalkerPriority.is_bound()) {
ret_val.currentTalkerPriority() = single_value->field_currentTalkerPriority.valueof();
}
if (single_value->field_rejectedTalkerPriority.is_omit()) ret_val.rejectedTalkerPriority() = OMIT_VALUE;
else if (single_value->field_rejectedTalkerPriority.is_bound()) {
ret_val.rejectedTalkerPriority() = single_value->field_rejectedTalkerPriority.valueof();
}
if (single_value->field_talkerIdentity.is_omit()) ret_val.talkerIdentity() = OMIT_VALUE;
else if (single_value->field_talkerIdentity.is_bound()) {
ret_val.talkerIdentity() = single_value->field_talkerIdentity.valueof();
}
return ret_val;
}

void PDU__BSSMAP__UplinkRejectCommand_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__UplinkRejectCommand_template[list_length];
}

PDU__BSSMAP__UplinkRejectCommand_template& PDU__BSSMAP__UplinkRejectCommand_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__UplinkRejectCommand_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__UplinkRejectCommand_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand.");
return single_value->field_messageType;
}

BSSMAP__IE__Cause_template& PDU__BSSMAP__UplinkRejectCommand_template::cause()
{
set_specific();
return single_value->field_cause;
}

const BSSMAP__IE__Cause_template& PDU__BSSMAP__UplinkRejectCommand_template::cause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cause of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand.");
return single_value->field_cause;
}

BSSMAP__IE__TalkerPriority_template& PDU__BSSMAP__UplinkRejectCommand_template::currentTalkerPriority()
{
set_specific();
return single_value->field_currentTalkerPriority;
}

const BSSMAP__IE__TalkerPriority_template& PDU__BSSMAP__UplinkRejectCommand_template::currentTalkerPriority() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field currentTalkerPriority of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand.");
return single_value->field_currentTalkerPriority;
}

BSSMAP__IE__TalkerPriority_template& PDU__BSSMAP__UplinkRejectCommand_template::rejectedTalkerPriority()
{
set_specific();
return single_value->field_rejectedTalkerPriority;
}

const BSSMAP__IE__TalkerPriority_template& PDU__BSSMAP__UplinkRejectCommand_template::rejectedTalkerPriority() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rejectedTalkerPriority of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand.");
return single_value->field_rejectedTalkerPriority;
}

BSSMAP__IE__TalkerIdentity_template& PDU__BSSMAP__UplinkRejectCommand_template::talkerIdentity()
{
set_specific();
return single_value->field_talkerIdentity;
}

const BSSMAP__IE__TalkerIdentity_template& PDU__BSSMAP__UplinkRejectCommand_template::talkerIdentity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field talkerIdentity of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand.");
return single_value->field_talkerIdentity;
}

int PDU__BSSMAP__UplinkRejectCommand_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_currentTalkerPriority.is_present()) ret_val++;
      if (single_value->field_rejectedTalkerPriority.is_present()) ret_val++;
      if (single_value->field_talkerIdentity.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand.");
  }
  return 0;
}

void PDU__BSSMAP__UplinkRejectCommand_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log();
TTCN_Logger::log_event_str(", currentTalkerPriority := ");
single_value->field_currentTalkerPriority.log();
TTCN_Logger::log_event_str(", rejectedTalkerPriority := ");
single_value->field_rejectedTalkerPriority.log();
TTCN_Logger::log_event_str(", talkerIdentity := ");
single_value->field_talkerIdentity.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__UplinkRejectCommand_template::log_match(const PDU__BSSMAP__UplinkRejectCommand& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cause.match(match_value.cause(), legacy)){
TTCN_Logger::log_logmatch_info(".cause");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.currentTalkerPriority().ispresent()){
if(!single_value->field_currentTalkerPriority.match(match_value.currentTalkerPriority(), legacy)){
TTCN_Logger::log_logmatch_info(".currentTalkerPriority");
single_value->field_currentTalkerPriority.log_match(match_value.currentTalkerPriority(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_currentTalkerPriority.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".currentTalkerPriority := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_currentTalkerPriority.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.rejectedTalkerPriority().ispresent()){
if(!single_value->field_rejectedTalkerPriority.match(match_value.rejectedTalkerPriority(), legacy)){
TTCN_Logger::log_logmatch_info(".rejectedTalkerPriority");
single_value->field_rejectedTalkerPriority.log_match(match_value.rejectedTalkerPriority(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_rejectedTalkerPriority.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".rejectedTalkerPriority := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_rejectedTalkerPriority.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.talkerIdentity().ispresent()){
if(!single_value->field_talkerIdentity.match(match_value.talkerIdentity(), legacy)){
TTCN_Logger::log_logmatch_info(".talkerIdentity");
single_value->field_talkerIdentity.log_match(match_value.talkerIdentity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_talkerIdentity.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".talkerIdentity := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_talkerIdentity.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::log_event_str(", currentTalkerPriority := ");
if (match_value.currentTalkerPriority().ispresent()) {
single_value->field_currentTalkerPriority.log_match(match_value.currentTalkerPriority(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_currentTalkerPriority.log();
if (single_value->field_currentTalkerPriority.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", rejectedTalkerPriority := ");
if (match_value.rejectedTalkerPriority().ispresent()) {
single_value->field_rejectedTalkerPriority.log_match(match_value.rejectedTalkerPriority(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_rejectedTalkerPriority.log();
if (single_value->field_rejectedTalkerPriority.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", talkerIdentity := ");
if (match_value.talkerIdentity().ispresent()) {
single_value->field_talkerIdentity.log_match(match_value.talkerIdentity(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_talkerIdentity.log();
if (single_value->field_talkerIdentity.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__UplinkRejectCommand_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (cause().is_bound()) cause().set_implicit_omit();
if (!currentTalkerPriority().is_bound()) currentTalkerPriority() = OMIT_VALUE;
else currentTalkerPriority().set_implicit_omit();
if (!rejectedTalkerPriority().is_bound()) rejectedTalkerPriority() = OMIT_VALUE;
else rejectedTalkerPriority().set_implicit_omit();
if (!talkerIdentity().is_bound()) talkerIdentity() = OMIT_VALUE;
else talkerIdentity().set_implicit_omit();
}

void PDU__BSSMAP__UplinkRejectCommand_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_cause.encode_text(text_buf);
single_value->field_currentTalkerPriority.encode_text(text_buf);
single_value->field_rejectedTalkerPriority.encode_text(text_buf);
single_value->field_talkerIdentity.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand.");
}
}

void PDU__BSSMAP__UplinkRejectCommand_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_cause.decode_text(text_buf);
single_value->field_currentTalkerPriority.decode_text(text_buf);
single_value->field_rejectedTalkerPriority.decode_text(text_buf);
single_value->field_talkerIdentity.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__UplinkRejectCommand_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand.");
}
}

void PDU__BSSMAP__UplinkRejectCommand_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__UplinkRejectCommand_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) currentTalkerPriority().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rejectedTalkerPriority().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) talkerIdentity().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "currentTalkerPriority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          currentTalkerPriority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rejectedTalkerPriority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rejectedTalkerPriority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "talkerIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          talkerIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__UplinkRejectCommand_template* precondition = new PDU__BSSMAP__UplinkRejectCommand_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__UplinkRejectCommand_template* implied_template = new PDU__BSSMAP__UplinkRejectCommand_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__UplinkRejectCommand_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__UplinkRejectCommand_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand");
single_value->field_cause.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand");
single_value->field_currentTalkerPriority.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand");
single_value->field_rejectedTalkerPriority.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand");
single_value->field_talkerIdentity.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkRejectCommand");
}

boolean PDU__BSSMAP__UplinkRejectCommand_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__UplinkRejectCommand_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__UplinkReleaseCommand::PDU__BSSMAP__UplinkReleaseCommand()
{
}

PDU__BSSMAP__UplinkReleaseCommand::PDU__BSSMAP__UplinkReleaseCommand(const OCTETSTRING& par_messageType,
    const BSSMAP__IE__Cause& par_cause)
  :   field_messageType(par_messageType),
  field_cause(par_cause)
{
}

PDU__BSSMAP__UplinkReleaseCommand::PDU__BSSMAP__UplinkReleaseCommand(const PDU__BSSMAP__UplinkReleaseCommand& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.cause().is_bound()) field_cause = other_value.cause();
else field_cause.clean_up();
}

void PDU__BSSMAP__UplinkReleaseCommand::clean_up()
{
field_messageType.clean_up();
field_cause.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__UplinkReleaseCommand::get_descriptor() const { return &PDU__BSSMAP__UplinkReleaseCommand_descr_; }
PDU__BSSMAP__UplinkReleaseCommand& PDU__BSSMAP__UplinkReleaseCommand::operator=(const PDU__BSSMAP__UplinkReleaseCommand& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.cause().is_bound()) field_cause = other_value.cause();
  else field_cause.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__UplinkReleaseCommand::operator==(const PDU__BSSMAP__UplinkReleaseCommand& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_cause==other_value.field_cause;
}

boolean PDU__BSSMAP__UplinkReleaseCommand::is_bound() const
{
return (field_messageType.is_bound())
  || (field_cause.is_bound());
}
boolean PDU__BSSMAP__UplinkReleaseCommand::is_value() const
{
return field_messageType.is_value()
  && field_cause.is_value();
}
void PDU__BSSMAP__UplinkReleaseCommand::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", cause := ");
field_cause.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__UplinkReleaseCommand::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (cause().is_bound()) cause().set_implicit_omit();
}

void PDU__BSSMAP__UplinkReleaseCommand::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand");
  }
}

void PDU__BSSMAP__UplinkReleaseCommand::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_cause.encode_text(text_buf);
}

void PDU__BSSMAP__UplinkReleaseCommand::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_cause.decode_text(text_buf);
}

void PDU__BSSMAP__UplinkReleaseCommand::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__UplinkReleaseCommand::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__UplinkReleaseCommand::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__Cause_descr_.raw->forceomit);
  decoded_field_length = field_cause.RAW_decode(BSSMAP__IE__Cause_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_messageType !=  os_101) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__UplinkReleaseCommand::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__Cause_descr_.raw);
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_cause.RAW_encode(BSSMAP__IE__Cause_descr_, *myleaf.body.node.nodes[1]);
  if (field_messageType !=  os_101) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_101.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__UplinkReleaseCommand_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__Cause_template field_cause;
};

void PDU__BSSMAP__UplinkReleaseCommand_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_cause = ANY_VALUE;
}
}
}

void PDU__BSSMAP__UplinkReleaseCommand_template::copy_value(const PDU__BSSMAP__UplinkReleaseCommand& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.cause().is_bound()) {
  single_value->field_cause = other_value.cause();
} else {
  single_value->field_cause.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__UplinkReleaseCommand_template::copy_template(const PDU__BSSMAP__UplinkReleaseCommand_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cause().get_selection()) {
single_value->field_cause = other_value.cause();
} else {
single_value->field_cause.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__UplinkReleaseCommand_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__UplinkReleaseCommand_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__UplinkReleaseCommand_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__UplinkReleaseCommand_template::PDU__BSSMAP__UplinkReleaseCommand_template()
{
}

PDU__BSSMAP__UplinkReleaseCommand_template::PDU__BSSMAP__UplinkReleaseCommand_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__UplinkReleaseCommand_template::PDU__BSSMAP__UplinkReleaseCommand_template(const PDU__BSSMAP__UplinkReleaseCommand& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__UplinkReleaseCommand_template::PDU__BSSMAP__UplinkReleaseCommand_template(const OPTIONAL<PDU__BSSMAP__UplinkReleaseCommand>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__UplinkReleaseCommand&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand from an unbound optional field.");
}
}

PDU__BSSMAP__UplinkReleaseCommand_template::PDU__BSSMAP__UplinkReleaseCommand_template(PDU__BSSMAP__UplinkReleaseCommand_template* p_precondition, PDU__BSSMAP__UplinkReleaseCommand_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__UplinkReleaseCommand_template::PDU__BSSMAP__UplinkReleaseCommand_template(Dynamic_Match_Interface<PDU__BSSMAP__UplinkReleaseCommand>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__UplinkReleaseCommand>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__UplinkReleaseCommand_template::PDU__BSSMAP__UplinkReleaseCommand_template(const PDU__BSSMAP__UplinkReleaseCommand_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__UplinkReleaseCommand_template::~PDU__BSSMAP__UplinkReleaseCommand_template()
{
clean_up();
}

PDU__BSSMAP__UplinkReleaseCommand_template& PDU__BSSMAP__UplinkReleaseCommand_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__UplinkReleaseCommand_template& PDU__BSSMAP__UplinkReleaseCommand_template::operator=(const PDU__BSSMAP__UplinkReleaseCommand& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__UplinkReleaseCommand_template& PDU__BSSMAP__UplinkReleaseCommand_template::operator=(const OPTIONAL<PDU__BSSMAP__UplinkReleaseCommand>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__UplinkReleaseCommand&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand.");
}
return *this;
}

PDU__BSSMAP__UplinkReleaseCommand_template& PDU__BSSMAP__UplinkReleaseCommand_template::operator=(const PDU__BSSMAP__UplinkReleaseCommand_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__UplinkReleaseCommand_template::match(const PDU__BSSMAP__UplinkReleaseCommand& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.cause().is_bound()) return FALSE;
if(!single_value->field_cause.match(other_value.cause(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand.");
}
return FALSE;
}

boolean PDU__BSSMAP__UplinkReleaseCommand_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_cause.is_bound();
}

boolean PDU__BSSMAP__UplinkReleaseCommand_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_cause.is_value();
}

void PDU__BSSMAP__UplinkReleaseCommand_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__UplinkReleaseCommand PDU__BSSMAP__UplinkReleaseCommand_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand.");
PDU__BSSMAP__UplinkReleaseCommand ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_cause.is_bound()) {
ret_val.cause() = single_value->field_cause.valueof();
}
return ret_val;
}

void PDU__BSSMAP__UplinkReleaseCommand_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__UplinkReleaseCommand_template[list_length];
}

PDU__BSSMAP__UplinkReleaseCommand_template& PDU__BSSMAP__UplinkReleaseCommand_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__UplinkReleaseCommand_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__UplinkReleaseCommand_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand.");
return single_value->field_messageType;
}

BSSMAP__IE__Cause_template& PDU__BSSMAP__UplinkReleaseCommand_template::cause()
{
set_specific();
return single_value->field_cause;
}

const BSSMAP__IE__Cause_template& PDU__BSSMAP__UplinkReleaseCommand_template::cause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cause of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand.");
return single_value->field_cause;
}

int PDU__BSSMAP__UplinkReleaseCommand_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand.");
  }
  return 0;
}

void PDU__BSSMAP__UplinkReleaseCommand_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__UplinkReleaseCommand_template::log_match(const PDU__BSSMAP__UplinkReleaseCommand& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cause.match(match_value.cause(), legacy)){
TTCN_Logger::log_logmatch_info(".cause");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__UplinkReleaseCommand_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (cause().is_bound()) cause().set_implicit_omit();
}

void PDU__BSSMAP__UplinkReleaseCommand_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_cause.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand.");
}
}

void PDU__BSSMAP__UplinkReleaseCommand_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_cause.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__UplinkReleaseCommand_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand.");
}
}

void PDU__BSSMAP__UplinkReleaseCommand_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__UplinkReleaseCommand_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__UplinkReleaseCommand_template* precondition = new PDU__BSSMAP__UplinkReleaseCommand_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__UplinkReleaseCommand_template* implied_template = new PDU__BSSMAP__UplinkReleaseCommand_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__UplinkReleaseCommand_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__UplinkReleaseCommand_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand");
single_value->field_cause.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkReleaseCommand");
}

boolean PDU__BSSMAP__UplinkReleaseCommand_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__UplinkReleaseCommand_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__UplinkSeizedCommand::PDU__BSSMAP__UplinkSeizedCommand()
{
}

PDU__BSSMAP__UplinkSeizedCommand::PDU__BSSMAP__UplinkSeizedCommand(const OCTETSTRING& par_messageType,
    const BSSMAP__IE__Cause& par_cause,
    const OPTIONAL< BSSMAP__IE__TalkerPriority >& par_talkerPriority,
    const OPTIONAL< BSSMAP__IE__EmergencySetIndication >& par_emergencySetIndication,
    const OPTIONAL< BSSMAP__IE__TalkerIdentity >& par_talkerIdentity)
  :   field_messageType(par_messageType),
  field_cause(par_cause),
  field_talkerPriority(par_talkerPriority),
  field_emergencySetIndication(par_emergencySetIndication),
  field_talkerIdentity(par_talkerIdentity)
{
}

PDU__BSSMAP__UplinkSeizedCommand::PDU__BSSMAP__UplinkSeizedCommand(const PDU__BSSMAP__UplinkSeizedCommand& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.cause().is_bound()) field_cause = other_value.cause();
else field_cause.clean_up();
if (other_value.talkerPriority().is_bound()) field_talkerPriority = other_value.talkerPriority();
else field_talkerPriority.clean_up();
if (other_value.emergencySetIndication().is_bound()) field_emergencySetIndication = other_value.emergencySetIndication();
else field_emergencySetIndication.clean_up();
if (other_value.talkerIdentity().is_bound()) field_talkerIdentity = other_value.talkerIdentity();
else field_talkerIdentity.clean_up();
}

void PDU__BSSMAP__UplinkSeizedCommand::clean_up()
{
field_messageType.clean_up();
field_cause.clean_up();
field_talkerPriority.clean_up();
field_emergencySetIndication.clean_up();
field_talkerIdentity.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__UplinkSeizedCommand::get_descriptor() const { return &PDU__BSSMAP__UplinkSeizedCommand_descr_; }
PDU__BSSMAP__UplinkSeizedCommand& PDU__BSSMAP__UplinkSeizedCommand::operator=(const PDU__BSSMAP__UplinkSeizedCommand& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.cause().is_bound()) field_cause = other_value.cause();
  else field_cause.clean_up();
  if (other_value.talkerPriority().is_bound()) field_talkerPriority = other_value.talkerPriority();
  else field_talkerPriority.clean_up();
  if (other_value.emergencySetIndication().is_bound()) field_emergencySetIndication = other_value.emergencySetIndication();
  else field_emergencySetIndication.clean_up();
  if (other_value.talkerIdentity().is_bound()) field_talkerIdentity = other_value.talkerIdentity();
  else field_talkerIdentity.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__UplinkSeizedCommand::operator==(const PDU__BSSMAP__UplinkSeizedCommand& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_cause==other_value.field_cause
  && field_talkerPriority==other_value.field_talkerPriority
  && field_emergencySetIndication==other_value.field_emergencySetIndication
  && field_talkerIdentity==other_value.field_talkerIdentity;
}

boolean PDU__BSSMAP__UplinkSeizedCommand::is_bound() const
{
return (field_messageType.is_bound())
  || (field_cause.is_bound())
  || (OPTIONAL_OMIT == field_talkerPriority.get_selection() || field_talkerPriority.is_bound())
  || (OPTIONAL_OMIT == field_emergencySetIndication.get_selection() || field_emergencySetIndication.is_bound())
  || (OPTIONAL_OMIT == field_talkerIdentity.get_selection() || field_talkerIdentity.is_bound());
}
boolean PDU__BSSMAP__UplinkSeizedCommand::is_value() const
{
return field_messageType.is_value()
  && field_cause.is_value()
  && (OPTIONAL_OMIT == field_talkerPriority.get_selection() || field_talkerPriority.is_value())
  && (OPTIONAL_OMIT == field_emergencySetIndication.get_selection() || field_emergencySetIndication.is_value())
  && (OPTIONAL_OMIT == field_talkerIdentity.get_selection() || field_talkerIdentity.is_value());
}
int PDU__BSSMAP__UplinkSeizedCommand::size_of() const
{
  int ret_val = 2;
  if (field_talkerPriority.ispresent()) ret_val++;
  if (field_emergencySetIndication.ispresent()) ret_val++;
  if (field_talkerIdentity.ispresent()) ret_val++;
  return ret_val;
}

void PDU__BSSMAP__UplinkSeizedCommand::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", cause := ");
field_cause.log();
TTCN_Logger::log_event_str(", talkerPriority := ");
field_talkerPriority.log();
TTCN_Logger::log_event_str(", emergencySetIndication := ");
field_emergencySetIndication.log();
TTCN_Logger::log_event_str(", talkerIdentity := ");
field_talkerIdentity.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__UplinkSeizedCommand::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (cause().is_bound()) cause().set_implicit_omit();
if (!talkerPriority().is_bound()) talkerPriority() = OMIT_VALUE;
else talkerPriority().set_implicit_omit();
if (!emergencySetIndication().is_bound()) emergencySetIndication() = OMIT_VALUE;
else emergencySetIndication().set_implicit_omit();
if (!talkerIdentity().is_bound()) talkerIdentity() = OMIT_VALUE;
else talkerIdentity().set_implicit_omit();
}

void PDU__BSSMAP__UplinkSeizedCommand::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) talkerPriority().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) emergencySetIndication().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) talkerIdentity().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "talkerPriority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          talkerPriority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "emergencySetIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          emergencySetIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "talkerIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          talkerIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand");
  }
}

void PDU__BSSMAP__UplinkSeizedCommand::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_cause.encode_text(text_buf);
field_talkerPriority.encode_text(text_buf);
field_emergencySetIndication.encode_text(text_buf);
field_talkerIdentity.encode_text(text_buf);
}

void PDU__BSSMAP__UplinkSeizedCommand::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_cause.decode_text(text_buf);
field_talkerPriority.decode_text(text_buf);
field_emergencySetIndication.decode_text(text_buf);
field_talkerIdentity.decode_text(text_buf);
}

void PDU__BSSMAP__UplinkSeizedCommand::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__UplinkSeizedCommand::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__UplinkSeizedCommand::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__Cause_descr_.raw->forceomit);
  decoded_field_length = field_cause.RAW_decode(BSSMAP__IE__Cause_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_talkerPriority = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, BSSMAP__IE__TalkerPriority_descr_.raw->forceomit);
  decoded_field_length = field_talkerPriority().RAW_decode(BSSMAP__IE__TalkerPriority_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_talkerPriority = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_talkerPriority=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_emergencySetIndication = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, BSSMAP__IE__EmergencySetIndication_descr_.raw->forceomit);
  decoded_field_length = field_emergencySetIndication().RAW_decode(BSSMAP__IE__EmergencySetIndication_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_emergencySetIndication = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_emergencySetIndication=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_talkerIdentity = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, BSSMAP__IE__TalkerIdentity_descr_.raw->forceomit);
  decoded_field_length = field_talkerIdentity().RAW_decode(BSSMAP__IE__TalkerIdentity_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_talkerIdentity = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_talkerIdentity=OMIT_VALUE;
  if (field_messageType !=  os_70) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__UplinkSeizedCommand::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__Cause_descr_.raw);
  if (field_talkerPriority.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, BSSMAP__IE__TalkerPriority_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_emergencySetIndication.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, BSSMAP__IE__EmergencySetIndication_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_talkerIdentity.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, BSSMAP__IE__TalkerIdentity_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_cause.RAW_encode(BSSMAP__IE__Cause_descr_, *myleaf.body.node.nodes[1]);
  if (field_talkerPriority.ispresent()) {
  encoded_length += field_talkerPriority().RAW_encode(BSSMAP__IE__TalkerPriority_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_emergencySetIndication.ispresent()) {
  encoded_length += field_emergencySetIndication().RAW_encode(BSSMAP__IE__EmergencySetIndication_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_talkerIdentity.ispresent()) {
  encoded_length += field_talkerIdentity().RAW_encode(BSSMAP__IE__TalkerIdentity_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_messageType !=  os_70) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_70.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__UplinkSeizedCommand_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__Cause_template field_cause;
BSSMAP__IE__TalkerPriority_template field_talkerPriority;
BSSMAP__IE__EmergencySetIndication_template field_emergencySetIndication;
BSSMAP__IE__TalkerIdentity_template field_talkerIdentity;
};

void PDU__BSSMAP__UplinkSeizedCommand_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_cause = ANY_VALUE;
single_value->field_talkerPriority = ANY_OR_OMIT;
single_value->field_emergencySetIndication = ANY_OR_OMIT;
single_value->field_talkerIdentity = ANY_OR_OMIT;
}
}
}

void PDU__BSSMAP__UplinkSeizedCommand_template::copy_value(const PDU__BSSMAP__UplinkSeizedCommand& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.cause().is_bound()) {
  single_value->field_cause = other_value.cause();
} else {
  single_value->field_cause.clean_up();
}
if (other_value.talkerPriority().is_bound()) {
  if (other_value.talkerPriority().ispresent()) single_value->field_talkerPriority = other_value.talkerPriority()();
  else single_value->field_talkerPriority = OMIT_VALUE;
} else {
  single_value->field_talkerPriority.clean_up();
}
if (other_value.emergencySetIndication().is_bound()) {
  if (other_value.emergencySetIndication().ispresent()) single_value->field_emergencySetIndication = other_value.emergencySetIndication()();
  else single_value->field_emergencySetIndication = OMIT_VALUE;
} else {
  single_value->field_emergencySetIndication.clean_up();
}
if (other_value.talkerIdentity().is_bound()) {
  if (other_value.talkerIdentity().ispresent()) single_value->field_talkerIdentity = other_value.talkerIdentity()();
  else single_value->field_talkerIdentity = OMIT_VALUE;
} else {
  single_value->field_talkerIdentity.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__UplinkSeizedCommand_template::copy_template(const PDU__BSSMAP__UplinkSeizedCommand_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cause().get_selection()) {
single_value->field_cause = other_value.cause();
} else {
single_value->field_cause.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.talkerPriority().get_selection()) {
single_value->field_talkerPriority = other_value.talkerPriority();
} else {
single_value->field_talkerPriority.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.emergencySetIndication().get_selection()) {
single_value->field_emergencySetIndication = other_value.emergencySetIndication();
} else {
single_value->field_emergencySetIndication.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.talkerIdentity().get_selection()) {
single_value->field_talkerIdentity = other_value.talkerIdentity();
} else {
single_value->field_talkerIdentity.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__UplinkSeizedCommand_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__UplinkSeizedCommand_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__UplinkSeizedCommand_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__UplinkSeizedCommand_template::PDU__BSSMAP__UplinkSeizedCommand_template()
{
}

PDU__BSSMAP__UplinkSeizedCommand_template::PDU__BSSMAP__UplinkSeizedCommand_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__UplinkSeizedCommand_template::PDU__BSSMAP__UplinkSeizedCommand_template(const PDU__BSSMAP__UplinkSeizedCommand& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__UplinkSeizedCommand_template::PDU__BSSMAP__UplinkSeizedCommand_template(const OPTIONAL<PDU__BSSMAP__UplinkSeizedCommand>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__UplinkSeizedCommand&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand from an unbound optional field.");
}
}

PDU__BSSMAP__UplinkSeizedCommand_template::PDU__BSSMAP__UplinkSeizedCommand_template(PDU__BSSMAP__UplinkSeizedCommand_template* p_precondition, PDU__BSSMAP__UplinkSeizedCommand_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__UplinkSeizedCommand_template::PDU__BSSMAP__UplinkSeizedCommand_template(Dynamic_Match_Interface<PDU__BSSMAP__UplinkSeizedCommand>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__UplinkSeizedCommand>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__UplinkSeizedCommand_template::PDU__BSSMAP__UplinkSeizedCommand_template(const PDU__BSSMAP__UplinkSeizedCommand_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__UplinkSeizedCommand_template::~PDU__BSSMAP__UplinkSeizedCommand_template()
{
clean_up();
}

PDU__BSSMAP__UplinkSeizedCommand_template& PDU__BSSMAP__UplinkSeizedCommand_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__UplinkSeizedCommand_template& PDU__BSSMAP__UplinkSeizedCommand_template::operator=(const PDU__BSSMAP__UplinkSeizedCommand& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__UplinkSeizedCommand_template& PDU__BSSMAP__UplinkSeizedCommand_template::operator=(const OPTIONAL<PDU__BSSMAP__UplinkSeizedCommand>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__UplinkSeizedCommand&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand.");
}
return *this;
}

PDU__BSSMAP__UplinkSeizedCommand_template& PDU__BSSMAP__UplinkSeizedCommand_template::operator=(const PDU__BSSMAP__UplinkSeizedCommand_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__UplinkSeizedCommand_template::match(const PDU__BSSMAP__UplinkSeizedCommand& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.cause().is_bound()) return FALSE;
if(!single_value->field_cause.match(other_value.cause(), legacy))return FALSE;
if(!other_value.talkerPriority().is_bound()) return FALSE;
if((other_value.talkerPriority().ispresent() ? !single_value->field_talkerPriority.match((const BSSMAP__IE__TalkerPriority&)other_value.talkerPriority(), legacy) : !single_value->field_talkerPriority.match_omit(legacy)))return FALSE;
if(!other_value.emergencySetIndication().is_bound()) return FALSE;
if((other_value.emergencySetIndication().ispresent() ? !single_value->field_emergencySetIndication.match((const BSSMAP__IE__EmergencySetIndication&)other_value.emergencySetIndication(), legacy) : !single_value->field_emergencySetIndication.match_omit(legacy)))return FALSE;
if(!other_value.talkerIdentity().is_bound()) return FALSE;
if((other_value.talkerIdentity().ispresent() ? !single_value->field_talkerIdentity.match((const BSSMAP__IE__TalkerIdentity&)other_value.talkerIdentity(), legacy) : !single_value->field_talkerIdentity.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand.");
}
return FALSE;
}

boolean PDU__BSSMAP__UplinkSeizedCommand_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_cause.is_bound()
 || (single_value->field_talkerPriority.is_omit() || single_value->field_talkerPriority.is_bound())
 || (single_value->field_emergencySetIndication.is_omit() || single_value->field_emergencySetIndication.is_bound())
 || (single_value->field_talkerIdentity.is_omit() || single_value->field_talkerIdentity.is_bound());
}

boolean PDU__BSSMAP__UplinkSeizedCommand_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_cause.is_value()
 && (single_value->field_talkerPriority.is_omit() || single_value->field_talkerPriority.is_value())
 && (single_value->field_emergencySetIndication.is_omit() || single_value->field_emergencySetIndication.is_value())
 && (single_value->field_talkerIdentity.is_omit() || single_value->field_talkerIdentity.is_value());
}

void PDU__BSSMAP__UplinkSeizedCommand_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__UplinkSeizedCommand PDU__BSSMAP__UplinkSeizedCommand_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand.");
PDU__BSSMAP__UplinkSeizedCommand ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_cause.is_bound()) {
ret_val.cause() = single_value->field_cause.valueof();
}
if (single_value->field_talkerPriority.is_omit()) ret_val.talkerPriority() = OMIT_VALUE;
else if (single_value->field_talkerPriority.is_bound()) {
ret_val.talkerPriority() = single_value->field_talkerPriority.valueof();
}
if (single_value->field_emergencySetIndication.is_omit()) ret_val.emergencySetIndication() = OMIT_VALUE;
else if (single_value->field_emergencySetIndication.is_bound()) {
ret_val.emergencySetIndication() = single_value->field_emergencySetIndication.valueof();
}
if (single_value->field_talkerIdentity.is_omit()) ret_val.talkerIdentity() = OMIT_VALUE;
else if (single_value->field_talkerIdentity.is_bound()) {
ret_val.talkerIdentity() = single_value->field_talkerIdentity.valueof();
}
return ret_val;
}

void PDU__BSSMAP__UplinkSeizedCommand_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__UplinkSeizedCommand_template[list_length];
}

PDU__BSSMAP__UplinkSeizedCommand_template& PDU__BSSMAP__UplinkSeizedCommand_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__UplinkSeizedCommand_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__UplinkSeizedCommand_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand.");
return single_value->field_messageType;
}

BSSMAP__IE__Cause_template& PDU__BSSMAP__UplinkSeizedCommand_template::cause()
{
set_specific();
return single_value->field_cause;
}

const BSSMAP__IE__Cause_template& PDU__BSSMAP__UplinkSeizedCommand_template::cause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cause of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand.");
return single_value->field_cause;
}

BSSMAP__IE__TalkerPriority_template& PDU__BSSMAP__UplinkSeizedCommand_template::talkerPriority()
{
set_specific();
return single_value->field_talkerPriority;
}

const BSSMAP__IE__TalkerPriority_template& PDU__BSSMAP__UplinkSeizedCommand_template::talkerPriority() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field talkerPriority of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand.");
return single_value->field_talkerPriority;
}

BSSMAP__IE__EmergencySetIndication_template& PDU__BSSMAP__UplinkSeizedCommand_template::emergencySetIndication()
{
set_specific();
return single_value->field_emergencySetIndication;
}

const BSSMAP__IE__EmergencySetIndication_template& PDU__BSSMAP__UplinkSeizedCommand_template::emergencySetIndication() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field emergencySetIndication of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand.");
return single_value->field_emergencySetIndication;
}

BSSMAP__IE__TalkerIdentity_template& PDU__BSSMAP__UplinkSeizedCommand_template::talkerIdentity()
{
set_specific();
return single_value->field_talkerIdentity;
}

const BSSMAP__IE__TalkerIdentity_template& PDU__BSSMAP__UplinkSeizedCommand_template::talkerIdentity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field talkerIdentity of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand.");
return single_value->field_talkerIdentity;
}

int PDU__BSSMAP__UplinkSeizedCommand_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_talkerPriority.is_present()) ret_val++;
      if (single_value->field_emergencySetIndication.is_present()) ret_val++;
      if (single_value->field_talkerIdentity.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand.");
  }
  return 0;
}

void PDU__BSSMAP__UplinkSeizedCommand_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log();
TTCN_Logger::log_event_str(", talkerPriority := ");
single_value->field_talkerPriority.log();
TTCN_Logger::log_event_str(", emergencySetIndication := ");
single_value->field_emergencySetIndication.log();
TTCN_Logger::log_event_str(", talkerIdentity := ");
single_value->field_talkerIdentity.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__UplinkSeizedCommand_template::log_match(const PDU__BSSMAP__UplinkSeizedCommand& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cause.match(match_value.cause(), legacy)){
TTCN_Logger::log_logmatch_info(".cause");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.talkerPriority().ispresent()){
if(!single_value->field_talkerPriority.match(match_value.talkerPriority(), legacy)){
TTCN_Logger::log_logmatch_info(".talkerPriority");
single_value->field_talkerPriority.log_match(match_value.talkerPriority(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_talkerPriority.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".talkerPriority := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_talkerPriority.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.emergencySetIndication().ispresent()){
if(!single_value->field_emergencySetIndication.match(match_value.emergencySetIndication(), legacy)){
TTCN_Logger::log_logmatch_info(".emergencySetIndication");
single_value->field_emergencySetIndication.log_match(match_value.emergencySetIndication(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_emergencySetIndication.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".emergencySetIndication := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_emergencySetIndication.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.talkerIdentity().ispresent()){
if(!single_value->field_talkerIdentity.match(match_value.talkerIdentity(), legacy)){
TTCN_Logger::log_logmatch_info(".talkerIdentity");
single_value->field_talkerIdentity.log_match(match_value.talkerIdentity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_talkerIdentity.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".talkerIdentity := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_talkerIdentity.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::log_event_str(", talkerPriority := ");
if (match_value.talkerPriority().ispresent()) {
single_value->field_talkerPriority.log_match(match_value.talkerPriority(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_talkerPriority.log();
if (single_value->field_talkerPriority.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", emergencySetIndication := ");
if (match_value.emergencySetIndication().ispresent()) {
single_value->field_emergencySetIndication.log_match(match_value.emergencySetIndication(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_emergencySetIndication.log();
if (single_value->field_emergencySetIndication.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", talkerIdentity := ");
if (match_value.talkerIdentity().ispresent()) {
single_value->field_talkerIdentity.log_match(match_value.talkerIdentity(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_talkerIdentity.log();
if (single_value->field_talkerIdentity.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__UplinkSeizedCommand_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (cause().is_bound()) cause().set_implicit_omit();
if (!talkerPriority().is_bound()) talkerPriority() = OMIT_VALUE;
else talkerPriority().set_implicit_omit();
if (!emergencySetIndication().is_bound()) emergencySetIndication() = OMIT_VALUE;
else emergencySetIndication().set_implicit_omit();
if (!talkerIdentity().is_bound()) talkerIdentity() = OMIT_VALUE;
else talkerIdentity().set_implicit_omit();
}

void PDU__BSSMAP__UplinkSeizedCommand_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_cause.encode_text(text_buf);
single_value->field_talkerPriority.encode_text(text_buf);
single_value->field_emergencySetIndication.encode_text(text_buf);
single_value->field_talkerIdentity.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand.");
}
}

void PDU__BSSMAP__UplinkSeizedCommand_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_cause.decode_text(text_buf);
single_value->field_talkerPriority.decode_text(text_buf);
single_value->field_emergencySetIndication.decode_text(text_buf);
single_value->field_talkerIdentity.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__UplinkSeizedCommand_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand.");
}
}

void PDU__BSSMAP__UplinkSeizedCommand_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__UplinkSeizedCommand_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) talkerPriority().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) emergencySetIndication().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) talkerIdentity().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "talkerPriority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          talkerPriority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "emergencySetIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          emergencySetIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "talkerIdentity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          talkerIdentity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__UplinkSeizedCommand_template* precondition = new PDU__BSSMAP__UplinkSeizedCommand_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__UplinkSeizedCommand_template* implied_template = new PDU__BSSMAP__UplinkSeizedCommand_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__UplinkSeizedCommand_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__UplinkSeizedCommand_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand");
single_value->field_cause.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand");
single_value->field_talkerPriority.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand");
single_value->field_emergencySetIndication.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand");
single_value->field_talkerIdentity.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_UplinkSeizedCommand");
}

boolean PDU__BSSMAP__UplinkSeizedCommand_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__UplinkSeizedCommand_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__Suspend::PDU__BSSMAP__Suspend()
{
}

PDU__BSSMAP__Suspend::PDU__BSSMAP__Suspend(const OCTETSTRING& par_messageType,
    const BSSMAP__IE__DLCI& par_dLCI)
  :   field_messageType(par_messageType),
  field_dLCI(par_dLCI)
{
}

PDU__BSSMAP__Suspend::PDU__BSSMAP__Suspend(const PDU__BSSMAP__Suspend& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_Suspend.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.dLCI().is_bound()) field_dLCI = other_value.dLCI();
else field_dLCI.clean_up();
}

void PDU__BSSMAP__Suspend::clean_up()
{
field_messageType.clean_up();
field_dLCI.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__Suspend::get_descriptor() const { return &PDU__BSSMAP__Suspend_descr_; }
PDU__BSSMAP__Suspend& PDU__BSSMAP__Suspend::operator=(const PDU__BSSMAP__Suspend& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_Suspend.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.dLCI().is_bound()) field_dLCI = other_value.dLCI();
  else field_dLCI.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__Suspend::operator==(const PDU__BSSMAP__Suspend& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_dLCI==other_value.field_dLCI;
}

boolean PDU__BSSMAP__Suspend::is_bound() const
{
return (field_messageType.is_bound())
  || (field_dLCI.is_bound());
}
boolean PDU__BSSMAP__Suspend::is_value() const
{
return field_messageType.is_value()
  && field_dLCI.is_value();
}
void PDU__BSSMAP__Suspend::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", dLCI := ");
field_dLCI.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__Suspend::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (dLCI().is_bound()) dLCI().set_implicit_omit();
}

void PDU__BSSMAP__Suspend::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_Suspend has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) dLCI().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dLCI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dLCI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_Suspend: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_Suspend");
  }
}

void PDU__BSSMAP__Suspend::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_dLCI.encode_text(text_buf);
}

void PDU__BSSMAP__Suspend::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_dLCI.decode_text(text_buf);
}

void PDU__BSSMAP__Suspend::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__Suspend::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__Suspend::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__DLCI_descr_.raw->forceomit);
  decoded_field_length = field_dLCI.RAW_decode(BSSMAP__IE__DLCI_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_messageType !=  os_42) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__Suspend::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__DLCI_descr_.raw);
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_dLCI.RAW_encode(BSSMAP__IE__DLCI_descr_, *myleaf.body.node.nodes[1]);
  if (field_messageType !=  os_42) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_42.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__Suspend_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__DLCI_template field_dLCI;
};

void PDU__BSSMAP__Suspend_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_dLCI = ANY_VALUE;
}
}
}

void PDU__BSSMAP__Suspend_template::copy_value(const PDU__BSSMAP__Suspend& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.dLCI().is_bound()) {
  single_value->field_dLCI = other_value.dLCI();
} else {
  single_value->field_dLCI.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__Suspend_template::copy_template(const PDU__BSSMAP__Suspend_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.dLCI().get_selection()) {
single_value->field_dLCI = other_value.dLCI();
} else {
single_value->field_dLCI.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__Suspend_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__Suspend_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__Suspend_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_Suspend.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__Suspend_template::PDU__BSSMAP__Suspend_template()
{
}

PDU__BSSMAP__Suspend_template::PDU__BSSMAP__Suspend_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__Suspend_template::PDU__BSSMAP__Suspend_template(const PDU__BSSMAP__Suspend& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__Suspend_template::PDU__BSSMAP__Suspend_template(const OPTIONAL<PDU__BSSMAP__Suspend>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__Suspend&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_Suspend from an unbound optional field.");
}
}

PDU__BSSMAP__Suspend_template::PDU__BSSMAP__Suspend_template(PDU__BSSMAP__Suspend_template* p_precondition, PDU__BSSMAP__Suspend_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__Suspend_template::PDU__BSSMAP__Suspend_template(Dynamic_Match_Interface<PDU__BSSMAP__Suspend>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__Suspend>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__Suspend_template::PDU__BSSMAP__Suspend_template(const PDU__BSSMAP__Suspend_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__Suspend_template::~PDU__BSSMAP__Suspend_template()
{
clean_up();
}

PDU__BSSMAP__Suspend_template& PDU__BSSMAP__Suspend_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__Suspend_template& PDU__BSSMAP__Suspend_template::operator=(const PDU__BSSMAP__Suspend& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__Suspend_template& PDU__BSSMAP__Suspend_template::operator=(const OPTIONAL<PDU__BSSMAP__Suspend>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__Suspend&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_Suspend.");
}
return *this;
}

PDU__BSSMAP__Suspend_template& PDU__BSSMAP__Suspend_template::operator=(const PDU__BSSMAP__Suspend_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__Suspend_template::match(const PDU__BSSMAP__Suspend& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.dLCI().is_bound()) return FALSE;
if(!single_value->field_dLCI.match(other_value.dLCI(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_Suspend.");
}
return FALSE;
}

boolean PDU__BSSMAP__Suspend_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_dLCI.is_bound();
}

boolean PDU__BSSMAP__Suspend_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_dLCI.is_value();
}

void PDU__BSSMAP__Suspend_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__Suspend PDU__BSSMAP__Suspend_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_Suspend.");
PDU__BSSMAP__Suspend ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_dLCI.is_bound()) {
ret_val.dLCI() = single_value->field_dLCI.valueof();
}
return ret_val;
}

void PDU__BSSMAP__Suspend_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_Suspend.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__Suspend_template[list_length];
}

PDU__BSSMAP__Suspend_template& PDU__BSSMAP__Suspend_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_Suspend.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_Suspend.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__Suspend_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__Suspend_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_Suspend.");
return single_value->field_messageType;
}

BSSMAP__IE__DLCI_template& PDU__BSSMAP__Suspend_template::dLCI()
{
set_specific();
return single_value->field_dLCI;
}

const BSSMAP__IE__DLCI_template& PDU__BSSMAP__Suspend_template::dLCI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field dLCI of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_Suspend.");
return single_value->field_dLCI;
}

int PDU__BSSMAP__Suspend_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_Suspend which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_Suspend containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_Suspend containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_Suspend containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_Suspend containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_Suspend containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_Suspend containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_Suspend containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_Suspend containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_Suspend.");
  }
  return 0;
}

void PDU__BSSMAP__Suspend_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", dLCI := ");
single_value->field_dLCI.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__Suspend_template::log_match(const PDU__BSSMAP__Suspend& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_dLCI.match(match_value.dLCI(), legacy)){
TTCN_Logger::log_logmatch_info(".dLCI");
single_value->field_dLCI.log_match(match_value.dLCI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", dLCI := ");
single_value->field_dLCI.log_match(match_value.dLCI(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__Suspend_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (dLCI().is_bound()) dLCI().set_implicit_omit();
}

void PDU__BSSMAP__Suspend_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_dLCI.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_Suspend.");
}
}

void PDU__BSSMAP__Suspend_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_dLCI.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__Suspend_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_Suspend.");
}
}

void PDU__BSSMAP__Suspend_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__Suspend_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_Suspend has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) dLCI().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dLCI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dLCI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_Suspend: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__Suspend_template* precondition = new PDU__BSSMAP__Suspend_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__Suspend_template* implied_template = new PDU__BSSMAP__Suspend_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__Suspend_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_Suspend");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__Suspend_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_Suspend");
single_value->field_dLCI.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_Suspend");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_Suspend");
}

boolean PDU__BSSMAP__Suspend_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__Suspend_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__Resume::PDU__BSSMAP__Resume()
{
}

PDU__BSSMAP__Resume::PDU__BSSMAP__Resume(const OCTETSTRING& par_messageType,
    const BSSMAP__IE__DLCI& par_dLCI)
  :   field_messageType(par_messageType),
  field_dLCI(par_dLCI)
{
}

PDU__BSSMAP__Resume::PDU__BSSMAP__Resume(const PDU__BSSMAP__Resume& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_Resume.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.dLCI().is_bound()) field_dLCI = other_value.dLCI();
else field_dLCI.clean_up();
}

void PDU__BSSMAP__Resume::clean_up()
{
field_messageType.clean_up();
field_dLCI.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__Resume::get_descriptor() const { return &PDU__BSSMAP__Resume_descr_; }
PDU__BSSMAP__Resume& PDU__BSSMAP__Resume::operator=(const PDU__BSSMAP__Resume& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_Resume.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.dLCI().is_bound()) field_dLCI = other_value.dLCI();
  else field_dLCI.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__Resume::operator==(const PDU__BSSMAP__Resume& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_dLCI==other_value.field_dLCI;
}

boolean PDU__BSSMAP__Resume::is_bound() const
{
return (field_messageType.is_bound())
  || (field_dLCI.is_bound());
}
boolean PDU__BSSMAP__Resume::is_value() const
{
return field_messageType.is_value()
  && field_dLCI.is_value();
}
void PDU__BSSMAP__Resume::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", dLCI := ");
field_dLCI.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__Resume::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (dLCI().is_bound()) dLCI().set_implicit_omit();
}

void PDU__BSSMAP__Resume::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_Resume has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) dLCI().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dLCI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dLCI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_Resume: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_Resume");
  }
}

void PDU__BSSMAP__Resume::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_dLCI.encode_text(text_buf);
}

void PDU__BSSMAP__Resume::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_dLCI.decode_text(text_buf);
}

void PDU__BSSMAP__Resume::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__Resume::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__Resume::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__DLCI_descr_.raw->forceomit);
  decoded_field_length = field_dLCI.RAW_decode(BSSMAP__IE__DLCI_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_messageType !=  os_89) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__Resume::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__DLCI_descr_.raw);
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_dLCI.RAW_encode(BSSMAP__IE__DLCI_descr_, *myleaf.body.node.nodes[1]);
  if (field_messageType !=  os_89) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_89.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__Resume_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__DLCI_template field_dLCI;
};

void PDU__BSSMAP__Resume_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_dLCI = ANY_VALUE;
}
}
}

void PDU__BSSMAP__Resume_template::copy_value(const PDU__BSSMAP__Resume& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.dLCI().is_bound()) {
  single_value->field_dLCI = other_value.dLCI();
} else {
  single_value->field_dLCI.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__Resume_template::copy_template(const PDU__BSSMAP__Resume_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.dLCI().get_selection()) {
single_value->field_dLCI = other_value.dLCI();
} else {
single_value->field_dLCI.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__Resume_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__Resume_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__Resume_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_Resume.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__Resume_template::PDU__BSSMAP__Resume_template()
{
}

PDU__BSSMAP__Resume_template::PDU__BSSMAP__Resume_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__Resume_template::PDU__BSSMAP__Resume_template(const PDU__BSSMAP__Resume& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__Resume_template::PDU__BSSMAP__Resume_template(const OPTIONAL<PDU__BSSMAP__Resume>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__Resume&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_Resume from an unbound optional field.");
}
}

PDU__BSSMAP__Resume_template::PDU__BSSMAP__Resume_template(PDU__BSSMAP__Resume_template* p_precondition, PDU__BSSMAP__Resume_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__Resume_template::PDU__BSSMAP__Resume_template(Dynamic_Match_Interface<PDU__BSSMAP__Resume>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__Resume>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__Resume_template::PDU__BSSMAP__Resume_template(const PDU__BSSMAP__Resume_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__Resume_template::~PDU__BSSMAP__Resume_template()
{
clean_up();
}

PDU__BSSMAP__Resume_template& PDU__BSSMAP__Resume_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__Resume_template& PDU__BSSMAP__Resume_template::operator=(const PDU__BSSMAP__Resume& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__Resume_template& PDU__BSSMAP__Resume_template::operator=(const OPTIONAL<PDU__BSSMAP__Resume>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__Resume&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_Resume.");
}
return *this;
}

PDU__BSSMAP__Resume_template& PDU__BSSMAP__Resume_template::operator=(const PDU__BSSMAP__Resume_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__Resume_template::match(const PDU__BSSMAP__Resume& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.dLCI().is_bound()) return FALSE;
if(!single_value->field_dLCI.match(other_value.dLCI(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_Resume.");
}
return FALSE;
}

boolean PDU__BSSMAP__Resume_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_dLCI.is_bound();
}

boolean PDU__BSSMAP__Resume_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_dLCI.is_value();
}

void PDU__BSSMAP__Resume_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__Resume PDU__BSSMAP__Resume_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_Resume.");
PDU__BSSMAP__Resume ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_dLCI.is_bound()) {
ret_val.dLCI() = single_value->field_dLCI.valueof();
}
return ret_val;
}

void PDU__BSSMAP__Resume_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_Resume.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__Resume_template[list_length];
}

PDU__BSSMAP__Resume_template& PDU__BSSMAP__Resume_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_Resume.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_Resume.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__Resume_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__Resume_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_Resume.");
return single_value->field_messageType;
}

BSSMAP__IE__DLCI_template& PDU__BSSMAP__Resume_template::dLCI()
{
set_specific();
return single_value->field_dLCI;
}

const BSSMAP__IE__DLCI_template& PDU__BSSMAP__Resume_template::dLCI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field dLCI of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_Resume.");
return single_value->field_dLCI;
}

int PDU__BSSMAP__Resume_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_Resume which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_Resume containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_Resume containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_Resume containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_Resume containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_Resume containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_Resume containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_Resume containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_Resume containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_Resume.");
  }
  return 0;
}

void PDU__BSSMAP__Resume_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", dLCI := ");
single_value->field_dLCI.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__Resume_template::log_match(const PDU__BSSMAP__Resume& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_dLCI.match(match_value.dLCI(), legacy)){
TTCN_Logger::log_logmatch_info(".dLCI");
single_value->field_dLCI.log_match(match_value.dLCI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", dLCI := ");
single_value->field_dLCI.log_match(match_value.dLCI(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__Resume_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (dLCI().is_bound()) dLCI().set_implicit_omit();
}

void PDU__BSSMAP__Resume_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_dLCI.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_Resume.");
}
}

void PDU__BSSMAP__Resume_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_dLCI.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__Resume_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_Resume.");
}
}

void PDU__BSSMAP__Resume_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__Resume_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_Resume has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) dLCI().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dLCI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dLCI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_Resume: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__Resume_template* precondition = new PDU__BSSMAP__Resume_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__Resume_template* implied_template = new PDU__BSSMAP__Resume_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__Resume_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_Resume");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__Resume_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_Resume");
single_value->field_dLCI.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_Resume");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_Resume");
}

boolean PDU__BSSMAP__Resume_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__Resume_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__ChangeCircuit::PDU__BSSMAP__ChangeCircuit()
{
}

PDU__BSSMAP__ChangeCircuit::PDU__BSSMAP__ChangeCircuit(const OCTETSTRING& par_messageType,
    const BSSMAP__IE__Cause& par_cause)
  :   field_messageType(par_messageType),
  field_cause(par_cause)
{
}

PDU__BSSMAP__ChangeCircuit::PDU__BSSMAP__ChangeCircuit(const PDU__BSSMAP__ChangeCircuit& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_ChangeCircuit.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.cause().is_bound()) field_cause = other_value.cause();
else field_cause.clean_up();
}

void PDU__BSSMAP__ChangeCircuit::clean_up()
{
field_messageType.clean_up();
field_cause.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__ChangeCircuit::get_descriptor() const { return &PDU__BSSMAP__ChangeCircuit_descr_; }
PDU__BSSMAP__ChangeCircuit& PDU__BSSMAP__ChangeCircuit::operator=(const PDU__BSSMAP__ChangeCircuit& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_ChangeCircuit.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.cause().is_bound()) field_cause = other_value.cause();
  else field_cause.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__ChangeCircuit::operator==(const PDU__BSSMAP__ChangeCircuit& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_cause==other_value.field_cause;
}

boolean PDU__BSSMAP__ChangeCircuit::is_bound() const
{
return (field_messageType.is_bound())
  || (field_cause.is_bound());
}
boolean PDU__BSSMAP__ChangeCircuit::is_value() const
{
return field_messageType.is_value()
  && field_cause.is_value();
}
void PDU__BSSMAP__ChangeCircuit::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", cause := ");
field_cause.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__ChangeCircuit::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (cause().is_bound()) cause().set_implicit_omit();
}

void PDU__BSSMAP__ChangeCircuit::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_ChangeCircuit has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_ChangeCircuit: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_ChangeCircuit");
  }
}

void PDU__BSSMAP__ChangeCircuit::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_cause.encode_text(text_buf);
}

void PDU__BSSMAP__ChangeCircuit::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_cause.decode_text(text_buf);
}

void PDU__BSSMAP__ChangeCircuit::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__ChangeCircuit::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__ChangeCircuit::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
 