// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "BSSAP_Types.hh"

namespace BSSAP__Types {

/* Member functions of C++ classes */

PDU__BSSMAP__InternalHandoverEnquiry::PDU__BSSMAP__InternalHandoverEnquiry()
{
}

PDU__BSSMAP__InternalHandoverEnquiry::PDU__BSSMAP__InternalHandoverEnquiry(const OCTETSTRING& par_messageType,
    const BSSMAP__IE__SpeechCodec& par_speechCodec)
  :   field_messageType(par_messageType),
  field_speechCodec(par_speechCodec)
{
}

PDU__BSSMAP__InternalHandoverEnquiry::PDU__BSSMAP__InternalHandoverEnquiry(const PDU__BSSMAP__InternalHandoverEnquiry& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.speechCodec().is_bound()) field_speechCodec = other_value.speechCodec();
else field_speechCodec.clean_up();
}

void PDU__BSSMAP__InternalHandoverEnquiry::clean_up()
{
field_messageType.clean_up();
field_speechCodec.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__InternalHandoverEnquiry::get_descriptor() const { return &PDU__BSSMAP__InternalHandoverEnquiry_descr_; }
PDU__BSSMAP__InternalHandoverEnquiry& PDU__BSSMAP__InternalHandoverEnquiry::operator=(const PDU__BSSMAP__InternalHandoverEnquiry& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.speechCodec().is_bound()) field_speechCodec = other_value.speechCodec();
  else field_speechCodec.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__InternalHandoverEnquiry::operator==(const PDU__BSSMAP__InternalHandoverEnquiry& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_speechCodec==other_value.field_speechCodec;
}

boolean PDU__BSSMAP__InternalHandoverEnquiry::is_bound() const
{
return (field_messageType.is_bound())
  || (field_speechCodec.is_bound());
}
boolean PDU__BSSMAP__InternalHandoverEnquiry::is_value() const
{
return field_messageType.is_value()
  && field_speechCodec.is_value();
}
void PDU__BSSMAP__InternalHandoverEnquiry::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", speechCodec := ");
field_speechCodec.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__InternalHandoverEnquiry::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (speechCodec().is_bound()) speechCodec().set_implicit_omit();
}

void PDU__BSSMAP__InternalHandoverEnquiry::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) speechCodec().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "speechCodec")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          speechCodec().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry");
  }
}

void PDU__BSSMAP__InternalHandoverEnquiry::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_speechCodec.encode_text(text_buf);
}

void PDU__BSSMAP__InternalHandoverEnquiry::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_speechCodec.decode_text(text_buf);
}

void PDU__BSSMAP__InternalHandoverEnquiry::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__InternalHandoverEnquiry::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__InternalHandoverEnquiry::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__SpeechCodec_descr_.raw->forceomit);
  decoded_field_length = field_speechCodec.RAW_decode(BSSMAP__IE__SpeechCodec_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_messageType !=  os_125) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__InternalHandoverEnquiry::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__SpeechCodec_descr_.raw);
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_speechCodec.RAW_encode(BSSMAP__IE__SpeechCodec_descr_, *myleaf.body.node.nodes[1]);
  if (field_messageType !=  os_125) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_125.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__InternalHandoverEnquiry_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__SpeechCodec_template field_speechCodec;
};

void PDU__BSSMAP__InternalHandoverEnquiry_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_speechCodec = ANY_VALUE;
}
}
}

void PDU__BSSMAP__InternalHandoverEnquiry_template::copy_value(const PDU__BSSMAP__InternalHandoverEnquiry& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.speechCodec().is_bound()) {
  single_value->field_speechCodec = other_value.speechCodec();
} else {
  single_value->field_speechCodec.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__InternalHandoverEnquiry_template::copy_template(const PDU__BSSMAP__InternalHandoverEnquiry_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.speechCodec().get_selection()) {
single_value->field_speechCodec = other_value.speechCodec();
} else {
single_value->field_speechCodec.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__InternalHandoverEnquiry_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__InternalHandoverEnquiry_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__InternalHandoverEnquiry_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__InternalHandoverEnquiry_template::PDU__BSSMAP__InternalHandoverEnquiry_template()
{
}

PDU__BSSMAP__InternalHandoverEnquiry_template::PDU__BSSMAP__InternalHandoverEnquiry_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__InternalHandoverEnquiry_template::PDU__BSSMAP__InternalHandoverEnquiry_template(const PDU__BSSMAP__InternalHandoverEnquiry& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__InternalHandoverEnquiry_template::PDU__BSSMAP__InternalHandoverEnquiry_template(const OPTIONAL<PDU__BSSMAP__InternalHandoverEnquiry>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__InternalHandoverEnquiry&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry from an unbound optional field.");
}
}

PDU__BSSMAP__InternalHandoverEnquiry_template::PDU__BSSMAP__InternalHandoverEnquiry_template(PDU__BSSMAP__InternalHandoverEnquiry_template* p_precondition, PDU__BSSMAP__InternalHandoverEnquiry_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__InternalHandoverEnquiry_template::PDU__BSSMAP__InternalHandoverEnquiry_template(Dynamic_Match_Interface<PDU__BSSMAP__InternalHandoverEnquiry>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__InternalHandoverEnquiry>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__InternalHandoverEnquiry_template::PDU__BSSMAP__InternalHandoverEnquiry_template(const PDU__BSSMAP__InternalHandoverEnquiry_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__InternalHandoverEnquiry_template::~PDU__BSSMAP__InternalHandoverEnquiry_template()
{
clean_up();
}

PDU__BSSMAP__InternalHandoverEnquiry_template& PDU__BSSMAP__InternalHandoverEnquiry_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__InternalHandoverEnquiry_template& PDU__BSSMAP__InternalHandoverEnquiry_template::operator=(const PDU__BSSMAP__InternalHandoverEnquiry& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__InternalHandoverEnquiry_template& PDU__BSSMAP__InternalHandoverEnquiry_template::operator=(const OPTIONAL<PDU__BSSMAP__InternalHandoverEnquiry>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__InternalHandoverEnquiry&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry.");
}
return *this;
}

PDU__BSSMAP__InternalHandoverEnquiry_template& PDU__BSSMAP__InternalHandoverEnquiry_template::operator=(const PDU__BSSMAP__InternalHandoverEnquiry_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__InternalHandoverEnquiry_template::match(const PDU__BSSMAP__InternalHandoverEnquiry& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.speechCodec().is_bound()) return FALSE;
if(!single_value->field_speechCodec.match(other_value.speechCodec(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry.");
}
return FALSE;
}

boolean PDU__BSSMAP__InternalHandoverEnquiry_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_speechCodec.is_bound();
}

boolean PDU__BSSMAP__InternalHandoverEnquiry_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_speechCodec.is_value();
}

void PDU__BSSMAP__InternalHandoverEnquiry_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__InternalHandoverEnquiry PDU__BSSMAP__InternalHandoverEnquiry_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry.");
PDU__BSSMAP__InternalHandoverEnquiry ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_speechCodec.is_bound()) {
ret_val.speechCodec() = single_value->field_speechCodec.valueof();
}
return ret_val;
}

void PDU__BSSMAP__InternalHandoverEnquiry_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__InternalHandoverEnquiry_template[list_length];
}

PDU__BSSMAP__InternalHandoverEnquiry_template& PDU__BSSMAP__InternalHandoverEnquiry_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__InternalHandoverEnquiry_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__InternalHandoverEnquiry_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry.");
return single_value->field_messageType;
}

BSSMAP__IE__SpeechCodec_template& PDU__BSSMAP__InternalHandoverEnquiry_template::speechCodec()
{
set_specific();
return single_value->field_speechCodec;
}

const BSSMAP__IE__SpeechCodec_template& PDU__BSSMAP__InternalHandoverEnquiry_template::speechCodec() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field speechCodec of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry.");
return single_value->field_speechCodec;
}

int PDU__BSSMAP__InternalHandoverEnquiry_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry.");
  }
  return 0;
}

void PDU__BSSMAP__InternalHandoverEnquiry_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", speechCodec := ");
single_value->field_speechCodec.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__InternalHandoverEnquiry_template::log_match(const PDU__BSSMAP__InternalHandoverEnquiry& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_speechCodec.match(match_value.speechCodec(), legacy)){
TTCN_Logger::log_logmatch_info(".speechCodec");
single_value->field_speechCodec.log_match(match_value.speechCodec(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", speechCodec := ");
single_value->field_speechCodec.log_match(match_value.speechCodec(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__InternalHandoverEnquiry_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (speechCodec().is_bound()) speechCodec().set_implicit_omit();
}

void PDU__BSSMAP__InternalHandoverEnquiry_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_speechCodec.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry.");
}
}

void PDU__BSSMAP__InternalHandoverEnquiry_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_speechCodec.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__InternalHandoverEnquiry_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry.");
}
}

void PDU__BSSMAP__InternalHandoverEnquiry_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__InternalHandoverEnquiry_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) speechCodec().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "speechCodec")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          speechCodec().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__InternalHandoverEnquiry_template* precondition = new PDU__BSSMAP__InternalHandoverEnquiry_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__InternalHandoverEnquiry_template* implied_template = new PDU__BSSMAP__InternalHandoverEnquiry_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__InternalHandoverEnquiry_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__InternalHandoverEnquiry_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry");
single_value->field_speechCodec.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_InternalHandoverEnquiry");
}

boolean PDU__BSSMAP__InternalHandoverEnquiry_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__InternalHandoverEnquiry_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__ResetIPResource::PDU__BSSMAP__ResetIPResource()
{
}

PDU__BSSMAP__ResetIPResource::PDU__BSSMAP__ResetIPResource(const OCTETSTRING& par_messageType,
    const BSSMAP__IE__Cause& par_cause,
    const BSSMAP__IE__CallIdentifierList& par_callIdentifierList)
  :   field_messageType(par_messageType),
  field_cause(par_cause),
  field_callIdentifierList(par_callIdentifierList)
{
}

PDU__BSSMAP__ResetIPResource::PDU__BSSMAP__ResetIPResource(const PDU__BSSMAP__ResetIPResource& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.cause().is_bound()) field_cause = other_value.cause();
else field_cause.clean_up();
if (other_value.callIdentifierList().is_bound()) field_callIdentifierList = other_value.callIdentifierList();
else field_callIdentifierList.clean_up();
}

void PDU__BSSMAP__ResetIPResource::clean_up()
{
field_messageType.clean_up();
field_cause.clean_up();
field_callIdentifierList.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__ResetIPResource::get_descriptor() const { return &PDU__BSSMAP__ResetIPResource_descr_; }
PDU__BSSMAP__ResetIPResource& PDU__BSSMAP__ResetIPResource::operator=(const PDU__BSSMAP__ResetIPResource& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.cause().is_bound()) field_cause = other_value.cause();
  else field_cause.clean_up();
  if (other_value.callIdentifierList().is_bound()) field_callIdentifierList = other_value.callIdentifierList();
  else field_callIdentifierList.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__ResetIPResource::operator==(const PDU__BSSMAP__ResetIPResource& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_cause==other_value.field_cause
  && field_callIdentifierList==other_value.field_callIdentifierList;
}

boolean PDU__BSSMAP__ResetIPResource::is_bound() const
{
return (field_messageType.is_bound())
  || (field_cause.is_bound())
  || (field_callIdentifierList.is_bound());
}
boolean PDU__BSSMAP__ResetIPResource::is_value() const
{
return field_messageType.is_value()
  && field_cause.is_value()
  && field_callIdentifierList.is_value();
}
void PDU__BSSMAP__ResetIPResource::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", cause := ");
field_cause.log();
TTCN_Logger::log_event_str(", callIdentifierList := ");
field_callIdentifierList.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__ResetIPResource::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (cause().is_bound()) cause().set_implicit_omit();
if (callIdentifierList().is_bound()) callIdentifierList().set_implicit_omit();
}

void PDU__BSSMAP__ResetIPResource::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) callIdentifierList().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "callIdentifierList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          callIdentifierList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_ResetIPResource: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_ResetIPResource");
  }
}

void PDU__BSSMAP__ResetIPResource::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_cause.encode_text(text_buf);
field_callIdentifierList.encode_text(text_buf);
}

void PDU__BSSMAP__ResetIPResource::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_cause.decode_text(text_buf);
field_callIdentifierList.decode_text(text_buf);
}

void PDU__BSSMAP__ResetIPResource::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__ResetIPResource::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__ResetIPResource::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__Cause_descr_.raw->forceomit);
  decoded_field_length = field_cause.RAW_decode(BSSMAP__IE__Cause_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, BSSMAP__IE__CallIdentifierList_descr_.raw->forceomit);
  decoded_field_length = field_callIdentifierList.RAW_decode(BSSMAP__IE__CallIdentifierList_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_messageType !=  os_80) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__ResetIPResource::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__Cause_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, BSSMAP__IE__CallIdentifierList_descr_.raw);
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_cause.RAW_encode(BSSMAP__IE__Cause_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_callIdentifierList.RAW_encode(BSSMAP__IE__CallIdentifierList_descr_, *myleaf.body.node.nodes[2]);
  if (field_messageType !=  os_80) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_80.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__ResetIPResource_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__Cause_template field_cause;
BSSMAP__IE__CallIdentifierList_template field_callIdentifierList;
};

void PDU__BSSMAP__ResetIPResource_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_cause = ANY_VALUE;
single_value->field_callIdentifierList = ANY_VALUE;
}
}
}

void PDU__BSSMAP__ResetIPResource_template::copy_value(const PDU__BSSMAP__ResetIPResource& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.cause().is_bound()) {
  single_value->field_cause = other_value.cause();
} else {
  single_value->field_cause.clean_up();
}
if (other_value.callIdentifierList().is_bound()) {
  single_value->field_callIdentifierList = other_value.callIdentifierList();
} else {
  single_value->field_callIdentifierList.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__ResetIPResource_template::copy_template(const PDU__BSSMAP__ResetIPResource_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cause().get_selection()) {
single_value->field_cause = other_value.cause();
} else {
single_value->field_cause.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.callIdentifierList().get_selection()) {
single_value->field_callIdentifierList = other_value.callIdentifierList();
} else {
single_value->field_callIdentifierList.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__ResetIPResource_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__ResetIPResource_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__ResetIPResource_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__ResetIPResource_template::PDU__BSSMAP__ResetIPResource_template()
{
}

PDU__BSSMAP__ResetIPResource_template::PDU__BSSMAP__ResetIPResource_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__ResetIPResource_template::PDU__BSSMAP__ResetIPResource_template(const PDU__BSSMAP__ResetIPResource& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__ResetIPResource_template::PDU__BSSMAP__ResetIPResource_template(const OPTIONAL<PDU__BSSMAP__ResetIPResource>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__ResetIPResource&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource from an unbound optional field.");
}
}

PDU__BSSMAP__ResetIPResource_template::PDU__BSSMAP__ResetIPResource_template(PDU__BSSMAP__ResetIPResource_template* p_precondition, PDU__BSSMAP__ResetIPResource_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__ResetIPResource_template::PDU__BSSMAP__ResetIPResource_template(Dynamic_Match_Interface<PDU__BSSMAP__ResetIPResource>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__ResetIPResource>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__ResetIPResource_template::PDU__BSSMAP__ResetIPResource_template(const PDU__BSSMAP__ResetIPResource_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__ResetIPResource_template::~PDU__BSSMAP__ResetIPResource_template()
{
clean_up();
}

PDU__BSSMAP__ResetIPResource_template& PDU__BSSMAP__ResetIPResource_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__ResetIPResource_template& PDU__BSSMAP__ResetIPResource_template::operator=(const PDU__BSSMAP__ResetIPResource& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__ResetIPResource_template& PDU__BSSMAP__ResetIPResource_template::operator=(const OPTIONAL<PDU__BSSMAP__ResetIPResource>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__ResetIPResource&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource.");
}
return *this;
}

PDU__BSSMAP__ResetIPResource_template& PDU__BSSMAP__ResetIPResource_template::operator=(const PDU__BSSMAP__ResetIPResource_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__ResetIPResource_template::match(const PDU__BSSMAP__ResetIPResource& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.cause().is_bound()) return FALSE;
if(!single_value->field_cause.match(other_value.cause(), legacy))return FALSE;
if(!other_value.callIdentifierList().is_bound()) return FALSE;
if(!single_value->field_callIdentifierList.match(other_value.callIdentifierList(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource.");
}
return FALSE;
}

boolean PDU__BSSMAP__ResetIPResource_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_cause.is_bound()
 || single_value->field_callIdentifierList.is_bound();
}

boolean PDU__BSSMAP__ResetIPResource_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_cause.is_value()
 && single_value->field_callIdentifierList.is_value();
}

void PDU__BSSMAP__ResetIPResource_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__ResetIPResource PDU__BSSMAP__ResetIPResource_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource.");
PDU__BSSMAP__ResetIPResource ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_cause.is_bound()) {
ret_val.cause() = single_value->field_cause.valueof();
}
if (single_value->field_callIdentifierList.is_bound()) {
ret_val.callIdentifierList() = single_value->field_callIdentifierList.valueof();
}
return ret_val;
}

void PDU__BSSMAP__ResetIPResource_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__ResetIPResource_template[list_length];
}

PDU__BSSMAP__ResetIPResource_template& PDU__BSSMAP__ResetIPResource_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__ResetIPResource_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__ResetIPResource_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource.");
return single_value->field_messageType;
}

BSSMAP__IE__Cause_template& PDU__BSSMAP__ResetIPResource_template::cause()
{
set_specific();
return single_value->field_cause;
}

const BSSMAP__IE__Cause_template& PDU__BSSMAP__ResetIPResource_template::cause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cause of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource.");
return single_value->field_cause;
}

BSSMAP__IE__CallIdentifierList_template& PDU__BSSMAP__ResetIPResource_template::callIdentifierList()
{
set_specific();
return single_value->field_callIdentifierList;
}

const BSSMAP__IE__CallIdentifierList_template& PDU__BSSMAP__ResetIPResource_template::callIdentifierList() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field callIdentifierList of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource.");
return single_value->field_callIdentifierList;
}

int PDU__BSSMAP__ResetIPResource_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource.");
  }
  return 0;
}

void PDU__BSSMAP__ResetIPResource_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log();
TTCN_Logger::log_event_str(", callIdentifierList := ");
single_value->field_callIdentifierList.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__ResetIPResource_template::log_match(const PDU__BSSMAP__ResetIPResource& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cause.match(match_value.cause(), legacy)){
TTCN_Logger::log_logmatch_info(".cause");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_callIdentifierList.match(match_value.callIdentifierList(), legacy)){
TTCN_Logger::log_logmatch_info(".callIdentifierList");
single_value->field_callIdentifierList.log_match(match_value.callIdentifierList(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", cause := ");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::log_event_str(", callIdentifierList := ");
single_value->field_callIdentifierList.log_match(match_value.callIdentifierList(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__ResetIPResource_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (cause().is_bound()) cause().set_implicit_omit();
if (callIdentifierList().is_bound()) callIdentifierList().set_implicit_omit();
}

void PDU__BSSMAP__ResetIPResource_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_cause.encode_text(text_buf);
single_value->field_callIdentifierList.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource.");
}
}

void PDU__BSSMAP__ResetIPResource_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_cause.decode_text(text_buf);
single_value->field_callIdentifierList.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__ResetIPResource_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource.");
}
}

void PDU__BSSMAP__ResetIPResource_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__ResetIPResource_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResource has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) callIdentifierList().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "callIdentifierList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          callIdentifierList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_ResetIPResource: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__ResetIPResource_template* precondition = new PDU__BSSMAP__ResetIPResource_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__ResetIPResource_template* implied_template = new PDU__BSSMAP__ResetIPResource_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__ResetIPResource_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_ResetIPResource");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__ResetIPResource_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_ResetIPResource");
single_value->field_cause.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_ResetIPResource");
single_value->field_callIdentifierList.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_ResetIPResource");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_ResetIPResource");
}

boolean PDU__BSSMAP__ResetIPResource_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__ResetIPResource_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__ResetIPResourceAck::PDU__BSSMAP__ResetIPResourceAck()
{
}

PDU__BSSMAP__ResetIPResourceAck::PDU__BSSMAP__ResetIPResourceAck(const OCTETSTRING& par_messageType,
    const BSSMAP__IE__CallIdentifierList& par_callIdentifierList)
  :   field_messageType(par_messageType),
  field_callIdentifierList(par_callIdentifierList)
{
}

PDU__BSSMAP__ResetIPResourceAck::PDU__BSSMAP__ResetIPResourceAck(const PDU__BSSMAP__ResetIPResourceAck& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.callIdentifierList().is_bound()) field_callIdentifierList = other_value.callIdentifierList();
else field_callIdentifierList.clean_up();
}

void PDU__BSSMAP__ResetIPResourceAck::clean_up()
{
field_messageType.clean_up();
field_callIdentifierList.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__ResetIPResourceAck::get_descriptor() const { return &PDU__BSSMAP__ResetIPResourceAck_descr_; }
PDU__BSSMAP__ResetIPResourceAck& PDU__BSSMAP__ResetIPResourceAck::operator=(const PDU__BSSMAP__ResetIPResourceAck& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.callIdentifierList().is_bound()) field_callIdentifierList = other_value.callIdentifierList();
  else field_callIdentifierList.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__ResetIPResourceAck::operator==(const PDU__BSSMAP__ResetIPResourceAck& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_callIdentifierList==other_value.field_callIdentifierList;
}

boolean PDU__BSSMAP__ResetIPResourceAck::is_bound() const
{
return (field_messageType.is_bound())
  || (field_callIdentifierList.is_bound());
}
boolean PDU__BSSMAP__ResetIPResourceAck::is_value() const
{
return field_messageType.is_value()
  && field_callIdentifierList.is_value();
}
void PDU__BSSMAP__ResetIPResourceAck::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", callIdentifierList := ");
field_callIdentifierList.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__ResetIPResourceAck::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (callIdentifierList().is_bound()) callIdentifierList().set_implicit_omit();
}

void PDU__BSSMAP__ResetIPResourceAck::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) callIdentifierList().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "callIdentifierList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          callIdentifierList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck");
  }
}

void PDU__BSSMAP__ResetIPResourceAck::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_callIdentifierList.encode_text(text_buf);
}

void PDU__BSSMAP__ResetIPResourceAck::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_callIdentifierList.decode_text(text_buf);
}

void PDU__BSSMAP__ResetIPResourceAck::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__ResetIPResourceAck::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__ResetIPResourceAck::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__CallIdentifierList_descr_.raw->forceomit);
  decoded_field_length = field_callIdentifierList.RAW_decode(BSSMAP__IE__CallIdentifierList_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_messageType !=  os_96) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__ResetIPResourceAck::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__CallIdentifierList_descr_.raw);
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_callIdentifierList.RAW_encode(BSSMAP__IE__CallIdentifierList_descr_, *myleaf.body.node.nodes[1]);
  if (field_messageType !=  os_96) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_96.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__ResetIPResourceAck_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__CallIdentifierList_template field_callIdentifierList;
};

void PDU__BSSMAP__ResetIPResourceAck_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_callIdentifierList = ANY_VALUE;
}
}
}

void PDU__BSSMAP__ResetIPResourceAck_template::copy_value(const PDU__BSSMAP__ResetIPResourceAck& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.callIdentifierList().is_bound()) {
  single_value->field_callIdentifierList = other_value.callIdentifierList();
} else {
  single_value->field_callIdentifierList.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__ResetIPResourceAck_template::copy_template(const PDU__BSSMAP__ResetIPResourceAck_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.callIdentifierList().get_selection()) {
single_value->field_callIdentifierList = other_value.callIdentifierList();
} else {
single_value->field_callIdentifierList.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__ResetIPResourceAck_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__ResetIPResourceAck_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__ResetIPResourceAck_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__ResetIPResourceAck_template::PDU__BSSMAP__ResetIPResourceAck_template()
{
}

PDU__BSSMAP__ResetIPResourceAck_template::PDU__BSSMAP__ResetIPResourceAck_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__ResetIPResourceAck_template::PDU__BSSMAP__ResetIPResourceAck_template(const PDU__BSSMAP__ResetIPResourceAck& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__ResetIPResourceAck_template::PDU__BSSMAP__ResetIPResourceAck_template(const OPTIONAL<PDU__BSSMAP__ResetIPResourceAck>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__ResetIPResourceAck&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck from an unbound optional field.");
}
}

PDU__BSSMAP__ResetIPResourceAck_template::PDU__BSSMAP__ResetIPResourceAck_template(PDU__BSSMAP__ResetIPResourceAck_template* p_precondition, PDU__BSSMAP__ResetIPResourceAck_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__ResetIPResourceAck_template::PDU__BSSMAP__ResetIPResourceAck_template(Dynamic_Match_Interface<PDU__BSSMAP__ResetIPResourceAck>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__ResetIPResourceAck>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__ResetIPResourceAck_template::PDU__BSSMAP__ResetIPResourceAck_template(const PDU__BSSMAP__ResetIPResourceAck_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__ResetIPResourceAck_template::~PDU__BSSMAP__ResetIPResourceAck_template()
{
clean_up();
}

PDU__BSSMAP__ResetIPResourceAck_template& PDU__BSSMAP__ResetIPResourceAck_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__ResetIPResourceAck_template& PDU__BSSMAP__ResetIPResourceAck_template::operator=(const PDU__BSSMAP__ResetIPResourceAck& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__ResetIPResourceAck_template& PDU__BSSMAP__ResetIPResourceAck_template::operator=(const OPTIONAL<PDU__BSSMAP__ResetIPResourceAck>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__ResetIPResourceAck&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck.");
}
return *this;
}

PDU__BSSMAP__ResetIPResourceAck_template& PDU__BSSMAP__ResetIPResourceAck_template::operator=(const PDU__BSSMAP__ResetIPResourceAck_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__ResetIPResourceAck_template::match(const PDU__BSSMAP__ResetIPResourceAck& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.callIdentifierList().is_bound()) return FALSE;
if(!single_value->field_callIdentifierList.match(other_value.callIdentifierList(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck.");
}
return FALSE;
}

boolean PDU__BSSMAP__ResetIPResourceAck_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_callIdentifierList.is_bound();
}

boolean PDU__BSSMAP__ResetIPResourceAck_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_callIdentifierList.is_value();
}

void PDU__BSSMAP__ResetIPResourceAck_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__ResetIPResourceAck PDU__BSSMAP__ResetIPResourceAck_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck.");
PDU__BSSMAP__ResetIPResourceAck ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_callIdentifierList.is_bound()) {
ret_val.callIdentifierList() = single_value->field_callIdentifierList.valueof();
}
return ret_val;
}

void PDU__BSSMAP__ResetIPResourceAck_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__ResetIPResourceAck_template[list_length];
}

PDU__BSSMAP__ResetIPResourceAck_template& PDU__BSSMAP__ResetIPResourceAck_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__ResetIPResourceAck_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__ResetIPResourceAck_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck.");
return single_value->field_messageType;
}

BSSMAP__IE__CallIdentifierList_template& PDU__BSSMAP__ResetIPResourceAck_template::callIdentifierList()
{
set_specific();
return single_value->field_callIdentifierList;
}

const BSSMAP__IE__CallIdentifierList_template& PDU__BSSMAP__ResetIPResourceAck_template::callIdentifierList() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field callIdentifierList of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck.");
return single_value->field_callIdentifierList;
}

int PDU__BSSMAP__ResetIPResourceAck_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck.");
  }
  return 0;
}

void PDU__BSSMAP__ResetIPResourceAck_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", callIdentifierList := ");
single_value->field_callIdentifierList.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__ResetIPResourceAck_template::log_match(const PDU__BSSMAP__ResetIPResourceAck& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_callIdentifierList.match(match_value.callIdentifierList(), legacy)){
TTCN_Logger::log_logmatch_info(".callIdentifierList");
single_value->field_callIdentifierList.log_match(match_value.callIdentifierList(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", callIdentifierList := ");
single_value->field_callIdentifierList.log_match(match_value.callIdentifierList(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__ResetIPResourceAck_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (callIdentifierList().is_bound()) callIdentifierList().set_implicit_omit();
}

void PDU__BSSMAP__ResetIPResourceAck_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_callIdentifierList.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck.");
}
}

void PDU__BSSMAP__ResetIPResourceAck_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_callIdentifierList.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__ResetIPResourceAck_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck.");
}
}

void PDU__BSSMAP__ResetIPResourceAck_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__ResetIPResourceAck_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) callIdentifierList().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "callIdentifierList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          callIdentifierList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__ResetIPResourceAck_template* precondition = new PDU__BSSMAP__ResetIPResourceAck_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__ResetIPResourceAck_template* implied_template = new PDU__BSSMAP__ResetIPResourceAck_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__ResetIPResourceAck_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__ResetIPResourceAck_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck");
single_value->field_callIdentifierList.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_ResetIPResourceAck");
}

boolean PDU__BSSMAP__ResetIPResourceAck_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__ResetIPResourceAck_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__RerouteCommand::PDU__BSSMAP__RerouteCommand()
{
}

PDU__BSSMAP__RerouteCommand::PDU__BSSMAP__RerouteCommand(const OCTETSTRING& par_messageType,
    const BSSMAP__IE__Layer3Information& par_initialLayer3Information,
    const BSSMAP__IE__RerouteRejectCause& par_rerouteRejectCause,
    const OPTIONAL< BSSMAP__IE__Layer3Information >& par_layer3Information,
    const OPTIONAL< BSSMAP__IE__SendSequenceNumber >& par_sendSequenceNumber,
    const OPTIONAL< BSSMAP__IE__IMSI >& par_iMSI)
  :   field_messageType(par_messageType),
  field_initialLayer3Information(par_initialLayer3Information),
  field_rerouteRejectCause(par_rerouteRejectCause),
  field_layer3Information(par_layer3Information),
  field_sendSequenceNumber(par_sendSequenceNumber),
  field_iMSI(par_iMSI)
{
}

PDU__BSSMAP__RerouteCommand::PDU__BSSMAP__RerouteCommand(const PDU__BSSMAP__RerouteCommand& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.initialLayer3Information().is_bound()) field_initialLayer3Information = other_value.initialLayer3Information();
else field_initialLayer3Information.clean_up();
if (other_value.rerouteRejectCause().is_bound()) field_rerouteRejectCause = other_value.rerouteRejectCause();
else field_rerouteRejectCause.clean_up();
if (other_value.layer3Information().is_bound()) field_layer3Information = other_value.layer3Information();
else field_layer3Information.clean_up();
if (other_value.sendSequenceNumber().is_bound()) field_sendSequenceNumber = other_value.sendSequenceNumber();
else field_sendSequenceNumber.clean_up();
if (other_value.iMSI().is_bound()) field_iMSI = other_value.iMSI();
else field_iMSI.clean_up();
}

void PDU__BSSMAP__RerouteCommand::clean_up()
{
field_messageType.clean_up();
field_initialLayer3Information.clean_up();
field_rerouteRejectCause.clean_up();
field_layer3Information.clean_up();
field_sendSequenceNumber.clean_up();
field_iMSI.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__RerouteCommand::get_descriptor() const { return &PDU__BSSMAP__RerouteCommand_descr_; }
PDU__BSSMAP__RerouteCommand& PDU__BSSMAP__RerouteCommand::operator=(const PDU__BSSMAP__RerouteCommand& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.initialLayer3Information().is_bound()) field_initialLayer3Information = other_value.initialLayer3Information();
  else field_initialLayer3Information.clean_up();
  if (other_value.rerouteRejectCause().is_bound()) field_rerouteRejectCause = other_value.rerouteRejectCause();
  else field_rerouteRejectCause.clean_up();
  if (other_value.layer3Information().is_bound()) field_layer3Information = other_value.layer3Information();
  else field_layer3Information.clean_up();
  if (other_value.sendSequenceNumber().is_bound()) field_sendSequenceNumber = other_value.sendSequenceNumber();
  else field_sendSequenceNumber.clean_up();
  if (other_value.iMSI().is_bound()) field_iMSI = other_value.iMSI();
  else field_iMSI.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__RerouteCommand::operator==(const PDU__BSSMAP__RerouteCommand& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_initialLayer3Information==other_value.field_initialLayer3Information
  && field_rerouteRejectCause==other_value.field_rerouteRejectCause
  && field_layer3Information==other_value.field_layer3Information
  && field_sendSequenceNumber==other_value.field_sendSequenceNumber
  && field_iMSI==other_value.field_iMSI;
}

boolean PDU__BSSMAP__RerouteCommand::is_bound() const
{
return (field_messageType.is_bound())
  || (field_initialLayer3Information.is_bound())
  || (field_rerouteRejectCause.is_bound())
  || (OPTIONAL_OMIT == field_layer3Information.get_selection() || field_layer3Information.is_bound())
  || (OPTIONAL_OMIT == field_sendSequenceNumber.get_selection() || field_sendSequenceNumber.is_bound())
  || (OPTIONAL_OMIT == field_iMSI.get_selection() || field_iMSI.is_bound());
}
boolean PDU__BSSMAP__RerouteCommand::is_value() const
{
return field_messageType.is_value()
  && field_initialLayer3Information.is_value()
  && field_rerouteRejectCause.is_value()
  && (OPTIONAL_OMIT == field_layer3Information.get_selection() || field_layer3Information.is_value())
  && (OPTIONAL_OMIT == field_sendSequenceNumber.get_selection() || field_sendSequenceNumber.is_value())
  && (OPTIONAL_OMIT == field_iMSI.get_selection() || field_iMSI.is_value());
}
int PDU__BSSMAP__RerouteCommand::size_of() const
{
  int ret_val = 3;
  if (field_layer3Information.ispresent()) ret_val++;
  if (field_sendSequenceNumber.ispresent()) ret_val++;
  if (field_iMSI.ispresent()) ret_val++;
  return ret_val;
}

void PDU__BSSMAP__RerouteCommand::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", initialLayer3Information := ");
field_initialLayer3Information.log();
TTCN_Logger::log_event_str(", rerouteRejectCause := ");
field_rerouteRejectCause.log();
TTCN_Logger::log_event_str(", layer3Information := ");
field_layer3Information.log();
TTCN_Logger::log_event_str(", sendSequenceNumber := ");
field_sendSequenceNumber.log();
TTCN_Logger::log_event_str(", iMSI := ");
field_iMSI.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__RerouteCommand::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (initialLayer3Information().is_bound()) initialLayer3Information().set_implicit_omit();
if (rerouteRejectCause().is_bound()) rerouteRejectCause().set_implicit_omit();
if (!layer3Information().is_bound()) layer3Information() = OMIT_VALUE;
else layer3Information().set_implicit_omit();
if (!sendSequenceNumber().is_bound()) sendSequenceNumber() = OMIT_VALUE;
else sendSequenceNumber().set_implicit_omit();
if (!iMSI().is_bound()) iMSI() = OMIT_VALUE;
else iMSI().set_implicit_omit();
}

void PDU__BSSMAP__RerouteCommand::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) initialLayer3Information().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) rerouteRejectCause().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) layer3Information().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) sendSequenceNumber().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) iMSI().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "initialLayer3Information")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          initialLayer3Information().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rerouteRejectCause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rerouteRejectCause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "layer3Information")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          layer3Information().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sendSequenceNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sendSequenceNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iMSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iMSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_RerouteCommand: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_RerouteCommand");
  }
}

void PDU__BSSMAP__RerouteCommand::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_initialLayer3Information.encode_text(text_buf);
field_rerouteRejectCause.encode_text(text_buf);
field_layer3Information.encode_text(text_buf);
field_sendSequenceNumber.encode_text(text_buf);
field_iMSI.encode_text(text_buf);
}

void PDU__BSSMAP__RerouteCommand::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_initialLayer3Information.decode_text(text_buf);
field_rerouteRejectCause.decode_text(text_buf);
field_layer3Information.decode_text(text_buf);
field_sendSequenceNumber.decode_text(text_buf);
field_iMSI.decode_text(text_buf);
}

void PDU__BSSMAP__RerouteCommand::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__RerouteCommand::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__RerouteCommand::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__Layer3Information_descr_.raw->forceomit);
  decoded_field_length = field_initialLayer3Information.RAW_decode(BSSMAP__IE__Layer3Information_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, BSSMAP__IE__RerouteRejectCause_descr_.raw->forceomit);
  decoded_field_length = field_rerouteRejectCause.RAW_decode(BSSMAP__IE__RerouteRejectCause_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_layer3Information = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, BSSMAP__IE__Layer3Information_descr_.raw->forceomit);
  decoded_field_length = field_layer3Information().RAW_decode(BSSMAP__IE__Layer3Information_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_layer3Information = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_layer3Information=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_sendSequenceNumber = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, BSSMAP__IE__SendSequenceNumber_descr_.raw->forceomit);
  decoded_field_length = field_sendSequenceNumber().RAW_decode(BSSMAP__IE__SendSequenceNumber_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_sendSequenceNumber = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_sendSequenceNumber=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_iMSI = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, BSSMAP__IE__IMSI_descr_.raw->forceomit);
  decoded_field_length = field_iMSI().RAW_decode(BSSMAP__IE__IMSI_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_iMSI = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_iMSI=OMIT_VALUE;
  if (field_messageType !=  os_128) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__RerouteCommand::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 6;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(6);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__Layer3Information_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, BSSMAP__IE__RerouteRejectCause_descr_.raw);
  if (field_layer3Information.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, BSSMAP__IE__Layer3Information_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_sendSequenceNumber.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, BSSMAP__IE__SendSequenceNumber_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  if (field_iMSI.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, BSSMAP__IE__IMSI_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_initialLayer3Information.RAW_encode(BSSMAP__IE__Layer3Information_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_rerouteRejectCause.RAW_encode(BSSMAP__IE__RerouteRejectCause_descr_, *myleaf.body.node.nodes[2]);
  if (field_layer3Information.ispresent()) {
  encoded_length += field_layer3Information().RAW_encode(BSSMAP__IE__Layer3Information_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_sendSequenceNumber.ispresent()) {
  encoded_length += field_sendSequenceNumber().RAW_encode(BSSMAP__IE__SendSequenceNumber_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_iMSI.ispresent()) {
  encoded_length += field_iMSI().RAW_encode(BSSMAP__IE__IMSI_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_messageType !=  os_128) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_128.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__RerouteCommand_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__Layer3Information_template field_initialLayer3Information;
BSSMAP__IE__RerouteRejectCause_template field_rerouteRejectCause;
BSSMAP__IE__Layer3Information_template field_layer3Information;
BSSMAP__IE__SendSequenceNumber_template field_sendSequenceNumber;
BSSMAP__IE__IMSI_template field_iMSI;
};

void PDU__BSSMAP__RerouteCommand_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_initialLayer3Information = ANY_VALUE;
single_value->field_rerouteRejectCause = ANY_VALUE;
single_value->field_layer3Information = ANY_OR_OMIT;
single_value->field_sendSequenceNumber = ANY_OR_OMIT;
single_value->field_iMSI = ANY_OR_OMIT;
}
}
}

void PDU__BSSMAP__RerouteCommand_template::copy_value(const PDU__BSSMAP__RerouteCommand& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.initialLayer3Information().is_bound()) {
  single_value->field_initialLayer3Information = other_value.initialLayer3Information();
} else {
  single_value->field_initialLayer3Information.clean_up();
}
if (other_value.rerouteRejectCause().is_bound()) {
  single_value->field_rerouteRejectCause = other_value.rerouteRejectCause();
} else {
  single_value->field_rerouteRejectCause.clean_up();
}
if (other_value.layer3Information().is_bound()) {
  if (other_value.layer3Information().ispresent()) single_value->field_layer3Information = other_value.layer3Information()();
  else single_value->field_layer3Information = OMIT_VALUE;
} else {
  single_value->field_layer3Information.clean_up();
}
if (other_value.sendSequenceNumber().is_bound()) {
  if (other_value.sendSequenceNumber().ispresent()) single_value->field_sendSequenceNumber = other_value.sendSequenceNumber()();
  else single_value->field_sendSequenceNumber = OMIT_VALUE;
} else {
  single_value->field_sendSequenceNumber.clean_up();
}
if (other_value.iMSI().is_bound()) {
  if (other_value.iMSI().ispresent()) single_value->field_iMSI = other_value.iMSI()();
  else single_value->field_iMSI = OMIT_VALUE;
} else {
  single_value->field_iMSI.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__RerouteCommand_template::copy_template(const PDU__BSSMAP__RerouteCommand_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.initialLayer3Information().get_selection()) {
single_value->field_initialLayer3Information = other_value.initialLayer3Information();
} else {
single_value->field_initialLayer3Information.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rerouteRejectCause().get_selection()) {
single_value->field_rerouteRejectCause = other_value.rerouteRejectCause();
} else {
single_value->field_rerouteRejectCause.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.layer3Information().get_selection()) {
single_value->field_layer3Information = other_value.layer3Information();
} else {
single_value->field_layer3Information.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sendSequenceNumber().get_selection()) {
single_value->field_sendSequenceNumber = other_value.sendSequenceNumber();
} else {
single_value->field_sendSequenceNumber.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.iMSI().get_selection()) {
single_value->field_iMSI = other_value.iMSI();
} else {
single_value->field_iMSI.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__RerouteCommand_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__RerouteCommand_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__RerouteCommand_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__RerouteCommand_template::PDU__BSSMAP__RerouteCommand_template()
{
}

PDU__BSSMAP__RerouteCommand_template::PDU__BSSMAP__RerouteCommand_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__RerouteCommand_template::PDU__BSSMAP__RerouteCommand_template(const PDU__BSSMAP__RerouteCommand& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__RerouteCommand_template::PDU__BSSMAP__RerouteCommand_template(const OPTIONAL<PDU__BSSMAP__RerouteCommand>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__RerouteCommand&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand from an unbound optional field.");
}
}

PDU__BSSMAP__RerouteCommand_template::PDU__BSSMAP__RerouteCommand_template(PDU__BSSMAP__RerouteCommand_template* p_precondition, PDU__BSSMAP__RerouteCommand_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__RerouteCommand_template::PDU__BSSMAP__RerouteCommand_template(Dynamic_Match_Interface<PDU__BSSMAP__RerouteCommand>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__RerouteCommand>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__RerouteCommand_template::PDU__BSSMAP__RerouteCommand_template(const PDU__BSSMAP__RerouteCommand_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__RerouteCommand_template::~PDU__BSSMAP__RerouteCommand_template()
{
clean_up();
}

PDU__BSSMAP__RerouteCommand_template& PDU__BSSMAP__RerouteCommand_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__RerouteCommand_template& PDU__BSSMAP__RerouteCommand_template::operator=(const PDU__BSSMAP__RerouteCommand& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__RerouteCommand_template& PDU__BSSMAP__RerouteCommand_template::operator=(const OPTIONAL<PDU__BSSMAP__RerouteCommand>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__RerouteCommand&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand.");
}
return *this;
}

PDU__BSSMAP__RerouteCommand_template& PDU__BSSMAP__RerouteCommand_template::operator=(const PDU__BSSMAP__RerouteCommand_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__RerouteCommand_template::match(const PDU__BSSMAP__RerouteCommand& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.initialLayer3Information().is_bound()) return FALSE;
if(!single_value->field_initialLayer3Information.match(other_value.initialLayer3Information(), legacy))return FALSE;
if(!other_value.rerouteRejectCause().is_bound()) return FALSE;
if(!single_value->field_rerouteRejectCause.match(other_value.rerouteRejectCause(), legacy))return FALSE;
if(!other_value.layer3Information().is_bound()) return FALSE;
if((other_value.layer3Information().ispresent() ? !single_value->field_layer3Information.match((const BSSMAP__IE__Layer3Information&)other_value.layer3Information(), legacy) : !single_value->field_layer3Information.match_omit(legacy)))return FALSE;
if(!other_value.sendSequenceNumber().is_bound()) return FALSE;
if((other_value.sendSequenceNumber().ispresent() ? !single_value->field_sendSequenceNumber.match((const BSSMAP__IE__SendSequenceNumber&)other_value.sendSequenceNumber(), legacy) : !single_value->field_sendSequenceNumber.match_omit(legacy)))return FALSE;
if(!other_value.iMSI().is_bound()) return FALSE;
if((other_value.iMSI().ispresent() ? !single_value->field_iMSI.match((const BSSMAP__IE__IMSI&)other_value.iMSI(), legacy) : !single_value->field_iMSI.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand.");
}
return FALSE;
}

boolean PDU__BSSMAP__RerouteCommand_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_initialLayer3Information.is_bound()
 || single_value->field_rerouteRejectCause.is_bound()
 || (single_value->field_layer3Information.is_omit() || single_value->field_layer3Information.is_bound())
 || (single_value->field_sendSequenceNumber.is_omit() || single_value->field_sendSequenceNumber.is_bound())
 || (single_value->field_iMSI.is_omit() || single_value->field_iMSI.is_bound());
}

boolean PDU__BSSMAP__RerouteCommand_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_initialLayer3Information.is_value()
 && single_value->field_rerouteRejectCause.is_value()
 && (single_value->field_layer3Information.is_omit() || single_value->field_layer3Information.is_value())
 && (single_value->field_sendSequenceNumber.is_omit() || single_value->field_sendSequenceNumber.is_value())
 && (single_value->field_iMSI.is_omit() || single_value->field_iMSI.is_value());
}

void PDU__BSSMAP__RerouteCommand_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__RerouteCommand PDU__BSSMAP__RerouteCommand_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand.");
PDU__BSSMAP__RerouteCommand ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_initialLayer3Information.is_bound()) {
ret_val.initialLayer3Information() = single_value->field_initialLayer3Information.valueof();
}
if (single_value->field_rerouteRejectCause.is_bound()) {
ret_val.rerouteRejectCause() = single_value->field_rerouteRejectCause.valueof();
}
if (single_value->field_layer3Information.is_omit()) ret_val.layer3Information() = OMIT_VALUE;
else if (single_value->field_layer3Information.is_bound()) {
ret_val.layer3Information() = single_value->field_layer3Information.valueof();
}
if (single_value->field_sendSequenceNumber.is_omit()) ret_val.sendSequenceNumber() = OMIT_VALUE;
else if (single_value->field_sendSequenceNumber.is_bound()) {
ret_val.sendSequenceNumber() = single_value->field_sendSequenceNumber.valueof();
}
if (single_value->field_iMSI.is_omit()) ret_val.iMSI() = OMIT_VALUE;
else if (single_value->field_iMSI.is_bound()) {
ret_val.iMSI() = single_value->field_iMSI.valueof();
}
return ret_val;
}

void PDU__BSSMAP__RerouteCommand_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__RerouteCommand_template[list_length];
}

PDU__BSSMAP__RerouteCommand_template& PDU__BSSMAP__RerouteCommand_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__RerouteCommand_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__RerouteCommand_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand.");
return single_value->field_messageType;
}

BSSMAP__IE__Layer3Information_template& PDU__BSSMAP__RerouteCommand_template::initialLayer3Information()
{
set_specific();
return single_value->field_initialLayer3Information;
}

const BSSMAP__IE__Layer3Information_template& PDU__BSSMAP__RerouteCommand_template::initialLayer3Information() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field initialLayer3Information of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand.");
return single_value->field_initialLayer3Information;
}

BSSMAP__IE__RerouteRejectCause_template& PDU__BSSMAP__RerouteCommand_template::rerouteRejectCause()
{
set_specific();
return single_value->field_rerouteRejectCause;
}

const BSSMAP__IE__RerouteRejectCause_template& PDU__BSSMAP__RerouteCommand_template::rerouteRejectCause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rerouteRejectCause of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand.");
return single_value->field_rerouteRejectCause;
}

BSSMAP__IE__Layer3Information_template& PDU__BSSMAP__RerouteCommand_template::layer3Information()
{
set_specific();
return single_value->field_layer3Information;
}

const BSSMAP__IE__Layer3Information_template& PDU__BSSMAP__RerouteCommand_template::layer3Information() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field layer3Information of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand.");
return single_value->field_layer3Information;
}

BSSMAP__IE__SendSequenceNumber_template& PDU__BSSMAP__RerouteCommand_template::sendSequenceNumber()
{
set_specific();
return single_value->field_sendSequenceNumber;
}

const BSSMAP__IE__SendSequenceNumber_template& PDU__BSSMAP__RerouteCommand_template::sendSequenceNumber() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sendSequenceNumber of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand.");
return single_value->field_sendSequenceNumber;
}

BSSMAP__IE__IMSI_template& PDU__BSSMAP__RerouteCommand_template::iMSI()
{
set_specific();
return single_value->field_iMSI;
}

const BSSMAP__IE__IMSI_template& PDU__BSSMAP__RerouteCommand_template::iMSI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field iMSI of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand.");
return single_value->field_iMSI;
}

int PDU__BSSMAP__RerouteCommand_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 3;
      if (single_value->field_layer3Information.is_present()) ret_val++;
      if (single_value->field_sendSequenceNumber.is_present()) ret_val++;
      if (single_value->field_iMSI.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand.");
  }
  return 0;
}

void PDU__BSSMAP__RerouteCommand_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", initialLayer3Information := ");
single_value->field_initialLayer3Information.log();
TTCN_Logger::log_event_str(", rerouteRejectCause := ");
single_value->field_rerouteRejectCause.log();
TTCN_Logger::log_event_str(", layer3Information := ");
single_value->field_layer3Information.log();
TTCN_Logger::log_event_str(", sendSequenceNumber := ");
single_value->field_sendSequenceNumber.log();
TTCN_Logger::log_event_str(", iMSI := ");
single_value->field_iMSI.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__RerouteCommand_template::log_match(const PDU__BSSMAP__RerouteCommand& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_initialLayer3Information.match(match_value.initialLayer3Information(), legacy)){
TTCN_Logger::log_logmatch_info(".initialLayer3Information");
single_value->field_initialLayer3Information.log_match(match_value.initialLayer3Information(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rerouteRejectCause.match(match_value.rerouteRejectCause(), legacy)){
TTCN_Logger::log_logmatch_info(".rerouteRejectCause");
single_value->field_rerouteRejectCause.log_match(match_value.rerouteRejectCause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.layer3Information().ispresent()){
if(!single_value->field_layer3Information.match(match_value.layer3Information(), legacy)){
TTCN_Logger::log_logmatch_info(".layer3Information");
single_value->field_layer3Information.log_match(match_value.layer3Information(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_layer3Information.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".layer3Information := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_layer3Information.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.sendSequenceNumber().ispresent()){
if(!single_value->field_sendSequenceNumber.match(match_value.sendSequenceNumber(), legacy)){
TTCN_Logger::log_logmatch_info(".sendSequenceNumber");
single_value->field_sendSequenceNumber.log_match(match_value.sendSequenceNumber(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_sendSequenceNumber.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".sendSequenceNumber := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_sendSequenceNumber.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.iMSI().ispresent()){
if(!single_value->field_iMSI.match(match_value.iMSI(), legacy)){
TTCN_Logger::log_logmatch_info(".iMSI");
single_value->field_iMSI.log_match(match_value.iMSI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_iMSI.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".iMSI := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_iMSI.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", initialLayer3Information := ");
single_value->field_initialLayer3Information.log_match(match_value.initialLayer3Information(), legacy);
TTCN_Logger::log_event_str(", rerouteRejectCause := ");
single_value->field_rerouteRejectCause.log_match(match_value.rerouteRejectCause(), legacy);
TTCN_Logger::log_event_str(", layer3Information := ");
if (match_value.layer3Information().ispresent()) {
single_value->field_layer3Information.log_match(match_value.layer3Information(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_layer3Information.log();
if (single_value->field_layer3Information.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", sendSequenceNumber := ");
if (match_value.sendSequenceNumber().ispresent()) {
single_value->field_sendSequenceNumber.log_match(match_value.sendSequenceNumber(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_sendSequenceNumber.log();
if (single_value->field_sendSequenceNumber.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", iMSI := ");
if (match_value.iMSI().ispresent()) {
single_value->field_iMSI.log_match(match_value.iMSI(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_iMSI.log();
if (single_value->field_iMSI.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__RerouteCommand_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (initialLayer3Information().is_bound()) initialLayer3Information().set_implicit_omit();
if (rerouteRejectCause().is_bound()) rerouteRejectCause().set_implicit_omit();
if (!layer3Information().is_bound()) layer3Information() = OMIT_VALUE;
else layer3Information().set_implicit_omit();
if (!sendSequenceNumber().is_bound()) sendSequenceNumber() = OMIT_VALUE;
else sendSequenceNumber().set_implicit_omit();
if (!iMSI().is_bound()) iMSI() = OMIT_VALUE;
else iMSI().set_implicit_omit();
}

void PDU__BSSMAP__RerouteCommand_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_initialLayer3Information.encode_text(text_buf);
single_value->field_rerouteRejectCause.encode_text(text_buf);
single_value->field_layer3Information.encode_text(text_buf);
single_value->field_sendSequenceNumber.encode_text(text_buf);
single_value->field_iMSI.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand.");
}
}

void PDU__BSSMAP__RerouteCommand_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_initialLayer3Information.decode_text(text_buf);
single_value->field_rerouteRejectCause.decode_text(text_buf);
single_value->field_layer3Information.decode_text(text_buf);
single_value->field_sendSequenceNumber.decode_text(text_buf);
single_value->field_iMSI.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__RerouteCommand_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand.");
}
}

void PDU__BSSMAP__RerouteCommand_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__RerouteCommand_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (6<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_RerouteCommand has 6 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) initialLayer3Information().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) rerouteRejectCause().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) layer3Information().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) sendSequenceNumber().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) iMSI().set_param(*param.get_elem(5));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "initialLayer3Information")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          initialLayer3Information().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rerouteRejectCause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rerouteRejectCause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "layer3Information")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          layer3Information().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sendSequenceNumber")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sendSequenceNumber().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "iMSI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          iMSI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_RerouteCommand: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__RerouteCommand_template* precondition = new PDU__BSSMAP__RerouteCommand_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__RerouteCommand_template* implied_template = new PDU__BSSMAP__RerouteCommand_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__RerouteCommand_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_RerouteCommand");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__RerouteCommand_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_RerouteCommand");
single_value->field_initialLayer3Information.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_RerouteCommand");
single_value->field_rerouteRejectCause.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_RerouteCommand");
single_value->field_layer3Information.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_RerouteCommand");
single_value->field_sendSequenceNumber.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_RerouteCommand");
single_value->field_iMSI.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_RerouteCommand");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_RerouteCommand");
}

boolean PDU__BSSMAP__RerouteCommand_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__RerouteCommand_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__RerouteComplete::PDU__BSSMAP__RerouteComplete()
{
}

PDU__BSSMAP__RerouteComplete::PDU__BSSMAP__RerouteComplete(const OCTETSTRING& par_messageType,
    const BSSMAP__IE__RerouteCompleteOutcome& par_rerouteCompleteOutcome)
  :   field_messageType(par_messageType),
  field_rerouteCompleteOutcome(par_rerouteCompleteOutcome)
{
}

PDU__BSSMAP__RerouteComplete::PDU__BSSMAP__RerouteComplete(const PDU__BSSMAP__RerouteComplete& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.rerouteCompleteOutcome().is_bound()) field_rerouteCompleteOutcome = other_value.rerouteCompleteOutcome();
else field_rerouteCompleteOutcome.clean_up();
}

void PDU__BSSMAP__RerouteComplete::clean_up()
{
field_messageType.clean_up();
field_rerouteCompleteOutcome.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__RerouteComplete::get_descriptor() const { return &PDU__BSSMAP__RerouteComplete_descr_; }
PDU__BSSMAP__RerouteComplete& PDU__BSSMAP__RerouteComplete::operator=(const PDU__BSSMAP__RerouteComplete& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.rerouteCompleteOutcome().is_bound()) field_rerouteCompleteOutcome = other_value.rerouteCompleteOutcome();
  else field_rerouteCompleteOutcome.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__RerouteComplete::operator==(const PDU__BSSMAP__RerouteComplete& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_rerouteCompleteOutcome==other_value.field_rerouteCompleteOutcome;
}

boolean PDU__BSSMAP__RerouteComplete::is_bound() const
{
return (field_messageType.is_bound())
  || (field_rerouteCompleteOutcome.is_bound());
}
boolean PDU__BSSMAP__RerouteComplete::is_value() const
{
return field_messageType.is_value()
  && field_rerouteCompleteOutcome.is_value();
}
void PDU__BSSMAP__RerouteComplete::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", rerouteCompleteOutcome := ");
field_rerouteCompleteOutcome.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__RerouteComplete::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (rerouteCompleteOutcome().is_bound()) rerouteCompleteOutcome().set_implicit_omit();
}

void PDU__BSSMAP__RerouteComplete::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) rerouteCompleteOutcome().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rerouteCompleteOutcome")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rerouteCompleteOutcome().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_RerouteComplete: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_RerouteComplete");
  }
}

void PDU__BSSMAP__RerouteComplete::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_rerouteCompleteOutcome.encode_text(text_buf);
}

void PDU__BSSMAP__RerouteComplete::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_rerouteCompleteOutcome.decode_text(text_buf);
}

void PDU__BSSMAP__RerouteComplete::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__RerouteComplete::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__RerouteComplete::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__RerouteCompleteOutcome_descr_.raw->forceomit);
  decoded_field_length = field_rerouteCompleteOutcome.RAW_decode(BSSMAP__IE__RerouteCompleteOutcome_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_messageType !=  os_129) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__RerouteComplete::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__RerouteCompleteOutcome_descr_.raw);
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_rerouteCompleteOutcome.RAW_encode(BSSMAP__IE__RerouteCompleteOutcome_descr_, *myleaf.body.node.nodes[1]);
  if (field_messageType !=  os_129) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_129.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__RerouteComplete_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__RerouteCompleteOutcome_template field_rerouteCompleteOutcome;
};

void PDU__BSSMAP__RerouteComplete_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_rerouteCompleteOutcome = ANY_VALUE;
}
}
}

void PDU__BSSMAP__RerouteComplete_template::copy_value(const PDU__BSSMAP__RerouteComplete& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.rerouteCompleteOutcome().is_bound()) {
  single_value->field_rerouteCompleteOutcome = other_value.rerouteCompleteOutcome();
} else {
  single_value->field_rerouteCompleteOutcome.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__RerouteComplete_template::copy_template(const PDU__BSSMAP__RerouteComplete_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rerouteCompleteOutcome().get_selection()) {
single_value->field_rerouteCompleteOutcome = other_value.rerouteCompleteOutcome();
} else {
single_value->field_rerouteCompleteOutcome.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__RerouteComplete_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__RerouteComplete_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__RerouteComplete_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__RerouteComplete_template::PDU__BSSMAP__RerouteComplete_template()
{
}

PDU__BSSMAP__RerouteComplete_template::PDU__BSSMAP__RerouteComplete_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__RerouteComplete_template::PDU__BSSMAP__RerouteComplete_template(const PDU__BSSMAP__RerouteComplete& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__RerouteComplete_template::PDU__BSSMAP__RerouteComplete_template(const OPTIONAL<PDU__BSSMAP__RerouteComplete>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__RerouteComplete&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete from an unbound optional field.");
}
}

PDU__BSSMAP__RerouteComplete_template::PDU__BSSMAP__RerouteComplete_template(PDU__BSSMAP__RerouteComplete_template* p_precondition, PDU__BSSMAP__RerouteComplete_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__RerouteComplete_template::PDU__BSSMAP__RerouteComplete_template(Dynamic_Match_Interface<PDU__BSSMAP__RerouteComplete>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__RerouteComplete>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__RerouteComplete_template::PDU__BSSMAP__RerouteComplete_template(const PDU__BSSMAP__RerouteComplete_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__RerouteComplete_template::~PDU__BSSMAP__RerouteComplete_template()
{
clean_up();
}

PDU__BSSMAP__RerouteComplete_template& PDU__BSSMAP__RerouteComplete_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__RerouteComplete_template& PDU__BSSMAP__RerouteComplete_template::operator=(const PDU__BSSMAP__RerouteComplete& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__RerouteComplete_template& PDU__BSSMAP__RerouteComplete_template::operator=(const OPTIONAL<PDU__BSSMAP__RerouteComplete>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__RerouteComplete&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete.");
}
return *this;
}

PDU__BSSMAP__RerouteComplete_template& PDU__BSSMAP__RerouteComplete_template::operator=(const PDU__BSSMAP__RerouteComplete_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__RerouteComplete_template::match(const PDU__BSSMAP__RerouteComplete& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.rerouteCompleteOutcome().is_bound()) return FALSE;
if(!single_value->field_rerouteCompleteOutcome.match(other_value.rerouteCompleteOutcome(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete.");
}
return FALSE;
}

boolean PDU__BSSMAP__RerouteComplete_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_rerouteCompleteOutcome.is_bound();
}

boolean PDU__BSSMAP__RerouteComplete_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_rerouteCompleteOutcome.is_value();
}

void PDU__BSSMAP__RerouteComplete_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__RerouteComplete PDU__BSSMAP__RerouteComplete_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete.");
PDU__BSSMAP__RerouteComplete ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_rerouteCompleteOutcome.is_bound()) {
ret_val.rerouteCompleteOutcome() = single_value->field_rerouteCompleteOutcome.valueof();
}
return ret_val;
}

void PDU__BSSMAP__RerouteComplete_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__RerouteComplete_template[list_length];
}

PDU__BSSMAP__RerouteComplete_template& PDU__BSSMAP__RerouteComplete_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__RerouteComplete_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__RerouteComplete_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete.");
return single_value->field_messageType;
}

BSSMAP__IE__RerouteCompleteOutcome_template& PDU__BSSMAP__RerouteComplete_template::rerouteCompleteOutcome()
{
set_specific();
return single_value->field_rerouteCompleteOutcome;
}

const BSSMAP__IE__RerouteCompleteOutcome_template& PDU__BSSMAP__RerouteComplete_template::rerouteCompleteOutcome() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rerouteCompleteOutcome of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete.");
return single_value->field_rerouteCompleteOutcome;
}

int PDU__BSSMAP__RerouteComplete_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete.");
  }
  return 0;
}

void PDU__BSSMAP__RerouteComplete_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", rerouteCompleteOutcome := ");
single_value->field_rerouteCompleteOutcome.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__RerouteComplete_template::log_match(const PDU__BSSMAP__RerouteComplete& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rerouteCompleteOutcome.match(match_value.rerouteCompleteOutcome(), legacy)){
TTCN_Logger::log_logmatch_info(".rerouteCompleteOutcome");
single_value->field_rerouteCompleteOutcome.log_match(match_value.rerouteCompleteOutcome(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", rerouteCompleteOutcome := ");
single_value->field_rerouteCompleteOutcome.log_match(match_value.rerouteCompleteOutcome(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__RerouteComplete_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (rerouteCompleteOutcome().is_bound()) rerouteCompleteOutcome().set_implicit_omit();
}

void PDU__BSSMAP__RerouteComplete_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_rerouteCompleteOutcome.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete.");
}
}

void PDU__BSSMAP__RerouteComplete_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_rerouteCompleteOutcome.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__RerouteComplete_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete.");
}
}

void PDU__BSSMAP__RerouteComplete_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__RerouteComplete_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_RerouteComplete has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) rerouteCompleteOutcome().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rerouteCompleteOutcome")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rerouteCompleteOutcome().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_RerouteComplete: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__RerouteComplete_template* precondition = new PDU__BSSMAP__RerouteComplete_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__RerouteComplete_template* implied_template = new PDU__BSSMAP__RerouteComplete_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__RerouteComplete_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_RerouteComplete");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__RerouteComplete_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_RerouteComplete");
single_value->field_rerouteCompleteOutcome.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_RerouteComplete");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_RerouteComplete");
}

boolean PDU__BSSMAP__RerouteComplete_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__RerouteComplete_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__LCLS__ConnectControl::PDU__BSSMAP__LCLS__ConnectControl()
{
}

PDU__BSSMAP__LCLS__ConnectControl::PDU__BSSMAP__LCLS__ConnectControl(const OCTETSTRING& par_messageType,
    const OPTIONAL< BSSMAP__IE__LCLS__Configuration >& par_lCLS__Configuration,
    const OPTIONAL< BSSMAP__IE__LCLS__ConnectionStatusControl >& par_lCLS__ConnectionStatusControl)
  :   field_messageType(par_messageType),
  field_lCLS__Configuration(par_lCLS__Configuration),
  field_lCLS__ConnectionStatusControl(par_lCLS__ConnectionStatusControl)
{
}

PDU__BSSMAP__LCLS__ConnectControl::PDU__BSSMAP__LCLS__ConnectControl(const PDU__BSSMAP__LCLS__ConnectControl& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.lCLS__Configuration().is_bound()) field_lCLS__Configuration = other_value.lCLS__Configuration();
else field_lCLS__Configuration.clean_up();
if (other_value.lCLS__ConnectionStatusControl().is_bound()) field_lCLS__ConnectionStatusControl = other_value.lCLS__ConnectionStatusControl();
else field_lCLS__ConnectionStatusControl.clean_up();
}

void PDU__BSSMAP__LCLS__ConnectControl::clean_up()
{
field_messageType.clean_up();
field_lCLS__Configuration.clean_up();
field_lCLS__ConnectionStatusControl.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__LCLS__ConnectControl::get_descriptor() const { return &PDU__BSSMAP__LCLS__ConnectControl_descr_; }
PDU__BSSMAP__LCLS__ConnectControl& PDU__BSSMAP__LCLS__ConnectControl::operator=(const PDU__BSSMAP__LCLS__ConnectControl& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.lCLS__Configuration().is_bound()) field_lCLS__Configuration = other_value.lCLS__Configuration();
  else field_lCLS__Configuration.clean_up();
  if (other_value.lCLS__ConnectionStatusControl().is_bound()) field_lCLS__ConnectionStatusControl = other_value.lCLS__ConnectionStatusControl();
  else field_lCLS__ConnectionStatusControl.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__LCLS__ConnectControl::operator==(const PDU__BSSMAP__LCLS__ConnectControl& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_lCLS__Configuration==other_value.field_lCLS__Configuration
  && field_lCLS__ConnectionStatusControl==other_value.field_lCLS__ConnectionStatusControl;
}

boolean PDU__BSSMAP__LCLS__ConnectControl::is_bound() const
{
return (field_messageType.is_bound())
  || (OPTIONAL_OMIT == field_lCLS__Configuration.get_selection() || field_lCLS__Configuration.is_bound())
  || (OPTIONAL_OMIT == field_lCLS__ConnectionStatusControl.get_selection() || field_lCLS__ConnectionStatusControl.is_bound());
}
boolean PDU__BSSMAP__LCLS__ConnectControl::is_value() const
{
return field_messageType.is_value()
  && (OPTIONAL_OMIT == field_lCLS__Configuration.get_selection() || field_lCLS__Configuration.is_value())
  && (OPTIONAL_OMIT == field_lCLS__ConnectionStatusControl.get_selection() || field_lCLS__ConnectionStatusControl.is_value());
}
int PDU__BSSMAP__LCLS__ConnectControl::size_of() const
{
  int ret_val = 1;
  if (field_lCLS__Configuration.ispresent()) ret_val++;
  if (field_lCLS__ConnectionStatusControl.ispresent()) ret_val++;
  return ret_val;
}

void PDU__BSSMAP__LCLS__ConnectControl::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", lCLS_Configuration := ");
field_lCLS__Configuration.log();
TTCN_Logger::log_event_str(", lCLS_ConnectionStatusControl := ");
field_lCLS__ConnectionStatusControl.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__LCLS__ConnectControl::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (!lCLS__Configuration().is_bound()) lCLS__Configuration() = OMIT_VALUE;
else lCLS__Configuration().set_implicit_omit();
if (!lCLS__ConnectionStatusControl().is_bound()) lCLS__ConnectionStatusControl() = OMIT_VALUE;
else lCLS__ConnectionStatusControl().set_implicit_omit();
}

void PDU__BSSMAP__LCLS__ConnectControl::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lCLS__Configuration().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lCLS__ConnectionStatusControl().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lCLS_Configuration")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lCLS__Configuration().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lCLS_ConnectionStatusControl")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lCLS__ConnectionStatusControl().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl");
  }
}

void PDU__BSSMAP__LCLS__ConnectControl::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_lCLS__Configuration.encode_text(text_buf);
field_lCLS__ConnectionStatusControl.encode_text(text_buf);
}

void PDU__BSSMAP__LCLS__ConnectControl::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_lCLS__Configuration.decode_text(text_buf);
field_lCLS__ConnectionStatusControl.decode_text(text_buf);
}

void PDU__BSSMAP__LCLS__ConnectControl::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__LCLS__ConnectControl::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__LCLS__ConnectControl::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_lCLS__Configuration = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__LCLS__Configuration_descr_.raw->forceomit);
  decoded_field_length = field_lCLS__Configuration().RAW_decode(BSSMAP__IE__LCLS__Configuration_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_lCLS__Configuration = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_lCLS__Configuration=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_lCLS__ConnectionStatusControl = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, BSSMAP__IE__LCLS__ConnectionStatusControl_descr_.raw->forceomit);
  decoded_field_length = field_lCLS__ConnectionStatusControl().RAW_decode(BSSMAP__IE__LCLS__ConnectionStatusControl_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_lCLS__ConnectionStatusControl = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_lCLS__ConnectionStatusControl=OMIT_VALUE;
  if (field_messageType !=  os_124) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__LCLS__ConnectControl::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  if (field_lCLS__Configuration.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__LCLS__Configuration_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  if (field_lCLS__ConnectionStatusControl.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, BSSMAP__IE__LCLS__ConnectionStatusControl_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  if (field_lCLS__Configuration.ispresent()) {
  encoded_length += field_lCLS__Configuration().RAW_encode(BSSMAP__IE__LCLS__Configuration_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_lCLS__ConnectionStatusControl.ispresent()) {
  encoded_length += field_lCLS__ConnectionStatusControl().RAW_encode(BSSMAP__IE__LCLS__ConnectionStatusControl_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_messageType !=  os_124) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_124.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__LCLS__ConnectControl_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__LCLS__Configuration_template field_lCLS__Configuration;
BSSMAP__IE__LCLS__ConnectionStatusControl_template field_lCLS__ConnectionStatusControl;
};

void PDU__BSSMAP__LCLS__ConnectControl_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_lCLS__Configuration = ANY_OR_OMIT;
single_value->field_lCLS__ConnectionStatusControl = ANY_OR_OMIT;
}
}
}

void PDU__BSSMAP__LCLS__ConnectControl_template::copy_value(const PDU__BSSMAP__LCLS__ConnectControl& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.lCLS__Configuration().is_bound()) {
  if (other_value.lCLS__Configuration().ispresent()) single_value->field_lCLS__Configuration = other_value.lCLS__Configuration()();
  else single_value->field_lCLS__Configuration = OMIT_VALUE;
} else {
  single_value->field_lCLS__Configuration.clean_up();
}
if (other_value.lCLS__ConnectionStatusControl().is_bound()) {
  if (other_value.lCLS__ConnectionStatusControl().ispresent()) single_value->field_lCLS__ConnectionStatusControl = other_value.lCLS__ConnectionStatusControl()();
  else single_value->field_lCLS__ConnectionStatusControl = OMIT_VALUE;
} else {
  single_value->field_lCLS__ConnectionStatusControl.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__LCLS__ConnectControl_template::copy_template(const PDU__BSSMAP__LCLS__ConnectControl_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lCLS__Configuration().get_selection()) {
single_value->field_lCLS__Configuration = other_value.lCLS__Configuration();
} else {
single_value->field_lCLS__Configuration.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lCLS__ConnectionStatusControl().get_selection()) {
single_value->field_lCLS__ConnectionStatusControl = other_value.lCLS__ConnectionStatusControl();
} else {
single_value->field_lCLS__ConnectionStatusControl.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__LCLS__ConnectControl_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__LCLS__ConnectControl_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__LCLS__ConnectControl_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__LCLS__ConnectControl_template::PDU__BSSMAP__LCLS__ConnectControl_template()
{
}

PDU__BSSMAP__LCLS__ConnectControl_template::PDU__BSSMAP__LCLS__ConnectControl_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__LCLS__ConnectControl_template::PDU__BSSMAP__LCLS__ConnectControl_template(const PDU__BSSMAP__LCLS__ConnectControl& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__LCLS__ConnectControl_template::PDU__BSSMAP__LCLS__ConnectControl_template(const OPTIONAL<PDU__BSSMAP__LCLS__ConnectControl>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__LCLS__ConnectControl&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl from an unbound optional field.");
}
}

PDU__BSSMAP__LCLS__ConnectControl_template::PDU__BSSMAP__LCLS__ConnectControl_template(PDU__BSSMAP__LCLS__ConnectControl_template* p_precondition, PDU__BSSMAP__LCLS__ConnectControl_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__LCLS__ConnectControl_template::PDU__BSSMAP__LCLS__ConnectControl_template(Dynamic_Match_Interface<PDU__BSSMAP__LCLS__ConnectControl>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__LCLS__ConnectControl>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__LCLS__ConnectControl_template::PDU__BSSMAP__LCLS__ConnectControl_template(const PDU__BSSMAP__LCLS__ConnectControl_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__LCLS__ConnectControl_template::~PDU__BSSMAP__LCLS__ConnectControl_template()
{
clean_up();
}

PDU__BSSMAP__LCLS__ConnectControl_template& PDU__BSSMAP__LCLS__ConnectControl_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__LCLS__ConnectControl_template& PDU__BSSMAP__LCLS__ConnectControl_template::operator=(const PDU__BSSMAP__LCLS__ConnectControl& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__LCLS__ConnectControl_template& PDU__BSSMAP__LCLS__ConnectControl_template::operator=(const OPTIONAL<PDU__BSSMAP__LCLS__ConnectControl>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__LCLS__ConnectControl&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl.");
}
return *this;
}

PDU__BSSMAP__LCLS__ConnectControl_template& PDU__BSSMAP__LCLS__ConnectControl_template::operator=(const PDU__BSSMAP__LCLS__ConnectControl_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__LCLS__ConnectControl_template::match(const PDU__BSSMAP__LCLS__ConnectControl& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.lCLS__Configuration().is_bound()) return FALSE;
if((other_value.lCLS__Configuration().ispresent() ? !single_value->field_lCLS__Configuration.match((const BSSMAP__IE__LCLS__Configuration&)other_value.lCLS__Configuration(), legacy) : !single_value->field_lCLS__Configuration.match_omit(legacy)))return FALSE;
if(!other_value.lCLS__ConnectionStatusControl().is_bound()) return FALSE;
if((other_value.lCLS__ConnectionStatusControl().ispresent() ? !single_value->field_lCLS__ConnectionStatusControl.match((const BSSMAP__IE__LCLS__ConnectionStatusControl&)other_value.lCLS__ConnectionStatusControl(), legacy) : !single_value->field_lCLS__ConnectionStatusControl.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl.");
}
return FALSE;
}

boolean PDU__BSSMAP__LCLS__ConnectControl_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || (single_value->field_lCLS__Configuration.is_omit() || single_value->field_lCLS__Configuration.is_bound())
 || (single_value->field_lCLS__ConnectionStatusControl.is_omit() || single_value->field_lCLS__ConnectionStatusControl.is_bound());
}

boolean PDU__BSSMAP__LCLS__ConnectControl_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && (single_value->field_lCLS__Configuration.is_omit() || single_value->field_lCLS__Configuration.is_value())
 && (single_value->field_lCLS__ConnectionStatusControl.is_omit() || single_value->field_lCLS__ConnectionStatusControl.is_value());
}

void PDU__BSSMAP__LCLS__ConnectControl_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__LCLS__ConnectControl PDU__BSSMAP__LCLS__ConnectControl_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl.");
PDU__BSSMAP__LCLS__ConnectControl ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_lCLS__Configuration.is_omit()) ret_val.lCLS__Configuration() = OMIT_VALUE;
else if (single_value->field_lCLS__Configuration.is_bound()) {
ret_val.lCLS__Configuration() = single_value->field_lCLS__Configuration.valueof();
}
if (single_value->field_lCLS__ConnectionStatusControl.is_omit()) ret_val.lCLS__ConnectionStatusControl() = OMIT_VALUE;
else if (single_value->field_lCLS__ConnectionStatusControl.is_bound()) {
ret_val.lCLS__ConnectionStatusControl() = single_value->field_lCLS__ConnectionStatusControl.valueof();
}
return ret_val;
}

void PDU__BSSMAP__LCLS__ConnectControl_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__LCLS__ConnectControl_template[list_length];
}

PDU__BSSMAP__LCLS__ConnectControl_template& PDU__BSSMAP__LCLS__ConnectControl_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__LCLS__ConnectControl_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__LCLS__ConnectControl_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl.");
return single_value->field_messageType;
}

BSSMAP__IE__LCLS__Configuration_template& PDU__BSSMAP__LCLS__ConnectControl_template::lCLS__Configuration()
{
set_specific();
return single_value->field_lCLS__Configuration;
}

const BSSMAP__IE__LCLS__Configuration_template& PDU__BSSMAP__LCLS__ConnectControl_template::lCLS__Configuration() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lCLS_Configuration of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl.");
return single_value->field_lCLS__Configuration;
}

BSSMAP__IE__LCLS__ConnectionStatusControl_template& PDU__BSSMAP__LCLS__ConnectControl_template::lCLS__ConnectionStatusControl()
{
set_specific();
return single_value->field_lCLS__ConnectionStatusControl;
}

const BSSMAP__IE__LCLS__ConnectionStatusControl_template& PDU__BSSMAP__LCLS__ConnectControl_template::lCLS__ConnectionStatusControl() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lCLS_ConnectionStatusControl of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl.");
return single_value->field_lCLS__ConnectionStatusControl;
}

int PDU__BSSMAP__LCLS__ConnectControl_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_lCLS__Configuration.is_present()) ret_val++;
      if (single_value->field_lCLS__ConnectionStatusControl.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl.");
  }
  return 0;
}

void PDU__BSSMAP__LCLS__ConnectControl_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", lCLS_Configuration := ");
single_value->field_lCLS__Configuration.log();
TTCN_Logger::log_event_str(", lCLS_ConnectionStatusControl := ");
single_value->field_lCLS__ConnectionStatusControl.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__LCLS__ConnectControl_template::log_match(const PDU__BSSMAP__LCLS__ConnectControl& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.lCLS__Configuration().ispresent()){
if(!single_value->field_lCLS__Configuration.match(match_value.lCLS__Configuration(), legacy)){
TTCN_Logger::log_logmatch_info(".lCLS_Configuration");
single_value->field_lCLS__Configuration.log_match(match_value.lCLS__Configuration(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_lCLS__Configuration.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".lCLS_Configuration := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_lCLS__Configuration.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.lCLS__ConnectionStatusControl().ispresent()){
if(!single_value->field_lCLS__ConnectionStatusControl.match(match_value.lCLS__ConnectionStatusControl(), legacy)){
TTCN_Logger::log_logmatch_info(".lCLS_ConnectionStatusControl");
single_value->field_lCLS__ConnectionStatusControl.log_match(match_value.lCLS__ConnectionStatusControl(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_lCLS__ConnectionStatusControl.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".lCLS_ConnectionStatusControl := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_lCLS__ConnectionStatusControl.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", lCLS_Configuration := ");
if (match_value.lCLS__Configuration().ispresent()) {
single_value->field_lCLS__Configuration.log_match(match_value.lCLS__Configuration(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_lCLS__Configuration.log();
if (single_value->field_lCLS__Configuration.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", lCLS_ConnectionStatusControl := ");
if (match_value.lCLS__ConnectionStatusControl().ispresent()) {
single_value->field_lCLS__ConnectionStatusControl.log_match(match_value.lCLS__ConnectionStatusControl(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_lCLS__ConnectionStatusControl.log();
if (single_value->field_lCLS__ConnectionStatusControl.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__LCLS__ConnectControl_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (!lCLS__Configuration().is_bound()) lCLS__Configuration() = OMIT_VALUE;
else lCLS__Configuration().set_implicit_omit();
if (!lCLS__ConnectionStatusControl().is_bound()) lCLS__ConnectionStatusControl() = OMIT_VALUE;
else lCLS__ConnectionStatusControl().set_implicit_omit();
}

void PDU__BSSMAP__LCLS__ConnectControl_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_lCLS__Configuration.encode_text(text_buf);
single_value->field_lCLS__ConnectionStatusControl.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl.");
}
}

void PDU__BSSMAP__LCLS__ConnectControl_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_lCLS__Configuration.decode_text(text_buf);
single_value->field_lCLS__ConnectionStatusControl.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__LCLS__ConnectControl_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl.");
}
}

void PDU__BSSMAP__LCLS__ConnectControl_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__LCLS__ConnectControl_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lCLS__Configuration().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lCLS__ConnectionStatusControl().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lCLS_Configuration")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lCLS__Configuration().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lCLS_ConnectionStatusControl")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lCLS__ConnectionStatusControl().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__LCLS__ConnectControl_template* precondition = new PDU__BSSMAP__LCLS__ConnectControl_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__LCLS__ConnectControl_template* implied_template = new PDU__BSSMAP__LCLS__ConnectControl_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__LCLS__ConnectControl_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__LCLS__ConnectControl_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl");
single_value->field_lCLS__Configuration.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl");
single_value->field_lCLS__ConnectionStatusControl.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControl");
}

boolean PDU__BSSMAP__LCLS__ConnectControl_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__LCLS__ConnectControl_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__LCLS__ConnectControlAck::PDU__BSSMAP__LCLS__ConnectControlAck()
{
}

PDU__BSSMAP__LCLS__ConnectControlAck::PDU__BSSMAP__LCLS__ConnectControlAck(const OCTETSTRING& par_messageType,
    const BSSMAP__IE__LCLS__BSS__Status& par_lCLS__BSS__Status)
  :   field_messageType(par_messageType),
  field_lCLS__BSS__Status(par_lCLS__BSS__Status)
{
}

PDU__BSSMAP__LCLS__ConnectControlAck::PDU__BSSMAP__LCLS__ConnectControlAck(const PDU__BSSMAP__LCLS__ConnectControlAck& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.lCLS__BSS__Status().is_bound()) field_lCLS__BSS__Status = other_value.lCLS__BSS__Status();
else field_lCLS__BSS__Status.clean_up();
}

void PDU__BSSMAP__LCLS__ConnectControlAck::clean_up()
{
field_messageType.clean_up();
field_lCLS__BSS__Status.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__LCLS__ConnectControlAck::get_descriptor() const { return &PDU__BSSMAP__LCLS__ConnectControlAck_descr_; }
PDU__BSSMAP__LCLS__ConnectControlAck& PDU__BSSMAP__LCLS__ConnectControlAck::operator=(const PDU__BSSMAP__LCLS__ConnectControlAck& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.lCLS__BSS__Status().is_bound()) field_lCLS__BSS__Status = other_value.lCLS__BSS__Status();
  else field_lCLS__BSS__Status.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__LCLS__ConnectControlAck::operator==(const PDU__BSSMAP__LCLS__ConnectControlAck& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_lCLS__BSS__Status==other_value.field_lCLS__BSS__Status;
}

boolean PDU__BSSMAP__LCLS__ConnectControlAck::is_bound() const
{
return (field_messageType.is_bound())
  || (field_lCLS__BSS__Status.is_bound());
}
boolean PDU__BSSMAP__LCLS__ConnectControlAck::is_value() const
{
return field_messageType.is_value()
  && field_lCLS__BSS__Status.is_value();
}
void PDU__BSSMAP__LCLS__ConnectControlAck::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", lCLS_BSS_Status := ");
field_lCLS__BSS__Status.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__LCLS__ConnectControlAck::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (lCLS__BSS__Status().is_bound()) lCLS__BSS__Status().set_implicit_omit();
}

void PDU__BSSMAP__LCLS__ConnectControlAck::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lCLS__BSS__Status().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lCLS_BSS_Status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lCLS__BSS__Status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck");
  }
}

void PDU__BSSMAP__LCLS__ConnectControlAck::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_lCLS__BSS__Status.encode_text(text_buf);
}

void PDU__BSSMAP__LCLS__ConnectControlAck::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_lCLS__BSS__Status.decode_text(text_buf);
}

void PDU__BSSMAP__LCLS__ConnectControlAck::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__LCLS__ConnectControlAck::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__LCLS__ConnectControlAck::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__LCLS__BSS__Status_descr_.raw->forceomit);
  decoded_field_length = field_lCLS__BSS__Status.RAW_decode(BSSMAP__IE__LCLS__BSS__Status_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (field_messageType !=  os_100) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__LCLS__ConnectControlAck::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__LCLS__BSS__Status_descr_.raw);
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_lCLS__BSS__Status.RAW_encode(BSSMAP__IE__LCLS__BSS__Status_descr_, *myleaf.body.node.nodes[1]);
  if (field_messageType !=  os_100) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_100.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__LCLS__ConnectControlAck_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__LCLS__BSS__Status_template field_lCLS__BSS__Status;
};

void PDU__BSSMAP__LCLS__ConnectControlAck_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_lCLS__BSS__Status = ANY_VALUE;
}
}
}

void PDU__BSSMAP__LCLS__ConnectControlAck_template::copy_value(const PDU__BSSMAP__LCLS__ConnectControlAck& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.lCLS__BSS__Status().is_bound()) {
  single_value->field_lCLS__BSS__Status = other_value.lCLS__BSS__Status();
} else {
  single_value->field_lCLS__BSS__Status.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__LCLS__ConnectControlAck_template::copy_template(const PDU__BSSMAP__LCLS__ConnectControlAck_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lCLS__BSS__Status().get_selection()) {
single_value->field_lCLS__BSS__Status = other_value.lCLS__BSS__Status();
} else {
single_value->field_lCLS__BSS__Status.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__LCLS__ConnectControlAck_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__LCLS__ConnectControlAck_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__LCLS__ConnectControlAck_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__LCLS__ConnectControlAck_template::PDU__BSSMAP__LCLS__ConnectControlAck_template()
{
}

PDU__BSSMAP__LCLS__ConnectControlAck_template::PDU__BSSMAP__LCLS__ConnectControlAck_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__LCLS__ConnectControlAck_template::PDU__BSSMAP__LCLS__ConnectControlAck_template(const PDU__BSSMAP__LCLS__ConnectControlAck& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__LCLS__ConnectControlAck_template::PDU__BSSMAP__LCLS__ConnectControlAck_template(const OPTIONAL<PDU__BSSMAP__LCLS__ConnectControlAck>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__LCLS__ConnectControlAck&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck from an unbound optional field.");
}
}

PDU__BSSMAP__LCLS__ConnectControlAck_template::PDU__BSSMAP__LCLS__ConnectControlAck_template(PDU__BSSMAP__LCLS__ConnectControlAck_template* p_precondition, PDU__BSSMAP__LCLS__ConnectControlAck_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__LCLS__ConnectControlAck_template::PDU__BSSMAP__LCLS__ConnectControlAck_template(Dynamic_Match_Interface<PDU__BSSMAP__LCLS__ConnectControlAck>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__LCLS__ConnectControlAck>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__LCLS__ConnectControlAck_template::PDU__BSSMAP__LCLS__ConnectControlAck_template(const PDU__BSSMAP__LCLS__ConnectControlAck_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__LCLS__ConnectControlAck_template::~PDU__BSSMAP__LCLS__ConnectControlAck_template()
{
clean_up();
}

PDU__BSSMAP__LCLS__ConnectControlAck_template& PDU__BSSMAP__LCLS__ConnectControlAck_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__LCLS__ConnectControlAck_template& PDU__BSSMAP__LCLS__ConnectControlAck_template::operator=(const PDU__BSSMAP__LCLS__ConnectControlAck& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__LCLS__ConnectControlAck_template& PDU__BSSMAP__LCLS__ConnectControlAck_template::operator=(const OPTIONAL<PDU__BSSMAP__LCLS__ConnectControlAck>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__LCLS__ConnectControlAck&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck.");
}
return *this;
}

PDU__BSSMAP__LCLS__ConnectControlAck_template& PDU__BSSMAP__LCLS__ConnectControlAck_template::operator=(const PDU__BSSMAP__LCLS__ConnectControlAck_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__LCLS__ConnectControlAck_template::match(const PDU__BSSMAP__LCLS__ConnectControlAck& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.lCLS__BSS__Status().is_bound()) return FALSE;
if(!single_value->field_lCLS__BSS__Status.match(other_value.lCLS__BSS__Status(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck.");
}
return FALSE;
}

boolean PDU__BSSMAP__LCLS__ConnectControlAck_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || single_value->field_lCLS__BSS__Status.is_bound();
}

boolean PDU__BSSMAP__LCLS__ConnectControlAck_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && single_value->field_lCLS__BSS__Status.is_value();
}

void PDU__BSSMAP__LCLS__ConnectControlAck_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__LCLS__ConnectControlAck PDU__BSSMAP__LCLS__ConnectControlAck_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck.");
PDU__BSSMAP__LCLS__ConnectControlAck ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_lCLS__BSS__Status.is_bound()) {
ret_val.lCLS__BSS__Status() = single_value->field_lCLS__BSS__Status.valueof();
}
return ret_val;
}

void PDU__BSSMAP__LCLS__ConnectControlAck_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__LCLS__ConnectControlAck_template[list_length];
}

PDU__BSSMAP__LCLS__ConnectControlAck_template& PDU__BSSMAP__LCLS__ConnectControlAck_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__LCLS__ConnectControlAck_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__LCLS__ConnectControlAck_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck.");
return single_value->field_messageType;
}

BSSMAP__IE__LCLS__BSS__Status_template& PDU__BSSMAP__LCLS__ConnectControlAck_template::lCLS__BSS__Status()
{
set_specific();
return single_value->field_lCLS__BSS__Status;
}

const BSSMAP__IE__LCLS__BSS__Status_template& PDU__BSSMAP__LCLS__ConnectControlAck_template::lCLS__BSS__Status() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lCLS_BSS_Status of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck.");
return single_value->field_lCLS__BSS__Status;
}

int PDU__BSSMAP__LCLS__ConnectControlAck_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck.");
  }
  return 0;
}

void PDU__BSSMAP__LCLS__ConnectControlAck_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", lCLS_BSS_Status := ");
single_value->field_lCLS__BSS__Status.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__LCLS__ConnectControlAck_template::log_match(const PDU__BSSMAP__LCLS__ConnectControlAck& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lCLS__BSS__Status.match(match_value.lCLS__BSS__Status(), legacy)){
TTCN_Logger::log_logmatch_info(".lCLS_BSS_Status");
single_value->field_lCLS__BSS__Status.log_match(match_value.lCLS__BSS__Status(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", lCLS_BSS_Status := ");
single_value->field_lCLS__BSS__Status.log_match(match_value.lCLS__BSS__Status(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__LCLS__ConnectControlAck_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (lCLS__BSS__Status().is_bound()) lCLS__BSS__Status().set_implicit_omit();
}

void PDU__BSSMAP__LCLS__ConnectControlAck_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_lCLS__BSS__Status.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck.");
}
}

void PDU__BSSMAP__LCLS__ConnectControlAck_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_lCLS__BSS__Status.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__LCLS__ConnectControlAck_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck.");
}
}

void PDU__BSSMAP__LCLS__ConnectControlAck_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__LCLS__ConnectControlAck_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lCLS__BSS__Status().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lCLS_BSS_Status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lCLS__BSS__Status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__LCLS__ConnectControlAck_template* precondition = new PDU__BSSMAP__LCLS__ConnectControlAck_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__LCLS__ConnectControlAck_template* implied_template = new PDU__BSSMAP__LCLS__ConnectControlAck_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__LCLS__ConnectControlAck_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__LCLS__ConnectControlAck_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck");
single_value->field_lCLS__BSS__Status.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_LCLS_ConnectControlAck");
}

boolean PDU__BSSMAP__LCLS__ConnectControlAck_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__LCLS__ConnectControlAck_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDU__BSSMAP__LCLS__Notification::PDU__BSSMAP__LCLS__Notification()
{
}

PDU__BSSMAP__LCLS__Notification::PDU__BSSMAP__LCLS__Notification(const OCTETSTRING& par_messageType,
    const OPTIONAL< BSSMAP__IE__LCLS__BSS__Status >& par_lCLS__BSS__Status,
    const OPTIONAL< BSSMAP__IE__LCLS__BreakRequest >& par_lCLS__BreakRequest)
  :   field_messageType(par_messageType),
  field_lCLS__BSS__Status(par_lCLS__BSS__Status),
  field_lCLS__BreakRequest(par_lCLS__BreakRequest)
{
}

PDU__BSSMAP__LCLS__Notification::PDU__BSSMAP__LCLS__Notification(const PDU__BSSMAP__LCLS__Notification& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification.");
if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
else field_messageType.clean_up();
if (other_value.lCLS__BSS__Status().is_bound()) field_lCLS__BSS__Status = other_value.lCLS__BSS__Status();
else field_lCLS__BSS__Status.clean_up();
if (other_value.lCLS__BreakRequest().is_bound()) field_lCLS__BreakRequest = other_value.lCLS__BreakRequest();
else field_lCLS__BreakRequest.clean_up();
}

void PDU__BSSMAP__LCLS__Notification::clean_up()
{
field_messageType.clean_up();
field_lCLS__BSS__Status.clean_up();
field_lCLS__BreakRequest.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSMAP__LCLS__Notification::get_descriptor() const { return &PDU__BSSMAP__LCLS__Notification_descr_; }
PDU__BSSMAP__LCLS__Notification& PDU__BSSMAP__LCLS__Notification::operator=(const PDU__BSSMAP__LCLS__Notification& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification.");
  if (other_value.messageType().is_bound()) field_messageType = other_value.messageType();
  else field_messageType.clean_up();
  if (other_value.lCLS__BSS__Status().is_bound()) field_lCLS__BSS__Status = other_value.lCLS__BSS__Status();
  else field_lCLS__BSS__Status.clean_up();
  if (other_value.lCLS__BreakRequest().is_bound()) field_lCLS__BreakRequest = other_value.lCLS__BreakRequest();
  else field_lCLS__BreakRequest.clean_up();
}
return *this;
}

boolean PDU__BSSMAP__LCLS__Notification::operator==(const PDU__BSSMAP__LCLS__Notification& other_value) const
{
return field_messageType==other_value.field_messageType
  && field_lCLS__BSS__Status==other_value.field_lCLS__BSS__Status
  && field_lCLS__BreakRequest==other_value.field_lCLS__BreakRequest;
}

boolean PDU__BSSMAP__LCLS__Notification::is_bound() const
{
return (field_messageType.is_bound())
  || (OPTIONAL_OMIT == field_lCLS__BSS__Status.get_selection() || field_lCLS__BSS__Status.is_bound())
  || (OPTIONAL_OMIT == field_lCLS__BreakRequest.get_selection() || field_lCLS__BreakRequest.is_bound());
}
boolean PDU__BSSMAP__LCLS__Notification::is_value() const
{
return field_messageType.is_value()
  && (OPTIONAL_OMIT == field_lCLS__BSS__Status.get_selection() || field_lCLS__BSS__Status.is_value())
  && (OPTIONAL_OMIT == field_lCLS__BreakRequest.get_selection() || field_lCLS__BreakRequest.is_value());
}
int PDU__BSSMAP__LCLS__Notification::size_of() const
{
  int ret_val = 1;
  if (field_lCLS__BSS__Status.ispresent()) ret_val++;
  if (field_lCLS__BreakRequest.ispresent()) ret_val++;
  return ret_val;
}

void PDU__BSSMAP__LCLS__Notification::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ messageType := ");
field_messageType.log();
TTCN_Logger::log_event_str(", lCLS_BSS_Status := ");
field_lCLS__BSS__Status.log();
TTCN_Logger::log_event_str(", lCLS_BreakRequest := ");
field_lCLS__BreakRequest.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSMAP__LCLS__Notification::set_implicit_omit()
{
if (messageType().is_bound()) messageType().set_implicit_omit();
if (!lCLS__BSS__Status().is_bound()) lCLS__BSS__Status() = OMIT_VALUE;
else lCLS__BSS__Status().set_implicit_omit();
if (!lCLS__BreakRequest().is_bound()) lCLS__BreakRequest() = OMIT_VALUE;
else lCLS__BreakRequest().set_implicit_omit();
}

void PDU__BSSMAP__LCLS__Notification::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lCLS__BSS__Status().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lCLS__BreakRequest().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lCLS_BSS_Status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lCLS__BSS__Status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lCLS_BreakRequest")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lCLS__BreakRequest().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSMAP_LCLS_Notification");
  }
}

void PDU__BSSMAP__LCLS__Notification::encode_text(Text_Buf& text_buf) const
{
field_messageType.encode_text(text_buf);
field_lCLS__BSS__Status.encode_text(text_buf);
field_lCLS__BreakRequest.encode_text(text_buf);
}

void PDU__BSSMAP__LCLS__Notification::decode_text(Text_Buf& text_buf)
{
field_messageType.decode_text(text_buf);
field_lCLS__BSS__Status.decode_text(text_buf);
field_lCLS__BreakRequest.decode_text(text_buf);
}

void PDU__BSSMAP__LCLS__Notification::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP__LCLS__Notification::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP__LCLS__Notification::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::OCT1_descr_.raw->forceomit);
  decoded_field_length = field_messageType.RAW_decode(General__Types::OCT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_lCLS__BSS__Status = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, BSSMAP__IE__LCLS__BSS__Status_descr_.raw->forceomit);
  decoded_field_length = field_lCLS__BSS__Status().RAW_decode(BSSMAP__IE__LCLS__BSS__Status_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_lCLS__BSS__Status = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_lCLS__BSS__Status=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_lCLS__BreakRequest = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, BSSMAP__IE__LCLS__BreakRequest_descr_.raw->forceomit);
  decoded_field_length = field_lCLS__BreakRequest().RAW_decode(BSSMAP__IE__LCLS__BreakRequest_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_lCLS__BreakRequest = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_lCLS__BreakRequest=OMIT_VALUE;
  if (field_messageType !=  os_102) return -1;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSMAP__LCLS__Notification::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::OCT1_descr_.raw);
  if (field_lCLS__BSS__Status.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, BSSMAP__IE__LCLS__BSS__Status_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  if (field_lCLS__BreakRequest.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, BSSMAP__IE__LCLS__BreakRequest_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  encoded_length += field_messageType.RAW_encode(General__Types::OCT1_descr_, *myleaf.body.node.nodes[0]);
  if (field_lCLS__BSS__Status.ispresent()) {
  encoded_length += field_lCLS__BSS__Status().RAW_encode(BSSMAP__IE__LCLS__BSS__Status_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_lCLS__BreakRequest.ispresent()) {
  encoded_length += field_lCLS__BreakRequest().RAW_encode(BSSMAP__IE__LCLS__BreakRequest_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_messageType !=  os_102) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   os_102.RAW_encode(General__Types::OCT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSMAP__LCLS__Notification_template::single_value_struct {
OCTETSTRING_template field_messageType;
BSSMAP__IE__LCLS__BSS__Status_template field_lCLS__BSS__Status;
BSSMAP__IE__LCLS__BreakRequest_template field_lCLS__BreakRequest;
};

void PDU__BSSMAP__LCLS__Notification_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_messageType = ANY_VALUE;
single_value->field_lCLS__BSS__Status = ANY_OR_OMIT;
single_value->field_lCLS__BreakRequest = ANY_OR_OMIT;
}
}
}

void PDU__BSSMAP__LCLS__Notification_template::copy_value(const PDU__BSSMAP__LCLS__Notification& other_value)
{
single_value = new single_value_struct;
if (other_value.messageType().is_bound()) {
  single_value->field_messageType = other_value.messageType();
} else {
  single_value->field_messageType.clean_up();
}
if (other_value.lCLS__BSS__Status().is_bound()) {
  if (other_value.lCLS__BSS__Status().ispresent()) single_value->field_lCLS__BSS__Status = other_value.lCLS__BSS__Status()();
  else single_value->field_lCLS__BSS__Status = OMIT_VALUE;
} else {
  single_value->field_lCLS__BSS__Status.clean_up();
}
if (other_value.lCLS__BreakRequest().is_bound()) {
  if (other_value.lCLS__BreakRequest().ispresent()) single_value->field_lCLS__BreakRequest = other_value.lCLS__BreakRequest()();
  else single_value->field_lCLS__BreakRequest = OMIT_VALUE;
} else {
  single_value->field_lCLS__BreakRequest.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP__LCLS__Notification_template::copy_template(const PDU__BSSMAP__LCLS__Notification_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.messageType().get_selection()) {
single_value->field_messageType = other_value.messageType();
} else {
single_value->field_messageType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lCLS__BSS__Status().get_selection()) {
single_value->field_lCLS__BSS__Status = other_value.lCLS__BSS__Status();
} else {
single_value->field_lCLS__BSS__Status.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lCLS__BreakRequest().get_selection()) {
single_value->field_lCLS__BreakRequest = other_value.lCLS__BreakRequest();
} else {
single_value->field_lCLS__BreakRequest.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP__LCLS__Notification_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP__LCLS__Notification_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP__LCLS__Notification_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification.");
break;
}
set_selection(other_value);
}

PDU__BSSMAP__LCLS__Notification_template::PDU__BSSMAP__LCLS__Notification_template()
{
}

PDU__BSSMAP__LCLS__Notification_template::PDU__BSSMAP__LCLS__Notification_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP__LCLS__Notification_template::PDU__BSSMAP__LCLS__Notification_template(const PDU__BSSMAP__LCLS__Notification& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP__LCLS__Notification_template::PDU__BSSMAP__LCLS__Notification_template(const OPTIONAL<PDU__BSSMAP__LCLS__Notification>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__LCLS__Notification&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification from an unbound optional field.");
}
}

PDU__BSSMAP__LCLS__Notification_template::PDU__BSSMAP__LCLS__Notification_template(PDU__BSSMAP__LCLS__Notification_template* p_precondition, PDU__BSSMAP__LCLS__Notification_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP__LCLS__Notification_template::PDU__BSSMAP__LCLS__Notification_template(Dynamic_Match_Interface<PDU__BSSMAP__LCLS__Notification>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP__LCLS__Notification>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP__LCLS__Notification_template::PDU__BSSMAP__LCLS__Notification_template(const PDU__BSSMAP__LCLS__Notification_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSMAP__LCLS__Notification_template::~PDU__BSSMAP__LCLS__Notification_template()
{
clean_up();
}

PDU__BSSMAP__LCLS__Notification_template& PDU__BSSMAP__LCLS__Notification_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP__LCLS__Notification_template& PDU__BSSMAP__LCLS__Notification_template::operator=(const PDU__BSSMAP__LCLS__Notification& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP__LCLS__Notification_template& PDU__BSSMAP__LCLS__Notification_template::operator=(const OPTIONAL<PDU__BSSMAP__LCLS__Notification>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP__LCLS__Notification&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification.");
}
return *this;
}

PDU__BSSMAP__LCLS__Notification_template& PDU__BSSMAP__LCLS__Notification_template::operator=(const PDU__BSSMAP__LCLS__Notification_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP__LCLS__Notification_template::match(const PDU__BSSMAP__LCLS__Notification& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.messageType().is_bound()) return FALSE;
if(!single_value->field_messageType.match(other_value.messageType(), legacy))return FALSE;
if(!other_value.lCLS__BSS__Status().is_bound()) return FALSE;
if((other_value.lCLS__BSS__Status().ispresent() ? !single_value->field_lCLS__BSS__Status.match((const BSSMAP__IE__LCLS__BSS__Status&)other_value.lCLS__BSS__Status(), legacy) : !single_value->field_lCLS__BSS__Status.match_omit(legacy)))return FALSE;
if(!other_value.lCLS__BreakRequest().is_bound()) return FALSE;
if((other_value.lCLS__BreakRequest().ispresent() ? !single_value->field_lCLS__BreakRequest.match((const BSSMAP__IE__LCLS__BreakRequest&)other_value.lCLS__BreakRequest(), legacy) : !single_value->field_lCLS__BreakRequest.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification.");
}
return FALSE;
}

boolean PDU__BSSMAP__LCLS__Notification_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_messageType.is_bound()
 || (single_value->field_lCLS__BSS__Status.is_omit() || single_value->field_lCLS__BSS__Status.is_bound())
 || (single_value->field_lCLS__BreakRequest.is_omit() || single_value->field_lCLS__BreakRequest.is_bound());
}

boolean PDU__BSSMAP__LCLS__Notification_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_messageType.is_value()
 && (single_value->field_lCLS__BSS__Status.is_omit() || single_value->field_lCLS__BSS__Status.is_value())
 && (single_value->field_lCLS__BreakRequest.is_omit() || single_value->field_lCLS__BreakRequest.is_value());
}

void PDU__BSSMAP__LCLS__Notification_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP__LCLS__Notification PDU__BSSMAP__LCLS__Notification_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification.");
PDU__BSSMAP__LCLS__Notification ret_val;
if (single_value->field_messageType.is_bound()) {
ret_val.messageType() = single_value->field_messageType.valueof();
}
if (single_value->field_lCLS__BSS__Status.is_omit()) ret_val.lCLS__BSS__Status() = OMIT_VALUE;
else if (single_value->field_lCLS__BSS__Status.is_bound()) {
ret_val.lCLS__BSS__Status() = single_value->field_lCLS__BSS__Status.valueof();
}
if (single_value->field_lCLS__BreakRequest.is_omit()) ret_val.lCLS__BreakRequest() = OMIT_VALUE;
else if (single_value->field_lCLS__BreakRequest.is_bound()) {
ret_val.lCLS__BreakRequest() = single_value->field_lCLS__BreakRequest.valueof();
}
return ret_val;
}

void PDU__BSSMAP__LCLS__Notification_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP__LCLS__Notification_template[list_length];
}

PDU__BSSMAP__LCLS__Notification_template& PDU__BSSMAP__LCLS__Notification_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDU__BSSMAP__LCLS__Notification_template::messageType()
{
set_specific();
return single_value->field_messageType;
}

const OCTETSTRING_template& PDU__BSSMAP__LCLS__Notification_template::messageType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field messageType of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification.");
return single_value->field_messageType;
}

BSSMAP__IE__LCLS__BSS__Status_template& PDU__BSSMAP__LCLS__Notification_template::lCLS__BSS__Status()
{
set_specific();
return single_value->field_lCLS__BSS__Status;
}

const BSSMAP__IE__LCLS__BSS__Status_template& PDU__BSSMAP__LCLS__Notification_template::lCLS__BSS__Status() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lCLS_BSS_Status of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification.");
return single_value->field_lCLS__BSS__Status;
}

BSSMAP__IE__LCLS__BreakRequest_template& PDU__BSSMAP__LCLS__Notification_template::lCLS__BreakRequest()
{
set_specific();
return single_value->field_lCLS__BreakRequest;
}

const BSSMAP__IE__LCLS__BreakRequest_template& PDU__BSSMAP__LCLS__Notification_template::lCLS__BreakRequest() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lCLS_BreakRequest of a non-specific template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification.");
return single_value->field_lCLS__BreakRequest;
}

int PDU__BSSMAP__LCLS__Notification_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_lCLS__BSS__Status.is_present()) ret_val++;
      if (single_value->field_lCLS__BreakRequest.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification.");
  }
  return 0;
}

void PDU__BSSMAP__LCLS__Notification_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log();
TTCN_Logger::log_event_str(", lCLS_BSS_Status := ");
single_value->field_lCLS__BSS__Status.log();
TTCN_Logger::log_event_str(", lCLS_BreakRequest := ");
single_value->field_lCLS__BreakRequest.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP__LCLS__Notification_template::log_match(const PDU__BSSMAP__LCLS__Notification& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_messageType.match(match_value.messageType(), legacy)){
TTCN_Logger::log_logmatch_info(".messageType");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.lCLS__BSS__Status().ispresent()){
if(!single_value->field_lCLS__BSS__Status.match(match_value.lCLS__BSS__Status(), legacy)){
TTCN_Logger::log_logmatch_info(".lCLS_BSS_Status");
single_value->field_lCLS__BSS__Status.log_match(match_value.lCLS__BSS__Status(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_lCLS__BSS__Status.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".lCLS_BSS_Status := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_lCLS__BSS__Status.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.lCLS__BreakRequest().ispresent()){
if(!single_value->field_lCLS__BreakRequest.match(match_value.lCLS__BreakRequest(), legacy)){
TTCN_Logger::log_logmatch_info(".lCLS_BreakRequest");
single_value->field_lCLS__BreakRequest.log_match(match_value.lCLS__BreakRequest(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_lCLS__BreakRequest.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".lCLS_BreakRequest := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_lCLS__BreakRequest.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ messageType := ");
single_value->field_messageType.log_match(match_value.messageType(), legacy);
TTCN_Logger::log_event_str(", lCLS_BSS_Status := ");
if (match_value.lCLS__BSS__Status().ispresent()) {
single_value->field_lCLS__BSS__Status.log_match(match_value.lCLS__BSS__Status(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_lCLS__BSS__Status.log();
if (single_value->field_lCLS__BSS__Status.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", lCLS_BreakRequest := ");
if (match_value.lCLS__BreakRequest().ispresent()) {
single_value->field_lCLS__BreakRequest.log_match(match_value.lCLS__BreakRequest(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_lCLS__BreakRequest.log();
if (single_value->field_lCLS__BreakRequest.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP__LCLS__Notification_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (messageType().is_bound()) messageType().set_implicit_omit();
if (!lCLS__BSS__Status().is_bound()) lCLS__BSS__Status() = OMIT_VALUE;
else lCLS__BSS__Status().set_implicit_omit();
if (!lCLS__BreakRequest().is_bound()) lCLS__BreakRequest() = OMIT_VALUE;
else lCLS__BreakRequest().set_implicit_omit();
}

void PDU__BSSMAP__LCLS__Notification_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_messageType.encode_text(text_buf);
single_value->field_lCLS__BSS__Status.encode_text(text_buf);
single_value->field_lCLS__BreakRequest.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification.");
}
}

void PDU__BSSMAP__LCLS__Notification_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_messageType.decode_text(text_buf);
single_value->field_lCLS__BSS__Status.decode_text(text_buf);
single_value->field_lCLS__BreakRequest.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP__LCLS__Notification_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification.");
}
}

void PDU__BSSMAP__LCLS__Notification_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP__LCLS__Notification_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) messageType().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) lCLS__BSS__Status().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) lCLS__BreakRequest().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "messageType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          messageType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lCLS_BSS_Status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lCLS__BSS__Status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lCLS_BreakRequest")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lCLS__BreakRequest().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSMAP_LCLS_Notification: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP__LCLS__Notification_template* precondition = new PDU__BSSMAP__LCLS__Notification_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSMAP__LCLS__Notification_template* implied_template = new PDU__BSSMAP__LCLS__Notification_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSMAP__LCLS__Notification_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSMAP_LCLS_Notification");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP__LCLS__Notification_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_messageType.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_LCLS_Notification");
single_value->field_lCLS__BSS__Status.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_LCLS_Notification");
single_value->field_lCLS__BreakRequest.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_LCLS_Notification");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP_LCLS_Notification");
}

boolean PDU__BSSMAP__LCLS__Notification_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP__LCLS__Notification_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void PDU__BSSMAP::copy_value(const PDU__BSSMAP& other_value)
{
switch (other_value.union_selection) {
case ALT_assignmentRequest:
field_assignmentRequest = new PDU__BSSMAP__AssignmentRequest(*other_value.field_assignmentRequest);
break;
case ALT_assignmentComplete:
field_assignmentComplete = new PDU__BSSMAP__AssignmentComplete(*other_value.field_assignmentComplete);
break;
case ALT_assignmentFailure:
field_assignmentFailure = new PDU__BSSMAP__AssignmentFailure(*other_value.field_assignmentFailure);
break;
case ALT_channelModifyRequest:
field_channelModifyRequest = new PDU__BSSMAP__ChannelModifyRequest(*other_value.field_channelModifyRequest);
break;
case ALT_block:
field_block = new PDU__BSSMAP__Block(*other_value.field_block);
break;
case ALT_blockingAck:
field_blockingAck = new PDU__BSSMAP__BlockingAck(*other_value.field_blockingAck);
break;
case ALT_bSSInvokeTrace:
field_bSSInvokeTrace = new PDU__BSSMAP__BSSInvokeTrace(*other_value.field_bSSInvokeTrace);
break;
case ALT_changeCircuit:
field_changeCircuit = new PDU__BSSMAP__ChangeCircuit(*other_value.field_changeCircuit);
break;
case ALT_changeCircuitAck:
field_changeCircuitAck = new PDU__BSSMAP__ChangeCircuitAck(*other_value.field_changeCircuitAck);
break;
case ALT_cipherModeCommand:
field_cipherModeCommand = new PDU__BSSMAP__CipherModeCommand(*other_value.field_cipherModeCommand);
break;
case ALT_cipherModeComplete:
field_cipherModeComplete = new PDU__BSSMAP__CipherModeComplete(*other_value.field_cipherModeComplete);
break;
case ALT_cipherModeReject:
field_cipherModeReject = new PDU__BSSMAP__CipherModeReject(*other_value.field_cipherModeReject);
break;
case ALT_circuitGroupBlock:
field_circuitGroupBlock = new PDU__BSSMAP__CircuitGroupBlock(*other_value.field_circuitGroupBlock);
break;
case ALT_circuitGroupBlockingAck:
field_circuitGroupBlockingAck = new PDU__BSSMAP__CircuitGroupBlockingAck(*other_value.field_circuitGroupBlockingAck);
break;
case ALT_circuitGroupUnblock:
field_circuitGroupUnblock = new PDU__BSSMAP__CircuitGroupUnblock(*other_value.field_circuitGroupUnblock);
break;
case ALT_circuitGroupUnblockAck:
field_circuitGroupUnblockAck = new PDU__BSSMAP__CircuitGroupUnblockAck(*other_value.field_circuitGroupUnblockAck);
break;
case ALT_classmarkRequest:
field_classmarkRequest = new PDU__BSSMAP__ClassmarkRequest(*other_value.field_classmarkRequest);
break;
case ALT_classmarkUpdate:
field_classmarkUpdate = new PDU__BSSMAP__ClassmarkUpdate(*other_value.field_classmarkUpdate);
break;
case ALT_clearCommand:
field_clearCommand = new PDU__BSSMAP__ClearCommand(*other_value.field_clearCommand);
break;
case ALT_clearComplete:
field_clearComplete = new PDU__BSSMAP__ClearComplete(*other_value.field_clearComplete);
break;
case ALT_clearRequest:
field_clearRequest = new PDU__BSSMAP__ClearRequest(*other_value.field_clearRequest);
break;
case ALT_commonID:
field_commonID = new PDU__BSSMAP__CommonID(*other_value.field_commonID);
break;
case ALT_completeLayer3Information:
field_completeLayer3Information = new PDU__BSSMAP__CompleteLayer3Information(*other_value.field_completeLayer3Information);
break;
case ALT_confusion:
field_confusion = new PDU__BSSMAP__Confusion(*other_value.field_confusion);
break;
case ALT_connectionlessInformation:
field_connectionlessInformation = new PDU__BSSMAP__ConnectionlessInformation(*other_value.field_connectionlessInformation);
break;
case ALT_handoverCandidateEnquire:
field_handoverCandidateEnquire = new PDU__BSSMAP__HandoverCandidateEnquire(*other_value.field_handoverCandidateEnquire);
break;
case ALT_handoverCandidateResponse:
field_handoverCandidateResponse = new PDU__BSSMAP__HandoverCandidateResponse(*other_value.field_handoverCandidateResponse);
break;
case ALT_handoverCommand:
field_handoverCommand = new PDU__BSSMAP__HandoverCommand(*other_value.field_handoverCommand);
break;
case ALT_handoverComplete:
field_handoverComplete = new PDU__BSSMAP__HandoverComplete(*other_value.field_handoverComplete);
break;
case ALT_handoverDetect:
field_handoverDetect = new PDU__BSSMAP__HandoverDetect(*other_value.field_handoverDetect);
break;
case ALT_handoverFailure:
field_handoverFailure = new PDU__BSSMAP__HandoverFailure(*other_value.field_handoverFailure);
break;
case ALT_handoverPerformed:
field_handoverPerformed = new PDU__BSSMAP__HandoverPerformed(*other_value.field_handoverPerformed);
break;
case ALT_handoverRequest:
field_handoverRequest = new PDU__BSSMAP__HandoverRequest(*other_value.field_handoverRequest);
break;
case ALT_handoverRequestAck:
field_handoverRequestAck = new PDU__BSSMAP__HandoverRequestAck(*other_value.field_handoverRequestAck);
break;
case ALT_handoverRequired:
field_handoverRequired = new PDU__BSSMAP__HandoverRequired(*other_value.field_handoverRequired);
break;
case ALT_handoverRequiredReject:
field_handoverRequiredReject = new PDU__BSSMAP__HandoverRequiredReject(*other_value.field_handoverRequiredReject);
break;
case ALT_handoverSucceeded:
field_handoverSucceeded = new PDU__BSSMAP__HandoverSucceeded(*other_value.field_handoverSucceeded);
break;
case ALT_loadIndication:
field_loadIndication = new PDU__BSSMAP__LoadIndication(*other_value.field_loadIndication);
break;
case ALT_lSAInformation:
field_lSAInformation = new PDU__BSSMAP__LSAInformation(*other_value.field_lSAInformation);
break;
case ALT_mSCInvokeTrace:
field_mSCInvokeTrace = new PDU__BSSMAP__MSCInvokeTrace(*other_value.field_mSCInvokeTrace);
break;
case ALT_overload:
field_overload = new PDU__BSSMAP__Overload(*other_value.field_overload);
break;
case ALT_paging:
field_paging = new PDU__BSSMAP__Paging(*other_value.field_paging);
break;
case ALT_performLocationAbort:
field_performLocationAbort = new PDU__BSSMAP__PerformLocationAbort(*other_value.field_performLocationAbort);
break;
case ALT_performLocationRequest:
field_performLocationRequest = new PDU__BSSMAP__PerformLocationRequest(*other_value.field_performLocationRequest);
break;
case ALT_performLocationResponse:
field_performLocationResponse = new PDU__BSSMAP__PerformLocationResponse(*other_value.field_performLocationResponse);
break;
case ALT_queueingIndication:
field_queueingIndication = new PDU__BSSMAP__QueueingIndication(*other_value.field_queueingIndication);
break;
case ALT_reset:
field_reset = new PDU__BSSMAP__Reset(*other_value.field_reset);
break;
case ALT_resetAck:
field_resetAck = new PDU__BSSMAP__ResetAck(*other_value.field_resetAck);
break;
case ALT_resetCircuit:
field_resetCircuit = new PDU__BSSMAP__ResetCircuit(*other_value.field_resetCircuit);
break;
case ALT_resetCircuitAck:
field_resetCircuitAck = new PDU__BSSMAP__ResetCircuitAck(*other_value.field_resetCircuitAck);
break;
case ALT_resourceIndication:
field_resourceIndication = new PDU__BSSMAP__ResourceIndication(*other_value.field_resourceIndication);
break;
case ALT_resourceRequest:
field_resourceRequest = new PDU__BSSMAP__ResourceRequest(*other_value.field_resourceRequest);
break;
case ALT_sAPInReject:
field_sAPInReject = new PDU__BSSMAP__SAPInReject(*other_value.field_sAPInReject);
break;
case ALT_suspend:
field_suspend = new PDU__BSSMAP__Suspend(*other_value.field_suspend);
break;
case ALT_resume:
field_resume = new PDU__BSSMAP__Resume(*other_value.field_resume);
break;
case ALT_unblock:
field_unblock = new PDU__BSSMAP__Unblock(*other_value.field_unblock);
break;
case ALT_unblockAck:
field_unblockAck = new PDU__BSSMAP__UnblockAck(*other_value.field_unblockAck);
break;
case ALT_unequippedCircuit:
field_unequippedCircuit = new PDU__BSSMAP__UnequippedCircuit(*other_value.field_unequippedCircuit);
break;
case ALT_uplinkRequest:
field_uplinkRequest = new PDU__BSSMAP__UplinkRequest(*other_value.field_uplinkRequest);
break;
case ALT_uplinkRequestAck:
field_uplinkRequestAck = new PDU__BSSMAP__UplinkRequestAck(*other_value.field_uplinkRequestAck);
break;
case ALT_uplinkRequestConfirmation:
field_uplinkRequestConfirmation = new PDU__BSSMAP__UplinkRequestConfirmation(*other_value.field_uplinkRequestConfirmation);
break;
case ALT_uplinkReleaseIndication:
field_uplinkReleaseIndication = new PDU__BSSMAP__UplinkReleaseIndication(*other_value.field_uplinkReleaseIndication);
break;
case ALT_uplinkRejectCommand:
field_uplinkRejectCommand = new PDU__BSSMAP__UplinkRejectCommand(*other_value.field_uplinkRejectCommand);
break;
case ALT_uplinkReleaseCommand:
field_uplinkReleaseCommand = new PDU__BSSMAP__UplinkReleaseCommand(*other_value.field_uplinkReleaseCommand);
break;
case ALT_uplinkSeizedCommand:
field_uplinkSeizedCommand = new PDU__BSSMAP__UplinkSeizedCommand(*other_value.field_uplinkSeizedCommand);
break;
case ALT_vGCS__VBSSetup:
field_vGCS__VBSSetup = new PDU__BSSMAP__VGCS__VBSSetup(*other_value.field_vGCS__VBSSetup);
break;
case ALT_vGCS__VBSSetupAck:
field_vGCS__VBSSetupAck = new PDU__BSSMAP__VGCS__VBSSetupAck(*other_value.field_vGCS__VBSSetupAck);
break;
case ALT_vGCS__VBSSetupRefuse:
field_vGCS__VBSSetupRefuse = new PDU__BSSMAP__VGCS__VBSSetupRefuse(*other_value.field_vGCS__VBSSetupRefuse);
break;
case ALT_vGCS__VBSAssignmentRequest:
field_vGCS__VBSAssignmentRequest = new PDU__BSSMAP__VGCS__VBSAssignmentRequest(*other_value.field_vGCS__VBSAssignmentRequest);
break;
case ALT_vGCS__VBSAssignmentResult:
field_vGCS__VBSAssignmentResult = new PDU__BSSMAP__VGCS__VBSAssignmentResult(*other_value.field_vGCS__VBSAssignmentResult);
break;
case ALT_vGCS__VBSAssignmentFailure:
field_vGCS__VBSAssignmentFailure = new PDU__BSSMAP__VGCS__VBSAssignmentFailure(*other_value.field_vGCS__VBSAssignmentFailure);
break;
case ALT_vGCS__VBSQueuingIndication:
field_vGCS__VBSQueuingIndication = new PDU__BSSMAP__VGCS__VBSQueuingIndication(*other_value.field_vGCS__VBSQueuingIndication);
break;
case ALT_vGCS__AdditionalInformation:
field_vGCS__AdditionalInformation = new PDU__BSSMAP__VGCS__AdditionalInformation(*other_value.field_vGCS__AdditionalInformation);
break;
case ALT_vGCS__VBS__AreaCellInfo:
field_vGCS__VBS__AreaCellInfo = new PDU__BSSMAP__VGCS__VBS__AreaCellInfo(*other_value.field_vGCS__VBS__AreaCellInfo);
break;
case ALT_vGCS__VBS__AssignmentStatus:
field_vGCS__VBS__AssignmentStatus = new PDU__BSSMAP__VGCS__VBS__AssignmentStatus(*other_value.field_vGCS__VBS__AssignmentStatus);
break;
case ALT_vGCS__SMS:
field_vGCS__SMS = new PDU__BSSMAP__VGCS__SMS(*other_value.field_vGCS__SMS);
break;
case ALT_uplinkApplicationData:
field_uplinkApplicationData = new PDU__BSSMAP__UplinkApplicationData(*other_value.field_uplinkApplicationData);
break;
case ALT_notificationData:
field_notificationData = new PDU__BSSMAP__NotificationData(*other_value.field_notificationData);
break;
case ALT_internalHandoverRequired:
field_internalHandoverRequired = new PDU__BSSMAP__InternalHandoverRequired(*other_value.field_internalHandoverRequired);
break;
case ALT_internalHandoverRequiredReject:
field_internalHandoverRequiredReject = new PDU__BSSMAP__InternalHandoverRequiredReject(*other_value.field_internalHandoverRequiredReject);
break;
case ALT_internalHandoverCommand:
field_internalHandoverCommand = new PDU__BSSMAP__InternalHandoverCommand(*other_value.field_internalHandoverCommand);
break;
case ALT_internalHandoverEnquiry:
field_internalHandoverEnquiry = new PDU__BSSMAP__InternalHandoverEnquiry(*other_value.field_internalHandoverEnquiry);
break;
case ALT_resetIPResource:
field_resetIPResource = new PDU__BSSMAP__ResetIPResource(*other_value.field_resetIPResource);
break;
case ALT_resetIPResourceAck:
field_resetIPResourceAck = new PDU__BSSMAP__ResetIPResourceAck(*other_value.field_resetIPResourceAck);
break;
case ALT_rerouteCommand:
field_rerouteCommand = new PDU__BSSMAP__RerouteCommand(*other_value.field_rerouteCommand);
break;
case ALT_rerouteComplete:
field_rerouteComplete = new PDU__BSSMAP__RerouteComplete(*other_value.field_rerouteComplete);
break;
case ALT_lCLS__ConnectControl:
field_lCLS__ConnectControl = new PDU__BSSMAP__LCLS__ConnectControl(*other_value.field_lCLS__ConnectControl);
break;
case ALT_lCLS__connectControlAck:
field_lCLS__connectControlAck = new PDU__BSSMAP__LCLS__ConnectControlAck(*other_value.field_lCLS__connectControlAck);
break;
case ALT_lCLS__Notification:
field_lCLS__Notification = new PDU__BSSMAP__LCLS__Notification(*other_value.field_lCLS__Notification);
break;
default:
TTCN_error("Assignment of an unbound union value of type @BSSAP_Types.PDU_BSSMAP.");
}
union_selection = other_value.union_selection;
}

PDU__BSSMAP::PDU__BSSMAP()
{
union_selection = UNBOUND_VALUE;
}

PDU__BSSMAP::PDU__BSSMAP(const PDU__BSSMAP& other_value)
: Base_Type(){
copy_value(other_value);
}

PDU__BSSMAP::~PDU__BSSMAP()
{
clean_up();
}

PDU__BSSMAP& PDU__BSSMAP::operator=(const PDU__BSSMAP& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean PDU__BSSMAP::operator==(const PDU__BSSMAP& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @BSSAP_Types.PDU_BSSMAP.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @BSSAP_Types.PDU_BSSMAP.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_assignmentRequest:
return *field_assignmentRequest == *other_value.field_assignmentRequest;
case ALT_assignmentComplete:
return *field_assignmentComplete == *other_value.field_assignmentComplete;
case ALT_assignmentFailure:
return *field_assignmentFailure == *other_value.field_assignmentFailure;
case ALT_channelModifyRequest:
return *field_channelModifyRequest == *other_value.field_channelModifyRequest;
case ALT_block:
return *field_block == *other_value.field_block;
case ALT_blockingAck:
return *field_blockingAck == *other_value.field_blockingAck;
case ALT_bSSInvokeTrace:
return *field_bSSInvokeTrace == *other_value.field_bSSInvokeTrace;
case ALT_changeCircuit:
return *field_changeCircuit == *other_value.field_changeCircuit;
case ALT_changeCircuitAck:
return *field_changeCircuitAck == *other_value.field_changeCircuitAck;
case ALT_cipherModeCommand:
return *field_cipherModeCommand == *other_value.field_cipherModeCommand;
case ALT_cipherModeComplete:
return *field_cipherModeComplete == *other_value.field_cipherModeComplete;
case ALT_cipherModeReject:
return *field_cipherModeReject == *other_value.field_cipherModeReject;
case ALT_circuitGroupBlock:
return *field_circuitGroupBlock == *other_value.field_circuitGroupBlock;
case ALT_circuitGroupBlockingAck:
return *field_circuitGroupBlockingAck == *other_value.field_circuitGroupBlockingAck;
case ALT_circuitGroupUnblock:
return *field_circuitGroupUnblock == *other_value.field_circuitGroupUnblock;
case ALT_circuitGroupUnblockAck:
return *field_circuitGroupUnblockAck == *other_value.field_circuitGroupUnblockAck;
case ALT_classmarkRequest:
return *field_classmarkRequest == *other_value.field_classmarkRequest;
case ALT_classmarkUpdate:
return *field_classmarkUpdate == *other_value.field_classmarkUpdate;
case ALT_clearCommand:
return *field_clearCommand == *other_value.field_clearCommand;
case ALT_clearComplete:
return *field_clearComplete == *other_value.field_clearComplete;
case ALT_clearRequest:
return *field_clearRequest == *other_value.field_clearRequest;
case ALT_commonID:
return *field_commonID == *other_value.field_commonID;
case ALT_completeLayer3Information:
return *field_completeLayer3Information == *other_value.field_completeLayer3Information;
case ALT_confusion:
return *field_confusion == *other_value.field_confusion;
case ALT_connectionlessInformation:
return *field_connectionlessInformation == *other_value.field_connectionlessInformation;
case ALT_handoverCandidateEnquire:
return *field_handoverCandidateEnquire == *other_value.field_handoverCandidateEnquire;
case ALT_handoverCandidateResponse:
return *field_handoverCandidateResponse == *other_value.field_handoverCandidateResponse;
case ALT_handoverCommand:
return *field_handoverCommand == *other_value.field_handoverCommand;
case ALT_handoverComplete:
return *field_handoverComplete == *other_value.field_handoverComplete;
case ALT_handoverDetect:
return *field_handoverDetect == *other_value.field_handoverDetect;
case ALT_handoverFailure:
return *field_handoverFailure == *other_value.field_handoverFailure;
case ALT_handoverPerformed:
return *field_handoverPerformed == *other_value.field_handoverPerformed;
case ALT_handoverRequest:
return *field_handoverRequest == *other_value.field_handoverRequest;
case ALT_handoverRequestAck:
return *field_handoverRequestAck == *other_value.field_handoverRequestAck;
case ALT_handoverRequired:
return *field_handoverRequired == *other_value.field_handoverRequired;
case ALT_handoverRequiredReject:
return *field_handoverRequiredReject == *other_value.field_handoverRequiredReject;
case ALT_handoverSucceeded:
return *field_handoverSucceeded == *other_value.field_handoverSucceeded;
case ALT_loadIndication:
return *field_loadIndication == *other_value.field_loadIndication;
case ALT_lSAInformation:
return *field_lSAInformation == *other_value.field_lSAInformation;
case ALT_mSCInvokeTrace:
return *field_mSCInvokeTrace == *other_value.field_mSCInvokeTrace;
case ALT_overload:
return *field_overload == *other_value.field_overload;
case ALT_paging:
return *field_paging == *other_value.field_paging;
case ALT_performLocationAbort:
return *field_performLocationAbort == *other_value.field_performLocationAbort;
case ALT_performLocationRequest:
return *field_performLocationRequest == *other_value.field_performLocationRequest;
case ALT_performLocationResponse:
return *field_performLocationResponse == *other_value.field_performLocationResponse;
case ALT_queueingIndication:
return *field_queueingIndication == *other_value.field_queueingIndication;
case ALT_reset:
return *field_reset == *other_value.field_reset;
case ALT_resetAck:
return *field_resetAck == *other_value.field_resetAck;
case ALT_resetCircuit:
return *field_resetCircuit == *other_value.field_resetCircuit;
case ALT_resetCircuitAck:
return *field_resetCircuitAck == *other_value.field_resetCircuitAck;
case ALT_resourceIndication:
return *field_resourceIndication == *other_value.field_resourceIndication;
case ALT_resourceRequest:
return *field_resourceRequest == *other_value.field_resourceRequest;
case ALT_sAPInReject:
return *field_sAPInReject == *other_value.field_sAPInReject;
case ALT_suspend:
return *field_suspend == *other_value.field_suspend;
case ALT_resume:
return *field_resume == *other_value.field_resume;
case ALT_unblock:
return *field_unblock == *other_value.field_unblock;
case ALT_unblockAck:
return *field_unblockAck == *other_value.field_unblockAck;
case ALT_unequippedCircuit:
return *field_unequippedCircuit == *other_value.field_unequippedCircuit;
case ALT_uplinkRequest:
return *field_uplinkRequest == *other_value.field_uplinkRequest;
case ALT_uplinkRequestAck:
return *field_uplinkRequestAck == *other_value.field_uplinkRequestAck;
case ALT_uplinkRequestConfirmation:
return *field_uplinkRequestConfirmation == *other_value.field_uplinkRequestConfirmation;
case ALT_uplinkReleaseIndication:
return *field_uplinkReleaseIndication == *other_value.field_uplinkReleaseIndication;
case ALT_uplinkRejectCommand:
return *field_uplinkRejectCommand == *other_value.field_uplinkRejectCommand;
case ALT_uplinkReleaseCommand:
return *field_uplinkReleaseCommand == *other_value.field_uplinkReleaseCommand;
case ALT_uplinkSeizedCommand:
return *field_uplinkSeizedCommand == *other_value.field_uplinkSeizedCommand;
case ALT_vGCS__VBSSetup:
return *field_vGCS__VBSSetup == *other_value.field_vGCS__VBSSetup;
case ALT_vGCS__VBSSetupAck:
return *field_vGCS__VBSSetupAck == *other_value.field_vGCS__VBSSetupAck;
case ALT_vGCS__VBSSetupRefuse:
return *field_vGCS__VBSSetupRefuse == *other_value.field_vGCS__VBSSetupRefuse;
case ALT_vGCS__VBSAssignmentRequest:
return *field_vGCS__VBSAssignmentRequest == *other_value.field_vGCS__VBSAssignmentRequest;
case ALT_vGCS__VBSAssignmentResult:
return *field_vGCS__VBSAssignmentResult == *other_value.field_vGCS__VBSAssignmentResult;
case ALT_vGCS__VBSAssignmentFailure:
return *field_vGCS__VBSAssignmentFailure == *other_value.field_vGCS__VBSAssignmentFailure;
case ALT_vGCS__VBSQueuingIndication:
return *field_vGCS__VBSQueuingIndication == *other_value.field_vGCS__VBSQueuingIndication;
case ALT_vGCS__AdditionalInformation:
return *field_vGCS__AdditionalInformation == *other_value.field_vGCS__AdditionalInformation;
case ALT_vGCS__VBS__AreaCellInfo:
return *field_vGCS__VBS__AreaCellInfo == *other_value.field_vGCS__VBS__AreaCellInfo;
case ALT_vGCS__VBS__AssignmentStatus:
return *field_vGCS__VBS__AssignmentStatus == *other_value.field_vGCS__VBS__AssignmentStatus;
case ALT_vGCS__SMS:
return *field_vGCS__SMS == *other_value.field_vGCS__SMS;
case ALT_uplinkApplicationData:
return *field_uplinkApplicationData == *other_value.field_uplinkApplicationData;
case ALT_notificationData:
return *field_notificationData == *other_value.field_notificationData;
case ALT_internalHandoverRequired:
return *field_internalHandoverRequired == *other_value.field_internalHandoverRequired;
case ALT_internalHandoverRequiredReject:
return *field_internalHandoverRequiredReject == *other_value.field_internalHandoverRequiredReject;
case ALT_internalHandoverCommand:
return *field_internalHandoverCommand == *other_value.field_internalHandoverCommand;
case ALT_internalHandoverEnquiry:
return *field_internalHandoverEnquiry == *other_value.field_internalHandoverEnquiry;
case ALT_resetIPResource:
return *field_resetIPResource == *other_value.field_resetIPResource;
case ALT_resetIPResourceAck:
return *field_resetIPResourceAck == *other_value.field_resetIPResourceAck;
case ALT_rerouteCommand:
return *field_rerouteCommand == *other_value.field_rerouteCommand;
case ALT_rerouteComplete:
return *field_rerouteComplete == *other_value.field_rerouteComplete;
case ALT_lCLS__ConnectControl:
return *field_lCLS__ConnectControl == *other_value.field_lCLS__ConnectControl;
case ALT_lCLS__connectControlAck:
return *field_lCLS__connectControlAck == *other_value.field_lCLS__connectControlAck;
case ALT_lCLS__Notification:
return *field_lCLS__Notification == *other_value.field_lCLS__Notification;
default:
return FALSE;
}
}

PDU__BSSMAP__AssignmentRequest& PDU__BSSMAP::assignmentRequest()
{
if (union_selection != ALT_assignmentRequest) {
clean_up();
field_assignmentRequest = new PDU__BSSMAP__AssignmentRequest;
union_selection = ALT_assignmentRequest;
}
return *field_assignmentRequest;
}

const PDU__BSSMAP__AssignmentRequest& PDU__BSSMAP::assignmentRequest() const
{
if (union_selection != ALT_assignmentRequest) TTCN_error("Using non-selected field assignmentRequest in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_assignmentRequest;
}

PDU__BSSMAP__AssignmentComplete& PDU__BSSMAP::assignmentComplete()
{
if (union_selection != ALT_assignmentComplete) {
clean_up();
field_assignmentComplete = new PDU__BSSMAP__AssignmentComplete;
union_selection = ALT_assignmentComplete;
}
return *field_assignmentComplete;
}

const PDU__BSSMAP__AssignmentComplete& PDU__BSSMAP::assignmentComplete() const
{
if (union_selection != ALT_assignmentComplete) TTCN_error("Using non-selected field assignmentComplete in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_assignmentComplete;
}

PDU__BSSMAP__AssignmentFailure& PDU__BSSMAP::assignmentFailure()
{
if (union_selection != ALT_assignmentFailure) {
clean_up();
field_assignmentFailure = new PDU__BSSMAP__AssignmentFailure;
union_selection = ALT_assignmentFailure;
}
return *field_assignmentFailure;
}

const PDU__BSSMAP__AssignmentFailure& PDU__BSSMAP::assignmentFailure() const
{
if (union_selection != ALT_assignmentFailure) TTCN_error("Using non-selected field assignmentFailure in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_assignmentFailure;
}

PDU__BSSMAP__ChannelModifyRequest& PDU__BSSMAP::channelModifyRequest()
{
if (union_selection != ALT_channelModifyRequest) {
clean_up();
field_channelModifyRequest = new PDU__BSSMAP__ChannelModifyRequest;
union_selection = ALT_channelModifyRequest;
}
return *field_channelModifyRequest;
}

const PDU__BSSMAP__ChannelModifyRequest& PDU__BSSMAP::channelModifyRequest() const
{
if (union_selection != ALT_channelModifyRequest) TTCN_error("Using non-selected field channelModifyRequest in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_channelModifyRequest;
}

PDU__BSSMAP__Block& PDU__BSSMAP::block()
{
if (union_selection != ALT_block) {
clean_up();
field_block = new PDU__BSSMAP__Block;
union_selection = ALT_block;
}
return *field_block;
}

const PDU__BSSMAP__Block& PDU__BSSMAP::block() const
{
if (union_selection != ALT_block) TTCN_error("Using non-selected field block in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_block;
}

PDU__BSSMAP__BlockingAck& PDU__BSSMAP::blockingAck()
{
if (union_selection != ALT_blockingAck) {
clean_up();
field_blockingAck = new PDU__BSSMAP__BlockingAck;
union_selection = ALT_blockingAck;
}
return *field_blockingAck;
}

const PDU__BSSMAP__BlockingAck& PDU__BSSMAP::blockingAck() const
{
if (union_selection != ALT_blockingAck) TTCN_error("Using non-selected field blockingAck in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_blockingAck;
}

PDU__BSSMAP__BSSInvokeTrace& PDU__BSSMAP::bSSInvokeTrace()
{
if (union_selection != ALT_bSSInvokeTrace) {
clean_up();
field_bSSInvokeTrace = new PDU__BSSMAP__BSSInvokeTrace;
union_selection = ALT_bSSInvokeTrace;
}
return *field_bSSInvokeTrace;
}

const PDU__BSSMAP__BSSInvokeTrace& PDU__BSSMAP::bSSInvokeTrace() const
{
if (union_selection != ALT_bSSInvokeTrace) TTCN_error("Using non-selected field bSSInvokeTrace in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_bSSInvokeTrace;
}

PDU__BSSMAP__ChangeCircuit& PDU__BSSMAP::changeCircuit()
{
if (union_selection != ALT_changeCircuit) {
clean_up();
field_changeCircuit = new PDU__BSSMAP__ChangeCircuit;
union_selection = ALT_changeCircuit;
}
return *field_changeCircuit;
}

const PDU__BSSMAP__ChangeCircuit& PDU__BSSMAP::changeCircuit() const
{
if (union_selection != ALT_changeCircuit) TTCN_error("Using non-selected field changeCircuit in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_changeCircuit;
}

PDU__BSSMAP__ChangeCircuitAck& PDU__BSSMAP::changeCircuitAck()
{
if (union_selection != ALT_changeCircuitAck) {
clean_up();
field_changeCircuitAck = new PDU__BSSMAP__ChangeCircuitAck;
union_selection = ALT_changeCircuitAck;
}
return *field_changeCircuitAck;
}

const PDU__BSSMAP__ChangeCircuitAck& PDU__BSSMAP::changeCircuitAck() const
{
if (union_selection != ALT_changeCircuitAck) TTCN_error("Using non-selected field changeCircuitAck in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_changeCircuitAck;
}

PDU__BSSMAP__CipherModeCommand& PDU__BSSMAP::cipherModeCommand()
{
if (union_selection != ALT_cipherModeCommand) {
clean_up();
field_cipherModeCommand = new PDU__BSSMAP__CipherModeCommand;
union_selection = ALT_cipherModeCommand;
}
return *field_cipherModeCommand;
}

const PDU__BSSMAP__CipherModeCommand& PDU__BSSMAP::cipherModeCommand() const
{
if (union_selection != ALT_cipherModeCommand) TTCN_error("Using non-selected field cipherModeCommand in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_cipherModeCommand;
}

PDU__BSSMAP__CipherModeComplete& PDU__BSSMAP::cipherModeComplete()
{
if (union_selection != ALT_cipherModeComplete) {
clean_up();
field_cipherModeComplete = new PDU__BSSMAP__CipherModeComplete;
union_selection = ALT_cipherModeComplete;
}
return *field_cipherModeComplete;
}

const PDU__BSSMAP__CipherModeComplete& PDU__BSSMAP::cipherModeComplete() const
{
if (union_selection != ALT_cipherModeComplete) TTCN_error("Using non-selected field cipherModeComplete in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_cipherModeComplete;
}

PDU__BSSMAP__CipherModeReject& PDU__BSSMAP::cipherModeReject()
{
if (union_selection != ALT_cipherModeReject) {
clean_up();
field_cipherModeReject = new PDU__BSSMAP__CipherModeReject;
union_selection = ALT_cipherModeReject;
}
return *field_cipherModeReject;
}

const PDU__BSSMAP__CipherModeReject& PDU__BSSMAP::cipherModeReject() const
{
if (union_selection != ALT_cipherModeReject) TTCN_error("Using non-selected field cipherModeReject in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_cipherModeReject;
}

PDU__BSSMAP__CircuitGroupBlock& PDU__BSSMAP::circuitGroupBlock()
{
if (union_selection != ALT_circuitGroupBlock) {
clean_up();
field_circuitGroupBlock = new PDU__BSSMAP__CircuitGroupBlock;
union_selection = ALT_circuitGroupBlock;
}
return *field_circuitGroupBlock;
}

const PDU__BSSMAP__CircuitGroupBlock& PDU__BSSMAP::circuitGroupBlock() const
{
if (union_selection != ALT_circuitGroupBlock) TTCN_error("Using non-selected field circuitGroupBlock in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_circuitGroupBlock;
}

PDU__BSSMAP__CircuitGroupBlockingAck& PDU__BSSMAP::circuitGroupBlockingAck()
{
if (union_selection != ALT_circuitGroupBlockingAck) {
clean_up();
field_circuitGroupBlockingAck = new PDU__BSSMAP__CircuitGroupBlockingAck;
union_selection = ALT_circuitGroupBlockingAck;
}
return *field_circuitGroupBlockingAck;
}

const PDU__BSSMAP__CircuitGroupBlockingAck& PDU__BSSMAP::circuitGroupBlockingAck() const
{
if (union_selection != ALT_circuitGroupBlockingAck) TTCN_error("Using non-selected field circuitGroupBlockingAck in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_circuitGroupBlockingAck;
}

PDU__BSSMAP__CircuitGroupUnblock& PDU__BSSMAP::circuitGroupUnblock()
{
if (union_selection != ALT_circuitGroupUnblock) {
clean_up();
field_circuitGroupUnblock = new PDU__BSSMAP__CircuitGroupUnblock;
union_selection = ALT_circuitGroupUnblock;
}
return *field_circuitGroupUnblock;
}

const PDU__BSSMAP__CircuitGroupUnblock& PDU__BSSMAP::circuitGroupUnblock() const
{
if (union_selection != ALT_circuitGroupUnblock) TTCN_error("Using non-selected field circuitGroupUnblock in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_circuitGroupUnblock;
}

PDU__BSSMAP__CircuitGroupUnblockAck& PDU__BSSMAP::circuitGroupUnblockAck()
{
if (union_selection != ALT_circuitGroupUnblockAck) {
clean_up();
field_circuitGroupUnblockAck = new PDU__BSSMAP__CircuitGroupUnblockAck;
union_selection = ALT_circuitGroupUnblockAck;
}
return *field_circuitGroupUnblockAck;
}

const PDU__BSSMAP__CircuitGroupUnblockAck& PDU__BSSMAP::circuitGroupUnblockAck() const
{
if (union_selection != ALT_circuitGroupUnblockAck) TTCN_error("Using non-selected field circuitGroupUnblockAck in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_circuitGroupUnblockAck;
}

PDU__BSSMAP__ClassmarkRequest& PDU__BSSMAP::classmarkRequest()
{
if (union_selection != ALT_classmarkRequest) {
clean_up();
field_classmarkRequest = new PDU__BSSMAP__ClassmarkRequest;
union_selection = ALT_classmarkRequest;
}
return *field_classmarkRequest;
}

const PDU__BSSMAP__ClassmarkRequest& PDU__BSSMAP::classmarkRequest() const
{
if (union_selection != ALT_classmarkRequest) TTCN_error("Using non-selected field classmarkRequest in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_classmarkRequest;
}

PDU__BSSMAP__ClassmarkUpdate& PDU__BSSMAP::classmarkUpdate()
{
if (union_selection != ALT_classmarkUpdate) {
clean_up();
field_classmarkUpdate = new PDU__BSSMAP__ClassmarkUpdate;
union_selection = ALT_classmarkUpdate;
}
return *field_classmarkUpdate;
}

const PDU__BSSMAP__ClassmarkUpdate& PDU__BSSMAP::classmarkUpdate() const
{
if (union_selection != ALT_classmarkUpdate) TTCN_error("Using non-selected field classmarkUpdate in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_classmarkUpdate;
}

PDU__BSSMAP__ClearCommand& PDU__BSSMAP::clearCommand()
{
if (union_selection != ALT_clearCommand) {
clean_up();
field_clearCommand = new PDU__BSSMAP__ClearCommand;
union_selection = ALT_clearCommand;
}
return *field_clearCommand;
}

const PDU__BSSMAP__ClearCommand& PDU__BSSMAP::clearCommand() const
{
if (union_selection != ALT_clearCommand) TTCN_error("Using non-selected field clearCommand in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_clearCommand;
}

PDU__BSSMAP__ClearComplete& PDU__BSSMAP::clearComplete()
{
if (union_selection != ALT_clearComplete) {
clean_up();
field_clearComplete = new PDU__BSSMAP__ClearComplete;
union_selection = ALT_clearComplete;
}
return *field_clearComplete;
}

const PDU__BSSMAP__ClearComplete& PDU__BSSMAP::clearComplete() const
{
if (union_selection != ALT_clearComplete) TTCN_error("Using non-selected field clearComplete in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_clearComplete;
}

PDU__BSSMAP__ClearRequest& PDU__BSSMAP::clearRequest()
{
if (union_selection != ALT_clearRequest) {
clean_up();
field_clearRequest = new PDU__BSSMAP__ClearRequest;
union_selection = ALT_clearRequest;
}
return *field_clearRequest;
}

const PDU__BSSMAP__ClearRequest& PDU__BSSMAP::clearRequest() const
{
if (union_selection != ALT_clearRequest) TTCN_error("Using non-selected field clearRequest in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_clearRequest;
}

PDU__BSSMAP__CommonID& PDU__BSSMAP::commonID()
{
if (union_selection != ALT_commonID) {
clean_up();
field_commonID = new PDU__BSSMAP__CommonID;
union_selection = ALT_commonID;
}
return *field_commonID;
}

const PDU__BSSMAP__CommonID& PDU__BSSMAP::commonID() const
{
if (union_selection != ALT_commonID) TTCN_error("Using non-selected field commonID in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_commonID;
}

PDU__BSSMAP__CompleteLayer3Information& PDU__BSSMAP::completeLayer3Information()
{
if (union_selection != ALT_completeLayer3Information) {
clean_up();
field_completeLayer3Information = new PDU__BSSMAP__CompleteLayer3Information;
union_selection = ALT_completeLayer3Information;
}
return *field_completeLayer3Information;
}

const PDU__BSSMAP__CompleteLayer3Information& PDU__BSSMAP::completeLayer3Information() const
{
if (union_selection != ALT_completeLayer3Information) TTCN_error("Using non-selected field completeLayer3Information in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_completeLayer3Information;
}

PDU__BSSMAP__Confusion& PDU__BSSMAP::confusion()
{
if (union_selection != ALT_confusion) {
clean_up();
field_confusion = new PDU__BSSMAP__Confusion;
union_selection = ALT_confusion;
}
return *field_confusion;
}

const PDU__BSSMAP__Confusion& PDU__BSSMAP::confusion() const
{
if (union_selection != ALT_confusion) TTCN_error("Using non-selected field confusion in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_confusion;
}

PDU__BSSMAP__ConnectionlessInformation& PDU__BSSMAP::connectionlessInformation()
{
if (union_selection != ALT_connectionlessInformation) {
clean_up();
field_connectionlessInformation = new PDU__BSSMAP__ConnectionlessInformation;
union_selection = ALT_connectionlessInformation;
}
return *field_connectionlessInformation;
}

const PDU__BSSMAP__ConnectionlessInformation& PDU__BSSMAP::connectionlessInformation() const
{
if (union_selection != ALT_connectionlessInformation) TTCN_error("Using non-selected field connectionlessInformation in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_connectionlessInformation;
}

PDU__BSSMAP__HandoverCandidateEnquire& PDU__BSSMAP::handoverCandidateEnquire()
{
if (union_selection != ALT_handoverCandidateEnquire) {
clean_up();
field_handoverCandidateEnquire = new PDU__BSSMAP__HandoverCandidateEnquire;
union_selection = ALT_handoverCandidateEnquire;
}
return *field_handoverCandidateEnquire;
}

const PDU__BSSMAP__HandoverCandidateEnquire& PDU__BSSMAP::handoverCandidateEnquire() const
{
if (union_selection != ALT_handoverCandidateEnquire) TTCN_error("Using non-selected field handoverCandidateEnquire in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_handoverCandidateEnquire;
}

PDU__BSSMAP__HandoverCandidateResponse& PDU__BSSMAP::handoverCandidateResponse()
{
if (union_selection != ALT_handoverCandidateResponse) {
clean_up();
field_handoverCandidateResponse = new PDU__BSSMAP__HandoverCandidateResponse;
union_selection = ALT_handoverCandidateResponse;
}
return *field_handoverCandidateResponse;
}

const PDU__BSSMAP__HandoverCandidateResponse& PDU__BSSMAP::handoverCandidateResponse() const
{
if (union_selection != ALT_handoverCandidateResponse) TTCN_error("Using non-selected field handoverCandidateResponse in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_handoverCandidateResponse;
}

PDU__BSSMAP__HandoverCommand& PDU__BSSMAP::handoverCommand()
{
if (union_selection != ALT_handoverCommand) {
clean_up();
field_handoverCommand = new PDU__BSSMAP__HandoverCommand;
union_selection = ALT_handoverCommand;
}
return *field_handoverCommand;
}

const PDU__BSSMAP__HandoverCommand& PDU__BSSMAP::handoverCommand() const
{
if (union_selection != ALT_handoverCommand) TTCN_error("Using non-selected field handoverCommand in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_handoverCommand;
}

PDU__BSSMAP__HandoverComplete& PDU__BSSMAP::handoverComplete()
{
if (union_selection != ALT_handoverComplete) {
clean_up();
field_handoverComplete = new PDU__BSSMAP__HandoverComplete;
union_selection = ALT_handoverComplete;
}
return *field_handoverComplete;
}

const PDU__BSSMAP__HandoverComplete& PDU__BSSMAP::handoverComplete() const
{
if (union_selection != ALT_handoverComplete) TTCN_error("Using non-selected field handoverComplete in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_handoverComplete;
}

PDU__BSSMAP__HandoverDetect& PDU__BSSMAP::handoverDetect()
{
if (union_selection != ALT_handoverDetect) {
clean_up();
field_handoverDetect = new PDU__BSSMAP__HandoverDetect;
union_selection = ALT_handoverDetect;
}
return *field_handoverDetect;
}

const PDU__BSSMAP__HandoverDetect& PDU__BSSMAP::handoverDetect() const
{
if (union_selection != ALT_handoverDetect) TTCN_error("Using non-selected field handoverDetect in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_handoverDetect;
}

PDU__BSSMAP__HandoverFailure& PDU__BSSMAP::handoverFailure()
{
if (union_selection != ALT_handoverFailure) {
clean_up();
field_handoverFailure = new PDU__BSSMAP__HandoverFailure;
union_selection = ALT_handoverFailure;
}
return *field_handoverFailure;
}

const PDU__BSSMAP__HandoverFailure& PDU__BSSMAP::handoverFailure() const
{
if (union_selection != ALT_handoverFailure) TTCN_error("Using non-selected field handoverFailure in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_handoverFailure;
}

PDU__BSSMAP__HandoverPerformed& PDU__BSSMAP::handoverPerformed()
{
if (union_selection != ALT_handoverPerformed) {
clean_up();
field_handoverPerformed = new PDU__BSSMAP__HandoverPerformed;
union_selection = ALT_handoverPerformed;
}
return *field_handoverPerformed;
}

const PDU__BSSMAP__HandoverPerformed& PDU__BSSMAP::handoverPerformed() const
{
if (union_selection != ALT_handoverPerformed) TTCN_error("Using non-selected field handoverPerformed in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_handoverPerformed;
}

PDU__BSSMAP__HandoverRequest& PDU__BSSMAP::handoverRequest()
{
if (union_selection != ALT_handoverRequest) {
clean_up();
field_handoverRequest = new PDU__BSSMAP__HandoverRequest;
union_selection = ALT_handoverRequest;
}
return *field_handoverRequest;
}

const PDU__BSSMAP__HandoverRequest& PDU__BSSMAP::handoverRequest() const
{
if (union_selection != ALT_handoverRequest) TTCN_error("Using non-selected field handoverRequest in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_handoverRequest;
}

PDU__BSSMAP__HandoverRequestAck& PDU__BSSMAP::handoverRequestAck()
{
if (union_selection != ALT_handoverRequestAck) {
clean_up();
field_handoverRequestAck = new PDU__BSSMAP__HandoverRequestAck;
union_selection = ALT_handoverRequestAck;
}
return *field_handoverRequestAck;
}

const PDU__BSSMAP__HandoverRequestAck& PDU__BSSMAP::handoverRequestAck() const
{
if (union_selection != ALT_handoverRequestAck) TTCN_error("Using non-selected field handoverRequestAck in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_handoverRequestAck;
}

PDU__BSSMAP__HandoverRequired& PDU__BSSMAP::handoverRequired()
{
if (union_selection != ALT_handoverRequired) {
clean_up();
field_handoverRequired = new PDU__BSSMAP__HandoverRequired;
union_selection = ALT_handoverRequired;
}
return *field_handoverRequired;
}

const PDU__BSSMAP__HandoverRequired& PDU__BSSMAP::handoverRequired() const
{
if (union_selection != ALT_handoverRequired) TTCN_error("Using non-selected field handoverRequired in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_handoverRequired;
}

PDU__BSSMAP__HandoverRequiredReject& PDU__BSSMAP::handoverRequiredReject()
{
if (union_selection != ALT_handoverRequiredReject) {
clean_up();
field_handoverRequiredReject = new PDU__BSSMAP__HandoverRequiredReject;
union_selection = ALT_handoverRequiredReject;
}
return *field_handoverRequiredReject;
}

const PDU__BSSMAP__HandoverRequiredReject& PDU__BSSMAP::handoverRequiredReject() const
{
if (union_selection != ALT_handoverRequiredReject) TTCN_error("Using non-selected field handoverRequiredReject in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_handoverRequiredReject;
}

PDU__BSSMAP__HandoverSucceeded& PDU__BSSMAP::handoverSucceeded()
{
if (union_selection != ALT_handoverSucceeded) {
clean_up();
field_handoverSucceeded = new PDU__BSSMAP__HandoverSucceeded;
union_selection = ALT_handoverSucceeded;
}
return *field_handoverSucceeded;
}

const PDU__BSSMAP__HandoverSucceeded& PDU__BSSMAP::handoverSucceeded() const
{
if (union_selection != ALT_handoverSucceeded) TTCN_error("Using non-selected field handoverSucceeded in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_handoverSucceeded;
}

PDU__BSSMAP__LoadIndication& PDU__BSSMAP::loadIndication()
{
if (union_selection != ALT_loadIndication) {
clean_up();
field_loadIndication = new PDU__BSSMAP__LoadIndication;
union_selection = ALT_loadIndication;
}
return *field_loadIndication;
}

const PDU__BSSMAP__LoadIndication& PDU__BSSMAP::loadIndication() const
{
if (union_selection != ALT_loadIndication) TTCN_error("Using non-selected field loadIndication in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_loadIndication;
}

PDU__BSSMAP__LSAInformation& PDU__BSSMAP::lSAInformation()
{
if (union_selection != ALT_lSAInformation) {
clean_up();
field_lSAInformation = new PDU__BSSMAP__LSAInformation;
union_selection = ALT_lSAInformation;
}
return *field_lSAInformation;
}

const PDU__BSSMAP__LSAInformation& PDU__BSSMAP::lSAInformation() const
{
if (union_selection != ALT_lSAInformation) TTCN_error("Using non-selected field lSAInformation in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_lSAInformation;
}

PDU__BSSMAP__MSCInvokeTrace& PDU__BSSMAP::mSCInvokeTrace()
{
if (union_selection != ALT_mSCInvokeTrace) {
clean_up();
field_mSCInvokeTrace = new PDU__BSSMAP__MSCInvokeTrace;
union_selection = ALT_mSCInvokeTrace;
}
return *field_mSCInvokeTrace;
}

const PDU__BSSMAP__MSCInvokeTrace& PDU__BSSMAP::mSCInvokeTrace() const
{
if (union_selection != ALT_mSCInvokeTrace) TTCN_error("Using non-selected field mSCInvokeTrace in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_mSCInvokeTrace;
}

PDU__BSSMAP__Overload& PDU__BSSMAP::overload()
{
if (union_selection != ALT_overload) {
clean_up();
field_overload = new PDU__BSSMAP__Overload;
union_selection = ALT_overload;
}
return *field_overload;
}

const PDU__BSSMAP__Overload& PDU__BSSMAP::overload() const
{
if (union_selection != ALT_overload) TTCN_error("Using non-selected field overload in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_overload;
}

PDU__BSSMAP__Paging& PDU__BSSMAP::paging()
{
if (union_selection != ALT_paging) {
clean_up();
field_paging = new PDU__BSSMAP__Paging;
union_selection = ALT_paging;
}
return *field_paging;
}

const PDU__BSSMAP__Paging& PDU__BSSMAP::paging() const
{
if (union_selection != ALT_paging) TTCN_error("Using non-selected field paging in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_paging;
}

PDU__BSSMAP__PerformLocationAbort& PDU__BSSMAP::performLocationAbort()
{
if (union_selection != ALT_performLocationAbort) {
clean_up();
field_performLocationAbort = new PDU__BSSMAP__PerformLocationAbort;
union_selection = ALT_performLocationAbort;
}
return *field_performLocationAbort;
}

const PDU__BSSMAP__PerformLocationAbort& PDU__BSSMAP::performLocationAbort() const
{
if (union_selection != ALT_performLocationAbort) TTCN_error("Using non-selected field performLocationAbort in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_performLocationAbort;
}

PDU__BSSMAP__PerformLocationRequest& PDU__BSSMAP::performLocationRequest()
{
if (union_selection != ALT_performLocationRequest) {
clean_up();
field_performLocationRequest = new PDU__BSSMAP__PerformLocationRequest;
union_selection = ALT_performLocationRequest;
}
return *field_performLocationRequest;
}

const PDU__BSSMAP__PerformLocationRequest& PDU__BSSMAP::performLocationRequest() const
{
if (union_selection != ALT_performLocationRequest) TTCN_error("Using non-selected field performLocationRequest in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_performLocationRequest;
}

PDU__BSSMAP__PerformLocationResponse& PDU__BSSMAP::performLocationResponse()
{
if (union_selection != ALT_performLocationResponse) {
clean_up();
field_performLocationResponse = new PDU__BSSMAP__PerformLocationResponse;
union_selection = ALT_performLocationResponse;
}
return *field_performLocationResponse;
}

const PDU__BSSMAP__PerformLocationResponse& PDU__BSSMAP::performLocationResponse() const
{
if (union_selection != ALT_performLocationResponse) TTCN_error("Using non-selected field performLocationResponse in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_performLocationResponse;
}

PDU__BSSMAP__QueueingIndication& PDU__BSSMAP::queueingIndication()
{
if (union_selection != ALT_queueingIndication) {
clean_up();
field_queueingIndication = new PDU__BSSMAP__QueueingIndication;
union_selection = ALT_queueingIndication;
}
return *field_queueingIndication;
}

const PDU__BSSMAP__QueueingIndication& PDU__BSSMAP::queueingIndication() const
{
if (union_selection != ALT_queueingIndication) TTCN_error("Using non-selected field queueingIndication in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_queueingIndication;
}

PDU__BSSMAP__Reset& PDU__BSSMAP::reset()
{
if (union_selection != ALT_reset) {
clean_up();
field_reset = new PDU__BSSMAP__Reset;
union_selection = ALT_reset;
}
return *field_reset;
}

const PDU__BSSMAP__Reset& PDU__BSSMAP::reset() const
{
if (union_selection != ALT_reset) TTCN_error("Using non-selected field reset in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_reset;
}

PDU__BSSMAP__ResetAck& PDU__BSSMAP::resetAck()
{
if (union_selection != ALT_resetAck) {
clean_up();
field_resetAck = new PDU__BSSMAP__ResetAck;
union_selection = ALT_resetAck;
}
return *field_resetAck;
}

const PDU__BSSMAP__ResetAck& PDU__BSSMAP::resetAck() const
{
if (union_selection != ALT_resetAck) TTCN_error("Using non-selected field resetAck in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_resetAck;
}

PDU__BSSMAP__ResetCircuit& PDU__BSSMAP::resetCircuit()
{
if (union_selection != ALT_resetCircuit) {
clean_up();
field_resetCircuit = new PDU__BSSMAP__ResetCircuit;
union_selection = ALT_resetCircuit;
}
return *field_resetCircuit;
}

const PDU__BSSMAP__ResetCircuit& PDU__BSSMAP::resetCircuit() const
{
if (union_selection != ALT_resetCircuit) TTCN_error("Using non-selected field resetCircuit in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_resetCircuit;
}

PDU__BSSMAP__ResetCircuitAck& PDU__BSSMAP::resetCircuitAck()
{
if (union_selection != ALT_resetCircuitAck) {
clean_up();
field_resetCircuitAck = new PDU__BSSMAP__ResetCircuitAck;
union_selection = ALT_resetCircuitAck;
}
return *field_resetCircuitAck;
}

const PDU__BSSMAP__ResetCircuitAck& PDU__BSSMAP::resetCircuitAck() const
{
if (union_selection != ALT_resetCircuitAck) TTCN_error("Using non-selected field resetCircuitAck in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_resetCircuitAck;
}

PDU__BSSMAP__ResourceIndication& PDU__BSSMAP::resourceIndication()
{
if (union_selection != ALT_resourceIndication) {
clean_up();
field_resourceIndication = new PDU__BSSMAP__ResourceIndication;
union_selection = ALT_resourceIndication;
}
return *field_resourceIndication;
}

const PDU__BSSMAP__ResourceIndication& PDU__BSSMAP::resourceIndication() const
{
if (union_selection != ALT_resourceIndication) TTCN_error("Using non-selected field resourceIndication in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_resourceIndication;
}

PDU__BSSMAP__ResourceRequest& PDU__BSSMAP::resourceRequest()
{
if (union_selection != ALT_resourceRequest) {
clean_up();
field_resourceRequest = new PDU__BSSMAP__ResourceRequest;
union_selection = ALT_resourceRequest;
}
return *field_resourceRequest;
}

const PDU__BSSMAP__ResourceRequest& PDU__BSSMAP::resourceRequest() const
{
if (union_selection != ALT_resourceRequest) TTCN_error("Using non-selected field resourceRequest in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_resourceRequest;
}

PDU__BSSMAP__SAPInReject& PDU__BSSMAP::sAPInReject()
{
if (union_selection != ALT_sAPInReject) {
clean_up();
field_sAPInReject = new PDU__BSSMAP__SAPInReject;
union_selection = ALT_sAPInReject;
}
return *field_sAPInReject;
}

const PDU__BSSMAP__SAPInReject& PDU__BSSMAP::sAPInReject() const
{
if (union_selection != ALT_sAPInReject) TTCN_error("Using non-selected field sAPInReject in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_sAPInReject;
}

PDU__BSSMAP__Suspend& PDU__BSSMAP::suspend()
{
if (union_selection != ALT_suspend) {
clean_up();
field_suspend = new PDU__BSSMAP__Suspend;
union_selection = ALT_suspend;
}
return *field_suspend;
}

const PDU__BSSMAP__Suspend& PDU__BSSMAP::suspend() const
{
if (union_selection != ALT_suspend) TTCN_error("Using non-selected field suspend in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_suspend;
}

PDU__BSSMAP__Resume& PDU__BSSMAP::resume()
{
if (union_selection != ALT_resume) {
clean_up();
field_resume = new PDU__BSSMAP__Resume;
union_selection = ALT_resume;
}
return *field_resume;
}

const PDU__BSSMAP__Resume& PDU__BSSMAP::resume() const
{
if (union_selection != ALT_resume) TTCN_error("Using non-selected field resume in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_resume;
}

PDU__BSSMAP__Unblock& PDU__BSSMAP::unblock()
{
if (union_selection != ALT_unblock) {
clean_up();
field_unblock = new PDU__BSSMAP__Unblock;
union_selection = ALT_unblock;
}
return *field_unblock;
}

const PDU__BSSMAP__Unblock& PDU__BSSMAP::unblock() const
{
if (union_selection != ALT_unblock) TTCN_error("Using non-selected field unblock in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_unblock;
}

PDU__BSSMAP__UnblockAck& PDU__BSSMAP::unblockAck()
{
if (union_selection != ALT_unblockAck) {
clean_up();
field_unblockAck = new PDU__BSSMAP__UnblockAck;
union_selection = ALT_unblockAck;
}
return *field_unblockAck;
}

const PDU__BSSMAP__UnblockAck& PDU__BSSMAP::unblockAck() const
{
if (union_selection != ALT_unblockAck) TTCN_error("Using non-selected field unblockAck in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_unblockAck;
}

PDU__BSSMAP__UnequippedCircuit& PDU__BSSMAP::unequippedCircuit()
{
if (union_selection != ALT_unequippedCircuit) {
clean_up();
field_unequippedCircuit = new PDU__BSSMAP__UnequippedCircuit;
union_selection = ALT_unequippedCircuit;
}
return *field_unequippedCircuit;
}

const PDU__BSSMAP__UnequippedCircuit& PDU__BSSMAP::unequippedCircuit() const
{
if (union_selection != ALT_unequippedCircuit) TTCN_error("Using non-selected field unequippedCircuit in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_unequippedCircuit;
}

PDU__BSSMAP__UplinkRequest& PDU__BSSMAP::uplinkRequest()
{
if (union_selection != ALT_uplinkRequest) {
clean_up();
field_uplinkRequest = new PDU__BSSMAP__UplinkRequest;
union_selection = ALT_uplinkRequest;
}
return *field_uplinkRequest;
}

const PDU__BSSMAP__UplinkRequest& PDU__BSSMAP::uplinkRequest() const
{
if (union_selection != ALT_uplinkRequest) TTCN_error("Using non-selected field uplinkRequest in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_uplinkRequest;
}

PDU__BSSMAP__UplinkRequestAck& PDU__BSSMAP::uplinkRequestAck()
{
if (union_selection != ALT_uplinkRequestAck) {
clean_up();
field_uplinkRequestAck = new PDU__BSSMAP__UplinkRequestAck;
union_selection = ALT_uplinkRequestAck;
}
return *field_uplinkRequestAck;
}

const PDU__BSSMAP__UplinkRequestAck& PDU__BSSMAP::uplinkRequestAck() const
{
if (union_selection != ALT_uplinkRequestAck) TTCN_error("Using non-selected field uplinkRequestAck in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_uplinkRequestAck;
}

PDU__BSSMAP__UplinkRequestConfirmation& PDU__BSSMAP::uplinkRequestConfirmation()
{
if (union_selection != ALT_uplinkRequestConfirmation) {
clean_up();
field_uplinkRequestConfirmation = new PDU__BSSMAP__UplinkRequestConfirmation;
union_selection = ALT_uplinkRequestConfirmation;
}
return *field_uplinkRequestConfirmation;
}

const PDU__BSSMAP__UplinkRequestConfirmation& PDU__BSSMAP::uplinkRequestConfirmation() const
{
if (union_selection != ALT_uplinkRequestConfirmation) TTCN_error("Using non-selected field uplinkRequestConfirmation in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_uplinkRequestConfirmation;
}

PDU__BSSMAP__UplinkReleaseIndication& PDU__BSSMAP::uplinkReleaseIndication()
{
if (union_selection != ALT_uplinkReleaseIndication) {
clean_up();
field_uplinkReleaseIndication = new PDU__BSSMAP__UplinkReleaseIndication;
union_selection = ALT_uplinkReleaseIndication;
}
return *field_uplinkReleaseIndication;
}

const PDU__BSSMAP__UplinkReleaseIndication& PDU__BSSMAP::uplinkReleaseIndication() const
{
if (union_selection != ALT_uplinkReleaseIndication) TTCN_error("Using non-selected field uplinkReleaseIndication in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_uplinkReleaseIndication;
}

PDU__BSSMAP__UplinkRejectCommand& PDU__BSSMAP::uplinkRejectCommand()
{
if (union_selection != ALT_uplinkRejectCommand) {
clean_up();
field_uplinkRejectCommand = new PDU__BSSMAP__UplinkRejectCommand;
union_selection = ALT_uplinkRejectCommand;
}
return *field_uplinkRejectCommand;
}

const PDU__BSSMAP__UplinkRejectCommand& PDU__BSSMAP::uplinkRejectCommand() const
{
if (union_selection != ALT_uplinkRejectCommand) TTCN_error("Using non-selected field uplinkRejectCommand in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_uplinkRejectCommand;
}

PDU__BSSMAP__UplinkReleaseCommand& PDU__BSSMAP::uplinkReleaseCommand()
{
if (union_selection != ALT_uplinkReleaseCommand) {
clean_up();
field_uplinkReleaseCommand = new PDU__BSSMAP__UplinkReleaseCommand;
union_selection = ALT_uplinkReleaseCommand;
}
return *field_uplinkReleaseCommand;
}

const PDU__BSSMAP__UplinkReleaseCommand& PDU__BSSMAP::uplinkReleaseCommand() const
{
if (union_selection != ALT_uplinkReleaseCommand) TTCN_error("Using non-selected field uplinkReleaseCommand in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_uplinkReleaseCommand;
}

PDU__BSSMAP__UplinkSeizedCommand& PDU__BSSMAP::uplinkSeizedCommand()
{
if (union_selection != ALT_uplinkSeizedCommand) {
clean_up();
field_uplinkSeizedCommand = new PDU__BSSMAP__UplinkSeizedCommand;
union_selection = ALT_uplinkSeizedCommand;
}
return *field_uplinkSeizedCommand;
}

const PDU__BSSMAP__UplinkSeizedCommand& PDU__BSSMAP::uplinkSeizedCommand() const
{
if (union_selection != ALT_uplinkSeizedCommand) TTCN_error("Using non-selected field uplinkSeizedCommand in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_uplinkSeizedCommand;
}

PDU__BSSMAP__VGCS__VBSSetup& PDU__BSSMAP::vGCS__VBSSetup()
{
if (union_selection != ALT_vGCS__VBSSetup) {
clean_up();
field_vGCS__VBSSetup = new PDU__BSSMAP__VGCS__VBSSetup;
union_selection = ALT_vGCS__VBSSetup;
}
return *field_vGCS__VBSSetup;
}

const PDU__BSSMAP__VGCS__VBSSetup& PDU__BSSMAP::vGCS__VBSSetup() const
{
if (union_selection != ALT_vGCS__VBSSetup) TTCN_error("Using non-selected field vGCS_VBSSetup in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_vGCS__VBSSetup;
}

PDU__BSSMAP__VGCS__VBSSetupAck& PDU__BSSMAP::vGCS__VBSSetupAck()
{
if (union_selection != ALT_vGCS__VBSSetupAck) {
clean_up();
field_vGCS__VBSSetupAck = new PDU__BSSMAP__VGCS__VBSSetupAck;
union_selection = ALT_vGCS__VBSSetupAck;
}
return *field_vGCS__VBSSetupAck;
}

const PDU__BSSMAP__VGCS__VBSSetupAck& PDU__BSSMAP::vGCS__VBSSetupAck() const
{
if (union_selection != ALT_vGCS__VBSSetupAck) TTCN_error("Using non-selected field vGCS_VBSSetupAck in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_vGCS__VBSSetupAck;
}

PDU__BSSMAP__VGCS__VBSSetupRefuse& PDU__BSSMAP::vGCS__VBSSetupRefuse()
{
if (union_selection != ALT_vGCS__VBSSetupRefuse) {
clean_up();
field_vGCS__VBSSetupRefuse = new PDU__BSSMAP__VGCS__VBSSetupRefuse;
union_selection = ALT_vGCS__VBSSetupRefuse;
}
return *field_vGCS__VBSSetupRefuse;
}

const PDU__BSSMAP__VGCS__VBSSetupRefuse& PDU__BSSMAP::vGCS__VBSSetupRefuse() const
{
if (union_selection != ALT_vGCS__VBSSetupRefuse) TTCN_error("Using non-selected field vGCS_VBSSetupRefuse in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_vGCS__VBSSetupRefuse;
}

PDU__BSSMAP__VGCS__VBSAssignmentRequest& PDU__BSSMAP::vGCS__VBSAssignmentRequest()
{
if (union_selection != ALT_vGCS__VBSAssignmentRequest) {
clean_up();
field_vGCS__VBSAssignmentRequest = new PDU__BSSMAP__VGCS__VBSAssignmentRequest;
union_selection = ALT_vGCS__VBSAssignmentRequest;
}
return *field_vGCS__VBSAssignmentRequest;
}

const PDU__BSSMAP__VGCS__VBSAssignmentRequest& PDU__BSSMAP::vGCS__VBSAssignmentRequest() const
{
if (union_selection != ALT_vGCS__VBSAssignmentRequest) TTCN_error("Using non-selected field vGCS_VBSAssignmentRequest in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_vGCS__VBSAssignmentRequest;
}

PDU__BSSMAP__VGCS__VBSAssignmentResult& PDU__BSSMAP::vGCS__VBSAssignmentResult()
{
if (union_selection != ALT_vGCS__VBSAssignmentResult) {
clean_up();
field_vGCS__VBSAssignmentResult = new PDU__BSSMAP__VGCS__VBSAssignmentResult;
union_selection = ALT_vGCS__VBSAssignmentResult;
}
return *field_vGCS__VBSAssignmentResult;
}

const PDU__BSSMAP__VGCS__VBSAssignmentResult& PDU__BSSMAP::vGCS__VBSAssignmentResult() const
{
if (union_selection != ALT_vGCS__VBSAssignmentResult) TTCN_error("Using non-selected field vGCS_VBSAssignmentResult in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_vGCS__VBSAssignmentResult;
}

PDU__BSSMAP__VGCS__VBSAssignmentFailure& PDU__BSSMAP::vGCS__VBSAssignmentFailure()
{
if (union_selection != ALT_vGCS__VBSAssignmentFailure) {
clean_up();
field_vGCS__VBSAssignmentFailure = new PDU__BSSMAP__VGCS__VBSAssignmentFailure;
union_selection = ALT_vGCS__VBSAssignmentFailure;
}
return *field_vGCS__VBSAssignmentFailure;
}

const PDU__BSSMAP__VGCS__VBSAssignmentFailure& PDU__BSSMAP::vGCS__VBSAssignmentFailure() const
{
if (union_selection != ALT_vGCS__VBSAssignmentFailure) TTCN_error("Using non-selected field vGCS_VBSAssignmentFailure in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_vGCS__VBSAssignmentFailure;
}

PDU__BSSMAP__VGCS__VBSQueuingIndication& PDU__BSSMAP::vGCS__VBSQueuingIndication()
{
if (union_selection != ALT_vGCS__VBSQueuingIndication) {
clean_up();
field_vGCS__VBSQueuingIndication = new PDU__BSSMAP__VGCS__VBSQueuingIndication;
union_selection = ALT_vGCS__VBSQueuingIndication;
}
return *field_vGCS__VBSQueuingIndication;
}

const PDU__BSSMAP__VGCS__VBSQueuingIndication& PDU__BSSMAP::vGCS__VBSQueuingIndication() const
{
if (union_selection != ALT_vGCS__VBSQueuingIndication) TTCN_error("Using non-selected field vGCS_VBSQueuingIndication in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_vGCS__VBSQueuingIndication;
}

PDU__BSSMAP__VGCS__AdditionalInformation& PDU__BSSMAP::vGCS__AdditionalInformation()
{
if (union_selection != ALT_vGCS__AdditionalInformation) {
clean_up();
field_vGCS__AdditionalInformation = new PDU__BSSMAP__VGCS__AdditionalInformation;
union_selection = ALT_vGCS__AdditionalInformation;
}
return *field_vGCS__AdditionalInformation;
}

const PDU__BSSMAP__VGCS__AdditionalInformation& PDU__BSSMAP::vGCS__AdditionalInformation() const
{
if (union_selection != ALT_vGCS__AdditionalInformation) TTCN_error("Using non-selected field vGCS_AdditionalInformation in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_vGCS__AdditionalInformation;
}

PDU__BSSMAP__VGCS__VBS__AreaCellInfo& PDU__BSSMAP::vGCS__VBS__AreaCellInfo()
{
if (union_selection != ALT_vGCS__VBS__AreaCellInfo) {
clean_up();
field_vGCS__VBS__AreaCellInfo = new PDU__BSSMAP__VGCS__VBS__AreaCellInfo;
union_selection = ALT_vGCS__VBS__AreaCellInfo;
}
return *field_vGCS__VBS__AreaCellInfo;
}

const PDU__BSSMAP__VGCS__VBS__AreaCellInfo& PDU__BSSMAP::vGCS__VBS__AreaCellInfo() const
{
if (union_selection != ALT_vGCS__VBS__AreaCellInfo) TTCN_error("Using non-selected field vGCS_VBS_AreaCellInfo in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_vGCS__VBS__AreaCellInfo;
}

PDU__BSSMAP__VGCS__VBS__AssignmentStatus& PDU__BSSMAP::vGCS__VBS__AssignmentStatus()
{
if (union_selection != ALT_vGCS__VBS__AssignmentStatus) {
clean_up();
field_vGCS__VBS__AssignmentStatus = new PDU__BSSMAP__VGCS__VBS__AssignmentStatus;
union_selection = ALT_vGCS__VBS__AssignmentStatus;
}
return *field_vGCS__VBS__AssignmentStatus;
}

const PDU__BSSMAP__VGCS__VBS__AssignmentStatus& PDU__BSSMAP::vGCS__VBS__AssignmentStatus() const
{
if (union_selection != ALT_vGCS__VBS__AssignmentStatus) TTCN_error("Using non-selected field vGCS_VBS_AssignmentStatus in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_vGCS__VBS__AssignmentStatus;
}

PDU__BSSMAP__VGCS__SMS& PDU__BSSMAP::vGCS__SMS()
{
if (union_selection != ALT_vGCS__SMS) {
clean_up();
field_vGCS__SMS = new PDU__BSSMAP__VGCS__SMS;
union_selection = ALT_vGCS__SMS;
}
return *field_vGCS__SMS;
}

const PDU__BSSMAP__VGCS__SMS& PDU__BSSMAP::vGCS__SMS() const
{
if (union_selection != ALT_vGCS__SMS) TTCN_error("Using non-selected field vGCS_SMS in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_vGCS__SMS;
}

PDU__BSSMAP__UplinkApplicationData& PDU__BSSMAP::uplinkApplicationData()
{
if (union_selection != ALT_uplinkApplicationData) {
clean_up();
field_uplinkApplicationData = new PDU__BSSMAP__UplinkApplicationData;
union_selection = ALT_uplinkApplicationData;
}
return *field_uplinkApplicationData;
}

const PDU__BSSMAP__UplinkApplicationData& PDU__BSSMAP::uplinkApplicationData() const
{
if (union_selection != ALT_uplinkApplicationData) TTCN_error("Using non-selected field uplinkApplicationData in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_uplinkApplicationData;
}

PDU__BSSMAP__NotificationData& PDU__BSSMAP::notificationData()
{
if (union_selection != ALT_notificationData) {
clean_up();
field_notificationData = new PDU__BSSMAP__NotificationData;
union_selection = ALT_notificationData;
}
return *field_notificationData;
}

const PDU__BSSMAP__NotificationData& PDU__BSSMAP::notificationData() const
{
if (union_selection != ALT_notificationData) TTCN_error("Using non-selected field notificationData in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_notificationData;
}

PDU__BSSMAP__InternalHandoverRequired& PDU__BSSMAP::internalHandoverRequired()
{
if (union_selection != ALT_internalHandoverRequired) {
clean_up();
field_internalHandoverRequired = new PDU__BSSMAP__InternalHandoverRequired;
union_selection = ALT_internalHandoverRequired;
}
return *field_internalHandoverRequired;
}

const PDU__BSSMAP__InternalHandoverRequired& PDU__BSSMAP::internalHandoverRequired() const
{
if (union_selection != ALT_internalHandoverRequired) TTCN_error("Using non-selected field internalHandoverRequired in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_internalHandoverRequired;
}

PDU__BSSMAP__InternalHandoverRequiredReject& PDU__BSSMAP::internalHandoverRequiredReject()
{
if (union_selection != ALT_internalHandoverRequiredReject) {
clean_up();
field_internalHandoverRequiredReject = new PDU__BSSMAP__InternalHandoverRequiredReject;
union_selection = ALT_internalHandoverRequiredReject;
}
return *field_internalHandoverRequiredReject;
}

const PDU__BSSMAP__InternalHandoverRequiredReject& PDU__BSSMAP::internalHandoverRequiredReject() const
{
if (union_selection != ALT_internalHandoverRequiredReject) TTCN_error("Using non-selected field internalHandoverRequiredReject in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_internalHandoverRequiredReject;
}

PDU__BSSMAP__InternalHandoverCommand& PDU__BSSMAP::internalHandoverCommand()
{
if (union_selection != ALT_internalHandoverCommand) {
clean_up();
field_internalHandoverCommand = new PDU__BSSMAP__InternalHandoverCommand;
union_selection = ALT_internalHandoverCommand;
}
return *field_internalHandoverCommand;
}

const PDU__BSSMAP__InternalHandoverCommand& PDU__BSSMAP::internalHandoverCommand() const
{
if (union_selection != ALT_internalHandoverCommand) TTCN_error("Using non-selected field internalHandoverCommand in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_internalHandoverCommand;
}

PDU__BSSMAP__InternalHandoverEnquiry& PDU__BSSMAP::internalHandoverEnquiry()
{
if (union_selection != ALT_internalHandoverEnquiry) {
clean_up();
field_internalHandoverEnquiry = new PDU__BSSMAP__InternalHandoverEnquiry;
union_selection = ALT_internalHandoverEnquiry;
}
return *field_internalHandoverEnquiry;
}

const PDU__BSSMAP__InternalHandoverEnquiry& PDU__BSSMAP::internalHandoverEnquiry() const
{
if (union_selection != ALT_internalHandoverEnquiry) TTCN_error("Using non-selected field internalHandoverEnquiry in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_internalHandoverEnquiry;
}

PDU__BSSMAP__ResetIPResource& PDU__BSSMAP::resetIPResource()
{
if (union_selection != ALT_resetIPResource) {
clean_up();
field_resetIPResource = new PDU__BSSMAP__ResetIPResource;
union_selection = ALT_resetIPResource;
}
return *field_resetIPResource;
}

const PDU__BSSMAP__ResetIPResource& PDU__BSSMAP::resetIPResource() const
{
if (union_selection != ALT_resetIPResource) TTCN_error("Using non-selected field resetIPResource in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_resetIPResource;
}

PDU__BSSMAP__ResetIPResourceAck& PDU__BSSMAP::resetIPResourceAck()
{
if (union_selection != ALT_resetIPResourceAck) {
clean_up();
field_resetIPResourceAck = new PDU__BSSMAP__ResetIPResourceAck;
union_selection = ALT_resetIPResourceAck;
}
return *field_resetIPResourceAck;
}

const PDU__BSSMAP__ResetIPResourceAck& PDU__BSSMAP::resetIPResourceAck() const
{
if (union_selection != ALT_resetIPResourceAck) TTCN_error("Using non-selected field resetIPResourceAck in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_resetIPResourceAck;
}

PDU__BSSMAP__RerouteCommand& PDU__BSSMAP::rerouteCommand()
{
if (union_selection != ALT_rerouteCommand) {
clean_up();
field_rerouteCommand = new PDU__BSSMAP__RerouteCommand;
union_selection = ALT_rerouteCommand;
}
return *field_rerouteCommand;
}

const PDU__BSSMAP__RerouteCommand& PDU__BSSMAP::rerouteCommand() const
{
if (union_selection != ALT_rerouteCommand) TTCN_error("Using non-selected field rerouteCommand in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_rerouteCommand;
}

PDU__BSSMAP__RerouteComplete& PDU__BSSMAP::rerouteComplete()
{
if (union_selection != ALT_rerouteComplete) {
clean_up();
field_rerouteComplete = new PDU__BSSMAP__RerouteComplete;
union_selection = ALT_rerouteComplete;
}
return *field_rerouteComplete;
}

const PDU__BSSMAP__RerouteComplete& PDU__BSSMAP::rerouteComplete() const
{
if (union_selection != ALT_rerouteComplete) TTCN_error("Using non-selected field rerouteComplete in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_rerouteComplete;
}

PDU__BSSMAP__LCLS__ConnectControl& PDU__BSSMAP::lCLS__ConnectControl()
{
if (union_selection != ALT_lCLS__ConnectControl) {
clean_up();
field_lCLS__ConnectControl = new PDU__BSSMAP__LCLS__ConnectControl;
union_selection = ALT_lCLS__ConnectControl;
}
return *field_lCLS__ConnectControl;
}

const PDU__BSSMAP__LCLS__ConnectControl& PDU__BSSMAP::lCLS__ConnectControl() const
{
if (union_selection != ALT_lCLS__ConnectControl) TTCN_error("Using non-selected field lCLS_ConnectControl in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_lCLS__ConnectControl;
}

PDU__BSSMAP__LCLS__ConnectControlAck& PDU__BSSMAP::lCLS__connectControlAck()
{
if (union_selection != ALT_lCLS__connectControlAck) {
clean_up();
field_lCLS__connectControlAck = new PDU__BSSMAP__LCLS__ConnectControlAck;
union_selection = ALT_lCLS__connectControlAck;
}
return *field_lCLS__connectControlAck;
}

const PDU__BSSMAP__LCLS__ConnectControlAck& PDU__BSSMAP::lCLS__connectControlAck() const
{
if (union_selection != ALT_lCLS__connectControlAck) TTCN_error("Using non-selected field lCLS_connectControlAck in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_lCLS__connectControlAck;
}

PDU__BSSMAP__LCLS__Notification& PDU__BSSMAP::lCLS__Notification()
{
if (union_selection != ALT_lCLS__Notification) {
clean_up();
field_lCLS__Notification = new PDU__BSSMAP__LCLS__Notification;
union_selection = ALT_lCLS__Notification;
}
return *field_lCLS__Notification;
}

const PDU__BSSMAP__LCLS__Notification& PDU__BSSMAP::lCLS__Notification() const
{
if (union_selection != ALT_lCLS__Notification) TTCN_error("Using non-selected field lCLS_Notification in a value of union type @BSSAP_Types.PDU_BSSMAP.");
return *field_lCLS__Notification;
}

boolean PDU__BSSMAP::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @BSSAP_Types.PDU_BSSMAP.");
return union_selection == checked_selection;
}

boolean PDU__BSSMAP::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean PDU__BSSMAP::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_assignmentRequest: return field_assignmentRequest->is_value();
case ALT_assignmentComplete: return field_assignmentComplete->is_value();
case ALT_assignmentFailure: return field_assignmentFailure->is_value();
case ALT_channelModifyRequest: return field_channelModifyRequest->is_value();
case ALT_block: return field_block->is_value();
case ALT_blockingAck: return field_blockingAck->is_value();
case ALT_bSSInvokeTrace: return field_bSSInvokeTrace->is_value();
case ALT_changeCircuit: return field_changeCircuit->is_value();
case ALT_changeCircuitAck: return field_changeCircuitAck->is_value();
case ALT_cipherModeCommand: return field_cipherModeCommand->is_value();
case ALT_cipherModeComplete: return field_cipherModeComplete->is_value();
case ALT_cipherModeReject: return field_cipherModeReject->is_value();
case ALT_circuitGroupBlock: return field_circuitGroupBlock->is_value();
case ALT_circuitGroupBlockingAck: return field_circuitGroupBlockingAck->is_value();
case ALT_circuitGroupUnblock: return field_circuitGroupUnblock->is_value();
case ALT_circuitGroupUnblockAck: return field_circuitGroupUnblockAck->is_value();
case ALT_classmarkRequest: return field_classmarkRequest->is_value();
case ALT_classmarkUpdate: return field_classmarkUpdate->is_value();
case ALT_clearCommand: return field_clearCommand->is_value();
case ALT_clearComplete: return field_clearComplete->is_value();
case ALT_clearRequest: return field_clearRequest->is_value();
case ALT_commonID: return field_commonID->is_value();
case ALT_completeLayer3Information: return field_completeLayer3Information->is_value();
case ALT_confusion: return field_confusion->is_value();
case ALT_connectionlessInformation: return field_connectionlessInformation->is_value();
case ALT_handoverCandidateEnquire: return field_handoverCandidateEnquire->is_value();
case ALT_handoverCandidateResponse: return field_handoverCandidateResponse->is_value();
case ALT_handoverCommand: return field_handoverCommand->is_value();
case ALT_handoverComplete: return field_handoverComplete->is_value();
case ALT_handoverDetect: return field_handoverDetect->is_value();
case ALT_handoverFailure: return field_handoverFailure->is_value();
case ALT_handoverPerformed: return field_handoverPerformed->is_value();
case ALT_handoverRequest: return field_handoverRequest->is_value();
case ALT_handoverRequestAck: return field_handoverRequestAck->is_value();
case ALT_handoverRequired: return field_handoverRequired->is_value();
case ALT_handoverRequiredReject: return field_handoverRequiredReject->is_value();
case ALT_handoverSucceeded: return field_handoverSucceeded->is_value();
case ALT_loadIndication: return field_loadIndication->is_value();
case ALT_lSAInformation: return field_lSAInformation->is_value();
case ALT_mSCInvokeTrace: return field_mSCInvokeTrace->is_value();
case ALT_overload: return field_overload->is_value();
case ALT_paging: return field_paging->is_value();
case ALT_performLocationAbort: return field_performLocationAbort->is_value();
case ALT_performLocationRequest: return field_performLocationRequest->is_value();
case ALT_performLocationResponse: return field_performLocationResponse->is_value();
case ALT_queueingIndication: return field_queueingIndication->is_value();
case ALT_reset: return field_reset->is_value();
case ALT_resetAck: return field_resetAck->is_value();
case ALT_resetCircuit: return field_resetCircuit->is_value();
case ALT_resetCircuitAck: return field_resetCircuitAck->is_value();
case ALT_resourceIndication: return field_resourceIndication->is_value();
case ALT_resourceRequest: return field_resourceRequest->is_value();
case ALT_sAPInReject: return field_sAPInReject->is_value();
case ALT_suspend: return field_suspend->is_value();
case ALT_resume: return field_resume->is_value();
case ALT_unblock: return field_unblock->is_value();
case ALT_unblockAck: return field_unblockAck->is_value();
case ALT_unequippedCircuit: return field_unequippedCircuit->is_value();
case ALT_uplinkRequest: return field_uplinkRequest->is_value();
case ALT_uplinkRequestAck: return field_uplinkRequestAck->is_value();
case ALT_uplinkRequestConfirmation: return field_uplinkRequestConfirmation->is_value();
case ALT_uplinkReleaseIndication: return field_uplinkReleaseIndication->is_value();
case ALT_uplinkRejectCommand: return field_uplinkRejectCommand->is_value();
case ALT_uplinkReleaseCommand: return field_uplinkReleaseCommand->is_value();
case ALT_uplinkSeizedCommand: return field_uplinkSeizedCommand->is_value();
case ALT_vGCS__VBSSetup: return field_vGCS__VBSSetup->is_value();
case ALT_vGCS__VBSSetupAck: return field_vGCS__VBSSetupAck->is_value();
case ALT_vGCS__VBSSetupRefuse: return field_vGCS__VBSSetupRefuse->is_value();
case ALT_vGCS__VBSAssignmentRequest: return field_vGCS__VBSAssignmentRequest->is_value();
case ALT_vGCS__VBSAssignmentResult: return field_vGCS__VBSAssignmentResult->is_value();
case ALT_vGCS__VBSAssignmentFailure: return field_vGCS__VBSAssignmentFailure->is_value();
case ALT_vGCS__VBSQueuingIndication: return field_vGCS__VBSQueuingIndication->is_value();
case ALT_vGCS__AdditionalInformation: return field_vGCS__AdditionalInformation->is_value();
case ALT_vGCS__VBS__AreaCellInfo: return field_vGCS__VBS__AreaCellInfo->is_value();
case ALT_vGCS__VBS__AssignmentStatus: return field_vGCS__VBS__AssignmentStatus->is_value();
case ALT_vGCS__SMS: return field_vGCS__SMS->is_value();
case ALT_uplinkApplicationData: return field_uplinkApplicationData->is_value();
case ALT_notificationData: return field_notificationData->is_value();
case ALT_internalHandoverRequired: return field_internalHandoverRequired->is_value();
case ALT_internalHandoverRequiredReject: return field_internalHandoverRequiredReject->is_value();
case ALT_internalHandoverCommand: return field_internalHandoverCommand->is_value();
case ALT_internalHandoverEnquiry: return field_internalHandoverEnquiry->is_value();
case ALT_resetIPResource: return field_resetIPResource->is_value();
case ALT_resetIPResourceAck: return field_resetIPResourceAck->is_value();
case ALT_rerouteCommand: return field_rerouteCommand->is_value();
case ALT_rerouteComplete: return field_rerouteComplete->is_value();
case ALT_lCLS__ConnectControl: return field_lCLS__ConnectControl->is_value();
case ALT_lCLS__connectControlAck: return field_lCLS__connectControlAck->is_value();
case ALT_lCLS__Notification: return field_lCLS__Notification->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void PDU__BSSMAP::clean_up()
{
switch (union_selection) {
case ALT_assignmentRequest:
  delete field_assignmentRequest;
  break;
case ALT_assignmentComplete:
  delete field_assignmentComplete;
  break;
case ALT_assignmentFailure:
  delete field_assignmentFailure;
  break;
case ALT_channelModifyRequest:
  delete field_channelModifyRequest;
  break;
case ALT_block:
  delete field_block;
  break;
case ALT_blockingAck:
  delete field_blockingAck;
  break;
case ALT_bSSInvokeTrace:
  delete field_bSSInvokeTrace;
  break;
case ALT_changeCircuit:
  delete field_changeCircuit;
  break;
case ALT_changeCircuitAck:
  delete field_changeCircuitAck;
  break;
case ALT_cipherModeCommand:
  delete field_cipherModeCommand;
  break;
case ALT_cipherModeComplete:
  delete field_cipherModeComplete;
  break;
case ALT_cipherModeReject:
  delete field_cipherModeReject;
  break;
case ALT_circuitGroupBlock:
  delete field_circuitGroupBlock;
  break;
case ALT_circuitGroupBlockingAck:
  delete field_circuitGroupBlockingAck;
  break;
case ALT_circuitGroupUnblock:
  delete field_circuitGroupUnblock;
  break;
case ALT_circuitGroupUnblockAck:
  delete field_circuitGroupUnblockAck;
  break;
case ALT_classmarkRequest:
  delete field_classmarkRequest;
  break;
case ALT_classmarkUpdate:
  delete field_classmarkUpdate;
  break;
case ALT_clearCommand:
  delete field_clearCommand;
  break;
case ALT_clearComplete:
  delete field_clearComplete;
  break;
case ALT_clearRequest:
  delete field_clearRequest;
  break;
case ALT_commonID:
  delete field_commonID;
  break;
case ALT_completeLayer3Information:
  delete field_completeLayer3Information;
  break;
case ALT_confusion:
  delete field_confusion;
  break;
case ALT_connectionlessInformation:
  delete field_connectionlessInformation;
  break;
case ALT_handoverCandidateEnquire:
  delete field_handoverCandidateEnquire;
  break;
case ALT_handoverCandidateResponse:
  delete field_handoverCandidateResponse;
  break;
case ALT_handoverCommand:
  delete field_handoverCommand;
  break;
case ALT_handoverComplete:
  delete field_handoverComplete;
  break;
case ALT_handoverDetect:
  delete field_handoverDetect;
  break;
case ALT_handoverFailure:
  delete field_handoverFailure;
  break;
case ALT_handoverPerformed:
  delete field_handoverPerformed;
  break;
case ALT_handoverRequest:
  delete field_handoverRequest;
  break;
case ALT_handoverRequestAck:
  delete field_handoverRequestAck;
  break;
case ALT_handoverRequired:
  delete field_handoverRequired;
  break;
case ALT_handoverRequiredReject:
  delete field_handoverRequiredReject;
  break;
case ALT_handoverSucceeded:
  delete field_handoverSucceeded;
  break;
case ALT_loadIndication:
  delete field_loadIndication;
  break;
case ALT_lSAInformation:
  delete field_lSAInformation;
  break;
case ALT_mSCInvokeTrace:
  delete field_mSCInvokeTrace;
  break;
case ALT_overload:
  delete field_overload;
  break;
case ALT_paging:
  delete field_paging;
  break;
case ALT_performLocationAbort:
  delete field_performLocationAbort;
  break;
case ALT_performLocationRequest:
  delete field_performLocationRequest;
  break;
case ALT_performLocationResponse:
  delete field_performLocationResponse;
  break;
case ALT_queueingIndication:
  delete field_queueingIndication;
  break;
case ALT_reset:
  delete field_reset;
  break;
case ALT_resetAck:
  delete field_resetAck;
  break;
case ALT_resetCircuit:
  delete field_resetCircuit;
  break;
case ALT_resetCircuitAck:
  delete field_resetCircuitAck;
  break;
case ALT_resourceIndication:
  delete field_resourceIndication;
  break;
case ALT_resourceRequest:
  delete field_resourceRequest;
  break;
case ALT_sAPInReject:
  delete field_sAPInReject;
  break;
case ALT_suspend:
  delete field_suspend;
  break;
case ALT_resume:
  delete field_resume;
  break;
case ALT_unblock:
  delete field_unblock;
  break;
case ALT_unblockAck:
  delete field_unblockAck;
  break;
case ALT_unequippedCircuit:
  delete field_unequippedCircuit;
  break;
case ALT_uplinkRequest:
  delete field_uplinkRequest;
  break;
case ALT_uplinkRequestAck:
  delete field_uplinkRequestAck;
  break;
case ALT_uplinkRequestConfirmation:
  delete field_uplinkRequestConfirmation;
  break;
case ALT_uplinkReleaseIndication:
  delete field_uplinkReleaseIndication;
  break;
case ALT_uplinkRejectCommand:
  delete field_uplinkRejectCommand;
  break;
case ALT_uplinkReleaseCommand:
  delete field_uplinkReleaseCommand;
  break;
case ALT_uplinkSeizedCommand:
  delete field_uplinkSeizedCommand;
  break;
case ALT_vGCS__VBSSetup:
  delete field_vGCS__VBSSetup;
  break;
case ALT_vGCS__VBSSetupAck:
  delete field_vGCS__VBSSetupAck;
  break;
case ALT_vGCS__VBSSetupRefuse:
  delete field_vGCS__VBSSetupRefuse;
  break;
case ALT_vGCS__VBSAssignmentRequest:
  delete field_vGCS__VBSAssignmentRequest;
  break;
case ALT_vGCS__VBSAssignmentResult:
  delete field_vGCS__VBSAssignmentResult;
  break;
case ALT_vGCS__VBSAssignmentFailure:
  delete field_vGCS__VBSAssignmentFailure;
  break;
case ALT_vGCS__VBSQueuingIndication:
  delete field_vGCS__VBSQueuingIndication;
  break;
case ALT_vGCS__AdditionalInformation:
  delete field_vGCS__AdditionalInformation;
  break;
case ALT_vGCS__VBS__AreaCellInfo:
  delete field_vGCS__VBS__AreaCellInfo;
  break;
case ALT_vGCS__VBS__AssignmentStatus:
  delete field_vGCS__VBS__AssignmentStatus;
  break;
case ALT_vGCS__SMS:
  delete field_vGCS__SMS;
  break;
case ALT_uplinkApplicationData:
  delete field_uplinkApplicationData;
  break;
case ALT_notificationData:
  delete field_notificationData;
  break;
case ALT_internalHandoverRequired:
  delete field_internalHandoverRequired;
  break;
case ALT_internalHandoverRequiredReject:
  delete field_internalHandoverRequiredReject;
  break;
case ALT_internalHandoverCommand:
  delete field_internalHandoverCommand;
  break;
case ALT_internalHandoverEnquiry:
  delete field_internalHandoverEnquiry;
  break;
case ALT_resetIPResource:
  delete field_resetIPResource;
  break;
case ALT_resetIPResourceAck:
  delete field_resetIPResourceAck;
  break;
case ALT_rerouteCommand:
  delete field_rerouteCommand;
  break;
case ALT_rerouteComplete:
  delete field_rerouteComplete;
  break;
case ALT_lCLS__ConnectControl:
  delete field_lCLS__ConnectControl;
  break;
case ALT_lCLS__connectControlAck:
  delete field_lCLS__connectControlAck;
  break;
case ALT_lCLS__Notification:
  delete field_lCLS__Notification;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void PDU__BSSMAP::log() const
{
switch (union_selection) {
case ALT_assignmentRequest:
TTCN_Logger::log_event_str("{ assignmentRequest := ");
field_assignmentRequest->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_assignmentComplete:
TTCN_Logger::log_event_str("{ assignmentComplete := ");
field_assignmentComplete->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_assignmentFailure:
TTCN_Logger::log_event_str("{ assignmentFailure := ");
field_assignmentFailure->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_channelModifyRequest:
TTCN_Logger::log_event_str("{ channelModifyRequest := ");
field_channelModifyRequest->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_block:
TTCN_Logger::log_event_str("{ block := ");
field_block->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_blockingAck:
TTCN_Logger::log_event_str("{ blockingAck := ");
field_blockingAck->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_bSSInvokeTrace:
TTCN_Logger::log_event_str("{ bSSInvokeTrace := ");
field_bSSInvokeTrace->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_changeCircuit:
TTCN_Logger::log_event_str("{ changeCircuit := ");
field_changeCircuit->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_changeCircuitAck:
TTCN_Logger::log_event_str("{ changeCircuitAck := ");
field_changeCircuitAck->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cipherModeCommand:
TTCN_Logger::log_event_str("{ cipherModeCommand := ");
field_cipherModeCommand->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cipherModeComplete:
TTCN_Logger::log_event_str("{ cipherModeComplete := ");
field_cipherModeComplete->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cipherModeReject:
TTCN_Logger::log_event_str("{ cipherModeReject := ");
field_cipherModeReject->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_circuitGroupBlock:
TTCN_Logger::log_event_str("{ circuitGroupBlock := ");
field_circuitGroupBlock->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_circuitGroupBlockingAck:
TTCN_Logger::log_event_str("{ circuitGroupBlockingAck := ");
field_circuitGroupBlockingAck->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_circuitGroupUnblock:
TTCN_Logger::log_event_str("{ circuitGroupUnblock := ");
field_circuitGroupUnblock->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_circuitGroupUnblockAck:
TTCN_Logger::log_event_str("{ circuitGroupUnblockAck := ");
field_circuitGroupUnblockAck->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_classmarkRequest:
TTCN_Logger::log_event_str("{ classmarkRequest := ");
field_classmarkRequest->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_classmarkUpdate:
TTCN_Logger::log_event_str("{ classmarkUpdate := ");
field_classmarkUpdate->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_clearCommand:
TTCN_Logger::log_event_str("{ clearCommand := ");
field_clearCommand->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_clearComplete:
TTCN_Logger::log_event_str("{ clearComplete := ");
field_clearComplete->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_clearRequest:
TTCN_Logger::log_event_str("{ clearRequest := ");
field_clearRequest->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_commonID:
TTCN_Logger::log_event_str("{ commonID := ");
field_commonID->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_completeLayer3Information:
TTCN_Logger::log_event_str("{ completeLayer3Information := ");
field_completeLayer3Information->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_confusion:
TTCN_Logger::log_event_str("{ confusion := ");
field_confusion->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_connectionlessInformation:
TTCN_Logger::log_event_str("{ connectionlessInformation := ");
field_connectionlessInformation->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_handoverCandidateEnquire:
TTCN_Logger::log_event_str("{ handoverCandidateEnquire := ");
field_handoverCandidateEnquire->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_handoverCandidateResponse:
TTCN_Logger::log_event_str("{ handoverCandidateResponse := ");
field_handoverCandidateResponse->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_handoverCommand:
TTCN_Logger::log_event_str("{ handoverCommand := ");
field_handoverCommand->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_handoverComplete:
TTCN_Logger::log_event_str("{ handoverComplete := ");
field_handoverComplete->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_handoverDetect:
TTCN_Logger::log_event_str("{ handoverDetect := ");
field_handoverDetect->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_handoverFailure:
TTCN_Logger::log_event_str("{ handoverFailure := ");
field_handoverFailure->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_handoverPerformed:
TTCN_Logger::log_event_str("{ handoverPerformed := ");
field_handoverPerformed->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_handoverRequest:
TTCN_Logger::log_event_str("{ handoverRequest := ");
field_handoverRequest->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_handoverRequestAck:
TTCN_Logger::log_event_str("{ handoverRequestAck := ");
field_handoverRequestAck->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_handoverRequired:
TTCN_Logger::log_event_str("{ handoverRequired := ");
field_handoverRequired->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_handoverRequiredReject:
TTCN_Logger::log_event_str("{ handoverRequiredReject := ");
field_handoverRequiredReject->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_handoverSucceeded:
TTCN_Logger::log_event_str("{ handoverSucceeded := ");
field_handoverSucceeded->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_loadIndication:
TTCN_Logger::log_event_str("{ loadIndication := ");
field_loadIndication->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_lSAInformation:
TTCN_Logger::log_event_str("{ lSAInformation := ");
field_lSAInformation->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_mSCInvokeTrace:
TTCN_Logger::log_event_str("{ mSCInvokeTrace := ");
field_mSCInvokeTrace->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_overload:
TTCN_Logger::log_event_str("{ overload := ");
field_overload->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_paging:
TTCN_Logger::log_event_str("{ paging := ");
field_paging->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_performLocationAbort:
TTCN_Logger::log_event_str("{ performLocationAbort := ");
field_performLocationAbort->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_performLocationRequest:
TTCN_Logger::log_event_str("{ performLocationRequest := ");
field_performLocationRequest->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_performLocationResponse:
TTCN_Logger::log_event_str("{ performLocationResponse := ");
field_performLocationResponse->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_queueingIndication:
TTCN_Logger::log_event_str("{ queueingIndication := ");
field_queueingIndication->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_reset:
TTCN_Logger::log_event_str("{ reset := ");
field_reset->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_resetAck:
TTCN_Logger::log_event_str("{ resetAck := ");
field_resetAck->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_resetCircuit:
TTCN_Logger::log_event_str("{ resetCircuit := ");
field_resetCircuit->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_resetCircuitAck:
TTCN_Logger::log_event_str("{ resetCircuitAck := ");
field_resetCircuitAck->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_resourceIndication:
TTCN_Logger::log_event_str("{ resourceIndication := ");
field_resourceIndication->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_resourceRequest:
TTCN_Logger::log_event_str("{ resourceRequest := ");
field_resourceRequest->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_sAPInReject:
TTCN_Logger::log_event_str("{ sAPInReject := ");
field_sAPInReject->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_suspend:
TTCN_Logger::log_event_str("{ suspend := ");
field_suspend->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_resume:
TTCN_Logger::log_event_str("{ resume := ");
field_resume->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_unblock:
TTCN_Logger::log_event_str("{ unblock := ");
field_unblock->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_unblockAck:
TTCN_Logger::log_event_str("{ unblockAck := ");
field_unblockAck->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_unequippedCircuit:
TTCN_Logger::log_event_str("{ unequippedCircuit := ");
field_unequippedCircuit->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_uplinkRequest:
TTCN_Logger::log_event_str("{ uplinkRequest := ");
field_uplinkRequest->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_uplinkRequestAck:
TTCN_Logger::log_event_str("{ uplinkRequestAck := ");
field_uplinkRequestAck->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_uplinkRequestConfirmation:
TTCN_Logger::log_event_str("{ uplinkRequestConfirmation := ");
field_uplinkRequestConfirmation->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_uplinkReleaseIndication:
TTCN_Logger::log_event_str("{ uplinkReleaseIndication := ");
field_uplinkReleaseIndication->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_uplinkRejectCommand:
TTCN_Logger::log_event_str("{ uplinkRejectCommand := ");
field_uplinkRejectCommand->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_uplinkReleaseCommand:
TTCN_Logger::log_event_str("{ uplinkReleaseCommand := ");
field_uplinkReleaseCommand->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_uplinkSeizedCommand:
TTCN_Logger::log_event_str("{ uplinkSeizedCommand := ");
field_uplinkSeizedCommand->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_vGCS__VBSSetup:
TTCN_Logger::log_event_str("{ vGCS_VBSSetup := ");
field_vGCS__VBSSetup->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_vGCS__VBSSetupAck:
TTCN_Logger::log_event_str("{ vGCS_VBSSetupAck := ");
field_vGCS__VBSSetupAck->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_vGCS__VBSSetupRefuse:
TTCN_Logger::log_event_str("{ vGCS_VBSSetupRefuse := ");
field_vGCS__VBSSetupRefuse->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_vGCS__VBSAssignmentRequest:
TTCN_Logger::log_event_str("{ vGCS_VBSAssignmentRequest := ");
field_vGCS__VBSAssignmentRequest->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_vGCS__VBSAssignmentResult:
TTCN_Logger::log_event_str("{ vGCS_VBSAssignmentResult := ");
field_vGCS__VBSAssignmentResult->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_vGCS__VBSAssignmentFailure:
TTCN_Logger::log_event_str("{ vGCS_VBSAssignmentFailure := ");
field_vGCS__VBSAssignmentFailure->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_vGCS__VBSQueuingIndication:
TTCN_Logger::log_event_str("{ vGCS_VBSQueuingIndication := ");
field_vGCS__VBSQueuingIndication->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_vGCS__AdditionalInformation:
TTCN_Logger::log_event_str("{ vGCS_AdditionalInformation := ");
field_vGCS__AdditionalInformation->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_vGCS__VBS__AreaCellInfo:
TTCN_Logger::log_event_str("{ vGCS_VBS_AreaCellInfo := ");
field_vGCS__VBS__AreaCellInfo->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_vGCS__VBS__AssignmentStatus:
TTCN_Logger::log_event_str("{ vGCS_VBS_AssignmentStatus := ");
field_vGCS__VBS__AssignmentStatus->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_vGCS__SMS:
TTCN_Logger::log_event_str("{ vGCS_SMS := ");
field_vGCS__SMS->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_uplinkApplicationData:
TTCN_Logger::log_event_str("{ uplinkApplicationData := ");
field_uplinkApplicationData->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_notificationData:
TTCN_Logger::log_event_str("{ notificationData := ");
field_notificationData->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_internalHandoverRequired:
TTCN_Logger::log_event_str("{ internalHandoverRequired := ");
field_internalHandoverRequired->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_internalHandoverRequiredReject:
TTCN_Logger::log_event_str("{ internalHandoverRequiredReject := ");
field_internalHandoverRequiredReject->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_internalHandoverCommand:
TTCN_Logger::log_event_str("{ internalHandoverCommand := ");
field_internalHandoverCommand->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_internalHandoverEnquiry:
TTCN_Logger::log_event_str("{ internalHandoverEnquiry := ");
field_internalHandoverEnquiry->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_resetIPResource:
TTCN_Logger::log_event_str("{ resetIPResource := ");
field_resetIPResource->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_resetIPResourceAck:
TTCN_Logger::log_event_str("{ resetIPResourceAck := ");
field_resetIPResourceAck->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_rerouteCommand:
TTCN_Logger::log_event_str("{ rerouteCommand := ");
field_rerouteCommand->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_rerouteComplete:
TTCN_Logger::log_event_str("{ rerouteComplete := ");
field_rerouteComplete->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_lCLS__ConnectControl:
TTCN_Logger::log_event_str("{ lCLS_ConnectControl := ");
field_lCLS__ConnectControl->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_lCLS__connectControlAck:
TTCN_Logger::log_event_str("{ lCLS_connectControlAck := ");
field_lCLS__connectControlAck->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_lCLS__Notification:
TTCN_Logger::log_event_str("{ lCLS_Notification := ");
field_lCLS__Notification->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void PDU__BSSMAP::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "assignmentRequest")) {
    assignmentRequest().set_param(*mp_last);
    if (!assignmentRequest().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "assignmentComplete")) {
    assignmentComplete().set_param(*mp_last);
    if (!assignmentComplete().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "assignmentFailure")) {
    assignmentFailure().set_param(*mp_last);
    if (!assignmentFailure().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "channelModifyRequest")) {
    channelModifyRequest().set_param(*mp_last);
    if (!channelModifyRequest().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "block")) {
    block().set_param(*mp_last);
    if (!block().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "blockingAck")) {
    blockingAck().set_param(*mp_last);
    if (!blockingAck().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "bSSInvokeTrace")) {
    bSSInvokeTrace().set_param(*mp_last);
    if (!bSSInvokeTrace().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "changeCircuit")) {
    changeCircuit().set_param(*mp_last);
    if (!changeCircuit().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "changeCircuitAck")) {
    changeCircuitAck().set_param(*mp_last);
    if (!changeCircuitAck().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cipherModeCommand")) {
    cipherModeCommand().set_param(*mp_last);
    if (!cipherModeCommand().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cipherModeComplete")) {
    cipherModeComplete().set_param(*mp_last);
    if (!cipherModeComplete().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cipherModeReject")) {
    cipherModeReject().set_param(*mp_last);
    if (!cipherModeReject().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "circuitGroupBlock")) {
    circuitGroupBlock().set_param(*mp_last);
    if (!circuitGroupBlock().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "circuitGroupBlockingAck")) {
    circuitGroupBlockingAck().set_param(*mp_last);
    if (!circuitGroupBlockingAck().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "circuitGroupUnblock")) {
    circuitGroupUnblock().set_param(*mp_last);
    if (!circuitGroupUnblock().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "circuitGroupUnblockAck")) {
    circuitGroupUnblockAck().set_param(*mp_last);
    if (!circuitGroupUnblockAck().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "classmarkRequest")) {
    classmarkRequest().set_param(*mp_last);
    if (!classmarkRequest().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "classmarkUpdate")) {
    classmarkUpdate().set_param(*mp_last);
    if (!classmarkUpdate().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "clearCommand")) {
    clearCommand().set_param(*mp_last);
    if (!clearCommand().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "clearComplete")) {
    clearComplete().set_param(*mp_last);
    if (!clearComplete().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "clearRequest")) {
    clearRequest().set_param(*mp_last);
    if (!clearRequest().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "commonID")) {
    commonID().set_param(*mp_last);
    if (!commonID().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "completeLayer3Information")) {
    completeLayer3Information().set_param(*mp_last);
    if (!completeLayer3Information().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "confusion")) {
    confusion().set_param(*mp_last);
    if (!confusion().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "connectionlessInformation")) {
    connectionlessInformation().set_param(*mp_last);
    if (!connectionlessInformation().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "handoverCandidateEnquire")) {
    handoverCandidateEnquire().set_param(*mp_last);
    if (!handoverCandidateEnquire().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "handoverCandidateResponse")) {
    handoverCandidateResponse().set_param(*mp_last);
    if (!handoverCandidateResponse().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "handoverCommand")) {
    handoverCommand().set_param(*mp_last);
    if (!handoverCommand().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "handoverComplete")) {
    handoverComplete().set_param(*mp_last);
    if (!handoverComplete().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "handoverDetect")) {
    handoverDetect().set_param(*mp_last);
    if (!handoverDetect().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "handoverFailure")) {
    handoverFailure().set_param(*mp_last);
    if (!handoverFailure().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "handoverPerformed")) {
    handoverPerformed().set_param(*mp_last);
    if (!handoverPerformed().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "handoverRequest")) {
    handoverRequest().set_param(*mp_last);
    if (!handoverRequest().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "handoverRequestAck")) {
    handoverRequestAck().set_param(*mp_last);
    if (!handoverRequestAck().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "handoverRequired")) {
    handoverRequired().set_param(*mp_last);
    if (!handoverRequired().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "handoverRequiredReject")) {
    handoverRequiredReject().set_param(*mp_last);
    if (!handoverRequiredReject().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "handoverSucceeded")) {
    handoverSucceeded().set_param(*mp_last);
    if (!handoverSucceeded().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "loadIndication")) {
    loadIndication().set_param(*mp_last);
    if (!loadIndication().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "lSAInformation")) {
    lSAInformation().set_param(*mp_last);
    if (!lSAInformation().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "mSCInvokeTrace")) {
    mSCInvokeTrace().set_param(*mp_last);
    if (!mSCInvokeTrace().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "overload")) {
    overload().set_param(*mp_last);
    if (!overload().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "paging")) {
    paging().set_param(*mp_last);
    if (!paging().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "performLocationAbort")) {
    performLocationAbort().set_param(*mp_last);
    if (!performLocationAbort().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "performLocationRequest")) {
    performLocationRequest().set_param(*mp_last);
    if (!performLocationRequest().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "performLocationResponse")) {
    performLocationResponse().set_param(*mp_last);
    if (!performLocationResponse().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "queueingIndication")) {
    queueingIndication().set_param(*mp_last);
    if (!queueingIndication().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "reset")) {
    reset().set_param(*mp_last);
    if (!reset().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "resetAck")) {
    resetAck().set_param(*mp_last);
    if (!resetAck().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "resetCircuit")) {
    resetCircuit().set_param(*mp_last);
    if (!resetCircuit().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "resetCircuitAck")) {
    resetCircuitAck().set_param(*mp_last);
    if (!resetCircuitAck().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "resourceIndication")) {
    resourceIndication().set_param(*mp_last);
    if (!resourceIndication().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "resourceRequest")) {
    resourceRequest().set_param(*mp_last);
    if (!resourceRequest().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "sAPInReject")) {
    sAPInReject().set_param(*mp_last);
    if (!sAPInReject().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "suspend")) {
    suspend().set_param(*mp_last);
    if (!suspend().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "resume")) {
    resume().set_param(*mp_last);
    if (!resume().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "unblock")) {
    unblock().set_param(*mp_last);
    if (!unblock().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "unblockAck")) {
    unblockAck().set_param(*mp_last);
    if (!unblockAck().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "unequippedCircuit")) {
    unequippedCircuit().set_param(*mp_last);
    if (!unequippedCircuit().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "uplinkRequest")) {
    uplinkRequest().set_param(*mp_last);
    if (!uplinkRequest().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "uplinkRequestAck")) {
    uplinkRequestAck().set_param(*mp_last);
    if (!uplinkRequestAck().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "uplinkRequestConfirmation")) {
    uplinkRequestConfirmation().set_param(*mp_last);
    if (!uplinkRequestConfirmation().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "uplinkReleaseIndication")) {
    uplinkReleaseIndication().set_param(*mp_last);
    if (!uplinkReleaseIndication().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "uplinkRejectCommand")) {
    uplinkRejectCommand().set_param(*mp_last);
    if (!uplinkRejectCommand().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "uplinkReleaseCommand")) {
    uplinkReleaseCommand().set_param(*mp_last);
    if (!uplinkReleaseCommand().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "uplinkSeizedCommand")) {
    uplinkSeizedCommand().set_param(*mp_last);
    if (!uplinkSeizedCommand().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "vGCS_VBSSetup")) {
    vGCS__VBSSetup().set_param(*mp_last);
    if (!vGCS__VBSSetup().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "vGCS_VBSSetupAck")) {
    vGCS__VBSSetupAck().set_param(*mp_last);
    if (!vGCS__VBSSetupAck().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "vGCS_VBSSetupRefuse")) {
    vGCS__VBSSetupRefuse().set_param(*mp_last);
    if (!vGCS__VBSSetupRefuse().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "vGCS_VBSAssignmentRequest")) {
    vGCS__VBSAssignmentRequest().set_param(*mp_last);
    if (!vGCS__VBSAssignmentRequest().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "vGCS_VBSAssignmentResult")) {
    vGCS__VBSAssignmentResult().set_param(*mp_last);
    if (!vGCS__VBSAssignmentResult().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "vGCS_VBSAssignmentFailure")) {
    vGCS__VBSAssignmentFailure().set_param(*mp_last);
    if (!vGCS__VBSAssignmentFailure().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "vGCS_VBSQueuingIndication")) {
    vGCS__VBSQueuingIndication().set_param(*mp_last);
    if (!vGCS__VBSQueuingIndication().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "vGCS_AdditionalInformation")) {
    vGCS__AdditionalInformation().set_param(*mp_last);
    if (!vGCS__AdditionalInformation().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "vGCS_VBS_AreaCellInfo")) {
    vGCS__VBS__AreaCellInfo().set_param(*mp_last);
    if (!vGCS__VBS__AreaCellInfo().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "vGCS_VBS_AssignmentStatus")) {
    vGCS__VBS__AssignmentStatus().set_param(*mp_last);
    if (!vGCS__VBS__AssignmentStatus().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "vGCS_SMS")) {
    vGCS__SMS().set_param(*mp_last);
    if (!vGCS__SMS().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "uplinkApplicationData")) {
    uplinkApplicationData().set_param(*mp_last);
    if (!uplinkApplicationData().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "notificationData")) {
    notificationData().set_param(*mp_last);
    if (!notificationData().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "internalHandoverRequired")) {
    internalHandoverRequired().set_param(*mp_last);
    if (!internalHandoverRequired().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "internalHandoverRequiredReject")) {
    internalHandoverRequiredReject().set_param(*mp_last);
    if (!internalHandoverRequiredReject().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "internalHandoverCommand")) {
    internalHandoverCommand().set_param(*mp_last);
    if (!internalHandoverCommand().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "internalHandoverEnquiry")) {
    internalHandoverEnquiry().set_param(*mp_last);
    if (!internalHandoverEnquiry().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "resetIPResource")) {
    resetIPResource().set_param(*mp_last);
    if (!resetIPResource().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "resetIPResourceAck")) {
    resetIPResourceAck().set_param(*mp_last);
    if (!resetIPResourceAck().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "rerouteCommand")) {
    rerouteCommand().set_param(*mp_last);
    if (!rerouteCommand().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "rerouteComplete")) {
    rerouteComplete().set_param(*mp_last);
    if (!rerouteComplete().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "lCLS_ConnectControl")) {
    lCLS__ConnectControl().set_param(*mp_last);
    if (!lCLS__ConnectControl().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "lCLS_connectControlAck")) {
    lCLS__connectControlAck().set_param(*mp_last);
    if (!lCLS__connectControlAck().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "lCLS_Notification")) {
    lCLS__Notification().set_param(*mp_last);
    if (!lCLS__Notification().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @BSSAP_Types.PDU_BSSMAP.", last_name);
}

void PDU__BSSMAP::set_implicit_omit()
{
switch (union_selection) {
case ALT_assignmentRequest:
field_assignmentRequest->set_implicit_omit(); break;
case ALT_assignmentComplete:
field_assignmentComplete->set_implicit_omit(); break;
case ALT_assignmentFailure:
field_assignmentFailure->set_implicit_omit(); break;
case ALT_channelModifyRequest:
field_channelModifyRequest->set_implicit_omit(); break;
case ALT_block:
field_block->set_implicit_omit(); break;
case ALT_blockingAck:
field_blockingAck->set_implicit_omit(); break;
case ALT_bSSInvokeTrace:
field_bSSInvokeTrace->set_implicit_omit(); break;
case ALT_changeCircuit:
field_changeCircuit->set_implicit_omit(); break;
case ALT_changeCircuitAck:
field_changeCircuitAck->set_implicit_omit(); break;
case ALT_cipherModeCommand:
field_cipherModeCommand->set_implicit_omit(); break;
case ALT_cipherModeComplete:
field_cipherModeComplete->set_implicit_omit(); break;
case ALT_cipherModeReject:
field_cipherModeReject->set_implicit_omit(); break;
case ALT_circuitGroupBlock:
field_circuitGroupBlock->set_implicit_omit(); break;
case ALT_circuitGroupBlockingAck:
field_circuitGroupBlockingAck->set_implicit_omit(); break;
case ALT_circuitGroupUnblock:
field_circuitGroupUnblock->set_implicit_omit(); break;
case ALT_circuitGroupUnblockAck:
field_circuitGroupUnblockAck->set_implicit_omit(); break;
case ALT_classmarkRequest:
field_classmarkRequest->set_implicit_omit(); break;
case ALT_classmarkUpdate:
field_classmarkUpdate->set_implicit_omit(); break;
case ALT_clearCommand:
field_clearCommand->set_implicit_omit(); break;
case ALT_clearComplete:
field_clearComplete->set_implicit_omit(); break;
case ALT_clearRequest:
field_clearRequest->set_implicit_omit(); break;
case ALT_commonID:
field_commonID->set_implicit_omit(); break;
case ALT_completeLayer3Information:
field_completeLayer3Information->set_implicit_omit(); break;
case ALT_confusion:
field_confusion->set_implicit_omit(); break;
case ALT_connectionlessInformation:
field_connectionlessInformation->set_implicit_omit(); break;
case ALT_handoverCandidateEnquire:
field_handoverCandidateEnquire->set_implicit_omit(); break;
case ALT_handoverCandidateResponse:
field_handoverCandidateResponse->set_implicit_omit(); break;
case ALT_handoverCommand:
field_handoverCommand->set_implicit_omit(); break;
case ALT_handoverComplete:
field_handoverComplete->set_implicit_omit(); break;
case ALT_handoverDetect:
field_handoverDetect->set_implicit_omit(); break;
case ALT_handoverFailure:
field_handoverFailure->set_implicit_omit(); break;
case ALT_handoverPerformed:
field_handoverPerformed->set_implicit_omit(); break;
case ALT_handoverRequest:
field_handoverRequest->set_implicit_omit(); break;
case ALT_handoverRequestAck:
field_handoverRequestAck->set_implicit_omit(); break;
case ALT_handoverRequired:
field_handoverRequired->set_implicit_omit(); break;
case ALT_handoverRequiredReject:
field_handoverRequiredReject->set_implicit_omit(); break;
case ALT_handoverSucceeded:
field_handoverSucceeded->set_implicit_omit(); break;
case ALT_loadIndication:
field_loadIndication->set_implicit_omit(); break;
case ALT_lSAInformation:
field_lSAInformation->set_implicit_omit(); break;
case ALT_mSCInvokeTrace:
field_mSCInvokeTrace->set_implicit_omit(); break;
case ALT_overload:
field_overload->set_implicit_omit(); break;
case ALT_paging:
field_paging->set_implicit_omit(); break;
case ALT_performLocationAbort:
field_performLocationAbort->set_implicit_omit(); break;
case ALT_performLocationRequest:
field_performLocationRequest->set_implicit_omit(); break;
case ALT_performLocationResponse:
field_performLocationResponse->set_implicit_omit(); break;
case ALT_queueingIndication:
field_queueingIndication->set_implicit_omit(); break;
case ALT_reset:
field_reset->set_implicit_omit(); break;
case ALT_resetAck:
field_resetAck->set_implicit_omit(); break;
case ALT_resetCircuit:
field_resetCircuit->set_implicit_omit(); break;
case ALT_resetCircuitAck:
field_resetCircuitAck->set_implicit_omit(); break;
case ALT_resourceIndication:
field_resourceIndication->set_implicit_omit(); break;
case ALT_resourceRequest:
field_resourceRequest->set_implicit_omit(); break;
case ALT_sAPInReject:
field_sAPInReject->set_implicit_omit(); break;
case ALT_suspend:
field_suspend->set_implicit_omit(); break;
case ALT_resume:
field_resume->set_implicit_omit(); break;
case ALT_unblock:
field_unblock->set_implicit_omit(); break;
case ALT_unblockAck:
field_unblockAck->set_implicit_omit(); break;
case ALT_unequippedCircuit:
field_unequippedCircuit->set_implicit_omit(); break;
case ALT_uplinkRequest:
field_uplinkRequest->set_implicit_omit(); break;
case ALT_uplinkRequestAck:
field_uplinkRequestAck->set_implicit_omit(); break;
case ALT_uplinkRequestConfirmation:
field_uplinkRequestConfirmation->set_implicit_omit(); break;
case ALT_uplinkReleaseIndication:
field_uplinkReleaseIndication->set_implicit_omit(); break;
case ALT_uplinkRejectCommand:
field_uplinkRejectCommand->set_implicit_omit(); break;
case ALT_uplinkReleaseCommand:
field_uplinkReleaseCommand->set_implicit_omit(); break;
case ALT_uplinkSeizedCommand:
field_uplinkSeizedCommand->set_implicit_omit(); break;
case ALT_vGCS__VBSSetup:
field_vGCS__VBSSetup->set_implicit_omit(); break;
case ALT_vGCS__VBSSetupAck:
field_vGCS__VBSSetupAck->set_implicit_omit(); break;
case ALT_vGCS__VBSSetupRefuse:
field_vGCS__VBSSetupRefuse->set_implicit_omit(); break;
case ALT_vGCS__VBSAssignmentRequest:
field_vGCS__VBSAssignmentRequest->set_implicit_omit(); break;
case ALT_vGCS__VBSAssignmentResult:
field_vGCS__VBSAssignmentResult->set_implicit_omit(); break;
case ALT_vGCS__VBSAssignmentFailure:
field_vGCS__VBSAssignmentFailure->set_implicit_omit(); break;
case ALT_vGCS__VBSQueuingIndication:
field_vGCS__VBSQueuingIndication->set_implicit_omit(); break;
case ALT_vGCS__AdditionalInformation:
field_vGCS__AdditionalInformation->set_implicit_omit(); break;
case ALT_vGCS__VBS__AreaCellInfo:
field_vGCS__VBS__AreaCellInfo->set_implicit_omit(); break;
case ALT_vGCS__VBS__AssignmentStatus:
field_vGCS__VBS__AssignmentStatus->set_implicit_omit(); break;
case ALT_vGCS__SMS:
field_vGCS__SMS->set_implicit_omit(); break;
case ALT_uplinkApplicationData:
field_uplinkApplicationData->set_implicit_omit(); break;
case ALT_notificationData:
field_notificationData->set_implicit_omit(); break;
case ALT_internalHandoverRequired:
field_internalHandoverRequired->set_implicit_omit(); break;
case ALT_internalHandoverRequiredReject:
field_internalHandoverRequiredReject->set_implicit_omit(); break;
case ALT_internalHandoverCommand:
field_internalHandoverCommand->set_implicit_omit(); break;
case ALT_internalHandoverEnquiry:
field_internalHandoverEnquiry->set_implicit_omit(); break;
case ALT_resetIPResource:
field_resetIPResource->set_implicit_omit(); break;
case ALT_resetIPResourceAck:
field_resetIPResourceAck->set_implicit_omit(); break;
case ALT_rerouteCommand:
field_rerouteCommand->set_implicit_omit(); break;
case ALT_rerouteComplete:
field_rerouteComplete->set_implicit_omit(); break;
case ALT_lCLS__ConnectControl:
field_lCLS__ConnectControl->set_implicit_omit(); break;
case ALT_lCLS__connectControlAck:
field_lCLS__connectControlAck->set_implicit_omit(); break;
case ALT_lCLS__Notification:
field_lCLS__Notification->set_implicit_omit(); break;
default: break;
}
}

void PDU__BSSMAP::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_assignmentRequest:
field_assignmentRequest->encode_text(text_buf);
break;
case ALT_assignmentComplete:
field_assignmentComplete->encode_text(text_buf);
break;
case ALT_assignmentFailure:
field_assignmentFailure->encode_text(text_buf);
break;
case ALT_channelModifyRequest:
field_channelModifyRequest->encode_text(text_buf);
break;
case ALT_block:
field_block->encode_text(text_buf);
break;
case ALT_blockingAck:
field_blockingAck->encode_text(text_buf);
break;
case ALT_bSSInvokeTrace:
field_bSSInvokeTrace->encode_text(text_buf);
break;
case ALT_changeCircuit:
field_changeCircuit->encode_text(text_buf);
break;
case ALT_changeCircuitAck:
field_changeCircuitAck->encode_text(text_buf);
break;
case ALT_cipherModeCommand:
field_cipherModeCommand->encode_text(text_buf);
break;
case ALT_cipherModeComplete:
field_cipherModeComplete->encode_text(text_buf);
break;
case ALT_cipherModeReject:
field_cipherModeReject->encode_text(text_buf);
break;
case ALT_circuitGroupBlock:
field_circuitGroupBlock->encode_text(text_buf);
break;
case ALT_circuitGroupBlockingAck:
field_circuitGroupBlockingAck->encode_text(text_buf);
break;
case ALT_circuitGroupUnblock:
field_circuitGroupUnblock->encode_text(text_buf);
break;
case ALT_circuitGroupUnblockAck:
field_circuitGroupUnblockAck->encode_text(text_buf);
break;
case ALT_classmarkRequest:
field_classmarkRequest->encode_text(text_buf);
break;
case ALT_classmarkUpdate:
field_classmarkUpdate->encode_text(text_buf);
break;
case ALT_clearCommand:
field_clearCommand->encode_text(text_buf);
break;
case ALT_clearComplete:
field_clearComplete->encode_text(text_buf);
break;
case ALT_clearRequest:
field_clearRequest->encode_text(text_buf);
break;
case ALT_commonID:
field_commonID->encode_text(text_buf);
break;
case ALT_completeLayer3Information:
field_completeLayer3Information->encode_text(text_buf);
break;
case ALT_confusion:
field_confusion->encode_text(text_buf);
break;
case ALT_connectionlessInformation:
field_connectionlessInformation->encode_text(text_buf);
break;
case ALT_handoverCandidateEnquire:
field_handoverCandidateEnquire->encode_text(text_buf);
break;
case ALT_handoverCandidateResponse:
field_handoverCandidateResponse->encode_text(text_buf);
break;
case ALT_handoverCommand:
field_handoverCommand->encode_text(text_buf);
break;
case ALT_handoverComplete:
field_handoverComplete->encode_text(text_buf);
break;
case ALT_handoverDetect:
field_handoverDetect->encode_text(text_buf);
break;
case ALT_handoverFailure:
field_handoverFailure->encode_text(text_buf);
break;
case ALT_handoverPerformed:
field_handoverPerformed->encode_text(text_buf);
break;
case ALT_handoverRequest:
field_handoverRequest->encode_text(text_buf);
break;
case ALT_handoverRequestAck:
field_handoverRequestAck->encode_text(text_buf);
break;
case ALT_handoverRequired:
field_handoverRequired->encode_text(text_buf);
break;
case ALT_handoverRequiredReject:
field_handoverRequiredReject->encode_text(text_buf);
break;
case ALT_handoverSucceeded:
field_handoverSucceeded->encode_text(text_buf);
break;
case ALT_loadIndication:
field_loadIndication->encode_text(text_buf);
break;
case ALT_lSAInformation:
field_lSAInformation->encode_text(text_buf);
break;
case ALT_mSCInvokeTrace:
field_mSCInvokeTrace->encode_text(text_buf);
break;
case ALT_overload:
field_overload->encode_text(text_buf);
break;
case ALT_paging:
field_paging->encode_text(text_buf);
break;
case ALT_performLocationAbort:
field_performLocationAbort->encode_text(text_buf);
break;
case ALT_performLocationRequest:
field_performLocationRequest->encode_text(text_buf);
break;
case ALT_performLocationResponse:
field_performLocationResponse->encode_text(text_buf);
break;
case ALT_queueingIndication:
field_queueingIndication->encode_text(text_buf);
break;
case ALT_reset:
field_reset->encode_text(text_buf);
break;
case ALT_resetAck:
field_resetAck->encode_text(text_buf);
break;
case ALT_resetCircuit:
field_resetCircuit->encode_text(text_buf);
break;
case ALT_resetCircuitAck:
field_resetCircuitAck->encode_text(text_buf);
break;
case ALT_resourceIndication:
field_resourceIndication->encode_text(text_buf);
break;
case ALT_resourceRequest:
field_resourceRequest->encode_text(text_buf);
break;
case ALT_sAPInReject:
field_sAPInReject->encode_text(text_buf);
break;
case ALT_suspend:
field_suspend->encode_text(text_buf);
break;
case ALT_resume:
field_resume->encode_text(text_buf);
break;
case ALT_unblock:
field_unblock->encode_text(text_buf);
break;
case ALT_unblockAck:
field_unblockAck->encode_text(text_buf);
break;
case ALT_unequippedCircuit:
field_unequippedCircuit->encode_text(text_buf);
break;
case ALT_uplinkRequest:
field_uplinkRequest->encode_text(text_buf);
break;
case ALT_uplinkRequestAck:
field_uplinkRequestAck->encode_text(text_buf);
break;
case ALT_uplinkRequestConfirmation:
field_uplinkRequestConfirmation->encode_text(text_buf);
break;
case ALT_uplinkReleaseIndication:
field_uplinkReleaseIndication->encode_text(text_buf);
break;
case ALT_uplinkRejectCommand:
field_uplinkRejectCommand->encode_text(text_buf);
break;
case ALT_uplinkReleaseCommand:
field_uplinkReleaseCommand->encode_text(text_buf);
break;
case ALT_uplinkSeizedCommand:
field_uplinkSeizedCommand->encode_text(text_buf);
break;
case ALT_vGCS__VBSSetup:
field_vGCS__VBSSetup->encode_text(text_buf);
break;
case ALT_vGCS__VBSSetupAck:
field_vGCS__VBSSetupAck->encode_text(text_buf);
break;
case ALT_vGCS__VBSSetupRefuse:
field_vGCS__VBSSetupRefuse->encode_text(text_buf);
break;
case ALT_vGCS__VBSAssignmentRequest:
field_vGCS__VBSAssignmentRequest->encode_text(text_buf);
break;
case ALT_vGCS__VBSAssignmentResult:
field_vGCS__VBSAssignmentResult->encode_text(text_buf);
break;
case ALT_vGCS__VBSAssignmentFailure:
field_vGCS__VBSAssignmentFailure->encode_text(text_buf);
break;
case ALT_vGCS__VBSQueuingIndication:
field_vGCS__VBSQueuingIndication->encode_text(text_buf);
break;
case ALT_vGCS__AdditionalInformation:
field_vGCS__AdditionalInformation->encode_text(text_buf);
break;
case ALT_vGCS__VBS__AreaCellInfo:
field_vGCS__VBS__AreaCellInfo->encode_text(text_buf);
break;
case ALT_vGCS__VBS__AssignmentStatus:
field_vGCS__VBS__AssignmentStatus->encode_text(text_buf);
break;
case ALT_vGCS__SMS:
field_vGCS__SMS->encode_text(text_buf);
break;
case ALT_uplinkApplicationData:
field_uplinkApplicationData->encode_text(text_buf);
break;
case ALT_notificationData:
field_notificationData->encode_text(text_buf);
break;
case ALT_internalHandoverRequired:
field_internalHandoverRequired->encode_text(text_buf);
break;
case ALT_internalHandoverRequiredReject:
field_internalHandoverRequiredReject->encode_text(text_buf);
break;
case ALT_internalHandoverCommand:
field_internalHandoverCommand->encode_text(text_buf);
break;
case ALT_internalHandoverEnquiry:
field_internalHandoverEnquiry->encode_text(text_buf);
break;
case ALT_resetIPResource:
field_resetIPResource->encode_text(text_buf);
break;
case ALT_resetIPResourceAck:
field_resetIPResourceAck->encode_text(text_buf);
break;
case ALT_rerouteCommand:
field_rerouteCommand->encode_text(text_buf);
break;
case ALT_rerouteComplete:
field_rerouteComplete->encode_text(text_buf);
break;
case ALT_lCLS__ConnectControl:
field_lCLS__ConnectControl->encode_text(text_buf);
break;
case ALT_lCLS__connectControlAck:
field_lCLS__connectControlAck->encode_text(text_buf);
break;
case ALT_lCLS__Notification:
field_lCLS__Notification->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @BSSAP_Types.PDU_BSSMAP.");
}
}

void PDU__BSSMAP::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_assignmentRequest:
assignmentRequest().decode_text(text_buf);
break;
case ALT_assignmentComplete:
assignmentComplete().decode_text(text_buf);
break;
case ALT_assignmentFailure:
assignmentFailure().decode_text(text_buf);
break;
case ALT_channelModifyRequest:
channelModifyRequest().decode_text(text_buf);
break;
case ALT_block:
block().decode_text(text_buf);
break;
case ALT_blockingAck:
blockingAck().decode_text(text_buf);
break;
case ALT_bSSInvokeTrace:
bSSInvokeTrace().decode_text(text_buf);
break;
case ALT_changeCircuit:
changeCircuit().decode_text(text_buf);
break;
case ALT_changeCircuitAck:
changeCircuitAck().decode_text(text_buf);
break;
case ALT_cipherModeCommand:
cipherModeCommand().decode_text(text_buf);
break;
case ALT_cipherModeComplete:
cipherModeComplete().decode_text(text_buf);
break;
case ALT_cipherModeReject:
cipherModeReject().decode_text(text_buf);
break;
case ALT_circuitGroupBlock:
circuitGroupBlock().decode_text(text_buf);
break;
case ALT_circuitGroupBlockingAck:
circuitGroupBlockingAck().decode_text(text_buf);
break;
case ALT_circuitGroupUnblock:
circuitGroupUnblock().decode_text(text_buf);
break;
case ALT_circuitGroupUnblockAck:
circuitGroupUnblockAck().decode_text(text_buf);
break;
case ALT_classmarkRequest:
classmarkRequest().decode_text(text_buf);
break;
case ALT_classmarkUpdate:
classmarkUpdate().decode_text(text_buf);
break;
case ALT_clearCommand:
clearCommand().decode_text(text_buf);
break;
case ALT_clearComplete:
clearComplete().decode_text(text_buf);
break;
case ALT_clearRequest:
clearRequest().decode_text(text_buf);
break;
case ALT_commonID:
commonID().decode_text(text_buf);
break;
case ALT_completeLayer3Information:
completeLayer3Information().decode_text(text_buf);
break;
case ALT_confusion:
confusion().decode_text(text_buf);
break;
case ALT_connectionlessInformation:
connectionlessInformation().decode_text(text_buf);
break;
case ALT_handoverCandidateEnquire:
handoverCandidateEnquire().decode_text(text_buf);
break;
case ALT_handoverCandidateResponse:
handoverCandidateResponse().decode_text(text_buf);
break;
case ALT_handoverCommand:
handoverCommand().decode_text(text_buf);
break;
case ALT_handoverComplete:
handoverComplete().decode_text(text_buf);
break;
case ALT_handoverDetect:
handoverDetect().decode_text(text_buf);
break;
case ALT_handoverFailure:
handoverFailure().decode_text(text_buf);
break;
case ALT_handoverPerformed:
handoverPerformed().decode_text(text_buf);
break;
case ALT_handoverRequest:
handoverRequest().decode_text(text_buf);
break;
case ALT_handoverRequestAck:
handoverRequestAck().decode_text(text_buf);
break;
case ALT_handoverRequired:
handoverRequired().decode_text(text_buf);
break;
case ALT_handoverRequiredReject:
handoverRequiredReject().decode_text(text_buf);
break;
case ALT_handoverSucceeded:
handoverSucceeded().decode_text(text_buf);
break;
case ALT_loadIndication:
loadIndication().decode_text(text_buf);
break;
case ALT_lSAInformation:
lSAInformation().decode_text(text_buf);
break;
case ALT_mSCInvokeTrace:
mSCInvokeTrace().decode_text(text_buf);
break;
case ALT_overload:
overload().decode_text(text_buf);
break;
case ALT_paging:
paging().decode_text(text_buf);
break;
case ALT_performLocationAbort:
performLocationAbort().decode_text(text_buf);
break;
case ALT_performLocationRequest:
performLocationRequest().decode_text(text_buf);
break;
case ALT_performLocationResponse:
performLocationResponse().decode_text(text_buf);
break;
case ALT_queueingIndication:
queueingIndication().decode_text(text_buf);
break;
case ALT_reset:
reset().decode_text(text_buf);
break;
case ALT_resetAck:
resetAck().decode_text(text_buf);
break;
case ALT_resetCircuit:
resetCircuit().decode_text(text_buf);
break;
case ALT_resetCircuitAck:
resetCircuitAck().decode_text(text_buf);
break;
case ALT_resourceIndication:
resourceIndication().decode_text(text_buf);
break;
case ALT_resourceRequest:
resourceRequest().decode_text(text_buf);
break;
case ALT_sAPInReject:
sAPInReject().decode_text(text_buf);
break;
case ALT_suspend:
suspend().decode_text(text_buf);
break;
case ALT_resume:
resume().decode_text(text_buf);
break;
case ALT_unblock:
unblock().decode_text(text_buf);
break;
case ALT_unblockAck:
unblockAck().decode_text(text_buf);
break;
case ALT_unequippedCircuit:
unequippedCircuit().decode_text(text_buf);
break;
case ALT_uplinkRequest:
uplinkRequest().decode_text(text_buf);
break;
case ALT_uplinkRequestAck:
uplinkRequestAck().decode_text(text_buf);
break;
case ALT_uplinkRequestConfirmation:
uplinkRequestConfirmation().decode_text(text_buf);
break;
case ALT_uplinkReleaseIndication:
uplinkReleaseIndication().decode_text(text_buf);
break;
case ALT_uplinkRejectCommand:
uplinkRejectCommand().decode_text(text_buf);
break;
case ALT_uplinkReleaseCommand:
uplinkReleaseCommand().decode_text(text_buf);
break;
case ALT_uplinkSeizedCommand:
uplinkSeizedCommand().decode_text(text_buf);
break;
case ALT_vGCS__VBSSetup:
vGCS__VBSSetup().decode_text(text_buf);
break;
case ALT_vGCS__VBSSetupAck:
vGCS__VBSSetupAck().decode_text(text_buf);
break;
case ALT_vGCS__VBSSetupRefuse:
vGCS__VBSSetupRefuse().decode_text(text_buf);
break;
case ALT_vGCS__VBSAssignmentRequest:
vGCS__VBSAssignmentRequest().decode_text(text_buf);
break;
case ALT_vGCS__VBSAssignmentResult:
vGCS__VBSAssignmentResult().decode_text(text_buf);
break;
case ALT_vGCS__VBSAssignmentFailure:
vGCS__VBSAssignmentFailure().decode_text(text_buf);
break;
case ALT_vGCS__VBSQueuingIndication:
vGCS__VBSQueuingIndication().decode_text(text_buf);
break;
case ALT_vGCS__AdditionalInformation:
vGCS__AdditionalInformation().decode_text(text_buf);
break;
case ALT_vGCS__VBS__AreaCellInfo:
vGCS__VBS__AreaCellInfo().decode_text(text_buf);
break;
case ALT_vGCS__VBS__AssignmentStatus:
vGCS__VBS__AssignmentStatus().decode_text(text_buf);
break;
case ALT_vGCS__SMS:
vGCS__SMS().decode_text(text_buf);
break;
case ALT_uplinkApplicationData:
uplinkApplicationData().decode_text(text_buf);
break;
case ALT_notificationData:
notificationData().decode_text(text_buf);
break;
case ALT_internalHandoverRequired:
internalHandoverRequired().decode_text(text_buf);
break;
case ALT_internalHandoverRequiredReject:
internalHandoverRequiredReject().decode_text(text_buf);
break;
case ALT_internalHandoverCommand:
internalHandoverCommand().decode_text(text_buf);
break;
case ALT_internalHandoverEnquiry:
internalHandoverEnquiry().decode_text(text_buf);
break;
case ALT_resetIPResource:
resetIPResource().decode_text(text_buf);
break;
case ALT_resetIPResourceAck:
resetIPResourceAck().decode_text(text_buf);
break;
case ALT_rerouteCommand:
rerouteCommand().decode_text(text_buf);
break;
case ALT_rerouteComplete:
rerouteComplete().decode_text(text_buf);
break;
case ALT_lCLS__ConnectControl:
lCLS__ConnectControl().decode_text(text_buf);
break;
case ALT_lCLS__connectControlAck:
lCLS__connectControlAck().decode_text(text_buf);
break;
case ALT_lCLS__Notification:
lCLS__Notification().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @BSSAP_Types.PDU_BSSMAP.");
}
}

void PDU__BSSMAP::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSMAP::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSMAP::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, PDU__BSSMAP__AssignmentRequest_descr_.raw->forceomit);
      decoded_length = assignmentRequest().RAW_decode(PDU__BSSMAP__AssignmentRequest_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, PDU__BSSMAP__AssignmentComplete_descr_.raw->forceomit);
      decoded_length = assignmentComplete().RAW_decode(PDU__BSSMAP__AssignmentComplete_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 2: {
      RAW_Force_Omit field_force_omit(2, force_omit, PDU__BSSMAP__AssignmentFailure_descr_.raw->forceomit);
      decoded_length = assignmentFailure().RAW_decode(PDU__BSSMAP__AssignmentFailure_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 3: {
      RAW_Force_Omit field_force_omit(3, force_omit, PDU__BSSMAP__ChannelModifyRequest_descr_.raw->forceomit);
      decoded_length = channelModifyRequest().RAW_decode(PDU__BSSMAP__ChannelModifyRequest_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 4: {
      RAW_Force_Omit field_force_omit(4, force_omit, PDU__BSSMAP__Block_descr_.raw->forceomit);
      decoded_length = block().RAW_decode(PDU__BSSMAP__Block_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 5: {
      RAW_Force_Omit field_force_omit(5, force_omit, PDU__BSSMAP__BlockingAck_descr_.raw->forceomit);
      decoded_length = blockingAck().RAW_decode(PDU__BSSMAP__BlockingAck_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 6: {
      RAW_Force_Omit field_force_omit(6, force_omit, PDU__BSSMAP__BSSInvokeTrace_descr_.raw->forceomit);
      decoded_length = bSSInvokeTrace().RAW_decode(PDU__BSSMAP__BSSInvokeTrace_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 7: {
      RAW_Force_Omit field_force_omit(7, force_omit, PDU__BSSMAP__ChangeCircuit_descr_.raw->forceomit);
      decoded_length = changeCircuit().RAW_decode(PDU__BSSMAP__ChangeCircuit_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 8: {
      RAW_Force_Omit field_force_omit(8, force_omit, PDU__BSSMAP__ChangeCircuitAck_descr_.raw->forceomit);
      decoded_length = changeCircuitAck().RAW_decode(PDU__BSSMAP__ChangeCircuitAck_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 9: {
      RAW_Force_Omit field_force_omit(9, force_omit, PDU__BSSMAP__CipherModeCommand_descr_.raw->forceomit);
      decoded_length = cipherModeCommand().RAW_decode(PDU__BSSMAP__CipherModeCommand_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 10: {
      RAW_Force_Omit field_force_omit(10, force_omit, PDU__BSSMAP__CipherModeComplete_descr_.raw->forceomit);
      decoded_length = cipherModeComplete().RAW_decode(PDU__BSSMAP__CipherModeComplete_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 11: {
      RAW_Force_Omit field_force_omit(11, force_omit, PDU__BSSMAP__CipherModeReject_descr_.raw->forceomit);
      decoded_length = cipherModeReject().RAW_decode(PDU__BSSMAP__CipherModeReject_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 12: {
      RAW_Force_Omit field_force_omit(12, force_omit, PDU__BSSMAP__CircuitGroupBlock_descr_.raw->forceomit);
      decoded_length = circuitGroupBlock().RAW_decode(PDU__BSSMAP__CircuitGroupBlock_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 13: {
      RAW_Force_Omit field_force_omit(13, force_omit, PDU__BSSMAP__CircuitGroupBlockingAck_descr_.raw->forceomit);
      decoded_length = circuitGroupBlockingAck().RAW_decode(PDU__BSSMAP__CircuitGroupBlockingAck_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 14: {
      RAW_Force_Omit field_force_omit(14, force_omit, PDU__BSSMAP__CircuitGroupUnblock_descr_.raw->forceomit);
      decoded_length = circuitGroupUnblock().RAW_decode(PDU__BSSMAP__CircuitGroupUnblock_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 15: {
      RAW_Force_Omit field_force_omit(15, force_omit, PDU__BSSMAP__CircuitGroupUnblockAck_descr_.raw->forceomit);
      decoded_length = circuitGroupUnblockAck().RAW_decode(PDU__BSSMAP__CircuitGroupUnblockAck_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 16: {
      RAW_Force_Omit field_force_omit(16, force_omit, PDU__BSSMAP__ClassmarkRequest_descr_.raw->forceomit);
      decoded_length = classmarkRequest().RAW_decode(PDU__BSSMAP__ClassmarkRequest_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 17: {
      RAW_Force_Omit field_force_omit(17, force_omit, PDU__BSSMAP__ClassmarkUpdate_descr_.raw->forceomit);
      decoded_length = classmarkUpdate().RAW_decode(PDU__BSSMAP__ClassmarkUpdate_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 18: {
      RAW_Force_Omit field_force_omit(18, force_omit, PDU__BSSMAP__ClearCommand_descr_.raw->forceomit);
      decoded_length = clearCommand().RAW_decode(PDU__BSSMAP__ClearCommand_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 19: {
      RAW_Force_Omit field_force_omit(19, force_omit, PDU__BSSMAP__ClearComplete_descr_.raw->forceomit);
      decoded_length = clearComplete().RAW_decode(PDU__BSSMAP__ClearComplete_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 20: {
      RAW_Force_Omit field_force_omit(20, force_omit, PDU__BSSMAP__ClearRequest_descr_.raw->forceomit);
      decoded_length = clearRequest().RAW_decode(PDU__BSSMAP__ClearRequest_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 21: {
      RAW_Force_Omit field_force_omit(21, force_omit, PDU__BSSMAP__CommonID_descr_.raw->forceomit);
      decoded_length = commonID().RAW_decode(PDU__BSSMAP__CommonID_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 22: {
      RAW_Force_Omit field_force_omit(22, force_omit, PDU__BSSMAP__CompleteLayer3Information_descr_.raw->forceomit);
      decoded_length = completeLayer3Information().RAW_decode(PDU__BSSMAP__CompleteLayer3Information_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 23: {
      RAW_Force_Omit field_force_omit(23, force_omit, PDU__BSSMAP__Confusion_descr_.raw->forceomit);
      decoded_length = confusion().RAW_decode(PDU__BSSMAP__Confusion_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 24: {
      RAW_Force_Omit field_force_omit(24, force_omit, PDU__BSSMAP__ConnectionlessInformation_descr_.raw->forceomit);
      decoded_length = connectionlessInformation().RAW_decode(PDU__BSSMAP__ConnectionlessInformation_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 25: {
      RAW_Force_Omit field_force_omit(25, force_omit, PDU__BSSMAP__HandoverCandidateEnquire_descr_.raw->forceomit);
      decoded_length = handoverCandidateEnquire().RAW_decode(PDU__BSSMAP__HandoverCandidateEnquire_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 26: {
      RAW_Force_Omit field_force_omit(26, force_omit, PDU__BSSMAP__HandoverCandidateResponse_descr_.raw->forceomit);
      decoded_length = handoverCandidateResponse().RAW_decode(PDU__BSSMAP__HandoverCandidateResponse_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 27: {
      RAW_Force_Omit field_force_omit(27, force_omit, PDU__BSSMAP__HandoverCommand_descr_.raw->forceomit);
      decoded_length = handoverCommand().RAW_decode(PDU__BSSMAP__HandoverCommand_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 28: {
      RAW_Force_Omit field_force_omit(28, force_omit, PDU__BSSMAP__HandoverComplete_descr_.raw->forceomit);
      decoded_length = handoverComplete().RAW_decode(PDU__BSSMAP__HandoverComplete_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 29: {
      RAW_Force_Omit field_force_omit(29, force_omit, PDU__BSSMAP__HandoverDetect_descr_.raw->forceomit);
      decoded_length = handoverDetect().RAW_decode(PDU__BSSMAP__HandoverDetect_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 30: {
      RAW_Force_Omit field_force_omit(30, force_omit, PDU__BSSMAP__HandoverFailure_descr_.raw->forceomit);
      decoded_length = handoverFailure().RAW_decode(PDU__BSSMAP__HandoverFailure_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 31: {
      RAW_Force_Omit field_force_omit(31, force_omit, PDU__BSSMAP__HandoverPerformed_descr_.raw->forceomit);
      decoded_length = handoverPerformed().RAW_decode(PDU__BSSMAP__HandoverPerformed_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 32: {
      RAW_Force_Omit field_force_omit(32, force_omit, PDU__BSSMAP__HandoverRequest_descr_.raw->forceomit);
      decoded_length = handoverRequest().RAW_decode(PDU__BSSMAP__HandoverRequest_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 33: {
      RAW_Force_Omit field_force_omit(33, force_omit, PDU__BSSMAP__HandoverRequestAck_descr_.raw->forceomit);
      decoded_length = handoverRequestAck().RAW_decode(PDU__BSSMAP__HandoverRequestAck_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 34: {
      RAW_Force_Omit field_force_omit(34, force_omit, PDU__BSSMAP__HandoverRequired_descr_.raw->forceomit);
      decoded_length = handoverRequired().RAW_decode(PDU__BSSMAP__HandoverRequired_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 35: {
      RAW_Force_Omit field_force_omit(35, force_omit, PDU__BSSMAP__HandoverRequiredReject_descr_.raw->forceomit);
      decoded_length = handoverRequiredReject().RAW_decode(PDU__BSSMAP__HandoverRequiredReject_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 36: {
      RAW_Force_Omit field_force_omit(36, force_omit, PDU__BSSMAP__HandoverSucceeded_descr_.raw->forceomit);
      decoded_length = handoverSucceeded().RAW_decode(PDU__BSSMAP__HandoverSucceeded_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 37: {
      RAW_Force_Omit field_force_omit(37, force_omit, PDU__BSSMAP__LoadIndication_descr_.raw->forceomit);
      decoded_length = loadIndication().RAW_decode(PDU__BSSMAP__LoadIndication_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 38: {
      RAW_Force_Omit field_force_omit(38, force_omit, PDU__BSSMAP__LSAInformation_descr_.raw->forceomit);
      decoded_length = lSAInformation().RAW_decode(PDU__BSSMAP__LSAInformation_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 39: {
      RAW_Force_Omit field_force_omit(39, force_omit, PDU__BSSMAP__MSCInvokeTrace_descr_.raw->forceomit);
      decoded_length = mSCInvokeTrace().RAW_decode(PDU__BSSMAP__MSCInvokeTrace_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 40: {
      RAW_Force_Omit field_force_omit(40, force_omit, PDU__BSSMAP__Overload_descr_.raw->forceomit);
      decoded_length = overload().RAW_decode(PDU__BSSMAP__Overload_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 41: {
      RAW_Force_Omit field_force_omit(41, force_omit, PDU__BSSMAP__Paging_descr_.raw->forceomit);
      decoded_length = paging().RAW_decode(PDU__BSSMAP__Paging_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 42: {
      RAW_Force_Omit field_force_omit(42, force_omit, PDU__BSSMAP__PerformLocationAbort_descr_.raw->forceomit);
      decoded_length = performLocationAbort().RAW_decode(PDU__BSSMAP__PerformLocationAbort_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 43: {
      RAW_Force_Omit field_force_omit(43, force_omit, PDU__BSSMAP__PerformLocationRequest_descr_.raw->forceomit);
      decoded_length = performLocationRequest().RAW_decode(PDU__BSSMAP__PerformLocationRequest_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 44: {
      RAW_Force_Omit field_force_omit(44, force_omit, PDU__BSSMAP__PerformLocationResponse_descr_.raw->forceomit);
      decoded_length = performLocationResponse().RAW_decode(PDU__BSSMAP__PerformLocationResponse_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 45: {
      RAW_Force_Omit field_force_omit(45, force_omit, PDU__BSSMAP__QueueingIndication_descr_.raw->forceomit);
      decoded_length = queueingIndication().RAW_decode(PDU__BSSMAP__QueueingIndication_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 46: {
      RAW_Force_Omit field_force_omit(46, force_omit, PDU__BSSMAP__Reset_descr_.raw->forceomit);
      decoded_length = reset().RAW_decode(PDU__BSSMAP__Reset_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 47: {
      RAW_Force_Omit field_force_omit(47, force_omit, PDU__BSSMAP__ResetAck_descr_.raw->forceomit);
      decoded_length = resetAck().RAW_decode(PDU__BSSMAP__ResetAck_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 48: {
      RAW_Force_Omit field_force_omit(48, force_omit, PDU__BSSMAP__ResetCircuit_descr_.raw->forceomit);
      decoded_length = resetCircuit().RAW_decode(PDU__BSSMAP__ResetCircuit_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 49: {
      RAW_Force_Omit field_force_omit(49, force_omit, PDU__BSSMAP__ResetCircuitAck_descr_.raw->forceomit);
      decoded_length = resetCircuitAck().RAW_decode(PDU__BSSMAP__ResetCircuitAck_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 50: {
      RAW_Force_Omit field_force_omit(50, force_omit, PDU__BSSMAP__ResourceIndication_descr_.raw->forceomit);
      decoded_length = resourceIndication().RAW_decode(PDU__BSSMAP__ResourceIndication_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 51: {
      RAW_Force_Omit field_force_omit(51, force_omit, PDU__BSSMAP__ResourceRequest_descr_.raw->forceomit);
      decoded_length = resourceRequest().RAW_decode(PDU__BSSMAP__ResourceRequest_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 52: {
      RAW_Force_Omit field_force_omit(52, force_omit, PDU__BSSMAP__SAPInReject_descr_.raw->forceomit);
      decoded_length = sAPInReject().RAW_decode(PDU__BSSMAP__SAPInReject_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 53: {
      RAW_Force_Omit field_force_omit(53, force_omit, PDU__BSSMAP__Suspend_descr_.raw->forceomit);
      decoded_length = suspend().RAW_decode(PDU__BSSMAP__Suspend_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 54: {
      RAW_Force_Omit field_force_omit(54, force_omit, PDU__BSSMAP__Resume_descr_.raw->forceomit);
      decoded_length = resume().RAW_decode(PDU__BSSMAP__Resume_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 55: {
      RAW_Force_Omit field_force_omit(55, force_omit, PDU__BSSMAP__Unblock_descr_.raw->forceomit);
      decoded_length = unblock().RAW_decode(PDU__BSSMAP__Unblock_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 56: {
      RAW_Force_Omit field_force_omit(56, force_omit, PDU__BSSMAP__UnblockAck_descr_.raw->forceomit);
      decoded_length = unblockAck().RAW_decode(PDU__BSSMAP__UnblockAck_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 57: {
      RAW_Force_Omit field_force_omit(57, force_omit, PDU__BSSMAP__UnequippedCircuit_descr_.raw->forceomit);
      decoded_length = unequippedCircuit().RAW_decode(PDU__BSSMAP__UnequippedCircuit_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 58: {
      RAW_Force_Omit field_force_omit(58, force_omit, PDU__BSSMAP__UplinkRequest_descr_.raw->forceomit);
      decoded_length = uplinkRequest().RAW_decode(PDU__BSSMAP__UplinkRequest_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 59: {
      RAW_Force_Omit field_force_omit(59, force_omit, PDU__BSSMAP__UplinkRequestAck_descr_.raw->forceomit);
      decoded_length = uplinkRequestAck().RAW_decode(PDU__BSSMAP__UplinkRequestAck_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 60: {
      RAW_Force_Omit field_force_omit(60, force_omit, PDU__BSSMAP__UplinkRequestConfirmation_descr_.raw->forceomit);
      decoded_length = uplinkRequestConfirmation().RAW_decode(PDU__BSSMAP__UplinkRequestConfirmation_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 61: {
      RAW_Force_Omit field_force_omit(61, force_omit, PDU__BSSMAP__UplinkReleaseIndication_descr_.raw->forceomit);
      decoded_length = uplinkReleaseIndication().RAW_decode(PDU__BSSMAP__UplinkReleaseIndication_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 62: {
      RAW_Force_Omit field_force_omit(62, force_omit, PDU__BSSMAP__UplinkRejectCommand_descr_.raw->forceomit);
      decoded_length = uplinkRejectCommand().RAW_decode(PDU__BSSMAP__UplinkRejectCommand_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 63: {
      RAW_Force_Omit field_force_omit(63, force_omit, PDU__BSSMAP__UplinkReleaseCommand_descr_.raw->forceomit);
      decoded_length = uplinkReleaseCommand().RAW_decode(PDU__BSSMAP__UplinkReleaseCommand_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 64: {
      RAW_Force_Omit field_force_omit(64, force_omit, PDU__BSSMAP__UplinkSeizedCommand_descr_.raw->forceomit);
      decoded_length = uplinkSeizedCommand().RAW_decode(PDU__BSSMAP__UplinkSeizedCommand_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 65: {
      RAW_Force_Omit field_force_omit(65, force_omit, PDU__BSSMAP__VGCS__VBSSetup_descr_.raw->forceomit);
      decoded_length = vGCS__VBSSetup().RAW_decode(PDU__BSSMAP__VGCS__VBSSetup_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 66: {
      RAW_Force_Omit field_force_omit(66, force_omit, PDU__BSSMAP__VGCS__VBSSetupAck_descr_.raw->forceomit);
      decoded_length = vGCS__VBSSetupAck().RAW_decode(PDU__BSSMAP__VGCS__VBSSetupAck_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 67: {
      RAW_Force_Omit field_force_omit(67, force_omit, PDU__BSSMAP__VGCS__VBSSetupRefuse_descr_.raw->forceomit);
      decoded_length = vGCS__VBSSetupRefuse().RAW_decode(PDU__BSSMAP__VGCS__VBSSetupRefuse_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 68: {
      RAW_Force_Omit field_force_omit(68, force_omit, PDU__BSSMAP__VGCS__VBSAssignmentRequest_descr_.raw->forceomit);
      decoded_length = vGCS__VBSAssignmentRequest().RAW_decode(PDU__BSSMAP__VGCS__VBSAssignmentRequest_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 69: {
      RAW_Force_Omit field_force_omit(69, force_omit, PDU__BSSMAP__VGCS__VBSAssignmentResult_descr_.raw->forceomit);
      decoded_length = vGCS__VBSAssignmentResult().RAW_decode(PDU__BSSMAP__VGCS__VBSAssignmentResult_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 70: {
      RAW_Force_Omit field_force_omit(70, force_omit, PDU__BSSMAP__VGCS__VBSAssignmentFailure_descr_.raw->forceomit);
      decoded_length = vGCS__VBSAssignmentFailure().RAW_decode(PDU__BSSMAP__VGCS__VBSAssignmentFailure_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 71: {
      RAW_Force_Omit field_force_omit(71, force_omit, PDU__BSSMAP__VGCS__VBSQueuingIndication_descr_.raw->forceomit);
      decoded_length = vGCS__VBSQueuingIndication().RAW_decode(PDU__BSSMAP__VGCS__VBSQueuingIndication_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 72: {
      RAW_Force_Omit field_force_omit(72, force_omit, PDU__BSSMAP__VGCS__AdditionalInformation_descr_.raw->forceomit);
      decoded_length = vGCS__AdditionalInformation().RAW_decode(PDU__BSSMAP__VGCS__AdditionalInformation_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 73: {
      RAW_Force_Omit field_force_omit(73, force_omit, PDU__BSSMAP__VGCS__VBS__AreaCellInfo_descr_.raw->forceomit);
      decoded_length = vGCS__VBS__AreaCellInfo().RAW_decode(PDU__BSSMAP__VGCS__VBS__AreaCellInfo_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 74: {
      RAW_Force_Omit field_force_omit(74, force_omit, PDU__BSSMAP__VGCS__VBS__AssignmentStatus_descr_.raw->forceomit);
      decoded_length = vGCS__VBS__AssignmentStatus().RAW_decode(PDU__BSSMAP__VGCS__VBS__AssignmentStatus_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 75: {
      RAW_Force_Omit field_force_omit(75, force_omit, PDU__BSSMAP__VGCS__SMS_descr_.raw->forceomit);
      decoded_length = vGCS__SMS().RAW_decode(PDU__BSSMAP__VGCS__SMS_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 76: {
      RAW_Force_Omit field_force_omit(76, force_omit, PDU__BSSMAP__UplinkApplicationData_descr_.raw->forceomit);
      decoded_length = uplinkApplicationData().RAW_decode(PDU__BSSMAP__UplinkApplicationData_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 77: {
      RAW_Force_Omit field_force_omit(77, force_omit, PDU__BSSMAP__NotificationData_descr_.raw->forceomit);
      decoded_length = notificationData().RAW_decode(PDU__BSSMAP__NotificationData_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 78: {
      RAW_Force_Omit field_force_omit(78, force_omit, PDU__BSSMAP__InternalHandoverRequired_descr_.raw->forceomit);
      decoded_length = internalHandoverRequired().RAW_decode(PDU__BSSMAP__InternalHandoverRequired_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 79: {
      RAW_Force_Omit field_force_omit(79, force_omit, PDU__BSSMAP__InternalHandoverRequiredReject_descr_.raw->forceomit);
      decoded_length = internalHandoverRequiredReject().RAW_decode(PDU__BSSMAP__InternalHandoverRequiredReject_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 80: {
      RAW_Force_Omit field_force_omit(80, force_omit, PDU__BSSMAP__InternalHandoverCommand_descr_.raw->forceomit);
      decoded_length = internalHandoverCommand().RAW_decode(PDU__BSSMAP__InternalHandoverCommand_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 81: {
      RAW_Force_Omit field_force_omit(81, force_omit, PDU__BSSMAP__InternalHandoverEnquiry_descr_.raw->forceomit);
      decoded_length = internalHandoverEnquiry().RAW_decode(PDU__BSSMAP__InternalHandoverEnquiry_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 82: {
      RAW_Force_Omit field_force_omit(82, force_omit, PDU__BSSMAP__ResetIPResource_descr_.raw->forceomit);
      decoded_length = resetIPResource().RAW_decode(PDU__BSSMAP__ResetIPResource_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 83: {
      RAW_Force_Omit field_force_omit(83, force_omit, PDU__BSSMAP__ResetIPResourceAck_descr_.raw->forceomit);
      decoded_length = resetIPResourceAck().RAW_decode(PDU__BSSMAP__ResetIPResourceAck_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 84: {
      RAW_Force_Omit field_force_omit(84, force_omit, PDU__BSSMAP__RerouteCommand_descr_.raw->forceomit);
      decoded_length = rerouteCommand().RAW_decode(PDU__BSSMAP__RerouteCommand_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 85: {
      RAW_Force_Omit field_force_omit(85, force_omit, PDU__BSSMAP__RerouteComplete_descr_.raw->forceomit);
      decoded_length = rerouteComplete().RAW_decode(PDU__BSSMAP__RerouteComplete_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 86: {
      RAW_Force_Omit field_force_omit(86, force_omit, PDU__BSSMAP__LCLS__ConnectControl_descr_.raw->forceomit);
      decoded_length = lCLS__ConnectControl().RAW_decode(PDU__BSSMAP__LCLS__ConnectControl_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 87: {
      RAW_Force_Omit field_force_omit(87, force_omit, PDU__BSSMAP__LCLS__ConnectControlAck_descr_.raw->forceomit);
      decoded_length = lCLS__connectControlAck().RAW_decode(PDU__BSSMAP__LCLS__ConnectControlAck_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 88: {
      RAW_Force_Omit field_force_omit(88, force_omit, PDU__BSSMAP__LCLS__Notification_descr_.raw->forceomit);
      decoded_length = lCLS__Notification().RAW_decode(PDU__BSSMAP__LCLS__Notification_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_0_force_omit(0, force_omit, PDU__BSSMAP__AssignmentRequest_descr_.raw->forceomit);
      decoded_length = assignmentRequest().RAW_decode(PDU__BSSMAP__AssignmentRequest_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_0_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_1_force_omit(1, force_omit, PDU__BSSMAP__AssignmentComplete_descr_.raw->forceomit);
      decoded_length = assignmentComplete().RAW_decode(PDU__BSSMAP__AssignmentComplete_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_1_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_2_force_omit(2, force_omit, PDU__BSSMAP__AssignmentFailure_descr_.raw->forceomit);
      decoded_length = assignmentFailure().RAW_decode(PDU__BSSMAP__AssignmentFailure_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_2_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_3_force_omit(3, force_omit, PDU__BSSMAP__ChannelModifyRequest_descr_.raw->forceomit);
      decoded_length = channelModifyRequest().RAW_decode(PDU__BSSMAP__ChannelModifyRequest_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_3_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_4_force_omit(4, force_omit, PDU__BSSMAP__Block_descr_.raw->forceomit);
      decoded_length = block().RAW_decode(PDU__BSSMAP__Block_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_4_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_5_force_omit(5, force_omit, PDU__BSSMAP__BlockingAck_descr_.raw->forceomit);
      decoded_length = blockingAck().RAW_decode(PDU__BSSMAP__BlockingAck_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_5_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_6_force_omit(6, force_omit, PDU__BSSMAP__BSSInvokeTrace_descr_.raw->forceomit);
      decoded_length = bSSInvokeTrace().RAW_decode(PDU__BSSMAP__BSSInvokeTrace_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_6_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_7_force_omit(7, force_omit, PDU__BSSMAP__ChangeCircuit_descr_.raw->forceomit);
      decoded_length = changeCircuit().RAW_decode(PDU__BSSMAP__ChangeCircuit_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_7_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_8_force_omit(8, force_omit, PDU__BSSMAP__ChangeCircuitAck_descr_.raw->forceomit);
      decoded_length = changeCircuitAck().RAW_decode(PDU__BSSMAP__ChangeCircuitAck_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_8_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_9_force_omit(9, force_omit, PDU__BSSMAP__CipherModeCommand_descr_.raw->forceomit);
      decoded_length = cipherModeCommand().RAW_decode(PDU__BSSMAP__CipherModeCommand_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_9_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_10_force_omit(10, force_omit, PDU__BSSMAP__CipherModeComplete_descr_.raw->forceomit);
      decoded_length = cipherModeComplete().RAW_decode(PDU__BSSMAP__CipherModeComplete_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_10_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_11_force_omit(11, force_omit, PDU__BSSMAP__CipherModeReject_descr_.raw->forceomit);
      decoded_length = cipherModeReject().RAW_decode(PDU__BSSMAP__CipherModeReject_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_11_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_12_force_omit(12, force_omit, PDU__BSSMAP__CircuitGroupBlock_descr_.raw->forceomit);
      decoded_length = circuitGroupBlock().RAW_decode(PDU__BSSMAP__CircuitGroupBlock_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_12_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_13_force_omit(13, force_omit, PDU__BSSMAP__CircuitGroupBlockingAck_descr_.raw->forceomit);
      decoded_length = circuitGroupBlockingAck().RAW_decode(PDU__BSSMAP__CircuitGroupBlockingAck_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_13_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_14_force_omit(14, force_omit, PDU__BSSMAP__CircuitGroupUnblock_descr_.raw->forceomit);
      decoded_length = circuitGroupUnblock().RAW_decode(PDU__BSSMAP__CircuitGroupUnblock_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_14_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_15_force_omit(15, force_omit, PDU__BSSMAP__CircuitGroupUnblockAck_descr_.raw->forceomit);
      decoded_length = circuitGroupUnblockAck().RAW_decode(PDU__BSSMAP__CircuitGroupUnblockAck_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_15_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_16_force_omit(16, force_omit, PDU__BSSMAP__ClassmarkRequest_descr_.raw->forceomit);
      decoded_length = classmarkRequest().RAW_decode(PDU__BSSMAP__ClassmarkRequest_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_16_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_17_force_omit(17, force_omit, PDU__BSSMAP__ClassmarkUpdate_descr_.raw->forceomit);
      decoded_length = classmarkUpdate().RAW_decode(PDU__BSSMAP__ClassmarkUpdate_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_17_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_18_force_omit(18, force_omit, PDU__BSSMAP__ClearCommand_descr_.raw->forceomit);
      decoded_length = clearCommand().RAW_decode(PDU__BSSMAP__ClearCommand_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_18_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_19_force_omit(19, force_omit, PDU__BSSMAP__ClearComplete_descr_.raw->forceomit);
      decoded_length = clearComplete().RAW_decode(PDU__BSSMAP__ClearComplete_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_19_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_20_force_omit(20, force_omit, PDU__BSSMAP__ClearRequest_descr_.raw->forceomit);
      decoded_length = clearRequest().RAW_decode(PDU__BSSMAP__ClearRequest_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_20_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_21_force_omit(21, force_omit, PDU__BSSMAP__CommonID_descr_.raw->forceomit);
      decoded_length = commonID().RAW_decode(PDU__BSSMAP__CommonID_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_21_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_22_force_omit(22, force_omit, PDU__BSSMAP__CompleteLayer3Information_descr_.raw->forceomit);
      decoded_length = completeLayer3Information().RAW_decode(PDU__BSSMAP__CompleteLayer3Information_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_22_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_23_force_omit(23, force_omit, PDU__BSSMAP__Confusion_descr_.raw->forceomit);
      decoded_length = confusion().RAW_decode(PDU__BSSMAP__Confusion_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_23_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_24_force_omit(24, force_omit, PDU__BSSMAP__ConnectionlessInformation_descr_.raw->forceomit);
      decoded_length = connectionlessInformation().RAW_decode(PDU__BSSMAP__ConnectionlessInformation_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_24_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_25_force_omit(25, force_omit, PDU__BSSMAP__HandoverCandidateEnquire_descr_.raw->forceomit);
      decoded_length = handoverCandidateEnquire().RAW_decode(PDU__BSSMAP__HandoverCandidateEnquire_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_25_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_26_force_omit(26, force_omit, PDU__BSSMAP__HandoverCandidateResponse_descr_.raw->forceomit);
      decoded_length = handoverCandidateResponse().RAW_decode(PDU__BSSMAP__HandoverCandidateResponse_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_26_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_27_force_omit(27, force_omit, PDU__BSSMAP__HandoverCommand_descr_.raw->forceomit);
      decoded_length = handoverCommand().RAW_decode(PDU__BSSMAP__HandoverCommand_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_27_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_28_force_omit(28, force_omit, PDU__BSSMAP__HandoverComplete_descr_.raw->forceomit);
      decoded_length = handoverComplete().RAW_decode(PDU__BSSMAP__HandoverComplete_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_28_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_29_force_omit(29, force_omit, PDU__BSSMAP__HandoverDetect_descr_.raw->forceomit);
      decoded_length = handoverDetect().RAW_decode(PDU__BSSMAP__HandoverDetect_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_29_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_30_force_omit(30, force_omit, PDU__BSSMAP__HandoverFailure_descr_.raw->forceomit);
      decoded_length = handoverFailure().RAW_decode(PDU__BSSMAP__HandoverFailure_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_30_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_31_force_omit(31, force_omit, PDU__BSSMAP__HandoverPerformed_descr_.raw->forceomit);
      decoded_length = handoverPerformed().RAW_decode(PDU__BSSMAP__HandoverPerformed_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_31_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_32_force_omit(32, force_omit, PDU__BSSMAP__HandoverRequest_descr_.raw->forceomit);
      decoded_length = handoverRequest().RAW_decode(PDU__BSSMAP__HandoverRequest_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_32_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_33_force_omit(33, force_omit, PDU__BSSMAP__HandoverRequestAck_descr_.raw->forceomit);
      decoded_length = handoverRequestAck().RAW_decode(PDU__BSSMAP__HandoverRequestAck_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_33_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_34_force_omit(34, force_omit, PDU__BSSMAP__HandoverRequired_descr_.raw->forceomit);
      decoded_length = handoverRequired().RAW_decode(PDU__BSSMAP__HandoverRequired_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_34_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_35_force_omit(35, force_omit, PDU__BSSMAP__HandoverRequiredReject_descr_.raw->forceomit);
      decoded_length = handoverRequiredReject().RAW_decode(PDU__BSSMAP__HandoverRequiredReject_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_35_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_36_force_omit(36, force_omit, PDU__BSSMAP__HandoverSucceeded_descr_.raw->forceomit);
      decoded_length = handoverSucceeded().RAW_decode(PDU__BSSMAP__HandoverSucceeded_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_36_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_37_force_omit(37, force_omit, PDU__BSSMAP__LoadIndication_descr_.raw->forceomit);
      decoded_length = loadIndication().RAW_decode(PDU__BSSMAP__LoadIndication_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_37_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_38_force_omit(38, force_omit, PDU__BSSMAP__LSAInformation_descr_.raw->forceomit);
      decoded_length = lSAInformation().RAW_decode(PDU__BSSMAP__LSAInformation_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_38_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_39_force_omit(39, force_omit, PDU__BSSMAP__MSCInvokeTrace_descr_.raw->forceomit);
      decoded_length = mSCInvokeTrace().RAW_decode(PDU__BSSMAP__MSCInvokeTrace_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_39_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_40_force_omit(40, force_omit, PDU__BSSMAP__Overload_descr_.raw->forceomit);
      decoded_length = overload().RAW_decode(PDU__BSSMAP__Overload_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_40_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_41_force_omit(41, force_omit, PDU__BSSMAP__Paging_descr_.raw->forceomit);
      decoded_length = paging().RAW_decode(PDU__BSSMAP__Paging_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_41_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_42_force_omit(42, force_omit, PDU__BSSMAP__PerformLocationAbort_descr_.raw->forceomit);
      decoded_length = performLocationAbort().RAW_decode(PDU__BSSMAP__PerformLocationAbort_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_42_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_43_force_omit(43, force_omit, PDU__BSSMAP__PerformLocationRequest_descr_.raw->forceomit);
      decoded_length = performLocationRequest().RAW_decode(PDU__BSSMAP__PerformLocationRequest_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_43_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_44_force_omit(44, force_omit, PDU__BSSMAP__PerformLocationResponse_descr_.raw->forceomit);
      decoded_length = performLocationResponse().RAW_decode(PDU__BSSMAP__PerformLocationResponse_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_44_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_45_force_omit(45, force_omit, PDU__BSSMAP__QueueingIndication_descr_.raw->forceomit);
      decoded_length = queueingIndication().RAW_decode(PDU__BSSMAP__QueueingIndication_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_45_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_46_force_omit(46, force_omit, PDU__BSSMAP__Reset_descr_.raw->forceomit);
      decoded_length = reset().RAW_decode(PDU__BSSMAP__Reset_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_46_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_47_force_omit(47, force_omit, PDU__BSSMAP__ResetAck_descr_.raw->forceomit);
      decoded_length = resetAck().RAW_decode(PDU__BSSMAP__ResetAck_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_47_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_48_force_omit(48, force_omit, PDU__BSSMAP__ResetCircuit_descr_.raw->forceomit);
      decoded_length = resetCircuit().RAW_decode(PDU__BSSMAP__ResetCircuit_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_48_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_49_force_omit(49, force_omit, PDU__BSSMAP__ResetCircuitAck_descr_.raw->forceomit);
      decoded_length = resetCircuitAck().RAW_decode(PDU__BSSMAP__ResetCircuitAck_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_49_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_50_force_omit(50, force_omit, PDU__BSSMAP__ResourceIndication_descr_.raw->forceomit);
      decoded_length = resourceIndication().RAW_decode(PDU__BSSMAP__ResourceIndication_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_50_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_51_force_omit(51, force_omit, PDU__BSSMAP__ResourceRequest_descr_.raw->forceomit);
      decoded_length = resourceRequest().RAW_decode(PDU__BSSMAP__ResourceRequest_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_51_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_52_force_omit(52, force_omit, PDU__BSSMAP__SAPInReject_descr_.raw->forceomit);
      decoded_length = sAPInReject().RAW_decode(PDU__BSSMAP__SAPInReject_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_52_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_53_force_omit(53, force_omit, PDU__BSSMAP__Suspend_descr_.raw->forceomit);
      decoded_length = suspend().RAW_decode(PDU__BSSMAP__Suspend_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_53_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_54_force_omit(54, force_omit, PDU__BSSMAP__Resume_descr_.raw->forceomit);
      decoded_length = resume().RAW_decode(PDU__BSSMAP__Resume_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_54_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_55_force_omit(55, force_omit, PDU__BSSMAP__Unblock_descr_.raw->forceomit);
      decoded_length = unblock().RAW_decode(PDU__BSSMAP__Unblock_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_55_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_56_force_omit(56, force_omit, PDU__BSSMAP__UnblockAck_descr_.raw->forceomit);
      decoded_length = unblockAck().RAW_decode(PDU__BSSMAP__UnblockAck_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_56_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_57_force_omit(57, force_omit, PDU__BSSMAP__UnequippedCircuit_descr_.raw->forceomit);
      decoded_length = unequippedCircuit().RAW_decode(PDU__BSSMAP__UnequippedCircuit_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_57_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_58_force_omit(58, force_omit, PDU__BSSMAP__UplinkRequest_descr_.raw->forceomit);
      decoded_length = uplinkRequest().RAW_decode(PDU__BSSMAP__UplinkRequest_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_58_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_59_force_omit(59, force_omit, PDU__BSSMAP__UplinkRequestAck_descr_.raw->forceomit);
      decoded_length = uplinkRequestAck().RAW_decode(PDU__BSSMAP__UplinkRequestAck_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_59_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_60_force_omit(60, force_omit, PDU__BSSMAP__UplinkRequestConfirmation_descr_.raw->forceomit);
      decoded_length = uplinkRequestConfirmation().RAW_decode(PDU__BSSMAP__UplinkRequestConfirmation_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_60_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_61_force_omit(61, force_omit, PDU__BSSMAP__UplinkReleaseIndication_descr_.raw->forceomit);
      decoded_length = uplinkReleaseIndication().RAW_decode(PDU__BSSMAP__UplinkReleaseIndication_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_61_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_62_force_omit(62, force_omit, PDU__BSSMAP__UplinkRejectCommand_descr_.raw->forceomit);
      decoded_length = uplinkRejectCommand().RAW_decode(PDU__BSSMAP__UplinkRejectCommand_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_62_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_63_force_omit(63, force_omit, PDU__BSSMAP__UplinkReleaseCommand_descr_.raw->forceomit);
      decoded_length = uplinkReleaseCommand().RAW_decode(PDU__BSSMAP__UplinkReleaseCommand_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_63_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_64_force_omit(64, force_omit, PDU__BSSMAP__UplinkSeizedCommand_descr_.raw->forceomit);
      decoded_length = uplinkSeizedCommand().RAW_decode(PDU__BSSMAP__UplinkSeizedCommand_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_64_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_65_force_omit(65, force_omit, PDU__BSSMAP__VGCS__VBSSetup_descr_.raw->forceomit);
      decoded_length = vGCS__VBSSetup().RAW_decode(PDU__BSSMAP__VGCS__VBSSetup_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_65_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_66_force_omit(66, force_omit, PDU__BSSMAP__VGCS__VBSSetupAck_descr_.raw->forceomit);
      decoded_length = vGCS__VBSSetupAck().RAW_decode(PDU__BSSMAP__VGCS__VBSSetupAck_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_66_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_67_force_omit(67, force_omit, PDU__BSSMAP__VGCS__VBSSetupRefuse_descr_.raw->forceomit);
      decoded_length = vGCS__VBSSetupRefuse().RAW_decode(PDU__BSSMAP__VGCS__VBSSetupRefuse_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_67_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_68_force_omit(68, force_omit, PDU__BSSMAP__VGCS__VBSAssignmentRequest_descr_.raw->forceomit);
      decoded_length = vGCS__VBSAssignmentRequest().RAW_decode(PDU__BSSMAP__VGCS__VBSAssignmentRequest_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_68_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_69_force_omit(69, force_omit, PDU__BSSMAP__VGCS__VBSAssignmentResult_descr_.raw->forceomit);
      decoded_length = vGCS__VBSAssignmentResult().RAW_decode(PDU__BSSMAP__VGCS__VBSAssignmentResult_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_69_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_70_force_omit(70, force_omit, PDU__BSSMAP__VGCS__VBSAssignmentFailure_descr_.raw->forceomit);
      decoded_length = vGCS__VBSAssignmentFailure().RAW_decode(PDU__BSSMAP__VGCS__VBSAssignmentFailure_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_70_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_71_force_omit(71, force_omit, PDU__BSSMAP__VGCS__VBSQueuingIndication_descr_.raw->forceomit);
      decoded_length = vGCS__VBSQueuingIndication().RAW_decode(PDU__BSSMAP__VGCS__VBSQueuingIndication_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_71_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_72_force_omit(72, force_omit, PDU__BSSMAP__VGCS__AdditionalInformation_descr_.raw->forceomit);
      decoded_length = vGCS__AdditionalInformation().RAW_decode(PDU__BSSMAP__VGCS__AdditionalInformation_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_72_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_73_force_omit(73, force_omit, PDU__BSSMAP__VGCS__VBS__AreaCellInfo_descr_.raw->forceomit);
      decoded_length = vGCS__VBS__AreaCellInfo().RAW_decode(PDU__BSSMAP__VGCS__VBS__AreaCellInfo_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_73_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_74_force_omit(74, force_omit, PDU__BSSMAP__VGCS__VBS__AssignmentStatus_descr_.raw->forceomit);
      decoded_length = vGCS__VBS__AssignmentStatus().RAW_decode(PDU__BSSMAP__VGCS__VBS__AssignmentStatus_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_74_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_75_force_omit(75, force_omit, PDU__BSSMAP__VGCS__SMS_descr_.raw->forceomit);
      decoded_length = vGCS__SMS().RAW_decode(PDU__BSSMAP__VGCS__SMS_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_75_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_76_force_omit(76, force_omit, PDU__BSSMAP__UplinkApplicationData_descr_.raw->forceomit);
      decoded_length = uplinkApplicationData().RAW_decode(PDU__BSSMAP__UplinkApplicationData_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_76_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_77_force_omit(77, force_omit, PDU__BSSMAP__NotificationData_descr_.raw->forceomit);
      decoded_length = notificationData().RAW_decode(PDU__BSSMAP__NotificationData_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_77_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_78_force_omit(78, force_omit, PDU__BSSMAP__InternalHandoverRequired_descr_.raw->forceomit);
      decoded_length = internalHandoverRequired().RAW_decode(PDU__BSSMAP__InternalHandoverRequired_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_78_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_79_force_omit(79, force_omit, PDU__BSSMAP__InternalHandoverRequiredReject_descr_.raw->forceomit);
      decoded_length = internalHandoverRequiredReject().RAW_decode(PDU__BSSMAP__InternalHandoverRequiredReject_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_79_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_80_force_omit(80, force_omit, PDU__BSSMAP__InternalHandoverCommand_descr_.raw->forceomit);
      decoded_length = internalHandoverCommand().RAW_decode(PDU__BSSMAP__InternalHandoverCommand_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_80_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_81_force_omit(81, force_omit, PDU__BSSMAP__InternalHandoverEnquiry_descr_.raw->forceomit);
      decoded_length = internalHandoverEnquiry().RAW_decode(PDU__BSSMAP__InternalHandoverEnquiry_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_81_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_82_force_omit(82, force_omit, PDU__BSSMAP__ResetIPResource_descr_.raw->forceomit);
      decoded_length = resetIPResource().RAW_decode(PDU__BSSMAP__ResetIPResource_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_82_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_83_force_omit(83, force_omit, PDU__BSSMAP__ResetIPResourceAck_descr_.raw->forceomit);
      decoded_length = resetIPResourceAck().RAW_decode(PDU__BSSMAP__ResetIPResourceAck_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_83_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_84_force_omit(84, force_omit, PDU__BSSMAP__RerouteCommand_descr_.raw->forceomit);
      decoded_length = rerouteCommand().RAW_decode(PDU__BSSMAP__RerouteCommand_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_84_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_85_force_omit(85, force_omit, PDU__BSSMAP__RerouteComplete_descr_.raw->forceomit);
      decoded_length = rerouteComplete().RAW_decode(PDU__BSSMAP__RerouteComplete_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_85_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_86_force_omit(86, force_omit, PDU__BSSMAP__LCLS__ConnectControl_descr_.raw->forceomit);
      decoded_length = lCLS__ConnectControl().RAW_decode(PDU__BSSMAP__LCLS__ConnectControl_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_86_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_87_force_omit(87, force_omit, PDU__BSSMAP__LCLS__ConnectControlAck_descr_.raw->forceomit);
      decoded_length = lCLS__connectControlAck().RAW_decode(PDU__BSSMAP__LCLS__ConnectControlAck_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_87_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_88_force_omit(88, force_omit, PDU__BSSMAP__LCLS__Notification_descr_.raw->forceomit);
      decoded_length = lCLS__Notification().RAW_decode(PDU__BSSMAP__LCLS__Notification_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_88_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
 }
 clean_up();
 return -1;
}

int PDU__BSSMAP::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 89;  myleaf.body.node.nodes = init_nodes_of_enc_tree(89);
  memset(myleaf.body.node.nodes, 0, 89 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_assignmentRequest:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, PDU__BSSMAP__AssignmentRequest_descr_.raw);
    encoded_length = field_assignmentRequest->RAW_encode(PDU__BSSMAP__AssignmentRequest_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &PDU__BSSMAP__AssignmentRequest_descr_;
    break;
  case ALT_assignmentComplete:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, PDU__BSSMAP__AssignmentComplete_descr_.raw);
    encoded_length = field_assignmentComplete->RAW_encode(PDU__BSSMAP__AssignmentComplete_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &PDU__BSSMAP__AssignmentComplete_descr_;
    break;
  case ALT_assignmentFailure:
    myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 2, PDU__BSSMAP__AssignmentFailure_descr_.raw);
    encoded_length = field_assignmentFailure->RAW_encode(PDU__BSSMAP__AssignmentFailure_descr_, *myleaf.body.node.nodes[2]);
    myleaf.body.node.nodes[2]->coding_descr = &PDU__BSSMAP__AssignmentFailure_descr_;
    break;
  case ALT_channelModifyRequest:
    myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 3, PDU__BSSMAP__ChannelModifyRequest_descr_.raw);
    encoded_length = field_channelModifyRequest->RAW_encode(PDU__BSSMAP__ChannelModifyRequest_descr_, *myleaf.body.node.nodes[3]);
    myleaf.body.node.nodes[3]->coding_descr = &PDU__BSSMAP__ChannelModifyRequest_descr_;
    break;
  case ALT_block:
    myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 4, PDU__BSSMAP__Block_descr_.raw);
    encoded_length = field_block->RAW_encode(PDU__BSSMAP__Block_descr_, *myleaf.body.node.nodes[4]);
    myleaf.body.node.nodes[4]->coding_descr = &PDU__BSSMAP__Block_descr_;
    break;
  case ALT_blockingAck:
    myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 5, PDU__BSSMAP__BlockingAck_descr_.raw);
    encoded_length = field_blockingAck->RAW_encode(PDU__BSSMAP__BlockingAck_descr_, *myleaf.body.node.nodes[5]);
    myleaf.body.node.nodes[5]->coding_descr = &PDU__BSSMAP__BlockingAck_descr_;
    break;
  case ALT_bSSInvokeTrace:
    myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 6, PDU__BSSMAP__BSSInvokeTrace_descr_.raw);
    encoded_length = field_bSSInvokeTrace->RAW_encode(PDU__BSSMAP__BSSInvokeTrace_descr_, *myleaf.body.node.nodes[6]);
    myleaf.body.node.nodes[6]->coding_descr = &PDU__BSSMAP__BSSInvokeTrace_descr_;
    break;
  case ALT_changeCircuit:
    myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 7, PDU__BSSMAP__ChangeCircuit_descr_.raw);
    encoded_length = field_changeCircuit->RAW_encode(PDU__BSSMAP__ChangeCircuit_descr_, *myleaf.body.node.nodes[7]);
    myleaf.body.node.nodes[7]->coding_descr = &PDU__BSSMAP__ChangeCircuit_descr_;
    break;
  case ALT_changeCircuitAck:
    myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 8, PDU__BSSMAP__ChangeCircuitAck_descr_.raw);
    encoded_length = field_changeCircuitAck->RAW_encode(PDU__BSSMAP__ChangeCircuitAck_descr_, *myleaf.body.node.nodes[8]);
    myleaf.body.node.nodes[8]->coding_descr = &PDU__BSSMAP__ChangeCircuitAck_descr_;
    break;
  case ALT_cipherModeCommand:
    myleaf.body.node.nodes[9] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 9, PDU__BSSMAP__CipherModeCommand_descr_.raw);
    encoded_length = field_cipherModeCommand->RAW_encode(PDU__BSSMAP__CipherModeCommand_descr_, *myleaf.body.node.nodes[9]);
    myleaf.body.node.nodes[9]->coding_descr = &PDU__BSSMAP__CipherModeCommand_descr_;
    break;
  case ALT_cipherModeComplete:
    myleaf.body.node.nodes[10] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 10, PDU__BSSMAP__CipherModeComplete_descr_.raw);
    encoded_length = field_cipherModeComplete->RAW_encode(PDU__BSSMAP__CipherModeComplete_descr_, *myleaf.body.node.nodes[10]);
    myleaf.body.node.nodes[10]->coding_descr = &PDU__BSSMAP__CipherModeComplete_descr_;
    break;
  case ALT_cipherModeReject:
    myleaf.body.node.nodes[11] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 11, PDU__BSSMAP__CipherModeReject_descr_.raw);
    encoded_length = field_cipherModeReject->RAW_encode(PDU__BSSMAP__CipherModeReject_descr_, *myleaf.body.node.nodes[11]);
    myleaf.body.node.nodes[11]->coding_descr = &PDU__BSSMAP__CipherModeReject_descr_;
    break;
  case ALT_circuitGroupBlock:
    myleaf.body.node.nodes[12] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 12, PDU__BSSMAP__CircuitGroupBlock_descr_.raw);
    encoded_length = field_circuitGroupBlock->RAW_encode(PDU__BSSMAP__CircuitGroupBlock_descr_, *myleaf.body.node.nodes[12]);
    myleaf.body.node.nodes[12]->coding_descr = &PDU__BSSMAP__CircuitGroupBlock_descr_;
    break;
  case ALT_circuitGroupBlockingAck:
    myleaf.body.node.nodes[13] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 13, PDU__BSSMAP__CircuitGroupBlockingAck_descr_.raw);
    encoded_length = field_circuitGroupBlockingAck->RAW_encode(PDU__BSSMAP__CircuitGroupBlockingAck_descr_, *myleaf.body.node.nodes[13]);
    myleaf.body.node.nodes[13]->coding_descr = &PDU__BSSMAP__CircuitGroupBlockingAck_descr_;
    break;
  case ALT_circuitGroupUnblock:
    myleaf.body.node.nodes[14] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 14, PDU__BSSMAP__CircuitGroupUnblock_descr_.raw);
    encoded_length = field_circuitGroupUnblock->RAW_encode(PDU__BSSMAP__CircuitGroupUnblock_descr_, *myleaf.body.node.nodes[14]);
    myleaf.body.node.nodes[14]->coding_descr = &PDU__BSSMAP__CircuitGroupUnblock_descr_;
    break;
  case ALT_circuitGroupUnblockAck:
    myleaf.body.node.nodes[15] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 15, PDU__BSSMAP__CircuitGroupUnblockAck_descr_.raw);
    encoded_length = field_circuitGroupUnblockAck->RAW_encode(PDU__BSSMAP__CircuitGroupUnblockAck_descr_, *myleaf.body.node.nodes[15]);
    myleaf.body.node.nodes[15]->coding_descr = &PDU__BSSMAP__CircuitGroupUnblockAck_descr_;
    break;
  case ALT_classmarkRequest:
    myleaf.body.node.nodes[16] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 16, PDU__BSSMAP__ClassmarkRequest_descr_.raw);
    encoded_length = field_classmarkRequest->RAW_encode(PDU__BSSMAP__ClassmarkRequest_descr_, *myleaf.body.node.nodes[16]);
    myleaf.body.node.nodes[16]->coding_descr = &PDU__BSSMAP__ClassmarkRequest_descr_;
    break;
  case ALT_classmarkUpdate:
    myleaf.body.node.nodes[17] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 17, PDU__BSSMAP__ClassmarkUpdate_descr_.raw);
    encoded_length = field_classmarkUpdate->RAW_encode(PDU__BSSMAP__ClassmarkUpdate_descr_, *myleaf.body.node.nodes[17]);
    myleaf.body.node.nodes[17]->coding_descr = &PDU__BSSMAP__ClassmarkUpdate_descr_;
    break;
  case ALT_clearCommand:
    myleaf.body.node.nodes[18] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 18, PDU__BSSMAP__ClearCommand_descr_.raw);
    encoded_length = field_clearCommand->RAW_encode(PDU__BSSMAP__ClearCommand_descr_, *myleaf.body.node.nodes[18]);
    myleaf.body.node.nodes[18]->coding_descr = &PDU__BSSMAP__ClearCommand_descr_;
    break;
  case ALT_clearComplete:
    myleaf.body.node.nodes[19] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 19, PDU__BSSMAP__ClearComplete_descr_.raw);
    encoded_length = field_clearComplete->RAW_encode(PDU__BSSMAP__ClearComplete_descr_, *myleaf.body.node.nodes[19]);
    myleaf.body.node.nodes[19]->coding_descr = &PDU__BSSMAP__ClearComplete_descr_;
    break;
  case ALT_clearRequest:
    myleaf.body.node.nodes[20] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 20, PDU__BSSMAP__ClearRequest_descr_.raw);
    encoded_length = field_clearRequest->RAW_encode(PDU__BSSMAP__ClearRequest_descr_, *myleaf.body.node.nodes[20]);
    myleaf.body.node.nodes[20]->coding_descr = &PDU__BSSMAP__ClearRequest_descr_;
    break;
  case ALT_commonID:
    myleaf.body.node.nodes[21] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 21, PDU__BSSMAP__CommonID_descr_.raw);
    encoded_length = field_commonID->RAW_encode(PDU__BSSMAP__CommonID_descr_, *myleaf.body.node.nodes[21]);
    myleaf.body.node.nodes[21]->coding_descr = &PDU__BSSMAP__CommonID_descr_;
    break;
  case ALT_completeLayer3Information:
    myleaf.body.node.nodes[22] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 22, PDU__BSSMAP__CompleteLayer3Information_descr_.raw);
    encoded_length = field_completeLayer3Information->RAW_encode(PDU__BSSMAP__CompleteLayer3Information_descr_, *myleaf.body.node.nodes[22]);
    myleaf.body.node.nodes[22]->coding_descr = &PDU__BSSMAP__CompleteLayer3Information_descr_;
    break;
  case ALT_confusion:
    myleaf.body.node.nodes[23] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 23, PDU__BSSMAP__Confusion_descr_.raw);
    encoded_length = field_confusion->RAW_encode(PDU__BSSMAP__Confusion_descr_, *myleaf.body.node.nodes[23]);
    myleaf.body.node.nodes[23]->coding_descr = &PDU__BSSMAP__Confusion_descr_;
    break;
  case ALT_connectionlessInformation:
    myleaf.body.node.nodes[24] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 24, PDU__BSSMAP__ConnectionlessInformation_descr_.raw);
    encoded_length = field_connectionlessInformation->RAW_encode(PDU__BSSMAP__ConnectionlessInformation_descr_, *myleaf.body.node.nodes[24]);
    myleaf.body.node.nodes[24]->coding_descr = &PDU__BSSMAP__ConnectionlessInformation_descr_;
    break;
  case ALT_handoverCandidateEnquire:
    myleaf.body.node.nodes[25] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 25, PDU__BSSMAP__HandoverCandidateEnquire_descr_.raw);
    encoded_length = field_handoverCandidateEnquire->RAW_encode(PDU__BSSMAP__HandoverCandidateEnquire_descr_, *myleaf.body.node.nodes[25]);
    myleaf.body.node.nodes[25]->coding_descr = &PDU__BSSMAP__HandoverCandidateEnquire_descr_;
    break;
  case ALT_handoverCandidateResponse:
    myleaf.body.node.nodes[26] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 26, PDU__BSSMAP__HandoverCandidateResponse_descr_.raw);
    encoded_length = field_handoverCandidateResponse->RAW_encode(PDU__BSSMAP__HandoverCandidateResponse_descr_, *myleaf.body.node.nodes[26]);
    myleaf.body.node.nodes[26]->coding_descr = &PDU__BSSMAP__HandoverCandidateResponse_descr_;
    break;
  case ALT_handoverCommand:
    myleaf.body.node.nodes[27] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 27, PDU__BSSMAP__HandoverCommand_descr_.raw);
    encoded_length = field_handoverCommand->RAW_encode(PDU__BSSMAP__HandoverCommand_descr_, *myleaf.body.node.nodes[27]);
    myleaf.body.node.nodes[27]->coding_descr = &PDU__BSSMAP__HandoverCommand_descr_;
    break;
  case ALT_handoverComplete:
    myleaf.body.node.nodes[28] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 28, PDU__BSSMAP__HandoverComplete_descr_.raw);
    encoded_length = field_handoverComplete->RAW_encode(PDU__BSSMAP__HandoverComplete_descr_, *myleaf.body.node.nodes[28]);
    myleaf.body.node.nodes[28]->coding_descr = &PDU__BSSMAP__HandoverComplete_descr_;
    break;
  case ALT_handoverDetect:
    myleaf.body.node.nodes[29] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 29, PDU__BSSMAP__HandoverDetect_descr_.raw);
    encoded_length = field_handoverDetect->RAW_encode(PDU__BSSMAP__HandoverDetect_descr_, *myleaf.body.node.nodes[29]);
    myleaf.body.node.nodes[29]->coding_descr = &PDU__BSSMAP__HandoverDetect_descr_;
    break;
  case ALT_handoverFailure:
    myleaf.body.node.nodes[30] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 30, PDU__BSSMAP__HandoverFailure_descr_.raw);
    encoded_length = field_handoverFailure->RAW_encode(PDU__BSSMAP__HandoverFailure_descr_, *myleaf.body.node.nodes[30]);
    myleaf.body.node.nodes[30]->coding_descr = &PDU__BSSMAP__HandoverFailure_descr_;
    break;
  case ALT_handoverPerformed:
    myleaf.body.node.nodes[31] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 31, PDU__BSSMAP__HandoverPerformed_descr_.raw);
    encoded_length = field_handoverPerformed->RAW_encode(PDU__BSSMAP__HandoverPerformed_descr_, *myleaf.body.node.nodes[31]);
    myleaf.body.node.nodes[31]->coding_descr = &PDU__BSSMAP__HandoverPerformed_descr_;
    break;
  case ALT_handoverRequest:
    myleaf.body.node.nodes[32] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 32, PDU__BSSMAP__HandoverRequest_descr_.raw);
    encoded_length = field_handoverRequest->RAW_encode(PDU__BSSMAP__HandoverRequest_descr_, *myleaf.body.node.nodes[32]);
    myleaf.body.node.nodes[32]->coding_descr = &PDU__BSSMAP__HandoverRequest_descr_;
    break;
  case ALT_handoverRequestAck:
    myleaf.body.node.nodes[33] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 33, PDU__BSSMAP__HandoverRequestAck_descr_.raw);
    encoded_length = field_handoverRequestAck->RAW_encode(PDU__BSSMAP__HandoverRequestAck_descr_, *myleaf.body.node.nodes[33]);
    myleaf.body.node.nodes[33]->coding_descr = &PDU__BSSMAP__HandoverRequestAck_descr_;
    break;
  case ALT_handoverRequired:
    myleaf.body.node.nodes[34] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 34, PDU__BSSMAP__HandoverRequired_descr_.raw);
    encoded_length = field_handoverRequired->RAW_encode(PDU__BSSMAP__HandoverRequired_descr_, *myleaf.body.node.nodes[34]);
    myleaf.body.node.nodes[34]->coding_descr = &PDU__BSSMAP__HandoverRequired_descr_;
    break;
  case ALT_handoverRequiredReject:
    myleaf.body.node.nodes[35] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 35, PDU__BSSMAP__HandoverRequiredReject_descr_.raw);
    encoded_length = field_handoverRequiredReject->RAW_encode(PDU__BSSMAP__HandoverRequiredReject_descr_, *myleaf.body.node.nodes[35]);
    myleaf.body.node.nodes[35]->coding_descr = &PDU__BSSMAP__HandoverRequiredReject_descr_;
    break;
  case ALT_handoverSucceeded:
    myleaf.body.node.nodes[36] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 36, PDU__BSSMAP__HandoverSucceeded_descr_.raw);
    encoded_length = field_handoverSucceeded->RAW_encode(PDU__BSSMAP__HandoverSucceeded_descr_, *myleaf.body.node.nodes[36]);
    myleaf.body.node.nodes[36]->coding_descr = &PDU__BSSMAP__HandoverSucceeded_descr_;
    break;
  case ALT_loadIndication:
    myleaf.body.node.nodes[37] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 37, PDU__BSSMAP__LoadIndication_descr_.raw);
    encoded_length = field_loadIndication->RAW_encode(PDU__BSSMAP__LoadIndication_descr_, *myleaf.body.node.nodes[37]);
    myleaf.body.node.nodes[37]->coding_descr = &PDU__BSSMAP__LoadIndication_descr_;
    break;
  case ALT_lSAInformation:
    myleaf.body.node.nodes[38] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 38, PDU__BSSMAP__LSAInformation_descr_.raw);
    encoded_length = field_lSAInformation->RAW_encode(PDU__BSSMAP__LSAInformation_descr_, *myleaf.body.node.nodes[38]);
    myleaf.body.node.nodes[38]->coding_descr = &PDU__BSSMAP__LSAInformation_descr_;
    break;
  case ALT_mSCInvokeTrace:
    myleaf.body.node.nodes[39] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 39, PDU__BSSMAP__MSCInvokeTrace_descr_.raw);
    encoded_length = field_mSCInvokeTrace->RAW_encode(PDU__BSSMAP__MSCInvokeTrace_descr_, *myleaf.body.node.nodes[39]);
    myleaf.body.node.nodes[39]->coding_descr = &PDU__BSSMAP__MSCInvokeTrace_descr_;
    break;
  case ALT_overload:
    myleaf.body.node.nodes[40] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 40, PDU__BSSMAP__Overload_descr_.raw);
    encoded_length = field_overload->RAW_encode(PDU__BSSMAP__Overload_descr_, *myleaf.body.node.nodes[40]);
    myleaf.body.node.nodes[40]->coding_descr = &PDU__BSSMAP__Overload_descr_;
    break;
  case ALT_paging:
    myleaf.body.node.nodes[41] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 41, PDU__BSSMAP__Paging_descr_.raw);
    encoded_length = field_paging->RAW_encode(PDU__BSSMAP__Paging_descr_, *myleaf.body.node.nodes[41]);
    myleaf.body.node.nodes[41]->coding_descr = &PDU__BSSMAP__Paging_descr_;
    break;
  case ALT_performLocationAbort:
    myleaf.body.node.nodes[42] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 42, PDU__BSSMAP__PerformLocationAbort_descr_.raw);
    encoded_length = field_performLocationAbort->RAW_encode(PDU__BSSMAP__PerformLocationAbort_descr_, *myleaf.body.node.nodes[42]);
    myleaf.body.node.nodes[42]->coding_descr = &PDU__BSSMAP__PerformLocationAbort_descr_;
    break;
  case ALT_performLocationRequest:
    myleaf.body.node.nodes[43] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 43, PDU__BSSMAP__PerformLocationRequest_descr_.raw);
    encoded_length = field_performLocationRequest->RAW_encode(PDU__BSSMAP__PerformLocationRequest_descr_, *myleaf.body.node.nodes[43]);
    myleaf.body.node.nodes[43]->coding_descr = &PDU__BSSMAP__PerformLocationRequest_descr_;
    break;
  case ALT_performLocationResponse:
    myleaf.body.node.nodes[44] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 44, PDU__BSSMAP__PerformLocationResponse_descr_.raw);
    encoded_length = field_performLocationResponse->RAW_encode(PDU__BSSMAP__PerformLocationResponse_descr_, *myleaf.body.node.nodes[44]);
    myleaf.body.node.nodes[44]->coding_descr = &PDU__BSSMAP__PerformLocationResponse_descr_;
    break;
  case ALT_queueingIndication:
    myleaf.body.node.nodes[45] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 45, PDU__BSSMAP__QueueingIndication_descr_.raw);
    encoded_length = field_queueingIndication->RAW_encode(PDU__BSSMAP__QueueingIndication_descr_, *myleaf.body.node.nodes[45]);
    myleaf.body.node.nodes[45]->coding_descr = &PDU__BSSMAP__QueueingIndication_descr_;
    break;
  case ALT_reset:
    myleaf.body.node.nodes[46] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 46, PDU__BSSMAP__Reset_descr_.raw);
    encoded_length = field_reset->RAW_encode(PDU__BSSMAP__Reset_descr_, *myleaf.body.node.nodes[46]);
    myleaf.body.node.nodes[46]->coding_descr = &PDU__BSSMAP__Reset_descr_;
    break;
  case ALT_resetAck:
    myleaf.body.node.nodes[47] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 47, PDU__BSSMAP__ResetAck_descr_.raw);
    encoded_length = field_resetAck->RAW_encode(PDU__BSSMAP__ResetAck_descr_, *myleaf.body.node.nodes[47]);
    myleaf.body.node.nodes[47]->coding_descr = &PDU__BSSMAP__ResetAck_descr_;
    break;
  case ALT_resetCircuit:
    myleaf.body.node.nodes[48] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 48, PDU__BSSMAP__ResetCircuit_descr_.raw);
    encoded_length = field_resetCircuit->RAW_encode(PDU__BSSMAP__ResetCircuit_descr_, *myleaf.body.node.nodes[48]);
    myleaf.body.node.nodes[48]->coding_descr = &PDU__BSSMAP__ResetCircuit_descr_;
    break;
  case ALT_resetCircuitAck:
    myleaf.body.node.nodes[49] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 49, PDU__BSSMAP__ResetCircuitAck_descr_.raw);
    encoded_length = field_resetCircuitAck->RAW_encode(PDU__BSSMAP__ResetCircuitAck_descr_, *myleaf.body.node.nodes[49]);
    myleaf.body.node.nodes[49]->coding_descr = &PDU__BSSMAP__ResetCircuitAck_descr_;
    break;
  case ALT_resourceIndication:
    myleaf.body.node.nodes[50] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 50, PDU__BSSMAP__ResourceIndication_descr_.raw);
    encoded_length = field_resourceIndication->RAW_encode(PDU__BSSMAP__ResourceIndication_descr_, *myleaf.body.node.nodes[50]);
    myleaf.body.node.nodes[50]->coding_descr = &PDU__BSSMAP__ResourceIndication_descr_;
    break;
  case ALT_resourceRequest:
    myleaf.body.node.nodes[51] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 51, PDU__BSSMAP__ResourceRequest_descr_.raw);
    encoded_length = field_resourceRequest->RAW_encode(PDU__BSSMAP__ResourceRequest_descr_, *myleaf.body.node.nodes[51]);
    myleaf.body.node.nodes[51]->coding_descr = &PDU__BSSMAP__ResourceRequest_descr_;
    break;
  case ALT_sAPInReject:
    myleaf.body.node.nodes[52] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 52, PDU__BSSMAP__SAPInReject_descr_.raw);
    encoded_length = field_sAPInReject->RAW_encode(PDU__BSSMAP__SAPInReject_descr_, *myleaf.body.node.nodes[52]);
    myleaf.body.node.nodes[52]->coding_descr = &PDU__BSSMAP__SAPInReject_descr_;
    break;
  case ALT_suspend:
    myleaf.body.node.nodes[53] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 53, PDU__BSSMAP__Suspend_descr_.raw);
    encoded_length = field_suspend->RAW_encode(PDU__BSSMAP__Suspend_descr_, *myleaf.body.node.nodes[53]);
    myleaf.body.node.nodes[53]->coding_descr = &PDU__BSSMAP__Suspend_descr_;
    break;
  case ALT_resume:
    myleaf.body.node.nodes[54] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 54, PDU__BSSMAP__Resume_descr_.raw);
    encoded_length = field_resume->RAW_encode(PDU__BSSMAP__Resume_descr_, *myleaf.body.node.nodes[54]);
    myleaf.body.node.nodes[54]->coding_descr = &PDU__BSSMAP__Resume_descr_;
    break;
  case ALT_unblock:
    myleaf.body.node.nodes[55] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 55, PDU__BSSMAP__Unblock_descr_.raw);
    encoded_length = field_unblock->RAW_encode(PDU__BSSMAP__Unblock_descr_, *myleaf.body.node.nodes[55]);
    myleaf.body.node.nodes[55]->coding_descr = &PDU__BSSMAP__Unblock_descr_;
    break;
  case ALT_unblockAck:
    myleaf.body.node.nodes[56] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 56, PDU__BSSMAP__UnblockAck_descr_.raw);
    encoded_length = field_unblockAck->RAW_encode(PDU__BSSMAP__UnblockAck_descr_, *myleaf.body.node.nodes[56]);
    myleaf.body.node.nodes[56]->coding_descr = &PDU__BSSMAP__UnblockAck_descr_;
    break;
  case ALT_unequippedCircuit:
    myleaf.body.node.nodes[57] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 57, PDU__BSSMAP__UnequippedCircuit_descr_.raw);
    encoded_length = field_unequippedCircuit->RAW_encode(PDU__BSSMAP__UnequippedCircuit_descr_, *myleaf.body.node.nodes[57]);
    myleaf.body.node.nodes[57]->coding_descr = &PDU__BSSMAP__UnequippedCircuit_descr_;
    break;
  case ALT_uplinkRequest:
    myleaf.body.node.nodes[58] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 58, PDU__BSSMAP__UplinkRequest_descr_.raw);
    encoded_length = field_uplinkRequest->RAW_encode(PDU__BSSMAP__UplinkRequest_descr_, *myleaf.body.node.nodes[58]);
    myleaf.body.node.nodes[58]->coding_descr = &PDU__BSSMAP__UplinkRequest_descr_;
    break;
  case ALT_uplinkRequestAck:
    myleaf.body.node.nodes[59] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 59, PDU__BSSMAP__UplinkRequestAck_descr_.raw);
    encoded_length = field_uplinkRequestAck->RAW_encode(PDU__BSSMAP__UplinkRequestAck_descr_, *myleaf.body.node.nodes[59]);
    myleaf.body.node.nodes[59]->coding_descr = &PDU__BSSMAP__UplinkRequestAck_descr_;
    break;
  case ALT_uplinkRequestConfirmation:
    myleaf.body.node.nodes[60] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 60, PDU__BSSMAP__UplinkRequestConfirmation_descr_.raw);
    encoded_length = field_uplinkRequestConfirmation->RAW_encode(PDU__BSSMAP__UplinkRequestConfirmation_descr_, *myleaf.body.node.nodes[60]);
    myleaf.body.node.nodes[60]->coding_descr = &PDU__BSSMAP__UplinkRequestConfirmation_descr_;
    break;
  case ALT_uplinkReleaseIndication:
    myleaf.body.node.nodes[61] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 61, PDU__BSSMAP__UplinkReleaseIndication_descr_.raw);
    encoded_length = field_uplinkReleaseIndication->RAW_encode(PDU__BSSMAP__UplinkReleaseIndication_descr_, *myleaf.body.node.nodes[61]);
    myleaf.body.node.nodes[61]->coding_descr = &PDU__BSSMAP__UplinkReleaseIndication_descr_;
    break;
  case ALT_uplinkRejectCommand:
    myleaf.body.node.nodes[62] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 62, PDU__BSSMAP__UplinkRejectCommand_descr_.raw);
    encoded_length = field_uplinkRejectCommand->RAW_encode(PDU__BSSMAP__UplinkRejectCommand_descr_, *myleaf.body.node.nodes[62]);
    myleaf.body.node.nodes[62]->coding_descr = &PDU__BSSMAP__UplinkRejectCommand_descr_;
    break;
  case ALT_uplinkReleaseCommand:
    myleaf.body.node.nodes[63] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 63, PDU__BSSMAP__UplinkReleaseCommand_descr_.raw);
    encoded_length = field_uplinkReleaseCommand->RAW_encode(PDU__BSSMAP__UplinkReleaseCommand_descr_, *myleaf.body.node.nodes[63]);
    myleaf.body.node.nodes[63]->coding_descr = &PDU__BSSMAP__UplinkReleaseCommand_descr_;
    break;
  case ALT_uplinkSeizedCommand:
    myleaf.body.node.nodes[64] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 64, PDU__BSSMAP__UplinkSeizedCommand_descr_.raw);
    encoded_length = field_uplinkSeizedCommand->RAW_encode(PDU__BSSMAP__UplinkSeizedCommand_descr_, *myleaf.body.node.nodes[64]);
    myleaf.body.node.nodes[64]->coding_descr = &PDU__BSSMAP__UplinkSeizedCommand_descr_;
    break;
  case ALT_vGCS__VBSSetup:
    myleaf.body.node.nodes[65] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 65, PDU__BSSMAP__VGCS__VBSSetup_descr_.raw);
    encoded_length = field_vGCS__VBSSetup->RAW_encode(PDU__BSSMAP__VGCS__VBSSetup_descr_, *myleaf.body.node.nodes[65]);
    myleaf.body.node.nodes[65]->coding_descr = &PDU__BSSMAP__VGCS__VBSSetup_descr_;
    break;
  case ALT_vGCS__VBSSetupAck:
    myleaf.body.node.nodes[66] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 66, PDU__BSSMAP__VGCS__VBSSetupAck_descr_.raw);
    encoded_length = field_vGCS__VBSSetupAck->RAW_encode(PDU__BSSMAP__VGCS__VBSSetupAck_descr_, *myleaf.body.node.nodes[66]);
    myleaf.body.node.nodes[66]->coding_descr = &PDU__BSSMAP__VGCS__VBSSetupAck_descr_;
    break;
  case ALT_vGCS__VBSSetupRefuse:
    myleaf.body.node.nodes[67] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 67, PDU__BSSMAP__VGCS__VBSSetupRefuse_descr_.raw);
    encoded_length = field_vGCS__VBSSetupRefuse->RAW_encode(PDU__BSSMAP__VGCS__VBSSetupRefuse_descr_, *myleaf.body.node.nodes[67]);
    myleaf.body.node.nodes[67]->coding_descr = &PDU__BSSMAP__VGCS__VBSSetupRefuse_descr_;
    break;
  case ALT_vGCS__VBSAssignmentRequest:
    myleaf.body.node.nodes[68] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 68, PDU__BSSMAP__VGCS__VBSAssignmentRequest_descr_.raw);
    encoded_length = field_vGCS__VBSAssignmentRequest->RAW_encode(PDU__BSSMAP__VGCS__VBSAssignmentRequest_descr_, *myleaf.body.node.nodes[68]);
    myleaf.body.node.nodes[68]->coding_descr = &PDU__BSSMAP__VGCS__VBSAssignmentRequest_descr_;
    break;
  case ALT_vGCS__VBSAssignmentResult:
    myleaf.body.node.nodes[69] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 69, PDU__BSSMAP__VGCS__VBSAssignmentResult_descr_.raw);
    encoded_length = field_vGCS__VBSAssignmentResult->RAW_encode(PDU__BSSMAP__VGCS__VBSAssignmentResult_descr_, *myleaf.body.node.nodes[69]);
    myleaf.body.node.nodes[69]->coding_descr = &PDU__BSSMAP__VGCS__VBSAssignmentResult_descr_;
    break;
  case ALT_vGCS__VBSAssignmentFailure:
    myleaf.body.node.nodes[70] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 70, PDU__BSSMAP__VGCS__VBSAssignmentFailure_descr_.raw);
    encoded_length = field_vGCS__VBSAssignmentFailure->RAW_encode(PDU__BSSMAP__VGCS__VBSAssignmentFailure_descr_, *myleaf.body.node.nodes[70]);
    myleaf.body.node.nodes[70]->coding_descr = &PDU__BSSMAP__VGCS__VBSAssignmentFailure_descr_;
    break;
  case ALT_vGCS__VBSQueuingIndication:
    myleaf.body.node.nodes[71] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 71, PDU__BSSMAP__VGCS__VBSQueuingIndication_descr_.raw);
    encoded_length = field_vGCS__VBSQueuingIndication->RAW_encode(PDU__BSSMAP__VGCS__VBSQueuingIndication_descr_, *myleaf.body.node.nodes[71]);
    myleaf.body.node.nodes[71]->coding_descr = &PDU__BSSMAP__VGCS__VBSQueuingIndication_descr_;
    break;
  case ALT_vGCS__AdditionalInformation:
    myleaf.body.node.nodes[72] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 72, PDU__BSSMAP__VGCS__AdditionalInformation_descr_.raw);
    encoded_length = field_vGCS__AdditionalInformation->RAW_encode(PDU__BSSMAP__VGCS__AdditionalInformation_descr_, *myleaf.body.node.nodes[72]);
    myleaf.body.node.nodes[72]->coding_descr = &PDU__BSSMAP__VGCS__AdditionalInformation_descr_;
    break;
  case ALT_vGCS__VBS__AreaCellInfo:
    myleaf.body.node.nodes[73] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 73, PDU__BSSMAP__VGCS__VBS__AreaCellInfo_descr_.raw);
    encoded_length = field_vGCS__VBS__AreaCellInfo->RAW_encode(PDU__BSSMAP__VGCS__VBS__AreaCellInfo_descr_, *myleaf.body.node.nodes[73]);
    myleaf.body.node.nodes[73]->coding_descr = &PDU__BSSMAP__VGCS__VBS__AreaCellInfo_descr_;
    break;
  case ALT_vGCS__VBS__AssignmentStatus:
    myleaf.body.node.nodes[74] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 74, PDU__BSSMAP__VGCS__VBS__AssignmentStatus_descr_.raw);
    encoded_length = field_vGCS__VBS__AssignmentStatus->RAW_encode(PDU__BSSMAP__VGCS__VBS__AssignmentStatus_descr_, *myleaf.body.node.nodes[74]);
    myleaf.body.node.nodes[74]->coding_descr = &PDU__BSSMAP__VGCS__VBS__AssignmentStatus_descr_;
    break;
  case ALT_vGCS__SMS:
    myleaf.body.node.nodes[75] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 75, PDU__BSSMAP__VGCS__SMS_descr_.raw);
    encoded_length = field_vGCS__SMS->RAW_encode(PDU__BSSMAP__VGCS__SMS_descr_, *myleaf.body.node.nodes[75]);
    myleaf.body.node.nodes[75]->coding_descr = &PDU__BSSMAP__VGCS__SMS_descr_;
    break;
  case ALT_uplinkApplicationData:
    myleaf.body.node.nodes[76] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 76, PDU__BSSMAP__UplinkApplicationData_descr_.raw);
    encoded_length = field_uplinkApplicationData->RAW_encode(PDU__BSSMAP__UplinkApplicationData_descr_, *myleaf.body.node.nodes[76]);
    myleaf.body.node.nodes[76]->coding_descr = &PDU__BSSMAP__UplinkApplicationData_descr_;
    break;
  case ALT_notificationData:
    myleaf.body.node.nodes[77] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 77, PDU__BSSMAP__NotificationData_descr_.raw);
    encoded_length = field_notificationData->RAW_encode(PDU__BSSMAP__NotificationData_descr_, *myleaf.body.node.nodes[77]);
    myleaf.body.node.nodes[77]->coding_descr = &PDU__BSSMAP__NotificationData_descr_;
    break;
  case ALT_internalHandoverRequired:
    myleaf.body.node.nodes[78] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 78, PDU__BSSMAP__InternalHandoverRequired_descr_.raw);
    encoded_length = field_internalHandoverRequired->RAW_encode(PDU__BSSMAP__InternalHandoverRequired_descr_, *myleaf.body.node.nodes[78]);
    myleaf.body.node.nodes[78]->coding_descr = &PDU__BSSMAP__InternalHandoverRequired_descr_;
    break;
  case ALT_internalHandoverRequiredReject:
    myleaf.body.node.nodes[79] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 79, PDU__BSSMAP__InternalHandoverRequiredReject_descr_.raw);
    encoded_length = field_internalHandoverRequiredReject->RAW_encode(PDU__BSSMAP__InternalHandoverRequiredReject_descr_, *myleaf.body.node.nodes[79]);
    myleaf.body.node.nodes[79]->coding_descr = &PDU__BSSMAP__InternalHandoverRequiredReject_descr_;
    break;
  case ALT_internalHandoverCommand:
    myleaf.body.node.nodes[80] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 80, PDU__BSSMAP__InternalHandoverCommand_descr_.raw);
    encoded_length = field_internalHandoverCommand->RAW_encode(PDU__BSSMAP__InternalHandoverCommand_descr_, *myleaf.body.node.nodes[80]);
    myleaf.body.node.nodes[80]->coding_descr = &PDU__BSSMAP__InternalHandoverCommand_descr_;
    break;
  case ALT_internalHandoverEnquiry:
    myleaf.body.node.nodes[81] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 81, PDU__BSSMAP__InternalHandoverEnquiry_descr_.raw);
    encoded_length = field_internalHandoverEnquiry->RAW_encode(PDU__BSSMAP__InternalHandoverEnquiry_descr_, *myleaf.body.node.nodes[81]);
    myleaf.body.node.nodes[81]->coding_descr = &PDU__BSSMAP__InternalHandoverEnquiry_descr_;
    break;
  case ALT_resetIPResource:
    myleaf.body.node.nodes[82] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 82, PDU__BSSMAP__ResetIPResource_descr_.raw);
    encoded_length = field_resetIPResource->RAW_encode(PDU__BSSMAP__ResetIPResource_descr_, *myleaf.body.node.nodes[82]);
    myleaf.body.node.nodes[82]->coding_descr = &PDU__BSSMAP__ResetIPResource_descr_;
    break;
  case ALT_resetIPResourceAck:
    myleaf.body.node.nodes[83] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 83, PDU__BSSMAP__ResetIPResourceAck_descr_.raw);
    encoded_length = field_resetIPResourceAck->RAW_encode(PDU__BSSMAP__ResetIPResourceAck_descr_, *myleaf.body.node.nodes[83]);
    myleaf.body.node.nodes[83]->coding_descr = &PDU__BSSMAP__ResetIPResourceAck_descr_;
    break;
  case ALT_rerouteCommand:
    myleaf.body.node.nodes[84] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 84, PDU__BSSMAP__RerouteCommand_descr_.raw);
    encoded_length = field_rerouteCommand->RAW_encode(PDU__BSSMAP__RerouteCommand_descr_, *myleaf.body.node.nodes[84]);
    myleaf.body.node.nodes[84]->coding_descr = &PDU__BSSMAP__RerouteCommand_descr_;
    break;
  case ALT_rerouteComplete:
    myleaf.body.node.nodes[85] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 85, PDU__BSSMAP__RerouteComplete_descr_.raw);
    encoded_length = field_rerouteComplete->RAW_encode(PDU__BSSMAP__RerouteComplete_descr_, *myleaf.body.node.nodes[85]);
    myleaf.body.node.nodes[85]->coding_descr = &PDU__BSSMAP__RerouteComplete_descr_;
    break;
  case ALT_lCLS__ConnectControl:
    myleaf.body.node.nodes[86] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 86, PDU__BSSMAP__LCLS__ConnectControl_descr_.raw);
    encoded_length = field_lCLS__ConnectControl->RAW_encode(PDU__BSSMAP__LCLS__ConnectControl_descr_, *myleaf.body.node.nodes[86]);
    myleaf.body.node.nodes[86]->coding_descr = &PDU__BSSMAP__LCLS__ConnectControl_descr_;
    break;
  case ALT_lCLS__connectControlAck:
    myleaf.body.node.nodes[87] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 87, PDU__BSSMAP__LCLS__ConnectControlAck_descr_.raw);
    encoded_length = field_lCLS__connectControlAck->RAW_encode(PDU__BSSMAP__LCLS__ConnectControlAck_descr_, *myleaf.body.node.nodes[87]);
    myleaf.body.node.nodes[87]->coding_descr = &PDU__BSSMAP__LCLS__ConnectControlAck_descr_;
    break;
  case ALT_lCLS__Notification:
    myleaf.body.node.nodes[88] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 88, PDU__BSSMAP__LCLS__Notification_descr_.raw);
    encoded_length = field_lCLS__Notification->RAW_encode(PDU__BSSMAP__LCLS__Notification_descr_, *myleaf.body.node.nodes[88]);
    myleaf.body.node.nodes[88]->coding_descr = &PDU__BSSMAP__LCLS__Notification_descr_;
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void PDU__BSSMAP_template::copy_value(const PDU__BSSMAP& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case PDU__BSSMAP::ALT_assignmentRequest:
single_value.field_assignmentRequest = new PDU__BSSMAP__AssignmentRequest_template(other_value.assignmentRequest());
break;
case PDU__BSSMAP::ALT_assignmentComplete:
single_value.field_assignmentComplete = new PDU__BSSMAP__AssignmentComplete_template(other_value.assignmentComplete());
break;
case PDU__BSSMAP::ALT_assignmentFailure:
single_value.field_assignmentFailure = new PDU__BSSMAP__AssignmentFailure_template(other_value.assignmentFailure());
break;
case PDU__BSSMAP::ALT_channelModifyRequest:
single_value.field_channelModifyRequest = new PDU__BSSMAP__ChannelModifyRequest_template(other_value.channelModifyRequest());
break;
case PDU__BSSMAP::ALT_block:
single_value.field_block = new PDU__BSSMAP__Block_template(other_value.block());
break;
case PDU__BSSMAP::ALT_blockingAck:
single_value.field_blockingAck = new PDU__BSSMAP__BlockingAck_template(other_value.blockingAck());
break;
case PDU__BSSMAP::ALT_bSSInvokeTrace:
single_value.field_bSSInvokeTrace = new PDU__BSSMAP__BSSInvokeTrace_template(other_value.bSSInvokeTrace());
break;
case PDU__BSSMAP::ALT_changeCircuit:
single_value.field_changeCircuit = new PDU__BSSMAP__ChangeCircuit_template(other_value.changeCircuit());
break;
case PDU__BSSMAP::ALT_changeCircuitAck:
single_value.field_changeCircuitAck = new PDU__BSSMAP__ChangeCircuitAck_template(other_value.changeCircuitAck());
break;
case PDU__BSSMAP::ALT_cipherModeCommand:
single_value.field_cipherModeCommand = new PDU__BSSMAP__CipherModeCommand_template(other_value.cipherModeCommand());
break;
case PDU__BSSMAP::ALT_cipherModeComplete:
single_value.field_cipherModeComplete = new PDU__BSSMAP__CipherModeComplete_template(other_value.cipherModeComplete());
break;
case PDU__BSSMAP::ALT_cipherModeReject:
single_value.field_cipherModeReject = new PDU__BSSMAP__CipherModeReject_template(other_value.cipherModeReject());
break;
case PDU__BSSMAP::ALT_circuitGroupBlock:
single_value.field_circuitGroupBlock = new PDU__BSSMAP__CircuitGroupBlock_template(other_value.circuitGroupBlock());
break;
case PDU__BSSMAP::ALT_circuitGroupBlockingAck:
single_value.field_circuitGroupBlockingAck = new PDU__BSSMAP__CircuitGroupBlockingAck_template(other_value.circuitGroupBlockingAck());
break;
case PDU__BSSMAP::ALT_circuitGroupUnblock:
single_value.field_circuitGroupUnblock = new PDU__BSSMAP__CircuitGroupUnblock_template(other_value.circuitGroupUnblock());
break;
case PDU__BSSMAP::ALT_circuitGroupUnblockAck:
single_value.field_circuitGroupUnblockAck = new PDU__BSSMAP__CircuitGroupUnblockAck_template(other_value.circuitGroupUnblockAck());
break;
case PDU__BSSMAP::ALT_classmarkRequest:
single_value.field_classmarkRequest = new PDU__BSSMAP__ClassmarkRequest_template(other_value.classmarkRequest());
break;
case PDU__BSSMAP::ALT_classmarkUpdate:
single_value.field_classmarkUpdate = new PDU__BSSMAP__ClassmarkUpdate_template(other_value.classmarkUpdate());
break;
case PDU__BSSMAP::ALT_clearCommand:
single_value.field_clearCommand = new PDU__BSSMAP__ClearCommand_template(other_value.clearCommand());
break;
case PDU__BSSMAP::ALT_clearComplete:
single_value.field_clearComplete = new PDU__BSSMAP__ClearComplete_template(other_value.clearComplete());
break;
case PDU__BSSMAP::ALT_clearRequest:
single_value.field_clearRequest = new PDU__BSSMAP__ClearRequest_template(other_value.clearRequest());
break;
case PDU__BSSMAP::ALT_commonID:
single_value.field_commonID = new PDU__BSSMAP__CommonID_template(other_value.commonID());
break;
case PDU__BSSMAP::ALT_completeLayer3Information:
single_value.field_completeLayer3Information = new PDU__BSSMAP__CompleteLayer3Information_template(other_value.completeLayer3Information());
break;
case PDU__BSSMAP::ALT_confusion:
single_value.field_confusion = new PDU__BSSMAP__Confusion_template(other_value.confusion());
break;
case PDU__BSSMAP::ALT_connectionlessInformation:
single_value.field_connectionlessInformation = new PDU__BSSMAP__ConnectionlessInformation_template(other_value.connectionlessInformation());
break;
case PDU__BSSMAP::ALT_handoverCandidateEnquire:
single_value.field_handoverCandidateEnquire = new PDU__BSSMAP__HandoverCandidateEnquire_template(other_value.handoverCandidateEnquire());
break;
case PDU__BSSMAP::ALT_handoverCandidateResponse:
single_value.field_handoverCandidateResponse = new PDU__BSSMAP__HandoverCandidateResponse_template(other_value.handoverCandidateResponse());
break;
case PDU__BSSMAP::ALT_handoverCommand:
single_value.field_handoverCommand = new PDU__BSSMAP__HandoverCommand_template(other_value.handoverCommand());
break;
case PDU__BSSMAP::ALT_handoverComplete:
single_value.field_handoverComplete = new PDU__BSSMAP__HandoverComplete_template(other_value.handoverComplete());
break;
case PDU__BSSMAP::ALT_handoverDetect:
single_value.field_handoverDetect = new PDU__BSSMAP__HandoverDetect_template(other_value.handoverDetect());
break;
case PDU__BSSMAP::ALT_handoverFailure:
single_value.field_handoverFailure = new PDU__BSSMAP__HandoverFailure_template(other_value.handoverFailure());
break;
case PDU__BSSMAP::ALT_handoverPerformed:
single_value.field_handoverPerformed = new PDU__BSSMAP__HandoverPerformed_template(other_value.handoverPerformed());
break;
case PDU__BSSMAP::ALT_handoverRequest:
single_value.field_handoverRequest = new PDU__BSSMAP__HandoverRequest_template(other_value.handoverRequest());
break;
case PDU__BSSMAP::ALT_handoverRequestAck:
single_value.field_handoverRequestAck = new PDU__BSSMAP__HandoverRequestAck_template(other_value.handoverRequestAck());
break;
case PDU__BSSMAP::ALT_handoverRequired:
single_value.field_handoverRequired = new PDU__BSSMAP__HandoverRequired_template(other_value.handoverRequired());
break;
case PDU__BSSMAP::ALT_handoverRequiredReject:
single_value.field_handoverRequiredReject = new PDU__BSSMAP__HandoverRequiredReject_template(other_value.handoverRequiredReject());
break;
case PDU__BSSMAP::ALT_handoverSucceeded:
single_value.field_handoverSucceeded = new PDU__BSSMAP__HandoverSucceeded_template(other_value.handoverSucceeded());
break;
case PDU__BSSMAP::ALT_loadIndication:
single_value.field_loadIndication = new PDU__BSSMAP__LoadIndication_template(other_value.loadIndication());
break;
case PDU__BSSMAP::ALT_lSAInformation:
single_value.field_lSAInformation = new PDU__BSSMAP__LSAInformation_template(other_value.lSAInformation());
break;
case PDU__BSSMAP::ALT_mSCInvokeTrace:
single_value.field_mSCInvokeTrace = new PDU__BSSMAP__MSCInvokeTrace_template(other_value.mSCInvokeTrace());
break;
case PDU__BSSMAP::ALT_overload:
single_value.field_overload = new PDU__BSSMAP__Overload_template(other_value.overload());
break;
case PDU__BSSMAP::ALT_paging:
single_value.field_paging = new PDU__BSSMAP__Paging_template(other_value.paging());
break;
case PDU__BSSMAP::ALT_performLocationAbort:
single_value.field_performLocationAbort = new PDU__BSSMAP__PerformLocationAbort_template(other_value.performLocationAbort());
break;
case PDU__BSSMAP::ALT_performLocationRequest:
single_value.field_performLocationRequest = new PDU__BSSMAP__PerformLocationRequest_template(other_value.performLocationRequest());
break;
case PDU__BSSMAP::ALT_performLocationResponse:
single_value.field_performLocationResponse = new PDU__BSSMAP__PerformLocationResponse_template(other_value.performLocationResponse());
break;
case PDU__BSSMAP::ALT_queueingIndication:
single_value.field_queueingIndication = new PDU__BSSMAP__QueueingIndication_template(other_value.queueingIndication());
break;
case PDU__BSSMAP::ALT_reset:
single_value.field_reset = new PDU__BSSMAP__Reset_template(other_value.reset());
break;
case PDU__BSSMAP::ALT_resetAck:
single_value.field_resetAck = new PDU__BSSMAP__ResetAck_template(other_value.resetAck());
break;
case PDU__BSSMAP::ALT_resetCircuit:
single_value.field_resetCircuit = new PDU__BSSMAP__ResetCircuit_template(other_value.resetCircuit());
break;
case PDU__BSSMAP::ALT_resetCircuitAck:
single_value.field_resetCircuitAck = new PDU__BSSMAP__ResetCircuitAck_template(other_value.resetCircuitAck());
break;
case PDU__BSSMAP::ALT_resourceIndication:
single_value.field_resourceIndication = new PDU__BSSMAP__ResourceIndication_template(other_value.resourceIndication());
break;
case PDU__BSSMAP::ALT_resourceRequest:
single_value.field_resourceRequest = new PDU__BSSMAP__ResourceRequest_template(other_value.resourceRequest());
break;
case PDU__BSSMAP::ALT_sAPInReject:
single_value.field_sAPInReject = new PDU__BSSMAP__SAPInReject_template(other_value.sAPInReject());
break;
case PDU__BSSMAP::ALT_suspend:
single_value.field_suspend = new PDU__BSSMAP__Suspend_template(other_value.suspend());
break;
case PDU__BSSMAP::ALT_resume:
single_value.field_resume = new PDU__BSSMAP__Resume_template(other_value.resume());
break;
case PDU__BSSMAP::ALT_unblock:
single_value.field_unblock = new PDU__BSSMAP__Unblock_template(other_value.unblock());
break;
case PDU__BSSMAP::ALT_unblockAck:
single_value.field_unblockAck = new PDU__BSSMAP__UnblockAck_template(other_value.unblockAck());
break;
case PDU__BSSMAP::ALT_unequippedCircuit:
single_value.field_unequippedCircuit = new PDU__BSSMAP__UnequippedCircuit_template(other_value.unequippedCircuit());
break;
case PDU__BSSMAP::ALT_uplinkRequest:
single_value.field_uplinkRequest = new PDU__BSSMAP__UplinkRequest_template(other_value.uplinkRequest());
break;
case PDU__BSSMAP::ALT_uplinkRequestAck:
single_value.field_uplinkRequestAck = new PDU__BSSMAP__UplinkRequestAck_template(other_value.uplinkRequestAck());
break;
case PDU__BSSMAP::ALT_uplinkRequestConfirmation:
single_value.field_uplinkRequestConfirmation = new PDU__BSSMAP__UplinkRequestConfirmation_template(other_value.uplinkRequestConfirmation());
break;
case PDU__BSSMAP::ALT_uplinkReleaseIndication:
single_value.field_uplinkReleaseIndication = new PDU__BSSMAP__UplinkReleaseIndication_template(other_value.uplinkReleaseIndication());
break;
case PDU__BSSMAP::ALT_uplinkRejectCommand:
single_value.field_uplinkRejectCommand = new PDU__BSSMAP__UplinkRejectCommand_template(other_value.uplinkRejectCommand());
break;
case PDU__BSSMAP::ALT_uplinkReleaseCommand:
single_value.field_uplinkReleaseCommand = new PDU__BSSMAP__UplinkReleaseCommand_template(other_value.uplinkReleaseCommand());
break;
case PDU__BSSMAP::ALT_uplinkSeizedCommand:
single_value.field_uplinkSeizedCommand = new PDU__BSSMAP__UplinkSeizedCommand_template(other_value.uplinkSeizedCommand());
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetup:
single_value.field_vGCS__VBSSetup = new PDU__BSSMAP__VGCS__VBSSetup_template(other_value.vGCS__VBSSetup());
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetupAck:
single_value.field_vGCS__VBSSetupAck = new PDU__BSSMAP__VGCS__VBSSetupAck_template(other_value.vGCS__VBSSetupAck());
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetupRefuse:
single_value.field_vGCS__VBSSetupRefuse = new PDU__BSSMAP__VGCS__VBSSetupRefuse_template(other_value.vGCS__VBSSetupRefuse());
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentRequest:
single_value.field_vGCS__VBSAssignmentRequest = new PDU__BSSMAP__VGCS__VBSAssignmentRequest_template(other_value.vGCS__VBSAssignmentRequest());
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentResult:
single_value.field_vGCS__VBSAssignmentResult = new PDU__BSSMAP__VGCS__VBSAssignmentResult_template(other_value.vGCS__VBSAssignmentResult());
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentFailure:
single_value.field_vGCS__VBSAssignmentFailure = new PDU__BSSMAP__VGCS__VBSAssignmentFailure_template(other_value.vGCS__VBSAssignmentFailure());
break;
case PDU__BSSMAP::ALT_vGCS__VBSQueuingIndication:
single_value.field_vGCS__VBSQueuingIndication = new PDU__BSSMAP__VGCS__VBSQueuingIndication_template(other_value.vGCS__VBSQueuingIndication());
break;
case PDU__BSSMAP::ALT_vGCS__AdditionalInformation:
single_value.field_vGCS__AdditionalInformation = new PDU__BSSMAP__VGCS__AdditionalInformation_template(other_value.vGCS__AdditionalInformation());
break;
case PDU__BSSMAP::ALT_vGCS__VBS__AreaCellInfo:
single_value.field_vGCS__VBS__AreaCellInfo = new PDU__BSSMAP__VGCS__VBS__AreaCellInfo_template(other_value.vGCS__VBS__AreaCellInfo());
break;
case PDU__BSSMAP::ALT_vGCS__VBS__AssignmentStatus:
single_value.field_vGCS__VBS__AssignmentStatus = new PDU__BSSMAP__VGCS__VBS__AssignmentStatus_template(other_value.vGCS__VBS__AssignmentStatus());
break;
case PDU__BSSMAP::ALT_vGCS__SMS:
single_value.field_vGCS__SMS = new PDU__BSSMAP__VGCS__SMS_template(other_value.vGCS__SMS());
break;
case PDU__BSSMAP::ALT_uplinkApplicationData:
single_value.field_uplinkApplicationData = new PDU__BSSMAP__UplinkApplicationData_template(other_value.uplinkApplicationData());
break;
case PDU__BSSMAP::ALT_notificationData:
single_value.field_notificationData = new PDU__BSSMAP__NotificationData_template(other_value.notificationData());
break;
case PDU__BSSMAP::ALT_internalHandoverRequired:
single_value.field_internalHandoverRequired = new PDU__BSSMAP__InternalHandoverRequired_template(other_value.internalHandoverRequired());
break;
case PDU__BSSMAP::ALT_internalHandoverRequiredReject:
single_value.field_internalHandoverRequiredReject = new PDU__BSSMAP__InternalHandoverRequiredReject_template(other_value.internalHandoverRequiredReject());
break;
case PDU__BSSMAP::ALT_internalHandoverCommand:
single_value.field_internalHandoverCommand = new PDU__BSSMAP__InternalHandoverCommand_template(other_value.internalHandoverCommand());
break;
case PDU__BSSMAP::ALT_internalHandoverEnquiry:
single_value.field_internalHandoverEnquiry = new PDU__BSSMAP__InternalHandoverEnquiry_template(other_value.internalHandoverEnquiry());
break;
case PDU__BSSMAP::ALT_resetIPResource:
single_value.field_resetIPResource = new PDU__BSSMAP__ResetIPResource_template(other_value.resetIPResource());
break;
case PDU__BSSMAP::ALT_resetIPResourceAck:
single_value.field_resetIPResourceAck = new PDU__BSSMAP__ResetIPResourceAck_template(other_value.resetIPResourceAck());
break;
case PDU__BSSMAP::ALT_rerouteCommand:
single_value.field_rerouteCommand = new PDU__BSSMAP__RerouteCommand_template(other_value.rerouteCommand());
break;
case PDU__BSSMAP::ALT_rerouteComplete:
single_value.field_rerouteComplete = new PDU__BSSMAP__RerouteComplete_template(other_value.rerouteComplete());
break;
case PDU__BSSMAP::ALT_lCLS__ConnectControl:
single_value.field_lCLS__ConnectControl = new PDU__BSSMAP__LCLS__ConnectControl_template(other_value.lCLS__ConnectControl());
break;
case PDU__BSSMAP::ALT_lCLS__connectControlAck:
single_value.field_lCLS__connectControlAck = new PDU__BSSMAP__LCLS__ConnectControlAck_template(other_value.lCLS__connectControlAck());
break;
case PDU__BSSMAP::ALT_lCLS__Notification:
single_value.field_lCLS__Notification = new PDU__BSSMAP__LCLS__Notification_template(other_value.lCLS__Notification());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @BSSAP_Types.PDU_BSSMAP.");
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSMAP_template::copy_template(const PDU__BSSMAP_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case PDU__BSSMAP::ALT_assignmentRequest:
single_value.field_assignmentRequest = new PDU__BSSMAP__AssignmentRequest_template(*other_value.single_value.field_assignmentRequest);
break;
case PDU__BSSMAP::ALT_assignmentComplete:
single_value.field_assignmentComplete = new PDU__BSSMAP__AssignmentComplete_template(*other_value.single_value.field_assignmentComplete);
break;
case PDU__BSSMAP::ALT_assignmentFailure:
single_value.field_assignmentFailure = new PDU__BSSMAP__AssignmentFailure_template(*other_value.single_value.field_assignmentFailure);
break;
case PDU__BSSMAP::ALT_channelModifyRequest:
single_value.field_channelModifyRequest = new PDU__BSSMAP__ChannelModifyRequest_template(*other_value.single_value.field_channelModifyRequest);
break;
case PDU__BSSMAP::ALT_block:
single_value.field_block = new PDU__BSSMAP__Block_template(*other_value.single_value.field_block);
break;
case PDU__BSSMAP::ALT_blockingAck:
single_value.field_blockingAck = new PDU__BSSMAP__BlockingAck_template(*other_value.single_value.field_blockingAck);
break;
case PDU__BSSMAP::ALT_bSSInvokeTrace:
single_value.field_bSSInvokeTrace = new PDU__BSSMAP__BSSInvokeTrace_template(*other_value.single_value.field_bSSInvokeTrace);
break;
case PDU__BSSMAP::ALT_changeCircuit:
single_value.field_changeCircuit = new PDU__BSSMAP__ChangeCircuit_template(*other_value.single_value.field_changeCircuit);
break;
case PDU__BSSMAP::ALT_changeCircuitAck:
single_value.field_changeCircuitAck = new PDU__BSSMAP__ChangeCircuitAck_template(*other_value.single_value.field_changeCircuitAck);
break;
case PDU__BSSMAP::ALT_cipherModeCommand:
single_value.field_cipherModeCommand = new PDU__BSSMAP__CipherModeCommand_template(*other_value.single_value.field_cipherModeCommand);
break;
case PDU__BSSMAP::ALT_cipherModeComplete:
single_value.field_cipherModeComplete = new PDU__BSSMAP__CipherModeComplete_template(*other_value.single_value.field_cipherModeComplete);
break;
case PDU__BSSMAP::ALT_cipherModeReject:
single_value.field_cipherModeReject = new PDU__BSSMAP__CipherModeReject_template(*other_value.single_value.field_cipherModeReject);
break;
case PDU__BSSMAP::ALT_circuitGroupBlock:
single_value.field_circuitGroupBlock = new PDU__BSSMAP__CircuitGroupBlock_template(*other_value.single_value.field_circuitGroupBlock);
break;
case PDU__BSSMAP::ALT_circuitGroupBlockingAck:
single_value.field_circuitGroupBlockingAck = new PDU__BSSMAP__CircuitGroupBlockingAck_template(*other_value.single_value.field_circuitGroupBlockingAck);
break;
case PDU__BSSMAP::ALT_circuitGroupUnblock:
single_value.field_circuitGroupUnblock = new PDU__BSSMAP__CircuitGroupUnblock_template(*other_value.single_value.field_circuitGroupUnblock);
break;
case PDU__BSSMAP::ALT_circuitGroupUnblockAck:
single_value.field_circuitGroupUnblockAck = new PDU__BSSMAP__CircuitGroupUnblockAck_template(*other_value.single_value.field_circuitGroupUnblockAck);
break;
case PDU__BSSMAP::ALT_classmarkRequest:
single_value.field_classmarkRequest = new PDU__BSSMAP__ClassmarkRequest_template(*other_value.single_value.field_classmarkRequest);
break;
case PDU__BSSMAP::ALT_classmarkUpdate:
single_value.field_classmarkUpdate = new PDU__BSSMAP__ClassmarkUpdate_template(*other_value.single_value.field_classmarkUpdate);
break;
case PDU__BSSMAP::ALT_clearCommand:
single_value.field_clearCommand = new PDU__BSSMAP__ClearCommand_template(*other_value.single_value.field_clearCommand);
break;
case PDU__BSSMAP::ALT_clearComplete:
single_value.field_clearComplete = new PDU__BSSMAP__ClearComplete_template(*other_value.single_value.field_clearComplete);
break;
case PDU__BSSMAP::ALT_clearRequest:
single_value.field_clearRequest = new PDU__BSSMAP__ClearRequest_template(*other_value.single_value.field_clearRequest);
break;
case PDU__BSSMAP::ALT_commonID:
single_value.field_commonID = new PDU__BSSMAP__CommonID_template(*other_value.single_value.field_commonID);
break;
case PDU__BSSMAP::ALT_completeLayer3Information:
single_value.field_completeLayer3Information = new PDU__BSSMAP__CompleteLayer3Information_template(*other_value.single_value.field_completeLayer3Information);
break;
case PDU__BSSMAP::ALT_confusion:
single_value.field_confusion = new PDU__BSSMAP__Confusion_template(*other_value.single_value.field_confusion);
break;
case PDU__BSSMAP::ALT_connectionlessInformation:
single_value.field_connectionlessInformation = new PDU__BSSMAP__ConnectionlessInformation_template(*other_value.single_value.field_connectionlessInformation);
break;
case PDU__BSSMAP::ALT_handoverCandidateEnquire:
single_value.field_handoverCandidateEnquire = new PDU__BSSMAP__HandoverCandidateEnquire_template(*other_value.single_value.field_handoverCandidateEnquire);
break;
case PDU__BSSMAP::ALT_handoverCandidateResponse:
single_value.field_handoverCandidateResponse = new PDU__BSSMAP__HandoverCandidateResponse_template(*other_value.single_value.field_handoverCandidateResponse);
break;
case PDU__BSSMAP::ALT_handoverCommand:
single_value.field_handoverCommand = new PDU__BSSMAP__HandoverCommand_template(*other_value.single_value.field_handoverCommand);
break;
case PDU__BSSMAP::ALT_handoverComplete:
single_value.field_handoverComplete = new PDU__BSSMAP__HandoverComplete_template(*other_value.single_value.field_handoverComplete);
break;
case PDU__BSSMAP::ALT_handoverDetect:
single_value.field_handoverDetect = new PDU__BSSMAP__HandoverDetect_template(*other_value.single_value.field_handoverDetect);
break;
case PDU__BSSMAP::ALT_handoverFailure:
single_value.field_handoverFailure = new PDU__BSSMAP__HandoverFailure_template(*other_value.single_value.field_handoverFailure);
break;
case PDU__BSSMAP::ALT_handoverPerformed:
single_value.field_handoverPerformed = new PDU__BSSMAP__HandoverPerformed_template(*other_value.single_value.field_handoverPerformed);
break;
case PDU__BSSMAP::ALT_handoverRequest:
single_value.field_handoverRequest = new PDU__BSSMAP__HandoverRequest_template(*other_value.single_value.field_handoverRequest);
break;
case PDU__BSSMAP::ALT_handoverRequestAck:
single_value.field_handoverRequestAck = new PDU__BSSMAP__HandoverRequestAck_template(*other_value.single_value.field_handoverRequestAck);
break;
case PDU__BSSMAP::ALT_handoverRequired:
single_value.field_handoverRequired = new PDU__BSSMAP__HandoverRequired_template(*other_value.single_value.field_handoverRequired);
break;
case PDU__BSSMAP::ALT_handoverRequiredReject:
single_value.field_handoverRequiredReject = new PDU__BSSMAP__HandoverRequiredReject_template(*other_value.single_value.field_handoverRequiredReject);
break;
case PDU__BSSMAP::ALT_handoverSucceeded:
single_value.field_handoverSucceeded = new PDU__BSSMAP__HandoverSucceeded_template(*other_value.single_value.field_handoverSucceeded);
break;
case PDU__BSSMAP::ALT_loadIndication:
single_value.field_loadIndication = new PDU__BSSMAP__LoadIndication_template(*other_value.single_value.field_loadIndication);
break;
case PDU__BSSMAP::ALT_lSAInformation:
single_value.field_lSAInformation = new PDU__BSSMAP__LSAInformation_template(*other_value.single_value.field_lSAInformation);
break;
case PDU__BSSMAP::ALT_mSCInvokeTrace:
single_value.field_mSCInvokeTrace = new PDU__BSSMAP__MSCInvokeTrace_template(*other_value.single_value.field_mSCInvokeTrace);
break;
case PDU__BSSMAP::ALT_overload:
single_value.field_overload = new PDU__BSSMAP__Overload_template(*other_value.single_value.field_overload);
break;
case PDU__BSSMAP::ALT_paging:
single_value.field_paging = new PDU__BSSMAP__Paging_template(*other_value.single_value.field_paging);
break;
case PDU__BSSMAP::ALT_performLocationAbort:
single_value.field_performLocationAbort = new PDU__BSSMAP__PerformLocationAbort_template(*other_value.single_value.field_performLocationAbort);
break;
case PDU__BSSMAP::ALT_performLocationRequest:
single_value.field_performLocationRequest = new PDU__BSSMAP__PerformLocationRequest_template(*other_value.single_value.field_performLocationRequest);
break;
case PDU__BSSMAP::ALT_performLocationResponse:
single_value.field_performLocationResponse = new PDU__BSSMAP__PerformLocationResponse_template(*other_value.single_value.field_performLocationResponse);
break;
case PDU__BSSMAP::ALT_queueingIndication:
single_value.field_queueingIndication = new PDU__BSSMAP__QueueingIndication_template(*other_value.single_value.field_queueingIndication);
break;
case PDU__BSSMAP::ALT_reset:
single_value.field_reset = new PDU__BSSMAP__Reset_template(*other_value.single_value.field_reset);
break;
case PDU__BSSMAP::ALT_resetAck:
single_value.field_resetAck = new PDU__BSSMAP__ResetAck_template(*other_value.single_value.field_resetAck);
break;
case PDU__BSSMAP::ALT_resetCircuit:
single_value.field_resetCircuit = new PDU__BSSMAP__ResetCircuit_template(*other_value.single_value.field_resetCircuit);
break;
case PDU__BSSMAP::ALT_resetCircuitAck:
single_value.field_resetCircuitAck = new PDU__BSSMAP__ResetCircuitAck_template(*other_value.single_value.field_resetCircuitAck);
break;
case PDU__BSSMAP::ALT_resourceIndication:
single_value.field_resourceIndication = new PDU__BSSMAP__ResourceIndication_template(*other_value.single_value.field_resourceIndication);
break;
case PDU__BSSMAP::ALT_resourceRequest:
single_value.field_resourceRequest = new PDU__BSSMAP__ResourceRequest_template(*other_value.single_value.field_resourceRequest);
break;
case PDU__BSSMAP::ALT_sAPInReject:
single_value.field_sAPInReject = new PDU__BSSMAP__SAPInReject_template(*other_value.single_value.field_sAPInReject);
break;
case PDU__BSSMAP::ALT_suspend:
single_value.field_suspend = new PDU__BSSMAP__Suspend_template(*other_value.single_value.field_suspend);
break;
case PDU__BSSMAP::ALT_resume:
single_value.field_resume = new PDU__BSSMAP__Resume_template(*other_value.single_value.field_resume);
break;
case PDU__BSSMAP::ALT_unblock:
single_value.field_unblock = new PDU__BSSMAP__Unblock_template(*other_value.single_value.field_unblock);
break;
case PDU__BSSMAP::ALT_unblockAck:
single_value.field_unblockAck = new PDU__BSSMAP__UnblockAck_template(*other_value.single_value.field_unblockAck);
break;
case PDU__BSSMAP::ALT_unequippedCircuit:
single_value.field_unequippedCircuit = new PDU__BSSMAP__UnequippedCircuit_template(*other_value.single_value.field_unequippedCircuit);
break;
case PDU__BSSMAP::ALT_uplinkRequest:
single_value.field_uplinkRequest = new PDU__BSSMAP__UplinkRequest_template(*other_value.single_value.field_uplinkRequest);
break;
case PDU__BSSMAP::ALT_uplinkRequestAck:
single_value.field_uplinkRequestAck = new PDU__BSSMAP__UplinkRequestAck_template(*other_value.single_value.field_uplinkRequestAck);
break;
case PDU__BSSMAP::ALT_uplinkRequestConfirmation:
single_value.field_uplinkRequestConfirmation = new PDU__BSSMAP__UplinkRequestConfirmation_template(*other_value.single_value.field_uplinkRequestConfirmation);
break;
case PDU__BSSMAP::ALT_uplinkReleaseIndication:
single_value.field_uplinkReleaseIndication = new PDU__BSSMAP__UplinkReleaseIndication_template(*other_value.single_value.field_uplinkReleaseIndication);
break;
case PDU__BSSMAP::ALT_uplinkRejectCommand:
single_value.field_uplinkRejectCommand = new PDU__BSSMAP__UplinkRejectCommand_template(*other_value.single_value.field_uplinkRejectCommand);
break;
case PDU__BSSMAP::ALT_uplinkReleaseCommand:
single_value.field_uplinkReleaseCommand = new PDU__BSSMAP__UplinkReleaseCommand_template(*other_value.single_value.field_uplinkReleaseCommand);
break;
case PDU__BSSMAP::ALT_uplinkSeizedCommand:
single_value.field_uplinkSeizedCommand = new PDU__BSSMAP__UplinkSeizedCommand_template(*other_value.single_value.field_uplinkSeizedCommand);
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetup:
single_value.field_vGCS__VBSSetup = new PDU__BSSMAP__VGCS__VBSSetup_template(*other_value.single_value.field_vGCS__VBSSetup);
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetupAck:
single_value.field_vGCS__VBSSetupAck = new PDU__BSSMAP__VGCS__VBSSetupAck_template(*other_value.single_value.field_vGCS__VBSSetupAck);
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetupRefuse:
single_value.field_vGCS__VBSSetupRefuse = new PDU__BSSMAP__VGCS__VBSSetupRefuse_template(*other_value.single_value.field_vGCS__VBSSetupRefuse);
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentRequest:
single_value.field_vGCS__VBSAssignmentRequest = new PDU__BSSMAP__VGCS__VBSAssignmentRequest_template(*other_value.single_value.field_vGCS__VBSAssignmentRequest);
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentResult:
single_value.field_vGCS__VBSAssignmentResult = new PDU__BSSMAP__VGCS__VBSAssignmentResult_template(*other_value.single_value.field_vGCS__VBSAssignmentResult);
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentFailure:
single_value.field_vGCS__VBSAssignmentFailure = new PDU__BSSMAP__VGCS__VBSAssignmentFailure_template(*other_value.single_value.field_vGCS__VBSAssignmentFailure);
break;
case PDU__BSSMAP::ALT_vGCS__VBSQueuingIndication:
single_value.field_vGCS__VBSQueuingIndication = new PDU__BSSMAP__VGCS__VBSQueuingIndication_template(*other_value.single_value.field_vGCS__VBSQueuingIndication);
break;
case PDU__BSSMAP::ALT_vGCS__AdditionalInformation:
single_value.field_vGCS__AdditionalInformation = new PDU__BSSMAP__VGCS__AdditionalInformation_template(*other_value.single_value.field_vGCS__AdditionalInformation);
break;
case PDU__BSSMAP::ALT_vGCS__VBS__AreaCellInfo:
single_value.field_vGCS__VBS__AreaCellInfo = new PDU__BSSMAP__VGCS__VBS__AreaCellInfo_template(*other_value.single_value.field_vGCS__VBS__AreaCellInfo);
break;
case PDU__BSSMAP::ALT_vGCS__VBS__AssignmentStatus:
single_value.field_vGCS__VBS__AssignmentStatus = new PDU__BSSMAP__VGCS__VBS__AssignmentStatus_template(*other_value.single_value.field_vGCS__VBS__AssignmentStatus);
break;
case PDU__BSSMAP::ALT_vGCS__SMS:
single_value.field_vGCS__SMS = new PDU__BSSMAP__VGCS__SMS_template(*other_value.single_value.field_vGCS__SMS);
break;
case PDU__BSSMAP::ALT_uplinkApplicationData:
single_value.field_uplinkApplicationData = new PDU__BSSMAP__UplinkApplicationData_template(*other_value.single_value.field_uplinkApplicationData);
break;
case PDU__BSSMAP::ALT_notificationData:
single_value.field_notificationData = new PDU__BSSMAP__NotificationData_template(*other_value.single_value.field_notificationData);
break;
case PDU__BSSMAP::ALT_internalHandoverRequired:
single_value.field_internalHandoverRequired = new PDU__BSSMAP__InternalHandoverRequired_template(*other_value.single_value.field_internalHandoverRequired);
break;
case PDU__BSSMAP::ALT_internalHandoverRequiredReject:
single_value.field_internalHandoverRequiredReject = new PDU__BSSMAP__InternalHandoverRequiredReject_template(*other_value.single_value.field_internalHandoverRequiredReject);
break;
case PDU__BSSMAP::ALT_internalHandoverCommand:
single_value.field_internalHandoverCommand = new PDU__BSSMAP__InternalHandoverCommand_template(*other_value.single_value.field_internalHandoverCommand);
break;
case PDU__BSSMAP::ALT_internalHandoverEnquiry:
single_value.field_internalHandoverEnquiry = new PDU__BSSMAP__InternalHandoverEnquiry_template(*other_value.single_value.field_internalHandoverEnquiry);
break;
case PDU__BSSMAP::ALT_resetIPResource:
single_value.field_resetIPResource = new PDU__BSSMAP__ResetIPResource_template(*other_value.single_value.field_resetIPResource);
break;
case PDU__BSSMAP::ALT_resetIPResourceAck:
single_value.field_resetIPResourceAck = new PDU__BSSMAP__ResetIPResourceAck_template(*other_value.single_value.field_resetIPResourceAck);
break;
case PDU__BSSMAP::ALT_rerouteCommand:
single_value.field_rerouteCommand = new PDU__BSSMAP__RerouteCommand_template(*other_value.single_value.field_rerouteCommand);
break;
case PDU__BSSMAP::ALT_rerouteComplete:
single_value.field_rerouteComplete = new PDU__BSSMAP__RerouteComplete_template(*other_value.single_value.field_rerouteComplete);
break;
case PDU__BSSMAP::ALT_lCLS__ConnectControl:
single_value.field_lCLS__ConnectControl = new PDU__BSSMAP__LCLS__ConnectControl_template(*other_value.single_value.field_lCLS__ConnectControl);
break;
case PDU__BSSMAP::ALT_lCLS__connectControlAck:
single_value.field_lCLS__connectControlAck = new PDU__BSSMAP__LCLS__ConnectControlAck_template(*other_value.single_value.field_lCLS__connectControlAck);
break;
case PDU__BSSMAP::ALT_lCLS__Notification:
single_value.field_lCLS__Notification = new PDU__BSSMAP__LCLS__Notification_template(*other_value.single_value.field_lCLS__Notification);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @BSSAP_Types.PDU_BSSMAP.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSMAP_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSMAP_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSMAP_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @BSSAP_Types.PDU_BSSMAP.");
}
set_selection(other_value);
}

PDU__BSSMAP_template::PDU__BSSMAP_template()
{
}

PDU__BSSMAP_template::PDU__BSSMAP_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSMAP_template::PDU__BSSMAP_template(const PDU__BSSMAP& other_value)
{
copy_value(other_value);
}

PDU__BSSMAP_template::PDU__BSSMAP_template(const OPTIONAL<PDU__BSSMAP>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @BSSAP_Types.PDU_BSSMAP from an unbound optional field.");
}
}

PDU__BSSMAP_template::PDU__BSSMAP_template(PDU__BSSMAP_template* p_precondition, PDU__BSSMAP_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSMAP_template::PDU__BSSMAP_template(Dynamic_Match_Interface<PDU__BSSMAP>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSMAP>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSMAP_template::PDU__BSSMAP_template(const PDU__BSSMAP_template& other_value)
: Base_Template(){
copy_template(other_value);
}

PDU__BSSMAP_template::~PDU__BSSMAP_template()
{
clean_up();
}

void PDU__BSSMAP_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case PDU__BSSMAP::ALT_assignmentRequest:
delete single_value.field_assignmentRequest;
break;
case PDU__BSSMAP::ALT_assignmentComplete:
delete single_value.field_assignmentComplete;
break;
case PDU__BSSMAP::ALT_assignmentFailure:
delete single_value.field_assignmentFailure;
break;
case PDU__BSSMAP::ALT_channelModifyRequest:
delete single_value.field_channelModifyRequest;
break;
case PDU__BSSMAP::ALT_block:
delete single_value.field_block;
break;
case PDU__BSSMAP::ALT_blockingAck:
delete single_value.field_blockingAck;
break;
case PDU__BSSMAP::ALT_bSSInvokeTrace:
delete single_value.field_bSSInvokeTrace;
break;
case PDU__BSSMAP::ALT_changeCircuit:
delete single_value.field_changeCircuit;
break;
case PDU__BSSMAP::ALT_changeCircuitAck:
delete single_value.field_changeCircuitAck;
break;
case PDU__BSSMAP::ALT_cipherModeCommand:
delete single_value.field_cipherModeCommand;
break;
case PDU__BSSMAP::ALT_cipherModeComplete:
delete single_value.field_cipherModeComplete;
break;
case PDU__BSSMAP::ALT_cipherModeReject:
delete single_value.field_cipherModeReject;
break;
case PDU__BSSMAP::ALT_circuitGroupBlock:
delete single_value.field_circuitGroupBlock;
break;
case PDU__BSSMAP::ALT_circuitGroupBlockingAck:
delete single_value.field_circuitGroupBlockingAck;
break;
case PDU__BSSMAP::ALT_circuitGroupUnblock:
delete single_value.field_circuitGroupUnblock;
break;
case PDU__BSSMAP::ALT_circuitGroupUnblockAck:
delete single_value.field_circuitGroupUnblockAck;
break;
case PDU__BSSMAP::ALT_classmarkRequest:
delete single_value.field_classmarkRequest;
break;
case PDU__BSSMAP::ALT_classmarkUpdate:
delete single_value.field_classmarkUpdate;
break;
case PDU__BSSMAP::ALT_clearCommand:
delete single_value.field_clearCommand;
break;
case PDU__BSSMAP::ALT_clearComplete:
delete single_value.field_clearComplete;
break;
case PDU__BSSMAP::ALT_clearRequest:
delete single_value.field_clearRequest;
break;
case PDU__BSSMAP::ALT_commonID:
delete single_value.field_commonID;
break;
case PDU__BSSMAP::ALT_completeLayer3Information:
delete single_value.field_completeLayer3Information;
break;
case PDU__BSSMAP::ALT_confusion:
delete single_value.field_confusion;
break;
case PDU__BSSMAP::ALT_connectionlessInformation:
delete single_value.field_connectionlessInformation;
break;
case PDU__BSSMAP::ALT_handoverCandidateEnquire:
delete single_value.field_handoverCandidateEnquire;
break;
case PDU__BSSMAP::ALT_handoverCandidateResponse:
delete single_value.field_handoverCandidateResponse;
break;
case PDU__BSSMAP::ALT_handoverCommand:
delete single_value.field_handoverCommand;
break;
case PDU__BSSMAP::ALT_handoverComplete:
delete single_value.field_handoverComplete;
break;
case PDU__BSSMAP::ALT_handoverDetect:
delete single_value.field_handoverDetect;
break;
case PDU__BSSMAP::ALT_handoverFailure:
delete single_value.field_handoverFailure;
break;
case PDU__BSSMAP::ALT_handoverPerformed:
delete single_value.field_handoverPerformed;
break;
case PDU__BSSMAP::ALT_handoverRequest:
delete single_value.field_handoverRequest;
break;
case PDU__BSSMAP::ALT_handoverRequestAck:
delete single_value.field_handoverRequestAck;
break;
case PDU__BSSMAP::ALT_handoverRequired:
delete single_value.field_handoverRequired;
break;
case PDU__BSSMAP::ALT_handoverRequiredReject:
delete single_value.field_handoverRequiredReject;
break;
case PDU__BSSMAP::ALT_handoverSucceeded:
delete single_value.field_handoverSucceeded;
break;
case PDU__BSSMAP::ALT_loadIndication:
delete single_value.field_loadIndication;
break;
case PDU__BSSMAP::ALT_lSAInformation:
delete single_value.field_lSAInformation;
break;
case PDU__BSSMAP::ALT_mSCInvokeTrace:
delete single_value.field_mSCInvokeTrace;
break;
case PDU__BSSMAP::ALT_overload:
delete single_value.field_overload;
break;
case PDU__BSSMAP::ALT_paging:
delete single_value.field_paging;
break;
case PDU__BSSMAP::ALT_performLocationAbort:
delete single_value.field_performLocationAbort;
break;
case PDU__BSSMAP::ALT_performLocationRequest:
delete single_value.field_performLocationRequest;
break;
case PDU__BSSMAP::ALT_performLocationResponse:
delete single_value.field_performLocationResponse;
break;
case PDU__BSSMAP::ALT_queueingIndication:
delete single_value.field_queueingIndication;
break;
case PDU__BSSMAP::ALT_reset:
delete single_value.field_reset;
break;
case PDU__BSSMAP::ALT_resetAck:
delete single_value.field_resetAck;
break;
case PDU__BSSMAP::ALT_resetCircuit:
delete single_value.field_resetCircuit;
break;
case PDU__BSSMAP::ALT_resetCircuitAck:
delete single_value.field_resetCircuitAck;
break;
case PDU__BSSMAP::ALT_resourceIndication:
delete single_value.field_resourceIndication;
break;
case PDU__BSSMAP::ALT_resourceRequest:
delete single_value.field_resourceRequest;
break;
case PDU__BSSMAP::ALT_sAPInReject:
delete single_value.field_sAPInReject;
break;
case PDU__BSSMAP::ALT_suspend:
delete single_value.field_suspend;
break;
case PDU__BSSMAP::ALT_resume:
delete single_value.field_resume;
break;
case PDU__BSSMAP::ALT_unblock:
delete single_value.field_unblock;
break;
case PDU__BSSMAP::ALT_unblockAck:
delete single_value.field_unblockAck;
break;
case PDU__BSSMAP::ALT_unequippedCircuit:
delete single_value.field_unequippedCircuit;
break;
case PDU__BSSMAP::ALT_uplinkRequest:
delete single_value.field_uplinkRequest;
break;
case PDU__BSSMAP::ALT_uplinkRequestAck:
delete single_value.field_uplinkRequestAck;
break;
case PDU__BSSMAP::ALT_uplinkRequestConfirmation:
delete single_value.field_uplinkRequestConfirmation;
break;
case PDU__BSSMAP::ALT_uplinkReleaseIndication:
delete single_value.field_uplinkReleaseIndication;
break;
case PDU__BSSMAP::ALT_uplinkRejectCommand:
delete single_value.field_uplinkRejectCommand;
break;
case PDU__BSSMAP::ALT_uplinkReleaseCommand:
delete single_value.field_uplinkReleaseCommand;
break;
case PDU__BSSMAP::ALT_uplinkSeizedCommand:
delete single_value.field_uplinkSeizedCommand;
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetup:
delete single_value.field_vGCS__VBSSetup;
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetupAck:
delete single_value.field_vGCS__VBSSetupAck;
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetupRefuse:
delete single_value.field_vGCS__VBSSetupRefuse;
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentRequest:
delete single_value.field_vGCS__VBSAssignmentRequest;
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentResult:
delete single_value.field_vGCS__VBSAssignmentResult;
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentFailure:
delete single_value.field_vGCS__VBSAssignmentFailure;
break;
case PDU__BSSMAP::ALT_vGCS__VBSQueuingIndication:
delete single_value.field_vGCS__VBSQueuingIndication;
break;
case PDU__BSSMAP::ALT_vGCS__AdditionalInformation:
delete single_value.field_vGCS__AdditionalInformation;
break;
case PDU__BSSMAP::ALT_vGCS__VBS__AreaCellInfo:
delete single_value.field_vGCS__VBS__AreaCellInfo;
break;
case PDU__BSSMAP::ALT_vGCS__VBS__AssignmentStatus:
delete single_value.field_vGCS__VBS__AssignmentStatus;
break;
case PDU__BSSMAP::ALT_vGCS__SMS:
delete single_value.field_vGCS__SMS;
break;
case PDU__BSSMAP::ALT_uplinkApplicationData:
delete single_value.field_uplinkApplicationData;
break;
case PDU__BSSMAP::ALT_notificationData:
delete single_value.field_notificationData;
break;
case PDU__BSSMAP::ALT_internalHandoverRequired:
delete single_value.field_internalHandoverRequired;
break;
case PDU__BSSMAP::ALT_internalHandoverRequiredReject:
delete single_value.field_internalHandoverRequiredReject;
break;
case PDU__BSSMAP::ALT_internalHandoverCommand:
delete single_value.field_internalHandoverCommand;
break;
case PDU__BSSMAP::ALT_internalHandoverEnquiry:
delete single_value.field_internalHandoverEnquiry;
break;
case PDU__BSSMAP::ALT_resetIPResource:
delete single_value.field_resetIPResource;
break;
case PDU__BSSMAP::ALT_resetIPResourceAck:
delete single_value.field_resetIPResourceAck;
break;
case PDU__BSSMAP::ALT_rerouteCommand:
delete single_value.field_rerouteCommand;
break;
case PDU__BSSMAP::ALT_rerouteComplete:
delete single_value.field_rerouteComplete;
break;
case PDU__BSSMAP::ALT_lCLS__ConnectControl:
delete single_value.field_lCLS__ConnectControl;
break;
case PDU__BSSMAP::ALT_lCLS__connectControlAck:
delete single_value.field_lCLS__connectControlAck;
break;
case PDU__BSSMAP::ALT_lCLS__Notification:
delete single_value.field_lCLS__Notification;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSMAP_template& PDU__BSSMAP_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSMAP_template& PDU__BSSMAP_template::operator=(const PDU__BSSMAP& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSMAP_template& PDU__BSSMAP_template::operator=(const OPTIONAL<PDU__BSSMAP>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSMAP&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @BSSAP_Types.PDU_BSSMAP.");
}
return *this;
}

PDU__BSSMAP_template& PDU__BSSMAP_template::operator=(const PDU__BSSMAP_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSMAP_template::match(const PDU__BSSMAP& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
PDU__BSSMAP::union_selection_type value_selection = other_value.get_selection();
if (value_selection == PDU__BSSMAP::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case PDU__BSSMAP::ALT_assignmentRequest:
return single_value.field_assignmentRequest->match(other_value.assignmentRequest(), legacy);
case PDU__BSSMAP::ALT_assignmentComplete:
return single_value.field_assignmentComplete->match(other_value.assignmentComplete(), legacy);
case PDU__BSSMAP::ALT_assignmentFailure:
return single_value.field_assignmentFailure->match(other_value.assignmentFailure(), legacy);
case PDU__BSSMAP::ALT_channelModifyRequest:
return single_value.field_channelModifyRequest->match(other_value.channelModifyRequest(), legacy);
case PDU__BSSMAP::ALT_block:
return single_value.field_block->match(other_value.block(), legacy);
case PDU__BSSMAP::ALT_blockingAck:
return single_value.field_blockingAck->match(other_value.blockingAck(), legacy);
case PDU__BSSMAP::ALT_bSSInvokeTrace:
return single_value.field_bSSInvokeTrace->match(other_value.bSSInvokeTrace(), legacy);
case PDU__BSSMAP::ALT_changeCircuit:
return single_value.field_changeCircuit->match(other_value.changeCircuit(), legacy);
case PDU__BSSMAP::ALT_changeCircuitAck:
return single_value.field_changeCircuitAck->match(other_value.changeCircuitAck(), legacy);
case PDU__BSSMAP::ALT_cipherModeCommand:
return single_value.field_cipherModeCommand->match(other_value.cipherModeCommand(), legacy);
case PDU__BSSMAP::ALT_cipherModeComplete:
return single_value.field_cipherModeComplete->match(other_value.cipherModeComplete(), legacy);
case PDU__BSSMAP::ALT_cipherModeReject:
return single_value.field_cipherModeReject->match(other_value.cipherModeReject(), legacy);
case PDU__BSSMAP::ALT_circuitGroupBlock:
return single_value.field_circuitGroupBlock->match(other_value.circuitGroupBlock(), legacy);
case PDU__BSSMAP::ALT_circuitGroupBlockingAck:
return single_value.field_circuitGroupBlockingAck->match(other_value.circuitGroupBlockingAck(), legacy);
case PDU__BSSMAP::ALT_circuitGroupUnblock:
return single_value.field_circuitGroupUnblock->match(other_value.circuitGroupUnblock(), legacy);
case PDU__BSSMAP::ALT_circuitGroupUnblockAck:
return single_value.field_circuitGroupUnblockAck->match(other_value.circuitGroupUnblockAck(), legacy);
case PDU__BSSMAP::ALT_classmarkRequest:
return single_value.field_classmarkRequest->match(other_value.classmarkRequest(), legacy);
case PDU__BSSMAP::ALT_classmarkUpdate:
return single_value.field_classmarkUpdate->match(other_value.classmarkUpdate(), legacy);
case PDU__BSSMAP::ALT_clearCommand:
return single_value.field_clearCommand->match(other_value.clearCommand(), legacy);
case PDU__BSSMAP::ALT_clearComplete:
return single_value.field_clearComplete->match(other_value.clearComplete(), legacy);
case PDU__BSSMAP::ALT_clearRequest:
return single_value.field_clearRequest->match(other_value.clearRequest(), legacy);
case PDU__BSSMAP::ALT_commonID:
return single_value.field_commonID->match(other_value.commonID(), legacy);
case PDU__BSSMAP::ALT_completeLayer3Information:
return single_value.field_completeLayer3Information->match(other_value.completeLayer3Information(), legacy);
case PDU__BSSMAP::ALT_confusion:
return single_value.field_confusion->match(other_value.confusion(), legacy);
case PDU__BSSMAP::ALT_connectionlessInformation:
return single_value.field_connectionlessInformation->match(other_value.connectionlessInformation(), legacy);
case PDU__BSSMAP::ALT_handoverCandidateEnquire:
return single_value.field_handoverCandidateEnquire->match(other_value.handoverCandidateEnquire(), legacy);
case PDU__BSSMAP::ALT_handoverCandidateResponse:
return single_value.field_handoverCandidateResponse->match(other_value.handoverCandidateResponse(), legacy);
case PDU__BSSMAP::ALT_handoverCommand:
return single_value.field_handoverCommand->match(other_value.handoverCommand(), legacy);
case PDU__BSSMAP::ALT_handoverComplete:
return single_value.field_handoverComplete->match(other_value.handoverComplete(), legacy);
case PDU__BSSMAP::ALT_handoverDetect:
return single_value.field_handoverDetect->match(other_value.handoverDetect(), legacy);
case PDU__BSSMAP::ALT_handoverFailure:
return single_value.field_handoverFailure->match(other_value.handoverFailure(), legacy);
case PDU__BSSMAP::ALT_handoverPerformed:
return single_value.field_handoverPerformed->match(other_value.handoverPerformed(), legacy);
case PDU__BSSMAP::ALT_handoverRequest:
return single_value.field_handoverRequest->match(other_value.handoverRequest(), legacy);
case PDU__BSSMAP::ALT_handoverRequestAck:
return single_value.field_handoverRequestAck->match(other_value.handoverRequestAck(), legacy);
case PDU__BSSMAP::ALT_handoverRequired:
return single_value.field_handoverRequired->match(other_value.handoverRequired(), legacy);
case PDU__BSSMAP::ALT_handoverRequiredReject:
return single_value.field_handoverRequiredReject->match(other_value.handoverRequiredReject(), legacy);
case PDU__BSSMAP::ALT_handoverSucceeded:
return single_value.field_handoverSucceeded->match(other_value.handoverSucceeded(), legacy);
case PDU__BSSMAP::ALT_loadIndication:
return single_value.field_loadIndication->match(other_value.loadIndication(), legacy);
case PDU__BSSMAP::ALT_lSAInformation:
return single_value.field_lSAInformation->match(other_value.lSAInformation(), legacy);
case PDU__BSSMAP::ALT_mSCInvokeTrace:
return single_value.field_mSCInvokeTrace->match(other_value.mSCInvokeTrace(), legacy);
case PDU__BSSMAP::ALT_overload:
return single_value.field_overload->match(other_value.overload(), legacy);
case PDU__BSSMAP::ALT_paging:
return single_value.field_paging->match(other_value.paging(), legacy);
case PDU__BSSMAP::ALT_performLocationAbort:
return single_value.field_performLocationAbort->match(other_value.performLocationAbort(), legacy);
case PDU__BSSMAP::ALT_performLocationRequest:
return single_value.field_performLocationRequest->match(other_value.performLocationRequest(), legacy);
case PDU__BSSMAP::ALT_performLocationResponse:
return single_value.field_performLocationResponse->match(other_value.performLocationResponse(), legacy);
case PDU__BSSMAP::ALT_queueingIndication:
return single_value.field_queueingIndication->match(other_value.queueingIndication(), legacy);
case PDU__BSSMAP::ALT_reset:
return single_value.field_reset->match(other_value.reset(), legacy);
case PDU__BSSMAP::ALT_resetAck:
return single_value.field_resetAck->match(other_value.resetAck(), legacy);
case PDU__BSSMAP::ALT_resetCircuit:
return single_value.field_resetCircuit->match(other_value.resetCircuit(), legacy);
case PDU__BSSMAP::ALT_resetCircuitAck:
return single_value.field_resetCircuitAck->match(other_value.resetCircuitAck(), legacy);
case PDU__BSSMAP::ALT_resourceIndication:
return single_value.field_resourceIndication->match(other_value.resourceIndication(), legacy);
case PDU__BSSMAP::ALT_resourceRequest:
return single_value.field_resourceRequest->match(other_value.resourceRequest(), legacy);
case PDU__BSSMAP::ALT_sAPInReject:
return single_value.field_sAPInReject->match(other_value.sAPInReject(), legacy);
case PDU__BSSMAP::ALT_suspend:
return single_value.field_suspend->match(other_value.suspend(), legacy);
case PDU__BSSMAP::ALT_resume:
return single_value.field_resume->match(other_value.resume(), legacy);
case PDU__BSSMAP::ALT_unblock:
return single_value.field_unblock->match(other_value.unblock(), legacy);
case PDU__BSSMAP::ALT_unblockAck:
return single_value.field_unblockAck->match(other_value.unblockAck(), legacy);
case PDU__BSSMAP::ALT_unequippedCircuit:
return single_value.field_unequippedCircuit->match(other_value.unequippedCircuit(), legacy);
case PDU__BSSMAP::ALT_uplinkRequest:
return single_value.field_uplinkRequest->match(other_value.uplinkRequest(), legacy);
case PDU__BSSMAP::ALT_uplinkRequestAck:
return single_value.field_uplinkRequestAck->match(other_value.uplinkRequestAck(), legacy);
case PDU__BSSMAP::ALT_uplinkRequestConfirmation:
return single_value.field_uplinkRequestConfirmation->match(other_value.uplinkRequestConfirmation(), legacy);
case PDU__BSSMAP::ALT_uplinkReleaseIndication:
return single_value.field_uplinkReleaseIndication->match(other_value.uplinkReleaseIndication(), legacy);
case PDU__BSSMAP::ALT_uplinkRejectCommand:
return single_value.field_uplinkRejectCommand->match(other_value.uplinkRejectCommand(), legacy);
case PDU__BSSMAP::ALT_uplinkReleaseCommand:
return single_value.field_uplinkReleaseCommand->match(other_value.uplinkReleaseCommand(), legacy);
case PDU__BSSMAP::ALT_uplinkSeizedCommand:
return single_value.field_uplinkSeizedCommand->match(other_value.uplinkSeizedCommand(), legacy);
case PDU__BSSMAP::ALT_vGCS__VBSSetup:
return single_value.field_vGCS__VBSSetup->match(other_value.vGCS__VBSSetup(), legacy);
case PDU__BSSMAP::ALT_vGCS__VBSSetupAck:
return single_value.field_vGCS__VBSSetupAck->match(other_value.vGCS__VBSSetupAck(), legacy);
case PDU__BSSMAP::ALT_vGCS__VBSSetupRefuse:
return single_value.field_vGCS__VBSSetupRefuse->match(other_value.vGCS__VBSSetupRefuse(), legacy);
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentRequest:
return single_value.field_vGCS__VBSAssignmentRequest->match(other_value.vGCS__VBSAssignmentRequest(), legacy);
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentResult:
return single_value.field_vGCS__VBSAssignmentResult->match(other_value.vGCS__VBSAssignmentResult(), legacy);
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentFailure:
return single_value.field_vGCS__VBSAssignmentFailure->match(other_value.vGCS__VBSAssignmentFailure(), legacy);
case PDU__BSSMAP::ALT_vGCS__VBSQueuingIndication:
return single_value.field_vGCS__VBSQueuingIndication->match(other_value.vGCS__VBSQueuingIndication(), legacy);
case PDU__BSSMAP::ALT_vGCS__AdditionalInformation:
return single_value.field_vGCS__AdditionalInformation->match(other_value.vGCS__AdditionalInformation(), legacy);
case PDU__BSSMAP::ALT_vGCS__VBS__AreaCellInfo:
return single_value.field_vGCS__VBS__AreaCellInfo->match(other_value.vGCS__VBS__AreaCellInfo(), legacy);
case PDU__BSSMAP::ALT_vGCS__VBS__AssignmentStatus:
return single_value.field_vGCS__VBS__AssignmentStatus->match(other_value.vGCS__VBS__AssignmentStatus(), legacy);
case PDU__BSSMAP::ALT_vGCS__SMS:
return single_value.field_vGCS__SMS->match(other_value.vGCS__SMS(), legacy);
case PDU__BSSMAP::ALT_uplinkApplicationData:
return single_value.field_uplinkApplicationData->match(other_value.uplinkApplicationData(), legacy);
case PDU__BSSMAP::ALT_notificationData:
return single_value.field_notificationData->match(other_value.notificationData(), legacy);
case PDU__BSSMAP::ALT_internalHandoverRequired:
return single_value.field_internalHandoverRequired->match(other_value.internalHandoverRequired(), legacy);
case PDU__BSSMAP::ALT_internalHandoverRequiredReject:
return single_value.field_internalHandoverRequiredReject->match(other_value.internalHandoverRequiredReject(), legacy);
case PDU__BSSMAP::ALT_internalHandoverCommand:
return single_value.field_internalHandoverCommand->match(other_value.internalHandoverCommand(), legacy);
case PDU__BSSMAP::ALT_internalHandoverEnquiry:
return single_value.field_internalHandoverEnquiry->match(other_value.internalHandoverEnquiry(), legacy);
case PDU__BSSMAP::ALT_resetIPResource:
return single_value.field_resetIPResource->match(other_value.resetIPResource(), legacy);
case PDU__BSSMAP::ALT_resetIPResourceAck:
return single_value.field_resetIPResourceAck->match(other_value.resetIPResourceAck(), legacy);
case PDU__BSSMAP::ALT_rerouteCommand:
return single_value.field_rerouteCommand->match(other_value.rerouteCommand(), legacy);
case PDU__BSSMAP::ALT_rerouteComplete:
return single_value.field_rerouteComplete->match(other_value.rerouteComplete(), legacy);
case PDU__BSSMAP::ALT_lCLS__ConnectControl:
return single_value.field_lCLS__ConnectControl->match(other_value.lCLS__ConnectControl(), legacy);
case PDU__BSSMAP::ALT_lCLS__connectControlAck:
return single_value.field_lCLS__connectControlAck->match(other_value.lCLS__connectControlAck(), legacy);
case PDU__BSSMAP::ALT_lCLS__Notification:
return single_value.field_lCLS__Notification->match(other_value.lCLS__Notification(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @BSSAP_Types.PDU_BSSMAP.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @BSSAP_Types.PDU_BSSMAP.");
}
return FALSE;
}

boolean PDU__BSSMAP_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case PDU__BSSMAP::ALT_assignmentRequest:
return single_value.field_assignmentRequest->is_value();
case PDU__BSSMAP::ALT_assignmentComplete:
return single_value.field_assignmentComplete->is_value();
case PDU__BSSMAP::ALT_assignmentFailure:
return single_value.field_assignmentFailure->is_value();
case PDU__BSSMAP::ALT_channelModifyRequest:
return single_value.field_channelModifyRequest->is_value();
case PDU__BSSMAP::ALT_block:
return single_value.field_block->is_value();
case PDU__BSSMAP::ALT_blockingAck:
return single_value.field_blockingAck->is_value();
case PDU__BSSMAP::ALT_bSSInvokeTrace:
return single_value.field_bSSInvokeTrace->is_value();
case PDU__BSSMAP::ALT_changeCircuit:
return single_value.field_changeCircuit->is_value();
case PDU__BSSMAP::ALT_changeCircuitAck:
return single_value.field_changeCircuitAck->is_value();
case PDU__BSSMAP::ALT_cipherModeCommand:
return single_value.field_cipherModeCommand->is_value();
case PDU__BSSMAP::ALT_cipherModeComplete:
return single_value.field_cipherModeComplete->is_value();
case PDU__BSSMAP::ALT_cipherModeReject:
return single_value.field_cipherModeReject->is_value();
case PDU__BSSMAP::ALT_circuitGroupBlock:
return single_value.field_circuitGroupBlock->is_value();
case PDU__BSSMAP::ALT_circuitGroupBlockingAck:
return single_value.field_circuitGroupBlockingAck->is_value();
case PDU__BSSMAP::ALT_circuitGroupUnblock:
return single_value.field_circuitGroupUnblock->is_value();
case PDU__BSSMAP::ALT_circuitGroupUnblockAck:
return single_value.field_circuitGroupUnblockAck->is_value();
case PDU__BSSMAP::ALT_classmarkRequest:
return single_value.field_classmarkRequest->is_value();
case PDU__BSSMAP::ALT_classmarkUpdate:
return single_value.field_classmarkUpdate->is_value();
case PDU__BSSMAP::ALT_clearCommand:
return single_value.field_clearCommand->is_value();
case PDU__BSSMAP::ALT_clearComplete:
return single_value.field_clearComplete->is_value();
case PDU__BSSMAP::ALT_clearRequest:
return single_value.field_clearRequest->is_value();
case PDU__BSSMAP::ALT_commonID:
return single_value.field_commonID->is_value();
case PDU__BSSMAP::ALT_completeLayer3Information:
return single_value.field_completeLayer3Information->is_value();
case PDU__BSSMAP::ALT_confusion:
return single_value.field_confusion->is_value();
case PDU__BSSMAP::ALT_connectionlessInformation:
return single_value.field_connectionlessInformation->is_value();
case PDU__BSSMAP::ALT_handoverCandidateEnquire:
return single_value.field_handoverCandidateEnquire->is_value();
case PDU__BSSMAP::ALT_handoverCandidateResponse:
return single_value.field_handoverCandidateResponse->is_value();
case PDU__BSSMAP::ALT_handoverCommand:
return single_value.field_handoverCommand->is_value();
case PDU__BSSMAP::ALT_handoverComplete:
return single_value.field_handoverComplete->is_value();
case PDU__BSSMAP::ALT_handoverDetect:
return single_value.field_handoverDetect->is_value();
case PDU__BSSMAP::ALT_handoverFailure:
return single_value.field_handoverFailure->is_value();
case PDU__BSSMAP::ALT_handoverPerformed:
return single_value.field_handoverPerformed->is_value();
case PDU__BSSMAP::ALT_handoverRequest:
return single_value.field_handoverRequest->is_value();
case PDU__BSSMAP::ALT_handoverRequestAck:
return single_value.field_handoverRequestAck->is_value();
case PDU__BSSMAP::ALT_handoverRequired:
return single_value.field_handoverRequired->is_value();
case PDU__BSSMAP::ALT_handoverRequiredReject:
return single_value.field_handoverRequiredReject->is_value();
case PDU__BSSMAP::ALT_handoverSucceeded:
return single_value.field_handoverSucceeded->is_value();
case PDU__BSSMAP::ALT_loadIndication:
return single_value.field_loadIndication->is_value();
case PDU__BSSMAP::ALT_lSAInformation:
return single_value.field_lSAInformation->is_value();
case PDU__BSSMAP::ALT_mSCInvokeTrace:
return single_value.field_mSCInvokeTrace->is_value();
case PDU__BSSMAP::ALT_overload:
return single_value.field_overload->is_value();
case PDU__BSSMAP::ALT_paging:
return single_value.field_paging->is_value();
case PDU__BSSMAP::ALT_performLocationAbort:
return single_value.field_performLocationAbort->is_value();
case PDU__BSSMAP::ALT_performLocationRequest:
return single_value.field_performLocationRequest->is_value();
case PDU__BSSMAP::ALT_performLocationResponse:
return single_value.field_performLocationResponse->is_value();
case PDU__BSSMAP::ALT_queueingIndication:
return single_value.field_queueingIndication->is_value();
case PDU__BSSMAP::ALT_reset:
return single_value.field_reset->is_value();
case PDU__BSSMAP::ALT_resetAck:
return single_value.field_resetAck->is_value();
case PDU__BSSMAP::ALT_resetCircuit:
return single_value.field_resetCircuit->is_value();
case PDU__BSSMAP::ALT_resetCircuitAck:
return single_value.field_resetCircuitAck->is_value();
case PDU__BSSMAP::ALT_resourceIndication:
return single_value.field_resourceIndication->is_value();
case PDU__BSSMAP::ALT_resourceRequest:
return single_value.field_resourceRequest->is_value();
case PDU__BSSMAP::ALT_sAPInReject:
return single_value.field_sAPInReject->is_value();
case PDU__BSSMAP::ALT_suspend:
return single_value.field_suspend->is_value();
case PDU__BSSMAP::ALT_resume:
return single_value.field_resume->is_value();
case PDU__BSSMAP::ALT_unblock:
return single_value.field_unblock->is_value();
case PDU__BSSMAP::ALT_unblockAck:
return single_value.field_unblockAck->is_value();
case PDU__BSSMAP::ALT_unequippedCircuit:
return single_value.field_unequippedCircuit->is_value();
case PDU__BSSMAP::ALT_uplinkRequest:
return single_value.field_uplinkRequest->is_value();
case PDU__BSSMAP::ALT_uplinkRequestAck:
return single_value.field_uplinkRequestAck->is_value();
case PDU__BSSMAP::ALT_uplinkRequestConfirmation:
return single_value.field_uplinkRequestConfirmation->is_value();
case PDU__BSSMAP::ALT_uplinkReleaseIndication:
return single_value.field_uplinkReleaseIndication->is_value();
case PDU__BSSMAP::ALT_uplinkRejectCommand:
return single_value.field_uplinkRejectCommand->is_value();
case PDU__BSSMAP::ALT_uplinkReleaseCommand:
return single_value.field_uplinkReleaseCommand->is_value();
case PDU__BSSMAP::ALT_uplinkSeizedCommand:
return single_value.field_uplinkSeizedCommand->is_value();
case PDU__BSSMAP::ALT_vGCS__VBSSetup:
return single_value.field_vGCS__VBSSetup->is_value();
case PDU__BSSMAP::ALT_vGCS__VBSSetupAck:
return single_value.field_vGCS__VBSSetupAck->is_value();
case PDU__BSSMAP::ALT_vGCS__VBSSetupRefuse:
return single_value.field_vGCS__VBSSetupRefuse->is_value();
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentRequest:
return single_value.field_vGCS__VBSAssignmentRequest->is_value();
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentResult:
return single_value.field_vGCS__VBSAssignmentResult->is_value();
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentFailure:
return single_value.field_vGCS__VBSAssignmentFailure->is_value();
case PDU__BSSMAP::ALT_vGCS__VBSQueuingIndication:
return single_value.field_vGCS__VBSQueuingIndication->is_value();
case PDU__BSSMAP::ALT_vGCS__AdditionalInformation:
return single_value.field_vGCS__AdditionalInformation->is_value();
case PDU__BSSMAP::ALT_vGCS__VBS__AreaCellInfo:
return single_value.field_vGCS__VBS__AreaCellInfo->is_value();
case PDU__BSSMAP::ALT_vGCS__VBS__AssignmentStatus:
return single_value.field_vGCS__VBS__AssignmentStatus->is_value();
case PDU__BSSMAP::ALT_vGCS__SMS:
return single_value.field_vGCS__SMS->is_value();
case PDU__BSSMAP::ALT_uplinkApplicationData:
return single_value.field_uplinkApplicationData->is_value();
case PDU__BSSMAP::ALT_notificationData:
return single_value.field_notificationData->is_value();
case PDU__BSSMAP::ALT_internalHandoverRequired:
return single_value.field_internalHandoverRequired->is_value();
case PDU__BSSMAP::ALT_internalHandoverRequiredReject:
return single_value.field_internalHandoverRequiredReject->is_value();
case PDU__BSSMAP::ALT_internalHandoverCommand:
return single_value.field_internalHandoverCommand->is_value();
case PDU__BSSMAP::ALT_internalHandoverEnquiry:
return single_value.field_internalHandoverEnquiry->is_value();
case PDU__BSSMAP::ALT_resetIPResource:
return single_value.field_resetIPResource->is_value();
case PDU__BSSMAP::ALT_resetIPResourceAck:
return single_value.field_resetIPResourceAck->is_value();
case PDU__BSSMAP::ALT_rerouteCommand:
return single_value.field_rerouteCommand->is_value();
case PDU__BSSMAP::ALT_rerouteComplete:
return single_value.field_rerouteComplete->is_value();
case PDU__BSSMAP::ALT_lCLS__ConnectControl:
return single_value.field_lCLS__ConnectControl->is_value();
case PDU__BSSMAP::ALT_lCLS__connectControlAck:
return single_value.field_lCLS__connectControlAck->is_value();
case PDU__BSSMAP::ALT_lCLS__Notification:
return single_value.field_lCLS__Notification->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @BSSAP_Types.PDU_BSSMAP.");
}
}

PDU__BSSMAP PDU__BSSMAP_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
PDU__BSSMAP ret_val;
switch (single_value.union_selection) {
case PDU__BSSMAP::ALT_assignmentRequest:
ret_val.assignmentRequest() = single_value.field_assignmentRequest->valueof();
break;
case PDU__BSSMAP::ALT_assignmentComplete:
ret_val.assignmentComplete() = single_value.field_assignmentComplete->valueof();
break;
case PDU__BSSMAP::ALT_assignmentFailure:
ret_val.assignmentFailure() = single_value.field_assignmentFailure->valueof();
break;
case PDU__BSSMAP::ALT_channelModifyRequest:
ret_val.channelModifyRequest() = single_value.field_channelModifyRequest->valueof();
break;
case PDU__BSSMAP::ALT_block:
ret_val.block() = single_value.field_block->valueof();
break;
case PDU__BSSMAP::ALT_blockingAck:
ret_val.blockingAck() = single_value.field_blockingAck->valueof();
break;
case PDU__BSSMAP::ALT_bSSInvokeTrace:
ret_val.bSSInvokeTrace() = single_value.field_bSSInvokeTrace->valueof();
break;
case PDU__BSSMAP::ALT_changeCircuit:
ret_val.changeCircuit() = single_value.field_changeCircuit->valueof();
break;
case PDU__BSSMAP::ALT_changeCircuitAck:
ret_val.changeCircuitAck() = single_value.field_changeCircuitAck->valueof();
break;
case PDU__BSSMAP::ALT_cipherModeCommand:
ret_val.cipherModeCommand() = single_value.field_cipherModeCommand->valueof();
break;
case PDU__BSSMAP::ALT_cipherModeComplete:
ret_val.cipherModeComplete() = single_value.field_cipherModeComplete->valueof();
break;
case PDU__BSSMAP::ALT_cipherModeReject:
ret_val.cipherModeReject() = single_value.field_cipherModeReject->valueof();
break;
case PDU__BSSMAP::ALT_circuitGroupBlock:
ret_val.circuitGroupBlock() = single_value.field_circuitGroupBlock->valueof();
break;
case PDU__BSSMAP::ALT_circuitGroupBlockingAck:
ret_val.circuitGroupBlockingAck() = single_value.field_circuitGroupBlockingAck->valueof();
break;
case PDU__BSSMAP::ALT_circuitGroupUnblock:
ret_val.circuitGroupUnblock() = single_value.field_circuitGroupUnblock->valueof();
break;
case PDU__BSSMAP::ALT_circuitGroupUnblockAck:
ret_val.circuitGroupUnblockAck() = single_value.field_circuitGroupUnblockAck->valueof();
break;
case PDU__BSSMAP::ALT_classmarkRequest:
ret_val.classmarkRequest() = single_value.field_classmarkRequest->valueof();
break;
case PDU__BSSMAP::ALT_classmarkUpdate:
ret_val.classmarkUpdate() = single_value.field_classmarkUpdate->valueof();
break;
case PDU__BSSMAP::ALT_clearCommand:
ret_val.clearCommand() = single_value.field_clearCommand->valueof();
break;
case PDU__BSSMAP::ALT_clearComplete:
ret_val.clearComplete() = single_value.field_clearComplete->valueof();
break;
case PDU__BSSMAP::ALT_clearRequest:
ret_val.clearRequest() = single_value.field_clearRequest->valueof();
break;
case PDU__BSSMAP::ALT_commonID:
ret_val.commonID() = single_value.field_commonID->valueof();
break;
case PDU__BSSMAP::ALT_completeLayer3Information:
ret_val.completeLayer3Information() = single_value.field_completeLayer3Information->valueof();
break;
case PDU__BSSMAP::ALT_confusion:
ret_val.confusion() = single_value.field_confusion->valueof();
break;
case PDU__BSSMAP::ALT_connectionlessInformation:
ret_val.connectionlessInformation() = single_value.field_connectionlessInformation->valueof();
break;
case PDU__BSSMAP::ALT_handoverCandidateEnquire:
ret_val.handoverCandidateEnquire() = single_value.field_handoverCandidateEnquire->valueof();
break;
case PDU__BSSMAP::ALT_handoverCandidateResponse:
ret_val.handoverCandidateResponse() = single_value.field_handoverCandidateResponse->valueof();
break;
case PDU__BSSMAP::ALT_handoverCommand:
ret_val.handoverCommand() = single_value.field_handoverCommand->valueof();
break;
case PDU__BSSMAP::ALT_handoverComplete:
ret_val.handoverComplete() = single_value.field_handoverComplete->valueof();
break;
case PDU__BSSMAP::ALT_handoverDetect:
ret_val.handoverDetect() = single_value.field_handoverDetect->valueof();
break;
case PDU__BSSMAP::ALT_handoverFailure:
ret_val.handoverFailure() = single_value.field_handoverFailure->valueof();
break;
case PDU__BSSMAP::ALT_handoverPerformed:
ret_val.handoverPerformed() = single_value.field_handoverPerformed->valueof();
break;
case PDU__BSSMAP::ALT_handoverRequest:
ret_val.handoverRequest() = single_value.field_handoverRequest->valueof();
break;
case PDU__BSSMAP::ALT_handoverRequestAck:
ret_val.handoverRequestAck() = single_value.field_handoverRequestAck->valueof();
break;
case PDU__BSSMAP::ALT_handoverRequired:
ret_val.handoverRequired() = single_value.field_handoverRequired->valueof();
break;
case PDU__BSSMAP::ALT_handoverRequiredReject:
ret_val.handoverRequiredReject() = single_value.field_handoverRequiredReject->valueof();
break;
case PDU__BSSMAP::ALT_handoverSucceeded:
ret_val.handoverSucceeded() = single_value.field_handoverSucceeded->valueof();
break;
case PDU__BSSMAP::ALT_loadIndication:
ret_val.loadIndication() = single_value.field_loadIndication->valueof();
break;
case PDU__BSSMAP::ALT_lSAInformation:
ret_val.lSAInformation() = single_value.field_lSAInformation->valueof();
break;
case PDU__BSSMAP::ALT_mSCInvokeTrace:
ret_val.mSCInvokeTrace() = single_value.field_mSCInvokeTrace->valueof();
break;
case PDU__BSSMAP::ALT_overload:
ret_val.overload() = single_value.field_overload->valueof();
break;
case PDU__BSSMAP::ALT_paging:
ret_val.paging() = single_value.field_paging->valueof();
break;
case PDU__BSSMAP::ALT_performLocationAbort:
ret_val.performLocationAbort() = single_value.field_performLocationAbort->valueof();
break;
case PDU__BSSMAP::ALT_performLocationRequest:
ret_val.performLocationRequest() = single_value.field_performLocationRequest->valueof();
break;
case PDU__BSSMAP::ALT_performLocationResponse:
ret_val.performLocationResponse() = single_value.field_performLocationResponse->valueof();
break;
case PDU__BSSMAP::ALT_queueingIndication:
ret_val.queueingIndication() = single_value.field_queueingIndication->valueof();
break;
case PDU__BSSMAP::ALT_reset:
ret_val.reset() = single_value.field_reset->valueof();
break;
case PDU__BSSMAP::ALT_resetAck:
ret_val.resetAck() = single_value.field_resetAck->valueof();
break;
case PDU__BSSMAP::ALT_resetCircuit:
ret_val.resetCircuit() = single_value.field_resetCircuit->valueof();
break;
case PDU__BSSMAP::ALT_resetCircuitAck:
ret_val.resetCircuitAck() = single_value.field_resetCircuitAck->valueof();
break;
case PDU__BSSMAP::ALT_resourceIndication:
ret_val.resourceIndication() = single_value.field_resourceIndication->valueof();
break;
case PDU__BSSMAP::ALT_resourceRequest:
ret_val.resourceRequest() = single_value.field_resourceRequest->valueof();
break;
case PDU__BSSMAP::ALT_sAPInReject:
ret_val.sAPInReject() = single_value.field_sAPInReject->valueof();
break;
case PDU__BSSMAP::ALT_suspend:
ret_val.suspend() = single_value.field_suspend->valueof();
break;
case PDU__BSSMAP::ALT_resume:
ret_val.resume() = single_value.field_resume->valueof();
break;
case PDU__BSSMAP::ALT_unblock:
ret_val.unblock() = single_value.field_unblock->valueof();
break;
case PDU__BSSMAP::ALT_unblockAck:
ret_val.unblockAck() = single_value.field_unblockAck->valueof();
break;
case PDU__BSSMAP::ALT_unequippedCircuit:
ret_val.unequippedCircuit() = single_value.field_unequippedCircuit->valueof();
break;
case PDU__BSSMAP::ALT_uplinkRequest:
ret_val.uplinkRequest() = single_value.field_uplinkRequest->valueof();
break;
case PDU__BSSMAP::ALT_uplinkRequestAck:
ret_val.uplinkRequestAck() = single_value.field_uplinkRequestAck->valueof();
break;
case PDU__BSSMAP::ALT_uplinkRequestConfirmation:
ret_val.uplinkRequestConfirmation() = single_value.field_uplinkRequestConfirmation->valueof();
break;
case PDU__BSSMAP::ALT_uplinkReleaseIndication:
ret_val.uplinkReleaseIndication() = single_value.field_uplinkReleaseIndication->valueof();
break;
case PDU__BSSMAP::ALT_uplinkRejectCommand:
ret_val.uplinkRejectCommand() = single_value.field_uplinkRejectCommand->valueof();
break;
case PDU__BSSMAP::ALT_uplinkReleaseCommand:
ret_val.uplinkReleaseCommand() = single_value.field_uplinkReleaseCommand->valueof();
break;
case PDU__BSSMAP::ALT_uplinkSeizedCommand:
ret_val.uplinkSeizedCommand() = single_value.field_uplinkSeizedCommand->valueof();
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetup:
ret_val.vGCS__VBSSetup() = single_value.field_vGCS__VBSSetup->valueof();
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetupAck:
ret_val.vGCS__VBSSetupAck() = single_value.field_vGCS__VBSSetupAck->valueof();
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetupRefuse:
ret_val.vGCS__VBSSetupRefuse() = single_value.field_vGCS__VBSSetupRefuse->valueof();
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentRequest:
ret_val.vGCS__VBSAssignmentRequest() = single_value.field_vGCS__VBSAssignmentRequest->valueof();
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentResult:
ret_val.vGCS__VBSAssignmentResult() = single_value.field_vGCS__VBSAssignmentResult->valueof();
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentFailure:
ret_val.vGCS__VBSAssignmentFailure() = single_value.field_vGCS__VBSAssignmentFailure->valueof();
break;
case PDU__BSSMAP::ALT_vGCS__VBSQueuingIndication:
ret_val.vGCS__VBSQueuingIndication() = single_value.field_vGCS__VBSQueuingIndication->valueof();
break;
case PDU__BSSMAP::ALT_vGCS__AdditionalInformation:
ret_val.vGCS__AdditionalInformation() = single_value.field_vGCS__AdditionalInformation->valueof();
break;
case PDU__BSSMAP::ALT_vGCS__VBS__AreaCellInfo:
ret_val.vGCS__VBS__AreaCellInfo() = single_value.field_vGCS__VBS__AreaCellInfo->valueof();
break;
case PDU__BSSMAP::ALT_vGCS__VBS__AssignmentStatus:
ret_val.vGCS__VBS__AssignmentStatus() = single_value.field_vGCS__VBS__AssignmentStatus->valueof();
break;
case PDU__BSSMAP::ALT_vGCS__SMS:
ret_val.vGCS__SMS() = single_value.field_vGCS__SMS->valueof();
break;
case PDU__BSSMAP::ALT_uplinkApplicationData:
ret_val.uplinkApplicationData() = single_value.field_uplinkApplicationData->valueof();
break;
case PDU__BSSMAP::ALT_notificationData:
ret_val.notificationData() = single_value.field_notificationData->valueof();
break;
case PDU__BSSMAP::ALT_internalHandoverRequired:
ret_val.internalHandoverRequired() = single_value.field_internalHandoverRequired->valueof();
break;
case PDU__BSSMAP::ALT_internalHandoverRequiredReject:
ret_val.internalHandoverRequiredReject() = single_value.field_internalHandoverRequiredReject->valueof();
break;
case PDU__BSSMAP::ALT_internalHandoverCommand:
ret_val.internalHandoverCommand() = single_value.field_internalHandoverCommand->valueof();
break;
case PDU__BSSMAP::ALT_internalHandoverEnquiry:
ret_val.internalHandoverEnquiry() = single_value.field_internalHandoverEnquiry->valueof();
break;
case PDU__BSSMAP::ALT_resetIPResource:
ret_val.resetIPResource() = single_value.field_resetIPResource->valueof();
break;
case PDU__BSSMAP::ALT_resetIPResourceAck:
ret_val.resetIPResourceAck() = single_value.field_resetIPResourceAck->valueof();
break;
case PDU__BSSMAP::ALT_rerouteCommand:
ret_val.rerouteCommand() = single_value.field_rerouteCommand->valueof();
break;
case PDU__BSSMAP::ALT_rerouteComplete:
ret_val.rerouteComplete() = single_value.field_rerouteComplete->valueof();
break;
case PDU__BSSMAP::ALT_lCLS__ConnectControl:
ret_val.lCLS__ConnectControl() = single_value.field_lCLS__ConnectControl->valueof();
break;
case PDU__BSSMAP::ALT_lCLS__connectControlAck:
ret_val.lCLS__connectControlAck() = single_value.field_lCLS__connectControlAck->valueof();
break;
case PDU__BSSMAP::ALT_lCLS__Notification:
ret_val.lCLS__Notification() = single_value.field_lCLS__Notification->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @BSSAP_Types.PDU_BSSMAP.");
}
return ret_val;
}

PDU__BSSMAP_template& PDU__BSSMAP_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @BSSAP_Types.PDU_BSSMAP.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @BSSAP_Types.PDU_BSSMAP.");
return value_list.list_value[list_index];
}
void PDU__BSSMAP_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @BSSAP_Types.PDU_BSSMAP.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSMAP_template[list_length];
}

PDU__BSSMAP__AssignmentRequest_template& PDU__BSSMAP_template::assignmentRequest()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_assignmentRequest) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_assignmentRequest = new PDU__BSSMAP__AssignmentRequest_template(ANY_VALUE);
else single_value.field_assignmentRequest = new PDU__BSSMAP__AssignmentRequest_template;
single_value.union_selection = PDU__BSSMAP::ALT_assignmentRequest;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_assignmentRequest;
}

const PDU__BSSMAP__AssignmentRequest_template& PDU__BSSMAP_template::assignmentRequest() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field assignmentRequest in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_assignmentRequest) TTCN_error("Accessing non-selected field assignmentRequest in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_assignmentRequest;
}

PDU__BSSMAP__AssignmentComplete_template& PDU__BSSMAP_template::assignmentComplete()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_assignmentComplete) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_assignmentComplete = new PDU__BSSMAP__AssignmentComplete_template(ANY_VALUE);
else single_value.field_assignmentComplete = new PDU__BSSMAP__AssignmentComplete_template;
single_value.union_selection = PDU__BSSMAP::ALT_assignmentComplete;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_assignmentComplete;
}

const PDU__BSSMAP__AssignmentComplete_template& PDU__BSSMAP_template::assignmentComplete() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field assignmentComplete in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_assignmentComplete) TTCN_error("Accessing non-selected field assignmentComplete in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_assignmentComplete;
}

PDU__BSSMAP__AssignmentFailure_template& PDU__BSSMAP_template::assignmentFailure()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_assignmentFailure) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_assignmentFailure = new PDU__BSSMAP__AssignmentFailure_template(ANY_VALUE);
else single_value.field_assignmentFailure = new PDU__BSSMAP__AssignmentFailure_template;
single_value.union_selection = PDU__BSSMAP::ALT_assignmentFailure;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_assignmentFailure;
}

const PDU__BSSMAP__AssignmentFailure_template& PDU__BSSMAP_template::assignmentFailure() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field assignmentFailure in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_assignmentFailure) TTCN_error("Accessing non-selected field assignmentFailure in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_assignmentFailure;
}

PDU__BSSMAP__ChannelModifyRequest_template& PDU__BSSMAP_template::channelModifyRequest()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_channelModifyRequest) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_channelModifyRequest = new PDU__BSSMAP__ChannelModifyRequest_template(ANY_VALUE);
else single_value.field_channelModifyRequest = new PDU__BSSMAP__ChannelModifyRequest_template;
single_value.union_selection = PDU__BSSMAP::ALT_channelModifyRequest;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_channelModifyRequest;
}

const PDU__BSSMAP__ChannelModifyRequest_template& PDU__BSSMAP_template::channelModifyRequest() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field channelModifyRequest in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_channelModifyRequest) TTCN_error("Accessing non-selected field channelModifyRequest in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_channelModifyRequest;
}

PDU__BSSMAP__Block_template& PDU__BSSMAP_template::block()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_block) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_block = new PDU__BSSMAP__Block_template(ANY_VALUE);
else single_value.field_block = new PDU__BSSMAP__Block_template;
single_value.union_selection = PDU__BSSMAP::ALT_block;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_block;
}

const PDU__BSSMAP__Block_template& PDU__BSSMAP_template::block() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field block in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_block) TTCN_error("Accessing non-selected field block in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_block;
}

PDU__BSSMAP__BlockingAck_template& PDU__BSSMAP_template::blockingAck()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_blockingAck) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_blockingAck = new PDU__BSSMAP__BlockingAck_template(ANY_VALUE);
else single_value.field_blockingAck = new PDU__BSSMAP__BlockingAck_template;
single_value.union_selection = PDU__BSSMAP::ALT_blockingAck;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_blockingAck;
}

const PDU__BSSMAP__BlockingAck_template& PDU__BSSMAP_template::blockingAck() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field blockingAck in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_blockingAck) TTCN_error("Accessing non-selected field blockingAck in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_blockingAck;
}

PDU__BSSMAP__BSSInvokeTrace_template& PDU__BSSMAP_template::bSSInvokeTrace()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_bSSInvokeTrace) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_bSSInvokeTrace = new PDU__BSSMAP__BSSInvokeTrace_template(ANY_VALUE);
else single_value.field_bSSInvokeTrace = new PDU__BSSMAP__BSSInvokeTrace_template;
single_value.union_selection = PDU__BSSMAP::ALT_bSSInvokeTrace;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_bSSInvokeTrace;
}

const PDU__BSSMAP__BSSInvokeTrace_template& PDU__BSSMAP_template::bSSInvokeTrace() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field bSSInvokeTrace in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_bSSInvokeTrace) TTCN_error("Accessing non-selected field bSSInvokeTrace in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_bSSInvokeTrace;
}

PDU__BSSMAP__ChangeCircuit_template& PDU__BSSMAP_template::changeCircuit()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_changeCircuit) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_changeCircuit = new PDU__BSSMAP__ChangeCircuit_template(ANY_VALUE);
else single_value.field_changeCircuit = new PDU__BSSMAP__ChangeCircuit_template;
single_value.union_selection = PDU__BSSMAP::ALT_changeCircuit;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_changeCircuit;
}

const PDU__BSSMAP__ChangeCircuit_template& PDU__BSSMAP_template::changeCircuit() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field changeCircuit in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_changeCircuit) TTCN_error("Accessing non-selected field changeCircuit in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_changeCircuit;
}

PDU__BSSMAP__ChangeCircuitAck_template& PDU__BSSMAP_template::changeCircuitAck()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_changeCircuitAck) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_changeCircuitAck = new PDU__BSSMAP__ChangeCircuitAck_template(ANY_VALUE);
else single_value.field_changeCircuitAck = new PDU__BSSMAP__ChangeCircuitAck_template;
single_value.union_selection = PDU__BSSMAP::ALT_changeCircuitAck;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_changeCircuitAck;
}

const PDU__BSSMAP__ChangeCircuitAck_template& PDU__BSSMAP_template::changeCircuitAck() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field changeCircuitAck in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_changeCircuitAck) TTCN_error("Accessing non-selected field changeCircuitAck in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_changeCircuitAck;
}

PDU__BSSMAP__CipherModeCommand_template& PDU__BSSMAP_template::cipherModeCommand()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_cipherModeCommand) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cipherModeCommand = new PDU__BSSMAP__CipherModeCommand_template(ANY_VALUE);
else single_value.field_cipherModeCommand = new PDU__BSSMAP__CipherModeCommand_template;
single_value.union_selection = PDU__BSSMAP::ALT_cipherModeCommand;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cipherModeCommand;
}

const PDU__BSSMAP__CipherModeCommand_template& PDU__BSSMAP_template::cipherModeCommand() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cipherModeCommand in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_cipherModeCommand) TTCN_error("Accessing non-selected field cipherModeCommand in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_cipherModeCommand;
}

PDU__BSSMAP__CipherModeComplete_template& PDU__BSSMAP_template::cipherModeComplete()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_cipherModeComplete) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cipherModeComplete = new PDU__BSSMAP__CipherModeComplete_template(ANY_VALUE);
else single_value.field_cipherModeComplete = new PDU__BSSMAP__CipherModeComplete_template;
single_value.union_selection = PDU__BSSMAP::ALT_cipherModeComplete;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cipherModeComplete;
}

const PDU__BSSMAP__CipherModeComplete_template& PDU__BSSMAP_template::cipherModeComplete() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cipherModeComplete in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_cipherModeComplete) TTCN_error("Accessing non-selected field cipherModeComplete in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_cipherModeComplete;
}

PDU__BSSMAP__CipherModeReject_template& PDU__BSSMAP_template::cipherModeReject()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_cipherModeReject) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cipherModeReject = new PDU__BSSMAP__CipherModeReject_template(ANY_VALUE);
else single_value.field_cipherModeReject = new PDU__BSSMAP__CipherModeReject_template;
single_value.union_selection = PDU__BSSMAP::ALT_cipherModeReject;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cipherModeReject;
}

const PDU__BSSMAP__CipherModeReject_template& PDU__BSSMAP_template::cipherModeReject() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cipherModeReject in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_cipherModeReject) TTCN_error("Accessing non-selected field cipherModeReject in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_cipherModeReject;
}

PDU__BSSMAP__CircuitGroupBlock_template& PDU__BSSMAP_template::circuitGroupBlock()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_circuitGroupBlock) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_circuitGroupBlock = new PDU__BSSMAP__CircuitGroupBlock_template(ANY_VALUE);
else single_value.field_circuitGroupBlock = new PDU__BSSMAP__CircuitGroupBlock_template;
single_value.union_selection = PDU__BSSMAP::ALT_circuitGroupBlock;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_circuitGroupBlock;
}

const PDU__BSSMAP__CircuitGroupBlock_template& PDU__BSSMAP_template::circuitGroupBlock() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field circuitGroupBlock in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_circuitGroupBlock) TTCN_error("Accessing non-selected field circuitGroupBlock in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_circuitGroupBlock;
}

PDU__BSSMAP__CircuitGroupBlockingAck_template& PDU__BSSMAP_template::circuitGroupBlockingAck()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_circuitGroupBlockingAck) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_circuitGroupBlockingAck = new PDU__BSSMAP__CircuitGroupBlockingAck_template(ANY_VALUE);
else single_value.field_circuitGroupBlockingAck = new PDU__BSSMAP__CircuitGroupBlockingAck_template;
single_value.union_selection = PDU__BSSMAP::ALT_circuitGroupBlockingAck;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_circuitGroupBlockingAck;
}

const PDU__BSSMAP__CircuitGroupBlockingAck_template& PDU__BSSMAP_template::circuitGroupBlockingAck() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field circuitGroupBlockingAck in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_circuitGroupBlockingAck) TTCN_error("Accessing non-selected field circuitGroupBlockingAck in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_circuitGroupBlockingAck;
}

PDU__BSSMAP__CircuitGroupUnblock_template& PDU__BSSMAP_template::circuitGroupUnblock()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_circuitGroupUnblock) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_circuitGroupUnblock = new PDU__BSSMAP__CircuitGroupUnblock_template(ANY_VALUE);
else single_value.field_circuitGroupUnblock = new PDU__BSSMAP__CircuitGroupUnblock_template;
single_value.union_selection = PDU__BSSMAP::ALT_circuitGroupUnblock;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_circuitGroupUnblock;
}

const PDU__BSSMAP__CircuitGroupUnblock_template& PDU__BSSMAP_template::circuitGroupUnblock() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field circuitGroupUnblock in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_circuitGroupUnblock) TTCN_error("Accessing non-selected field circuitGroupUnblock in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_circuitGroupUnblock;
}

PDU__BSSMAP__CircuitGroupUnblockAck_template& PDU__BSSMAP_template::circuitGroupUnblockAck()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_circuitGroupUnblockAck) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_circuitGroupUnblockAck = new PDU__BSSMAP__CircuitGroupUnblockAck_template(ANY_VALUE);
else single_value.field_circuitGroupUnblockAck = new PDU__BSSMAP__CircuitGroupUnblockAck_template;
single_value.union_selection = PDU__BSSMAP::ALT_circuitGroupUnblockAck;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_circuitGroupUnblockAck;
}

const PDU__BSSMAP__CircuitGroupUnblockAck_template& PDU__BSSMAP_template::circuitGroupUnblockAck() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field circuitGroupUnblockAck in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_circuitGroupUnblockAck) TTCN_error("Accessing non-selected field circuitGroupUnblockAck in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_circuitGroupUnblockAck;
}

PDU__BSSMAP__ClassmarkRequest_template& PDU__BSSMAP_template::classmarkRequest()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_classmarkRequest) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_classmarkRequest = new PDU__BSSMAP__ClassmarkRequest_template(ANY_VALUE);
else single_value.field_classmarkRequest = new PDU__BSSMAP__ClassmarkRequest_template;
single_value.union_selection = PDU__BSSMAP::ALT_classmarkRequest;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_classmarkRequest;
}

const PDU__BSSMAP__ClassmarkRequest_template& PDU__BSSMAP_template::classmarkRequest() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field classmarkRequest in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_classmarkRequest) TTCN_error("Accessing non-selected field classmarkRequest in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_classmarkRequest;
}

PDU__BSSMAP__ClassmarkUpdate_template& PDU__BSSMAP_template::classmarkUpdate()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_classmarkUpdate) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_classmarkUpdate = new PDU__BSSMAP__ClassmarkUpdate_template(ANY_VALUE);
else single_value.field_classmarkUpdate = new PDU__BSSMAP__ClassmarkUpdate_template;
single_value.union_selection = PDU__BSSMAP::ALT_classmarkUpdate;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_classmarkUpdate;
}

const PDU__BSSMAP__ClassmarkUpdate_template& PDU__BSSMAP_template::classmarkUpdate() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field classmarkUpdate in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_classmarkUpdate) TTCN_error("Accessing non-selected field classmarkUpdate in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_classmarkUpdate;
}

PDU__BSSMAP__ClearCommand_template& PDU__BSSMAP_template::clearCommand()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_clearCommand) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_clearCommand = new PDU__BSSMAP__ClearCommand_template(ANY_VALUE);
else single_value.field_clearCommand = new PDU__BSSMAP__ClearCommand_template;
single_value.union_selection = PDU__BSSMAP::ALT_clearCommand;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_clearCommand;
}

const PDU__BSSMAP__ClearCommand_template& PDU__BSSMAP_template::clearCommand() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field clearCommand in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_clearCommand) TTCN_error("Accessing non-selected field clearCommand in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_clearCommand;
}

PDU__BSSMAP__ClearComplete_template& PDU__BSSMAP_template::clearComplete()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_clearComplete) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_clearComplete = new PDU__BSSMAP__ClearComplete_template(ANY_VALUE);
else single_value.field_clearComplete = new PDU__BSSMAP__ClearComplete_template;
single_value.union_selection = PDU__BSSMAP::ALT_clearComplete;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_clearComplete;
}

const PDU__BSSMAP__ClearComplete_template& PDU__BSSMAP_template::clearComplete() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field clearComplete in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_clearComplete) TTCN_error("Accessing non-selected field clearComplete in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_clearComplete;
}

PDU__BSSMAP__ClearRequest_template& PDU__BSSMAP_template::clearRequest()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_clearRequest) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_clearRequest = new PDU__BSSMAP__ClearRequest_template(ANY_VALUE);
else single_value.field_clearRequest = new PDU__BSSMAP__ClearRequest_template;
single_value.union_selection = PDU__BSSMAP::ALT_clearRequest;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_clearRequest;
}

const PDU__BSSMAP__ClearRequest_template& PDU__BSSMAP_template::clearRequest() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field clearRequest in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_clearRequest) TTCN_error("Accessing non-selected field clearRequest in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_clearRequest;
}

PDU__BSSMAP__CommonID_template& PDU__BSSMAP_template::commonID()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_commonID) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_commonID = new PDU__BSSMAP__CommonID_template(ANY_VALUE);
else single_value.field_commonID = new PDU__BSSMAP__CommonID_template;
single_value.union_selection = PDU__BSSMAP::ALT_commonID;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_commonID;
}

const PDU__BSSMAP__CommonID_template& PDU__BSSMAP_template::commonID() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field commonID in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_commonID) TTCN_error("Accessing non-selected field commonID in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_commonID;
}

PDU__BSSMAP__CompleteLayer3Information_template& PDU__BSSMAP_template::completeLayer3Information()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_completeLayer3Information) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_completeLayer3Information = new PDU__BSSMAP__CompleteLayer3Information_template(ANY_VALUE);
else single_value.field_completeLayer3Information = new PDU__BSSMAP__CompleteLayer3Information_template;
single_value.union_selection = PDU__BSSMAP::ALT_completeLayer3Information;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_completeLayer3Information;
}

const PDU__BSSMAP__CompleteLayer3Information_template& PDU__BSSMAP_template::completeLayer3Information() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field completeLayer3Information in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_completeLayer3Information) TTCN_error("Accessing non-selected field completeLayer3Information in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_completeLayer3Information;
}

PDU__BSSMAP__Confusion_template& PDU__BSSMAP_template::confusion()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_confusion) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_confusion = new PDU__BSSMAP__Confusion_template(ANY_VALUE);
else single_value.field_confusion = new PDU__BSSMAP__Confusion_template;
single_value.union_selection = PDU__BSSMAP::ALT_confusion;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_confusion;
}

const PDU__BSSMAP__Confusion_template& PDU__BSSMAP_template::confusion() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field confusion in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_confusion) TTCN_error("Accessing non-selected field confusion in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_confusion;
}

PDU__BSSMAP__ConnectionlessInformation_template& PDU__BSSMAP_template::connectionlessInformation()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_connectionlessInformation) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_connectionlessInformation = new PDU__BSSMAP__ConnectionlessInformation_template(ANY_VALUE);
else single_value.field_connectionlessInformation = new PDU__BSSMAP__ConnectionlessInformation_template;
single_value.union_selection = PDU__BSSMAP::ALT_connectionlessInformation;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_connectionlessInformation;
}

const PDU__BSSMAP__ConnectionlessInformation_template& PDU__BSSMAP_template::connectionlessInformation() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field connectionlessInformation in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_connectionlessInformation) TTCN_error("Accessing non-selected field connectionlessInformation in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_connectionlessInformation;
}

PDU__BSSMAP__HandoverCandidateEnquire_template& PDU__BSSMAP_template::handoverCandidateEnquire()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_handoverCandidateEnquire) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_handoverCandidateEnquire = new PDU__BSSMAP__HandoverCandidateEnquire_template(ANY_VALUE);
else single_value.field_handoverCandidateEnquire = new PDU__BSSMAP__HandoverCandidateEnquire_template;
single_value.union_selection = PDU__BSSMAP::ALT_handoverCandidateEnquire;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_handoverCandidateEnquire;
}

const PDU__BSSMAP__HandoverCandidateEnquire_template& PDU__BSSMAP_template::handoverCandidateEnquire() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field handoverCandidateEnquire in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_handoverCandidateEnquire) TTCN_error("Accessing non-selected field handoverCandidateEnquire in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_handoverCandidateEnquire;
}

PDU__BSSMAP__HandoverCandidateResponse_template& PDU__BSSMAP_template::handoverCandidateResponse()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_handoverCandidateResponse) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_handoverCandidateResponse = new PDU__BSSMAP__HandoverCandidateResponse_template(ANY_VALUE);
else single_value.field_handoverCandidateResponse = new PDU__BSSMAP__HandoverCandidateResponse_template;
single_value.union_selection = PDU__BSSMAP::ALT_handoverCandidateResponse;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_handoverCandidateResponse;
}

const PDU__BSSMAP__HandoverCandidateResponse_template& PDU__BSSMAP_template::handoverCandidateResponse() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field handoverCandidateResponse in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_handoverCandidateResponse) TTCN_error("Accessing non-selected field handoverCandidateResponse in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_handoverCandidateResponse;
}

PDU__BSSMAP__HandoverCommand_template& PDU__BSSMAP_template::handoverCommand()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_handoverCommand) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_handoverCommand = new PDU__BSSMAP__HandoverCommand_template(ANY_VALUE);
else single_value.field_handoverCommand = new PDU__BSSMAP__HandoverCommand_template;
single_value.union_selection = PDU__BSSMAP::ALT_handoverCommand;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_handoverCommand;
}

const PDU__BSSMAP__HandoverCommand_template& PDU__BSSMAP_template::handoverCommand() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field handoverCommand in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_handoverCommand) TTCN_error("Accessing non-selected field handoverCommand in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_handoverCommand;
}

PDU__BSSMAP__HandoverComplete_template& PDU__BSSMAP_template::handoverComplete()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_handoverComplete) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_handoverComplete = new PDU__BSSMAP__HandoverComplete_template(ANY_VALUE);
else single_value.field_handoverComplete = new PDU__BSSMAP__HandoverComplete_template;
single_value.union_selection = PDU__BSSMAP::ALT_handoverComplete;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_handoverComplete;
}

const PDU__BSSMAP__HandoverComplete_template& PDU__BSSMAP_template::handoverComplete() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field handoverComplete in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_handoverComplete) TTCN_error("Accessing non-selected field handoverComplete in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_handoverComplete;
}

PDU__BSSMAP__HandoverDetect_template& PDU__BSSMAP_template::handoverDetect()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_handoverDetect) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_handoverDetect = new PDU__BSSMAP__HandoverDetect_template(ANY_VALUE);
else single_value.field_handoverDetect = new PDU__BSSMAP__HandoverDetect_template;
single_value.union_selection = PDU__BSSMAP::ALT_handoverDetect;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_handoverDetect;
}

const PDU__BSSMAP__HandoverDetect_template& PDU__BSSMAP_template::handoverDetect() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field handoverDetect in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_handoverDetect) TTCN_error("Accessing non-selected field handoverDetect in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_handoverDetect;
}

PDU__BSSMAP__HandoverFailure_template& PDU__BSSMAP_template::handoverFailure()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_handoverFailure) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_handoverFailure = new PDU__BSSMAP__HandoverFailure_template(ANY_VALUE);
else single_value.field_handoverFailure = new PDU__BSSMAP__HandoverFailure_template;
single_value.union_selection = PDU__BSSMAP::ALT_handoverFailure;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_handoverFailure;
}

const PDU__BSSMAP__HandoverFailure_template& PDU__BSSMAP_template::handoverFailure() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field handoverFailure in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_handoverFailure) TTCN_error("Accessing non-selected field handoverFailure in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_handoverFailure;
}

PDU__BSSMAP__HandoverPerformed_template& PDU__BSSMAP_template::handoverPerformed()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_handoverPerformed) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_handoverPerformed = new PDU__BSSMAP__HandoverPerformed_template(ANY_VALUE);
else single_value.field_handoverPerformed = new PDU__BSSMAP__HandoverPerformed_template;
single_value.union_selection = PDU__BSSMAP::ALT_handoverPerformed;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_handoverPerformed;
}

const PDU__BSSMAP__HandoverPerformed_template& PDU__BSSMAP_template::handoverPerformed() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field handoverPerformed in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_handoverPerformed) TTCN_error("Accessing non-selected field handoverPerformed in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_handoverPerformed;
}

PDU__BSSMAP__HandoverRequest_template& PDU__BSSMAP_template::handoverRequest()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_handoverRequest) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_handoverRequest = new PDU__BSSMAP__HandoverRequest_template(ANY_VALUE);
else single_value.field_handoverRequest = new PDU__BSSMAP__HandoverRequest_template;
single_value.union_selection = PDU__BSSMAP::ALT_handoverRequest;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_handoverRequest;
}

const PDU__BSSMAP__HandoverRequest_template& PDU__BSSMAP_template::handoverRequest() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field handoverRequest in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_handoverRequest) TTCN_error("Accessing non-selected field handoverRequest in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_handoverRequest;
}

PDU__BSSMAP__HandoverRequestAck_template& PDU__BSSMAP_template::handoverRequestAck()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_handoverRequestAck) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_handoverRequestAck = new PDU__BSSMAP__HandoverRequestAck_template(ANY_VALUE);
else single_value.field_handoverRequestAck = new PDU__BSSMAP__HandoverRequestAck_template;
single_value.union_selection = PDU__BSSMAP::ALT_handoverRequestAck;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_handoverRequestAck;
}

const PDU__BSSMAP__HandoverRequestAck_template& PDU__BSSMAP_template::handoverRequestAck() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field handoverRequestAck in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_handoverRequestAck) TTCN_error("Accessing non-selected field handoverRequestAck in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_handoverRequestAck;
}

PDU__BSSMAP__HandoverRequired_template& PDU__BSSMAP_template::handoverRequired()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_handoverRequired) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_handoverRequired = new PDU__BSSMAP__HandoverRequired_template(ANY_VALUE);
else single_value.field_handoverRequired = new PDU__BSSMAP__HandoverRequired_template;
single_value.union_selection = PDU__BSSMAP::ALT_handoverRequired;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_handoverRequired;
}

const PDU__BSSMAP__HandoverRequired_template& PDU__BSSMAP_template::handoverRequired() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field handoverRequired in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_handoverRequired) TTCN_error("Accessing non-selected field handoverRequired in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_handoverRequired;
}

PDU__BSSMAP__HandoverRequiredReject_template& PDU__BSSMAP_template::handoverRequiredReject()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_handoverRequiredReject) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_handoverRequiredReject = new PDU__BSSMAP__HandoverRequiredReject_template(ANY_VALUE);
else single_value.field_handoverRequiredReject = new PDU__BSSMAP__HandoverRequiredReject_template;
single_value.union_selection = PDU__BSSMAP::ALT_handoverRequiredReject;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_handoverRequiredReject;
}

const PDU__BSSMAP__HandoverRequiredReject_template& PDU__BSSMAP_template::handoverRequiredReject() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field handoverRequiredReject in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_handoverRequiredReject) TTCN_error("Accessing non-selected field handoverRequiredReject in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_handoverRequiredReject;
}

PDU__BSSMAP__HandoverSucceeded_template& PDU__BSSMAP_template::handoverSucceeded()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_handoverSucceeded) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_handoverSucceeded = new PDU__BSSMAP__HandoverSucceeded_template(ANY_VALUE);
else single_value.field_handoverSucceeded = new PDU__BSSMAP__HandoverSucceeded_template;
single_value.union_selection = PDU__BSSMAP::ALT_handoverSucceeded;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_handoverSucceeded;
}

const PDU__BSSMAP__HandoverSucceeded_template& PDU__BSSMAP_template::handoverSucceeded() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field handoverSucceeded in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_handoverSucceeded) TTCN_error("Accessing non-selected field handoverSucceeded in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_handoverSucceeded;
}

PDU__BSSMAP__LoadIndication_template& PDU__BSSMAP_template::loadIndication()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_loadIndication) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_loadIndication = new PDU__BSSMAP__LoadIndication_template(ANY_VALUE);
else single_value.field_loadIndication = new PDU__BSSMAP__LoadIndication_template;
single_value.union_selection = PDU__BSSMAP::ALT_loadIndication;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_loadIndication;
}

const PDU__BSSMAP__LoadIndication_template& PDU__BSSMAP_template::loadIndication() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field loadIndication in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_loadIndication) TTCN_error("Accessing non-selected field loadIndication in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_loadIndication;
}

PDU__BSSMAP__LSAInformation_template& PDU__BSSMAP_template::lSAInformation()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_lSAInformation) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_lSAInformation = new PDU__BSSMAP__LSAInformation_template(ANY_VALUE);
else single_value.field_lSAInformation = new PDU__BSSMAP__LSAInformation_template;
single_value.union_selection = PDU__BSSMAP::ALT_lSAInformation;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_lSAInformation;
}

const PDU__BSSMAP__LSAInformation_template& PDU__BSSMAP_template::lSAInformation() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field lSAInformation in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_lSAInformation) TTCN_error("Accessing non-selected field lSAInformation in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_lSAInformation;
}

PDU__BSSMAP__MSCInvokeTrace_template& PDU__BSSMAP_template::mSCInvokeTrace()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_mSCInvokeTrace) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_mSCInvokeTrace = new PDU__BSSMAP__MSCInvokeTrace_template(ANY_VALUE);
else single_value.field_mSCInvokeTrace = new PDU__BSSMAP__MSCInvokeTrace_template;
single_value.union_selection = PDU__BSSMAP::ALT_mSCInvokeTrace;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_mSCInvokeTrace;
}

const PDU__BSSMAP__MSCInvokeTrace_template& PDU__BSSMAP_template::mSCInvokeTrace() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field mSCInvokeTrace in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_mSCInvokeTrace) TTCN_error("Accessing non-selected field mSCInvokeTrace in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_mSCInvokeTrace;
}

PDU__BSSMAP__Overload_template& PDU__BSSMAP_template::overload()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_overload) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_overload = new PDU__BSSMAP__Overload_template(ANY_VALUE);
else single_value.field_overload = new PDU__BSSMAP__Overload_template;
single_value.union_selection = PDU__BSSMAP::ALT_overload;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_overload;
}

const PDU__BSSMAP__Overload_template& PDU__BSSMAP_template::overload() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field overload in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_overload) TTCN_error("Accessing non-selected field overload in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_overload;
}

PDU__BSSMAP__Paging_template& PDU__BSSMAP_template::paging()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_paging) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_paging = new PDU__BSSMAP__Paging_template(ANY_VALUE);
else single_value.field_paging = new PDU__BSSMAP__Paging_template;
single_value.union_selection = PDU__BSSMAP::ALT_paging;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_paging;
}

const PDU__BSSMAP__Paging_template& PDU__BSSMAP_template::paging() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field paging in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_paging) TTCN_error("Accessing non-selected field paging in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_paging;
}

PDU__BSSMAP__PerformLocationAbort_template& PDU__BSSMAP_template::performLocationAbort()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_performLocationAbort) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_performLocationAbort = new PDU__BSSMAP__PerformLocationAbort_template(ANY_VALUE);
else single_value.field_performLocationAbort = new PDU__BSSMAP__PerformLocationAbort_template;
single_value.union_selection = PDU__BSSMAP::ALT_performLocationAbort;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_performLocationAbort;
}

const PDU__BSSMAP__PerformLocationAbort_template& PDU__BSSMAP_template::performLocationAbort() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field performLocationAbort in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_performLocationAbort) TTCN_error("Accessing non-selected field performLocationAbort in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_performLocationAbort;
}

PDU__BSSMAP__PerformLocationRequest_template& PDU__BSSMAP_template::performLocationRequest()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_performLocationRequest) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_performLocationRequest = new PDU__BSSMAP__PerformLocationRequest_template(ANY_VALUE);
else single_value.field_performLocationRequest = new PDU__BSSMAP__PerformLocationRequest_template;
single_value.union_selection = PDU__BSSMAP::ALT_performLocationRequest;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_performLocationRequest;
}

const PDU__BSSMAP__PerformLocationRequest_template& PDU__BSSMAP_template::performLocationRequest() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field performLocationRequest in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_performLocationRequest) TTCN_error("Accessing non-selected field performLocationRequest in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_performLocationRequest;
}

PDU__BSSMAP__PerformLocationResponse_template& PDU__BSSMAP_template::performLocationResponse()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_performLocationResponse) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_performLocationResponse = new PDU__BSSMAP__PerformLocationResponse_template(ANY_VALUE);
else single_value.field_performLocationResponse = new PDU__BSSMAP__PerformLocationResponse_template;
single_value.union_selection = PDU__BSSMAP::ALT_performLocationResponse;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_performLocationResponse;
}

const PDU__BSSMAP__PerformLocationResponse_template& PDU__BSSMAP_template::performLocationResponse() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field performLocationResponse in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_performLocationResponse) TTCN_error("Accessing non-selected field performLocationResponse in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_performLocationResponse;
}

PDU__BSSMAP__QueueingIndication_template& PDU__BSSMAP_template::queueingIndication()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_queueingIndication) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_queueingIndication = new PDU__BSSMAP__QueueingIndication_template(ANY_VALUE);
else single_value.field_queueingIndication = new PDU__BSSMAP__QueueingIndication_template;
single_value.union_selection = PDU__BSSMAP::ALT_queueingIndication;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_queueingIndication;
}

const PDU__BSSMAP__QueueingIndication_template& PDU__BSSMAP_template::queueingIndication() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field queueingIndication in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_queueingIndication) TTCN_error("Accessing non-selected field queueingIndication in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_queueingIndication;
}

PDU__BSSMAP__Reset_template& PDU__BSSMAP_template::reset()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_reset) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_reset = new PDU__BSSMAP__Reset_template(ANY_VALUE);
else single_value.field_reset = new PDU__BSSMAP__Reset_template;
single_value.union_selection = PDU__BSSMAP::ALT_reset;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_reset;
}

const PDU__BSSMAP__Reset_template& PDU__BSSMAP_template::reset() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field reset in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_reset) TTCN_error("Accessing non-selected field reset in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_reset;
}

PDU__BSSMAP__ResetAck_template& PDU__BSSMAP_template::resetAck()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_resetAck) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_resetAck = new PDU__BSSMAP__ResetAck_template(ANY_VALUE);
else single_value.field_resetAck = new PDU__BSSMAP__ResetAck_template;
single_value.union_selection = PDU__BSSMAP::ALT_resetAck;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_resetAck;
}

const PDU__BSSMAP__ResetAck_template& PDU__BSSMAP_template::resetAck() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field resetAck in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_resetAck) TTCN_error("Accessing non-selected field resetAck in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_resetAck;
}

PDU__BSSMAP__ResetCircuit_template& PDU__BSSMAP_template::resetCircuit()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_resetCircuit) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_resetCircuit = new PDU__BSSMAP__ResetCircuit_template(ANY_VALUE);
else single_value.field_resetCircuit = new PDU__BSSMAP__ResetCircuit_template;
single_value.union_selection = PDU__BSSMAP::ALT_resetCircuit;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_resetCircuit;
}

const PDU__BSSMAP__ResetCircuit_template& PDU__BSSMAP_template::resetCircuit() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field resetCircuit in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_resetCircuit) TTCN_error("Accessing non-selected field resetCircuit in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_resetCircuit;
}

PDU__BSSMAP__ResetCircuitAck_template& PDU__BSSMAP_template::resetCircuitAck()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_resetCircuitAck) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_resetCircuitAck = new PDU__BSSMAP__ResetCircuitAck_template(ANY_VALUE);
else single_value.field_resetCircuitAck = new PDU__BSSMAP__ResetCircuitAck_template;
single_value.union_selection = PDU__BSSMAP::ALT_resetCircuitAck;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_resetCircuitAck;
}

const PDU__BSSMAP__ResetCircuitAck_template& PDU__BSSMAP_template::resetCircuitAck() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field resetCircuitAck in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_resetCircuitAck) TTCN_error("Accessing non-selected field resetCircuitAck in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_resetCircuitAck;
}

PDU__BSSMAP__ResourceIndication_template& PDU__BSSMAP_template::resourceIndication()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_resourceIndication) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_resourceIndication = new PDU__BSSMAP__ResourceIndication_template(ANY_VALUE);
else single_value.field_resourceIndication = new PDU__BSSMAP__ResourceIndication_template;
single_value.union_selection = PDU__BSSMAP::ALT_resourceIndication;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_resourceIndication;
}

const PDU__BSSMAP__ResourceIndication_template& PDU__BSSMAP_template::resourceIndication() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field resourceIndication in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_resourceIndication) TTCN_error("Accessing non-selected field resourceIndication in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_resourceIndication;
}

PDU__BSSMAP__ResourceRequest_template& PDU__BSSMAP_template::resourceRequest()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_resourceRequest) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_resourceRequest = new PDU__BSSMAP__ResourceRequest_template(ANY_VALUE);
else single_value.field_resourceRequest = new PDU__BSSMAP__ResourceRequest_template;
single_value.union_selection = PDU__BSSMAP::ALT_resourceRequest;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_resourceRequest;
}

const PDU__BSSMAP__ResourceRequest_template& PDU__BSSMAP_template::resourceRequest() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field resourceRequest in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_resourceRequest) TTCN_error("Accessing non-selected field resourceRequest in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_resourceRequest;
}

PDU__BSSMAP__SAPInReject_template& PDU__BSSMAP_template::sAPInReject()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_sAPInReject) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_sAPInReject = new PDU__BSSMAP__SAPInReject_template(ANY_VALUE);
else single_value.field_sAPInReject = new PDU__BSSMAP__SAPInReject_template;
single_value.union_selection = PDU__BSSMAP::ALT_sAPInReject;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_sAPInReject;
}

const PDU__BSSMAP__SAPInReject_template& PDU__BSSMAP_template::sAPInReject() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field sAPInReject in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_sAPInReject) TTCN_error("Accessing non-selected field sAPInReject in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_sAPInReject;
}

PDU__BSSMAP__Suspend_template& PDU__BSSMAP_template::suspend()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_suspend) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_suspend = new PDU__BSSMAP__Suspend_template(ANY_VALUE);
else single_value.field_suspend = new PDU__BSSMAP__Suspend_template;
single_value.union_selection = PDU__BSSMAP::ALT_suspend;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_suspend;
}

const PDU__BSSMAP__Suspend_template& PDU__BSSMAP_template::suspend() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field suspend in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_suspend) TTCN_error("Accessing non-selected field suspend in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_suspend;
}

PDU__BSSMAP__Resume_template& PDU__BSSMAP_template::resume()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_resume) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_resume = new PDU__BSSMAP__Resume_template(ANY_VALUE);
else single_value.field_resume = new PDU__BSSMAP__Resume_template;
single_value.union_selection = PDU__BSSMAP::ALT_resume;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_resume;
}

const PDU__BSSMAP__Resume_template& PDU__BSSMAP_template::resume() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field resume in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_resume) TTCN_error("Accessing non-selected field resume in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_resume;
}

PDU__BSSMAP__Unblock_template& PDU__BSSMAP_template::unblock()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_unblock) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_unblock = new PDU__BSSMAP__Unblock_template(ANY_VALUE);
else single_value.field_unblock = new PDU__BSSMAP__Unblock_template;
single_value.union_selection = PDU__BSSMAP::ALT_unblock;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_unblock;
}

const PDU__BSSMAP__Unblock_template& PDU__BSSMAP_template::unblock() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field unblock in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_unblock) TTCN_error("Accessing non-selected field unblock in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_unblock;
}

PDU__BSSMAP__UnblockAck_template& PDU__BSSMAP_template::unblockAck()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_unblockAck) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_unblockAck = new PDU__BSSMAP__UnblockAck_template(ANY_VALUE);
else single_value.field_unblockAck = new PDU__BSSMAP__UnblockAck_template;
single_value.union_selection = PDU__BSSMAP::ALT_unblockAck;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_unblockAck;
}

const PDU__BSSMAP__UnblockAck_template& PDU__BSSMAP_template::unblockAck() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field unblockAck in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_unblockAck) TTCN_error("Accessing non-selected field unblockAck in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_unblockAck;
}

PDU__BSSMAP__UnequippedCircuit_template& PDU__BSSMAP_template::unequippedCircuit()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_unequippedCircuit) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_unequippedCircuit = new PDU__BSSMAP__UnequippedCircuit_template(ANY_VALUE);
else single_value.field_unequippedCircuit = new PDU__BSSMAP__UnequippedCircuit_template;
single_value.union_selection = PDU__BSSMAP::ALT_unequippedCircuit;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_unequippedCircuit;
}

const PDU__BSSMAP__UnequippedCircuit_template& PDU__BSSMAP_template::unequippedCircuit() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field unequippedCircuit in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_unequippedCircuit) TTCN_error("Accessing non-selected field unequippedCircuit in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_unequippedCircuit;
}

PDU__BSSMAP__UplinkRequest_template& PDU__BSSMAP_template::uplinkRequest()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_uplinkRequest) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_uplinkRequest = new PDU__BSSMAP__UplinkRequest_template(ANY_VALUE);
else single_value.field_uplinkRequest = new PDU__BSSMAP__UplinkRequest_template;
single_value.union_selection = PDU__BSSMAP::ALT_uplinkRequest;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_uplinkRequest;
}

const PDU__BSSMAP__UplinkRequest_template& PDU__BSSMAP_template::uplinkRequest() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field uplinkRequest in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_uplinkRequest) TTCN_error("Accessing non-selected field uplinkRequest in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_uplinkRequest;
}

PDU__BSSMAP__UplinkRequestAck_template& PDU__BSSMAP_template::uplinkRequestAck()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_uplinkRequestAck) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_uplinkRequestAck = new PDU__BSSMAP__UplinkRequestAck_template(ANY_VALUE);
else single_value.field_uplinkRequestAck = new PDU__BSSMAP__UplinkRequestAck_template;
single_value.union_selection = PDU__BSSMAP::ALT_uplinkRequestAck;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_uplinkRequestAck;
}

const PDU__BSSMAP__UplinkRequestAck_template& PDU__BSSMAP_template::uplinkRequestAck() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field uplinkRequestAck in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_uplinkRequestAck) TTCN_error("Accessing non-selected field uplinkRequestAck in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_uplinkRequestAck;
}

PDU__BSSMAP__UplinkRequestConfirmation_template& PDU__BSSMAP_template::uplinkRequestConfirmation()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_uplinkRequestConfirmation) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_uplinkRequestConfirmation = new PDU__BSSMAP__UplinkRequestConfirmation_template(ANY_VALUE);
else single_value.field_uplinkRequestConfirmation = new PDU__BSSMAP__UplinkRequestConfirmation_template;
single_value.union_selection = PDU__BSSMAP::ALT_uplinkRequestConfirmation;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_uplinkRequestConfirmation;
}

const PDU__BSSMAP__UplinkRequestConfirmation_template& PDU__BSSMAP_template::uplinkRequestConfirmation() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field uplinkRequestConfirmation in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_uplinkRequestConfirmation) TTCN_error("Accessing non-selected field uplinkRequestConfirmation in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_uplinkRequestConfirmation;
}

PDU__BSSMAP__UplinkReleaseIndication_template& PDU__BSSMAP_template::uplinkReleaseIndication()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_uplinkReleaseIndication) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_uplinkReleaseIndication = new PDU__BSSMAP__UplinkReleaseIndication_template(ANY_VALUE);
else single_value.field_uplinkReleaseIndication = new PDU__BSSMAP__UplinkReleaseIndication_template;
single_value.union_selection = PDU__BSSMAP::ALT_uplinkReleaseIndication;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_uplinkReleaseIndication;
}

const PDU__BSSMAP__UplinkReleaseIndication_template& PDU__BSSMAP_template::uplinkReleaseIndication() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field uplinkReleaseIndication in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_uplinkReleaseIndication) TTCN_error("Accessing non-selected field uplinkReleaseIndication in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_uplinkReleaseIndication;
}

PDU__BSSMAP__UplinkRejectCommand_template& PDU__BSSMAP_template::uplinkRejectCommand()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_uplinkRejectCommand) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_uplinkRejectCommand = new PDU__BSSMAP__UplinkRejectCommand_template(ANY_VALUE);
else single_value.field_uplinkRejectCommand = new PDU__BSSMAP__UplinkRejectCommand_template;
single_value.union_selection = PDU__BSSMAP::ALT_uplinkRejectCommand;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_uplinkRejectCommand;
}

const PDU__BSSMAP__UplinkRejectCommand_template& PDU__BSSMAP_template::uplinkRejectCommand() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field uplinkRejectCommand in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_uplinkRejectCommand) TTCN_error("Accessing non-selected field uplinkRejectCommand in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_uplinkRejectCommand;
}

PDU__BSSMAP__UplinkReleaseCommand_template& PDU__BSSMAP_template::uplinkReleaseCommand()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_uplinkReleaseCommand) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_uplinkReleaseCommand = new PDU__BSSMAP__UplinkReleaseCommand_template(ANY_VALUE);
else single_value.field_uplinkReleaseCommand = new PDU__BSSMAP__UplinkReleaseCommand_template;
single_value.union_selection = PDU__BSSMAP::ALT_uplinkReleaseCommand;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_uplinkReleaseCommand;
}

const PDU__BSSMAP__UplinkReleaseCommand_template& PDU__BSSMAP_template::uplinkReleaseCommand() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field uplinkReleaseCommand in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_uplinkReleaseCommand) TTCN_error("Accessing non-selected field uplinkReleaseCommand in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_uplinkReleaseCommand;
}

PDU__BSSMAP__UplinkSeizedCommand_template& PDU__BSSMAP_template::uplinkSeizedCommand()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_uplinkSeizedCommand) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_uplinkSeizedCommand = new PDU__BSSMAP__UplinkSeizedCommand_template(ANY_VALUE);
else single_value.field_uplinkSeizedCommand = new PDU__BSSMAP__UplinkSeizedCommand_template;
single_value.union_selection = PDU__BSSMAP::ALT_uplinkSeizedCommand;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_uplinkSeizedCommand;
}

const PDU__BSSMAP__UplinkSeizedCommand_template& PDU__BSSMAP_template::uplinkSeizedCommand() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field uplinkSeizedCommand in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_uplinkSeizedCommand) TTCN_error("Accessing non-selected field uplinkSeizedCommand in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_uplinkSeizedCommand;
}

PDU__BSSMAP__VGCS__VBSSetup_template& PDU__BSSMAP_template::vGCS__VBSSetup()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_vGCS__VBSSetup) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_vGCS__VBSSetup = new PDU__BSSMAP__VGCS__VBSSetup_template(ANY_VALUE);
else single_value.field_vGCS__VBSSetup = new PDU__BSSMAP__VGCS__VBSSetup_template;
single_value.union_selection = PDU__BSSMAP::ALT_vGCS__VBSSetup;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_vGCS__VBSSetup;
}

const PDU__BSSMAP__VGCS__VBSSetup_template& PDU__BSSMAP_template::vGCS__VBSSetup() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field vGCS_VBSSetup in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_vGCS__VBSSetup) TTCN_error("Accessing non-selected field vGCS_VBSSetup in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_vGCS__VBSSetup;
}

PDU__BSSMAP__VGCS__VBSSetupAck_template& PDU__BSSMAP_template::vGCS__VBSSetupAck()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_vGCS__VBSSetupAck) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_vGCS__VBSSetupAck = new PDU__BSSMAP__VGCS__VBSSetupAck_template(ANY_VALUE);
else single_value.field_vGCS__VBSSetupAck = new PDU__BSSMAP__VGCS__VBSSetupAck_template;
single_value.union_selection = PDU__BSSMAP::ALT_vGCS__VBSSetupAck;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_vGCS__VBSSetupAck;
}

const PDU__BSSMAP__VGCS__VBSSetupAck_template& PDU__BSSMAP_template::vGCS__VBSSetupAck() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field vGCS_VBSSetupAck in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_vGCS__VBSSetupAck) TTCN_error("Accessing non-selected field vGCS_VBSSetupAck in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_vGCS__VBSSetupAck;
}

PDU__BSSMAP__VGCS__VBSSetupRefuse_template& PDU__BSSMAP_template::vGCS__VBSSetupRefuse()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_vGCS__VBSSetupRefuse) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_vGCS__VBSSetupRefuse = new PDU__BSSMAP__VGCS__VBSSetupRefuse_template(ANY_VALUE);
else single_value.field_vGCS__VBSSetupRefuse = new PDU__BSSMAP__VGCS__VBSSetupRefuse_template;
single_value.union_selection = PDU__BSSMAP::ALT_vGCS__VBSSetupRefuse;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_vGCS__VBSSetupRefuse;
}

const PDU__BSSMAP__VGCS__VBSSetupRefuse_template& PDU__BSSMAP_template::vGCS__VBSSetupRefuse() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field vGCS_VBSSetupRefuse in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_vGCS__VBSSetupRefuse) TTCN_error("Accessing non-selected field vGCS_VBSSetupRefuse in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_vGCS__VBSSetupRefuse;
}

PDU__BSSMAP__VGCS__VBSAssignmentRequest_template& PDU__BSSMAP_template::vGCS__VBSAssignmentRequest()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_vGCS__VBSAssignmentRequest) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_vGCS__VBSAssignmentRequest = new PDU__BSSMAP__VGCS__VBSAssignmentRequest_template(ANY_VALUE);
else single_value.field_vGCS__VBSAssignmentRequest = new PDU__BSSMAP__VGCS__VBSAssignmentRequest_template;
single_value.union_selection = PDU__BSSMAP::ALT_vGCS__VBSAssignmentRequest;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_vGCS__VBSAssignmentRequest;
}

const PDU__BSSMAP__VGCS__VBSAssignmentRequest_template& PDU__BSSMAP_template::vGCS__VBSAssignmentRequest() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field vGCS_VBSAssignmentRequest in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_vGCS__VBSAssignmentRequest) TTCN_error("Accessing non-selected field vGCS_VBSAssignmentRequest in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_vGCS__VBSAssignmentRequest;
}

PDU__BSSMAP__VGCS__VBSAssignmentResult_template& PDU__BSSMAP_template::vGCS__VBSAssignmentResult()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_vGCS__VBSAssignmentResult) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_vGCS__VBSAssignmentResult = new PDU__BSSMAP__VGCS__VBSAssignmentResult_template(ANY_VALUE);
else single_value.field_vGCS__VBSAssignmentResult = new PDU__BSSMAP__VGCS__VBSAssignmentResult_template;
single_value.union_selection = PDU__BSSMAP::ALT_vGCS__VBSAssignmentResult;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_vGCS__VBSAssignmentResult;
}

const PDU__BSSMAP__VGCS__VBSAssignmentResult_template& PDU__BSSMAP_template::vGCS__VBSAssignmentResult() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field vGCS_VBSAssignmentResult in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_vGCS__VBSAssignmentResult) TTCN_error("Accessing non-selected field vGCS_VBSAssignmentResult in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_vGCS__VBSAssignmentResult;
}

PDU__BSSMAP__VGCS__VBSAssignmentFailure_template& PDU__BSSMAP_template::vGCS__VBSAssignmentFailure()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_vGCS__VBSAssignmentFailure) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_vGCS__VBSAssignmentFailure = new PDU__BSSMAP__VGCS__VBSAssignmentFailure_template(ANY_VALUE);
else single_value.field_vGCS__VBSAssignmentFailure = new PDU__BSSMAP__VGCS__VBSAssignmentFailure_template;
single_value.union_selection = PDU__BSSMAP::ALT_vGCS__VBSAssignmentFailure;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_vGCS__VBSAssignmentFailure;
}

const PDU__BSSMAP__VGCS__VBSAssignmentFailure_template& PDU__BSSMAP_template::vGCS__VBSAssignmentFailure() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field vGCS_VBSAssignmentFailure in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_vGCS__VBSAssignmentFailure) TTCN_error("Accessing non-selected field vGCS_VBSAssignmentFailure in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_vGCS__VBSAssignmentFailure;
}

PDU__BSSMAP__VGCS__VBSQueuingIndication_template& PDU__BSSMAP_template::vGCS__VBSQueuingIndication()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_vGCS__VBSQueuingIndication) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_vGCS__VBSQueuingIndication = new PDU__BSSMAP__VGCS__VBSQueuingIndication_template(ANY_VALUE);
else single_value.field_vGCS__VBSQueuingIndication = new PDU__BSSMAP__VGCS__VBSQueuingIndication_template;
single_value.union_selection = PDU__BSSMAP::ALT_vGCS__VBSQueuingIndication;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_vGCS__VBSQueuingIndication;
}

const PDU__BSSMAP__VGCS__VBSQueuingIndication_template& PDU__BSSMAP_template::vGCS__VBSQueuingIndication() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field vGCS_VBSQueuingIndication in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_vGCS__VBSQueuingIndication) TTCN_error("Accessing non-selected field vGCS_VBSQueuingIndication in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_vGCS__VBSQueuingIndication;
}

PDU__BSSMAP__VGCS__AdditionalInformation_template& PDU__BSSMAP_template::vGCS__AdditionalInformation()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_vGCS__AdditionalInformation) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_vGCS__AdditionalInformation = new PDU__BSSMAP__VGCS__AdditionalInformation_template(ANY_VALUE);
else single_value.field_vGCS__AdditionalInformation = new PDU__BSSMAP__VGCS__AdditionalInformation_template;
single_value.union_selection = PDU__BSSMAP::ALT_vGCS__AdditionalInformation;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_vGCS__AdditionalInformation;
}

const PDU__BSSMAP__VGCS__AdditionalInformation_template& PDU__BSSMAP_template::vGCS__AdditionalInformation() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field vGCS_AdditionalInformation in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_vGCS__AdditionalInformation) TTCN_error("Accessing non-selected field vGCS_AdditionalInformation in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_vGCS__AdditionalInformation;
}

PDU__BSSMAP__VGCS__VBS__AreaCellInfo_template& PDU__BSSMAP_template::vGCS__VBS__AreaCellInfo()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_vGCS__VBS__AreaCellInfo) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_vGCS__VBS__AreaCellInfo = new PDU__BSSMAP__VGCS__VBS__AreaCellInfo_template(ANY_VALUE);
else single_value.field_vGCS__VBS__AreaCellInfo = new PDU__BSSMAP__VGCS__VBS__AreaCellInfo_template;
single_value.union_selection = PDU__BSSMAP::ALT_vGCS__VBS__AreaCellInfo;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_vGCS__VBS__AreaCellInfo;
}

const PDU__BSSMAP__VGCS__VBS__AreaCellInfo_template& PDU__BSSMAP_template::vGCS__VBS__AreaCellInfo() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field vGCS_VBS_AreaCellInfo in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_vGCS__VBS__AreaCellInfo) TTCN_error("Accessing non-selected field vGCS_VBS_AreaCellInfo in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_vGCS__VBS__AreaCellInfo;
}

PDU__BSSMAP__VGCS__VBS__AssignmentStatus_template& PDU__BSSMAP_template::vGCS__VBS__AssignmentStatus()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_vGCS__VBS__AssignmentStatus) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_vGCS__VBS__AssignmentStatus = new PDU__BSSMAP__VGCS__VBS__AssignmentStatus_template(ANY_VALUE);
else single_value.field_vGCS__VBS__AssignmentStatus = new PDU__BSSMAP__VGCS__VBS__AssignmentStatus_template;
single_value.union_selection = PDU__BSSMAP::ALT_vGCS__VBS__AssignmentStatus;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_vGCS__VBS__AssignmentStatus;
}

const PDU__BSSMAP__VGCS__VBS__AssignmentStatus_template& PDU__BSSMAP_template::vGCS__VBS__AssignmentStatus() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field vGCS_VBS_AssignmentStatus in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_vGCS__VBS__AssignmentStatus) TTCN_error("Accessing non-selected field vGCS_VBS_AssignmentStatus in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_vGCS__VBS__AssignmentStatus;
}

PDU__BSSMAP__VGCS__SMS_template& PDU__BSSMAP_template::vGCS__SMS()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_vGCS__SMS) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_vGCS__SMS = new PDU__BSSMAP__VGCS__SMS_template(ANY_VALUE);
else single_value.field_vGCS__SMS = new PDU__BSSMAP__VGCS__SMS_template;
single_value.union_selection = PDU__BSSMAP::ALT_vGCS__SMS;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_vGCS__SMS;
}

const PDU__BSSMAP__VGCS__SMS_template& PDU__BSSMAP_template::vGCS__SMS() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field vGCS_SMS in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_vGCS__SMS) TTCN_error("Accessing non-selected field vGCS_SMS in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_vGCS__SMS;
}

PDU__BSSMAP__UplinkApplicationData_template& PDU__BSSMAP_template::uplinkApplicationData()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_uplinkApplicationData) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_uplinkApplicationData = new PDU__BSSMAP__UplinkApplicationData_template(ANY_VALUE);
else single_value.field_uplinkApplicationData = new PDU__BSSMAP__UplinkApplicationData_template;
single_value.union_selection = PDU__BSSMAP::ALT_uplinkApplicationData;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_uplinkApplicationData;
}

const PDU__BSSMAP__UplinkApplicationData_template& PDU__BSSMAP_template::uplinkApplicationData() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field uplinkApplicationData in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_uplinkApplicationData) TTCN_error("Accessing non-selected field uplinkApplicationData in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_uplinkApplicationData;
}

PDU__BSSMAP__NotificationData_template& PDU__BSSMAP_template::notificationData()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_notificationData) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_notificationData = new PDU__BSSMAP__NotificationData_template(ANY_VALUE);
else single_value.field_notificationData = new PDU__BSSMAP__NotificationData_template;
single_value.union_selection = PDU__BSSMAP::ALT_notificationData;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_notificationData;
}

const PDU__BSSMAP__NotificationData_template& PDU__BSSMAP_template::notificationData() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field notificationData in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_notificationData) TTCN_error("Accessing non-selected field notificationData in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_notificationData;
}

PDU__BSSMAP__InternalHandoverRequired_template& PDU__BSSMAP_template::internalHandoverRequired()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_internalHandoverRequired) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_internalHandoverRequired = new PDU__BSSMAP__InternalHandoverRequired_template(ANY_VALUE);
else single_value.field_internalHandoverRequired = new PDU__BSSMAP__InternalHandoverRequired_template;
single_value.union_selection = PDU__BSSMAP::ALT_internalHandoverRequired;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_internalHandoverRequired;
}

const PDU__BSSMAP__InternalHandoverRequired_template& PDU__BSSMAP_template::internalHandoverRequired() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field internalHandoverRequired in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_internalHandoverRequired) TTCN_error("Accessing non-selected field internalHandoverRequired in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_internalHandoverRequired;
}

PDU__BSSMAP__InternalHandoverRequiredReject_template& PDU__BSSMAP_template::internalHandoverRequiredReject()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_internalHandoverRequiredReject) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_internalHandoverRequiredReject = new PDU__BSSMAP__InternalHandoverRequiredReject_template(ANY_VALUE);
else single_value.field_internalHandoverRequiredReject = new PDU__BSSMAP__InternalHandoverRequiredReject_template;
single_value.union_selection = PDU__BSSMAP::ALT_internalHandoverRequiredReject;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_internalHandoverRequiredReject;
}

const PDU__BSSMAP__InternalHandoverRequiredReject_template& PDU__BSSMAP_template::internalHandoverRequiredReject() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field internalHandoverRequiredReject in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_internalHandoverRequiredReject) TTCN_error("Accessing non-selected field internalHandoverRequiredReject in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_internalHandoverRequiredReject;
}

PDU__BSSMAP__InternalHandoverCommand_template& PDU__BSSMAP_template::internalHandoverCommand()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_internalHandoverCommand) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_internalHandoverCommand = new PDU__BSSMAP__InternalHandoverCommand_template(ANY_VALUE);
else single_value.field_internalHandoverCommand = new PDU__BSSMAP__InternalHandoverCommand_template;
single_value.union_selection = PDU__BSSMAP::ALT_internalHandoverCommand;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_internalHandoverCommand;
}

const PDU__BSSMAP__InternalHandoverCommand_template& PDU__BSSMAP_template::internalHandoverCommand() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field internalHandoverCommand in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_internalHandoverCommand) TTCN_error("Accessing non-selected field internalHandoverCommand in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_internalHandoverCommand;
}

PDU__BSSMAP__InternalHandoverEnquiry_template& PDU__BSSMAP_template::internalHandoverEnquiry()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_internalHandoverEnquiry) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_internalHandoverEnquiry = new PDU__BSSMAP__InternalHandoverEnquiry_template(ANY_VALUE);
else single_value.field_internalHandoverEnquiry = new PDU__BSSMAP__InternalHandoverEnquiry_template;
single_value.union_selection = PDU__BSSMAP::ALT_internalHandoverEnquiry;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_internalHandoverEnquiry;
}

const PDU__BSSMAP__InternalHandoverEnquiry_template& PDU__BSSMAP_template::internalHandoverEnquiry() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field internalHandoverEnquiry in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_internalHandoverEnquiry) TTCN_error("Accessing non-selected field internalHandoverEnquiry in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_internalHandoverEnquiry;
}

PDU__BSSMAP__ResetIPResource_template& PDU__BSSMAP_template::resetIPResource()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_resetIPResource) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_resetIPResource = new PDU__BSSMAP__ResetIPResource_template(ANY_VALUE);
else single_value.field_resetIPResource = new PDU__BSSMAP__ResetIPResource_template;
single_value.union_selection = PDU__BSSMAP::ALT_resetIPResource;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_resetIPResource;
}

const PDU__BSSMAP__ResetIPResource_template& PDU__BSSMAP_template::resetIPResource() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field resetIPResource in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_resetIPResource) TTCN_error("Accessing non-selected field resetIPResource in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_resetIPResource;
}

PDU__BSSMAP__ResetIPResourceAck_template& PDU__BSSMAP_template::resetIPResourceAck()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_resetIPResourceAck) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_resetIPResourceAck = new PDU__BSSMAP__ResetIPResourceAck_template(ANY_VALUE);
else single_value.field_resetIPResourceAck = new PDU__BSSMAP__ResetIPResourceAck_template;
single_value.union_selection = PDU__BSSMAP::ALT_resetIPResourceAck;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_resetIPResourceAck;
}

const PDU__BSSMAP__ResetIPResourceAck_template& PDU__BSSMAP_template::resetIPResourceAck() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field resetIPResourceAck in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_resetIPResourceAck) TTCN_error("Accessing non-selected field resetIPResourceAck in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_resetIPResourceAck;
}

PDU__BSSMAP__RerouteCommand_template& PDU__BSSMAP_template::rerouteCommand()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_rerouteCommand) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_rerouteCommand = new PDU__BSSMAP__RerouteCommand_template(ANY_VALUE);
else single_value.field_rerouteCommand = new PDU__BSSMAP__RerouteCommand_template;
single_value.union_selection = PDU__BSSMAP::ALT_rerouteCommand;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_rerouteCommand;
}

const PDU__BSSMAP__RerouteCommand_template& PDU__BSSMAP_template::rerouteCommand() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field rerouteCommand in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_rerouteCommand) TTCN_error("Accessing non-selected field rerouteCommand in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_rerouteCommand;
}

PDU__BSSMAP__RerouteComplete_template& PDU__BSSMAP_template::rerouteComplete()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_rerouteComplete) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_rerouteComplete = new PDU__BSSMAP__RerouteComplete_template(ANY_VALUE);
else single_value.field_rerouteComplete = new PDU__BSSMAP__RerouteComplete_template;
single_value.union_selection = PDU__BSSMAP::ALT_rerouteComplete;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_rerouteComplete;
}

const PDU__BSSMAP__RerouteComplete_template& PDU__BSSMAP_template::rerouteComplete() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field rerouteComplete in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_rerouteComplete) TTCN_error("Accessing non-selected field rerouteComplete in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_rerouteComplete;
}

PDU__BSSMAP__LCLS__ConnectControl_template& PDU__BSSMAP_template::lCLS__ConnectControl()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_lCLS__ConnectControl) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_lCLS__ConnectControl = new PDU__BSSMAP__LCLS__ConnectControl_template(ANY_VALUE);
else single_value.field_lCLS__ConnectControl = new PDU__BSSMAP__LCLS__ConnectControl_template;
single_value.union_selection = PDU__BSSMAP::ALT_lCLS__ConnectControl;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_lCLS__ConnectControl;
}

const PDU__BSSMAP__LCLS__ConnectControl_template& PDU__BSSMAP_template::lCLS__ConnectControl() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field lCLS_ConnectControl in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_lCLS__ConnectControl) TTCN_error("Accessing non-selected field lCLS_ConnectControl in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_lCLS__ConnectControl;
}

PDU__BSSMAP__LCLS__ConnectControlAck_template& PDU__BSSMAP_template::lCLS__connectControlAck()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_lCLS__connectControlAck) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_lCLS__connectControlAck = new PDU__BSSMAP__LCLS__ConnectControlAck_template(ANY_VALUE);
else single_value.field_lCLS__connectControlAck = new PDU__BSSMAP__LCLS__ConnectControlAck_template;
single_value.union_selection = PDU__BSSMAP::ALT_lCLS__connectControlAck;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_lCLS__connectControlAck;
}

const PDU__BSSMAP__LCLS__ConnectControlAck_template& PDU__BSSMAP_template::lCLS__connectControlAck() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field lCLS_connectControlAck in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_lCLS__connectControlAck) TTCN_error("Accessing non-selected field lCLS_connectControlAck in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_lCLS__connectControlAck;
}

PDU__BSSMAP__LCLS__Notification_template& PDU__BSSMAP_template::lCLS__Notification()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != PDU__BSSMAP::ALT_lCLS__Notification) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_lCLS__Notification = new PDU__BSSMAP__LCLS__Notification_template(ANY_VALUE);
else single_value.field_lCLS__Notification = new PDU__BSSMAP__LCLS__Notification_template;
single_value.union_selection = PDU__BSSMAP::ALT_lCLS__Notification;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_lCLS__Notification;
}

const PDU__BSSMAP__LCLS__Notification_template& PDU__BSSMAP_template::lCLS__Notification() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field lCLS_Notification in a non-specific template of union type @BSSAP_Types.PDU_BSSMAP.");
if (single_value.union_selection != PDU__BSSMAP::ALT_lCLS__Notification) TTCN_error("Accessing non-selected field lCLS_Notification in a template of union type @BSSAP_Types.PDU_BSSMAP.");
return *single_value.field_lCLS__Notification;
}

boolean PDU__BSSMAP_template::ischosen(PDU__BSSMAP::union_selection_type checked_selection) const
{
if (checked_selection == PDU__BSSMAP::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @BSSAP_Types.PDU_BSSMAP.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == PDU__BSSMAP::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @BSSAP_Types.PDU_BSSMAP.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @BSSAP_Types.PDU_BSSMAP containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void PDU__BSSMAP_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case PDU__BSSMAP::ALT_assignmentRequest:
TTCN_Logger::log_event_str("{ assignmentRequest := ");
single_value.field_assignmentRequest->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_assignmentComplete:
TTCN_Logger::log_event_str("{ assignmentComplete := ");
single_value.field_assignmentComplete->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_assignmentFailure:
TTCN_Logger::log_event_str("{ assignmentFailure := ");
single_value.field_assignmentFailure->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_channelModifyRequest:
TTCN_Logger::log_event_str("{ channelModifyRequest := ");
single_value.field_channelModifyRequest->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_block:
TTCN_Logger::log_event_str("{ block := ");
single_value.field_block->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_blockingAck:
TTCN_Logger::log_event_str("{ blockingAck := ");
single_value.field_blockingAck->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_bSSInvokeTrace:
TTCN_Logger::log_event_str("{ bSSInvokeTrace := ");
single_value.field_bSSInvokeTrace->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_changeCircuit:
TTCN_Logger::log_event_str("{ changeCircuit := ");
single_value.field_changeCircuit->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_changeCircuitAck:
TTCN_Logger::log_event_str("{ changeCircuitAck := ");
single_value.field_changeCircuitAck->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_cipherModeCommand:
TTCN_Logger::log_event_str("{ cipherModeCommand := ");
single_value.field_cipherModeCommand->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_cipherModeComplete:
TTCN_Logger::log_event_str("{ cipherModeComplete := ");
single_value.field_cipherModeComplete->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_cipherModeReject:
TTCN_Logger::log_event_str("{ cipherModeReject := ");
single_value.field_cipherModeReject->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_circuitGroupBlock:
TTCN_Logger::log_event_str("{ circuitGroupBlock := ");
single_value.field_circuitGroupBlock->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_circuitGroupBlockingAck:
TTCN_Logger::log_event_str("{ circuitGroupBlockingAck := ");
single_value.field_circuitGroupBlockingAck->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_circuitGroupUnblock:
TTCN_Logger::log_event_str("{ circuitGroupUnblock := ");
single_value.field_circuitGroupUnblock->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_circuitGroupUnblockAck:
TTCN_Logger::log_event_str("{ circuitGroupUnblockAck := ");
single_value.field_circuitGroupUnblockAck->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_classmarkRequest:
TTCN_Logger::log_event_str("{ classmarkRequest := ");
single_value.field_classmarkRequest->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_classmarkUpdate:
TTCN_Logger::log_event_str("{ classmarkUpdate := ");
single_value.field_classmarkUpdate->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_clearCommand:
TTCN_Logger::log_event_str("{ clearCommand := ");
single_value.field_clearCommand->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_clearComplete:
TTCN_Logger::log_event_str("{ clearComplete := ");
single_value.field_clearComplete->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_clearRequest:
TTCN_Logger::log_event_str("{ clearRequest := ");
single_value.field_clearRequest->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_commonID:
TTCN_Logger::log_event_str("{ commonID := ");
single_value.field_commonID->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_completeLayer3Information:
TTCN_Logger::log_event_str("{ completeLayer3Information := ");
single_value.field_completeLayer3Information->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_confusion:
TTCN_Logger::log_event_str("{ confusion := ");
single_value.field_confusion->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_connectionlessInformation:
TTCN_Logger::log_event_str("{ connectionlessInformation := ");
single_value.field_connectionlessInformation->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_handoverCandidateEnquire:
TTCN_Logger::log_event_str("{ handoverCandidateEnquire := ");
single_value.field_handoverCandidateEnquire->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_handoverCandidateResponse:
TTCN_Logger::log_event_str("{ handoverCandidateResponse := ");
single_value.field_handoverCandidateResponse->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_handoverCommand:
TTCN_Logger::log_event_str("{ handoverCommand := ");
single_value.field_handoverCommand->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_handoverComplete:
TTCN_Logger::log_event_str("{ handoverComplete := ");
single_value.field_handoverComplete->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_handoverDetect:
TTCN_Logger::log_event_str("{ handoverDetect := ");
single_value.field_handoverDetect->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_handoverFailure:
TTCN_Logger::log_event_str("{ handoverFailure := ");
single_value.field_handoverFailure->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_handoverPerformed:
TTCN_Logger::log_event_str("{ handoverPerformed := ");
single_value.field_handoverPerformed->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_handoverRequest:
TTCN_Logger::log_event_str("{ handoverRequest := ");
single_value.field_handoverRequest->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_handoverRequestAck:
TTCN_Logger::log_event_str("{ handoverRequestAck := ");
single_value.field_handoverRequestAck->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_handoverRequired:
TTCN_Logger::log_event_str("{ handoverRequired := ");
single_value.field_handoverRequired->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_handoverRequiredReject:
TTCN_Logger::log_event_str("{ handoverRequiredReject := ");
single_value.field_handoverRequiredReject->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_handoverSucceeded:
TTCN_Logger::log_event_str("{ handoverSucceeded := ");
single_value.field_handoverSucceeded->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_loadIndication:
TTCN_Logger::log_event_str("{ loadIndication := ");
single_value.field_loadIndication->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_lSAInformation:
TTCN_Logger::log_event_str("{ lSAInformation := ");
single_value.field_lSAInformation->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_mSCInvokeTrace:
TTCN_Logger::log_event_str("{ mSCInvokeTrace := ");
single_value.field_mSCInvokeTrace->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_overload:
TTCN_Logger::log_event_str("{ overload := ");
single_value.field_overload->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_paging:
TTCN_Logger::log_event_str("{ paging := ");
single_value.field_paging->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_performLocationAbort:
TTCN_Logger::log_event_str("{ performLocationAbort := ");
single_value.field_performLocationAbort->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_performLocationRequest:
TTCN_Logger::log_event_str("{ performLocationRequest := ");
single_value.field_performLocationRequest->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_performLocationResponse:
TTCN_Logger::log_event_str("{ performLocationResponse := ");
single_value.field_performLocationResponse->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_queueingIndication:
TTCN_Logger::log_event_str("{ queueingIndication := ");
single_value.field_queueingIndication->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_reset:
TTCN_Logger::log_event_str("{ reset := ");
single_value.field_reset->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_resetAck:
TTCN_Logger::log_event_str("{ resetAck := ");
single_value.field_resetAck->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_resetCircuit:
TTCN_Logger::log_event_str("{ resetCircuit := ");
single_value.field_resetCircuit->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_resetCircuitAck:
TTCN_Logger::log_event_str("{ resetCircuitAck := ");
single_value.field_resetCircuitAck->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_resourceIndication:
TTCN_Logger::log_event_str("{ resourceIndication := ");
single_value.field_resourceIndication->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_resourceRequest:
TTCN_Logger::log_event_str("{ resourceRequest := ");
single_value.field_resourceRequest->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_sAPInReject:
TTCN_Logger::log_event_str("{ sAPInReject := ");
single_value.field_sAPInReject->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_suspend:
TTCN_Logger::log_event_str("{ suspend := ");
single_value.field_suspend->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_resume:
TTCN_Logger::log_event_str("{ resume := ");
single_value.field_resume->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_unblock:
TTCN_Logger::log_event_str("{ unblock := ");
single_value.field_unblock->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_unblockAck:
TTCN_Logger::log_event_str("{ unblockAck := ");
single_value.field_unblockAck->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_unequippedCircuit:
TTCN_Logger::log_event_str("{ unequippedCircuit := ");
single_value.field_unequippedCircuit->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_uplinkRequest:
TTCN_Logger::log_event_str("{ uplinkRequest := ");
single_value.field_uplinkRequest->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_uplinkRequestAck:
TTCN_Logger::log_event_str("{ uplinkRequestAck := ");
single_value.field_uplinkRequestAck->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_uplinkRequestConfirmation:
TTCN_Logger::log_event_str("{ uplinkRequestConfirmation := ");
single_value.field_uplinkRequestConfirmation->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_uplinkReleaseIndication:
TTCN_Logger::log_event_str("{ uplinkReleaseIndication := ");
single_value.field_uplinkReleaseIndication->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_uplinkRejectCommand:
TTCN_Logger::log_event_str("{ uplinkRejectCommand := ");
single_value.field_uplinkRejectCommand->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_uplinkReleaseCommand:
TTCN_Logger::log_event_str("{ uplinkReleaseCommand := ");
single_value.field_uplinkReleaseCommand->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_uplinkSeizedCommand:
TTCN_Logger::log_event_str("{ uplinkSeizedCommand := ");
single_value.field_uplinkSeizedCommand->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetup:
TTCN_Logger::log_event_str("{ vGCS_VBSSetup := ");
single_value.field_vGCS__VBSSetup->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetupAck:
TTCN_Logger::log_event_str("{ vGCS_VBSSetupAck := ");
single_value.field_vGCS__VBSSetupAck->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetupRefuse:
TTCN_Logger::log_event_str("{ vGCS_VBSSetupRefuse := ");
single_value.field_vGCS__VBSSetupRefuse->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentRequest:
TTCN_Logger::log_event_str("{ vGCS_VBSAssignmentRequest := ");
single_value.field_vGCS__VBSAssignmentRequest->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentResult:
TTCN_Logger::log_event_str("{ vGCS_VBSAssignmentResult := ");
single_value.field_vGCS__VBSAssignmentResult->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentFailure:
TTCN_Logger::log_event_str("{ vGCS_VBSAssignmentFailure := ");
single_value.field_vGCS__VBSAssignmentFailure->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_vGCS__VBSQueuingIndication:
TTCN_Logger::log_event_str("{ vGCS_VBSQueuingIndication := ");
single_value.field_vGCS__VBSQueuingIndication->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_vGCS__AdditionalInformation:
TTCN_Logger::log_event_str("{ vGCS_AdditionalInformation := ");
single_value.field_vGCS__AdditionalInformation->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_vGCS__VBS__AreaCellInfo:
TTCN_Logger::log_event_str("{ vGCS_VBS_AreaCellInfo := ");
single_value.field_vGCS__VBS__AreaCellInfo->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_vGCS__VBS__AssignmentStatus:
TTCN_Logger::log_event_str("{ vGCS_VBS_AssignmentStatus := ");
single_value.field_vGCS__VBS__AssignmentStatus->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_vGCS__SMS:
TTCN_Logger::log_event_str("{ vGCS_SMS := ");
single_value.field_vGCS__SMS->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_uplinkApplicationData:
TTCN_Logger::log_event_str("{ uplinkApplicationData := ");
single_value.field_uplinkApplicationData->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_notificationData:
TTCN_Logger::log_event_str("{ notificationData := ");
single_value.field_notificationData->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_internalHandoverRequired:
TTCN_Logger::log_event_str("{ internalHandoverRequired := ");
single_value.field_internalHandoverRequired->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_internalHandoverRequiredReject:
TTCN_Logger::log_event_str("{ internalHandoverRequiredReject := ");
single_value.field_internalHandoverRequiredReject->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_internalHandoverCommand:
TTCN_Logger::log_event_str("{ internalHandoverCommand := ");
single_value.field_internalHandoverCommand->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_internalHandoverEnquiry:
TTCN_Logger::log_event_str("{ internalHandoverEnquiry := ");
single_value.field_internalHandoverEnquiry->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_resetIPResource:
TTCN_Logger::log_event_str("{ resetIPResource := ");
single_value.field_resetIPResource->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_resetIPResourceAck:
TTCN_Logger::log_event_str("{ resetIPResourceAck := ");
single_value.field_resetIPResourceAck->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_rerouteCommand:
TTCN_Logger::log_event_str("{ rerouteCommand := ");
single_value.field_rerouteCommand->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_rerouteComplete:
TTCN_Logger::log_event_str("{ rerouteComplete := ");
single_value.field_rerouteComplete->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_lCLS__ConnectControl:
TTCN_Logger::log_event_str("{ lCLS_ConnectControl := ");
single_value.field_lCLS__ConnectControl->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_lCLS__connectControlAck:
TTCN_Logger::log_event_str("{ lCLS_connectControlAck := ");
single_value.field_lCLS__connectControlAck->log();
TTCN_Logger::log_event_str(" }");
break;
case PDU__BSSMAP::ALT_lCLS__Notification:
TTCN_Logger::log_event_str("{ lCLS_Notification := ");
single_value.field_lCLS__Notification->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSMAP_template::log_match(const PDU__BSSMAP& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case PDU__BSSMAP::ALT_assignmentRequest:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".assignmentRequest");
single_value.field_assignmentRequest->log_match(match_value.assignmentRequest(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ assignmentRequest := ");
single_value.field_assignmentRequest->log_match(match_value.assignmentRequest(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_assignmentComplete:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".assignmentComplete");
single_value.field_assignmentComplete->log_match(match_value.assignmentComplete(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ assignmentComplete := ");
single_value.field_assignmentComplete->log_match(match_value.assignmentComplete(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_assignmentFailure:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".assignmentFailure");
single_value.field_assignmentFailure->log_match(match_value.assignmentFailure(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ assignmentFailure := ");
single_value.field_assignmentFailure->log_match(match_value.assignmentFailure(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_channelModifyRequest:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".channelModifyRequest");
single_value.field_channelModifyRequest->log_match(match_value.channelModifyRequest(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ channelModifyRequest := ");
single_value.field_channelModifyRequest->log_match(match_value.channelModifyRequest(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_block:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".block");
single_value.field_block->log_match(match_value.block(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ block := ");
single_value.field_block->log_match(match_value.block(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_blockingAck:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".blockingAck");
single_value.field_blockingAck->log_match(match_value.blockingAck(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ blockingAck := ");
single_value.field_blockingAck->log_match(match_value.blockingAck(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_bSSInvokeTrace:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".bSSInvokeTrace");
single_value.field_bSSInvokeTrace->log_match(match_value.bSSInvokeTrace(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ bSSInvokeTrace := ");
single_value.field_bSSInvokeTrace->log_match(match_value.bSSInvokeTrace(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_changeCircuit:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".changeCircuit");
single_value.field_changeCircuit->log_match(match_value.changeCircuit(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ changeCircuit := ");
single_value.field_changeCircuit->log_match(match_value.changeCircuit(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_changeCircuitAck:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".changeCircuitAck");
single_value.field_changeCircuitAck->log_match(match_value.changeCircuitAck(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ changeCircuitAck := ");
single_value.field_changeCircuitAck->log_match(match_value.changeCircuitAck(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_cipherModeCommand:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cipherModeCommand");
single_value.field_cipherModeCommand->log_match(match_value.cipherModeCommand(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cipherModeCommand := ");
single_value.field_cipherModeCommand->log_match(match_value.cipherModeCommand(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_cipherModeComplete:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cipherModeComplete");
single_value.field_cipherModeComplete->log_match(match_value.cipherModeComplete(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cipherModeComplete := ");
single_value.field_cipherModeComplete->log_match(match_value.cipherModeComplete(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_cipherModeReject:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".cipherModeReject");
single_value.field_cipherModeReject->log_match(match_value.cipherModeReject(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ cipherModeReject := ");
single_value.field_cipherModeReject->log_match(match_value.cipherModeReject(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_circuitGroupBlock:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".circuitGroupBlock");
single_value.field_circuitGroupBlock->log_match(match_value.circuitGroupBlock(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ circuitGroupBlock := ");
single_value.field_circuitGroupBlock->log_match(match_value.circuitGroupBlock(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_circuitGroupBlockingAck:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".circuitGroupBlockingAck");
single_value.field_circuitGroupBlockingAck->log_match(match_value.circuitGroupBlockingAck(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ circuitGroupBlockingAck := ");
single_value.field_circuitGroupBlockingAck->log_match(match_value.circuitGroupBlockingAck(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_circuitGroupUnblock:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".circuitGroupUnblock");
single_value.field_circuitGroupUnblock->log_match(match_value.circuitGroupUnblock(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ circuitGroupUnblock := ");
single_value.field_circuitGroupUnblock->log_match(match_value.circuitGroupUnblock(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_circuitGroupUnblockAck:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".circuitGroupUnblockAck");
single_value.field_circuitGroupUnblockAck->log_match(match_value.circuitGroupUnblockAck(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ circuitGroupUnblockAck := ");
single_value.field_circuitGroupUnblockAck->log_match(match_value.circuitGroupUnblockAck(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_classmarkRequest:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".classmarkRequest");
single_value.field_classmarkRequest->log_match(match_value.classmarkRequest(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ classmarkRequest := ");
single_value.field_classmarkRequest->log_match(match_value.classmarkRequest(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_classmarkUpdate:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".classmarkUpdate");
single_value.field_classmarkUpdate->log_match(match_value.classmarkUpdate(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ classmarkUpdate := ");
single_value.field_classmarkUpdate->log_match(match_value.classmarkUpdate(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_clearCommand:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".clearCommand");
single_value.field_clearCommand->log_match(match_value.clearCommand(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ clearCommand := ");
single_value.field_clearCommand->log_match(match_value.clearCommand(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_clearComplete:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".clearComplete");
single_value.field_clearComplete->log_match(match_value.clearComplete(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ clearComplete := ");
single_value.field_clearComplete->log_match(match_value.clearComplete(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_clearRequest:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".clearRequest");
single_value.field_clearRequest->log_match(match_value.clearRequest(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ clearRequest := ");
single_value.field_clearRequest->log_match(match_value.clearRequest(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_commonID:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".commonID");
single_value.field_commonID->log_match(match_value.commonID(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ commonID := ");
single_value.field_commonID->log_match(match_value.commonID(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_completeLayer3Information:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".completeLayer3Information");
single_value.field_completeLayer3Information->log_match(match_value.completeLayer3Information(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ completeLayer3Information := ");
single_value.field_completeLayer3Information->log_match(match_value.completeLayer3Information(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_confusion:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".confusion");
single_value.field_confusion->log_match(match_value.confusion(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ confusion := ");
single_value.field_confusion->log_match(match_value.confusion(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_connectionlessInformation:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".connectionlessInformation");
single_value.field_connectionlessInformation->log_match(match_value.connectionlessInformation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ connectionlessInformation := ");
single_value.field_connectionlessInformation->log_match(match_value.connectionlessInformation(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_handoverCandidateEnquire:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".handoverCandidateEnquire");
single_value.field_handoverCandidateEnquire->log_match(match_value.handoverCandidateEnquire(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ handoverCandidateEnquire := ");
single_value.field_handoverCandidateEnquire->log_match(match_value.handoverCandidateEnquire(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_handoverCandidateResponse:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".handoverCandidateResponse");
single_value.field_handoverCandidateResponse->log_match(match_value.handoverCandidateResponse(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ handoverCandidateResponse := ");
single_value.field_handoverCandidateResponse->log_match(match_value.handoverCandidateResponse(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_handoverCommand:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".handoverCommand");
single_value.field_handoverCommand->log_match(match_value.handoverCommand(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ handoverCommand := ");
single_value.field_handoverCommand->log_match(match_value.handoverCommand(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_handoverComplete:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".handoverComplete");
single_value.field_handoverComplete->log_match(match_value.handoverComplete(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ handoverComplete := ");
single_value.field_handoverComplete->log_match(match_value.handoverComplete(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_handoverDetect:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".handoverDetect");
single_value.field_handoverDetect->log_match(match_value.handoverDetect(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ handoverDetect := ");
single_value.field_handoverDetect->log_match(match_value.handoverDetect(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_handoverFailure:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".handoverFailure");
single_value.field_handoverFailure->log_match(match_value.handoverFailure(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ handoverFailure := ");
single_value.field_handoverFailure->log_match(match_value.handoverFailure(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_handoverPerformed:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".handoverPerformed");
single_value.field_handoverPerformed->log_match(match_value.handoverPerformed(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ handoverPerformed := ");
single_value.field_handoverPerformed->log_match(match_value.handoverPerformed(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_handoverRequest:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".handoverRequest");
single_value.field_handoverRequest->log_match(match_value.handoverRequest(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ handoverRequest := ");
single_value.field_handoverRequest->log_match(match_value.handoverRequest(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_handoverRequestAck:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".handoverRequestAck");
single_value.field_handoverRequestAck->log_match(match_value.handoverRequestAck(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ handoverRequestAck := ");
single_value.field_handoverRequestAck->log_match(match_value.handoverRequestAck(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_handoverRequired:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".handoverRequired");
single_value.field_handoverRequired->log_match(match_value.handoverRequired(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ handoverRequired := ");
single_value.field_handoverRequired->log_match(match_value.handoverRequired(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_handoverRequiredReject:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".handoverRequiredReject");
single_value.field_handoverRequiredReject->log_match(match_value.handoverRequiredReject(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ handoverRequiredReject := ");
single_value.field_handoverRequiredReject->log_match(match_value.handoverRequiredReject(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_handoverSucceeded:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".handoverSucceeded");
single_value.field_handoverSucceeded->log_match(match_value.handoverSucceeded(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ handoverSucceeded := ");
single_value.field_handoverSucceeded->log_match(match_value.handoverSucceeded(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_loadIndication:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".loadIndication");
single_value.field_loadIndication->log_match(match_value.loadIndication(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ loadIndication := ");
single_value.field_loadIndication->log_match(match_value.loadIndication(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_lSAInformation:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".lSAInformation");
single_value.field_lSAInformation->log_match(match_value.lSAInformation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ lSAInformation := ");
single_value.field_lSAInformation->log_match(match_value.lSAInformation(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_mSCInvokeTrace:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".mSCInvokeTrace");
single_value.field_mSCInvokeTrace->log_match(match_value.mSCInvokeTrace(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ mSCInvokeTrace := ");
single_value.field_mSCInvokeTrace->log_match(match_value.mSCInvokeTrace(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_overload:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".overload");
single_value.field_overload->log_match(match_value.overload(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ overload := ");
single_value.field_overload->log_match(match_value.overload(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_paging:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".paging");
single_value.field_paging->log_match(match_value.paging(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ paging := ");
single_value.field_paging->log_match(match_value.paging(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_performLocationAbort:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".performLocationAbort");
single_value.field_performLocationAbort->log_match(match_value.performLocationAbort(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ performLocationAbort := ");
single_value.field_performLocationAbort->log_match(match_value.performLocationAbort(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_performLocationRequest:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".performLocationRequest");
single_value.field_performLocationRequest->log_match(match_value.performLocationRequest(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ performLocationRequest := ");
single_value.field_performLocationRequest->log_match(match_value.performLocationRequest(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_performLocationResponse:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".performLocationResponse");
single_value.field_performLocationResponse->log_match(match_value.performLocationResponse(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ performLocationResponse := ");
single_value.field_performLocationResponse->log_match(match_value.performLocationResponse(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_queueingIndication:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".queueingIndication");
single_value.field_queueingIndication->log_match(match_value.queueingIndication(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ queueingIndication := ");
single_value.field_queueingIndication->log_match(match_value.queueingIndication(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_reset:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".reset");
single_value.field_reset->log_match(match_value.reset(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ reset := ");
single_value.field_reset->log_match(match_value.reset(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_resetAck:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".resetAck");
single_value.field_resetAck->log_match(match_value.resetAck(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ resetAck := ");
single_value.field_resetAck->log_match(match_value.resetAck(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_resetCircuit:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".resetCircuit");
single_value.field_resetCircuit->log_match(match_value.resetCircuit(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ resetCircuit := ");
single_value.field_resetCircuit->log_match(match_value.resetCircuit(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_resetCircuitAck:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".resetCircuitAck");
single_value.field_resetCircuitAck->log_match(match_value.resetCircuitAck(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ resetCircuitAck := ");
single_value.field_resetCircuitAck->log_match(match_value.resetCircuitAck(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_resourceIndication:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".resourceIndication");
single_value.field_resourceIndication->log_match(match_value.resourceIndication(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ resourceIndication := ");
single_value.field_resourceIndication->log_match(match_value.resourceIndication(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_resourceRequest:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".resourceRequest");
single_value.field_resourceRequest->log_match(match_value.resourceRequest(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ resourceRequest := ");
single_value.field_resourceRequest->log_match(match_value.resourceRequest(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_sAPInReject:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".sAPInReject");
single_value.field_sAPInReject->log_match(match_value.sAPInReject(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ sAPInReject := ");
single_value.field_sAPInReject->log_match(match_value.sAPInReject(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_suspend:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".suspend");
single_value.field_suspend->log_match(match_value.suspend(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ suspend := ");
single_value.field_suspend->log_match(match_value.suspend(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_resume:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".resume");
single_value.field_resume->log_match(match_value.resume(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ resume := ");
single_value.field_resume->log_match(match_value.resume(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_unblock:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".unblock");
single_value.field_unblock->log_match(match_value.unblock(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ unblock := ");
single_value.field_unblock->log_match(match_value.unblock(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_unblockAck:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".unblockAck");
single_value.field_unblockAck->log_match(match_value.unblockAck(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ unblockAck := ");
single_value.field_unblockAck->log_match(match_value.unblockAck(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_unequippedCircuit:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".unequippedCircuit");
single_value.field_unequippedCircuit->log_match(match_value.unequippedCircuit(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ unequippedCircuit := ");
single_value.field_unequippedCircuit->log_match(match_value.unequippedCircuit(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_uplinkRequest:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".uplinkRequest");
single_value.field_uplinkRequest->log_match(match_value.uplinkRequest(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ uplinkRequest := ");
single_value.field_uplinkRequest->log_match(match_value.uplinkRequest(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_uplinkRequestAck:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".uplinkRequestAck");
single_value.field_uplinkRequestAck->log_match(match_value.uplinkRequestAck(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ uplinkRequestAck := ");
single_value.field_uplinkRequestAck->log_match(match_value.uplinkRequestAck(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_uplinkRequestConfirmation:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".uplinkRequestConfirmation");
single_value.field_uplinkRequestConfirmation->log_match(match_value.uplinkRequestConfirmation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ uplinkRequestConfirmation := ");
single_value.field_uplinkRequestConfirmation->log_match(match_value.uplinkRequestConfirmation(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_uplinkReleaseIndication:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".uplinkReleaseIndication");
single_value.field_uplinkReleaseIndication->log_match(match_value.uplinkReleaseIndication(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ uplinkReleaseIndication := ");
single_value.field_uplinkReleaseIndication->log_match(match_value.uplinkReleaseIndication(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_uplinkRejectCommand:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".uplinkRejectCommand");
single_value.field_uplinkRejectCommand->log_match(match_value.uplinkRejectCommand(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ uplinkRejectCommand := ");
single_value.field_uplinkRejectCommand->log_match(match_value.uplinkRejectCommand(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_uplinkReleaseCommand:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".uplinkReleaseCommand");
single_value.field_uplinkReleaseCommand->log_match(match_value.uplinkReleaseCommand(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ uplinkReleaseCommand := ");
single_value.field_uplinkReleaseCommand->log_match(match_value.uplinkReleaseCommand(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_uplinkSeizedCommand:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".uplinkSeizedCommand");
single_value.field_uplinkSeizedCommand->log_match(match_value.uplinkSeizedCommand(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ uplinkSeizedCommand := ");
single_value.field_uplinkSeizedCommand->log_match(match_value.uplinkSeizedCommand(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetup:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".vGCS_VBSSetup");
single_value.field_vGCS__VBSSetup->log_match(match_value.vGCS__VBSSetup(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ vGCS_VBSSetup := ");
single_value.field_vGCS__VBSSetup->log_match(match_value.vGCS__VBSSetup(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetupAck:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".vGCS_VBSSetupAck");
single_value.field_vGCS__VBSSetupAck->log_match(match_value.vGCS__VBSSetupAck(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ vGCS_VBSSetupAck := ");
single_value.field_vGCS__VBSSetupAck->log_match(match_value.vGCS__VBSSetupAck(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetupRefuse:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".vGCS_VBSSetupRefuse");
single_value.field_vGCS__VBSSetupRefuse->log_match(match_value.vGCS__VBSSetupRefuse(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ vGCS_VBSSetupRefuse := ");
single_value.field_vGCS__VBSSetupRefuse->log_match(match_value.vGCS__VBSSetupRefuse(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentRequest:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".vGCS_VBSAssignmentRequest");
single_value.field_vGCS__VBSAssignmentRequest->log_match(match_value.vGCS__VBSAssignmentRequest(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ vGCS_VBSAssignmentRequest := ");
single_value.field_vGCS__VBSAssignmentRequest->log_match(match_value.vGCS__VBSAssignmentRequest(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentResult:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".vGCS_VBSAssignmentResult");
single_value.field_vGCS__VBSAssignmentResult->log_match(match_value.vGCS__VBSAssignmentResult(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ vGCS_VBSAssignmentResult := ");
single_value.field_vGCS__VBSAssignmentResult->log_match(match_value.vGCS__VBSAssignmentResult(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentFailure:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".vGCS_VBSAssignmentFailure");
single_value.field_vGCS__VBSAssignmentFailure->log_match(match_value.vGCS__VBSAssignmentFailure(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ vGCS_VBSAssignmentFailure := ");
single_value.field_vGCS__VBSAssignmentFailure->log_match(match_value.vGCS__VBSAssignmentFailure(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_vGCS__VBSQueuingIndication:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".vGCS_VBSQueuingIndication");
single_value.field_vGCS__VBSQueuingIndication->log_match(match_value.vGCS__VBSQueuingIndication(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ vGCS_VBSQueuingIndication := ");
single_value.field_vGCS__VBSQueuingIndication->log_match(match_value.vGCS__VBSQueuingIndication(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_vGCS__AdditionalInformation:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".vGCS_AdditionalInformation");
single_value.field_vGCS__AdditionalInformation->log_match(match_value.vGCS__AdditionalInformation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ vGCS_AdditionalInformation := ");
single_value.field_vGCS__AdditionalInformation->log_match(match_value.vGCS__AdditionalInformation(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_vGCS__VBS__AreaCellInfo:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".vGCS_VBS_AreaCellInfo");
single_value.field_vGCS__VBS__AreaCellInfo->log_match(match_value.vGCS__VBS__AreaCellInfo(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ vGCS_VBS_AreaCellInfo := ");
single_value.field_vGCS__VBS__AreaCellInfo->log_match(match_value.vGCS__VBS__AreaCellInfo(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_vGCS__VBS__AssignmentStatus:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".vGCS_VBS_AssignmentStatus");
single_value.field_vGCS__VBS__AssignmentStatus->log_match(match_value.vGCS__VBS__AssignmentStatus(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ vGCS_VBS_AssignmentStatus := ");
single_value.field_vGCS__VBS__AssignmentStatus->log_match(match_value.vGCS__VBS__AssignmentStatus(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_vGCS__SMS:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".vGCS_SMS");
single_value.field_vGCS__SMS->log_match(match_value.vGCS__SMS(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ vGCS_SMS := ");
single_value.field_vGCS__SMS->log_match(match_value.vGCS__SMS(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_uplinkApplicationData:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".uplinkApplicationData");
single_value.field_uplinkApplicationData->log_match(match_value.uplinkApplicationData(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ uplinkApplicationData := ");
single_value.field_uplinkApplicationData->log_match(match_value.uplinkApplicationData(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_notificationData:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".notificationData");
single_value.field_notificationData->log_match(match_value.notificationData(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ notificationData := ");
single_value.field_notificationData->log_match(match_value.notificationData(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_internalHandoverRequired:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".internalHandoverRequired");
single_value.field_internalHandoverRequired->log_match(match_value.internalHandoverRequired(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ internalHandoverRequired := ");
single_value.field_internalHandoverRequired->log_match(match_value.internalHandoverRequired(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_internalHandoverRequiredReject:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".internalHandoverRequiredReject");
single_value.field_internalHandoverRequiredReject->log_match(match_value.internalHandoverRequiredReject(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ internalHandoverRequiredReject := ");
single_value.field_internalHandoverRequiredReject->log_match(match_value.internalHandoverRequiredReject(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_internalHandoverCommand:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".internalHandoverCommand");
single_value.field_internalHandoverCommand->log_match(match_value.internalHandoverCommand(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ internalHandoverCommand := ");
single_value.field_internalHandoverCommand->log_match(match_value.internalHandoverCommand(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_internalHandoverEnquiry:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".internalHandoverEnquiry");
single_value.field_internalHandoverEnquiry->log_match(match_value.internalHandoverEnquiry(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ internalHandoverEnquiry := ");
single_value.field_internalHandoverEnquiry->log_match(match_value.internalHandoverEnquiry(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_resetIPResource:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".resetIPResource");
single_value.field_resetIPResource->log_match(match_value.resetIPResource(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ resetIPResource := ");
single_value.field_resetIPResource->log_match(match_value.resetIPResource(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_resetIPResourceAck:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".resetIPResourceAck");
single_value.field_resetIPResourceAck->log_match(match_value.resetIPResourceAck(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ resetIPResourceAck := ");
single_value.field_resetIPResourceAck->log_match(match_value.resetIPResourceAck(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_rerouteCommand:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".rerouteCommand");
single_value.field_rerouteCommand->log_match(match_value.rerouteCommand(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ rerouteCommand := ");
single_value.field_rerouteCommand->log_match(match_value.rerouteCommand(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_rerouteComplete:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".rerouteComplete");
single_value.field_rerouteComplete->log_match(match_value.rerouteComplete(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ rerouteComplete := ");
single_value.field_rerouteComplete->log_match(match_value.rerouteComplete(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_lCLS__ConnectControl:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".lCLS_ConnectControl");
single_value.field_lCLS__ConnectControl->log_match(match_value.lCLS__ConnectControl(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ lCLS_ConnectControl := ");
single_value.field_lCLS__ConnectControl->log_match(match_value.lCLS__ConnectControl(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_lCLS__connectControlAck:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".lCLS_connectControlAck");
single_value.field_lCLS__connectControlAck->log_match(match_value.lCLS__connectControlAck(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ lCLS_connectControlAck := ");
single_value.field_lCLS__connectControlAck->log_match(match_value.lCLS__connectControlAck(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case PDU__BSSMAP::ALT_lCLS__Notification:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".lCLS_Notification");
single_value.field_lCLS__Notification->log_match(match_value.lCLS__Notification(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ lCLS_Notification := ");
single_value.field_lCLS__Notification->log_match(match_value.lCLS__Notification(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSMAP_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case PDU__BSSMAP::ALT_assignmentRequest:
single_value.field_assignmentRequest->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_assignmentComplete:
single_value.field_assignmentComplete->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_assignmentFailure:
single_value.field_assignmentFailure->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_channelModifyRequest:
single_value.field_channelModifyRequest->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_block:
single_value.field_block->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_blockingAck:
single_value.field_blockingAck->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_bSSInvokeTrace:
single_value.field_bSSInvokeTrace->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_changeCircuit:
single_value.field_changeCircuit->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_changeCircuitAck:
single_value.field_changeCircuitAck->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_cipherModeCommand:
single_value.field_cipherModeCommand->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_cipherModeComplete:
single_value.field_cipherModeComplete->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_cipherModeReject:
single_value.field_cipherModeReject->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_circuitGroupBlock:
single_value.field_circuitGroupBlock->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_circuitGroupBlockingAck:
single_value.field_circuitGroupBlockingAck->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_circuitGroupUnblock:
single_value.field_circuitGroupUnblock->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_circuitGroupUnblockAck:
single_value.field_circuitGroupUnblockAck->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_classmarkRequest:
single_value.field_classmarkRequest->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_classmarkUpdate:
single_value.field_classmarkUpdate->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_clearCommand:
single_value.field_clearCommand->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_clearComplete:
single_value.field_clearComplete->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_clearRequest:
single_value.field_clearRequest->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_commonID:
single_value.field_commonID->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_completeLayer3Information:
single_value.field_completeLayer3Information->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_confusion:
single_value.field_confusion->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_connectionlessInformation:
single_value.field_connectionlessInformation->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_handoverCandidateEnquire:
single_value.field_handoverCandidateEnquire->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_handoverCandidateResponse:
single_value.field_handoverCandidateResponse->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_handoverCommand:
single_value.field_handoverCommand->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_handoverComplete:
single_value.field_handoverComplete->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_handoverDetect:
single_value.field_handoverDetect->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_handoverFailure:
single_value.field_handoverFailure->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_handoverPerformed:
single_value.field_handoverPerformed->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_handoverRequest:
single_value.field_handoverRequest->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_handoverRequestAck:
single_value.field_handoverRequestAck->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_handoverRequired:
single_value.field_handoverRequired->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_handoverRequiredReject:
single_value.field_handoverRequiredReject->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_handoverSucceeded:
single_value.field_handoverSucceeded->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_loadIndication:
single_value.field_loadIndication->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_lSAInformation:
single_value.field_lSAInformation->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_mSCInvokeTrace:
single_value.field_mSCInvokeTrace->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_overload:
single_value.field_overload->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_paging:
single_value.field_paging->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_performLocationAbort:
single_value.field_performLocationAbort->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_performLocationRequest:
single_value.field_performLocationRequest->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_performLocationResponse:
single_value.field_performLocationResponse->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_queueingIndication:
single_value.field_queueingIndication->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_reset:
single_value.field_reset->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_resetAck:
single_value.field_resetAck->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_resetCircuit:
single_value.field_resetCircuit->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_resetCircuitAck:
single_value.field_resetCircuitAck->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_resourceIndication:
single_value.field_resourceIndication->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_resourceRequest:
single_value.field_resourceRequest->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_sAPInReject:
single_value.field_sAPInReject->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_suspend:
single_value.field_suspend->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_resume:
single_value.field_resume->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_unblock:
single_value.field_unblock->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_unblockAck:
single_value.field_unblockAck->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_unequippedCircuit:
single_value.field_unequippedCircuit->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_uplinkRequest:
single_value.field_uplinkRequest->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_uplinkRequestAck:
single_value.field_uplinkRequestAck->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_uplinkRequestConfirmation:
single_value.field_uplinkRequestConfirmation->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_uplinkReleaseIndication:
single_value.field_uplinkReleaseIndication->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_uplinkRejectCommand:
single_value.field_uplinkRejectCommand->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_uplinkReleaseCommand:
single_value.field_uplinkReleaseCommand->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_uplinkSeizedCommand:
single_value.field_uplinkSeizedCommand->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_vGCS__VBSSetup:
single_value.field_vGCS__VBSSetup->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_vGCS__VBSSetupAck:
single_value.field_vGCS__VBSSetupAck->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_vGCS__VBSSetupRefuse:
single_value.field_vGCS__VBSSetupRefuse->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentRequest:
single_value.field_vGCS__VBSAssignmentRequest->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentResult:
single_value.field_vGCS__VBSAssignmentResult->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentFailure:
single_value.field_vGCS__VBSAssignmentFailure->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_vGCS__VBSQueuingIndication:
single_value.field_vGCS__VBSQueuingIndication->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_vGCS__AdditionalInformation:
single_value.field_vGCS__AdditionalInformation->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_vGCS__VBS__AreaCellInfo:
single_value.field_vGCS__VBS__AreaCellInfo->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_vGCS__VBS__AssignmentStatus:
single_value.field_vGCS__VBS__AssignmentStatus->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_vGCS__SMS:
single_value.field_vGCS__SMS->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_uplinkApplicationData:
single_value.field_uplinkApplicationData->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_notificationData:
single_value.field_notificationData->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_internalHandoverRequired:
single_value.field_internalHandoverRequired->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_internalHandoverRequiredReject:
single_value.field_internalHandoverRequiredReject->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_internalHandoverCommand:
single_value.field_internalHandoverCommand->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_internalHandoverEnquiry:
single_value.field_internalHandoverEnquiry->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_resetIPResource:
single_value.field_resetIPResource->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_resetIPResourceAck:
single_value.field_resetIPResourceAck->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_rerouteCommand:
single_value.field_rerouteCommand->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_rerouteComplete:
single_value.field_rerouteComplete->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_lCLS__ConnectControl:
single_value.field_lCLS__ConnectControl->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_lCLS__connectControlAck:
single_value.field_lCLS__connectControlAck->set_implicit_omit(); break;
case PDU__BSSMAP::ALT_lCLS__Notification:
single_value.field_lCLS__Notification->set_implicit_omit(); break;
default: break;
}
}

void PDU__BSSMAP_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case PDU__BSSMAP::ALT_assignmentRequest:
single_value.field_assignmentRequest->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_assignmentComplete:
single_value.field_assignmentComplete->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_assignmentFailure:
single_value.field_assignmentFailure->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_channelModifyRequest:
single_value.field_channelModifyRequest->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_block:
single_value.field_block->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_blockingAck:
single_value.field_blockingAck->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_bSSInvokeTrace:
single_value.field_bSSInvokeTrace->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_changeCircuit:
single_value.field_changeCircuit->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_changeCircuitAck:
single_value.field_changeCircuitAck->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_cipherModeCommand:
single_value.field_cipherModeCommand->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_cipherModeComplete:
single_value.field_cipherModeComplete->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_cipherModeReject:
single_value.field_cipherModeReject->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_circuitGroupBlock:
single_value.field_circuitGroupBlock->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_circuitGroupBlockingAck:
single_value.field_circuitGroupBlockingAck->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_circuitGroupUnblock:
single_value.field_circuitGroupUnblock->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_circuitGroupUnblockAck:
single_value.field_circuitGroupUnblockAck->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_classmarkRequest:
single_value.field_classmarkRequest->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_classmarkUpdate:
single_value.field_classmarkUpdate->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_clearCommand:
single_value.field_clearCommand->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_clearComplete:
single_value.field_clearComplete->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_clearRequest:
single_value.field_clearRequest->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_commonID:
single_value.field_commonID->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_completeLayer3Information:
single_value.field_completeLayer3Information->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_confusion:
single_value.field_confusion->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_connectionlessInformation:
single_value.field_connectionlessInformation->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverCandidateEnquire:
single_value.field_handoverCandidateEnquire->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverCandidateResponse:
single_value.field_handoverCandidateResponse->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverCommand:
single_value.field_handoverCommand->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverComplete:
single_value.field_handoverComplete->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverDetect:
single_value.field_handoverDetect->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverFailure:
single_value.field_handoverFailure->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverPerformed:
single_value.field_handoverPerformed->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverRequest:
single_value.field_handoverRequest->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverRequestAck:
single_value.field_handoverRequestAck->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverRequired:
single_value.field_handoverRequired->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverRequiredReject:
single_value.field_handoverRequiredReject->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverSucceeded:
single_value.field_handoverSucceeded->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_loadIndication:
single_value.field_loadIndication->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_lSAInformation:
single_value.field_lSAInformation->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_mSCInvokeTrace:
single_value.field_mSCInvokeTrace->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_overload:
single_value.field_overload->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_paging:
single_value.field_paging->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_performLocationAbort:
single_value.field_performLocationAbort->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_performLocationRequest:
single_value.field_performLocationRequest->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_performLocationResponse:
single_value.field_performLocationResponse->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_queueingIndication:
single_value.field_queueingIndication->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_reset:
single_value.field_reset->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_resetAck:
single_value.field_resetAck->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_resetCircuit:
single_value.field_resetCircuit->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_resetCircuitAck:
single_value.field_resetCircuitAck->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_resourceIndication:
single_value.field_resourceIndication->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_resourceRequest:
single_value.field_resourceRequest->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_sAPInReject:
single_value.field_sAPInReject->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_suspend:
single_value.field_suspend->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_resume:
single_value.field_resume->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_unblock:
single_value.field_unblock->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_unblockAck:
single_value.field_unblockAck->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_unequippedCircuit:
single_value.field_unequippedCircuit->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_uplinkRequest:
single_value.field_uplinkRequest->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_uplinkRequestAck:
single_value.field_uplinkRequestAck->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_uplinkRequestConfirmation:
single_value.field_uplinkRequestConfirmation->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_uplinkReleaseIndication:
single_value.field_uplinkReleaseIndication->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_uplinkRejectCommand:
single_value.field_uplinkRejectCommand->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_uplinkReleaseCommand:
single_value.field_uplinkReleaseCommand->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_uplinkSeizedCommand:
single_value.field_uplinkSeizedCommand->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetup:
single_value.field_vGCS__VBSSetup->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetupAck:
single_value.field_vGCS__VBSSetupAck->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetupRefuse:
single_value.field_vGCS__VBSSetupRefuse->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentRequest:
single_value.field_vGCS__VBSAssignmentRequest->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentResult:
single_value.field_vGCS__VBSAssignmentResult->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentFailure:
single_value.field_vGCS__VBSAssignmentFailure->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_vGCS__VBSQueuingIndication:
single_value.field_vGCS__VBSQueuingIndication->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_vGCS__AdditionalInformation:
single_value.field_vGCS__AdditionalInformation->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_vGCS__VBS__AreaCellInfo:
single_value.field_vGCS__VBS__AreaCellInfo->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_vGCS__VBS__AssignmentStatus:
single_value.field_vGCS__VBS__AssignmentStatus->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_vGCS__SMS:
single_value.field_vGCS__SMS->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_uplinkApplicationData:
single_value.field_uplinkApplicationData->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_notificationData:
single_value.field_notificationData->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_internalHandoverRequired:
single_value.field_internalHandoverRequired->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_internalHandoverRequiredReject:
single_value.field_internalHandoverRequiredReject->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_internalHandoverCommand:
single_value.field_internalHandoverCommand->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_internalHandoverEnquiry:
single_value.field_internalHandoverEnquiry->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_resetIPResource:
single_value.field_resetIPResource->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_resetIPResourceAck:
single_value.field_resetIPResourceAck->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_rerouteCommand:
single_value.field_rerouteCommand->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_rerouteComplete:
single_value.field_rerouteComplete->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_lCLS__ConnectControl:
single_value.field_lCLS__ConnectControl->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_lCLS__connectControlAck:
single_value.field_lCLS__connectControlAck->encode_text(text_buf);
break;
case PDU__BSSMAP::ALT_lCLS__Notification:
single_value.field_lCLS__Notification->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @BSSAP_Types.PDU_BSSMAP.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @BSSAP_Types.PDU_BSSMAP.");
}
}

void PDU__BSSMAP_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = PDU__BSSMAP::UNBOUND_VALUE;
PDU__BSSMAP::union_selection_type new_selection = (PDU__BSSMAP::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case PDU__BSSMAP::ALT_assignmentRequest:
single_value.field_assignmentRequest = new PDU__BSSMAP__AssignmentRequest_template;
single_value.field_assignmentRequest->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_assignmentComplete:
single_value.field_assignmentComplete = new PDU__BSSMAP__AssignmentComplete_template;
single_value.field_assignmentComplete->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_assignmentFailure:
single_value.field_assignmentFailure = new PDU__BSSMAP__AssignmentFailure_template;
single_value.field_assignmentFailure->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_channelModifyRequest:
single_value.field_channelModifyRequest = new PDU__BSSMAP__ChannelModifyRequest_template;
single_value.field_channelModifyRequest->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_block:
single_value.field_block = new PDU__BSSMAP__Block_template;
single_value.field_block->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_blockingAck:
single_value.field_blockingAck = new PDU__BSSMAP__BlockingAck_template;
single_value.field_blockingAck->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_bSSInvokeTrace:
single_value.field_bSSInvokeTrace = new PDU__BSSMAP__BSSInvokeTrace_template;
single_value.field_bSSInvokeTrace->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_changeCircuit:
single_value.field_changeCircuit = new PDU__BSSMAP__ChangeCircuit_template;
single_value.field_changeCircuit->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_changeCircuitAck:
single_value.field_changeCircuitAck = new PDU__BSSMAP__ChangeCircuitAck_template;
single_value.field_changeCircuitAck->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_cipherModeCommand:
single_value.field_cipherModeCommand = new PDU__BSSMAP__CipherModeCommand_template;
single_value.field_cipherModeCommand->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_cipherModeComplete:
single_value.field_cipherModeComplete = new PDU__BSSMAP__CipherModeComplete_template;
single_value.field_cipherModeComplete->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_cipherModeReject:
single_value.field_cipherModeReject = new PDU__BSSMAP__CipherModeReject_template;
single_value.field_cipherModeReject->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_circuitGroupBlock:
single_value.field_circuitGroupBlock = new PDU__BSSMAP__CircuitGroupBlock_template;
single_value.field_circuitGroupBlock->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_circuitGroupBlockingAck:
single_value.field_circuitGroupBlockingAck = new PDU__BSSMAP__CircuitGroupBlockingAck_template;
single_value.field_circuitGroupBlockingAck->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_circuitGroupUnblock:
single_value.field_circuitGroupUnblock = new PDU__BSSMAP__CircuitGroupUnblock_template;
single_value.field_circuitGroupUnblock->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_circuitGroupUnblockAck:
single_value.field_circuitGroupUnblockAck = new PDU__BSSMAP__CircuitGroupUnblockAck_template;
single_value.field_circuitGroupUnblockAck->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_classmarkRequest:
single_value.field_classmarkRequest = new PDU__BSSMAP__ClassmarkRequest_template;
single_value.field_classmarkRequest->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_classmarkUpdate:
single_value.field_classmarkUpdate = new PDU__BSSMAP__ClassmarkUpdate_template;
single_value.field_classmarkUpdate->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_clearCommand:
single_value.field_clearCommand = new PDU__BSSMAP__ClearCommand_template;
single_value.field_clearCommand->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_clearComplete:
single_value.field_clearComplete = new PDU__BSSMAP__ClearComplete_template;
single_value.field_clearComplete->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_clearRequest:
single_value.field_clearRequest = new PDU__BSSMAP__ClearRequest_template;
single_value.field_clearRequest->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_commonID:
single_value.field_commonID = new PDU__BSSMAP__CommonID_template;
single_value.field_commonID->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_completeLayer3Information:
single_value.field_completeLayer3Information = new PDU__BSSMAP__CompleteLayer3Information_template;
single_value.field_completeLayer3Information->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_confusion:
single_value.field_confusion = new PDU__BSSMAP__Confusion_template;
single_value.field_confusion->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_connectionlessInformation:
single_value.field_connectionlessInformation = new PDU__BSSMAP__ConnectionlessInformation_template;
single_value.field_connectionlessInformation->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverCandidateEnquire:
single_value.field_handoverCandidateEnquire = new PDU__BSSMAP__HandoverCandidateEnquire_template;
single_value.field_handoverCandidateEnquire->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverCandidateResponse:
single_value.field_handoverCandidateResponse = new PDU__BSSMAP__HandoverCandidateResponse_template;
single_value.field_handoverCandidateResponse->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverCommand:
single_value.field_handoverCommand = new PDU__BSSMAP__HandoverCommand_template;
single_value.field_handoverCommand->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverComplete:
single_value.field_handoverComplete = new PDU__BSSMAP__HandoverComplete_template;
single_value.field_handoverComplete->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverDetect:
single_value.field_handoverDetect = new PDU__BSSMAP__HandoverDetect_template;
single_value.field_handoverDetect->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverFailure:
single_value.field_handoverFailure = new PDU__BSSMAP__HandoverFailure_template;
single_value.field_handoverFailure->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverPerformed:
single_value.field_handoverPerformed = new PDU__BSSMAP__HandoverPerformed_template;
single_value.field_handoverPerformed->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverRequest:
single_value.field_handoverRequest = new PDU__BSSMAP__HandoverRequest_template;
single_value.field_handoverRequest->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverRequestAck:
single_value.field_handoverRequestAck = new PDU__BSSMAP__HandoverRequestAck_template;
single_value.field_handoverRequestAck->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverRequired:
single_value.field_handoverRequired = new PDU__BSSMAP__HandoverRequired_template;
single_value.field_handoverRequired->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverRequiredReject:
single_value.field_handoverRequiredReject = new PDU__BSSMAP__HandoverRequiredReject_template;
single_value.field_handoverRequiredReject->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_handoverSucceeded:
single_value.field_handoverSucceeded = new PDU__BSSMAP__HandoverSucceeded_template;
single_value.field_handoverSucceeded->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_loadIndication:
single_value.field_loadIndication = new PDU__BSSMAP__LoadIndication_template;
single_value.field_loadIndication->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_lSAInformation:
single_value.field_lSAInformation = new PDU__BSSMAP__LSAInformation_template;
single_value.field_lSAInformation->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_mSCInvokeTrace:
single_value.field_mSCInvokeTrace = new PDU__BSSMAP__MSCInvokeTrace_template;
single_value.field_mSCInvokeTrace->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_overload:
single_value.field_overload = new PDU__BSSMAP__Overload_template;
single_value.field_overload->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_paging:
single_value.field_paging = new PDU__BSSMAP__Paging_template;
single_value.field_paging->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_performLocationAbort:
single_value.field_performLocationAbort = new PDU__BSSMAP__PerformLocationAbort_template;
single_value.field_performLocationAbort->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_performLocationRequest:
single_value.field_performLocationRequest = new PDU__BSSMAP__PerformLocationRequest_template;
single_value.field_performLocationRequest->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_performLocationResponse:
single_value.field_performLocationResponse = new PDU__BSSMAP__PerformLocationResponse_template;
single_value.field_performLocationResponse->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_queueingIndication:
single_value.field_queueingIndication = new PDU__BSSMAP__QueueingIndication_template;
single_value.field_queueingIndication->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_reset:
single_value.field_reset = new PDU__BSSMAP__Reset_template;
single_value.field_reset->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_resetAck:
single_value.field_resetAck = new PDU__BSSMAP__ResetAck_template;
single_value.field_resetAck->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_resetCircuit:
single_value.field_resetCircuit = new PDU__BSSMAP__ResetCircuit_template;
single_value.field_resetCircuit->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_resetCircuitAck:
single_value.field_resetCircuitAck = new PDU__BSSMAP__ResetCircuitAck_template;
single_value.field_resetCircuitAck->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_resourceIndication:
single_value.field_resourceIndication = new PDU__BSSMAP__ResourceIndication_template;
single_value.field_resourceIndication->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_resourceRequest:
single_value.field_resourceRequest = new PDU__BSSMAP__ResourceRequest_template;
single_value.field_resourceRequest->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_sAPInReject:
single_value.field_sAPInReject = new PDU__BSSMAP__SAPInReject_template;
single_value.field_sAPInReject->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_suspend:
single_value.field_suspend = new PDU__BSSMAP__Suspend_template;
single_value.field_suspend->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_resume:
single_value.field_resume = new PDU__BSSMAP__Resume_template;
single_value.field_resume->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_unblock:
single_value.field_unblock = new PDU__BSSMAP__Unblock_template;
single_value.field_unblock->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_unblockAck:
single_value.field_unblockAck = new PDU__BSSMAP__UnblockAck_template;
single_value.field_unblockAck->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_unequippedCircuit:
single_value.field_unequippedCircuit = new PDU__BSSMAP__UnequippedCircuit_template;
single_value.field_unequippedCircuit->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_uplinkRequest:
single_value.field_uplinkRequest = new PDU__BSSMAP__UplinkRequest_template;
single_value.field_uplinkRequest->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_uplinkRequestAck:
single_value.field_uplinkRequestAck = new PDU__BSSMAP__UplinkRequestAck_template;
single_value.field_uplinkRequestAck->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_uplinkRequestConfirmation:
single_value.field_uplinkRequestConfirmation = new PDU__BSSMAP__UplinkRequestConfirmation_template;
single_value.field_uplinkRequestConfirmation->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_uplinkReleaseIndication:
single_value.field_uplinkReleaseIndication = new PDU__BSSMAP__UplinkReleaseIndication_template;
single_value.field_uplinkReleaseIndication->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_uplinkRejectCommand:
single_value.field_uplinkRejectCommand = new PDU__BSSMAP__UplinkRejectCommand_template;
single_value.field_uplinkRejectCommand->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_uplinkReleaseCommand:
single_value.field_uplinkReleaseCommand = new PDU__BSSMAP__UplinkReleaseCommand_template;
single_value.field_uplinkReleaseCommand->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_uplinkSeizedCommand:
single_value.field_uplinkSeizedCommand = new PDU__BSSMAP__UplinkSeizedCommand_template;
single_value.field_uplinkSeizedCommand->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetup:
single_value.field_vGCS__VBSSetup = new PDU__BSSMAP__VGCS__VBSSetup_template;
single_value.field_vGCS__VBSSetup->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetupAck:
single_value.field_vGCS__VBSSetupAck = new PDU__BSSMAP__VGCS__VBSSetupAck_template;
single_value.field_vGCS__VBSSetupAck->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_vGCS__VBSSetupRefuse:
single_value.field_vGCS__VBSSetupRefuse = new PDU__BSSMAP__VGCS__VBSSetupRefuse_template;
single_value.field_vGCS__VBSSetupRefuse->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentRequest:
single_value.field_vGCS__VBSAssignmentRequest = new PDU__BSSMAP__VGCS__VBSAssignmentRequest_template;
single_value.field_vGCS__VBSAssignmentRequest->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentResult:
single_value.field_vGCS__VBSAssignmentResult = new PDU__BSSMAP__VGCS__VBSAssignmentResult_template;
single_value.field_vGCS__VBSAssignmentResult->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentFailure:
single_value.field_vGCS__VBSAssignmentFailure = new PDU__BSSMAP__VGCS__VBSAssignmentFailure_template;
single_value.field_vGCS__VBSAssignmentFailure->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_vGCS__VBSQueuingIndication:
single_value.field_vGCS__VBSQueuingIndication = new PDU__BSSMAP__VGCS__VBSQueuingIndication_template;
single_value.field_vGCS__VBSQueuingIndication->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_vGCS__AdditionalInformation:
single_value.field_vGCS__AdditionalInformation = new PDU__BSSMAP__VGCS__AdditionalInformation_template;
single_value.field_vGCS__AdditionalInformation->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_vGCS__VBS__AreaCellInfo:
single_value.field_vGCS__VBS__AreaCellInfo = new PDU__BSSMAP__VGCS__VBS__AreaCellInfo_template;
single_value.field_vGCS__VBS__AreaCellInfo->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_vGCS__VBS__AssignmentStatus:
single_value.field_vGCS__VBS__AssignmentStatus = new PDU__BSSMAP__VGCS__VBS__AssignmentStatus_template;
single_value.field_vGCS__VBS__AssignmentStatus->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_vGCS__SMS:
single_value.field_vGCS__SMS = new PDU__BSSMAP__VGCS__SMS_template;
single_value.field_vGCS__SMS->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_uplinkApplicationData:
single_value.field_uplinkApplicationData = new PDU__BSSMAP__UplinkApplicationData_template;
single_value.field_uplinkApplicationData->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_notificationData:
single_value.field_notificationData = new PDU__BSSMAP__NotificationData_template;
single_value.field_notificationData->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_internalHandoverRequired:
single_value.field_internalHandoverRequired = new PDU__BSSMAP__InternalHandoverRequired_template;
single_value.field_internalHandoverRequired->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_internalHandoverRequiredReject:
single_value.field_internalHandoverRequiredReject = new PDU__BSSMAP__InternalHandoverRequiredReject_template;
single_value.field_internalHandoverRequiredReject->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_internalHandoverCommand:
single_value.field_internalHandoverCommand = new PDU__BSSMAP__InternalHandoverCommand_template;
single_value.field_internalHandoverCommand->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_internalHandoverEnquiry:
single_value.field_internalHandoverEnquiry = new PDU__BSSMAP__InternalHandoverEnquiry_template;
single_value.field_internalHandoverEnquiry->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_resetIPResource:
single_value.field_resetIPResource = new PDU__BSSMAP__ResetIPResource_template;
single_value.field_resetIPResource->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_resetIPResourceAck:
single_value.field_resetIPResourceAck = new PDU__BSSMAP__ResetIPResourceAck_template;
single_value.field_resetIPResourceAck->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_rerouteCommand:
single_value.field_rerouteCommand = new PDU__BSSMAP__RerouteCommand_template;
single_value.field_rerouteCommand->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_rerouteComplete:
single_value.field_rerouteComplete = new PDU__BSSMAP__RerouteComplete_template;
single_value.field_rerouteComplete->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_lCLS__ConnectControl:
single_value.field_lCLS__ConnectControl = new PDU__BSSMAP__LCLS__ConnectControl_template;
single_value.field_lCLS__ConnectControl->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_lCLS__connectControlAck:
single_value.field_lCLS__connectControlAck = new PDU__BSSMAP__LCLS__ConnectControlAck_template;
single_value.field_lCLS__connectControlAck->decode_text(text_buf);
break;
case PDU__BSSMAP::ALT_lCLS__Notification:
single_value.field_lCLS__Notification = new PDU__BSSMAP__LCLS__Notification_template;
single_value.field_lCLS__Notification->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @BSSAP_Types.PDU_BSSMAP.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSMAP_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @BSSAP_Types.PDU_BSSMAP.");
}
}

boolean PDU__BSSMAP_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSMAP_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void PDU__BSSMAP_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@BSSAP_Types.PDU_BSSMAP'");
    }
    if (strcmp("assignmentRequest", param_field) == 0) {
      assignmentRequest().set_param(param);
      return;
    } else if (strcmp("assignmentComplete", param_field) == 0) {
      assignmentComplete().set_param(param);
      return;
    } else if (strcmp("assignmentFailure", param_field) == 0) {
      assignmentFailure().set_param(param);
      return;
    } else if (strcmp("channelModifyRequest", param_field) == 0) {
      channelModifyRequest().set_param(param);
      return;
    } else if (strcmp("block", param_field) == 0) {
      block().set_param(param);
      return;
    } else if (strcmp("blockingAck", param_field) == 0) {
      blockingAck().set_param(param);
      return;
    } else if (strcmp("bSSInvokeTrace", param_field) == 0) {
      bSSInvokeTrace().set_param(param);
      return;
    } else if (strcmp("changeCircuit", param_field) == 0) {
      changeCircuit().set_param(param);
      return;
    } else if (strcmp("changeCircuitAck", param_field) == 0) {
      changeCircuitAck().set_param(param);
      return;
    } else if (strcmp("cipherModeCommand", param_field) == 0) {
      cipherModeCommand().set_param(param);
      return;
    } else if (strcmp("cipherModeComplete", param_field) == 0) {
      cipherModeComplete().set_param(param);
      return;
    } else if (strcmp("cipherModeReject", param_field) == 0) {
      cipherModeReject().set_param(param);
      return;
    } else if (strcmp("circuitGroupBlock", param_field) == 0) {
      circuitGroupBlock().set_param(param);
      return;
    } else if (strcmp("circuitGroupBlockingAck", param_field) == 0) {
      circuitGroupBlockingAck().set_param(param);
      return;
    } else if (strcmp("circuitGroupUnblock", param_field) == 0) {
      circuitGroupUnblock().set_param(param);
      return;
    } else if (strcmp("circuitGroupUnblockAck", param_field) == 0) {
      circuitGroupUnblockAck().set_param(param);
      return;
    } else if (strcmp("classmarkRequest", param_field) == 0) {
      classmarkRequest().set_param(param);
      return;
    } else if (strcmp("classmarkUpdate", param_field) == 0) {
      classmarkUpdate().set_param(param);
      return;
    } else if (strcmp("clearCommand", param_field) == 0) {
      clearCommand().set_param(param);
      return;
    } else if (strcmp("clearComplete", param_field) == 0) {
      clearComplete().set_param(param);
      return;
    } else if (strcmp("clearRequest", param_field) == 0) {
      clearRequest().set_param(param);
      return;
    } else if (strcmp("commonID", param_field) == 0) {
      commonID().set_param(param);
      return;
    } else if (strcmp("completeLayer3Information", param_field) == 0) {
      completeLayer3Information().set_param(param);
      return;
    } else if (strcmp("confusion", param_field) == 0) {
      confusion().set_param(param);
      return;
    } else if (strcmp("connectionlessInformation", param_field) == 0) {
      connectionlessInformation().set_param(param);
      return;
    } else if (strcmp("handoverCandidateEnquire", param_field) == 0) {
      handoverCandidateEnquire().set_param(param);
      return;
    } else if (strcmp("handoverCandidateResponse", param_field) == 0) {
      handoverCandidateResponse().set_param(param);
      return;
    } else if (strcmp("handoverCommand", param_field) == 0) {
      handoverCommand().set_param(param);
      return;
    } else if (strcmp("handoverComplete", param_field) == 0) {
      handoverComplete().set_param(param);
      return;
    } else if (strcmp("handoverDetect", param_field) == 0) {
      handoverDetect().set_param(param);
      return;
    } else if (strcmp("handoverFailure", param_field) == 0) {
      handoverFailure().set_param(param);
      return;
    } else if (strcmp("handoverPerformed", param_field) == 0) {
      handoverPerformed().set_param(param);
      return;
    } else if (strcmp("handoverRequest", param_field) == 0) {
      handoverRequest().set_param(param);
      return;
    } else if (strcmp("handoverRequestAck", param_field) == 0) {
      handoverRequestAck().set_param(param);
      return;
    } else if (strcmp("handoverRequired", param_field) == 0) {
      handoverRequired().set_param(param);
      return;
    } else if (strcmp("handoverRequiredReject", param_field) == 0) {
      handoverRequiredReject().set_param(param);
      return;
    } else if (strcmp("handoverSucceeded", param_field) == 0) {
      handoverSucceeded().set_param(param);
      return;
    } else if (strcmp("loadIndication", param_field) == 0) {
      loadIndication().set_param(param);
      return;
    } else if (strcmp("lSAInformation", param_field) == 0) {
      lSAInformation().set_param(param);
      return;
    } else if (strcmp("mSCInvokeTrace", param_field) == 0) {
      mSCInvokeTrace().set_param(param);
      return;
    } else if (strcmp("overload", param_field) == 0) {
      overload().set_param(param);
      return;
    } else if (strcmp("paging", param_field) == 0) {
      paging().set_param(param);
      return;
    } else if (strcmp("performLocationAbort", param_field) == 0) {
      performLocationAbort().set_param(param);
      return;
    } else if (strcmp("performLocationRequest", param_field) == 0) {
      performLocationRequest().set_param(param);
      return;
    } else if (strcmp("performLocationResponse", param_field) == 0) {
      performLocationResponse().set_param(param);
      return;
    } else if (strcmp("queueingIndication", param_field) == 0) {
      queueingIndication().set_param(param);
      return;
    } else if (strcmp("reset", param_field) == 0) {
      reset().set_param(param);
      return;
    } else if (strcmp("resetAck", param_field) == 0) {
      resetAck().set_param(param);
      return;
    } else if (strcmp("resetCircuit", param_field) == 0) {
      resetCircuit().set_param(param);
      return;
    } else if (strcmp("resetCircuitAck", param_field) == 0) {
      resetCircuitAck().set_param(param);
      return;
    } else if (strcmp("resourceIndication", param_field) == 0) {
      resourceIndication().set_param(param);
      return;
    } else if (strcmp("resourceRequest", param_field) == 0) {
      resourceRequest().set_param(param);
      return;
    } else if (strcmp("sAPInReject", param_field) == 0) {
      sAPInReject().set_param(param);
      return;
    } else if (strcmp("suspend", param_field) == 0) {
      suspend().set_param(param);
      return;
    } else if (strcmp("resume", param_field) == 0) {
      resume().set_param(param);
      return;
    } else if (strcmp("unblock", param_field) == 0) {
      unblock().set_param(param);
      return;
    } else if (strcmp("unblockAck", param_field) == 0) {
      unblockAck().set_param(param);
      return;
    } else if (strcmp("unequippedCircuit", param_field) == 0) {
      unequippedCircuit().set_param(param);
      return;
    } else if (strcmp("uplinkRequest", param_field) == 0) {
      uplinkRequest().set_param(param);
      return;
    } else if (strcmp("uplinkRequestAck", param_field) == 0) {
      uplinkRequestAck().set_param(param);
      return;
    } else if (strcmp("uplinkRequestConfirmation", param_field) == 0) {
      uplinkRequestConfirmation().set_param(param);
      return;
    } else if (strcmp("uplinkReleaseIndication", param_field) == 0) {
      uplinkReleaseIndication().set_param(param);
      return;
    } else if (strcmp("uplinkRejectCommand", param_field) == 0) {
      uplinkRejectCommand().set_param(param);
      return;
    } else if (strcmp("uplinkReleaseCommand", param_field) == 0) {
      uplinkReleaseCommand().set_param(param);
      return;
    } else if (strcmp("uplinkSeizedCommand", param_field) == 0) {
      uplinkSeizedCommand().set_param(param);
      return;
    } else if (strcmp("vGCS_VBSSetup", param_field) == 0) {
      vGCS__VBSSetup().set_param(param);
      return;
    } else if (strcmp("vGCS_VBSSetupAck", param_field) == 0) {
      vGCS__VBSSetupAck().set_param(param);
      return;
    } else if (strcmp("vGCS_VBSSetupRefuse", param_field) == 0) {
      vGCS__VBSSetupRefuse().set_param(param);
      return;
    } else if (strcmp("vGCS_VBSAssignmentRequest", param_field) == 0) {
      vGCS__VBSAssignmentRequest().set_param(param);
      return;
    } else if (strcmp("vGCS_VBSAssignmentResult", param_field) == 0) {
      vGCS__VBSAssignmentResult().set_param(param);
      return;
    } else if (strcmp("vGCS_VBSAssignmentFailure", param_field) == 0) {
      vGCS__VBSAssignmentFailure().set_param(param);
      return;
    } else if (strcmp("vGCS_VBSQueuingIndication", param_field) == 0) {
      vGCS__VBSQueuingIndication().set_param(param);
      return;
    } else if (strcmp("vGCS_AdditionalInformation", param_field) == 0) {
      vGCS__AdditionalInformation().set_param(param);
      return;
    } else if (strcmp("vGCS_VBS_AreaCellInfo", param_field) == 0) {
      vGCS__VBS__AreaCellInfo().set_param(param);
      return;
    } else if (strcmp("vGCS_VBS_AssignmentStatus", param_field) == 0) {
      vGCS__VBS__AssignmentStatus().set_param(param);
      return;
    } else if (strcmp("vGCS_SMS", param_field) == 0) {
      vGCS__SMS().set_param(param);
      return;
    } else if (strcmp("uplinkApplicationData", param_field) == 0) {
      uplinkApplicationData().set_param(param);
      return;
    } else if (strcmp("notificationData", param_field) == 0) {
      notificationData().set_param(param);
      return;
    } else if (strcmp("internalHandoverRequired", param_field) == 0) {
      internalHandoverRequired().set_param(param);
      return;
    } else if (strcmp("internalHandoverRequiredReject", param_field) == 0) {
      internalHandoverRequiredReject().set_param(param);
      return;
    } else if (strcmp("internalHandoverCommand", param_field) == 0) {
      internalHandoverCommand().set_param(param);
      return;
    } else if (strcmp("internalHandoverEnquiry", param_field) == 0) {
      internalHandoverEnquiry().set_param(param);
      return;
    } else if (strcmp("resetIPResource", param_field) == 0) {
      resetIPResource().set_param(param);
      return;
    } else if (strcmp("resetIPResourceAck", param_field) == 0) {
      resetIPResourceAck().set_param(param);
      return;
    } else if (strcmp("rerouteCommand", param_field) == 0) {
      rerouteCommand().set_param(param);
      return;
    } else if (strcmp("rerouteComplete", param_field) == 0) {
      rerouteComplete().set_param(param);
      return;
    } else if (strcmp("lCLS_ConnectControl", param_field) == 0) {
      lCLS__ConnectControl().set_param(param);
      return;
    } else if (strcmp("lCLS_connectControlAck", param_field) == 0) {
      lCLS__connectControlAck().set_param(param);
      return;
    } else if (strcmp("lCLS_Notification", param_field) == 0) {
      lCLS__Notification().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@BSSAP_Types.PDU_BSSMAP'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSMAP_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@BSSAP_Types.PDU_BSSMAP");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "assignmentRequest")) {
      assignmentRequest().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "assignmentComplete")) {
      assignmentComplete().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "assignmentFailure")) {
      assignmentFailure().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "channelModifyRequest")) {
      channelModifyRequest().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "block")) {
      block().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "blockingAck")) {
      blockingAck().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "bSSInvokeTrace")) {
      bSSInvokeTrace().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "changeCircuit")) {
      changeCircuit().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "changeCircuitAck")) {
      changeCircuitAck().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cipherModeCommand")) {
      cipherModeCommand().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cipherModeComplete")) {
      cipherModeComplete().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "cipherModeReject")) {
      cipherModeReject().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "circuitGroupBlock")) {
      circuitGroupBlock().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "circuitGroupBlockingAck")) {
      circuitGroupBlockingAck().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "circuitGroupUnblock")) {
      circuitGroupUnblock().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "circuitGroupUnblockAck")) {
      circuitGroupUnblockAck().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "classmarkRequest")) {
      classmarkRequest().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "classmarkUpdate")) {
      classmarkUpdate().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "clearCommand")) {
      clearCommand().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "clearComplete")) {
      clearComplete().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "clearRequest")) {
      clearRequest().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "commonID")) {
      commonID().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "completeLayer3Information")) {
      completeLayer3Information().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "confusion")) {
      confusion().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "connectionlessInformation")) {
      connectionlessInformation().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "handoverCandidateEnquire")) {
      handoverCandidateEnquire().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "handoverCandidateResponse")) {
      handoverCandidateResponse().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "handoverCommand")) {
      handoverCommand().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "handoverComplete")) {
      handoverComplete().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "handoverDetect")) {
      handoverDetect().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "handoverFailure")) {
      handoverFailure().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "handoverPerformed")) {
      handoverPerformed().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "handoverRequest")) {
      handoverRequest().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "handoverRequestAck")) {
      handoverRequestAck().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "handoverRequired")) {
      handoverRequired().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "handoverRequiredReject")) {
      handoverRequiredReject().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "handoverSucceeded")) {
      handoverSucceeded().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "loadIndication")) {
      loadIndication().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "lSAInformation")) {
      lSAInformation().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "mSCInvokeTrace")) {
      mSCInvokeTrace().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "overload")) {
      overload().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "paging")) {
      paging().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "performLocationAbort")) {
      performLocationAbort().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "performLocationRequest")) {
      performLocationRequest().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "performLocationResponse")) {
      performLocationResponse().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "queueingIndication")) {
      queueingIndication().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "reset")) {
      reset().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "resetAck")) {
      resetAck().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "resetCircuit")) {
      resetCircuit().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "resetCircuitAck")) {
      resetCircuitAck().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "resourceIndication")) {
      resourceIndication().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "resourceRequest")) {
      resourceRequest().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "sAPInReject")) {
      sAPInReject().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "suspend")) {
      suspend().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "resume")) {
      resume().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "unblock")) {
      unblock().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "unblockAck")) {
      unblockAck().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "unequippedCircuit")) {
      unequippedCircuit().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "uplinkRequest")) {
      uplinkRequest().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "uplinkRequestAck")) {
      uplinkRequestAck().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "uplinkRequestConfirmation")) {
      uplinkRequestConfirmation().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "uplinkReleaseIndication")) {
      uplinkReleaseIndication().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "uplinkRejectCommand")) {
      uplinkRejectCommand().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "uplinkReleaseCommand")) {
      uplinkReleaseCommand().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "uplinkSeizedCommand")) {
      uplinkSeizedCommand().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "vGCS_VBSSetup")) {
      vGCS__VBSSetup().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "vGCS_VBSSetupAck")) {
      vGCS__VBSSetupAck().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "vGCS_VBSSetupRefuse")) {
      vGCS__VBSSetupRefuse().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "vGCS_VBSAssignmentRequest")) {
      vGCS__VBSAssignmentRequest().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "vGCS_VBSAssignmentResult")) {
      vGCS__VBSAssignmentResult().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "vGCS_VBSAssignmentFailure")) {
      vGCS__VBSAssignmentFailure().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "vGCS_VBSQueuingIndication")) {
      vGCS__VBSQueuingIndication().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "vGCS_AdditionalInformation")) {
      vGCS__AdditionalInformation().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "vGCS_VBS_AreaCellInfo")) {
      vGCS__VBS__AreaCellInfo().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "vGCS_VBS_AssignmentStatus")) {
      vGCS__VBS__AssignmentStatus().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "vGCS_SMS")) {
      vGCS__SMS().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "uplinkApplicationData")) {
      uplinkApplicationData().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "notificationData")) {
      notificationData().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "internalHandoverRequired")) {
      internalHandoverRequired().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "internalHandoverRequiredReject")) {
      internalHandoverRequiredReject().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "internalHandoverCommand")) {
      internalHandoverCommand().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "internalHandoverEnquiry")) {
      internalHandoverEnquiry().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "resetIPResource")) {
      resetIPResource().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "resetIPResourceAck")) {
      resetIPResourceAck().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "rerouteCommand")) {
      rerouteCommand().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "rerouteComplete")) {
      rerouteComplete().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "lCLS_ConnectControl")) {
      lCLS__ConnectControl().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "lCLS_connectControlAck")) {
      lCLS__connectControlAck().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "lCLS_Notification")) {
      lCLS__Notification().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @BSSAP_Types.PDU_BSSMAP.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSMAP_template* precondition = new PDU__BSSMAP_template;
    precondition->set_param(*m_p->get_elem(0));
    PDU__BSSMAP_template* implied_template = new PDU__BSSMAP_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = PDU__BSSMAP_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@BSSAP_Types.PDU_BSSMAP");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSMAP_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case PDU__BSSMAP::ALT_assignmentRequest:
single_value.field_assignmentRequest->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_assignmentComplete:
single_value.field_assignmentComplete->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_assignmentFailure:
single_value.field_assignmentFailure->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_channelModifyRequest:
single_value.field_channelModifyRequest->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_block:
single_value.field_block->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_blockingAck:
single_value.field_blockingAck->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_bSSInvokeTrace:
single_value.field_bSSInvokeTrace->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_changeCircuit:
single_value.field_changeCircuit->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_changeCircuitAck:
single_value.field_changeCircuitAck->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_cipherModeCommand:
single_value.field_cipherModeCommand->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_cipherModeComplete:
single_value.field_cipherModeComplete->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_cipherModeReject:
single_value.field_cipherModeReject->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_circuitGroupBlock:
single_value.field_circuitGroupBlock->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_circuitGroupBlockingAck:
single_value.field_circuitGroupBlockingAck->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_circuitGroupUnblock:
single_value.field_circuitGroupUnblock->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_circuitGroupUnblockAck:
single_value.field_circuitGroupUnblockAck->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_classmarkRequest:
single_value.field_classmarkRequest->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_classmarkUpdate:
single_value.field_classmarkUpdate->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_clearCommand:
single_value.field_clearCommand->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_clearComplete:
single_value.field_clearComplete->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_clearRequest:
single_value.field_clearRequest->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_commonID:
single_value.field_commonID->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_completeLayer3Information:
single_value.field_completeLayer3Information->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_confusion:
single_value.field_confusion->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_connectionlessInformation:
single_value.field_connectionlessInformation->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_handoverCandidateEnquire:
single_value.field_handoverCandidateEnquire->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_handoverCandidateResponse:
single_value.field_handoverCandidateResponse->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_handoverCommand:
single_value.field_handoverCommand->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_handoverComplete:
single_value.field_handoverComplete->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_handoverDetect:
single_value.field_handoverDetect->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_handoverFailure:
single_value.field_handoverFailure->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_handoverPerformed:
single_value.field_handoverPerformed->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_handoverRequest:
single_value.field_handoverRequest->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_handoverRequestAck:
single_value.field_handoverRequestAck->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_handoverRequired:
single_value.field_handoverRequired->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_handoverRequiredReject:
single_value.field_handoverRequiredReject->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_handoverSucceeded:
single_value.field_handoverSucceeded->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_loadIndication:
single_value.field_loadIndication->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_lSAInformation:
single_value.field_lSAInformation->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_mSCInvokeTrace:
single_value.field_mSCInvokeTrace->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_overload:
single_value.field_overload->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_paging:
single_value.field_paging->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_performLocationAbort:
single_value.field_performLocationAbort->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_performLocationRequest:
single_value.field_performLocationRequest->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_performLocationResponse:
single_value.field_performLocationResponse->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_queueingIndication:
single_value.field_queueingIndication->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_reset:
single_value.field_reset->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_resetAck:
single_value.field_resetAck->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_resetCircuit:
single_value.field_resetCircuit->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_resetCircuitAck:
single_value.field_resetCircuitAck->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_resourceIndication:
single_value.field_resourceIndication->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_resourceRequest:
single_value.field_resourceRequest->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_sAPInReject:
single_value.field_sAPInReject->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_suspend:
single_value.field_suspend->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_resume:
single_value.field_resume->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_unblock:
single_value.field_unblock->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_unblockAck:
single_value.field_unblockAck->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_unequippedCircuit:
single_value.field_unequippedCircuit->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_uplinkRequest:
single_value.field_uplinkRequest->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_uplinkRequestAck:
single_value.field_uplinkRequestAck->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_uplinkRequestConfirmation:
single_value.field_uplinkRequestConfirmation->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_uplinkReleaseIndication:
single_value.field_uplinkReleaseIndication->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_uplinkRejectCommand:
single_value.field_uplinkRejectCommand->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_uplinkReleaseCommand:
single_value.field_uplinkReleaseCommand->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_uplinkSeizedCommand:
single_value.field_uplinkSeizedCommand->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_vGCS__VBSSetup:
single_value.field_vGCS__VBSSetup->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_vGCS__VBSSetupAck:
single_value.field_vGCS__VBSSetupAck->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_vGCS__VBSSetupRefuse:
single_value.field_vGCS__VBSSetupRefuse->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentRequest:
single_value.field_vGCS__VBSAssignmentRequest->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentResult:
single_value.field_vGCS__VBSAssignmentResult->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_vGCS__VBSAssignmentFailure:
single_value.field_vGCS__VBSAssignmentFailure->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_vGCS__VBSQueuingIndication:
single_value.field_vGCS__VBSQueuingIndication->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_vGCS__AdditionalInformation:
single_value.field_vGCS__AdditionalInformation->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_vGCS__VBS__AreaCellInfo:
single_value.field_vGCS__VBS__AreaCellInfo->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_vGCS__VBS__AssignmentStatus:
single_value.field_vGCS__VBS__AssignmentStatus->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_vGCS__SMS:
single_value.field_vGCS__SMS->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_uplinkApplicationData:
single_value.field_uplinkApplicationData->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_notificationData:
single_value.field_notificationData->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_internalHandoverRequired:
single_value.field_internalHandoverRequired->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_internalHandoverRequiredReject:
single_value.field_internalHandoverRequiredReject->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_internalHandoverCommand:
single_value.field_internalHandoverCommand->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_internalHandoverEnquiry:
single_value.field_internalHandoverEnquiry->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_resetIPResource:
single_value.field_resetIPResource->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_resetIPResourceAck:
single_value.field_resetIPResourceAck->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_rerouteCommand:
single_value.field_rerouteCommand->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_rerouteComplete:
single_value.field_rerouteComplete->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_lCLS__ConnectControl:
single_value.field_lCLS__ConnectControl->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_lCLS__connectControlAck:
single_value.field_lCLS__connectControlAck->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
case PDU__BSSMAP::ALT_lCLS__Notification:
single_value.field_lCLS__Notification->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @BSSAP_Types.PDU_BSSMAP.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSMAP");
}

void BSSMAPorDTAP::copy_value(const BSSMAPorDTAP& other_value)
{
switch (other_value.union_selection) {
case ALT_bssmap:
field_bssmap = new PDU__BSSMAP(*other_value.field_bssmap);
break;
case ALT_dtap:
field_dtap = new OCTETSTRING(*other_value.field_dtap);
break;
default:
TTCN_error("Assignment of an unbound union value of type @BSSAP_Types.BSSMAPorDTAP.");
}
union_selection = other_value.union_selection;
}

BSSMAPorDTAP::BSSMAPorDTAP()
{
union_selection = UNBOUND_VALUE;
}

BSSMAPorDTAP::BSSMAPorDTAP(const BSSMAPorDTAP& other_value)
: Base_Type(){
copy_value(other_value);
}

BSSMAPorDTAP::~BSSMAPorDTAP()
{
clean_up();
}

BSSMAPorDTAP& BSSMAPorDTAP::operator=(const BSSMAPorDTAP& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean BSSMAPorDTAP::operator==(const BSSMAPorDTAP& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @BSSAP_Types.BSSMAPorDTAP.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @BSSAP_Types.BSSMAPorDTAP.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_bssmap:
return *field_bssmap == *other_value.field_bssmap;
case ALT_dtap:
return *field_dtap == *other_value.field_dtap;
default:
return FALSE;
}
}

PDU__BSSMAP& BSSMAPorDTAP::bssmap()
{
if (union_selection != ALT_bssmap) {
clean_up();
field_bssmap = new PDU__BSSMAP;
union_selection = ALT_bssmap;
}
return *field_bssmap;
}

const PDU__BSSMAP& BSSMAPorDTAP::bssmap() const
{
if (union_selection != ALT_bssmap) TTCN_error("Using non-selected field bssmap in a value of union type @BSSAP_Types.BSSMAPorDTAP.");
return *field_bssmap;
}

OCTETSTRING& BSSMAPorDTAP::dtap()
{
if (union_selection != ALT_dtap) {
clean_up();
field_dtap = new OCTETSTRING;
union_selection = ALT_dtap;
}
return *field_dtap;
}

const OCTETSTRING& BSSMAPorDTAP::dtap() const
{
if (union_selection != ALT_dtap) TTCN_error("Using non-selected field dtap in a value of union type @BSSAP_Types.BSSMAPorDTAP.");
return *field_dtap;
}

boolean BSSMAPorDTAP::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @BSSAP_Types.BSSMAPorDTAP.");
return union_selection == checked_selection;
}

boolean BSSMAPorDTAP::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean BSSMAPorDTAP::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_bssmap: return field_bssmap->is_value();
case ALT_dtap: return field_dtap->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void BSSMAPorDTAP::clean_up()
{
switch (union_selection) {
case ALT_bssmap:
  delete field_bssmap;
  break;
case ALT_dtap:
  delete field_dtap;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void BSSMAPorDTAP::log() const
{
switch (union_selection) {
case ALT_bssmap:
TTCN_Logger::log_event_str("{ bssmap := ");
field_bssmap->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_dtap:
TTCN_Logger::log_event_str("{ dtap := ");
field_dtap->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void BSSMAPorDTAP::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "bssmap")) {
    bssmap().set_param(*mp_last);
    if (!bssmap().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "dtap")) {
    dtap().set_param(*mp_last);
    if (!dtap().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @BSSAP_Types.BSSMAPorDTAP.", last_name);
}

void BSSMAPorDTAP::set_implicit_omit()
{
switch (union_selection) {
case ALT_bssmap:
field_bssmap->set_implicit_omit(); break;
case ALT_dtap:
field_dtap->set_implicit_omit(); break;
default: break;
}
}

void BSSMAPorDTAP::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_bssmap:
field_bssmap->encode_text(text_buf);
break;
case ALT_dtap:
field_dtap->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @BSSAP_Types.BSSMAPorDTAP.");
}
}

void BSSMAPorDTAP::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_bssmap:
bssmap().decode_text(text_buf);
break;
case ALT_dtap:
dtap().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @BSSAP_Types.BSSMAPorDTAP.");
}
}

void BSSMAPorDTAP::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void BSSMAPorDTAP::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int BSSMAPorDTAP::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, PDU__BSSMAP_descr_.raw->forceomit);
      decoded_length = bssmap().RAW_decode(PDU__BSSMAP_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, OCTETSTRING_descr_.raw->forceomit);
      decoded_length = dtap().RAW_decode(OCTETSTRING_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_0_force_omit(0, force_omit, PDU__BSSMAP_descr_.raw->forceomit);
      decoded_length = bssmap().RAW_decode(PDU__BSSMAP_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_0_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_1_force_omit(1, force_omit, OCTETSTRING_descr_.raw->forceomit);
      decoded_length = dtap().RAW_decode(OCTETSTRING_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_1_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
 }
 clean_up();
 return -1;
}

int BSSMAPorDTAP::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  memset(myleaf.body.node.nodes, 0, 2 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_bssmap:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, PDU__BSSMAP_descr_.raw);
    encoded_length = field_bssmap->RAW_encode(PDU__BSSMAP_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &PDU__BSSMAP_descr_;
    break;
  case ALT_dtap:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, OCTETSTRING_descr_.raw);
    encoded_length = field_dtap->RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &OCTETSTRING_descr_;
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void BSSMAPorDTAP_template::copy_value(const BSSMAPorDTAP& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case BSSMAPorDTAP::ALT_bssmap:
single_value.field_bssmap = new PDU__BSSMAP_template(other_value.bssmap());
break;
case BSSMAPorDTAP::ALT_dtap:
single_value.field_dtap = new OCTETSTRING_template(other_value.dtap());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @BSSAP_Types.BSSMAPorDTAP.");
}
set_selection(SPECIFIC_VALUE);
}

void BSSMAPorDTAP_template::copy_template(const BSSMAPorDTAP_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case BSSMAPorDTAP::ALT_bssmap:
single_value.field_bssmap = new PDU__BSSMAP_template(*other_value.single_value.field_bssmap);
break;
case BSSMAPorDTAP::ALT_dtap:
single_value.field_dtap = new OCTETSTRING_template(*other_value.single_value.field_dtap);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @BSSAP_Types.BSSMAPorDTAP.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new BSSMAPorDTAP_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new BSSMAPorDTAP_template(*other_value.implication_.precondition);
implication_.implied_template = new BSSMAPorDTAP_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @BSSAP_Types.BSSMAPorDTAP.");
}
set_selection(other_value);
}

BSSMAPorDTAP_template::BSSMAPorDTAP_template()
{
}

BSSMAPorDTAP_template::BSSMAPorDTAP_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

BSSMAPorDTAP_template::BSSMAPorDTAP_template(const BSSMAPorDTAP& other_value)
{
copy_value(other_value);
}

BSSMAPorDTAP_template::BSSMAPorDTAP_template(const OPTIONAL<BSSMAPorDTAP>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAPorDTAP&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @BSSAP_Types.BSSMAPorDTAP from an unbound optional field.");
}
}

BSSMAPorDTAP_template::BSSMAPorDTAP_template(BSSMAPorDTAP_template* p_precondition, BSSMAPorDTAP_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

BSSMAPorDTAP_template::BSSMAPorDTAP_template(Dynamic_Match_Interface<BSSMAPorDTAP>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<BSSMAPorDTAP>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

BSSMAPorDTAP_template::BSSMAPorDTAP_template(const BSSMAPorDTAP_template& other_value)
: Base_Template(){
copy_template(other_value);
}

BSSMAPorDTAP_template::~BSSMAPorDTAP_template()
{
clean_up();
}

void BSSMAPorDTAP_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case BSSMAPorDTAP::ALT_bssmap:
delete single_value.field_bssmap;
break;
case BSSMAPorDTAP::ALT_dtap:
delete single_value.field_dtap;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

BSSMAPorDTAP_template& BSSMAPorDTAP_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

BSSMAPorDTAP_template& BSSMAPorDTAP_template::operator=(const BSSMAPorDTAP& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

BSSMAPorDTAP_template& BSSMAPorDTAP_template::operator=(const OPTIONAL<BSSMAPorDTAP>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const BSSMAPorDTAP&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @BSSAP_Types.BSSMAPorDTAP.");
}
return *this;
}

BSSMAPorDTAP_template& BSSMAPorDTAP_template::operator=(const BSSMAPorDTAP_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean BSSMAPorDTAP_template::match(const BSSMAPorDTAP& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
BSSMAPorDTAP::union_selection_type value_selection = other_value.get_selection();
if (value_selection == BSSMAPorDTAP::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case BSSMAPorDTAP::ALT_bssmap:
return single_value.field_bssmap->match(other_value.bssmap(), legacy);
case BSSMAPorDTAP::ALT_dtap:
return single_value.field_dtap->match(other_value.dtap(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @BSSAP_Types.BSSMAPorDTAP.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @BSSAP_Types.BSSMAPorDTAP.");
}
return FALSE;
}

boolean BSSMAPorDTAP_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case BSSMAPorDTAP::ALT_bssmap:
return single_value.field_bssmap->is_value();
case BSSMAPorDTAP::ALT_dtap:
return single_value.field_dtap->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @BSSAP_Types.BSSMAPorDTAP.");
}
}

BSSMAPorDTAP BSSMAPorDTAP_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @BSSAP_Types.BSSMAPorDTAP.");
BSSMAPorDTAP ret_val;
switch (single_value.union_selection) {
case BSSMAPorDTAP::ALT_bssmap:
ret_val.bssmap() = single_value.field_bssmap->valueof();
break;
case BSSMAPorDTAP::ALT_dtap:
ret_val.dtap() = single_value.field_dtap->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @BSSAP_Types.BSSMAPorDTAP.");
}
return ret_val;
}

BSSMAPorDTAP_template& BSSMAPorDTAP_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @BSSAP_Types.BSSMAPorDTAP.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @BSSAP_Types.BSSMAPorDTAP.");
return value_list.list_value[list_index];
}
void BSSMAPorDTAP_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @BSSAP_Types.BSSMAPorDTAP.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new BSSMAPorDTAP_template[list_length];
}

PDU__BSSMAP_template& BSSMAPorDTAP_template::bssmap()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAPorDTAP::ALT_bssmap) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_bssmap = new PDU__BSSMAP_template(ANY_VALUE);
else single_value.field_bssmap = new PDU__BSSMAP_template;
single_value.union_selection = BSSMAPorDTAP::ALT_bssmap;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_bssmap;
}

const PDU__BSSMAP_template& BSSMAPorDTAP_template::bssmap() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field bssmap in a non-specific template of union type @BSSAP_Types.BSSMAPorDTAP.");
if (single_value.union_selection != BSSMAPorDTAP::ALT_bssmap) TTCN_error("Accessing non-selected field bssmap in a template of union type @BSSAP_Types.BSSMAPorDTAP.");
return *single_value.field_bssmap;
}

OCTETSTRING_template& BSSMAPorDTAP_template::dtap()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != BSSMAPorDTAP::ALT_dtap) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_dtap = new OCTETSTRING_template(ANY_VALUE);
else single_value.field_dtap = new OCTETSTRING_template;
single_value.union_selection = BSSMAPorDTAP::ALT_dtap;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_dtap;
}

const OCTETSTRING_template& BSSMAPorDTAP_template::dtap() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field dtap in a non-specific template of union type @BSSAP_Types.BSSMAPorDTAP.");
if (single_value.union_selection != BSSMAPorDTAP::ALT_dtap) TTCN_error("Accessing non-selected field dtap in a template of union type @BSSAP_Types.BSSMAPorDTAP.");
return *single_value.field_dtap;
}

boolean BSSMAPorDTAP_template::ischosen(BSSMAPorDTAP::union_selection_type checked_selection) const
{
if (checked_selection == BSSMAPorDTAP::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @BSSAP_Types.BSSMAPorDTAP.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == BSSMAPorDTAP::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @BSSAP_Types.BSSMAPorDTAP.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @BSSAP_Types.BSSMAPorDTAP containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void BSSMAPorDTAP_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case BSSMAPorDTAP::ALT_bssmap:
TTCN_Logger::log_event_str("{ bssmap := ");
single_value.field_bssmap->log();
TTCN_Logger::log_event_str(" }");
break;
case BSSMAPorDTAP::ALT_dtap:
TTCN_Logger::log_event_str("{ dtap := ");
single_value.field_dtap->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void BSSMAPorDTAP_template::log_match(const BSSMAPorDTAP& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case BSSMAPorDTAP::ALT_bssmap:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".bssmap");
single_value.field_bssmap->log_match(match_value.bssmap(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ bssmap := ");
single_value.field_bssmap->log_match(match_value.bssmap(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case BSSMAPorDTAP::ALT_dtap:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".dtap");
single_value.field_dtap->log_match(match_value.dtap(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ dtap := ");
single_value.field_dtap->log_match(match_value.dtap(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void BSSMAPorDTAP_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case BSSMAPorDTAP::ALT_bssmap:
single_value.field_bssmap->set_implicit_omit(); break;
case BSSMAPorDTAP::ALT_dtap:
single_value.field_dtap->set_implicit_omit(); break;
default: break;
}
}

void BSSMAPorDTAP_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case BSSMAPorDTAP::ALT_bssmap:
single_value.field_bssmap->encode_text(text_buf);
break;
case BSSMAPorDTAP::ALT_dtap:
single_value.field_dtap->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @BSSAP_Types.BSSMAPorDTAP.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @BSSAP_Types.BSSMAPorDTAP.");
}
}

void BSSMAPorDTAP_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = BSSMAPorDTAP::UNBOUND_VALUE;
BSSMAPorDTAP::union_selection_type new_selection = (BSSMAPorDTAP::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case BSSMAPorDTAP::ALT_bssmap:
single_value.field_bssmap = new PDU__BSSMAP_template;
single_value.field_bssmap->decode_text(text_buf);
break;
case BSSMAPorDTAP::ALT_dtap:
single_value.field_dtap = new OCTETSTRING_template;
single_value.field_dtap->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @BSSAP_Types.BSSMAPorDTAP.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new BSSMAPorDTAP_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @BSSAP_Types.BSSMAPorDTAP.");
}
}

boolean BSSMAPorDTAP_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean BSSMAPorDTAP_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void BSSMAPorDTAP_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@BSSAP_Types.BSSMAPorDTAP'");
    }
    if (strcmp("bssmap", param_field) == 0) {
      bssmap().set_param(param);
      return;
    } else if (strcmp("dtap", param_field) == 0) {
      dtap().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@BSSAP_Types.BSSMAPorDTAP'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    BSSMAPorDTAP_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@BSSAP_Types.BSSMAPorDTAP");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "bssmap")) {
      bssmap().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "dtap")) {
      dtap().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @BSSAP_Types.BSSMAPorDTAP.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    BSSMAPorDTAP_template* precondition = new BSSMAPorDTAP_template;
    precondition->set_param(*m_p->get_elem(0));
    BSSMAPorDTAP_template* implied_template = new BSSMAPorDTAP_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = BSSMAPorDTAP_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@BSSAP_Types.BSSMAPorDTAP");
  }
  is_ifpresent = param.get_ifpresent();
}

void BSSMAPorDTAP_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case BSSMAPorDTAP::ALT_bssmap:
single_value.field_bssmap->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAPorDTAP");
return;
case BSSMAPorDTAP::ALT_dtap:
single_value.field_dtap->check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.BSSMAPorDTAP");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @BSSAP_Types.BSSMAPorDTAP.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.BSSMAPorDTAP");
}

PDU__BSSAP::PDU__BSSAP()
{
}

PDU__BSSAP::PDU__BSSAP(const BITSTRING& par_discriminator,
    const BITSTRING& par_spare,
    const OPTIONAL< OCTETSTRING >& par_dlci,
    const INTEGER& par_lengthIndicator,
    const BSSMAPorDTAP& par_pdu)
  :   field_discriminator(par_discriminator),
  field_spare(par_spare),
  field_dlci(par_dlci),
  field_lengthIndicator(par_lengthIndicator),
  field_pdu(par_pdu)
{
}

PDU__BSSAP::PDU__BSSAP(const PDU__BSSAP& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @BSSAP_Types.PDU_BSSAP.");
if (other_value.discriminator().is_bound()) field_discriminator = other_value.discriminator();
else field_discriminator.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.dlci().is_bound()) field_dlci = other_value.dlci();
else field_dlci.clean_up();
if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
else field_lengthIndicator.clean_up();
if (other_value.pdu().is_bound()) field_pdu = other_value.pdu();
else field_pdu.clean_up();
}

void PDU__BSSAP::clean_up()
{
field_discriminator.clean_up();
field_spare.clean_up();
field_dlci.clean_up();
field_lengthIndicator.clean_up();
field_pdu.clean_up();
}

const TTCN_Typedescriptor_t* PDU__BSSAP::get_descriptor() const { return &PDU__BSSAP_descr_; }
PDU__BSSAP& PDU__BSSAP::operator=(const PDU__BSSAP& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @BSSAP_Types.PDU_BSSAP.");
  if (other_value.discriminator().is_bound()) field_discriminator = other_value.discriminator();
  else field_discriminator.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.dlci().is_bound()) field_dlci = other_value.dlci();
  else field_dlci.clean_up();
  if (other_value.lengthIndicator().is_bound()) field_lengthIndicator = other_value.lengthIndicator();
  else field_lengthIndicator.clean_up();
  if (other_value.pdu().is_bound()) field_pdu = other_value.pdu();
  else field_pdu.clean_up();
}
return *this;
}

boolean PDU__BSSAP::operator==(const PDU__BSSAP& other_value) const
{
return field_discriminator==other_value.field_discriminator
  && field_spare==other_value.field_spare
  && field_dlci==other_value.field_dlci
  && field_lengthIndicator==other_value.field_lengthIndicator
  && field_pdu==other_value.field_pdu;
}

boolean PDU__BSSAP::is_bound() const
{
return (field_discriminator.is_bound())
  || (field_spare.is_bound())
  || (OPTIONAL_OMIT == field_dlci.get_selection() || field_dlci.is_bound())
  || (field_lengthIndicator.is_bound())
  || (field_pdu.is_bound());
}
boolean PDU__BSSAP::is_value() const
{
return field_discriminator.is_value()
  && field_spare.is_value()
  && (OPTIONAL_OMIT == field_dlci.get_selection() || field_dlci.is_value())
  && field_lengthIndicator.is_value()
  && field_pdu.is_value();
}
int PDU__BSSAP::size_of() const
{
  int ret_val = 4;
  if (field_dlci.ispresent()) ret_val++;
  return ret_val;
}

void PDU__BSSAP::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ discriminator := ");
field_discriminator.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", dlci := ");
field_dlci.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
field_lengthIndicator.log();
TTCN_Logger::log_event_str(", pdu := ");
field_pdu.log();
TTCN_Logger::log_event_str(" }");
}

void PDU__BSSAP::set_implicit_omit()
{
if (discriminator().is_bound()) discriminator().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (!dlci().is_bound()) dlci() = OMIT_VALUE;
else dlci().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (pdu().is_bound()) pdu().set_implicit_omit();
}

void PDU__BSSAP::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @BSSAP_Types.PDU_BSSAP has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) discriminator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) dlci().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) pdu().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "discriminator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          discriminator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dlci")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dlci().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdu")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdu().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSAP: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@BSSAP_Types.PDU_BSSAP");
  }
}

void PDU__BSSAP::encode_text(Text_Buf& text_buf) const
{
field_discriminator.encode_text(text_buf);
field_spare.encode_text(text_buf);
field_dlci.encode_text(text_buf);
field_lengthIndicator.encode_text(text_buf);
field_pdu.encode_text(text_buf);
}

void PDU__BSSAP::decode_text(Text_Buf& text_buf)
{
field_discriminator.decode_text(text_buf);
field_spare.decode_text(text_buf);
field_dlci.decode_text(text_buf);
field_lengthIndicator.decode_text(text_buf);
field_pdu.decode_text(text_buf);
}

void PDU__BSSAP::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDU__BSSAP::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PDU__BSSAP::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  int selected_field = -1;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field3 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, General__Types::BIT1_descr_.raw->forceomit);
  decoded_field_length = field_discriminator.RAW_decode(General__Types::BIT1_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, General__Types::BIT7_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(General__Types::BIT7_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0 && field_discriminator ==  bs_9){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_dlci = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, PDU__BSSAP_dlci_descr_.raw->forceomit);
  decoded_field_length = field_dlci().RAW_decode(PDU__BSSAP_dlci_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_dlci = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_dlci=OMIT_VALUE;
  RAW_Force_Omit field_3_force_omit(3, force_omit, PDU__BSSAP_lengthIndicator_descr_.raw->forceomit);
  decoded_field_length = field_lengthIndicator.RAW_decode(PDU__BSSAP_lengthIndicator_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp3 = field_lengthIndicator.convert_to_Integer(PDU__BSSAP_lengthIndicator_descr_);
  field_lengthIndicator = tmp3;
  value_of_length_field3 += tmp3.get_long_long_val() * 8;
  if (field_discriminator ==  bs_14) selected_field = 0;
  else if (field_discriminator ==  bs_9) selected_field = 1;
  else selected_field = -1;
  RAW_Force_Omit field_4_force_omit(4, force_omit, PDU__BSSAP_pdu_descr_.raw->forceomit);
  decoded_field_length = field_pdu.RAW_decode(PDU__BSSAP_pdu_descr_, p_buf, min_of_ints(2, limit, value_of_length_field3), local_top_order, no_err, selected_field, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field3 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int PDU__BSSAP::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, General__Types::BIT1_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, General__Types::BIT7_descr_.raw);
  if (field_dlci.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, PDU__BSSAP_dlci_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, PDU__BSSAP_lengthIndicator_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, PDU__BSSAP_pdu_descr_.raw);
  encoded_length += field_discriminator.RAW_encode(General__Types::BIT1_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_spare.RAW_encode(General__Types::BIT7_descr_, *myleaf.body.node.nodes[1]);
  if (field_dlci.ispresent()) {
  encoded_length += field_dlci().RAW_encode(PDU__BSSAP_dlci_descr_, *myleaf.body.node.nodes[2]);
  }
  encoded_length += 8;
  myleaf.body.node.nodes[3]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[3]->coding_descr = &PDU__BSSAP_lengthIndicator_descr_;
  myleaf.body.node.nodes[3]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[3]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[3]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[3]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[3]->length = 8;
  myleaf.body.node.nodes[3]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[3]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  encoded_length += field_pdu.RAW_encode(PDU__BSSAP_pdu_descr_, *myleaf.body.node.nodes[4]);
  if (field_dlci.ispresent() && (field_discriminator !=  bs_9)) {
  RAW_enc_tree* temp_leaf;
  {
  RAW_enc_tr_pos pr_pos0;
  pr_pos0.level=myleaf.curr_pos.level+1;
  int new_pos0[]={0};
  pr_pos0.pos=init_new_tree_pos(myleaf.curr_pos,1,new_pos0);
  temp_leaf = myleaf.get_node(pr_pos0);
  if(temp_leaf != NULL){
   bs_9.RAW_encode(General__Types::BIT1_descr_,*temp_leaf);
  } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  }
  free_tree_pos(pr_pos0.pos);
  }
  }
  switch (field_pdu.get_selection()) {
  case BSSMAPorDTAP::ALT_bssmap:
  if (field_discriminator !=  bs_14) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_14.RAW_encode(General__Types::BIT1_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  case BSSMAPorDTAP::ALT_dtap:
  if (field_discriminator !=  bs_9) {
  RAW_enc_tr_pos pr_pos;
  pr_pos.level = myleaf.curr_pos.level + 1;
  int new_pos[] = { 0 };
  pr_pos.pos = init_new_tree_pos(myleaf.curr_pos, 1, new_pos);
  RAW_enc_tree* temp_leaf = myleaf.get_node(pr_pos);
  if (temp_leaf != NULL)
     bs_9.RAW_encode(General__Types::BIT1_descr_,*temp_leaf);
  else
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_OMITTED_TAG, "Encoding a tagged, but omitted value.");
  free_tree_pos(pr_pos.pos);
  }
  break;
  default:;
  }
  return myleaf.length = encoded_length;
}

struct PDU__BSSAP_template::single_value_struct {
BITSTRING_template field_discriminator;
BITSTRING_template field_spare;
OCTETSTRING_template field_dlci;
INTEGER_template field_lengthIndicator;
BSSMAPorDTAP_template field_pdu;
};

void PDU__BSSAP_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_discriminator = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
single_value->field_dlci = ANY_OR_OMIT;
single_value->field_lengthIndicator = ANY_VALUE;
single_value->field_pdu = ANY_VALUE;
}
}
}

void PDU__BSSAP_template::copy_value(const PDU__BSSAP& other_value)
{
single_value = new single_value_struct;
if (other_value.discriminator().is_bound()) {
  single_value->field_discriminator = other_value.discriminator();
} else {
  single_value->field_discriminator.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.dlci().is_bound()) {
  if (other_value.dlci().ispresent()) single_value->field_dlci = other_value.dlci()();
  else single_value->field_dlci = OMIT_VALUE;
} else {
  single_value->field_dlci.clean_up();
}
if (other_value.lengthIndicator().is_bound()) {
  single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
  single_value->field_lengthIndicator.clean_up();
}
if (other_value.pdu().is_bound()) {
  single_value->field_pdu = other_value.pdu();
} else {
  single_value->field_pdu.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDU__BSSAP_template::copy_template(const PDU__BSSAP_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.discriminator().get_selection()) {
single_value->field_discriminator = other_value.discriminator();
} else {
single_value->field_discriminator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.dlci().get_selection()) {
single_value->field_dlci = other_value.dlci();
} else {
single_value->field_dlci.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lengthIndicator().get_selection()) {
single_value->field_lengthIndicator = other_value.lengthIndicator();
} else {
single_value->field_lengthIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pdu().get_selection()) {
single_value->field_pdu = other_value.pdu();
} else {
single_value->field_pdu.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDU__BSSAP_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDU__BSSAP_template(*other_value.implication_.precondition);
implication_.implied_template = new PDU__BSSAP_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSAP.");
break;
}
set_selection(other_value);
}

PDU__BSSAP_template::PDU__BSSAP_template()
{
}

PDU__BSSAP_template::PDU__BSSAP_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDU__BSSAP_template::PDU__BSSAP_template(const PDU__BSSAP& other_value)
{
copy_value(other_value);
}

PDU__BSSAP_template::PDU__BSSAP_template(const OPTIONAL<PDU__BSSAP>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSAP&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @BSSAP_Types.PDU_BSSAP from an unbound optional field.");
}
}

PDU__BSSAP_template::PDU__BSSAP_template(PDU__BSSAP_template* p_precondition, PDU__BSSAP_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDU__BSSAP_template::PDU__BSSAP_template(Dynamic_Match_Interface<PDU__BSSAP>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDU__BSSAP>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDU__BSSAP_template::PDU__BSSAP_template(const PDU__BSSAP_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDU__BSSAP_template::~PDU__BSSAP_template()
{
clean_up();
}

PDU__BSSAP_template& PDU__BSSAP_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDU__BSSAP_template& PDU__BSSAP_template::operator=(const PDU__BSSAP& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDU__BSSAP_template& PDU__BSSAP_template::operator=(const OPTIONAL<PDU__BSSAP>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDU__BSSAP&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @BSSAP_Types.PDU_BSSAP.");
}
return *this;
}

PDU__BSSAP_template& PDU__BSSAP_template::operator=(const PDU__BSSAP_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDU__BSSAP_template::match(const PDU__BSSAP& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.discriminator().is_bound()) return FALSE;
if(!single_value->field_discriminator.match(other_value.discriminator(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.dlci().is_bound()) return FALSE;
if((other_value.dlci().ispresent() ? !single_value->field_dlci.match((const OCTETSTRING&)other_value.dlci(), legacy) : !single_value->field_dlci.match_omit(legacy)))return FALSE;
if(!other_value.lengthIndicator().is_bound()) return FALSE;
if(!single_value->field_lengthIndicator.match(other_value.lengthIndicator(), legacy))return FALSE;
if(!other_value.pdu().is_bound()) return FALSE;
if(!single_value->field_pdu.match(other_value.pdu(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSAP.");
}
return FALSE;
}

boolean PDU__BSSAP_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_discriminator.is_bound()
 || single_value->field_spare.is_bound()
 || (single_value->field_dlci.is_omit() || single_value->field_dlci.is_bound())
 || single_value->field_lengthIndicator.is_bound()
 || single_value->field_pdu.is_bound();
}

boolean PDU__BSSAP_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_discriminator.is_value()
 && single_value->field_spare.is_value()
 && (single_value->field_dlci.is_omit() || single_value->field_dlci.is_value())
 && single_value->field_lengthIndicator.is_value()
 && single_value->field_pdu.is_value();
}

void PDU__BSSAP_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDU__BSSAP PDU__BSSAP_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @BSSAP_Types.PDU_BSSAP.");
PDU__BSSAP ret_val;
if (single_value->field_discriminator.is_bound()) {
ret_val.discriminator() = single_value->field_discriminator.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_dlci.is_omit()) ret_val.dlci() = OMIT_VALUE;
else if (single_value->field_dlci.is_bound()) {
ret_val.dlci() = single_value->field_dlci.valueof();
}
if (single_value->field_lengthIndicator.is_bound()) {
ret_val.lengthIndicator() = single_value->field_lengthIndicator.valueof();
}
if (single_value->field_pdu.is_bound()) {
ret_val.pdu() = single_value->field_pdu.valueof();
}
return ret_val;
}

void PDU__BSSAP_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @BSSAP_Types.PDU_BSSAP.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDU__BSSAP_template[list_length];
}

PDU__BSSAP_template& PDU__BSSAP_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @BSSAP_Types.PDU_BSSAP.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @BSSAP_Types.PDU_BSSAP.");
return value_list.list_value[list_index];
}

BITSTRING_template& PDU__BSSAP_template::discriminator()
{
set_specific();
return single_value->field_discriminator;
}

const BITSTRING_template& PDU__BSSAP_template::discriminator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field discriminator of a non-specific template of type @BSSAP_Types.PDU_BSSAP.");
return single_value->field_discriminator;
}

BITSTRING_template& PDU__BSSAP_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& PDU__BSSAP_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @BSSAP_Types.PDU_BSSAP.");
return single_value->field_spare;
}

OCTETSTRING_template& PDU__BSSAP_template::dlci()
{
set_specific();
return single_value->field_dlci;
}

const OCTETSTRING_template& PDU__BSSAP_template::dlci() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field dlci of a non-specific template of type @BSSAP_Types.PDU_BSSAP.");
return single_value->field_dlci;
}

INTEGER_template& PDU__BSSAP_template::lengthIndicator()
{
set_specific();
return single_value->field_lengthIndicator;
}

const INTEGER_template& PDU__BSSAP_template::lengthIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lengthIndicator of a non-specific template of type @BSSAP_Types.PDU_BSSAP.");
return single_value->field_lengthIndicator;
}

BSSMAPorDTAP_template& PDU__BSSAP_template::pdu()
{
set_specific();
return single_value->field_pdu;
}

const BSSMAPorDTAP_template& PDU__BSSAP_template::pdu() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pdu of a non-specific template of type @BSSAP_Types.PDU_BSSAP.");
return single_value->field_pdu;
}

int PDU__BSSAP_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSAP which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 4;
      if (single_value->field_dlci.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSAP containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSAP containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSAP containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSAP containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSAP containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSAP containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSAP containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @BSSAP_Types.PDU_BSSAP containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSAP.");
  }
  return 0;
}

void PDU__BSSAP_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ discriminator := ");
single_value->field_discriminator.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", dlci := ");
single_value->field_dlci.log();
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log();
TTCN_Logger::log_event_str(", pdu := ");
single_value->field_pdu.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDU__BSSAP_template::log_match(const PDU__BSSAP& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_discriminator.match(match_value.discriminator(), legacy)){
TTCN_Logger::log_logmatch_info(".discriminator");
single_value->field_discriminator.log_match(match_value.discriminator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.dlci().ispresent()){
if(!single_value->field_dlci.match(match_value.dlci(), legacy)){
TTCN_Logger::log_logmatch_info(".dlci");
single_value->field_dlci.log_match(match_value.dlci(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_dlci.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".dlci := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_dlci.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_lengthIndicator.match(match_value.lengthIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".lengthIndicator");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_pdu.match(match_value.pdu(), legacy)){
TTCN_Logger::log_logmatch_info(".pdu");
single_value->field_pdu.log_match(match_value.pdu(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ discriminator := ");
single_value->field_discriminator.log_match(match_value.discriminator(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", dlci := ");
if (match_value.dlci().ispresent()) {
single_value->field_dlci.log_match(match_value.dlci(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_dlci.log();
if (single_value->field_dlci.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", lengthIndicator := ");
single_value->field_lengthIndicator.log_match(match_value.lengthIndicator(), legacy);
TTCN_Logger::log_event_str(", pdu := ");
single_value->field_pdu.log_match(match_value.pdu(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDU__BSSAP_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (discriminator().is_bound()) discriminator().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (!dlci().is_bound()) dlci() = OMIT_VALUE;
else dlci().set_implicit_omit();
if (lengthIndicator().is_bound()) lengthIndicator().set_implicit_omit();
if (pdu().is_bound()) pdu().set_implicit_omit();
}

void PDU__BSSAP_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_discriminator.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
single_value->field_dlci.encode_text(text_buf);
single_value->field_lengthIndicator.encode_text(text_buf);
single_value->field_pdu.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @BSSAP_Types.PDU_BSSAP.");
}
}

void PDU__BSSAP_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_discriminator.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
single_value->field_dlci.decode_text(text_buf);
single_value->field_lengthIndicator.decode_text(text_buf);
single_value->field_pdu.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDU__BSSAP_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @BSSAP_Types.PDU_BSSAP.");
}
}

void PDU__BSSAP_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDU__BSSAP_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @BSSAP_Types.PDU_BSSAP has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) discriminator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) dlci().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) lengthIndicator().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) pdu().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "discriminator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          discriminator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dlci")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dlci().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lengthIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lengthIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdu")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdu().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @BSSAP_Types.PDU_BSSAP: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDU__BSSAP_template* precondition = new PDU__BSSAP_template;
    precondition->set_param(*param.get_elem(0));
    PDU__BSSAP_template* implied_template = new PDU__BSSAP_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDU__BSSAP_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@BSSAP_Types.PDU_BSSAP");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDU__BSSAP_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_discriminator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSAP");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSAP");
single_value->field_dlci.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSAP");
single_value->field_lengthIndicator.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSAP");
single_value->field_pdu.check_restriction(t_res, t_name ? t_name : "@BSSAP_Types.PDU_BSSAP");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@BSSAP_Types.PDU_BSSAP");
}

boolean PDU__BSSAP_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDU__BSSAP_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case 