// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "CBSP_Types.hh"

namespace CBSP__Types {

/* Bodies of functions, altsteps and testcases */

void CBSP__PDU_msg__type_encoder(const CBSP__MessageType& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@CBSP_Types.CBSP_MessageType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CBSP__PDU_msg__type_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CBSP__PDU_msg__type_decoder(OCTETSTRING& input_stream, CBSP__MessageType& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@CBSP_Types.CBSP_MessageType' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CBSP__PDU_msg__type_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CBSP__PDU_len_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CBSP__PDU_len_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CBSP__PDU_len_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CBSP__PDU_len_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CBSP__PDU_ies_encoder(const CBSP__IEs& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@CBSP_Types.CBSP_IEs' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CBSP__PDU_ies_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CBSP__PDU_ies_decoder(OCTETSTRING& input_stream, CBSP__IEs& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@CBSP_Types.CBSP_IEs' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CBSP__PDU_ies_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CBSP__PDU_encoder(const CBSP__PDU& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@CBSP_Types.CBSP_PDU' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CBSP__PDU_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CBSP__PDU_decoder(OCTETSTRING& input_stream, CBSP__PDU& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_RAW) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@CBSP_Types.CBSP_PDU' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CBSP__PDU_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

OCTETSTRING enc__CBSP__PDU(const CBSP__PDU& msg)
{
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("enc_CBSP_PDU(): Encoding @CBSP_Types.CBSP_PDU: ");
msg.log();
TTCN_Logger::end_event();
}
TTCN_EncDec::set_error_behavior(TTCN_EncDec::ET_ALL, TTCN_EncDec::EB_DEFAULT);
TTCN_Buffer ttcn_buffer;
msg.encode(CBSP__PDU_descr_, ttcn_buffer, TTCN_EncDec::CT_RAW, 0);
OCTETSTRING ret_val;
ttcn_buffer.get_string(ret_val);
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("enc_CBSP_PDU(): Stream after encoding: ");
ret_val.log();
TTCN_Logger::end_event();
}
return ret_val;
}

CBSP__PDU dec__CBSP__PDU(const OCTETSTRING& msg)
{
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("dec_CBSP_PDU(): Stream before decoding: ");
msg.log();
TTCN_Logger::end_event();
}
TTCN_EncDec::set_error_behavior(TTCN_EncDec::ET_ALL, TTCN_EncDec::EB_DEFAULT);
TTCN_EncDec::clear_error();
TTCN_Buffer ttcn_buffer(msg);
CBSP__PDU ret_val;
ret_val.decode(CBSP__PDU_descr_, ttcn_buffer, TTCN_EncDec::CT_RAW);
if (TTCN_Logger::log_this_event(TTCN_Logger::DEBUG_ENCDEC)) {
TTCN_Logger::begin_event(TTCN_Logger::DEBUG_ENCDEC);
TTCN_Logger::log_event_str("dec_CBSP_PDU(): Decoded @CBSP_Types.CBSP_PDU: ");
ret_val.log();
TTCN_Logger::end_event();
}
if (TTCN_EncDec::get_last_error_type() == TTCN_EncDec::ET_NONE) {
if (ttcn_buffer.get_pos() < ttcn_buffer.get_len()) {
ttcn_buffer.cut();
OCTETSTRING tmp_os;
ttcn_buffer.get_string(tmp_os);
TTCN_Logger::begin_event_log2str();
tmp_os.log();
CHARSTRING remaining_stream = TTCN_Logger::end_event_log2str();
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_EXTRA_DATA, "dec_CBSP_PDU(): Data remained at the end of the stream after successful decoding: %s", (const char*) remaining_stream);
}
}
return ret_val;
}

INTEGER f__cbsp__period2s(const INTEGER& period)
{
TTCN_Location current_location("CBSP_Types.ttcn", 382, TTCN_Location::LOCATION_FUNCTION, "f_cbsp_period2s");
current_location.update_lineno(384);
/* CBSP_Types.ttcn, line 384 */
if ((period == 0)) {
current_location.update_lineno(385);
/* CBSP_Types.ttcn, line 385 */
return -1;
}
else {
current_location.update_lineno(386);
/* CBSP_Types.ttcn, line 386 */
if ((period <= 10)) {
current_location.update_lineno(387);
/* CBSP_Types.ttcn, line 387 */
return period;
}
else {
current_location.update_lineno(388);
/* CBSP_Types.ttcn, line 388 */
if ((period <= 20)) {
current_location.update_lineno(389);
/* CBSP_Types.ttcn, line 389 */
return (10 + ((period - 10) * 2));
}
else {
current_location.update_lineno(390);
/* CBSP_Types.ttcn, line 390 */
if ((period <= 38)) {
current_location.update_lineno(391);
/* CBSP_Types.ttcn, line 391 */
return (30 + ((period - 20) * 5));
}
else {
current_location.update_lineno(392);
/* CBSP_Types.ttcn, line 392 */
if ((period <= 86)) {
current_location.update_lineno(393);
/* CBSP_Types.ttcn, line 393 */
return (120 + ((period - 38) * 10));
}
else {
current_location.update_lineno(394);
/* CBSP_Types.ttcn, line 394 */
if ((period <= 186)) {
current_location.update_lineno(395);
/* CBSP_Types.ttcn, line 395 */
return (600 + ((period - 86) * 30));
}
else {
current_location.update_lineno(397);
/* CBSP_Types.ttcn, line 397 */
return 0;
}
}
}
}
}
}
}


/* Bodies of static functions */

void pre_init_module()
{
TTCN_Location current_location("CBSP_Types.ttcn", 0, TTCN_Location::LOCATION_UNKNOWN, "CBSP_Types");
Osmocom__Types::module_object.pre_init_module();
BSSAP__Types::module_object.pre_init_module();
module_object.add_function("enc_CBSP_PDU", (genericfunc_t)&enc__CBSP__PDU, NULL);
module_object.add_function("dec_CBSP_PDU", (genericfunc_t)&dec__CBSP__PDU, NULL);
module_object.add_function("f_cbsp_period2s", (genericfunc_t)&f__cbsp__period2s, NULL);
}

void post_init_module()
{
TTCN_Location current_location("CBSP_Types.ttcn", 0, TTCN_Location::LOCATION_UNKNOWN, "CBSP_Types");
Osmocom__Types::module_object.post_init_module();
BSSAP__Types::module_object.post_init_module();
}


} /* end of namespace */
