// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "RSL_Types.hh"

namespace RSL__Types {

/* Member functions of C++ classes */

RSL__IE__GroupChannelDescription::RSL__IE__GroupChannelDescription()
{
}

RSL__IE__GroupChannelDescription::RSL__IE__GroupChannelDescription(const INTEGER& par_len,
    const OCTETSTRING& par_chan__desc)
  :   field_len(par_len),
  field_chan__desc(par_chan__desc)
{
}

RSL__IE__GroupChannelDescription::RSL__IE__GroupChannelDescription(const RSL__IE__GroupChannelDescription& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_GroupChannelDescription.");
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.chan__desc().is_bound()) field_chan__desc = other_value.chan__desc();
else field_chan__desc.clean_up();
}

void RSL__IE__GroupChannelDescription::clean_up()
{
field_len.clean_up();
field_chan__desc.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__GroupChannelDescription::get_descriptor() const { return &RSL__IE__GroupChannelDescription_descr_; }
RSL__IE__GroupChannelDescription& RSL__IE__GroupChannelDescription::operator=(const RSL__IE__GroupChannelDescription& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_GroupChannelDescription.");
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.chan__desc().is_bound()) field_chan__desc = other_value.chan__desc();
  else field_chan__desc.clean_up();
}
return *this;
}

boolean RSL__IE__GroupChannelDescription::operator==(const RSL__IE__GroupChannelDescription& other_value) const
{
return field_len==other_value.field_len
  && field_chan__desc==other_value.field_chan__desc;
}

boolean RSL__IE__GroupChannelDescription::is_bound() const
{
return (field_len.is_bound())
  || (field_chan__desc.is_bound());
}
boolean RSL__IE__GroupChannelDescription::is_value() const
{
return field_len.is_value()
  && field_chan__desc.is_value();
}
void RSL__IE__GroupChannelDescription::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len := ");
field_len.log();
TTCN_Logger::log_event_str(", chan_desc := ");
field_chan__desc.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__GroupChannelDescription::set_implicit_omit()
{
if (len().is_bound()) len().set_implicit_omit();
if (chan__desc().is_bound()) chan__desc().set_implicit_omit();
}

void RSL__IE__GroupChannelDescription::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_GroupChannelDescription has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) chan__desc().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "chan_desc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          chan__desc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_GroupChannelDescription: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_GroupChannelDescription");
  }
}

void RSL__IE__GroupChannelDescription::encode_text(Text_Buf& text_buf) const
{
field_len.encode_text(text_buf);
field_chan__desc.encode_text(text_buf);
}

void RSL__IE__GroupChannelDescription::decode_text(Text_Buf& text_buf)
{
field_len.decode_text(text_buf);
field_chan__desc.decode_text(text_buf);
}

void RSL__IE__GroupChannelDescription::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__GroupChannelDescription::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__GroupChannelDescription::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__GroupChannelDescription_len_descr_.raw->forceomit);
  decoded_field_length = field_len.RAW_decode(RSL__IE__GroupChannelDescription_len_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_len.convert_to_Integer(RSL__IE__GroupChannelDescription_len_descr_);
  field_len = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__GroupChannelDescription_chan__desc_descr_.raw->forceomit);
  decoded_field_length = field_chan__desc.RAW_decode(RSL__IE__GroupChannelDescription_chan__desc_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__GroupChannelDescription::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__GroupChannelDescription_len_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__GroupChannelDescription_chan__desc_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &RSL__IE__GroupChannelDescription_len_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  encoded_length += field_chan__desc.RAW_encode(RSL__IE__GroupChannelDescription_chan__desc_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__GroupChannelDescription_template::single_value_struct {
INTEGER_template field_len;
OCTETSTRING_template field_chan__desc;
};

void RSL__IE__GroupChannelDescription_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_len = ANY_VALUE;
single_value->field_chan__desc = ANY_VALUE;
}
}
}

void RSL__IE__GroupChannelDescription_template::copy_value(const RSL__IE__GroupChannelDescription& other_value)
{
single_value = new single_value_struct;
if (other_value.len().is_bound()) {
  single_value->field_len = other_value.len();
} else {
  single_value->field_len.clean_up();
}
if (other_value.chan__desc().is_bound()) {
  single_value->field_chan__desc = other_value.chan__desc();
} else {
  single_value->field_chan__desc.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__GroupChannelDescription_template::copy_template(const RSL__IE__GroupChannelDescription_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.len().get_selection()) {
single_value->field_len = other_value.len();
} else {
single_value->field_len.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.chan__desc().get_selection()) {
single_value->field_chan__desc = other_value.chan__desc();
} else {
single_value->field_chan__desc.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__GroupChannelDescription_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__GroupChannelDescription_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__GroupChannelDescription_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
break;
}
set_selection(other_value);
}

RSL__IE__GroupChannelDescription_template::RSL__IE__GroupChannelDescription_template()
{
}

RSL__IE__GroupChannelDescription_template::RSL__IE__GroupChannelDescription_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__GroupChannelDescription_template::RSL__IE__GroupChannelDescription_template(const RSL__IE__GroupChannelDescription& other_value)
{
copy_value(other_value);
}

RSL__IE__GroupChannelDescription_template::RSL__IE__GroupChannelDescription_template(const OPTIONAL<RSL__IE__GroupChannelDescription>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__GroupChannelDescription&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_GroupChannelDescription from an unbound optional field.");
}
}

RSL__IE__GroupChannelDescription_template::RSL__IE__GroupChannelDescription_template(RSL__IE__GroupChannelDescription_template* p_precondition, RSL__IE__GroupChannelDescription_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__GroupChannelDescription_template::RSL__IE__GroupChannelDescription_template(Dynamic_Match_Interface<RSL__IE__GroupChannelDescription>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__GroupChannelDescription>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__GroupChannelDescription_template::RSL__IE__GroupChannelDescription_template(const RSL__IE__GroupChannelDescription_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__GroupChannelDescription_template::~RSL__IE__GroupChannelDescription_template()
{
clean_up();
}

RSL__IE__GroupChannelDescription_template& RSL__IE__GroupChannelDescription_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__GroupChannelDescription_template& RSL__IE__GroupChannelDescription_template::operator=(const RSL__IE__GroupChannelDescription& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__GroupChannelDescription_template& RSL__IE__GroupChannelDescription_template::operator=(const OPTIONAL<RSL__IE__GroupChannelDescription>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__GroupChannelDescription&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
}
return *this;
}

RSL__IE__GroupChannelDescription_template& RSL__IE__GroupChannelDescription_template::operator=(const RSL__IE__GroupChannelDescription_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__GroupChannelDescription_template::match(const RSL__IE__GroupChannelDescription& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.len().is_bound()) return FALSE;
if(!single_value->field_len.match(other_value.len(), legacy))return FALSE;
if(!other_value.chan__desc().is_bound()) return FALSE;
if(!single_value->field_chan__desc.match(other_value.chan__desc(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
}
return FALSE;
}

boolean RSL__IE__GroupChannelDescription_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_len.is_bound()
 || single_value->field_chan__desc.is_bound();
}

boolean RSL__IE__GroupChannelDescription_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_len.is_value()
 && single_value->field_chan__desc.is_value();
}

void RSL__IE__GroupChannelDescription_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__GroupChannelDescription RSL__IE__GroupChannelDescription_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
RSL__IE__GroupChannelDescription ret_val;
if (single_value->field_len.is_bound()) {
ret_val.len() = single_value->field_len.valueof();
}
if (single_value->field_chan__desc.is_bound()) {
ret_val.chan__desc() = single_value->field_chan__desc.valueof();
}
return ret_val;
}

void RSL__IE__GroupChannelDescription_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__GroupChannelDescription_template[list_length];
}

RSL__IE__GroupChannelDescription_template& RSL__IE__GroupChannelDescription_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__GroupChannelDescription_template::len()
{
set_specific();
return single_value->field_len;
}

const INTEGER_template& RSL__IE__GroupChannelDescription_template::len() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len of a non-specific template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
return single_value->field_len;
}

OCTETSTRING_template& RSL__IE__GroupChannelDescription_template::chan__desc()
{
set_specific();
return single_value->field_chan__desc;
}

const OCTETSTRING_template& RSL__IE__GroupChannelDescription_template::chan__desc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field chan_desc of a non-specific template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
return single_value->field_chan__desc;
}

int RSL__IE__GroupChannelDescription_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupChannelDescription which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupChannelDescription containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupChannelDescription containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupChannelDescription containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupChannelDescription containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupChannelDescription containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupChannelDescription containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupChannelDescription containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_GroupChannelDescription containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
  }
  return 0;
}

void RSL__IE__GroupChannelDescription_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log();
TTCN_Logger::log_event_str(", chan_desc := ");
single_value->field_chan__desc.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__GroupChannelDescription_template::log_match(const RSL__IE__GroupChannelDescription& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_len.match(match_value.len(), legacy)){
TTCN_Logger::log_logmatch_info(".len");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_chan__desc.match(match_value.chan__desc(), legacy)){
TTCN_Logger::log_logmatch_info(".chan_desc");
single_value->field_chan__desc.log_match(match_value.chan__desc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::log_event_str(", chan_desc := ");
single_value->field_chan__desc.log_match(match_value.chan__desc(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__GroupChannelDescription_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (len().is_bound()) len().set_implicit_omit();
if (chan__desc().is_bound()) chan__desc().set_implicit_omit();
}

void RSL__IE__GroupChannelDescription_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_len.encode_text(text_buf);
single_value->field_chan__desc.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
}
}

void RSL__IE__GroupChannelDescription_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_len.decode_text(text_buf);
single_value->field_chan__desc.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__GroupChannelDescription_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_GroupChannelDescription.");
}
}

void RSL__IE__GroupChannelDescription_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__GroupChannelDescription_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_GroupChannelDescription has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) chan__desc().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "chan_desc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          chan__desc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_GroupChannelDescription: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__GroupChannelDescription_template* precondition = new RSL__IE__GroupChannelDescription_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__GroupChannelDescription_template* implied_template = new RSL__IE__GroupChannelDescription_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__GroupChannelDescription_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_GroupChannelDescription");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__GroupChannelDescription_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_len.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_GroupChannelDescription");
single_value->field_chan__desc.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_GroupChannelDescription");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_GroupChannelDescription");
}

boolean RSL__IE__GroupChannelDescription_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__GroupChannelDescription_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IE__NchDrxInformation::RSL__IE__NchDrxInformation()
{
}

RSL__IE__NchDrxInformation::RSL__IE__NchDrxInformation(const INTEGER& par_len,
    const BITSTRING& par_spare,
    const BITSTRING& par_nln__status,
    const BITSTRING& par_emlpp__priority,
    const BITSTRING& par_nln)
  :   field_len(par_len),
  field_spare(par_spare),
  field_nln__status(par_nln__status),
  field_emlpp__priority(par_emlpp__priority),
  field_nln(par_nln)
{
}

RSL__IE__NchDrxInformation::RSL__IE__NchDrxInformation(const RSL__IE__NchDrxInformation& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_NchDrxInformation.");
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.nln__status().is_bound()) field_nln__status = other_value.nln__status();
else field_nln__status.clean_up();
if (other_value.emlpp__priority().is_bound()) field_emlpp__priority = other_value.emlpp__priority();
else field_emlpp__priority.clean_up();
if (other_value.nln().is_bound()) field_nln = other_value.nln();
else field_nln.clean_up();
}

void RSL__IE__NchDrxInformation::clean_up()
{
field_len.clean_up();
field_spare.clean_up();
field_nln__status.clean_up();
field_emlpp__priority.clean_up();
field_nln.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__NchDrxInformation::get_descriptor() const { return &RSL__IE__NchDrxInformation_descr_; }
RSL__IE__NchDrxInformation& RSL__IE__NchDrxInformation::operator=(const RSL__IE__NchDrxInformation& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_NchDrxInformation.");
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.nln__status().is_bound()) field_nln__status = other_value.nln__status();
  else field_nln__status.clean_up();
  if (other_value.emlpp__priority().is_bound()) field_emlpp__priority = other_value.emlpp__priority();
  else field_emlpp__priority.clean_up();
  if (other_value.nln().is_bound()) field_nln = other_value.nln();
  else field_nln.clean_up();
}
return *this;
}

boolean RSL__IE__NchDrxInformation::operator==(const RSL__IE__NchDrxInformation& other_value) const
{
return field_len==other_value.field_len
  && field_spare==other_value.field_spare
  && field_nln__status==other_value.field_nln__status
  && field_emlpp__priority==other_value.field_emlpp__priority
  && field_nln==other_value.field_nln;
}

boolean RSL__IE__NchDrxInformation::is_bound() const
{
return (field_len.is_bound())
  || (field_spare.is_bound())
  || (field_nln__status.is_bound())
  || (field_emlpp__priority.is_bound())
  || (field_nln.is_bound());
}
boolean RSL__IE__NchDrxInformation::is_value() const
{
return field_len.is_value()
  && field_spare.is_value()
  && field_nln__status.is_value()
  && field_emlpp__priority.is_value()
  && field_nln.is_value();
}
void RSL__IE__NchDrxInformation::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len := ");
field_len.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", nln_status := ");
field_nln__status.log();
TTCN_Logger::log_event_str(", emlpp_priority := ");
field_emlpp__priority.log();
TTCN_Logger::log_event_str(", nln := ");
field_nln.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__NchDrxInformation::set_implicit_omit()
{
if (len().is_bound()) len().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (nln__status().is_bound()) nln__status().set_implicit_omit();
if (emlpp__priority().is_bound()) emlpp__priority().set_implicit_omit();
if (nln().is_bound()) nln().set_implicit_omit();
}

void RSL__IE__NchDrxInformation::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_NchDrxInformation has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) nln__status().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) emlpp__priority().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) nln().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nln_status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nln__status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "emlpp_priority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          emlpp__priority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nln")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nln().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_NchDrxInformation: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_NchDrxInformation");
  }
}

void RSL__IE__NchDrxInformation::encode_text(Text_Buf& text_buf) const
{
field_len.encode_text(text_buf);
field_spare.encode_text(text_buf);
field_nln__status.encode_text(text_buf);
field_emlpp__priority.encode_text(text_buf);
field_nln.encode_text(text_buf);
}

void RSL__IE__NchDrxInformation::decode_text(Text_Buf& text_buf)
{
field_len.decode_text(text_buf);
field_spare.decode_text(text_buf);
field_nln__status.decode_text(text_buf);
field_emlpp__priority.decode_text(text_buf);
field_nln.decode_text(text_buf);
}

void RSL__IE__NchDrxInformation::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__NchDrxInformation::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__NchDrxInformation::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__NchDrxInformation_len_descr_.raw->forceomit);
  decoded_field_length = field_len.RAW_decode(RSL__IE__NchDrxInformation_len_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_len.convert_to_Integer(RSL__IE__NchDrxInformation_len_descr_);
  field_len = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__NchDrxInformation_spare_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(RSL__IE__NchDrxInformation_spare_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RSL__IE__NchDrxInformation_nln__status_descr_.raw->forceomit);
  decoded_field_length = field_nln__status.RAW_decode(RSL__IE__NchDrxInformation_nln__status_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, RSL__IE__NchDrxInformation_emlpp__priority_descr_.raw->forceomit);
  decoded_field_length = field_emlpp__priority.RAW_decode(RSL__IE__NchDrxInformation_emlpp__priority_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, RSL__IE__NchDrxInformation_nln_descr_.raw->forceomit);
  decoded_field_length = field_nln.RAW_decode(RSL__IE__NchDrxInformation_nln_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__NchDrxInformation::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__NchDrxInformation_len_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__NchDrxInformation_spare_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RSL__IE__NchDrxInformation_nln__status_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, RSL__IE__NchDrxInformation_emlpp__priority_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, RSL__IE__NchDrxInformation_nln_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &RSL__IE__NchDrxInformation_len_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 4;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(4);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  encoded_length += field_spare.RAW_encode(RSL__IE__NchDrxInformation_spare_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_nln__status.RAW_encode(RSL__IE__NchDrxInformation_nln__status_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_emlpp__priority.RAW_encode(RSL__IE__NchDrxInformation_emlpp__priority_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_nln.RAW_encode(RSL__IE__NchDrxInformation_nln_descr_, *myleaf.body.node.nodes[4]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__NchDrxInformation_template::single_value_struct {
INTEGER_template field_len;
BITSTRING_template field_spare;
BITSTRING_template field_nln__status;
BITSTRING_template field_emlpp__priority;
BITSTRING_template field_nln;
};

void RSL__IE__NchDrxInformation_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_len = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
single_value->field_nln__status = ANY_VALUE;
single_value->field_emlpp__priority = ANY_VALUE;
single_value->field_nln = ANY_VALUE;
}
}
}

void RSL__IE__NchDrxInformation_template::copy_value(const RSL__IE__NchDrxInformation& other_value)
{
single_value = new single_value_struct;
if (other_value.len().is_bound()) {
  single_value->field_len = other_value.len();
} else {
  single_value->field_len.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.nln__status().is_bound()) {
  single_value->field_nln__status = other_value.nln__status();
} else {
  single_value->field_nln__status.clean_up();
}
if (other_value.emlpp__priority().is_bound()) {
  single_value->field_emlpp__priority = other_value.emlpp__priority();
} else {
  single_value->field_emlpp__priority.clean_up();
}
if (other_value.nln().is_bound()) {
  single_value->field_nln = other_value.nln();
} else {
  single_value->field_nln.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__NchDrxInformation_template::copy_template(const RSL__IE__NchDrxInformation_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.len().get_selection()) {
single_value->field_len = other_value.len();
} else {
single_value->field_len.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nln__status().get_selection()) {
single_value->field_nln__status = other_value.nln__status();
} else {
single_value->field_nln__status.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.emlpp__priority().get_selection()) {
single_value->field_emlpp__priority = other_value.emlpp__priority();
} else {
single_value->field_emlpp__priority.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nln().get_selection()) {
single_value->field_nln = other_value.nln();
} else {
single_value->field_nln.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__NchDrxInformation_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__NchDrxInformation_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__NchDrxInformation_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_NchDrxInformation.");
break;
}
set_selection(other_value);
}

RSL__IE__NchDrxInformation_template::RSL__IE__NchDrxInformation_template()
{
}

RSL__IE__NchDrxInformation_template::RSL__IE__NchDrxInformation_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__NchDrxInformation_template::RSL__IE__NchDrxInformation_template(const RSL__IE__NchDrxInformation& other_value)
{
copy_value(other_value);
}

RSL__IE__NchDrxInformation_template::RSL__IE__NchDrxInformation_template(const OPTIONAL<RSL__IE__NchDrxInformation>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__NchDrxInformation&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_NchDrxInformation from an unbound optional field.");
}
}

RSL__IE__NchDrxInformation_template::RSL__IE__NchDrxInformation_template(RSL__IE__NchDrxInformation_template* p_precondition, RSL__IE__NchDrxInformation_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__NchDrxInformation_template::RSL__IE__NchDrxInformation_template(Dynamic_Match_Interface<RSL__IE__NchDrxInformation>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__NchDrxInformation>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__NchDrxInformation_template::RSL__IE__NchDrxInformation_template(const RSL__IE__NchDrxInformation_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__NchDrxInformation_template::~RSL__IE__NchDrxInformation_template()
{
clean_up();
}

RSL__IE__NchDrxInformation_template& RSL__IE__NchDrxInformation_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__NchDrxInformation_template& RSL__IE__NchDrxInformation_template::operator=(const RSL__IE__NchDrxInformation& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__NchDrxInformation_template& RSL__IE__NchDrxInformation_template::operator=(const OPTIONAL<RSL__IE__NchDrxInformation>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__NchDrxInformation&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_NchDrxInformation.");
}
return *this;
}

RSL__IE__NchDrxInformation_template& RSL__IE__NchDrxInformation_template::operator=(const RSL__IE__NchDrxInformation_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__NchDrxInformation_template::match(const RSL__IE__NchDrxInformation& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.len().is_bound()) return FALSE;
if(!single_value->field_len.match(other_value.len(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.nln__status().is_bound()) return FALSE;
if(!single_value->field_nln__status.match(other_value.nln__status(), legacy))return FALSE;
if(!other_value.emlpp__priority().is_bound()) return FALSE;
if(!single_value->field_emlpp__priority.match(other_value.emlpp__priority(), legacy))return FALSE;
if(!other_value.nln().is_bound()) return FALSE;
if(!single_value->field_nln.match(other_value.nln(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_NchDrxInformation.");
}
return FALSE;
}

boolean RSL__IE__NchDrxInformation_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_len.is_bound()
 || single_value->field_spare.is_bound()
 || single_value->field_nln__status.is_bound()
 || single_value->field_emlpp__priority.is_bound()
 || single_value->field_nln.is_bound();
}

boolean RSL__IE__NchDrxInformation_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_len.is_value()
 && single_value->field_spare.is_value()
 && single_value->field_nln__status.is_value()
 && single_value->field_emlpp__priority.is_value()
 && single_value->field_nln.is_value();
}

void RSL__IE__NchDrxInformation_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__NchDrxInformation RSL__IE__NchDrxInformation_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_NchDrxInformation.");
RSL__IE__NchDrxInformation ret_val;
if (single_value->field_len.is_bound()) {
ret_val.len() = single_value->field_len.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_nln__status.is_bound()) {
ret_val.nln__status() = single_value->field_nln__status.valueof();
}
if (single_value->field_emlpp__priority.is_bound()) {
ret_val.emlpp__priority() = single_value->field_emlpp__priority.valueof();
}
if (single_value->field_nln.is_bound()) {
ret_val.nln() = single_value->field_nln.valueof();
}
return ret_val;
}

void RSL__IE__NchDrxInformation_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_NchDrxInformation.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__NchDrxInformation_template[list_length];
}

RSL__IE__NchDrxInformation_template& RSL__IE__NchDrxInformation_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_NchDrxInformation.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_NchDrxInformation.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__NchDrxInformation_template::len()
{
set_specific();
return single_value->field_len;
}

const INTEGER_template& RSL__IE__NchDrxInformation_template::len() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len of a non-specific template of type @RSL_Types.RSL_IE_NchDrxInformation.");
return single_value->field_len;
}

BITSTRING_template& RSL__IE__NchDrxInformation_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& RSL__IE__NchDrxInformation_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @RSL_Types.RSL_IE_NchDrxInformation.");
return single_value->field_spare;
}

BITSTRING_template& RSL__IE__NchDrxInformation_template::nln__status()
{
set_specific();
return single_value->field_nln__status;
}

const BITSTRING_template& RSL__IE__NchDrxInformation_template::nln__status() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nln_status of a non-specific template of type @RSL_Types.RSL_IE_NchDrxInformation.");
return single_value->field_nln__status;
}

BITSTRING_template& RSL__IE__NchDrxInformation_template::emlpp__priority()
{
set_specific();
return single_value->field_emlpp__priority;
}

const BITSTRING_template& RSL__IE__NchDrxInformation_template::emlpp__priority() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field emlpp_priority of a non-specific template of type @RSL_Types.RSL_IE_NchDrxInformation.");
return single_value->field_emlpp__priority;
}

BITSTRING_template& RSL__IE__NchDrxInformation_template::nln()
{
set_specific();
return single_value->field_nln;
}

const BITSTRING_template& RSL__IE__NchDrxInformation_template::nln() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nln of a non-specific template of type @RSL_Types.RSL_IE_NchDrxInformation.");
return single_value->field_nln;
}

int RSL__IE__NchDrxInformation_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_NchDrxInformation which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_NchDrxInformation containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_NchDrxInformation containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_NchDrxInformation containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_NchDrxInformation containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_NchDrxInformation containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_NchDrxInformation containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_NchDrxInformation containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_NchDrxInformation containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_NchDrxInformation.");
  }
  return 0;
}

void RSL__IE__NchDrxInformation_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", nln_status := ");
single_value->field_nln__status.log();
TTCN_Logger::log_event_str(", emlpp_priority := ");
single_value->field_emlpp__priority.log();
TTCN_Logger::log_event_str(", nln := ");
single_value->field_nln.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__NchDrxInformation_template::log_match(const RSL__IE__NchDrxInformation& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_len.match(match_value.len(), legacy)){
TTCN_Logger::log_logmatch_info(".len");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nln__status.match(match_value.nln__status(), legacy)){
TTCN_Logger::log_logmatch_info(".nln_status");
single_value->field_nln__status.log_match(match_value.nln__status(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_emlpp__priority.match(match_value.emlpp__priority(), legacy)){
TTCN_Logger::log_logmatch_info(".emlpp_priority");
single_value->field_emlpp__priority.log_match(match_value.emlpp__priority(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nln.match(match_value.nln(), legacy)){
TTCN_Logger::log_logmatch_info(".nln");
single_value->field_nln.log_match(match_value.nln(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", nln_status := ");
single_value->field_nln__status.log_match(match_value.nln__status(), legacy);
TTCN_Logger::log_event_str(", emlpp_priority := ");
single_value->field_emlpp__priority.log_match(match_value.emlpp__priority(), legacy);
TTCN_Logger::log_event_str(", nln := ");
single_value->field_nln.log_match(match_value.nln(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__NchDrxInformation_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (len().is_bound()) len().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (nln__status().is_bound()) nln__status().set_implicit_omit();
if (emlpp__priority().is_bound()) emlpp__priority().set_implicit_omit();
if (nln().is_bound()) nln().set_implicit_omit();
}

void RSL__IE__NchDrxInformation_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_len.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
single_value->field_nln__status.encode_text(text_buf);
single_value->field_emlpp__priority.encode_text(text_buf);
single_value->field_nln.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_NchDrxInformation.");
}
}

void RSL__IE__NchDrxInformation_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_len.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
single_value->field_nln__status.decode_text(text_buf);
single_value->field_emlpp__priority.decode_text(text_buf);
single_value->field_nln.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__NchDrxInformation_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_NchDrxInformation.");
}
}

void RSL__IE__NchDrxInformation_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__NchDrxInformation_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_NchDrxInformation has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) nln__status().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) emlpp__priority().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) nln().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nln_status")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nln__status().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "emlpp_priority")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          emlpp__priority().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nln")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nln().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_NchDrxInformation: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__NchDrxInformation_template* precondition = new RSL__IE__NchDrxInformation_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__NchDrxInformation_template* implied_template = new RSL__IE__NchDrxInformation_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__NchDrxInformation_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_NchDrxInformation");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__NchDrxInformation_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_len.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_NchDrxInformation");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_NchDrxInformation");
single_value->field_nln__status.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_NchDrxInformation");
single_value->field_emlpp__priority.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_NchDrxInformation");
single_value->field_nln.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_NchDrxInformation");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_NchDrxInformation");
}

boolean RSL__IE__NchDrxInformation_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__NchDrxInformation_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__CommandIndicator::RSL__CommandIndicator()
{
enum_value = UNBOUND_VALUE;
}

RSL__CommandIndicator::RSL__CommandIndicator(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @RSL_Types.RSL_CommandIndicator with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

RSL__CommandIndicator::RSL__CommandIndicator(enum_type other_value)
{
enum_value = other_value;
}

RSL__CommandIndicator::RSL__CommandIndicator(const RSL__CommandIndicator& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
enum_value = other_value.enum_value;
}

RSL__CommandIndicator& RSL__CommandIndicator::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @RSL_Types.RSL_CommandIndicator.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

RSL__CommandIndicator& RSL__CommandIndicator::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

RSL__CommandIndicator& RSL__CommandIndicator::operator=(const RSL__CommandIndicator& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
enum_value = other_value.enum_value;
return *this;
}

boolean RSL__CommandIndicator::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_CommandIndicator comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean RSL__CommandIndicator::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
return enum_value == other_value;
}

boolean RSL__CommandIndicator::operator==(const RSL__CommandIndicator& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
return enum_value == other_value.enum_value;
}

boolean RSL__CommandIndicator::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_CommandIndicator comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean RSL__CommandIndicator::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
return enum_value < other_value;
}

boolean RSL__CommandIndicator::operator<(const RSL__CommandIndicator& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
return enum_value < other_value.enum_value;
}

boolean RSL__CommandIndicator::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_CommandIndicator comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean RSL__CommandIndicator::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
return enum_value > other_value;
}

boolean RSL__CommandIndicator::operator>(const RSL__CommandIndicator& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
return enum_value > other_value.enum_value;
}

const char *RSL__CommandIndicator::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case CMD__IND__START: return "CMD_IND_START";
case CMD__IND__STOP: return "CMD_IND_STOP";
default:
return "<unknown>";
}
}

RSL__CommandIndicator::enum_type RSL__CommandIndicator::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "CMD_IND_START")) return CMD__IND__START;
if (!strcmp(str_par, "CMD_IND_STOP")) return CMD__IND__STOP;
}
return UNKNOWN_VALUE;
}

boolean RSL__CommandIndicator::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
return TRUE;
default:
return FALSE;
}
}

int RSL__CommandIndicator::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_CommandIndicator.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int RSL__CommandIndicator::enum2int(const RSL__CommandIndicator& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_CommandIndicator.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void RSL__CommandIndicator::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @RSL_Types.RSL_CommandIndicator.", int_val);
enum_value = (enum_type)int_val;
}

RSL__CommandIndicator::operator RSL__CommandIndicator::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @RSL_Types.RSL_CommandIndicator.");
return enum_value;
}

void RSL__CommandIndicator::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void RSL__CommandIndicator::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@RSL_Types.RSL_CommandIndicator");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @RSL_Types.RSL_CommandIndicator.");
  }
}

void RSL__CommandIndicator::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
text_buf.push_int(enum_value);
}

void RSL__CommandIndicator::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @RSL_Types.RSL_CommandIndicator.", enum_value);
}

void RSL__CommandIndicator::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__CommandIndicator::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__CommandIndicator::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int RSL__CommandIndicator::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void RSL__CommandIndicator_template::copy_template(const RSL__CommandIndicator_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__CommandIndicator_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__CommandIndicator_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__CommandIndicator_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_CommandIndicator.");
}
}

RSL__CommandIndicator_template::RSL__CommandIndicator_template()
{
}

RSL__CommandIndicator_template::RSL__CommandIndicator_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__CommandIndicator_template::RSL__CommandIndicator_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!RSL__CommandIndicator::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @RSL_Types.RSL_CommandIndicator with unknown numeric value %d.", other_value);
single_value = (RSL__CommandIndicator::enum_type)other_value;
}

RSL__CommandIndicator_template::RSL__CommandIndicator_template(RSL__CommandIndicator::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

RSL__CommandIndicator_template::RSL__CommandIndicator_template(const RSL__CommandIndicator& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == RSL__CommandIndicator::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator.");
single_value = other_value.enum_value;
}

RSL__CommandIndicator_template::RSL__CommandIndicator_template(const OPTIONAL<RSL__CommandIndicator>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__CommandIndicator::enum_type)(const RSL__CommandIndicator&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @RSL_Types.RSL_CommandIndicator from an unbound optional field.");
}
}

RSL__CommandIndicator_template::RSL__CommandIndicator_template(RSL__CommandIndicator_template* p_precondition, RSL__CommandIndicator_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__CommandIndicator_template::RSL__CommandIndicator_template(Dynamic_Match_Interface<RSL__CommandIndicator>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__CommandIndicator>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__CommandIndicator_template::RSL__CommandIndicator_template(const RSL__CommandIndicator_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

RSL__CommandIndicator_template::~RSL__CommandIndicator_template()
{
clean_up();
}

boolean RSL__CommandIndicator_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean RSL__CommandIndicator_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != RSL__CommandIndicator::UNBOUND_VALUE;
}

void RSL__CommandIndicator_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__CommandIndicator_template& RSL__CommandIndicator_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__CommandIndicator_template& RSL__CommandIndicator_template::operator=(int other_value)
{
if (!RSL__CommandIndicator::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @RSL_Types.RSL_CommandIndicator.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (RSL__CommandIndicator::enum_type)other_value;
return *this;
}

RSL__CommandIndicator_template& RSL__CommandIndicator_template::operator=(RSL__CommandIndicator::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

RSL__CommandIndicator_template& RSL__CommandIndicator_template::operator=(const RSL__CommandIndicator& other_value)
{
if (other_value.enum_value == RSL__CommandIndicator::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_CommandIndicator to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

RSL__CommandIndicator_template& RSL__CommandIndicator_template::operator=(const OPTIONAL<RSL__CommandIndicator>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__CommandIndicator::enum_type)(const RSL__CommandIndicator&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @RSL_Types.RSL_CommandIndicator.");
}
return *this;
}

RSL__CommandIndicator_template& RSL__CommandIndicator_template::operator=(const RSL__CommandIndicator_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__CommandIndicator_template::match(RSL__CommandIndicator::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_CommandIndicator.");
}
return FALSE;
}

boolean RSL__CommandIndicator_template::match(const RSL__CommandIndicator& other_value, boolean) const
{
if (other_value.enum_value == RSL__CommandIndicator::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @RSL_Types.RSL_CommandIndicator with an unbound value.");
return match(other_value.enum_value);
}

RSL__CommandIndicator::enum_type RSL__CommandIndicator_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @RSL_Types.RSL_CommandIndicator.");
return single_value;
}

void RSL__CommandIndicator_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__CommandIndicator_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @RSL_Types.RSL_CommandIndicator.");
}
}

RSL__CommandIndicator_template& RSL__CommandIndicator_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @RSL_Types.RSL_CommandIndicator.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @RSL_Types.RSL_CommandIndicator.");
return value_list.list_value[list_index];
}

void RSL__CommandIndicator_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(RSL__CommandIndicator::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__CommandIndicator_template::log_match(const RSL__CommandIndicator& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void RSL__CommandIndicator_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_CommandIndicator.");
}
}

void RSL__CommandIndicator_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (RSL__CommandIndicator::enum_type)text_buf.pull_int().get_val();
if (!RSL__CommandIndicator::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @RSL_Types.RSL_CommandIndicator.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__CommandIndicator_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @RSL_Types.RSL_CommandIndicator.");
}
}

boolean RSL__CommandIndicator_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__CommandIndicator_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RSL__CommandIndicator_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__CommandIndicator_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    RSL__CommandIndicator::enum_type enum_val = RSL__CommandIndicator::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!RSL__CommandIndicator::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @RSL_Types.RSL_CommandIndicator.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__CommandIndicator_template* precondition = new RSL__CommandIndicator_template;
    precondition->set_param(*m_p->get_elem(0));
    RSL__CommandIndicator_template* implied_template = new RSL__CommandIndicator_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = RSL__CommandIndicator_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@RSL_Types.RSL_CommandIndicator");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__CommandIndicator_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_CommandIndicator");
}

RSL__IE__CommandIndicator::RSL__IE__CommandIndicator()
{
}

RSL__IE__CommandIndicator::RSL__IE__CommandIndicator(const INTEGER& par_len,
    const RSL__CommandIndicator& par_command__value)
  :   field_len(par_len),
  field_command__value(par_command__value)
{
}

RSL__IE__CommandIndicator::RSL__IE__CommandIndicator(const RSL__IE__CommandIndicator& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_CommandIndicator.");
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.command__value().is_bound()) field_command__value = other_value.command__value();
else field_command__value.clean_up();
}

void RSL__IE__CommandIndicator::clean_up()
{
field_len.clean_up();
field_command__value.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__CommandIndicator::get_descriptor() const { return &RSL__IE__CommandIndicator_descr_; }
RSL__IE__CommandIndicator& RSL__IE__CommandIndicator::operator=(const RSL__IE__CommandIndicator& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_CommandIndicator.");
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.command__value().is_bound()) field_command__value = other_value.command__value();
  else field_command__value.clean_up();
}
return *this;
}

boolean RSL__IE__CommandIndicator::operator==(const RSL__IE__CommandIndicator& other_value) const
{
return field_len==other_value.field_len
  && field_command__value==other_value.field_command__value;
}

boolean RSL__IE__CommandIndicator::is_bound() const
{
return (field_len.is_bound())
  || (field_command__value.is_bound());
}
boolean RSL__IE__CommandIndicator::is_value() const
{
return field_len.is_value()
  && field_command__value.is_value();
}
void RSL__IE__CommandIndicator::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len := ");
field_len.log();
TTCN_Logger::log_event_str(", command_value := ");
field_command__value.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__CommandIndicator::set_implicit_omit()
{
if (len().is_bound()) len().set_implicit_omit();
if (command__value().is_bound()) command__value().set_implicit_omit();
}

void RSL__IE__CommandIndicator::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_CommandIndicator has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) command__value().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "command_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          command__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_CommandIndicator: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_CommandIndicator");
  }
}

void RSL__IE__CommandIndicator::encode_text(Text_Buf& text_buf) const
{
field_len.encode_text(text_buf);
field_command__value.encode_text(text_buf);
}

void RSL__IE__CommandIndicator::decode_text(Text_Buf& text_buf)
{
field_len.decode_text(text_buf);
field_command__value.decode_text(text_buf);
}

void RSL__IE__CommandIndicator::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__CommandIndicator::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__CommandIndicator::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__CommandIndicator_len_descr_.raw->forceomit);
  decoded_field_length = field_len.RAW_decode(RSL__IE__CommandIndicator_len_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_len.convert_to_Integer(RSL__IE__CommandIndicator_len_descr_);
  field_len = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__CommandIndicator_command__value_descr_.raw->forceomit);
  decoded_field_length = field_command__value.RAW_decode(RSL__IE__CommandIndicator_command__value_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__CommandIndicator::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__CommandIndicator_len_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__CommandIndicator_command__value_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &RSL__IE__CommandIndicator_len_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  encoded_length += field_command__value.RAW_encode(RSL__IE__CommandIndicator_command__value_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__CommandIndicator_template::single_value_struct {
INTEGER_template field_len;
RSL__CommandIndicator_template field_command__value;
};

void RSL__IE__CommandIndicator_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_len = ANY_VALUE;
single_value->field_command__value = ANY_VALUE;
}
}
}

void RSL__IE__CommandIndicator_template::copy_value(const RSL__IE__CommandIndicator& other_value)
{
single_value = new single_value_struct;
if (other_value.len().is_bound()) {
  single_value->field_len = other_value.len();
} else {
  single_value->field_len.clean_up();
}
if (other_value.command__value().is_bound()) {
  single_value->field_command__value = other_value.command__value();
} else {
  single_value->field_command__value.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__CommandIndicator_template::copy_template(const RSL__IE__CommandIndicator_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.len().get_selection()) {
single_value->field_len = other_value.len();
} else {
single_value->field_len.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.command__value().get_selection()) {
single_value->field_command__value = other_value.command__value();
} else {
single_value->field_command__value.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__CommandIndicator_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__CommandIndicator_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__CommandIndicator_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_CommandIndicator.");
break;
}
set_selection(other_value);
}

RSL__IE__CommandIndicator_template::RSL__IE__CommandIndicator_template()
{
}

RSL__IE__CommandIndicator_template::RSL__IE__CommandIndicator_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__CommandIndicator_template::RSL__IE__CommandIndicator_template(const RSL__IE__CommandIndicator& other_value)
{
copy_value(other_value);
}

RSL__IE__CommandIndicator_template::RSL__IE__CommandIndicator_template(const OPTIONAL<RSL__IE__CommandIndicator>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__CommandIndicator&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_CommandIndicator from an unbound optional field.");
}
}

RSL__IE__CommandIndicator_template::RSL__IE__CommandIndicator_template(RSL__IE__CommandIndicator_template* p_precondition, RSL__IE__CommandIndicator_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__CommandIndicator_template::RSL__IE__CommandIndicator_template(Dynamic_Match_Interface<RSL__IE__CommandIndicator>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__CommandIndicator>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__CommandIndicator_template::RSL__IE__CommandIndicator_template(const RSL__IE__CommandIndicator_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__CommandIndicator_template::~RSL__IE__CommandIndicator_template()
{
clean_up();
}

RSL__IE__CommandIndicator_template& RSL__IE__CommandIndicator_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__CommandIndicator_template& RSL__IE__CommandIndicator_template::operator=(const RSL__IE__CommandIndicator& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__CommandIndicator_template& RSL__IE__CommandIndicator_template::operator=(const OPTIONAL<RSL__IE__CommandIndicator>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__CommandIndicator&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_CommandIndicator.");
}
return *this;
}

RSL__IE__CommandIndicator_template& RSL__IE__CommandIndicator_template::operator=(const RSL__IE__CommandIndicator_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__CommandIndicator_template::match(const RSL__IE__CommandIndicator& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.len().is_bound()) return FALSE;
if(!single_value->field_len.match(other_value.len(), legacy))return FALSE;
if(!other_value.command__value().is_bound()) return FALSE;
if(!single_value->field_command__value.match(other_value.command__value(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_CommandIndicator.");
}
return FALSE;
}

boolean RSL__IE__CommandIndicator_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_len.is_bound()
 || single_value->field_command__value.is_bound();
}

boolean RSL__IE__CommandIndicator_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_len.is_value()
 && single_value->field_command__value.is_value();
}

void RSL__IE__CommandIndicator_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__CommandIndicator RSL__IE__CommandIndicator_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_CommandIndicator.");
RSL__IE__CommandIndicator ret_val;
if (single_value->field_len.is_bound()) {
ret_val.len() = single_value->field_len.valueof();
}
if (single_value->field_command__value.is_bound()) {
ret_val.command__value() = single_value->field_command__value.valueof();
}
return ret_val;
}

void RSL__IE__CommandIndicator_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_CommandIndicator.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__CommandIndicator_template[list_length];
}

RSL__IE__CommandIndicator_template& RSL__IE__CommandIndicator_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_CommandIndicator.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_CommandIndicator.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__CommandIndicator_template::len()
{
set_specific();
return single_value->field_len;
}

const INTEGER_template& RSL__IE__CommandIndicator_template::len() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len of a non-specific template of type @RSL_Types.RSL_IE_CommandIndicator.");
return single_value->field_len;
}

RSL__CommandIndicator_template& RSL__IE__CommandIndicator_template::command__value()
{
set_specific();
return single_value->field_command__value;
}

const RSL__CommandIndicator_template& RSL__IE__CommandIndicator_template::command__value() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field command_value of a non-specific template of type @RSL_Types.RSL_IE_CommandIndicator.");
return single_value->field_command__value;
}

int RSL__IE__CommandIndicator_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CommandIndicator which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CommandIndicator containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CommandIndicator containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CommandIndicator containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CommandIndicator containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CommandIndicator containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CommandIndicator containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CommandIndicator containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_CommandIndicator containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_CommandIndicator.");
  }
  return 0;
}

void RSL__IE__CommandIndicator_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log();
TTCN_Logger::log_event_str(", command_value := ");
single_value->field_command__value.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__CommandIndicator_template::log_match(const RSL__IE__CommandIndicator& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_len.match(match_value.len(), legacy)){
TTCN_Logger::log_logmatch_info(".len");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_command__value.match(match_value.command__value(), legacy)){
TTCN_Logger::log_logmatch_info(".command_value");
single_value->field_command__value.log_match(match_value.command__value(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::log_event_str(", command_value := ");
single_value->field_command__value.log_match(match_value.command__value(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__CommandIndicator_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (len().is_bound()) len().set_implicit_omit();
if (command__value().is_bound()) command__value().set_implicit_omit();
}

void RSL__IE__CommandIndicator_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_len.encode_text(text_buf);
single_value->field_command__value.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_CommandIndicator.");
}
}

void RSL__IE__CommandIndicator_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_len.decode_text(text_buf);
single_value->field_command__value.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__CommandIndicator_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_CommandIndicator.");
}
}

void RSL__IE__CommandIndicator_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__CommandIndicator_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_CommandIndicator has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) command__value().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "command_value")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          command__value().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_CommandIndicator: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__CommandIndicator_template* precondition = new RSL__IE__CommandIndicator_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__CommandIndicator_template* implied_template = new RSL__IE__CommandIndicator_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__CommandIndicator_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_CommandIndicator");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__CommandIndicator_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_len.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_CommandIndicator");
single_value->field_command__value.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_CommandIndicator");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_CommandIndicator");
}

boolean RSL__IE__CommandIndicator_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__CommandIndicator_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IE__Uic::RSL__IE__Uic()
{
}

RSL__IE__Uic::RSL__IE__Uic(const INTEGER& par_len,
    const BITSTRING& par_spare,
    const INTEGER& par_uic)
  :   field_len(par_len),
  field_spare(par_spare),
  field_uic(par_uic)
{
}

RSL__IE__Uic::RSL__IE__Uic(const RSL__IE__Uic& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_Uic.");
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.uic().is_bound()) field_uic = other_value.uic();
else field_uic.clean_up();
}

void RSL__IE__Uic::clean_up()
{
field_len.clean_up();
field_spare.clean_up();
field_uic.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__Uic::get_descriptor() const { return &RSL__IE__Uic_descr_; }
RSL__IE__Uic& RSL__IE__Uic::operator=(const RSL__IE__Uic& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_Uic.");
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.uic().is_bound()) field_uic = other_value.uic();
  else field_uic.clean_up();
}
return *this;
}

boolean RSL__IE__Uic::operator==(const RSL__IE__Uic& other_value) const
{
return field_len==other_value.field_len
  && field_spare==other_value.field_spare
  && field_uic==other_value.field_uic;
}

boolean RSL__IE__Uic::is_bound() const
{
return (field_len.is_bound())
  || (field_spare.is_bound())
  || (field_uic.is_bound());
}
boolean RSL__IE__Uic::is_value() const
{
return field_len.is_value()
  && field_spare.is_value()
  && field_uic.is_value();
}
void RSL__IE__Uic::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len := ");
field_len.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", uic := ");
field_uic.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__Uic::set_implicit_omit()
{
if (len().is_bound()) len().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (uic().is_bound()) uic().set_implicit_omit();
}

void RSL__IE__Uic::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_Uic has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) uic().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "uic")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          uic().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_Uic: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_Uic");
  }
}

void RSL__IE__Uic::encode_text(Text_Buf& text_buf) const
{
field_len.encode_text(text_buf);
field_spare.encode_text(text_buf);
field_uic.encode_text(text_buf);
}

void RSL__IE__Uic::decode_text(Text_Buf& text_buf)
{
field_len.decode_text(text_buf);
field_spare.decode_text(text_buf);
field_uic.decode_text(text_buf);
}

void RSL__IE__Uic::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__Uic::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__Uic::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__Uic_len_descr_.raw->forceomit);
  decoded_field_length = field_len.RAW_decode(RSL__IE__Uic_len_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_len.convert_to_Integer(RSL__IE__Uic_len_descr_);
  field_len = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__Uic_spare_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(RSL__IE__Uic_spare_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RSL__IE__Uic_uic_descr_.raw->forceomit);
  decoded_field_length = field_uic.RAW_decode(RSL__IE__Uic_uic_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__Uic::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__Uic_len_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__Uic_spare_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RSL__IE__Uic_uic_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &RSL__IE__Uic_len_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 2;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(2);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_spare.RAW_encode(RSL__IE__Uic_spare_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_uic.RAW_encode(RSL__IE__Uic_uic_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__Uic_template::single_value_struct {
INTEGER_template field_len;
BITSTRING_template field_spare;
INTEGER_template field_uic;
};

void RSL__IE__Uic_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_len = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
single_value->field_uic = ANY_VALUE;
}
}
}

void RSL__IE__Uic_template::copy_value(const RSL__IE__Uic& other_value)
{
single_value = new single_value_struct;
if (other_value.len().is_bound()) {
  single_value->field_len = other_value.len();
} else {
  single_value->field_len.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.uic().is_bound()) {
  single_value->field_uic = other_value.uic();
} else {
  single_value->field_uic.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__Uic_template::copy_template(const RSL__IE__Uic_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.len().get_selection()) {
single_value->field_len = other_value.len();
} else {
single_value->field_len.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.uic().get_selection()) {
single_value->field_uic = other_value.uic();
} else {
single_value->field_uic.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__Uic_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__Uic_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__Uic_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_Uic.");
break;
}
set_selection(other_value);
}

RSL__IE__Uic_template::RSL__IE__Uic_template()
{
}

RSL__IE__Uic_template::RSL__IE__Uic_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__Uic_template::RSL__IE__Uic_template(const RSL__IE__Uic& other_value)
{
copy_value(other_value);
}

RSL__IE__Uic_template::RSL__IE__Uic_template(const OPTIONAL<RSL__IE__Uic>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__Uic&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_Uic from an unbound optional field.");
}
}

RSL__IE__Uic_template::RSL__IE__Uic_template(RSL__IE__Uic_template* p_precondition, RSL__IE__Uic_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__Uic_template::RSL__IE__Uic_template(Dynamic_Match_Interface<RSL__IE__Uic>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__Uic>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__Uic_template::RSL__IE__Uic_template(const RSL__IE__Uic_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__Uic_template::~RSL__IE__Uic_template()
{
clean_up();
}

RSL__IE__Uic_template& RSL__IE__Uic_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__Uic_template& RSL__IE__Uic_template::operator=(const RSL__IE__Uic& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__Uic_template& RSL__IE__Uic_template::operator=(const OPTIONAL<RSL__IE__Uic>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__Uic&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_Uic.");
}
return *this;
}

RSL__IE__Uic_template& RSL__IE__Uic_template::operator=(const RSL__IE__Uic_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__Uic_template::match(const RSL__IE__Uic& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.len().is_bound()) return FALSE;
if(!single_value->field_len.match(other_value.len(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.uic().is_bound()) return FALSE;
if(!single_value->field_uic.match(other_value.uic(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_Uic.");
}
return FALSE;
}

boolean RSL__IE__Uic_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_len.is_bound()
 || single_value->field_spare.is_bound()
 || single_value->field_uic.is_bound();
}

boolean RSL__IE__Uic_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_len.is_value()
 && single_value->field_spare.is_value()
 && single_value->field_uic.is_value();
}

void RSL__IE__Uic_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__Uic RSL__IE__Uic_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_Uic.");
RSL__IE__Uic ret_val;
if (single_value->field_len.is_bound()) {
ret_val.len() = single_value->field_len.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_uic.is_bound()) {
ret_val.uic() = single_value->field_uic.valueof();
}
return ret_val;
}

void RSL__IE__Uic_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_Uic.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__Uic_template[list_length];
}

RSL__IE__Uic_template& RSL__IE__Uic_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_Uic.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_Uic.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__Uic_template::len()
{
set_specific();
return single_value->field_len;
}

const INTEGER_template& RSL__IE__Uic_template::len() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len of a non-specific template of type @RSL_Types.RSL_IE_Uic.");
return single_value->field_len;
}

BITSTRING_template& RSL__IE__Uic_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& RSL__IE__Uic_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @RSL_Types.RSL_IE_Uic.");
return single_value->field_spare;
}

INTEGER_template& RSL__IE__Uic_template::uic()
{
set_specific();
return single_value->field_uic;
}

const INTEGER_template& RSL__IE__Uic_template::uic() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field uic of a non-specific template of type @RSL_Types.RSL_IE_Uic.");
return single_value->field_uic;
}

int RSL__IE__Uic_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_Uic which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_Uic containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_Uic containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_Uic containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_Uic containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_Uic containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_Uic containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_Uic containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_Uic containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_Uic.");
  }
  return 0;
}

void RSL__IE__Uic_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", uic := ");
single_value->field_uic.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__Uic_template::log_match(const RSL__IE__Uic& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_len.match(match_value.len(), legacy)){
TTCN_Logger::log_logmatch_info(".len");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_uic.match(match_value.uic(), legacy)){
TTCN_Logger::log_logmatch_info(".uic");
single_value->field_uic.log_match(match_value.uic(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", uic := ");
single_value->field_uic.log_match(match_value.uic(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__Uic_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (len().is_bound()) len().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (uic().is_bound()) uic().set_implicit_omit();
}

void RSL__IE__Uic_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_len.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
single_value->field_uic.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_Uic.");
}
}

void RSL__IE__Uic_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_len.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
single_value->field_uic.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__Uic_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_Uic.");
}
}

void RSL__IE__Uic_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__Uic_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_Uic has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) uic().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "uic")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          uic().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_Uic: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__Uic_template* precondition = new RSL__IE__Uic_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__Uic_template* implied_template = new RSL__IE__Uic_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__Uic_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_Uic");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__Uic_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_len.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_Uic");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_Uic");
single_value->field_uic.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_Uic");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_Uic");
}

boolean RSL__IE__Uic_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__Uic_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IE__MultirateCfg::RSL__IE__MultirateCfg()
{
}

RSL__IE__MultirateCfg::RSL__IE__MultirateCfg(const INTEGER& par_len,
    const INTEGER& par_mr__speech__ver,
    const BOOLEAN& par_nscb,
    const BOOLEAN& par_icmi,
    const BITSTRING& par_spare,
    const INTEGER& par_start__mode,
    const BITSTRING& par_codec__modes,
    const OCTETSTRING& par_parameters)
  :   field_len(par_len),
  field_mr__speech__ver(par_mr__speech__ver),
  field_nscb(par_nscb),
  field_icmi(par_icmi),
  field_spare(par_spare),
  field_start__mode(par_start__mode),
  field_codec__modes(par_codec__modes),
  field_parameters(par_parameters)
{
}

RSL__IE__MultirateCfg::RSL__IE__MultirateCfg(const RSL__IE__MultirateCfg& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_MultirateCfg.");
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.mr__speech__ver().is_bound()) field_mr__speech__ver = other_value.mr__speech__ver();
else field_mr__speech__ver.clean_up();
if (other_value.nscb().is_bound()) field_nscb = other_value.nscb();
else field_nscb.clean_up();
if (other_value.icmi().is_bound()) field_icmi = other_value.icmi();
else field_icmi.clean_up();
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.start__mode().is_bound()) field_start__mode = other_value.start__mode();
else field_start__mode.clean_up();
if (other_value.codec__modes().is_bound()) field_codec__modes = other_value.codec__modes();
else field_codec__modes.clean_up();
if (other_value.parameters().is_bound()) field_parameters = other_value.parameters();
else field_parameters.clean_up();
}

void RSL__IE__MultirateCfg::clean_up()
{
field_len.clean_up();
field_mr__speech__ver.clean_up();
field_nscb.clean_up();
field_icmi.clean_up();
field_spare.clean_up();
field_start__mode.clean_up();
field_codec__modes.clean_up();
field_parameters.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__MultirateCfg::get_descriptor() const { return &RSL__IE__MultirateCfg_descr_; }
RSL__IE__MultirateCfg& RSL__IE__MultirateCfg::operator=(const RSL__IE__MultirateCfg& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_MultirateCfg.");
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.mr__speech__ver().is_bound()) field_mr__speech__ver = other_value.mr__speech__ver();
  else field_mr__speech__ver.clean_up();
  if (other_value.nscb().is_bound()) field_nscb = other_value.nscb();
  else field_nscb.clean_up();
  if (other_value.icmi().is_bound()) field_icmi = other_value.icmi();
  else field_icmi.clean_up();
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.start__mode().is_bound()) field_start__mode = other_value.start__mode();
  else field_start__mode.clean_up();
  if (other_value.codec__modes().is_bound()) field_codec__modes = other_value.codec__modes();
  else field_codec__modes.clean_up();
  if (other_value.parameters().is_bound()) field_parameters = other_value.parameters();
  else field_parameters.clean_up();
}
return *this;
}

boolean RSL__IE__MultirateCfg::operator==(const RSL__IE__MultirateCfg& other_value) const
{
return field_len==other_value.field_len
  && field_mr__speech__ver==other_value.field_mr__speech__ver
  && field_nscb==other_value.field_nscb
  && field_icmi==other_value.field_icmi
  && field_spare==other_value.field_spare
  && field_start__mode==other_value.field_start__mode
  && field_codec__modes==other_value.field_codec__modes
  && field_parameters==other_value.field_parameters;
}

boolean RSL__IE__MultirateCfg::is_bound() const
{
return (field_len.is_bound())
  || (field_mr__speech__ver.is_bound())
  || (field_nscb.is_bound())
  || (field_icmi.is_bound())
  || (field_spare.is_bound())
  || (field_start__mode.is_bound())
  || (field_codec__modes.is_bound())
  || (field_parameters.is_bound());
}
boolean RSL__IE__MultirateCfg::is_value() const
{
return field_len.is_value()
  && field_mr__speech__ver.is_value()
  && field_nscb.is_value()
  && field_icmi.is_value()
  && field_spare.is_value()
  && field_start__mode.is_value()
  && field_codec__modes.is_value()
  && field_parameters.is_value();
}
void RSL__IE__MultirateCfg::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len := ");
field_len.log();
TTCN_Logger::log_event_str(", mr_speech_ver := ");
field_mr__speech__ver.log();
TTCN_Logger::log_event_str(", nscb := ");
field_nscb.log();
TTCN_Logger::log_event_str(", icmi := ");
field_icmi.log();
TTCN_Logger::log_event_str(", spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", start_mode := ");
field_start__mode.log();
TTCN_Logger::log_event_str(", codec_modes := ");
field_codec__modes.log();
TTCN_Logger::log_event_str(", parameters := ");
field_parameters.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__MultirateCfg::set_implicit_omit()
{
if (len().is_bound()) len().set_implicit_omit();
if (mr__speech__ver().is_bound()) mr__speech__ver().set_implicit_omit();
if (nscb().is_bound()) nscb().set_implicit_omit();
if (icmi().is_bound()) icmi().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (start__mode().is_bound()) start__mode().set_implicit_omit();
if (codec__modes().is_bound()) codec__modes().set_implicit_omit();
if (parameters().is_bound()) parameters().set_implicit_omit();
}

void RSL__IE__MultirateCfg::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_MultirateCfg has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) mr__speech__ver().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) nscb().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) icmi().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) start__mode().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) codec__modes().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) parameters().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mr_speech_ver")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mr__speech__ver().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nscb")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nscb().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "icmi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          icmi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "start_mode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          start__mode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "codec_modes")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          codec__modes().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "parameters")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          parameters().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_MultirateCfg: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_MultirateCfg");
  }
}

void RSL__IE__MultirateCfg::encode_text(Text_Buf& text_buf) const
{
field_len.encode_text(text_buf);
field_mr__speech__ver.encode_text(text_buf);
field_nscb.encode_text(text_buf);
field_icmi.encode_text(text_buf);
field_spare.encode_text(text_buf);
field_start__mode.encode_text(text_buf);
field_codec__modes.encode_text(text_buf);
field_parameters.encode_text(text_buf);
}

void RSL__IE__MultirateCfg::decode_text(Text_Buf& text_buf)
{
field_len.decode_text(text_buf);
field_mr__speech__ver.decode_text(text_buf);
field_nscb.decode_text(text_buf);
field_icmi.decode_text(text_buf);
field_spare.decode_text(text_buf);
field_start__mode.decode_text(text_buf);
field_codec__modes.decode_text(text_buf);
field_parameters.decode_text(text_buf);
}

void RSL__IE__MultirateCfg::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__MultirateCfg::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__MultirateCfg::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__MultirateCfg_len_descr_.raw->forceomit);
  decoded_field_length = field_len.RAW_decode(RSL__IE__MultirateCfg_len_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_len.convert_to_Integer(RSL__IE__MultirateCfg_len_descr_);
  field_len = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__MultirateCfg_mr__speech__ver_descr_.raw->forceomit);
  decoded_field_length = field_mr__speech__ver.RAW_decode(RSL__IE__MultirateCfg_mr__speech__ver_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RSL__IE__MultirateCfg_nscb_descr_.raw->forceomit);
  decoded_field_length = field_nscb.RAW_decode(RSL__IE__MultirateCfg_nscb_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, RSL__IE__MultirateCfg_icmi_descr_.raw->forceomit);
  decoded_field_length = field_icmi.RAW_decode(RSL__IE__MultirateCfg_icmi_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, RSL__IE__MultirateCfg_spare_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(RSL__IE__MultirateCfg_spare_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_5_force_omit(5, force_omit, RSL__IE__MultirateCfg_start__mode_descr_.raw->forceomit);
  decoded_field_length = field_start__mode.RAW_decode(RSL__IE__MultirateCfg_start__mode_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_6_force_omit(6, force_omit, RSL__IE__MultirateCfg_codec__modes_descr_.raw->forceomit);
  decoded_field_length = field_codec__modes.RAW_decode(RSL__IE__MultirateCfg_codec__modes_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_7_force_omit(7, force_omit, RSL__IE__MultirateCfg_parameters_descr_.raw->forceomit);
  decoded_field_length = field_parameters.RAW_decode(RSL__IE__MultirateCfg_parameters_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__MultirateCfg::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 8;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(8);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__MultirateCfg_len_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__MultirateCfg_mr__speech__ver_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RSL__IE__MultirateCfg_nscb_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, RSL__IE__MultirateCfg_icmi_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, RSL__IE__MultirateCfg_spare_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, RSL__IE__MultirateCfg_start__mode_descr_.raw);
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, RSL__IE__MultirateCfg_codec__modes_descr_.raw);
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, RSL__IE__MultirateCfg_parameters_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &RSL__IE__MultirateCfg_len_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 7;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(7);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[4].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[4].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[5].level = myleaf.body.node.nodes[6]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[5].pos = myleaf.body.node.nodes[6]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[6].level = myleaf.body.node.nodes[7]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[6].pos = myleaf.body.node.nodes[7]->curr_pos.pos;
  encoded_length += field_mr__speech__ver.RAW_encode(RSL__IE__MultirateCfg_mr__speech__ver_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_nscb.RAW_encode(RSL__IE__MultirateCfg_nscb_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_icmi.RAW_encode(RSL__IE__MultirateCfg_icmi_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_spare.RAW_encode(RSL__IE__MultirateCfg_spare_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_start__mode.RAW_encode(RSL__IE__MultirateCfg_start__mode_descr_, *myleaf.body.node.nodes[5]);
  encoded_length += field_codec__modes.RAW_encode(RSL__IE__MultirateCfg_codec__modes_descr_, *myleaf.body.node.nodes[6]);
  encoded_length += field_parameters.RAW_encode(RSL__IE__MultirateCfg_parameters_descr_, *myleaf.body.node.nodes[7]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__MultirateCfg_template::single_value_struct {
INTEGER_template field_len;
INTEGER_template field_mr__speech__ver;
BOOLEAN_template field_nscb;
BOOLEAN_template field_icmi;
BITSTRING_template field_spare;
INTEGER_template field_start__mode;
BITSTRING_template field_codec__modes;
OCTETSTRING_template field_parameters;
};

void RSL__IE__MultirateCfg_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_len = ANY_VALUE;
single_value->field_mr__speech__ver = ANY_VALUE;
single_value->field_nscb = ANY_VALUE;
single_value->field_icmi = ANY_VALUE;
single_value->field_spare = ANY_VALUE;
single_value->field_start__mode = ANY_VALUE;
single_value->field_codec__modes = ANY_VALUE;
single_value->field_parameters = ANY_VALUE;
}
}
}

void RSL__IE__MultirateCfg_template::copy_value(const RSL__IE__MultirateCfg& other_value)
{
single_value = new single_value_struct;
if (other_value.len().is_bound()) {
  single_value->field_len = other_value.len();
} else {
  single_value->field_len.clean_up();
}
if (other_value.mr__speech__ver().is_bound()) {
  single_value->field_mr__speech__ver = other_value.mr__speech__ver();
} else {
  single_value->field_mr__speech__ver.clean_up();
}
if (other_value.nscb().is_bound()) {
  single_value->field_nscb = other_value.nscb();
} else {
  single_value->field_nscb.clean_up();
}
if (other_value.icmi().is_bound()) {
  single_value->field_icmi = other_value.icmi();
} else {
  single_value->field_icmi.clean_up();
}
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.start__mode().is_bound()) {
  single_value->field_start__mode = other_value.start__mode();
} else {
  single_value->field_start__mode.clean_up();
}
if (other_value.codec__modes().is_bound()) {
  single_value->field_codec__modes = other_value.codec__modes();
} else {
  single_value->field_codec__modes.clean_up();
}
if (other_value.parameters().is_bound()) {
  single_value->field_parameters = other_value.parameters();
} else {
  single_value->field_parameters.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__MultirateCfg_template::copy_template(const RSL__IE__MultirateCfg_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.len().get_selection()) {
single_value->field_len = other_value.len();
} else {
single_value->field_len.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mr__speech__ver().get_selection()) {
single_value->field_mr__speech__ver = other_value.mr__speech__ver();
} else {
single_value->field_mr__speech__ver.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nscb().get_selection()) {
single_value->field_nscb = other_value.nscb();
} else {
single_value->field_nscb.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.icmi().get_selection()) {
single_value->field_icmi = other_value.icmi();
} else {
single_value->field_icmi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.start__mode().get_selection()) {
single_value->field_start__mode = other_value.start__mode();
} else {
single_value->field_start__mode.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.codec__modes().get_selection()) {
single_value->field_codec__modes = other_value.codec__modes();
} else {
single_value->field_codec__modes.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.parameters().get_selection()) {
single_value->field_parameters = other_value.parameters();
} else {
single_value->field_parameters.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__MultirateCfg_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__MultirateCfg_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__MultirateCfg_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_MultirateCfg.");
break;
}
set_selection(other_value);
}

RSL__IE__MultirateCfg_template::RSL__IE__MultirateCfg_template()
{
}

RSL__IE__MultirateCfg_template::RSL__IE__MultirateCfg_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__MultirateCfg_template::RSL__IE__MultirateCfg_template(const RSL__IE__MultirateCfg& other_value)
{
copy_value(other_value);
}

RSL__IE__MultirateCfg_template::RSL__IE__MultirateCfg_template(const OPTIONAL<RSL__IE__MultirateCfg>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__MultirateCfg&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_MultirateCfg from an unbound optional field.");
}
}

RSL__IE__MultirateCfg_template::RSL__IE__MultirateCfg_template(RSL__IE__MultirateCfg_template* p_precondition, RSL__IE__MultirateCfg_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__MultirateCfg_template::RSL__IE__MultirateCfg_template(Dynamic_Match_Interface<RSL__IE__MultirateCfg>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__MultirateCfg>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__MultirateCfg_template::RSL__IE__MultirateCfg_template(const RSL__IE__MultirateCfg_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__MultirateCfg_template::~RSL__IE__MultirateCfg_template()
{
clean_up();
}

RSL__IE__MultirateCfg_template& RSL__IE__MultirateCfg_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__MultirateCfg_template& RSL__IE__MultirateCfg_template::operator=(const RSL__IE__MultirateCfg& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__MultirateCfg_template& RSL__IE__MultirateCfg_template::operator=(const OPTIONAL<RSL__IE__MultirateCfg>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__MultirateCfg&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_MultirateCfg.");
}
return *this;
}

RSL__IE__MultirateCfg_template& RSL__IE__MultirateCfg_template::operator=(const RSL__IE__MultirateCfg_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__MultirateCfg_template::match(const RSL__IE__MultirateCfg& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.len().is_bound()) return FALSE;
if(!single_value->field_len.match(other_value.len(), legacy))return FALSE;
if(!other_value.mr__speech__ver().is_bound()) return FALSE;
if(!single_value->field_mr__speech__ver.match(other_value.mr__speech__ver(), legacy))return FALSE;
if(!other_value.nscb().is_bound()) return FALSE;
if(!single_value->field_nscb.match(other_value.nscb(), legacy))return FALSE;
if(!other_value.icmi().is_bound()) return FALSE;
if(!single_value->field_icmi.match(other_value.icmi(), legacy))return FALSE;
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.start__mode().is_bound()) return FALSE;
if(!single_value->field_start__mode.match(other_value.start__mode(), legacy))return FALSE;
if(!other_value.codec__modes().is_bound()) return FALSE;
if(!single_value->field_codec__modes.match(other_value.codec__modes(), legacy))return FALSE;
if(!other_value.parameters().is_bound()) return FALSE;
if(!single_value->field_parameters.match(other_value.parameters(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_MultirateCfg.");
}
return FALSE;
}

boolean RSL__IE__MultirateCfg_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_len.is_bound()
 || single_value->field_mr__speech__ver.is_bound()
 || single_value->field_nscb.is_bound()
 || single_value->field_icmi.is_bound()
 || single_value->field_spare.is_bound()
 || single_value->field_start__mode.is_bound()
 || single_value->field_codec__modes.is_bound()
 || single_value->field_parameters.is_bound();
}

boolean RSL__IE__MultirateCfg_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_len.is_value()
 && single_value->field_mr__speech__ver.is_value()
 && single_value->field_nscb.is_value()
 && single_value->field_icmi.is_value()
 && single_value->field_spare.is_value()
 && single_value->field_start__mode.is_value()
 && single_value->field_codec__modes.is_value()
 && single_value->field_parameters.is_value();
}

void RSL__IE__MultirateCfg_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__MultirateCfg RSL__IE__MultirateCfg_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_MultirateCfg.");
RSL__IE__MultirateCfg ret_val;
if (single_value->field_len.is_bound()) {
ret_val.len() = single_value->field_len.valueof();
}
if (single_value->field_mr__speech__ver.is_bound()) {
ret_val.mr__speech__ver() = single_value->field_mr__speech__ver.valueof();
}
if (single_value->field_nscb.is_bound()) {
ret_val.nscb() = single_value->field_nscb.valueof();
}
if (single_value->field_icmi.is_bound()) {
ret_val.icmi() = single_value->field_icmi.valueof();
}
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_start__mode.is_bound()) {
ret_val.start__mode() = single_value->field_start__mode.valueof();
}
if (single_value->field_codec__modes.is_bound()) {
ret_val.codec__modes() = single_value->field_codec__modes.valueof();
}
if (single_value->field_parameters.is_bound()) {
ret_val.parameters() = single_value->field_parameters.valueof();
}
return ret_val;
}

void RSL__IE__MultirateCfg_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_MultirateCfg.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__MultirateCfg_template[list_length];
}

RSL__IE__MultirateCfg_template& RSL__IE__MultirateCfg_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_MultirateCfg.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_MultirateCfg.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__MultirateCfg_template::len()
{
set_specific();
return single_value->field_len;
}

const INTEGER_template& RSL__IE__MultirateCfg_template::len() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len of a non-specific template of type @RSL_Types.RSL_IE_MultirateCfg.");
return single_value->field_len;
}

INTEGER_template& RSL__IE__MultirateCfg_template::mr__speech__ver()
{
set_specific();
return single_value->field_mr__speech__ver;
}

const INTEGER_template& RSL__IE__MultirateCfg_template::mr__speech__ver() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mr_speech_ver of a non-specific template of type @RSL_Types.RSL_IE_MultirateCfg.");
return single_value->field_mr__speech__ver;
}

BOOLEAN_template& RSL__IE__MultirateCfg_template::nscb()
{
set_specific();
return single_value->field_nscb;
}

const BOOLEAN_template& RSL__IE__MultirateCfg_template::nscb() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nscb of a non-specific template of type @RSL_Types.RSL_IE_MultirateCfg.");
return single_value->field_nscb;
}

BOOLEAN_template& RSL__IE__MultirateCfg_template::icmi()
{
set_specific();
return single_value->field_icmi;
}

const BOOLEAN_template& RSL__IE__MultirateCfg_template::icmi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field icmi of a non-specific template of type @RSL_Types.RSL_IE_MultirateCfg.");
return single_value->field_icmi;
}

BITSTRING_template& RSL__IE__MultirateCfg_template::spare()
{
set_specific();
return single_value->field_spare;
}

const BITSTRING_template& RSL__IE__MultirateCfg_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @RSL_Types.RSL_IE_MultirateCfg.");
return single_value->field_spare;
}

INTEGER_template& RSL__IE__MultirateCfg_template::start__mode()
{
set_specific();
return single_value->field_start__mode;
}

const INTEGER_template& RSL__IE__MultirateCfg_template::start__mode() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field start_mode of a non-specific template of type @RSL_Types.RSL_IE_MultirateCfg.");
return single_value->field_start__mode;
}

BITSTRING_template& RSL__IE__MultirateCfg_template::codec__modes()
{
set_specific();
return single_value->field_codec__modes;
}

const BITSTRING_template& RSL__IE__MultirateCfg_template::codec__modes() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field codec_modes of a non-specific template of type @RSL_Types.RSL_IE_MultirateCfg.");
return single_value->field_codec__modes;
}

OCTETSTRING_template& RSL__IE__MultirateCfg_template::parameters()
{
set_specific();
return single_value->field_parameters;
}

const OCTETSTRING_template& RSL__IE__MultirateCfg_template::parameters() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field parameters of a non-specific template of type @RSL_Types.RSL_IE_MultirateCfg.");
return single_value->field_parameters;
}

int RSL__IE__MultirateCfg_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCfg which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 8;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCfg containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCfg containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCfg containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCfg containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCfg containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCfg containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCfg containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCfg containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_MultirateCfg.");
  }
  return 0;
}

void RSL__IE__MultirateCfg_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log();
TTCN_Logger::log_event_str(", mr_speech_ver := ");
single_value->field_mr__speech__ver.log();
TTCN_Logger::log_event_str(", nscb := ");
single_value->field_nscb.log();
TTCN_Logger::log_event_str(", icmi := ");
single_value->field_icmi.log();
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", start_mode := ");
single_value->field_start__mode.log();
TTCN_Logger::log_event_str(", codec_modes := ");
single_value->field_codec__modes.log();
TTCN_Logger::log_event_str(", parameters := ");
single_value->field_parameters.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__MultirateCfg_template::log_match(const RSL__IE__MultirateCfg& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_len.match(match_value.len(), legacy)){
TTCN_Logger::log_logmatch_info(".len");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_mr__speech__ver.match(match_value.mr__speech__ver(), legacy)){
TTCN_Logger::log_logmatch_info(".mr_speech_ver");
single_value->field_mr__speech__ver.log_match(match_value.mr__speech__ver(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_nscb.match(match_value.nscb(), legacy)){
TTCN_Logger::log_logmatch_info(".nscb");
single_value->field_nscb.log_match(match_value.nscb(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_icmi.match(match_value.icmi(), legacy)){
TTCN_Logger::log_logmatch_info(".icmi");
single_value->field_icmi.log_match(match_value.icmi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_start__mode.match(match_value.start__mode(), legacy)){
TTCN_Logger::log_logmatch_info(".start_mode");
single_value->field_start__mode.log_match(match_value.start__mode(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_codec__modes.match(match_value.codec__modes(), legacy)){
TTCN_Logger::log_logmatch_info(".codec_modes");
single_value->field_codec__modes.log_match(match_value.codec__modes(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_parameters.match(match_value.parameters(), legacy)){
TTCN_Logger::log_logmatch_info(".parameters");
single_value->field_parameters.log_match(match_value.parameters(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::log_event_str(", mr_speech_ver := ");
single_value->field_mr__speech__ver.log_match(match_value.mr__speech__ver(), legacy);
TTCN_Logger::log_event_str(", nscb := ");
single_value->field_nscb.log_match(match_value.nscb(), legacy);
TTCN_Logger::log_event_str(", icmi := ");
single_value->field_icmi.log_match(match_value.icmi(), legacy);
TTCN_Logger::log_event_str(", spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", start_mode := ");
single_value->field_start__mode.log_match(match_value.start__mode(), legacy);
TTCN_Logger::log_event_str(", codec_modes := ");
single_value->field_codec__modes.log_match(match_value.codec__modes(), legacy);
TTCN_Logger::log_event_str(", parameters := ");
single_value->field_parameters.log_match(match_value.parameters(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__MultirateCfg_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (len().is_bound()) len().set_implicit_omit();
if (mr__speech__ver().is_bound()) mr__speech__ver().set_implicit_omit();
if (nscb().is_bound()) nscb().set_implicit_omit();
if (icmi().is_bound()) icmi().set_implicit_omit();
if (spare().is_bound()) spare().set_implicit_omit();
if (start__mode().is_bound()) start__mode().set_implicit_omit();
if (codec__modes().is_bound()) codec__modes().set_implicit_omit();
if (parameters().is_bound()) parameters().set_implicit_omit();
}

void RSL__IE__MultirateCfg_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_len.encode_text(text_buf);
single_value->field_mr__speech__ver.encode_text(text_buf);
single_value->field_nscb.encode_text(text_buf);
single_value->field_icmi.encode_text(text_buf);
single_value->field_spare.encode_text(text_buf);
single_value->field_start__mode.encode_text(text_buf);
single_value->field_codec__modes.encode_text(text_buf);
single_value->field_parameters.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_MultirateCfg.");
}
}

void RSL__IE__MultirateCfg_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_len.decode_text(text_buf);
single_value->field_mr__speech__ver.decode_text(text_buf);
single_value->field_nscb.decode_text(text_buf);
single_value->field_icmi.decode_text(text_buf);
single_value->field_spare.decode_text(text_buf);
single_value->field_start__mode.decode_text(text_buf);
single_value->field_codec__modes.decode_text(text_buf);
single_value->field_parameters.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__MultirateCfg_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_MultirateCfg.");
}
}

void RSL__IE__MultirateCfg_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__MultirateCfg_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_MultirateCfg has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) mr__speech__ver().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) nscb().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) icmi().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) start__mode().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) codec__modes().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) parameters().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mr_speech_ver")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mr__speech__ver().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nscb")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nscb().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "icmi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          icmi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "start_mode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          start__mode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "codec_modes")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          codec__modes().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "parameters")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          parameters().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_MultirateCfg: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__MultirateCfg_template* precondition = new RSL__IE__MultirateCfg_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__MultirateCfg_template* implied_template = new RSL__IE__MultirateCfg_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__MultirateCfg_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_MultirateCfg");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__MultirateCfg_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_len.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCfg");
single_value->field_mr__speech__ver.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCfg");
single_value->field_nscb.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCfg");
single_value->field_icmi.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCfg");
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCfg");
single_value->field_start__mode.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCfg");
single_value->field_codec__modes.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCfg");
single_value->field_parameters.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCfg");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCfg");
}

boolean RSL__IE__MultirateCfg_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__MultirateCfg_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IE__MultirateCtrl::RSL__IE__MultirateCtrl()
{
}

RSL__IE__MultirateCtrl::RSL__IE__MultirateCtrl(const INTEGER& par_spare,
    const BOOLEAN& par_od,
    const BOOLEAN& par_pre,
    const INTEGER& par_rae,
    const BOOLEAN& par_tfo)
  :   field_spare(par_spare),
  field_od(par_od),
  field_pre(par_pre),
  field_rae(par_rae),
  field_tfo(par_tfo)
{
}

RSL__IE__MultirateCtrl::RSL__IE__MultirateCtrl(const RSL__IE__MultirateCtrl& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_MultirateCtrl.");
if (other_value.spare().is_bound()) field_spare = other_value.spare();
else field_spare.clean_up();
if (other_value.od().is_bound()) field_od = other_value.od();
else field_od.clean_up();
if (other_value.pre().is_bound()) field_pre = other_value.pre();
else field_pre.clean_up();
if (other_value.rae().is_bound()) field_rae = other_value.rae();
else field_rae.clean_up();
if (other_value.tfo().is_bound()) field_tfo = other_value.tfo();
else field_tfo.clean_up();
}

void RSL__IE__MultirateCtrl::clean_up()
{
field_spare.clean_up();
field_od.clean_up();
field_pre.clean_up();
field_rae.clean_up();
field_tfo.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__MultirateCtrl::get_descriptor() const { return &RSL__IE__MultirateCtrl_descr_; }
RSL__IE__MultirateCtrl& RSL__IE__MultirateCtrl::operator=(const RSL__IE__MultirateCtrl& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_MultirateCtrl.");
  if (other_value.spare().is_bound()) field_spare = other_value.spare();
  else field_spare.clean_up();
  if (other_value.od().is_bound()) field_od = other_value.od();
  else field_od.clean_up();
  if (other_value.pre().is_bound()) field_pre = other_value.pre();
  else field_pre.clean_up();
  if (other_value.rae().is_bound()) field_rae = other_value.rae();
  else field_rae.clean_up();
  if (other_value.tfo().is_bound()) field_tfo = other_value.tfo();
  else field_tfo.clean_up();
}
return *this;
}

boolean RSL__IE__MultirateCtrl::operator==(const RSL__IE__MultirateCtrl& other_value) const
{
return field_spare==other_value.field_spare
  && field_od==other_value.field_od
  && field_pre==other_value.field_pre
  && field_rae==other_value.field_rae
  && field_tfo==other_value.field_tfo;
}

boolean RSL__IE__MultirateCtrl::is_bound() const
{
return (field_spare.is_bound())
  || (field_od.is_bound())
  || (field_pre.is_bound())
  || (field_rae.is_bound())
  || (field_tfo.is_bound());
}
boolean RSL__IE__MultirateCtrl::is_value() const
{
return field_spare.is_value()
  && field_od.is_value()
  && field_pre.is_value()
  && field_rae.is_value()
  && field_tfo.is_value();
}
void RSL__IE__MultirateCtrl::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ spare := ");
field_spare.log();
TTCN_Logger::log_event_str(", od := ");
field_od.log();
TTCN_Logger::log_event_str(", pre := ");
field_pre.log();
TTCN_Logger::log_event_str(", rae := ");
field_rae.log();
TTCN_Logger::log_event_str(", tfo := ");
field_tfo.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__MultirateCtrl::set_implicit_omit()
{
if (spare().is_bound()) spare().set_implicit_omit();
if (od().is_bound()) od().set_implicit_omit();
if (pre().is_bound()) pre().set_implicit_omit();
if (rae().is_bound()) rae().set_implicit_omit();
if (tfo().is_bound()) tfo().set_implicit_omit();
}

void RSL__IE__MultirateCtrl::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_MultirateCtrl has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) od().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) pre().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rae().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) tfo().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "od")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          od().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pre")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pre().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rae")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rae().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tfo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tfo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_MultirateCtrl: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_MultirateCtrl");
  }
}

void RSL__IE__MultirateCtrl::encode_text(Text_Buf& text_buf) const
{
field_spare.encode_text(text_buf);
field_od.encode_text(text_buf);
field_pre.encode_text(text_buf);
field_rae.encode_text(text_buf);
field_tfo.encode_text(text_buf);
}

void RSL__IE__MultirateCtrl::decode_text(Text_Buf& text_buf)
{
field_spare.decode_text(text_buf);
field_od.decode_text(text_buf);
field_pre.decode_text(text_buf);
field_rae.decode_text(text_buf);
field_tfo.decode_text(text_buf);
}

void RSL__IE__MultirateCtrl::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__MultirateCtrl::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__MultirateCtrl::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__MultirateCtrl_spare_descr_.raw->forceomit);
  decoded_field_length = field_spare.RAW_decode(RSL__IE__MultirateCtrl_spare_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__MultirateCtrl_od_descr_.raw->forceomit);
  decoded_field_length = field_od.RAW_decode(RSL__IE__MultirateCtrl_od_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, RSL__IE__MultirateCtrl_pre_descr_.raw->forceomit);
  decoded_field_length = field_pre.RAW_decode(RSL__IE__MultirateCtrl_pre_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_3_force_omit(3, force_omit, RSL__IE__MultirateCtrl_rae_descr_.raw->forceomit);
  decoded_field_length = field_rae.RAW_decode(RSL__IE__MultirateCtrl_rae_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_4_force_omit(4, force_omit, RSL__IE__MultirateCtrl_tfo_descr_.raw->forceomit);
  decoded_field_length = field_tfo.RAW_decode(RSL__IE__MultirateCtrl_tfo_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__MultirateCtrl::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__MultirateCtrl_spare_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__MultirateCtrl_od_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RSL__IE__MultirateCtrl_pre_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, RSL__IE__MultirateCtrl_rae_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, RSL__IE__MultirateCtrl_tfo_descr_.raw);
  encoded_length += field_spare.RAW_encode(RSL__IE__MultirateCtrl_spare_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_od.RAW_encode(RSL__IE__MultirateCtrl_od_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_pre.RAW_encode(RSL__IE__MultirateCtrl_pre_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_rae.RAW_encode(RSL__IE__MultirateCtrl_rae_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_tfo.RAW_encode(RSL__IE__MultirateCtrl_tfo_descr_, *myleaf.body.node.nodes[4]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__MultirateCtrl_template::single_value_struct {
INTEGER_template field_spare;
BOOLEAN_template field_od;
BOOLEAN_template field_pre;
INTEGER_template field_rae;
BOOLEAN_template field_tfo;
};

void RSL__IE__MultirateCtrl_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_spare = ANY_VALUE;
single_value->field_od = ANY_VALUE;
single_value->field_pre = ANY_VALUE;
single_value->field_rae = ANY_VALUE;
single_value->field_tfo = ANY_VALUE;
}
}
}

void RSL__IE__MultirateCtrl_template::copy_value(const RSL__IE__MultirateCtrl& other_value)
{
single_value = new single_value_struct;
if (other_value.spare().is_bound()) {
  single_value->field_spare = other_value.spare();
} else {
  single_value->field_spare.clean_up();
}
if (other_value.od().is_bound()) {
  single_value->field_od = other_value.od();
} else {
  single_value->field_od.clean_up();
}
if (other_value.pre().is_bound()) {
  single_value->field_pre = other_value.pre();
} else {
  single_value->field_pre.clean_up();
}
if (other_value.rae().is_bound()) {
  single_value->field_rae = other_value.rae();
} else {
  single_value->field_rae.clean_up();
}
if (other_value.tfo().is_bound()) {
  single_value->field_tfo = other_value.tfo();
} else {
  single_value->field_tfo.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__MultirateCtrl_template::copy_template(const RSL__IE__MultirateCtrl_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.spare().get_selection()) {
single_value->field_spare = other_value.spare();
} else {
single_value->field_spare.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.od().get_selection()) {
single_value->field_od = other_value.od();
} else {
single_value->field_od.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pre().get_selection()) {
single_value->field_pre = other_value.pre();
} else {
single_value->field_pre.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rae().get_selection()) {
single_value->field_rae = other_value.rae();
} else {
single_value->field_rae.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tfo().get_selection()) {
single_value->field_tfo = other_value.tfo();
} else {
single_value->field_tfo.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__MultirateCtrl_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__MultirateCtrl_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__MultirateCtrl_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_MultirateCtrl.");
break;
}
set_selection(other_value);
}

RSL__IE__MultirateCtrl_template::RSL__IE__MultirateCtrl_template()
{
}

RSL__IE__MultirateCtrl_template::RSL__IE__MultirateCtrl_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__MultirateCtrl_template::RSL__IE__MultirateCtrl_template(const RSL__IE__MultirateCtrl& other_value)
{
copy_value(other_value);
}

RSL__IE__MultirateCtrl_template::RSL__IE__MultirateCtrl_template(const OPTIONAL<RSL__IE__MultirateCtrl>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__MultirateCtrl&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_MultirateCtrl from an unbound optional field.");
}
}

RSL__IE__MultirateCtrl_template::RSL__IE__MultirateCtrl_template(RSL__IE__MultirateCtrl_template* p_precondition, RSL__IE__MultirateCtrl_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__MultirateCtrl_template::RSL__IE__MultirateCtrl_template(Dynamic_Match_Interface<RSL__IE__MultirateCtrl>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__MultirateCtrl>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__MultirateCtrl_template::RSL__IE__MultirateCtrl_template(const RSL__IE__MultirateCtrl_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__MultirateCtrl_template::~RSL__IE__MultirateCtrl_template()
{
clean_up();
}

RSL__IE__MultirateCtrl_template& RSL__IE__MultirateCtrl_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__MultirateCtrl_template& RSL__IE__MultirateCtrl_template::operator=(const RSL__IE__MultirateCtrl& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__MultirateCtrl_template& RSL__IE__MultirateCtrl_template::operator=(const OPTIONAL<RSL__IE__MultirateCtrl>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__MultirateCtrl&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_MultirateCtrl.");
}
return *this;
}

RSL__IE__MultirateCtrl_template& RSL__IE__MultirateCtrl_template::operator=(const RSL__IE__MultirateCtrl_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__MultirateCtrl_template::match(const RSL__IE__MultirateCtrl& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.spare().is_bound()) return FALSE;
if(!single_value->field_spare.match(other_value.spare(), legacy))return FALSE;
if(!other_value.od().is_bound()) return FALSE;
if(!single_value->field_od.match(other_value.od(), legacy))return FALSE;
if(!other_value.pre().is_bound()) return FALSE;
if(!single_value->field_pre.match(other_value.pre(), legacy))return FALSE;
if(!other_value.rae().is_bound()) return FALSE;
if(!single_value->field_rae.match(other_value.rae(), legacy))return FALSE;
if(!other_value.tfo().is_bound()) return FALSE;
if(!single_value->field_tfo.match(other_value.tfo(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_MultirateCtrl.");
}
return FALSE;
}

boolean RSL__IE__MultirateCtrl_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_spare.is_bound()
 || single_value->field_od.is_bound()
 || single_value->field_pre.is_bound()
 || single_value->field_rae.is_bound()
 || single_value->field_tfo.is_bound();
}

boolean RSL__IE__MultirateCtrl_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_spare.is_value()
 && single_value->field_od.is_value()
 && single_value->field_pre.is_value()
 && single_value->field_rae.is_value()
 && single_value->field_tfo.is_value();
}

void RSL__IE__MultirateCtrl_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__MultirateCtrl RSL__IE__MultirateCtrl_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_MultirateCtrl.");
RSL__IE__MultirateCtrl ret_val;
if (single_value->field_spare.is_bound()) {
ret_val.spare() = single_value->field_spare.valueof();
}
if (single_value->field_od.is_bound()) {
ret_val.od() = single_value->field_od.valueof();
}
if (single_value->field_pre.is_bound()) {
ret_val.pre() = single_value->field_pre.valueof();
}
if (single_value->field_rae.is_bound()) {
ret_val.rae() = single_value->field_rae.valueof();
}
if (single_value->field_tfo.is_bound()) {
ret_val.tfo() = single_value->field_tfo.valueof();
}
return ret_val;
}

void RSL__IE__MultirateCtrl_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_MultirateCtrl.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__MultirateCtrl_template[list_length];
}

RSL__IE__MultirateCtrl_template& RSL__IE__MultirateCtrl_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_MultirateCtrl.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_MultirateCtrl.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__MultirateCtrl_template::spare()
{
set_specific();
return single_value->field_spare;
}

const INTEGER_template& RSL__IE__MultirateCtrl_template::spare() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field spare of a non-specific template of type @RSL_Types.RSL_IE_MultirateCtrl.");
return single_value->field_spare;
}

BOOLEAN_template& RSL__IE__MultirateCtrl_template::od()
{
set_specific();
return single_value->field_od;
}

const BOOLEAN_template& RSL__IE__MultirateCtrl_template::od() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field od of a non-specific template of type @RSL_Types.RSL_IE_MultirateCtrl.");
return single_value->field_od;
}

BOOLEAN_template& RSL__IE__MultirateCtrl_template::pre()
{
set_specific();
return single_value->field_pre;
}

const BOOLEAN_template& RSL__IE__MultirateCtrl_template::pre() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pre of a non-specific template of type @RSL_Types.RSL_IE_MultirateCtrl.");
return single_value->field_pre;
}

INTEGER_template& RSL__IE__MultirateCtrl_template::rae()
{
set_specific();
return single_value->field_rae;
}

const INTEGER_template& RSL__IE__MultirateCtrl_template::rae() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rae of a non-specific template of type @RSL_Types.RSL_IE_MultirateCtrl.");
return single_value->field_rae;
}

BOOLEAN_template& RSL__IE__MultirateCtrl_template::tfo()
{
set_specific();
return single_value->field_tfo;
}

const BOOLEAN_template& RSL__IE__MultirateCtrl_template::tfo() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tfo of a non-specific template of type @RSL_Types.RSL_IE_MultirateCtrl.");
return single_value->field_tfo;
}

int RSL__IE__MultirateCtrl_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCtrl which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCtrl containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCtrl containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCtrl containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCtrl containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCtrl containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCtrl containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCtrl containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_MultirateCtrl containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_MultirateCtrl.");
  }
  return 0;
}

void RSL__IE__MultirateCtrl_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ spare := ");
single_value->field_spare.log();
TTCN_Logger::log_event_str(", od := ");
single_value->field_od.log();
TTCN_Logger::log_event_str(", pre := ");
single_value->field_pre.log();
TTCN_Logger::log_event_str(", rae := ");
single_value->field_rae.log();
TTCN_Logger::log_event_str(", tfo := ");
single_value->field_tfo.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__MultirateCtrl_template::log_match(const RSL__IE__MultirateCtrl& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_spare.match(match_value.spare(), legacy)){
TTCN_Logger::log_logmatch_info(".spare");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_od.match(match_value.od(), legacy)){
TTCN_Logger::log_logmatch_info(".od");
single_value->field_od.log_match(match_value.od(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_pre.match(match_value.pre(), legacy)){
TTCN_Logger::log_logmatch_info(".pre");
single_value->field_pre.log_match(match_value.pre(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rae.match(match_value.rae(), legacy)){
TTCN_Logger::log_logmatch_info(".rae");
single_value->field_rae.log_match(match_value.rae(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_tfo.match(match_value.tfo(), legacy)){
TTCN_Logger::log_logmatch_info(".tfo");
single_value->field_tfo.log_match(match_value.tfo(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ spare := ");
single_value->field_spare.log_match(match_value.spare(), legacy);
TTCN_Logger::log_event_str(", od := ");
single_value->field_od.log_match(match_value.od(), legacy);
TTCN_Logger::log_event_str(", pre := ");
single_value->field_pre.log_match(match_value.pre(), legacy);
TTCN_Logger::log_event_str(", rae := ");
single_value->field_rae.log_match(match_value.rae(), legacy);
TTCN_Logger::log_event_str(", tfo := ");
single_value->field_tfo.log_match(match_value.tfo(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__MultirateCtrl_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (spare().is_bound()) spare().set_implicit_omit();
if (od().is_bound()) od().set_implicit_omit();
if (pre().is_bound()) pre().set_implicit_omit();
if (rae().is_bound()) rae().set_implicit_omit();
if (tfo().is_bound()) tfo().set_implicit_omit();
}

void RSL__IE__MultirateCtrl_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_spare.encode_text(text_buf);
single_value->field_od.encode_text(text_buf);
single_value->field_pre.encode_text(text_buf);
single_value->field_rae.encode_text(text_buf);
single_value->field_tfo.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_MultirateCtrl.");
}
}

void RSL__IE__MultirateCtrl_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_spare.decode_text(text_buf);
single_value->field_od.decode_text(text_buf);
single_value->field_pre.decode_text(text_buf);
single_value->field_rae.decode_text(text_buf);
single_value->field_tfo.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__MultirateCtrl_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_MultirateCtrl.");
}
}

void RSL__IE__MultirateCtrl_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__MultirateCtrl_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_MultirateCtrl has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) spare().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) od().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) pre().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rae().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) tfo().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "spare")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          spare().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "od")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          od().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pre")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pre().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rae")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rae().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tfo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tfo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_MultirateCtrl: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__MultirateCtrl_template* precondition = new RSL__IE__MultirateCtrl_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__MultirateCtrl_template* implied_template = new RSL__IE__MultirateCtrl_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__MultirateCtrl_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_MultirateCtrl");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__MultirateCtrl_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_spare.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCtrl");
single_value->field_od.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCtrl");
single_value->field_pre.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCtrl");
single_value->field_rae.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCtrl");
single_value->field_tfo.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCtrl");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_MultirateCtrl");
}

boolean RSL__IE__MultirateCtrl_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__MultirateCtrl_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IE__IPA__ConnectionStats::RSL__IE__IPA__ConnectionStats()
{
}

RSL__IE__IPA__ConnectionStats::RSL__IE__IPA__ConnectionStats(const INTEGER& par_len,
    const INTEGER& par_tx__packets,
    const INTEGER& par_tx__octets,
    const INTEGER& par_rx__packets,
    const INTEGER& par_rx__octets,
    const INTEGER& par_lost__packets,
    const INTEGER& par_jitter,
    const INTEGER& par_avg__delay)
  :   field_len(par_len),
  field_tx__packets(par_tx__packets),
  field_tx__octets(par_tx__octets),
  field_rx__packets(par_rx__packets),
  field_rx__octets(par_rx__octets),
  field_lost__packets(par_lost__packets),
  field_jitter(par_jitter),
  field_avg__delay(par_avg__delay)
{
}

RSL__IE__IPA__ConnectionStats::RSL__IE__IPA__ConnectionStats(const RSL__IE__IPA__ConnectionStats& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.tx__packets().is_bound()) field_tx__packets = other_value.tx__packets();
else field_tx__packets.clean_up();
if (other_value.tx__octets().is_bound()) field_tx__octets = other_value.tx__octets();
else field_tx__octets.clean_up();
if (other_value.rx__packets().is_bound()) field_rx__packets = other_value.rx__packets();
else field_rx__packets.clean_up();
if (other_value.rx__octets().is_bound()) field_rx__octets = other_value.rx__octets();
else field_rx__octets.clean_up();
if (other_value.lost__packets().is_bound()) field_lost__packets = other_value.lost__packets();
else field_lost__packets.clean_up();
if (other_value.jitter().is_bound()) field_jitter = other_value.jitter();
else field_jitter.clean_up();
if (other_value.avg__delay().is_bound()) field_avg__delay = other_value.avg__delay();
else field_avg__delay.clean_up();
}

void RSL__IE__IPA__ConnectionStats::clean_up()
{
field_len.clean_up();
field_tx__packets.clean_up();
field_tx__octets.clean_up();
field_rx__packets.clean_up();
field_rx__octets.clean_up();
field_lost__packets.clean_up();
field_jitter.clean_up();
field_avg__delay.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__IPA__ConnectionStats::get_descriptor() const { return &RSL__IE__IPA__ConnectionStats_descr_; }
RSL__IE__IPA__ConnectionStats& RSL__IE__IPA__ConnectionStats::operator=(const RSL__IE__IPA__ConnectionStats& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.tx__packets().is_bound()) field_tx__packets = other_value.tx__packets();
  else field_tx__packets.clean_up();
  if (other_value.tx__octets().is_bound()) field_tx__octets = other_value.tx__octets();
  else field_tx__octets.clean_up();
  if (other_value.rx__packets().is_bound()) field_rx__packets = other_value.rx__packets();
  else field_rx__packets.clean_up();
  if (other_value.rx__octets().is_bound()) field_rx__octets = other_value.rx__octets();
  else field_rx__octets.clean_up();
  if (other_value.lost__packets().is_bound()) field_lost__packets = other_value.lost__packets();
  else field_lost__packets.clean_up();
  if (other_value.jitter().is_bound()) field_jitter = other_value.jitter();
  else field_jitter.clean_up();
  if (other_value.avg__delay().is_bound()) field_avg__delay = other_value.avg__delay();
  else field_avg__delay.clean_up();
}
return *this;
}

boolean RSL__IE__IPA__ConnectionStats::operator==(const RSL__IE__IPA__ConnectionStats& other_value) const
{
return field_len==other_value.field_len
  && field_tx__packets==other_value.field_tx__packets
  && field_tx__octets==other_value.field_tx__octets
  && field_rx__packets==other_value.field_rx__packets
  && field_rx__octets==other_value.field_rx__octets
  && field_lost__packets==other_value.field_lost__packets
  && field_jitter==other_value.field_jitter
  && field_avg__delay==other_value.field_avg__delay;
}

boolean RSL__IE__IPA__ConnectionStats::is_bound() const
{
return (field_len.is_bound())
  || (field_tx__packets.is_bound())
  || (field_tx__octets.is_bound())
  || (field_rx__packets.is_bound())
  || (field_rx__octets.is_bound())
  || (field_lost__packets.is_bound())
  || (field_jitter.is_bound())
  || (field_avg__delay.is_bound());
}
boolean RSL__IE__IPA__ConnectionStats::is_value() const
{
return field_len.is_value()
  && field_tx__packets.is_value()
  && field_tx__octets.is_value()
  && field_rx__packets.is_value()
  && field_rx__octets.is_value()
  && field_lost__packets.is_value()
  && field_jitter.is_value()
  && field_avg__delay.is_value();
}
void RSL__IE__IPA__ConnectionStats::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len := ");
field_len.log();
TTCN_Logger::log_event_str(", tx_packets := ");
field_tx__packets.log();
TTCN_Logger::log_event_str(", tx_octets := ");
field_tx__octets.log();
TTCN_Logger::log_event_str(", rx_packets := ");
field_rx__packets.log();
TTCN_Logger::log_event_str(", rx_octets := ");
field_rx__octets.log();
TTCN_Logger::log_event_str(", lost_packets := ");
field_lost__packets.log();
TTCN_Logger::log_event_str(", jitter := ");
field_jitter.log();
TTCN_Logger::log_event_str(", avg_delay := ");
field_avg__delay.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__IPA__ConnectionStats::set_implicit_omit()
{
if (len().is_bound()) len().set_implicit_omit();
if (tx__packets().is_bound()) tx__packets().set_implicit_omit();
if (tx__octets().is_bound()) tx__octets().set_implicit_omit();
if (rx__packets().is_bound()) rx__packets().set_implicit_omit();
if (rx__octets().is_bound()) rx__octets().set_implicit_omit();
if (lost__packets().is_bound()) lost__packets().set_implicit_omit();
if (jitter().is_bound()) jitter().set_implicit_omit();
if (avg__delay().is_bound()) avg__delay().set_implicit_omit();
}

void RSL__IE__IPA__ConnectionStats::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_IPA_ConnectionStats has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) tx__packets().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) tx__octets().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rx__packets().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) rx__octets().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) lost__packets().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) jitter().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) avg__delay().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tx_packets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tx__packets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tx_octets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tx__octets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rx_packets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rx__packets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rx_octets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rx__octets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lost_packets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lost__packets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "jitter")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          jitter().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "avg_delay")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          avg__delay().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_IPA_ConnectionStats: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_IPA_ConnectionStats");
  }
}

void RSL__IE__IPA__ConnectionStats::encode_text(Text_Buf& text_buf) const
{
field_len.encode_text(text_buf);
field_tx__packets.encode_text(text_buf);
field_tx__octets.encode_text(text_buf);
field_rx__packets.encode_text(text_buf);
field_rx__octets.encode_text(text_buf);
field_lost__packets.encode_text(text_buf);
field_jitter.encode_text(text_buf);
field_avg__delay.encode_text(text_buf);
}

void RSL__IE__IPA__ConnectionStats::decode_text(Text_Buf& text_buf)
{
field_len.decode_text(text_buf);
field_tx__packets.decode_text(text_buf);
field_tx__octets.decode_text(text_buf);
field_rx__packets.decode_text(text_buf);
field_rx__octets.decode_text(text_buf);
field_lost__packets.decode_text(text_buf);
field_jitter.decode_text(text_buf);
field_avg__delay.decode_text(text_buf);
}

void RSL__IE__IPA__ConnectionStats::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__IPA__ConnectionStats::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__IPA__ConnectionStats::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__IPA__ConnectionStats_len_descr_.raw->forceomit);
  decoded_field_length = field_len.RAW_decode(RSL__IE__IPA__ConnectionStats_len_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_len.convert_to_Integer(RSL__IE__IPA__ConnectionStats_len_descr_);
  field_len = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__IPA__ConnectionStats_tx__packets_descr_.raw->forceomit);
  decoded_field_length = field_tx__packets.RAW_decode(RSL__IE__IPA__ConnectionStats_tx__packets_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RSL__IE__IPA__ConnectionStats_tx__octets_descr_.raw->forceomit);
  decoded_field_length = field_tx__octets.RAW_decode(RSL__IE__IPA__ConnectionStats_tx__octets_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, RSL__IE__IPA__ConnectionStats_rx__packets_descr_.raw->forceomit);
  decoded_field_length = field_rx__packets.RAW_decode(RSL__IE__IPA__ConnectionStats_rx__packets_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, RSL__IE__IPA__ConnectionStats_rx__octets_descr_.raw->forceomit);
  decoded_field_length = field_rx__octets.RAW_decode(RSL__IE__IPA__ConnectionStats_rx__octets_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_5_force_omit(5, force_omit, RSL__IE__IPA__ConnectionStats_lost__packets_descr_.raw->forceomit);
  decoded_field_length = field_lost__packets.RAW_decode(RSL__IE__IPA__ConnectionStats_lost__packets_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_6_force_omit(6, force_omit, RSL__IE__IPA__ConnectionStats_jitter_descr_.raw->forceomit);
  decoded_field_length = field_jitter.RAW_decode(RSL__IE__IPA__ConnectionStats_jitter_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_7_force_omit(7, force_omit, RSL__IE__IPA__ConnectionStats_avg__delay_descr_.raw->forceomit);
  decoded_field_length = field_avg__delay.RAW_decode(RSL__IE__IPA__ConnectionStats_avg__delay_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__IPA__ConnectionStats::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 8;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(8);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__IPA__ConnectionStats_len_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__IPA__ConnectionStats_tx__packets_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RSL__IE__IPA__ConnectionStats_tx__octets_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, RSL__IE__IPA__ConnectionStats_rx__packets_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, RSL__IE__IPA__ConnectionStats_rx__octets_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, RSL__IE__IPA__ConnectionStats_lost__packets_descr_.raw);
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, RSL__IE__IPA__ConnectionStats_jitter_descr_.raw);
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, RSL__IE__IPA__ConnectionStats_avg__delay_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &RSL__IE__IPA__ConnectionStats_len_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 7;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(7);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[4].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[4].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[5].level = myleaf.body.node.nodes[6]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[5].pos = myleaf.body.node.nodes[6]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[6].level = myleaf.body.node.nodes[7]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[6].pos = myleaf.body.node.nodes[7]->curr_pos.pos;
  encoded_length += field_tx__packets.RAW_encode(RSL__IE__IPA__ConnectionStats_tx__packets_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_tx__octets.RAW_encode(RSL__IE__IPA__ConnectionStats_tx__octets_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_rx__packets.RAW_encode(RSL__IE__IPA__ConnectionStats_rx__packets_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_rx__octets.RAW_encode(RSL__IE__IPA__ConnectionStats_rx__octets_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_lost__packets.RAW_encode(RSL__IE__IPA__ConnectionStats_lost__packets_descr_, *myleaf.body.node.nodes[5]);
  encoded_length += field_jitter.RAW_encode(RSL__IE__IPA__ConnectionStats_jitter_descr_, *myleaf.body.node.nodes[6]);
  encoded_length += field_avg__delay.RAW_encode(RSL__IE__IPA__ConnectionStats_avg__delay_descr_, *myleaf.body.node.nodes[7]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__IPA__ConnectionStats_template::single_value_struct {
INTEGER_template field_len;
INTEGER_template field_tx__packets;
INTEGER_template field_tx__octets;
INTEGER_template field_rx__packets;
INTEGER_template field_rx__octets;
INTEGER_template field_lost__packets;
INTEGER_template field_jitter;
INTEGER_template field_avg__delay;
};

void RSL__IE__IPA__ConnectionStats_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_len = ANY_VALUE;
single_value->field_tx__packets = ANY_VALUE;
single_value->field_tx__octets = ANY_VALUE;
single_value->field_rx__packets = ANY_VALUE;
single_value->field_rx__octets = ANY_VALUE;
single_value->field_lost__packets = ANY_VALUE;
single_value->field_jitter = ANY_VALUE;
single_value->field_avg__delay = ANY_VALUE;
}
}
}

void RSL__IE__IPA__ConnectionStats_template::copy_value(const RSL__IE__IPA__ConnectionStats& other_value)
{
single_value = new single_value_struct;
if (other_value.len().is_bound()) {
  single_value->field_len = other_value.len();
} else {
  single_value->field_len.clean_up();
}
if (other_value.tx__packets().is_bound()) {
  single_value->field_tx__packets = other_value.tx__packets();
} else {
  single_value->field_tx__packets.clean_up();
}
if (other_value.tx__octets().is_bound()) {
  single_value->field_tx__octets = other_value.tx__octets();
} else {
  single_value->field_tx__octets.clean_up();
}
if (other_value.rx__packets().is_bound()) {
  single_value->field_rx__packets = other_value.rx__packets();
} else {
  single_value->field_rx__packets.clean_up();
}
if (other_value.rx__octets().is_bound()) {
  single_value->field_rx__octets = other_value.rx__octets();
} else {
  single_value->field_rx__octets.clean_up();
}
if (other_value.lost__packets().is_bound()) {
  single_value->field_lost__packets = other_value.lost__packets();
} else {
  single_value->field_lost__packets.clean_up();
}
if (other_value.jitter().is_bound()) {
  single_value->field_jitter = other_value.jitter();
} else {
  single_value->field_jitter.clean_up();
}
if (other_value.avg__delay().is_bound()) {
  single_value->field_avg__delay = other_value.avg__delay();
} else {
  single_value->field_avg__delay.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__IPA__ConnectionStats_template::copy_template(const RSL__IE__IPA__ConnectionStats_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.len().get_selection()) {
single_value->field_len = other_value.len();
} else {
single_value->field_len.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tx__packets().get_selection()) {
single_value->field_tx__packets = other_value.tx__packets();
} else {
single_value->field_tx__packets.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tx__octets().get_selection()) {
single_value->field_tx__octets = other_value.tx__octets();
} else {
single_value->field_tx__octets.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rx__packets().get_selection()) {
single_value->field_rx__packets = other_value.rx__packets();
} else {
single_value->field_rx__packets.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rx__octets().get_selection()) {
single_value->field_rx__octets = other_value.rx__octets();
} else {
single_value->field_rx__octets.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.lost__packets().get_selection()) {
single_value->field_lost__packets = other_value.lost__packets();
} else {
single_value->field_lost__packets.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.jitter().get_selection()) {
single_value->field_jitter = other_value.jitter();
} else {
single_value->field_jitter.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.avg__delay().get_selection()) {
single_value->field_avg__delay = other_value.avg__delay();
} else {
single_value->field_avg__delay.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__IPA__ConnectionStats_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__IPA__ConnectionStats_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__IPA__ConnectionStats_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
break;
}
set_selection(other_value);
}

RSL__IE__IPA__ConnectionStats_template::RSL__IE__IPA__ConnectionStats_template()
{
}

RSL__IE__IPA__ConnectionStats_template::RSL__IE__IPA__ConnectionStats_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__IPA__ConnectionStats_template::RSL__IE__IPA__ConnectionStats_template(const RSL__IE__IPA__ConnectionStats& other_value)
{
copy_value(other_value);
}

RSL__IE__IPA__ConnectionStats_template::RSL__IE__IPA__ConnectionStats_template(const OPTIONAL<RSL__IE__IPA__ConnectionStats>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__IPA__ConnectionStats&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats from an unbound optional field.");
}
}

RSL__IE__IPA__ConnectionStats_template::RSL__IE__IPA__ConnectionStats_template(RSL__IE__IPA__ConnectionStats_template* p_precondition, RSL__IE__IPA__ConnectionStats_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__IPA__ConnectionStats_template::RSL__IE__IPA__ConnectionStats_template(Dynamic_Match_Interface<RSL__IE__IPA__ConnectionStats>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__IPA__ConnectionStats>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__IPA__ConnectionStats_template::RSL__IE__IPA__ConnectionStats_template(const RSL__IE__IPA__ConnectionStats_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__IPA__ConnectionStats_template::~RSL__IE__IPA__ConnectionStats_template()
{
clean_up();
}

RSL__IE__IPA__ConnectionStats_template& RSL__IE__IPA__ConnectionStats_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__IPA__ConnectionStats_template& RSL__IE__IPA__ConnectionStats_template::operator=(const RSL__IE__IPA__ConnectionStats& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__IPA__ConnectionStats_template& RSL__IE__IPA__ConnectionStats_template::operator=(const OPTIONAL<RSL__IE__IPA__ConnectionStats>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__IPA__ConnectionStats&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
}
return *this;
}

RSL__IE__IPA__ConnectionStats_template& RSL__IE__IPA__ConnectionStats_template::operator=(const RSL__IE__IPA__ConnectionStats_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__IPA__ConnectionStats_template::match(const RSL__IE__IPA__ConnectionStats& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.len().is_bound()) return FALSE;
if(!single_value->field_len.match(other_value.len(), legacy))return FALSE;
if(!other_value.tx__packets().is_bound()) return FALSE;
if(!single_value->field_tx__packets.match(other_value.tx__packets(), legacy))return FALSE;
if(!other_value.tx__octets().is_bound()) return FALSE;
if(!single_value->field_tx__octets.match(other_value.tx__octets(), legacy))return FALSE;
if(!other_value.rx__packets().is_bound()) return FALSE;
if(!single_value->field_rx__packets.match(other_value.rx__packets(), legacy))return FALSE;
if(!other_value.rx__octets().is_bound()) return FALSE;
if(!single_value->field_rx__octets.match(other_value.rx__octets(), legacy))return FALSE;
if(!other_value.lost__packets().is_bound()) return FALSE;
if(!single_value->field_lost__packets.match(other_value.lost__packets(), legacy))return FALSE;
if(!other_value.jitter().is_bound()) return FALSE;
if(!single_value->field_jitter.match(other_value.jitter(), legacy))return FALSE;
if(!other_value.avg__delay().is_bound()) return FALSE;
if(!single_value->field_avg__delay.match(other_value.avg__delay(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
}
return FALSE;
}

boolean RSL__IE__IPA__ConnectionStats_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_len.is_bound()
 || single_value->field_tx__packets.is_bound()
 || single_value->field_tx__octets.is_bound()
 || single_value->field_rx__packets.is_bound()
 || single_value->field_rx__octets.is_bound()
 || single_value->field_lost__packets.is_bound()
 || single_value->field_jitter.is_bound()
 || single_value->field_avg__delay.is_bound();
}

boolean RSL__IE__IPA__ConnectionStats_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_len.is_value()
 && single_value->field_tx__packets.is_value()
 && single_value->field_tx__octets.is_value()
 && single_value->field_rx__packets.is_value()
 && single_value->field_rx__octets.is_value()
 && single_value->field_lost__packets.is_value()
 && single_value->field_jitter.is_value()
 && single_value->field_avg__delay.is_value();
}

void RSL__IE__IPA__ConnectionStats_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__IPA__ConnectionStats RSL__IE__IPA__ConnectionStats_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
RSL__IE__IPA__ConnectionStats ret_val;
if (single_value->field_len.is_bound()) {
ret_val.len() = single_value->field_len.valueof();
}
if (single_value->field_tx__packets.is_bound()) {
ret_val.tx__packets() = single_value->field_tx__packets.valueof();
}
if (single_value->field_tx__octets.is_bound()) {
ret_val.tx__octets() = single_value->field_tx__octets.valueof();
}
if (single_value->field_rx__packets.is_bound()) {
ret_val.rx__packets() = single_value->field_rx__packets.valueof();
}
if (single_value->field_rx__octets.is_bound()) {
ret_val.rx__octets() = single_value->field_rx__octets.valueof();
}
if (single_value->field_lost__packets.is_bound()) {
ret_val.lost__packets() = single_value->field_lost__packets.valueof();
}
if (single_value->field_jitter.is_bound()) {
ret_val.jitter() = single_value->field_jitter.valueof();
}
if (single_value->field_avg__delay.is_bound()) {
ret_val.avg__delay() = single_value->field_avg__delay.valueof();
}
return ret_val;
}

void RSL__IE__IPA__ConnectionStats_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__IPA__ConnectionStats_template[list_length];
}

RSL__IE__IPA__ConnectionStats_template& RSL__IE__IPA__ConnectionStats_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__IPA__ConnectionStats_template::len()
{
set_specific();
return single_value->field_len;
}

const INTEGER_template& RSL__IE__IPA__ConnectionStats_template::len() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len of a non-specific template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
return single_value->field_len;
}

INTEGER_template& RSL__IE__IPA__ConnectionStats_template::tx__packets()
{
set_specific();
return single_value->field_tx__packets;
}

const INTEGER_template& RSL__IE__IPA__ConnectionStats_template::tx__packets() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tx_packets of a non-specific template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
return single_value->field_tx__packets;
}

INTEGER_template& RSL__IE__IPA__ConnectionStats_template::tx__octets()
{
set_specific();
return single_value->field_tx__octets;
}

const INTEGER_template& RSL__IE__IPA__ConnectionStats_template::tx__octets() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tx_octets of a non-specific template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
return single_value->field_tx__octets;
}

INTEGER_template& RSL__IE__IPA__ConnectionStats_template::rx__packets()
{
set_specific();
return single_value->field_rx__packets;
}

const INTEGER_template& RSL__IE__IPA__ConnectionStats_template::rx__packets() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rx_packets of a non-specific template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
return single_value->field_rx__packets;
}

INTEGER_template& RSL__IE__IPA__ConnectionStats_template::rx__octets()
{
set_specific();
return single_value->field_rx__octets;
}

const INTEGER_template& RSL__IE__IPA__ConnectionStats_template::rx__octets() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rx_octets of a non-specific template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
return single_value->field_rx__octets;
}

INTEGER_template& RSL__IE__IPA__ConnectionStats_template::lost__packets()
{
set_specific();
return single_value->field_lost__packets;
}

const INTEGER_template& RSL__IE__IPA__ConnectionStats_template::lost__packets() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field lost_packets of a non-specific template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
return single_value->field_lost__packets;
}

INTEGER_template& RSL__IE__IPA__ConnectionStats_template::jitter()
{
set_specific();
return single_value->field_jitter;
}

const INTEGER_template& RSL__IE__IPA__ConnectionStats_template::jitter() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field jitter of a non-specific template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
return single_value->field_jitter;
}

INTEGER_template& RSL__IE__IPA__ConnectionStats_template::avg__delay()
{
set_specific();
return single_value->field_avg__delay;
}

const INTEGER_template& RSL__IE__IPA__ConnectionStats_template::avg__delay() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field avg_delay of a non-specific template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
return single_value->field_avg__delay;
}

int RSL__IE__IPA__ConnectionStats_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 8;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
  }
  return 0;
}

void RSL__IE__IPA__ConnectionStats_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log();
TTCN_Logger::log_event_str(", tx_packets := ");
single_value->field_tx__packets.log();
TTCN_Logger::log_event_str(", tx_octets := ");
single_value->field_tx__octets.log();
TTCN_Logger::log_event_str(", rx_packets := ");
single_value->field_rx__packets.log();
TTCN_Logger::log_event_str(", rx_octets := ");
single_value->field_rx__octets.log();
TTCN_Logger::log_event_str(", lost_packets := ");
single_value->field_lost__packets.log();
TTCN_Logger::log_event_str(", jitter := ");
single_value->field_jitter.log();
TTCN_Logger::log_event_str(", avg_delay := ");
single_value->field_avg__delay.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__IPA__ConnectionStats_template::log_match(const RSL__IE__IPA__ConnectionStats& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_len.match(match_value.len(), legacy)){
TTCN_Logger::log_logmatch_info(".len");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_tx__packets.match(match_value.tx__packets(), legacy)){
TTCN_Logger::log_logmatch_info(".tx_packets");
single_value->field_tx__packets.log_match(match_value.tx__packets(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_tx__octets.match(match_value.tx__octets(), legacy)){
TTCN_Logger::log_logmatch_info(".tx_octets");
single_value->field_tx__octets.log_match(match_value.tx__octets(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rx__packets.match(match_value.rx__packets(), legacy)){
TTCN_Logger::log_logmatch_info(".rx_packets");
single_value->field_rx__packets.log_match(match_value.rx__packets(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rx__octets.match(match_value.rx__octets(), legacy)){
TTCN_Logger::log_logmatch_info(".rx_octets");
single_value->field_rx__octets.log_match(match_value.rx__octets(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_lost__packets.match(match_value.lost__packets(), legacy)){
TTCN_Logger::log_logmatch_info(".lost_packets");
single_value->field_lost__packets.log_match(match_value.lost__packets(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_jitter.match(match_value.jitter(), legacy)){
TTCN_Logger::log_logmatch_info(".jitter");
single_value->field_jitter.log_match(match_value.jitter(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_avg__delay.match(match_value.avg__delay(), legacy)){
TTCN_Logger::log_logmatch_info(".avg_delay");
single_value->field_avg__delay.log_match(match_value.avg__delay(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::log_event_str(", tx_packets := ");
single_value->field_tx__packets.log_match(match_value.tx__packets(), legacy);
TTCN_Logger::log_event_str(", tx_octets := ");
single_value->field_tx__octets.log_match(match_value.tx__octets(), legacy);
TTCN_Logger::log_event_str(", rx_packets := ");
single_value->field_rx__packets.log_match(match_value.rx__packets(), legacy);
TTCN_Logger::log_event_str(", rx_octets := ");
single_value->field_rx__octets.log_match(match_value.rx__octets(), legacy);
TTCN_Logger::log_event_str(", lost_packets := ");
single_value->field_lost__packets.log_match(match_value.lost__packets(), legacy);
TTCN_Logger::log_event_str(", jitter := ");
single_value->field_jitter.log_match(match_value.jitter(), legacy);
TTCN_Logger::log_event_str(", avg_delay := ");
single_value->field_avg__delay.log_match(match_value.avg__delay(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__IPA__ConnectionStats_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (len().is_bound()) len().set_implicit_omit();
if (tx__packets().is_bound()) tx__packets().set_implicit_omit();
if (tx__octets().is_bound()) tx__octets().set_implicit_omit();
if (rx__packets().is_bound()) rx__packets().set_implicit_omit();
if (rx__octets().is_bound()) rx__octets().set_implicit_omit();
if (lost__packets().is_bound()) lost__packets().set_implicit_omit();
if (jitter().is_bound()) jitter().set_implicit_omit();
if (avg__delay().is_bound()) avg__delay().set_implicit_omit();
}

void RSL__IE__IPA__ConnectionStats_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_len.encode_text(text_buf);
single_value->field_tx__packets.encode_text(text_buf);
single_value->field_tx__octets.encode_text(text_buf);
single_value->field_rx__packets.encode_text(text_buf);
single_value->field_rx__octets.encode_text(text_buf);
single_value->field_lost__packets.encode_text(text_buf);
single_value->field_jitter.encode_text(text_buf);
single_value->field_avg__delay.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
}
}

void RSL__IE__IPA__ConnectionStats_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_len.decode_text(text_buf);
single_value->field_tx__packets.decode_text(text_buf);
single_value->field_tx__octets.decode_text(text_buf);
single_value->field_rx__packets.decode_text(text_buf);
single_value->field_rx__octets.decode_text(text_buf);
single_value->field_lost__packets.decode_text(text_buf);
single_value->field_jitter.decode_text(text_buf);
single_value->field_avg__delay.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__IPA__ConnectionStats_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_IPA_ConnectionStats.");
}
}

void RSL__IE__IPA__ConnectionStats_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__IPA__ConnectionStats_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_IPA_ConnectionStats has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) tx__packets().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) tx__octets().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rx__packets().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) rx__octets().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) lost__packets().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) jitter().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) avg__delay().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tx_packets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tx__packets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tx_octets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tx__octets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rx_packets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rx__packets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rx_octets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rx__octets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "lost_packets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          lost__packets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "jitter")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          jitter().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "avg_delay")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          avg__delay().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_IPA_ConnectionStats: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__IPA__ConnectionStats_template* precondition = new RSL__IE__IPA__ConnectionStats_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__IPA__ConnectionStats_template* implied_template = new RSL__IE__IPA__ConnectionStats_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__IPA__ConnectionStats_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_IPA_ConnectionStats");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__IPA__ConnectionStats_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_len.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_ConnectionStats");
single_value->field_tx__packets.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_ConnectionStats");
single_value->field_tx__octets.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_ConnectionStats");
single_value->field_rx__packets.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_ConnectionStats");
single_value->field_rx__octets.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_ConnectionStats");
single_value->field_lost__packets.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_ConnectionStats");
single_value->field_jitter.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_ConnectionStats");
single_value->field_avg__delay.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_ConnectionStats");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_IPA_ConnectionStats");
}

boolean RSL__IE__IPA__ConnectionStats_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__IPA__ConnectionStats_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IPA__SpeechMode::RSL__IPA__SpeechMode()
{
enum_value = UNBOUND_VALUE;
}

RSL__IPA__SpeechMode::RSL__IPA__SpeechMode(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @RSL_Types.RSL_IPA_SpeechMode with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

RSL__IPA__SpeechMode::RSL__IPA__SpeechMode(enum_type other_value)
{
enum_value = other_value;
}

RSL__IPA__SpeechMode::RSL__IPA__SpeechMode(const RSL__IPA__SpeechMode& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
enum_value = other_value.enum_value;
}

RSL__IPA__SpeechMode& RSL__IPA__SpeechMode::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @RSL_Types.RSL_IPA_SpeechMode.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

RSL__IPA__SpeechMode& RSL__IPA__SpeechMode::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

RSL__IPA__SpeechMode& RSL__IPA__SpeechMode::operator=(const RSL__IPA__SpeechMode& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
enum_value = other_value.enum_value;
return *this;
}

boolean RSL__IPA__SpeechMode::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_SpeechMode comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean RSL__IPA__SpeechMode::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
return enum_value == other_value;
}

boolean RSL__IPA__SpeechMode::operator==(const RSL__IPA__SpeechMode& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
return enum_value == other_value.enum_value;
}

boolean RSL__IPA__SpeechMode::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_SpeechMode comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean RSL__IPA__SpeechMode::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
return enum_value < other_value;
}

boolean RSL__IPA__SpeechMode::operator<(const RSL__IPA__SpeechMode& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
return enum_value < other_value.enum_value;
}

boolean RSL__IPA__SpeechMode::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_SpeechMode comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean RSL__IPA__SpeechMode::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
return enum_value > other_value;
}

boolean RSL__IPA__SpeechMode::operator>(const RSL__IPA__SpeechMode& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
return enum_value > other_value.enum_value;
}

const char *RSL__IPA__SpeechMode::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case RSL__IPA__SPM__SENDRECV: return "RSL_IPA_SPM_SENDRECV";
case RSL__IPA__SPM__RECVONLY: return "RSL_IPA_SPM_RECVONLY";
case RSL__IPA__SPM__SENDONLY: return "RSL_IPA_SPM_SENDONLY";
case RSL__IPA__SPM__RESERVED: return "RSL_IPA_SPM_RESERVED";
default:
return "<unknown>";
}
}

RSL__IPA__SpeechMode::enum_type RSL__IPA__SpeechMode::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "RSL_IPA_SPM_SENDRECV")) return RSL__IPA__SPM__SENDRECV;
if (!strcmp(str_par, "RSL_IPA_SPM_RECVONLY")) return RSL__IPA__SPM__RECVONLY;
if (!strcmp(str_par, "RSL_IPA_SPM_SENDONLY")) return RSL__IPA__SPM__SENDONLY;
if (!strcmp(str_par, "RSL_IPA_SPM_RESERVED")) return RSL__IPA__SPM__RESERVED;
}
return UNKNOWN_VALUE;
}

boolean RSL__IPA__SpeechMode::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
return TRUE;
default:
return FALSE;
}
}

int RSL__IPA__SpeechMode::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int RSL__IPA__SpeechMode::enum2int(const RSL__IPA__SpeechMode& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void RSL__IPA__SpeechMode::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @RSL_Types.RSL_IPA_SpeechMode.", int_val);
enum_value = (enum_type)int_val;
}

RSL__IPA__SpeechMode::operator RSL__IPA__SpeechMode::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
return enum_value;
}

void RSL__IPA__SpeechMode::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void RSL__IPA__SpeechMode::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@RSL_Types.RSL_IPA_SpeechMode");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @RSL_Types.RSL_IPA_SpeechMode.");
  }
}

void RSL__IPA__SpeechMode::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
text_buf.push_int(enum_value);
}

void RSL__IPA__SpeechMode::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @RSL_Types.RSL_IPA_SpeechMode.", enum_value);
}

void RSL__IPA__SpeechMode::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IPA__SpeechMode::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IPA__SpeechMode::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 3, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int RSL__IPA__SpeechMode::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 3);
}

void RSL__IPA__SpeechMode_template::copy_template(const RSL__IPA__SpeechMode_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IPA__SpeechMode_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IPA__SpeechMode_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IPA__SpeechMode_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
}
}

RSL__IPA__SpeechMode_template::RSL__IPA__SpeechMode_template()
{
}

RSL__IPA__SpeechMode_template::RSL__IPA__SpeechMode_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IPA__SpeechMode_template::RSL__IPA__SpeechMode_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!RSL__IPA__SpeechMode::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @RSL_Types.RSL_IPA_SpeechMode with unknown numeric value %d.", other_value);
single_value = (RSL__IPA__SpeechMode::enum_type)other_value;
}

RSL__IPA__SpeechMode_template::RSL__IPA__SpeechMode_template(RSL__IPA__SpeechMode::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

RSL__IPA__SpeechMode_template::RSL__IPA__SpeechMode_template(const RSL__IPA__SpeechMode& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == RSL__IPA__SpeechMode::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
single_value = other_value.enum_value;
}

RSL__IPA__SpeechMode_template::RSL__IPA__SpeechMode_template(const OPTIONAL<RSL__IPA__SpeechMode>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__SpeechMode::enum_type)(const RSL__IPA__SpeechMode&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @RSL_Types.RSL_IPA_SpeechMode from an unbound optional field.");
}
}

RSL__IPA__SpeechMode_template::RSL__IPA__SpeechMode_template(RSL__IPA__SpeechMode_template* p_precondition, RSL__IPA__SpeechMode_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IPA__SpeechMode_template::RSL__IPA__SpeechMode_template(Dynamic_Match_Interface<RSL__IPA__SpeechMode>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IPA__SpeechMode>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IPA__SpeechMode_template::RSL__IPA__SpeechMode_template(const RSL__IPA__SpeechMode_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

RSL__IPA__SpeechMode_template::~RSL__IPA__SpeechMode_template()
{
clean_up();
}

boolean RSL__IPA__SpeechMode_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean RSL__IPA__SpeechMode_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != RSL__IPA__SpeechMode::UNBOUND_VALUE;
}

void RSL__IPA__SpeechMode_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IPA__SpeechMode_template& RSL__IPA__SpeechMode_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IPA__SpeechMode_template& RSL__IPA__SpeechMode_template::operator=(int other_value)
{
if (!RSL__IPA__SpeechMode::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @RSL_Types.RSL_IPA_SpeechMode.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__SpeechMode::enum_type)other_value;
return *this;
}

RSL__IPA__SpeechMode_template& RSL__IPA__SpeechMode_template::operator=(RSL__IPA__SpeechMode::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

RSL__IPA__SpeechMode_template& RSL__IPA__SpeechMode_template::operator=(const RSL__IPA__SpeechMode& other_value)
{
if (other_value.enum_value == RSL__IPA__SpeechMode::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_IPA_SpeechMode to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

RSL__IPA__SpeechMode_template& RSL__IPA__SpeechMode_template::operator=(const OPTIONAL<RSL__IPA__SpeechMode>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__SpeechMode::enum_type)(const RSL__IPA__SpeechMode&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
}
return *this;
}

RSL__IPA__SpeechMode_template& RSL__IPA__SpeechMode_template::operator=(const RSL__IPA__SpeechMode_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IPA__SpeechMode_template::match(RSL__IPA__SpeechMode::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
}
return FALSE;
}

boolean RSL__IPA__SpeechMode_template::match(const RSL__IPA__SpeechMode& other_value, boolean) const
{
if (other_value.enum_value == RSL__IPA__SpeechMode::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @RSL_Types.RSL_IPA_SpeechMode with an unbound value.");
return match(other_value.enum_value);
}

RSL__IPA__SpeechMode::enum_type RSL__IPA__SpeechMode_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
return single_value;
}

void RSL__IPA__SpeechMode_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IPA__SpeechMode_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
}
}

RSL__IPA__SpeechMode_template& RSL__IPA__SpeechMode_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
return value_list.list_value[list_index];
}

void RSL__IPA__SpeechMode_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(RSL__IPA__SpeechMode::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IPA__SpeechMode_template::log_match(const RSL__IPA__SpeechMode& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void RSL__IPA__SpeechMode_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
}
}

void RSL__IPA__SpeechMode_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (RSL__IPA__SpeechMode::enum_type)text_buf.pull_int().get_val();
if (!RSL__IPA__SpeechMode::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @RSL_Types.RSL_IPA_SpeechMode.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IPA__SpeechMode_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @RSL_Types.RSL_IPA_SpeechMode.");
}
}

boolean RSL__IPA__SpeechMode_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IPA__SpeechMode_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RSL__IPA__SpeechMode_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IPA__SpeechMode_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    RSL__IPA__SpeechMode::enum_type enum_val = RSL__IPA__SpeechMode::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!RSL__IPA__SpeechMode::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @RSL_Types.RSL_IPA_SpeechMode.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IPA__SpeechMode_template* precondition = new RSL__IPA__SpeechMode_template;
    precondition->set_param(*m_p->get_elem(0));
    RSL__IPA__SpeechMode_template* implied_template = new RSL__IPA__SpeechMode_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = RSL__IPA__SpeechMode_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@RSL_Types.RSL_IPA_SpeechMode");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IPA__SpeechMode_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IPA_SpeechMode");
}

RSL__IPA__Codec::RSL__IPA__Codec()
{
enum_value = UNBOUND_VALUE;
}

RSL__IPA__Codec::RSL__IPA__Codec(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @RSL_Types.RSL_IPA_Codec with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

RSL__IPA__Codec::RSL__IPA__Codec(enum_type other_value)
{
enum_value = other_value;
}

RSL__IPA__Codec::RSL__IPA__Codec(const RSL__IPA__Codec& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
enum_value = other_value.enum_value;
}

RSL__IPA__Codec& RSL__IPA__Codec::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @RSL_Types.RSL_IPA_Codec.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

RSL__IPA__Codec& RSL__IPA__Codec::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

RSL__IPA__Codec& RSL__IPA__Codec::operator=(const RSL__IPA__Codec& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
enum_value = other_value.enum_value;
return *this;
}

boolean RSL__IPA__Codec::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_Codec comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean RSL__IPA__Codec::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
return enum_value == other_value;
}

boolean RSL__IPA__Codec::operator==(const RSL__IPA__Codec& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
return enum_value == other_value.enum_value;
}

boolean RSL__IPA__Codec::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_Codec comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean RSL__IPA__Codec::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
return enum_value < other_value;
}

boolean RSL__IPA__Codec::operator<(const RSL__IPA__Codec& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
return enum_value < other_value.enum_value;
}

boolean RSL__IPA__Codec::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_Codec comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean RSL__IPA__Codec::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
return enum_value > other_value;
}

boolean RSL__IPA__Codec::operator>(const RSL__IPA__Codec& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
return enum_value > other_value.enum_value;
}

const char *RSL__IPA__Codec::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case RSL__IPA__CODEC__FR: return "RSL_IPA_CODEC_FR";
case RSL__IPA__CODEC__EFR: return "RSL_IPA_CODEC_EFR";
case RSL__IPA__CODEC__AMR__F: return "RSL_IPA_CODEC_AMR_F";
case RSL__IPA__CODEC__HR: return "RSL_IPA_CODEC_HR";
case RSL__IPA__CODEC__AMR__H: return "RSL_IPA_CODEC_AMR_H";
case RSL__IPA__CODEC__RTP__PT: return "RSL_IPA_CODEC_RTP_PT";
default:
return "<unknown>";
}
}

RSL__IPA__Codec::enum_type RSL__IPA__Codec::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "RSL_IPA_CODEC_FR")) return RSL__IPA__CODEC__FR;
if (!strcmp(str_par, "RSL_IPA_CODEC_EFR")) return RSL__IPA__CODEC__EFR;
if (!strcmp(str_par, "RSL_IPA_CODEC_AMR_F")) return RSL__IPA__CODEC__AMR__F;
if (!strcmp(str_par, "RSL_IPA_CODEC_HR")) return RSL__IPA__CODEC__HR;
if (!strcmp(str_par, "RSL_IPA_CODEC_AMR_H")) return RSL__IPA__CODEC__AMR__H;
if (!strcmp(str_par, "RSL_IPA_CODEC_RTP_PT")) return RSL__IPA__CODEC__RTP__PT;
}
return UNKNOWN_VALUE;
}

boolean RSL__IPA__Codec::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
case 5:
case 15:
return TRUE;
default:
return FALSE;
}
}

int RSL__IPA__Codec::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_IPA_Codec.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int RSL__IPA__Codec::enum2int(const RSL__IPA__Codec& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_IPA_Codec.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void RSL__IPA__Codec::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @RSL_Types.RSL_IPA_Codec.", int_val);
enum_value = (enum_type)int_val;
}

RSL__IPA__Codec::operator RSL__IPA__Codec::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @RSL_Types.RSL_IPA_Codec.");
return enum_value;
}

void RSL__IPA__Codec::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void RSL__IPA__Codec::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@RSL_Types.RSL_IPA_Codec");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @RSL_Types.RSL_IPA_Codec.");
  }
}

void RSL__IPA__Codec::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
text_buf.push_int(enum_value);
}

void RSL__IPA__Codec::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @RSL_Types.RSL_IPA_Codec.", enum_value);
}

void RSL__IPA__Codec::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IPA__Codec::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IPA__Codec::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 4, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int RSL__IPA__Codec::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 4);
}

void RSL__IPA__Codec_template::copy_template(const RSL__IPA__Codec_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IPA__Codec_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IPA__Codec_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IPA__Codec_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_Codec.");
}
}

RSL__IPA__Codec_template::RSL__IPA__Codec_template()
{
}

RSL__IPA__Codec_template::RSL__IPA__Codec_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IPA__Codec_template::RSL__IPA__Codec_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!RSL__IPA__Codec::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @RSL_Types.RSL_IPA_Codec with unknown numeric value %d.", other_value);
single_value = (RSL__IPA__Codec::enum_type)other_value;
}

RSL__IPA__Codec_template::RSL__IPA__Codec_template(RSL__IPA__Codec::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

RSL__IPA__Codec_template::RSL__IPA__Codec_template(const RSL__IPA__Codec& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == RSL__IPA__Codec::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec.");
single_value = other_value.enum_value;
}

RSL__IPA__Codec_template::RSL__IPA__Codec_template(const OPTIONAL<RSL__IPA__Codec>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__Codec::enum_type)(const RSL__IPA__Codec&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @RSL_Types.RSL_IPA_Codec from an unbound optional field.");
}
}

RSL__IPA__Codec_template::RSL__IPA__Codec_template(RSL__IPA__Codec_template* p_precondition, RSL__IPA__Codec_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IPA__Codec_template::RSL__IPA__Codec_template(Dynamic_Match_Interface<RSL__IPA__Codec>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IPA__Codec>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IPA__Codec_template::RSL__IPA__Codec_template(const RSL__IPA__Codec_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

RSL__IPA__Codec_template::~RSL__IPA__Codec_template()
{
clean_up();
}

boolean RSL__IPA__Codec_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean RSL__IPA__Codec_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != RSL__IPA__Codec::UNBOUND_VALUE;
}

void RSL__IPA__Codec_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IPA__Codec_template& RSL__IPA__Codec_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IPA__Codec_template& RSL__IPA__Codec_template::operator=(int other_value)
{
if (!RSL__IPA__Codec::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @RSL_Types.RSL_IPA_Codec.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__Codec::enum_type)other_value;
return *this;
}

RSL__IPA__Codec_template& RSL__IPA__Codec_template::operator=(RSL__IPA__Codec::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

RSL__IPA__Codec_template& RSL__IPA__Codec_template::operator=(const RSL__IPA__Codec& other_value)
{
if (other_value.enum_value == RSL__IPA__Codec::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_IPA_Codec to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

RSL__IPA__Codec_template& RSL__IPA__Codec_template::operator=(const OPTIONAL<RSL__IPA__Codec>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__Codec::enum_type)(const RSL__IPA__Codec&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @RSL_Types.RSL_IPA_Codec.");
}
return *this;
}

RSL__IPA__Codec_template& RSL__IPA__Codec_template::operator=(const RSL__IPA__Codec_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IPA__Codec_template::match(RSL__IPA__Codec::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_Codec.");
}
return FALSE;
}

boolean RSL__IPA__Codec_template::match(const RSL__IPA__Codec& other_value, boolean) const
{
if (other_value.enum_value == RSL__IPA__Codec::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @RSL_Types.RSL_IPA_Codec with an unbound value.");
return match(other_value.enum_value);
}

RSL__IPA__Codec::enum_type RSL__IPA__Codec_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @RSL_Types.RSL_IPA_Codec.");
return single_value;
}

void RSL__IPA__Codec_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IPA__Codec_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @RSL_Types.RSL_IPA_Codec.");
}
}

RSL__IPA__Codec_template& RSL__IPA__Codec_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @RSL_Types.RSL_IPA_Codec.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @RSL_Types.RSL_IPA_Codec.");
return value_list.list_value[list_index];
}

void RSL__IPA__Codec_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(RSL__IPA__Codec::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IPA__Codec_template::log_match(const RSL__IPA__Codec& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void RSL__IPA__Codec_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_Codec.");
}
}

void RSL__IPA__Codec_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (RSL__IPA__Codec::enum_type)text_buf.pull_int().get_val();
if (!RSL__IPA__Codec::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @RSL_Types.RSL_IPA_Codec.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IPA__Codec_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @RSL_Types.RSL_IPA_Codec.");
}
}

boolean RSL__IPA__Codec_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IPA__Codec_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RSL__IPA__Codec_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IPA__Codec_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    RSL__IPA__Codec::enum_type enum_val = RSL__IPA__Codec::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!RSL__IPA__Codec::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @RSL_Types.RSL_IPA_Codec.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IPA__Codec_template* precondition = new RSL__IPA__Codec_template;
    precondition->set_param(*m_p->get_elem(0));
    RSL__IPA__Codec_template* implied_template = new RSL__IPA__Codec_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = RSL__IPA__Codec_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@RSL_Types.RSL_IPA_Codec");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IPA__Codec_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IPA_Codec");
}

RSL__IE__IPA__SpeechMode::RSL__IE__IPA__SpeechMode()
{
}

RSL__IE__IPA__SpeechMode::RSL__IE__IPA__SpeechMode(const BITSTRING& par_reserved,
    const RSL__IPA__SpeechMode& par_mode,
    const RSL__IPA__Codec& par_codec)
  :   field_reserved(par_reserved),
  field_mode(par_mode),
  field_codec(par_codec)
{
}

RSL__IE__IPA__SpeechMode::RSL__IE__IPA__SpeechMode(const RSL__IE__IPA__SpeechMode& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
else field_reserved.clean_up();
if (other_value.mode().is_bound()) field_mode = other_value.mode();
else field_mode.clean_up();
if (other_value.codec().is_bound()) field_codec = other_value.codec();
else field_codec.clean_up();
}

void RSL__IE__IPA__SpeechMode::clean_up()
{
field_reserved.clean_up();
field_mode.clean_up();
field_codec.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__IPA__SpeechMode::get_descriptor() const { return &RSL__IE__IPA__SpeechMode_descr_; }
RSL__IE__IPA__SpeechMode& RSL__IE__IPA__SpeechMode::operator=(const RSL__IE__IPA__SpeechMode& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
  if (other_value.reserved().is_bound()) field_reserved = other_value.reserved();
  else field_reserved.clean_up();
  if (other_value.mode().is_bound()) field_mode = other_value.mode();
  else field_mode.clean_up();
  if (other_value.codec().is_bound()) field_codec = other_value.codec();
  else field_codec.clean_up();
}
return *this;
}

boolean RSL__IE__IPA__SpeechMode::operator==(const RSL__IE__IPA__SpeechMode& other_value) const
{
return field_reserved==other_value.field_reserved
  && field_mode==other_value.field_mode
  && field_codec==other_value.field_codec;
}

boolean RSL__IE__IPA__SpeechMode::is_bound() const
{
return (field_reserved.is_bound())
  || (field_mode.is_bound())
  || (field_codec.is_bound());
}
boolean RSL__IE__IPA__SpeechMode::is_value() const
{
return field_reserved.is_value()
  && field_mode.is_value()
  && field_codec.is_value();
}
void RSL__IE__IPA__SpeechMode::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ reserved := ");
field_reserved.log();
TTCN_Logger::log_event_str(", mode := ");
field_mode.log();
TTCN_Logger::log_event_str(", codec := ");
field_codec.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__IPA__SpeechMode::set_implicit_omit()
{
if (reserved().is_bound()) reserved().set_implicit_omit();
if (mode().is_bound()) mode().set_implicit_omit();
if (codec().is_bound()) codec().set_implicit_omit();
}

void RSL__IE__IPA__SpeechMode::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_IPA_SpeechMode has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) mode().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) codec().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "codec")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          codec().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_IPA_SpeechMode: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_IPA_SpeechMode");
  }
}

void RSL__IE__IPA__SpeechMode::encode_text(Text_Buf& text_buf) const
{
field_reserved.encode_text(text_buf);
field_mode.encode_text(text_buf);
field_codec.encode_text(text_buf);
}

void RSL__IE__IPA__SpeechMode::decode_text(Text_Buf& text_buf)
{
field_reserved.decode_text(text_buf);
field_mode.decode_text(text_buf);
field_codec.decode_text(text_buf);
}

void RSL__IE__IPA__SpeechMode::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__IPA__SpeechMode::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__IPA__SpeechMode::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__IPA__SpeechMode_reserved_descr_.raw->forceomit);
  decoded_field_length = field_reserved.RAW_decode(RSL__IE__IPA__SpeechMode_reserved_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__IPA__SpeechMode_mode_descr_.raw->forceomit);
  decoded_field_length = field_mode.RAW_decode(RSL__IE__IPA__SpeechMode_mode_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_2_force_omit(2, force_omit, RSL__IE__IPA__SpeechMode_codec_descr_.raw->forceomit);
  decoded_field_length = field_codec.RAW_decode(RSL__IE__IPA__SpeechMode_codec_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__IPA__SpeechMode::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__IPA__SpeechMode_reserved_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__IPA__SpeechMode_mode_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RSL__IE__IPA__SpeechMode_codec_descr_.raw);
  encoded_length += field_reserved.RAW_encode(RSL__IE__IPA__SpeechMode_reserved_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_mode.RAW_encode(RSL__IE__IPA__SpeechMode_mode_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_codec.RAW_encode(RSL__IE__IPA__SpeechMode_codec_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__IPA__SpeechMode_template::single_value_struct {
BITSTRING_template field_reserved;
RSL__IPA__SpeechMode_template field_mode;
RSL__IPA__Codec_template field_codec;
};

void RSL__IE__IPA__SpeechMode_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_reserved = ANY_VALUE;
single_value->field_mode = ANY_VALUE;
single_value->field_codec = ANY_VALUE;
}
}
}

void RSL__IE__IPA__SpeechMode_template::copy_value(const RSL__IE__IPA__SpeechMode& other_value)
{
single_value = new single_value_struct;
if (other_value.reserved().is_bound()) {
  single_value->field_reserved = other_value.reserved();
} else {
  single_value->field_reserved.clean_up();
}
if (other_value.mode().is_bound()) {
  single_value->field_mode = other_value.mode();
} else {
  single_value->field_mode.clean_up();
}
if (other_value.codec().is_bound()) {
  single_value->field_codec = other_value.codec();
} else {
  single_value->field_codec.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__IPA__SpeechMode_template::copy_template(const RSL__IE__IPA__SpeechMode_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.reserved().get_selection()) {
single_value->field_reserved = other_value.reserved();
} else {
single_value->field_reserved.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mode().get_selection()) {
single_value->field_mode = other_value.mode();
} else {
single_value->field_mode.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.codec().get_selection()) {
single_value->field_codec = other_value.codec();
} else {
single_value->field_codec.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__IPA__SpeechMode_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__IPA__SpeechMode_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__IPA__SpeechMode_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
break;
}
set_selection(other_value);
}

RSL__IE__IPA__SpeechMode_template::RSL__IE__IPA__SpeechMode_template()
{
}

RSL__IE__IPA__SpeechMode_template::RSL__IE__IPA__SpeechMode_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__IPA__SpeechMode_template::RSL__IE__IPA__SpeechMode_template(const RSL__IE__IPA__SpeechMode& other_value)
{
copy_value(other_value);
}

RSL__IE__IPA__SpeechMode_template::RSL__IE__IPA__SpeechMode_template(const OPTIONAL<RSL__IE__IPA__SpeechMode>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__IPA__SpeechMode&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_IPA_SpeechMode from an unbound optional field.");
}
}

RSL__IE__IPA__SpeechMode_template::RSL__IE__IPA__SpeechMode_template(RSL__IE__IPA__SpeechMode_template* p_precondition, RSL__IE__IPA__SpeechMode_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__IPA__SpeechMode_template::RSL__IE__IPA__SpeechMode_template(Dynamic_Match_Interface<RSL__IE__IPA__SpeechMode>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__IPA__SpeechMode>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__IPA__SpeechMode_template::RSL__IE__IPA__SpeechMode_template(const RSL__IE__IPA__SpeechMode_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__IPA__SpeechMode_template::~RSL__IE__IPA__SpeechMode_template()
{
clean_up();
}

RSL__IE__IPA__SpeechMode_template& RSL__IE__IPA__SpeechMode_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__IPA__SpeechMode_template& RSL__IE__IPA__SpeechMode_template::operator=(const RSL__IE__IPA__SpeechMode& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__IPA__SpeechMode_template& RSL__IE__IPA__SpeechMode_template::operator=(const OPTIONAL<RSL__IE__IPA__SpeechMode>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__IPA__SpeechMode&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
}
return *this;
}

RSL__IE__IPA__SpeechMode_template& RSL__IE__IPA__SpeechMode_template::operator=(const RSL__IE__IPA__SpeechMode_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__IPA__SpeechMode_template::match(const RSL__IE__IPA__SpeechMode& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.reserved().is_bound()) return FALSE;
if(!single_value->field_reserved.match(other_value.reserved(), legacy))return FALSE;
if(!other_value.mode().is_bound()) return FALSE;
if(!single_value->field_mode.match(other_value.mode(), legacy))return FALSE;
if(!other_value.codec().is_bound()) return FALSE;
if(!single_value->field_codec.match(other_value.codec(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
}
return FALSE;
}

boolean RSL__IE__IPA__SpeechMode_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_reserved.is_bound()
 || single_value->field_mode.is_bound()
 || single_value->field_codec.is_bound();
}

boolean RSL__IE__IPA__SpeechMode_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_reserved.is_value()
 && single_value->field_mode.is_value()
 && single_value->field_codec.is_value();
}

void RSL__IE__IPA__SpeechMode_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__IPA__SpeechMode RSL__IE__IPA__SpeechMode_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
RSL__IE__IPA__SpeechMode ret_val;
if (single_value->field_reserved.is_bound()) {
ret_val.reserved() = single_value->field_reserved.valueof();
}
if (single_value->field_mode.is_bound()) {
ret_val.mode() = single_value->field_mode.valueof();
}
if (single_value->field_codec.is_bound()) {
ret_val.codec() = single_value->field_codec.valueof();
}
return ret_val;
}

void RSL__IE__IPA__SpeechMode_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__IPA__SpeechMode_template[list_length];
}

RSL__IE__IPA__SpeechMode_template& RSL__IE__IPA__SpeechMode_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
return value_list.list_value[list_index];
}

BITSTRING_template& RSL__IE__IPA__SpeechMode_template::reserved()
{
set_specific();
return single_value->field_reserved;
}

const BITSTRING_template& RSL__IE__IPA__SpeechMode_template::reserved() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reserved of a non-specific template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
return single_value->field_reserved;
}

RSL__IPA__SpeechMode_template& RSL__IE__IPA__SpeechMode_template::mode()
{
set_specific();
return single_value->field_mode;
}

const RSL__IPA__SpeechMode_template& RSL__IE__IPA__SpeechMode_template::mode() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mode of a non-specific template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
return single_value->field_mode;
}

RSL__IPA__Codec_template& RSL__IE__IPA__SpeechMode_template::codec()
{
set_specific();
return single_value->field_codec;
}

const RSL__IPA__Codec_template& RSL__IE__IPA__SpeechMode_template::codec() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field codec of a non-specific template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
return single_value->field_codec;
}

int RSL__IE__IPA__SpeechMode_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_SpeechMode which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_SpeechMode containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_SpeechMode containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_SpeechMode containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_SpeechMode containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_SpeechMode containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_SpeechMode containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_SpeechMode containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_SpeechMode containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
  }
  return 0;
}

void RSL__IE__IPA__SpeechMode_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ reserved := ");
single_value->field_reserved.log();
TTCN_Logger::log_event_str(", mode := ");
single_value->field_mode.log();
TTCN_Logger::log_event_str(", codec := ");
single_value->field_codec.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__IPA__SpeechMode_template::log_match(const RSL__IE__IPA__SpeechMode& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_reserved.match(match_value.reserved(), legacy)){
TTCN_Logger::log_logmatch_info(".reserved");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_mode.match(match_value.mode(), legacy)){
TTCN_Logger::log_logmatch_info(".mode");
single_value->field_mode.log_match(match_value.mode(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_codec.match(match_value.codec(), legacy)){
TTCN_Logger::log_logmatch_info(".codec");
single_value->field_codec.log_match(match_value.codec(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ reserved := ");
single_value->field_reserved.log_match(match_value.reserved(), legacy);
TTCN_Logger::log_event_str(", mode := ");
single_value->field_mode.log_match(match_value.mode(), legacy);
TTCN_Logger::log_event_str(", codec := ");
single_value->field_codec.log_match(match_value.codec(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__IPA__SpeechMode_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (reserved().is_bound()) reserved().set_implicit_omit();
if (mode().is_bound()) mode().set_implicit_omit();
if (codec().is_bound()) codec().set_implicit_omit();
}

void RSL__IE__IPA__SpeechMode_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_reserved.encode_text(text_buf);
single_value->field_mode.encode_text(text_buf);
single_value->field_codec.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
}
}

void RSL__IE__IPA__SpeechMode_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_reserved.decode_text(text_buf);
single_value->field_mode.decode_text(text_buf);
single_value->field_codec.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__IPA__SpeechMode_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_IPA_SpeechMode.");
}
}

void RSL__IE__IPA__SpeechMode_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__IPA__SpeechMode_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_IPA_SpeechMode has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) reserved().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) mode().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) codec().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reserved")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reserved().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "codec")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          codec().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_IPA_SpeechMode: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__IPA__SpeechMode_template* precondition = new RSL__IE__IPA__SpeechMode_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__IPA__SpeechMode_template* implied_template = new RSL__IE__IPA__SpeechMode_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__IPA__SpeechMode_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_IPA_SpeechMode");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__IPA__SpeechMode_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_reserved.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_SpeechMode");
single_value->field_mode.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_SpeechMode");
single_value->field_codec.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_SpeechMode");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_IPA_SpeechMode");
}

boolean RSL__IE__IPA__SpeechMode_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__IPA__SpeechMode_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IPA__RTP__CSD__FMT__D::RSL__IPA__RTP__CSD__FMT__D()
{
enum_value = UNBOUND_VALUE;
}

RSL__IPA__RTP__CSD__FMT__D::RSL__IPA__RTP__CSD__FMT__D(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

RSL__IPA__RTP__CSD__FMT__D::RSL__IPA__RTP__CSD__FMT__D(enum_type other_value)
{
enum_value = other_value;
}

RSL__IPA__RTP__CSD__FMT__D::RSL__IPA__RTP__CSD__FMT__D(const RSL__IPA__RTP__CSD__FMT__D& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
enum_value = other_value.enum_value;
}

RSL__IPA__RTP__CSD__FMT__D& RSL__IPA__RTP__CSD__FMT__D::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

RSL__IPA__RTP__CSD__FMT__D& RSL__IPA__RTP__CSD__FMT__D::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

RSL__IPA__RTP__CSD__FMT__D& RSL__IPA__RTP__CSD__FMT__D::operator=(const RSL__IPA__RTP__CSD__FMT__D& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
enum_value = other_value.enum_value;
return *this;
}

boolean RSL__IPA__RTP__CSD__FMT__D::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__D::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
return enum_value == other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__D::operator==(const RSL__IPA__RTP__CSD__FMT__D& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
return enum_value == other_value.enum_value;
}

boolean RSL__IPA__RTP__CSD__FMT__D::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__D::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
return enum_value < other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__D::operator<(const RSL__IPA__RTP__CSD__FMT__D& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
return enum_value < other_value.enum_value;
}

boolean RSL__IPA__RTP__CSD__FMT__D::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__D::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
return enum_value > other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__D::operator>(const RSL__IPA__RTP__CSD__FMT__D& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
return enum_value > other_value.enum_value;
}

const char *RSL__IPA__RTP__CSD__FMT__D::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case RSL__IPA__RTP__CSD__EXT__TRAU: return "RSL_IPA_RTP_CSD_EXT_TRAU";
case RSL__IPA__RTP__CSD__NON__TRAU: return "RSL_IPA_RTP_CSD_NON_TRAU";
case RSL__IPA__RTP__CSD__TRAU__BTS: return "RSL_IPA_RTP_CSD_TRAU_BTS";
case RSL__IPA__RTP__CSD__IWF__FREE: return "RSL_IPA_RTP_CSD_IWF_FREE";
default:
return "<unknown>";
}
}

RSL__IPA__RTP__CSD__FMT__D::enum_type RSL__IPA__RTP__CSD__FMT__D::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "RSL_IPA_RTP_CSD_EXT_TRAU")) return RSL__IPA__RTP__CSD__EXT__TRAU;
if (!strcmp(str_par, "RSL_IPA_RTP_CSD_NON_TRAU")) return RSL__IPA__RTP__CSD__NON__TRAU;
if (!strcmp(str_par, "RSL_IPA_RTP_CSD_TRAU_BTS")) return RSL__IPA__RTP__CSD__TRAU__BTS;
if (!strcmp(str_par, "RSL_IPA_RTP_CSD_IWF_FREE")) return RSL__IPA__RTP__CSD__IWF__FREE;
}
return UNKNOWN_VALUE;
}

boolean RSL__IPA__RTP__CSD__FMT__D::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
return TRUE;
default:
return FALSE;
}
}

int RSL__IPA__RTP__CSD__FMT__D::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int RSL__IPA__RTP__CSD__FMT__D::enum2int(const RSL__IPA__RTP__CSD__FMT__D& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void RSL__IPA__RTP__CSD__FMT__D::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.", int_val);
enum_value = (enum_type)int_val;
}

RSL__IPA__RTP__CSD__FMT__D::operator RSL__IPA__RTP__CSD__FMT__D::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
return enum_value;
}

void RSL__IPA__RTP__CSD__FMT__D::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void RSL__IPA__RTP__CSD__FMT__D::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@RSL_Types.RSL_IPA_RTP_CSD_FMT_D");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
  }
}

void RSL__IPA__RTP__CSD__FMT__D::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
text_buf.push_int(enum_value);
}

void RSL__IPA__RTP__CSD__FMT__D::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.", enum_value);
}

void RSL__IPA__RTP__CSD__FMT__D::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IPA__RTP__CSD__FMT__D::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IPA__RTP__CSD__FMT__D::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 3, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int RSL__IPA__RTP__CSD__FMT__D::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 3);
}

void RSL__IPA__RTP__CSD__FMT__D_template::copy_template(const RSL__IPA__RTP__CSD__FMT__D_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IPA__RTP__CSD__FMT__D_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IPA__RTP__CSD__FMT__D_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IPA__RTP__CSD__FMT__D_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
}
}

RSL__IPA__RTP__CSD__FMT__D_template::RSL__IPA__RTP__CSD__FMT__D_template()
{
}

RSL__IPA__RTP__CSD__FMT__D_template::RSL__IPA__RTP__CSD__FMT__D_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IPA__RTP__CSD__FMT__D_template::RSL__IPA__RTP__CSD__FMT__D_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!RSL__IPA__RTP__CSD__FMT__D::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D with unknown numeric value %d.", other_value);
single_value = (RSL__IPA__RTP__CSD__FMT__D::enum_type)other_value;
}

RSL__IPA__RTP__CSD__FMT__D_template::RSL__IPA__RTP__CSD__FMT__D_template(RSL__IPA__RTP__CSD__FMT__D::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

RSL__IPA__RTP__CSD__FMT__D_template::RSL__IPA__RTP__CSD__FMT__D_template(const RSL__IPA__RTP__CSD__FMT__D& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == RSL__IPA__RTP__CSD__FMT__D::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
single_value = other_value.enum_value;
}

RSL__IPA__RTP__CSD__FMT__D_template::RSL__IPA__RTP__CSD__FMT__D_template(const OPTIONAL<RSL__IPA__RTP__CSD__FMT__D>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__RTP__CSD__FMT__D::enum_type)(const RSL__IPA__RTP__CSD__FMT__D&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D from an unbound optional field.");
}
}

RSL__IPA__RTP__CSD__FMT__D_template::RSL__IPA__RTP__CSD__FMT__D_template(RSL__IPA__RTP__CSD__FMT__D_template* p_precondition, RSL__IPA__RTP__CSD__FMT__D_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IPA__RTP__CSD__FMT__D_template::RSL__IPA__RTP__CSD__FMT__D_template(Dynamic_Match_Interface<RSL__IPA__RTP__CSD__FMT__D>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IPA__RTP__CSD__FMT__D>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IPA__RTP__CSD__FMT__D_template::RSL__IPA__RTP__CSD__FMT__D_template(const RSL__IPA__RTP__CSD__FMT__D_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

RSL__IPA__RTP__CSD__FMT__D_template::~RSL__IPA__RTP__CSD__FMT__D_template()
{
clean_up();
}

boolean RSL__IPA__RTP__CSD__FMT__D_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean RSL__IPA__RTP__CSD__FMT__D_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != RSL__IPA__RTP__CSD__FMT__D::UNBOUND_VALUE;
}

void RSL__IPA__RTP__CSD__FMT__D_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IPA__RTP__CSD__FMT__D_template& RSL__IPA__RTP__CSD__FMT__D_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IPA__RTP__CSD__FMT__D_template& RSL__IPA__RTP__CSD__FMT__D_template::operator=(int other_value)
{
if (!RSL__IPA__RTP__CSD__FMT__D::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__RTP__CSD__FMT__D::enum_type)other_value;
return *this;
}

RSL__IPA__RTP__CSD__FMT__D_template& RSL__IPA__RTP__CSD__FMT__D_template::operator=(RSL__IPA__RTP__CSD__FMT__D::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

RSL__IPA__RTP__CSD__FMT__D_template& RSL__IPA__RTP__CSD__FMT__D_template::operator=(const RSL__IPA__RTP__CSD__FMT__D& other_value)
{
if (other_value.enum_value == RSL__IPA__RTP__CSD__FMT__D::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

RSL__IPA__RTP__CSD__FMT__D_template& RSL__IPA__RTP__CSD__FMT__D_template::operator=(const OPTIONAL<RSL__IPA__RTP__CSD__FMT__D>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__RTP__CSD__FMT__D::enum_type)(const RSL__IPA__RTP__CSD__FMT__D&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
}
return *this;
}

RSL__IPA__RTP__CSD__FMT__D_template& RSL__IPA__RTP__CSD__FMT__D_template::operator=(const RSL__IPA__RTP__CSD__FMT__D_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IPA__RTP__CSD__FMT__D_template::match(RSL__IPA__RTP__CSD__FMT__D::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
}
return FALSE;
}

boolean RSL__IPA__RTP__CSD__FMT__D_template::match(const RSL__IPA__RTP__CSD__FMT__D& other_value, boolean) const
{
if (other_value.enum_value == RSL__IPA__RTP__CSD__FMT__D::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D with an unbound value.");
return match(other_value.enum_value);
}

RSL__IPA__RTP__CSD__FMT__D::enum_type RSL__IPA__RTP__CSD__FMT__D_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
return single_value;
}

void RSL__IPA__RTP__CSD__FMT__D_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IPA__RTP__CSD__FMT__D_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
}
}

RSL__IPA__RTP__CSD__FMT__D_template& RSL__IPA__RTP__CSD__FMT__D_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
return value_list.list_value[list_index];
}

void RSL__IPA__RTP__CSD__FMT__D_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(RSL__IPA__RTP__CSD__FMT__D::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IPA__RTP__CSD__FMT__D_template::log_match(const RSL__IPA__RTP__CSD__FMT__D& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void RSL__IPA__RTP__CSD__FMT__D_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
}
}

void RSL__IPA__RTP__CSD__FMT__D_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (RSL__IPA__RTP__CSD__FMT__D::enum_type)text_buf.pull_int().get_val();
if (!RSL__IPA__RTP__CSD__FMT__D::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IPA__RTP__CSD__FMT__D_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
}
}

boolean RSL__IPA__RTP__CSD__FMT__D_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IPA__RTP__CSD__FMT__D_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RSL__IPA__RTP__CSD__FMT__D_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IPA__RTP__CSD__FMT__D_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    RSL__IPA__RTP__CSD__FMT__D::enum_type enum_val = RSL__IPA__RTP__CSD__FMT__D::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!RSL__IPA__RTP__CSD__FMT__D::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @RSL_Types.RSL_IPA_RTP_CSD_FMT_D.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IPA__RTP__CSD__FMT__D_template* precondition = new RSL__IPA__RTP__CSD__FMT__D_template;
    precondition->set_param(*m_p->get_elem(0));
    RSL__IPA__RTP__CSD__FMT__D_template* implied_template = new RSL__IPA__RTP__CSD__FMT__D_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = RSL__IPA__RTP__CSD__FMT__D_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@RSL_Types.RSL_IPA_RTP_CSD_FMT_D");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IPA__RTP__CSD__FMT__D_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IPA_RTP_CSD_FMT_D");
}

RSL__IPA__RTP__CSD__FMT__IR::RSL__IPA__RTP__CSD__FMT__IR()
{
enum_value = UNBOUND_VALUE;
}

RSL__IPA__RTP__CSD__FMT__IR::RSL__IPA__RTP__CSD__FMT__IR(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

RSL__IPA__RTP__CSD__FMT__IR::RSL__IPA__RTP__CSD__FMT__IR(enum_type other_value)
{
enum_value = other_value;
}

RSL__IPA__RTP__CSD__FMT__IR::RSL__IPA__RTP__CSD__FMT__IR(const RSL__IPA__RTP__CSD__FMT__IR& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
enum_value = other_value.enum_value;
}

RSL__IPA__RTP__CSD__FMT__IR& RSL__IPA__RTP__CSD__FMT__IR::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

RSL__IPA__RTP__CSD__FMT__IR& RSL__IPA__RTP__CSD__FMT__IR::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

RSL__IPA__RTP__CSD__FMT__IR& RSL__IPA__RTP__CSD__FMT__IR::operator=(const RSL__IPA__RTP__CSD__FMT__IR& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
enum_value = other_value.enum_value;
return *this;
}

boolean RSL__IPA__RTP__CSD__FMT__IR::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__IR::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
return enum_value == other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__IR::operator==(const RSL__IPA__RTP__CSD__FMT__IR& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
return enum_value == other_value.enum_value;
}

boolean RSL__IPA__RTP__CSD__FMT__IR::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__IR::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
return enum_value < other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__IR::operator<(const RSL__IPA__RTP__CSD__FMT__IR& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
return enum_value < other_value.enum_value;
}

boolean RSL__IPA__RTP__CSD__FMT__IR::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__IR::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
return enum_value > other_value;
}

boolean RSL__IPA__RTP__CSD__FMT__IR::operator>(const RSL__IPA__RTP__CSD__FMT__IR& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
return enum_value > other_value.enum_value;
}

const char *RSL__IPA__RTP__CSD__FMT__IR::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case RSL__IPA__RTP__CSD__8k: return "RSL_IPA_RTP_CSD_8k";
case RSL__IPA__RTP__CSD__16k: return "RSL_IPA_RTP_CSD_16k";
case RSL__IPA__RTP__CSD__32k: return "RSL_IPA_RTP_CSD_32k";
case RSL__IPA__RTP__CSD__64: return "RSL_IPA_RTP_CSD_64";
default:
return "<unknown>";
}
}

RSL__IPA__RTP__CSD__FMT__IR::enum_type RSL__IPA__RTP__CSD__FMT__IR::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "RSL_IPA_RTP_CSD_8k")) return RSL__IPA__RTP__CSD__8k;
if (!strcmp(str_par, "RSL_IPA_RTP_CSD_16k")) return RSL__IPA__RTP__CSD__16k;
if (!strcmp(str_par, "RSL_IPA_RTP_CSD_32k")) return RSL__IPA__RTP__CSD__32k;
if (!strcmp(str_par, "RSL_IPA_RTP_CSD_64")) return RSL__IPA__RTP__CSD__64;
}
return UNKNOWN_VALUE;
}

boolean RSL__IPA__RTP__CSD__FMT__IR::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
return TRUE;
default:
return FALSE;
}
}

int RSL__IPA__RTP__CSD__FMT__IR::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int RSL__IPA__RTP__CSD__FMT__IR::enum2int(const RSL__IPA__RTP__CSD__FMT__IR& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void RSL__IPA__RTP__CSD__FMT__IR::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.", int_val);
enum_value = (enum_type)int_val;
}

RSL__IPA__RTP__CSD__FMT__IR::operator RSL__IPA__RTP__CSD__FMT__IR::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
return enum_value;
}

void RSL__IPA__RTP__CSD__FMT__IR::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void RSL__IPA__RTP__CSD__FMT__IR::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@RSL_Types.RSL_IPA_RTP_CSD_FMT_IR");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
  }
}

void RSL__IPA__RTP__CSD__FMT__IR::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
text_buf.push_int(enum_value);
}

void RSL__IPA__RTP__CSD__FMT__IR::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.", enum_value);
}

void RSL__IPA__RTP__CSD__FMT__IR::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IPA__RTP__CSD__FMT__IR::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IPA__RTP__CSD__FMT__IR::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 3, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int RSL__IPA__RTP__CSD__FMT__IR::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 3);
}

void RSL__IPA__RTP__CSD__FMT__IR_template::copy_template(const RSL__IPA__RTP__CSD__FMT__IR_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IPA__RTP__CSD__FMT__IR_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IPA__RTP__CSD__FMT__IR_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IPA__RTP__CSD__FMT__IR_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
}
}

RSL__IPA__RTP__CSD__FMT__IR_template::RSL__IPA__RTP__CSD__FMT__IR_template()
{
}

RSL__IPA__RTP__CSD__FMT__IR_template::RSL__IPA__RTP__CSD__FMT__IR_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IPA__RTP__CSD__FMT__IR_template::RSL__IPA__RTP__CSD__FMT__IR_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!RSL__IPA__RTP__CSD__FMT__IR::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR with unknown numeric value %d.", other_value);
single_value = (RSL__IPA__RTP__CSD__FMT__IR::enum_type)other_value;
}

RSL__IPA__RTP__CSD__FMT__IR_template::RSL__IPA__RTP__CSD__FMT__IR_template(RSL__IPA__RTP__CSD__FMT__IR::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

RSL__IPA__RTP__CSD__FMT__IR_template::RSL__IPA__RTP__CSD__FMT__IR_template(const RSL__IPA__RTP__CSD__FMT__IR& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == RSL__IPA__RTP__CSD__FMT__IR::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
single_value = other_value.enum_value;
}

RSL__IPA__RTP__CSD__FMT__IR_template::RSL__IPA__RTP__CSD__FMT__IR_template(const OPTIONAL<RSL__IPA__RTP__CSD__FMT__IR>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__RTP__CSD__FMT__IR::enum_type)(const RSL__IPA__RTP__CSD__FMT__IR&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR from an unbound optional field.");
}
}

RSL__IPA__RTP__CSD__FMT__IR_template::RSL__IPA__RTP__CSD__FMT__IR_template(RSL__IPA__RTP__CSD__FMT__IR_template* p_precondition, RSL__IPA__RTP__CSD__FMT__IR_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IPA__RTP__CSD__FMT__IR_template::RSL__IPA__RTP__CSD__FMT__IR_template(Dynamic_Match_Interface<RSL__IPA__RTP__CSD__FMT__IR>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IPA__RTP__CSD__FMT__IR>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IPA__RTP__CSD__FMT__IR_template::RSL__IPA__RTP__CSD__FMT__IR_template(const RSL__IPA__RTP__CSD__FMT__IR_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

RSL__IPA__RTP__CSD__FMT__IR_template::~RSL__IPA__RTP__CSD__FMT__IR_template()
{
clean_up();
}

boolean RSL__IPA__RTP__CSD__FMT__IR_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean RSL__IPA__RTP__CSD__FMT__IR_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != RSL__IPA__RTP__CSD__FMT__IR::UNBOUND_VALUE;
}

void RSL__IPA__RTP__CSD__FMT__IR_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IPA__RTP__CSD__FMT__IR_template& RSL__IPA__RTP__CSD__FMT__IR_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IPA__RTP__CSD__FMT__IR_template& RSL__IPA__RTP__CSD__FMT__IR_template::operator=(int other_value)
{
if (!RSL__IPA__RTP__CSD__FMT__IR::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__RTP__CSD__FMT__IR::enum_type)other_value;
return *this;
}

RSL__IPA__RTP__CSD__FMT__IR_template& RSL__IPA__RTP__CSD__FMT__IR_template::operator=(RSL__IPA__RTP__CSD__FMT__IR::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

RSL__IPA__RTP__CSD__FMT__IR_template& RSL__IPA__RTP__CSD__FMT__IR_template::operator=(const RSL__IPA__RTP__CSD__FMT__IR& other_value)
{
if (other_value.enum_value == RSL__IPA__RTP__CSD__FMT__IR::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

RSL__IPA__RTP__CSD__FMT__IR_template& RSL__IPA__RTP__CSD__FMT__IR_template::operator=(const OPTIONAL<RSL__IPA__RTP__CSD__FMT__IR>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IPA__RTP__CSD__FMT__IR::enum_type)(const RSL__IPA__RTP__CSD__FMT__IR&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
}
return *this;
}

RSL__IPA__RTP__CSD__FMT__IR_template& RSL__IPA__RTP__CSD__FMT__IR_template::operator=(const RSL__IPA__RTP__CSD__FMT__IR_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IPA__RTP__CSD__FMT__IR_template::match(RSL__IPA__RTP__CSD__FMT__IR::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
}
return FALSE;
}

boolean RSL__IPA__RTP__CSD__FMT__IR_template::match(const RSL__IPA__RTP__CSD__FMT__IR& other_value, boolean) const
{
if (other_value.enum_value == RSL__IPA__RTP__CSD__FMT__IR::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR with an unbound value.");
return match(other_value.enum_value);
}

RSL__IPA__RTP__CSD__FMT__IR::enum_type RSL__IPA__RTP__CSD__FMT__IR_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
return single_value;
}

void RSL__IPA__RTP__CSD__FMT__IR_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IPA__RTP__CSD__FMT__IR_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
}
}

RSL__IPA__RTP__CSD__FMT__IR_template& RSL__IPA__RTP__CSD__FMT__IR_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
return value_list.list_value[list_index];
}

void RSL__IPA__RTP__CSD__FMT__IR_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(RSL__IPA__RTP__CSD__FMT__IR::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IPA__RTP__CSD__FMT__IR_template::log_match(const RSL__IPA__RTP__CSD__FMT__IR& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void RSL__IPA__RTP__CSD__FMT__IR_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
}
}

void RSL__IPA__RTP__CSD__FMT__IR_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (RSL__IPA__RTP__CSD__FMT__IR::enum_type)text_buf.pull_int().get_val();
if (!RSL__IPA__RTP__CSD__FMT__IR::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IPA__RTP__CSD__FMT__IR_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
}
}

boolean RSL__IPA__RTP__CSD__FMT__IR_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IPA__RTP__CSD__FMT__IR_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RSL__IPA__RTP__CSD__FMT__IR_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IPA__RTP__CSD__FMT__IR_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    RSL__IPA__RTP__CSD__FMT__IR::enum_type enum_val = RSL__IPA__RTP__CSD__FMT__IR::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!RSL__IPA__RTP__CSD__FMT__IR::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @RSL_Types.RSL_IPA_RTP_CSD_FMT_IR.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IPA__RTP__CSD__FMT__IR_template* precondition = new RSL__IPA__RTP__CSD__FMT__IR_template;
    precondition->set_param(*m_p->get_elem(0));
    RSL__IPA__RTP__CSD__FMT__IR_template* implied_template = new RSL__IPA__RTP__CSD__FMT__IR_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = RSL__IPA__RTP__CSD__FMT__IR_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@RSL_Types.RSL_IPA_RTP_CSD_FMT_IR");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IPA__RTP__CSD__FMT__IR_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IPA_RTP_CSD_FMT_IR");
}

RSL__IE__IPA__RTP__CSD__FMT::RSL__IE__IPA__RTP__CSD__FMT()
{
}

RSL__IE__IPA__RTP__CSD__FMT::RSL__IE__IPA__RTP__CSD__FMT(const RSL__IPA__RTP__CSD__FMT__IR& par_ir,
    const RSL__IPA__RTP__CSD__FMT__D& par_d)
  :   field_ir(par_ir),
  field_d(par_d)
{
}

RSL__IE__IPA__RTP__CSD__FMT::RSL__IE__IPA__RTP__CSD__FMT(const RSL__IE__IPA__RTP__CSD__FMT& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
if (other_value.ir().is_bound()) field_ir = other_value.ir();
else field_ir.clean_up();
if (other_value.d().is_bound()) field_d = other_value.d();
else field_d.clean_up();
}

void RSL__IE__IPA__RTP__CSD__FMT::clean_up()
{
field_ir.clean_up();
field_d.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__IPA__RTP__CSD__FMT::get_descriptor() const { return &RSL__IE__IPA__RTP__CSD__FMT_descr_; }
RSL__IE__IPA__RTP__CSD__FMT& RSL__IE__IPA__RTP__CSD__FMT::operator=(const RSL__IE__IPA__RTP__CSD__FMT& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
  if (other_value.ir().is_bound()) field_ir = other_value.ir();
  else field_ir.clean_up();
  if (other_value.d().is_bound()) field_d = other_value.d();
  else field_d.clean_up();
}
return *this;
}

boolean RSL__IE__IPA__RTP__CSD__FMT::operator==(const RSL__IE__IPA__RTP__CSD__FMT& other_value) const
{
return field_ir==other_value.field_ir
  && field_d==other_value.field_d;
}

boolean RSL__IE__IPA__RTP__CSD__FMT::is_bound() const
{
return (field_ir.is_bound())
  || (field_d.is_bound());
}
boolean RSL__IE__IPA__RTP__CSD__FMT::is_value() const
{
return field_ir.is_value()
  && field_d.is_value();
}
void RSL__IE__IPA__RTP__CSD__FMT::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ ir := ");
field_ir.log();
TTCN_Logger::log_event_str(", d := ");
field_d.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__IPA__RTP__CSD__FMT::set_implicit_omit()
{
if (ir().is_bound()) ir().set_implicit_omit();
if (d().is_bound()) d().set_implicit_omit();
}

void RSL__IE__IPA__RTP__CSD__FMT::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) ir().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) d().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ir")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ir().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "d")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          d().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_IPA_RTP_CSD_FMT");
  }
}

void RSL__IE__IPA__RTP__CSD__FMT::encode_text(Text_Buf& text_buf) const
{
field_ir.encode_text(text_buf);
field_d.encode_text(text_buf);
}

void RSL__IE__IPA__RTP__CSD__FMT::decode_text(Text_Buf& text_buf)
{
field_ir.decode_text(text_buf);
field_d.decode_text(text_buf);
}

void RSL__IE__IPA__RTP__CSD__FMT::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__IPA__RTP__CSD__FMT::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__IPA__RTP__CSD__FMT::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__IPA__RTP__CSD__FMT_ir_descr_.raw->forceomit);
  decoded_field_length = field_ir.RAW_decode(RSL__IE__IPA__RTP__CSD__FMT_ir_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__IPA__RTP__CSD__FMT_d_descr_.raw->forceomit);
  decoded_field_length = field_d.RAW_decode(RSL__IE__IPA__RTP__CSD__FMT_d_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__IPA__RTP__CSD__FMT::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__IPA__RTP__CSD__FMT_ir_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__IPA__RTP__CSD__FMT_d_descr_.raw);
  encoded_length += field_ir.RAW_encode(RSL__IE__IPA__RTP__CSD__FMT_ir_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_d.RAW_encode(RSL__IE__IPA__RTP__CSD__FMT_d_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__IPA__RTP__CSD__FMT_template::single_value_struct {
RSL__IPA__RTP__CSD__FMT__IR_template field_ir;
RSL__IPA__RTP__CSD__FMT__D_template field_d;
};

void RSL__IE__IPA__RTP__CSD__FMT_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_ir = ANY_VALUE;
single_value->field_d = ANY_VALUE;
}
}
}

void RSL__IE__IPA__RTP__CSD__FMT_template::copy_value(const RSL__IE__IPA__RTP__CSD__FMT& other_value)
{
single_value = new single_value_struct;
if (other_value.ir().is_bound()) {
  single_value->field_ir = other_value.ir();
} else {
  single_value->field_ir.clean_up();
}
if (other_value.d().is_bound()) {
  single_value->field_d = other_value.d();
} else {
  single_value->field_d.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__IPA__RTP__CSD__FMT_template::copy_template(const RSL__IE__IPA__RTP__CSD__FMT_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.ir().get_selection()) {
single_value->field_ir = other_value.ir();
} else {
single_value->field_ir.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.d().get_selection()) {
single_value->field_d = other_value.d();
} else {
single_value->field_d.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__IPA__RTP__CSD__FMT_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__IPA__RTP__CSD__FMT_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__IPA__RTP__CSD__FMT_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
break;
}
set_selection(other_value);
}

RSL__IE__IPA__RTP__CSD__FMT_template::RSL__IE__IPA__RTP__CSD__FMT_template()
{
}

RSL__IE__IPA__RTP__CSD__FMT_template::RSL__IE__IPA__RTP__CSD__FMT_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__IPA__RTP__CSD__FMT_template::RSL__IE__IPA__RTP__CSD__FMT_template(const RSL__IE__IPA__RTP__CSD__FMT& other_value)
{
copy_value(other_value);
}

RSL__IE__IPA__RTP__CSD__FMT_template::RSL__IE__IPA__RTP__CSD__FMT_template(const OPTIONAL<RSL__IE__IPA__RTP__CSD__FMT>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__IPA__RTP__CSD__FMT&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT from an unbound optional field.");
}
}

RSL__IE__IPA__RTP__CSD__FMT_template::RSL__IE__IPA__RTP__CSD__FMT_template(RSL__IE__IPA__RTP__CSD__FMT_template* p_precondition, RSL__IE__IPA__RTP__CSD__FMT_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__IPA__RTP__CSD__FMT_template::RSL__IE__IPA__RTP__CSD__FMT_template(Dynamic_Match_Interface<RSL__IE__IPA__RTP__CSD__FMT>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__IPA__RTP__CSD__FMT>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__IPA__RTP__CSD__FMT_template::RSL__IE__IPA__RTP__CSD__FMT_template(const RSL__IE__IPA__RTP__CSD__FMT_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__IPA__RTP__CSD__FMT_template::~RSL__IE__IPA__RTP__CSD__FMT_template()
{
clean_up();
}

RSL__IE__IPA__RTP__CSD__FMT_template& RSL__IE__IPA__RTP__CSD__FMT_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__IPA__RTP__CSD__FMT_template& RSL__IE__IPA__RTP__CSD__FMT_template::operator=(const RSL__IE__IPA__RTP__CSD__FMT& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__IPA__RTP__CSD__FMT_template& RSL__IE__IPA__RTP__CSD__FMT_template::operator=(const OPTIONAL<RSL__IE__IPA__RTP__CSD__FMT>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__IPA__RTP__CSD__FMT&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
}
return *this;
}

RSL__IE__IPA__RTP__CSD__FMT_template& RSL__IE__IPA__RTP__CSD__FMT_template::operator=(const RSL__IE__IPA__RTP__CSD__FMT_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__IPA__RTP__CSD__FMT_template::match(const RSL__IE__IPA__RTP__CSD__FMT& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.ir().is_bound()) return FALSE;
if(!single_value->field_ir.match(other_value.ir(), legacy))return FALSE;
if(!other_value.d().is_bound()) return FALSE;
if(!single_value->field_d.match(other_value.d(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
}
return FALSE;
}

boolean RSL__IE__IPA__RTP__CSD__FMT_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_ir.is_bound()
 || single_value->field_d.is_bound();
}

boolean RSL__IE__IPA__RTP__CSD__FMT_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_ir.is_value()
 && single_value->field_d.is_value();
}

void RSL__IE__IPA__RTP__CSD__FMT_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__IPA__RTP__CSD__FMT RSL__IE__IPA__RTP__CSD__FMT_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
RSL__IE__IPA__RTP__CSD__FMT ret_val;
if (single_value->field_ir.is_bound()) {
ret_val.ir() = single_value->field_ir.valueof();
}
if (single_value->field_d.is_bound()) {
ret_val.d() = single_value->field_d.valueof();
}
return ret_val;
}

void RSL__IE__IPA__RTP__CSD__FMT_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__IPA__RTP__CSD__FMT_template[list_length];
}

RSL__IE__IPA__RTP__CSD__FMT_template& RSL__IE__IPA__RTP__CSD__FMT_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
return value_list.list_value[list_index];
}

RSL__IPA__RTP__CSD__FMT__IR_template& RSL__IE__IPA__RTP__CSD__FMT_template::ir()
{
set_specific();
return single_value->field_ir;
}

const RSL__IPA__RTP__CSD__FMT__IR_template& RSL__IE__IPA__RTP__CSD__FMT_template::ir() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ir of a non-specific template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
return single_value->field_ir;
}

RSL__IPA__RTP__CSD__FMT__D_template& RSL__IE__IPA__RTP__CSD__FMT_template::d()
{
set_specific();
return single_value->field_d;
}

const RSL__IPA__RTP__CSD__FMT__D_template& RSL__IE__IPA__RTP__CSD__FMT_template::d() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field d of a non-specific template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
return single_value->field_d;
}

int RSL__IE__IPA__RTP__CSD__FMT_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
  }
  return 0;
}

void RSL__IE__IPA__RTP__CSD__FMT_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ ir := ");
single_value->field_ir.log();
TTCN_Logger::log_event_str(", d := ");
single_value->field_d.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__IPA__RTP__CSD__FMT_template::log_match(const RSL__IE__IPA__RTP__CSD__FMT& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_ir.match(match_value.ir(), legacy)){
TTCN_Logger::log_logmatch_info(".ir");
single_value->field_ir.log_match(match_value.ir(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_d.match(match_value.d(), legacy)){
TTCN_Logger::log_logmatch_info(".d");
single_value->field_d.log_match(match_value.d(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ ir := ");
single_value->field_ir.log_match(match_value.ir(), legacy);
TTCN_Logger::log_event_str(", d := ");
single_value->field_d.log_match(match_value.d(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__IPA__RTP__CSD__FMT_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (ir().is_bound()) ir().set_implicit_omit();
if (d().is_bound()) d().set_implicit_omit();
}

void RSL__IE__IPA__RTP__CSD__FMT_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_ir.encode_text(text_buf);
single_value->field_d.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
}
}

void RSL__IE__IPA__RTP__CSD__FMT_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_ir.decode_text(text_buf);
single_value->field_d.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__IPA__RTP__CSD__FMT_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT.");
}
}

void RSL__IE__IPA__RTP__CSD__FMT_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__IPA__RTP__CSD__FMT_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) ir().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) d().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ir")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ir().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "d")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          d().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_IPA_RTP_CSD_FMT: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__IPA__RTP__CSD__FMT_template* precondition = new RSL__IE__IPA__RTP__CSD__FMT_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__IPA__RTP__CSD__FMT_template* implied_template = new RSL__IE__IPA__RTP__CSD__FMT_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__IPA__RTP__CSD__FMT_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_IPA_RTP_CSD_FMT");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__IPA__RTP__CSD__FMT_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_ir.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_RTP_CSD_FMT");
single_value->field_d.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_IPA_RTP_CSD_FMT");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_IPA_RTP_CSD_FMT");
}

boolean RSL__IE__IPA__RTP__CSD__FMT_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__IPA__RTP__CSD__FMT_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IE__ReleaseMode::RSL__IE__ReleaseMode()
{
enum_value = UNBOUND_VALUE;
}

RSL__IE__ReleaseMode::RSL__IE__ReleaseMode(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @RSL_Types.RSL_IE_ReleaseMode with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

RSL__IE__ReleaseMode::RSL__IE__ReleaseMode(enum_type other_value)
{
enum_value = other_value;
}

RSL__IE__ReleaseMode::RSL__IE__ReleaseMode(const RSL__IE__ReleaseMode& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
enum_value = other_value.enum_value;
}

RSL__IE__ReleaseMode& RSL__IE__ReleaseMode::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @RSL_Types.RSL_IE_ReleaseMode.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

RSL__IE__ReleaseMode& RSL__IE__ReleaseMode::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

RSL__IE__ReleaseMode& RSL__IE__ReleaseMode::operator=(const RSL__IE__ReleaseMode& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
enum_value = other_value.enum_value;
return *this;
}

boolean RSL__IE__ReleaseMode::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IE_ReleaseMode comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean RSL__IE__ReleaseMode::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
return enum_value == other_value;
}

boolean RSL__IE__ReleaseMode::operator==(const RSL__IE__ReleaseMode& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
return enum_value == other_value.enum_value;
}

boolean RSL__IE__ReleaseMode::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IE_ReleaseMode comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean RSL__IE__ReleaseMode::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
return enum_value < other_value;
}

boolean RSL__IE__ReleaseMode::operator<(const RSL__IE__ReleaseMode& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
return enum_value < other_value.enum_value;
}

boolean RSL__IE__ReleaseMode::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @RSL_Types.RSL_IE_ReleaseMode comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean RSL__IE__ReleaseMode::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
return enum_value > other_value;
}

boolean RSL__IE__ReleaseMode::operator>(const RSL__IE__ReleaseMode& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
return enum_value > other_value.enum_value;
}

const char *RSL__IE__ReleaseMode::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case RSL__REL__MODE__NORMAL: return "RSL_REL_MODE_NORMAL";
case RSL__REL__MODE__LOCAL: return "RSL_REL_MODE_LOCAL";
default:
return "<unknown>";
}
}

RSL__IE__ReleaseMode::enum_type RSL__IE__ReleaseMode::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "RSL_REL_MODE_NORMAL")) return RSL__REL__MODE__NORMAL;
if (!strcmp(str_par, "RSL_REL_MODE_LOCAL")) return RSL__REL__MODE__LOCAL;
}
return UNKNOWN_VALUE;
}

boolean RSL__IE__ReleaseMode::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
return TRUE;
default:
return FALSE;
}
}

int RSL__IE__ReleaseMode::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int RSL__IE__ReleaseMode::enum2int(const RSL__IE__ReleaseMode& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void RSL__IE__ReleaseMode::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @RSL_Types.RSL_IE_ReleaseMode.", int_val);
enum_value = (enum_type)int_val;
}

RSL__IE__ReleaseMode::operator RSL__IE__ReleaseMode::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
return enum_value;
}

void RSL__IE__ReleaseMode::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void RSL__IE__ReleaseMode::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@RSL_Types.RSL_IE_ReleaseMode");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @RSL_Types.RSL_IE_ReleaseMode.");
  }
}

void RSL__IE__ReleaseMode::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
text_buf.push_int(enum_value);
}

void RSL__IE__ReleaseMode::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @RSL_Types.RSL_IE_ReleaseMode.", enum_value);
}

void RSL__IE__ReleaseMode::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__ReleaseMode::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__ReleaseMode::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int RSL__IE__ReleaseMode::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void RSL__IE__ReleaseMode_template::copy_template(const RSL__IE__ReleaseMode_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__ReleaseMode_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__ReleaseMode_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__ReleaseMode_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
}
}

RSL__IE__ReleaseMode_template::RSL__IE__ReleaseMode_template()
{
}

RSL__IE__ReleaseMode_template::RSL__IE__ReleaseMode_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__ReleaseMode_template::RSL__IE__ReleaseMode_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!RSL__IE__ReleaseMode::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @RSL_Types.RSL_IE_ReleaseMode with unknown numeric value %d.", other_value);
single_value = (RSL__IE__ReleaseMode::enum_type)other_value;
}

RSL__IE__ReleaseMode_template::RSL__IE__ReleaseMode_template(RSL__IE__ReleaseMode::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

RSL__IE__ReleaseMode_template::RSL__IE__ReleaseMode_template(const RSL__IE__ReleaseMode& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == RSL__IE__ReleaseMode::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
single_value = other_value.enum_value;
}

RSL__IE__ReleaseMode_template::RSL__IE__ReleaseMode_template(const OPTIONAL<RSL__IE__ReleaseMode>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IE__ReleaseMode::enum_type)(const RSL__IE__ReleaseMode&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @RSL_Types.RSL_IE_ReleaseMode from an unbound optional field.");
}
}

RSL__IE__ReleaseMode_template::RSL__IE__ReleaseMode_template(RSL__IE__ReleaseMode_template* p_precondition, RSL__IE__ReleaseMode_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__ReleaseMode_template::RSL__IE__ReleaseMode_template(Dynamic_Match_Interface<RSL__IE__ReleaseMode>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__ReleaseMode>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__ReleaseMode_template::RSL__IE__ReleaseMode_template(const RSL__IE__ReleaseMode_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

RSL__IE__ReleaseMode_template::~RSL__IE__ReleaseMode_template()
{
clean_up();
}

boolean RSL__IE__ReleaseMode_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean RSL__IE__ReleaseMode_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != RSL__IE__ReleaseMode::UNBOUND_VALUE;
}

void RSL__IE__ReleaseMode_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__ReleaseMode_template& RSL__IE__ReleaseMode_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__ReleaseMode_template& RSL__IE__ReleaseMode_template::operator=(int other_value)
{
if (!RSL__IE__ReleaseMode::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @RSL_Types.RSL_IE_ReleaseMode.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IE__ReleaseMode::enum_type)other_value;
return *this;
}

RSL__IE__ReleaseMode_template& RSL__IE__ReleaseMode_template::operator=(RSL__IE__ReleaseMode::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

RSL__IE__ReleaseMode_template& RSL__IE__ReleaseMode_template::operator=(const RSL__IE__ReleaseMode& other_value)
{
if (other_value.enum_value == RSL__IE__ReleaseMode::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @RSL_Types.RSL_IE_ReleaseMode to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

RSL__IE__ReleaseMode_template& RSL__IE__ReleaseMode_template::operator=(const OPTIONAL<RSL__IE__ReleaseMode>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RSL__IE__ReleaseMode::enum_type)(const RSL__IE__ReleaseMode&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
}
return *this;
}

RSL__IE__ReleaseMode_template& RSL__IE__ReleaseMode_template::operator=(const RSL__IE__ReleaseMode_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__ReleaseMode_template::match(RSL__IE__ReleaseMode::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
}
return FALSE;
}

boolean RSL__IE__ReleaseMode_template::match(const RSL__IE__ReleaseMode& other_value, boolean) const
{
if (other_value.enum_value == RSL__IE__ReleaseMode::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @RSL_Types.RSL_IE_ReleaseMode with an unbound value.");
return match(other_value.enum_value);
}

RSL__IE__ReleaseMode::enum_type RSL__IE__ReleaseMode_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
return single_value;
}

void RSL__IE__ReleaseMode_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__ReleaseMode_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
}
}

RSL__IE__ReleaseMode_template& RSL__IE__ReleaseMode_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
return value_list.list_value[list_index];
}

void RSL__IE__ReleaseMode_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(RSL__IE__ReleaseMode::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__ReleaseMode_template::log_match(const RSL__IE__ReleaseMode& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void RSL__IE__ReleaseMode_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
}
}

void RSL__IE__ReleaseMode_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (RSL__IE__ReleaseMode::enum_type)text_buf.pull_int().get_val();
if (!RSL__IE__ReleaseMode::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @RSL_Types.RSL_IE_ReleaseMode.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__ReleaseMode_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @RSL_Types.RSL_IE_ReleaseMode.");
}
}

boolean RSL__IE__ReleaseMode_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__ReleaseMode_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RSL__IE__ReleaseMode_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__ReleaseMode_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    RSL__IE__ReleaseMode::enum_type enum_val = RSL__IE__ReleaseMode::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!RSL__IE__ReleaseMode::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @RSL_Types.RSL_IE_ReleaseMode.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__ReleaseMode_template* precondition = new RSL__IE__ReleaseMode_template;
    precondition->set_param(*m_p->get_elem(0));
    RSL__IE__ReleaseMode_template* implied_template = new RSL__IE__ReleaseMode_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = RSL__IE__ReleaseMode_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@RSL_Types.RSL_IE_ReleaseMode");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__ReleaseMode_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_ReleaseMode");
}

RSL__IE__OSMO__TrainingSequence::RSL__IE__OSMO__TrainingSequence()
{
}

RSL__IE__OSMO__TrainingSequence::RSL__IE__OSMO__TrainingSequence(const INTEGER& par_len,
    const INTEGER& par_tsc__set,
    const INTEGER& par_tsc)
  :   field_len(par_len),
  field_tsc__set(par_tsc__set),
  field_tsc(par_tsc)
{
}

RSL__IE__OSMO__TrainingSequence::RSL__IE__OSMO__TrainingSequence(const RSL__IE__OSMO__TrainingSequence& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.tsc__set().is_bound()) field_tsc__set = other_value.tsc__set();
else field_tsc__set.clean_up();
if (other_value.tsc().is_bound()) field_tsc = other_value.tsc();
else field_tsc.clean_up();
}

void RSL__IE__OSMO__TrainingSequence::clean_up()
{
field_len.clean_up();
field_tsc__set.clean_up();
field_tsc.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__OSMO__TrainingSequence::get_descriptor() const { return &RSL__IE__OSMO__TrainingSequence_descr_; }
RSL__IE__OSMO__TrainingSequence& RSL__IE__OSMO__TrainingSequence::operator=(const RSL__IE__OSMO__TrainingSequence& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.tsc__set().is_bound()) field_tsc__set = other_value.tsc__set();
  else field_tsc__set.clean_up();
  if (other_value.tsc().is_bound()) field_tsc = other_value.tsc();
  else field_tsc.clean_up();
}
return *this;
}

boolean RSL__IE__OSMO__TrainingSequence::operator==(const RSL__IE__OSMO__TrainingSequence& other_value) const
{
return field_len==other_value.field_len
  && field_tsc__set==other_value.field_tsc__set
  && field_tsc==other_value.field_tsc;
}

boolean RSL__IE__OSMO__TrainingSequence::is_bound() const
{
return (field_len.is_bound())
  || (field_tsc__set.is_bound())
  || (field_tsc.is_bound());
}
boolean RSL__IE__OSMO__TrainingSequence::is_value() const
{
return field_len.is_value()
  && field_tsc__set.is_value()
  && field_tsc.is_value();
}
void RSL__IE__OSMO__TrainingSequence::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len := ");
field_len.log();
TTCN_Logger::log_event_str(", tsc_set := ");
field_tsc__set.log();
TTCN_Logger::log_event_str(", tsc := ");
field_tsc.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__OSMO__TrainingSequence::set_implicit_omit()
{
if (len().is_bound()) len().set_implicit_omit();
if (tsc__set().is_bound()) tsc__set().set_implicit_omit();
if (tsc().is_bound()) tsc().set_implicit_omit();
}

void RSL__IE__OSMO__TrainingSequence::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_OSMO_TrainingSequence has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) tsc__set().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) tsc().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tsc_set")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tsc__set().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tsc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tsc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_OSMO_TrainingSequence: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_OSMO_TrainingSequence");
  }
}

void RSL__IE__OSMO__TrainingSequence::encode_text(Text_Buf& text_buf) const
{
field_len.encode_text(text_buf);
field_tsc__set.encode_text(text_buf);
field_tsc.encode_text(text_buf);
}

void RSL__IE__OSMO__TrainingSequence::decode_text(Text_Buf& text_buf)
{
field_len.decode_text(text_buf);
field_tsc__set.decode_text(text_buf);
field_tsc.decode_text(text_buf);
}

void RSL__IE__OSMO__TrainingSequence::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__OSMO__TrainingSequence::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__OSMO__TrainingSequence::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__OSMO__TrainingSequence_len_descr_.raw->forceomit);
  decoded_field_length = field_len.RAW_decode(RSL__IE__OSMO__TrainingSequence_len_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_len.convert_to_Integer(RSL__IE__OSMO__TrainingSequence_len_descr_);
  field_len = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__OSMO__TrainingSequence_tsc__set_descr_.raw->forceomit);
  decoded_field_length = field_tsc__set.RAW_decode(RSL__IE__OSMO__TrainingSequence_tsc__set_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RSL__IE__OSMO__TrainingSequence_tsc_descr_.raw->forceomit);
  decoded_field_length = field_tsc.RAW_decode(RSL__IE__OSMO__TrainingSequence_tsc_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__OSMO__TrainingSequence::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__OSMO__TrainingSequence_len_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__OSMO__TrainingSequence_tsc__set_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RSL__IE__OSMO__TrainingSequence_tsc_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &RSL__IE__OSMO__TrainingSequence_len_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 2;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(2);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  encoded_length += field_tsc__set.RAW_encode(RSL__IE__OSMO__TrainingSequence_tsc__set_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_tsc.RAW_encode(RSL__IE__OSMO__TrainingSequence_tsc_descr_, *myleaf.body.node.nodes[2]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__OSMO__TrainingSequence_template::single_value_struct {
INTEGER_template field_len;
INTEGER_template field_tsc__set;
INTEGER_template field_tsc;
};

void RSL__IE__OSMO__TrainingSequence_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_len = ANY_VALUE;
single_value->field_tsc__set = ANY_VALUE;
single_value->field_tsc = ANY_VALUE;
}
}
}

void RSL__IE__OSMO__TrainingSequence_template::copy_value(const RSL__IE__OSMO__TrainingSequence& other_value)
{
single_value = new single_value_struct;
if (other_value.len().is_bound()) {
  single_value->field_len = other_value.len();
} else {
  single_value->field_len.clean_up();
}
if (other_value.tsc__set().is_bound()) {
  single_value->field_tsc__set = other_value.tsc__set();
} else {
  single_value->field_tsc__set.clean_up();
}
if (other_value.tsc().is_bound()) {
  single_value->field_tsc = other_value.tsc();
} else {
  single_value->field_tsc.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__OSMO__TrainingSequence_template::copy_template(const RSL__IE__OSMO__TrainingSequence_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.len().get_selection()) {
single_value->field_len = other_value.len();
} else {
single_value->field_len.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tsc__set().get_selection()) {
single_value->field_tsc__set = other_value.tsc__set();
} else {
single_value->field_tsc__set.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tsc().get_selection()) {
single_value->field_tsc = other_value.tsc();
} else {
single_value->field_tsc.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__OSMO__TrainingSequence_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__OSMO__TrainingSequence_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__OSMO__TrainingSequence_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
break;
}
set_selection(other_value);
}

RSL__IE__OSMO__TrainingSequence_template::RSL__IE__OSMO__TrainingSequence_template()
{
}

RSL__IE__OSMO__TrainingSequence_template::RSL__IE__OSMO__TrainingSequence_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__OSMO__TrainingSequence_template::RSL__IE__OSMO__TrainingSequence_template(const RSL__IE__OSMO__TrainingSequence& other_value)
{
copy_value(other_value);
}

RSL__IE__OSMO__TrainingSequence_template::RSL__IE__OSMO__TrainingSequence_template(const OPTIONAL<RSL__IE__OSMO__TrainingSequence>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__OSMO__TrainingSequence&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence from an unbound optional field.");
}
}

RSL__IE__OSMO__TrainingSequence_template::RSL__IE__OSMO__TrainingSequence_template(RSL__IE__OSMO__TrainingSequence_template* p_precondition, RSL__IE__OSMO__TrainingSequence_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__OSMO__TrainingSequence_template::RSL__IE__OSMO__TrainingSequence_template(Dynamic_Match_Interface<RSL__IE__OSMO__TrainingSequence>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__OSMO__TrainingSequence>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__OSMO__TrainingSequence_template::RSL__IE__OSMO__TrainingSequence_template(const RSL__IE__OSMO__TrainingSequence_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__OSMO__TrainingSequence_template::~RSL__IE__OSMO__TrainingSequence_template()
{
clean_up();
}

RSL__IE__OSMO__TrainingSequence_template& RSL__IE__OSMO__TrainingSequence_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__OSMO__TrainingSequence_template& RSL__IE__OSMO__TrainingSequence_template::operator=(const RSL__IE__OSMO__TrainingSequence& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__OSMO__TrainingSequence_template& RSL__IE__OSMO__TrainingSequence_template::operator=(const OPTIONAL<RSL__IE__OSMO__TrainingSequence>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__OSMO__TrainingSequence&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
}
return *this;
}

RSL__IE__OSMO__TrainingSequence_template& RSL__IE__OSMO__TrainingSequence_template::operator=(const RSL__IE__OSMO__TrainingSequence_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__OSMO__TrainingSequence_template::match(const RSL__IE__OSMO__TrainingSequence& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.len().is_bound()) return FALSE;
if(!single_value->field_len.match(other_value.len(), legacy))return FALSE;
if(!other_value.tsc__set().is_bound()) return FALSE;
if(!single_value->field_tsc__set.match(other_value.tsc__set(), legacy))return FALSE;
if(!other_value.tsc().is_bound()) return FALSE;
if(!single_value->field_tsc.match(other_value.tsc(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
}
return FALSE;
}

boolean RSL__IE__OSMO__TrainingSequence_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_len.is_bound()
 || single_value->field_tsc__set.is_bound()
 || single_value->field_tsc.is_bound();
}

boolean RSL__IE__OSMO__TrainingSequence_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_len.is_value()
 && single_value->field_tsc__set.is_value()
 && single_value->field_tsc.is_value();
}

void RSL__IE__OSMO__TrainingSequence_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__OSMO__TrainingSequence RSL__IE__OSMO__TrainingSequence_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
RSL__IE__OSMO__TrainingSequence ret_val;
if (single_value->field_len.is_bound()) {
ret_val.len() = single_value->field_len.valueof();
}
if (single_value->field_tsc__set.is_bound()) {
ret_val.tsc__set() = single_value->field_tsc__set.valueof();
}
if (single_value->field_tsc.is_bound()) {
ret_val.tsc() = single_value->field_tsc.valueof();
}
return ret_val;
}

void RSL__IE__OSMO__TrainingSequence_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__OSMO__TrainingSequence_template[list_length];
}

RSL__IE__OSMO__TrainingSequence_template& RSL__IE__OSMO__TrainingSequence_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__OSMO__TrainingSequence_template::len()
{
set_specific();
return single_value->field_len;
}

const INTEGER_template& RSL__IE__OSMO__TrainingSequence_template::len() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len of a non-specific template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
return single_value->field_len;
}

INTEGER_template& RSL__IE__OSMO__TrainingSequence_template::tsc__set()
{
set_specific();
return single_value->field_tsc__set;
}

const INTEGER_template& RSL__IE__OSMO__TrainingSequence_template::tsc__set() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tsc_set of a non-specific template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
return single_value->field_tsc__set;
}

INTEGER_template& RSL__IE__OSMO__TrainingSequence_template::tsc()
{
set_specific();
return single_value->field_tsc;
}

const INTEGER_template& RSL__IE__OSMO__TrainingSequence_template::tsc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tsc of a non-specific template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
return single_value->field_tsc;
}

int RSL__IE__OSMO__TrainingSequence_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
  }
  return 0;
}

void RSL__IE__OSMO__TrainingSequence_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log();
TTCN_Logger::log_event_str(", tsc_set := ");
single_value->field_tsc__set.log();
TTCN_Logger::log_event_str(", tsc := ");
single_value->field_tsc.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__OSMO__TrainingSequence_template::log_match(const RSL__IE__OSMO__TrainingSequence& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_len.match(match_value.len(), legacy)){
TTCN_Logger::log_logmatch_info(".len");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_tsc__set.match(match_value.tsc__set(), legacy)){
TTCN_Logger::log_logmatch_info(".tsc_set");
single_value->field_tsc__set.log_match(match_value.tsc__set(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_tsc.match(match_value.tsc(), legacy)){
TTCN_Logger::log_logmatch_info(".tsc");
single_value->field_tsc.log_match(match_value.tsc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::log_event_str(", tsc_set := ");
single_value->field_tsc__set.log_match(match_value.tsc__set(), legacy);
TTCN_Logger::log_event_str(", tsc := ");
single_value->field_tsc.log_match(match_value.tsc(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__OSMO__TrainingSequence_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (len().is_bound()) len().set_implicit_omit();
if (tsc__set().is_bound()) tsc__set().set_implicit_omit();
if (tsc().is_bound()) tsc().set_implicit_omit();
}

void RSL__IE__OSMO__TrainingSequence_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_len.encode_text(text_buf);
single_value->field_tsc__set.encode_text(text_buf);
single_value->field_tsc.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
}
}

void RSL__IE__OSMO__TrainingSequence_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_len.decode_text(text_buf);
single_value->field_tsc__set.decode_text(text_buf);
single_value->field_tsc.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__OSMO__TrainingSequence_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence.");
}
}

void RSL__IE__OSMO__TrainingSequence_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__OSMO__TrainingSequence_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_OSMO_TrainingSequence has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) tsc__set().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) tsc().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tsc_set")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tsc__set().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tsc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tsc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_OSMO_TrainingSequence: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__OSMO__TrainingSequence_template* precondition = new RSL__IE__OSMO__TrainingSequence_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__OSMO__TrainingSequence_template* implied_template = new RSL__IE__OSMO__TrainingSequence_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__OSMO__TrainingSequence_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_OSMO_TrainingSequence");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__OSMO__TrainingSequence_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_len.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_TrainingSequence");
single_value->field_tsc__set.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_TrainingSequence");
single_value->field_tsc.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_TrainingSequence");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_TrainingSequence");
}

boolean RSL__IE__OSMO__TrainingSequence_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__OSMO__TrainingSequence_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IE__OSMO__RepAcchCap::RSL__IE__OSMO__RepAcchCap()
{
}

RSL__IE__OSMO__RepAcchCap::RSL__IE__OSMO__RepAcchCap(const INTEGER& par_len,
    const BITSTRING& par_rfu,
    const INTEGER& par_rxqual,
    const BOOLEAN& par_ul__sacch,
    const BOOLEAN& par_dl__sacch,
    const BOOLEAN& par_dl__facch__all,
    const BOOLEAN& par_dl__facch__cmd)
  :   field_len(par_len),
  field_rfu(par_rfu),
  field_rxqual(par_rxqual),
  field_ul__sacch(par_ul__sacch),
  field_dl__sacch(par_dl__sacch),
  field_dl__facch__all(par_dl__facch__all),
  field_dl__facch__cmd(par_dl__facch__cmd)
{
}

RSL__IE__OSMO__RepAcchCap::RSL__IE__OSMO__RepAcchCap(const RSL__IE__OSMO__RepAcchCap& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.rfu().is_bound()) field_rfu = other_value.rfu();
else field_rfu.clean_up();
if (other_value.rxqual().is_bound()) field_rxqual = other_value.rxqual();
else field_rxqual.clean_up();
if (other_value.ul__sacch().is_bound()) field_ul__sacch = other_value.ul__sacch();
else field_ul__sacch.clean_up();
if (other_value.dl__sacch().is_bound()) field_dl__sacch = other_value.dl__sacch();
else field_dl__sacch.clean_up();
if (other_value.dl__facch__all().is_bound()) field_dl__facch__all = other_value.dl__facch__all();
else field_dl__facch__all.clean_up();
if (other_value.dl__facch__cmd().is_bound()) field_dl__facch__cmd = other_value.dl__facch__cmd();
else field_dl__facch__cmd.clean_up();
}

void RSL__IE__OSMO__RepAcchCap::clean_up()
{
field_len.clean_up();
field_rfu.clean_up();
field_rxqual.clean_up();
field_ul__sacch.clean_up();
field_dl__sacch.clean_up();
field_dl__facch__all.clean_up();
field_dl__facch__cmd.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__OSMO__RepAcchCap::get_descriptor() const { return &RSL__IE__OSMO__RepAcchCap_descr_; }
RSL__IE__OSMO__RepAcchCap& RSL__IE__OSMO__RepAcchCap::operator=(const RSL__IE__OSMO__RepAcchCap& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.rfu().is_bound()) field_rfu = other_value.rfu();
  else field_rfu.clean_up();
  if (other_value.rxqual().is_bound()) field_rxqual = other_value.rxqual();
  else field_rxqual.clean_up();
  if (other_value.ul__sacch().is_bound()) field_ul__sacch = other_value.ul__sacch();
  else field_ul__sacch.clean_up();
  if (other_value.dl__sacch().is_bound()) field_dl__sacch = other_value.dl__sacch();
  else field_dl__sacch.clean_up();
  if (other_value.dl__facch__all().is_bound()) field_dl__facch__all = other_value.dl__facch__all();
  else field_dl__facch__all.clean_up();
  if (other_value.dl__facch__cmd().is_bound()) field_dl__facch__cmd = other_value.dl__facch__cmd();
  else field_dl__facch__cmd.clean_up();
}
return *this;
}

boolean RSL__IE__OSMO__RepAcchCap::operator==(const RSL__IE__OSMO__RepAcchCap& other_value) const
{
return field_len==other_value.field_len
  && field_rfu==other_value.field_rfu
  && field_rxqual==other_value.field_rxqual
  && field_ul__sacch==other_value.field_ul__sacch
  && field_dl__sacch==other_value.field_dl__sacch
  && field_dl__facch__all==other_value.field_dl__facch__all
  && field_dl__facch__cmd==other_value.field_dl__facch__cmd;
}

boolean RSL__IE__OSMO__RepAcchCap::is_bound() const
{
return (field_len.is_bound())
  || (field_rfu.is_bound())
  || (field_rxqual.is_bound())
  || (field_ul__sacch.is_bound())
  || (field_dl__sacch.is_bound())
  || (field_dl__facch__all.is_bound())
  || (field_dl__facch__cmd.is_bound());
}
boolean RSL__IE__OSMO__RepAcchCap::is_value() const
{
return field_len.is_value()
  && field_rfu.is_value()
  && field_rxqual.is_value()
  && field_ul__sacch.is_value()
  && field_dl__sacch.is_value()
  && field_dl__facch__all.is_value()
  && field_dl__facch__cmd.is_value();
}
void RSL__IE__OSMO__RepAcchCap::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len := ");
field_len.log();
TTCN_Logger::log_event_str(", rfu := ");
field_rfu.log();
TTCN_Logger::log_event_str(", rxqual := ");
field_rxqual.log();
TTCN_Logger::log_event_str(", ul_sacch := ");
field_ul__sacch.log();
TTCN_Logger::log_event_str(", dl_sacch := ");
field_dl__sacch.log();
TTCN_Logger::log_event_str(", dl_facch_all := ");
field_dl__facch__all.log();
TTCN_Logger::log_event_str(", dl_facch_cmd := ");
field_dl__facch__cmd.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__OSMO__RepAcchCap::set_implicit_omit()
{
if (len().is_bound()) len().set_implicit_omit();
if (rfu().is_bound()) rfu().set_implicit_omit();
if (rxqual().is_bound()) rxqual().set_implicit_omit();
if (ul__sacch().is_bound()) ul__sacch().set_implicit_omit();
if (dl__sacch().is_bound()) dl__sacch().set_implicit_omit();
if (dl__facch__all().is_bound()) dl__facch__all().set_implicit_omit();
if (dl__facch__cmd().is_bound()) dl__facch__cmd().set_implicit_omit();
}

void RSL__IE__OSMO__RepAcchCap::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (7<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_OSMO_RepAcchCap has 7 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) rfu().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) rxqual().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) ul__sacch().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) dl__sacch().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) dl__facch__all().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) dl__facch__cmd().set_param(*param.get_elem(6));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rfu")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rfu().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rxqual")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rxqual().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ul_sacch")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ul__sacch().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dl_sacch")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dl__sacch().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dl_facch_all")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dl__facch__all().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dl_facch_cmd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dl__facch__cmd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_OSMO_RepAcchCap: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_OSMO_RepAcchCap");
  }
}

void RSL__IE__OSMO__RepAcchCap::encode_text(Text_Buf& text_buf) const
{
field_len.encode_text(text_buf);
field_rfu.encode_text(text_buf);
field_rxqual.encode_text(text_buf);
field_ul__sacch.encode_text(text_buf);
field_dl__sacch.encode_text(text_buf);
field_dl__facch__all.encode_text(text_buf);
field_dl__facch__cmd.encode_text(text_buf);
}

void RSL__IE__OSMO__RepAcchCap::decode_text(Text_Buf& text_buf)
{
field_len.decode_text(text_buf);
field_rfu.decode_text(text_buf);
field_rxqual.decode_text(text_buf);
field_ul__sacch.decode_text(text_buf);
field_dl__sacch.decode_text(text_buf);
field_dl__facch__all.decode_text(text_buf);
field_dl__facch__cmd.decode_text(text_buf);
}

void RSL__IE__OSMO__RepAcchCap::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__OSMO__RepAcchCap::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__OSMO__RepAcchCap::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__OSMO__RepAcchCap_len_descr_.raw->forceomit);
  decoded_field_length = field_len.RAW_decode(RSL__IE__OSMO__RepAcchCap_len_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_len.convert_to_Integer(RSL__IE__OSMO__RepAcchCap_len_descr_);
  field_len = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__OSMO__RepAcchCap_rfu_descr_.raw->forceomit);
  decoded_field_length = field_rfu.RAW_decode(RSL__IE__OSMO__RepAcchCap_rfu_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RSL__IE__OSMO__RepAcchCap_rxqual_descr_.raw->forceomit);
  decoded_field_length = field_rxqual.RAW_decode(RSL__IE__OSMO__RepAcchCap_rxqual_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, RSL__IE__OSMO__RepAcchCap_ul__sacch_descr_.raw->forceomit);
  decoded_field_length = field_ul__sacch.RAW_decode(RSL__IE__OSMO__RepAcchCap_ul__sacch_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, RSL__IE__OSMO__RepAcchCap_dl__sacch_descr_.raw->forceomit);
  decoded_field_length = field_dl__sacch.RAW_decode(RSL__IE__OSMO__RepAcchCap_dl__sacch_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_5_force_omit(5, force_omit, RSL__IE__OSMO__RepAcchCap_dl__facch__all_descr_.raw->forceomit);
  decoded_field_length = field_dl__facch__all.RAW_decode(RSL__IE__OSMO__RepAcchCap_dl__facch__all_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_6_force_omit(6, force_omit, RSL__IE__OSMO__RepAcchCap_dl__facch__cmd_descr_.raw->forceomit);
  decoded_field_length = field_dl__facch__cmd.RAW_decode(RSL__IE__OSMO__RepAcchCap_dl__facch__cmd_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__OSMO__RepAcchCap::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 7;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(7);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__OSMO__RepAcchCap_len_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__OSMO__RepAcchCap_rfu_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RSL__IE__OSMO__RepAcchCap_rxqual_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, RSL__IE__OSMO__RepAcchCap_ul__sacch_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, RSL__IE__OSMO__RepAcchCap_dl__sacch_descr_.raw);
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, RSL__IE__OSMO__RepAcchCap_dl__facch__all_descr_.raw);
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, RSL__IE__OSMO__RepAcchCap_dl__facch__cmd_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &RSL__IE__OSMO__RepAcchCap_len_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 6;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(6);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[4].level = myleaf.body.node.nodes[5]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[4].pos = myleaf.body.node.nodes[5]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[5].level = myleaf.body.node.nodes[6]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[5].pos = myleaf.body.node.nodes[6]->curr_pos.pos;
  encoded_length += field_rfu.RAW_encode(RSL__IE__OSMO__RepAcchCap_rfu_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_rxqual.RAW_encode(RSL__IE__OSMO__RepAcchCap_rxqual_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_ul__sacch.RAW_encode(RSL__IE__OSMO__RepAcchCap_ul__sacch_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_dl__sacch.RAW_encode(RSL__IE__OSMO__RepAcchCap_dl__sacch_descr_, *myleaf.body.node.nodes[4]);
  encoded_length += field_dl__facch__all.RAW_encode(RSL__IE__OSMO__RepAcchCap_dl__facch__all_descr_, *myleaf.body.node.nodes[5]);
  encoded_length += field_dl__facch__cmd.RAW_encode(RSL__IE__OSMO__RepAcchCap_dl__facch__cmd_descr_, *myleaf.body.node.nodes[6]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__OSMO__RepAcchCap_template::single_value_struct {
INTEGER_template field_len;
BITSTRING_template field_rfu;
INTEGER_template field_rxqual;
BOOLEAN_template field_ul__sacch;
BOOLEAN_template field_dl__sacch;
BOOLEAN_template field_dl__facch__all;
BOOLEAN_template field_dl__facch__cmd;
};

void RSL__IE__OSMO__RepAcchCap_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_len = ANY_VALUE;
single_value->field_rfu = ANY_VALUE;
single_value->field_rxqual = ANY_VALUE;
single_value->field_ul__sacch = ANY_VALUE;
single_value->field_dl__sacch = ANY_VALUE;
single_value->field_dl__facch__all = ANY_VALUE;
single_value->field_dl__facch__cmd = ANY_VALUE;
}
}
}

void RSL__IE__OSMO__RepAcchCap_template::copy_value(const RSL__IE__OSMO__RepAcchCap& other_value)
{
single_value = new single_value_struct;
if (other_value.len().is_bound()) {
  single_value->field_len = other_value.len();
} else {
  single_value->field_len.clean_up();
}
if (other_value.rfu().is_bound()) {
  single_value->field_rfu = other_value.rfu();
} else {
  single_value->field_rfu.clean_up();
}
if (other_value.rxqual().is_bound()) {
  single_value->field_rxqual = other_value.rxqual();
} else {
  single_value->field_rxqual.clean_up();
}
if (other_value.ul__sacch().is_bound()) {
  single_value->field_ul__sacch = other_value.ul__sacch();
} else {
  single_value->field_ul__sacch.clean_up();
}
if (other_value.dl__sacch().is_bound()) {
  single_value->field_dl__sacch = other_value.dl__sacch();
} else {
  single_value->field_dl__sacch.clean_up();
}
if (other_value.dl__facch__all().is_bound()) {
  single_value->field_dl__facch__all = other_value.dl__facch__all();
} else {
  single_value->field_dl__facch__all.clean_up();
}
if (other_value.dl__facch__cmd().is_bound()) {
  single_value->field_dl__facch__cmd = other_value.dl__facch__cmd();
} else {
  single_value->field_dl__facch__cmd.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__OSMO__RepAcchCap_template::copy_template(const RSL__IE__OSMO__RepAcchCap_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.len().get_selection()) {
single_value->field_len = other_value.len();
} else {
single_value->field_len.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rfu().get_selection()) {
single_value->field_rfu = other_value.rfu();
} else {
single_value->field_rfu.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rxqual().get_selection()) {
single_value->field_rxqual = other_value.rxqual();
} else {
single_value->field_rxqual.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ul__sacch().get_selection()) {
single_value->field_ul__sacch = other_value.ul__sacch();
} else {
single_value->field_ul__sacch.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.dl__sacch().get_selection()) {
single_value->field_dl__sacch = other_value.dl__sacch();
} else {
single_value->field_dl__sacch.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.dl__facch__all().get_selection()) {
single_value->field_dl__facch__all = other_value.dl__facch__all();
} else {
single_value->field_dl__facch__all.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.dl__facch__cmd().get_selection()) {
single_value->field_dl__facch__cmd = other_value.dl__facch__cmd();
} else {
single_value->field_dl__facch__cmd.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__OSMO__RepAcchCap_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__OSMO__RepAcchCap_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__OSMO__RepAcchCap_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
break;
}
set_selection(other_value);
}

RSL__IE__OSMO__RepAcchCap_template::RSL__IE__OSMO__RepAcchCap_template()
{
}

RSL__IE__OSMO__RepAcchCap_template::RSL__IE__OSMO__RepAcchCap_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__OSMO__RepAcchCap_template::RSL__IE__OSMO__RepAcchCap_template(const RSL__IE__OSMO__RepAcchCap& other_value)
{
copy_value(other_value);
}

RSL__IE__OSMO__RepAcchCap_template::RSL__IE__OSMO__RepAcchCap_template(const OPTIONAL<RSL__IE__OSMO__RepAcchCap>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__OSMO__RepAcchCap&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap from an unbound optional field.");
}
}

RSL__IE__OSMO__RepAcchCap_template::RSL__IE__OSMO__RepAcchCap_template(RSL__IE__OSMO__RepAcchCap_template* p_precondition, RSL__IE__OSMO__RepAcchCap_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__OSMO__RepAcchCap_template::RSL__IE__OSMO__RepAcchCap_template(Dynamic_Match_Interface<RSL__IE__OSMO__RepAcchCap>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__OSMO__RepAcchCap>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__OSMO__RepAcchCap_template::RSL__IE__OSMO__RepAcchCap_template(const RSL__IE__OSMO__RepAcchCap_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__OSMO__RepAcchCap_template::~RSL__IE__OSMO__RepAcchCap_template()
{
clean_up();
}

RSL__IE__OSMO__RepAcchCap_template& RSL__IE__OSMO__RepAcchCap_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__OSMO__RepAcchCap_template& RSL__IE__OSMO__RepAcchCap_template::operator=(const RSL__IE__OSMO__RepAcchCap& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__OSMO__RepAcchCap_template& RSL__IE__OSMO__RepAcchCap_template::operator=(const OPTIONAL<RSL__IE__OSMO__RepAcchCap>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__OSMO__RepAcchCap&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
}
return *this;
}

RSL__IE__OSMO__RepAcchCap_template& RSL__IE__OSMO__RepAcchCap_template::operator=(const RSL__IE__OSMO__RepAcchCap_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__OSMO__RepAcchCap_template::match(const RSL__IE__OSMO__RepAcchCap& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.len().is_bound()) return FALSE;
if(!single_value->field_len.match(other_value.len(), legacy))return FALSE;
if(!other_value.rfu().is_bound()) return FALSE;
if(!single_value->field_rfu.match(other_value.rfu(), legacy))return FALSE;
if(!other_value.rxqual().is_bound()) return FALSE;
if(!single_value->field_rxqual.match(other_value.rxqual(), legacy))return FALSE;
if(!other_value.ul__sacch().is_bound()) return FALSE;
if(!single_value->field_ul__sacch.match(other_value.ul__sacch(), legacy))return FALSE;
if(!other_value.dl__sacch().is_bound()) return FALSE;
if(!single_value->field_dl__sacch.match(other_value.dl__sacch(), legacy))return FALSE;
if(!other_value.dl__facch__all().is_bound()) return FALSE;
if(!single_value->field_dl__facch__all.match(other_value.dl__facch__all(), legacy))return FALSE;
if(!other_value.dl__facch__cmd().is_bound()) return FALSE;
if(!single_value->field_dl__facch__cmd.match(other_value.dl__facch__cmd(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
}
return FALSE;
}

boolean RSL__IE__OSMO__RepAcchCap_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_len.is_bound()
 || single_value->field_rfu.is_bound()
 || single_value->field_rxqual.is_bound()
 || single_value->field_ul__sacch.is_bound()
 || single_value->field_dl__sacch.is_bound()
 || single_value->field_dl__facch__all.is_bound()
 || single_value->field_dl__facch__cmd.is_bound();
}

boolean RSL__IE__OSMO__RepAcchCap_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_len.is_value()
 && single_value->field_rfu.is_value()
 && single_value->field_rxqual.is_value()
 && single_value->field_ul__sacch.is_value()
 && single_value->field_dl__sacch.is_value()
 && single_value->field_dl__facch__all.is_value()
 && single_value->field_dl__facch__cmd.is_value();
}

void RSL__IE__OSMO__RepAcchCap_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__OSMO__RepAcchCap RSL__IE__OSMO__RepAcchCap_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
RSL__IE__OSMO__RepAcchCap ret_val;
if (single_value->field_len.is_bound()) {
ret_val.len() = single_value->field_len.valueof();
}
if (single_value->field_rfu.is_bound()) {
ret_val.rfu() = single_value->field_rfu.valueof();
}
if (single_value->field_rxqual.is_bound()) {
ret_val.rxqual() = single_value->field_rxqual.valueof();
}
if (single_value->field_ul__sacch.is_bound()) {
ret_val.ul__sacch() = single_value->field_ul__sacch.valueof();
}
if (single_value->field_dl__sacch.is_bound()) {
ret_val.dl__sacch() = single_value->field_dl__sacch.valueof();
}
if (single_value->field_dl__facch__all.is_bound()) {
ret_val.dl__facch__all() = single_value->field_dl__facch__all.valueof();
}
if (single_value->field_dl__facch__cmd.is_bound()) {
ret_val.dl__facch__cmd() = single_value->field_dl__facch__cmd.valueof();
}
return ret_val;
}

void RSL__IE__OSMO__RepAcchCap_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__OSMO__RepAcchCap_template[list_length];
}

RSL__IE__OSMO__RepAcchCap_template& RSL__IE__OSMO__RepAcchCap_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__OSMO__RepAcchCap_template::len()
{
set_specific();
return single_value->field_len;
}

const INTEGER_template& RSL__IE__OSMO__RepAcchCap_template::len() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len of a non-specific template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
return single_value->field_len;
}

BITSTRING_template& RSL__IE__OSMO__RepAcchCap_template::rfu()
{
set_specific();
return single_value->field_rfu;
}

const BITSTRING_template& RSL__IE__OSMO__RepAcchCap_template::rfu() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rfu of a non-specific template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
return single_value->field_rfu;
}

INTEGER_template& RSL__IE__OSMO__RepAcchCap_template::rxqual()
{
set_specific();
return single_value->field_rxqual;
}

const INTEGER_template& RSL__IE__OSMO__RepAcchCap_template::rxqual() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rxqual of a non-specific template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
return single_value->field_rxqual;
}

BOOLEAN_template& RSL__IE__OSMO__RepAcchCap_template::ul__sacch()
{
set_specific();
return single_value->field_ul__sacch;
}

const BOOLEAN_template& RSL__IE__OSMO__RepAcchCap_template::ul__sacch() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ul_sacch of a non-specific template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
return single_value->field_ul__sacch;
}

BOOLEAN_template& RSL__IE__OSMO__RepAcchCap_template::dl__sacch()
{
set_specific();
return single_value->field_dl__sacch;
}

const BOOLEAN_template& RSL__IE__OSMO__RepAcchCap_template::dl__sacch() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field dl_sacch of a non-specific template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
return single_value->field_dl__sacch;
}

BOOLEAN_template& RSL__IE__OSMO__RepAcchCap_template::dl__facch__all()
{
set_specific();
return single_value->field_dl__facch__all;
}

const BOOLEAN_template& RSL__IE__OSMO__RepAcchCap_template::dl__facch__all() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field dl_facch_all of a non-specific template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
return single_value->field_dl__facch__all;
}

BOOLEAN_template& RSL__IE__OSMO__RepAcchCap_template::dl__facch__cmd()
{
set_specific();
return single_value->field_dl__facch__cmd;
}

const BOOLEAN_template& RSL__IE__OSMO__RepAcchCap_template::dl__facch__cmd() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field dl_facch_cmd of a non-specific template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
return single_value->field_dl__facch__cmd;
}

int RSL__IE__OSMO__RepAcchCap_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 7;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
  }
  return 0;
}

void RSL__IE__OSMO__RepAcchCap_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log();
TTCN_Logger::log_event_str(", rfu := ");
single_value->field_rfu.log();
TTCN_Logger::log_event_str(", rxqual := ");
single_value->field_rxqual.log();
TTCN_Logger::log_event_str(", ul_sacch := ");
single_value->field_ul__sacch.log();
TTCN_Logger::log_event_str(", dl_sacch := ");
single_value->field_dl__sacch.log();
TTCN_Logger::log_event_str(", dl_facch_all := ");
single_value->field_dl__facch__all.log();
TTCN_Logger::log_event_str(", dl_facch_cmd := ");
single_value->field_dl__facch__cmd.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__OSMO__RepAcchCap_template::log_match(const RSL__IE__OSMO__RepAcchCap& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_len.match(match_value.len(), legacy)){
TTCN_Logger::log_logmatch_info(".len");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rfu.match(match_value.rfu(), legacy)){
TTCN_Logger::log_logmatch_info(".rfu");
single_value->field_rfu.log_match(match_value.rfu(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rxqual.match(match_value.rxqual(), legacy)){
TTCN_Logger::log_logmatch_info(".rxqual");
single_value->field_rxqual.log_match(match_value.rxqual(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ul__sacch.match(match_value.ul__sacch(), legacy)){
TTCN_Logger::log_logmatch_info(".ul_sacch");
single_value->field_ul__sacch.log_match(match_value.ul__sacch(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_dl__sacch.match(match_value.dl__sacch(), legacy)){
TTCN_Logger::log_logmatch_info(".dl_sacch");
single_value->field_dl__sacch.log_match(match_value.dl__sacch(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_dl__facch__all.match(match_value.dl__facch__all(), legacy)){
TTCN_Logger::log_logmatch_info(".dl_facch_all");
single_value->field_dl__facch__all.log_match(match_value.dl__facch__all(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_dl__facch__cmd.match(match_value.dl__facch__cmd(), legacy)){
TTCN_Logger::log_logmatch_info(".dl_facch_cmd");
single_value->field_dl__facch__cmd.log_match(match_value.dl__facch__cmd(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::log_event_str(", rfu := ");
single_value->field_rfu.log_match(match_value.rfu(), legacy);
TTCN_Logger::log_event_str(", rxqual := ");
single_value->field_rxqual.log_match(match_value.rxqual(), legacy);
TTCN_Logger::log_event_str(", ul_sacch := ");
single_value->field_ul__sacch.log_match(match_value.ul__sacch(), legacy);
TTCN_Logger::log_event_str(", dl_sacch := ");
single_value->field_dl__sacch.log_match(match_value.dl__sacch(), legacy);
TTCN_Logger::log_event_str(", dl_facch_all := ");
single_value->field_dl__facch__all.log_match(match_value.dl__facch__all(), legacy);
TTCN_Logger::log_event_str(", dl_facch_cmd := ");
single_value->field_dl__facch__cmd.log_match(match_value.dl__facch__cmd(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__OSMO__RepAcchCap_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (len().is_bound()) len().set_implicit_omit();
if (rfu().is_bound()) rfu().set_implicit_omit();
if (rxqual().is_bound()) rxqual().set_implicit_omit();
if (ul__sacch().is_bound()) ul__sacch().set_implicit_omit();
if (dl__sacch().is_bound()) dl__sacch().set_implicit_omit();
if (dl__facch__all().is_bound()) dl__facch__all().set_implicit_omit();
if (dl__facch__cmd().is_bound()) dl__facch__cmd().set_implicit_omit();
}

void RSL__IE__OSMO__RepAcchCap_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_len.encode_text(text_buf);
single_value->field_rfu.encode_text(text_buf);
single_value->field_rxqual.encode_text(text_buf);
single_value->field_ul__sacch.encode_text(text_buf);
single_value->field_dl__sacch.encode_text(text_buf);
single_value->field_dl__facch__all.encode_text(text_buf);
single_value->field_dl__facch__cmd.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
}
}

void RSL__IE__OSMO__RepAcchCap_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_len.decode_text(text_buf);
single_value->field_rfu.decode_text(text_buf);
single_value->field_rxqual.decode_text(text_buf);
single_value->field_ul__sacch.decode_text(text_buf);
single_value->field_dl__sacch.decode_text(text_buf);
single_value->field_dl__facch__all.decode_text(text_buf);
single_value->field_dl__facch__cmd.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__OSMO__RepAcchCap_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap.");
}
}

void RSL__IE__OSMO__RepAcchCap_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__OSMO__RepAcchCap_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (7<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_OSMO_RepAcchCap has 7 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) rfu().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) rxqual().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) ul__sacch().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) dl__sacch().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) dl__facch__all().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) dl__facch__cmd().set_param(*param.get_elem(6));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rfu")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rfu().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rxqual")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rxqual().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ul_sacch")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ul__sacch().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dl_sacch")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dl__sacch().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dl_facch_all")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dl__facch__all().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "dl_facch_cmd")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          dl__facch__cmd().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_OSMO_RepAcchCap: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__OSMO__RepAcchCap_template* precondition = new RSL__IE__OSMO__RepAcchCap_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__OSMO__RepAcchCap_template* implied_template = new RSL__IE__OSMO__RepAcchCap_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__OSMO__RepAcchCap_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_OSMO_RepAcchCap");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__OSMO__RepAcchCap_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_len.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_RepAcchCap");
single_value->field_rfu.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_RepAcchCap");
single_value->field_rxqual.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_RepAcchCap");
single_value->field_ul__sacch.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_RepAcchCap");
single_value->field_dl__sacch.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_RepAcchCap");
single_value->field_dl__facch__all.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_RepAcchCap");
single_value->field_dl__facch__cmd.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_RepAcchCap");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_RepAcchCap");
}

boolean RSL__IE__OSMO__RepAcchCap_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__OSMO__RepAcchCap_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IE__OSMO__TopAcchCap::RSL__IE__OSMO__TopAcchCap()
{
}

RSL__IE__OSMO__TopAcchCap::RSL__IE__OSMO__TopAcchCap(const INTEGER& par_len,
    const BOOLEAN& par_sacch__enable,
    const BOOLEAN& par_facch__enable,
    const INTEGER& par_rxqual,
    const INTEGER& par_overpower__db)
  :   field_len(par_len),
  field_sacch__enable(par_sacch__enable),
  field_facch__enable(par_facch__enable),
  field_rxqual(par_rxqual),
  field_overpower__db(par_overpower__db)
{
}

RSL__IE__OSMO__TopAcchCap::RSL__IE__OSMO__TopAcchCap(const RSL__IE__OSMO__TopAcchCap& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.sacch__enable().is_bound()) field_sacch__enable = other_value.sacch__enable();
else field_sacch__enable.clean_up();
if (other_value.facch__enable().is_bound()) field_facch__enable = other_value.facch__enable();
else field_facch__enable.clean_up();
if (other_value.rxqual().is_bound()) field_rxqual = other_value.rxqual();
else field_rxqual.clean_up();
if (other_value.overpower__db().is_bound()) field_overpower__db = other_value.overpower__db();
else field_overpower__db.clean_up();
}

void RSL__IE__OSMO__TopAcchCap::clean_up()
{
field_len.clean_up();
field_sacch__enable.clean_up();
field_facch__enable.clean_up();
field_rxqual.clean_up();
field_overpower__db.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__OSMO__TopAcchCap::get_descriptor() const { return &RSL__IE__OSMO__TopAcchCap_descr_; }
RSL__IE__OSMO__TopAcchCap& RSL__IE__OSMO__TopAcchCap::operator=(const RSL__IE__OSMO__TopAcchCap& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.sacch__enable().is_bound()) field_sacch__enable = other_value.sacch__enable();
  else field_sacch__enable.clean_up();
  if (other_value.facch__enable().is_bound()) field_facch__enable = other_value.facch__enable();
  else field_facch__enable.clean_up();
  if (other_value.rxqual().is_bound()) field_rxqual = other_value.rxqual();
  else field_rxqual.clean_up();
  if (other_value.overpower__db().is_bound()) field_overpower__db = other_value.overpower__db();
  else field_overpower__db.clean_up();
}
return *this;
}

boolean RSL__IE__OSMO__TopAcchCap::operator==(const RSL__IE__OSMO__TopAcchCap& other_value) const
{
return field_len==other_value.field_len
  && field_sacch__enable==other_value.field_sacch__enable
  && field_facch__enable==other_value.field_facch__enable
  && field_rxqual==other_value.field_rxqual
  && field_overpower__db==other_value.field_overpower__db;
}

boolean RSL__IE__OSMO__TopAcchCap::is_bound() const
{
return (field_len.is_bound())
  || (field_sacch__enable.is_bound())
  || (field_facch__enable.is_bound())
  || (field_rxqual.is_bound())
  || (field_overpower__db.is_bound());
}
boolean RSL__IE__OSMO__TopAcchCap::is_value() const
{
return field_len.is_value()
  && field_sacch__enable.is_value()
  && field_facch__enable.is_value()
  && field_rxqual.is_value()
  && field_overpower__db.is_value();
}
void RSL__IE__OSMO__TopAcchCap::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len := ");
field_len.log();
TTCN_Logger::log_event_str(", sacch_enable := ");
field_sacch__enable.log();
TTCN_Logger::log_event_str(", facch_enable := ");
field_facch__enable.log();
TTCN_Logger::log_event_str(", rxqual := ");
field_rxqual.log();
TTCN_Logger::log_event_str(", overpower_db := ");
field_overpower__db.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__OSMO__TopAcchCap::set_implicit_omit()
{
if (len().is_bound()) len().set_implicit_omit();
if (sacch__enable().is_bound()) sacch__enable().set_implicit_omit();
if (facch__enable().is_bound()) facch__enable().set_implicit_omit();
if (rxqual().is_bound()) rxqual().set_implicit_omit();
if (overpower__db().is_bound()) overpower__db().set_implicit_omit();
}

void RSL__IE__OSMO__TopAcchCap::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_OSMO_TopAcchCap has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) sacch__enable().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) facch__enable().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rxqual().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) overpower__db().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sacch_enable")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sacch__enable().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "facch_enable")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          facch__enable().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rxqual")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rxqual().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "overpower_db")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          overpower__db().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_OSMO_TopAcchCap: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_OSMO_TopAcchCap");
  }
}

void RSL__IE__OSMO__TopAcchCap::encode_text(Text_Buf& text_buf) const
{
field_len.encode_text(text_buf);
field_sacch__enable.encode_text(text_buf);
field_facch__enable.encode_text(text_buf);
field_rxqual.encode_text(text_buf);
field_overpower__db.encode_text(text_buf);
}

void RSL__IE__OSMO__TopAcchCap::decode_text(Text_Buf& text_buf)
{
field_len.decode_text(text_buf);
field_sacch__enable.decode_text(text_buf);
field_facch__enable.decode_text(text_buf);
field_rxqual.decode_text(text_buf);
field_overpower__db.decode_text(text_buf);
}

void RSL__IE__OSMO__TopAcchCap::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__OSMO__TopAcchCap::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__OSMO__TopAcchCap::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__OSMO__TopAcchCap_len_descr_.raw->forceomit);
  decoded_field_length = field_len.RAW_decode(RSL__IE__OSMO__TopAcchCap_len_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_len.convert_to_Integer(RSL__IE__OSMO__TopAcchCap_len_descr_);
  field_len = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__OSMO__TopAcchCap_sacch__enable_descr_.raw->forceomit);
  decoded_field_length = field_sacch__enable.RAW_decode(RSL__IE__OSMO__TopAcchCap_sacch__enable_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_2_force_omit(2, force_omit, RSL__IE__OSMO__TopAcchCap_facch__enable_descr_.raw->forceomit);
  decoded_field_length = field_facch__enable.RAW_decode(RSL__IE__OSMO__TopAcchCap_facch__enable_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_3_force_omit(3, force_omit, RSL__IE__OSMO__TopAcchCap_rxqual_descr_.raw->forceomit);
  decoded_field_length = field_rxqual.RAW_decode(RSL__IE__OSMO__TopAcchCap_rxqual_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  RAW_Force_Omit field_4_force_omit(4, force_omit, RSL__IE__OSMO__TopAcchCap_overpower__db_descr_.raw->forceomit);
  decoded_field_length = field_overpower__db.RAW_decode(RSL__IE__OSMO__TopAcchCap_overpower__db_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__OSMO__TopAcchCap::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 5;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(5);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__OSMO__TopAcchCap_len_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__OSMO__TopAcchCap_sacch__enable_descr_.raw);
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, RSL__IE__OSMO__TopAcchCap_facch__enable_descr_.raw);
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, RSL__IE__OSMO__TopAcchCap_rxqual_descr_.raw);
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, RSL__IE__OSMO__TopAcchCap_overpower__db_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &RSL__IE__OSMO__TopAcchCap_len_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 4;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(4);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].level = myleaf.body.node.nodes[2]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[1].pos = myleaf.body.node.nodes[2]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[2].level = myleaf.body.node.nodes[3]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[2].pos = myleaf.body.node.nodes[3]->curr_pos.pos;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[3].level = myleaf.body.node.nodes[4]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[3].pos = myleaf.body.node.nodes[4]->curr_pos.pos;
  encoded_length += field_sacch__enable.RAW_encode(RSL__IE__OSMO__TopAcchCap_sacch__enable_descr_, *myleaf.body.node.nodes[1]);
  encoded_length += field_facch__enable.RAW_encode(RSL__IE__OSMO__TopAcchCap_facch__enable_descr_, *myleaf.body.node.nodes[2]);
  encoded_length += field_rxqual.RAW_encode(RSL__IE__OSMO__TopAcchCap_rxqual_descr_, *myleaf.body.node.nodes[3]);
  encoded_length += field_overpower__db.RAW_encode(RSL__IE__OSMO__TopAcchCap_overpower__db_descr_, *myleaf.body.node.nodes[4]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__OSMO__TopAcchCap_template::single_value_struct {
INTEGER_template field_len;
BOOLEAN_template field_sacch__enable;
BOOLEAN_template field_facch__enable;
INTEGER_template field_rxqual;
INTEGER_template field_overpower__db;
};

void RSL__IE__OSMO__TopAcchCap_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_len = ANY_VALUE;
single_value->field_sacch__enable = ANY_VALUE;
single_value->field_facch__enable = ANY_VALUE;
single_value->field_rxqual = ANY_VALUE;
single_value->field_overpower__db = ANY_VALUE;
}
}
}

void RSL__IE__OSMO__TopAcchCap_template::copy_value(const RSL__IE__OSMO__TopAcchCap& other_value)
{
single_value = new single_value_struct;
if (other_value.len().is_bound()) {
  single_value->field_len = other_value.len();
} else {
  single_value->field_len.clean_up();
}
if (other_value.sacch__enable().is_bound()) {
  single_value->field_sacch__enable = other_value.sacch__enable();
} else {
  single_value->field_sacch__enable.clean_up();
}
if (other_value.facch__enable().is_bound()) {
  single_value->field_facch__enable = other_value.facch__enable();
} else {
  single_value->field_facch__enable.clean_up();
}
if (other_value.rxqual().is_bound()) {
  single_value->field_rxqual = other_value.rxqual();
} else {
  single_value->field_rxqual.clean_up();
}
if (other_value.overpower__db().is_bound()) {
  single_value->field_overpower__db = other_value.overpower__db();
} else {
  single_value->field_overpower__db.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__OSMO__TopAcchCap_template::copy_template(const RSL__IE__OSMO__TopAcchCap_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.len().get_selection()) {
single_value->field_len = other_value.len();
} else {
single_value->field_len.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sacch__enable().get_selection()) {
single_value->field_sacch__enable = other_value.sacch__enable();
} else {
single_value->field_sacch__enable.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.facch__enable().get_selection()) {
single_value->field_facch__enable = other_value.facch__enable();
} else {
single_value->field_facch__enable.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rxqual().get_selection()) {
single_value->field_rxqual = other_value.rxqual();
} else {
single_value->field_rxqual.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.overpower__db().get_selection()) {
single_value->field_overpower__db = other_value.overpower__db();
} else {
single_value->field_overpower__db.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__OSMO__TopAcchCap_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__OSMO__TopAcchCap_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__OSMO__TopAcchCap_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
break;
}
set_selection(other_value);
}

RSL__IE__OSMO__TopAcchCap_template::RSL__IE__OSMO__TopAcchCap_template()
{
}

RSL__IE__OSMO__TopAcchCap_template::RSL__IE__OSMO__TopAcchCap_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__OSMO__TopAcchCap_template::RSL__IE__OSMO__TopAcchCap_template(const RSL__IE__OSMO__TopAcchCap& other_value)
{
copy_value(other_value);
}

RSL__IE__OSMO__TopAcchCap_template::RSL__IE__OSMO__TopAcchCap_template(const OPTIONAL<RSL__IE__OSMO__TopAcchCap>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__OSMO__TopAcchCap&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap from an unbound optional field.");
}
}

RSL__IE__OSMO__TopAcchCap_template::RSL__IE__OSMO__TopAcchCap_template(RSL__IE__OSMO__TopAcchCap_template* p_precondition, RSL__IE__OSMO__TopAcchCap_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__OSMO__TopAcchCap_template::RSL__IE__OSMO__TopAcchCap_template(Dynamic_Match_Interface<RSL__IE__OSMO__TopAcchCap>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__OSMO__TopAcchCap>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__OSMO__TopAcchCap_template::RSL__IE__OSMO__TopAcchCap_template(const RSL__IE__OSMO__TopAcchCap_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__OSMO__TopAcchCap_template::~RSL__IE__OSMO__TopAcchCap_template()
{
clean_up();
}

RSL__IE__OSMO__TopAcchCap_template& RSL__IE__OSMO__TopAcchCap_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__OSMO__TopAcchCap_template& RSL__IE__OSMO__TopAcchCap_template::operator=(const RSL__IE__OSMO__TopAcchCap& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__OSMO__TopAcchCap_template& RSL__IE__OSMO__TopAcchCap_template::operator=(const OPTIONAL<RSL__IE__OSMO__TopAcchCap>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__OSMO__TopAcchCap&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
}
return *this;
}

RSL__IE__OSMO__TopAcchCap_template& RSL__IE__OSMO__TopAcchCap_template::operator=(const RSL__IE__OSMO__TopAcchCap_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__OSMO__TopAcchCap_template::match(const RSL__IE__OSMO__TopAcchCap& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.len().is_bound()) return FALSE;
if(!single_value->field_len.match(other_value.len(), legacy))return FALSE;
if(!other_value.sacch__enable().is_bound()) return FALSE;
if(!single_value->field_sacch__enable.match(other_value.sacch__enable(), legacy))return FALSE;
if(!other_value.facch__enable().is_bound()) return FALSE;
if(!single_value->field_facch__enable.match(other_value.facch__enable(), legacy))return FALSE;
if(!other_value.rxqual().is_bound()) return FALSE;
if(!single_value->field_rxqual.match(other_value.rxqual(), legacy))return FALSE;
if(!other_value.overpower__db().is_bound()) return FALSE;
if(!single_value->field_overpower__db.match(other_value.overpower__db(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
}
return FALSE;
}

boolean RSL__IE__OSMO__TopAcchCap_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_len.is_bound()
 || single_value->field_sacch__enable.is_bound()
 || single_value->field_facch__enable.is_bound()
 || single_value->field_rxqual.is_bound()
 || single_value->field_overpower__db.is_bound();
}

boolean RSL__IE__OSMO__TopAcchCap_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_len.is_value()
 && single_value->field_sacch__enable.is_value()
 && single_value->field_facch__enable.is_value()
 && single_value->field_rxqual.is_value()
 && single_value->field_overpower__db.is_value();
}

void RSL__IE__OSMO__TopAcchCap_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__OSMO__TopAcchCap RSL__IE__OSMO__TopAcchCap_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
RSL__IE__OSMO__TopAcchCap ret_val;
if (single_value->field_len.is_bound()) {
ret_val.len() = single_value->field_len.valueof();
}
if (single_value->field_sacch__enable.is_bound()) {
ret_val.sacch__enable() = single_value->field_sacch__enable.valueof();
}
if (single_value->field_facch__enable.is_bound()) {
ret_val.facch__enable() = single_value->field_facch__enable.valueof();
}
if (single_value->field_rxqual.is_bound()) {
ret_val.rxqual() = single_value->field_rxqual.valueof();
}
if (single_value->field_overpower__db.is_bound()) {
ret_val.overpower__db() = single_value->field_overpower__db.valueof();
}
return ret_val;
}

void RSL__IE__OSMO__TopAcchCap_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__OSMO__TopAcchCap_template[list_length];
}

RSL__IE__OSMO__TopAcchCap_template& RSL__IE__OSMO__TopAcchCap_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__OSMO__TopAcchCap_template::len()
{
set_specific();
return single_value->field_len;
}

const INTEGER_template& RSL__IE__OSMO__TopAcchCap_template::len() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len of a non-specific template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
return single_value->field_len;
}

BOOLEAN_template& RSL__IE__OSMO__TopAcchCap_template::sacch__enable()
{
set_specific();
return single_value->field_sacch__enable;
}

const BOOLEAN_template& RSL__IE__OSMO__TopAcchCap_template::sacch__enable() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sacch_enable of a non-specific template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
return single_value->field_sacch__enable;
}

BOOLEAN_template& RSL__IE__OSMO__TopAcchCap_template::facch__enable()
{
set_specific();
return single_value->field_facch__enable;
}

const BOOLEAN_template& RSL__IE__OSMO__TopAcchCap_template::facch__enable() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field facch_enable of a non-specific template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
return single_value->field_facch__enable;
}

INTEGER_template& RSL__IE__OSMO__TopAcchCap_template::rxqual()
{
set_specific();
return single_value->field_rxqual;
}

const INTEGER_template& RSL__IE__OSMO__TopAcchCap_template::rxqual() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rxqual of a non-specific template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
return single_value->field_rxqual;
}

INTEGER_template& RSL__IE__OSMO__TopAcchCap_template::overpower__db()
{
set_specific();
return single_value->field_overpower__db;
}

const INTEGER_template& RSL__IE__OSMO__TopAcchCap_template::overpower__db() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field overpower_db of a non-specific template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
return single_value->field_overpower__db;
}

int RSL__IE__OSMO__TopAcchCap_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
  }
  return 0;
}

void RSL__IE__OSMO__TopAcchCap_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log();
TTCN_Logger::log_event_str(", sacch_enable := ");
single_value->field_sacch__enable.log();
TTCN_Logger::log_event_str(", facch_enable := ");
single_value->field_facch__enable.log();
TTCN_Logger::log_event_str(", rxqual := ");
single_value->field_rxqual.log();
TTCN_Logger::log_event_str(", overpower_db := ");
single_value->field_overpower__db.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__OSMO__TopAcchCap_template::log_match(const RSL__IE__OSMO__TopAcchCap& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_len.match(match_value.len(), legacy)){
TTCN_Logger::log_logmatch_info(".len");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sacch__enable.match(match_value.sacch__enable(), legacy)){
TTCN_Logger::log_logmatch_info(".sacch_enable");
single_value->field_sacch__enable.log_match(match_value.sacch__enable(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_facch__enable.match(match_value.facch__enable(), legacy)){
TTCN_Logger::log_logmatch_info(".facch_enable");
single_value->field_facch__enable.log_match(match_value.facch__enable(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_rxqual.match(match_value.rxqual(), legacy)){
TTCN_Logger::log_logmatch_info(".rxqual");
single_value->field_rxqual.log_match(match_value.rxqual(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_overpower__db.match(match_value.overpower__db(), legacy)){
TTCN_Logger::log_logmatch_info(".overpower_db");
single_value->field_overpower__db.log_match(match_value.overpower__db(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::log_event_str(", sacch_enable := ");
single_value->field_sacch__enable.log_match(match_value.sacch__enable(), legacy);
TTCN_Logger::log_event_str(", facch_enable := ");
single_value->field_facch__enable.log_match(match_value.facch__enable(), legacy);
TTCN_Logger::log_event_str(", rxqual := ");
single_value->field_rxqual.log_match(match_value.rxqual(), legacy);
TTCN_Logger::log_event_str(", overpower_db := ");
single_value->field_overpower__db.log_match(match_value.overpower__db(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__OSMO__TopAcchCap_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (len().is_bound()) len().set_implicit_omit();
if (sacch__enable().is_bound()) sacch__enable().set_implicit_omit();
if (facch__enable().is_bound()) facch__enable().set_implicit_omit();
if (rxqual().is_bound()) rxqual().set_implicit_omit();
if (overpower__db().is_bound()) overpower__db().set_implicit_omit();
}

void RSL__IE__OSMO__TopAcchCap_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_len.encode_text(text_buf);
single_value->field_sacch__enable.encode_text(text_buf);
single_value->field_facch__enable.encode_text(text_buf);
single_value->field_rxqual.encode_text(text_buf);
single_value->field_overpower__db.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
}
}

void RSL__IE__OSMO__TopAcchCap_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_len.decode_text(text_buf);
single_value->field_sacch__enable.decode_text(text_buf);
single_value->field_facch__enable.decode_text(text_buf);
single_value->field_rxqual.decode_text(text_buf);
single_value->field_overpower__db.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__OSMO__TopAcchCap_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap.");
}
}

void RSL__IE__OSMO__TopAcchCap_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__OSMO__TopAcchCap_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_OSMO_TopAcchCap has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) sacch__enable().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) facch__enable().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) rxqual().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) overpower__db().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sacch_enable")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sacch__enable().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "facch_enable")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          facch__enable().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rxqual")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rxqual().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "overpower_db")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          overpower__db().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_OSMO_TopAcchCap: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__OSMO__TopAcchCap_template* precondition = new RSL__IE__OSMO__TopAcchCap_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__OSMO__TopAcchCap_template* implied_template = new RSL__IE__OSMO__TopAcchCap_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__OSMO__TopAcchCap_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_OSMO_TopAcchCap");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__OSMO__TopAcchCap_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_len.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_TopAcchCap");
single_value->field_sacch__enable.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_TopAcchCap");
single_value->field_facch__enable.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_TopAcchCap");
single_value->field_rxqual.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_TopAcchCap");
single_value->field_overpower__db.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_TopAcchCap");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_TopAcchCap");
}

boolean RSL__IE__OSMO__TopAcchCap_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__OSMO__TopAcchCap_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

RSL__IE__OSMO__Osmux__CID::RSL__IE__OSMO__Osmux__CID()
{
}

RSL__IE__OSMO__Osmux__CID::RSL__IE__OSMO__Osmux__CID(const INTEGER& par_len,
    const INTEGER& par_cid)
  :   field_len(par_len),
  field_cid(par_cid)
{
}

RSL__IE__OSMO__Osmux__CID::RSL__IE__OSMO__Osmux__CID(const RSL__IE__OSMO__Osmux__CID& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @RSL_Types.RSL_IE_OSMO_Osmux_CID.");
if (other_value.len().is_bound()) field_len = other_value.len();
else field_len.clean_up();
if (other_value.cid().is_bound()) field_cid = other_value.cid();
else field_cid.clean_up();
}

void RSL__IE__OSMO__Osmux__CID::clean_up()
{
field_len.clean_up();
field_cid.clean_up();
}

const TTCN_Typedescriptor_t* RSL__IE__OSMO__Osmux__CID::get_descriptor() const { return &RSL__IE__OSMO__Osmux__CID_descr_; }
RSL__IE__OSMO__Osmux__CID& RSL__IE__OSMO__Osmux__CID::operator=(const RSL__IE__OSMO__Osmux__CID& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @RSL_Types.RSL_IE_OSMO_Osmux_CID.");
  if (other_value.len().is_bound()) field_len = other_value.len();
  else field_len.clean_up();
  if (other_value.cid().is_bound()) field_cid = other_value.cid();
  else field_cid.clean_up();
}
return *this;
}

boolean RSL__IE__OSMO__Osmux__CID::operator==(const RSL__IE__OSMO__Osmux__CID& other_value) const
{
return field_len==other_value.field_len
  && field_cid==other_value.field_cid;
}

boolean RSL__IE__OSMO__Osmux__CID::is_bound() const
{
return (field_len.is_bound())
  || (field_cid.is_bound());
}
boolean RSL__IE__OSMO__Osmux__CID::is_value() const
{
return field_len.is_value()
  && field_cid.is_value();
}
void RSL__IE__OSMO__Osmux__CID::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ len := ");
field_len.log();
TTCN_Logger::log_event_str(", cid := ");
field_cid.log();
TTCN_Logger::log_event_str(" }");
}

void RSL__IE__OSMO__Osmux__CID::set_implicit_omit()
{
if (len().is_bound()) len().set_implicit_omit();
if (cid().is_bound()) cid().set_implicit_omit();
}

void RSL__IE__OSMO__Osmux__CID::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @RSL_Types.RSL_IE_OSMO_Osmux_CID has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cid().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cid")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cid().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_OSMO_Osmux_CID: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@RSL_Types.RSL_IE_OSMO_Osmux_CID");
  }
}

void RSL__IE__OSMO__Osmux__CID::encode_text(Text_Buf& text_buf) const
{
field_len.encode_text(text_buf);
field_cid.encode_text(text_buf);
}

void RSL__IE__OSMO__Osmux__CID::decode_text(Text_Buf& text_buf)
{
field_len.decode_text(text_buf);
field_cid.decode_text(text_buf);
}

void RSL__IE__OSMO__Osmux__CID::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__OSMO__Osmux__CID::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__OSMO__Osmux__CID::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  int value_of_length_field0 = 0;
  RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__OSMO__Osmux__CID_len_descr_.raw->forceomit);
  decoded_field_length = field_len.RAW_decode(RSL__IE__OSMO__Osmux__CID_len_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  INTEGER tmp0 = field_len.convert_to_Integer(RSL__IE__OSMO__Osmux__CID_len_descr_);
  field_len = tmp0;
  value_of_length_field0 += tmp0.get_long_long_val() * 8;
  RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__OSMO__Osmux__CID_cid_descr_.raw->forceomit);
  decoded_field_length = field_cid.RAW_decode(RSL__IE__OSMO__Osmux__CID_cid_descr_, p_buf, min_of_ints(2, limit, value_of_length_field0), local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  value_of_length_field0 -= decoded_field_length;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int RSL__IE__OSMO__Osmux__CID::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, RSL__IE__OSMO__Osmux__CID_len_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RSL__IE__OSMO__Osmux__CID_cid_descr_.raw);
  encoded_length += 8;
  myleaf.body.node.nodes[0]->calc = CALC_LENGTH;
  myleaf.body.node.nodes[0]->coding_descr = &RSL__IE__OSMO__Osmux__CID_len_descr_;
  myleaf.body.node.nodes[0]->calcof.lengthto.num_of_fields = 1;
  myleaf.body.node.nodes[0]->calcof.lengthto.unit = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.offset = 0;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields = init_lengthto_fields_list(1);
  myleaf.body.node.nodes[0]->length = 8;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].level = myleaf.body.node.nodes[1]->curr_pos.level;
  myleaf.body.node.nodes[0]->calcof.lengthto.fields[0].pos = myleaf.body.node.nodes[1]->curr_pos.pos;
  encoded_length += field_cid.RAW_encode(RSL__IE__OSMO__Osmux__CID_cid_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct RSL__IE__OSMO__Osmux__CID_template::single_value_struct {
INTEGER_template field_len;
INTEGER_template field_cid;
};

void RSL__IE__OSMO__Osmux__CID_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_len = ANY_VALUE;
single_value->field_cid = ANY_VALUE;
}
}
}

void RSL__IE__OSMO__Osmux__CID_template::copy_value(const RSL__IE__OSMO__Osmux__CID& other_value)
{
single_value = new single_value_struct;
if (other_value.len().is_bound()) {
  single_value->field_len = other_value.len();
} else {
  single_value->field_len.clean_up();
}
if (other_value.cid().is_bound()) {
  single_value->field_cid = other_value.cid();
} else {
  single_value->field_cid.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__OSMO__Osmux__CID_template::copy_template(const RSL__IE__OSMO__Osmux__CID_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.len().get_selection()) {
single_value->field_len = other_value.len();
} else {
single_value->field_len.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cid().get_selection()) {
single_value->field_cid = other_value.cid();
} else {
single_value->field_cid.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__OSMO__Osmux__CID_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__OSMO__Osmux__CID_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__OSMO__Osmux__CID_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_Osmux_CID.");
break;
}
set_selection(other_value);
}

RSL__IE__OSMO__Osmux__CID_template::RSL__IE__OSMO__Osmux__CID_template()
{
}

RSL__IE__OSMO__Osmux__CID_template::RSL__IE__OSMO__Osmux__CID_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__OSMO__Osmux__CID_template::RSL__IE__OSMO__Osmux__CID_template(const RSL__IE__OSMO__Osmux__CID& other_value)
{
copy_value(other_value);
}

RSL__IE__OSMO__Osmux__CID_template::RSL__IE__OSMO__Osmux__CID_template(const OPTIONAL<RSL__IE__OSMO__Osmux__CID>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__OSMO__Osmux__CID&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @RSL_Types.RSL_IE_OSMO_Osmux_CID from an unbound optional field.");
}
}

RSL__IE__OSMO__Osmux__CID_template::RSL__IE__OSMO__Osmux__CID_template(RSL__IE__OSMO__Osmux__CID_template* p_precondition, RSL__IE__OSMO__Osmux__CID_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__OSMO__Osmux__CID_template::RSL__IE__OSMO__Osmux__CID_template(Dynamic_Match_Interface<RSL__IE__OSMO__Osmux__CID>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__OSMO__Osmux__CID>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__OSMO__Osmux__CID_template::RSL__IE__OSMO__Osmux__CID_template(const RSL__IE__OSMO__Osmux__CID_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

RSL__IE__OSMO__Osmux__CID_template::~RSL__IE__OSMO__Osmux__CID_template()
{
clean_up();
}

RSL__IE__OSMO__Osmux__CID_template& RSL__IE__OSMO__Osmux__CID_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__OSMO__Osmux__CID_template& RSL__IE__OSMO__Osmux__CID_template::operator=(const RSL__IE__OSMO__Osmux__CID& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__OSMO__Osmux__CID_template& RSL__IE__OSMO__Osmux__CID_template::operator=(const OPTIONAL<RSL__IE__OSMO__Osmux__CID>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__OSMO__Osmux__CID&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @RSL_Types.RSL_IE_OSMO_Osmux_CID.");
}
return *this;
}

RSL__IE__OSMO__Osmux__CID_template& RSL__IE__OSMO__Osmux__CID_template::operator=(const RSL__IE__OSMO__Osmux__CID_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__OSMO__Osmux__CID_template::match(const RSL__IE__OSMO__Osmux__CID& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.len().is_bound()) return FALSE;
if(!single_value->field_len.match(other_value.len(), legacy))return FALSE;
if(!other_value.cid().is_bound()) return FALSE;
if(!single_value->field_cid.match(other_value.cid(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_Osmux_CID.");
}
return FALSE;
}

boolean RSL__IE__OSMO__Osmux__CID_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_len.is_bound()
 || single_value->field_cid.is_bound();
}

boolean RSL__IE__OSMO__Osmux__CID_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_len.is_value()
 && single_value->field_cid.is_value();
}

void RSL__IE__OSMO__Osmux__CID_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__OSMO__Osmux__CID RSL__IE__OSMO__Osmux__CID_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @RSL_Types.RSL_IE_OSMO_Osmux_CID.");
RSL__IE__OSMO__Osmux__CID ret_val;
if (single_value->field_len.is_bound()) {
ret_val.len() = single_value->field_len.valueof();
}
if (single_value->field_cid.is_bound()) {
ret_val.cid() = single_value->field_cid.valueof();
}
return ret_val;
}

void RSL__IE__OSMO__Osmux__CID_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @RSL_Types.RSL_IE_OSMO_Osmux_CID.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__OSMO__Osmux__CID_template[list_length];
}

RSL__IE__OSMO__Osmux__CID_template& RSL__IE__OSMO__Osmux__CID_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @RSL_Types.RSL_IE_OSMO_Osmux_CID.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @RSL_Types.RSL_IE_OSMO_Osmux_CID.");
return value_list.list_value[list_index];
}

INTEGER_template& RSL__IE__OSMO__Osmux__CID_template::len()
{
set_specific();
return single_value->field_len;
}

const INTEGER_template& RSL__IE__OSMO__Osmux__CID_template::len() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field len of a non-specific template of type @RSL_Types.RSL_IE_OSMO_Osmux_CID.");
return single_value->field_len;
}

INTEGER_template& RSL__IE__OSMO__Osmux__CID_template::cid()
{
set_specific();
return single_value->field_cid;
}

const INTEGER_template& RSL__IE__OSMO__Osmux__CID_template::cid() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cid of a non-specific template of type @RSL_Types.RSL_IE_OSMO_Osmux_CID.");
return single_value->field_cid;
}

int RSL__IE__OSMO__Osmux__CID_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_Osmux_CID which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_Osmux_CID containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_Osmux_CID containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_Osmux_CID containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_Osmux_CID containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_Osmux_CID containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_Osmux_CID containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_Osmux_CID containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @RSL_Types.RSL_IE_OSMO_Osmux_CID containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_Osmux_CID.");
  }
  return 0;
}

void RSL__IE__OSMO__Osmux__CID_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log();
TTCN_Logger::log_event_str(", cid := ");
single_value->field_cid.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RSL__IE__OSMO__Osmux__CID_template::log_match(const RSL__IE__OSMO__Osmux__CID& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_len.match(match_value.len(), legacy)){
TTCN_Logger::log_logmatch_info(".len");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cid.match(match_value.cid(), legacy)){
TTCN_Logger::log_logmatch_info(".cid");
single_value->field_cid.log_match(match_value.cid(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ len := ");
single_value->field_len.log_match(match_value.len(), legacy);
TTCN_Logger::log_event_str(", cid := ");
single_value->field_cid.log_match(match_value.cid(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void RSL__IE__OSMO__Osmux__CID_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (len().is_bound()) len().set_implicit_omit();
if (cid().is_bound()) cid().set_implicit_omit();
}

void RSL__IE__OSMO__Osmux__CID_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_len.encode_text(text_buf);
single_value->field_cid.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @RSL_Types.RSL_IE_OSMO_Osmux_CID.");
}
}

void RSL__IE__OSMO__Osmux__CID_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_len.decode_text(text_buf);
single_value->field_cid.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RSL__IE__OSMO__Osmux__CID_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @RSL_Types.RSL_IE_OSMO_Osmux_CID.");
}
}

void RSL__IE__OSMO__Osmux__CID_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RSL__IE__OSMO__Osmux__CID_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @RSL_Types.RSL_IE_OSMO_Osmux_CID has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) len().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cid().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "len")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          len().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cid")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cid().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @RSL_Types.RSL_IE_OSMO_Osmux_CID: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    RSL__IE__OSMO__Osmux__CID_template* precondition = new RSL__IE__OSMO__Osmux__CID_template;
    precondition->set_param(*param.get_elem(0));
    RSL__IE__OSMO__Osmux__CID_template* implied_template = new RSL__IE__OSMO__Osmux__CID_template;
    implied_template->set_param(*param.get_elem(1));
    *this = RSL__IE__OSMO__Osmux__CID_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@RSL_Types.RSL_IE_OSMO_Osmux_CID");
  }
  is_ifpresent = param.get_ifpresent();
}

void RSL__IE__OSMO__Osmux__CID_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_len.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_Osmux_CID");
single_value->field_cid.check_restriction(t_res, t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_Osmux_CID");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@RSL_Types.RSL_IE_OSMO_Osmux_CID");
}

boolean RSL__IE__OSMO__Osmux__CID_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RSL__IE__OSMO__Osmux__CID_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RSL__IE__Body::copy_value(const RSL__IE__Body& other_value)
{
switch (other_value.union_selection) {
case ALT_chan__nr:
field_chan__nr = new GSM__Types::RslChannelNr(*other_value.field_chan__nr);
break;
case ALT_link__id:
field_link__id = new GSM__Types::RslLinkId(*other_value.field_link__id);
break;
case ALT_l3__info:
field_l3__info = new RSL__L16V(*other_value.field_l3__info);
break;
case ALT_rlm__cause:
field_rlm__cause = new RSL__LV(*other_value.field_rlm__cause);
break;
case ALT_release__mode:
field_release__mode = new RSL__IE__ReleaseMode(*other_value.field_release__mode);
break;
case ALT_act__type:
field_act__type = new RSL__IE__ActivationType(*other_value.field_act__type);
break;
case ALT_chan__ident:
field_chan__ident = new RSL__IE__ChannelIdent(*other_value.field_chan__ident);
break;
case ALT_chan__mode:
field_chan__mode = new RSL__IE__ChannelMode(*other_value.field_chan__mode);
break;
case ALT_handover__ref:
field_handover__ref = new INTEGER(*other_value.field_handover__ref);
break;
case ALT_bs__power:
field_bs__power = new RSL__IE__BS__Power(*other_value.field_bs__power);
break;
case ALT_bs__power__params:
field_bs__power__params = new RSL__LV(*other_value.field_bs__power__params);
break;
case ALT_ms__power:
field_ms__power = new RSL__IE__MS__Power(*other_value.field_ms__power);
break;
case ALT_ms__power__params:
field_ms__power__params = new RSL__IE__MS__Power__Parameters(*other_value.field_ms__power__params);
break;
case ALT_timing__adv:
field_timing__adv = new INTEGER(*other_value.field_timing__adv);
break;
case ALT_multirate__cfg:
field_multirate__cfg = new RSL__IE__MultirateCfg(*other_value.field_multirate__cfg);
break;
case ALT_multirate__ctrl:
field_multirate__ctrl = new RSL__IE__MultirateCtrl(*other_value.field_multirate__ctrl);
break;
case ALT_msg__id:
field_msg__id = new INTEGER(*other_value.field_msg__id);
break;
case ALT_frame__nr:
field_frame__nr = new RSL__IE__FrameNumber(*other_value.field_frame__nr);
break;
case ALT_cause:
field_cause = new RSL__IE__Cause(*other_value.field_cause);
break;
case ALT_access__delay:
field_access__delay = new INTEGER(*other_value.field_access__delay);
break;
case ALT_rach__load:
field_rach__load = new RSL__IE__RachLoad(*other_value.field_rach__load);
break;
case ALT_meas__res__nr:
field_meas__res__nr = new INTEGER(*other_value.field_meas__res__nr);
break;
case ALT_ms__timing__offset:
field_ms__timing__offset = new INTEGER(*other_value.field_ms__timing__offset);
break;
case ALT_uplink__meas:
field_uplink__meas = new RSL__IE__UplinkMeas(*other_value.field_uplink__meas);
break;
case ALT_l1__info:
field_l1__info = new RSL__IE__L1Info(*other_value.field_l1__info);
break;
case ALT_sysinfo__type:
field_sysinfo__type = new RSL__IE__SysinfoType(*other_value.field_sysinfo__type);
break;
case ALT_paging__load:
field_paging__load = new INTEGER(*other_value.field_paging__load);
break;
case ALT_paging__group:
field_paging__group = new INTEGER(*other_value.field_paging__group);
break;
case ALT_chan__needed:
field_chan__needed = new RSL__IE__ChanNeeded(*other_value.field_chan__needed);
break;
case ALT_cb__cmd__type:
field_cb__cmd__type = new RSL__IE__CbCommandType(*other_value.field_cb__cmd__type);
break;
case ALT_smscb__message:
field_smscb__message = new RSL__LV(*other_value.field_smscb__message);
break;
case ALT_cbch__load__info:
field_cbch__load__info = new RSL__IE__CbchLoadInfo(*other_value.field_cbch__load__info);
break;
case ALT_resource__info:
field_resource__info = new RSL__IE__ResourceInfo(*other_value.field_resource__info);
break;
case ALT_sacch__info:
field_sacch__info = new RSL__SacchInfo(*other_value.field_sacch__info);
break;
case ALT_starting__time:
field_starting__time = new RSL__IE__FrameNumber(*other_value.field_starting__time);
break;
case ALT_encr__info:
field_encr__info = new RSL__IE__EncryptionInfo(*other_value.field_encr__info);
break;
case ALT_smscb__chan__ind:
field_smscb__chan__ind = new INTEGER(*other_value.field_smscb__chan__ind);
break;
case ALT_req__ref:
field_req__ref = new RSL__IE__RequestRef(*other_value.field_req__ref);
break;
case ALT_full__imm__ass__info:
field_full__imm__ass__info = new RSL__LV(*other_value.field_full__imm__ass__info);
break;
case ALT_ms__identity:
field_ms__identity = new MobileL3__CommonIE__Types::MobileIdentityLV(*other_value.field_ms__identity);
break;
case ALT_group__call__ref:
field_group__call__ref = new RSL__IE__GroupCallReference(*other_value.field_group__call__ref);
break;
case ALT_group__chan__desc:
field_group__chan__desc = new RSL__IE__GroupChannelDescription(*other_value.field_group__chan__desc);
break;
case ALT_nch__drx__info:
field_nch__drx__info = new RSL__IE__NchDrxInformation(*other_value.field_nch__drx__info);
break;
case ALT_cmd__indicator:
field_cmd__indicator = new RSL__IE__CommandIndicator(*other_value.field_cmd__indicator);
break;
case ALT_uic:
field_uic = new RSL__IE__Uic(*other_value.field_uic);
break;
case ALT_ipa__conn__id:
field_ipa__conn__id = new INTEGER(*other_value.field_ipa__conn__id);
break;
case ALT_ipa__local__port:
field_ipa__local__port = new INTEGER(*other_value.field_ipa__local__port);
break;
case ALT_ipa__remote__port:
field_ipa__remote__port = new INTEGER(*other_value.field_ipa__remote__port);
break;
case ALT_ipa__local__ip:
field_ipa__local__ip = new OCTETSTRING(*other_value.field_ipa__local__ip);
break;
case ALT_ipa__remote__ip:
field_ipa__remote__ip = new OCTETSTRING(*other_value.field_ipa__remote__ip);
break;
case ALT_ipa__rtp__pt:
field_ipa__rtp__pt = new INTEGER(*other_value.field_ipa__rtp__pt);
break;
case ALT_ipa__rtp__pt2:
field_ipa__rtp__pt2 = new INTEGER(*other_value.field_ipa__rtp__pt2);
break;
case ALT_ipa__stats:
field_ipa__stats = new RSL__IE__IPA__ConnectionStats(*other_value.field_ipa__stats);
break;
case ALT_ipa__speech__mode:
field_ipa__speech__mode = new RSL__IE__IPA__SpeechMode(*other_value.field_ipa__speech__mode);
break;
case ALT_ipa__rtp__csd__fmt:
field_ipa__rtp__csd__fmt = new RSL__IE__IPA__RTP__CSD__FMT(*other_value.field_ipa__rtp__csd__fmt);
break;
case ALT_osmo__training__sequence:
field_osmo__training__sequence = new RSL__IE__OSMO__TrainingSequence(*other_value.field_osmo__training__sequence);
break;
case ALT_rep__acch__cap:
field_rep__acch__cap = new RSL__IE__OSMO__RepAcchCap(*other_value.field_rep__acch__cap);
break;
case ALT_top__acch__cap:
field_top__acch__cap = new RSL__IE__OSMO__TopAcchCap(*other_value.field_top__acch__cap);
break;
case ALT_osmux__cid:
field_osmux__cid = new RSL__IE__OSMO__Osmux__CID(*other_value.field_osmux__cid);
break;
case ALT_other:
field_other = new RSL__LV(*other_value.field_other);
break;
default:
TTCN_error("Assignment of an unbound union value of type @RSL_Types.RSL_IE_Body.");
}
union_selection = other_value.union_selection;
}

RSL__IE__Body::RSL__IE__Body()
{
union_selection = UNBOUND_VALUE;
}

RSL__IE__Body::RSL__IE__Body(const RSL__IE__Body& other_value)
: Base_Type(){
copy_value(other_value);
}

RSL__IE__Body::~RSL__IE__Body()
{
clean_up();
}

RSL__IE__Body& RSL__IE__Body::operator=(const RSL__IE__Body& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean RSL__IE__Body::operator==(const RSL__IE__Body& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @RSL_Types.RSL_IE_Body.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @RSL_Types.RSL_IE_Body.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_chan__nr:
return *field_chan__nr == *other_value.field_chan__nr;
case ALT_link__id:
return *field_link__id == *other_value.field_link__id;
case ALT_l3__info:
return *field_l3__info == *other_value.field_l3__info;
case ALT_rlm__cause:
return *field_rlm__cause == *other_value.field_rlm__cause;
case ALT_release__mode:
return *field_release__mode == *other_value.field_release__mode;
case ALT_act__type:
return *field_act__type == *other_value.field_act__type;
case ALT_chan__ident:
return *field_chan__ident == *other_value.field_chan__ident;
case ALT_chan__mode:
return *field_chan__mode == *other_value.field_chan__mode;
case ALT_handover__ref:
return *field_handover__ref == *other_value.field_handover__ref;
case ALT_bs__power:
return *field_bs__power == *other_value.field_bs__power;
case ALT_bs__power__params:
return *field_bs__power__params == *other_value.field_bs__power__params;
case ALT_ms__power:
return *field_ms__power == *other_value.field_ms__power;
case ALT_ms__power__params:
return *field_ms__power__params == *other_value.field_ms__power__params;
case ALT_timing__adv:
return *field_timing__adv == *other_value.field_timing__adv;
case ALT_multirate__cfg:
return *field_multirate__cfg == *other_value.field_multirate__cfg;
case ALT_multirate__ctrl:
return *field_multirate__ctrl == *other_value.field_multirate__ctrl;
case ALT_msg__id:
return *field_msg__id == *other_value.field_msg__id;
case ALT_frame__nr:
return *field_frame__nr == *other_value.field_frame__nr;
case ALT_cause:
return *field_cause == *other_value.field_cause;
case ALT_access__delay:
return *field_access__delay == *other_value.field_access__delay;
case ALT_rach__load:
return *field_rach__load == *other_value.field_rach__load;
case ALT_meas__res__nr:
return *field_meas__res__nr == *other_value.field_meas__res__nr;
case ALT_ms__timing__offset:
return *field_ms__timing__offset == *other_value.field_ms__timing__offset;
case ALT_uplink__meas:
return *field_uplink__meas == *other_value.field_uplink__meas;
case ALT_l1__info:
return *field_l1__info == *other_value.field_l1__info;
case ALT_sysinfo__type:
return *field_sysinfo__type == *other_value.field_sysinfo__type;
case ALT_paging__load:
return *field_paging__load == *other_value.field_paging__load;
case ALT_paging__group:
return *field_paging__group == *other_value.field_paging__group;
case ALT_chan__needed:
return *field_chan__needed == *other_value.field_chan__needed;
case ALT_cb__cmd__type:
return *field_cb__cmd__type == *other_value.field_cb__cmd__type;
case ALT_smscb__message:
return *field_smscb__message == *other_value.field_smscb__message;
case ALT_cbch__load__info:
return *field_cbch__load__info == *other_value.field_cbch__load__info;
case ALT_resource__info:
return *field_resource__info == *other_value.field_resource__info;
case ALT_sacch__info:
return *field_sacch__info == *other_value.field_sacch__info;
case ALT_starting__time:
return *field_starting__time == *other_value.field_starting__time;
case ALT_encr__info:
return *field_encr__info == *other_value.field_encr__info;
case ALT_smscb__chan__ind:
return *field_smscb__chan__ind == *other_value.field_smscb__chan__ind;
case ALT_req__ref:
return *field_req__ref == *other_value.field_req__ref;
case ALT_full__imm__ass__info:
return *field_full__imm__ass__info == *other_value.field_full__imm__ass__info;
case ALT_ms__identity:
return *field_ms__identity == *other_value.field_ms__identity;
case ALT_group__call__ref:
return *field_group__call__ref == *other_value.field_group__call__ref;
case ALT_group__chan__desc:
return *field_group__chan__desc == *other_value.field_group__chan__desc;
case ALT_nch__drx__info:
return *field_nch__drx__info == *other_value.field_nch__drx__info;
case ALT_cmd__indicator:
return *field_cmd__indicator == *other_value.field_cmd__indicator;
case ALT_uic:
return *field_uic == *other_value.field_uic;
case ALT_ipa__conn__id:
return *field_ipa__conn__id == *other_value.field_ipa__conn__id;
case ALT_ipa__local__port:
return *field_ipa__local__port == *other_value.field_ipa__local__port;
case ALT_ipa__remote__port:
return *field_ipa__remote__port == *other_value.field_ipa__remote__port;
case ALT_ipa__local__ip:
return *field_ipa__local__ip == *other_value.field_ipa__local__ip;
case ALT_ipa__remote__ip:
return *field_ipa__remote__ip == *other_value.field_ipa__remote__ip;
case ALT_ipa__rtp__pt:
return *field_ipa__rtp__pt == *other_value.field_ipa__rtp__pt;
case ALT_ipa__rtp__pt2:
return *field_ipa__rtp__pt2 == *other_value.field_ipa__rtp__pt2;
case ALT_ipa__stats:
return *field_ipa__stats == *other_value.field_ipa__stats;
case ALT_ipa__speech__mode:
return *field_ipa__speech__mode == *other_value.field_ipa__speech__mode;
case ALT_ipa__rtp__csd__fmt:
return *field_ipa__rtp__csd__fmt == *other_value.field_ipa__rtp__csd__fmt;
case ALT_osmo__training__sequence:
return *field_osmo__training__sequence == *other_value.field_osmo__training__sequence;
case ALT_rep__acch__cap:
return *field_rep__acch__cap == *other_value.field_rep__acch__cap;
case ALT_top__acch__cap:
return *field_top__acch__cap == *other_value.field_top__acch__cap;
case ALT_osmux__cid:
return *field_osmux__cid == *other_value.field_osmux__cid;
case ALT_other:
return *field_other == *other_value.field_other;
default:
return FALSE;
}
}

GSM__Types::RslChannelNr& RSL__IE__Body::chan__nr()
{
if (union_selection != ALT_chan__nr) {
clean_up();
field_chan__nr = new GSM__Types::RslChannelNr;
union_selection = ALT_chan__nr;
}
return *field_chan__nr;
}

const GSM__Types::RslChannelNr& RSL__IE__Body::chan__nr() const
{
if (union_selection != ALT_chan__nr) TTCN_error("Using non-selected field chan_nr in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_chan__nr;
}

GSM__Types::RslLinkId& RSL__IE__Body::link__id()
{
if (union_selection != ALT_link__id) {
clean_up();
field_link__id = new GSM__Types::RslLinkId;
union_selection = ALT_link__id;
}
return *field_link__id;
}

const GSM__Types::RslLinkId& RSL__IE__Body::link__id() const
{
if (union_selection != ALT_link__id) TTCN_error("Using non-selected field link_id in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_link__id;
}

RSL__L16V& RSL__IE__Body::l3__info()
{
if (union_selection != ALT_l3__info) {
clean_up();
field_l3__info = new RSL__L16V;
union_selection = ALT_l3__info;
}
return *field_l3__info;
}

const RSL__L16V& RSL__IE__Body::l3__info() const
{
if (union_selection != ALT_l3__info) TTCN_error("Using non-selected field l3_info in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_l3__info;
}

RSL__LV& RSL__IE__Body::rlm__cause()
{
if (union_selection != ALT_rlm__cause) {
clean_up();
field_rlm__cause = new RSL__LV;
union_selection = ALT_rlm__cause;
}
return *field_rlm__cause;
}

const RSL__LV& RSL__IE__Body::rlm__cause() const
{
if (union_selection != ALT_rlm__cause) TTCN_error("Using non-selected field rlm_cause in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_rlm__cause;
}

RSL__IE__ReleaseMode& RSL__IE__Body::release__mode()
{
if (union_selection != ALT_release__mode) {
clean_up();
field_release__mode = new RSL__IE__ReleaseMode;
union_selection = ALT_release__mode;
}
return *field_release__mode;
}

const RSL__IE__ReleaseMode& RSL__IE__Body::release__mode() const
{
if (union_selection != ALT_release__mode) TTCN_error("Using non-selected field release_mode in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_release__mode;
}

RSL__IE__ActivationType& RSL__IE__Body::act__type()
{
if (union_selection != ALT_act__type) {
clean_up();
field_act__type = new RSL__IE__ActivationType;
union_selection = ALT_act__type;
}
return *field_act__type;
}

const RSL__IE__ActivationType& RSL__IE__Body::act__type() const
{
if (union_selection != ALT_act__type) TTCN_error("Using non-selected field act_type in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_act__type;
}

RSL__IE__ChannelIdent& RSL__IE__Body::chan__ident()
{
if (union_selection != ALT_chan__ident) {
clean_up();
field_chan__ident = new RSL__IE__ChannelIdent;
union_selection = ALT_chan__ident;
}
return *field_chan__ident;
}

const RSL__IE__ChannelIdent& RSL__IE__Body::chan__ident() const
{
if (union_selection != ALT_chan__ident) TTCN_error("Using non-selected field chan_ident in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_chan__ident;
}

RSL__IE__ChannelMode& RSL__IE__Body::chan__mode()
{
if (union_selection != ALT_chan__mode) {
clean_up();
field_chan__mode = new RSL__IE__ChannelMode;
union_selection = ALT_chan__mode;
}
return *field_chan__mode;
}

const RSL__IE__ChannelMode& RSL__IE__Body::chan__mode() const
{
if (union_selection != ALT_chan__mode) TTCN_error("Using non-selected field chan_mode in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_chan__mode;
}

INTEGER& RSL__IE__Body::handover__ref()
{
if (union_selection != ALT_handover__ref) {
clean_up();
field_handover__ref = new INTEGER;
union_selection = ALT_handover__ref;
}
return *field_handover__ref;
}

const INTEGER& RSL__IE__Body::handover__ref() const
{
if (union_selection != ALT_handover__ref) TTCN_error("Using non-selected field handover_ref in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_handover__ref;
}

RSL__IE__BS__Power& RSL__IE__Body::bs__power()
{
if (union_selection != ALT_bs__power) {
clean_up();
field_bs__power = new RSL__IE__BS__Power;
union_selection = ALT_bs__power;
}
return *field_bs__power;
}

const RSL__IE__BS__Power& RSL__IE__Body::bs__power() const
{
if (union_selection != ALT_bs__power) TTCN_error("Using non-selected field bs_power in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_bs__power;
}

RSL__LV& RSL__IE__Body::bs__power__params()
{
if (union_selection != ALT_bs__power__params) {
clean_up();
field_bs__power__params = new RSL__LV;
union_selection = ALT_bs__power__params;
}
return *field_bs__power__params;
}

const RSL__LV& RSL__IE__Body::bs__power__params() const
{
if (union_selection != ALT_bs__power__params) TTCN_error("Using non-selected field bs_power_params in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_bs__power__params;
}

RSL__IE__MS__Power& RSL__IE__Body::ms__power()
{
if (union_selection != ALT_ms__power) {
clean_up();
field_ms__power = new RSL__IE__MS__Power;
union_selection = ALT_ms__power;
}
return *field_ms__power;
}

const RSL__IE__MS__Power& RSL__IE__Body::ms__power() const
{
if (union_selection != ALT_ms__power) TTCN_error("Using non-selected field ms_power in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_ms__power;
}

RSL__IE__MS__Power__Parameters& RSL__IE__Body::ms__power__params()
{
if (union_selection != ALT_ms__power__params) {
clean_up();
field_ms__power__params = new RSL__IE__MS__Power__Parameters;
union_selection = ALT_ms__power__params;
}
return *field_ms__power__params;
}

const RSL__IE__MS__Power__Parameters& RSL__IE__Body::ms__power__params() const
{
if (union_selection != ALT_ms__power__params) TTCN_error("Using non-selected field ms_power_params in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_ms__power__params;
}

INTEGER& RSL__IE__Body::timing__adv()
{
if (union_selection != ALT_timing__adv) {
clean_up();
field_timing__adv = new INTEGER;
union_selection = ALT_timing__adv;
}
return *field_timing__adv;
}

const INTEGER& RSL__IE__Body::timing__adv() const
{
if (union_selection != ALT_timing__adv) TTCN_error("Using non-selected field timing_adv in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_timing__adv;
}

RSL__IE__MultirateCfg& RSL__IE__Body::multirate__cfg()
{
if (union_selection != ALT_multirate__cfg) {
clean_up();
field_multirate__cfg = new RSL__IE__MultirateCfg;
union_selection = ALT_multirate__cfg;
}
return *field_multirate__cfg;
}

const RSL__IE__MultirateCfg& RSL__IE__Body::multirate__cfg() const
{
if (union_selection != ALT_multirate__cfg) TTCN_error("Using non-selected field multirate_cfg in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_multirate__cfg;
}

RSL__IE__MultirateCtrl& RSL__IE__Body::multirate__ctrl()
{
if (union_selection != ALT_multirate__ctrl) {
clean_up();
field_multirate__ctrl = new RSL__IE__MultirateCtrl;
union_selection = ALT_multirate__ctrl;
}
return *field_multirate__ctrl;
}

const RSL__IE__MultirateCtrl& RSL__IE__Body::multirate__ctrl() const
{
if (union_selection != ALT_multirate__ctrl) TTCN_error("Using non-selected field multirate_ctrl in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_multirate__ctrl;
}

INTEGER& RSL__IE__Body::msg__id()
{
if (union_selection != ALT_msg__id) {
clean_up();
field_msg__id = new INTEGER;
union_selection = ALT_msg__id;
}
return *field_msg__id;
}

const INTEGER& RSL__IE__Body::msg__id() const
{
if (union_selection != ALT_msg__id) TTCN_error("Using non-selected field msg_id in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_msg__id;
}

RSL__IE__FrameNumber& RSL__IE__Body::frame__nr()
{
if (union_selection != ALT_frame__nr) {
clean_up();
field_frame__nr = new RSL__IE__FrameNumber;
union_selection = ALT_frame__nr;
}
return *field_frame__nr;
}

const RSL__IE__FrameNumber& RSL__IE__Body::frame__nr() const
{
if (union_selection != ALT_frame__nr) TTCN_error("Using non-selected field frame_nr in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_frame__nr;
}

RSL__IE__Cause& RSL__IE__Body::cause()
{
if (union_selection != ALT_cause) {
clean_up();
field_cause = new RSL__IE__Cause;
union_selection = ALT_cause;
}
return *field_cause;
}

const RSL__IE__Cause& RSL__IE__Body::cause() const
{
if (union_selection != ALT_cause) TTCN_error("Using non-selected field cause in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_cause;
}

INTEGER& RSL__IE__Body::access__delay()
{
if (union_selection != ALT_access__delay) {
clean_up();
field_access__delay = new INTEGER;
union_selection = ALT_access__delay;
}
return *field_access__delay;
}

const INTEGER& RSL__IE__Body::access__delay() const
{
if (union_selection != ALT_access__delay) TTCN_error("Using non-selected field access_delay in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_access__delay;
}

RSL__IE__RachLoad& RSL__IE__Body::rach__load()
{
if (union_selection != ALT_rach__load) {
clean_up();
field_rach__load = new RSL__IE__RachLoad;
union_selection = ALT_rach__load;
}
return *field_rach__load;
}

const RSL__IE__RachLoad& RSL__IE__Body::rach__load() const
{
if (union_selection != ALT_rach__load) TTCN_error("Using non-selected field rach_load in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_rach__load;
}

INTEGER& RSL__IE__Body::meas__res__nr()
{
if (union_selection != ALT_meas__res__nr) {
clean_up();
field_meas__res__nr = new INTEGER;
union_selection = ALT_meas__res__nr;
}
return *field_meas__res__nr;
}

const INTEGER& RSL__IE__Body::meas__res__nr() const
{
if (union_selection != ALT_meas__res__nr) TTCN_error("Using non-selected field meas_res_nr in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_meas__res__nr;
}

INTEGER& RSL__IE__Body::ms__timing__offset()
{
if (union_selection != ALT_ms__timing__offset) {
clean_up();
field_ms__timing__offset = new INTEGER;
union_selection = ALT_ms__timing__offset;
}
return *field_ms__timing__offset;
}

const INTEGER& RSL__IE__Body::ms__timing__offset() const
{
if (union_selection != ALT_ms__timing__offset) TTCN_error("Using non-selected field ms_timing_offset in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_ms__timing__offset;
}

RSL__IE__UplinkMeas& RSL__IE__Body::uplink__meas()
{
if (union_selection != ALT_uplink__meas) {
clean_up();
field_uplink__meas = new RSL__IE__UplinkMeas;
union_selection = ALT_uplink__meas;
}
return *field_uplink__meas;
}

const RSL__IE__UplinkMeas& RSL__IE__Body::uplink__meas() const
{
if (union_selection != ALT_uplink__meas) TTCN_error("Using non-selected field uplink_meas in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_uplink__meas;
}

RSL__IE__L1Info& RSL__IE__Body::l1__info()
{
if (union_selection != ALT_l1__info) {
clean_up();
field_l1__info = new RSL__IE__L1Info;
union_selection = ALT_l1__info;
}
return *field_l1__info;
}

const RSL__IE__L1Info& RSL__IE__Body::l1__info() const
{
if (union_selection != ALT_l1__info) TTCN_error("Using non-selected field l1_info in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_l1__info;
}

RSL__IE__SysinfoType& RSL__IE__Body::sysinfo__type()
{
if (union_selection != ALT_sysinfo__type) {
clean_up();
field_sysinfo__type = new RSL__IE__SysinfoType;
union_selection = ALT_sysinfo__type;
}
return *field_sysinfo__type;
}

const RSL__IE__SysinfoType& RSL__IE__Body::sysinfo__type() const
{
if (union_selection != ALT_sysinfo__type) TTCN_error("Using non-selected field sysinfo_type in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_sysinfo__type;
}

INTEGER& RSL__IE__Body::paging__load()
{
if (union_selection != ALT_paging__load) {
clean_up();
field_paging__load = new INTEGER;
union_selection = ALT_paging__load;
}
return *field_paging__load;
}

const INTEGER& RSL__IE__Body::paging__load() const
{
if (union_selection != ALT_paging__load) TTCN_error("Using non-selected field paging_load in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_paging__load;
}

INTEGER& RSL__IE__Body::paging__group()
{
if (union_selection != ALT_paging__group) {
clean_up();
field_paging__group = new INTEGER;
union_selection = ALT_paging__group;
}
return *field_paging__group;
}

const INTEGER& RSL__IE__Body::paging__group() const
{
if (union_selection != ALT_paging__group) TTCN_error("Using non-selected field paging_group in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_paging__group;
}

RSL__IE__ChanNeeded& RSL__IE__Body::chan__needed()
{
if (union_selection != ALT_chan__needed) {
clean_up();
field_chan__needed = new RSL__IE__ChanNeeded;
union_selection = ALT_chan__needed;
}
return *field_chan__needed;
}

const RSL__IE__ChanNeeded& RSL__IE__Body::chan__needed() const
{
if (union_selection != ALT_chan__needed) TTCN_error("Using non-selected field chan_needed in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_chan__needed;
}

RSL__IE__CbCommandType& RSL__IE__Body::cb__cmd__type()
{
if (union_selection != ALT_cb__cmd__type) {
clean_up();
field_cb__cmd__type = new RSL__IE__CbCommandType;
union_selection = ALT_cb__cmd__type;
}
return *field_cb__cmd__type;
}

const RSL__IE__CbCommandType& RSL__IE__Body::cb__cmd__type() const
{
if (union_selection != ALT_cb__cmd__type) TTCN_error("Using non-selected field cb_cmd_type in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_cb__cmd__type;
}

RSL__LV& RSL__IE__Body::smscb__message()
{
if (union_selection != ALT_smscb__message) {
clean_up();
field_smscb__message = new RSL__LV;
union_selection = ALT_smscb__message;
}
return *field_smscb__message;
}

const RSL__LV& RSL__IE__Body::smscb__message() const
{
if (union_selection != ALT_smscb__message) TTCN_error("Using non-selected field smscb_message in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_smscb__message;
}

RSL__IE__CbchLoadInfo& RSL__IE__Body::cbch__load__info()
{
if (union_selection != ALT_cbch__load__info) {
clean_up();
field_cbch__load__info = new RSL__IE__CbchLoadInfo;
union_selection = ALT_cbch__load__info;
}
return *field_cbch__load__info;
}

const RSL__IE__CbchLoadInfo& RSL__IE__Body::cbch__load__info() const
{
if (union_selection != ALT_cbch__load__info) TTCN_error("Using non-selected field cbch_load_info in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_cbch__load__info;
}

RSL__IE__ResourceInfo& RSL__IE__Body::resource__info()
{
if (union_selection != ALT_resource__info) {
clean_up();
field_resource__info = new RSL__IE__ResourceInfo;
union_selection = ALT_resource__info;
}
return *field_resource__info;
}

const RSL__IE__ResourceInfo& RSL__IE__Body::resource__info() const
{
if (union_selection != ALT_resource__info) TTCN_error("Using non-selected field resource_info in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_resource__info;
}

RSL__SacchInfo& RSL__IE__Body::sacch__info()
{
if (union_selection != ALT_sacch__info) {
clean_up();
field_sacch__info = new RSL__SacchInfo;
union_selection = ALT_sacch__info;
}
return *field_sacch__info;
}

const RSL__SacchInfo& RSL__IE__Body::sacch__info() const
{
if (union_selection != ALT_sacch__info) TTCN_error("Using non-selected field sacch_info in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_sacch__info;
}

RSL__IE__FrameNumber& RSL__IE__Body::starting__time()
{
if (union_selection != ALT_starting__time) {
clean_up();
field_starting__time = new RSL__IE__FrameNumber;
union_selection = ALT_starting__time;
}
return *field_starting__time;
}

const RSL__IE__FrameNumber& RSL__IE__Body::starting__time() const
{
if (union_selection != ALT_starting__time) TTCN_error("Using non-selected field starting_time in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_starting__time;
}

RSL__IE__EncryptionInfo& RSL__IE__Body::encr__info()
{
if (union_selection != ALT_encr__info) {
clean_up();
field_encr__info = new RSL__IE__EncryptionInfo;
union_selection = ALT_encr__info;
}
return *field_encr__info;
}

const RSL__IE__EncryptionInfo& RSL__IE__Body::encr__info() const
{
if (union_selection != ALT_encr__info) TTCN_error("Using non-selected field encr_info in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_encr__info;
}

INTEGER& RSL__IE__Body::smscb__chan__ind()
{
if (union_selection != ALT_smscb__chan__ind) {
clean_up();
field_smscb__chan__ind = new INTEGER;
union_selection = ALT_smscb__chan__ind;
}
return *field_smscb__chan__ind;
}

const INTEGER& RSL__IE__Body::smscb__chan__ind() const
{
if (union_selection != ALT_smscb__chan__ind) TTCN_error("Using non-selected field smscb_chan_ind in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_smscb__chan__ind;
}

RSL__IE__RequestRef& RSL__IE__Body::req__ref()
{
if (union_selection != ALT_req__ref) {
clean_up();
field_req__ref = new RSL__IE__RequestRef;
union_selection = ALT_req__ref;
}
return *field_req__ref;
}

const RSL__IE__RequestRef& RSL__IE__Body::req__ref() const
{
if (union_selection != ALT_req__ref) TTCN_error("Using non-selected field req_ref in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_req__ref;
}

RSL__LV& RSL__IE__Body::full__imm__ass__info()
{
if (union_selection != ALT_full__imm__ass__info) {
clean_up();
field_full__imm__ass__info = new RSL__LV;
union_selection = ALT_full__imm__ass__info;
}
return *field_full__imm__ass__info;
}

const RSL__LV& RSL__IE__Body::full__imm__ass__info() const
{
if (union_selection != ALT_full__imm__ass__info) TTCN_error("Using non-selected field full_imm_ass_info in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_full__imm__ass__info;
}

MobileL3__CommonIE__Types::MobileIdentityLV& RSL__IE__Body::ms__identity()
{
if (union_selection != ALT_ms__identity) {
clean_up();
field_ms__identity = new MobileL3__CommonIE__Types::MobileIdentityLV;
union_selection = ALT_ms__identity;
}
return *field_ms__identity;
}

const MobileL3__CommonIE__Types::MobileIdentityLV& RSL__IE__Body::ms__identity() const
{
if (union_selection != ALT_ms__identity) TTCN_error("Using non-selected field ms_identity in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_ms__identity;
}

RSL__IE__GroupCallReference& RSL__IE__Body::group__call__ref()
{
if (union_selection != ALT_group__call__ref) {
clean_up();
field_group__call__ref = new RSL__IE__GroupCallReference;
union_selection = ALT_group__call__ref;
}
return *field_group__call__ref;
}

const RSL__IE__GroupCallReference& RSL__IE__Body::group__call__ref() const
{
if (union_selection != ALT_group__call__ref) TTCN_error("Using non-selected field group_call_ref in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_group__call__ref;
}

RSL__IE__GroupChannelDescription& RSL__IE__Body::group__chan__desc()
{
if (union_selection != ALT_group__chan__desc) {
clean_up();
field_group__chan__desc = new RSL__IE__GroupChannelDescription;
union_selection = ALT_group__chan__desc;
}
return *field_group__chan__desc;
}

const RSL__IE__GroupChannelDescription& RSL__IE__Body::group__chan__desc() const
{
if (union_selection != ALT_group__chan__desc) TTCN_error("Using non-selected field group_chan_desc in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_group__chan__desc;
}

RSL__IE__NchDrxInformation& RSL__IE__Body::nch__drx__info()
{
if (union_selection != ALT_nch__drx__info) {
clean_up();
field_nch__drx__info = new RSL__IE__NchDrxInformation;
union_selection = ALT_nch__drx__info;
}
return *field_nch__drx__info;
}

const RSL__IE__NchDrxInformation& RSL__IE__Body::nch__drx__info() const
{
if (union_selection != ALT_nch__drx__info) TTCN_error("Using non-selected field nch_drx_info in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_nch__drx__info;
}

RSL__IE__CommandIndicator& RSL__IE__Body::cmd__indicator()
{
if (union_selection != ALT_cmd__indicator) {
clean_up();
field_cmd__indicator = new RSL__IE__CommandIndicator;
union_selection = ALT_cmd__indicator;
}
return *field_cmd__indicator;
}

const RSL__IE__CommandIndicator& RSL__IE__Body::cmd__indicator() const
{
if (union_selection != ALT_cmd__indicator) TTCN_error("Using non-selected field cmd_indicator in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_cmd__indicator;
}

RSL__IE__Uic& RSL__IE__Body::uic()
{
if (union_selection != ALT_uic) {
clean_up();
field_uic = new RSL__IE__Uic;
union_selection = ALT_uic;
}
return *field_uic;
}

const RSL__IE__Uic& RSL__IE__Body::uic() const
{
if (union_selection != ALT_uic) TTCN_error("Using non-selected field uic in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_uic;
}

INTEGER& RSL__IE__Body::ipa__conn__id()
{
if (union_selection != ALT_ipa__conn__id) {
clean_up();
field_ipa__conn__id = new INTEGER;
union_selection = ALT_ipa__conn__id;
}
return *field_ipa__conn__id;
}

const INTEGER& RSL__IE__Body::ipa__conn__id() const
{
if (union_selection != ALT_ipa__conn__id) TTCN_error("Using non-selected field ipa_conn_id in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_ipa__conn__id;
}

INTEGER& RSL__IE__Body::ipa__local__port()
{
if (union_selection != ALT_ipa__local__port) {
clean_up();
field_ipa__local__port = new INTEGER;
union_selection = ALT_ipa__local__port;
}
return *field_ipa__local__port;
}

const INTEGER& RSL__IE__Body::ipa__local__port() const
{
if (union_selection != ALT_ipa__local__port) TTCN_error("Using non-selected field ipa_local_port in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_ipa__local__port;
}

INTEGER& RSL__IE__Body::ipa__remote__port()
{
if (union_selection != ALT_ipa__remote__port) {
clean_up();
field_ipa__remote__port = new INTEGER;
union_selection = ALT_ipa__remote__port;
}
return *field_ipa__remote__port;
}

const INTEGER& RSL__IE__Body::ipa__remote__port() const
{
if (union_selection != ALT_ipa__remote__port) TTCN_error("Using non-selected field ipa_remote_port in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_ipa__remote__port;
}

OCTETSTRING& RSL__IE__Body::ipa__local__ip()
{
if (union_selection != ALT_ipa__local__ip) {
clean_up();
field_ipa__local__ip = new OCTETSTRING;
union_selection = ALT_ipa__local__ip;
}
return *field_ipa__local__ip;
}

const OCTETSTRING& RSL__IE__Body::ipa__local__ip() const
{
if (union_selection != ALT_ipa__local__ip) TTCN_error("Using non-selected field ipa_local_ip in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_ipa__local__ip;
}

OCTETSTRING& RSL__IE__Body::ipa__remote__ip()
{
if (union_selection != ALT_ipa__remote__ip) {
clean_up();
field_ipa__remote__ip = new OCTETSTRING;
union_selection = ALT_ipa__remote__ip;
}
return *field_ipa__remote__ip;
}

const OCTETSTRING& RSL__IE__Body::ipa__remote__ip() const
{
if (union_selection != ALT_ipa__remote__ip) TTCN_error("Using non-selected field ipa_remote_ip in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_ipa__remote__ip;
}

INTEGER& RSL__IE__Body::ipa__rtp__pt()
{
if (union_selection != ALT_ipa__rtp__pt) {
clean_up();
field_ipa__rtp__pt = new INTEGER;
union_selection = ALT_ipa__rtp__pt;
}
return *field_ipa__rtp__pt;
}

const INTEGER& RSL__IE__Body::ipa__rtp__pt() const
{
if (union_selection != ALT_ipa__rtp__pt) TTCN_error("Using non-selected field ipa_rtp_pt in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_ipa__rtp__pt;
}

INTEGER& RSL__IE__Body::ipa__rtp__pt2()
{
if (union_selection != ALT_ipa__rtp__pt2) {
clean_up();
field_ipa__rtp__pt2 = new INTEGER;
union_selection = ALT_ipa__rtp__pt2;
}
return *field_ipa__rtp__pt2;
}

const INTEGER& RSL__IE__Body::ipa__rtp__pt2() const
{
if (union_selection != ALT_ipa__rtp__pt2) TTCN_error("Using non-selected field ipa_rtp_pt2 in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_ipa__rtp__pt2;
}

RSL__IE__IPA__ConnectionStats& RSL__IE__Body::ipa__stats()
{
if (union_selection != ALT_ipa__stats) {
clean_up();
field_ipa__stats = new RSL__IE__IPA__ConnectionStats;
union_selection = ALT_ipa__stats;
}
return *field_ipa__stats;
}

const RSL__IE__IPA__ConnectionStats& RSL__IE__Body::ipa__stats() const
{
if (union_selection != ALT_ipa__stats) TTCN_error("Using non-selected field ipa_stats in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_ipa__stats;
}

RSL__IE__IPA__SpeechMode& RSL__IE__Body::ipa__speech__mode()
{
if (union_selection != ALT_ipa__speech__mode) {
clean_up();
field_ipa__speech__mode = new RSL__IE__IPA__SpeechMode;
union_selection = ALT_ipa__speech__mode;
}
return *field_ipa__speech__mode;
}

const RSL__IE__IPA__SpeechMode& RSL__IE__Body::ipa__speech__mode() const
{
if (union_selection != ALT_ipa__speech__mode) TTCN_error("Using non-selected field ipa_speech_mode in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_ipa__speech__mode;
}

RSL__IE__IPA__RTP__CSD__FMT& RSL__IE__Body::ipa__rtp__csd__fmt()
{
if (union_selection != ALT_ipa__rtp__csd__fmt) {
clean_up();
field_ipa__rtp__csd__fmt = new RSL__IE__IPA__RTP__CSD__FMT;
union_selection = ALT_ipa__rtp__csd__fmt;
}
return *field_ipa__rtp__csd__fmt;
}

const RSL__IE__IPA__RTP__CSD__FMT& RSL__IE__Body::ipa__rtp__csd__fmt() const
{
if (union_selection != ALT_ipa__rtp__csd__fmt) TTCN_error("Using non-selected field ipa_rtp_csd_fmt in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_ipa__rtp__csd__fmt;
}

RSL__IE__OSMO__TrainingSequence& RSL__IE__Body::osmo__training__sequence()
{
if (union_selection != ALT_osmo__training__sequence) {
clean_up();
field_osmo__training__sequence = new RSL__IE__OSMO__TrainingSequence;
union_selection = ALT_osmo__training__sequence;
}
return *field_osmo__training__sequence;
}

const RSL__IE__OSMO__TrainingSequence& RSL__IE__Body::osmo__training__sequence() const
{
if (union_selection != ALT_osmo__training__sequence) TTCN_error("Using non-selected field osmo_training_sequence in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_osmo__training__sequence;
}

RSL__IE__OSMO__RepAcchCap& RSL__IE__Body::rep__acch__cap()
{
if (union_selection != ALT_rep__acch__cap) {
clean_up();
field_rep__acch__cap = new RSL__IE__OSMO__RepAcchCap;
union_selection = ALT_rep__acch__cap;
}
return *field_rep__acch__cap;
}

const RSL__IE__OSMO__RepAcchCap& RSL__IE__Body::rep__acch__cap() const
{
if (union_selection != ALT_rep__acch__cap) TTCN_error("Using non-selected field rep_acch_cap in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_rep__acch__cap;
}

RSL__IE__OSMO__TopAcchCap& RSL__IE__Body::top__acch__cap()
{
if (union_selection != ALT_top__acch__cap) {
clean_up();
field_top__acch__cap = new RSL__IE__OSMO__TopAcchCap;
union_selection = ALT_top__acch__cap;
}
return *field_top__acch__cap;
}

const RSL__IE__OSMO__TopAcchCap& RSL__IE__Body::top__acch__cap() const
{
if (union_selection != ALT_top__acch__cap) TTCN_error("Using non-selected field top_acch_cap in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_top__acch__cap;
}

RSL__IE__OSMO__Osmux__CID& RSL__IE__Body::osmux__cid()
{
if (union_selection != ALT_osmux__cid) {
clean_up();
field_osmux__cid = new RSL__IE__OSMO__Osmux__CID;
union_selection = ALT_osmux__cid;
}
return *field_osmux__cid;
}

const RSL__IE__OSMO__Osmux__CID& RSL__IE__Body::osmux__cid() const
{
if (union_selection != ALT_osmux__cid) TTCN_error("Using non-selected field osmux_cid in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_osmux__cid;
}

RSL__LV& RSL__IE__Body::other()
{
if (union_selection != ALT_other) {
clean_up();
field_other = new RSL__LV;
union_selection = ALT_other;
}
return *field_other;
}

const RSL__LV& RSL__IE__Body::other() const
{
if (union_selection != ALT_other) TTCN_error("Using non-selected field other in a value of union type @RSL_Types.RSL_IE_Body.");
return *field_other;
}

boolean RSL__IE__Body::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @RSL_Types.RSL_IE_Body.");
return union_selection == checked_selection;
}

boolean RSL__IE__Body::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean RSL__IE__Body::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_chan__nr: return field_chan__nr->is_value();
case ALT_link__id: return field_link__id->is_value();
case ALT_l3__info: return field_l3__info->is_value();
case ALT_rlm__cause: return field_rlm__cause->is_value();
case ALT_release__mode: return field_release__mode->is_value();
case ALT_act__type: return field_act__type->is_value();
case ALT_chan__ident: return field_chan__ident->is_value();
case ALT_chan__mode: return field_chan__mode->is_value();
case ALT_handover__ref: return field_handover__ref->is_value();
case ALT_bs__power: return field_bs__power->is_value();
case ALT_bs__power__params: return field_bs__power__params->is_value();
case ALT_ms__power: return field_ms__power->is_value();
case ALT_ms__power__params: return field_ms__power__params->is_value();
case ALT_timing__adv: return field_timing__adv->is_value();
case ALT_multirate__cfg: return field_multirate__cfg->is_value();
case ALT_multirate__ctrl: return field_multirate__ctrl->is_value();
case ALT_msg__id: return field_msg__id->is_value();
case ALT_frame__nr: return field_frame__nr->is_value();
case ALT_cause: return field_cause->is_value();
case ALT_access__delay: return field_access__delay->is_value();
case ALT_rach__load: return field_rach__load->is_value();
case ALT_meas__res__nr: return field_meas__res__nr->is_value();
case ALT_ms__timing__offset: return field_ms__timing__offset->is_value();
case ALT_uplink__meas: return field_uplink__meas->is_value();
case ALT_l1__info: return field_l1__info->is_value();
case ALT_sysinfo__type: return field_sysinfo__type->is_value();
case ALT_paging__load: return field_paging__load->is_value();
case ALT_paging__group: return field_paging__group->is_value();
case ALT_chan__needed: return field_chan__needed->is_value();
case ALT_cb__cmd__type: return field_cb__cmd__type->is_value();
case ALT_smscb__message: return field_smscb__message->is_value();
case ALT_cbch__load__info: return field_cbch__load__info->is_value();
case ALT_resource__info: return field_resource__info->is_value();
case ALT_sacch__info: return field_sacch__info->is_value();
case ALT_starting__time: return field_starting__time->is_value();
case ALT_encr__info: return field_encr__info->is_value();
case ALT_smscb__chan__ind: return field_smscb__chan__ind->is_value();
case ALT_req__ref: return field_req__ref->is_value();
case ALT_full__imm__ass__info: return field_full__imm__ass__info->is_value();
case ALT_ms__identity: return field_ms__identity->is_value();
case ALT_group__call__ref: return field_group__call__ref->is_value();
case ALT_group__chan__desc: return field_group__chan__desc->is_value();
case ALT_nch__drx__info: return field_nch__drx__info->is_value();
case ALT_cmd__indicator: return field_cmd__indicator->is_value();
case ALT_uic: return field_uic->is_value();
case ALT_ipa__conn__id: return field_ipa__conn__id->is_value();
case ALT_ipa__local__port: return field_ipa__local__port->is_value();
case ALT_ipa__remote__port: return field_ipa__remote__port->is_value();
case ALT_ipa__local__ip: return field_ipa__local__ip->is_value();
case ALT_ipa__remote__ip: return field_ipa__remote__ip->is_value();
case ALT_ipa__rtp__pt: return field_ipa__rtp__pt->is_value();
case ALT_ipa__rtp__pt2: return field_ipa__rtp__pt2->is_value();
case ALT_ipa__stats: return field_ipa__stats->is_value();
case ALT_ipa__speech__mode: return field_ipa__speech__mode->is_value();
case ALT_ipa__rtp__csd__fmt: return field_ipa__rtp__csd__fmt->is_value();
case ALT_osmo__training__sequence: return field_osmo__training__sequence->is_value();
case ALT_rep__acch__cap: return field_rep__acch__cap->is_value();
case ALT_top__acch__cap: return field_top__acch__cap->is_value();
case ALT_osmux__cid: return field_osmux__cid->is_value();
case ALT_other: return field_other->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void RSL__IE__Body::clean_up()
{
switch (union_selection) {
case ALT_chan__nr:
  delete field_chan__nr;
  break;
case ALT_link__id:
  delete field_link__id;
  break;
case ALT_l3__info:
  delete field_l3__info;
  break;
case ALT_rlm__cause:
  delete field_rlm__cause;
  break;
case ALT_release__mode:
  delete field_release__mode;
  break;
case ALT_act__type:
  delete field_act__type;
  break;
case ALT_chan__ident:
  delete field_chan__ident;
  break;
case ALT_chan__mode:
  delete field_chan__mode;
  break;
case ALT_handover__ref:
  delete field_handover__ref;
  break;
case ALT_bs__power:
  delete field_bs__power;
  break;
case ALT_bs__power__params:
  delete field_bs__power__params;
  break;
case ALT_ms__power:
  delete field_ms__power;
  break;
case ALT_ms__power__params:
  delete field_ms__power__params;
  break;
case ALT_timing__adv:
  delete field_timing__adv;
  break;
case ALT_multirate__cfg:
  delete field_multirate__cfg;
  break;
case ALT_multirate__ctrl:
  delete field_multirate__ctrl;
  break;
case ALT_msg__id:
  delete field_msg__id;
  break;
case ALT_frame__nr:
  delete field_frame__nr;
  break;
case ALT_cause:
  delete field_cause;
  break;
case ALT_access__delay:
  delete field_access__delay;
  break;
case ALT_rach__load:
  delete field_rach__load;
  break;
case ALT_meas__res__nr:
  delete field_meas__res__nr;
  break;
case ALT_ms__timing__offset:
  delete field_ms__timing__offset;
  break;
case ALT_uplink__meas:
  delete field_uplink__meas;
  break;
case ALT_l1__info:
  delete field_l1__info;
  break;
case ALT_sysinfo__type:
  delete field_sysinfo__type;
  break;
case ALT_paging__load:
  delete field_paging__load;
  break;
case ALT_paging__group:
  delete field_paging__group;
  break;
case ALT_chan__needed:
  delete field_chan__needed;
  break;
case ALT_cb__cmd__type:
  delete field_cb__cmd__type;
  break;
case ALT_smscb__message:
  delete field_smscb__message;
  break;
case ALT_cbch__load__info:
  delete field_cbch__load__info;
  break;
case ALT_resource__info:
  delete field_resource__info;
  break;
case ALT_sacch__info:
  delete field_sacch__info;
  break;
case ALT_starting__time:
  delete field_starting__time;
  break;
case ALT_encr__info:
  delete field_encr__info;
  break;
case ALT_smscb__chan__ind:
  delete field_smscb__chan__ind;
  break;
case ALT_req__ref:
  delete field_req__ref;
  break;
case ALT_full__imm__ass__info:
  delete field_full__imm__ass__info;
  break;
case ALT_ms__identity:
  delete field_ms__identity;
  break;
case ALT_group__call__ref:
  delete field_group__call__ref;
  break;
case ALT_group__chan__desc:
  delete field_group__chan__desc;
  break;
case ALT_nch__drx__info:
  delete field_nch__drx__info;
  break;
case ALT_cmd__indicator:
  delete field_cmd__indicator;
  break;
case ALT_uic:
  delete field_uic;
  break;
case ALT_ipa__conn__id:
  delete field_ipa__conn__id;
  break;
case ALT_ipa__local__port:
  delete field_ipa__local__port;
  break;
case ALT_ipa__remote__port:
  delete field_ipa__remote__port;
  break;
case ALT_ipa__local__ip:
  delete field_ipa__local__ip;
  break;
case ALT_ipa__remote__ip:
  delete field_ipa__remote__ip;
  break;
case ALT_ipa__rtp__pt:
  delete field_ipa__rtp__pt;
  break;
case ALT_ipa__rtp__pt2:
  delete field_ipa__rtp__pt2;
  break;
case ALT_ipa__stats:
  delete field_ipa__stats;
  break;
case ALT_ipa__speech__mode:
  delete field_ipa__speech__mode;
  break;
case ALT_ipa__rtp__csd__fmt:
  delete field_ipa__rtp__csd__fmt;
  break;
case ALT_osmo__training__sequence:
  delete field_osmo__training__sequence;
  break;
case ALT_rep__acch__cap:
  delete field_rep__acch__cap;
  break;
case ALT_top__acch__cap:
  delete field_top__acch__cap;
  break;
case ALT_osmux__cid:
  delete field_osmux__cid;
  break;
case ALT_other:
  delete field_other;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void RSL__IE__Body::log() const
{
switch (union_selection) {
case ALT_chan__nr:
TTCN_Logger::log_event_str("{ chan_nr := ");
field_chan__nr->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_link__id:
TTCN_Logger::log_event_str("{ link_id := ");
field_link__id->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_l3__info:
TTCN_Logger::log_event_str("{ l3_info := ");
field_l3__info->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_rlm__cause:
TTCN_Logger::log_event_str("{ rlm_cause := ");
field_rlm__cause->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_release__mode:
TTCN_Logger::log_event_str("{ release_mode := ");
field_release__mode->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_act__type:
TTCN_Logger::log_event_str("{ act_type := ");
field_act__type->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_chan__ident:
TTCN_Logger::log_event_str("{ chan_ident := ");
field_chan__ident->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_chan__mode:
TTCN_Logger::log_event_str("{ chan_mode := ");
field_chan__mode->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_handover__ref:
TTCN_Logger::log_event_str("{ handover_ref := ");
field_handover__ref->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_bs__power:
TTCN_Logger::log_event_str("{ bs_power := ");
field_bs__power->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_bs__power__params:
TTCN_Logger::log_event_str("{ bs_power_params := ");
field_bs__power__params->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_ms__power:
TTCN_Logger::log_event_str("{ ms_power := ");
field_ms__power->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_ms__power__params:
TTCN_Logger::log_event_str("{ ms_power_params := ");
field_ms__power__params->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_timing__adv:
TTCN_Logger::log_event_str("{ timing_adv := ");
field_timing__adv->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_multirate__cfg:
TTCN_Logger::log_event_str("{ multirate_cfg := ");
field_multirate__cfg->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_multirate__ctrl:
TTCN_Logger::log_event_str("{ multirate_ctrl := ");
field_multirate__ctrl->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_msg__id:
TTCN_Logger::log_event_str("{ msg_id := ");
field_msg__id->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_frame__nr:
TTCN_Logger::log_event_str("{ frame_nr := ");
field_frame__nr->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cause:
TTCN_Logger::log_event_str("{ cause := ");
field_cause->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_access__delay:
TTCN_Logger::log_event_str("{ access_delay := ");
field_access__delay->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_rach__load:
TTCN_Logger::log_event_str("{ rach_load := ");
field_rach__load->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_meas__res__nr:
TTCN_Logger::log_event_str("{ meas_res_nr := ");
field_meas__res__nr->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_ms__timing__offset:
TTCN_Logger::log_event_str("{ ms_timing_offset := ");
field_ms__timing__offset->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_uplink__meas:
TTCN_Logger::log_event_str("{ uplink_meas := ");
field_uplink__meas->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_l1__info:
TTCN_Logger::log_event_str("{ l1_info := ");
field_l1__info->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_sysinfo__type:
TTCN_Logger::log_event_str("{ sysinfo_type := ");
field_sysinfo__type->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_paging__load:
TTCN_Logger::log_event_str("{ paging_load := ");
field_paging__load->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_paging__group:
TTCN_Logger::log_event_str("{ paging_group := ");
field_paging__group->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_chan__needed:
TTCN_Logger::log_event_str("{ chan_needed := ");
field_chan__needed->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cb__cmd__type:
TTCN_Logger::log_event_str("{ cb_cmd_type := ");
field_cb__cmd__type->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_smscb__message:
TTCN_Logger::log_event_str("{ smscb_message := ");
field_smscb__message->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cbch__load__info:
TTCN_Logger::log_event_str("{ cbch_load_info := ");
field_cbch__load__info->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_resource__info:
TTCN_Logger::log_event_str("{ resource_info := ");
field_resource__info->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_sacch__info:
TTCN_Logger::log_event_str("{ sacch_info := ");
field_sacch__info->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_starting__time:
TTCN_Logger::log_event_str("{ starting_time := ");
field_starting__time->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_encr__info:
TTCN_Logger::log_event_str("{ encr_info := ");
field_encr__info->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_smscb__chan__ind:
TTCN_Logger::log_event_str("{ smscb_chan_ind := ");
field_smscb__chan__ind->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_req__ref:
TTCN_Logger::log_event_str("{ req_ref := ");
field_req__ref->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_full__imm__ass__info:
TTCN_Logger::log_event_str("{ full_imm_ass_info := ");
field_full__imm__ass__info->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_ms__identity:
TTCN_Logger::log_event_str("{ ms_identity := ");
field_ms__identity->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_group__call__ref:
TTCN_Logger::log_event_str("{ group_call_ref := ");
field_group__call__ref->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_group__chan__desc:
TTCN_Logger::log_event_str("{ group_chan_desc := ");
field_group__chan__desc->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_nch__drx__info:
TTCN_Logger::log_event_str("{ nch_drx_info := ");
field_nch__drx__info->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_cmd__indicator:
TTCN_Logger::log_event_str("{ cmd_indicator := ");
field_cmd__indicator->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_uic:
TTCN_Logger::log_event_str("{ uic := ");
field_uic->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_ipa__conn__id:
TTCN_Logger::log_event_str("{ ipa_conn_id := ");
field_ipa__conn__id->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_ipa__local__port:
TTCN_Logger::log_event_str("{ ipa_local_port := ");
field_ipa__local__port->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_ipa__remote__port:
TTCN_Logger::log_event_str("{ ipa_remote_port := ");
field_ipa__remote__port->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_ipa__local__ip:
TTCN_Logger::log_event_str("{ ipa_local_ip := ");
field_ipa__local__ip->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_ipa__remote__ip:
TTCN_Logger::log_event_str("{ ipa_remote_ip := ");
field_ipa__remote__ip->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_ipa__rtp__pt:
TTCN_Logger::log_event_str("{ ipa_rtp_pt := ");
field_ipa__rtp__pt->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_ipa__rtp__pt2:
TTCN_Logger::log_event_str("{ ipa_rtp_pt2 := ");
field_ipa__rtp__pt2->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_ipa__stats:
TTCN_Logger::log_event_str("{ ipa_stats := ");
field_ipa__stats->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_ipa__speech__mode:
TTCN_Logger::log_event_str("{ ipa_speech_mode := ");
field_ipa__speech__mode->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_ipa__rtp__csd__fmt:
TTCN_Logger::log_event_str("{ ipa_rtp_csd_fmt := ");
field_ipa__rtp__csd__fmt->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_osmo__training__sequence:
TTCN_Logger::log_event_str("{ osmo_training_sequence := ");
field_osmo__training__sequence->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_rep__acch__cap:
TTCN_Logger::log_event_str("{ rep_acch_cap := ");
field_rep__acch__cap->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_top__acch__cap:
TTCN_Logger::log_event_str("{ top_acch_cap := ");
field_top__acch__cap->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_osmux__cid:
TTCN_Logger::log_event_str("{ osmux_cid := ");
field_osmux__cid->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_other:
TTCN_Logger::log_event_str("{ other := ");
field_other->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void RSL__IE__Body::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "chan_nr")) {
    chan__nr().set_param(*mp_last);
    if (!chan__nr().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "link_id")) {
    link__id().set_param(*mp_last);
    if (!link__id().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "l3_info")) {
    l3__info().set_param(*mp_last);
    if (!l3__info().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "rlm_cause")) {
    rlm__cause().set_param(*mp_last);
    if (!rlm__cause().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "release_mode")) {
    release__mode().set_param(*mp_last);
    if (!release__mode().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "act_type")) {
    act__type().set_param(*mp_last);
    if (!act__type().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "chan_ident")) {
    chan__ident().set_param(*mp_last);
    if (!chan__ident().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "chan_mode")) {
    chan__mode().set_param(*mp_last);
    if (!chan__mode().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "handover_ref")) {
    handover__ref().set_param(*mp_last);
    if (!handover__ref().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "bs_power")) {
    bs__power().set_param(*mp_last);
    if (!bs__power().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "bs_power_params")) {
    bs__power__params().set_param(*mp_last);
    if (!bs__power__params().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "ms_power")) {
    ms__power().set_param(*mp_last);
    if (!ms__power().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "ms_power_params")) {
    ms__power__params().set_param(*mp_last);
    if (!ms__power__params().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "timing_adv")) {
    timing__adv().set_param(*mp_last);
    if (!timing__adv().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "multirate_cfg")) {
    multirate__cfg().set_param(*mp_last);
    if (!multirate__cfg().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "multirate_ctrl")) {
    multirate__ctrl().set_param(*mp_last);
    if (!multirate__ctrl().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "msg_id")) {
    msg__id().set_param(*mp_last);
    if (!msg__id().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "frame_nr")) {
    frame__nr().set_param(*mp_last);
    if (!frame__nr().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cause")) {
    cause().set_param(*mp_last);
    if (!cause().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "access_delay")) {
    access__delay().set_param(*mp_last);
    if (!access__delay().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "rach_load")) {
    rach__load().set_param(*mp_last);
    if (!rach__load().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "meas_res_nr")) {
    meas__res__nr().set_param(*mp_last);
    if (!meas__res__nr().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "ms_timing_offset")) {
    ms__timing__offset().set_param(*mp_last);
    if (!ms__timing__offset().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "uplink_meas")) {
    uplink__meas().set_param(*mp_last);
    if (!uplink__meas().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "l1_info")) {
    l1__info().set_param(*mp_last);
    if (!l1__info().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "sysinfo_type")) {
    sysinfo__type().set_param(*mp_last);
    if (!sysinfo__type().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "paging_load")) {
    paging__load().set_param(*mp_last);
    if (!paging__load().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "paging_group")) {
    paging__group().set_param(*mp_last);
    if (!paging__group().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "chan_needed")) {
    chan__needed().set_param(*mp_last);
    if (!chan__needed().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cb_cmd_type")) {
    cb__cmd__type().set_param(*mp_last);
    if (!cb__cmd__type().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "smscb_message")) {
    smscb__message().set_param(*mp_last);
    if (!smscb__message().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cbch_load_info")) {
    cbch__load__info().set_param(*mp_last);
    if (!cbch__load__info().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "resource_info")) {
    resource__info().set_param(*mp_last);
    if (!resource__info().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "sacch_info")) {
    sacch__info().set_param(*mp_last);
    if (!sacch__info().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "starting_time")) {
    starting__time().set_param(*mp_last);
    if (!starting__time().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "encr_info")) {
    encr__info().set_param(*mp_last);
    if (!encr__info().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "smscb_chan_ind")) {
    smscb__chan__ind().set_param(*mp_last);
    if (!smscb__chan__ind().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "req_ref")) {
    req__ref().set_param(*mp_last);
    if (!req__ref().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "full_imm_ass_info")) {
    full__imm__ass__info().set_param(*mp_last);
    if (!full__imm__ass__info().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "ms_identity")) {
    ms__identity().set_param(*mp_last);
    if (!ms__identity().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "group_call_ref")) {
    group__call__ref().set_param(*mp_last);
    if (!group__call__ref().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "group_chan_desc")) {
    group__chan__desc().set_param(*mp_last);
    if (!group__chan__desc().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "nch_drx_info")) {
    nch__drx__info().set_param(*mp_last);
    if (!nch__drx__info().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "cmd_indicator")) {
    cmd__indicator().set_param(*mp_last);
    if (!cmd__indicator().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "uic")) {
    uic().set_param(*mp_last);
    if (!uic().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "ipa_conn_id")) {
    ipa__conn__id().set_param(*mp_last);
    if (!ipa__conn__id().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "ipa_local_port")) {
    ipa__local__port().set_param(*mp_last);
    if (!ipa__local__port().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "ipa_remote_port")) {
    ipa__remote__port().set_param(*mp_last);
    if (!ipa__remote__port().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "ipa_local_ip")) {
    ipa__local__ip().set_param(*mp_last);
    if (!ipa__local__ip().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "ipa_remote_ip")) {
    ipa__remote__ip().set_param(*mp_last);
    if (!ipa__remote__ip().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "ipa_rtp_pt")) {
    ipa__rtp__pt().set_param(*mp_last);
    if (!ipa__rtp__pt().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "ipa_rtp_pt2")) {
    ipa__rtp__pt2().set_param(*mp_last);
    if (!ipa__rtp__pt2().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "ipa_stats")) {
    ipa__stats().set_param(*mp_last);
    if (!ipa__stats().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "ipa_speech_mode")) {
    ipa__speech__mode().set_param(*mp_last);
    if (!ipa__speech__mode().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "ipa_rtp_csd_fmt")) {
    ipa__rtp__csd__fmt().set_param(*mp_last);
    if (!ipa__rtp__csd__fmt().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "osmo_training_sequence")) {
    osmo__training__sequence().set_param(*mp_last);
    if (!osmo__training__sequence().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "rep_acch_cap")) {
    rep__acch__cap().set_param(*mp_last);
    if (!rep__acch__cap().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "top_acch_cap")) {
    top__acch__cap().set_param(*mp_last);
    if (!top__acch__cap().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "osmux_cid")) {
    osmux__cid().set_param(*mp_last);
    if (!osmux__cid().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "other")) {
    other().set_param(*mp_last);
    if (!other().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @RSL_Types.RSL_IE_Body.", last_name);
}

void RSL__IE__Body::set_implicit_omit()
{
switch (union_selection) {
case ALT_chan__nr:
field_chan__nr->set_implicit_omit(); break;
case ALT_link__id:
field_link__id->set_implicit_omit(); break;
case ALT_l3__info:
field_l3__info->set_implicit_omit(); break;
case ALT_rlm__cause:
field_rlm__cause->set_implicit_omit(); break;
case ALT_release__mode:
field_release__mode->set_implicit_omit(); break;
case ALT_act__type:
field_act__type->set_implicit_omit(); break;
case ALT_chan__ident:
field_chan__ident->set_implicit_omit(); break;
case ALT_chan__mode:
field_chan__mode->set_implicit_omit(); break;
case ALT_handover__ref:
field_handover__ref->set_implicit_omit(); break;
case ALT_bs__power:
field_bs__power->set_implicit_omit(); break;
case ALT_bs__power__params:
field_bs__power__params->set_implicit_omit(); break;
case ALT_ms__power:
field_ms__power->set_implicit_omit(); break;
case ALT_ms__power__params:
field_ms__power__params->set_implicit_omit(); break;
case ALT_timing__adv:
field_timing__adv->set_implicit_omit(); break;
case ALT_multirate__cfg:
field_multirate__cfg->set_implicit_omit(); break;
case ALT_multirate__ctrl:
field_multirate__ctrl->set_implicit_omit(); break;
case ALT_msg__id:
field_msg__id->set_implicit_omit(); break;
case ALT_frame__nr:
field_frame__nr->set_implicit_omit(); break;
case ALT_cause:
field_cause->set_implicit_omit(); break;
case ALT_access__delay:
field_access__delay->set_implicit_omit(); break;
case ALT_rach__load:
field_rach__load->set_implicit_omit(); break;
case ALT_meas__res__nr:
field_meas__res__nr->set_implicit_omit(); break;
case ALT_ms__timing__offset:
field_ms__timing__offset->set_implicit_omit(); break;
case ALT_uplink__meas:
field_uplink__meas->set_implicit_omit(); break;
case ALT_l1__info:
field_l1__info->set_implicit_omit(); break;
case ALT_sysinfo__type:
field_sysinfo__type->set_implicit_omit(); break;
case ALT_paging__load:
field_paging__load->set_implicit_omit(); break;
case ALT_paging__group:
field_paging__group->set_implicit_omit(); break;
case ALT_chan__needed:
field_chan__needed->set_implicit_omit(); break;
case ALT_cb__cmd__type:
field_cb__cmd__type->set_implicit_omit(); break;
case ALT_smscb__message:
field_smscb__message->set_implicit_omit(); break;
case ALT_cbch__load__info:
field_cbch__load__info->set_implicit_omit(); break;
case ALT_resource__info:
field_resource__info->set_implicit_omit(); break;
case ALT_sacch__info:
field_sacch__info->set_implicit_omit(); break;
case ALT_starting__time:
field_starting__time->set_implicit_omit(); break;
case ALT_encr__info:
field_encr__info->set_implicit_omit(); break;
case ALT_smscb__chan__ind:
field_smscb__chan__ind->set_implicit_omit(); break;
case ALT_req__ref:
field_req__ref->set_implicit_omit(); break;
case ALT_full__imm__ass__info:
field_full__imm__ass__info->set_implicit_omit(); break;
case ALT_ms__identity:
field_ms__identity->set_implicit_omit(); break;
case ALT_group__call__ref:
field_group__call__ref->set_implicit_omit(); break;
case ALT_group__chan__desc:
field_group__chan__desc->set_implicit_omit(); break;
case ALT_nch__drx__info:
field_nch__drx__info->set_implicit_omit(); break;
case ALT_cmd__indicator:
field_cmd__indicator->set_implicit_omit(); break;
case ALT_uic:
field_uic->set_implicit_omit(); break;
case ALT_ipa__conn__id:
field_ipa__conn__id->set_implicit_omit(); break;
case ALT_ipa__local__port:
field_ipa__local__port->set_implicit_omit(); break;
case ALT_ipa__remote__port:
field_ipa__remote__port->set_implicit_omit(); break;
case ALT_ipa__local__ip:
field_ipa__local__ip->set_implicit_omit(); break;
case ALT_ipa__remote__ip:
field_ipa__remote__ip->set_implicit_omit(); break;
case ALT_ipa__rtp__pt:
field_ipa__rtp__pt->set_implicit_omit(); break;
case ALT_ipa__rtp__pt2:
field_ipa__rtp__pt2->set_implicit_omit(); break;
case ALT_ipa__stats:
field_ipa__stats->set_implicit_omit(); break;
case ALT_ipa__speech__mode:
field_ipa__speech__mode->set_implicit_omit(); break;
case ALT_ipa__rtp__csd__fmt:
field_ipa__rtp__csd__fmt->set_implicit_omit(); break;
case ALT_osmo__training__sequence:
field_osmo__training__sequence->set_implicit_omit(); break;
case ALT_rep__acch__cap:
field_rep__acch__cap->set_implicit_omit(); break;
case ALT_top__acch__cap:
field_top__acch__cap->set_implicit_omit(); break;
case ALT_osmux__cid:
field_osmux__cid->set_implicit_omit(); break;
case ALT_other:
field_other->set_implicit_omit(); break;
default: break;
}
}

void RSL__IE__Body::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_chan__nr:
field_chan__nr->encode_text(text_buf);
break;
case ALT_link__id:
field_link__id->encode_text(text_buf);
break;
case ALT_l3__info:
field_l3__info->encode_text(text_buf);
break;
case ALT_rlm__cause:
field_rlm__cause->encode_text(text_buf);
break;
case ALT_release__mode:
field_release__mode->encode_text(text_buf);
break;
case ALT_act__type:
field_act__type->encode_text(text_buf);
break;
case ALT_chan__ident:
field_chan__ident->encode_text(text_buf);
break;
case ALT_chan__mode:
field_chan__mode->encode_text(text_buf);
break;
case ALT_handover__ref:
field_handover__ref->encode_text(text_buf);
break;
case ALT_bs__power:
field_bs__power->encode_text(text_buf);
break;
case ALT_bs__power__params:
field_bs__power__params->encode_text(text_buf);
break;
case ALT_ms__power:
field_ms__power->encode_text(text_buf);
break;
case ALT_ms__power__params:
field_ms__power__params->encode_text(text_buf);
break;
case ALT_timing__adv:
field_timing__adv->encode_text(text_buf);
break;
case ALT_multirate__cfg:
field_multirate__cfg->encode_text(text_buf);
break;
case ALT_multirate__ctrl:
field_multirate__ctrl->encode_text(text_buf);
break;
case ALT_msg__id:
field_msg__id->encode_text(text_buf);
break;
case ALT_frame__nr:
field_frame__nr->encode_text(text_buf);
break;
case ALT_cause:
field_cause->encode_text(text_buf);
break;
case ALT_access__delay:
field_access__delay->encode_text(text_buf);
break;
case ALT_rach__load:
field_rach__load->encode_text(text_buf);
break;
case ALT_meas__res__nr:
field_meas__res__nr->encode_text(text_buf);
break;
case ALT_ms__timing__offset:
field_ms__timing__offset->encode_text(text_buf);
break;
case ALT_uplink__meas:
field_uplink__meas->encode_text(text_buf);
break;
case ALT_l1__info:
field_l1__info->encode_text(text_buf);
break;
case ALT_sysinfo__type:
field_sysinfo__type->encode_text(text_buf);
break;
case ALT_paging__load:
field_paging__load->encode_text(text_buf);
break;
case ALT_paging__group:
field_paging__group->encode_text(text_buf);
break;
case ALT_chan__needed:
field_chan__needed->encode_text(text_buf);
break;
case ALT_cb__cmd__type:
field_cb__cmd__type->encode_text(text_buf);
break;
case ALT_smscb__message:
field_smscb__message->encode_text(text_buf);
break;
case ALT_cbch__load__info:
field_cbch__load__info->encode_text(text_buf);
break;
case ALT_resource__info:
field_resource__info->encode_text(text_buf);
break;
case ALT_sacch__info:
field_sacch__info->encode_text(text_buf);
break;
case ALT_starting__time:
field_starting__time->encode_text(text_buf);
break;
case ALT_encr__info:
field_encr__info->encode_text(text_buf);
break;
case ALT_smscb__chan__ind:
field_smscb__chan__ind->encode_text(text_buf);
break;
case ALT_req__ref:
field_req__ref->encode_text(text_buf);
break;
case ALT_full__imm__ass__info:
field_full__imm__ass__info->encode_text(text_buf);
break;
case ALT_ms__identity:
field_ms__identity->encode_text(text_buf);
break;
case ALT_group__call__ref:
field_group__call__ref->encode_text(text_buf);
break;
case ALT_group__chan__desc:
field_group__chan__desc->encode_text(text_buf);
break;
case ALT_nch__drx__info:
field_nch__drx__info->encode_text(text_buf);
break;
case ALT_cmd__indicator:
field_cmd__indicator->encode_text(text_buf);
break;
case ALT_uic:
field_uic->encode_text(text_buf);
break;
case ALT_ipa__conn__id:
field_ipa__conn__id->encode_text(text_buf);
break;
case ALT_ipa__local__port:
field_ipa__local__port->encode_text(text_buf);
break;
case ALT_ipa__remote__port:
field_ipa__remote__port->encode_text(text_buf);
break;
case ALT_ipa__local__ip:
field_ipa__local__ip->encode_text(text_buf);
break;
case ALT_ipa__remote__ip:
field_ipa__remote__ip->encode_text(text_buf);
break;
case ALT_ipa__rtp__pt:
field_ipa__rtp__pt->encode_text(text_buf);
break;
case ALT_ipa__rtp__pt2:
field_ipa__rtp__pt2->encode_text(text_buf);
break;
case ALT_ipa__stats:
field_ipa__stats->encode_text(text_buf);
break;
case ALT_ipa__speech__mode:
field_ipa__speech__mode->encode_text(text_buf);
break;
case ALT_ipa__rtp__csd__fmt:
field_ipa__rtp__csd__fmt->encode_text(text_buf);
break;
case ALT_osmo__training__sequence:
field_osmo__training__sequence->encode_text(text_buf);
break;
case ALT_rep__acch__cap:
field_rep__acch__cap->encode_text(text_buf);
break;
case ALT_top__acch__cap:
field_top__acch__cap->encode_text(text_buf);
break;
case ALT_osmux__cid:
field_osmux__cid->encode_text(text_buf);
break;
case ALT_other:
field_other->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @RSL_Types.RSL_IE_Body.");
}
}

void RSL__IE__Body::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_chan__nr:
chan__nr().decode_text(text_buf);
break;
case ALT_link__id:
link__id().decode_text(text_buf);
break;
case ALT_l3__info:
l3__info().decode_text(text_buf);
break;
case ALT_rlm__cause:
rlm__cause().decode_text(text_buf);
break;
case ALT_release__mode:
release__mode().decode_text(text_buf);
break;
case ALT_act__type:
act__type().decode_text(text_buf);
break;
case ALT_chan__ident:
chan__ident().decode_text(text_buf);
break;
case ALT_chan__mode:
chan__mode().decode_text(text_buf);
break;
case ALT_handover__ref:
handover__ref().decode_text(text_buf);
break;
case ALT_bs__power:
bs__power().decode_text(text_buf);
break;
case ALT_bs__power__params:
bs__power__params().decode_text(text_buf);
break;
case ALT_ms__power:
ms__power().decode_text(text_buf);
break;
case ALT_ms__power__params:
ms__power__params().decode_text(text_buf);
break;
case ALT_timing__adv:
timing__adv().decode_text(text_buf);
break;
case ALT_multirate__cfg:
multirate__cfg().decode_text(text_buf);
break;
case ALT_multirate__ctrl:
multirate__ctrl().decode_text(text_buf);
break;
case ALT_msg__id:
msg__id().decode_text(text_buf);
break;
case ALT_frame__nr:
frame__nr().decode_text(text_buf);
break;
case ALT_cause:
cause().decode_text(text_buf);
break;
case ALT_access__delay:
access__delay().decode_text(text_buf);
break;
case ALT_rach__load:
rach__load().decode_text(text_buf);
break;
case ALT_meas__res__nr:
meas__res__nr().decode_text(text_buf);
break;
case ALT_ms__timing__offset:
ms__timing__offset().decode_text(text_buf);
break;
case ALT_uplink__meas:
uplink__meas().decode_text(text_buf);
break;
case ALT_l1__info:
l1__info().decode_text(text_buf);
break;
case ALT_sysinfo__type:
sysinfo__type().decode_text(text_buf);
break;
case ALT_paging__load:
paging__load().decode_text(text_buf);
break;
case ALT_paging__group:
paging__group().decode_text(text_buf);
break;
case ALT_chan__needed:
chan__needed().decode_text(text_buf);
break;
case ALT_cb__cmd__type:
cb__cmd__type().decode_text(text_buf);
break;
case ALT_smscb__message:
smscb__message().decode_text(text_buf);
break;
case ALT_cbch__load__info:
cbch__load__info().decode_text(text_buf);
break;
case ALT_resource__info:
resource__info().decode_text(text_buf);
break;
case ALT_sacch__info:
sacch__info().decode_text(text_buf);
break;
case ALT_starting__time:
starting__time().decode_text(text_buf);
break;
case ALT_encr__info:
encr__info().decode_text(text_buf);
break;
case ALT_smscb__chan__ind:
smscb__chan__ind().decode_text(text_buf);
break;
case ALT_req__ref:
req__ref().decode_text(text_buf);
break;
case ALT_full__imm__ass__info:
full__imm__ass__info().decode_text(text_buf);
break;
case ALT_ms__identity:
ms__identity().decode_text(text_buf);
break;
case ALT_group__call__ref:
group__call__ref().decode_text(text_buf);
break;
case ALT_group__chan__desc:
group__chan__desc().decode_text(text_buf);
break;
case ALT_nch__drx__info:
nch__drx__info().decode_text(text_buf);
break;
case ALT_cmd__indicator:
cmd__indicator().decode_text(text_buf);
break;
case ALT_uic:
uic().decode_text(text_buf);
break;
case ALT_ipa__conn__id:
ipa__conn__id().decode_text(text_buf);
break;
case ALT_ipa__local__port:
ipa__local__port().decode_text(text_buf);
break;
case ALT_ipa__remote__port:
ipa__remote__port().decode_text(text_buf);
break;
case ALT_ipa__local__ip:
ipa__local__ip().decode_text(text_buf);
break;
case ALT_ipa__remote__ip:
ipa__remote__ip().decode_text(text_buf);
break;
case ALT_ipa__rtp__pt:
ipa__rtp__pt().decode_text(text_buf);
break;
case ALT_ipa__rtp__pt2:
ipa__rtp__pt2().decode_text(text_buf);
break;
case ALT_ipa__stats:
ipa__stats().decode_text(text_buf);
break;
case ALT_ipa__speech__mode:
ipa__speech__mode().decode_text(text_buf);
break;
case ALT_ipa__rtp__csd__fmt:
ipa__rtp__csd__fmt().decode_text(text_buf);
break;
case ALT_osmo__training__sequence:
osmo__training__sequence().decode_text(text_buf);
break;
case ALT_rep__acch__cap:
rep__acch__cap().decode_text(text_buf);
break;
case ALT_top__acch__cap:
top__acch__cap().decode_text(text_buf);
break;
case ALT_osmux__cid:
osmux__cid().decode_text(text_buf);
break;
case ALT_other:
other().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @RSL_Types.RSL_IE_Body.");
}
}

void RSL__IE__Body::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RSL__IE__Body::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RSL__IE__Body::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, RSL__IE__Body_chan__nr_descr_.raw->forceomit);
      decoded_length = chan__nr().RAW_decode(RSL__IE__Body_chan__nr_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, RSL__IE__Body_link__id_descr_.raw->forceomit);
      decoded_length = link__id().RAW_decode(RSL__IE__Body_link__id_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 2: {
      RAW_Force_Omit field_force_omit(2, force_omit, RSL__IE__Body_l3__info_descr_.raw->forceomit);
      decoded_length = l3__info().RAW_decode(RSL__IE__Body_l3__info_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 3: {
      RAW_Force_Omit field_force_omit(3, force_omit, RSL__IE__Body_rlm__cause_descr_.raw->forceomit);
      decoded_length = rlm__cause().RAW_decode(RSL__IE__Body_rlm__cause_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 4: {
      RAW_Force_Omit field_force_omit(4, force_omit, RSL__IE__Body_release__mode_descr_.raw->forceomit);
      decoded_length = release__mode().RAW_decode(RSL__IE__Body_release__mode_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 5: {
      RAW_Force_Omit field_force_omit(5, force_omit, RSL__IE__Body_act__type_descr_.raw->forceomit);
      decoded_length = act__type().RAW_decode(RSL__IE__Body_act__type_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 6: {
      RAW_Force_Omit field_force_omit(6, force_omit, RSL__IE__Body_chan__ident_descr_.raw->forceomit);
      decoded_length = chan__ident().RAW_decode(RSL__IE__Body_chan__ident_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 7: {
      RAW_Force_Omit field_force_omit(7, force_omit, RSL__IE__Body_chan__mode_descr_.raw->forceomit);
      decoded_length = chan__mode().RAW_decode(RSL__IE__Body_chan__mode_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 8: {
      RAW_Force_Omit field_force_omit(8, force_omit, RSL__IE__Body_handover__ref_descr_.raw->forceomit);
      decoded_length = handover__ref().RAW_decode(RSL__IE__Body_handover__ref_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 9: {
      RAW_Force_Omit field_force_omit(9, force_omit, RSL__IE__Body_bs__power_descr_.raw->forceomit);
      decoded_length = bs__power().RAW_decode(RSL__IE__Body_bs__power_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 10: {
      RAW_Force_Omit field_force_omit(10, force_omit, RSL__IE__Body_bs__power__params_descr_.raw->forceomit);
      decoded_length = bs__power__params().RAW_decode(RSL__IE__Body_bs__power__params_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 11: {
      RAW_Force_Omit field_force_omit(11, force_omit, RSL__IE__Body_ms__power_descr_.raw->forceomit);
      decoded_length = ms__power().RAW_decode(RSL__IE__Body_ms__power_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 12: {
      RAW_Force_Omit field_force_omit(12, force_omit, RSL__IE__Body_ms__power__params_descr_.raw->forceomit);
      decoded_length = ms__power__params().RAW_decode(RSL__IE__Body_ms__power__params_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 13: {
      RAW_Force_Omit field_force_omit(13, force_omit, RSL__IE__Body_timing__adv_descr_.raw->forceomit);
      decoded_length = timing__adv().RAW_decode(RSL__IE__Body_timing__adv_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 14: {
      RAW_Force_Omit field_force_omit(14, force_omit, RSL__IE__Body_multirate__cfg_descr_.raw->forceomit);
      decoded_length = multirate__cfg().RAW_decode(RSL__IE__Body_multirate__cfg_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 15: {
      RAW_Force_Omit field_force_omit(15, force_omit, RSL__IE__Body_multirate__ctrl_descr_.raw->forceomit);
      decoded_length = multirate__ctrl().RAW_decode(RSL__IE__Body_multirate__ctrl_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 16: {
      RAW_Force_Omit field_force_omit(16, force_omit, RSL__IE__Body_msg__id_descr_.raw->forceomit);
      decoded_length = msg__id().RAW_decode(RSL__IE__Body_msg__id_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 17: {
      RAW_Force_Omit field_force_omit(17, force_omit, RSL__IE__Body_frame__nr_descr_.raw->forceomit);
      decoded_length = frame__nr().RAW_decode(RSL__IE__Body_frame__nr_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 18: {
      RAW_Force_Omit field_force_omit(18, force_omit, RSL__IE__Body_cause_descr_.raw->forceomit);
      decoded_length = cause().RAW_decode(RSL__IE__Body_cause_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 19: {
      RAW_Force_Omit field_force_omit(19, force_omit, RSL__IE__Body_access__delay_descr_.raw->forceomit);
      decoded_length = access__delay().RAW_decode(RSL__IE__Body_access__delay_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 20: {
      RAW_Force_Omit field_force_omit(20, force_omit, RSL__IE__Body_rach__load_descr_.raw->forceomit);
      decoded_length = rach__load().RAW_decode(RSL__IE__Body_rach__load_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 21: {
      RAW_Force_Omit field_force_omit(21, force_omit, RSL__IE__Body_meas__res__nr_descr_.raw->forceomit);
      decoded_length = meas__res__nr().RAW_decode(RSL__IE__Body_meas__res__nr_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 22: {
      RAW_Force_Omit field_force_omit(22, force_omit, RSL__IE__Body_ms__timing__offset_descr_.raw->forceomit);
      decoded_length = ms__timing__offset().RAW_decode(RSL__IE__Body_ms__timing__offset_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 23: {
      RAW_Force_Omit field_force_omit(23, force_omit, RSL__IE__Body_uplink__meas_descr_.raw->forceomit);
      decoded_length = uplink__meas().RAW_decode(RSL__IE__Body_uplink__meas_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 24: {
      RAW_Force_Omit field_force_omit(24, force_omit, RSL__IE__Body_l1__info_descr_.raw->forceomit);
      decoded_length = l1__info().RAW_decode(RSL__IE__Body_l1__info_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 25: {
      RAW_Force_Omit field_force_omit(25, force_omit, RSL__IE__Body_sysinfo__type_descr_.raw->forceomit);
      decoded_length = sysinfo__type().RAW_decode(RSL__IE__Body_sysinfo__type_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 26: {
      RAW_Force_Omit field_force_omit(26, force_omit, RSL__IE__Body_paging__load_descr_.raw->forceomit);
      decoded_length = paging__load().RAW_decode(RSL__IE__Body_paging__load_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 27: {
      RAW_Force_Omit field_force_omit(27, force_omit, RSL__IE__Body_paging__group_descr_.raw->forceomit);
      decoded_length = paging__group().RAW_decode(RSL__IE__Body_paging__group_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 28: {
      RAW_Force_Omit field_force_omit(28, force_omit, RSL__IE__Body_chan__needed_descr_.raw->forceomit);
      decoded_length = chan__needed().RAW_decode(RSL__IE__Body_chan__needed_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 29: {
      RAW_Force_Omit field_force_omit(29, force_omit, RSL__IE__Body_cb__cmd__type_descr_.raw->forceomit);
      decoded_length = cb__cmd__type().RAW_decode(RSL__IE__Body_cb__cmd__type_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 30: {
      RAW_Force_Omit field_force_omit(30, force_omit, RSL__IE__Body_smscb__message_descr_.raw->forceomit);
      decoded_length = smscb__message().RAW_decode(RSL__IE__Body_smscb__message_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 31: {
      RAW_Force_Omit field_force_omit(31, force_omit, RSL__IE__Body_cbch__load__info_descr_.raw->forceomit);
      decoded_length = cbch__load__info().RAW_decode(RSL__IE__Body_cbch__load__info_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 32: {
      RAW_Force_Omit field_force_omit(32, force_omit, RSL__IE__Body_resource__info_descr_.raw->forceomit);
      decoded_length = resource__info().RAW_decode(RSL__IE__Body_resource__info_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 33: {
      RAW_Force_Omit field_force_omit(33, force_omit, RSL__IE__Body_sacch__info_descr_.raw->forceomit);
      decoded_length = sacch__info().RAW_decode(RSL__IE__Body_sacch__info_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 34: {
      RAW_Force_Omit field_force_omit(34, force_omit, RSL__IE__Body_starting__time_descr_.raw->forceomit);
      decoded_length = starting__time().RAW_decode(RSL__IE__Body_starting__time_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 35: {
      RAW_Force_Omit field_force_omit(35, force_omit, RSL__IE__Body_encr__info_descr_.raw->forceomit);
      decoded_length = encr__info().RAW_decode(RSL__IE__Body_encr__info_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 36: {
      RAW_Force_Omit field_force_omit(36, force_omit, RSL__IE__Body_smscb__chan__ind_descr_.raw->forceomit);
      decoded_length = smscb__chan__ind().RAW_decode(RSL__IE__Body_smscb__chan__ind_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 37: {
      RAW_Force_Omit field_force_omit(37, force_omit, RSL__IE__Body_req__ref_descr_.raw->forceomit);
      decoded_length = req__ref().RAW_decode(RSL__IE__Body_req__ref_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 38: {
      RAW_Force_Omit field_force_omit(38, force_omit, RSL__IE__Body_full__imm__ass__info_descr_.raw->forceomit);
      decoded_length = full__imm__ass__info().RAW_decode(RSL__IE__Body_full__imm__ass__info_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 39: {
      RAW_Force_Omit field_force_omit(39, force_omit, RSL__IE__Body_ms__identity_descr_.raw->forceomit);
      decoded_length = ms__identity().RAW_decode(RSL__IE__Body_ms__identity_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 40: {
      RAW_Force_Omit field_force_omit(40, force_omit, RSL__IE__Body_group__call__ref_descr_.raw->forceomit);
      decoded_length = group__call__ref().RAW_decode(RSL__IE__Body_group__call__ref_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 41: {
      RAW_Force_Omit field_force_omit(41, force_omit, RSL__IE__Body_group__chan__desc_descr_.raw->forceomit);
      decoded_length = group__chan__desc().RAW_decode(RSL__IE__Body_group__chan__desc_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 42: {
      RAW_Force_Omit field_force_omit(42, force_omit, RSL__IE__Body_nch__drx__info_descr_.raw->forceomit);
      decoded_length = nch__drx__info().RAW_decode(RSL__IE__Body_nch__drx__info_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 43: {
      RAW_Force_Omit field_force_omit(43, force_omit, RSL__IE__Body_cmd__indicator_descr_.raw->forceomit);
      decoded_length = cmd__indicator().RAW_decode(RSL__IE__Body_cmd__indicator_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 44: {
      RAW_Force_Omit field_force_omit(44, force_omit, RSL__IE__Body_uic_descr_.raw->forceomit);
      decoded_length = uic().RAW_decode(RSL__IE__Body_uic_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 45: {
      RAW_Force_Omit field_force_omit(45, force_omit, RSL__IE__Body_ipa__conn__id_descr_.raw->forceomit);
      decoded_length = ipa__conn__id().RAW_decode(RSL__IE__Body_ipa__conn__id_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 46: {
      RAW_Force_Omit field_force_omit(46, force_omit, RSL__IE__Body_ipa__local__port_descr_.raw->forceomit);
      decoded_length = ipa__local__port().RAW_decode(RSL__IE__Body_ipa__local__port_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 47: {
      RAW_Force_Omit field_force_omit(47, force_omit, RSL__IE__Body_ipa__remote__port_descr_.raw->forceomit);
      decoded_length = ipa__remote__port().RAW_decode(RSL__IE__Body_ipa__remote__port_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 48: {
      RAW_Force_Omit field_force_omit(48, force_omit, RSL__IE__Body_ipa__local__ip_descr_.raw->forceomit);
      decoded_length = ipa__local__ip().RAW_decode(RSL__IE__Body_ipa__local__ip_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 49: {
      RAW_Force_Omit field_force_omit(49, force_omit, RSL__IE__Body_ipa__remote__ip_descr_.raw->forceomit);
      decoded_length = ipa__remote__ip().RAW_decode(RSL__IE__Body_ipa__remote__ip_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 50: {
      RAW_Force_Omit field_force_omit(50, force_omit, RSL__IE__Body_ipa__rtp__pt_descr_.raw->forceomit);
      decoded_length = ipa__rtp__pt().RAW_decode(RSL__IE__Body_ipa__rtp__pt_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 51: {
      RAW_Force_Omit field_force_omit(51, force_omit, RSL__IE__Body_ipa__rtp__pt2_descr_.raw->forceomit);
      decoded_length = ipa__rtp__pt2().RAW_decode(RSL__IE__Body_ipa__rtp__pt2_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 52: {
      RAW_Force_Omit field_force_omit(52, force_omit, RSL__IE__Body_ipa__stats_descr_.raw->forceomit);
      decoded_length = ipa__stats().RAW_decode(RSL__IE__Body_ipa__stats_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 53: {
      RAW_Force_Omit field_force_omit(53, force_omit, RSL__IE__Body_ipa__speech__mode_descr_.raw->forceomit);
      decoded_length = ipa__speech__mode().RAW_decode(RSL__IE__Body_ipa__speech__mode_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 54: {
      RAW_Force_Omit field_force_omit(54, force_omit, RSL__IE__Body_ipa__rtp__csd__fmt_descr_.raw->forceomit);
      decoded_length = ipa__rtp__csd__fmt().RAW_decode(RSL__IE__Body_ipa__rtp__csd__fmt_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 55: {
      RAW_Force_Omit field_force_omit(55, force_omit, RSL__IE__Body_osmo__training__sequence_descr_.raw->forceomit);
      decoded_length = osmo__training__sequence().RAW_decode(RSL__IE__Body_osmo__training__sequence_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 56: {
      RAW_Force_Omit field_force_omit(56, force_omit, RSL__IE__Body_rep__acch__cap_descr_.raw->forceomit);
      decoded_length = rep__acch__cap().RAW_decode(RSL__IE__Body_rep__acch__cap_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 57: {
      RAW_Force_Omit field_force_omit(57, force_omit, RSL__IE__Body_top__acch__cap_descr_.raw->forceomit);
      decoded_length = top__acch__cap().RAW_decode(RSL__IE__Body_top__acch__cap_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 58: {
      RAW_Force_Omit field_force_omit(58, force_omit, RSL__IE__Body_osmux__cid_descr_.raw->forceomit);
      decoded_length = osmux__cid().RAW_decode(RSL__IE__Body_osmux__cid_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 59: {
      RAW_Force_Omit field_force_omit(59, force_omit, RSL__IE__Body_other_descr_.raw->forceomit);
      decoded_length = other().RAW_decode(RSL__IE__Body_other_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_0_force_omit(0, force_omit, RSL__IE__Body_chan__nr_descr_.raw->forceomit);
      decoded_length = chan__nr().RAW_decode(RSL__IE__Body_chan__nr_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_0_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_1_force_omit(1, force_omit, RSL__IE__Body_link__id_descr_.raw->forceomit);
      decoded_length = link__id().RAW_decode(RSL__IE__Body_link__id_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_1_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_2_force_omit(2, force_omit, RSL__IE__Body_l3__info_descr_.raw->forceomit);
      decoded_length = l3__info().RAW_decode(RSL__IE__Body_l3__info_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_2_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_3_force_omit(3, force_omit, RSL__IE__Body_rlm__cause_descr_.raw->forceomit);
      decoded_length = rlm__cause().RAW_decode(RSL__IE__Body_rlm__cause_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_3_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_4_force_omit(4, force_omit, RSL__IE__Body_release__mode_descr_.raw->forceomit);
      decoded_length = release__mode().RAW_decode(RSL__IE__Body_release__mode_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_4_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_5_force_omit(5, force_omit, RSL__IE__Body_act__type_descr_.raw->forceomit);
      decoded_length = act__type().RAW_decode(RSL__IE__Body_act__type_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_5_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_6_force_omit(6, force_omit, RSL__IE__Body_chan__ident_descr_.raw->forceomit);
      decoded_length = chan__ident().RAW_decode(RSL__IE__Body_chan__ident_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_6_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_7_force_omit(7, force_omit, RSL__IE__Body_chan__mode_descr_.raw->forceomit);
      decoded_length = chan__mode().RAW_decode(RSL__IE__Body_chan__mode_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_7_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_8_force_omit(8, force_omit, RSL__IE__Body_handover__ref_descr_.raw->forceomit);
      decoded_length = handover__ref().RAW_decode(RSL__IE__Body_handover__ref_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_8_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_9_force_omit(9, force_omit, RSL__IE__Body_bs__power_descr_.raw->forceomit);
      decoded_length = bs__power().RAW_decode(RSL__IE__Body_bs__power_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_9_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_10_force_omit(10, force_omit, RSL__IE__Body_bs__power__params_descr_.raw->forceomit);
      decoded_length = bs__power__params().RAW_decode(RSL__IE__Body_bs__power__params_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_10_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_11_force_omit(11, force_omit, RSL__IE__Body_ms__power_descr_.raw->forceomit);
      decoded_length = ms__power().RAW_decode(RSL__IE__Body_ms__power_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_11_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_12_force_omit(12, force_omit, RSL__IE__Body_ms__power__params_descr_.raw->forceomit);
      decoded_length = ms__power__params().RAW_decode(RSL__IE__Body_ms__power__params_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_12_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_13_force_omit(13, force_omit, RSL__IE__Body_timing__adv_descr_.raw->forceomit);
      decoded_length = timing__adv().RAW_decode(RSL__IE__Body_timing__adv_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_13_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_14_force_omit(14, force_omit, RSL__IE__Body_multirate__cfg_descr_.raw->forceomit);
      decoded_length = multirate__cfg().RAW_decode(RSL__IE__Body_multirate__cfg_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_14_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_15_force_omit(15, force_omit, RSL__IE__Body_multirate__ctrl_descr_.raw->forceomit);
      decoded_length = multirate__ctrl().RAW_decode(RSL__IE__Body_multirate__ctrl_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_15_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_16_force_omit(16, force_omit, RSL__IE__Body_msg__id_descr_.raw->forceomit);
      decoded_length = msg__id().RAW_decode(RSL__IE__Body_msg__id_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_16_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_17_force_omit(17, force_omit, RSL__IE__Body_frame__nr_descr_.raw->forceomit);
      decoded_length = frame__nr().RAW_decode(RSL__IE__Body_frame__nr_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_17_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_18_force_omit(18, force_omit, RSL__IE__Body_cause_descr_.raw->forceomit);
      decoded_length = cause().RAW_decode(RSL__IE__Body_cause_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_18_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_19_force_omit(19, force_omit, RSL__IE__Body_access__delay_descr_.raw->forceomit);
      decoded_length = access__delay().RAW_decode(RSL__IE__Body_access__delay_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_19_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_20_force_omit(20, force_omit, RSL__IE__Body_rach__load_descr_.raw->forceomit);
      decoded_length = rach__load().RAW_decode(RSL__IE__Body_rach__load_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_20_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_21_force_omit(21, force_omit, RSL__IE__Body_meas__res__nr_descr_.raw->forceomit);
      decoded_length = meas__res__nr().RAW_decode(RSL__IE__Body_meas__res__nr_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_21_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_22_force_omit(22, force_omit, RSL__IE__Body_ms__timing__offset_descr_.raw->forceomit);
      decoded_length = ms__timing__offset().RAW_decode(RSL__IE__Body_ms__timing__offset_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_22_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_23_force_omit(23, force_omit, RSL__IE__Body_uplink__meas_descr_.raw->forceomit);
      decoded_length = uplink__meas().RAW_decode(RSL__IE__Body_uplink__meas_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_23_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_24_force_omit(24, force_omit, RSL__IE__Body_l1__info_descr_.raw->forceomit);
      decoded_length = l1__info().RAW_decode(RSL__IE__Body_l1__info_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_24_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_25_force_omit(25, force_omit, RSL__IE__Body_sysinfo__type_descr_.raw->forceomit);
      decoded_length = sysinfo__type().RAW_decode(RSL__IE__Body_sysinfo__type_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_25_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_26_force_omit(26, force_omit, RSL__IE__Body_paging__load_descr_.raw->forceomit);
      decoded_length = paging__load().RAW_decode(RSL__IE__Body_paging__load_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_26_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_27_force_omit(27, force_omit, RSL__IE__Body_paging__group_descr_.raw->forceomit);
      decoded_length = paging__group().RAW_decode(RSL__IE__Body_paging__group_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_27_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_28_force_omit(28, force_omit, RSL__IE__Body_chan__needed_descr_.raw->forceomit);
      decoded_length = chan__needed().RAW_decode(RSL__IE__Body_chan__needed_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_28_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_29_force_omit(29, force_omit, RSL__IE__Body_cb__cmd__type_descr_.raw->forceomit);
      decoded_length = cb__cmd__type().RAW_decode(RSL__IE__Body_cb__cmd__type_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_29_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_30_force_omit(30, force_omit, RSL__IE__Body_smscb__message_descr_.raw->forceomit);
      decoded_length = smscb__message().RAW_decode(RSL__IE__Body_smscb__message_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_30_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_31_force_omit(31, force_omit, RSL__IE__Body_cbch__load__info_descr_.raw->forceomit);
      decoded_length = cbch__load__info().RAW_decode(RSL__IE__Body_cbch__load__info_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_31_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_32_force_omit(32, force_omit, RSL__IE__Body_resource__info_descr_.raw->forceomit);
      decoded_length = resource__info().RAW_decode(RSL__IE__Body_resource__info_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_32_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_33_force_omit(33, force_omit, RSL__IE__Body_sacch__info_descr_.raw->forceomit);
      decoded_length = sacch__info().RAW_decode(RSL__IE__Body_sacch__info_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_33_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_34_force_omit(34, force_omit, RSL__IE__Body_starting__time_descr_.raw->forceomit);
      decoded_length = starting__time().RAW_decode(RSL__IE__Body_starting__time_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_34_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_35_force_omit(35, force_omit, RSL__IE__Body_encr__info_descr_.raw->forceomit);
      decoded_length = encr__info().RAW_decode(RSL__IE__Body_encr__info_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_35_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_36_force_omit(36, force_omit, RSL__IE__Body_smscb__chan__ind_descr_.raw->forceomit);
      decoded_length = smscb__chan__ind().RAW_decode(RSL__IE__Body_smscb__chan__ind_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_36_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_37_force_omit(37, force_omit, RSL__IE__Body_req__ref_descr_.raw->forceomit);
      decoded_length = req__ref().RAW_decode(RSL__IE__Body_req__ref_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_37_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_38_force_omit(38, force_omit, RSL__IE__Body_full__imm__ass__info_descr_.raw->forceomit);
      decoded_length = full__imm__ass__info().RAW_decode(RSL__IE__Body_full__imm__ass__info_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_38_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_39_force_omit(39, force_omit, RSL__IE__Body_ms__identity_descr_.raw->forceomit);
      decoded_length = ms__identity().RAW_decode(RSL__IE__Body_ms__identity_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_39_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_40_force_omit(40, force_omit, RSL__IE__Body_group__call__ref_descr_.raw->forceomit);
      decoded_length = group__call__ref().RAW_decode(RSL__IE__Body_group__call__ref_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_40_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_41_force_omit(41, force_omit, RSL__IE__Body_group__chan__desc_descr_.raw->forceomit);
      decoded_length = group__chan__desc().RAW_decode(RSL__IE__Body_group__chan__desc_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_41_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_42_force_omit(42, force_omit, RSL__IE__Body_nch__drx__info_descr_.raw->forceomit);
      decoded_length = nch__drx__info().RAW_decode(RSL__IE__Body_nch__drx__info_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_42_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_43_force_omit(43, force_omit, RSL__IE__Body_cmd__indicator_descr_.raw->forceomit);
      decoded_length = cmd__indicator().RAW_decode(RSL__IE__Body_cmd__indicator_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_43_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_44_force_omit(44, force_omit, RSL__IE__Body_uic_descr_.raw->forceomit);
      decoded_length = uic().RAW_decode(RSL__IE__Body_uic_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_44_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_45_force_omit(45, force_omit, RSL__IE__Body_ipa__conn__id_descr_.raw->forceomit);
      decoded_length = ipa__conn__id().RAW_decode(RSL__IE__Body_ipa__conn__id_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_45_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_46_force_omit(46, force_omit, RSL__IE__Body_ipa__local__port_descr_.raw->forceomit);
      decoded_length = ipa__local__port().RAW_decode(RSL__IE__Body_ipa__local__port_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_46_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_47_force_omit(47, force_omit, RSL__IE__Body_ipa__remote__port_descr_.raw->forceomit);
      decoded_length = ipa__remote__port().RAW_decode(RSL__IE__Body_ipa__remote__port_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_47_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_48_force_omit(48, force_omit, RSL__IE__Body_ipa__local__ip_descr_.raw->forceomit);
      decoded_length = ipa__local__ip().RAW_decode(RSL__IE__Body_ipa__local__ip_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_48_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_49_force_omit(49, force_omit, RSL__IE__Body_ipa__remote__ip_descr_.raw->forceomit);
      decoded_length = ipa__remote__ip().RAW_decode(RSL__IE__Body_ipa__remote__ip_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_49_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_50_force_omit(50, force_omit, RSL__IE__Body_ipa__rtp__pt_descr_.raw->forceomit);
      decoded_length = ipa__rtp__pt().RAW_decode(RSL__IE__Body_ipa__rtp__pt_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_50_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_51_force_omit(51, force_omit, RSL__IE__Body_ipa__rtp__pt2_descr_.raw->forceomit);
      decoded_length = ipa__rtp__pt2().RAW_decode(RSL__IE__Body_ipa__rtp__pt2_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_51_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_52_force_omit(52, force_omit, RSL__IE__Body_ipa__stats_descr_.raw->forceomit);
      decoded_length = ipa__stats().RAW_decode(RSL__IE__Body_ipa__stats_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_52_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_53_force_omit(53, force_omit, RSL__IE__Body_ipa__speech__mode_descr_.raw->forceomit);
      decoded_length = ipa__speech__mode().RAW_decode(RSL__IE__Body_ipa__speech__mode_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_53_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_54_force_omit(54, force_omit, RSL__IE__Body_ipa__rtp__csd__fmt_descr_.raw->forceomit);
      decoded_length = ipa__rtp__csd__fmt().RAW_decode(RSL__IE__Body_ipa__rtp__csd__fmt_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_54_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_55_force_omit(55, force_omit, RSL__IE__Body_osmo__training__sequence_descr_.raw->forceomit);
      decoded_length = osmo__training__sequence().RAW_decode(RSL__IE__Body_osmo__training__sequence_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_55_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_56_force_omit(56, force_omit, RSL__IE__Body_rep__acch__cap_descr_.raw->forceomit);
      decoded_length = rep__acch__cap().RAW_decode(RSL__IE__Body_rep__acch__cap_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_56_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_57_force_omit(57, force_omit, RSL__IE__Body_top__acch__cap_descr_.raw->forceomit);
      decoded_length = top__acch__cap().RAW_decode(RSL__IE__Body_top__acch__cap_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_57_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_58_force_omit(58, force_omit, RSL__IE__Body_osmux__cid_descr_.raw->forceomit);
      decoded_length = osmux__cid().RAW_decode(RSL__IE__Body_osmux__cid_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_58_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_59_force_omit(59, force_omit, RSL__IE__Body_other_descr_.raw->forceomit);
      decoded_length = other().RAW_decode(RSL__IE__Body_other_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_59_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
 }
 clean_up();
 return -1;
}

int RSL__IE__Body::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 60;  myleaf.body.node.nodes = init_nodes_of_enc_tree(60);
  memset(myleaf.body.node.nodes, 0, 60 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_chan__nr:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, RSL__IE__Body_chan__nr_descr_.raw);
    encoded_length = field_chan__nr->RAW_encode(RSL__IE__Body_chan__nr_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &RSL__IE__Body_chan__nr_descr_;
    break;
  case ALT_link__id:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, RSL__IE__Body_link__id_descr_.raw);
    encoded_length = field_link__id->RAW_encode(RSL__IE__Body_link__id_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &RSL__IE__Body_link__id_descr_;
    break;
  case ALT_l3__info:
    myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 2, RSL__IE__Body_l3__info_descr_.raw);
    encoded_length = field_l3__info->RAW_encode(RSL__IE__Body_l3__info_descr_, *myleaf.body.node.nodes[2]);
    myleaf.body.node.nodes[2]->coding_descr = &RSL__IE__Body_l3__info_descr_;
    break;
  case ALT_rlm__cause:
    myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 3, RSL__IE__Body_rlm__cause_descr_.raw);
    encoded_length = field_rlm__cause->RAW_encode(RSL__IE__Body_rlm__cause_descr_, *myleaf.body.node.nodes[3]);
    myleaf.body.node.nodes[3]->coding_descr = &RSL__IE__Body_rlm__cause_descr_;
    break;
  case ALT_release__mode:
    myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 4, RSL__IE__Body_release__mode_descr_.raw);
    encoded_length = field_release__mode->RAW_encode(RSL__IE__Body_release__mode_descr_, *myleaf.body.node.nodes[4]);
    myleaf.body.node.nodes[4]->coding_descr = &RSL__IE__Body_release__mode_descr_;
    break;
  case ALT_act__type:
    myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 5, RSL__IE__Body_act__type_descr_.raw);
    encoded_length = field_act__type->RAW_encode(RSL__IE__Body_act__type_descr_, *myleaf.body.node.nodes[5]);
    myleaf.body.node.nodes[5]->coding_descr = &RSL__IE__Body_act__type_descr_;
    break;
  case ALT_chan__ident:
    myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 6, RSL__IE__Body_chan__ident_descr_.raw);
    encoded_length = field_chan__ident->RAW_encode(RSL__IE__Body_chan__ident_descr_, *myleaf.body.node.nodes[6]);
    myleaf.body.node.nodes[6]->coding_descr = &RSL__IE__Body_chan__ident_descr_;
    break;
  case ALT_chan__mode:
    myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 7, RSL__IE__Body_chan__mode_descr_.raw);
    encoded_length = field_chan__mode->RAW_encode(RSL__IE__Body_chan__mode_descr_, *myleaf.body.node.nodes[7]);
    myleaf.body.node.nodes[7]->coding_descr = &RSL__IE__Body_chan__mode_descr_;
    break;
  case ALT_handover__ref:
    myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 8, RSL__IE__Body_handover__ref_descr_.raw);
    encoded_length = field_handover__ref->RAW_encode(RSL__IE__Body_handover__ref_descr_, *myleaf.body.node.nodes[8]);
    myleaf.body.node.nodes[8]->coding_descr = &RSL__IE__Body_handover__ref_descr_;
    break;
  case ALT_bs__power:
    myleaf.body.node.nodes[9] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 9, RSL__IE__Body_bs__power_descr_.raw);
    encoded_length = field_bs__power->RAW_encode(RSL__IE__Body_bs__power_descr_, *myleaf.body.node.nodes[9]);
    myleaf.body.node.nodes[9]->coding_descr = &RSL__IE__Body_bs__power_descr_;
    break;
  case ALT_bs__power__params:
    myleaf.body.node.nodes[10] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 10, RSL__IE__Body_bs__power__params_descr_.raw);
    encoded_length = field_bs__power__params->RAW_encode(RSL__IE__Body_bs__power__params_descr_, *myleaf.body.node.nodes[10]);
    myleaf.body.node.nodes[10]->coding_descr = &RSL__IE__Body_bs__power__params_descr_;
    break;
  case ALT_ms__power:
    myleaf.body.node.nodes[11] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 11, RSL__IE__Body_ms__power_descr_.raw);
    encoded_length = field_ms__power->RAW_encode(RSL__IE__Body_ms__power_descr_, *myleaf.body.node.nodes[11]);
    myleaf.body.node.nodes[11]->coding_descr = &RSL__IE__Body_ms__power_descr_;
    break;
  case ALT_ms__power__params:
    myleaf.body.node.nodes[12] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 12, RSL__IE__Body_ms__power__params_descr_.raw);
    encoded_length = field_ms__power__params->RAW_encode(RSL__IE__Body_ms__power__params_descr_, *myleaf.body.node.nodes[12]);
    myleaf.body.node.nodes[12]->coding_descr = &RSL__IE__Body_ms__power__params_descr_;
    break;
  case ALT_timing__adv:
    myleaf.body.node.nodes[13] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 13, RSL__IE__Body_timing__adv_descr_.raw);
    encoded_length = field_timing__adv->RAW_encode(RSL__IE__Body_timing__adv_descr_, *myleaf.body.node.nodes[13]);
    myleaf.body.node.nodes[13]->coding_descr = &RSL__IE__Body_timing__adv_descr_;
    break;
  case ALT_multirate__cfg:
    myleaf.body.node.nodes[14] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 14, RSL__IE__Body_multirate__cfg_descr_.raw);
    encoded_length = field_multirate__cfg->RAW_encode(RSL__IE__Body_multirate__cfg_descr_, *myleaf.body.node.nodes[14]);
    myleaf.body.node.nodes[14]->coding_descr = &RSL__IE__Body_multirate__cfg_descr_;
    break;
  case ALT_multirate__ctrl:
    myleaf.body.node.nodes[15] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 15, RSL__IE__Body_multirate__ctrl_descr_.raw);
    encoded_length = field_multirate__ctrl->RAW_encode(RSL__IE__Body_multirate__ctrl_descr_, *myleaf.body.node.nodes[15]);
    myleaf.body.node.nodes[15]->coding_descr = &RSL__IE__Body_multirate__ctrl_descr_;
    break;
  case ALT_msg__id:
    myleaf.body.node.nodes[16] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 16, RSL__IE__Body_msg__id_descr_.raw);
    encoded_length = field_msg__id->RAW_encode(RSL__IE__Body_msg__id_descr_, *myleaf.body.node.nodes[16]);
    myleaf.body.node.nodes[16]->coding_descr = &RSL__IE__Body_msg__id_descr_;
    break;
  case ALT_frame__nr:
    myleaf.body.node.nodes[17] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 17, RSL__IE__Body_frame__nr_descr_.raw);
    encoded_length = field_frame__nr->RAW_encode(RSL__IE__Body_frame__nr_descr_, *myleaf.body.node.nodes[17]);
    myleaf.body.node.nodes[17]->coding_descr = &RSL__IE__Body_frame__nr_descr_;
    break;
  case ALT_cause:
    myleaf.body.node.nodes[18] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 18, RSL__IE__Body_cause_descr_.raw);
    encoded_length = field_cause->RAW_encode(RSL__IE__Body_cause_descr_, *myleaf.body.node.nodes[18]);
    myleaf.body.node.nodes[18]->coding_descr = &RSL__IE__Body_cause_descr_;
    break;
  case ALT_access__delay:
    myleaf.body.node.nodes[19] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 19, RSL__IE__Body_access__delay_descr_.raw);
    encoded_length = field_access__delay->RAW_encode(RSL__IE__Body_access__delay_descr_, *myleaf.body.node.nodes[19]);
    myleaf.body.node.nodes[19]->coding_descr = &RSL__IE__Body_access__delay_descr_;
    break;
  case ALT_rach__load:
    myleaf.body.node.nodes[20] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 20, RSL__IE__Body_rach__load_descr_.raw);
    encoded_length = field_rach__load->RAW_encode(RSL__IE__Body_rach__load_descr_, *myleaf.body.node.nodes[20]);
    myleaf.body.node.nodes[20]->coding_descr = &RSL__IE__Body_rach__load_descr_;
    break;
  case ALT_meas__res__nr:
    myleaf.body.node.nodes[21] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 21, RSL__IE__Body_meas__res__nr_descr_.raw);
    encoded_length = field_meas__res__nr->RAW_encode(RSL__IE__Body_meas__res__nr_descr_, *myleaf.body.node.nodes[21]);
    myleaf.body.node.nodes[21]->coding_descr = &RSL__IE__Body_meas__res__nr_descr_;
    break;
  case ALT_ms__timing__offset:
    myleaf.body.node.nodes[22] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 22, RSL__IE__Body_ms__timing__offset_descr_.raw);
    encoded_length = field_ms__timing__offset->RAW_encode(RSL__IE__Body_ms__timing__offset_descr_, *myleaf.body.node.nodes[22]);
    myleaf.body.node.nodes[22]->coding_descr = &RSL__IE__Body_ms__timing__offset_descr_;
    break;
  case ALT_uplink__meas:
    myleaf.body.node.nodes[23] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 23, RSL__IE__Body_uplink__meas_descr_.raw);
    encoded_length = field_uplink__meas->RAW_encode(RSL__IE__Body_uplink__meas_descr_, *myleaf.body.node.nodes[23]);
    myleaf.body.node.nodes[23]->coding_descr = &RSL__IE__Body_uplink__meas_descr_;
    break;
  case ALT_l1__info:
    myleaf.body.node.nodes[24] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 24, RSL__IE__Body_l1__info_descr_.raw);
    encoded_length = field_l1__info->RAW_encode(RSL__IE__Body_l1__info_descr_, *myleaf.body.node.nodes[24]);
    myleaf.body.node.nodes[24]->coding_descr = &RSL__IE__Body_l1__info_descr_;
    break;
  case ALT_sysinfo__type:
    myleaf.body.node.nodes[25] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 25, RSL__IE__Body_sysinfo__type_descr_.raw);
    encoded_length = field_sysinfo__type->RAW_encode(RSL__IE__Body_sysinfo__type_descr_, *myleaf.body.node.nodes[25]);
    myleaf.body.node.nodes[25]->coding_descr = &RSL__IE__Body_sysinfo__type_descr_;
    break;
  case ALT_paging__load:
    myleaf.body.node.nodes[26] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 26, RSL__IE__Body_paging__load_descr_.raw);
    encoded_length = field_paging__load->RAW_encode(RSL__IE__Body_paging__load_descr_, *myleaf.body.node.nodes[26]);
    myleaf.body.node.nodes[26]->coding_descr = &RSL__IE__Body_paging__load_descr_;
    break;
  case ALT_paging__group:
    myleaf.body.node.nodes[27] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 27, RSL__IE__Body_paging__group_descr_.raw);
    encoded_length = field_paging__group->RAW_encode(RSL__IE__Body_paging__group_descr_, *myleaf.body.node.nodes[27]);
    myleaf.body.node.nodes[27]->coding_descr = &RSL__IE__Body_paging__group_descr_;
    break;
  case ALT_chan__needed:
    myleaf.body.node.nodes[28] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 28, RSL__IE__Body_chan__needed_descr_.raw);
    encoded_length = field_chan__needed->RAW_encode(RSL__IE__Body_chan__needed_descr_, *myleaf.body.node.nodes[28]);
    myleaf.body.node.nodes[28]->coding_descr = &RSL__IE__Body_chan__needed_descr_;
    break;
  case ALT_cb__cmd__type:
    myleaf.body.node.nodes[29] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 29, RSL__IE__Body_cb__cmd__type_descr_.raw);
    encoded_length = field_cb__cmd__type->RAW_encode(RSL__IE__Body_cb__cmd__type_descr_, *myleaf.body.node.nodes[29]);
    myleaf.body.node.nodes[29]->coding_descr = &RSL__IE__Body_cb__cmd__type_descr_;
    break;
  case ALT_smscb__message:
    myleaf.body.node.nodes[30] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 30, RSL__IE__Body_smscb__message_descr_.raw);
    encoded_length = field_smscb__message->RAW_encode(RSL__IE__Body_smscb__message_descr_, *myleaf.body.node.nodes[30]);
    myleaf.body.node.nodes[30]->coding_descr = &RSL__IE__Body_smscb__message_descr_;
    break;
  case ALT_cbch__load__info:
    myleaf.body.node.nodes[31] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 31, RSL__IE__Body_cbch__load__info_descr_.raw);
    encoded_length = field_cbch__load__info->RAW_encode(RSL__IE__Body_cbch__load__info_descr_, *myleaf.body.node.nodes[31]);
    myleaf.body.node.nodes[31]->coding_descr = &RSL__IE__Body_cbch__load__info_descr_;
    break;
  case ALT_resource__info:
    myleaf.body.node.nodes[32] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 32, RSL__IE__Body_resource__info_descr_.raw);
    encoded_length = field_resource__info->RAW_encode(RSL__IE__Body_resource__info_descr_, *myleaf.body.node.nodes[32]);
    myleaf.body.node.nodes[32]->coding_descr = &RSL__IE__Body_resource__info_descr_;
    break;
  case ALT_sacch__info:
    myleaf.body.node.nodes[33] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 33, RSL__IE__Body_sacch__info_descr_.raw);
    encoded_length = field_sacch__info->RAW_encode(RSL__IE__Body_sacch__info_descr_, *myleaf.body.node.nodes[33]);
    myleaf.body.node.nodes[33]->coding_descr = &RSL__IE__Body_sacch__info_descr_;
    break;
  case ALT_starting__time:
    myleaf.body.node.nodes[34] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 34, RSL__IE__Body_starting__time_descr_.raw);
    encoded_length = field_starting__time->RAW_encode(RSL__IE__Body_starting__time_descr_, *myleaf.body.node.nodes[34]);
    myleaf.body.node.nodes[34]->coding_descr = &RSL__IE__Body_starting__time_descr_;
    break;
  case ALT_encr__info:
    myleaf.body.node.nodes[35] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 35, RSL__IE__Body_encr__info_descr_.raw);
    encoded_length = field_encr__info->RAW_encode(RSL__IE__Body_encr__info_descr_, *myleaf.body.node.nodes[35]);
    myleaf.body.node.nodes[35]->coding_descr = &RSL__IE__Body_encr__info_descr_;
    break;
  case ALT_smscb__chan__ind:
    myleaf.body.node.nodes[36] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 36, RSL__IE__Body_smscb__chan__ind_descr_.raw);
    encoded_length = field_smscb__chan__ind->RAW_encode(RSL__IE__Body_smscb__chan__ind_descr_, *myleaf.body.node.nodes[36]);
    myleaf.body.node.nodes[36]->coding_descr = &RSL__IE__Body_smscb__chan__ind_descr_;
    break;
  case ALT_req__ref:
    myleaf.body.node.nodes[37] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 37, RSL__IE__Body_req__ref_descr_.raw);
    encoded_length = field_req__ref->RAW_encode(RSL__IE__Body_req__ref_descr_, *myleaf.body.node.nodes[37]);
    myleaf.body.node.nodes[37]->coding_descr = &RSL__IE__Body_req__ref_descr_;
    break;
  case ALT_full__imm__ass__info:
    myleaf.body.node.nodes[38] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 38, RSL__IE__Body_full__imm__ass__info_descr_.raw);
    encoded_length = field_full__imm__ass__info->RAW_encode(RSL__IE__Body_full__imm__ass__info_descr_, *myleaf.body.node.nodes[38]);
    myleaf.body.node.nodes[38]->coding_descr = &RSL__IE__Body_full__imm__ass__info_descr_;
    break;
  case ALT_ms__identity:
    myleaf.body.node.nodes[39] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 39, RSL__IE__Body_ms__identity_descr_.raw);
    encoded_length = field_ms__identity->RAW_encode(RSL__IE__Body_ms__identity_descr_, *myleaf.body.node.nodes[39]);
    myleaf.body.node.nodes[39]->coding_descr = &RSL__IE__Body_ms__identity_descr_;
    break;
  case ALT_group__call__ref:
    myleaf.body.node.nodes[40] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 40, RSL__IE__Body_group__call__ref_descr_.raw);
    encoded_length = field_group__call__ref->RAW_encode(RSL__IE__Body_group__call__ref_descr_, *myleaf.body.node.nodes[40]);
    myleaf.body.node.nodes[40]->coding_descr = &RSL__IE__Body_group__call__ref_descr_;
    break;
  case ALT_group__chan__desc:
    myleaf.body.node.nodes[41] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 41, RSL__IE__Body_group__chan__desc_descr_.raw);
    encoded_length = field_group__chan__desc->RAW_encode(RSL__IE__Body_group__chan__desc_descr_, *myleaf.body.node.nodes[41]);
    myleaf.body.node.nodes[41]->coding_descr = &RSL__IE__Body_group__chan__desc_descr_;
    break;
  case ALT_nch__drx__info:
    myleaf.body.node.nodes[42] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 42, RSL__IE__Body_nch__drx__info_descr_.raw);
    encoded_length = field_nch__drx__info->RAW_encode(RSL__IE__Body_nch__drx__info_descr_, *myleaf.body.node.nodes[42]);
    myleaf.body.node.nodes[42]->coding_descr = &RSL__IE__Body_nch__drx__info_descr_;
    break;
  case ALT_cmd__indicator:
    myleaf.body.node.nodes[43] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 43, RSL__IE__Body_cmd__indicator_descr_.raw);
    encoded_length = field_cmd__indicator->RAW_encode(RSL__IE__Body_cmd__indicator_descr_, *myleaf.body.node.nodes[43]);
    myleaf.body.node.nodes[43]->coding_descr = &RSL__IE__Body_cmd__indicator_descr_;
    break;
  case ALT_uic:
    myleaf.body.node.nodes[44] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 44, RSL__IE__Body_uic_descr_.raw);
    encoded_length = field_uic->RAW_encode(RSL__IE__Body_uic_descr_, *myleaf.body.node.nodes[44]);
    myleaf.body.node.nodes[44]->coding_descr = &RSL__IE__Body_uic_descr_;
    break;
  case ALT_ipa__conn__id:
    myleaf.body.node.nodes[45] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 45, RSL__IE__Body_ipa__conn__id_descr_.raw);
    encoded_length = field_ipa__conn__id->RAW_encode(RSL__IE__Body_ipa__conn__id_descr_, *myleaf.body.node.nodes[45]);
    myleaf.body.node.nodes[45]->coding_descr = &RSL__IE__Body_ipa__conn__id_descr_;
    break;
  case ALT_ipa__local__port:
    myleaf.body.node.nodes[46] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 46, RSL__IE__Body_ipa__local__port_descr_.raw);
    encoded_length = field_ipa__local__port->RAW_encode(RSL__IE__Body_ipa__local__port_descr_, *myleaf.body.node.nodes[46]);
    myleaf.body.node.nodes[46]->coding_descr = &RSL__IE__Body_ipa__local__port_descr_;
    break;
  case ALT_ipa__remote__port:
    myleaf.body.node.nodes[47] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 47, RSL__IE__Body_ipa__remote__port_descr_.raw);
    encoded_length = field_ipa__remote__port->RAW_encode(RSL__IE__Body_ipa__remote__port_descr_, *myleaf.body.node.nodes[47]);
    myleaf.body.node.nodes[47]->coding_descr = &RSL__IE__Body_ipa__remote__port_descr_;
    break;
  case ALT_ipa__local__ip:
    myleaf.body.node.nodes[48] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 48, RSL__IE__Body_ipa__local__ip_descr_.raw);
    encoded_length = field_ipa__local__ip->RAW_encode(RSL__IE__Body_ipa__local__ip_descr_, *myleaf.body.node.nodes[48]);
    myleaf.body.node.nodes[48]->coding_descr = &RSL__IE__Body_ipa__local__ip_descr_;
    break;
  case ALT_ipa__remote__ip:
    myleaf.body.node.nodes[49] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 49, RSL__IE__Body_ipa__remote__ip_descr_.raw);
    encoded_length = field_ipa__remote__ip->RAW_encode(RSL__IE__Body_ipa__remote__ip_descr_, *myleaf.body.node.nodes[49]);
    myleaf.body.node.nodes[49]->coding_descr = &RSL__IE__Body_ipa__remote__ip_descr_;
    break;
  case ALT_ipa__rtp__pt:
    myleaf.body.node.nodes[50] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 50, RSL__IE__Body_ipa__rtp__pt_descr_.raw);
    encoded_length = field_ipa__rtp__pt->RAW_encode(RSL__IE__Body_ipa__rtp__pt_descr_, *myleaf.body.node.nodes[50]);
    myleaf.body.node.nodes[50]->coding_descr = &RSL__IE__Body_ipa__rtp__pt_descr_;
    break;
  case ALT_ipa__rtp__pt2:
    myleaf.body.node.nodes[51] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 51, RSL__IE__Body_ipa__rtp__pt2_descr_.raw);
    encoded_length = field_ipa__rtp__pt2->RAW_encode(RSL__IE__Body_ipa__rtp__pt2_descr_, *myleaf.body.node.nodes[51]);
    myleaf.body.node.nodes[51]->coding_descr = &RSL__IE__Body_ipa__rtp__pt2_descr_;
    break;
  case ALT_ipa__stats:
    myleaf.body.node.nodes[52] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 52, RSL__IE__Body_ipa__stats_descr_.raw);
    encoded_length = field_ipa__stats->RAW_encode(RSL__IE__Body_ipa__stats_descr_, *myleaf.body.node.nodes[52]);
    myleaf.body.node.nodes[52]->coding_descr = &RSL__IE__Body_ipa__stats_descr_;
    break;
  case ALT_ipa__speech__mode:
    myleaf.body.node.nodes[53] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 53, RSL__IE__Body_ipa__speech__mode_descr_.raw);
    encoded_length = field_ipa__speech__mode->RAW_encode(RSL__IE__Body_ipa__speech__mode_descr_, *myleaf.body.node.nodes[53]);
    myleaf.body.node.nodes[53]->coding_descr = &RSL__IE__Body_ipa__speech__mode_descr_;
    break;
  case ALT_ipa__rtp__csd__fmt:
    myleaf.body.node.nodes[54] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 54, RSL__IE__Body_ipa__rtp__csd__fmt_descr_.raw);
    encoded_length = field_ipa__rtp__csd__fmt->RAW_encode(RSL__IE__Body_ipa__rtp__csd__fmt_descr_, *myleaf.body.node.nodes[54]);
    myleaf.body.node.nodes[54]->coding_descr = &RSL__IE__Body_ipa__rtp__csd__fmt_descr_;
    break;
  case ALT_osmo__training__sequence:
    myleaf.body.node.nodes[55] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 55, RSL__IE__Body_osmo__training__sequence_descr_.raw);
    encoded_length = field_osmo__training__sequence->RAW_encode(RSL__IE__Body_osmo__training__sequence_descr_, *myleaf.body.node.nodes[55]);
    myleaf.body.node.nodes[55]->coding_descr = &RSL__IE__Body_osmo__training__sequence_descr_;
    break;
  case ALT_rep__acch__cap:
    myleaf.body.node.nodes[56] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 56, RSL__IE__Body_rep__acch__cap_descr_.raw);
    encoded_length = field_rep__acch__cap->RAW_encode(RSL__IE__Body_rep__acch__cap_descr_, *myleaf.body.node.nodes[56]);
    myleaf.body.node.nodes[56]->coding_descr = &RSL__IE__Body_rep__acch__cap_descr_;
    break;
  case ALT_top__acch__cap:
    myleaf.body.node.nodes[57] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 57, RSL__IE__Body_top__acch__cap_descr_.raw);
    encoded_length = field_top__acch__cap->RAW_encode(RSL__IE__Body_top__acch__cap_descr_, *myleaf.body.node.nodes[57]);
    myleaf.body.node.nodes[57]->coding_descr = &RSL__IE__Body_top__acch__cap_descr_;
    break;
  case ALT_osmux__cid:
    myleaf.body.node.nodes[58] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 58, RSL__IE__Body_osmux__cid_descr_.raw);
    encoded_length = field_osmux__cid->RAW_encode(RSL__IE__Body_osmux__cid_descr_, *myleaf.body.node.nodes[58]);
    myleaf.body.node.nodes[58]->coding_descr = &RSL__IE__Body_osmux__cid_descr_;
    break;
  case ALT_other:
    myleaf.body.node.nodes[59] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 59, RSL__IE__Body_other_descr_.raw);
    encoded_length = field_other->RAW_encode(RSL__IE__Body_other_descr_, *myleaf.body.node.nodes[59]);
    myleaf.body.node.nodes[59]->coding_descr = &RSL__IE__Body_other_descr_;
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void RSL__IE__Body_template::copy_value(const RSL__IE__Body& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case RSL__IE__Body::ALT_chan__nr:
single_value.field_chan__nr = new GSM__Types::RslChannelNr_template(other_value.chan__nr());
break;
case RSL__IE__Body::ALT_link__id:
single_value.field_link__id = new GSM__Types::RslLinkId_template(other_value.link__id());
break;
case RSL__IE__Body::ALT_l3__info:
single_value.field_l3__info = new RSL__L16V_template(other_value.l3__info());
break;
case RSL__IE__Body::ALT_rlm__cause:
single_value.field_rlm__cause = new RSL__LV_template(other_value.rlm__cause());
break;
case RSL__IE__Body::ALT_release__mode:
single_value.field_release__mode = new RSL__IE__ReleaseMode_template(other_value.release__mode());
break;
case RSL__IE__Body::ALT_act__type:
single_value.field_act__type = new RSL__IE__ActivationType_template(other_value.act__type());
break;
case RSL__IE__Body::ALT_chan__ident:
single_value.field_chan__ident = new RSL__IE__ChannelIdent_template(other_value.chan__ident());
break;
case RSL__IE__Body::ALT_chan__mode:
single_value.field_chan__mode = new RSL__IE__ChannelMode_template(other_value.chan__mode());
break;
case RSL__IE__Body::ALT_handover__ref:
single_value.field_handover__ref = new INTEGER_template(other_value.handover__ref());
break;
case RSL__IE__Body::ALT_bs__power:
single_value.field_bs__power = new RSL__IE__BS__Power_template(other_value.bs__power());
break;
case RSL__IE__Body::ALT_bs__power__params:
single_value.field_bs__power__params = new RSL__LV_template(other_value.bs__power__params());
break;
case RSL__IE__Body::ALT_ms__power:
single_value.field_ms__power = new RSL__IE__MS__Power_template(other_value.ms__power());
break;
case RSL__IE__Body::ALT_ms__power__params:
single_value.field_ms__power__params = new RSL__IE__MS__Power__Parameters_template(other_value.ms__power__params());
break;
case RSL__IE__Body::ALT_timing__adv:
single_value.field_timing__adv = new INTEGER_template(other_value.timing__adv());
break;
case RSL__IE__Body::ALT_multirate__cfg:
single_value.field_multirate__cfg = new RSL__IE__MultirateCfg_template(other_value.multirate__cfg());
break;
case RSL__IE__Body::ALT_multirate__ctrl:
single_value.field_multirate__ctrl = new RSL__IE__MultirateCtrl_template(other_value.multirate__ctrl());
break;
case RSL__IE__Body::ALT_msg__id:
single_value.field_msg__id = new INTEGER_template(other_value.msg__id());
break;
case RSL__IE__Body::ALT_frame__nr:
single_value.field_frame__nr = new RSL__IE__FrameNumber_template(other_value.frame__nr());
break;
case RSL__IE__Body::ALT_cause:
single_value.field_cause = new RSL__IE__Cause_template(other_value.cause());
break;
case RSL__IE__Body::ALT_access__delay:
single_value.field_access__delay = new INTEGER_template(other_value.access__delay());
break;
case RSL__IE__Body::ALT_rach__load:
single_value.field_rach__load = new RSL__IE__RachLoad_template(other_value.rach__load());
break;
case RSL__IE__Body::ALT_meas__res__nr:
single_value.field_meas__res__nr = new INTEGER_template(other_value.meas__res__nr());
break;
case RSL__IE__Body::ALT_ms__timing__offset:
single_value.field_ms__timing__offset = new INTEGER_template(other_value.ms__timing__offset());
break;
case RSL__IE__Body::ALT_uplink__meas:
single_value.field_uplink__meas = new RSL__IE__UplinkMeas_template(other_value.uplink__meas());
break;
case RSL__IE__Body::ALT_l1__info:
single_value.field_l1__info = new RSL__IE__L1Info_template(other_value.l1__info());
break;
case RSL__IE__Body::ALT_sysinfo__type:
single_value.field_sysinfo__type = new RSL__IE__SysinfoType_template(other_value.sysinfo__type());
break;
case RSL__IE__Body::ALT_paging__load:
single_value.field_paging__load = new INTEGER_template(other_value.paging__load());
break;
case RSL__IE__Body::ALT_paging__group:
single_value.field_paging__group = new INTEGER_template(other_value.paging__group());
break;
case RSL__IE__Body::ALT_chan__needed:
single_value.field_chan__needed = new RSL__IE__ChanNeeded_template(other_value.chan__needed());
break;
case RSL__IE__Body::ALT_cb__cmd__type:
single_value.field_cb__cmd__type = new RSL__IE__CbCommandType_template(other_value.cb__cmd__type());
break;
case RSL__IE__Body::ALT_smscb__message:
single_value.field_smscb__message = new RSL__LV_template(other_value.smscb__message());
break;
case RSL__IE__Body::ALT_cbch__load__info:
single_value.field_cbch__load__info = new RSL__IE__CbchLoadInfo_template(other_value.cbch__load__info());
break;
case RSL__IE__Body::ALT_resource__info:
single_value.field_resource__info = new RSL__IE__ResourceInfo_template(other_value.resource__info());
break;
case RSL__IE__Body::ALT_sacch__info:
single_value.field_sacch__info = new RSL__SacchInfo_template(other_value.sacch__info());
break;
case RSL__IE__Body::ALT_starting__time:
single_value.field_starting__time = new RSL__IE__FrameNumber_template(other_value.starting__time());
break;
case RSL__IE__Body::ALT_encr__info:
single_value.field_encr__info = new RSL__IE__EncryptionInfo_template(other_value.encr__info());
break;
case RSL__IE__Body::ALT_smscb__chan__ind:
single_value.field_smscb__chan__ind = new INTEGER_template(other_value.smscb__chan__ind());
break;
case RSL__IE__Body::ALT_req__ref:
single_value.field_req__ref = new RSL__IE__RequestRef_template(other_value.req__ref());
break;
case RSL__IE__Body::ALT_full__imm__ass__info:
single_value.field_full__imm__ass__info = new RSL__LV_template(other_value.full__imm__ass__info());
break;
case RSL__IE__Body::ALT_ms__identity:
single_value.field_ms__identity = new MobileL3__CommonIE__Types::MobileIdentityLV_template(other_value.ms__identity());
break;
case RSL__IE__Body::ALT_group__call__ref:
single_value.field_group__call__ref = new RSL__IE__GroupCallReference_template(other_value.group__call__ref());
break;
case RSL__IE__Body::ALT_group__chan__desc:
single_value.field_group__chan__desc = new RSL__IE__GroupChannelDescription_template(other_value.group__chan__desc());
break;
case RSL__IE__Body::ALT_nch__drx__info:
single_value.field_nch__drx__info = new RSL__IE__NchDrxInformation_template(other_value.nch__drx__info());
break;
case RSL__IE__Body::ALT_cmd__indicator:
single_value.field_cmd__indicator = new RSL__IE__CommandIndicator_template(other_value.cmd__indicator());
break;
case RSL__IE__Body::ALT_uic:
single_value.field_uic = new RSL__IE__Uic_template(other_value.uic());
break;
case RSL__IE__Body::ALT_ipa__conn__id:
single_value.field_ipa__conn__id = new INTEGER_template(other_value.ipa__conn__id());
break;
case RSL__IE__Body::ALT_ipa__local__port:
single_value.field_ipa__local__port = new INTEGER_template(other_value.ipa__local__port());
break;
case RSL__IE__Body::ALT_ipa__remote__port:
single_value.field_ipa__remote__port = new INTEGER_template(other_value.ipa__remote__port());
break;
case RSL__IE__Body::ALT_ipa__local__ip:
single_value.field_ipa__local__ip = new OCTETSTRING_template(other_value.ipa__local__ip());
break;
case RSL__IE__Body::ALT_ipa__remote__ip:
single_value.field_ipa__remote__ip = new OCTETSTRING_template(other_value.ipa__remote__ip());
break;
case RSL__IE__Body::ALT_ipa__rtp__pt:
single_value.field_ipa__rtp__pt = new INTEGER_template(other_value.ipa__rtp__pt());
break;
case RSL__IE__Body::ALT_ipa__rtp__pt2:
single_value.field_ipa__rtp__pt2 = new INTEGER_template(other_value.ipa__rtp__pt2());
break;
case RSL__IE__Body::ALT_ipa__stats:
single_value.field_ipa__stats = new RSL__IE__IPA__ConnectionStats_template(other_value.ipa__stats());
break;
case RSL__IE__Body::ALT_ipa__speech__mode:
single_value.field_ipa__speech__mode = new RSL__IE__IPA__SpeechMode_template(other_value.ipa__speech__mode());
break;
case RSL__IE__Body::ALT_ipa__rtp__csd__fmt:
single_value.field_ipa__rtp__csd__fmt = new RSL__IE__IPA__RTP__CSD__FMT_template(other_value.ipa__rtp__csd__fmt());
break;
case RSL__IE__Body::ALT_osmo__training__sequence:
single_value.field_osmo__training__sequence = new RSL__IE__OSMO__TrainingSequence_template(other_value.osmo__training__sequence());
break;
case RSL__IE__Body::ALT_rep__acch__cap:
single_value.field_rep__acch__cap = new RSL__IE__OSMO__RepAcchCap_template(other_value.rep__acch__cap());
break;
case RSL__IE__Body::ALT_top__acch__cap:
single_value.field_top__acch__cap = new RSL__IE__OSMO__TopAcchCap_template(other_value.top__acch__cap());
break;
case RSL__IE__Body::ALT_osmux__cid:
single_value.field_osmux__cid = new RSL__IE__OSMO__Osmux__CID_template(other_value.osmux__cid());
break;
case RSL__IE__Body::ALT_other:
single_value.field_other = new RSL__LV_template(other_value.other());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @RSL_Types.RSL_IE_Body.");
}
set_selection(SPECIFIC_VALUE);
}

void RSL__IE__Body_template::copy_template(const RSL__IE__Body_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case RSL__IE__Body::ALT_chan__nr:
single_value.field_chan__nr = new GSM__Types::RslChannelNr_template(*other_value.single_value.field_chan__nr);
break;
case RSL__IE__Body::ALT_link__id:
single_value.field_link__id = new GSM__Types::RslLinkId_template(*other_value.single_value.field_link__id);
break;
case RSL__IE__Body::ALT_l3__info:
single_value.field_l3__info = new RSL__L16V_template(*other_value.single_value.field_l3__info);
break;
case RSL__IE__Body::ALT_rlm__cause:
single_value.field_rlm__cause = new RSL__LV_template(*other_value.single_value.field_rlm__cause);
break;
case RSL__IE__Body::ALT_release__mode:
single_value.field_release__mode = new RSL__IE__ReleaseMode_template(*other_value.single_value.field_release__mode);
break;
case RSL__IE__Body::ALT_act__type:
single_value.field_act__type = new RSL__IE__ActivationType_template(*other_value.single_value.field_act__type);
break;
case RSL__IE__Body::ALT_chan__ident:
single_value.field_chan__ident = new RSL__IE__ChannelIdent_template(*other_value.single_value.field_chan__ident);
break;
case RSL__IE__Body::ALT_chan__mode:
single_value.field_chan__mode = new RSL__IE__ChannelMode_template(*other_value.single_value.field_chan__mode);
break;
case RSL__IE__Body::ALT_handover__ref:
single_value.field_handover__ref = new INTEGER_template(*other_value.single_value.field_handover__ref);
break;
case RSL__IE__Body::ALT_bs__power:
single_value.field_bs__power = new RSL__IE__BS__Power_template(*other_value.single_value.field_bs__power);
break;
case RSL__IE__Body::ALT_bs__power__params:
single_value.field_bs__power__params = new RSL__LV_template(*other_value.single_value.field_bs__power__params);
break;
case RSL__IE__Body::ALT_ms__power:
single_value.field_ms__power = new RSL__IE__MS__Power_template(*other_value.single_value.field_ms__power);
break;
case RSL__IE__Body::ALT_ms__power__params:
single_value.field_ms__power__params = new RSL__IE__MS__Power__Parameters_template(*other_value.single_value.field_ms__power__params);
break;
case RSL__IE__Body::ALT_timing__adv:
single_value.field_timing__adv = new INTEGER_template(*other_value.single_value.field_timing__adv);
break;
case RSL__IE__Body::ALT_multirate__cfg:
single_value.field_multirate__cfg = new RSL__IE__MultirateCfg_template(*other_value.single_value.field_multirate__cfg);
break;
case RSL__IE__Body::ALT_multirate__ctrl:
single_value.field_multirate__ctrl = new RSL__IE__MultirateCtrl_template(*other_value.single_value.field_multirate__ctrl);
break;
case RSL__IE__Body::ALT_msg__id:
single_value.field_msg__id = new INTEGER_template(*other_value.single_value.field_msg__id);
break;
case RSL__IE__Body::ALT_frame__nr:
single_value.field_frame__nr = new RSL__IE__FrameNumber_template(*other_value.single_value.field_frame__nr);
break;
case RSL__IE__Body::ALT_cause:
single_value.field_cause = new RSL__IE__Cause_template(*other_value.single_value.field_cause);
break;
case RSL__IE__Body::ALT_access__delay:
single_value.field_access__delay = new INTEGER_template(*other_value.single_value.field_access__delay);
break;
case RSL__IE__Body::ALT_rach__load:
single_value.field_rach__load = new RSL__IE__RachLoad_template(*other_value.single_value.field_rach__load);
break;
case RSL__IE__Body::ALT_meas__res__nr:
single_value.field_meas__res__nr = new INTEGER_template(*other_value.single_value.field_meas__res__nr);
break;
case RSL__IE__Body::ALT_ms__timing__offset:
single_value.field_ms__timing__offset = new INTEGER_template(*other_value.single_value.field_ms__timing__offset);
break;
case RSL__IE__Body::ALT_uplink__meas:
single_value.field_uplink__meas = new RSL__IE__UplinkMeas_template(*other_value.single_value.field_uplink__meas);
break;
case RSL__IE__Body::ALT_l1__info:
single_value.field_l1__info = new RSL__IE__L1Info_template(*other_value.single_value.field_l1__info);
break;
case RSL__IE__Body::ALT_sysinfo__type:
single_value.field_sysinfo__type = new RSL__IE__SysinfoType_template(*other_value.single_value.field_sysinfo__type);
break;
case RSL__IE__Body::ALT_paging__load:
single_value.field_paging__load = new INTEGER_template(*other_value.single_value.field_paging__load);
break;
case RSL__IE__Body::ALT_paging__group:
single_value.field_paging__group = new INTEGER_template(*other_value.single_value.field_paging__group);
break;
case RSL__IE__Body::ALT_chan__needed:
single_value.field_chan__needed = new RSL__IE__ChanNeeded_template(*other_value.single_value.field_chan__needed);
break;
case RSL__IE__Body::ALT_cb__cmd__type:
single_value.field_cb__cmd__type = new RSL__IE__CbCommandType_template(*other_value.single_value.field_cb__cmd__type);
break;
case RSL__IE__Body::ALT_smscb__message:
single_value.field_smscb__message = new RSL__LV_template(*other_value.single_value.field_smscb__message);
break;
case RSL__IE__Body::ALT_cbch__load__info:
single_value.field_cbch__load__info = new RSL__IE__CbchLoadInfo_template(*other_value.single_value.field_cbch__load__info);
break;
case RSL__IE__Body::ALT_resource__info:
single_value.field_resource__info = new RSL__IE__ResourceInfo_template(*other_value.single_value.field_resource__info);
break;
case RSL__IE__Body::ALT_sacch__info:
single_value.field_sacch__info = new RSL__SacchInfo_template(*other_value.single_value.field_sacch__info);
break;
case RSL__IE__Body::ALT_starting__time:
single_value.field_starting__time = new RSL__IE__FrameNumber_template(*other_value.single_value.field_starting__time);
break;
case RSL__IE__Body::ALT_encr__info:
single_value.field_encr__info = new RSL__IE__EncryptionInfo_template(*other_value.single_value.field_encr__info);
break;
case RSL__IE__Body::ALT_smscb__chan__ind:
single_value.field_smscb__chan__ind = new INTEGER_template(*other_value.single_value.field_smscb__chan__ind);
break;
case RSL__IE__Body::ALT_req__ref:
single_value.field_req__ref = new RSL__IE__RequestRef_template(*other_value.single_value.field_req__ref);
break;
case RSL__IE__Body::ALT_full__imm__ass__info:
single_value.field_full__imm__ass__info = new RSL__LV_template(*other_value.single_value.field_full__imm__ass__info);
break;
case RSL__IE__Body::ALT_ms__identity:
single_value.field_ms__identity = new MobileL3__CommonIE__Types::MobileIdentityLV_template(*other_value.single_value.field_ms__identity);
break;
case RSL__IE__Body::ALT_group__call__ref:
single_value.field_group__call__ref = new RSL__IE__GroupCallReference_template(*other_value.single_value.field_group__call__ref);
break;
case RSL__IE__Body::ALT_group__chan__desc:
single_value.field_group__chan__desc = new RSL__IE__GroupChannelDescription_template(*other_value.single_value.field_group__chan__desc);
break;
case RSL__IE__Body::ALT_nch__drx__info:
single_value.field_nch__drx__info = new RSL__IE__NchDrxInformation_template(*other_value.single_value.field_nch__drx__info);
break;
case RSL__IE__Body::ALT_cmd__indicator:
single_value.field_cmd__indicator = new RSL__IE__CommandIndicator_template(*other_value.single_value.field_cmd__indicator);
break;
case RSL__IE__Body::ALT_uic:
single_value.field_uic = new RSL__IE__Uic_template(*other_value.single_value.field_uic);
break;
case RSL__IE__Body::ALT_ipa__conn__id:
single_value.field_ipa__conn__id = new INTEGER_template(*other_value.single_value.field_ipa__conn__id);
break;
case RSL__IE__Body::ALT_ipa__local__port:
single_value.field_ipa__local__port = new INTEGER_template(*other_value.single_value.field_ipa__local__port);
break;
case RSL__IE__Body::ALT_ipa__remote__port:
single_value.field_ipa__remote__port = new INTEGER_template(*other_value.single_value.field_ipa__remote__port);
break;
case RSL__IE__Body::ALT_ipa__local__ip:
single_value.field_ipa__local__ip = new OCTETSTRING_template(*other_value.single_value.field_ipa__local__ip);
break;
case RSL__IE__Body::ALT_ipa__remote__ip:
single_value.field_ipa__remote__ip = new OCTETSTRING_template(*other_value.single_value.field_ipa__remote__ip);
break;
case RSL__IE__Body::ALT_ipa__rtp__pt:
single_value.field_ipa__rtp__pt = new INTEGER_template(*other_value.single_value.field_ipa__rtp__pt);
break;
case RSL__IE__Body::ALT_ipa__rtp__pt2:
single_value.field_ipa__rtp__pt2 = new INTEGER_template(*other_value.single_value.field_ipa__rtp__pt2);
break;
case RSL__IE__Body::ALT_ipa__stats:
single_value.field_ipa__stats = new RSL__IE__IPA__ConnectionStats_template(*other_value.single_value.field_ipa__stats);
break;
case RSL__IE__Body::ALT_ipa__speech__mode:
single_value.field_ipa__speech__mode = new RSL__IE__IPA__SpeechMode_template(*other_value.single_value.field_ipa__speech__mode);
break;
case RSL__IE__Body::ALT_ipa__rtp__csd__fmt:
single_value.field_ipa__rtp__csd__fmt = new RSL__IE__IPA__RTP__CSD__FMT_template(*other_value.single_value.field_ipa__rtp__csd__fmt);
break;
case RSL__IE__Body::ALT_osmo__training__sequence:
single_value.field_osmo__training__sequence = new RSL__IE__OSMO__TrainingSequence_template(*other_value.single_value.field_osmo__training__sequence);
break;
case RSL__IE__Body::ALT_rep__acch__cap:
single_value.field_rep__acch__cap = new RSL__IE__OSMO__RepAcchCap_template(*other_value.single_value.field_rep__acch__cap);
break;
case RSL__IE__Body::ALT_top__acch__cap:
single_value.field_top__acch__cap = new RSL__IE__OSMO__TopAcchCap_template(*other_value.single_value.field_top__acch__cap);
break;
case RSL__IE__Body::ALT_osmux__cid:
single_value.field_osmux__cid = new RSL__IE__OSMO__Osmux__CID_template(*other_value.single_value.field_osmux__cid);
break;
case RSL__IE__Body::ALT_other:
single_value.field_other = new RSL__LV_template(*other_value.single_value.field_other);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @RSL_Types.RSL_IE_Body.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RSL__IE__Body_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RSL__IE__Body_template(*other_value.implication_.precondition);
implication_.implied_template = new RSL__IE__Body_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @RSL_Types.RSL_IE_Body.");
}
set_selection(other_value);
}

RSL__IE__Body_template::RSL__IE__Body_template()
{
}

RSL__IE__Body_template::RSL__IE__Body_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RSL__IE__Body_template::RSL__IE__Body_template(const RSL__IE__Body& other_value)
{
copy_value(other_value);
}

RSL__IE__Body_template::RSL__IE__Body_template(const OPTIONAL<RSL__IE__Body>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__Body&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @RSL_Types.RSL_IE_Body from an unbound optional field.");
}
}

RSL__IE__Body_template::RSL__IE__Body_template(RSL__IE__Body_template* p_precondition, RSL__IE__Body_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RSL__IE__Body_template::RSL__IE__Body_template(Dynamic_Match_Interface<RSL__IE__Body>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RSL__IE__Body>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RSL__IE__Body_template::RSL__IE__Body_template(const RSL__IE__Body_template& other_value)
: Base_Template(){
copy_template(other_value);
}

RSL__IE__Body_template::~RSL__IE__Body_template()
{
clean_up();
}

void RSL__IE__Body_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case RSL__IE__Body::ALT_chan__nr:
delete single_value.field_chan__nr;
break;
case RSL__IE__Body::ALT_link__id:
delete single_value.field_link__id;
break;
case RSL__IE__Body::ALT_l3__info:
delete single_value.field_l3__info;
break;
case RSL__IE__Body::ALT_rlm__cause:
delete single_value.field_rlm__cause;
break;
case RSL__IE__Body::ALT_release__mode:
delete single_value.field_release__mode;
break;
case RSL__IE__Body::ALT_act__type:
delete single_value.field_act__type;
break;
case RSL__IE__Body::ALT_chan__ident:
delete single_value.field_chan__ident;
break;
case RSL__IE__Body::ALT_chan__mode:
delete single_value.field_chan__mode;
break;
case RSL__IE__Body::ALT_handover__ref:
delete single_value.field_handover__ref;
break;
case RSL__IE__Body::ALT_bs__power:
delete single_value.field_bs__power;
break;
case RSL__IE__Body::ALT_bs__power__params:
delete single_value.field_bs__power__params;
break;
case RSL__IE__Body::ALT_ms__power:
delete single_value.field_ms__power;
break;
case RSL__IE__Body::ALT_ms__power__params:
delete single_value.field_ms__power__params;
break;
case RSL__IE__Body::ALT_timing__adv:
delete single_value.field_timing__adv;
break;
case RSL__IE__Body::ALT_multirate__cfg:
delete single_value.field_multirate__cfg;
break;
case RSL__IE__Body::ALT_multirate__ctrl:
delete single_value.field_multirate__ctrl;
break;
case RSL__IE__Body::ALT_msg__id:
delete single_value.field_msg__id;
break;
case RSL__IE__Body::ALT_frame__nr:
delete single_value.field_frame__nr;
break;
case RSL__IE__Body::ALT_cause:
delete single_value.field_cause;
break;
case RSL__IE__Body::ALT_access__delay:
delete single_value.field_access__delay;
break;
case RSL__IE__Body::ALT_rach__load:
delete single_value.field_rach__load;
break;
case RSL__IE__Body::ALT_meas__res__nr:
delete single_value.field_meas__res__nr;
break;
case RSL__IE__Body::ALT_ms__timing__offset:
delete single_value.field_ms__timing__offset;
break;
case RSL__IE__Body::ALT_uplink__meas:
delete single_value.field_uplink__meas;
break;
case RSL__IE__Body::ALT_l1__info:
delete single_value.field_l1__info;
break;
case RSL__IE__Body::ALT_sysinfo__type:
delete single_value.field_sysinfo__type;
break;
case RSL__IE__Body::ALT_paging__load:
delete single_value.field_paging__load;
break;
case RSL__IE__Body::ALT_paging__group:
delete single_value.field_paging__group;
break;
case RSL__IE__Body::ALT_chan__needed:
delete single_value.field_chan__needed;
break;
case RSL__IE__Body::ALT_cb__cmd__type:
delete single_value.field_cb__cmd__type;
break;
case RSL__IE__Body::ALT_smscb__message:
delete single_value.field_smscb__message;
break;
case RSL__IE__Body::ALT_cbch__load__info:
delete single_value.field_cbch__load__info;
break;
case RSL__IE__Body::ALT_resource__info:
delete single_value.field_resource__info;
break;
case RSL__IE__Body::ALT_sacch__info:
delete single_value.field_sacch__info;
break;
case RSL__IE__Body::ALT_starting__time:
delete single_value.field_starting__time;
break;
case RSL__IE__Body::ALT_encr__info:
delete single_value.field_encr__info;
break;
case RSL__IE__Body::ALT_smscb__chan__ind:
delete single_value.field_smscb__chan__ind;
break;
case RSL__IE__Body::ALT_req__ref:
delete single_value.field_req__ref;
break;
case RSL__IE__Body::ALT_full__imm__ass__info:
delete single_value.field_full__imm__ass__info;
break;
case RSL__IE__Body::ALT_ms__identity:
delete single_value.field_ms__identity;
break;
case RSL__IE__Body::ALT_group__call__ref:
delete single_value.field_group__call__ref;
break;
case RSL__IE__Body::ALT_group__chan__desc:
delete single_value.field_group__chan__desc;
break;
case RSL__IE__Body::ALT_nch__drx__info:
delete single_value.field_nch__drx__info;
break;
case RSL__IE__Body::ALT_cmd__indicator:
delete single_value.field_cmd__indicator;
break;
case RSL__IE__Body::ALT_uic:
delete single_value.field_uic;
break;
case RSL__IE__Body::ALT_ipa__conn__id:
delete single_value.field_ipa__conn__id;
break;
case RSL__IE__Body::ALT_ipa__local__port:
delete single_value.field_ipa__local__port;
break;
case RSL__IE__Body::ALT_ipa__remote__port:
delete single_value.field_ipa__remote__port;
break;
case RSL__IE__Body::ALT_ipa__local__ip:
delete single_value.field_ipa__local__ip;
break;
case RSL__IE__Body::ALT_ipa__remote__ip:
delete single_value.field_ipa__remote__ip;
break;
case RSL__IE__Body::ALT_ipa__rtp__pt:
delete single_value.field_ipa__rtp__pt;
break;
case RSL__IE__Body::ALT_ipa__rtp__pt2:
delete single_value.field_ipa__rtp__pt2;
break;
case RSL__IE__Body::ALT_ipa__stats:
delete single_value.field_ipa__stats;
break;
case RSL__IE__Body::ALT_ipa__speech__mode:
delete single_value.field_ipa__speech__mode;
break;
case RSL__IE__Body::ALT_ipa__rtp__csd__fmt:
delete single_value.field_ipa__rtp__csd__fmt;
break;
case RSL__IE__Body::ALT_osmo__training__sequence:
delete single_value.field_osmo__training__sequence;
break;
case RSL__IE__Body::ALT_rep__acch__cap:
delete single_value.field_rep__acch__cap;
break;
case RSL__IE__Body::ALT_top__acch__cap:
delete single_value.field_top__acch__cap;
break;
case RSL__IE__Body::ALT_osmux__cid:
delete single_value.field_osmux__cid;
break;
case RSL__IE__Body::ALT_other:
delete single_value.field_other;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RSL__IE__Body_template& RSL__IE__Body_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RSL__IE__Body_template& RSL__IE__Body_template::operator=(const RSL__IE__Body& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

RSL__IE__Body_template& RSL__IE__Body_template::operator=(const OPTIONAL<RSL__IE__Body>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const RSL__IE__Body&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @RSL_Types.RSL_IE_Body.");
}
return *this;
}

RSL__IE__Body_template& RSL__IE__Body_template::operator=(const RSL__IE__Body_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RSL__IE__Body_template::match(const RSL__IE__Body& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
RSL__IE__Body::union_selection_type value_selection = other_value.get_selection();
if (value_selection == RSL__IE__Body::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case RSL__IE__Body::ALT_chan__nr:
return single_value.field_chan__nr->match(other_value.chan__nr(), legacy);
case RSL__IE__Body::ALT_link__id:
return single_value.field_link__id->match(other_value.link__id(), legacy);
case RSL__IE__Body::ALT_l3__info:
return single_value.field_l3__info->match(other_value.l3__info(), legacy);
case RSL__IE__Body::ALT_rlm__cause:
return single_value.field_rlm__cause->match(other_value.rlm__cause(), legacy);
case RSL__IE__Body::ALT_release__mode:
return single_value.field_release__mode->match(other_value.release__mode(), legacy);
case RSL__IE__Body::ALT_act__type:
return single_value.field_act__type->match(other_value.act__type(), legacy);
case RSL__IE__Body::ALT_chan__ident:
return single_value.field_chan__ident->match(other_value.chan__ident(), legacy);
case RSL__IE__Body::ALT_chan__mode:
return single_value.field_chan__mode->match(other_value.chan__mode(), legacy);
case RSL__IE__Body::ALT_handover__ref:
return single_value.field_handover__ref->match(other_value.handover__ref(), legacy);
case RSL__IE__Body::ALT_bs__power:
return single_value.field_bs__power->match(other_value.bs__power(), legacy);
case RSL__IE__Body::ALT_bs__power__params:
return single_value.field_bs__power__params->match(other_value.bs__power__params(), legacy);
case RSL__IE__Body::ALT_ms__power:
return single_value.field_ms__power->match(other_value.ms__power(), legacy);
case RSL__IE__Body::ALT_ms__power__params:
return single_value.field_ms__power__params->match(other_value.ms__power__params(), legacy);
case RSL__IE__Body::ALT_timing__adv:
return single_value.field_timing__adv->match(other_value.timing__adv(), legacy);
case RSL__IE__Body::ALT_multirate__cfg:
return single_value.field_multirate__cfg->match(other_value.multirate__cfg(), legacy);
case RSL__IE__Body::ALT_multirate__ctrl:
return single_value.field_multirate__ctrl->match(other_value.multirate__ctrl(), legacy);
case RSL__IE__Body::ALT_msg__id:
return single_value.field_msg__id->match(other_value.msg__id(), legacy);
case RSL__IE__Body::ALT_frame__nr:
return single_value.field_frame__nr->match(other_value.frame__nr(), legacy);
case RSL__IE__Body::ALT_cause:
return single_value.field_cause->match(other_value.cause(), legacy);
case RSL__IE__Body::ALT_access__delay:
return single_value.field_access__delay->match(other_value.access__delay(), legacy);
case RSL__IE__Body::ALT_rach__load:
return single_value.field_rach__load->match(other_value.rach__load(), legacy);
case RSL__IE__Body::ALT_meas__res__nr:
return single_value.field_meas__res__nr->match(other_value.meas__res__nr(), legacy);
case RSL__IE__Body::ALT_ms__timing__offset:
return single_value.field_ms__timing__offset->match(other_value.ms__timing__offset(), legacy);
case RSL__IE__Body::ALT_uplink__meas:
return single_value.field_uplink__meas->match(other_value.uplink__meas(), legacy);
case RSL__IE__Body::ALT_l1__info:
return single_value.field_l1__info->match(other_value.l1__info(), legacy);
case RSL__IE__Body::ALT_sysinfo__type:
return single_value.field_sysinfo__type->match(other_value.sysinfo__type(), legacy);
case RSL__IE__Body::ALT_paging__load:
return single_value.field_paging__load->match(other_value.paging__load(), legacy);
case RSL__IE__Body::ALT_paging__group:
return single_value.field_paging__group->match(other_value.paging__group(), legacy);
case RSL__IE__Body::ALT_chan__needed:
return single_value.field_chan__needed->match(other_value.chan__needed(), legacy);
case RSL__IE__Body::ALT_cb__cmd__type:
return single_value.field_cb__cmd__type->match(other_value.cb__cmd__type(), legacy);
case RSL__IE__Body::ALT_smscb__message:
return single_value.field_smscb__message->match(other_value.smscb__message(), legacy);
case RSL__IE__Body::ALT_cbch__load__info:
return single_value.field_cbch__load__info->match(other_value.cbch__load__info(), legacy);
case RSL__IE__Body::ALT_resource__info:
return single_value.field_resource__info->match(other_value.resource__info(), legacy);
case RSL__IE__Body::ALT_sacch__info:
return single_value.field_sacch__info->match(other_value.sacch__info(), legacy);
case RSL__IE__Body::ALT_starting__time:
return single_value.field_starting__time->match(other_value.starting__time(), legacy);
case RSL__IE__Body::ALT_encr__info:
return single_value.field_encr__info->match(other_value.encr__info(), legacy);
case RSL__IE__Body::ALT_smscb__chan__ind:
return single_value.field_smscb__chan__ind->match(other_value.smscb__chan__ind(), legacy);
case RSL__IE__Body::ALT_req__ref:
return single_value.field_req__ref->match(other_value.req__ref(), legacy);
case RSL__IE__Body::ALT_full__imm__ass__info:
return single_value.field_full__imm__ass__info->match(other_value.full__imm__ass__info(), legacy);
case RSL__IE__Body::ALT_ms__identity:
return single_value.field_ms__identity->match(other_value.ms__identity(), legacy);
case RSL__IE__Body::ALT_group__call__ref:
return single_value.field_group__call__ref->match(other_value.group__call__ref(), legacy);
case RSL__IE__Body::ALT_group__chan__desc:
return single_value.field_group__chan__desc->match(other_value.group__chan__desc(), legacy);
case RSL__IE__Body::ALT_nch__drx__info:
return single_value.field_nch__drx__info->match(other_value.nch__drx__info(), legacy);
case RSL__IE__Body::ALT_cmd__indicator:
return single_value.field_cmd__indicator->match(other_value.cmd__indicator(), legacy);
case RSL__IE__Body::ALT_uic:
return single_value.field_uic->match(other_value.uic(), legacy);
case RSL__IE__Body::ALT_ipa__conn__id:
return single_value.field_ipa__conn__id->match(other_value.ipa__conn__id(), legacy);
case RSL__IE__Body::ALT_ipa__local__port:
return single_value.field_ipa__local__port->match(other_value.ipa__local__port(), legacy);
case RSL__IE__Body::ALT_ipa__remote__port:
return single_value.field_ipa__remote__port->match(other_value.ipa__remote__port(), legacy);
case RSL__IE__Body::ALT_ipa__local__ip:
return single_value.field_ipa__local__ip->match(other_value.ipa__local__ip(), legacy);
case RSL__IE__Body::ALT_ipa__remote__ip:
return single_value.field_ipa__remote__ip->match(other_value.ipa__remote__ip(), legacy);
case RSL__IE__Body::ALT_ipa__rtp__pt:
return single_value.field_ipa__rtp__pt->match(other_value.ipa__rtp__pt(), legacy);
case RSL__IE__Body::ALT_ipa__rtp__pt2:
return single_value.field_ipa__rtp__pt2->match(other_value.ipa__rtp__pt2(), legacy);
case RSL__IE__Body::ALT_ipa__stats:
return single_value.field_ipa__stats->match(other_value.ipa__stats(), legacy);
case RSL__IE__Body::ALT_ipa__speech__mode:
return single_value.field_ipa__speech__mode->match(other_value.ipa__speech__mode(), legacy);
case RSL__IE__Body::ALT_ipa__rtp__csd__fmt:
return single_value.field_ipa__rtp__csd__fmt->match(other_value.ipa__rtp__csd__fmt(), legacy);
case RSL__IE__Body::ALT_osmo__training__sequence:
return single_value.field_osmo__training__sequence->match(other_value.osmo__training__sequence(), legacy);
case RSL__IE__Body::ALT_rep__acch__cap:
return single_value.field_rep__acch__cap->match(other_value.rep__acch__cap(), legacy);
case RSL__IE__Body::ALT_top__acch__cap:
return single_value.field_top__acch__cap->match(other_value.top__acch__cap(), legacy);
case RSL__IE__Body::ALT_osmux__cid:
return single_value.field_osmux__cid->match(other_value.osmux__cid(), legacy);
case RSL__IE__Body::ALT_other:
return single_value.field_other->match(other_value.other(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @RSL_Types.RSL_IE_Body.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @RSL_Types.RSL_IE_Body.");
}
return FALSE;
}

boolean RSL__IE__Body_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case RSL__IE__Body::ALT_chan__nr:
return single_value.field_chan__nr->is_value();
case RSL__IE__Body::ALT_link__id:
return single_value.field_link__id->is_value();
case RSL__IE__Body::ALT_l3__info:
return single_value.field_l3__info->is_value();
case RSL__IE__Body::ALT_rlm__cause:
return single_value.field_rlm__cause->is_value();
case RSL__IE__Body::ALT_release__mode:
return single_value.field_release__mode->is_value();
case RSL__IE__Body::ALT_act__type:
return single_value.field_act__type->is_value();
case RSL__IE__Body::ALT_chan__ident:
return single_value.field_chan__ident->is_value();
case RSL__IE__Body::ALT_chan__mode:
return single_value.field_chan__mode->is_value();
case RSL__IE__Body::ALT_handover__ref:
return single_value.field_handover__ref->is_value();
case RSL__IE__Body::ALT_bs__power:
return single_value.field_bs__power->is_value();
case RSL__IE__Body::ALT_bs__power__params:
return single_value.field_bs__power__params->is_value();
case RSL__IE__Body::ALT_ms__power:
return single_value.field_ms__power->is_value();
case RSL__IE__Body::ALT_ms__power__params:
return single_value.field_ms__power__params->is_value();
case RSL__IE__Body::ALT_timing__adv:
return single_value.field_timing__adv->is_value();
case RSL__IE__Body::ALT_multirate__cfg:
return single_value.field_multirate__cfg->is_value();
case RSL__IE__Body::ALT_multirate__ctrl:
return single_value.field_multirate__ctrl->is_value();
case RSL__IE__Body::ALT_msg__id:
return single_value.field_msg__id->is_value();
case RSL__IE__Body::ALT_frame__nr:
return single_value.field_frame__nr->is_value();
case RSL__IE__Body::ALT_cause:
return single_value.field_cause->is_value();
case RSL__IE__Body::ALT_access__delay:
return single_value.field_access__delay->is_value();
case RSL__IE__Body::ALT_rach__load:
return single_value.field_rach__load->is_value();
case RSL__IE__Body::ALT_meas__res__nr:
return single_value.field_meas__res__nr->is_value();
case RSL__IE__Body::ALT_ms__timing__offset:
return single_value.field_ms__timing__offset->is_value();
case RSL__IE__Body::ALT_uplink__meas:
return single_value.field_uplink__meas->is_value();
case RSL__IE__Body::ALT_l1__info:
return single_value.field_l1__info->is_value();
case RSL__IE__Body::ALT_sysinfo__type:
return single_value.field_sysinfo__type->is_value();
case RSL__IE__Body::ALT_paging__load:
return single_value.field_paging__load->is_value();
case RSL__IE__Body::ALT_paging__group:
return single_value.field_paging__group->is_value();
case RSL__IE__Body::ALT_chan__needed:
return single_value.field_chan__needed->is_value();
case RSL__IE__Body::ALT_cb__cmd__type:
return single_value.field_cb__cmd__type->is_value();
case RSL__IE__Body::ALT_smscb__message:
return single_value.field_smscb__message->is_value();
case RSL__IE__Body::ALT_cbch__load__info:
return single_value.field_cbch__load__info->is_value();
case RSL__IE__Body::ALT_resource__info:
return single_value.field_resource__info->is_value();
case RSL__IE__Body::ALT_sacch__info:
return single_value.field_sacch__info->is_value();
case RSL__IE__Body::ALT_starting__time:
return single_value.field_starting__time->is_value();
case RSL__IE__Body::ALT_encr__info:
return single_value.field_encr__info->is_value();
case RSL__IE__Body::ALT_smscb__chan__ind:
return single_value.field_smscb__chan__ind->is_value();
case RSL__IE__Body::ALT_req__ref:
return single_value.field_req__ref->is_value();
case RSL__IE__Body::ALT_full__imm__ass__info:
return single_value.field_full__imm__ass__info->is_value();
case RSL__IE__Body::ALT_ms__identity:
return single_value.field_ms__identity->is_value();
case RSL__IE__Body::ALT_group__call__ref:
return single_value.field_group__call__ref->is_value();
case RSL__IE__Body::ALT_group__chan__desc:
return single_value.field_group__chan__desc->is_value();
case RSL__IE__Body::ALT_nch__drx__info:
return single_value.field_nch__drx__info->is_value();
case RSL__IE__Body::ALT_cmd__indicator:
return single_value.field_cmd__indicator->is_value();
case RSL__IE__Body::ALT_uic:
return single_value.field_uic->is_value();
case RSL__IE__Body::ALT_ipa__conn__id:
return single_value.field_ipa__conn__id->is_value();
case RSL__IE__Body::ALT_ipa__local__port:
return single_value.field_ipa__local__port->is_value();
case RSL__IE__Body::ALT_ipa__remote__port:
return single_value.field_ipa__remote__port->is_value();
case RSL__IE__Body::ALT_ipa__local__ip:
return single_value.field_ipa__local__ip->is_value();
case RSL__IE__Body::ALT_ipa__remote__ip:
return single_value.field_ipa__remote__ip->is_value();
case RSL__IE__Body::ALT_ipa__rtp__pt:
return single_value.field_ipa__rtp__pt->is_value();
case RSL__IE__Body::ALT_ipa__rtp__pt2:
return single_value.field_ipa__rtp__pt2->is_value();
case RSL__IE__Body::ALT_ipa__stats:
return single_value.field_ipa__stats->is_value();
case RSL__IE__Body::ALT_ipa__speech__mode:
return single_value.field_ipa__speech__mode->is_value();
case RSL__IE__Body::ALT_ipa__rtp__csd__fmt:
return single_value.field_ipa__rtp__csd__fmt->is_value();
case RSL__IE__Body::ALT_osmo__training__sequence:
return single_value.field_osmo__training__sequence->is_value();
case RSL__IE__Body::ALT_rep__acch__cap:
return single_value.field_rep__acch__cap->is_value();
case RSL__IE__Body::ALT_top__acch__cap:
return single_value.field_top__acch__cap->is_value();
case RSL__IE__Body::ALT_osmux__cid:
return single_value.field_osmux__cid->is_value();
case RSL__IE__Body::ALT_other:
return single_value.field_other->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @RSL_Types.RSL_IE_Body.");
}
}

RSL__IE__Body RSL__IE__Body_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @RSL_Types.RSL_IE_Body.");
RSL__IE__Body ret_val;
switch (single_value.union_selection) {
case RSL__IE__Body::ALT_chan__nr:
ret_val.chan__nr() = single_value.field_chan__nr->valueof();
break;
case RSL__IE__Body::ALT_link__id:
ret_val.link__id() = single_value.field_link__id->valueof();
break;
case RSL__IE__Body::ALT_l3__info:
ret_val.l3__info() = single_value.field_l3__info->valueof();
break;
case RSL__IE__Body::ALT_rlm__cause:
ret_val.rlm__cause() = single_value.field_rlm__cause->valueof();
break;
case RSL__IE__Body::ALT_release__mode:
ret_val.release__mode() = single_value.field_release__mode->valueof();
break;
case RSL__IE__Body::ALT_act__type:
ret_val.act__type() = single_value.field_act__type->valueof();
break;
case RSL__IE__Body::ALT_chan__ident:
ret_val.chan__ident() = single_value.field_chan__ident->valueof();
break;
case RSL__IE__Body::ALT_chan__mode:
ret_val.chan__mode() = single_value.field_chan__mode->valueof();
break;
case RSL__IE__Body::ALT_handover__ref:
ret_val.handover__ref() = single_value.field_handover__ref->valueof();
break;
case RSL__IE__Body::ALT_bs__power:
ret_val.bs__power() = single_value.field_bs__power->valueof();
break;
case RSL__IE__Body::ALT_bs__power__params:
ret_val.bs__power__params() = single_value.field_bs__power__params->valueof();
break;
case RSL__IE__Body::ALT_ms__power:
ret_val.ms__power() = single_value.field_ms__power->valueof();
break;
case RSL__IE__Body::ALT_ms__power__params:
ret_val.ms__power__params() = single_value.field_ms__power__params->valueof();
break;
case RSL__IE__Body::ALT_timing__adv:
ret_val.timing__adv() = single_value.field_timing__adv->valueof();
break;
case RSL__IE__Body::ALT_multirate__cfg:
ret_val.multirate__cfg() = single_value.field_multirate__cfg->valueof();
break;
case RSL__IE__Body::ALT_multirate__ctrl:
ret_val.multirate__ctrl() = single_value.field_multirate__ctrl->valueof();
break;
case RSL__IE__Body::ALT_msg__id:
ret_val.msg__id() = single_value.field_msg__id->valueof();
break;
case RSL__IE__Body::ALT_frame__nr:
ret_val.frame__nr() = single_value.field_frame__nr->valueof();
break;
case RSL__IE__Body::ALT_cause:
ret_val.cause() = single_value.field_cause->valueof();
break;
case RSL__IE__Body::ALT_access__delay:
ret_val.access__delay() = single_value.field_access__delay->valueof();
break;
case RSL__IE__Body::ALT_rach__load:
ret_val.rach__load() = single_value.field_rach__load->valueof();
break;
case RSL__IE__Body::ALT_meas__res__nr:
ret_val.meas__res__nr() = single_value.field_meas__res__nr->valueof();
break;
case RSL__IE__Body::ALT_ms__timing__offset:
ret_val.ms__timing__offset() = single_value.field_ms__timing__offset->valueof();
break;
case RSL__IE__Body::ALT_uplink__meas:
ret_val.uplink__meas() = single_value.field_uplink__meas->valueof();
break;
case RSL__IE__Body::ALT_l1__info:
ret_val.l1__info() = single_value.field_l1__info->valueof();
break;
case RSL__IE__Body::ALT_sysinfo__type:
ret_val.sysinfo__type() = single_value.field_sysinfo__type->valueof();
break;
case RSL__IE__Body::ALT_paging__load:
ret_val.paging__load() = single_value.field_paging__load->valueof();
break;
case RSL__IE__Body::ALT_paging__group:
ret_val.paging__group() = single_value.field_paging__group->valueof();
break;
case RSL__IE__Body::ALT_chan__needed:
ret_val.chan__needed() = single_value.field_chan__needed->valueof();
break;
case RSL__IE__Body::ALT_cb__cmd__type:
ret_val.cb__cmd__type() = single_value.field_cb__cmd__type->valueof();
break;
case RSL__IE__Body::ALT_smscb__message:
ret_val.smscb__message() = single_value.field_smscb__message->valueof();
break;
case RSL__IE__Body::ALT_cbch__load__info:
ret_val.cbch__load__info() = single_value.field_cbch__load__info->valueof();
break;
case RSL__IE__Body::ALT_resource__info:
ret_val.resource__info() = single_value.field_resource__info->valueof();
break;
case RSL__IE__Body::ALT_sacch__info:
ret_val.sacch__info() = single_value.field_sacch__info->valueof();
break;
case RSL__IE__Body::ALT_starting__time:
ret_val.starting__time() = single_value.field_starting__time->valueof();
break;
case RSL__IE__Body::ALT_encr__info:
ret_val.encr__info() = single_value.field_encr__info->valueof();
break;
case RSL__IE__Body::ALT_smscb__chan__ind:
ret_val.smscb__chan__ind() = single_value.field_smscb__chan__ind->valueof();
break;
case RSL__IE__Body::ALT_req__ref:
ret_val.req__ref() = single_value.field_req__ref->valueof();
break;
case RSL__IE__Body::ALT_full__imm__ass__info:
ret_val.full__imm__ass__info() = single_value.field_full__imm__ass__info->valueof();
break;
case RSL__IE__Body::ALT_ms__identity:
ret_val.ms__identity() = single_value.field_ms__identity->valueof();
break;
case RSL__IE__Body::ALT_group__call__ref:
ret_val.group__call__ref() = single_value.field_group__call__ref->valueof();
break;
case RSL__IE__Body::ALT_group__chan__desc:
ret_val.group__chan__desc() = single_value.field_group__chan__desc->valueof();
break;
case RSL__IE__Body::ALT_nch__drx__info:
ret_val.nch__drx__info() = single_value.field_nch__drx__info->valueof();
break;
case RSL__IE__Body::ALT_cmd__indicator:
ret_val.cmd__indicator() = single_value.field_cmd__indicator->valueof();
break;
case RSL__IE__Body::ALT_uic:
ret_val.uic() = single_value.field_uic->valueof();
break;
case RSL__IE__Body::ALT_ipa__conn__id:
ret_val.ipa__conn__id() = single_value.field_ipa__conn__id->valueof();
break;
case RSL__IE__Body::ALT_ipa__local__port:
ret_val.ipa__local__port() = single_value.field_ipa__local__port->valueof();
break;
case RSL__IE__Body::ALT_ipa__remote__port:
ret_val.ipa__remote__port() = single_value.field_ipa__remote__port->valueof();
break;
case RSL__IE__Body::ALT_ipa__local__ip:
ret_val.ipa__local__ip() = single_value.field_ipa__local__ip->valueof();
break;
case RSL__IE__Body::ALT_ipa__remote__ip:
ret_val.ipa__remote__ip() = single_value.field_ipa__remote__ip->valueof();
break;
case RSL__IE__Body::ALT_ipa__rtp__pt:
ret_val.ipa__rtp__pt() = single_value.field_ipa__rtp__pt->valueof();
break;
case RSL__IE__Body::ALT_ipa__rtp__pt2:
ret_val.ipa__rtp__pt2() = single_value.field_ipa__rtp__pt2->valueof();
break;
case RSL__IE__Body::ALT_ipa__stats:
ret_val.ipa__stats() = single_value.field_ipa__stats->valueof();
break;
case RSL__IE__Body::ALT_ipa__speech__mode:
ret_val.ipa__speech__mode() = single_value.field_ipa__speech__mode->valueof();
break;
case RSL__IE__Body::ALT_ipa__rtp__csd__fmt:
ret_val.ipa__rtp__csd__fmt() = single_value.field_ipa__rtp__csd__fmt->valueof();
break;
case RSL__IE__Body::ALT_osmo__training__sequence:
ret_val.osmo__training__sequence() = single_value.field_osmo__training__sequence->valueof();
break;
case RSL__IE__Body::ALT_rep__acch__cap:
ret_val.rep__acch__cap() = single_value.field_rep__acch__cap->valueof();
break;
case RSL__IE__Body::ALT_top__acch__cap:
ret_val.top__acch__cap() = single_value.field_top__acch__cap->valueof();
break;
case RSL__IE__Body::ALT_osmux__cid:
ret_val.osmux__cid() = single_value.field_osmux__cid->valueof();
break;
case RSL__IE__Body::ALT_other:
ret_val.other() = single_value.field_other->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @RSL_Types.RSL_IE_Body.");
}
return ret_val;
}

RSL__IE__Body_template& RSL__IE__Body_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @RSL_Types.RSL_IE_Body.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @RSL_Types.RSL_IE_Body.");
return value_list.list_value[list_index];
}
void RSL__IE__Body_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @RSL_Types.RSL_IE_Body.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RSL__IE__Body_template[list_length];
}

GSM__Types::RslChannelNr_template& RSL__IE__Body_template::chan__nr()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RSL__IE__Body::ALT_chan__nr) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_chan__nr = new GSM__Types::RslChannelNr_template(ANY_VALUE);
else single_value.field_chan__nr = new GSM__Types::RslChannelNr_template;
single_value.union_selection = RSL__IE__Body::ALT_chan__nr;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_chan__nr;
}

const GSM__Types::RslChannelNr_template& RSL__IE__Body_template::chan__nr() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field chan_nr in a non-specific template of union type @RSL_Types.RSL_IE_Body.");
if (single_value.union_selection != RSL__IE__Body::ALT_chan__nr) TTCN_error("Accessing non-selected field chan_nr in a template of union type @RSL_Types.RSL_IE_Body.");
return *single_value.field_chan__nr;
}

GSM__Types::RslLinkId_template& RSL__IE__Body_template::link__id()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RSL__IE__Body::ALT_link__id) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_link__id = new GSM__Types::RslLinkId_template(ANY_VALUE);
else single_value.field_link__id = new GSM__Types::RslLinkId_template;
single_value.union_selection = RSL__IE__Body::ALT_link__id;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_link__id;
}

const GSM__Types::RslLinkId_template& RSL__IE__Body_template::link__id() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field link_id in a non-specific template of union type @RSL_Types.RSL_IE_Body.");
if (single_value.union_selection != RSL__IE__Body::ALT_link__id) TTCN_error("Accessing non-selected field link_id in a template of union type @RSL_Types.RSL_IE_Body.");
return *single_value.field_link__id;
}

RSL__L16V_template& RSL__IE__Body_template::l3__info()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RSL__IE__Body::ALT_l3__info) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_l3__info = new RSL__L16V_template(ANY_VALUE);
else single_value.field_l3__info = new RSL__L16V_template;
single_value.union_selection = RSL__IE__Body::ALT_l3__info;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_l3__info;
}

const RSL__L16V_template& RSL__IE__Body_template::l3__info() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field l3_info in a non-specific template of union type @RSL_Types.RSL_IE_Body.");
if (single_value.union_selection != RSL__IE__Body::ALT_l3__info) TTCN_error("Accessing non-selected field l3_info in a template of union type @RSL_Types.RSL_IE_Body.");
return *single_value.field_l3__info;
}

RSL__LV_template& RSL__IE__Body_template::rlm__cause()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RSL__IE__Body::ALT_rlm__cause) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_rlm__cause = new RSL__LV_template(ANY_VALUE);
else single_value.field_rlm__cause = new RSL__LV_template;
single_value.union_selection = RSL__IE__Body::ALT_rlm__cause;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_rlm__cause;
}

const RSL__LV_template& RSL__IE__Body_template::rlm__cause() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field rlm_cause in a non-specific template of union type @RSL_Types.RSL_IE_Body.");
if (single_value.union_selection != RSL__IE__Body::ALT_rlm__cause) TTCN_error("Accessing non-selected field rlm_cause in a template of union type @RSL_Types.RSL_IE_Body.");
return *single_value.field_rlm__cause;
}

RSL__IE__ReleaseMode_template& RSL__IE__Body_template::release__mode()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RSL__IE__Body::ALT_release__mode) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_release__mode = new RSL__IE__ReleaseMode_template(ANY_VALUE);
else single_value.field_release__mode = new RSL__IE__ReleaseMode_template;
single_value.union_selection = RSL__IE__Body::ALT_release__mode;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_release__mode;
}

const RSL__IE__ReleaseMode_template& RSL__IE__Body_template::release__mode() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field release_mode in a non-specific template of union type @RSL_Types.RSL_IE_Body.");
if (single_value.union_selection != RSL__IE__Body::ALT_release__mode) TTCN_error("Accessing non-selected field release_mode in a template of union type @RSL_Types.RSL_IE_Body.");
return *single_value.field_release__mode;
}

RSL__IE__ActivationType_template& RSL__IE__Body_template::act__type()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RSL__IE__Body::ALT_act__type) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_act__type = new RSL__IE__ActivationType_template(ANY_VALUE);
else single_value.field_act__type = new RSL__IE__ActivationType_template;
single_value.union_selection = RSL__IE__Body::ALT_act__type;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_act__type;
}

const RSL__IE__ActivationType_template& RSL__IE__Body_template::act__type() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field act_type in a non-specific template of union type @RSL_Types.RSL_IE_Body.");
if (single_value.union_selection != RSL__IE__Body::ALT_act__type) TTCN_error("Accessing non-selected field act_type in a template of union type @RSL_Types.RSL_IE_Body.");
return *single_value.field_act__type;
}

RSL__IE__ChannelIdent_template& RSL__IE__Body_template::chan__ident()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RSL__IE__Body::ALT_chan__ident) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_chan__ident = new RSL__IE__ChannelIdent_template(ANY_VALUE);
else single_value.field_chan__ident = new RSL__IE__ChannelIdent_template;
single_value.union_selection = RSL__IE__Body::ALT_chan__ident;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_chan__ident;
}

const RSL__IE__ChannelIdent_template& RSL__IE__Body_template::chan__ident() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field chan_ident in a non-specific template of union type @RSL_Types.RSL_IE_Body.");
if (single_value.union_selection != RSL__IE__Body::ALT_chan__ident) TTCN_error("Accessing non-selected field chan_ident in a template of union type @RSL_Types.RSL_IE_Body.");
return *single_value.field_chan__ident;
}

RSL__IE__ChannelMode_template& RSL__IE__Body_template::chan__mode()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RSL__IE__Body::ALT_chan__mode) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_chan__mode = new RSL__IE__ChannelMode_template(ANY_VALUE);
else single_value.field_chan__mode = new RSL__IE__ChannelMode_template;
single_value.union_selection = RSL__IE__Body::ALT_chan__mode;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_chan__mode;
}

const RSL__IE__ChannelMode_template& RSL__IE__Body_template::chan__mode() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field chan_mode in a non-specific template of union type @RSL_Types.RSL_IE_Body.");
if (single_value.union_selection != RSL__IE__Body::ALT_chan__mode) TTCN_error("Accessing non-selected field chan_mode in a template of union type @RSL_Types.RSL_IE_Body.");
return *single_value.field_chan__mode;
}

INTEGER_template& RSL__IE__Body_template::handover__ref()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RSL__IE__Body::ALT_handover__ref) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_handover__ref = new INTEGER_template(ANY_VALUE);
else single_value.field_handover__ref = new INTEGER_template;
single_value.union_selection = RSL__IE__Body::ALT_handover__ref;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_handover__ref;
}

const INTEGER_template& RSL__IE__Body_template::handover__ref() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field handover_ref in a non-specific template of union type @RSL_Types.RSL_IE_Body.");
if (single_value.union_selection != RSL__IE__Body::ALT_handover__ref) TTCN_error("Accessing non-selected field handover_ref in a template of union type @RSL_Types.RSL_IE_Body.");
return *single_value.field_handover__ref;
}

RSL__IE__BS__Power_template& RSL__IE__Body_template::bs__power()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RSL__IE__Body::ALT_bs__power) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_bs__power = new RSL__IE__BS__Power_template(ANY_VALUE);
else single_value.field_bs__power = new RSL__IE__BS__Power_template;
single_value.union_selection = RSL__IE__Body::ALT_bs__power;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_bs__power;
}

const RSL__IE__BS__Power_template& RSL__IE__Body_template::bs__power() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field bs_power in a non-specific template of union type @RSL_Types.RSL_IE_Body.");
if (single_value.union_selection != RSL__IE__Body::ALT_bs__power) TTCN_error("Accessing non-selected field bs_power in a template of union type @RSL_Types.RSL_IE_Body.");
return *single_value.field_bs__power;
}

RSL__LV_template& RSL__IE__Body_template::bs__power__params()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RSL__IE__Body::ALT_bs__power__params) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_bs__power__params = new RSL__LV_template(ANY_VALUE);
else single_value.field_bs__power__params = new RSL__LV_template;
single_value.union_selection = RSL__IE__Body::ALT_bs__power__params;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_bs__power__params;
}

const RSL__LV_template& RSL__IE__Body_template::bs__power__params() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field bs_power_params in a non-specific template of union type @RSL_Types.RSL_IE_Body.");
if (single_value.union_selection != RSL__IE__Body::ALT_bs__power__params) TTCN_error("Accessing non-selected field bs_power_params in a template of union type @RSL_Types.RSL_IE_Body.");
return *single_value.field_bs__power__params;
}

RSL__IE__MS__Power_template& RSL__IE__Body_template::ms__power()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RSL__IE__Body::ALT_ms__power) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_ms__power = new RSL__IE__MS__Power_template(ANY_VALUE);
else single_value.field_ms__power = new RSL__IE__MS__Power_template;
single_value.union_selection = RSL__IE__Body::ALT_ms__power;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_ms__power;
}

const RSL__IE__MS__Power_template& RSL__IE__Body_template::ms__power() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field ms_power in a non-specific template of union type @RSL_Types.RSL_IE_Body.");
if (single_value.union_selection != RSL__IE__Body::ALT_ms__power) TTCN_error("Accessing non-selected field ms_power in a template of union type @RSL_Types.RSL_IE_Body.");
return *single_value.field_ms__power;
}

RSL__IE__MS__Power__Parameters_template& RSL__IE__Body_template::ms__power__params()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RSL__IE__Body::ALT_ms__power__params) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_ms__power__params = new RSL__IE__MS__Power__Parameters_template(ANY_VALUE);
else single_value.field_ms__power__params = new RSL__IE__MS__Power__Parameters_template;
single_value.union_selection = RSL__IE__Body::ALT_ms__power__params;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_ms__power__params;
}

const RSL__IE__MS__Power__Parameters_template& RSL__IE__Body_template::ms__power__params() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field ms_power_params in a non-specific template of union type @RSL_Types.RSL_IE_Body.");
if (single_value.union_selection != RSL__IE__Body::ALT_ms__power__params) TTCN_error("Accessing non-selected field ms_power_params in a template of union type @RSL_Types.RSL_IE_Body.");
return *single_value.field_ms__power__params;
}

INTEGER_template& RSL__IE__Body_template::timing__adv()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RSL__IE__Body::ALT_timing__adv) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_timing__adv = new INTEGER_template(ANY_VALUE);
else single_value.field_timing__adv = new INTEGER_template;
single_value.union_selection = RSL__IE__Body::ALT_timing__adv;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_timing__adv;
}

const INTEGER_template& RSL__IE__Body_template::timing__adv() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field timing_adv in a non-specific template of union type @RSL_Types.RSL_IE_Body.");
if (single_value.union_selection != RSL__IE__Body::ALT_timing__adv) TTCN_error("Accessing non-selected field timing_adv in a template of union type @RSL_Types.RSL_IE_Body.");
return *single_value.field_timing__adv;
}

RSL__IE__MultirateCfg_template& RSL__IE__Body_template::multirate__cfg()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RSL__IE__Body::ALT_multirate__cfg) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_multirate__cfg = new RSL__IE__MultirateCfg_template(ANY_VALUE);
else single_value.field_multirate__cfg = new RSL__IE__MultirateCfg_template;
single_value.union_selection = RSL__IE__Body::ALT_multirate__cfg;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_multirate__cfg;
}

const RSL__IE__MultirateCfg_template& RSL__IE__Body_template::multirate__cfg() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field multirate_cfg in a non-specific template of union type @RSL_Types.RSL_IE_Body.");
if (single_value.union_selection != RSL__IE__Body::ALT_multirate__cfg) TTCN_error("Accessing non-selected field multirate_cfg in a template of union type @RSL_Types.RSL_IE_Body.");
return *single_value.field_multirate__cfg;
}

RSL__IE__MultirateCtrl_template& RSL__IE__Body_template::multirate__ctrl()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RSL__IE__Body::ALT_multirate__ctrl) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_multirate__ctrl = new RSL__IE__MultirateCtrl_template(ANY_VALUE);
else single_value.field_multirate__ctrl = new RSL__IE__MultirateCtrl_template;
single_value.union_selection = RSL__IE__Body::ALT_multirate__ctrl;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_multirate__ctrl;
}

const RSL__IE__MultirateCtrl_template& RSL__IE__Body_template::multirate__ctrl() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field multirate_ctrl in a non-specific template of union type @RSL_Types.RSL_IE_Body.");
if (single_value.union_selection != RSL__IE__Body::ALT_multirate__ctrl) TTCN_error("Accessing non-selected field multirate_ctrl in a template of union type @RSL_Types.RSL_IE_Body.");
return *single_value.field_multirate__ctrl;
}

INTEGER_template& RSL__IE__Body_template::msg__id()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RSL__IE__Body::ALT_msg__id) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_msg__id = new INTEGER_template(ANY_VALUE);
else single_value.field_msg__id = new INTEGER_template;
single_value.union_selection = RSL__IE__Body::ALT_msg__id;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_msg__id;
}

const INTEGER_template& RSL__IE__Body_template::msg__id() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field msg_id in a non-specific template of union type @RSL_Types.RSL_IE_Body.");
if (single_value.union_selection != RSL__IE__Body::ALT_msg__id) TTCN_error("Accessing non-selected field msg_id in a template of union type @RSL_Types.RSL_IE_Body.");
return *single_value.field_msg__id;
}

RSL__IE__FrameNumber_template& RSL__IE__Body_template::frame__nr()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RSL__IE__Body::ALT_frame__nr) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_frame__nr = new RSL__IE__FrameNumber_template(ANY_VALUE);
else single_value.field_frame__nr = new RSL__IE__FrameNumber_template;
single_value.union_selection = RSL__IE__Body::ALT_frame__nr;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_frame__nr;
}

const RSL__IE__FrameNumber_template& RSL__IE__Body_template::frame__nr() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field frame_nr in a non-specific template of union type @RSL_Types.RSL_IE_Body.");
if (single_value.union_selection != RSL__IE__Body::ALT_frame__nr) TTCN_error("Accessing non-selected field frame_nr in a template of union type @RSL_Types.RSL_IE_Body.");
return *single_value.field_frame__nr;
}

RSL__IE__Cause_template& RSL__IE__Body_template::cause()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RSL__IE__Body::ALT_cause) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_cause = new RSL__IE__Cause_template(ANY_VALUE);
else single_value.field_cause = new RSL__IE__Cause_template;
single_value.union_selection = RSL__IE__Body::ALT_cause;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_cause;
}

const RSL__IE__Cause_template& RSL__IE__Body_template::cause() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field cause in a non-specific template of union type @RSL_Types.RSL_IE_Body.");
if (single_value.union_selection != RSL__IE__Body::ALT_cause) TTCN_error("Accessing non-selected field cause in a template of union type @RSL_Types.RSL_IE_Body.");
return *single_value.field_cause;
}

INTEGER_template& RSL__IE__Body_template::access__delay()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != RSL__IE__Body::ALT_access__delay) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_access__delay = new INTEGER_template(ANY_VALUE);
else single_value.field_access__delay = new INTEGER_template;
single_value.union_selection = RSL__IE__Body::ALT_access__delay;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_access__delay;
}

const INTEGER_template& RSL__IE__Body_template::access__delay() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field access_delay in a non-specific template of union type @RSL_Types.RSL_IE_Body.");
if (single_value.union_selection != RSL__IE__Body::ALT_access__delay) TTCN_error("Accessing n