/*!
 * \file      NGAPPort.hh
 * \brief     Header file for NGAPPort.
 * \author    ETSI TTF041
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */

#pragma once

#include "LibNGAP_Interface.hh"
#include "NGAP_PDU_Descriptions.hh"

#include "layer.hh"
#include "params.hh"

namespace NGAP__PDU__Descriptions{
  class NGAP__PDU;
}
namespace LibNGAP__Interface {

  class  NGAPPort : public NGAPPort_BASE {
    params _cfg_params;
    params _layer_params;
    layer* _layer;
    std::string _time_key;
  public:
     NGAPPort(const char *par_port_name);
    ~ NGAPPort();
    
    //inline const char *get_name() const { return port_name; }
    void set_parameter(const char *parameter_name, const char *parameter_value);
    void receiveMsg (const NGAP__PDU__Descriptions::NGAP__PDU& p_ind, const params& p_params);
    
  private:
    /* void Handle_Fd_Event(int fd, boolean is_readable,
       boolean is_writable, boolean is_error); */
    void Handle_Fd_Event_Error(int fd);
    void Handle_Fd_Event_Writable(int fd);
    void Handle_Fd_Event_Readable(int fd);
    /* void Handle_Timeout(double time_since_last_call); */

  protected:
    const char *port_name;
    void user_map(const char *system_port);
    void user_unmap(const char *system_port);

    void user_start();
    void user_stop();

  protected:
    void outgoing_send(const NGAP__PDU__Descriptions::NGAP__PDU& send_par);
  }; // End of class  NGAPPort

} // End of namespace LibNGAP__Interface

