// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "DIAMETER_Types.hh"

namespace DIAMETER__Types {

/* Member functions of C++ classes */

AddressType::AddressType()
{
enum_value = UNBOUND_VALUE;
}

AddressType::AddressType(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.AddressType with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

AddressType::AddressType(enum_type other_value)
{
enum_value = other_value;
}

AddressType::AddressType(const AddressType& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.AddressType.");
enum_value = other_value.enum_value;
}

AddressType& AddressType::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.AddressType.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

AddressType& AddressType::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

AddressType& AddressType::operator=(const AddressType& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.AddressType.");
enum_value = other_value.enum_value;
return *this;
}

boolean AddressType::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AddressType.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.AddressType comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean AddressType::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AddressType.");
return enum_value == other_value;
}

boolean AddressType::operator==(const AddressType& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AddressType.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AddressType.");
return enum_value == other_value.enum_value;
}

boolean AddressType::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AddressType.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.AddressType comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean AddressType::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AddressType.");
return enum_value < other_value;
}

boolean AddressType::operator<(const AddressType& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AddressType.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AddressType.");
return enum_value < other_value.enum_value;
}

boolean AddressType::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AddressType.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.AddressType comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean AddressType::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AddressType.");
return enum_value > other_value;
}

boolean AddressType::operator>(const AddressType& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AddressType.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AddressType.");
return enum_value > other_value.enum_value;
}

const char *AddressType::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case Reserved__0: return "Reserved_0";
case IP: return "IP";
case IP6: return "IP6";
case NSAP: return "NSAP";
case HDLC: return "HDLC";
case BBN1822: return "BBN1822";
case IEEE802: return "IEEE802";
case E163: return "E163";
case E164: return "E164";
case F69: return "F69";
case X121: return "X121";
case IPX: return "IPX";
case Appletalk: return "Appletalk";
case Decnet__IV: return "Decnet_IV";
case Banyan__Vines: return "Banyan_Vines";
case E164__NSAP: return "E164_NSAP";
case DNS: return "DNS";
case Distinguished__Name: return "Distinguished_Name";
case AS__Number: return "AS_Number";
case XTP__IP: return "XTP_IP";
case XTP__IP6: return "XTP_IP6";
case XTP__native: return "XTP_native";
case Fibre__Channel__WW__Port: return "Fibre_Channel_WW_Port";
case Fibre__Channel__WW__Node: return "Fibre_Channel_WW_Node";
case GWID: return "GWID";
case Reserved__65535: return "Reserved_65535";
default:
return "<unknown>";
}
}

AddressType::enum_type AddressType::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "Reserved_0")) return Reserved__0;
if (!strcmp(str_par, "IP")) return IP;
if (!strcmp(str_par, "IP6")) return IP6;
if (!strcmp(str_par, "NSAP")) return NSAP;
if (!strcmp(str_par, "HDLC")) return HDLC;
if (!strcmp(str_par, "BBN1822")) return BBN1822;
if (!strcmp(str_par, "IEEE802")) return IEEE802;
if (!strcmp(str_par, "E163")) return E163;
if (!strcmp(str_par, "E164")) return E164;
if (!strcmp(str_par, "F69")) return F69;
if (!strcmp(str_par, "X121")) return X121;
if (!strcmp(str_par, "IPX")) return IPX;
if (!strcmp(str_par, "Appletalk")) return Appletalk;
if (!strcmp(str_par, "Decnet_IV")) return Decnet__IV;
if (!strcmp(str_par, "Banyan_Vines")) return Banyan__Vines;
if (!strcmp(str_par, "E164_NSAP")) return E164__NSAP;
if (!strcmp(str_par, "DNS")) return DNS;
if (!strcmp(str_par, "Distinguished_Name")) return Distinguished__Name;
if (!strcmp(str_par, "AS_Number")) return AS__Number;
if (!strcmp(str_par, "XTP_IP")) return XTP__IP;
if (!strcmp(str_par, "XTP_IP6")) return XTP__IP6;
if (!strcmp(str_par, "XTP_native")) return XTP__native;
if (!strcmp(str_par, "Fibre_Channel_WW_Port")) return Fibre__Channel__WW__Port;
if (!strcmp(str_par, "Fibre_Channel_WW_Node")) return Fibre__Channel__WW__Node;
if (!strcmp(str_par, "GWID")) return GWID;
if (!strcmp(str_par, "Reserved_65535")) return Reserved__65535;
}
return UNKNOWN_VALUE;
}

boolean AddressType::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
case 4:
case 5:
case 6:
case 7:
case 8:
case 9:
case 10:
case 11:
case 12:
case 13:
case 14:
case 15:
case 16:
case 17:
case 18:
case 19:
case 20:
case 21:
case 22:
case 23:
case 24:
case 65535:
return TRUE;
default:
return FALSE;
}
}

int AddressType::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.AddressType.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int AddressType::enum2int(const AddressType& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.AddressType.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void AddressType::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.AddressType.", int_val);
enum_value = (enum_type)int_val;
}

AddressType::operator AddressType::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.AddressType.");
return enum_value;
}

void AddressType::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void AddressType::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.AddressType");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.AddressType.");
  }
}

void AddressType::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.AddressType.");
text_buf.push_int(enum_value);
}

void AddressType::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.AddressType.", enum_value);
}

void AddressType::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void AddressType::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int AddressType::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 16, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int AddressType::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 16);
}

void AddressType_template::copy_template(const AddressType_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new AddressType_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new AddressType_template(*other_value.implication_.precondition);
implication_.implied_template = new AddressType_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.AddressType.");
}
}

AddressType_template::AddressType_template()
{
}

AddressType_template::AddressType_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

AddressType_template::AddressType_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!AddressType::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.AddressType with unknown numeric value %d.", other_value);
single_value = (AddressType::enum_type)other_value;
}

AddressType_template::AddressType_template(AddressType::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

AddressType_template::AddressType_template(const AddressType& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == AddressType::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.AddressType.");
single_value = other_value.enum_value;
}

AddressType_template::AddressType_template(const OPTIONAL<AddressType>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (AddressType::enum_type)(const AddressType&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.AddressType from an unbound optional field.");
}
}

AddressType_template::AddressType_template(AddressType_template* p_precondition, AddressType_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

AddressType_template::AddressType_template(Dynamic_Match_Interface<AddressType>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<AddressType>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

AddressType_template::AddressType_template(const AddressType_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

AddressType_template::~AddressType_template()
{
clean_up();
}

boolean AddressType_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean AddressType_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != AddressType::UNBOUND_VALUE;
}

void AddressType_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

AddressType_template& AddressType_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

AddressType_template& AddressType_template::operator=(int other_value)
{
if (!AddressType::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.AddressType.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (AddressType::enum_type)other_value;
return *this;
}

AddressType_template& AddressType_template::operator=(AddressType::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

AddressType_template& AddressType_template::operator=(const AddressType& other_value)
{
if (other_value.enum_value == AddressType::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.AddressType to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

AddressType_template& AddressType_template::operator=(const OPTIONAL<AddressType>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (AddressType::enum_type)(const AddressType&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.AddressType.");
}
return *this;
}

AddressType_template& AddressType_template::operator=(const AddressType_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean AddressType_template::match(AddressType::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.AddressType.");
}
return FALSE;
}

boolean AddressType_template::match(const AddressType& other_value, boolean) const
{
if (other_value.enum_value == AddressType::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.AddressType with an unbound value.");
return match(other_value.enum_value);
}

AddressType::enum_type AddressType_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.AddressType.");
return single_value;
}

void AddressType_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new AddressType_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.AddressType.");
}
}

AddressType_template& AddressType_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.AddressType.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.AddressType.");
return value_list.list_value[list_index];
}

void AddressType_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(AddressType::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void AddressType_template::log_match(const AddressType& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void AddressType_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.AddressType.");
}
}

void AddressType_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (AddressType::enum_type)text_buf.pull_int().get_val();
if (!AddressType::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.AddressType.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new AddressType_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.AddressType.");
}
}

boolean AddressType_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean AddressType_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void AddressType_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    AddressType_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    AddressType::enum_type enum_val = AddressType::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!AddressType::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.AddressType.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    AddressType_template* precondition = new AddressType_template;
    precondition->set_param(*m_p->get_elem(0));
    AddressType_template* implied_template = new AddressType_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = AddressType_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.AddressType");
  }
  is_ifpresent = param.get_ifpresent();
}

void AddressType_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.AddressType");
}

AVP__Address::AVP__Address()
{
}

AVP__Address::AVP__Address(const AddressType& par_address__type,
    const OCTETSTRING& par_address__data)
  :   field_address__type(par_address__type),
  field_address__data(par_address__data)
{
}

AVP__Address::AVP__Address(const AVP__Address& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @DIAMETER_Types.AVP_Address.");
if (other_value.address__type().is_bound()) field_address__type = other_value.address__type();
else field_address__type.clean_up();
if (other_value.address__data().is_bound()) field_address__data = other_value.address__data();
else field_address__data.clean_up();
}

void AVP__Address::clean_up()
{
field_address__type.clean_up();
field_address__data.clean_up();
}

const TTCN_Typedescriptor_t* AVP__Address::get_descriptor() const { return &AVP__Address_descr_; }
AVP__Address& AVP__Address::operator=(const AVP__Address& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @DIAMETER_Types.AVP_Address.");
  if (other_value.address__type().is_bound()) field_address__type = other_value.address__type();
  else field_address__type.clean_up();
  if (other_value.address__data().is_bound()) field_address__data = other_value.address__data();
  else field_address__data.clean_up();
}
return *this;
}

boolean AVP__Address::operator==(const AVP__Address& other_value) const
{
return field_address__type==other_value.field_address__type
  && field_address__data==other_value.field_address__data;
}

boolean AVP__Address::is_bound() const
{
return (field_address__type.is_bound())
  || (field_address__data.is_bound());
}
boolean AVP__Address::is_value() const
{
return field_address__type.is_value()
  && field_address__data.is_value();
}
void AVP__Address::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ address_type := ");
field_address__type.log();
TTCN_Logger::log_event_str(", address_data := ");
field_address__data.log();
TTCN_Logger::log_event_str(" }");
}

void AVP__Address::set_implicit_omit()
{
if (address__type().is_bound()) address__type().set_implicit_omit();
if (address__data().is_bound()) address__data().set_implicit_omit();
}

void AVP__Address::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @DIAMETER_Types.AVP_Address has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) address__type().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) address__data().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "address_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          address__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "address_data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          address__data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @DIAMETER_Types.AVP_Address: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@DIAMETER_Types.AVP_Address");
  }
}

void AVP__Address::encode_text(Text_Buf& text_buf) const
{
field_address__type.encode_text(text_buf);
field_address__data.encode_text(text_buf);
}

void AVP__Address::decode_text(Text_Buf& text_buf)
{
field_address__type.decode_text(text_buf);
field_address__data.decode_text(text_buf);
}

void AVP__Address::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void AVP__Address::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int AVP__Address::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, AddressType_descr_.raw->forceomit);
  decoded_field_length = field_address__type.RAW_decode(AddressType_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_1_force_omit(1, force_omit, OCTETSTRING_descr_.raw->forceomit);
  decoded_field_length = field_address__data.RAW_decode(OCTETSTRING_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int AVP__Address::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, AddressType_descr_.raw);
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, OCTETSTRING_descr_.raw);
  encoded_length += field_address__type.RAW_encode(AddressType_descr_, *myleaf.body.node.nodes[0]);
  encoded_length += field_address__data.RAW_encode(OCTETSTRING_descr_, *myleaf.body.node.nodes[1]);
  return myleaf.length = encoded_length;
}

struct AVP__Address_template::single_value_struct {
AddressType_template field_address__type;
OCTETSTRING_template field_address__data;
};

void AVP__Address_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_address__type = ANY_VALUE;
single_value->field_address__data = ANY_VALUE;
}
}
}

void AVP__Address_template::copy_value(const AVP__Address& other_value)
{
single_value = new single_value_struct;
if (other_value.address__type().is_bound()) {
  single_value->field_address__type = other_value.address__type();
} else {
  single_value->field_address__type.clean_up();
}
if (other_value.address__data().is_bound()) {
  single_value->field_address__data = other_value.address__data();
} else {
  single_value->field_address__data.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void AVP__Address_template::copy_template(const AVP__Address_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.address__type().get_selection()) {
single_value->field_address__type = other_value.address__type();
} else {
single_value->field_address__type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.address__data().get_selection()) {
single_value->field_address__data = other_value.address__data();
} else {
single_value->field_address__data.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new AVP__Address_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new AVP__Address_template(*other_value.implication_.precondition);
implication_.implied_template = new AVP__Address_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @DIAMETER_Types.AVP_Address.");
break;
}
set_selection(other_value);
}

AVP__Address_template::AVP__Address_template()
{
}

AVP__Address_template::AVP__Address_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

AVP__Address_template::AVP__Address_template(const AVP__Address& other_value)
{
copy_value(other_value);
}

AVP__Address_template::AVP__Address_template(const OPTIONAL<AVP__Address>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const AVP__Address&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @DIAMETER_Types.AVP_Address from an unbound optional field.");
}
}

AVP__Address_template::AVP__Address_template(AVP__Address_template* p_precondition, AVP__Address_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

AVP__Address_template::AVP__Address_template(Dynamic_Match_Interface<AVP__Address>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<AVP__Address>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

AVP__Address_template::AVP__Address_template(const AVP__Address_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

AVP__Address_template::~AVP__Address_template()
{
clean_up();
}

AVP__Address_template& AVP__Address_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

AVP__Address_template& AVP__Address_template::operator=(const AVP__Address& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

AVP__Address_template& AVP__Address_template::operator=(const OPTIONAL<AVP__Address>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const AVP__Address&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @DIAMETER_Types.AVP_Address.");
}
return *this;
}

AVP__Address_template& AVP__Address_template::operator=(const AVP__Address_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean AVP__Address_template::match(const AVP__Address& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.address__type().is_bound()) return FALSE;
if(!single_value->field_address__type.match(other_value.address__type(), legacy))return FALSE;
if(!other_value.address__data().is_bound()) return FALSE;
if(!single_value->field_address__data.match(other_value.address__data(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @DIAMETER_Types.AVP_Address.");
}
return FALSE;
}

boolean AVP__Address_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_address__type.is_bound()
 || single_value->field_address__data.is_bound();
}

boolean AVP__Address_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_address__type.is_value()
 && single_value->field_address__data.is_value();
}

void AVP__Address_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

AVP__Address AVP__Address_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @DIAMETER_Types.AVP_Address.");
AVP__Address ret_val;
if (single_value->field_address__type.is_bound()) {
ret_val.address__type() = single_value->field_address__type.valueof();
}
if (single_value->field_address__data.is_bound()) {
ret_val.address__data() = single_value->field_address__data.valueof();
}
return ret_val;
}

void AVP__Address_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @DIAMETER_Types.AVP_Address.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new AVP__Address_template[list_length];
}

AVP__Address_template& AVP__Address_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @DIAMETER_Types.AVP_Address.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @DIAMETER_Types.AVP_Address.");
return value_list.list_value[list_index];
}

AddressType_template& AVP__Address_template::address__type()
{
set_specific();
return single_value->field_address__type;
}

const AddressType_template& AVP__Address_template::address__type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field address_type of a non-specific template of type @DIAMETER_Types.AVP_Address.");
return single_value->field_address__type;
}

OCTETSTRING_template& AVP__Address_template::address__data()
{
set_specific();
return single_value->field_address__data;
}

const OCTETSTRING_template& AVP__Address_template::address__data() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field address_data of a non-specific template of type @DIAMETER_Types.AVP_Address.");
return single_value->field_address__data;
}

int AVP__Address_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @DIAMETER_Types.AVP_Address which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @DIAMETER_Types.AVP_Address containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @DIAMETER_Types.AVP_Address containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @DIAMETER_Types.AVP_Address containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @DIAMETER_Types.AVP_Address containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @DIAMETER_Types.AVP_Address containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @DIAMETER_Types.AVP_Address containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @DIAMETER_Types.AVP_Address containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @DIAMETER_Types.AVP_Address containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @DIAMETER_Types.AVP_Address.");
  }
  return 0;
}

void AVP__Address_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ address_type := ");
single_value->field_address__type.log();
TTCN_Logger::log_event_str(", address_data := ");
single_value->field_address__data.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void AVP__Address_template::log_match(const AVP__Address& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_address__type.match(match_value.address__type(), legacy)){
TTCN_Logger::log_logmatch_info(".address_type");
single_value->field_address__type.log_match(match_value.address__type(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_address__data.match(match_value.address__data(), legacy)){
TTCN_Logger::log_logmatch_info(".address_data");
single_value->field_address__data.log_match(match_value.address__data(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ address_type := ");
single_value->field_address__type.log_match(match_value.address__type(), legacy);
TTCN_Logger::log_event_str(", address_data := ");
single_value->field_address__data.log_match(match_value.address__data(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void AVP__Address_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (address__type().is_bound()) address__type().set_implicit_omit();
if (address__data().is_bound()) address__data().set_implicit_omit();
}

void AVP__Address_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_address__type.encode_text(text_buf);
single_value->field_address__data.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @DIAMETER_Types.AVP_Address.");
}
}

void AVP__Address_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_address__type.decode_text(text_buf);
single_value->field_address__data.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new AVP__Address_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @DIAMETER_Types.AVP_Address.");
}
}

void AVP__Address_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    AVP__Address_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @DIAMETER_Types.AVP_Address has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) address__type().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) address__data().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "address_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          address__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "address_data")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          address__data().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @DIAMETER_Types.AVP_Address: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    AVP__Address_template* precondition = new AVP__Address_template;
    precondition->set_param(*param.get_elem(0));
    AVP__Address_template* implied_template = new AVP__Address_template;
    implied_template->set_param(*param.get_elem(1));
    *this = AVP__Address_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@DIAMETER_Types.AVP_Address");
  }
  is_ifpresent = param.get_ifpresent();
}

void AVP__Address_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_address__type.check_restriction(t_res, t_name ? t_name : "@DIAMETER_Types.AVP_Address");
single_value->field_address__data.check_restriction(t_res, t_name ? t_name : "@DIAMETER_Types.AVP_Address");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.AVP_Address");
}

boolean AVP__Address_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean AVP__Address_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

DCC__NONE__Direct__Debiting__Failure__Handling::DCC__NONE__Direct__Debiting__Failure__Handling()
{
enum_value = UNBOUND_VALUE;
}

DCC__NONE__Direct__Debiting__Failure__Handling::DCC__NONE__Direct__Debiting__Failure__Handling(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

DCC__NONE__Direct__Debiting__Failure__Handling::DCC__NONE__Direct__Debiting__Failure__Handling(enum_type other_value)
{
enum_value = other_value;
}

DCC__NONE__Direct__Debiting__Failure__Handling::DCC__NONE__Direct__Debiting__Failure__Handling(const DCC__NONE__Direct__Debiting__Failure__Handling& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
enum_value = other_value.enum_value;
}

DCC__NONE__Direct__Debiting__Failure__Handling& DCC__NONE__Direct__Debiting__Failure__Handling::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

DCC__NONE__Direct__Debiting__Failure__Handling& DCC__NONE__Direct__Debiting__Failure__Handling::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

DCC__NONE__Direct__Debiting__Failure__Handling& DCC__NONE__Direct__Debiting__Failure__Handling::operator=(const DCC__NONE__Direct__Debiting__Failure__Handling& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
enum_value = other_value.enum_value;
return *this;
}

boolean DCC__NONE__Direct__Debiting__Failure__Handling::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean DCC__NONE__Direct__Debiting__Failure__Handling::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
return enum_value == other_value;
}

boolean DCC__NONE__Direct__Debiting__Failure__Handling::operator==(const DCC__NONE__Direct__Debiting__Failure__Handling& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
return enum_value == other_value.enum_value;
}

boolean DCC__NONE__Direct__Debiting__Failure__Handling::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean DCC__NONE__Direct__Debiting__Failure__Handling::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
return enum_value < other_value;
}

boolean DCC__NONE__Direct__Debiting__Failure__Handling::operator<(const DCC__NONE__Direct__Debiting__Failure__Handling& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
return enum_value < other_value.enum_value;
}

boolean DCC__NONE__Direct__Debiting__Failure__Handling::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean DCC__NONE__Direct__Debiting__Failure__Handling::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
return enum_value > other_value;
}

boolean DCC__NONE__Direct__Debiting__Failure__Handling::operator>(const DCC__NONE__Direct__Debiting__Failure__Handling& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
return enum_value > other_value.enum_value;
}

const char *DCC__NONE__Direct__Debiting__Failure__Handling::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case TERMINATE__OR__BUFFER: return "TERMINATE_OR_BUFFER";
case CONTINUE: return "CONTINUE";
default:
return "<unknown>";
}
}

DCC__NONE__Direct__Debiting__Failure__Handling::enum_type DCC__NONE__Direct__Debiting__Failure__Handling::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "TERMINATE_OR_BUFFER")) return TERMINATE__OR__BUFFER;
if (!strcmp(str_par, "CONTINUE")) return CONTINUE;
}
return UNKNOWN_VALUE;
}

boolean DCC__NONE__Direct__Debiting__Failure__Handling::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
return TRUE;
default:
return FALSE;
}
}

int DCC__NONE__Direct__Debiting__Failure__Handling::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int DCC__NONE__Direct__Debiting__Failure__Handling::enum2int(const DCC__NONE__Direct__Debiting__Failure__Handling& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void DCC__NONE__Direct__Debiting__Failure__Handling::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.", int_val);
enum_value = (enum_type)int_val;
}

DCC__NONE__Direct__Debiting__Failure__Handling::operator DCC__NONE__Direct__Debiting__Failure__Handling::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
return enum_value;
}

void DCC__NONE__Direct__Debiting__Failure__Handling::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void DCC__NONE__Direct__Debiting__Failure__Handling::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
  }
}

void DCC__NONE__Direct__Debiting__Failure__Handling::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
text_buf.push_int(enum_value);
}

void DCC__NONE__Direct__Debiting__Failure__Handling::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.", enum_value);
}

void DCC__NONE__Direct__Debiting__Failure__Handling::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void DCC__NONE__Direct__Debiting__Failure__Handling::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int DCC__NONE__Direct__Debiting__Failure__Handling::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int DCC__NONE__Direct__Debiting__Failure__Handling::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void DCC__NONE__Direct__Debiting__Failure__Handling_template::copy_template(const DCC__NONE__Direct__Debiting__Failure__Handling_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new DCC__NONE__Direct__Debiting__Failure__Handling_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new DCC__NONE__Direct__Debiting__Failure__Handling_template(*other_value.implication_.precondition);
implication_.implied_template = new DCC__NONE__Direct__Debiting__Failure__Handling_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
}
}

DCC__NONE__Direct__Debiting__Failure__Handling_template::DCC__NONE__Direct__Debiting__Failure__Handling_template()
{
}

DCC__NONE__Direct__Debiting__Failure__Handling_template::DCC__NONE__Direct__Debiting__Failure__Handling_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

DCC__NONE__Direct__Debiting__Failure__Handling_template::DCC__NONE__Direct__Debiting__Failure__Handling_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!DCC__NONE__Direct__Debiting__Failure__Handling::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling with unknown numeric value %d.", other_value);
single_value = (DCC__NONE__Direct__Debiting__Failure__Handling::enum_type)other_value;
}

DCC__NONE__Direct__Debiting__Failure__Handling_template::DCC__NONE__Direct__Debiting__Failure__Handling_template(DCC__NONE__Direct__Debiting__Failure__Handling::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

DCC__NONE__Direct__Debiting__Failure__Handling_template::DCC__NONE__Direct__Debiting__Failure__Handling_template(const DCC__NONE__Direct__Debiting__Failure__Handling& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == DCC__NONE__Direct__Debiting__Failure__Handling::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
single_value = other_value.enum_value;
}

DCC__NONE__Direct__Debiting__Failure__Handling_template::DCC__NONE__Direct__Debiting__Failure__Handling_template(const OPTIONAL<DCC__NONE__Direct__Debiting__Failure__Handling>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCC__NONE__Direct__Debiting__Failure__Handling::enum_type)(const DCC__NONE__Direct__Debiting__Failure__Handling&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling from an unbound optional field.");
}
}

DCC__NONE__Direct__Debiting__Failure__Handling_template::DCC__NONE__Direct__Debiting__Failure__Handling_template(DCC__NONE__Direct__Debiting__Failure__Handling_template* p_precondition, DCC__NONE__Direct__Debiting__Failure__Handling_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

DCC__NONE__Direct__Debiting__Failure__Handling_template::DCC__NONE__Direct__Debiting__Failure__Handling_template(Dynamic_Match_Interface<DCC__NONE__Direct__Debiting__Failure__Handling>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<DCC__NONE__Direct__Debiting__Failure__Handling>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

DCC__NONE__Direct__Debiting__Failure__Handling_template::DCC__NONE__Direct__Debiting__Failure__Handling_template(const DCC__NONE__Direct__Debiting__Failure__Handling_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

DCC__NONE__Direct__Debiting__Failure__Handling_template::~DCC__NONE__Direct__Debiting__Failure__Handling_template()
{
clean_up();
}

boolean DCC__NONE__Direct__Debiting__Failure__Handling_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean DCC__NONE__Direct__Debiting__Failure__Handling_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != DCC__NONE__Direct__Debiting__Failure__Handling::UNBOUND_VALUE;
}

void DCC__NONE__Direct__Debiting__Failure__Handling_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

DCC__NONE__Direct__Debiting__Failure__Handling_template& DCC__NONE__Direct__Debiting__Failure__Handling_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

DCC__NONE__Direct__Debiting__Failure__Handling_template& DCC__NONE__Direct__Debiting__Failure__Handling_template::operator=(int other_value)
{
if (!DCC__NONE__Direct__Debiting__Failure__Handling::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (DCC__NONE__Direct__Debiting__Failure__Handling::enum_type)other_value;
return *this;
}

DCC__NONE__Direct__Debiting__Failure__Handling_template& DCC__NONE__Direct__Debiting__Failure__Handling_template::operator=(DCC__NONE__Direct__Debiting__Failure__Handling::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

DCC__NONE__Direct__Debiting__Failure__Handling_template& DCC__NONE__Direct__Debiting__Failure__Handling_template::operator=(const DCC__NONE__Direct__Debiting__Failure__Handling& other_value)
{
if (other_value.enum_value == DCC__NONE__Direct__Debiting__Failure__Handling::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

DCC__NONE__Direct__Debiting__Failure__Handling_template& DCC__NONE__Direct__Debiting__Failure__Handling_template::operator=(const OPTIONAL<DCC__NONE__Direct__Debiting__Failure__Handling>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCC__NONE__Direct__Debiting__Failure__Handling::enum_type)(const DCC__NONE__Direct__Debiting__Failure__Handling&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
}
return *this;
}

DCC__NONE__Direct__Debiting__Failure__Handling_template& DCC__NONE__Direct__Debiting__Failure__Handling_template::operator=(const DCC__NONE__Direct__Debiting__Failure__Handling_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean DCC__NONE__Direct__Debiting__Failure__Handling_template::match(DCC__NONE__Direct__Debiting__Failure__Handling::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
}
return FALSE;
}

boolean DCC__NONE__Direct__Debiting__Failure__Handling_template::match(const DCC__NONE__Direct__Debiting__Failure__Handling& other_value, boolean) const
{
if (other_value.enum_value == DCC__NONE__Direct__Debiting__Failure__Handling::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling with an unbound value.");
return match(other_value.enum_value);
}

DCC__NONE__Direct__Debiting__Failure__Handling::enum_type DCC__NONE__Direct__Debiting__Failure__Handling_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
return single_value;
}

void DCC__NONE__Direct__Debiting__Failure__Handling_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new DCC__NONE__Direct__Debiting__Failure__Handling_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
}
}

DCC__NONE__Direct__Debiting__Failure__Handling_template& DCC__NONE__Direct__Debiting__Failure__Handling_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
return value_list.list_value[list_index];
}

void DCC__NONE__Direct__Debiting__Failure__Handling_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(DCC__NONE__Direct__Debiting__Failure__Handling::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void DCC__NONE__Direct__Debiting__Failure__Handling_template::log_match(const DCC__NONE__Direct__Debiting__Failure__Handling& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void DCC__NONE__Direct__Debiting__Failure__Handling_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
}
}

void DCC__NONE__Direct__Debiting__Failure__Handling_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (DCC__NONE__Direct__Debiting__Failure__Handling::enum_type)text_buf.pull_int().get_val();
if (!DCC__NONE__Direct__Debiting__Failure__Handling::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new DCC__NONE__Direct__Debiting__Failure__Handling_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
}
}

boolean DCC__NONE__Direct__Debiting__Failure__Handling_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean DCC__NONE__Direct__Debiting__Failure__Handling_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void DCC__NONE__Direct__Debiting__Failure__Handling_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    DCC__NONE__Direct__Debiting__Failure__Handling_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    DCC__NONE__Direct__Debiting__Failure__Handling::enum_type enum_val = DCC__NONE__Direct__Debiting__Failure__Handling::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!DCC__NONE__Direct__Debiting__Failure__Handling::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    DCC__NONE__Direct__Debiting__Failure__Handling_template* precondition = new DCC__NONE__Direct__Debiting__Failure__Handling_template;
    precondition->set_param(*m_p->get_elem(0));
    DCC__NONE__Direct__Debiting__Failure__Handling_template* implied_template = new DCC__NONE__Direct__Debiting__Failure__Handling_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = DCC__NONE__Direct__Debiting__Failure__Handling_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling");
  }
  is_ifpresent = param.get_ifpresent();
}

void DCC__NONE__Direct__Debiting__Failure__Handling_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.DCC_NONE_Direct_Debiting_Failure_Handling");
}

DCA__3GPP__Reporting__Reason::DCA__3GPP__Reporting__Reason()
{
enum_value = UNBOUND_VALUE;
}

DCA__3GPP__Reporting__Reason::DCA__3GPP__Reporting__Reason(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

DCA__3GPP__Reporting__Reason::DCA__3GPP__Reporting__Reason(enum_type other_value)
{
enum_value = other_value;
}

DCA__3GPP__Reporting__Reason::DCA__3GPP__Reporting__Reason(const DCA__3GPP__Reporting__Reason& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
enum_value = other_value.enum_value;
}

DCA__3GPP__Reporting__Reason& DCA__3GPP__Reporting__Reason::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

DCA__3GPP__Reporting__Reason& DCA__3GPP__Reporting__Reason::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

DCA__3GPP__Reporting__Reason& DCA__3GPP__Reporting__Reason::operator=(const DCA__3GPP__Reporting__Reason& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
enum_value = other_value.enum_value;
return *this;
}

boolean DCA__3GPP__Reporting__Reason::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean DCA__3GPP__Reporting__Reason::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
return enum_value == other_value;
}

boolean DCA__3GPP__Reporting__Reason::operator==(const DCA__3GPP__Reporting__Reason& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
return enum_value == other_value.enum_value;
}

boolean DCA__3GPP__Reporting__Reason::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean DCA__3GPP__Reporting__Reason::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
return enum_value < other_value;
}

boolean DCA__3GPP__Reporting__Reason::operator<(const DCA__3GPP__Reporting__Reason& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
return enum_value < other_value.enum_value;
}

boolean DCA__3GPP__Reporting__Reason::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean DCA__3GPP__Reporting__Reason::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
return enum_value > other_value;
}

boolean DCA__3GPP__Reporting__Reason::operator>(const DCA__3GPP__Reporting__Reason& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
return enum_value > other_value.enum_value;
}

const char *DCA__3GPP__Reporting__Reason::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case THRESHOLD: return "THRESHOLD";
case QHT: return "QHT";
case FINAL: return "FINAL";
case QUOTA__EXHAUSTED: return "QUOTA_EXHAUSTED";
case VALIDITY__TIME: return "VALIDITY_TIME";
case OTHER__QUOTA__TYPE: return "OTHER_QUOTA_TYPE";
case RATING__CONDITION__CHANGE: return "RATING_CONDITION_CHANGE";
case FORCED__REAUTHORISATION: return "FORCED_REAUTHORISATION";
case POOL__EXHAUSTED: return "POOL_EXHAUSTED";
default:
return "<unknown>";
}
}

DCA__3GPP__Reporting__Reason::enum_type DCA__3GPP__Reporting__Reason::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "THRESHOLD")) return THRESHOLD;
if (!strcmp(str_par, "QHT")) return QHT;
if (!strcmp(str_par, "FINAL")) return FINAL;
if (!strcmp(str_par, "QUOTA_EXHAUSTED")) return QUOTA__EXHAUSTED;
if (!strcmp(str_par, "VALIDITY_TIME")) return VALIDITY__TIME;
if (!strcmp(str_par, "OTHER_QUOTA_TYPE")) return OTHER__QUOTA__TYPE;
if (!strcmp(str_par, "RATING_CONDITION_CHANGE")) return RATING__CONDITION__CHANGE;
if (!strcmp(str_par, "FORCED_REAUTHORISATION")) return FORCED__REAUTHORISATION;
if (!strcmp(str_par, "POOL_EXHAUSTED")) return POOL__EXHAUSTED;
}
return UNKNOWN_VALUE;
}

boolean DCA__3GPP__Reporting__Reason::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
case 4:
case 5:
case 6:
case 7:
case 8:
return TRUE;
default:
return FALSE;
}
}

int DCA__3GPP__Reporting__Reason::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int DCA__3GPP__Reporting__Reason::enum2int(const DCA__3GPP__Reporting__Reason& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void DCA__3GPP__Reporting__Reason::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.", int_val);
enum_value = (enum_type)int_val;
}

DCA__3GPP__Reporting__Reason::operator DCA__3GPP__Reporting__Reason::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
return enum_value;
}

void DCA__3GPP__Reporting__Reason::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void DCA__3GPP__Reporting__Reason::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.DCA_3GPP_Reporting_Reason");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
  }
}

void DCA__3GPP__Reporting__Reason::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
text_buf.push_int(enum_value);
}

void DCA__3GPP__Reporting__Reason::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.", enum_value);
}

void DCA__3GPP__Reporting__Reason::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void DCA__3GPP__Reporting__Reason::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int DCA__3GPP__Reporting__Reason::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 4, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int DCA__3GPP__Reporting__Reason::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 4);
}

void DCA__3GPP__Reporting__Reason_template::copy_template(const DCA__3GPP__Reporting__Reason_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new DCA__3GPP__Reporting__Reason_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new DCA__3GPP__Reporting__Reason_template(*other_value.implication_.precondition);
implication_.implied_template = new DCA__3GPP__Reporting__Reason_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
}
}

DCA__3GPP__Reporting__Reason_template::DCA__3GPP__Reporting__Reason_template()
{
}

DCA__3GPP__Reporting__Reason_template::DCA__3GPP__Reporting__Reason_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

DCA__3GPP__Reporting__Reason_template::DCA__3GPP__Reporting__Reason_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!DCA__3GPP__Reporting__Reason::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason with unknown numeric value %d.", other_value);
single_value = (DCA__3GPP__Reporting__Reason::enum_type)other_value;
}

DCA__3GPP__Reporting__Reason_template::DCA__3GPP__Reporting__Reason_template(DCA__3GPP__Reporting__Reason::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

DCA__3GPP__Reporting__Reason_template::DCA__3GPP__Reporting__Reason_template(const DCA__3GPP__Reporting__Reason& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == DCA__3GPP__Reporting__Reason::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
single_value = other_value.enum_value;
}

DCA__3GPP__Reporting__Reason_template::DCA__3GPP__Reporting__Reason_template(const OPTIONAL<DCA__3GPP__Reporting__Reason>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__Reporting__Reason::enum_type)(const DCA__3GPP__Reporting__Reason&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason from an unbound optional field.");
}
}

DCA__3GPP__Reporting__Reason_template::DCA__3GPP__Reporting__Reason_template(DCA__3GPP__Reporting__Reason_template* p_precondition, DCA__3GPP__Reporting__Reason_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

DCA__3GPP__Reporting__Reason_template::DCA__3GPP__Reporting__Reason_template(Dynamic_Match_Interface<DCA__3GPP__Reporting__Reason>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<DCA__3GPP__Reporting__Reason>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

DCA__3GPP__Reporting__Reason_template::DCA__3GPP__Reporting__Reason_template(const DCA__3GPP__Reporting__Reason_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

DCA__3GPP__Reporting__Reason_template::~DCA__3GPP__Reporting__Reason_template()
{
clean_up();
}

boolean DCA__3GPP__Reporting__Reason_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean DCA__3GPP__Reporting__Reason_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != DCA__3GPP__Reporting__Reason::UNBOUND_VALUE;
}

void DCA__3GPP__Reporting__Reason_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

DCA__3GPP__Reporting__Reason_template& DCA__3GPP__Reporting__Reason_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

DCA__3GPP__Reporting__Reason_template& DCA__3GPP__Reporting__Reason_template::operator=(int other_value)
{
if (!DCA__3GPP__Reporting__Reason::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__Reporting__Reason::enum_type)other_value;
return *this;
}

DCA__3GPP__Reporting__Reason_template& DCA__3GPP__Reporting__Reason_template::operator=(DCA__3GPP__Reporting__Reason::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

DCA__3GPP__Reporting__Reason_template& DCA__3GPP__Reporting__Reason_template::operator=(const DCA__3GPP__Reporting__Reason& other_value)
{
if (other_value.enum_value == DCA__3GPP__Reporting__Reason::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

DCA__3GPP__Reporting__Reason_template& DCA__3GPP__Reporting__Reason_template::operator=(const OPTIONAL<DCA__3GPP__Reporting__Reason>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__Reporting__Reason::enum_type)(const DCA__3GPP__Reporting__Reason&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
}
return *this;
}

DCA__3GPP__Reporting__Reason_template& DCA__3GPP__Reporting__Reason_template::operator=(const DCA__3GPP__Reporting__Reason_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean DCA__3GPP__Reporting__Reason_template::match(DCA__3GPP__Reporting__Reason::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
}
return FALSE;
}

boolean DCA__3GPP__Reporting__Reason_template::match(const DCA__3GPP__Reporting__Reason& other_value, boolean) const
{
if (other_value.enum_value == DCA__3GPP__Reporting__Reason::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason with an unbound value.");
return match(other_value.enum_value);
}

DCA__3GPP__Reporting__Reason::enum_type DCA__3GPP__Reporting__Reason_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
return single_value;
}

void DCA__3GPP__Reporting__Reason_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new DCA__3GPP__Reporting__Reason_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
}
}

DCA__3GPP__Reporting__Reason_template& DCA__3GPP__Reporting__Reason_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
return value_list.list_value[list_index];
}

void DCA__3GPP__Reporting__Reason_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(DCA__3GPP__Reporting__Reason::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void DCA__3GPP__Reporting__Reason_template::log_match(const DCA__3GPP__Reporting__Reason& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void DCA__3GPP__Reporting__Reason_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
}
}

void DCA__3GPP__Reporting__Reason_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (DCA__3GPP__Reporting__Reason::enum_type)text_buf.pull_int().get_val();
if (!DCA__3GPP__Reporting__Reason::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new DCA__3GPP__Reporting__Reason_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
}
}

boolean DCA__3GPP__Reporting__Reason_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean DCA__3GPP__Reporting__Reason_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void DCA__3GPP__Reporting__Reason_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    DCA__3GPP__Reporting__Reason_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    DCA__3GPP__Reporting__Reason::enum_type enum_val = DCA__3GPP__Reporting__Reason::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!DCA__3GPP__Reporting__Reason::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.DCA_3GPP_Reporting_Reason.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    DCA__3GPP__Reporting__Reason_template* precondition = new DCA__3GPP__Reporting__Reason_template;
    precondition->set_param(*m_p->get_elem(0));
    DCA__3GPP__Reporting__Reason_template* implied_template = new DCA__3GPP__Reporting__Reason_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = DCA__3GPP__Reporting__Reason_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.DCA_3GPP_Reporting_Reason");
  }
  is_ifpresent = param.get_ifpresent();
}

void DCA__3GPP__Reporting__Reason_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.DCA_3GPP_Reporting_Reason");
}

PCC__3GPP__CSG__Information__Reporting::PCC__3GPP__CSG__Information__Reporting()
{
enum_value = UNBOUND_VALUE;
}

PCC__3GPP__CSG__Information__Reporting::PCC__3GPP__CSG__Information__Reporting(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

PCC__3GPP__CSG__Information__Reporting::PCC__3GPP__CSG__Information__Reporting(enum_type other_value)
{
enum_value = other_value;
}

PCC__3GPP__CSG__Information__Reporting::PCC__3GPP__CSG__Information__Reporting(const PCC__3GPP__CSG__Information__Reporting& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
enum_value = other_value.enum_value;
}

PCC__3GPP__CSG__Information__Reporting& PCC__3GPP__CSG__Information__Reporting::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

PCC__3GPP__CSG__Information__Reporting& PCC__3GPP__CSG__Information__Reporting::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

PCC__3GPP__CSG__Information__Reporting& PCC__3GPP__CSG__Information__Reporting::operator=(const PCC__3GPP__CSG__Information__Reporting& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
enum_value = other_value.enum_value;
return *this;
}

boolean PCC__3GPP__CSG__Information__Reporting::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean PCC__3GPP__CSG__Information__Reporting::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
return enum_value == other_value;
}

boolean PCC__3GPP__CSG__Information__Reporting::operator==(const PCC__3GPP__CSG__Information__Reporting& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
return enum_value == other_value.enum_value;
}

boolean PCC__3GPP__CSG__Information__Reporting::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean PCC__3GPP__CSG__Information__Reporting::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
return enum_value < other_value;
}

boolean PCC__3GPP__CSG__Information__Reporting::operator<(const PCC__3GPP__CSG__Information__Reporting& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
return enum_value < other_value.enum_value;
}

boolean PCC__3GPP__CSG__Information__Reporting::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean PCC__3GPP__CSG__Information__Reporting::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
return enum_value > other_value;
}

boolean PCC__3GPP__CSG__Information__Reporting::operator>(const PCC__3GPP__CSG__Information__Reporting& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
return enum_value > other_value.enum_value;
}

const char *PCC__3GPP__CSG__Information__Reporting::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case CHANGE__CSG__CELL: return "CHANGE_CSG_CELL";
case CHANGE__CSG__SUBSCRIBED__HYBRID__CELL: return "CHANGE_CSG_SUBSCRIBED_HYBRID_CELL";
case CHANGE__CSG__UNSUBSCRIBED__HYBRID__CELL: return "CHANGE_CSG_UNSUBSCRIBED_HYBRID_CELL";
default:
return "<unknown>";
}
}

PCC__3GPP__CSG__Information__Reporting::enum_type PCC__3GPP__CSG__Information__Reporting::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "CHANGE_CSG_CELL")) return CHANGE__CSG__CELL;
if (!strcmp(str_par, "CHANGE_CSG_SUBSCRIBED_HYBRID_CELL")) return CHANGE__CSG__SUBSCRIBED__HYBRID__CELL;
if (!strcmp(str_par, "CHANGE_CSG_UNSUBSCRIBED_HYBRID_CELL")) return CHANGE__CSG__UNSUBSCRIBED__HYBRID__CELL;
}
return UNKNOWN_VALUE;
}

boolean PCC__3GPP__CSG__Information__Reporting::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
return TRUE;
default:
return FALSE;
}
}

int PCC__3GPP__CSG__Information__Reporting::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int PCC__3GPP__CSG__Information__Reporting::enum2int(const PCC__3GPP__CSG__Information__Reporting& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void PCC__3GPP__CSG__Information__Reporting::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.", int_val);
enum_value = (enum_type)int_val;
}

PCC__3GPP__CSG__Information__Reporting::operator PCC__3GPP__CSG__Information__Reporting::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
return enum_value;
}

void PCC__3GPP__CSG__Information__Reporting::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void PCC__3GPP__CSG__Information__Reporting::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
  }
}

void PCC__3GPP__CSG__Information__Reporting::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
text_buf.push_int(enum_value);
}

void PCC__3GPP__CSG__Information__Reporting::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.", enum_value);
}

void PCC__3GPP__CSG__Information__Reporting::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PCC__3GPP__CSG__Information__Reporting::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PCC__3GPP__CSG__Information__Reporting::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int PCC__3GPP__CSG__Information__Reporting::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void PCC__3GPP__CSG__Information__Reporting_template::copy_template(const PCC__3GPP__CSG__Information__Reporting_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PCC__3GPP__CSG__Information__Reporting_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PCC__3GPP__CSG__Information__Reporting_template(*other_value.implication_.precondition);
implication_.implied_template = new PCC__3GPP__CSG__Information__Reporting_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
}
}

PCC__3GPP__CSG__Information__Reporting_template::PCC__3GPP__CSG__Information__Reporting_template()
{
}

PCC__3GPP__CSG__Information__Reporting_template::PCC__3GPP__CSG__Information__Reporting_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PCC__3GPP__CSG__Information__Reporting_template::PCC__3GPP__CSG__Information__Reporting_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!PCC__3GPP__CSG__Information__Reporting::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting with unknown numeric value %d.", other_value);
single_value = (PCC__3GPP__CSG__Information__Reporting::enum_type)other_value;
}

PCC__3GPP__CSG__Information__Reporting_template::PCC__3GPP__CSG__Information__Reporting_template(PCC__3GPP__CSG__Information__Reporting::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

PCC__3GPP__CSG__Information__Reporting_template::PCC__3GPP__CSG__Information__Reporting_template(const PCC__3GPP__CSG__Information__Reporting& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == PCC__3GPP__CSG__Information__Reporting::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
single_value = other_value.enum_value;
}

PCC__3GPP__CSG__Information__Reporting_template::PCC__3GPP__CSG__Information__Reporting_template(const OPTIONAL<PCC__3GPP__CSG__Information__Reporting>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (PCC__3GPP__CSG__Information__Reporting::enum_type)(const PCC__3GPP__CSG__Information__Reporting&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting from an unbound optional field.");
}
}

PCC__3GPP__CSG__Information__Reporting_template::PCC__3GPP__CSG__Information__Reporting_template(PCC__3GPP__CSG__Information__Reporting_template* p_precondition, PCC__3GPP__CSG__Information__Reporting_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PCC__3GPP__CSG__Information__Reporting_template::PCC__3GPP__CSG__Information__Reporting_template(Dynamic_Match_Interface<PCC__3GPP__CSG__Information__Reporting>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PCC__3GPP__CSG__Information__Reporting>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PCC__3GPP__CSG__Information__Reporting_template::PCC__3GPP__CSG__Information__Reporting_template(const PCC__3GPP__CSG__Information__Reporting_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

PCC__3GPP__CSG__Information__Reporting_template::~PCC__3GPP__CSG__Information__Reporting_template()
{
clean_up();
}

boolean PCC__3GPP__CSG__Information__Reporting_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean PCC__3GPP__CSG__Information__Reporting_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != PCC__3GPP__CSG__Information__Reporting::UNBOUND_VALUE;
}

void PCC__3GPP__CSG__Information__Reporting_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PCC__3GPP__CSG__Information__Reporting_template& PCC__3GPP__CSG__Information__Reporting_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PCC__3GPP__CSG__Information__Reporting_template& PCC__3GPP__CSG__Information__Reporting_template::operator=(int other_value)
{
if (!PCC__3GPP__CSG__Information__Reporting::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (PCC__3GPP__CSG__Information__Reporting::enum_type)other_value;
return *this;
}

PCC__3GPP__CSG__Information__Reporting_template& PCC__3GPP__CSG__Information__Reporting_template::operator=(PCC__3GPP__CSG__Information__Reporting::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

PCC__3GPP__CSG__Information__Reporting_template& PCC__3GPP__CSG__Information__Reporting_template::operator=(const PCC__3GPP__CSG__Information__Reporting& other_value)
{
if (other_value.enum_value == PCC__3GPP__CSG__Information__Reporting::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

PCC__3GPP__CSG__Information__Reporting_template& PCC__3GPP__CSG__Information__Reporting_template::operator=(const OPTIONAL<PCC__3GPP__CSG__Information__Reporting>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (PCC__3GPP__CSG__Information__Reporting::enum_type)(const PCC__3GPP__CSG__Information__Reporting&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
}
return *this;
}

PCC__3GPP__CSG__Information__Reporting_template& PCC__3GPP__CSG__Information__Reporting_template::operator=(const PCC__3GPP__CSG__Information__Reporting_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PCC__3GPP__CSG__Information__Reporting_template::match(PCC__3GPP__CSG__Information__Reporting::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
}
return FALSE;
}

boolean PCC__3GPP__CSG__Information__Reporting_template::match(const PCC__3GPP__CSG__Information__Reporting& other_value, boolean) const
{
if (other_value.enum_value == PCC__3GPP__CSG__Information__Reporting::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting with an unbound value.");
return match(other_value.enum_value);
}

PCC__3GPP__CSG__Information__Reporting::enum_type PCC__3GPP__CSG__Information__Reporting_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
return single_value;
}

void PCC__3GPP__CSG__Information__Reporting_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PCC__3GPP__CSG__Information__Reporting_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
}
}

PCC__3GPP__CSG__Information__Reporting_template& PCC__3GPP__CSG__Information__Reporting_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
return value_list.list_value[list_index];
}

void PCC__3GPP__CSG__Information__Reporting_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(PCC__3GPP__CSG__Information__Reporting::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PCC__3GPP__CSG__Information__Reporting_template::log_match(const PCC__3GPP__CSG__Information__Reporting& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void PCC__3GPP__CSG__Information__Reporting_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
}
}

void PCC__3GPP__CSG__Information__Reporting_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (PCC__3GPP__CSG__Information__Reporting::enum_type)text_buf.pull_int().get_val();
if (!PCC__3GPP__CSG__Information__Reporting::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PCC__3GPP__CSG__Information__Reporting_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
}
}

boolean PCC__3GPP__CSG__Information__Reporting_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PCC__3GPP__CSG__Information__Reporting_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void PCC__3GPP__CSG__Information__Reporting_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PCC__3GPP__CSG__Information__Reporting_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    PCC__3GPP__CSG__Information__Reporting::enum_type enum_val = PCC__3GPP__CSG__Information__Reporting::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!PCC__3GPP__CSG__Information__Reporting::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    PCC__3GPP__CSG__Information__Reporting_template* precondition = new PCC__3GPP__CSG__Information__Reporting_template;
    precondition->set_param(*m_p->get_elem(0));
    PCC__3GPP__CSG__Information__Reporting_template* implied_template = new PCC__3GPP__CSG__Information__Reporting_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = PCC__3GPP__CSG__Information__Reporting_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting");
  }
  is_ifpresent = param.get_ifpresent();
}

void PCC__3GPP__CSG__Information__Reporting_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.PCC_3GPP_CSG_Information_Reporting");
}

PCC__3GPP__Bearer__Usage::PCC__3GPP__Bearer__Usage()
{
enum_value = UNBOUND_VALUE;
}

PCC__3GPP__Bearer__Usage::PCC__3GPP__Bearer__Usage(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

PCC__3GPP__Bearer__Usage::PCC__3GPP__Bearer__Usage(enum_type other_value)
{
enum_value = other_value;
}

PCC__3GPP__Bearer__Usage::PCC__3GPP__Bearer__Usage(const PCC__3GPP__Bearer__Usage& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
enum_value = other_value.enum_value;
}

PCC__3GPP__Bearer__Usage& PCC__3GPP__Bearer__Usage::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

PCC__3GPP__Bearer__Usage& PCC__3GPP__Bearer__Usage::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

PCC__3GPP__Bearer__Usage& PCC__3GPP__Bearer__Usage::operator=(const PCC__3GPP__Bearer__Usage& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
enum_value = other_value.enum_value;
return *this;
}

boolean PCC__3GPP__Bearer__Usage::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean PCC__3GPP__Bearer__Usage::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
return enum_value == other_value;
}

boolean PCC__3GPP__Bearer__Usage::operator==(const PCC__3GPP__Bearer__Usage& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
return enum_value == other_value.enum_value;
}

boolean PCC__3GPP__Bearer__Usage::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean PCC__3GPP__Bearer__Usage::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
return enum_value < other_value;
}

boolean PCC__3GPP__Bearer__Usage::operator<(const PCC__3GPP__Bearer__Usage& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
return enum_value < other_value.enum_value;
}

boolean PCC__3GPP__Bearer__Usage::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean PCC__3GPP__Bearer__Usage::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
return enum_value > other_value;
}

boolean PCC__3GPP__Bearer__Usage::operator>(const PCC__3GPP__Bearer__Usage& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
return enum_value > other_value.enum_value;
}

const char *PCC__3GPP__Bearer__Usage::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case GENERAL: return "GENERAL";
case IMS__SIGNALLING: return "IMS_SIGNALLING";
default:
return "<unknown>";
}
}

PCC__3GPP__Bearer__Usage::enum_type PCC__3GPP__Bearer__Usage::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "GENERAL")) return GENERAL;
if (!strcmp(str_par, "IMS_SIGNALLING")) return IMS__SIGNALLING;
}
return UNKNOWN_VALUE;
}

boolean PCC__3GPP__Bearer__Usage::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
return TRUE;
default:
return FALSE;
}
}

int PCC__3GPP__Bearer__Usage::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int PCC__3GPP__Bearer__Usage::enum2int(const PCC__3GPP__Bearer__Usage& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void PCC__3GPP__Bearer__Usage::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.", int_val);
enum_value = (enum_type)int_val;
}

PCC__3GPP__Bearer__Usage::operator PCC__3GPP__Bearer__Usage::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
return enum_value;
}

void PCC__3GPP__Bearer__Usage::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void PCC__3GPP__Bearer__Usage::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.PCC_3GPP_Bearer_Usage");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
  }
}

void PCC__3GPP__Bearer__Usage::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
text_buf.push_int(enum_value);
}

void PCC__3GPP__Bearer__Usage::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.", enum_value);
}

void PCC__3GPP__Bearer__Usage::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PCC__3GPP__Bearer__Usage::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PCC__3GPP__Bearer__Usage::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int PCC__3GPP__Bearer__Usage::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void PCC__3GPP__Bearer__Usage_template::copy_template(const PCC__3GPP__Bearer__Usage_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PCC__3GPP__Bearer__Usage_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PCC__3GPP__Bearer__Usage_template(*other_value.implication_.precondition);
implication_.implied_template = new PCC__3GPP__Bearer__Usage_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
}
}

PCC__3GPP__Bearer__Usage_template::PCC__3GPP__Bearer__Usage_template()
{
}

PCC__3GPP__Bearer__Usage_template::PCC__3GPP__Bearer__Usage_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PCC__3GPP__Bearer__Usage_template::PCC__3GPP__Bearer__Usage_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!PCC__3GPP__Bearer__Usage::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage with unknown numeric value %d.", other_value);
single_value = (PCC__3GPP__Bearer__Usage::enum_type)other_value;
}

PCC__3GPP__Bearer__Usage_template::PCC__3GPP__Bearer__Usage_template(PCC__3GPP__Bearer__Usage::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

PCC__3GPP__Bearer__Usage_template::PCC__3GPP__Bearer__Usage_template(const PCC__3GPP__Bearer__Usage& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == PCC__3GPP__Bearer__Usage::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
single_value = other_value.enum_value;
}

PCC__3GPP__Bearer__Usage_template::PCC__3GPP__Bearer__Usage_template(const OPTIONAL<PCC__3GPP__Bearer__Usage>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (PCC__3GPP__Bearer__Usage::enum_type)(const PCC__3GPP__Bearer__Usage&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage from an unbound optional field.");
}
}

PCC__3GPP__Bearer__Usage_template::PCC__3GPP__Bearer__Usage_template(PCC__3GPP__Bearer__Usage_template* p_precondition, PCC__3GPP__Bearer__Usage_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PCC__3GPP__Bearer__Usage_template::PCC__3GPP__Bearer__Usage_template(Dynamic_Match_Interface<PCC__3GPP__Bearer__Usage>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PCC__3GPP__Bearer__Usage>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PCC__3GPP__Bearer__Usage_template::PCC__3GPP__Bearer__Usage_template(const PCC__3GPP__Bearer__Usage_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

PCC__3GPP__Bearer__Usage_template::~PCC__3GPP__Bearer__Usage_template()
{
clean_up();
}

boolean PCC__3GPP__Bearer__Usage_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean PCC__3GPP__Bearer__Usage_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != PCC__3GPP__Bearer__Usage::UNBOUND_VALUE;
}

void PCC__3GPP__Bearer__Usage_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PCC__3GPP__Bearer__Usage_template& PCC__3GPP__Bearer__Usage_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PCC__3GPP__Bearer__Usage_template& PCC__3GPP__Bearer__Usage_template::operator=(int other_value)
{
if (!PCC__3GPP__Bearer__Usage::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (PCC__3GPP__Bearer__Usage::enum_type)other_value;
return *this;
}

PCC__3GPP__Bearer__Usage_template& PCC__3GPP__Bearer__Usage_template::operator=(PCC__3GPP__Bearer__Usage::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

PCC__3GPP__Bearer__Usage_template& PCC__3GPP__Bearer__Usage_template::operator=(const PCC__3GPP__Bearer__Usage& other_value)
{
if (other_value.enum_value == PCC__3GPP__Bearer__Usage::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

PCC__3GPP__Bearer__Usage_template& PCC__3GPP__Bearer__Usage_template::operator=(const OPTIONAL<PCC__3GPP__Bearer__Usage>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (PCC__3GPP__Bearer__Usage::enum_type)(const PCC__3GPP__Bearer__Usage&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
}
return *this;
}

PCC__3GPP__Bearer__Usage_template& PCC__3GPP__Bearer__Usage_template::operator=(const PCC__3GPP__Bearer__Usage_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PCC__3GPP__Bearer__Usage_template::match(PCC__3GPP__Bearer__Usage::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
}
return FALSE;
}

boolean PCC__3GPP__Bearer__Usage_template::match(const PCC__3GPP__Bearer__Usage& other_value, boolean) const
{
if (other_value.enum_value == PCC__3GPP__Bearer__Usage::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage with an unbound value.");
return match(other_value.enum_value);
}

PCC__3GPP__Bearer__Usage::enum_type PCC__3GPP__Bearer__Usage_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
return single_value;
}

void PCC__3GPP__Bearer__Usage_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PCC__3GPP__Bearer__Usage_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
}
}

PCC__3GPP__Bearer__Usage_template& PCC__3GPP__Bearer__Usage_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
return value_list.list_value[list_index];
}

void PCC__3GPP__Bearer__Usage_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(PCC__3GPP__Bearer__Usage::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PCC__3GPP__Bearer__Usage_template::log_match(const PCC__3GPP__Bearer__Usage& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void PCC__3GPP__Bearer__Usage_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
}
}

void PCC__3GPP__Bearer__Usage_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (PCC__3GPP__Bearer__Usage::enum_type)text_buf.pull_int().get_val();
if (!PCC__3GPP__Bearer__Usage::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PCC__3GPP__Bearer__Usage_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
}
}

boolean PCC__3GPP__Bearer__Usage_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PCC__3GPP__Bearer__Usage_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void PCC__3GPP__Bearer__Usage_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PCC__3GPP__Bearer__Usage_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    PCC__3GPP__Bearer__Usage::enum_type enum_val = PCC__3GPP__Bearer__Usage::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!PCC__3GPP__Bearer__Usage::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.PCC_3GPP_Bearer_Usage.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    PCC__3GPP__Bearer__Usage_template* precondition = new PCC__3GPP__Bearer__Usage_template;
    precondition->set_param(*m_p->get_elem(0));
    PCC__3GPP__Bearer__Usage_template* implied_template = new PCC__3GPP__Bearer__Usage_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = PCC__3GPP__Bearer__Usage_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.PCC_3GPP_Bearer_Usage");
  }
  is_ifpresent = param.get_ifpresent();
}

void PCC__3GPP__Bearer__Usage_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.PCC_3GPP_Bearer_Usage");
}

DCA__3GPP__Status__AS__Code::DCA__3GPP__Status__AS__Code()
{
enum_value = UNBOUND_VALUE;
}

DCA__3GPP__Status__AS__Code::DCA__3GPP__Status__AS__Code(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

DCA__3GPP__Status__AS__Code::DCA__3GPP__Status__AS__Code(enum_type other_value)
{
enum_value = other_value;
}

DCA__3GPP__Status__AS__Code::DCA__3GPP__Status__AS__Code(const DCA__3GPP__Status__AS__Code& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
enum_value = other_value.enum_value;
}

DCA__3GPP__Status__AS__Code& DCA__3GPP__Status__AS__Code::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

DCA__3GPP__Status__AS__Code& DCA__3GPP__Status__AS__Code::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

DCA__3GPP__Status__AS__Code& DCA__3GPP__Status__AS__Code::operator=(const DCA__3GPP__Status__AS__Code& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
enum_value = other_value.enum_value;
return *this;
}

boolean DCA__3GPP__Status__AS__Code::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean DCA__3GPP__Status__AS__Code::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
return enum_value == other_value;
}

boolean DCA__3GPP__Status__AS__Code::operator==(const DCA__3GPP__Status__AS__Code& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
return enum_value == other_value.enum_value;
}

boolean DCA__3GPP__Status__AS__Code::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean DCA__3GPP__Status__AS__Code::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
return enum_value < other_value;
}

boolean DCA__3GPP__Status__AS__Code::operator<(const DCA__3GPP__Status__AS__Code& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
return enum_value < other_value.enum_value;
}

boolean DCA__3GPP__Status__AS__Code::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean DCA__3GPP__Status__AS__Code::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
return enum_value > other_value;
}

boolean DCA__3GPP__Status__AS__Code::operator>(const DCA__3GPP__Status__AS__Code& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
return enum_value > other_value.enum_value;
}

const char *DCA__3GPP__Status__AS__Code::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case code__4xx: return "code_4xx";
case code__5xx: return "code_5xx";
case Timeout: return "Timeout";
default:
return "<unknown>";
}
}

DCA__3GPP__Status__AS__Code::enum_type DCA__3GPP__Status__AS__Code::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "code_4xx")) return code__4xx;
if (!strcmp(str_par, "code_5xx")) return code__5xx;
if (!strcmp(str_par, "Timeout")) return Timeout;
}
return UNKNOWN_VALUE;
}

boolean DCA__3GPP__Status__AS__Code::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
return TRUE;
default:
return FALSE;
}
}

int DCA__3GPP__Status__AS__Code::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int DCA__3GPP__Status__AS__Code::enum2int(const DCA__3GPP__Status__AS__Code& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void DCA__3GPP__Status__AS__Code::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.", int_val);
enum_value = (enum_type)int_val;
}

DCA__3GPP__Status__AS__Code::operator DCA__3GPP__Status__AS__Code::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
return enum_value;
}

void DCA__3GPP__Status__AS__Code::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void DCA__3GPP__Status__AS__Code::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.DCA_3GPP_Status_AS_Code");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
  }
}

void DCA__3GPP__Status__AS__Code::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
text_buf.push_int(enum_value);
}

void DCA__3GPP__Status__AS__Code::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.", enum_value);
}

void DCA__3GPP__Status__AS__Code::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void DCA__3GPP__Status__AS__Code::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int DCA__3GPP__Status__AS__Code::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int DCA__3GPP__Status__AS__Code::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void DCA__3GPP__Status__AS__Code_template::copy_template(const DCA__3GPP__Status__AS__Code_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new DCA__3GPP__Status__AS__Code_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new DCA__3GPP__Status__AS__Code_template(*other_value.implication_.precondition);
implication_.implied_template = new DCA__3GPP__Status__AS__Code_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
}
}

DCA__3GPP__Status__AS__Code_template::DCA__3GPP__Status__AS__Code_template()
{
}

DCA__3GPP__Status__AS__Code_template::DCA__3GPP__Status__AS__Code_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

DCA__3GPP__Status__AS__Code_template::DCA__3GPP__Status__AS__Code_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!DCA__3GPP__Status__AS__Code::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code with unknown numeric value %d.", other_value);
single_value = (DCA__3GPP__Status__AS__Code::enum_type)other_value;
}

DCA__3GPP__Status__AS__Code_template::DCA__3GPP__Status__AS__Code_template(DCA__3GPP__Status__AS__Code::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

DCA__3GPP__Status__AS__Code_template::DCA__3GPP__Status__AS__Code_template(const DCA__3GPP__Status__AS__Code& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == DCA__3GPP__Status__AS__Code::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
single_value = other_value.enum_value;
}

DCA__3GPP__Status__AS__Code_template::DCA__3GPP__Status__AS__Code_template(const OPTIONAL<DCA__3GPP__Status__AS__Code>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__Status__AS__Code::enum_type)(const DCA__3GPP__Status__AS__Code&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code from an unbound optional field.");
}
}

DCA__3GPP__Status__AS__Code_template::DCA__3GPP__Status__AS__Code_template(DCA__3GPP__Status__AS__Code_template* p_precondition, DCA__3GPP__Status__AS__Code_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

DCA__3GPP__Status__AS__Code_template::DCA__3GPP__Status__AS__Code_template(Dynamic_Match_Interface<DCA__3GPP__Status__AS__Code>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<DCA__3GPP__Status__AS__Code>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

DCA__3GPP__Status__AS__Code_template::DCA__3GPP__Status__AS__Code_template(const DCA__3GPP__Status__AS__Code_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

DCA__3GPP__Status__AS__Code_template::~DCA__3GPP__Status__AS__Code_template()
{
clean_up();
}

boolean DCA__3GPP__Status__AS__Code_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean DCA__3GPP__Status__AS__Code_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != DCA__3GPP__Status__AS__Code::UNBOUND_VALUE;
}

void DCA__3GPP__Status__AS__Code_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

DCA__3GPP__Status__AS__Code_template& DCA__3GPP__Status__AS__Code_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

DCA__3GPP__Status__AS__Code_template& DCA__3GPP__Status__AS__Code_template::operator=(int other_value)
{
if (!DCA__3GPP__Status__AS__Code::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__Status__AS__Code::enum_type)other_value;
return *this;
}

DCA__3GPP__Status__AS__Code_template& DCA__3GPP__Status__AS__Code_template::operator=(DCA__3GPP__Status__AS__Code::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

DCA__3GPP__Status__AS__Code_template& DCA__3GPP__Status__AS__Code_template::operator=(const DCA__3GPP__Status__AS__Code& other_value)
{
if (other_value.enum_value == DCA__3GPP__Status__AS__Code::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

DCA__3GPP__Status__AS__Code_template& DCA__3GPP__Status__AS__Code_template::operator=(const OPTIONAL<DCA__3GPP__Status__AS__Code>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__Status__AS__Code::enum_type)(const DCA__3GPP__Status__AS__Code&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
}
return *this;
}

DCA__3GPP__Status__AS__Code_template& DCA__3GPP__Status__AS__Code_template::operator=(const DCA__3GPP__Status__AS__Code_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean DCA__3GPP__Status__AS__Code_template::match(DCA__3GPP__Status__AS__Code::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
}
return FALSE;
}

boolean DCA__3GPP__Status__AS__Code_template::match(const DCA__3GPP__Status__AS__Code& other_value, boolean) const
{
if (other_value.enum_value == DCA__3GPP__Status__AS__Code::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code with an unbound value.");
return match(other_value.enum_value);
}

DCA__3GPP__Status__AS__Code::enum_type DCA__3GPP__Status__AS__Code_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
return single_value;
}

void DCA__3GPP__Status__AS__Code_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new DCA__3GPP__Status__AS__Code_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
}
}

DCA__3GPP__Status__AS__Code_template& DCA__3GPP__Status__AS__Code_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
return value_list.list_value[list_index];
}

void DCA__3GPP__Status__AS__Code_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(DCA__3GPP__Status__AS__Code::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void DCA__3GPP__Status__AS__Code_template::log_match(const DCA__3GPP__Status__AS__Code& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void DCA__3GPP__Status__AS__Code_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
}
}

void DCA__3GPP__Status__AS__Code_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (DCA__3GPP__Status__AS__Code::enum_type)text_buf.pull_int().get_val();
if (!DCA__3GPP__Status__AS__Code::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new DCA__3GPP__Status__AS__Code_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
}
}

boolean DCA__3GPP__Status__AS__Code_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean DCA__3GPP__Status__AS__Code_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void DCA__3GPP__Status__AS__Code_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    DCA__3GPP__Status__AS__Code_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    DCA__3GPP__Status__AS__Code::enum_type enum_val = DCA__3GPP__Status__AS__Code::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!DCA__3GPP__Status__AS__Code::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.DCA_3GPP_Status_AS_Code.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    DCA__3GPP__Status__AS__Code_template* precondition = new DCA__3GPP__Status__AS__Code_template;
    precondition->set_param(*m_p->get_elem(0));
    DCA__3GPP__Status__AS__Code_template* implied_template = new DCA__3GPP__Status__AS__Code_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = DCA__3GPP__Status__AS__Code_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.DCA_3GPP_Status_AS_Code");
  }
  is_ifpresent = param.get_ifpresent();
}

void DCA__3GPP__Status__AS__Code_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.DCA_3GPP_Status_AS_Code");
}

DCA__3GPP__LCS__Client__Type::DCA__3GPP__LCS__Client__Type()
{
enum_value = UNBOUND_VALUE;
}

DCA__3GPP__LCS__Client__Type::DCA__3GPP__LCS__Client__Type(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

DCA__3GPP__LCS__Client__Type::DCA__3GPP__LCS__Client__Type(enum_type other_value)
{
enum_value = other_value;
}

DCA__3GPP__LCS__Client__Type::DCA__3GPP__LCS__Client__Type(const DCA__3GPP__LCS__Client__Type& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
enum_value = other_value.enum_value;
}

DCA__3GPP__LCS__Client__Type& DCA__3GPP__LCS__Client__Type::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

DCA__3GPP__LCS__Client__Type& DCA__3GPP__LCS__Client__Type::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

DCA__3GPP__LCS__Client__Type& DCA__3GPP__LCS__Client__Type::operator=(const DCA__3GPP__LCS__Client__Type& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
enum_value = other_value.enum_value;
return *this;
}

boolean DCA__3GPP__LCS__Client__Type::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean DCA__3GPP__LCS__Client__Type::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
return enum_value == other_value;
}

boolean DCA__3GPP__LCS__Client__Type::operator==(const DCA__3GPP__LCS__Client__Type& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
return enum_value == other_value.enum_value;
}

boolean DCA__3GPP__LCS__Client__Type::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean DCA__3GPP__LCS__Client__Type::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
return enum_value < other_value;
}

boolean DCA__3GPP__LCS__Client__Type::operator<(const DCA__3GPP__LCS__Client__Type& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
return enum_value < other_value.enum_value;
}

boolean DCA__3GPP__LCS__Client__Type::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean DCA__3GPP__LCS__Client__Type::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
return enum_value > other_value;
}

boolean DCA__3GPP__LCS__Client__Type::operator>(const DCA__3GPP__LCS__Client__Type& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
return enum_value > other_value.enum_value;
}

const char *DCA__3GPP__LCS__Client__Type::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case EMERGENCY__SERVICES: return "EMERGENCY_SERVICES";
case VALUE__ADDED__SERVICES: return "VALUE_ADDED_SERVICES";
case PLMN__OPERATOR__SERVICES: return "PLMN_OPERATOR_SERVICES";
case LAWFUL__INTERCEPT__SERVICES: return "LAWFUL_INTERCEPT_SERVICES";
default:
return "<unknown>";
}
}

DCA__3GPP__LCS__Client__Type::enum_type DCA__3GPP__LCS__Client__Type::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "EMERGENCY_SERVICES")) return EMERGENCY__SERVICES;
if (!strcmp(str_par, "VALUE_ADDED_SERVICES")) return VALUE__ADDED__SERVICES;
if (!strcmp(str_par, "PLMN_OPERATOR_SERVICES")) return PLMN__OPERATOR__SERVICES;
if (!strcmp(str_par, "LAWFUL_INTERCEPT_SERVICES")) return LAWFUL__INTERCEPT__SERVICES;
}
return UNKNOWN_VALUE;
}

boolean DCA__3GPP__LCS__Client__Type::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
return TRUE;
default:
return FALSE;
}
}

int DCA__3GPP__LCS__Client__Type::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int DCA__3GPP__LCS__Client__Type::enum2int(const DCA__3GPP__LCS__Client__Type& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void DCA__3GPP__LCS__Client__Type::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.", int_val);
enum_value = (enum_type)int_val;
}

DCA__3GPP__LCS__Client__Type::operator DCA__3GPP__LCS__Client__Type::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
return enum_value;
}

void DCA__3GPP__LCS__Client__Type::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void DCA__3GPP__LCS__Client__Type::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.DCA_3GPP_LCS_Client_Type");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
  }
}

void DCA__3GPP__LCS__Client__Type::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
text_buf.push_int(enum_value);
}

void DCA__3GPP__LCS__Client__Type::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.", enum_value);
}

void DCA__3GPP__LCS__Client__Type::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void DCA__3GPP__LCS__Client__Type::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int DCA__3GPP__LCS__Client__Type::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 3, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int DCA__3GPP__LCS__Client__Type::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 3);
}

void DCA__3GPP__LCS__Client__Type_template::copy_template(const DCA__3GPP__LCS__Client__Type_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new DCA__3GPP__LCS__Client__Type_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new DCA__3GPP__LCS__Client__Type_template(*other_value.implication_.precondition);
implication_.implied_template = new DCA__3GPP__LCS__Client__Type_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
}
}

DCA__3GPP__LCS__Client__Type_template::DCA__3GPP__LCS__Client__Type_template()
{
}

DCA__3GPP__LCS__Client__Type_template::DCA__3GPP__LCS__Client__Type_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

DCA__3GPP__LCS__Client__Type_template::DCA__3GPP__LCS__Client__Type_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!DCA__3GPP__LCS__Client__Type::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type with unknown numeric value %d.", other_value);
single_value = (DCA__3GPP__LCS__Client__Type::enum_type)other_value;
}

DCA__3GPP__LCS__Client__Type_template::DCA__3GPP__LCS__Client__Type_template(DCA__3GPP__LCS__Client__Type::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

DCA__3GPP__LCS__Client__Type_template::DCA__3GPP__LCS__Client__Type_template(const DCA__3GPP__LCS__Client__Type& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == DCA__3GPP__LCS__Client__Type::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
single_value = other_value.enum_value;
}

DCA__3GPP__LCS__Client__Type_template::DCA__3GPP__LCS__Client__Type_template(const OPTIONAL<DCA__3GPP__LCS__Client__Type>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__LCS__Client__Type::enum_type)(const DCA__3GPP__LCS__Client__Type&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type from an unbound optional field.");
}
}

DCA__3GPP__LCS__Client__Type_template::DCA__3GPP__LCS__Client__Type_template(DCA__3GPP__LCS__Client__Type_template* p_precondition, DCA__3GPP__LCS__Client__Type_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

DCA__3GPP__LCS__Client__Type_template::DCA__3GPP__LCS__Client__Type_template(Dynamic_Match_Interface<DCA__3GPP__LCS__Client__Type>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<DCA__3GPP__LCS__Client__Type>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

DCA__3GPP__LCS__Client__Type_template::DCA__3GPP__LCS__Client__Type_template(const DCA__3GPP__LCS__Client__Type_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

DCA__3GPP__LCS__Client__Type_template::~DCA__3GPP__LCS__Client__Type_template()
{
clean_up();
}

boolean DCA__3GPP__LCS__Client__Type_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean DCA__3GPP__LCS__Client__Type_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != DCA__3GPP__LCS__Client__Type::UNBOUND_VALUE;
}

void DCA__3GPP__LCS__Client__Type_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

DCA__3GPP__LCS__Client__Type_template& DCA__3GPP__LCS__Client__Type_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

DCA__3GPP__LCS__Client__Type_template& DCA__3GPP__LCS__Client__Type_template::operator=(int other_value)
{
if (!DCA__3GPP__LCS__Client__Type::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__LCS__Client__Type::enum_type)other_value;
return *this;
}

DCA__3GPP__LCS__Client__Type_template& DCA__3GPP__LCS__Client__Type_template::operator=(DCA__3GPP__LCS__Client__Type::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

DCA__3GPP__LCS__Client__Type_template& DCA__3GPP__LCS__Client__Type_template::operator=(const DCA__3GPP__LCS__Client__Type& other_value)
{
if (other_value.enum_value == DCA__3GPP__LCS__Client__Type::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

DCA__3GPP__LCS__Client__Type_template& DCA__3GPP__LCS__Client__Type_template::operator=(const OPTIONAL<DCA__3GPP__LCS__Client__Type>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__LCS__Client__Type::enum_type)(const DCA__3GPP__LCS__Client__Type&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
}
return *this;
}

DCA__3GPP__LCS__Client__Type_template& DCA__3GPP__LCS__Client__Type_template::operator=(const DCA__3GPP__LCS__Client__Type_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean DCA__3GPP__LCS__Client__Type_template::match(DCA__3GPP__LCS__Client__Type::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
}
return FALSE;
}

boolean DCA__3GPP__LCS__Client__Type_template::match(const DCA__3GPP__LCS__Client__Type& other_value, boolean) const
{
if (other_value.enum_value == DCA__3GPP__LCS__Client__Type::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type with an unbound value.");
return match(other_value.enum_value);
}

DCA__3GPP__LCS__Client__Type::enum_type DCA__3GPP__LCS__Client__Type_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
return single_value;
}

void DCA__3GPP__LCS__Client__Type_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new DCA__3GPP__LCS__Client__Type_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
}
}

DCA__3GPP__LCS__Client__Type_template& DCA__3GPP__LCS__Client__Type_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
return value_list.list_value[list_index];
}

void DCA__3GPP__LCS__Client__Type_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(DCA__3GPP__LCS__Client__Type::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void DCA__3GPP__LCS__Client__Type_template::log_match(const DCA__3GPP__LCS__Client__Type& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void DCA__3GPP__LCS__Client__Type_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
}
}

void DCA__3GPP__LCS__Client__Type_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (DCA__3GPP__LCS__Client__Type::enum_type)text_buf.pull_int().get_val();
if (!DCA__3GPP__LCS__Client__Type::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new DCA__3GPP__LCS__Client__Type_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
}
}

boolean DCA__3GPP__LCS__Client__Type_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean DCA__3GPP__LCS__Client__Type_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void DCA__3GPP__LCS__Client__Type_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    DCA__3GPP__LCS__Client__Type_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    DCA__3GPP__LCS__Client__Type::enum_type enum_val = DCA__3GPP__LCS__Client__Type::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!DCA__3GPP__LCS__Client__Type::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.DCA_3GPP_LCS_Client_Type.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    DCA__3GPP__LCS__Client__Type_template* precondition = new DCA__3GPP__LCS__Client__Type_template;
    precondition->set_param(*m_p->get_elem(0));
    DCA__3GPP__LCS__Client__Type_template* implied_template = new DCA__3GPP__LCS__Client__Type_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = DCA__3GPP__LCS__Client__Type_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.DCA_3GPP_LCS_Client_Type");
  }
  is_ifpresent = param.get_ifpresent();
}

void DCA__3GPP__LCS__Client__Type_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.DCA_3GPP_LCS_Client_Type");
}

DCA__3GPP__PoC__Session__Initiation__Type::DCA__3GPP__PoC__Session__Initiation__Type()
{
enum_value = UNBOUND_VALUE;
}

DCA__3GPP__PoC__Session__Initiation__Type::DCA__3GPP__PoC__Session__Initiation__Type(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

DCA__3GPP__PoC__Session__Initiation__Type::DCA__3GPP__PoC__Session__Initiation__Type(enum_type other_value)
{
enum_value = other_value;
}

DCA__3GPP__PoC__Session__Initiation__Type::DCA__3GPP__PoC__Session__Initiation__Type(const DCA__3GPP__PoC__Session__Initiation__Type& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
enum_value = other_value.enum_value;
}

DCA__3GPP__PoC__Session__Initiation__Type& DCA__3GPP__PoC__Session__Initiation__Type::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

DCA__3GPP__PoC__Session__Initiation__Type& DCA__3GPP__PoC__Session__Initiation__Type::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

DCA__3GPP__PoC__Session__Initiation__Type& DCA__3GPP__PoC__Session__Initiation__Type::operator=(const DCA__3GPP__PoC__Session__Initiation__Type& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
enum_value = other_value.enum_value;
return *this;
}

boolean DCA__3GPP__PoC__Session__Initiation__Type::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean DCA__3GPP__PoC__Session__Initiation__Type::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
return enum_value == other_value;
}

boolean DCA__3GPP__PoC__Session__Initiation__Type::operator==(const DCA__3GPP__PoC__Session__Initiation__Type& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
return enum_value == other_value.enum_value;
}

boolean DCA__3GPP__PoC__Session__Initiation__Type::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean DCA__3GPP__PoC__Session__Initiation__Type::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
return enum_value < other_value;
}

boolean DCA__3GPP__PoC__Session__Initiation__Type::operator<(const DCA__3GPP__PoC__Session__Initiation__Type& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
return enum_value < other_value.enum_value;
}

boolean DCA__3GPP__PoC__Session__Initiation__Type::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean DCA__3GPP__PoC__Session__Initiation__Type::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
return enum_value > other_value;
}

boolean DCA__3GPP__PoC__Session__Initiation__Type::operator>(const DCA__3GPP__PoC__Session__Initiation__Type& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
return enum_value > other_value.enum_value;
}

const char *DCA__3GPP__PoC__Session__Initiation__Type::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case PRE__ESTABLISHED: return "PRE_ESTABLISHED";
case ON__DEMAND: return "ON_DEMAND";
default:
return "<unknown>";
}
}

DCA__3GPP__PoC__Session__Initiation__Type::enum_type DCA__3GPP__PoC__Session__Initiation__Type::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "PRE_ESTABLISHED")) return PRE__ESTABLISHED;
if (!strcmp(str_par, "ON_DEMAND")) return ON__DEMAND;
}
return UNKNOWN_VALUE;
}

boolean DCA__3GPP__PoC__Session__Initiation__Type::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
return TRUE;
default:
return FALSE;
}
}

int DCA__3GPP__PoC__Session__Initiation__Type::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int DCA__3GPP__PoC__Session__Initiation__Type::enum2int(const DCA__3GPP__PoC__Session__Initiation__Type& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void DCA__3GPP__PoC__Session__Initiation__Type::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.", int_val);
enum_value = (enum_type)int_val;
}

DCA__3GPP__PoC__Session__Initiation__Type::operator DCA__3GPP__PoC__Session__Initiation__Type::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
return enum_value;
}

void DCA__3GPP__PoC__Session__Initiation__Type::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void DCA__3GPP__PoC__Session__Initiation__Type::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
  }
}

void DCA__3GPP__PoC__Session__Initiation__Type::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
text_buf.push_int(enum_value);
}

void DCA__3GPP__PoC__Session__Initiation__Type::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.", enum_value);
}

void DCA__3GPP__PoC__Session__Initiation__Type::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void DCA__3GPP__PoC__Session__Initiation__Type::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int DCA__3GPP__PoC__Session__Initiation__Type::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int DCA__3GPP__PoC__Session__Initiation__Type::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void DCA__3GPP__PoC__Session__Initiation__Type_template::copy_template(const DCA__3GPP__PoC__Session__Initiation__Type_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new DCA__3GPP__PoC__Session__Initiation__Type_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new DCA__3GPP__PoC__Session__Initiation__Type_template(*other_value.implication_.precondition);
implication_.implied_template = new DCA__3GPP__PoC__Session__Initiation__Type_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
}
}

DCA__3GPP__PoC__Session__Initiation__Type_template::DCA__3GPP__PoC__Session__Initiation__Type_template()
{
}

DCA__3GPP__PoC__Session__Initiation__Type_template::DCA__3GPP__PoC__Session__Initiation__Type_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

DCA__3GPP__PoC__Session__Initiation__Type_template::DCA__3GPP__PoC__Session__Initiation__Type_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!DCA__3GPP__PoC__Session__Initiation__Type::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type with unknown numeric value %d.", other_value);
single_value = (DCA__3GPP__PoC__Session__Initiation__Type::enum_type)other_value;
}

DCA__3GPP__PoC__Session__Initiation__Type_template::DCA__3GPP__PoC__Session__Initiation__Type_template(DCA__3GPP__PoC__Session__Initiation__Type::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

DCA__3GPP__PoC__Session__Initiation__Type_template::DCA__3GPP__PoC__Session__Initiation__Type_template(const DCA__3GPP__PoC__Session__Initiation__Type& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == DCA__3GPP__PoC__Session__Initiation__Type::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
single_value = other_value.enum_value;
}

DCA__3GPP__PoC__Session__Initiation__Type_template::DCA__3GPP__PoC__Session__Initiation__Type_template(const OPTIONAL<DCA__3GPP__PoC__Session__Initiation__Type>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__PoC__Session__Initiation__Type::enum_type)(const DCA__3GPP__PoC__Session__Initiation__Type&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type from an unbound optional field.");
}
}

DCA__3GPP__PoC__Session__Initiation__Type_template::DCA__3GPP__PoC__Session__Initiation__Type_template(DCA__3GPP__PoC__Session__Initiation__Type_template* p_precondition, DCA__3GPP__PoC__Session__Initiation__Type_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

DCA__3GPP__PoC__Session__Initiation__Type_template::DCA__3GPP__PoC__Session__Initiation__Type_template(Dynamic_Match_Interface<DCA__3GPP__PoC__Session__Initiation__Type>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<DCA__3GPP__PoC__Session__Initiation__Type>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

DCA__3GPP__PoC__Session__Initiation__Type_template::DCA__3GPP__PoC__Session__Initiation__Type_template(const DCA__3GPP__PoC__Session__Initiation__Type_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

DCA__3GPP__PoC__Session__Initiation__Type_template::~DCA__3GPP__PoC__Session__Initiation__Type_template()
{
clean_up();
}

boolean DCA__3GPP__PoC__Session__Initiation__Type_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean DCA__3GPP__PoC__Session__Initiation__Type_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != DCA__3GPP__PoC__Session__Initiation__Type::UNBOUND_VALUE;
}

void DCA__3GPP__PoC__Session__Initiation__Type_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

DCA__3GPP__PoC__Session__Initiation__Type_template& DCA__3GPP__PoC__Session__Initiation__Type_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

DCA__3GPP__PoC__Session__Initiation__Type_template& DCA__3GPP__PoC__Session__Initiation__Type_template::operator=(int other_value)
{
if (!DCA__3GPP__PoC__Session__Initiation__Type::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__PoC__Session__Initiation__Type::enum_type)other_value;
return *this;
}

DCA__3GPP__PoC__Session__Initiation__Type_template& DCA__3GPP__PoC__Session__Initiation__Type_template::operator=(DCA__3GPP__PoC__Session__Initiation__Type::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

DCA__3GPP__PoC__Session__Initiation__Type_template& DCA__3GPP__PoC__Session__Initiation__Type_template::operator=(const DCA__3GPP__PoC__Session__Initiation__Type& other_value)
{
if (other_value.enum_value == DCA__3GPP__PoC__Session__Initiation__Type::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

DCA__3GPP__PoC__Session__Initiation__Type_template& DCA__3GPP__PoC__Session__Initiation__Type_template::operator=(const OPTIONAL<DCA__3GPP__PoC__Session__Initiation__Type>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__PoC__Session__Initiation__Type::enum_type)(const DCA__3GPP__PoC__Session__Initiation__Type&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
}
return *this;
}

DCA__3GPP__PoC__Session__Initiation__Type_template& DCA__3GPP__PoC__Session__Initiation__Type_template::operator=(const DCA__3GPP__PoC__Session__Initiation__Type_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean DCA__3GPP__PoC__Session__Initiation__Type_template::match(DCA__3GPP__PoC__Session__Initiation__Type::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
}
return FALSE;
}

boolean DCA__3GPP__PoC__Session__Initiation__Type_template::match(const DCA__3GPP__PoC__Session__Initiation__Type& other_value, boolean) const
{
if (other_value.enum_value == DCA__3GPP__PoC__Session__Initiation__Type::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type with an unbound value.");
return match(other_value.enum_value);
}

DCA__3GPP__PoC__Session__Initiation__Type::enum_type DCA__3GPP__PoC__Session__Initiation__Type_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
return single_value;
}

void DCA__3GPP__PoC__Session__Initiation__Type_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new DCA__3GPP__PoC__Session__Initiation__Type_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
}
}

DCA__3GPP__PoC__Session__Initiation__Type_template& DCA__3GPP__PoC__Session__Initiation__Type_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
return value_list.list_value[list_index];
}

void DCA__3GPP__PoC__Session__Initiation__Type_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(DCA__3GPP__PoC__Session__Initiation__Type::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void DCA__3GPP__PoC__Session__Initiation__Type_template::log_match(const DCA__3GPP__PoC__Session__Initiation__Type& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void DCA__3GPP__PoC__Session__Initiation__Type_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
}
}

void DCA__3GPP__PoC__Session__Initiation__Type_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (DCA__3GPP__PoC__Session__Initiation__Type::enum_type)text_buf.pull_int().get_val();
if (!DCA__3GPP__PoC__Session__Initiation__Type::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new DCA__3GPP__PoC__Session__Initiation__Type_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
}
}

boolean DCA__3GPP__PoC__Session__Initiation__Type_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean DCA__3GPP__PoC__Session__Initiation__Type_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void DCA__3GPP__PoC__Session__Initiation__Type_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    DCA__3GPP__PoC__Session__Initiation__Type_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    DCA__3GPP__PoC__Session__Initiation__Type::enum_type enum_val = DCA__3GPP__PoC__Session__Initiation__Type::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!DCA__3GPP__PoC__Session__Initiation__Type::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    DCA__3GPP__PoC__Session__Initiation__Type_template* precondition = new DCA__3GPP__PoC__Session__Initiation__Type_template;
    precondition->set_param(*m_p->get_elem(0));
    DCA__3GPP__PoC__Session__Initiation__Type_template* implied_template = new DCA__3GPP__PoC__Session__Initiation__Type_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = DCA__3GPP__PoC__Session__Initiation__Type_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type");
  }
  is_ifpresent = param.get_ifpresent();
}

void DCA__3GPP__PoC__Session__Initiation__Type_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.DCA_3GPP_PoC_Session_Initiation_Type");
}

DCA__3GPP__ProSe__Event__Type::DCA__3GPP__ProSe__Event__Type()
{
enum_value = UNBOUND_VALUE;
}

DCA__3GPP__ProSe__Event__Type::DCA__3GPP__ProSe__Event__Type(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

DCA__3GPP__ProSe__Event__Type::DCA__3GPP__ProSe__Event__Type(enum_type other_value)
{
enum_value = other_value;
}

DCA__3GPP__ProSe__Event__Type::DCA__3GPP__ProSe__Event__Type(const DCA__3GPP__ProSe__Event__Type& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
enum_value = other_value.enum_value;
}

DCA__3GPP__ProSe__Event__Type& DCA__3GPP__ProSe__Event__Type::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

DCA__3GPP__ProSe__Event__Type& DCA__3GPP__ProSe__Event__Type::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

DCA__3GPP__ProSe__Event__Type& DCA__3GPP__ProSe__Event__Type::operator=(const DCA__3GPP__ProSe__Event__Type& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
enum_value = other_value.enum_value;
return *this;
}

boolean DCA__3GPP__ProSe__Event__Type::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean DCA__3GPP__ProSe__Event__Type::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
return enum_value == other_value;
}

boolean DCA__3GPP__ProSe__Event__Type::operator==(const DCA__3GPP__ProSe__Event__Type& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
return enum_value == other_value.enum_value;
}

boolean DCA__3GPP__ProSe__Event__Type::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean DCA__3GPP__ProSe__Event__Type::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
return enum_value < other_value;
}

boolean DCA__3GPP__ProSe__Event__Type::operator<(const DCA__3GPP__ProSe__Event__Type& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
return enum_value < other_value.enum_value;
}

boolean DCA__3GPP__ProSe__Event__Type::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean DCA__3GPP__ProSe__Event__Type::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
return enum_value > other_value;
}

boolean DCA__3GPP__ProSe__Event__Type::operator>(const DCA__3GPP__ProSe__Event__Type& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
return enum_value > other_value.enum_value;
}

const char *DCA__3GPP__ProSe__Event__Type::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case ANNOUNCING: return "ANNOUNCING";
case MONITORING: return "MONITORING";
case MATCH__REPORT: return "MATCH_REPORT";
default:
return "<unknown>";
}
}

DCA__3GPP__ProSe__Event__Type::enum_type DCA__3GPP__ProSe__Event__Type::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "ANNOUNCING")) return ANNOUNCING;
if (!strcmp(str_par, "MONITORING")) return MONITORING;
if (!strcmp(str_par, "MATCH_REPORT")) return MATCH__REPORT;
}
return UNKNOWN_VALUE;
}

boolean DCA__3GPP__ProSe__Event__Type::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
return TRUE;
default:
return FALSE;
}
}

int DCA__3GPP__ProSe__Event__Type::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int DCA__3GPP__ProSe__Event__Type::enum2int(const DCA__3GPP__ProSe__Event__Type& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void DCA__3GPP__ProSe__Event__Type::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.", int_val);
enum_value = (enum_type)int_val;
}

DCA__3GPP__ProSe__Event__Type::operator DCA__3GPP__ProSe__Event__Type::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
return enum_value;
}

void DCA__3GPP__ProSe__Event__Type::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void DCA__3GPP__ProSe__Event__Type::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.DCA_3GPP_ProSe_Event_Type");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
  }
}

void DCA__3GPP__ProSe__Event__Type::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
text_buf.push_int(enum_value);
}

void DCA__3GPP__ProSe__Event__Type::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.", enum_value);
}

void DCA__3GPP__ProSe__Event__Type::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void DCA__3GPP__ProSe__Event__Type::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int DCA__3GPP__ProSe__Event__Type::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int DCA__3GPP__ProSe__Event__Type::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void DCA__3GPP__ProSe__Event__Type_template::copy_template(const DCA__3GPP__ProSe__Event__Type_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new DCA__3GPP__ProSe__Event__Type_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new DCA__3GPP__ProSe__Event__Type_template(*other_value.implication_.precondition);
implication_.implied_template = new DCA__3GPP__ProSe__Event__Type_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
}
}

DCA__3GPP__ProSe__Event__Type_template::DCA__3GPP__ProSe__Event__Type_template()
{
}

DCA__3GPP__ProSe__Event__Type_template::DCA__3GPP__ProSe__Event__Type_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

DCA__3GPP__ProSe__Event__Type_template::DCA__3GPP__ProSe__Event__Type_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!DCA__3GPP__ProSe__Event__Type::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type with unknown numeric value %d.", other_value);
single_value = (DCA__3GPP__ProSe__Event__Type::enum_type)other_value;
}

DCA__3GPP__ProSe__Event__Type_template::DCA__3GPP__ProSe__Event__Type_template(DCA__3GPP__ProSe__Event__Type::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

DCA__3GPP__ProSe__Event__Type_template::DCA__3GPP__ProSe__Event__Type_template(const DCA__3GPP__ProSe__Event__Type& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == DCA__3GPP__ProSe__Event__Type::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
single_value = other_value.enum_value;
}

DCA__3GPP__ProSe__Event__Type_template::DCA__3GPP__ProSe__Event__Type_template(const OPTIONAL<DCA__3GPP__ProSe__Event__Type>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__ProSe__Event__Type::enum_type)(const DCA__3GPP__ProSe__Event__Type&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type from an unbound optional field.");
}
}

DCA__3GPP__ProSe__Event__Type_template::DCA__3GPP__ProSe__Event__Type_template(DCA__3GPP__ProSe__Event__Type_template* p_precondition, DCA__3GPP__ProSe__Event__Type_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

DCA__3GPP__ProSe__Event__Type_template::DCA__3GPP__ProSe__Event__Type_template(Dynamic_Match_Interface<DCA__3GPP__ProSe__Event__Type>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<DCA__3GPP__ProSe__Event__Type>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

DCA__3GPP__ProSe__Event__Type_template::DCA__3GPP__ProSe__Event__Type_template(const DCA__3GPP__ProSe__Event__Type_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

DCA__3GPP__ProSe__Event__Type_template::~DCA__3GPP__ProSe__Event__Type_template()
{
clean_up();
}

boolean DCA__3GPP__ProSe__Event__Type_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean DCA__3GPP__ProSe__Event__Type_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != DCA__3GPP__ProSe__Event__Type::UNBOUND_VALUE;
}

void DCA__3GPP__ProSe__Event__Type_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

DCA__3GPP__ProSe__Event__Type_template& DCA__3GPP__ProSe__Event__Type_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

DCA__3GPP__ProSe__Event__Type_template& DCA__3GPP__ProSe__Event__Type_template::operator=(int other_value)
{
if (!DCA__3GPP__ProSe__Event__Type::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__ProSe__Event__Type::enum_type)other_value;
return *this;
}

DCA__3GPP__ProSe__Event__Type_template& DCA__3GPP__ProSe__Event__Type_template::operator=(DCA__3GPP__ProSe__Event__Type::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

DCA__3GPP__ProSe__Event__Type_template& DCA__3GPP__ProSe__Event__Type_template::operator=(const DCA__3GPP__ProSe__Event__Type& other_value)
{
if (other_value.enum_value == DCA__3GPP__ProSe__Event__Type::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

DCA__3GPP__ProSe__Event__Type_template& DCA__3GPP__ProSe__Event__Type_template::operator=(const OPTIONAL<DCA__3GPP__ProSe__Event__Type>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__ProSe__Event__Type::enum_type)(const DCA__3GPP__ProSe__Event__Type&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
}
return *this;
}

DCA__3GPP__ProSe__Event__Type_template& DCA__3GPP__ProSe__Event__Type_template::operator=(const DCA__3GPP__ProSe__Event__Type_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean DCA__3GPP__ProSe__Event__Type_template::match(DCA__3GPP__ProSe__Event__Type::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
}
return FALSE;
}

boolean DCA__3GPP__ProSe__Event__Type_template::match(const DCA__3GPP__ProSe__Event__Type& other_value, boolean) const
{
if (other_value.enum_value == DCA__3GPP__ProSe__Event__Type::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type with an unbound value.");
return match(other_value.enum_value);
}

DCA__3GPP__ProSe__Event__Type::enum_type DCA__3GPP__ProSe__Event__Type_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
return single_value;
}

void DCA__3GPP__ProSe__Event__Type_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new DCA__3GPP__ProSe__Event__Type_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
}
}

DCA__3GPP__ProSe__Event__Type_template& DCA__3GPP__ProSe__Event__Type_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
return value_list.list_value[list_index];
}

void DCA__3GPP__ProSe__Event__Type_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(DCA__3GPP__ProSe__Event__Type::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void DCA__3GPP__ProSe__Event__Type_template::log_match(const DCA__3GPP__ProSe__Event__Type& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void DCA__3GPP__ProSe__Event__Type_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
}
}

void DCA__3GPP__ProSe__Event__Type_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (DCA__3GPP__ProSe__Event__Type::enum_type)text_buf.pull_int().get_val();
if (!DCA__3GPP__ProSe__Event__Type::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new DCA__3GPP__ProSe__Event__Type_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
}
}

boolean DCA__3GPP__ProSe__Event__Type_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean DCA__3GPP__ProSe__Event__Type_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void DCA__3GPP__ProSe__Event__Type_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    DCA__3GPP__ProSe__Event__Type_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    DCA__3GPP__ProSe__Event__Type::enum_type enum_val = DCA__3GPP__ProSe__Event__Type::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!DCA__3GPP__ProSe__Event__Type::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.DCA_3GPP_ProSe_Event_Type.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    DCA__3GPP__ProSe__Event__Type_template* precondition = new DCA__3GPP__ProSe__Event__Type_template;
    precondition->set_param(*m_p->get_elem(0));
    DCA__3GPP__ProSe__Event__Type_template* implied_template = new DCA__3GPP__ProSe__Event__Type_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = DCA__3GPP__ProSe__Event__Type_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.DCA_3GPP_ProSe_Event_Type");
  }
  is_ifpresent = param.get_ifpresent();
}

void DCA__3GPP__ProSe__Event__Type_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.DCA_3GPP_ProSe_Event_Type");
}

PCC__3GPP__Network__Request__Support::PCC__3GPP__Network__Request__Support()
{
enum_value = UNBOUND_VALUE;
}

PCC__3GPP__Network__Request__Support::PCC__3GPP__Network__Request__Support(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

PCC__3GPP__Network__Request__Support::PCC__3GPP__Network__Request__Support(enum_type other_value)
{
enum_value = other_value;
}

PCC__3GPP__Network__Request__Support::PCC__3GPP__Network__Request__Support(const PCC__3GPP__Network__Request__Support& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
enum_value = other_value.enum_value;
}

PCC__3GPP__Network__Request__Support& PCC__3GPP__Network__Request__Support::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

PCC__3GPP__Network__Request__Support& PCC__3GPP__Network__Request__Support::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

PCC__3GPP__Network__Request__Support& PCC__3GPP__Network__Request__Support::operator=(const PCC__3GPP__Network__Request__Support& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
enum_value = other_value.enum_value;
return *this;
}

boolean PCC__3GPP__Network__Request__Support::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean PCC__3GPP__Network__Request__Support::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
return enum_value == other_value;
}

boolean PCC__3GPP__Network__Request__Support::operator==(const PCC__3GPP__Network__Request__Support& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
return enum_value == other_value.enum_value;
}

boolean PCC__3GPP__Network__Request__Support::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean PCC__3GPP__Network__Request__Support::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
return enum_value < other_value;
}

boolean PCC__3GPP__Network__Request__Support::operator<(const PCC__3GPP__Network__Request__Support& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
return enum_value < other_value.enum_value;
}

boolean PCC__3GPP__Network__Request__Support::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean PCC__3GPP__Network__Request__Support::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
return enum_value > other_value;
}

boolean PCC__3GPP__Network__Request__Support::operator>(const PCC__3GPP__Network__Request__Support& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
return enum_value > other_value.enum_value;
}

const char *PCC__3GPP__Network__Request__Support::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case NETWORK__REQUEST__NOT__SUPPORTED: return "NETWORK_REQUEST_NOT_SUPPORTED";
case NETWORK__REQUEST__SUPPORTED: return "NETWORK_REQUEST_SUPPORTED";
default:
return "<unknown>";
}
}

PCC__3GPP__Network__Request__Support::enum_type PCC__3GPP__Network__Request__Support::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "NETWORK_REQUEST_NOT_SUPPORTED")) return NETWORK__REQUEST__NOT__SUPPORTED;
if (!strcmp(str_par, "NETWORK_REQUEST_SUPPORTED")) return NETWORK__REQUEST__SUPPORTED;
}
return UNKNOWN_VALUE;
}

boolean PCC__3GPP__Network__Request__Support::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
return TRUE;
default:
return FALSE;
}
}

int PCC__3GPP__Network__Request__Support::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int PCC__3GPP__Network__Request__Support::enum2int(const PCC__3GPP__Network__Request__Support& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void PCC__3GPP__Network__Request__Support::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.", int_val);
enum_value = (enum_type)int_val;
}

PCC__3GPP__Network__Request__Support::operator PCC__3GPP__Network__Request__Support::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
return enum_value;
}

void PCC__3GPP__Network__Request__Support::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void PCC__3GPP__Network__Request__Support::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.PCC_3GPP_Network_Request_Support");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
  }
}

void PCC__3GPP__Network__Request__Support::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
text_buf.push_int(enum_value);
}

void PCC__3GPP__Network__Request__Support::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.", enum_value);
}

void PCC__3GPP__Network__Request__Support::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PCC__3GPP__Network__Request__Support::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PCC__3GPP__Network__Request__Support::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int PCC__3GPP__Network__Request__Support::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void PCC__3GPP__Network__Request__Support_template::copy_template(const PCC__3GPP__Network__Request__Support_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PCC__3GPP__Network__Request__Support_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PCC__3GPP__Network__Request__Support_template(*other_value.implication_.precondition);
implication_.implied_template = new PCC__3GPP__Network__Request__Support_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
}
}

PCC__3GPP__Network__Request__Support_template::PCC__3GPP__Network__Request__Support_template()
{
}

PCC__3GPP__Network__Request__Support_template::PCC__3GPP__Network__Request__Support_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PCC__3GPP__Network__Request__Support_template::PCC__3GPP__Network__Request__Support_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!PCC__3GPP__Network__Request__Support::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support with unknown numeric value %d.", other_value);
single_value = (PCC__3GPP__Network__Request__Support::enum_type)other_value;
}

PCC__3GPP__Network__Request__Support_template::PCC__3GPP__Network__Request__Support_template(PCC__3GPP__Network__Request__Support::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

PCC__3GPP__Network__Request__Support_template::PCC__3GPP__Network__Request__Support_template(const PCC__3GPP__Network__Request__Support& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == PCC__3GPP__Network__Request__Support::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
single_value = other_value.enum_value;
}

PCC__3GPP__Network__Request__Support_template::PCC__3GPP__Network__Request__Support_template(const OPTIONAL<PCC__3GPP__Network__Request__Support>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (PCC__3GPP__Network__Request__Support::enum_type)(const PCC__3GPP__Network__Request__Support&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support from an unbound optional field.");
}
}

PCC__3GPP__Network__Request__Support_template::PCC__3GPP__Network__Request__Support_template(PCC__3GPP__Network__Request__Support_template* p_precondition, PCC__3GPP__Network__Request__Support_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PCC__3GPP__Network__Request__Support_template::PCC__3GPP__Network__Request__Support_template(Dynamic_Match_Interface<PCC__3GPP__Network__Request__Support>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PCC__3GPP__Network__Request__Support>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PCC__3GPP__Network__Request__Support_template::PCC__3GPP__Network__Request__Support_template(const PCC__3GPP__Network__Request__Support_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

PCC__3GPP__Network__Request__Support_template::~PCC__3GPP__Network__Request__Support_template()
{
clean_up();
}

boolean PCC__3GPP__Network__Request__Support_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean PCC__3GPP__Network__Request__Support_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != PCC__3GPP__Network__Request__Support::UNBOUND_VALUE;
}

void PCC__3GPP__Network__Request__Support_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PCC__3GPP__Network__Request__Support_template& PCC__3GPP__Network__Request__Support_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PCC__3GPP__Network__Request__Support_template& PCC__3GPP__Network__Request__Support_template::operator=(int other_value)
{
if (!PCC__3GPP__Network__Request__Support::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (PCC__3GPP__Network__Request__Support::enum_type)other_value;
return *this;
}

PCC__3GPP__Network__Request__Support_template& PCC__3GPP__Network__Request__Support_template::operator=(PCC__3GPP__Network__Request__Support::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

PCC__3GPP__Network__Request__Support_template& PCC__3GPP__Network__Request__Support_template::operator=(const PCC__3GPP__Network__Request__Support& other_value)
{
if (other_value.enum_value == PCC__3GPP__Network__Request__Support::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

PCC__3GPP__Network__Request__Support_template& PCC__3GPP__Network__Request__Support_template::operator=(const OPTIONAL<PCC__3GPP__Network__Request__Support>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (PCC__3GPP__Network__Request__Support::enum_type)(const PCC__3GPP__Network__Request__Support&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
}
return *this;
}

PCC__3GPP__Network__Request__Support_template& PCC__3GPP__Network__Request__Support_template::operator=(const PCC__3GPP__Network__Request__Support_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PCC__3GPP__Network__Request__Support_template::match(PCC__3GPP__Network__Request__Support::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
}
return FALSE;
}

boolean PCC__3GPP__Network__Request__Support_template::match(const PCC__3GPP__Network__Request__Support& other_value, boolean) const
{
if (other_value.enum_value == PCC__3GPP__Network__Request__Support::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support with an unbound value.");
return match(other_value.enum_value);
}

PCC__3GPP__Network__Request__Support::enum_type PCC__3GPP__Network__Request__Support_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
return single_value;
}

void PCC__3GPP__Network__Request__Support_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PCC__3GPP__Network__Request__Support_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
}
}

PCC__3GPP__Network__Request__Support_template& PCC__3GPP__Network__Request__Support_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
return value_list.list_value[list_index];
}

void PCC__3GPP__Network__Request__Support_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(PCC__3GPP__Network__Request__Support::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PCC__3GPP__Network__Request__Support_template::log_match(const PCC__3GPP__Network__Request__Support& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void PCC__3GPP__Network__Request__Support_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
}
}

void PCC__3GPP__Network__Request__Support_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (PCC__3GPP__Network__Request__Support::enum_type)text_buf.pull_int().get_val();
if (!PCC__3GPP__Network__Request__Support::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PCC__3GPP__Network__Request__Support_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
}
}

boolean PCC__3GPP__Network__Request__Support_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PCC__3GPP__Network__Request__Support_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void PCC__3GPP__Network__Request__Support_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PCC__3GPP__Network__Request__Support_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    PCC__3GPP__Network__Request__Support::enum_type enum_val = PCC__3GPP__Network__Request__Support::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!PCC__3GPP__Network__Request__Support::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.PCC_3GPP_Network_Request_Support.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    PCC__3GPP__Network__Request__Support_template* precondition = new PCC__3GPP__Network__Request__Support_template;
    precondition->set_param(*m_p->get_elem(0));
    PCC__3GPP__Network__Request__Support_template* implied_template = new PCC__3GPP__Network__Request__Support_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = PCC__3GPP__Network__Request__Support_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.PCC_3GPP_Network_Request_Support");
  }
  is_ifpresent = param.get_ifpresent();
}

void PCC__3GPP__Network__Request__Support_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.PCC_3GPP_Network_Request_Support");
}

AAA__3GPP__SIPTO__Permission::AAA__3GPP__SIPTO__Permission()
{
enum_value = UNBOUND_VALUE;
}

AAA__3GPP__SIPTO__Permission::AAA__3GPP__SIPTO__Permission(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

AAA__3GPP__SIPTO__Permission::AAA__3GPP__SIPTO__Permission(enum_type other_value)
{
enum_value = other_value;
}

AAA__3GPP__SIPTO__Permission::AAA__3GPP__SIPTO__Permission(const AAA__3GPP__SIPTO__Permission& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
enum_value = other_value.enum_value;
}

AAA__3GPP__SIPTO__Permission& AAA__3GPP__SIPTO__Permission::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

AAA__3GPP__SIPTO__Permission& AAA__3GPP__SIPTO__Permission::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

AAA__3GPP__SIPTO__Permission& AAA__3GPP__SIPTO__Permission::operator=(const AAA__3GPP__SIPTO__Permission& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
enum_value = other_value.enum_value;
return *this;
}

boolean AAA__3GPP__SIPTO__Permission::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean AAA__3GPP__SIPTO__Permission::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
return enum_value == other_value;
}

boolean AAA__3GPP__SIPTO__Permission::operator==(const AAA__3GPP__SIPTO__Permission& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
return enum_value == other_value.enum_value;
}

boolean AAA__3GPP__SIPTO__Permission::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean AAA__3GPP__SIPTO__Permission::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
return enum_value < other_value;
}

boolean AAA__3GPP__SIPTO__Permission::operator<(const AAA__3GPP__SIPTO__Permission& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
return enum_value < other_value.enum_value;
}

boolean AAA__3GPP__SIPTO__Permission::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean AAA__3GPP__SIPTO__Permission::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
return enum_value > other_value;
}

boolean AAA__3GPP__SIPTO__Permission::operator>(const AAA__3GPP__SIPTO__Permission& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
return enum_value > other_value.enum_value;
}

const char *AAA__3GPP__SIPTO__Permission::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case SIPTO__ALLOWED: return "SIPTO_ALLOWED";
case SIPTO__NOTALLOWED: return "SIPTO_NOTALLOWED";
default:
return "<unknown>";
}
}

AAA__3GPP__SIPTO__Permission::enum_type AAA__3GPP__SIPTO__Permission::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "SIPTO_ALLOWED")) return SIPTO__ALLOWED;
if (!strcmp(str_par, "SIPTO_NOTALLOWED")) return SIPTO__NOTALLOWED;
}
return UNKNOWN_VALUE;
}

boolean AAA__3GPP__SIPTO__Permission::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
return TRUE;
default:
return FALSE;
}
}

int AAA__3GPP__SIPTO__Permission::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int AAA__3GPP__SIPTO__Permission::enum2int(const AAA__3GPP__SIPTO__Permission& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void AAA__3GPP__SIPTO__Permission::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.", int_val);
enum_value = (enum_type)int_val;
}

AAA__3GPP__SIPTO__Permission::operator AAA__3GPP__SIPTO__Permission::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
return enum_value;
}

void AAA__3GPP__SIPTO__Permission::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void AAA__3GPP__SIPTO__Permission::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.AAA_3GPP_SIPTO_Permission");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
  }
}

void AAA__3GPP__SIPTO__Permission::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
text_buf.push_int(enum_value);
}

void AAA__3GPP__SIPTO__Permission::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.", enum_value);
}

void AAA__3GPP__SIPTO__Permission::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void AAA__3GPP__SIPTO__Permission::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int AAA__3GPP__SIPTO__Permission::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int AAA__3GPP__SIPTO__Permission::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void AAA__3GPP__SIPTO__Permission_template::copy_template(const AAA__3GPP__SIPTO__Permission_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new AAA__3GPP__SIPTO__Permission_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new AAA__3GPP__SIPTO__Permission_template(*other_value.implication_.precondition);
implication_.implied_template = new AAA__3GPP__SIPTO__Permission_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
}
}

AAA__3GPP__SIPTO__Permission_template::AAA__3GPP__SIPTO__Permission_template()
{
}

AAA__3GPP__SIPTO__Permission_template::AAA__3GPP__SIPTO__Permission_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

AAA__3GPP__SIPTO__Permission_template::AAA__3GPP__SIPTO__Permission_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!AAA__3GPP__SIPTO__Permission::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission with unknown numeric value %d.", other_value);
single_value = (AAA__3GPP__SIPTO__Permission::enum_type)other_value;
}

AAA__3GPP__SIPTO__Permission_template::AAA__3GPP__SIPTO__Permission_template(AAA__3GPP__SIPTO__Permission::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

AAA__3GPP__SIPTO__Permission_template::AAA__3GPP__SIPTO__Permission_template(const AAA__3GPP__SIPTO__Permission& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == AAA__3GPP__SIPTO__Permission::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
single_value = other_value.enum_value;
}

AAA__3GPP__SIPTO__Permission_template::AAA__3GPP__SIPTO__Permission_template(const OPTIONAL<AAA__3GPP__SIPTO__Permission>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (AAA__3GPP__SIPTO__Permission::enum_type)(const AAA__3GPP__SIPTO__Permission&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission from an unbound optional field.");
}
}

AAA__3GPP__SIPTO__Permission_template::AAA__3GPP__SIPTO__Permission_template(AAA__3GPP__SIPTO__Permission_template* p_precondition, AAA__3GPP__SIPTO__Permission_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

AAA__3GPP__SIPTO__Permission_template::AAA__3GPP__SIPTO__Permission_template(Dynamic_Match_Interface<AAA__3GPP__SIPTO__Permission>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<AAA__3GPP__SIPTO__Permission>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

AAA__3GPP__SIPTO__Permission_template::AAA__3GPP__SIPTO__Permission_template(const AAA__3GPP__SIPTO__Permission_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

AAA__3GPP__SIPTO__Permission_template::~AAA__3GPP__SIPTO__Permission_template()
{
clean_up();
}

boolean AAA__3GPP__SIPTO__Permission_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean AAA__3GPP__SIPTO__Permission_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != AAA__3GPP__SIPTO__Permission::UNBOUND_VALUE;
}

void AAA__3GPP__SIPTO__Permission_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

AAA__3GPP__SIPTO__Permission_template& AAA__3GPP__SIPTO__Permission_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

AAA__3GPP__SIPTO__Permission_template& AAA__3GPP__SIPTO__Permission_template::operator=(int other_value)
{
if (!AAA__3GPP__SIPTO__Permission::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (AAA__3GPP__SIPTO__Permission::enum_type)other_value;
return *this;
}

AAA__3GPP__SIPTO__Permission_template& AAA__3GPP__SIPTO__Permission_template::operator=(AAA__3GPP__SIPTO__Permission::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

AAA__3GPP__SIPTO__Permission_template& AAA__3GPP__SIPTO__Permission_template::operator=(const AAA__3GPP__SIPTO__Permission& other_value)
{
if (other_value.enum_value == AAA__3GPP__SIPTO__Permission::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

AAA__3GPP__SIPTO__Permission_template& AAA__3GPP__SIPTO__Permission_template::operator=(const OPTIONAL<AAA__3GPP__SIPTO__Permission>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (AAA__3GPP__SIPTO__Permission::enum_type)(const AAA__3GPP__SIPTO__Permission&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
}
return *this;
}

AAA__3GPP__SIPTO__Permission_template& AAA__3GPP__SIPTO__Permission_template::operator=(const AAA__3GPP__SIPTO__Permission_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean AAA__3GPP__SIPTO__Permission_template::match(AAA__3GPP__SIPTO__Permission::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
}
return FALSE;
}

boolean AAA__3GPP__SIPTO__Permission_template::match(const AAA__3GPP__SIPTO__Permission& other_value, boolean) const
{
if (other_value.enum_value == AAA__3GPP__SIPTO__Permission::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission with an unbound value.");
return match(other_value.enum_value);
}

AAA__3GPP__SIPTO__Permission::enum_type AAA__3GPP__SIPTO__Permission_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
return single_value;
}

void AAA__3GPP__SIPTO__Permission_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new AAA__3GPP__SIPTO__Permission_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
}
}

AAA__3GPP__SIPTO__Permission_template& AAA__3GPP__SIPTO__Permission_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
return value_list.list_value[list_index];
}

void AAA__3GPP__SIPTO__Permission_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(AAA__3GPP__SIPTO__Permission::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void AAA__3GPP__SIPTO__Permission_template::log_match(const AAA__3GPP__SIPTO__Permission& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void AAA__3GPP__SIPTO__Permission_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
}
}

void AAA__3GPP__SIPTO__Permission_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (AAA__3GPP__SIPTO__Permission::enum_type)text_buf.pull_int().get_val();
if (!AAA__3GPP__SIPTO__Permission::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new AAA__3GPP__SIPTO__Permission_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
}
}

boolean AAA__3GPP__SIPTO__Permission_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean AAA__3GPP__SIPTO__Permission_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void AAA__3GPP__SIPTO__Permission_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    AAA__3GPP__SIPTO__Permission_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    AAA__3GPP__SIPTO__Permission::enum_type enum_val = AAA__3GPP__SIPTO__Permission::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!AAA__3GPP__SIPTO__Permission::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.AAA_3GPP_SIPTO_Permission.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    AAA__3GPP__SIPTO__Permission_template* precondition = new AAA__3GPP__SIPTO__Permission_template;
    precondition->set_param(*m_p->get_elem(0));
    AAA__3GPP__SIPTO__Permission_template* implied_template = new AAA__3GPP__SIPTO__Permission_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = AAA__3GPP__SIPTO__Permission_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.AAA_3GPP_SIPTO_Permission");
  }
  is_ifpresent = param.get_ifpresent();
}

void AAA__3GPP__SIPTO__Permission_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.AAA_3GPP_SIPTO_Permission");
}

CxDx__3GPP__User__Authorization__Type::CxDx__3GPP__User__Authorization__Type()
{
enum_value = UNBOUND_VALUE;
}

CxDx__3GPP__User__Authorization__Type::CxDx__3GPP__User__Authorization__Type(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

CxDx__3GPP__User__Authorization__Type::CxDx__3GPP__User__Authorization__Type(enum_type other_value)
{
enum_value = other_value;
}

CxDx__3GPP__User__Authorization__Type::CxDx__3GPP__User__Authorization__Type(const CxDx__3GPP__User__Authorization__Type& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
enum_value = other_value.enum_value;
}

CxDx__3GPP__User__Authorization__Type& CxDx__3GPP__User__Authorization__Type::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

CxDx__3GPP__User__Authorization__Type& CxDx__3GPP__User__Authorization__Type::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

CxDx__3GPP__User__Authorization__Type& CxDx__3GPP__User__Authorization__Type::operator=(const CxDx__3GPP__User__Authorization__Type& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
enum_value = other_value.enum_value;
return *this;
}

boolean CxDx__3GPP__User__Authorization__Type::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean CxDx__3GPP__User__Authorization__Type::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
return enum_value == other_value;
}

boolean CxDx__3GPP__User__Authorization__Type::operator==(const CxDx__3GPP__User__Authorization__Type& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
return enum_value == other_value.enum_value;
}

boolean CxDx__3GPP__User__Authorization__Type::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean CxDx__3GPP__User__Authorization__Type::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
return enum_value < other_value;
}

boolean CxDx__3GPP__User__Authorization__Type::operator<(const CxDx__3GPP__User__Authorization__Type& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
return enum_value < other_value.enum_value;
}

boolean CxDx__3GPP__User__Authorization__Type::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean CxDx__3GPP__User__Authorization__Type::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
return enum_value > other_value;
}

boolean CxDx__3GPP__User__Authorization__Type::operator>(const CxDx__3GPP__User__Authorization__Type& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
return enum_value > other_value.enum_value;
}

const char *CxDx__3GPP__User__Authorization__Type::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case REGISTRATION: return "REGISTRATION";
case DE__REGISTRATION: return "DE_REGISTRATION";
case REGISTRATION__AND__CAPABILITIES: return "REGISTRATION_AND_CAPABILITIES";
default:
return "<unknown>";
}
}

CxDx__3GPP__User__Authorization__Type::enum_type CxDx__3GPP__User__Authorization__Type::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "REGISTRATION")) return REGISTRATION;
if (!strcmp(str_par, "DE_REGISTRATION")) return DE__REGISTRATION;
if (!strcmp(str_par, "REGISTRATION_AND_CAPABILITIES")) return REGISTRATION__AND__CAPABILITIES;
}
return UNKNOWN_VALUE;
}

boolean CxDx__3GPP__User__Authorization__Type::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
return TRUE;
default:
return FALSE;
}
}

int CxDx__3GPP__User__Authorization__Type::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int CxDx__3GPP__User__Authorization__Type::enum2int(const CxDx__3GPP__User__Authorization__Type& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void CxDx__3GPP__User__Authorization__Type::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.", int_val);
enum_value = (enum_type)int_val;
}

CxDx__3GPP__User__Authorization__Type::operator CxDx__3GPP__User__Authorization__Type::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
return enum_value;
}

void CxDx__3GPP__User__Authorization__Type::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void CxDx__3GPP__User__Authorization__Type::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.CxDx_3GPP_User_Authorization_Type");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
  }
}

void CxDx__3GPP__User__Authorization__Type::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
text_buf.push_int(enum_value);
}

void CxDx__3GPP__User__Authorization__Type::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.", enum_value);
}

void CxDx__3GPP__User__Authorization__Type::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void CxDx__3GPP__User__Authorization__Type::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int CxDx__3GPP__User__Authorization__Type::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int CxDx__3GPP__User__Authorization__Type::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void CxDx__3GPP__User__Authorization__Type_template::copy_template(const CxDx__3GPP__User__Authorization__Type_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new CxDx__3GPP__User__Authorization__Type_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new CxDx__3GPP__User__Authorization__Type_template(*other_value.implication_.precondition);
implication_.implied_template = new CxDx__3GPP__User__Authorization__Type_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
}
}

CxDx__3GPP__User__Authorization__Type_template::CxDx__3GPP__User__Authorization__Type_template()
{
}

CxDx__3GPP__User__Authorization__Type_template::CxDx__3GPP__User__Authorization__Type_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

CxDx__3GPP__User__Authorization__Type_template::CxDx__3GPP__User__Authorization__Type_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!CxDx__3GPP__User__Authorization__Type::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type with unknown numeric value %d.", other_value);
single_value = (CxDx__3GPP__User__Authorization__Type::enum_type)other_value;
}

CxDx__3GPP__User__Authorization__Type_template::CxDx__3GPP__User__Authorization__Type_template(CxDx__3GPP__User__Authorization__Type::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

CxDx__3GPP__User__Authorization__Type_template::CxDx__3GPP__User__Authorization__Type_template(const CxDx__3GPP__User__Authorization__Type& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == CxDx__3GPP__User__Authorization__Type::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
single_value = other_value.enum_value;
}

CxDx__3GPP__User__Authorization__Type_template::CxDx__3GPP__User__Authorization__Type_template(const OPTIONAL<CxDx__3GPP__User__Authorization__Type>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (CxDx__3GPP__User__Authorization__Type::enum_type)(const CxDx__3GPP__User__Authorization__Type&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type from an unbound optional field.");
}
}

CxDx__3GPP__User__Authorization__Type_template::CxDx__3GPP__User__Authorization__Type_template(CxDx__3GPP__User__Authorization__Type_template* p_precondition, CxDx__3GPP__User__Authorization__Type_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

CxDx__3GPP__User__Authorization__Type_template::CxDx__3GPP__User__Authorization__Type_template(Dynamic_Match_Interface<CxDx__3GPP__User__Authorization__Type>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<CxDx__3GPP__User__Authorization__Type>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

CxDx__3GPP__User__Authorization__Type_template::CxDx__3GPP__User__Authorization__Type_template(const CxDx__3GPP__User__Authorization__Type_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

CxDx__3GPP__User__Authorization__Type_template::~CxDx__3GPP__User__Authorization__Type_template()
{
clean_up();
}

boolean CxDx__3GPP__User__Authorization__Type_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean CxDx__3GPP__User__Authorization__Type_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != CxDx__3GPP__User__Authorization__Type::UNBOUND_VALUE;
}

void CxDx__3GPP__User__Authorization__Type_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

CxDx__3GPP__User__Authorization__Type_template& CxDx__3GPP__User__Authorization__Type_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

CxDx__3GPP__User__Authorization__Type_template& CxDx__3GPP__User__Authorization__Type_template::operator=(int other_value)
{
if (!CxDx__3GPP__User__Authorization__Type::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (CxDx__3GPP__User__Authorization__Type::enum_type)other_value;
return *this;
}

CxDx__3GPP__User__Authorization__Type_template& CxDx__3GPP__User__Authorization__Type_template::operator=(CxDx__3GPP__User__Authorization__Type::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

CxDx__3GPP__User__Authorization__Type_template& CxDx__3GPP__User__Authorization__Type_template::operator=(const CxDx__3GPP__User__Authorization__Type& other_value)
{
if (other_value.enum_value == CxDx__3GPP__User__Authorization__Type::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

CxDx__3GPP__User__Authorization__Type_template& CxDx__3GPP__User__Authorization__Type_template::operator=(const OPTIONAL<CxDx__3GPP__User__Authorization__Type>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (CxDx__3GPP__User__Authorization__Type::enum_type)(const CxDx__3GPP__User__Authorization__Type&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
}
return *this;
}

CxDx__3GPP__User__Authorization__Type_template& CxDx__3GPP__User__Authorization__Type_template::operator=(const CxDx__3GPP__User__Authorization__Type_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean CxDx__3GPP__User__Authorization__Type_template::match(CxDx__3GPP__User__Authorization__Type::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
}
return FALSE;
}

boolean CxDx__3GPP__User__Authorization__Type_template::match(const CxDx__3GPP__User__Authorization__Type& other_value, boolean) const
{
if (other_value.enum_value == CxDx__3GPP__User__Authorization__Type::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type with an unbound value.");
return match(other_value.enum_value);
}

CxDx__3GPP__User__Authorization__Type::enum_type CxDx__3GPP__User__Authorization__Type_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
return single_value;
}

void CxDx__3GPP__User__Authorization__Type_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new CxDx__3GPP__User__Authorization__Type_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
}
}

CxDx__3GPP__User__Authorization__Type_template& CxDx__3GPP__User__Authorization__Type_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
return value_list.list_value[list_index];
}

void CxDx__3GPP__User__Authorization__Type_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(CxDx__3GPP__User__Authorization__Type::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void CxDx__3GPP__User__Authorization__Type_template::log_match(const CxDx__3GPP__User__Authorization__Type& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void CxDx__3GPP__User__Authorization__Type_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
}
}

void CxDx__3GPP__User__Authorization__Type_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (CxDx__3GPP__User__Authorization__Type::enum_type)text_buf.pull_int().get_val();
if (!CxDx__3GPP__User__Authorization__Type::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new CxDx__3GPP__User__Authorization__Type_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
}
}

boolean CxDx__3GPP__User__Authorization__Type_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean CxDx__3GPP__User__Authorization__Type_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void CxDx__3GPP__User__Authorization__Type_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    CxDx__3GPP__User__Authorization__Type_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    CxDx__3GPP__User__Authorization__Type::enum_type enum_val = CxDx__3GPP__User__Authorization__Type::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!CxDx__3GPP__User__Authorization__Type::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.CxDx_3GPP_User_Authorization_Type.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    CxDx__3GPP__User__Authorization__Type_template* precondition = new CxDx__3GPP__User__Authorization__Type_template;
    precondition->set_param(*m_p->get_elem(0));
    CxDx__3GPP__User__Authorization__Type_template* implied_template = new CxDx__3GPP__User__Authorization__Type_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = CxDx__3GPP__User__Authorization__Type_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.CxDx_3GPP_User_Authorization_Type");
  }
  is_ifpresent = param.get_ifpresent();
}

void CxDx__3GPP__User__Authorization__Type_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.CxDx_3GPP_User_Authorization_Type");
}

AAA__3GPP__PLMN__Client::AAA__3GPP__PLMN__Client()
{
enum_value = UNBOUND_VALUE;
}

AAA__3GPP__PLMN__Client::AAA__3GPP__PLMN__Client(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

AAA__3GPP__PLMN__Client::AAA__3GPP__PLMN__Client(enum_type other_value)
{
enum_value = other_value;
}

AAA__3GPP__PLMN__Client::AAA__3GPP__PLMN__Client(const AAA__3GPP__PLMN__Client& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
enum_value = other_value.enum_value;
}

AAA__3GPP__PLMN__Client& AAA__3GPP__PLMN__Client::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

AAA__3GPP__PLMN__Client& AAA__3GPP__PLMN__Client::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

AAA__3GPP__PLMN__Client& AAA__3GPP__PLMN__Client::operator=(const AAA__3GPP__PLMN__Client& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
enum_value = other_value.enum_value;
return *this;
}

boolean AAA__3GPP__PLMN__Client::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean AAA__3GPP__PLMN__Client::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
return enum_value == other_value;
}

boolean AAA__3GPP__PLMN__Client::operator==(const AAA__3GPP__PLMN__Client& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
return enum_value == other_value.enum_value;
}

boolean AAA__3GPP__PLMN__Client::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean AAA__3GPP__PLMN__Client::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
return enum_value < other_value;
}

boolean AAA__3GPP__PLMN__Client::operator<(const AAA__3GPP__PLMN__Client& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
return enum_value < other_value.enum_value;
}

boolean AAA__3GPP__PLMN__Client::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean AAA__3GPP__PLMN__Client::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
return enum_value > other_value;
}

boolean AAA__3GPP__PLMN__Client::operator>(const AAA__3GPP__PLMN__Client& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
return enum_value > other_value.enum_value;
}

const char *AAA__3GPP__PLMN__Client::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case BROADCAST__SERVICE: return "BROADCAST_SERVICE";
case O__AND__M__HPLMN: return "O_AND_M_HPLMN";
case O__AND__M__VPLMN: return "O_AND_M_VPLMN";
case ANONYMOUS__LOCATION: return "ANONYMOUS_LOCATION";
case TARGET__UE__SUBSCRIBED__SERVICE: return "TARGET_UE_SUBSCRIBED_SERVICE";
default:
return "<unknown>";
}
}

AAA__3GPP__PLMN__Client::enum_type AAA__3GPP__PLMN__Client::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "BROADCAST_SERVICE")) return BROADCAST__SERVICE;
if (!strcmp(str_par, "O_AND_M_HPLMN")) return O__AND__M__HPLMN;
if (!strcmp(str_par, "O_AND_M_VPLMN")) return O__AND__M__VPLMN;
if (!strcmp(str_par, "ANONYMOUS_LOCATION")) return ANONYMOUS__LOCATION;
if (!strcmp(str_par, "TARGET_UE_SUBSCRIBED_SERVICE")) return TARGET__UE__SUBSCRIBED__SERVICE;
}
return UNKNOWN_VALUE;
}

boolean AAA__3GPP__PLMN__Client::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
case 4:
return TRUE;
default:
return FALSE;
}
}

int AAA__3GPP__PLMN__Client::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int AAA__3GPP__PLMN__Client::enum2int(const AAA__3GPP__PLMN__Client& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void AAA__3GPP__PLMN__Client::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.", int_val);
enum_value = (enum_type)int_val;
}

AAA__3GPP__PLMN__Client::operator AAA__3GPP__PLMN__Client::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
return enum_value;
}

void AAA__3GPP__PLMN__Client::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void AAA__3GPP__PLMN__Client::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.AAA_3GPP_PLMN_Client");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
  }
}

void AAA__3GPP__PLMN__Client::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
text_buf.push_int(enum_value);
}

void AAA__3GPP__PLMN__Client::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.", enum_value);
}

void AAA__3GPP__PLMN__Client::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void AAA__3GPP__PLMN__Client::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int AAA__3GPP__PLMN__Client::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 3, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int AAA__3GPP__PLMN__Client::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 3);
}

void AAA__3GPP__PLMN__Client_template::copy_template(const AAA__3GPP__PLMN__Client_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new AAA__3GPP__PLMN__Client_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new AAA__3GPP__PLMN__Client_template(*other_value.implication_.precondition);
implication_.implied_template = new AAA__3GPP__PLMN__Client_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
}
}

AAA__3GPP__PLMN__Client_template::AAA__3GPP__PLMN__Client_template()
{
}

AAA__3GPP__PLMN__Client_template::AAA__3GPP__PLMN__Client_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

AAA__3GPP__PLMN__Client_template::AAA__3GPP__PLMN__Client_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!AAA__3GPP__PLMN__Client::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client with unknown numeric value %d.", other_value);
single_value = (AAA__3GPP__PLMN__Client::enum_type)other_value;
}

AAA__3GPP__PLMN__Client_template::AAA__3GPP__PLMN__Client_template(AAA__3GPP__PLMN__Client::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

AAA__3GPP__PLMN__Client_template::AAA__3GPP__PLMN__Client_template(const AAA__3GPP__PLMN__Client& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == AAA__3GPP__PLMN__Client::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
single_value = other_value.enum_value;
}

AAA__3GPP__PLMN__Client_template::AAA__3GPP__PLMN__Client_template(const OPTIONAL<AAA__3GPP__PLMN__Client>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (AAA__3GPP__PLMN__Client::enum_type)(const AAA__3GPP__PLMN__Client&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client from an unbound optional field.");
}
}

AAA__3GPP__PLMN__Client_template::AAA__3GPP__PLMN__Client_template(AAA__3GPP__PLMN__Client_template* p_precondition, AAA__3GPP__PLMN__Client_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

AAA__3GPP__PLMN__Client_template::AAA__3GPP__PLMN__Client_template(Dynamic_Match_Interface<AAA__3GPP__PLMN__Client>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<AAA__3GPP__PLMN__Client>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

AAA__3GPP__PLMN__Client_template::AAA__3GPP__PLMN__Client_template(const AAA__3GPP__PLMN__Client_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

AAA__3GPP__PLMN__Client_template::~AAA__3GPP__PLMN__Client_template()
{
clean_up();
}

boolean AAA__3GPP__PLMN__Client_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean AAA__3GPP__PLMN__Client_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != AAA__3GPP__PLMN__Client::UNBOUND_VALUE;
}

void AAA__3GPP__PLMN__Client_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

AAA__3GPP__PLMN__Client_template& AAA__3GPP__PLMN__Client_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

AAA__3GPP__PLMN__Client_template& AAA__3GPP__PLMN__Client_template::operator=(int other_value)
{
if (!AAA__3GPP__PLMN__Client::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (AAA__3GPP__PLMN__Client::enum_type)other_value;
return *this;
}

AAA__3GPP__PLMN__Client_template& AAA__3GPP__PLMN__Client_template::operator=(AAA__3GPP__PLMN__Client::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

AAA__3GPP__PLMN__Client_template& AAA__3GPP__PLMN__Client_template::operator=(const AAA__3GPP__PLMN__Client& other_value)
{
if (other_value.enum_value == AAA__3GPP__PLMN__Client::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

AAA__3GPP__PLMN__Client_template& AAA__3GPP__PLMN__Client_template::operator=(const OPTIONAL<AAA__3GPP__PLMN__Client>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (AAA__3GPP__PLMN__Client::enum_type)(const AAA__3GPP__PLMN__Client&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
}
return *this;
}

AAA__3GPP__PLMN__Client_template& AAA__3GPP__PLMN__Client_template::operator=(const AAA__3GPP__PLMN__Client_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean AAA__3GPP__PLMN__Client_template::match(AAA__3GPP__PLMN__Client::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
}
return FALSE;
}

boolean AAA__3GPP__PLMN__Client_template::match(const AAA__3GPP__PLMN__Client& other_value, boolean) const
{
if (other_value.enum_value == AAA__3GPP__PLMN__Client::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client with an unbound value.");
return match(other_value.enum_value);
}

AAA__3GPP__PLMN__Client::enum_type AAA__3GPP__PLMN__Client_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
return single_value;
}

void AAA__3GPP__PLMN__Client_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new AAA__3GPP__PLMN__Client_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
}
}

AAA__3GPP__PLMN__Client_template& AAA__3GPP__PLMN__Client_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
return value_list.list_value[list_index];
}

void AAA__3GPP__PLMN__Client_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(AAA__3GPP__PLMN__Client::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void AAA__3GPP__PLMN__Client_template::log_match(const AAA__3GPP__PLMN__Client& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void AAA__3GPP__PLMN__Client_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
}
}

void AAA__3GPP__PLMN__Client_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (AAA__3GPP__PLMN__Client::enum_type)text_buf.pull_int().get_val();
if (!AAA__3GPP__PLMN__Client::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new AAA__3GPP__PLMN__Client_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
}
}

boolean AAA__3GPP__PLMN__Client_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean AAA__3GPP__PLMN__Client_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void AAA__3GPP__PLMN__Client_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    AAA__3GPP__PLMN__Client_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    AAA__3GPP__PLMN__Client::enum_type enum_val = AAA__3GPP__PLMN__Client::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!AAA__3GPP__PLMN__Client::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.AAA_3GPP_PLMN_Client.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    AAA__3GPP__PLMN__Client_template* precondition = new AAA__3GPP__PLMN__Client_template;
    precondition->set_param(*m_p->get_elem(0));
    AAA__3GPP__PLMN__Client_template* implied_template = new AAA__3GPP__PLMN__Client_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = AAA__3GPP__PLMN__Client_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.AAA_3GPP_PLMN_Client");
  }
  is_ifpresent = param.get_ifpresent();
}

void AAA__3GPP__PLMN__Client_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.AAA_3GPP_PLMN_Client");
}

DCA__3GPP__IP__Realm__Default__Indication::DCA__3GPP__IP__Realm__Default__Indication()
{
enum_value = UNBOUND_VALUE;
}

DCA__3GPP__IP__Realm__Default__Indication::DCA__3GPP__IP__Realm__Default__Indication(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

DCA__3GPP__IP__Realm__Default__Indication::DCA__3GPP__IP__Realm__Default__Indication(enum_type other_value)
{
enum_value = other_value;
}

DCA__3GPP__IP__Realm__Default__Indication::DCA__3GPP__IP__Realm__Default__Indication(const DCA__3GPP__IP__Realm__Default__Indication& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
enum_value = other_value.enum_value;
}

DCA__3GPP__IP__Realm__Default__Indication& DCA__3GPP__IP__Realm__Default__Indication::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

DCA__3GPP__IP__Realm__Default__Indication& DCA__3GPP__IP__Realm__Default__Indication::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

DCA__3GPP__IP__Realm__Default__Indication& DCA__3GPP__IP__Realm__Default__Indication::operator=(const DCA__3GPP__IP__Realm__Default__Indication& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
enum_value = other_value.enum_value;
return *this;
}

boolean DCA__3GPP__IP__Realm__Default__Indication::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean DCA__3GPP__IP__Realm__Default__Indication::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
return enum_value == other_value;
}

boolean DCA__3GPP__IP__Realm__Default__Indication::operator==(const DCA__3GPP__IP__Realm__Default__Indication& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
return enum_value == other_value.enum_value;
}

boolean DCA__3GPP__IP__Realm__Default__Indication::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean DCA__3GPP__IP__Realm__Default__Indication::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
return enum_value < other_value;
}

boolean DCA__3GPP__IP__Realm__Default__Indication::operator<(const DCA__3GPP__IP__Realm__Default__Indication& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
return enum_value < other_value.enum_value;
}

boolean DCA__3GPP__IP__Realm__Default__Indication::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean DCA__3GPP__IP__Realm__Default__Indication::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
return enum_value > other_value;
}

boolean DCA__3GPP__IP__Realm__Default__Indication::operator>(const DCA__3GPP__IP__Realm__Default__Indication& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
return enum_value > other_value.enum_value;
}

const char *DCA__3GPP__IP__Realm__Default__Indication::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case DEFAULT__IP__REALM__NOT__USED: return "DEFAULT_IP_REALM_NOT_USED";
case DEFAULT__IP__REALM__USED: return "DEFAULT_IP_REALM_USED";
default:
return "<unknown>";
}
}

DCA__3GPP__IP__Realm__Default__Indication::enum_type DCA__3GPP__IP__Realm__Default__Indication::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "DEFAULT_IP_REALM_NOT_USED")) return DEFAULT__IP__REALM__NOT__USED;
if (!strcmp(str_par, "DEFAULT_IP_REALM_USED")) return DEFAULT__IP__REALM__USED;
}
return UNKNOWN_VALUE;
}

boolean DCA__3GPP__IP__Realm__Default__Indication::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
return TRUE;
default:
return FALSE;
}
}

int DCA__3GPP__IP__Realm__Default__Indication::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int DCA__3GPP__IP__Realm__Default__Indication::enum2int(const DCA__3GPP__IP__Realm__Default__Indication& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void DCA__3GPP__IP__Realm__Default__Indication::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.", int_val);
enum_value = (enum_type)int_val;
}

DCA__3GPP__IP__Realm__Default__Indication::operator DCA__3GPP__IP__Realm__Default__Indication::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
return enum_value;
}

void DCA__3GPP__IP__Realm__Default__Indication::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void DCA__3GPP__IP__Realm__Default__Indication::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
  }
}

void DCA__3GPP__IP__Realm__Default__Indication::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
text_buf.push_int(enum_value);
}

void DCA__3GPP__IP__Realm__Default__Indication::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.", enum_value);
}

void DCA__3GPP__IP__Realm__Default__Indication::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void DCA__3GPP__IP__Realm__Default__Indication::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int DCA__3GPP__IP__Realm__Default__Indication::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int DCA__3GPP__IP__Realm__Default__Indication::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void DCA__3GPP__IP__Realm__Default__Indication_template::copy_template(const DCA__3GPP__IP__Realm__Default__Indication_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new DCA__3GPP__IP__Realm__Default__Indication_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new DCA__3GPP__IP__Realm__Default__Indication_template(*other_value.implication_.precondition);
implication_.implied_template = new DCA__3GPP__IP__Realm__Default__Indication_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
}
}

DCA__3GPP__IP__Realm__Default__Indication_template::DCA__3GPP__IP__Realm__Default__Indication_template()
{
}

DCA__3GPP__IP__Realm__Default__Indication_template::DCA__3GPP__IP__Realm__Default__Indication_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

DCA__3GPP__IP__Realm__Default__Indication_template::DCA__3GPP__IP__Realm__Default__Indication_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!DCA__3GPP__IP__Realm__Default__Indication::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication with unknown numeric value %d.", other_value);
single_value = (DCA__3GPP__IP__Realm__Default__Indication::enum_type)other_value;
}

DCA__3GPP__IP__Realm__Default__Indication_template::DCA__3GPP__IP__Realm__Default__Indication_template(DCA__3GPP__IP__Realm__Default__Indication::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

DCA__3GPP__IP__Realm__Default__Indication_template::DCA__3GPP__IP__Realm__Default__Indication_template(const DCA__3GPP__IP__Realm__Default__Indication& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == DCA__3GPP__IP__Realm__Default__Indication::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
single_value = other_value.enum_value;
}

DCA__3GPP__IP__Realm__Default__Indication_template::DCA__3GPP__IP__Realm__Default__Indication_template(const OPTIONAL<DCA__3GPP__IP__Realm__Default__Indication>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__IP__Realm__Default__Indication::enum_type)(const DCA__3GPP__IP__Realm__Default__Indication&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication from an unbound optional field.");
}
}

DCA__3GPP__IP__Realm__Default__Indication_template::DCA__3GPP__IP__Realm__Default__Indication_template(DCA__3GPP__IP__Realm__Default__Indication_template* p_precondition, DCA__3GPP__IP__Realm__Default__Indication_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

DCA__3GPP__IP__Realm__Default__Indication_template::DCA__3GPP__IP__Realm__Default__Indication_template(Dynamic_Match_Interface<DCA__3GPP__IP__Realm__Default__Indication>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<DCA__3GPP__IP__Realm__Default__Indication>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

DCA__3GPP__IP__Realm__Default__Indication_template::DCA__3GPP__IP__Realm__Default__Indication_template(const DCA__3GPP__IP__Realm__Default__Indication_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

DCA__3GPP__IP__Realm__Default__Indication_template::~DCA__3GPP__IP__Realm__Default__Indication_template()
{
clean_up();
}

boolean DCA__3GPP__IP__Realm__Default__Indication_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean DCA__3GPP__IP__Realm__Default__Indication_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != DCA__3GPP__IP__Realm__Default__Indication::UNBOUND_VALUE;
}

void DCA__3GPP__IP__Realm__Default__Indication_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

DCA__3GPP__IP__Realm__Default__Indication_template& DCA__3GPP__IP__Realm__Default__Indication_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

DCA__3GPP__IP__Realm__Default__Indication_template& DCA__3GPP__IP__Realm__Default__Indication_template::operator=(int other_value)
{
if (!DCA__3GPP__IP__Realm__Default__Indication::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__IP__Realm__Default__Indication::enum_type)other_value;
return *this;
}

DCA__3GPP__IP__Realm__Default__Indication_template& DCA__3GPP__IP__Realm__Default__Indication_template::operator=(DCA__3GPP__IP__Realm__Default__Indication::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

DCA__3GPP__IP__Realm__Default__Indication_template& DCA__3GPP__IP__Realm__Default__Indication_template::operator=(const DCA__3GPP__IP__Realm__Default__Indication& other_value)
{
if (other_value.enum_value == DCA__3GPP__IP__Realm__Default__Indication::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

DCA__3GPP__IP__Realm__Default__Indication_template& DCA__3GPP__IP__Realm__Default__Indication_template::operator=(const OPTIONAL<DCA__3GPP__IP__Realm__Default__Indication>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__IP__Realm__Default__Indication::enum_type)(const DCA__3GPP__IP__Realm__Default__Indication&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
}
return *this;
}

DCA__3GPP__IP__Realm__Default__Indication_template& DCA__3GPP__IP__Realm__Default__Indication_template::operator=(const DCA__3GPP__IP__Realm__Default__Indication_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean DCA__3GPP__IP__Realm__Default__Indication_template::match(DCA__3GPP__IP__Realm__Default__Indication::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
}
return FALSE;
}

boolean DCA__3GPP__IP__Realm__Default__Indication_template::match(const DCA__3GPP__IP__Realm__Default__Indication& other_value, boolean) const
{
if (other_value.enum_value == DCA__3GPP__IP__Realm__Default__Indication::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication with an unbound value.");
return match(other_value.enum_value);
}

DCA__3GPP__IP__Realm__Default__Indication::enum_type DCA__3GPP__IP__Realm__Default__Indication_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
return single_value;
}

void DCA__3GPP__IP__Realm__Default__Indication_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new DCA__3GPP__IP__Realm__Default__Indication_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
}
}

DCA__3GPP__IP__Realm__Default__Indication_template& DCA__3GPP__IP__Realm__Default__Indication_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
return value_list.list_value[list_index];
}

void DCA__3GPP__IP__Realm__Default__Indication_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(DCA__3GPP__IP__Realm__Default__Indication::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void DCA__3GPP__IP__Realm__Default__Indication_template::log_match(const DCA__3GPP__IP__Realm__Default__Indication& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void DCA__3GPP__IP__Realm__Default__Indication_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
}
}

void DCA__3GPP__IP__Realm__Default__Indication_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (DCA__3GPP__IP__Realm__Default__Indication::enum_type)text_buf.pull_int().get_val();
if (!DCA__3GPP__IP__Realm__Default__Indication::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new DCA__3GPP__IP__Realm__Default__Indication_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
}
}

boolean DCA__3GPP__IP__Realm__Default__Indication_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean DCA__3GPP__IP__Realm__Default__Indication_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void DCA__3GPP__IP__Realm__Default__Indication_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    DCA__3GPP__IP__Realm__Default__Indication_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    DCA__3GPP__IP__Realm__Default__Indication::enum_type enum_val = DCA__3GPP__IP__Realm__Default__Indication::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!DCA__3GPP__IP__Realm__Default__Indication::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    DCA__3GPP__IP__Realm__Default__Indication_template* precondition = new DCA__3GPP__IP__Realm__Default__Indication_template;
    precondition->set_param(*m_p->get_elem(0));
    DCA__3GPP__IP__Realm__Default__Indication_template* implied_template = new DCA__3GPP__IP__Realm__Default__Indication_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = DCA__3GPP__IP__Realm__Default__Indication_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication");
  }
  is_ifpresent = param.get_ifpresent();
}

void DCA__3GPP__IP__Realm__Default__Indication_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.DCA_3GPP_IP_Realm_Default_Indication");
}

DCA__3GPP__Relationship__Mode::DCA__3GPP__Relationship__Mode()
{
enum_value = UNBOUND_VALUE;
}

DCA__3GPP__Relationship__Mode::DCA__3GPP__Relationship__Mode(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

DCA__3GPP__Relationship__Mode::DCA__3GPP__Relationship__Mode(enum_type other_value)
{
enum_value = other_value;
}

DCA__3GPP__Relationship__Mode::DCA__3GPP__Relationship__Mode(const DCA__3GPP__Relationship__Mode& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
enum_value = other_value.enum_value;
}

DCA__3GPP__Relationship__Mode& DCA__3GPP__Relationship__Mode::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

DCA__3GPP__Relationship__Mode& DCA__3GPP__Relationship__Mode::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

DCA__3GPP__Relationship__Mode& DCA__3GPP__Relationship__Mode::operator=(const DCA__3GPP__Relationship__Mode& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
enum_value = other_value.enum_value;
return *this;
}

boolean DCA__3GPP__Relationship__Mode::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean DCA__3GPP__Relationship__Mode::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
return enum_value == other_value;
}

boolean DCA__3GPP__Relationship__Mode::operator==(const DCA__3GPP__Relationship__Mode& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
return enum_value == other_value.enum_value;
}

boolean DCA__3GPP__Relationship__Mode::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean DCA__3GPP__Relationship__Mode::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
return enum_value < other_value;
}

boolean DCA__3GPP__Relationship__Mode::operator<(const DCA__3GPP__Relationship__Mode& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
return enum_value < other_value.enum_value;
}

boolean DCA__3GPP__Relationship__Mode::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean DCA__3GPP__Relationship__Mode::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
return enum_value > other_value;
}

boolean DCA__3GPP__Relationship__Mode::operator>(const DCA__3GPP__Relationship__Mode& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
return enum_value > other_value.enum_value;
}

const char *DCA__3GPP__Relationship__Mode::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case Trusted: return "Trusted";
case Non__Trusted: return "Non_Trusted";
default:
return "<unknown>";
}
}

DCA__3GPP__Relationship__Mode::enum_type DCA__3GPP__Relationship__Mode::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "Trusted")) return Trusted;
if (!strcmp(str_par, "Non_Trusted")) return Non__Trusted;
}
return UNKNOWN_VALUE;
}

boolean DCA__3GPP__Relationship__Mode::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
return TRUE;
default:
return FALSE;
}
}

int DCA__3GPP__Relationship__Mode::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int DCA__3GPP__Relationship__Mode::enum2int(const DCA__3GPP__Relationship__Mode& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void DCA__3GPP__Relationship__Mode::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.", int_val);
enum_value = (enum_type)int_val;
}

DCA__3GPP__Relationship__Mode::operator DCA__3GPP__Relationship__Mode::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
return enum_value;
}

void DCA__3GPP__Relationship__Mode::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void DCA__3GPP__Relationship__Mode::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.DCA_3GPP_Relationship_Mode");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
  }
}

void DCA__3GPP__Relationship__Mode::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
text_buf.push_int(enum_value);
}

void DCA__3GPP__Relationship__Mode::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.", enum_value);
}

void DCA__3GPP__Relationship__Mode::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void DCA__3GPP__Relationship__Mode::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int DCA__3GPP__Relationship__Mode::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int DCA__3GPP__Relationship__Mode::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void DCA__3GPP__Relationship__Mode_template::copy_template(const DCA__3GPP__Relationship__Mode_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new DCA__3GPP__Relationship__Mode_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new DCA__3GPP__Relationship__Mode_template(*other_value.implication_.precondition);
implication_.implied_template = new DCA__3GPP__Relationship__Mode_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
}
}

DCA__3GPP__Relationship__Mode_template::DCA__3GPP__Relationship__Mode_template()
{
}

DCA__3GPP__Relationship__Mode_template::DCA__3GPP__Relationship__Mode_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

DCA__3GPP__Relationship__Mode_template::DCA__3GPP__Relationship__Mode_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!DCA__3GPP__Relationship__Mode::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode with unknown numeric value %d.", other_value);
single_value = (DCA__3GPP__Relationship__Mode::enum_type)other_value;
}

DCA__3GPP__Relationship__Mode_template::DCA__3GPP__Relationship__Mode_template(DCA__3GPP__Relationship__Mode::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

DCA__3GPP__Relationship__Mode_template::DCA__3GPP__Relationship__Mode_template(const DCA__3GPP__Relationship__Mode& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == DCA__3GPP__Relationship__Mode::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
single_value = other_value.enum_value;
}

DCA__3GPP__Relationship__Mode_template::DCA__3GPP__Relationship__Mode_template(const OPTIONAL<DCA__3GPP__Relationship__Mode>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__Relationship__Mode::enum_type)(const DCA__3GPP__Relationship__Mode&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode from an unbound optional field.");
}
}

DCA__3GPP__Relationship__Mode_template::DCA__3GPP__Relationship__Mode_template(DCA__3GPP__Relationship__Mode_template* p_precondition, DCA__3GPP__Relationship__Mode_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

DCA__3GPP__Relationship__Mode_template::DCA__3GPP__Relationship__Mode_template(Dynamic_Match_Interface<DCA__3GPP__Relationship__Mode>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<DCA__3GPP__Relationship__Mode>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

DCA__3GPP__Relationship__Mode_template::DCA__3GPP__Relationship__Mode_template(const DCA__3GPP__Relationship__Mode_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

DCA__3GPP__Relationship__Mode_template::~DCA__3GPP__Relationship__Mode_template()
{
clean_up();
}

boolean DCA__3GPP__Relationship__Mode_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean DCA__3GPP__Relationship__Mode_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != DCA__3GPP__Relationship__Mode::UNBOUND_VALUE;
}

void DCA__3GPP__Relationship__Mode_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

DCA__3GPP__Relationship__Mode_template& DCA__3GPP__Relationship__Mode_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

DCA__3GPP__Relationship__Mode_template& DCA__3GPP__Relationship__Mode_template::operator=(int other_value)
{
if (!DCA__3GPP__Relationship__Mode::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__Relationship__Mode::enum_type)other_value;
return *this;
}

DCA__3GPP__Relationship__Mode_template& DCA__3GPP__Relationship__Mode_template::operator=(DCA__3GPP__Relationship__Mode::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

DCA__3GPP__Relationship__Mode_template& DCA__3GPP__Relationship__Mode_template::operator=(const DCA__3GPP__Relationship__Mode& other_value)
{
if (other_value.enum_value == DCA__3GPP__Relationship__Mode::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

DCA__3GPP__Relationship__Mode_template& DCA__3GPP__Relationship__Mode_template::operator=(const OPTIONAL<DCA__3GPP__Relationship__Mode>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__Relationship__Mode::enum_type)(const DCA__3GPP__Relationship__Mode&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
}
return *this;
}

DCA__3GPP__Relationship__Mode_template& DCA__3GPP__Relationship__Mode_template::operator=(const DCA__3GPP__Relationship__Mode_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean DCA__3GPP__Relationship__Mode_template::match(DCA__3GPP__Relationship__Mode::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
}
return FALSE;
}

boolean DCA__3GPP__Relationship__Mode_template::match(const DCA__3GPP__Relationship__Mode& other_value, boolean) const
{
if (other_value.enum_value == DCA__3GPP__Relationship__Mode::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode with an unbound value.");
return match(other_value.enum_value);
}

DCA__3GPP__Relationship__Mode::enum_type DCA__3GPP__Relationship__Mode_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
return single_value;
}

void DCA__3GPP__Relationship__Mode_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new DCA__3GPP__Relationship__Mode_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
}
}

DCA__3GPP__Relationship__Mode_template& DCA__3GPP__Relationship__Mode_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
return value_list.list_value[list_index];
}

void DCA__3GPP__Relationship__Mode_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(DCA__3GPP__Relationship__Mode::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void DCA__3GPP__Relationship__Mode_template::log_match(const DCA__3GPP__Relationship__Mode& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void DCA__3GPP__Relationship__Mode_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
}
}

void DCA__3GPP__Relationship__Mode_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (DCA__3GPP__Relationship__Mode::enum_type)text_buf.pull_int().get_val();
if (!DCA__3GPP__Relationship__Mode::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new DCA__3GPP__Relationship__Mode_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
}
}

boolean DCA__3GPP__Relationship__Mode_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean DCA__3GPP__Relationship__Mode_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void DCA__3GPP__Relationship__Mode_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    DCA__3GPP__Relationship__Mode_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    DCA__3GPP__Relationship__Mode::enum_type enum_val = DCA__3GPP__Relationship__Mode::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!DCA__3GPP__Relationship__Mode::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.DCA_3GPP_Relationship_Mode.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    DCA__3GPP__Relationship__Mode_template* precondition = new DCA__3GPP__Relationship__Mode_template;
    precondition->set_param(*m_p->get_elem(0));
    DCA__3GPP__Relationship__Mode_template* implied_template = new DCA__3GPP__Relationship__Mode_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = DCA__3GPP__Relationship__Mode_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.DCA_3GPP_Relationship_Mode");
  }
  is_ifpresent = param.get_ifpresent();
}

void DCA__3GPP__Relationship__Mode_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.DCA_3GPP_Relationship_Mode");
}

DCC__NONE__Redirect__Address__Type::DCC__NONE__Redirect__Address__Type()
{
enum_value = UNBOUND_VALUE;
}

DCC__NONE__Redirect__Address__Type::DCC__NONE__Redirect__Address__Type(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

DCC__NONE__Redirect__Address__Type::DCC__NONE__Redirect__Address__Type(enum_type other_value)
{
enum_value = other_value;
}

DCC__NONE__Redirect__Address__Type::DCC__NONE__Redirect__Address__Type(const DCC__NONE__Redirect__Address__Type& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
enum_value = other_value.enum_value;
}

DCC__NONE__Redirect__Address__Type& DCC__NONE__Redirect__Address__Type::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

DCC__NONE__Redirect__Address__Type& DCC__NONE__Redirect__Address__Type::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

DCC__NONE__Redirect__Address__Type& DCC__NONE__Redirect__Address__Type::operator=(const DCC__NONE__Redirect__Address__Type& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
enum_value = other_value.enum_value;
return *this;
}

boolean DCC__NONE__Redirect__Address__Type::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean DCC__NONE__Redirect__Address__Type::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
return enum_value == other_value;
}

boolean DCC__NONE__Redirect__Address__Type::operator==(const DCC__NONE__Redirect__Address__Type& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
return enum_value == other_value.enum_value;
}

boolean DCC__NONE__Redirect__Address__Type::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean DCC__NONE__Redirect__Address__Type::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
return enum_value < other_value;
}

boolean DCC__NONE__Redirect__Address__Type::operator<(const DCC__NONE__Redirect__Address__Type& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
return enum_value < other_value.enum_value;
}

boolean DCC__NONE__Redirect__Address__Type::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean DCC__NONE__Redirect__Address__Type::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
return enum_value > other_value;
}

boolean DCC__NONE__Redirect__Address__Type::operator>(const DCC__NONE__Redirect__Address__Type& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
return enum_value > other_value.enum_value;
}

const char *DCC__NONE__Redirect__Address__Type::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case IPV4__ADDRESS: return "IPV4_ADDRESS";
case IPV6__ADDRESS: return "IPV6_ADDRESS";
case URL: return "URL";
case SIP__URI: return "SIP_URI";
default:
return "<unknown>";
}
}

DCC__NONE__Redirect__Address__Type::enum_type DCC__NONE__Redirect__Address__Type::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "IPV4_ADDRESS")) return IPV4__ADDRESS;
if (!strcmp(str_par, "IPV6_ADDRESS")) return IPV6__ADDRESS;
if (!strcmp(str_par, "URL")) return URL;
if (!strcmp(str_par, "SIP_URI")) return SIP__URI;
}
return UNKNOWN_VALUE;
}

boolean DCC__NONE__Redirect__Address__Type::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
return TRUE;
default:
return FALSE;
}
}

int DCC__NONE__Redirect__Address__Type::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int DCC__NONE__Redirect__Address__Type::enum2int(const DCC__NONE__Redirect__Address__Type& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void DCC__NONE__Redirect__Address__Type::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.", int_val);
enum_value = (enum_type)int_val;
}

DCC__NONE__Redirect__Address__Type::operator DCC__NONE__Redirect__Address__Type::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
return enum_value;
}

void DCC__NONE__Redirect__Address__Type::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void DCC__NONE__Redirect__Address__Type::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.DCC_NONE_Redirect_Address_Type");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
  }
}

void DCC__NONE__Redirect__Address__Type::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
text_buf.push_int(enum_value);
}

void DCC__NONE__Redirect__Address__Type::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.", enum_value);
}

void DCC__NONE__Redirect__Address__Type::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void DCC__NONE__Redirect__Address__Type::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int DCC__NONE__Redirect__Address__Type::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 3, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int DCC__NONE__Redirect__Address__Type::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 3);
}

void DCC__NONE__Redirect__Address__Type_template::copy_template(const DCC__NONE__Redirect__Address__Type_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new DCC__NONE__Redirect__Address__Type_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new DCC__NONE__Redirect__Address__Type_template(*other_value.implication_.precondition);
implication_.implied_template = new DCC__NONE__Redirect__Address__Type_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
}
}

DCC__NONE__Redirect__Address__Type_template::DCC__NONE__Redirect__Address__Type_template()
{
}

DCC__NONE__Redirect__Address__Type_template::DCC__NONE__Redirect__Address__Type_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

DCC__NONE__Redirect__Address__Type_template::DCC__NONE__Redirect__Address__Type_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!DCC__NONE__Redirect__Address__Type::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type with unknown numeric value %d.", other_value);
single_value = (DCC__NONE__Redirect__Address__Type::enum_type)other_value;
}

DCC__NONE__Redirect__Address__Type_template::DCC__NONE__Redirect__Address__Type_template(DCC__NONE__Redirect__Address__Type::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

DCC__NONE__Redirect__Address__Type_template::DCC__NONE__Redirect__Address__Type_template(const DCC__NONE__Redirect__Address__Type& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == DCC__NONE__Redirect__Address__Type::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
single_value = other_value.enum_value;
}

DCC__NONE__Redirect__Address__Type_template::DCC__NONE__Redirect__Address__Type_template(const OPTIONAL<DCC__NONE__Redirect__Address__Type>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCC__NONE__Redirect__Address__Type::enum_type)(const DCC__NONE__Redirect__Address__Type&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type from an unbound optional field.");
}
}

DCC__NONE__Redirect__Address__Type_template::DCC__NONE__Redirect__Address__Type_template(DCC__NONE__Redirect__Address__Type_template* p_precondition, DCC__NONE__Redirect__Address__Type_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

DCC__NONE__Redirect__Address__Type_template::DCC__NONE__Redirect__Address__Type_template(Dynamic_Match_Interface<DCC__NONE__Redirect__Address__Type>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<DCC__NONE__Redirect__Address__Type>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

DCC__NONE__Redirect__Address__Type_template::DCC__NONE__Redirect__Address__Type_template(const DCC__NONE__Redirect__Address__Type_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

DCC__NONE__Redirect__Address__Type_template::~DCC__NONE__Redirect__Address__Type_template()
{
clean_up();
}

boolean DCC__NONE__Redirect__Address__Type_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean DCC__NONE__Redirect__Address__Type_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != DCC__NONE__Redirect__Address__Type::UNBOUND_VALUE;
}

void DCC__NONE__Redirect__Address__Type_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

DCC__NONE__Redirect__Address__Type_template& DCC__NONE__Redirect__Address__Type_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

DCC__NONE__Redirect__Address__Type_template& DCC__NONE__Redirect__Address__Type_template::operator=(int other_value)
{
if (!DCC__NONE__Redirect__Address__Type::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (DCC__NONE__Redirect__Address__Type::enum_type)other_value;
return *this;
}

DCC__NONE__Redirect__Address__Type_template& DCC__NONE__Redirect__Address__Type_template::operator=(DCC__NONE__Redirect__Address__Type::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

DCC__NONE__Redirect__Address__Type_template& DCC__NONE__Redirect__Address__Type_template::operator=(const DCC__NONE__Redirect__Address__Type& other_value)
{
if (other_value.enum_value == DCC__NONE__Redirect__Address__Type::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

DCC__NONE__Redirect__Address__Type_template& DCC__NONE__Redirect__Address__Type_template::operator=(const OPTIONAL<DCC__NONE__Redirect__Address__Type>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCC__NONE__Redirect__Address__Type::enum_type)(const DCC__NONE__Redirect__Address__Type&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
}
return *this;
}

DCC__NONE__Redirect__Address__Type_template& DCC__NONE__Redirect__Address__Type_template::operator=(const DCC__NONE__Redirect__Address__Type_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean DCC__NONE__Redirect__Address__Type_template::match(DCC__NONE__Redirect__Address__Type::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
}
return FALSE;
}

boolean DCC__NONE__Redirect__Address__Type_template::match(const DCC__NONE__Redirect__Address__Type& other_value, boolean) const
{
if (other_value.enum_value == DCC__NONE__Redirect__Address__Type::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type with an unbound value.");
return match(other_value.enum_value);
}

DCC__NONE__Redirect__Address__Type::enum_type DCC__NONE__Redirect__Address__Type_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
return single_value;
}

void DCC__NONE__Redirect__Address__Type_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new DCC__NONE__Redirect__Address__Type_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
}
}

DCC__NONE__Redirect__Address__Type_template& DCC__NONE__Redirect__Address__Type_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
return value_list.list_value[list_index];
}

void DCC__NONE__Redirect__Address__Type_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(DCC__NONE__Redirect__Address__Type::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void DCC__NONE__Redirect__Address__Type_template::log_match(const DCC__NONE__Redirect__Address__Type& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void DCC__NONE__Redirect__Address__Type_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
}
}

void DCC__NONE__Redirect__Address__Type_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (DCC__NONE__Redirect__Address__Type::enum_type)text_buf.pull_int().get_val();
if (!DCC__NONE__Redirect__Address__Type::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new DCC__NONE__Redirect__Address__Type_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
}
}

boolean DCC__NONE__Redirect__Address__Type_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean DCC__NONE__Redirect__Address__Type_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void DCC__NONE__Redirect__Address__Type_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    DCC__NONE__Redirect__Address__Type_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    DCC__NONE__Redirect__Address__Type::enum_type enum_val = DCC__NONE__Redirect__Address__Type::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!DCC__NONE__Redirect__Address__Type::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.DCC_NONE_Redirect_Address_Type.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    DCC__NONE__Redirect__Address__Type_template* precondition = new DCC__NONE__Redirect__Address__Type_template;
    precondition->set_param(*m_p->get_elem(0));
    DCC__NONE__Redirect__Address__Type_template* implied_template = new DCC__NONE__Redirect__Address__Type_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = DCC__NONE__Redirect__Address__Type_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.DCC_NONE_Redirect_Address_Type");
  }
  is_ifpresent = param.get_ifpresent();
}

void DCC__NONE__Redirect__Address__Type_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.DCC_NONE_Redirect_Address_Type");
}

DCA__3GPP__Originator::DCA__3GPP__Originator()
{
enum_value = UNBOUND_VALUE;
}

DCA__3GPP__Originator::DCA__3GPP__Originator(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.DCA_3GPP_Originator with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

DCA__3GPP__Originator::DCA__3GPP__Originator(enum_type other_value)
{
enum_value = other_value;
}

DCA__3GPP__Originator::DCA__3GPP__Originator(const DCA__3GPP__Originator& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
enum_value = other_value.enum_value;
}

DCA__3GPP__Originator& DCA__3GPP__Originator::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

DCA__3GPP__Originator& DCA__3GPP__Originator::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

DCA__3GPP__Originator& DCA__3GPP__Originator::operator=(const DCA__3GPP__Originator& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
enum_value = other_value.enum_value;
return *this;
}

boolean DCA__3GPP__Originator::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_Originator comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean DCA__3GPP__Originator::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
return enum_value == other_value;
}

boolean DCA__3GPP__Originator::operator==(const DCA__3GPP__Originator& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
return enum_value == other_value.enum_value;
}

boolean DCA__3GPP__Originator::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_Originator comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean DCA__3GPP__Originator::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
return enum_value < other_value;
}

boolean DCA__3GPP__Originator::operator<(const DCA__3GPP__Originator& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
return enum_value < other_value.enum_value;
}

boolean DCA__3GPP__Originator::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_Originator comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean DCA__3GPP__Originator::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
return enum_value > other_value;
}

boolean DCA__3GPP__Originator::operator>(const DCA__3GPP__Originator& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
return enum_value > other_value.enum_value;
}

const char *DCA__3GPP__Originator::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case CALLING__PARTY: return "CALLING_PARTY";
case CALLED__PARTY: return "CALLED_PARTY";
default:
return "<unknown>";
}
}

DCA__3GPP__Originator::enum_type DCA__3GPP__Originator::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "CALLING_PARTY")) return CALLING__PARTY;
if (!strcmp(str_par, "CALLED_PARTY")) return CALLED__PARTY;
}
return UNKNOWN_VALUE;
}

boolean DCA__3GPP__Originator::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
return TRUE;
default:
return FALSE;
}
}

int DCA__3GPP__Originator::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int DCA__3GPP__Originator::enum2int(const DCA__3GPP__Originator& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void DCA__3GPP__Originator::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.", int_val);
enum_value = (enum_type)int_val;
}

DCA__3GPP__Originator::operator DCA__3GPP__Originator::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
return enum_value;
}

void DCA__3GPP__Originator::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void DCA__3GPP__Originator::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.DCA_3GPP_Originator");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.DCA_3GPP_Originator.");
  }
}

void DCA__3GPP__Originator::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
text_buf.push_int(enum_value);
}

void DCA__3GPP__Originator::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.DCA_3GPP_Originator.", enum_value);
}

void DCA__3GPP__Originator::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void DCA__3GPP__Originator::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int DCA__3GPP__Originator::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int DCA__3GPP__Originator::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void DCA__3GPP__Originator_template::copy_template(const DCA__3GPP__Originator_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new DCA__3GPP__Originator_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new DCA__3GPP__Originator_template(*other_value.implication_.precondition);
implication_.implied_template = new DCA__3GPP__Originator_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
}
}

DCA__3GPP__Originator_template::DCA__3GPP__Originator_template()
{
}

DCA__3GPP__Originator_template::DCA__3GPP__Originator_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

DCA__3GPP__Originator_template::DCA__3GPP__Originator_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!DCA__3GPP__Originator::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.DCA_3GPP_Originator with unknown numeric value %d.", other_value);
single_value = (DCA__3GPP__Originator::enum_type)other_value;
}

DCA__3GPP__Originator_template::DCA__3GPP__Originator_template(DCA__3GPP__Originator::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

DCA__3GPP__Originator_template::DCA__3GPP__Originator_template(const DCA__3GPP__Originator& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == DCA__3GPP__Originator::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
single_value = other_value.enum_value;
}

DCA__3GPP__Originator_template::DCA__3GPP__Originator_template(const OPTIONAL<DCA__3GPP__Originator>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__Originator::enum_type)(const DCA__3GPP__Originator&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.DCA_3GPP_Originator from an unbound optional field.");
}
}

DCA__3GPP__Originator_template::DCA__3GPP__Originator_template(DCA__3GPP__Originator_template* p_precondition, DCA__3GPP__Originator_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

DCA__3GPP__Originator_template::DCA__3GPP__Originator_template(Dynamic_Match_Interface<DCA__3GPP__Originator>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<DCA__3GPP__Originator>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

DCA__3GPP__Originator_template::DCA__3GPP__Originator_template(const DCA__3GPP__Originator_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

DCA__3GPP__Originator_template::~DCA__3GPP__Originator_template()
{
clean_up();
}

boolean DCA__3GPP__Originator_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean DCA__3GPP__Originator_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != DCA__3GPP__Originator::UNBOUND_VALUE;
}

void DCA__3GPP__Originator_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

DCA__3GPP__Originator_template& DCA__3GPP__Originator_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

DCA__3GPP__Originator_template& DCA__3GPP__Originator_template::operator=(int other_value)
{
if (!DCA__3GPP__Originator::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__Originator::enum_type)other_value;
return *this;
}

DCA__3GPP__Originator_template& DCA__3GPP__Originator_template::operator=(DCA__3GPP__Originator::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

DCA__3GPP__Originator_template& DCA__3GPP__Originator_template::operator=(const DCA__3GPP__Originator& other_value)
{
if (other_value.enum_value == DCA__3GPP__Originator::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Originator to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

DCA__3GPP__Originator_template& DCA__3GPP__Originator_template::operator=(const OPTIONAL<DCA__3GPP__Originator>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__Originator::enum_type)(const DCA__3GPP__Originator&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
}
return *this;
}

DCA__3GPP__Originator_template& DCA__3GPP__Originator_template::operator=(const DCA__3GPP__Originator_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean DCA__3GPP__Originator_template::match(DCA__3GPP__Originator::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
}
return FALSE;
}

boolean DCA__3GPP__Originator_template::match(const DCA__3GPP__Originator& other_value, boolean) const
{
if (other_value.enum_value == DCA__3GPP__Originator::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.DCA_3GPP_Originator with an unbound value.");
return match(other_value.enum_value);
}

DCA__3GPP__Originator::enum_type DCA__3GPP__Originator_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
return single_value;
}

void DCA__3GPP__Originator_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new DCA__3GPP__Originator_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
}
}

DCA__3GPP__Originator_template& DCA__3GPP__Originator_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
return value_list.list_value[list_index];
}

void DCA__3GPP__Originator_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(DCA__3GPP__Originator::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void DCA__3GPP__Originator_template::log_match(const DCA__3GPP__Originator& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void DCA__3GPP__Originator_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
}
}

void DCA__3GPP__Originator_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (DCA__3GPP__Originator::enum_type)text_buf.pull_int().get_val();
if (!DCA__3GPP__Originator::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new DCA__3GPP__Originator_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.DCA_3GPP_Originator.");
}
}

boolean DCA__3GPP__Originator_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean DCA__3GPP__Originator_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void DCA__3GPP__Originator_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    DCA__3GPP__Originator_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    DCA__3GPP__Originator::enum_type enum_val = DCA__3GPP__Originator::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!DCA__3GPP__Originator::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.DCA_3GPP_Originator.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    DCA__3GPP__Originator_template* precondition = new DCA__3GPP__Originator_template;
    precondition->set_param(*m_p->get_elem(0));
    DCA__3GPP__Originator_template* implied_template = new DCA__3GPP__Originator_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = DCA__3GPP__Originator_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.DCA_3GPP_Originator");
  }
  is_ifpresent = param.get_ifpresent();
}

void DCA__3GPP__Originator_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.DCA_3GPP_Originator");
}

DCC__NONE__User__Equipment__Info__Type::DCC__NONE__User__Equipment__Info__Type()
{
enum_value = UNBOUND_VALUE;
}

DCC__NONE__User__Equipment__Info__Type::DCC__NONE__User__Equipment__Info__Type(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

DCC__NONE__User__Equipment__Info__Type::DCC__NONE__User__Equipment__Info__Type(enum_type other_value)
{
enum_value = other_value;
}

DCC__NONE__User__Equipment__Info__Type::DCC__NONE__User__Equipment__Info__Type(const DCC__NONE__User__Equipment__Info__Type& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
enum_value = other_value.enum_value;
}

DCC__NONE__User__Equipment__Info__Type& DCC__NONE__User__Equipment__Info__Type::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

DCC__NONE__User__Equipment__Info__Type& DCC__NONE__User__Equipment__Info__Type::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

DCC__NONE__User__Equipment__Info__Type& DCC__NONE__User__Equipment__Info__Type::operator=(const DCC__NONE__User__Equipment__Info__Type& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
enum_value = other_value.enum_value;
return *this;
}

boolean DCC__NONE__User__Equipment__Info__Type::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean DCC__NONE__User__Equipment__Info__Type::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
return enum_value == other_value;
}

boolean DCC__NONE__User__Equipment__Info__Type::operator==(const DCC__NONE__User__Equipment__Info__Type& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
return enum_value == other_value.enum_value;
}

boolean DCC__NONE__User__Equipment__Info__Type::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean DCC__NONE__User__Equipment__Info__Type::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
return enum_value < other_value;
}

boolean DCC__NONE__User__Equipment__Info__Type::operator<(const DCC__NONE__User__Equipment__Info__Type& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
return enum_value < other_value.enum_value;
}

boolean DCC__NONE__User__Equipment__Info__Type::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean DCC__NONE__User__Equipment__Info__Type::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
return enum_value > other_value;
}

boolean DCC__NONE__User__Equipment__Info__Type::operator>(const DCC__NONE__User__Equipment__Info__Type& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
return enum_value > other_value.enum_value;
}

const char *DCC__NONE__User__Equipment__Info__Type::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case IMEISV: return "IMEISV";
case MAC: return "MAC";
case EUI64: return "EUI64";
case MODIFIED__EUI64: return "MODIFIED_EUI64";
case ESN: return "ESN";
case MEID: return "MEID";
default:
return "<unknown>";
}
}

DCC__NONE__User__Equipment__Info__Type::enum_type DCC__NONE__User__Equipment__Info__Type::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "IMEISV")) return IMEISV;
if (!strcmp(str_par, "MAC")) return MAC;
if (!strcmp(str_par, "EUI64")) return EUI64;
if (!strcmp(str_par, "MODIFIED_EUI64")) return MODIFIED__EUI64;
if (!strcmp(str_par, "ESN")) return ESN;
if (!strcmp(str_par, "MEID")) return MEID;
}
return UNKNOWN_VALUE;
}

boolean DCC__NONE__User__Equipment__Info__Type::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
case 4:
case 5:
return TRUE;
default:
return FALSE;
}
}

int DCC__NONE__User__Equipment__Info__Type::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int DCC__NONE__User__Equipment__Info__Type::enum2int(const DCC__NONE__User__Equipment__Info__Type& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void DCC__NONE__User__Equipment__Info__Type::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.", int_val);
enum_value = (enum_type)int_val;
}

DCC__NONE__User__Equipment__Info__Type::operator DCC__NONE__User__Equipment__Info__Type::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
return enum_value;
}

void DCC__NONE__User__Equipment__Info__Type::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void DCC__NONE__User__Equipment__Info__Type::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
  }
}

void DCC__NONE__User__Equipment__Info__Type::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
text_buf.push_int(enum_value);
}

void DCC__NONE__User__Equipment__Info__Type::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.", enum_value);
}

void DCC__NONE__User__Equipment__Info__Type::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void DCC__NONE__User__Equipment__Info__Type::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int DCC__NONE__User__Equipment__Info__Type::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 3, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int DCC__NONE__User__Equipment__Info__Type::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 3);
}

void DCC__NONE__User__Equipment__Info__Type_template::copy_template(const DCC__NONE__User__Equipment__Info__Type_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new DCC__NONE__User__Equipment__Info__Type_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new DCC__NONE__User__Equipment__Info__Type_template(*other_value.implication_.precondition);
implication_.implied_template = new DCC__NONE__User__Equipment__Info__Type_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
}
}

DCC__NONE__User__Equipment__Info__Type_template::DCC__NONE__User__Equipment__Info__Type_template()
{
}

DCC__NONE__User__Equipment__Info__Type_template::DCC__NONE__User__Equipment__Info__Type_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

DCC__NONE__User__Equipment__Info__Type_template::DCC__NONE__User__Equipment__Info__Type_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!DCC__NONE__User__Equipment__Info__Type::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type with unknown numeric value %d.", other_value);
single_value = (DCC__NONE__User__Equipment__Info__Type::enum_type)other_value;
}

DCC__NONE__User__Equipment__Info__Type_template::DCC__NONE__User__Equipment__Info__Type_template(DCC__NONE__User__Equipment__Info__Type::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

DCC__NONE__User__Equipment__Info__Type_template::DCC__NONE__User__Equipment__Info__Type_template(const DCC__NONE__User__Equipment__Info__Type& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == DCC__NONE__User__Equipment__Info__Type::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
single_value = other_value.enum_value;
}

DCC__NONE__User__Equipment__Info__Type_template::DCC__NONE__User__Equipment__Info__Type_template(const OPTIONAL<DCC__NONE__User__Equipment__Info__Type>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCC__NONE__User__Equipment__Info__Type::enum_type)(const DCC__NONE__User__Equipment__Info__Type&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type from an unbound optional field.");
}
}

DCC__NONE__User__Equipment__Info__Type_template::DCC__NONE__User__Equipment__Info__Type_template(DCC__NONE__User__Equipment__Info__Type_template* p_precondition, DCC__NONE__User__Equipment__Info__Type_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

DCC__NONE__User__Equipment__Info__Type_template::DCC__NONE__User__Equipment__Info__Type_template(Dynamic_Match_Interface<DCC__NONE__User__Equipment__Info__Type>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<DCC__NONE__User__Equipment__Info__Type>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

DCC__NONE__User__Equipment__Info__Type_template::DCC__NONE__User__Equipment__Info__Type_template(const DCC__NONE__User__Equipment__Info__Type_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

DCC__NONE__User__Equipment__Info__Type_template::~DCC__NONE__User__Equipment__Info__Type_template()
{
clean_up();
}

boolean DCC__NONE__User__Equipment__Info__Type_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean DCC__NONE__User__Equipment__Info__Type_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != DCC__NONE__User__Equipment__Info__Type::UNBOUND_VALUE;
}

void DCC__NONE__User__Equipment__Info__Type_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

DCC__NONE__User__Equipment__Info__Type_template& DCC__NONE__User__Equipment__Info__Type_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

DCC__NONE__User__Equipment__Info__Type_template& DCC__NONE__User__Equipment__Info__Type_template::operator=(int other_value)
{
if (!DCC__NONE__User__Equipment__Info__Type::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (DCC__NONE__User__Equipment__Info__Type::enum_type)other_value;
return *this;
}

DCC__NONE__User__Equipment__Info__Type_template& DCC__NONE__User__Equipment__Info__Type_template::operator=(DCC__NONE__User__Equipment__Info__Type::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

DCC__NONE__User__Equipment__Info__Type_template& DCC__NONE__User__Equipment__Info__Type_template::operator=(const DCC__NONE__User__Equipment__Info__Type& other_value)
{
if (other_value.enum_value == DCC__NONE__User__Equipment__Info__Type::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

DCC__NONE__User__Equipment__Info__Type_template& DCC__NONE__User__Equipment__Info__Type_template::operator=(const OPTIONAL<DCC__NONE__User__Equipment__Info__Type>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCC__NONE__User__Equipment__Info__Type::enum_type)(const DCC__NONE__User__Equipment__Info__Type&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
}
return *this;
}

DCC__NONE__User__Equipment__Info__Type_template& DCC__NONE__User__Equipment__Info__Type_template::operator=(const DCC__NONE__User__Equipment__Info__Type_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean DCC__NONE__User__Equipment__Info__Type_template::match(DCC__NONE__User__Equipment__Info__Type::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
}
return FALSE;
}

boolean DCC__NONE__User__Equipment__Info__Type_template::match(const DCC__NONE__User__Equipment__Info__Type& other_value, boolean) const
{
if (other_value.enum_value == DCC__NONE__User__Equipment__Info__Type::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type with an unbound value.");
return match(other_value.enum_value);
}

DCC__NONE__User__Equipment__Info__Type::enum_type DCC__NONE__User__Equipment__Info__Type_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
return single_value;
}

void DCC__NONE__User__Equipment__Info__Type_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new DCC__NONE__User__Equipment__Info__Type_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
}
}

DCC__NONE__User__Equipment__Info__Type_template& DCC__NONE__User__Equipment__Info__Type_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
return value_list.list_value[list_index];
}

void DCC__NONE__User__Equipment__Info__Type_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(DCC__NONE__User__Equipment__Info__Type::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void DCC__NONE__User__Equipment__Info__Type_template::log_match(const DCC__NONE__User__Equipment__Info__Type& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void DCC__NONE__User__Equipment__Info__Type_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
}
}

void DCC__NONE__User__Equipment__Info__Type_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (DCC__NONE__User__Equipment__Info__Type::enum_type)text_buf.pull_int().get_val();
if (!DCC__NONE__User__Equipment__Info__Type::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new DCC__NONE__User__Equipment__Info__Type_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
}
}

boolean DCC__NONE__User__Equipment__Info__Type_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean DCC__NONE__User__Equipment__Info__Type_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void DCC__NONE__User__Equipment__Info__Type_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    DCC__NONE__User__Equipment__Info__Type_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    DCC__NONE__User__Equipment__Info__Type::enum_type enum_val = DCC__NONE__User__Equipment__Info__Type::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!DCC__NONE__User__Equipment__Info__Type::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    DCC__NONE__User__Equipment__Info__Type_template* precondition = new DCC__NONE__User__Equipment__Info__Type_template;
    precondition->set_param(*m_p->get_elem(0));
    DCC__NONE__User__Equipment__Info__Type_template* implied_template = new DCC__NONE__User__Equipment__Info__Type_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = DCC__NONE__User__Equipment__Info__Type_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type");
  }
  is_ifpresent = param.get_ifpresent();
}

void DCC__NONE__User__Equipment__Info__Type_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.DCC_NONE_User_Equipment_Info_Type");
}

PCC__3GPP__Resource__Allocation__Notification::PCC__3GPP__Resource__Allocation__Notification()
{
enum_value = UNBOUND_VALUE;
}

PCC__3GPP__Resource__Allocation__Notification::PCC__3GPP__Resource__Allocation__Notification(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

PCC__3GPP__Resource__Allocation__Notification::PCC__3GPP__Resource__Allocation__Notification(enum_type other_value)
{
enum_value = other_value;
}

PCC__3GPP__Resource__Allocation__Notification::PCC__3GPP__Resource__Allocation__Notification(const PCC__3GPP__Resource__Allocation__Notification& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
enum_value = other_value.enum_value;
}

PCC__3GPP__Resource__Allocation__Notification& PCC__3GPP__Resource__Allocation__Notification::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

PCC__3GPP__Resource__Allocation__Notification& PCC__3GPP__Resource__Allocation__Notification::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

PCC__3GPP__Resource__Allocation__Notification& PCC__3GPP__Resource__Allocation__Notification::operator=(const PCC__3GPP__Resource__Allocation__Notification& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
enum_value = other_value.enum_value;
return *this;
}

boolean PCC__3GPP__Resource__Allocation__Notification::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean PCC__3GPP__Resource__Allocation__Notification::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
return enum_value == other_value;
}

boolean PCC__3GPP__Resource__Allocation__Notification::operator==(const PCC__3GPP__Resource__Allocation__Notification& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
return enum_value == other_value.enum_value;
}

boolean PCC__3GPP__Resource__Allocation__Notification::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean PCC__3GPP__Resource__Allocation__Notification::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
return enum_value < other_value;
}

boolean PCC__3GPP__Resource__Allocation__Notification::operator<(const PCC__3GPP__Resource__Allocation__Notification& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
return enum_value < other_value.enum_value;
}

boolean PCC__3GPP__Resource__Allocation__Notification::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean PCC__3GPP__Resource__Allocation__Notification::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
return enum_value > other_value;
}

boolean PCC__3GPP__Resource__Allocation__Notification::operator>(const PCC__3GPP__Resource__Allocation__Notification& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
return enum_value > other_value.enum_value;
}

const char *PCC__3GPP__Resource__Allocation__Notification::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case ENABLE__NOTIFICATION: return "ENABLE_NOTIFICATION";
default:
return "<unknown>";
}
}

PCC__3GPP__Resource__Allocation__Notification::enum_type PCC__3GPP__Resource__Allocation__Notification::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "ENABLE_NOTIFICATION")) return ENABLE__NOTIFICATION;
}
return UNKNOWN_VALUE;
}

boolean PCC__3GPP__Resource__Allocation__Notification::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
return TRUE;
default:
return FALSE;
}
}

int PCC__3GPP__Resource__Allocation__Notification::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int PCC__3GPP__Resource__Allocation__Notification::enum2int(const PCC__3GPP__Resource__Allocation__Notification& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void PCC__3GPP__Resource__Allocation__Notification::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.", int_val);
enum_value = (enum_type)int_val;
}

PCC__3GPP__Resource__Allocation__Notification::operator PCC__3GPP__Resource__Allocation__Notification::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
return enum_value;
}

void PCC__3GPP__Resource__Allocation__Notification::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void PCC__3GPP__Resource__Allocation__Notification::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
  }
}

void PCC__3GPP__Resource__Allocation__Notification::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
text_buf.push_int(enum_value);
}

void PCC__3GPP__Resource__Allocation__Notification::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.", enum_value);
}

void PCC__3GPP__Resource__Allocation__Notification::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PCC__3GPP__Resource__Allocation__Notification::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PCC__3GPP__Resource__Allocation__Notification::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 1, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int PCC__3GPP__Resource__Allocation__Notification::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 1);
}

void PCC__3GPP__Resource__Allocation__Notification_template::copy_template(const PCC__3GPP__Resource__Allocation__Notification_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PCC__3GPP__Resource__Allocation__Notification_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PCC__3GPP__Resource__Allocation__Notification_template(*other_value.implication_.precondition);
implication_.implied_template = new PCC__3GPP__Resource__Allocation__Notification_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
}
}

PCC__3GPP__Resource__Allocation__Notification_template::PCC__3GPP__Resource__Allocation__Notification_template()
{
}

PCC__3GPP__Resource__Allocation__Notification_template::PCC__3GPP__Resource__Allocation__Notification_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PCC__3GPP__Resource__Allocation__Notification_template::PCC__3GPP__Resource__Allocation__Notification_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!PCC__3GPP__Resource__Allocation__Notification::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification with unknown numeric value %d.", other_value);
single_value = (PCC__3GPP__Resource__Allocation__Notification::enum_type)other_value;
}

PCC__3GPP__Resource__Allocation__Notification_template::PCC__3GPP__Resource__Allocation__Notification_template(PCC__3GPP__Resource__Allocation__Notification::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

PCC__3GPP__Resource__Allocation__Notification_template::PCC__3GPP__Resource__Allocation__Notification_template(const PCC__3GPP__Resource__Allocation__Notification& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == PCC__3GPP__Resource__Allocation__Notification::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
single_value = other_value.enum_value;
}

PCC__3GPP__Resource__Allocation__Notification_template::PCC__3GPP__Resource__Allocation__Notification_template(const OPTIONAL<PCC__3GPP__Resource__Allocation__Notification>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (PCC__3GPP__Resource__Allocation__Notification::enum_type)(const PCC__3GPP__Resource__Allocation__Notification&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification from an unbound optional field.");
}
}

PCC__3GPP__Resource__Allocation__Notification_template::PCC__3GPP__Resource__Allocation__Notification_template(PCC__3GPP__Resource__Allocation__Notification_template* p_precondition, PCC__3GPP__Resource__Allocation__Notification_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PCC__3GPP__Resource__Allocation__Notification_template::PCC__3GPP__Resource__Allocation__Notification_template(Dynamic_Match_Interface<PCC__3GPP__Resource__Allocation__Notification>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PCC__3GPP__Resource__Allocation__Notification>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PCC__3GPP__Resource__Allocation__Notification_template::PCC__3GPP__Resource__Allocation__Notification_template(const PCC__3GPP__Resource__Allocation__Notification_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

PCC__3GPP__Resource__Allocation__Notification_template::~PCC__3GPP__Resource__Allocation__Notification_template()
{
clean_up();
}

boolean PCC__3GPP__Resource__Allocation__Notification_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean PCC__3GPP__Resource__Allocation__Notification_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != PCC__3GPP__Resource__Allocation__Notification::UNBOUND_VALUE;
}

void PCC__3GPP__Resource__Allocation__Notification_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PCC__3GPP__Resource__Allocation__Notification_template& PCC__3GPP__Resource__Allocation__Notification_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PCC__3GPP__Resource__Allocation__Notification_template& PCC__3GPP__Resource__Allocation__Notification_template::operator=(int other_value)
{
if (!PCC__3GPP__Resource__Allocation__Notification::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (PCC__3GPP__Resource__Allocation__Notification::enum_type)other_value;
return *this;
}

PCC__3GPP__Resource__Allocation__Notification_template& PCC__3GPP__Resource__Allocation__Notification_template::operator=(PCC__3GPP__Resource__Allocation__Notification::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

PCC__3GPP__Resource__Allocation__Notification_template& PCC__3GPP__Resource__Allocation__Notification_template::operator=(const PCC__3GPP__Resource__Allocation__Notification& other_value)
{
if (other_value.enum_value == PCC__3GPP__Resource__Allocation__Notification::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

PCC__3GPP__Resource__Allocation__Notification_template& PCC__3GPP__Resource__Allocation__Notification_template::operator=(const OPTIONAL<PCC__3GPP__Resource__Allocation__Notification>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (PCC__3GPP__Resource__Allocation__Notification::enum_type)(const PCC__3GPP__Resource__Allocation__Notification&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
}
return *this;
}

PCC__3GPP__Resource__Allocation__Notification_template& PCC__3GPP__Resource__Allocation__Notification_template::operator=(const PCC__3GPP__Resource__Allocation__Notification_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PCC__3GPP__Resource__Allocation__Notification_template::match(PCC__3GPP__Resource__Allocation__Notification::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
}
return FALSE;
}

boolean PCC__3GPP__Resource__Allocation__Notification_template::match(const PCC__3GPP__Resource__Allocation__Notification& other_value, boolean) const
{
if (other_value.enum_value == PCC__3GPP__Resource__Allocation__Notification::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification with an unbound value.");
return match(other_value.enum_value);
}

PCC__3GPP__Resource__Allocation__Notification::enum_type PCC__3GPP__Resource__Allocation__Notification_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
return single_value;
}

void PCC__3GPP__Resource__Allocation__Notification_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PCC__3GPP__Resource__Allocation__Notification_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
}
}

PCC__3GPP__Resource__Allocation__Notification_template& PCC__3GPP__Resource__Allocation__Notification_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
return value_list.list_value[list_index];
}

void PCC__3GPP__Resource__Allocation__Notification_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(PCC__3GPP__Resource__Allocation__Notification::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PCC__3GPP__Resource__Allocation__Notification_template::log_match(const PCC__3GPP__Resource__Allocation__Notification& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void PCC__3GPP__Resource__Allocation__Notification_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
}
}

void PCC__3GPP__Resource__Allocation__Notification_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (PCC__3GPP__Resource__Allocation__Notification::enum_type)text_buf.pull_int().get_val();
if (!PCC__3GPP__Resource__Allocation__Notification::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PCC__3GPP__Resource__Allocation__Notification_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
}
}

boolean PCC__3GPP__Resource__Allocation__Notification_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PCC__3GPP__Resource__Allocation__Notification_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void PCC__3GPP__Resource__Allocation__Notification_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PCC__3GPP__Resource__Allocation__Notification_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    PCC__3GPP__Resource__Allocation__Notification::enum_type enum_val = PCC__3GPP__Resource__Allocation__Notification::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!PCC__3GPP__Resource__Allocation__Notification::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    PCC__3GPP__Resource__Allocation__Notification_template* precondition = new PCC__3GPP__Resource__Allocation__Notification_template;
    precondition->set_param(*m_p->get_elem(0));
    PCC__3GPP__Resource__Allocation__Notification_template* implied_template = new PCC__3GPP__Resource__Allocation__Notification_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = PCC__3GPP__Resource__Allocation__Notification_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification");
  }
  is_ifpresent = param.get_ifpresent();
}

void PCC__3GPP__Resource__Allocation__Notification_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.PCC_3GPP_Resource_Allocation_Notification");
}

DCA__3GPP__Role__Of__Node::DCA__3GPP__Role__Of__Node()
{
enum_value = UNBOUND_VALUE;
}

DCA__3GPP__Role__Of__Node::DCA__3GPP__Role__Of__Node(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

DCA__3GPP__Role__Of__Node::DCA__3GPP__Role__Of__Node(enum_type other_value)
{
enum_value = other_value;
}

DCA__3GPP__Role__Of__Node::DCA__3GPP__Role__Of__Node(const DCA__3GPP__Role__Of__Node& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
enum_value = other_value.enum_value;
}

DCA__3GPP__Role__Of__Node& DCA__3GPP__Role__Of__Node::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

DCA__3GPP__Role__Of__Node& DCA__3GPP__Role__Of__Node::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

DCA__3GPP__Role__Of__Node& DCA__3GPP__Role__Of__Node::operator=(const DCA__3GPP__Role__Of__Node& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
enum_value = other_value.enum_value;
return *this;
}

boolean DCA__3GPP__Role__Of__Node::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean DCA__3GPP__Role__Of__Node::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
return enum_value == other_value;
}

boolean DCA__3GPP__Role__Of__Node::operator==(const DCA__3GPP__Role__Of__Node& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
return enum_value == other_value.enum_value;
}

boolean DCA__3GPP__Role__Of__Node::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean DCA__3GPP__Role__Of__Node::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
return enum_value < other_value;
}

boolean DCA__3GPP__Role__Of__Node::operator<(const DCA__3GPP__Role__Of__Node& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
return enum_value < other_value.enum_value;
}

boolean DCA__3GPP__Role__Of__Node::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean DCA__3GPP__Role__Of__Node::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
return enum_value > other_value;
}

boolean DCA__3GPP__Role__Of__Node::operator>(const DCA__3GPP__Role__Of__Node& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
return enum_value > other_value.enum_value;
}

const char *DCA__3GPP__Role__Of__Node::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case ORIGINATING__ROLE: return "ORIGINATING_ROLE";
case TERMINATING__ROLE: return "TERMINATING_ROLE";
case FORWARDING__ROLE: return "FORWARDING_ROLE";
default:
return "<unknown>";
}
}

DCA__3GPP__Role__Of__Node::enum_type DCA__3GPP__Role__Of__Node::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "ORIGINATING_ROLE")) return ORIGINATING__ROLE;
if (!strcmp(str_par, "TERMINATING_ROLE")) return TERMINATING__ROLE;
if (!strcmp(str_par, "FORWARDING_ROLE")) return FORWARDING__ROLE;
}
return UNKNOWN_VALUE;
}

boolean DCA__3GPP__Role__Of__Node::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
return TRUE;
default:
return FALSE;
}
}

int DCA__3GPP__Role__Of__Node::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int DCA__3GPP__Role__Of__Node::enum2int(const DCA__3GPP__Role__Of__Node& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void DCA__3GPP__Role__Of__Node::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.", int_val);
enum_value = (enum_type)int_val;
}

DCA__3GPP__Role__Of__Node::operator DCA__3GPP__Role__Of__Node::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
return enum_value;
}

void DCA__3GPP__Role__Of__Node::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void DCA__3GPP__Role__Of__Node::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.DCA_3GPP_Role_Of_Node");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
  }
}

void DCA__3GPP__Role__Of__Node::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
text_buf.push_int(enum_value);
}

void DCA__3GPP__Role__Of__Node::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.", enum_value);
}

void DCA__3GPP__Role__Of__Node::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void DCA__3GPP__Role__Of__Node::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int DCA__3GPP__Role__Of__Node::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int DCA__3GPP__Role__Of__Node::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void DCA__3GPP__Role__Of__Node_template::copy_template(const DCA__3GPP__Role__Of__Node_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new DCA__3GPP__Role__Of__Node_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new DCA__3GPP__Role__Of__Node_template(*other_value.implication_.precondition);
implication_.implied_template = new DCA__3GPP__Role__Of__Node_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
}
}

DCA__3GPP__Role__Of__Node_template::DCA__3GPP__Role__Of__Node_template()
{
}

DCA__3GPP__Role__Of__Node_template::DCA__3GPP__Role__Of__Node_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

DCA__3GPP__Role__Of__Node_template::DCA__3GPP__Role__Of__Node_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!DCA__3GPP__Role__Of__Node::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node with unknown numeric value %d.", other_value);
single_value = (DCA__3GPP__Role__Of__Node::enum_type)other_value;
}

DCA__3GPP__Role__Of__Node_template::DCA__3GPP__Role__Of__Node_template(DCA__3GPP__Role__Of__Node::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

DCA__3GPP__Role__Of__Node_template::DCA__3GPP__Role__Of__Node_template(const DCA__3GPP__Role__Of__Node& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == DCA__3GPP__Role__Of__Node::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
single_value = other_value.enum_value;
}

DCA__3GPP__Role__Of__Node_template::DCA__3GPP__Role__Of__Node_template(const OPTIONAL<DCA__3GPP__Role__Of__Node>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__Role__Of__Node::enum_type)(const DCA__3GPP__Role__Of__Node&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node from an unbound optional field.");
}
}

DCA__3GPP__Role__Of__Node_template::DCA__3GPP__Role__Of__Node_template(DCA__3GPP__Role__Of__Node_template* p_precondition, DCA__3GPP__Role__Of__Node_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

DCA__3GPP__Role__Of__Node_template::DCA__3GPP__Role__Of__Node_template(Dynamic_Match_Interface<DCA__3GPP__Role__Of__Node>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<DCA__3GPP__Role__Of__Node>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

DCA__3GPP__Role__Of__Node_template::DCA__3GPP__Role__Of__Node_template(const DCA__3GPP__Role__Of__Node_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

DCA__3GPP__Role__Of__Node_template::~DCA__3GPP__Role__Of__Node_template()
{
clean_up();
}

boolean DCA__3GPP__Role__Of__Node_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean DCA__3GPP__Role__Of__Node_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != DCA__3GPP__Role__Of__Node::UNBOUND_VALUE;
}

void DCA__3GPP__Role__Of__Node_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

DCA__3GPP__Role__Of__Node_template& DCA__3GPP__Role__Of__Node_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

DCA__3GPP__Role__Of__Node_template& DCA__3GPP__Role__Of__Node_template::operator=(int other_value)
{
if (!DCA__3GPP__Role__Of__Node::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__Role__Of__Node::enum_type)other_value;
return *this;
}

DCA__3GPP__Role__Of__Node_template& DCA__3GPP__Role__Of__Node_template::operator=(DCA__3GPP__Role__Of__Node::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

DCA__3GPP__Role__Of__Node_template& DCA__3GPP__Role__Of__Node_template::operator=(const DCA__3GPP__Role__Of__Node& other_value)
{
if (other_value.enum_value == DCA__3GPP__Role__Of__Node::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

DCA__3GPP__Role__Of__Node_template& DCA__3GPP__Role__Of__Node_template::operator=(const OPTIONAL<DCA__3GPP__Role__Of__Node>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__Role__Of__Node::enum_type)(const DCA__3GPP__Role__Of__Node&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
}
return *this;
}

DCA__3GPP__Role__Of__Node_template& DCA__3GPP__Role__Of__Node_template::operator=(const DCA__3GPP__Role__Of__Node_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean DCA__3GPP__Role__Of__Node_template::match(DCA__3GPP__Role__Of__Node::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
}
return FALSE;
}

boolean DCA__3GPP__Role__Of__Node_template::match(const DCA__3GPP__Role__Of__Node& other_value, boolean) const
{
if (other_value.enum_value == DCA__3GPP__Role__Of__Node::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node with an unbound value.");
return match(other_value.enum_value);
}

DCA__3GPP__Role__Of__Node::enum_type DCA__3GPP__Role__Of__Node_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
return single_value;
}

void DCA__3GPP__Role__Of__Node_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new DCA__3GPP__Role__Of__Node_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
}
}

DCA__3GPP__Role__Of__Node_template& DCA__3GPP__Role__Of__Node_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
return value_list.list_value[list_index];
}

void DCA__3GPP__Role__Of__Node_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(DCA__3GPP__Role__Of__Node::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void DCA__3GPP__Role__Of__Node_template::log_match(const DCA__3GPP__Role__Of__Node& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void DCA__3GPP__Role__Of__Node_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
}
}

void DCA__3GPP__Role__Of__Node_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (DCA__3GPP__Role__Of__Node::enum_type)text_buf.pull_int().get_val();
if (!DCA__3GPP__Role__Of__Node::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new DCA__3GPP__Role__Of__Node_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
}
}

boolean DCA__3GPP__Role__Of__Node_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean DCA__3GPP__Role__Of__Node_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void DCA__3GPP__Role__Of__Node_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    DCA__3GPP__Role__Of__Node_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    DCA__3GPP__Role__Of__Node::enum_type enum_val = DCA__3GPP__Role__Of__Node::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!DCA__3GPP__Role__Of__Node::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.DCA_3GPP_Role_Of_Node.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    DCA__3GPP__Role__Of__Node_template* precondition = new DCA__3GPP__Role__Of__Node_template;
    precondition->set_param(*m_p->get_elem(0));
    DCA__3GPP__Role__Of__Node_template* implied_template = new DCA__3GPP__Role__Of__Node_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = DCA__3GPP__Role__Of__Node_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.DCA_3GPP_Role_Of_Node");
  }
  is_ifpresent = param.get_ifpresent();
}

void DCA__3GPP__Role__Of__Node_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.DCA_3GPP_Role_Of_Node");
}

PCC__3GPP__Default__Bearer__Indication::PCC__3GPP__Default__Bearer__Indication()
{
enum_value = UNBOUND_VALUE;
}

PCC__3GPP__Default__Bearer__Indication::PCC__3GPP__Default__Bearer__Indication(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

PCC__3GPP__Default__Bearer__Indication::PCC__3GPP__Default__Bearer__Indication(enum_type other_value)
{
enum_value = other_value;
}

PCC__3GPP__Default__Bearer__Indication::PCC__3GPP__Default__Bearer__Indication(const PCC__3GPP__Default__Bearer__Indication& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
enum_value = other_value.enum_value;
}

PCC__3GPP__Default__Bearer__Indication& PCC__3GPP__Default__Bearer__Indication::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

PCC__3GPP__Default__Bearer__Indication& PCC__3GPP__Default__Bearer__Indication::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

PCC__3GPP__Default__Bearer__Indication& PCC__3GPP__Default__Bearer__Indication::operator=(const PCC__3GPP__Default__Bearer__Indication& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
enum_value = other_value.enum_value;
return *this;
}

boolean PCC__3GPP__Default__Bearer__Indication::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean PCC__3GPP__Default__Bearer__Indication::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
return enum_value == other_value;
}

boolean PCC__3GPP__Default__Bearer__Indication::operator==(const PCC__3GPP__Default__Bearer__Indication& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
return enum_value == other_value.enum_value;
}

boolean PCC__3GPP__Default__Bearer__Indication::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean PCC__3GPP__Default__Bearer__Indication::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
return enum_value < other_value;
}

boolean PCC__3GPP__Default__Bearer__Indication::operator<(const PCC__3GPP__Default__Bearer__Indication& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
return enum_value < other_value.enum_value;
}

boolean PCC__3GPP__Default__Bearer__Indication::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean PCC__3GPP__Default__Bearer__Indication::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
return enum_value > other_value;
}

boolean PCC__3GPP__Default__Bearer__Indication::operator>(const PCC__3GPP__Default__Bearer__Indication& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
return enum_value > other_value.enum_value;
}

const char *PCC__3GPP__Default__Bearer__Indication::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case BIND__TO__DEF__BEARER: return "BIND_TO_DEF_BEARER";
case BIND__TO__APPLICABLE__BEARER: return "BIND_TO_APPLICABLE_BEARER";
default:
return "<unknown>";
}
}

PCC__3GPP__Default__Bearer__Indication::enum_type PCC__3GPP__Default__Bearer__Indication::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "BIND_TO_DEF_BEARER")) return BIND__TO__DEF__BEARER;
if (!strcmp(str_par, "BIND_TO_APPLICABLE_BEARER")) return BIND__TO__APPLICABLE__BEARER;
}
return UNKNOWN_VALUE;
}

boolean PCC__3GPP__Default__Bearer__Indication::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
return TRUE;
default:
return FALSE;
}
}

int PCC__3GPP__Default__Bearer__Indication::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int PCC__3GPP__Default__Bearer__Indication::enum2int(const PCC__3GPP__Default__Bearer__Indication& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void PCC__3GPP__Default__Bearer__Indication::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.", int_val);
enum_value = (enum_type)int_val;
}

PCC__3GPP__Default__Bearer__Indication::operator PCC__3GPP__Default__Bearer__Indication::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
return enum_value;
}

void PCC__3GPP__Default__Bearer__Indication::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void PCC__3GPP__Default__Bearer__Indication::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
  }
}

void PCC__3GPP__Default__Bearer__Indication::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
text_buf.push_int(enum_value);
}

void PCC__3GPP__Default__Bearer__Indication::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.", enum_value);
}

void PCC__3GPP__Default__Bearer__Indication::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PCC__3GPP__Default__Bearer__Indication::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PCC__3GPP__Default__Bearer__Indication::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int PCC__3GPP__Default__Bearer__Indication::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void PCC__3GPP__Default__Bearer__Indication_template::copy_template(const PCC__3GPP__Default__Bearer__Indication_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PCC__3GPP__Default__Bearer__Indication_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PCC__3GPP__Default__Bearer__Indication_template(*other_value.implication_.precondition);
implication_.implied_template = new PCC__3GPP__Default__Bearer__Indication_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
}
}

PCC__3GPP__Default__Bearer__Indication_template::PCC__3GPP__Default__Bearer__Indication_template()
{
}

PCC__3GPP__Default__Bearer__Indication_template::PCC__3GPP__Default__Bearer__Indication_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PCC__3GPP__Default__Bearer__Indication_template::PCC__3GPP__Default__Bearer__Indication_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!PCC__3GPP__Default__Bearer__Indication::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication with unknown numeric value %d.", other_value);
single_value = (PCC__3GPP__Default__Bearer__Indication::enum_type)other_value;
}

PCC__3GPP__Default__Bearer__Indication_template::PCC__3GPP__Default__Bearer__Indication_template(PCC__3GPP__Default__Bearer__Indication::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

PCC__3GPP__Default__Bearer__Indication_template::PCC__3GPP__Default__Bearer__Indication_template(const PCC__3GPP__Default__Bearer__Indication& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == PCC__3GPP__Default__Bearer__Indication::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
single_value = other_value.enum_value;
}

PCC__3GPP__Default__Bearer__Indication_template::PCC__3GPP__Default__Bearer__Indication_template(const OPTIONAL<PCC__3GPP__Default__Bearer__Indication>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (PCC__3GPP__Default__Bearer__Indication::enum_type)(const PCC__3GPP__Default__Bearer__Indication&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication from an unbound optional field.");
}
}

PCC__3GPP__Default__Bearer__Indication_template::PCC__3GPP__Default__Bearer__Indication_template(PCC__3GPP__Default__Bearer__Indication_template* p_precondition, PCC__3GPP__Default__Bearer__Indication_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PCC__3GPP__Default__Bearer__Indication_template::PCC__3GPP__Default__Bearer__Indication_template(Dynamic_Match_Interface<PCC__3GPP__Default__Bearer__Indication>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PCC__3GPP__Default__Bearer__Indication>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PCC__3GPP__Default__Bearer__Indication_template::PCC__3GPP__Default__Bearer__Indication_template(const PCC__3GPP__Default__Bearer__Indication_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

PCC__3GPP__Default__Bearer__Indication_template::~PCC__3GPP__Default__Bearer__Indication_template()
{
clean_up();
}

boolean PCC__3GPP__Default__Bearer__Indication_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean PCC__3GPP__Default__Bearer__Indication_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != PCC__3GPP__Default__Bearer__Indication::UNBOUND_VALUE;
}

void PCC__3GPP__Default__Bearer__Indication_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PCC__3GPP__Default__Bearer__Indication_template& PCC__3GPP__Default__Bearer__Indication_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PCC__3GPP__Default__Bearer__Indication_template& PCC__3GPP__Default__Bearer__Indication_template::operator=(int other_value)
{
if (!PCC__3GPP__Default__Bearer__Indication::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (PCC__3GPP__Default__Bearer__Indication::enum_type)other_value;
return *this;
}

PCC__3GPP__Default__Bearer__Indication_template& PCC__3GPP__Default__Bearer__Indication_template::operator=(PCC__3GPP__Default__Bearer__Indication::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

PCC__3GPP__Default__Bearer__Indication_template& PCC__3GPP__Default__Bearer__Indication_template::operator=(const PCC__3GPP__Default__Bearer__Indication& other_value)
{
if (other_value.enum_value == PCC__3GPP__Default__Bearer__Indication::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

PCC__3GPP__Default__Bearer__Indication_template& PCC__3GPP__Default__Bearer__Indication_template::operator=(const OPTIONAL<PCC__3GPP__Default__Bearer__Indication>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (PCC__3GPP__Default__Bearer__Indication::enum_type)(const PCC__3GPP__Default__Bearer__Indication&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
}
return *this;
}

PCC__3GPP__Default__Bearer__Indication_template& PCC__3GPP__Default__Bearer__Indication_template::operator=(const PCC__3GPP__Default__Bearer__Indication_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PCC__3GPP__Default__Bearer__Indication_template::match(PCC__3GPP__Default__Bearer__Indication::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
}
return FALSE;
}

boolean PCC__3GPP__Default__Bearer__Indication_template::match(const PCC__3GPP__Default__Bearer__Indication& other_value, boolean) const
{
if (other_value.enum_value == PCC__3GPP__Default__Bearer__Indication::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication with an unbound value.");
return match(other_value.enum_value);
}

PCC__3GPP__Default__Bearer__Indication::enum_type PCC__3GPP__Default__Bearer__Indication_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
return single_value;
}

void PCC__3GPP__Default__Bearer__Indication_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PCC__3GPP__Default__Bearer__Indication_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
}
}

PCC__3GPP__Default__Bearer__Indication_template& PCC__3GPP__Default__Bearer__Indication_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
return value_list.list_value[list_index];
}

void PCC__3GPP__Default__Bearer__Indication_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(PCC__3GPP__Default__Bearer__Indication::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PCC__3GPP__Default__Bearer__Indication_template::log_match(const PCC__3GPP__Default__Bearer__Indication& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void PCC__3GPP__Default__Bearer__Indication_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
}
}

void PCC__3GPP__Default__Bearer__Indication_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (PCC__3GPP__Default__Bearer__Indication::enum_type)text_buf.pull_int().get_val();
if (!PCC__3GPP__Default__Bearer__Indication::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PCC__3GPP__Default__Bearer__Indication_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
}
}

boolean PCC__3GPP__Default__Bearer__Indication_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PCC__3GPP__Default__Bearer__Indication_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void PCC__3GPP__Default__Bearer__Indication_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PCC__3GPP__Default__Bearer__Indication_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    PCC__3GPP__Default__Bearer__Indication::enum_type enum_val = PCC__3GPP__Default__Bearer__Indication::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!PCC__3GPP__Default__Bearer__Indication::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    PCC__3GPP__Default__Bearer__Indication_template* precondition = new PCC__3GPP__Default__Bearer__Indication_template;
    precondition->set_param(*m_p->get_elem(0));
    PCC__3GPP__Default__Bearer__Indication_template* implied_template = new PCC__3GPP__Default__Bearer__Indication_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = PCC__3GPP__Default__Bearer__Indication_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication");
  }
  is_ifpresent = param.get_ifpresent();
}

void PCC__3GPP__Default__Bearer__Indication_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.PCC_3GPP_Default_Bearer_Indication");
}

AAA__3GPP__VPLMN__LIPA__Allowed::AAA__3GPP__VPLMN__LIPA__Allowed()
{
enum_value = UNBOUND_VALUE;
}

AAA__3GPP__VPLMN__LIPA__Allowed::AAA__3GPP__VPLMN__LIPA__Allowed(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

AAA__3GPP__VPLMN__LIPA__Allowed::AAA__3GPP__VPLMN__LIPA__Allowed(enum_type other_value)
{
enum_value = other_value;
}

AAA__3GPP__VPLMN__LIPA__Allowed::AAA__3GPP__VPLMN__LIPA__Allowed(const AAA__3GPP__VPLMN__LIPA__Allowed& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
enum_value = other_value.enum_value;
}

AAA__3GPP__VPLMN__LIPA__Allowed& AAA__3GPP__VPLMN__LIPA__Allowed::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

AAA__3GPP__VPLMN__LIPA__Allowed& AAA__3GPP__VPLMN__LIPA__Allowed::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

AAA__3GPP__VPLMN__LIPA__Allowed& AAA__3GPP__VPLMN__LIPA__Allowed::operator=(const AAA__3GPP__VPLMN__LIPA__Allowed& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
enum_value = other_value.enum_value;
return *this;
}

boolean AAA__3GPP__VPLMN__LIPA__Allowed::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean AAA__3GPP__VPLMN__LIPA__Allowed::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
return enum_value == other_value;
}

boolean AAA__3GPP__VPLMN__LIPA__Allowed::operator==(const AAA__3GPP__VPLMN__LIPA__Allowed& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
return enum_value == other_value.enum_value;
}

boolean AAA__3GPP__VPLMN__LIPA__Allowed::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean AAA__3GPP__VPLMN__LIPA__Allowed::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
return enum_value < other_value;
}

boolean AAA__3GPP__VPLMN__LIPA__Allowed::operator<(const AAA__3GPP__VPLMN__LIPA__Allowed& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
return enum_value < other_value.enum_value;
}

boolean AAA__3GPP__VPLMN__LIPA__Allowed::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean AAA__3GPP__VPLMN__LIPA__Allowed::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
return enum_value > other_value;
}

boolean AAA__3GPP__VPLMN__LIPA__Allowed::operator>(const AAA__3GPP__VPLMN__LIPA__Allowed& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
return enum_value > other_value.enum_value;
}

const char *AAA__3GPP__VPLMN__LIPA__Allowed::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case LIPA__NOTALLOWED: return "LIPA_NOTALLOWED";
case LIPA__ALLOWED: return "LIPA_ALLOWED";
default:
return "<unknown>";
}
}

AAA__3GPP__VPLMN__LIPA__Allowed::enum_type AAA__3GPP__VPLMN__LIPA__Allowed::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "LIPA_NOTALLOWED")) return LIPA__NOTALLOWED;
if (!strcmp(str_par, "LIPA_ALLOWED")) return LIPA__ALLOWED;
}
return UNKNOWN_VALUE;
}

boolean AAA__3GPP__VPLMN__LIPA__Allowed::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
return TRUE;
default:
return FALSE;
}
}

int AAA__3GPP__VPLMN__LIPA__Allowed::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int AAA__3GPP__VPLMN__LIPA__Allowed::enum2int(const AAA__3GPP__VPLMN__LIPA__Allowed& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void AAA__3GPP__VPLMN__LIPA__Allowed::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.", int_val);
enum_value = (enum_type)int_val;
}

AAA__3GPP__VPLMN__LIPA__Allowed::operator AAA__3GPP__VPLMN__LIPA__Allowed::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
return enum_value;
}

void AAA__3GPP__VPLMN__LIPA__Allowed::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void AAA__3GPP__VPLMN__LIPA__Allowed::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
  }
}

void AAA__3GPP__VPLMN__LIPA__Allowed::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
text_buf.push_int(enum_value);
}

void AAA__3GPP__VPLMN__LIPA__Allowed::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.", enum_value);
}

void AAA__3GPP__VPLMN__LIPA__Allowed::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void AAA__3GPP__VPLMN__LIPA__Allowed::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int AAA__3GPP__VPLMN__LIPA__Allowed::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int AAA__3GPP__VPLMN__LIPA__Allowed::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void AAA__3GPP__VPLMN__LIPA__Allowed_template::copy_template(const AAA__3GPP__VPLMN__LIPA__Allowed_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new AAA__3GPP__VPLMN__LIPA__Allowed_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new AAA__3GPP__VPLMN__LIPA__Allowed_template(*other_value.implication_.precondition);
implication_.implied_template = new AAA__3GPP__VPLMN__LIPA__Allowed_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
}
}

AAA__3GPP__VPLMN__LIPA__Allowed_template::AAA__3GPP__VPLMN__LIPA__Allowed_template()
{
}

AAA__3GPP__VPLMN__LIPA__Allowed_template::AAA__3GPP__VPLMN__LIPA__Allowed_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

AAA__3GPP__VPLMN__LIPA__Allowed_template::AAA__3GPP__VPLMN__LIPA__Allowed_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!AAA__3GPP__VPLMN__LIPA__Allowed::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed with unknown numeric value %d.", other_value);
single_value = (AAA__3GPP__VPLMN__LIPA__Allowed::enum_type)other_value;
}

AAA__3GPP__VPLMN__LIPA__Allowed_template::AAA__3GPP__VPLMN__LIPA__Allowed_template(AAA__3GPP__VPLMN__LIPA__Allowed::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

AAA__3GPP__VPLMN__LIPA__Allowed_template::AAA__3GPP__VPLMN__LIPA__Allowed_template(const AAA__3GPP__VPLMN__LIPA__Allowed& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == AAA__3GPP__VPLMN__LIPA__Allowed::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
single_value = other_value.enum_value;
}

AAA__3GPP__VPLMN__LIPA__Allowed_template::AAA__3GPP__VPLMN__LIPA__Allowed_template(const OPTIONAL<AAA__3GPP__VPLMN__LIPA__Allowed>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (AAA__3GPP__VPLMN__LIPA__Allowed::enum_type)(const AAA__3GPP__VPLMN__LIPA__Allowed&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed from an unbound optional field.");
}
}

AAA__3GPP__VPLMN__LIPA__Allowed_template::AAA__3GPP__VPLMN__LIPA__Allowed_template(AAA__3GPP__VPLMN__LIPA__Allowed_template* p_precondition, AAA__3GPP__VPLMN__LIPA__Allowed_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

AAA__3GPP__VPLMN__LIPA__Allowed_template::AAA__3GPP__VPLMN__LIPA__Allowed_template(Dynamic_Match_Interface<AAA__3GPP__VPLMN__LIPA__Allowed>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<AAA__3GPP__VPLMN__LIPA__Allowed>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

AAA__3GPP__VPLMN__LIPA__Allowed_template::AAA__3GPP__VPLMN__LIPA__Allowed_template(const AAA__3GPP__VPLMN__LIPA__Allowed_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

AAA__3GPP__VPLMN__LIPA__Allowed_template::~AAA__3GPP__VPLMN__LIPA__Allowed_template()
{
clean_up();
}

boolean AAA__3GPP__VPLMN__LIPA__Allowed_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean AAA__3GPP__VPLMN__LIPA__Allowed_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != AAA__3GPP__VPLMN__LIPA__Allowed::UNBOUND_VALUE;
}

void AAA__3GPP__VPLMN__LIPA__Allowed_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

AAA__3GPP__VPLMN__LIPA__Allowed_template& AAA__3GPP__VPLMN__LIPA__Allowed_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

AAA__3GPP__VPLMN__LIPA__Allowed_template& AAA__3GPP__VPLMN__LIPA__Allowed_template::operator=(int other_value)
{
if (!AAA__3GPP__VPLMN__LIPA__Allowed::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (AAA__3GPP__VPLMN__LIPA__Allowed::enum_type)other_value;
return *this;
}

AAA__3GPP__VPLMN__LIPA__Allowed_template& AAA__3GPP__VPLMN__LIPA__Allowed_template::operator=(AAA__3GPP__VPLMN__LIPA__Allowed::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

AAA__3GPP__VPLMN__LIPA__Allowed_template& AAA__3GPP__VPLMN__LIPA__Allowed_template::operator=(const AAA__3GPP__VPLMN__LIPA__Allowed& other_value)
{
if (other_value.enum_value == AAA__3GPP__VPLMN__LIPA__Allowed::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

AAA__3GPP__VPLMN__LIPA__Allowed_template& AAA__3GPP__VPLMN__LIPA__Allowed_template::operator=(const OPTIONAL<AAA__3GPP__VPLMN__LIPA__Allowed>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (AAA__3GPP__VPLMN__LIPA__Allowed::enum_type)(const AAA__3GPP__VPLMN__LIPA__Allowed&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
}
return *this;
}

AAA__3GPP__VPLMN__LIPA__Allowed_template& AAA__3GPP__VPLMN__LIPA__Allowed_template::operator=(const AAA__3GPP__VPLMN__LIPA__Allowed_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean AAA__3GPP__VPLMN__LIPA__Allowed_template::match(AAA__3GPP__VPLMN__LIPA__Allowed::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
}
return FALSE;
}

boolean AAA__3GPP__VPLMN__LIPA__Allowed_template::match(const AAA__3GPP__VPLMN__LIPA__Allowed& other_value, boolean) const
{
if (other_value.enum_value == AAA__3GPP__VPLMN__LIPA__Allowed::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed with an unbound value.");
return match(other_value.enum_value);
}

AAA__3GPP__VPLMN__LIPA__Allowed::enum_type AAA__3GPP__VPLMN__LIPA__Allowed_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
return single_value;
}

void AAA__3GPP__VPLMN__LIPA__Allowed_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new AAA__3GPP__VPLMN__LIPA__Allowed_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
}
}

AAA__3GPP__VPLMN__LIPA__Allowed_template& AAA__3GPP__VPLMN__LIPA__Allowed_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
return value_list.list_value[list_index];
}

void AAA__3GPP__VPLMN__LIPA__Allowed_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(AAA__3GPP__VPLMN__LIPA__Allowed::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void AAA__3GPP__VPLMN__LIPA__Allowed_template::log_match(const AAA__3GPP__VPLMN__LIPA__Allowed& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void AAA__3GPP__VPLMN__LIPA__Allowed_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
}
}

void AAA__3GPP__VPLMN__LIPA__Allowed_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (AAA__3GPP__VPLMN__LIPA__Allowed::enum_type)text_buf.pull_int().get_val();
if (!AAA__3GPP__VPLMN__LIPA__Allowed::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new AAA__3GPP__VPLMN__LIPA__Allowed_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
}
}

boolean AAA__3GPP__VPLMN__LIPA__Allowed_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean AAA__3GPP__VPLMN__LIPA__Allowed_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void AAA__3GPP__VPLMN__LIPA__Allowed_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    AAA__3GPP__VPLMN__LIPA__Allowed_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    AAA__3GPP__VPLMN__LIPA__Allowed::enum_type enum_val = AAA__3GPP__VPLMN__LIPA__Allowed::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!AAA__3GPP__VPLMN__LIPA__Allowed::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    AAA__3GPP__VPLMN__LIPA__Allowed_template* precondition = new AAA__3GPP__VPLMN__LIPA__Allowed_template;
    precondition->set_param(*m_p->get_elem(0));
    AAA__3GPP__VPLMN__LIPA__Allowed_template* implied_template = new AAA__3GPP__VPLMN__LIPA__Allowed_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = AAA__3GPP__VPLMN__LIPA__Allowed_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed");
  }
  is_ifpresent = param.get_ifpresent();
}

void AAA__3GPP__VPLMN__LIPA__Allowed_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.AAA_3GPP_VPLMN_LIPA_Allowed");
}

PCC__3GPP__Mute__Notification::PCC__3GPP__Mute__Notification()
{
enum_value = UNBOUND_VALUE;
}

PCC__3GPP__Mute__Notification::PCC__3GPP__Mute__Notification(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

PCC__3GPP__Mute__Notification::PCC__3GPP__Mute__Notification(enum_type other_value)
{
enum_value = other_value;
}

PCC__3GPP__Mute__Notification::PCC__3GPP__Mute__Notification(const PCC__3GPP__Mute__Notification& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
enum_value = other_value.enum_value;
}

PCC__3GPP__Mute__Notification& PCC__3GPP__Mute__Notification::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

PCC__3GPP__Mute__Notification& PCC__3GPP__Mute__Notification::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

PCC__3GPP__Mute__Notification& PCC__3GPP__Mute__Notification::operator=(const PCC__3GPP__Mute__Notification& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
enum_value = other_value.enum_value;
return *this;
}

boolean PCC__3GPP__Mute__Notification::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean PCC__3GPP__Mute__Notification::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
return enum_value == other_value;
}

boolean PCC__3GPP__Mute__Notification::operator==(const PCC__3GPP__Mute__Notification& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
return enum_value == other_value.enum_value;
}

boolean PCC__3GPP__Mute__Notification::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean PCC__3GPP__Mute__Notification::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
return enum_value < other_value;
}

boolean PCC__3GPP__Mute__Notification::operator<(const PCC__3GPP__Mute__Notification& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
return enum_value < other_value.enum_value;
}

boolean PCC__3GPP__Mute__Notification::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean PCC__3GPP__Mute__Notification::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
return enum_value > other_value;
}

boolean PCC__3GPP__Mute__Notification::operator>(const PCC__3GPP__Mute__Notification& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
return enum_value > other_value.enum_value;
}

const char *PCC__3GPP__Mute__Notification::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case MUTE__REQUIRED: return "MUTE_REQUIRED";
default:
return "<unknown>";
}
}

PCC__3GPP__Mute__Notification::enum_type PCC__3GPP__Mute__Notification::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "MUTE_REQUIRED")) return MUTE__REQUIRED;
}
return UNKNOWN_VALUE;
}

boolean PCC__3GPP__Mute__Notification::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
return TRUE;
default:
return FALSE;
}
}

int PCC__3GPP__Mute__Notification::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int PCC__3GPP__Mute__Notification::enum2int(const PCC__3GPP__Mute__Notification& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void PCC__3GPP__Mute__Notification::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.", int_val);
enum_value = (enum_type)int_val;
}

PCC__3GPP__Mute__Notification::operator PCC__3GPP__Mute__Notification::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
return enum_value;
}

void PCC__3GPP__Mute__Notification::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void PCC__3GPP__Mute__Notification::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.PCC_3GPP_Mute_Notification");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
  }
}

void PCC__3GPP__Mute__Notification::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
text_buf.push_int(enum_value);
}

void PCC__3GPP__Mute__Notification::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.", enum_value);
}

void PCC__3GPP__Mute__Notification::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PCC__3GPP__Mute__Notification::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PCC__3GPP__Mute__Notification::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 1, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int PCC__3GPP__Mute__Notification::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 1);
}

void PCC__3GPP__Mute__Notification_template::copy_template(const PCC__3GPP__Mute__Notification_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PCC__3GPP__Mute__Notification_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PCC__3GPP__Mute__Notification_template(*other_value.implication_.precondition);
implication_.implied_template = new PCC__3GPP__Mute__Notification_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
}
}

PCC__3GPP__Mute__Notification_template::PCC__3GPP__Mute__Notification_template()
{
}

PCC__3GPP__Mute__Notification_template::PCC__3GPP__Mute__Notification_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PCC__3GPP__Mute__Notification_template::PCC__3GPP__Mute__Notification_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!PCC__3GPP__Mute__Notification::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification with unknown numeric value %d.", other_value);
single_value = (PCC__3GPP__Mute__Notification::enum_type)other_value;
}

PCC__3GPP__Mute__Notification_template::PCC__3GPP__Mute__Notification_template(PCC__3GPP__Mute__Notification::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

PCC__3GPP__Mute__Notification_template::PCC__3GPP__Mute__Notification_template(const PCC__3GPP__Mute__Notification& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == PCC__3GPP__Mute__Notification::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
single_value = other_value.enum_value;
}

PCC__3GPP__Mute__Notification_template::PCC__3GPP__Mute__Notification_template(const OPTIONAL<PCC__3GPP__Mute__Notification>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (PCC__3GPP__Mute__Notification::enum_type)(const PCC__3GPP__Mute__Notification&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification from an unbound optional field.");
}
}

PCC__3GPP__Mute__Notification_template::PCC__3GPP__Mute__Notification_template(PCC__3GPP__Mute__Notification_template* p_precondition, PCC__3GPP__Mute__Notification_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PCC__3GPP__Mute__Notification_template::PCC__3GPP__Mute__Notification_template(Dynamic_Match_Interface<PCC__3GPP__Mute__Notification>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PCC__3GPP__Mute__Notification>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PCC__3GPP__Mute__Notification_template::PCC__3GPP__Mute__Notification_template(const PCC__3GPP__Mute__Notification_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

PCC__3GPP__Mute__Notification_template::~PCC__3GPP__Mute__Notification_template()
{
clean_up();
}

boolean PCC__3GPP__Mute__Notification_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean PCC__3GPP__Mute__Notification_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != PCC__3GPP__Mute__Notification::UNBOUND_VALUE;
}

void PCC__3GPP__Mute__Notification_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PCC__3GPP__Mute__Notification_template& PCC__3GPP__Mute__Notification_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PCC__3GPP__Mute__Notification_template& PCC__3GPP__Mute__Notification_template::operator=(int other_value)
{
if (!PCC__3GPP__Mute__Notification::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (PCC__3GPP__Mute__Notification::enum_type)other_value;
return *this;
}

PCC__3GPP__Mute__Notification_template& PCC__3GPP__Mute__Notification_template::operator=(PCC__3GPP__Mute__Notification::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

PCC__3GPP__Mute__Notification_template& PCC__3GPP__Mute__Notification_template::operator=(const PCC__3GPP__Mute__Notification& other_value)
{
if (other_value.enum_value == PCC__3GPP__Mute__Notification::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

PCC__3GPP__Mute__Notification_template& PCC__3GPP__Mute__Notification_template::operator=(const OPTIONAL<PCC__3GPP__Mute__Notification>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (PCC__3GPP__Mute__Notification::enum_type)(const PCC__3GPP__Mute__Notification&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
}
return *this;
}

PCC__3GPP__Mute__Notification_template& PCC__3GPP__Mute__Notification_template::operator=(const PCC__3GPP__Mute__Notification_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PCC__3GPP__Mute__Notification_template::match(PCC__3GPP__Mute__Notification::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
}
return FALSE;
}

boolean PCC__3GPP__Mute__Notification_template::match(const PCC__3GPP__Mute__Notification& other_value, boolean) const
{
if (other_value.enum_value == PCC__3GPP__Mute__Notification::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification with an unbound value.");
return match(other_value.enum_value);
}

PCC__3GPP__Mute__Notification::enum_type PCC__3GPP__Mute__Notification_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
return single_value;
}

void PCC__3GPP__Mute__Notification_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PCC__3GPP__Mute__Notification_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
}
}

PCC__3GPP__Mute__Notification_template& PCC__3GPP__Mute__Notification_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
return value_list.list_value[list_index];
}

void PCC__3GPP__Mute__Notification_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(PCC__3GPP__Mute__Notification::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PCC__3GPP__Mute__Notification_template::log_match(const PCC__3GPP__Mute__Notification& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void PCC__3GPP__Mute__Notification_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
}
}

void PCC__3GPP__Mute__Notification_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (PCC__3GPP__Mute__Notification::enum_type)text_buf.pull_int().get_val();
if (!PCC__3GPP__Mute__Notification::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PCC__3GPP__Mute__Notification_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
}
}

boolean PCC__3GPP__Mute__Notification_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PCC__3GPP__Mute__Notification_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void PCC__3GPP__Mute__Notification_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PCC__3GPP__Mute__Notification_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    PCC__3GPP__Mute__Notification::enum_type enum_val = PCC__3GPP__Mute__Notification::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!PCC__3GPP__Mute__Notification::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.PCC_3GPP_Mute_Notification.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    PCC__3GPP__Mute__Notification_template* precondition = new PCC__3GPP__Mute__Notification_template;
    precondition->set_param(*m_p->get_elem(0));
    PCC__3GPP__Mute__Notification_template* implied_template = new PCC__3GPP__Mute__Notification_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = PCC__3GPP__Mute__Notification_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.PCC_3GPP_Mute_Notification");
  }
  is_ifpresent = param.get_ifpresent();
}

void PCC__3GPP__Mute__Notification_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.PCC_3GPP_Mute_Notification");
}

AAA__3GPP__Logging__Duration::AAA__3GPP__Logging__Duration()
{
enum_value = UNBOUND_VALUE;
}

AAA__3GPP__Logging__Duration::AAA__3GPP__Logging__Duration(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

AAA__3GPP__Logging__Duration::AAA__3GPP__Logging__Duration(enum_type other_value)
{
enum_value = other_value;
}

AAA__3GPP__Logging__Duration::AAA__3GPP__Logging__Duration(const AAA__3GPP__Logging__Duration& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
enum_value = other_value.enum_value;
}

AAA__3GPP__Logging__Duration& AAA__3GPP__Logging__Duration::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

AAA__3GPP__Logging__Duration& AAA__3GPP__Logging__Duration::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

AAA__3GPP__Logging__Duration& AAA__3GPP__Logging__Duration::operator=(const AAA__3GPP__Logging__Duration& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
enum_value = other_value.enum_value;
return *this;
}

boolean AAA__3GPP__Logging__Duration::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean AAA__3GPP__Logging__Duration::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
return enum_value == other_value;
}

boolean AAA__3GPP__Logging__Duration::operator==(const AAA__3GPP__Logging__Duration& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
return enum_value == other_value.enum_value;
}

boolean AAA__3GPP__Logging__Duration::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean AAA__3GPP__Logging__Duration::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
return enum_value < other_value;
}

boolean AAA__3GPP__Logging__Duration::operator<(const AAA__3GPP__Logging__Duration& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
return enum_value < other_value.enum_value;
}

boolean AAA__3GPP__Logging__Duration::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean AAA__3GPP__Logging__Duration::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
return enum_value > other_value;
}

boolean AAA__3GPP__Logging__Duration::operator>(const AAA__3GPP__Logging__Duration& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
return enum_value > other_value.enum_value;
}

const char *AAA__3GPP__Logging__Duration::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case LD__600__SEC: return "LD_600_SEC";
case LD__1200__SEC: return "LD_1200_SEC";
case LD__2400__SEC: return "LD_2400_SEC";
case LD__3600__SEC: return "LD_3600_SEC";
case LD__5400__SEC: return "LD_5400_SEC";
case LD__7200__SEC: return "LD_7200_SEC";
default:
return "<unknown>";
}
}

AAA__3GPP__Logging__Duration::enum_type AAA__3GPP__Logging__Duration::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "LD_600_SEC")) return LD__600__SEC;
if (!strcmp(str_par, "LD_1200_SEC")) return LD__1200__SEC;
if (!strcmp(str_par, "LD_2400_SEC")) return LD__2400__SEC;
if (!strcmp(str_par, "LD_3600_SEC")) return LD__3600__SEC;
if (!strcmp(str_par, "LD_5400_SEC")) return LD__5400__SEC;
if (!strcmp(str_par, "LD_7200_SEC")) return LD__7200__SEC;
}
return UNKNOWN_VALUE;
}

boolean AAA__3GPP__Logging__Duration::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
case 4:
case 5:
return TRUE;
default:
return FALSE;
}
}

int AAA__3GPP__Logging__Duration::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int AAA__3GPP__Logging__Duration::enum2int(const AAA__3GPP__Logging__Duration& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void AAA__3GPP__Logging__Duration::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.", int_val);
enum_value = (enum_type)int_val;
}

AAA__3GPP__Logging__Duration::operator AAA__3GPP__Logging__Duration::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
return enum_value;
}

void AAA__3GPP__Logging__Duration::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void AAA__3GPP__Logging__Duration::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.AAA_3GPP_Logging_Duration");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
  }
}

void AAA__3GPP__Logging__Duration::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
text_buf.push_int(enum_value);
}

void AAA__3GPP__Logging__Duration::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.", enum_value);
}

void AAA__3GPP__Logging__Duration::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void AAA__3GPP__Logging__Duration::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int AAA__3GPP__Logging__Duration::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 3, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int AAA__3GPP__Logging__Duration::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 3);
}

void AAA__3GPP__Logging__Duration_template::copy_template(const AAA__3GPP__Logging__Duration_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new AAA__3GPP__Logging__Duration_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new AAA__3GPP__Logging__Duration_template(*other_value.implication_.precondition);
implication_.implied_template = new AAA__3GPP__Logging__Duration_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
}
}

AAA__3GPP__Logging__Duration_template::AAA__3GPP__Logging__Duration_template()
{
}

AAA__3GPP__Logging__Duration_template::AAA__3GPP__Logging__Duration_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

AAA__3GPP__Logging__Duration_template::AAA__3GPP__Logging__Duration_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!AAA__3GPP__Logging__Duration::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration with unknown numeric value %d.", other_value);
single_value = (AAA__3GPP__Logging__Duration::enum_type)other_value;
}

AAA__3GPP__Logging__Duration_template::AAA__3GPP__Logging__Duration_template(AAA__3GPP__Logging__Duration::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

AAA__3GPP__Logging__Duration_template::AAA__3GPP__Logging__Duration_template(const AAA__3GPP__Logging__Duration& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == AAA__3GPP__Logging__Duration::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
single_value = other_value.enum_value;
}

AAA__3GPP__Logging__Duration_template::AAA__3GPP__Logging__Duration_template(const OPTIONAL<AAA__3GPP__Logging__Duration>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (AAA__3GPP__Logging__Duration::enum_type)(const AAA__3GPP__Logging__Duration&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration from an unbound optional field.");
}
}

AAA__3GPP__Logging__Duration_template::AAA__3GPP__Logging__Duration_template(AAA__3GPP__Logging__Duration_template* p_precondition, AAA__3GPP__Logging__Duration_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

AAA__3GPP__Logging__Duration_template::AAA__3GPP__Logging__Duration_template(Dynamic_Match_Interface<AAA__3GPP__Logging__Duration>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<AAA__3GPP__Logging__Duration>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

AAA__3GPP__Logging__Duration_template::AAA__3GPP__Logging__Duration_template(const AAA__3GPP__Logging__Duration_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

AAA__3GPP__Logging__Duration_template::~AAA__3GPP__Logging__Duration_template()
{
clean_up();
}

boolean AAA__3GPP__Logging__Duration_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean AAA__3GPP__Logging__Duration_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != AAA__3GPP__Logging__Duration::UNBOUND_VALUE;
}

void AAA__3GPP__Logging__Duration_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

AAA__3GPP__Logging__Duration_template& AAA__3GPP__Logging__Duration_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

AAA__3GPP__Logging__Duration_template& AAA__3GPP__Logging__Duration_template::operator=(int other_value)
{
if (!AAA__3GPP__Logging__Duration::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (AAA__3GPP__Logging__Duration::enum_type)other_value;
return *this;
}

AAA__3GPP__Logging__Duration_template& AAA__3GPP__Logging__Duration_template::operator=(AAA__3GPP__Logging__Duration::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

AAA__3GPP__Logging__Duration_template& AAA__3GPP__Logging__Duration_template::operator=(const AAA__3GPP__Logging__Duration& other_value)
{
if (other_value.enum_value == AAA__3GPP__Logging__Duration::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

AAA__3GPP__Logging__Duration_template& AAA__3GPP__Logging__Duration_template::operator=(const OPTIONAL<AAA__3GPP__Logging__Duration>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (AAA__3GPP__Logging__Duration::enum_type)(const AAA__3GPP__Logging__Duration&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
}
return *this;
}

AAA__3GPP__Logging__Duration_template& AAA__3GPP__Logging__Duration_template::operator=(const AAA__3GPP__Logging__Duration_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean AAA__3GPP__Logging__Duration_template::match(AAA__3GPP__Logging__Duration::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
}
return FALSE;
}

boolean AAA__3GPP__Logging__Duration_template::match(const AAA__3GPP__Logging__Duration& other_value, boolean) const
{
if (other_value.enum_value == AAA__3GPP__Logging__Duration::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration with an unbound value.");
return match(other_value.enum_value);
}

AAA__3GPP__Logging__Duration::enum_type AAA__3GPP__Logging__Duration_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
return single_value;
}

void AAA__3GPP__Logging__Duration_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new AAA__3GPP__Logging__Duration_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
}
}

AAA__3GPP__Logging__Duration_template& AAA__3GPP__Logging__Duration_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
return value_list.list_value[list_index];
}

void AAA__3GPP__Logging__Duration_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(AAA__3GPP__Logging__Duration::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void AAA__3GPP__Logging__Duration_template::log_match(const AAA__3GPP__Logging__Duration& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void AAA__3GPP__Logging__Duration_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
}
}

void AAA__3GPP__Logging__Duration_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (AAA__3GPP__Logging__Duration::enum_type)text_buf.pull_int().get_val();
if (!AAA__3GPP__Logging__Duration::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new AAA__3GPP__Logging__Duration_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
}
}

boolean AAA__3GPP__Logging__Duration_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean AAA__3GPP__Logging__Duration_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void AAA__3GPP__Logging__Duration_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    AAA__3GPP__Logging__Duration_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    AAA__3GPP__Logging__Duration::enum_type enum_val = AAA__3GPP__Logging__Duration::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!AAA__3GPP__Logging__Duration::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.AAA_3GPP_Logging_Duration.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    AAA__3GPP__Logging__Duration_template* precondition = new AAA__3GPP__Logging__Duration_template;
    precondition->set_param(*m_p->get_elem(0));
    AAA__3GPP__Logging__Duration_template* implied_template = new AAA__3GPP__Logging__Duration_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = AAA__3GPP__Logging__Duration_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.AAA_3GPP_Logging_Duration");
  }
  is_ifpresent = param.get_ifpresent();
}

void AAA__3GPP__Logging__Duration_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.AAA_3GPP_Logging_Duration");
}

DCA__3GPP__IMS__Emergency__Indicator::DCA__3GPP__IMS__Emergency__Indicator()
{
enum_value = UNBOUND_VALUE;
}

DCA__3GPP__IMS__Emergency__Indicator::DCA__3GPP__IMS__Emergency__Indicator(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

DCA__3GPP__IMS__Emergency__Indicator::DCA__3GPP__IMS__Emergency__Indicator(enum_type other_value)
{
enum_value = other_value;
}

DCA__3GPP__IMS__Emergency__Indicator::DCA__3GPP__IMS__Emergency__Indicator(const DCA__3GPP__IMS__Emergency__Indicator& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
enum_value = other_value.enum_value;
}

DCA__3GPP__IMS__Emergency__Indicator& DCA__3GPP__IMS__Emergency__Indicator::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

DCA__3GPP__IMS__Emergency__Indicator& DCA__3GPP__IMS__Emergency__Indicator::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

DCA__3GPP__IMS__Emergency__Indicator& DCA__3GPP__IMS__Emergency__Indicator::operator=(const DCA__3GPP__IMS__Emergency__Indicator& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
enum_value = other_value.enum_value;
return *this;
}

boolean DCA__3GPP__IMS__Emergency__Indicator::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean DCA__3GPP__IMS__Emergency__Indicator::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
return enum_value == other_value;
}

boolean DCA__3GPP__IMS__Emergency__Indicator::operator==(const DCA__3GPP__IMS__Emergency__Indicator& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
return enum_value == other_value.enum_value;
}

boolean DCA__3GPP__IMS__Emergency__Indicator::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean DCA__3GPP__IMS__Emergency__Indicator::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
return enum_value < other_value;
}

boolean DCA__3GPP__IMS__Emergency__Indicator::operator<(const DCA__3GPP__IMS__Emergency__Indicator& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
return enum_value < other_value.enum_value;
}

boolean DCA__3GPP__IMS__Emergency__Indicator::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean DCA__3GPP__IMS__Emergency__Indicator::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
return enum_value > other_value;
}

boolean DCA__3GPP__IMS__Emergency__Indicator::operator>(const DCA__3GPP__IMS__Emergency__Indicator& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
return enum_value > other_value.enum_value;
}

const char *DCA__3GPP__IMS__Emergency__Indicator::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case Non__Emergency: return "Non_Emergency";
case Emergency: return "Emergency";
default:
return "<unknown>";
}
}

DCA__3GPP__IMS__Emergency__Indicator::enum_type DCA__3GPP__IMS__Emergency__Indicator::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "Non_Emergency")) return Non__Emergency;
if (!strcmp(str_par, "Emergency")) return Emergency;
}
return UNKNOWN_VALUE;
}

boolean DCA__3GPP__IMS__Emergency__Indicator::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
return TRUE;
default:
return FALSE;
}
}

int DCA__3GPP__IMS__Emergency__Indicator::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int DCA__3GPP__IMS__Emergency__Indicator::enum2int(const DCA__3GPP__IMS__Emergency__Indicator& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void DCA__3GPP__IMS__Emergency__Indicator::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.", int_val);
enum_value = (enum_type)int_val;
}

DCA__3GPP__IMS__Emergency__Indicator::operator DCA__3GPP__IMS__Emergency__Indicator::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
return enum_value;
}

void DCA__3GPP__IMS__Emergency__Indicator::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void DCA__3GPP__IMS__Emergency__Indicator::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
  }
}

void DCA__3GPP__IMS__Emergency__Indicator::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
text_buf.push_int(enum_value);
}

void DCA__3GPP__IMS__Emergency__Indicator::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.", enum_value);
}

void DCA__3GPP__IMS__Emergency__Indicator::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void DCA__3GPP__IMS__Emergency__Indicator::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int DCA__3GPP__IMS__Emergency__Indicator::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int DCA__3GPP__IMS__Emergency__Indicator::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void DCA__3GPP__IMS__Emergency__Indicator_template::copy_template(const DCA__3GPP__IMS__Emergency__Indicator_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new DCA__3GPP__IMS__Emergency__Indicator_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new DCA__3GPP__IMS__Emergency__Indicator_template(*other_value.implication_.precondition);
implication_.implied_template = new DCA__3GPP__IMS__Emergency__Indicator_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
}
}

DCA__3GPP__IMS__Emergency__Indicator_template::DCA__3GPP__IMS__Emergency__Indicator_template()
{
}

DCA__3GPP__IMS__Emergency__Indicator_template::DCA__3GPP__IMS__Emergency__Indicator_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

DCA__3GPP__IMS__Emergency__Indicator_template::DCA__3GPP__IMS__Emergency__Indicator_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!DCA__3GPP__IMS__Emergency__Indicator::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator with unknown numeric value %d.", other_value);
single_value = (DCA__3GPP__IMS__Emergency__Indicator::enum_type)other_value;
}

DCA__3GPP__IMS__Emergency__Indicator_template::DCA__3GPP__IMS__Emergency__Indicator_template(DCA__3GPP__IMS__Emergency__Indicator::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

DCA__3GPP__IMS__Emergency__Indicator_template::DCA__3GPP__IMS__Emergency__Indicator_template(const DCA__3GPP__IMS__Emergency__Indicator& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == DCA__3GPP__IMS__Emergency__Indicator::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
single_value = other_value.enum_value;
}

DCA__3GPP__IMS__Emergency__Indicator_template::DCA__3GPP__IMS__Emergency__Indicator_template(const OPTIONAL<DCA__3GPP__IMS__Emergency__Indicator>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__IMS__Emergency__Indicator::enum_type)(const DCA__3GPP__IMS__Emergency__Indicator&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator from an unbound optional field.");
}
}

DCA__3GPP__IMS__Emergency__Indicator_template::DCA__3GPP__IMS__Emergency__Indicator_template(DCA__3GPP__IMS__Emergency__Indicator_template* p_precondition, DCA__3GPP__IMS__Emergency__Indicator_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

DCA__3GPP__IMS__Emergency__Indicator_template::DCA__3GPP__IMS__Emergency__Indicator_template(Dynamic_Match_Interface<DCA__3GPP__IMS__Emergency__Indicator>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<DCA__3GPP__IMS__Emergency__Indicator>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

DCA__3GPP__IMS__Emergency__Indicator_template::DCA__3GPP__IMS__Emergency__Indicator_template(const DCA__3GPP__IMS__Emergency__Indicator_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

DCA__3GPP__IMS__Emergency__Indicator_template::~DCA__3GPP__IMS__Emergency__Indicator_template()
{
clean_up();
}

boolean DCA__3GPP__IMS__Emergency__Indicator_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean DCA__3GPP__IMS__Emergency__Indicator_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != DCA__3GPP__IMS__Emergency__Indicator::UNBOUND_VALUE;
}

void DCA__3GPP__IMS__Emergency__Indicator_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

DCA__3GPP__IMS__Emergency__Indicator_template& DCA__3GPP__IMS__Emergency__Indicator_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

DCA__3GPP__IMS__Emergency__Indicator_template& DCA__3GPP__IMS__Emergency__Indicator_template::operator=(int other_value)
{
if (!DCA__3GPP__IMS__Emergency__Indicator::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__IMS__Emergency__Indicator::enum_type)other_value;
return *this;
}

DCA__3GPP__IMS__Emergency__Indicator_template& DCA__3GPP__IMS__Emergency__Indicator_template::operator=(DCA__3GPP__IMS__Emergency__Indicator::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

DCA__3GPP__IMS__Emergency__Indicator_template& DCA__3GPP__IMS__Emergency__Indicator_template::operator=(const DCA__3GPP__IMS__Emergency__Indicator& other_value)
{
if (other_value.enum_value == DCA__3GPP__IMS__Emergency__Indicator::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

DCA__3GPP__IMS__Emergency__Indicator_template& DCA__3GPP__IMS__Emergency__Indicator_template::operator=(const OPTIONAL<DCA__3GPP__IMS__Emergency__Indicator>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (DCA__3GPP__IMS__Emergency__Indicator::enum_type)(const DCA__3GPP__IMS__Emergency__Indicator&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
}
return *this;
}

DCA__3GPP__IMS__Emergency__Indicator_template& DCA__3GPP__IMS__Emergency__Indicator_template::operator=(const DCA__3GPP__IMS__Emergency__Indicator_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean DCA__3GPP__IMS__Emergency__Indicator_template::match(DCA__3GPP__IMS__Emergency__Indicator::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
}
return FALSE;
}

boolean DCA__3GPP__IMS__Emergency__Indicator_template::match(const DCA__3GPP__IMS__Emergency__Indicator& other_value, boolean) const
{
if (other_value.enum_value == DCA__3GPP__IMS__Emergency__Indicator::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator with an unbound value.");
return match(other_value.enum_value);
}

DCA__3GPP__IMS__Emergency__Indicator::enum_type DCA__3GPP__IMS__Emergency__Indicator_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
return single_value;
}

void DCA__3GPP__IMS__Emergency__Indicator_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new DCA__3GPP__IMS__Emergency__Indicator_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
}
}

DCA__3GPP__IMS__Emergency__Indicator_template& DCA__3GPP__IMS__Emergency__Indicator_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
return value_list.list_value[list_index];
}

void DCA__3GPP__IMS__Emergency__Indicator_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(DCA__3GPP__IMS__Emergency__Indicator::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void DCA__3GPP__IMS__Emergency__Indicator_template::log_match(const DCA__3GPP__IMS__Emergency__Indicator& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void DCA__3GPP__IMS__Emergency__Indicator_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
}
}

void DCA__3GPP__IMS__Emergency__Indicator_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (DCA__3GPP__IMS__Emergency__Indicator::enum_type)text_buf.pull_int().get_val();
if (!DCA__3GPP__IMS__Emergency__Indicator::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new DCA__3GPP__IMS__Emergency__Indicator_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
}
}

boolean DCA__3GPP__IMS__Emergency__Indicator_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean DCA__3GPP__IMS__Emergency__Indicator_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void DCA__3GPP__IMS__Emergency__Indicator_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    DCA__3GPP__IMS__Emergency__Indicator_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    DCA__3GPP__IMS__Emergency__Indicator::enum_type enum_val = DCA__3GPP__IMS__Emergency__Indicator::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!DCA__3GPP__IMS__Emergency__Indicator::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    DCA__3GPP__IMS__Emergency__Indicator_template* precondition = new DCA__3GPP__IMS__Emergency__Indicator_template;
    precondition->set_param(*m_p->get_elem(0));
    DCA__3GPP__IMS__Emergency__Indicator_template* implied_template = new DCA__3GPP__IMS__Emergency__Indicator_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = DCA__3GPP__IMS__Emergency__Indicator_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator");
  }
  is_ifpresent = param.get_ifpresent();
}

void DCA__3GPP__IMS__Emergency__Indicator_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.DCA_3GPP_IMS_Emergency_Indicator");
}

AAA__3GPP__Non__3GPP__IP__Access__APN::AAA__3GPP__Non__3GPP__IP__Access__APN()
{
enum_value = UNBOUND_VALUE;
}

AAA__3GPP__Non__3GPP__IP__Access__APN::AAA__3GPP__Non__3GPP__IP__Access__APN(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

AAA__3GPP__Non__3GPP__IP__Access__APN::AAA__3GPP__Non__3GPP__IP__Access__APN(enum_type other_value)
{
enum_value = other_value;
}

AAA__3GPP__Non__3GPP__IP__Access__APN::AAA__3GPP__Non__3GPP__IP__Access__APN(const AAA__3GPP__Non__3GPP__IP__Access__APN& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
enum_value = other_value.enum_value;
}

AAA__3GPP__Non__3GPP__IP__Access__APN& AAA__3GPP__Non__3GPP__IP__Access__APN::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

AAA__3GPP__Non__3GPP__IP__Access__APN& AAA__3GPP__Non__3GPP__IP__Access__APN::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

AAA__3GPP__Non__3GPP__IP__Access__APN& AAA__3GPP__Non__3GPP__IP__Access__APN::operator=(const AAA__3GPP__Non__3GPP__IP__Access__APN& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
enum_value = other_value.enum_value;
return *this;
}

boolean AAA__3GPP__Non__3GPP__IP__Access__APN::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean AAA__3GPP__Non__3GPP__IP__Access__APN::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
return enum_value == other_value;
}

boolean AAA__3GPP__Non__3GPP__IP__Access__APN::operator==(const AAA__3GPP__Non__3GPP__IP__Access__APN& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
return enum_value == other_value.enum_value;
}

boolean AAA__3GPP__Non__3GPP__IP__Access__APN::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean AAA__3GPP__Non__3GPP__IP__Access__APN::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
return enum_value < other_value;
}

boolean AAA__3GPP__Non__3GPP__IP__Access__APN::operator<(const AAA__3GPP__Non__3GPP__IP__Access__APN& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
return enum_value < other_value.enum_value;
}

boolean AAA__3GPP__Non__3GPP__IP__Access__APN::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean AAA__3GPP__Non__3GPP__IP__Access__APN::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
return enum_value > other_value;
}

boolean AAA__3GPP__Non__3GPP__IP__Access__APN::operator>(const AAA__3GPP__Non__3GPP__IP__Access__APN& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
return enum_value > other_value.enum_value;
}

const char *AAA__3GPP__Non__3GPP__IP__Access__APN::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case NON__3GPP__APNS__ENABLE: return "NON_3GPP_APNS_ENABLE";
case NON__3GPP__APNS__DISABLE: return "NON_3GPP_APNS_DISABLE";
default:
return "<unknown>";
}
}

AAA__3GPP__Non__3GPP__IP__Access__APN::enum_type AAA__3GPP__Non__3GPP__IP__Access__APN::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "NON_3GPP_APNS_ENABLE")) return NON__3GPP__APNS__ENABLE;
if (!strcmp(str_par, "NON_3GPP_APNS_DISABLE")) return NON__3GPP__APNS__DISABLE;
}
return UNKNOWN_VALUE;
}

boolean AAA__3GPP__Non__3GPP__IP__Access__APN::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
return TRUE;
default:
return FALSE;
}
}

int AAA__3GPP__Non__3GPP__IP__Access__APN::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int AAA__3GPP__Non__3GPP__IP__Access__APN::enum2int(const AAA__3GPP__Non__3GPP__IP__Access__APN& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void AAA__3GPP__Non__3GPP__IP__Access__APN::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.", int_val);
enum_value = (enum_type)int_val;
}

AAA__3GPP__Non__3GPP__IP__Access__APN::operator AAA__3GPP__Non__3GPP__IP__Access__APN::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
return enum_value;
}

void AAA__3GPP__Non__3GPP__IP__Access__APN::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void AAA__3GPP__Non__3GPP__IP__Access__APN::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
  }
}

void AAA__3GPP__Non__3GPP__IP__Access__APN::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
text_buf.push_int(enum_value);
}

void AAA__3GPP__Non__3GPP__IP__Access__APN::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.", enum_value);
}

void AAA__3GPP__Non__3GPP__IP__Access__APN::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void AAA__3GPP__Non__3GPP__IP__Access__APN::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int AAA__3GPP__Non__3GPP__IP__Access__APN::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int AAA__3GPP__Non__3GPP__IP__Access__APN::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void AAA__3GPP__Non__3GPP__IP__Access__APN_template::copy_template(const AAA__3GPP__Non__3GPP__IP__Access__APN_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new AAA__3GPP__Non__3GPP__IP__Access__APN_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new AAA__3GPP__Non__3GPP__IP__Access__APN_template(*other_value.implication_.precondition);
implication_.implied_template = new AAA__3GPP__Non__3GPP__IP__Access__APN_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
}
}

AAA__3GPP__Non__3GPP__IP__Access__APN_template::AAA__3GPP__Non__3GPP__IP__Access__APN_template()
{
}

AAA__3GPP__Non__3GPP__IP__Access__APN_template::AAA__3GPP__Non__3GPP__IP__Access__APN_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

AAA__3GPP__Non__3GPP__IP__Access__APN_template::AAA__3GPP__Non__3GPP__IP__Access__APN_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!AAA__3GPP__Non__3GPP__IP__Access__APN::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN with unknown numeric value %d.", other_value);
single_value = (AAA__3GPP__Non__3GPP__IP__Access__APN::enum_type)other_value;
}

AAA__3GPP__Non__3GPP__IP__Access__APN_template::AAA__3GPP__Non__3GPP__IP__Access__APN_template(AAA__3GPP__Non__3GPP__IP__Access__APN::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

AAA__3GPP__Non__3GPP__IP__Access__APN_template::AAA__3GPP__Non__3GPP__IP__Access__APN_template(const AAA__3GPP__Non__3GPP__IP__Access__APN& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == AAA__3GPP__Non__3GPP__IP__Access__APN::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
single_value = other_value.enum_value;
}

AAA__3GPP__Non__3GPP__IP__Access__APN_template::AAA__3GPP__Non__3GPP__IP__Access__APN_template(const OPTIONAL<AAA__3GPP__Non__3GPP__IP__Access__APN>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (AAA__3GPP__Non__3GPP__IP__Access__APN::enum_type)(const AAA__3GPP__Non__3GPP__IP__Access__APN&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN from an unbound optional field.");
}
}

AAA__3GPP__Non__3GPP__IP__Access__APN_template::AAA__3GPP__Non__3GPP__IP__Access__APN_template(AAA__3GPP__Non__3GPP__IP__Access__APN_template* p_precondition, AAA__3GPP__Non__3GPP__IP__Access__APN_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

AAA__3GPP__Non__3GPP__IP__Access__APN_template::AAA__3GPP__Non__3GPP__IP__Access__APN_template(Dynamic_Match_Interface<AAA__3GPP__Non__3GPP__IP__Access__APN>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<AAA__3GPP__Non__3GPP__IP__Access__APN>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

AAA__3GPP__Non__3GPP__IP__Access__APN_template::AAA__3GPP__Non__3GPP__IP__Access__APN_template(const AAA__3GPP__Non__3GPP__IP__Access__APN_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

AAA__3GPP__Non__3GPP__IP__Access__APN_template::~AAA__3GPP__Non__3GPP__IP__Access__APN_template()
{
clean_up();
}

boolean AAA__3GPP__Non__3GPP__IP__Access__APN_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean AAA__3GPP__Non__3GPP__IP__Access__APN_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != AAA__3GPP__Non__3GPP__IP__Access__APN::UNBOUND_VALUE;
}

void AAA__3GPP__Non__3GPP__IP__Access__APN_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

AAA__3GPP__Non__3GPP__IP__Access__APN_template& AAA__3GPP__Non__3GPP__IP__Access__APN_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

AAA__3GPP__Non__3GPP__IP__Access__APN_template& AAA__3GPP__Non__3GPP__IP__Access__APN_template::operator=(int other_value)
{
if (!AAA__3GPP__Non__3GPP__IP__Access__APN::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (AAA__3GPP__Non__3GPP__IP__Access__APN::enum_type)other_value;
return *this;
}

AAA__3GPP__Non__3GPP__IP__Access__APN_template& AAA__3GPP__Non__3GPP__IP__Access__APN_template::operator=(AAA__3GPP__Non__3GPP__IP__Access__APN::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

AAA__3GPP__Non__3GPP__IP__Access__APN_template& AAA__3GPP__Non__3GPP__IP__Access__APN_template::operator=(const AAA__3GPP__Non__3GPP__IP__Access__APN& other_value)
{
if (other_value.enum_value == AAA__3GPP__Non__3GPP__IP__Access__APN::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

AAA__3GPP__Non__3GPP__IP__Access__APN_template& AAA__3GPP__Non__3GPP__IP__Access__APN_template::operator=(const OPTIONAL<AAA__3GPP__Non__3GPP__IP__Access__APN>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (AAA__3GPP__Non__3GPP__IP__Access__APN::enum_type)(const AAA__3GPP__Non__3GPP__IP__Access__APN&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
}
return *this;
}

AAA__3GPP__Non__3GPP__IP__Access__APN_template& AAA__3GPP__Non__3GPP__IP__Access__APN_template::operator=(const AAA__3GPP__Non__3GPP__IP__Access__APN_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean AAA__3GPP__Non__3GPP__IP__Access__APN_template::match(AAA__3GPP__Non__3GPP__IP__Access__APN::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
}
return FALSE;
}

boolean AAA__3GPP__Non__3GPP__IP__Access__APN_template::match(const AAA__3GPP__Non__3GPP__IP__Access__APN& other_value, boolean) const
{
if (other_value.enum_value == AAA__3GPP__Non__3GPP__IP__Access__APN::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN with an unbound value.");
return match(other_value.enum_value);
}

AAA__3GPP__Non__3GPP__IP__Access__APN::enum_type AAA__3GPP__Non__3GPP__IP__Access__APN_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
return single_value;
}

void AAA__3GPP__Non__3GPP__IP__Access__APN_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new AAA__3GPP__Non__3GPP__IP__Access__APN_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
}
}

AAA__3GPP__Non__3GPP__IP__Access__APN_template& AAA__3GPP__Non__3GPP__IP__Access__APN_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
return value_list.list_value[list_index];
}

void AAA__3GPP__Non__3GPP__IP__Access__APN_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(AAA__3GPP__Non__3GPP__IP__Access__APN::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void AAA__3GPP__Non__3GPP__IP__Access__APN_template::log_match(const AAA__3GPP__Non__3GPP__IP__Access__APN& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void AAA__3GPP__Non__3GPP__IP__Access__APN_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
}
}

void AAA__3GPP__Non__3GPP__IP__Access__APN_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (AAA__3GPP__Non__3GPP__IP__Access__APN::enum_type)text_buf.pull_int().get_val();
if (!AAA__3GPP__Non__3GPP__IP__Access__APN::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new AAA__3GPP__Non__3GPP__IP__Access__APN_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
}
}

boolean AAA__3GPP__Non__3GPP__IP__Access__APN_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean AAA__3GPP__Non__3GPP__IP__Access__APN_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void AAA__3GPP__Non__3GPP__IP__Access__APN_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    AAA__3GPP__Non__3GPP__IP__Access__APN_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    AAA__3GPP__Non__3GPP__IP__Access__APN::enum_type enum_val = AAA__3GPP__Non__3GPP__IP__Access__APN::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!AAA__3GPP__Non__3GPP__IP__Access__APN::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    AAA__3GPP__Non__3GPP__IP__Access__APN_template* precondition = new AAA__3GPP__Non__3GPP__IP__Access__APN_template;
    precondition->set_param(*m_p->get_elem(0));
    AAA__3GPP__Non__3GPP__IP__Access__APN_template* implied_template = new AAA__3GPP__Non__3GPP__IP__Access__APN_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = AAA__3GPP__Non__3GPP__IP__Access__APN_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN");
  }
  is_ifpresent = param.get_ifpresent();
}

void AAA__3GPP__Non__3GPP__IP__Access__APN_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.AAA_3GPP_Non_3GPP_IP_Access_APN");
}

RX__3GPP__Flow__Usage::RX__3GPP__Flow__Usage()
{
enum_value = UNBOUND_VALUE;
}

RX__3GPP__Flow__Usage::RX__3GPP__Flow__Usage(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

RX__3GPP__Flow__Usage::RX__3GPP__Flow__Usage(enum_type other_value)
{
enum_value = other_value;
}

RX__3GPP__Flow__Usage::RX__3GPP__Flow__Usage(const RX__3GPP__Flow__Usage& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
enum_value = other_value.enum_value;
}

RX__3GPP__Flow__Usage& RX__3GPP__Flow__Usage::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

RX__3GPP__Flow__Usage& RX__3GPP__Flow__Usage::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

RX__3GPP__Flow__Usage& RX__3GPP__Flow__Usage::operator=(const RX__3GPP__Flow__Usage& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
enum_value = other_value.enum_value;
return *this;
}

boolean RX__3GPP__Flow__Usage::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean RX__3GPP__Flow__Usage::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
return enum_value == other_value;
}

boolean RX__3GPP__Flow__Usage::operator==(const RX__3GPP__Flow__Usage& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
return enum_value == other_value.enum_value;
}

boolean RX__3GPP__Flow__Usage::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean RX__3GPP__Flow__Usage::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
return enum_value < other_value;
}

boolean RX__3GPP__Flow__Usage::operator<(const RX__3GPP__Flow__Usage& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
return enum_value < other_value.enum_value;
}

boolean RX__3GPP__Flow__Usage::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean RX__3GPP__Flow__Usage::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
return enum_value > other_value;
}

boolean RX__3GPP__Flow__Usage::operator>(const RX__3GPP__Flow__Usage& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
return enum_value > other_value.enum_value;
}

const char *RX__3GPP__Flow__Usage::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case NO__INFORMATION: return "NO_INFORMATION";
case RTCP: return "RTCP";
case AF__SIGNALLING: return "AF_SIGNALLING";
default:
return "<unknown>";
}
}

RX__3GPP__Flow__Usage::enum_type RX__3GPP__Flow__Usage::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "NO_INFORMATION")) return NO__INFORMATION;
if (!strcmp(str_par, "RTCP")) return RTCP;
if (!strcmp(str_par, "AF_SIGNALLING")) return AF__SIGNALLING;
}
return UNKNOWN_VALUE;
}

boolean RX__3GPP__Flow__Usage::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
return TRUE;
default:
return FALSE;
}
}

int RX__3GPP__Flow__Usage::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int RX__3GPP__Flow__Usage::enum2int(const RX__3GPP__Flow__Usage& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void RX__3GPP__Flow__Usage::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.", int_val);
enum_value = (enum_type)int_val;
}

RX__3GPP__Flow__Usage::operator RX__3GPP__Flow__Usage::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
return enum_value;
}

void RX__3GPP__Flow__Usage::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void RX__3GPP__Flow__Usage::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.RX_3GPP_Flow_Usage");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
  }
}

void RX__3GPP__Flow__Usage::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
text_buf.push_int(enum_value);
}

void RX__3GPP__Flow__Usage::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.", enum_value);
}

void RX__3GPP__Flow__Usage::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void RX__3GPP__Flow__Usage::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int RX__3GPP__Flow__Usage::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 2, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int RX__3GPP__Flow__Usage::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 2);
}

void RX__3GPP__Flow__Usage_template::copy_template(const RX__3GPP__Flow__Usage_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new RX__3GPP__Flow__Usage_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new RX__3GPP__Flow__Usage_template(*other_value.implication_.precondition);
implication_.implied_template = new RX__3GPP__Flow__Usage_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
}
}

RX__3GPP__Flow__Usage_template::RX__3GPP__Flow__Usage_template()
{
}

RX__3GPP__Flow__Usage_template::RX__3GPP__Flow__Usage_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

RX__3GPP__Flow__Usage_template::RX__3GPP__Flow__Usage_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!RX__3GPP__Flow__Usage::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage with unknown numeric value %d.", other_value);
single_value = (RX__3GPP__Flow__Usage::enum_type)other_value;
}

RX__3GPP__Flow__Usage_template::RX__3GPP__Flow__Usage_template(RX__3GPP__Flow__Usage::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

RX__3GPP__Flow__Usage_template::RX__3GPP__Flow__Usage_template(const RX__3GPP__Flow__Usage& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == RX__3GPP__Flow__Usage::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
single_value = other_value.enum_value;
}

RX__3GPP__Flow__Usage_template::RX__3GPP__Flow__Usage_template(const OPTIONAL<RX__3GPP__Flow__Usage>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RX__3GPP__Flow__Usage::enum_type)(const RX__3GPP__Flow__Usage&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage from an unbound optional field.");
}
}

RX__3GPP__Flow__Usage_template::RX__3GPP__Flow__Usage_template(RX__3GPP__Flow__Usage_template* p_precondition, RX__3GPP__Flow__Usage_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

RX__3GPP__Flow__Usage_template::RX__3GPP__Flow__Usage_template(Dynamic_Match_Interface<RX__3GPP__Flow__Usage>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<RX__3GPP__Flow__Usage>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

RX__3GPP__Flow__Usage_template::RX__3GPP__Flow__Usage_template(const RX__3GPP__Flow__Usage_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

RX__3GPP__Flow__Usage_template::~RX__3GPP__Flow__Usage_template()
{
clean_up();
}

boolean RX__3GPP__Flow__Usage_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean RX__3GPP__Flow__Usage_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != RX__3GPP__Flow__Usage::UNBOUND_VALUE;
}

void RX__3GPP__Flow__Usage_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

RX__3GPP__Flow__Usage_template& RX__3GPP__Flow__Usage_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

RX__3GPP__Flow__Usage_template& RX__3GPP__Flow__Usage_template::operator=(int other_value)
{
if (!RX__3GPP__Flow__Usage::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (RX__3GPP__Flow__Usage::enum_type)other_value;
return *this;
}

RX__3GPP__Flow__Usage_template& RX__3GPP__Flow__Usage_template::operator=(RX__3GPP__Flow__Usage::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

RX__3GPP__Flow__Usage_template& RX__3GPP__Flow__Usage_template::operator=(const RX__3GPP__Flow__Usage& other_value)
{
if (other_value.enum_value == RX__3GPP__Flow__Usage::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

RX__3GPP__Flow__Usage_template& RX__3GPP__Flow__Usage_template::operator=(const OPTIONAL<RX__3GPP__Flow__Usage>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (RX__3GPP__Flow__Usage::enum_type)(const RX__3GPP__Flow__Usage&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
}
return *this;
}

RX__3GPP__Flow__Usage_template& RX__3GPP__Flow__Usage_template::operator=(const RX__3GPP__Flow__Usage_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean RX__3GPP__Flow__Usage_template::match(RX__3GPP__Flow__Usage::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
}
return FALSE;
}

boolean RX__3GPP__Flow__Usage_template::match(const RX__3GPP__Flow__Usage& other_value, boolean) const
{
if (other_value.enum_value == RX__3GPP__Flow__Usage::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage with an unbound value.");
return match(other_value.enum_value);
}

RX__3GPP__Flow__Usage::enum_type RX__3GPP__Flow__Usage_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
return single_value;
}

void RX__3GPP__Flow__Usage_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new RX__3GPP__Flow__Usage_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
}
}

RX__3GPP__Flow__Usage_template& RX__3GPP__Flow__Usage_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
return value_list.list_value[list_index];
}

void RX__3GPP__Flow__Usage_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(RX__3GPP__Flow__Usage::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void RX__3GPP__Flow__Usage_template::log_match(const RX__3GPP__Flow__Usage& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void RX__3GPP__Flow__Usage_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
}
}

void RX__3GPP__Flow__Usage_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (RX__3GPP__Flow__Usage::enum_type)text_buf.pull_int().get_val();
if (!RX__3GPP__Flow__Usage::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new RX__3GPP__Flow__Usage_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
}
}

boolean RX__3GPP__Flow__Usage_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean RX__3GPP__Flow__Usage_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void RX__3GPP__Flow__Usage_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    RX__3GPP__Flow__Usage_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    RX__3GPP__Flow__Usage::enum_type enum_val = RX__3GPP__Flow__Usage::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!RX__3GPP__Flow__Usage::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.RX_3GPP_Flow_Usage.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    RX__3GPP__Flow__Usage_template* precondition = new RX__3GPP__Flow__Usage_template;
    precondition->set_param(*m_p->get_elem(0));
    RX__3GPP__Flow__Usage_template* implied_template = new RX__3GPP__Flow__Usage_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = RX__3GPP__Flow__Usage_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.RX_3GPP_Flow_Usage");
  }
  is_ifpresent = param.get_ifpresent();
}

void RX__3GPP__Flow__Usage_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.RX_3GPP_Flow_Usage");
}

PCC__3GPP__Rule__Failure__Code::PCC__3GPP__Rule__Failure__Code()
{
enum_value = UNBOUND_VALUE;
}

PCC__3GPP__Rule__Failure__Code::PCC__3GPP__Rule__Failure__Code(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

PCC__3GPP__Rule__Failure__Code::PCC__3GPP__Rule__Failure__Code(enum_type other_value)
{
enum_value = other_value;
}

PCC__3GPP__Rule__Failure__Code::PCC__3GPP__Rule__Failure__Code(const PCC__3GPP__Rule__Failure__Code& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
enum_value = other_value.enum_value;
}

PCC__3GPP__Rule__Failure__Code& PCC__3GPP__Rule__Failure__Code::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

PCC__3GPP__Rule__Failure__Code& PCC__3GPP__Rule__Failure__Code::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

PCC__3GPP__Rule__Failure__Code& PCC__3GPP__Rule__Failure__Code::operator=(const PCC__3GPP__Rule__Failure__Code& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
enum_value = other_value.enum_value;
return *this;
}

boolean PCC__3GPP__Rule__Failure__Code::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean PCC__3GPP__Rule__Failure__Code::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
return enum_value == other_value;
}

boolean PCC__3GPP__Rule__Failure__Code::operator==(const PCC__3GPP__Rule__Failure__Code& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
return enum_value == other_value.enum_value;
}

boolean PCC__3GPP__Rule__Failure__Code::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean PCC__3GPP__Rule__Failure__Code::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
return enum_value < other_value;
}

boolean PCC__3GPP__Rule__Failure__Code::operator<(const PCC__3GPP__Rule__Failure__Code& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
return enum_value < other_value.enum_value;
}

boolean PCC__3GPP__Rule__Failure__Code::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean PCC__3GPP__Rule__Failure__Code::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
return enum_value > other_value;
}

boolean PCC__3GPP__Rule__Failure__Code::operator>(const PCC__3GPP__Rule__Failure__Code& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
return enum_value > other_value.enum_value;
}

const char *PCC__3GPP__Rule__Failure__Code::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case UNKNOWN__RULE__NAME: return "UNKNOWN_RULE_NAME";
case RATING__GROUP__ERROR: return "RATING_GROUP_ERROR";
case SERVICE__IDENTIFIER__ERROR: return "SERVICE_IDENTIFIER_ERROR";
case GW__PCEF__MALFUNCTION: return "GW_PCEF_MALFUNCTION";
case RESOURCES__LIMITATION: return "RESOURCES_LIMITATION";
case MAX__NR__BEARERS__REACHED: return "MAX_NR_BEARERS_REACHED";
case UNKNOWN__BEARER__ID: return "UNKNOWN_BEARER_ID";
case MISSING__BEARER__ID: return "MISSING_BEARER_ID";
case MISSING__FLOW__DESCRIPTION: return "MISSING_FLOW_DESCRIPTION";
case RESOURCE__ALLOCATION__FAILURE: return "RESOURCE_ALLOCATION_FAILURE";
case UNSUCCESSFUL__QOS__VALIDATION: return "UNSUCCESSFUL_QOS_VALIDATION";
case INCORRECT__FLOW__INFORMATION: return "INCORRECT_FLOW_INFORMATION";
case PS__TO__CS__HANDOVER: return "PS_TO_CS_HANDOVER";
case TDF__APPLICATION__IDENTIFIER__ERROR: return "TDF_APPLICATION_IDENTIFIER_ERROR";
case NO__BEARER__BOUND: return "NO_BEARER_BOUND";
case FILTER__RESTRICTIONS: return "FILTER_RESTRICTIONS";
case AN__GW__FAILED: return "AN_GW_FAILED";
case MISSING__REDIRECT__SERVER__ADDRESS: return "MISSING_REDIRECT_SERVER_ADDRESS";
case CM__END__USER__SERVICE__DENIED: return "CM_END_USER_SERVICE_DENIED";
case CM__CREDIT__CONTROL__NOT__APPLICABLE: return "CM_CREDIT_CONTROL_NOT_APPLICABLE";
case CM__AUTHORIZATION__REJECTED: return "CM_AUTHORIZATION_REJECTED";
case CM__USER__UNKNOWN: return "CM_USER_UNKNOWN";
case CM__RATING__FAILED: return "CM_RATING_FAILED";
case ROUTING__RULE__REJECTION: return "ROUTING_RULE_REJECTION";
case UNKNOWN__ROUTING__ACCESS__INFORMATION: return "UNKNOWN_ROUTING_ACCESS_INFORMATION";
case NO__NBIFOM__SUPPORT: return "NO_NBIFOM_SUPPORT";
default:
return "<unknown>";
}
}

PCC__3GPP__Rule__Failure__Code::enum_type PCC__3GPP__Rule__Failure__Code::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "UNKNOWN_RULE_NAME")) return UNKNOWN__RULE__NAME;
if (!strcmp(str_par, "RATING_GROUP_ERROR")) return RATING__GROUP__ERROR;
if (!strcmp(str_par, "SERVICE_IDENTIFIER_ERROR")) return SERVICE__IDENTIFIER__ERROR;
if (!strcmp(str_par, "GW_PCEF_MALFUNCTION")) return GW__PCEF__MALFUNCTION;
if (!strcmp(str_par, "RESOURCES_LIMITATION")) return RESOURCES__LIMITATION;
if (!strcmp(str_par, "MAX_NR_BEARERS_REACHED")) return MAX__NR__BEARERS__REACHED;
if (!strcmp(str_par, "UNKNOWN_BEARER_ID")) return UNKNOWN__BEARER__ID;
if (!strcmp(str_par, "MISSING_BEARER_ID")) return MISSING__BEARER__ID;
if (!strcmp(str_par, "MISSING_FLOW_DESCRIPTION")) return MISSING__FLOW__DESCRIPTION;
if (!strcmp(str_par, "RESOURCE_ALLOCATION_FAILURE")) return RESOURCE__ALLOCATION__FAILURE;
if (!strcmp(str_par, "UNSUCCESSFUL_QOS_VALIDATION")) return UNSUCCESSFUL__QOS__VALIDATION;
if (!strcmp(str_par, "INCORRECT_FLOW_INFORMATION")) return INCORRECT__FLOW__INFORMATION;
if (!strcmp(str_par, "PS_TO_CS_HANDOVER")) return PS__TO__CS__HANDOVER;
if (!strcmp(str_par, "TDF_APPLICATION_IDENTIFIER_ERROR")) return TDF__APPLICATION__IDENTIFIER__ERROR;
if (!strcmp(str_par, "NO_BEARER_BOUND")) return NO__BEARER__BOUND;
if (!strcmp(str_par, "FILTER_RESTRICTIONS")) return FILTER__RESTRICTIONS;
if (!strcmp(str_par, "AN_GW_FAILED")) return AN__GW__FAILED;
if (!strcmp(str_par, "MISSING_REDIRECT_SERVER_ADDRESS")) return MISSING__REDIRECT__SERVER__ADDRESS;
if (!strcmp(str_par, "CM_END_USER_SERVICE_DENIED")) return CM__END__USER__SERVICE__DENIED;
if (!strcmp(str_par, "CM_CREDIT_CONTROL_NOT_APPLICABLE")) return CM__CREDIT__CONTROL__NOT__APPLICABLE;
if (!strcmp(str_par, "CM_AUTHORIZATION_REJECTED")) return CM__AUTHORIZATION__REJECTED;
if (!strcmp(str_par, "CM_USER_UNKNOWN")) return CM__USER__UNKNOWN;
if (!strcmp(str_par, "CM_RATING_FAILED")) return CM__RATING__FAILED;
if (!strcmp(str_par, "ROUTING_RULE_REJECTION")) return ROUTING__RULE__REJECTION;
if (!strcmp(str_par, "UNKNOWN_ROUTING_ACCESS_INFORMATION")) return UNKNOWN__ROUTING__ACCESS__INFORMATION;
if (!strcmp(str_par, "NO_NBIFOM_SUPPORT")) return NO__NBIFOM__SUPPORT;
}
return UNKNOWN_VALUE;
}

boolean PCC__3GPP__Rule__Failure__Code::is_valid_enum(int int_par)
{
switch (int_par) {
case 1:
case 2:
case 3:
case 4:
case 5:
case 6:
case 7:
case 8:
case 9:
case 10:
case 11:
case 12:
case 13:
case 14:
case 15:
case 16:
case 17:
case 18:
case 19:
case 20:
case 21:
case 22:
case 23:
case 24:
case 25:
case 26:
return TRUE;
default:
return FALSE;
}
}

int PCC__3GPP__Rule__Failure__Code::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int PCC__3GPP__Rule__Failure__Code::enum2int(const PCC__3GPP__Rule__Failure__Code& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void PCC__3GPP__Rule__Failure__Code::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.", int_val);
enum_value = (enum_type)int_val;
}

PCC__3GPP__Rule__Failure__Code::operator PCC__3GPP__Rule__Failure__Code::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
return enum_value;
}

void PCC__3GPP__Rule__Failure__Code::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void PCC__3GPP__Rule__Failure__Code::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.PCC_3GPP_Rule_Failure_Code");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
  }
}

void PCC__3GPP__Rule__Failure__Code::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
text_buf.push_int(enum_value);
}

void PCC__3GPP__Rule__Failure__Code::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.", enum_value);
}

void PCC__3GPP__Rule__Failure__Code::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PCC__3GPP__Rule__Failure__Code::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int PCC__3GPP__Rule__Failure__Code::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 5, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int PCC__3GPP__Rule__Failure__Code::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 5);
}

void PCC__3GPP__Rule__Failure__Code_template::copy_template(const PCC__3GPP__Rule__Failure__Code_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PCC__3GPP__Rule__Failure__Code_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PCC__3GPP__Rule__Failure__Code_template(*other_value.implication_.precondition);
implication_.implied_template = new PCC__3GPP__Rule__Failure__Code_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
}
}

PCC__3GPP__Rule__Failure__Code_template::PCC__3GPP__Rule__Failure__Code_template()
{
}

PCC__3GPP__Rule__Failure__Code_template::PCC__3GPP__Rule__Failure__Code_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PCC__3GPP__Rule__Failure__Code_template::PCC__3GPP__Rule__Failure__Code_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!PCC__3GPP__Rule__Failure__Code::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code with unknown numeric value %d.", other_value);
single_value = (PCC__3GPP__Rule__Failure__Code::enum_type)other_value;
}

PCC__3GPP__Rule__Failure__Code_template::PCC__3GPP__Rule__Failure__Code_template(PCC__3GPP__Rule__Failure__Code::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

PCC__3GPP__Rule__Failure__Code_template::PCC__3GPP__Rule__Failure__Code_template(const PCC__3GPP__Rule__Failure__Code& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == PCC__3GPP__Rule__Failure__Code::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
single_value = other_value.enum_value;
}

PCC__3GPP__Rule__Failure__Code_template::PCC__3GPP__Rule__Failure__Code_template(const OPTIONAL<PCC__3GPP__Rule__Failure__Code>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (PCC__3GPP__Rule__Failure__Code::enum_type)(const PCC__3GPP__Rule__Failure__Code&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code from an unbound optional field.");
}
}

PCC__3GPP__Rule__Failure__Code_template::PCC__3GPP__Rule__Failure__Code_template(PCC__3GPP__Rule__Failure__Code_template* p_precondition, PCC__3GPP__Rule__Failure__Code_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PCC__3GPP__Rule__Failure__Code_template::PCC__3GPP__Rule__Failure__Code_template(Dynamic_Match_Interface<PCC__3GPP__Rule__Failure__Code>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PCC__3GPP__Rule__Failure__Code>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PCC__3GPP__Rule__Failure__Code_template::PCC__3GPP__Rule__Failure__Code_template(const PCC__3GPP__Rule__Failure__Code_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

PCC__3GPP__Rule__Failure__Code_template::~PCC__3GPP__Rule__Failure__Code_template()
{
clean_up();
}

boolean PCC__3GPP__Rule__Failure__Code_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean PCC__3GPP__Rule__Failure__Code_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != PCC__3GPP__Rule__Failure__Code::UNBOUND_VALUE;
}

void PCC__3GPP__Rule__Failure__Code_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PCC__3GPP__Rule__Failure__Code_template& PCC__3GPP__Rule__Failure__Code_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PCC__3GPP__Rule__Failure__Code_template& PCC__3GPP__Rule__Failure__Code_template::operator=(int other_value)
{
if (!PCC__3GPP__Rule__Failure__Code::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (PCC__3GPP__Rule__Failure__Code::enum_type)other_value;
return *this;
}

PCC__3GPP__Rule__Failure__Code_template& PCC__3GPP__Rule__Failure__Code_template::operator=(PCC__3GPP__Rule__Failure__Code::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

PCC__3GPP__Rule__Failure__Code_template& PCC__3GPP__Rule__Failure__Code_template::operator=(const PCC__3GPP__Rule__Failure__Code& other_value)
{
if (other_value.enum_value == PCC__3GPP__Rule__Failure__Code::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

PCC__3GPP__Rule__Failure__Code_template& PCC__3GPP__Rule__Failure__Code_template::operator=(const OPTIONAL<PCC__3GPP__Rule__Failure__Code>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (PCC__3GPP__Rule__Failure__Code::enum_type)(const PCC__3GPP__Rule__Failure__Code&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
}
return *this;
}

PCC__3GPP__Rule__Failure__Code_template& PCC__3GPP__Rule__Failure__Code_template::operator=(const PCC__3GPP__Rule__Failure__Code_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PCC__3GPP__Rule__Failure__Code_template::match(PCC__3GPP__Rule__Failure__Code::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
}
return FALSE;
}

boolean PCC__3GPP__Rule__Failure__Code_template::match(const PCC__3GPP__Rule__Failure__Code& other_value, boolean) const
{
if (other_value.enum_value == PCC__3GPP__Rule__Failure__Code::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code with an unbound value.");
return match(other_value.enum_value);
}

PCC__3GPP__Rule__Failure__Code::enum_type PCC__3GPP__Rule__Failure__Code_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
return single_value;
}

void PCC__3GPP__Rule__Failure__Code_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PCC__3GPP__Rule__Failure__Code_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
}
}

PCC__3GPP__Rule__Failure__Code_template& PCC__3GPP__Rule__Failure__Code_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
return value_list.list_value[list_index];
}

void PCC__3GPP__Rule__Failure__Code_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(PCC__3GPP__Rule__Failure__Code::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PCC__3GPP__Rule__Failure__Code_template::log_match(const PCC__3GPP__Rule__Failure__Code& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void PCC__3GPP__Rule__Failure__Code_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
}
}

void PCC__3GPP__Rule__Failure__Code_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (PCC__3GPP__Rule__Failure__Code::enum_type)text_buf.pull_int().get_val();
if (!PCC__3GPP__Rule__Failure__Code::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PCC__3GPP__Rule__Failure__Code_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
}
}

boolean PCC__3GPP__Rule__Failure__Code_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PCC__3GPP__Rule__Failure__Code_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void PCC__3GPP__Rule__Failure__Code_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PCC__3GPP__Rule__Failure__Code_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    PCC__3GPP__Rule__Failure__Code::enum_type enum_val = PCC__3GPP__Rule__Failure__Code::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!PCC__3GPP__Rule__Failure__Code::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.PCC_3GPP_Rule_Failure_Code.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    PCC__3GPP__Rule__Failure__Code_template* precondition = new PCC__3GPP__Rule__Failure__Code_template;
    precondition->set_param(*m_p->get_elem(0));
    PCC__3GPP__Rule__Failure__Code_template* implied_template = new PCC__3GPP__Rule__Failure__Code_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = PCC__3GPP__Rule__Failure__Code_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.PCC_3GPP_Rule_Failure_Code");
  }
  is_ifpresent = param.get_ifpresent();
}

void PCC__3GPP__Rule__Failure__Code_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.PCC_3GPP_Rule_Failure_Code");
}

AAA__3GPP__Measurement__Period__LTE::AAA__3GPP__Measurement__Period__LTE()
{
enum_value = UNBOUND_VALUE;
}

AAA__3GPP__Measurement__Period__LTE::AAA__3GPP__Measurement__Period__LTE(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

AAA__3GPP__Measurement__Period__LTE::AAA__3GPP__Measurement__Period__LTE(enum_type other_value)
{
enum_value = other_value;
}

AAA__3GPP__Measurement__Period__LTE::AAA__3GPP__Measurement__Period__LTE(const AAA__3GPP__Measurement__Period__LTE& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
enum_value = other_value.enum_value;
}

AAA__3GPP__Measurement__Period__LTE& AAA__3GPP__Measurement__Period__LTE::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

AAA__3GPP__Measurement__Period__LTE& AAA__3GPP__Measurement__Period__LTE::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

AAA__3GPP__Measurement__Period__LTE& AAA__3GPP__Measurement__Period__LTE::operator=(const AAA__3GPP__Measurement__Period__LTE& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
enum_value = other_value.enum_value;
return *this;
}

boolean AAA__3GPP__Measurement__Period__LTE::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean AAA__3GPP__Measurement__Period__LTE::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
return enum_value == other_value;
}

boolean AAA__3GPP__Measurement__Period__LTE::operator==(const AAA__3GPP__Measurement__Period__LTE& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
return enum_value == other_value.enum_value;
}

boolean AAA__3GPP__Measurement__Period__LTE::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean AAA__3GPP__Measurement__Period__LTE::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
return enum_value < other_value;
}

boolean AAA__3GPP__Measurement__Period__LTE::operator<(const AAA__3GPP__Measurement__Period__LTE& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
return enum_value < other_value.enum_value;
}

boolean AAA__3GPP__Measurement__Period__LTE::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean AAA__3GPP__Measurement__Period__LTE::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
return enum_value > other_value;
}

boolean AAA__3GPP__Measurement__Period__LTE::operator>(const AAA__3GPP__Measurement__Period__LTE& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
return enum_value > other_value.enum_value;
}

const char *AAA__3GPP__Measurement__Period__LTE::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case PERIOD__1024__ms: return "PERIOD_1024_ms";
case PERIOD__1280__ms: return "PERIOD_1280_ms";
case PERIOD__2048__ms: return "PERIOD_2048_ms";
case PERIOD__2560__ms: return "PERIOD_2560_ms";
case PERIOD__5120__ms: return "PERIOD_5120_ms";
case PERIOD__10240__ms: return "PERIOD_10240_ms";
case PERIOD__1__min: return "PERIOD_1_min";
default:
return "<unknown>";
}
}

AAA__3GPP__Measurement__Period__LTE::enum_type AAA__3GPP__Measurement__Period__LTE::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "PERIOD_1024_ms")) return PERIOD__1024__ms;
if (!strcmp(str_par, "PERIOD_1280_ms")) return PERIOD__1280__ms;
if (!strcmp(str_par, "PERIOD_2048_ms")) return PERIOD__2048__ms;
if (!strcmp(str_par, "PERIOD_2560_ms")) return PERIOD__2560__ms;
if (!strcmp(str_par, "PERIOD_5120_ms")) return PERIOD__5120__ms;
if (!strcmp(str_par, "PERIOD_10240_ms")) return PERIOD__10240__ms;
if (!strcmp(str_par, "PERIOD_1_min")) return PERIOD__1__min;
}
return UNKNOWN_VALUE;
}

boolean AAA__3GPP__Measurement__Period__LTE::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
case 4:
case 5:
case 6:
return TRUE;
default:
return FALSE;
}
}

int AAA__3GPP__Measurement__Period__LTE::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int AAA__3GPP__Measurement__Period__LTE::enum2int(const AAA__3GPP__Measurement__Period__LTE& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void AAA__3GPP__Measurement__Period__LTE::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.", int_val);
enum_value = (enum_type)int_val;
}

AAA__3GPP__Measurement__Period__LTE::operator AAA__3GPP__Measurement__Period__LTE::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
return enum_value;
}

void AAA__3GPP__Measurement__Period__LTE::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void AAA__3GPP__Measurement__Period__LTE::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
  }
}

void AAA__3GPP__Measurement__Period__LTE::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
text_buf.push_int(enum_value);
}

void AAA__3GPP__Measurement__Period__LTE::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.", enum_value);
}

void AAA__3GPP__Measurement__Period__LTE::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void AAA__3GPP__Measurement__Period__LTE::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int AAA__3GPP__Measurement__Period__LTE::RAW_decode(const TTCN_Typedescriptor_t& p_td,TTCN_Buffer& p_buf,int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit*)
{
  int decoded_value = 0;
  int decoded_length = RAW_decode_enum_type(p_td, p_buf, limit, top_bit_ord, decoded_value, 3, no_err);
  if (decoded_length < 0) return decoded_length;
  if (is_valid_enum(decoded_value)) enum_value = (enum_type)decoded_value;
  else {
    if(no_err){
     return -1;
    } else {
    TTCN_EncDec_ErrorContext::error
      (TTCN_EncDec::ET_ENC_ENUM, "Invalid enum value '%d' for '%s': ",decoded_value, p_td.name);
    enum_value = UNKNOWN_VALUE;
    }
  }
  return decoded_length;
}

int AAA__3GPP__Measurement__Period__LTE::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& myleaf) const
{
  return RAW_encode_enum_type(p_td, myleaf, (int)enum_value, 3);
}

void AAA__3GPP__Measurement__Period__LTE_template::copy_template(const AAA__3GPP__Measurement__Period__LTE_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new AAA__3GPP__Measurement__Period__LTE_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new AAA__3GPP__Measurement__Period__LTE_template(*other_value.implication_.precondition);
implication_.implied_template = new AAA__3GPP__Measurement__Period__LTE_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
}
}

AAA__3GPP__Measurement__Period__LTE_template::AAA__3GPP__Measurement__Period__LTE_template()
{
}

AAA__3GPP__Measurement__Period__LTE_template::AAA__3GPP__Measurement__Period__LTE_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

AAA__3GPP__Measurement__Period__LTE_template::AAA__3GPP__Measurement__Period__LTE_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!AAA__3GPP__Measurement__Period__LTE::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE with unknown numeric value %d.", other_value);
single_value = (AAA__3GPP__Measurement__Period__LTE::enum_type)other_value;
}

AAA__3GPP__Measurement__Period__LTE_template::AAA__3GPP__Measurement__Period__LTE_template(AAA__3GPP__Measurement__Period__LTE::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

AAA__3GPP__Measurement__Period__LTE_template::AAA__3GPP__Measurement__Period__LTE_template(const AAA__3GPP__Measurement__Period__LTE& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == AAA__3GPP__Measurement__Period__LTE::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
single_value = other_value.enum_value;
}

AAA__3GPP__Measurement__Period__LTE_template::AAA__3GPP__Measurement__Period__LTE_template(const OPTIONAL<AAA__3GPP__Measurement__Period__LTE>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (AAA__3GPP__Measurement__Period__LTE::enum_type)(const AAA__3GPP__Measurement__Period__LTE&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE from an unbound optional field.");
}
}

AAA__3GPP__Measurement__Period__LTE_template::AAA__3GPP__Measurement__Period__LTE_template(AAA__3GPP__Measurement__Period__LTE_template* p_precondition, AAA__3GPP__Measurement__Period__LTE_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

AAA__3GPP__Measurement__Period__LTE_template::AAA__3GPP__Measurement__Period__LTE_template(Dynamic_Match_Interface<AAA__3GPP__Measurement__Period__LTE>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<AAA__3GPP__Measurement__Period__LTE>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

AAA__3GPP__Measurement__Period__LTE_template::AAA__3GPP__Measurement__Period__LTE_template(const AAA__3GPP__Measurement__Period__LTE_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

AAA__3GPP__Measurement__Period__LTE_template::~AAA__3GPP__Measurement__Period__LTE_template()
{
clean_up();
}

boolean AAA__3GPP__Measurement__Period__LTE_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean AAA__3GPP__Measurement__Period__LTE_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != AAA__3GPP__Measurement__Period__LTE::UNBOUND_VALUE;
}

void AAA__3GPP__Measurement__Period__LTE_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

AAA__3GPP__Measurement__Period__LTE_template& AAA__3GPP__Measurement__Period__LTE_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

AAA__3GPP__Measurement__Period__LTE_template& AAA__3GPP__Measurement__Period__LTE_template::operator=(int other_value)
{
if (!AAA__3GPP__Measurement__Period__LTE::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (AAA__3GPP__Measurement__Period__LTE::enum_type)other_value;
return *this;
}

AAA__3GPP__Measurement__Period__LTE_template& AAA__3GPP__Measurement__Period__LTE_template::operator=(AAA__3GPP__Measurement__Period__LTE::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

AAA__3GPP__Measurement__Period__LTE_template& AAA__3GPP__Measurement__Period__LTE_template::operator=(const AAA__3GPP__Measurement__Period__LTE& other_value)
{
if (other_value.enum_value == AAA__3GPP__Measurement__Period__LTE::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

AAA__3GPP__Measurement__Period__LTE_template& AAA__3GPP__Measurement__Period__LTE_template::operator=(const OPTIONAL<AAA__3GPP__Measurement__Period__LTE>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (AAA__3GPP__Measurement__Period__LTE::enum_type)(const AAA__3GPP__Measurement__Period__LTE&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
}
return *this;
}

AAA__3GPP__Measurement__Period__LTE_template& AAA__3GPP__Measurement__Period__LTE_template::operator=(const AAA__3GPP__Measurement__Period__LTE_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean AAA__3GPP__Measurement__Period__LTE_template::match(AAA__3GPP__Measurement__Period__LTE::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
}
return FALSE;
}

boolean AAA__3GPP__Measurement__Period__LTE_template::match(const AAA__3GPP__Measurement__Period__LTE& other_value, boolean) const
{
if (other_value.enum_value == AAA__3GPP__Measurement__Period__LTE::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE with an unbound value.");
return match(other_value.enum_value);
}

AAA__3GPP__Measurement__Period__LTE::enum_type AAA__3GPP__Measurement__Period__LTE_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
return single_value;
}

void AAA__3GPP__Measurement__Period__LTE_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new AAA__3GPP__Measurement__Period__LTE_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
}
}

AAA__3GPP__Measurement__Period__LTE_template& AAA__3GPP__Measurement__Period__LTE_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
return value_list.list_value[list_index];
}

void AAA__3GPP__Measurement__Period__LTE_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(AAA__3GPP__Measurement__Period__LTE::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void AAA__3GPP__Measurement__Period__LTE_template::log_match(const AAA__3GPP__Measurement__Period__LTE& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void AAA__3GPP__Measurement__Period__LTE_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
}
}

void AAA__3GPP__Measurement__Period__LTE_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (AAA__3GPP__Measurement__Period__LTE::enum_type)text_buf.pull_int().get_val();
if (!AAA__3GPP__Measurement__Period__LTE::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new AAA__3GPP__Measurement__Period__LTE_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
}
}

boolean AAA__3GPP__Measurement__Period__LTE_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean AAA__3GPP__Measurement__Period__LTE_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void AAA__3GPP__Measurement__Period__LTE_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    AAA__3GPP__Measurement__Period__LTE_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    AAA__3GPP__Measurement__Period__LTE::enum_type enum_val = AAA__3GPP__Measurement__Period__LTE::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!AAA__3GPP__Measurement__Period__LTE::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    AAA__3GPP__Measurement__Period__LTE_template* precondition = new AAA__3GPP__Measurement__Period__LTE_template;
    precondition->set_param(*m_p->get_elem(0));
    AAA__3GPP__Measurement__Period__LTE_template* implied_template = new AAA__3GPP__Measurement__Period__LTE_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = AAA__3GPP__Measurement__Period__LTE_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE");
  }
  is_ifpresent = param.get_ifpresent();
}

void AAA__3GPP__Measurement__Period__LTE_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@DIAMETER_Types.AAA_3GPP_Measurement_Period_LTE");
}

CxDx__3GPP__Session__Priority::CxDx__3GPP__Session__Priority()
{
enum_value = UNBOUND_VALUE;
}

CxDx__3GPP__Session__Priority::CxDx__3GPP__Session__Priority(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @DIAMETER_Types.CxDx_3GPP_Session_Priority with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

CxDx__3GPP__Session__Priority::CxDx__3GPP__Session__Priority(enum_type other_value)
{
enum_value = other_value;
}

CxDx__3GPP__Session__Priority::CxDx__3GPP__Session__Priority(const CxDx__3GPP__Session__Priority& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_Session_Priority.");
enum_value = other_value.enum_value;
}

CxDx__3GPP__Session__Priority& CxDx__3GPP__Session__Priority::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @DIAMETER_Types.CxDx_3GPP_Session_Priority.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

CxDx__3GPP__Session__Priority& CxDx__3GPP__Session__Priority::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

CxDx__3GPP__Session__Priority& CxDx__3GPP__Session__Priority::operator=(const CxDx__3GPP__Session__Priority& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_Session_Priority.");
enum_value = other_value.enum_value;
return *this;
}

boolean CxDx__3GPP__Session__Priority::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_Session_Priority.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.CxDx_3GPP_Session_Priority comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean CxDx__3GPP__Session__Priority::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_Session_Priority.");
return enum_value == other_value;
}

boolean CxDx__3GPP__Session__Priority::operator==(const CxDx__3GPP__Session__Priority& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_Session_Priority.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_Session_Priority.");
return enum_value == other_value.enum_value;
}

boolean CxDx__3GPP__Session__Priority::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_Session_Priority.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.CxDx_3GPP_Session_Priority comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean CxDx__3GPP__Session__Priority::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_Session_Priority.");
return enum_value < other_value;
}

boolean CxDx__3GPP__Session__Priority::operator<(const CxDx__3GPP__Session__Priority& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_Session_Priority.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_Session_Priority.");
return enum_value < other_value.enum_value;
}

boolean CxDx__3GPP__Session__Priority::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_Session_Priority.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @DIAMETER_Types.CxDx_3GPP_Session_Priority comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean CxDx__3GPP__Session__Priority::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_Session_Priority.");
return enum_value > other_value;
}

boolean CxDx__3GPP__Session__Priority::operator>(const CxDx__3GPP__Session__Priority& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_Session_Priority.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @DIAMETER_Types.CxDx_3GPP_Session_Priority.");
return enum_value > other_value.enum_value;
}

const char *CxDx__3GPP__Session__Priority::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case PRIORITY__0: return "PRIORITY_0";
case PRIORITY__1: return "PRIORITY_1";
case PRIORITY__2: return "PRIORITY_2";
case PRIORITY__3: return "PRIORITY_3";
case PRIORITY__4: return "PRIORITY_4";
default:
return "<unknown>";
}
}

CxDx__3GPP__Session__Priority::enum_type CxDx__3GPP__Session__Priority::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "PRIORITY_0")) return PRIORITY__0;
if (!strcmp(str_par, "PRIORITY_1")) return PRIORITY__1;
if (!strcmp(str_par, "PRIORITY_2")) return PRIORITY__2;
if (!strcmp(str_par, "PRIORITY_3")) return PRIORITY__3;
if (!strcmp(str_par, "PRIORITY_4")) return PRIORITY__4;
}
return UNKNOWN_VALUE;
}

boolean CxDx__3GPP__Session__Priority::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
case 4:
return TRUE;
default:
return FALSE;
}
}

int CxDx__3GPP__Session__Priority::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.CxDx_3GPP_Session_Priority.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int CxDx__3GPP__Session__Priority::enum2int(const CxDx__3GPP__Session__Priority& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @DIAMETER_Types.CxDx_3GPP_Session_Priority.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void CxDx__3GPP__Session__Priority::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning 