// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "GTPC_Types.hh"

namespace GTPC__Types {

/* Member functions of C++ classes */

EchoRequest::EchoRequest()
{
}

EchoRequest::EchoRequest(const OPTIONAL< PrivateExtension__gtpc__List >& par_private__extension__gtpc)
  :   field_private__extension__gtpc(par_private__extension__gtpc)
{
}

EchoRequest::EchoRequest(const EchoRequest& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.EchoRequest.");
if (other_value.private__extension__gtpc().is_bound()) field_private__extension__gtpc = other_value.private__extension__gtpc();
else field_private__extension__gtpc.clean_up();
}

void EchoRequest::clean_up()
{
field_private__extension__gtpc.clean_up();
}

const TTCN_Typedescriptor_t* EchoRequest::get_descriptor() const { return &EchoRequest_descr_; }
EchoRequest& EchoRequest::operator=(const EchoRequest& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.EchoRequest.");
  if (other_value.private__extension__gtpc().is_bound()) field_private__extension__gtpc = other_value.private__extension__gtpc();
  else field_private__extension__gtpc.clean_up();
}
return *this;
}

boolean EchoRequest::operator==(const EchoRequest& other_value) const
{
return field_private__extension__gtpc==other_value.field_private__extension__gtpc;
}

boolean EchoRequest::is_bound() const
{
return (OPTIONAL_OMIT == field_private__extension__gtpc.get_selection() || field_private__extension__gtpc.is_bound());
}
boolean EchoRequest::is_value() const
{
return (OPTIONAL_OMIT == field_private__extension__gtpc.get_selection() || field_private__extension__gtpc.is_value());
}
int EchoRequest::size_of() const
{
  int ret_val = 0;
  if (field_private__extension__gtpc.ispresent()) ret_val++;
  return ret_val;
}

void EchoRequest::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ private_extension_gtpc := ");
field_private__extension__gtpc.log();
TTCN_Logger::log_event_str(" }");
}

void EchoRequest::set_implicit_omit()
{
if (!private__extension__gtpc().is_bound()) private__extension__gtpc() = OMIT_VALUE;
else private__extension__gtpc().set_implicit_omit();
}

void EchoRequest::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @GTPC_Types.EchoRequest has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) private__extension__gtpc().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "private_extension_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          private__extension__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.EchoRequest: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.EchoRequest");
  }
}

void EchoRequest::encode_text(Text_Buf& text_buf) const
{
field_private__extension__gtpc.encode_text(text_buf);
}

void EchoRequest::decode_text(Text_Buf& text_buf)
{
field_private__extension__gtpc.decode_text(text_buf);
}

void EchoRequest::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void EchoRequest::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int EchoRequest::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(0)) {
    field_private__extension__gtpc = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_0_force_omit(0, force_omit, PrivateExtension__gtpc__List_descr_.raw->forceomit);
  decoded_field_length = field_private__extension__gtpc().RAW_decode(PrivateExtension__gtpc__List_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 1) {
  field_private__extension__gtpc = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_private__extension__gtpc=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int EchoRequest::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 1;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(1);
  if (field_private__extension__gtpc.ispresent()) {
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, PrivateExtension__gtpc__List_descr_.raw);
  }
  else myleaf.body.node.nodes[0] = NULL;
  if (field_private__extension__gtpc.ispresent()) {
  encoded_length += field_private__extension__gtpc().RAW_encode(PrivateExtension__gtpc__List_descr_, *myleaf.body.node.nodes[0]);
  }
  return myleaf.length = encoded_length;
}

struct EchoRequest_template::single_value_struct {
PrivateExtension__gtpc__List_template field_private__extension__gtpc;
};

void EchoRequest_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_private__extension__gtpc = ANY_OR_OMIT;
}
}
}

void EchoRequest_template::copy_value(const EchoRequest& other_value)
{
single_value = new single_value_struct;
if (other_value.private__extension__gtpc().is_bound()) {
  if (other_value.private__extension__gtpc().ispresent()) single_value->field_private__extension__gtpc = other_value.private__extension__gtpc()();
  else single_value->field_private__extension__gtpc = OMIT_VALUE;
} else {
  single_value->field_private__extension__gtpc.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void EchoRequest_template::copy_template(const EchoRequest_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.private__extension__gtpc().get_selection()) {
single_value->field_private__extension__gtpc = other_value.private__extension__gtpc();
} else {
single_value->field_private__extension__gtpc.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new EchoRequest_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new EchoRequest_template(*other_value.implication_.precondition);
implication_.implied_template = new EchoRequest_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.EchoRequest.");
break;
}
set_selection(other_value);
}

EchoRequest_template::EchoRequest_template()
{
}

EchoRequest_template::EchoRequest_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

EchoRequest_template::EchoRequest_template(const EchoRequest& other_value)
{
copy_value(other_value);
}

EchoRequest_template::EchoRequest_template(const OPTIONAL<EchoRequest>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EchoRequest&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.EchoRequest from an unbound optional field.");
}
}

EchoRequest_template::EchoRequest_template(EchoRequest_template* p_precondition, EchoRequest_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

EchoRequest_template::EchoRequest_template(Dynamic_Match_Interface<EchoRequest>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<EchoRequest>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

EchoRequest_template::EchoRequest_template(const EchoRequest_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

EchoRequest_template::~EchoRequest_template()
{
clean_up();
}

EchoRequest_template& EchoRequest_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

EchoRequest_template& EchoRequest_template::operator=(const EchoRequest& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

EchoRequest_template& EchoRequest_template::operator=(const OPTIONAL<EchoRequest>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EchoRequest&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.EchoRequest.");
}
return *this;
}

EchoRequest_template& EchoRequest_template::operator=(const EchoRequest_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean EchoRequest_template::match(const EchoRequest& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.private__extension__gtpc().is_bound()) return FALSE;
if((other_value.private__extension__gtpc().ispresent() ? !single_value->field_private__extension__gtpc.match((const PrivateExtension__gtpc__List&)other_value.private__extension__gtpc(), legacy) : !single_value->field_private__extension__gtpc.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.EchoRequest.");
}
return FALSE;
}

boolean EchoRequest_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_private__extension__gtpc.is_omit() || single_value->field_private__extension__gtpc.is_bound());
}

boolean EchoRequest_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_private__extension__gtpc.is_omit() || single_value->field_private__extension__gtpc.is_value());
}

void EchoRequest_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

EchoRequest EchoRequest_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.EchoRequest.");
EchoRequest ret_val;
if (single_value->field_private__extension__gtpc.is_omit()) ret_val.private__extension__gtpc() = OMIT_VALUE;
else if (single_value->field_private__extension__gtpc.is_bound()) {
ret_val.private__extension__gtpc() = single_value->field_private__extension__gtpc.valueof();
}
return ret_val;
}

void EchoRequest_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.EchoRequest.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new EchoRequest_template[list_length];
}

EchoRequest_template& EchoRequest_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.EchoRequest.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.EchoRequest.");
return value_list.list_value[list_index];
}

PrivateExtension__gtpc__List_template& EchoRequest_template::private__extension__gtpc()
{
set_specific();
return single_value->field_private__extension__gtpc;
}

const PrivateExtension__gtpc__List_template& EchoRequest_template::private__extension__gtpc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field private_extension_gtpc of a non-specific template of type @GTPC_Types.EchoRequest.");
return single_value->field_private__extension__gtpc;
}

int EchoRequest_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.EchoRequest which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 0;
      if (single_value->field_private__extension__gtpc.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.EchoRequest containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.EchoRequest containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.EchoRequest containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.EchoRequest containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.EchoRequest containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.EchoRequest containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.EchoRequest containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.EchoRequest containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.EchoRequest.");
  }
  return 0;
}

void EchoRequest_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ private_extension_gtpc := ");
single_value->field_private__extension__gtpc.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void EchoRequest_template::log_match(const EchoRequest& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.private__extension__gtpc().ispresent()){
if(!single_value->field_private__extension__gtpc.match(match_value.private__extension__gtpc(), legacy)){
TTCN_Logger::log_logmatch_info(".private_extension_gtpc");
single_value->field_private__extension__gtpc.log_match(match_value.private__extension__gtpc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_private__extension__gtpc.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".private_extension_gtpc := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_private__extension__gtpc.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ private_extension_gtpc := ");
if (match_value.private__extension__gtpc().ispresent()) {
single_value->field_private__extension__gtpc.log_match(match_value.private__extension__gtpc(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_private__extension__gtpc.log();
if (single_value->field_private__extension__gtpc.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void EchoRequest_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!private__extension__gtpc().is_bound()) private__extension__gtpc() = OMIT_VALUE;
else private__extension__gtpc().set_implicit_omit();
}

void EchoRequest_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_private__extension__gtpc.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.EchoRequest.");
}
}

void EchoRequest_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_private__extension__gtpc.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new EchoRequest_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.EchoRequest.");
}
}

void EchoRequest_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    EchoRequest_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @GTPC_Types.EchoRequest has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) private__extension__gtpc().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "private_extension_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          private__extension__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.EchoRequest: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    EchoRequest_template* precondition = new EchoRequest_template;
    precondition->set_param(*param.get_elem(0));
    EchoRequest_template* implied_template = new EchoRequest_template;
    implied_template->set_param(*param.get_elem(1));
    *this = EchoRequest_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.EchoRequest");
  }
  is_ifpresent = param.get_ifpresent();
}

void EchoRequest_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_private__extension__gtpc.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.EchoRequest");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.EchoRequest");
}

boolean EchoRequest_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean EchoRequest_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

EchoResponse::EchoResponse()
{
}

EchoResponse::EchoResponse(const Recovery__gtpc& par_recovery,
    const OPTIONAL< PrivateExtension__gtpc__List >& par_private__extension__gtpc)
  :   field_recovery(par_recovery),
  field_private__extension__gtpc(par_private__extension__gtpc)
{
}

EchoResponse::EchoResponse(const EchoResponse& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.EchoResponse.");
if (other_value.recovery().is_bound()) field_recovery = other_value.recovery();
else field_recovery.clean_up();
if (other_value.private__extension__gtpc().is_bound()) field_private__extension__gtpc = other_value.private__extension__gtpc();
else field_private__extension__gtpc.clean_up();
}

void EchoResponse::clean_up()
{
field_recovery.clean_up();
field_private__extension__gtpc.clean_up();
}

const TTCN_Typedescriptor_t* EchoResponse::get_descriptor() const { return &EchoResponse_descr_; }
EchoResponse& EchoResponse::operator=(const EchoResponse& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.EchoResponse.");
  if (other_value.recovery().is_bound()) field_recovery = other_value.recovery();
  else field_recovery.clean_up();
  if (other_value.private__extension__gtpc().is_bound()) field_private__extension__gtpc = other_value.private__extension__gtpc();
  else field_private__extension__gtpc.clean_up();
}
return *this;
}

boolean EchoResponse::operator==(const EchoResponse& other_value) const
{
return field_recovery==other_value.field_recovery
  && field_private__extension__gtpc==other_value.field_private__extension__gtpc;
}

boolean EchoResponse::is_bound() const
{
return (field_recovery.is_bound())
  || (OPTIONAL_OMIT == field_private__extension__gtpc.get_selection() || field_private__extension__gtpc.is_bound());
}
boolean EchoResponse::is_value() const
{
return field_recovery.is_value()
  && (OPTIONAL_OMIT == field_private__extension__gtpc.get_selection() || field_private__extension__gtpc.is_value());
}
int EchoResponse::size_of() const
{
  int ret_val = 1;
  if (field_private__extension__gtpc.ispresent()) ret_val++;
  return ret_val;
}

void EchoResponse::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ recovery := ");
field_recovery.log();
TTCN_Logger::log_event_str(", private_extension_gtpc := ");
field_private__extension__gtpc.log();
TTCN_Logger::log_event_str(" }");
}

void EchoResponse::set_implicit_omit()
{
if (recovery().is_bound()) recovery().set_implicit_omit();
if (!private__extension__gtpc().is_bound()) private__extension__gtpc() = OMIT_VALUE;
else private__extension__gtpc().set_implicit_omit();
}

void EchoResponse::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @GTPC_Types.EchoResponse has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) recovery().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) private__extension__gtpc().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "recovery")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          recovery().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "private_extension_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          private__extension__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.EchoResponse: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.EchoResponse");
  }
}

void EchoResponse::encode_text(Text_Buf& text_buf) const
{
field_recovery.encode_text(text_buf);
field_private__extension__gtpc.encode_text(text_buf);
}

void EchoResponse::decode_text(Text_Buf& text_buf)
{
field_recovery.decode_text(text_buf);
field_private__extension__gtpc.decode_text(text_buf);
}

void EchoResponse::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void EchoResponse::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int EchoResponse::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, Recovery__gtpc_descr_.raw->forceomit);
  decoded_field_length = field_recovery.RAW_decode(Recovery__gtpc_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_private__extension__gtpc = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, PrivateExtension__gtpc__List_descr_.raw->forceomit);
  decoded_field_length = field_private__extension__gtpc().RAW_decode(PrivateExtension__gtpc__List_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_private__extension__gtpc = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_private__extension__gtpc=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int EchoResponse::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 2;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(2);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, Recovery__gtpc_descr_.raw);
  if (field_private__extension__gtpc.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, PrivateExtension__gtpc__List_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  encoded_length += field_recovery.RAW_encode(Recovery__gtpc_descr_, *myleaf.body.node.nodes[0]);
  if (field_private__extension__gtpc.ispresent()) {
  encoded_length += field_private__extension__gtpc().RAW_encode(PrivateExtension__gtpc__List_descr_, *myleaf.body.node.nodes[1]);
  }
  return myleaf.length = encoded_length;
}

struct EchoResponse_template::single_value_struct {
Recovery__gtpc_template field_recovery;
PrivateExtension__gtpc__List_template field_private__extension__gtpc;
};

void EchoResponse_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_recovery = ANY_VALUE;
single_value->field_private__extension__gtpc = ANY_OR_OMIT;
}
}
}

void EchoResponse_template::copy_value(const EchoResponse& other_value)
{
single_value = new single_value_struct;
if (other_value.recovery().is_bound()) {
  single_value->field_recovery = other_value.recovery();
} else {
  single_value->field_recovery.clean_up();
}
if (other_value.private__extension__gtpc().is_bound()) {
  if (other_value.private__extension__gtpc().ispresent()) single_value->field_private__extension__gtpc = other_value.private__extension__gtpc()();
  else single_value->field_private__extension__gtpc = OMIT_VALUE;
} else {
  single_value->field_private__extension__gtpc.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void EchoResponse_template::copy_template(const EchoResponse_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.recovery().get_selection()) {
single_value->field_recovery = other_value.recovery();
} else {
single_value->field_recovery.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.private__extension__gtpc().get_selection()) {
single_value->field_private__extension__gtpc = other_value.private__extension__gtpc();
} else {
single_value->field_private__extension__gtpc.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new EchoResponse_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new EchoResponse_template(*other_value.implication_.precondition);
implication_.implied_template = new EchoResponse_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.EchoResponse.");
break;
}
set_selection(other_value);
}

EchoResponse_template::EchoResponse_template()
{
}

EchoResponse_template::EchoResponse_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

EchoResponse_template::EchoResponse_template(const EchoResponse& other_value)
{
copy_value(other_value);
}

EchoResponse_template::EchoResponse_template(const OPTIONAL<EchoResponse>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EchoResponse&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.EchoResponse from an unbound optional field.");
}
}

EchoResponse_template::EchoResponse_template(EchoResponse_template* p_precondition, EchoResponse_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

EchoResponse_template::EchoResponse_template(Dynamic_Match_Interface<EchoResponse>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<EchoResponse>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

EchoResponse_template::EchoResponse_template(const EchoResponse_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

EchoResponse_template::~EchoResponse_template()
{
clean_up();
}

EchoResponse_template& EchoResponse_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

EchoResponse_template& EchoResponse_template::operator=(const EchoResponse& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

EchoResponse_template& EchoResponse_template::operator=(const OPTIONAL<EchoResponse>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EchoResponse&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.EchoResponse.");
}
return *this;
}

EchoResponse_template& EchoResponse_template::operator=(const EchoResponse_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean EchoResponse_template::match(const EchoResponse& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.recovery().is_bound()) return FALSE;
if(!single_value->field_recovery.match(other_value.recovery(), legacy))return FALSE;
if(!other_value.private__extension__gtpc().is_bound()) return FALSE;
if((other_value.private__extension__gtpc().ispresent() ? !single_value->field_private__extension__gtpc.match((const PrivateExtension__gtpc__List&)other_value.private__extension__gtpc(), legacy) : !single_value->field_private__extension__gtpc.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.EchoResponse.");
}
return FALSE;
}

boolean EchoResponse_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_recovery.is_bound()
 || (single_value->field_private__extension__gtpc.is_omit() || single_value->field_private__extension__gtpc.is_bound());
}

boolean EchoResponse_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_recovery.is_value()
 && (single_value->field_private__extension__gtpc.is_omit() || single_value->field_private__extension__gtpc.is_value());
}

void EchoResponse_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

EchoResponse EchoResponse_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.EchoResponse.");
EchoResponse ret_val;
if (single_value->field_recovery.is_bound()) {
ret_val.recovery() = single_value->field_recovery.valueof();
}
if (single_value->field_private__extension__gtpc.is_omit()) ret_val.private__extension__gtpc() = OMIT_VALUE;
else if (single_value->field_private__extension__gtpc.is_bound()) {
ret_val.private__extension__gtpc() = single_value->field_private__extension__gtpc.valueof();
}
return ret_val;
}

void EchoResponse_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.EchoResponse.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new EchoResponse_template[list_length];
}

EchoResponse_template& EchoResponse_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.EchoResponse.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.EchoResponse.");
return value_list.list_value[list_index];
}

Recovery__gtpc_template& EchoResponse_template::recovery()
{
set_specific();
return single_value->field_recovery;
}

const Recovery__gtpc_template& EchoResponse_template::recovery() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field recovery of a non-specific template of type @GTPC_Types.EchoResponse.");
return single_value->field_recovery;
}

PrivateExtension__gtpc__List_template& EchoResponse_template::private__extension__gtpc()
{
set_specific();
return single_value->field_private__extension__gtpc;
}

const PrivateExtension__gtpc__List_template& EchoResponse_template::private__extension__gtpc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field private_extension_gtpc of a non-specific template of type @GTPC_Types.EchoResponse.");
return single_value->field_private__extension__gtpc;
}

int EchoResponse_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.EchoResponse which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_private__extension__gtpc.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.EchoResponse containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.EchoResponse containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.EchoResponse containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.EchoResponse containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.EchoResponse containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.EchoResponse containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.EchoResponse containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.EchoResponse containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.EchoResponse.");
  }
  return 0;
}

void EchoResponse_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ recovery := ");
single_value->field_recovery.log();
TTCN_Logger::log_event_str(", private_extension_gtpc := ");
single_value->field_private__extension__gtpc.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void EchoResponse_template::log_match(const EchoResponse& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_recovery.match(match_value.recovery(), legacy)){
TTCN_Logger::log_logmatch_info(".recovery");
single_value->field_recovery.log_match(match_value.recovery(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.private__extension__gtpc().ispresent()){
if(!single_value->field_private__extension__gtpc.match(match_value.private__extension__gtpc(), legacy)){
TTCN_Logger::log_logmatch_info(".private_extension_gtpc");
single_value->field_private__extension__gtpc.log_match(match_value.private__extension__gtpc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_private__extension__gtpc.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".private_extension_gtpc := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_private__extension__gtpc.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ recovery := ");
single_value->field_recovery.log_match(match_value.recovery(), legacy);
TTCN_Logger::log_event_str(", private_extension_gtpc := ");
if (match_value.private__extension__gtpc().ispresent()) {
single_value->field_private__extension__gtpc.log_match(match_value.private__extension__gtpc(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_private__extension__gtpc.log();
if (single_value->field_private__extension__gtpc.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void EchoResponse_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (recovery().is_bound()) recovery().set_implicit_omit();
if (!private__extension__gtpc().is_bound()) private__extension__gtpc() = OMIT_VALUE;
else private__extension__gtpc().set_implicit_omit();
}

void EchoResponse_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_recovery.encode_text(text_buf);
single_value->field_private__extension__gtpc.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.EchoResponse.");
}
}

void EchoResponse_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_recovery.decode_text(text_buf);
single_value->field_private__extension__gtpc.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new EchoResponse_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.EchoResponse.");
}
}

void EchoResponse_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    EchoResponse_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @GTPC_Types.EchoResponse has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) recovery().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) private__extension__gtpc().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "recovery")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          recovery().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "private_extension_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          private__extension__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.EchoResponse: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    EchoResponse_template* precondition = new EchoResponse_template;
    precondition->set_param(*param.get_elem(0));
    EchoResponse_template* implied_template = new EchoResponse_template;
    implied_template->set_param(*param.get_elem(1));
    *this = EchoResponse_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.EchoResponse");
  }
  is_ifpresent = param.get_ifpresent();
}

void EchoResponse_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_recovery.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.EchoResponse");
single_value->field_private__extension__gtpc.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.EchoResponse");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.EchoResponse");
}

boolean EchoResponse_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean EchoResponse_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

VersionNotSupported::VersionNotSupported()
{
bound_flag = FALSE;
}

VersionNotSupported::VersionNotSupported(null_type)
{
bound_flag = TRUE;
}

VersionNotSupported::VersionNotSupported(const VersionNotSupported& other_value)
{
other_value.must_bound("Copying an unbound value of type @GTPC_Types.VersionNotSupported.");
bound_flag = TRUE;
}

VersionNotSupported& VersionNotSupported::operator=(null_type)
{
bound_flag = TRUE;
return *this;
}

VersionNotSupported& VersionNotSupported::operator=(const VersionNotSupported& other_value)
{
other_value.must_bound("Assignment of an unbound value of type @GTPC_Types.VersionNotSupported.");
bound_flag = TRUE;
return *this;
}

boolean VersionNotSupported::operator==(null_type) const
{
must_bound("Comparison of an unbound value of type @GTPC_Types.VersionNotSupported.");
return TRUE;
}

boolean VersionNotSupported::operator==(const VersionNotSupported& other_value) const
{
must_bound("Comparison of an unbound value of type @GTPC_Types.VersionNotSupported.");
other_value.must_bound("Comparison of an unbound value of type @GTPC_Types.VersionNotSupported.");
return TRUE;
}

void VersionNotSupported::log() const
{
if (bound_flag) TTCN_Logger::log_event_str("{ }");
else TTCN_Logger::log_event_unbound();
}

void VersionNotSupported::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "empty record/set value (i.e. { })");
  if (param.get_type()!=Module_Param::MP_Value_List || param.get_size()>0) {
    param.type_error("empty record/set value (i.e. { })", "@GTPC_Types.VersionNotSupported");
  }
  bound_flag = TRUE;
}

void VersionNotSupported::encode_text(Text_Buf& /*text_buf*/) const
{
must_bound("Text encoder: Encoding an unbound value of type @GTPC_Types.VersionNotSupported.");
}

void VersionNotSupported::decode_text(Text_Buf& /*text_buf*/)
{
bound_flag = TRUE;
}

void VersionNotSupported::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void VersionNotSupported::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int VersionNotSupported::RAW_encode(const TTCN_Typedescriptor_t& p_td, RAW_enc_tree& /*myleaf*/) const
{
if (!bound_flag) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value of type %s.", p_td.name);
return 0;
}

int VersionNotSupported::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int, raw_order_t, boolean, int, boolean, const RAW_Force_Omit*)
{
bound_flag = TRUE;
return p_buf.increase_pos_padd(p_td.raw->prepadding) + p_buf.increase_pos_padd(p_td.raw->padding);
}

void VersionNotSupported_template::copy_template(const VersionNotSupported_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
case SPECIFIC_VALUE:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new VersionNotSupported_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new VersionNotSupported_template(*other_value.implication_.precondition);
implication_.implied_template = new VersionNotSupported_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.VersionNotSupported.");
break;
}
}

VersionNotSupported_template::VersionNotSupported_template()
{
}

VersionNotSupported_template::VersionNotSupported_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

VersionNotSupported_template::VersionNotSupported_template(null_type)
 : Base_Template(SPECIFIC_VALUE)
{
}

VersionNotSupported_template::VersionNotSupported_template(const VersionNotSupported& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
other_value.must_bound("Creating a template from an unbound value of type @GTPC_Types.VersionNotSupported.");
}

VersionNotSupported_template::VersionNotSupported_template(const OPTIONAL<VersionNotSupported>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.VersionNotSupported from an unbound optional field.");
}
}

VersionNotSupported_template::VersionNotSupported_template(VersionNotSupported_template* p_precondition, VersionNotSupported_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

VersionNotSupported_template::VersionNotSupported_template(Dynamic_Match_Interface<VersionNotSupported>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<VersionNotSupported>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

VersionNotSupported_template::VersionNotSupported_template(const VersionNotSupported_template& other_value)
: Base_Template(){
copy_template(other_value);
}

VersionNotSupported_template::~VersionNotSupported_template()
{
clean_up();
}

void VersionNotSupported_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

VersionNotSupported_template& VersionNotSupported_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

VersionNotSupported_template& VersionNotSupported_template::operator=(null_type)
{
clean_up();
set_selection(SPECIFIC_VALUE);
return *this;
}

VersionNotSupported_template& VersionNotSupported_template::operator=(const VersionNotSupported& other_value)
{
other_value.must_bound("Assignment of an unbound value of type @GTPC_Types.VersionNotSupported to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
return *this;
}

VersionNotSupported_template& VersionNotSupported_template::operator=(const OPTIONAL<VersionNotSupported>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.VersionNotSupported.");
}
return *this;
}

VersionNotSupported_template& VersionNotSupported_template::operator=(const VersionNotSupported_template& other_value)
{
if (&other_value != this) {
clean_up();
set_selection(other_value);
}
return *this;
}

boolean VersionNotSupported_template::match(null_type other_value,boolean) const
{
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
case SPECIFIC_VALUE:
return TRUE;
case OMIT_VALUE:
return FALSE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.VersionNotSupported.");
}
return FALSE;
}

boolean VersionNotSupported_template::match(const VersionNotSupported& other_value, boolean) const
{
if (!other_value.is_bound()) return FALSE;
return match(NULL_VALUE);
}

VersionNotSupported VersionNotSupported_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.VersionNotSupported.");
return NULL_VALUE;
}

void VersionNotSupported_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.VersionNotSupported.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new VersionNotSupported_template[list_length];
}

VersionNotSupported_template& VersionNotSupported_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.VersionNotSupported.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.VersionNotSupported.");
return value_list.list_value[list_index];
}

void VersionNotSupported_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void VersionNotSupported_template::log_match(const VersionNotSupported& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void VersionNotSupported_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
case SPECIFIC_VALUE:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.VersionNotSupported.");
}
}

void VersionNotSupported_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
case SPECIFIC_VALUE:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new VersionNotSupported_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.VersionNotSupported.");
}
}

void VersionNotSupported_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "empty record/set template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    VersionNotSupported_template temp;
    temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = temp;
    break; }
  case Module_Param::MP_Value_List:
    if (param.get_size()>0) param.type_error("empty record/set template", "@GTPC_Types.VersionNotSupported");
    *this = NULL_VALUE;
    break;
  case Module_Param::MP_Implication_Template: {
    VersionNotSupported_template* precondition = new VersionNotSupported_template;
    precondition->set_param(*param.get_elem(0));
    VersionNotSupported_template* implied_template = new VersionNotSupported_template;
    implied_template->set_param(*param.get_elem(1));
    *this = VersionNotSupported_template(precondition, implied_template);
  } break;
  default:
    param.type_error("empty record/set template", "@GTPC_Types.VersionNotSupported");
  }
  is_ifpresent = param.get_ifpresent();
}

void VersionNotSupported_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.VersionNotSupported");
}

boolean VersionNotSupported_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean VersionNotSupported_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SupportedExtensionHeadersNotification::SupportedExtensionHeadersNotification()
{
}

SupportedExtensionHeadersNotification::SupportedExtensionHeadersNotification(const ExtensionHeaderTypeList__gtpc& par_extensionHeaderTypeList)
  :   field_extensionHeaderTypeList(par_extensionHeaderTypeList)
{
}

SupportedExtensionHeadersNotification::SupportedExtensionHeadersNotification(const SupportedExtensionHeadersNotification& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.SupportedExtensionHeadersNotification.");
if (other_value.extensionHeaderTypeList().is_bound()) field_extensionHeaderTypeList = other_value.extensionHeaderTypeList();
else field_extensionHeaderTypeList.clean_up();
}

void SupportedExtensionHeadersNotification::clean_up()
{
field_extensionHeaderTypeList.clean_up();
}

const TTCN_Typedescriptor_t* SupportedExtensionHeadersNotification::get_descriptor() const { return &SupportedExtensionHeadersNotification_descr_; }
SupportedExtensionHeadersNotification& SupportedExtensionHeadersNotification::operator=(const SupportedExtensionHeadersNotification& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.SupportedExtensionHeadersNotification.");
  if (other_value.extensionHeaderTypeList().is_bound()) field_extensionHeaderTypeList = other_value.extensionHeaderTypeList();
  else field_extensionHeaderTypeList.clean_up();
}
return *this;
}

boolean SupportedExtensionHeadersNotification::operator==(const SupportedExtensionHeadersNotification& other_value) const
{
return field_extensionHeaderTypeList==other_value.field_extensionHeaderTypeList;
}

boolean SupportedExtensionHeadersNotification::is_bound() const
{
return (field_extensionHeaderTypeList.is_bound());
}
boolean SupportedExtensionHeadersNotification::is_value() const
{
return field_extensionHeaderTypeList.is_value();
}
void SupportedExtensionHeadersNotification::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ extensionHeaderTypeList := ");
field_extensionHeaderTypeList.log();
TTCN_Logger::log_event_str(" }");
}

void SupportedExtensionHeadersNotification::set_implicit_omit()
{
if (extensionHeaderTypeList().is_bound()) extensionHeaderTypeList().set_implicit_omit();
}

void SupportedExtensionHeadersNotification::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @GTPC_Types.SupportedExtensionHeadersNotification has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) extensionHeaderTypeList().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionHeaderTypeList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionHeaderTypeList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.SupportedExtensionHeadersNotification: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.SupportedExtensionHeadersNotification");
  }
}

void SupportedExtensionHeadersNotification::encode_text(Text_Buf& text_buf) const
{
field_extensionHeaderTypeList.encode_text(text_buf);
}

void SupportedExtensionHeadersNotification::decode_text(Text_Buf& text_buf)
{
field_extensionHeaderTypeList.decode_text(text_buf);
}

void SupportedExtensionHeadersNotification::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SupportedExtensionHeadersNotification::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int SupportedExtensionHeadersNotification::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, ExtensionHeaderTypeList__gtpc_descr_.raw->forceomit);
  decoded_field_length = field_extensionHeaderTypeList.RAW_decode(ExtensionHeaderTypeList__gtpc_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int SupportedExtensionHeadersNotification::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 1;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(1);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, ExtensionHeaderTypeList__gtpc_descr_.raw);
  encoded_length += field_extensionHeaderTypeList.RAW_encode(ExtensionHeaderTypeList__gtpc_descr_, *myleaf.body.node.nodes[0]);
  return myleaf.length = encoded_length;
}

struct SupportedExtensionHeadersNotification_template::single_value_struct {
ExtensionHeaderTypeList__gtpc_template field_extensionHeaderTypeList;
};

void SupportedExtensionHeadersNotification_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_extensionHeaderTypeList = ANY_VALUE;
}
}
}

void SupportedExtensionHeadersNotification_template::copy_value(const SupportedExtensionHeadersNotification& other_value)
{
single_value = new single_value_struct;
if (other_value.extensionHeaderTypeList().is_bound()) {
  single_value->field_extensionHeaderTypeList = other_value.extensionHeaderTypeList();
} else {
  single_value->field_extensionHeaderTypeList.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SupportedExtensionHeadersNotification_template::copy_template(const SupportedExtensionHeadersNotification_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.extensionHeaderTypeList().get_selection()) {
single_value->field_extensionHeaderTypeList = other_value.extensionHeaderTypeList();
} else {
single_value->field_extensionHeaderTypeList.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SupportedExtensionHeadersNotification_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SupportedExtensionHeadersNotification_template(*other_value.implication_.precondition);
implication_.implied_template = new SupportedExtensionHeadersNotification_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.SupportedExtensionHeadersNotification.");
break;
}
set_selection(other_value);
}

SupportedExtensionHeadersNotification_template::SupportedExtensionHeadersNotification_template()
{
}

SupportedExtensionHeadersNotification_template::SupportedExtensionHeadersNotification_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SupportedExtensionHeadersNotification_template::SupportedExtensionHeadersNotification_template(const SupportedExtensionHeadersNotification& other_value)
{
copy_value(other_value);
}

SupportedExtensionHeadersNotification_template::SupportedExtensionHeadersNotification_template(const OPTIONAL<SupportedExtensionHeadersNotification>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SupportedExtensionHeadersNotification&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.SupportedExtensionHeadersNotification from an unbound optional field.");
}
}

SupportedExtensionHeadersNotification_template::SupportedExtensionHeadersNotification_template(SupportedExtensionHeadersNotification_template* p_precondition, SupportedExtensionHeadersNotification_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SupportedExtensionHeadersNotification_template::SupportedExtensionHeadersNotification_template(Dynamic_Match_Interface<SupportedExtensionHeadersNotification>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SupportedExtensionHeadersNotification>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SupportedExtensionHeadersNotification_template::SupportedExtensionHeadersNotification_template(const SupportedExtensionHeadersNotification_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SupportedExtensionHeadersNotification_template::~SupportedExtensionHeadersNotification_template()
{
clean_up();
}

SupportedExtensionHeadersNotification_template& SupportedExtensionHeadersNotification_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SupportedExtensionHeadersNotification_template& SupportedExtensionHeadersNotification_template::operator=(const SupportedExtensionHeadersNotification& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SupportedExtensionHeadersNotification_template& SupportedExtensionHeadersNotification_template::operator=(const OPTIONAL<SupportedExtensionHeadersNotification>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SupportedExtensionHeadersNotification&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.SupportedExtensionHeadersNotification.");
}
return *this;
}

SupportedExtensionHeadersNotification_template& SupportedExtensionHeadersNotification_template::operator=(const SupportedExtensionHeadersNotification_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SupportedExtensionHeadersNotification_template::match(const SupportedExtensionHeadersNotification& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.extensionHeaderTypeList().is_bound()) return FALSE;
if(!single_value->field_extensionHeaderTypeList.match(other_value.extensionHeaderTypeList(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.SupportedExtensionHeadersNotification.");
}
return FALSE;
}

boolean SupportedExtensionHeadersNotification_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_extensionHeaderTypeList.is_bound();
}

boolean SupportedExtensionHeadersNotification_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_extensionHeaderTypeList.is_value();
}

void SupportedExtensionHeadersNotification_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SupportedExtensionHeadersNotification SupportedExtensionHeadersNotification_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.SupportedExtensionHeadersNotification.");
SupportedExtensionHeadersNotification ret_val;
if (single_value->field_extensionHeaderTypeList.is_bound()) {
ret_val.extensionHeaderTypeList() = single_value->field_extensionHeaderTypeList.valueof();
}
return ret_val;
}

void SupportedExtensionHeadersNotification_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.SupportedExtensionHeadersNotification.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SupportedExtensionHeadersNotification_template[list_length];
}

SupportedExtensionHeadersNotification_template& SupportedExtensionHeadersNotification_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.SupportedExtensionHeadersNotification.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.SupportedExtensionHeadersNotification.");
return value_list.list_value[list_index];
}

ExtensionHeaderTypeList__gtpc_template& SupportedExtensionHeadersNotification_template::extensionHeaderTypeList()
{
set_specific();
return single_value->field_extensionHeaderTypeList;
}

const ExtensionHeaderTypeList__gtpc_template& SupportedExtensionHeadersNotification_template::extensionHeaderTypeList() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionHeaderTypeList of a non-specific template of type @GTPC_Types.SupportedExtensionHeadersNotification.");
return single_value->field_extensionHeaderTypeList;
}

int SupportedExtensionHeadersNotification_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.SupportedExtensionHeadersNotification which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.SupportedExtensionHeadersNotification containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.SupportedExtensionHeadersNotification containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.SupportedExtensionHeadersNotification containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.SupportedExtensionHeadersNotification containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.SupportedExtensionHeadersNotification containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.SupportedExtensionHeadersNotification containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.SupportedExtensionHeadersNotification containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.SupportedExtensionHeadersNotification containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.SupportedExtensionHeadersNotification.");
  }
  return 0;
}

void SupportedExtensionHeadersNotification_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ extensionHeaderTypeList := ");
single_value->field_extensionHeaderTypeList.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SupportedExtensionHeadersNotification_template::log_match(const SupportedExtensionHeadersNotification& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_extensionHeaderTypeList.match(match_value.extensionHeaderTypeList(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionHeaderTypeList");
single_value->field_extensionHeaderTypeList.log_match(match_value.extensionHeaderTypeList(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ extensionHeaderTypeList := ");
single_value->field_extensionHeaderTypeList.log_match(match_value.extensionHeaderTypeList(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SupportedExtensionHeadersNotification_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (extensionHeaderTypeList().is_bound()) extensionHeaderTypeList().set_implicit_omit();
}

void SupportedExtensionHeadersNotification_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_extensionHeaderTypeList.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.SupportedExtensionHeadersNotification.");
}
}

void SupportedExtensionHeadersNotification_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_extensionHeaderTypeList.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SupportedExtensionHeadersNotification_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.SupportedExtensionHeadersNotification.");
}
}

void SupportedExtensionHeadersNotification_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SupportedExtensionHeadersNotification_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @GTPC_Types.SupportedExtensionHeadersNotification has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) extensionHeaderTypeList().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionHeaderTypeList")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionHeaderTypeList().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.SupportedExtensionHeadersNotification: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SupportedExtensionHeadersNotification_template* precondition = new SupportedExtensionHeadersNotification_template;
    precondition->set_param(*param.get_elem(0));
    SupportedExtensionHeadersNotification_template* implied_template = new SupportedExtensionHeadersNotification_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SupportedExtensionHeadersNotification_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.SupportedExtensionHeadersNotification");
  }
  is_ifpresent = param.get_ifpresent();
}

void SupportedExtensionHeadersNotification_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_extensionHeaderTypeList.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.SupportedExtensionHeadersNotification");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.SupportedExtensionHeadersNotification");
}

boolean SupportedExtensionHeadersNotification_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SupportedExtensionHeadersNotification_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

CreatePDPContextRequest::CreatePDPContextRequest()
{
}

CreatePDPContextRequest::CreatePDPContextRequest(const OPTIONAL< IMSI__gtpc >& par_imsi,
    const OPTIONAL< RoutingAreaIdentity >& par_rai,
    const OPTIONAL< Recovery__gtpc >& par_recovery,
    const OPTIONAL< SelectionMode >& par_selectionMode,
    const TeidDataI& par_teidDataI,
    const OPTIONAL< TeidControlPlane >& par_teidControlPlane,
    const NSAPI__GTPC& par_nsapi,
    const OPTIONAL< NSAPI__GTPC >& par_linked__nsapi,
    const OPTIONAL< ChargingCharacteristics__GTPC >& par_charging__char,
    const OPTIONAL< TraceRef >& par_trace__ref,
    const OPTIONAL< GTP__TraceType >& par_trace__type,
    const OPTIONAL< EndUserAddress >& par_endUserAddress,
    const OPTIONAL< AccessPointName >& par_accessPointName,
    const OPTIONAL< ProtConfigOptions >& par_protConfigOptions,
    const GSN__Address__GTPC& par_sgsn__addr__signalling,
    const GSN__Address__GTPC& par_sgsn__addr__traffic,
    const OPTIONAL< MSISDN >& par_msisdn,
    const QualityOfServiceProfile& par_qualityOfServiceProfile,
    const OPTIONAL< TrafficFlowTemplate >& par_tft,
    const OPTIONAL< GTP__TriggerID >& par_triggerId,
    const OPTIONAL< OMCIdentity >& par_omcId,
    const OPTIONAL< CommonFlags >& par_commonFlags,
    const OPTIONAL< APN__Restriction >& par_aPN__Restriction,
    const OPTIONAL< RATType >& par_ratType,
    const OPTIONAL< UserLocationInformation >& par_userLocationInformation,
    const OPTIONAL< MS__TimeZone >& par_mS__TimeZone,
    const OPTIONAL< IMEISV__gtpc >& par_imeisv,
    const OPTIONAL< CamelChargingInformationContainer >& par_camelChargingInformationContainer,
    const OPTIONAL< AdditionalTraceInfo >& par_additionalTraceInfo,
    const OPTIONAL< CorrelationID >& par_correlationID,
    const OPTIONAL< EvolvedAllocationRetentionPriorityI >& par_evolvedAllocationRetentionPriorityI,
    const OPTIONAL< ExtendedCommonFlags >& par_extendedCommonFlags,
    const OPTIONAL< UserCSGInformation >& par_userCSGInformation,
    const OPTIONAL< APN__AMBR >& par_aPN__AMBR,
    const OPTIONAL< SignallingPriorityIndication >& par_signallingPriorityIndication,
    const OPTIONAL< CN__OperatorSelectionEntity >& par_cN__OperatorSelectionEntity,
    const OPTIONAL< PrivateExtension__gtpc__List >& par_private__extension__gtpc)
  :   field_imsi(par_imsi),
  field_rai(par_rai),
  field_recovery(par_recovery),
  field_selectionMode(par_selectionMode),
  field_teidDataI(par_teidDataI),
  field_teidControlPlane(par_teidControlPlane),
  field_nsapi(par_nsapi),
  field_linked__nsapi(par_linked__nsapi),
  field_charging__char(par_charging__char),
  field_trace__ref(par_trace__ref),
  field_trace__type(par_trace__type),
  field_endUserAddress(par_endUserAddress),
  field_accessPointName(par_accessPointName),
  field_protConfigOptions(par_protConfigOptions),
  field_sgsn__addr__signalling(par_sgsn__addr__signalling),
  field_sgsn__addr__traffic(par_sgsn__addr__traffic),
  field_msisdn(par_msisdn),
  field_qualityOfServiceProfile(par_qualityOfServiceProfile),
  field_tft(par_tft),
  field_triggerId(par_triggerId),
  field_omcId(par_omcId),
  field_commonFlags(par_commonFlags),
  field_aPN__Restriction(par_aPN__Restriction),
  field_ratType(par_ratType),
  field_userLocationInformation(par_userLocationInformation),
  field_mS__TimeZone(par_mS__TimeZone),
  field_imeisv(par_imeisv),
  field_camelChargingInformationContainer(par_camelChargingInformationContainer),
  field_additionalTraceInfo(par_additionalTraceInfo),
  field_correlationID(par_correlationID),
  field_evolvedAllocationRetentionPriorityI(par_evolvedAllocationRetentionPriorityI),
  field_extendedCommonFlags(par_extendedCommonFlags),
  field_userCSGInformation(par_userCSGInformation),
  field_aPN__AMBR(par_aPN__AMBR),
  field_signallingPriorityIndication(par_signallingPriorityIndication),
  field_cN__OperatorSelectionEntity(par_cN__OperatorSelectionEntity),
  field_private__extension__gtpc(par_private__extension__gtpc)
{
}

CreatePDPContextRequest::CreatePDPContextRequest(const CreatePDPContextRequest& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.CreatePDPContextRequest.");
if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
else field_imsi.clean_up();
if (other_value.rai().is_bound()) field_rai = other_value.rai();
else field_rai.clean_up();
if (other_value.recovery().is_bound()) field_recovery = other_value.recovery();
else field_recovery.clean_up();
if (other_value.selectionMode().is_bound()) field_selectionMode = other_value.selectionMode();
else field_selectionMode.clean_up();
if (other_value.teidDataI().is_bound()) field_teidDataI = other_value.teidDataI();
else field_teidDataI.clean_up();
if (other_value.teidControlPlane().is_bound()) field_teidControlPlane = other_value.teidControlPlane();
else field_teidControlPlane.clean_up();
if (other_value.nsapi().is_bound()) field_nsapi = other_value.nsapi();
else field_nsapi.clean_up();
if (other_value.linked__nsapi().is_bound()) field_linked__nsapi = other_value.linked__nsapi();
else field_linked__nsapi.clean_up();
if (other_value.charging__char().is_bound()) field_charging__char = other_value.charging__char();
else field_charging__char.clean_up();
if (other_value.trace__ref().is_bound()) field_trace__ref = other_value.trace__ref();
else field_trace__ref.clean_up();
if (other_value.trace__type().is_bound()) field_trace__type = other_value.trace__type();
else field_trace__type.clean_up();
if (other_value.endUserAddress().is_bound()) field_endUserAddress = other_value.endUserAddress();
else field_endUserAddress.clean_up();
if (other_value.accessPointName().is_bound()) field_accessPointName = other_value.accessPointName();
else field_accessPointName.clean_up();
if (other_value.protConfigOptions().is_bound()) field_protConfigOptions = other_value.protConfigOptions();
else field_protConfigOptions.clean_up();
if (other_value.sgsn__addr__signalling().is_bound()) field_sgsn__addr__signalling = other_value.sgsn__addr__signalling();
else field_sgsn__addr__signalling.clean_up();
if (other_value.sgsn__addr__traffic().is_bound()) field_sgsn__addr__traffic = other_value.sgsn__addr__traffic();
else field_sgsn__addr__traffic.clean_up();
if (other_value.msisdn().is_bound()) field_msisdn = other_value.msisdn();
else field_msisdn.clean_up();
if (other_value.qualityOfServiceProfile().is_bound()) field_qualityOfServiceProfile = other_value.qualityOfServiceProfile();
else field_qualityOfServiceProfile.clean_up();
if (other_value.tft().is_bound()) field_tft = other_value.tft();
else field_tft.clean_up();
if (other_value.triggerId().is_bound()) field_triggerId = other_value.triggerId();
else field_triggerId.clean_up();
if (other_value.omcId().is_bound()) field_omcId = other_value.omcId();
else field_omcId.clean_up();
if (other_value.commonFlags().is_bound()) field_commonFlags = other_value.commonFlags();
else field_commonFlags.clean_up();
if (other_value.aPN__Restriction().is_bound()) field_aPN__Restriction = other_value.aPN__Restriction();
else field_aPN__Restriction.clean_up();
if (other_value.ratType().is_bound()) field_ratType = other_value.ratType();
else field_ratType.clean_up();
if (other_value.userLocationInformation().is_bound()) field_userLocationInformation = other_value.userLocationInformation();
else field_userLocationInformation.clean_up();
if (other_value.mS__TimeZone().is_bound()) field_mS__TimeZone = other_value.mS__TimeZone();
else field_mS__TimeZone.clean_up();
if (other_value.imeisv().is_bound()) field_imeisv = other_value.imeisv();
else field_imeisv.clean_up();
if (other_value.camelChargingInformationContainer().is_bound()) field_camelChargingInformationContainer = other_value.camelChargingInformationContainer();
else field_camelChargingInformationContainer.clean_up();
if (other_value.additionalTraceInfo().is_bound()) field_additionalTraceInfo = other_value.additionalTraceInfo();
else field_additionalTraceInfo.clean_up();
if (other_value.correlationID().is_bound()) field_correlationID = other_value.correlationID();
else field_correlationID.clean_up();
if (other_value.evolvedAllocationRetentionPriorityI().is_bound()) field_evolvedAllocationRetentionPriorityI = other_value.evolvedAllocationRetentionPriorityI();
else field_evolvedAllocationRetentionPriorityI.clean_up();
if (other_value.extendedCommonFlags().is_bound()) field_extendedCommonFlags = other_value.extendedCommonFlags();
else field_extendedCommonFlags.clean_up();
if (other_value.userCSGInformation().is_bound()) field_userCSGInformation = other_value.userCSGInformation();
else field_userCSGInformation.clean_up();
if (other_value.aPN__AMBR().is_bound()) field_aPN__AMBR = other_value.aPN__AMBR();
else field_aPN__AMBR.clean_up();
if (other_value.signallingPriorityIndication().is_bound()) field_signallingPriorityIndication = other_value.signallingPriorityIndication();
else field_signallingPriorityIndication.clean_up();
if (other_value.cN__OperatorSelectionEntity().is_bound()) field_cN__OperatorSelectionEntity = other_value.cN__OperatorSelectionEntity();
else field_cN__OperatorSelectionEntity.clean_up();
if (other_value.private__extension__gtpc().is_bound()) field_private__extension__gtpc = other_value.private__extension__gtpc();
else field_private__extension__gtpc.clean_up();
}

void CreatePDPContextRequest::clean_up()
{
field_imsi.clean_up();
field_rai.clean_up();
field_recovery.clean_up();
field_selectionMode.clean_up();
field_teidDataI.clean_up();
field_teidControlPlane.clean_up();
field_nsapi.clean_up();
field_linked__nsapi.clean_up();
field_charging__char.clean_up();
field_trace__ref.clean_up();
field_trace__type.clean_up();
field_endUserAddress.clean_up();
field_accessPointName.clean_up();
field_protConfigOptions.clean_up();
field_sgsn__addr__signalling.clean_up();
field_sgsn__addr__traffic.clean_up();
field_msisdn.clean_up();
field_qualityOfServiceProfile.clean_up();
field_tft.clean_up();
field_triggerId.clean_up();
field_omcId.clean_up();
field_commonFlags.clean_up();
field_aPN__Restriction.clean_up();
field_ratType.clean_up();
field_userLocationInformation.clean_up();
field_mS__TimeZone.clean_up();
field_imeisv.clean_up();
field_camelChargingInformationContainer.clean_up();
field_additionalTraceInfo.clean_up();
field_correlationID.clean_up();
field_evolvedAllocationRetentionPriorityI.clean_up();
field_extendedCommonFlags.clean_up();
field_userCSGInformation.clean_up();
field_aPN__AMBR.clean_up();
field_signallingPriorityIndication.clean_up();
field_cN__OperatorSelectionEntity.clean_up();
field_private__extension__gtpc.clean_up();
}

const TTCN_Typedescriptor_t* CreatePDPContextRequest::get_descriptor() const { return &CreatePDPContextRequest_descr_; }
CreatePDPContextRequest& CreatePDPContextRequest::operator=(const CreatePDPContextRequest& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.CreatePDPContextRequest.");
  if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
  else field_imsi.clean_up();
  if (other_value.rai().is_bound()) field_rai = other_value.rai();
  else field_rai.clean_up();
  if (other_value.recovery().is_bound()) field_recovery = other_value.recovery();
  else field_recovery.clean_up();
  if (other_value.selectionMode().is_bound()) field_selectionMode = other_value.selectionMode();
  else field_selectionMode.clean_up();
  if (other_value.teidDataI().is_bound()) field_teidDataI = other_value.teidDataI();
  else field_teidDataI.clean_up();
  if (other_value.teidControlPlane().is_bound()) field_teidControlPlane = other_value.teidControlPlane();
  else field_teidControlPlane.clean_up();
  if (other_value.nsapi().is_bound()) field_nsapi = other_value.nsapi();
  else field_nsapi.clean_up();
  if (other_value.linked__nsapi().is_bound()) field_linked__nsapi = other_value.linked__nsapi();
  else field_linked__nsapi.clean_up();
  if (other_value.charging__char().is_bound()) field_charging__char = other_value.charging__char();
  else field_charging__char.clean_up();
  if (other_value.trace__ref().is_bound()) field_trace__ref = other_value.trace__ref();
  else field_trace__ref.clean_up();
  if (other_value.trace__type().is_bound()) field_trace__type = other_value.trace__type();
  else field_trace__type.clean_up();
  if (other_value.endUserAddress().is_bound()) field_endUserAddress = other_value.endUserAddress();
  else field_endUserAddress.clean_up();
  if (other_value.accessPointName().is_bound()) field_accessPointName = other_value.accessPointName();
  else field_accessPointName.clean_up();
  if (other_value.protConfigOptions().is_bound()) field_protConfigOptions = other_value.protConfigOptions();
  else field_protConfigOptions.clean_up();
  if (other_value.sgsn__addr__signalling().is_bound()) field_sgsn__addr__signalling = other_value.sgsn__addr__signalling();
  else field_sgsn__addr__signalling.clean_up();
  if (other_value.sgsn__addr__traffic().is_bound()) field_sgsn__addr__traffic = other_value.sgsn__addr__traffic();
  else field_sgsn__addr__traffic.clean_up();
  if (other_value.msisdn().is_bound()) field_msisdn = other_value.msisdn();
  else field_msisdn.clean_up();
  if (other_value.qualityOfServiceProfile().is_bound()) field_qualityOfServiceProfile = other_value.qualityOfServiceProfile();
  else field_qualityOfServiceProfile.clean_up();
  if (other_value.tft().is_bound()) field_tft = other_value.tft();
  else field_tft.clean_up();
  if (other_value.triggerId().is_bound()) field_triggerId = other_value.triggerId();
  else field_triggerId.clean_up();
  if (other_value.omcId().is_bound()) field_omcId = other_value.omcId();
  else field_omcId.clean_up();
  if (other_value.commonFlags().is_bound()) field_commonFlags = other_value.commonFlags();
  else field_commonFlags.clean_up();
  if (other_value.aPN__Restriction().is_bound()) field_aPN__Restriction = other_value.aPN__Restriction();
  else field_aPN__Restriction.clean_up();
  if (other_value.ratType().is_bound()) field_ratType = other_value.ratType();
  else field_ratType.clean_up();
  if (other_value.userLocationInformation().is_bound()) field_userLocationInformation = other_value.userLocationInformation();
  else field_userLocationInformation.clean_up();
  if (other_value.mS__TimeZone().is_bound()) field_mS__TimeZone = other_value.mS__TimeZone();
  else field_mS__TimeZone.clean_up();
  if (other_value.imeisv().is_bound()) field_imeisv = other_value.imeisv();
  else field_imeisv.clean_up();
  if (other_value.camelChargingInformationContainer().is_bound()) field_camelChargingInformationContainer = other_value.camelChargingInformationContainer();
  else field_camelChargingInformationContainer.clean_up();
  if (other_value.additionalTraceInfo().is_bound()) field_additionalTraceInfo = other_value.additionalTraceInfo();
  else field_additionalTraceInfo.clean_up();
  if (other_value.correlationID().is_bound()) field_correlationID = other_value.correlationID();
  else field_correlationID.clean_up();
  if (other_value.evolvedAllocationRetentionPriorityI().is_bound()) field_evolvedAllocationRetentionPriorityI = other_value.evolvedAllocationRetentionPriorityI();
  else field_evolvedAllocationRetentionPriorityI.clean_up();
  if (other_value.extendedCommonFlags().is_bound()) field_extendedCommonFlags = other_value.extendedCommonFlags();
  else field_extendedCommonFlags.clean_up();
  if (other_value.userCSGInformation().is_bound()) field_userCSGInformation = other_value.userCSGInformation();
  else field_userCSGInformation.clean_up();
  if (other_value.aPN__AMBR().is_bound()) field_aPN__AMBR = other_value.aPN__AMBR();
  else field_aPN__AMBR.clean_up();
  if (other_value.signallingPriorityIndication().is_bound()) field_signallingPriorityIndication = other_value.signallingPriorityIndication();
  else field_signallingPriorityIndication.clean_up();
  if (other_value.cN__OperatorSelectionEntity().is_bound()) field_cN__OperatorSelectionEntity = other_value.cN__OperatorSelectionEntity();
  else field_cN__OperatorSelectionEntity.clean_up();
  if (other_value.private__extension__gtpc().is_bound()) field_private__extension__gtpc = other_value.private__extension__gtpc();
  else field_private__extension__gtpc.clean_up();
}
return *this;
}

boolean CreatePDPContextRequest::operator==(const CreatePDPContextRequest& other_value) const
{
return field_imsi==other_value.field_imsi
  && field_rai==other_value.field_rai
  && field_recovery==other_value.field_recovery
  && field_selectionMode==other_value.field_selectionMode
  && field_teidDataI==other_value.field_teidDataI
  && field_teidControlPlane==other_value.field_teidControlPlane
  && field_nsapi==other_value.field_nsapi
  && field_linked__nsapi==other_value.field_linked__nsapi
  && field_charging__char==other_value.field_charging__char
  && field_trace__ref==other_value.field_trace__ref
  && field_trace__type==other_value.field_trace__type
  && field_endUserAddress==other_value.field_endUserAddress
  && field_accessPointName==other_value.field_accessPointName
  && field_protConfigOptions==other_value.field_protConfigOptions
  && field_sgsn__addr__signalling==other_value.field_sgsn__addr__signalling
  && field_sgsn__addr__traffic==other_value.field_sgsn__addr__traffic
  && field_msisdn==other_value.field_msisdn
  && field_qualityOfServiceProfile==other_value.field_qualityOfServiceProfile
  && field_tft==other_value.field_tft
  && field_triggerId==other_value.field_triggerId
  && field_omcId==other_value.field_omcId
  && field_commonFlags==other_value.field_commonFlags
  && field_aPN__Restriction==other_value.field_aPN__Restriction
  && field_ratType==other_value.field_ratType
  && field_userLocationInformation==other_value.field_userLocationInformation
  && field_mS__TimeZone==other_value.field_mS__TimeZone
  && field_imeisv==other_value.field_imeisv
  && field_camelChargingInformationContainer==other_value.field_camelChargingInformationContainer
  && field_additionalTraceInfo==other_value.field_additionalTraceInfo
  && field_correlationID==other_value.field_correlationID
  && field_evolvedAllocationRetentionPriorityI==other_value.field_evolvedAllocationRetentionPriorityI
  && field_extendedCommonFlags==other_value.field_extendedCommonFlags
  && field_userCSGInformation==other_value.field_userCSGInformation
  && field_aPN__AMBR==other_value.field_aPN__AMBR
  && field_signallingPriorityIndication==other_value.field_signallingPriorityIndication
  && field_cN__OperatorSelectionEntity==other_value.field_cN__OperatorSelectionEntity
  && field_private__extension__gtpc==other_value.field_private__extension__gtpc;
}

boolean CreatePDPContextRequest::is_bound() const
{
return (OPTIONAL_OMIT == field_imsi.get_selection() || field_imsi.is_bound())
  || (OPTIONAL_OMIT == field_rai.get_selection() || field_rai.is_bound())
  || (OPTIONAL_OMIT == field_recovery.get_selection() || field_recovery.is_bound())
  || (OPTIONAL_OMIT == field_selectionMode.get_selection() || field_selectionMode.is_bound())
  || (field_teidDataI.is_bound())
  || (OPTIONAL_OMIT == field_teidControlPlane.get_selection() || field_teidControlPlane.is_bound())
  || (field_nsapi.is_bound())
  || (OPTIONAL_OMIT == field_linked__nsapi.get_selection() || field_linked__nsapi.is_bound())
  || (OPTIONAL_OMIT == field_charging__char.get_selection() || field_charging__char.is_bound())
  || (OPTIONAL_OMIT == field_trace__ref.get_selection() || field_trace__ref.is_bound())
  || (OPTIONAL_OMIT == field_trace__type.get_selection() || field_trace__type.is_bound())
  || (OPTIONAL_OMIT == field_endUserAddress.get_selection() || field_endUserAddress.is_bound())
  || (OPTIONAL_OMIT == field_accessPointName.get_selection() || field_accessPointName.is_bound())
  || (OPTIONAL_OMIT == field_protConfigOptions.get_selection() || field_protConfigOptions.is_bound())
  || (field_sgsn__addr__signalling.is_bound())
  || (field_sgsn__addr__traffic.is_bound())
  || (OPTIONAL_OMIT == field_msisdn.get_selection() || field_msisdn.is_bound())
  || (field_qualityOfServiceProfile.is_bound())
  || (OPTIONAL_OMIT == field_tft.get_selection() || field_tft.is_bound())
  || (OPTIONAL_OMIT == field_triggerId.get_selection() || field_triggerId.is_bound())
  || (OPTIONAL_OMIT == field_omcId.get_selection() || field_omcId.is_bound())
  || (OPTIONAL_OMIT == field_commonFlags.get_selection() || field_commonFlags.is_bound())
  || (OPTIONAL_OMIT == field_aPN__Restriction.get_selection() || field_aPN__Restriction.is_bound())
  || (OPTIONAL_OMIT == field_ratType.get_selection() || field_ratType.is_bound())
  || (OPTIONAL_OMIT == field_userLocationInformation.get_selection() || field_userLocationInformation.is_bound())
  || (OPTIONAL_OMIT == field_mS__TimeZone.get_selection() || field_mS__TimeZone.is_bound())
  || (OPTIONAL_OMIT == field_imeisv.get_selection() || field_imeisv.is_bound())
  || (OPTIONAL_OMIT == field_camelChargingInformationContainer.get_selection() || field_camelChargingInformationContainer.is_bound())
  || (OPTIONAL_OMIT == field_additionalTraceInfo.get_selection() || field_additionalTraceInfo.is_bound())
  || (OPTIONAL_OMIT == field_correlationID.get_selection() || field_correlationID.is_bound())
  || (OPTIONAL_OMIT == field_evolvedAllocationRetentionPriorityI.get_selection() || field_evolvedAllocationRetentionPriorityI.is_bound())
  || (OPTIONAL_OMIT == field_extendedCommonFlags.get_selection() || field_extendedCommonFlags.is_bound())
  || (OPTIONAL_OMIT == field_userCSGInformation.get_selection() || field_userCSGInformation.is_bound())
  || (OPTIONAL_OMIT == field_aPN__AMBR.get_selection() || field_aPN__AMBR.is_bound())
  || (OPTIONAL_OMIT == field_signallingPriorityIndication.get_selection() || field_signallingPriorityIndication.is_bound())
  || (OPTIONAL_OMIT == field_cN__OperatorSelectionEntity.get_selection() || field_cN__OperatorSelectionEntity.is_bound())
  || (OPTIONAL_OMIT == field_private__extension__gtpc.get_selection() || field_private__extension__gtpc.is_bound());
}
boolean CreatePDPContextRequest::is_value() const
{
return (OPTIONAL_OMIT == field_imsi.get_selection() || field_imsi.is_value())
  && (OPTIONAL_OMIT == field_rai.get_selection() || field_rai.is_value())
  && (OPTIONAL_OMIT == field_recovery.get_selection() || field_recovery.is_value())
  && (OPTIONAL_OMIT == field_selectionMode.get_selection() || field_selectionMode.is_value())
  && field_teidDataI.is_value()
  && (OPTIONAL_OMIT == field_teidControlPlane.get_selection() || field_teidControlPlane.is_value())
  && field_nsapi.is_value()
  && (OPTIONAL_OMIT == field_linked__nsapi.get_selection() || field_linked__nsapi.is_value())
  && (OPTIONAL_OMIT == field_charging__char.get_selection() || field_charging__char.is_value())
  && (OPTIONAL_OMIT == field_trace__ref.get_selection() || field_trace__ref.is_value())
  && (OPTIONAL_OMIT == field_trace__type.get_selection() || field_trace__type.is_value())
  && (OPTIONAL_OMIT == field_endUserAddress.get_selection() || field_endUserAddress.is_value())
  && (OPTIONAL_OMIT == field_accessPointName.get_selection() || field_accessPointName.is_value())
  && (OPTIONAL_OMIT == field_protConfigOptions.get_selection() || field_protConfigOptions.is_value())
  && field_sgsn__addr__signalling.is_value()
  && field_sgsn__addr__traffic.is_value()
  && (OPTIONAL_OMIT == field_msisdn.get_selection() || field_msisdn.is_value())
  && field_qualityOfServiceProfile.is_value()
  && (OPTIONAL_OMIT == field_tft.get_selection() || field_tft.is_value())
  && (OPTIONAL_OMIT == field_triggerId.get_selection() || field_triggerId.is_value())
  && (OPTIONAL_OMIT == field_omcId.get_selection() || field_omcId.is_value())
  && (OPTIONAL_OMIT == field_commonFlags.get_selection() || field_commonFlags.is_value())
  && (OPTIONAL_OMIT == field_aPN__Restriction.get_selection() || field_aPN__Restriction.is_value())
  && (OPTIONAL_OMIT == field_ratType.get_selection() || field_ratType.is_value())
  && (OPTIONAL_OMIT == field_userLocationInformation.get_selection() || field_userLocationInformation.is_value())
  && (OPTIONAL_OMIT == field_mS__TimeZone.get_selection() || field_mS__TimeZone.is_value())
  && (OPTIONAL_OMIT == field_imeisv.get_selection() || field_imeisv.is_value())
  && (OPTIONAL_OMIT == field_camelChargingInformationContainer.get_selection() || field_camelChargingInformationContainer.is_value())
  && (OPTIONAL_OMIT == field_additionalTraceInfo.get_selection() || field_additionalTraceInfo.is_value())
  && (OPTIONAL_OMIT == field_correlationID.get_selection() || field_correlationID.is_value())
  && (OPTIONAL_OMIT == field_evolvedAllocationRetentionPriorityI.get_selection() || field_evolvedAllocationRetentionPriorityI.is_value())
  && (OPTIONAL_OMIT == field_extendedCommonFlags.get_selection() || field_extendedCommonFlags.is_value())
  && (OPTIONAL_OMIT == field_userCSGInformation.get_selection() || field_userCSGInformation.is_value())
  && (OPTIONAL_OMIT == field_aPN__AMBR.get_selection() || field_aPN__AMBR.is_value())
  && (OPTIONAL_OMIT == field_signallingPriorityIndication.get_selection() || field_signallingPriorityIndication.is_value())
  && (OPTIONAL_OMIT == field_cN__OperatorSelectionEntity.get_selection() || field_cN__OperatorSelectionEntity.is_value())
  && (OPTIONAL_OMIT == field_private__extension__gtpc.get_selection() || field_private__extension__gtpc.is_value());
}
int CreatePDPContextRequest::size_of() const
{
  int ret_val = 5;
  if (field_imsi.ispresent()) ret_val++;
  if (field_rai.ispresent()) ret_val++;
  if (field_recovery.ispresent()) ret_val++;
  if (field_selectionMode.ispresent()) ret_val++;
  if (field_teidControlPlane.ispresent()) ret_val++;
  if (field_linked__nsapi.ispresent()) ret_val++;
  if (field_charging__char.ispresent()) ret_val++;
  if (field_trace__ref.ispresent()) ret_val++;
  if (field_trace__type.ispresent()) ret_val++;
  if (field_endUserAddress.ispresent()) ret_val++;
  if (field_accessPointName.ispresent()) ret_val++;
  if (field_protConfigOptions.ispresent()) ret_val++;
  if (field_msisdn.ispresent()) ret_val++;
  if (field_tft.ispresent()) ret_val++;
  if (field_triggerId.ispresent()) ret_val++;
  if (field_omcId.ispresent()) ret_val++;
  if (field_commonFlags.ispresent()) ret_val++;
  if (field_aPN__Restriction.ispresent()) ret_val++;
  if (field_ratType.ispresent()) ret_val++;
  if (field_userLocationInformation.ispresent()) ret_val++;
  if (field_mS__TimeZone.ispresent()) ret_val++;
  if (field_imeisv.ispresent()) ret_val++;
  if (field_camelChargingInformationContainer.ispresent()) ret_val++;
  if (field_additionalTraceInfo.ispresent()) ret_val++;
  if (field_correlationID.ispresent()) ret_val++;
  if (field_evolvedAllocationRetentionPriorityI.ispresent()) ret_val++;
  if (field_extendedCommonFlags.ispresent()) ret_val++;
  if (field_userCSGInformation.ispresent()) ret_val++;
  if (field_aPN__AMBR.ispresent()) ret_val++;
  if (field_signallingPriorityIndication.ispresent()) ret_val++;
  if (field_cN__OperatorSelectionEntity.ispresent()) ret_val++;
  if (field_private__extension__gtpc.ispresent()) ret_val++;
  return ret_val;
}

void CreatePDPContextRequest::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ imsi := ");
field_imsi.log();
TTCN_Logger::log_event_str(", rai := ");
field_rai.log();
TTCN_Logger::log_event_str(", recovery := ");
field_recovery.log();
TTCN_Logger::log_event_str(", selectionMode := ");
field_selectionMode.log();
TTCN_Logger::log_event_str(", teidDataI := ");
field_teidDataI.log();
TTCN_Logger::log_event_str(", teidControlPlane := ");
field_teidControlPlane.log();
TTCN_Logger::log_event_str(", nsapi := ");
field_nsapi.log();
TTCN_Logger::log_event_str(", linked_nsapi := ");
field_linked__nsapi.log();
TTCN_Logger::log_event_str(", charging_char := ");
field_charging__char.log();
TTCN_Logger::log_event_str(", trace_ref := ");
field_trace__ref.log();
TTCN_Logger::log_event_str(", trace_type := ");
field_trace__type.log();
TTCN_Logger::log_event_str(", endUserAddress := ");
field_endUserAddress.log();
TTCN_Logger::log_event_str(", accessPointName := ");
field_accessPointName.log();
TTCN_Logger::log_event_str(", protConfigOptions := ");
field_protConfigOptions.log();
TTCN_Logger::log_event_str(", sgsn_addr_signalling := ");
field_sgsn__addr__signalling.log();
TTCN_Logger::log_event_str(", sgsn_addr_traffic := ");
field_sgsn__addr__traffic.log();
TTCN_Logger::log_event_str(", msisdn := ");
field_msisdn.log();
TTCN_Logger::log_event_str(", qualityOfServiceProfile := ");
field_qualityOfServiceProfile.log();
TTCN_Logger::log_event_str(", tft := ");
field_tft.log();
TTCN_Logger::log_event_str(", triggerId := ");
field_triggerId.log();
TTCN_Logger::log_event_str(", omcId := ");
field_omcId.log();
TTCN_Logger::log_event_str(", commonFlags := ");
field_commonFlags.log();
TTCN_Logger::log_event_str(", aPN_Restriction := ");
field_aPN__Restriction.log();
TTCN_Logger::log_event_str(", ratType := ");
field_ratType.log();
TTCN_Logger::log_event_str(", userLocationInformation := ");
field_userLocationInformation.log();
TTCN_Logger::log_event_str(", mS_TimeZone := ");
field_mS__TimeZone.log();
TTCN_Logger::log_event_str(", imeisv := ");
field_imeisv.log();
TTCN_Logger::log_event_str(", camelChargingInformationContainer := ");
field_camelChargingInformationContainer.log();
TTCN_Logger::log_event_str(", additionalTraceInfo := ");
field_additionalTraceInfo.log();
TTCN_Logger::log_event_str(", correlationID := ");
field_correlationID.log();
TTCN_Logger::log_event_str(", evolvedAllocationRetentionPriorityI := ");
field_evolvedAllocationRetentionPriorityI.log();
TTCN_Logger::log_event_str(", extendedCommonFlags := ");
field_extendedCommonFlags.log();
TTCN_Logger::log_event_str(", userCSGInformation := ");
field_userCSGInformation.log();
TTCN_Logger::log_event_str(", aPN_AMBR := ");
field_aPN__AMBR.log();
TTCN_Logger::log_event_str(", signallingPriorityIndication := ");
field_signallingPriorityIndication.log();
TTCN_Logger::log_event_str(", cN_OperatorSelectionEntity := ");
field_cN__OperatorSelectionEntity.log();
TTCN_Logger::log_event_str(", private_extension_gtpc := ");
field_private__extension__gtpc.log();
TTCN_Logger::log_event_str(" }");
}

void CreatePDPContextRequest::set_implicit_omit()
{
if (!imsi().is_bound()) imsi() = OMIT_VALUE;
else imsi().set_implicit_omit();
if (!rai().is_bound()) rai() = OMIT_VALUE;
else rai().set_implicit_omit();
if (!recovery().is_bound()) recovery() = OMIT_VALUE;
else recovery().set_implicit_omit();
if (!selectionMode().is_bound()) selectionMode() = OMIT_VALUE;
else selectionMode().set_implicit_omit();
if (teidDataI().is_bound()) teidDataI().set_implicit_omit();
if (!teidControlPlane().is_bound()) teidControlPlane() = OMIT_VALUE;
else teidControlPlane().set_implicit_omit();
if (nsapi().is_bound()) nsapi().set_implicit_omit();
if (!linked__nsapi().is_bound()) linked__nsapi() = OMIT_VALUE;
else linked__nsapi().set_implicit_omit();
if (!charging__char().is_bound()) charging__char() = OMIT_VALUE;
else charging__char().set_implicit_omit();
if (!trace__ref().is_bound()) trace__ref() = OMIT_VALUE;
else trace__ref().set_implicit_omit();
if (!trace__type().is_bound()) trace__type() = OMIT_VALUE;
else trace__type().set_implicit_omit();
if (!endUserAddress().is_bound()) endUserAddress() = OMIT_VALUE;
else endUserAddress().set_implicit_omit();
if (!accessPointName().is_bound()) accessPointName() = OMIT_VALUE;
else accessPointName().set_implicit_omit();
if (!protConfigOptions().is_bound()) protConfigOptions() = OMIT_VALUE;
else protConfigOptions().set_implicit_omit();
if (sgsn__addr__signalling().is_bound()) sgsn__addr__signalling().set_implicit_omit();
if (sgsn__addr__traffic().is_bound()) sgsn__addr__traffic().set_implicit_omit();
if (!msisdn().is_bound()) msisdn() = OMIT_VALUE;
else msisdn().set_implicit_omit();
if (qualityOfServiceProfile().is_bound()) qualityOfServiceProfile().set_implicit_omit();
if (!tft().is_bound()) tft() = OMIT_VALUE;
else tft().set_implicit_omit();
if (!triggerId().is_bound()) triggerId() = OMIT_VALUE;
else triggerId().set_implicit_omit();
if (!omcId().is_bound()) omcId() = OMIT_VALUE;
else omcId().set_implicit_omit();
if (!commonFlags().is_bound()) commonFlags() = OMIT_VALUE;
else commonFlags().set_implicit_omit();
if (!aPN__Restriction().is_bound()) aPN__Restriction() = OMIT_VALUE;
else aPN__Restriction().set_implicit_omit();
if (!ratType().is_bound()) ratType() = OMIT_VALUE;
else ratType().set_implicit_omit();
if (!userLocationInformation().is_bound()) userLocationInformation() = OMIT_VALUE;
else userLocationInformation().set_implicit_omit();
if (!mS__TimeZone().is_bound()) mS__TimeZone() = OMIT_VALUE;
else mS__TimeZone().set_implicit_omit();
if (!imeisv().is_bound()) imeisv() = OMIT_VALUE;
else imeisv().set_implicit_omit();
if (!camelChargingInformationContainer().is_bound()) camelChargingInformationContainer() = OMIT_VALUE;
else camelChargingInformationContainer().set_implicit_omit();
if (!additionalTraceInfo().is_bound()) additionalTraceInfo() = OMIT_VALUE;
else additionalTraceInfo().set_implicit_omit();
if (!correlationID().is_bound()) correlationID() = OMIT_VALUE;
else correlationID().set_implicit_omit();
if (!evolvedAllocationRetentionPriorityI().is_bound()) evolvedAllocationRetentionPriorityI() = OMIT_VALUE;
else evolvedAllocationRetentionPriorityI().set_implicit_omit();
if (!extendedCommonFlags().is_bound()) extendedCommonFlags() = OMIT_VALUE;
else extendedCommonFlags().set_implicit_omit();
if (!userCSGInformation().is_bound()) userCSGInformation() = OMIT_VALUE;
else userCSGInformation().set_implicit_omit();
if (!aPN__AMBR().is_bound()) aPN__AMBR() = OMIT_VALUE;
else aPN__AMBR().set_implicit_omit();
if (!signallingPriorityIndication().is_bound()) signallingPriorityIndication() = OMIT_VALUE;
else signallingPriorityIndication().set_implicit_omit();
if (!cN__OperatorSelectionEntity().is_bound()) cN__OperatorSelectionEntity() = OMIT_VALUE;
else cN__OperatorSelectionEntity().set_implicit_omit();
if (!private__extension__gtpc().is_bound()) private__extension__gtpc() = OMIT_VALUE;
else private__extension__gtpc().set_implicit_omit();
}

void CreatePDPContextRequest::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (37<param.get_size()) {
      param.error("record value of type @GTPC_Types.CreatePDPContextRequest has 37 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) imsi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) rai().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) recovery().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) selectionMode().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) teidDataI().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) teidControlPlane().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) nsapi().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) linked__nsapi().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) charging__char().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) trace__ref().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) trace__type().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) endUserAddress().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) accessPointName().set_param(*param.get_elem(12));
    if (param.get_size()>13 && param.get_elem(13)->get_type()!=Module_Param::MP_NotUsed) protConfigOptions().set_param(*param.get_elem(13));
    if (param.get_size()>14 && param.get_elem(14)->get_type()!=Module_Param::MP_NotUsed) sgsn__addr__signalling().set_param(*param.get_elem(14));
    if (param.get_size()>15 && param.get_elem(15)->get_type()!=Module_Param::MP_NotUsed) sgsn__addr__traffic().set_param(*param.get_elem(15));
    if (param.get_size()>16 && param.get_elem(16)->get_type()!=Module_Param::MP_NotUsed) msisdn().set_param(*param.get_elem(16));
    if (param.get_size()>17 && param.get_elem(17)->get_type()!=Module_Param::MP_NotUsed) qualityOfServiceProfile().set_param(*param.get_elem(17));
    if (param.get_size()>18 && param.get_elem(18)->get_type()!=Module_Param::MP_NotUsed) tft().set_param(*param.get_elem(18));
    if (param.get_size()>19 && param.get_elem(19)->get_type()!=Module_Param::MP_NotUsed) triggerId().set_param(*param.get_elem(19));
    if (param.get_size()>20 && param.get_elem(20)->get_type()!=Module_Param::MP_NotUsed) omcId().set_param(*param.get_elem(20));
    if (param.get_size()>21 && param.get_elem(21)->get_type()!=Module_Param::MP_NotUsed) commonFlags().set_param(*param.get_elem(21));
    if (param.get_size()>22 && param.get_elem(22)->get_type()!=Module_Param::MP_NotUsed) aPN__Restriction().set_param(*param.get_elem(22));
    if (param.get_size()>23 && param.get_elem(23)->get_type()!=Module_Param::MP_NotUsed) ratType().set_param(*param.get_elem(23));
    if (param.get_size()>24 && param.get_elem(24)->get_type()!=Module_Param::MP_NotUsed) userLocationInformation().set_param(*param.get_elem(24));
    if (param.get_size()>25 && param.get_elem(25)->get_type()!=Module_Param::MP_NotUsed) mS__TimeZone().set_param(*param.get_elem(25));
    if (param.get_size()>26 && param.get_elem(26)->get_type()!=Module_Param::MP_NotUsed) imeisv().set_param(*param.get_elem(26));
    if (param.get_size()>27 && param.get_elem(27)->get_type()!=Module_Param::MP_NotUsed) camelChargingInformationContainer().set_param(*param.get_elem(27));
    if (param.get_size()>28 && param.get_elem(28)->get_type()!=Module_Param::MP_NotUsed) additionalTraceInfo().set_param(*param.get_elem(28));
    if (param.get_size()>29 && param.get_elem(29)->get_type()!=Module_Param::MP_NotUsed) correlationID().set_param(*param.get_elem(29));
    if (param.get_size()>30 && param.get_elem(30)->get_type()!=Module_Param::MP_NotUsed) evolvedAllocationRetentionPriorityI().set_param(*param.get_elem(30));
    if (param.get_size()>31 && param.get_elem(31)->get_type()!=Module_Param::MP_NotUsed) extendedCommonFlags().set_param(*param.get_elem(31));
    if (param.get_size()>32 && param.get_elem(32)->get_type()!=Module_Param::MP_NotUsed) userCSGInformation().set_param(*param.get_elem(32));
    if (param.get_size()>33 && param.get_elem(33)->get_type()!=Module_Param::MP_NotUsed) aPN__AMBR().set_param(*param.get_elem(33));
    if (param.get_size()>34 && param.get_elem(34)->get_type()!=Module_Param::MP_NotUsed) signallingPriorityIndication().set_param(*param.get_elem(34));
    if (param.get_size()>35 && param.get_elem(35)->get_type()!=Module_Param::MP_NotUsed) cN__OperatorSelectionEntity().set_param(*param.get_elem(35));
    if (param.get_size()>36 && param.get_elem(36)->get_type()!=Module_Param::MP_NotUsed) private__extension__gtpc().set_param(*param.get_elem(36));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rai")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rai().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "recovery")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          recovery().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "selectionMode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          selectionMode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "teidDataI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          teidDataI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "teidControlPlane")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          teidControlPlane().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsapi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsapi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "linked_nsapi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          linked__nsapi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "charging_char")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          charging__char().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "trace_ref")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          trace__ref().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "trace_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          trace__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "endUserAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          endUserAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "accessPointName")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          accessPointName().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protConfigOptions")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protConfigOptions().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sgsn_addr_signalling")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sgsn__addr__signalling().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sgsn_addr_traffic")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sgsn__addr__traffic().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "msisdn")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          msisdn().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "qualityOfServiceProfile")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          qualityOfServiceProfile().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tft")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tft().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "triggerId")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          triggerId().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "omcId")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          omcId().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "commonFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          commonFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aPN_Restriction")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aPN__Restriction().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ratType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ratType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "userLocationInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          userLocationInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mS_TimeZone")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mS__TimeZone().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imeisv")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imeisv().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "camelChargingInformationContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          camelChargingInformationContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "additionalTraceInfo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          additionalTraceInfo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "correlationID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          correlationID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "evolvedAllocationRetentionPriorityI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          evolvedAllocationRetentionPriorityI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extendedCommonFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extendedCommonFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "userCSGInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          userCSGInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aPN_AMBR")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aPN__AMBR().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "signallingPriorityIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          signallingPriorityIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cN_OperatorSelectionEntity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cN__OperatorSelectionEntity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "private_extension_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          private__extension__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.CreatePDPContextRequest: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.CreatePDPContextRequest");
  }
}

void CreatePDPContextRequest::encode_text(Text_Buf& text_buf) const
{
field_imsi.encode_text(text_buf);
field_rai.encode_text(text_buf);
field_recovery.encode_text(text_buf);
field_selectionMode.encode_text(text_buf);
field_teidDataI.encode_text(text_buf);
field_teidControlPlane.encode_text(text_buf);
field_nsapi.encode_text(text_buf);
field_linked__nsapi.encode_text(text_buf);
field_charging__char.encode_text(text_buf);
field_trace__ref.encode_text(text_buf);
field_trace__type.encode_text(text_buf);
field_endUserAddress.encode_text(text_buf);
field_accessPointName.encode_text(text_buf);
field_protConfigOptions.encode_text(text_buf);
field_sgsn__addr__signalling.encode_text(text_buf);
field_sgsn__addr__traffic.encode_text(text_buf);
field_msisdn.encode_text(text_buf);
field_qualityOfServiceProfile.encode_text(text_buf);
field_tft.encode_text(text_buf);
field_triggerId.encode_text(text_buf);
field_omcId.encode_text(text_buf);
field_commonFlags.encode_text(text_buf);
field_aPN__Restriction.encode_text(text_buf);
field_ratType.encode_text(text_buf);
field_userLocationInformation.encode_text(text_buf);
field_mS__TimeZone.encode_text(text_buf);
field_imeisv.encode_text(text_buf);
field_camelChargingInformationContainer.encode_text(text_buf);
field_additionalTraceInfo.encode_text(text_buf);
field_correlationID.encode_text(text_buf);
field_evolvedAllocationRetentionPriorityI.encode_text(text_buf);
field_extendedCommonFlags.encode_text(text_buf);
field_userCSGInformation.encode_text(text_buf);
field_aPN__AMBR.encode_text(text_buf);
field_signallingPriorityIndication.encode_text(text_buf);
field_cN__OperatorSelectionEntity.encode_text(text_buf);
field_private__extension__gtpc.encode_text(text_buf);
}

void CreatePDPContextRequest::decode_text(Text_Buf& text_buf)
{
field_imsi.decode_text(text_buf);
field_rai.decode_text(text_buf);
field_recovery.decode_text(text_buf);
field_selectionMode.decode_text(text_buf);
field_teidDataI.decode_text(text_buf);
field_teidControlPlane.decode_text(text_buf);
field_nsapi.decode_text(text_buf);
field_linked__nsapi.decode_text(text_buf);
field_charging__char.decode_text(text_buf);
field_trace__ref.decode_text(text_buf);
field_trace__type.decode_text(text_buf);
field_endUserAddress.decode_text(text_buf);
field_accessPointName.decode_text(text_buf);
field_protConfigOptions.decode_text(text_buf);
field_sgsn__addr__signalling.decode_text(text_buf);
field_sgsn__addr__traffic.decode_text(text_buf);
field_msisdn.decode_text(text_buf);
field_qualityOfServiceProfile.decode_text(text_buf);
field_tft.decode_text(text_buf);
field_triggerId.decode_text(text_buf);
field_omcId.decode_text(text_buf);
field_commonFlags.decode_text(text_buf);
field_aPN__Restriction.decode_text(text_buf);
field_ratType.decode_text(text_buf);
field_userLocationInformation.decode_text(text_buf);
field_mS__TimeZone.decode_text(text_buf);
field_imeisv.decode_text(text_buf);
field_camelChargingInformationContainer.decode_text(text_buf);
field_additionalTraceInfo.decode_text(text_buf);
field_correlationID.decode_text(text_buf);
field_evolvedAllocationRetentionPriorityI.decode_text(text_buf);
field_extendedCommonFlags.decode_text(text_buf);
field_userCSGInformation.decode_text(text_buf);
field_aPN__AMBR.decode_text(text_buf);
field_signallingPriorityIndication.decode_text(text_buf);
field_cN__OperatorSelectionEntity.decode_text(text_buf);
field_private__extension__gtpc.decode_text(text_buf);
}

void CreatePDPContextRequest::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void CreatePDPContextRequest::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int CreatePDPContextRequest::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(0)) {
    field_imsi = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_0_force_omit(0, force_omit, IMSI__gtpc_descr_.raw->forceomit);
  decoded_field_length = field_imsi().RAW_decode(IMSI__gtpc_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 1) {
  field_imsi = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_imsi=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_rai = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, RoutingAreaIdentity_descr_.raw->forceomit);
  decoded_field_length = field_rai().RAW_decode(RoutingAreaIdentity_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_rai = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_rai=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_recovery = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, Recovery__gtpc_descr_.raw->forceomit);
  decoded_field_length = field_recovery().RAW_decode(Recovery__gtpc_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_recovery = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_recovery=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_selectionMode = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, SelectionMode_descr_.raw->forceomit);
  decoded_field_length = field_selectionMode().RAW_decode(SelectionMode_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_selectionMode = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_selectionMode=OMIT_VALUE;
  RAW_Force_Omit field_4_force_omit(4, force_omit, TeidDataI_descr_.raw->forceomit);
  decoded_field_length = field_teidDataI.RAW_decode(TeidDataI_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_teidControlPlane = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, TeidControlPlane_descr_.raw->forceomit);
  decoded_field_length = field_teidControlPlane().RAW_decode(TeidControlPlane_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_teidControlPlane = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_teidControlPlane=OMIT_VALUE;
  RAW_Force_Omit field_6_force_omit(6, force_omit, NSAPI__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_nsapi.RAW_decode(NSAPI__GTPC_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(7)) {
    field_linked__nsapi = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_7_force_omit(7, force_omit, NSAPI__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_linked__nsapi().RAW_decode(NSAPI__GTPC_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 1) {
  field_linked__nsapi = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_linked__nsapi=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(8)) {
    field_charging__char = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_8_force_omit(8, force_omit, ChargingCharacteristics__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_charging__char().RAW_decode(ChargingCharacteristics__GTPC_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 1) {
  field_charging__char = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_charging__char=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(9)) {
    field_trace__ref = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_9_force_omit(9, force_omit, TraceRef_descr_.raw->forceomit);
  decoded_field_length = field_trace__ref().RAW_decode(TraceRef_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_9_force_omit);
  if (decoded_field_length < 1) {
  field_trace__ref = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_trace__ref=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(10)) {
    field_trace__type = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_10_force_omit(10, force_omit, GTP__TraceType_descr_.raw->forceomit);
  decoded_field_length = field_trace__type().RAW_decode(GTP__TraceType_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_10_force_omit);
  if (decoded_field_length < 1) {
  field_trace__type = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_trace__type=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(11)) {
    field_endUserAddress = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_11_force_omit(11, force_omit, EndUserAddress_descr_.raw->forceomit);
  decoded_field_length = field_endUserAddress().RAW_decode(EndUserAddress_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_11_force_omit);
  if (decoded_field_length < 1) {
  field_endUserAddress = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_endUserAddress=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(12)) {
    field_accessPointName = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_12_force_omit(12, force_omit, AccessPointName_descr_.raw->forceomit);
  decoded_field_length = field_accessPointName().RAW_decode(AccessPointName_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_12_force_omit);
  if (decoded_field_length < 1) {
  field_accessPointName = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_accessPointName=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(13)) {
    field_protConfigOptions = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_13_force_omit(13, force_omit, ProtConfigOptions_descr_.raw->forceomit);
  decoded_field_length = field_protConfigOptions().RAW_decode(ProtConfigOptions_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_13_force_omit);
  if (decoded_field_length < 1) {
  field_protConfigOptions = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_protConfigOptions=OMIT_VALUE;
  RAW_Force_Omit field_14_force_omit(14, force_omit, GSN__Address__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_sgsn__addr__signalling.RAW_decode(GSN__Address__GTPC_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_14_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_15_force_omit(15, force_omit, GSN__Address__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_sgsn__addr__traffic.RAW_decode(GSN__Address__GTPC_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_15_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(16)) {
    field_msisdn = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_16_force_omit(16, force_omit, MSISDN_descr_.raw->forceomit);
  decoded_field_length = field_msisdn().RAW_decode(MSISDN_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_16_force_omit);
  if (decoded_field_length < 1) {
  field_msisdn = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_msisdn=OMIT_VALUE;
  RAW_Force_Omit field_17_force_omit(17, force_omit, QualityOfServiceProfile_descr_.raw->forceomit);
  decoded_field_length = field_qualityOfServiceProfile.RAW_decode(QualityOfServiceProfile_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_17_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(18)) {
    field_tft = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_18_force_omit(18, force_omit, TrafficFlowTemplate_descr_.raw->forceomit);
  decoded_field_length = field_tft().RAW_decode(TrafficFlowTemplate_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_18_force_omit);
  if (decoded_field_length < 1) {
  field_tft = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_tft=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(19)) {
    field_triggerId = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_19_force_omit(19, force_omit, GTP__TriggerID_descr_.raw->forceomit);
  decoded_field_length = field_triggerId().RAW_decode(GTP__TriggerID_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_19_force_omit);
  if (decoded_field_length < 1) {
  field_triggerId = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_triggerId=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(20)) {
    field_omcId = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_20_force_omit(20, force_omit, OMCIdentity_descr_.raw->forceomit);
  decoded_field_length = field_omcId().RAW_decode(OMCIdentity_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_20_force_omit);
  if (decoded_field_length < 1) {
  field_omcId = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_omcId=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(21)) {
    field_commonFlags = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_21_force_omit(21, force_omit, CommonFlags_descr_.raw->forceomit);
  decoded_field_length = field_commonFlags().RAW_decode(CommonFlags_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_21_force_omit);
  if (decoded_field_length < 1) {
  field_commonFlags = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_commonFlags=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(22)) {
    field_aPN__Restriction = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_22_force_omit(22, force_omit, APN__Restriction_descr_.raw->forceomit);
  decoded_field_length = field_aPN__Restriction().RAW_decode(APN__Restriction_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_22_force_omit);
  if (decoded_field_length < 1) {
  field_aPN__Restriction = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_aPN__Restriction=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(23)) {
    field_ratType = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_23_force_omit(23, force_omit, RATType_descr_.raw->forceomit);
  decoded_field_length = field_ratType().RAW_decode(RATType_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_23_force_omit);
  if (decoded_field_length < 1) {
  field_ratType = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_ratType=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(24)) {
    field_userLocationInformation = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_24_force_omit(24, force_omit, UserLocationInformation_descr_.raw->forceomit);
  decoded_field_length = field_userLocationInformation().RAW_decode(UserLocationInformation_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_24_force_omit);
  if (decoded_field_length < 1) {
  field_userLocationInformation = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_userLocationInformation=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(25)) {
    field_mS__TimeZone = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_25_force_omit(25, force_omit, MS__TimeZone_descr_.raw->forceomit);
  decoded_field_length = field_mS__TimeZone().RAW_decode(MS__TimeZone_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_25_force_omit);
  if (decoded_field_length < 1) {
  field_mS__TimeZone = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_mS__TimeZone=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(26)) {
    field_imeisv = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_26_force_omit(26, force_omit, IMEISV__gtpc_descr_.raw->forceomit);
  decoded_field_length = field_imeisv().RAW_decode(IMEISV__gtpc_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_26_force_omit);
  if (decoded_field_length < 1) {
  field_imeisv = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_imeisv=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(27)) {
    field_camelChargingInformationContainer = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_27_force_omit(27, force_omit, CamelChargingInformationContainer_descr_.raw->forceomit);
  decoded_field_length = field_camelChargingInformationContainer().RAW_decode(CamelChargingInformationContainer_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_27_force_omit);
  if (decoded_field_length < 1) {
  field_camelChargingInformationContainer = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_camelChargingInformationContainer=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(28)) {
    field_additionalTraceInfo = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_28_force_omit(28, force_omit, AdditionalTraceInfo_descr_.raw->forceomit);
  decoded_field_length = field_additionalTraceInfo().RAW_decode(AdditionalTraceInfo_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_28_force_omit);
  if (decoded_field_length < 1) {
  field_additionalTraceInfo = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_additionalTraceInfo=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(29)) {
    field_correlationID = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_29_force_omit(29, force_omit, CorrelationID_descr_.raw->forceomit);
  decoded_field_length = field_correlationID().RAW_decode(CorrelationID_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_29_force_omit);
  if (decoded_field_length < 1) {
  field_correlationID = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_correlationID=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(30)) {
    field_evolvedAllocationRetentionPriorityI = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_30_force_omit(30, force_omit, EvolvedAllocationRetentionPriorityI_descr_.raw->forceomit);
  decoded_field_length = field_evolvedAllocationRetentionPriorityI().RAW_decode(EvolvedAllocationRetentionPriorityI_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_30_force_omit);
  if (decoded_field_length < 1) {
  field_evolvedAllocationRetentionPriorityI = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_evolvedAllocationRetentionPriorityI=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(31)) {
    field_extendedCommonFlags = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_31_force_omit(31, force_omit, ExtendedCommonFlags_descr_.raw->forceomit);
  decoded_field_length = field_extendedCommonFlags().RAW_decode(ExtendedCommonFlags_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_31_force_omit);
  if (decoded_field_length < 1) {
  field_extendedCommonFlags = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_extendedCommonFlags=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(32)) {
    field_userCSGInformation = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_32_force_omit(32, force_omit, UserCSGInformation_descr_.raw->forceomit);
  decoded_field_length = field_userCSGInformation().RAW_decode(UserCSGInformation_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_32_force_omit);
  if (decoded_field_length < 1) {
  field_userCSGInformation = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_userCSGInformation=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(33)) {
    field_aPN__AMBR = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_33_force_omit(33, force_omit, APN__AMBR_descr_.raw->forceomit);
  decoded_field_length = field_aPN__AMBR().RAW_decode(APN__AMBR_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_33_force_omit);
  if (decoded_field_length < 1) {
  field_aPN__AMBR = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_aPN__AMBR=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(34)) {
    field_signallingPriorityIndication = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_34_force_omit(34, force_omit, SignallingPriorityIndication_descr_.raw->forceomit);
  decoded_field_length = field_signallingPriorityIndication().RAW_decode(SignallingPriorityIndication_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_34_force_omit);
  if (decoded_field_length < 1) {
  field_signallingPriorityIndication = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_signallingPriorityIndication=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(35)) {
    field_cN__OperatorSelectionEntity = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_35_force_omit(35, force_omit, CN__OperatorSelectionEntity_descr_.raw->forceomit);
  decoded_field_length = field_cN__OperatorSelectionEntity().RAW_decode(CN__OperatorSelectionEntity_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_35_force_omit);
  if (decoded_field_length < 1) {
  field_cN__OperatorSelectionEntity = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_cN__OperatorSelectionEntity=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(36)) {
    field_private__extension__gtpc = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_36_force_omit(36, force_omit, PrivateExtension__gtpc__List_descr_.raw->forceomit);
  decoded_field_length = field_private__extension__gtpc().RAW_decode(PrivateExtension__gtpc__List_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_36_force_omit);
  if (decoded_field_length < 1) {
  field_private__extension__gtpc = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_private__extension__gtpc=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int CreatePDPContextRequest::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 37;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(37);
  if (field_imsi.ispresent()) {
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, IMSI__gtpc_descr_.raw);
  }
  else myleaf.body.node.nodes[0] = NULL;
  if (field_rai.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RoutingAreaIdentity_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  if (field_recovery.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, Recovery__gtpc_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_selectionMode.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, SelectionMode_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, TeidDataI_descr_.raw);
  if (field_teidControlPlane.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, TeidControlPlane_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, NSAPI__GTPC_descr_.raw);
  if (field_linked__nsapi.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, NSAPI__GTPC_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  if (field_charging__char.ispresent()) {
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, ChargingCharacteristics__GTPC_descr_.raw);
  }
  else myleaf.body.node.nodes[8] = NULL;
  if (field_trace__ref.ispresent()) {
  myleaf.body.node.nodes[9] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 9, TraceRef_descr_.raw);
  }
  else myleaf.body.node.nodes[9] = NULL;
  if (field_trace__type.ispresent()) {
  myleaf.body.node.nodes[10] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 10, GTP__TraceType_descr_.raw);
  }
  else myleaf.body.node.nodes[10] = NULL;
  if (field_endUserAddress.ispresent()) {
  myleaf.body.node.nodes[11] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 11, EndUserAddress_descr_.raw);
  }
  else myleaf.body.node.nodes[11] = NULL;
  if (field_accessPointName.ispresent()) {
  myleaf.body.node.nodes[12] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 12, AccessPointName_descr_.raw);
  }
  else myleaf.body.node.nodes[12] = NULL;
  if (field_protConfigOptions.ispresent()) {
  myleaf.body.node.nodes[13] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 13, ProtConfigOptions_descr_.raw);
  }
  else myleaf.body.node.nodes[13] = NULL;
  myleaf.body.node.nodes[14] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 14, GSN__Address__GTPC_descr_.raw);
  myleaf.body.node.nodes[15] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 15, GSN__Address__GTPC_descr_.raw);
  if (field_msisdn.ispresent()) {
  myleaf.body.node.nodes[16] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 16, MSISDN_descr_.raw);
  }
  else myleaf.body.node.nodes[16] = NULL;
  myleaf.body.node.nodes[17] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 17, QualityOfServiceProfile_descr_.raw);
  if (field_tft.ispresent()) {
  myleaf.body.node.nodes[18] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 18, TrafficFlowTemplate_descr_.raw);
  }
  else myleaf.body.node.nodes[18] = NULL;
  if (field_triggerId.ispresent()) {
  myleaf.body.node.nodes[19] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 19, GTP__TriggerID_descr_.raw);
  }
  else myleaf.body.node.nodes[19] = NULL;
  if (field_omcId.ispresent()) {
  myleaf.body.node.nodes[20] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 20, OMCIdentity_descr_.raw);
  }
  else myleaf.body.node.nodes[20] = NULL;
  if (field_commonFlags.ispresent()) {
  myleaf.body.node.nodes[21] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 21, CommonFlags_descr_.raw);
  }
  else myleaf.body.node.nodes[21] = NULL;
  if (field_aPN__Restriction.ispresent()) {
  myleaf.body.node.nodes[22] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 22, APN__Restriction_descr_.raw);
  }
  else myleaf.body.node.nodes[22] = NULL;
  if (field_ratType.ispresent()) {
  myleaf.body.node.nodes[23] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 23, RATType_descr_.raw);
  }
  else myleaf.body.node.nodes[23] = NULL;
  if (field_userLocationInformation.ispresent()) {
  myleaf.body.node.nodes[24] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 24, UserLocationInformation_descr_.raw);
  }
  else myleaf.body.node.nodes[24] = NULL;
  if (field_mS__TimeZone.ispresent()) {
  myleaf.body.node.nodes[25] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 25, MS__TimeZone_descr_.raw);
  }
  else myleaf.body.node.nodes[25] = NULL;
  if (field_imeisv.ispresent()) {
  myleaf.body.node.nodes[26] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 26, IMEISV__gtpc_descr_.raw);
  }
  else myleaf.body.node.nodes[26] = NULL;
  if (field_camelChargingInformationContainer.ispresent()) {
  myleaf.body.node.nodes[27] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 27, CamelChargingInformationContainer_descr_.raw);
  }
  else myleaf.body.node.nodes[27] = NULL;
  if (field_additionalTraceInfo.ispresent()) {
  myleaf.body.node.nodes[28] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 28, AdditionalTraceInfo_descr_.raw);
  }
  else myleaf.body.node.nodes[28] = NULL;
  if (field_correlationID.ispresent()) {
  myleaf.body.node.nodes[29] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 29, CorrelationID_descr_.raw);
  }
  else myleaf.body.node.nodes[29] = NULL;
  if (field_evolvedAllocationRetentionPriorityI.ispresent()) {
  myleaf.body.node.nodes[30] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 30, EvolvedAllocationRetentionPriorityI_descr_.raw);
  }
  else myleaf.body.node.nodes[30] = NULL;
  if (field_extendedCommonFlags.ispresent()) {
  myleaf.body.node.nodes[31] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 31, ExtendedCommonFlags_descr_.raw);
  }
  else myleaf.body.node.nodes[31] = NULL;
  if (field_userCSGInformation.ispresent()) {
  myleaf.body.node.nodes[32] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 32, UserCSGInformation_descr_.raw);
  }
  else myleaf.body.node.nodes[32] = NULL;
  if (field_aPN__AMBR.ispresent()) {
  myleaf.body.node.nodes[33] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 33, APN__AMBR_descr_.raw);
  }
  else myleaf.body.node.nodes[33] = NULL;
  if (field_signallingPriorityIndication.ispresent()) {
  myleaf.body.node.nodes[34] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 34, SignallingPriorityIndication_descr_.raw);
  }
  else myleaf.body.node.nodes[34] = NULL;
  if (field_cN__OperatorSelectionEntity.ispresent()) {
  myleaf.body.node.nodes[35] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 35, CN__OperatorSelectionEntity_descr_.raw);
  }
  else myleaf.body.node.nodes[35] = NULL;
  if (field_private__extension__gtpc.ispresent()) {
  myleaf.body.node.nodes[36] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 36, PrivateExtension__gtpc__List_descr_.raw);
  }
  else myleaf.body.node.nodes[36] = NULL;
  if (field_imsi.ispresent()) {
  encoded_length += field_imsi().RAW_encode(IMSI__gtpc_descr_, *myleaf.body.node.nodes[0]);
  }
  if (field_rai.ispresent()) {
  encoded_length += field_rai().RAW_encode(RoutingAreaIdentity_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_recovery.ispresent()) {
  encoded_length += field_recovery().RAW_encode(Recovery__gtpc_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_selectionMode.ispresent()) {
  encoded_length += field_selectionMode().RAW_encode(SelectionMode_descr_, *myleaf.body.node.nodes[3]);
  }
  encoded_length += field_teidDataI.RAW_encode(TeidDataI_descr_, *myleaf.body.node.nodes[4]);
  if (field_teidControlPlane.ispresent()) {
  encoded_length += field_teidControlPlane().RAW_encode(TeidControlPlane_descr_, *myleaf.body.node.nodes[5]);
  }
  encoded_length += field_nsapi.RAW_encode(NSAPI__GTPC_descr_, *myleaf.body.node.nodes[6]);
  if (field_linked__nsapi.ispresent()) {
  encoded_length += field_linked__nsapi().RAW_encode(NSAPI__GTPC_descr_, *myleaf.body.node.nodes[7]);
  }
  if (field_charging__char.ispresent()) {
  encoded_length += field_charging__char().RAW_encode(ChargingCharacteristics__GTPC_descr_, *myleaf.body.node.nodes[8]);
  }
  if (field_trace__ref.ispresent()) {
  encoded_length += field_trace__ref().RAW_encode(TraceRef_descr_, *myleaf.body.node.nodes[9]);
  }
  if (field_trace__type.ispresent()) {
  encoded_length += field_trace__type().RAW_encode(GTP__TraceType_descr_, *myleaf.body.node.nodes[10]);
  }
  if (field_endUserAddress.ispresent()) {
  encoded_length += field_endUserAddress().RAW_encode(EndUserAddress_descr_, *myleaf.body.node.nodes[11]);
  }
  if (field_accessPointName.ispresent()) {
  encoded_length += field_accessPointName().RAW_encode(AccessPointName_descr_, *myleaf.body.node.nodes[12]);
  }
  if (field_protConfigOptions.ispresent()) {
  encoded_length += field_protConfigOptions().RAW_encode(ProtConfigOptions_descr_, *myleaf.body.node.nodes[13]);
  }
  encoded_length += field_sgsn__addr__signalling.RAW_encode(GSN__Address__GTPC_descr_, *myleaf.body.node.nodes[14]);
  encoded_length += field_sgsn__addr__traffic.RAW_encode(GSN__Address__GTPC_descr_, *myleaf.body.node.nodes[15]);
  if (field_msisdn.ispresent()) {
  encoded_length += field_msisdn().RAW_encode(MSISDN_descr_, *myleaf.body.node.nodes[16]);
  }
  encoded_length += field_qualityOfServiceProfile.RAW_encode(QualityOfServiceProfile_descr_, *myleaf.body.node.nodes[17]);
  if (field_tft.ispresent()) {
  encoded_length += field_tft().RAW_encode(TrafficFlowTemplate_descr_, *myleaf.body.node.nodes[18]);
  }
  if (field_triggerId.ispresent()) {
  encoded_length += field_triggerId().RAW_encode(GTP__TriggerID_descr_, *myleaf.body.node.nodes[19]);
  }
  if (field_omcId.ispresent()) {
  encoded_length += field_omcId().RAW_encode(OMCIdentity_descr_, *myleaf.body.node.nodes[20]);
  }
  if (field_commonFlags.ispresent()) {
  encoded_length += field_commonFlags().RAW_encode(CommonFlags_descr_, *myleaf.body.node.nodes[21]);
  }
  if (field_aPN__Restriction.ispresent()) {
  encoded_length += field_aPN__Restriction().RAW_encode(APN__Restriction_descr_, *myleaf.body.node.nodes[22]);
  }
  if (field_ratType.ispresent()) {
  encoded_length += field_ratType().RAW_encode(RATType_descr_, *myleaf.body.node.nodes[23]);
  }
  if (field_userLocationInformation.ispresent()) {
  encoded_length += field_userLocationInformation().RAW_encode(UserLocationInformation_descr_, *myleaf.body.node.nodes[24]);
  }
  if (field_mS__TimeZone.ispresent()) {
  encoded_length += field_mS__TimeZone().RAW_encode(MS__TimeZone_descr_, *myleaf.body.node.nodes[25]);
  }
  if (field_imeisv.ispresent()) {
  encoded_length += field_imeisv().RAW_encode(IMEISV__gtpc_descr_, *myleaf.body.node.nodes[26]);
  }
  if (field_camelChargingInformationContainer.ispresent()) {
  encoded_length += field_camelChargingInformationContainer().RAW_encode(CamelChargingInformationContainer_descr_, *myleaf.body.node.nodes[27]);
  }
  if (field_additionalTraceInfo.ispresent()) {
  encoded_length += field_additionalTraceInfo().RAW_encode(AdditionalTraceInfo_descr_, *myleaf.body.node.nodes[28]);
  }
  if (field_correlationID.ispresent()) {
  encoded_length += field_correlationID().RAW_encode(CorrelationID_descr_, *myleaf.body.node.nodes[29]);
  }
  if (field_evolvedAllocationRetentionPriorityI.ispresent()) {
  encoded_length += field_evolvedAllocationRetentionPriorityI().RAW_encode(EvolvedAllocationRetentionPriorityI_descr_, *myleaf.body.node.nodes[30]);
  }
  if (field_extendedCommonFlags.ispresent()) {
  encoded_length += field_extendedCommonFlags().RAW_encode(ExtendedCommonFlags_descr_, *myleaf.body.node.nodes[31]);
  }
  if (field_userCSGInformation.ispresent()) {
  encoded_length += field_userCSGInformation().RAW_encode(UserCSGInformation_descr_, *myleaf.body.node.nodes[32]);
  }
  if (field_aPN__AMBR.ispresent()) {
  encoded_length += field_aPN__AMBR().RAW_encode(APN__AMBR_descr_, *myleaf.body.node.nodes[33]);
  }
  if (field_signallingPriorityIndication.ispresent()) {
  encoded_length += field_signallingPriorityIndication().RAW_encode(SignallingPriorityIndication_descr_, *myleaf.body.node.nodes[34]);
  }
  if (field_cN__OperatorSelectionEntity.ispresent()) {
  encoded_length += field_cN__OperatorSelectionEntity().RAW_encode(CN__OperatorSelectionEntity_descr_, *myleaf.body.node.nodes[35]);
  }
  if (field_private__extension__gtpc.ispresent()) {
  encoded_length += field_private__extension__gtpc().RAW_encode(PrivateExtension__gtpc__List_descr_, *myleaf.body.node.nodes[36]);
  }
  return myleaf.length = encoded_length;
}

struct CreatePDPContextRequest_template::single_value_struct {
IMSI__gtpc_template field_imsi;
RoutingAreaIdentity_template field_rai;
Recovery__gtpc_template field_recovery;
SelectionMode_template field_selectionMode;
TeidDataI_template field_teidDataI;
TeidControlPlane_template field_teidControlPlane;
NSAPI__GTPC_template field_nsapi;
NSAPI__GTPC_template field_linked__nsapi;
ChargingCharacteristics__GTPC_template field_charging__char;
TraceRef_template field_trace__ref;
GTP__TraceType_template field_trace__type;
EndUserAddress_template field_endUserAddress;
AccessPointName_template field_accessPointName;
ProtConfigOptions_template field_protConfigOptions;
GSN__Address__GTPC_template field_sgsn__addr__signalling;
GSN__Address__GTPC_template field_sgsn__addr__traffic;
MSISDN_template field_msisdn;
QualityOfServiceProfile_template field_qualityOfServiceProfile;
TrafficFlowTemplate_template field_tft;
GTP__TriggerID_template field_triggerId;
OMCIdentity_template field_omcId;
CommonFlags_template field_commonFlags;
APN__Restriction_template field_aPN__Restriction;
RATType_template field_ratType;
UserLocationInformation_template field_userLocationInformation;
MS__TimeZone_template field_mS__TimeZone;
IMEISV__gtpc_template field_imeisv;
CamelChargingInformationContainer_template field_camelChargingInformationContainer;
AdditionalTraceInfo_template field_additionalTraceInfo;
CorrelationID_template field_correlationID;
EvolvedAllocationRetentionPriorityI_template field_evolvedAllocationRetentionPriorityI;
ExtendedCommonFlags_template field_extendedCommonFlags;
UserCSGInformation_template field_userCSGInformation;
APN__AMBR_template field_aPN__AMBR;
SignallingPriorityIndication_template field_signallingPriorityIndication;
CN__OperatorSelectionEntity_template field_cN__OperatorSelectionEntity;
PrivateExtension__gtpc__List_template field_private__extension__gtpc;
};

void CreatePDPContextRequest_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_imsi = ANY_OR_OMIT;
single_value->field_rai = ANY_OR_OMIT;
single_value->field_recovery = ANY_OR_OMIT;
single_value->field_selectionMode = ANY_OR_OMIT;
single_value->field_teidDataI = ANY_VALUE;
single_value->field_teidControlPlane = ANY_OR_OMIT;
single_value->field_nsapi = ANY_VALUE;
single_value->field_linked__nsapi = ANY_OR_OMIT;
single_value->field_charging__char = ANY_OR_OMIT;
single_value->field_trace__ref = ANY_OR_OMIT;
single_value->field_trace__type = ANY_OR_OMIT;
single_value->field_endUserAddress = ANY_OR_OMIT;
single_value->field_accessPointName = ANY_OR_OMIT;
single_value->field_protConfigOptions = ANY_OR_OMIT;
single_value->field_sgsn__addr__signalling = ANY_VALUE;
single_value->field_sgsn__addr__traffic = ANY_VALUE;
single_value->field_msisdn = ANY_OR_OMIT;
single_value->field_qualityOfServiceProfile = ANY_VALUE;
single_value->field_tft = ANY_OR_OMIT;
single_value->field_triggerId = ANY_OR_OMIT;
single_value->field_omcId = ANY_OR_OMIT;
single_value->field_commonFlags = ANY_OR_OMIT;
single_value->field_aPN__Restriction = ANY_OR_OMIT;
single_value->field_ratType = ANY_OR_OMIT;
single_value->field_userLocationInformation = ANY_OR_OMIT;
single_value->field_mS__TimeZone = ANY_OR_OMIT;
single_value->field_imeisv = ANY_OR_OMIT;
single_value->field_camelChargingInformationContainer = ANY_OR_OMIT;
single_value->field_additionalTraceInfo = ANY_OR_OMIT;
single_value->field_correlationID = ANY_OR_OMIT;
single_value->field_evolvedAllocationRetentionPriorityI = ANY_OR_OMIT;
single_value->field_extendedCommonFlags = ANY_OR_OMIT;
single_value->field_userCSGInformation = ANY_OR_OMIT;
single_value->field_aPN__AMBR = ANY_OR_OMIT;
single_value->field_signallingPriorityIndication = ANY_OR_OMIT;
single_value->field_cN__OperatorSelectionEntity = ANY_OR_OMIT;
single_value->field_private__extension__gtpc = ANY_OR_OMIT;
}
}
}

void CreatePDPContextRequest_template::copy_value(const CreatePDPContextRequest& other_value)
{
single_value = new single_value_struct;
if (other_value.imsi().is_bound()) {
  if (other_value.imsi().ispresent()) single_value->field_imsi = other_value.imsi()();
  else single_value->field_imsi = OMIT_VALUE;
} else {
  single_value->field_imsi.clean_up();
}
if (other_value.rai().is_bound()) {
  if (other_value.rai().ispresent()) single_value->field_rai = other_value.rai()();
  else single_value->field_rai = OMIT_VALUE;
} else {
  single_value->field_rai.clean_up();
}
if (other_value.recovery().is_bound()) {
  if (other_value.recovery().ispresent()) single_value->field_recovery = other_value.recovery()();
  else single_value->field_recovery = OMIT_VALUE;
} else {
  single_value->field_recovery.clean_up();
}
if (other_value.selectionMode().is_bound()) {
  if (other_value.selectionMode().ispresent()) single_value->field_selectionMode = other_value.selectionMode()();
  else single_value->field_selectionMode = OMIT_VALUE;
} else {
  single_value->field_selectionMode.clean_up();
}
if (other_value.teidDataI().is_bound()) {
  single_value->field_teidDataI = other_value.teidDataI();
} else {
  single_value->field_teidDataI.clean_up();
}
if (other_value.teidControlPlane().is_bound()) {
  if (other_value.teidControlPlane().ispresent()) single_value->field_teidControlPlane = other_value.teidControlPlane()();
  else single_value->field_teidControlPlane = OMIT_VALUE;
} else {
  single_value->field_teidControlPlane.clean_up();
}
if (other_value.nsapi().is_bound()) {
  single_value->field_nsapi = other_value.nsapi();
} else {
  single_value->field_nsapi.clean_up();
}
if (other_value.linked__nsapi().is_bound()) {
  if (other_value.linked__nsapi().ispresent()) single_value->field_linked__nsapi = other_value.linked__nsapi()();
  else single_value->field_linked__nsapi = OMIT_VALUE;
} else {
  single_value->field_linked__nsapi.clean_up();
}
if (other_value.charging__char().is_bound()) {
  if (other_value.charging__char().ispresent()) single_value->field_charging__char = other_value.charging__char()();
  else single_value->field_charging__char = OMIT_VALUE;
} else {
  single_value->field_charging__char.clean_up();
}
if (other_value.trace__ref().is_bound()) {
  if (other_value.trace__ref().ispresent()) single_value->field_trace__ref = other_value.trace__ref()();
  else single_value->field_trace__ref = OMIT_VALUE;
} else {
  single_value->field_trace__ref.clean_up();
}
if (other_value.trace__type().is_bound()) {
  if (other_value.trace__type().ispresent()) single_value->field_trace__type = other_value.trace__type()();
  else single_value->field_trace__type = OMIT_VALUE;
} else {
  single_value->field_trace__type.clean_up();
}
if (other_value.endUserAddress().is_bound()) {
  if (other_value.endUserAddress().ispresent()) single_value->field_endUserAddress = other_value.endUserAddress()();
  else single_value->field_endUserAddress = OMIT_VALUE;
} else {
  single_value->field_endUserAddress.clean_up();
}
if (other_value.accessPointName().is_bound()) {
  if (other_value.accessPointName().ispresent()) single_value->field_accessPointName = other_value.accessPointName()();
  else single_value->field_accessPointName = OMIT_VALUE;
} else {
  single_value->field_accessPointName.clean_up();
}
if (other_value.protConfigOptions().is_bound()) {
  if (other_value.protConfigOptions().ispresent()) single_value->field_protConfigOptions = other_value.protConfigOptions()();
  else single_value->field_protConfigOptions = OMIT_VALUE;
} else {
  single_value->field_protConfigOptions.clean_up();
}
if (other_value.sgsn__addr__signalling().is_bound()) {
  single_value->field_sgsn__addr__signalling = other_value.sgsn__addr__signalling();
} else {
  single_value->field_sgsn__addr__signalling.clean_up();
}
if (other_value.sgsn__addr__traffic().is_bound()) {
  single_value->field_sgsn__addr__traffic = other_value.sgsn__addr__traffic();
} else {
  single_value->field_sgsn__addr__traffic.clean_up();
}
if (other_value.msisdn().is_bound()) {
  if (other_value.msisdn().ispresent()) single_value->field_msisdn = other_value.msisdn()();
  else single_value->field_msisdn = OMIT_VALUE;
} else {
  single_value->field_msisdn.clean_up();
}
if (other_value.qualityOfServiceProfile().is_bound()) {
  single_value->field_qualityOfServiceProfile = other_value.qualityOfServiceProfile();
} else {
  single_value->field_qualityOfServiceProfile.clean_up();
}
if (other_value.tft().is_bound()) {
  if (other_value.tft().ispresent()) single_value->field_tft = other_value.tft()();
  else single_value->field_tft = OMIT_VALUE;
} else {
  single_value->field_tft.clean_up();
}
if (other_value.triggerId().is_bound()) {
  if (other_value.triggerId().ispresent()) single_value->field_triggerId = other_value.triggerId()();
  else single_value->field_triggerId = OMIT_VALUE;
} else {
  single_value->field_triggerId.clean_up();
}
if (other_value.omcId().is_bound()) {
  if (other_value.omcId().ispresent()) single_value->field_omcId = other_value.omcId()();
  else single_value->field_omcId = OMIT_VALUE;
} else {
  single_value->field_omcId.clean_up();
}
if (other_value.commonFlags().is_bound()) {
  if (other_value.commonFlags().ispresent()) single_value->field_commonFlags = other_value.commonFlags()();
  else single_value->field_commonFlags = OMIT_VALUE;
} else {
  single_value->field_commonFlags.clean_up();
}
if (other_value.aPN__Restriction().is_bound()) {
  if (other_value.aPN__Restriction().ispresent()) single_value->field_aPN__Restriction = other_value.aPN__Restriction()();
  else single_value->field_aPN__Restriction = OMIT_VALUE;
} else {
  single_value->field_aPN__Restriction.clean_up();
}
if (other_value.ratType().is_bound()) {
  if (other_value.ratType().ispresent()) single_value->field_ratType = other_value.ratType()();
  else single_value->field_ratType = OMIT_VALUE;
} else {
  single_value->field_ratType.clean_up();
}
if (other_value.userLocationInformation().is_bound()) {
  if (other_value.userLocationInformation().ispresent()) single_value->field_userLocationInformation = other_value.userLocationInformation()();
  else single_value->field_userLocationInformation = OMIT_VALUE;
} else {
  single_value->field_userLocationInformation.clean_up();
}
if (other_value.mS__TimeZone().is_bound()) {
  if (other_value.mS__TimeZone().ispresent()) single_value->field_mS__TimeZone = other_value.mS__TimeZone()();
  else single_value->field_mS__TimeZone = OMIT_VALUE;
} else {
  single_value->field_mS__TimeZone.clean_up();
}
if (other_value.imeisv().is_bound()) {
  if (other_value.imeisv().ispresent()) single_value->field_imeisv = other_value.imeisv()();
  else single_value->field_imeisv = OMIT_VALUE;
} else {
  single_value->field_imeisv.clean_up();
}
if (other_value.camelChargingInformationContainer().is_bound()) {
  if (other_value.camelChargingInformationContainer().ispresent()) single_value->field_camelChargingInformationContainer = other_value.camelChargingInformationContainer()();
  else single_value->field_camelChargingInformationContainer = OMIT_VALUE;
} else {
  single_value->field_camelChargingInformationContainer.clean_up();
}
if (other_value.additionalTraceInfo().is_bound()) {
  if (other_value.additionalTraceInfo().ispresent()) single_value->field_additionalTraceInfo = other_value.additionalTraceInfo()();
  else single_value->field_additionalTraceInfo = OMIT_VALUE;
} else {
  single_value->field_additionalTraceInfo.clean_up();
}
if (other_value.correlationID().is_bound()) {
  if (other_value.correlationID().ispresent()) single_value->field_correlationID = other_value.correlationID()();
  else single_value->field_correlationID = OMIT_VALUE;
} else {
  single_value->field_correlationID.clean_up();
}
if (other_value.evolvedAllocationRetentionPriorityI().is_bound()) {
  if (other_value.evolvedAllocationRetentionPriorityI().ispresent()) single_value->field_evolvedAllocationRetentionPriorityI = other_value.evolvedAllocationRetentionPriorityI()();
  else single_value->field_evolvedAllocationRetentionPriorityI = OMIT_VALUE;
} else {
  single_value->field_evolvedAllocationRetentionPriorityI.clean_up();
}
if (other_value.extendedCommonFlags().is_bound()) {
  if (other_value.extendedCommonFlags().ispresent()) single_value->field_extendedCommonFlags = other_value.extendedCommonFlags()();
  else single_value->field_extendedCommonFlags = OMIT_VALUE;
} else {
  single_value->field_extendedCommonFlags.clean_up();
}
if (other_value.userCSGInformation().is_bound()) {
  if (other_value.userCSGInformation().ispresent()) single_value->field_userCSGInformation = other_value.userCSGInformation()();
  else single_value->field_userCSGInformation = OMIT_VALUE;
} else {
  single_value->field_userCSGInformation.clean_up();
}
if (other_value.aPN__AMBR().is_bound()) {
  if (other_value.aPN__AMBR().ispresent()) single_value->field_aPN__AMBR = other_value.aPN__AMBR()();
  else single_value->field_aPN__AMBR = OMIT_VALUE;
} else {
  single_value->field_aPN__AMBR.clean_up();
}
if (other_value.signallingPriorityIndication().is_bound()) {
  if (other_value.signallingPriorityIndication().ispresent()) single_value->field_signallingPriorityIndication = other_value.signallingPriorityIndication()();
  else single_value->field_signallingPriorityIndication = OMIT_VALUE;
} else {
  single_value->field_signallingPriorityIndication.clean_up();
}
if (other_value.cN__OperatorSelectionEntity().is_bound()) {
  if (other_value.cN__OperatorSelectionEntity().ispresent()) single_value->field_cN__OperatorSelectionEntity = other_value.cN__OperatorSelectionEntity()();
  else single_value->field_cN__OperatorSelectionEntity = OMIT_VALUE;
} else {
  single_value->field_cN__OperatorSelectionEntity.clean_up();
}
if (other_value.private__extension__gtpc().is_bound()) {
  if (other_value.private__extension__gtpc().ispresent()) single_value->field_private__extension__gtpc = other_value.private__extension__gtpc()();
  else single_value->field_private__extension__gtpc = OMIT_VALUE;
} else {
  single_value->field_private__extension__gtpc.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void CreatePDPContextRequest_template::copy_template(const CreatePDPContextRequest_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.imsi().get_selection()) {
single_value->field_imsi = other_value.imsi();
} else {
single_value->field_imsi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rai().get_selection()) {
single_value->field_rai = other_value.rai();
} else {
single_value->field_rai.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.recovery().get_selection()) {
single_value->field_recovery = other_value.recovery();
} else {
single_value->field_recovery.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.selectionMode().get_selection()) {
single_value->field_selectionMode = other_value.selectionMode();
} else {
single_value->field_selectionMode.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.teidDataI().get_selection()) {
single_value->field_teidDataI = other_value.teidDataI();
} else {
single_value->field_teidDataI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.teidControlPlane().get_selection()) {
single_value->field_teidControlPlane = other_value.teidControlPlane();
} else {
single_value->field_teidControlPlane.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsapi().get_selection()) {
single_value->field_nsapi = other_value.nsapi();
} else {
single_value->field_nsapi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.linked__nsapi().get_selection()) {
single_value->field_linked__nsapi = other_value.linked__nsapi();
} else {
single_value->field_linked__nsapi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.charging__char().get_selection()) {
single_value->field_charging__char = other_value.charging__char();
} else {
single_value->field_charging__char.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.trace__ref().get_selection()) {
single_value->field_trace__ref = other_value.trace__ref();
} else {
single_value->field_trace__ref.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.trace__type().get_selection()) {
single_value->field_trace__type = other_value.trace__type();
} else {
single_value->field_trace__type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.endUserAddress().get_selection()) {
single_value->field_endUserAddress = other_value.endUserAddress();
} else {
single_value->field_endUserAddress.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.accessPointName().get_selection()) {
single_value->field_accessPointName = other_value.accessPointName();
} else {
single_value->field_accessPointName.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.protConfigOptions().get_selection()) {
single_value->field_protConfigOptions = other_value.protConfigOptions();
} else {
single_value->field_protConfigOptions.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sgsn__addr__signalling().get_selection()) {
single_value->field_sgsn__addr__signalling = other_value.sgsn__addr__signalling();
} else {
single_value->field_sgsn__addr__signalling.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sgsn__addr__traffic().get_selection()) {
single_value->field_sgsn__addr__traffic = other_value.sgsn__addr__traffic();
} else {
single_value->field_sgsn__addr__traffic.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.msisdn().get_selection()) {
single_value->field_msisdn = other_value.msisdn();
} else {
single_value->field_msisdn.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.qualityOfServiceProfile().get_selection()) {
single_value->field_qualityOfServiceProfile = other_value.qualityOfServiceProfile();
} else {
single_value->field_qualityOfServiceProfile.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tft().get_selection()) {
single_value->field_tft = other_value.tft();
} else {
single_value->field_tft.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.triggerId().get_selection()) {
single_value->field_triggerId = other_value.triggerId();
} else {
single_value->field_triggerId.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.omcId().get_selection()) {
single_value->field_omcId = other_value.omcId();
} else {
single_value->field_omcId.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.commonFlags().get_selection()) {
single_value->field_commonFlags = other_value.commonFlags();
} else {
single_value->field_commonFlags.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.aPN__Restriction().get_selection()) {
single_value->field_aPN__Restriction = other_value.aPN__Restriction();
} else {
single_value->field_aPN__Restriction.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ratType().get_selection()) {
single_value->field_ratType = other_value.ratType();
} else {
single_value->field_ratType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.userLocationInformation().get_selection()) {
single_value->field_userLocationInformation = other_value.userLocationInformation();
} else {
single_value->field_userLocationInformation.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mS__TimeZone().get_selection()) {
single_value->field_mS__TimeZone = other_value.mS__TimeZone();
} else {
single_value->field_mS__TimeZone.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.imeisv().get_selection()) {
single_value->field_imeisv = other_value.imeisv();
} else {
single_value->field_imeisv.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.camelChargingInformationContainer().get_selection()) {
single_value->field_camelChargingInformationContainer = other_value.camelChargingInformationContainer();
} else {
single_value->field_camelChargingInformationContainer.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.additionalTraceInfo().get_selection()) {
single_value->field_additionalTraceInfo = other_value.additionalTraceInfo();
} else {
single_value->field_additionalTraceInfo.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.correlationID().get_selection()) {
single_value->field_correlationID = other_value.correlationID();
} else {
single_value->field_correlationID.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.evolvedAllocationRetentionPriorityI().get_selection()) {
single_value->field_evolvedAllocationRetentionPriorityI = other_value.evolvedAllocationRetentionPriorityI();
} else {
single_value->field_evolvedAllocationRetentionPriorityI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extendedCommonFlags().get_selection()) {
single_value->field_extendedCommonFlags = other_value.extendedCommonFlags();
} else {
single_value->field_extendedCommonFlags.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.userCSGInformation().get_selection()) {
single_value->field_userCSGInformation = other_value.userCSGInformation();
} else {
single_value->field_userCSGInformation.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.aPN__AMBR().get_selection()) {
single_value->field_aPN__AMBR = other_value.aPN__AMBR();
} else {
single_value->field_aPN__AMBR.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.signallingPriorityIndication().get_selection()) {
single_value->field_signallingPriorityIndication = other_value.signallingPriorityIndication();
} else {
single_value->field_signallingPriorityIndication.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cN__OperatorSelectionEntity().get_selection()) {
single_value->field_cN__OperatorSelectionEntity = other_value.cN__OperatorSelectionEntity();
} else {
single_value->field_cN__OperatorSelectionEntity.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.private__extension__gtpc().get_selection()) {
single_value->field_private__extension__gtpc = other_value.private__extension__gtpc();
} else {
single_value->field_private__extension__gtpc.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new CreatePDPContextRequest_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new CreatePDPContextRequest_template(*other_value.implication_.precondition);
implication_.implied_template = new CreatePDPContextRequest_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.CreatePDPContextRequest.");
break;
}
set_selection(other_value);
}

CreatePDPContextRequest_template::CreatePDPContextRequest_template()
{
}

CreatePDPContextRequest_template::CreatePDPContextRequest_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

CreatePDPContextRequest_template::CreatePDPContextRequest_template(const CreatePDPContextRequest& other_value)
{
copy_value(other_value);
}

CreatePDPContextRequest_template::CreatePDPContextRequest_template(const OPTIONAL<CreatePDPContextRequest>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CreatePDPContextRequest&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.CreatePDPContextRequest from an unbound optional field.");
}
}

CreatePDPContextRequest_template::CreatePDPContextRequest_template(CreatePDPContextRequest_template* p_precondition, CreatePDPContextRequest_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

CreatePDPContextRequest_template::CreatePDPContextRequest_template(Dynamic_Match_Interface<CreatePDPContextRequest>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<CreatePDPContextRequest>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

CreatePDPContextRequest_template::CreatePDPContextRequest_template(const CreatePDPContextRequest_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

CreatePDPContextRequest_template::~CreatePDPContextRequest_template()
{
clean_up();
}

CreatePDPContextRequest_template& CreatePDPContextRequest_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

CreatePDPContextRequest_template& CreatePDPContextRequest_template::operator=(const CreatePDPContextRequest& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

CreatePDPContextRequest_template& CreatePDPContextRequest_template::operator=(const OPTIONAL<CreatePDPContextRequest>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CreatePDPContextRequest&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.CreatePDPContextRequest.");
}
return *this;
}

CreatePDPContextRequest_template& CreatePDPContextRequest_template::operator=(const CreatePDPContextRequest_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean CreatePDPContextRequest_template::match(const CreatePDPContextRequest& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.imsi().is_bound()) return FALSE;
if((other_value.imsi().ispresent() ? !single_value->field_imsi.match((const IMSI__gtpc&)other_value.imsi(), legacy) : !single_value->field_imsi.match_omit(legacy)))return FALSE;
if(!other_value.rai().is_bound()) return FALSE;
if((other_value.rai().ispresent() ? !single_value->field_rai.match((const RoutingAreaIdentity&)other_value.rai(), legacy) : !single_value->field_rai.match_omit(legacy)))return FALSE;
if(!other_value.recovery().is_bound()) return FALSE;
if((other_value.recovery().ispresent() ? !single_value->field_recovery.match((const Recovery__gtpc&)other_value.recovery(), legacy) : !single_value->field_recovery.match_omit(legacy)))return FALSE;
if(!other_value.selectionMode().is_bound()) return FALSE;
if((other_value.selectionMode().ispresent() ? !single_value->field_selectionMode.match((const SelectionMode&)other_value.selectionMode(), legacy) : !single_value->field_selectionMode.match_omit(legacy)))return FALSE;
if(!other_value.teidDataI().is_bound()) return FALSE;
if(!single_value->field_teidDataI.match(other_value.teidDataI(), legacy))return FALSE;
if(!other_value.teidControlPlane().is_bound()) return FALSE;
if((other_value.teidControlPlane().ispresent() ? !single_value->field_teidControlPlane.match((const TeidControlPlane&)other_value.teidControlPlane(), legacy) : !single_value->field_teidControlPlane.match_omit(legacy)))return FALSE;
if(!other_value.nsapi().is_bound()) return FALSE;
if(!single_value->field_nsapi.match(other_value.nsapi(), legacy))return FALSE;
if(!other_value.linked__nsapi().is_bound()) return FALSE;
if((other_value.linked__nsapi().ispresent() ? !single_value->field_linked__nsapi.match((const NSAPI__GTPC&)other_value.linked__nsapi(), legacy) : !single_value->field_linked__nsapi.match_omit(legacy)))return FALSE;
if(!other_value.charging__char().is_bound()) return FALSE;
if((other_value.charging__char().ispresent() ? !single_value->field_charging__char.match((const ChargingCharacteristics__GTPC&)other_value.charging__char(), legacy) : !single_value->field_charging__char.match_omit(legacy)))return FALSE;
if(!other_value.trace__ref().is_bound()) return FALSE;
if((other_value.trace__ref().ispresent() ? !single_value->field_trace__ref.match((const TraceRef&)other_value.trace__ref(), legacy) : !single_value->field_trace__ref.match_omit(legacy)))return FALSE;
if(!other_value.trace__type().is_bound()) return FALSE;
if((other_value.trace__type().ispresent() ? !single_value->field_trace__type.match((const GTP__TraceType&)other_value.trace__type(), legacy) : !single_value->field_trace__type.match_omit(legacy)))return FALSE;
if(!other_value.endUserAddress().is_bound()) return FALSE;
if((other_value.endUserAddress().ispresent() ? !single_value->field_endUserAddress.match((const EndUserAddress&)other_value.endUserAddress(), legacy) : !single_value->field_endUserAddress.match_omit(legacy)))return FALSE;
if(!other_value.accessPointName().is_bound()) return FALSE;
if((other_value.accessPointName().ispresent() ? !single_value->field_accessPointName.match((const AccessPointName&)other_value.accessPointName(), legacy) : !single_value->field_accessPointName.match_omit(legacy)))return FALSE;
if(!other_value.protConfigOptions().is_bound()) return FALSE;
if((other_value.protConfigOptions().ispresent() ? !single_value->field_protConfigOptions.match((const ProtConfigOptions&)other_value.protConfigOptions(), legacy) : !single_value->field_protConfigOptions.match_omit(legacy)))return FALSE;
if(!other_value.sgsn__addr__signalling().is_bound()) return FALSE;
if(!single_value->field_sgsn__addr__signalling.match(other_value.sgsn__addr__signalling(), legacy))return FALSE;
if(!other_value.sgsn__addr__traffic().is_bound()) return FALSE;
if(!single_value->field_sgsn__addr__traffic.match(other_value.sgsn__addr__traffic(), legacy))return FALSE;
if(!other_value.msisdn().is_bound()) return FALSE;
if((other_value.msisdn().ispresent() ? !single_value->field_msisdn.match((const MSISDN&)other_value.msisdn(), legacy) : !single_value->field_msisdn.match_omit(legacy)))return FALSE;
if(!other_value.qualityOfServiceProfile().is_bound()) return FALSE;
if(!single_value->field_qualityOfServiceProfile.match(other_value.qualityOfServiceProfile(), legacy))return FALSE;
if(!other_value.tft().is_bound()) return FALSE;
if((other_value.tft().ispresent() ? !single_value->field_tft.match((const TrafficFlowTemplate&)other_value.tft(), legacy) : !single_value->field_tft.match_omit(legacy)))return FALSE;
if(!other_value.triggerId().is_bound()) return FALSE;
if((other_value.triggerId().ispresent() ? !single_value->field_triggerId.match((const GTP__TriggerID&)other_value.triggerId(), legacy) : !single_value->field_triggerId.match_omit(legacy)))return FALSE;
if(!other_value.omcId().is_bound()) return FALSE;
if((other_value.omcId().ispresent() ? !single_value->field_omcId.match((const OMCIdentity&)other_value.omcId(), legacy) : !single_value->field_omcId.match_omit(legacy)))return FALSE;
if(!other_value.commonFlags().is_bound()) return FALSE;
if((other_value.commonFlags().ispresent() ? !single_value->field_commonFlags.match((const CommonFlags&)other_value.commonFlags(), legacy) : !single_value->field_commonFlags.match_omit(legacy)))return FALSE;
if(!other_value.aPN__Restriction().is_bound()) return FALSE;
if((other_value.aPN__Restriction().ispresent() ? !single_value->field_aPN__Restriction.match((const APN__Restriction&)other_value.aPN__Restriction(), legacy) : !single_value->field_aPN__Restriction.match_omit(legacy)))return FALSE;
if(!other_value.ratType().is_bound()) return FALSE;
if((other_value.ratType().ispresent() ? !single_value->field_ratType.match((const RATType&)other_value.ratType(), legacy) : !single_value->field_ratType.match_omit(legacy)))return FALSE;
if(!other_value.userLocationInformation().is_bound()) return FALSE;
if((other_value.userLocationInformation().ispresent() ? !single_value->field_userLocationInformation.match((const UserLocationInformation&)other_value.userLocationInformation(), legacy) : !single_value->field_userLocationInformation.match_omit(legacy)))return FALSE;
if(!other_value.mS__TimeZone().is_bound()) return FALSE;
if((other_value.mS__TimeZone().ispresent() ? !single_value->field_mS__TimeZone.match((const MS__TimeZone&)other_value.mS__TimeZone(), legacy) : !single_value->field_mS__TimeZone.match_omit(legacy)))return FALSE;
if(!other_value.imeisv().is_bound()) return FALSE;
if((other_value.imeisv().ispresent() ? !single_value->field_imeisv.match((const IMEISV__gtpc&)other_value.imeisv(), legacy) : !single_value->field_imeisv.match_omit(legacy)))return FALSE;
if(!other_value.camelChargingInformationContainer().is_bound()) return FALSE;
if((other_value.camelChargingInformationContainer().ispresent() ? !single_value->field_camelChargingInformationContainer.match((const CamelChargingInformationContainer&)other_value.camelChargingInformationContainer(), legacy) : !single_value->field_camelChargingInformationContainer.match_omit(legacy)))return FALSE;
if(!other_value.additionalTraceInfo().is_bound()) return FALSE;
if((other_value.additionalTraceInfo().ispresent() ? !single_value->field_additionalTraceInfo.match((const AdditionalTraceInfo&)other_value.additionalTraceInfo(), legacy) : !single_value->field_additionalTraceInfo.match_omit(legacy)))return FALSE;
if(!other_value.correlationID().is_bound()) return FALSE;
if((other_value.correlationID().ispresent() ? !single_value->field_correlationID.match((const CorrelationID&)other_value.correlationID(), legacy) : !single_value->field_correlationID.match_omit(legacy)))return FALSE;
if(!other_value.evolvedAllocationRetentionPriorityI().is_bound()) return FALSE;
if((other_value.evolvedAllocationRetentionPriorityI().ispresent() ? !single_value->field_evolvedAllocationRetentionPriorityI.match((const EvolvedAllocationRetentionPriorityI&)other_value.evolvedAllocationRetentionPriorityI(), legacy) : !single_value->field_evolvedAllocationRetentionPriorityI.match_omit(legacy)))return FALSE;
if(!other_value.extendedCommonFlags().is_bound()) return FALSE;
if((other_value.extendedCommonFlags().ispresent() ? !single_value->field_extendedCommonFlags.match((const ExtendedCommonFlags&)other_value.extendedCommonFlags(), legacy) : !single_value->field_extendedCommonFlags.match_omit(legacy)))return FALSE;
if(!other_value.userCSGInformation().is_bound()) return FALSE;
if((other_value.userCSGInformation().ispresent() ? !single_value->field_userCSGInformation.match((const UserCSGInformation&)other_value.userCSGInformation(), legacy) : !single_value->field_userCSGInformation.match_omit(legacy)))return FALSE;
if(!other_value.aPN__AMBR().is_bound()) return FALSE;
if((other_value.aPN__AMBR().ispresent() ? !single_value->field_aPN__AMBR.match((const APN__AMBR&)other_value.aPN__AMBR(), legacy) : !single_value->field_aPN__AMBR.match_omit(legacy)))return FALSE;
if(!other_value.signallingPriorityIndication().is_bound()) return FALSE;
if((other_value.signallingPriorityIndication().ispresent() ? !single_value->field_signallingPriorityIndication.match((const SignallingPriorityIndication&)other_value.signallingPriorityIndication(), legacy) : !single_value->field_signallingPriorityIndication.match_omit(legacy)))return FALSE;
if(!other_value.cN__OperatorSelectionEntity().is_bound()) return FALSE;
if((other_value.cN__OperatorSelectionEntity().ispresent() ? !single_value->field_cN__OperatorSelectionEntity.match((const CN__OperatorSelectionEntity&)other_value.cN__OperatorSelectionEntity(), legacy) : !single_value->field_cN__OperatorSelectionEntity.match_omit(legacy)))return FALSE;
if(!other_value.private__extension__gtpc().is_bound()) return FALSE;
if((other_value.private__extension__gtpc().ispresent() ? !single_value->field_private__extension__gtpc.match((const PrivateExtension__gtpc__List&)other_value.private__extension__gtpc(), legacy) : !single_value->field_private__extension__gtpc.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.CreatePDPContextRequest.");
}
return FALSE;
}

boolean CreatePDPContextRequest_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_imsi.is_omit() || single_value->field_imsi.is_bound())
 || (single_value->field_rai.is_omit() || single_value->field_rai.is_bound())
 || (single_value->field_recovery.is_omit() || single_value->field_recovery.is_bound())
 || (single_value->field_selectionMode.is_omit() || single_value->field_selectionMode.is_bound())
 || single_value->field_teidDataI.is_bound()
 || (single_value->field_teidControlPlane.is_omit() || single_value->field_teidControlPlane.is_bound())
 || single_value->field_nsapi.is_bound()
 || (single_value->field_linked__nsapi.is_omit() || single_value->field_linked__nsapi.is_bound())
 || (single_value->field_charging__char.is_omit() || single_value->field_charging__char.is_bound())
 || (single_value->field_trace__ref.is_omit() || single_value->field_trace__ref.is_bound())
 || (single_value->field_trace__type.is_omit() || single_value->field_trace__type.is_bound())
 || (single_value->field_endUserAddress.is_omit() || single_value->field_endUserAddress.is_bound())
 || (single_value->field_accessPointName.is_omit() || single_value->field_accessPointName.is_bound())
 || (single_value->field_protConfigOptions.is_omit() || single_value->field_protConfigOptions.is_bound())
 || single_value->field_sgsn__addr__signalling.is_bound()
 || single_value->field_sgsn__addr__traffic.is_bound()
 || (single_value->field_msisdn.is_omit() || single_value->field_msisdn.is_bound())
 || single_value->field_qualityOfServiceProfile.is_bound()
 || (single_value->field_tft.is_omit() || single_value->field_tft.is_bound())
 || (single_value->field_triggerId.is_omit() || single_value->field_triggerId.is_bound())
 || (single_value->field_omcId.is_omit() || single_value->field_omcId.is_bound())
 || (single_value->field_commonFlags.is_omit() || single_value->field_commonFlags.is_bound())
 || (single_value->field_aPN__Restriction.is_omit() || single_value->field_aPN__Restriction.is_bound())
 || (single_value->field_ratType.is_omit() || single_value->field_ratType.is_bound())
 || (single_value->field_userLocationInformation.is_omit() || single_value->field_userLocationInformation.is_bound())
 || (single_value->field_mS__TimeZone.is_omit() || single_value->field_mS__TimeZone.is_bound())
 || (single_value->field_imeisv.is_omit() || single_value->field_imeisv.is_bound())
 || (single_value->field_camelChargingInformationContainer.is_omit() || single_value->field_camelChargingInformationContainer.is_bound())
 || (single_value->field_additionalTraceInfo.is_omit() || single_value->field_additionalTraceInfo.is_bound())
 || (single_value->field_correlationID.is_omit() || single_value->field_correlationID.is_bound())
 || (single_value->field_evolvedAllocationRetentionPriorityI.is_omit() || single_value->field_evolvedAllocationRetentionPriorityI.is_bound())
 || (single_value->field_extendedCommonFlags.is_omit() || single_value->field_extendedCommonFlags.is_bound())
 || (single_value->field_userCSGInformation.is_omit() || single_value->field_userCSGInformation.is_bound())
 || (single_value->field_aPN__AMBR.is_omit() || single_value->field_aPN__AMBR.is_bound())
 || (single_value->field_signallingPriorityIndication.is_omit() || single_value->field_signallingPriorityIndication.is_bound())
 || (single_value->field_cN__OperatorSelectionEntity.is_omit() || single_value->field_cN__OperatorSelectionEntity.is_bound())
 || (single_value->field_private__extension__gtpc.is_omit() || single_value->field_private__extension__gtpc.is_bound());
}

boolean CreatePDPContextRequest_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_imsi.is_omit() || single_value->field_imsi.is_value())
 && (single_value->field_rai.is_omit() || single_value->field_rai.is_value())
 && (single_value->field_recovery.is_omit() || single_value->field_recovery.is_value())
 && (single_value->field_selectionMode.is_omit() || single_value->field_selectionMode.is_value())
 && single_value->field_teidDataI.is_value()
 && (single_value->field_teidControlPlane.is_omit() || single_value->field_teidControlPlane.is_value())
 && single_value->field_nsapi.is_value()
 && (single_value->field_linked__nsapi.is_omit() || single_value->field_linked__nsapi.is_value())
 && (single_value->field_charging__char.is_omit() || single_value->field_charging__char.is_value())
 && (single_value->field_trace__ref.is_omit() || single_value->field_trace__ref.is_value())
 && (single_value->field_trace__type.is_omit() || single_value->field_trace__type.is_value())
 && (single_value->field_endUserAddress.is_omit() || single_value->field_endUserAddress.is_value())
 && (single_value->field_accessPointName.is_omit() || single_value->field_accessPointName.is_value())
 && (single_value->field_protConfigOptions.is_omit() || single_value->field_protConfigOptions.is_value())
 && single_value->field_sgsn__addr__signalling.is_value()
 && single_value->field_sgsn__addr__traffic.is_value()
 && (single_value->field_msisdn.is_omit() || single_value->field_msisdn.is_value())
 && single_value->field_qualityOfServiceProfile.is_value()
 && (single_value->field_tft.is_omit() || single_value->field_tft.is_value())
 && (single_value->field_triggerId.is_omit() || single_value->field_triggerId.is_value())
 && (single_value->field_omcId.is_omit() || single_value->field_omcId.is_value())
 && (single_value->field_commonFlags.is_omit() || single_value->field_commonFlags.is_value())
 && (single_value->field_aPN__Restriction.is_omit() || single_value->field_aPN__Restriction.is_value())
 && (single_value->field_ratType.is_omit() || single_value->field_ratType.is_value())
 && (single_value->field_userLocationInformation.is_omit() || single_value->field_userLocationInformation.is_value())
 && (single_value->field_mS__TimeZone.is_omit() || single_value->field_mS__TimeZone.is_value())
 && (single_value->field_imeisv.is_omit() || single_value->field_imeisv.is_value())
 && (single_value->field_camelChargingInformationContainer.is_omit() || single_value->field_camelChargingInformationContainer.is_value())
 && (single_value->field_additionalTraceInfo.is_omit() || single_value->field_additionalTraceInfo.is_value())
 && (single_value->field_correlationID.is_omit() || single_value->field_correlationID.is_value())
 && (single_value->field_evolvedAllocationRetentionPriorityI.is_omit() || single_value->field_evolvedAllocationRetentionPriorityI.is_value())
 && (single_value->field_extendedCommonFlags.is_omit() || single_value->field_extendedCommonFlags.is_value())
 && (single_value->field_userCSGInformation.is_omit() || single_value->field_userCSGInformation.is_value())
 && (single_value->field_aPN__AMBR.is_omit() || single_value->field_aPN__AMBR.is_value())
 && (single_value->field_signallingPriorityIndication.is_omit() || single_value->field_signallingPriorityIndication.is_value())
 && (single_value->field_cN__OperatorSelectionEntity.is_omit() || single_value->field_cN__OperatorSelectionEntity.is_value())
 && (single_value->field_private__extension__gtpc.is_omit() || single_value->field_private__extension__gtpc.is_value());
}

void CreatePDPContextRequest_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

CreatePDPContextRequest CreatePDPContextRequest_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
CreatePDPContextRequest ret_val;
if (single_value->field_imsi.is_omit()) ret_val.imsi() = OMIT_VALUE;
else if (single_value->field_imsi.is_bound()) {
ret_val.imsi() = single_value->field_imsi.valueof();
}
if (single_value->field_rai.is_omit()) ret_val.rai() = OMIT_VALUE;
else if (single_value->field_rai.is_bound()) {
ret_val.rai() = single_value->field_rai.valueof();
}
if (single_value->field_recovery.is_omit()) ret_val.recovery() = OMIT_VALUE;
else if (single_value->field_recovery.is_bound()) {
ret_val.recovery() = single_value->field_recovery.valueof();
}
if (single_value->field_selectionMode.is_omit()) ret_val.selectionMode() = OMIT_VALUE;
else if (single_value->field_selectionMode.is_bound()) {
ret_val.selectionMode() = single_value->field_selectionMode.valueof();
}
if (single_value->field_teidDataI.is_bound()) {
ret_val.teidDataI() = single_value->field_teidDataI.valueof();
}
if (single_value->field_teidControlPlane.is_omit()) ret_val.teidControlPlane() = OMIT_VALUE;
else if (single_value->field_teidControlPlane.is_bound()) {
ret_val.teidControlPlane() = single_value->field_teidControlPlane.valueof();
}
if (single_value->field_nsapi.is_bound()) {
ret_val.nsapi() = single_value->field_nsapi.valueof();
}
if (single_value->field_linked__nsapi.is_omit()) ret_val.linked__nsapi() = OMIT_VALUE;
else if (single_value->field_linked__nsapi.is_bound()) {
ret_val.linked__nsapi() = single_value->field_linked__nsapi.valueof();
}
if (single_value->field_charging__char.is_omit()) ret_val.charging__char() = OMIT_VALUE;
else if (single_value->field_charging__char.is_bound()) {
ret_val.charging__char() = single_value->field_charging__char.valueof();
}
if (single_value->field_trace__ref.is_omit()) ret_val.trace__ref() = OMIT_VALUE;
else if (single_value->field_trace__ref.is_bound()) {
ret_val.trace__ref() = single_value->field_trace__ref.valueof();
}
if (single_value->field_trace__type.is_omit()) ret_val.trace__type() = OMIT_VALUE;
else if (single_value->field_trace__type.is_bound()) {
ret_val.trace__type() = single_value->field_trace__type.valueof();
}
if (single_value->field_endUserAddress.is_omit()) ret_val.endUserAddress() = OMIT_VALUE;
else if (single_value->field_endUserAddress.is_bound()) {
ret_val.endUserAddress() = single_value->field_endUserAddress.valueof();
}
if (single_value->field_accessPointName.is_omit()) ret_val.accessPointName() = OMIT_VALUE;
else if (single_value->field_accessPointName.is_bound()) {
ret_val.accessPointName() = single_value->field_accessPointName.valueof();
}
if (single_value->field_protConfigOptions.is_omit()) ret_val.protConfigOptions() = OMIT_VALUE;
else if (single_value->field_protConfigOptions.is_bound()) {
ret_val.protConfigOptions() = single_value->field_protConfigOptions.valueof();
}
if (single_value->field_sgsn__addr__signalling.is_bound()) {
ret_val.sgsn__addr__signalling() = single_value->field_sgsn__addr__signalling.valueof();
}
if (single_value->field_sgsn__addr__traffic.is_bound()) {
ret_val.sgsn__addr__traffic() = single_value->field_sgsn__addr__traffic.valueof();
}
if (single_value->field_msisdn.is_omit()) ret_val.msisdn() = OMIT_VALUE;
else if (single_value->field_msisdn.is_bound()) {
ret_val.msisdn() = single_value->field_msisdn.valueof();
}
if (single_value->field_qualityOfServiceProfile.is_bound()) {
ret_val.qualityOfServiceProfile() = single_value->field_qualityOfServiceProfile.valueof();
}
if (single_value->field_tft.is_omit()) ret_val.tft() = OMIT_VALUE;
else if (single_value->field_tft.is_bound()) {
ret_val.tft() = single_value->field_tft.valueof();
}
if (single_value->field_triggerId.is_omit()) ret_val.triggerId() = OMIT_VALUE;
else if (single_value->field_triggerId.is_bound()) {
ret_val.triggerId() = single_value->field_triggerId.valueof();
}
if (single_value->field_omcId.is_omit()) ret_val.omcId() = OMIT_VALUE;
else if (single_value->field_omcId.is_bound()) {
ret_val.omcId() = single_value->field_omcId.valueof();
}
if (single_value->field_commonFlags.is_omit()) ret_val.commonFlags() = OMIT_VALUE;
else if (single_value->field_commonFlags.is_bound()) {
ret_val.commonFlags() = single_value->field_commonFlags.valueof();
}
if (single_value->field_aPN__Restriction.is_omit()) ret_val.aPN__Restriction() = OMIT_VALUE;
else if (single_value->field_aPN__Restriction.is_bound()) {
ret_val.aPN__Restriction() = single_value->field_aPN__Restriction.valueof();
}
if (single_value->field_ratType.is_omit()) ret_val.ratType() = OMIT_VALUE;
else if (single_value->field_ratType.is_bound()) {
ret_val.ratType() = single_value->field_ratType.valueof();
}
if (single_value->field_userLocationInformation.is_omit()) ret_val.userLocationInformation() = OMIT_VALUE;
else if (single_value->field_userLocationInformation.is_bound()) {
ret_val.userLocationInformation() = single_value->field_userLocationInformation.valueof();
}
if (single_value->field_mS__TimeZone.is_omit()) ret_val.mS__TimeZone() = OMIT_VALUE;
else if (single_value->field_mS__TimeZone.is_bound()) {
ret_val.mS__TimeZone() = single_value->field_mS__TimeZone.valueof();
}
if (single_value->field_imeisv.is_omit()) ret_val.imeisv() = OMIT_VALUE;
else if (single_value->field_imeisv.is_bound()) {
ret_val.imeisv() = single_value->field_imeisv.valueof();
}
if (single_value->field_camelChargingInformationContainer.is_omit()) ret_val.camelChargingInformationContainer() = OMIT_VALUE;
else if (single_value->field_camelChargingInformationContainer.is_bound()) {
ret_val.camelChargingInformationContainer() = single_value->field_camelChargingInformationContainer.valueof();
}
if (single_value->field_additionalTraceInfo.is_omit()) ret_val.additionalTraceInfo() = OMIT_VALUE;
else if (single_value->field_additionalTraceInfo.is_bound()) {
ret_val.additionalTraceInfo() = single_value->field_additionalTraceInfo.valueof();
}
if (single_value->field_correlationID.is_omit()) ret_val.correlationID() = OMIT_VALUE;
else if (single_value->field_correlationID.is_bound()) {
ret_val.correlationID() = single_value->field_correlationID.valueof();
}
if (single_value->field_evolvedAllocationRetentionPriorityI.is_omit()) ret_val.evolvedAllocationRetentionPriorityI() = OMIT_VALUE;
else if (single_value->field_evolvedAllocationRetentionPriorityI.is_bound()) {
ret_val.evolvedAllocationRetentionPriorityI() = single_value->field_evolvedAllocationRetentionPriorityI.valueof();
}
if (single_value->field_extendedCommonFlags.is_omit()) ret_val.extendedCommonFlags() = OMIT_VALUE;
else if (single_value->field_extendedCommonFlags.is_bound()) {
ret_val.extendedCommonFlags() = single_value->field_extendedCommonFlags.valueof();
}
if (single_value->field_userCSGInformation.is_omit()) ret_val.userCSGInformation() = OMIT_VALUE;
else if (single_value->field_userCSGInformation.is_bound()) {
ret_val.userCSGInformation() = single_value->field_userCSGInformation.valueof();
}
if (single_value->field_aPN__AMBR.is_omit()) ret_val.aPN__AMBR() = OMIT_VALUE;
else if (single_value->field_aPN__AMBR.is_bound()) {
ret_val.aPN__AMBR() = single_value->field_aPN__AMBR.valueof();
}
if (single_value->field_signallingPriorityIndication.is_omit()) ret_val.signallingPriorityIndication() = OMIT_VALUE;
else if (single_value->field_signallingPriorityIndication.is_bound()) {
ret_val.signallingPriorityIndication() = single_value->field_signallingPriorityIndication.valueof();
}
if (single_value->field_cN__OperatorSelectionEntity.is_omit()) ret_val.cN__OperatorSelectionEntity() = OMIT_VALUE;
else if (single_value->field_cN__OperatorSelectionEntity.is_bound()) {
ret_val.cN__OperatorSelectionEntity() = single_value->field_cN__OperatorSelectionEntity.valueof();
}
if (single_value->field_private__extension__gtpc.is_omit()) ret_val.private__extension__gtpc() = OMIT_VALUE;
else if (single_value->field_private__extension__gtpc.is_bound()) {
ret_val.private__extension__gtpc() = single_value->field_private__extension__gtpc.valueof();
}
return ret_val;
}

void CreatePDPContextRequest_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.CreatePDPContextRequest.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new CreatePDPContextRequest_template[list_length];
}

CreatePDPContextRequest_template& CreatePDPContextRequest_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.CreatePDPContextRequest.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.CreatePDPContextRequest.");
return value_list.list_value[list_index];
}

IMSI__gtpc_template& CreatePDPContextRequest_template::imsi()
{
set_specific();
return single_value->field_imsi;
}

const IMSI__gtpc_template& CreatePDPContextRequest_template::imsi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field imsi of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_imsi;
}

RoutingAreaIdentity_template& CreatePDPContextRequest_template::rai()
{
set_specific();
return single_value->field_rai;
}

const RoutingAreaIdentity_template& CreatePDPContextRequest_template::rai() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rai of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_rai;
}

Recovery__gtpc_template& CreatePDPContextRequest_template::recovery()
{
set_specific();
return single_value->field_recovery;
}

const Recovery__gtpc_template& CreatePDPContextRequest_template::recovery() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field recovery of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_recovery;
}

SelectionMode_template& CreatePDPContextRequest_template::selectionMode()
{
set_specific();
return single_value->field_selectionMode;
}

const SelectionMode_template& CreatePDPContextRequest_template::selectionMode() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field selectionMode of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_selectionMode;
}

TeidDataI_template& CreatePDPContextRequest_template::teidDataI()
{
set_specific();
return single_value->field_teidDataI;
}

const TeidDataI_template& CreatePDPContextRequest_template::teidDataI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field teidDataI of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_teidDataI;
}

TeidControlPlane_template& CreatePDPContextRequest_template::teidControlPlane()
{
set_specific();
return single_value->field_teidControlPlane;
}

const TeidControlPlane_template& CreatePDPContextRequest_template::teidControlPlane() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field teidControlPlane of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_teidControlPlane;
}

NSAPI__GTPC_template& CreatePDPContextRequest_template::nsapi()
{
set_specific();
return single_value->field_nsapi;
}

const NSAPI__GTPC_template& CreatePDPContextRequest_template::nsapi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsapi of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_nsapi;
}

NSAPI__GTPC_template& CreatePDPContextRequest_template::linked__nsapi()
{
set_specific();
return single_value->field_linked__nsapi;
}

const NSAPI__GTPC_template& CreatePDPContextRequest_template::linked__nsapi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field linked_nsapi of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_linked__nsapi;
}

ChargingCharacteristics__GTPC_template& CreatePDPContextRequest_template::charging__char()
{
set_specific();
return single_value->field_charging__char;
}

const ChargingCharacteristics__GTPC_template& CreatePDPContextRequest_template::charging__char() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field charging_char of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_charging__char;
}

TraceRef_template& CreatePDPContextRequest_template::trace__ref()
{
set_specific();
return single_value->field_trace__ref;
}

const TraceRef_template& CreatePDPContextRequest_template::trace__ref() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field trace_ref of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_trace__ref;
}

GTP__TraceType_template& CreatePDPContextRequest_template::trace__type()
{
set_specific();
return single_value->field_trace__type;
}

const GTP__TraceType_template& CreatePDPContextRequest_template::trace__type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field trace_type of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_trace__type;
}

EndUserAddress_template& CreatePDPContextRequest_template::endUserAddress()
{
set_specific();
return single_value->field_endUserAddress;
}

const EndUserAddress_template& CreatePDPContextRequest_template::endUserAddress() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field endUserAddress of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_endUserAddress;
}

AccessPointName_template& CreatePDPContextRequest_template::accessPointName()
{
set_specific();
return single_value->field_accessPointName;
}

const AccessPointName_template& CreatePDPContextRequest_template::accessPointName() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field accessPointName of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_accessPointName;
}

ProtConfigOptions_template& CreatePDPContextRequest_template::protConfigOptions()
{
set_specific();
return single_value->field_protConfigOptions;
}

const ProtConfigOptions_template& CreatePDPContextRequest_template::protConfigOptions() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field protConfigOptions of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_protConfigOptions;
}

GSN__Address__GTPC_template& CreatePDPContextRequest_template::sgsn__addr__signalling()
{
set_specific();
return single_value->field_sgsn__addr__signalling;
}

const GSN__Address__GTPC_template& CreatePDPContextRequest_template::sgsn__addr__signalling() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sgsn_addr_signalling of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_sgsn__addr__signalling;
}

GSN__Address__GTPC_template& CreatePDPContextRequest_template::sgsn__addr__traffic()
{
set_specific();
return single_value->field_sgsn__addr__traffic;
}

const GSN__Address__GTPC_template& CreatePDPContextRequest_template::sgsn__addr__traffic() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sgsn_addr_traffic of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_sgsn__addr__traffic;
}

MSISDN_template& CreatePDPContextRequest_template::msisdn()
{
set_specific();
return single_value->field_msisdn;
}

const MSISDN_template& CreatePDPContextRequest_template::msisdn() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field msisdn of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_msisdn;
}

QualityOfServiceProfile_template& CreatePDPContextRequest_template::qualityOfServiceProfile()
{
set_specific();
return single_value->field_qualityOfServiceProfile;
}

const QualityOfServiceProfile_template& CreatePDPContextRequest_template::qualityOfServiceProfile() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field qualityOfServiceProfile of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_qualityOfServiceProfile;
}

TrafficFlowTemplate_template& CreatePDPContextRequest_template::tft()
{
set_specific();
return single_value->field_tft;
}

const TrafficFlowTemplate_template& CreatePDPContextRequest_template::tft() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tft of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_tft;
}

GTP__TriggerID_template& CreatePDPContextRequest_template::triggerId()
{
set_specific();
return single_value->field_triggerId;
}

const GTP__TriggerID_template& CreatePDPContextRequest_template::triggerId() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field triggerId of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_triggerId;
}

OMCIdentity_template& CreatePDPContextRequest_template::omcId()
{
set_specific();
return single_value->field_omcId;
}

const OMCIdentity_template& CreatePDPContextRequest_template::omcId() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field omcId of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_omcId;
}

CommonFlags_template& CreatePDPContextRequest_template::commonFlags()
{
set_specific();
return single_value->field_commonFlags;
}

const CommonFlags_template& CreatePDPContextRequest_template::commonFlags() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field commonFlags of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_commonFlags;
}

APN__Restriction_template& CreatePDPContextRequest_template::aPN__Restriction()
{
set_specific();
return single_value->field_aPN__Restriction;
}

const APN__Restriction_template& CreatePDPContextRequest_template::aPN__Restriction() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field aPN_Restriction of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_aPN__Restriction;
}

RATType_template& CreatePDPContextRequest_template::ratType()
{
set_specific();
return single_value->field_ratType;
}

const RATType_template& CreatePDPContextRequest_template::ratType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ratType of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_ratType;
}

UserLocationInformation_template& CreatePDPContextRequest_template::userLocationInformation()
{
set_specific();
return single_value->field_userLocationInformation;
}

const UserLocationInformation_template& CreatePDPContextRequest_template::userLocationInformation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field userLocationInformation of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_userLocationInformation;
}

MS__TimeZone_template& CreatePDPContextRequest_template::mS__TimeZone()
{
set_specific();
return single_value->field_mS__TimeZone;
}

const MS__TimeZone_template& CreatePDPContextRequest_template::mS__TimeZone() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mS_TimeZone of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_mS__TimeZone;
}

IMEISV__gtpc_template& CreatePDPContextRequest_template::imeisv()
{
set_specific();
return single_value->field_imeisv;
}

const IMEISV__gtpc_template& CreatePDPContextRequest_template::imeisv() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field imeisv of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_imeisv;
}

CamelChargingInformationContainer_template& CreatePDPContextRequest_template::camelChargingInformationContainer()
{
set_specific();
return single_value->field_camelChargingInformationContainer;
}

const CamelChargingInformationContainer_template& CreatePDPContextRequest_template::camelChargingInformationContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field camelChargingInformationContainer of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_camelChargingInformationContainer;
}

AdditionalTraceInfo_template& CreatePDPContextRequest_template::additionalTraceInfo()
{
set_specific();
return single_value->field_additionalTraceInfo;
}

const AdditionalTraceInfo_template& CreatePDPContextRequest_template::additionalTraceInfo() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field additionalTraceInfo of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_additionalTraceInfo;
}

CorrelationID_template& CreatePDPContextRequest_template::correlationID()
{
set_specific();
return single_value->field_correlationID;
}

const CorrelationID_template& CreatePDPContextRequest_template::correlationID() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field correlationID of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_correlationID;
}

EvolvedAllocationRetentionPriorityI_template& CreatePDPContextRequest_template::evolvedAllocationRetentionPriorityI()
{
set_specific();
return single_value->field_evolvedAllocationRetentionPriorityI;
}

const EvolvedAllocationRetentionPriorityI_template& CreatePDPContextRequest_template::evolvedAllocationRetentionPriorityI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field evolvedAllocationRetentionPriorityI of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_evolvedAllocationRetentionPriorityI;
}

ExtendedCommonFlags_template& CreatePDPContextRequest_template::extendedCommonFlags()
{
set_specific();
return single_value->field_extendedCommonFlags;
}

const ExtendedCommonFlags_template& CreatePDPContextRequest_template::extendedCommonFlags() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extendedCommonFlags of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_extendedCommonFlags;
}

UserCSGInformation_template& CreatePDPContextRequest_template::userCSGInformation()
{
set_specific();
return single_value->field_userCSGInformation;
}

const UserCSGInformation_template& CreatePDPContextRequest_template::userCSGInformation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field userCSGInformation of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_userCSGInformation;
}

APN__AMBR_template& CreatePDPContextRequest_template::aPN__AMBR()
{
set_specific();
return single_value->field_aPN__AMBR;
}

const APN__AMBR_template& CreatePDPContextRequest_template::aPN__AMBR() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field aPN_AMBR of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_aPN__AMBR;
}

SignallingPriorityIndication_template& CreatePDPContextRequest_template::signallingPriorityIndication()
{
set_specific();
return single_value->field_signallingPriorityIndication;
}

const SignallingPriorityIndication_template& CreatePDPContextRequest_template::signallingPriorityIndication() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field signallingPriorityIndication of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_signallingPriorityIndication;
}

CN__OperatorSelectionEntity_template& CreatePDPContextRequest_template::cN__OperatorSelectionEntity()
{
set_specific();
return single_value->field_cN__OperatorSelectionEntity;
}

const CN__OperatorSelectionEntity_template& CreatePDPContextRequest_template::cN__OperatorSelectionEntity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cN_OperatorSelectionEntity of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_cN__OperatorSelectionEntity;
}

PrivateExtension__gtpc__List_template& CreatePDPContextRequest_template::private__extension__gtpc()
{
set_specific();
return single_value->field_private__extension__gtpc;
}

const PrivateExtension__gtpc__List_template& CreatePDPContextRequest_template::private__extension__gtpc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field private_extension_gtpc of a non-specific template of type @GTPC_Types.CreatePDPContextRequest.");
return single_value->field_private__extension__gtpc;
}

int CreatePDPContextRequest_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CreatePDPContextRequest which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 5;
      if (single_value->field_imsi.is_present()) ret_val++;
      if (single_value->field_rai.is_present()) ret_val++;
      if (single_value->field_recovery.is_present()) ret_val++;
      if (single_value->field_selectionMode.is_present()) ret_val++;
      if (single_value->field_teidControlPlane.is_present()) ret_val++;
      if (single_value->field_linked__nsapi.is_present()) ret_val++;
      if (single_value->field_charging__char.is_present()) ret_val++;
      if (single_value->field_trace__ref.is_present()) ret_val++;
      if (single_value->field_trace__type.is_present()) ret_val++;
      if (single_value->field_endUserAddress.is_present()) ret_val++;
      if (single_value->field_accessPointName.is_present()) ret_val++;
      if (single_value->field_protConfigOptions.is_present()) ret_val++;
      if (single_value->field_msisdn.is_present()) ret_val++;
      if (single_value->field_tft.is_present()) ret_val++;
      if (single_value->field_triggerId.is_present()) ret_val++;
      if (single_value->field_omcId.is_present()) ret_val++;
      if (single_value->field_commonFlags.is_present()) ret_val++;
      if (single_value->field_aPN__Restriction.is_present()) ret_val++;
      if (single_value->field_ratType.is_present()) ret_val++;
      if (single_value->field_userLocationInformation.is_present()) ret_val++;
      if (single_value->field_mS__TimeZone.is_present()) ret_val++;
      if (single_value->field_imeisv.is_present()) ret_val++;
      if (single_value->field_camelChargingInformationContainer.is_present()) ret_val++;
      if (single_value->field_additionalTraceInfo.is_present()) ret_val++;
      if (single_value->field_correlationID.is_present()) ret_val++;
      if (single_value->field_evolvedAllocationRetentionPriorityI.is_present()) ret_val++;
      if (single_value->field_extendedCommonFlags.is_present()) ret_val++;
      if (single_value->field_userCSGInformation.is_present()) ret_val++;
      if (single_value->field_aPN__AMBR.is_present()) ret_val++;
      if (single_value->field_signallingPriorityIndication.is_present()) ret_val++;
      if (single_value->field_cN__OperatorSelectionEntity.is_present()) ret_val++;
      if (single_value->field_private__extension__gtpc.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.CreatePDPContextRequest containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CreatePDPContextRequest containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CreatePDPContextRequest containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CreatePDPContextRequest containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CreatePDPContextRequest containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CreatePDPContextRequest containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CreatePDPContextRequest containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CreatePDPContextRequest containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.CreatePDPContextRequest.");
  }
  return 0;
}

void CreatePDPContextRequest_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ imsi := ");
single_value->field_imsi.log();
TTCN_Logger::log_event_str(", rai := ");
single_value->field_rai.log();
TTCN_Logger::log_event_str(", recovery := ");
single_value->field_recovery.log();
TTCN_Logger::log_event_str(", selectionMode := ");
single_value->field_selectionMode.log();
TTCN_Logger::log_event_str(", teidDataI := ");
single_value->field_teidDataI.log();
TTCN_Logger::log_event_str(", teidControlPlane := ");
single_value->field_teidControlPlane.log();
TTCN_Logger::log_event_str(", nsapi := ");
single_value->field_nsapi.log();
TTCN_Logger::log_event_str(", linked_nsapi := ");
single_value->field_linked__nsapi.log();
TTCN_Logger::log_event_str(", charging_char := ");
single_value->field_charging__char.log();
TTCN_Logger::log_event_str(", trace_ref := ");
single_value->field_trace__ref.log();
TTCN_Logger::log_event_str(", trace_type := ");
single_value->field_trace__type.log();
TTCN_Logger::log_event_str(", endUserAddress := ");
single_value->field_endUserAddress.log();
TTCN_Logger::log_event_str(", accessPointName := ");
single_value->field_accessPointName.log();
TTCN_Logger::log_event_str(", protConfigOptions := ");
single_value->field_protConfigOptions.log();
TTCN_Logger::log_event_str(", sgsn_addr_signalling := ");
single_value->field_sgsn__addr__signalling.log();
TTCN_Logger::log_event_str(", sgsn_addr_traffic := ");
single_value->field_sgsn__addr__traffic.log();
TTCN_Logger::log_event_str(", msisdn := ");
single_value->field_msisdn.log();
TTCN_Logger::log_event_str(", qualityOfServiceProfile := ");
single_value->field_qualityOfServiceProfile.log();
TTCN_Logger::log_event_str(", tft := ");
single_value->field_tft.log();
TTCN_Logger::log_event_str(", triggerId := ");
single_value->field_triggerId.log();
TTCN_Logger::log_event_str(", omcId := ");
single_value->field_omcId.log();
TTCN_Logger::log_event_str(", commonFlags := ");
single_value->field_commonFlags.log();
TTCN_Logger::log_event_str(", aPN_Restriction := ");
single_value->field_aPN__Restriction.log();
TTCN_Logger::log_event_str(", ratType := ");
single_value->field_ratType.log();
TTCN_Logger::log_event_str(", userLocationInformation := ");
single_value->field_userLocationInformation.log();
TTCN_Logger::log_event_str(", mS_TimeZone := ");
single_value->field_mS__TimeZone.log();
TTCN_Logger::log_event_str(", imeisv := ");
single_value->field_imeisv.log();
TTCN_Logger::log_event_str(", camelChargingInformationContainer := ");
single_value->field_camelChargingInformationContainer.log();
TTCN_Logger::log_event_str(", additionalTraceInfo := ");
single_value->field_additionalTraceInfo.log();
TTCN_Logger::log_event_str(", correlationID := ");
single_value->field_correlationID.log();
TTCN_Logger::log_event_str(", evolvedAllocationRetentionPriorityI := ");
single_value->field_evolvedAllocationRetentionPriorityI.log();
TTCN_Logger::log_event_str(", extendedCommonFlags := ");
single_value->field_extendedCommonFlags.log();
TTCN_Logger::log_event_str(", userCSGInformation := ");
single_value->field_userCSGInformation.log();
TTCN_Logger::log_event_str(", aPN_AMBR := ");
single_value->field_aPN__AMBR.log();
TTCN_Logger::log_event_str(", signallingPriorityIndication := ");
single_value->field_signallingPriorityIndication.log();
TTCN_Logger::log_event_str(", cN_OperatorSelectionEntity := ");
single_value->field_cN__OperatorSelectionEntity.log();
TTCN_Logger::log_event_str(", private_extension_gtpc := ");
single_value->field_private__extension__gtpc.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void CreatePDPContextRequest_template::log_match(const CreatePDPContextRequest& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.imsi().ispresent()){
if(!single_value->field_imsi.match(match_value.imsi(), legacy)){
TTCN_Logger::log_logmatch_info(".imsi");
single_value->field_imsi.log_match(match_value.imsi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_imsi.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".imsi := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_imsi.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.rai().ispresent()){
if(!single_value->field_rai.match(match_value.rai(), legacy)){
TTCN_Logger::log_logmatch_info(".rai");
single_value->field_rai.log_match(match_value.rai(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_rai.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".rai := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_rai.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.recovery().ispresent()){
if(!single_value->field_recovery.match(match_value.recovery(), legacy)){
TTCN_Logger::log_logmatch_info(".recovery");
single_value->field_recovery.log_match(match_value.recovery(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_recovery.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".recovery := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_recovery.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.selectionMode().ispresent()){
if(!single_value->field_selectionMode.match(match_value.selectionMode(), legacy)){
TTCN_Logger::log_logmatch_info(".selectionMode");
single_value->field_selectionMode.log_match(match_value.selectionMode(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_selectionMode.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".selectionMode := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_selectionMode.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_teidDataI.match(match_value.teidDataI(), legacy)){
TTCN_Logger::log_logmatch_info(".teidDataI");
single_value->field_teidDataI.log_match(match_value.teidDataI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.teidControlPlane().ispresent()){
if(!single_value->field_teidControlPlane.match(match_value.teidControlPlane(), legacy)){
TTCN_Logger::log_logmatch_info(".teidControlPlane");
single_value->field_teidControlPlane.log_match(match_value.teidControlPlane(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_teidControlPlane.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".teidControlPlane := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_teidControlPlane.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_nsapi.match(match_value.nsapi(), legacy)){
TTCN_Logger::log_logmatch_info(".nsapi");
single_value->field_nsapi.log_match(match_value.nsapi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.linked__nsapi().ispresent()){
if(!single_value->field_linked__nsapi.match(match_value.linked__nsapi(), legacy)){
TTCN_Logger::log_logmatch_info(".linked_nsapi");
single_value->field_linked__nsapi.log_match(match_value.linked__nsapi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_linked__nsapi.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".linked_nsapi := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_linked__nsapi.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.charging__char().ispresent()){
if(!single_value->field_charging__char.match(match_value.charging__char(), legacy)){
TTCN_Logger::log_logmatch_info(".charging_char");
single_value->field_charging__char.log_match(match_value.charging__char(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_charging__char.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".charging_char := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_charging__char.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.trace__ref().ispresent()){
if(!single_value->field_trace__ref.match(match_value.trace__ref(), legacy)){
TTCN_Logger::log_logmatch_info(".trace_ref");
single_value->field_trace__ref.log_match(match_value.trace__ref(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_trace__ref.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".trace_ref := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_trace__ref.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.trace__type().ispresent()){
if(!single_value->field_trace__type.match(match_value.trace__type(), legacy)){
TTCN_Logger::log_logmatch_info(".trace_type");
single_value->field_trace__type.log_match(match_value.trace__type(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_trace__type.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".trace_type := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_trace__type.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.endUserAddress().ispresent()){
if(!single_value->field_endUserAddress.match(match_value.endUserAddress(), legacy)){
TTCN_Logger::log_logmatch_info(".endUserAddress");
single_value->field_endUserAddress.log_match(match_value.endUserAddress(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_endUserAddress.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".endUserAddress := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_endUserAddress.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.accessPointName().ispresent()){
if(!single_value->field_accessPointName.match(match_value.accessPointName(), legacy)){
TTCN_Logger::log_logmatch_info(".accessPointName");
single_value->field_accessPointName.log_match(match_value.accessPointName(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_accessPointName.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".accessPointName := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_accessPointName.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.protConfigOptions().ispresent()){
if(!single_value->field_protConfigOptions.match(match_value.protConfigOptions(), legacy)){
TTCN_Logger::log_logmatch_info(".protConfigOptions");
single_value->field_protConfigOptions.log_match(match_value.protConfigOptions(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_protConfigOptions.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".protConfigOptions := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_protConfigOptions.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_sgsn__addr__signalling.match(match_value.sgsn__addr__signalling(), legacy)){
TTCN_Logger::log_logmatch_info(".sgsn_addr_signalling");
single_value->field_sgsn__addr__signalling.log_match(match_value.sgsn__addr__signalling(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sgsn__addr__traffic.match(match_value.sgsn__addr__traffic(), legacy)){
TTCN_Logger::log_logmatch_info(".sgsn_addr_traffic");
single_value->field_sgsn__addr__traffic.log_match(match_value.sgsn__addr__traffic(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.msisdn().ispresent()){
if(!single_value->field_msisdn.match(match_value.msisdn(), legacy)){
TTCN_Logger::log_logmatch_info(".msisdn");
single_value->field_msisdn.log_match(match_value.msisdn(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_msisdn.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".msisdn := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_msisdn.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_qualityOfServiceProfile.match(match_value.qualityOfServiceProfile(), legacy)){
TTCN_Logger::log_logmatch_info(".qualityOfServiceProfile");
single_value->field_qualityOfServiceProfile.log_match(match_value.qualityOfServiceProfile(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.tft().ispresent()){
if(!single_value->field_tft.match(match_value.tft(), legacy)){
TTCN_Logger::log_logmatch_info(".tft");
single_value->field_tft.log_match(match_value.tft(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_tft.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".tft := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_tft.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.triggerId().ispresent()){
if(!single_value->field_triggerId.match(match_value.triggerId(), legacy)){
TTCN_Logger::log_logmatch_info(".triggerId");
single_value->field_triggerId.log_match(match_value.triggerId(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_triggerId.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".triggerId := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_triggerId.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.omcId().ispresent()){
if(!single_value->field_omcId.match(match_value.omcId(), legacy)){
TTCN_Logger::log_logmatch_info(".omcId");
single_value->field_omcId.log_match(match_value.omcId(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_omcId.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".omcId := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_omcId.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.commonFlags().ispresent()){
if(!single_value->field_commonFlags.match(match_value.commonFlags(), legacy)){
TTCN_Logger::log_logmatch_info(".commonFlags");
single_value->field_commonFlags.log_match(match_value.commonFlags(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_commonFlags.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".commonFlags := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_commonFlags.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.aPN__Restriction().ispresent()){
if(!single_value->field_aPN__Restriction.match(match_value.aPN__Restriction(), legacy)){
TTCN_Logger::log_logmatch_info(".aPN_Restriction");
single_value->field_aPN__Restriction.log_match(match_value.aPN__Restriction(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_aPN__Restriction.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".aPN_Restriction := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_aPN__Restriction.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.ratType().ispresent()){
if(!single_value->field_ratType.match(match_value.ratType(), legacy)){
TTCN_Logger::log_logmatch_info(".ratType");
single_value->field_ratType.log_match(match_value.ratType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_ratType.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".ratType := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_ratType.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.userLocationInformation().ispresent()){
if(!single_value->field_userLocationInformation.match(match_value.userLocationInformation(), legacy)){
TTCN_Logger::log_logmatch_info(".userLocationInformation");
single_value->field_userLocationInformation.log_match(match_value.userLocationInformation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_userLocationInformation.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".userLocationInformation := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_userLocationInformation.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.mS__TimeZone().ispresent()){
if(!single_value->field_mS__TimeZone.match(match_value.mS__TimeZone(), legacy)){
TTCN_Logger::log_logmatch_info(".mS_TimeZone");
single_value->field_mS__TimeZone.log_match(match_value.mS__TimeZone(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_mS__TimeZone.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".mS_TimeZone := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_mS__TimeZone.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.imeisv().ispresent()){
if(!single_value->field_imeisv.match(match_value.imeisv(), legacy)){
TTCN_Logger::log_logmatch_info(".imeisv");
single_value->field_imeisv.log_match(match_value.imeisv(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_imeisv.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".imeisv := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_imeisv.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.camelChargingInformationContainer().ispresent()){
if(!single_value->field_camelChargingInformationContainer.match(match_value.camelChargingInformationContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".camelChargingInformationContainer");
single_value->field_camelChargingInformationContainer.log_match(match_value.camelChargingInformationContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_camelChargingInformationContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".camelChargingInformationContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_camelChargingInformationContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.additionalTraceInfo().ispresent()){
if(!single_value->field_additionalTraceInfo.match(match_value.additionalTraceInfo(), legacy)){
TTCN_Logger::log_logmatch_info(".additionalTraceInfo");
single_value->field_additionalTraceInfo.log_match(match_value.additionalTraceInfo(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_additionalTraceInfo.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".additionalTraceInfo := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_additionalTraceInfo.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.correlationID().ispresent()){
if(!single_value->field_correlationID.match(match_value.correlationID(), legacy)){
TTCN_Logger::log_logmatch_info(".correlationID");
single_value->field_correlationID.log_match(match_value.correlationID(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_correlationID.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".correlationID := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_correlationID.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.evolvedAllocationRetentionPriorityI().ispresent()){
if(!single_value->field_evolvedAllocationRetentionPriorityI.match(match_value.evolvedAllocationRetentionPriorityI(), legacy)){
TTCN_Logger::log_logmatch_info(".evolvedAllocationRetentionPriorityI");
single_value->field_evolvedAllocationRetentionPriorityI.log_match(match_value.evolvedAllocationRetentionPriorityI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_evolvedAllocationRetentionPriorityI.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".evolvedAllocationRetentionPriorityI := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_evolvedAllocationRetentionPriorityI.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.extendedCommonFlags().ispresent()){
if(!single_value->field_extendedCommonFlags.match(match_value.extendedCommonFlags(), legacy)){
TTCN_Logger::log_logmatch_info(".extendedCommonFlags");
single_value->field_extendedCommonFlags.log_match(match_value.extendedCommonFlags(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extendedCommonFlags.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extendedCommonFlags := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extendedCommonFlags.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.userCSGInformation().ispresent()){
if(!single_value->field_userCSGInformation.match(match_value.userCSGInformation(), legacy)){
TTCN_Logger::log_logmatch_info(".userCSGInformation");
single_value->field_userCSGInformation.log_match(match_value.userCSGInformation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_userCSGInformation.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".userCSGInformation := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_userCSGInformation.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.aPN__AMBR().ispresent()){
if(!single_value->field_aPN__AMBR.match(match_value.aPN__AMBR(), legacy)){
TTCN_Logger::log_logmatch_info(".aPN_AMBR");
single_value->field_aPN__AMBR.log_match(match_value.aPN__AMBR(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_aPN__AMBR.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".aPN_AMBR := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_aPN__AMBR.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.signallingPriorityIndication().ispresent()){
if(!single_value->field_signallingPriorityIndication.match(match_value.signallingPriorityIndication(), legacy)){
TTCN_Logger::log_logmatch_info(".signallingPriorityIndication");
single_value->field_signallingPriorityIndication.log_match(match_value.signallingPriorityIndication(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_signallingPriorityIndication.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".signallingPriorityIndication := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_signallingPriorityIndication.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.cN__OperatorSelectionEntity().ispresent()){
if(!single_value->field_cN__OperatorSelectionEntity.match(match_value.cN__OperatorSelectionEntity(), legacy)){
TTCN_Logger::log_logmatch_info(".cN_OperatorSelectionEntity");
single_value->field_cN__OperatorSelectionEntity.log_match(match_value.cN__OperatorSelectionEntity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_cN__OperatorSelectionEntity.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".cN_OperatorSelectionEntity := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_cN__OperatorSelectionEntity.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.private__extension__gtpc().ispresent()){
if(!single_value->field_private__extension__gtpc.match(match_value.private__extension__gtpc(), legacy)){
TTCN_Logger::log_logmatch_info(".private_extension_gtpc");
single_value->field_private__extension__gtpc.log_match(match_value.private__extension__gtpc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_private__extension__gtpc.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".private_extension_gtpc := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_private__extension__gtpc.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ imsi := ");
if (match_value.imsi().ispresent()) {
single_value->field_imsi.log_match(match_value.imsi(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_imsi.log();
if (single_value->field_imsi.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", rai := ");
if (match_value.rai().ispresent()) {
single_value->field_rai.log_match(match_value.rai(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_rai.log();
if (single_value->field_rai.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", recovery := ");
if (match_value.recovery().ispresent()) {
single_value->field_recovery.log_match(match_value.recovery(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_recovery.log();
if (single_value->field_recovery.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", selectionMode := ");
if (match_value.selectionMode().ispresent()) {
single_value->field_selectionMode.log_match(match_value.selectionMode(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_selectionMode.log();
if (single_value->field_selectionMode.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", teidDataI := ");
single_value->field_teidDataI.log_match(match_value.teidDataI(), legacy);
TTCN_Logger::log_event_str(", teidControlPlane := ");
if (match_value.teidControlPlane().ispresent()) {
single_value->field_teidControlPlane.log_match(match_value.teidControlPlane(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_teidControlPlane.log();
if (single_value->field_teidControlPlane.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", nsapi := ");
single_value->field_nsapi.log_match(match_value.nsapi(), legacy);
TTCN_Logger::log_event_str(", linked_nsapi := ");
if (match_value.linked__nsapi().ispresent()) {
single_value->field_linked__nsapi.log_match(match_value.linked__nsapi(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_linked__nsapi.log();
if (single_value->field_linked__nsapi.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", charging_char := ");
if (match_value.charging__char().ispresent()) {
single_value->field_charging__char.log_match(match_value.charging__char(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_charging__char.log();
if (single_value->field_charging__char.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", trace_ref := ");
if (match_value.trace__ref().ispresent()) {
single_value->field_trace__ref.log_match(match_value.trace__ref(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_trace__ref.log();
if (single_value->field_trace__ref.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", trace_type := ");
if (match_value.trace__type().ispresent()) {
single_value->field_trace__type.log_match(match_value.trace__type(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_trace__type.log();
if (single_value->field_trace__type.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", endUserAddress := ");
if (match_value.endUserAddress().ispresent()) {
single_value->field_endUserAddress.log_match(match_value.endUserAddress(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_endUserAddress.log();
if (single_value->field_endUserAddress.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", accessPointName := ");
if (match_value.accessPointName().ispresent()) {
single_value->field_accessPointName.log_match(match_value.accessPointName(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_accessPointName.log();
if (single_value->field_accessPointName.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", protConfigOptions := ");
if (match_value.protConfigOptions().ispresent()) {
single_value->field_protConfigOptions.log_match(match_value.protConfigOptions(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_protConfigOptions.log();
if (single_value->field_protConfigOptions.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", sgsn_addr_signalling := ");
single_value->field_sgsn__addr__signalling.log_match(match_value.sgsn__addr__signalling(), legacy);
TTCN_Logger::log_event_str(", sgsn_addr_traffic := ");
single_value->field_sgsn__addr__traffic.log_match(match_value.sgsn__addr__traffic(), legacy);
TTCN_Logger::log_event_str(", msisdn := ");
if (match_value.msisdn().ispresent()) {
single_value->field_msisdn.log_match(match_value.msisdn(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_msisdn.log();
if (single_value->field_msisdn.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", qualityOfServiceProfile := ");
single_value->field_qualityOfServiceProfile.log_match(match_value.qualityOfServiceProfile(), legacy);
TTCN_Logger::log_event_str(", tft := ");
if (match_value.tft().ispresent()) {
single_value->field_tft.log_match(match_value.tft(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_tft.log();
if (single_value->field_tft.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", triggerId := ");
if (match_value.triggerId().ispresent()) {
single_value->field_triggerId.log_match(match_value.triggerId(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_triggerId.log();
if (single_value->field_triggerId.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", omcId := ");
if (match_value.omcId().ispresent()) {
single_value->field_omcId.log_match(match_value.omcId(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_omcId.log();
if (single_value->field_omcId.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", commonFlags := ");
if (match_value.commonFlags().ispresent()) {
single_value->field_commonFlags.log_match(match_value.commonFlags(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_commonFlags.log();
if (single_value->field_commonFlags.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", aPN_Restriction := ");
if (match_value.aPN__Restriction().ispresent()) {
single_value->field_aPN__Restriction.log_match(match_value.aPN__Restriction(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_aPN__Restriction.log();
if (single_value->field_aPN__Restriction.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", ratType := ");
if (match_value.ratType().ispresent()) {
single_value->field_ratType.log_match(match_value.ratType(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_ratType.log();
if (single_value->field_ratType.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", userLocationInformation := ");
if (match_value.userLocationInformation().ispresent()) {
single_value->field_userLocationInformation.log_match(match_value.userLocationInformation(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_userLocationInformation.log();
if (single_value->field_userLocationInformation.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", mS_TimeZone := ");
if (match_value.mS__TimeZone().ispresent()) {
single_value->field_mS__TimeZone.log_match(match_value.mS__TimeZone(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_mS__TimeZone.log();
if (single_value->field_mS__TimeZone.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", imeisv := ");
if (match_value.imeisv().ispresent()) {
single_value->field_imeisv.log_match(match_value.imeisv(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_imeisv.log();
if (single_value->field_imeisv.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", camelChargingInformationContainer := ");
if (match_value.camelChargingInformationContainer().ispresent()) {
single_value->field_camelChargingInformationContainer.log_match(match_value.camelChargingInformationContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_camelChargingInformationContainer.log();
if (single_value->field_camelChargingInformationContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", additionalTraceInfo := ");
if (match_value.additionalTraceInfo().ispresent()) {
single_value->field_additionalTraceInfo.log_match(match_value.additionalTraceInfo(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_additionalTraceInfo.log();
if (single_value->field_additionalTraceInfo.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", correlationID := ");
if (match_value.correlationID().ispresent()) {
single_value->field_correlationID.log_match(match_value.correlationID(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_correlationID.log();
if (single_value->field_correlationID.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", evolvedAllocationRetentionPriorityI := ");
if (match_value.evolvedAllocationRetentionPriorityI().ispresent()) {
single_value->field_evolvedAllocationRetentionPriorityI.log_match(match_value.evolvedAllocationRetentionPriorityI(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_evolvedAllocationRetentionPriorityI.log();
if (single_value->field_evolvedAllocationRetentionPriorityI.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", extendedCommonFlags := ");
if (match_value.extendedCommonFlags().ispresent()) {
single_value->field_extendedCommonFlags.log_match(match_value.extendedCommonFlags(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extendedCommonFlags.log();
if (single_value->field_extendedCommonFlags.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", userCSGInformation := ");
if (match_value.userCSGInformation().ispresent()) {
single_value->field_userCSGInformation.log_match(match_value.userCSGInformation(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_userCSGInformation.log();
if (single_value->field_userCSGInformation.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", aPN_AMBR := ");
if (match_value.aPN__AMBR().ispresent()) {
single_value->field_aPN__AMBR.log_match(match_value.aPN__AMBR(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_aPN__AMBR.log();
if (single_value->field_aPN__AMBR.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", signallingPriorityIndication := ");
if (match_value.signallingPriorityIndication().ispresent()) {
single_value->field_signallingPriorityIndication.log_match(match_value.signallingPriorityIndication(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_signallingPriorityIndication.log();
if (single_value->field_signallingPriorityIndication.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", cN_OperatorSelectionEntity := ");
if (match_value.cN__OperatorSelectionEntity().ispresent()) {
single_value->field_cN__OperatorSelectionEntity.log_match(match_value.cN__OperatorSelectionEntity(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_cN__OperatorSelectionEntity.log();
if (single_value->field_cN__OperatorSelectionEntity.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", private_extension_gtpc := ");
if (match_value.private__extension__gtpc().ispresent()) {
single_value->field_private__extension__gtpc.log_match(match_value.private__extension__gtpc(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_private__extension__gtpc.log();
if (single_value->field_private__extension__gtpc.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void CreatePDPContextRequest_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!imsi().is_bound()) imsi() = OMIT_VALUE;
else imsi().set_implicit_omit();
if (!rai().is_bound()) rai() = OMIT_VALUE;
else rai().set_implicit_omit();
if (!recovery().is_bound()) recovery() = OMIT_VALUE;
else recovery().set_implicit_omit();
if (!selectionMode().is_bound()) selectionMode() = OMIT_VALUE;
else selectionMode().set_implicit_omit();
if (teidDataI().is_bound()) teidDataI().set_implicit_omit();
if (!teidControlPlane().is_bound()) teidControlPlane() = OMIT_VALUE;
else teidControlPlane().set_implicit_omit();
if (nsapi().is_bound()) nsapi().set_implicit_omit();
if (!linked__nsapi().is_bound()) linked__nsapi() = OMIT_VALUE;
else linked__nsapi().set_implicit_omit();
if (!charging__char().is_bound()) charging__char() = OMIT_VALUE;
else charging__char().set_implicit_omit();
if (!trace__ref().is_bound()) trace__ref() = OMIT_VALUE;
else trace__ref().set_implicit_omit();
if (!trace__type().is_bound()) trace__type() = OMIT_VALUE;
else trace__type().set_implicit_omit();
if (!endUserAddress().is_bound()) endUserAddress() = OMIT_VALUE;
else endUserAddress().set_implicit_omit();
if (!accessPointName().is_bound()) accessPointName() = OMIT_VALUE;
else accessPointName().set_implicit_omit();
if (!protConfigOptions().is_bound()) protConfigOptions() = OMIT_VALUE;
else protConfigOptions().set_implicit_omit();
if (sgsn__addr__signalling().is_bound()) sgsn__addr__signalling().set_implicit_omit();
if (sgsn__addr__traffic().is_bound()) sgsn__addr__traffic().set_implicit_omit();
if (!msisdn().is_bound()) msisdn() = OMIT_VALUE;
else msisdn().set_implicit_omit();
if (qualityOfServiceProfile().is_bound()) qualityOfServiceProfile().set_implicit_omit();
if (!tft().is_bound()) tft() = OMIT_VALUE;
else tft().set_implicit_omit();
if (!triggerId().is_bound()) triggerId() = OMIT_VALUE;
else triggerId().set_implicit_omit();
if (!omcId().is_bound()) omcId() = OMIT_VALUE;
else omcId().set_implicit_omit();
if (!commonFlags().is_bound()) commonFlags() = OMIT_VALUE;
else commonFlags().set_implicit_omit();
if (!aPN__Restriction().is_bound()) aPN__Restriction() = OMIT_VALUE;
else aPN__Restriction().set_implicit_omit();
if (!ratType().is_bound()) ratType() = OMIT_VALUE;
else ratType().set_implicit_omit();
if (!userLocationInformation().is_bound()) userLocationInformation() = OMIT_VALUE;
else userLocationInformation().set_implicit_omit();
if (!mS__TimeZone().is_bound()) mS__TimeZone() = OMIT_VALUE;
else mS__TimeZone().set_implicit_omit();
if (!imeisv().is_bound()) imeisv() = OMIT_VALUE;
else imeisv().set_implicit_omit();
if (!camelChargingInformationContainer().is_bound()) camelChargingInformationContainer() = OMIT_VALUE;
else camelChargingInformationContainer().set_implicit_omit();
if (!additionalTraceInfo().is_bound()) additionalTraceInfo() = OMIT_VALUE;
else additionalTraceInfo().set_implicit_omit();
if (!correlationID().is_bound()) correlationID() = OMIT_VALUE;
else correlationID().set_implicit_omit();
if (!evolvedAllocationRetentionPriorityI().is_bound()) evolvedAllocationRetentionPriorityI() = OMIT_VALUE;
else evolvedAllocationRetentionPriorityI().set_implicit_omit();
if (!extendedCommonFlags().is_bound()) extendedCommonFlags() = OMIT_VALUE;
else extendedCommonFlags().set_implicit_omit();
if (!userCSGInformation().is_bound()) userCSGInformation() = OMIT_VALUE;
else userCSGInformation().set_implicit_omit();
if (!aPN__AMBR().is_bound()) aPN__AMBR() = OMIT_VALUE;
else aPN__AMBR().set_implicit_omit();
if (!signallingPriorityIndication().is_bound()) signallingPriorityIndication() = OMIT_VALUE;
else signallingPriorityIndication().set_implicit_omit();
if (!cN__OperatorSelectionEntity().is_bound()) cN__OperatorSelectionEntity() = OMIT_VALUE;
else cN__OperatorSelectionEntity().set_implicit_omit();
if (!private__extension__gtpc().is_bound()) private__extension__gtpc() = OMIT_VALUE;
else private__extension__gtpc().set_implicit_omit();
}

void CreatePDPContextRequest_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_imsi.encode_text(text_buf);
single_value->field_rai.encode_text(text_buf);
single_value->field_recovery.encode_text(text_buf);
single_value->field_selectionMode.encode_text(text_buf);
single_value->field_teidDataI.encode_text(text_buf);
single_value->field_teidControlPlane.encode_text(text_buf);
single_value->field_nsapi.encode_text(text_buf);
single_value->field_linked__nsapi.encode_text(text_buf);
single_value->field_charging__char.encode_text(text_buf);
single_value->field_trace__ref.encode_text(text_buf);
single_value->field_trace__type.encode_text(text_buf);
single_value->field_endUserAddress.encode_text(text_buf);
single_value->field_accessPointName.encode_text(text_buf);
single_value->field_protConfigOptions.encode_text(text_buf);
single_value->field_sgsn__addr__signalling.encode_text(text_buf);
single_value->field_sgsn__addr__traffic.encode_text(text_buf);
single_value->field_msisdn.encode_text(text_buf);
single_value->field_qualityOfServiceProfile.encode_text(text_buf);
single_value->field_tft.encode_text(text_buf);
single_value->field_triggerId.encode_text(text_buf);
single_value->field_omcId.encode_text(text_buf);
single_value->field_commonFlags.encode_text(text_buf);
single_value->field_aPN__Restriction.encode_text(text_buf);
single_value->field_ratType.encode_text(text_buf);
single_value->field_userLocationInformation.encode_text(text_buf);
single_value->field_mS__TimeZone.encode_text(text_buf);
single_value->field_imeisv.encode_text(text_buf);
single_value->field_camelChargingInformationContainer.encode_text(text_buf);
single_value->field_additionalTraceInfo.encode_text(text_buf);
single_value->field_correlationID.encode_text(text_buf);
single_value->field_evolvedAllocationRetentionPriorityI.encode_text(text_buf);
single_value->field_extendedCommonFlags.encode_text(text_buf);
single_value->field_userCSGInformation.encode_text(text_buf);
single_value->field_aPN__AMBR.encode_text(text_buf);
single_value->field_signallingPriorityIndication.encode_text(text_buf);
single_value->field_cN__OperatorSelectionEntity.encode_text(text_buf);
single_value->field_private__extension__gtpc.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.CreatePDPContextRequest.");
}
}

void CreatePDPContextRequest_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_imsi.decode_text(text_buf);
single_value->field_rai.decode_text(text_buf);
single_value->field_recovery.decode_text(text_buf);
single_value->field_selectionMode.decode_text(text_buf);
single_value->field_teidDataI.decode_text(text_buf);
single_value->field_teidControlPlane.decode_text(text_buf);
single_value->field_nsapi.decode_text(text_buf);
single_value->field_linked__nsapi.decode_text(text_buf);
single_value->field_charging__char.decode_text(text_buf);
single_value->field_trace__ref.decode_text(text_buf);
single_value->field_trace__type.decode_text(text_buf);
single_value->field_endUserAddress.decode_text(text_buf);
single_value->field_accessPointName.decode_text(text_buf);
single_value->field_protConfigOptions.decode_text(text_buf);
single_value->field_sgsn__addr__signalling.decode_text(text_buf);
single_value->field_sgsn__addr__traffic.decode_text(text_buf);
single_value->field_msisdn.decode_text(text_buf);
single_value->field_qualityOfServiceProfile.decode_text(text_buf);
single_value->field_tft.decode_text(text_buf);
single_value->field_triggerId.decode_text(text_buf);
single_value->field_omcId.decode_text(text_buf);
single_value->field_commonFlags.decode_text(text_buf);
single_value->field_aPN__Restriction.decode_text(text_buf);
single_value->field_ratType.decode_text(text_buf);
single_value->field_userLocationInformation.decode_text(text_buf);
single_value->field_mS__TimeZone.decode_text(text_buf);
single_value->field_imeisv.decode_text(text_buf);
single_value->field_camelChargingInformationContainer.decode_text(text_buf);
single_value->field_additionalTraceInfo.decode_text(text_buf);
single_value->field_correlationID.decode_text(text_buf);
single_value->field_evolvedAllocationRetentionPriorityI.decode_text(text_buf);
single_value->field_extendedCommonFlags.decode_text(text_buf);
single_value->field_userCSGInformation.decode_text(text_buf);
single_value->field_aPN__AMBR.decode_text(text_buf);
single_value->field_signallingPriorityIndication.decode_text(text_buf);
single_value->field_cN__OperatorSelectionEntity.decode_text(text_buf);
single_value->field_private__extension__gtpc.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new CreatePDPContextRequest_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.CreatePDPContextRequest.");
}
}

void CreatePDPContextRequest_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    CreatePDPContextRequest_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (37<param.get_size()) {
      param.error("record template of type @GTPC_Types.CreatePDPContextRequest has 37 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) imsi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) rai().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) recovery().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) selectionMode().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) teidDataI().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) teidControlPlane().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) nsapi().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) linked__nsapi().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) charging__char().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) trace__ref().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) trace__type().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) endUserAddress().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) accessPointName().set_param(*param.get_elem(12));
    if (param.get_size()>13 && param.get_elem(13)->get_type()!=Module_Param::MP_NotUsed) protConfigOptions().set_param(*param.get_elem(13));
    if (param.get_size()>14 && param.get_elem(14)->get_type()!=Module_Param::MP_NotUsed) sgsn__addr__signalling().set_param(*param.get_elem(14));
    if (param.get_size()>15 && param.get_elem(15)->get_type()!=Module_Param::MP_NotUsed) sgsn__addr__traffic().set_param(*param.get_elem(15));
    if (param.get_size()>16 && param.get_elem(16)->get_type()!=Module_Param::MP_NotUsed) msisdn().set_param(*param.get_elem(16));
    if (param.get_size()>17 && param.get_elem(17)->get_type()!=Module_Param::MP_NotUsed) qualityOfServiceProfile().set_param(*param.get_elem(17));
    if (param.get_size()>18 && param.get_elem(18)->get_type()!=Module_Param::MP_NotUsed) tft().set_param(*param.get_elem(18));
    if (param.get_size()>19 && param.get_elem(19)->get_type()!=Module_Param::MP_NotUsed) triggerId().set_param(*param.get_elem(19));
    if (param.get_size()>20 && param.get_elem(20)->get_type()!=Module_Param::MP_NotUsed) omcId().set_param(*param.get_elem(20));
    if (param.get_size()>21 && param.get_elem(21)->get_type()!=Module_Param::MP_NotUsed) commonFlags().set_param(*param.get_elem(21));
    if (param.get_size()>22 && param.get_elem(22)->get_type()!=Module_Param::MP_NotUsed) aPN__Restriction().set_param(*param.get_elem(22));
    if (param.get_size()>23 && param.get_elem(23)->get_type()!=Module_Param::MP_NotUsed) ratType().set_param(*param.get_elem(23));
    if (param.get_size()>24 && param.get_elem(24)->get_type()!=Module_Param::MP_NotUsed) userLocationInformation().set_param(*param.get_elem(24));
    if (param.get_size()>25 && param.get_elem(25)->get_type()!=Module_Param::MP_NotUsed) mS__TimeZone().set_param(*param.get_elem(25));
    if (param.get_size()>26 && param.get_elem(26)->get_type()!=Module_Param::MP_NotUsed) imeisv().set_param(*param.get_elem(26));
    if (param.get_size()>27 && param.get_elem(27)->get_type()!=Module_Param::MP_NotUsed) camelChargingInformationContainer().set_param(*param.get_elem(27));
    if (param.get_size()>28 && param.get_elem(28)->get_type()!=Module_Param::MP_NotUsed) additionalTraceInfo().set_param(*param.get_elem(28));
    if (param.get_size()>29 && param.get_elem(29)->get_type()!=Module_Param::MP_NotUsed) correlationID().set_param(*param.get_elem(29));
    if (param.get_size()>30 && param.get_elem(30)->get_type()!=Module_Param::MP_NotUsed) evolvedAllocationRetentionPriorityI().set_param(*param.get_elem(30));
    if (param.get_size()>31 && param.get_elem(31)->get_type()!=Module_Param::MP_NotUsed) extendedCommonFlags().set_param(*param.get_elem(31));
    if (param.get_size()>32 && param.get_elem(32)->get_type()!=Module_Param::MP_NotUsed) userCSGInformation().set_param(*param.get_elem(32));
    if (param.get_size()>33 && param.get_elem(33)->get_type()!=Module_Param::MP_NotUsed) aPN__AMBR().set_param(*param.get_elem(33));
    if (param.get_size()>34 && param.get_elem(34)->get_type()!=Module_Param::MP_NotUsed) signallingPriorityIndication().set_param(*param.get_elem(34));
    if (param.get_size()>35 && param.get_elem(35)->get_type()!=Module_Param::MP_NotUsed) cN__OperatorSelectionEntity().set_param(*param.get_elem(35));
    if (param.get_size()>36 && param.get_elem(36)->get_type()!=Module_Param::MP_NotUsed) private__extension__gtpc().set_param(*param.get_elem(36));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rai")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rai().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "recovery")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          recovery().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "selectionMode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          selectionMode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "teidDataI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          teidDataI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "teidControlPlane")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          teidControlPlane().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsapi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsapi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "linked_nsapi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          linked__nsapi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "charging_char")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          charging__char().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "trace_ref")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          trace__ref().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "trace_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          trace__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "endUserAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          endUserAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "accessPointName")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          accessPointName().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protConfigOptions")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protConfigOptions().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sgsn_addr_signalling")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sgsn__addr__signalling().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sgsn_addr_traffic")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sgsn__addr__traffic().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "msisdn")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          msisdn().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "qualityOfServiceProfile")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          qualityOfServiceProfile().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tft")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tft().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "triggerId")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          triggerId().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "omcId")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          omcId().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "commonFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          commonFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aPN_Restriction")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aPN__Restriction().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ratType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ratType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "userLocationInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          userLocationInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mS_TimeZone")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mS__TimeZone().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imeisv")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imeisv().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "camelChargingInformationContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          camelChargingInformationContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "additionalTraceInfo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          additionalTraceInfo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "correlationID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          correlationID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "evolvedAllocationRetentionPriorityI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          evolvedAllocationRetentionPriorityI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extendedCommonFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extendedCommonFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "userCSGInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          userCSGInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aPN_AMBR")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aPN__AMBR().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "signallingPriorityIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          signallingPriorityIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cN_OperatorSelectionEntity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cN__OperatorSelectionEntity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "private_extension_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          private__extension__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.CreatePDPContextRequest: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    CreatePDPContextRequest_template* precondition = new CreatePDPContextRequest_template;
    precondition->set_param(*param.get_elem(0));
    CreatePDPContextRequest_template* implied_template = new CreatePDPContextRequest_template;
    implied_template->set_param(*param.get_elem(1));
    *this = CreatePDPContextRequest_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.CreatePDPContextRequest");
  }
  is_ifpresent = param.get_ifpresent();
}

void CreatePDPContextRequest_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_imsi.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_rai.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_recovery.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_selectionMode.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_teidDataI.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_teidControlPlane.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_nsapi.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_linked__nsapi.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_charging__char.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_trace__ref.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_trace__type.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_endUserAddress.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_accessPointName.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_protConfigOptions.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_sgsn__addr__signalling.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_sgsn__addr__traffic.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_msisdn.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_qualityOfServiceProfile.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_tft.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_triggerId.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_omcId.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_commonFlags.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_aPN__Restriction.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_ratType.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_userLocationInformation.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_mS__TimeZone.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_imeisv.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_camelChargingInformationContainer.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_additionalTraceInfo.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_correlationID.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_evolvedAllocationRetentionPriorityI.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_extendedCommonFlags.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_userCSGInformation.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_aPN__AMBR.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_signallingPriorityIndication.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_cN__OperatorSelectionEntity.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
single_value->field_private__extension__gtpc.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.CreatePDPContextRequest");
}

boolean CreatePDPContextRequest_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean CreatePDPContextRequest_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

CreatePDPContextResponse::CreatePDPContextResponse()
{
}

CreatePDPContextResponse::CreatePDPContextResponse(const Cause__gtpc& par_cause,
    const OPTIONAL< ReorderingRequired >& par_reorderingRequired,
    const OPTIONAL< Recovery__gtpc >& par_recovery,
    const OPTIONAL< TeidDataI >& par_teidDataI,
    const OPTIONAL< TeidControlPlane >& par_teidControlPlane,
    const OPTIONAL< NSAPI__GTPC >& par_nsapi,
    const OPTIONAL< ChargingID >& par_chargingID,
    const OPTIONAL< EndUserAddress >& par_endUserAddress,
    const OPTIONAL< ProtConfigOptions >& par_protConfigOptions,
    const OPTIONAL< GSN__Address__GTPC >& par_ggsn__addr__controlPlane,
    const OPTIONAL< GSN__Address__GTPC >& par_ggsn__addr__traffic,
    const OPTIONAL< GSN__Address__GTPC >& par_alt__ggsn__addr__controlPane,
    const OPTIONAL< GSN__Address__GTPC >& par_alt__ggsn__addr__traffic,
    const OPTIONAL< QualityOfServiceProfile >& par_qualityOfServiceProfile,
    const OPTIONAL< CommonFlags >& par_commonFlags,
    const OPTIONAL< APN__Restriction >& par_aPN__Restriction,
    const OPTIONAL< MS__InfoChangeReportingAction >& par_mS__InfoChangeReportingAction,
    const OPTIONAL< BearerControlMode >& par_bearerControlMode,
    const OPTIONAL< EvolvedAllocationRetentionPriorityI >& par_evolvedAllocationRetentionPriorityI,
    const OPTIONAL< ExtendedCommonFlags >& par_extendedCommonFlag,
    const OPTIONAL< CSGInfoReportingAction >& par_csg__information__reporting__action,
    const OPTIONAL< APN__AMBR >& par_aPN__AMBR,
    const OPTIONAL< GGSN__BackOffTime >& par_gGSN__BackOffTime,
    const OPTIONAL< PrivateExtension__gtpc__List >& par_private__extension__gtpc)
  :   field_cause(par_cause),
  field_reorderingRequired(par_reorderingRequired),
  field_recovery(par_recovery),
  field_teidDataI(par_teidDataI),
  field_teidControlPlane(par_teidControlPlane),
  field_nsapi(par_nsapi),
  field_chargingID(par_chargingID),
  field_endUserAddress(par_endUserAddress),
  field_protConfigOptions(par_protConfigOptions),
  field_ggsn__addr__controlPlane(par_ggsn__addr__controlPlane),
  field_ggsn__addr__traffic(par_ggsn__addr__traffic),
  field_alt__ggsn__addr__controlPane(par_alt__ggsn__addr__controlPane),
  field_alt__ggsn__addr__traffic(par_alt__ggsn__addr__traffic),
  field_qualityOfServiceProfile(par_qualityOfServiceProfile),
  field_commonFlags(par_commonFlags),
  field_aPN__Restriction(par_aPN__Restriction),
  field_mS__InfoChangeReportingAction(par_mS__InfoChangeReportingAction),
  field_bearerControlMode(par_bearerControlMode),
  field_evolvedAllocationRetentionPriorityI(par_evolvedAllocationRetentionPriorityI),
  field_extendedCommonFlag(par_extendedCommonFlag),
  field_csg__information__reporting__action(par_csg__information__reporting__action),
  field_aPN__AMBR(par_aPN__AMBR),
  field_gGSN__BackOffTime(par_gGSN__BackOffTime),
  field_private__extension__gtpc(par_private__extension__gtpc)
{
}

CreatePDPContextResponse::CreatePDPContextResponse(const CreatePDPContextResponse& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.CreatePDPContextResponse.");
if (other_value.cause().is_bound()) field_cause = other_value.cause();
else field_cause.clean_up();
if (other_value.reorderingRequired().is_bound()) field_reorderingRequired = other_value.reorderingRequired();
else field_reorderingRequired.clean_up();
if (other_value.recovery().is_bound()) field_recovery = other_value.recovery();
else field_recovery.clean_up();
if (other_value.teidDataI().is_bound()) field_teidDataI = other_value.teidDataI();
else field_teidDataI.clean_up();
if (other_value.teidControlPlane().is_bound()) field_teidControlPlane = other_value.teidControlPlane();
else field_teidControlPlane.clean_up();
if (other_value.nsapi().is_bound()) field_nsapi = other_value.nsapi();
else field_nsapi.clean_up();
if (other_value.chargingID().is_bound()) field_chargingID = other_value.chargingID();
else field_chargingID.clean_up();
if (other_value.endUserAddress().is_bound()) field_endUserAddress = other_value.endUserAddress();
else field_endUserAddress.clean_up();
if (other_value.protConfigOptions().is_bound()) field_protConfigOptions = other_value.protConfigOptions();
else field_protConfigOptions.clean_up();
if (other_value.ggsn__addr__controlPlane().is_bound()) field_ggsn__addr__controlPlane = other_value.ggsn__addr__controlPlane();
else field_ggsn__addr__controlPlane.clean_up();
if (other_value.ggsn__addr__traffic().is_bound()) field_ggsn__addr__traffic = other_value.ggsn__addr__traffic();
else field_ggsn__addr__traffic.clean_up();
if (other_value.alt__ggsn__addr__controlPane().is_bound()) field_alt__ggsn__addr__controlPane = other_value.alt__ggsn__addr__controlPane();
else field_alt__ggsn__addr__controlPane.clean_up();
if (other_value.alt__ggsn__addr__traffic().is_bound()) field_alt__ggsn__addr__traffic = other_value.alt__ggsn__addr__traffic();
else field_alt__ggsn__addr__traffic.clean_up();
if (other_value.qualityOfServiceProfile().is_bound()) field_qualityOfServiceProfile = other_value.qualityOfServiceProfile();
else field_qualityOfServiceProfile.clean_up();
if (other_value.commonFlags().is_bound()) field_commonFlags = other_value.commonFlags();
else field_commonFlags.clean_up();
if (other_value.aPN__Restriction().is_bound()) field_aPN__Restriction = other_value.aPN__Restriction();
else field_aPN__Restriction.clean_up();
if (other_value.mS__InfoChangeReportingAction().is_bound()) field_mS__InfoChangeReportingAction = other_value.mS__InfoChangeReportingAction();
else field_mS__InfoChangeReportingAction.clean_up();
if (other_value.bearerControlMode().is_bound()) field_bearerControlMode = other_value.bearerControlMode();
else field_bearerControlMode.clean_up();
if (other_value.evolvedAllocationRetentionPriorityI().is_bound()) field_evolvedAllocationRetentionPriorityI = other_value.evolvedAllocationRetentionPriorityI();
else field_evolvedAllocationRetentionPriorityI.clean_up();
if (other_value.extendedCommonFlag().is_bound()) field_extendedCommonFlag = other_value.extendedCommonFlag();
else field_extendedCommonFlag.clean_up();
if (other_value.csg__information__reporting__action().is_bound()) field_csg__information__reporting__action = other_value.csg__information__reporting__action();
else field_csg__information__reporting__action.clean_up();
if (other_value.aPN__AMBR().is_bound()) field_aPN__AMBR = other_value.aPN__AMBR();
else field_aPN__AMBR.clean_up();
if (other_value.gGSN__BackOffTime().is_bound()) field_gGSN__BackOffTime = other_value.gGSN__BackOffTime();
else field_gGSN__BackOffTime.clean_up();
if (other_value.private__extension__gtpc().is_bound()) field_private__extension__gtpc = other_value.private__extension__gtpc();
else field_private__extension__gtpc.clean_up();
}

void CreatePDPContextResponse::clean_up()
{
field_cause.clean_up();
field_reorderingRequired.clean_up();
field_recovery.clean_up();
field_teidDataI.clean_up();
field_teidControlPlane.clean_up();
field_nsapi.clean_up();
field_chargingID.clean_up();
field_endUserAddress.clean_up();
field_protConfigOptions.clean_up();
field_ggsn__addr__controlPlane.clean_up();
field_ggsn__addr__traffic.clean_up();
field_alt__ggsn__addr__controlPane.clean_up();
field_alt__ggsn__addr__traffic.clean_up();
field_qualityOfServiceProfile.clean_up();
field_commonFlags.clean_up();
field_aPN__Restriction.clean_up();
field_mS__InfoChangeReportingAction.clean_up();
field_bearerControlMode.clean_up();
field_evolvedAllocationRetentionPriorityI.clean_up();
field_extendedCommonFlag.clean_up();
field_csg__information__reporting__action.clean_up();
field_aPN__AMBR.clean_up();
field_gGSN__BackOffTime.clean_up();
field_private__extension__gtpc.clean_up();
}

const TTCN_Typedescriptor_t* CreatePDPContextResponse::get_descriptor() const { return &CreatePDPContextResponse_descr_; }
CreatePDPContextResponse& CreatePDPContextResponse::operator=(const CreatePDPContextResponse& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.CreatePDPContextResponse.");
  if (other_value.cause().is_bound()) field_cause = other_value.cause();
  else field_cause.clean_up();
  if (other_value.reorderingRequired().is_bound()) field_reorderingRequired = other_value.reorderingRequired();
  else field_reorderingRequired.clean_up();
  if (other_value.recovery().is_bound()) field_recovery = other_value.recovery();
  else field_recovery.clean_up();
  if (other_value.teidDataI().is_bound()) field_teidDataI = other_value.teidDataI();
  else field_teidDataI.clean_up();
  if (other_value.teidControlPlane().is_bound()) field_teidControlPlane = other_value.teidControlPlane();
  else field_teidControlPlane.clean_up();
  if (other_value.nsapi().is_bound()) field_nsapi = other_value.nsapi();
  else field_nsapi.clean_up();
  if (other_value.chargingID().is_bound()) field_chargingID = other_value.chargingID();
  else field_chargingID.clean_up();
  if (other_value.endUserAddress().is_bound()) field_endUserAddress = other_value.endUserAddress();
  else field_endUserAddress.clean_up();
  if (other_value.protConfigOptions().is_bound()) field_protConfigOptions = other_value.protConfigOptions();
  else field_protConfigOptions.clean_up();
  if (other_value.ggsn__addr__controlPlane().is_bound()) field_ggsn__addr__controlPlane = other_value.ggsn__addr__controlPlane();
  else field_ggsn__addr__controlPlane.clean_up();
  if (other_value.ggsn__addr__traffic().is_bound()) field_ggsn__addr__traffic = other_value.ggsn__addr__traffic();
  else field_ggsn__addr__traffic.clean_up();
  if (other_value.alt__ggsn__addr__controlPane().is_bound()) field_alt__ggsn__addr__controlPane = other_value.alt__ggsn__addr__controlPane();
  else field_alt__ggsn__addr__controlPane.clean_up();
  if (other_value.alt__ggsn__addr__traffic().is_bound()) field_alt__ggsn__addr__traffic = other_value.alt__ggsn__addr__traffic();
  else field_alt__ggsn__addr__traffic.clean_up();
  if (other_value.qualityOfServiceProfile().is_bound()) field_qualityOfServiceProfile = other_value.qualityOfServiceProfile();
  else field_qualityOfServiceProfile.clean_up();
  if (other_value.commonFlags().is_bound()) field_commonFlags = other_value.commonFlags();
  else field_commonFlags.clean_up();
  if (other_value.aPN__Restriction().is_bound()) field_aPN__Restriction = other_value.aPN__Restriction();
  else field_aPN__Restriction.clean_up();
  if (other_value.mS__InfoChangeReportingAction().is_bound()) field_mS__InfoChangeReportingAction = other_value.mS__InfoChangeReportingAction();
  else field_mS__InfoChangeReportingAction.clean_up();
  if (other_value.bearerControlMode().is_bound()) field_bearerControlMode = other_value.bearerControlMode();
  else field_bearerControlMode.clean_up();
  if (other_value.evolvedAllocationRetentionPriorityI().is_bound()) field_evolvedAllocationRetentionPriorityI = other_value.evolvedAllocationRetentionPriorityI();
  else field_evolvedAllocationRetentionPriorityI.clean_up();
  if (other_value.extendedCommonFlag().is_bound()) field_extendedCommonFlag = other_value.extendedCommonFlag();
  else field_extendedCommonFlag.clean_up();
  if (other_value.csg__information__reporting__action().is_bound()) field_csg__information__reporting__action = other_value.csg__information__reporting__action();
  else field_csg__information__reporting__action.clean_up();
  if (other_value.aPN__AMBR().is_bound()) field_aPN__AMBR = other_value.aPN__AMBR();
  else field_aPN__AMBR.clean_up();
  if (other_value.gGSN__BackOffTime().is_bound()) field_gGSN__BackOffTime = other_value.gGSN__BackOffTime();
  else field_gGSN__BackOffTime.clean_up();
  if (other_value.private__extension__gtpc().is_bound()) field_private__extension__gtpc = other_value.private__extension__gtpc();
  else field_private__extension__gtpc.clean_up();
}
return *this;
}

boolean CreatePDPContextResponse::operator==(const CreatePDPContextResponse& other_value) const
{
return field_cause==other_value.field_cause
  && field_reorderingRequired==other_value.field_reorderingRequired
  && field_recovery==other_value.field_recovery
  && field_teidDataI==other_value.field_teidDataI
  && field_teidControlPlane==other_value.field_teidControlPlane
  && field_nsapi==other_value.field_nsapi
  && field_chargingID==other_value.field_chargingID
  && field_endUserAddress==other_value.field_endUserAddress
  && field_protConfigOptions==other_value.field_protConfigOptions
  && field_ggsn__addr__controlPlane==other_value.field_ggsn__addr__controlPlane
  && field_ggsn__addr__traffic==other_value.field_ggsn__addr__traffic
  && field_alt__ggsn__addr__controlPane==other_value.field_alt__ggsn__addr__controlPane
  && field_alt__ggsn__addr__traffic==other_value.field_alt__ggsn__addr__traffic
  && field_qualityOfServiceProfile==other_value.field_qualityOfServiceProfile
  && field_commonFlags==other_value.field_commonFlags
  && field_aPN__Restriction==other_value.field_aPN__Restriction
  && field_mS__InfoChangeReportingAction==other_value.field_mS__InfoChangeReportingAction
  && field_bearerControlMode==other_value.field_bearerControlMode
  && field_evolvedAllocationRetentionPriorityI==other_value.field_evolvedAllocationRetentionPriorityI
  && field_extendedCommonFlag==other_value.field_extendedCommonFlag
  && field_csg__information__reporting__action==other_value.field_csg__information__reporting__action
  && field_aPN__AMBR==other_value.field_aPN__AMBR
  && field_gGSN__BackOffTime==other_value.field_gGSN__BackOffTime
  && field_private__extension__gtpc==other_value.field_private__extension__gtpc;
}

boolean CreatePDPContextResponse::is_bound() const
{
return (field_cause.is_bound())
  || (OPTIONAL_OMIT == field_reorderingRequired.get_selection() || field_reorderingRequired.is_bound())
  || (OPTIONAL_OMIT == field_recovery.get_selection() || field_recovery.is_bound())
  || (OPTIONAL_OMIT == field_teidDataI.get_selection() || field_teidDataI.is_bound())
  || (OPTIONAL_OMIT == field_teidControlPlane.get_selection() || field_teidControlPlane.is_bound())
  || (OPTIONAL_OMIT == field_nsapi.get_selection() || field_nsapi.is_bound())
  || (OPTIONAL_OMIT == field_chargingID.get_selection() || field_chargingID.is_bound())
  || (OPTIONAL_OMIT == field_endUserAddress.get_selection() || field_endUserAddress.is_bound())
  || (OPTIONAL_OMIT == field_protConfigOptions.get_selection() || field_protConfigOptions.is_bound())
  || (OPTIONAL_OMIT == field_ggsn__addr__controlPlane.get_selection() || field_ggsn__addr__controlPlane.is_bound())
  || (OPTIONAL_OMIT == field_ggsn__addr__traffic.get_selection() || field_ggsn__addr__traffic.is_bound())
  || (OPTIONAL_OMIT == field_alt__ggsn__addr__controlPane.get_selection() || field_alt__ggsn__addr__controlPane.is_bound())
  || (OPTIONAL_OMIT == field_alt__ggsn__addr__traffic.get_selection() || field_alt__ggsn__addr__traffic.is_bound())
  || (OPTIONAL_OMIT == field_qualityOfServiceProfile.get_selection() || field_qualityOfServiceProfile.is_bound())
  || (OPTIONAL_OMIT == field_commonFlags.get_selection() || field_commonFlags.is_bound())
  || (OPTIONAL_OMIT == field_aPN__Restriction.get_selection() || field_aPN__Restriction.is_bound())
  || (OPTIONAL_OMIT == field_mS__InfoChangeReportingAction.get_selection() || field_mS__InfoChangeReportingAction.is_bound())
  || (OPTIONAL_OMIT == field_bearerControlMode.get_selection() || field_bearerControlMode.is_bound())
  || (OPTIONAL_OMIT == field_evolvedAllocationRetentionPriorityI.get_selection() || field_evolvedAllocationRetentionPriorityI.is_bound())
  || (OPTIONAL_OMIT == field_extendedCommonFlag.get_selection() || field_extendedCommonFlag.is_bound())
  || (OPTIONAL_OMIT == field_csg__information__reporting__action.get_selection() || field_csg__information__reporting__action.is_bound())
  || (OPTIONAL_OMIT == field_aPN__AMBR.get_selection() || field_aPN__AMBR.is_bound())
  || (OPTIONAL_OMIT == field_gGSN__BackOffTime.get_selection() || field_gGSN__BackOffTime.is_bound())
  || (OPTIONAL_OMIT == field_private__extension__gtpc.get_selection() || field_private__extension__gtpc.is_bound());
}
boolean CreatePDPContextResponse::is_value() const
{
return field_cause.is_value()
  && (OPTIONAL_OMIT == field_reorderingRequired.get_selection() || field_reorderingRequired.is_value())
  && (OPTIONAL_OMIT == field_recovery.get_selection() || field_recovery.is_value())
  && (OPTIONAL_OMIT == field_teidDataI.get_selection() || field_teidDataI.is_value())
  && (OPTIONAL_OMIT == field_teidControlPlane.get_selection() || field_teidControlPlane.is_value())
  && (OPTIONAL_OMIT == field_nsapi.get_selection() || field_nsapi.is_value())
  && (OPTIONAL_OMIT == field_chargingID.get_selection() || field_chargingID.is_value())
  && (OPTIONAL_OMIT == field_endUserAddress.get_selection() || field_endUserAddress.is_value())
  && (OPTIONAL_OMIT == field_protConfigOptions.get_selection() || field_protConfigOptions.is_value())
  && (OPTIONAL_OMIT == field_ggsn__addr__controlPlane.get_selection() || field_ggsn__addr__controlPlane.is_value())
  && (OPTIONAL_OMIT == field_ggsn__addr__traffic.get_selection() || field_ggsn__addr__traffic.is_value())
  && (OPTIONAL_OMIT == field_alt__ggsn__addr__controlPane.get_selection() || field_alt__ggsn__addr__controlPane.is_value())
  && (OPTIONAL_OMIT == field_alt__ggsn__addr__traffic.get_selection() || field_alt__ggsn__addr__traffic.is_value())
  && (OPTIONAL_OMIT == field_qualityOfServiceProfile.get_selection() || field_qualityOfServiceProfile.is_value())
  && (OPTIONAL_OMIT == field_commonFlags.get_selection() || field_commonFlags.is_value())
  && (OPTIONAL_OMIT == field_aPN__Restriction.get_selection() || field_aPN__Restriction.is_value())
  && (OPTIONAL_OMIT == field_mS__InfoChangeReportingAction.get_selection() || field_mS__InfoChangeReportingAction.is_value())
  && (OPTIONAL_OMIT == field_bearerControlMode.get_selection() || field_bearerControlMode.is_value())
  && (OPTIONAL_OMIT == field_evolvedAllocationRetentionPriorityI.get_selection() || field_evolvedAllocationRetentionPriorityI.is_value())
  && (OPTIONAL_OMIT == field_extendedCommonFlag.get_selection() || field_extendedCommonFlag.is_value())
  && (OPTIONAL_OMIT == field_csg__information__reporting__action.get_selection() || field_csg__information__reporting__action.is_value())
  && (OPTIONAL_OMIT == field_aPN__AMBR.get_selection() || field_aPN__AMBR.is_value())
  && (OPTIONAL_OMIT == field_gGSN__BackOffTime.get_selection() || field_gGSN__BackOffTime.is_value())
  && (OPTIONAL_OMIT == field_private__extension__gtpc.get_selection() || field_private__extension__gtpc.is_value());
}
int CreatePDPContextResponse::size_of() const
{
  int ret_val = 1;
  if (field_reorderingRequired.ispresent()) ret_val++;
  if (field_recovery.ispresent()) ret_val++;
  if (field_teidDataI.ispresent()) ret_val++;
  if (field_teidControlPlane.ispresent()) ret_val++;
  if (field_nsapi.ispresent()) ret_val++;
  if (field_chargingID.ispresent()) ret_val++;
  if (field_endUserAddress.ispresent()) ret_val++;
  if (field_protConfigOptions.ispresent()) ret_val++;
  if (field_ggsn__addr__controlPlane.ispresent()) ret_val++;
  if (field_ggsn__addr__traffic.ispresent()) ret_val++;
  if (field_alt__ggsn__addr__controlPane.ispresent()) ret_val++;
  if (field_alt__ggsn__addr__traffic.ispresent()) ret_val++;
  if (field_qualityOfServiceProfile.ispresent()) ret_val++;
  if (field_commonFlags.ispresent()) ret_val++;
  if (field_aPN__Restriction.ispresent()) ret_val++;
  if (field_mS__InfoChangeReportingAction.ispresent()) ret_val++;
  if (field_bearerControlMode.ispresent()) ret_val++;
  if (field_evolvedAllocationRetentionPriorityI.ispresent()) ret_val++;
  if (field_extendedCommonFlag.ispresent()) ret_val++;
  if (field_csg__information__reporting__action.ispresent()) ret_val++;
  if (field_aPN__AMBR.ispresent()) ret_val++;
  if (field_gGSN__BackOffTime.ispresent()) ret_val++;
  if (field_private__extension__gtpc.ispresent()) ret_val++;
  return ret_val;
}

void CreatePDPContextResponse::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ cause := ");
field_cause.log();
TTCN_Logger::log_event_str(", reorderingRequired := ");
field_reorderingRequired.log();
TTCN_Logger::log_event_str(", recovery := ");
field_recovery.log();
TTCN_Logger::log_event_str(", teidDataI := ");
field_teidDataI.log();
TTCN_Logger::log_event_str(", teidControlPlane := ");
field_teidControlPlane.log();
TTCN_Logger::log_event_str(", nsapi := ");
field_nsapi.log();
TTCN_Logger::log_event_str(", chargingID := ");
field_chargingID.log();
TTCN_Logger::log_event_str(", endUserAddress := ");
field_endUserAddress.log();
TTCN_Logger::log_event_str(", protConfigOptions := ");
field_protConfigOptions.log();
TTCN_Logger::log_event_str(", ggsn_addr_controlPlane := ");
field_ggsn__addr__controlPlane.log();
TTCN_Logger::log_event_str(", ggsn_addr_traffic := ");
field_ggsn__addr__traffic.log();
TTCN_Logger::log_event_str(", alt_ggsn_addr_controlPane := ");
field_alt__ggsn__addr__controlPane.log();
TTCN_Logger::log_event_str(", alt_ggsn_addr_traffic := ");
field_alt__ggsn__addr__traffic.log();
TTCN_Logger::log_event_str(", qualityOfServiceProfile := ");
field_qualityOfServiceProfile.log();
TTCN_Logger::log_event_str(", commonFlags := ");
field_commonFlags.log();
TTCN_Logger::log_event_str(", aPN_Restriction := ");
field_aPN__Restriction.log();
TTCN_Logger::log_event_str(", mS_InfoChangeReportingAction := ");
field_mS__InfoChangeReportingAction.log();
TTCN_Logger::log_event_str(", bearerControlMode := ");
field_bearerControlMode.log();
TTCN_Logger::log_event_str(", evolvedAllocationRetentionPriorityI := ");
field_evolvedAllocationRetentionPriorityI.log();
TTCN_Logger::log_event_str(", extendedCommonFlag := ");
field_extendedCommonFlag.log();
TTCN_Logger::log_event_str(", csg_information_reporting_action := ");
field_csg__information__reporting__action.log();
TTCN_Logger::log_event_str(", aPN_AMBR := ");
field_aPN__AMBR.log();
TTCN_Logger::log_event_str(", gGSN_BackOffTime := ");
field_gGSN__BackOffTime.log();
TTCN_Logger::log_event_str(", private_extension_gtpc := ");
field_private__extension__gtpc.log();
TTCN_Logger::log_event_str(" }");
}

void CreatePDPContextResponse::set_implicit_omit()
{
if (cause().is_bound()) cause().set_implicit_omit();
if (!reorderingRequired().is_bound()) reorderingRequired() = OMIT_VALUE;
else reorderingRequired().set_implicit_omit();
if (!recovery().is_bound()) recovery() = OMIT_VALUE;
else recovery().set_implicit_omit();
if (!teidDataI().is_bound()) teidDataI() = OMIT_VALUE;
else teidDataI().set_implicit_omit();
if (!teidControlPlane().is_bound()) teidControlPlane() = OMIT_VALUE;
else teidControlPlane().set_implicit_omit();
if (!nsapi().is_bound()) nsapi() = OMIT_VALUE;
else nsapi().set_implicit_omit();
if (!chargingID().is_bound()) chargingID() = OMIT_VALUE;
else chargingID().set_implicit_omit();
if (!endUserAddress().is_bound()) endUserAddress() = OMIT_VALUE;
else endUserAddress().set_implicit_omit();
if (!protConfigOptions().is_bound()) protConfigOptions() = OMIT_VALUE;
else protConfigOptions().set_implicit_omit();
if (!ggsn__addr__controlPlane().is_bound()) ggsn__addr__controlPlane() = OMIT_VALUE;
else ggsn__addr__controlPlane().set_implicit_omit();
if (!ggsn__addr__traffic().is_bound()) ggsn__addr__traffic() = OMIT_VALUE;
else ggsn__addr__traffic().set_implicit_omit();
if (!alt__ggsn__addr__controlPane().is_bound()) alt__ggsn__addr__controlPane() = OMIT_VALUE;
else alt__ggsn__addr__controlPane().set_implicit_omit();
if (!alt__ggsn__addr__traffic().is_bound()) alt__ggsn__addr__traffic() = OMIT_VALUE;
else alt__ggsn__addr__traffic().set_implicit_omit();
if (!qualityOfServiceProfile().is_bound()) qualityOfServiceProfile() = OMIT_VALUE;
else qualityOfServiceProfile().set_implicit_omit();
if (!commonFlags().is_bound()) commonFlags() = OMIT_VALUE;
else commonFlags().set_implicit_omit();
if (!aPN__Restriction().is_bound()) aPN__Restriction() = OMIT_VALUE;
else aPN__Restriction().set_implicit_omit();
if (!mS__InfoChangeReportingAction().is_bound()) mS__InfoChangeReportingAction() = OMIT_VALUE;
else mS__InfoChangeReportingAction().set_implicit_omit();
if (!bearerControlMode().is_bound()) bearerControlMode() = OMIT_VALUE;
else bearerControlMode().set_implicit_omit();
if (!evolvedAllocationRetentionPriorityI().is_bound()) evolvedAllocationRetentionPriorityI() = OMIT_VALUE;
else evolvedAllocationRetentionPriorityI().set_implicit_omit();
if (!extendedCommonFlag().is_bound()) extendedCommonFlag() = OMIT_VALUE;
else extendedCommonFlag().set_implicit_omit();
if (!csg__information__reporting__action().is_bound()) csg__information__reporting__action() = OMIT_VALUE;
else csg__information__reporting__action().set_implicit_omit();
if (!aPN__AMBR().is_bound()) aPN__AMBR() = OMIT_VALUE;
else aPN__AMBR().set_implicit_omit();
if (!gGSN__BackOffTime().is_bound()) gGSN__BackOffTime() = OMIT_VALUE;
else gGSN__BackOffTime().set_implicit_omit();
if (!private__extension__gtpc().is_bound()) private__extension__gtpc() = OMIT_VALUE;
else private__extension__gtpc().set_implicit_omit();
}

void CreatePDPContextResponse::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (24<param.get_size()) {
      param.error("record value of type @GTPC_Types.CreatePDPContextResponse has 24 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) reorderingRequired().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) recovery().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) teidDataI().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) teidControlPlane().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) nsapi().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) chargingID().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) endUserAddress().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) protConfigOptions().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) ggsn__addr__controlPlane().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) ggsn__addr__traffic().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) alt__ggsn__addr__controlPane().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) alt__ggsn__addr__traffic().set_param(*param.get_elem(12));
    if (param.get_size()>13 && param.get_elem(13)->get_type()!=Module_Param::MP_NotUsed) qualityOfServiceProfile().set_param(*param.get_elem(13));
    if (param.get_size()>14 && param.get_elem(14)->get_type()!=Module_Param::MP_NotUsed) commonFlags().set_param(*param.get_elem(14));
    if (param.get_size()>15 && param.get_elem(15)->get_type()!=Module_Param::MP_NotUsed) aPN__Restriction().set_param(*param.get_elem(15));
    if (param.get_size()>16 && param.get_elem(16)->get_type()!=Module_Param::MP_NotUsed) mS__InfoChangeReportingAction().set_param(*param.get_elem(16));
    if (param.get_size()>17 && param.get_elem(17)->get_type()!=Module_Param::MP_NotUsed) bearerControlMode().set_param(*param.get_elem(17));
    if (param.get_size()>18 && param.get_elem(18)->get_type()!=Module_Param::MP_NotUsed) evolvedAllocationRetentionPriorityI().set_param(*param.get_elem(18));
    if (param.get_size()>19 && param.get_elem(19)->get_type()!=Module_Param::MP_NotUsed) extendedCommonFlag().set_param(*param.get_elem(19));
    if (param.get_size()>20 && param.get_elem(20)->get_type()!=Module_Param::MP_NotUsed) csg__information__reporting__action().set_param(*param.get_elem(20));
    if (param.get_size()>21 && param.get_elem(21)->get_type()!=Module_Param::MP_NotUsed) aPN__AMBR().set_param(*param.get_elem(21));
    if (param.get_size()>22 && param.get_elem(22)->get_type()!=Module_Param::MP_NotUsed) gGSN__BackOffTime().set_param(*param.get_elem(22));
    if (param.get_size()>23 && param.get_elem(23)->get_type()!=Module_Param::MP_NotUsed) private__extension__gtpc().set_param(*param.get_elem(23));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reorderingRequired")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reorderingRequired().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "recovery")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          recovery().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "teidDataI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          teidDataI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "teidControlPlane")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          teidControlPlane().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsapi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsapi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "chargingID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          chargingID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "endUserAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          endUserAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protConfigOptions")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protConfigOptions().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ggsn_addr_controlPlane")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ggsn__addr__controlPlane().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ggsn_addr_traffic")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ggsn__addr__traffic().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "alt_ggsn_addr_controlPane")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          alt__ggsn__addr__controlPane().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "alt_ggsn_addr_traffic")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          alt__ggsn__addr__traffic().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "qualityOfServiceProfile")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          qualityOfServiceProfile().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "commonFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          commonFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aPN_Restriction")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aPN__Restriction().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mS_InfoChangeReportingAction")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mS__InfoChangeReportingAction().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bearerControlMode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bearerControlMode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "evolvedAllocationRetentionPriorityI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          evolvedAllocationRetentionPriorityI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extendedCommonFlag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extendedCommonFlag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "csg_information_reporting_action")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          csg__information__reporting__action().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aPN_AMBR")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aPN__AMBR().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gGSN_BackOffTime")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gGSN__BackOffTime().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "private_extension_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          private__extension__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.CreatePDPContextResponse: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.CreatePDPContextResponse");
  }
}

void CreatePDPContextResponse::encode_text(Text_Buf& text_buf) const
{
field_cause.encode_text(text_buf);
field_reorderingRequired.encode_text(text_buf);
field_recovery.encode_text(text_buf);
field_teidDataI.encode_text(text_buf);
field_teidControlPlane.encode_text(text_buf);
field_nsapi.encode_text(text_buf);
field_chargingID.encode_text(text_buf);
field_endUserAddress.encode_text(text_buf);
field_protConfigOptions.encode_text(text_buf);
field_ggsn__addr__controlPlane.encode_text(text_buf);
field_ggsn__addr__traffic.encode_text(text_buf);
field_alt__ggsn__addr__controlPane.encode_text(text_buf);
field_alt__ggsn__addr__traffic.encode_text(text_buf);
field_qualityOfServiceProfile.encode_text(text_buf);
field_commonFlags.encode_text(text_buf);
field_aPN__Restriction.encode_text(text_buf);
field_mS__InfoChangeReportingAction.encode_text(text_buf);
field_bearerControlMode.encode_text(text_buf);
field_evolvedAllocationRetentionPriorityI.encode_text(text_buf);
field_extendedCommonFlag.encode_text(text_buf);
field_csg__information__reporting__action.encode_text(text_buf);
field_aPN__AMBR.encode_text(text_buf);
field_gGSN__BackOffTime.encode_text(text_buf);
field_private__extension__gtpc.encode_text(text_buf);
}

void CreatePDPContextResponse::decode_text(Text_Buf& text_buf)
{
field_cause.decode_text(text_buf);
field_reorderingRequired.decode_text(text_buf);
field_recovery.decode_text(text_buf);
field_teidDataI.decode_text(text_buf);
field_teidControlPlane.decode_text(text_buf);
field_nsapi.decode_text(text_buf);
field_chargingID.decode_text(text_buf);
field_endUserAddress.decode_text(text_buf);
field_protConfigOptions.decode_text(text_buf);
field_ggsn__addr__controlPlane.decode_text(text_buf);
field_ggsn__addr__traffic.decode_text(text_buf);
field_alt__ggsn__addr__controlPane.decode_text(text_buf);
field_alt__ggsn__addr__traffic.decode_text(text_buf);
field_qualityOfServiceProfile.decode_text(text_buf);
field_commonFlags.decode_text(text_buf);
field_aPN__Restriction.decode_text(text_buf);
field_mS__InfoChangeReportingAction.decode_text(text_buf);
field_bearerControlMode.decode_text(text_buf);
field_evolvedAllocationRetentionPriorityI.decode_text(text_buf);
field_extendedCommonFlag.decode_text(text_buf);
field_csg__information__reporting__action.decode_text(text_buf);
field_aPN__AMBR.decode_text(text_buf);
field_gGSN__BackOffTime.decode_text(text_buf);
field_private__extension__gtpc.decode_text(text_buf);
}

void CreatePDPContextResponse::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void CreatePDPContextResponse::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int CreatePDPContextResponse::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  RAW_Force_Omit field_0_force_omit(0, force_omit, Cause__gtpc_descr_.raw->forceomit);
  decoded_field_length = field_cause.RAW_decode(Cause__gtpc_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_reorderingRequired = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, ReorderingRequired_descr_.raw->forceomit);
  decoded_field_length = field_reorderingRequired().RAW_decode(ReorderingRequired_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_reorderingRequired = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_reorderingRequired=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_recovery = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, Recovery__gtpc_descr_.raw->forceomit);
  decoded_field_length = field_recovery().RAW_decode(Recovery__gtpc_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_recovery = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_recovery=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_teidDataI = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, TeidDataI_descr_.raw->forceomit);
  decoded_field_length = field_teidDataI().RAW_decode(TeidDataI_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_teidDataI = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_teidDataI=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_teidControlPlane = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, TeidControlPlane_descr_.raw->forceomit);
  decoded_field_length = field_teidControlPlane().RAW_decode(TeidControlPlane_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_teidControlPlane = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_teidControlPlane=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_nsapi = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, NSAPI__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_nsapi().RAW_decode(NSAPI__GTPC_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_nsapi = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_nsapi=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(6)) {
    field_chargingID = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, ChargingID_descr_.raw->forceomit);
  decoded_field_length = field_chargingID().RAW_decode(ChargingID_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_chargingID = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_chargingID=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(7)) {
    field_endUserAddress = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_7_force_omit(7, force_omit, EndUserAddress_descr_.raw->forceomit);
  decoded_field_length = field_endUserAddress().RAW_decode(EndUserAddress_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 1) {
  field_endUserAddress = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_endUserAddress=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(8)) {
    field_protConfigOptions = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_8_force_omit(8, force_omit, ProtConfigOptions_descr_.raw->forceomit);
  decoded_field_length = field_protConfigOptions().RAW_decode(ProtConfigOptions_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 1) {
  field_protConfigOptions = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_protConfigOptions=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(9)) {
    field_ggsn__addr__controlPlane = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_9_force_omit(9, force_omit, GSN__Address__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_ggsn__addr__controlPlane().RAW_decode(GSN__Address__GTPC_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_9_force_omit);
  if (decoded_field_length < 1) {
  field_ggsn__addr__controlPlane = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_ggsn__addr__controlPlane=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(10)) {
    field_ggsn__addr__traffic = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_10_force_omit(10, force_omit, GSN__Address__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_ggsn__addr__traffic().RAW_decode(GSN__Address__GTPC_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_10_force_omit);
  if (decoded_field_length < 1) {
  field_ggsn__addr__traffic = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_ggsn__addr__traffic=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(11)) {
    field_alt__ggsn__addr__controlPane = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_11_force_omit(11, force_omit, GSN__Address__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_alt__ggsn__addr__controlPane().RAW_decode(GSN__Address__GTPC_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_11_force_omit);
  if (decoded_field_length < 1) {
  field_alt__ggsn__addr__controlPane = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_alt__ggsn__addr__controlPane=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(12)) {
    field_alt__ggsn__addr__traffic = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_12_force_omit(12, force_omit, GSN__Address__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_alt__ggsn__addr__traffic().RAW_decode(GSN__Address__GTPC_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_12_force_omit);
  if (decoded_field_length < 1) {
  field_alt__ggsn__addr__traffic = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_alt__ggsn__addr__traffic=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(13)) {
    field_qualityOfServiceProfile = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_13_force_omit(13, force_omit, QualityOfServiceProfile_descr_.raw->forceomit);
  decoded_field_length = field_qualityOfServiceProfile().RAW_decode(QualityOfServiceProfile_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_13_force_omit);
  if (decoded_field_length < 1) {
  field_qualityOfServiceProfile = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_qualityOfServiceProfile=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(14)) {
    field_commonFlags = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_14_force_omit(14, force_omit, CommonFlags_descr_.raw->forceomit);
  decoded_field_length = field_commonFlags().RAW_decode(CommonFlags_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_14_force_omit);
  if (decoded_field_length < 1) {
  field_commonFlags = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_commonFlags=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(15)) {
    field_aPN__Restriction = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_15_force_omit(15, force_omit, APN__Restriction_descr_.raw->forceomit);
  decoded_field_length = field_aPN__Restriction().RAW_decode(APN__Restriction_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_15_force_omit);
  if (decoded_field_length < 1) {
  field_aPN__Restriction = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_aPN__Restriction=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(16)) {
    field_mS__InfoChangeReportingAction = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_16_force_omit(16, force_omit, MS__InfoChangeReportingAction_descr_.raw->forceomit);
  decoded_field_length = field_mS__InfoChangeReportingAction().RAW_decode(MS__InfoChangeReportingAction_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_16_force_omit);
  if (decoded_field_length < 1) {
  field_mS__InfoChangeReportingAction = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_mS__InfoChangeReportingAction=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(17)) {
    field_bearerControlMode = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_17_force_omit(17, force_omit, BearerControlMode_descr_.raw->forceomit);
  decoded_field_length = field_bearerControlMode().RAW_decode(BearerControlMode_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_17_force_omit);
  if (decoded_field_length < 1) {
  field_bearerControlMode = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_bearerControlMode=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(18)) {
    field_evolvedAllocationRetentionPriorityI = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_18_force_omit(18, force_omit, EvolvedAllocationRetentionPriorityI_descr_.raw->forceomit);
  decoded_field_length = field_evolvedAllocationRetentionPriorityI().RAW_decode(EvolvedAllocationRetentionPriorityI_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_18_force_omit);
  if (decoded_field_length < 1) {
  field_evolvedAllocationRetentionPriorityI = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_evolvedAllocationRetentionPriorityI=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(19)) {
    field_extendedCommonFlag = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_19_force_omit(19, force_omit, ExtendedCommonFlags_descr_.raw->forceomit);
  decoded_field_length = field_extendedCommonFlag().RAW_decode(ExtendedCommonFlags_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_19_force_omit);
  if (decoded_field_length < 1) {
  field_extendedCommonFlag = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_extendedCommonFlag=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(20)) {
    field_csg__information__reporting__action = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_20_force_omit(20, force_omit, CSGInfoReportingAction_descr_.raw->forceomit);
  decoded_field_length = field_csg__information__reporting__action().RAW_decode(CSGInfoReportingAction_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_20_force_omit);
  if (decoded_field_length < 1) {
  field_csg__information__reporting__action = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_csg__information__reporting__action=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(21)) {
    field_aPN__AMBR = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_21_force_omit(21, force_omit, APN__AMBR_descr_.raw->forceomit);
  decoded_field_length = field_aPN__AMBR().RAW_decode(APN__AMBR_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_21_force_omit);
  if (decoded_field_length < 1) {
  field_aPN__AMBR = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_aPN__AMBR=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(22)) {
    field_gGSN__BackOffTime = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_22_force_omit(22, force_omit, GGSN__BackOffTime_descr_.raw->forceomit);
  decoded_field_length = field_gGSN__BackOffTime().RAW_decode(GGSN__BackOffTime_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_22_force_omit);
  if (decoded_field_length < 1) {
  field_gGSN__BackOffTime = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_gGSN__BackOffTime=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(23)) {
    field_private__extension__gtpc = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_23_force_omit(23, force_omit, PrivateExtension__gtpc__List_descr_.raw->forceomit);
  decoded_field_length = field_private__extension__gtpc().RAW_decode(PrivateExtension__gtpc__List_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_23_force_omit);
  if (decoded_field_length < 1) {
  field_private__extension__gtpc = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_private__extension__gtpc=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int CreatePDPContextResponse::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 24;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(24);
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, Cause__gtpc_descr_.raw);
  if (field_reorderingRequired.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, ReorderingRequired_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  if (field_recovery.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, Recovery__gtpc_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  if (field_teidDataI.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, TeidDataI_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_teidControlPlane.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, TeidControlPlane_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  if (field_nsapi.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, NSAPI__GTPC_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_chargingID.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, ChargingID_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  if (field_endUserAddress.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, EndUserAddress_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  if (field_protConfigOptions.ispresent()) {
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, ProtConfigOptions_descr_.raw);
  }
  else myleaf.body.node.nodes[8] = NULL;
  if (field_ggsn__addr__controlPlane.ispresent()) {
  myleaf.body.node.nodes[9] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 9, GSN__Address__GTPC_descr_.raw);
  }
  else myleaf.body.node.nodes[9] = NULL;
  if (field_ggsn__addr__traffic.ispresent()) {
  myleaf.body.node.nodes[10] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 10, GSN__Address__GTPC_descr_.raw);
  }
  else myleaf.body.node.nodes[10] = NULL;
  if (field_alt__ggsn__addr__controlPane.ispresent()) {
  myleaf.body.node.nodes[11] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 11, GSN__Address__GTPC_descr_.raw);
  }
  else myleaf.body.node.nodes[11] = NULL;
  if (field_alt__ggsn__addr__traffic.ispresent()) {
  myleaf.body.node.nodes[12] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 12, GSN__Address__GTPC_descr_.raw);
  }
  else myleaf.body.node.nodes[12] = NULL;
  if (field_qualityOfServiceProfile.ispresent()) {
  myleaf.body.node.nodes[13] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 13, QualityOfServiceProfile_descr_.raw);
  }
  else myleaf.body.node.nodes[13] = NULL;
  if (field_commonFlags.ispresent()) {
  myleaf.body.node.nodes[14] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 14, CommonFlags_descr_.raw);
  }
  else myleaf.body.node.nodes[14] = NULL;
  if (field_aPN__Restriction.ispresent()) {
  myleaf.body.node.nodes[15] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 15, APN__Restriction_descr_.raw);
  }
  else myleaf.body.node.nodes[15] = NULL;
  if (field_mS__InfoChangeReportingAction.ispresent()) {
  myleaf.body.node.nodes[16] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 16, MS__InfoChangeReportingAction_descr_.raw);
  }
  else myleaf.body.node.nodes[16] = NULL;
  if (field_bearerControlMode.ispresent()) {
  myleaf.body.node.nodes[17] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 17, BearerControlMode_descr_.raw);
  }
  else myleaf.body.node.nodes[17] = NULL;
  if (field_evolvedAllocationRetentionPriorityI.ispresent()) {
  myleaf.body.node.nodes[18] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 18, EvolvedAllocationRetentionPriorityI_descr_.raw);
  }
  else myleaf.body.node.nodes[18] = NULL;
  if (field_extendedCommonFlag.ispresent()) {
  myleaf.body.node.nodes[19] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 19, ExtendedCommonFlags_descr_.raw);
  }
  else myleaf.body.node.nodes[19] = NULL;
  if (field_csg__information__reporting__action.ispresent()) {
  myleaf.body.node.nodes[20] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 20, CSGInfoReportingAction_descr_.raw);
  }
  else myleaf.body.node.nodes[20] = NULL;
  if (field_aPN__AMBR.ispresent()) {
  myleaf.body.node.nodes[21] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 21, APN__AMBR_descr_.raw);
  }
  else myleaf.body.node.nodes[21] = NULL;
  if (field_gGSN__BackOffTime.ispresent()) {
  myleaf.body.node.nodes[22] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 22, GGSN__BackOffTime_descr_.raw);
  }
  else myleaf.body.node.nodes[22] = NULL;
  if (field_private__extension__gtpc.ispresent()) {
  myleaf.body.node.nodes[23] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 23, PrivateExtension__gtpc__List_descr_.raw);
  }
  else myleaf.body.node.nodes[23] = NULL;
  encoded_length += field_cause.RAW_encode(Cause__gtpc_descr_, *myleaf.body.node.nodes[0]);
  if (field_reorderingRequired.ispresent()) {
  encoded_length += field_reorderingRequired().RAW_encode(ReorderingRequired_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_recovery.ispresent()) {
  encoded_length += field_recovery().RAW_encode(Recovery__gtpc_descr_, *myleaf.body.node.nodes[2]);
  }
  if (field_teidDataI.ispresent()) {
  encoded_length += field_teidDataI().RAW_encode(TeidDataI_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_teidControlPlane.ispresent()) {
  encoded_length += field_teidControlPlane().RAW_encode(TeidControlPlane_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_nsapi.ispresent()) {
  encoded_length += field_nsapi().RAW_encode(NSAPI__GTPC_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_chargingID.ispresent()) {
  encoded_length += field_chargingID().RAW_encode(ChargingID_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_endUserAddress.ispresent()) {
  encoded_length += field_endUserAddress().RAW_encode(EndUserAddress_descr_, *myleaf.body.node.nodes[7]);
  }
  if (field_protConfigOptions.ispresent()) {
  encoded_length += field_protConfigOptions().RAW_encode(ProtConfigOptions_descr_, *myleaf.body.node.nodes[8]);
  }
  if (field_ggsn__addr__controlPlane.ispresent()) {
  encoded_length += field_ggsn__addr__controlPlane().RAW_encode(GSN__Address__GTPC_descr_, *myleaf.body.node.nodes[9]);
  }
  if (field_ggsn__addr__traffic.ispresent()) {
  encoded_length += field_ggsn__addr__traffic().RAW_encode(GSN__Address__GTPC_descr_, *myleaf.body.node.nodes[10]);
  }
  if (field_alt__ggsn__addr__controlPane.ispresent()) {
  encoded_length += field_alt__ggsn__addr__controlPane().RAW_encode(GSN__Address__GTPC_descr_, *myleaf.body.node.nodes[11]);
  }
  if (field_alt__ggsn__addr__traffic.ispresent()) {
  encoded_length += field_alt__ggsn__addr__traffic().RAW_encode(GSN__Address__GTPC_descr_, *myleaf.body.node.nodes[12]);
  }
  if (field_qualityOfServiceProfile.ispresent()) {
  encoded_length += field_qualityOfServiceProfile().RAW_encode(QualityOfServiceProfile_descr_, *myleaf.body.node.nodes[13]);
  }
  if (field_commonFlags.ispresent()) {
  encoded_length += field_commonFlags().RAW_encode(CommonFlags_descr_, *myleaf.body.node.nodes[14]);
  }
  if (field_aPN__Restriction.ispresent()) {
  encoded_length += field_aPN__Restriction().RAW_encode(APN__Restriction_descr_, *myleaf.body.node.nodes[15]);
  }
  if (field_mS__InfoChangeReportingAction.ispresent()) {
  encoded_length += field_mS__InfoChangeReportingAction().RAW_encode(MS__InfoChangeReportingAction_descr_, *myleaf.body.node.nodes[16]);
  }
  if (field_bearerControlMode.ispresent()) {
  encoded_length += field_bearerControlMode().RAW_encode(BearerControlMode_descr_, *myleaf.body.node.nodes[17]);
  }
  if (field_evolvedAllocationRetentionPriorityI.ispresent()) {
  encoded_length += field_evolvedAllocationRetentionPriorityI().RAW_encode(EvolvedAllocationRetentionPriorityI_descr_, *myleaf.body.node.nodes[18]);
  }
  if (field_extendedCommonFlag.ispresent()) {
  encoded_length += field_extendedCommonFlag().RAW_encode(ExtendedCommonFlags_descr_, *myleaf.body.node.nodes[19]);
  }
  if (field_csg__information__reporting__action.ispresent()) {
  encoded_length += field_csg__information__reporting__action().RAW_encode(CSGInfoReportingAction_descr_, *myleaf.body.node.nodes[20]);
  }
  if (field_aPN__AMBR.ispresent()) {
  encoded_length += field_aPN__AMBR().RAW_encode(APN__AMBR_descr_, *myleaf.body.node.nodes[21]);
  }
  if (field_gGSN__BackOffTime.ispresent()) {
  encoded_length += field_gGSN__BackOffTime().RAW_encode(GGSN__BackOffTime_descr_, *myleaf.body.node.nodes[22]);
  }
  if (field_private__extension__gtpc.ispresent()) {
  encoded_length += field_private__extension__gtpc().RAW_encode(PrivateExtension__gtpc__List_descr_, *myleaf.body.node.nodes[23]);
  }
  return myleaf.length = encoded_length;
}

struct CreatePDPContextResponse_template::single_value_struct {
Cause__gtpc_template field_cause;
ReorderingRequired_template field_reorderingRequired;
Recovery__gtpc_template field_recovery;
TeidDataI_template field_teidDataI;
TeidControlPlane_template field_teidControlPlane;
NSAPI__GTPC_template field_nsapi;
ChargingID_template field_chargingID;
EndUserAddress_template field_endUserAddress;
ProtConfigOptions_template field_protConfigOptions;
GSN__Address__GTPC_template field_ggsn__addr__controlPlane;
GSN__Address__GTPC_template field_ggsn__addr__traffic;
GSN__Address__GTPC_template field_alt__ggsn__addr__controlPane;
GSN__Address__GTPC_template field_alt__ggsn__addr__traffic;
QualityOfServiceProfile_template field_qualityOfServiceProfile;
CommonFlags_template field_commonFlags;
APN__Restriction_template field_aPN__Restriction;
MS__InfoChangeReportingAction_template field_mS__InfoChangeReportingAction;
BearerControlMode_template field_bearerControlMode;
EvolvedAllocationRetentionPriorityI_template field_evolvedAllocationRetentionPriorityI;
ExtendedCommonFlags_template field_extendedCommonFlag;
CSGInfoReportingAction_template field_csg__information__reporting__action;
APN__AMBR_template field_aPN__AMBR;
GGSN__BackOffTime_template field_gGSN__BackOffTime;
PrivateExtension__gtpc__List_template field_private__extension__gtpc;
};

void CreatePDPContextResponse_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_cause = ANY_VALUE;
single_value->field_reorderingRequired = ANY_OR_OMIT;
single_value->field_recovery = ANY_OR_OMIT;
single_value->field_teidDataI = ANY_OR_OMIT;
single_value->field_teidControlPlane = ANY_OR_OMIT;
single_value->field_nsapi = ANY_OR_OMIT;
single_value->field_chargingID = ANY_OR_OMIT;
single_value->field_endUserAddress = ANY_OR_OMIT;
single_value->field_protConfigOptions = ANY_OR_OMIT;
single_value->field_ggsn__addr__controlPlane = ANY_OR_OMIT;
single_value->field_ggsn__addr__traffic = ANY_OR_OMIT;
single_value->field_alt__ggsn__addr__controlPane = ANY_OR_OMIT;
single_value->field_alt__ggsn__addr__traffic = ANY_OR_OMIT;
single_value->field_qualityOfServiceProfile = ANY_OR_OMIT;
single_value->field_commonFlags = ANY_OR_OMIT;
single_value->field_aPN__Restriction = ANY_OR_OMIT;
single_value->field_mS__InfoChangeReportingAction = ANY_OR_OMIT;
single_value->field_bearerControlMode = ANY_OR_OMIT;
single_value->field_evolvedAllocationRetentionPriorityI = ANY_OR_OMIT;
single_value->field_extendedCommonFlag = ANY_OR_OMIT;
single_value->field_csg__information__reporting__action = ANY_OR_OMIT;
single_value->field_aPN__AMBR = ANY_OR_OMIT;
single_value->field_gGSN__BackOffTime = ANY_OR_OMIT;
single_value->field_private__extension__gtpc = ANY_OR_OMIT;
}
}
}

void CreatePDPContextResponse_template::copy_value(const CreatePDPContextResponse& other_value)
{
single_value = new single_value_struct;
if (other_value.cause().is_bound()) {
  single_value->field_cause = other_value.cause();
} else {
  single_value->field_cause.clean_up();
}
if (other_value.reorderingRequired().is_bound()) {
  if (other_value.reorderingRequired().ispresent()) single_value->field_reorderingRequired = other_value.reorderingRequired()();
  else single_value->field_reorderingRequired = OMIT_VALUE;
} else {
  single_value->field_reorderingRequired.clean_up();
}
if (other_value.recovery().is_bound()) {
  if (other_value.recovery().ispresent()) single_value->field_recovery = other_value.recovery()();
  else single_value->field_recovery = OMIT_VALUE;
} else {
  single_value->field_recovery.clean_up();
}
if (other_value.teidDataI().is_bound()) {
  if (other_value.teidDataI().ispresent()) single_value->field_teidDataI = other_value.teidDataI()();
  else single_value->field_teidDataI = OMIT_VALUE;
} else {
  single_value->field_teidDataI.clean_up();
}
if (other_value.teidControlPlane().is_bound()) {
  if (other_value.teidControlPlane().ispresent()) single_value->field_teidControlPlane = other_value.teidControlPlane()();
  else single_value->field_teidControlPlane = OMIT_VALUE;
} else {
  single_value->field_teidControlPlane.clean_up();
}
if (other_value.nsapi().is_bound()) {
  if (other_value.nsapi().ispresent()) single_value->field_nsapi = other_value.nsapi()();
  else single_value->field_nsapi = OMIT_VALUE;
} else {
  single_value->field_nsapi.clean_up();
}
if (other_value.chargingID().is_bound()) {
  if (other_value.chargingID().ispresent()) single_value->field_chargingID = other_value.chargingID()();
  else single_value->field_chargingID = OMIT_VALUE;
} else {
  single_value->field_chargingID.clean_up();
}
if (other_value.endUserAddress().is_bound()) {
  if (other_value.endUserAddress().ispresent()) single_value->field_endUserAddress = other_value.endUserAddress()();
  else single_value->field_endUserAddress = OMIT_VALUE;
} else {
  single_value->field_endUserAddress.clean_up();
}
if (other_value.protConfigOptions().is_bound()) {
  if (other_value.protConfigOptions().ispresent()) single_value->field_protConfigOptions = other_value.protConfigOptions()();
  else single_value->field_protConfigOptions = OMIT_VALUE;
} else {
  single_value->field_protConfigOptions.clean_up();
}
if (other_value.ggsn__addr__controlPlane().is_bound()) {
  if (other_value.ggsn__addr__controlPlane().ispresent()) single_value->field_ggsn__addr__controlPlane = other_value.ggsn__addr__controlPlane()();
  else single_value->field_ggsn__addr__controlPlane = OMIT_VALUE;
} else {
  single_value->field_ggsn__addr__controlPlane.clean_up();
}
if (other_value.ggsn__addr__traffic().is_bound()) {
  if (other_value.ggsn__addr__traffic().ispresent()) single_value->field_ggsn__addr__traffic = other_value.ggsn__addr__traffic()();
  else single_value->field_ggsn__addr__traffic = OMIT_VALUE;
} else {
  single_value->field_ggsn__addr__traffic.clean_up();
}
if (other_value.alt__ggsn__addr__controlPane().is_bound()) {
  if (other_value.alt__ggsn__addr__controlPane().ispresent()) single_value->field_alt__ggsn__addr__controlPane = other_value.alt__ggsn__addr__controlPane()();
  else single_value->field_alt__ggsn__addr__controlPane = OMIT_VALUE;
} else {
  single_value->field_alt__ggsn__addr__controlPane.clean_up();
}
if (other_value.alt__ggsn__addr__traffic().is_bound()) {
  if (other_value.alt__ggsn__addr__traffic().ispresent()) single_value->field_alt__ggsn__addr__traffic = other_value.alt__ggsn__addr__traffic()();
  else single_value->field_alt__ggsn__addr__traffic = OMIT_VALUE;
} else {
  single_value->field_alt__ggsn__addr__traffic.clean_up();
}
if (other_value.qualityOfServiceProfile().is_bound()) {
  if (other_value.qualityOfServiceProfile().ispresent()) single_value->field_qualityOfServiceProfile = other_value.qualityOfServiceProfile()();
  else single_value->field_qualityOfServiceProfile = OMIT_VALUE;
} else {
  single_value->field_qualityOfServiceProfile.clean_up();
}
if (other_value.commonFlags().is_bound()) {
  if (other_value.commonFlags().ispresent()) single_value->field_commonFlags = other_value.commonFlags()();
  else single_value->field_commonFlags = OMIT_VALUE;
} else {
  single_value->field_commonFlags.clean_up();
}
if (other_value.aPN__Restriction().is_bound()) {
  if (other_value.aPN__Restriction().ispresent()) single_value->field_aPN__Restriction = other_value.aPN__Restriction()();
  else single_value->field_aPN__Restriction = OMIT_VALUE;
} else {
  single_value->field_aPN__Restriction.clean_up();
}
if (other_value.mS__InfoChangeReportingAction().is_bound()) {
  if (other_value.mS__InfoChangeReportingAction().ispresent()) single_value->field_mS__InfoChangeReportingAction = other_value.mS__InfoChangeReportingAction()();
  else single_value->field_mS__InfoChangeReportingAction = OMIT_VALUE;
} else {
  single_value->field_mS__InfoChangeReportingAction.clean_up();
}
if (other_value.bearerControlMode().is_bound()) {
  if (other_value.bearerControlMode().ispresent()) single_value->field_bearerControlMode = other_value.bearerControlMode()();
  else single_value->field_bearerControlMode = OMIT_VALUE;
} else {
  single_value->field_bearerControlMode.clean_up();
}
if (other_value.evolvedAllocationRetentionPriorityI().is_bound()) {
  if (other_value.evolvedAllocationRetentionPriorityI().ispresent()) single_value->field_evolvedAllocationRetentionPriorityI = other_value.evolvedAllocationRetentionPriorityI()();
  else single_value->field_evolvedAllocationRetentionPriorityI = OMIT_VALUE;
} else {
  single_value->field_evolvedAllocationRetentionPriorityI.clean_up();
}
if (other_value.extendedCommonFlag().is_bound()) {
  if (other_value.extendedCommonFlag().ispresent()) single_value->field_extendedCommonFlag = other_value.extendedCommonFlag()();
  else single_value->field_extendedCommonFlag = OMIT_VALUE;
} else {
  single_value->field_extendedCommonFlag.clean_up();
}
if (other_value.csg__information__reporting__action().is_bound()) {
  if (other_value.csg__information__reporting__action().ispresent()) single_value->field_csg__information__reporting__action = other_value.csg__information__reporting__action()();
  else single_value->field_csg__information__reporting__action = OMIT_VALUE;
} else {
  single_value->field_csg__information__reporting__action.clean_up();
}
if (other_value.aPN__AMBR().is_bound()) {
  if (other_value.aPN__AMBR().ispresent()) single_value->field_aPN__AMBR = other_value.aPN__AMBR()();
  else single_value->field_aPN__AMBR = OMIT_VALUE;
} else {
  single_value->field_aPN__AMBR.clean_up();
}
if (other_value.gGSN__BackOffTime().is_bound()) {
  if (other_value.gGSN__BackOffTime().ispresent()) single_value->field_gGSN__BackOffTime = other_value.gGSN__BackOffTime()();
  else single_value->field_gGSN__BackOffTime = OMIT_VALUE;
} else {
  single_value->field_gGSN__BackOffTime.clean_up();
}
if (other_value.private__extension__gtpc().is_bound()) {
  if (other_value.private__extension__gtpc().ispresent()) single_value->field_private__extension__gtpc = other_value.private__extension__gtpc()();
  else single_value->field_private__extension__gtpc = OMIT_VALUE;
} else {
  single_value->field_private__extension__gtpc.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void CreatePDPContextResponse_template::copy_template(const CreatePDPContextResponse_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.cause().get_selection()) {
single_value->field_cause = other_value.cause();
} else {
single_value->field_cause.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.reorderingRequired().get_selection()) {
single_value->field_reorderingRequired = other_value.reorderingRequired();
} else {
single_value->field_reorderingRequired.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.recovery().get_selection()) {
single_value->field_recovery = other_value.recovery();
} else {
single_value->field_recovery.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.teidDataI().get_selection()) {
single_value->field_teidDataI = other_value.teidDataI();
} else {
single_value->field_teidDataI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.teidControlPlane().get_selection()) {
single_value->field_teidControlPlane = other_value.teidControlPlane();
} else {
single_value->field_teidControlPlane.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsapi().get_selection()) {
single_value->field_nsapi = other_value.nsapi();
} else {
single_value->field_nsapi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.chargingID().get_selection()) {
single_value->field_chargingID = other_value.chargingID();
} else {
single_value->field_chargingID.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.endUserAddress().get_selection()) {
single_value->field_endUserAddress = other_value.endUserAddress();
} else {
single_value->field_endUserAddress.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.protConfigOptions().get_selection()) {
single_value->field_protConfigOptions = other_value.protConfigOptions();
} else {
single_value->field_protConfigOptions.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ggsn__addr__controlPlane().get_selection()) {
single_value->field_ggsn__addr__controlPlane = other_value.ggsn__addr__controlPlane();
} else {
single_value->field_ggsn__addr__controlPlane.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ggsn__addr__traffic().get_selection()) {
single_value->field_ggsn__addr__traffic = other_value.ggsn__addr__traffic();
} else {
single_value->field_ggsn__addr__traffic.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.alt__ggsn__addr__controlPane().get_selection()) {
single_value->field_alt__ggsn__addr__controlPane = other_value.alt__ggsn__addr__controlPane();
} else {
single_value->field_alt__ggsn__addr__controlPane.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.alt__ggsn__addr__traffic().get_selection()) {
single_value->field_alt__ggsn__addr__traffic = other_value.alt__ggsn__addr__traffic();
} else {
single_value->field_alt__ggsn__addr__traffic.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.qualityOfServiceProfile().get_selection()) {
single_value->field_qualityOfServiceProfile = other_value.qualityOfServiceProfile();
} else {
single_value->field_qualityOfServiceProfile.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.commonFlags().get_selection()) {
single_value->field_commonFlags = other_value.commonFlags();
} else {
single_value->field_commonFlags.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.aPN__Restriction().get_selection()) {
single_value->field_aPN__Restriction = other_value.aPN__Restriction();
} else {
single_value->field_aPN__Restriction.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mS__InfoChangeReportingAction().get_selection()) {
single_value->field_mS__InfoChangeReportingAction = other_value.mS__InfoChangeReportingAction();
} else {
single_value->field_mS__InfoChangeReportingAction.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.bearerControlMode().get_selection()) {
single_value->field_bearerControlMode = other_value.bearerControlMode();
} else {
single_value->field_bearerControlMode.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.evolvedAllocationRetentionPriorityI().get_selection()) {
single_value->field_evolvedAllocationRetentionPriorityI = other_value.evolvedAllocationRetentionPriorityI();
} else {
single_value->field_evolvedAllocationRetentionPriorityI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extendedCommonFlag().get_selection()) {
single_value->field_extendedCommonFlag = other_value.extendedCommonFlag();
} else {
single_value->field_extendedCommonFlag.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.csg__information__reporting__action().get_selection()) {
single_value->field_csg__information__reporting__action = other_value.csg__information__reporting__action();
} else {
single_value->field_csg__information__reporting__action.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.aPN__AMBR().get_selection()) {
single_value->field_aPN__AMBR = other_value.aPN__AMBR();
} else {
single_value->field_aPN__AMBR.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.gGSN__BackOffTime().get_selection()) {
single_value->field_gGSN__BackOffTime = other_value.gGSN__BackOffTime();
} else {
single_value->field_gGSN__BackOffTime.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.private__extension__gtpc().get_selection()) {
single_value->field_private__extension__gtpc = other_value.private__extension__gtpc();
} else {
single_value->field_private__extension__gtpc.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new CreatePDPContextResponse_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new CreatePDPContextResponse_template(*other_value.implication_.precondition);
implication_.implied_template = new CreatePDPContextResponse_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.CreatePDPContextResponse.");
break;
}
set_selection(other_value);
}

CreatePDPContextResponse_template::CreatePDPContextResponse_template()
{
}

CreatePDPContextResponse_template::CreatePDPContextResponse_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

CreatePDPContextResponse_template::CreatePDPContextResponse_template(const CreatePDPContextResponse& other_value)
{
copy_value(other_value);
}

CreatePDPContextResponse_template::CreatePDPContextResponse_template(const OPTIONAL<CreatePDPContextResponse>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CreatePDPContextResponse&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.CreatePDPContextResponse from an unbound optional field.");
}
}

CreatePDPContextResponse_template::CreatePDPContextResponse_template(CreatePDPContextResponse_template* p_precondition, CreatePDPContextResponse_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

CreatePDPContextResponse_template::CreatePDPContextResponse_template(Dynamic_Match_Interface<CreatePDPContextResponse>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<CreatePDPContextResponse>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

CreatePDPContextResponse_template::CreatePDPContextResponse_template(const CreatePDPContextResponse_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

CreatePDPContextResponse_template::~CreatePDPContextResponse_template()
{
clean_up();
}

CreatePDPContextResponse_template& CreatePDPContextResponse_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

CreatePDPContextResponse_template& CreatePDPContextResponse_template::operator=(const CreatePDPContextResponse& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

CreatePDPContextResponse_template& CreatePDPContextResponse_template::operator=(const OPTIONAL<CreatePDPContextResponse>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CreatePDPContextResponse&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.CreatePDPContextResponse.");
}
return *this;
}

CreatePDPContextResponse_template& CreatePDPContextResponse_template::operator=(const CreatePDPContextResponse_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean CreatePDPContextResponse_template::match(const CreatePDPContextResponse& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.cause().is_bound()) return FALSE;
if(!single_value->field_cause.match(other_value.cause(), legacy))return FALSE;
if(!other_value.reorderingRequired().is_bound()) return FALSE;
if((other_value.reorderingRequired().ispresent() ? !single_value->field_reorderingRequired.match((const ReorderingRequired&)other_value.reorderingRequired(), legacy) : !single_value->field_reorderingRequired.match_omit(legacy)))return FALSE;
if(!other_value.recovery().is_bound()) return FALSE;
if((other_value.recovery().ispresent() ? !single_value->field_recovery.match((const Recovery__gtpc&)other_value.recovery(), legacy) : !single_value->field_recovery.match_omit(legacy)))return FALSE;
if(!other_value.teidDataI().is_bound()) return FALSE;
if((other_value.teidDataI().ispresent() ? !single_value->field_teidDataI.match((const TeidDataI&)other_value.teidDataI(), legacy) : !single_value->field_teidDataI.match_omit(legacy)))return FALSE;
if(!other_value.teidControlPlane().is_bound()) return FALSE;
if((other_value.teidControlPlane().ispresent() ? !single_value->field_teidControlPlane.match((const TeidControlPlane&)other_value.teidControlPlane(), legacy) : !single_value->field_teidControlPlane.match_omit(legacy)))return FALSE;
if(!other_value.nsapi().is_bound()) return FALSE;
if((other_value.nsapi().ispresent() ? !single_value->field_nsapi.match((const NSAPI__GTPC&)other_value.nsapi(), legacy) : !single_value->field_nsapi.match_omit(legacy)))return FALSE;
if(!other_value.chargingID().is_bound()) return FALSE;
if((other_value.chargingID().ispresent() ? !single_value->field_chargingID.match((const ChargingID&)other_value.chargingID(), legacy) : !single_value->field_chargingID.match_omit(legacy)))return FALSE;
if(!other_value.endUserAddress().is_bound()) return FALSE;
if((other_value.endUserAddress().ispresent() ? !single_value->field_endUserAddress.match((const EndUserAddress&)other_value.endUserAddress(), legacy) : !single_value->field_endUserAddress.match_omit(legacy)))return FALSE;
if(!other_value.protConfigOptions().is_bound()) return FALSE;
if((other_value.protConfigOptions().ispresent() ? !single_value->field_protConfigOptions.match((const ProtConfigOptions&)other_value.protConfigOptions(), legacy) : !single_value->field_protConfigOptions.match_omit(legacy)))return FALSE;
if(!other_value.ggsn__addr__controlPlane().is_bound()) return FALSE;
if((other_value.ggsn__addr__controlPlane().ispresent() ? !single_value->field_ggsn__addr__controlPlane.match((const GSN__Address__GTPC&)other_value.ggsn__addr__controlPlane(), legacy) : !single_value->field_ggsn__addr__controlPlane.match_omit(legacy)))return FALSE;
if(!other_value.ggsn__addr__traffic().is_bound()) return FALSE;
if((other_value.ggsn__addr__traffic().ispresent() ? !single_value->field_ggsn__addr__traffic.match((const GSN__Address__GTPC&)other_value.ggsn__addr__traffic(), legacy) : !single_value->field_ggsn__addr__traffic.match_omit(legacy)))return FALSE;
if(!other_value.alt__ggsn__addr__controlPane().is_bound()) return FALSE;
if((other_value.alt__ggsn__addr__controlPane().ispresent() ? !single_value->field_alt__ggsn__addr__controlPane.match((const GSN__Address__GTPC&)other_value.alt__ggsn__addr__controlPane(), legacy) : !single_value->field_alt__ggsn__addr__controlPane.match_omit(legacy)))return FALSE;
if(!other_value.alt__ggsn__addr__traffic().is_bound()) return FALSE;
if((other_value.alt__ggsn__addr__traffic().ispresent() ? !single_value->field_alt__ggsn__addr__traffic.match((const GSN__Address__GTPC&)other_value.alt__ggsn__addr__traffic(), legacy) : !single_value->field_alt__ggsn__addr__traffic.match_omit(legacy)))return FALSE;
if(!other_value.qualityOfServiceProfile().is_bound()) return FALSE;
if((other_value.qualityOfServiceProfile().ispresent() ? !single_value->field_qualityOfServiceProfile.match((const QualityOfServiceProfile&)other_value.qualityOfServiceProfile(), legacy) : !single_value->field_qualityOfServiceProfile.match_omit(legacy)))return FALSE;
if(!other_value.commonFlags().is_bound()) return FALSE;
if((other_value.commonFlags().ispresent() ? !single_value->field_commonFlags.match((const CommonFlags&)other_value.commonFlags(), legacy) : !single_value->field_commonFlags.match_omit(legacy)))return FALSE;
if(!other_value.aPN__Restriction().is_bound()) return FALSE;
if((other_value.aPN__Restriction().ispresent() ? !single_value->field_aPN__Restriction.match((const APN__Restriction&)other_value.aPN__Restriction(), legacy) : !single_value->field_aPN__Restriction.match_omit(legacy)))return FALSE;
if(!other_value.mS__InfoChangeReportingAction().is_bound()) return FALSE;
if((other_value.mS__InfoChangeReportingAction().ispresent() ? !single_value->field_mS__InfoChangeReportingAction.match((const MS__InfoChangeReportingAction&)other_value.mS__InfoChangeReportingAction(), legacy) : !single_value->field_mS__InfoChangeReportingAction.match_omit(legacy)))return FALSE;
if(!other_value.bearerControlMode().is_bound()) return FALSE;
if((other_value.bearerControlMode().ispresent() ? !single_value->field_bearerControlMode.match((const BearerControlMode&)other_value.bearerControlMode(), legacy) : !single_value->field_bearerControlMode.match_omit(legacy)))return FALSE;
if(!other_value.evolvedAllocationRetentionPriorityI().is_bound()) return FALSE;
if((other_value.evolvedAllocationRetentionPriorityI().ispresent() ? !single_value->field_evolvedAllocationRetentionPriorityI.match((const EvolvedAllocationRetentionPriorityI&)other_value.evolvedAllocationRetentionPriorityI(), legacy) : !single_value->field_evolvedAllocationRetentionPriorityI.match_omit(legacy)))return FALSE;
if(!other_value.extendedCommonFlag().is_bound()) return FALSE;
if((other_value.extendedCommonFlag().ispresent() ? !single_value->field_extendedCommonFlag.match((const ExtendedCommonFlags&)other_value.extendedCommonFlag(), legacy) : !single_value->field_extendedCommonFlag.match_omit(legacy)))return FALSE;
if(!other_value.csg__information__reporting__action().is_bound()) return FALSE;
if((other_value.csg__information__reporting__action().ispresent() ? !single_value->field_csg__information__reporting__action.match((const CSGInfoReportingAction&)other_value.csg__information__reporting__action(), legacy) : !single_value->field_csg__information__reporting__action.match_omit(legacy)))return FALSE;
if(!other_value.aPN__AMBR().is_bound()) return FALSE;
if((other_value.aPN__AMBR().ispresent() ? !single_value->field_aPN__AMBR.match((const APN__AMBR&)other_value.aPN__AMBR(), legacy) : !single_value->field_aPN__AMBR.match_omit(legacy)))return FALSE;
if(!other_value.gGSN__BackOffTime().is_bound()) return FALSE;
if((other_value.gGSN__BackOffTime().ispresent() ? !single_value->field_gGSN__BackOffTime.match((const GGSN__BackOffTime&)other_value.gGSN__BackOffTime(), legacy) : !single_value->field_gGSN__BackOffTime.match_omit(legacy)))return FALSE;
if(!other_value.private__extension__gtpc().is_bound()) return FALSE;
if((other_value.private__extension__gtpc().ispresent() ? !single_value->field_private__extension__gtpc.match((const PrivateExtension__gtpc__List&)other_value.private__extension__gtpc(), legacy) : !single_value->field_private__extension__gtpc.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.CreatePDPContextResponse.");
}
return FALSE;
}

boolean CreatePDPContextResponse_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_cause.is_bound()
 || (single_value->field_reorderingRequired.is_omit() || single_value->field_reorderingRequired.is_bound())
 || (single_value->field_recovery.is_omit() || single_value->field_recovery.is_bound())
 || (single_value->field_teidDataI.is_omit() || single_value->field_teidDataI.is_bound())
 || (single_value->field_teidControlPlane.is_omit() || single_value->field_teidControlPlane.is_bound())
 || (single_value->field_nsapi.is_omit() || single_value->field_nsapi.is_bound())
 || (single_value->field_chargingID.is_omit() || single_value->field_chargingID.is_bound())
 || (single_value->field_endUserAddress.is_omit() || single_value->field_endUserAddress.is_bound())
 || (single_value->field_protConfigOptions.is_omit() || single_value->field_protConfigOptions.is_bound())
 || (single_value->field_ggsn__addr__controlPlane.is_omit() || single_value->field_ggsn__addr__controlPlane.is_bound())
 || (single_value->field_ggsn__addr__traffic.is_omit() || single_value->field_ggsn__addr__traffic.is_bound())
 || (single_value->field_alt__ggsn__addr__controlPane.is_omit() || single_value->field_alt__ggsn__addr__controlPane.is_bound())
 || (single_value->field_alt__ggsn__addr__traffic.is_omit() || single_value->field_alt__ggsn__addr__traffic.is_bound())
 || (single_value->field_qualityOfServiceProfile.is_omit() || single_value->field_qualityOfServiceProfile.is_bound())
 || (single_value->field_commonFlags.is_omit() || single_value->field_commonFlags.is_bound())
 || (single_value->field_aPN__Restriction.is_omit() || single_value->field_aPN__Restriction.is_bound())
 || (single_value->field_mS__InfoChangeReportingAction.is_omit() || single_value->field_mS__InfoChangeReportingAction.is_bound())
 || (single_value->field_bearerControlMode.is_omit() || single_value->field_bearerControlMode.is_bound())
 || (single_value->field_evolvedAllocationRetentionPriorityI.is_omit() || single_value->field_evolvedAllocationRetentionPriorityI.is_bound())
 || (single_value->field_extendedCommonFlag.is_omit() || single_value->field_extendedCommonFlag.is_bound())
 || (single_value->field_csg__information__reporting__action.is_omit() || single_value->field_csg__information__reporting__action.is_bound())
 || (single_value->field_aPN__AMBR.is_omit() || single_value->field_aPN__AMBR.is_bound())
 || (single_value->field_gGSN__BackOffTime.is_omit() || single_value->field_gGSN__BackOffTime.is_bound())
 || (single_value->field_private__extension__gtpc.is_omit() || single_value->field_private__extension__gtpc.is_bound());
}

boolean CreatePDPContextResponse_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_cause.is_value()
 && (single_value->field_reorderingRequired.is_omit() || single_value->field_reorderingRequired.is_value())
 && (single_value->field_recovery.is_omit() || single_value->field_recovery.is_value())
 && (single_value->field_teidDataI.is_omit() || single_value->field_teidDataI.is_value())
 && (single_value->field_teidControlPlane.is_omit() || single_value->field_teidControlPlane.is_value())
 && (single_value->field_nsapi.is_omit() || single_value->field_nsapi.is_value())
 && (single_value->field_chargingID.is_omit() || single_value->field_chargingID.is_value())
 && (single_value->field_endUserAddress.is_omit() || single_value->field_endUserAddress.is_value())
 && (single_value->field_protConfigOptions.is_omit() || single_value->field_protConfigOptions.is_value())
 && (single_value->field_ggsn__addr__controlPlane.is_omit() || single_value->field_ggsn__addr__controlPlane.is_value())
 && (single_value->field_ggsn__addr__traffic.is_omit() || single_value->field_ggsn__addr__traffic.is_value())
 && (single_value->field_alt__ggsn__addr__controlPane.is_omit() || single_value->field_alt__ggsn__addr__controlPane.is_value())
 && (single_value->field_alt__ggsn__addr__traffic.is_omit() || single_value->field_alt__ggsn__addr__traffic.is_value())
 && (single_value->field_qualityOfServiceProfile.is_omit() || single_value->field_qualityOfServiceProfile.is_value())
 && (single_value->field_commonFlags.is_omit() || single_value->field_commonFlags.is_value())
 && (single_value->field_aPN__Restriction.is_omit() || single_value->field_aPN__Restriction.is_value())
 && (single_value->field_mS__InfoChangeReportingAction.is_omit() || single_value->field_mS__InfoChangeReportingAction.is_value())
 && (single_value->field_bearerControlMode.is_omit() || single_value->field_bearerControlMode.is_value())
 && (single_value->field_evolvedAllocationRetentionPriorityI.is_omit() || single_value->field_evolvedAllocationRetentionPriorityI.is_value())
 && (single_value->field_extendedCommonFlag.is_omit() || single_value->field_extendedCommonFlag.is_value())
 && (single_value->field_csg__information__reporting__action.is_omit() || single_value->field_csg__information__reporting__action.is_value())
 && (single_value->field_aPN__AMBR.is_omit() || single_value->field_aPN__AMBR.is_value())
 && (single_value->field_gGSN__BackOffTime.is_omit() || single_value->field_gGSN__BackOffTime.is_value())
 && (single_value->field_private__extension__gtpc.is_omit() || single_value->field_private__extension__gtpc.is_value());
}

void CreatePDPContextResponse_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

CreatePDPContextResponse CreatePDPContextResponse_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
CreatePDPContextResponse ret_val;
if (single_value->field_cause.is_bound()) {
ret_val.cause() = single_value->field_cause.valueof();
}
if (single_value->field_reorderingRequired.is_omit()) ret_val.reorderingRequired() = OMIT_VALUE;
else if (single_value->field_reorderingRequired.is_bound()) {
ret_val.reorderingRequired() = single_value->field_reorderingRequired.valueof();
}
if (single_value->field_recovery.is_omit()) ret_val.recovery() = OMIT_VALUE;
else if (single_value->field_recovery.is_bound()) {
ret_val.recovery() = single_value->field_recovery.valueof();
}
if (single_value->field_teidDataI.is_omit()) ret_val.teidDataI() = OMIT_VALUE;
else if (single_value->field_teidDataI.is_bound()) {
ret_val.teidDataI() = single_value->field_teidDataI.valueof();
}
if (single_value->field_teidControlPlane.is_omit()) ret_val.teidControlPlane() = OMIT_VALUE;
else if (single_value->field_teidControlPlane.is_bound()) {
ret_val.teidControlPlane() = single_value->field_teidControlPlane.valueof();
}
if (single_value->field_nsapi.is_omit()) ret_val.nsapi() = OMIT_VALUE;
else if (single_value->field_nsapi.is_bound()) {
ret_val.nsapi() = single_value->field_nsapi.valueof();
}
if (single_value->field_chargingID.is_omit()) ret_val.chargingID() = OMIT_VALUE;
else if (single_value->field_chargingID.is_bound()) {
ret_val.chargingID() = single_value->field_chargingID.valueof();
}
if (single_value->field_endUserAddress.is_omit()) ret_val.endUserAddress() = OMIT_VALUE;
else if (single_value->field_endUserAddress.is_bound()) {
ret_val.endUserAddress() = single_value->field_endUserAddress.valueof();
}
if (single_value->field_protConfigOptions.is_omit()) ret_val.protConfigOptions() = OMIT_VALUE;
else if (single_value->field_protConfigOptions.is_bound()) {
ret_val.protConfigOptions() = single_value->field_protConfigOptions.valueof();
}
if (single_value->field_ggsn__addr__controlPlane.is_omit()) ret_val.ggsn__addr__controlPlane() = OMIT_VALUE;
else if (single_value->field_ggsn__addr__controlPlane.is_bound()) {
ret_val.ggsn__addr__controlPlane() = single_value->field_ggsn__addr__controlPlane.valueof();
}
if (single_value->field_ggsn__addr__traffic.is_omit()) ret_val.ggsn__addr__traffic() = OMIT_VALUE;
else if (single_value->field_ggsn__addr__traffic.is_bound()) {
ret_val.ggsn__addr__traffic() = single_value->field_ggsn__addr__traffic.valueof();
}
if (single_value->field_alt__ggsn__addr__controlPane.is_omit()) ret_val.alt__ggsn__addr__controlPane() = OMIT_VALUE;
else if (single_value->field_alt__ggsn__addr__controlPane.is_bound()) {
ret_val.alt__ggsn__addr__controlPane() = single_value->field_alt__ggsn__addr__controlPane.valueof();
}
if (single_value->field_alt__ggsn__addr__traffic.is_omit()) ret_val.alt__ggsn__addr__traffic() = OMIT_VALUE;
else if (single_value->field_alt__ggsn__addr__traffic.is_bound()) {
ret_val.alt__ggsn__addr__traffic() = single_value->field_alt__ggsn__addr__traffic.valueof();
}
if (single_value->field_qualityOfServiceProfile.is_omit()) ret_val.qualityOfServiceProfile() = OMIT_VALUE;
else if (single_value->field_qualityOfServiceProfile.is_bound()) {
ret_val.qualityOfServiceProfile() = single_value->field_qualityOfServiceProfile.valueof();
}
if (single_value->field_commonFlags.is_omit()) ret_val.commonFlags() = OMIT_VALUE;
else if (single_value->field_commonFlags.is_bound()) {
ret_val.commonFlags() = single_value->field_commonFlags.valueof();
}
if (single_value->field_aPN__Restriction.is_omit()) ret_val.aPN__Restriction() = OMIT_VALUE;
else if (single_value->field_aPN__Restriction.is_bound()) {
ret_val.aPN__Restriction() = single_value->field_aPN__Restriction.valueof();
}
if (single_value->field_mS__InfoChangeReportingAction.is_omit()) ret_val.mS__InfoChangeReportingAction() = OMIT_VALUE;
else if (single_value->field_mS__InfoChangeReportingAction.is_bound()) {
ret_val.mS__InfoChangeReportingAction() = single_value->field_mS__InfoChangeReportingAction.valueof();
}
if (single_value->field_bearerControlMode.is_omit()) ret_val.bearerControlMode() = OMIT_VALUE;
else if (single_value->field_bearerControlMode.is_bound()) {
ret_val.bearerControlMode() = single_value->field_bearerControlMode.valueof();
}
if (single_value->field_evolvedAllocationRetentionPriorityI.is_omit()) ret_val.evolvedAllocationRetentionPriorityI() = OMIT_VALUE;
else if (single_value->field_evolvedAllocationRetentionPriorityI.is_bound()) {
ret_val.evolvedAllocationRetentionPriorityI() = single_value->field_evolvedAllocationRetentionPriorityI.valueof();
}
if (single_value->field_extendedCommonFlag.is_omit()) ret_val.extendedCommonFlag() = OMIT_VALUE;
else if (single_value->field_extendedCommonFlag.is_bound()) {
ret_val.extendedCommonFlag() = single_value->field_extendedCommonFlag.valueof();
}
if (single_value->field_csg__information__reporting__action.is_omit()) ret_val.csg__information__reporting__action() = OMIT_VALUE;
else if (single_value->field_csg__information__reporting__action.is_bound()) {
ret_val.csg__information__reporting__action() = single_value->field_csg__information__reporting__action.valueof();
}
if (single_value->field_aPN__AMBR.is_omit()) ret_val.aPN__AMBR() = OMIT_VALUE;
else if (single_value->field_aPN__AMBR.is_bound()) {
ret_val.aPN__AMBR() = single_value->field_aPN__AMBR.valueof();
}
if (single_value->field_gGSN__BackOffTime.is_omit()) ret_val.gGSN__BackOffTime() = OMIT_VALUE;
else if (single_value->field_gGSN__BackOffTime.is_bound()) {
ret_val.gGSN__BackOffTime() = single_value->field_gGSN__BackOffTime.valueof();
}
if (single_value->field_private__extension__gtpc.is_omit()) ret_val.private__extension__gtpc() = OMIT_VALUE;
else if (single_value->field_private__extension__gtpc.is_bound()) {
ret_val.private__extension__gtpc() = single_value->field_private__extension__gtpc.valueof();
}
return ret_val;
}

void CreatePDPContextResponse_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.CreatePDPContextResponse.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new CreatePDPContextResponse_template[list_length];
}

CreatePDPContextResponse_template& CreatePDPContextResponse_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.CreatePDPContextResponse.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.CreatePDPContextResponse.");
return value_list.list_value[list_index];
}

Cause__gtpc_template& CreatePDPContextResponse_template::cause()
{
set_specific();
return single_value->field_cause;
}

const Cause__gtpc_template& CreatePDPContextResponse_template::cause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cause of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_cause;
}

ReorderingRequired_template& CreatePDPContextResponse_template::reorderingRequired()
{
set_specific();
return single_value->field_reorderingRequired;
}

const ReorderingRequired_template& CreatePDPContextResponse_template::reorderingRequired() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field reorderingRequired of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_reorderingRequired;
}

Recovery__gtpc_template& CreatePDPContextResponse_template::recovery()
{
set_specific();
return single_value->field_recovery;
}

const Recovery__gtpc_template& CreatePDPContextResponse_template::recovery() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field recovery of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_recovery;
}

TeidDataI_template& CreatePDPContextResponse_template::teidDataI()
{
set_specific();
return single_value->field_teidDataI;
}

const TeidDataI_template& CreatePDPContextResponse_template::teidDataI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field teidDataI of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_teidDataI;
}

TeidControlPlane_template& CreatePDPContextResponse_template::teidControlPlane()
{
set_specific();
return single_value->field_teidControlPlane;
}

const TeidControlPlane_template& CreatePDPContextResponse_template::teidControlPlane() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field teidControlPlane of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_teidControlPlane;
}

NSAPI__GTPC_template& CreatePDPContextResponse_template::nsapi()
{
set_specific();
return single_value->field_nsapi;
}

const NSAPI__GTPC_template& CreatePDPContextResponse_template::nsapi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsapi of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_nsapi;
}

ChargingID_template& CreatePDPContextResponse_template::chargingID()
{
set_specific();
return single_value->field_chargingID;
}

const ChargingID_template& CreatePDPContextResponse_template::chargingID() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field chargingID of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_chargingID;
}

EndUserAddress_template& CreatePDPContextResponse_template::endUserAddress()
{
set_specific();
return single_value->field_endUserAddress;
}

const EndUserAddress_template& CreatePDPContextResponse_template::endUserAddress() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field endUserAddress of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_endUserAddress;
}

ProtConfigOptions_template& CreatePDPContextResponse_template::protConfigOptions()
{
set_specific();
return single_value->field_protConfigOptions;
}

const ProtConfigOptions_template& CreatePDPContextResponse_template::protConfigOptions() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field protConfigOptions of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_protConfigOptions;
}

GSN__Address__GTPC_template& CreatePDPContextResponse_template::ggsn__addr__controlPlane()
{
set_specific();
return single_value->field_ggsn__addr__controlPlane;
}

const GSN__Address__GTPC_template& CreatePDPContextResponse_template::ggsn__addr__controlPlane() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ggsn_addr_controlPlane of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_ggsn__addr__controlPlane;
}

GSN__Address__GTPC_template& CreatePDPContextResponse_template::ggsn__addr__traffic()
{
set_specific();
return single_value->field_ggsn__addr__traffic;
}

const GSN__Address__GTPC_template& CreatePDPContextResponse_template::ggsn__addr__traffic() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ggsn_addr_traffic of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_ggsn__addr__traffic;
}

GSN__Address__GTPC_template& CreatePDPContextResponse_template::alt__ggsn__addr__controlPane()
{
set_specific();
return single_value->field_alt__ggsn__addr__controlPane;
}

const GSN__Address__GTPC_template& CreatePDPContextResponse_template::alt__ggsn__addr__controlPane() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field alt_ggsn_addr_controlPane of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_alt__ggsn__addr__controlPane;
}

GSN__Address__GTPC_template& CreatePDPContextResponse_template::alt__ggsn__addr__traffic()
{
set_specific();
return single_value->field_alt__ggsn__addr__traffic;
}

const GSN__Address__GTPC_template& CreatePDPContextResponse_template::alt__ggsn__addr__traffic() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field alt_ggsn_addr_traffic of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_alt__ggsn__addr__traffic;
}

QualityOfServiceProfile_template& CreatePDPContextResponse_template::qualityOfServiceProfile()
{
set_specific();
return single_value->field_qualityOfServiceProfile;
}

const QualityOfServiceProfile_template& CreatePDPContextResponse_template::qualityOfServiceProfile() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field qualityOfServiceProfile of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_qualityOfServiceProfile;
}

CommonFlags_template& CreatePDPContextResponse_template::commonFlags()
{
set_specific();
return single_value->field_commonFlags;
}

const CommonFlags_template& CreatePDPContextResponse_template::commonFlags() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field commonFlags of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_commonFlags;
}

APN__Restriction_template& CreatePDPContextResponse_template::aPN__Restriction()
{
set_specific();
return single_value->field_aPN__Restriction;
}

const APN__Restriction_template& CreatePDPContextResponse_template::aPN__Restriction() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field aPN_Restriction of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_aPN__Restriction;
}

MS__InfoChangeReportingAction_template& CreatePDPContextResponse_template::mS__InfoChangeReportingAction()
{
set_specific();
return single_value->field_mS__InfoChangeReportingAction;
}

const MS__InfoChangeReportingAction_template& CreatePDPContextResponse_template::mS__InfoChangeReportingAction() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mS_InfoChangeReportingAction of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_mS__InfoChangeReportingAction;
}

BearerControlMode_template& CreatePDPContextResponse_template::bearerControlMode()
{
set_specific();
return single_value->field_bearerControlMode;
}

const BearerControlMode_template& CreatePDPContextResponse_template::bearerControlMode() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bearerControlMode of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_bearerControlMode;
}

EvolvedAllocationRetentionPriorityI_template& CreatePDPContextResponse_template::evolvedAllocationRetentionPriorityI()
{
set_specific();
return single_value->field_evolvedAllocationRetentionPriorityI;
}

const EvolvedAllocationRetentionPriorityI_template& CreatePDPContextResponse_template::evolvedAllocationRetentionPriorityI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field evolvedAllocationRetentionPriorityI of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_evolvedAllocationRetentionPriorityI;
}

ExtendedCommonFlags_template& CreatePDPContextResponse_template::extendedCommonFlag()
{
set_specific();
return single_value->field_extendedCommonFlag;
}

const ExtendedCommonFlags_template& CreatePDPContextResponse_template::extendedCommonFlag() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extendedCommonFlag of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_extendedCommonFlag;
}

CSGInfoReportingAction_template& CreatePDPContextResponse_template::csg__information__reporting__action()
{
set_specific();
return single_value->field_csg__information__reporting__action;
}

const CSGInfoReportingAction_template& CreatePDPContextResponse_template::csg__information__reporting__action() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field csg_information_reporting_action of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_csg__information__reporting__action;
}

APN__AMBR_template& CreatePDPContextResponse_template::aPN__AMBR()
{
set_specific();
return single_value->field_aPN__AMBR;
}

const APN__AMBR_template& CreatePDPContextResponse_template::aPN__AMBR() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field aPN_AMBR of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_aPN__AMBR;
}

GGSN__BackOffTime_template& CreatePDPContextResponse_template::gGSN__BackOffTime()
{
set_specific();
return single_value->field_gGSN__BackOffTime;
}

const GGSN__BackOffTime_template& CreatePDPContextResponse_template::gGSN__BackOffTime() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field gGSN_BackOffTime of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_gGSN__BackOffTime;
}

PrivateExtension__gtpc__List_template& CreatePDPContextResponse_template::private__extension__gtpc()
{
set_specific();
return single_value->field_private__extension__gtpc;
}

const PrivateExtension__gtpc__List_template& CreatePDPContextResponse_template::private__extension__gtpc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field private_extension_gtpc of a non-specific template of type @GTPC_Types.CreatePDPContextResponse.");
return single_value->field_private__extension__gtpc;
}

int CreatePDPContextResponse_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CreatePDPContextResponse which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_reorderingRequired.is_present()) ret_val++;
      if (single_value->field_recovery.is_present()) ret_val++;
      if (single_value->field_teidDataI.is_present()) ret_val++;
      if (single_value->field_teidControlPlane.is_present()) ret_val++;
      if (single_value->field_nsapi.is_present()) ret_val++;
      if (single_value->field_chargingID.is_present()) ret_val++;
      if (single_value->field_endUserAddress.is_present()) ret_val++;
      if (single_value->field_protConfigOptions.is_present()) ret_val++;
      if (single_value->field_ggsn__addr__controlPlane.is_present()) ret_val++;
      if (single_value->field_ggsn__addr__traffic.is_present()) ret_val++;
      if (single_value->field_alt__ggsn__addr__controlPane.is_present()) ret_val++;
      if (single_value->field_alt__ggsn__addr__traffic.is_present()) ret_val++;
      if (single_value->field_qualityOfServiceProfile.is_present()) ret_val++;
      if (single_value->field_commonFlags.is_present()) ret_val++;
      if (single_value->field_aPN__Restriction.is_present()) ret_val++;
      if (single_value->field_mS__InfoChangeReportingAction.is_present()) ret_val++;
      if (single_value->field_bearerControlMode.is_present()) ret_val++;
      if (single_value->field_evolvedAllocationRetentionPriorityI.is_present()) ret_val++;
      if (single_value->field_extendedCommonFlag.is_present()) ret_val++;
      if (single_value->field_csg__information__reporting__action.is_present()) ret_val++;
      if (single_value->field_aPN__AMBR.is_present()) ret_val++;
      if (single_value->field_gGSN__BackOffTime.is_present()) ret_val++;
      if (single_value->field_private__extension__gtpc.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.CreatePDPContextResponse containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CreatePDPContextResponse containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CreatePDPContextResponse containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CreatePDPContextResponse containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CreatePDPContextResponse containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CreatePDPContextResponse containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CreatePDPContextResponse containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.CreatePDPContextResponse containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.CreatePDPContextResponse.");
  }
  return 0;
}

void CreatePDPContextResponse_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ cause := ");
single_value->field_cause.log();
TTCN_Logger::log_event_str(", reorderingRequired := ");
single_value->field_reorderingRequired.log();
TTCN_Logger::log_event_str(", recovery := ");
single_value->field_recovery.log();
TTCN_Logger::log_event_str(", teidDataI := ");
single_value->field_teidDataI.log();
TTCN_Logger::log_event_str(", teidControlPlane := ");
single_value->field_teidControlPlane.log();
TTCN_Logger::log_event_str(", nsapi := ");
single_value->field_nsapi.log();
TTCN_Logger::log_event_str(", chargingID := ");
single_value->field_chargingID.log();
TTCN_Logger::log_event_str(", endUserAddress := ");
single_value->field_endUserAddress.log();
TTCN_Logger::log_event_str(", protConfigOptions := ");
single_value->field_protConfigOptions.log();
TTCN_Logger::log_event_str(", ggsn_addr_controlPlane := ");
single_value->field_ggsn__addr__controlPlane.log();
TTCN_Logger::log_event_str(", ggsn_addr_traffic := ");
single_value->field_ggsn__addr__traffic.log();
TTCN_Logger::log_event_str(", alt_ggsn_addr_controlPane := ");
single_value->field_alt__ggsn__addr__controlPane.log();
TTCN_Logger::log_event_str(", alt_ggsn_addr_traffic := ");
single_value->field_alt__ggsn__addr__traffic.log();
TTCN_Logger::log_event_str(", qualityOfServiceProfile := ");
single_value->field_qualityOfServiceProfile.log();
TTCN_Logger::log_event_str(", commonFlags := ");
single_value->field_commonFlags.log();
TTCN_Logger::log_event_str(", aPN_Restriction := ");
single_value->field_aPN__Restriction.log();
TTCN_Logger::log_event_str(", mS_InfoChangeReportingAction := ");
single_value->field_mS__InfoChangeReportingAction.log();
TTCN_Logger::log_event_str(", bearerControlMode := ");
single_value->field_bearerControlMode.log();
TTCN_Logger::log_event_str(", evolvedAllocationRetentionPriorityI := ");
single_value->field_evolvedAllocationRetentionPriorityI.log();
TTCN_Logger::log_event_str(", extendedCommonFlag := ");
single_value->field_extendedCommonFlag.log();
TTCN_Logger::log_event_str(", csg_information_reporting_action := ");
single_value->field_csg__information__reporting__action.log();
TTCN_Logger::log_event_str(", aPN_AMBR := ");
single_value->field_aPN__AMBR.log();
TTCN_Logger::log_event_str(", gGSN_BackOffTime := ");
single_value->field_gGSN__BackOffTime.log();
TTCN_Logger::log_event_str(", private_extension_gtpc := ");
single_value->field_private__extension__gtpc.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void CreatePDPContextResponse_template::log_match(const CreatePDPContextResponse& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_cause.match(match_value.cause(), legacy)){
TTCN_Logger::log_logmatch_info(".cause");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.reorderingRequired().ispresent()){
if(!single_value->field_reorderingRequired.match(match_value.reorderingRequired(), legacy)){
TTCN_Logger::log_logmatch_info(".reorderingRequired");
single_value->field_reorderingRequired.log_match(match_value.reorderingRequired(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_reorderingRequired.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".reorderingRequired := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_reorderingRequired.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.recovery().ispresent()){
if(!single_value->field_recovery.match(match_value.recovery(), legacy)){
TTCN_Logger::log_logmatch_info(".recovery");
single_value->field_recovery.log_match(match_value.recovery(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_recovery.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".recovery := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_recovery.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.teidDataI().ispresent()){
if(!single_value->field_teidDataI.match(match_value.teidDataI(), legacy)){
TTCN_Logger::log_logmatch_info(".teidDataI");
single_value->field_teidDataI.log_match(match_value.teidDataI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_teidDataI.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".teidDataI := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_teidDataI.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.teidControlPlane().ispresent()){
if(!single_value->field_teidControlPlane.match(match_value.teidControlPlane(), legacy)){
TTCN_Logger::log_logmatch_info(".teidControlPlane");
single_value->field_teidControlPlane.log_match(match_value.teidControlPlane(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_teidControlPlane.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".teidControlPlane := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_teidControlPlane.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.nsapi().ispresent()){
if(!single_value->field_nsapi.match(match_value.nsapi(), legacy)){
TTCN_Logger::log_logmatch_info(".nsapi");
single_value->field_nsapi.log_match(match_value.nsapi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_nsapi.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".nsapi := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_nsapi.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.chargingID().ispresent()){
if(!single_value->field_chargingID.match(match_value.chargingID(), legacy)){
TTCN_Logger::log_logmatch_info(".chargingID");
single_value->field_chargingID.log_match(match_value.chargingID(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_chargingID.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".chargingID := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_chargingID.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.endUserAddress().ispresent()){
if(!single_value->field_endUserAddress.match(match_value.endUserAddress(), legacy)){
TTCN_Logger::log_logmatch_info(".endUserAddress");
single_value->field_endUserAddress.log_match(match_value.endUserAddress(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_endUserAddress.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".endUserAddress := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_endUserAddress.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.protConfigOptions().ispresent()){
if(!single_value->field_protConfigOptions.match(match_value.protConfigOptions(), legacy)){
TTCN_Logger::log_logmatch_info(".protConfigOptions");
single_value->field_protConfigOptions.log_match(match_value.protConfigOptions(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_protConfigOptions.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".protConfigOptions := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_protConfigOptions.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.ggsn__addr__controlPlane().ispresent()){
if(!single_value->field_ggsn__addr__controlPlane.match(match_value.ggsn__addr__controlPlane(), legacy)){
TTCN_Logger::log_logmatch_info(".ggsn_addr_controlPlane");
single_value->field_ggsn__addr__controlPlane.log_match(match_value.ggsn__addr__controlPlane(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_ggsn__addr__controlPlane.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".ggsn_addr_controlPlane := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_ggsn__addr__controlPlane.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.ggsn__addr__traffic().ispresent()){
if(!single_value->field_ggsn__addr__traffic.match(match_value.ggsn__addr__traffic(), legacy)){
TTCN_Logger::log_logmatch_info(".ggsn_addr_traffic");
single_value->field_ggsn__addr__traffic.log_match(match_value.ggsn__addr__traffic(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_ggsn__addr__traffic.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".ggsn_addr_traffic := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_ggsn__addr__traffic.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.alt__ggsn__addr__controlPane().ispresent()){
if(!single_value->field_alt__ggsn__addr__controlPane.match(match_value.alt__ggsn__addr__controlPane(), legacy)){
TTCN_Logger::log_logmatch_info(".alt_ggsn_addr_controlPane");
single_value->field_alt__ggsn__addr__controlPane.log_match(match_value.alt__ggsn__addr__controlPane(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_alt__ggsn__addr__controlPane.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".alt_ggsn_addr_controlPane := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_alt__ggsn__addr__controlPane.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.alt__ggsn__addr__traffic().ispresent()){
if(!single_value->field_alt__ggsn__addr__traffic.match(match_value.alt__ggsn__addr__traffic(), legacy)){
TTCN_Logger::log_logmatch_info(".alt_ggsn_addr_traffic");
single_value->field_alt__ggsn__addr__traffic.log_match(match_value.alt__ggsn__addr__traffic(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_alt__ggsn__addr__traffic.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".alt_ggsn_addr_traffic := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_alt__ggsn__addr__traffic.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.qualityOfServiceProfile().ispresent()){
if(!single_value->field_qualityOfServiceProfile.match(match_value.qualityOfServiceProfile(), legacy)){
TTCN_Logger::log_logmatch_info(".qualityOfServiceProfile");
single_value->field_qualityOfServiceProfile.log_match(match_value.qualityOfServiceProfile(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_qualityOfServiceProfile.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".qualityOfServiceProfile := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_qualityOfServiceProfile.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.commonFlags().ispresent()){
if(!single_value->field_commonFlags.match(match_value.commonFlags(), legacy)){
TTCN_Logger::log_logmatch_info(".commonFlags");
single_value->field_commonFlags.log_match(match_value.commonFlags(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_commonFlags.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".commonFlags := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_commonFlags.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.aPN__Restriction().ispresent()){
if(!single_value->field_aPN__Restriction.match(match_value.aPN__Restriction(), legacy)){
TTCN_Logger::log_logmatch_info(".aPN_Restriction");
single_value->field_aPN__Restriction.log_match(match_value.aPN__Restriction(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_aPN__Restriction.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".aPN_Restriction := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_aPN__Restriction.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.mS__InfoChangeReportingAction().ispresent()){
if(!single_value->field_mS__InfoChangeReportingAction.match(match_value.mS__InfoChangeReportingAction(), legacy)){
TTCN_Logger::log_logmatch_info(".mS_InfoChangeReportingAction");
single_value->field_mS__InfoChangeReportingAction.log_match(match_value.mS__InfoChangeReportingAction(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_mS__InfoChangeReportingAction.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".mS_InfoChangeReportingAction := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_mS__InfoChangeReportingAction.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.bearerControlMode().ispresent()){
if(!single_value->field_bearerControlMode.match(match_value.bearerControlMode(), legacy)){
TTCN_Logger::log_logmatch_info(".bearerControlMode");
single_value->field_bearerControlMode.log_match(match_value.bearerControlMode(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_bearerControlMode.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".bearerControlMode := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_bearerControlMode.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.evolvedAllocationRetentionPriorityI().ispresent()){
if(!single_value->field_evolvedAllocationRetentionPriorityI.match(match_value.evolvedAllocationRetentionPriorityI(), legacy)){
TTCN_Logger::log_logmatch_info(".evolvedAllocationRetentionPriorityI");
single_value->field_evolvedAllocationRetentionPriorityI.log_match(match_value.evolvedAllocationRetentionPriorityI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_evolvedAllocationRetentionPriorityI.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".evolvedAllocationRetentionPriorityI := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_evolvedAllocationRetentionPriorityI.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.extendedCommonFlag().ispresent()){
if(!single_value->field_extendedCommonFlag.match(match_value.extendedCommonFlag(), legacy)){
TTCN_Logger::log_logmatch_info(".extendedCommonFlag");
single_value->field_extendedCommonFlag.log_match(match_value.extendedCommonFlag(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extendedCommonFlag.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extendedCommonFlag := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extendedCommonFlag.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.csg__information__reporting__action().ispresent()){
if(!single_value->field_csg__information__reporting__action.match(match_value.csg__information__reporting__action(), legacy)){
TTCN_Logger::log_logmatch_info(".csg_information_reporting_action");
single_value->field_csg__information__reporting__action.log_match(match_value.csg__information__reporting__action(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_csg__information__reporting__action.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".csg_information_reporting_action := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_csg__information__reporting__action.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.aPN__AMBR().ispresent()){
if(!single_value->field_aPN__AMBR.match(match_value.aPN__AMBR(), legacy)){
TTCN_Logger::log_logmatch_info(".aPN_AMBR");
single_value->field_aPN__AMBR.log_match(match_value.aPN__AMBR(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_aPN__AMBR.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".aPN_AMBR := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_aPN__AMBR.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.gGSN__BackOffTime().ispresent()){
if(!single_value->field_gGSN__BackOffTime.match(match_value.gGSN__BackOffTime(), legacy)){
TTCN_Logger::log_logmatch_info(".gGSN_BackOffTime");
single_value->field_gGSN__BackOffTime.log_match(match_value.gGSN__BackOffTime(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_gGSN__BackOffTime.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".gGSN_BackOffTime := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_gGSN__BackOffTime.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.private__extension__gtpc().ispresent()){
if(!single_value->field_private__extension__gtpc.match(match_value.private__extension__gtpc(), legacy)){
TTCN_Logger::log_logmatch_info(".private_extension_gtpc");
single_value->field_private__extension__gtpc.log_match(match_value.private__extension__gtpc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_private__extension__gtpc.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".private_extension_gtpc := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_private__extension__gtpc.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ cause := ");
single_value->field_cause.log_match(match_value.cause(), legacy);
TTCN_Logger::log_event_str(", reorderingRequired := ");
if (match_value.reorderingRequired().ispresent()) {
single_value->field_reorderingRequired.log_match(match_value.reorderingRequired(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_reorderingRequired.log();
if (single_value->field_reorderingRequired.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", recovery := ");
if (match_value.recovery().ispresent()) {
single_value->field_recovery.log_match(match_value.recovery(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_recovery.log();
if (single_value->field_recovery.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", teidDataI := ");
if (match_value.teidDataI().ispresent()) {
single_value->field_teidDataI.log_match(match_value.teidDataI(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_teidDataI.log();
if (single_value->field_teidDataI.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", teidControlPlane := ");
if (match_value.teidControlPlane().ispresent()) {
single_value->field_teidControlPlane.log_match(match_value.teidControlPlane(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_teidControlPlane.log();
if (single_value->field_teidControlPlane.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", nsapi := ");
if (match_value.nsapi().ispresent()) {
single_value->field_nsapi.log_match(match_value.nsapi(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_nsapi.log();
if (single_value->field_nsapi.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", chargingID := ");
if (match_value.chargingID().ispresent()) {
single_value->field_chargingID.log_match(match_value.chargingID(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_chargingID.log();
if (single_value->field_chargingID.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", endUserAddress := ");
if (match_value.endUserAddress().ispresent()) {
single_value->field_endUserAddress.log_match(match_value.endUserAddress(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_endUserAddress.log();
if (single_value->field_endUserAddress.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", protConfigOptions := ");
if (match_value.protConfigOptions().ispresent()) {
single_value->field_protConfigOptions.log_match(match_value.protConfigOptions(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_protConfigOptions.log();
if (single_value->field_protConfigOptions.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", ggsn_addr_controlPlane := ");
if (match_value.ggsn__addr__controlPlane().ispresent()) {
single_value->field_ggsn__addr__controlPlane.log_match(match_value.ggsn__addr__controlPlane(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_ggsn__addr__controlPlane.log();
if (single_value->field_ggsn__addr__controlPlane.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", ggsn_addr_traffic := ");
if (match_value.ggsn__addr__traffic().ispresent()) {
single_value->field_ggsn__addr__traffic.log_match(match_value.ggsn__addr__traffic(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_ggsn__addr__traffic.log();
if (single_value->field_ggsn__addr__traffic.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", alt_ggsn_addr_controlPane := ");
if (match_value.alt__ggsn__addr__controlPane().ispresent()) {
single_value->field_alt__ggsn__addr__controlPane.log_match(match_value.alt__ggsn__addr__controlPane(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_alt__ggsn__addr__controlPane.log();
if (single_value->field_alt__ggsn__addr__controlPane.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", alt_ggsn_addr_traffic := ");
if (match_value.alt__ggsn__addr__traffic().ispresent()) {
single_value->field_alt__ggsn__addr__traffic.log_match(match_value.alt__ggsn__addr__traffic(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_alt__ggsn__addr__traffic.log();
if (single_value->field_alt__ggsn__addr__traffic.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", qualityOfServiceProfile := ");
if (match_value.qualityOfServiceProfile().ispresent()) {
single_value->field_qualityOfServiceProfile.log_match(match_value.qualityOfServiceProfile(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_qualityOfServiceProfile.log();
if (single_value->field_qualityOfServiceProfile.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", commonFlags := ");
if (match_value.commonFlags().ispresent()) {
single_value->field_commonFlags.log_match(match_value.commonFlags(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_commonFlags.log();
if (single_value->field_commonFlags.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", aPN_Restriction := ");
if (match_value.aPN__Restriction().ispresent()) {
single_value->field_aPN__Restriction.log_match(match_value.aPN__Restriction(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_aPN__Restriction.log();
if (single_value->field_aPN__Restriction.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", mS_InfoChangeReportingAction := ");
if (match_value.mS__InfoChangeReportingAction().ispresent()) {
single_value->field_mS__InfoChangeReportingAction.log_match(match_value.mS__InfoChangeReportingAction(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_mS__InfoChangeReportingAction.log();
if (single_value->field_mS__InfoChangeReportingAction.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", bearerControlMode := ");
if (match_value.bearerControlMode().ispresent()) {
single_value->field_bearerControlMode.log_match(match_value.bearerControlMode(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_bearerControlMode.log();
if (single_value->field_bearerControlMode.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", evolvedAllocationRetentionPriorityI := ");
if (match_value.evolvedAllocationRetentionPriorityI().ispresent()) {
single_value->field_evolvedAllocationRetentionPriorityI.log_match(match_value.evolvedAllocationRetentionPriorityI(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_evolvedAllocationRetentionPriorityI.log();
if (single_value->field_evolvedAllocationRetentionPriorityI.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", extendedCommonFlag := ");
if (match_value.extendedCommonFlag().ispresent()) {
single_value->field_extendedCommonFlag.log_match(match_value.extendedCommonFlag(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extendedCommonFlag.log();
if (single_value->field_extendedCommonFlag.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", csg_information_reporting_action := ");
if (match_value.csg__information__reporting__action().ispresent()) {
single_value->field_csg__information__reporting__action.log_match(match_value.csg__information__reporting__action(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_csg__information__reporting__action.log();
if (single_value->field_csg__information__reporting__action.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", aPN_AMBR := ");
if (match_value.aPN__AMBR().ispresent()) {
single_value->field_aPN__AMBR.log_match(match_value.aPN__AMBR(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_aPN__AMBR.log();
if (single_value->field_aPN__AMBR.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", gGSN_BackOffTime := ");
if (match_value.gGSN__BackOffTime().ispresent()) {
single_value->field_gGSN__BackOffTime.log_match(match_value.gGSN__BackOffTime(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_gGSN__BackOffTime.log();
if (single_value->field_gGSN__BackOffTime.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", private_extension_gtpc := ");
if (match_value.private__extension__gtpc().ispresent()) {
single_value->field_private__extension__gtpc.log_match(match_value.private__extension__gtpc(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_private__extension__gtpc.log();
if (single_value->field_private__extension__gtpc.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void CreatePDPContextResponse_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (cause().is_bound()) cause().set_implicit_omit();
if (!reorderingRequired().is_bound()) reorderingRequired() = OMIT_VALUE;
else reorderingRequired().set_implicit_omit();
if (!recovery().is_bound()) recovery() = OMIT_VALUE;
else recovery().set_implicit_omit();
if (!teidDataI().is_bound()) teidDataI() = OMIT_VALUE;
else teidDataI().set_implicit_omit();
if (!teidControlPlane().is_bound()) teidControlPlane() = OMIT_VALUE;
else teidControlPlane().set_implicit_omit();
if (!nsapi().is_bound()) nsapi() = OMIT_VALUE;
else nsapi().set_implicit_omit();
if (!chargingID().is_bound()) chargingID() = OMIT_VALUE;
else chargingID().set_implicit_omit();
if (!endUserAddress().is_bound()) endUserAddress() = OMIT_VALUE;
else endUserAddress().set_implicit_omit();
if (!protConfigOptions().is_bound()) protConfigOptions() = OMIT_VALUE;
else protConfigOptions().set_implicit_omit();
if (!ggsn__addr__controlPlane().is_bound()) ggsn__addr__controlPlane() = OMIT_VALUE;
else ggsn__addr__controlPlane().set_implicit_omit();
if (!ggsn__addr__traffic().is_bound()) ggsn__addr__traffic() = OMIT_VALUE;
else ggsn__addr__traffic().set_implicit_omit();
if (!alt__ggsn__addr__controlPane().is_bound()) alt__ggsn__addr__controlPane() = OMIT_VALUE;
else alt__ggsn__addr__controlPane().set_implicit_omit();
if (!alt__ggsn__addr__traffic().is_bound()) alt__ggsn__addr__traffic() = OMIT_VALUE;
else alt__ggsn__addr__traffic().set_implicit_omit();
if (!qualityOfServiceProfile().is_bound()) qualityOfServiceProfile() = OMIT_VALUE;
else qualityOfServiceProfile().set_implicit_omit();
if (!commonFlags().is_bound()) commonFlags() = OMIT_VALUE;
else commonFlags().set_implicit_omit();
if (!aPN__Restriction().is_bound()) aPN__Restriction() = OMIT_VALUE;
else aPN__Restriction().set_implicit_omit();
if (!mS__InfoChangeReportingAction().is_bound()) mS__InfoChangeReportingAction() = OMIT_VALUE;
else mS__InfoChangeReportingAction().set_implicit_omit();
if (!bearerControlMode().is_bound()) bearerControlMode() = OMIT_VALUE;
else bearerControlMode().set_implicit_omit();
if (!evolvedAllocationRetentionPriorityI().is_bound()) evolvedAllocationRetentionPriorityI() = OMIT_VALUE;
else evolvedAllocationRetentionPriorityI().set_implicit_omit();
if (!extendedCommonFlag().is_bound()) extendedCommonFlag() = OMIT_VALUE;
else extendedCommonFlag().set_implicit_omit();
if (!csg__information__reporting__action().is_bound()) csg__information__reporting__action() = OMIT_VALUE;
else csg__information__reporting__action().set_implicit_omit();
if (!aPN__AMBR().is_bound()) aPN__AMBR() = OMIT_VALUE;
else aPN__AMBR().set_implicit_omit();
if (!gGSN__BackOffTime().is_bound()) gGSN__BackOffTime() = OMIT_VALUE;
else gGSN__BackOffTime().set_implicit_omit();
if (!private__extension__gtpc().is_bound()) private__extension__gtpc() = OMIT_VALUE;
else private__extension__gtpc().set_implicit_omit();
}

void CreatePDPContextResponse_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_cause.encode_text(text_buf);
single_value->field_reorderingRequired.encode_text(text_buf);
single_value->field_recovery.encode_text(text_buf);
single_value->field_teidDataI.encode_text(text_buf);
single_value->field_teidControlPlane.encode_text(text_buf);
single_value->field_nsapi.encode_text(text_buf);
single_value->field_chargingID.encode_text(text_buf);
single_value->field_endUserAddress.encode_text(text_buf);
single_value->field_protConfigOptions.encode_text(text_buf);
single_value->field_ggsn__addr__controlPlane.encode_text(text_buf);
single_value->field_ggsn__addr__traffic.encode_text(text_buf);
single_value->field_alt__ggsn__addr__controlPane.encode_text(text_buf);
single_value->field_alt__ggsn__addr__traffic.encode_text(text_buf);
single_value->field_qualityOfServiceProfile.encode_text(text_buf);
single_value->field_commonFlags.encode_text(text_buf);
single_value->field_aPN__Restriction.encode_text(text_buf);
single_value->field_mS__InfoChangeReportingAction.encode_text(text_buf);
single_value->field_bearerControlMode.encode_text(text_buf);
single_value->field_evolvedAllocationRetentionPriorityI.encode_text(text_buf);
single_value->field_extendedCommonFlag.encode_text(text_buf);
single_value->field_csg__information__reporting__action.encode_text(text_buf);
single_value->field_aPN__AMBR.encode_text(text_buf);
single_value->field_gGSN__BackOffTime.encode_text(text_buf);
single_value->field_private__extension__gtpc.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.CreatePDPContextResponse.");
}
}

void CreatePDPContextResponse_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_cause.decode_text(text_buf);
single_value->field_reorderingRequired.decode_text(text_buf);
single_value->field_recovery.decode_text(text_buf);
single_value->field_teidDataI.decode_text(text_buf);
single_value->field_teidControlPlane.decode_text(text_buf);
single_value->field_nsapi.decode_text(text_buf);
single_value->field_chargingID.decode_text(text_buf);
single_value->field_endUserAddress.decode_text(text_buf);
single_value->field_protConfigOptions.decode_text(text_buf);
single_value->field_ggsn__addr__controlPlane.decode_text(text_buf);
single_value->field_ggsn__addr__traffic.decode_text(text_buf);
single_value->field_alt__ggsn__addr__controlPane.decode_text(text_buf);
single_value->field_alt__ggsn__addr__traffic.decode_text(text_buf);
single_value->field_qualityOfServiceProfile.decode_text(text_buf);
single_value->field_commonFlags.decode_text(text_buf);
single_value->field_aPN__Restriction.decode_text(text_buf);
single_value->field_mS__InfoChangeReportingAction.decode_text(text_buf);
single_value->field_bearerControlMode.decode_text(text_buf);
single_value->field_evolvedAllocationRetentionPriorityI.decode_text(text_buf);
single_value->field_extendedCommonFlag.decode_text(text_buf);
single_value->field_csg__information__reporting__action.decode_text(text_buf);
single_value->field_aPN__AMBR.decode_text(text_buf);
single_value->field_gGSN__BackOffTime.decode_text(text_buf);
single_value->field_private__extension__gtpc.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new CreatePDPContextResponse_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.CreatePDPContextResponse.");
}
}

void CreatePDPContextResponse_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    CreatePDPContextResponse_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (24<param.get_size()) {
      param.error("record template of type @GTPC_Types.CreatePDPContextResponse has 24 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) cause().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) reorderingRequired().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) recovery().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) teidDataI().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) teidControlPlane().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) nsapi().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) chargingID().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) endUserAddress().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) protConfigOptions().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) ggsn__addr__controlPlane().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) ggsn__addr__traffic().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) alt__ggsn__addr__controlPane().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) alt__ggsn__addr__traffic().set_param(*param.get_elem(12));
    if (param.get_size()>13 && param.get_elem(13)->get_type()!=Module_Param::MP_NotUsed) qualityOfServiceProfile().set_param(*param.get_elem(13));
    if (param.get_size()>14 && param.get_elem(14)->get_type()!=Module_Param::MP_NotUsed) commonFlags().set_param(*param.get_elem(14));
    if (param.get_size()>15 && param.get_elem(15)->get_type()!=Module_Param::MP_NotUsed) aPN__Restriction().set_param(*param.get_elem(15));
    if (param.get_size()>16 && param.get_elem(16)->get_type()!=Module_Param::MP_NotUsed) mS__InfoChangeReportingAction().set_param(*param.get_elem(16));
    if (param.get_size()>17 && param.get_elem(17)->get_type()!=Module_Param::MP_NotUsed) bearerControlMode().set_param(*param.get_elem(17));
    if (param.get_size()>18 && param.get_elem(18)->get_type()!=Module_Param::MP_NotUsed) evolvedAllocationRetentionPriorityI().set_param(*param.get_elem(18));
    if (param.get_size()>19 && param.get_elem(19)->get_type()!=Module_Param::MP_NotUsed) extendedCommonFlag().set_param(*param.get_elem(19));
    if (param.get_size()>20 && param.get_elem(20)->get_type()!=Module_Param::MP_NotUsed) csg__information__reporting__action().set_param(*param.get_elem(20));
    if (param.get_size()>21 && param.get_elem(21)->get_type()!=Module_Param::MP_NotUsed) aPN__AMBR().set_param(*param.get_elem(21));
    if (param.get_size()>22 && param.get_elem(22)->get_type()!=Module_Param::MP_NotUsed) gGSN__BackOffTime().set_param(*param.get_elem(22));
    if (param.get_size()>23 && param.get_elem(23)->get_type()!=Module_Param::MP_NotUsed) private__extension__gtpc().set_param(*param.get_elem(23));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "reorderingRequired")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          reorderingRequired().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "recovery")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          recovery().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "teidDataI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          teidDataI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "teidControlPlane")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          teidControlPlane().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsapi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsapi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "chargingID")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          chargingID().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "endUserAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          endUserAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protConfigOptions")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protConfigOptions().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ggsn_addr_controlPlane")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ggsn__addr__controlPlane().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ggsn_addr_traffic")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ggsn__addr__traffic().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "alt_ggsn_addr_controlPane")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          alt__ggsn__addr__controlPane().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "alt_ggsn_addr_traffic")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          alt__ggsn__addr__traffic().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "qualityOfServiceProfile")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          qualityOfServiceProfile().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "commonFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          commonFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aPN_Restriction")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aPN__Restriction().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mS_InfoChangeReportingAction")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mS__InfoChangeReportingAction().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bearerControlMode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bearerControlMode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "evolvedAllocationRetentionPriorityI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          evolvedAllocationRetentionPriorityI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extendedCommonFlag")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extendedCommonFlag().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "csg_information_reporting_action")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          csg__information__reporting__action().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aPN_AMBR")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aPN__AMBR().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gGSN_BackOffTime")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gGSN__BackOffTime().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "private_extension_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          private__extension__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.CreatePDPContextResponse: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    CreatePDPContextResponse_template* precondition = new CreatePDPContextResponse_template;
    precondition->set_param(*param.get_elem(0));
    CreatePDPContextResponse_template* implied_template = new CreatePDPContextResponse_template;
    implied_template->set_param(*param.get_elem(1));
    *this = CreatePDPContextResponse_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.CreatePDPContextResponse");
  }
  is_ifpresent = param.get_ifpresent();
}

void CreatePDPContextResponse_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_cause.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
single_value->field_reorderingRequired.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
single_value->field_recovery.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
single_value->field_teidDataI.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
single_value->field_teidControlPlane.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
single_value->field_nsapi.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
single_value->field_chargingID.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
single_value->field_endUserAddress.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
single_value->field_protConfigOptions.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
single_value->field_ggsn__addr__controlPlane.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
single_value->field_ggsn__addr__traffic.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
single_value->field_alt__ggsn__addr__controlPane.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
single_value->field_alt__ggsn__addr__traffic.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
single_value->field_qualityOfServiceProfile.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
single_value->field_commonFlags.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
single_value->field_aPN__Restriction.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
single_value->field_mS__InfoChangeReportingAction.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
single_value->field_bearerControlMode.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
single_value->field_evolvedAllocationRetentionPriorityI.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
single_value->field_extendedCommonFlag.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
single_value->field_csg__information__reporting__action.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
single_value->field_aPN__AMBR.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
single_value->field_gGSN__BackOffTime.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
single_value->field_private__extension__gtpc.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.CreatePDPContextResponse");
}

boolean CreatePDPContextResponse_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean CreatePDPContextResponse_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void UpdatePDPContextRequest::copy_value(const UpdatePDPContextRequest& other_value)
{
switch (other_value.union_selection) {
case ALT_updatePDPContextRequestSGSN:
field_updatePDPContextRequestSGSN = new UpdatePDPContextRequestSGSN(*other_value.field_updatePDPContextRequestSGSN);
break;
case ALT_updatePDPContextRequestGGSN:
field_updatePDPContextRequestGGSN = new UpdatePDPContextRequestGGSN(*other_value.field_updatePDPContextRequestGGSN);
break;
case ALT_updatePDPContextRequestCGW:
field_updatePDPContextRequestCGW = new UpdatePDPContextRequestCGW(*other_value.field_updatePDPContextRequestCGW);
break;
default:
TTCN_error("Assignment of an unbound union value of type @GTPC_Types.UpdatePDPContextRequest.");
}
union_selection = other_value.union_selection;
}

UpdatePDPContextRequest::UpdatePDPContextRequest()
{
union_selection = UNBOUND_VALUE;
}

UpdatePDPContextRequest::UpdatePDPContextRequest(const UpdatePDPContextRequest& other_value)
: Base_Type(){
copy_value(other_value);
}

UpdatePDPContextRequest::~UpdatePDPContextRequest()
{
clean_up();
}

UpdatePDPContextRequest& UpdatePDPContextRequest::operator=(const UpdatePDPContextRequest& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean UpdatePDPContextRequest::operator==(const UpdatePDPContextRequest& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @GTPC_Types.UpdatePDPContextRequest.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @GTPC_Types.UpdatePDPContextRequest.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_updatePDPContextRequestSGSN:
return *field_updatePDPContextRequestSGSN == *other_value.field_updatePDPContextRequestSGSN;
case ALT_updatePDPContextRequestGGSN:
return *field_updatePDPContextRequestGGSN == *other_value.field_updatePDPContextRequestGGSN;
case ALT_updatePDPContextRequestCGW:
return *field_updatePDPContextRequestCGW == *other_value.field_updatePDPContextRequestCGW;
default:
return FALSE;
}
}

UpdatePDPContextRequestSGSN& UpdatePDPContextRequest::updatePDPContextRequestSGSN()
{
if (union_selection != ALT_updatePDPContextRequestSGSN) {
clean_up();
field_updatePDPContextRequestSGSN = new UpdatePDPContextRequestSGSN;
union_selection = ALT_updatePDPContextRequestSGSN;
}
return *field_updatePDPContextRequestSGSN;
}

const UpdatePDPContextRequestSGSN& UpdatePDPContextRequest::updatePDPContextRequestSGSN() const
{
if (union_selection != ALT_updatePDPContextRequestSGSN) TTCN_error("Using non-selected field updatePDPContextRequestSGSN in a value of union type @GTPC_Types.UpdatePDPContextRequest.");
return *field_updatePDPContextRequestSGSN;
}

UpdatePDPContextRequestGGSN& UpdatePDPContextRequest::updatePDPContextRequestGGSN()
{
if (union_selection != ALT_updatePDPContextRequestGGSN) {
clean_up();
field_updatePDPContextRequestGGSN = new UpdatePDPContextRequestGGSN;
union_selection = ALT_updatePDPContextRequestGGSN;
}
return *field_updatePDPContextRequestGGSN;
}

const UpdatePDPContextRequestGGSN& UpdatePDPContextRequest::updatePDPContextRequestGGSN() const
{
if (union_selection != ALT_updatePDPContextRequestGGSN) TTCN_error("Using non-selected field updatePDPContextRequestGGSN in a value of union type @GTPC_Types.UpdatePDPContextRequest.");
return *field_updatePDPContextRequestGGSN;
}

UpdatePDPContextRequestCGW& UpdatePDPContextRequest::updatePDPContextRequestCGW()
{
if (union_selection != ALT_updatePDPContextRequestCGW) {
clean_up();
field_updatePDPContextRequestCGW = new UpdatePDPContextRequestCGW;
union_selection = ALT_updatePDPContextRequestCGW;
}
return *field_updatePDPContextRequestCGW;
}

const UpdatePDPContextRequestCGW& UpdatePDPContextRequest::updatePDPContextRequestCGW() const
{
if (union_selection != ALT_updatePDPContextRequestCGW) TTCN_error("Using non-selected field updatePDPContextRequestCGW in a value of union type @GTPC_Types.UpdatePDPContextRequest.");
return *field_updatePDPContextRequestCGW;
}

boolean UpdatePDPContextRequest::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @GTPC_Types.UpdatePDPContextRequest.");
return union_selection == checked_selection;
}

boolean UpdatePDPContextRequest::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean UpdatePDPContextRequest::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_updatePDPContextRequestSGSN: return field_updatePDPContextRequestSGSN->is_value();
case ALT_updatePDPContextRequestGGSN: return field_updatePDPContextRequestGGSN->is_value();
case ALT_updatePDPContextRequestCGW: return field_updatePDPContextRequestCGW->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void UpdatePDPContextRequest::clean_up()
{
switch (union_selection) {
case ALT_updatePDPContextRequestSGSN:
  delete field_updatePDPContextRequestSGSN;
  break;
case ALT_updatePDPContextRequestGGSN:
  delete field_updatePDPContextRequestGGSN;
  break;
case ALT_updatePDPContextRequestCGW:
  delete field_updatePDPContextRequestCGW;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void UpdatePDPContextRequest::log() const
{
switch (union_selection) {
case ALT_updatePDPContextRequestSGSN:
TTCN_Logger::log_event_str("{ updatePDPContextRequestSGSN := ");
field_updatePDPContextRequestSGSN->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_updatePDPContextRequestGGSN:
TTCN_Logger::log_event_str("{ updatePDPContextRequestGGSN := ");
field_updatePDPContextRequestGGSN->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_updatePDPContextRequestCGW:
TTCN_Logger::log_event_str("{ updatePDPContextRequestCGW := ");
field_updatePDPContextRequestCGW->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void UpdatePDPContextRequest::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "updatePDPContextRequestSGSN")) {
    updatePDPContextRequestSGSN().set_param(*mp_last);
    if (!updatePDPContextRequestSGSN().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "updatePDPContextRequestGGSN")) {
    updatePDPContextRequestGGSN().set_param(*mp_last);
    if (!updatePDPContextRequestGGSN().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "updatePDPContextRequestCGW")) {
    updatePDPContextRequestCGW().set_param(*mp_last);
    if (!updatePDPContextRequestCGW().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @GTPC_Types.UpdatePDPContextRequest.", last_name);
}

void UpdatePDPContextRequest::set_implicit_omit()
{
switch (union_selection) {
case ALT_updatePDPContextRequestSGSN:
field_updatePDPContextRequestSGSN->set_implicit_omit(); break;
case ALT_updatePDPContextRequestGGSN:
field_updatePDPContextRequestGGSN->set_implicit_omit(); break;
case ALT_updatePDPContextRequestCGW:
field_updatePDPContextRequestCGW->set_implicit_omit(); break;
default: break;
}
}

void UpdatePDPContextRequest::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_updatePDPContextRequestSGSN:
field_updatePDPContextRequestSGSN->encode_text(text_buf);
break;
case ALT_updatePDPContextRequestGGSN:
field_updatePDPContextRequestGGSN->encode_text(text_buf);
break;
case ALT_updatePDPContextRequestCGW:
field_updatePDPContextRequestCGW->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @GTPC_Types.UpdatePDPContextRequest.");
}
}

void UpdatePDPContextRequest::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_updatePDPContextRequestSGSN:
updatePDPContextRequestSGSN().decode_text(text_buf);
break;
case ALT_updatePDPContextRequestGGSN:
updatePDPContextRequestGGSN().decode_text(text_buf);
break;
case ALT_updatePDPContextRequestCGW:
updatePDPContextRequestCGW().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @GTPC_Types.UpdatePDPContextRequest.");
}
}

void UpdatePDPContextRequest::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void UpdatePDPContextRequest::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int UpdatePDPContextRequest::RAW_decode(
const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, 
raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean, const RAW_Force_Omit* force_omit)
{
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  int decoded_length=0;
  int starting_pos=p_buf.get_pos_bit();
  if(sel_field!=-1){
    switch(sel_field){
    case 0: {
      RAW_Force_Omit field_force_omit(0, force_omit, UpdatePDPContextRequestSGSN_descr_.raw->forceomit);
      decoded_length = updatePDPContextRequestSGSN().RAW_decode(UpdatePDPContextRequestSGSN_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 1: {
      RAW_Force_Omit field_force_omit(1, force_omit, UpdatePDPContextRequestGGSN_descr_.raw->forceomit);
      decoded_length = updatePDPContextRequestGGSN().RAW_decode(UpdatePDPContextRequestGGSN_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    case 2: {
      RAW_Force_Omit field_force_omit(2, force_omit, UpdatePDPContextRequestCGW_descr_.raw->forceomit);
      decoded_length = updatePDPContextRequestCGW().RAW_decode(UpdatePDPContextRequestCGW_descr_, p_buf, limit, top_bit_ord, no_err, -1, TRUE, &field_force_omit);
      break; }
    default: break;
    }
    return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
  } else {
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_0_force_omit(0, force_omit, UpdatePDPContextRequestSGSN_descr_.raw->forceomit);
      decoded_length = updatePDPContextRequestSGSN().RAW_decode(UpdatePDPContextRequestSGSN_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_0_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_1_force_omit(1, force_omit, UpdatePDPContextRequestGGSN_descr_.raw->forceomit);
      decoded_length = updatePDPContextRequestGGSN().RAW_decode(UpdatePDPContextRequestGGSN_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_1_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
      p_buf.set_pos_bit(starting_pos);
      RAW_Force_Omit field_2_force_omit(2, force_omit, UpdatePDPContextRequestCGW_descr_.raw->forceomit);
      decoded_length = updatePDPContextRequestCGW().RAW_decode(UpdatePDPContextRequestCGW_descr_, p_buf, limit, top_bit_ord, TRUE, -1, TRUE, &field_2_force_omit);
      if (decoded_length >= 0) {
         return decoded_length + p_buf.increase_pos_padd(p_td.raw->padding) + prepaddlength;
       }
 }
 clean_up();
 return -1;
}

int UpdatePDPContextRequest::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const
{
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 3;  myleaf.body.node.nodes = init_nodes_of_enc_tree(3);
  memset(myleaf.body.node.nodes, 0, 3 * sizeof(RAW_enc_tree *));
  switch (union_selection) {
  case ALT_updatePDPContextRequestSGSN:
    myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 0, UpdatePDPContextRequestSGSN_descr_.raw);
    encoded_length = field_updatePDPContextRequestSGSN->RAW_encode(UpdatePDPContextRequestSGSN_descr_, *myleaf.body.node.nodes[0]);
    myleaf.body.node.nodes[0]->coding_descr = &UpdatePDPContextRequestSGSN_descr_;
    break;
  case ALT_updatePDPContextRequestGGSN:
    myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 1, UpdatePDPContextRequestGGSN_descr_.raw);
    encoded_length = field_updatePDPContextRequestGGSN->RAW_encode(UpdatePDPContextRequestGGSN_descr_, *myleaf.body.node.nodes[1]);
    myleaf.body.node.nodes[1]->coding_descr = &UpdatePDPContextRequestGGSN_descr_;
    break;
  case ALT_updatePDPContextRequestCGW:
    myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &myleaf.curr_pos, 2, UpdatePDPContextRequestCGW_descr_.raw);
    encoded_length = field_updatePDPContextRequestCGW->RAW_encode(UpdatePDPContextRequestCGW_descr_, *myleaf.body.node.nodes[2]);
    myleaf.body.node.nodes[2]->coding_descr = &UpdatePDPContextRequestCGW_descr_;
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  }
  return encoded_length;
}

void UpdatePDPContextRequest_template::copy_value(const UpdatePDPContextRequest& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case UpdatePDPContextRequest::ALT_updatePDPContextRequestSGSN:
single_value.field_updatePDPContextRequestSGSN = new UpdatePDPContextRequestSGSN_template(other_value.updatePDPContextRequestSGSN());
break;
case UpdatePDPContextRequest::ALT_updatePDPContextRequestGGSN:
single_value.field_updatePDPContextRequestGGSN = new UpdatePDPContextRequestGGSN_template(other_value.updatePDPContextRequestGGSN());
break;
case UpdatePDPContextRequest::ALT_updatePDPContextRequestCGW:
single_value.field_updatePDPContextRequestCGW = new UpdatePDPContextRequestCGW_template(other_value.updatePDPContextRequestCGW());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @GTPC_Types.UpdatePDPContextRequest.");
}
set_selection(SPECIFIC_VALUE);
}

void UpdatePDPContextRequest_template::copy_template(const UpdatePDPContextRequest_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case UpdatePDPContextRequest::ALT_updatePDPContextRequestSGSN:
single_value.field_updatePDPContextRequestSGSN = new UpdatePDPContextRequestSGSN_template(*other_value.single_value.field_updatePDPContextRequestSGSN);
break;
case UpdatePDPContextRequest::ALT_updatePDPContextRequestGGSN:
single_value.field_updatePDPContextRequestGGSN = new UpdatePDPContextRequestGGSN_template(*other_value.single_value.field_updatePDPContextRequestGGSN);
break;
case UpdatePDPContextRequest::ALT_updatePDPContextRequestCGW:
single_value.field_updatePDPContextRequestCGW = new UpdatePDPContextRequestCGW_template(*other_value.single_value.field_updatePDPContextRequestCGW);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @GTPC_Types.UpdatePDPContextRequest.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new UpdatePDPContextRequest_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new UpdatePDPContextRequest_template(*other_value.implication_.precondition);
implication_.implied_template = new UpdatePDPContextRequest_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @GTPC_Types.UpdatePDPContextRequest.");
}
set_selection(other_value);
}

UpdatePDPContextRequest_template::UpdatePDPContextRequest_template()
{
}

UpdatePDPContextRequest_template::UpdatePDPContextRequest_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

UpdatePDPContextRequest_template::UpdatePDPContextRequest_template(const UpdatePDPContextRequest& other_value)
{
copy_value(other_value);
}

UpdatePDPContextRequest_template::UpdatePDPContextRequest_template(const OPTIONAL<UpdatePDPContextRequest>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UpdatePDPContextRequest&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @GTPC_Types.UpdatePDPContextRequest from an unbound optional field.");
}
}

UpdatePDPContextRequest_template::UpdatePDPContextRequest_template(UpdatePDPContextRequest_template* p_precondition, UpdatePDPContextRequest_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

UpdatePDPContextRequest_template::UpdatePDPContextRequest_template(Dynamic_Match_Interface<UpdatePDPContextRequest>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<UpdatePDPContextRequest>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

UpdatePDPContextRequest_template::UpdatePDPContextRequest_template(const UpdatePDPContextRequest_template& other_value)
: Base_Template(){
copy_template(other_value);
}

UpdatePDPContextRequest_template::~UpdatePDPContextRequest_template()
{
clean_up();
}

void UpdatePDPContextRequest_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case UpdatePDPContextRequest::ALT_updatePDPContextRequestSGSN:
delete single_value.field_updatePDPContextRequestSGSN;
break;
case UpdatePDPContextRequest::ALT_updatePDPContextRequestGGSN:
delete single_value.field_updatePDPContextRequestGGSN;
break;
case UpdatePDPContextRequest::ALT_updatePDPContextRequestCGW:
delete single_value.field_updatePDPContextRequestCGW;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

UpdatePDPContextRequest_template& UpdatePDPContextRequest_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

UpdatePDPContextRequest_template& UpdatePDPContextRequest_template::operator=(const UpdatePDPContextRequest& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

UpdatePDPContextRequest_template& UpdatePDPContextRequest_template::operator=(const OPTIONAL<UpdatePDPContextRequest>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UpdatePDPContextRequest&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @GTPC_Types.UpdatePDPContextRequest.");
}
return *this;
}

UpdatePDPContextRequest_template& UpdatePDPContextRequest_template::operator=(const UpdatePDPContextRequest_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean UpdatePDPContextRequest_template::match(const UpdatePDPContextRequest& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
UpdatePDPContextRequest::union_selection_type value_selection = other_value.get_selection();
if (value_selection == UpdatePDPContextRequest::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case UpdatePDPContextRequest::ALT_updatePDPContextRequestSGSN:
return single_value.field_updatePDPContextRequestSGSN->match(other_value.updatePDPContextRequestSGSN(), legacy);
case UpdatePDPContextRequest::ALT_updatePDPContextRequestGGSN:
return single_value.field_updatePDPContextRequestGGSN->match(other_value.updatePDPContextRequestGGSN(), legacy);
case UpdatePDPContextRequest::ALT_updatePDPContextRequestCGW:
return single_value.field_updatePDPContextRequestCGW->match(other_value.updatePDPContextRequestCGW(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @GTPC_Types.UpdatePDPContextRequest.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @GTPC_Types.UpdatePDPContextRequest.");
}
return FALSE;
}

boolean UpdatePDPContextRequest_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case UpdatePDPContextRequest::ALT_updatePDPContextRequestSGSN:
return single_value.field_updatePDPContextRequestSGSN->is_value();
case UpdatePDPContextRequest::ALT_updatePDPContextRequestGGSN:
return single_value.field_updatePDPContextRequestGGSN->is_value();
case UpdatePDPContextRequest::ALT_updatePDPContextRequestCGW:
return single_value.field_updatePDPContextRequestCGW->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @GTPC_Types.UpdatePDPContextRequest.");
}
}

UpdatePDPContextRequest UpdatePDPContextRequest_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @GTPC_Types.UpdatePDPContextRequest.");
UpdatePDPContextRequest ret_val;
switch (single_value.union_selection) {
case UpdatePDPContextRequest::ALT_updatePDPContextRequestSGSN:
ret_val.updatePDPContextRequestSGSN() = single_value.field_updatePDPContextRequestSGSN->valueof();
break;
case UpdatePDPContextRequest::ALT_updatePDPContextRequestGGSN:
ret_val.updatePDPContextRequestGGSN() = single_value.field_updatePDPContextRequestGGSN->valueof();
break;
case UpdatePDPContextRequest::ALT_updatePDPContextRequestCGW:
ret_val.updatePDPContextRequestCGW() = single_value.field_updatePDPContextRequestCGW->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @GTPC_Types.UpdatePDPContextRequest.");
}
return ret_val;
}

UpdatePDPContextRequest_template& UpdatePDPContextRequest_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @GTPC_Types.UpdatePDPContextRequest.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @GTPC_Types.UpdatePDPContextRequest.");
return value_list.list_value[list_index];
}
void UpdatePDPContextRequest_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @GTPC_Types.UpdatePDPContextRequest.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new UpdatePDPContextRequest_template[list_length];
}

UpdatePDPContextRequestSGSN_template& UpdatePDPContextRequest_template::updatePDPContextRequestSGSN()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != UpdatePDPContextRequest::ALT_updatePDPContextRequestSGSN) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_updatePDPContextRequestSGSN = new UpdatePDPContextRequestSGSN_template(ANY_VALUE);
else single_value.field_updatePDPContextRequestSGSN = new UpdatePDPContextRequestSGSN_template;
single_value.union_selection = UpdatePDPContextRequest::ALT_updatePDPContextRequestSGSN;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_updatePDPContextRequestSGSN;
}

const UpdatePDPContextRequestSGSN_template& UpdatePDPContextRequest_template::updatePDPContextRequestSGSN() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field updatePDPContextRequestSGSN in a non-specific template of union type @GTPC_Types.UpdatePDPContextRequest.");
if (single_value.union_selection != UpdatePDPContextRequest::ALT_updatePDPContextRequestSGSN) TTCN_error("Accessing non-selected field updatePDPContextRequestSGSN in a template of union type @GTPC_Types.UpdatePDPContextRequest.");
return *single_value.field_updatePDPContextRequestSGSN;
}

UpdatePDPContextRequestGGSN_template& UpdatePDPContextRequest_template::updatePDPContextRequestGGSN()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != UpdatePDPContextRequest::ALT_updatePDPContextRequestGGSN) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_updatePDPContextRequestGGSN = new UpdatePDPContextRequestGGSN_template(ANY_VALUE);
else single_value.field_updatePDPContextRequestGGSN = new UpdatePDPContextRequestGGSN_template;
single_value.union_selection = UpdatePDPContextRequest::ALT_updatePDPContextRequestGGSN;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_updatePDPContextRequestGGSN;
}

const UpdatePDPContextRequestGGSN_template& UpdatePDPContextRequest_template::updatePDPContextRequestGGSN() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field updatePDPContextRequestGGSN in a non-specific template of union type @GTPC_Types.UpdatePDPContextRequest.");
if (single_value.union_selection != UpdatePDPContextRequest::ALT_updatePDPContextRequestGGSN) TTCN_error("Accessing non-selected field updatePDPContextRequestGGSN in a template of union type @GTPC_Types.UpdatePDPContextRequest.");
return *single_value.field_updatePDPContextRequestGGSN;
}

UpdatePDPContextRequestCGW_template& UpdatePDPContextRequest_template::updatePDPContextRequestCGW()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != UpdatePDPContextRequest::ALT_updatePDPContextRequestCGW) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_updatePDPContextRequestCGW = new UpdatePDPContextRequestCGW_template(ANY_VALUE);
else single_value.field_updatePDPContextRequestCGW = new UpdatePDPContextRequestCGW_template;
single_value.union_selection = UpdatePDPContextRequest::ALT_updatePDPContextRequestCGW;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_updatePDPContextRequestCGW;
}

const UpdatePDPContextRequestCGW_template& UpdatePDPContextRequest_template::updatePDPContextRequestCGW() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field updatePDPContextRequestCGW in a non-specific template of union type @GTPC_Types.UpdatePDPContextRequest.");
if (single_value.union_selection != UpdatePDPContextRequest::ALT_updatePDPContextRequestCGW) TTCN_error("Accessing non-selected field updatePDPContextRequestCGW in a template of union type @GTPC_Types.UpdatePDPContextRequest.");
return *single_value.field_updatePDPContextRequestCGW;
}

boolean UpdatePDPContextRequest_template::ischosen(UpdatePDPContextRequest::union_selection_type checked_selection) const
{
if (checked_selection == UpdatePDPContextRequest::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @GTPC_Types.UpdatePDPContextRequest.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == UpdatePDPContextRequest::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @GTPC_Types.UpdatePDPContextRequest.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @GTPC_Types.UpdatePDPContextRequest containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void UpdatePDPContextRequest_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case UpdatePDPContextRequest::ALT_updatePDPContextRequestSGSN:
TTCN_Logger::log_event_str("{ updatePDPContextRequestSGSN := ");
single_value.field_updatePDPContextRequestSGSN->log();
TTCN_Logger::log_event_str(" }");
break;
case UpdatePDPContextRequest::ALT_updatePDPContextRequestGGSN:
TTCN_Logger::log_event_str("{ updatePDPContextRequestGGSN := ");
single_value.field_updatePDPContextRequestGGSN->log();
TTCN_Logger::log_event_str(" }");
break;
case UpdatePDPContextRequest::ALT_updatePDPContextRequestCGW:
TTCN_Logger::log_event_str("{ updatePDPContextRequestCGW := ");
single_value.field_updatePDPContextRequestCGW->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void UpdatePDPContextRequest_template::log_match(const UpdatePDPContextRequest& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case UpdatePDPContextRequest::ALT_updatePDPContextRequestSGSN:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".updatePDPContextRequestSGSN");
single_value.field_updatePDPContextRequestSGSN->log_match(match_value.updatePDPContextRequestSGSN(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ updatePDPContextRequestSGSN := ");
single_value.field_updatePDPContextRequestSGSN->log_match(match_value.updatePDPContextRequestSGSN(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case UpdatePDPContextRequest::ALT_updatePDPContextRequestGGSN:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".updatePDPContextRequestGGSN");
single_value.field_updatePDPContextRequestGGSN->log_match(match_value.updatePDPContextRequestGGSN(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ updatePDPContextRequestGGSN := ");
single_value.field_updatePDPContextRequestGGSN->log_match(match_value.updatePDPContextRequestGGSN(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case UpdatePDPContextRequest::ALT_updatePDPContextRequestCGW:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".updatePDPContextRequestCGW");
single_value.field_updatePDPContextRequestCGW->log_match(match_value.updatePDPContextRequestCGW(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ updatePDPContextRequestCGW := ");
single_value.field_updatePDPContextRequestCGW->log_match(match_value.updatePDPContextRequestCGW(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void UpdatePDPContextRequest_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case UpdatePDPContextRequest::ALT_updatePDPContextRequestSGSN:
single_value.field_updatePDPContextRequestSGSN->set_implicit_omit(); break;
case UpdatePDPContextRequest::ALT_updatePDPContextRequestGGSN:
single_value.field_updatePDPContextRequestGGSN->set_implicit_omit(); break;
case UpdatePDPContextRequest::ALT_updatePDPContextRequestCGW:
single_value.field_updatePDPContextRequestCGW->set_implicit_omit(); break;
default: break;
}
}

void UpdatePDPContextRequest_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case UpdatePDPContextRequest::ALT_updatePDPContextRequestSGSN:
single_value.field_updatePDPContextRequestSGSN->encode_text(text_buf);
break;
case UpdatePDPContextRequest::ALT_updatePDPContextRequestGGSN:
single_value.field_updatePDPContextRequestGGSN->encode_text(text_buf);
break;
case UpdatePDPContextRequest::ALT_updatePDPContextRequestCGW:
single_value.field_updatePDPContextRequestCGW->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @GTPC_Types.UpdatePDPContextRequest.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @GTPC_Types.UpdatePDPContextRequest.");
}
}

void UpdatePDPContextRequest_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = UpdatePDPContextRequest::UNBOUND_VALUE;
UpdatePDPContextRequest::union_selection_type new_selection = (UpdatePDPContextRequest::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case UpdatePDPContextRequest::ALT_updatePDPContextRequestSGSN:
single_value.field_updatePDPContextRequestSGSN = new UpdatePDPContextRequestSGSN_template;
single_value.field_updatePDPContextRequestSGSN->decode_text(text_buf);
break;
case UpdatePDPContextRequest::ALT_updatePDPContextRequestGGSN:
single_value.field_updatePDPContextRequestGGSN = new UpdatePDPContextRequestGGSN_template;
single_value.field_updatePDPContextRequestGGSN->decode_text(text_buf);
break;
case UpdatePDPContextRequest::ALT_updatePDPContextRequestCGW:
single_value.field_updatePDPContextRequestCGW = new UpdatePDPContextRequestCGW_template;
single_value.field_updatePDPContextRequestCGW->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @GTPC_Types.UpdatePDPContextRequest.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new UpdatePDPContextRequest_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @GTPC_Types.UpdatePDPContextRequest.");
}
}

boolean UpdatePDPContextRequest_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean UpdatePDPContextRequest_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void UpdatePDPContextRequest_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@GTPC_Types.UpdatePDPContextRequest'");
    }
    if (strcmp("updatePDPContextRequestSGSN", param_field) == 0) {
      updatePDPContextRequestSGSN().set_param(param);
      return;
    } else if (strcmp("updatePDPContextRequestGGSN", param_field) == 0) {
      updatePDPContextRequestGGSN().set_param(param);
      return;
    } else if (strcmp("updatePDPContextRequestCGW", param_field) == 0) {
      updatePDPContextRequestCGW().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@GTPC_Types.UpdatePDPContextRequest'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    UpdatePDPContextRequest_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@GTPC_Types.UpdatePDPContextRequest");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "updatePDPContextRequestSGSN")) {
      updatePDPContextRequestSGSN().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "updatePDPContextRequestGGSN")) {
      updatePDPContextRequestGGSN().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "updatePDPContextRequestCGW")) {
      updatePDPContextRequestCGW().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @GTPC_Types.UpdatePDPContextRequest.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    UpdatePDPContextRequest_template* precondition = new UpdatePDPContextRequest_template;
    precondition->set_param(*m_p->get_elem(0));
    UpdatePDPContextRequest_template* implied_template = new UpdatePDPContextRequest_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = UpdatePDPContextRequest_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@GTPC_Types.UpdatePDPContextRequest");
  }
  is_ifpresent = param.get_ifpresent();
}

void UpdatePDPContextRequest_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case UpdatePDPContextRequest::ALT_updatePDPContextRequestSGSN:
single_value.field_updatePDPContextRequestSGSN->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequest");
return;
case UpdatePDPContextRequest::ALT_updatePDPContextRequestGGSN:
single_value.field_updatePDPContextRequestGGSN->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequest");
return;
case UpdatePDPContextRequest::ALT_updatePDPContextRequestCGW:
single_value.field_updatePDPContextRequestCGW->check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequest");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @GTPC_Types.UpdatePDPContextRequest.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequest");
}

UpdatePDPContextRequestSGSN::UpdatePDPContextRequestSGSN()
{
}

UpdatePDPContextRequestSGSN::UpdatePDPContextRequestSGSN(const OPTIONAL< IMSI__gtpc >& par_imsi,
    const OPTIONAL< RoutingAreaIdentity >& par_rai,
    const OPTIONAL< Recovery__gtpc >& par_recovery,
    const TeidDataI& par_teidDataI,
    const OPTIONAL< TeidControlPlane >& par_teidControlPlane,
    const NSAPI__GTPC& par_nsapi,
    const OPTIONAL< TraceRef >& par_trace__ref,
    const OPTIONAL< GTP__TraceType >& par_trace__type,
    const OPTIONAL< ProtConfigOptions >& par_protConfigOptions,
    const GSN__Address__GTPC& par_sgsn__addr__controlPlane,
    const GSN__Address__GTPC& par_sgsn__addr__traffic,
    const OPTIONAL< GSN__Address__GTPC >& par_alt__ggsn__addr__controlPane,
    const OPTIONAL< GSN__Address__GTPC >& par_alt__ggsn__addr__traffic,
    const QualityOfServiceProfile& par_qualityOfServiceProfile,
    const OPTIONAL< TrafficFlowTemplate >& par_tft,
    const OPTIONAL< GTP__TriggerID >& par_triggerId,
    const OPTIONAL< OMCIdentity >& par_omcId,
    const OPTIONAL< CommonFlags >& par_commonFlags,
    const OPTIONAL< RATType >& par_ratType,
    const OPTIONAL< UserLocationInformation >& par_userLocationInformation,
    const OPTIONAL< MS__TimeZone >& par_mS__TimeZone,
    const OPTIONAL< AdditionalTraceInfo >& par_additionalTraceInfo,
    const OPTIONAL< DirectTunnelFlags >& par_directTunnelFlags,
    const OPTIONAL< EvolvedAllocationRetentionPriorityI >& par_evolvedAllocationRetentionPriorityI,
    const OPTIONAL< ExtendedCommonFlags >& par_extendedCommonFlags,
    const OPTIONAL< UserCSGInformation >& par_userCSGInformation,
    const OPTIONAL< APN__AMBR >& par_aPN__AMBR,
    const OPTIONAL< SignallingPriorityIndication >& par_signallingPriorityIndication,
    const OPTIONAL< CN__OperatorSelectionEntity >& par_cN__OperatorSelectionEntity,
    const OPTIONAL< PrivateExtension__gtpc__List >& par_private__extension__gtpc)
  :   field_imsi(par_imsi),
  field_rai(par_rai),
  field_recovery(par_recovery),
  field_teidDataI(par_teidDataI),
  field_teidControlPlane(par_teidControlPlane),
  field_nsapi(par_nsapi),
  field_trace__ref(par_trace__ref),
  field_trace__type(par_trace__type),
  field_protConfigOptions(par_protConfigOptions),
  field_sgsn__addr__controlPlane(par_sgsn__addr__controlPlane),
  field_sgsn__addr__traffic(par_sgsn__addr__traffic),
  field_alt__ggsn__addr__controlPane(par_alt__ggsn__addr__controlPane),
  field_alt__ggsn__addr__traffic(par_alt__ggsn__addr__traffic),
  field_qualityOfServiceProfile(par_qualityOfServiceProfile),
  field_tft(par_tft),
  field_triggerId(par_triggerId),
  field_omcId(par_omcId),
  field_commonFlags(par_commonFlags),
  field_ratType(par_ratType),
  field_userLocationInformation(par_userLocationInformation),
  field_mS__TimeZone(par_mS__TimeZone),
  field_additionalTraceInfo(par_additionalTraceInfo),
  field_directTunnelFlags(par_directTunnelFlags),
  field_evolvedAllocationRetentionPriorityI(par_evolvedAllocationRetentionPriorityI),
  field_extendedCommonFlags(par_extendedCommonFlags),
  field_userCSGInformation(par_userCSGInformation),
  field_aPN__AMBR(par_aPN__AMBR),
  field_signallingPriorityIndication(par_signallingPriorityIndication),
  field_cN__OperatorSelectionEntity(par_cN__OperatorSelectionEntity),
  field_private__extension__gtpc(par_private__extension__gtpc)
{
}

UpdatePDPContextRequestSGSN::UpdatePDPContextRequestSGSN(const UpdatePDPContextRequestSGSN& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
else field_imsi.clean_up();
if (other_value.rai().is_bound()) field_rai = other_value.rai();
else field_rai.clean_up();
if (other_value.recovery().is_bound()) field_recovery = other_value.recovery();
else field_recovery.clean_up();
if (other_value.teidDataI().is_bound()) field_teidDataI = other_value.teidDataI();
else field_teidDataI.clean_up();
if (other_value.teidControlPlane().is_bound()) field_teidControlPlane = other_value.teidControlPlane();
else field_teidControlPlane.clean_up();
if (other_value.nsapi().is_bound()) field_nsapi = other_value.nsapi();
else field_nsapi.clean_up();
if (other_value.trace__ref().is_bound()) field_trace__ref = other_value.trace__ref();
else field_trace__ref.clean_up();
if (other_value.trace__type().is_bound()) field_trace__type = other_value.trace__type();
else field_trace__type.clean_up();
if (other_value.protConfigOptions().is_bound()) field_protConfigOptions = other_value.protConfigOptions();
else field_protConfigOptions.clean_up();
if (other_value.sgsn__addr__controlPlane().is_bound()) field_sgsn__addr__controlPlane = other_value.sgsn__addr__controlPlane();
else field_sgsn__addr__controlPlane.clean_up();
if (other_value.sgsn__addr__traffic().is_bound()) field_sgsn__addr__traffic = other_value.sgsn__addr__traffic();
else field_sgsn__addr__traffic.clean_up();
if (other_value.alt__ggsn__addr__controlPane().is_bound()) field_alt__ggsn__addr__controlPane = other_value.alt__ggsn__addr__controlPane();
else field_alt__ggsn__addr__controlPane.clean_up();
if (other_value.alt__ggsn__addr__traffic().is_bound()) field_alt__ggsn__addr__traffic = other_value.alt__ggsn__addr__traffic();
else field_alt__ggsn__addr__traffic.clean_up();
if (other_value.qualityOfServiceProfile().is_bound()) field_qualityOfServiceProfile = other_value.qualityOfServiceProfile();
else field_qualityOfServiceProfile.clean_up();
if (other_value.tft().is_bound()) field_tft = other_value.tft();
else field_tft.clean_up();
if (other_value.triggerId().is_bound()) field_triggerId = other_value.triggerId();
else field_triggerId.clean_up();
if (other_value.omcId().is_bound()) field_omcId = other_value.omcId();
else field_omcId.clean_up();
if (other_value.commonFlags().is_bound()) field_commonFlags = other_value.commonFlags();
else field_commonFlags.clean_up();
if (other_value.ratType().is_bound()) field_ratType = other_value.ratType();
else field_ratType.clean_up();
if (other_value.userLocationInformation().is_bound()) field_userLocationInformation = other_value.userLocationInformation();
else field_userLocationInformation.clean_up();
if (other_value.mS__TimeZone().is_bound()) field_mS__TimeZone = other_value.mS__TimeZone();
else field_mS__TimeZone.clean_up();
if (other_value.additionalTraceInfo().is_bound()) field_additionalTraceInfo = other_value.additionalTraceInfo();
else field_additionalTraceInfo.clean_up();
if (other_value.directTunnelFlags().is_bound()) field_directTunnelFlags = other_value.directTunnelFlags();
else field_directTunnelFlags.clean_up();
if (other_value.evolvedAllocationRetentionPriorityI().is_bound()) field_evolvedAllocationRetentionPriorityI = other_value.evolvedAllocationRetentionPriorityI();
else field_evolvedAllocationRetentionPriorityI.clean_up();
if (other_value.extendedCommonFlags().is_bound()) field_extendedCommonFlags = other_value.extendedCommonFlags();
else field_extendedCommonFlags.clean_up();
if (other_value.userCSGInformation().is_bound()) field_userCSGInformation = other_value.userCSGInformation();
else field_userCSGInformation.clean_up();
if (other_value.aPN__AMBR().is_bound()) field_aPN__AMBR = other_value.aPN__AMBR();
else field_aPN__AMBR.clean_up();
if (other_value.signallingPriorityIndication().is_bound()) field_signallingPriorityIndication = other_value.signallingPriorityIndication();
else field_signallingPriorityIndication.clean_up();
if (other_value.cN__OperatorSelectionEntity().is_bound()) field_cN__OperatorSelectionEntity = other_value.cN__OperatorSelectionEntity();
else field_cN__OperatorSelectionEntity.clean_up();
if (other_value.private__extension__gtpc().is_bound()) field_private__extension__gtpc = other_value.private__extension__gtpc();
else field_private__extension__gtpc.clean_up();
}

void UpdatePDPContextRequestSGSN::clean_up()
{
field_imsi.clean_up();
field_rai.clean_up();
field_recovery.clean_up();
field_teidDataI.clean_up();
field_teidControlPlane.clean_up();
field_nsapi.clean_up();
field_trace__ref.clean_up();
field_trace__type.clean_up();
field_protConfigOptions.clean_up();
field_sgsn__addr__controlPlane.clean_up();
field_sgsn__addr__traffic.clean_up();
field_alt__ggsn__addr__controlPane.clean_up();
field_alt__ggsn__addr__traffic.clean_up();
field_qualityOfServiceProfile.clean_up();
field_tft.clean_up();
field_triggerId.clean_up();
field_omcId.clean_up();
field_commonFlags.clean_up();
field_ratType.clean_up();
field_userLocationInformation.clean_up();
field_mS__TimeZone.clean_up();
field_additionalTraceInfo.clean_up();
field_directTunnelFlags.clean_up();
field_evolvedAllocationRetentionPriorityI.clean_up();
field_extendedCommonFlags.clean_up();
field_userCSGInformation.clean_up();
field_aPN__AMBR.clean_up();
field_signallingPriorityIndication.clean_up();
field_cN__OperatorSelectionEntity.clean_up();
field_private__extension__gtpc.clean_up();
}

const TTCN_Typedescriptor_t* UpdatePDPContextRequestSGSN::get_descriptor() const { return &UpdatePDPContextRequestSGSN_descr_; }
UpdatePDPContextRequestSGSN& UpdatePDPContextRequestSGSN::operator=(const UpdatePDPContextRequestSGSN& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
  if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
  else field_imsi.clean_up();
  if (other_value.rai().is_bound()) field_rai = other_value.rai();
  else field_rai.clean_up();
  if (other_value.recovery().is_bound()) field_recovery = other_value.recovery();
  else field_recovery.clean_up();
  if (other_value.teidDataI().is_bound()) field_teidDataI = other_value.teidDataI();
  else field_teidDataI.clean_up();
  if (other_value.teidControlPlane().is_bound()) field_teidControlPlane = other_value.teidControlPlane();
  else field_teidControlPlane.clean_up();
  if (other_value.nsapi().is_bound()) field_nsapi = other_value.nsapi();
  else field_nsapi.clean_up();
  if (other_value.trace__ref().is_bound()) field_trace__ref = other_value.trace__ref();
  else field_trace__ref.clean_up();
  if (other_value.trace__type().is_bound()) field_trace__type = other_value.trace__type();
  else field_trace__type.clean_up();
  if (other_value.protConfigOptions().is_bound()) field_protConfigOptions = other_value.protConfigOptions();
  else field_protConfigOptions.clean_up();
  if (other_value.sgsn__addr__controlPlane().is_bound()) field_sgsn__addr__controlPlane = other_value.sgsn__addr__controlPlane();
  else field_sgsn__addr__controlPlane.clean_up();
  if (other_value.sgsn__addr__traffic().is_bound()) field_sgsn__addr__traffic = other_value.sgsn__addr__traffic();
  else field_sgsn__addr__traffic.clean_up();
  if (other_value.alt__ggsn__addr__controlPane().is_bound()) field_alt__ggsn__addr__controlPane = other_value.alt__ggsn__addr__controlPane();
  else field_alt__ggsn__addr__controlPane.clean_up();
  if (other_value.alt__ggsn__addr__traffic().is_bound()) field_alt__ggsn__addr__traffic = other_value.alt__ggsn__addr__traffic();
  else field_alt__ggsn__addr__traffic.clean_up();
  if (other_value.qualityOfServiceProfile().is_bound()) field_qualityOfServiceProfile = other_value.qualityOfServiceProfile();
  else field_qualityOfServiceProfile.clean_up();
  if (other_value.tft().is_bound()) field_tft = other_value.tft();
  else field_tft.clean_up();
  if (other_value.triggerId().is_bound()) field_triggerId = other_value.triggerId();
  else field_triggerId.clean_up();
  if (other_value.omcId().is_bound()) field_omcId = other_value.omcId();
  else field_omcId.clean_up();
  if (other_value.commonFlags().is_bound()) field_commonFlags = other_value.commonFlags();
  else field_commonFlags.clean_up();
  if (other_value.ratType().is_bound()) field_ratType = other_value.ratType();
  else field_ratType.clean_up();
  if (other_value.userLocationInformation().is_bound()) field_userLocationInformation = other_value.userLocationInformation();
  else field_userLocationInformation.clean_up();
  if (other_value.mS__TimeZone().is_bound()) field_mS__TimeZone = other_value.mS__TimeZone();
  else field_mS__TimeZone.clean_up();
  if (other_value.additionalTraceInfo().is_bound()) field_additionalTraceInfo = other_value.additionalTraceInfo();
  else field_additionalTraceInfo.clean_up();
  if (other_value.directTunnelFlags().is_bound()) field_directTunnelFlags = other_value.directTunnelFlags();
  else field_directTunnelFlags.clean_up();
  if (other_value.evolvedAllocationRetentionPriorityI().is_bound()) field_evolvedAllocationRetentionPriorityI = other_value.evolvedAllocationRetentionPriorityI();
  else field_evolvedAllocationRetentionPriorityI.clean_up();
  if (other_value.extendedCommonFlags().is_bound()) field_extendedCommonFlags = other_value.extendedCommonFlags();
  else field_extendedCommonFlags.clean_up();
  if (other_value.userCSGInformation().is_bound()) field_userCSGInformation = other_value.userCSGInformation();
  else field_userCSGInformation.clean_up();
  if (other_value.aPN__AMBR().is_bound()) field_aPN__AMBR = other_value.aPN__AMBR();
  else field_aPN__AMBR.clean_up();
  if (other_value.signallingPriorityIndication().is_bound()) field_signallingPriorityIndication = other_value.signallingPriorityIndication();
  else field_signallingPriorityIndication.clean_up();
  if (other_value.cN__OperatorSelectionEntity().is_bound()) field_cN__OperatorSelectionEntity = other_value.cN__OperatorSelectionEntity();
  else field_cN__OperatorSelectionEntity.clean_up();
  if (other_value.private__extension__gtpc().is_bound()) field_private__extension__gtpc = other_value.private__extension__gtpc();
  else field_private__extension__gtpc.clean_up();
}
return *this;
}

boolean UpdatePDPContextRequestSGSN::operator==(const UpdatePDPContextRequestSGSN& other_value) const
{
return field_imsi==other_value.field_imsi
  && field_rai==other_value.field_rai
  && field_recovery==other_value.field_recovery
  && field_teidDataI==other_value.field_teidDataI
  && field_teidControlPlane==other_value.field_teidControlPlane
  && field_nsapi==other_value.field_nsapi
  && field_trace__ref==other_value.field_trace__ref
  && field_trace__type==other_value.field_trace__type
  && field_protConfigOptions==other_value.field_protConfigOptions
  && field_sgsn__addr__controlPlane==other_value.field_sgsn__addr__controlPlane
  && field_sgsn__addr__traffic==other_value.field_sgsn__addr__traffic
  && field_alt__ggsn__addr__controlPane==other_value.field_alt__ggsn__addr__controlPane
  && field_alt__ggsn__addr__traffic==other_value.field_alt__ggsn__addr__traffic
  && field_qualityOfServiceProfile==other_value.field_qualityOfServiceProfile
  && field_tft==other_value.field_tft
  && field_triggerId==other_value.field_triggerId
  && field_omcId==other_value.field_omcId
  && field_commonFlags==other_value.field_commonFlags
  && field_ratType==other_value.field_ratType
  && field_userLocationInformation==other_value.field_userLocationInformation
  && field_mS__TimeZone==other_value.field_mS__TimeZone
  && field_additionalTraceInfo==other_value.field_additionalTraceInfo
  && field_directTunnelFlags==other_value.field_directTunnelFlags
  && field_evolvedAllocationRetentionPriorityI==other_value.field_evolvedAllocationRetentionPriorityI
  && field_extendedCommonFlags==other_value.field_extendedCommonFlags
  && field_userCSGInformation==other_value.field_userCSGInformation
  && field_aPN__AMBR==other_value.field_aPN__AMBR
  && field_signallingPriorityIndication==other_value.field_signallingPriorityIndication
  && field_cN__OperatorSelectionEntity==other_value.field_cN__OperatorSelectionEntity
  && field_private__extension__gtpc==other_value.field_private__extension__gtpc;
}

boolean UpdatePDPContextRequestSGSN::is_bound() const
{
return (OPTIONAL_OMIT == field_imsi.get_selection() || field_imsi.is_bound())
  || (OPTIONAL_OMIT == field_rai.get_selection() || field_rai.is_bound())
  || (OPTIONAL_OMIT == field_recovery.get_selection() || field_recovery.is_bound())
  || (field_teidDataI.is_bound())
  || (OPTIONAL_OMIT == field_teidControlPlane.get_selection() || field_teidControlPlane.is_bound())
  || (field_nsapi.is_bound())
  || (OPTIONAL_OMIT == field_trace__ref.get_selection() || field_trace__ref.is_bound())
  || (OPTIONAL_OMIT == field_trace__type.get_selection() || field_trace__type.is_bound())
  || (OPTIONAL_OMIT == field_protConfigOptions.get_selection() || field_protConfigOptions.is_bound())
  || (field_sgsn__addr__controlPlane.is_bound())
  || (field_sgsn__addr__traffic.is_bound())
  || (OPTIONAL_OMIT == field_alt__ggsn__addr__controlPane.get_selection() || field_alt__ggsn__addr__controlPane.is_bound())
  || (OPTIONAL_OMIT == field_alt__ggsn__addr__traffic.get_selection() || field_alt__ggsn__addr__traffic.is_bound())
  || (field_qualityOfServiceProfile.is_bound())
  || (OPTIONAL_OMIT == field_tft.get_selection() || field_tft.is_bound())
  || (OPTIONAL_OMIT == field_triggerId.get_selection() || field_triggerId.is_bound())
  || (OPTIONAL_OMIT == field_omcId.get_selection() || field_omcId.is_bound())
  || (OPTIONAL_OMIT == field_commonFlags.get_selection() || field_commonFlags.is_bound())
  || (OPTIONAL_OMIT == field_ratType.get_selection() || field_ratType.is_bound())
  || (OPTIONAL_OMIT == field_userLocationInformation.get_selection() || field_userLocationInformation.is_bound())
  || (OPTIONAL_OMIT == field_mS__TimeZone.get_selection() || field_mS__TimeZone.is_bound())
  || (OPTIONAL_OMIT == field_additionalTraceInfo.get_selection() || field_additionalTraceInfo.is_bound())
  || (OPTIONAL_OMIT == field_directTunnelFlags.get_selection() || field_directTunnelFlags.is_bound())
  || (OPTIONAL_OMIT == field_evolvedAllocationRetentionPriorityI.get_selection() || field_evolvedAllocationRetentionPriorityI.is_bound())
  || (OPTIONAL_OMIT == field_extendedCommonFlags.get_selection() || field_extendedCommonFlags.is_bound())
  || (OPTIONAL_OMIT == field_userCSGInformation.get_selection() || field_userCSGInformation.is_bound())
  || (OPTIONAL_OMIT == field_aPN__AMBR.get_selection() || field_aPN__AMBR.is_bound())
  || (OPTIONAL_OMIT == field_signallingPriorityIndication.get_selection() || field_signallingPriorityIndication.is_bound())
  || (OPTIONAL_OMIT == field_cN__OperatorSelectionEntity.get_selection() || field_cN__OperatorSelectionEntity.is_bound())
  || (OPTIONAL_OMIT == field_private__extension__gtpc.get_selection() || field_private__extension__gtpc.is_bound());
}
boolean UpdatePDPContextRequestSGSN::is_value() const
{
return (OPTIONAL_OMIT == field_imsi.get_selection() || field_imsi.is_value())
  && (OPTIONAL_OMIT == field_rai.get_selection() || field_rai.is_value())
  && (OPTIONAL_OMIT == field_recovery.get_selection() || field_recovery.is_value())
  && field_teidDataI.is_value()
  && (OPTIONAL_OMIT == field_teidControlPlane.get_selection() || field_teidControlPlane.is_value())
  && field_nsapi.is_value()
  && (OPTIONAL_OMIT == field_trace__ref.get_selection() || field_trace__ref.is_value())
  && (OPTIONAL_OMIT == field_trace__type.get_selection() || field_trace__type.is_value())
  && (OPTIONAL_OMIT == field_protConfigOptions.get_selection() || field_protConfigOptions.is_value())
  && field_sgsn__addr__controlPlane.is_value()
  && field_sgsn__addr__traffic.is_value()
  && (OPTIONAL_OMIT == field_alt__ggsn__addr__controlPane.get_selection() || field_alt__ggsn__addr__controlPane.is_value())
  && (OPTIONAL_OMIT == field_alt__ggsn__addr__traffic.get_selection() || field_alt__ggsn__addr__traffic.is_value())
  && field_qualityOfServiceProfile.is_value()
  && (OPTIONAL_OMIT == field_tft.get_selection() || field_tft.is_value())
  && (OPTIONAL_OMIT == field_triggerId.get_selection() || field_triggerId.is_value())
  && (OPTIONAL_OMIT == field_omcId.get_selection() || field_omcId.is_value())
  && (OPTIONAL_OMIT == field_commonFlags.get_selection() || field_commonFlags.is_value())
  && (OPTIONAL_OMIT == field_ratType.get_selection() || field_ratType.is_value())
  && (OPTIONAL_OMIT == field_userLocationInformation.get_selection() || field_userLocationInformation.is_value())
  && (OPTIONAL_OMIT == field_mS__TimeZone.get_selection() || field_mS__TimeZone.is_value())
  && (OPTIONAL_OMIT == field_additionalTraceInfo.get_selection() || field_additionalTraceInfo.is_value())
  && (OPTIONAL_OMIT == field_directTunnelFlags.get_selection() || field_directTunnelFlags.is_value())
  && (OPTIONAL_OMIT == field_evolvedAllocationRetentionPriorityI.get_selection() || field_evolvedAllocationRetentionPriorityI.is_value())
  && (OPTIONAL_OMIT == field_extendedCommonFlags.get_selection() || field_extendedCommonFlags.is_value())
  && (OPTIONAL_OMIT == field_userCSGInformation.get_selection() || field_userCSGInformation.is_value())
  && (OPTIONAL_OMIT == field_aPN__AMBR.get_selection() || field_aPN__AMBR.is_value())
  && (OPTIONAL_OMIT == field_signallingPriorityIndication.get_selection() || field_signallingPriorityIndication.is_value())
  && (OPTIONAL_OMIT == field_cN__OperatorSelectionEntity.get_selection() || field_cN__OperatorSelectionEntity.is_value())
  && (OPTIONAL_OMIT == field_private__extension__gtpc.get_selection() || field_private__extension__gtpc.is_value());
}
int UpdatePDPContextRequestSGSN::size_of() const
{
  int ret_val = 5;
  if (field_imsi.ispresent()) ret_val++;
  if (field_rai.ispresent()) ret_val++;
  if (field_recovery.ispresent()) ret_val++;
  if (field_teidControlPlane.ispresent()) ret_val++;
  if (field_trace__ref.ispresent()) ret_val++;
  if (field_trace__type.ispresent()) ret_val++;
  if (field_protConfigOptions.ispresent()) ret_val++;
  if (field_alt__ggsn__addr__controlPane.ispresent()) ret_val++;
  if (field_alt__ggsn__addr__traffic.ispresent()) ret_val++;
  if (field_tft.ispresent()) ret_val++;
  if (field_triggerId.ispresent()) ret_val++;
  if (field_omcId.ispresent()) ret_val++;
  if (field_commonFlags.ispresent()) ret_val++;
  if (field_ratType.ispresent()) ret_val++;
  if (field_userLocationInformation.ispresent()) ret_val++;
  if (field_mS__TimeZone.ispresent()) ret_val++;
  if (field_additionalTraceInfo.ispresent()) ret_val++;
  if (field_directTunnelFlags.ispresent()) ret_val++;
  if (field_evolvedAllocationRetentionPriorityI.ispresent()) ret_val++;
  if (field_extendedCommonFlags.ispresent()) ret_val++;
  if (field_userCSGInformation.ispresent()) ret_val++;
  if (field_aPN__AMBR.ispresent()) ret_val++;
  if (field_signallingPriorityIndication.ispresent()) ret_val++;
  if (field_cN__OperatorSelectionEntity.ispresent()) ret_val++;
  if (field_private__extension__gtpc.ispresent()) ret_val++;
  return ret_val;
}

void UpdatePDPContextRequestSGSN::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ imsi := ");
field_imsi.log();
TTCN_Logger::log_event_str(", rai := ");
field_rai.log();
TTCN_Logger::log_event_str(", recovery := ");
field_recovery.log();
TTCN_Logger::log_event_str(", teidDataI := ");
field_teidDataI.log();
TTCN_Logger::log_event_str(", teidControlPlane := ");
field_teidControlPlane.log();
TTCN_Logger::log_event_str(", nsapi := ");
field_nsapi.log();
TTCN_Logger::log_event_str(", trace_ref := ");
field_trace__ref.log();
TTCN_Logger::log_event_str(", trace_type := ");
field_trace__type.log();
TTCN_Logger::log_event_str(", protConfigOptions := ");
field_protConfigOptions.log();
TTCN_Logger::log_event_str(", sgsn_addr_controlPlane := ");
field_sgsn__addr__controlPlane.log();
TTCN_Logger::log_event_str(", sgsn_addr_traffic := ");
field_sgsn__addr__traffic.log();
TTCN_Logger::log_event_str(", alt_ggsn_addr_controlPane := ");
field_alt__ggsn__addr__controlPane.log();
TTCN_Logger::log_event_str(", alt_ggsn_addr_traffic := ");
field_alt__ggsn__addr__traffic.log();
TTCN_Logger::log_event_str(", qualityOfServiceProfile := ");
field_qualityOfServiceProfile.log();
TTCN_Logger::log_event_str(", tft := ");
field_tft.log();
TTCN_Logger::log_event_str(", triggerId := ");
field_triggerId.log();
TTCN_Logger::log_event_str(", omcId := ");
field_omcId.log();
TTCN_Logger::log_event_str(", commonFlags := ");
field_commonFlags.log();
TTCN_Logger::log_event_str(", ratType := ");
field_ratType.log();
TTCN_Logger::log_event_str(", userLocationInformation := ");
field_userLocationInformation.log();
TTCN_Logger::log_event_str(", mS_TimeZone := ");
field_mS__TimeZone.log();
TTCN_Logger::log_event_str(", additionalTraceInfo := ");
field_additionalTraceInfo.log();
TTCN_Logger::log_event_str(", directTunnelFlags := ");
field_directTunnelFlags.log();
TTCN_Logger::log_event_str(", evolvedAllocationRetentionPriorityI := ");
field_evolvedAllocationRetentionPriorityI.log();
TTCN_Logger::log_event_str(", extendedCommonFlags := ");
field_extendedCommonFlags.log();
TTCN_Logger::log_event_str(", userCSGInformation := ");
field_userCSGInformation.log();
TTCN_Logger::log_event_str(", aPN_AMBR := ");
field_aPN__AMBR.log();
TTCN_Logger::log_event_str(", signallingPriorityIndication := ");
field_signallingPriorityIndication.log();
TTCN_Logger::log_event_str(", cN_OperatorSelectionEntity := ");
field_cN__OperatorSelectionEntity.log();
TTCN_Logger::log_event_str(", private_extension_gtpc := ");
field_private__extension__gtpc.log();
TTCN_Logger::log_event_str(" }");
}

void UpdatePDPContextRequestSGSN::set_implicit_omit()
{
if (!imsi().is_bound()) imsi() = OMIT_VALUE;
else imsi().set_implicit_omit();
if (!rai().is_bound()) rai() = OMIT_VALUE;
else rai().set_implicit_omit();
if (!recovery().is_bound()) recovery() = OMIT_VALUE;
else recovery().set_implicit_omit();
if (teidDataI().is_bound()) teidDataI().set_implicit_omit();
if (!teidControlPlane().is_bound()) teidControlPlane() = OMIT_VALUE;
else teidControlPlane().set_implicit_omit();
if (nsapi().is_bound()) nsapi().set_implicit_omit();
if (!trace__ref().is_bound()) trace__ref() = OMIT_VALUE;
else trace__ref().set_implicit_omit();
if (!trace__type().is_bound()) trace__type() = OMIT_VALUE;
else trace__type().set_implicit_omit();
if (!protConfigOptions().is_bound()) protConfigOptions() = OMIT_VALUE;
else protConfigOptions().set_implicit_omit();
if (sgsn__addr__controlPlane().is_bound()) sgsn__addr__controlPlane().set_implicit_omit();
if (sgsn__addr__traffic().is_bound()) sgsn__addr__traffic().set_implicit_omit();
if (!alt__ggsn__addr__controlPane().is_bound()) alt__ggsn__addr__controlPane() = OMIT_VALUE;
else alt__ggsn__addr__controlPane().set_implicit_omit();
if (!alt__ggsn__addr__traffic().is_bound()) alt__ggsn__addr__traffic() = OMIT_VALUE;
else alt__ggsn__addr__traffic().set_implicit_omit();
if (qualityOfServiceProfile().is_bound()) qualityOfServiceProfile().set_implicit_omit();
if (!tft().is_bound()) tft() = OMIT_VALUE;
else tft().set_implicit_omit();
if (!triggerId().is_bound()) triggerId() = OMIT_VALUE;
else triggerId().set_implicit_omit();
if (!omcId().is_bound()) omcId() = OMIT_VALUE;
else omcId().set_implicit_omit();
if (!commonFlags().is_bound()) commonFlags() = OMIT_VALUE;
else commonFlags().set_implicit_omit();
if (!ratType().is_bound()) ratType() = OMIT_VALUE;
else ratType().set_implicit_omit();
if (!userLocationInformation().is_bound()) userLocationInformation() = OMIT_VALUE;
else userLocationInformation().set_implicit_omit();
if (!mS__TimeZone().is_bound()) mS__TimeZone() = OMIT_VALUE;
else mS__TimeZone().set_implicit_omit();
if (!additionalTraceInfo().is_bound()) additionalTraceInfo() = OMIT_VALUE;
else additionalTraceInfo().set_implicit_omit();
if (!directTunnelFlags().is_bound()) directTunnelFlags() = OMIT_VALUE;
else directTunnelFlags().set_implicit_omit();
if (!evolvedAllocationRetentionPriorityI().is_bound()) evolvedAllocationRetentionPriorityI() = OMIT_VALUE;
else evolvedAllocationRetentionPriorityI().set_implicit_omit();
if (!extendedCommonFlags().is_bound()) extendedCommonFlags() = OMIT_VALUE;
else extendedCommonFlags().set_implicit_omit();
if (!userCSGInformation().is_bound()) userCSGInformation() = OMIT_VALUE;
else userCSGInformation().set_implicit_omit();
if (!aPN__AMBR().is_bound()) aPN__AMBR() = OMIT_VALUE;
else aPN__AMBR().set_implicit_omit();
if (!signallingPriorityIndication().is_bound()) signallingPriorityIndication() = OMIT_VALUE;
else signallingPriorityIndication().set_implicit_omit();
if (!cN__OperatorSelectionEntity().is_bound()) cN__OperatorSelectionEntity() = OMIT_VALUE;
else cN__OperatorSelectionEntity().set_implicit_omit();
if (!private__extension__gtpc().is_bound()) private__extension__gtpc() = OMIT_VALUE;
else private__extension__gtpc().set_implicit_omit();
}

void UpdatePDPContextRequestSGSN::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (30<param.get_size()) {
      param.error("record value of type @GTPC_Types.UpdatePDPContextRequestSGSN has 30 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) imsi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) rai().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) recovery().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) teidDataI().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) teidControlPlane().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) nsapi().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) trace__ref().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) trace__type().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) protConfigOptions().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) sgsn__addr__controlPlane().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) sgsn__addr__traffic().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) alt__ggsn__addr__controlPane().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) alt__ggsn__addr__traffic().set_param(*param.get_elem(12));
    if (param.get_size()>13 && param.get_elem(13)->get_type()!=Module_Param::MP_NotUsed) qualityOfServiceProfile().set_param(*param.get_elem(13));
    if (param.get_size()>14 && param.get_elem(14)->get_type()!=Module_Param::MP_NotUsed) tft().set_param(*param.get_elem(14));
    if (param.get_size()>15 && param.get_elem(15)->get_type()!=Module_Param::MP_NotUsed) triggerId().set_param(*param.get_elem(15));
    if (param.get_size()>16 && param.get_elem(16)->get_type()!=Module_Param::MP_NotUsed) omcId().set_param(*param.get_elem(16));
    if (param.get_size()>17 && param.get_elem(17)->get_type()!=Module_Param::MP_NotUsed) commonFlags().set_param(*param.get_elem(17));
    if (param.get_size()>18 && param.get_elem(18)->get_type()!=Module_Param::MP_NotUsed) ratType().set_param(*param.get_elem(18));
    if (param.get_size()>19 && param.get_elem(19)->get_type()!=Module_Param::MP_NotUsed) userLocationInformation().set_param(*param.get_elem(19));
    if (param.get_size()>20 && param.get_elem(20)->get_type()!=Module_Param::MP_NotUsed) mS__TimeZone().set_param(*param.get_elem(20));
    if (param.get_size()>21 && param.get_elem(21)->get_type()!=Module_Param::MP_NotUsed) additionalTraceInfo().set_param(*param.get_elem(21));
    if (param.get_size()>22 && param.get_elem(22)->get_type()!=Module_Param::MP_NotUsed) directTunnelFlags().set_param(*param.get_elem(22));
    if (param.get_size()>23 && param.get_elem(23)->get_type()!=Module_Param::MP_NotUsed) evolvedAllocationRetentionPriorityI().set_param(*param.get_elem(23));
    if (param.get_size()>24 && param.get_elem(24)->get_type()!=Module_Param::MP_NotUsed) extendedCommonFlags().set_param(*param.get_elem(24));
    if (param.get_size()>25 && param.get_elem(25)->get_type()!=Module_Param::MP_NotUsed) userCSGInformation().set_param(*param.get_elem(25));
    if (param.get_size()>26 && param.get_elem(26)->get_type()!=Module_Param::MP_NotUsed) aPN__AMBR().set_param(*param.get_elem(26));
    if (param.get_size()>27 && param.get_elem(27)->get_type()!=Module_Param::MP_NotUsed) signallingPriorityIndication().set_param(*param.get_elem(27));
    if (param.get_size()>28 && param.get_elem(28)->get_type()!=Module_Param::MP_NotUsed) cN__OperatorSelectionEntity().set_param(*param.get_elem(28));
    if (param.get_size()>29 && param.get_elem(29)->get_type()!=Module_Param::MP_NotUsed) private__extension__gtpc().set_param(*param.get_elem(29));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rai")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rai().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "recovery")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          recovery().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "teidDataI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          teidDataI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "teidControlPlane")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          teidControlPlane().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsapi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsapi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "trace_ref")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          trace__ref().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "trace_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          trace__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protConfigOptions")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protConfigOptions().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sgsn_addr_controlPlane")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sgsn__addr__controlPlane().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sgsn_addr_traffic")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sgsn__addr__traffic().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "alt_ggsn_addr_controlPane")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          alt__ggsn__addr__controlPane().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "alt_ggsn_addr_traffic")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          alt__ggsn__addr__traffic().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "qualityOfServiceProfile")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          qualityOfServiceProfile().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tft")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tft().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "triggerId")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          triggerId().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "omcId")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          omcId().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "commonFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          commonFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ratType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ratType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "userLocationInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          userLocationInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mS_TimeZone")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mS__TimeZone().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "additionalTraceInfo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          additionalTraceInfo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "directTunnelFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          directTunnelFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "evolvedAllocationRetentionPriorityI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          evolvedAllocationRetentionPriorityI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extendedCommonFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extendedCommonFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "userCSGInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          userCSGInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aPN_AMBR")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aPN__AMBR().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "signallingPriorityIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          signallingPriorityIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cN_OperatorSelectionEntity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cN__OperatorSelectionEntity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "private_extension_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          private__extension__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.UpdatePDPContextRequestSGSN: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.UpdatePDPContextRequestSGSN");
  }
}

void UpdatePDPContextRequestSGSN::encode_text(Text_Buf& text_buf) const
{
field_imsi.encode_text(text_buf);
field_rai.encode_text(text_buf);
field_recovery.encode_text(text_buf);
field_teidDataI.encode_text(text_buf);
field_teidControlPlane.encode_text(text_buf);
field_nsapi.encode_text(text_buf);
field_trace__ref.encode_text(text_buf);
field_trace__type.encode_text(text_buf);
field_protConfigOptions.encode_text(text_buf);
field_sgsn__addr__controlPlane.encode_text(text_buf);
field_sgsn__addr__traffic.encode_text(text_buf);
field_alt__ggsn__addr__controlPane.encode_text(text_buf);
field_alt__ggsn__addr__traffic.encode_text(text_buf);
field_qualityOfServiceProfile.encode_text(text_buf);
field_tft.encode_text(text_buf);
field_triggerId.encode_text(text_buf);
field_omcId.encode_text(text_buf);
field_commonFlags.encode_text(text_buf);
field_ratType.encode_text(text_buf);
field_userLocationInformation.encode_text(text_buf);
field_mS__TimeZone.encode_text(text_buf);
field_additionalTraceInfo.encode_text(text_buf);
field_directTunnelFlags.encode_text(text_buf);
field_evolvedAllocationRetentionPriorityI.encode_text(text_buf);
field_extendedCommonFlags.encode_text(text_buf);
field_userCSGInformation.encode_text(text_buf);
field_aPN__AMBR.encode_text(text_buf);
field_signallingPriorityIndication.encode_text(text_buf);
field_cN__OperatorSelectionEntity.encode_text(text_buf);
field_private__extension__gtpc.encode_text(text_buf);
}

void UpdatePDPContextRequestSGSN::decode_text(Text_Buf& text_buf)
{
field_imsi.decode_text(text_buf);
field_rai.decode_text(text_buf);
field_recovery.decode_text(text_buf);
field_teidDataI.decode_text(text_buf);
field_teidControlPlane.decode_text(text_buf);
field_nsapi.decode_text(text_buf);
field_trace__ref.decode_text(text_buf);
field_trace__type.decode_text(text_buf);
field_protConfigOptions.decode_text(text_buf);
field_sgsn__addr__controlPlane.decode_text(text_buf);
field_sgsn__addr__traffic.decode_text(text_buf);
field_alt__ggsn__addr__controlPane.decode_text(text_buf);
field_alt__ggsn__addr__traffic.decode_text(text_buf);
field_qualityOfServiceProfile.decode_text(text_buf);
field_tft.decode_text(text_buf);
field_triggerId.decode_text(text_buf);
field_omcId.decode_text(text_buf);
field_commonFlags.decode_text(text_buf);
field_ratType.decode_text(text_buf);
field_userLocationInformation.decode_text(text_buf);
field_mS__TimeZone.decode_text(text_buf);
field_additionalTraceInfo.decode_text(text_buf);
field_directTunnelFlags.decode_text(text_buf);
field_evolvedAllocationRetentionPriorityI.decode_text(text_buf);
field_extendedCommonFlags.decode_text(text_buf);
field_userCSGInformation.decode_text(text_buf);
field_aPN__AMBR.decode_text(text_buf);
field_signallingPriorityIndication.decode_text(text_buf);
field_cN__OperatorSelectionEntity.decode_text(text_buf);
field_private__extension__gtpc.decode_text(text_buf);
}

void UpdatePDPContextRequestSGSN::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void UpdatePDPContextRequestSGSN::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int UpdatePDPContextRequestSGSN::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(0)) {
    field_imsi = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_0_force_omit(0, force_omit, IMSI__gtpc_descr_.raw->forceomit);
  decoded_field_length = field_imsi().RAW_decode(IMSI__gtpc_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 1) {
  field_imsi = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_imsi=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_rai = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, RoutingAreaIdentity_descr_.raw->forceomit);
  decoded_field_length = field_rai().RAW_decode(RoutingAreaIdentity_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_rai = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_rai=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(2)) {
    field_recovery = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_2_force_omit(2, force_omit, Recovery__gtpc_descr_.raw->forceomit);
  decoded_field_length = field_recovery().RAW_decode(Recovery__gtpc_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 1) {
  field_recovery = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_recovery=OMIT_VALUE;
  RAW_Force_Omit field_3_force_omit(3, force_omit, TeidDataI_descr_.raw->forceomit);
  decoded_field_length = field_teidDataI.RAW_decode(TeidDataI_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_teidControlPlane = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, TeidControlPlane_descr_.raw->forceomit);
  decoded_field_length = field_teidControlPlane().RAW_decode(TeidControlPlane_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_teidControlPlane = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_teidControlPlane=OMIT_VALUE;
  RAW_Force_Omit field_5_force_omit(5, force_omit, NSAPI__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_nsapi.RAW_decode(NSAPI__GTPC_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(6)) {
    field_trace__ref = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, TraceRef_descr_.raw->forceomit);
  decoded_field_length = field_trace__ref().RAW_decode(TraceRef_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_trace__ref = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_trace__ref=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(7)) {
    field_trace__type = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_7_force_omit(7, force_omit, GTP__TraceType_descr_.raw->forceomit);
  decoded_field_length = field_trace__type().RAW_decode(GTP__TraceType_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 1) {
  field_trace__type = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_trace__type=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(8)) {
    field_protConfigOptions = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_8_force_omit(8, force_omit, ProtConfigOptions_descr_.raw->forceomit);
  decoded_field_length = field_protConfigOptions().RAW_decode(ProtConfigOptions_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 1) {
  field_protConfigOptions = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_protConfigOptions=OMIT_VALUE;
  RAW_Force_Omit field_9_force_omit(9, force_omit, GSN__Address__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_sgsn__addr__controlPlane.RAW_decode(GSN__Address__GTPC_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_9_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  RAW_Force_Omit field_10_force_omit(10, force_omit, GSN__Address__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_sgsn__addr__traffic.RAW_decode(GSN__Address__GTPC_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_10_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(11)) {
    field_alt__ggsn__addr__controlPane = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_11_force_omit(11, force_omit, GSN__Address__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_alt__ggsn__addr__controlPane().RAW_decode(GSN__Address__GTPC_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_11_force_omit);
  if (decoded_field_length < 1) {
  field_alt__ggsn__addr__controlPane = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_alt__ggsn__addr__controlPane=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(12)) {
    field_alt__ggsn__addr__traffic = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_12_force_omit(12, force_omit, GSN__Address__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_alt__ggsn__addr__traffic().RAW_decode(GSN__Address__GTPC_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_12_force_omit);
  if (decoded_field_length < 1) {
  field_alt__ggsn__addr__traffic = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_alt__ggsn__addr__traffic=OMIT_VALUE;
  RAW_Force_Omit field_13_force_omit(13, force_omit, QualityOfServiceProfile_descr_.raw->forceomit);
  decoded_field_length = field_qualityOfServiceProfile.RAW_decode(QualityOfServiceProfile_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_13_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(14)) {
    field_tft = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_14_force_omit(14, force_omit, TrafficFlowTemplate_descr_.raw->forceomit);
  decoded_field_length = field_tft().RAW_decode(TrafficFlowTemplate_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_14_force_omit);
  if (decoded_field_length < 1) {
  field_tft = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_tft=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(15)) {
    field_triggerId = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_15_force_omit(15, force_omit, GTP__TriggerID_descr_.raw->forceomit);
  decoded_field_length = field_triggerId().RAW_decode(GTP__TriggerID_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_15_force_omit);
  if (decoded_field_length < 1) {
  field_triggerId = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_triggerId=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(16)) {
    field_omcId = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_16_force_omit(16, force_omit, OMCIdentity_descr_.raw->forceomit);
  decoded_field_length = field_omcId().RAW_decode(OMCIdentity_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_16_force_omit);
  if (decoded_field_length < 1) {
  field_omcId = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_omcId=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(17)) {
    field_commonFlags = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_17_force_omit(17, force_omit, CommonFlags_descr_.raw->forceomit);
  decoded_field_length = field_commonFlags().RAW_decode(CommonFlags_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_17_force_omit);
  if (decoded_field_length < 1) {
  field_commonFlags = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_commonFlags=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(18)) {
    field_ratType = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_18_force_omit(18, force_omit, RATType_descr_.raw->forceomit);
  decoded_field_length = field_ratType().RAW_decode(RATType_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_18_force_omit);
  if (decoded_field_length < 1) {
  field_ratType = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_ratType=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(19)) {
    field_userLocationInformation = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_19_force_omit(19, force_omit, UserLocationInformation_descr_.raw->forceomit);
  decoded_field_length = field_userLocationInformation().RAW_decode(UserLocationInformation_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_19_force_omit);
  if (decoded_field_length < 1) {
  field_userLocationInformation = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_userLocationInformation=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(20)) {
    field_mS__TimeZone = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_20_force_omit(20, force_omit, MS__TimeZone_descr_.raw->forceomit);
  decoded_field_length = field_mS__TimeZone().RAW_decode(MS__TimeZone_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_20_force_omit);
  if (decoded_field_length < 1) {
  field_mS__TimeZone = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_mS__TimeZone=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(21)) {
    field_additionalTraceInfo = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_21_force_omit(21, force_omit, AdditionalTraceInfo_descr_.raw->forceomit);
  decoded_field_length = field_additionalTraceInfo().RAW_decode(AdditionalTraceInfo_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_21_force_omit);
  if (decoded_field_length < 1) {
  field_additionalTraceInfo = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_additionalTraceInfo=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(22)) {
    field_directTunnelFlags = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_22_force_omit(22, force_omit, DirectTunnelFlags_descr_.raw->forceomit);
  decoded_field_length = field_directTunnelFlags().RAW_decode(DirectTunnelFlags_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_22_force_omit);
  if (decoded_field_length < 1) {
  field_directTunnelFlags = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_directTunnelFlags=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(23)) {
    field_evolvedAllocationRetentionPriorityI = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_23_force_omit(23, force_omit, EvolvedAllocationRetentionPriorityI_descr_.raw->forceomit);
  decoded_field_length = field_evolvedAllocationRetentionPriorityI().RAW_decode(EvolvedAllocationRetentionPriorityI_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_23_force_omit);
  if (decoded_field_length < 1) {
  field_evolvedAllocationRetentionPriorityI = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_evolvedAllocationRetentionPriorityI=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(24)) {
    field_extendedCommonFlags = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_24_force_omit(24, force_omit, ExtendedCommonFlags_descr_.raw->forceomit);
  decoded_field_length = field_extendedCommonFlags().RAW_decode(ExtendedCommonFlags_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_24_force_omit);
  if (decoded_field_length < 1) {
  field_extendedCommonFlags = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_extendedCommonFlags=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(25)) {
    field_userCSGInformation = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_25_force_omit(25, force_omit, UserCSGInformation_descr_.raw->forceomit);
  decoded_field_length = field_userCSGInformation().RAW_decode(UserCSGInformation_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_25_force_omit);
  if (decoded_field_length < 1) {
  field_userCSGInformation = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_userCSGInformation=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(26)) {
    field_aPN__AMBR = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_26_force_omit(26, force_omit, APN__AMBR_descr_.raw->forceomit);
  decoded_field_length = field_aPN__AMBR().RAW_decode(APN__AMBR_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_26_force_omit);
  if (decoded_field_length < 1) {
  field_aPN__AMBR = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_aPN__AMBR=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(27)) {
    field_signallingPriorityIndication = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_27_force_omit(27, force_omit, SignallingPriorityIndication_descr_.raw->forceomit);
  decoded_field_length = field_signallingPriorityIndication().RAW_decode(SignallingPriorityIndication_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_27_force_omit);
  if (decoded_field_length < 1) {
  field_signallingPriorityIndication = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_signallingPriorityIndication=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(28)) {
    field_cN__OperatorSelectionEntity = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_28_force_omit(28, force_omit, CN__OperatorSelectionEntity_descr_.raw->forceomit);
  decoded_field_length = field_cN__OperatorSelectionEntity().RAW_decode(CN__OperatorSelectionEntity_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_28_force_omit);
  if (decoded_field_length < 1) {
  field_cN__OperatorSelectionEntity = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_cN__OperatorSelectionEntity=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(29)) {
    field_private__extension__gtpc = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_29_force_omit(29, force_omit, PrivateExtension__gtpc__List_descr_.raw->forceomit);
  decoded_field_length = field_private__extension__gtpc().RAW_decode(PrivateExtension__gtpc__List_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_29_force_omit);
  if (decoded_field_length < 1) {
  field_private__extension__gtpc = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_private__extension__gtpc=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int UpdatePDPContextRequestSGSN::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 30;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(30);
  if (field_imsi.ispresent()) {
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, IMSI__gtpc_descr_.raw);
  }
  else myleaf.body.node.nodes[0] = NULL;
  if (field_rai.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, RoutingAreaIdentity_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  if (field_recovery.ispresent()) {
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, Recovery__gtpc_descr_.raw);
  }
  else myleaf.body.node.nodes[2] = NULL;
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, TeidDataI_descr_.raw);
  if (field_teidControlPlane.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, TeidControlPlane_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, NSAPI__GTPC_descr_.raw);
  if (field_trace__ref.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, TraceRef_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  if (field_trace__type.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, GTP__TraceType_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  if (field_protConfigOptions.ispresent()) {
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, ProtConfigOptions_descr_.raw);
  }
  else myleaf.body.node.nodes[8] = NULL;
  myleaf.body.node.nodes[9] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 9, GSN__Address__GTPC_descr_.raw);
  myleaf.body.node.nodes[10] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 10, GSN__Address__GTPC_descr_.raw);
  if (field_alt__ggsn__addr__controlPane.ispresent()) {
  myleaf.body.node.nodes[11] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 11, GSN__Address__GTPC_descr_.raw);
  }
  else myleaf.body.node.nodes[11] = NULL;
  if (field_alt__ggsn__addr__traffic.ispresent()) {
  myleaf.body.node.nodes[12] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 12, GSN__Address__GTPC_descr_.raw);
  }
  else myleaf.body.node.nodes[12] = NULL;
  myleaf.body.node.nodes[13] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 13, QualityOfServiceProfile_descr_.raw);
  if (field_tft.ispresent()) {
  myleaf.body.node.nodes[14] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 14, TrafficFlowTemplate_descr_.raw);
  }
  else myleaf.body.node.nodes[14] = NULL;
  if (field_triggerId.ispresent()) {
  myleaf.body.node.nodes[15] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 15, GTP__TriggerID_descr_.raw);
  }
  else myleaf.body.node.nodes[15] = NULL;
  if (field_omcId.ispresent()) {
  myleaf.body.node.nodes[16] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 16, OMCIdentity_descr_.raw);
  }
  else myleaf.body.node.nodes[16] = NULL;
  if (field_commonFlags.ispresent()) {
  myleaf.body.node.nodes[17] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 17, CommonFlags_descr_.raw);
  }
  else myleaf.body.node.nodes[17] = NULL;
  if (field_ratType.ispresent()) {
  myleaf.body.node.nodes[18] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 18, RATType_descr_.raw);
  }
  else myleaf.body.node.nodes[18] = NULL;
  if (field_userLocationInformation.ispresent()) {
  myleaf.body.node.nodes[19] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 19, UserLocationInformation_descr_.raw);
  }
  else myleaf.body.node.nodes[19] = NULL;
  if (field_mS__TimeZone.ispresent()) {
  myleaf.body.node.nodes[20] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 20, MS__TimeZone_descr_.raw);
  }
  else myleaf.body.node.nodes[20] = NULL;
  if (field_additionalTraceInfo.ispresent()) {
  myleaf.body.node.nodes[21] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 21, AdditionalTraceInfo_descr_.raw);
  }
  else myleaf.body.node.nodes[21] = NULL;
  if (field_directTunnelFlags.ispresent()) {
  myleaf.body.node.nodes[22] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 22, DirectTunnelFlags_descr_.raw);
  }
  else myleaf.body.node.nodes[22] = NULL;
  if (field_evolvedAllocationRetentionPriorityI.ispresent()) {
  myleaf.body.node.nodes[23] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 23, EvolvedAllocationRetentionPriorityI_descr_.raw);
  }
  else myleaf.body.node.nodes[23] = NULL;
  if (field_extendedCommonFlags.ispresent()) {
  myleaf.body.node.nodes[24] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 24, ExtendedCommonFlags_descr_.raw);
  }
  else myleaf.body.node.nodes[24] = NULL;
  if (field_userCSGInformation.ispresent()) {
  myleaf.body.node.nodes[25] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 25, UserCSGInformation_descr_.raw);
  }
  else myleaf.body.node.nodes[25] = NULL;
  if (field_aPN__AMBR.ispresent()) {
  myleaf.body.node.nodes[26] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 26, APN__AMBR_descr_.raw);
  }
  else myleaf.body.node.nodes[26] = NULL;
  if (field_signallingPriorityIndication.ispresent()) {
  myleaf.body.node.nodes[27] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 27, SignallingPriorityIndication_descr_.raw);
  }
  else myleaf.body.node.nodes[27] = NULL;
  if (field_cN__OperatorSelectionEntity.ispresent()) {
  myleaf.body.node.nodes[28] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 28, CN__OperatorSelectionEntity_descr_.raw);
  }
  else myleaf.body.node.nodes[28] = NULL;
  if (field_private__extension__gtpc.ispresent()) {
  myleaf.body.node.nodes[29] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 29, PrivateExtension__gtpc__List_descr_.raw);
  }
  else myleaf.body.node.nodes[29] = NULL;
  if (field_imsi.ispresent()) {
  encoded_length += field_imsi().RAW_encode(IMSI__gtpc_descr_, *myleaf.body.node.nodes[0]);
  }
  if (field_rai.ispresent()) {
  encoded_length += field_rai().RAW_encode(RoutingAreaIdentity_descr_, *myleaf.body.node.nodes[1]);
  }
  if (field_recovery.ispresent()) {
  encoded_length += field_recovery().RAW_encode(Recovery__gtpc_descr_, *myleaf.body.node.nodes[2]);
  }
  encoded_length += field_teidDataI.RAW_encode(TeidDataI_descr_, *myleaf.body.node.nodes[3]);
  if (field_teidControlPlane.ispresent()) {
  encoded_length += field_teidControlPlane().RAW_encode(TeidControlPlane_descr_, *myleaf.body.node.nodes[4]);
  }
  encoded_length += field_nsapi.RAW_encode(NSAPI__GTPC_descr_, *myleaf.body.node.nodes[5]);
  if (field_trace__ref.ispresent()) {
  encoded_length += field_trace__ref().RAW_encode(TraceRef_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_trace__type.ispresent()) {
  encoded_length += field_trace__type().RAW_encode(GTP__TraceType_descr_, *myleaf.body.node.nodes[7]);
  }
  if (field_protConfigOptions.ispresent()) {
  encoded_length += field_protConfigOptions().RAW_encode(ProtConfigOptions_descr_, *myleaf.body.node.nodes[8]);
  }
  encoded_length += field_sgsn__addr__controlPlane.RAW_encode(GSN__Address__GTPC_descr_, *myleaf.body.node.nodes[9]);
  encoded_length += field_sgsn__addr__traffic.RAW_encode(GSN__Address__GTPC_descr_, *myleaf.body.node.nodes[10]);
  if (field_alt__ggsn__addr__controlPane.ispresent()) {
  encoded_length += field_alt__ggsn__addr__controlPane().RAW_encode(GSN__Address__GTPC_descr_, *myleaf.body.node.nodes[11]);
  }
  if (field_alt__ggsn__addr__traffic.ispresent()) {
  encoded_length += field_alt__ggsn__addr__traffic().RAW_encode(GSN__Address__GTPC_descr_, *myleaf.body.node.nodes[12]);
  }
  encoded_length += field_qualityOfServiceProfile.RAW_encode(QualityOfServiceProfile_descr_, *myleaf.body.node.nodes[13]);
  if (field_tft.ispresent()) {
  encoded_length += field_tft().RAW_encode(TrafficFlowTemplate_descr_, *myleaf.body.node.nodes[14]);
  }
  if (field_triggerId.ispresent()) {
  encoded_length += field_triggerId().RAW_encode(GTP__TriggerID_descr_, *myleaf.body.node.nodes[15]);
  }
  if (field_omcId.ispresent()) {
  encoded_length += field_omcId().RAW_encode(OMCIdentity_descr_, *myleaf.body.node.nodes[16]);
  }
  if (field_commonFlags.ispresent()) {
  encoded_length += field_commonFlags().RAW_encode(CommonFlags_descr_, *myleaf.body.node.nodes[17]);
  }
  if (field_ratType.ispresent()) {
  encoded_length += field_ratType().RAW_encode(RATType_descr_, *myleaf.body.node.nodes[18]);
  }
  if (field_userLocationInformation.ispresent()) {
  encoded_length += field_userLocationInformation().RAW_encode(UserLocationInformation_descr_, *myleaf.body.node.nodes[19]);
  }
  if (field_mS__TimeZone.ispresent()) {
  encoded_length += field_mS__TimeZone().RAW_encode(MS__TimeZone_descr_, *myleaf.body.node.nodes[20]);
  }
  if (field_additionalTraceInfo.ispresent()) {
  encoded_length += field_additionalTraceInfo().RAW_encode(AdditionalTraceInfo_descr_, *myleaf.body.node.nodes[21]);
  }
  if (field_directTunnelFlags.ispresent()) {
  encoded_length += field_directTunnelFlags().RAW_encode(DirectTunnelFlags_descr_, *myleaf.body.node.nodes[22]);
  }
  if (field_evolvedAllocationRetentionPriorityI.ispresent()) {
  encoded_length += field_evolvedAllocationRetentionPriorityI().RAW_encode(EvolvedAllocationRetentionPriorityI_descr_, *myleaf.body.node.nodes[23]);
  }
  if (field_extendedCommonFlags.ispresent()) {
  encoded_length += field_extendedCommonFlags().RAW_encode(ExtendedCommonFlags_descr_, *myleaf.body.node.nodes[24]);
  }
  if (field_userCSGInformation.ispresent()) {
  encoded_length += field_userCSGInformation().RAW_encode(UserCSGInformation_descr_, *myleaf.body.node.nodes[25]);
  }
  if (field_aPN__AMBR.ispresent()) {
  encoded_length += field_aPN__AMBR().RAW_encode(APN__AMBR_descr_, *myleaf.body.node.nodes[26]);
  }
  if (field_signallingPriorityIndication.ispresent()) {
  encoded_length += field_signallingPriorityIndication().RAW_encode(SignallingPriorityIndication_descr_, *myleaf.body.node.nodes[27]);
  }
  if (field_cN__OperatorSelectionEntity.ispresent()) {
  encoded_length += field_cN__OperatorSelectionEntity().RAW_encode(CN__OperatorSelectionEntity_descr_, *myleaf.body.node.nodes[28]);
  }
  if (field_private__extension__gtpc.ispresent()) {
  encoded_length += field_private__extension__gtpc().RAW_encode(PrivateExtension__gtpc__List_descr_, *myleaf.body.node.nodes[29]);
  }
  return myleaf.length = encoded_length;
}

struct UpdatePDPContextRequestSGSN_template::single_value_struct {
IMSI__gtpc_template field_imsi;
RoutingAreaIdentity_template field_rai;
Recovery__gtpc_template field_recovery;
TeidDataI_template field_teidDataI;
TeidControlPlane_template field_teidControlPlane;
NSAPI__GTPC_template field_nsapi;
TraceRef_template field_trace__ref;
GTP__TraceType_template field_trace__type;
ProtConfigOptions_template field_protConfigOptions;
GSN__Address__GTPC_template field_sgsn__addr__controlPlane;
GSN__Address__GTPC_template field_sgsn__addr__traffic;
GSN__Address__GTPC_template field_alt__ggsn__addr__controlPane;
GSN__Address__GTPC_template field_alt__ggsn__addr__traffic;
QualityOfServiceProfile_template field_qualityOfServiceProfile;
TrafficFlowTemplate_template field_tft;
GTP__TriggerID_template field_triggerId;
OMCIdentity_template field_omcId;
CommonFlags_template field_commonFlags;
RATType_template field_ratType;
UserLocationInformation_template field_userLocationInformation;
MS__TimeZone_template field_mS__TimeZone;
AdditionalTraceInfo_template field_additionalTraceInfo;
DirectTunnelFlags_template field_directTunnelFlags;
EvolvedAllocationRetentionPriorityI_template field_evolvedAllocationRetentionPriorityI;
ExtendedCommonFlags_template field_extendedCommonFlags;
UserCSGInformation_template field_userCSGInformation;
APN__AMBR_template field_aPN__AMBR;
SignallingPriorityIndication_template field_signallingPriorityIndication;
CN__OperatorSelectionEntity_template field_cN__OperatorSelectionEntity;
PrivateExtension__gtpc__List_template field_private__extension__gtpc;
};

void UpdatePDPContextRequestSGSN_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_imsi = ANY_OR_OMIT;
single_value->field_rai = ANY_OR_OMIT;
single_value->field_recovery = ANY_OR_OMIT;
single_value->field_teidDataI = ANY_VALUE;
single_value->field_teidControlPlane = ANY_OR_OMIT;
single_value->field_nsapi = ANY_VALUE;
single_value->field_trace__ref = ANY_OR_OMIT;
single_value->field_trace__type = ANY_OR_OMIT;
single_value->field_protConfigOptions = ANY_OR_OMIT;
single_value->field_sgsn__addr__controlPlane = ANY_VALUE;
single_value->field_sgsn__addr__traffic = ANY_VALUE;
single_value->field_alt__ggsn__addr__controlPane = ANY_OR_OMIT;
single_value->field_alt__ggsn__addr__traffic = ANY_OR_OMIT;
single_value->field_qualityOfServiceProfile = ANY_VALUE;
single_value->field_tft = ANY_OR_OMIT;
single_value->field_triggerId = ANY_OR_OMIT;
single_value->field_omcId = ANY_OR_OMIT;
single_value->field_commonFlags = ANY_OR_OMIT;
single_value->field_ratType = ANY_OR_OMIT;
single_value->field_userLocationInformation = ANY_OR_OMIT;
single_value->field_mS__TimeZone = ANY_OR_OMIT;
single_value->field_additionalTraceInfo = ANY_OR_OMIT;
single_value->field_directTunnelFlags = ANY_OR_OMIT;
single_value->field_evolvedAllocationRetentionPriorityI = ANY_OR_OMIT;
single_value->field_extendedCommonFlags = ANY_OR_OMIT;
single_value->field_userCSGInformation = ANY_OR_OMIT;
single_value->field_aPN__AMBR = ANY_OR_OMIT;
single_value->field_signallingPriorityIndication = ANY_OR_OMIT;
single_value->field_cN__OperatorSelectionEntity = ANY_OR_OMIT;
single_value->field_private__extension__gtpc = ANY_OR_OMIT;
}
}
}

void UpdatePDPContextRequestSGSN_template::copy_value(const UpdatePDPContextRequestSGSN& other_value)
{
single_value = new single_value_struct;
if (other_value.imsi().is_bound()) {
  if (other_value.imsi().ispresent()) single_value->field_imsi = other_value.imsi()();
  else single_value->field_imsi = OMIT_VALUE;
} else {
  single_value->field_imsi.clean_up();
}
if (other_value.rai().is_bound()) {
  if (other_value.rai().ispresent()) single_value->field_rai = other_value.rai()();
  else single_value->field_rai = OMIT_VALUE;
} else {
  single_value->field_rai.clean_up();
}
if (other_value.recovery().is_bound()) {
  if (other_value.recovery().ispresent()) single_value->field_recovery = other_value.recovery()();
  else single_value->field_recovery = OMIT_VALUE;
} else {
  single_value->field_recovery.clean_up();
}
if (other_value.teidDataI().is_bound()) {
  single_value->field_teidDataI = other_value.teidDataI();
} else {
  single_value->field_teidDataI.clean_up();
}
if (other_value.teidControlPlane().is_bound()) {
  if (other_value.teidControlPlane().ispresent()) single_value->field_teidControlPlane = other_value.teidControlPlane()();
  else single_value->field_teidControlPlane = OMIT_VALUE;
} else {
  single_value->field_teidControlPlane.clean_up();
}
if (other_value.nsapi().is_bound()) {
  single_value->field_nsapi = other_value.nsapi();
} else {
  single_value->field_nsapi.clean_up();
}
if (other_value.trace__ref().is_bound()) {
  if (other_value.trace__ref().ispresent()) single_value->field_trace__ref = other_value.trace__ref()();
  else single_value->field_trace__ref = OMIT_VALUE;
} else {
  single_value->field_trace__ref.clean_up();
}
if (other_value.trace__type().is_bound()) {
  if (other_value.trace__type().ispresent()) single_value->field_trace__type = other_value.trace__type()();
  else single_value->field_trace__type = OMIT_VALUE;
} else {
  single_value->field_trace__type.clean_up();
}
if (other_value.protConfigOptions().is_bound()) {
  if (other_value.protConfigOptions().ispresent()) single_value->field_protConfigOptions = other_value.protConfigOptions()();
  else single_value->field_protConfigOptions = OMIT_VALUE;
} else {
  single_value->field_protConfigOptions.clean_up();
}
if (other_value.sgsn__addr__controlPlane().is_bound()) {
  single_value->field_sgsn__addr__controlPlane = other_value.sgsn__addr__controlPlane();
} else {
  single_value->field_sgsn__addr__controlPlane.clean_up();
}
if (other_value.sgsn__addr__traffic().is_bound()) {
  single_value->field_sgsn__addr__traffic = other_value.sgsn__addr__traffic();
} else {
  single_value->field_sgsn__addr__traffic.clean_up();
}
if (other_value.alt__ggsn__addr__controlPane().is_bound()) {
  if (other_value.alt__ggsn__addr__controlPane().ispresent()) single_value->field_alt__ggsn__addr__controlPane = other_value.alt__ggsn__addr__controlPane()();
  else single_value->field_alt__ggsn__addr__controlPane = OMIT_VALUE;
} else {
  single_value->field_alt__ggsn__addr__controlPane.clean_up();
}
if (other_value.alt__ggsn__addr__traffic().is_bound()) {
  if (other_value.alt__ggsn__addr__traffic().ispresent()) single_value->field_alt__ggsn__addr__traffic = other_value.alt__ggsn__addr__traffic()();
  else single_value->field_alt__ggsn__addr__traffic = OMIT_VALUE;
} else {
  single_value->field_alt__ggsn__addr__traffic.clean_up();
}
if (other_value.qualityOfServiceProfile().is_bound()) {
  single_value->field_qualityOfServiceProfile = other_value.qualityOfServiceProfile();
} else {
  single_value->field_qualityOfServiceProfile.clean_up();
}
if (other_value.tft().is_bound()) {
  if (other_value.tft().ispresent()) single_value->field_tft = other_value.tft()();
  else single_value->field_tft = OMIT_VALUE;
} else {
  single_value->field_tft.clean_up();
}
if (other_value.triggerId().is_bound()) {
  if (other_value.triggerId().ispresent()) single_value->field_triggerId = other_value.triggerId()();
  else single_value->field_triggerId = OMIT_VALUE;
} else {
  single_value->field_triggerId.clean_up();
}
if (other_value.omcId().is_bound()) {
  if (other_value.omcId().ispresent()) single_value->field_omcId = other_value.omcId()();
  else single_value->field_omcId = OMIT_VALUE;
} else {
  single_value->field_omcId.clean_up();
}
if (other_value.commonFlags().is_bound()) {
  if (other_value.commonFlags().ispresent()) single_value->field_commonFlags = other_value.commonFlags()();
  else single_value->field_commonFlags = OMIT_VALUE;
} else {
  single_value->field_commonFlags.clean_up();
}
if (other_value.ratType().is_bound()) {
  if (other_value.ratType().ispresent()) single_value->field_ratType = other_value.ratType()();
  else single_value->field_ratType = OMIT_VALUE;
} else {
  single_value->field_ratType.clean_up();
}
if (other_value.userLocationInformation().is_bound()) {
  if (other_value.userLocationInformation().ispresent()) single_value->field_userLocationInformation = other_value.userLocationInformation()();
  else single_value->field_userLocationInformation = OMIT_VALUE;
} else {
  single_value->field_userLocationInformation.clean_up();
}
if (other_value.mS__TimeZone().is_bound()) {
  if (other_value.mS__TimeZone().ispresent()) single_value->field_mS__TimeZone = other_value.mS__TimeZone()();
  else single_value->field_mS__TimeZone = OMIT_VALUE;
} else {
  single_value->field_mS__TimeZone.clean_up();
}
if (other_value.additionalTraceInfo().is_bound()) {
  if (other_value.additionalTraceInfo().ispresent()) single_value->field_additionalTraceInfo = other_value.additionalTraceInfo()();
  else single_value->field_additionalTraceInfo = OMIT_VALUE;
} else {
  single_value->field_additionalTraceInfo.clean_up();
}
if (other_value.directTunnelFlags().is_bound()) {
  if (other_value.directTunnelFlags().ispresent()) single_value->field_directTunnelFlags = other_value.directTunnelFlags()();
  else single_value->field_directTunnelFlags = OMIT_VALUE;
} else {
  single_value->field_directTunnelFlags.clean_up();
}
if (other_value.evolvedAllocationRetentionPriorityI().is_bound()) {
  if (other_value.evolvedAllocationRetentionPriorityI().ispresent()) single_value->field_evolvedAllocationRetentionPriorityI = other_value.evolvedAllocationRetentionPriorityI()();
  else single_value->field_evolvedAllocationRetentionPriorityI = OMIT_VALUE;
} else {
  single_value->field_evolvedAllocationRetentionPriorityI.clean_up();
}
if (other_value.extendedCommonFlags().is_bound()) {
  if (other_value.extendedCommonFlags().ispresent()) single_value->field_extendedCommonFlags = other_value.extendedCommonFlags()();
  else single_value->field_extendedCommonFlags = OMIT_VALUE;
} else {
  single_value->field_extendedCommonFlags.clean_up();
}
if (other_value.userCSGInformation().is_bound()) {
  if (other_value.userCSGInformation().ispresent()) single_value->field_userCSGInformation = other_value.userCSGInformation()();
  else single_value->field_userCSGInformation = OMIT_VALUE;
} else {
  single_value->field_userCSGInformation.clean_up();
}
if (other_value.aPN__AMBR().is_bound()) {
  if (other_value.aPN__AMBR().ispresent()) single_value->field_aPN__AMBR = other_value.aPN__AMBR()();
  else single_value->field_aPN__AMBR = OMIT_VALUE;
} else {
  single_value->field_aPN__AMBR.clean_up();
}
if (other_value.signallingPriorityIndication().is_bound()) {
  if (other_value.signallingPriorityIndication().ispresent()) single_value->field_signallingPriorityIndication = other_value.signallingPriorityIndication()();
  else single_value->field_signallingPriorityIndication = OMIT_VALUE;
} else {
  single_value->field_signallingPriorityIndication.clean_up();
}
if (other_value.cN__OperatorSelectionEntity().is_bound()) {
  if (other_value.cN__OperatorSelectionEntity().ispresent()) single_value->field_cN__OperatorSelectionEntity = other_value.cN__OperatorSelectionEntity()();
  else single_value->field_cN__OperatorSelectionEntity = OMIT_VALUE;
} else {
  single_value->field_cN__OperatorSelectionEntity.clean_up();
}
if (other_value.private__extension__gtpc().is_bound()) {
  if (other_value.private__extension__gtpc().ispresent()) single_value->field_private__extension__gtpc = other_value.private__extension__gtpc()();
  else single_value->field_private__extension__gtpc = OMIT_VALUE;
} else {
  single_value->field_private__extension__gtpc.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void UpdatePDPContextRequestSGSN_template::copy_template(const UpdatePDPContextRequestSGSN_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.imsi().get_selection()) {
single_value->field_imsi = other_value.imsi();
} else {
single_value->field_imsi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rai().get_selection()) {
single_value->field_rai = other_value.rai();
} else {
single_value->field_rai.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.recovery().get_selection()) {
single_value->field_recovery = other_value.recovery();
} else {
single_value->field_recovery.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.teidDataI().get_selection()) {
single_value->field_teidDataI = other_value.teidDataI();
} else {
single_value->field_teidDataI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.teidControlPlane().get_selection()) {
single_value->field_teidControlPlane = other_value.teidControlPlane();
} else {
single_value->field_teidControlPlane.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsapi().get_selection()) {
single_value->field_nsapi = other_value.nsapi();
} else {
single_value->field_nsapi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.trace__ref().get_selection()) {
single_value->field_trace__ref = other_value.trace__ref();
} else {
single_value->field_trace__ref.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.trace__type().get_selection()) {
single_value->field_trace__type = other_value.trace__type();
} else {
single_value->field_trace__type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.protConfigOptions().get_selection()) {
single_value->field_protConfigOptions = other_value.protConfigOptions();
} else {
single_value->field_protConfigOptions.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sgsn__addr__controlPlane().get_selection()) {
single_value->field_sgsn__addr__controlPlane = other_value.sgsn__addr__controlPlane();
} else {
single_value->field_sgsn__addr__controlPlane.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sgsn__addr__traffic().get_selection()) {
single_value->field_sgsn__addr__traffic = other_value.sgsn__addr__traffic();
} else {
single_value->field_sgsn__addr__traffic.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.alt__ggsn__addr__controlPane().get_selection()) {
single_value->field_alt__ggsn__addr__controlPane = other_value.alt__ggsn__addr__controlPane();
} else {
single_value->field_alt__ggsn__addr__controlPane.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.alt__ggsn__addr__traffic().get_selection()) {
single_value->field_alt__ggsn__addr__traffic = other_value.alt__ggsn__addr__traffic();
} else {
single_value->field_alt__ggsn__addr__traffic.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.qualityOfServiceProfile().get_selection()) {
single_value->field_qualityOfServiceProfile = other_value.qualityOfServiceProfile();
} else {
single_value->field_qualityOfServiceProfile.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tft().get_selection()) {
single_value->field_tft = other_value.tft();
} else {
single_value->field_tft.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.triggerId().get_selection()) {
single_value->field_triggerId = other_value.triggerId();
} else {
single_value->field_triggerId.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.omcId().get_selection()) {
single_value->field_omcId = other_value.omcId();
} else {
single_value->field_omcId.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.commonFlags().get_selection()) {
single_value->field_commonFlags = other_value.commonFlags();
} else {
single_value->field_commonFlags.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ratType().get_selection()) {
single_value->field_ratType = other_value.ratType();
} else {
single_value->field_ratType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.userLocationInformation().get_selection()) {
single_value->field_userLocationInformation = other_value.userLocationInformation();
} else {
single_value->field_userLocationInformation.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mS__TimeZone().get_selection()) {
single_value->field_mS__TimeZone = other_value.mS__TimeZone();
} else {
single_value->field_mS__TimeZone.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.additionalTraceInfo().get_selection()) {
single_value->field_additionalTraceInfo = other_value.additionalTraceInfo();
} else {
single_value->field_additionalTraceInfo.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.directTunnelFlags().get_selection()) {
single_value->field_directTunnelFlags = other_value.directTunnelFlags();
} else {
single_value->field_directTunnelFlags.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.evolvedAllocationRetentionPriorityI().get_selection()) {
single_value->field_evolvedAllocationRetentionPriorityI = other_value.evolvedAllocationRetentionPriorityI();
} else {
single_value->field_evolvedAllocationRetentionPriorityI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extendedCommonFlags().get_selection()) {
single_value->field_extendedCommonFlags = other_value.extendedCommonFlags();
} else {
single_value->field_extendedCommonFlags.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.userCSGInformation().get_selection()) {
single_value->field_userCSGInformation = other_value.userCSGInformation();
} else {
single_value->field_userCSGInformation.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.aPN__AMBR().get_selection()) {
single_value->field_aPN__AMBR = other_value.aPN__AMBR();
} else {
single_value->field_aPN__AMBR.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.signallingPriorityIndication().get_selection()) {
single_value->field_signallingPriorityIndication = other_value.signallingPriorityIndication();
} else {
single_value->field_signallingPriorityIndication.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cN__OperatorSelectionEntity().get_selection()) {
single_value->field_cN__OperatorSelectionEntity = other_value.cN__OperatorSelectionEntity();
} else {
single_value->field_cN__OperatorSelectionEntity.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.private__extension__gtpc().get_selection()) {
single_value->field_private__extension__gtpc = other_value.private__extension__gtpc();
} else {
single_value->field_private__extension__gtpc.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new UpdatePDPContextRequestSGSN_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new UpdatePDPContextRequestSGSN_template(*other_value.implication_.precondition);
implication_.implied_template = new UpdatePDPContextRequestSGSN_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
break;
}
set_selection(other_value);
}

UpdatePDPContextRequestSGSN_template::UpdatePDPContextRequestSGSN_template()
{
}

UpdatePDPContextRequestSGSN_template::UpdatePDPContextRequestSGSN_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

UpdatePDPContextRequestSGSN_template::UpdatePDPContextRequestSGSN_template(const UpdatePDPContextRequestSGSN& other_value)
{
copy_value(other_value);
}

UpdatePDPContextRequestSGSN_template::UpdatePDPContextRequestSGSN_template(const OPTIONAL<UpdatePDPContextRequestSGSN>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UpdatePDPContextRequestSGSN&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.UpdatePDPContextRequestSGSN from an unbound optional field.");
}
}

UpdatePDPContextRequestSGSN_template::UpdatePDPContextRequestSGSN_template(UpdatePDPContextRequestSGSN_template* p_precondition, UpdatePDPContextRequestSGSN_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

UpdatePDPContextRequestSGSN_template::UpdatePDPContextRequestSGSN_template(Dynamic_Match_Interface<UpdatePDPContextRequestSGSN>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<UpdatePDPContextRequestSGSN>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

UpdatePDPContextRequestSGSN_template::UpdatePDPContextRequestSGSN_template(const UpdatePDPContextRequestSGSN_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

UpdatePDPContextRequestSGSN_template::~UpdatePDPContextRequestSGSN_template()
{
clean_up();
}

UpdatePDPContextRequestSGSN_template& UpdatePDPContextRequestSGSN_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

UpdatePDPContextRequestSGSN_template& UpdatePDPContextRequestSGSN_template::operator=(const UpdatePDPContextRequestSGSN& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

UpdatePDPContextRequestSGSN_template& UpdatePDPContextRequestSGSN_template::operator=(const OPTIONAL<UpdatePDPContextRequestSGSN>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UpdatePDPContextRequestSGSN&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
}
return *this;
}

UpdatePDPContextRequestSGSN_template& UpdatePDPContextRequestSGSN_template::operator=(const UpdatePDPContextRequestSGSN_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean UpdatePDPContextRequestSGSN_template::match(const UpdatePDPContextRequestSGSN& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.imsi().is_bound()) return FALSE;
if((other_value.imsi().ispresent() ? !single_value->field_imsi.match((const IMSI__gtpc&)other_value.imsi(), legacy) : !single_value->field_imsi.match_omit(legacy)))return FALSE;
if(!other_value.rai().is_bound()) return FALSE;
if((other_value.rai().ispresent() ? !single_value->field_rai.match((const RoutingAreaIdentity&)other_value.rai(), legacy) : !single_value->field_rai.match_omit(legacy)))return FALSE;
if(!other_value.recovery().is_bound()) return FALSE;
if((other_value.recovery().ispresent() ? !single_value->field_recovery.match((const Recovery__gtpc&)other_value.recovery(), legacy) : !single_value->field_recovery.match_omit(legacy)))return FALSE;
if(!other_value.teidDataI().is_bound()) return FALSE;
if(!single_value->field_teidDataI.match(other_value.teidDataI(), legacy))return FALSE;
if(!other_value.teidControlPlane().is_bound()) return FALSE;
if((other_value.teidControlPlane().ispresent() ? !single_value->field_teidControlPlane.match((const TeidControlPlane&)other_value.teidControlPlane(), legacy) : !single_value->field_teidControlPlane.match_omit(legacy)))return FALSE;
if(!other_value.nsapi().is_bound()) return FALSE;
if(!single_value->field_nsapi.match(other_value.nsapi(), legacy))return FALSE;
if(!other_value.trace__ref().is_bound()) return FALSE;
if((other_value.trace__ref().ispresent() ? !single_value->field_trace__ref.match((const TraceRef&)other_value.trace__ref(), legacy) : !single_value->field_trace__ref.match_omit(legacy)))return FALSE;
if(!other_value.trace__type().is_bound()) return FALSE;
if((other_value.trace__type().ispresent() ? !single_value->field_trace__type.match((const GTP__TraceType&)other_value.trace__type(), legacy) : !single_value->field_trace__type.match_omit(legacy)))return FALSE;
if(!other_value.protConfigOptions().is_bound()) return FALSE;
if((other_value.protConfigOptions().ispresent() ? !single_value->field_protConfigOptions.match((const ProtConfigOptions&)other_value.protConfigOptions(), legacy) : !single_value->field_protConfigOptions.match_omit(legacy)))return FALSE;
if(!other_value.sgsn__addr__controlPlane().is_bound()) return FALSE;
if(!single_value->field_sgsn__addr__controlPlane.match(other_value.sgsn__addr__controlPlane(), legacy))return FALSE;
if(!other_value.sgsn__addr__traffic().is_bound()) return FALSE;
if(!single_value->field_sgsn__addr__traffic.match(other_value.sgsn__addr__traffic(), legacy))return FALSE;
if(!other_value.alt__ggsn__addr__controlPane().is_bound()) return FALSE;
if((other_value.alt__ggsn__addr__controlPane().ispresent() ? !single_value->field_alt__ggsn__addr__controlPane.match((const GSN__Address__GTPC&)other_value.alt__ggsn__addr__controlPane(), legacy) : !single_value->field_alt__ggsn__addr__controlPane.match_omit(legacy)))return FALSE;
if(!other_value.alt__ggsn__addr__traffic().is_bound()) return FALSE;
if((other_value.alt__ggsn__addr__traffic().ispresent() ? !single_value->field_alt__ggsn__addr__traffic.match((const GSN__Address__GTPC&)other_value.alt__ggsn__addr__traffic(), legacy) : !single_value->field_alt__ggsn__addr__traffic.match_omit(legacy)))return FALSE;
if(!other_value.qualityOfServiceProfile().is_bound()) return FALSE;
if(!single_value->field_qualityOfServiceProfile.match(other_value.qualityOfServiceProfile(), legacy))return FALSE;
if(!other_value.tft().is_bound()) return FALSE;
if((other_value.tft().ispresent() ? !single_value->field_tft.match((const TrafficFlowTemplate&)other_value.tft(), legacy) : !single_value->field_tft.match_omit(legacy)))return FALSE;
if(!other_value.triggerId().is_bound()) return FALSE;
if((other_value.triggerId().ispresent() ? !single_value->field_triggerId.match((const GTP__TriggerID&)other_value.triggerId(), legacy) : !single_value->field_triggerId.match_omit(legacy)))return FALSE;
if(!other_value.omcId().is_bound()) return FALSE;
if((other_value.omcId().ispresent() ? !single_value->field_omcId.match((const OMCIdentity&)other_value.omcId(), legacy) : !single_value->field_omcId.match_omit(legacy)))return FALSE;
if(!other_value.commonFlags().is_bound()) return FALSE;
if((other_value.commonFlags().ispresent() ? !single_value->field_commonFlags.match((const CommonFlags&)other_value.commonFlags(), legacy) : !single_value->field_commonFlags.match_omit(legacy)))return FALSE;
if(!other_value.ratType().is_bound()) return FALSE;
if((other_value.ratType().ispresent() ? !single_value->field_ratType.match((const RATType&)other_value.ratType(), legacy) : !single_value->field_ratType.match_omit(legacy)))return FALSE;
if(!other_value.userLocationInformation().is_bound()) return FALSE;
if((other_value.userLocationInformation().ispresent() ? !single_value->field_userLocationInformation.match((const UserLocationInformation&)other_value.userLocationInformation(), legacy) : !single_value->field_userLocationInformation.match_omit(legacy)))return FALSE;
if(!other_value.mS__TimeZone().is_bound()) return FALSE;
if((other_value.mS__TimeZone().ispresent() ? !single_value->field_mS__TimeZone.match((const MS__TimeZone&)other_value.mS__TimeZone(), legacy) : !single_value->field_mS__TimeZone.match_omit(legacy)))return FALSE;
if(!other_value.additionalTraceInfo().is_bound()) return FALSE;
if((other_value.additionalTraceInfo().ispresent() ? !single_value->field_additionalTraceInfo.match((const AdditionalTraceInfo&)other_value.additionalTraceInfo(), legacy) : !single_value->field_additionalTraceInfo.match_omit(legacy)))return FALSE;
if(!other_value.directTunnelFlags().is_bound()) return FALSE;
if((other_value.directTunnelFlags().ispresent() ? !single_value->field_directTunnelFlags.match((const DirectTunnelFlags&)other_value.directTunnelFlags(), legacy) : !single_value->field_directTunnelFlags.match_omit(legacy)))return FALSE;
if(!other_value.evolvedAllocationRetentionPriorityI().is_bound()) return FALSE;
if((other_value.evolvedAllocationRetentionPriorityI().ispresent() ? !single_value->field_evolvedAllocationRetentionPriorityI.match((const EvolvedAllocationRetentionPriorityI&)other_value.evolvedAllocationRetentionPriorityI(), legacy) : !single_value->field_evolvedAllocationRetentionPriorityI.match_omit(legacy)))return FALSE;
if(!other_value.extendedCommonFlags().is_bound()) return FALSE;
if((other_value.extendedCommonFlags().ispresent() ? !single_value->field_extendedCommonFlags.match((const ExtendedCommonFlags&)other_value.extendedCommonFlags(), legacy) : !single_value->field_extendedCommonFlags.match_omit(legacy)))return FALSE;
if(!other_value.userCSGInformation().is_bound()) return FALSE;
if((other_value.userCSGInformation().ispresent() ? !single_value->field_userCSGInformation.match((const UserCSGInformation&)other_value.userCSGInformation(), legacy) : !single_value->field_userCSGInformation.match_omit(legacy)))return FALSE;
if(!other_value.aPN__AMBR().is_bound()) return FALSE;
if((other_value.aPN__AMBR().ispresent() ? !single_value->field_aPN__AMBR.match((const APN__AMBR&)other_value.aPN__AMBR(), legacy) : !single_value->field_aPN__AMBR.match_omit(legacy)))return FALSE;
if(!other_value.signallingPriorityIndication().is_bound()) return FALSE;
if((other_value.signallingPriorityIndication().ispresent() ? !single_value->field_signallingPriorityIndication.match((const SignallingPriorityIndication&)other_value.signallingPriorityIndication(), legacy) : !single_value->field_signallingPriorityIndication.match_omit(legacy)))return FALSE;
if(!other_value.cN__OperatorSelectionEntity().is_bound()) return FALSE;
if((other_value.cN__OperatorSelectionEntity().ispresent() ? !single_value->field_cN__OperatorSelectionEntity.match((const CN__OperatorSelectionEntity&)other_value.cN__OperatorSelectionEntity(), legacy) : !single_value->field_cN__OperatorSelectionEntity.match_omit(legacy)))return FALSE;
if(!other_value.private__extension__gtpc().is_bound()) return FALSE;
if((other_value.private__extension__gtpc().ispresent() ? !single_value->field_private__extension__gtpc.match((const PrivateExtension__gtpc__List&)other_value.private__extension__gtpc(), legacy) : !single_value->field_private__extension__gtpc.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
}
return FALSE;
}

boolean UpdatePDPContextRequestSGSN_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_imsi.is_omit() || single_value->field_imsi.is_bound())
 || (single_value->field_rai.is_omit() || single_value->field_rai.is_bound())
 || (single_value->field_recovery.is_omit() || single_value->field_recovery.is_bound())
 || single_value->field_teidDataI.is_bound()
 || (single_value->field_teidControlPlane.is_omit() || single_value->field_teidControlPlane.is_bound())
 || single_value->field_nsapi.is_bound()
 || (single_value->field_trace__ref.is_omit() || single_value->field_trace__ref.is_bound())
 || (single_value->field_trace__type.is_omit() || single_value->field_trace__type.is_bound())
 || (single_value->field_protConfigOptions.is_omit() || single_value->field_protConfigOptions.is_bound())
 || single_value->field_sgsn__addr__controlPlane.is_bound()
 || single_value->field_sgsn__addr__traffic.is_bound()
 || (single_value->field_alt__ggsn__addr__controlPane.is_omit() || single_value->field_alt__ggsn__addr__controlPane.is_bound())
 || (single_value->field_alt__ggsn__addr__traffic.is_omit() || single_value->field_alt__ggsn__addr__traffic.is_bound())
 || single_value->field_qualityOfServiceProfile.is_bound()
 || (single_value->field_tft.is_omit() || single_value->field_tft.is_bound())
 || (single_value->field_triggerId.is_omit() || single_value->field_triggerId.is_bound())
 || (single_value->field_omcId.is_omit() || single_value->field_omcId.is_bound())
 || (single_value->field_commonFlags.is_omit() || single_value->field_commonFlags.is_bound())
 || (single_value->field_ratType.is_omit() || single_value->field_ratType.is_bound())
 || (single_value->field_userLocationInformation.is_omit() || single_value->field_userLocationInformation.is_bound())
 || (single_value->field_mS__TimeZone.is_omit() || single_value->field_mS__TimeZone.is_bound())
 || (single_value->field_additionalTraceInfo.is_omit() || single_value->field_additionalTraceInfo.is_bound())
 || (single_value->field_directTunnelFlags.is_omit() || single_value->field_directTunnelFlags.is_bound())
 || (single_value->field_evolvedAllocationRetentionPriorityI.is_omit() || single_value->field_evolvedAllocationRetentionPriorityI.is_bound())
 || (single_value->field_extendedCommonFlags.is_omit() || single_value->field_extendedCommonFlags.is_bound())
 || (single_value->field_userCSGInformation.is_omit() || single_value->field_userCSGInformation.is_bound())
 || (single_value->field_aPN__AMBR.is_omit() || single_value->field_aPN__AMBR.is_bound())
 || (single_value->field_signallingPriorityIndication.is_omit() || single_value->field_signallingPriorityIndication.is_bound())
 || (single_value->field_cN__OperatorSelectionEntity.is_omit() || single_value->field_cN__OperatorSelectionEntity.is_bound())
 || (single_value->field_private__extension__gtpc.is_omit() || single_value->field_private__extension__gtpc.is_bound());
}

boolean UpdatePDPContextRequestSGSN_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_imsi.is_omit() || single_value->field_imsi.is_value())
 && (single_value->field_rai.is_omit() || single_value->field_rai.is_value())
 && (single_value->field_recovery.is_omit() || single_value->field_recovery.is_value())
 && single_value->field_teidDataI.is_value()
 && (single_value->field_teidControlPlane.is_omit() || single_value->field_teidControlPlane.is_value())
 && single_value->field_nsapi.is_value()
 && (single_value->field_trace__ref.is_omit() || single_value->field_trace__ref.is_value())
 && (single_value->field_trace__type.is_omit() || single_value->field_trace__type.is_value())
 && (single_value->field_protConfigOptions.is_omit() || single_value->field_protConfigOptions.is_value())
 && single_value->field_sgsn__addr__controlPlane.is_value()
 && single_value->field_sgsn__addr__traffic.is_value()
 && (single_value->field_alt__ggsn__addr__controlPane.is_omit() || single_value->field_alt__ggsn__addr__controlPane.is_value())
 && (single_value->field_alt__ggsn__addr__traffic.is_omit() || single_value->field_alt__ggsn__addr__traffic.is_value())
 && single_value->field_qualityOfServiceProfile.is_value()
 && (single_value->field_tft.is_omit() || single_value->field_tft.is_value())
 && (single_value->field_triggerId.is_omit() || single_value->field_triggerId.is_value())
 && (single_value->field_omcId.is_omit() || single_value->field_omcId.is_value())
 && (single_value->field_commonFlags.is_omit() || single_value->field_commonFlags.is_value())
 && (single_value->field_ratType.is_omit() || single_value->field_ratType.is_value())
 && (single_value->field_userLocationInformation.is_omit() || single_value->field_userLocationInformation.is_value())
 && (single_value->field_mS__TimeZone.is_omit() || single_value->field_mS__TimeZone.is_value())
 && (single_value->field_additionalTraceInfo.is_omit() || single_value->field_additionalTraceInfo.is_value())
 && (single_value->field_directTunnelFlags.is_omit() || single_value->field_directTunnelFlags.is_value())
 && (single_value->field_evolvedAllocationRetentionPriorityI.is_omit() || single_value->field_evolvedAllocationRetentionPriorityI.is_value())
 && (single_value->field_extendedCommonFlags.is_omit() || single_value->field_extendedCommonFlags.is_value())
 && (single_value->field_userCSGInformation.is_omit() || single_value->field_userCSGInformation.is_value())
 && (single_value->field_aPN__AMBR.is_omit() || single_value->field_aPN__AMBR.is_value())
 && (single_value->field_signallingPriorityIndication.is_omit() || single_value->field_signallingPriorityIndication.is_value())
 && (single_value->field_cN__OperatorSelectionEntity.is_omit() || single_value->field_cN__OperatorSelectionEntity.is_value())
 && (single_value->field_private__extension__gtpc.is_omit() || single_value->field_private__extension__gtpc.is_value());
}

void UpdatePDPContextRequestSGSN_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

UpdatePDPContextRequestSGSN UpdatePDPContextRequestSGSN_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
UpdatePDPContextRequestSGSN ret_val;
if (single_value->field_imsi.is_omit()) ret_val.imsi() = OMIT_VALUE;
else if (single_value->field_imsi.is_bound()) {
ret_val.imsi() = single_value->field_imsi.valueof();
}
if (single_value->field_rai.is_omit()) ret_val.rai() = OMIT_VALUE;
else if (single_value->field_rai.is_bound()) {
ret_val.rai() = single_value->field_rai.valueof();
}
if (single_value->field_recovery.is_omit()) ret_val.recovery() = OMIT_VALUE;
else if (single_value->field_recovery.is_bound()) {
ret_val.recovery() = single_value->field_recovery.valueof();
}
if (single_value->field_teidDataI.is_bound()) {
ret_val.teidDataI() = single_value->field_teidDataI.valueof();
}
if (single_value->field_teidControlPlane.is_omit()) ret_val.teidControlPlane() = OMIT_VALUE;
else if (single_value->field_teidControlPlane.is_bound()) {
ret_val.teidControlPlane() = single_value->field_teidControlPlane.valueof();
}
if (single_value->field_nsapi.is_bound()) {
ret_val.nsapi() = single_value->field_nsapi.valueof();
}
if (single_value->field_trace__ref.is_omit()) ret_val.trace__ref() = OMIT_VALUE;
else if (single_value->field_trace__ref.is_bound()) {
ret_val.trace__ref() = single_value->field_trace__ref.valueof();
}
if (single_value->field_trace__type.is_omit()) ret_val.trace__type() = OMIT_VALUE;
else if (single_value->field_trace__type.is_bound()) {
ret_val.trace__type() = single_value->field_trace__type.valueof();
}
if (single_value->field_protConfigOptions.is_omit()) ret_val.protConfigOptions() = OMIT_VALUE;
else if (single_value->field_protConfigOptions.is_bound()) {
ret_val.protConfigOptions() = single_value->field_protConfigOptions.valueof();
}
if (single_value->field_sgsn__addr__controlPlane.is_bound()) {
ret_val.sgsn__addr__controlPlane() = single_value->field_sgsn__addr__controlPlane.valueof();
}
if (single_value->field_sgsn__addr__traffic.is_bound()) {
ret_val.sgsn__addr__traffic() = single_value->field_sgsn__addr__traffic.valueof();
}
if (single_value->field_alt__ggsn__addr__controlPane.is_omit()) ret_val.alt__ggsn__addr__controlPane() = OMIT_VALUE;
else if (single_value->field_alt__ggsn__addr__controlPane.is_bound()) {
ret_val.alt__ggsn__addr__controlPane() = single_value->field_alt__ggsn__addr__controlPane.valueof();
}
if (single_value->field_alt__ggsn__addr__traffic.is_omit()) ret_val.alt__ggsn__addr__traffic() = OMIT_VALUE;
else if (single_value->field_alt__ggsn__addr__traffic.is_bound()) {
ret_val.alt__ggsn__addr__traffic() = single_value->field_alt__ggsn__addr__traffic.valueof();
}
if (single_value->field_qualityOfServiceProfile.is_bound()) {
ret_val.qualityOfServiceProfile() = single_value->field_qualityOfServiceProfile.valueof();
}
if (single_value->field_tft.is_omit()) ret_val.tft() = OMIT_VALUE;
else if (single_value->field_tft.is_bound()) {
ret_val.tft() = single_value->field_tft.valueof();
}
if (single_value->field_triggerId.is_omit()) ret_val.triggerId() = OMIT_VALUE;
else if (single_value->field_triggerId.is_bound()) {
ret_val.triggerId() = single_value->field_triggerId.valueof();
}
if (single_value->field_omcId.is_omit()) ret_val.omcId() = OMIT_VALUE;
else if (single_value->field_omcId.is_bound()) {
ret_val.omcId() = single_value->field_omcId.valueof();
}
if (single_value->field_commonFlags.is_omit()) ret_val.commonFlags() = OMIT_VALUE;
else if (single_value->field_commonFlags.is_bound()) {
ret_val.commonFlags() = single_value->field_commonFlags.valueof();
}
if (single_value->field_ratType.is_omit()) ret_val.ratType() = OMIT_VALUE;
else if (single_value->field_ratType.is_bound()) {
ret_val.ratType() = single_value->field_ratType.valueof();
}
if (single_value->field_userLocationInformation.is_omit()) ret_val.userLocationInformation() = OMIT_VALUE;
else if (single_value->field_userLocationInformation.is_bound()) {
ret_val.userLocationInformation() = single_value->field_userLocationInformation.valueof();
}
if (single_value->field_mS__TimeZone.is_omit()) ret_val.mS__TimeZone() = OMIT_VALUE;
else if (single_value->field_mS__TimeZone.is_bound()) {
ret_val.mS__TimeZone() = single_value->field_mS__TimeZone.valueof();
}
if (single_value->field_additionalTraceInfo.is_omit()) ret_val.additionalTraceInfo() = OMIT_VALUE;
else if (single_value->field_additionalTraceInfo.is_bound()) {
ret_val.additionalTraceInfo() = single_value->field_additionalTraceInfo.valueof();
}
if (single_value->field_directTunnelFlags.is_omit()) ret_val.directTunnelFlags() = OMIT_VALUE;
else if (single_value->field_directTunnelFlags.is_bound()) {
ret_val.directTunnelFlags() = single_value->field_directTunnelFlags.valueof();
}
if (single_value->field_evolvedAllocationRetentionPriorityI.is_omit()) ret_val.evolvedAllocationRetentionPriorityI() = OMIT_VALUE;
else if (single_value->field_evolvedAllocationRetentionPriorityI.is_bound()) {
ret_val.evolvedAllocationRetentionPriorityI() = single_value->field_evolvedAllocationRetentionPriorityI.valueof();
}
if (single_value->field_extendedCommonFlags.is_omit()) ret_val.extendedCommonFlags() = OMIT_VALUE;
else if (single_value->field_extendedCommonFlags.is_bound()) {
ret_val.extendedCommonFlags() = single_value->field_extendedCommonFlags.valueof();
}
if (single_value->field_userCSGInformation.is_omit()) ret_val.userCSGInformation() = OMIT_VALUE;
else if (single_value->field_userCSGInformation.is_bound()) {
ret_val.userCSGInformation() = single_value->field_userCSGInformation.valueof();
}
if (single_value->field_aPN__AMBR.is_omit()) ret_val.aPN__AMBR() = OMIT_VALUE;
else if (single_value->field_aPN__AMBR.is_bound()) {
ret_val.aPN__AMBR() = single_value->field_aPN__AMBR.valueof();
}
if (single_value->field_signallingPriorityIndication.is_omit()) ret_val.signallingPriorityIndication() = OMIT_VALUE;
else if (single_value->field_signallingPriorityIndication.is_bound()) {
ret_val.signallingPriorityIndication() = single_value->field_signallingPriorityIndication.valueof();
}
if (single_value->field_cN__OperatorSelectionEntity.is_omit()) ret_val.cN__OperatorSelectionEntity() = OMIT_VALUE;
else if (single_value->field_cN__OperatorSelectionEntity.is_bound()) {
ret_val.cN__OperatorSelectionEntity() = single_value->field_cN__OperatorSelectionEntity.valueof();
}
if (single_value->field_private__extension__gtpc.is_omit()) ret_val.private__extension__gtpc() = OMIT_VALUE;
else if (single_value->field_private__extension__gtpc.is_bound()) {
ret_val.private__extension__gtpc() = single_value->field_private__extension__gtpc.valueof();
}
return ret_val;
}

void UpdatePDPContextRequestSGSN_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new UpdatePDPContextRequestSGSN_template[list_length];
}

UpdatePDPContextRequestSGSN_template& UpdatePDPContextRequestSGSN_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return value_list.list_value[list_index];
}

IMSI__gtpc_template& UpdatePDPContextRequestSGSN_template::imsi()
{
set_specific();
return single_value->field_imsi;
}

const IMSI__gtpc_template& UpdatePDPContextRequestSGSN_template::imsi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field imsi of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_imsi;
}

RoutingAreaIdentity_template& UpdatePDPContextRequestSGSN_template::rai()
{
set_specific();
return single_value->field_rai;
}

const RoutingAreaIdentity_template& UpdatePDPContextRequestSGSN_template::rai() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rai of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_rai;
}

Recovery__gtpc_template& UpdatePDPContextRequestSGSN_template::recovery()
{
set_specific();
return single_value->field_recovery;
}

const Recovery__gtpc_template& UpdatePDPContextRequestSGSN_template::recovery() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field recovery of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_recovery;
}

TeidDataI_template& UpdatePDPContextRequestSGSN_template::teidDataI()
{
set_specific();
return single_value->field_teidDataI;
}

const TeidDataI_template& UpdatePDPContextRequestSGSN_template::teidDataI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field teidDataI of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_teidDataI;
}

TeidControlPlane_template& UpdatePDPContextRequestSGSN_template::teidControlPlane()
{
set_specific();
return single_value->field_teidControlPlane;
}

const TeidControlPlane_template& UpdatePDPContextRequestSGSN_template::teidControlPlane() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field teidControlPlane of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_teidControlPlane;
}

NSAPI__GTPC_template& UpdatePDPContextRequestSGSN_template::nsapi()
{
set_specific();
return single_value->field_nsapi;
}

const NSAPI__GTPC_template& UpdatePDPContextRequestSGSN_template::nsapi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsapi of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_nsapi;
}

TraceRef_template& UpdatePDPContextRequestSGSN_template::trace__ref()
{
set_specific();
return single_value->field_trace__ref;
}

const TraceRef_template& UpdatePDPContextRequestSGSN_template::trace__ref() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field trace_ref of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_trace__ref;
}

GTP__TraceType_template& UpdatePDPContextRequestSGSN_template::trace__type()
{
set_specific();
return single_value->field_trace__type;
}

const GTP__TraceType_template& UpdatePDPContextRequestSGSN_template::trace__type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field trace_type of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_trace__type;
}

ProtConfigOptions_template& UpdatePDPContextRequestSGSN_template::protConfigOptions()
{
set_specific();
return single_value->field_protConfigOptions;
}

const ProtConfigOptions_template& UpdatePDPContextRequestSGSN_template::protConfigOptions() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field protConfigOptions of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_protConfigOptions;
}

GSN__Address__GTPC_template& UpdatePDPContextRequestSGSN_template::sgsn__addr__controlPlane()
{
set_specific();
return single_value->field_sgsn__addr__controlPlane;
}

const GSN__Address__GTPC_template& UpdatePDPContextRequestSGSN_template::sgsn__addr__controlPlane() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sgsn_addr_controlPlane of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_sgsn__addr__controlPlane;
}

GSN__Address__GTPC_template& UpdatePDPContextRequestSGSN_template::sgsn__addr__traffic()
{
set_specific();
return single_value->field_sgsn__addr__traffic;
}

const GSN__Address__GTPC_template& UpdatePDPContextRequestSGSN_template::sgsn__addr__traffic() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sgsn_addr_traffic of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_sgsn__addr__traffic;
}

GSN__Address__GTPC_template& UpdatePDPContextRequestSGSN_template::alt__ggsn__addr__controlPane()
{
set_specific();
return single_value->field_alt__ggsn__addr__controlPane;
}

const GSN__Address__GTPC_template& UpdatePDPContextRequestSGSN_template::alt__ggsn__addr__controlPane() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field alt_ggsn_addr_controlPane of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_alt__ggsn__addr__controlPane;
}

GSN__Address__GTPC_template& UpdatePDPContextRequestSGSN_template::alt__ggsn__addr__traffic()
{
set_specific();
return single_value->field_alt__ggsn__addr__traffic;
}

const GSN__Address__GTPC_template& UpdatePDPContextRequestSGSN_template::alt__ggsn__addr__traffic() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field alt_ggsn_addr_traffic of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_alt__ggsn__addr__traffic;
}

QualityOfServiceProfile_template& UpdatePDPContextRequestSGSN_template::qualityOfServiceProfile()
{
set_specific();
return single_value->field_qualityOfServiceProfile;
}

const QualityOfServiceProfile_template& UpdatePDPContextRequestSGSN_template::qualityOfServiceProfile() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field qualityOfServiceProfile of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_qualityOfServiceProfile;
}

TrafficFlowTemplate_template& UpdatePDPContextRequestSGSN_template::tft()
{
set_specific();
return single_value->field_tft;
}

const TrafficFlowTemplate_template& UpdatePDPContextRequestSGSN_template::tft() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tft of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_tft;
}

GTP__TriggerID_template& UpdatePDPContextRequestSGSN_template::triggerId()
{
set_specific();
return single_value->field_triggerId;
}

const GTP__TriggerID_template& UpdatePDPContextRequestSGSN_template::triggerId() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field triggerId of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_triggerId;
}

OMCIdentity_template& UpdatePDPContextRequestSGSN_template::omcId()
{
set_specific();
return single_value->field_omcId;
}

const OMCIdentity_template& UpdatePDPContextRequestSGSN_template::omcId() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field omcId of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_omcId;
}

CommonFlags_template& UpdatePDPContextRequestSGSN_template::commonFlags()
{
set_specific();
return single_value->field_commonFlags;
}

const CommonFlags_template& UpdatePDPContextRequestSGSN_template::commonFlags() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field commonFlags of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_commonFlags;
}

RATType_template& UpdatePDPContextRequestSGSN_template::ratType()
{
set_specific();
return single_value->field_ratType;
}

const RATType_template& UpdatePDPContextRequestSGSN_template::ratType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ratType of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_ratType;
}

UserLocationInformation_template& UpdatePDPContextRequestSGSN_template::userLocationInformation()
{
set_specific();
return single_value->field_userLocationInformation;
}

const UserLocationInformation_template& UpdatePDPContextRequestSGSN_template::userLocationInformation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field userLocationInformation of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_userLocationInformation;
}

MS__TimeZone_template& UpdatePDPContextRequestSGSN_template::mS__TimeZone()
{
set_specific();
return single_value->field_mS__TimeZone;
}

const MS__TimeZone_template& UpdatePDPContextRequestSGSN_template::mS__TimeZone() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mS_TimeZone of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_mS__TimeZone;
}

AdditionalTraceInfo_template& UpdatePDPContextRequestSGSN_template::additionalTraceInfo()
{
set_specific();
return single_value->field_additionalTraceInfo;
}

const AdditionalTraceInfo_template& UpdatePDPContextRequestSGSN_template::additionalTraceInfo() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field additionalTraceInfo of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_additionalTraceInfo;
}

DirectTunnelFlags_template& UpdatePDPContextRequestSGSN_template::directTunnelFlags()
{
set_specific();
return single_value->field_directTunnelFlags;
}

const DirectTunnelFlags_template& UpdatePDPContextRequestSGSN_template::directTunnelFlags() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field directTunnelFlags of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_directTunnelFlags;
}

EvolvedAllocationRetentionPriorityI_template& UpdatePDPContextRequestSGSN_template::evolvedAllocationRetentionPriorityI()
{
set_specific();
return single_value->field_evolvedAllocationRetentionPriorityI;
}

const EvolvedAllocationRetentionPriorityI_template& UpdatePDPContextRequestSGSN_template::evolvedAllocationRetentionPriorityI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field evolvedAllocationRetentionPriorityI of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_evolvedAllocationRetentionPriorityI;
}

ExtendedCommonFlags_template& UpdatePDPContextRequestSGSN_template::extendedCommonFlags()
{
set_specific();
return single_value->field_extendedCommonFlags;
}

const ExtendedCommonFlags_template& UpdatePDPContextRequestSGSN_template::extendedCommonFlags() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extendedCommonFlags of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_extendedCommonFlags;
}

UserCSGInformation_template& UpdatePDPContextRequestSGSN_template::userCSGInformation()
{
set_specific();
return single_value->field_userCSGInformation;
}

const UserCSGInformation_template& UpdatePDPContextRequestSGSN_template::userCSGInformation() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field userCSGInformation of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_userCSGInformation;
}

APN__AMBR_template& UpdatePDPContextRequestSGSN_template::aPN__AMBR()
{
set_specific();
return single_value->field_aPN__AMBR;
}

const APN__AMBR_template& UpdatePDPContextRequestSGSN_template::aPN__AMBR() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field aPN_AMBR of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_aPN__AMBR;
}

SignallingPriorityIndication_template& UpdatePDPContextRequestSGSN_template::signallingPriorityIndication()
{
set_specific();
return single_value->field_signallingPriorityIndication;
}

const SignallingPriorityIndication_template& UpdatePDPContextRequestSGSN_template::signallingPriorityIndication() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field signallingPriorityIndication of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_signallingPriorityIndication;
}

CN__OperatorSelectionEntity_template& UpdatePDPContextRequestSGSN_template::cN__OperatorSelectionEntity()
{
set_specific();
return single_value->field_cN__OperatorSelectionEntity;
}

const CN__OperatorSelectionEntity_template& UpdatePDPContextRequestSGSN_template::cN__OperatorSelectionEntity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cN_OperatorSelectionEntity of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_cN__OperatorSelectionEntity;
}

PrivateExtension__gtpc__List_template& UpdatePDPContextRequestSGSN_template::private__extension__gtpc()
{
set_specific();
return single_value->field_private__extension__gtpc;
}

const PrivateExtension__gtpc__List_template& UpdatePDPContextRequestSGSN_template::private__extension__gtpc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field private_extension_gtpc of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
return single_value->field_private__extension__gtpc;
}

int UpdatePDPContextRequestSGSN_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.UpdatePDPContextRequestSGSN which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 5;
      if (single_value->field_imsi.is_present()) ret_val++;
      if (single_value->field_rai.is_present()) ret_val++;
      if (single_value->field_recovery.is_present()) ret_val++;
      if (single_value->field_teidControlPlane.is_present()) ret_val++;
      if (single_value->field_trace__ref.is_present()) ret_val++;
      if (single_value->field_trace__type.is_present()) ret_val++;
      if (single_value->field_protConfigOptions.is_present()) ret_val++;
      if (single_value->field_alt__ggsn__addr__controlPane.is_present()) ret_val++;
      if (single_value->field_alt__ggsn__addr__traffic.is_present()) ret_val++;
      if (single_value->field_tft.is_present()) ret_val++;
      if (single_value->field_triggerId.is_present()) ret_val++;
      if (single_value->field_omcId.is_present()) ret_val++;
      if (single_value->field_commonFlags.is_present()) ret_val++;
      if (single_value->field_ratType.is_present()) ret_val++;
      if (single_value->field_userLocationInformation.is_present()) ret_val++;
      if (single_value->field_mS__TimeZone.is_present()) ret_val++;
      if (single_value->field_additionalTraceInfo.is_present()) ret_val++;
      if (single_value->field_directTunnelFlags.is_present()) ret_val++;
      if (single_value->field_evolvedAllocationRetentionPriorityI.is_present()) ret_val++;
      if (single_value->field_extendedCommonFlags.is_present()) ret_val++;
      if (single_value->field_userCSGInformation.is_present()) ret_val++;
      if (single_value->field_aPN__AMBR.is_present()) ret_val++;
      if (single_value->field_signallingPriorityIndication.is_present()) ret_val++;
      if (single_value->field_cN__OperatorSelectionEntity.is_present()) ret_val++;
      if (single_value->field_private__extension__gtpc.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.UpdatePDPContextRequestSGSN containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.UpdatePDPContextRequestSGSN containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.UpdatePDPContextRequestSGSN containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.UpdatePDPContextRequestSGSN containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.UpdatePDPContextRequestSGSN containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.UpdatePDPContextRequestSGSN containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.UpdatePDPContextRequestSGSN containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.UpdatePDPContextRequestSGSN containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
  }
  return 0;
}

void UpdatePDPContextRequestSGSN_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ imsi := ");
single_value->field_imsi.log();
TTCN_Logger::log_event_str(", rai := ");
single_value->field_rai.log();
TTCN_Logger::log_event_str(", recovery := ");
single_value->field_recovery.log();
TTCN_Logger::log_event_str(", teidDataI := ");
single_value->field_teidDataI.log();
TTCN_Logger::log_event_str(", teidControlPlane := ");
single_value->field_teidControlPlane.log();
TTCN_Logger::log_event_str(", nsapi := ");
single_value->field_nsapi.log();
TTCN_Logger::log_event_str(", trace_ref := ");
single_value->field_trace__ref.log();
TTCN_Logger::log_event_str(", trace_type := ");
single_value->field_trace__type.log();
TTCN_Logger::log_event_str(", protConfigOptions := ");
single_value->field_protConfigOptions.log();
TTCN_Logger::log_event_str(", sgsn_addr_controlPlane := ");
single_value->field_sgsn__addr__controlPlane.log();
TTCN_Logger::log_event_str(", sgsn_addr_traffic := ");
single_value->field_sgsn__addr__traffic.log();
TTCN_Logger::log_event_str(", alt_ggsn_addr_controlPane := ");
single_value->field_alt__ggsn__addr__controlPane.log();
TTCN_Logger::log_event_str(", alt_ggsn_addr_traffic := ");
single_value->field_alt__ggsn__addr__traffic.log();
TTCN_Logger::log_event_str(", qualityOfServiceProfile := ");
single_value->field_qualityOfServiceProfile.log();
TTCN_Logger::log_event_str(", tft := ");
single_value->field_tft.log();
TTCN_Logger::log_event_str(", triggerId := ");
single_value->field_triggerId.log();
TTCN_Logger::log_event_str(", omcId := ");
single_value->field_omcId.log();
TTCN_Logger::log_event_str(", commonFlags := ");
single_value->field_commonFlags.log();
TTCN_Logger::log_event_str(", ratType := ");
single_value->field_ratType.log();
TTCN_Logger::log_event_str(", userLocationInformation := ");
single_value->field_userLocationInformation.log();
TTCN_Logger::log_event_str(", mS_TimeZone := ");
single_value->field_mS__TimeZone.log();
TTCN_Logger::log_event_str(", additionalTraceInfo := ");
single_value->field_additionalTraceInfo.log();
TTCN_Logger::log_event_str(", directTunnelFlags := ");
single_value->field_directTunnelFlags.log();
TTCN_Logger::log_event_str(", evolvedAllocationRetentionPriorityI := ");
single_value->field_evolvedAllocationRetentionPriorityI.log();
TTCN_Logger::log_event_str(", extendedCommonFlags := ");
single_value->field_extendedCommonFlags.log();
TTCN_Logger::log_event_str(", userCSGInformation := ");
single_value->field_userCSGInformation.log();
TTCN_Logger::log_event_str(", aPN_AMBR := ");
single_value->field_aPN__AMBR.log();
TTCN_Logger::log_event_str(", signallingPriorityIndication := ");
single_value->field_signallingPriorityIndication.log();
TTCN_Logger::log_event_str(", cN_OperatorSelectionEntity := ");
single_value->field_cN__OperatorSelectionEntity.log();
TTCN_Logger::log_event_str(", private_extension_gtpc := ");
single_value->field_private__extension__gtpc.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void UpdatePDPContextRequestSGSN_template::log_match(const UpdatePDPContextRequestSGSN& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.imsi().ispresent()){
if(!single_value->field_imsi.match(match_value.imsi(), legacy)){
TTCN_Logger::log_logmatch_info(".imsi");
single_value->field_imsi.log_match(match_value.imsi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_imsi.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".imsi := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_imsi.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.rai().ispresent()){
if(!single_value->field_rai.match(match_value.rai(), legacy)){
TTCN_Logger::log_logmatch_info(".rai");
single_value->field_rai.log_match(match_value.rai(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_rai.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".rai := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_rai.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.recovery().ispresent()){
if(!single_value->field_recovery.match(match_value.recovery(), legacy)){
TTCN_Logger::log_logmatch_info(".recovery");
single_value->field_recovery.log_match(match_value.recovery(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_recovery.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".recovery := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_recovery.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_teidDataI.match(match_value.teidDataI(), legacy)){
TTCN_Logger::log_logmatch_info(".teidDataI");
single_value->field_teidDataI.log_match(match_value.teidDataI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.teidControlPlane().ispresent()){
if(!single_value->field_teidControlPlane.match(match_value.teidControlPlane(), legacy)){
TTCN_Logger::log_logmatch_info(".teidControlPlane");
single_value->field_teidControlPlane.log_match(match_value.teidControlPlane(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_teidControlPlane.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".teidControlPlane := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_teidControlPlane.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_nsapi.match(match_value.nsapi(), legacy)){
TTCN_Logger::log_logmatch_info(".nsapi");
single_value->field_nsapi.log_match(match_value.nsapi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.trace__ref().ispresent()){
if(!single_value->field_trace__ref.match(match_value.trace__ref(), legacy)){
TTCN_Logger::log_logmatch_info(".trace_ref");
single_value->field_trace__ref.log_match(match_value.trace__ref(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_trace__ref.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".trace_ref := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_trace__ref.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.trace__type().ispresent()){
if(!single_value->field_trace__type.match(match_value.trace__type(), legacy)){
TTCN_Logger::log_logmatch_info(".trace_type");
single_value->field_trace__type.log_match(match_value.trace__type(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_trace__type.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".trace_type := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_trace__type.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.protConfigOptions().ispresent()){
if(!single_value->field_protConfigOptions.match(match_value.protConfigOptions(), legacy)){
TTCN_Logger::log_logmatch_info(".protConfigOptions");
single_value->field_protConfigOptions.log_match(match_value.protConfigOptions(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_protConfigOptions.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".protConfigOptions := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_protConfigOptions.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_sgsn__addr__controlPlane.match(match_value.sgsn__addr__controlPlane(), legacy)){
TTCN_Logger::log_logmatch_info(".sgsn_addr_controlPlane");
single_value->field_sgsn__addr__controlPlane.log_match(match_value.sgsn__addr__controlPlane(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sgsn__addr__traffic.match(match_value.sgsn__addr__traffic(), legacy)){
TTCN_Logger::log_logmatch_info(".sgsn_addr_traffic");
single_value->field_sgsn__addr__traffic.log_match(match_value.sgsn__addr__traffic(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.alt__ggsn__addr__controlPane().ispresent()){
if(!single_value->field_alt__ggsn__addr__controlPane.match(match_value.alt__ggsn__addr__controlPane(), legacy)){
TTCN_Logger::log_logmatch_info(".alt_ggsn_addr_controlPane");
single_value->field_alt__ggsn__addr__controlPane.log_match(match_value.alt__ggsn__addr__controlPane(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_alt__ggsn__addr__controlPane.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".alt_ggsn_addr_controlPane := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_alt__ggsn__addr__controlPane.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.alt__ggsn__addr__traffic().ispresent()){
if(!single_value->field_alt__ggsn__addr__traffic.match(match_value.alt__ggsn__addr__traffic(), legacy)){
TTCN_Logger::log_logmatch_info(".alt_ggsn_addr_traffic");
single_value->field_alt__ggsn__addr__traffic.log_match(match_value.alt__ggsn__addr__traffic(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_alt__ggsn__addr__traffic.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".alt_ggsn_addr_traffic := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_alt__ggsn__addr__traffic.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_qualityOfServiceProfile.match(match_value.qualityOfServiceProfile(), legacy)){
TTCN_Logger::log_logmatch_info(".qualityOfServiceProfile");
single_value->field_qualityOfServiceProfile.log_match(match_value.qualityOfServiceProfile(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.tft().ispresent()){
if(!single_value->field_tft.match(match_value.tft(), legacy)){
TTCN_Logger::log_logmatch_info(".tft");
single_value->field_tft.log_match(match_value.tft(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_tft.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".tft := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_tft.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.triggerId().ispresent()){
if(!single_value->field_triggerId.match(match_value.triggerId(), legacy)){
TTCN_Logger::log_logmatch_info(".triggerId");
single_value->field_triggerId.log_match(match_value.triggerId(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_triggerId.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".triggerId := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_triggerId.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.omcId().ispresent()){
if(!single_value->field_omcId.match(match_value.omcId(), legacy)){
TTCN_Logger::log_logmatch_info(".omcId");
single_value->field_omcId.log_match(match_value.omcId(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_omcId.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".omcId := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_omcId.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.commonFlags().ispresent()){
if(!single_value->field_commonFlags.match(match_value.commonFlags(), legacy)){
TTCN_Logger::log_logmatch_info(".commonFlags");
single_value->field_commonFlags.log_match(match_value.commonFlags(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_commonFlags.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".commonFlags := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_commonFlags.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.ratType().ispresent()){
if(!single_value->field_ratType.match(match_value.ratType(), legacy)){
TTCN_Logger::log_logmatch_info(".ratType");
single_value->field_ratType.log_match(match_value.ratType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_ratType.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".ratType := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_ratType.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.userLocationInformation().ispresent()){
if(!single_value->field_userLocationInformation.match(match_value.userLocationInformation(), legacy)){
TTCN_Logger::log_logmatch_info(".userLocationInformation");
single_value->field_userLocationInformation.log_match(match_value.userLocationInformation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_userLocationInformation.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".userLocationInformation := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_userLocationInformation.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.mS__TimeZone().ispresent()){
if(!single_value->field_mS__TimeZone.match(match_value.mS__TimeZone(), legacy)){
TTCN_Logger::log_logmatch_info(".mS_TimeZone");
single_value->field_mS__TimeZone.log_match(match_value.mS__TimeZone(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_mS__TimeZone.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".mS_TimeZone := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_mS__TimeZone.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.additionalTraceInfo().ispresent()){
if(!single_value->field_additionalTraceInfo.match(match_value.additionalTraceInfo(), legacy)){
TTCN_Logger::log_logmatch_info(".additionalTraceInfo");
single_value->field_additionalTraceInfo.log_match(match_value.additionalTraceInfo(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_additionalTraceInfo.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".additionalTraceInfo := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_additionalTraceInfo.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.directTunnelFlags().ispresent()){
if(!single_value->field_directTunnelFlags.match(match_value.directTunnelFlags(), legacy)){
TTCN_Logger::log_logmatch_info(".directTunnelFlags");
single_value->field_directTunnelFlags.log_match(match_value.directTunnelFlags(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_directTunnelFlags.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".directTunnelFlags := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_directTunnelFlags.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.evolvedAllocationRetentionPriorityI().ispresent()){
if(!single_value->field_evolvedAllocationRetentionPriorityI.match(match_value.evolvedAllocationRetentionPriorityI(), legacy)){
TTCN_Logger::log_logmatch_info(".evolvedAllocationRetentionPriorityI");
single_value->field_evolvedAllocationRetentionPriorityI.log_match(match_value.evolvedAllocationRetentionPriorityI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_evolvedAllocationRetentionPriorityI.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".evolvedAllocationRetentionPriorityI := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_evolvedAllocationRetentionPriorityI.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.extendedCommonFlags().ispresent()){
if(!single_value->field_extendedCommonFlags.match(match_value.extendedCommonFlags(), legacy)){
TTCN_Logger::log_logmatch_info(".extendedCommonFlags");
single_value->field_extendedCommonFlags.log_match(match_value.extendedCommonFlags(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extendedCommonFlags.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extendedCommonFlags := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extendedCommonFlags.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.userCSGInformation().ispresent()){
if(!single_value->field_userCSGInformation.match(match_value.userCSGInformation(), legacy)){
TTCN_Logger::log_logmatch_info(".userCSGInformation");
single_value->field_userCSGInformation.log_match(match_value.userCSGInformation(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_userCSGInformation.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".userCSGInformation := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_userCSGInformation.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.aPN__AMBR().ispresent()){
if(!single_value->field_aPN__AMBR.match(match_value.aPN__AMBR(), legacy)){
TTCN_Logger::log_logmatch_info(".aPN_AMBR");
single_value->field_aPN__AMBR.log_match(match_value.aPN__AMBR(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_aPN__AMBR.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".aPN_AMBR := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_aPN__AMBR.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.signallingPriorityIndication().ispresent()){
if(!single_value->field_signallingPriorityIndication.match(match_value.signallingPriorityIndication(), legacy)){
TTCN_Logger::log_logmatch_info(".signallingPriorityIndication");
single_value->field_signallingPriorityIndication.log_match(match_value.signallingPriorityIndication(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_signallingPriorityIndication.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".signallingPriorityIndication := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_signallingPriorityIndication.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.cN__OperatorSelectionEntity().ispresent()){
if(!single_value->field_cN__OperatorSelectionEntity.match(match_value.cN__OperatorSelectionEntity(), legacy)){
TTCN_Logger::log_logmatch_info(".cN_OperatorSelectionEntity");
single_value->field_cN__OperatorSelectionEntity.log_match(match_value.cN__OperatorSelectionEntity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_cN__OperatorSelectionEntity.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".cN_OperatorSelectionEntity := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_cN__OperatorSelectionEntity.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.private__extension__gtpc().ispresent()){
if(!single_value->field_private__extension__gtpc.match(match_value.private__extension__gtpc(), legacy)){
TTCN_Logger::log_logmatch_info(".private_extension_gtpc");
single_value->field_private__extension__gtpc.log_match(match_value.private__extension__gtpc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_private__extension__gtpc.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".private_extension_gtpc := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_private__extension__gtpc.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ imsi := ");
if (match_value.imsi().ispresent()) {
single_value->field_imsi.log_match(match_value.imsi(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_imsi.log();
if (single_value->field_imsi.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", rai := ");
if (match_value.rai().ispresent()) {
single_value->field_rai.log_match(match_value.rai(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_rai.log();
if (single_value->field_rai.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", recovery := ");
if (match_value.recovery().ispresent()) {
single_value->field_recovery.log_match(match_value.recovery(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_recovery.log();
if (single_value->field_recovery.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", teidDataI := ");
single_value->field_teidDataI.log_match(match_value.teidDataI(), legacy);
TTCN_Logger::log_event_str(", teidControlPlane := ");
if (match_value.teidControlPlane().ispresent()) {
single_value->field_teidControlPlane.log_match(match_value.teidControlPlane(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_teidControlPlane.log();
if (single_value->field_teidControlPlane.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", nsapi := ");
single_value->field_nsapi.log_match(match_value.nsapi(), legacy);
TTCN_Logger::log_event_str(", trace_ref := ");
if (match_value.trace__ref().ispresent()) {
single_value->field_trace__ref.log_match(match_value.trace__ref(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_trace__ref.log();
if (single_value->field_trace__ref.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", trace_type := ");
if (match_value.trace__type().ispresent()) {
single_value->field_trace__type.log_match(match_value.trace__type(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_trace__type.log();
if (single_value->field_trace__type.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", protConfigOptions := ");
if (match_value.protConfigOptions().ispresent()) {
single_value->field_protConfigOptions.log_match(match_value.protConfigOptions(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_protConfigOptions.log();
if (single_value->field_protConfigOptions.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", sgsn_addr_controlPlane := ");
single_value->field_sgsn__addr__controlPlane.log_match(match_value.sgsn__addr__controlPlane(), legacy);
TTCN_Logger::log_event_str(", sgsn_addr_traffic := ");
single_value->field_sgsn__addr__traffic.log_match(match_value.sgsn__addr__traffic(), legacy);
TTCN_Logger::log_event_str(", alt_ggsn_addr_controlPane := ");
if (match_value.alt__ggsn__addr__controlPane().ispresent()) {
single_value->field_alt__ggsn__addr__controlPane.log_match(match_value.alt__ggsn__addr__controlPane(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_alt__ggsn__addr__controlPane.log();
if (single_value->field_alt__ggsn__addr__controlPane.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", alt_ggsn_addr_traffic := ");
if (match_value.alt__ggsn__addr__traffic().ispresent()) {
single_value->field_alt__ggsn__addr__traffic.log_match(match_value.alt__ggsn__addr__traffic(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_alt__ggsn__addr__traffic.log();
if (single_value->field_alt__ggsn__addr__traffic.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", qualityOfServiceProfile := ");
single_value->field_qualityOfServiceProfile.log_match(match_value.qualityOfServiceProfile(), legacy);
TTCN_Logger::log_event_str(", tft := ");
if (match_value.tft().ispresent()) {
single_value->field_tft.log_match(match_value.tft(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_tft.log();
if (single_value->field_tft.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", triggerId := ");
if (match_value.triggerId().ispresent()) {
single_value->field_triggerId.log_match(match_value.triggerId(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_triggerId.log();
if (single_value->field_triggerId.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", omcId := ");
if (match_value.omcId().ispresent()) {
single_value->field_omcId.log_match(match_value.omcId(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_omcId.log();
if (single_value->field_omcId.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", commonFlags := ");
if (match_value.commonFlags().ispresent()) {
single_value->field_commonFlags.log_match(match_value.commonFlags(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_commonFlags.log();
if (single_value->field_commonFlags.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", ratType := ");
if (match_value.ratType().ispresent()) {
single_value->field_ratType.log_match(match_value.ratType(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_ratType.log();
if (single_value->field_ratType.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", userLocationInformation := ");
if (match_value.userLocationInformation().ispresent()) {
single_value->field_userLocationInformation.log_match(match_value.userLocationInformation(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_userLocationInformation.log();
if (single_value->field_userLocationInformation.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", mS_TimeZone := ");
if (match_value.mS__TimeZone().ispresent()) {
single_value->field_mS__TimeZone.log_match(match_value.mS__TimeZone(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_mS__TimeZone.log();
if (single_value->field_mS__TimeZone.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", additionalTraceInfo := ");
if (match_value.additionalTraceInfo().ispresent()) {
single_value->field_additionalTraceInfo.log_match(match_value.additionalTraceInfo(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_additionalTraceInfo.log();
if (single_value->field_additionalTraceInfo.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", directTunnelFlags := ");
if (match_value.directTunnelFlags().ispresent()) {
single_value->field_directTunnelFlags.log_match(match_value.directTunnelFlags(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_directTunnelFlags.log();
if (single_value->field_directTunnelFlags.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", evolvedAllocationRetentionPriorityI := ");
if (match_value.evolvedAllocationRetentionPriorityI().ispresent()) {
single_value->field_evolvedAllocationRetentionPriorityI.log_match(match_value.evolvedAllocationRetentionPriorityI(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_evolvedAllocationRetentionPriorityI.log();
if (single_value->field_evolvedAllocationRetentionPriorityI.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", extendedCommonFlags := ");
if (match_value.extendedCommonFlags().ispresent()) {
single_value->field_extendedCommonFlags.log_match(match_value.extendedCommonFlags(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extendedCommonFlags.log();
if (single_value->field_extendedCommonFlags.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", userCSGInformation := ");
if (match_value.userCSGInformation().ispresent()) {
single_value->field_userCSGInformation.log_match(match_value.userCSGInformation(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_userCSGInformation.log();
if (single_value->field_userCSGInformation.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", aPN_AMBR := ");
if (match_value.aPN__AMBR().ispresent()) {
single_value->field_aPN__AMBR.log_match(match_value.aPN__AMBR(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_aPN__AMBR.log();
if (single_value->field_aPN__AMBR.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", signallingPriorityIndication := ");
if (match_value.signallingPriorityIndication().ispresent()) {
single_value->field_signallingPriorityIndication.log_match(match_value.signallingPriorityIndication(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_signallingPriorityIndication.log();
if (single_value->field_signallingPriorityIndication.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", cN_OperatorSelectionEntity := ");
if (match_value.cN__OperatorSelectionEntity().ispresent()) {
single_value->field_cN__OperatorSelectionEntity.log_match(match_value.cN__OperatorSelectionEntity(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_cN__OperatorSelectionEntity.log();
if (single_value->field_cN__OperatorSelectionEntity.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", private_extension_gtpc := ");
if (match_value.private__extension__gtpc().ispresent()) {
single_value->field_private__extension__gtpc.log_match(match_value.private__extension__gtpc(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_private__extension__gtpc.log();
if (single_value->field_private__extension__gtpc.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void UpdatePDPContextRequestSGSN_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!imsi().is_bound()) imsi() = OMIT_VALUE;
else imsi().set_implicit_omit();
if (!rai().is_bound()) rai() = OMIT_VALUE;
else rai().set_implicit_omit();
if (!recovery().is_bound()) recovery() = OMIT_VALUE;
else recovery().set_implicit_omit();
if (teidDataI().is_bound()) teidDataI().set_implicit_omit();
if (!teidControlPlane().is_bound()) teidControlPlane() = OMIT_VALUE;
else teidControlPlane().set_implicit_omit();
if (nsapi().is_bound()) nsapi().set_implicit_omit();
if (!trace__ref().is_bound()) trace__ref() = OMIT_VALUE;
else trace__ref().set_implicit_omit();
if (!trace__type().is_bound()) trace__type() = OMIT_VALUE;
else trace__type().set_implicit_omit();
if (!protConfigOptions().is_bound()) protConfigOptions() = OMIT_VALUE;
else protConfigOptions().set_implicit_omit();
if (sgsn__addr__controlPlane().is_bound()) sgsn__addr__controlPlane().set_implicit_omit();
if (sgsn__addr__traffic().is_bound()) sgsn__addr__traffic().set_implicit_omit();
if (!alt__ggsn__addr__controlPane().is_bound()) alt__ggsn__addr__controlPane() = OMIT_VALUE;
else alt__ggsn__addr__controlPane().set_implicit_omit();
if (!alt__ggsn__addr__traffic().is_bound()) alt__ggsn__addr__traffic() = OMIT_VALUE;
else alt__ggsn__addr__traffic().set_implicit_omit();
if (qualityOfServiceProfile().is_bound()) qualityOfServiceProfile().set_implicit_omit();
if (!tft().is_bound()) tft() = OMIT_VALUE;
else tft().set_implicit_omit();
if (!triggerId().is_bound()) triggerId() = OMIT_VALUE;
else triggerId().set_implicit_omit();
if (!omcId().is_bound()) omcId() = OMIT_VALUE;
else omcId().set_implicit_omit();
if (!commonFlags().is_bound()) commonFlags() = OMIT_VALUE;
else commonFlags().set_implicit_omit();
if (!ratType().is_bound()) ratType() = OMIT_VALUE;
else ratType().set_implicit_omit();
if (!userLocationInformation().is_bound()) userLocationInformation() = OMIT_VALUE;
else userLocationInformation().set_implicit_omit();
if (!mS__TimeZone().is_bound()) mS__TimeZone() = OMIT_VALUE;
else mS__TimeZone().set_implicit_omit();
if (!additionalTraceInfo().is_bound()) additionalTraceInfo() = OMIT_VALUE;
else additionalTraceInfo().set_implicit_omit();
if (!directTunnelFlags().is_bound()) directTunnelFlags() = OMIT_VALUE;
else directTunnelFlags().set_implicit_omit();
if (!evolvedAllocationRetentionPriorityI().is_bound()) evolvedAllocationRetentionPriorityI() = OMIT_VALUE;
else evolvedAllocationRetentionPriorityI().set_implicit_omit();
if (!extendedCommonFlags().is_bound()) extendedCommonFlags() = OMIT_VALUE;
else extendedCommonFlags().set_implicit_omit();
if (!userCSGInformation().is_bound()) userCSGInformation() = OMIT_VALUE;
else userCSGInformation().set_implicit_omit();
if (!aPN__AMBR().is_bound()) aPN__AMBR() = OMIT_VALUE;
else aPN__AMBR().set_implicit_omit();
if (!signallingPriorityIndication().is_bound()) signallingPriorityIndication() = OMIT_VALUE;
else signallingPriorityIndication().set_implicit_omit();
if (!cN__OperatorSelectionEntity().is_bound()) cN__OperatorSelectionEntity() = OMIT_VALUE;
else cN__OperatorSelectionEntity().set_implicit_omit();
if (!private__extension__gtpc().is_bound()) private__extension__gtpc() = OMIT_VALUE;
else private__extension__gtpc().set_implicit_omit();
}

void UpdatePDPContextRequestSGSN_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_imsi.encode_text(text_buf);
single_value->field_rai.encode_text(text_buf);
single_value->field_recovery.encode_text(text_buf);
single_value->field_teidDataI.encode_text(text_buf);
single_value->field_teidControlPlane.encode_text(text_buf);
single_value->field_nsapi.encode_text(text_buf);
single_value->field_trace__ref.encode_text(text_buf);
single_value->field_trace__type.encode_text(text_buf);
single_value->field_protConfigOptions.encode_text(text_buf);
single_value->field_sgsn__addr__controlPlane.encode_text(text_buf);
single_value->field_sgsn__addr__traffic.encode_text(text_buf);
single_value->field_alt__ggsn__addr__controlPane.encode_text(text_buf);
single_value->field_alt__ggsn__addr__traffic.encode_text(text_buf);
single_value->field_qualityOfServiceProfile.encode_text(text_buf);
single_value->field_tft.encode_text(text_buf);
single_value->field_triggerId.encode_text(text_buf);
single_value->field_omcId.encode_text(text_buf);
single_value->field_commonFlags.encode_text(text_buf);
single_value->field_ratType.encode_text(text_buf);
single_value->field_userLocationInformation.encode_text(text_buf);
single_value->field_mS__TimeZone.encode_text(text_buf);
single_value->field_additionalTraceInfo.encode_text(text_buf);
single_value->field_directTunnelFlags.encode_text(text_buf);
single_value->field_evolvedAllocationRetentionPriorityI.encode_text(text_buf);
single_value->field_extendedCommonFlags.encode_text(text_buf);
single_value->field_userCSGInformation.encode_text(text_buf);
single_value->field_aPN__AMBR.encode_text(text_buf);
single_value->field_signallingPriorityIndication.encode_text(text_buf);
single_value->field_cN__OperatorSelectionEntity.encode_text(text_buf);
single_value->field_private__extension__gtpc.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
}
}

void UpdatePDPContextRequestSGSN_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_imsi.decode_text(text_buf);
single_value->field_rai.decode_text(text_buf);
single_value->field_recovery.decode_text(text_buf);
single_value->field_teidDataI.decode_text(text_buf);
single_value->field_teidControlPlane.decode_text(text_buf);
single_value->field_nsapi.decode_text(text_buf);
single_value->field_trace__ref.decode_text(text_buf);
single_value->field_trace__type.decode_text(text_buf);
single_value->field_protConfigOptions.decode_text(text_buf);
single_value->field_sgsn__addr__controlPlane.decode_text(text_buf);
single_value->field_sgsn__addr__traffic.decode_text(text_buf);
single_value->field_alt__ggsn__addr__controlPane.decode_text(text_buf);
single_value->field_alt__ggsn__addr__traffic.decode_text(text_buf);
single_value->field_qualityOfServiceProfile.decode_text(text_buf);
single_value->field_tft.decode_text(text_buf);
single_value->field_triggerId.decode_text(text_buf);
single_value->field_omcId.decode_text(text_buf);
single_value->field_commonFlags.decode_text(text_buf);
single_value->field_ratType.decode_text(text_buf);
single_value->field_userLocationInformation.decode_text(text_buf);
single_value->field_mS__TimeZone.decode_text(text_buf);
single_value->field_additionalTraceInfo.decode_text(text_buf);
single_value->field_directTunnelFlags.decode_text(text_buf);
single_value->field_evolvedAllocationRetentionPriorityI.decode_text(text_buf);
single_value->field_extendedCommonFlags.decode_text(text_buf);
single_value->field_userCSGInformation.decode_text(text_buf);
single_value->field_aPN__AMBR.decode_text(text_buf);
single_value->field_signallingPriorityIndication.decode_text(text_buf);
single_value->field_cN__OperatorSelectionEntity.decode_text(text_buf);
single_value->field_private__extension__gtpc.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new UpdatePDPContextRequestSGSN_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.UpdatePDPContextRequestSGSN.");
}
}

void UpdatePDPContextRequestSGSN_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    UpdatePDPContextRequestSGSN_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (30<param.get_size()) {
      param.error("record template of type @GTPC_Types.UpdatePDPContextRequestSGSN has 30 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) imsi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) rai().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) recovery().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) teidDataI().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) teidControlPlane().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) nsapi().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) trace__ref().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) trace__type().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) protConfigOptions().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) sgsn__addr__controlPlane().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) sgsn__addr__traffic().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) alt__ggsn__addr__controlPane().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) alt__ggsn__addr__traffic().set_param(*param.get_elem(12));
    if (param.get_size()>13 && param.get_elem(13)->get_type()!=Module_Param::MP_NotUsed) qualityOfServiceProfile().set_param(*param.get_elem(13));
    if (param.get_size()>14 && param.get_elem(14)->get_type()!=Module_Param::MP_NotUsed) tft().set_param(*param.get_elem(14));
    if (param.get_size()>15 && param.get_elem(15)->get_type()!=Module_Param::MP_NotUsed) triggerId().set_param(*param.get_elem(15));
    if (param.get_size()>16 && param.get_elem(16)->get_type()!=Module_Param::MP_NotUsed) omcId().set_param(*param.get_elem(16));
    if (param.get_size()>17 && param.get_elem(17)->get_type()!=Module_Param::MP_NotUsed) commonFlags().set_param(*param.get_elem(17));
    if (param.get_size()>18 && param.get_elem(18)->get_type()!=Module_Param::MP_NotUsed) ratType().set_param(*param.get_elem(18));
    if (param.get_size()>19 && param.get_elem(19)->get_type()!=Module_Param::MP_NotUsed) userLocationInformation().set_param(*param.get_elem(19));
    if (param.get_size()>20 && param.get_elem(20)->get_type()!=Module_Param::MP_NotUsed) mS__TimeZone().set_param(*param.get_elem(20));
    if (param.get_size()>21 && param.get_elem(21)->get_type()!=Module_Param::MP_NotUsed) additionalTraceInfo().set_param(*param.get_elem(21));
    if (param.get_size()>22 && param.get_elem(22)->get_type()!=Module_Param::MP_NotUsed) directTunnelFlags().set_param(*param.get_elem(22));
    if (param.get_size()>23 && param.get_elem(23)->get_type()!=Module_Param::MP_NotUsed) evolvedAllocationRetentionPriorityI().set_param(*param.get_elem(23));
    if (param.get_size()>24 && param.get_elem(24)->get_type()!=Module_Param::MP_NotUsed) extendedCommonFlags().set_param(*param.get_elem(24));
    if (param.get_size()>25 && param.get_elem(25)->get_type()!=Module_Param::MP_NotUsed) userCSGInformation().set_param(*param.get_elem(25));
    if (param.get_size()>26 && param.get_elem(26)->get_type()!=Module_Param::MP_NotUsed) aPN__AMBR().set_param(*param.get_elem(26));
    if (param.get_size()>27 && param.get_elem(27)->get_type()!=Module_Param::MP_NotUsed) signallingPriorityIndication().set_param(*param.get_elem(27));
    if (param.get_size()>28 && param.get_elem(28)->get_type()!=Module_Param::MP_NotUsed) cN__OperatorSelectionEntity().set_param(*param.get_elem(28));
    if (param.get_size()>29 && param.get_elem(29)->get_type()!=Module_Param::MP_NotUsed) private__extension__gtpc().set_param(*param.get_elem(29));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rai")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rai().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "recovery")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          recovery().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "teidDataI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          teidDataI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "teidControlPlane")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          teidControlPlane().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsapi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsapi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "trace_ref")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          trace__ref().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "trace_type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          trace__type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protConfigOptions")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protConfigOptions().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sgsn_addr_controlPlane")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sgsn__addr__controlPlane().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sgsn_addr_traffic")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sgsn__addr__traffic().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "alt_ggsn_addr_controlPane")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          alt__ggsn__addr__controlPane().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "alt_ggsn_addr_traffic")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          alt__ggsn__addr__traffic().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "qualityOfServiceProfile")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          qualityOfServiceProfile().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tft")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tft().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "triggerId")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          triggerId().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "omcId")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          omcId().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "commonFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          commonFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ratType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ratType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "userLocationInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          userLocationInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mS_TimeZone")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mS__TimeZone().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "additionalTraceInfo")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          additionalTraceInfo().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "directTunnelFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          directTunnelFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "evolvedAllocationRetentionPriorityI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          evolvedAllocationRetentionPriorityI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extendedCommonFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extendedCommonFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "userCSGInformation")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          userCSGInformation().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aPN_AMBR")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aPN__AMBR().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "signallingPriorityIndication")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          signallingPriorityIndication().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cN_OperatorSelectionEntity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cN__OperatorSelectionEntity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "private_extension_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          private__extension__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.UpdatePDPContextRequestSGSN: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    UpdatePDPContextRequestSGSN_template* precondition = new UpdatePDPContextRequestSGSN_template;
    precondition->set_param(*param.get_elem(0));
    UpdatePDPContextRequestSGSN_template* implied_template = new UpdatePDPContextRequestSGSN_template;
    implied_template->set_param(*param.get_elem(1));
    *this = UpdatePDPContextRequestSGSN_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.UpdatePDPContextRequestSGSN");
  }
  is_ifpresent = param.get_ifpresent();
}

void UpdatePDPContextRequestSGSN_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_imsi.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_rai.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_recovery.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_teidDataI.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_teidControlPlane.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_nsapi.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_trace__ref.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_trace__type.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_protConfigOptions.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_sgsn__addr__controlPlane.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_sgsn__addr__traffic.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_alt__ggsn__addr__controlPane.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_alt__ggsn__addr__traffic.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_qualityOfServiceProfile.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_tft.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_triggerId.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_omcId.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_commonFlags.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_ratType.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_userLocationInformation.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_mS__TimeZone.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_additionalTraceInfo.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_directTunnelFlags.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_evolvedAllocationRetentionPriorityI.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_extendedCommonFlags.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_userCSGInformation.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_aPN__AMBR.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_signallingPriorityIndication.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_cN__OperatorSelectionEntity.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
single_value->field_private__extension__gtpc.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestSGSN");
}

boolean UpdatePDPContextRequestSGSN_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean UpdatePDPContextRequestSGSN_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

UpdatePDPContextRequestGGSN::UpdatePDPContextRequestGGSN()
{
}

UpdatePDPContextRequestGGSN::UpdatePDPContextRequestGGSN(const OPTIONAL< IMSI__gtpc >& par_imsi,
    const OPTIONAL< Recovery__gtpc >& par_recovery,
    const NSAPI__GTPC& par_nsapi,
    const OPTIONAL< EndUserAddress >& par_endUserAddress,
    const OPTIONAL< ProtConfigOptions >& par_protConfigOptions,
    const OPTIONAL< QualityOfServiceProfile >& par_qualityOfServiceProfile,
    const OPTIONAL< TrafficFlowTemplate >& par_tft,
    const OPTIONAL< CommonFlags >& par_commonFlags,
    const OPTIONAL< APN__Restriction >& par_aPN__Restriction,
    const OPTIONAL< MS__InfoChangeReportingAction >& par_mS__InfoChangeReportingAction,
    const OPTIONAL< DirectTunnelFlags >& par_directTunnelFlags,
    const OPTIONAL< BearerControlMode >& par_bearerControlMode,
    const OPTIONAL< EvolvedAllocationRetentionPriorityI >& par_evolvedAllocationRetentionPriorityI,
    const OPTIONAL< ExtendedCommonFlags >& par_extendedCommonFlags,
    const OPTIONAL< CSGInfoReportingAction >& par_cSGInfoReportingAction,
    const OPTIONAL< APN__AMBR >& par_aPN__AMBR,
    const OPTIONAL< PrivateExtension__gtpc__List >& par_private__extension__gtpc)
  :   field_imsi(par_imsi),
  field_recovery(par_recovery),
  field_nsapi(par_nsapi),
  field_endUserAddress(par_endUserAddress),
  field_protConfigOptions(par_protConfigOptions),
  field_qualityOfServiceProfile(par_qualityOfServiceProfile),
  field_tft(par_tft),
  field_commonFlags(par_commonFlags),
  field_aPN__Restriction(par_aPN__Restriction),
  field_mS__InfoChangeReportingAction(par_mS__InfoChangeReportingAction),
  field_directTunnelFlags(par_directTunnelFlags),
  field_bearerControlMode(par_bearerControlMode),
  field_evolvedAllocationRetentionPriorityI(par_evolvedAllocationRetentionPriorityI),
  field_extendedCommonFlags(par_extendedCommonFlags),
  field_cSGInfoReportingAction(par_cSGInfoReportingAction),
  field_aPN__AMBR(par_aPN__AMBR),
  field_private__extension__gtpc(par_private__extension__gtpc)
{
}

UpdatePDPContextRequestGGSN::UpdatePDPContextRequestGGSN(const UpdatePDPContextRequestGGSN& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
else field_imsi.clean_up();
if (other_value.recovery().is_bound()) field_recovery = other_value.recovery();
else field_recovery.clean_up();
if (other_value.nsapi().is_bound()) field_nsapi = other_value.nsapi();
else field_nsapi.clean_up();
if (other_value.endUserAddress().is_bound()) field_endUserAddress = other_value.endUserAddress();
else field_endUserAddress.clean_up();
if (other_value.protConfigOptions().is_bound()) field_protConfigOptions = other_value.protConfigOptions();
else field_protConfigOptions.clean_up();
if (other_value.qualityOfServiceProfile().is_bound()) field_qualityOfServiceProfile = other_value.qualityOfServiceProfile();
else field_qualityOfServiceProfile.clean_up();
if (other_value.tft().is_bound()) field_tft = other_value.tft();
else field_tft.clean_up();
if (other_value.commonFlags().is_bound()) field_commonFlags = other_value.commonFlags();
else field_commonFlags.clean_up();
if (other_value.aPN__Restriction().is_bound()) field_aPN__Restriction = other_value.aPN__Restriction();
else field_aPN__Restriction.clean_up();
if (other_value.mS__InfoChangeReportingAction().is_bound()) field_mS__InfoChangeReportingAction = other_value.mS__InfoChangeReportingAction();
else field_mS__InfoChangeReportingAction.clean_up();
if (other_value.directTunnelFlags().is_bound()) field_directTunnelFlags = other_value.directTunnelFlags();
else field_directTunnelFlags.clean_up();
if (other_value.bearerControlMode().is_bound()) field_bearerControlMode = other_value.bearerControlMode();
else field_bearerControlMode.clean_up();
if (other_value.evolvedAllocationRetentionPriorityI().is_bound()) field_evolvedAllocationRetentionPriorityI = other_value.evolvedAllocationRetentionPriorityI();
else field_evolvedAllocationRetentionPriorityI.clean_up();
if (other_value.extendedCommonFlags().is_bound()) field_extendedCommonFlags = other_value.extendedCommonFlags();
else field_extendedCommonFlags.clean_up();
if (other_value.cSGInfoReportingAction().is_bound()) field_cSGInfoReportingAction = other_value.cSGInfoReportingAction();
else field_cSGInfoReportingAction.clean_up();
if (other_value.aPN__AMBR().is_bound()) field_aPN__AMBR = other_value.aPN__AMBR();
else field_aPN__AMBR.clean_up();
if (other_value.private__extension__gtpc().is_bound()) field_private__extension__gtpc = other_value.private__extension__gtpc();
else field_private__extension__gtpc.clean_up();
}

void UpdatePDPContextRequestGGSN::clean_up()
{
field_imsi.clean_up();
field_recovery.clean_up();
field_nsapi.clean_up();
field_endUserAddress.clean_up();
field_protConfigOptions.clean_up();
field_qualityOfServiceProfile.clean_up();
field_tft.clean_up();
field_commonFlags.clean_up();
field_aPN__Restriction.clean_up();
field_mS__InfoChangeReportingAction.clean_up();
field_directTunnelFlags.clean_up();
field_bearerControlMode.clean_up();
field_evolvedAllocationRetentionPriorityI.clean_up();
field_extendedCommonFlags.clean_up();
field_cSGInfoReportingAction.clean_up();
field_aPN__AMBR.clean_up();
field_private__extension__gtpc.clean_up();
}

const TTCN_Typedescriptor_t* UpdatePDPContextRequestGGSN::get_descriptor() const { return &UpdatePDPContextRequestGGSN_descr_; }
UpdatePDPContextRequestGGSN& UpdatePDPContextRequestGGSN::operator=(const UpdatePDPContextRequestGGSN& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
  if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
  else field_imsi.clean_up();
  if (other_value.recovery().is_bound()) field_recovery = other_value.recovery();
  else field_recovery.clean_up();
  if (other_value.nsapi().is_bound()) field_nsapi = other_value.nsapi();
  else field_nsapi.clean_up();
  if (other_value.endUserAddress().is_bound()) field_endUserAddress = other_value.endUserAddress();
  else field_endUserAddress.clean_up();
  if (other_value.protConfigOptions().is_bound()) field_protConfigOptions = other_value.protConfigOptions();
  else field_protConfigOptions.clean_up();
  if (other_value.qualityOfServiceProfile().is_bound()) field_qualityOfServiceProfile = other_value.qualityOfServiceProfile();
  else field_qualityOfServiceProfile.clean_up();
  if (other_value.tft().is_bound()) field_tft = other_value.tft();
  else field_tft.clean_up();
  if (other_value.commonFlags().is_bound()) field_commonFlags = other_value.commonFlags();
  else field_commonFlags.clean_up();
  if (other_value.aPN__Restriction().is_bound()) field_aPN__Restriction = other_value.aPN__Restriction();
  else field_aPN__Restriction.clean_up();
  if (other_value.mS__InfoChangeReportingAction().is_bound()) field_mS__InfoChangeReportingAction = other_value.mS__InfoChangeReportingAction();
  else field_mS__InfoChangeReportingAction.clean_up();
  if (other_value.directTunnelFlags().is_bound()) field_directTunnelFlags = other_value.directTunnelFlags();
  else field_directTunnelFlags.clean_up();
  if (other_value.bearerControlMode().is_bound()) field_bearerControlMode = other_value.bearerControlMode();
  else field_bearerControlMode.clean_up();
  if (other_value.evolvedAllocationRetentionPriorityI().is_bound()) field_evolvedAllocationRetentionPriorityI = other_value.evolvedAllocationRetentionPriorityI();
  else field_evolvedAllocationRetentionPriorityI.clean_up();
  if (other_value.extendedCommonFlags().is_bound()) field_extendedCommonFlags = other_value.extendedCommonFlags();
  else field_extendedCommonFlags.clean_up();
  if (other_value.cSGInfoReportingAction().is_bound()) field_cSGInfoReportingAction = other_value.cSGInfoReportingAction();
  else field_cSGInfoReportingAction.clean_up();
  if (other_value.aPN__AMBR().is_bound()) field_aPN__AMBR = other_value.aPN__AMBR();
  else field_aPN__AMBR.clean_up();
  if (other_value.private__extension__gtpc().is_bound()) field_private__extension__gtpc = other_value.private__extension__gtpc();
  else field_private__extension__gtpc.clean_up();
}
return *this;
}

boolean UpdatePDPContextRequestGGSN::operator==(const UpdatePDPContextRequestGGSN& other_value) const
{
return field_imsi==other_value.field_imsi
  && field_recovery==other_value.field_recovery
  && field_nsapi==other_value.field_nsapi
  && field_endUserAddress==other_value.field_endUserAddress
  && field_protConfigOptions==other_value.field_protConfigOptions
  && field_qualityOfServiceProfile==other_value.field_qualityOfServiceProfile
  && field_tft==other_value.field_tft
  && field_commonFlags==other_value.field_commonFlags
  && field_aPN__Restriction==other_value.field_aPN__Restriction
  && field_mS__InfoChangeReportingAction==other_value.field_mS__InfoChangeReportingAction
  && field_directTunnelFlags==other_value.field_directTunnelFlags
  && field_bearerControlMode==other_value.field_bearerControlMode
  && field_evolvedAllocationRetentionPriorityI==other_value.field_evolvedAllocationRetentionPriorityI
  && field_extendedCommonFlags==other_value.field_extendedCommonFlags
  && field_cSGInfoReportingAction==other_value.field_cSGInfoReportingAction
  && field_aPN__AMBR==other_value.field_aPN__AMBR
  && field_private__extension__gtpc==other_value.field_private__extension__gtpc;
}

boolean UpdatePDPContextRequestGGSN::is_bound() const
{
return (OPTIONAL_OMIT == field_imsi.get_selection() || field_imsi.is_bound())
  || (OPTIONAL_OMIT == field_recovery.get_selection() || field_recovery.is_bound())
  || (field_nsapi.is_bound())
  || (OPTIONAL_OMIT == field_endUserAddress.get_selection() || field_endUserAddress.is_bound())
  || (OPTIONAL_OMIT == field_protConfigOptions.get_selection() || field_protConfigOptions.is_bound())
  || (OPTIONAL_OMIT == field_qualityOfServiceProfile.get_selection() || field_qualityOfServiceProfile.is_bound())
  || (OPTIONAL_OMIT == field_tft.get_selection() || field_tft.is_bound())
  || (OPTIONAL_OMIT == field_commonFlags.get_selection() || field_commonFlags.is_bound())
  || (OPTIONAL_OMIT == field_aPN__Restriction.get_selection() || field_aPN__Restriction.is_bound())
  || (OPTIONAL_OMIT == field_mS__InfoChangeReportingAction.get_selection() || field_mS__InfoChangeReportingAction.is_bound())
  || (OPTIONAL_OMIT == field_directTunnelFlags.get_selection() || field_directTunnelFlags.is_bound())
  || (OPTIONAL_OMIT == field_bearerControlMode.get_selection() || field_bearerControlMode.is_bound())
  || (OPTIONAL_OMIT == field_evolvedAllocationRetentionPriorityI.get_selection() || field_evolvedAllocationRetentionPriorityI.is_bound())
  || (OPTIONAL_OMIT == field_extendedCommonFlags.get_selection() || field_extendedCommonFlags.is_bound())
  || (OPTIONAL_OMIT == field_cSGInfoReportingAction.get_selection() || field_cSGInfoReportingAction.is_bound())
  || (OPTIONAL_OMIT == field_aPN__AMBR.get_selection() || field_aPN__AMBR.is_bound())
  || (OPTIONAL_OMIT == field_private__extension__gtpc.get_selection() || field_private__extension__gtpc.is_bound());
}
boolean UpdatePDPContextRequestGGSN::is_value() const
{
return (OPTIONAL_OMIT == field_imsi.get_selection() || field_imsi.is_value())
  && (OPTIONAL_OMIT == field_recovery.get_selection() || field_recovery.is_value())
  && field_nsapi.is_value()
  && (OPTIONAL_OMIT == field_endUserAddress.get_selection() || field_endUserAddress.is_value())
  && (OPTIONAL_OMIT == field_protConfigOptions.get_selection() || field_protConfigOptions.is_value())
  && (OPTIONAL_OMIT == field_qualityOfServiceProfile.get_selection() || field_qualityOfServiceProfile.is_value())
  && (OPTIONAL_OMIT == field_tft.get_selection() || field_tft.is_value())
  && (OPTIONAL_OMIT == field_commonFlags.get_selection() || field_commonFlags.is_value())
  && (OPTIONAL_OMIT == field_aPN__Restriction.get_selection() || field_aPN__Restriction.is_value())
  && (OPTIONAL_OMIT == field_mS__InfoChangeReportingAction.get_selection() || field_mS__InfoChangeReportingAction.is_value())
  && (OPTIONAL_OMIT == field_directTunnelFlags.get_selection() || field_directTunnelFlags.is_value())
  && (OPTIONAL_OMIT == field_bearerControlMode.get_selection() || field_bearerControlMode.is_value())
  && (OPTIONAL_OMIT == field_evolvedAllocationRetentionPriorityI.get_selection() || field_evolvedAllocationRetentionPriorityI.is_value())
  && (OPTIONAL_OMIT == field_extendedCommonFlags.get_selection() || field_extendedCommonFlags.is_value())
  && (OPTIONAL_OMIT == field_cSGInfoReportingAction.get_selection() || field_cSGInfoReportingAction.is_value())
  && (OPTIONAL_OMIT == field_aPN__AMBR.get_selection() || field_aPN__AMBR.is_value())
  && (OPTIONAL_OMIT == field_private__extension__gtpc.get_selection() || field_private__extension__gtpc.is_value());
}
int UpdatePDPContextRequestGGSN::size_of() const
{
  int ret_val = 1;
  if (field_imsi.ispresent()) ret_val++;
  if (field_recovery.ispresent()) ret_val++;
  if (field_endUserAddress.ispresent()) ret_val++;
  if (field_protConfigOptions.ispresent()) ret_val++;
  if (field_qualityOfServiceProfile.ispresent()) ret_val++;
  if (field_tft.ispresent()) ret_val++;
  if (field_commonFlags.ispresent()) ret_val++;
  if (field_aPN__Restriction.ispresent()) ret_val++;
  if (field_mS__InfoChangeReportingAction.ispresent()) ret_val++;
  if (field_directTunnelFlags.ispresent()) ret_val++;
  if (field_bearerControlMode.ispresent()) ret_val++;
  if (field_evolvedAllocationRetentionPriorityI.ispresent()) ret_val++;
  if (field_extendedCommonFlags.ispresent()) ret_val++;
  if (field_cSGInfoReportingAction.ispresent()) ret_val++;
  if (field_aPN__AMBR.ispresent()) ret_val++;
  if (field_private__extension__gtpc.ispresent()) ret_val++;
  return ret_val;
}

void UpdatePDPContextRequestGGSN::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ imsi := ");
field_imsi.log();
TTCN_Logger::log_event_str(", recovery := ");
field_recovery.log();
TTCN_Logger::log_event_str(", nsapi := ");
field_nsapi.log();
TTCN_Logger::log_event_str(", endUserAddress := ");
field_endUserAddress.log();
TTCN_Logger::log_event_str(", protConfigOptions := ");
field_protConfigOptions.log();
TTCN_Logger::log_event_str(", qualityOfServiceProfile := ");
field_qualityOfServiceProfile.log();
TTCN_Logger::log_event_str(", tft := ");
field_tft.log();
TTCN_Logger::log_event_str(", commonFlags := ");
field_commonFlags.log();
TTCN_Logger::log_event_str(", aPN_Restriction := ");
field_aPN__Restriction.log();
TTCN_Logger::log_event_str(", mS_InfoChangeReportingAction := ");
field_mS__InfoChangeReportingAction.log();
TTCN_Logger::log_event_str(", directTunnelFlags := ");
field_directTunnelFlags.log();
TTCN_Logger::log_event_str(", bearerControlMode := ");
field_bearerControlMode.log();
TTCN_Logger::log_event_str(", evolvedAllocationRetentionPriorityI := ");
field_evolvedAllocationRetentionPriorityI.log();
TTCN_Logger::log_event_str(", extendedCommonFlags := ");
field_extendedCommonFlags.log();
TTCN_Logger::log_event_str(", cSGInfoReportingAction := ");
field_cSGInfoReportingAction.log();
TTCN_Logger::log_event_str(", aPN_AMBR := ");
field_aPN__AMBR.log();
TTCN_Logger::log_event_str(", private_extension_gtpc := ");
field_private__extension__gtpc.log();
TTCN_Logger::log_event_str(" }");
}

void UpdatePDPContextRequestGGSN::set_implicit_omit()
{
if (!imsi().is_bound()) imsi() = OMIT_VALUE;
else imsi().set_implicit_omit();
if (!recovery().is_bound()) recovery() = OMIT_VALUE;
else recovery().set_implicit_omit();
if (nsapi().is_bound()) nsapi().set_implicit_omit();
if (!endUserAddress().is_bound()) endUserAddress() = OMIT_VALUE;
else endUserAddress().set_implicit_omit();
if (!protConfigOptions().is_bound()) protConfigOptions() = OMIT_VALUE;
else protConfigOptions().set_implicit_omit();
if (!qualityOfServiceProfile().is_bound()) qualityOfServiceProfile() = OMIT_VALUE;
else qualityOfServiceProfile().set_implicit_omit();
if (!tft().is_bound()) tft() = OMIT_VALUE;
else tft().set_implicit_omit();
if (!commonFlags().is_bound()) commonFlags() = OMIT_VALUE;
else commonFlags().set_implicit_omit();
if (!aPN__Restriction().is_bound()) aPN__Restriction() = OMIT_VALUE;
else aPN__Restriction().set_implicit_omit();
if (!mS__InfoChangeReportingAction().is_bound()) mS__InfoChangeReportingAction() = OMIT_VALUE;
else mS__InfoChangeReportingAction().set_implicit_omit();
if (!directTunnelFlags().is_bound()) directTunnelFlags() = OMIT_VALUE;
else directTunnelFlags().set_implicit_omit();
if (!bearerControlMode().is_bound()) bearerControlMode() = OMIT_VALUE;
else bearerControlMode().set_implicit_omit();
if (!evolvedAllocationRetentionPriorityI().is_bound()) evolvedAllocationRetentionPriorityI() = OMIT_VALUE;
else evolvedAllocationRetentionPriorityI().set_implicit_omit();
if (!extendedCommonFlags().is_bound()) extendedCommonFlags() = OMIT_VALUE;
else extendedCommonFlags().set_implicit_omit();
if (!cSGInfoReportingAction().is_bound()) cSGInfoReportingAction() = OMIT_VALUE;
else cSGInfoReportingAction().set_implicit_omit();
if (!aPN__AMBR().is_bound()) aPN__AMBR() = OMIT_VALUE;
else aPN__AMBR().set_implicit_omit();
if (!private__extension__gtpc().is_bound()) private__extension__gtpc() = OMIT_VALUE;
else private__extension__gtpc().set_implicit_omit();
}

void UpdatePDPContextRequestGGSN::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (17<param.get_size()) {
      param.error("record value of type @GTPC_Types.UpdatePDPContextRequestGGSN has 17 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) imsi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) recovery().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) nsapi().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) endUserAddress().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) protConfigOptions().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) qualityOfServiceProfile().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) tft().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) commonFlags().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) aPN__Restriction().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) mS__InfoChangeReportingAction().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) directTunnelFlags().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) bearerControlMode().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) evolvedAllocationRetentionPriorityI().set_param(*param.get_elem(12));
    if (param.get_size()>13 && param.get_elem(13)->get_type()!=Module_Param::MP_NotUsed) extendedCommonFlags().set_param(*param.get_elem(13));
    if (param.get_size()>14 && param.get_elem(14)->get_type()!=Module_Param::MP_NotUsed) cSGInfoReportingAction().set_param(*param.get_elem(14));
    if (param.get_size()>15 && param.get_elem(15)->get_type()!=Module_Param::MP_NotUsed) aPN__AMBR().set_param(*param.get_elem(15));
    if (param.get_size()>16 && param.get_elem(16)->get_type()!=Module_Param::MP_NotUsed) private__extension__gtpc().set_param(*param.get_elem(16));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "recovery")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          recovery().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsapi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsapi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "endUserAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          endUserAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protConfigOptions")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protConfigOptions().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "qualityOfServiceProfile")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          qualityOfServiceProfile().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tft")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tft().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "commonFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          commonFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aPN_Restriction")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aPN__Restriction().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mS_InfoChangeReportingAction")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mS__InfoChangeReportingAction().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "directTunnelFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          directTunnelFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bearerControlMode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bearerControlMode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "evolvedAllocationRetentionPriorityI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          evolvedAllocationRetentionPriorityI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extendedCommonFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extendedCommonFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cSGInfoReportingAction")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cSGInfoReportingAction().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aPN_AMBR")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aPN__AMBR().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "private_extension_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          private__extension__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.UpdatePDPContextRequestGGSN: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.UpdatePDPContextRequestGGSN");
  }
}

void UpdatePDPContextRequestGGSN::encode_text(Text_Buf& text_buf) const
{
field_imsi.encode_text(text_buf);
field_recovery.encode_text(text_buf);
field_nsapi.encode_text(text_buf);
field_endUserAddress.encode_text(text_buf);
field_protConfigOptions.encode_text(text_buf);
field_qualityOfServiceProfile.encode_text(text_buf);
field_tft.encode_text(text_buf);
field_commonFlags.encode_text(text_buf);
field_aPN__Restriction.encode_text(text_buf);
field_mS__InfoChangeReportingAction.encode_text(text_buf);
field_directTunnelFlags.encode_text(text_buf);
field_bearerControlMode.encode_text(text_buf);
field_evolvedAllocationRetentionPriorityI.encode_text(text_buf);
field_extendedCommonFlags.encode_text(text_buf);
field_cSGInfoReportingAction.encode_text(text_buf);
field_aPN__AMBR.encode_text(text_buf);
field_private__extension__gtpc.encode_text(text_buf);
}

void UpdatePDPContextRequestGGSN::decode_text(Text_Buf& text_buf)
{
field_imsi.decode_text(text_buf);
field_recovery.decode_text(text_buf);
field_nsapi.decode_text(text_buf);
field_endUserAddress.decode_text(text_buf);
field_protConfigOptions.decode_text(text_buf);
field_qualityOfServiceProfile.decode_text(text_buf);
field_tft.decode_text(text_buf);
field_commonFlags.decode_text(text_buf);
field_aPN__Restriction.decode_text(text_buf);
field_mS__InfoChangeReportingAction.decode_text(text_buf);
field_directTunnelFlags.decode_text(text_buf);
field_bearerControlMode.decode_text(text_buf);
field_evolvedAllocationRetentionPriorityI.decode_text(text_buf);
field_extendedCommonFlags.decode_text(text_buf);
field_cSGInfoReportingAction.decode_text(text_buf);
field_aPN__AMBR.decode_text(text_buf);
field_private__extension__gtpc.decode_text(text_buf);
}

void UpdatePDPContextRequestGGSN::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void UpdatePDPContextRequestGGSN::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

int UpdatePDPContextRequestGGSN::RAW_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int limit, raw_order_t top_bit_ord, boolean no_err, int, boolean, const RAW_Force_Omit* force_omit)
{ (void)no_err;
  int prepaddlength=p_buf.increase_pos_padd(p_td.raw->prepadding);
  limit-=prepaddlength;
  size_t last_decoded_pos = p_buf.get_pos_bit();
  int decoded_length = 0;
  int decoded_field_length = 0;
  raw_order_t local_top_order;
  if(p_td.raw->top_bit_order==TOP_BIT_INHERITED)local_top_order=top_bit_ord;
  else if(p_td.raw->top_bit_order==TOP_BIT_RIGHT)local_top_order=ORDER_MSB;
  else local_top_order=ORDER_LSB;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(0)) {
    field_imsi = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_0_force_omit(0, force_omit, IMSI__gtpc_descr_.raw->forceomit);
  decoded_field_length = field_imsi().RAW_decode(IMSI__gtpc_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_0_force_omit);
  if (decoded_field_length < 1) {
  field_imsi = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_imsi=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(1)) {
    field_recovery = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_1_force_omit(1, force_omit, Recovery__gtpc_descr_.raw->forceomit);
  decoded_field_length = field_recovery().RAW_decode(Recovery__gtpc_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_1_force_omit);
  if (decoded_field_length < 1) {
  field_recovery = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_recovery=OMIT_VALUE;
  RAW_Force_Omit field_2_force_omit(2, force_omit, NSAPI__GTPC_descr_.raw->forceomit);
  decoded_field_length = field_nsapi.RAW_decode(NSAPI__GTPC_descr_, p_buf, limit, local_top_order, no_err, -1, TRUE, &field_2_force_omit);
  if (decoded_field_length < 0) return decoded_field_length;
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(3)) {
    field_endUserAddress = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_3_force_omit(3, force_omit, EndUserAddress_descr_.raw->forceomit);
  decoded_field_length = field_endUserAddress().RAW_decode(EndUserAddress_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_3_force_omit);
  if (decoded_field_length < 1) {
  field_endUserAddress = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_endUserAddress=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(4)) {
    field_protConfigOptions = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_4_force_omit(4, force_omit, ProtConfigOptions_descr_.raw->forceomit);
  decoded_field_length = field_protConfigOptions().RAW_decode(ProtConfigOptions_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_4_force_omit);
  if (decoded_field_length < 1) {
  field_protConfigOptions = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_protConfigOptions=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(5)) {
    field_qualityOfServiceProfile = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_5_force_omit(5, force_omit, QualityOfServiceProfile_descr_.raw->forceomit);
  decoded_field_length = field_qualityOfServiceProfile().RAW_decode(QualityOfServiceProfile_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_5_force_omit);
  if (decoded_field_length < 1) {
  field_qualityOfServiceProfile = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_qualityOfServiceProfile=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(6)) {
    field_tft = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_6_force_omit(6, force_omit, TrafficFlowTemplate_descr_.raw->forceomit);
  decoded_field_length = field_tft().RAW_decode(TrafficFlowTemplate_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_6_force_omit);
  if (decoded_field_length < 1) {
  field_tft = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_tft=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(7)) {
    field_commonFlags = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_7_force_omit(7, force_omit, CommonFlags_descr_.raw->forceomit);
  decoded_field_length = field_commonFlags().RAW_decode(CommonFlags_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_7_force_omit);
  if (decoded_field_length < 1) {
  field_commonFlags = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_commonFlags=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(8)) {
    field_aPN__Restriction = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_8_force_omit(8, force_omit, APN__Restriction_descr_.raw->forceomit);
  decoded_field_length = field_aPN__Restriction().RAW_decode(APN__Restriction_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_8_force_omit);
  if (decoded_field_length < 1) {
  field_aPN__Restriction = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_aPN__Restriction=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(9)) {
    field_mS__InfoChangeReportingAction = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_9_force_omit(9, force_omit, MS__InfoChangeReportingAction_descr_.raw->forceomit);
  decoded_field_length = field_mS__InfoChangeReportingAction().RAW_decode(MS__InfoChangeReportingAction_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_9_force_omit);
  if (decoded_field_length < 1) {
  field_mS__InfoChangeReportingAction = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_mS__InfoChangeReportingAction=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(10)) {
    field_directTunnelFlags = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_10_force_omit(10, force_omit, DirectTunnelFlags_descr_.raw->forceomit);
  decoded_field_length = field_directTunnelFlags().RAW_decode(DirectTunnelFlags_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_10_force_omit);
  if (decoded_field_length < 1) {
  field_directTunnelFlags = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_directTunnelFlags=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(11)) {
    field_bearerControlMode = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_11_force_omit(11, force_omit, BearerControlMode_descr_.raw->forceomit);
  decoded_field_length = field_bearerControlMode().RAW_decode(BearerControlMode_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_11_force_omit);
  if (decoded_field_length < 1) {
  field_bearerControlMode = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_bearerControlMode=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(12)) {
    field_evolvedAllocationRetentionPriorityI = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_12_force_omit(12, force_omit, EvolvedAllocationRetentionPriorityI_descr_.raw->forceomit);
  decoded_field_length = field_evolvedAllocationRetentionPriorityI().RAW_decode(EvolvedAllocationRetentionPriorityI_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_12_force_omit);
  if (decoded_field_length < 1) {
  field_evolvedAllocationRetentionPriorityI = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_evolvedAllocationRetentionPriorityI=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(13)) {
    field_extendedCommonFlags = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_13_force_omit(13, force_omit, ExtendedCommonFlags_descr_.raw->forceomit);
  decoded_field_length = field_extendedCommonFlags().RAW_decode(ExtendedCommonFlags_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_13_force_omit);
  if (decoded_field_length < 1) {
  field_extendedCommonFlags = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_extendedCommonFlags=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(14)) {
    field_cSGInfoReportingAction = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_14_force_omit(14, force_omit, CSGInfoReportingAction_descr_.raw->forceomit);
  decoded_field_length = field_cSGInfoReportingAction().RAW_decode(CSGInfoReportingAction_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_14_force_omit);
  if (decoded_field_length < 1) {
  field_cSGInfoReportingAction = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_cSGInfoReportingAction=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(15)) {
    field_aPN__AMBR = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_15_force_omit(15, force_omit, APN__AMBR_descr_.raw->forceomit);
  decoded_field_length = field_aPN__AMBR().RAW_decode(APN__AMBR_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_15_force_omit);
  if (decoded_field_length < 1) {
  field_aPN__AMBR = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_aPN__AMBR=OMIT_VALUE;
  if (limit > 0){
  if (force_omit != NULL && (*force_omit)(16)) {
    field_private__extension__gtpc = OMIT_VALUE;
  }
  else {
  size_t fl_start_pos = p_buf.get_pos_bit();
  RAW_Force_Omit field_16_force_omit(16, force_omit, PrivateExtension__gtpc__List_descr_.raw->forceomit);
  decoded_field_length = field_private__extension__gtpc().RAW_decode(PrivateExtension__gtpc__List_descr_, p_buf, limit, local_top_order, TRUE, -1, TRUE, &field_16_force_omit);
  if (decoded_field_length < 1) {
  field_private__extension__gtpc = OMIT_VALUE;
  p_buf.set_pos_bit(fl_start_pos);
  } else {
  decoded_length+=decoded_field_length;
  limit-=decoded_field_length;
  last_decoded_pos=bigger(last_decoded_pos, p_buf.get_pos_bit());
  }
  }
  }
  else field_private__extension__gtpc=OMIT_VALUE;
  p_buf.set_pos_bit(last_decoded_pos);
  return decoded_length+prepaddlength+p_buf.increase_pos_padd(p_td.raw->padding);
}

int UpdatePDPContextRequestGGSN::RAW_encode(const TTCN_Typedescriptor_t&, RAW_enc_tree& myleaf) const {
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  int encoded_length = 0;
  myleaf.isleaf = FALSE;
  myleaf.body.node.num_of_nodes = 17;
  myleaf.body.node.nodes = init_nodes_of_enc_tree(17);
  if (field_imsi.ispresent()) {
  myleaf.body.node.nodes[0] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 0, IMSI__gtpc_descr_.raw);
  }
  else myleaf.body.node.nodes[0] = NULL;
  if (field_recovery.ispresent()) {
  myleaf.body.node.nodes[1] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 1, Recovery__gtpc_descr_.raw);
  }
  else myleaf.body.node.nodes[1] = NULL;
  myleaf.body.node.nodes[2] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 2, NSAPI__GTPC_descr_.raw);
  if (field_endUserAddress.ispresent()) {
  myleaf.body.node.nodes[3] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 3, EndUserAddress_descr_.raw);
  }
  else myleaf.body.node.nodes[3] = NULL;
  if (field_protConfigOptions.ispresent()) {
  myleaf.body.node.nodes[4] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 4, ProtConfigOptions_descr_.raw);
  }
  else myleaf.body.node.nodes[4] = NULL;
  if (field_qualityOfServiceProfile.ispresent()) {
  myleaf.body.node.nodes[5] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 5, QualityOfServiceProfile_descr_.raw);
  }
  else myleaf.body.node.nodes[5] = NULL;
  if (field_tft.ispresent()) {
  myleaf.body.node.nodes[6] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 6, TrafficFlowTemplate_descr_.raw);
  }
  else myleaf.body.node.nodes[6] = NULL;
  if (field_commonFlags.ispresent()) {
  myleaf.body.node.nodes[7] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 7, CommonFlags_descr_.raw);
  }
  else myleaf.body.node.nodes[7] = NULL;
  if (field_aPN__Restriction.ispresent()) {
  myleaf.body.node.nodes[8] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 8, APN__Restriction_descr_.raw);
  }
  else myleaf.body.node.nodes[8] = NULL;
  if (field_mS__InfoChangeReportingAction.ispresent()) {
  myleaf.body.node.nodes[9] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 9, MS__InfoChangeReportingAction_descr_.raw);
  }
  else myleaf.body.node.nodes[9] = NULL;
  if (field_directTunnelFlags.ispresent()) {
  myleaf.body.node.nodes[10] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 10, DirectTunnelFlags_descr_.raw);
  }
  else myleaf.body.node.nodes[10] = NULL;
  if (field_bearerControlMode.ispresent()) {
  myleaf.body.node.nodes[11] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 11, BearerControlMode_descr_.raw);
  }
  else myleaf.body.node.nodes[11] = NULL;
  if (field_evolvedAllocationRetentionPriorityI.ispresent()) {
  myleaf.body.node.nodes[12] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 12, EvolvedAllocationRetentionPriorityI_descr_.raw);
  }
  else myleaf.body.node.nodes[12] = NULL;
  if (field_extendedCommonFlags.ispresent()) {
  myleaf.body.node.nodes[13] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 13, ExtendedCommonFlags_descr_.raw);
  }
  else myleaf.body.node.nodes[13] = NULL;
  if (field_cSGInfoReportingAction.ispresent()) {
  myleaf.body.node.nodes[14] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 14, CSGInfoReportingAction_descr_.raw);
  }
  else myleaf.body.node.nodes[14] = NULL;
  if (field_aPN__AMBR.ispresent()) {
  myleaf.body.node.nodes[15] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 15, APN__AMBR_descr_.raw);
  }
  else myleaf.body.node.nodes[15] = NULL;
  if (field_private__extension__gtpc.ispresent()) {
  myleaf.body.node.nodes[16] = new RAW_enc_tree(TRUE, &myleaf, &(myleaf.curr_pos), 16, PrivateExtension__gtpc__List_descr_.raw);
  }
  else myleaf.body.node.nodes[16] = NULL;
  if (field_imsi.ispresent()) {
  encoded_length += field_imsi().RAW_encode(IMSI__gtpc_descr_, *myleaf.body.node.nodes[0]);
  }
  if (field_recovery.ispresent()) {
  encoded_length += field_recovery().RAW_encode(Recovery__gtpc_descr_, *myleaf.body.node.nodes[1]);
  }
  encoded_length += field_nsapi.RAW_encode(NSAPI__GTPC_descr_, *myleaf.body.node.nodes[2]);
  if (field_endUserAddress.ispresent()) {
  encoded_length += field_endUserAddress().RAW_encode(EndUserAddress_descr_, *myleaf.body.node.nodes[3]);
  }
  if (field_protConfigOptions.ispresent()) {
  encoded_length += field_protConfigOptions().RAW_encode(ProtConfigOptions_descr_, *myleaf.body.node.nodes[4]);
  }
  if (field_qualityOfServiceProfile.ispresent()) {
  encoded_length += field_qualityOfServiceProfile().RAW_encode(QualityOfServiceProfile_descr_, *myleaf.body.node.nodes[5]);
  }
  if (field_tft.ispresent()) {
  encoded_length += field_tft().RAW_encode(TrafficFlowTemplate_descr_, *myleaf.body.node.nodes[6]);
  }
  if (field_commonFlags.ispresent()) {
  encoded_length += field_commonFlags().RAW_encode(CommonFlags_descr_, *myleaf.body.node.nodes[7]);
  }
  if (field_aPN__Restriction.ispresent()) {
  encoded_length += field_aPN__Restriction().RAW_encode(APN__Restriction_descr_, *myleaf.body.node.nodes[8]);
  }
  if (field_mS__InfoChangeReportingAction.ispresent()) {
  encoded_length += field_mS__InfoChangeReportingAction().RAW_encode(MS__InfoChangeReportingAction_descr_, *myleaf.body.node.nodes[9]);
  }
  if (field_directTunnelFlags.ispresent()) {
  encoded_length += field_directTunnelFlags().RAW_encode(DirectTunnelFlags_descr_, *myleaf.body.node.nodes[10]);
  }
  if (field_bearerControlMode.ispresent()) {
  encoded_length += field_bearerControlMode().RAW_encode(BearerControlMode_descr_, *myleaf.body.node.nodes[11]);
  }
  if (field_evolvedAllocationRetentionPriorityI.ispresent()) {
  encoded_length += field_evolvedAllocationRetentionPriorityI().RAW_encode(EvolvedAllocationRetentionPriorityI_descr_, *myleaf.body.node.nodes[12]);
  }
  if (field_extendedCommonFlags.ispresent()) {
  encoded_length += field_extendedCommonFlags().RAW_encode(ExtendedCommonFlags_descr_, *myleaf.body.node.nodes[13]);
  }
  if (field_cSGInfoReportingAction.ispresent()) {
  encoded_length += field_cSGInfoReportingAction().RAW_encode(CSGInfoReportingAction_descr_, *myleaf.body.node.nodes[14]);
  }
  if (field_aPN__AMBR.ispresent()) {
  encoded_length += field_aPN__AMBR().RAW_encode(APN__AMBR_descr_, *myleaf.body.node.nodes[15]);
  }
  if (field_private__extension__gtpc.ispresent()) {
  encoded_length += field_private__extension__gtpc().RAW_encode(PrivateExtension__gtpc__List_descr_, *myleaf.body.node.nodes[16]);
  }
  return myleaf.length = encoded_length;
}

struct UpdatePDPContextRequestGGSN_template::single_value_struct {
IMSI__gtpc_template field_imsi;
Recovery__gtpc_template field_recovery;
NSAPI__GTPC_template field_nsapi;
EndUserAddress_template field_endUserAddress;
ProtConfigOptions_template field_protConfigOptions;
QualityOfServiceProfile_template field_qualityOfServiceProfile;
TrafficFlowTemplate_template field_tft;
CommonFlags_template field_commonFlags;
APN__Restriction_template field_aPN__Restriction;
MS__InfoChangeReportingAction_template field_mS__InfoChangeReportingAction;
DirectTunnelFlags_template field_directTunnelFlags;
BearerControlMode_template field_bearerControlMode;
EvolvedAllocationRetentionPriorityI_template field_evolvedAllocationRetentionPriorityI;
ExtendedCommonFlags_template field_extendedCommonFlags;
CSGInfoReportingAction_template field_cSGInfoReportingAction;
APN__AMBR_template field_aPN__AMBR;
PrivateExtension__gtpc__List_template field_private__extension__gtpc;
};

void UpdatePDPContextRequestGGSN_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_imsi = ANY_OR_OMIT;
single_value->field_recovery = ANY_OR_OMIT;
single_value->field_nsapi = ANY_VALUE;
single_value->field_endUserAddress = ANY_OR_OMIT;
single_value->field_protConfigOptions = ANY_OR_OMIT;
single_value->field_qualityOfServiceProfile = ANY_OR_OMIT;
single_value->field_tft = ANY_OR_OMIT;
single_value->field_commonFlags = ANY_OR_OMIT;
single_value->field_aPN__Restriction = ANY_OR_OMIT;
single_value->field_mS__InfoChangeReportingAction = ANY_OR_OMIT;
single_value->field_directTunnelFlags = ANY_OR_OMIT;
single_value->field_bearerControlMode = ANY_OR_OMIT;
single_value->field_evolvedAllocationRetentionPriorityI = ANY_OR_OMIT;
single_value->field_extendedCommonFlags = ANY_OR_OMIT;
single_value->field_cSGInfoReportingAction = ANY_OR_OMIT;
single_value->field_aPN__AMBR = ANY_OR_OMIT;
single_value->field_private__extension__gtpc = ANY_OR_OMIT;
}
}
}

void UpdatePDPContextRequestGGSN_template::copy_value(const UpdatePDPContextRequestGGSN& other_value)
{
single_value = new single_value_struct;
if (other_value.imsi().is_bound()) {
  if (other_value.imsi().ispresent()) single_value->field_imsi = other_value.imsi()();
  else single_value->field_imsi = OMIT_VALUE;
} else {
  single_value->field_imsi.clean_up();
}
if (other_value.recovery().is_bound()) {
  if (other_value.recovery().ispresent()) single_value->field_recovery = other_value.recovery()();
  else single_value->field_recovery = OMIT_VALUE;
} else {
  single_value->field_recovery.clean_up();
}
if (other_value.nsapi().is_bound()) {
  single_value->field_nsapi = other_value.nsapi();
} else {
  single_value->field_nsapi.clean_up();
}
if (other_value.endUserAddress().is_bound()) {
  if (other_value.endUserAddress().ispresent()) single_value->field_endUserAddress = other_value.endUserAddress()();
  else single_value->field_endUserAddress = OMIT_VALUE;
} else {
  single_value->field_endUserAddress.clean_up();
}
if (other_value.protConfigOptions().is_bound()) {
  if (other_value.protConfigOptions().ispresent()) single_value->field_protConfigOptions = other_value.protConfigOptions()();
  else single_value->field_protConfigOptions = OMIT_VALUE;
} else {
  single_value->field_protConfigOptions.clean_up();
}
if (other_value.qualityOfServiceProfile().is_bound()) {
  if (other_value.qualityOfServiceProfile().ispresent()) single_value->field_qualityOfServiceProfile = other_value.qualityOfServiceProfile()();
  else single_value->field_qualityOfServiceProfile = OMIT_VALUE;
} else {
  single_value->field_qualityOfServiceProfile.clean_up();
}
if (other_value.tft().is_bound()) {
  if (other_value.tft().ispresent()) single_value->field_tft = other_value.tft()();
  else single_value->field_tft = OMIT_VALUE;
} else {
  single_value->field_tft.clean_up();
}
if (other_value.commonFlags().is_bound()) {
  if (other_value.commonFlags().ispresent()) single_value->field_commonFlags = other_value.commonFlags()();
  else single_value->field_commonFlags = OMIT_VALUE;
} else {
  single_value->field_commonFlags.clean_up();
}
if (other_value.aPN__Restriction().is_bound()) {
  if (other_value.aPN__Restriction().ispresent()) single_value->field_aPN__Restriction = other_value.aPN__Restriction()();
  else single_value->field_aPN__Restriction = OMIT_VALUE;
} else {
  single_value->field_aPN__Restriction.clean_up();
}
if (other_value.mS__InfoChangeReportingAction().is_bound()) {
  if (other_value.mS__InfoChangeReportingAction().ispresent()) single_value->field_mS__InfoChangeReportingAction = other_value.mS__InfoChangeReportingAction()();
  else single_value->field_mS__InfoChangeReportingAction = OMIT_VALUE;
} else {
  single_value->field_mS__InfoChangeReportingAction.clean_up();
}
if (other_value.directTunnelFlags().is_bound()) {
  if (other_value.directTunnelFlags().ispresent()) single_value->field_directTunnelFlags = other_value.directTunnelFlags()();
  else single_value->field_directTunnelFlags = OMIT_VALUE;
} else {
  single_value->field_directTunnelFlags.clean_up();
}
if (other_value.bearerControlMode().is_bound()) {
  if (other_value.bearerControlMode().ispresent()) single_value->field_bearerControlMode = other_value.bearerControlMode()();
  else single_value->field_bearerControlMode = OMIT_VALUE;
} else {
  single_value->field_bearerControlMode.clean_up();
}
if (other_value.evolvedAllocationRetentionPriorityI().is_bound()) {
  if (other_value.evolvedAllocationRetentionPriorityI().ispresent()) single_value->field_evolvedAllocationRetentionPriorityI = other_value.evolvedAllocationRetentionPriorityI()();
  else single_value->field_evolvedAllocationRetentionPriorityI = OMIT_VALUE;
} else {
  single_value->field_evolvedAllocationRetentionPriorityI.clean_up();
}
if (other_value.extendedCommonFlags().is_bound()) {
  if (other_value.extendedCommonFlags().ispresent()) single_value->field_extendedCommonFlags = other_value.extendedCommonFlags()();
  else single_value->field_extendedCommonFlags = OMIT_VALUE;
} else {
  single_value->field_extendedCommonFlags.clean_up();
}
if (other_value.cSGInfoReportingAction().is_bound()) {
  if (other_value.cSGInfoReportingAction().ispresent()) single_value->field_cSGInfoReportingAction = other_value.cSGInfoReportingAction()();
  else single_value->field_cSGInfoReportingAction = OMIT_VALUE;
} else {
  single_value->field_cSGInfoReportingAction.clean_up();
}
if (other_value.aPN__AMBR().is_bound()) {
  if (other_value.aPN__AMBR().ispresent()) single_value->field_aPN__AMBR = other_value.aPN__AMBR()();
  else single_value->field_aPN__AMBR = OMIT_VALUE;
} else {
  single_value->field_aPN__AMBR.clean_up();
}
if (other_value.private__extension__gtpc().is_bound()) {
  if (other_value.private__extension__gtpc().ispresent()) single_value->field_private__extension__gtpc = other_value.private__extension__gtpc()();
  else single_value->field_private__extension__gtpc = OMIT_VALUE;
} else {
  single_value->field_private__extension__gtpc.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void UpdatePDPContextRequestGGSN_template::copy_template(const UpdatePDPContextRequestGGSN_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.imsi().get_selection()) {
single_value->field_imsi = other_value.imsi();
} else {
single_value->field_imsi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.recovery().get_selection()) {
single_value->field_recovery = other_value.recovery();
} else {
single_value->field_recovery.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nsapi().get_selection()) {
single_value->field_nsapi = other_value.nsapi();
} else {
single_value->field_nsapi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.endUserAddress().get_selection()) {
single_value->field_endUserAddress = other_value.endUserAddress();
} else {
single_value->field_endUserAddress.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.protConfigOptions().get_selection()) {
single_value->field_protConfigOptions = other_value.protConfigOptions();
} else {
single_value->field_protConfigOptions.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.qualityOfServiceProfile().get_selection()) {
single_value->field_qualityOfServiceProfile = other_value.qualityOfServiceProfile();
} else {
single_value->field_qualityOfServiceProfile.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.tft().get_selection()) {
single_value->field_tft = other_value.tft();
} else {
single_value->field_tft.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.commonFlags().get_selection()) {
single_value->field_commonFlags = other_value.commonFlags();
} else {
single_value->field_commonFlags.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.aPN__Restriction().get_selection()) {
single_value->field_aPN__Restriction = other_value.aPN__Restriction();
} else {
single_value->field_aPN__Restriction.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.mS__InfoChangeReportingAction().get_selection()) {
single_value->field_mS__InfoChangeReportingAction = other_value.mS__InfoChangeReportingAction();
} else {
single_value->field_mS__InfoChangeReportingAction.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.directTunnelFlags().get_selection()) {
single_value->field_directTunnelFlags = other_value.directTunnelFlags();
} else {
single_value->field_directTunnelFlags.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.bearerControlMode().get_selection()) {
single_value->field_bearerControlMode = other_value.bearerControlMode();
} else {
single_value->field_bearerControlMode.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.evolvedAllocationRetentionPriorityI().get_selection()) {
single_value->field_evolvedAllocationRetentionPriorityI = other_value.evolvedAllocationRetentionPriorityI();
} else {
single_value->field_evolvedAllocationRetentionPriorityI.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extendedCommonFlags().get_selection()) {
single_value->field_extendedCommonFlags = other_value.extendedCommonFlags();
} else {
single_value->field_extendedCommonFlags.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cSGInfoReportingAction().get_selection()) {
single_value->field_cSGInfoReportingAction = other_value.cSGInfoReportingAction();
} else {
single_value->field_cSGInfoReportingAction.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.aPN__AMBR().get_selection()) {
single_value->field_aPN__AMBR = other_value.aPN__AMBR();
} else {
single_value->field_aPN__AMBR.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.private__extension__gtpc().get_selection()) {
single_value->field_private__extension__gtpc = other_value.private__extension__gtpc();
} else {
single_value->field_private__extension__gtpc.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new UpdatePDPContextRequestGGSN_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new UpdatePDPContextRequestGGSN_template(*other_value.implication_.precondition);
implication_.implied_template = new UpdatePDPContextRequestGGSN_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
break;
}
set_selection(other_value);
}

UpdatePDPContextRequestGGSN_template::UpdatePDPContextRequestGGSN_template()
{
}

UpdatePDPContextRequestGGSN_template::UpdatePDPContextRequestGGSN_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

UpdatePDPContextRequestGGSN_template::UpdatePDPContextRequestGGSN_template(const UpdatePDPContextRequestGGSN& other_value)
{
copy_value(other_value);
}

UpdatePDPContextRequestGGSN_template::UpdatePDPContextRequestGGSN_template(const OPTIONAL<UpdatePDPContextRequestGGSN>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UpdatePDPContextRequestGGSN&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GTPC_Types.UpdatePDPContextRequestGGSN from an unbound optional field.");
}
}

UpdatePDPContextRequestGGSN_template::UpdatePDPContextRequestGGSN_template(UpdatePDPContextRequestGGSN_template* p_precondition, UpdatePDPContextRequestGGSN_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

UpdatePDPContextRequestGGSN_template::UpdatePDPContextRequestGGSN_template(Dynamic_Match_Interface<UpdatePDPContextRequestGGSN>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<UpdatePDPContextRequestGGSN>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

UpdatePDPContextRequestGGSN_template::UpdatePDPContextRequestGGSN_template(const UpdatePDPContextRequestGGSN_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

UpdatePDPContextRequestGGSN_template::~UpdatePDPContextRequestGGSN_template()
{
clean_up();
}

UpdatePDPContextRequestGGSN_template& UpdatePDPContextRequestGGSN_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

UpdatePDPContextRequestGGSN_template& UpdatePDPContextRequestGGSN_template::operator=(const UpdatePDPContextRequestGGSN& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

UpdatePDPContextRequestGGSN_template& UpdatePDPContextRequestGGSN_template::operator=(const OPTIONAL<UpdatePDPContextRequestGGSN>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UpdatePDPContextRequestGGSN&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
}
return *this;
}

UpdatePDPContextRequestGGSN_template& UpdatePDPContextRequestGGSN_template::operator=(const UpdatePDPContextRequestGGSN_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean UpdatePDPContextRequestGGSN_template::match(const UpdatePDPContextRequestGGSN& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.imsi().is_bound()) return FALSE;
if((other_value.imsi().ispresent() ? !single_value->field_imsi.match((const IMSI__gtpc&)other_value.imsi(), legacy) : !single_value->field_imsi.match_omit(legacy)))return FALSE;
if(!other_value.recovery().is_bound()) return FALSE;
if((other_value.recovery().ispresent() ? !single_value->field_recovery.match((const Recovery__gtpc&)other_value.recovery(), legacy) : !single_value->field_recovery.match_omit(legacy)))return FALSE;
if(!other_value.nsapi().is_bound()) return FALSE;
if(!single_value->field_nsapi.match(other_value.nsapi(), legacy))return FALSE;
if(!other_value.endUserAddress().is_bound()) return FALSE;
if((other_value.endUserAddress().ispresent() ? !single_value->field_endUserAddress.match((const EndUserAddress&)other_value.endUserAddress(), legacy) : !single_value->field_endUserAddress.match_omit(legacy)))return FALSE;
if(!other_value.protConfigOptions().is_bound()) return FALSE;
if((other_value.protConfigOptions().ispresent() ? !single_value->field_protConfigOptions.match((const ProtConfigOptions&)other_value.protConfigOptions(), legacy) : !single_value->field_protConfigOptions.match_omit(legacy)))return FALSE;
if(!other_value.qualityOfServiceProfile().is_bound()) return FALSE;
if((other_value.qualityOfServiceProfile().ispresent() ? !single_value->field_qualityOfServiceProfile.match((const QualityOfServiceProfile&)other_value.qualityOfServiceProfile(), legacy) : !single_value->field_qualityOfServiceProfile.match_omit(legacy)))return FALSE;
if(!other_value.tft().is_bound()) return FALSE;
if((other_value.tft().ispresent() ? !single_value->field_tft.match((const TrafficFlowTemplate&)other_value.tft(), legacy) : !single_value->field_tft.match_omit(legacy)))return FALSE;
if(!other_value.commonFlags().is_bound()) return FALSE;
if((other_value.commonFlags().ispresent() ? !single_value->field_commonFlags.match((const CommonFlags&)other_value.commonFlags(), legacy) : !single_value->field_commonFlags.match_omit(legacy)))return FALSE;
if(!other_value.aPN__Restriction().is_bound()) return FALSE;
if((other_value.aPN__Restriction().ispresent() ? !single_value->field_aPN__Restriction.match((const APN__Restriction&)other_value.aPN__Restriction(), legacy) : !single_value->field_aPN__Restriction.match_omit(legacy)))return FALSE;
if(!other_value.mS__InfoChangeReportingAction().is_bound()) return FALSE;
if((other_value.mS__InfoChangeReportingAction().ispresent() ? !single_value->field_mS__InfoChangeReportingAction.match((const MS__InfoChangeReportingAction&)other_value.mS__InfoChangeReportingAction(), legacy) : !single_value->field_mS__InfoChangeReportingAction.match_omit(legacy)))return FALSE;
if(!other_value.directTunnelFlags().is_bound()) return FALSE;
if((other_value.directTunnelFlags().ispresent() ? !single_value->field_directTunnelFlags.match((const DirectTunnelFlags&)other_value.directTunnelFlags(), legacy) : !single_value->field_directTunnelFlags.match_omit(legacy)))return FALSE;
if(!other_value.bearerControlMode().is_bound()) return FALSE;
if((other_value.bearerControlMode().ispresent() ? !single_value->field_bearerControlMode.match((const BearerControlMode&)other_value.bearerControlMode(), legacy) : !single_value->field_bearerControlMode.match_omit(legacy)))return FALSE;
if(!other_value.evolvedAllocationRetentionPriorityI().is_bound()) return FALSE;
if((other_value.evolvedAllocationRetentionPriorityI().ispresent() ? !single_value->field_evolvedAllocationRetentionPriorityI.match((const EvolvedAllocationRetentionPriorityI&)other_value.evolvedAllocationRetentionPriorityI(), legacy) : !single_value->field_evolvedAllocationRetentionPriorityI.match_omit(legacy)))return FALSE;
if(!other_value.extendedCommonFlags().is_bound()) return FALSE;
if((other_value.extendedCommonFlags().ispresent() ? !single_value->field_extendedCommonFlags.match((const ExtendedCommonFlags&)other_value.extendedCommonFlags(), legacy) : !single_value->field_extendedCommonFlags.match_omit(legacy)))return FALSE;
if(!other_value.cSGInfoReportingAction().is_bound()) return FALSE;
if((other_value.cSGInfoReportingAction().ispresent() ? !single_value->field_cSGInfoReportingAction.match((const CSGInfoReportingAction&)other_value.cSGInfoReportingAction(), legacy) : !single_value->field_cSGInfoReportingAction.match_omit(legacy)))return FALSE;
if(!other_value.aPN__AMBR().is_bound()) return FALSE;
if((other_value.aPN__AMBR().ispresent() ? !single_value->field_aPN__AMBR.match((const APN__AMBR&)other_value.aPN__AMBR(), legacy) : !single_value->field_aPN__AMBR.match_omit(legacy)))return FALSE;
if(!other_value.private__extension__gtpc().is_bound()) return FALSE;
if((other_value.private__extension__gtpc().ispresent() ? !single_value->field_private__extension__gtpc.match((const PrivateExtension__gtpc__List&)other_value.private__extension__gtpc(), legacy) : !single_value->field_private__extension__gtpc.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
}
return FALSE;
}

boolean UpdatePDPContextRequestGGSN_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_imsi.is_omit() || single_value->field_imsi.is_bound())
 || (single_value->field_recovery.is_omit() || single_value->field_recovery.is_bound())
 || single_value->field_nsapi.is_bound()
 || (single_value->field_endUserAddress.is_omit() || single_value->field_endUserAddress.is_bound())
 || (single_value->field_protConfigOptions.is_omit() || single_value->field_protConfigOptions.is_bound())
 || (single_value->field_qualityOfServiceProfile.is_omit() || single_value->field_qualityOfServiceProfile.is_bound())
 || (single_value->field_tft.is_omit() || single_value->field_tft.is_bound())
 || (single_value->field_commonFlags.is_omit() || single_value->field_commonFlags.is_bound())
 || (single_value->field_aPN__Restriction.is_omit() || single_value->field_aPN__Restriction.is_bound())
 || (single_value->field_mS__InfoChangeReportingAction.is_omit() || single_value->field_mS__InfoChangeReportingAction.is_bound())
 || (single_value->field_directTunnelFlags.is_omit() || single_value->field_directTunnelFlags.is_bound())
 || (single_value->field_bearerControlMode.is_omit() || single_value->field_bearerControlMode.is_bound())
 || (single_value->field_evolvedAllocationRetentionPriorityI.is_omit() || single_value->field_evolvedAllocationRetentionPriorityI.is_bound())
 || (single_value->field_extendedCommonFlags.is_omit() || single_value->field_extendedCommonFlags.is_bound())
 || (single_value->field_cSGInfoReportingAction.is_omit() || single_value->field_cSGInfoReportingAction.is_bound())
 || (single_value->field_aPN__AMBR.is_omit() || single_value->field_aPN__AMBR.is_bound())
 || (single_value->field_private__extension__gtpc.is_omit() || single_value->field_private__extension__gtpc.is_bound());
}

boolean UpdatePDPContextRequestGGSN_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_imsi.is_omit() || single_value->field_imsi.is_value())
 && (single_value->field_recovery.is_omit() || single_value->field_recovery.is_value())
 && single_value->field_nsapi.is_value()
 && (single_value->field_endUserAddress.is_omit() || single_value->field_endUserAddress.is_value())
 && (single_value->field_protConfigOptions.is_omit() || single_value->field_protConfigOptions.is_value())
 && (single_value->field_qualityOfServiceProfile.is_omit() || single_value->field_qualityOfServiceProfile.is_value())
 && (single_value->field_tft.is_omit() || single_value->field_tft.is_value())
 && (single_value->field_commonFlags.is_omit() || single_value->field_commonFlags.is_value())
 && (single_value->field_aPN__Restriction.is_omit() || single_value->field_aPN__Restriction.is_value())
 && (single_value->field_mS__InfoChangeReportingAction.is_omit() || single_value->field_mS__InfoChangeReportingAction.is_value())
 && (single_value->field_directTunnelFlags.is_omit() || single_value->field_directTunnelFlags.is_value())
 && (single_value->field_bearerControlMode.is_omit() || single_value->field_bearerControlMode.is_value())
 && (single_value->field_evolvedAllocationRetentionPriorityI.is_omit() || single_value->field_evolvedAllocationRetentionPriorityI.is_value())
 && (single_value->field_extendedCommonFlags.is_omit() || single_value->field_extendedCommonFlags.is_value())
 && (single_value->field_cSGInfoReportingAction.is_omit() || single_value->field_cSGInfoReportingAction.is_value())
 && (single_value->field_aPN__AMBR.is_omit() || single_value->field_aPN__AMBR.is_value())
 && (single_value->field_private__extension__gtpc.is_omit() || single_value->field_private__extension__gtpc.is_value());
}

void UpdatePDPContextRequestGGSN_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

UpdatePDPContextRequestGGSN UpdatePDPContextRequestGGSN_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
UpdatePDPContextRequestGGSN ret_val;
if (single_value->field_imsi.is_omit()) ret_val.imsi() = OMIT_VALUE;
else if (single_value->field_imsi.is_bound()) {
ret_val.imsi() = single_value->field_imsi.valueof();
}
if (single_value->field_recovery.is_omit()) ret_val.recovery() = OMIT_VALUE;
else if (single_value->field_recovery.is_bound()) {
ret_val.recovery() = single_value->field_recovery.valueof();
}
if (single_value->field_nsapi.is_bound()) {
ret_val.nsapi() = single_value->field_nsapi.valueof();
}
if (single_value->field_endUserAddress.is_omit()) ret_val.endUserAddress() = OMIT_VALUE;
else if (single_value->field_endUserAddress.is_bound()) {
ret_val.endUserAddress() = single_value->field_endUserAddress.valueof();
}
if (single_value->field_protConfigOptions.is_omit()) ret_val.protConfigOptions() = OMIT_VALUE;
else if (single_value->field_protConfigOptions.is_bound()) {
ret_val.protConfigOptions() = single_value->field_protConfigOptions.valueof();
}
if (single_value->field_qualityOfServiceProfile.is_omit()) ret_val.qualityOfServiceProfile() = OMIT_VALUE;
else if (single_value->field_qualityOfServiceProfile.is_bound()) {
ret_val.qualityOfServiceProfile() = single_value->field_qualityOfServiceProfile.valueof();
}
if (single_value->field_tft.is_omit()) ret_val.tft() = OMIT_VALUE;
else if (single_value->field_tft.is_bound()) {
ret_val.tft() = single_value->field_tft.valueof();
}
if (single_value->field_commonFlags.is_omit()) ret_val.commonFlags() = OMIT_VALUE;
else if (single_value->field_commonFlags.is_bound()) {
ret_val.commonFlags() = single_value->field_commonFlags.valueof();
}
if (single_value->field_aPN__Restriction.is_omit()) ret_val.aPN__Restriction() = OMIT_VALUE;
else if (single_value->field_aPN__Restriction.is_bound()) {
ret_val.aPN__Restriction() = single_value->field_aPN__Restriction.valueof();
}
if (single_value->field_mS__InfoChangeReportingAction.is_omit()) ret_val.mS__InfoChangeReportingAction() = OMIT_VALUE;
else if (single_value->field_mS__InfoChangeReportingAction.is_bound()) {
ret_val.mS__InfoChangeReportingAction() = single_value->field_mS__InfoChangeReportingAction.valueof();
}
if (single_value->field_directTunnelFlags.is_omit()) ret_val.directTunnelFlags() = OMIT_VALUE;
else if (single_value->field_directTunnelFlags.is_bound()) {
ret_val.directTunnelFlags() = single_value->field_directTunnelFlags.valueof();
}
if (single_value->field_bearerControlMode.is_omit()) ret_val.bearerControlMode() = OMIT_VALUE;
else if (single_value->field_bearerControlMode.is_bound()) {
ret_val.bearerControlMode() = single_value->field_bearerControlMode.valueof();
}
if (single_value->field_evolvedAllocationRetentionPriorityI.is_omit()) ret_val.evolvedAllocationRetentionPriorityI() = OMIT_VALUE;
else if (single_value->field_evolvedAllocationRetentionPriorityI.is_bound()) {
ret_val.evolvedAllocationRetentionPriorityI() = single_value->field_evolvedAllocationRetentionPriorityI.valueof();
}
if (single_value->field_extendedCommonFlags.is_omit()) ret_val.extendedCommonFlags() = OMIT_VALUE;
else if (single_value->field_extendedCommonFlags.is_bound()) {
ret_val.extendedCommonFlags() = single_value->field_extendedCommonFlags.valueof();
}
if (single_value->field_cSGInfoReportingAction.is_omit()) ret_val.cSGInfoReportingAction() = OMIT_VALUE;
else if (single_value->field_cSGInfoReportingAction.is_bound()) {
ret_val.cSGInfoReportingAction() = single_value->field_cSGInfoReportingAction.valueof();
}
if (single_value->field_aPN__AMBR.is_omit()) ret_val.aPN__AMBR() = OMIT_VALUE;
else if (single_value->field_aPN__AMBR.is_bound()) {
ret_val.aPN__AMBR() = single_value->field_aPN__AMBR.valueof();
}
if (single_value->field_private__extension__gtpc.is_omit()) ret_val.private__extension__gtpc() = OMIT_VALUE;
else if (single_value->field_private__extension__gtpc.is_bound()) {
ret_val.private__extension__gtpc() = single_value->field_private__extension__gtpc.valueof();
}
return ret_val;
}

void UpdatePDPContextRequestGGSN_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new UpdatePDPContextRequestGGSN_template[list_length];
}

UpdatePDPContextRequestGGSN_template& UpdatePDPContextRequestGGSN_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
return value_list.list_value[list_index];
}

IMSI__gtpc_template& UpdatePDPContextRequestGGSN_template::imsi()
{
set_specific();
return single_value->field_imsi;
}

const IMSI__gtpc_template& UpdatePDPContextRequestGGSN_template::imsi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field imsi of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
return single_value->field_imsi;
}

Recovery__gtpc_template& UpdatePDPContextRequestGGSN_template::recovery()
{
set_specific();
return single_value->field_recovery;
}

const Recovery__gtpc_template& UpdatePDPContextRequestGGSN_template::recovery() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field recovery of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
return single_value->field_recovery;
}

NSAPI__GTPC_template& UpdatePDPContextRequestGGSN_template::nsapi()
{
set_specific();
return single_value->field_nsapi;
}

const NSAPI__GTPC_template& UpdatePDPContextRequestGGSN_template::nsapi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nsapi of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
return single_value->field_nsapi;
}

EndUserAddress_template& UpdatePDPContextRequestGGSN_template::endUserAddress()
{
set_specific();
return single_value->field_endUserAddress;
}

const EndUserAddress_template& UpdatePDPContextRequestGGSN_template::endUserAddress() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field endUserAddress of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
return single_value->field_endUserAddress;
}

ProtConfigOptions_template& UpdatePDPContextRequestGGSN_template::protConfigOptions()
{
set_specific();
return single_value->field_protConfigOptions;
}

const ProtConfigOptions_template& UpdatePDPContextRequestGGSN_template::protConfigOptions() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field protConfigOptions of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
return single_value->field_protConfigOptions;
}

QualityOfServiceProfile_template& UpdatePDPContextRequestGGSN_template::qualityOfServiceProfile()
{
set_specific();
return single_value->field_qualityOfServiceProfile;
}

const QualityOfServiceProfile_template& UpdatePDPContextRequestGGSN_template::qualityOfServiceProfile() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field qualityOfServiceProfile of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
return single_value->field_qualityOfServiceProfile;
}

TrafficFlowTemplate_template& UpdatePDPContextRequestGGSN_template::tft()
{
set_specific();
return single_value->field_tft;
}

const TrafficFlowTemplate_template& UpdatePDPContextRequestGGSN_template::tft() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field tft of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
return single_value->field_tft;
}

CommonFlags_template& UpdatePDPContextRequestGGSN_template::commonFlags()
{
set_specific();
return single_value->field_commonFlags;
}

const CommonFlags_template& UpdatePDPContextRequestGGSN_template::commonFlags() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field commonFlags of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
return single_value->field_commonFlags;
}

APN__Restriction_template& UpdatePDPContextRequestGGSN_template::aPN__Restriction()
{
set_specific();
return single_value->field_aPN__Restriction;
}

const APN__Restriction_template& UpdatePDPContextRequestGGSN_template::aPN__Restriction() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field aPN_Restriction of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
return single_value->field_aPN__Restriction;
}

MS__InfoChangeReportingAction_template& UpdatePDPContextRequestGGSN_template::mS__InfoChangeReportingAction()
{
set_specific();
return single_value->field_mS__InfoChangeReportingAction;
}

const MS__InfoChangeReportingAction_template& UpdatePDPContextRequestGGSN_template::mS__InfoChangeReportingAction() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field mS_InfoChangeReportingAction of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
return single_value->field_mS__InfoChangeReportingAction;
}

DirectTunnelFlags_template& UpdatePDPContextRequestGGSN_template::directTunnelFlags()
{
set_specific();
return single_value->field_directTunnelFlags;
}

const DirectTunnelFlags_template& UpdatePDPContextRequestGGSN_template::directTunnelFlags() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field directTunnelFlags of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
return single_value->field_directTunnelFlags;
}

BearerControlMode_template& UpdatePDPContextRequestGGSN_template::bearerControlMode()
{
set_specific();
return single_value->field_bearerControlMode;
}

const BearerControlMode_template& UpdatePDPContextRequestGGSN_template::bearerControlMode() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field bearerControlMode of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
return single_value->field_bearerControlMode;
}

EvolvedAllocationRetentionPriorityI_template& UpdatePDPContextRequestGGSN_template::evolvedAllocationRetentionPriorityI()
{
set_specific();
return single_value->field_evolvedAllocationRetentionPriorityI;
}

const EvolvedAllocationRetentionPriorityI_template& UpdatePDPContextRequestGGSN_template::evolvedAllocationRetentionPriorityI() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field evolvedAllocationRetentionPriorityI of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
return single_value->field_evolvedAllocationRetentionPriorityI;
}

ExtendedCommonFlags_template& UpdatePDPContextRequestGGSN_template::extendedCommonFlags()
{
set_specific();
return single_value->field_extendedCommonFlags;
}

const ExtendedCommonFlags_template& UpdatePDPContextRequestGGSN_template::extendedCommonFlags() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extendedCommonFlags of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
return single_value->field_extendedCommonFlags;
}

CSGInfoReportingAction_template& UpdatePDPContextRequestGGSN_template::cSGInfoReportingAction()
{
set_specific();
return single_value->field_cSGInfoReportingAction;
}

const CSGInfoReportingAction_template& UpdatePDPContextRequestGGSN_template::cSGInfoReportingAction() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cSGInfoReportingAction of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
return single_value->field_cSGInfoReportingAction;
}

APN__AMBR_template& UpdatePDPContextRequestGGSN_template::aPN__AMBR()
{
set_specific();
return single_value->field_aPN__AMBR;
}

const APN__AMBR_template& UpdatePDPContextRequestGGSN_template::aPN__AMBR() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field aPN_AMBR of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
return single_value->field_aPN__AMBR;
}

PrivateExtension__gtpc__List_template& UpdatePDPContextRequestGGSN_template::private__extension__gtpc()
{
set_specific();
return single_value->field_private__extension__gtpc;
}

const PrivateExtension__gtpc__List_template& UpdatePDPContextRequestGGSN_template::private__extension__gtpc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field private_extension_gtpc of a non-specific template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
return single_value->field_private__extension__gtpc;
}

int UpdatePDPContextRequestGGSN_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.UpdatePDPContextRequestGGSN which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_imsi.is_present()) ret_val++;
      if (single_value->field_recovery.is_present()) ret_val++;
      if (single_value->field_endUserAddress.is_present()) ret_val++;
      if (single_value->field_protConfigOptions.is_present()) ret_val++;
      if (single_value->field_qualityOfServiceProfile.is_present()) ret_val++;
      if (single_value->field_tft.is_present()) ret_val++;
      if (single_value->field_commonFlags.is_present()) ret_val++;
      if (single_value->field_aPN__Restriction.is_present()) ret_val++;
      if (single_value->field_mS__InfoChangeReportingAction.is_present()) ret_val++;
      if (single_value->field_directTunnelFlags.is_present()) ret_val++;
      if (single_value->field_bearerControlMode.is_present()) ret_val++;
      if (single_value->field_evolvedAllocationRetentionPriorityI.is_present()) ret_val++;
      if (single_value->field_extendedCommonFlags.is_present()) ret_val++;
      if (single_value->field_cSGInfoReportingAction.is_present()) ret_val++;
      if (single_value->field_aPN__AMBR.is_present()) ret_val++;
      if (single_value->field_private__extension__gtpc.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GTPC_Types.UpdatePDPContextRequestGGSN containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.UpdatePDPContextRequestGGSN containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.UpdatePDPContextRequestGGSN containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.UpdatePDPContextRequestGGSN containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.UpdatePDPContextRequestGGSN containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.UpdatePDPContextRequestGGSN containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.UpdatePDPContextRequestGGSN containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GTPC_Types.UpdatePDPContextRequestGGSN containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
  }
  return 0;
}

void UpdatePDPContextRequestGGSN_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ imsi := ");
single_value->field_imsi.log();
TTCN_Logger::log_event_str(", recovery := ");
single_value->field_recovery.log();
TTCN_Logger::log_event_str(", nsapi := ");
single_value->field_nsapi.log();
TTCN_Logger::log_event_str(", endUserAddress := ");
single_value->field_endUserAddress.log();
TTCN_Logger::log_event_str(", protConfigOptions := ");
single_value->field_protConfigOptions.log();
TTCN_Logger::log_event_str(", qualityOfServiceProfile := ");
single_value->field_qualityOfServiceProfile.log();
TTCN_Logger::log_event_str(", tft := ");
single_value->field_tft.log();
TTCN_Logger::log_event_str(", commonFlags := ");
single_value->field_commonFlags.log();
TTCN_Logger::log_event_str(", aPN_Restriction := ");
single_value->field_aPN__Restriction.log();
TTCN_Logger::log_event_str(", mS_InfoChangeReportingAction := ");
single_value->field_mS__InfoChangeReportingAction.log();
TTCN_Logger::log_event_str(", directTunnelFlags := ");
single_value->field_directTunnelFlags.log();
TTCN_Logger::log_event_str(", bearerControlMode := ");
single_value->field_bearerControlMode.log();
TTCN_Logger::log_event_str(", evolvedAllocationRetentionPriorityI := ");
single_value->field_evolvedAllocationRetentionPriorityI.log();
TTCN_Logger::log_event_str(", extendedCommonFlags := ");
single_value->field_extendedCommonFlags.log();
TTCN_Logger::log_event_str(", cSGInfoReportingAction := ");
single_value->field_cSGInfoReportingAction.log();
TTCN_Logger::log_event_str(", aPN_AMBR := ");
single_value->field_aPN__AMBR.log();
TTCN_Logger::log_event_str(", private_extension_gtpc := ");
single_value->field_private__extension__gtpc.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void UpdatePDPContextRequestGGSN_template::log_match(const UpdatePDPContextRequestGGSN& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.imsi().ispresent()){
if(!single_value->field_imsi.match(match_value.imsi(), legacy)){
TTCN_Logger::log_logmatch_info(".imsi");
single_value->field_imsi.log_match(match_value.imsi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_imsi.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".imsi := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_imsi.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.recovery().ispresent()){
if(!single_value->field_recovery.match(match_value.recovery(), legacy)){
TTCN_Logger::log_logmatch_info(".recovery");
single_value->field_recovery.log_match(match_value.recovery(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_recovery.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".recovery := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_recovery.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_nsapi.match(match_value.nsapi(), legacy)){
TTCN_Logger::log_logmatch_info(".nsapi");
single_value->field_nsapi.log_match(match_value.nsapi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.endUserAddress().ispresent()){
if(!single_value->field_endUserAddress.match(match_value.endUserAddress(), legacy)){
TTCN_Logger::log_logmatch_info(".endUserAddress");
single_value->field_endUserAddress.log_match(match_value.endUserAddress(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_endUserAddress.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".endUserAddress := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_endUserAddress.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.protConfigOptions().ispresent()){
if(!single_value->field_protConfigOptions.match(match_value.protConfigOptions(), legacy)){
TTCN_Logger::log_logmatch_info(".protConfigOptions");
single_value->field_protConfigOptions.log_match(match_value.protConfigOptions(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_protConfigOptions.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".protConfigOptions := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_protConfigOptions.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.qualityOfServiceProfile().ispresent()){
if(!single_value->field_qualityOfServiceProfile.match(match_value.qualityOfServiceProfile(), legacy)){
TTCN_Logger::log_logmatch_info(".qualityOfServiceProfile");
single_value->field_qualityOfServiceProfile.log_match(match_value.qualityOfServiceProfile(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_qualityOfServiceProfile.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".qualityOfServiceProfile := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_qualityOfServiceProfile.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.tft().ispresent()){
if(!single_value->field_tft.match(match_value.tft(), legacy)){
TTCN_Logger::log_logmatch_info(".tft");
single_value->field_tft.log_match(match_value.tft(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_tft.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".tft := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_tft.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.commonFlags().ispresent()){
if(!single_value->field_commonFlags.match(match_value.commonFlags(), legacy)){
TTCN_Logger::log_logmatch_info(".commonFlags");
single_value->field_commonFlags.log_match(match_value.commonFlags(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_commonFlags.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".commonFlags := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_commonFlags.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.aPN__Restriction().ispresent()){
if(!single_value->field_aPN__Restriction.match(match_value.aPN__Restriction(), legacy)){
TTCN_Logger::log_logmatch_info(".aPN_Restriction");
single_value->field_aPN__Restriction.log_match(match_value.aPN__Restriction(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_aPN__Restriction.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".aPN_Restriction := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_aPN__Restriction.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.mS__InfoChangeReportingAction().ispresent()){
if(!single_value->field_mS__InfoChangeReportingAction.match(match_value.mS__InfoChangeReportingAction(), legacy)){
TTCN_Logger::log_logmatch_info(".mS_InfoChangeReportingAction");
single_value->field_mS__InfoChangeReportingAction.log_match(match_value.mS__InfoChangeReportingAction(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_mS__InfoChangeReportingAction.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".mS_InfoChangeReportingAction := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_mS__InfoChangeReportingAction.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.directTunnelFlags().ispresent()){
if(!single_value->field_directTunnelFlags.match(match_value.directTunnelFlags(), legacy)){
TTCN_Logger::log_logmatch_info(".directTunnelFlags");
single_value->field_directTunnelFlags.log_match(match_value.directTunnelFlags(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_directTunnelFlags.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".directTunnelFlags := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_directTunnelFlags.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.bearerControlMode().ispresent()){
if(!single_value->field_bearerControlMode.match(match_value.bearerControlMode(), legacy)){
TTCN_Logger::log_logmatch_info(".bearerControlMode");
single_value->field_bearerControlMode.log_match(match_value.bearerControlMode(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_bearerControlMode.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".bearerControlMode := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_bearerControlMode.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.evolvedAllocationRetentionPriorityI().ispresent()){
if(!single_value->field_evolvedAllocationRetentionPriorityI.match(match_value.evolvedAllocationRetentionPriorityI(), legacy)){
TTCN_Logger::log_logmatch_info(".evolvedAllocationRetentionPriorityI");
single_value->field_evolvedAllocationRetentionPriorityI.log_match(match_value.evolvedAllocationRetentionPriorityI(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_evolvedAllocationRetentionPriorityI.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".evolvedAllocationRetentionPriorityI := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_evolvedAllocationRetentionPriorityI.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.extendedCommonFlags().ispresent()){
if(!single_value->field_extendedCommonFlags.match(match_value.extendedCommonFlags(), legacy)){
TTCN_Logger::log_logmatch_info(".extendedCommonFlags");
single_value->field_extendedCommonFlags.log_match(match_value.extendedCommonFlags(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extendedCommonFlags.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extendedCommonFlags := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extendedCommonFlags.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.cSGInfoReportingAction().ispresent()){
if(!single_value->field_cSGInfoReportingAction.match(match_value.cSGInfoReportingAction(), legacy)){
TTCN_Logger::log_logmatch_info(".cSGInfoReportingAction");
single_value->field_cSGInfoReportingAction.log_match(match_value.cSGInfoReportingAction(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_cSGInfoReportingAction.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".cSGInfoReportingAction := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_cSGInfoReportingAction.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.aPN__AMBR().ispresent()){
if(!single_value->field_aPN__AMBR.match(match_value.aPN__AMBR(), legacy)){
TTCN_Logger::log_logmatch_info(".aPN_AMBR");
single_value->field_aPN__AMBR.log_match(match_value.aPN__AMBR(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_aPN__AMBR.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".aPN_AMBR := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_aPN__AMBR.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.private__extension__gtpc().ispresent()){
if(!single_value->field_private__extension__gtpc.match(match_value.private__extension__gtpc(), legacy)){
TTCN_Logger::log_logmatch_info(".private_extension_gtpc");
single_value->field_private__extension__gtpc.log_match(match_value.private__extension__gtpc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_private__extension__gtpc.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".private_extension_gtpc := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_private__extension__gtpc.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ imsi := ");
if (match_value.imsi().ispresent()) {
single_value->field_imsi.log_match(match_value.imsi(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_imsi.log();
if (single_value->field_imsi.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", recovery := ");
if (match_value.recovery().ispresent()) {
single_value->field_recovery.log_match(match_value.recovery(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_recovery.log();
if (single_value->field_recovery.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", nsapi := ");
single_value->field_nsapi.log_match(match_value.nsapi(), legacy);
TTCN_Logger::log_event_str(", endUserAddress := ");
if (match_value.endUserAddress().ispresent()) {
single_value->field_endUserAddress.log_match(match_value.endUserAddress(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_endUserAddress.log();
if (single_value->field_endUserAddress.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", protConfigOptions := ");
if (match_value.protConfigOptions().ispresent()) {
single_value->field_protConfigOptions.log_match(match_value.protConfigOptions(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_protConfigOptions.log();
if (single_value->field_protConfigOptions.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", qualityOfServiceProfile := ");
if (match_value.qualityOfServiceProfile().ispresent()) {
single_value->field_qualityOfServiceProfile.log_match(match_value.qualityOfServiceProfile(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_qualityOfServiceProfile.log();
if (single_value->field_qualityOfServiceProfile.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", tft := ");
if (match_value.tft().ispresent()) {
single_value->field_tft.log_match(match_value.tft(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_tft.log();
if (single_value->field_tft.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", commonFlags := ");
if (match_value.commonFlags().ispresent()) {
single_value->field_commonFlags.log_match(match_value.commonFlags(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_commonFlags.log();
if (single_value->field_commonFlags.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", aPN_Restriction := ");
if (match_value.aPN__Restriction().ispresent()) {
single_value->field_aPN__Restriction.log_match(match_value.aPN__Restriction(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_aPN__Restriction.log();
if (single_value->field_aPN__Restriction.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", mS_InfoChangeReportingAction := ");
if (match_value.mS__InfoChangeReportingAction().ispresent()) {
single_value->field_mS__InfoChangeReportingAction.log_match(match_value.mS__InfoChangeReportingAction(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_mS__InfoChangeReportingAction.log();
if (single_value->field_mS__InfoChangeReportingAction.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", directTunnelFlags := ");
if (match_value.directTunnelFlags().ispresent()) {
single_value->field_directTunnelFlags.log_match(match_value.directTunnelFlags(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_directTunnelFlags.log();
if (single_value->field_directTunnelFlags.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", bearerControlMode := ");
if (match_value.bearerControlMode().ispresent()) {
single_value->field_bearerControlMode.log_match(match_value.bearerControlMode(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_bearerControlMode.log();
if (single_value->field_bearerControlMode.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", evolvedAllocationRetentionPriorityI := ");
if (match_value.evolvedAllocationRetentionPriorityI().ispresent()) {
single_value->field_evolvedAllocationRetentionPriorityI.log_match(match_value.evolvedAllocationRetentionPriorityI(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_evolvedAllocationRetentionPriorityI.log();
if (single_value->field_evolvedAllocationRetentionPriorityI.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", extendedCommonFlags := ");
if (match_value.extendedCommonFlags().ispresent()) {
single_value->field_extendedCommonFlags.log_match(match_value.extendedCommonFlags(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extendedCommonFlags.log();
if (single_value->field_extendedCommonFlags.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", cSGInfoReportingAction := ");
if (match_value.cSGInfoReportingAction().ispresent()) {
single_value->field_cSGInfoReportingAction.log_match(match_value.cSGInfoReportingAction(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_cSGInfoReportingAction.log();
if (single_value->field_cSGInfoReportingAction.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", aPN_AMBR := ");
if (match_value.aPN__AMBR().ispresent()) {
single_value->field_aPN__AMBR.log_match(match_value.aPN__AMBR(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_aPN__AMBR.log();
if (single_value->field_aPN__AMBR.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", private_extension_gtpc := ");
if (match_value.private__extension__gtpc().ispresent()) {
single_value->field_private__extension__gtpc.log_match(match_value.private__extension__gtpc(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_private__extension__gtpc.log();
if (single_value->field_private__extension__gtpc.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void UpdatePDPContextRequestGGSN_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!imsi().is_bound()) imsi() = OMIT_VALUE;
else imsi().set_implicit_omit();
if (!recovery().is_bound()) recovery() = OMIT_VALUE;
else recovery().set_implicit_omit();
if (nsapi().is_bound()) nsapi().set_implicit_omit();
if (!endUserAddress().is_bound()) endUserAddress() = OMIT_VALUE;
else endUserAddress().set_implicit_omit();
if (!protConfigOptions().is_bound()) protConfigOptions() = OMIT_VALUE;
else protConfigOptions().set_implicit_omit();
if (!qualityOfServiceProfile().is_bound()) qualityOfServiceProfile() = OMIT_VALUE;
else qualityOfServiceProfile().set_implicit_omit();
if (!tft().is_bound()) tft() = OMIT_VALUE;
else tft().set_implicit_omit();
if (!commonFlags().is_bound()) commonFlags() = OMIT_VALUE;
else commonFlags().set_implicit_omit();
if (!aPN__Restriction().is_bound()) aPN__Restriction() = OMIT_VALUE;
else aPN__Restriction().set_implicit_omit();
if (!mS__InfoChangeReportingAction().is_bound()) mS__InfoChangeReportingAction() = OMIT_VALUE;
else mS__InfoChangeReportingAction().set_implicit_omit();
if (!directTunnelFlags().is_bound()) directTunnelFlags() = OMIT_VALUE;
else directTunnelFlags().set_implicit_omit();
if (!bearerControlMode().is_bound()) bearerControlMode() = OMIT_VALUE;
else bearerControlMode().set_implicit_omit();
if (!evolvedAllocationRetentionPriorityI().is_bound()) evolvedAllocationRetentionPriorityI() = OMIT_VALUE;
else evolvedAllocationRetentionPriorityI().set_implicit_omit();
if (!extendedCommonFlags().is_bound()) extendedCommonFlags() = OMIT_VALUE;
else extendedCommonFlags().set_implicit_omit();
if (!cSGInfoReportingAction().is_bound()) cSGInfoReportingAction() = OMIT_VALUE;
else cSGInfoReportingAction().set_implicit_omit();
if (!aPN__AMBR().is_bound()) aPN__AMBR() = OMIT_VALUE;
else aPN__AMBR().set_implicit_omit();
if (!private__extension__gtpc().is_bound()) private__extension__gtpc() = OMIT_VALUE;
else private__extension__gtpc().set_implicit_omit();
}

void UpdatePDPContextRequestGGSN_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_imsi.encode_text(text_buf);
single_value->field_recovery.encode_text(text_buf);
single_value->field_nsapi.encode_text(text_buf);
single_value->field_endUserAddress.encode_text(text_buf);
single_value->field_protConfigOptions.encode_text(text_buf);
single_value->field_qualityOfServiceProfile.encode_text(text_buf);
single_value->field_tft.encode_text(text_buf);
single_value->field_commonFlags.encode_text(text_buf);
single_value->field_aPN__Restriction.encode_text(text_buf);
single_value->field_mS__InfoChangeReportingAction.encode_text(text_buf);
single_value->field_directTunnelFlags.encode_text(text_buf);
single_value->field_bearerControlMode.encode_text(text_buf);
single_value->field_evolvedAllocationRetentionPriorityI.encode_text(text_buf);
single_value->field_extendedCommonFlags.encode_text(text_buf);
single_value->field_cSGInfoReportingAction.encode_text(text_buf);
single_value->field_aPN__AMBR.encode_text(text_buf);
single_value->field_private__extension__gtpc.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
}
}

void UpdatePDPContextRequestGGSN_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_imsi.decode_text(text_buf);
single_value->field_recovery.decode_text(text_buf);
single_value->field_nsapi.decode_text(text_buf);
single_value->field_endUserAddress.decode_text(text_buf);
single_value->field_protConfigOptions.decode_text(text_buf);
single_value->field_qualityOfServiceProfile.decode_text(text_buf);
single_value->field_tft.decode_text(text_buf);
single_value->field_commonFlags.decode_text(text_buf);
single_value->field_aPN__Restriction.decode_text(text_buf);
single_value->field_mS__InfoChangeReportingAction.decode_text(text_buf);
single_value->field_directTunnelFlags.decode_text(text_buf);
single_value->field_bearerControlMode.decode_text(text_buf);
single_value->field_evolvedAllocationRetentionPriorityI.decode_text(text_buf);
single_value->field_extendedCommonFlags.decode_text(text_buf);
single_value->field_cSGInfoReportingAction.decode_text(text_buf);
single_value->field_aPN__AMBR.decode_text(text_buf);
single_value->field_private__extension__gtpc.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new UpdatePDPContextRequestGGSN_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GTPC_Types.UpdatePDPContextRequestGGSN.");
}
}

void UpdatePDPContextRequestGGSN_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    UpdatePDPContextRequestGGSN_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (17<param.get_size()) {
      param.error("record template of type @GTPC_Types.UpdatePDPContextRequestGGSN has 17 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) imsi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) recovery().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) nsapi().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) endUserAddress().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) protConfigOptions().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) qualityOfServiceProfile().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) tft().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) commonFlags().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) aPN__Restriction().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) mS__InfoChangeReportingAction().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) directTunnelFlags().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) bearerControlMode().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) evolvedAllocationRetentionPriorityI().set_param(*param.get_elem(12));
    if (param.get_size()>13 && param.get_elem(13)->get_type()!=Module_Param::MP_NotUsed) extendedCommonFlags().set_param(*param.get_elem(13));
    if (param.get_size()>14 && param.get_elem(14)->get_type()!=Module_Param::MP_NotUsed) cSGInfoReportingAction().set_param(*param.get_elem(14));
    if (param.get_size()>15 && param.get_elem(15)->get_type()!=Module_Param::MP_NotUsed) aPN__AMBR().set_param(*param.get_elem(15));
    if (param.get_size()>16 && param.get_elem(16)->get_type()!=Module_Param::MP_NotUsed) private__extension__gtpc().set_param(*param.get_elem(16));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "recovery")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          recovery().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsapi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsapi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "endUserAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          endUserAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protConfigOptions")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protConfigOptions().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "qualityOfServiceProfile")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          qualityOfServiceProfile().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tft")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tft().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "commonFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          commonFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aPN_Restriction")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aPN__Restriction().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mS_InfoChangeReportingAction")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mS__InfoChangeReportingAction().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "directTunnelFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          directTunnelFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bearerControlMode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bearerControlMode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "evolvedAllocationRetentionPriorityI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          evolvedAllocationRetentionPriorityI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extendedCommonFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extendedCommonFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cSGInfoReportingAction")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cSGInfoReportingAction().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aPN_AMBR")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aPN__AMBR().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "private_extension_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          private__extension__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.UpdatePDPContextRequestGGSN: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    UpdatePDPContextRequestGGSN_template* precondition = new UpdatePDPContextRequestGGSN_template;
    precondition->set_param(*param.get_elem(0));
    UpdatePDPContextRequestGGSN_template* implied_template = new UpdatePDPContextRequestGGSN_template;
    implied_template->set_param(*param.get_elem(1));
    *this = UpdatePDPContextRequestGGSN_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GTPC_Types.UpdatePDPContextRequestGGSN");
  }
  is_ifpresent = param.get_ifpresent();
}

void UpdatePDPContextRequestGGSN_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_imsi.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestGGSN");
single_value->field_recovery.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestGGSN");
single_value->field_nsapi.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestGGSN");
single_value->field_endUserAddress.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestGGSN");
single_value->field_protConfigOptions.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestGGSN");
single_value->field_qualityOfServiceProfile.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestGGSN");
single_value->field_tft.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestGGSN");
single_value->field_commonFlags.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestGGSN");
single_value->field_aPN__Restriction.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestGGSN");
single_value->field_mS__InfoChangeReportingAction.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestGGSN");
single_value->field_directTunnelFlags.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestGGSN");
single_value->field_bearerControlMode.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestGGSN");
single_value->field_evolvedAllocationRetentionPriorityI.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestGGSN");
single_value->field_extendedCommonFlags.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestGGSN");
single_value->field_cSGInfoReportingAction.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestGGSN");
single_value->field_aPN__AMBR.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestGGSN");
single_value->field_private__extension__gtpc.check_restriction(t_res, t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestGGSN");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GTPC_Types.UpdatePDPContextRequestGGSN");
}

boolean UpdatePDPContextRequestGGSN_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean UpdatePDPContextRequestGGSN_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

UpdatePDPContextRequestCGW::UpdatePDPContextRequestCGW()
{
}

UpdatePDPContextRequestCGW::UpdatePDPContextRequestCGW(const OPTIONAL< IMSI__gtpc >& par_imsi,
    const OPTIONAL< Recovery__gtpc >& par_recovery,
    const NSAPI__GTPC& par_nsapi,
    const OPTIONAL< EndUserAddress >& par_endUserAddress,
    const OPTIONAL< ProtConfigOptions >& par_protConfigOptions,
    const OPTIONAL< QualityOfServiceProfile >& par_qualityOfServiceProfile,
    const OPTIONAL< TrafficFlowTemplate >& par_tft,
    const OPTIONAL< CommonFlags >& par_commonFlags,
    const OPTIONAL< APN__Restriction >& par_aPN__Restriction,
    const OPTIONAL< MS__InfoChangeReportingAction >& par_mS__InfoChangeReportingAction,
    const OPTIONAL< DirectTunnelFlags >& par_directTunnelFlags,
    const OPTIONAL< BearerControlMode >& par_bearerControlMode,
    const OPTIONAL< EvolvedAllocationRetentionPriorityI >& par_evolvedAllocationRetentionPriorityI,
    const OPTIONAL< CSGInfoReportingAction >& par_cSGInfoReportingAction,
    const OPTIONAL< APN__AMBR >& par_aPN__AMBR,
    const OPTIONAL< PrivateExtension__gtpc__List >& par_private__extension__gtpc)
  :   field_imsi(par_imsi),
  field_recovery(par_recovery),
  field_nsapi(par_nsapi),
  field_endUserAddress(par_endUserAddress),
  field_protConfigOptions(par_protConfigOptions),
  field_qualityOfServiceProfile(par_qualityOfServiceProfile),
  field_tft(par_tft),
  field_commonFlags(par_commonFlags),
  field_aPN__Restriction(par_aPN__Restriction),
  field_mS__InfoChangeReportingAction(par_mS__InfoChangeReportingAction),
  field_directTunnelFlags(par_directTunnelFlags),
  field_bearerControlMode(par_bearerControlMode),
  field_evolvedAllocationRetentionPriorityI(par_evolvedAllocationRetentionPriorityI),
  field_cSGInfoReportingAction(par_cSGInfoReportingAction),
  field_aPN__AMBR(par_aPN__AMBR),
  field_private__extension__gtpc(par_private__extension__gtpc)
{
}

UpdatePDPContextRequestCGW::UpdatePDPContextRequestCGW(const UpdatePDPContextRequestCGW& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GTPC_Types.UpdatePDPContextRequestCGW.");
if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
else field_imsi.clean_up();
if (other_value.recovery().is_bound()) field_recovery = other_value.recovery();
else field_recovery.clean_up();
if (other_value.nsapi().is_bound()) field_nsapi = other_value.nsapi();
else field_nsapi.clean_up();
if (other_value.endUserAddress().is_bound()) field_endUserAddress = other_value.endUserAddress();
else field_endUserAddress.clean_up();
if (other_value.protConfigOptions().is_bound()) field_protConfigOptions = other_value.protConfigOptions();
else field_protConfigOptions.clean_up();
if (other_value.qualityOfServiceProfile().is_bound()) field_qualityOfServiceProfile = other_value.qualityOfServiceProfile();
else field_qualityOfServiceProfile.clean_up();
if (other_value.tft().is_bound()) field_tft = other_value.tft();
else field_tft.clean_up();
if (other_value.commonFlags().is_bound()) field_commonFlags = other_value.commonFlags();
else field_commonFlags.clean_up();
if (other_value.aPN__Restriction().is_bound()) field_aPN__Restriction = other_value.aPN__Restriction();
else field_aPN__Restriction.clean_up();
if (other_value.mS__InfoChangeReportingAction().is_bound()) field_mS__InfoChangeReportingAction = other_value.mS__InfoChangeReportingAction();
else field_mS__InfoChangeReportingAction.clean_up();
if (other_value.directTunnelFlags().is_bound()) field_directTunnelFlags = other_value.directTunnelFlags();
else field_directTunnelFlags.clean_up();
if (other_value.bearerControlMode().is_bound()) field_bearerControlMode = other_value.bearerControlMode();
else field_bearerControlMode.clean_up();
if (other_value.evolvedAllocationRetentionPriorityI().is_bound()) field_evolvedAllocationRetentionPriorityI = other_value.evolvedAllocationRetentionPriorityI();
else field_evolvedAllocationRetentionPriorityI.clean_up();
if (other_value.cSGInfoReportingAction().is_bound()) field_cSGInfoReportingAction = other_value.cSGInfoReportingAction();
else field_cSGInfoReportingAction.clean_up();
if (other_value.aPN__AMBR().is_bound()) field_aPN__AMBR = other_value.aPN__AMBR();
else field_aPN__AMBR.clean_up();
if (other_value.private__extension__gtpc().is_bound()) field_private__extension__gtpc = other_value.private__extension__gtpc();
else field_private__extension__gtpc.clean_up();
}

void UpdatePDPContextRequestCGW::clean_up()
{
field_imsi.clean_up();
field_recovery.clean_up();
field_nsapi.clean_up();
field_endUserAddress.clean_up();
field_protConfigOptions.clean_up();
field_qualityOfServiceProfile.clean_up();
field_tft.clean_up();
field_commonFlags.clean_up();
field_aPN__Restriction.clean_up();
field_mS__InfoChangeReportingAction.clean_up();
field_directTunnelFlags.clean_up();
field_bearerControlMode.clean_up();
field_evolvedAllocationRetentionPriorityI.clean_up();
field_cSGInfoReportingAction.clean_up();
field_aPN__AMBR.clean_up();
field_private__extension__gtpc.clean_up();
}

const TTCN_Typedescriptor_t* UpdatePDPContextRequestCGW::get_descriptor() const { return &UpdatePDPContextRequestCGW_descr_; }
UpdatePDPContextRequestCGW& UpdatePDPContextRequestCGW::operator=(const UpdatePDPContextRequestCGW& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GTPC_Types.UpdatePDPContextRequestCGW.");
  if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
  else field_imsi.clean_up();
  if (other_value.recovery().is_bound()) field_recovery = other_value.recovery();
  else field_recovery.clean_up();
  if (other_value.nsapi().is_bound()) field_nsapi = other_value.nsapi();
  else field_nsapi.clean_up();
  if (other_value.endUserAddress().is_bound()) field_endUserAddress = other_value.endUserAddress();
  else field_endUserAddress.clean_up();
  if (other_value.protConfigOptions().is_bound()) field_protConfigOptions = other_value.protConfigOptions();
  else field_protConfigOptions.clean_up();
  if (other_value.qualityOfServiceProfile().is_bound()) field_qualityOfServiceProfile = other_value.qualityOfServiceProfile();
  else field_qualityOfServiceProfile.clean_up();
  if (other_value.tft().is_bound()) field_tft = other_value.tft();
  else field_tft.clean_up();
  if (other_value.commonFlags().is_bound()) field_commonFlags = other_value.commonFlags();
  else field_commonFlags.clean_up();
  if (other_value.aPN__Restriction().is_bound()) field_aPN__Restriction = other_value.aPN__Restriction();
  else field_aPN__Restriction.clean_up();
  if (other_value.mS__InfoChangeReportingAction().is_bound()) field_mS__InfoChangeReportingAction = other_value.mS__InfoChangeReportingAction();
  else field_mS__InfoChangeReportingAction.clean_up();
  if (other_value.directTunnelFlags().is_bound()) field_directTunnelFlags = other_value.directTunnelFlags();
  else field_directTunnelFlags.clean_up();
  if (other_value.bearerControlMode().is_bound()) field_bearerControlMode = other_value.bearerControlMode();
  else field_bearerControlMode.clean_up();
  if (other_value.evolvedAllocationRetentionPriorityI().is_bound()) field_evolvedAllocationRetentionPriorityI = other_value.evolvedAllocationRetentionPriorityI();
  else field_evolvedAllocationRetentionPriorityI.clean_up();
  if (other_value.cSGInfoReportingAction().is_bound()) field_cSGInfoReportingAction = other_value.cSGInfoReportingAction();
  else field_cSGInfoReportingAction.clean_up();
  if (other_value.aPN__AMBR().is_bound()) field_aPN__AMBR = other_value.aPN__AMBR();
  else field_aPN__AMBR.clean_up();
  if (other_value.private__extension__gtpc().is_bound()) field_private__extension__gtpc = other_value.private__extension__gtpc();
  else field_private__extension__gtpc.clean_up();
}
return *this;
}

boolean UpdatePDPContextRequestCGW::operator==(const UpdatePDPContextRequestCGW& other_value) const
{
return field_imsi==other_value.field_imsi
  && field_recovery==other_value.field_recovery
  && field_nsapi==other_value.field_nsapi
  && field_endUserAddress==other_value.field_endUserAddress
  && field_protConfigOptions==other_value.field_protConfigOptions
  && field_qualityOfServiceProfile==other_value.field_qualityOfServiceProfile
  && field_tft==other_value.field_tft
  && field_commonFlags==other_value.field_commonFlags
  && field_aPN__Restriction==other_value.field_aPN__Restriction
  && field_mS__InfoChangeReportingAction==other_value.field_mS__InfoChangeReportingAction
  && field_directTunnelFlags==other_value.field_directTunnelFlags
  && field_bearerControlMode==other_value.field_bearerControlMode
  && field_evolvedAllocationRetentionPriorityI==other_value.field_evolvedAllocationRetentionPriorityI
  && field_cSGInfoReportingAction==other_value.field_cSGInfoReportingAction
  && field_aPN__AMBR==other_value.field_aPN__AMBR
  && field_private__extension__gtpc==other_value.field_private__extension__gtpc;
}

boolean UpdatePDPContextRequestCGW::is_bound() const
{
return (OPTIONAL_OMIT == field_imsi.get_selection() || field_imsi.is_bound())
  || (OPTIONAL_OMIT == field_recovery.get_selection() || field_recovery.is_bound())
  || (field_nsapi.is_bound())
  || (OPTIONAL_OMIT == field_endUserAddress.get_selection() || field_endUserAddress.is_bound())
  || (OPTIONAL_OMIT == field_protConfigOptions.get_selection() || field_protConfigOptions.is_bound())
  || (OPTIONAL_OMIT == field_qualityOfServiceProfile.get_selection() || field_qualityOfServiceProfile.is_bound())
  || (OPTIONAL_OMIT == field_tft.get_selection() || field_tft.is_bound())
  || (OPTIONAL_OMIT == field_commonFlags.get_selection() || field_commonFlags.is_bound())
  || (OPTIONAL_OMIT == field_aPN__Restriction.get_selection() || field_aPN__Restriction.is_bound())
  || (OPTIONAL_OMIT == field_mS__InfoChangeReportingAction.get_selection() || field_mS__InfoChangeReportingAction.is_bound())
  || (OPTIONAL_OMIT == field_directTunnelFlags.get_selection() || field_directTunnelFlags.is_bound())
  || (OPTIONAL_OMIT == field_bearerControlMode.get_selection() || field_bearerControlMode.is_bound())
  || (OPTIONAL_OMIT == field_evolvedAllocationRetentionPriorityI.get_selection() || field_evolvedAllocationRetentionPriorityI.is_bound())
  || (OPTIONAL_OMIT == field_cSGInfoReportingAction.get_selection() || field_cSGInfoReportingAction.is_bound())
  || (OPTIONAL_OMIT == field_aPN__AMBR.get_selection() || field_aPN__AMBR.is_bound())
  || (OPTIONAL_OMIT == field_private__extension__gtpc.get_selection() || field_private__extension__gtpc.is_bound());
}
boolean UpdatePDPContextRequestCGW::is_value() const
{
return (OPTIONAL_OMIT == field_imsi.get_selection() || field_imsi.is_value())
  && (OPTIONAL_OMIT == field_recovery.get_selection() || field_recovery.is_value())
  && field_nsapi.is_value()
  && (OPTIONAL_OMIT == field_endUserAddress.get_selection() || field_endUserAddress.is_value())
  && (OPTIONAL_OMIT == field_protConfigOptions.get_selection() || field_protConfigOptions.is_value())
  && (OPTIONAL_OMIT == field_qualityOfServiceProfile.get_selection() || field_qualityOfServiceProfile.is_value())
  && (OPTIONAL_OMIT == field_tft.get_selection() || field_tft.is_value())
  && (OPTIONAL_OMIT == field_commonFlags.get_selection() || field_commonFlags.is_value())
  && (OPTIONAL_OMIT == field_aPN__Restriction.get_selection() || field_aPN__Restriction.is_value())
  && (OPTIONAL_OMIT == field_mS__InfoChangeReportingAction.get_selection() || field_mS__InfoChangeReportingAction.is_value())
  && (OPTIONAL_OMIT == field_directTunnelFlags.get_selection() || field_directTunnelFlags.is_value())
  && (OPTIONAL_OMIT == field_bearerControlMode.get_selection() || field_bearerControlMode.is_value())
  && (OPTIONAL_OMIT == field_evolvedAllocationRetentionPriorityI.get_selection() || field_evolvedAllocationRetentionPriorityI.is_value())
  && (OPTIONAL_OMIT == field_cSGInfoReportingAction.get_selection() || field_cSGInfoReportingAction.is_value())
  && (OPTIONAL_OMIT == field_aPN__AMBR.get_selection() || field_aPN__AMBR.is_value())
  && (OPTIONAL_OMIT == field_private__extension__gtpc.get_selection() || field_private__extension__gtpc.is_value());
}
int UpdatePDPContextRequestCGW::size_of() const
{
  int ret_val = 1;
  if (field_imsi.ispresent()) ret_val++;
  if (field_recovery.ispresent()) ret_val++;
  if (field_endUserAddress.ispresent()) ret_val++;
  if (field_protConfigOptions.ispresent()) ret_val++;
  if (field_qualityOfServiceProfile.ispresent()) ret_val++;
  if (field_tft.ispresent()) ret_val++;
  if (field_commonFlags.ispresent()) ret_val++;
  if (field_aPN__Restriction.ispresent()) ret_val++;
  if (field_mS__InfoChangeReportingAction.ispresent()) ret_val++;
  if (field_directTunnelFlags.ispresent()) ret_val++;
  if (field_bearerControlMode.ispresent()) ret_val++;
  if (field_evolvedAllocationRetentionPriorityI.ispresent()) ret_val++;
  if (field_cSGInfoReportingAction.ispresent()) ret_val++;
  if (field_aPN__AMBR.ispresent()) ret_val++;
  if (field_private__extension__gtpc.ispresent()) ret_val++;
  return ret_val;
}

void UpdatePDPContextRequestCGW::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ imsi := ");
field_imsi.log();
TTCN_Logger::log_event_str(", recovery := ");
field_recovery.log();
TTCN_Logger::log_event_str(", nsapi := ");
field_nsapi.log();
TTCN_Logger::log_event_str(", endUserAddress := ");
field_endUserAddress.log();
TTCN_Logger::log_event_str(", protConfigOptions := ");
field_protConfigOptions.log();
TTCN_Logger::log_event_str(", qualityOfServiceProfile := ");
field_qualityOfServiceProfile.log();
TTCN_Logger::log_event_str(", tft := ");
field_tft.log();
TTCN_Logger::log_event_str(", commonFlags := ");
field_commonFlags.log();
TTCN_Logger::log_event_str(", aPN_Restriction := ");
field_aPN__Restriction.log();
TTCN_Logger::log_event_str(", mS_InfoChangeReportingAction := ");
field_mS__InfoChangeReportingAction.log();
TTCN_Logger::log_event_str(", directTunnelFlags := ");
field_directTunnelFlags.log();
TTCN_Logger::log_event_str(", bearerControlMode := ");
field_bearerControlMode.log();
TTCN_Logger::log_event_str(", evolvedAllocationRetentionPriorityI := ");
field_evolvedAllocationRetentionPriorityI.log();
TTCN_Logger::log_event_str(", cSGInfoReportingAction := ");
field_cSGInfoReportingAction.log();
TTCN_Logger::log_event_str(", aPN_AMBR := ");
field_aPN__AMBR.log();
TTCN_Logger::log_event_str(", private_extension_gtpc := ");
field_private__extension__gtpc.log();
TTCN_Logger::log_event_str(" }");
}

void UpdatePDPContextRequestCGW::set_implicit_omit()
{
if (!imsi().is_bound()) imsi() = OMIT_VALUE;
else imsi().set_implicit_omit();
if (!recovery().is_bound()) recovery() = OMIT_VALUE;
else recovery().set_implicit_omit();
if (nsapi().is_bound()) nsapi().set_implicit_omit();
if (!endUserAddress().is_bound()) endUserAddress() = OMIT_VALUE;
else endUserAddress().set_implicit_omit();
if (!protConfigOptions().is_bound()) protConfigOptions() = OMIT_VALUE;
else protConfigOptions().set_implicit_omit();
if (!qualityOfServiceProfile().is_bound()) qualityOfServiceProfile() = OMIT_VALUE;
else qualityOfServiceProfile().set_implicit_omit();
if (!tft().is_bound()) tft() = OMIT_VALUE;
else tft().set_implicit_omit();
if (!commonFlags().is_bound()) commonFlags() = OMIT_VALUE;
else commonFlags().set_implicit_omit();
if (!aPN__Restriction().is_bound()) aPN__Restriction() = OMIT_VALUE;
else aPN__Restriction().set_implicit_omit();
if (!mS__InfoChangeReportingAction().is_bound()) mS__InfoChangeReportingAction() = OMIT_VALUE;
else mS__InfoChangeReportingAction().set_implicit_omit();
if (!directTunnelFlags().is_bound()) directTunnelFlags() = OMIT_VALUE;
else directTunnelFlags().set_implicit_omit();
if (!bearerControlMode().is_bound()) bearerControlMode() = OMIT_VALUE;
else bearerControlMode().set_implicit_omit();
if (!evolvedAllocationRetentionPriorityI().is_bound()) evolvedAllocationRetentionPriorityI() = OMIT_VALUE;
else evolvedAllocationRetentionPriorityI().set_implicit_omit();
if (!cSGInfoReportingAction().is_bound()) cSGInfoReportingAction() = OMIT_VALUE;
else cSGInfoReportingAction().set_implicit_omit();
if (!aPN__AMBR().is_bound()) aPN__AMBR() = OMIT_VALUE;
else aPN__AMBR().set_implicit_omit();
if (!private__extension__gtpc().is_bound()) private__extension__gtpc() = OMIT_VALUE;
else private__extension__gtpc().set_implicit_omit();
}

void UpdatePDPContextRequestCGW::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (16<param.get_size()) {
      param.error("record value of type @GTPC_Types.UpdatePDPContextRequestCGW has 16 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) imsi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) recovery().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) nsapi().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) endUserAddress().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) protConfigOptions().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) qualityOfServiceProfile().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) tft().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) commonFlags().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) aPN__Restriction().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) mS__InfoChangeReportingAction().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) directTunnelFlags().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) bearerControlMode().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) evolvedAllocationRetentionPriorityI().set_param(*param.get_elem(12));
    if (param.get_size()>13 && param.get_elem(13)->get_type()!=Module_Param::MP_NotUsed) cSGInfoReportingAction().set_param(*param.get_elem(13));
    if (param.get_size()>14 && param.get_elem(14)->get_type()!=Module_Param::MP_NotUsed) aPN__AMBR().set_param(*param.get_elem(14));
    if (param.get_size()>15 && param.get_elem(15)->get_type()!=Module_Param::MP_NotUsed) private__extension__gtpc().set_param(*param.get_elem(15));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "recovery")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          recovery().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nsapi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nsapi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "endUserAddress")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          endUserAddress().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "protConfigOptions")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          protConfigOptions().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "qualityOfServiceProfile")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          qualityOfServiceProfile().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "tft")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          tft().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "commonFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          commonFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aPN_Restriction")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aPN__Restriction().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "mS_InfoChangeReportingAction")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          mS__InfoChangeReportingAction().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "directTunnelFlags")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          directTunnelFlags().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "bearerControlMode")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          bearerControlMode().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "evolvedAllocationRetentionPriorityI")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          evolvedAllocationRetentionPriorityI().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cSGInfoReportingAction")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cSGInfoReportingAction().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "aPN_AMBR")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          aPN__AMBR().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "private_extension_gtpc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          private__extension__gtpc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GTPC_Types.UpdatePDPContextRequestCGW: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GTPC_Types.UpdatePDPContextRequestCGW");
  }
}

void UpdatePDPContextRequestCGW::encode_text(Text_Buf& text_buf) const
{
field_imsi.encode_text(text_buf);
field_recovery.encode_text(text_buf);
field_nsapi.encode_text(text_buf);
field_endUserAddress.encode_text(text_buf);
field_protConfigOptions.encode_text(text_buf);
field_qualityOfServiceProfile.encode_text(text_buf);
field_tft.encode_text(text_buf);
field_commonFlags.encode_text(text_buf);
field_aPN__Restriction.encode_text(text_buf);
field_mS__InfoChangeReportingAction.encode_text(text_buf);
field_directTunnelFlags.encode_text(text_buf);
field_bearerControlMode.encode_text(text_buf);
field_evolvedAllocationRetentionPriorityI.encode_text(text_buf);
field_cSGInfoReportingAction.encode_text(text_buf);
field_aPN__AMBR.encode_text(text_buf);
field_private__extension__gtpc.encode_text(text_buf);
}

void UpdatePDPContextRequestCGW::decode_text(Text_Buf& text_buf)
{
field_imsi.decode_text(text_buf);
field_recovery.decode_text(text_buf);
field_nsapi.decode_text(text_buf);
field_endUserAddress.decode_text(text_buf);
field_protConfigOptions.decode_text(text_buf);
field_qualityOfServiceProfile.decode_text(text_buf);
field_tft.decode_text(text_buf);
field_commonFlags.decode_text(text_buf);
field_aPN__Restriction.decode_text(text_buf);
field_mS__InfoChangeReportingAction.decode_text(text_buf);
field_directTunnelFlags.decode_text(text_buf);
field_bearerControlMode.decode_text(text_buf);
field_evolvedAllocationRetentionPriorityI.decode_text(text_buf);
field_cSGInfoReportingAction.decode_text(text_buf);
field_aPN__AMBR.decode_text(text_buf);
field_private__extension__gtpc.decode_text(text_buf);
}

void UpdatePDPContextRequestCGW::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n