// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "GSUP_Emulation.hh"

namespace GSUP__Emulation {

/* Literal string constants */

extern const CHARSTRING cs_0(0, NULL);
const unsigned char module_checksum[] = { 0xcb, 0xca, 0x2c, 0xed, 0x81, 0xb1, 0xec, 0x2c, 0x47, 0xad, 0xbc, 0x18, 0x90, 0x9f, 0x3f, 0xeb };

/* Global variable definitions */

const TTCN_Typedescriptor_t& GSUP__ConnHdlr_descr_ = COMPONENT_descr_;
GSUP__Conn__PT GSUP__ConnHdlr_component_GSUP("GSUP");
GSUPEM__PROC__PT GSUP__ConnHdlr_component_GSUP__PROC("GSUP_PROC");
const XERdescriptor_t       ConnectionData_imsi_xer_ = { {"imsi>\n", "imsi>\n"}, {6, 6}, 0 |FORM_UNQUALIFIED, WHITESPACE_PRESERVE,  NULL, &module_object, -1, 0, NULL, NULL, -1, XSD_NONE };
const TTCN_Typedescriptor_t ConnectionData_imsi_descr_ = { "@GSUP_Emulation.ConnectionData.imsi", NULL, &CHARSTRING_raw_, &CHARSTRING_text_, &ConnectionData_imsi_xer_, &CHARSTRING_json_, NULL, NULL, NULL, TTCN_Typedescriptor_t::DONTCARE };
// No XER for ConnectionData
const TTCN_Typedescriptor_t ConnectionData_descr_ = { "@GSUP_Emulation.ConnectionData", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, TTCN_Typedescriptor_t::DONTCARE };
const TTCN_Typedescriptor_t& GSUP__Emulation__CT_descr_ = COMPONENT_descr_;
IPA__Emulation::IPA__GSUP__PT GSUP__Emulation__CT_component_GSUP("GSUP");
GSUP__Conn__PT GSUP__Emulation__CT_component_GSUP__CLIENT("GSUP_CLIENT");
VALUE_ARRAY<ConnectionData, 256, 0> GSUP__Emulation__CT_component_GsupImsiTable;
// No XER for ExpectData
const TTCN_Typedescriptor_t ExpectData_descr_ = { "@GSUP_Emulation.ExpectData", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, TTCN_Typedescriptor_t::DONTCARE };
const XERdescriptor_t       ExpectData_imsi_xer_ = { {"imsi>\n", "imsi>\n"}, {6, 6}, 0 |FORM_UNQUALIFIED |XER_OPTIONAL, WHITESPACE_PRESERVE,  NULL, &module_object, -1, 0, NULL, NULL, -1, XSD_NONE };
const TTCN_Typedescriptor_t ExpectData_imsi_descr_ = { "@GSUP_Emulation.ExpectData.imsi", NULL, &CHARSTRING_raw_, &CHARSTRING_text_, &ExpectData_imsi_xer_, &CHARSTRING_json_, NULL, NULL, NULL, TTCN_Typedescriptor_t::DONTCARE };
VALUE_ARRAY<ExpectData, 256, 0> GSUP__Emulation__CT_component_GsupExpectTable;
GSUPEM__PROC__PT GSUP__Emulation__CT_component_GSUP__PROC("GSUP_PROC");
// No XER for GsupCreateCallback
const TTCN_Typedescriptor_t GsupCreateCallback_descr_ = { "@GSUP_Emulation.GsupCreateCallback", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, TTCN_Typedescriptor_t::DONTCARE };
// No XER for GsupOps
const TTCN_Typedescriptor_t GsupOps_descr_ = { "@GSUP_Emulation.GsupOps", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, TTCN_Typedescriptor_t::DONTCARE };
TTCN_Module module_object("GSUP_Emulation", __DATE__, __TIME__, module_checksum, pre_init_module, NULL, 0U, 4294967295U, 4294967295U, 4294967295U, NULL, 0LU, 0, post_init_module, NULL, NULL, NULL, init_comp_type, init_system_port, start_ptc_function, NULL);

const RuntimeVersionChecker ver_checker(  current_runtime_version.requires_major_version_11,
  current_runtime_version.requires_minor_version_1,
  current_runtime_version.requires_patch_level_0,  current_runtime_version.requires_runtime_1);

/* Member functions of C++ classes */

void GSUP__Conn__PT::remove_msg_queue_head()
{
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
switch (my_head->item_selection) {
case MESSAGE_0:
delete (my_head)->message_0;
break;
default:
TTCN_error("Internal error: Invalid message selector in the queue of port %s.", port_name);
}
msg_queue_item_base *next_item = msg_queue_head->next_item;
delete (msg_queue_item*)msg_queue_head;
msg_queue_head = next_item;
if (next_item == NULL) msg_queue_tail = NULL;
TTCN_Logger::log_port_queue(TitanLoggerApiSimple::Port__Queue_operation::extract__msg, port_name, 0, ++msg_head_count, CHARSTRING(0,NULL), CHARSTRING(0,NULL));}

void GSUP__Conn__PT::clear_queue()
{
while (msg_queue_head != NULL) remove_msg_queue_head();
}

GSUP__Conn__PT::GSUP__Conn__PT(const char *par_port_name)
 : PORT(par_port_name)
{
msg_queue_head = NULL;
msg_queue_tail = NULL;
}

GSUP__Conn__PT::~GSUP__Conn__PT()
{
clear_queue();
}

void GSUP__Conn__PT::send(const GSUP__Types::GSUP__PDU& send_par, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
if (!is_started) TTCN_error("Sending a message on port %s, which is not started.", port_name);
if (!destination_component.is_bound()) TTCN_error("Unbound component reference in the to clause of send operation.");
const TTCN_Logger::Severity log_sev = destination_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMSEND:TTCN_Logger::PORTEVENT_MCSEND;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_send(port_name, destination_component,
(TTCN_Logger::begin_event(log_sev, TRUE), TTCN_Logger::log_event_str(" @GSUP_Types.GSUP_PDU : "),
send_par.log(), TTCN_Logger::end_event_log2str()));
}
if (destination_component == SYSTEM_COMPREF) TTCN_error("Message cannot be sent to system on internal port %s.", port_name);
else {
Text_Buf text_buf;
prepare_message(text_buf, "@GSUP_Types.GSUP_PDU");
send_par.encode_text(text_buf);
send_data(text_buf, destination_component);
}
}

void GSUP__Conn__PT::send(const GSUP__Types::GSUP__PDU& send_par, size_t nof_components, const COMPONENT* destination_components, FLOAT* timestamp_redirect)
{
for (size_t i = 0; i < nof_components; ++i) send(send_par, destination_components[i], timestamp_redirect);
}

void GSUP__Conn__PT::send(const GSUP__Types::GSUP__PDU& send_par, boolean broadcast, FLOAT* timestamp_redirect)
{
if (broadcast) {
if (!is_started) TTCN_error("Sending a message on port %s, which is not started.", port_name);
Text_Buf text_buf;
prepare_message(text_buf, "@GSUP_Types.GSUP_PDU");
send_par.encode_text(text_buf);
send_data_broadcast(text_buf, PORT::OMT_SEND, (TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_MCSEND, TRUE),
TTCN_Logger::log_event_str(" @GSUP_Types.GSUP_PDU : "), send_par.log(), TTCN_Logger::end_event_log2str()));
}
else send(send_par, COMPONENT(get_default_destination()), timestamp_redirect);
}

void GSUP__Conn__PT::send(const GSUP__Types::GSUP__PDU_template& send_par, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
const GSUP__Types::GSUP__PDU& send_par_value = GSUP__Types::GSUP__PDU(send_par.valueof());
send(send_par_value, destination_component, timestamp_redirect);
}

void GSUP__Conn__PT::send(const GSUP__Types::GSUP__PDU_template& send_par, size_t nof_components, const COMPONENT* destination_components, FLOAT* timestamp_redirect)
{
const GSUP__Types::GSUP__PDU& send_par_value = GSUP__Types::GSUP__PDU(send_par.valueof());
send(send_par_value, nof_components, destination_components, timestamp_redirect);
}

void GSUP__Conn__PT::send(const GSUP__Types::GSUP__PDU_template& send_par, boolean broadcast, FLOAT* timestamp_redirect)
{
const GSUP__Types::GSUP__PDU& send_par_value = GSUP__Types::GSUP__PDU(send_par.valueof());
send(send_par_value, broadcast, timestamp_redirect);
}

alt_status GSUP__Conn__PT::receive(const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else {
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS, "Matching on port %s succeeded.", port_name);
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
switch (my_head->item_selection) {
case MESSAGE_0:
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @GSUP_Types.GSUP_PDU: "),
my_head->message_0->log(), TTCN_Logger::end_event_log2str()), msg_head_count+1);
break;
default:
TTCN_error("Internal error: unknown message");
}
}
remove_msg_queue_head();
return ALT_YES;
}
}

alt_status GSUP__Conn__PT::check_receive(const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else {
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS, "Matching on port %s succeeded.", port_name);
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
switch (my_head->item_selection) {
case MESSAGE_0:
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::check__receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @GSUP_Types.GSUP_PDU: "),
my_head->message_0->log(), TTCN_Logger::end_event_log2str()), msg_head_count+1);
break;
default:
TTCN_error("Internal error: unknown message");
}
}
return ALT_YES;
}
}

alt_status GSUP__Conn__PT::trigger(const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s will drop a message: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
remove_msg_queue_head();
return ALT_REPEAT;
} else {
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS, "Matching on port %s succeeded.", port_name);
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
switch (my_head->item_selection) {
case MESSAGE_0:
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::trigger__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @GSUP_Types.GSUP_PDU: "),
my_head->message_0->log(), TTCN_Logger::end_event_log2str()), msg_head_count+1);
break;
default:
TTCN_error("Internal error: unknown message");
}
}
remove_msg_queue_head();
return ALT_YES;
}
}

alt_status GSUP__Conn__PT::receive(const GSUP__Types::GSUP__PDU_template& value_template, GSUP__Types::GSUP__PDU *value_redirect, const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (value_template.get_selection() == ANY_OR_OMIT) TTCN_error("Receive operation using '*' as matching template");
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (my_head->item_selection != MESSAGE_0) {
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC, "Matching on port %s failed: Type of the first message in the queue is not @GSUP_Types.GSUP_PDU.", port_name);
return ALT_NO;
} else if (!value_template.match(*my_head->message_0)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_MMUNSUCC : TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::message__does__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_0),
 TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
if (value_redirect != NULL) {
*value_redirect = *my_head->message_0;
}
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_success(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_0),
 TTCN_Logger::end_event_log2str()));
}
log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @GSUP_Types.GSUP_PDU : "),
my_head->message_0->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_msg_queue_head();
return ALT_YES;
}
}

alt_status GSUP__Conn__PT::check_receive(const GSUP__Types::GSUP__PDU_template& value_template, GSUP__Types::GSUP__PDU *value_redirect, const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (value_template.get_selection() == ANY_OR_OMIT) TTCN_error("Check-receive operation using '*' as matching template");
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (my_head->item_selection != MESSAGE_0) {
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC, "Matching on port %s failed: Type of the first message in the queue is not @GSUP_Types.GSUP_PDU.", port_name);
return ALT_NO;
} else if (!value_template.match(*my_head->message_0)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_MMUNSUCC : TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::message__does__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_0),
 TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
if (value_redirect != NULL) {
*value_redirect = *my_head->message_0;
}
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_success(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_0),
 TTCN_Logger::end_event_log2str()));
}
log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::check__receive__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @GSUP_Types.GSUP_PDU : "),
my_head->message_0->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
return ALT_YES;
}
}

alt_status GSUP__Conn__PT::trigger(const GSUP__Types::GSUP__PDU_template& value_template, GSUP__Types::GSUP__PDU *value_redirect, const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (value_template.get_selection() == ANY_OR_OMIT) TTCN_error("Trigger operation using '*' as matching template");
msg_queue_item *my_head = (msg_queue_item*)msg_queue_head;
if (msg_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(my_head->sender_component)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s will drop a message: Sender of the first message in the queue does not match the from clause: ", port_name);
sender_template.log_match(my_head->sender_component);
TTCN_Logger::end_event();
}
remove_msg_queue_head();
return ALT_REPEAT;
} else if (my_head->item_selection != MESSAGE_0) {
TTCN_Logger::log(my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMUNSUCC:TTCN_Logger::MATCHING_MCUNSUCC, "Matching on port %s will drop a message: Type of the first message in the queue is not @GSUP_Types.GSUP_PDU.", port_name);
remove_msg_queue_head();
return ALT_REPEAT;
} else if (!value_template.match(*my_head->message_0)) {
const TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_MMUNSUCC : TTCN_Logger::MATCHING_MCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::message__does__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_0),
 TTCN_Logger::end_event_log2str()));
}
remove_msg_queue_head();
return ALT_REPEAT;
} else {
if (value_redirect != NULL) {
*value_redirect = *my_head->message_0;
}
if (sender_ptr != NULL) *sender_ptr = my_head->sender_component;
TTCN_Logger::Severity log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_MMSUCCESS:TTCN_Logger::MATCHING_MCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_success(TitanLoggerApiSimple::PortType::message__,
port_name, my_head->sender_component,
(TTCN_Logger::begin_event(log_sev, TRUE), value_template.log_match(*my_head->message_0),
 TTCN_Logger::end_event_log2str()));
}
log_sev = my_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_MMRECV:TTCN_Logger::PORTEVENT_MCRECV;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_msgport_recv(port_name, TitanLoggerApiSimple::Msg__port__recv_operation::trigger__op,
my_head->sender_component, CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(log_sev,TRUE), TTCN_Logger::log_event_str(": @GSUP_Types.GSUP_PDU : "),
my_head->message_0->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_msg_queue_head();
return ALT_YES;
}
}

void GSUP__Conn__PT::incoming_message(const GSUP__Types::GSUP__PDU& incoming_par, component sender_component)
{
if (!is_started) {
if (is_halted) {
TTCN_warning("A message that arrived on port %s has been discarded, because the port is not started.", port_name);
return;
}
else {
TTCN_error("Port %s is not started but a message has arrived on it.", port_name);
}
}
msg_tail_count++;
if (TTCN_Logger::log_this_event(TTCN_Logger::PORTEVENT_MQUEUE)) {
TTCN_Logger::log_port_queue(TitanLoggerApiSimple::Port__Queue_operation::enqueue__msg, port_name, sender_component, msg_tail_count,
CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_MQUEUE, TRUE), TTCN_Logger::log_event_str(" @GSUP_Types.GSUP_PDU : "), incoming_par.log(), TTCN_Logger::end_event_log2str()));
}
msg_queue_item *new_item = new msg_queue_item;
new_item->item_selection = MESSAGE_0;
new_item->message_0 = new GSUP__Types::GSUP__PDU(incoming_par);
new_item->sender_component = sender_component;
append_to_msg_queue(new_item);
}

boolean GSUP__Conn__PT::process_message(const char *message_type, Text_Buf& incoming_buf, component sender_component, OCTETSTRING&)
{
if (!strcmp(message_type, "@GSUP_Types.GSUP_PDU")) {
GSUP__Types::GSUP__PDU incoming_par;
incoming_par.decode_text(incoming_buf);
incoming_message(incoming_par, sender_component);
return TRUE;
} else return FALSE;
}

ConnectionData::ConnectionData()
{
}

ConnectionData::ConnectionData(const COMPONENT& par_comp__ref,
    const CHARSTRING& par_imsi)
  :   field_comp__ref(par_comp__ref),
  field_imsi(par_imsi)
{
}

ConnectionData::ConnectionData(const ConnectionData& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GSUP_Emulation.ConnectionData.");
if (other_value.comp__ref().is_bound()) field_comp__ref = other_value.comp__ref();
else field_comp__ref.clean_up();
if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
else field_imsi.clean_up();
}

void ConnectionData::clean_up()
{
field_comp__ref.clean_up();
field_imsi.clean_up();
}

const TTCN_Typedescriptor_t* ConnectionData::get_descriptor() const { return &ConnectionData_descr_; }
ConnectionData& ConnectionData::operator=(const ConnectionData& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GSUP_Emulation.ConnectionData.");
  if (other_value.comp__ref().is_bound()) field_comp__ref = other_value.comp__ref();
  else field_comp__ref.clean_up();
  if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
  else field_imsi.clean_up();
}
return *this;
}

boolean ConnectionData::operator==(const ConnectionData& other_value) const
{
return field_comp__ref==other_value.field_comp__ref
  && field_imsi==other_value.field_imsi;
}

boolean ConnectionData::is_bound() const
{
return (field_comp__ref.is_bound())
  || (field_imsi.is_bound());
}
boolean ConnectionData::is_value() const
{
return field_comp__ref.is_value()
  && field_imsi.is_value();
}
void ConnectionData::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ comp_ref := ");
field_comp__ref.log();
TTCN_Logger::log_event_str(", imsi := ");
field_imsi.log();
TTCN_Logger::log_event_str(" }");
}

void ConnectionData::set_implicit_omit()
{
if (comp__ref().is_bound()) comp__ref().set_implicit_omit();
if (imsi().is_bound()) imsi().set_implicit_omit();
}

void ConnectionData::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @GSUP_Emulation.ConnectionData has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) comp__ref().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) imsi().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "comp_ref")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          comp__ref().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GSUP_Emulation.ConnectionData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GSUP_Emulation.ConnectionData");
  }
}

void ConnectionData::encode_text(Text_Buf& text_buf) const
{
field_comp__ref.encode_text(text_buf);
field_imsi.encode_text(text_buf);
}

void ConnectionData::decode_text(Text_Buf& text_buf)
{
field_comp__ref.decode_text(text_buf);
field_imsi.decode_text(text_buf);
}

struct ConnectionData_template::single_value_struct {
COMPONENT_template field_comp__ref;
CHARSTRING_template field_imsi;
};

void ConnectionData_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_comp__ref = ANY_VALUE;
single_value->field_imsi = ANY_VALUE;
}
}
}

void ConnectionData_template::copy_value(const ConnectionData& other_value)
{
single_value = new single_value_struct;
if (other_value.comp__ref().is_bound()) {
  single_value->field_comp__ref = other_value.comp__ref();
} else {
  single_value->field_comp__ref.clean_up();
}
if (other_value.imsi().is_bound()) {
  single_value->field_imsi = other_value.imsi();
} else {
  single_value->field_imsi.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ConnectionData_template::copy_template(const ConnectionData_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.comp__ref().get_selection()) {
single_value->field_comp__ref = other_value.comp__ref();
} else {
single_value->field_comp__ref.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.imsi().get_selection()) {
single_value->field_imsi = other_value.imsi();
} else {
single_value->field_imsi.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ConnectionData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ConnectionData_template(*other_value.implication_.precondition);
implication_.implied_template = new ConnectionData_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GSUP_Emulation.ConnectionData.");
break;
}
set_selection(other_value);
}

ConnectionData_template::ConnectionData_template()
{
}

ConnectionData_template::ConnectionData_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ConnectionData_template::ConnectionData_template(const ConnectionData& other_value)
{
copy_value(other_value);
}

ConnectionData_template::ConnectionData_template(const OPTIONAL<ConnectionData>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ConnectionData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GSUP_Emulation.ConnectionData from an unbound optional field.");
}
}

ConnectionData_template::ConnectionData_template(ConnectionData_template* p_precondition, ConnectionData_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ConnectionData_template::ConnectionData_template(Dynamic_Match_Interface<ConnectionData>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ConnectionData>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ConnectionData_template::ConnectionData_template(const ConnectionData_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ConnectionData_template::~ConnectionData_template()
{
clean_up();
}

ConnectionData_template& ConnectionData_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ConnectionData_template& ConnectionData_template::operator=(const ConnectionData& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ConnectionData_template& ConnectionData_template::operator=(const OPTIONAL<ConnectionData>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ConnectionData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GSUP_Emulation.ConnectionData.");
}
return *this;
}

ConnectionData_template& ConnectionData_template::operator=(const ConnectionData_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ConnectionData_template::match(const ConnectionData& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.comp__ref().is_bound()) return FALSE;
if(!single_value->field_comp__ref.match(other_value.comp__ref(), legacy))return FALSE;
if(!other_value.imsi().is_bound()) return FALSE;
if(!single_value->field_imsi.match(other_value.imsi(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GSUP_Emulation.ConnectionData.");
}
return FALSE;
}

boolean ConnectionData_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_comp__ref.is_bound()
 || single_value->field_imsi.is_bound();
}

boolean ConnectionData_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_comp__ref.is_value()
 && single_value->field_imsi.is_value();
}

void ConnectionData_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ConnectionData ConnectionData_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GSUP_Emulation.ConnectionData.");
ConnectionData ret_val;
if (single_value->field_comp__ref.is_bound()) {
ret_val.comp__ref() = single_value->field_comp__ref.valueof();
}
if (single_value->field_imsi.is_bound()) {
ret_val.imsi() = single_value->field_imsi.valueof();
}
return ret_val;
}

void ConnectionData_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GSUP_Emulation.ConnectionData.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ConnectionData_template[list_length];
}

ConnectionData_template& ConnectionData_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GSUP_Emulation.ConnectionData.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GSUP_Emulation.ConnectionData.");
return value_list.list_value[list_index];
}

COMPONENT_template& ConnectionData_template::comp__ref()
{
set_specific();
return single_value->field_comp__ref;
}

const COMPONENT_template& ConnectionData_template::comp__ref() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field comp_ref of a non-specific template of type @GSUP_Emulation.ConnectionData.");
return single_value->field_comp__ref;
}

CHARSTRING_template& ConnectionData_template::imsi()
{
set_specific();
return single_value->field_imsi;
}

const CHARSTRING_template& ConnectionData_template::imsi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field imsi of a non-specific template of type @GSUP_Emulation.ConnectionData.");
return single_value->field_imsi;
}

int ConnectionData_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.ConnectionData which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GSUP_Emulation.ConnectionData containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.ConnectionData containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.ConnectionData containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.ConnectionData containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.ConnectionData containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.ConnectionData containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.ConnectionData containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.ConnectionData containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GSUP_Emulation.ConnectionData.");
  }
  return 0;
}

void ConnectionData_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ comp_ref := ");
single_value->field_comp__ref.log();
TTCN_Logger::log_event_str(", imsi := ");
single_value->field_imsi.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ConnectionData_template::log_match(const ConnectionData& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_comp__ref.match(match_value.comp__ref(), legacy)){
TTCN_Logger::log_logmatch_info(".comp_ref");
single_value->field_comp__ref.log_match(match_value.comp__ref(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_imsi.match(match_value.imsi(), legacy)){
TTCN_Logger::log_logmatch_info(".imsi");
single_value->field_imsi.log_match(match_value.imsi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ comp_ref := ");
single_value->field_comp__ref.log_match(match_value.comp__ref(), legacy);
TTCN_Logger::log_event_str(", imsi := ");
single_value->field_imsi.log_match(match_value.imsi(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ConnectionData_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (comp__ref().is_bound()) comp__ref().set_implicit_omit();
if (imsi().is_bound()) imsi().set_implicit_omit();
}

void ConnectionData_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_comp__ref.encode_text(text_buf);
single_value->field_imsi.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GSUP_Emulation.ConnectionData.");
}
}

void ConnectionData_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_comp__ref.decode_text(text_buf);
single_value->field_imsi.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ConnectionData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GSUP_Emulation.ConnectionData.");
}
}

void ConnectionData_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ConnectionData_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @GSUP_Emulation.ConnectionData has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) comp__ref().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) imsi().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "comp_ref")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          comp__ref().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GSUP_Emulation.ConnectionData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ConnectionData_template* precondition = new ConnectionData_template;
    precondition->set_param(*param.get_elem(0));
    ConnectionData_template* implied_template = new ConnectionData_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ConnectionData_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GSUP_Emulation.ConnectionData");
  }
  is_ifpresent = param.get_ifpresent();
}

void ConnectionData_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_comp__ref.check_restriction(t_res, t_name ? t_name : "@GSUP_Emulation.ConnectionData");
single_value->field_imsi.check_restriction(t_res, t_name ? t_name : "@GSUP_Emulation.ConnectionData");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GSUP_Emulation.ConnectionData");
}

boolean ConnectionData_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ConnectionData_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

ExpectData::ExpectData()
{
}

ExpectData::ExpectData(const OPTIONAL< CHARSTRING >& par_imsi,
    const COMPONENT& par_vc__conn)
  :   field_imsi(par_imsi),
  field_vc__conn(par_vc__conn)
{
}

ExpectData::ExpectData(const ExpectData& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GSUP_Emulation.ExpectData.");
if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
else field_imsi.clean_up();
if (other_value.vc__conn().is_bound()) field_vc__conn = other_value.vc__conn();
else field_vc__conn.clean_up();
}

void ExpectData::clean_up()
{
field_imsi.clean_up();
field_vc__conn.clean_up();
}

const TTCN_Typedescriptor_t* ExpectData::get_descriptor() const { return &ExpectData_descr_; }
ExpectData& ExpectData::operator=(const ExpectData& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GSUP_Emulation.ExpectData.");
  if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
  else field_imsi.clean_up();
  if (other_value.vc__conn().is_bound()) field_vc__conn = other_value.vc__conn();
  else field_vc__conn.clean_up();
}
return *this;
}

boolean ExpectData::operator==(const ExpectData& other_value) const
{
return field_imsi==other_value.field_imsi
  && field_vc__conn==other_value.field_vc__conn;
}

boolean ExpectData::is_bound() const
{
return (OPTIONAL_OMIT == field_imsi.get_selection() || field_imsi.is_bound())
  || (field_vc__conn.is_bound());
}
boolean ExpectData::is_value() const
{
return (OPTIONAL_OMIT == field_imsi.get_selection() || field_imsi.is_value())
  && field_vc__conn.is_value();
}
int ExpectData::size_of() const
{
  int ret_val = 1;
  if (field_imsi.ispresent()) ret_val++;
  return ret_val;
}

void ExpectData::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ imsi := ");
field_imsi.log();
TTCN_Logger::log_event_str(", vc_conn := ");
field_vc__conn.log();
TTCN_Logger::log_event_str(" }");
}

void ExpectData::set_implicit_omit()
{
if (!imsi().is_bound()) imsi() = OMIT_VALUE;
else imsi().set_implicit_omit();
if (vc__conn().is_bound()) vc__conn().set_implicit_omit();
}

void ExpectData::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @GSUP_Emulation.ExpectData has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) imsi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) vc__conn().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vc_conn")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vc__conn().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GSUP_Emulation.ExpectData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GSUP_Emulation.ExpectData");
  }
}

void ExpectData::encode_text(Text_Buf& text_buf) const
{
field_imsi.encode_text(text_buf);
field_vc__conn.encode_text(text_buf);
}

void ExpectData::decode_text(Text_Buf& text_buf)
{
field_imsi.decode_text(text_buf);
field_vc__conn.decode_text(text_buf);
}

struct ExpectData_template::single_value_struct {
CHARSTRING_template field_imsi;
COMPONENT_template field_vc__conn;
};

void ExpectData_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_imsi = ANY_OR_OMIT;
single_value->field_vc__conn = ANY_VALUE;
}
}
}

void ExpectData_template::copy_value(const ExpectData& other_value)
{
single_value = new single_value_struct;
if (other_value.imsi().is_bound()) {
  if (other_value.imsi().ispresent()) single_value->field_imsi = other_value.imsi()();
  else single_value->field_imsi = OMIT_VALUE;
} else {
  single_value->field_imsi.clean_up();
}
if (other_value.vc__conn().is_bound()) {
  single_value->field_vc__conn = other_value.vc__conn();
} else {
  single_value->field_vc__conn.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void ExpectData_template::copy_template(const ExpectData_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.imsi().get_selection()) {
single_value->field_imsi = other_value.imsi();
} else {
single_value->field_imsi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.vc__conn().get_selection()) {
single_value->field_vc__conn = other_value.vc__conn();
} else {
single_value->field_vc__conn.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new ExpectData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new ExpectData_template(*other_value.implication_.precondition);
implication_.implied_template = new ExpectData_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GSUP_Emulation.ExpectData.");
break;
}
set_selection(other_value);
}

ExpectData_template::ExpectData_template()
{
}

ExpectData_template::ExpectData_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

ExpectData_template::ExpectData_template(const ExpectData& other_value)
{
copy_value(other_value);
}

ExpectData_template::ExpectData_template(const OPTIONAL<ExpectData>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ExpectData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GSUP_Emulation.ExpectData from an unbound optional field.");
}
}

ExpectData_template::ExpectData_template(ExpectData_template* p_precondition, ExpectData_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

ExpectData_template::ExpectData_template(Dynamic_Match_Interface<ExpectData>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<ExpectData>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

ExpectData_template::ExpectData_template(const ExpectData_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

ExpectData_template::~ExpectData_template()
{
clean_up();
}

ExpectData_template& ExpectData_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

ExpectData_template& ExpectData_template::operator=(const ExpectData& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

ExpectData_template& ExpectData_template::operator=(const OPTIONAL<ExpectData>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const ExpectData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GSUP_Emulation.ExpectData.");
}
return *this;
}

ExpectData_template& ExpectData_template::operator=(const ExpectData_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean ExpectData_template::match(const ExpectData& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.imsi().is_bound()) return FALSE;
if((other_value.imsi().ispresent() ? !single_value->field_imsi.match((const CHARSTRING&)other_value.imsi(), legacy) : !single_value->field_imsi.match_omit(legacy)))return FALSE;
if(!other_value.vc__conn().is_bound()) return FALSE;
if(!single_value->field_vc__conn.match(other_value.vc__conn(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GSUP_Emulation.ExpectData.");
}
return FALSE;
}

boolean ExpectData_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_imsi.is_omit() || single_value->field_imsi.is_bound())
 || single_value->field_vc__conn.is_bound();
}

boolean ExpectData_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_imsi.is_omit() || single_value->field_imsi.is_value())
 && single_value->field_vc__conn.is_value();
}

void ExpectData_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

ExpectData ExpectData_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GSUP_Emulation.ExpectData.");
ExpectData ret_val;
if (single_value->field_imsi.is_omit()) ret_val.imsi() = OMIT_VALUE;
else if (single_value->field_imsi.is_bound()) {
ret_val.imsi() = single_value->field_imsi.valueof();
}
if (single_value->field_vc__conn.is_bound()) {
ret_val.vc__conn() = single_value->field_vc__conn.valueof();
}
return ret_val;
}

void ExpectData_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GSUP_Emulation.ExpectData.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new ExpectData_template[list_length];
}

ExpectData_template& ExpectData_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GSUP_Emulation.ExpectData.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GSUP_Emulation.ExpectData.");
return value_list.list_value[list_index];
}

CHARSTRING_template& ExpectData_template::imsi()
{
set_specific();
return single_value->field_imsi;
}

const CHARSTRING_template& ExpectData_template::imsi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field imsi of a non-specific template of type @GSUP_Emulation.ExpectData.");
return single_value->field_imsi;
}

COMPONENT_template& ExpectData_template::vc__conn()
{
set_specific();
return single_value->field_vc__conn;
}

const COMPONENT_template& ExpectData_template::vc__conn() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field vc_conn of a non-specific template of type @GSUP_Emulation.ExpectData.");
return single_value->field_vc__conn;
}

int ExpectData_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.ExpectData which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 1;
      if (single_value->field_imsi.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GSUP_Emulation.ExpectData containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.ExpectData containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.ExpectData containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.ExpectData containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.ExpectData containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.ExpectData containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.ExpectData containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.ExpectData containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GSUP_Emulation.ExpectData.");
  }
  return 0;
}

void ExpectData_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ imsi := ");
single_value->field_imsi.log();
TTCN_Logger::log_event_str(", vc_conn := ");
single_value->field_vc__conn.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void ExpectData_template::log_match(const ExpectData& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.imsi().ispresent()){
if(!single_value->field_imsi.match(match_value.imsi(), legacy)){
TTCN_Logger::log_logmatch_info(".imsi");
single_value->field_imsi.log_match(match_value.imsi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_imsi.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".imsi := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_imsi.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if(!single_value->field_vc__conn.match(match_value.vc__conn(), legacy)){
TTCN_Logger::log_logmatch_info(".vc_conn");
single_value->field_vc__conn.log_match(match_value.vc__conn(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ imsi := ");
if (match_value.imsi().ispresent()) {
single_value->field_imsi.log_match(match_value.imsi(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_imsi.log();
if (single_value->field_imsi.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", vc_conn := ");
single_value->field_vc__conn.log_match(match_value.vc__conn(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void ExpectData_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!imsi().is_bound()) imsi() = OMIT_VALUE;
else imsi().set_implicit_omit();
if (vc__conn().is_bound()) vc__conn().set_implicit_omit();
}

void ExpectData_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_imsi.encode_text(text_buf);
single_value->field_vc__conn.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GSUP_Emulation.ExpectData.");
}
}

void ExpectData_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_imsi.decode_text(text_buf);
single_value->field_vc__conn.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new ExpectData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GSUP_Emulation.ExpectData.");
}
}

void ExpectData_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    ExpectData_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @GSUP_Emulation.ExpectData has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) imsi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) vc__conn().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vc_conn")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vc__conn().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GSUP_Emulation.ExpectData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    ExpectData_template* precondition = new ExpectData_template;
    precondition->set_param(*param.get_elem(0));
    ExpectData_template* implied_template = new ExpectData_template;
    implied_template->set_param(*param.get_elem(1));
    *this = ExpectData_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GSUP_Emulation.ExpectData");
  }
  is_ifpresent = param.get_ifpresent();
}

void ExpectData_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_imsi.check_restriction(t_res, t_name ? t_name : "@GSUP_Emulation.ExpectData");
single_value->field_vc__conn.check_restriction(t_res, t_name ? t_name : "@GSUP_Emulation.ExpectData");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GSUP_Emulation.ExpectData");
}

boolean ExpectData_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean ExpectData_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

GsupCreateCallback::GsupCreateCallback()
{
referred_function = NULL;
}

GsupCreateCallback::GsupCreateCallback(function_pointer other_value)
{
referred_function = other_value;
}

GsupCreateCallback::GsupCreateCallback(const GsupCreateCallback& other_value)
: Base_Type(){
other_value.must_bound("Copying an unbound @GSUP_Emulation.GsupCreateCallback value.");
referred_function = other_value.referred_function;
}

GsupCreateCallback& GsupCreateCallback::operator=(function_pointer other_value)
{
referred_function = other_value;
return *this;
}

GsupCreateCallback& GsupCreateCallback::operator=(const GsupCreateCallback& other_value)
{
other_value.must_bound("Assignment of an unbound value.");
referred_function = other_value.referred_function;
return *this;
}

boolean GsupCreateCallback::operator==(function_pointer other_value) const
{
must_bound("Unbound left operand of @GSUP_Emulation.GsupCreateCallback comparison.");
return referred_function == other_value;
}

boolean GsupCreateCallback::operator==(const GsupCreateCallback& other_value) const
{
must_bound("Unbound left operand of @GSUP_Emulation.GsupCreateCallback comparison.");
other_value.must_bound("Unbound right operand of @GSUP_Emulation.GsupCreateCallback comparison.");
return referred_function == other_value.referred_function;
}

COMPONENT GsupCreateCallback::invoke(const GSUP__Types::GSUP__PDU& gsup, const CHARSTRING& id) const
{
must_bound("Call of unbound function.");
if(referred_function == (GsupCreateCallback::function_pointer)Module_List::get_fat_null())
TTCN_error("null reference cannot be invoked.");
return referred_function(gsup, id);
}

void GsupCreateCallback::start(const COMPONENT& component_reference, const GSUP__Types::GSUP__PDU& gsup, const CHARSTRING& id) const
{
((GsupCreateCallback::start_pointer)Module_List::lookup_start_by_function_address((genericfunc_t)referred_function))(component_reference, gsup, id);
}

void GsupCreateCallback::log() const
{
Module_List::log_function((genericfunc_t)referred_function);
}

void GsupCreateCallback::set_param(Module_Param& param)
{
  param.error("Not supported.");
}

void GsupCreateCallback::encode_text(Text_Buf& text_buf) const
{
Module_List::encode_function(text_buf,(genericfunc_t)referred_function);
}

void GsupCreateCallback::decode_text(Text_Buf& text_buf)
{
Module_List::decode_function(text_buf,(genericfunc_t*)&referred_function);
}

boolean operator==(GsupCreateCallback::function_pointer value, const GsupCreateCallback& other_value)
{
other_value.must_bound("Unbound right operand of @GSUP_Emulation.GsupCreateCallback comparison.");
return value == other_value.referred_function;
}

void GsupCreateCallback_template::copy_template(const GsupCreateCallback_template& other_value)
{
switch(other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new GsupCreateCallback_template[value_list.n_values];
for(unsigned int i = 0; i < value_list.n_values; i++)
value_list.list_value[i] = other_value.value_list.list_value[i];
break;
default:
TTCN_error("Copying an unitialized/unsupported @GSUP_Emulation.GsupCreateCallback template.");
}
set_selection(other_value);
}

GsupCreateCallback_template::GsupCreateCallback_template()
{
}

GsupCreateCallback_template::GsupCreateCallback_template(template_sel other_value)
  : Base_Template(other_value)
{
check_single_selection(other_value);
}

GsupCreateCallback_template::GsupCreateCallback_template(GsupCreateCallback::function_pointer other_value)
  : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

GsupCreateCallback_template::GsupCreateCallback_template(const GsupCreateCallback& other_value)
  :Base_Template(SPECIFIC_VALUE)
{
other_value.must_bound("Creating a template from an unbound @GSUP_Emulation.GsupCreateCallback value.");
single_value = other_value.referred_function;
}

GsupCreateCallback_template::GsupCreateCallback_template(const OPTIONAL<GsupCreateCallback>& other_value)
{
if(other_value.ispresent()) {
set_selection(SPECIFIC_VALUE);
single_value = ((const GsupCreateCallback&)other_value()).referred_function;
} else set_selection(OMIT_VALUE);
}

GsupCreateCallback_template::GsupCreateCallback_template(const GsupCreateCallback_template& other_value)
  :Base_Template()
{
copy_template(other_value);
}

GsupCreateCallback_template::~GsupCreateCallback_template()
{
  clean_up();
}

void GsupCreateCallback_template::clean_up(){
if(template_selection == VALUE_LIST ||
template_selection == COMPLEMENTED_LIST)
delete[] value_list.list_value;
template_selection = UNINITIALIZED_TEMPLATE;
}

GsupCreateCallback_template& GsupCreateCallback_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

GsupCreateCallback_template& GsupCreateCallback_template::operator=(GsupCreateCallback::function_pointer other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;}

GsupCreateCallback_template& GsupCreateCallback_template::operator=(const GsupCreateCallback& other_value)
{
other_value.must_bound("Assignment of an unbound @GSUP_Emulation.GsupCreateCallback value to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.referred_function;
return *this;
}

GsupCreateCallback_template& GsupCreateCallback_template::operator=(const OPTIONAL<GsupCreateCallback>& other_value)
{
clean_up();
if(other_value.ispresent()) { 
set_selection(SPECIFIC_VALUE);
single_value = ((const GsupCreateCallback&)other_value()).referred_function;
} else set_selection(OMIT_VALUE);
return *this;}

GsupCreateCallback_template& GsupCreateCallback_template::operator=(const GsupCreateCallback_template& other_value)
{
if(&other_value != this) {
clean_up();copy_template(other_value);
}
return *this;
}

boolean GsupCreateCallback_template::match(GsupCreateCallback::function_pointer other_value, boolean) const
{
switch(template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for(unsigned int i = 0; i < value_list.n_values; i++)
if(value_list.list_value[i].match(other_value))
return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
default:
TTCN_error("Matching with an unitialized/unsupported @GSUP_Emulation.GsupCreateCallback template.");
};
return FALSE;
}

boolean GsupCreateCallback_template::match(const GsupCreateCallback& other_value, boolean) const
{
  if (!other_value.is_bound()) return FALSE;
return match(other_value.referred_function);
}

GsupCreateCallback GsupCreateCallback_template::valueof() const
{
if(template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific @GSUP_Emulation.GsupCreateCallback template.");
return single_value;
}

void GsupCreateCallback_template::set_type(template_sel template_type, unsigned int list_length)
{
if(template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST)
TTCN_error("Setting an invalid type for an @GSUP_Emulation.GsupCreateCallback template.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new GsupCreateCallback_template[list_length];
}

GsupCreateCallback_template& GsupCreateCallback_template::list_item(unsigned int list_index) const
{
if(template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST)
TTCN_error("Accessing a list element of a non-list template of type @GSUP_Emulation.GsupCreateCallback");
if(list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GSUP_Emulation.GsupCreateCallback.");
return value_list.list_value[list_index];
}

void GsupCreateCallback_template::log() const
{
switch(template_selection) {
case SPECIFIC_VALUE:
Module_List::log_function((genericfunc_t)single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case VALUE_LIST:
TTCN_Logger::log_char('(');
for(unsigned int i = 0; i < value_list.n_values; i++) {
if(i > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[i].log();
}
TTCN_Logger::log_char(')');
break;
default:
log_generic();
}
log_ifpresent();
}

void GsupCreateCallback_template::log_match(const GsupCreateCallback& match_value, boolean legacy) const
{
log();
TTCN_Logger::log_event_str(" with ");
match_value.log();
if(match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void GsupCreateCallback_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch(template_selection) {
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case SPECIFIC_VALUE:
Module_List::encode_function(text_buf, (genericfunc_t)single_value);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for(unsigned int i = 0; i < value_list.n_values; i++)
value_list.list_value[i].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GSUP_Emulation.GsupCreateCallback.");
}
}

void GsupCreateCallback_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch(template_selection) {
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case SPECIFIC_VALUE:
Module_List::decode_function(text_buf,(genericfunc_t*)&single_value);
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new GsupCreateCallback_template[value_list.n_values];
for(unsigned int i = 0; i < value_list.n_values; i++)
value_list.list_value[i].decode_text(text_buf);
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GSUP_Emulation.GsupCreateCallback.");
}
}

boolean GsupCreateCallback_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean GsupCreateCallback_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void GsupCreateCallback_template::set_param(Module_Param& param)
{
  param.error("Not supported.");
}

void GsupCreateCallback_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GSUP_Emulation.GsupCreateCallback");
}

GsupOps::GsupOps()
{
}

GsupOps::GsupOps(const GsupCreateCallback& par_create__cb)
  :   field_create__cb(par_create__cb)
{
}

GsupOps::GsupOps(const GsupOps& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @GSUP_Emulation.GsupOps.");
if (other_value.create__cb().is_bound()) field_create__cb = other_value.create__cb();
else field_create__cb.clean_up();
}

void GsupOps::clean_up()
{
field_create__cb.clean_up();
}

const TTCN_Typedescriptor_t* GsupOps::get_descriptor() const { return &GsupOps_descr_; }
GsupOps& GsupOps::operator=(const GsupOps& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @GSUP_Emulation.GsupOps.");
  if (other_value.create__cb().is_bound()) field_create__cb = other_value.create__cb();
  else field_create__cb.clean_up();
}
return *this;
}

boolean GsupOps::operator==(const GsupOps& other_value) const
{
return field_create__cb==other_value.field_create__cb;
}

boolean GsupOps::is_bound() const
{
return (field_create__cb.is_bound());
}
boolean GsupOps::is_value() const
{
return field_create__cb.is_value();
}
void GsupOps::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ create_cb := ");
field_create__cb.log();
TTCN_Logger::log_event_str(" }");
}

void GsupOps::set_implicit_omit()
{
if (create__cb().is_bound()) create__cb().set_implicit_omit();
}

void GsupOps::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @GSUP_Emulation.GsupOps has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) create__cb().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "create_cb")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          create__cb().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GSUP_Emulation.GsupOps: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@GSUP_Emulation.GsupOps");
  }
}

void GsupOps::encode_text(Text_Buf& text_buf) const
{
field_create__cb.encode_text(text_buf);
}

void GsupOps::decode_text(Text_Buf& text_buf)
{
field_create__cb.decode_text(text_buf);
}

struct GsupOps_template::single_value_struct {
GsupCreateCallback_template field_create__cb;
};

void GsupOps_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_create__cb = ANY_VALUE;
}
}
}

void GsupOps_template::copy_value(const GsupOps& other_value)
{
single_value = new single_value_struct;
if (other_value.create__cb().is_bound()) {
  single_value->field_create__cb = other_value.create__cb();
} else {
  single_value->field_create__cb.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void GsupOps_template::copy_template(const GsupOps_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.create__cb().get_selection()) {
single_value->field_create__cb = other_value.create__cb();
} else {
single_value->field_create__cb.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new GsupOps_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new GsupOps_template(*other_value.implication_.precondition);
implication_.implied_template = new GsupOps_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @GSUP_Emulation.GsupOps.");
break;
}
set_selection(other_value);
}

GsupOps_template::GsupOps_template()
{
}

GsupOps_template::GsupOps_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

GsupOps_template::GsupOps_template(const GsupOps& other_value)
{
copy_value(other_value);
}

GsupOps_template::GsupOps_template(const OPTIONAL<GsupOps>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const GsupOps&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @GSUP_Emulation.GsupOps from an unbound optional field.");
}
}

GsupOps_template::GsupOps_template(GsupOps_template* p_precondition, GsupOps_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

GsupOps_template::GsupOps_template(Dynamic_Match_Interface<GsupOps>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<GsupOps>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

GsupOps_template::GsupOps_template(const GsupOps_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

GsupOps_template::~GsupOps_template()
{
clean_up();
}

GsupOps_template& GsupOps_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

GsupOps_template& GsupOps_template::operator=(const GsupOps& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

GsupOps_template& GsupOps_template::operator=(const OPTIONAL<GsupOps>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const GsupOps&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @GSUP_Emulation.GsupOps.");
}
return *this;
}

GsupOps_template& GsupOps_template::operator=(const GsupOps_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean GsupOps_template::match(const GsupOps& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.create__cb().is_bound()) return FALSE;
if(!single_value->field_create__cb.match(other_value.create__cb(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @GSUP_Emulation.GsupOps.");
}
return FALSE;
}

boolean GsupOps_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_create__cb.is_bound();
}

boolean GsupOps_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_create__cb.is_value();
}

void GsupOps_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

GsupOps GsupOps_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @GSUP_Emulation.GsupOps.");
GsupOps ret_val;
if (single_value->field_create__cb.is_bound()) {
ret_val.create__cb() = single_value->field_create__cb.valueof();
}
return ret_val;
}

void GsupOps_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @GSUP_Emulation.GsupOps.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new GsupOps_template[list_length];
}

GsupOps_template& GsupOps_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @GSUP_Emulation.GsupOps.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @GSUP_Emulation.GsupOps.");
return value_list.list_value[list_index];
}

GsupCreateCallback_template& GsupOps_template::create__cb()
{
set_specific();
return single_value->field_create__cb;
}

const GsupCreateCallback_template& GsupOps_template::create__cb() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field create_cb of a non-specific template of type @GSUP_Emulation.GsupOps.");
return single_value->field_create__cb;
}

int GsupOps_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.GsupOps which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 1;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @GSUP_Emulation.GsupOps containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.GsupOps containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.GsupOps containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.GsupOps containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.GsupOps containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.GsupOps containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.GsupOps containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @GSUP_Emulation.GsupOps containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @GSUP_Emulation.GsupOps.");
  }
  return 0;
}

void GsupOps_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ create_cb := ");
single_value->field_create__cb.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void GsupOps_template::log_match(const GsupOps& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_create__cb.match(match_value.create__cb(), legacy)){
TTCN_Logger::log_logmatch_info(".create_cb");
single_value->field_create__cb.log_match(match_value.create__cb(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ create_cb := ");
single_value->field_create__cb.log_match(match_value.create__cb(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void GsupOps_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (create__cb().is_bound()) create__cb().set_implicit_omit();
}

void GsupOps_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_create__cb.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @GSUP_Emulation.GsupOps.");
}
}

void GsupOps_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_create__cb.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new GsupOps_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @GSUP_Emulation.GsupOps.");
}
}

void GsupOps_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    GsupOps_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @GSUP_Emulation.GsupOps has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) create__cb().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "create_cb")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          create__cb().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @GSUP_Emulation.GsupOps: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    GsupOps_template* precondition = new GsupOps_template;
    precondition->set_param(*param.get_elem(0));
    GsupOps_template* implied_template = new GsupOps_template;
    implied_template->set_param(*param.get_elem(1));
    *this = GsupOps_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@GSUP_Emulation.GsupOps");
  }
  is_ifpresent = param.get_ifpresent();
}

void GsupOps_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_create__cb.check_restriction(t_res, t_name ? t_name : "@GSUP_Emulation.GsupOps");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@GSUP_Emulation.GsupOps");
}

boolean GsupOps_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean GsupOps_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void GSUPEM__register__expect_call::encode_text(Text_Buf& text_buf) const
{
param_imsi.encode_text(text_buf);
param_hdlr.encode_text(text_buf);
}

void GSUPEM__register__expect_call::decode_text(Text_Buf& text_buf)
{
param_imsi.decode_text(text_buf);
param_hdlr.decode_text(text_buf);
}

void GSUPEM__register__expect_call::log() const
{
TTCN_Logger::log_event_str("@GSUP_Emulation.GSUPEM_register_expect : { ");
TTCN_Logger::log_event_str("imsi := ");
param_imsi.log();
TTCN_Logger::log_event_str(", hdlr := ");
param_hdlr.log();
TTCN_Logger::log_event_str(" }");
}

void GSUPEM__register__expect_call_redirect::set_parameters(const GSUPEM__register__expect_call& call_par) const
{
if (ptr_imsi != NULL) *ptr_imsi = call_par.imsi();
if (ptr_hdlr != NULL) *ptr_hdlr = call_par.hdlr();
}

void GSUPEM__register__expect_reply::log() const
{
TTCN_Logger::log_event_str("@GSUP_Emulation.GSUPEM_register_expect : { }");
}

GSUPEM__register__expect_template::GSUPEM__register__expect_template()
 : param_imsi(ANY_VALUE), param_hdlr(ANY_VALUE)
{
}

GSUPEM__register__expect_call GSUPEM__register__expect_template::create_call() const
{
GSUPEM__register__expect_call ret_val;
ret_val.imsi() = param_imsi.valueof();
ret_val.hdlr() = param_hdlr.valueof();
return ret_val;
}

boolean GSUPEM__register__expect_template::match_call(const GSUPEM__register__expect_call& match_value, boolean legacy) const
{
return param_imsi.match(match_value.imsi(), legacy) &&
param_hdlr.match(match_value.hdlr(), legacy);
}

void GSUPEM__register__expect_template::log() const
{
TTCN_Logger::log_event_str("{ imsi := ");
param_imsi.log();
TTCN_Logger::log_event_str(", hdlr := ");
param_hdlr.log();
TTCN_Logger::log_event_str(" }");
}

void GSUPEM__register__expect_template::log_match_call(const GSUPEM__register__expect_call& match_value, boolean legacy) const
{
TTCN_Logger::log_event_str("{ imsi := ");
param_imsi.log_match(match_value.imsi(), legacy);
TTCN_Logger::log_event_str(", hdlr := ");
param_hdlr.log_match(match_value.hdlr(), legacy);
TTCN_Logger::log_event_str(" }");
}

void GSUPEM__register__expect_template::log_match_reply(const GSUPEM__register__expect_reply& , boolean) const
{
TTCN_Logger::log_event_str("{ } with { } matched");
}

void GSUPEM__register__expect_template::encode_text(Text_Buf& text_buf) const
{
param_imsi.encode_text(text_buf);
param_hdlr.encode_text(text_buf);
}

void GSUPEM__register__expect_template::decode_text(Text_Buf& text_buf)
{
param_imsi.decode_text(text_buf);
param_hdlr.decode_text(text_buf);
}

void GSUPEM__unregister__expect_call::encode_text(Text_Buf& text_buf) const
{
param_imsi.encode_text(text_buf);
param_hdlr.encode_text(text_buf);
}

void GSUPEM__unregister__expect_call::decode_text(Text_Buf& text_buf)
{
param_imsi.decode_text(text_buf);
param_hdlr.decode_text(text_buf);
}

void GSUPEM__unregister__expect_call::log() const
{
TTCN_Logger::log_event_str("@GSUP_Emulation.GSUPEM_unregister_expect : { ");
TTCN_Logger::log_event_str("imsi := ");
param_imsi.log();
TTCN_Logger::log_event_str(", hdlr := ");
param_hdlr.log();
TTCN_Logger::log_event_str(" }");
}

void GSUPEM__unregister__expect_call_redirect::set_parameters(const GSUPEM__unregister__expect_call& call_par) const
{
if (ptr_imsi != NULL) *ptr_imsi = call_par.imsi();
if (ptr_hdlr != NULL) *ptr_hdlr = call_par.hdlr();
}

void GSUPEM__unregister__expect_reply::log() const
{
TTCN_Logger::log_event_str("@GSUP_Emulation.GSUPEM_unregister_expect : { }");
}

GSUPEM__unregister__expect_template::GSUPEM__unregister__expect_template()
 : param_imsi(ANY_VALUE), param_hdlr(ANY_VALUE)
{
}

GSUPEM__unregister__expect_call GSUPEM__unregister__expect_template::create_call() const
{
GSUPEM__unregister__expect_call ret_val;
ret_val.imsi() = param_imsi.valueof();
ret_val.hdlr() = param_hdlr.valueof();
return ret_val;
}

boolean GSUPEM__unregister__expect_template::match_call(const GSUPEM__unregister__expect_call& match_value, boolean legacy) const
{
return param_imsi.match(match_value.imsi(), legacy) &&
param_hdlr.match(match_value.hdlr(), legacy);
}

void GSUPEM__unregister__expect_template::log() const
{
TTCN_Logger::log_event_str("{ imsi := ");
param_imsi.log();
TTCN_Logger::log_event_str(", hdlr := ");
param_hdlr.log();
TTCN_Logger::log_event_str(" }");
}

void GSUPEM__unregister__expect_template::log_match_call(const GSUPEM__unregister__expect_call& match_value, boolean legacy) const
{
TTCN_Logger::log_event_str("{ imsi := ");
param_imsi.log_match(match_value.imsi(), legacy);
TTCN_Logger::log_event_str(", hdlr := ");
param_hdlr.log_match(match_value.hdlr(), legacy);
TTCN_Logger::log_event_str(" }");
}

void GSUPEM__unregister__expect_template::log_match_reply(const GSUPEM__unregister__expect_reply& , boolean) const
{
TTCN_Logger::log_event_str("{ } with { } matched");
}

void GSUPEM__unregister__expect_template::encode_text(Text_Buf& text_buf) const
{
param_imsi.encode_text(text_buf);
param_hdlr.encode_text(text_buf);
}

void GSUPEM__unregister__expect_template::decode_text(Text_Buf& text_buf)
{
param_imsi.decode_text(text_buf);
param_hdlr.decode_text(text_buf);
}

void GSUPEM__unregister__connhdlr_call::encode_text(Text_Buf& text_buf) const
{
param_imsi.encode_text(text_buf);
}

void GSUPEM__unregister__connhdlr_call::decode_text(Text_Buf& text_buf)
{
param_imsi.decode_text(text_buf);
}

void GSUPEM__unregister__connhdlr_call::log() const
{
TTCN_Logger::log_event_str("@GSUP_Emulation.GSUPEM_unregister_connhdlr : { ");
TTCN_Logger::log_event_str("imsi := ");
param_imsi.log();
TTCN_Logger::log_event_str(" }");
}

void GSUPEM__unregister__connhdlr_call_redirect::set_parameters(const GSUPEM__unregister__connhdlr_call& call_par) const
{
if (ptr_imsi != NULL) *ptr_imsi = call_par.imsi();
}

void GSUPEM__unregister__connhdlr_reply::log() const
{
TTCN_Logger::log_event_str("@GSUP_Emulation.GSUPEM_unregister_connhdlr : { }");
}

GSUPEM__unregister__connhdlr_template::GSUPEM__unregister__connhdlr_template()
 : param_imsi(ANY_VALUE)
{
}

GSUPEM__unregister__connhdlr_call GSUPEM__unregister__connhdlr_template::create_call() const
{
GSUPEM__unregister__connhdlr_call ret_val;
ret_val.imsi() = param_imsi.valueof();
return ret_val;
}

boolean GSUPEM__unregister__connhdlr_template::match_call(const GSUPEM__unregister__connhdlr_call& match_value, boolean legacy) const
{
return param_imsi.match(match_value.imsi(), legacy);
}

void GSUPEM__unregister__connhdlr_template::log() const
{
TTCN_Logger::log_event_str("{ imsi := ");
param_imsi.log();
TTCN_Logger::log_event_str(" }");
}

void GSUPEM__unregister__connhdlr_template::log_match_call(const GSUPEM__unregister__connhdlr_call& match_value, boolean legacy) const
{
TTCN_Logger::log_event_str("{ imsi := ");
param_imsi.log_match(match_value.imsi(), legacy);
TTCN_Logger::log_event_str(" }");
}

void GSUPEM__unregister__connhdlr_template::log_match_reply(const GSUPEM__unregister__connhdlr_reply& , boolean) const
{
TTCN_Logger::log_event_str("{ } with { } matched");
}

void GSUPEM__unregister__connhdlr_template::encode_text(Text_Buf& text_buf) const
{
param_imsi.encode_text(text_buf);
}

void GSUPEM__unregister__connhdlr_template::decode_text(Text_Buf& text_buf)
{
param_imsi.decode_text(text_buf);
}

void GSUPEM__change__connhdlr_call::encode_text(Text_Buf& text_buf) const
{
param_imsi.encode_text(text_buf);
param_hdlr.encode_text(text_buf);
}

void GSUPEM__change__connhdlr_call::decode_text(Text_Buf& text_buf)
{
param_imsi.decode_text(text_buf);
param_hdlr.decode_text(text_buf);
}

void GSUPEM__change__connhdlr_call::log() const
{
TTCN_Logger::log_event_str("@GSUP_Emulation.GSUPEM_change_connhdlr : { ");
TTCN_Logger::log_event_str("imsi := ");
param_imsi.log();
TTCN_Logger::log_event_str(", hdlr := ");
param_hdlr.log();
TTCN_Logger::log_event_str(" }");
}

void GSUPEM__change__connhdlr_call_redirect::set_parameters(const GSUPEM__change__connhdlr_call& call_par) const
{
if (ptr_imsi != NULL) *ptr_imsi = call_par.imsi();
if (ptr_hdlr != NULL) *ptr_hdlr = call_par.hdlr();
}

void GSUPEM__change__connhdlr_reply::log() const
{
TTCN_Logger::log_event_str("@GSUP_Emulation.GSUPEM_change_connhdlr : { }");
}

GSUPEM__change__connhdlr_template::GSUPEM__change__connhdlr_template()
 : param_imsi(ANY_VALUE), param_hdlr(ANY_VALUE)
{
}

GSUPEM__change__connhdlr_call GSUPEM__change__connhdlr_template::create_call() const
{
GSUPEM__change__connhdlr_call ret_val;
ret_val.imsi() = param_imsi.valueof();
ret_val.hdlr() = param_hdlr.valueof();
return ret_val;
}

boolean GSUPEM__change__connhdlr_template::match_call(const GSUPEM__change__connhdlr_call& match_value, boolean legacy) const
{
return param_imsi.match(match_value.imsi(), legacy) &&
param_hdlr.match(match_value.hdlr(), legacy);
}

void GSUPEM__change__connhdlr_template::log() const
{
TTCN_Logger::log_event_str("{ imsi := ");
param_imsi.log();
TTCN_Logger::log_event_str(", hdlr := ");
param_hdlr.log();
TTCN_Logger::log_event_str(" }");
}

void GSUPEM__change__connhdlr_template::log_match_call(const GSUPEM__change__connhdlr_call& match_value, boolean legacy) const
{
TTCN_Logger::log_event_str("{ imsi := ");
param_imsi.log_match(match_value.imsi(), legacy);
TTCN_Logger::log_event_str(", hdlr := ");
param_hdlr.log_match(match_value.hdlr(), legacy);
TTCN_Logger::log_event_str(" }");
}

void GSUPEM__change__connhdlr_template::log_match_reply(const GSUPEM__change__connhdlr_reply& , boolean) const
{
TTCN_Logger::log_event_str("{ } with { } matched");
}

void GSUPEM__change__connhdlr_template::encode_text(Text_Buf& text_buf) const
{
param_imsi.encode_text(text_buf);
param_hdlr.encode_text(text_buf);
}

void GSUPEM__change__connhdlr_template::decode_text(Text_Buf& text_buf)
{
param_imsi.decode_text(text_buf);
param_hdlr.decode_text(text_buf);
}

void GSUPEM__PROC__PT::append_to_proc_queue(proc_queue_item *new_item)
{
new_item->next_item = NULL;
if (proc_queue_tail != NULL) proc_queue_tail->next_item = new_item;
else proc_queue_head = new_item;
proc_queue_tail = new_item;
}

void GSUPEM__PROC__PT::remove_proc_queue_head()
{
switch (proc_queue_head->item_selection) {
case CALL_0:
delete proc_queue_head->call_0;
break;
case CALL_1:
delete proc_queue_head->call_1;
break;
case CALL_2:
delete proc_queue_head->call_2;
break;
case CALL_3:
delete proc_queue_head->call_3;
break;
case REPLY_0:
delete proc_queue_head->reply_0;
break;
case REPLY_1:
delete proc_queue_head->reply_1;
break;
case REPLY_2:
delete proc_queue_head->reply_2;
break;
case REPLY_3:
delete proc_queue_head->reply_3;
break;
default:
TTCN_error("Internal error: Invalid signature selector in the queue of port %s.", port_name);
}
proc_queue_item *next_item = proc_queue_head->next_item;
delete proc_queue_head;
proc_queue_head = next_item;
if (next_item == NULL) proc_queue_tail = NULL;
TTCN_Logger::log_port_queue(TitanLoggerApiSimple::Port__Queue_operation::extract__op, port_name, 0, ++proc_head_count, CHARSTRING(0,NULL), CHARSTRING(0,NULL));}

void GSUPEM__PROC__PT::clear_queue()
{
while (proc_queue_head != NULL) remove_proc_queue_head();
}

GSUPEM__PROC__PT::GSUPEM__PROC__PT(const char *par_port_name)
 : PORT(par_port_name)
{
proc_queue_head = NULL;
proc_queue_tail = NULL;
}

GSUPEM__PROC__PT::~GSUPEM__PROC__PT()
{
clear_queue();
}

void GSUPEM__PROC__PT::call(const GSUPEM__register__expect_template& call_template, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
if (!is_started) TTCN_error("Calling a signature on port %s, which is not started.", port_name);
if (!destination_component.is_bound()) TTCN_error("Unbound component reference in the to clause of call operation.");
const GSUPEM__register__expect_call& call_tmp = call_template.create_call();
const TTCN_Logger::Severity log_sev = destination_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMOUT:TTCN_Logger::PORTEVENT_PCOUT;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_send(port_name,TitanLoggerApiSimple::Port__oper::call__op, destination_component,
CHARSTRING(0,NULL),(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PMOUT, TRUE), call_tmp.log(), TTCN_Logger::end_event_log2str()));
}
if (destination_component == SYSTEM_COMPREF) TTCN_error("Internal port %s cannot send call to system.", port_name);
else {
Text_Buf text_buf;
prepare_call(text_buf, "@GSUP_Emulation.GSUPEM_register_expect");
call_tmp.encode_text(text_buf);
send_data(text_buf, destination_component);
}
}

void GSUPEM__PROC__PT::call(const GSUPEM__register__expect_template& call_template, size_t nof_components, const COMPONENT* destination_components, FLOAT* timestamp_redirect)
{
for (size_t i = 0; i < nof_components; ++i) call(call_template, destination_components[i], timestamp_redirect);
}

void GSUPEM__PROC__PT::call(const GSUPEM__register__expect_template& call_template, boolean broadcast, FLOAT* timestamp_redirect)
{
if (broadcast) {
if (!is_started) TTCN_error("Calling a signature on port %s, which is not started.", port_name);
Text_Buf text_buf;
prepare_call(text_buf, "@GSUP_Emulation.GSUPEM_register_expect");
const GSUPEM__register__expect_call& call_tmp = call_template.create_call();
call_tmp.encode_text(text_buf);
send_data_broadcast(text_buf, PORT::OMT_CALL, (TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PCOUT, TRUE), 
call_tmp.log(), TTCN_Logger::end_event_log2str()));
}
else call(call_template, COMPONENT(get_default_destination()), timestamp_redirect);
}

void GSUPEM__PROC__PT::call(const GSUPEM__unregister__expect_template& call_template, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
if (!is_started) TTCN_error("Calling a signature on port %s, which is not started.", port_name);
if (!destination_component.is_bound()) TTCN_error("Unbound component reference in the to clause of call operation.");
const GSUPEM__unregister__expect_call& call_tmp = call_template.create_call();
const TTCN_Logger::Severity log_sev = destination_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMOUT:TTCN_Logger::PORTEVENT_PCOUT;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_send(port_name,TitanLoggerApiSimple::Port__oper::call__op, destination_component,
CHARSTRING(0,NULL),(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PMOUT, TRUE), call_tmp.log(), TTCN_Logger::end_event_log2str()));
}
if (destination_component == SYSTEM_COMPREF) TTCN_error("Internal port %s cannot send call to system.", port_name);
else {
Text_Buf text_buf;
prepare_call(text_buf, "@GSUP_Emulation.GSUPEM_unregister_expect");
call_tmp.encode_text(text_buf);
send_data(text_buf, destination_component);
}
}

void GSUPEM__PROC__PT::call(const GSUPEM__unregister__expect_template& call_template, size_t nof_components, const COMPONENT* destination_components, FLOAT* timestamp_redirect)
{
for (size_t i = 0; i < nof_components; ++i) call(call_template, destination_components[i], timestamp_redirect);
}

void GSUPEM__PROC__PT::call(const GSUPEM__unregister__expect_template& call_template, boolean broadcast, FLOAT* timestamp_redirect)
{
if (broadcast) {
if (!is_started) TTCN_error("Calling a signature on port %s, which is not started.", port_name);
Text_Buf text_buf;
prepare_call(text_buf, "@GSUP_Emulation.GSUPEM_unregister_expect");
const GSUPEM__unregister__expect_call& call_tmp = call_template.create_call();
call_tmp.encode_text(text_buf);
send_data_broadcast(text_buf, PORT::OMT_CALL, (TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PCOUT, TRUE), 
call_tmp.log(), TTCN_Logger::end_event_log2str()));
}
else call(call_template, COMPONENT(get_default_destination()), timestamp_redirect);
}

void GSUPEM__PROC__PT::call(const GSUPEM__unregister__connhdlr_template& call_template, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
if (!is_started) TTCN_error("Calling a signature on port %s, which is not started.", port_name);
if (!destination_component.is_bound()) TTCN_error("Unbound component reference in the to clause of call operation.");
const GSUPEM__unregister__connhdlr_call& call_tmp = call_template.create_call();
const TTCN_Logger::Severity log_sev = destination_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMOUT:TTCN_Logger::PORTEVENT_PCOUT;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_send(port_name,TitanLoggerApiSimple::Port__oper::call__op, destination_component,
CHARSTRING(0,NULL),(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PMOUT, TRUE), call_tmp.log(), TTCN_Logger::end_event_log2str()));
}
if (destination_component == SYSTEM_COMPREF) TTCN_error("Internal port %s cannot send call to system.", port_name);
else {
Text_Buf text_buf;
prepare_call(text_buf, "@GSUP_Emulation.GSUPEM_unregister_connhdlr");
call_tmp.encode_text(text_buf);
send_data(text_buf, destination_component);
}
}

void GSUPEM__PROC__PT::call(const GSUPEM__unregister__connhdlr_template& call_template, size_t nof_components, const COMPONENT* destination_components, FLOAT* timestamp_redirect)
{
for (size_t i = 0; i < nof_components; ++i) call(call_template, destination_components[i], timestamp_redirect);
}

void GSUPEM__PROC__PT::call(const GSUPEM__unregister__connhdlr_template& call_template, boolean broadcast, FLOAT* timestamp_redirect)
{
if (broadcast) {
if (!is_started) TTCN_error("Calling a signature on port %s, which is not started.", port_name);
Text_Buf text_buf;
prepare_call(text_buf, "@GSUP_Emulation.GSUPEM_unregister_connhdlr");
const GSUPEM__unregister__connhdlr_call& call_tmp = call_template.create_call();
call_tmp.encode_text(text_buf);
send_data_broadcast(text_buf, PORT::OMT_CALL, (TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PCOUT, TRUE), 
call_tmp.log(), TTCN_Logger::end_event_log2str()));
}
else call(call_template, COMPONENT(get_default_destination()), timestamp_redirect);
}

void GSUPEM__PROC__PT::call(const GSUPEM__change__connhdlr_template& call_template, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
if (!is_started) TTCN_error("Calling a signature on port %s, which is not started.", port_name);
if (!destination_component.is_bound()) TTCN_error("Unbound component reference in the to clause of call operation.");
const GSUPEM__change__connhdlr_call& call_tmp = call_template.create_call();
const TTCN_Logger::Severity log_sev = destination_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMOUT:TTCN_Logger::PORTEVENT_PCOUT;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_send(port_name,TitanLoggerApiSimple::Port__oper::call__op, destination_component,
CHARSTRING(0,NULL),(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PMOUT, TRUE), call_tmp.log(), TTCN_Logger::end_event_log2str()));
}
if (destination_component == SYSTEM_COMPREF) TTCN_error("Internal port %s cannot send call to system.", port_name);
else {
Text_Buf text_buf;
prepare_call(text_buf, "@GSUP_Emulation.GSUPEM_change_connhdlr");
call_tmp.encode_text(text_buf);
send_data(text_buf, destination_component);
}
}

void GSUPEM__PROC__PT::call(const GSUPEM__change__connhdlr_template& call_template, size_t nof_components, const COMPONENT* destination_components, FLOAT* timestamp_redirect)
{
for (size_t i = 0; i < nof_components; ++i) call(call_template, destination_components[i], timestamp_redirect);
}

void GSUPEM__PROC__PT::call(const GSUPEM__change__connhdlr_template& call_template, boolean broadcast, FLOAT* timestamp_redirect)
{
if (broadcast) {
if (!is_started) TTCN_error("Calling a signature on port %s, which is not started.", port_name);
Text_Buf text_buf;
prepare_call(text_buf, "@GSUP_Emulation.GSUPEM_change_connhdlr");
const GSUPEM__change__connhdlr_call& call_tmp = call_template.create_call();
call_tmp.encode_text(text_buf);
send_data_broadcast(text_buf, PORT::OMT_CALL, (TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PCOUT, TRUE), 
call_tmp.log(), TTCN_Logger::end_event_log2str()));
}
else call(call_template, COMPONENT(get_default_destination()), timestamp_redirect);
}

void GSUPEM__PROC__PT::reply(const GSUPEM__register__expect_template& reply_template, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
if (!is_started) TTCN_error("Replying to a signature on port %s, which is not started.", port_name);
if (!destination_component.is_bound()) TTCN_error("Unbound component reference in the to clause of reply operation.");
const GSUPEM__register__expect_reply& reply_tmp = reply_template.create_reply();
const TTCN_Logger::Severity log_sev = destination_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMOUT:TTCN_Logger::PORTEVENT_PCOUT;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_send(port_name, TitanLoggerApiSimple::Port__oper::reply__op, destination_component,
 CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PMOUT, TRUE), reply_tmp.log(), TTCN_Logger::end_event_log2str()));
}
if (destination_component == SYSTEM_COMPREF) TTCN_error("Internal port %s cannot send reply to system.", port_name);
else {
Text_Buf text_buf;
prepare_reply(text_buf, "@GSUP_Emulation.GSUPEM_register_expect");
reply_tmp.encode_text(text_buf);
send_data(text_buf, destination_component);
}
}

void GSUPEM__PROC__PT::reply(const GSUPEM__register__expect_template& reply_template, size_t nof_components, const COMPONENT* destination_components, FLOAT* timestamp_redirect)
{
for (size_t i = 0; i < nof_components; ++i) reply(reply_template, destination_components[i], timestamp_redirect);
}

void GSUPEM__PROC__PT::reply(const GSUPEM__register__expect_template& reply_template, boolean broadcast, FLOAT* timestamp_redirect)
{
if (broadcast) {
if (!is_started) TTCN_error("Replying to a call on port %s, which is not started.", port_name);
Text_Buf text_buf;
prepare_reply(text_buf, "@GSUP_Emulation.GSUPEM_register_expect");
const GSUPEM__register__expect_reply& reply_tmp = reply_template.create_reply();
reply_tmp.encode_text(text_buf);
send_data_broadcast(text_buf, PORT::OMT_REPLY, (TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PCOUT, TRUE), 
reply_tmp.log(), TTCN_Logger::end_event_log2str()));
}
else reply(reply_template, COMPONENT(get_default_destination()), timestamp_redirect);
}

void GSUPEM__PROC__PT::reply(const GSUPEM__unregister__expect_template& reply_template, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
if (!is_started) TTCN_error("Replying to a signature on port %s, which is not started.", port_name);
if (!destination_component.is_bound()) TTCN_error("Unbound component reference in the to clause of reply operation.");
const GSUPEM__unregister__expect_reply& reply_tmp = reply_template.create_reply();
const TTCN_Logger::Severity log_sev = destination_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMOUT:TTCN_Logger::PORTEVENT_PCOUT;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_send(port_name, TitanLoggerApiSimple::Port__oper::reply__op, destination_component,
 CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PMOUT, TRUE), reply_tmp.log(), TTCN_Logger::end_event_log2str()));
}
if (destination_component == SYSTEM_COMPREF) TTCN_error("Internal port %s cannot send reply to system.", port_name);
else {
Text_Buf text_buf;
prepare_reply(text_buf, "@GSUP_Emulation.GSUPEM_unregister_expect");
reply_tmp.encode_text(text_buf);
send_data(text_buf, destination_component);
}
}

void GSUPEM__PROC__PT::reply(const GSUPEM__unregister__expect_template& reply_template, size_t nof_components, const COMPONENT* destination_components, FLOAT* timestamp_redirect)
{
for (size_t i = 0; i < nof_components; ++i) reply(reply_template, destination_components[i], timestamp_redirect);
}

void GSUPEM__PROC__PT::reply(const GSUPEM__unregister__expect_template& reply_template, boolean broadcast, FLOAT* timestamp_redirect)
{
if (broadcast) {
if (!is_started) TTCN_error("Replying to a call on port %s, which is not started.", port_name);
Text_Buf text_buf;
prepare_reply(text_buf, "@GSUP_Emulation.GSUPEM_unregister_expect");
const GSUPEM__unregister__expect_reply& reply_tmp = reply_template.create_reply();
reply_tmp.encode_text(text_buf);
send_data_broadcast(text_buf, PORT::OMT_REPLY, (TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PCOUT, TRUE), 
reply_tmp.log(), TTCN_Logger::end_event_log2str()));
}
else reply(reply_template, COMPONENT(get_default_destination()), timestamp_redirect);
}

void GSUPEM__PROC__PT::reply(const GSUPEM__unregister__connhdlr_template& reply_template, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
if (!is_started) TTCN_error("Replying to a signature on port %s, which is not started.", port_name);
if (!destination_component.is_bound()) TTCN_error("Unbound component reference in the to clause of reply operation.");
const GSUPEM__unregister__connhdlr_reply& reply_tmp = reply_template.create_reply();
const TTCN_Logger::Severity log_sev = destination_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMOUT:TTCN_Logger::PORTEVENT_PCOUT;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_send(port_name, TitanLoggerApiSimple::Port__oper::reply__op, destination_component,
 CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PMOUT, TRUE), reply_tmp.log(), TTCN_Logger::end_event_log2str()));
}
if (destination_component == SYSTEM_COMPREF) TTCN_error("Internal port %s cannot send reply to system.", port_name);
else {
Text_Buf text_buf;
prepare_reply(text_buf, "@GSUP_Emulation.GSUPEM_unregister_connhdlr");
reply_tmp.encode_text(text_buf);
send_data(text_buf, destination_component);
}
}

void GSUPEM__PROC__PT::reply(const GSUPEM__unregister__connhdlr_template& reply_template, size_t nof_components, const COMPONENT* destination_components, FLOAT* timestamp_redirect)
{
for (size_t i = 0; i < nof_components; ++i) reply(reply_template, destination_components[i], timestamp_redirect);
}

void GSUPEM__PROC__PT::reply(const GSUPEM__unregister__connhdlr_template& reply_template, boolean broadcast, FLOAT* timestamp_redirect)
{
if (broadcast) {
if (!is_started) TTCN_error("Replying to a call on port %s, which is not started.", port_name);
Text_Buf text_buf;
prepare_reply(text_buf, "@GSUP_Emulation.GSUPEM_unregister_connhdlr");
const GSUPEM__unregister__connhdlr_reply& reply_tmp = reply_template.create_reply();
reply_tmp.encode_text(text_buf);
send_data_broadcast(text_buf, PORT::OMT_REPLY, (TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PCOUT, TRUE), 
reply_tmp.log(), TTCN_Logger::end_event_log2str()));
}
else reply(reply_template, COMPONENT(get_default_destination()), timestamp_redirect);
}

void GSUPEM__PROC__PT::reply(const GSUPEM__change__connhdlr_template& reply_template, const COMPONENT& destination_component, FLOAT* timestamp_redirect)
{
if (!is_started) TTCN_error("Replying to a signature on port %s, which is not started.", port_name);
if (!destination_component.is_bound()) TTCN_error("Unbound component reference in the to clause of reply operation.");
const GSUPEM__change__connhdlr_reply& reply_tmp = reply_template.create_reply();
const TTCN_Logger::Severity log_sev = destination_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMOUT:TTCN_Logger::PORTEVENT_PCOUT;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_send(port_name, TitanLoggerApiSimple::Port__oper::reply__op, destination_component,
 CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PMOUT, TRUE), reply_tmp.log(), TTCN_Logger::end_event_log2str()));
}
if (destination_component == SYSTEM_COMPREF) TTCN_error("Internal port %s cannot send reply to system.", port_name);
else {
Text_Buf text_buf;
prepare_reply(text_buf, "@GSUP_Emulation.GSUPEM_change_connhdlr");
reply_tmp.encode_text(text_buf);
send_data(text_buf, destination_component);
}
}

void GSUPEM__PROC__PT::reply(const GSUPEM__change__connhdlr_template& reply_template, size_t nof_components, const COMPONENT* destination_components, FLOAT* timestamp_redirect)
{
for (size_t i = 0; i < nof_components; ++i) reply(reply_template, destination_components[i], timestamp_redirect);
}

void GSUPEM__PROC__PT::reply(const GSUPEM__change__connhdlr_template& reply_template, boolean broadcast, FLOAT* timestamp_redirect)
{
if (broadcast) {
if (!is_started) TTCN_error("Replying to a call on port %s, which is not started.", port_name);
Text_Buf text_buf;
prepare_reply(text_buf, "@GSUP_Emulation.GSUPEM_change_connhdlr");
const GSUPEM__change__connhdlr_reply& reply_tmp = reply_template.create_reply();
reply_tmp.encode_text(text_buf);
send_data_broadcast(text_buf, PORT::OMT_REPLY, (TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PCOUT, TRUE), 
reply_tmp.log(), TTCN_Logger::end_event_log2str()));
}
else reply(reply_template, COMPONENT(get_default_destination()), timestamp_redirect);
}

alt_status GSUPEM__PROC__PT::getcall(const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first entity in the queue does not match the from clause: ", port_name);
sender_template.log_match(proc_queue_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else switch (proc_queue_head->item_selection) {
case CALL_0:
case CALL_1:
case CALL_2:
case CALL_3:
{
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS, "Matching on port %s succeeded.", port_name);
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::call__op, proc_queue_head->sender_component,
FALSE, CHARSTRING(0, NULL), msg_head_count+1);
}
remove_proc_queue_head();
return ALT_YES;
}
default:
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: First entity in the queue is not a call.", port_name);
return ALT_NO;
}
}

alt_status GSUPEM__PROC__PT::check_getcall(const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first entity in the queue does not match the from clause: ", port_name);
sender_template.log_match(proc_queue_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else switch (proc_queue_head->item_selection) {
case CALL_0:
case CALL_1:
case CALL_2:
case CALL_3:
{
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS, "Matching on port %s succeeded.", port_name);
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::call__op, proc_queue_head->sender_component,
TRUE, CHARSTRING(0, NULL), msg_head_count+1);
}
return ALT_YES;
}
default:
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: First entity in the queue is not a call.", port_name);
return ALT_NO;
}
}

alt_status GSUPEM__PROC__PT::getcall(const GSUPEM__register__expect_template& getcall_template, const COMPONENT_template& sender_template, const GSUPEM__register__expect_call_redirect& param_ref, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::sender__does__not__match__from__clause,
(TTCN_Logger::begin_event(log_sev, TRUE), sender_template.log_match(proc_queue_head->sender_component),  TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else if (proc_queue_head->item_selection != CALL_0) {
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: The first entity in the queue is not a call for signature @GSUP_Emulation.GSUPEM_register_expect.", port_name);
return ALT_NO;
} else if (!getcall_template.match_call(*proc_queue_head->call_0)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::parameters__of__call__do__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), getcall_template.log_match_call(*proc_queue_head->call_0), TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
param_ref.set_parameters(*proc_queue_head->call_0);
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s succeeded: ", port_name);
getcall_template.log_match_call(*proc_queue_head->call_0);
TTCN_Logger::end_event();
}
log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::call__op, proc_queue_head->sender_component, FALSE,
(TTCN_Logger::begin_event(log_sev, TRUE), proc_queue_head->call_0->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_proc_queue_head();
return ALT_YES;
}
}

alt_status GSUPEM__PROC__PT::check_getcall(const GSUPEM__register__expect_template& getcall_template, const COMPONENT_template& sender_template, const GSUPEM__register__expect_call_redirect& param_ref, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::sender__does__not__match__from__clause,
(TTCN_Logger::begin_event(log_sev, TRUE), sender_template.log_match(proc_queue_head->sender_component),  TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else if (proc_queue_head->item_selection != CALL_0) {
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: The first entity in the queue is not a call for signature @GSUP_Emulation.GSUPEM_register_expect.", port_name);
return ALT_NO;
} else if (!getcall_template.match_call(*proc_queue_head->call_0)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::parameters__of__call__do__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), getcall_template.log_match_call(*proc_queue_head->call_0), TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
param_ref.set_parameters(*proc_queue_head->call_0);
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s succeeded: ", port_name);
getcall_template.log_match_call(*proc_queue_head->call_0);
TTCN_Logger::end_event();
}
log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::call__op, proc_queue_head->sender_component, TRUE,
(TTCN_Logger::begin_event(log_sev, TRUE), proc_queue_head->call_0->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
return ALT_YES;
}
}

alt_status GSUPEM__PROC__PT::getcall(const GSUPEM__unregister__expect_template& getcall_template, const COMPONENT_template& sender_template, const GSUPEM__unregister__expect_call_redirect& param_ref, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::sender__does__not__match__from__clause,
(TTCN_Logger::begin_event(log_sev, TRUE), sender_template.log_match(proc_queue_head->sender_component),  TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else if (proc_queue_head->item_selection != CALL_1) {
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: The first entity in the queue is not a call for signature @GSUP_Emulation.GSUPEM_unregister_expect.", port_name);
return ALT_NO;
} else if (!getcall_template.match_call(*proc_queue_head->call_1)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::parameters__of__call__do__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), getcall_template.log_match_call(*proc_queue_head->call_1), TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
param_ref.set_parameters(*proc_queue_head->call_1);
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s succeeded: ", port_name);
getcall_template.log_match_call(*proc_queue_head->call_1);
TTCN_Logger::end_event();
}
log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::call__op, proc_queue_head->sender_component, FALSE,
(TTCN_Logger::begin_event(log_sev, TRUE), proc_queue_head->call_1->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_proc_queue_head();
return ALT_YES;
}
}

alt_status GSUPEM__PROC__PT::check_getcall(const GSUPEM__unregister__expect_template& getcall_template, const COMPONENT_template& sender_template, const GSUPEM__unregister__expect_call_redirect& param_ref, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::sender__does__not__match__from__clause,
(TTCN_Logger::begin_event(log_sev, TRUE), sender_template.log_match(proc_queue_head->sender_component),  TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else if (proc_queue_head->item_selection != CALL_1) {
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: The first entity in the queue is not a call for signature @GSUP_Emulation.GSUPEM_unregister_expect.", port_name);
return ALT_NO;
} else if (!getcall_template.match_call(*proc_queue_head->call_1)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::parameters__of__call__do__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), getcall_template.log_match_call(*proc_queue_head->call_1), TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
param_ref.set_parameters(*proc_queue_head->call_1);
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s succeeded: ", port_name);
getcall_template.log_match_call(*proc_queue_head->call_1);
TTCN_Logger::end_event();
}
log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::call__op, proc_queue_head->sender_component, TRUE,
(TTCN_Logger::begin_event(log_sev, TRUE), proc_queue_head->call_1->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
return ALT_YES;
}
}

alt_status GSUPEM__PROC__PT::getcall(const GSUPEM__unregister__connhdlr_template& getcall_template, const COMPONENT_template& sender_template, const GSUPEM__unregister__connhdlr_call_redirect& param_ref, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::sender__does__not__match__from__clause,
(TTCN_Logger::begin_event(log_sev, TRUE), sender_template.log_match(proc_queue_head->sender_component),  TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else if (proc_queue_head->item_selection != CALL_2) {
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: The first entity in the queue is not a call for signature @GSUP_Emulation.GSUPEM_unregister_connhdlr.", port_name);
return ALT_NO;
} else if (!getcall_template.match_call(*proc_queue_head->call_2)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::parameters__of__call__do__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), getcall_template.log_match_call(*proc_queue_head->call_2), TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
param_ref.set_parameters(*proc_queue_head->call_2);
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s succeeded: ", port_name);
getcall_template.log_match_call(*proc_queue_head->call_2);
TTCN_Logger::end_event();
}
log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::call__op, proc_queue_head->sender_component, FALSE,
(TTCN_Logger::begin_event(log_sev, TRUE), proc_queue_head->call_2->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_proc_queue_head();
return ALT_YES;
}
}

alt_status GSUPEM__PROC__PT::check_getcall(const GSUPEM__unregister__connhdlr_template& getcall_template, const COMPONENT_template& sender_template, const GSUPEM__unregister__connhdlr_call_redirect& param_ref, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::sender__does__not__match__from__clause,
(TTCN_Logger::begin_event(log_sev, TRUE), sender_template.log_match(proc_queue_head->sender_component),  TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else if (proc_queue_head->item_selection != CALL_2) {
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: The first entity in the queue is not a call for signature @GSUP_Emulation.GSUPEM_unregister_connhdlr.", port_name);
return ALT_NO;
} else if (!getcall_template.match_call(*proc_queue_head->call_2)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::parameters__of__call__do__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), getcall_template.log_match_call(*proc_queue_head->call_2), TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
param_ref.set_parameters(*proc_queue_head->call_2);
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s succeeded: ", port_name);
getcall_template.log_match_call(*proc_queue_head->call_2);
TTCN_Logger::end_event();
}
log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::call__op, proc_queue_head->sender_component, TRUE,
(TTCN_Logger::begin_event(log_sev, TRUE), proc_queue_head->call_2->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
return ALT_YES;
}
}

alt_status GSUPEM__PROC__PT::getcall(const GSUPEM__change__connhdlr_template& getcall_template, const COMPONENT_template& sender_template, const GSUPEM__change__connhdlr_call_redirect& param_ref, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::sender__does__not__match__from__clause,
(TTCN_Logger::begin_event(log_sev, TRUE), sender_template.log_match(proc_queue_head->sender_component),  TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else if (proc_queue_head->item_selection != CALL_3) {
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: The first entity in the queue is not a call for signature @GSUP_Emulation.GSUPEM_change_connhdlr.", port_name);
return ALT_NO;
} else if (!getcall_template.match_call(*proc_queue_head->call_3)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::parameters__of__call__do__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), getcall_template.log_match_call(*proc_queue_head->call_3), TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
param_ref.set_parameters(*proc_queue_head->call_3);
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s succeeded: ", port_name);
getcall_template.log_match_call(*proc_queue_head->call_3);
TTCN_Logger::end_event();
}
log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::call__op, proc_queue_head->sender_component, FALSE,
(TTCN_Logger::begin_event(log_sev, TRUE), proc_queue_head->call_3->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_proc_queue_head();
return ALT_YES;
}
}

alt_status GSUPEM__PROC__PT::check_getcall(const GSUPEM__change__connhdlr_template& getcall_template, const COMPONENT_template& sender_template, const GSUPEM__change__connhdlr_call_redirect& param_ref, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::sender__does__not__match__from__clause,
(TTCN_Logger::begin_event(log_sev, TRUE), sender_template.log_match(proc_queue_head->sender_component),  TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else if (proc_queue_head->item_selection != CALL_3) {
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: The first entity in the queue is not a call for signature @GSUP_Emulation.GSUPEM_change_connhdlr.", port_name);
return ALT_NO;
} else if (!getcall_template.match_call(*proc_queue_head->call_3)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::parameters__of__call__do__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), getcall_template.log_match_call(*proc_queue_head->call_3), TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
param_ref.set_parameters(*proc_queue_head->call_3);
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s succeeded: ", port_name);
getcall_template.log_match_call(*proc_queue_head->call_3);
TTCN_Logger::end_event();
}
log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::call__op, proc_queue_head->sender_component, TRUE,
(TTCN_Logger::begin_event(log_sev, TRUE), proc_queue_head->call_3->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
return ALT_YES;
}
}

alt_status GSUPEM__PROC__PT::getreply(const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first entity in the queue does not match the from clause: ", port_name);
sender_template.log_match(proc_queue_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else switch (proc_queue_head->item_selection) {
case REPLY_0:
case REPLY_1:
case REPLY_2:
case REPLY_3:
{
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS, "Matching on port %s succeeded.", port_name);
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::reply__op, proc_queue_head->sender_component,
FALSE, CHARSTRING(0, NULL), msg_head_count+1);
}
remove_proc_queue_head();
return ALT_YES;
}
default:
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: First entity in the queue is not a reply.", port_name);
return ALT_NO;
}
}

alt_status GSUPEM__PROC__PT::check_getreply(const COMPONENT_template& sender_template, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first entity in the queue does not match the from clause: ", port_name);
sender_template.log_match(proc_queue_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else switch (proc_queue_head->item_selection) {
case REPLY_0:
case REPLY_1:
case REPLY_2:
case REPLY_3:
{
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS, "Matching on port %s succeeded.", port_name);
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::reply__op, proc_queue_head->sender_component,
TRUE, CHARSTRING(0, NULL), msg_head_count+1);
}
return ALT_YES;
}
default:
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: First entity in the queue is not a reply.", port_name);
return ALT_NO;
}
}

alt_status GSUPEM__PROC__PT::getreply(const GSUPEM__register__expect_template& getreply_template, const COMPONENT_template& sender_template, const GSUPEM__register__expect_reply_redirect& param_ref, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first entity in the queue does not match the from clause: ", port_name);
sender_template.log_match(proc_queue_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (proc_queue_head->item_selection != REPLY_0) {
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: The first entity in the queue is not a reply for signature @GSUP_Emulation.GSUPEM_register_expect.", port_name);
return ALT_NO;
} else if (!getreply_template.match_reply(*proc_queue_head->reply_0)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::parameters__of__reply__do__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), getreply_template.log_match_reply(*proc_queue_head->reply_0), TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
param_ref.set_parameters(*proc_queue_head->reply_0);
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s succeeded: ", port_name);
getreply_template.log_match_reply(*proc_queue_head->reply_0);
TTCN_Logger::end_event();
}
log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::reply__op, proc_queue_head->sender_component, FALSE,
(TTCN_Logger::begin_event(log_sev, TRUE), proc_queue_head->reply_0->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_proc_queue_head();
return ALT_YES;
}
}

alt_status GSUPEM__PROC__PT::check_getreply(const GSUPEM__register__expect_template& getreply_template, const COMPONENT_template& sender_template, const GSUPEM__register__expect_reply_redirect& param_ref, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first entity in the queue does not match the from clause: ", port_name);
sender_template.log_match(proc_queue_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (proc_queue_head->item_selection != REPLY_0) {
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: The first entity in the queue is not a reply for signature @GSUP_Emulation.GSUPEM_register_expect.", port_name);
return ALT_NO;
} else if (!getreply_template.match_reply(*proc_queue_head->reply_0)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::parameters__of__reply__do__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), getreply_template.log_match_reply(*proc_queue_head->reply_0), TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
param_ref.set_parameters(*proc_queue_head->reply_0);
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s succeeded: ", port_name);
getreply_template.log_match_reply(*proc_queue_head->reply_0);
TTCN_Logger::end_event();
}
log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::reply__op, proc_queue_head->sender_component, TRUE,
(TTCN_Logger::begin_event(log_sev, TRUE), proc_queue_head->reply_0->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
return ALT_YES;
}
}

alt_status GSUPEM__PROC__PT::getreply(const GSUPEM__unregister__expect_template& getreply_template, const COMPONENT_template& sender_template, const GSUPEM__unregister__expect_reply_redirect& param_ref, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first entity in the queue does not match the from clause: ", port_name);
sender_template.log_match(proc_queue_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (proc_queue_head->item_selection != REPLY_1) {
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: The first entity in the queue is not a reply for signature @GSUP_Emulation.GSUPEM_unregister_expect.", port_name);
return ALT_NO;
} else if (!getreply_template.match_reply(*proc_queue_head->reply_1)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::parameters__of__reply__do__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), getreply_template.log_match_reply(*proc_queue_head->reply_1), TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
param_ref.set_parameters(*proc_queue_head->reply_1);
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s succeeded: ", port_name);
getreply_template.log_match_reply(*proc_queue_head->reply_1);
TTCN_Logger::end_event();
}
log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::reply__op, proc_queue_head->sender_component, FALSE,
(TTCN_Logger::begin_event(log_sev, TRUE), proc_queue_head->reply_1->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_proc_queue_head();
return ALT_YES;
}
}

alt_status GSUPEM__PROC__PT::check_getreply(const GSUPEM__unregister__expect_template& getreply_template, const COMPONENT_template& sender_template, const GSUPEM__unregister__expect_reply_redirect& param_ref, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first entity in the queue does not match the from clause: ", port_name);
sender_template.log_match(proc_queue_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (proc_queue_head->item_selection != REPLY_1) {
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: The first entity in the queue is not a reply for signature @GSUP_Emulation.GSUPEM_unregister_expect.", port_name);
return ALT_NO;
} else if (!getreply_template.match_reply(*proc_queue_head->reply_1)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::parameters__of__reply__do__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), getreply_template.log_match_reply(*proc_queue_head->reply_1), TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
param_ref.set_parameters(*proc_queue_head->reply_1);
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s succeeded: ", port_name);
getreply_template.log_match_reply(*proc_queue_head->reply_1);
TTCN_Logger::end_event();
}
log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::reply__op, proc_queue_head->sender_component, TRUE,
(TTCN_Logger::begin_event(log_sev, TRUE), proc_queue_head->reply_1->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
return ALT_YES;
}
}

alt_status GSUPEM__PROC__PT::getreply(const GSUPEM__unregister__connhdlr_template& getreply_template, const COMPONENT_template& sender_template, const GSUPEM__unregister__connhdlr_reply_redirect& param_ref, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first entity in the queue does not match the from clause: ", port_name);
sender_template.log_match(proc_queue_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (proc_queue_head->item_selection != REPLY_2) {
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: The first entity in the queue is not a reply for signature @GSUP_Emulation.GSUPEM_unregister_connhdlr.", port_name);
return ALT_NO;
} else if (!getreply_template.match_reply(*proc_queue_head->reply_2)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::parameters__of__reply__do__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), getreply_template.log_match_reply(*proc_queue_head->reply_2), TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
param_ref.set_parameters(*proc_queue_head->reply_2);
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s succeeded: ", port_name);
getreply_template.log_match_reply(*proc_queue_head->reply_2);
TTCN_Logger::end_event();
}
log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::reply__op, proc_queue_head->sender_component, FALSE,
(TTCN_Logger::begin_event(log_sev, TRUE), proc_queue_head->reply_2->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_proc_queue_head();
return ALT_YES;
}
}

alt_status GSUPEM__PROC__PT::check_getreply(const GSUPEM__unregister__connhdlr_template& getreply_template, const COMPONENT_template& sender_template, const GSUPEM__unregister__connhdlr_reply_redirect& param_ref, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first entity in the queue does not match the from clause: ", port_name);
sender_template.log_match(proc_queue_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (proc_queue_head->item_selection != REPLY_2) {
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: The first entity in the queue is not a reply for signature @GSUP_Emulation.GSUPEM_unregister_connhdlr.", port_name);
return ALT_NO;
} else if (!getreply_template.match_reply(*proc_queue_head->reply_2)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::parameters__of__reply__do__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), getreply_template.log_match_reply(*proc_queue_head->reply_2), TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
param_ref.set_parameters(*proc_queue_head->reply_2);
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s succeeded: ", port_name);
getreply_template.log_match_reply(*proc_queue_head->reply_2);
TTCN_Logger::end_event();
}
log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::reply__op, proc_queue_head->sender_component, TRUE,
(TTCN_Logger::begin_event(log_sev, TRUE), proc_queue_head->reply_2->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
return ALT_YES;
}
}

alt_status GSUPEM__PROC__PT::getreply(const GSUPEM__change__connhdlr_template& getreply_template, const COMPONENT_template& sender_template, const GSUPEM__change__connhdlr_reply_redirect& param_ref, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first entity in the queue does not match the from clause: ", port_name);
sender_template.log_match(proc_queue_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (proc_queue_head->item_selection != REPLY_3) {
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: The first entity in the queue is not a reply for signature @GSUP_Emulation.GSUPEM_change_connhdlr.", port_name);
return ALT_NO;
} else if (!getreply_template.match_reply(*proc_queue_head->reply_3)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::parameters__of__reply__do__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), getreply_template.log_match_reply(*proc_queue_head->reply_3), TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
param_ref.set_parameters(*proc_queue_head->reply_3);
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s succeeded: ", port_name);
getreply_template.log_match_reply(*proc_queue_head->reply_3);
TTCN_Logger::end_event();
}
log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::reply__op, proc_queue_head->sender_component, FALSE,
(TTCN_Logger::begin_event(log_sev, TRUE), proc_queue_head->reply_3->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
remove_proc_queue_head();
return ALT_YES;
}
}

alt_status GSUPEM__PROC__PT::check_getreply(const GSUPEM__change__connhdlr_template& getreply_template, const COMPONENT_template& sender_template, const GSUPEM__change__connhdlr_reply_redirect& param_ref, COMPONENT *sender_ptr, FLOAT* timestamp_redirect, Index_Redirect*)
{
if (proc_queue_head == NULL) {
if (is_started) return ALT_MAYBE;
else {
TTCN_Logger::log(TTCN_Logger::MATCHING_PROBLEM, "Matching on port %s failed: Port is not started and the queue is empty.", port_name);
return ALT_NO;
}
} else if (!sender_template.match(proc_queue_head->sender_component)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s failed: Sender of the first entity in the queue does not match the from clause: ", port_name);
sender_template.log_match(proc_queue_head->sender_component);
TTCN_Logger::end_event();
}
return ALT_NO;
} else if (proc_queue_head->item_selection != REPLY_3) {
TTCN_Logger::log(proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMUNSUCC:TTCN_Logger::MATCHING_PCUNSUCC, "Matching on port %s failed: The first entity in the queue is not a reply for signature @GSUP_Emulation.GSUPEM_change_connhdlr.", port_name);
return ALT_NO;
} else if (!getreply_template.match_reply(*proc_queue_head->reply_3)) {
const TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF ? TTCN_Logger::MATCHING_PMUNSUCC : TTCN_Logger::MATCHING_PCUNSUCC;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_matching_failure(TitanLoggerApiSimple::PortType::procedure__,
port_name, proc_queue_head->sender_component,
TitanLoggerApiSimple::MatchingFailureType_reason::parameters__of__reply__do__not__match__template,
(TTCN_Logger::begin_event(log_sev, TRUE), getreply_template.log_match_reply(*proc_queue_head->reply_3), TTCN_Logger::end_event_log2str()));
}
return ALT_NO;
} else {
param_ref.set_parameters(*proc_queue_head->reply_3);
if (sender_ptr != NULL) *sender_ptr = proc_queue_head->sender_component;
TTCN_Logger::Severity log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::MATCHING_PMSUCCESS:TTCN_Logger::MATCHING_PCSUCCESS;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::begin_event(log_sev);
TTCN_Logger::log_event("Matching on port %s succeeded: ", port_name);
getreply_template.log_match_reply(*proc_queue_head->reply_3);
TTCN_Logger::end_event();
}
log_sev = proc_queue_head->sender_component==SYSTEM_COMPREF?TTCN_Logger::PORTEVENT_PMIN:TTCN_Logger::PORTEVENT_PCIN;
if (TTCN_Logger::log_this_event(log_sev)) {
TTCN_Logger::log_procport_recv(port_name, TitanLoggerApiSimple::Port__oper::reply__op, proc_queue_head->sender_component, TRUE,
(TTCN_Logger::begin_event(log_sev, TRUE), proc_queue_head->reply_3->log(), TTCN_Logger::end_event_log2str()),
msg_head_count+1);
}
return ALT_YES;
}
}

void GSUPEM__PROC__PT::incoming_call(const GSUPEM__register__expect_call& incoming_par, component sender_component)
{
if (!is_started) {
if (is_halted) {
TTCN_warning("A call that arrived on port %s has been discarded, because the port is not started.", port_name);
return;
}
else {
TTCN_error("Port %s is not started but a call has arrived on it.", port_name);
}
}
proc_tail_count++;
if (TTCN_Logger::log_this_event(TTCN_Logger::PORTEVENT_PQUEUE)) {
TTCN_Logger::log_port_queue(TitanLoggerApiSimple::Port__Queue_operation::enqueue__call, port_name, sender_component, proc_tail_count,
CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PQUEUE, TRUE), TTCN_Logger::log_char(' '), incoming_par.log(), TTCN_Logger::end_event_log2str()));
}
proc_queue_item *new_item = new proc_queue_item;
new_item->item_selection = CALL_0;
new_item->call_0 = new GSUPEM__register__expect_call(incoming_par);
new_item->sender_component = sender_component;
append_to_proc_queue(new_item);
}

void GSUPEM__PROC__PT::incoming_call(const GSUPEM__unregister__expect_call& incoming_par, component sender_component)
{
if (!is_started) {
if (is_halted) {
TTCN_warning("A call that arrived on port %s has been discarded, because the port is not started.", port_name);
return;
}
else {
TTCN_error("Port %s is not started but a call has arrived on it.", port_name);
}
}
proc_tail_count++;
if (TTCN_Logger::log_this_event(TTCN_Logger::PORTEVENT_PQUEUE)) {
TTCN_Logger::log_port_queue(TitanLoggerApiSimple::Port__Queue_operation::enqueue__call, port_name, sender_component, proc_tail_count,
CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PQUEUE, TRUE), TTCN_Logger::log_char(' '), incoming_par.log(), TTCN_Logger::end_event_log2str()));
}
proc_queue_item *new_item = new proc_queue_item;
new_item->item_selection = CALL_1;
new_item->call_1 = new GSUPEM__unregister__expect_call(incoming_par);
new_item->sender_component = sender_component;
append_to_proc_queue(new_item);
}

void GSUPEM__PROC__PT::incoming_call(const GSUPEM__unregister__connhdlr_call& incoming_par, component sender_component)
{
if (!is_started) {
if (is_halted) {
TTCN_warning("A call that arrived on port %s has been discarded, because the port is not started.", port_name);
return;
}
else {
TTCN_error("Port %s is not started but a call has arrived on it.", port_name);
}
}
proc_tail_count++;
if (TTCN_Logger::log_this_event(TTCN_Logger::PORTEVENT_PQUEUE)) {
TTCN_Logger::log_port_queue(TitanLoggerApiSimple::Port__Queue_operation::enqueue__call, port_name, sender_component, proc_tail_count,
CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PQUEUE, TRUE), TTCN_Logger::log_char(' '), incoming_par.log(), TTCN_Logger::end_event_log2str()));
}
proc_queue_item *new_item = new proc_queue_item;
new_item->item_selection = CALL_2;
new_item->call_2 = new GSUPEM__unregister__connhdlr_call(incoming_par);
new_item->sender_component = sender_component;
append_to_proc_queue(new_item);
}

void GSUPEM__PROC__PT::incoming_call(const GSUPEM__change__connhdlr_call& incoming_par, component sender_component)
{
if (!is_started) {
if (is_halted) {
TTCN_warning("A call that arrived on port %s has been discarded, because the port is not started.", port_name);
return;
}
else {
TTCN_error("Port %s is not started but a call has arrived on it.", port_name);
}
}
proc_tail_count++;
if (TTCN_Logger::log_this_event(TTCN_Logger::PORTEVENT_PQUEUE)) {
TTCN_Logger::log_port_queue(TitanLoggerApiSimple::Port__Queue_operation::enqueue__call, port_name, sender_component, proc_tail_count,
CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PQUEUE, TRUE), TTCN_Logger::log_char(' '), incoming_par.log(), TTCN_Logger::end_event_log2str()));
}
proc_queue_item *new_item = new proc_queue_item;
new_item->item_selection = CALL_3;
new_item->call_3 = new GSUPEM__change__connhdlr_call(incoming_par);
new_item->sender_component = sender_component;
append_to_proc_queue(new_item);
}

void GSUPEM__PROC__PT::incoming_reply(const GSUPEM__register__expect_reply& incoming_par, component sender_component)
{
if (!is_started) {
if (is_halted) {
TTCN_warning("A reply that arrived on port %s has been discarded, because the port is not started.", port_name);
return;
}
else {
TTCN_error("Port %s is not started but a reply has arrived on it.", port_name);
}
}
proc_tail_count++;
if (TTCN_Logger::log_this_event(TTCN_Logger::PORTEVENT_PQUEUE)) {
TTCN_Logger::log_port_queue(TitanLoggerApiSimple::Port__Queue_operation::enqueue__reply, port_name, sender_component, proc_tail_count,
CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PQUEUE, TRUE), TTCN_Logger::log_char(' '), incoming_par.log(), TTCN_Logger::end_event_log2str()));
}
proc_queue_item *new_item = new proc_queue_item;
new_item->item_selection = REPLY_0;
new_item->reply_0 = new GSUPEM__register__expect_reply(incoming_par);
new_item->sender_component = sender_component;
append_to_proc_queue(new_item);
}

void GSUPEM__PROC__PT::incoming_reply(const GSUPEM__unregister__expect_reply& incoming_par, component sender_component)
{
if (!is_started) {
if (is_halted) {
TTCN_warning("A reply that arrived on port %s has been discarded, because the port is not started.", port_name);
return;
}
else {
TTCN_error("Port %s is not started but a reply has arrived on it.", port_name);
}
}
proc_tail_count++;
if (TTCN_Logger::log_this_event(TTCN_Logger::PORTEVENT_PQUEUE)) {
TTCN_Logger::log_port_queue(TitanLoggerApiSimple::Port__Queue_operation::enqueue__reply, port_name, sender_component, proc_tail_count,
CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PQUEUE, TRUE), TTCN_Logger::log_char(' '), incoming_par.log(), TTCN_Logger::end_event_log2str()));
}
proc_queue_item *new_item = new proc_queue_item;
new_item->item_selection = REPLY_1;
new_item->reply_1 = new GSUPEM__unregister__expect_reply(incoming_par);
new_item->sender_component = sender_component;
append_to_proc_queue(new_item);
}

void GSUPEM__PROC__PT::incoming_reply(const GSUPEM__unregister__connhdlr_reply& incoming_par, component sender_component)
{
if (!is_started) {
if (is_halted) {
TTCN_warning("A reply that arrived on port %s has been discarded, because the port is not started.", port_name);
return;
}
else {
TTCN_error("Port %s is not started but a reply has arrived on it.", port_name);
}
}
proc_tail_count++;
if (TTCN_Logger::log_this_event(TTCN_Logger::PORTEVENT_PQUEUE)) {
TTCN_Logger::log_port_queue(TitanLoggerApiSimple::Port__Queue_operation::enqueue__reply, port_name, sender_component, proc_tail_count,
CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PQUEUE, TRUE), TTCN_Logger::log_char(' '), incoming_par.log(), TTCN_Logger::end_event_log2str()));
}
proc_queue_item *new_item = new proc_queue_item;
new_item->item_selection = REPLY_2;
new_item->reply_2 = new GSUPEM__unregister__connhdlr_reply(incoming_par);
new_item->sender_component = sender_component;
append_to_proc_queue(new_item);
}

void GSUPEM__PROC__PT::incoming_reply(const GSUPEM__change__connhdlr_reply& incoming_par, component sender_component)
{
if (!is_started) {
if (is_halted) {
TTCN_warning("A reply that arrived on port %s has been discarded, because the port is not started.", port_name);
return;
}
else {
TTCN_error("Port %s is not started but a reply has arrived on it.", port_name);
}
}
proc_tail_count++;
if (TTCN_Logger::log_this_event(TTCN_Logger::PORTEVENT_PQUEUE)) {
TTCN_Logger::log_port_queue(TitanLoggerApiSimple::Port__Queue_operation::enqueue__reply, port_name, sender_component, proc_tail_count,
CHARSTRING(0, NULL),
(TTCN_Logger::begin_event(TTCN_Logger::PORTEVENT_PQUEUE, TRUE), TTCN_Logger::log_char(' '), incoming_par.log(), TTCN_Logger::end_event_log2str()));
}
proc_queue_item *new_item = new proc_queue_item;
new_item->item_selection = REPLY_3;
new_item->reply_3 = new GSUPEM__change__connhdlr_reply(incoming_par);
new_item->sender_component = sender_component;
append_to_proc_queue(new_item);
}

boolean GSUPEM__PROC__PT::process_call(const char *signature_name, Text_Buf& incoming_buf, component sender_component)
{
if (!strcmp(signature_name, "@GSUP_Emulation.GSUPEM_register_expect")) {
GSUPEM__register__expect_call incoming_par;
incoming_par.decode_text(incoming_buf);
incoming_call(incoming_par, sender_component);
return TRUE;
} else if (!strcmp(signature_name, "@GSUP_Emulation.GSUPEM_unregister_expect")) {
GSUPEM__unregister__expect_call incoming_par;
incoming_par.decode_text(incoming_buf);
incoming_call(incoming_par, sender_component);
return TRUE;
} else if (!strcmp(signature_name, "@GSUP_Emulation.GSUPEM_unregister_connhdlr")) {
GSUPEM__unregister__connhdlr_call incoming_par;
incoming_par.decode_text(incoming_buf);
incoming_call(incoming_par, sender_component);
return TRUE;
} else if (!strcmp(signature_name, "@GSUP_Emulation.GSUPEM_change_connhdlr")) {
GSUPEM__change__connhdlr_call incoming_par;
incoming_par.decode_text(incoming_buf);
incoming_call(incoming_par, sender_component);
return TRUE;
} else return FALSE;
}

boolean GSUPEM__PROC__PT::process_reply(const char *signature_name, Text_Buf& incoming_buf, component sender_component)
{
if (!strcmp(signature_name, "@GSUP_Emulation.GSUPEM_register_expect")) {
GSUPEM__register__expect_reply incoming_par;
incoming_par.decode_text(incoming_buf);
incoming_reply(incoming_par, sender_component);
return TRUE;
} else if (!strcmp(signature_name, "@GSUP_Emulation.GSUPEM_unregister_expect")) {
GSUPEM__unregister__expect_reply incoming_par;
incoming_par.decode_text(incoming_buf);
incoming_reply(incoming_par, sender_component);
return TRUE;
} else if (!strcmp(signature_name, "@GSUP_Emulation.GSUPEM_unregister_connhdlr")) {
GSUPEM__unregister__connhdlr_reply incoming_par;
incoming_par.decode_text(incoming_buf);
incoming_reply(incoming_par, sender_component);
return TRUE;
} else if (!strcmp(signature_name, "@GSUP_Emulation.GSUPEM_change_connhdlr")) {
GSUPEM__change__connhdlr_reply incoming_par;
incoming_par.decode_text(incoming_buf);
incoming_reply(incoming_par, sender_component);
return TRUE;
} else return FALSE;
}


/* Bodies of functions, altsteps and testcases */

BOOLEAN f__imsi__known(const CHARSTRING& imsi)
{
TTCN_Location current_location("GSUP_Emulation.ttcn", 71, TTCN_Location::LOCATION_FUNCTION, "f_imsi_known");
current_location.update_lineno(73);
/* GSUP_Emulation.ttcn, line 73 */
INTEGER i;
current_location.update_lineno(74);
/* GSUP_Emulation.ttcn, line 74 */
i = 0;
current_location.update_lineno(74);
/* GSUP_Emulation.ttcn, line 74 */
for ( ; ; ) {
current_location.update_lineno(74);
/* GSUP_Emulation.ttcn, line 74 */
if (!(i < 256)) break;
current_location.update_lineno(75);
/* GSUP_Emulation.ttcn, line 75 */
if ((const_cast< const VALUE_ARRAY<ConnectionData, 256, 0>&>(GSUP__Emulation__CT_component_GsupImsiTable)[i].imsi() == imsi)) {
current_location.update_lineno(76);
/* GSUP_Emulation.ttcn, line 76 */
return TRUE;
}
current_location.update_lineno(74);
/* GSUP_Emulation.ttcn, line 74 */
{
INTEGER tmp_1;
++i;
}
}
current_location.update_lineno(79);
/* GSUP_Emulation.ttcn, line 79 */
return FALSE;
}

void start_f__imsi__known(const COMPONENT& component_reference, const CHARSTRING& imsi)
{
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_imsi_known(");
imsi.log();
TTCN_Logger::log_event_str(") on component ");
component_reference.log();
TTCN_Logger::log_char('.');
TTCN_Logger::end_event();
Text_Buf text_buf;
TTCN_Runtime::prepare_start_component(component_reference, "GSUP_Emulation", "f_imsi_known", text_buf);
imsi.encode_text(text_buf);
TTCN_Runtime::send_start_component(text_buf);
}

BOOLEAN f__comp__known(const COMPONENT& client)
{
TTCN_Location current_location("GSUP_Emulation.ttcn", 82, TTCN_Location::LOCATION_FUNCTION, "f_comp_known");
current_location.update_lineno(84);
/* GSUP_Emulation.ttcn, line 84 */
INTEGER i;
current_location.update_lineno(85);
/* GSUP_Emulation.ttcn, line 85 */
i = 0;
current_location.update_lineno(85);
/* GSUP_Emulation.ttcn, line 85 */
for ( ; ; ) {
current_location.update_lineno(85);
/* GSUP_Emulation.ttcn, line 85 */
if (!(i < 256)) break;
current_location.update_lineno(86);
/* GSUP_Emulation.ttcn, line 86 */
if ((const_cast< const VALUE_ARRAY<ConnectionData, 256, 0>&>(GSUP__Emulation__CT_component_GsupImsiTable)[i].comp__ref() == client)) {
current_location.update_lineno(87);
/* GSUP_Emulation.ttcn, line 87 */
return TRUE;
}
current_location.update_lineno(85);
/* GSUP_Emulation.ttcn, line 85 */
{
INTEGER tmp_3;
++i;
}
}
current_location.update_lineno(90);
/* GSUP_Emulation.ttcn, line 90 */
return FALSE;
}

void start_f__comp__known(const COMPONENT& component_reference, const COMPONENT& client)
{
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_comp_known(");
client.log();
TTCN_Logger::log_event_str(") on component ");
component_reference.log();
TTCN_Logger::log_char('.');
TTCN_Logger::end_event();
Text_Buf text_buf;
TTCN_Runtime::prepare_start_component(component_reference, "GSUP_Emulation", "f_comp_known", text_buf);
client.encode_text(text_buf);
TTCN_Runtime::send_start_component(text_buf);
}

COMPONENT f__comp__by__imsi(const CHARSTRING& imsi)
{
TTCN_Location current_location("GSUP_Emulation.ttcn", 94, TTCN_Location::LOCATION_FUNCTION, "f_comp_by_imsi");
current_location.update_lineno(96);
/* GSUP_Emulation.ttcn, line 96 */
INTEGER i;
current_location.update_lineno(97);
/* GSUP_Emulation.ttcn, line 97 */
i = 0;
current_location.update_lineno(97);
/* GSUP_Emulation.ttcn, line 97 */
for ( ; ; ) {
current_location.update_lineno(97);
/* GSUP_Emulation.ttcn, line 97 */
if (!(i < 256)) break;
current_location.update_lineno(98);
/* GSUP_Emulation.ttcn, line 98 */
if ((const_cast< const VALUE_ARRAY<ConnectionData, 256, 0>&>(GSUP__Emulation__CT_component_GsupImsiTable)[i].imsi() == imsi)) {
current_location.update_lineno(99);
/* GSUP_Emulation.ttcn, line 99 */
return const_cast< const VALUE_ARRAY<ConnectionData, 256, 0>&>(GSUP__Emulation__CT_component_GsupImsiTable)[i].comp__ref();
}
current_location.update_lineno(97);
/* GSUP_Emulation.ttcn, line 97 */
{
INTEGER tmp_5;
++i;
}
}
current_location.update_lineno(102);
/* GSUP_Emulation.ttcn, line 102 */
TTCN_Runtime::setverdict(FAIL,(TTCN_Logger::begin_event_log2str(),TTCN_Logger::log_event_str("GSUP IMSI table not found by IMSI "),imsi.log(),TTCN_Logger::end_event_log2str()));
current_location.update_lineno(103);
/* GSUP_Emulation.ttcn, line 103 */
TTCN_Runtime::stop_component(MTC_COMPREF);
}

void start_f__comp__by__imsi(const COMPONENT& component_reference, const CHARSTRING& imsi)
{
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_comp_by_imsi(");
imsi.log();
TTCN_Logger::log_event_str(") on component ");
component_reference.log();
TTCN_Logger::log_char('.');
TTCN_Logger::end_event();
Text_Buf text_buf;
TTCN_Runtime::prepare_start_component(component_reference, "GSUP_Emulation", "f_comp_by_imsi", text_buf);
imsi.encode_text(text_buf);
TTCN_Runtime::send_start_component(text_buf);
}

CHARSTRING f__imsi__by__comp(const COMPONENT& client)
{
TTCN_Location current_location("GSUP_Emulation.ttcn", 107, TTCN_Location::LOCATION_FUNCTION, "f_imsi_by_comp");
{
current_location.update_lineno(109);
/* GSUP_Emulation.ttcn, line 109 */
INTEGER i(0);
current_location.update_lineno(109);
/* GSUP_Emulation.ttcn, line 109 */
for ( ; ; ) {
current_location.update_lineno(109);
/* GSUP_Emulation.ttcn, line 109 */
if (!(i < 256)) break;
current_location.update_lineno(110);
/* GSUP_Emulation.ttcn, line 110 */
if ((const_cast< const VALUE_ARRAY<ConnectionData, 256, 0>&>(GSUP__Emulation__CT_component_GsupImsiTable)[i].comp__ref() == client)) {
current_location.update_lineno(111);
/* GSUP_Emulation.ttcn, line 111 */
return const_cast< const VALUE_ARRAY<ConnectionData, 256, 0>&>(GSUP__Emulation__CT_component_GsupImsiTable)[i].imsi();
}
current_location.update_lineno(109);
/* GSUP_Emulation.ttcn, line 109 */
{
INTEGER tmp_6;
++i;
}
}
}
current_location.update_lineno(114);
/* GSUP_Emulation.ttcn, line 114 */
TTCN_Runtime::setverdict(FAIL,(TTCN_Logger::begin_event_log2str(),TTCN_Logger::log_event_str("GSUP IMSI table not found by component "),client.log(),TTCN_Logger::end_event_log2str()));
current_location.update_lineno(115);
/* GSUP_Emulation.ttcn, line 115 */
TTCN_Runtime::stop_component(MTC_COMPREF);
}

void start_f__imsi__by__comp(const COMPONENT& component_reference, const COMPONENT& client)
{
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_imsi_by_comp(");
client.log();
TTCN_Logger::log_event_str(") on component ");
component_reference.log();
TTCN_Logger::log_char('.');
TTCN_Logger::end_event();
Text_Buf text_buf;
TTCN_Runtime::prepare_start_component(component_reference, "GSUP_Emulation", "f_imsi_by_comp", text_buf);
client.encode_text(text_buf);
TTCN_Runtime::send_start_component(text_buf);
}

void f__imsi__table__init()
{
TTCN_Location current_location("GSUP_Emulation.ttcn", 118, TTCN_Location::LOCATION_FUNCTION, "f_imsi_table_init");
{
current_location.update_lineno(120);
/* GSUP_Emulation.ttcn, line 120 */
INTEGER i(0);
current_location.update_lineno(120);
/* GSUP_Emulation.ttcn, line 120 */
for ( ; ; ) {
current_location.update_lineno(120);
/* GSUP_Emulation.ttcn, line 120 */
if (!(i < 256)) break;
current_location.update_lineno(121);
/* GSUP_Emulation.ttcn, line 121 */
GSUP__Emulation__CT_component_GsupImsiTable[i].comp__ref() = NULL_COMPREF;
current_location.update_lineno(122);
/* GSUP_Emulation.ttcn, line 122 */
GSUP__Emulation__CT_component_GsupImsiTable[i].imsi() = cs_0;
current_location.update_lineno(120);
/* GSUP_Emulation.ttcn, line 120 */
{
INTEGER tmp_9;
++i;
}
}
}
}

void start_f__imsi__table__init(const COMPONENT& component_reference)
{
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_imsi_table_init(");
TTCN_Logger::log_event_str(") on component ");
component_reference.log();
TTCN_Logger::log_char('.');
TTCN_Logger::end_event();
Text_Buf text_buf;
TTCN_Runtime::prepare_start_component(component_reference, "GSUP_Emulation", "f_imsi_table_init", text_buf);
TTCN_Runtime::send_start_component(text_buf);
}

void f__expect__table__init()
{
TTCN_Location current_location("GSUP_Emulation.ttcn", 126, TTCN_Location::LOCATION_FUNCTION, "f_expect_table_init");
{
current_location.update_lineno(128);
/* GSUP_Emulation.ttcn, line 128 */
INTEGER i(0);
current_location.update_lineno(128);
/* GSUP_Emulation.ttcn, line 128 */
for ( ; ; ) {
current_location.update_lineno(128);
/* GSUP_Emulation.ttcn, line 128 */
if (!(i < 256)) break;
current_location.update_lineno(129);
/* GSUP_Emulation.ttcn, line 129 */
GSUP__Emulation__CT_component_GsupExpectTable[i].vc__conn() = NULL_COMPREF;
current_location.update_lineno(130);
/* GSUP_Emulation.ttcn, line 130 */
GSUP__Emulation__CT_component_GsupExpectTable[i].imsi() = OMIT_VALUE;
current_location.update_lineno(128);
/* GSUP_Emulation.ttcn, line 128 */
{
INTEGER tmp_12;
++i;
}
}
}
}

void start_f__expect__table__init(const COMPONENT& component_reference)
{
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_expect_table_init(");
TTCN_Logger::log_event_str(") on component ");
component_reference.log();
TTCN_Logger::log_char('.');
TTCN_Logger::end_event();
Text_Buf text_buf;
TTCN_Runtime::prepare_start_component(component_reference, "GSUP_Emulation", "f_expect_table_init", text_buf);
TTCN_Runtime::send_start_component(text_buf);
}

void f__imsi__table__add(const COMPONENT& comp__ref, const CHARSTRING& imsi)
{
TTCN_Location current_location("GSUP_Emulation.ttcn", 134, TTCN_Location::LOCATION_FUNCTION, "f_imsi_table_add");
{
current_location.update_lineno(136);
/* GSUP_Emulation.ttcn, line 136 */
INTEGER i(0);
current_location.update_lineno(136);
/* GSUP_Emulation.ttcn, line 136 */
for ( ; ; ) {
current_location.update_lineno(136);
/* GSUP_Emulation.ttcn, line 136 */
if (!(i < 256)) break;
current_location.update_lineno(137);
/* GSUP_Emulation.ttcn, line 137 */
if ((const_cast< const VALUE_ARRAY<ConnectionData, 256, 0>&>(GSUP__Emulation__CT_component_GsupImsiTable)[i].imsi() == cs_0)) {
current_location.update_lineno(138);
/* GSUP_Emulation.ttcn, line 138 */
GSUP__Emulation__CT_component_GsupImsiTable[i].comp__ref() = comp__ref;
current_location.update_lineno(139);
/* GSUP_Emulation.ttcn, line 139 */
GSUP__Emulation__CT_component_GsupImsiTable[i].imsi() = imsi;
current_location.update_lineno(140);
/* GSUP_Emulation.ttcn, line 140 */
try {
TTCN_Logger::begin_event(TTCN_USER);
TTCN_Logger::log_event_str("Added IMSI table entry ");
i.log();
comp__ref.log();
imsi.log();
TTCN_Logger::end_event();
} catch (...) {
TTCN_Logger::finish_event();
throw;
}
current_location.update_lineno(141);
/* GSUP_Emulation.ttcn, line 141 */
return;
}
current_location.update_lineno(136);
/* GSUP_Emulation.ttcn, line 136 */
{
INTEGER tmp_15;
++i;
}
}
}
current_location.update_lineno(144);
/* GSUP_Emulation.ttcn, line 144 */
TTCN_Logger::log_str(TTCN_USER, "GSUP IMSI table full!");
TTCN_error("testcase.stop");
}

void start_f__imsi__table__add(const COMPONENT& component_reference, const COMPONENT& comp__ref, const CHARSTRING& imsi)
{
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_imsi_table_add(");
comp__ref.log();
TTCN_Logger::log_event_str(", ");
imsi.log();
TTCN_Logger::log_event_str(") on component ");
component_reference.log();
TTCN_Logger::log_char('.');
TTCN_Logger::end_event();
Text_Buf text_buf;
TTCN_Runtime::prepare_start_component(component_reference, "GSUP_Emulation", "f_imsi_table_add", text_buf);
comp__ref.encode_text(text_buf);
imsi.encode_text(text_buf);
TTCN_Runtime::send_start_component(text_buf);
}

void f__imsi__table__del(const CHARSTRING& imsi)
{
TTCN_Location current_location("GSUP_Emulation.ttcn", 147, TTCN_Location::LOCATION_FUNCTION, "f_imsi_table_del");
{
current_location.update_lineno(149);
/* GSUP_Emulation.ttcn, line 149 */
INTEGER i(0);
current_location.update_lineno(149);
/* GSUP_Emulation.ttcn, line 149 */
for ( ; ; ) {
current_location.update_lineno(149);
/* GSUP_Emulation.ttcn, line 149 */
if (!(i < 256)) break;
current_location.update_lineno(150);
/* GSUP_Emulation.ttcn, line 150 */
if ((const_cast< const VALUE_ARRAY<ConnectionData, 256, 0>&>(GSUP__Emulation__CT_component_GsupImsiTable)[i].imsi() == imsi)) {
current_location.update_lineno(151);
/* GSUP_Emulation.ttcn, line 151 */
try {
TTCN_Logger::begin_event(TTCN_USER);
TTCN_Logger::log_event_str("Deleted GSUP IMSI table entry ");
i.log();
const_cast< const VALUE_ARRAY<ConnectionData, 256, 0>&>(GSUP__Emulation__CT_component_GsupImsiTable)[i].comp__ref().log();
imsi.log();
TTCN_Logger::end_event();
} catch (...) {
TTCN_Logger::finish_event();
throw;
}
current_location.update_lineno(153);
/* GSUP_Emulation.ttcn, line 153 */
GSUP__Emulation__CT_component_GsupImsiTable[i].imsi() = cs_0;
current_location.update_lineno(154);
/* GSUP_Emulation.ttcn, line 154 */
GSUP__Emulation__CT_component_GsupImsiTable[i].comp__ref() = NULL_COMPREF;
current_location.update_lineno(155);
/* GSUP_Emulation.ttcn, line 155 */
return;
}
current_location.update_lineno(149);
/* GSUP_Emulation.ttcn, line 149 */
{
INTEGER tmp_18;
++i;
}
}
}
current_location.update_lineno(158);
/* GSUP_Emulation.ttcn, line 158 */
TTCN_Runtime::setverdict(FAIL,(TTCN_Logger::begin_event_log2str(),TTCN_Logger::log_event_str("GSUP IMSI table attempt to delete non-existant "),imsi.log(),TTCN_Logger::end_event_log2str()));
current_location.update_lineno(159);
/* GSUP_Emulation.ttcn, line 159 */
TTCN_Runtime::stop_component(MTC_COMPREF);
}

void start_f__imsi__table__del(const COMPONENT& component_reference, const CHARSTRING& imsi)
{
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_imsi_table_del(");
imsi.log();
TTCN_Logger::log_event_str(") on component ");
component_reference.log();
TTCN_Logger::log_char('.');
TTCN_Logger::end_event();
Text_Buf text_buf;
TTCN_Runtime::prepare_start_component(component_reference, "GSUP_Emulation", "f_imsi_table_del", text_buf);
imsi.encode_text(text_buf);
TTCN_Runtime::send_start_component(text_buf);
}

void main_(const GsupOps& ops, const CHARSTRING& id)
{
TTCN_Location current_location("GSUP_Emulation.ttcn", 172, TTCN_Location::LOCATION_FUNCTION, "main");
current_location.update_lineno(174);
/* GSUP_Emulation.ttcn, line 174 */
f__imsi__table__init();
current_location.update_lineno(175);
/* GSUP_Emulation.ttcn, line 175 */
f__expect__table__init();
for ( ; ; ) {
current_location.update_lineno(178);
/* GSUP_Emulation.ttcn, line 178 */
COMPONENT vc__conn;
current_location.update_lineno(179);
/* GSUP_Emulation.ttcn, line 179 */
COMPONENT vc__hdlr;
current_location.update_lineno(180);
/* GSUP_Emulation.ttcn, line 180 */
GSUP__Types::GSUP__PDU gsup;
current_location.update_lineno(181);
/* GSUP_Emulation.ttcn, line 181 */
CHARSTRING imsi;
current_location.update_lineno(183);
/* GSUP_Emulation.ttcn, line 183 */
{
tmp_19:
alt_status tmp_19_alt_flag_0 = ALT_MAYBE;
alt_status tmp_19_alt_flag_1 = ALT_MAYBE;
alt_status tmp_19_alt_flag_2 = ALT_MAYBE;
alt_status tmp_19_alt_flag_3 = ALT_MAYBE;
alt_status tmp_19_alt_flag_4 = ALT_MAYBE;
alt_status tmp_19_alt_flag_5 = ALT_MAYBE;
alt_status tmp_19_alt_flag_6 = ALT_MAYBE;
alt_status tmp_19_alt_flag_7 = ALT_MAYBE;
alt_status tmp_19_alt_flag_8 = ALT_MAYBE;
alt_status tmp_19_alt_flag_9 = ALT_MAYBE;
alt_status tmp_19_default_flag = ALT_MAYBE;
boolean first_run = TRUE;
TTCN_Snapshot::take_new(FALSE);
for ( ; ; ) {
if (tmp_19_alt_flag_0 == ALT_MAYBE) {
current_location.update_lineno(185);
/* GSUP_Emulation.ttcn, line 185 */
tmp_19_alt_flag_0 = GSUP__Emulation__CT_component_GSUP.receive(IPA__Emulation::tr__ASP__IPA__EV(IPA__Emulation::ASP__IPA__EventType_template(IPA__Emulation::ASP__IPA__EventType::ASP__IPA__EVENT__ID__ACK), IPA__Emulation::tr__ASP__IPA__EV_conn__id_defval, IPA__Emulation::tr__ASP__IPA__EV_id__resp_defval), NULL, any_compref, NULL, NULL, NULL);
if (tmp_19_alt_flag_0 == ALT_YES) {
current_location.update_lineno(185);
/* GSUP_Emulation.ttcn, line 185 */
goto tmp_19;
}
}
if (tmp_19_alt_flag_1 == ALT_MAYBE) {
current_location.update_lineno(186);
/* GSUP_Emulation.ttcn, line 186 */
tmp_19_alt_flag_1 = GSUP__Emulation__CT_component_GSUP.receive(IPA__Emulation::tr__ASP__IPA__EV(IPA__Emulation::ASP__IPA__EventType_template(IPA__Emulation::ASP__IPA__EventType::ASP__IPA__EVENT__UP), IPA__Emulation::tr__ASP__IPA__EV_conn__id_defval, IPA__Emulation::tr__ASP__IPA__EV_id__resp_defval), NULL, any_compref, NULL, NULL, NULL);
if (tmp_19_alt_flag_1 == ALT_YES) {
current_location.update_lineno(186);
/* GSUP_Emulation.ttcn, line 186 */
goto tmp_19;
}
}
if (tmp_19_alt_flag_2 == ALT_MAYBE) {
current_location.update_lineno(187);
/* GSUP_Emulation.ttcn, line 187 */
tmp_19_alt_flag_2 = GSUP__Emulation__CT_component_GSUP.receive(IPA__Emulation::tr__ASP__IPA__EV(IPA__Emulation::ASP__IPA__EventType_template(IPA__Emulation::ASP__IPA__EventType::ASP__IPA__EVENT__DOWN), IPA__Emulation::tr__ASP__IPA__EV_conn__id_defval, IPA__Emulation::tr__ASP__IPA__EV_id__resp_defval), NULL, any_compref, NULL, NULL, NULL);
if (tmp_19_alt_flag_2 == ALT_YES) {
current_location.update_lineno(188);
/* GSUP_Emulation.ttcn, line 188 */
TTCN_Runtime::setverdict(FAIL,(TTCN_Logger::begin_event_log2str(),TTCN_Logger::log_event_str("GSUP Connection Lost"),TTCN_Logger::end_event_log2str()));
current_location.update_lineno(189);
/* GSUP_Emulation.ttcn, line 189 */
TTCN_Runtime::stop_component(MTC_COMPREF);
}
}
if (tmp_19_alt_flag_3 == ALT_MAYBE) {
current_location.update_lineno(193);
/* GSUP_Emulation.ttcn, line 193 */
tmp_19_alt_flag_3 = GSUP__Emulation__CT_component_GSUP.receive(GSUP__Types::GSUP__PDU_template(ANY_VALUE), &(gsup), any_compref, NULL, NULL, NULL);
if (tmp_19_alt_flag_3 == ALT_YES) {
current_location.update_lineno(194);
/* GSUP_Emulation.ttcn, line 194 */
imsi = hex2str(const_cast< const GSUP__Types::GSUP__PDU&>(gsup).ies()[0].val().imsi());
current_location.update_lineno(196);
/* GSUP_Emulation.ttcn, line 196 */
if (f__imsi__known(imsi)) {
current_location.update_lineno(197);
/* GSUP_Emulation.ttcn, line 197 */
vc__conn = f__comp__by__imsi(imsi);
current_location.update_lineno(198);
/* GSUP_Emulation.ttcn, line 198 */
GSUP__Emulation__CT_component_GSUP__CLIENT.send(gsup, COMPONENT(vc__conn), NULL);
}
else {
current_location.update_lineno(201);
/* GSUP_Emulation.ttcn, line 201 */
vc__conn = const_cast< const GsupOps&>(ops).create__cb().invoke(gsup, id);
current_location.update_lineno(203);
/* GSUP_Emulation.ttcn, line 203 */
f__imsi__table__add(vc__conn, imsi);
current_location.update_lineno(205);
/* GSUP_Emulation.ttcn, line 205 */
GSUP__Emulation__CT_component_GSUP__CLIENT.send(gsup, COMPONENT(vc__conn), NULL);
}
break;
}
}
if (tmp_19_alt_flag_4 == ALT_MAYBE) {
current_location.update_lineno(209);
/* GSUP_Emulation.ttcn, line 209 */
tmp_19_alt_flag_4 = GSUP__Emulation__CT_component_GSUP.receive(any_compref, NULL, NULL, NULL);
if (tmp_19_alt_flag_4 == ALT_YES) {
current_location.update_lineno(209);
/* GSUP_Emulation.ttcn, line 209 */
goto tmp_19;
}
}
if (tmp_19_alt_flag_5 == ALT_MAYBE) {
current_location.update_lineno(212);
/* GSUP_Emulation.ttcn, line 212 */
tmp_19_alt_flag_5 = GSUP__Emulation__CT_component_GSUP__CLIENT.receive(GSUP__Types::GSUP__PDU_template(ANY_VALUE), &(gsup), any_compref, &(vc__conn), NULL, NULL);
if (tmp_19_alt_flag_5 == ALT_YES) {
current_location.update_lineno(214);
/* GSUP_Emulation.ttcn, line 214 */
GSUP__Emulation__CT_component_GSUP.send(gsup, FALSE, NULL);
break;
}
}
if (tmp_19_alt_flag_6 == ALT_MAYBE) {
current_location.update_lineno(219);
/* GSUP_Emulation.ttcn, line 219 */
{
GSUPEM__register__expect_template tmp_23;
tmp_23.imsi() = ANY_VALUE;
tmp_23.hdlr() = ANY_VALUE;
tmp_19_alt_flag_6 = GSUP__Emulation__CT_component_GSUP__PROC.getcall(tmp_23, any_compref, GSUPEM__register__expect_call_redirect(&(imsi), &(vc__hdlr)), NULL, NULL, NULL);
}
if (tmp_19_alt_flag_6 == ALT_YES) {
current_location.update_lineno(220);
/* GSUP_Emulation.ttcn, line 220 */
f__create__expect(imsi, vc__hdlr);
current_location.update_lineno(221);
/* GSUP_Emulation.ttcn, line 221 */
{
GSUPEM__register__expect_template tmp_24;
tmp_24.imsi() = imsi;
tmp_24.hdlr() = vc__hdlr;
GSUP__Emulation__CT_component_GSUP__PROC.reply(tmp_24, COMPONENT(vc__hdlr), NULL);
}
break;
}
}
if (tmp_19_alt_flag_7 == ALT_MAYBE) {
current_location.update_lineno(224);
/* GSUP_Emulation.ttcn, line 224 */
{
GSUPEM__unregister__expect_template tmp_25;
tmp_25.imsi() = ANY_VALUE;
tmp_25.hdlr() = ANY_VALUE;
tmp_19_alt_flag_7 = GSUP__Emulation__CT_component_GSUP__PROC.getcall(tmp_25, any_compref, GSUPEM__unregister__expect_call_redirect(&(imsi), &(vc__hdlr)), NULL, NULL, NULL);
}
if (tmp_19_alt_flag_7 == ALT_YES) {
current_location.update_lineno(225);
/* GSUP_Emulation.ttcn, line 225 */
f__destroy__expect(imsi, vc__hdlr);
current_location.update_lineno(226);
/* GSUP_Emulation.ttcn, line 226 */
{
GSUPEM__unregister__expect_template tmp_26;
tmp_26.imsi() = imsi;
tmp_26.hdlr() = vc__hdlr;
GSUP__Emulation__CT_component_GSUP__PROC.reply(tmp_26, COMPONENT(vc__hdlr), NULL);
}
break;
}
}
if (tmp_19_alt_flag_8 == ALT_MAYBE) {
current_location.update_lineno(229);
/* GSUP_Emulation.ttcn, line 229 */
{
GSUPEM__unregister__connhdlr_template tmp_27;
tmp_27.imsi() = ANY_VALUE;
tmp_19_alt_flag_8 = GSUP__Emulation__CT_component_GSUP__PROC.getcall(tmp_27, any_compref, GSUPEM__unregister__connhdlr_call_redirect(&(imsi)), &(vc__hdlr), NULL, NULL);
}
if (tmp_19_alt_flag_8 == ALT_YES) {
current_location.update_lineno(230);
/* GSUP_Emulation.ttcn, line 230 */
f__imsi__table__del(imsi);
current_location.update_lineno(231);
/* GSUP_Emulation.ttcn, line 231 */
{
GSUPEM__unregister__connhdlr_template tmp_28;
tmp_28.imsi() = imsi;
GSUP__Emulation__CT_component_GSUP__PROC.reply(tmp_28, COMPONENT(vc__hdlr), NULL);
}
break;
}
}
if (tmp_19_alt_flag_9 == ALT_MAYBE) {
current_location.update_lineno(233);
/* GSUP_Emulation.ttcn, line 233 */
{
GSUPEM__change__connhdlr_template tmp_29;
tmp_29.imsi() = ANY_VALUE;
tmp_29.hdlr() = ANY_VALUE;
tmp_19_alt_flag_9 = GSUP__Emulation__CT_component_GSUP__PROC.getcall(tmp_29, any_compref, GSUPEM__change__connhdlr_call_redirect(&(imsi), &(vc__hdlr)), NULL, NULL, NULL);
}
if (tmp_19_alt_flag_9 == ALT_YES) {
current_location.update_lineno(234);
/* GSUP_Emulation.ttcn, line 234 */
f__imsi__table__del(imsi);
current_location.update_lineno(235);
/* GSUP_Emulation.ttcn, line 235 */
f__imsi__table__add(vc__hdlr, imsi);
current_location.update_lineno(236);
/* GSUP_Emulation.ttcn, line 236 */
{
GSUPEM__change__connhdlr_template tmp_30;
tmp_30.imsi() = imsi;
tmp_30.hdlr() = vc__hdlr;
GSUP__Emulation__CT_component_GSUP__PROC.reply(tmp_30, COMPONENT(vc__hdlr), NULL);
}
break;
}
}
if (tmp_19_default_flag == ALT_MAYBE) {
tmp_19_default_flag = TTCN_Default::try_altsteps(first_run);
if (tmp_19_default_flag == ALT_YES || tmp_19_default_flag == ALT_BREAK) break;
else if (tmp_19_default_flag == ALT_REPEAT) goto tmp_19;
}
current_location.update_lineno(183);
/* GSUP_Emulation.ttcn, line 183 */
if (tmp_19_alt_flag_0 == ALT_NO && tmp_19_alt_flag_1 == ALT_NO && tmp_19_alt_flag_2 == ALT_NO && tmp_19_alt_flag_3 == ALT_NO && tmp_19_alt_flag_4 == ALT_NO && tmp_19_alt_flag_5 == ALT_NO && tmp_19_alt_flag_6 == ALT_NO && tmp_19_alt_flag_7 == ALT_NO && tmp_19_alt_flag_8 == ALT_NO && tmp_19_alt_flag_9 == ALT_NO && tmp_19_default_flag == ALT_NO) TTCN_error("None of the branches can be chosen in the alt statement in file GSUP_Emulation.ttcn between lines 183 and 239.");
TTCN_Snapshot::take_new(TRUE);
first_run = FALSE;
}
}
}
}

void start_main_(const COMPONENT& component_reference, const GsupOps& ops, const CHARSTRING& id)
{
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function main(");
ops.log();
TTCN_Logger::log_event_str(", ");
id.log();
TTCN_Logger::log_event_str(") on component ");
component_reference.log();
TTCN_Logger::log_char('.');
TTCN_Logger::end_event();
Text_Buf text_buf;
TTCN_Runtime::prepare_start_component(component_reference, "GSUP_Emulation", "main", text_buf);
ops.encode_text(text_buf);
id.encode_text(text_buf);
TTCN_Runtime::send_start_component(text_buf);
}

COMPONENT ExpectedCreateCallback(const GSUP__Types::GSUP__PDU& gsup, const CHARSTRING& )
{
TTCN_Location current_location("GSUP_Emulation.ttcn", 267, TTCN_Location::LOCATION_FUNCTION, "ExpectedCreateCallback");
current_location.update_lineno(269);
/* GSUP_Emulation.ttcn, line 269 */
COMPONENT ret(NULL_COMPREF);
current_location.update_lineno(270);
/* GSUP_Emulation.ttcn, line 270 */
CHARSTRING imsi;
current_location.update_lineno(271);
/* GSUP_Emulation.ttcn, line 271 */
INTEGER i;
current_location.update_lineno(273);
/* GSUP_Emulation.ttcn, line 273 */
imsi = hex2str(const_cast< const GSUP__Types::GSUP__PDU&>(gsup).ies()[0].val().imsi());
current_location.update_lineno(275);
/* GSUP_Emulation.ttcn, line 275 */
i = 0;
current_location.update_lineno(275);
/* GSUP_Emulation.ttcn, line 275 */
for ( ; ; ) {
current_location.update_lineno(275);
/* GSUP_Emulation.ttcn, line 275 */
if (!(i < 256)) break;
{
current_location.update_lineno(276);
/* GSUP_Emulation.ttcn, line 276 */
{
boolean tmp_39;
{
boolean tmp_34 = GSUP__Emulation__CT_component_GsupExpectTable.is_bound();
if(tmp_34) {
const int tmp_35 = i;
tmp_34 = (tmp_35 >= 0) && (GSUP__Emulation__CT_component_GsupExpectTable.size_of() > tmp_35);
if(tmp_34) {
const ExpectData& tmp_36 = GSUP__Emulation__CT_component_GsupExpectTable[tmp_35];
tmp_34 = tmp_36.is_bound();
if(tmp_34) {
const OPTIONAL< CHARSTRING >& tmp_37 = tmp_36.imsi();
switch (tmp_37.get_selection()) {
case OPTIONAL_UNBOUND:
tmp_34 = FALSE;
break;
case OPTIONAL_OMIT:
tmp_34 = FALSE;
break;
default:
{
const CHARSTRING& tmp_38 = (const CHARSTRING&) tmp_37;
tmp_34 = tmp_38.is_present();
break;}
}
}
}
}
tmp_39 = (!(tmp_34));
}
if (tmp_39) {
current_location.update_lineno(277);
/* GSUP_Emulation.ttcn, line 277 */
goto tmp_33;
}
}
current_location.update_lineno(279);
/* GSUP_Emulation.ttcn, line 279 */
if ((imsi == const_cast< const VALUE_ARRAY<ExpectData, 256, 0>&>(GSUP__Emulation__CT_component_GsupExpectTable)[i].imsi())) {
current_location.update_lineno(280);
/* GSUP_Emulation.ttcn, line 280 */
ret = const_cast< const VALUE_ARRAY<ExpectData, 256, 0>&>(GSUP__Emulation__CT_component_GsupExpectTable)[i].vc__conn();
current_location.update_lineno(282);
/* GSUP_Emulation.ttcn, line 282 */
GSUP__Emulation__CT_component_GsupExpectTable[i].imsi() = OMIT_VALUE;
current_location.update_lineno(283);
/* GSUP_Emulation.ttcn, line 283 */
GSUP__Emulation__CT_component_GsupExpectTable[i].vc__conn() = NULL_COMPREF;
current_location.update_lineno(284);
/* GSUP_Emulation.ttcn, line 284 */
try {
TTCN_Logger::begin_event(TTCN_USER);
TTCN_Logger::log_event_str("Found GsupExpect[");
i.log();
TTCN_Logger::log_event_str("] for ");
imsi.log();
TTCN_Logger::log_event_str(" handled at ");
ret.log();
TTCN_Logger::end_event();
} catch (...) {
TTCN_Logger::finish_event();
throw;
}
current_location.update_lineno(286);
/* GSUP_Emulation.ttcn, line 286 */
return ret;
}
}
tmp_33:
current_location.update_lineno(275);
/* GSUP_Emulation.ttcn, line 275 */
{
INTEGER tmp_43;
++i;
}
}
current_location.update_lineno(289);
/* GSUP_Emulation.ttcn, line 289 */
TTCN_Runtime::setverdict(FAIL,(TTCN_Logger::begin_event_log2str(),TTCN_Logger::log_event_str("Couldn't find GsupExpect for incoming imsi "),imsi.log(),TTCN_Logger::end_event_log2str()));
current_location.update_lineno(290);
/* GSUP_Emulation.ttcn, line 290 */
TTCN_Runtime::stop_component(MTC_COMPREF);
current_location.update_lineno(291);
/* GSUP_Emulation.ttcn, line 291 */
return ret;
}

void start_ExpectedCreateCallback(const COMPONENT& component_reference, const GSUP__Types::GSUP__PDU& gsup, const CHARSTRING& id)
{
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function ExpectedCreateCallback(");
gsup.log();
TTCN_Logger::log_event_str(", ");
id.log();
TTCN_Logger::log_event_str(") on component ");
component_reference.log();
TTCN_Logger::log_char('.');
TTCN_Logger::end_event();
Text_Buf text_buf;
TTCN_Runtime::prepare_start_component(component_reference, "GSUP_Emulation", "ExpectedCreateCallback", text_buf);
gsup.encode_text(text_buf);
id.encode_text(text_buf);
TTCN_Runtime::send_start_component(text_buf);
}

void f__create__expect(const CHARSTRING& imsi, const COMPONENT& hdlr)
{
TTCN_Location current_location("GSUP_Emulation.ttcn", 295, TTCN_Location::LOCATION_FUNCTION, "f_create_expect");
current_location.update_lineno(297);
/* GSUP_Emulation.ttcn, line 297 */
INTEGER i;
current_location.update_lineno(298);
/* GSUP_Emulation.ttcn, line 298 */
i = 0;
current_location.update_lineno(298);
/* GSUP_Emulation.ttcn, line 298 */
for ( ; ; ) {
current_location.update_lineno(298);
/* GSUP_Emulation.ttcn, line 298 */
if (!(i < 256)) break;
current_location.update_lineno(299);
/* GSUP_Emulation.ttcn, line 299 */
{
boolean tmp_50;
{
boolean tmp_45 = GSUP__Emulation__CT_component_GsupExpectTable.is_bound();
if(tmp_45) {
const int tmp_46 = i;
tmp_45 = (tmp_46 >= 0) && (GSUP__Emulation__CT_component_GsupExpectTable.size_of() > tmp_46);
if(tmp_45) {
const ExpectData& tmp_47 = GSUP__Emulation__CT_component_GsupExpectTable[tmp_46];
tmp_45 = tmp_47.is_bound();
if(tmp_45) {
const OPTIONAL< CHARSTRING >& tmp_48 = tmp_47.imsi();
switch (tmp_48.get_selection()) {
case OPTIONAL_UNBOUND:
tmp_45 = FALSE;
break;
case OPTIONAL_OMIT:
tmp_45 = FALSE;
break;
default:
{
const CHARSTRING& tmp_49 = (const CHARSTRING&) tmp_48;
tmp_45 = tmp_49.is_present();
break;}
}
}
}
}
tmp_50 = (!(tmp_45));
}
if (tmp_50) {
current_location.update_lineno(300);
/* GSUP_Emulation.ttcn, line 300 */
GSUP__Emulation__CT_component_GsupExpectTable[i].imsi() = imsi;
current_location.update_lineno(301);
/* GSUP_Emulation.ttcn, line 301 */
GSUP__Emulation__CT_component_GsupExpectTable[i].vc__conn() = hdlr;
current_location.update_lineno(302);
/* GSUP_Emulation.ttcn, line 302 */
try {
TTCN_Logger::begin_event(TTCN_USER);
TTCN_Logger::log_event_str("Created GsupExpect[");
i.log();
TTCN_Logger::log_event_str("] for ");
imsi.log();
TTCN_Logger::log_event_str(" to be handled at ");
hdlr.log();
TTCN_Logger::end_event();
} catch (...) {
TTCN_Logger::finish_event();
throw;
}
current_location.update_lineno(303);
/* GSUP_Emulation.ttcn, line 303 */
return;
}
}
current_location.update_lineno(298);
/* GSUP_Emulation.ttcn, line 298 */
{
INTEGER tmp_53;
++i;
}
}
current_location.update_lineno(306);
/* GSUP_Emulation.ttcn, line 306 */
TTCN_Logger::log_str(TTCN_USER, "No space left in GsupExpectTable");
TTCN_error("testcase.stop");
}

void start_f__create__expect(const COMPONENT& component_reference, const CHARSTRING& imsi, const COMPONENT& hdlr)
{
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_create_expect(");
imsi.log();
TTCN_Logger::log_event_str(", ");
hdlr.log();
TTCN_Logger::log_event_str(") on component ");
component_reference.log();
TTCN_Logger::log_char('.');
TTCN_Logger::end_event();
Text_Buf text_buf;
TTCN_Runtime::prepare_start_component(component_reference, "GSUP_Emulation", "f_create_expect", text_buf);
imsi.encode_text(text_buf);
hdlr.encode_text(text_buf);
TTCN_Runtime::send_start_component(text_buf);
}

void f__destroy__expect(const CHARSTRING& imsi, const COMPONENT& hdlr)
{
TTCN_Location current_location("GSUP_Emulation.ttcn", 310, TTCN_Location::LOCATION_FUNCTION, "f_destroy_expect");
current_location.update_lineno(312);
/* GSUP_Emulation.ttcn, line 312 */
INTEGER i;
current_location.update_lineno(313);
/* GSUP_Emulation.ttcn, line 313 */
i = 0;
current_location.update_lineno(313);
/* GSUP_Emulation.ttcn, line 313 */
for ( ; ; ) {
current_location.update_lineno(313);
/* GSUP_Emulation.ttcn, line 313 */
if (!(i < 256)) break;
current_location.update_lineno(314);
/* GSUP_Emulation.ttcn, line 314 */
{
boolean tmp_55;
tmp_55 = (const_cast< const VALUE_ARRAY<ExpectData, 256, 0>&>(GSUP__Emulation__CT_component_GsupExpectTable)[i].imsi() == imsi);
if (tmp_55) tmp_55 = (const_cast< const VALUE_ARRAY<ExpectData, 256, 0>&>(GSUP__Emulation__CT_component_GsupExpectTable)[i].vc__conn() == hdlr);
if (tmp_55) {
current_location.update_lineno(315);
/* GSUP_Emulation.ttcn, line 315 */
GSUP__Emulation__CT_component_GsupExpectTable[i].imsi() = OMIT_VALUE;
current_location.update_lineno(316);
/* GSUP_Emulation.ttcn, line 316 */
GSUP__Emulation__CT_component_GsupExpectTable[i].vc__conn() = NULL_COMPREF;
current_location.update_lineno(317);
/* GSUP_Emulation.ttcn, line 317 */
try {
TTCN_Logger::begin_event(TTCN_USER);
TTCN_Logger::log_event_str("Destroyed GsupExpect[");
i.log();
TTCN_Logger::log_event_str("] for ");
imsi.log();
TTCN_Logger::log_event_str(" to be handled at ");
hdlr.log();
TTCN_Logger::end_event();
} catch (...) {
TTCN_Logger::finish_event();
throw;
}
current_location.update_lineno(318);
/* GSUP_Emulation.ttcn, line 318 */
return;
}
}
current_location.update_lineno(313);
/* GSUP_Emulation.ttcn, line 313 */
{
INTEGER tmp_58;
++i;
}
}
current_location.update_lineno(321);
/* GSUP_Emulation.ttcn, line 321 */
TTCN_Logger::log_str(TTCN_USER, "No matching expect found to be destoyed");
TTCN_error("testcase.stop");
}

void start_f__destroy__expect(const COMPONENT& component_reference, const CHARSTRING& imsi, const COMPONENT& hdlr)
{
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_destroy_expect(");
imsi.log();
TTCN_Logger::log_event_str(", ");
hdlr.log();
TTCN_Logger::log_event_str(") on component ");
component_reference.log();
TTCN_Logger::log_char('.');
TTCN_Logger::end_event();
Text_Buf text_buf;
TTCN_Runtime::prepare_start_component(component_reference, "GSUP_Emulation", "f_destroy_expect", text_buf);
imsi.encode_text(text_buf);
hdlr.encode_text(text_buf);
TTCN_Runtime::send_start_component(text_buf);
}

void f__create__gsup__expect(const CHARSTRING& imsi)
{
TTCN_Location current_location("GSUP_Emulation.ttcn", 325, TTCN_Location::LOCATION_FUNCTION, "f_create_gsup_expect");
current_location.update_lineno(326);
/* GSUP_Emulation.ttcn, line 326 */
{
GSUPEM__register__expect_template tmp_59;
tmp_59.imsi() = imsi;
tmp_59.hdlr() = self;
GSUP__ConnHdlr_component_GSUP__PROC.call(tmp_59, FALSE, NULL);
}
{
alt_status tmp_60_alt_flag_0 = ALT_MAYBE;
current_location.update_lineno(326);
/* GSUP_Emulation.ttcn, line 326 */
TTCN_Snapshot::take_new(FALSE);
for ( ; ; ) {
if (tmp_60_alt_flag_0 == ALT_MAYBE) {
current_location.update_lineno(327);
/* GSUP_Emulation.ttcn, line 327 */
{
GSUPEM__register__expect_template tmp_61;
tmp_61.imsi() = ANY_VALUE;
tmp_61.hdlr() = ANY_VALUE;
tmp_60_alt_flag_0 = GSUP__ConnHdlr_component_GSUP__PROC.getreply(tmp_61, any_compref, GSUPEM__register__expect_reply_redirect(), NULL, NULL, NULL);
}
if (tmp_60_alt_flag_0 == ALT_YES) break;
}
current_location.update_lineno(326);
/* GSUP_Emulation.ttcn, line 326 */
if (tmp_60_alt_flag_0 == ALT_NO) TTCN_error("None of the branches can be chosen in the response and exception handling part of call statement in file GSUP_Emulation.ttcn between lines 326 and 328.");
TTCN_Snapshot::take_new(TRUE);
}
}
}

void start_f__create__gsup__expect(const COMPONENT& component_reference, const CHARSTRING& imsi)
{
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_create_gsup_expect(");
imsi.log();
TTCN_Logger::log_event_str(") on component ");
component_reference.log();
TTCN_Logger::log_char('.');
TTCN_Logger::end_event();
Text_Buf text_buf;
TTCN_Runtime::prepare_start_component(component_reference, "GSUP_Emulation", "f_create_gsup_expect", text_buf);
imsi.encode_text(text_buf);
TTCN_Runtime::send_start_component(text_buf);
}

void f__destroy__gsup__expect(const CHARSTRING& imsi)
{
TTCN_Location current_location("GSUP_Emulation.ttcn", 331, TTCN_Location::LOCATION_FUNCTION, "f_destroy_gsup_expect");
current_location.update_lineno(332);
/* GSUP_Emulation.ttcn, line 332 */
{
GSUPEM__unregister__expect_template tmp_62;
tmp_62.imsi() = imsi;
tmp_62.hdlr() = self;
GSUP__ConnHdlr_component_GSUP__PROC.call(tmp_62, FALSE, NULL);
}
{
alt_status tmp_63_alt_flag_0 = ALT_MAYBE;
current_location.update_lineno(332);
/* GSUP_Emulation.ttcn, line 332 */
TTCN_Snapshot::take_new(FALSE);
for ( ; ; ) {
if (tmp_63_alt_flag_0 == ALT_MAYBE) {
current_location.update_lineno(333);
/* GSUP_Emulation.ttcn, line 333 */
{
GSUPEM__unregister__expect_template tmp_64;
tmp_64.imsi() = ANY_VALUE;
tmp_64.hdlr() = ANY_VALUE;
tmp_63_alt_flag_0 = GSUP__ConnHdlr_component_GSUP__PROC.getreply(tmp_64, any_compref, GSUPEM__unregister__expect_reply_redirect(), NULL, NULL, NULL);
}
if (tmp_63_alt_flag_0 == ALT_YES) break;
}
current_location.update_lineno(332);
/* GSUP_Emulation.ttcn, line 332 */
if (tmp_63_alt_flag_0 == ALT_NO) TTCN_error("None of the branches can be chosen in the response and exception handling part of call statement in file GSUP_Emulation.ttcn between lines 332 and 334.");
TTCN_Snapshot::take_new(TRUE);
}
}
}

void start_f__destroy__gsup__expect(const COMPONENT& component_reference, const CHARSTRING& imsi)
{
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_destroy_gsup_expect(");
imsi.log();
TTCN_Logger::log_event_str(") on component ");
component_reference.log();
TTCN_Logger::log_char('.');
TTCN_Logger::end_event();
Text_Buf text_buf;
TTCN_Runtime::prepare_start_component(component_reference, "GSUP_Emulation", "f_destroy_gsup_expect", text_buf);
imsi.encode_text(text_buf);
TTCN_Runtime::send_start_component(text_buf);
}

void f__unregister__gsup__imsi(const CHARSTRING& imsi)
{
TTCN_Location current_location("GSUP_Emulation.ttcn", 337, TTCN_Location::LOCATION_FUNCTION, "f_unregister_gsup_imsi");
current_location.update_lineno(338);
/* GSUP_Emulation.ttcn, line 338 */
{
GSUPEM__unregister__connhdlr_template tmp_65;
tmp_65.imsi() = imsi;
GSUP__ConnHdlr_component_GSUP__PROC.call(tmp_65, FALSE, NULL);
}
{
alt_status tmp_66_alt_flag_0 = ALT_MAYBE;
current_location.update_lineno(338);
/* GSUP_Emulation.ttcn, line 338 */
TTCN_Snapshot::take_new(FALSE);
for ( ; ; ) {
if (tmp_66_alt_flag_0 == ALT_MAYBE) {
current_location.update_lineno(339);
/* GSUP_Emulation.ttcn, line 339 */
{
GSUPEM__unregister__connhdlr_template tmp_67;
tmp_67.imsi() = ANY_VALUE;
tmp_66_alt_flag_0 = GSUP__ConnHdlr_component_GSUP__PROC.getreply(tmp_67, any_compref, GSUPEM__unregister__connhdlr_reply_redirect(), NULL, NULL, NULL);
}
if (tmp_66_alt_flag_0 == ALT_YES) break;
}
current_location.update_lineno(338);
/* GSUP_Emulation.ttcn, line 338 */
if (tmp_66_alt_flag_0 == ALT_NO) TTCN_error("None of the branches can be chosen in the response and exception handling part of call statement in file GSUP_Emulation.ttcn between lines 338 and 340.");
TTCN_Snapshot::take_new(TRUE);
}
}
}

void start_f__unregister__gsup__imsi(const COMPONENT& component_reference, const CHARSTRING& imsi)
{
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_unregister_gsup_imsi(");
imsi.log();
TTCN_Logger::log_event_str(") on component ");
component_reference.log();
TTCN_Logger::log_char('.');
TTCN_Logger::end_event();
Text_Buf text_buf;
TTCN_Runtime::prepare_start_component(component_reference, "GSUP_Emulation", "f_unregister_gsup_imsi", text_buf);
imsi.encode_text(text_buf);
TTCN_Runtime::send_start_component(text_buf);
}

void f__create__gsup__expect__explicit(const CHARSTRING& imsi, const COMPONENT& ct)
{
TTCN_Location current_location("GSUP_Emulation.ttcn", 346, TTCN_Location::LOCATION_FUNCTION, "f_create_gsup_expect_explicit");
current_location.update_lineno(347);
/* GSUP_Emulation.ttcn, line 347 */
{
GSUPEM__register__expect_template tmp_68;
tmp_68.imsi() = imsi;
tmp_68.hdlr() = self;
GSUP__ConnHdlr_component_GSUP__PROC.call(tmp_68, COMPONENT(ct), NULL);
}
{
alt_status tmp_69_alt_flag_0 = ALT_MAYBE;
current_location.update_lineno(347);
/* GSUP_Emulation.ttcn, line 347 */
TTCN_Snapshot::take_new(FALSE);
for ( ; ; ) {
if (tmp_69_alt_flag_0 == ALT_MAYBE) {
current_location.update_lineno(348);
/* GSUP_Emulation.ttcn, line 348 */
{
GSUPEM__register__expect_template tmp_70;
tmp_70.imsi() = ANY_VALUE;
tmp_70.hdlr() = ANY_VALUE;
tmp_69_alt_flag_0 = GSUP__ConnHdlr_component_GSUP__PROC.getreply(tmp_70, any_compref, GSUPEM__register__expect_reply_redirect(), NULL, NULL, NULL);
}
if (tmp_69_alt_flag_0 == ALT_YES) break;
}
current_location.update_lineno(347);
/* GSUP_Emulation.ttcn, line 347 */
if (tmp_69_alt_flag_0 == ALT_NO) TTCN_error("None of the branches can be chosen in the response and exception handling part of call statement in file GSUP_Emulation.ttcn between lines 347 and 349.");
TTCN_Snapshot::take_new(TRUE);
}
}
}

void start_f__create__gsup__expect__explicit(const COMPONENT& component_reference, const CHARSTRING& imsi, const COMPONENT& ct)
{
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_create_gsup_expect_explicit(");
imsi.log();
TTCN_Logger::log_event_str(", ");
ct.log();
TTCN_Logger::log_event_str(") on component ");
component_reference.log();
TTCN_Logger::log_char('.');
TTCN_Logger::end_event();
Text_Buf text_buf;
TTCN_Runtime::prepare_start_component(component_reference, "GSUP_Emulation", "f_create_gsup_expect_explicit", text_buf);
imsi.encode_text(text_buf);
ct.encode_text(text_buf);
TTCN_Runtime::send_start_component(text_buf);
}

void f__gsup__change__connhdlr(const CHARSTRING& imsi)
{
TTCN_Location current_location("GSUP_Emulation.ttcn", 352, TTCN_Location::LOCATION_FUNCTION, "f_gsup_change_connhdlr");
current_location.update_lineno(353);
/* GSUP_Emulation.ttcn, line 353 */
{
GSUPEM__change__connhdlr_template tmp_71;
tmp_71.imsi() = imsi;
tmp_71.hdlr() = self;
GSUP__ConnHdlr_component_GSUP__PROC.call(tmp_71, FALSE, NULL);
}
{
alt_status tmp_72_alt_flag_0 = ALT_MAYBE;
current_location.update_lineno(353);
/* GSUP_Emulation.ttcn, line 353 */
TTCN_Snapshot::take_new(FALSE);
for ( ; ; ) {
if (tmp_72_alt_flag_0 == ALT_MAYBE) {
current_location.update_lineno(354);
/* GSUP_Emulation.ttcn, line 354 */
{
GSUPEM__change__connhdlr_template tmp_73;
tmp_73.imsi() = ANY_VALUE;
tmp_73.hdlr() = ANY_VALUE;
tmp_72_alt_flag_0 = GSUP__ConnHdlr_component_GSUP__PROC.getreply(tmp_73, any_compref, GSUPEM__change__connhdlr_reply_redirect(), NULL, NULL, NULL);
}
if (tmp_72_alt_flag_0 == ALT_YES) break;
}
current_location.update_lineno(353);
/* GSUP_Emulation.ttcn, line 353 */
if (tmp_72_alt_flag_0 == ALT_NO) TTCN_error("None of the branches can be chosen in the response and exception handling part of call statement in file GSUP_Emulation.ttcn between lines 353 and 355.");
TTCN_Snapshot::take_new(TRUE);
}
}
}

void start_f__gsup__change__connhdlr(const COMPONENT& component_reference, const CHARSTRING& imsi)
{
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_gsup_change_connhdlr(");
imsi.log();
TTCN_Logger::log_event_str(") on component ");
component_reference.log();
TTCN_Logger::log_char('.');
TTCN_Logger::end_event();
Text_Buf text_buf;
TTCN_Runtime::prepare_start_component(component_reference, "GSUP_Emulation", "f_gsup_change_connhdlr", text_buf);
imsi.encode_text(text_buf);
TTCN_Runtime::send_start_component(text_buf);
}


/* Bodies of static functions */

void pre_init_module()
{
TTCN_Location current_location("GSUP_Emulation.ttcn", 0, TTCN_Location::LOCATION_UNKNOWN, "GSUP_Emulation");
IPA__Emulation::module_object.pre_init_module();
module_object.add_function("f_imsi_known", (genericfunc_t)&f__imsi__known, (genericfunc_t)&start_f__imsi__known);
module_object.add_function("f_comp_known", (genericfunc_t)&f__comp__known, (genericfunc_t)&start_f__comp__known);
module_object.add_function("f_comp_by_imsi", (genericfunc_t)&f__comp__by__imsi, (genericfunc_t)&start_f__comp__by__imsi);
module_object.add_function("f_imsi_by_comp", (genericfunc_t)&f__imsi__by__comp, (genericfunc_t)&start_f__imsi__by__comp);
module_object.add_function("f_imsi_table_init", (genericfunc_t)&f__imsi__table__init, (genericfunc_t)&start_f__imsi__table__init);
module_object.add_function("f_expect_table_init", (genericfunc_t)&f__expect__table__init, (genericfunc_t)&start_f__expect__table__init);
module_object.add_function("f_imsi_table_add", (genericfunc_t)&f__imsi__table__add, (genericfunc_t)&start_f__imsi__table__add);
module_object.add_function("f_imsi_table_del", (genericfunc_t)&f__imsi__table__del, (genericfunc_t)&start_f__imsi__table__del);
module_object.add_function("main", (genericfunc_t)&main_, (genericfunc_t)&start_main_);
module_object.add_function("ExpectedCreateCallback", (genericfunc_t)&ExpectedCreateCallback, (genericfunc_t)&start_ExpectedCreateCallback);
module_object.add_function("f_create_expect", (genericfunc_t)&f__create__expect, (genericfunc_t)&start_f__create__expect);
module_object.add_function("f_destroy_expect", (genericfunc_t)&f__destroy__expect, (genericfunc_t)&start_f__destroy__expect);
module_object.add_function("f_create_gsup_expect", (genericfunc_t)&f__create__gsup__expect, (genericfunc_t)&start_f__create__gsup__expect);
module_object.add_function("f_destroy_gsup_expect", (genericfunc_t)&f__destroy__gsup__expect, (genericfunc_t)&start_f__destroy__gsup__expect);
module_object.add_function("f_unregister_gsup_imsi", (genericfunc_t)&f__unregister__gsup__imsi, (genericfunc_t)&start_f__unregister__gsup__imsi);
module_object.add_function("f_create_gsup_expect_explicit", (genericfunc_t)&f__create__gsup__expect__explicit, (genericfunc_t)&start_f__create__gsup__expect__explicit);
module_object.add_function("f_gsup_change_connhdlr", (genericfunc_t)&f__gsup__change__connhdlr, (genericfunc_t)&start_f__gsup__change__connhdlr);
}

void post_init_module()
{
TTCN_Location current_location("GSUP_Emulation.ttcn", 0, TTCN_Location::LOCATION_UNKNOWN, "GSUP_Emulation");
IPA__Emulation::module_object.post_init_module();
}

boolean init_comp_type(const char *component_type, boolean init_base_comps)
{
(void)init_base_comps;
if (!strcmp(component_type, "GSUP_ConnHdlr")) {
GSUP__ConnHdlr_component_GSUP.activate_port();
GSUP__ConnHdlr_component_GSUP__PROC.activate_port();
return TRUE;
} else if (!strcmp(component_type, "GSUP_Emulation_CT")) {
GSUP__Emulation__CT_component_GSUP.activate_port();
GSUP__Emulation__CT_component_GSUP__CLIENT.activate_port();
GSUP__Emulation__CT_component_GsupImsiTable.clean_up();
GSUP__Emulation__CT_component_GsupExpectTable.clean_up();
GSUP__Emulation__CT_component_GSUP__PROC.activate_port();
return TRUE;
} else return FALSE;
}

boolean init_system_port(const char* component_type, const char* port_name)
{
if (!strcmp(component_type, "GSUP_ConnHdlr")) {
if (!strcmp(port_name, "GSUP")) {
GSUP__ConnHdlr_component_GSUP.safe_start();
return TRUE;
}
if (!strcmp(port_name, "GSUP_PROC")) {
GSUP__ConnHdlr_component_GSUP__PROC.safe_start();
return TRUE;
}
}
else if (!strcmp(component_type, "GSUP_Emulation_CT")) {
if (!strcmp(port_name, "GSUP")) {
GSUP__Emulation__CT_component_GSUP.safe_start();
return TRUE;
}
if (!strcmp(port_name, "GSUP_CLIENT")) {
GSUP__Emulation__CT_component_GSUP__CLIENT.safe_start();
return TRUE;
}
if (!strcmp(port_name, "GSUP_PROC")) {
GSUP__Emulation__CT_component_GSUP__PROC.safe_start();
return TRUE;
}
}
return FALSE;
}

boolean start_ptc_function(const char *function_name, Text_Buf& function_arguments)
{
if (!strcmp(function_name, "f_imsi_known")) {
CHARSTRING imsi;
imsi.decode_text(function_arguments);
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_imsi_known(");
imsi.log();
TTCN_Logger::log_event_str(").");
TTCN_Logger::end_event();
TTCN_Runtime::function_started(function_arguments);
f__imsi__known(imsi);
TTCN_Runtime::function_finished("f_imsi_known");
return TRUE;
} else if (!strcmp(function_name, "f_comp_known")) {
COMPONENT client;
client.decode_text(function_arguments);
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_comp_known(");
client.log();
TTCN_Logger::log_event_str(").");
TTCN_Logger::end_event();
TTCN_Runtime::function_started(function_arguments);
f__comp__known(client);
TTCN_Runtime::function_finished("f_comp_known");
return TRUE;
} else if (!strcmp(function_name, "f_comp_by_imsi")) {
CHARSTRING imsi;
imsi.decode_text(function_arguments);
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_comp_by_imsi(");
imsi.log();
TTCN_Logger::log_event_str(").");
TTCN_Logger::end_event();
TTCN_Runtime::function_started(function_arguments);
f__comp__by__imsi(imsi);
TTCN_Runtime::function_finished("f_comp_by_imsi");
return TRUE;
} else if (!strcmp(function_name, "f_imsi_by_comp")) {
COMPONENT client;
client.decode_text(function_arguments);
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_imsi_by_comp(");
client.log();
TTCN_Logger::log_event_str(").");
TTCN_Logger::end_event();
TTCN_Runtime::function_started(function_arguments);
f__imsi__by__comp(client);
TTCN_Runtime::function_finished("f_imsi_by_comp");
return TRUE;
} else if (!strcmp(function_name, "f_imsi_table_init")) {
TTCN_Logger::log_str(TTCN_Logger::PARALLEL_PTC, "Starting function f_imsi_table_init().");
TTCN_Runtime::function_started(function_arguments);
f__imsi__table__init();
TTCN_Runtime::function_finished("f_imsi_table_init");
return TRUE;
} else if (!strcmp(function_name, "f_expect_table_init")) {
TTCN_Logger::log_str(TTCN_Logger::PARALLEL_PTC, "Starting function f_expect_table_init().");
TTCN_Runtime::function_started(function_arguments);
f__expect__table__init();
TTCN_Runtime::function_finished("f_expect_table_init");
return TRUE;
} else if (!strcmp(function_name, "f_imsi_table_add")) {
COMPONENT comp__ref;
CHARSTRING imsi;
comp__ref.decode_text(function_arguments);
imsi.decode_text(function_arguments);
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_imsi_table_add(");
comp__ref.log();
TTCN_Logger::log_event_str(", ");
imsi.log();
TTCN_Logger::log_event_str(").");
TTCN_Logger::end_event();
TTCN_Runtime::function_started(function_arguments);
f__imsi__table__add(comp__ref, imsi);
TTCN_Runtime::function_finished("f_imsi_table_add");
return TRUE;
} else if (!strcmp(function_name, "f_imsi_table_del")) {
CHARSTRING imsi;
imsi.decode_text(function_arguments);
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_imsi_table_del(");
imsi.log();
TTCN_Logger::log_event_str(").");
TTCN_Logger::end_event();
TTCN_Runtime::function_started(function_arguments);
f__imsi__table__del(imsi);
TTCN_Runtime::function_finished("f_imsi_table_del");
return TRUE;
} else if (!strcmp(function_name, "main")) {
GsupOps ops;
CHARSTRING id;
ops.decode_text(function_arguments);
id.decode_text(function_arguments);
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function main(");
ops.log();
TTCN_Logger::log_event_str(", ");
id.log();
TTCN_Logger::log_event_str(").");
TTCN_Logger::end_event();
TTCN_Runtime::function_started(function_arguments);
main_(ops, id);
TTCN_Runtime::function_finished("main");
return TRUE;
} else if (!strcmp(function_name, "ExpectedCreateCallback")) {
GSUP__Types::GSUP__PDU gsup;
CHARSTRING id;
gsup.decode_text(function_arguments);
id.decode_text(function_arguments);
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function ExpectedCreateCallback(");
gsup.log();
TTCN_Logger::log_event_str(", ");
id.log();
TTCN_Logger::log_event_str(").");
TTCN_Logger::end_event();
TTCN_Runtime::function_started(function_arguments);
ExpectedCreateCallback(gsup, id);
TTCN_Runtime::function_finished("ExpectedCreateCallback");
return TRUE;
} else if (!strcmp(function_name, "f_create_expect")) {
CHARSTRING imsi;
COMPONENT hdlr;
imsi.decode_text(function_arguments);
hdlr.decode_text(function_arguments);
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_create_expect(");
imsi.log();
TTCN_Logger::log_event_str(", ");
hdlr.log();
TTCN_Logger::log_event_str(").");
TTCN_Logger::end_event();
TTCN_Runtime::function_started(function_arguments);
f__create__expect(imsi, hdlr);
TTCN_Runtime::function_finished("f_create_expect");
return TRUE;
} else if (!strcmp(function_name, "f_destroy_expect")) {
CHARSTRING imsi;
COMPONENT hdlr;
imsi.decode_text(function_arguments);
hdlr.decode_text(function_arguments);
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_destroy_expect(");
imsi.log();
TTCN_Logger::log_event_str(", ");
hdlr.log();
TTCN_Logger::log_event_str(").");
TTCN_Logger::end_event();
TTCN_Runtime::function_started(function_arguments);
f__destroy__expect(imsi, hdlr);
TTCN_Runtime::function_finished("f_destroy_expect");
return TRUE;
} else if (!strcmp(function_name, "f_create_gsup_expect")) {
CHARSTRING imsi;
imsi.decode_text(function_arguments);
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_create_gsup_expect(");
imsi.log();
TTCN_Logger::log_event_str(").");
TTCN_Logger::end_event();
TTCN_Runtime::function_started(function_arguments);
f__create__gsup__expect(imsi);
TTCN_Runtime::function_finished("f_create_gsup_expect");
return TRUE;
} else if (!strcmp(function_name, "f_destroy_gsup_expect")) {
CHARSTRING imsi;
imsi.decode_text(function_arguments);
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_destroy_gsup_expect(");
imsi.log();
TTCN_Logger::log_event_str(").");
TTCN_Logger::end_event();
TTCN_Runtime::function_started(function_arguments);
f__destroy__gsup__expect(imsi);
TTCN_Runtime::function_finished("f_destroy_gsup_expect");
return TRUE;
} else if (!strcmp(function_name, "f_unregister_gsup_imsi")) {
CHARSTRING imsi;
imsi.decode_text(function_arguments);
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_unregister_gsup_imsi(");
imsi.log();
TTCN_Logger::log_event_str(").");
TTCN_Logger::end_event();
TTCN_Runtime::function_started(function_arguments);
f__unregister__gsup__imsi(imsi);
TTCN_Runtime::function_finished("f_unregister_gsup_imsi");
return TRUE;
} else if (!strcmp(function_name, "f_create_gsup_expect_explicit")) {
CHARSTRING imsi;
COMPONENT ct;
imsi.decode_text(function_arguments);
ct.decode_text(function_arguments);
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_create_gsup_expect_explicit(");
imsi.log();
TTCN_Logger::log_event_str(", ");
ct.log();
TTCN_Logger::log_event_str(").");
TTCN_Logger::end_event();
TTCN_Runtime::function_started(function_arguments);
f__create__gsup__expect__explicit(imsi, ct);
TTCN_Runtime::function_finished("f_create_gsup_expect_explicit");
return TRUE;
} else if (!strcmp(function_name, "f_gsup_change_connhdlr")) {
CHARSTRING imsi;
imsi.decode_text(function_arguments);
TTCN_Logger::begin_event(TTCN_Logger::PARALLEL_PTC);
TTCN_Logger::log_event_str("Starting function f_gsup_change_connhdlr(");
imsi.log();
TTCN_Logger::log_event_str(").");
TTCN_Logger::end_event();
TTCN_Runtime::function_started(function_arguments);
f__gsup__change__connhdlr(imsi);
TTCN_Runtime::function_finished("f_gsup_change_connhdlr");
return TRUE;
} else return FALSE;
}


} /* end of namespace */
