// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "MAP_ER_DataTypes.hh"

namespace MAP__ER__DataTypes {

/* Member functions of C++ classes */

MM__EventNotSupported__Param::MM__EventNotSupported__Param()
{
}

MM__EventNotSupported__Param::MM__EventNotSupported__Param(const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer)
  :   field_extensionContainer(par_extensionContainer)
{
}

MM__EventNotSupported__Param::MM__EventNotSupported__Param(const MM__EventNotSupported__Param& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-ER-DataTypes.MM-EventNotSupported-Param.");
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
}

void MM__EventNotSupported__Param::clean_up()
{
field_extensionContainer.clean_up();
}

const TTCN_Typedescriptor_t* MM__EventNotSupported__Param::get_descriptor() const { return &MM__EventNotSupported__Param_descr_; }
MM__EventNotSupported__Param& MM__EventNotSupported__Param::operator=(const MM__EventNotSupported__Param& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-ER-DataTypes.MM-EventNotSupported-Param.");
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
}
return *this;
}

boolean MM__EventNotSupported__Param::operator==(const MM__EventNotSupported__Param& other_value) const
{
return field_extensionContainer==other_value.field_extensionContainer;
}

boolean MM__EventNotSupported__Param::is_bound() const
{
return (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound());
}
boolean MM__EventNotSupported__Param::is_value() const
{
return (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value());
}
int MM__EventNotSupported__Param::size_of() const
{
  int ret_val = 0;
  if (field_extensionContainer.ispresent()) ret_val++;
  return ret_val;
}

void MM__EventNotSupported__Param::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
}

void MM__EventNotSupported__Param::set_implicit_omit()
{
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void MM__EventNotSupported__Param::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @MAP-ER-DataTypes.MM-EventNotSupported-Param has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-ER-DataTypes.MM-EventNotSupported-Param: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-ER-DataTypes.MM-EventNotSupported-Param");
  }
}

void MM__EventNotSupported__Param::encode_text(Text_Buf& text_buf) const
{
field_extensionContainer.encode_text(text_buf);
}

void MM__EventNotSupported__Param::decode_text(Text_Buf& text_buf)
{
field_extensionContainer.decode_text(text_buf);
}

void MM__EventNotSupported__Param::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void MM__EventNotSupported__Param::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* MM__EventNotSupported__Param::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(MM__EventNotSupported__Param_extensionContainer_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean MM__EventNotSupported__Param::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-ER-DataTypes.MM-EventNotSupported-Param' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(MM__EventNotSupported__Param_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int MM__EventNotSupported__Param::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-ER-DataTypes.MM-EventNotSupported-Param.");
    return -1;
  }

  if (p_td.json->as_value) {
   if (field_extensionContainer == OMIT_VALUE) {
     return p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL) + 
       p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
   }
   return field_extensionContainer.JSON_encode(MM__EventNotSupported__Param_extensionContainer_descr_, p_tok, FALSE);
  }
  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(MM__EventNotSupported__Param_extensionContainer_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int MM__EventNotSupported__Param::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const MM__EventNotSupported__Param*>(p_td.json->default_value.val);
    return 0;
  }
  if (p_td.json->as_value) {
   json_token_t j_token = JSON_TOKEN_NONE;
   size_t buf_pos = p_tok.get_buf_pos();
   size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
   if (j_token == JSON_TOKEN_LITERAL_NULL) {
     return JSON_ERROR_FATAL;
   }
   else if (j_token == JSON_TOKEN_OBJECT_START) {
     dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
     if (j_token == JSON_TOKEN_OBJECT_END) {
       field_extensionContainer = OMIT_VALUE;
       return dec_len;
     }
   }
   p_tok.set_buf_pos(buf_pos);
   return field_extensionContainer.JSON_decode(MM__EventNotSupported__Param_extensionContainer_descr_, p_tok, p_silent, FALSE);
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean extensionContainer_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(MM__EventNotSupported__Param_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int MM__EventNotSupported__Param::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_extensionContainer.is_present()) {
    c |= 64;
  }
  p_buf.put_c(c);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(MM__EventNotSupported__Param_extensionContainer_descr_, p_buf);
  return 0;
}

int MM__EventNotSupported__Param::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  if (uc[0] & 64)
    field_extensionContainer.OER_decode(MM__EventNotSupported__Param_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void MM__EventNotSupported__Param::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(MM__EventNotSupported__Param_extensionContainer_descr_, p_buf, p_options);
}

void MM__EventNotSupported__Param::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
if (field_extensionContainer_present) field_extensionContainer.PER_decode(MM__EventNotSupported__Param_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct MM__EventNotSupported__Param_template::single_value_struct {
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
};

void MM__EventNotSupported__Param_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_extensionContainer = ANY_OR_OMIT;
}
}
}

void MM__EventNotSupported__Param_template::copy_value(const MM__EventNotSupported__Param& other_value)
{
single_value = new single_value_struct;
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void MM__EventNotSupported__Param_template::copy_template(const MM__EventNotSupported__Param_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new MM__EventNotSupported__Param_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new MM__EventNotSupported__Param_template(*other_value.implication_.precondition);
implication_.implied_template = new MM__EventNotSupported__Param_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-ER-DataTypes.MM-EventNotSupported-Param.");
break;
}
set_selection(other_value);
}

MM__EventNotSupported__Param_template::MM__EventNotSupported__Param_template()
{
}

MM__EventNotSupported__Param_template::MM__EventNotSupported__Param_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

MM__EventNotSupported__Param_template::MM__EventNotSupported__Param_template(const MM__EventNotSupported__Param& other_value)
{
copy_value(other_value);
}

MM__EventNotSupported__Param_template::MM__EventNotSupported__Param_template(const OPTIONAL<MM__EventNotSupported__Param>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const MM__EventNotSupported__Param&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-ER-DataTypes.MM-EventNotSupported-Param from an unbound optional field.");
}
}

MM__EventNotSupported__Param_template::MM__EventNotSupported__Param_template(MM__EventNotSupported__Param_template* p_precondition, MM__EventNotSupported__Param_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

MM__EventNotSupported__Param_template::MM__EventNotSupported__Param_template(Dynamic_Match_Interface<MM__EventNotSupported__Param>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<MM__EventNotSupported__Param>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

MM__EventNotSupported__Param_template::MM__EventNotSupported__Param_template(const MM__EventNotSupported__Param_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

MM__EventNotSupported__Param_template::~MM__EventNotSupported__Param_template()
{
clean_up();
}

MM__EventNotSupported__Param_template& MM__EventNotSupported__Param_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

MM__EventNotSupported__Param_template& MM__EventNotSupported__Param_template::operator=(const MM__EventNotSupported__Param& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

MM__EventNotSupported__Param_template& MM__EventNotSupported__Param_template::operator=(const OPTIONAL<MM__EventNotSupported__Param>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const MM__EventNotSupported__Param&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-ER-DataTypes.MM-EventNotSupported-Param.");
}
return *this;
}

MM__EventNotSupported__Param_template& MM__EventNotSupported__Param_template::operator=(const MM__EventNotSupported__Param_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean MM__EventNotSupported__Param_template::match(const MM__EventNotSupported__Param& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-ER-DataTypes.MM-EventNotSupported-Param.");
}
return FALSE;
}

boolean MM__EventNotSupported__Param_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound());
}

boolean MM__EventNotSupported__Param_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value());
}

void MM__EventNotSupported__Param_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

MM__EventNotSupported__Param MM__EventNotSupported__Param_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-ER-DataTypes.MM-EventNotSupported-Param.");
MM__EventNotSupported__Param ret_val;
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
return ret_val;
}

void MM__EventNotSupported__Param_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-ER-DataTypes.MM-EventNotSupported-Param.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new MM__EventNotSupported__Param_template[list_length];
}

MM__EventNotSupported__Param_template& MM__EventNotSupported__Param_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-ER-DataTypes.MM-EventNotSupported-Param.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-ER-DataTypes.MM-EventNotSupported-Param.");
return value_list.list_value[list_index];
}

MAP__ExtensionDataTypes::ExtensionContainer_template& MM__EventNotSupported__Param_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& MM__EventNotSupported__Param_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-ER-DataTypes.MM-EventNotSupported-Param.");
return single_value->field_extensionContainer;
}

int MM__EventNotSupported__Param_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.MM-EventNotSupported-Param which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 0;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-ER-DataTypes.MM-EventNotSupported-Param containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.MM-EventNotSupported-Param containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.MM-EventNotSupported-Param containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.MM-EventNotSupported-Param containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.MM-EventNotSupported-Param containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.MM-EventNotSupported-Param containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.MM-EventNotSupported-Param containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.MM-EventNotSupported-Param containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-ER-DataTypes.MM-EventNotSupported-Param.");
  }
  return 0;
}

void MM__EventNotSupported__Param_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void MM__EventNotSupported__Param_template::log_match(const MM__EventNotSupported__Param& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void MM__EventNotSupported__Param_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void MM__EventNotSupported__Param_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_extensionContainer.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-ER-DataTypes.MM-EventNotSupported-Param.");
}
}

void MM__EventNotSupported__Param_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_extensionContainer.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new MM__EventNotSupported__Param_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-ER-DataTypes.MM-EventNotSupported-Param.");
}
}

void MM__EventNotSupported__Param_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    MM__EventNotSupported__Param_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @MAP-ER-DataTypes.MM-EventNotSupported-Param has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-ER-DataTypes.MM-EventNotSupported-Param: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    MM__EventNotSupported__Param_template* precondition = new MM__EventNotSupported__Param_template;
    precondition->set_param(*param.get_elem(0));
    MM__EventNotSupported__Param_template* implied_template = new MM__EventNotSupported__Param_template;
    implied_template->set_param(*param.get_elem(1));
    *this = MM__EventNotSupported__Param_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-ER-DataTypes.MM-EventNotSupported-Param");
  }
  is_ifpresent = param.get_ifpresent();
}

void MM__EventNotSupported__Param_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-ER-DataTypes.MM-EventNotSupported-Param");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-ER-DataTypes.MM-EventNotSupported-Param");
}

boolean MM__EventNotSupported__Param_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean MM__EventNotSupported__Param_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

TargetCellOutsideGCA__Param::TargetCellOutsideGCA__Param()
{
}

TargetCellOutsideGCA__Param::TargetCellOutsideGCA__Param(const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer)
  :   field_extensionContainer(par_extensionContainer)
{
}

TargetCellOutsideGCA__Param::TargetCellOutsideGCA__Param(const TargetCellOutsideGCA__Param& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param.");
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
}

void TargetCellOutsideGCA__Param::clean_up()
{
field_extensionContainer.clean_up();
}

const TTCN_Typedescriptor_t* TargetCellOutsideGCA__Param::get_descriptor() const { return &TargetCellOutsideGCA__Param_descr_; }
TargetCellOutsideGCA__Param& TargetCellOutsideGCA__Param::operator=(const TargetCellOutsideGCA__Param& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param.");
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
}
return *this;
}

boolean TargetCellOutsideGCA__Param::operator==(const TargetCellOutsideGCA__Param& other_value) const
{
return field_extensionContainer==other_value.field_extensionContainer;
}

boolean TargetCellOutsideGCA__Param::is_bound() const
{
return (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound());
}
boolean TargetCellOutsideGCA__Param::is_value() const
{
return (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value());
}
int TargetCellOutsideGCA__Param::size_of() const
{
  int ret_val = 0;
  if (field_extensionContainer.ispresent()) ret_val++;
  return ret_val;
}

void TargetCellOutsideGCA__Param::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
}

void TargetCellOutsideGCA__Param::set_implicit_omit()
{
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void TargetCellOutsideGCA__Param::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-ER-DataTypes.TargetCellOutsideGCA-Param");
  }
}

void TargetCellOutsideGCA__Param::encode_text(Text_Buf& text_buf) const
{
field_extensionContainer.encode_text(text_buf);
}

void TargetCellOutsideGCA__Param::decode_text(Text_Buf& text_buf)
{
field_extensionContainer.decode_text(text_buf);
}

void TargetCellOutsideGCA__Param::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void TargetCellOutsideGCA__Param::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* TargetCellOutsideGCA__Param::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(TargetCellOutsideGCA__Param_extensionContainer_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean TargetCellOutsideGCA__Param::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-ER-DataTypes.TargetCellOutsideGCA-Param' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(TargetCellOutsideGCA__Param_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int TargetCellOutsideGCA__Param::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param.");
    return -1;
  }

  if (p_td.json->as_value) {
   if (field_extensionContainer == OMIT_VALUE) {
     return p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL) + 
       p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
   }
   return field_extensionContainer.JSON_encode(TargetCellOutsideGCA__Param_extensionContainer_descr_, p_tok, FALSE);
  }
  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(TargetCellOutsideGCA__Param_extensionContainer_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int TargetCellOutsideGCA__Param::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const TargetCellOutsideGCA__Param*>(p_td.json->default_value.val);
    return 0;
  }
  if (p_td.json->as_value) {
   json_token_t j_token = JSON_TOKEN_NONE;
   size_t buf_pos = p_tok.get_buf_pos();
   size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
   if (j_token == JSON_TOKEN_LITERAL_NULL) {
     return JSON_ERROR_FATAL;
   }
   else if (j_token == JSON_TOKEN_OBJECT_START) {
     dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
     if (j_token == JSON_TOKEN_OBJECT_END) {
       field_extensionContainer = OMIT_VALUE;
       return dec_len;
     }
   }
   p_tok.set_buf_pos(buf_pos);
   return field_extensionContainer.JSON_decode(TargetCellOutsideGCA__Param_extensionContainer_descr_, p_tok, p_silent, FALSE);
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean extensionContainer_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(TargetCellOutsideGCA__Param_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int TargetCellOutsideGCA__Param::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_extensionContainer.is_present()) {
    c |= 64;
  }
  p_buf.put_c(c);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(TargetCellOutsideGCA__Param_extensionContainer_descr_, p_buf);
  return 0;
}

int TargetCellOutsideGCA__Param::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  if (uc[0] & 64)
    field_extensionContainer.OER_decode(TargetCellOutsideGCA__Param_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void TargetCellOutsideGCA__Param::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(TargetCellOutsideGCA__Param_extensionContainer_descr_, p_buf, p_options);
}

void TargetCellOutsideGCA__Param::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
if (field_extensionContainer_present) field_extensionContainer.PER_decode(TargetCellOutsideGCA__Param_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct TargetCellOutsideGCA__Param_template::single_value_struct {
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
};

void TargetCellOutsideGCA__Param_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_extensionContainer = ANY_OR_OMIT;
}
}
}

void TargetCellOutsideGCA__Param_template::copy_value(const TargetCellOutsideGCA__Param& other_value)
{
single_value = new single_value_struct;
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void TargetCellOutsideGCA__Param_template::copy_template(const TargetCellOutsideGCA__Param_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new TargetCellOutsideGCA__Param_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new TargetCellOutsideGCA__Param_template(*other_value.implication_.precondition);
implication_.implied_template = new TargetCellOutsideGCA__Param_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param.");
break;
}
set_selection(other_value);
}

TargetCellOutsideGCA__Param_template::TargetCellOutsideGCA__Param_template()
{
}

TargetCellOutsideGCA__Param_template::TargetCellOutsideGCA__Param_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

TargetCellOutsideGCA__Param_template::TargetCellOutsideGCA__Param_template(const TargetCellOutsideGCA__Param& other_value)
{
copy_value(other_value);
}

TargetCellOutsideGCA__Param_template::TargetCellOutsideGCA__Param_template(const OPTIONAL<TargetCellOutsideGCA__Param>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const TargetCellOutsideGCA__Param&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param from an unbound optional field.");
}
}

TargetCellOutsideGCA__Param_template::TargetCellOutsideGCA__Param_template(TargetCellOutsideGCA__Param_template* p_precondition, TargetCellOutsideGCA__Param_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

TargetCellOutsideGCA__Param_template::TargetCellOutsideGCA__Param_template(Dynamic_Match_Interface<TargetCellOutsideGCA__Param>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<TargetCellOutsideGCA__Param>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

TargetCellOutsideGCA__Param_template::TargetCellOutsideGCA__Param_template(const TargetCellOutsideGCA__Param_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

TargetCellOutsideGCA__Param_template::~TargetCellOutsideGCA__Param_template()
{
clean_up();
}

TargetCellOutsideGCA__Param_template& TargetCellOutsideGCA__Param_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

TargetCellOutsideGCA__Param_template& TargetCellOutsideGCA__Param_template::operator=(const TargetCellOutsideGCA__Param& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

TargetCellOutsideGCA__Param_template& TargetCellOutsideGCA__Param_template::operator=(const OPTIONAL<TargetCellOutsideGCA__Param>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const TargetCellOutsideGCA__Param&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param.");
}
return *this;
}

TargetCellOutsideGCA__Param_template& TargetCellOutsideGCA__Param_template::operator=(const TargetCellOutsideGCA__Param_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean TargetCellOutsideGCA__Param_template::match(const TargetCellOutsideGCA__Param& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param.");
}
return FALSE;
}

boolean TargetCellOutsideGCA__Param_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound());
}

boolean TargetCellOutsideGCA__Param_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value());
}

void TargetCellOutsideGCA__Param_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

TargetCellOutsideGCA__Param TargetCellOutsideGCA__Param_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param.");
TargetCellOutsideGCA__Param ret_val;
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
return ret_val;
}

void TargetCellOutsideGCA__Param_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new TargetCellOutsideGCA__Param_template[list_length];
}

TargetCellOutsideGCA__Param_template& TargetCellOutsideGCA__Param_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param.");
return value_list.list_value[list_index];
}

MAP__ExtensionDataTypes::ExtensionContainer_template& TargetCellOutsideGCA__Param_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& TargetCellOutsideGCA__Param_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param.");
return single_value->field_extensionContainer;
}

int TargetCellOutsideGCA__Param_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 0;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param.");
  }
  return 0;
}

void TargetCellOutsideGCA__Param_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void TargetCellOutsideGCA__Param_template::log_match(const TargetCellOutsideGCA__Param& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void TargetCellOutsideGCA__Param_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void TargetCellOutsideGCA__Param_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_extensionContainer.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param.");
}
}

void TargetCellOutsideGCA__Param_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_extensionContainer.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new TargetCellOutsideGCA__Param_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param.");
}
}

void TargetCellOutsideGCA__Param_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    TargetCellOutsideGCA__Param_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-ER-DataTypes.TargetCellOutsideGCA-Param: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    TargetCellOutsideGCA__Param_template* precondition = new TargetCellOutsideGCA__Param_template;
    precondition->set_param(*param.get_elem(0));
    TargetCellOutsideGCA__Param_template* implied_template = new TargetCellOutsideGCA__Param_template;
    implied_template->set_param(*param.get_elem(1));
    *this = TargetCellOutsideGCA__Param_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-ER-DataTypes.TargetCellOutsideGCA-Param");
  }
  is_ifpresent = param.get_ifpresent();
}

void TargetCellOutsideGCA__Param_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-ER-DataTypes.TargetCellOutsideGCA-Param");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-ER-DataTypes.TargetCellOutsideGCA-Param");
}

boolean TargetCellOutsideGCA__Param_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean TargetCellOutsideGCA__Param_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

OngoingGroupCallParam::OngoingGroupCallParam()
{
}

OngoingGroupCallParam::OngoingGroupCallParam(const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer)
  :   field_extensionContainer(par_extensionContainer)
{
}

OngoingGroupCallParam::OngoingGroupCallParam(const OngoingGroupCallParam& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-ER-DataTypes.OngoingGroupCallParam.");
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
}

void OngoingGroupCallParam::clean_up()
{
field_extensionContainer.clean_up();
}

const TTCN_Typedescriptor_t* OngoingGroupCallParam::get_descriptor() const { return &OngoingGroupCallParam_descr_; }
OngoingGroupCallParam& OngoingGroupCallParam::operator=(const OngoingGroupCallParam& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-ER-DataTypes.OngoingGroupCallParam.");
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
}
return *this;
}

boolean OngoingGroupCallParam::operator==(const OngoingGroupCallParam& other_value) const
{
return field_extensionContainer==other_value.field_extensionContainer;
}

boolean OngoingGroupCallParam::is_bound() const
{
return (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound());
}
boolean OngoingGroupCallParam::is_value() const
{
return (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value());
}
int OngoingGroupCallParam::size_of() const
{
  int ret_val = 0;
  if (field_extensionContainer.ispresent()) ret_val++;
  return ret_val;
}

void OngoingGroupCallParam::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
}

void OngoingGroupCallParam::set_implicit_omit()
{
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void OngoingGroupCallParam::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @MAP-ER-DataTypes.OngoingGroupCallParam has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-ER-DataTypes.OngoingGroupCallParam: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-ER-DataTypes.OngoingGroupCallParam");
  }
}

void OngoingGroupCallParam::encode_text(Text_Buf& text_buf) const
{
field_extensionContainer.encode_text(text_buf);
}

void OngoingGroupCallParam::decode_text(Text_Buf& text_buf)
{
field_extensionContainer.decode_text(text_buf);
}

void OngoingGroupCallParam::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void OngoingGroupCallParam::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* OngoingGroupCallParam::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(OngoingGroupCallParam_extensionContainer_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean OngoingGroupCallParam::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-ER-DataTypes.OngoingGroupCallParam' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(OngoingGroupCallParam_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int OngoingGroupCallParam::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-ER-DataTypes.OngoingGroupCallParam.");
    return -1;
  }

  if (p_td.json->as_value) {
   if (field_extensionContainer == OMIT_VALUE) {
     return p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL) + 
       p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
   }
   return field_extensionContainer.JSON_encode(OngoingGroupCallParam_extensionContainer_descr_, p_tok, FALSE);
  }
  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(OngoingGroupCallParam_extensionContainer_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int OngoingGroupCallParam::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const OngoingGroupCallParam*>(p_td.json->default_value.val);
    return 0;
  }
  if (p_td.json->as_value) {
   json_token_t j_token = JSON_TOKEN_NONE;
   size_t buf_pos = p_tok.get_buf_pos();
   size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
   if (j_token == JSON_TOKEN_LITERAL_NULL) {
     return JSON_ERROR_FATAL;
   }
   else if (j_token == JSON_TOKEN_OBJECT_START) {
     dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
     if (j_token == JSON_TOKEN_OBJECT_END) {
       field_extensionContainer = OMIT_VALUE;
       return dec_len;
     }
   }
   p_tok.set_buf_pos(buf_pos);
   return field_extensionContainer.JSON_decode(OngoingGroupCallParam_extensionContainer_descr_, p_tok, p_silent, FALSE);
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean extensionContainer_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(OngoingGroupCallParam_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int OngoingGroupCallParam::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_extensionContainer.is_present()) {
    c |= 64;
  }
  p_buf.put_c(c);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(OngoingGroupCallParam_extensionContainer_descr_, p_buf);
  return 0;
}

int OngoingGroupCallParam::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  if (uc[0] & 64)
    field_extensionContainer.OER_decode(OngoingGroupCallParam_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void OngoingGroupCallParam::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(OngoingGroupCallParam_extensionContainer_descr_, p_buf, p_options);
}

void OngoingGroupCallParam::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
if (field_extensionContainer_present) field_extensionContainer.PER_decode(OngoingGroupCallParam_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct OngoingGroupCallParam_template::single_value_struct {
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
};

void OngoingGroupCallParam_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_extensionContainer = ANY_OR_OMIT;
}
}
}

void OngoingGroupCallParam_template::copy_value(const OngoingGroupCallParam& other_value)
{
single_value = new single_value_struct;
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void OngoingGroupCallParam_template::copy_template(const OngoingGroupCallParam_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new OngoingGroupCallParam_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new OngoingGroupCallParam_template(*other_value.implication_.precondition);
implication_.implied_template = new OngoingGroupCallParam_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-ER-DataTypes.OngoingGroupCallParam.");
break;
}
set_selection(other_value);
}

OngoingGroupCallParam_template::OngoingGroupCallParam_template()
{
}

OngoingGroupCallParam_template::OngoingGroupCallParam_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

OngoingGroupCallParam_template::OngoingGroupCallParam_template(const OngoingGroupCallParam& other_value)
{
copy_value(other_value);
}

OngoingGroupCallParam_template::OngoingGroupCallParam_template(const OPTIONAL<OngoingGroupCallParam>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const OngoingGroupCallParam&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-ER-DataTypes.OngoingGroupCallParam from an unbound optional field.");
}
}

OngoingGroupCallParam_template::OngoingGroupCallParam_template(OngoingGroupCallParam_template* p_precondition, OngoingGroupCallParam_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

OngoingGroupCallParam_template::OngoingGroupCallParam_template(Dynamic_Match_Interface<OngoingGroupCallParam>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<OngoingGroupCallParam>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

OngoingGroupCallParam_template::OngoingGroupCallParam_template(const OngoingGroupCallParam_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

OngoingGroupCallParam_template::~OngoingGroupCallParam_template()
{
clean_up();
}

OngoingGroupCallParam_template& OngoingGroupCallParam_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

OngoingGroupCallParam_template& OngoingGroupCallParam_template::operator=(const OngoingGroupCallParam& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

OngoingGroupCallParam_template& OngoingGroupCallParam_template::operator=(const OPTIONAL<OngoingGroupCallParam>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const OngoingGroupCallParam&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-ER-DataTypes.OngoingGroupCallParam.");
}
return *this;
}

OngoingGroupCallParam_template& OngoingGroupCallParam_template::operator=(const OngoingGroupCallParam_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean OngoingGroupCallParam_template::match(const OngoingGroupCallParam& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-ER-DataTypes.OngoingGroupCallParam.");
}
return FALSE;
}

boolean OngoingGroupCallParam_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound());
}

boolean OngoingGroupCallParam_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value());
}

void OngoingGroupCallParam_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

OngoingGroupCallParam OngoingGroupCallParam_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-ER-DataTypes.OngoingGroupCallParam.");
OngoingGroupCallParam ret_val;
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
return ret_val;
}

void OngoingGroupCallParam_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-ER-DataTypes.OngoingGroupCallParam.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new OngoingGroupCallParam_template[list_length];
}

OngoingGroupCallParam_template& OngoingGroupCallParam_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-ER-DataTypes.OngoingGroupCallParam.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-ER-DataTypes.OngoingGroupCallParam.");
return value_list.list_value[list_index];
}

MAP__ExtensionDataTypes::ExtensionContainer_template& OngoingGroupCallParam_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& OngoingGroupCallParam_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-ER-DataTypes.OngoingGroupCallParam.");
return single_value->field_extensionContainer;
}

int OngoingGroupCallParam_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.OngoingGroupCallParam which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 0;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-ER-DataTypes.OngoingGroupCallParam containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.OngoingGroupCallParam containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.OngoingGroupCallParam containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.OngoingGroupCallParam containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.OngoingGroupCallParam containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.OngoingGroupCallParam containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.OngoingGroupCallParam containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-ER-DataTypes.OngoingGroupCallParam containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-ER-DataTypes.OngoingGroupCallParam.");
  }
  return 0;
}

void OngoingGroupCallParam_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void OngoingGroupCallParam_template::log_match(const OngoingGroupCallParam& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void OngoingGroupCallParam_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void OngoingGroupCallParam_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_extensionContainer.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-ER-DataTypes.OngoingGroupCallParam.");
}
}

void OngoingGroupCallParam_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_extensionContainer.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new OngoingGroupCallParam_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-ER-DataTypes.OngoingGroupCallParam.");
}
}

void OngoingGroupCallParam_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    OngoingGroupCallParam_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @MAP-ER-DataTypes.OngoingGroupCallParam has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-ER-DataTypes.OngoingGroupCallParam: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    OngoingGroupCallParam_template* precondition = new OngoingGroupCallParam_template;
    precondition->set_param(*param.get_elem(0));
    OngoingGroupCallParam_template* implied_template = new OngoingGroupCallParam_template;
    implied_template->set_param(*param.get_elem(1));
    *this = OngoingGroupCallParam_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-ER-DataTypes.OngoingGroupCallParam");
  }
  is_ifpresent = param.get_ifpresent();
}

void OngoingGroupCallParam_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-ER-DataTypes.OngoingGroupCallParam");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-ER-DataTypes.OngoingGroupCallParam");
}

boolean OngoingGroupCallParam_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean OngoingGroupCallParam_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}


/* Bodies of functions, altsteps and testcases */

void RoamingNotAllowedCause_encoder(const RoamingNotAllowedCause& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.RoamingNotAllowedCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RoamingNotAllowedCause_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RoamingNotAllowedCause_decoder(OCTETSTRING& input_stream, RoamingNotAllowedCause& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.RoamingNotAllowedCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RoamingNotAllowedCause_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RoamingNotAllowedParam_roamingNotAllowedCause_encoder(const RoamingNotAllowedCause& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.RoamingNotAllowedCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RoamingNotAllowedCause_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RoamingNotAllowedParam_roamingNotAllowedCause_decoder(OCTETSTRING& input_stream, RoamingNotAllowedCause& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.RoamingNotAllowedCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RoamingNotAllowedCause_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RoamingNotAllowedParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RoamingNotAllowedParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RoamingNotAllowedParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RoamingNotAllowedParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void AdditionalRoamingNotAllowedCause_encoder(const AdditionalRoamingNotAllowedCause& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.AdditionalRoamingNotAllowedCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(AdditionalRoamingNotAllowedCause_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER AdditionalRoamingNotAllowedCause_decoder(OCTETSTRING& input_stream, AdditionalRoamingNotAllowedCause& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.AdditionalRoamingNotAllowedCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(AdditionalRoamingNotAllowedCause_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RoamingNotAllowedParam_additionalRoamingNotAllowedCause_encoder(const AdditionalRoamingNotAllowedCause& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.AdditionalRoamingNotAllowedCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RoamingNotAllowedParam_additionalRoamingNotAllowedCause_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RoamingNotAllowedParam_additionalRoamingNotAllowedCause_decoder(OCTETSTRING& input_stream, AdditionalRoamingNotAllowedCause& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.AdditionalRoamingNotAllowedCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RoamingNotAllowedParam_additionalRoamingNotAllowedCause_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void RoamingNotAllowedParam_encoder(const RoamingNotAllowedParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.RoamingNotAllowedParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(RoamingNotAllowedParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER RoamingNotAllowedParam_decoder(OCTETSTRING& input_stream, RoamingNotAllowedParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.RoamingNotAllowedParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(RoamingNotAllowedParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CallBarringCause_encoder(const CallBarringCause& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.CallBarringCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CallBarringCause_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CallBarringCause_decoder(OCTETSTRING& input_stream, CallBarringCause& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.CallBarringCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CallBarringCause_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CallBarredParam_callBarringCause_encoder(const CallBarringCause& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.CallBarringCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CallBarringCause_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CallBarredParam_callBarringCause_decoder(OCTETSTRING& input_stream, CallBarringCause& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.CallBarringCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CallBarringCause_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ExtensibleCallBarredParam_callBarringCause_encoder(const CallBarringCause& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.CallBarringCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CallBarringCause_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ExtensibleCallBarredParam_callBarringCause_decoder(OCTETSTRING& input_stream, CallBarringCause& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.CallBarringCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CallBarringCause_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ExtensibleCallBarredParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ExtensibleCallBarredParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ExtensibleCallBarredParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ExtensibleCallBarredParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ExtensibleCallBarredParam_unauthorisedMessageOriginator_encoder(const ASN_NULL& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `NULL' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ExtensibleCallBarredParam_unauthorisedMessageOriginator_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ExtensibleCallBarredParam_unauthorisedMessageOriginator_decoder(OCTETSTRING& input_stream, ASN_NULL& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `NULL' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ExtensibleCallBarredParam_unauthorisedMessageOriginator_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ExtensibleCallBarredParam_encoder(const ExtensibleCallBarredParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.ExtensibleCallBarredParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ExtensibleCallBarredParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ExtensibleCallBarredParam_decoder(OCTETSTRING& input_stream, ExtensibleCallBarredParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.ExtensibleCallBarredParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ExtensibleCallBarredParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CallBarredParam_extensibleCallBarredParam_encoder(const ExtensibleCallBarredParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.ExtensibleCallBarredParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CallBarredParam_extensibleCallBarredParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CallBarredParam_extensibleCallBarredParam_decoder(OCTETSTRING& input_stream, ExtensibleCallBarredParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.ExtensibleCallBarredParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CallBarredParam_extensibleCallBarredParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CallBarredParam_encoder(const CallBarredParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.CallBarredParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CallBarredParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CallBarredParam_decoder(OCTETSTRING& input_stream, CallBarredParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.CallBarredParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CallBarredParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CUG__RejectCause_encoder(const CUG__RejectCause& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.CUG-RejectCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CUG__RejectCause_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CUG__RejectCause_decoder(OCTETSTRING& input_stream, CUG__RejectCause& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.CUG-RejectCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CUG__RejectCause_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CUG__RejectParam_cug__RejectCause_encoder(const CUG__RejectCause& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.CUG-RejectCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CUG__RejectCause_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CUG__RejectParam_cug__RejectCause_decoder(OCTETSTRING& input_stream, CUG__RejectCause& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.CUG-RejectCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CUG__RejectCause_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CUG__RejectParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CUG__RejectParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CUG__RejectParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CUG__RejectParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void CUG__RejectParam_encoder(const CUG__RejectParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.CUG-RejectParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(CUG__RejectParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER CUG__RejectParam_decoder(OCTETSTRING& input_stream, CUG__RejectParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.CUG-RejectParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(CUG__RejectParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void SS__IncompatibilityCause_ss__Code_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(SS__IncompatibilityCause_ss__Code_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER SS__IncompatibilityCause_ss__Code_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(SS__IncompatibilityCause_ss__Code_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void SS__IncompatibilityCause_basicService_encoder(const MAP__CommonDataTypes::BasicServiceCode& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-CommonDataTypes.BasicServiceCode' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(MAP__CommonDataTypes::BasicServiceCode_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER SS__IncompatibilityCause_basicService_decoder(OCTETSTRING& input_stream, MAP__CommonDataTypes::BasicServiceCode& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-CommonDataTypes.BasicServiceCode' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(MAP__CommonDataTypes::BasicServiceCode_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void SS__IncompatibilityCause_ss__Status_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(SS__IncompatibilityCause_ss__Status_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER SS__IncompatibilityCause_ss__Status_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(SS__IncompatibilityCause_ss__Status_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void SS__IncompatibilityCause_encoder(const SS__IncompatibilityCause& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.SS-IncompatibilityCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(SS__IncompatibilityCause_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER SS__IncompatibilityCause_decoder(OCTETSTRING& input_stream, SS__IncompatibilityCause& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.SS-IncompatibilityCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(SS__IncompatibilityCause_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PW__RegistrationFailureCause_encoder(const PW__RegistrationFailureCause& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.PW-RegistrationFailureCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PW__RegistrationFailureCause_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PW__RegistrationFailureCause_decoder(OCTETSTRING& input_stream, PW__RegistrationFailureCause& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.PW-RegistrationFailureCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PW__RegistrationFailureCause_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void SM__EnumeratedDeliveryFailureCause_encoder(const SM__EnumeratedDeliveryFailureCause& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.SM-EnumeratedDeliveryFailureCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(SM__EnumeratedDeliveryFailureCause_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER SM__EnumeratedDeliveryFailureCause_decoder(OCTETSTRING& input_stream, SM__EnumeratedDeliveryFailureCause& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.SM-EnumeratedDeliveryFailureCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(SM__EnumeratedDeliveryFailureCause_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void SM__DeliveryFailureCause_sm__EnumeratedDeliveryFailureCause_encoder(const SM__EnumeratedDeliveryFailureCause& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.SM-EnumeratedDeliveryFailureCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(SM__EnumeratedDeliveryFailureCause_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER SM__DeliveryFailureCause_sm__EnumeratedDeliveryFailureCause_decoder(OCTETSTRING& input_stream, SM__EnumeratedDeliveryFailureCause& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.SM-EnumeratedDeliveryFailureCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(SM__EnumeratedDeliveryFailureCause_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void SM__DeliveryFailureCause_diagnosticInfo_encoder(const OCTETSTRING& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(MAP__CommonDataTypes::SignalInfo_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER SM__DeliveryFailureCause_diagnosticInfo_decoder(OCTETSTRING& input_stream, OCTETSTRING& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `octetstring' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(MAP__CommonDataTypes::SignalInfo_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void SM__DeliveryFailureCause_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(SM__DeliveryFailureCause_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER SM__DeliveryFailureCause_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(SM__DeliveryFailureCause_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void SM__DeliveryFailureCause_encoder(const SM__DeliveryFailureCause& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.SM-DeliveryFailureCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(SM__DeliveryFailureCause_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER SM__DeliveryFailureCause_decoder(OCTETSTRING& input_stream, SM__DeliveryFailureCause& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.SM-DeliveryFailureCause' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(SM__DeliveryFailureCause_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void AbsentSubscriberDiagnosticSM_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(AbsentSubscriberDiagnosticSM_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER AbsentSubscriberDiagnosticSM_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(AbsentSubscriberDiagnosticSM_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void AbsentSubscriberSM__Param_absentSubscriberDiagnosticSM_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(AbsentSubscriberSM__Param_absentSubscriberDiagnosticSM_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER AbsentSubscriberSM__Param_absentSubscriberDiagnosticSM_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(AbsentSubscriberSM__Param_absentSubscriberDiagnosticSM_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void AbsentSubscriberSM__Param_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(AbsentSubscriberSM__Param_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER AbsentSubscriberSM__Param_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(AbsentSubscriberSM__Param_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void AbsentSubscriberSM__Param_additionalAbsentSubscriberDiagnosticSM_encoder(const INTEGER& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(AbsentSubscriberSM__Param_additionalAbsentSubscriberDiagnosticSM_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER AbsentSubscriberSM__Param_additionalAbsentSubscriberDiagnosticSM_decoder(OCTETSTRING& input_stream, INTEGER& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `integer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(AbsentSubscriberSM__Param_additionalAbsentSubscriberDiagnosticSM_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void AbsentSubscriberSM__Param_encoder(const AbsentSubscriberSM__Param& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.AbsentSubscriberSM-Param' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(AbsentSubscriberSM__Param_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER AbsentSubscriberSM__Param_decoder(OCTETSTRING& input_stream, AbsentSubscriberSM__Param& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.AbsentSubscriberSM-Param' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(AbsentSubscriberSM__Param_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void SystemFailureParam_networkResource_encoder(const MAP__CommonDataTypes::NetworkResource& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-CommonDataTypes.NetworkResource' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(MAP__CommonDataTypes::NetworkResource_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER SystemFailureParam_networkResource_decoder(OCTETSTRING& input_stream, MAP__CommonDataTypes::NetworkResource& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-CommonDataTypes.NetworkResource' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(MAP__CommonDataTypes::NetworkResource_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ExtensibleSystemFailureParam_networkResource_encoder(const MAP__CommonDataTypes::NetworkResource& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-CommonDataTypes.NetworkResource' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(MAP__CommonDataTypes::NetworkResource_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ExtensibleSystemFailureParam_networkResource_decoder(OCTETSTRING& input_stream, MAP__CommonDataTypes::NetworkResource& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-CommonDataTypes.NetworkResource' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(MAP__CommonDataTypes::NetworkResource_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ExtensibleSystemFailureParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ExtensibleSystemFailureParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ExtensibleSystemFailureParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ExtensibleSystemFailureParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ExtensibleSystemFailureParam_additionalNetworkResource_encoder(const MAP__CommonDataTypes::AdditionalNetworkResource& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-CommonDataTypes.AdditionalNetworkResource' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ExtensibleSystemFailureParam_additionalNetworkResource_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ExtensibleSystemFailureParam_additionalNetworkResource_decoder(OCTETSTRING& input_stream, MAP__CommonDataTypes::AdditionalNetworkResource& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-CommonDataTypes.AdditionalNetworkResource' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ExtensibleSystemFailureParam_additionalNetworkResource_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void FailureCauseParam_encoder(const FailureCauseParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.FailureCauseParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(FailureCauseParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER FailureCauseParam_decoder(OCTETSTRING& input_stream, FailureCauseParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.FailureCauseParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(FailureCauseParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ExtensibleSystemFailureParam_failureCauseParam_encoder(const FailureCauseParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.FailureCauseParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ExtensibleSystemFailureParam_failureCauseParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ExtensibleSystemFailureParam_failureCauseParam_decoder(OCTETSTRING& input_stream, FailureCauseParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.FailureCauseParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ExtensibleSystemFailureParam_failureCauseParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ExtensibleSystemFailureParam_encoder(const ExtensibleSystemFailureParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.ExtensibleSystemFailureParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ExtensibleSystemFailureParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ExtensibleSystemFailureParam_decoder(OCTETSTRING& input_stream, ExtensibleSystemFailureParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.ExtensibleSystemFailureParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ExtensibleSystemFailureParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void SystemFailureParam_extensibleSystemFailureParam_encoder(const ExtensibleSystemFailureParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.ExtensibleSystemFailureParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(SystemFailureParam_extensibleSystemFailureParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER SystemFailureParam_extensibleSystemFailureParam_decoder(OCTETSTRING& input_stream, ExtensibleSystemFailureParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.ExtensibleSystemFailureParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(SystemFailureParam_extensibleSystemFailureParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void SystemFailureParam_encoder(const SystemFailureParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.SystemFailureParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(SystemFailureParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER SystemFailureParam_decoder(OCTETSTRING& input_stream, SystemFailureParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.SystemFailureParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(SystemFailureParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void DataMissingParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(DataMissingParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER DataMissingParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(DataMissingParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void DataMissingParam_encoder(const DataMissingParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.DataMissingParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(DataMissingParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER DataMissingParam_decoder(OCTETSTRING& input_stream, DataMissingParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.DataMissingParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(DataMissingParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void UnexpectedDataParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(UnexpectedDataParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER UnexpectedDataParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(UnexpectedDataParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void UnexpectedDataParam_unexpectedSubscriber_encoder(const ASN_NULL& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `NULL' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(UnexpectedDataParam_unexpectedSubscriber_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER UnexpectedDataParam_unexpectedSubscriber_decoder(OCTETSTRING& input_stream, ASN_NULL& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `NULL' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(UnexpectedDataParam_unexpectedSubscriber_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void UnexpectedDataParam_encoder(const UnexpectedDataParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.UnexpectedDataParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(UnexpectedDataParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER UnexpectedDataParam_decoder(OCTETSTRING& input_stream, UnexpectedDataParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.UnexpectedDataParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(UnexpectedDataParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void FacilityNotSupParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(FacilityNotSupParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER FacilityNotSupParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(FacilityNotSupParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void FacilityNotSupParam_shapeOfLocationEstimateNotSupported_encoder(const ASN_NULL& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `NULL' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(FacilityNotSupParam_shapeOfLocationEstimateNotSupported_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER FacilityNotSupParam_shapeOfLocationEstimateNotSupported_decoder(OCTETSTRING& input_stream, ASN_NULL& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `NULL' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(FacilityNotSupParam_shapeOfLocationEstimateNotSupported_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void FacilityNotSupParam_neededLcsCapabilityNotSupportedInServingNode_encoder(const ASN_NULL& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `NULL' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(FacilityNotSupParam_neededLcsCapabilityNotSupportedInServingNode_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER FacilityNotSupParam_neededLcsCapabilityNotSupportedInServingNode_decoder(OCTETSTRING& input_stream, ASN_NULL& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `NULL' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(FacilityNotSupParam_neededLcsCapabilityNotSupportedInServingNode_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void FacilityNotSupParam_encoder(const FacilityNotSupParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.FacilityNotSupParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(FacilityNotSupParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER FacilityNotSupParam_decoder(OCTETSTRING& input_stream, FacilityNotSupParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.FacilityNotSupParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(FacilityNotSupParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void OR__NotAllowedParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(OR__NotAllowedParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER OR__NotAllowedParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(OR__NotAllowedParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void OR__NotAllowedParam_encoder(const OR__NotAllowedParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.OR-NotAllowedParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(OR__NotAllowedParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER OR__NotAllowedParam_decoder(OCTETSTRING& input_stream, OR__NotAllowedParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.OR-NotAllowedParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(OR__NotAllowedParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void UnknownSubscriberParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(UnknownSubscriberParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER UnknownSubscriberParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(UnknownSubscriberParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void UnknownSubscriberDiagnostic_encoder(const UnknownSubscriberDiagnostic& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.UnknownSubscriberDiagnostic' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(UnknownSubscriberDiagnostic_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER UnknownSubscriberDiagnostic_decoder(OCTETSTRING& input_stream, UnknownSubscriberDiagnostic& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.UnknownSubscriberDiagnostic' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(UnknownSubscriberDiagnostic_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void UnknownSubscriberParam_unknownSubscriberDiagnostic_encoder(const UnknownSubscriberDiagnostic& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.UnknownSubscriberDiagnostic' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(UnknownSubscriberDiagnostic_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER UnknownSubscriberParam_unknownSubscriberDiagnostic_decoder(OCTETSTRING& input_stream, UnknownSubscriberDiagnostic& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.UnknownSubscriberDiagnostic' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(UnknownSubscriberDiagnostic_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void UnknownSubscriberParam_encoder(const UnknownSubscriberParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.UnknownSubscriberParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(UnknownSubscriberParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER UnknownSubscriberParam_decoder(OCTETSTRING& input_stream, UnknownSubscriberParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.UnknownSubscriberParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(UnknownSubscriberParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void NumberChangedParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(NumberChangedParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER NumberChangedParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(NumberChangedParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void NumberChangedParam_encoder(const NumberChangedParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.NumberChangedParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(NumberChangedParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER NumberChangedParam_decoder(OCTETSTRING& input_stream, NumberChangedParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.NumberChangedParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(NumberChangedParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void UnidentifiedSubParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(UnidentifiedSubParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER UnidentifiedSubParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(UnidentifiedSubParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void UnidentifiedSubParam_encoder(const UnidentifiedSubParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.UnidentifiedSubParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(UnidentifiedSubParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER UnidentifiedSubParam_decoder(OCTETSTRING& input_stream, UnidentifiedSubParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.UnidentifiedSubParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(UnidentifiedSubParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void IllegalSubscriberParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(IllegalSubscriberParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER IllegalSubscriberParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(IllegalSubscriberParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void IllegalSubscriberParam_encoder(const IllegalSubscriberParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.IllegalSubscriberParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(IllegalSubscriberParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER IllegalSubscriberParam_decoder(OCTETSTRING& input_stream, IllegalSubscriberParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.IllegalSubscriberParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(IllegalSubscriberParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void IllegalEquipmentParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(IllegalEquipmentParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER IllegalEquipmentParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(IllegalEquipmentParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void IllegalEquipmentParam_encoder(const IllegalEquipmentParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.IllegalEquipmentParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(IllegalEquipmentParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER IllegalEquipmentParam_decoder(OCTETSTRING& input_stream, IllegalEquipmentParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.IllegalEquipmentParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(IllegalEquipmentParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void BearerServNotProvParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BearerServNotProvParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER BearerServNotProvParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BearerServNotProvParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void BearerServNotProvParam_encoder(const BearerServNotProvParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.BearerServNotProvParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BearerServNotProvParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER BearerServNotProvParam_decoder(OCTETSTRING& input_stream, BearerServNotProvParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.BearerServNotProvParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BearerServNotProvParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void TeleservNotProvParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(TeleservNotProvParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER TeleservNotProvParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(TeleservNotProvParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void TeleservNotProvParam_encoder(const TeleservNotProvParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.TeleservNotProvParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(TeleservNotProvParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER TeleservNotProvParam_decoder(OCTETSTRING& input_stream, TeleservNotProvParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.TeleservNotProvParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(TeleservNotProvParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void TracingBufferFullParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(TracingBufferFullParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER TracingBufferFullParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(TracingBufferFullParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void TracingBufferFullParam_encoder(const TracingBufferFullParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.TracingBufferFullParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(TracingBufferFullParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER TracingBufferFullParam_decoder(OCTETSTRING& input_stream, TracingBufferFullParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.TracingBufferFullParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(TracingBufferFullParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void NoRoamingNbParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(NoRoamingNbParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER NoRoamingNbParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(NoRoamingNbParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void NoRoamingNbParam_encoder(const NoRoamingNbParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.NoRoamingNbParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(NoRoamingNbParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER NoRoamingNbParam_decoder(OCTETSTRING& input_stream, NoRoamingNbParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.NoRoamingNbParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(NoRoamingNbParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void AbsentSubscriberParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(AbsentSubscriberParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER AbsentSubscriberParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(AbsentSubscriberParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void AbsentSubscriberReason_encoder(const AbsentSubscriberReason& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.AbsentSubscriberReason' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(AbsentSubscriberReason_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER AbsentSubscriberReason_decoder(OCTETSTRING& input_stream, AbsentSubscriberReason& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.AbsentSubscriberReason' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(AbsentSubscriberReason_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void AbsentSubscriberParam_absentSubscriberReason_encoder(const AbsentSubscriberReason& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.AbsentSubscriberReason' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(AbsentSubscriberParam_absentSubscriberReason_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER AbsentSubscriberParam_absentSubscriberReason_decoder(OCTETSTRING& input_stream, AbsentSubscriberReason& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.AbsentSubscriberReason' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(AbsentSubscriberParam_absentSubscriberReason_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void AbsentSubscriberParam_encoder(const AbsentSubscriberParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.AbsentSubscriberParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(AbsentSubscriberParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER AbsentSubscriberParam_decoder(OCTETSTRING& input_stream, AbsentSubscriberParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.AbsentSubscriberParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(AbsentSubscriberParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void BusySubscriberParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BusySubscriberParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER BusySubscriberParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BusySubscriberParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void BusySubscriberParam_ccbs__Possible_encoder(const ASN_NULL& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `NULL' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BusySubscriberParam_ccbs__Possible_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER BusySubscriberParam_ccbs__Possible_decoder(OCTETSTRING& input_stream, ASN_NULL& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `NULL' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BusySubscriberParam_ccbs__Possible_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void BusySubscriberParam_ccbs__Busy_encoder(const ASN_NULL& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `NULL' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BusySubscriberParam_ccbs__Busy_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER BusySubscriberParam_ccbs__Busy_decoder(OCTETSTRING& input_stream, ASN_NULL& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `NULL' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BusySubscriberParam_ccbs__Busy_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void BusySubscriberParam_encoder(const BusySubscriberParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.BusySubscriberParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(BusySubscriberParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER BusySubscriberParam_decoder(OCTETSTRING& input_stream, BusySubscriberParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.BusySubscriberParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(BusySubscriberParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void NoSubscriberReplyParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(NoSubscriberReplyParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER NoSubscriberReplyParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(NoSubscriberReplyParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void NoSubscriberReplyParam_encoder(const NoSubscriberReplyParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.NoSubscriberReplyParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(NoSubscriberReplyParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER NoSubscriberReplyParam_decoder(OCTETSTRING& input_stream, NoSubscriberReplyParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.NoSubscriberReplyParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(NoSubscriberReplyParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ForwardingViolationParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ForwardingViolationParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ForwardingViolationParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ForwardingViolationParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ForwardingViolationParam_encoder(const ForwardingViolationParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.ForwardingViolationParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ForwardingViolationParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ForwardingViolationParam_decoder(OCTETSTRING& input_stream, ForwardingViolationParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.ForwardingViolationParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ForwardingViolationParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ForwardingFailedParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ForwardingFailedParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ForwardingFailedParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ForwardingFailedParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ForwardingFailedParam_encoder(const ForwardingFailedParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.ForwardingFailedParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ForwardingFailedParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ForwardingFailedParam_decoder(OCTETSTRING& input_stream, ForwardingFailedParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.ForwardingFailedParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ForwardingFailedParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ATI__NotAllowedParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ATI__NotAllowedParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ATI__NotAllowedParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ATI__NotAllowedParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ATI__NotAllowedParam_encoder(const ATI__NotAllowedParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.ATI-NotAllowedParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ATI__NotAllowedParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ATI__NotAllowedParam_decoder(OCTETSTRING& input_stream, ATI__NotAllowedParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.ATI-NotAllowedParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ATI__NotAllowedParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ATSI__NotAllowedParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ATSI__NotAllowedParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ATSI__NotAllowedParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ATSI__NotAllowedParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ATSI__NotAllowedParam_encoder(const ATSI__NotAllowedParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.ATSI-NotAllowedParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ATSI__NotAllowedParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ATSI__NotAllowedParam_decoder(OCTETSTRING& input_stream, ATSI__NotAllowedParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.ATSI-NotAllowedParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ATSI__NotAllowedParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ATM__NotAllowedParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ATM__NotAllowedParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ATM__NotAllowedParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ATM__NotAllowedParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ATM__NotAllowedParam_encoder(const ATM__NotAllowedParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.ATM-NotAllowedParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ATM__NotAllowedParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ATM__NotAllowedParam_decoder(OCTETSTRING& input_stream, ATM__NotAllowedParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.ATM-NotAllowedParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ATM__NotAllowedParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void IllegalSS__OperationParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(IllegalSS__OperationParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER IllegalSS__OperationParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(IllegalSS__OperationParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void IllegalSS__OperationParam_encoder(const IllegalSS__OperationParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.IllegalSS-OperationParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(IllegalSS__OperationParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER IllegalSS__OperationParam_decoder(OCTETSTRING& input_stream, IllegalSS__OperationParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.IllegalSS-OperationParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(IllegalSS__OperationParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void SS__NotAvailableParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(SS__NotAvailableParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER SS__NotAvailableParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(SS__NotAvailableParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void SS__NotAvailableParam_encoder(const SS__NotAvailableParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.SS-NotAvailableParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(SS__NotAvailableParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER SS__NotAvailableParam_decoder(OCTETSTRING& input_stream, SS__NotAvailableParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.SS-NotAvailableParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(SS__NotAvailableParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void SS__SubscriptionViolationParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(SS__SubscriptionViolationParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER SS__SubscriptionViolationParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(SS__SubscriptionViolationParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void SS__SubscriptionViolationParam_encoder(const SS__SubscriptionViolationParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.SS-SubscriptionViolationParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(SS__SubscriptionViolationParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER SS__SubscriptionViolationParam_decoder(OCTETSTRING& input_stream, SS__SubscriptionViolationParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.SS-SubscriptionViolationParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(SS__SubscriptionViolationParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void InformationNotAvailableParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(InformationNotAvailableParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER InformationNotAvailableParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(InformationNotAvailableParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void InformationNotAvailableParam_encoder(const InformationNotAvailableParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.InformationNotAvailableParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(InformationNotAvailableParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER InformationNotAvailableParam_decoder(OCTETSTRING& input_stream, InformationNotAvailableParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.InformationNotAvailableParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(InformationNotAvailableParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void SubBusyForMT__SMS__Param_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(SubBusyForMT__SMS__Param_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER SubBusyForMT__SMS__Param_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(SubBusyForMT__SMS__Param_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void SubBusyForMT__SMS__Param_gprsConnectionSuspended_encoder(const ASN_NULL& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `NULL' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ASN_NULL_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER SubBusyForMT__SMS__Param_gprsConnectionSuspended_decoder(OCTETSTRING& input_stream, ASN_NULL& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `NULL' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ASN_NULL_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void SubBusyForMT__SMS__Param_encoder(const SubBusyForMT__SMS__Param& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.SubBusyForMT-SMS-Param' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(SubBusyForMT__SMS__Param_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER SubBusyForMT__SMS__Param_decoder(OCTETSTRING& input_stream, SubBusyForMT__SMS__Param& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.SubBusyForMT-SMS-Param' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(SubBusyForMT__SMS__Param_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void MessageWaitListFullParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(MessageWaitListFullParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER MessageWaitListFullParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(MessageWaitListFullParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void MessageWaitListFullParam_encoder(const MessageWaitListFullParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.MessageWaitListFullParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(MessageWaitListFullParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER MessageWaitListFullParam_decoder(OCTETSTRING& input_stream, MessageWaitListFullParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.MessageWaitListFullParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(MessageWaitListFullParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ResourceLimitationParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ResourceLimitationParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ResourceLimitationParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ResourceLimitationParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void ResourceLimitationParam_encoder(const ResourceLimitationParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.ResourceLimitationParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ResourceLimitationParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ResourceLimitationParam_decoder(OCTETSTRING& input_stream, ResourceLimitationParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.ResourceLimitationParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ResourceLimitationParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void NoGroupCallNbParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(NoGroupCallNbParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER NoGroupCallNbParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(NoGroupCallNbParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void NoGroupCallNbParam_encoder(const NoGroupCallNbParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.NoGroupCallNbParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(NoGroupCallNbParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER NoGroupCallNbParam_decoder(OCTETSTRING& input_stream, NoGroupCallNbParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.NoGroupCallNbParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(NoGroupCallNbParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void IncompatibleTerminalParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(IncompatibleTerminalParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER IncompatibleTerminalParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(IncompatibleTerminalParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void IncompatibleTerminalParam_encoder(const IncompatibleTerminalParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.IncompatibleTerminalParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(IncompatibleTerminalParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER IncompatibleTerminalParam_decoder(OCTETSTRING& input_stream, IncompatibleTerminalParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.IncompatibleTerminalParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(IncompatibleTerminalParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

boolean operator==(null_type, const ShortTermDenialParam& other_value)
{
other_value.must_bound("Comparison of an unbound value of type @MAP-ER-DataTypes.ShortTermDenialParam.");
return TRUE;
}

void ShortTermDenialParam_encoder(const ShortTermDenialParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.ShortTermDenialParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(ShortTermDenialParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER ShortTermDenialParam_decoder(OCTETSTRING& input_stream, ShortTermDenialParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.ShortTermDenialParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(ShortTermDenialParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

boolean operator==(null_type, const LongTermDenialParam& other_value)
{
other_value.must_bound("Comparison of an unbound value of type @MAP-ER-DataTypes.LongTermDenialParam.");
return TRUE;
}

void LongTermDenialParam_encoder(const LongTermDenialParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.LongTermDenialParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(LongTermDenialParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER LongTermDenialParam_decoder(OCTETSTRING& input_stream, LongTermDenialParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.LongTermDenialParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(LongTermDenialParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void UnauthorizedRequestingNetwork__Param_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(UnauthorizedRequestingNetwork__Param_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER UnauthorizedRequestingNetwork__Param_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(UnauthorizedRequestingNetwork__Param_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void UnauthorizedRequestingNetwork__Param_encoder(const UnauthorizedRequestingNetwork__Param& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.UnauthorizedRequestingNetwork-Param' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(UnauthorizedRequestingNetwork__Param_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER UnauthorizedRequestingNetwork__Param_decoder(OCTETSTRING& input_stream, UnauthorizedRequestingNetwork__Param& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.UnauthorizedRequestingNetwork-Param' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(UnauthorizedRequestingNetwork__Param_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void UnauthorizedLCSClient__Diagnostic_encoder(const UnauthorizedLCSClient__Diagnostic& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.UnauthorizedLCSClient-Diagnostic' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(UnauthorizedLCSClient__Diagnostic_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER UnauthorizedLCSClient__Diagnostic_decoder(OCTETSTRING& input_stream, UnauthorizedLCSClient__Diagnostic& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.UnauthorizedLCSClient-Diagnostic' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(UnauthorizedLCSClient__Diagnostic_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void UnauthorizedLCSClient__Param_unauthorizedLCSClient__Diagnostic_encoder(const UnauthorizedLCSClient__Diagnostic& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.UnauthorizedLCSClient-Diagnostic' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(UnauthorizedLCSClient__Param_unauthorizedLCSClient__Diagnostic_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER UnauthorizedLCSClient__Param_unauthorizedLCSClient__Diagnostic_decoder(OCTETSTRING& input_stream, UnauthorizedLCSClient__Diagnostic& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.UnauthorizedLCSClient-Diagnostic' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(UnauthorizedLCSClient__Param_unauthorizedLCSClient__Diagnostic_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void UnauthorizedLCSClient__Param_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(UnauthorizedLCSClient__Param_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER UnauthorizedLCSClient__Param_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(UnauthorizedLCSClient__Param_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void UnauthorizedLCSClient__Param_encoder(const UnauthorizedLCSClient__Param& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.UnauthorizedLCSClient-Param' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(UnauthorizedLCSClient__Param_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER UnauthorizedLCSClient__Param_decoder(OCTETSTRING& input_stream, UnauthorizedLCSClient__Param& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.UnauthorizedLCSClient-Param' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(UnauthorizedLCSClient__Param_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PositionMethodFailure__Diagnostic_encoder(const PositionMethodFailure__Diagnostic& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.PositionMethodFailure-Diagnostic' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PositionMethodFailure__Diagnostic_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PositionMethodFailure__Diagnostic_decoder(OCTETSTRING& input_stream, PositionMethodFailure__Diagnostic& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.PositionMethodFailure-Diagnostic' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PositionMethodFailure__Diagnostic_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PositionMethodFailure__Param_positionMethodFailure__Diagnostic_encoder(const PositionMethodFailure__Diagnostic& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.PositionMethodFailure-Diagnostic' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PositionMethodFailure__Param_positionMethodFailure__Diagnostic_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PositionMethodFailure__Param_positionMethodFailure__Diagnostic_decoder(OCTETSTRING& input_stream, PositionMethodFailure__Diagnostic& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.PositionMethodFailure-Diagnostic' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PositionMethodFailure__Param_positionMethodFailure__Diagnostic_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PositionMethodFailure__Param_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PositionMethodFailure__Param_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PositionMethodFailure__Param_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PositionMethodFailure__Param_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void PositionMethodFailure__Param_encoder(const PositionMethodFailure__Param& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.PositionMethodFailure-Param' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(PositionMethodFailure__Param_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER PositionMethodFailure__Param_decoder(OCTETSTRING& input_stream, PositionMethodFailure__Param& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.PositionMethodFailure-Param' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(PositionMethodFailure__Param_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void UnknownOrUnreachableLCSClient__Param_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(UnknownOrUnreachableLCSClient__Param_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER UnknownOrUnreachableLCSClient__Param_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(UnknownOrUnreachableLCSClient__Param_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void UnknownOrUnreachableLCSClient__Param_encoder(const UnknownOrUnreachableLCSClient__Param& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.UnknownOrUnreachableLCSClient-Param' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(UnknownOrUnreachableLCSClient__Param_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER UnknownOrUnreachableLCSClient__Param_decoder(OCTETSTRING& input_stream, UnknownOrUnreachableLCSClient__Param& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.UnknownOrUnreachableLCSClient-Param' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(UnknownOrUnreachableLCSClient__Param_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void MM__EventNotSupported__Param_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(MM__EventNotSupported__Param_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER MM__EventNotSupported__Param_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(MM__EventNotSupported__Param_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void MM__EventNotSupported__Param_encoder(const MM__EventNotSupported__Param& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.MM-EventNotSupported-Param' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(MM__EventNotSupported__Param_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER MM__EventNotSupported__Param_decoder(OCTETSTRING& input_stream, MM__EventNotSupported__Param& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.MM-EventNotSupported-Param' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(MM__EventNotSupported__Param_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void TargetCellOutsideGCA__Param_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(TargetCellOutsideGCA__Param_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER TargetCellOutsideGCA__Param_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(TargetCellOutsideGCA__Param_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void TargetCellOutsideGCA__Param_encoder(const TargetCellOutsideGCA__Param& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.TargetCellOutsideGCA-Param' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(TargetCellOutsideGCA__Param_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER TargetCellOutsideGCA__Param_decoder(OCTETSTRING& input_stream, TargetCellOutsideGCA__Param& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.TargetCellOutsideGCA-Param' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(TargetCellOutsideGCA__Param_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void OngoingGroupCallParam_extensionContainer_encoder(const MAP__ExtensionDataTypes::ExtensionContainer& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(OngoingGroupCallParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER OngoingGroupCallParam_extensionContainer_decoder(OCTETSTRING& input_stream, MAP__ExtensionDataTypes::ExtensionContainer& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ExtensionDataTypes.ExtensionContainer' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(OngoingGroupCallParam_extensionContainer_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}

void OngoingGroupCallParam_encoder(const OngoingGroupCallParam& input_value, OCTETSTRING& output_stream, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, TRUE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.OngoingGroupCallParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf;
input_value.encode(OngoingGroupCallParam_descr_, ttcn_buf, coding_type, extra_options);
ttcn_buf.get_string(output_stream);
}

INTEGER OngoingGroupCallParam_decoder(OCTETSTRING& input_stream, OngoingGroupCallParam& output_value, const UNIVERSAL_CHARSTRING& coding_name)
{
TTCN_EncDec::coding_t coding_type;
unsigned int extra_options = 0;
TTCN_EncDec::get_coding_from_str(coding_name, &coding_type, &extra_options, FALSE);
if (coding_type != TTCN_EncDec::CT_BER && coding_type != TTCN_EncDec::CT_PER && coding_type != TTCN_EncDec::CT_JSON && coding_type != TTCN_EncDec::CT_OER) {
TTCN_Logger::begin_event_log2str();
coding_name.log();
TTCN_error("Type `@MAP-ER-DataTypes.OngoingGroupCallParam' does not support %s encoding", (const char*) TTCN_Logger::end_event_log2str());
}
TTCN_Buffer ttcn_buf(input_stream);
output_value.decode(OngoingGroupCallParam_descr_, ttcn_buf, coding_type, extra_options);
switch (TTCN_EncDec::get_last_error_type()) {
case TTCN_EncDec::ET_NONE:
ttcn_buf.cut();
ttcn_buf.get_string(input_stream);
return 0;
case TTCN_EncDec::ET_INCOMPL_MSG:
case TTCN_EncDec::ET_LEN_ERR:
return 2;
default:
return 1;
}
}


/* Bodies of static functions */

void pre_init_module()
{
TTCN_Location current_location("MAP_ER_DataTypes.asn", 0, TTCN_Location::LOCATION_UNKNOWN, "MAP-ER-DataTypes");
MAP__SS__DataTypes::module_object.pre_init_module();
}


} /* end of namespace */
