// This C++ source file was generated by the TTCN-3 compiler
// of the TTCN-3 Test Executor version 11.1.0
// The generation of user and time information were disabled by the -D flag.

// Copyright (c) 2000-2025 Ericsson Telecom AB

// Do not edit this file unless you know what you are doing.

/* Including header files */

#include "MAP_MS_DataTypes.hh"

namespace MAP__MS__DataTypes {

/* Member functions of C++ classes */

AuthenticationQuintuplet::AuthenticationQuintuplet()
{
}

AuthenticationQuintuplet::AuthenticationQuintuplet(const OCTETSTRING& par_rand,
    const OCTETSTRING& par_xres,
    const OCTETSTRING& par_ck,
    const OCTETSTRING& par_ik,
    const OCTETSTRING& par_autn)
  :   field_rand(par_rand),
  field_xres(par_xres),
  field_ck(par_ck),
  field_ik(par_ik),
  field_autn(par_autn)
{
}

AuthenticationQuintuplet::AuthenticationQuintuplet(const AuthenticationQuintuplet& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.AuthenticationQuintuplet.");
if (other_value.rand().is_bound()) field_rand = other_value.rand();
else field_rand.clean_up();
if (other_value.xres().is_bound()) field_xres = other_value.xres();
else field_xres.clean_up();
if (other_value.ck().is_bound()) field_ck = other_value.ck();
else field_ck.clean_up();
if (other_value.ik().is_bound()) field_ik = other_value.ik();
else field_ik.clean_up();
if (other_value.autn().is_bound()) field_autn = other_value.autn();
else field_autn.clean_up();
}

void AuthenticationQuintuplet::clean_up()
{
field_rand.clean_up();
field_xres.clean_up();
field_ck.clean_up();
field_ik.clean_up();
field_autn.clean_up();
}

const TTCN_Typedescriptor_t* AuthenticationQuintuplet::get_descriptor() const { return &AuthenticationQuintuplet_descr_; }
AuthenticationQuintuplet& AuthenticationQuintuplet::operator=(const AuthenticationQuintuplet& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.AuthenticationQuintuplet.");
  if (other_value.rand().is_bound()) field_rand = other_value.rand();
  else field_rand.clean_up();
  if (other_value.xres().is_bound()) field_xres = other_value.xres();
  else field_xres.clean_up();
  if (other_value.ck().is_bound()) field_ck = other_value.ck();
  else field_ck.clean_up();
  if (other_value.ik().is_bound()) field_ik = other_value.ik();
  else field_ik.clean_up();
  if (other_value.autn().is_bound()) field_autn = other_value.autn();
  else field_autn.clean_up();
}
return *this;
}

boolean AuthenticationQuintuplet::operator==(const AuthenticationQuintuplet& other_value) const
{
return field_rand==other_value.field_rand
  && field_xres==other_value.field_xres
  && field_ck==other_value.field_ck
  && field_ik==other_value.field_ik
  && field_autn==other_value.field_autn;
}

boolean AuthenticationQuintuplet::is_bound() const
{
return (field_rand.is_bound())
  || (field_xres.is_bound())
  || (field_ck.is_bound())
  || (field_ik.is_bound())
  || (field_autn.is_bound());
}
boolean AuthenticationQuintuplet::is_value() const
{
return field_rand.is_value()
  && field_xres.is_value()
  && field_ck.is_value()
  && field_ik.is_value()
  && field_autn.is_value();
}
void AuthenticationQuintuplet::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ rand := ");
field_rand.log();
TTCN_Logger::log_event_str(", xres := ");
field_xres.log();
TTCN_Logger::log_event_str(", ck := ");
field_ck.log();
TTCN_Logger::log_event_str(", ik := ");
field_ik.log();
TTCN_Logger::log_event_str(", autn := ");
field_autn.log();
TTCN_Logger::log_event_str(" }");
}

void AuthenticationQuintuplet::set_implicit_omit()
{
if (rand().is_bound()) rand().set_implicit_omit();
if (xres().is_bound()) xres().set_implicit_omit();
if (ck().is_bound()) ck().set_implicit_omit();
if (ik().is_bound()) ik().set_implicit_omit();
if (autn().is_bound()) autn().set_implicit_omit();
}

void AuthenticationQuintuplet::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.AuthenticationQuintuplet has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) rand().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) xres().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) ck().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) ik().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) autn().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rand")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rand().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "xres")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          xres().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ck")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ck().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ik")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ik().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "autn")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          autn().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.AuthenticationQuintuplet: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.AuthenticationQuintuplet");
  }
}

void AuthenticationQuintuplet::encode_text(Text_Buf& text_buf) const
{
field_rand.encode_text(text_buf);
field_xres.encode_text(text_buf);
field_ck.encode_text(text_buf);
field_ik.encode_text(text_buf);
field_autn.encode_text(text_buf);
}

void AuthenticationQuintuplet::decode_text(Text_Buf& text_buf)
{
field_rand.decode_text(text_buf);
field_xres.decode_text(text_buf);
field_ck.decode_text(text_buf);
field_ik.decode_text(text_buf);
field_autn.decode_text(text_buf);
}

void AuthenticationQuintuplet::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void AuthenticationQuintuplet::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* AuthenticationQuintuplet::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("rand': ");
  new_tlv->add_TLV(field_rand.BER_encode_TLV(AuthenticationQuintuplet_rand_descr_, p_coding));
  ec_1.set_msg("xres': ");
  new_tlv->add_TLV(field_xres.BER_encode_TLV(XRES_descr_, p_coding));
  ec_1.set_msg("ck': ");
  new_tlv->add_TLV(field_ck.BER_encode_TLV(AuthenticationQuintuplet_ck_descr_, p_coding));
  ec_1.set_msg("ik': ");
  new_tlv->add_TLV(field_ik.BER_encode_TLV(AuthenticationQuintuplet_ik_descr_, p_coding));
  ec_1.set_msg("autn': ");
  new_tlv->add_TLV(field_autn.BER_encode_TLV(AuthenticationQuintuplet_autn_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean AuthenticationQuintuplet::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.AuthenticationQuintuplet' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("rand': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_rand.BER_decode_TLV(AuthenticationQuintuplet_rand_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("xres': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_xres.BER_decode_TLV(XRES_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("ck': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_ck.BER_decode_TLV(AuthenticationQuintuplet_ck_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("ik': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_ik.BER_decode_TLV(AuthenticationQuintuplet_ik_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("autn': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_autn.BER_decode_TLV(AuthenticationQuintuplet_autn_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int AuthenticationQuintuplet::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.AuthenticationQuintuplet.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "rand");
    enc_len += field_rand.JSON_encode(AuthenticationQuintuplet_rand_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "xres");
    enc_len += field_xres.JSON_encode(XRES_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ck");
    enc_len += field_ck.JSON_encode(AuthenticationQuintuplet_ck_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ik");
    enc_len += field_ik.JSON_encode(AuthenticationQuintuplet_ik_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "autn");
    enc_len += field_autn.JSON_encode(AuthenticationQuintuplet_autn_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int AuthenticationQuintuplet::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const AuthenticationQuintuplet*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean rand_found = FALSE;
  boolean xres_found = FALSE;
  boolean ck_found = FALSE;
  boolean ik_found = FALSE;
  boolean autn_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (4 == name_len && 0 == strncmp(fld_name, "rand", name_len)) {
        rand_found = TRUE;
         int ret_val = field_rand.JSON_decode(AuthenticationQuintuplet_rand_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 4, "rand");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (4 == name_len && 0 == strncmp(fld_name, "xres", name_len)) {
        xres_found = TRUE;
         int ret_val = field_xres.JSON_decode(XRES_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 4, "xres");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (2 == name_len && 0 == strncmp(fld_name, "ck", name_len)) {
        ck_found = TRUE;
         int ret_val = field_ck.JSON_decode(AuthenticationQuintuplet_ck_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 2, "ck");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (2 == name_len && 0 == strncmp(fld_name, "ik", name_len)) {
        ik_found = TRUE;
         int ret_val = field_ik.JSON_decode(AuthenticationQuintuplet_ik_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 2, "ik");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (4 == name_len && 0 == strncmp(fld_name, "autn", name_len)) {
        autn_found = TRUE;
         int ret_val = field_autn.JSON_decode(AuthenticationQuintuplet_autn_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 4, "autn");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!rand_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "rand");
    return JSON_ERROR_FATAL;
  }
  if (!xres_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "xres");
    return JSON_ERROR_FATAL;
  }
  if (!ck_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "ck");
    return JSON_ERROR_FATAL;
  }
  if (!ik_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "ik");
    return JSON_ERROR_FATAL;
  }
  if (!autn_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "autn");
    return JSON_ERROR_FATAL;
  }
  
  return (int)dec_len;
}

int AuthenticationQuintuplet::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  p_buf.put_c(c);
  field_rand.OER_encode(AuthenticationQuintuplet_rand_descr_, p_buf);
  field_xres.OER_encode(XRES_descr_, p_buf);
  field_ck.OER_encode(AuthenticationQuintuplet_ck_descr_, p_buf);
  field_ik.OER_encode(AuthenticationQuintuplet_ik_descr_, p_buf);
  field_autn.OER_encode(AuthenticationQuintuplet_autn_descr_, p_buf);
  return 0;
}

int AuthenticationQuintuplet::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_rand.OER_decode(AuthenticationQuintuplet_rand_descr_, p_buf, p_oer);
  field_xres.OER_decode(XRES_descr_, p_buf, p_oer);
  field_ck.OER_decode(AuthenticationQuintuplet_ck_descr_, p_buf, p_oer);
  field_ik.OER_decode(AuthenticationQuintuplet_ik_descr_, p_buf, p_oer);
  field_autn.OER_decode(AuthenticationQuintuplet_autn_descr_, p_buf, p_oer);
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void AuthenticationQuintuplet::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
field_rand.PER_encode(AuthenticationQuintuplet_rand_descr_, p_buf, p_options);
field_xres.PER_encode(XRES_descr_, p_buf, p_options);
field_ck.PER_encode(AuthenticationQuintuplet_ck_descr_, p_buf, p_options);
field_ik.PER_encode(AuthenticationQuintuplet_ik_descr_, p_buf, p_options);
field_autn.PER_encode(AuthenticationQuintuplet_autn_descr_, p_buf, p_options);
}

void AuthenticationQuintuplet::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
field_rand.PER_decode(AuthenticationQuintuplet_rand_descr_, p_buf, p_options);
field_xres.PER_decode(XRES_descr_, p_buf, p_options);
field_ck.PER_decode(AuthenticationQuintuplet_ck_descr_, p_buf, p_options);
field_ik.PER_decode(AuthenticationQuintuplet_ik_descr_, p_buf, p_options);
field_autn.PER_decode(AuthenticationQuintuplet_autn_descr_, p_buf, p_options);
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct AuthenticationQuintuplet_template::single_value_struct {
OCTETSTRING_template field_rand;
OCTETSTRING_template field_xres;
OCTETSTRING_template field_ck;
OCTETSTRING_template field_ik;
OCTETSTRING_template field_autn;
};

void AuthenticationQuintuplet_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_rand = ANY_VALUE;
single_value->field_xres = ANY_VALUE;
single_value->field_ck = ANY_VALUE;
single_value->field_ik = ANY_VALUE;
single_value->field_autn = ANY_VALUE;
}
}
}

void AuthenticationQuintuplet_template::copy_value(const AuthenticationQuintuplet& other_value)
{
single_value = new single_value_struct;
if (other_value.rand().is_bound()) {
  single_value->field_rand = other_value.rand();
} else {
  single_value->field_rand.clean_up();
}
if (other_value.xres().is_bound()) {
  single_value->field_xres = other_value.xres();
} else {
  single_value->field_xres.clean_up();
}
if (other_value.ck().is_bound()) {
  single_value->field_ck = other_value.ck();
} else {
  single_value->field_ck.clean_up();
}
if (other_value.ik().is_bound()) {
  single_value->field_ik = other_value.ik();
} else {
  single_value->field_ik.clean_up();
}
if (other_value.autn().is_bound()) {
  single_value->field_autn = other_value.autn();
} else {
  single_value->field_autn.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void AuthenticationQuintuplet_template::copy_template(const AuthenticationQuintuplet_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.rand().get_selection()) {
single_value->field_rand = other_value.rand();
} else {
single_value->field_rand.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.xres().get_selection()) {
single_value->field_xres = other_value.xres();
} else {
single_value->field_xres.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ck().get_selection()) {
single_value->field_ck = other_value.ck();
} else {
single_value->field_ck.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ik().get_selection()) {
single_value->field_ik = other_value.ik();
} else {
single_value->field_ik.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.autn().get_selection()) {
single_value->field_autn = other_value.autn();
} else {
single_value->field_autn.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new AuthenticationQuintuplet_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new AuthenticationQuintuplet_template(*other_value.implication_.precondition);
implication_.implied_template = new AuthenticationQuintuplet_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.AuthenticationQuintuplet.");
break;
}
set_selection(other_value);
}

AuthenticationQuintuplet_template::AuthenticationQuintuplet_template()
{
}

AuthenticationQuintuplet_template::AuthenticationQuintuplet_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

AuthenticationQuintuplet_template::AuthenticationQuintuplet_template(const AuthenticationQuintuplet& other_value)
{
copy_value(other_value);
}

AuthenticationQuintuplet_template::AuthenticationQuintuplet_template(const OPTIONAL<AuthenticationQuintuplet>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const AuthenticationQuintuplet&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.AuthenticationQuintuplet from an unbound optional field.");
}
}

AuthenticationQuintuplet_template::AuthenticationQuintuplet_template(AuthenticationQuintuplet_template* p_precondition, AuthenticationQuintuplet_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

AuthenticationQuintuplet_template::AuthenticationQuintuplet_template(Dynamic_Match_Interface<AuthenticationQuintuplet>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<AuthenticationQuintuplet>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

AuthenticationQuintuplet_template::AuthenticationQuintuplet_template(const AuthenticationQuintuplet_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

AuthenticationQuintuplet_template::~AuthenticationQuintuplet_template()
{
clean_up();
}

AuthenticationQuintuplet_template& AuthenticationQuintuplet_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

AuthenticationQuintuplet_template& AuthenticationQuintuplet_template::operator=(const AuthenticationQuintuplet& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

AuthenticationQuintuplet_template& AuthenticationQuintuplet_template::operator=(const OPTIONAL<AuthenticationQuintuplet>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const AuthenticationQuintuplet&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.AuthenticationQuintuplet.");
}
return *this;
}

AuthenticationQuintuplet_template& AuthenticationQuintuplet_template::operator=(const AuthenticationQuintuplet_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean AuthenticationQuintuplet_template::match(const AuthenticationQuintuplet& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.rand().is_bound()) return FALSE;
if(!single_value->field_rand.match(other_value.rand(), legacy))return FALSE;
if(!other_value.xres().is_bound()) return FALSE;
if(!single_value->field_xres.match(other_value.xres(), legacy))return FALSE;
if(!other_value.ck().is_bound()) return FALSE;
if(!single_value->field_ck.match(other_value.ck(), legacy))return FALSE;
if(!other_value.ik().is_bound()) return FALSE;
if(!single_value->field_ik.match(other_value.ik(), legacy))return FALSE;
if(!other_value.autn().is_bound()) return FALSE;
if(!single_value->field_autn.match(other_value.autn(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.AuthenticationQuintuplet.");
}
return FALSE;
}

boolean AuthenticationQuintuplet_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_rand.is_bound()
 || single_value->field_xres.is_bound()
 || single_value->field_ck.is_bound()
 || single_value->field_ik.is_bound()
 || single_value->field_autn.is_bound();
}

boolean AuthenticationQuintuplet_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_rand.is_value()
 && single_value->field_xres.is_value()
 && single_value->field_ck.is_value()
 && single_value->field_ik.is_value()
 && single_value->field_autn.is_value();
}

void AuthenticationQuintuplet_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

AuthenticationQuintuplet AuthenticationQuintuplet_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.AuthenticationQuintuplet.");
AuthenticationQuintuplet ret_val;
if (single_value->field_rand.is_bound()) {
ret_val.rand() = single_value->field_rand.valueof();
}
if (single_value->field_xres.is_bound()) {
ret_val.xres() = single_value->field_xres.valueof();
}
if (single_value->field_ck.is_bound()) {
ret_val.ck() = single_value->field_ck.valueof();
}
if (single_value->field_ik.is_bound()) {
ret_val.ik() = single_value->field_ik.valueof();
}
if (single_value->field_autn.is_bound()) {
ret_val.autn() = single_value->field_autn.valueof();
}
return ret_val;
}

void AuthenticationQuintuplet_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.AuthenticationQuintuplet.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new AuthenticationQuintuplet_template[list_length];
}

AuthenticationQuintuplet_template& AuthenticationQuintuplet_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.AuthenticationQuintuplet.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.AuthenticationQuintuplet.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& AuthenticationQuintuplet_template::rand()
{
set_specific();
return single_value->field_rand;
}

const OCTETSTRING_template& AuthenticationQuintuplet_template::rand() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rand of a non-specific template of type @MAP-MS-DataTypes.AuthenticationQuintuplet.");
return single_value->field_rand;
}

OCTETSTRING_template& AuthenticationQuintuplet_template::xres()
{
set_specific();
return single_value->field_xres;
}

const OCTETSTRING_template& AuthenticationQuintuplet_template::xres() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field xres of a non-specific template of type @MAP-MS-DataTypes.AuthenticationQuintuplet.");
return single_value->field_xres;
}

OCTETSTRING_template& AuthenticationQuintuplet_template::ck()
{
set_specific();
return single_value->field_ck;
}

const OCTETSTRING_template& AuthenticationQuintuplet_template::ck() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ck of a non-specific template of type @MAP-MS-DataTypes.AuthenticationQuintuplet.");
return single_value->field_ck;
}

OCTETSTRING_template& AuthenticationQuintuplet_template::ik()
{
set_specific();
return single_value->field_ik;
}

const OCTETSTRING_template& AuthenticationQuintuplet_template::ik() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ik of a non-specific template of type @MAP-MS-DataTypes.AuthenticationQuintuplet.");
return single_value->field_ik;
}

OCTETSTRING_template& AuthenticationQuintuplet_template::autn()
{
set_specific();
return single_value->field_autn;
}

const OCTETSTRING_template& AuthenticationQuintuplet_template::autn() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field autn of a non-specific template of type @MAP-MS-DataTypes.AuthenticationQuintuplet.");
return single_value->field_autn;
}

int AuthenticationQuintuplet_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationQuintuplet which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 5;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationQuintuplet containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationQuintuplet containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationQuintuplet containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationQuintuplet containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationQuintuplet containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationQuintuplet containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationQuintuplet containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationQuintuplet containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.AuthenticationQuintuplet.");
  }
  return 0;
}

void AuthenticationQuintuplet_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ rand := ");
single_value->field_rand.log();
TTCN_Logger::log_event_str(", xres := ");
single_value->field_xres.log();
TTCN_Logger::log_event_str(", ck := ");
single_value->field_ck.log();
TTCN_Logger::log_event_str(", ik := ");
single_value->field_ik.log();
TTCN_Logger::log_event_str(", autn := ");
single_value->field_autn.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void AuthenticationQuintuplet_template::log_match(const AuthenticationQuintuplet& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_rand.match(match_value.rand(), legacy)){
TTCN_Logger::log_logmatch_info(".rand");
single_value->field_rand.log_match(match_value.rand(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_xres.match(match_value.xres(), legacy)){
TTCN_Logger::log_logmatch_info(".xres");
single_value->field_xres.log_match(match_value.xres(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ck.match(match_value.ck(), legacy)){
TTCN_Logger::log_logmatch_info(".ck");
single_value->field_ck.log_match(match_value.ck(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ik.match(match_value.ik(), legacy)){
TTCN_Logger::log_logmatch_info(".ik");
single_value->field_ik.log_match(match_value.ik(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_autn.match(match_value.autn(), legacy)){
TTCN_Logger::log_logmatch_info(".autn");
single_value->field_autn.log_match(match_value.autn(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ rand := ");
single_value->field_rand.log_match(match_value.rand(), legacy);
TTCN_Logger::log_event_str(", xres := ");
single_value->field_xres.log_match(match_value.xres(), legacy);
TTCN_Logger::log_event_str(", ck := ");
single_value->field_ck.log_match(match_value.ck(), legacy);
TTCN_Logger::log_event_str(", ik := ");
single_value->field_ik.log_match(match_value.ik(), legacy);
TTCN_Logger::log_event_str(", autn := ");
single_value->field_autn.log_match(match_value.autn(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void AuthenticationQuintuplet_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (rand().is_bound()) rand().set_implicit_omit();
if (xres().is_bound()) xres().set_implicit_omit();
if (ck().is_bound()) ck().set_implicit_omit();
if (ik().is_bound()) ik().set_implicit_omit();
if (autn().is_bound()) autn().set_implicit_omit();
}

void AuthenticationQuintuplet_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_rand.encode_text(text_buf);
single_value->field_xres.encode_text(text_buf);
single_value->field_ck.encode_text(text_buf);
single_value->field_ik.encode_text(text_buf);
single_value->field_autn.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.AuthenticationQuintuplet.");
}
}

void AuthenticationQuintuplet_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_rand.decode_text(text_buf);
single_value->field_xres.decode_text(text_buf);
single_value->field_ck.decode_text(text_buf);
single_value->field_ik.decode_text(text_buf);
single_value->field_autn.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new AuthenticationQuintuplet_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.AuthenticationQuintuplet.");
}
}

void AuthenticationQuintuplet_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    AuthenticationQuintuplet_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (5<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.AuthenticationQuintuplet has 5 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) rand().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) xres().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) ck().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) ik().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) autn().set_param(*param.get_elem(4));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rand")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rand().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "xres")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          xres().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ck")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ck().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ik")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ik().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "autn")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          autn().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.AuthenticationQuintuplet: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    AuthenticationQuintuplet_template* precondition = new AuthenticationQuintuplet_template;
    precondition->set_param(*param.get_elem(0));
    AuthenticationQuintuplet_template* implied_template = new AuthenticationQuintuplet_template;
    implied_template->set_param(*param.get_elem(1));
    *this = AuthenticationQuintuplet_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.AuthenticationQuintuplet");
  }
  is_ifpresent = param.get_ifpresent();
}

void AuthenticationQuintuplet_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_rand.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AuthenticationQuintuplet");
single_value->field_xres.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AuthenticationQuintuplet");
single_value->field_ck.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AuthenticationQuintuplet");
single_value->field_ik.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AuthenticationQuintuplet");
single_value->field_autn.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AuthenticationQuintuplet");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.AuthenticationQuintuplet");
}

boolean AuthenticationQuintuplet_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean AuthenticationQuintuplet_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void CurrentSecurityContext::copy_value(const CurrentSecurityContext& other_value)
{
switch (other_value.union_selection) {
case ALT_gsm__SecurityContextData:
field_gsm__SecurityContextData = new GSM__SecurityContextData(*other_value.field_gsm__SecurityContextData);
break;
case ALT_umts__SecurityContextData:
field_umts__SecurityContextData = new UMTS__SecurityContextData(*other_value.field_umts__SecurityContextData);
break;
default:
TTCN_error("Assignment of an unbound union value of type @MAP-MS-DataTypes.CurrentSecurityContext.");
}
union_selection = other_value.union_selection;
}

CurrentSecurityContext::CurrentSecurityContext()
{
union_selection = UNBOUND_VALUE;
}

CurrentSecurityContext::CurrentSecurityContext(const CurrentSecurityContext& other_value)
: Base_Type(){
copy_value(other_value);
}

CurrentSecurityContext::~CurrentSecurityContext()
{
clean_up();
}

CurrentSecurityContext& CurrentSecurityContext::operator=(const CurrentSecurityContext& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean CurrentSecurityContext::operator==(const CurrentSecurityContext& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_gsm__SecurityContextData:
return *field_gsm__SecurityContextData == *other_value.field_gsm__SecurityContextData;
case ALT_umts__SecurityContextData:
return *field_umts__SecurityContextData == *other_value.field_umts__SecurityContextData;
default:
return FALSE;
}
}

GSM__SecurityContextData& CurrentSecurityContext::gsm__SecurityContextData()
{
if (union_selection != ALT_gsm__SecurityContextData) {
clean_up();
field_gsm__SecurityContextData = new GSM__SecurityContextData;
union_selection = ALT_gsm__SecurityContextData;
}
return *field_gsm__SecurityContextData;
}

const GSM__SecurityContextData& CurrentSecurityContext::gsm__SecurityContextData() const
{
if (union_selection != ALT_gsm__SecurityContextData) TTCN_error("Using non-selected field gsm_SecurityContextData in a value of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
return *field_gsm__SecurityContextData;
}

UMTS__SecurityContextData& CurrentSecurityContext::umts__SecurityContextData()
{
if (union_selection != ALT_umts__SecurityContextData) {
clean_up();
field_umts__SecurityContextData = new UMTS__SecurityContextData;
union_selection = ALT_umts__SecurityContextData;
}
return *field_umts__SecurityContextData;
}

const UMTS__SecurityContextData& CurrentSecurityContext::umts__SecurityContextData() const
{
if (union_selection != ALT_umts__SecurityContextData) TTCN_error("Using non-selected field umts_SecurityContextData in a value of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
return *field_umts__SecurityContextData;
}

boolean CurrentSecurityContext::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
return union_selection == checked_selection;
}

boolean CurrentSecurityContext::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean CurrentSecurityContext::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_gsm__SecurityContextData: return field_gsm__SecurityContextData->is_value();
case ALT_umts__SecurityContextData: return field_umts__SecurityContextData->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void CurrentSecurityContext::clean_up()
{
switch (union_selection) {
case ALT_gsm__SecurityContextData:
  delete field_gsm__SecurityContextData;
  break;
case ALT_umts__SecurityContextData:
  delete field_umts__SecurityContextData;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void CurrentSecurityContext::log() const
{
switch (union_selection) {
case ALT_gsm__SecurityContextData:
TTCN_Logger::log_event_str("{ gsm_SecurityContextData := ");
field_gsm__SecurityContextData->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_umts__SecurityContextData:
TTCN_Logger::log_event_str("{ umts_SecurityContextData := ");
field_umts__SecurityContextData->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void CurrentSecurityContext::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "gsm_SecurityContextData")) {
    gsm__SecurityContextData().set_param(*mp_last);
    if (!gsm__SecurityContextData().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "umts_SecurityContextData")) {
    umts__SecurityContextData().set_param(*mp_last);
    if (!umts__SecurityContextData().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @MAP-MS-DataTypes.CurrentSecurityContext.", last_name);
}

void CurrentSecurityContext::set_implicit_omit()
{
switch (union_selection) {
case ALT_gsm__SecurityContextData:
field_gsm__SecurityContextData->set_implicit_omit(); break;
case ALT_umts__SecurityContextData:
field_umts__SecurityContextData->set_implicit_omit(); break;
default: break;
}
}

void CurrentSecurityContext::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_gsm__SecurityContextData:
field_gsm__SecurityContextData->encode_text(text_buf);
break;
case ALT_umts__SecurityContextData:
field_umts__SecurityContextData->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
}
}

void CurrentSecurityContext::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_gsm__SecurityContextData:
gsm__SecurityContextData().decode_text(text_buf);
break;
case ALT_umts__SecurityContextData:
umts__SecurityContextData().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @MAP-MS-DataTypes.CurrentSecurityContext.");
}
}

void CurrentSecurityContext::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void CurrentSecurityContext::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t *CurrentSecurityContext::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv;
  TTCN_EncDec_ErrorContext ec_0("Alternative '");
  TTCN_EncDec_ErrorContext ec_1;
  switch (union_selection) {
  case ALT_gsm__SecurityContextData:
    ec_1.set_msg("gsm_SecurityContextData': ");
    new_tlv = field_gsm__SecurityContextData->BER_encode_TLV(CurrentSecurityContext_gsm__SecurityContextData_descr_, p_coding);
    break;
  case ALT_umts__SecurityContextData:
    ec_1.set_msg("umts_SecurityContextData': ");
    new_tlv = field_umts__SecurityContextData->BER_encode_TLV(CurrentSecurityContext_umts__SecurityContextData_descr_, p_coding);
    break;
  case UNBOUND_VALUE:
    new_tlv = BER_encode_chk_bound(FALSE);
    break;
  default:
    TTCN_EncDec_ErrorContext::error_internal("Unknown selection.");
    new_tlv = NULL;
  }
  return ASN_BER_V2TLV(new_tlv, p_td, p_coding);
}

boolean CurrentSecurityContext::BER_decode_set_selection(const ASN_BER_TLV_t& p_tlv)
{
  clean_up();
  field_gsm__SecurityContextData = new GSM__SecurityContextData;
  union_selection = ALT_gsm__SecurityContextData;
  if (field_gsm__SecurityContextData->BER_decode_isMyMsg(CurrentSecurityContext_gsm__SecurityContextData_descr_, p_tlv)) return TRUE;
  delete field_gsm__SecurityContextData;
  field_umts__SecurityContextData = new UMTS__SecurityContextData;
  union_selection = ALT_umts__SecurityContextData;
  if (field_umts__SecurityContextData->BER_decode_isMyMsg(CurrentSecurityContext_umts__SecurityContextData_descr_, p_tlv)) return TRUE;
  delete field_umts__SecurityContextData;
  union_selection = UNBOUND_VALUE;
  return FALSE;
}

boolean CurrentSecurityContext::BER_decode_isMyMsg(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv)
{
  if (p_td.ber->n_tags == 0) {
    CurrentSecurityContext tmp_type;
    return tmp_type.BER_decode_set_selection(p_tlv);
  } else return Base_Type::BER_decode_isMyMsg(p_td, p_tlv);
}

boolean CurrentSecurityContext::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.CurrentSecurityContext' type: ");
  ASN_BER_TLV_t tmp_tlv;
  if (!BER_decode_TLV_CHOICE(*p_td.ber, stripped_tlv, L_form, tmp_tlv) || !BER_decode_CHOICE_selection(BER_decode_set_selection(tmp_tlv), tmp_tlv)) return FALSE;
  TTCN_EncDec_ErrorContext ec_1("Alternative '");
  TTCN_EncDec_ErrorContext ec_2;
  switch (union_selection) {
  case ALT_gsm__SecurityContextData:
    ec_2.set_msg("gsm_SecurityContextData': ");
    field_gsm__SecurityContextData->BER_decode_TLV(CurrentSecurityContext_gsm__SecurityContextData_descr_, tmp_tlv, L_form);
    break;
  case ALT_umts__SecurityContextData:
    ec_2.set_msg("umts_SecurityContextData': ");
    field_umts__SecurityContextData->BER_decode_TLV(CurrentSecurityContext_umts__SecurityContextData_descr_, tmp_tlv, L_form);
    break;
  default:
    return FALSE;
  }
  return TRUE;
}

int CurrentSecurityContext::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean) const
{
  boolean as_value = p_td.json->as_value;
  int enc_len = as_value ? 0 : p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);
  switch(union_selection) {
  case ALT_gsm__SecurityContextData:
    if (!as_value) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "gsm_SecurityContextData");
    }
    enc_len += field_gsm__SecurityContextData->JSON_encode(CurrentSecurityContext_gsm__SecurityContextData_descr_, p_tok, FALSE);
    break;
  case ALT_umts__SecurityContextData:
    if (!as_value) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "umts_SecurityContextData");
    }
    enc_len += field_umts__SecurityContextData->JSON_encode(CurrentSecurityContext_umts__SecurityContextData_descr_, p_tok, FALSE);
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, 
      "Encoding an unbound value of type @MAP-MS-DataTypes.CurrentSecurityContext.");
    return -1;
  }

  if (!as_value) {
    enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  }
  return enc_len;
}

int CurrentSecurityContext::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean, int p_chosen_field)
{
  if (0 <= p_chosen_field && 2 > p_chosen_field) {
    switch (p_chosen_field) {
    case 0:
      return gsm__SecurityContextData().JSON_decode(CurrentSecurityContext_gsm__SecurityContextData_descr_, p_tok, TRUE, FALSE);
    case 1:
      return umts__SecurityContextData().JSON_decode(CurrentSecurityContext_umts__SecurityContextData_descr_, p_tok, TRUE, FALSE);
    }
  }
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const CurrentSecurityContext*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
 if (p_td.json->as_value) {
  size_t buf_pos = p_tok.get_buf_pos();
  p_tok.get_next_token(&j_token, NULL, NULL);
  int ret_val = 0;
  switch(j_token) {
  case JSON_TOKEN_NUMBER: {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "number '@MAP-MS-DataTypes.CurrentSecurityContext'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_STRING: {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "string '@MAP-MS-DataTypes.CurrentSecurityContext'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_LITERAL_TRUE:
  case JSON_TOKEN_LITERAL_FALSE: {
    char* literal_str = mprintf("literal (%s)",
      (JSON_TOKEN_LITERAL_TRUE == j_token) ? "true" : "false");
    try {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, literal_str);
    }
    catch (const TC_Error&) {
      Free(literal_str);
      throw;
    }
    Free(literal_str);
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_ARRAY_START: {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "array '@MAP-MS-DataTypes.CurrentSecurityContext'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_OBJECT_START: {
    p_tok.set_buf_pos(buf_pos);
    ret_val = gsm__SecurityContextData().JSON_decode(CurrentSecurityContext_gsm__SecurityContextData_descr_, p_tok, TRUE, FALSE);
    if (0 <= ret_val) {
      return ret_val;
    }
    p_tok.set_buf_pos(buf_pos);
    ret_val = umts__SecurityContextData().JSON_decode(CurrentSecurityContext_umts__SecurityContextData_descr_, p_tok, TRUE, FALSE);
    if (0 <= ret_val) {
      return ret_val;
    }
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "object '@MAP-MS-DataTypes.CurrentSecurityContext'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_LITERAL_NULL: {
    clean_up();
    return JSON_ERROR_INVALID_TOKEN;
  }
  case JSON_TOKEN_ERROR:
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  default:
    return JSON_ERROR_INVALID_TOKEN;
  }
  return ret_val;
 }
 else {
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }

  char* fld_name = 0;
  size_t name_len = 0;
  dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
  if (JSON_TOKEN_NAME != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
    return JSON_ERROR_FATAL;
  } else {
if (23 == name_len && 0 == strncmp(fld_name, "gsm_SecurityContextData", name_len)) {
      int ret_val = gsm__SecurityContextData().JSON_decode(CurrentSecurityContext_gsm__SecurityContextData_descr_, p_tok, p_silent, FALSE);
      if (0 > ret_val) {
        if (JSON_ERROR_INVALID_TOKEN == ret_val) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 23, "gsm_SecurityContextData");
        }
        return JSON_ERROR_FATAL;
      } else {
        dec_len += (size_t)ret_val;
      }
    } else if (24 == name_len && 0 == strncmp(fld_name, "umts_SecurityContextData", name_len)) {
      int ret_val = umts__SecurityContextData().JSON_decode(CurrentSecurityContext_umts__SecurityContextData_descr_, p_tok, p_silent, FALSE);
      if (0 > ret_val) {
        if (JSON_ERROR_INVALID_TOKEN == ret_val) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 24, "umts_SecurityContextData");
        }
        return JSON_ERROR_FATAL;
      } else {
        dec_len += (size_t)ret_val;
      }
    } else {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
      return JSON_ERROR_FATAL;
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_STATIC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  return (int)dec_len;
 }
}

int CurrentSecurityContext::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  switch(union_selection) {
  case ALT_gsm__SecurityContextData:
    {TTCN_Buffer buf;
    encode_oer_tag(*CurrentSecurityContext_gsm__SecurityContextData_descr_.ber, p_buf);
    field_gsm__SecurityContextData->OER_encode(CurrentSecurityContext_gsm__SecurityContextData_descr_, buf);
    p_buf.put_buf(buf);
    break;
}  case ALT_umts__SecurityContextData:
    {TTCN_Buffer buf;
    encode_oer_tag(*CurrentSecurityContext_umts__SecurityContextData_descr_.ber, p_buf);
    field_umts__SecurityContextData->OER_encode(CurrentSecurityContext_umts__SecurityContextData_descr_, buf);
    p_buf.put_buf(buf);
    break;
}  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, 
      "Encoding an unbound value of type @MAP-MS-DataTypes.CurrentSecurityContext.");
    return -1;
  }

  return 0;
}
int CurrentSecurityContext::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const ASN_Tag_t& descr = decode_oer_tag(p_buf);
  if (CurrentSecurityContext_gsm__SecurityContextData_descr_.ber->tags[CurrentSecurityContext_gsm__SecurityContextData_descr_.ber->n_tags-1].tagclass == descr.tagclass &&
      CurrentSecurityContext_gsm__SecurityContextData_descr_.ber->tags[CurrentSecurityContext_gsm__SecurityContextData_descr_.ber->n_tags-1].tagnumber == descr.tagnumber) {
    gsm__SecurityContextData().OER_decode(CurrentSecurityContext_gsm__SecurityContextData_descr_, p_buf, p_oer);
  } else 
  if (CurrentSecurityContext_umts__SecurityContextData_descr_.ber->tags[CurrentSecurityContext_umts__SecurityContextData_descr_.ber->n_tags-1].tagclass == descr.tagclass &&
      CurrentSecurityContext_umts__SecurityContextData_descr_.ber->tags[CurrentSecurityContext_umts__SecurityContextData_descr_.ber->n_tags-1].tagnumber == descr.tagnumber) {
    umts__SecurityContextData().OER_decode(CurrentSecurityContext_umts__SecurityContextData_descr_, p_buf, p_oer);
  } else 
{
    TTCN_error("Cannot find matching tag for type CurrentSecurityContext");
}
  return 0;
}
void CurrentSecurityContext::PER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound CHOICE value.");
return;
}
switch (union_selection) {
case ALT_gsm__SecurityContextData: {
INTEGER::PER_encode_int(p_buf, 0, 1);
field_gsm__SecurityContextData->PER_encode(CurrentSecurityContext_gsm__SecurityContextData_descr_, p_buf, p_options);
break; }
case ALT_umts__SecurityContextData: {
INTEGER::PER_encode_int(p_buf, 1, 1);
field_umts__SecurityContextData->PER_encode(CurrentSecurityContext_umts__SecurityContextData_descr_, p_buf, p_options);
break; }
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Internal error: Invalid CHOICE selection, expected an extension root field.");
break;
}
}

void CurrentSecurityContext::PER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
int sel_int;
INTEGER::PER_decode_int(p_buf, 1, FALSE, sel_int);
switch (sel_int) {
case 0:
gsm__SecurityContextData().PER_decode(CurrentSecurityContext_gsm__SecurityContextData_descr_, p_buf, p_options);
break;
case 1:
umts__SecurityContextData().PER_decode(CurrentSecurityContext_umts__SecurityContextData_descr_, p_buf, p_options);
break;
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INVAL_MSG, "Decoded invalid CHOICE selection (%d).", sel_int);
break;
}
}

void CurrentSecurityContext_template::copy_value(const CurrentSecurityContext& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case CurrentSecurityContext::ALT_gsm__SecurityContextData:
single_value.field_gsm__SecurityContextData = new GSM__SecurityContextData_template(other_value.gsm__SecurityContextData());
break;
case CurrentSecurityContext::ALT_umts__SecurityContextData:
single_value.field_umts__SecurityContextData = new UMTS__SecurityContextData_template(other_value.umts__SecurityContextData());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @MAP-MS-DataTypes.CurrentSecurityContext.");
}
set_selection(SPECIFIC_VALUE);
}

void CurrentSecurityContext_template::copy_template(const CurrentSecurityContext_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case CurrentSecurityContext::ALT_gsm__SecurityContextData:
single_value.field_gsm__SecurityContextData = new GSM__SecurityContextData_template(*other_value.single_value.field_gsm__SecurityContextData);
break;
case CurrentSecurityContext::ALT_umts__SecurityContextData:
single_value.field_umts__SecurityContextData = new UMTS__SecurityContextData_template(*other_value.single_value.field_umts__SecurityContextData);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @MAP-MS-DataTypes.CurrentSecurityContext.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new CurrentSecurityContext_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new CurrentSecurityContext_template(*other_value.implication_.precondition);
implication_.implied_template = new CurrentSecurityContext_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
}
set_selection(other_value);
}

CurrentSecurityContext_template::CurrentSecurityContext_template()
{
}

CurrentSecurityContext_template::CurrentSecurityContext_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

CurrentSecurityContext_template::CurrentSecurityContext_template(const CurrentSecurityContext& other_value)
{
copy_value(other_value);
}

CurrentSecurityContext_template::CurrentSecurityContext_template(const OPTIONAL<CurrentSecurityContext>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CurrentSecurityContext&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @MAP-MS-DataTypes.CurrentSecurityContext from an unbound optional field.");
}
}

CurrentSecurityContext_template::CurrentSecurityContext_template(CurrentSecurityContext_template* p_precondition, CurrentSecurityContext_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

CurrentSecurityContext_template::CurrentSecurityContext_template(Dynamic_Match_Interface<CurrentSecurityContext>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<CurrentSecurityContext>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

CurrentSecurityContext_template::CurrentSecurityContext_template(const CurrentSecurityContext_template& other_value)
: Base_Template(){
copy_template(other_value);
}

CurrentSecurityContext_template::~CurrentSecurityContext_template()
{
clean_up();
}

void CurrentSecurityContext_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case CurrentSecurityContext::ALT_gsm__SecurityContextData:
delete single_value.field_gsm__SecurityContextData;
break;
case CurrentSecurityContext::ALT_umts__SecurityContextData:
delete single_value.field_umts__SecurityContextData;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

CurrentSecurityContext_template& CurrentSecurityContext_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

CurrentSecurityContext_template& CurrentSecurityContext_template::operator=(const CurrentSecurityContext& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

CurrentSecurityContext_template& CurrentSecurityContext_template::operator=(const OPTIONAL<CurrentSecurityContext>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const CurrentSecurityContext&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
}
return *this;
}

CurrentSecurityContext_template& CurrentSecurityContext_template::operator=(const CurrentSecurityContext_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean CurrentSecurityContext_template::match(const CurrentSecurityContext& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
CurrentSecurityContext::union_selection_type value_selection = other_value.get_selection();
if (value_selection == CurrentSecurityContext::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case CurrentSecurityContext::ALT_gsm__SecurityContextData:
return single_value.field_gsm__SecurityContextData->match(other_value.gsm__SecurityContextData(), legacy);
case CurrentSecurityContext::ALT_umts__SecurityContextData:
return single_value.field_umts__SecurityContextData->match(other_value.umts__SecurityContextData(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
}
return FALSE;
}

boolean CurrentSecurityContext_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case CurrentSecurityContext::ALT_gsm__SecurityContextData:
return single_value.field_gsm__SecurityContextData->is_value();
case CurrentSecurityContext::ALT_umts__SecurityContextData:
return single_value.field_umts__SecurityContextData->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
}
}

CurrentSecurityContext CurrentSecurityContext_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
CurrentSecurityContext ret_val;
switch (single_value.union_selection) {
case CurrentSecurityContext::ALT_gsm__SecurityContextData:
ret_val.gsm__SecurityContextData() = single_value.field_gsm__SecurityContextData->valueof();
break;
case CurrentSecurityContext::ALT_umts__SecurityContextData:
ret_val.umts__SecurityContextData() = single_value.field_umts__SecurityContextData->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
}
return ret_val;
}

CurrentSecurityContext_template& CurrentSecurityContext_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
return value_list.list_value[list_index];
}
void CurrentSecurityContext_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new CurrentSecurityContext_template[list_length];
}

GSM__SecurityContextData_template& CurrentSecurityContext_template::gsm__SecurityContextData()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != CurrentSecurityContext::ALT_gsm__SecurityContextData) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_gsm__SecurityContextData = new GSM__SecurityContextData_template(ANY_VALUE);
else single_value.field_gsm__SecurityContextData = new GSM__SecurityContextData_template;
single_value.union_selection = CurrentSecurityContext::ALT_gsm__SecurityContextData;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_gsm__SecurityContextData;
}

const GSM__SecurityContextData_template& CurrentSecurityContext_template::gsm__SecurityContextData() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field gsm_SecurityContextData in a non-specific template of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
if (single_value.union_selection != CurrentSecurityContext::ALT_gsm__SecurityContextData) TTCN_error("Accessing non-selected field gsm_SecurityContextData in a template of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
return *single_value.field_gsm__SecurityContextData;
}

UMTS__SecurityContextData_template& CurrentSecurityContext_template::umts__SecurityContextData()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != CurrentSecurityContext::ALT_umts__SecurityContextData) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_umts__SecurityContextData = new UMTS__SecurityContextData_template(ANY_VALUE);
else single_value.field_umts__SecurityContextData = new UMTS__SecurityContextData_template;
single_value.union_selection = CurrentSecurityContext::ALT_umts__SecurityContextData;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_umts__SecurityContextData;
}

const UMTS__SecurityContextData_template& CurrentSecurityContext_template::umts__SecurityContextData() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field umts_SecurityContextData in a non-specific template of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
if (single_value.union_selection != CurrentSecurityContext::ALT_umts__SecurityContextData) TTCN_error("Accessing non-selected field umts_SecurityContextData in a template of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
return *single_value.field_umts__SecurityContextData;
}

boolean CurrentSecurityContext_template::ischosen(CurrentSecurityContext::union_selection_type checked_selection) const
{
if (checked_selection == CurrentSecurityContext::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == CurrentSecurityContext::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @MAP-MS-DataTypes.CurrentSecurityContext containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void CurrentSecurityContext_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case CurrentSecurityContext::ALT_gsm__SecurityContextData:
TTCN_Logger::log_event_str("{ gsm_SecurityContextData := ");
single_value.field_gsm__SecurityContextData->log();
TTCN_Logger::log_event_str(" }");
break;
case CurrentSecurityContext::ALT_umts__SecurityContextData:
TTCN_Logger::log_event_str("{ umts_SecurityContextData := ");
single_value.field_umts__SecurityContextData->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void CurrentSecurityContext_template::log_match(const CurrentSecurityContext& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case CurrentSecurityContext::ALT_gsm__SecurityContextData:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".gsm_SecurityContextData");
single_value.field_gsm__SecurityContextData->log_match(match_value.gsm__SecurityContextData(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ gsm_SecurityContextData := ");
single_value.field_gsm__SecurityContextData->log_match(match_value.gsm__SecurityContextData(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case CurrentSecurityContext::ALT_umts__SecurityContextData:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".umts_SecurityContextData");
single_value.field_umts__SecurityContextData->log_match(match_value.umts__SecurityContextData(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ umts_SecurityContextData := ");
single_value.field_umts__SecurityContextData->log_match(match_value.umts__SecurityContextData(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void CurrentSecurityContext_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case CurrentSecurityContext::ALT_gsm__SecurityContextData:
single_value.field_gsm__SecurityContextData->set_implicit_omit(); break;
case CurrentSecurityContext::ALT_umts__SecurityContextData:
single_value.field_umts__SecurityContextData->set_implicit_omit(); break;
default: break;
}
}

void CurrentSecurityContext_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case CurrentSecurityContext::ALT_gsm__SecurityContextData:
single_value.field_gsm__SecurityContextData->encode_text(text_buf);
break;
case CurrentSecurityContext::ALT_umts__SecurityContextData:
single_value.field_umts__SecurityContextData->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @MAP-MS-DataTypes.CurrentSecurityContext.");
}
}

void CurrentSecurityContext_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = CurrentSecurityContext::UNBOUND_VALUE;
CurrentSecurityContext::union_selection_type new_selection = (CurrentSecurityContext::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case CurrentSecurityContext::ALT_gsm__SecurityContextData:
single_value.field_gsm__SecurityContextData = new GSM__SecurityContextData_template;
single_value.field_gsm__SecurityContextData->decode_text(text_buf);
break;
case CurrentSecurityContext::ALT_umts__SecurityContextData:
single_value.field_umts__SecurityContextData = new UMTS__SecurityContextData_template;
single_value.field_umts__SecurityContextData->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @MAP-MS-DataTypes.CurrentSecurityContext.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new CurrentSecurityContext_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @MAP-MS-DataTypes.CurrentSecurityContext.");
}
}

boolean CurrentSecurityContext_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean CurrentSecurityContext_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void CurrentSecurityContext_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@MAP-MS-DataTypes.CurrentSecurityContext'");
    }
    if (strcmp("gsm_SecurityContextData", param_field) == 0) {
      gsm__SecurityContextData().set_param(param);
      return;
    } else if (strcmp("umts_SecurityContextData", param_field) == 0) {
      umts__SecurityContextData().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@MAP-MS-DataTypes.CurrentSecurityContext'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    CurrentSecurityContext_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@MAP-MS-DataTypes.CurrentSecurityContext");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "gsm_SecurityContextData")) {
      gsm__SecurityContextData().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "umts_SecurityContextData")) {
      umts__SecurityContextData().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @MAP-MS-DataTypes.CurrentSecurityContext.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    CurrentSecurityContext_template* precondition = new CurrentSecurityContext_template;
    precondition->set_param(*m_p->get_elem(0));
    CurrentSecurityContext_template* implied_template = new CurrentSecurityContext_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = CurrentSecurityContext_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@MAP-MS-DataTypes.CurrentSecurityContext");
  }
  is_ifpresent = param.get_ifpresent();
}

void CurrentSecurityContext_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case CurrentSecurityContext::ALT_gsm__SecurityContextData:
single_value.field_gsm__SecurityContextData->check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CurrentSecurityContext");
return;
case CurrentSecurityContext::ALT_umts__SecurityContextData:
single_value.field_umts__SecurityContextData->check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.CurrentSecurityContext");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @MAP-MS-DataTypes.CurrentSecurityContext.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.CurrentSecurityContext");
}

GSM__SecurityContextData::GSM__SecurityContextData()
{
}

GSM__SecurityContextData::GSM__SecurityContextData(const OCTETSTRING& par_kc,
    const OCTETSTRING& par_cksn)
  :   field_kc(par_kc),
  field_cksn(par_cksn)
{
}

GSM__SecurityContextData::GSM__SecurityContextData(const GSM__SecurityContextData& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.GSM-SecurityContextData.");
if (other_value.kc().is_bound()) field_kc = other_value.kc();
else field_kc.clean_up();
if (other_value.cksn().is_bound()) field_cksn = other_value.cksn();
else field_cksn.clean_up();
}

void GSM__SecurityContextData::clean_up()
{
field_kc.clean_up();
field_cksn.clean_up();
}

const TTCN_Typedescriptor_t* GSM__SecurityContextData::get_descriptor() const { return &GSM__SecurityContextData_descr_; }
GSM__SecurityContextData& GSM__SecurityContextData::operator=(const GSM__SecurityContextData& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.GSM-SecurityContextData.");
  if (other_value.kc().is_bound()) field_kc = other_value.kc();
  else field_kc.clean_up();
  if (other_value.cksn().is_bound()) field_cksn = other_value.cksn();
  else field_cksn.clean_up();
}
return *this;
}

boolean GSM__SecurityContextData::operator==(const GSM__SecurityContextData& other_value) const
{
return field_kc==other_value.field_kc
  && field_cksn==other_value.field_cksn;
}

boolean GSM__SecurityContextData::is_bound() const
{
return (field_kc.is_bound())
  || (field_cksn.is_bound());
}
boolean GSM__SecurityContextData::is_value() const
{
return field_kc.is_value()
  && field_cksn.is_value();
}
void GSM__SecurityContextData::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ kc := ");
field_kc.log();
TTCN_Logger::log_event_str(", cksn := ");
field_cksn.log();
TTCN_Logger::log_event_str(" }");
}

void GSM__SecurityContextData::set_implicit_omit()
{
if (kc().is_bound()) kc().set_implicit_omit();
if (cksn().is_bound()) cksn().set_implicit_omit();
}

void GSM__SecurityContextData::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.GSM-SecurityContextData has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) kc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cksn().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "kc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          kc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cksn")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cksn().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.GSM-SecurityContextData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.GSM-SecurityContextData");
  }
}

void GSM__SecurityContextData::encode_text(Text_Buf& text_buf) const
{
field_kc.encode_text(text_buf);
field_cksn.encode_text(text_buf);
}

void GSM__SecurityContextData::decode_text(Text_Buf& text_buf)
{
field_kc.decode_text(text_buf);
field_cksn.decode_text(text_buf);
}

void GSM__SecurityContextData::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void GSM__SecurityContextData::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* GSM__SecurityContextData::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("kc': ");
  new_tlv->add_TLV(field_kc.BER_encode_TLV(GSM__SecurityContextData_kc_descr_, p_coding));
  ec_1.set_msg("cksn': ");
  new_tlv->add_TLV(field_cksn.BER_encode_TLV(GSM__SecurityContextData_cksn_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean GSM__SecurityContextData::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.GSM-SecurityContextData' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("kc': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_kc.BER_decode_TLV(GSM__SecurityContextData_kc_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("cksn': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_cksn.BER_decode_TLV(GSM__SecurityContextData_cksn_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int GSM__SecurityContextData::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.GSM-SecurityContextData.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "kc");
    enc_len += field_kc.JSON_encode(GSM__SecurityContextData_kc_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "cksn");
    enc_len += field_cksn.JSON_encode(GSM__SecurityContextData_cksn_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int GSM__SecurityContextData::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const GSM__SecurityContextData*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean kc_found = FALSE;
  boolean cksn_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (2 == name_len && 0 == strncmp(fld_name, "kc", name_len)) {
        kc_found = TRUE;
         int ret_val = field_kc.JSON_decode(GSM__SecurityContextData_kc_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 2, "kc");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (4 == name_len && 0 == strncmp(fld_name, "cksn", name_len)) {
        cksn_found = TRUE;
         int ret_val = field_cksn.JSON_decode(GSM__SecurityContextData_cksn_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 4, "cksn");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!kc_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "kc");
    return JSON_ERROR_FATAL;
  }
  if (!cksn_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "cksn");
    return JSON_ERROR_FATAL;
  }
  
  return (int)dec_len;
}

int GSM__SecurityContextData::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  p_buf.put_c(c);
  field_kc.OER_encode(GSM__SecurityContextData_kc_descr_, p_buf);
  field_cksn.OER_encode(GSM__SecurityContextData_cksn_descr_, p_buf);
  return 0;
}

int GSM__SecurityContextData::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_kc.OER_decode(GSM__SecurityContextData_kc_descr_, p_buf, p_oer);
  field_cksn.OER_decode(GSM__SecurityContextData_cksn_descr_, p_buf, p_oer);
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void GSM__SecurityContextData::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
field_kc.PER_encode(GSM__SecurityContextData_kc_descr_, p_buf, p_options);
field_cksn.PER_encode(GSM__SecurityContextData_cksn_descr_, p_buf, p_options);
}

void GSM__SecurityContextData::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
field_kc.PER_decode(GSM__SecurityContextData_kc_descr_, p_buf, p_options);
field_cksn.PER_decode(GSM__SecurityContextData_cksn_descr_, p_buf, p_options);
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct GSM__SecurityContextData_template::single_value_struct {
OCTETSTRING_template field_kc;
OCTETSTRING_template field_cksn;
};

void GSM__SecurityContextData_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_kc = ANY_VALUE;
single_value->field_cksn = ANY_VALUE;
}
}
}

void GSM__SecurityContextData_template::copy_value(const GSM__SecurityContextData& other_value)
{
single_value = new single_value_struct;
if (other_value.kc().is_bound()) {
  single_value->field_kc = other_value.kc();
} else {
  single_value->field_kc.clean_up();
}
if (other_value.cksn().is_bound()) {
  single_value->field_cksn = other_value.cksn();
} else {
  single_value->field_cksn.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void GSM__SecurityContextData_template::copy_template(const GSM__SecurityContextData_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.kc().get_selection()) {
single_value->field_kc = other_value.kc();
} else {
single_value->field_kc.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.cksn().get_selection()) {
single_value->field_cksn = other_value.cksn();
} else {
single_value->field_cksn.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new GSM__SecurityContextData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new GSM__SecurityContextData_template(*other_value.implication_.precondition);
implication_.implied_template = new GSM__SecurityContextData_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.GSM-SecurityContextData.");
break;
}
set_selection(other_value);
}

GSM__SecurityContextData_template::GSM__SecurityContextData_template()
{
}

GSM__SecurityContextData_template::GSM__SecurityContextData_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

GSM__SecurityContextData_template::GSM__SecurityContextData_template(const GSM__SecurityContextData& other_value)
{
copy_value(other_value);
}

GSM__SecurityContextData_template::GSM__SecurityContextData_template(const OPTIONAL<GSM__SecurityContextData>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const GSM__SecurityContextData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.GSM-SecurityContextData from an unbound optional field.");
}
}

GSM__SecurityContextData_template::GSM__SecurityContextData_template(GSM__SecurityContextData_template* p_precondition, GSM__SecurityContextData_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

GSM__SecurityContextData_template::GSM__SecurityContextData_template(Dynamic_Match_Interface<GSM__SecurityContextData>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<GSM__SecurityContextData>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

GSM__SecurityContextData_template::GSM__SecurityContextData_template(const GSM__SecurityContextData_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

GSM__SecurityContextData_template::~GSM__SecurityContextData_template()
{
clean_up();
}

GSM__SecurityContextData_template& GSM__SecurityContextData_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

GSM__SecurityContextData_template& GSM__SecurityContextData_template::operator=(const GSM__SecurityContextData& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

GSM__SecurityContextData_template& GSM__SecurityContextData_template::operator=(const OPTIONAL<GSM__SecurityContextData>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const GSM__SecurityContextData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.GSM-SecurityContextData.");
}
return *this;
}

GSM__SecurityContextData_template& GSM__SecurityContextData_template::operator=(const GSM__SecurityContextData_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean GSM__SecurityContextData_template::match(const GSM__SecurityContextData& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.kc().is_bound()) return FALSE;
if(!single_value->field_kc.match(other_value.kc(), legacy))return FALSE;
if(!other_value.cksn().is_bound()) return FALSE;
if(!single_value->field_cksn.match(other_value.cksn(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.GSM-SecurityContextData.");
}
return FALSE;
}

boolean GSM__SecurityContextData_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_kc.is_bound()
 || single_value->field_cksn.is_bound();
}

boolean GSM__SecurityContextData_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_kc.is_value()
 && single_value->field_cksn.is_value();
}

void GSM__SecurityContextData_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

GSM__SecurityContextData GSM__SecurityContextData_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.GSM-SecurityContextData.");
GSM__SecurityContextData ret_val;
if (single_value->field_kc.is_bound()) {
ret_val.kc() = single_value->field_kc.valueof();
}
if (single_value->field_cksn.is_bound()) {
ret_val.cksn() = single_value->field_cksn.valueof();
}
return ret_val;
}

void GSM__SecurityContextData_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.GSM-SecurityContextData.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new GSM__SecurityContextData_template[list_length];
}

GSM__SecurityContextData_template& GSM__SecurityContextData_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.GSM-SecurityContextData.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.GSM-SecurityContextData.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& GSM__SecurityContextData_template::kc()
{
set_specific();
return single_value->field_kc;
}

const OCTETSTRING_template& GSM__SecurityContextData_template::kc() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field kc of a non-specific template of type @MAP-MS-DataTypes.GSM-SecurityContextData.");
return single_value->field_kc;
}

OCTETSTRING_template& GSM__SecurityContextData_template::cksn()
{
set_specific();
return single_value->field_cksn;
}

const OCTETSTRING_template& GSM__SecurityContextData_template::cksn() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field cksn of a non-specific template of type @MAP-MS-DataTypes.GSM-SecurityContextData.");
return single_value->field_cksn;
}

int GSM__SecurityContextData_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.GSM-SecurityContextData which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 2;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.GSM-SecurityContextData containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.GSM-SecurityContextData containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.GSM-SecurityContextData containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.GSM-SecurityContextData containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.GSM-SecurityContextData containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.GSM-SecurityContextData containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.GSM-SecurityContextData containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.GSM-SecurityContextData containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.GSM-SecurityContextData.");
  }
  return 0;
}

void GSM__SecurityContextData_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ kc := ");
single_value->field_kc.log();
TTCN_Logger::log_event_str(", cksn := ");
single_value->field_cksn.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void GSM__SecurityContextData_template::log_match(const GSM__SecurityContextData& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_kc.match(match_value.kc(), legacy)){
TTCN_Logger::log_logmatch_info(".kc");
single_value->field_kc.log_match(match_value.kc(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_cksn.match(match_value.cksn(), legacy)){
TTCN_Logger::log_logmatch_info(".cksn");
single_value->field_cksn.log_match(match_value.cksn(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ kc := ");
single_value->field_kc.log_match(match_value.kc(), legacy);
TTCN_Logger::log_event_str(", cksn := ");
single_value->field_cksn.log_match(match_value.cksn(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void GSM__SecurityContextData_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (kc().is_bound()) kc().set_implicit_omit();
if (cksn().is_bound()) cksn().set_implicit_omit();
}

void GSM__SecurityContextData_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_kc.encode_text(text_buf);
single_value->field_cksn.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.GSM-SecurityContextData.");
}
}

void GSM__SecurityContextData_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_kc.decode_text(text_buf);
single_value->field_cksn.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new GSM__SecurityContextData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.GSM-SecurityContextData.");
}
}

void GSM__SecurityContextData_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    GSM__SecurityContextData_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (2<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.GSM-SecurityContextData has 2 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) kc().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) cksn().set_param(*param.get_elem(1));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "kc")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          kc().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "cksn")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          cksn().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.GSM-SecurityContextData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    GSM__SecurityContextData_template* precondition = new GSM__SecurityContextData_template;
    precondition->set_param(*param.get_elem(0));
    GSM__SecurityContextData_template* implied_template = new GSM__SecurityContextData_template;
    implied_template->set_param(*param.get_elem(1));
    *this = GSM__SecurityContextData_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.GSM-SecurityContextData");
  }
  is_ifpresent = param.get_ifpresent();
}

void GSM__SecurityContextData_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_kc.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.GSM-SecurityContextData");
single_value->field_cksn.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.GSM-SecurityContextData");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.GSM-SecurityContextData");
}

boolean GSM__SecurityContextData_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean GSM__SecurityContextData_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

UMTS__SecurityContextData::UMTS__SecurityContextData()
{
}

UMTS__SecurityContextData::UMTS__SecurityContextData(const OCTETSTRING& par_ck,
    const OCTETSTRING& par_ik,
    const OCTETSTRING& par_ksi)
  :   field_ck(par_ck),
  field_ik(par_ik),
  field_ksi(par_ksi)
{
}

UMTS__SecurityContextData::UMTS__SecurityContextData(const UMTS__SecurityContextData& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.UMTS-SecurityContextData.");
if (other_value.ck().is_bound()) field_ck = other_value.ck();
else field_ck.clean_up();
if (other_value.ik().is_bound()) field_ik = other_value.ik();
else field_ik.clean_up();
if (other_value.ksi().is_bound()) field_ksi = other_value.ksi();
else field_ksi.clean_up();
}

void UMTS__SecurityContextData::clean_up()
{
field_ck.clean_up();
field_ik.clean_up();
field_ksi.clean_up();
}

const TTCN_Typedescriptor_t* UMTS__SecurityContextData::get_descriptor() const { return &UMTS__SecurityContextData_descr_; }
UMTS__SecurityContextData& UMTS__SecurityContextData::operator=(const UMTS__SecurityContextData& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.UMTS-SecurityContextData.");
  if (other_value.ck().is_bound()) field_ck = other_value.ck();
  else field_ck.clean_up();
  if (other_value.ik().is_bound()) field_ik = other_value.ik();
  else field_ik.clean_up();
  if (other_value.ksi().is_bound()) field_ksi = other_value.ksi();
  else field_ksi.clean_up();
}
return *this;
}

boolean UMTS__SecurityContextData::operator==(const UMTS__SecurityContextData& other_value) const
{
return field_ck==other_value.field_ck
  && field_ik==other_value.field_ik
  && field_ksi==other_value.field_ksi;
}

boolean UMTS__SecurityContextData::is_bound() const
{
return (field_ck.is_bound())
  || (field_ik.is_bound())
  || (field_ksi.is_bound());
}
boolean UMTS__SecurityContextData::is_value() const
{
return field_ck.is_value()
  && field_ik.is_value()
  && field_ksi.is_value();
}
void UMTS__SecurityContextData::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ ck := ");
field_ck.log();
TTCN_Logger::log_event_str(", ik := ");
field_ik.log();
TTCN_Logger::log_event_str(", ksi := ");
field_ksi.log();
TTCN_Logger::log_event_str(" }");
}

void UMTS__SecurityContextData::set_implicit_omit()
{
if (ck().is_bound()) ck().set_implicit_omit();
if (ik().is_bound()) ik().set_implicit_omit();
if (ksi().is_bound()) ksi().set_implicit_omit();
}

void UMTS__SecurityContextData::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.UMTS-SecurityContextData has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) ck().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ik().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) ksi().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ck")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ck().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ik")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ik().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ksi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ksi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.UMTS-SecurityContextData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.UMTS-SecurityContextData");
  }
}

void UMTS__SecurityContextData::encode_text(Text_Buf& text_buf) const
{
field_ck.encode_text(text_buf);
field_ik.encode_text(text_buf);
field_ksi.encode_text(text_buf);
}

void UMTS__SecurityContextData::decode_text(Text_Buf& text_buf)
{
field_ck.decode_text(text_buf);
field_ik.decode_text(text_buf);
field_ksi.decode_text(text_buf);
}

void UMTS__SecurityContextData::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void UMTS__SecurityContextData::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* UMTS__SecurityContextData::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("ck': ");
  new_tlv->add_TLV(field_ck.BER_encode_TLV(UMTS__SecurityContextData_ck_descr_, p_coding));
  ec_1.set_msg("ik': ");
  new_tlv->add_TLV(field_ik.BER_encode_TLV(UMTS__SecurityContextData_ik_descr_, p_coding));
  ec_1.set_msg("ksi': ");
  new_tlv->add_TLV(field_ksi.BER_encode_TLV(UMTS__SecurityContextData_ksi_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean UMTS__SecurityContextData::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.UMTS-SecurityContextData' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("ck': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_ck.BER_decode_TLV(UMTS__SecurityContextData_ck_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("ik': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_ik.BER_decode_TLV(UMTS__SecurityContextData_ik_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("ksi': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_ksi.BER_decode_TLV(UMTS__SecurityContextData_ksi_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int UMTS__SecurityContextData::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.UMTS-SecurityContextData.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ck");
    enc_len += field_ck.JSON_encode(UMTS__SecurityContextData_ck_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ik");
    enc_len += field_ik.JSON_encode(UMTS__SecurityContextData_ik_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ksi");
    enc_len += field_ksi.JSON_encode(UMTS__SecurityContextData_ksi_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int UMTS__SecurityContextData::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const UMTS__SecurityContextData*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean ck_found = FALSE;
  boolean ik_found = FALSE;
  boolean ksi_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (2 == name_len && 0 == strncmp(fld_name, "ck", name_len)) {
        ck_found = TRUE;
         int ret_val = field_ck.JSON_decode(UMTS__SecurityContextData_ck_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 2, "ck");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (2 == name_len && 0 == strncmp(fld_name, "ik", name_len)) {
        ik_found = TRUE;
         int ret_val = field_ik.JSON_decode(UMTS__SecurityContextData_ik_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 2, "ik");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (3 == name_len && 0 == strncmp(fld_name, "ksi", name_len)) {
        ksi_found = TRUE;
         int ret_val = field_ksi.JSON_decode(UMTS__SecurityContextData_ksi_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 3, "ksi");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!ck_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "ck");
    return JSON_ERROR_FATAL;
  }
  if (!ik_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "ik");
    return JSON_ERROR_FATAL;
  }
  if (!ksi_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "ksi");
    return JSON_ERROR_FATAL;
  }
  
  return (int)dec_len;
}

int UMTS__SecurityContextData::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  p_buf.put_c(c);
  field_ck.OER_encode(UMTS__SecurityContextData_ck_descr_, p_buf);
  field_ik.OER_encode(UMTS__SecurityContextData_ik_descr_, p_buf);
  field_ksi.OER_encode(UMTS__SecurityContextData_ksi_descr_, p_buf);
  return 0;
}

int UMTS__SecurityContextData::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_ck.OER_decode(UMTS__SecurityContextData_ck_descr_, p_buf, p_oer);
  field_ik.OER_decode(UMTS__SecurityContextData_ik_descr_, p_buf, p_oer);
  field_ksi.OER_decode(UMTS__SecurityContextData_ksi_descr_, p_buf, p_oer);
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void UMTS__SecurityContextData::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
field_ck.PER_encode(UMTS__SecurityContextData_ck_descr_, p_buf, p_options);
field_ik.PER_encode(UMTS__SecurityContextData_ik_descr_, p_buf, p_options);
field_ksi.PER_encode(UMTS__SecurityContextData_ksi_descr_, p_buf, p_options);
}

void UMTS__SecurityContextData::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
field_ck.PER_decode(UMTS__SecurityContextData_ck_descr_, p_buf, p_options);
field_ik.PER_decode(UMTS__SecurityContextData_ik_descr_, p_buf, p_options);
field_ksi.PER_decode(UMTS__SecurityContextData_ksi_descr_, p_buf, p_options);
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct UMTS__SecurityContextData_template::single_value_struct {
OCTETSTRING_template field_ck;
OCTETSTRING_template field_ik;
OCTETSTRING_template field_ksi;
};

void UMTS__SecurityContextData_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_ck = ANY_VALUE;
single_value->field_ik = ANY_VALUE;
single_value->field_ksi = ANY_VALUE;
}
}
}

void UMTS__SecurityContextData_template::copy_value(const UMTS__SecurityContextData& other_value)
{
single_value = new single_value_struct;
if (other_value.ck().is_bound()) {
  single_value->field_ck = other_value.ck();
} else {
  single_value->field_ck.clean_up();
}
if (other_value.ik().is_bound()) {
  single_value->field_ik = other_value.ik();
} else {
  single_value->field_ik.clean_up();
}
if (other_value.ksi().is_bound()) {
  single_value->field_ksi = other_value.ksi();
} else {
  single_value->field_ksi.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void UMTS__SecurityContextData_template::copy_template(const UMTS__SecurityContextData_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.ck().get_selection()) {
single_value->field_ck = other_value.ck();
} else {
single_value->field_ck.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ik().get_selection()) {
single_value->field_ik = other_value.ik();
} else {
single_value->field_ik.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ksi().get_selection()) {
single_value->field_ksi = other_value.ksi();
} else {
single_value->field_ksi.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new UMTS__SecurityContextData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new UMTS__SecurityContextData_template(*other_value.implication_.precondition);
implication_.implied_template = new UMTS__SecurityContextData_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.UMTS-SecurityContextData.");
break;
}
set_selection(other_value);
}

UMTS__SecurityContextData_template::UMTS__SecurityContextData_template()
{
}

UMTS__SecurityContextData_template::UMTS__SecurityContextData_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

UMTS__SecurityContextData_template::UMTS__SecurityContextData_template(const UMTS__SecurityContextData& other_value)
{
copy_value(other_value);
}

UMTS__SecurityContextData_template::UMTS__SecurityContextData_template(const OPTIONAL<UMTS__SecurityContextData>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UMTS__SecurityContextData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.UMTS-SecurityContextData from an unbound optional field.");
}
}

UMTS__SecurityContextData_template::UMTS__SecurityContextData_template(UMTS__SecurityContextData_template* p_precondition, UMTS__SecurityContextData_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

UMTS__SecurityContextData_template::UMTS__SecurityContextData_template(Dynamic_Match_Interface<UMTS__SecurityContextData>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<UMTS__SecurityContextData>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

UMTS__SecurityContextData_template::UMTS__SecurityContextData_template(const UMTS__SecurityContextData_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

UMTS__SecurityContextData_template::~UMTS__SecurityContextData_template()
{
clean_up();
}

UMTS__SecurityContextData_template& UMTS__SecurityContextData_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

UMTS__SecurityContextData_template& UMTS__SecurityContextData_template::operator=(const UMTS__SecurityContextData& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

UMTS__SecurityContextData_template& UMTS__SecurityContextData_template::operator=(const OPTIONAL<UMTS__SecurityContextData>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UMTS__SecurityContextData&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.UMTS-SecurityContextData.");
}
return *this;
}

UMTS__SecurityContextData_template& UMTS__SecurityContextData_template::operator=(const UMTS__SecurityContextData_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean UMTS__SecurityContextData_template::match(const UMTS__SecurityContextData& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.ck().is_bound()) return FALSE;
if(!single_value->field_ck.match(other_value.ck(), legacy))return FALSE;
if(!other_value.ik().is_bound()) return FALSE;
if(!single_value->field_ik.match(other_value.ik(), legacy))return FALSE;
if(!other_value.ksi().is_bound()) return FALSE;
if(!single_value->field_ksi.match(other_value.ksi(), legacy))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.UMTS-SecurityContextData.");
}
return FALSE;
}

boolean UMTS__SecurityContextData_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_ck.is_bound()
 || single_value->field_ik.is_bound()
 || single_value->field_ksi.is_bound();
}

boolean UMTS__SecurityContextData_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_ck.is_value()
 && single_value->field_ik.is_value()
 && single_value->field_ksi.is_value();
}

void UMTS__SecurityContextData_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

UMTS__SecurityContextData UMTS__SecurityContextData_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.UMTS-SecurityContextData.");
UMTS__SecurityContextData ret_val;
if (single_value->field_ck.is_bound()) {
ret_val.ck() = single_value->field_ck.valueof();
}
if (single_value->field_ik.is_bound()) {
ret_val.ik() = single_value->field_ik.valueof();
}
if (single_value->field_ksi.is_bound()) {
ret_val.ksi() = single_value->field_ksi.valueof();
}
return ret_val;
}

void UMTS__SecurityContextData_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.UMTS-SecurityContextData.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new UMTS__SecurityContextData_template[list_length];
}

UMTS__SecurityContextData_template& UMTS__SecurityContextData_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.UMTS-SecurityContextData.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.UMTS-SecurityContextData.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& UMTS__SecurityContextData_template::ck()
{
set_specific();
return single_value->field_ck;
}

const OCTETSTRING_template& UMTS__SecurityContextData_template::ck() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ck of a non-specific template of type @MAP-MS-DataTypes.UMTS-SecurityContextData.");
return single_value->field_ck;
}

OCTETSTRING_template& UMTS__SecurityContextData_template::ik()
{
set_specific();
return single_value->field_ik;
}

const OCTETSTRING_template& UMTS__SecurityContextData_template::ik() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ik of a non-specific template of type @MAP-MS-DataTypes.UMTS-SecurityContextData.");
return single_value->field_ik;
}

OCTETSTRING_template& UMTS__SecurityContextData_template::ksi()
{
set_specific();
return single_value->field_ksi;
}

const OCTETSTRING_template& UMTS__SecurityContextData_template::ksi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ksi of a non-specific template of type @MAP-MS-DataTypes.UMTS-SecurityContextData.");
return single_value->field_ksi;
}

int UMTS__SecurityContextData_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.UMTS-SecurityContextData which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
    return 3;
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.UMTS-SecurityContextData containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.UMTS-SecurityContextData containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.UMTS-SecurityContextData containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.UMTS-SecurityContextData containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.UMTS-SecurityContextData containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.UMTS-SecurityContextData containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.UMTS-SecurityContextData containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.UMTS-SecurityContextData containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.UMTS-SecurityContextData.");
  }
  return 0;
}

void UMTS__SecurityContextData_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ ck := ");
single_value->field_ck.log();
TTCN_Logger::log_event_str(", ik := ");
single_value->field_ik.log();
TTCN_Logger::log_event_str(", ksi := ");
single_value->field_ksi.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void UMTS__SecurityContextData_template::log_match(const UMTS__SecurityContextData& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_ck.match(match_value.ck(), legacy)){
TTCN_Logger::log_logmatch_info(".ck");
single_value->field_ck.log_match(match_value.ck(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ik.match(match_value.ik(), legacy)){
TTCN_Logger::log_logmatch_info(".ik");
single_value->field_ik.log_match(match_value.ik(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_ksi.match(match_value.ksi(), legacy)){
TTCN_Logger::log_logmatch_info(".ksi");
single_value->field_ksi.log_match(match_value.ksi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ ck := ");
single_value->field_ck.log_match(match_value.ck(), legacy);
TTCN_Logger::log_event_str(", ik := ");
single_value->field_ik.log_match(match_value.ik(), legacy);
TTCN_Logger::log_event_str(", ksi := ");
single_value->field_ksi.log_match(match_value.ksi(), legacy);
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void UMTS__SecurityContextData_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (ck().is_bound()) ck().set_implicit_omit();
if (ik().is_bound()) ik().set_implicit_omit();
if (ksi().is_bound()) ksi().set_implicit_omit();
}

void UMTS__SecurityContextData_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_ck.encode_text(text_buf);
single_value->field_ik.encode_text(text_buf);
single_value->field_ksi.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.UMTS-SecurityContextData.");
}
}

void UMTS__SecurityContextData_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_ck.decode_text(text_buf);
single_value->field_ik.decode_text(text_buf);
single_value->field_ksi.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new UMTS__SecurityContextData_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.UMTS-SecurityContextData.");
}
}

void UMTS__SecurityContextData_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    UMTS__SecurityContextData_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (3<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.UMTS-SecurityContextData has 3 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) ck().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) ik().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) ksi().set_param(*param.get_elem(2));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ck")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ck().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ik")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ik().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ksi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ksi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.UMTS-SecurityContextData: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    UMTS__SecurityContextData_template* precondition = new UMTS__SecurityContextData_template;
    precondition->set_param(*param.get_elem(0));
    UMTS__SecurityContextData_template* implied_template = new UMTS__SecurityContextData_template;
    implied_template->set_param(*param.get_elem(1));
    *this = UMTS__SecurityContextData_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.UMTS-SecurityContextData");
  }
  is_ifpresent = param.get_ifpresent();
}

void UMTS__SecurityContextData_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_ck.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.UMTS-SecurityContextData");
single_value->field_ik.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.UMTS-SecurityContextData");
single_value->field_ksi.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.UMTS-SecurityContextData");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.UMTS-SecurityContextData");
}

boolean UMTS__SecurityContextData_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean UMTS__SecurityContextData_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

FailureCause::FailureCause()
{
enum_value = UNBOUND_VALUE;
}

FailureCause::FailureCause(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @MAP-MS-DataTypes.FailureCause with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

FailureCause::FailureCause(enum_type other_value)
{
enum_value = other_value;
}

FailureCause::FailureCause(const FailureCause& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @MAP-MS-DataTypes.FailureCause.");
enum_value = other_value.enum_value;
}

FailureCause& FailureCause::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @MAP-MS-DataTypes.FailureCause.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

FailureCause& FailureCause::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

FailureCause& FailureCause::operator=(const FailureCause& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @MAP-MS-DataTypes.FailureCause.");
enum_value = other_value.enum_value;
return *this;
}

boolean FailureCause::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.FailureCause.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @MAP-MS-DataTypes.FailureCause comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean FailureCause::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.FailureCause.");
return enum_value == other_value;
}

boolean FailureCause::operator==(const FailureCause& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.FailureCause.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.FailureCause.");
return enum_value == other_value.enum_value;
}

boolean FailureCause::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.FailureCause.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @MAP-MS-DataTypes.FailureCause comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean FailureCause::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.FailureCause.");
return enum_value < other_value;
}

boolean FailureCause::operator<(const FailureCause& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.FailureCause.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.FailureCause.");
return enum_value < other_value.enum_value;
}

boolean FailureCause::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.FailureCause.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @MAP-MS-DataTypes.FailureCause comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean FailureCause::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.FailureCause.");
return enum_value > other_value;
}

boolean FailureCause::operator>(const FailureCause& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.FailureCause.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.FailureCause.");
return enum_value > other_value.enum_value;
}

const char *FailureCause::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case wrongUserResponse: return "wrongUserResponse";
case wrongNetworkSignature: return "wrongNetworkSignature";
default:
return "<unknown>";
}
}

FailureCause::enum_type FailureCause::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "wrongUserResponse")) return wrongUserResponse;
if (!strcmp(str_par, "wrongNetworkSignature")) return wrongNetworkSignature;
}
return UNKNOWN_VALUE;
}

boolean FailureCause::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
return TRUE;
default:
return FALSE;
}
}

int FailureCause::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @MAP-MS-DataTypes.FailureCause.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int FailureCause::enum2int(const FailureCause& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @MAP-MS-DataTypes.FailureCause.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void FailureCause::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @MAP-MS-DataTypes.FailureCause.", int_val);
enum_value = (enum_type)int_val;
}

FailureCause::operator FailureCause::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @MAP-MS-DataTypes.FailureCause.");
return enum_value;
}

void FailureCause::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void FailureCause::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@MAP-MS-DataTypes.FailureCause");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @MAP-MS-DataTypes.FailureCause.");
  }
}

void FailureCause::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @MAP-MS-DataTypes.FailureCause.");
text_buf.push_int(enum_value);
}

void FailureCause::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @MAP-MS-DataTypes.FailureCause.", enum_value);
}

void FailureCause::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void FailureCause::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* FailureCause::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=BER_encode_chk_bound(is_bound());
  if(!new_tlv) {
    BER_encode_chk_enum_valid(p_td, is_valid_enum(enum_value), enum_value);
    new_tlv=BER_encode_TLV_INTEGER(p_coding, enum_value);
  }
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean FailureCause::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  enum_value = UNBOUND_VALUE;
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec("While decoding ENUMERATED type @MAP-MS-DataTypes.FailureCause: ");
  int tmp_mfr;
  if (BER_decode_TLV_INTEGER(stripped_tlv, L_form, tmp_mfr)) {
    BER_decode_chk_enum_valid(p_td, is_valid_enum(tmp_mfr), tmp_mfr);
    enum_value = (enum_type)tmp_mfr;
    return TRUE;
  } else return FALSE;
}

int FailureCause::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean) const
{
  if (enum_value == UNBOUND_VALUE) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of enumerated type @MAP-MS-DataTypes.FailureCause.");
    return -1;
  }

  if (p_td.json->use_null) {
    return p_tok.put_next_token(JSON_TOKEN_LITERAL_NULL);
  }
  char* tmp_str;
  if (p_td.json->as_number) {
    tmp_str = mprintf("%d", enum_value);
  }
  else {
    boolean text_found = false;
    for (size_t i = 0; i < p_td.json->nof_enum_texts; ++i) {
      if (p_td.json->enum_texts[i].index == enum_value) {
        tmp_str = mprintf("\"%s\"", p_td.json->enum_texts[i].text);
        text_found = true;
        break;
      }
    }
    if (!text_found) {
      tmp_str = mprintf("\"%s\"", enum_to_str(enum_value));
    }
  }
  int enc_len = p_tok.put_next_token(p_td.json->as_number ? JSON_TOKEN_NUMBER : JSON_TOKEN_STRING, tmp_str);
  Free(tmp_str);
  return enc_len;
}

int FailureCause::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean, int)
{
  json_token_t token = JSON_TOKEN_NONE;
  char* value = 0;
  size_t value_len = 0;
  boolean error = FALSE;
  size_t dec_len = 0;
  boolean use_default = FALSE;
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const FailureCause*>(p_td.json->default_value.val);
    return dec_len;
  }
  if (p_td.json->default_value.type == JD_LEGACY && 0 == p_tok.get_buffer_length()) {
    value = const_cast<char*>(p_td.json->default_value.str);
    value_len = strlen(value);
    use_default = TRUE;
  } else {
    dec_len = p_tok.get_next_token(&token, &value, &value_len);
  }
  if (JSON_TOKEN_ERROR == token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_LITERAL_NULL == token && p_td.json->use_null) {
    enum_value = wrongUserResponse;
  }
  else if (!p_td.json->use_null && ((JSON_TOKEN_STRING == token && !p_td.json->as_number) || use_default)) {
    if (use_default || (value_len > 2 && value[0] == '\"' && value[value_len - 1] == '\"')) {
      if (!use_default) value[value_len - 1] = 0;
      boolean text_found = false;
      for (size_t i = 0; i < p_td.json->nof_enum_texts; ++i) {
        if (strcmp(p_td.json->enum_texts[i].text, value + (use_default ? 0 : 1)) == 0) {
          enum_value = static_cast<enum_type>(p_td.json->enum_texts[i].index);
          text_found = true;
          break;
        }
      }
      if (!text_found) {
        enum_value = str_to_enum(value + (use_default ? 0 : 1));
      }
      if (!use_default) value[value_len - 1] = '\"';
      if (UNKNOWN_VALUE == enum_value) {
        error = TRUE;
      }
    } else {
      error = TRUE;
    }
  }
  else if (!p_td.json->use_null && JSON_TOKEN_NUMBER == token && p_td.json->as_number) {
    char* value_str = mcopystrn(value, value_len);
    int number = atoi(value_str);
    if (strchr(value_str, '.') != NULL || strchr(value_str, 'e') != NULL || strchr(value_str, 'E') != NULL) {
      error = TRUE;
    }
    else if (is_valid_enum(number)) {
      enum_value = static_cast<enum_type>(number);
    }
    else {
      error = TRUE;
    }
    Free(value_str);
  }
  else {
    enum_value = UNBOUND_VALUE;
    return JSON_ERROR_INVALID_TOKEN;
  }

  if (error) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FORMAT_ERROR, p_td.json->as_number ? "number" : "string", "enumerated");
    enum_value = UNBOUND_VALUE;
    return JSON_ERROR_FATAL;
  }
  return (int)dec_len;
}

int FailureCause::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (enum_value == UNBOUND_VALUE) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of enumerated type @MAP-MS-DataTypes.FailureCause.");
    return -1;
  }

  if (enum_value >= 0 && enum_value < 128) {
    char c = enum_value;
    p_buf.put_c(c);
  } else {
    INTEGER intval(enum_value);
    TTCN_Buffer buf;
    intval.OER_encode(INTEGER_descr_, buf);
    unsigned char* uc = const_cast<unsigned char*>(buf.get_data());
    *uc |= 1 << 7;
    p_buf.put_buf(buf);
  }
  return 0;
}

int FailureCause::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  if (!(uc[0] & 0x80)) {
    if (is_valid_enum(uc[0])) {
      enum_value = static_cast<enum_type>(uc[0]);
    } else {
      enum_value = UNKNOWN_VALUE;
    }
    p_buf.increase_pos(1);
  } else {
    unsigned char* uc2 = const_cast<unsigned char*>(p_buf.get_read_data());
    uc2[0] &= ~0x80;
    INTEGER intval;
    intval.OER_decode(INTEGER_descr_, p_buf, p_oer);
    if (is_valid_enum(intval.get_val().get_val())) {
      enum_value = static_cast<enum_type>(intval.get_val().get_val());
    } else {
      enum_value = UNKNOWN_VALUE;
    }
  }
  return 0;
}

void FailureCause::PER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options) const
{
INTEGER enc_val;
switch (enum_value) {
case wrongUserResponse:
enc_val = 0;
break;
case wrongNetworkSignature:
enc_val = 1;
break;
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
 "Encoding an unbound or unknown value of enumerated type @MAP-MS-DataTypes.FailureCause.");
}
INTEGER::PER_encode_int(p_buf, enc_val, 1);
}

void FailureCause::PER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options)
{
INTEGER dec_val;
dec_val.PER_decode_unaligned_constrained(p_buf, 1, FALSE);
int dec_int = dec_val;
switch (dec_int) {
case 0: enum_value = wrongUserResponse; break;
case 1: enum_value = wrongNetworkSignature; break;
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INVAL_MSG,
 "Decoded invalid number (%d) for enumerated type @MAP-MS-DataTypes.FailureCause.", dec_int);
break;
}
}

void FailureCause_template::copy_template(const FailureCause_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new FailureCause_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new FailureCause_template(*other_value.implication_.precondition);
implication_.implied_template = new FailureCause_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @MAP-MS-DataTypes.FailureCause.");
}
}

FailureCause_template::FailureCause_template()
{
}

FailureCause_template::FailureCause_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

FailureCause_template::FailureCause_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!FailureCause::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @MAP-MS-DataTypes.FailureCause with unknown numeric value %d.", other_value);
single_value = (FailureCause::enum_type)other_value;
}

FailureCause_template::FailureCause_template(FailureCause::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

FailureCause_template::FailureCause_template(const FailureCause& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == FailureCause::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @MAP-MS-DataTypes.FailureCause.");
single_value = other_value.enum_value;
}

FailureCause_template::FailureCause_template(const OPTIONAL<FailureCause>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (FailureCause::enum_type)(const FailureCause&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @MAP-MS-DataTypes.FailureCause from an unbound optional field.");
}
}

FailureCause_template::FailureCause_template(FailureCause_template* p_precondition, FailureCause_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

FailureCause_template::FailureCause_template(Dynamic_Match_Interface<FailureCause>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<FailureCause>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

FailureCause_template::FailureCause_template(const FailureCause_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

FailureCause_template::~FailureCause_template()
{
clean_up();
}

boolean FailureCause_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean FailureCause_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != FailureCause::UNBOUND_VALUE;
}

void FailureCause_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

FailureCause_template& FailureCause_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

FailureCause_template& FailureCause_template::operator=(int other_value)
{
if (!FailureCause::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @MAP-MS-DataTypes.FailureCause.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (FailureCause::enum_type)other_value;
return *this;
}

FailureCause_template& FailureCause_template::operator=(FailureCause::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

FailureCause_template& FailureCause_template::operator=(const FailureCause& other_value)
{
if (other_value.enum_value == FailureCause::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @MAP-MS-DataTypes.FailureCause to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

FailureCause_template& FailureCause_template::operator=(const OPTIONAL<FailureCause>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (FailureCause::enum_type)(const FailureCause&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @MAP-MS-DataTypes.FailureCause.");
}
return *this;
}

FailureCause_template& FailureCause_template::operator=(const FailureCause_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean FailureCause_template::match(FailureCause::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @MAP-MS-DataTypes.FailureCause.");
}
return FALSE;
}

boolean FailureCause_template::match(const FailureCause& other_value, boolean) const
{
if (other_value.enum_value == FailureCause::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @MAP-MS-DataTypes.FailureCause with an unbound value.");
return match(other_value.enum_value);
}

FailureCause::enum_type FailureCause_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @MAP-MS-DataTypes.FailureCause.");
return single_value;
}

void FailureCause_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new FailureCause_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @MAP-MS-DataTypes.FailureCause.");
}
}

FailureCause_template& FailureCause_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @MAP-MS-DataTypes.FailureCause.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @MAP-MS-DataTypes.FailureCause.");
return value_list.list_value[list_index];
}

void FailureCause_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(FailureCause::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void FailureCause_template::log_match(const FailureCause& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void FailureCause_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @MAP-MS-DataTypes.FailureCause.");
}
}

void FailureCause_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (FailureCause::enum_type)text_buf.pull_int().get_val();
if (!FailureCause::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @MAP-MS-DataTypes.FailureCause.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new FailureCause_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @MAP-MS-DataTypes.FailureCause.");
}
}

boolean FailureCause_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean FailureCause_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void FailureCause_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    FailureCause_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    FailureCause::enum_type enum_val = FailureCause::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!FailureCause::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @MAP-MS-DataTypes.FailureCause.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    FailureCause_template* precondition = new FailureCause_template;
    precondition->set_param(*m_p->get_elem(0));
    FailureCause_template* implied_template = new FailureCause_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = FailureCause_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@MAP-MS-DataTypes.FailureCause");
  }
  is_ifpresent = param.get_ifpresent();
}

void FailureCause_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.FailureCause");
}

AuthenticationFailureReportArg::AuthenticationFailureReportArg()
{
}

AuthenticationFailureReportArg::AuthenticationFailureReportArg(const OCTETSTRING& par_imsi,
    const FailureCause& par_failureCause,
    const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer,
    const OPTIONAL< BOOLEAN >& par_re__attempt,
    const OPTIONAL< AccessType >& par_accessType,
    const OPTIONAL< OCTETSTRING >& par_rand,
    const OPTIONAL< OCTETSTRING >& par_vlr__Number,
    const OPTIONAL< OCTETSTRING >& par_sgsn__Number)
  :   field_imsi(par_imsi),
  field_failureCause(par_failureCause),
  field_extensionContainer(par_extensionContainer),
  field_re__attempt(par_re__attempt),
  field_accessType(par_accessType),
  field_rand(par_rand),
  field_vlr__Number(par_vlr__Number),
  field_sgsn__Number(par_sgsn__Number)
{
}

AuthenticationFailureReportArg::AuthenticationFailureReportArg(const AuthenticationFailureReportArg& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.AuthenticationFailureReportArg.");
if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
else field_imsi.clean_up();
if (other_value.failureCause().is_bound()) field_failureCause = other_value.failureCause();
else field_failureCause.clean_up();
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
if (other_value.re__attempt().is_bound()) field_re__attempt = other_value.re__attempt();
else field_re__attempt.clean_up();
if (other_value.accessType().is_bound()) field_accessType = other_value.accessType();
else field_accessType.clean_up();
if (other_value.rand().is_bound()) field_rand = other_value.rand();
else field_rand.clean_up();
if (other_value.vlr__Number().is_bound()) field_vlr__Number = other_value.vlr__Number();
else field_vlr__Number.clean_up();
if (other_value.sgsn__Number().is_bound()) field_sgsn__Number = other_value.sgsn__Number();
else field_sgsn__Number.clean_up();
}

void AuthenticationFailureReportArg::clean_up()
{
field_imsi.clean_up();
field_failureCause.clean_up();
field_extensionContainer.clean_up();
field_re__attempt.clean_up();
field_accessType.clean_up();
field_rand.clean_up();
field_vlr__Number.clean_up();
field_sgsn__Number.clean_up();
}

const TTCN_Typedescriptor_t* AuthenticationFailureReportArg::get_descriptor() const { return &AuthenticationFailureReportArg_descr_; }
AuthenticationFailureReportArg& AuthenticationFailureReportArg::operator=(const AuthenticationFailureReportArg& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.AuthenticationFailureReportArg.");
  if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
  else field_imsi.clean_up();
  if (other_value.failureCause().is_bound()) field_failureCause = other_value.failureCause();
  else field_failureCause.clean_up();
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
  if (other_value.re__attempt().is_bound()) field_re__attempt = other_value.re__attempt();
  else field_re__attempt.clean_up();
  if (other_value.accessType().is_bound()) field_accessType = other_value.accessType();
  else field_accessType.clean_up();
  if (other_value.rand().is_bound()) field_rand = other_value.rand();
  else field_rand.clean_up();
  if (other_value.vlr__Number().is_bound()) field_vlr__Number = other_value.vlr__Number();
  else field_vlr__Number.clean_up();
  if (other_value.sgsn__Number().is_bound()) field_sgsn__Number = other_value.sgsn__Number();
  else field_sgsn__Number.clean_up();
}
return *this;
}

boolean AuthenticationFailureReportArg::operator==(const AuthenticationFailureReportArg& other_value) const
{
return field_imsi==other_value.field_imsi
  && field_failureCause==other_value.field_failureCause
  && field_extensionContainer==other_value.field_extensionContainer
  && field_re__attempt==other_value.field_re__attempt
  && field_accessType==other_value.field_accessType
  && field_rand==other_value.field_rand
  && field_vlr__Number==other_value.field_vlr__Number
  && field_sgsn__Number==other_value.field_sgsn__Number;
}

boolean AuthenticationFailureReportArg::is_bound() const
{
return (field_imsi.is_bound())
  || (field_failureCause.is_bound())
  || (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound())
  || (OPTIONAL_OMIT == field_re__attempt.get_selection() || field_re__attempt.is_bound())
  || (OPTIONAL_OMIT == field_accessType.get_selection() || field_accessType.is_bound())
  || (OPTIONAL_OMIT == field_rand.get_selection() || field_rand.is_bound())
  || (OPTIONAL_OMIT == field_vlr__Number.get_selection() || field_vlr__Number.is_bound())
  || (OPTIONAL_OMIT == field_sgsn__Number.get_selection() || field_sgsn__Number.is_bound());
}
boolean AuthenticationFailureReportArg::is_value() const
{
return field_imsi.is_value()
  && field_failureCause.is_value()
  && (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value())
  && (OPTIONAL_OMIT == field_re__attempt.get_selection() || field_re__attempt.is_value())
  && (OPTIONAL_OMIT == field_accessType.get_selection() || field_accessType.is_value())
  && (OPTIONAL_OMIT == field_rand.get_selection() || field_rand.is_value())
  && (OPTIONAL_OMIT == field_vlr__Number.get_selection() || field_vlr__Number.is_value())
  && (OPTIONAL_OMIT == field_sgsn__Number.get_selection() || field_sgsn__Number.is_value());
}
int AuthenticationFailureReportArg::size_of() const
{
  int ret_val = 2;
  if (field_extensionContainer.ispresent()) ret_val++;
  if (field_re__attempt.ispresent()) ret_val++;
  if (field_accessType.ispresent()) ret_val++;
  if (field_rand.ispresent()) ret_val++;
  if (field_vlr__Number.ispresent()) ret_val++;
  if (field_sgsn__Number.ispresent()) ret_val++;
  return ret_val;
}

void AuthenticationFailureReportArg::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ imsi := ");
field_imsi.log();
TTCN_Logger::log_event_str(", failureCause := ");
field_failureCause.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(", re_attempt := ");
field_re__attempt.log();
TTCN_Logger::log_event_str(", accessType := ");
field_accessType.log();
TTCN_Logger::log_event_str(", rand := ");
field_rand.log();
TTCN_Logger::log_event_str(", vlr_Number := ");
field_vlr__Number.log();
TTCN_Logger::log_event_str(", sgsn_Number := ");
field_sgsn__Number.log();
TTCN_Logger::log_event_str(" }");
}

void AuthenticationFailureReportArg::set_implicit_omit()
{
if (imsi().is_bound()) imsi().set_implicit_omit();
if (failureCause().is_bound()) failureCause().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!re__attempt().is_bound()) re__attempt() = OMIT_VALUE;
else re__attempt().set_implicit_omit();
if (!accessType().is_bound()) accessType() = OMIT_VALUE;
else accessType().set_implicit_omit();
if (!rand().is_bound()) rand() = OMIT_VALUE;
else rand().set_implicit_omit();
if (!vlr__Number().is_bound()) vlr__Number() = OMIT_VALUE;
else vlr__Number().set_implicit_omit();
if (!sgsn__Number().is_bound()) sgsn__Number() = OMIT_VALUE;
else sgsn__Number().set_implicit_omit();
}

void AuthenticationFailureReportArg::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.AuthenticationFailureReportArg has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) imsi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) failureCause().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) re__attempt().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) accessType().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) rand().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) vlr__Number().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) sgsn__Number().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "failureCause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          failureCause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "re_attempt")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          re__attempt().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "accessType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          accessType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rand")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rand().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vlr_Number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vlr__Number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sgsn_Number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sgsn__Number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.AuthenticationFailureReportArg: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.AuthenticationFailureReportArg");
  }
}

void AuthenticationFailureReportArg::encode_text(Text_Buf& text_buf) const
{
field_imsi.encode_text(text_buf);
field_failureCause.encode_text(text_buf);
field_extensionContainer.encode_text(text_buf);
field_re__attempt.encode_text(text_buf);
field_accessType.encode_text(text_buf);
field_rand.encode_text(text_buf);
field_vlr__Number.encode_text(text_buf);
field_sgsn__Number.encode_text(text_buf);
}

void AuthenticationFailureReportArg::decode_text(Text_Buf& text_buf)
{
field_imsi.decode_text(text_buf);
field_failureCause.decode_text(text_buf);
field_extensionContainer.decode_text(text_buf);
field_re__attempt.decode_text(text_buf);
field_accessType.decode_text(text_buf);
field_rand.decode_text(text_buf);
field_vlr__Number.decode_text(text_buf);
field_sgsn__Number.decode_text(text_buf);
}

void AuthenticationFailureReportArg::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void AuthenticationFailureReportArg::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* AuthenticationFailureReportArg::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("imsi': ");
  new_tlv->add_TLV(field_imsi.BER_encode_TLV(MAP__CommonDataTypes::IMSI_descr_, p_coding));
  ec_1.set_msg("failureCause': ");
  new_tlv->add_TLV(field_failureCause.BER_encode_TLV(FailureCause_descr_, p_coding));
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(AuthenticationFailureReportArg_extensionContainer_descr_, p_coding));
  ec_1.set_msg("re_attempt': ");
  new_tlv->add_TLV(field_re__attempt.BER_encode_TLV(BOOLEAN_descr_, p_coding));
  ec_1.set_msg("accessType': ");
  new_tlv->add_TLV(field_accessType.BER_encode_TLV(AccessType_descr_, p_coding));
  ec_1.set_msg("rand': ");
  new_tlv->add_TLV(field_rand.BER_encode_TLV(AuthenticationFailureReportArg_rand_descr_, p_coding));
  ec_1.set_msg("vlr_Number': ");
  new_tlv->add_TLV(field_vlr__Number.BER_encode_TLV(AuthenticationFailureReportArg_vlr__Number_descr_, p_coding));
  ec_1.set_msg("sgsn_Number': ");
  new_tlv->add_TLV(field_sgsn__Number.BER_encode_TLV(AuthenticationFailureReportArg_sgsn__Number_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean AuthenticationFailureReportArg::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.AuthenticationFailureReportArg' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("imsi': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_imsi.BER_decode_TLV(MAP__CommonDataTypes::IMSI_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("failureCause': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_failureCause.BER_decode_TLV(FailureCause_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(AuthenticationFailureReportArg_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("re_attempt': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_re__attempt=OMIT_VALUE;
    else {
      field_re__attempt.BER_decode_TLV(BOOLEAN_descr_, tmp_tlv, L_form);
      if(field_re__attempt.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("accessType': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_accessType=OMIT_VALUE;
    else {
      field_accessType.BER_decode_TLV(AccessType_descr_, tmp_tlv, L_form);
      if(field_accessType.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("rand': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_rand=OMIT_VALUE;
    else {
      field_rand.BER_decode_TLV(AuthenticationFailureReportArg_rand_descr_, tmp_tlv, L_form);
      if(field_rand.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("vlr_Number': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_vlr__Number=OMIT_VALUE;
    else {
      field_vlr__Number.BER_decode_TLV(AuthenticationFailureReportArg_vlr__Number_descr_, tmp_tlv, L_form);
      if(field_vlr__Number.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("sgsn_Number': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_sgsn__Number=OMIT_VALUE;
    else {
      field_sgsn__Number.BER_decode_TLV(AuthenticationFailureReportArg_sgsn__Number_descr_, tmp_tlv, L_form);
      if(field_sgsn__Number.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int AuthenticationFailureReportArg::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.AuthenticationFailureReportArg.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "imsi");
    enc_len += field_imsi.JSON_encode(MAP__CommonDataTypes::IMSI_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "failureCause");
    enc_len += field_failureCause.JSON_encode(FailureCause_descr_, p_tok, FALSE);
  }

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(AuthenticationFailureReportArg_extensionContainer_descr_, p_tok, FALSE);
  }

  if (field_re__attempt.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "re_attempt");
    enc_len += field_re__attempt.JSON_encode(BOOLEAN_descr_, p_tok, FALSE);
  }

  if (field_accessType.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "accessType");
    enc_len += field_accessType.JSON_encode(AccessType_descr_, p_tok, FALSE);
  }

  if (field_rand.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "rand");
    enc_len += field_rand.JSON_encode(AuthenticationFailureReportArg_rand_descr_, p_tok, FALSE);
  }

  if (field_vlr__Number.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "vlr_Number");
    enc_len += field_vlr__Number.JSON_encode(AuthenticationFailureReportArg_vlr__Number_descr_, p_tok, FALSE);
  }

  if (field_sgsn__Number.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "sgsn_Number");
    enc_len += field_sgsn__Number.JSON_encode(AuthenticationFailureReportArg_sgsn__Number_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int AuthenticationFailureReportArg::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const AuthenticationFailureReportArg*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean imsi_found = FALSE;
  boolean failureCause_found = FALSE;
  boolean extensionContainer_found = FALSE;
  boolean re__attempt_found = FALSE;
  boolean accessType_found = FALSE;
  boolean rand_found = FALSE;
  boolean vlr__Number_found = FALSE;
  boolean sgsn__Number_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (4 == name_len && 0 == strncmp(fld_name, "imsi", name_len)) {
        imsi_found = TRUE;
         int ret_val = field_imsi.JSON_decode(MAP__CommonDataTypes::IMSI_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 4, "imsi");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (12 == name_len && 0 == strncmp(fld_name, "failureCause", name_len)) {
        failureCause_found = TRUE;
         int ret_val = field_failureCause.JSON_decode(FailureCause_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 12, "failureCause");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(AuthenticationFailureReportArg_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (10 == name_len && 0 == strncmp(fld_name, "re_attempt", name_len)) {
        re__attempt_found = TRUE;
         int ret_val = field_re__attempt.JSON_decode(BOOLEAN_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 10, "re_attempt");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (10 == name_len && 0 == strncmp(fld_name, "accessType", name_len)) {
        accessType_found = TRUE;
         int ret_val = field_accessType.JSON_decode(AccessType_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 10, "accessType");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (4 == name_len && 0 == strncmp(fld_name, "rand", name_len)) {
        rand_found = TRUE;
         int ret_val = field_rand.JSON_decode(AuthenticationFailureReportArg_rand_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 4, "rand");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (10 == name_len && 0 == strncmp(fld_name, "vlr_Number", name_len)) {
        vlr__Number_found = TRUE;
         int ret_val = field_vlr__Number.JSON_decode(AuthenticationFailureReportArg_vlr__Number_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 10, "vlr_Number");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (11 == name_len && 0 == strncmp(fld_name, "sgsn_Number", name_len)) {
        sgsn__Number_found = TRUE;
         int ret_val = field_sgsn__Number.JSON_decode(AuthenticationFailureReportArg_sgsn__Number_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 11, "sgsn_Number");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!imsi_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "imsi");
    return JSON_ERROR_FATAL;
  }
  if (!failureCause_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "failureCause");
    return JSON_ERROR_FATAL;
  }
  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  if (!re__attempt_found) {
    field_re__attempt = OMIT_VALUE;
  }
  if (!accessType_found) {
    field_accessType = OMIT_VALUE;
  }
  if (!rand_found) {
    field_rand = OMIT_VALUE;
  }
  if (!vlr__Number_found) {
    field_vlr__Number = OMIT_VALUE;
  }
  if (!sgsn__Number_found) {
    field_sgsn__Number = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int AuthenticationFailureReportArg::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  boolean has_extension = FALSE;
  has_extension = has_extension || (field_re__attempt.is_bound() && field_re__attempt.is_present());
  has_extension = has_extension || (field_accessType.is_bound() && field_accessType.is_present());
  has_extension = has_extension || (field_rand.is_bound() && field_rand.is_present());
  has_extension = has_extension || (field_vlr__Number.is_bound() && field_vlr__Number.is_present());
  has_extension = has_extension || (field_sgsn__Number.is_bound() && field_sgsn__Number.is_present());
  char c = 0;
  if (has_extension) {
    c |= 128;
  }
  if (field_extensionContainer.is_present()) {
    c |= 64;
  }
  p_buf.put_c(c);
  field_imsi.OER_encode(MAP__CommonDataTypes::IMSI_descr_, p_buf);
  field_failureCause.OER_encode(FailureCause_descr_, p_buf);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(AuthenticationFailureReportArg_extensionContainer_descr_, p_buf);
  if (has_extension) {
    TTCN_Buffer tmp_buf;
    TTCN_Buffer tmp_buf2;
    TTCN_Buffer tmp_buf3;
    c = 0;
    if (field_re__attempt.is_present()) {
      c |= 128;
      field_re__attempt.OER_encode(BOOLEAN_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_accessType.is_present()) {
      c |= 64;
      field_accessType.OER_encode(AccessType_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_rand.is_present()) {
      c |= 32;
      field_rand.OER_encode(AuthenticationFailureReportArg_rand_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_vlr__Number.is_present()) {
      c |= 16;
      field_vlr__Number.OER_encode(AuthenticationFailureReportArg_vlr__Number_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_sgsn__Number.is_present()) {
      c |= 8;
      field_sgsn__Number.OER_encode(AuthenticationFailureReportArg_sgsn__Number_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    tmp_buf3.put_c(c);
    encode_oer_length(2, p_buf, FALSE);
    p_buf.put_c(3);
    p_buf.put_buf(tmp_buf3);
    p_buf.put_buf(tmp_buf);
    tmp_buf.clear();
  }
  return 0;
}

int AuthenticationFailureReportArg::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_imsi.OER_decode(MAP__CommonDataTypes::IMSI_descr_, p_buf, p_oer);
  field_failureCause.OER_decode(FailureCause_descr_, p_buf, p_oer);
  if (uc[0] & 64)
    field_extensionContainer.OER_decode(AuthenticationFailureReportArg_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
    if (!(uc[0] & 128)) {
      field_re__attempt = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_re__attempt.OER_decode(BOOLEAN_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 64)) {
      field_accessType = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_accessType.OER_decode(AccessType_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 32)) {
      field_rand = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_rand.OER_decode(AuthenticationFailureReportArg_rand_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 16)) {
      field_vlr__Number = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_vlr__Number.OER_decode(AuthenticationFailureReportArg_vlr__Number_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 8)) {
      field_sgsn__Number = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_sgsn__Number.OER_decode(AuthenticationFailureReportArg_sgsn__Number_descr_, p_buf, p_oer);
    }
  }
  else {
    field_re__attempt = OMIT_VALUE;
    field_accessType = OMIT_VALUE;
    field_rand = OMIT_VALUE;
    field_vlr__Number = OMIT_VALUE;
    field_sgsn__Number = OMIT_VALUE;
  }
  return 0;
}

void AuthenticationFailureReportArg::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_0_present = field_re__attempt.is_present();
boolean ext_1_present = field_accessType.is_present();
boolean ext_2_present = field_rand.is_present();
boolean ext_3_present = field_vlr__Number.is_present();
boolean ext_4_present = field_sgsn__Number.is_present();
boolean ext_bit = ext_0_present || ext_1_present || ext_2_present || ext_3_present || ext_4_present;
p_buf.PER_put_bit(ext_bit);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
field_imsi.PER_encode(MAP__CommonDataTypes::IMSI_descr_, p_buf, p_options);
field_failureCause.PER_encode(FailureCause_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(AuthenticationFailureReportArg_extensionContainer_descr_, p_buf, p_options);
if (ext_bit) {
INTEGER length_(5);
length_.PER_encode_length(p_buf, p_options, TRUE);
p_buf.PER_put_bit(ext_0_present);
p_buf.PER_put_bit(ext_1_present);
p_buf.PER_put_bit(ext_2_present);
p_buf.PER_put_bit(ext_3_present);
p_buf.PER_put_bit(ext_4_present);
if (ext_0_present) {
TTCN_Buffer ext_add_buf;
field_re__attempt.PER_encode(BOOLEAN_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_1_present) {
TTCN_Buffer ext_add_buf;
field_accessType.PER_encode(AccessType_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_2_present) {
TTCN_Buffer ext_add_buf;
field_rand.PER_encode(AuthenticationFailureReportArg_rand_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_3_present) {
TTCN_Buffer ext_add_buf;
field_vlr__Number.PER_encode(AuthenticationFailureReportArg_vlr__Number_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_4_present) {
TTCN_Buffer ext_add_buf;
field_sgsn__Number.PER_encode(AuthenticationFailureReportArg_sgsn__Number_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
}
}

void AuthenticationFailureReportArg::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
field_imsi.PER_decode(MAP__CommonDataTypes::IMSI_descr_, p_buf, p_options);
field_failureCause.PER_decode(FailureCause_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_decode(AuthenticationFailureReportArg_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
if (nof_decoded_ext_adds < 5) {
for (int i = nof_decoded_ext_adds; i < 5; ++i) {
ext_presences.push_back(FALSE);
}
}
if (ext_presences[0]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_re__attempt.PER_decode(BOOLEAN_descr_, ext_add_buf, p_options);
}
else {
field_re__attempt = OMIT_VALUE;
}
if (ext_presences[1]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_accessType.PER_decode(AccessType_descr_, ext_add_buf, p_options);
}
else {
field_accessType = OMIT_VALUE;
}
if (ext_presences[2]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_rand.PER_decode(AuthenticationFailureReportArg_rand_descr_, ext_add_buf, p_options);
}
else {
field_rand = OMIT_VALUE;
}
if (ext_presences[3]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_vlr__Number.PER_decode(AuthenticationFailureReportArg_vlr__Number_descr_, ext_add_buf, p_options);
}
else {
field_vlr__Number = OMIT_VALUE;
}
if (ext_presences[4]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_sgsn__Number.PER_decode(AuthenticationFailureReportArg_sgsn__Number_descr_, ext_add_buf, p_options);
}
else {
field_sgsn__Number = OMIT_VALUE;
}
if (nof_decoded_ext_adds > 5) for (int i = 5; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct AuthenticationFailureReportArg_template::single_value_struct {
OCTETSTRING_template field_imsi;
FailureCause_template field_failureCause;
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
BOOLEAN_template field_re__attempt;
AccessType_template field_accessType;
OCTETSTRING_template field_rand;
OCTETSTRING_template field_vlr__Number;
OCTETSTRING_template field_sgsn__Number;
};

void AuthenticationFailureReportArg_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_imsi = ANY_VALUE;
single_value->field_failureCause = ANY_VALUE;
single_value->field_extensionContainer = ANY_OR_OMIT;
single_value->field_re__attempt = ANY_OR_OMIT;
single_value->field_accessType = ANY_OR_OMIT;
single_value->field_rand = ANY_OR_OMIT;
single_value->field_vlr__Number = ANY_OR_OMIT;
single_value->field_sgsn__Number = ANY_OR_OMIT;
}
}
}

void AuthenticationFailureReportArg_template::copy_value(const AuthenticationFailureReportArg& other_value)
{
single_value = new single_value_struct;
if (other_value.imsi().is_bound()) {
  single_value->field_imsi = other_value.imsi();
} else {
  single_value->field_imsi.clean_up();
}
if (other_value.failureCause().is_bound()) {
  single_value->field_failureCause = other_value.failureCause();
} else {
  single_value->field_failureCause.clean_up();
}
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
if (other_value.re__attempt().is_bound()) {
  if (other_value.re__attempt().ispresent()) single_value->field_re__attempt = other_value.re__attempt()();
  else single_value->field_re__attempt = OMIT_VALUE;
} else {
  single_value->field_re__attempt.clean_up();
}
if (other_value.accessType().is_bound()) {
  if (other_value.accessType().ispresent()) single_value->field_accessType = other_value.accessType()();
  else single_value->field_accessType = OMIT_VALUE;
} else {
  single_value->field_accessType.clean_up();
}
if (other_value.rand().is_bound()) {
  if (other_value.rand().ispresent()) single_value->field_rand = other_value.rand()();
  else single_value->field_rand = OMIT_VALUE;
} else {
  single_value->field_rand.clean_up();
}
if (other_value.vlr__Number().is_bound()) {
  if (other_value.vlr__Number().ispresent()) single_value->field_vlr__Number = other_value.vlr__Number()();
  else single_value->field_vlr__Number = OMIT_VALUE;
} else {
  single_value->field_vlr__Number.clean_up();
}
if (other_value.sgsn__Number().is_bound()) {
  if (other_value.sgsn__Number().ispresent()) single_value->field_sgsn__Number = other_value.sgsn__Number()();
  else single_value->field_sgsn__Number = OMIT_VALUE;
} else {
  single_value->field_sgsn__Number.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void AuthenticationFailureReportArg_template::copy_template(const AuthenticationFailureReportArg_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.imsi().get_selection()) {
single_value->field_imsi = other_value.imsi();
} else {
single_value->field_imsi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.failureCause().get_selection()) {
single_value->field_failureCause = other_value.failureCause();
} else {
single_value->field_failureCause.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.re__attempt().get_selection()) {
single_value->field_re__attempt = other_value.re__attempt();
} else {
single_value->field_re__attempt.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.accessType().get_selection()) {
single_value->field_accessType = other_value.accessType();
} else {
single_value->field_accessType.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.rand().get_selection()) {
single_value->field_rand = other_value.rand();
} else {
single_value->field_rand.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.vlr__Number().get_selection()) {
single_value->field_vlr__Number = other_value.vlr__Number();
} else {
single_value->field_vlr__Number.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sgsn__Number().get_selection()) {
single_value->field_sgsn__Number = other_value.sgsn__Number();
} else {
single_value->field_sgsn__Number.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new AuthenticationFailureReportArg_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new AuthenticationFailureReportArg_template(*other_value.implication_.precondition);
implication_.implied_template = new AuthenticationFailureReportArg_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg.");
break;
}
set_selection(other_value);
}

AuthenticationFailureReportArg_template::AuthenticationFailureReportArg_template()
{
}

AuthenticationFailureReportArg_template::AuthenticationFailureReportArg_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

AuthenticationFailureReportArg_template::AuthenticationFailureReportArg_template(const AuthenticationFailureReportArg& other_value)
{
copy_value(other_value);
}

AuthenticationFailureReportArg_template::AuthenticationFailureReportArg_template(const OPTIONAL<AuthenticationFailureReportArg>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const AuthenticationFailureReportArg&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg from an unbound optional field.");
}
}

AuthenticationFailureReportArg_template::AuthenticationFailureReportArg_template(AuthenticationFailureReportArg_template* p_precondition, AuthenticationFailureReportArg_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

AuthenticationFailureReportArg_template::AuthenticationFailureReportArg_template(Dynamic_Match_Interface<AuthenticationFailureReportArg>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<AuthenticationFailureReportArg>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

AuthenticationFailureReportArg_template::AuthenticationFailureReportArg_template(const AuthenticationFailureReportArg_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

AuthenticationFailureReportArg_template::~AuthenticationFailureReportArg_template()
{
clean_up();
}

AuthenticationFailureReportArg_template& AuthenticationFailureReportArg_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

AuthenticationFailureReportArg_template& AuthenticationFailureReportArg_template::operator=(const AuthenticationFailureReportArg& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

AuthenticationFailureReportArg_template& AuthenticationFailureReportArg_template::operator=(const OPTIONAL<AuthenticationFailureReportArg>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const AuthenticationFailureReportArg&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg.");
}
return *this;
}

AuthenticationFailureReportArg_template& AuthenticationFailureReportArg_template::operator=(const AuthenticationFailureReportArg_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean AuthenticationFailureReportArg_template::match(const AuthenticationFailureReportArg& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.imsi().is_bound()) return FALSE;
if(!single_value->field_imsi.match(other_value.imsi(), legacy))return FALSE;
if(!other_value.failureCause().is_bound()) return FALSE;
if(!single_value->field_failureCause.match(other_value.failureCause(), legacy))return FALSE;
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
if(!other_value.re__attempt().is_bound()) return FALSE;
if((other_value.re__attempt().ispresent() ? !single_value->field_re__attempt.match((const BOOLEAN&)other_value.re__attempt(), legacy) : !single_value->field_re__attempt.match_omit(legacy)))return FALSE;
if(!other_value.accessType().is_bound()) return FALSE;
if((other_value.accessType().ispresent() ? !single_value->field_accessType.match((const AccessType&)other_value.accessType(), legacy) : !single_value->field_accessType.match_omit(legacy)))return FALSE;
if(!other_value.rand().is_bound()) return FALSE;
if((other_value.rand().ispresent() ? !single_value->field_rand.match((const OCTETSTRING&)other_value.rand(), legacy) : !single_value->field_rand.match_omit(legacy)))return FALSE;
if(!other_value.vlr__Number().is_bound()) return FALSE;
if((other_value.vlr__Number().ispresent() ? !single_value->field_vlr__Number.match((const OCTETSTRING&)other_value.vlr__Number(), legacy) : !single_value->field_vlr__Number.match_omit(legacy)))return FALSE;
if(!other_value.sgsn__Number().is_bound()) return FALSE;
if((other_value.sgsn__Number().ispresent() ? !single_value->field_sgsn__Number.match((const OCTETSTRING&)other_value.sgsn__Number(), legacy) : !single_value->field_sgsn__Number.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg.");
}
return FALSE;
}

boolean AuthenticationFailureReportArg_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_imsi.is_bound()
 || single_value->field_failureCause.is_bound()
 || (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound())
 || (single_value->field_re__attempt.is_omit() || single_value->field_re__attempt.is_bound())
 || (single_value->field_accessType.is_omit() || single_value->field_accessType.is_bound())
 || (single_value->field_rand.is_omit() || single_value->field_rand.is_bound())
 || (single_value->field_vlr__Number.is_omit() || single_value->field_vlr__Number.is_bound())
 || (single_value->field_sgsn__Number.is_omit() || single_value->field_sgsn__Number.is_bound());
}

boolean AuthenticationFailureReportArg_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_imsi.is_value()
 && single_value->field_failureCause.is_value()
 && (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value())
 && (single_value->field_re__attempt.is_omit() || single_value->field_re__attempt.is_value())
 && (single_value->field_accessType.is_omit() || single_value->field_accessType.is_value())
 && (single_value->field_rand.is_omit() || single_value->field_rand.is_value())
 && (single_value->field_vlr__Number.is_omit() || single_value->field_vlr__Number.is_value())
 && (single_value->field_sgsn__Number.is_omit() || single_value->field_sgsn__Number.is_value());
}

void AuthenticationFailureReportArg_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

AuthenticationFailureReportArg AuthenticationFailureReportArg_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg.");
AuthenticationFailureReportArg ret_val;
if (single_value->field_imsi.is_bound()) {
ret_val.imsi() = single_value->field_imsi.valueof();
}
if (single_value->field_failureCause.is_bound()) {
ret_val.failureCause() = single_value->field_failureCause.valueof();
}
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
if (single_value->field_re__attempt.is_omit()) ret_val.re__attempt() = OMIT_VALUE;
else if (single_value->field_re__attempt.is_bound()) {
ret_val.re__attempt() = single_value->field_re__attempt.valueof();
}
if (single_value->field_accessType.is_omit()) ret_val.accessType() = OMIT_VALUE;
else if (single_value->field_accessType.is_bound()) {
ret_val.accessType() = single_value->field_accessType.valueof();
}
if (single_value->field_rand.is_omit()) ret_val.rand() = OMIT_VALUE;
else if (single_value->field_rand.is_bound()) {
ret_val.rand() = single_value->field_rand.valueof();
}
if (single_value->field_vlr__Number.is_omit()) ret_val.vlr__Number() = OMIT_VALUE;
else if (single_value->field_vlr__Number.is_bound()) {
ret_val.vlr__Number() = single_value->field_vlr__Number.valueof();
}
if (single_value->field_sgsn__Number.is_omit()) ret_val.sgsn__Number() = OMIT_VALUE;
else if (single_value->field_sgsn__Number.is_bound()) {
ret_val.sgsn__Number() = single_value->field_sgsn__Number.valueof();
}
return ret_val;
}

void AuthenticationFailureReportArg_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new AuthenticationFailureReportArg_template[list_length];
}

AuthenticationFailureReportArg_template& AuthenticationFailureReportArg_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& AuthenticationFailureReportArg_template::imsi()
{
set_specific();
return single_value->field_imsi;
}

const OCTETSTRING_template& AuthenticationFailureReportArg_template::imsi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field imsi of a non-specific template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg.");
return single_value->field_imsi;
}

FailureCause_template& AuthenticationFailureReportArg_template::failureCause()
{
set_specific();
return single_value->field_failureCause;
}

const FailureCause_template& AuthenticationFailureReportArg_template::failureCause() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field failureCause of a non-specific template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg.");
return single_value->field_failureCause;
}

MAP__ExtensionDataTypes::ExtensionContainer_template& AuthenticationFailureReportArg_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& AuthenticationFailureReportArg_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg.");
return single_value->field_extensionContainer;
}

BOOLEAN_template& AuthenticationFailureReportArg_template::re__attempt()
{
set_specific();
return single_value->field_re__attempt;
}

const BOOLEAN_template& AuthenticationFailureReportArg_template::re__attempt() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field re_attempt of a non-specific template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg.");
return single_value->field_re__attempt;
}

AccessType_template& AuthenticationFailureReportArg_template::accessType()
{
set_specific();
return single_value->field_accessType;
}

const AccessType_template& AuthenticationFailureReportArg_template::accessType() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field accessType of a non-specific template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg.");
return single_value->field_accessType;
}

OCTETSTRING_template& AuthenticationFailureReportArg_template::rand()
{
set_specific();
return single_value->field_rand;
}

const OCTETSTRING_template& AuthenticationFailureReportArg_template::rand() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field rand of a non-specific template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg.");
return single_value->field_rand;
}

OCTETSTRING_template& AuthenticationFailureReportArg_template::vlr__Number()
{
set_specific();
return single_value->field_vlr__Number;
}

const OCTETSTRING_template& AuthenticationFailureReportArg_template::vlr__Number() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field vlr_Number of a non-specific template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg.");
return single_value->field_vlr__Number;
}

OCTETSTRING_template& AuthenticationFailureReportArg_template::sgsn__Number()
{
set_specific();
return single_value->field_sgsn__Number;
}

const OCTETSTRING_template& AuthenticationFailureReportArg_template::sgsn__Number() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sgsn_Number of a non-specific template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg.");
return single_value->field_sgsn__Number;
}

int AuthenticationFailureReportArg_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 2;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      if (single_value->field_re__attempt.is_present()) ret_val++;
      if (single_value->field_accessType.is_present()) ret_val++;
      if (single_value->field_rand.is_present()) ret_val++;
      if (single_value->field_vlr__Number.is_present()) ret_val++;
      if (single_value->field_sgsn__Number.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg.");
  }
  return 0;
}

void AuthenticationFailureReportArg_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ imsi := ");
single_value->field_imsi.log();
TTCN_Logger::log_event_str(", failureCause := ");
single_value->field_failureCause.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(", re_attempt := ");
single_value->field_re__attempt.log();
TTCN_Logger::log_event_str(", accessType := ");
single_value->field_accessType.log();
TTCN_Logger::log_event_str(", rand := ");
single_value->field_rand.log();
TTCN_Logger::log_event_str(", vlr_Number := ");
single_value->field_vlr__Number.log();
TTCN_Logger::log_event_str(", sgsn_Number := ");
single_value->field_sgsn__Number.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void AuthenticationFailureReportArg_template::log_match(const AuthenticationFailureReportArg& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_imsi.match(match_value.imsi(), legacy)){
TTCN_Logger::log_logmatch_info(".imsi");
single_value->field_imsi.log_match(match_value.imsi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_failureCause.match(match_value.failureCause(), legacy)){
TTCN_Logger::log_logmatch_info(".failureCause");
single_value->field_failureCause.log_match(match_value.failureCause(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.re__attempt().ispresent()){
if(!single_value->field_re__attempt.match(match_value.re__attempt(), legacy)){
TTCN_Logger::log_logmatch_info(".re_attempt");
single_value->field_re__attempt.log_match(match_value.re__attempt(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_re__attempt.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".re_attempt := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_re__attempt.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.accessType().ispresent()){
if(!single_value->field_accessType.match(match_value.accessType(), legacy)){
TTCN_Logger::log_logmatch_info(".accessType");
single_value->field_accessType.log_match(match_value.accessType(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_accessType.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".accessType := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_accessType.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.rand().ispresent()){
if(!single_value->field_rand.match(match_value.rand(), legacy)){
TTCN_Logger::log_logmatch_info(".rand");
single_value->field_rand.log_match(match_value.rand(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_rand.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".rand := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_rand.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.vlr__Number().ispresent()){
if(!single_value->field_vlr__Number.match(match_value.vlr__Number(), legacy)){
TTCN_Logger::log_logmatch_info(".vlr_Number");
single_value->field_vlr__Number.log_match(match_value.vlr__Number(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_vlr__Number.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".vlr_Number := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_vlr__Number.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.sgsn__Number().ispresent()){
if(!single_value->field_sgsn__Number.match(match_value.sgsn__Number(), legacy)){
TTCN_Logger::log_logmatch_info(".sgsn_Number");
single_value->field_sgsn__Number.log_match(match_value.sgsn__Number(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_sgsn__Number.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".sgsn_Number := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_sgsn__Number.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ imsi := ");
single_value->field_imsi.log_match(match_value.imsi(), legacy);
TTCN_Logger::log_event_str(", failureCause := ");
single_value->field_failureCause.log_match(match_value.failureCause(), legacy);
TTCN_Logger::log_event_str(", extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", re_attempt := ");
if (match_value.re__attempt().ispresent()) {
single_value->field_re__attempt.log_match(match_value.re__attempt(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_re__attempt.log();
if (single_value->field_re__attempt.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", accessType := ");
if (match_value.accessType().ispresent()) {
single_value->field_accessType.log_match(match_value.accessType(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_accessType.log();
if (single_value->field_accessType.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", rand := ");
if (match_value.rand().ispresent()) {
single_value->field_rand.log_match(match_value.rand(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_rand.log();
if (single_value->field_rand.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", vlr_Number := ");
if (match_value.vlr__Number().ispresent()) {
single_value->field_vlr__Number.log_match(match_value.vlr__Number(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_vlr__Number.log();
if (single_value->field_vlr__Number.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", sgsn_Number := ");
if (match_value.sgsn__Number().ispresent()) {
single_value->field_sgsn__Number.log_match(match_value.sgsn__Number(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_sgsn__Number.log();
if (single_value->field_sgsn__Number.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void AuthenticationFailureReportArg_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (imsi().is_bound()) imsi().set_implicit_omit();
if (failureCause().is_bound()) failureCause().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!re__attempt().is_bound()) re__attempt() = OMIT_VALUE;
else re__attempt().set_implicit_omit();
if (!accessType().is_bound()) accessType() = OMIT_VALUE;
else accessType().set_implicit_omit();
if (!rand().is_bound()) rand() = OMIT_VALUE;
else rand().set_implicit_omit();
if (!vlr__Number().is_bound()) vlr__Number() = OMIT_VALUE;
else vlr__Number().set_implicit_omit();
if (!sgsn__Number().is_bound()) sgsn__Number() = OMIT_VALUE;
else sgsn__Number().set_implicit_omit();
}

void AuthenticationFailureReportArg_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_imsi.encode_text(text_buf);
single_value->field_failureCause.encode_text(text_buf);
single_value->field_extensionContainer.encode_text(text_buf);
single_value->field_re__attempt.encode_text(text_buf);
single_value->field_accessType.encode_text(text_buf);
single_value->field_rand.encode_text(text_buf);
single_value->field_vlr__Number.encode_text(text_buf);
single_value->field_sgsn__Number.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg.");
}
}

void AuthenticationFailureReportArg_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_imsi.decode_text(text_buf);
single_value->field_failureCause.decode_text(text_buf);
single_value->field_extensionContainer.decode_text(text_buf);
single_value->field_re__attempt.decode_text(text_buf);
single_value->field_accessType.decode_text(text_buf);
single_value->field_rand.decode_text(text_buf);
single_value->field_vlr__Number.decode_text(text_buf);
single_value->field_sgsn__Number.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new AuthenticationFailureReportArg_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg.");
}
}

void AuthenticationFailureReportArg_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    AuthenticationFailureReportArg_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (8<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.AuthenticationFailureReportArg has 8 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) imsi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) failureCause().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) re__attempt().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) accessType().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) rand().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) vlr__Number().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) sgsn__Number().set_param(*param.get_elem(7));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "failureCause")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          failureCause().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "re_attempt")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          re__attempt().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "accessType")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          accessType().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "rand")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          rand().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "vlr_Number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          vlr__Number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sgsn_Number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sgsn__Number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.AuthenticationFailureReportArg: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    AuthenticationFailureReportArg_template* precondition = new AuthenticationFailureReportArg_template;
    precondition->set_param(*param.get_elem(0));
    AuthenticationFailureReportArg_template* implied_template = new AuthenticationFailureReportArg_template;
    implied_template->set_param(*param.get_elem(1));
    *this = AuthenticationFailureReportArg_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.AuthenticationFailureReportArg");
  }
  is_ifpresent = param.get_ifpresent();
}

void AuthenticationFailureReportArg_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_imsi.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AuthenticationFailureReportArg");
single_value->field_failureCause.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AuthenticationFailureReportArg");
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AuthenticationFailureReportArg");
single_value->field_re__attempt.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AuthenticationFailureReportArg");
single_value->field_accessType.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AuthenticationFailureReportArg");
single_value->field_rand.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AuthenticationFailureReportArg");
single_value->field_vlr__Number.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AuthenticationFailureReportArg");
single_value->field_sgsn__Number.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AuthenticationFailureReportArg");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.AuthenticationFailureReportArg");
}

boolean AuthenticationFailureReportArg_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean AuthenticationFailureReportArg_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

AccessType::AccessType()
{
enum_value = UNBOUND_VALUE;
}

AccessType::AccessType(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @MAP-MS-DataTypes.AccessType with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

AccessType::AccessType(enum_type other_value)
{
enum_value = other_value;
}

AccessType::AccessType(const AccessType& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @MAP-MS-DataTypes.AccessType.");
enum_value = other_value.enum_value;
}

AccessType& AccessType::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @MAP-MS-DataTypes.AccessType.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

AccessType& AccessType::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

AccessType& AccessType::operator=(const AccessType& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @MAP-MS-DataTypes.AccessType.");
enum_value = other_value.enum_value;
return *this;
}

boolean AccessType::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.AccessType.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @MAP-MS-DataTypes.AccessType comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean AccessType::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.AccessType.");
return enum_value == other_value;
}

boolean AccessType::operator==(const AccessType& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.AccessType.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.AccessType.");
return enum_value == other_value.enum_value;
}

boolean AccessType::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.AccessType.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @MAP-MS-DataTypes.AccessType comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean AccessType::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.AccessType.");
return enum_value < other_value;
}

boolean AccessType::operator<(const AccessType& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.AccessType.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.AccessType.");
return enum_value < other_value.enum_value;
}

boolean AccessType::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.AccessType.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @MAP-MS-DataTypes.AccessType comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean AccessType::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.AccessType.");
return enum_value > other_value;
}

boolean AccessType::operator>(const AccessType& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.AccessType.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.AccessType.");
return enum_value > other_value.enum_value;
}

const char *AccessType::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case call__: return "call_";
case emergencyCall: return "emergencyCall";
case locationUpdating: return "locationUpdating";
case supplementaryService: return "supplementaryService";
case shortMessage: return "shortMessage";
case gprsAttach: return "gprsAttach";
case routingAreaUpdating: return "routingAreaUpdating";
case serviceRequest: return "serviceRequest";
case pdpContextActivation: return "pdpContextActivation";
case pdpContextDeactivation: return "pdpContextDeactivation";
case gprsDetach: return "gprsDetach";
default:
return "<unknown>";
}
}

AccessType::enum_type AccessType::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "call_")) return call__;
if (!strcmp(str_par, "emergencyCall")) return emergencyCall;
if (!strcmp(str_par, "locationUpdating")) return locationUpdating;
if (!strcmp(str_par, "supplementaryService")) return supplementaryService;
if (!strcmp(str_par, "shortMessage")) return shortMessage;
if (!strcmp(str_par, "gprsAttach")) return gprsAttach;
if (!strcmp(str_par, "routingAreaUpdating")) return routingAreaUpdating;
if (!strcmp(str_par, "serviceRequest")) return serviceRequest;
if (!strcmp(str_par, "pdpContextActivation")) return pdpContextActivation;
if (!strcmp(str_par, "pdpContextDeactivation")) return pdpContextDeactivation;
if (!strcmp(str_par, "gprsDetach")) return gprsDetach;
}
return UNKNOWN_VALUE;
}

boolean AccessType::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
case 4:
case 5:
case 6:
case 7:
case 8:
case 9:
case 10:
return TRUE;
default:
return FALSE;
}
}

int AccessType::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @MAP-MS-DataTypes.AccessType.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int AccessType::enum2int(const AccessType& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @MAP-MS-DataTypes.AccessType.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void AccessType::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @MAP-MS-DataTypes.AccessType.", int_val);
enum_value = (enum_type)int_val;
}

AccessType::operator AccessType::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @MAP-MS-DataTypes.AccessType.");
return enum_value;
}

void AccessType::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void AccessType::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@MAP-MS-DataTypes.AccessType");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @MAP-MS-DataTypes.AccessType.");
  }
}

void AccessType::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @MAP-MS-DataTypes.AccessType.");
text_buf.push_int(enum_value);
}

void AccessType::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @MAP-MS-DataTypes.AccessType.", enum_value);
}

void AccessType::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void AccessType::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* AccessType::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=BER_encode_chk_bound(is_bound());
  if(!new_tlv) {
    BER_encode_chk_enum_valid(p_td, is_valid_enum(enum_value), enum_value);
    new_tlv=BER_encode_TLV_INTEGER(p_coding, enum_value);
  }
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean AccessType::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  enum_value = UNBOUND_VALUE;
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec("While decoding ENUMERATED type @MAP-MS-DataTypes.AccessType: ");
  int tmp_mfr;
  if (BER_decode_TLV_INTEGER(stripped_tlv, L_form, tmp_mfr)) {
    BER_decode_chk_enum_valid(p_td, is_valid_enum(tmp_mfr), tmp_mfr);
    enum_value = (enum_type)tmp_mfr;
    return TRUE;
  } else return FALSE;
}

int AccessType::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean) const
{
  if (enum_value == UNBOUND_VALUE) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of enumerated type @MAP-MS-DataTypes.AccessType.");
    return -1;
  }

  if (p_td.json->use_null) {
    return p_tok.put_next_token(JSON_TOKEN_LITERAL_NULL);
  }
  char* tmp_str;
  if (p_td.json->as_number) {
    tmp_str = mprintf("%d", enum_value);
  }
  else {
    boolean text_found = false;
    for (size_t i = 0; i < p_td.json->nof_enum_texts; ++i) {
      if (p_td.json->enum_texts[i].index == enum_value) {
        tmp_str = mprintf("\"%s\"", p_td.json->enum_texts[i].text);
        text_found = true;
        break;
      }
    }
    if (!text_found) {
      tmp_str = mprintf("\"%s\"", enum_to_str(enum_value));
    }
  }
  int enc_len = p_tok.put_next_token(p_td.json->as_number ? JSON_TOKEN_NUMBER : JSON_TOKEN_STRING, tmp_str);
  Free(tmp_str);
  return enc_len;
}

int AccessType::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean, int)
{
  json_token_t token = JSON_TOKEN_NONE;
  char* value = 0;
  size_t value_len = 0;
  boolean error = FALSE;
  size_t dec_len = 0;
  boolean use_default = FALSE;
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const AccessType*>(p_td.json->default_value.val);
    return dec_len;
  }
  if (p_td.json->default_value.type == JD_LEGACY && 0 == p_tok.get_buffer_length()) {
    value = const_cast<char*>(p_td.json->default_value.str);
    value_len = strlen(value);
    use_default = TRUE;
  } else {
    dec_len = p_tok.get_next_token(&token, &value, &value_len);
  }
  if (JSON_TOKEN_ERROR == token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_LITERAL_NULL == token && p_td.json->use_null) {
    enum_value = call__;
  }
  else if (!p_td.json->use_null && ((JSON_TOKEN_STRING == token && !p_td.json->as_number) || use_default)) {
    if (use_default || (value_len > 2 && value[0] == '\"' && value[value_len - 1] == '\"')) {
      if (!use_default) value[value_len - 1] = 0;
      boolean text_found = false;
      for (size_t i = 0; i < p_td.json->nof_enum_texts; ++i) {
        if (strcmp(p_td.json->enum_texts[i].text, value + (use_default ? 0 : 1)) == 0) {
          enum_value = static_cast<enum_type>(p_td.json->enum_texts[i].index);
          text_found = true;
          break;
        }
      }
      if (!text_found) {
        enum_value = str_to_enum(value + (use_default ? 0 : 1));
      }
      if (!use_default) value[value_len - 1] = '\"';
      if (UNKNOWN_VALUE == enum_value) {
        error = TRUE;
      }
    } else {
      error = TRUE;
    }
  }
  else if (!p_td.json->use_null && JSON_TOKEN_NUMBER == token && p_td.json->as_number) {
    char* value_str = mcopystrn(value, value_len);
    int number = atoi(value_str);
    if (strchr(value_str, '.') != NULL || strchr(value_str, 'e') != NULL || strchr(value_str, 'E') != NULL) {
      error = TRUE;
    }
    else if (is_valid_enum(number)) {
      enum_value = static_cast<enum_type>(number);
    }
    else {
      error = TRUE;
    }
    Free(value_str);
  }
  else {
    enum_value = UNBOUND_VALUE;
    return JSON_ERROR_INVALID_TOKEN;
  }

  if (error) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FORMAT_ERROR, p_td.json->as_number ? "number" : "string", "enumerated");
    enum_value = UNBOUND_VALUE;
    return JSON_ERROR_FATAL;
  }
  return (int)dec_len;
}

int AccessType::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (enum_value == UNBOUND_VALUE) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of enumerated type @MAP-MS-DataTypes.AccessType.");
    return -1;
  }

  if (enum_value >= 0 && enum_value < 128) {
    char c = enum_value;
    p_buf.put_c(c);
  } else {
    INTEGER intval(enum_value);
    TTCN_Buffer buf;
    intval.OER_encode(INTEGER_descr_, buf);
    unsigned char* uc = const_cast<unsigned char*>(buf.get_data());
    *uc |= 1 << 7;
    p_buf.put_buf(buf);
  }
  return 0;
}

int AccessType::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  if (!(uc[0] & 0x80)) {
    if (is_valid_enum(uc[0])) {
      enum_value = static_cast<enum_type>(uc[0]);
    } else {
      enum_value = UNKNOWN_VALUE;
    }
    p_buf.increase_pos(1);
  } else {
    unsigned char* uc2 = const_cast<unsigned char*>(p_buf.get_read_data());
    uc2[0] &= ~0x80;
    INTEGER intval;
    intval.OER_decode(INTEGER_descr_, p_buf, p_oer);
    if (is_valid_enum(intval.get_val().get_val())) {
      enum_value = static_cast<enum_type>(intval.get_val().get_val());
    } else {
      enum_value = UNKNOWN_VALUE;
    }
  }
  return 0;
}

void AccessType::PER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options) const
{
INTEGER enc_val;
boolean ext_bit = FALSE;
switch (enum_value) {
case call__:
enc_val = 0;
ext_bit = FALSE;
break;
case emergencyCall:
enc_val = 1;
ext_bit = FALSE;
break;
case locationUpdating:
enc_val = 2;
ext_bit = FALSE;
break;
case supplementaryService:
enc_val = 3;
ext_bit = FALSE;
break;
case shortMessage:
enc_val = 4;
ext_bit = FALSE;
break;
case gprsAttach:
enc_val = 5;
ext_bit = FALSE;
break;
case routingAreaUpdating:
enc_val = 6;
ext_bit = FALSE;
break;
case serviceRequest:
enc_val = 7;
ext_bit = FALSE;
break;
case pdpContextActivation:
enc_val = 8;
ext_bit = FALSE;
break;
case pdpContextDeactivation:
enc_val = 9;
ext_bit = FALSE;
break;
case gprsDetach:
enc_val = 0;
ext_bit = TRUE;
break;
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
 "Encoding an unbound or unknown value of enumerated type @MAP-MS-DataTypes.AccessType.");
}
p_buf.PER_put_bit(ext_bit);
if (ext_bit) enc_val.PER_encode_normally_small(p_buf, p_options);
else INTEGER::PER_encode_int(p_buf, enc_val, 4);
}

void AccessType::PER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options)
{
INTEGER dec_val;
boolean ext_bit = p_buf.PER_get_bit();
if (ext_bit) dec_val.PER_decode_normally_small(p_buf, p_options);
else dec_val.PER_decode_unaligned_constrained(p_buf, 4, FALSE);
int dec_int = dec_val;
if (ext_bit) switch (dec_int) {
case 0: enum_value = gprsDetach; break;
default: enum_value = UNBOUND_VALUE; break;
}
else switch (dec_int) {
case 0: enum_value = call__; break;
case 1: enum_value = emergencyCall; break;
case 2: enum_value = locationUpdating; break;
case 3: enum_value = supplementaryService; break;
case 4: enum_value = shortMessage; break;
case 5: enum_value = gprsAttach; break;
case 6: enum_value = routingAreaUpdating; break;
case 7: enum_value = serviceRequest; break;
case 8: enum_value = pdpContextActivation; break;
case 9: enum_value = pdpContextDeactivation; break;
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INVAL_MSG,
 "Decoded invalid number (%d) for enumerated type @MAP-MS-DataTypes.AccessType.", dec_int);
break;
}
}

void AccessType_template::copy_template(const AccessType_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new AccessType_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new AccessType_template(*other_value.implication_.precondition);
implication_.implied_template = new AccessType_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @MAP-MS-DataTypes.AccessType.");
}
}

AccessType_template::AccessType_template()
{
}

AccessType_template::AccessType_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

AccessType_template::AccessType_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!AccessType::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @MAP-MS-DataTypes.AccessType with unknown numeric value %d.", other_value);
single_value = (AccessType::enum_type)other_value;
}

AccessType_template::AccessType_template(AccessType::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

AccessType_template::AccessType_template(const AccessType& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == AccessType::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @MAP-MS-DataTypes.AccessType.");
single_value = other_value.enum_value;
}

AccessType_template::AccessType_template(const OPTIONAL<AccessType>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (AccessType::enum_type)(const AccessType&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @MAP-MS-DataTypes.AccessType from an unbound optional field.");
}
}

AccessType_template::AccessType_template(AccessType_template* p_precondition, AccessType_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

AccessType_template::AccessType_template(Dynamic_Match_Interface<AccessType>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<AccessType>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

AccessType_template::AccessType_template(const AccessType_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

AccessType_template::~AccessType_template()
{
clean_up();
}

boolean AccessType_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean AccessType_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != AccessType::UNBOUND_VALUE;
}

void AccessType_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

AccessType_template& AccessType_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

AccessType_template& AccessType_template::operator=(int other_value)
{
if (!AccessType::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @MAP-MS-DataTypes.AccessType.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (AccessType::enum_type)other_value;
return *this;
}

AccessType_template& AccessType_template::operator=(AccessType::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

AccessType_template& AccessType_template::operator=(const AccessType& other_value)
{
if (other_value.enum_value == AccessType::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @MAP-MS-DataTypes.AccessType to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

AccessType_template& AccessType_template::operator=(const OPTIONAL<AccessType>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (AccessType::enum_type)(const AccessType&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @MAP-MS-DataTypes.AccessType.");
}
return *this;
}

AccessType_template& AccessType_template::operator=(const AccessType_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean AccessType_template::match(AccessType::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @MAP-MS-DataTypes.AccessType.");
}
return FALSE;
}

boolean AccessType_template::match(const AccessType& other_value, boolean) const
{
if (other_value.enum_value == AccessType::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @MAP-MS-DataTypes.AccessType with an unbound value.");
return match(other_value.enum_value);
}

AccessType::enum_type AccessType_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @MAP-MS-DataTypes.AccessType.");
return single_value;
}

void AccessType_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new AccessType_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @MAP-MS-DataTypes.AccessType.");
}
}

AccessType_template& AccessType_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @MAP-MS-DataTypes.AccessType.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @MAP-MS-DataTypes.AccessType.");
return value_list.list_value[list_index];
}

void AccessType_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(AccessType::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void AccessType_template::log_match(const AccessType& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void AccessType_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @MAP-MS-DataTypes.AccessType.");
}
}

void AccessType_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (AccessType::enum_type)text_buf.pull_int().get_val();
if (!AccessType::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @MAP-MS-DataTypes.AccessType.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new AccessType_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @MAP-MS-DataTypes.AccessType.");
}
}

boolean AccessType_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean AccessType_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void AccessType_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    AccessType_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    AccessType::enum_type enum_val = AccessType::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!AccessType::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @MAP-MS-DataTypes.AccessType.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    AccessType_template* precondition = new AccessType_template;
    precondition->set_param(*m_p->get_elem(0));
    AccessType_template* implied_template = new AccessType_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = AccessType_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@MAP-MS-DataTypes.AccessType");
  }
  is_ifpresent = param.get_ifpresent();
}

void AccessType_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.AccessType");
}

AuthenticationFailureReportRes::AuthenticationFailureReportRes()
{
}

AuthenticationFailureReportRes::AuthenticationFailureReportRes(const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer)
  :   field_extensionContainer(par_extensionContainer)
{
}

AuthenticationFailureReportRes::AuthenticationFailureReportRes(const AuthenticationFailureReportRes& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.AuthenticationFailureReportRes.");
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
}

void AuthenticationFailureReportRes::clean_up()
{
field_extensionContainer.clean_up();
}

const TTCN_Typedescriptor_t* AuthenticationFailureReportRes::get_descriptor() const { return &AuthenticationFailureReportRes_descr_; }
AuthenticationFailureReportRes& AuthenticationFailureReportRes::operator=(const AuthenticationFailureReportRes& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.AuthenticationFailureReportRes.");
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
}
return *this;
}

boolean AuthenticationFailureReportRes::operator==(const AuthenticationFailureReportRes& other_value) const
{
return field_extensionContainer==other_value.field_extensionContainer;
}

boolean AuthenticationFailureReportRes::is_bound() const
{
return (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound());
}
boolean AuthenticationFailureReportRes::is_value() const
{
return (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value());
}
int AuthenticationFailureReportRes::size_of() const
{
  int ret_val = 0;
  if (field_extensionContainer.ispresent()) ret_val++;
  return ret_val;
}

void AuthenticationFailureReportRes::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
}

void AuthenticationFailureReportRes::set_implicit_omit()
{
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void AuthenticationFailureReportRes::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.AuthenticationFailureReportRes has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.AuthenticationFailureReportRes: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.AuthenticationFailureReportRes");
  }
}

void AuthenticationFailureReportRes::encode_text(Text_Buf& text_buf) const
{
field_extensionContainer.encode_text(text_buf);
}

void AuthenticationFailureReportRes::decode_text(Text_Buf& text_buf)
{
field_extensionContainer.decode_text(text_buf);
}

void AuthenticationFailureReportRes::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void AuthenticationFailureReportRes::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* AuthenticationFailureReportRes::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(AuthenticationFailureReportRes_extensionContainer_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean AuthenticationFailureReportRes::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.AuthenticationFailureReportRes' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(AuthenticationFailureReportRes_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int AuthenticationFailureReportRes::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.AuthenticationFailureReportRes.");
    return -1;
  }

  if (p_td.json->as_value) {
   if (field_extensionContainer == OMIT_VALUE) {
     return p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL) + 
       p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
   }
   return field_extensionContainer.JSON_encode(AuthenticationFailureReportRes_extensionContainer_descr_, p_tok, FALSE);
  }
  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(AuthenticationFailureReportRes_extensionContainer_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int AuthenticationFailureReportRes::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const AuthenticationFailureReportRes*>(p_td.json->default_value.val);
    return 0;
  }
  if (p_td.json->as_value) {
   json_token_t j_token = JSON_TOKEN_NONE;
   size_t buf_pos = p_tok.get_buf_pos();
   size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
   if (j_token == JSON_TOKEN_LITERAL_NULL) {
     return JSON_ERROR_FATAL;
   }
   else if (j_token == JSON_TOKEN_OBJECT_START) {
     dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
     if (j_token == JSON_TOKEN_OBJECT_END) {
       field_extensionContainer = OMIT_VALUE;
       return dec_len;
     }
   }
   p_tok.set_buf_pos(buf_pos);
   return field_extensionContainer.JSON_decode(AuthenticationFailureReportRes_extensionContainer_descr_, p_tok, p_silent, FALSE);
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean extensionContainer_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(AuthenticationFailureReportRes_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int AuthenticationFailureReportRes::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_extensionContainer.is_present()) {
    c |= 64;
  }
  p_buf.put_c(c);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(AuthenticationFailureReportRes_extensionContainer_descr_, p_buf);
  return 0;
}

int AuthenticationFailureReportRes::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  if (uc[0] & 64)
    field_extensionContainer.OER_decode(AuthenticationFailureReportRes_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void AuthenticationFailureReportRes::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(AuthenticationFailureReportRes_extensionContainer_descr_, p_buf, p_options);
}

void AuthenticationFailureReportRes::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
if (field_extensionContainer_present) field_extensionContainer.PER_decode(AuthenticationFailureReportRes_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct AuthenticationFailureReportRes_template::single_value_struct {
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
};

void AuthenticationFailureReportRes_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_extensionContainer = ANY_OR_OMIT;
}
}
}

void AuthenticationFailureReportRes_template::copy_value(const AuthenticationFailureReportRes& other_value)
{
single_value = new single_value_struct;
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void AuthenticationFailureReportRes_template::copy_template(const AuthenticationFailureReportRes_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new AuthenticationFailureReportRes_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new AuthenticationFailureReportRes_template(*other_value.implication_.precondition);
implication_.implied_template = new AuthenticationFailureReportRes_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.AuthenticationFailureReportRes.");
break;
}
set_selection(other_value);
}

AuthenticationFailureReportRes_template::AuthenticationFailureReportRes_template()
{
}

AuthenticationFailureReportRes_template::AuthenticationFailureReportRes_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

AuthenticationFailureReportRes_template::AuthenticationFailureReportRes_template(const AuthenticationFailureReportRes& other_value)
{
copy_value(other_value);
}

AuthenticationFailureReportRes_template::AuthenticationFailureReportRes_template(const OPTIONAL<AuthenticationFailureReportRes>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const AuthenticationFailureReportRes&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.AuthenticationFailureReportRes from an unbound optional field.");
}
}

AuthenticationFailureReportRes_template::AuthenticationFailureReportRes_template(AuthenticationFailureReportRes_template* p_precondition, AuthenticationFailureReportRes_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

AuthenticationFailureReportRes_template::AuthenticationFailureReportRes_template(Dynamic_Match_Interface<AuthenticationFailureReportRes>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<AuthenticationFailureReportRes>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

AuthenticationFailureReportRes_template::AuthenticationFailureReportRes_template(const AuthenticationFailureReportRes_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

AuthenticationFailureReportRes_template::~AuthenticationFailureReportRes_template()
{
clean_up();
}

AuthenticationFailureReportRes_template& AuthenticationFailureReportRes_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

AuthenticationFailureReportRes_template& AuthenticationFailureReportRes_template::operator=(const AuthenticationFailureReportRes& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

AuthenticationFailureReportRes_template& AuthenticationFailureReportRes_template::operator=(const OPTIONAL<AuthenticationFailureReportRes>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const AuthenticationFailureReportRes&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.AuthenticationFailureReportRes.");
}
return *this;
}

AuthenticationFailureReportRes_template& AuthenticationFailureReportRes_template::operator=(const AuthenticationFailureReportRes_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean AuthenticationFailureReportRes_template::match(const AuthenticationFailureReportRes& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.AuthenticationFailureReportRes.");
}
return FALSE;
}

boolean AuthenticationFailureReportRes_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound());
}

boolean AuthenticationFailureReportRes_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value());
}

void AuthenticationFailureReportRes_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

AuthenticationFailureReportRes AuthenticationFailureReportRes_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.AuthenticationFailureReportRes.");
AuthenticationFailureReportRes ret_val;
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
return ret_val;
}

void AuthenticationFailureReportRes_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.AuthenticationFailureReportRes.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new AuthenticationFailureReportRes_template[list_length];
}

AuthenticationFailureReportRes_template& AuthenticationFailureReportRes_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.AuthenticationFailureReportRes.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.AuthenticationFailureReportRes.");
return value_list.list_value[list_index];
}

MAP__ExtensionDataTypes::ExtensionContainer_template& AuthenticationFailureReportRes_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& AuthenticationFailureReportRes_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-MS-DataTypes.AuthenticationFailureReportRes.");
return single_value->field_extensionContainer;
}

int AuthenticationFailureReportRes_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationFailureReportRes which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 0;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationFailureReportRes containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationFailureReportRes containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationFailureReportRes containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationFailureReportRes containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationFailureReportRes containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationFailureReportRes containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationFailureReportRes containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.AuthenticationFailureReportRes containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.AuthenticationFailureReportRes.");
  }
  return 0;
}

void AuthenticationFailureReportRes_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void AuthenticationFailureReportRes_template::log_match(const AuthenticationFailureReportRes& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void AuthenticationFailureReportRes_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void AuthenticationFailureReportRes_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_extensionContainer.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.AuthenticationFailureReportRes.");
}
}

void AuthenticationFailureReportRes_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_extensionContainer.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new AuthenticationFailureReportRes_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.AuthenticationFailureReportRes.");
}
}

void AuthenticationFailureReportRes_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    AuthenticationFailureReportRes_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (1<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.AuthenticationFailureReportRes has 1 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(0));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.AuthenticationFailureReportRes: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    AuthenticationFailureReportRes_template* precondition = new AuthenticationFailureReportRes_template;
    precondition->set_param(*param.get_elem(0));
    AuthenticationFailureReportRes_template* implied_template = new AuthenticationFailureReportRes_template;
    implied_template->set_param(*param.get_elem(1));
    *this = AuthenticationFailureReportRes_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.AuthenticationFailureReportRes");
  }
  is_ifpresent = param.get_ifpresent();
}

void AuthenticationFailureReportRes_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.AuthenticationFailureReportRes");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.AuthenticationFailureReportRes");
}

boolean AuthenticationFailureReportRes_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean AuthenticationFailureReportRes_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

UpdateGprsLocationArg::UpdateGprsLocationArg()
{
}

UpdateGprsLocationArg::UpdateGprsLocationArg(const OCTETSTRING& par_imsi,
    const OCTETSTRING& par_sgsn__Number,
    const OCTETSTRING& par_sgsn__Address,
    const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer,
    const OPTIONAL< SGSN__Capability >& par_sgsn__Capability,
    const OPTIONAL< ASN_NULL >& par_informPreviousNetworkEntity,
    const OPTIONAL< ASN_NULL >& par_ps__LCS__NotSupportedByUE,
    const OPTIONAL< OCTETSTRING >& par_v__gmlc__Address,
    const OPTIONAL< ADD__Info >& par_add__info,
    const OPTIONAL< EPS__Info >& par_eps__info,
    const OPTIONAL< ASN_NULL >& par_servingNodeTypeIndicator,
    const OPTIONAL< ASN_NULL >& par_skipSubscriberDataUpdate,
    const OPTIONAL< Used__RAT__Type >& par_usedRAT__Type,
    const OPTIONAL< ASN_NULL >& par_gprsSubscriptionDataNotNeeded,
    const OPTIONAL< ASN_NULL >& par_nodeTypeIndicator,
    const OPTIONAL< ASN_NULL >& par_areaRestricted,
    const OPTIONAL< ASN_NULL >& par_ue__reachableIndicator,
    const OPTIONAL< ASN_NULL >& par_epsSubscriptionDataNotNeeded,
    const OPTIONAL< UE__SRVCC__Capability >& par_ue__srvcc__Capability)
  :   field_imsi(par_imsi),
  field_sgsn__Number(par_sgsn__Number),
  field_sgsn__Address(par_sgsn__Address),
  field_extensionContainer(par_extensionContainer),
  field_sgsn__Capability(par_sgsn__Capability),
  field_informPreviousNetworkEntity(par_informPreviousNetworkEntity),
  field_ps__LCS__NotSupportedByUE(par_ps__LCS__NotSupportedByUE),
  field_v__gmlc__Address(par_v__gmlc__Address),
  field_add__info(par_add__info),
  field_eps__info(par_eps__info),
  field_servingNodeTypeIndicator(par_servingNodeTypeIndicator),
  field_skipSubscriberDataUpdate(par_skipSubscriberDataUpdate),
  field_usedRAT__Type(par_usedRAT__Type),
  field_gprsSubscriptionDataNotNeeded(par_gprsSubscriptionDataNotNeeded),
  field_nodeTypeIndicator(par_nodeTypeIndicator),
  field_areaRestricted(par_areaRestricted),
  field_ue__reachableIndicator(par_ue__reachableIndicator),
  field_epsSubscriptionDataNotNeeded(par_epsSubscriptionDataNotNeeded),
  field_ue__srvcc__Capability(par_ue__srvcc__Capability)
{
}

UpdateGprsLocationArg::UpdateGprsLocationArg(const UpdateGprsLocationArg& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
else field_imsi.clean_up();
if (other_value.sgsn__Number().is_bound()) field_sgsn__Number = other_value.sgsn__Number();
else field_sgsn__Number.clean_up();
if (other_value.sgsn__Address().is_bound()) field_sgsn__Address = other_value.sgsn__Address();
else field_sgsn__Address.clean_up();
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
if (other_value.sgsn__Capability().is_bound()) field_sgsn__Capability = other_value.sgsn__Capability();
else field_sgsn__Capability.clean_up();
if (other_value.informPreviousNetworkEntity().is_bound()) field_informPreviousNetworkEntity = other_value.informPreviousNetworkEntity();
else field_informPreviousNetworkEntity.clean_up();
if (other_value.ps__LCS__NotSupportedByUE().is_bound()) field_ps__LCS__NotSupportedByUE = other_value.ps__LCS__NotSupportedByUE();
else field_ps__LCS__NotSupportedByUE.clean_up();
if (other_value.v__gmlc__Address().is_bound()) field_v__gmlc__Address = other_value.v__gmlc__Address();
else field_v__gmlc__Address.clean_up();
if (other_value.add__info().is_bound()) field_add__info = other_value.add__info();
else field_add__info.clean_up();
if (other_value.eps__info().is_bound()) field_eps__info = other_value.eps__info();
else field_eps__info.clean_up();
if (other_value.servingNodeTypeIndicator().is_bound()) field_servingNodeTypeIndicator = other_value.servingNodeTypeIndicator();
else field_servingNodeTypeIndicator.clean_up();
if (other_value.skipSubscriberDataUpdate().is_bound()) field_skipSubscriberDataUpdate = other_value.skipSubscriberDataUpdate();
else field_skipSubscriberDataUpdate.clean_up();
if (other_value.usedRAT__Type().is_bound()) field_usedRAT__Type = other_value.usedRAT__Type();
else field_usedRAT__Type.clean_up();
if (other_value.gprsSubscriptionDataNotNeeded().is_bound()) field_gprsSubscriptionDataNotNeeded = other_value.gprsSubscriptionDataNotNeeded();
else field_gprsSubscriptionDataNotNeeded.clean_up();
if (other_value.nodeTypeIndicator().is_bound()) field_nodeTypeIndicator = other_value.nodeTypeIndicator();
else field_nodeTypeIndicator.clean_up();
if (other_value.areaRestricted().is_bound()) field_areaRestricted = other_value.areaRestricted();
else field_areaRestricted.clean_up();
if (other_value.ue__reachableIndicator().is_bound()) field_ue__reachableIndicator = other_value.ue__reachableIndicator();
else field_ue__reachableIndicator.clean_up();
if (other_value.epsSubscriptionDataNotNeeded().is_bound()) field_epsSubscriptionDataNotNeeded = other_value.epsSubscriptionDataNotNeeded();
else field_epsSubscriptionDataNotNeeded.clean_up();
if (other_value.ue__srvcc__Capability().is_bound()) field_ue__srvcc__Capability = other_value.ue__srvcc__Capability();
else field_ue__srvcc__Capability.clean_up();
}

void UpdateGprsLocationArg::clean_up()
{
field_imsi.clean_up();
field_sgsn__Number.clean_up();
field_sgsn__Address.clean_up();
field_extensionContainer.clean_up();
field_sgsn__Capability.clean_up();
field_informPreviousNetworkEntity.clean_up();
field_ps__LCS__NotSupportedByUE.clean_up();
field_v__gmlc__Address.clean_up();
field_add__info.clean_up();
field_eps__info.clean_up();
field_servingNodeTypeIndicator.clean_up();
field_skipSubscriberDataUpdate.clean_up();
field_usedRAT__Type.clean_up();
field_gprsSubscriptionDataNotNeeded.clean_up();
field_nodeTypeIndicator.clean_up();
field_areaRestricted.clean_up();
field_ue__reachableIndicator.clean_up();
field_epsSubscriptionDataNotNeeded.clean_up();
field_ue__srvcc__Capability.clean_up();
}

const TTCN_Typedescriptor_t* UpdateGprsLocationArg::get_descriptor() const { return &UpdateGprsLocationArg_descr_; }
UpdateGprsLocationArg& UpdateGprsLocationArg::operator=(const UpdateGprsLocationArg& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
  if (other_value.imsi().is_bound()) field_imsi = other_value.imsi();
  else field_imsi.clean_up();
  if (other_value.sgsn__Number().is_bound()) field_sgsn__Number = other_value.sgsn__Number();
  else field_sgsn__Number.clean_up();
  if (other_value.sgsn__Address().is_bound()) field_sgsn__Address = other_value.sgsn__Address();
  else field_sgsn__Address.clean_up();
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
  if (other_value.sgsn__Capability().is_bound()) field_sgsn__Capability = other_value.sgsn__Capability();
  else field_sgsn__Capability.clean_up();
  if (other_value.informPreviousNetworkEntity().is_bound()) field_informPreviousNetworkEntity = other_value.informPreviousNetworkEntity();
  else field_informPreviousNetworkEntity.clean_up();
  if (other_value.ps__LCS__NotSupportedByUE().is_bound()) field_ps__LCS__NotSupportedByUE = other_value.ps__LCS__NotSupportedByUE();
  else field_ps__LCS__NotSupportedByUE.clean_up();
  if (other_value.v__gmlc__Address().is_bound()) field_v__gmlc__Address = other_value.v__gmlc__Address();
  else field_v__gmlc__Address.clean_up();
  if (other_value.add__info().is_bound()) field_add__info = other_value.add__info();
  else field_add__info.clean_up();
  if (other_value.eps__info().is_bound()) field_eps__info = other_value.eps__info();
  else field_eps__info.clean_up();
  if (other_value.servingNodeTypeIndicator().is_bound()) field_servingNodeTypeIndicator = other_value.servingNodeTypeIndicator();
  else field_servingNodeTypeIndicator.clean_up();
  if (other_value.skipSubscriberDataUpdate().is_bound()) field_skipSubscriberDataUpdate = other_value.skipSubscriberDataUpdate();
  else field_skipSubscriberDataUpdate.clean_up();
  if (other_value.usedRAT__Type().is_bound()) field_usedRAT__Type = other_value.usedRAT__Type();
  else field_usedRAT__Type.clean_up();
  if (other_value.gprsSubscriptionDataNotNeeded().is_bound()) field_gprsSubscriptionDataNotNeeded = other_value.gprsSubscriptionDataNotNeeded();
  else field_gprsSubscriptionDataNotNeeded.clean_up();
  if (other_value.nodeTypeIndicator().is_bound()) field_nodeTypeIndicator = other_value.nodeTypeIndicator();
  else field_nodeTypeIndicator.clean_up();
  if (other_value.areaRestricted().is_bound()) field_areaRestricted = other_value.areaRestricted();
  else field_areaRestricted.clean_up();
  if (other_value.ue__reachableIndicator().is_bound()) field_ue__reachableIndicator = other_value.ue__reachableIndicator();
  else field_ue__reachableIndicator.clean_up();
  if (other_value.epsSubscriptionDataNotNeeded().is_bound()) field_epsSubscriptionDataNotNeeded = other_value.epsSubscriptionDataNotNeeded();
  else field_epsSubscriptionDataNotNeeded.clean_up();
  if (other_value.ue__srvcc__Capability().is_bound()) field_ue__srvcc__Capability = other_value.ue__srvcc__Capability();
  else field_ue__srvcc__Capability.clean_up();
}
return *this;
}

boolean UpdateGprsLocationArg::operator==(const UpdateGprsLocationArg& other_value) const
{
return field_imsi==other_value.field_imsi
  && field_sgsn__Number==other_value.field_sgsn__Number
  && field_sgsn__Address==other_value.field_sgsn__Address
  && field_extensionContainer==other_value.field_extensionContainer
  && field_sgsn__Capability==other_value.field_sgsn__Capability
  && field_informPreviousNetworkEntity==other_value.field_informPreviousNetworkEntity
  && field_ps__LCS__NotSupportedByUE==other_value.field_ps__LCS__NotSupportedByUE
  && field_v__gmlc__Address==other_value.field_v__gmlc__Address
  && field_add__info==other_value.field_add__info
  && field_eps__info==other_value.field_eps__info
  && field_servingNodeTypeIndicator==other_value.field_servingNodeTypeIndicator
  && field_skipSubscriberDataUpdate==other_value.field_skipSubscriberDataUpdate
  && field_usedRAT__Type==other_value.field_usedRAT__Type
  && field_gprsSubscriptionDataNotNeeded==other_value.field_gprsSubscriptionDataNotNeeded
  && field_nodeTypeIndicator==other_value.field_nodeTypeIndicator
  && field_areaRestricted==other_value.field_areaRestricted
  && field_ue__reachableIndicator==other_value.field_ue__reachableIndicator
  && field_epsSubscriptionDataNotNeeded==other_value.field_epsSubscriptionDataNotNeeded
  && field_ue__srvcc__Capability==other_value.field_ue__srvcc__Capability;
}

boolean UpdateGprsLocationArg::is_bound() const
{
return (field_imsi.is_bound())
  || (field_sgsn__Number.is_bound())
  || (field_sgsn__Address.is_bound())
  || (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound())
  || (OPTIONAL_OMIT == field_sgsn__Capability.get_selection() || field_sgsn__Capability.is_bound())
  || (OPTIONAL_OMIT == field_informPreviousNetworkEntity.get_selection() || field_informPreviousNetworkEntity.is_bound())
  || (OPTIONAL_OMIT == field_ps__LCS__NotSupportedByUE.get_selection() || field_ps__LCS__NotSupportedByUE.is_bound())
  || (OPTIONAL_OMIT == field_v__gmlc__Address.get_selection() || field_v__gmlc__Address.is_bound())
  || (OPTIONAL_OMIT == field_add__info.get_selection() || field_add__info.is_bound())
  || (OPTIONAL_OMIT == field_eps__info.get_selection() || field_eps__info.is_bound())
  || (OPTIONAL_OMIT == field_servingNodeTypeIndicator.get_selection() || field_servingNodeTypeIndicator.is_bound())
  || (OPTIONAL_OMIT == field_skipSubscriberDataUpdate.get_selection() || field_skipSubscriberDataUpdate.is_bound())
  || (OPTIONAL_OMIT == field_usedRAT__Type.get_selection() || field_usedRAT__Type.is_bound())
  || (OPTIONAL_OMIT == field_gprsSubscriptionDataNotNeeded.get_selection() || field_gprsSubscriptionDataNotNeeded.is_bound())
  || (OPTIONAL_OMIT == field_nodeTypeIndicator.get_selection() || field_nodeTypeIndicator.is_bound())
  || (OPTIONAL_OMIT == field_areaRestricted.get_selection() || field_areaRestricted.is_bound())
  || (OPTIONAL_OMIT == field_ue__reachableIndicator.get_selection() || field_ue__reachableIndicator.is_bound())
  || (OPTIONAL_OMIT == field_epsSubscriptionDataNotNeeded.get_selection() || field_epsSubscriptionDataNotNeeded.is_bound())
  || (OPTIONAL_OMIT == field_ue__srvcc__Capability.get_selection() || field_ue__srvcc__Capability.is_bound());
}
boolean UpdateGprsLocationArg::is_value() const
{
return field_imsi.is_value()
  && field_sgsn__Number.is_value()
  && field_sgsn__Address.is_value()
  && (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value())
  && (OPTIONAL_OMIT == field_sgsn__Capability.get_selection() || field_sgsn__Capability.is_value())
  && (OPTIONAL_OMIT == field_informPreviousNetworkEntity.get_selection() || field_informPreviousNetworkEntity.is_value())
  && (OPTIONAL_OMIT == field_ps__LCS__NotSupportedByUE.get_selection() || field_ps__LCS__NotSupportedByUE.is_value())
  && (OPTIONAL_OMIT == field_v__gmlc__Address.get_selection() || field_v__gmlc__Address.is_value())
  && (OPTIONAL_OMIT == field_add__info.get_selection() || field_add__info.is_value())
  && (OPTIONAL_OMIT == field_eps__info.get_selection() || field_eps__info.is_value())
  && (OPTIONAL_OMIT == field_servingNodeTypeIndicator.get_selection() || field_servingNodeTypeIndicator.is_value())
  && (OPTIONAL_OMIT == field_skipSubscriberDataUpdate.get_selection() || field_skipSubscriberDataUpdate.is_value())
  && (OPTIONAL_OMIT == field_usedRAT__Type.get_selection() || field_usedRAT__Type.is_value())
  && (OPTIONAL_OMIT == field_gprsSubscriptionDataNotNeeded.get_selection() || field_gprsSubscriptionDataNotNeeded.is_value())
  && (OPTIONAL_OMIT == field_nodeTypeIndicator.get_selection() || field_nodeTypeIndicator.is_value())
  && (OPTIONAL_OMIT == field_areaRestricted.get_selection() || field_areaRestricted.is_value())
  && (OPTIONAL_OMIT == field_ue__reachableIndicator.get_selection() || field_ue__reachableIndicator.is_value())
  && (OPTIONAL_OMIT == field_epsSubscriptionDataNotNeeded.get_selection() || field_epsSubscriptionDataNotNeeded.is_value())
  && (OPTIONAL_OMIT == field_ue__srvcc__Capability.get_selection() || field_ue__srvcc__Capability.is_value());
}
int UpdateGprsLocationArg::size_of() const
{
  int ret_val = 3;
  if (field_extensionContainer.ispresent()) ret_val++;
  if (field_sgsn__Capability.ispresent()) ret_val++;
  if (field_informPreviousNetworkEntity.ispresent()) ret_val++;
  if (field_ps__LCS__NotSupportedByUE.ispresent()) ret_val++;
  if (field_v__gmlc__Address.ispresent()) ret_val++;
  if (field_add__info.ispresent()) ret_val++;
  if (field_eps__info.ispresent()) ret_val++;
  if (field_servingNodeTypeIndicator.ispresent()) ret_val++;
  if (field_skipSubscriberDataUpdate.ispresent()) ret_val++;
  if (field_usedRAT__Type.ispresent()) ret_val++;
  if (field_gprsSubscriptionDataNotNeeded.ispresent()) ret_val++;
  if (field_nodeTypeIndicator.ispresent()) ret_val++;
  if (field_areaRestricted.ispresent()) ret_val++;
  if (field_ue__reachableIndicator.ispresent()) ret_val++;
  if (field_epsSubscriptionDataNotNeeded.ispresent()) ret_val++;
  if (field_ue__srvcc__Capability.ispresent()) ret_val++;
  return ret_val;
}

void UpdateGprsLocationArg::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ imsi := ");
field_imsi.log();
TTCN_Logger::log_event_str(", sgsn_Number := ");
field_sgsn__Number.log();
TTCN_Logger::log_event_str(", sgsn_Address := ");
field_sgsn__Address.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(", sgsn_Capability := ");
field_sgsn__Capability.log();
TTCN_Logger::log_event_str(", informPreviousNetworkEntity := ");
field_informPreviousNetworkEntity.log();
TTCN_Logger::log_event_str(", ps_LCS_NotSupportedByUE := ");
field_ps__LCS__NotSupportedByUE.log();
TTCN_Logger::log_event_str(", v_gmlc_Address := ");
field_v__gmlc__Address.log();
TTCN_Logger::log_event_str(", add_info := ");
field_add__info.log();
TTCN_Logger::log_event_str(", eps_info := ");
field_eps__info.log();
TTCN_Logger::log_event_str(", servingNodeTypeIndicator := ");
field_servingNodeTypeIndicator.log();
TTCN_Logger::log_event_str(", skipSubscriberDataUpdate := ");
field_skipSubscriberDataUpdate.log();
TTCN_Logger::log_event_str(", usedRAT_Type := ");
field_usedRAT__Type.log();
TTCN_Logger::log_event_str(", gprsSubscriptionDataNotNeeded := ");
field_gprsSubscriptionDataNotNeeded.log();
TTCN_Logger::log_event_str(", nodeTypeIndicator := ");
field_nodeTypeIndicator.log();
TTCN_Logger::log_event_str(", areaRestricted := ");
field_areaRestricted.log();
TTCN_Logger::log_event_str(", ue_reachableIndicator := ");
field_ue__reachableIndicator.log();
TTCN_Logger::log_event_str(", epsSubscriptionDataNotNeeded := ");
field_epsSubscriptionDataNotNeeded.log();
TTCN_Logger::log_event_str(", ue_srvcc_Capability := ");
field_ue__srvcc__Capability.log();
TTCN_Logger::log_event_str(" }");
}

void UpdateGprsLocationArg::set_implicit_omit()
{
if (imsi().is_bound()) imsi().set_implicit_omit();
if (sgsn__Number().is_bound()) sgsn__Number().set_implicit_omit();
if (sgsn__Address().is_bound()) sgsn__Address().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!sgsn__Capability().is_bound()) sgsn__Capability() = OMIT_VALUE;
else sgsn__Capability().set_implicit_omit();
if (!informPreviousNetworkEntity().is_bound()) informPreviousNetworkEntity() = OMIT_VALUE;
else informPreviousNetworkEntity().set_implicit_omit();
if (!ps__LCS__NotSupportedByUE().is_bound()) ps__LCS__NotSupportedByUE() = OMIT_VALUE;
else ps__LCS__NotSupportedByUE().set_implicit_omit();
if (!v__gmlc__Address().is_bound()) v__gmlc__Address() = OMIT_VALUE;
else v__gmlc__Address().set_implicit_omit();
if (!add__info().is_bound()) add__info() = OMIT_VALUE;
else add__info().set_implicit_omit();
if (!eps__info().is_bound()) eps__info() = OMIT_VALUE;
else eps__info().set_implicit_omit();
if (!servingNodeTypeIndicator().is_bound()) servingNodeTypeIndicator() = OMIT_VALUE;
else servingNodeTypeIndicator().set_implicit_omit();
if (!skipSubscriberDataUpdate().is_bound()) skipSubscriberDataUpdate() = OMIT_VALUE;
else skipSubscriberDataUpdate().set_implicit_omit();
if (!usedRAT__Type().is_bound()) usedRAT__Type() = OMIT_VALUE;
else usedRAT__Type().set_implicit_omit();
if (!gprsSubscriptionDataNotNeeded().is_bound()) gprsSubscriptionDataNotNeeded() = OMIT_VALUE;
else gprsSubscriptionDataNotNeeded().set_implicit_omit();
if (!nodeTypeIndicator().is_bound()) nodeTypeIndicator() = OMIT_VALUE;
else nodeTypeIndicator().set_implicit_omit();
if (!areaRestricted().is_bound()) areaRestricted() = OMIT_VALUE;
else areaRestricted().set_implicit_omit();
if (!ue__reachableIndicator().is_bound()) ue__reachableIndicator() = OMIT_VALUE;
else ue__reachableIndicator().set_implicit_omit();
if (!epsSubscriptionDataNotNeeded().is_bound()) epsSubscriptionDataNotNeeded() = OMIT_VALUE;
else epsSubscriptionDataNotNeeded().set_implicit_omit();
if (!ue__srvcc__Capability().is_bound()) ue__srvcc__Capability() = OMIT_VALUE;
else ue__srvcc__Capability().set_implicit_omit();
}

void UpdateGprsLocationArg::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (19<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.UpdateGprsLocationArg has 19 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) imsi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) sgsn__Number().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) sgsn__Address().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) sgsn__Capability().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) informPreviousNetworkEntity().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) ps__LCS__NotSupportedByUE().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) v__gmlc__Address().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) add__info().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) eps__info().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) servingNodeTypeIndicator().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) skipSubscriberDataUpdate().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) usedRAT__Type().set_param(*param.get_elem(12));
    if (param.get_size()>13 && param.get_elem(13)->get_type()!=Module_Param::MP_NotUsed) gprsSubscriptionDataNotNeeded().set_param(*param.get_elem(13));
    if (param.get_size()>14 && param.get_elem(14)->get_type()!=Module_Param::MP_NotUsed) nodeTypeIndicator().set_param(*param.get_elem(14));
    if (param.get_size()>15 && param.get_elem(15)->get_type()!=Module_Param::MP_NotUsed) areaRestricted().set_param(*param.get_elem(15));
    if (param.get_size()>16 && param.get_elem(16)->get_type()!=Module_Param::MP_NotUsed) ue__reachableIndicator().set_param(*param.get_elem(16));
    if (param.get_size()>17 && param.get_elem(17)->get_type()!=Module_Param::MP_NotUsed) epsSubscriptionDataNotNeeded().set_param(*param.get_elem(17));
    if (param.get_size()>18 && param.get_elem(18)->get_type()!=Module_Param::MP_NotUsed) ue__srvcc__Capability().set_param(*param.get_elem(18));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sgsn_Number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sgsn__Number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sgsn_Address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sgsn__Address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sgsn_Capability")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sgsn__Capability().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "informPreviousNetworkEntity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          informPreviousNetworkEntity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ps_LCS_NotSupportedByUE")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ps__LCS__NotSupportedByUE().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "v_gmlc_Address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          v__gmlc__Address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "add_info")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          add__info().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "eps_info")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          eps__info().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "servingNodeTypeIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          servingNodeTypeIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "skipSubscriberDataUpdate")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          skipSubscriberDataUpdate().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "usedRAT_Type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          usedRAT__Type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gprsSubscriptionDataNotNeeded")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gprsSubscriptionDataNotNeeded().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nodeTypeIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nodeTypeIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "areaRestricted")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          areaRestricted().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ue_reachableIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ue__reachableIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "epsSubscriptionDataNotNeeded")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          epsSubscriptionDataNotNeeded().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ue_srvcc_Capability")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ue__srvcc__Capability().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.UpdateGprsLocationArg: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.UpdateGprsLocationArg");
  }
}

void UpdateGprsLocationArg::encode_text(Text_Buf& text_buf) const
{
field_imsi.encode_text(text_buf);
field_sgsn__Number.encode_text(text_buf);
field_sgsn__Address.encode_text(text_buf);
field_extensionContainer.encode_text(text_buf);
field_sgsn__Capability.encode_text(text_buf);
field_informPreviousNetworkEntity.encode_text(text_buf);
field_ps__LCS__NotSupportedByUE.encode_text(text_buf);
field_v__gmlc__Address.encode_text(text_buf);
field_add__info.encode_text(text_buf);
field_eps__info.encode_text(text_buf);
field_servingNodeTypeIndicator.encode_text(text_buf);
field_skipSubscriberDataUpdate.encode_text(text_buf);
field_usedRAT__Type.encode_text(text_buf);
field_gprsSubscriptionDataNotNeeded.encode_text(text_buf);
field_nodeTypeIndicator.encode_text(text_buf);
field_areaRestricted.encode_text(text_buf);
field_ue__reachableIndicator.encode_text(text_buf);
field_epsSubscriptionDataNotNeeded.encode_text(text_buf);
field_ue__srvcc__Capability.encode_text(text_buf);
}

void UpdateGprsLocationArg::decode_text(Text_Buf& text_buf)
{
field_imsi.decode_text(text_buf);
field_sgsn__Number.decode_text(text_buf);
field_sgsn__Address.decode_text(text_buf);
field_extensionContainer.decode_text(text_buf);
field_sgsn__Capability.decode_text(text_buf);
field_informPreviousNetworkEntity.decode_text(text_buf);
field_ps__LCS__NotSupportedByUE.decode_text(text_buf);
field_v__gmlc__Address.decode_text(text_buf);
field_add__info.decode_text(text_buf);
field_eps__info.decode_text(text_buf);
field_servingNodeTypeIndicator.decode_text(text_buf);
field_skipSubscriberDataUpdate.decode_text(text_buf);
field_usedRAT__Type.decode_text(text_buf);
field_gprsSubscriptionDataNotNeeded.decode_text(text_buf);
field_nodeTypeIndicator.decode_text(text_buf);
field_areaRestricted.decode_text(text_buf);
field_ue__reachableIndicator.decode_text(text_buf);
field_epsSubscriptionDataNotNeeded.decode_text(text_buf);
field_ue__srvcc__Capability.decode_text(text_buf);
}

void UpdateGprsLocationArg::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void UpdateGprsLocationArg::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* UpdateGprsLocationArg::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("imsi': ");
  new_tlv->add_TLV(field_imsi.BER_encode_TLV(MAP__CommonDataTypes::IMSI_descr_, p_coding));
  ec_1.set_msg("sgsn_Number': ");
  new_tlv->add_TLV(field_sgsn__Number.BER_encode_TLV(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_coding));
  ec_1.set_msg("sgsn_Address': ");
  new_tlv->add_TLV(field_sgsn__Address.BER_encode_TLV(MAP__CommonDataTypes::GSN__Address_descr_, p_coding));
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(UpdateGprsLocationArg_extensionContainer_descr_, p_coding));
  ec_1.set_msg("sgsn_Capability': ");
  new_tlv->add_TLV(field_sgsn__Capability.BER_encode_TLV(UpdateGprsLocationArg_sgsn__Capability_descr_, p_coding));
  ec_1.set_msg("informPreviousNetworkEntity': ");
  new_tlv->add_TLV(field_informPreviousNetworkEntity.BER_encode_TLV(UpdateGprsLocationArg_informPreviousNetworkEntity_descr_, p_coding));
  ec_1.set_msg("ps_LCS_NotSupportedByUE': ");
  new_tlv->add_TLV(field_ps__LCS__NotSupportedByUE.BER_encode_TLV(UpdateGprsLocationArg_ps__LCS__NotSupportedByUE_descr_, p_coding));
  ec_1.set_msg("v_gmlc_Address': ");
  new_tlv->add_TLV(field_v__gmlc__Address.BER_encode_TLV(UpdateGprsLocationArg_v__gmlc__Address_descr_, p_coding));
  ec_1.set_msg("add_info': ");
  new_tlv->add_TLV(field_add__info.BER_encode_TLV(UpdateGprsLocationArg_add__info_descr_, p_coding));
  ec_1.set_msg("eps_info': ");
  new_tlv->add_TLV(field_eps__info.BER_encode_TLV(UpdateGprsLocationArg_eps__info_descr_, p_coding));
  ec_1.set_msg("servingNodeTypeIndicator': ");
  new_tlv->add_TLV(field_servingNodeTypeIndicator.BER_encode_TLV(UpdateGprsLocationArg_servingNodeTypeIndicator_descr_, p_coding));
  ec_1.set_msg("skipSubscriberDataUpdate': ");
  new_tlv->add_TLV(field_skipSubscriberDataUpdate.BER_encode_TLV(UpdateGprsLocationArg_skipSubscriberDataUpdate_descr_, p_coding));
  ec_1.set_msg("usedRAT_Type': ");
  new_tlv->add_TLV(field_usedRAT__Type.BER_encode_TLV(UpdateGprsLocationArg_usedRAT__Type_descr_, p_coding));
  ec_1.set_msg("gprsSubscriptionDataNotNeeded': ");
  new_tlv->add_TLV(field_gprsSubscriptionDataNotNeeded.BER_encode_TLV(UpdateGprsLocationArg_gprsSubscriptionDataNotNeeded_descr_, p_coding));
  ec_1.set_msg("nodeTypeIndicator': ");
  new_tlv->add_TLV(field_nodeTypeIndicator.BER_encode_TLV(UpdateGprsLocationArg_nodeTypeIndicator_descr_, p_coding));
  ec_1.set_msg("areaRestricted': ");
  new_tlv->add_TLV(field_areaRestricted.BER_encode_TLV(UpdateGprsLocationArg_areaRestricted_descr_, p_coding));
  ec_1.set_msg("ue_reachableIndicator': ");
  new_tlv->add_TLV(field_ue__reachableIndicator.BER_encode_TLV(UpdateGprsLocationArg_ue__reachableIndicator_descr_, p_coding));
  ec_1.set_msg("epsSubscriptionDataNotNeeded': ");
  new_tlv->add_TLV(field_epsSubscriptionDataNotNeeded.BER_encode_TLV(UpdateGprsLocationArg_epsSubscriptionDataNotNeeded_descr_, p_coding));
  ec_1.set_msg("ue_srvcc_Capability': ");
  new_tlv->add_TLV(field_ue__srvcc__Capability.BER_encode_TLV(UpdateGprsLocationArg_ue__srvcc__Capability_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean UpdateGprsLocationArg::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.UpdateGprsLocationArg' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("imsi': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_imsi.BER_decode_TLV(MAP__CommonDataTypes::IMSI_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("sgsn_Number': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_sgsn__Number.BER_decode_TLV(MAP__CommonDataTypes::ISDN__AddressString_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("sgsn_Address': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_sgsn__Address.BER_decode_TLV(MAP__CommonDataTypes::GSN__Address_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(UpdateGprsLocationArg_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("sgsn_Capability': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_sgsn__Capability=OMIT_VALUE;
    else {
      field_sgsn__Capability.BER_decode_TLV(UpdateGprsLocationArg_sgsn__Capability_descr_, tmp_tlv, L_form);
      if(field_sgsn__Capability.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("informPreviousNetworkEntity': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_informPreviousNetworkEntity=OMIT_VALUE;
    else {
      field_informPreviousNetworkEntity.BER_decode_TLV(UpdateGprsLocationArg_informPreviousNetworkEntity_descr_, tmp_tlv, L_form);
      if(field_informPreviousNetworkEntity.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("ps_LCS_NotSupportedByUE': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_ps__LCS__NotSupportedByUE=OMIT_VALUE;
    else {
      field_ps__LCS__NotSupportedByUE.BER_decode_TLV(UpdateGprsLocationArg_ps__LCS__NotSupportedByUE_descr_, tmp_tlv, L_form);
      if(field_ps__LCS__NotSupportedByUE.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("v_gmlc_Address': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_v__gmlc__Address=OMIT_VALUE;
    else {
      field_v__gmlc__Address.BER_decode_TLV(UpdateGprsLocationArg_v__gmlc__Address_descr_, tmp_tlv, L_form);
      if(field_v__gmlc__Address.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("add_info': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_add__info=OMIT_VALUE;
    else {
      field_add__info.BER_decode_TLV(UpdateGprsLocationArg_add__info_descr_, tmp_tlv, L_form);
      if(field_add__info.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("eps_info': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_eps__info=OMIT_VALUE;
    else {
      field_eps__info.BER_decode_TLV(UpdateGprsLocationArg_eps__info_descr_, tmp_tlv, L_form);
      if(field_eps__info.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("servingNodeTypeIndicator': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_servingNodeTypeIndicator=OMIT_VALUE;
    else {
      field_servingNodeTypeIndicator.BER_decode_TLV(UpdateGprsLocationArg_servingNodeTypeIndicator_descr_, tmp_tlv, L_form);
      if(field_servingNodeTypeIndicator.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("skipSubscriberDataUpdate': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_skipSubscriberDataUpdate=OMIT_VALUE;
    else {
      field_skipSubscriberDataUpdate.BER_decode_TLV(UpdateGprsLocationArg_skipSubscriberDataUpdate_descr_, tmp_tlv, L_form);
      if(field_skipSubscriberDataUpdate.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("usedRAT_Type': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_usedRAT__Type=OMIT_VALUE;
    else {
      field_usedRAT__Type.BER_decode_TLV(UpdateGprsLocationArg_usedRAT__Type_descr_, tmp_tlv, L_form);
      if(field_usedRAT__Type.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("gprsSubscriptionDataNotNeeded': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_gprsSubscriptionDataNotNeeded=OMIT_VALUE;
    else {
      field_gprsSubscriptionDataNotNeeded.BER_decode_TLV(UpdateGprsLocationArg_gprsSubscriptionDataNotNeeded_descr_, tmp_tlv, L_form);
      if(field_gprsSubscriptionDataNotNeeded.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("nodeTypeIndicator': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_nodeTypeIndicator=OMIT_VALUE;
    else {
      field_nodeTypeIndicator.BER_decode_TLV(UpdateGprsLocationArg_nodeTypeIndicator_descr_, tmp_tlv, L_form);
      if(field_nodeTypeIndicator.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("areaRestricted': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_areaRestricted=OMIT_VALUE;
    else {
      field_areaRestricted.BER_decode_TLV(UpdateGprsLocationArg_areaRestricted_descr_, tmp_tlv, L_form);
      if(field_areaRestricted.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("ue_reachableIndicator': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_ue__reachableIndicator=OMIT_VALUE;
    else {
      field_ue__reachableIndicator.BER_decode_TLV(UpdateGprsLocationArg_ue__reachableIndicator_descr_, tmp_tlv, L_form);
      if(field_ue__reachableIndicator.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("epsSubscriptionDataNotNeeded': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_epsSubscriptionDataNotNeeded=OMIT_VALUE;
    else {
      field_epsSubscriptionDataNotNeeded.BER_decode_TLV(UpdateGprsLocationArg_epsSubscriptionDataNotNeeded_descr_, tmp_tlv, L_form);
      if(field_epsSubscriptionDataNotNeeded.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("ue_srvcc_Capability': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_ue__srvcc__Capability=OMIT_VALUE;
    else {
      field_ue__srvcc__Capability.BER_decode_TLV(UpdateGprsLocationArg_ue__srvcc__Capability_descr_, tmp_tlv, L_form);
      if(field_ue__srvcc__Capability.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int UpdateGprsLocationArg::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "imsi");
    enc_len += field_imsi.JSON_encode(MAP__CommonDataTypes::IMSI_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "sgsn_Number");
    enc_len += field_sgsn__Number.JSON_encode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_tok, FALSE);
  }

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "sgsn_Address");
    enc_len += field_sgsn__Address.JSON_encode(MAP__CommonDataTypes::GSN__Address_descr_, p_tok, FALSE);
  }

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(UpdateGprsLocationArg_extensionContainer_descr_, p_tok, FALSE);
  }

  if (field_sgsn__Capability.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "sgsn_Capability");
    enc_len += field_sgsn__Capability.JSON_encode(UpdateGprsLocationArg_sgsn__Capability_descr_, p_tok, FALSE);
  }

  if (field_informPreviousNetworkEntity.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "informPreviousNetworkEntity");
    enc_len += field_informPreviousNetworkEntity.JSON_encode(UpdateGprsLocationArg_informPreviousNetworkEntity_descr_, p_tok, FALSE);
  }

  if (field_ps__LCS__NotSupportedByUE.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ps_LCS_NotSupportedByUE");
    enc_len += field_ps__LCS__NotSupportedByUE.JSON_encode(UpdateGprsLocationArg_ps__LCS__NotSupportedByUE_descr_, p_tok, FALSE);
  }

  if (field_v__gmlc__Address.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "v_gmlc_Address");
    enc_len += field_v__gmlc__Address.JSON_encode(UpdateGprsLocationArg_v__gmlc__Address_descr_, p_tok, FALSE);
  }

  if (field_add__info.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "add_info");
    enc_len += field_add__info.JSON_encode(UpdateGprsLocationArg_add__info_descr_, p_tok, FALSE);
  }

  if (field_eps__info.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "eps_info");
    enc_len += field_eps__info.JSON_encode(UpdateGprsLocationArg_eps__info_descr_, p_tok, FALSE);
  }

  if (field_servingNodeTypeIndicator.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "servingNodeTypeIndicator");
    enc_len += field_servingNodeTypeIndicator.JSON_encode(UpdateGprsLocationArg_servingNodeTypeIndicator_descr_, p_tok, FALSE);
  }

  if (field_skipSubscriberDataUpdate.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "skipSubscriberDataUpdate");
    enc_len += field_skipSubscriberDataUpdate.JSON_encode(UpdateGprsLocationArg_skipSubscriberDataUpdate_descr_, p_tok, FALSE);
  }

  if (field_usedRAT__Type.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "usedRAT_Type");
    enc_len += field_usedRAT__Type.JSON_encode(UpdateGprsLocationArg_usedRAT__Type_descr_, p_tok, FALSE);
  }

  if (field_gprsSubscriptionDataNotNeeded.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "gprsSubscriptionDataNotNeeded");
    enc_len += field_gprsSubscriptionDataNotNeeded.JSON_encode(UpdateGprsLocationArg_gprsSubscriptionDataNotNeeded_descr_, p_tok, FALSE);
  }

  if (field_nodeTypeIndicator.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "nodeTypeIndicator");
    enc_len += field_nodeTypeIndicator.JSON_encode(UpdateGprsLocationArg_nodeTypeIndicator_descr_, p_tok, FALSE);
  }

  if (field_areaRestricted.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "areaRestricted");
    enc_len += field_areaRestricted.JSON_encode(UpdateGprsLocationArg_areaRestricted_descr_, p_tok, FALSE);
  }

  if (field_ue__reachableIndicator.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ue_reachableIndicator");
    enc_len += field_ue__reachableIndicator.JSON_encode(UpdateGprsLocationArg_ue__reachableIndicator_descr_, p_tok, FALSE);
  }

  if (field_epsSubscriptionDataNotNeeded.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "epsSubscriptionDataNotNeeded");
    enc_len += field_epsSubscriptionDataNotNeeded.JSON_encode(UpdateGprsLocationArg_epsSubscriptionDataNotNeeded_descr_, p_tok, FALSE);
  }

  if (field_ue__srvcc__Capability.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "ue_srvcc_Capability");
    enc_len += field_ue__srvcc__Capability.JSON_encode(UpdateGprsLocationArg_ue__srvcc__Capability_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int UpdateGprsLocationArg::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const UpdateGprsLocationArg*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean imsi_found = FALSE;
  boolean sgsn__Number_found = FALSE;
  boolean sgsn__Address_found = FALSE;
  boolean extensionContainer_found = FALSE;
  boolean sgsn__Capability_found = FALSE;
  boolean informPreviousNetworkEntity_found = FALSE;
  boolean ps__LCS__NotSupportedByUE_found = FALSE;
  boolean v__gmlc__Address_found = FALSE;
  boolean add__info_found = FALSE;
  boolean eps__info_found = FALSE;
  boolean servingNodeTypeIndicator_found = FALSE;
  boolean skipSubscriberDataUpdate_found = FALSE;
  boolean usedRAT__Type_found = FALSE;
  boolean gprsSubscriptionDataNotNeeded_found = FALSE;
  boolean nodeTypeIndicator_found = FALSE;
  boolean areaRestricted_found = FALSE;
  boolean ue__reachableIndicator_found = FALSE;
  boolean epsSubscriptionDataNotNeeded_found = FALSE;
  boolean ue__srvcc__Capability_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (4 == name_len && 0 == strncmp(fld_name, "imsi", name_len)) {
        imsi_found = TRUE;
         int ret_val = field_imsi.JSON_decode(MAP__CommonDataTypes::IMSI_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 4, "imsi");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (11 == name_len && 0 == strncmp(fld_name, "sgsn_Number", name_len)) {
        sgsn__Number_found = TRUE;
         int ret_val = field_sgsn__Number.JSON_decode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 11, "sgsn_Number");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (12 == name_len && 0 == strncmp(fld_name, "sgsn_Address", name_len)) {
        sgsn__Address_found = TRUE;
         int ret_val = field_sgsn__Address.JSON_decode(MAP__CommonDataTypes::GSN__Address_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 12, "sgsn_Address");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(UpdateGprsLocationArg_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (15 == name_len && 0 == strncmp(fld_name, "sgsn_Capability", name_len)) {
        sgsn__Capability_found = TRUE;
         int ret_val = field_sgsn__Capability.JSON_decode(UpdateGprsLocationArg_sgsn__Capability_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 15, "sgsn_Capability");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (27 == name_len && 0 == strncmp(fld_name, "informPreviousNetworkEntity", name_len)) {
        informPreviousNetworkEntity_found = TRUE;
         int ret_val = field_informPreviousNetworkEntity.JSON_decode(UpdateGprsLocationArg_informPreviousNetworkEntity_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 27, "informPreviousNetworkEntity");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (23 == name_len && 0 == strncmp(fld_name, "ps_LCS_NotSupportedByUE", name_len)) {
        ps__LCS__NotSupportedByUE_found = TRUE;
         int ret_val = field_ps__LCS__NotSupportedByUE.JSON_decode(UpdateGprsLocationArg_ps__LCS__NotSupportedByUE_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 23, "ps_LCS_NotSupportedByUE");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (14 == name_len && 0 == strncmp(fld_name, "v_gmlc_Address", name_len)) {
        v__gmlc__Address_found = TRUE;
         int ret_val = field_v__gmlc__Address.JSON_decode(UpdateGprsLocationArg_v__gmlc__Address_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 14, "v_gmlc_Address");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (8 == name_len && 0 == strncmp(fld_name, "add_info", name_len)) {
        add__info_found = TRUE;
         int ret_val = field_add__info.JSON_decode(UpdateGprsLocationArg_add__info_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 8, "add_info");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (8 == name_len && 0 == strncmp(fld_name, "eps_info", name_len)) {
        eps__info_found = TRUE;
         int ret_val = field_eps__info.JSON_decode(UpdateGprsLocationArg_eps__info_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 8, "eps_info");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (24 == name_len && 0 == strncmp(fld_name, "servingNodeTypeIndicator", name_len)) {
        servingNodeTypeIndicator_found = TRUE;
         int ret_val = field_servingNodeTypeIndicator.JSON_decode(UpdateGprsLocationArg_servingNodeTypeIndicator_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 24, "servingNodeTypeIndicator");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (24 == name_len && 0 == strncmp(fld_name, "skipSubscriberDataUpdate", name_len)) {
        skipSubscriberDataUpdate_found = TRUE;
         int ret_val = field_skipSubscriberDataUpdate.JSON_decode(UpdateGprsLocationArg_skipSubscriberDataUpdate_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 24, "skipSubscriberDataUpdate");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (12 == name_len && 0 == strncmp(fld_name, "usedRAT_Type", name_len)) {
        usedRAT__Type_found = TRUE;
         int ret_val = field_usedRAT__Type.JSON_decode(UpdateGprsLocationArg_usedRAT__Type_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 12, "usedRAT_Type");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (29 == name_len && 0 == strncmp(fld_name, "gprsSubscriptionDataNotNeeded", name_len)) {
        gprsSubscriptionDataNotNeeded_found = TRUE;
         int ret_val = field_gprsSubscriptionDataNotNeeded.JSON_decode(UpdateGprsLocationArg_gprsSubscriptionDataNotNeeded_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 29, "gprsSubscriptionDataNotNeeded");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (17 == name_len && 0 == strncmp(fld_name, "nodeTypeIndicator", name_len)) {
        nodeTypeIndicator_found = TRUE;
         int ret_val = field_nodeTypeIndicator.JSON_decode(UpdateGprsLocationArg_nodeTypeIndicator_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 17, "nodeTypeIndicator");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (14 == name_len && 0 == strncmp(fld_name, "areaRestricted", name_len)) {
        areaRestricted_found = TRUE;
         int ret_val = field_areaRestricted.JSON_decode(UpdateGprsLocationArg_areaRestricted_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 14, "areaRestricted");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (21 == name_len && 0 == strncmp(fld_name, "ue_reachableIndicator", name_len)) {
        ue__reachableIndicator_found = TRUE;
         int ret_val = field_ue__reachableIndicator.JSON_decode(UpdateGprsLocationArg_ue__reachableIndicator_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 21, "ue_reachableIndicator");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (28 == name_len && 0 == strncmp(fld_name, "epsSubscriptionDataNotNeeded", name_len)) {
        epsSubscriptionDataNotNeeded_found = TRUE;
         int ret_val = field_epsSubscriptionDataNotNeeded.JSON_decode(UpdateGprsLocationArg_epsSubscriptionDataNotNeeded_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 28, "epsSubscriptionDataNotNeeded");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (19 == name_len && 0 == strncmp(fld_name, "ue_srvcc_Capability", name_len)) {
        ue__srvcc__Capability_found = TRUE;
         int ret_val = field_ue__srvcc__Capability.JSON_decode(UpdateGprsLocationArg_ue__srvcc__Capability_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 19, "ue_srvcc_Capability");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!imsi_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "imsi");
    return JSON_ERROR_FATAL;
  }
  if (!sgsn__Number_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "sgsn_Number");
    return JSON_ERROR_FATAL;
  }
  if (!sgsn__Address_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "sgsn_Address");
    return JSON_ERROR_FATAL;
  }
  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  if (!sgsn__Capability_found) {
    field_sgsn__Capability = OMIT_VALUE;
  }
  if (!informPreviousNetworkEntity_found) {
    field_informPreviousNetworkEntity = OMIT_VALUE;
  }
  if (!ps__LCS__NotSupportedByUE_found) {
    field_ps__LCS__NotSupportedByUE = OMIT_VALUE;
  }
  if (!v__gmlc__Address_found) {
    field_v__gmlc__Address = OMIT_VALUE;
  }
  if (!add__info_found) {
    field_add__info = OMIT_VALUE;
  }
  if (!eps__info_found) {
    field_eps__info = OMIT_VALUE;
  }
  if (!servingNodeTypeIndicator_found) {
    field_servingNodeTypeIndicator = OMIT_VALUE;
  }
  if (!skipSubscriberDataUpdate_found) {
    field_skipSubscriberDataUpdate = OMIT_VALUE;
  }
  if (!usedRAT__Type_found) {
    field_usedRAT__Type = OMIT_VALUE;
  }
  if (!gprsSubscriptionDataNotNeeded_found) {
    field_gprsSubscriptionDataNotNeeded = OMIT_VALUE;
  }
  if (!nodeTypeIndicator_found) {
    field_nodeTypeIndicator = OMIT_VALUE;
  }
  if (!areaRestricted_found) {
    field_areaRestricted = OMIT_VALUE;
  }
  if (!ue__reachableIndicator_found) {
    field_ue__reachableIndicator = OMIT_VALUE;
  }
  if (!epsSubscriptionDataNotNeeded_found) {
    field_epsSubscriptionDataNotNeeded = OMIT_VALUE;
  }
  if (!ue__srvcc__Capability_found) {
    field_ue__srvcc__Capability = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int UpdateGprsLocationArg::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  boolean has_extension = FALSE;
  has_extension = has_extension || (field_sgsn__Capability.is_bound() && field_sgsn__Capability.is_present());
  has_extension = has_extension || (field_informPreviousNetworkEntity.is_bound() && field_informPreviousNetworkEntity.is_present());
  has_extension = has_extension || (field_ps__LCS__NotSupportedByUE.is_bound() && field_ps__LCS__NotSupportedByUE.is_present());
  has_extension = has_extension || (field_v__gmlc__Address.is_bound() && field_v__gmlc__Address.is_present());
  has_extension = has_extension || (field_add__info.is_bound() && field_add__info.is_present());
  has_extension = has_extension || (field_eps__info.is_bound() && field_eps__info.is_present());
  has_extension = has_extension || (field_servingNodeTypeIndicator.is_bound() && field_servingNodeTypeIndicator.is_present());
  has_extension = has_extension || (field_skipSubscriberDataUpdate.is_bound() && field_skipSubscriberDataUpdate.is_present());
  has_extension = has_extension || (field_usedRAT__Type.is_bound() && field_usedRAT__Type.is_present());
  has_extension = has_extension || (field_gprsSubscriptionDataNotNeeded.is_bound() && field_gprsSubscriptionDataNotNeeded.is_present());
  has_extension = has_extension || (field_nodeTypeIndicator.is_bound() && field_nodeTypeIndicator.is_present());
  has_extension = has_extension || (field_areaRestricted.is_bound() && field_areaRestricted.is_present());
  has_extension = has_extension || (field_ue__reachableIndicator.is_bound() && field_ue__reachableIndicator.is_present());
  has_extension = has_extension || (field_epsSubscriptionDataNotNeeded.is_bound() && field_epsSubscriptionDataNotNeeded.is_present());
  has_extension = has_extension || (field_ue__srvcc__Capability.is_bound() && field_ue__srvcc__Capability.is_present());
  char c = 0;
  if (has_extension) {
    c |= 128;
  }
  if (field_extensionContainer.is_present()) {
    c |= 64;
  }
  p_buf.put_c(c);
  field_imsi.OER_encode(MAP__CommonDataTypes::IMSI_descr_, p_buf);
  field_sgsn__Number.OER_encode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_buf);
  field_sgsn__Address.OER_encode(MAP__CommonDataTypes::GSN__Address_descr_, p_buf);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(UpdateGprsLocationArg_extensionContainer_descr_, p_buf);
  if (has_extension) {
    TTCN_Buffer tmp_buf;
    TTCN_Buffer tmp_buf2;
    TTCN_Buffer tmp_buf3;
    c = 0;
    if (field_sgsn__Capability.is_present()) {
      c |= 128;
      field_sgsn__Capability.OER_encode(UpdateGprsLocationArg_sgsn__Capability_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_informPreviousNetworkEntity.is_present()) {
      c |= 64;
      field_informPreviousNetworkEntity.OER_encode(UpdateGprsLocationArg_informPreviousNetworkEntity_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_ps__LCS__NotSupportedByUE.is_present()) {
      c |= 32;
      field_ps__LCS__NotSupportedByUE.OER_encode(UpdateGprsLocationArg_ps__LCS__NotSupportedByUE_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_v__gmlc__Address.is_present()) {
      c |= 16;
      field_v__gmlc__Address.OER_encode(UpdateGprsLocationArg_v__gmlc__Address_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_add__info.is_present()) {
      c |= 8;
      field_add__info.OER_encode(UpdateGprsLocationArg_add__info_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_eps__info.is_present()) {
      c |= 4;
      field_eps__info.OER_encode(UpdateGprsLocationArg_eps__info_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_servingNodeTypeIndicator.is_present()) {
      c |= 2;
      field_servingNodeTypeIndicator.OER_encode(UpdateGprsLocationArg_servingNodeTypeIndicator_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_skipSubscriberDataUpdate.is_present()) {
      c |= 1;
      field_skipSubscriberDataUpdate.OER_encode(UpdateGprsLocationArg_skipSubscriberDataUpdate_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    tmp_buf3.put_c(c);
    c = 0;
    if (field_usedRAT__Type.is_present()) {
      c |= 128;
      field_usedRAT__Type.OER_encode(UpdateGprsLocationArg_usedRAT__Type_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_gprsSubscriptionDataNotNeeded.is_present()) {
      c |= 64;
      field_gprsSubscriptionDataNotNeeded.OER_encode(UpdateGprsLocationArg_gprsSubscriptionDataNotNeeded_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_nodeTypeIndicator.is_present()) {
      c |= 32;
      field_nodeTypeIndicator.OER_encode(UpdateGprsLocationArg_nodeTypeIndicator_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_areaRestricted.is_present()) {
      c |= 16;
      field_areaRestricted.OER_encode(UpdateGprsLocationArg_areaRestricted_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_ue__reachableIndicator.is_present()) {
      c |= 8;
      field_ue__reachableIndicator.OER_encode(UpdateGprsLocationArg_ue__reachableIndicator_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_epsSubscriptionDataNotNeeded.is_present()) {
      c |= 4;
      field_epsSubscriptionDataNotNeeded.OER_encode(UpdateGprsLocationArg_epsSubscriptionDataNotNeeded_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_ue__srvcc__Capability.is_present()) {
      c |= 2;
      field_ue__srvcc__Capability.OER_encode(UpdateGprsLocationArg_ue__srvcc__Capability_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    tmp_buf3.put_c(c);
    encode_oer_length(3, p_buf, FALSE);
    p_buf.put_c(1);
    p_buf.put_buf(tmp_buf3);
    p_buf.put_buf(tmp_buf);
    tmp_buf.clear();
  }
  return 0;
}

int UpdateGprsLocationArg::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_imsi.OER_decode(MAP__CommonDataTypes::IMSI_descr_, p_buf, p_oer);
  field_sgsn__Number.OER_decode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_buf, p_oer);
  field_sgsn__Address.OER_decode(MAP__CommonDataTypes::GSN__Address_descr_, p_buf, p_oer);
  if (uc[0] & 64)
    field_extensionContainer.OER_decode(UpdateGprsLocationArg_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
    if (!(uc[0] & 128)) {
      field_sgsn__Capability = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_sgsn__Capability.OER_decode(UpdateGprsLocationArg_sgsn__Capability_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 64)) {
      field_informPreviousNetworkEntity = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_informPreviousNetworkEntity.OER_decode(UpdateGprsLocationArg_informPreviousNetworkEntity_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 32)) {
      field_ps__LCS__NotSupportedByUE = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_ps__LCS__NotSupportedByUE.OER_decode(UpdateGprsLocationArg_ps__LCS__NotSupportedByUE_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 16)) {
      field_v__gmlc__Address = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_v__gmlc__Address.OER_decode(UpdateGprsLocationArg_v__gmlc__Address_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 8)) {
      field_add__info = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_add__info.OER_decode(UpdateGprsLocationArg_add__info_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 4)) {
      field_eps__info = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_eps__info.OER_decode(UpdateGprsLocationArg_eps__info_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 2)) {
      field_servingNodeTypeIndicator = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_servingNodeTypeIndicator.OER_decode(UpdateGprsLocationArg_servingNodeTypeIndicator_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 1)) {
      field_skipSubscriberDataUpdate = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_skipSubscriberDataUpdate.OER_decode(UpdateGprsLocationArg_skipSubscriberDataUpdate_descr_, p_buf, p_oer);
    }
    if (!(uc[1] & 128)) {
      field_usedRAT__Type = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_usedRAT__Type.OER_decode(UpdateGprsLocationArg_usedRAT__Type_descr_, p_buf, p_oer);
    }
    if (!(uc[1] & 64)) {
      field_gprsSubscriptionDataNotNeeded = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_gprsSubscriptionDataNotNeeded.OER_decode(UpdateGprsLocationArg_gprsSubscriptionDataNotNeeded_descr_, p_buf, p_oer);
    }
    if (!(uc[1] & 32)) {
      field_nodeTypeIndicator = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_nodeTypeIndicator.OER_decode(UpdateGprsLocationArg_nodeTypeIndicator_descr_, p_buf, p_oer);
    }
    if (!(uc[1] & 16)) {
      field_areaRestricted = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_areaRestricted.OER_decode(UpdateGprsLocationArg_areaRestricted_descr_, p_buf, p_oer);
    }
    if (!(uc[1] & 8)) {
      field_ue__reachableIndicator = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_ue__reachableIndicator.OER_decode(UpdateGprsLocationArg_ue__reachableIndicator_descr_, p_buf, p_oer);
    }
    if (!(uc[1] & 4)) {
      field_epsSubscriptionDataNotNeeded = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_epsSubscriptionDataNotNeeded.OER_decode(UpdateGprsLocationArg_epsSubscriptionDataNotNeeded_descr_, p_buf, p_oer);
    }
    if (!(uc[1] & 2)) {
      field_ue__srvcc__Capability = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_ue__srvcc__Capability.OER_decode(UpdateGprsLocationArg_ue__srvcc__Capability_descr_, p_buf, p_oer);
    }
  }
  else {
    field_sgsn__Capability = OMIT_VALUE;
    field_informPreviousNetworkEntity = OMIT_VALUE;
    field_ps__LCS__NotSupportedByUE = OMIT_VALUE;
    field_v__gmlc__Address = OMIT_VALUE;
    field_add__info = OMIT_VALUE;
    field_eps__info = OMIT_VALUE;
    field_servingNodeTypeIndicator = OMIT_VALUE;
    field_skipSubscriberDataUpdate = OMIT_VALUE;
    field_usedRAT__Type = OMIT_VALUE;
    field_gprsSubscriptionDataNotNeeded = OMIT_VALUE;
    field_nodeTypeIndicator = OMIT_VALUE;
    field_areaRestricted = OMIT_VALUE;
    field_ue__reachableIndicator = OMIT_VALUE;
    field_epsSubscriptionDataNotNeeded = OMIT_VALUE;
    field_ue__srvcc__Capability = OMIT_VALUE;
  }
  return 0;
}

void UpdateGprsLocationArg::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_0_present = field_sgsn__Capability.is_present();
boolean ext_1_present = field_informPreviousNetworkEntity.is_present();
boolean ext_2_present = field_ps__LCS__NotSupportedByUE.is_present();
boolean ext_3_present = field_v__gmlc__Address.is_present();
boolean ext_4_present = field_add__info.is_present();
boolean ext_5_present = field_eps__info.is_present();
boolean ext_6_present = field_servingNodeTypeIndicator.is_present();
boolean ext_7_present = field_skipSubscriberDataUpdate.is_present();
boolean ext_8_present = field_usedRAT__Type.is_present();
boolean ext_9_present = field_gprsSubscriptionDataNotNeeded.is_present();
boolean ext_10_present = field_nodeTypeIndicator.is_present();
boolean ext_11_present = field_areaRestricted.is_present();
boolean ext_12_present = field_ue__reachableIndicator.is_present();
boolean ext_13_present = field_epsSubscriptionDataNotNeeded.is_present();
boolean ext_14_present = field_ue__srvcc__Capability.is_present();
boolean ext_bit = ext_0_present || ext_1_present || ext_2_present || ext_3_present || ext_4_present || ext_5_present || ext_6_present || ext_7_present || ext_8_present || ext_9_present || ext_10_present || ext_11_present || ext_12_present || ext_13_present || ext_14_present;
p_buf.PER_put_bit(ext_bit);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
field_imsi.PER_encode(MAP__CommonDataTypes::IMSI_descr_, p_buf, p_options);
field_sgsn__Number.PER_encode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_buf, p_options);
field_sgsn__Address.PER_encode(MAP__CommonDataTypes::GSN__Address_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(UpdateGprsLocationArg_extensionContainer_descr_, p_buf, p_options);
if (ext_bit) {
INTEGER length_(15);
length_.PER_encode_length(p_buf, p_options, TRUE);
p_buf.PER_put_bit(ext_0_present);
p_buf.PER_put_bit(ext_1_present);
p_buf.PER_put_bit(ext_2_present);
p_buf.PER_put_bit(ext_3_present);
p_buf.PER_put_bit(ext_4_present);
p_buf.PER_put_bit(ext_5_present);
p_buf.PER_put_bit(ext_6_present);
p_buf.PER_put_bit(ext_7_present);
p_buf.PER_put_bit(ext_8_present);
p_buf.PER_put_bit(ext_9_present);
p_buf.PER_put_bit(ext_10_present);
p_buf.PER_put_bit(ext_11_present);
p_buf.PER_put_bit(ext_12_present);
p_buf.PER_put_bit(ext_13_present);
p_buf.PER_put_bit(ext_14_present);
if (ext_0_present) {
TTCN_Buffer ext_add_buf;
field_sgsn__Capability.PER_encode(UpdateGprsLocationArg_sgsn__Capability_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_1_present) {
TTCN_Buffer ext_add_buf;
field_informPreviousNetworkEntity.PER_encode(UpdateGprsLocationArg_informPreviousNetworkEntity_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_2_present) {
TTCN_Buffer ext_add_buf;
field_ps__LCS__NotSupportedByUE.PER_encode(UpdateGprsLocationArg_ps__LCS__NotSupportedByUE_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_3_present) {
TTCN_Buffer ext_add_buf;
field_v__gmlc__Address.PER_encode(UpdateGprsLocationArg_v__gmlc__Address_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_4_present) {
TTCN_Buffer ext_add_buf;
field_add__info.PER_encode(UpdateGprsLocationArg_add__info_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_5_present) {
TTCN_Buffer ext_add_buf;
field_eps__info.PER_encode(UpdateGprsLocationArg_eps__info_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_6_present) {
TTCN_Buffer ext_add_buf;
field_servingNodeTypeIndicator.PER_encode(UpdateGprsLocationArg_servingNodeTypeIndicator_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_7_present) {
TTCN_Buffer ext_add_buf;
field_skipSubscriberDataUpdate.PER_encode(UpdateGprsLocationArg_skipSubscriberDataUpdate_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_8_present) {
TTCN_Buffer ext_add_buf;
field_usedRAT__Type.PER_encode(UpdateGprsLocationArg_usedRAT__Type_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_9_present) {
TTCN_Buffer ext_add_buf;
field_gprsSubscriptionDataNotNeeded.PER_encode(UpdateGprsLocationArg_gprsSubscriptionDataNotNeeded_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_10_present) {
TTCN_Buffer ext_add_buf;
field_nodeTypeIndicator.PER_encode(UpdateGprsLocationArg_nodeTypeIndicator_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_11_present) {
TTCN_Buffer ext_add_buf;
field_areaRestricted.PER_encode(UpdateGprsLocationArg_areaRestricted_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_12_present) {
TTCN_Buffer ext_add_buf;
field_ue__reachableIndicator.PER_encode(UpdateGprsLocationArg_ue__reachableIndicator_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_13_present) {
TTCN_Buffer ext_add_buf;
field_epsSubscriptionDataNotNeeded.PER_encode(UpdateGprsLocationArg_epsSubscriptionDataNotNeeded_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_14_present) {
TTCN_Buffer ext_add_buf;
field_ue__srvcc__Capability.PER_encode(UpdateGprsLocationArg_ue__srvcc__Capability_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
}
}

void UpdateGprsLocationArg::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
field_imsi.PER_decode(MAP__CommonDataTypes::IMSI_descr_, p_buf, p_options);
field_sgsn__Number.PER_decode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_buf, p_options);
field_sgsn__Address.PER_decode(MAP__CommonDataTypes::GSN__Address_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_decode(UpdateGprsLocationArg_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
if (nof_decoded_ext_adds < 15) {
for (int i = nof_decoded_ext_adds; i < 15; ++i) {
ext_presences.push_back(FALSE);
}
}
if (ext_presences[0]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_sgsn__Capability.PER_decode(UpdateGprsLocationArg_sgsn__Capability_descr_, ext_add_buf, p_options);
}
else {
field_sgsn__Capability = OMIT_VALUE;
}
if (ext_presences[1]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_informPreviousNetworkEntity.PER_decode(UpdateGprsLocationArg_informPreviousNetworkEntity_descr_, ext_add_buf, p_options);
}
else {
field_informPreviousNetworkEntity = OMIT_VALUE;
}
if (ext_presences[2]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_ps__LCS__NotSupportedByUE.PER_decode(UpdateGprsLocationArg_ps__LCS__NotSupportedByUE_descr_, ext_add_buf, p_options);
}
else {
field_ps__LCS__NotSupportedByUE = OMIT_VALUE;
}
if (ext_presences[3]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_v__gmlc__Address.PER_decode(UpdateGprsLocationArg_v__gmlc__Address_descr_, ext_add_buf, p_options);
}
else {
field_v__gmlc__Address = OMIT_VALUE;
}
if (ext_presences[4]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_add__info.PER_decode(UpdateGprsLocationArg_add__info_descr_, ext_add_buf, p_options);
}
else {
field_add__info = OMIT_VALUE;
}
if (ext_presences[5]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_eps__info.PER_decode(UpdateGprsLocationArg_eps__info_descr_, ext_add_buf, p_options);
}
else {
field_eps__info = OMIT_VALUE;
}
if (ext_presences[6]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_servingNodeTypeIndicator.PER_decode(UpdateGprsLocationArg_servingNodeTypeIndicator_descr_, ext_add_buf, p_options);
}
else {
field_servingNodeTypeIndicator = OMIT_VALUE;
}
if (ext_presences[7]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_skipSubscriberDataUpdate.PER_decode(UpdateGprsLocationArg_skipSubscriberDataUpdate_descr_, ext_add_buf, p_options);
}
else {
field_skipSubscriberDataUpdate = OMIT_VALUE;
}
if (ext_presences[8]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_usedRAT__Type.PER_decode(UpdateGprsLocationArg_usedRAT__Type_descr_, ext_add_buf, p_options);
}
else {
field_usedRAT__Type = OMIT_VALUE;
}
if (ext_presences[9]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_gprsSubscriptionDataNotNeeded.PER_decode(UpdateGprsLocationArg_gprsSubscriptionDataNotNeeded_descr_, ext_add_buf, p_options);
}
else {
field_gprsSubscriptionDataNotNeeded = OMIT_VALUE;
}
if (ext_presences[10]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_nodeTypeIndicator.PER_decode(UpdateGprsLocationArg_nodeTypeIndicator_descr_, ext_add_buf, p_options);
}
else {
field_nodeTypeIndicator = OMIT_VALUE;
}
if (ext_presences[11]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_areaRestricted.PER_decode(UpdateGprsLocationArg_areaRestricted_descr_, ext_add_buf, p_options);
}
else {
field_areaRestricted = OMIT_VALUE;
}
if (ext_presences[12]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_ue__reachableIndicator.PER_decode(UpdateGprsLocationArg_ue__reachableIndicator_descr_, ext_add_buf, p_options);
}
else {
field_ue__reachableIndicator = OMIT_VALUE;
}
if (ext_presences[13]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_epsSubscriptionDataNotNeeded.PER_decode(UpdateGprsLocationArg_epsSubscriptionDataNotNeeded_descr_, ext_add_buf, p_options);
}
else {
field_epsSubscriptionDataNotNeeded = OMIT_VALUE;
}
if (ext_presences[14]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_ue__srvcc__Capability.PER_decode(UpdateGprsLocationArg_ue__srvcc__Capability_descr_, ext_add_buf, p_options);
}
else {
field_ue__srvcc__Capability = OMIT_VALUE;
}
if (nof_decoded_ext_adds > 15) for (int i = 15; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct UpdateGprsLocationArg_template::single_value_struct {
OCTETSTRING_template field_imsi;
OCTETSTRING_template field_sgsn__Number;
OCTETSTRING_template field_sgsn__Address;
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
SGSN__Capability_template field_sgsn__Capability;
ASN_NULL_template field_informPreviousNetworkEntity;
ASN_NULL_template field_ps__LCS__NotSupportedByUE;
OCTETSTRING_template field_v__gmlc__Address;
ADD__Info_template field_add__info;
EPS__Info_template field_eps__info;
ASN_NULL_template field_servingNodeTypeIndicator;
ASN_NULL_template field_skipSubscriberDataUpdate;
Used__RAT__Type_template field_usedRAT__Type;
ASN_NULL_template field_gprsSubscriptionDataNotNeeded;
ASN_NULL_template field_nodeTypeIndicator;
ASN_NULL_template field_areaRestricted;
ASN_NULL_template field_ue__reachableIndicator;
ASN_NULL_template field_epsSubscriptionDataNotNeeded;
UE__SRVCC__Capability_template field_ue__srvcc__Capability;
};

void UpdateGprsLocationArg_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_imsi = ANY_VALUE;
single_value->field_sgsn__Number = ANY_VALUE;
single_value->field_sgsn__Address = ANY_VALUE;
single_value->field_extensionContainer = ANY_OR_OMIT;
single_value->field_sgsn__Capability = ANY_OR_OMIT;
single_value->field_informPreviousNetworkEntity = ANY_OR_OMIT;
single_value->field_ps__LCS__NotSupportedByUE = ANY_OR_OMIT;
single_value->field_v__gmlc__Address = ANY_OR_OMIT;
single_value->field_add__info = ANY_OR_OMIT;
single_value->field_eps__info = ANY_OR_OMIT;
single_value->field_servingNodeTypeIndicator = ANY_OR_OMIT;
single_value->field_skipSubscriberDataUpdate = ANY_OR_OMIT;
single_value->field_usedRAT__Type = ANY_OR_OMIT;
single_value->field_gprsSubscriptionDataNotNeeded = ANY_OR_OMIT;
single_value->field_nodeTypeIndicator = ANY_OR_OMIT;
single_value->field_areaRestricted = ANY_OR_OMIT;
single_value->field_ue__reachableIndicator = ANY_OR_OMIT;
single_value->field_epsSubscriptionDataNotNeeded = ANY_OR_OMIT;
single_value->field_ue__srvcc__Capability = ANY_OR_OMIT;
}
}
}

void UpdateGprsLocationArg_template::copy_value(const UpdateGprsLocationArg& other_value)
{
single_value = new single_value_struct;
if (other_value.imsi().is_bound()) {
  single_value->field_imsi = other_value.imsi();
} else {
  single_value->field_imsi.clean_up();
}
if (other_value.sgsn__Number().is_bound()) {
  single_value->field_sgsn__Number = other_value.sgsn__Number();
} else {
  single_value->field_sgsn__Number.clean_up();
}
if (other_value.sgsn__Address().is_bound()) {
  single_value->field_sgsn__Address = other_value.sgsn__Address();
} else {
  single_value->field_sgsn__Address.clean_up();
}
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
if (other_value.sgsn__Capability().is_bound()) {
  if (other_value.sgsn__Capability().ispresent()) single_value->field_sgsn__Capability = other_value.sgsn__Capability()();
  else single_value->field_sgsn__Capability = OMIT_VALUE;
} else {
  single_value->field_sgsn__Capability.clean_up();
}
if (other_value.informPreviousNetworkEntity().is_bound()) {
  if (other_value.informPreviousNetworkEntity().ispresent()) single_value->field_informPreviousNetworkEntity = other_value.informPreviousNetworkEntity()();
  else single_value->field_informPreviousNetworkEntity = OMIT_VALUE;
} else {
  single_value->field_informPreviousNetworkEntity.clean_up();
}
if (other_value.ps__LCS__NotSupportedByUE().is_bound()) {
  if (other_value.ps__LCS__NotSupportedByUE().ispresent()) single_value->field_ps__LCS__NotSupportedByUE = other_value.ps__LCS__NotSupportedByUE()();
  else single_value->field_ps__LCS__NotSupportedByUE = OMIT_VALUE;
} else {
  single_value->field_ps__LCS__NotSupportedByUE.clean_up();
}
if (other_value.v__gmlc__Address().is_bound()) {
  if (other_value.v__gmlc__Address().ispresent()) single_value->field_v__gmlc__Address = other_value.v__gmlc__Address()();
  else single_value->field_v__gmlc__Address = OMIT_VALUE;
} else {
  single_value->field_v__gmlc__Address.clean_up();
}
if (other_value.add__info().is_bound()) {
  if (other_value.add__info().ispresent()) single_value->field_add__info = other_value.add__info()();
  else single_value->field_add__info = OMIT_VALUE;
} else {
  single_value->field_add__info.clean_up();
}
if (other_value.eps__info().is_bound()) {
  if (other_value.eps__info().ispresent()) single_value->field_eps__info = other_value.eps__info()();
  else single_value->field_eps__info = OMIT_VALUE;
} else {
  single_value->field_eps__info.clean_up();
}
if (other_value.servingNodeTypeIndicator().is_bound()) {
  if (other_value.servingNodeTypeIndicator().ispresent()) single_value->field_servingNodeTypeIndicator = other_value.servingNodeTypeIndicator()();
  else single_value->field_servingNodeTypeIndicator = OMIT_VALUE;
} else {
  single_value->field_servingNodeTypeIndicator.clean_up();
}
if (other_value.skipSubscriberDataUpdate().is_bound()) {
  if (other_value.skipSubscriberDataUpdate().ispresent()) single_value->field_skipSubscriberDataUpdate = other_value.skipSubscriberDataUpdate()();
  else single_value->field_skipSubscriberDataUpdate = OMIT_VALUE;
} else {
  single_value->field_skipSubscriberDataUpdate.clean_up();
}
if (other_value.usedRAT__Type().is_bound()) {
  if (other_value.usedRAT__Type().ispresent()) single_value->field_usedRAT__Type = other_value.usedRAT__Type()();
  else single_value->field_usedRAT__Type = OMIT_VALUE;
} else {
  single_value->field_usedRAT__Type.clean_up();
}
if (other_value.gprsSubscriptionDataNotNeeded().is_bound()) {
  if (other_value.gprsSubscriptionDataNotNeeded().ispresent()) single_value->field_gprsSubscriptionDataNotNeeded = other_value.gprsSubscriptionDataNotNeeded()();
  else single_value->field_gprsSubscriptionDataNotNeeded = OMIT_VALUE;
} else {
  single_value->field_gprsSubscriptionDataNotNeeded.clean_up();
}
if (other_value.nodeTypeIndicator().is_bound()) {
  if (other_value.nodeTypeIndicator().ispresent()) single_value->field_nodeTypeIndicator = other_value.nodeTypeIndicator()();
  else single_value->field_nodeTypeIndicator = OMIT_VALUE;
} else {
  single_value->field_nodeTypeIndicator.clean_up();
}
if (other_value.areaRestricted().is_bound()) {
  if (other_value.areaRestricted().ispresent()) single_value->field_areaRestricted = other_value.areaRestricted()();
  else single_value->field_areaRestricted = OMIT_VALUE;
} else {
  single_value->field_areaRestricted.clean_up();
}
if (other_value.ue__reachableIndicator().is_bound()) {
  if (other_value.ue__reachableIndicator().ispresent()) single_value->field_ue__reachableIndicator = other_value.ue__reachableIndicator()();
  else single_value->field_ue__reachableIndicator = OMIT_VALUE;
} else {
  single_value->field_ue__reachableIndicator.clean_up();
}
if (other_value.epsSubscriptionDataNotNeeded().is_bound()) {
  if (other_value.epsSubscriptionDataNotNeeded().ispresent()) single_value->field_epsSubscriptionDataNotNeeded = other_value.epsSubscriptionDataNotNeeded()();
  else single_value->field_epsSubscriptionDataNotNeeded = OMIT_VALUE;
} else {
  single_value->field_epsSubscriptionDataNotNeeded.clean_up();
}
if (other_value.ue__srvcc__Capability().is_bound()) {
  if (other_value.ue__srvcc__Capability().ispresent()) single_value->field_ue__srvcc__Capability = other_value.ue__srvcc__Capability()();
  else single_value->field_ue__srvcc__Capability = OMIT_VALUE;
} else {
  single_value->field_ue__srvcc__Capability.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void UpdateGprsLocationArg_template::copy_template(const UpdateGprsLocationArg_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.imsi().get_selection()) {
single_value->field_imsi = other_value.imsi();
} else {
single_value->field_imsi.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sgsn__Number().get_selection()) {
single_value->field_sgsn__Number = other_value.sgsn__Number();
} else {
single_value->field_sgsn__Number.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sgsn__Address().get_selection()) {
single_value->field_sgsn__Address = other_value.sgsn__Address();
} else {
single_value->field_sgsn__Address.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sgsn__Capability().get_selection()) {
single_value->field_sgsn__Capability = other_value.sgsn__Capability();
} else {
single_value->field_sgsn__Capability.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.informPreviousNetworkEntity().get_selection()) {
single_value->field_informPreviousNetworkEntity = other_value.informPreviousNetworkEntity();
} else {
single_value->field_informPreviousNetworkEntity.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ps__LCS__NotSupportedByUE().get_selection()) {
single_value->field_ps__LCS__NotSupportedByUE = other_value.ps__LCS__NotSupportedByUE();
} else {
single_value->field_ps__LCS__NotSupportedByUE.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.v__gmlc__Address().get_selection()) {
single_value->field_v__gmlc__Address = other_value.v__gmlc__Address();
} else {
single_value->field_v__gmlc__Address.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.add__info().get_selection()) {
single_value->field_add__info = other_value.add__info();
} else {
single_value->field_add__info.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.eps__info().get_selection()) {
single_value->field_eps__info = other_value.eps__info();
} else {
single_value->field_eps__info.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.servingNodeTypeIndicator().get_selection()) {
single_value->field_servingNodeTypeIndicator = other_value.servingNodeTypeIndicator();
} else {
single_value->field_servingNodeTypeIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.skipSubscriberDataUpdate().get_selection()) {
single_value->field_skipSubscriberDataUpdate = other_value.skipSubscriberDataUpdate();
} else {
single_value->field_skipSubscriberDataUpdate.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.usedRAT__Type().get_selection()) {
single_value->field_usedRAT__Type = other_value.usedRAT__Type();
} else {
single_value->field_usedRAT__Type.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.gprsSubscriptionDataNotNeeded().get_selection()) {
single_value->field_gprsSubscriptionDataNotNeeded = other_value.gprsSubscriptionDataNotNeeded();
} else {
single_value->field_gprsSubscriptionDataNotNeeded.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.nodeTypeIndicator().get_selection()) {
single_value->field_nodeTypeIndicator = other_value.nodeTypeIndicator();
} else {
single_value->field_nodeTypeIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.areaRestricted().get_selection()) {
single_value->field_areaRestricted = other_value.areaRestricted();
} else {
single_value->field_areaRestricted.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ue__reachableIndicator().get_selection()) {
single_value->field_ue__reachableIndicator = other_value.ue__reachableIndicator();
} else {
single_value->field_ue__reachableIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.epsSubscriptionDataNotNeeded().get_selection()) {
single_value->field_epsSubscriptionDataNotNeeded = other_value.epsSubscriptionDataNotNeeded();
} else {
single_value->field_epsSubscriptionDataNotNeeded.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.ue__srvcc__Capability().get_selection()) {
single_value->field_ue__srvcc__Capability = other_value.ue__srvcc__Capability();
} else {
single_value->field_ue__srvcc__Capability.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new UpdateGprsLocationArg_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new UpdateGprsLocationArg_template(*other_value.implication_.precondition);
implication_.implied_template = new UpdateGprsLocationArg_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
break;
}
set_selection(other_value);
}

UpdateGprsLocationArg_template::UpdateGprsLocationArg_template()
{
}

UpdateGprsLocationArg_template::UpdateGprsLocationArg_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

UpdateGprsLocationArg_template::UpdateGprsLocationArg_template(const UpdateGprsLocationArg& other_value)
{
copy_value(other_value);
}

UpdateGprsLocationArg_template::UpdateGprsLocationArg_template(const OPTIONAL<UpdateGprsLocationArg>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UpdateGprsLocationArg&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.UpdateGprsLocationArg from an unbound optional field.");
}
}

UpdateGprsLocationArg_template::UpdateGprsLocationArg_template(UpdateGprsLocationArg_template* p_precondition, UpdateGprsLocationArg_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

UpdateGprsLocationArg_template::UpdateGprsLocationArg_template(Dynamic_Match_Interface<UpdateGprsLocationArg>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<UpdateGprsLocationArg>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

UpdateGprsLocationArg_template::UpdateGprsLocationArg_template(const UpdateGprsLocationArg_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

UpdateGprsLocationArg_template::~UpdateGprsLocationArg_template()
{
clean_up();
}

UpdateGprsLocationArg_template& UpdateGprsLocationArg_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

UpdateGprsLocationArg_template& UpdateGprsLocationArg_template::operator=(const UpdateGprsLocationArg& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

UpdateGprsLocationArg_template& UpdateGprsLocationArg_template::operator=(const OPTIONAL<UpdateGprsLocationArg>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UpdateGprsLocationArg&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
}
return *this;
}

UpdateGprsLocationArg_template& UpdateGprsLocationArg_template::operator=(const UpdateGprsLocationArg_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean UpdateGprsLocationArg_template::match(const UpdateGprsLocationArg& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.imsi().is_bound()) return FALSE;
if(!single_value->field_imsi.match(other_value.imsi(), legacy))return FALSE;
if(!other_value.sgsn__Number().is_bound()) return FALSE;
if(!single_value->field_sgsn__Number.match(other_value.sgsn__Number(), legacy))return FALSE;
if(!other_value.sgsn__Address().is_bound()) return FALSE;
if(!single_value->field_sgsn__Address.match(other_value.sgsn__Address(), legacy))return FALSE;
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
if(!other_value.sgsn__Capability().is_bound()) return FALSE;
if((other_value.sgsn__Capability().ispresent() ? !single_value->field_sgsn__Capability.match((const SGSN__Capability&)other_value.sgsn__Capability(), legacy) : !single_value->field_sgsn__Capability.match_omit(legacy)))return FALSE;
if(!other_value.informPreviousNetworkEntity().is_bound()) return FALSE;
if((other_value.informPreviousNetworkEntity().ispresent() ? !single_value->field_informPreviousNetworkEntity.match((const ASN_NULL&)other_value.informPreviousNetworkEntity(), legacy) : !single_value->field_informPreviousNetworkEntity.match_omit(legacy)))return FALSE;
if(!other_value.ps__LCS__NotSupportedByUE().is_bound()) return FALSE;
if((other_value.ps__LCS__NotSupportedByUE().ispresent() ? !single_value->field_ps__LCS__NotSupportedByUE.match((const ASN_NULL&)other_value.ps__LCS__NotSupportedByUE(), legacy) : !single_value->field_ps__LCS__NotSupportedByUE.match_omit(legacy)))return FALSE;
if(!other_value.v__gmlc__Address().is_bound()) return FALSE;
if((other_value.v__gmlc__Address().ispresent() ? !single_value->field_v__gmlc__Address.match((const OCTETSTRING&)other_value.v__gmlc__Address(), legacy) : !single_value->field_v__gmlc__Address.match_omit(legacy)))return FALSE;
if(!other_value.add__info().is_bound()) return FALSE;
if((other_value.add__info().ispresent() ? !single_value->field_add__info.match((const ADD__Info&)other_value.add__info(), legacy) : !single_value->field_add__info.match_omit(legacy)))return FALSE;
if(!other_value.eps__info().is_bound()) return FALSE;
if((other_value.eps__info().ispresent() ? !single_value->field_eps__info.match((const EPS__Info&)other_value.eps__info(), legacy) : !single_value->field_eps__info.match_omit(legacy)))return FALSE;
if(!other_value.servingNodeTypeIndicator().is_bound()) return FALSE;
if((other_value.servingNodeTypeIndicator().ispresent() ? !single_value->field_servingNodeTypeIndicator.match((const ASN_NULL&)other_value.servingNodeTypeIndicator(), legacy) : !single_value->field_servingNodeTypeIndicator.match_omit(legacy)))return FALSE;
if(!other_value.skipSubscriberDataUpdate().is_bound()) return FALSE;
if((other_value.skipSubscriberDataUpdate().ispresent() ? !single_value->field_skipSubscriberDataUpdate.match((const ASN_NULL&)other_value.skipSubscriberDataUpdate(), legacy) : !single_value->field_skipSubscriberDataUpdate.match_omit(legacy)))return FALSE;
if(!other_value.usedRAT__Type().is_bound()) return FALSE;
if((other_value.usedRAT__Type().ispresent() ? !single_value->field_usedRAT__Type.match((const Used__RAT__Type&)other_value.usedRAT__Type(), legacy) : !single_value->field_usedRAT__Type.match_omit(legacy)))return FALSE;
if(!other_value.gprsSubscriptionDataNotNeeded().is_bound()) return FALSE;
if((other_value.gprsSubscriptionDataNotNeeded().ispresent() ? !single_value->field_gprsSubscriptionDataNotNeeded.match((const ASN_NULL&)other_value.gprsSubscriptionDataNotNeeded(), legacy) : !single_value->field_gprsSubscriptionDataNotNeeded.match_omit(legacy)))return FALSE;
if(!other_value.nodeTypeIndicator().is_bound()) return FALSE;
if((other_value.nodeTypeIndicator().ispresent() ? !single_value->field_nodeTypeIndicator.match((const ASN_NULL&)other_value.nodeTypeIndicator(), legacy) : !single_value->field_nodeTypeIndicator.match_omit(legacy)))return FALSE;
if(!other_value.areaRestricted().is_bound()) return FALSE;
if((other_value.areaRestricted().ispresent() ? !single_value->field_areaRestricted.match((const ASN_NULL&)other_value.areaRestricted(), legacy) : !single_value->field_areaRestricted.match_omit(legacy)))return FALSE;
if(!other_value.ue__reachableIndicator().is_bound()) return FALSE;
if((other_value.ue__reachableIndicator().ispresent() ? !single_value->field_ue__reachableIndicator.match((const ASN_NULL&)other_value.ue__reachableIndicator(), legacy) : !single_value->field_ue__reachableIndicator.match_omit(legacy)))return FALSE;
if(!other_value.epsSubscriptionDataNotNeeded().is_bound()) return FALSE;
if((other_value.epsSubscriptionDataNotNeeded().ispresent() ? !single_value->field_epsSubscriptionDataNotNeeded.match((const ASN_NULL&)other_value.epsSubscriptionDataNotNeeded(), legacy) : !single_value->field_epsSubscriptionDataNotNeeded.match_omit(legacy)))return FALSE;
if(!other_value.ue__srvcc__Capability().is_bound()) return FALSE;
if((other_value.ue__srvcc__Capability().ispresent() ? !single_value->field_ue__srvcc__Capability.match((const UE__SRVCC__Capability&)other_value.ue__srvcc__Capability(), legacy) : !single_value->field_ue__srvcc__Capability.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
}
return FALSE;
}

boolean UpdateGprsLocationArg_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return single_value->field_imsi.is_bound()
 || single_value->field_sgsn__Number.is_bound()
 || single_value->field_sgsn__Address.is_bound()
 || (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound())
 || (single_value->field_sgsn__Capability.is_omit() || single_value->field_sgsn__Capability.is_bound())
 || (single_value->field_informPreviousNetworkEntity.is_omit() || single_value->field_informPreviousNetworkEntity.is_bound())
 || (single_value->field_ps__LCS__NotSupportedByUE.is_omit() || single_value->field_ps__LCS__NotSupportedByUE.is_bound())
 || (single_value->field_v__gmlc__Address.is_omit() || single_value->field_v__gmlc__Address.is_bound())
 || (single_value->field_add__info.is_omit() || single_value->field_add__info.is_bound())
 || (single_value->field_eps__info.is_omit() || single_value->field_eps__info.is_bound())
 || (single_value->field_servingNodeTypeIndicator.is_omit() || single_value->field_servingNodeTypeIndicator.is_bound())
 || (single_value->field_skipSubscriberDataUpdate.is_omit() || single_value->field_skipSubscriberDataUpdate.is_bound())
 || (single_value->field_usedRAT__Type.is_omit() || single_value->field_usedRAT__Type.is_bound())
 || (single_value->field_gprsSubscriptionDataNotNeeded.is_omit() || single_value->field_gprsSubscriptionDataNotNeeded.is_bound())
 || (single_value->field_nodeTypeIndicator.is_omit() || single_value->field_nodeTypeIndicator.is_bound())
 || (single_value->field_areaRestricted.is_omit() || single_value->field_areaRestricted.is_bound())
 || (single_value->field_ue__reachableIndicator.is_omit() || single_value->field_ue__reachableIndicator.is_bound())
 || (single_value->field_epsSubscriptionDataNotNeeded.is_omit() || single_value->field_epsSubscriptionDataNotNeeded.is_bound())
 || (single_value->field_ue__srvcc__Capability.is_omit() || single_value->field_ue__srvcc__Capability.is_bound());
}

boolean UpdateGprsLocationArg_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value->field_imsi.is_value()
 && single_value->field_sgsn__Number.is_value()
 && single_value->field_sgsn__Address.is_value()
 && (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value())
 && (single_value->field_sgsn__Capability.is_omit() || single_value->field_sgsn__Capability.is_value())
 && (single_value->field_informPreviousNetworkEntity.is_omit() || single_value->field_informPreviousNetworkEntity.is_value())
 && (single_value->field_ps__LCS__NotSupportedByUE.is_omit() || single_value->field_ps__LCS__NotSupportedByUE.is_value())
 && (single_value->field_v__gmlc__Address.is_omit() || single_value->field_v__gmlc__Address.is_value())
 && (single_value->field_add__info.is_omit() || single_value->field_add__info.is_value())
 && (single_value->field_eps__info.is_omit() || single_value->field_eps__info.is_value())
 && (single_value->field_servingNodeTypeIndicator.is_omit() || single_value->field_servingNodeTypeIndicator.is_value())
 && (single_value->field_skipSubscriberDataUpdate.is_omit() || single_value->field_skipSubscriberDataUpdate.is_value())
 && (single_value->field_usedRAT__Type.is_omit() || single_value->field_usedRAT__Type.is_value())
 && (single_value->field_gprsSubscriptionDataNotNeeded.is_omit() || single_value->field_gprsSubscriptionDataNotNeeded.is_value())
 && (single_value->field_nodeTypeIndicator.is_omit() || single_value->field_nodeTypeIndicator.is_value())
 && (single_value->field_areaRestricted.is_omit() || single_value->field_areaRestricted.is_value())
 && (single_value->field_ue__reachableIndicator.is_omit() || single_value->field_ue__reachableIndicator.is_value())
 && (single_value->field_epsSubscriptionDataNotNeeded.is_omit() || single_value->field_epsSubscriptionDataNotNeeded.is_value())
 && (single_value->field_ue__srvcc__Capability.is_omit() || single_value->field_ue__srvcc__Capability.is_value());
}

void UpdateGprsLocationArg_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

UpdateGprsLocationArg UpdateGprsLocationArg_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
UpdateGprsLocationArg ret_val;
if (single_value->field_imsi.is_bound()) {
ret_val.imsi() = single_value->field_imsi.valueof();
}
if (single_value->field_sgsn__Number.is_bound()) {
ret_val.sgsn__Number() = single_value->field_sgsn__Number.valueof();
}
if (single_value->field_sgsn__Address.is_bound()) {
ret_val.sgsn__Address() = single_value->field_sgsn__Address.valueof();
}
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
if (single_value->field_sgsn__Capability.is_omit()) ret_val.sgsn__Capability() = OMIT_VALUE;
else if (single_value->field_sgsn__Capability.is_bound()) {
ret_val.sgsn__Capability() = single_value->field_sgsn__Capability.valueof();
}
if (single_value->field_informPreviousNetworkEntity.is_omit()) ret_val.informPreviousNetworkEntity() = OMIT_VALUE;
else if (single_value->field_informPreviousNetworkEntity.is_bound()) {
ret_val.informPreviousNetworkEntity() = single_value->field_informPreviousNetworkEntity.valueof();
}
if (single_value->field_ps__LCS__NotSupportedByUE.is_omit()) ret_val.ps__LCS__NotSupportedByUE() = OMIT_VALUE;
else if (single_value->field_ps__LCS__NotSupportedByUE.is_bound()) {
ret_val.ps__LCS__NotSupportedByUE() = single_value->field_ps__LCS__NotSupportedByUE.valueof();
}
if (single_value->field_v__gmlc__Address.is_omit()) ret_val.v__gmlc__Address() = OMIT_VALUE;
else if (single_value->field_v__gmlc__Address.is_bound()) {
ret_val.v__gmlc__Address() = single_value->field_v__gmlc__Address.valueof();
}
if (single_value->field_add__info.is_omit()) ret_val.add__info() = OMIT_VALUE;
else if (single_value->field_add__info.is_bound()) {
ret_val.add__info() = single_value->field_add__info.valueof();
}
if (single_value->field_eps__info.is_omit()) ret_val.eps__info() = OMIT_VALUE;
else if (single_value->field_eps__info.is_bound()) {
ret_val.eps__info() = single_value->field_eps__info.valueof();
}
if (single_value->field_servingNodeTypeIndicator.is_omit()) ret_val.servingNodeTypeIndicator() = OMIT_VALUE;
else if (single_value->field_servingNodeTypeIndicator.is_bound()) {
ret_val.servingNodeTypeIndicator() = single_value->field_servingNodeTypeIndicator.valueof();
}
if (single_value->field_skipSubscriberDataUpdate.is_omit()) ret_val.skipSubscriberDataUpdate() = OMIT_VALUE;
else if (single_value->field_skipSubscriberDataUpdate.is_bound()) {
ret_val.skipSubscriberDataUpdate() = single_value->field_skipSubscriberDataUpdate.valueof();
}
if (single_value->field_usedRAT__Type.is_omit()) ret_val.usedRAT__Type() = OMIT_VALUE;
else if (single_value->field_usedRAT__Type.is_bound()) {
ret_val.usedRAT__Type() = single_value->field_usedRAT__Type.valueof();
}
if (single_value->field_gprsSubscriptionDataNotNeeded.is_omit()) ret_val.gprsSubscriptionDataNotNeeded() = OMIT_VALUE;
else if (single_value->field_gprsSubscriptionDataNotNeeded.is_bound()) {
ret_val.gprsSubscriptionDataNotNeeded() = single_value->field_gprsSubscriptionDataNotNeeded.valueof();
}
if (single_value->field_nodeTypeIndicator.is_omit()) ret_val.nodeTypeIndicator() = OMIT_VALUE;
else if (single_value->field_nodeTypeIndicator.is_bound()) {
ret_val.nodeTypeIndicator() = single_value->field_nodeTypeIndicator.valueof();
}
if (single_value->field_areaRestricted.is_omit()) ret_val.areaRestricted() = OMIT_VALUE;
else if (single_value->field_areaRestricted.is_bound()) {
ret_val.areaRestricted() = single_value->field_areaRestricted.valueof();
}
if (single_value->field_ue__reachableIndicator.is_omit()) ret_val.ue__reachableIndicator() = OMIT_VALUE;
else if (single_value->field_ue__reachableIndicator.is_bound()) {
ret_val.ue__reachableIndicator() = single_value->field_ue__reachableIndicator.valueof();
}
if (single_value->field_epsSubscriptionDataNotNeeded.is_omit()) ret_val.epsSubscriptionDataNotNeeded() = OMIT_VALUE;
else if (single_value->field_epsSubscriptionDataNotNeeded.is_bound()) {
ret_val.epsSubscriptionDataNotNeeded() = single_value->field_epsSubscriptionDataNotNeeded.valueof();
}
if (single_value->field_ue__srvcc__Capability.is_omit()) ret_val.ue__srvcc__Capability() = OMIT_VALUE;
else if (single_value->field_ue__srvcc__Capability.is_bound()) {
ret_val.ue__srvcc__Capability() = single_value->field_ue__srvcc__Capability.valueof();
}
return ret_val;
}

void UpdateGprsLocationArg_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new UpdateGprsLocationArg_template[list_length];
}

UpdateGprsLocationArg_template& UpdateGprsLocationArg_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& UpdateGprsLocationArg_template::imsi()
{
set_specific();
return single_value->field_imsi;
}

const OCTETSTRING_template& UpdateGprsLocationArg_template::imsi() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field imsi of a non-specific template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
return single_value->field_imsi;
}

OCTETSTRING_template& UpdateGprsLocationArg_template::sgsn__Number()
{
set_specific();
return single_value->field_sgsn__Number;
}

const OCTETSTRING_template& UpdateGprsLocationArg_template::sgsn__Number() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sgsn_Number of a non-specific template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
return single_value->field_sgsn__Number;
}

OCTETSTRING_template& UpdateGprsLocationArg_template::sgsn__Address()
{
set_specific();
return single_value->field_sgsn__Address;
}

const OCTETSTRING_template& UpdateGprsLocationArg_template::sgsn__Address() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sgsn_Address of a non-specific template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
return single_value->field_sgsn__Address;
}

MAP__ExtensionDataTypes::ExtensionContainer_template& UpdateGprsLocationArg_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& UpdateGprsLocationArg_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
return single_value->field_extensionContainer;
}

SGSN__Capability_template& UpdateGprsLocationArg_template::sgsn__Capability()
{
set_specific();
return single_value->field_sgsn__Capability;
}

const SGSN__Capability_template& UpdateGprsLocationArg_template::sgsn__Capability() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field sgsn_Capability of a non-specific template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
return single_value->field_sgsn__Capability;
}

ASN_NULL_template& UpdateGprsLocationArg_template::informPreviousNetworkEntity()
{
set_specific();
return single_value->field_informPreviousNetworkEntity;
}

const ASN_NULL_template& UpdateGprsLocationArg_template::informPreviousNetworkEntity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field informPreviousNetworkEntity of a non-specific template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
return single_value->field_informPreviousNetworkEntity;
}

ASN_NULL_template& UpdateGprsLocationArg_template::ps__LCS__NotSupportedByUE()
{
set_specific();
return single_value->field_ps__LCS__NotSupportedByUE;
}

const ASN_NULL_template& UpdateGprsLocationArg_template::ps__LCS__NotSupportedByUE() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ps_LCS_NotSupportedByUE of a non-specific template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
return single_value->field_ps__LCS__NotSupportedByUE;
}

OCTETSTRING_template& UpdateGprsLocationArg_template::v__gmlc__Address()
{
set_specific();
return single_value->field_v__gmlc__Address;
}

const OCTETSTRING_template& UpdateGprsLocationArg_template::v__gmlc__Address() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field v_gmlc_Address of a non-specific template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
return single_value->field_v__gmlc__Address;
}

ADD__Info_template& UpdateGprsLocationArg_template::add__info()
{
set_specific();
return single_value->field_add__info;
}

const ADD__Info_template& UpdateGprsLocationArg_template::add__info() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field add_info of a non-specific template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
return single_value->field_add__info;
}

EPS__Info_template& UpdateGprsLocationArg_template::eps__info()
{
set_specific();
return single_value->field_eps__info;
}

const EPS__Info_template& UpdateGprsLocationArg_template::eps__info() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field eps_info of a non-specific template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
return single_value->field_eps__info;
}

ASN_NULL_template& UpdateGprsLocationArg_template::servingNodeTypeIndicator()
{
set_specific();
return single_value->field_servingNodeTypeIndicator;
}

const ASN_NULL_template& UpdateGprsLocationArg_template::servingNodeTypeIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field servingNodeTypeIndicator of a non-specific template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
return single_value->field_servingNodeTypeIndicator;
}

ASN_NULL_template& UpdateGprsLocationArg_template::skipSubscriberDataUpdate()
{
set_specific();
return single_value->field_skipSubscriberDataUpdate;
}

const ASN_NULL_template& UpdateGprsLocationArg_template::skipSubscriberDataUpdate() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field skipSubscriberDataUpdate of a non-specific template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
return single_value->field_skipSubscriberDataUpdate;
}

Used__RAT__Type_template& UpdateGprsLocationArg_template::usedRAT__Type()
{
set_specific();
return single_value->field_usedRAT__Type;
}

const Used__RAT__Type_template& UpdateGprsLocationArg_template::usedRAT__Type() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field usedRAT_Type of a non-specific template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
return single_value->field_usedRAT__Type;
}

ASN_NULL_template& UpdateGprsLocationArg_template::gprsSubscriptionDataNotNeeded()
{
set_specific();
return single_value->field_gprsSubscriptionDataNotNeeded;
}

const ASN_NULL_template& UpdateGprsLocationArg_template::gprsSubscriptionDataNotNeeded() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field gprsSubscriptionDataNotNeeded of a non-specific template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
return single_value->field_gprsSubscriptionDataNotNeeded;
}

ASN_NULL_template& UpdateGprsLocationArg_template::nodeTypeIndicator()
{
set_specific();
return single_value->field_nodeTypeIndicator;
}

const ASN_NULL_template& UpdateGprsLocationArg_template::nodeTypeIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field nodeTypeIndicator of a non-specific template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
return single_value->field_nodeTypeIndicator;
}

ASN_NULL_template& UpdateGprsLocationArg_template::areaRestricted()
{
set_specific();
return single_value->field_areaRestricted;
}

const ASN_NULL_template& UpdateGprsLocationArg_template::areaRestricted() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field areaRestricted of a non-specific template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
return single_value->field_areaRestricted;
}

ASN_NULL_template& UpdateGprsLocationArg_template::ue__reachableIndicator()
{
set_specific();
return single_value->field_ue__reachableIndicator;
}

const ASN_NULL_template& UpdateGprsLocationArg_template::ue__reachableIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ue_reachableIndicator of a non-specific template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
return single_value->field_ue__reachableIndicator;
}

ASN_NULL_template& UpdateGprsLocationArg_template::epsSubscriptionDataNotNeeded()
{
set_specific();
return single_value->field_epsSubscriptionDataNotNeeded;
}

const ASN_NULL_template& UpdateGprsLocationArg_template::epsSubscriptionDataNotNeeded() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field epsSubscriptionDataNotNeeded of a non-specific template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
return single_value->field_epsSubscriptionDataNotNeeded;
}

UE__SRVCC__Capability_template& UpdateGprsLocationArg_template::ue__srvcc__Capability()
{
set_specific();
return single_value->field_ue__srvcc__Capability;
}

const UE__SRVCC__Capability_template& UpdateGprsLocationArg_template::ue__srvcc__Capability() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field ue_srvcc_Capability of a non-specific template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
return single_value->field_ue__srvcc__Capability;
}

int UpdateGprsLocationArg_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.UpdateGprsLocationArg which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 3;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      if (single_value->field_sgsn__Capability.is_present()) ret_val++;
      if (single_value->field_informPreviousNetworkEntity.is_present()) ret_val++;
      if (single_value->field_ps__LCS__NotSupportedByUE.is_present()) ret_val++;
      if (single_value->field_v__gmlc__Address.is_present()) ret_val++;
      if (single_value->field_add__info.is_present()) ret_val++;
      if (single_value->field_eps__info.is_present()) ret_val++;
      if (single_value->field_servingNodeTypeIndicator.is_present()) ret_val++;
      if (single_value->field_skipSubscriberDataUpdate.is_present()) ret_val++;
      if (single_value->field_usedRAT__Type.is_present()) ret_val++;
      if (single_value->field_gprsSubscriptionDataNotNeeded.is_present()) ret_val++;
      if (single_value->field_nodeTypeIndicator.is_present()) ret_val++;
      if (single_value->field_areaRestricted.is_present()) ret_val++;
      if (single_value->field_ue__reachableIndicator.is_present()) ret_val++;
      if (single_value->field_epsSubscriptionDataNotNeeded.is_present()) ret_val++;
      if (single_value->field_ue__srvcc__Capability.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.UpdateGprsLocationArg containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.UpdateGprsLocationArg containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.UpdateGprsLocationArg containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.UpdateGprsLocationArg containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.UpdateGprsLocationArg containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.UpdateGprsLocationArg containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.UpdateGprsLocationArg containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.UpdateGprsLocationArg containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
  }
  return 0;
}

void UpdateGprsLocationArg_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ imsi := ");
single_value->field_imsi.log();
TTCN_Logger::log_event_str(", sgsn_Number := ");
single_value->field_sgsn__Number.log();
TTCN_Logger::log_event_str(", sgsn_Address := ");
single_value->field_sgsn__Address.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(", sgsn_Capability := ");
single_value->field_sgsn__Capability.log();
TTCN_Logger::log_event_str(", informPreviousNetworkEntity := ");
single_value->field_informPreviousNetworkEntity.log();
TTCN_Logger::log_event_str(", ps_LCS_NotSupportedByUE := ");
single_value->field_ps__LCS__NotSupportedByUE.log();
TTCN_Logger::log_event_str(", v_gmlc_Address := ");
single_value->field_v__gmlc__Address.log();
TTCN_Logger::log_event_str(", add_info := ");
single_value->field_add__info.log();
TTCN_Logger::log_event_str(", eps_info := ");
single_value->field_eps__info.log();
TTCN_Logger::log_event_str(", servingNodeTypeIndicator := ");
single_value->field_servingNodeTypeIndicator.log();
TTCN_Logger::log_event_str(", skipSubscriberDataUpdate := ");
single_value->field_skipSubscriberDataUpdate.log();
TTCN_Logger::log_event_str(", usedRAT_Type := ");
single_value->field_usedRAT__Type.log();
TTCN_Logger::log_event_str(", gprsSubscriptionDataNotNeeded := ");
single_value->field_gprsSubscriptionDataNotNeeded.log();
TTCN_Logger::log_event_str(", nodeTypeIndicator := ");
single_value->field_nodeTypeIndicator.log();
TTCN_Logger::log_event_str(", areaRestricted := ");
single_value->field_areaRestricted.log();
TTCN_Logger::log_event_str(", ue_reachableIndicator := ");
single_value->field_ue__reachableIndicator.log();
TTCN_Logger::log_event_str(", epsSubscriptionDataNotNeeded := ");
single_value->field_epsSubscriptionDataNotNeeded.log();
TTCN_Logger::log_event_str(", ue_srvcc_Capability := ");
single_value->field_ue__srvcc__Capability.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void UpdateGprsLocationArg_template::log_match(const UpdateGprsLocationArg& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if(!single_value->field_imsi.match(match_value.imsi(), legacy)){
TTCN_Logger::log_logmatch_info(".imsi");
single_value->field_imsi.log_match(match_value.imsi(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sgsn__Number.match(match_value.sgsn__Number(), legacy)){
TTCN_Logger::log_logmatch_info(".sgsn_Number");
single_value->field_sgsn__Number.log_match(match_value.sgsn__Number(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if(!single_value->field_sgsn__Address.match(match_value.sgsn__Address(), legacy)){
TTCN_Logger::log_logmatch_info(".sgsn_Address");
single_value->field_sgsn__Address.log_match(match_value.sgsn__Address(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.sgsn__Capability().ispresent()){
if(!single_value->field_sgsn__Capability.match(match_value.sgsn__Capability(), legacy)){
TTCN_Logger::log_logmatch_info(".sgsn_Capability");
single_value->field_sgsn__Capability.log_match(match_value.sgsn__Capability(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_sgsn__Capability.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".sgsn_Capability := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_sgsn__Capability.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.informPreviousNetworkEntity().ispresent()){
if(!single_value->field_informPreviousNetworkEntity.match(match_value.informPreviousNetworkEntity(), legacy)){
TTCN_Logger::log_logmatch_info(".informPreviousNetworkEntity");
single_value->field_informPreviousNetworkEntity.log_match(match_value.informPreviousNetworkEntity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_informPreviousNetworkEntity.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".informPreviousNetworkEntity := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_informPreviousNetworkEntity.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.ps__LCS__NotSupportedByUE().ispresent()){
if(!single_value->field_ps__LCS__NotSupportedByUE.match(match_value.ps__LCS__NotSupportedByUE(), legacy)){
TTCN_Logger::log_logmatch_info(".ps_LCS_NotSupportedByUE");
single_value->field_ps__LCS__NotSupportedByUE.log_match(match_value.ps__LCS__NotSupportedByUE(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_ps__LCS__NotSupportedByUE.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".ps_LCS_NotSupportedByUE := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_ps__LCS__NotSupportedByUE.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.v__gmlc__Address().ispresent()){
if(!single_value->field_v__gmlc__Address.match(match_value.v__gmlc__Address(), legacy)){
TTCN_Logger::log_logmatch_info(".v_gmlc_Address");
single_value->field_v__gmlc__Address.log_match(match_value.v__gmlc__Address(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_v__gmlc__Address.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".v_gmlc_Address := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_v__gmlc__Address.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.add__info().ispresent()){
if(!single_value->field_add__info.match(match_value.add__info(), legacy)){
TTCN_Logger::log_logmatch_info(".add_info");
single_value->field_add__info.log_match(match_value.add__info(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_add__info.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".add_info := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_add__info.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.eps__info().ispresent()){
if(!single_value->field_eps__info.match(match_value.eps__info(), legacy)){
TTCN_Logger::log_logmatch_info(".eps_info");
single_value->field_eps__info.log_match(match_value.eps__info(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_eps__info.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".eps_info := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_eps__info.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.servingNodeTypeIndicator().ispresent()){
if(!single_value->field_servingNodeTypeIndicator.match(match_value.servingNodeTypeIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".servingNodeTypeIndicator");
single_value->field_servingNodeTypeIndicator.log_match(match_value.servingNodeTypeIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_servingNodeTypeIndicator.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".servingNodeTypeIndicator := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_servingNodeTypeIndicator.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.skipSubscriberDataUpdate().ispresent()){
if(!single_value->field_skipSubscriberDataUpdate.match(match_value.skipSubscriberDataUpdate(), legacy)){
TTCN_Logger::log_logmatch_info(".skipSubscriberDataUpdate");
single_value->field_skipSubscriberDataUpdate.log_match(match_value.skipSubscriberDataUpdate(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_skipSubscriberDataUpdate.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".skipSubscriberDataUpdate := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_skipSubscriberDataUpdate.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.usedRAT__Type().ispresent()){
if(!single_value->field_usedRAT__Type.match(match_value.usedRAT__Type(), legacy)){
TTCN_Logger::log_logmatch_info(".usedRAT_Type");
single_value->field_usedRAT__Type.log_match(match_value.usedRAT__Type(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_usedRAT__Type.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".usedRAT_Type := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_usedRAT__Type.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.gprsSubscriptionDataNotNeeded().ispresent()){
if(!single_value->field_gprsSubscriptionDataNotNeeded.match(match_value.gprsSubscriptionDataNotNeeded(), legacy)){
TTCN_Logger::log_logmatch_info(".gprsSubscriptionDataNotNeeded");
single_value->field_gprsSubscriptionDataNotNeeded.log_match(match_value.gprsSubscriptionDataNotNeeded(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_gprsSubscriptionDataNotNeeded.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".gprsSubscriptionDataNotNeeded := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_gprsSubscriptionDataNotNeeded.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.nodeTypeIndicator().ispresent()){
if(!single_value->field_nodeTypeIndicator.match(match_value.nodeTypeIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".nodeTypeIndicator");
single_value->field_nodeTypeIndicator.log_match(match_value.nodeTypeIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_nodeTypeIndicator.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".nodeTypeIndicator := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_nodeTypeIndicator.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.areaRestricted().ispresent()){
if(!single_value->field_areaRestricted.match(match_value.areaRestricted(), legacy)){
TTCN_Logger::log_logmatch_info(".areaRestricted");
single_value->field_areaRestricted.log_match(match_value.areaRestricted(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_areaRestricted.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".areaRestricted := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_areaRestricted.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.ue__reachableIndicator().ispresent()){
if(!single_value->field_ue__reachableIndicator.match(match_value.ue__reachableIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".ue_reachableIndicator");
single_value->field_ue__reachableIndicator.log_match(match_value.ue__reachableIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_ue__reachableIndicator.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".ue_reachableIndicator := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_ue__reachableIndicator.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.epsSubscriptionDataNotNeeded().ispresent()){
if(!single_value->field_epsSubscriptionDataNotNeeded.match(match_value.epsSubscriptionDataNotNeeded(), legacy)){
TTCN_Logger::log_logmatch_info(".epsSubscriptionDataNotNeeded");
single_value->field_epsSubscriptionDataNotNeeded.log_match(match_value.epsSubscriptionDataNotNeeded(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_epsSubscriptionDataNotNeeded.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".epsSubscriptionDataNotNeeded := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_epsSubscriptionDataNotNeeded.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.ue__srvcc__Capability().ispresent()){
if(!single_value->field_ue__srvcc__Capability.match(match_value.ue__srvcc__Capability(), legacy)){
TTCN_Logger::log_logmatch_info(".ue_srvcc_Capability");
single_value->field_ue__srvcc__Capability.log_match(match_value.ue__srvcc__Capability(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_ue__srvcc__Capability.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".ue_srvcc_Capability := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_ue__srvcc__Capability.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ imsi := ");
single_value->field_imsi.log_match(match_value.imsi(), legacy);
TTCN_Logger::log_event_str(", sgsn_Number := ");
single_value->field_sgsn__Number.log_match(match_value.sgsn__Number(), legacy);
TTCN_Logger::log_event_str(", sgsn_Address := ");
single_value->field_sgsn__Address.log_match(match_value.sgsn__Address(), legacy);
TTCN_Logger::log_event_str(", extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", sgsn_Capability := ");
if (match_value.sgsn__Capability().ispresent()) {
single_value->field_sgsn__Capability.log_match(match_value.sgsn__Capability(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_sgsn__Capability.log();
if (single_value->field_sgsn__Capability.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", informPreviousNetworkEntity := ");
if (match_value.informPreviousNetworkEntity().ispresent()) {
single_value->field_informPreviousNetworkEntity.log_match(match_value.informPreviousNetworkEntity(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_informPreviousNetworkEntity.log();
if (single_value->field_informPreviousNetworkEntity.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", ps_LCS_NotSupportedByUE := ");
if (match_value.ps__LCS__NotSupportedByUE().ispresent()) {
single_value->field_ps__LCS__NotSupportedByUE.log_match(match_value.ps__LCS__NotSupportedByUE(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_ps__LCS__NotSupportedByUE.log();
if (single_value->field_ps__LCS__NotSupportedByUE.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", v_gmlc_Address := ");
if (match_value.v__gmlc__Address().ispresent()) {
single_value->field_v__gmlc__Address.log_match(match_value.v__gmlc__Address(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_v__gmlc__Address.log();
if (single_value->field_v__gmlc__Address.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", add_info := ");
if (match_value.add__info().ispresent()) {
single_value->field_add__info.log_match(match_value.add__info(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_add__info.log();
if (single_value->field_add__info.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", eps_info := ");
if (match_value.eps__info().ispresent()) {
single_value->field_eps__info.log_match(match_value.eps__info(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_eps__info.log();
if (single_value->field_eps__info.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", servingNodeTypeIndicator := ");
if (match_value.servingNodeTypeIndicator().ispresent()) {
single_value->field_servingNodeTypeIndicator.log_match(match_value.servingNodeTypeIndicator(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_servingNodeTypeIndicator.log();
if (single_value->field_servingNodeTypeIndicator.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", skipSubscriberDataUpdate := ");
if (match_value.skipSubscriberDataUpdate().ispresent()) {
single_value->field_skipSubscriberDataUpdate.log_match(match_value.skipSubscriberDataUpdate(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_skipSubscriberDataUpdate.log();
if (single_value->field_skipSubscriberDataUpdate.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", usedRAT_Type := ");
if (match_value.usedRAT__Type().ispresent()) {
single_value->field_usedRAT__Type.log_match(match_value.usedRAT__Type(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_usedRAT__Type.log();
if (single_value->field_usedRAT__Type.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", gprsSubscriptionDataNotNeeded := ");
if (match_value.gprsSubscriptionDataNotNeeded().ispresent()) {
single_value->field_gprsSubscriptionDataNotNeeded.log_match(match_value.gprsSubscriptionDataNotNeeded(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_gprsSubscriptionDataNotNeeded.log();
if (single_value->field_gprsSubscriptionDataNotNeeded.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", nodeTypeIndicator := ");
if (match_value.nodeTypeIndicator().ispresent()) {
single_value->field_nodeTypeIndicator.log_match(match_value.nodeTypeIndicator(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_nodeTypeIndicator.log();
if (single_value->field_nodeTypeIndicator.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", areaRestricted := ");
if (match_value.areaRestricted().ispresent()) {
single_value->field_areaRestricted.log_match(match_value.areaRestricted(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_areaRestricted.log();
if (single_value->field_areaRestricted.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", ue_reachableIndicator := ");
if (match_value.ue__reachableIndicator().ispresent()) {
single_value->field_ue__reachableIndicator.log_match(match_value.ue__reachableIndicator(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_ue__reachableIndicator.log();
if (single_value->field_ue__reachableIndicator.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", epsSubscriptionDataNotNeeded := ");
if (match_value.epsSubscriptionDataNotNeeded().ispresent()) {
single_value->field_epsSubscriptionDataNotNeeded.log_match(match_value.epsSubscriptionDataNotNeeded(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_epsSubscriptionDataNotNeeded.log();
if (single_value->field_epsSubscriptionDataNotNeeded.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", ue_srvcc_Capability := ");
if (match_value.ue__srvcc__Capability().ispresent()) {
single_value->field_ue__srvcc__Capability.log_match(match_value.ue__srvcc__Capability(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_ue__srvcc__Capability.log();
if (single_value->field_ue__srvcc__Capability.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void UpdateGprsLocationArg_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (imsi().is_bound()) imsi().set_implicit_omit();
if (sgsn__Number().is_bound()) sgsn__Number().set_implicit_omit();
if (sgsn__Address().is_bound()) sgsn__Address().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!sgsn__Capability().is_bound()) sgsn__Capability() = OMIT_VALUE;
else sgsn__Capability().set_implicit_omit();
if (!informPreviousNetworkEntity().is_bound()) informPreviousNetworkEntity() = OMIT_VALUE;
else informPreviousNetworkEntity().set_implicit_omit();
if (!ps__LCS__NotSupportedByUE().is_bound()) ps__LCS__NotSupportedByUE() = OMIT_VALUE;
else ps__LCS__NotSupportedByUE().set_implicit_omit();
if (!v__gmlc__Address().is_bound()) v__gmlc__Address() = OMIT_VALUE;
else v__gmlc__Address().set_implicit_omit();
if (!add__info().is_bound()) add__info() = OMIT_VALUE;
else add__info().set_implicit_omit();
if (!eps__info().is_bound()) eps__info() = OMIT_VALUE;
else eps__info().set_implicit_omit();
if (!servingNodeTypeIndicator().is_bound()) servingNodeTypeIndicator() = OMIT_VALUE;
else servingNodeTypeIndicator().set_implicit_omit();
if (!skipSubscriberDataUpdate().is_bound()) skipSubscriberDataUpdate() = OMIT_VALUE;
else skipSubscriberDataUpdate().set_implicit_omit();
if (!usedRAT__Type().is_bound()) usedRAT__Type() = OMIT_VALUE;
else usedRAT__Type().set_implicit_omit();
if (!gprsSubscriptionDataNotNeeded().is_bound()) gprsSubscriptionDataNotNeeded() = OMIT_VALUE;
else gprsSubscriptionDataNotNeeded().set_implicit_omit();
if (!nodeTypeIndicator().is_bound()) nodeTypeIndicator() = OMIT_VALUE;
else nodeTypeIndicator().set_implicit_omit();
if (!areaRestricted().is_bound()) areaRestricted() = OMIT_VALUE;
else areaRestricted().set_implicit_omit();
if (!ue__reachableIndicator().is_bound()) ue__reachableIndicator() = OMIT_VALUE;
else ue__reachableIndicator().set_implicit_omit();
if (!epsSubscriptionDataNotNeeded().is_bound()) epsSubscriptionDataNotNeeded() = OMIT_VALUE;
else epsSubscriptionDataNotNeeded().set_implicit_omit();
if (!ue__srvcc__Capability().is_bound()) ue__srvcc__Capability() = OMIT_VALUE;
else ue__srvcc__Capability().set_implicit_omit();
}

void UpdateGprsLocationArg_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_imsi.encode_text(text_buf);
single_value->field_sgsn__Number.encode_text(text_buf);
single_value->field_sgsn__Address.encode_text(text_buf);
single_value->field_extensionContainer.encode_text(text_buf);
single_value->field_sgsn__Capability.encode_text(text_buf);
single_value->field_informPreviousNetworkEntity.encode_text(text_buf);
single_value->field_ps__LCS__NotSupportedByUE.encode_text(text_buf);
single_value->field_v__gmlc__Address.encode_text(text_buf);
single_value->field_add__info.encode_text(text_buf);
single_value->field_eps__info.encode_text(text_buf);
single_value->field_servingNodeTypeIndicator.encode_text(text_buf);
single_value->field_skipSubscriberDataUpdate.encode_text(text_buf);
single_value->field_usedRAT__Type.encode_text(text_buf);
single_value->field_gprsSubscriptionDataNotNeeded.encode_text(text_buf);
single_value->field_nodeTypeIndicator.encode_text(text_buf);
single_value->field_areaRestricted.encode_text(text_buf);
single_value->field_ue__reachableIndicator.encode_text(text_buf);
single_value->field_epsSubscriptionDataNotNeeded.encode_text(text_buf);
single_value->field_ue__srvcc__Capability.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
}
}

void UpdateGprsLocationArg_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_imsi.decode_text(text_buf);
single_value->field_sgsn__Number.decode_text(text_buf);
single_value->field_sgsn__Address.decode_text(text_buf);
single_value->field_extensionContainer.decode_text(text_buf);
single_value->field_sgsn__Capability.decode_text(text_buf);
single_value->field_informPreviousNetworkEntity.decode_text(text_buf);
single_value->field_ps__LCS__NotSupportedByUE.decode_text(text_buf);
single_value->field_v__gmlc__Address.decode_text(text_buf);
single_value->field_add__info.decode_text(text_buf);
single_value->field_eps__info.decode_text(text_buf);
single_value->field_servingNodeTypeIndicator.decode_text(text_buf);
single_value->field_skipSubscriberDataUpdate.decode_text(text_buf);
single_value->field_usedRAT__Type.decode_text(text_buf);
single_value->field_gprsSubscriptionDataNotNeeded.decode_text(text_buf);
single_value->field_nodeTypeIndicator.decode_text(text_buf);
single_value->field_areaRestricted.decode_text(text_buf);
single_value->field_ue__reachableIndicator.decode_text(text_buf);
single_value->field_epsSubscriptionDataNotNeeded.decode_text(text_buf);
single_value->field_ue__srvcc__Capability.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new UpdateGprsLocationArg_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.UpdateGprsLocationArg.");
}
}

void UpdateGprsLocationArg_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    UpdateGprsLocationArg_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (19<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.UpdateGprsLocationArg has 19 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) imsi().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) sgsn__Number().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) sgsn__Address().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) sgsn__Capability().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) informPreviousNetworkEntity().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) ps__LCS__NotSupportedByUE().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) v__gmlc__Address().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) add__info().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) eps__info().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) servingNodeTypeIndicator().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) skipSubscriberDataUpdate().set_param(*param.get_elem(11));
    if (param.get_size()>12 && param.get_elem(12)->get_type()!=Module_Param::MP_NotUsed) usedRAT__Type().set_param(*param.get_elem(12));
    if (param.get_size()>13 && param.get_elem(13)->get_type()!=Module_Param::MP_NotUsed) gprsSubscriptionDataNotNeeded().set_param(*param.get_elem(13));
    if (param.get_size()>14 && param.get_elem(14)->get_type()!=Module_Param::MP_NotUsed) nodeTypeIndicator().set_param(*param.get_elem(14));
    if (param.get_size()>15 && param.get_elem(15)->get_type()!=Module_Param::MP_NotUsed) areaRestricted().set_param(*param.get_elem(15));
    if (param.get_size()>16 && param.get_elem(16)->get_type()!=Module_Param::MP_NotUsed) ue__reachableIndicator().set_param(*param.get_elem(16));
    if (param.get_size()>17 && param.get_elem(17)->get_type()!=Module_Param::MP_NotUsed) epsSubscriptionDataNotNeeded().set_param(*param.get_elem(17));
    if (param.get_size()>18 && param.get_elem(18)->get_type()!=Module_Param::MP_NotUsed) ue__srvcc__Capability().set_param(*param.get_elem(18));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "imsi")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          imsi().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sgsn_Number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sgsn__Number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sgsn_Address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sgsn__Address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sgsn_Capability")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sgsn__Capability().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "informPreviousNetworkEntity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          informPreviousNetworkEntity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ps_LCS_NotSupportedByUE")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ps__LCS__NotSupportedByUE().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "v_gmlc_Address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          v__gmlc__Address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "add_info")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          add__info().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "eps_info")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          eps__info().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "servingNodeTypeIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          servingNodeTypeIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "skipSubscriberDataUpdate")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          skipSubscriberDataUpdate().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "usedRAT_Type")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          usedRAT__Type().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gprsSubscriptionDataNotNeeded")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gprsSubscriptionDataNotNeeded().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "nodeTypeIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          nodeTypeIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "areaRestricted")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          areaRestricted().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ue_reachableIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ue__reachableIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "epsSubscriptionDataNotNeeded")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          epsSubscriptionDataNotNeeded().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "ue_srvcc_Capability")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          ue__srvcc__Capability().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.UpdateGprsLocationArg: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    UpdateGprsLocationArg_template* precondition = new UpdateGprsLocationArg_template;
    precondition->set_param(*param.get_elem(0));
    UpdateGprsLocationArg_template* implied_template = new UpdateGprsLocationArg_template;
    implied_template->set_param(*param.get_elem(1));
    *this = UpdateGprsLocationArg_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.UpdateGprsLocationArg");
  }
  is_ifpresent = param.get_ifpresent();
}

void UpdateGprsLocationArg_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_imsi.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.UpdateGprsLocationArg");
single_value->field_sgsn__Number.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.UpdateGprsLocationArg");
single_value->field_sgsn__Address.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.UpdateGprsLocationArg");
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.UpdateGprsLocationArg");
single_value->field_sgsn__Capability.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.UpdateGprsLocationArg");
single_value->field_informPreviousNetworkEntity.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.UpdateGprsLocationArg");
single_value->field_ps__LCS__NotSupportedByUE.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.UpdateGprsLocationArg");
single_value->field_v__gmlc__Address.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.UpdateGprsLocationArg");
single_value->field_add__info.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.UpdateGprsLocationArg");
single_value->field_eps__info.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.UpdateGprsLocationArg");
single_value->field_servingNodeTypeIndicator.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.UpdateGprsLocationArg");
single_value->field_skipSubscriberDataUpdate.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.UpdateGprsLocationArg");
single_value->field_usedRAT__Type.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.UpdateGprsLocationArg");
single_value->field_gprsSubscriptionDataNotNeeded.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.UpdateGprsLocationArg");
single_value->field_nodeTypeIndicator.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.UpdateGprsLocationArg");
single_value->field_areaRestricted.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.UpdateGprsLocationArg");
single_value->field_ue__reachableIndicator.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.UpdateGprsLocationArg");
single_value->field_epsSubscriptionDataNotNeeded.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.UpdateGprsLocationArg");
single_value->field_ue__srvcc__Capability.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.UpdateGprsLocationArg");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.UpdateGprsLocationArg");
}

boolean UpdateGprsLocationArg_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean UpdateGprsLocationArg_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

SGSN__Capability::SGSN__Capability()
{
}

SGSN__Capability::SGSN__Capability(const OPTIONAL< ASN_NULL >& par_solsaSupportIndicator,
    const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer,
    const OPTIONAL< SuperChargerInfo >& par_superChargerSupportedInServingNetworkEntity,
    const OPTIONAL< ASN_NULL >& par_gprsEnhancementsSupportIndicator,
    const OPTIONAL< BITSTRING >& par_supportedCamelPhases,
    const OPTIONAL< BITSTRING >& par_supportedLCS__CapabilitySets,
    const OPTIONAL< BITSTRING >& par_offeredCamel4CSIs,
    const OPTIONAL< ASN_NULL >& par_smsCallBarringSupportIndicator,
    const OPTIONAL< BITSTRING >& par_supportedRAT__TypesIndicator,
    const OPTIONAL< BITSTRING >& par_supportedFeatures,
    const OPTIONAL< ASN_NULL >& par_t__adsDataRetrieval,
    const OPTIONAL< BOOLEAN >& par_homogeneousSupportOfIMSVoiceOverPSSessions)
  :   field_solsaSupportIndicator(par_solsaSupportIndicator),
  field_extensionContainer(par_extensionContainer),
  field_superChargerSupportedInServingNetworkEntity(par_superChargerSupportedInServingNetworkEntity),
  field_gprsEnhancementsSupportIndicator(par_gprsEnhancementsSupportIndicator),
  field_supportedCamelPhases(par_supportedCamelPhases),
  field_supportedLCS__CapabilitySets(par_supportedLCS__CapabilitySets),
  field_offeredCamel4CSIs(par_offeredCamel4CSIs),
  field_smsCallBarringSupportIndicator(par_smsCallBarringSupportIndicator),
  field_supportedRAT__TypesIndicator(par_supportedRAT__TypesIndicator),
  field_supportedFeatures(par_supportedFeatures),
  field_t__adsDataRetrieval(par_t__adsDataRetrieval),
  field_homogeneousSupportOfIMSVoiceOverPSSessions(par_homogeneousSupportOfIMSVoiceOverPSSessions)
{
}

SGSN__Capability::SGSN__Capability(const SGSN__Capability& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.SGSN-Capability.");
if (other_value.solsaSupportIndicator().is_bound()) field_solsaSupportIndicator = other_value.solsaSupportIndicator();
else field_solsaSupportIndicator.clean_up();
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
if (other_value.superChargerSupportedInServingNetworkEntity().is_bound()) field_superChargerSupportedInServingNetworkEntity = other_value.superChargerSupportedInServingNetworkEntity();
else field_superChargerSupportedInServingNetworkEntity.clean_up();
if (other_value.gprsEnhancementsSupportIndicator().is_bound()) field_gprsEnhancementsSupportIndicator = other_value.gprsEnhancementsSupportIndicator();
else field_gprsEnhancementsSupportIndicator.clean_up();
if (other_value.supportedCamelPhases().is_bound()) field_supportedCamelPhases = other_value.supportedCamelPhases();
else field_supportedCamelPhases.clean_up();
if (other_value.supportedLCS__CapabilitySets().is_bound()) field_supportedLCS__CapabilitySets = other_value.supportedLCS__CapabilitySets();
else field_supportedLCS__CapabilitySets.clean_up();
if (other_value.offeredCamel4CSIs().is_bound()) field_offeredCamel4CSIs = other_value.offeredCamel4CSIs();
else field_offeredCamel4CSIs.clean_up();
if (other_value.smsCallBarringSupportIndicator().is_bound()) field_smsCallBarringSupportIndicator = other_value.smsCallBarringSupportIndicator();
else field_smsCallBarringSupportIndicator.clean_up();
if (other_value.supportedRAT__TypesIndicator().is_bound()) field_supportedRAT__TypesIndicator = other_value.supportedRAT__TypesIndicator();
else field_supportedRAT__TypesIndicator.clean_up();
if (other_value.supportedFeatures().is_bound()) field_supportedFeatures = other_value.supportedFeatures();
else field_supportedFeatures.clean_up();
if (other_value.t__adsDataRetrieval().is_bound()) field_t__adsDataRetrieval = other_value.t__adsDataRetrieval();
else field_t__adsDataRetrieval.clean_up();
if (other_value.homogeneousSupportOfIMSVoiceOverPSSessions().is_bound()) field_homogeneousSupportOfIMSVoiceOverPSSessions = other_value.homogeneousSupportOfIMSVoiceOverPSSessions();
else field_homogeneousSupportOfIMSVoiceOverPSSessions.clean_up();
}

void SGSN__Capability::clean_up()
{
field_solsaSupportIndicator.clean_up();
field_extensionContainer.clean_up();
field_superChargerSupportedInServingNetworkEntity.clean_up();
field_gprsEnhancementsSupportIndicator.clean_up();
field_supportedCamelPhases.clean_up();
field_supportedLCS__CapabilitySets.clean_up();
field_offeredCamel4CSIs.clean_up();
field_smsCallBarringSupportIndicator.clean_up();
field_supportedRAT__TypesIndicator.clean_up();
field_supportedFeatures.clean_up();
field_t__adsDataRetrieval.clean_up();
field_homogeneousSupportOfIMSVoiceOverPSSessions.clean_up();
}

const TTCN_Typedescriptor_t* SGSN__Capability::get_descriptor() const { return &SGSN__Capability_descr_; }
SGSN__Capability& SGSN__Capability::operator=(const SGSN__Capability& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.SGSN-Capability.");
  if (other_value.solsaSupportIndicator().is_bound()) field_solsaSupportIndicator = other_value.solsaSupportIndicator();
  else field_solsaSupportIndicator.clean_up();
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
  if (other_value.superChargerSupportedInServingNetworkEntity().is_bound()) field_superChargerSupportedInServingNetworkEntity = other_value.superChargerSupportedInServingNetworkEntity();
  else field_superChargerSupportedInServingNetworkEntity.clean_up();
  if (other_value.gprsEnhancementsSupportIndicator().is_bound()) field_gprsEnhancementsSupportIndicator = other_value.gprsEnhancementsSupportIndicator();
  else field_gprsEnhancementsSupportIndicator.clean_up();
  if (other_value.supportedCamelPhases().is_bound()) field_supportedCamelPhases = other_value.supportedCamelPhases();
  else field_supportedCamelPhases.clean_up();
  if (other_value.supportedLCS__CapabilitySets().is_bound()) field_supportedLCS__CapabilitySets = other_value.supportedLCS__CapabilitySets();
  else field_supportedLCS__CapabilitySets.clean_up();
  if (other_value.offeredCamel4CSIs().is_bound()) field_offeredCamel4CSIs = other_value.offeredCamel4CSIs();
  else field_offeredCamel4CSIs.clean_up();
  if (other_value.smsCallBarringSupportIndicator().is_bound()) field_smsCallBarringSupportIndicator = other_value.smsCallBarringSupportIndicator();
  else field_smsCallBarringSupportIndicator.clean_up();
  if (other_value.supportedRAT__TypesIndicator().is_bound()) field_supportedRAT__TypesIndicator = other_value.supportedRAT__TypesIndicator();
  else field_supportedRAT__TypesIndicator.clean_up();
  if (other_value.supportedFeatures().is_bound()) field_supportedFeatures = other_value.supportedFeatures();
  else field_supportedFeatures.clean_up();
  if (other_value.t__adsDataRetrieval().is_bound()) field_t__adsDataRetrieval = other_value.t__adsDataRetrieval();
  else field_t__adsDataRetrieval.clean_up();
  if (other_value.homogeneousSupportOfIMSVoiceOverPSSessions().is_bound()) field_homogeneousSupportOfIMSVoiceOverPSSessions = other_value.homogeneousSupportOfIMSVoiceOverPSSessions();
  else field_homogeneousSupportOfIMSVoiceOverPSSessions.clean_up();
}
return *this;
}

boolean SGSN__Capability::operator==(const SGSN__Capability& other_value) const
{
return field_solsaSupportIndicator==other_value.field_solsaSupportIndicator
  && field_extensionContainer==other_value.field_extensionContainer
  && field_superChargerSupportedInServingNetworkEntity==other_value.field_superChargerSupportedInServingNetworkEntity
  && field_gprsEnhancementsSupportIndicator==other_value.field_gprsEnhancementsSupportIndicator
  && field_supportedCamelPhases==other_value.field_supportedCamelPhases
  && field_supportedLCS__CapabilitySets==other_value.field_supportedLCS__CapabilitySets
  && field_offeredCamel4CSIs==other_value.field_offeredCamel4CSIs
  && field_smsCallBarringSupportIndicator==other_value.field_smsCallBarringSupportIndicator
  && field_supportedRAT__TypesIndicator==other_value.field_supportedRAT__TypesIndicator
  && field_supportedFeatures==other_value.field_supportedFeatures
  && field_t__adsDataRetrieval==other_value.field_t__adsDataRetrieval
  && field_homogeneousSupportOfIMSVoiceOverPSSessions==other_value.field_homogeneousSupportOfIMSVoiceOverPSSessions;
}

boolean SGSN__Capability::is_bound() const
{
return (OPTIONAL_OMIT == field_solsaSupportIndicator.get_selection() || field_solsaSupportIndicator.is_bound())
  || (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound())
  || (OPTIONAL_OMIT == field_superChargerSupportedInServingNetworkEntity.get_selection() || field_superChargerSupportedInServingNetworkEntity.is_bound())
  || (OPTIONAL_OMIT == field_gprsEnhancementsSupportIndicator.get_selection() || field_gprsEnhancementsSupportIndicator.is_bound())
  || (OPTIONAL_OMIT == field_supportedCamelPhases.get_selection() || field_supportedCamelPhases.is_bound())
  || (OPTIONAL_OMIT == field_supportedLCS__CapabilitySets.get_selection() || field_supportedLCS__CapabilitySets.is_bound())
  || (OPTIONAL_OMIT == field_offeredCamel4CSIs.get_selection() || field_offeredCamel4CSIs.is_bound())
  || (OPTIONAL_OMIT == field_smsCallBarringSupportIndicator.get_selection() || field_smsCallBarringSupportIndicator.is_bound())
  || (OPTIONAL_OMIT == field_supportedRAT__TypesIndicator.get_selection() || field_supportedRAT__TypesIndicator.is_bound())
  || (OPTIONAL_OMIT == field_supportedFeatures.get_selection() || field_supportedFeatures.is_bound())
  || (OPTIONAL_OMIT == field_t__adsDataRetrieval.get_selection() || field_t__adsDataRetrieval.is_bound())
  || (OPTIONAL_OMIT == field_homogeneousSupportOfIMSVoiceOverPSSessions.get_selection() || field_homogeneousSupportOfIMSVoiceOverPSSessions.is_bound());
}
boolean SGSN__Capability::is_value() const
{
return (OPTIONAL_OMIT == field_solsaSupportIndicator.get_selection() || field_solsaSupportIndicator.is_value())
  && (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value())
  && (OPTIONAL_OMIT == field_superChargerSupportedInServingNetworkEntity.get_selection() || field_superChargerSupportedInServingNetworkEntity.is_value())
  && (OPTIONAL_OMIT == field_gprsEnhancementsSupportIndicator.get_selection() || field_gprsEnhancementsSupportIndicator.is_value())
  && (OPTIONAL_OMIT == field_supportedCamelPhases.get_selection() || field_supportedCamelPhases.is_value())
  && (OPTIONAL_OMIT == field_supportedLCS__CapabilitySets.get_selection() || field_supportedLCS__CapabilitySets.is_value())
  && (OPTIONAL_OMIT == field_offeredCamel4CSIs.get_selection() || field_offeredCamel4CSIs.is_value())
  && (OPTIONAL_OMIT == field_smsCallBarringSupportIndicator.get_selection() || field_smsCallBarringSupportIndicator.is_value())
  && (OPTIONAL_OMIT == field_supportedRAT__TypesIndicator.get_selection() || field_supportedRAT__TypesIndicator.is_value())
  && (OPTIONAL_OMIT == field_supportedFeatures.get_selection() || field_supportedFeatures.is_value())
  && (OPTIONAL_OMIT == field_t__adsDataRetrieval.get_selection() || field_t__adsDataRetrieval.is_value())
  && (OPTIONAL_OMIT == field_homogeneousSupportOfIMSVoiceOverPSSessions.get_selection() || field_homogeneousSupportOfIMSVoiceOverPSSessions.is_value());
}
int SGSN__Capability::size_of() const
{
  int ret_val = 0;
  if (field_solsaSupportIndicator.ispresent()) ret_val++;
  if (field_extensionContainer.ispresent()) ret_val++;
  if (field_superChargerSupportedInServingNetworkEntity.ispresent()) ret_val++;
  if (field_gprsEnhancementsSupportIndicator.ispresent()) ret_val++;
  if (field_supportedCamelPhases.ispresent()) ret_val++;
  if (field_supportedLCS__CapabilitySets.ispresent()) ret_val++;
  if (field_offeredCamel4CSIs.ispresent()) ret_val++;
  if (field_smsCallBarringSupportIndicator.ispresent()) ret_val++;
  if (field_supportedRAT__TypesIndicator.ispresent()) ret_val++;
  if (field_supportedFeatures.ispresent()) ret_val++;
  if (field_t__adsDataRetrieval.ispresent()) ret_val++;
  if (field_homogeneousSupportOfIMSVoiceOverPSSessions.ispresent()) ret_val++;
  return ret_val;
}

void SGSN__Capability::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ solsaSupportIndicator := ");
field_solsaSupportIndicator.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(", superChargerSupportedInServingNetworkEntity := ");
field_superChargerSupportedInServingNetworkEntity.log();
TTCN_Logger::log_event_str(", gprsEnhancementsSupportIndicator := ");
field_gprsEnhancementsSupportIndicator.log();
TTCN_Logger::log_event_str(", supportedCamelPhases := ");
field_supportedCamelPhases.log();
TTCN_Logger::log_event_str(", supportedLCS_CapabilitySets := ");
field_supportedLCS__CapabilitySets.log();
TTCN_Logger::log_event_str(", offeredCamel4CSIs := ");
field_offeredCamel4CSIs.log();
TTCN_Logger::log_event_str(", smsCallBarringSupportIndicator := ");
field_smsCallBarringSupportIndicator.log();
TTCN_Logger::log_event_str(", supportedRAT_TypesIndicator := ");
field_supportedRAT__TypesIndicator.log();
TTCN_Logger::log_event_str(", supportedFeatures := ");
field_supportedFeatures.log();
TTCN_Logger::log_event_str(", t_adsDataRetrieval := ");
field_t__adsDataRetrieval.log();
TTCN_Logger::log_event_str(", homogeneousSupportOfIMSVoiceOverPSSessions := ");
field_homogeneousSupportOfIMSVoiceOverPSSessions.log();
TTCN_Logger::log_event_str(" }");
}

void SGSN__Capability::set_implicit_omit()
{
if (!solsaSupportIndicator().is_bound()) solsaSupportIndicator() = OMIT_VALUE;
else solsaSupportIndicator().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!superChargerSupportedInServingNetworkEntity().is_bound()) superChargerSupportedInServingNetworkEntity() = OMIT_VALUE;
else superChargerSupportedInServingNetworkEntity().set_implicit_omit();
if (!gprsEnhancementsSupportIndicator().is_bound()) gprsEnhancementsSupportIndicator() = OMIT_VALUE;
else gprsEnhancementsSupportIndicator().set_implicit_omit();
if (!supportedCamelPhases().is_bound()) supportedCamelPhases() = OMIT_VALUE;
else supportedCamelPhases().set_implicit_omit();
if (!supportedLCS__CapabilitySets().is_bound()) supportedLCS__CapabilitySets() = OMIT_VALUE;
else supportedLCS__CapabilitySets().set_implicit_omit();
if (!offeredCamel4CSIs().is_bound()) offeredCamel4CSIs() = OMIT_VALUE;
else offeredCamel4CSIs().set_implicit_omit();
if (!smsCallBarringSupportIndicator().is_bound()) smsCallBarringSupportIndicator() = OMIT_VALUE;
else smsCallBarringSupportIndicator().set_implicit_omit();
if (!supportedRAT__TypesIndicator().is_bound()) supportedRAT__TypesIndicator() = OMIT_VALUE;
else supportedRAT__TypesIndicator().set_implicit_omit();
if (!supportedFeatures().is_bound()) supportedFeatures() = OMIT_VALUE;
else supportedFeatures().set_implicit_omit();
if (!t__adsDataRetrieval().is_bound()) t__adsDataRetrieval() = OMIT_VALUE;
else t__adsDataRetrieval().set_implicit_omit();
if (!homogeneousSupportOfIMSVoiceOverPSSessions().is_bound()) homogeneousSupportOfIMSVoiceOverPSSessions() = OMIT_VALUE;
else homogeneousSupportOfIMSVoiceOverPSSessions().set_implicit_omit();
}

void SGSN__Capability::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (12<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.SGSN-Capability has 12 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) solsaSupportIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) superChargerSupportedInServingNetworkEntity().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) gprsEnhancementsSupportIndicator().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) supportedCamelPhases().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) supportedLCS__CapabilitySets().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) offeredCamel4CSIs().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) smsCallBarringSupportIndicator().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) supportedRAT__TypesIndicator().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) supportedFeatures().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) t__adsDataRetrieval().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) homogeneousSupportOfIMSVoiceOverPSSessions().set_param(*param.get_elem(11));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "solsaSupportIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          solsaSupportIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "superChargerSupportedInServingNetworkEntity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          superChargerSupportedInServingNetworkEntity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gprsEnhancementsSupportIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gprsEnhancementsSupportIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "supportedCamelPhases")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          supportedCamelPhases().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "supportedLCS_CapabilitySets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          supportedLCS__CapabilitySets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "offeredCamel4CSIs")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          offeredCamel4CSIs().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "smsCallBarringSupportIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          smsCallBarringSupportIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "supportedRAT_TypesIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          supportedRAT__TypesIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "supportedFeatures")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          supportedFeatures().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "t_adsDataRetrieval")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          t__adsDataRetrieval().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "homogeneousSupportOfIMSVoiceOverPSSessions")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          homogeneousSupportOfIMSVoiceOverPSSessions().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.SGSN-Capability: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.SGSN-Capability");
  }
}

void SGSN__Capability::encode_text(Text_Buf& text_buf) const
{
field_solsaSupportIndicator.encode_text(text_buf);
field_extensionContainer.encode_text(text_buf);
field_superChargerSupportedInServingNetworkEntity.encode_text(text_buf);
field_gprsEnhancementsSupportIndicator.encode_text(text_buf);
field_supportedCamelPhases.encode_text(text_buf);
field_supportedLCS__CapabilitySets.encode_text(text_buf);
field_offeredCamel4CSIs.encode_text(text_buf);
field_smsCallBarringSupportIndicator.encode_text(text_buf);
field_supportedRAT__TypesIndicator.encode_text(text_buf);
field_supportedFeatures.encode_text(text_buf);
field_t__adsDataRetrieval.encode_text(text_buf);
field_homogeneousSupportOfIMSVoiceOverPSSessions.encode_text(text_buf);
}

void SGSN__Capability::decode_text(Text_Buf& text_buf)
{
field_solsaSupportIndicator.decode_text(text_buf);
field_extensionContainer.decode_text(text_buf);
field_superChargerSupportedInServingNetworkEntity.decode_text(text_buf);
field_gprsEnhancementsSupportIndicator.decode_text(text_buf);
field_supportedCamelPhases.decode_text(text_buf);
field_supportedLCS__CapabilitySets.decode_text(text_buf);
field_offeredCamel4CSIs.decode_text(text_buf);
field_smsCallBarringSupportIndicator.decode_text(text_buf);
field_supportedRAT__TypesIndicator.decode_text(text_buf);
field_supportedFeatures.decode_text(text_buf);
field_t__adsDataRetrieval.decode_text(text_buf);
field_homogeneousSupportOfIMSVoiceOverPSSessions.decode_text(text_buf);
}

void SGSN__Capability::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void SGSN__Capability::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* SGSN__Capability::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("solsaSupportIndicator': ");
  new_tlv->add_TLV(field_solsaSupportIndicator.BER_encode_TLV(ASN_NULL_descr_, p_coding));
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(SGSN__Capability_extensionContainer_descr_, p_coding));
  ec_1.set_msg("superChargerSupportedInServingNetworkEntity': ");
  new_tlv->add_TLV(field_superChargerSupportedInServingNetworkEntity.BER_encode_TLV(SGSN__Capability_superChargerSupportedInServingNetworkEntity_descr_, p_coding));
  ec_1.set_msg("gprsEnhancementsSupportIndicator': ");
  new_tlv->add_TLV(field_gprsEnhancementsSupportIndicator.BER_encode_TLV(SGSN__Capability_gprsEnhancementsSupportIndicator_descr_, p_coding));
  ec_1.set_msg("supportedCamelPhases': ");
  new_tlv->add_TLV(field_supportedCamelPhases.BER_encode_TLV(SGSN__Capability_supportedCamelPhases_descr_, p_coding));
  ec_1.set_msg("supportedLCS_CapabilitySets': ");
  new_tlv->add_TLV(field_supportedLCS__CapabilitySets.BER_encode_TLV(SGSN__Capability_supportedLCS__CapabilitySets_descr_, p_coding));
  ec_1.set_msg("offeredCamel4CSIs': ");
  new_tlv->add_TLV(field_offeredCamel4CSIs.BER_encode_TLV(SGSN__Capability_offeredCamel4CSIs_descr_, p_coding));
  ec_1.set_msg("smsCallBarringSupportIndicator': ");
  new_tlv->add_TLV(field_smsCallBarringSupportIndicator.BER_encode_TLV(SGSN__Capability_smsCallBarringSupportIndicator_descr_, p_coding));
  ec_1.set_msg("supportedRAT_TypesIndicator': ");
  new_tlv->add_TLV(field_supportedRAT__TypesIndicator.BER_encode_TLV(SGSN__Capability_supportedRAT__TypesIndicator_descr_, p_coding));
  ec_1.set_msg("supportedFeatures': ");
  new_tlv->add_TLV(field_supportedFeatures.BER_encode_TLV(SGSN__Capability_supportedFeatures_descr_, p_coding));
  ec_1.set_msg("t_adsDataRetrieval': ");
  new_tlv->add_TLV(field_t__adsDataRetrieval.BER_encode_TLV(SGSN__Capability_t__adsDataRetrieval_descr_, p_coding));
  ec_1.set_msg("homogeneousSupportOfIMSVoiceOverPSSessions': ");
  new_tlv->add_TLV(field_homogeneousSupportOfIMSVoiceOverPSSessions.BER_encode_TLV(SGSN__Capability_homogeneousSupportOfIMSVoiceOverPSSessions_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean SGSN__Capability::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.SGSN-Capability' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("solsaSupportIndicator': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_solsaSupportIndicator=OMIT_VALUE;
    else {
      field_solsaSupportIndicator.BER_decode_TLV(ASN_NULL_descr_, tmp_tlv, L_form);
      if(field_solsaSupportIndicator.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(SGSN__Capability_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("superChargerSupportedInServingNetworkEntity': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_superChargerSupportedInServingNetworkEntity=OMIT_VALUE;
    else {
      field_superChargerSupportedInServingNetworkEntity.BER_decode_TLV(SGSN__Capability_superChargerSupportedInServingNetworkEntity_descr_, tmp_tlv, L_form);
      if(field_superChargerSupportedInServingNetworkEntity.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("gprsEnhancementsSupportIndicator': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_gprsEnhancementsSupportIndicator=OMIT_VALUE;
    else {
      field_gprsEnhancementsSupportIndicator.BER_decode_TLV(SGSN__Capability_gprsEnhancementsSupportIndicator_descr_, tmp_tlv, L_form);
      if(field_gprsEnhancementsSupportIndicator.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("supportedCamelPhases': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_supportedCamelPhases=OMIT_VALUE;
    else {
      field_supportedCamelPhases.BER_decode_TLV(SGSN__Capability_supportedCamelPhases_descr_, tmp_tlv, L_form);
      if(field_supportedCamelPhases.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("supportedLCS_CapabilitySets': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_supportedLCS__CapabilitySets=OMIT_VALUE;
    else {
      field_supportedLCS__CapabilitySets.BER_decode_TLV(SGSN__Capability_supportedLCS__CapabilitySets_descr_, tmp_tlv, L_form);
      if(field_supportedLCS__CapabilitySets.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("offeredCamel4CSIs': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_offeredCamel4CSIs=OMIT_VALUE;
    else {
      field_offeredCamel4CSIs.BER_decode_TLV(SGSN__Capability_offeredCamel4CSIs_descr_, tmp_tlv, L_form);
      if(field_offeredCamel4CSIs.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("smsCallBarringSupportIndicator': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_smsCallBarringSupportIndicator=OMIT_VALUE;
    else {
      field_smsCallBarringSupportIndicator.BER_decode_TLV(SGSN__Capability_smsCallBarringSupportIndicator_descr_, tmp_tlv, L_form);
      if(field_smsCallBarringSupportIndicator.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("supportedRAT_TypesIndicator': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_supportedRAT__TypesIndicator=OMIT_VALUE;
    else {
      field_supportedRAT__TypesIndicator.BER_decode_TLV(SGSN__Capability_supportedRAT__TypesIndicator_descr_, tmp_tlv, L_form);
      if(field_supportedRAT__TypesIndicator.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("supportedFeatures': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_supportedFeatures=OMIT_VALUE;
    else {
      field_supportedFeatures.BER_decode_TLV(SGSN__Capability_supportedFeatures_descr_, tmp_tlv, L_form);
      if(field_supportedFeatures.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("t_adsDataRetrieval': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_t__adsDataRetrieval=OMIT_VALUE;
    else {
      field_t__adsDataRetrieval.BER_decode_TLV(SGSN__Capability_t__adsDataRetrieval_descr_, tmp_tlv, L_form);
      if(field_t__adsDataRetrieval.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("homogeneousSupportOfIMSVoiceOverPSSessions': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_homogeneousSupportOfIMSVoiceOverPSSessions=OMIT_VALUE;
    else {
      field_homogeneousSupportOfIMSVoiceOverPSSessions.BER_decode_TLV(SGSN__Capability_homogeneousSupportOfIMSVoiceOverPSSessions_descr_, tmp_tlv, L_form);
      if(field_homogeneousSupportOfIMSVoiceOverPSSessions.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int SGSN__Capability::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.SGSN-Capability.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  if (field_solsaSupportIndicator.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "solsaSupportIndicator");
    enc_len += field_solsaSupportIndicator.JSON_encode(ASN_NULL_descr_, p_tok, FALSE);
  }

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(SGSN__Capability_extensionContainer_descr_, p_tok, FALSE);
  }

  if (field_superChargerSupportedInServingNetworkEntity.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "superChargerSupportedInServingNetworkEntity");
    enc_len += field_superChargerSupportedInServingNetworkEntity.JSON_encode(SGSN__Capability_superChargerSupportedInServingNetworkEntity_descr_, p_tok, FALSE);
  }

  if (field_gprsEnhancementsSupportIndicator.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "gprsEnhancementsSupportIndicator");
    enc_len += field_gprsEnhancementsSupportIndicator.JSON_encode(SGSN__Capability_gprsEnhancementsSupportIndicator_descr_, p_tok, FALSE);
  }

  if (field_supportedCamelPhases.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "supportedCamelPhases");
    enc_len += field_supportedCamelPhases.JSON_encode(SGSN__Capability_supportedCamelPhases_descr_, p_tok, FALSE);
  }

  if (field_supportedLCS__CapabilitySets.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "supportedLCS_CapabilitySets");
    enc_len += field_supportedLCS__CapabilitySets.JSON_encode(SGSN__Capability_supportedLCS__CapabilitySets_descr_, p_tok, FALSE);
  }

  if (field_offeredCamel4CSIs.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "offeredCamel4CSIs");
    enc_len += field_offeredCamel4CSIs.JSON_encode(SGSN__Capability_offeredCamel4CSIs_descr_, p_tok, FALSE);
  }

  if (field_smsCallBarringSupportIndicator.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "smsCallBarringSupportIndicator");
    enc_len += field_smsCallBarringSupportIndicator.JSON_encode(SGSN__Capability_smsCallBarringSupportIndicator_descr_, p_tok, FALSE);
  }

  if (field_supportedRAT__TypesIndicator.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "supportedRAT_TypesIndicator");
    enc_len += field_supportedRAT__TypesIndicator.JSON_encode(SGSN__Capability_supportedRAT__TypesIndicator_descr_, p_tok, FALSE);
  }

  if (field_supportedFeatures.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "supportedFeatures");
    enc_len += field_supportedFeatures.JSON_encode(SGSN__Capability_supportedFeatures_descr_, p_tok, FALSE);
  }

  if (field_t__adsDataRetrieval.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "t_adsDataRetrieval");
    enc_len += field_t__adsDataRetrieval.JSON_encode(SGSN__Capability_t__adsDataRetrieval_descr_, p_tok, FALSE);
  }

  if (field_homogeneousSupportOfIMSVoiceOverPSSessions.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "homogeneousSupportOfIMSVoiceOverPSSessions");
    enc_len += field_homogeneousSupportOfIMSVoiceOverPSSessions.JSON_encode(SGSN__Capability_homogeneousSupportOfIMSVoiceOverPSSessions_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int SGSN__Capability::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const SGSN__Capability*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean solsaSupportIndicator_found = FALSE;
  boolean extensionContainer_found = FALSE;
  boolean superChargerSupportedInServingNetworkEntity_found = FALSE;
  boolean gprsEnhancementsSupportIndicator_found = FALSE;
  boolean supportedCamelPhases_found = FALSE;
  boolean supportedLCS__CapabilitySets_found = FALSE;
  boolean offeredCamel4CSIs_found = FALSE;
  boolean smsCallBarringSupportIndicator_found = FALSE;
  boolean supportedRAT__TypesIndicator_found = FALSE;
  boolean supportedFeatures_found = FALSE;
  boolean t__adsDataRetrieval_found = FALSE;
  boolean homogeneousSupportOfIMSVoiceOverPSSessions_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (21 == name_len && 0 == strncmp(fld_name, "solsaSupportIndicator", name_len)) {
        solsaSupportIndicator_found = TRUE;
         int ret_val = field_solsaSupportIndicator.JSON_decode(ASN_NULL_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 21, "solsaSupportIndicator");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(SGSN__Capability_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (43 == name_len && 0 == strncmp(fld_name, "superChargerSupportedInServingNetworkEntity", name_len)) {
        superChargerSupportedInServingNetworkEntity_found = TRUE;
         int ret_val = field_superChargerSupportedInServingNetworkEntity.JSON_decode(SGSN__Capability_superChargerSupportedInServingNetworkEntity_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 43, "superChargerSupportedInServingNetworkEntity");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (32 == name_len && 0 == strncmp(fld_name, "gprsEnhancementsSupportIndicator", name_len)) {
        gprsEnhancementsSupportIndicator_found = TRUE;
         int ret_val = field_gprsEnhancementsSupportIndicator.JSON_decode(SGSN__Capability_gprsEnhancementsSupportIndicator_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 32, "gprsEnhancementsSupportIndicator");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (20 == name_len && 0 == strncmp(fld_name, "supportedCamelPhases", name_len)) {
        supportedCamelPhases_found = TRUE;
         int ret_val = field_supportedCamelPhases.JSON_decode(SGSN__Capability_supportedCamelPhases_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 20, "supportedCamelPhases");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (27 == name_len && 0 == strncmp(fld_name, "supportedLCS_CapabilitySets", name_len)) {
        supportedLCS__CapabilitySets_found = TRUE;
         int ret_val = field_supportedLCS__CapabilitySets.JSON_decode(SGSN__Capability_supportedLCS__CapabilitySets_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 27, "supportedLCS_CapabilitySets");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (17 == name_len && 0 == strncmp(fld_name, "offeredCamel4CSIs", name_len)) {
        offeredCamel4CSIs_found = TRUE;
         int ret_val = field_offeredCamel4CSIs.JSON_decode(SGSN__Capability_offeredCamel4CSIs_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 17, "offeredCamel4CSIs");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (30 == name_len && 0 == strncmp(fld_name, "smsCallBarringSupportIndicator", name_len)) {
        smsCallBarringSupportIndicator_found = TRUE;
         int ret_val = field_smsCallBarringSupportIndicator.JSON_decode(SGSN__Capability_smsCallBarringSupportIndicator_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 30, "smsCallBarringSupportIndicator");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (27 == name_len && 0 == strncmp(fld_name, "supportedRAT_TypesIndicator", name_len)) {
        supportedRAT__TypesIndicator_found = TRUE;
         int ret_val = field_supportedRAT__TypesIndicator.JSON_decode(SGSN__Capability_supportedRAT__TypesIndicator_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 27, "supportedRAT_TypesIndicator");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (17 == name_len && 0 == strncmp(fld_name, "supportedFeatures", name_len)) {
        supportedFeatures_found = TRUE;
         int ret_val = field_supportedFeatures.JSON_decode(SGSN__Capability_supportedFeatures_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 17, "supportedFeatures");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "t_adsDataRetrieval", name_len)) {
        t__adsDataRetrieval_found = TRUE;
         int ret_val = field_t__adsDataRetrieval.JSON_decode(SGSN__Capability_t__adsDataRetrieval_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "t_adsDataRetrieval");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (42 == name_len && 0 == strncmp(fld_name, "homogeneousSupportOfIMSVoiceOverPSSessions", name_len)) {
        homogeneousSupportOfIMSVoiceOverPSSessions_found = TRUE;
         int ret_val = field_homogeneousSupportOfIMSVoiceOverPSSessions.JSON_decode(SGSN__Capability_homogeneousSupportOfIMSVoiceOverPSSessions_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 42, "homogeneousSupportOfIMSVoiceOverPSSessions");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!solsaSupportIndicator_found) {
    field_solsaSupportIndicator = OMIT_VALUE;
  }
  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  if (!superChargerSupportedInServingNetworkEntity_found) {
    field_superChargerSupportedInServingNetworkEntity = OMIT_VALUE;
  }
  if (!gprsEnhancementsSupportIndicator_found) {
    field_gprsEnhancementsSupportIndicator = OMIT_VALUE;
  }
  if (!supportedCamelPhases_found) {
    field_supportedCamelPhases = OMIT_VALUE;
  }
  if (!supportedLCS__CapabilitySets_found) {
    field_supportedLCS__CapabilitySets = OMIT_VALUE;
  }
  if (!offeredCamel4CSIs_found) {
    field_offeredCamel4CSIs = OMIT_VALUE;
  }
  if (!smsCallBarringSupportIndicator_found) {
    field_smsCallBarringSupportIndicator = OMIT_VALUE;
  }
  if (!supportedRAT__TypesIndicator_found) {
    field_supportedRAT__TypesIndicator = OMIT_VALUE;
  }
  if (!supportedFeatures_found) {
    field_supportedFeatures = OMIT_VALUE;
  }
  if (!t__adsDataRetrieval_found) {
    field_t__adsDataRetrieval = OMIT_VALUE;
  }
  if (!homogeneousSupportOfIMSVoiceOverPSSessions_found) {
    field_homogeneousSupportOfIMSVoiceOverPSSessions = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int SGSN__Capability::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  boolean has_extension = FALSE;
  has_extension = has_extension || (field_superChargerSupportedInServingNetworkEntity.is_bound() && field_superChargerSupportedInServingNetworkEntity.is_present());
  has_extension = has_extension || (field_gprsEnhancementsSupportIndicator.is_bound() && field_gprsEnhancementsSupportIndicator.is_present());
  has_extension = has_extension || (field_supportedCamelPhases.is_bound() && field_supportedCamelPhases.is_present());
  has_extension = has_extension || (field_supportedLCS__CapabilitySets.is_bound() && field_supportedLCS__CapabilitySets.is_present());
  has_extension = has_extension || (field_offeredCamel4CSIs.is_bound() && field_offeredCamel4CSIs.is_present());
  has_extension = has_extension || (field_smsCallBarringSupportIndicator.is_bound() && field_smsCallBarringSupportIndicator.is_present());
  has_extension = has_extension || (field_supportedRAT__TypesIndicator.is_bound() && field_supportedRAT__TypesIndicator.is_present());
  has_extension = has_extension || (field_supportedFeatures.is_bound() && field_supportedFeatures.is_present());
  has_extension = has_extension || (field_t__adsDataRetrieval.is_bound() && field_t__adsDataRetrieval.is_present());
  has_extension = has_extension || (field_homogeneousSupportOfIMSVoiceOverPSSessions.is_bound() && field_homogeneousSupportOfIMSVoiceOverPSSessions.is_present());
  char c = 0;
  if (has_extension) {
    c |= 128;
  }
  if (field_solsaSupportIndicator.is_present()) {
    c |= 64;
  }
  if (field_extensionContainer.is_present()) {
    c |= 32;
  }
  p_buf.put_c(c);
  if (field_solsaSupportIndicator.is_present())
    field_solsaSupportIndicator.OER_encode(ASN_NULL_descr_, p_buf);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(SGSN__Capability_extensionContainer_descr_, p_buf);
  if (has_extension) {
    TTCN_Buffer tmp_buf;
    TTCN_Buffer tmp_buf2;
    TTCN_Buffer tmp_buf3;
    c = 0;
    if (field_superChargerSupportedInServingNetworkEntity.is_present()) {
      c |= 128;
      field_superChargerSupportedInServingNetworkEntity.OER_encode(SGSN__Capability_superChargerSupportedInServingNetworkEntity_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_gprsEnhancementsSupportIndicator.is_present()) {
      c |= 64;
      field_gprsEnhancementsSupportIndicator.OER_encode(SGSN__Capability_gprsEnhancementsSupportIndicator_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_supportedCamelPhases.is_present()) {
      c |= 32;
      field_supportedCamelPhases.OER_encode(SGSN__Capability_supportedCamelPhases_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_supportedLCS__CapabilitySets.is_present()) {
      c |= 16;
      field_supportedLCS__CapabilitySets.OER_encode(SGSN__Capability_supportedLCS__CapabilitySets_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_offeredCamel4CSIs.is_present()) {
      c |= 8;
      field_offeredCamel4CSIs.OER_encode(SGSN__Capability_offeredCamel4CSIs_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_smsCallBarringSupportIndicator.is_present()) {
      c |= 4;
      field_smsCallBarringSupportIndicator.OER_encode(SGSN__Capability_smsCallBarringSupportIndicator_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_supportedRAT__TypesIndicator.is_present()) {
      c |= 2;
      field_supportedRAT__TypesIndicator.OER_encode(SGSN__Capability_supportedRAT__TypesIndicator_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_supportedFeatures.is_present()) {
      c |= 1;
      field_supportedFeatures.OER_encode(SGSN__Capability_supportedFeatures_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    tmp_buf3.put_c(c);
    c = 0;
    if (field_t__adsDataRetrieval.is_present()) {
      c |= 128;
      field_t__adsDataRetrieval.OER_encode(SGSN__Capability_t__adsDataRetrieval_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_homogeneousSupportOfIMSVoiceOverPSSessions.is_present()) {
      c |= 64;
      field_homogeneousSupportOfIMSVoiceOverPSSessions.OER_encode(SGSN__Capability_homogeneousSupportOfIMSVoiceOverPSSessions_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    tmp_buf3.put_c(c);
    encode_oer_length(3, p_buf, FALSE);
    p_buf.put_c(6);
    p_buf.put_buf(tmp_buf3);
    p_buf.put_buf(tmp_buf);
    tmp_buf.clear();
  }
  return 0;
}

int SGSN__Capability::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  if (uc[0] & 64)
    field_solsaSupportIndicator.OER_decode(ASN_NULL_descr_, p_buf, p_oer);
 else
    field_solsaSupportIndicator = OMIT_VALUE;
  if (uc[0] & 32)
    field_extensionContainer.OER_decode(SGSN__Capability_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
    if (!(uc[0] & 128)) {
      field_superChargerSupportedInServingNetworkEntity = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_superChargerSupportedInServingNetworkEntity.OER_decode(SGSN__Capability_superChargerSupportedInServingNetworkEntity_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 64)) {
      field_gprsEnhancementsSupportIndicator = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_gprsEnhancementsSupportIndicator.OER_decode(SGSN__Capability_gprsEnhancementsSupportIndicator_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 32)) {
      field_supportedCamelPhases = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_supportedCamelPhases.OER_decode(SGSN__Capability_supportedCamelPhases_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 16)) {
      field_supportedLCS__CapabilitySets = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_supportedLCS__CapabilitySets.OER_decode(SGSN__Capability_supportedLCS__CapabilitySets_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 8)) {
      field_offeredCamel4CSIs = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_offeredCamel4CSIs.OER_decode(SGSN__Capability_offeredCamel4CSIs_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 4)) {
      field_smsCallBarringSupportIndicator = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_smsCallBarringSupportIndicator.OER_decode(SGSN__Capability_smsCallBarringSupportIndicator_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 2)) {
      field_supportedRAT__TypesIndicator = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_supportedRAT__TypesIndicator.OER_decode(SGSN__Capability_supportedRAT__TypesIndicator_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 1)) {
      field_supportedFeatures = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_supportedFeatures.OER_decode(SGSN__Capability_supportedFeatures_descr_, p_buf, p_oer);
    }
    if (!(uc[1] & 128)) {
      field_t__adsDataRetrieval = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_t__adsDataRetrieval.OER_decode(SGSN__Capability_t__adsDataRetrieval_descr_, p_buf, p_oer);
    }
    if (!(uc[1] & 64)) {
      field_homogeneousSupportOfIMSVoiceOverPSSessions = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_homogeneousSupportOfIMSVoiceOverPSSessions.OER_decode(SGSN__Capability_homogeneousSupportOfIMSVoiceOverPSSessions_descr_, p_buf, p_oer);
    }
  }
  else {
    field_superChargerSupportedInServingNetworkEntity = OMIT_VALUE;
    field_gprsEnhancementsSupportIndicator = OMIT_VALUE;
    field_supportedCamelPhases = OMIT_VALUE;
    field_supportedLCS__CapabilitySets = OMIT_VALUE;
    field_offeredCamel4CSIs = OMIT_VALUE;
    field_smsCallBarringSupportIndicator = OMIT_VALUE;
    field_supportedRAT__TypesIndicator = OMIT_VALUE;
    field_supportedFeatures = OMIT_VALUE;
    field_t__adsDataRetrieval = OMIT_VALUE;
    field_homogeneousSupportOfIMSVoiceOverPSSessions = OMIT_VALUE;
  }
  return 0;
}

void SGSN__Capability::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_0_present = field_superChargerSupportedInServingNetworkEntity.is_present();
boolean ext_1_present = field_gprsEnhancementsSupportIndicator.is_present();
boolean ext_2_present = field_supportedCamelPhases.is_present();
boolean ext_3_present = field_supportedLCS__CapabilitySets.is_present();
boolean ext_4_present = field_offeredCamel4CSIs.is_present();
boolean ext_5_present = field_smsCallBarringSupportIndicator.is_present();
boolean ext_6_present = field_supportedRAT__TypesIndicator.is_present();
boolean ext_7_present = field_supportedFeatures.is_present();
boolean ext_8_present = field_t__adsDataRetrieval.is_present();
boolean ext_9_present = field_homogeneousSupportOfIMSVoiceOverPSSessions.is_present();
boolean ext_bit = ext_0_present || ext_1_present || ext_2_present || ext_3_present || ext_4_present || ext_5_present || ext_6_present || ext_7_present || ext_8_present || ext_9_present;
p_buf.PER_put_bit(ext_bit);
boolean field_solsaSupportIndicator_present = field_solsaSupportIndicator.is_present();
p_buf.PER_put_bit(field_solsaSupportIndicator_present);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
if (field_solsaSupportIndicator_present) field_solsaSupportIndicator.PER_encode(ASN_NULL_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(SGSN__Capability_extensionContainer_descr_, p_buf, p_options);
if (ext_bit) {
INTEGER length_(10);
length_.PER_encode_length(p_buf, p_options, TRUE);
p_buf.PER_put_bit(ext_0_present);
p_buf.PER_put_bit(ext_1_present);
p_buf.PER_put_bit(ext_2_present);
p_buf.PER_put_bit(ext_3_present);
p_buf.PER_put_bit(ext_4_present);
p_buf.PER_put_bit(ext_5_present);
p_buf.PER_put_bit(ext_6_present);
p_buf.PER_put_bit(ext_7_present);
p_buf.PER_put_bit(ext_8_present);
p_buf.PER_put_bit(ext_9_present);
if (ext_0_present) {
TTCN_Buffer ext_add_buf;
field_superChargerSupportedInServingNetworkEntity.PER_encode(SGSN__Capability_superChargerSupportedInServingNetworkEntity_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_1_present) {
TTCN_Buffer ext_add_buf;
field_gprsEnhancementsSupportIndicator.PER_encode(SGSN__Capability_gprsEnhancementsSupportIndicator_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_2_present) {
TTCN_Buffer ext_add_buf;
field_supportedCamelPhases.PER_encode(SGSN__Capability_supportedCamelPhases_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_3_present) {
TTCN_Buffer ext_add_buf;
field_supportedLCS__CapabilitySets.PER_encode(SGSN__Capability_supportedLCS__CapabilitySets_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_4_present) {
TTCN_Buffer ext_add_buf;
field_offeredCamel4CSIs.PER_encode(SGSN__Capability_offeredCamel4CSIs_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_5_present) {
TTCN_Buffer ext_add_buf;
field_smsCallBarringSupportIndicator.PER_encode(SGSN__Capability_smsCallBarringSupportIndicator_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_6_present) {
TTCN_Buffer ext_add_buf;
field_supportedRAT__TypesIndicator.PER_encode(SGSN__Capability_supportedRAT__TypesIndicator_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_7_present) {
TTCN_Buffer ext_add_buf;
field_supportedFeatures.PER_encode(SGSN__Capability_supportedFeatures_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_8_present) {
TTCN_Buffer ext_add_buf;
field_t__adsDataRetrieval.PER_encode(SGSN__Capability_t__adsDataRetrieval_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_9_present) {
TTCN_Buffer ext_add_buf;
field_homogeneousSupportOfIMSVoiceOverPSSessions.PER_encode(SGSN__Capability_homogeneousSupportOfIMSVoiceOverPSSessions_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
}
}

void SGSN__Capability::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_solsaSupportIndicator_present = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
if (field_solsaSupportIndicator_present) field_solsaSupportIndicator.PER_decode(ASN_NULL_descr_, p_buf, p_options);
else field_solsaSupportIndicator = OMIT_VALUE;
if (field_extensionContainer_present) field_extensionContainer.PER_decode(SGSN__Capability_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
if (nof_decoded_ext_adds < 10) {
for (int i = nof_decoded_ext_adds; i < 10; ++i) {
ext_presences.push_back(FALSE);
}
}
if (ext_presences[0]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_superChargerSupportedInServingNetworkEntity.PER_decode(SGSN__Capability_superChargerSupportedInServingNetworkEntity_descr_, ext_add_buf, p_options);
}
else {
field_superChargerSupportedInServingNetworkEntity = OMIT_VALUE;
}
if (ext_presences[1]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_gprsEnhancementsSupportIndicator.PER_decode(SGSN__Capability_gprsEnhancementsSupportIndicator_descr_, ext_add_buf, p_options);
}
else {
field_gprsEnhancementsSupportIndicator = OMIT_VALUE;
}
if (ext_presences[2]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_supportedCamelPhases.PER_decode(SGSN__Capability_supportedCamelPhases_descr_, ext_add_buf, p_options);
}
else {
field_supportedCamelPhases = OMIT_VALUE;
}
if (ext_presences[3]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_supportedLCS__CapabilitySets.PER_decode(SGSN__Capability_supportedLCS__CapabilitySets_descr_, ext_add_buf, p_options);
}
else {
field_supportedLCS__CapabilitySets = OMIT_VALUE;
}
if (ext_presences[4]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_offeredCamel4CSIs.PER_decode(SGSN__Capability_offeredCamel4CSIs_descr_, ext_add_buf, p_options);
}
else {
field_offeredCamel4CSIs = OMIT_VALUE;
}
if (ext_presences[5]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_smsCallBarringSupportIndicator.PER_decode(SGSN__Capability_smsCallBarringSupportIndicator_descr_, ext_add_buf, p_options);
}
else {
field_smsCallBarringSupportIndicator = OMIT_VALUE;
}
if (ext_presences[6]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_supportedRAT__TypesIndicator.PER_decode(SGSN__Capability_supportedRAT__TypesIndicator_descr_, ext_add_buf, p_options);
}
else {
field_supportedRAT__TypesIndicator = OMIT_VALUE;
}
if (ext_presences[7]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_supportedFeatures.PER_decode(SGSN__Capability_supportedFeatures_descr_, ext_add_buf, p_options);
}
else {
field_supportedFeatures = OMIT_VALUE;
}
if (ext_presences[8]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_t__adsDataRetrieval.PER_decode(SGSN__Capability_t__adsDataRetrieval_descr_, ext_add_buf, p_options);
}
else {
field_t__adsDataRetrieval = OMIT_VALUE;
}
if (ext_presences[9]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_homogeneousSupportOfIMSVoiceOverPSSessions.PER_decode(SGSN__Capability_homogeneousSupportOfIMSVoiceOverPSSessions_descr_, ext_add_buf, p_options);
}
else {
field_homogeneousSupportOfIMSVoiceOverPSSessions = OMIT_VALUE;
}
if (nof_decoded_ext_adds > 10) for (int i = 10; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct SGSN__Capability_template::single_value_struct {
ASN_NULL_template field_solsaSupportIndicator;
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
SuperChargerInfo_template field_superChargerSupportedInServingNetworkEntity;
ASN_NULL_template field_gprsEnhancementsSupportIndicator;
BITSTRING_template field_supportedCamelPhases;
BITSTRING_template field_supportedLCS__CapabilitySets;
BITSTRING_template field_offeredCamel4CSIs;
ASN_NULL_template field_smsCallBarringSupportIndicator;
BITSTRING_template field_supportedRAT__TypesIndicator;
BITSTRING_template field_supportedFeatures;
ASN_NULL_template field_t__adsDataRetrieval;
BOOLEAN_template field_homogeneousSupportOfIMSVoiceOverPSSessions;
};

void SGSN__Capability_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_solsaSupportIndicator = ANY_OR_OMIT;
single_value->field_extensionContainer = ANY_OR_OMIT;
single_value->field_superChargerSupportedInServingNetworkEntity = ANY_OR_OMIT;
single_value->field_gprsEnhancementsSupportIndicator = ANY_OR_OMIT;
single_value->field_supportedCamelPhases = ANY_OR_OMIT;
single_value->field_supportedLCS__CapabilitySets = ANY_OR_OMIT;
single_value->field_offeredCamel4CSIs = ANY_OR_OMIT;
single_value->field_smsCallBarringSupportIndicator = ANY_OR_OMIT;
single_value->field_supportedRAT__TypesIndicator = ANY_OR_OMIT;
single_value->field_supportedFeatures = ANY_OR_OMIT;
single_value->field_t__adsDataRetrieval = ANY_OR_OMIT;
single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions = ANY_OR_OMIT;
}
}
}

void SGSN__Capability_template::copy_value(const SGSN__Capability& other_value)
{
single_value = new single_value_struct;
if (other_value.solsaSupportIndicator().is_bound()) {
  if (other_value.solsaSupportIndicator().ispresent()) single_value->field_solsaSupportIndicator = other_value.solsaSupportIndicator()();
  else single_value->field_solsaSupportIndicator = OMIT_VALUE;
} else {
  single_value->field_solsaSupportIndicator.clean_up();
}
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
if (other_value.superChargerSupportedInServingNetworkEntity().is_bound()) {
  if (other_value.superChargerSupportedInServingNetworkEntity().ispresent()) single_value->field_superChargerSupportedInServingNetworkEntity = other_value.superChargerSupportedInServingNetworkEntity()();
  else single_value->field_superChargerSupportedInServingNetworkEntity = OMIT_VALUE;
} else {
  single_value->field_superChargerSupportedInServingNetworkEntity.clean_up();
}
if (other_value.gprsEnhancementsSupportIndicator().is_bound()) {
  if (other_value.gprsEnhancementsSupportIndicator().ispresent()) single_value->field_gprsEnhancementsSupportIndicator = other_value.gprsEnhancementsSupportIndicator()();
  else single_value->field_gprsEnhancementsSupportIndicator = OMIT_VALUE;
} else {
  single_value->field_gprsEnhancementsSupportIndicator.clean_up();
}
if (other_value.supportedCamelPhases().is_bound()) {
  if (other_value.supportedCamelPhases().ispresent()) single_value->field_supportedCamelPhases = other_value.supportedCamelPhases()();
  else single_value->field_supportedCamelPhases = OMIT_VALUE;
} else {
  single_value->field_supportedCamelPhases.clean_up();
}
if (other_value.supportedLCS__CapabilitySets().is_bound()) {
  if (other_value.supportedLCS__CapabilitySets().ispresent()) single_value->field_supportedLCS__CapabilitySets = other_value.supportedLCS__CapabilitySets()();
  else single_value->field_supportedLCS__CapabilitySets = OMIT_VALUE;
} else {
  single_value->field_supportedLCS__CapabilitySets.clean_up();
}
if (other_value.offeredCamel4CSIs().is_bound()) {
  if (other_value.offeredCamel4CSIs().ispresent()) single_value->field_offeredCamel4CSIs = other_value.offeredCamel4CSIs()();
  else single_value->field_offeredCamel4CSIs = OMIT_VALUE;
} else {
  single_value->field_offeredCamel4CSIs.clean_up();
}
if (other_value.smsCallBarringSupportIndicator().is_bound()) {
  if (other_value.smsCallBarringSupportIndicator().ispresent()) single_value->field_smsCallBarringSupportIndicator = other_value.smsCallBarringSupportIndicator()();
  else single_value->field_smsCallBarringSupportIndicator = OMIT_VALUE;
} else {
  single_value->field_smsCallBarringSupportIndicator.clean_up();
}
if (other_value.supportedRAT__TypesIndicator().is_bound()) {
  if (other_value.supportedRAT__TypesIndicator().ispresent()) single_value->field_supportedRAT__TypesIndicator = other_value.supportedRAT__TypesIndicator()();
  else single_value->field_supportedRAT__TypesIndicator = OMIT_VALUE;
} else {
  single_value->field_supportedRAT__TypesIndicator.clean_up();
}
if (other_value.supportedFeatures().is_bound()) {
  if (other_value.supportedFeatures().ispresent()) single_value->field_supportedFeatures = other_value.supportedFeatures()();
  else single_value->field_supportedFeatures = OMIT_VALUE;
} else {
  single_value->field_supportedFeatures.clean_up();
}
if (other_value.t__adsDataRetrieval().is_bound()) {
  if (other_value.t__adsDataRetrieval().ispresent()) single_value->field_t__adsDataRetrieval = other_value.t__adsDataRetrieval()();
  else single_value->field_t__adsDataRetrieval = OMIT_VALUE;
} else {
  single_value->field_t__adsDataRetrieval.clean_up();
}
if (other_value.homogeneousSupportOfIMSVoiceOverPSSessions().is_bound()) {
  if (other_value.homogeneousSupportOfIMSVoiceOverPSSessions().ispresent()) single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions = other_value.homogeneousSupportOfIMSVoiceOverPSSessions()();
  else single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions = OMIT_VALUE;
} else {
  single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void SGSN__Capability_template::copy_template(const SGSN__Capability_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.solsaSupportIndicator().get_selection()) {
single_value->field_solsaSupportIndicator = other_value.solsaSupportIndicator();
} else {
single_value->field_solsaSupportIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.superChargerSupportedInServingNetworkEntity().get_selection()) {
single_value->field_superChargerSupportedInServingNetworkEntity = other_value.superChargerSupportedInServingNetworkEntity();
} else {
single_value->field_superChargerSupportedInServingNetworkEntity.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.gprsEnhancementsSupportIndicator().get_selection()) {
single_value->field_gprsEnhancementsSupportIndicator = other_value.gprsEnhancementsSupportIndicator();
} else {
single_value->field_gprsEnhancementsSupportIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.supportedCamelPhases().get_selection()) {
single_value->field_supportedCamelPhases = other_value.supportedCamelPhases();
} else {
single_value->field_supportedCamelPhases.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.supportedLCS__CapabilitySets().get_selection()) {
single_value->field_supportedLCS__CapabilitySets = other_value.supportedLCS__CapabilitySets();
} else {
single_value->field_supportedLCS__CapabilitySets.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.offeredCamel4CSIs().get_selection()) {
single_value->field_offeredCamel4CSIs = other_value.offeredCamel4CSIs();
} else {
single_value->field_offeredCamel4CSIs.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.smsCallBarringSupportIndicator().get_selection()) {
single_value->field_smsCallBarringSupportIndicator = other_value.smsCallBarringSupportIndicator();
} else {
single_value->field_smsCallBarringSupportIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.supportedRAT__TypesIndicator().get_selection()) {
single_value->field_supportedRAT__TypesIndicator = other_value.supportedRAT__TypesIndicator();
} else {
single_value->field_supportedRAT__TypesIndicator.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.supportedFeatures().get_selection()) {
single_value->field_supportedFeatures = other_value.supportedFeatures();
} else {
single_value->field_supportedFeatures.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.t__adsDataRetrieval().get_selection()) {
single_value->field_t__adsDataRetrieval = other_value.t__adsDataRetrieval();
} else {
single_value->field_t__adsDataRetrieval.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.homogeneousSupportOfIMSVoiceOverPSSessions().get_selection()) {
single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions = other_value.homogeneousSupportOfIMSVoiceOverPSSessions();
} else {
single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new SGSN__Capability_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new SGSN__Capability_template(*other_value.implication_.precondition);
implication_.implied_template = new SGSN__Capability_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.SGSN-Capability.");
break;
}
set_selection(other_value);
}

SGSN__Capability_template::SGSN__Capability_template()
{
}

SGSN__Capability_template::SGSN__Capability_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

SGSN__Capability_template::SGSN__Capability_template(const SGSN__Capability& other_value)
{
copy_value(other_value);
}

SGSN__Capability_template::SGSN__Capability_template(const OPTIONAL<SGSN__Capability>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SGSN__Capability&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.SGSN-Capability from an unbound optional field.");
}
}

SGSN__Capability_template::SGSN__Capability_template(SGSN__Capability_template* p_precondition, SGSN__Capability_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

SGSN__Capability_template::SGSN__Capability_template(Dynamic_Match_Interface<SGSN__Capability>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<SGSN__Capability>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

SGSN__Capability_template::SGSN__Capability_template(const SGSN__Capability_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

SGSN__Capability_template::~SGSN__Capability_template()
{
clean_up();
}

SGSN__Capability_template& SGSN__Capability_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

SGSN__Capability_template& SGSN__Capability_template::operator=(const SGSN__Capability& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

SGSN__Capability_template& SGSN__Capability_template::operator=(const OPTIONAL<SGSN__Capability>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const SGSN__Capability&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.SGSN-Capability.");
}
return *this;
}

SGSN__Capability_template& SGSN__Capability_template::operator=(const SGSN__Capability_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean SGSN__Capability_template::match(const SGSN__Capability& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.solsaSupportIndicator().is_bound()) return FALSE;
if((other_value.solsaSupportIndicator().ispresent() ? !single_value->field_solsaSupportIndicator.match((const ASN_NULL&)other_value.solsaSupportIndicator(), legacy) : !single_value->field_solsaSupportIndicator.match_omit(legacy)))return FALSE;
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
if(!other_value.superChargerSupportedInServingNetworkEntity().is_bound()) return FALSE;
if((other_value.superChargerSupportedInServingNetworkEntity().ispresent() ? !single_value->field_superChargerSupportedInServingNetworkEntity.match((const SuperChargerInfo&)other_value.superChargerSupportedInServingNetworkEntity(), legacy) : !single_value->field_superChargerSupportedInServingNetworkEntity.match_omit(legacy)))return FALSE;
if(!other_value.gprsEnhancementsSupportIndicator().is_bound()) return FALSE;
if((other_value.gprsEnhancementsSupportIndicator().ispresent() ? !single_value->field_gprsEnhancementsSupportIndicator.match((const ASN_NULL&)other_value.gprsEnhancementsSupportIndicator(), legacy) : !single_value->field_gprsEnhancementsSupportIndicator.match_omit(legacy)))return FALSE;
if(!other_value.supportedCamelPhases().is_bound()) return FALSE;
if((other_value.supportedCamelPhases().ispresent() ? !single_value->field_supportedCamelPhases.match((const BITSTRING&)other_value.supportedCamelPhases(), legacy) : !single_value->field_supportedCamelPhases.match_omit(legacy)))return FALSE;
if(!other_value.supportedLCS__CapabilitySets().is_bound()) return FALSE;
if((other_value.supportedLCS__CapabilitySets().ispresent() ? !single_value->field_supportedLCS__CapabilitySets.match((const BITSTRING&)other_value.supportedLCS__CapabilitySets(), legacy) : !single_value->field_supportedLCS__CapabilitySets.match_omit(legacy)))return FALSE;
if(!other_value.offeredCamel4CSIs().is_bound()) return FALSE;
if((other_value.offeredCamel4CSIs().ispresent() ? !single_value->field_offeredCamel4CSIs.match((const BITSTRING&)other_value.offeredCamel4CSIs(), legacy) : !single_value->field_offeredCamel4CSIs.match_omit(legacy)))return FALSE;
if(!other_value.smsCallBarringSupportIndicator().is_bound()) return FALSE;
if((other_value.smsCallBarringSupportIndicator().ispresent() ? !single_value->field_smsCallBarringSupportIndicator.match((const ASN_NULL&)other_value.smsCallBarringSupportIndicator(), legacy) : !single_value->field_smsCallBarringSupportIndicator.match_omit(legacy)))return FALSE;
if(!other_value.supportedRAT__TypesIndicator().is_bound()) return FALSE;
if((other_value.supportedRAT__TypesIndicator().ispresent() ? !single_value->field_supportedRAT__TypesIndicator.match((const BITSTRING&)other_value.supportedRAT__TypesIndicator(), legacy) : !single_value->field_supportedRAT__TypesIndicator.match_omit(legacy)))return FALSE;
if(!other_value.supportedFeatures().is_bound()) return FALSE;
if((other_value.supportedFeatures().ispresent() ? !single_value->field_supportedFeatures.match((const BITSTRING&)other_value.supportedFeatures(), legacy) : !single_value->field_supportedFeatures.match_omit(legacy)))return FALSE;
if(!other_value.t__adsDataRetrieval().is_bound()) return FALSE;
if((other_value.t__adsDataRetrieval().ispresent() ? !single_value->field_t__adsDataRetrieval.match((const ASN_NULL&)other_value.t__adsDataRetrieval(), legacy) : !single_value->field_t__adsDataRetrieval.match_omit(legacy)))return FALSE;
if(!other_value.homogeneousSupportOfIMSVoiceOverPSSessions().is_bound()) return FALSE;
if((other_value.homogeneousSupportOfIMSVoiceOverPSSessions().ispresent() ? !single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions.match((const BOOLEAN&)other_value.homogeneousSupportOfIMSVoiceOverPSSessions(), legacy) : !single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.SGSN-Capability.");
}
return FALSE;
}

boolean SGSN__Capability_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_solsaSupportIndicator.is_omit() || single_value->field_solsaSupportIndicator.is_bound())
 || (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound())
 || (single_value->field_superChargerSupportedInServingNetworkEntity.is_omit() || single_value->field_superChargerSupportedInServingNetworkEntity.is_bound())
 || (single_value->field_gprsEnhancementsSupportIndicator.is_omit() || single_value->field_gprsEnhancementsSupportIndicator.is_bound())
 || (single_value->field_supportedCamelPhases.is_omit() || single_value->field_supportedCamelPhases.is_bound())
 || (single_value->field_supportedLCS__CapabilitySets.is_omit() || single_value->field_supportedLCS__CapabilitySets.is_bound())
 || (single_value->field_offeredCamel4CSIs.is_omit() || single_value->field_offeredCamel4CSIs.is_bound())
 || (single_value->field_smsCallBarringSupportIndicator.is_omit() || single_value->field_smsCallBarringSupportIndicator.is_bound())
 || (single_value->field_supportedRAT__TypesIndicator.is_omit() || single_value->field_supportedRAT__TypesIndicator.is_bound())
 || (single_value->field_supportedFeatures.is_omit() || single_value->field_supportedFeatures.is_bound())
 || (single_value->field_t__adsDataRetrieval.is_omit() || single_value->field_t__adsDataRetrieval.is_bound())
 || (single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions.is_omit() || single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions.is_bound());
}

boolean SGSN__Capability_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_solsaSupportIndicator.is_omit() || single_value->field_solsaSupportIndicator.is_value())
 && (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value())
 && (single_value->field_superChargerSupportedInServingNetworkEntity.is_omit() || single_value->field_superChargerSupportedInServingNetworkEntity.is_value())
 && (single_value->field_gprsEnhancementsSupportIndicator.is_omit() || single_value->field_gprsEnhancementsSupportIndicator.is_value())
 && (single_value->field_supportedCamelPhases.is_omit() || single_value->field_supportedCamelPhases.is_value())
 && (single_value->field_supportedLCS__CapabilitySets.is_omit() || single_value->field_supportedLCS__CapabilitySets.is_value())
 && (single_value->field_offeredCamel4CSIs.is_omit() || single_value->field_offeredCamel4CSIs.is_value())
 && (single_value->field_smsCallBarringSupportIndicator.is_omit() || single_value->field_smsCallBarringSupportIndicator.is_value())
 && (single_value->field_supportedRAT__TypesIndicator.is_omit() || single_value->field_supportedRAT__TypesIndicator.is_value())
 && (single_value->field_supportedFeatures.is_omit() || single_value->field_supportedFeatures.is_value())
 && (single_value->field_t__adsDataRetrieval.is_omit() || single_value->field_t__adsDataRetrieval.is_value())
 && (single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions.is_omit() || single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions.is_value());
}

void SGSN__Capability_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

SGSN__Capability SGSN__Capability_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.SGSN-Capability.");
SGSN__Capability ret_val;
if (single_value->field_solsaSupportIndicator.is_omit()) ret_val.solsaSupportIndicator() = OMIT_VALUE;
else if (single_value->field_solsaSupportIndicator.is_bound()) {
ret_val.solsaSupportIndicator() = single_value->field_solsaSupportIndicator.valueof();
}
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
if (single_value->field_superChargerSupportedInServingNetworkEntity.is_omit()) ret_val.superChargerSupportedInServingNetworkEntity() = OMIT_VALUE;
else if (single_value->field_superChargerSupportedInServingNetworkEntity.is_bound()) {
ret_val.superChargerSupportedInServingNetworkEntity() = single_value->field_superChargerSupportedInServingNetworkEntity.valueof();
}
if (single_value->field_gprsEnhancementsSupportIndicator.is_omit()) ret_val.gprsEnhancementsSupportIndicator() = OMIT_VALUE;
else if (single_value->field_gprsEnhancementsSupportIndicator.is_bound()) {
ret_val.gprsEnhancementsSupportIndicator() = single_value->field_gprsEnhancementsSupportIndicator.valueof();
}
if (single_value->field_supportedCamelPhases.is_omit()) ret_val.supportedCamelPhases() = OMIT_VALUE;
else if (single_value->field_supportedCamelPhases.is_bound()) {
ret_val.supportedCamelPhases() = single_value->field_supportedCamelPhases.valueof();
}
if (single_value->field_supportedLCS__CapabilitySets.is_omit()) ret_val.supportedLCS__CapabilitySets() = OMIT_VALUE;
else if (single_value->field_supportedLCS__CapabilitySets.is_bound()) {
ret_val.supportedLCS__CapabilitySets() = single_value->field_supportedLCS__CapabilitySets.valueof();
}
if (single_value->field_offeredCamel4CSIs.is_omit()) ret_val.offeredCamel4CSIs() = OMIT_VALUE;
else if (single_value->field_offeredCamel4CSIs.is_bound()) {
ret_val.offeredCamel4CSIs() = single_value->field_offeredCamel4CSIs.valueof();
}
if (single_value->field_smsCallBarringSupportIndicator.is_omit()) ret_val.smsCallBarringSupportIndicator() = OMIT_VALUE;
else if (single_value->field_smsCallBarringSupportIndicator.is_bound()) {
ret_val.smsCallBarringSupportIndicator() = single_value->field_smsCallBarringSupportIndicator.valueof();
}
if (single_value->field_supportedRAT__TypesIndicator.is_omit()) ret_val.supportedRAT__TypesIndicator() = OMIT_VALUE;
else if (single_value->field_supportedRAT__TypesIndicator.is_bound()) {
ret_val.supportedRAT__TypesIndicator() = single_value->field_supportedRAT__TypesIndicator.valueof();
}
if (single_value->field_supportedFeatures.is_omit()) ret_val.supportedFeatures() = OMIT_VALUE;
else if (single_value->field_supportedFeatures.is_bound()) {
ret_val.supportedFeatures() = single_value->field_supportedFeatures.valueof();
}
if (single_value->field_t__adsDataRetrieval.is_omit()) ret_val.t__adsDataRetrieval() = OMIT_VALUE;
else if (single_value->field_t__adsDataRetrieval.is_bound()) {
ret_val.t__adsDataRetrieval() = single_value->field_t__adsDataRetrieval.valueof();
}
if (single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions.is_omit()) ret_val.homogeneousSupportOfIMSVoiceOverPSSessions() = OMIT_VALUE;
else if (single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions.is_bound()) {
ret_val.homogeneousSupportOfIMSVoiceOverPSSessions() = single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions.valueof();
}
return ret_val;
}

void SGSN__Capability_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.SGSN-Capability.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new SGSN__Capability_template[list_length];
}

SGSN__Capability_template& SGSN__Capability_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.SGSN-Capability.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.SGSN-Capability.");
return value_list.list_value[list_index];
}

ASN_NULL_template& SGSN__Capability_template::solsaSupportIndicator()
{
set_specific();
return single_value->field_solsaSupportIndicator;
}

const ASN_NULL_template& SGSN__Capability_template::solsaSupportIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field solsaSupportIndicator of a non-specific template of type @MAP-MS-DataTypes.SGSN-Capability.");
return single_value->field_solsaSupportIndicator;
}

MAP__ExtensionDataTypes::ExtensionContainer_template& SGSN__Capability_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& SGSN__Capability_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-MS-DataTypes.SGSN-Capability.");
return single_value->field_extensionContainer;
}

SuperChargerInfo_template& SGSN__Capability_template::superChargerSupportedInServingNetworkEntity()
{
set_specific();
return single_value->field_superChargerSupportedInServingNetworkEntity;
}

const SuperChargerInfo_template& SGSN__Capability_template::superChargerSupportedInServingNetworkEntity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field superChargerSupportedInServingNetworkEntity of a non-specific template of type @MAP-MS-DataTypes.SGSN-Capability.");
return single_value->field_superChargerSupportedInServingNetworkEntity;
}

ASN_NULL_template& SGSN__Capability_template::gprsEnhancementsSupportIndicator()
{
set_specific();
return single_value->field_gprsEnhancementsSupportIndicator;
}

const ASN_NULL_template& SGSN__Capability_template::gprsEnhancementsSupportIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field gprsEnhancementsSupportIndicator of a non-specific template of type @MAP-MS-DataTypes.SGSN-Capability.");
return single_value->field_gprsEnhancementsSupportIndicator;
}

BITSTRING_template& SGSN__Capability_template::supportedCamelPhases()
{
set_specific();
return single_value->field_supportedCamelPhases;
}

const BITSTRING_template& SGSN__Capability_template::supportedCamelPhases() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field supportedCamelPhases of a non-specific template of type @MAP-MS-DataTypes.SGSN-Capability.");
return single_value->field_supportedCamelPhases;
}

BITSTRING_template& SGSN__Capability_template::supportedLCS__CapabilitySets()
{
set_specific();
return single_value->field_supportedLCS__CapabilitySets;
}

const BITSTRING_template& SGSN__Capability_template::supportedLCS__CapabilitySets() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field supportedLCS_CapabilitySets of a non-specific template of type @MAP-MS-DataTypes.SGSN-Capability.");
return single_value->field_supportedLCS__CapabilitySets;
}

BITSTRING_template& SGSN__Capability_template::offeredCamel4CSIs()
{
set_specific();
return single_value->field_offeredCamel4CSIs;
}

const BITSTRING_template& SGSN__Capability_template::offeredCamel4CSIs() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field offeredCamel4CSIs of a non-specific template of type @MAP-MS-DataTypes.SGSN-Capability.");
return single_value->field_offeredCamel4CSIs;
}

ASN_NULL_template& SGSN__Capability_template::smsCallBarringSupportIndicator()
{
set_specific();
return single_value->field_smsCallBarringSupportIndicator;
}

const ASN_NULL_template& SGSN__Capability_template::smsCallBarringSupportIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field smsCallBarringSupportIndicator of a non-specific template of type @MAP-MS-DataTypes.SGSN-Capability.");
return single_value->field_smsCallBarringSupportIndicator;
}

BITSTRING_template& SGSN__Capability_template::supportedRAT__TypesIndicator()
{
set_specific();
return single_value->field_supportedRAT__TypesIndicator;
}

const BITSTRING_template& SGSN__Capability_template::supportedRAT__TypesIndicator() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field supportedRAT_TypesIndicator of a non-specific template of type @MAP-MS-DataTypes.SGSN-Capability.");
return single_value->field_supportedRAT__TypesIndicator;
}

BITSTRING_template& SGSN__Capability_template::supportedFeatures()
{
set_specific();
return single_value->field_supportedFeatures;
}

const BITSTRING_template& SGSN__Capability_template::supportedFeatures() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field supportedFeatures of a non-specific template of type @MAP-MS-DataTypes.SGSN-Capability.");
return single_value->field_supportedFeatures;
}

ASN_NULL_template& SGSN__Capability_template::t__adsDataRetrieval()
{
set_specific();
return single_value->field_t__adsDataRetrieval;
}

const ASN_NULL_template& SGSN__Capability_template::t__adsDataRetrieval() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field t_adsDataRetrieval of a non-specific template of type @MAP-MS-DataTypes.SGSN-Capability.");
return single_value->field_t__adsDataRetrieval;
}

BOOLEAN_template& SGSN__Capability_template::homogeneousSupportOfIMSVoiceOverPSSessions()
{
set_specific();
return single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions;
}

const BOOLEAN_template& SGSN__Capability_template::homogeneousSupportOfIMSVoiceOverPSSessions() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field homogeneousSupportOfIMSVoiceOverPSSessions of a non-specific template of type @MAP-MS-DataTypes.SGSN-Capability.");
return single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions;
}

int SGSN__Capability_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.SGSN-Capability which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 0;
      if (single_value->field_solsaSupportIndicator.is_present()) ret_val++;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      if (single_value->field_superChargerSupportedInServingNetworkEntity.is_present()) ret_val++;
      if (single_value->field_gprsEnhancementsSupportIndicator.is_present()) ret_val++;
      if (single_value->field_supportedCamelPhases.is_present()) ret_val++;
      if (single_value->field_supportedLCS__CapabilitySets.is_present()) ret_val++;
      if (single_value->field_offeredCamel4CSIs.is_present()) ret_val++;
      if (single_value->field_smsCallBarringSupportIndicator.is_present()) ret_val++;
      if (single_value->field_supportedRAT__TypesIndicator.is_present()) ret_val++;
      if (single_value->field_supportedFeatures.is_present()) ret_val++;
      if (single_value->field_t__adsDataRetrieval.is_present()) ret_val++;
      if (single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.SGSN-Capability containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.SGSN-Capability containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.SGSN-Capability containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.SGSN-Capability containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.SGSN-Capability containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.SGSN-Capability containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.SGSN-Capability containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.SGSN-Capability containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.SGSN-Capability.");
  }
  return 0;
}

void SGSN__Capability_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ solsaSupportIndicator := ");
single_value->field_solsaSupportIndicator.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(", superChargerSupportedInServingNetworkEntity := ");
single_value->field_superChargerSupportedInServingNetworkEntity.log();
TTCN_Logger::log_event_str(", gprsEnhancementsSupportIndicator := ");
single_value->field_gprsEnhancementsSupportIndicator.log();
TTCN_Logger::log_event_str(", supportedCamelPhases := ");
single_value->field_supportedCamelPhases.log();
TTCN_Logger::log_event_str(", supportedLCS_CapabilitySets := ");
single_value->field_supportedLCS__CapabilitySets.log();
TTCN_Logger::log_event_str(", offeredCamel4CSIs := ");
single_value->field_offeredCamel4CSIs.log();
TTCN_Logger::log_event_str(", smsCallBarringSupportIndicator := ");
single_value->field_smsCallBarringSupportIndicator.log();
TTCN_Logger::log_event_str(", supportedRAT_TypesIndicator := ");
single_value->field_supportedRAT__TypesIndicator.log();
TTCN_Logger::log_event_str(", supportedFeatures := ");
single_value->field_supportedFeatures.log();
TTCN_Logger::log_event_str(", t_adsDataRetrieval := ");
single_value->field_t__adsDataRetrieval.log();
TTCN_Logger::log_event_str(", homogeneousSupportOfIMSVoiceOverPSSessions := ");
single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void SGSN__Capability_template::log_match(const SGSN__Capability& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.solsaSupportIndicator().ispresent()){
if(!single_value->field_solsaSupportIndicator.match(match_value.solsaSupportIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".solsaSupportIndicator");
single_value->field_solsaSupportIndicator.log_match(match_value.solsaSupportIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_solsaSupportIndicator.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".solsaSupportIndicator := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_solsaSupportIndicator.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.superChargerSupportedInServingNetworkEntity().ispresent()){
if(!single_value->field_superChargerSupportedInServingNetworkEntity.match(match_value.superChargerSupportedInServingNetworkEntity(), legacy)){
TTCN_Logger::log_logmatch_info(".superChargerSupportedInServingNetworkEntity");
single_value->field_superChargerSupportedInServingNetworkEntity.log_match(match_value.superChargerSupportedInServingNetworkEntity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_superChargerSupportedInServingNetworkEntity.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".superChargerSupportedInServingNetworkEntity := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_superChargerSupportedInServingNetworkEntity.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.gprsEnhancementsSupportIndicator().ispresent()){
if(!single_value->field_gprsEnhancementsSupportIndicator.match(match_value.gprsEnhancementsSupportIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".gprsEnhancementsSupportIndicator");
single_value->field_gprsEnhancementsSupportIndicator.log_match(match_value.gprsEnhancementsSupportIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_gprsEnhancementsSupportIndicator.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".gprsEnhancementsSupportIndicator := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_gprsEnhancementsSupportIndicator.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.supportedCamelPhases().ispresent()){
if(!single_value->field_supportedCamelPhases.match(match_value.supportedCamelPhases(), legacy)){
TTCN_Logger::log_logmatch_info(".supportedCamelPhases");
single_value->field_supportedCamelPhases.log_match(match_value.supportedCamelPhases(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_supportedCamelPhases.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".supportedCamelPhases := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_supportedCamelPhases.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.supportedLCS__CapabilitySets().ispresent()){
if(!single_value->field_supportedLCS__CapabilitySets.match(match_value.supportedLCS__CapabilitySets(), legacy)){
TTCN_Logger::log_logmatch_info(".supportedLCS_CapabilitySets");
single_value->field_supportedLCS__CapabilitySets.log_match(match_value.supportedLCS__CapabilitySets(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_supportedLCS__CapabilitySets.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".supportedLCS_CapabilitySets := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_supportedLCS__CapabilitySets.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.offeredCamel4CSIs().ispresent()){
if(!single_value->field_offeredCamel4CSIs.match(match_value.offeredCamel4CSIs(), legacy)){
TTCN_Logger::log_logmatch_info(".offeredCamel4CSIs");
single_value->field_offeredCamel4CSIs.log_match(match_value.offeredCamel4CSIs(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_offeredCamel4CSIs.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".offeredCamel4CSIs := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_offeredCamel4CSIs.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.smsCallBarringSupportIndicator().ispresent()){
if(!single_value->field_smsCallBarringSupportIndicator.match(match_value.smsCallBarringSupportIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".smsCallBarringSupportIndicator");
single_value->field_smsCallBarringSupportIndicator.log_match(match_value.smsCallBarringSupportIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_smsCallBarringSupportIndicator.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".smsCallBarringSupportIndicator := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_smsCallBarringSupportIndicator.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.supportedRAT__TypesIndicator().ispresent()){
if(!single_value->field_supportedRAT__TypesIndicator.match(match_value.supportedRAT__TypesIndicator(), legacy)){
TTCN_Logger::log_logmatch_info(".supportedRAT_TypesIndicator");
single_value->field_supportedRAT__TypesIndicator.log_match(match_value.supportedRAT__TypesIndicator(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_supportedRAT__TypesIndicator.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".supportedRAT_TypesIndicator := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_supportedRAT__TypesIndicator.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.supportedFeatures().ispresent()){
if(!single_value->field_supportedFeatures.match(match_value.supportedFeatures(), legacy)){
TTCN_Logger::log_logmatch_info(".supportedFeatures");
single_value->field_supportedFeatures.log_match(match_value.supportedFeatures(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_supportedFeatures.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".supportedFeatures := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_supportedFeatures.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.t__adsDataRetrieval().ispresent()){
if(!single_value->field_t__adsDataRetrieval.match(match_value.t__adsDataRetrieval(), legacy)){
TTCN_Logger::log_logmatch_info(".t_adsDataRetrieval");
single_value->field_t__adsDataRetrieval.log_match(match_value.t__adsDataRetrieval(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_t__adsDataRetrieval.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".t_adsDataRetrieval := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_t__adsDataRetrieval.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.homogeneousSupportOfIMSVoiceOverPSSessions().ispresent()){
if(!single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions.match(match_value.homogeneousSupportOfIMSVoiceOverPSSessions(), legacy)){
TTCN_Logger::log_logmatch_info(".homogeneousSupportOfIMSVoiceOverPSSessions");
single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions.log_match(match_value.homogeneousSupportOfIMSVoiceOverPSSessions(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".homogeneousSupportOfIMSVoiceOverPSSessions := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ solsaSupportIndicator := ");
if (match_value.solsaSupportIndicator().ispresent()) {
single_value->field_solsaSupportIndicator.log_match(match_value.solsaSupportIndicator(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_solsaSupportIndicator.log();
if (single_value->field_solsaSupportIndicator.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", superChargerSupportedInServingNetworkEntity := ");
if (match_value.superChargerSupportedInServingNetworkEntity().ispresent()) {
single_value->field_superChargerSupportedInServingNetworkEntity.log_match(match_value.superChargerSupportedInServingNetworkEntity(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_superChargerSupportedInServingNetworkEntity.log();
if (single_value->field_superChargerSupportedInServingNetworkEntity.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", gprsEnhancementsSupportIndicator := ");
if (match_value.gprsEnhancementsSupportIndicator().ispresent()) {
single_value->field_gprsEnhancementsSupportIndicator.log_match(match_value.gprsEnhancementsSupportIndicator(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_gprsEnhancementsSupportIndicator.log();
if (single_value->field_gprsEnhancementsSupportIndicator.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", supportedCamelPhases := ");
if (match_value.supportedCamelPhases().ispresent()) {
single_value->field_supportedCamelPhases.log_match(match_value.supportedCamelPhases(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_supportedCamelPhases.log();
if (single_value->field_supportedCamelPhases.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", supportedLCS_CapabilitySets := ");
if (match_value.supportedLCS__CapabilitySets().ispresent()) {
single_value->field_supportedLCS__CapabilitySets.log_match(match_value.supportedLCS__CapabilitySets(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_supportedLCS__CapabilitySets.log();
if (single_value->field_supportedLCS__CapabilitySets.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", offeredCamel4CSIs := ");
if (match_value.offeredCamel4CSIs().ispresent()) {
single_value->field_offeredCamel4CSIs.log_match(match_value.offeredCamel4CSIs(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_offeredCamel4CSIs.log();
if (single_value->field_offeredCamel4CSIs.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", smsCallBarringSupportIndicator := ");
if (match_value.smsCallBarringSupportIndicator().ispresent()) {
single_value->field_smsCallBarringSupportIndicator.log_match(match_value.smsCallBarringSupportIndicator(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_smsCallBarringSupportIndicator.log();
if (single_value->field_smsCallBarringSupportIndicator.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", supportedRAT_TypesIndicator := ");
if (match_value.supportedRAT__TypesIndicator().ispresent()) {
single_value->field_supportedRAT__TypesIndicator.log_match(match_value.supportedRAT__TypesIndicator(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_supportedRAT__TypesIndicator.log();
if (single_value->field_supportedRAT__TypesIndicator.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", supportedFeatures := ");
if (match_value.supportedFeatures().ispresent()) {
single_value->field_supportedFeatures.log_match(match_value.supportedFeatures(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_supportedFeatures.log();
if (single_value->field_supportedFeatures.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", t_adsDataRetrieval := ");
if (match_value.t__adsDataRetrieval().ispresent()) {
single_value->field_t__adsDataRetrieval.log_match(match_value.t__adsDataRetrieval(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_t__adsDataRetrieval.log();
if (single_value->field_t__adsDataRetrieval.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", homogeneousSupportOfIMSVoiceOverPSSessions := ");
if (match_value.homogeneousSupportOfIMSVoiceOverPSSessions().ispresent()) {
single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions.log_match(match_value.homogeneousSupportOfIMSVoiceOverPSSessions(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions.log();
if (single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void SGSN__Capability_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!solsaSupportIndicator().is_bound()) solsaSupportIndicator() = OMIT_VALUE;
else solsaSupportIndicator().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!superChargerSupportedInServingNetworkEntity().is_bound()) superChargerSupportedInServingNetworkEntity() = OMIT_VALUE;
else superChargerSupportedInServingNetworkEntity().set_implicit_omit();
if (!gprsEnhancementsSupportIndicator().is_bound()) gprsEnhancementsSupportIndicator() = OMIT_VALUE;
else gprsEnhancementsSupportIndicator().set_implicit_omit();
if (!supportedCamelPhases().is_bound()) supportedCamelPhases() = OMIT_VALUE;
else supportedCamelPhases().set_implicit_omit();
if (!supportedLCS__CapabilitySets().is_bound()) supportedLCS__CapabilitySets() = OMIT_VALUE;
else supportedLCS__CapabilitySets().set_implicit_omit();
if (!offeredCamel4CSIs().is_bound()) offeredCamel4CSIs() = OMIT_VALUE;
else offeredCamel4CSIs().set_implicit_omit();
if (!smsCallBarringSupportIndicator().is_bound()) smsCallBarringSupportIndicator() = OMIT_VALUE;
else smsCallBarringSupportIndicator().set_implicit_omit();
if (!supportedRAT__TypesIndicator().is_bound()) supportedRAT__TypesIndicator() = OMIT_VALUE;
else supportedRAT__TypesIndicator().set_implicit_omit();
if (!supportedFeatures().is_bound()) supportedFeatures() = OMIT_VALUE;
else supportedFeatures().set_implicit_omit();
if (!t__adsDataRetrieval().is_bound()) t__adsDataRetrieval() = OMIT_VALUE;
else t__adsDataRetrieval().set_implicit_omit();
if (!homogeneousSupportOfIMSVoiceOverPSSessions().is_bound()) homogeneousSupportOfIMSVoiceOverPSSessions() = OMIT_VALUE;
else homogeneousSupportOfIMSVoiceOverPSSessions().set_implicit_omit();
}

void SGSN__Capability_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_solsaSupportIndicator.encode_text(text_buf);
single_value->field_extensionContainer.encode_text(text_buf);
single_value->field_superChargerSupportedInServingNetworkEntity.encode_text(text_buf);
single_value->field_gprsEnhancementsSupportIndicator.encode_text(text_buf);
single_value->field_supportedCamelPhases.encode_text(text_buf);
single_value->field_supportedLCS__CapabilitySets.encode_text(text_buf);
single_value->field_offeredCamel4CSIs.encode_text(text_buf);
single_value->field_smsCallBarringSupportIndicator.encode_text(text_buf);
single_value->field_supportedRAT__TypesIndicator.encode_text(text_buf);
single_value->field_supportedFeatures.encode_text(text_buf);
single_value->field_t__adsDataRetrieval.encode_text(text_buf);
single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.SGSN-Capability.");
}
}

void SGSN__Capability_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_solsaSupportIndicator.decode_text(text_buf);
single_value->field_extensionContainer.decode_text(text_buf);
single_value->field_superChargerSupportedInServingNetworkEntity.decode_text(text_buf);
single_value->field_gprsEnhancementsSupportIndicator.decode_text(text_buf);
single_value->field_supportedCamelPhases.decode_text(text_buf);
single_value->field_supportedLCS__CapabilitySets.decode_text(text_buf);
single_value->field_offeredCamel4CSIs.decode_text(text_buf);
single_value->field_smsCallBarringSupportIndicator.decode_text(text_buf);
single_value->field_supportedRAT__TypesIndicator.decode_text(text_buf);
single_value->field_supportedFeatures.decode_text(text_buf);
single_value->field_t__adsDataRetrieval.decode_text(text_buf);
single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new SGSN__Capability_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.SGSN-Capability.");
}
}

void SGSN__Capability_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    SGSN__Capability_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (12<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.SGSN-Capability has 12 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) solsaSupportIndicator().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) superChargerSupportedInServingNetworkEntity().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) gprsEnhancementsSupportIndicator().set_param(*param.get_elem(3));
    if (param.get_size()>4 && param.get_elem(4)->get_type()!=Module_Param::MP_NotUsed) supportedCamelPhases().set_param(*param.get_elem(4));
    if (param.get_size()>5 && param.get_elem(5)->get_type()!=Module_Param::MP_NotUsed) supportedLCS__CapabilitySets().set_param(*param.get_elem(5));
    if (param.get_size()>6 && param.get_elem(6)->get_type()!=Module_Param::MP_NotUsed) offeredCamel4CSIs().set_param(*param.get_elem(6));
    if (param.get_size()>7 && param.get_elem(7)->get_type()!=Module_Param::MP_NotUsed) smsCallBarringSupportIndicator().set_param(*param.get_elem(7));
    if (param.get_size()>8 && param.get_elem(8)->get_type()!=Module_Param::MP_NotUsed) supportedRAT__TypesIndicator().set_param(*param.get_elem(8));
    if (param.get_size()>9 && param.get_elem(9)->get_type()!=Module_Param::MP_NotUsed) supportedFeatures().set_param(*param.get_elem(9));
    if (param.get_size()>10 && param.get_elem(10)->get_type()!=Module_Param::MP_NotUsed) t__adsDataRetrieval().set_param(*param.get_elem(10));
    if (param.get_size()>11 && param.get_elem(11)->get_type()!=Module_Param::MP_NotUsed) homogeneousSupportOfIMSVoiceOverPSSessions().set_param(*param.get_elem(11));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "solsaSupportIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          solsaSupportIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "superChargerSupportedInServingNetworkEntity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          superChargerSupportedInServingNetworkEntity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "gprsEnhancementsSupportIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          gprsEnhancementsSupportIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "supportedCamelPhases")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          supportedCamelPhases().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "supportedLCS_CapabilitySets")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          supportedLCS__CapabilitySets().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "offeredCamel4CSIs")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          offeredCamel4CSIs().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "smsCallBarringSupportIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          smsCallBarringSupportIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "supportedRAT_TypesIndicator")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          supportedRAT__TypesIndicator().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "supportedFeatures")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          supportedFeatures().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "t_adsDataRetrieval")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          t__adsDataRetrieval().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "homogeneousSupportOfIMSVoiceOverPSSessions")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          homogeneousSupportOfIMSVoiceOverPSSessions().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.SGSN-Capability: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    SGSN__Capability_template* precondition = new SGSN__Capability_template;
    precondition->set_param(*param.get_elem(0));
    SGSN__Capability_template* implied_template = new SGSN__Capability_template;
    implied_template->set_param(*param.get_elem(1));
    *this = SGSN__Capability_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.SGSN-Capability");
  }
  is_ifpresent = param.get_ifpresent();
}

void SGSN__Capability_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_solsaSupportIndicator.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SGSN-Capability");
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SGSN-Capability");
single_value->field_superChargerSupportedInServingNetworkEntity.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SGSN-Capability");
single_value->field_gprsEnhancementsSupportIndicator.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SGSN-Capability");
single_value->field_supportedCamelPhases.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SGSN-Capability");
single_value->field_supportedLCS__CapabilitySets.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SGSN-Capability");
single_value->field_offeredCamel4CSIs.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SGSN-Capability");
single_value->field_smsCallBarringSupportIndicator.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SGSN-Capability");
single_value->field_supportedRAT__TypesIndicator.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SGSN-Capability");
single_value->field_supportedFeatures.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SGSN-Capability");
single_value->field_t__adsDataRetrieval.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SGSN-Capability");
single_value->field_homogeneousSupportOfIMSVoiceOverPSSessions.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.SGSN-Capability");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.SGSN-Capability");
}

boolean SGSN__Capability_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean SGSN__Capability_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void EPS__Info::copy_value(const EPS__Info& other_value)
{
switch (other_value.union_selection) {
case ALT_pdn__gw__update:
field_pdn__gw__update = new PDN__GW__Update(*other_value.field_pdn__gw__update);
break;
case ALT_isr__Information:
field_isr__Information = new BITSTRING(*other_value.field_isr__Information);
break;
default:
TTCN_error("Assignment of an unbound union value of type @MAP-MS-DataTypes.EPS-Info.");
}
union_selection = other_value.union_selection;
}

EPS__Info::EPS__Info()
{
union_selection = UNBOUND_VALUE;
}

EPS__Info::EPS__Info(const EPS__Info& other_value)
: Base_Type(){
copy_value(other_value);
}

EPS__Info::~EPS__Info()
{
clean_up();
}

EPS__Info& EPS__Info::operator=(const EPS__Info& other_value)
{
if (this != &other_value) {
clean_up();
copy_value(other_value);
}
return *this;
}

boolean EPS__Info::operator==(const EPS__Info& other_value) const
{
if (union_selection == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of union type @MAP-MS-DataTypes.EPS-Info.");
if (other_value.union_selection == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of union type @MAP-MS-DataTypes.EPS-Info.");
if (union_selection != other_value.union_selection) return FALSE;
switch (union_selection) {
case ALT_pdn__gw__update:
return *field_pdn__gw__update == *other_value.field_pdn__gw__update;
case ALT_isr__Information:
return *field_isr__Information == *other_value.field_isr__Information;
default:
return FALSE;
}
}

PDN__GW__Update& EPS__Info::pdn__gw__update()
{
if (union_selection != ALT_pdn__gw__update) {
clean_up();
field_pdn__gw__update = new PDN__GW__Update;
union_selection = ALT_pdn__gw__update;
}
return *field_pdn__gw__update;
}

const PDN__GW__Update& EPS__Info::pdn__gw__update() const
{
if (union_selection != ALT_pdn__gw__update) TTCN_error("Using non-selected field pdn_gw_update in a value of union type @MAP-MS-DataTypes.EPS-Info.");
return *field_pdn__gw__update;
}

BITSTRING& EPS__Info::isr__Information()
{
if (union_selection != ALT_isr__Information) {
clean_up();
field_isr__Information = new BITSTRING;
union_selection = ALT_isr__Information;
}
return *field_isr__Information;
}

const BITSTRING& EPS__Info::isr__Information() const
{
if (union_selection != ALT_isr__Information) TTCN_error("Using non-selected field isr_Information in a value of union type @MAP-MS-DataTypes.EPS-Info.");
return *field_isr__Information;
}

boolean EPS__Info::ischosen(union_selection_type checked_selection) const
{
if (checked_selection == UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @MAP-MS-DataTypes.EPS-Info.");
return union_selection == checked_selection;
}

boolean EPS__Info::is_bound() const
{
  return union_selection != UNBOUND_VALUE;
}

boolean EPS__Info::is_value() const
{
switch (union_selection) {
case UNBOUND_VALUE: return FALSE;
case ALT_pdn__gw__update: return field_pdn__gw__update->is_value();
case ALT_isr__Information: return field_isr__Information->is_value();
default: TTCN_error("Invalid selection in union is_bound");}
}

void EPS__Info::clean_up()
{
switch (union_selection) {
case ALT_pdn__gw__update:
  delete field_pdn__gw__update;
  break;
case ALT_isr__Information:
  delete field_isr__Information;
  break;
default:
  break;
}
union_selection = UNBOUND_VALUE;
}

void EPS__Info::log() const
{
switch (union_selection) {
case ALT_pdn__gw__update:
TTCN_Logger::log_event_str("{ pdn_gw_update := ");
field_pdn__gw__update->log();
TTCN_Logger::log_event_str(" }");
break;
case ALT_isr__Information:
TTCN_Logger::log_event_str("{ isr_Information := ");
field_isr__Information->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_unbound();
}
}

void EPS__Info::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "union value");
  Module_Param_Ptr m_p = &param;
  if (m_p->get_type()==Module_Param::MP_Value_List && m_p->get_size()==0) return;
  if (m_p->get_type()!=Module_Param::MP_Assignment_List) {
    param.error("union value with field name was expected");
  }
  Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
  char* last_name = mp_last->get_id()->get_name();
  if (!strcmp(last_name, "pdn_gw_update")) {
    pdn__gw__update().set_param(*mp_last);
    if (!pdn__gw__update().is_bound()) clean_up();
    return;
  }
  if (!strcmp(last_name, "isr_Information")) {
    isr__Information().set_param(*mp_last);
    if (!isr__Information().is_bound()) clean_up();
    return;
  }
  mp_last->error("Field %s does not exist in type @MAP-MS-DataTypes.EPS-Info.", last_name);
}

void EPS__Info::set_implicit_omit()
{
switch (union_selection) {
case ALT_pdn__gw__update:
field_pdn__gw__update->set_implicit_omit(); break;
case ALT_isr__Information:
field_isr__Information->set_implicit_omit(); break;
default: break;
}
}

void EPS__Info::encode_text(Text_Buf& text_buf) const
{
text_buf.push_int(union_selection);
switch (union_selection) {
case ALT_pdn__gw__update:
field_pdn__gw__update->encode_text(text_buf);
break;
case ALT_isr__Information:
field_isr__Information->encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an unbound value of union type @MAP-MS-DataTypes.EPS-Info.");
}
}

void EPS__Info::decode_text(Text_Buf& text_buf)
{
switch ((union_selection_type)text_buf.pull_int().get_val()) {
case ALT_pdn__gw__update:
pdn__gw__update().decode_text(text_buf);
break;
case ALT_isr__Information:
isr__Information().decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for type @MAP-MS-DataTypes.EPS-Info.");
}
}

void EPS__Info::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void EPS__Info::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t *EPS__Info::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv;
  TTCN_EncDec_ErrorContext ec_0("Alternative '");
  TTCN_EncDec_ErrorContext ec_1;
  switch (union_selection) {
  case ALT_pdn__gw__update:
    ec_1.set_msg("pdn_gw_update': ");
    new_tlv = field_pdn__gw__update->BER_encode_TLV(EPS__Info_pdn__gw__update_descr_, p_coding);
    break;
  case ALT_isr__Information:
    ec_1.set_msg("isr_Information': ");
    new_tlv = field_isr__Information->BER_encode_TLV(EPS__Info_isr__Information_descr_, p_coding);
    break;
  case UNBOUND_VALUE:
    new_tlv = BER_encode_chk_bound(FALSE);
    break;
  default:
    TTCN_EncDec_ErrorContext::error_internal("Unknown selection.");
    new_tlv = NULL;
  }
  return ASN_BER_V2TLV(new_tlv, p_td, p_coding);
}

boolean EPS__Info::BER_decode_set_selection(const ASN_BER_TLV_t& p_tlv)
{
  clean_up();
  field_pdn__gw__update = new PDN__GW__Update;
  union_selection = ALT_pdn__gw__update;
  if (field_pdn__gw__update->BER_decode_isMyMsg(EPS__Info_pdn__gw__update_descr_, p_tlv)) return TRUE;
  delete field_pdn__gw__update;
  field_isr__Information = new BITSTRING;
  union_selection = ALT_isr__Information;
  if (field_isr__Information->BER_decode_isMyMsg(EPS__Info_isr__Information_descr_, p_tlv)) return TRUE;
  delete field_isr__Information;
  union_selection = UNBOUND_VALUE;
  return FALSE;
}

boolean EPS__Info::BER_decode_isMyMsg(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv)
{
  if (p_td.ber->n_tags == 0) {
    EPS__Info tmp_type;
    return tmp_type.BER_decode_set_selection(p_tlv);
  } else return Base_Type::BER_decode_isMyMsg(p_td, p_tlv);
}

boolean EPS__Info::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.EPS-Info' type: ");
  ASN_BER_TLV_t tmp_tlv;
  if (!BER_decode_TLV_CHOICE(*p_td.ber, stripped_tlv, L_form, tmp_tlv) || !BER_decode_CHOICE_selection(BER_decode_set_selection(tmp_tlv), tmp_tlv)) return FALSE;
  TTCN_EncDec_ErrorContext ec_1("Alternative '");
  TTCN_EncDec_ErrorContext ec_2;
  switch (union_selection) {
  case ALT_pdn__gw__update:
    ec_2.set_msg("pdn_gw_update': ");
    field_pdn__gw__update->BER_decode_TLV(EPS__Info_pdn__gw__update_descr_, tmp_tlv, L_form);
    break;
  case ALT_isr__Information:
    ec_2.set_msg("isr_Information': ");
    field_isr__Information->BER_decode_TLV(EPS__Info_isr__Information_descr_, tmp_tlv, L_form);
    break;
  default:
    return FALSE;
  }
  return TRUE;
}

int EPS__Info::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean) const
{
  boolean as_value = p_td.json->as_value;
  int enc_len = as_value ? 0 : p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);
  switch(union_selection) {
  case ALT_pdn__gw__update:
    if (!as_value) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "pdn_gw_update");
    }
    enc_len += field_pdn__gw__update->JSON_encode(EPS__Info_pdn__gw__update_descr_, p_tok, FALSE);
    break;
  case ALT_isr__Information:
    if (!as_value) {
      enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "isr_Information");
    }
    enc_len += field_isr__Information->JSON_encode(EPS__Info_isr__Information_descr_, p_tok, FALSE);
    break;
  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, 
      "Encoding an unbound value of type @MAP-MS-DataTypes.EPS-Info.");
    return -1;
  }

  if (!as_value) {
    enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  }
  return enc_len;
}

int EPS__Info::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean, int p_chosen_field)
{
  if (0 <= p_chosen_field && 2 > p_chosen_field) {
    switch (p_chosen_field) {
    case 0:
      return pdn__gw__update().JSON_decode(EPS__Info_pdn__gw__update_descr_, p_tok, TRUE, FALSE);
    case 1:
      return isr__Information().JSON_decode(EPS__Info_isr__Information_descr_, p_tok, TRUE, FALSE);
    }
  }
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const EPS__Info*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
 if (p_td.json->as_value) {
  size_t buf_pos = p_tok.get_buf_pos();
  p_tok.get_next_token(&j_token, NULL, NULL);
  int ret_val = 0;
  switch(j_token) {
  case JSON_TOKEN_NUMBER: {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "number '@MAP-MS-DataTypes.EPS-Info'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_STRING: {
    p_tok.set_buf_pos(buf_pos);
    ret_val = isr__Information().JSON_decode(EPS__Info_isr__Information_descr_, p_tok, TRUE, FALSE);
    if (0 <= ret_val) {
      return ret_val;
    }
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "string '@MAP-MS-DataTypes.EPS-Info'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_LITERAL_TRUE:
  case JSON_TOKEN_LITERAL_FALSE: {
    char* literal_str = mprintf("literal (%s)",
      (JSON_TOKEN_LITERAL_TRUE == j_token) ? "true" : "false");
    try {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, literal_str);
    }
    catch (const TC_Error&) {
      Free(literal_str);
      throw;
    }
    Free(literal_str);
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_ARRAY_START: {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "array '@MAP-MS-DataTypes.EPS-Info'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_OBJECT_START: {
    p_tok.set_buf_pos(buf_pos);
    ret_val = pdn__gw__update().JSON_decode(EPS__Info_pdn__gw__update_descr_, p_tok, TRUE, FALSE);
    if (0 <= ret_val) {
      return ret_val;
    }
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_AS_VALUE_ERROR, "object '@MAP-MS-DataTypes.EPS-Info'");
    clean_up();
    return JSON_ERROR_FATAL;
  }
  case JSON_TOKEN_LITERAL_NULL: {
    clean_up();
    return JSON_ERROR_INVALID_TOKEN;
  }
  case JSON_TOKEN_ERROR:
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  default:
    return JSON_ERROR_INVALID_TOKEN;
  }
  return ret_val;
 }
 else {
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }

  char* fld_name = 0;
  size_t name_len = 0;
  dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
  if (JSON_TOKEN_NAME != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
    return JSON_ERROR_FATAL;
  } else {
if (13 == name_len && 0 == strncmp(fld_name, "pdn_gw_update", name_len)) {
      int ret_val = pdn__gw__update().JSON_decode(EPS__Info_pdn__gw__update_descr_, p_tok, p_silent, FALSE);
      if (0 > ret_val) {
        if (JSON_ERROR_INVALID_TOKEN == ret_val) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 13, "pdn_gw_update");
        }
        return JSON_ERROR_FATAL;
      } else {
        dec_len += (size_t)ret_val;
      }
    } else if (15 == name_len && 0 == strncmp(fld_name, "isr_Information", name_len)) {
      int ret_val = isr__Information().JSON_decode(EPS__Info_isr__Information_descr_, p_tok, p_silent, FALSE);
      if (0 > ret_val) {
        if (JSON_ERROR_INVALID_TOKEN == ret_val) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 15, "isr_Information");
        }
        return JSON_ERROR_FATAL;
      } else {
        dec_len += (size_t)ret_val;
      }
    } else {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
      return JSON_ERROR_FATAL;
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_STATIC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  return (int)dec_len;
 }
}

int EPS__Info::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  switch(union_selection) {
  case ALT_pdn__gw__update:
    {TTCN_Buffer buf;
    encode_oer_tag(*EPS__Info_pdn__gw__update_descr_.ber, p_buf);
    field_pdn__gw__update->OER_encode(EPS__Info_pdn__gw__update_descr_, buf);
    p_buf.put_buf(buf);
    break;
}  case ALT_isr__Information:
    {TTCN_Buffer buf;
    encode_oer_tag(*EPS__Info_isr__Information_descr_.ber, p_buf);
    field_isr__Information->OER_encode(EPS__Info_isr__Information_descr_, buf);
    p_buf.put_buf(buf);
    break;
}  default:
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, 
      "Encoding an unbound value of type @MAP-MS-DataTypes.EPS-Info.");
    return -1;
  }

  return 0;
}
int EPS__Info::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const ASN_Tag_t& descr = decode_oer_tag(p_buf);
  if (EPS__Info_pdn__gw__update_descr_.ber->tags[EPS__Info_pdn__gw__update_descr_.ber->n_tags-1].tagclass == descr.tagclass &&
      EPS__Info_pdn__gw__update_descr_.ber->tags[EPS__Info_pdn__gw__update_descr_.ber->n_tags-1].tagnumber == descr.tagnumber) {
    pdn__gw__update().OER_decode(EPS__Info_pdn__gw__update_descr_, p_buf, p_oer);
  } else 
  if (EPS__Info_isr__Information_descr_.ber->tags[EPS__Info_isr__Information_descr_.ber->n_tags-1].tagclass == descr.tagclass &&
      EPS__Info_isr__Information_descr_.ber->tags[EPS__Info_isr__Information_descr_.ber->n_tags-1].tagnumber == descr.tagnumber) {
    isr__Information().OER_decode(EPS__Info_isr__Information_descr_, p_buf, p_oer);
  } else 
{
    TTCN_error("Cannot find matching tag for type EPS__Info");
}
  return 0;
}
void EPS__Info::PER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound CHOICE value.");
return;
}
switch (union_selection) {
case ALT_pdn__gw__update: {
INTEGER::PER_encode_int(p_buf, 0, 1);
field_pdn__gw__update->PER_encode(EPS__Info_pdn__gw__update_descr_, p_buf, p_options);
break; }
case ALT_isr__Information: {
INTEGER::PER_encode_int(p_buf, 1, 1);
field_isr__Information->PER_encode(EPS__Info_isr__Information_descr_, p_buf, p_options);
break; }
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Internal error: Invalid CHOICE selection, expected an extension root field.");
break;
}
}

void EPS__Info::PER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
int sel_int;
INTEGER::PER_decode_int(p_buf, 1, FALSE, sel_int);
switch (sel_int) {
case 0:
pdn__gw__update().PER_decode(EPS__Info_pdn__gw__update_descr_, p_buf, p_options);
break;
case 1:
isr__Information().PER_decode(EPS__Info_isr__Information_descr_, p_buf, p_options);
break;
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INVAL_MSG, "Decoded invalid CHOICE selection (%d).", sel_int);
break;
}
}

void EPS__Info_template::copy_value(const EPS__Info& other_value)
{
single_value.union_selection = other_value.get_selection();
switch (single_value.union_selection) {
case EPS__Info::ALT_pdn__gw__update:
single_value.field_pdn__gw__update = new PDN__GW__Update_template(other_value.pdn__gw__update());
break;
case EPS__Info::ALT_isr__Information:
single_value.field_isr__Information = new BITSTRING_template(other_value.isr__Information());
break;
default:
TTCN_error("Initializing a template with an unbound value of type @MAP-MS-DataTypes.EPS-Info.");
}
set_selection(SPECIFIC_VALUE);
}

void EPS__Info_template::copy_template(const EPS__Info_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value.union_selection = other_value.single_value.union_selection;
switch (single_value.union_selection) {
case EPS__Info::ALT_pdn__gw__update:
single_value.field_pdn__gw__update = new PDN__GW__Update_template(*other_value.single_value.field_pdn__gw__update);
break;
case EPS__Info::ALT_isr__Information:
single_value.field_isr__Information = new BITSTRING_template(*other_value.single_value.field_isr__Information);
break;
default:
TTCN_error("Internal error: Invalid union selector in a specific value when copying a template of type @MAP-MS-DataTypes.EPS-Info.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new EPS__Info_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new EPS__Info_template(*other_value.implication_.precondition);
implication_.implied_template = new EPS__Info_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized template of union type @MAP-MS-DataTypes.EPS-Info.");
}
set_selection(other_value);
}

EPS__Info_template::EPS__Info_template()
{
}

EPS__Info_template::EPS__Info_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

EPS__Info_template::EPS__Info_template(const EPS__Info& other_value)
{
copy_value(other_value);
}

EPS__Info_template::EPS__Info_template(const OPTIONAL<EPS__Info>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EPS__Info&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of union type @MAP-MS-DataTypes.EPS-Info from an unbound optional field.");
}
}

EPS__Info_template::EPS__Info_template(EPS__Info_template* p_precondition, EPS__Info_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

EPS__Info_template::EPS__Info_template(Dynamic_Match_Interface<EPS__Info>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<EPS__Info>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

EPS__Info_template::EPS__Info_template(const EPS__Info_template& other_value)
: Base_Template(){
copy_template(other_value);
}

EPS__Info_template::~EPS__Info_template()
{
clean_up();
}

void EPS__Info_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case EPS__Info::ALT_pdn__gw__update:
delete single_value.field_pdn__gw__update;
break;
case EPS__Info::ALT_isr__Information:
delete single_value.field_isr__Information;
default:
break;
}
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

EPS__Info_template& EPS__Info_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

EPS__Info_template& EPS__Info_template::operator=(const EPS__Info& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

EPS__Info_template& EPS__Info_template::operator=(const OPTIONAL<EPS__Info>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const EPS__Info&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of union type @MAP-MS-DataTypes.EPS-Info.");
}
return *this;
}

EPS__Info_template& EPS__Info_template::operator=(const EPS__Info_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean EPS__Info_template::match(const EPS__Info& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
{
EPS__Info::union_selection_type value_selection = other_value.get_selection();
if (value_selection == EPS__Info::UNBOUND_VALUE) return FALSE;
if (value_selection != single_value.union_selection) return FALSE;
switch (value_selection) {
case EPS__Info::ALT_pdn__gw__update:
return single_value.field_pdn__gw__update->match(other_value.pdn__gw__update(), legacy);
case EPS__Info::ALT_isr__Information:
return single_value.field_isr__Information->match(other_value.isr__Information(), legacy);
default:
TTCN_error("Internal error: Invalid selector in a specific value when matching a template of union type @MAP-MS-DataTypes.EPS-Info.");
}
}
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error ("Matching an uninitialized template of union type @MAP-MS-DataTypes.EPS-Info.");
}
return FALSE;
}

boolean EPS__Info_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
switch (single_value.union_selection) {
case EPS__Info::ALT_pdn__gw__update:
return single_value.field_pdn__gw__update->is_value();
case EPS__Info::ALT_isr__Information:
return single_value.field_isr__Information->is_value();
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing is_value operation on a template of union type @MAP-MS-DataTypes.EPS-Info.");
}
}

EPS__Info EPS__Info_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of union type @MAP-MS-DataTypes.EPS-Info.");
EPS__Info ret_val;
switch (single_value.union_selection) {
case EPS__Info::ALT_pdn__gw__update:
ret_val.pdn__gw__update() = single_value.field_pdn__gw__update->valueof();
break;
case EPS__Info::ALT_isr__Information:
ret_val.isr__Information() = single_value.field_isr__Information->valueof();
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing valueof operation on a template of union type @MAP-MS-DataTypes.EPS-Info.");
}
return ret_val;
}

EPS__Info_template& EPS__Info_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Internal error: Accessing a list element of a non-list template of union type @MAP-MS-DataTypes.EPS-Info.");
if (list_index >= value_list.n_values) TTCN_error("Internal error: Index overflow in a value list template of union type @MAP-MS-DataTypes.EPS-Info.");
return value_list.list_value[list_index];
}
void EPS__Info_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST && template_type != CONJUNCTION_MATCH) TTCN_error ("Internal error: Setting an invalid list for a template of union type @MAP-MS-DataTypes.EPS-Info.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new EPS__Info_template[list_length];
}

PDN__GW__Update_template& EPS__Info_template::pdn__gw__update()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != EPS__Info::ALT_pdn__gw__update) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_pdn__gw__update = new PDN__GW__Update_template(ANY_VALUE);
else single_value.field_pdn__gw__update = new PDN__GW__Update_template;
single_value.union_selection = EPS__Info::ALT_pdn__gw__update;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_pdn__gw__update;
}

const PDN__GW__Update_template& EPS__Info_template::pdn__gw__update() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field pdn_gw_update in a non-specific template of union type @MAP-MS-DataTypes.EPS-Info.");
if (single_value.union_selection != EPS__Info::ALT_pdn__gw__update) TTCN_error("Accessing non-selected field pdn_gw_update in a template of union type @MAP-MS-DataTypes.EPS-Info.");
return *single_value.field_pdn__gw__update;
}

BITSTRING_template& EPS__Info_template::isr__Information()
{
if (template_selection != SPECIFIC_VALUE || single_value.union_selection != EPS__Info::ALT_isr__Information) {
template_sel old_selection = template_selection;
clean_up();
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) single_value.field_isr__Information = new BITSTRING_template(ANY_VALUE);
else single_value.field_isr__Information = new BITSTRING_template;
single_value.union_selection = EPS__Info::ALT_isr__Information;
set_selection(SPECIFIC_VALUE);
}
return *single_value.field_isr__Information;
}

const BITSTRING_template& EPS__Info_template::isr__Information() const
{
if (template_selection != SPECIFIC_VALUE) TTCN_error("Accessing field isr_Information in a non-specific template of union type @MAP-MS-DataTypes.EPS-Info.");
if (single_value.union_selection != EPS__Info::ALT_isr__Information) TTCN_error("Accessing non-selected field isr_Information in a template of union type @MAP-MS-DataTypes.EPS-Info.");
return *single_value.field_isr__Information;
}

boolean EPS__Info_template::ischosen(EPS__Info::union_selection_type checked_selection) const
{
if (checked_selection == EPS__Info::UNBOUND_VALUE) TTCN_error("Internal error: Performing ischosen() operation on an invalid field of union type @MAP-MS-DataTypes.EPS-Info.");
switch (template_selection) {
case SPECIFIC_VALUE:
if (single_value.union_selection == EPS__Info::UNBOUND_VALUE) TTCN_error("Internal error: Invalid selector in a specific value when performing ischosen() operation on a template of union type @MAP-MS-DataTypes.EPS-Info.");
return single_value.union_selection == checked_selection;
case VALUE_LIST:
{
if (value_list.n_values < 1)
TTCN_error("Internal error: Performing ischosen() operation on a template of union type @MAP-MS-DataTypes.EPS-Info containing an empty list.");
boolean ret_val = value_list.list_value[0].ischosen(checked_selection);
for (unsigned int list_count = 1; ret_val == TRUE && list_count < value_list.n_values; list_count++) {
ret_val = value_list.list_value[list_count].ischosen(checked_selection);
}
return ret_val;
}
default:
return FALSE;
}
return FALSE;
}

void EPS__Info_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
switch (single_value.union_selection) {
case EPS__Info::ALT_pdn__gw__update:
TTCN_Logger::log_event_str("{ pdn_gw_update := ");
single_value.field_pdn__gw__update->log();
TTCN_Logger::log_event_str(" }");
break;
case EPS__Info::ALT_isr__Information:
TTCN_Logger::log_event_str("{ isr_Information := ");
single_value.field_isr__Information->log();
TTCN_Logger::log_event_str(" }");
break;
default:
TTCN_Logger::log_event_str("<invalid selector>");
}
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void EPS__Info_template::log_match(const EPS__Info& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity() && match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
return;
}
if (template_selection == SPECIFIC_VALUE && single_value.union_selection == match_value.get_selection()) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
switch (single_value.union_selection) {
case EPS__Info::ALT_pdn__gw__update:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".pdn_gw_update");
single_value.field_pdn__gw__update->log_match(match_value.pdn__gw__update(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ pdn_gw_update := ");
single_value.field_pdn__gw__update->log_match(match_value.pdn__gw__update(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
case EPS__Info::ALT_isr__Information:
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
TTCN_Logger::log_logmatch_info(".isr_Information");
single_value.field_isr__Information->log_match(match_value.isr__Information(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
} else {
TTCN_Logger::log_event_str("{ isr_Information := ");
single_value.field_isr__Information->log_match(match_value.isr__Information(), legacy);
TTCN_Logger::log_event_str(" }");
}
break;
default:
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str("<invalid selector>");
}
} else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void EPS__Info_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
switch (single_value.union_selection) {
case EPS__Info::ALT_pdn__gw__update:
single_value.field_pdn__gw__update->set_implicit_omit(); break;
case EPS__Info::ALT_isr__Information:
single_value.field_isr__Information->set_implicit_omit(); break;
default: break;
}
}

void EPS__Info_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value.union_selection);
switch (single_value.union_selection) {
case EPS__Info::ALT_pdn__gw__update:
single_value.field_pdn__gw__update->encode_text(text_buf);
break;
case EPS__Info::ALT_isr__Information:
single_value.field_isr__Information->encode_text(text_buf);
break;
default:
TTCN_error("Internal error: Invalid selector in a specific value when encoding a template of union type @MAP-MS-DataTypes.EPS-Info.");
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized template of type @MAP-MS-DataTypes.EPS-Info.");
}
}

void EPS__Info_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
{
single_value.union_selection = EPS__Info::UNBOUND_VALUE;
EPS__Info::union_selection_type new_selection = (EPS__Info::union_selection_type)text_buf.pull_int().get_val();
switch (new_selection) {
case EPS__Info::ALT_pdn__gw__update:
single_value.field_pdn__gw__update = new PDN__GW__Update_template;
single_value.field_pdn__gw__update->decode_text(text_buf);
break;
case EPS__Info::ALT_isr__Information:
single_value.field_isr__Information = new BITSTRING_template;
single_value.field_isr__Information->decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized union selector was received for a template of type @MAP-MS-DataTypes.EPS-Info.");
}
single_value.union_selection = new_selection;
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new EPS__Info_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: Unrecognized selector was received in a template of type @MAP-MS-DataTypes.EPS-Info.");
}
}

boolean EPS__Info_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean EPS__Info_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int v_idx=0; v_idx<value_list.n_values; v_idx++)
if (value_list.list_value[v_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void EPS__Info_template::set_param(Module_Param& param)
{
  if (dynamic_cast<Module_Param_Name*>(param.get_id()) != NULL &&
      param.get_id()->next_name()) {
    char* param_field = param.get_id()->get_current_name();
    if (param_field[0] >= '0' && param_field[0] <= '9') {
      param.error("Unexpected array index in module parameter, expected a valid field"
        " name for union template type `@MAP-MS-DataTypes.EPS-Info'");
    }
    if (strcmp("pdn_gw_update", param_field) == 0) {
      pdn__gw__update().set_param(param);
      return;
    } else if (strcmp("isr_Information", param_field) == 0) {
      isr__Information().set_param(param);
      return;
    } else param.error("Field `%s' not found in union template type `@MAP-MS-DataTypes.EPS-Info'", param_field);
  }
  param.basic_check(Module_Param::BC_TEMPLATE, "union template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    EPS__Info_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (m_p->get_size()==0) break;
    param.type_error("union template", "@MAP-MS-DataTypes.EPS-Info");
    break;
  case Module_Param::MP_Assignment_List: {
    Module_Param* mp_last = m_p->get_elem(m_p->get_size()-1);
    char* last_name = mp_last->get_id()->get_name();
    if (!strcmp(last_name, "pdn_gw_update")) {
      pdn__gw__update().set_param(*mp_last);
      break;
    }
    if (!strcmp(last_name, "isr_Information")) {
      isr__Information().set_param(*mp_last);
      break;
    }
    mp_last->error("Field %s does not exist in type @MAP-MS-DataTypes.EPS-Info.", last_name);
  } break;
  case Module_Param::MP_Implication_Template: {
    EPS__Info_template* precondition = new EPS__Info_template;
    precondition->set_param(*m_p->get_elem(0));
    EPS__Info_template* implied_template = new EPS__Info_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = EPS__Info_template(precondition, implied_template);
  } break;
  default:
    param.type_error("union template", "@MAP-MS-DataTypes.EPS-Info");
  }
  is_ifpresent = param.get_ifpresent();
}

void EPS__Info_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
switch (single_value.union_selection) {
case EPS__Info::ALT_pdn__gw__update:
single_value.field_pdn__gw__update->check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.EPS-Info");
return;
case EPS__Info::ALT_isr__Information:
single_value.field_isr__Information->check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.EPS-Info");
return;
default:
TTCN_error("Internal error: Invalid selector in a specific value when performing check_restriction operation on a template of union type @MAP-MS-DataTypes.EPS-Info.");
}
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.EPS-Info");
}

PDN__GW__Update::PDN__GW__Update()
{
}

PDN__GW__Update::PDN__GW__Update(const OPTIONAL< OCTETSTRING >& par_apn,
    const OPTIONAL< PDN__GW__Identity >& par_pdn__gw__Identity,
    const OPTIONAL< INTEGER >& par_contextId,
    const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer)
  :   field_apn(par_apn),
  field_pdn__gw__Identity(par_pdn__gw__Identity),
  field_contextId(par_contextId),
  field_extensionContainer(par_extensionContainer)
{
}

PDN__GW__Update::PDN__GW__Update(const PDN__GW__Update& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.PDN-GW-Update.");
if (other_value.apn().is_bound()) field_apn = other_value.apn();
else field_apn.clean_up();
if (other_value.pdn__gw__Identity().is_bound()) field_pdn__gw__Identity = other_value.pdn__gw__Identity();
else field_pdn__gw__Identity.clean_up();
if (other_value.contextId().is_bound()) field_contextId = other_value.contextId();
else field_contextId.clean_up();
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
}

void PDN__GW__Update::clean_up()
{
field_apn.clean_up();
field_pdn__gw__Identity.clean_up();
field_contextId.clean_up();
field_extensionContainer.clean_up();
}

const TTCN_Typedescriptor_t* PDN__GW__Update::get_descriptor() const { return &PDN__GW__Update_descr_; }
PDN__GW__Update& PDN__GW__Update::operator=(const PDN__GW__Update& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.PDN-GW-Update.");
  if (other_value.apn().is_bound()) field_apn = other_value.apn();
  else field_apn.clean_up();
  if (other_value.pdn__gw__Identity().is_bound()) field_pdn__gw__Identity = other_value.pdn__gw__Identity();
  else field_pdn__gw__Identity.clean_up();
  if (other_value.contextId().is_bound()) field_contextId = other_value.contextId();
  else field_contextId.clean_up();
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
}
return *this;
}

boolean PDN__GW__Update::operator==(const PDN__GW__Update& other_value) const
{
return field_apn==other_value.field_apn
  && field_pdn__gw__Identity==other_value.field_pdn__gw__Identity
  && field_contextId==other_value.field_contextId
  && field_extensionContainer==other_value.field_extensionContainer;
}

boolean PDN__GW__Update::is_bound() const
{
return (OPTIONAL_OMIT == field_apn.get_selection() || field_apn.is_bound())
  || (OPTIONAL_OMIT == field_pdn__gw__Identity.get_selection() || field_pdn__gw__Identity.is_bound())
  || (OPTIONAL_OMIT == field_contextId.get_selection() || field_contextId.is_bound())
  || (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound());
}
boolean PDN__GW__Update::is_value() const
{
return (OPTIONAL_OMIT == field_apn.get_selection() || field_apn.is_value())
  && (OPTIONAL_OMIT == field_pdn__gw__Identity.get_selection() || field_pdn__gw__Identity.is_value())
  && (OPTIONAL_OMIT == field_contextId.get_selection() || field_contextId.is_value())
  && (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value());
}
int PDN__GW__Update::size_of() const
{
  int ret_val = 0;
  if (field_apn.ispresent()) ret_val++;
  if (field_pdn__gw__Identity.ispresent()) ret_val++;
  if (field_contextId.ispresent()) ret_val++;
  if (field_extensionContainer.ispresent()) ret_val++;
  return ret_val;
}

void PDN__GW__Update::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ apn := ");
field_apn.log();
TTCN_Logger::log_event_str(", pdn_gw_Identity := ");
field_pdn__gw__Identity.log();
TTCN_Logger::log_event_str(", contextId := ");
field_contextId.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
}

void PDN__GW__Update::set_implicit_omit()
{
if (!apn().is_bound()) apn() = OMIT_VALUE;
else apn().set_implicit_omit();
if (!pdn__gw__Identity().is_bound()) pdn__gw__Identity() = OMIT_VALUE;
else pdn__gw__Identity().set_implicit_omit();
if (!contextId().is_bound()) contextId() = OMIT_VALUE;
else contextId().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void PDN__GW__Update::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.PDN-GW-Update has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) apn().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) pdn__gw__Identity().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) contextId().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "apn")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          apn().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdn_gw_Identity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdn__gw__Identity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "contextId")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          contextId().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.PDN-GW-Update: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.PDN-GW-Update");
  }
}

void PDN__GW__Update::encode_text(Text_Buf& text_buf) const
{
field_apn.encode_text(text_buf);
field_pdn__gw__Identity.encode_text(text_buf);
field_contextId.encode_text(text_buf);
field_extensionContainer.encode_text(text_buf);
}

void PDN__GW__Update::decode_text(Text_Buf& text_buf)
{
field_apn.decode_text(text_buf);
field_pdn__gw__Identity.decode_text(text_buf);
field_contextId.decode_text(text_buf);
field_extensionContainer.decode_text(text_buf);
}

void PDN__GW__Update::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDN__GW__Update::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* PDN__GW__Update::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("apn': ");
  new_tlv->add_TLV(field_apn.BER_encode_TLV(PDN__GW__Update_apn_descr_, p_coding));
  ec_1.set_msg("pdn_gw_Identity': ");
  new_tlv->add_TLV(field_pdn__gw__Identity.BER_encode_TLV(PDN__GW__Update_pdn__gw__Identity_descr_, p_coding));
  ec_1.set_msg("contextId': ");
  new_tlv->add_TLV(field_contextId.BER_encode_TLV(PDN__GW__Update_contextId_descr_, p_coding));
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(PDN__GW__Update_extensionContainer_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean PDN__GW__Update::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.PDN-GW-Update' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("apn': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_apn=OMIT_VALUE;
    else {
      field_apn.BER_decode_TLV(PDN__GW__Update_apn_descr_, tmp_tlv, L_form);
      if(field_apn.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("pdn_gw_Identity': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_pdn__gw__Identity=OMIT_VALUE;
    else {
      field_pdn__gw__Identity.BER_decode_TLV(PDN__GW__Update_pdn__gw__Identity_descr_, tmp_tlv, L_form);
      if(field_pdn__gw__Identity.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("contextId': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_contextId=OMIT_VALUE;
    else {
      field_contextId.BER_decode_TLV(PDN__GW__Update_contextId_descr_, tmp_tlv, L_form);
      if(field_contextId.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(PDN__GW__Update_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int PDN__GW__Update::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.PDN-GW-Update.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  if (field_apn.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "apn");
    enc_len += field_apn.JSON_encode(PDN__GW__Update_apn_descr_, p_tok, FALSE);
  }

  if (field_pdn__gw__Identity.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "pdn_gw_Identity");
    enc_len += field_pdn__gw__Identity.JSON_encode(PDN__GW__Update_pdn__gw__Identity_descr_, p_tok, FALSE);
  }

  if (field_contextId.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "contextId");
    enc_len += field_contextId.JSON_encode(PDN__GW__Update_contextId_descr_, p_tok, FALSE);
  }

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(PDN__GW__Update_extensionContainer_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int PDN__GW__Update::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const PDN__GW__Update*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean apn_found = FALSE;
  boolean pdn__gw__Identity_found = FALSE;
  boolean contextId_found = FALSE;
  boolean extensionContainer_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (3 == name_len && 0 == strncmp(fld_name, "apn", name_len)) {
        apn_found = TRUE;
         int ret_val = field_apn.JSON_decode(PDN__GW__Update_apn_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 3, "apn");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (15 == name_len && 0 == strncmp(fld_name, "pdn_gw_Identity", name_len)) {
        pdn__gw__Identity_found = TRUE;
         int ret_val = field_pdn__gw__Identity.JSON_decode(PDN__GW__Update_pdn__gw__Identity_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 15, "pdn_gw_Identity");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (9 == name_len && 0 == strncmp(fld_name, "contextId", name_len)) {
        contextId_found = TRUE;
         int ret_val = field_contextId.JSON_decode(PDN__GW__Update_contextId_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 9, "contextId");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(PDN__GW__Update_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!apn_found) {
    field_apn = OMIT_VALUE;
  }
  if (!pdn__gw__Identity_found) {
    field_pdn__gw__Identity = OMIT_VALUE;
  }
  if (!contextId_found) {
    field_contextId = OMIT_VALUE;
  }
  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int PDN__GW__Update::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_apn.is_present()) {
    c |= 64;
  }
  if (field_pdn__gw__Identity.is_present()) {
    c |= 32;
  }
  if (field_contextId.is_present()) {
    c |= 16;
  }
  if (field_extensionContainer.is_present()) {
    c |= 8;
  }
  p_buf.put_c(c);
  if (field_apn.is_present())
    field_apn.OER_encode(PDN__GW__Update_apn_descr_, p_buf);
  if (field_pdn__gw__Identity.is_present())
    field_pdn__gw__Identity.OER_encode(PDN__GW__Update_pdn__gw__Identity_descr_, p_buf);
  if (field_contextId.is_present())
    field_contextId.OER_encode(PDN__GW__Update_contextId_descr_, p_buf);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(PDN__GW__Update_extensionContainer_descr_, p_buf);
  return 0;
}

int PDN__GW__Update::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  if (uc[0] & 64)
    field_apn.OER_decode(PDN__GW__Update_apn_descr_, p_buf, p_oer);
 else
    field_apn = OMIT_VALUE;
  if (uc[0] & 32)
    field_pdn__gw__Identity.OER_decode(PDN__GW__Update_pdn__gw__Identity_descr_, p_buf, p_oer);
 else
    field_pdn__gw__Identity = OMIT_VALUE;
  if (uc[0] & 16)
    field_contextId.OER_decode(PDN__GW__Update_contextId_descr_, p_buf, p_oer);
 else
    field_contextId = OMIT_VALUE;
  if (uc[0] & 8)
    field_extensionContainer.OER_decode(PDN__GW__Update_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void PDN__GW__Update::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
boolean field_apn_present = field_apn.is_present();
p_buf.PER_put_bit(field_apn_present);
boolean field_pdn__gw__Identity_present = field_pdn__gw__Identity.is_present();
p_buf.PER_put_bit(field_pdn__gw__Identity_present);
boolean field_contextId_present = field_contextId.is_present();
p_buf.PER_put_bit(field_contextId_present);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
if (field_apn_present) field_apn.PER_encode(PDN__GW__Update_apn_descr_, p_buf, p_options);
if (field_pdn__gw__Identity_present) field_pdn__gw__Identity.PER_encode(PDN__GW__Update_pdn__gw__Identity_descr_, p_buf, p_options);
if (field_contextId_present) field_contextId.PER_encode(PDN__GW__Update_contextId_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(PDN__GW__Update_extensionContainer_descr_, p_buf, p_options);
}

void PDN__GW__Update::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_apn_present = p_buf.PER_get_bit();
boolean field_pdn__gw__Identity_present = p_buf.PER_get_bit();
boolean field_contextId_present = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
if (field_apn_present) field_apn.PER_decode(PDN__GW__Update_apn_descr_, p_buf, p_options);
else field_apn = OMIT_VALUE;
if (field_pdn__gw__Identity_present) field_pdn__gw__Identity.PER_decode(PDN__GW__Update_pdn__gw__Identity_descr_, p_buf, p_options);
else field_pdn__gw__Identity = OMIT_VALUE;
if (field_contextId_present) field_contextId.PER_decode(PDN__GW__Update_contextId_descr_, p_buf, p_options);
else field_contextId = OMIT_VALUE;
if (field_extensionContainer_present) field_extensionContainer.PER_decode(PDN__GW__Update_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct PDN__GW__Update_template::single_value_struct {
OCTETSTRING_template field_apn;
PDN__GW__Identity_template field_pdn__gw__Identity;
INTEGER_template field_contextId;
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
};

void PDN__GW__Update_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_apn = ANY_OR_OMIT;
single_value->field_pdn__gw__Identity = ANY_OR_OMIT;
single_value->field_contextId = ANY_OR_OMIT;
single_value->field_extensionContainer = ANY_OR_OMIT;
}
}
}

void PDN__GW__Update_template::copy_value(const PDN__GW__Update& other_value)
{
single_value = new single_value_struct;
if (other_value.apn().is_bound()) {
  if (other_value.apn().ispresent()) single_value->field_apn = other_value.apn()();
  else single_value->field_apn = OMIT_VALUE;
} else {
  single_value->field_apn.clean_up();
}
if (other_value.pdn__gw__Identity().is_bound()) {
  if (other_value.pdn__gw__Identity().ispresent()) single_value->field_pdn__gw__Identity = other_value.pdn__gw__Identity()();
  else single_value->field_pdn__gw__Identity = OMIT_VALUE;
} else {
  single_value->field_pdn__gw__Identity.clean_up();
}
if (other_value.contextId().is_bound()) {
  if (other_value.contextId().ispresent()) single_value->field_contextId = other_value.contextId()();
  else single_value->field_contextId = OMIT_VALUE;
} else {
  single_value->field_contextId.clean_up();
}
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDN__GW__Update_template::copy_template(const PDN__GW__Update_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.apn().get_selection()) {
single_value->field_apn = other_value.apn();
} else {
single_value->field_apn.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pdn__gw__Identity().get_selection()) {
single_value->field_pdn__gw__Identity = other_value.pdn__gw__Identity();
} else {
single_value->field_pdn__gw__Identity.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.contextId().get_selection()) {
single_value->field_contextId = other_value.contextId();
} else {
single_value->field_contextId.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDN__GW__Update_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDN__GW__Update_template(*other_value.implication_.precondition);
implication_.implied_template = new PDN__GW__Update_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.PDN-GW-Update.");
break;
}
set_selection(other_value);
}

PDN__GW__Update_template::PDN__GW__Update_template()
{
}

PDN__GW__Update_template::PDN__GW__Update_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDN__GW__Update_template::PDN__GW__Update_template(const PDN__GW__Update& other_value)
{
copy_value(other_value);
}

PDN__GW__Update_template::PDN__GW__Update_template(const OPTIONAL<PDN__GW__Update>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDN__GW__Update&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.PDN-GW-Update from an unbound optional field.");
}
}

PDN__GW__Update_template::PDN__GW__Update_template(PDN__GW__Update_template* p_precondition, PDN__GW__Update_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDN__GW__Update_template::PDN__GW__Update_template(Dynamic_Match_Interface<PDN__GW__Update>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDN__GW__Update>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDN__GW__Update_template::PDN__GW__Update_template(const PDN__GW__Update_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDN__GW__Update_template::~PDN__GW__Update_template()
{
clean_up();
}

PDN__GW__Update_template& PDN__GW__Update_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDN__GW__Update_template& PDN__GW__Update_template::operator=(const PDN__GW__Update& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDN__GW__Update_template& PDN__GW__Update_template::operator=(const OPTIONAL<PDN__GW__Update>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDN__GW__Update&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.PDN-GW-Update.");
}
return *this;
}

PDN__GW__Update_template& PDN__GW__Update_template::operator=(const PDN__GW__Update_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDN__GW__Update_template::match(const PDN__GW__Update& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.apn().is_bound()) return FALSE;
if((other_value.apn().ispresent() ? !single_value->field_apn.match((const OCTETSTRING&)other_value.apn(), legacy) : !single_value->field_apn.match_omit(legacy)))return FALSE;
if(!other_value.pdn__gw__Identity().is_bound()) return FALSE;
if((other_value.pdn__gw__Identity().ispresent() ? !single_value->field_pdn__gw__Identity.match((const PDN__GW__Identity&)other_value.pdn__gw__Identity(), legacy) : !single_value->field_pdn__gw__Identity.match_omit(legacy)))return FALSE;
if(!other_value.contextId().is_bound()) return FALSE;
if((other_value.contextId().ispresent() ? !single_value->field_contextId.match((const INTEGER&)other_value.contextId(), legacy) : !single_value->field_contextId.match_omit(legacy)))return FALSE;
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.PDN-GW-Update.");
}
return FALSE;
}

boolean PDN__GW__Update_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_apn.is_omit() || single_value->field_apn.is_bound())
 || (single_value->field_pdn__gw__Identity.is_omit() || single_value->field_pdn__gw__Identity.is_bound())
 || (single_value->field_contextId.is_omit() || single_value->field_contextId.is_bound())
 || (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound());
}

boolean PDN__GW__Update_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_apn.is_omit() || single_value->field_apn.is_value())
 && (single_value->field_pdn__gw__Identity.is_omit() || single_value->field_pdn__gw__Identity.is_value())
 && (single_value->field_contextId.is_omit() || single_value->field_contextId.is_value())
 && (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value());
}

void PDN__GW__Update_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDN__GW__Update PDN__GW__Update_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.PDN-GW-Update.");
PDN__GW__Update ret_val;
if (single_value->field_apn.is_omit()) ret_val.apn() = OMIT_VALUE;
else if (single_value->field_apn.is_bound()) {
ret_val.apn() = single_value->field_apn.valueof();
}
if (single_value->field_pdn__gw__Identity.is_omit()) ret_val.pdn__gw__Identity() = OMIT_VALUE;
else if (single_value->field_pdn__gw__Identity.is_bound()) {
ret_val.pdn__gw__Identity() = single_value->field_pdn__gw__Identity.valueof();
}
if (single_value->field_contextId.is_omit()) ret_val.contextId() = OMIT_VALUE;
else if (single_value->field_contextId.is_bound()) {
ret_val.contextId() = single_value->field_contextId.valueof();
}
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
return ret_val;
}

void PDN__GW__Update_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.PDN-GW-Update.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDN__GW__Update_template[list_length];
}

PDN__GW__Update_template& PDN__GW__Update_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.PDN-GW-Update.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.PDN-GW-Update.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDN__GW__Update_template::apn()
{
set_specific();
return single_value->field_apn;
}

const OCTETSTRING_template& PDN__GW__Update_template::apn() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field apn of a non-specific template of type @MAP-MS-DataTypes.PDN-GW-Update.");
return single_value->field_apn;
}

PDN__GW__Identity_template& PDN__GW__Update_template::pdn__gw__Identity()
{
set_specific();
return single_value->field_pdn__gw__Identity;
}

const PDN__GW__Identity_template& PDN__GW__Update_template::pdn__gw__Identity() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pdn_gw_Identity of a non-specific template of type @MAP-MS-DataTypes.PDN-GW-Update.");
return single_value->field_pdn__gw__Identity;
}

INTEGER_template& PDN__GW__Update_template::contextId()
{
set_specific();
return single_value->field_contextId;
}

const INTEGER_template& PDN__GW__Update_template::contextId() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field contextId of a non-specific template of type @MAP-MS-DataTypes.PDN-GW-Update.");
return single_value->field_contextId;
}

MAP__ExtensionDataTypes::ExtensionContainer_template& PDN__GW__Update_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& PDN__GW__Update_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-MS-DataTypes.PDN-GW-Update.");
return single_value->field_extensionContainer;
}

int PDN__GW__Update_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.PDN-GW-Update which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 0;
      if (single_value->field_apn.is_present()) ret_val++;
      if (single_value->field_pdn__gw__Identity.is_present()) ret_val++;
      if (single_value->field_contextId.is_present()) ret_val++;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.PDN-GW-Update containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.PDN-GW-Update containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.PDN-GW-Update containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.PDN-GW-Update containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.PDN-GW-Update containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.PDN-GW-Update containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.PDN-GW-Update containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.PDN-GW-Update containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.PDN-GW-Update.");
  }
  return 0;
}

void PDN__GW__Update_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ apn := ");
single_value->field_apn.log();
TTCN_Logger::log_event_str(", pdn_gw_Identity := ");
single_value->field_pdn__gw__Identity.log();
TTCN_Logger::log_event_str(", contextId := ");
single_value->field_contextId.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDN__GW__Update_template::log_match(const PDN__GW__Update& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.apn().ispresent()){
if(!single_value->field_apn.match(match_value.apn(), legacy)){
TTCN_Logger::log_logmatch_info(".apn");
single_value->field_apn.log_match(match_value.apn(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_apn.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".apn := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_apn.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.pdn__gw__Identity().ispresent()){
if(!single_value->field_pdn__gw__Identity.match(match_value.pdn__gw__Identity(), legacy)){
TTCN_Logger::log_logmatch_info(".pdn_gw_Identity");
single_value->field_pdn__gw__Identity.log_match(match_value.pdn__gw__Identity(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_pdn__gw__Identity.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".pdn_gw_Identity := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_pdn__gw__Identity.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.contextId().ispresent()){
if(!single_value->field_contextId.match(match_value.contextId(), legacy)){
TTCN_Logger::log_logmatch_info(".contextId");
single_value->field_contextId.log_match(match_value.contextId(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_contextId.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".contextId := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_contextId.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ apn := ");
if (match_value.apn().ispresent()) {
single_value->field_apn.log_match(match_value.apn(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_apn.log();
if (single_value->field_apn.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", pdn_gw_Identity := ");
if (match_value.pdn__gw__Identity().ispresent()) {
single_value->field_pdn__gw__Identity.log_match(match_value.pdn__gw__Identity(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_pdn__gw__Identity.log();
if (single_value->field_pdn__gw__Identity.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", contextId := ");
if (match_value.contextId().ispresent()) {
single_value->field_contextId.log_match(match_value.contextId(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_contextId.log();
if (single_value->field_contextId.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDN__GW__Update_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!apn().is_bound()) apn() = OMIT_VALUE;
else apn().set_implicit_omit();
if (!pdn__gw__Identity().is_bound()) pdn__gw__Identity() = OMIT_VALUE;
else pdn__gw__Identity().set_implicit_omit();
if (!contextId().is_bound()) contextId() = OMIT_VALUE;
else contextId().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void PDN__GW__Update_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_apn.encode_text(text_buf);
single_value->field_pdn__gw__Identity.encode_text(text_buf);
single_value->field_contextId.encode_text(text_buf);
single_value->field_extensionContainer.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.PDN-GW-Update.");
}
}

void PDN__GW__Update_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_apn.decode_text(text_buf);
single_value->field_pdn__gw__Identity.decode_text(text_buf);
single_value->field_contextId.decode_text(text_buf);
single_value->field_extensionContainer.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDN__GW__Update_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.PDN-GW-Update.");
}
}

void PDN__GW__Update_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDN__GW__Update_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.PDN-GW-Update has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) apn().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) pdn__gw__Identity().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) contextId().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "apn")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          apn().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdn_gw_Identity")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdn__gw__Identity().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "contextId")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          contextId().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.PDN-GW-Update: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDN__GW__Update_template* precondition = new PDN__GW__Update_template;
    precondition->set_param(*param.get_elem(0));
    PDN__GW__Update_template* implied_template = new PDN__GW__Update_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDN__GW__Update_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.PDN-GW-Update");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDN__GW__Update_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_apn.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.PDN-GW-Update");
single_value->field_pdn__gw__Identity.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.PDN-GW-Update");
single_value->field_contextId.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.PDN-GW-Update");
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.PDN-GW-Update");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.PDN-GW-Update");
}

boolean PDN__GW__Update_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDN__GW__Update_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

PDN__GW__Identity::PDN__GW__Identity()
{
}

PDN__GW__Identity::PDN__GW__Identity(const OPTIONAL< OCTETSTRING >& par_pdn__gw__ipv4__Address,
    const OPTIONAL< OCTETSTRING >& par_pdn__gw__ipv6__Address,
    const OPTIONAL< OCTETSTRING >& par_pdn__gw__name,
    const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer)
  :   field_pdn__gw__ipv4__Address(par_pdn__gw__ipv4__Address),
  field_pdn__gw__ipv6__Address(par_pdn__gw__ipv6__Address),
  field_pdn__gw__name(par_pdn__gw__name),
  field_extensionContainer(par_extensionContainer)
{
}

PDN__GW__Identity::PDN__GW__Identity(const PDN__GW__Identity& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.PDN-GW-Identity.");
if (other_value.pdn__gw__ipv4__Address().is_bound()) field_pdn__gw__ipv4__Address = other_value.pdn__gw__ipv4__Address();
else field_pdn__gw__ipv4__Address.clean_up();
if (other_value.pdn__gw__ipv6__Address().is_bound()) field_pdn__gw__ipv6__Address = other_value.pdn__gw__ipv6__Address();
else field_pdn__gw__ipv6__Address.clean_up();
if (other_value.pdn__gw__name().is_bound()) field_pdn__gw__name = other_value.pdn__gw__name();
else field_pdn__gw__name.clean_up();
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
}

void PDN__GW__Identity::clean_up()
{
field_pdn__gw__ipv4__Address.clean_up();
field_pdn__gw__ipv6__Address.clean_up();
field_pdn__gw__name.clean_up();
field_extensionContainer.clean_up();
}

const TTCN_Typedescriptor_t* PDN__GW__Identity::get_descriptor() const { return &PDN__GW__Identity_descr_; }
PDN__GW__Identity& PDN__GW__Identity::operator=(const PDN__GW__Identity& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.PDN-GW-Identity.");
  if (other_value.pdn__gw__ipv4__Address().is_bound()) field_pdn__gw__ipv4__Address = other_value.pdn__gw__ipv4__Address();
  else field_pdn__gw__ipv4__Address.clean_up();
  if (other_value.pdn__gw__ipv6__Address().is_bound()) field_pdn__gw__ipv6__Address = other_value.pdn__gw__ipv6__Address();
  else field_pdn__gw__ipv6__Address.clean_up();
  if (other_value.pdn__gw__name().is_bound()) field_pdn__gw__name = other_value.pdn__gw__name();
  else field_pdn__gw__name.clean_up();
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
}
return *this;
}

boolean PDN__GW__Identity::operator==(const PDN__GW__Identity& other_value) const
{
return field_pdn__gw__ipv4__Address==other_value.field_pdn__gw__ipv4__Address
  && field_pdn__gw__ipv6__Address==other_value.field_pdn__gw__ipv6__Address
  && field_pdn__gw__name==other_value.field_pdn__gw__name
  && field_extensionContainer==other_value.field_extensionContainer;
}

boolean PDN__GW__Identity::is_bound() const
{
return (OPTIONAL_OMIT == field_pdn__gw__ipv4__Address.get_selection() || field_pdn__gw__ipv4__Address.is_bound())
  || (OPTIONAL_OMIT == field_pdn__gw__ipv6__Address.get_selection() || field_pdn__gw__ipv6__Address.is_bound())
  || (OPTIONAL_OMIT == field_pdn__gw__name.get_selection() || field_pdn__gw__name.is_bound())
  || (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound());
}
boolean PDN__GW__Identity::is_value() const
{
return (OPTIONAL_OMIT == field_pdn__gw__ipv4__Address.get_selection() || field_pdn__gw__ipv4__Address.is_value())
  && (OPTIONAL_OMIT == field_pdn__gw__ipv6__Address.get_selection() || field_pdn__gw__ipv6__Address.is_value())
  && (OPTIONAL_OMIT == field_pdn__gw__name.get_selection() || field_pdn__gw__name.is_value())
  && (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value());
}
int PDN__GW__Identity::size_of() const
{
  int ret_val = 0;
  if (field_pdn__gw__ipv4__Address.ispresent()) ret_val++;
  if (field_pdn__gw__ipv6__Address.ispresent()) ret_val++;
  if (field_pdn__gw__name.ispresent()) ret_val++;
  if (field_extensionContainer.ispresent()) ret_val++;
  return ret_val;
}

void PDN__GW__Identity::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ pdn_gw_ipv4_Address := ");
field_pdn__gw__ipv4__Address.log();
TTCN_Logger::log_event_str(", pdn_gw_ipv6_Address := ");
field_pdn__gw__ipv6__Address.log();
TTCN_Logger::log_event_str(", pdn_gw_name := ");
field_pdn__gw__name.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
}

void PDN__GW__Identity::set_implicit_omit()
{
if (!pdn__gw__ipv4__Address().is_bound()) pdn__gw__ipv4__Address() = OMIT_VALUE;
else pdn__gw__ipv4__Address().set_implicit_omit();
if (!pdn__gw__ipv6__Address().is_bound()) pdn__gw__ipv6__Address() = OMIT_VALUE;
else pdn__gw__ipv6__Address().set_implicit_omit();
if (!pdn__gw__name().is_bound()) pdn__gw__name() = OMIT_VALUE;
else pdn__gw__name().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void PDN__GW__Identity::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.PDN-GW-Identity has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) pdn__gw__ipv4__Address().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) pdn__gw__ipv6__Address().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) pdn__gw__name().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdn_gw_ipv4_Address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdn__gw__ipv4__Address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdn_gw_ipv6_Address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdn__gw__ipv6__Address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdn_gw_name")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdn__gw__name().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.PDN-GW-Identity: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.PDN-GW-Identity");
  }
}

void PDN__GW__Identity::encode_text(Text_Buf& text_buf) const
{
field_pdn__gw__ipv4__Address.encode_text(text_buf);
field_pdn__gw__ipv6__Address.encode_text(text_buf);
field_pdn__gw__name.encode_text(text_buf);
field_extensionContainer.encode_text(text_buf);
}

void PDN__GW__Identity::decode_text(Text_Buf& text_buf)
{
field_pdn__gw__ipv4__Address.decode_text(text_buf);
field_pdn__gw__ipv6__Address.decode_text(text_buf);
field_pdn__gw__name.decode_text(text_buf);
field_extensionContainer.decode_text(text_buf);
}

void PDN__GW__Identity::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void PDN__GW__Identity::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* PDN__GW__Identity::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("pdn_gw_ipv4_Address': ");
  new_tlv->add_TLV(field_pdn__gw__ipv4__Address.BER_encode_TLV(PDN__GW__Identity_pdn__gw__ipv4__Address_descr_, p_coding));
  ec_1.set_msg("pdn_gw_ipv6_Address': ");
  new_tlv->add_TLV(field_pdn__gw__ipv6__Address.BER_encode_TLV(PDN__GW__Identity_pdn__gw__ipv6__Address_descr_, p_coding));
  ec_1.set_msg("pdn_gw_name': ");
  new_tlv->add_TLV(field_pdn__gw__name.BER_encode_TLV(PDN__GW__Identity_pdn__gw__name_descr_, p_coding));
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(PDN__GW__Identity_extensionContainer_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean PDN__GW__Identity::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.PDN-GW-Identity' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("pdn_gw_ipv4_Address': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_pdn__gw__ipv4__Address=OMIT_VALUE;
    else {
      field_pdn__gw__ipv4__Address.BER_decode_TLV(PDN__GW__Identity_pdn__gw__ipv4__Address_descr_, tmp_tlv, L_form);
      if(field_pdn__gw__ipv4__Address.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("pdn_gw_ipv6_Address': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_pdn__gw__ipv6__Address=OMIT_VALUE;
    else {
      field_pdn__gw__ipv6__Address.BER_decode_TLV(PDN__GW__Identity_pdn__gw__ipv6__Address_descr_, tmp_tlv, L_form);
      if(field_pdn__gw__ipv6__Address.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("pdn_gw_name': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_pdn__gw__name=OMIT_VALUE;
    else {
      field_pdn__gw__name.BER_decode_TLV(PDN__GW__Identity_pdn__gw__name_descr_, tmp_tlv, L_form);
      if(field_pdn__gw__name.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(PDN__GW__Identity_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int PDN__GW__Identity::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.PDN-GW-Identity.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  if (field_pdn__gw__ipv4__Address.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "pdn_gw_ipv4_Address");
    enc_len += field_pdn__gw__ipv4__Address.JSON_encode(PDN__GW__Identity_pdn__gw__ipv4__Address_descr_, p_tok, FALSE);
  }

  if (field_pdn__gw__ipv6__Address.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "pdn_gw_ipv6_Address");
    enc_len += field_pdn__gw__ipv6__Address.JSON_encode(PDN__GW__Identity_pdn__gw__ipv6__Address_descr_, p_tok, FALSE);
  }

  if (field_pdn__gw__name.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "pdn_gw_name");
    enc_len += field_pdn__gw__name.JSON_encode(PDN__GW__Identity_pdn__gw__name_descr_, p_tok, FALSE);
  }

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(PDN__GW__Identity_extensionContainer_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int PDN__GW__Identity::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const PDN__GW__Identity*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean pdn__gw__ipv4__Address_found = FALSE;
  boolean pdn__gw__ipv6__Address_found = FALSE;
  boolean pdn__gw__name_found = FALSE;
  boolean extensionContainer_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (19 == name_len && 0 == strncmp(fld_name, "pdn_gw_ipv4_Address", name_len)) {
        pdn__gw__ipv4__Address_found = TRUE;
         int ret_val = field_pdn__gw__ipv4__Address.JSON_decode(PDN__GW__Identity_pdn__gw__ipv4__Address_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 19, "pdn_gw_ipv4_Address");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (19 == name_len && 0 == strncmp(fld_name, "pdn_gw_ipv6_Address", name_len)) {
        pdn__gw__ipv6__Address_found = TRUE;
         int ret_val = field_pdn__gw__ipv6__Address.JSON_decode(PDN__GW__Identity_pdn__gw__ipv6__Address_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 19, "pdn_gw_ipv6_Address");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (11 == name_len && 0 == strncmp(fld_name, "pdn_gw_name", name_len)) {
        pdn__gw__name_found = TRUE;
         int ret_val = field_pdn__gw__name.JSON_decode(PDN__GW__Identity_pdn__gw__name_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 11, "pdn_gw_name");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(PDN__GW__Identity_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!pdn__gw__ipv4__Address_found) {
    field_pdn__gw__ipv4__Address = OMIT_VALUE;
  }
  if (!pdn__gw__ipv6__Address_found) {
    field_pdn__gw__ipv6__Address = OMIT_VALUE;
  }
  if (!pdn__gw__name_found) {
    field_pdn__gw__name = OMIT_VALUE;
  }
  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int PDN__GW__Identity::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  char c = 0;
  if (field_pdn__gw__ipv4__Address.is_present()) {
    c |= 64;
  }
  if (field_pdn__gw__ipv6__Address.is_present()) {
    c |= 32;
  }
  if (field_pdn__gw__name.is_present()) {
    c |= 16;
  }
  if (field_extensionContainer.is_present()) {
    c |= 8;
  }
  p_buf.put_c(c);
  if (field_pdn__gw__ipv4__Address.is_present())
    field_pdn__gw__ipv4__Address.OER_encode(PDN__GW__Identity_pdn__gw__ipv4__Address_descr_, p_buf);
  if (field_pdn__gw__ipv6__Address.is_present())
    field_pdn__gw__ipv6__Address.OER_encode(PDN__GW__Identity_pdn__gw__ipv6__Address_descr_, p_buf);
  if (field_pdn__gw__name.is_present())
    field_pdn__gw__name.OER_encode(PDN__GW__Identity_pdn__gw__name_descr_, p_buf);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(PDN__GW__Identity_extensionContainer_descr_, p_buf);
  return 0;
}

int PDN__GW__Identity::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  if (uc[0] & 64)
    field_pdn__gw__ipv4__Address.OER_decode(PDN__GW__Identity_pdn__gw__ipv4__Address_descr_, p_buf, p_oer);
 else
    field_pdn__gw__ipv4__Address = OMIT_VALUE;
  if (uc[0] & 32)
    field_pdn__gw__ipv6__Address.OER_decode(PDN__GW__Identity_pdn__gw__ipv6__Address_descr_, p_buf, p_oer);
 else
    field_pdn__gw__ipv6__Address = OMIT_VALUE;
  if (uc[0] & 16)
    field_pdn__gw__name.OER_decode(PDN__GW__Identity_pdn__gw__name_descr_, p_buf, p_oer);
 else
    field_pdn__gw__name = OMIT_VALUE;
  if (uc[0] & 8)
    field_extensionContainer.OER_decode(PDN__GW__Identity_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
  }
  return 0;
}

void PDN__GW__Identity::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_bit = FALSE;
p_buf.PER_put_bit(ext_bit);
boolean field_pdn__gw__ipv4__Address_present = field_pdn__gw__ipv4__Address.is_present();
p_buf.PER_put_bit(field_pdn__gw__ipv4__Address_present);
boolean field_pdn__gw__ipv6__Address_present = field_pdn__gw__ipv6__Address.is_present();
p_buf.PER_put_bit(field_pdn__gw__ipv6__Address_present);
boolean field_pdn__gw__name_present = field_pdn__gw__name.is_present();
p_buf.PER_put_bit(field_pdn__gw__name_present);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
if (field_pdn__gw__ipv4__Address_present) field_pdn__gw__ipv4__Address.PER_encode(PDN__GW__Identity_pdn__gw__ipv4__Address_descr_, p_buf, p_options);
if (field_pdn__gw__ipv6__Address_present) field_pdn__gw__ipv6__Address.PER_encode(PDN__GW__Identity_pdn__gw__ipv6__Address_descr_, p_buf, p_options);
if (field_pdn__gw__name_present) field_pdn__gw__name.PER_encode(PDN__GW__Identity_pdn__gw__name_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(PDN__GW__Identity_extensionContainer_descr_, p_buf, p_options);
}

void PDN__GW__Identity::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_pdn__gw__ipv4__Address_present = p_buf.PER_get_bit();
boolean field_pdn__gw__ipv6__Address_present = p_buf.PER_get_bit();
boolean field_pdn__gw__name_present = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
if (field_pdn__gw__ipv4__Address_present) field_pdn__gw__ipv4__Address.PER_decode(PDN__GW__Identity_pdn__gw__ipv4__Address_descr_, p_buf, p_options);
else field_pdn__gw__ipv4__Address = OMIT_VALUE;
if (field_pdn__gw__ipv6__Address_present) field_pdn__gw__ipv6__Address.PER_decode(PDN__GW__Identity_pdn__gw__ipv6__Address_descr_, p_buf, p_options);
else field_pdn__gw__ipv6__Address = OMIT_VALUE;
if (field_pdn__gw__name_present) field_pdn__gw__name.PER_decode(PDN__GW__Identity_pdn__gw__name_descr_, p_buf, p_options);
else field_pdn__gw__name = OMIT_VALUE;
if (field_extensionContainer_present) field_extensionContainer.PER_decode(PDN__GW__Identity_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
for (int i = 0; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct PDN__GW__Identity_template::single_value_struct {
OCTETSTRING_template field_pdn__gw__ipv4__Address;
OCTETSTRING_template field_pdn__gw__ipv6__Address;
OCTETSTRING_template field_pdn__gw__name;
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
};

void PDN__GW__Identity_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_pdn__gw__ipv4__Address = ANY_OR_OMIT;
single_value->field_pdn__gw__ipv6__Address = ANY_OR_OMIT;
single_value->field_pdn__gw__name = ANY_OR_OMIT;
single_value->field_extensionContainer = ANY_OR_OMIT;
}
}
}

void PDN__GW__Identity_template::copy_value(const PDN__GW__Identity& other_value)
{
single_value = new single_value_struct;
if (other_value.pdn__gw__ipv4__Address().is_bound()) {
  if (other_value.pdn__gw__ipv4__Address().ispresent()) single_value->field_pdn__gw__ipv4__Address = other_value.pdn__gw__ipv4__Address()();
  else single_value->field_pdn__gw__ipv4__Address = OMIT_VALUE;
} else {
  single_value->field_pdn__gw__ipv4__Address.clean_up();
}
if (other_value.pdn__gw__ipv6__Address().is_bound()) {
  if (other_value.pdn__gw__ipv6__Address().ispresent()) single_value->field_pdn__gw__ipv6__Address = other_value.pdn__gw__ipv6__Address()();
  else single_value->field_pdn__gw__ipv6__Address = OMIT_VALUE;
} else {
  single_value->field_pdn__gw__ipv6__Address.clean_up();
}
if (other_value.pdn__gw__name().is_bound()) {
  if (other_value.pdn__gw__name().ispresent()) single_value->field_pdn__gw__name = other_value.pdn__gw__name()();
  else single_value->field_pdn__gw__name = OMIT_VALUE;
} else {
  single_value->field_pdn__gw__name.clean_up();
}
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void PDN__GW__Identity_template::copy_template(const PDN__GW__Identity_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.pdn__gw__ipv4__Address().get_selection()) {
single_value->field_pdn__gw__ipv4__Address = other_value.pdn__gw__ipv4__Address();
} else {
single_value->field_pdn__gw__ipv4__Address.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pdn__gw__ipv6__Address().get_selection()) {
single_value->field_pdn__gw__ipv6__Address = other_value.pdn__gw__ipv6__Address();
} else {
single_value->field_pdn__gw__ipv6__Address.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.pdn__gw__name().get_selection()) {
single_value->field_pdn__gw__name = other_value.pdn__gw__name();
} else {
single_value->field_pdn__gw__name.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new PDN__GW__Identity_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new PDN__GW__Identity_template(*other_value.implication_.precondition);
implication_.implied_template = new PDN__GW__Identity_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.PDN-GW-Identity.");
break;
}
set_selection(other_value);
}

PDN__GW__Identity_template::PDN__GW__Identity_template()
{
}

PDN__GW__Identity_template::PDN__GW__Identity_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

PDN__GW__Identity_template::PDN__GW__Identity_template(const PDN__GW__Identity& other_value)
{
copy_value(other_value);
}

PDN__GW__Identity_template::PDN__GW__Identity_template(const OPTIONAL<PDN__GW__Identity>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDN__GW__Identity&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.PDN-GW-Identity from an unbound optional field.");
}
}

PDN__GW__Identity_template::PDN__GW__Identity_template(PDN__GW__Identity_template* p_precondition, PDN__GW__Identity_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

PDN__GW__Identity_template::PDN__GW__Identity_template(Dynamic_Match_Interface<PDN__GW__Identity>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<PDN__GW__Identity>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

PDN__GW__Identity_template::PDN__GW__Identity_template(const PDN__GW__Identity_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

PDN__GW__Identity_template::~PDN__GW__Identity_template()
{
clean_up();
}

PDN__GW__Identity_template& PDN__GW__Identity_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

PDN__GW__Identity_template& PDN__GW__Identity_template::operator=(const PDN__GW__Identity& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

PDN__GW__Identity_template& PDN__GW__Identity_template::operator=(const OPTIONAL<PDN__GW__Identity>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const PDN__GW__Identity&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.PDN-GW-Identity.");
}
return *this;
}

PDN__GW__Identity_template& PDN__GW__Identity_template::operator=(const PDN__GW__Identity_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean PDN__GW__Identity_template::match(const PDN__GW__Identity& other_value, boolean legacy) const
{
if (!other_value.is_bound()) return FALSE;
switch (template_selection) {
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case OMIT_VALUE:
return FALSE;
case SPECIFIC_VALUE:
if(!other_value.pdn__gw__ipv4__Address().is_bound()) return FALSE;
if((other_value.pdn__gw__ipv4__Address().ispresent() ? !single_value->field_pdn__gw__ipv4__Address.match((const OCTETSTRING&)other_value.pdn__gw__ipv4__Address(), legacy) : !single_value->field_pdn__gw__ipv4__Address.match_omit(legacy)))return FALSE;
if(!other_value.pdn__gw__ipv6__Address().is_bound()) return FALSE;
if((other_value.pdn__gw__ipv6__Address().ispresent() ? !single_value->field_pdn__gw__ipv6__Address.match((const OCTETSTRING&)other_value.pdn__gw__ipv6__Address(), legacy) : !single_value->field_pdn__gw__ipv6__Address.match_omit(legacy)))return FALSE;
if(!other_value.pdn__gw__name().is_bound()) return FALSE;
if((other_value.pdn__gw__name().ispresent() ? !single_value->field_pdn__gw__name.match((const OCTETSTRING&)other_value.pdn__gw__name(), legacy) : !single_value->field_pdn__gw__name.match_omit(legacy)))return FALSE;
if(!other_value.extensionContainer().is_bound()) return FALSE;
if((other_value.extensionContainer().ispresent() ? !single_value->field_extensionContainer.match((const MAP__ExtensionDataTypes::ExtensionContainer&)other_value.extensionContainer(), legacy) : !single_value->field_extensionContainer.match_omit(legacy)))return FALSE;
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value, legacy)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of type @MAP-MS-DataTypes.PDN-GW-Identity.");
}
return FALSE;
}

boolean PDN__GW__Identity_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
if (template_selection != SPECIFIC_VALUE) return TRUE;
return (single_value->field_pdn__gw__ipv4__Address.is_omit() || single_value->field_pdn__gw__ipv4__Address.is_bound())
 || (single_value->field_pdn__gw__ipv6__Address.is_omit() || single_value->field_pdn__gw__ipv6__Address.is_bound())
 || (single_value->field_pdn__gw__name.is_omit() || single_value->field_pdn__gw__name.is_bound())
 || (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_bound());
}

boolean PDN__GW__Identity_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return (single_value->field_pdn__gw__ipv4__Address.is_omit() || single_value->field_pdn__gw__ipv4__Address.is_value())
 && (single_value->field_pdn__gw__ipv6__Address.is_omit() || single_value->field_pdn__gw__ipv6__Address.is_value())
 && (single_value->field_pdn__gw__name.is_omit() || single_value->field_pdn__gw__name.is_value())
 && (single_value->field_extensionContainer.is_omit() || single_value->field_extensionContainer.is_value());
}

void PDN__GW__Identity_template::clean_up()
{
switch (template_selection) {
case SPECIFIC_VALUE:
delete single_value;
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

PDN__GW__Identity PDN__GW__Identity_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent)
TTCN_error("Performing a valueof or send operation on a non-specific template of type @MAP-MS-DataTypes.PDN-GW-Identity.");
PDN__GW__Identity ret_val;
if (single_value->field_pdn__gw__ipv4__Address.is_omit()) ret_val.pdn__gw__ipv4__Address() = OMIT_VALUE;
else if (single_value->field_pdn__gw__ipv4__Address.is_bound()) {
ret_val.pdn__gw__ipv4__Address() = single_value->field_pdn__gw__ipv4__Address.valueof();
}
if (single_value->field_pdn__gw__ipv6__Address.is_omit()) ret_val.pdn__gw__ipv6__Address() = OMIT_VALUE;
else if (single_value->field_pdn__gw__ipv6__Address.is_bound()) {
ret_val.pdn__gw__ipv6__Address() = single_value->field_pdn__gw__ipv6__Address.valueof();
}
if (single_value->field_pdn__gw__name.is_omit()) ret_val.pdn__gw__name() = OMIT_VALUE;
else if (single_value->field_pdn__gw__name.is_bound()) {
ret_val.pdn__gw__name() = single_value->field_pdn__gw__name.valueof();
}
if (single_value->field_extensionContainer.is_omit()) ret_val.extensionContainer() = OMIT_VALUE;
else if (single_value->field_extensionContainer.is_bound()) {
ret_val.extensionContainer() = single_value->field_extensionContainer.valueof();
}
return ret_val;
}

void PDN__GW__Identity_template::set_type(template_sel template_type, unsigned int list_length)
{
if (template_type != VALUE_LIST && template_type != COMPLEMENTED_LIST&& template_type != CONJUNCTION_MATCH)
TTCN_error("Setting an invalid list for a template of type @MAP-MS-DataTypes.PDN-GW-Identity.");
clean_up();
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new PDN__GW__Identity_template[list_length];
}

PDN__GW__Identity_template& PDN__GW__Identity_template::list_item(unsigned int list_index) const
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST&& template_selection != CONJUNCTION_MATCH)
TTCN_error("Accessing a list element of a non-list template of type @MAP-MS-DataTypes.PDN-GW-Identity.");
if (list_index >= value_list.n_values)
TTCN_error("Index overflow in a value list template of type @MAP-MS-DataTypes.PDN-GW-Identity.");
return value_list.list_value[list_index];
}

OCTETSTRING_template& PDN__GW__Identity_template::pdn__gw__ipv4__Address()
{
set_specific();
return single_value->field_pdn__gw__ipv4__Address;
}

const OCTETSTRING_template& PDN__GW__Identity_template::pdn__gw__ipv4__Address() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pdn_gw_ipv4_Address of a non-specific template of type @MAP-MS-DataTypes.PDN-GW-Identity.");
return single_value->field_pdn__gw__ipv4__Address;
}

OCTETSTRING_template& PDN__GW__Identity_template::pdn__gw__ipv6__Address()
{
set_specific();
return single_value->field_pdn__gw__ipv6__Address;
}

const OCTETSTRING_template& PDN__GW__Identity_template::pdn__gw__ipv6__Address() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pdn_gw_ipv6_Address of a non-specific template of type @MAP-MS-DataTypes.PDN-GW-Identity.");
return single_value->field_pdn__gw__ipv6__Address;
}

OCTETSTRING_template& PDN__GW__Identity_template::pdn__gw__name()
{
set_specific();
return single_value->field_pdn__gw__name;
}

const OCTETSTRING_template& PDN__GW__Identity_template::pdn__gw__name() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field pdn_gw_name of a non-specific template of type @MAP-MS-DataTypes.PDN-GW-Identity.");
return single_value->field_pdn__gw__name;
}

MAP__ExtensionDataTypes::ExtensionContainer_template& PDN__GW__Identity_template::extensionContainer()
{
set_specific();
return single_value->field_extensionContainer;
}

const MAP__ExtensionDataTypes::ExtensionContainer_template& PDN__GW__Identity_template::extensionContainer() const
{
if (template_selection != SPECIFIC_VALUE)
TTCN_error("Accessing field extensionContainer of a non-specific template of type @MAP-MS-DataTypes.PDN-GW-Identity.");
return single_value->field_extensionContainer;
}

int PDN__GW__Identity_template::size_of() const
{
  if (is_ifpresent) TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.PDN-GW-Identity which has an ifpresent attribute.");
  switch (template_selection)
  {
  case SPECIFIC_VALUE:
  {    int ret_val = 0;
      if (single_value->field_pdn__gw__ipv4__Address.is_present()) ret_val++;
      if (single_value->field_pdn__gw__ipv6__Address.is_present()) ret_val++;
      if (single_value->field_pdn__gw__name.is_present()) ret_val++;
      if (single_value->field_extensionContainer.is_present()) ret_val++;
      return ret_val;
    }
  case VALUE_LIST:
   {
     if (value_list.n_values<1)
       TTCN_error("Internal error: Performing sizeof() operation on a template of type @MAP-MS-DataTypes.PDN-GW-Identity containing an empty list.");
      int item_size = value_list.list_value[0].size_of();
      for (unsigned int l_idx = 1; l_idx < value_list.n_values; l_idx++)
      {
        if (value_list.list_value[l_idx].size_of()!=item_size)
          TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.PDN-GW-Identity containing a value list with different sizes.");
      }
      return item_size;
    }
  case OMIT_VALUE:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.PDN-GW-Identity containing omit value.");
  case ANY_VALUE:
  case ANY_OR_OMIT:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.PDN-GW-Identity containing */? value.");
  case COMPLEMENTED_LIST:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.PDN-GW-Identity containing complemented list.");
  case CONJUNCTION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.PDN-GW-Identity containing a conjunction list match.");
  case IMPLICATION_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.PDN-GW-Identity containing an implication match.");
  case DYNAMIC_MATCH:
    TTCN_error("Performing sizeof() operation on a template of type @MAP-MS-DataTypes.PDN-GW-Identity containing a dynamic match.");
  default:
    TTCN_error("Performing sizeof() operation on an uninitialized/unsupported template of type @MAP-MS-DataTypes.PDN-GW-Identity.");
  }
  return 0;
}

void PDN__GW__Identity_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_str("{ pdn_gw_ipv4_Address := ");
single_value->field_pdn__gw__ipv4__Address.log();
TTCN_Logger::log_event_str(", pdn_gw_ipv6_Address := ");
single_value->field_pdn__gw__ipv6__Address.log();
TTCN_Logger::log_event_str(", pdn_gw_name := ");
single_value->field_pdn__gw__name.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" }");
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++) {
if (list_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[list_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void PDN__GW__Identity_template::log_match(const PDN__GW__Identity& match_value, boolean legacy) const
{
if(TTCN_Logger::VERBOSITY_COMPACT == TTCN_Logger::get_matching_verbosity()){
if(match(match_value, legacy)){
TTCN_Logger::print_logmatch_buffer();
TTCN_Logger::log_event_str(" matched");
} else{
if (template_selection == SPECIFIC_VALUE) {
size_t previous_size = TTCN_Logger::get_logmatch_buffer_len();
if (match_value.pdn__gw__ipv4__Address().ispresent()){
if(!single_value->field_pdn__gw__ipv4__Address.match(match_value.pdn__gw__ipv4__Address(), legacy)){
TTCN_Logger::log_logmatch_info(".pdn_gw_ipv4_Address");
single_value->field_pdn__gw__ipv4__Address.log_match(match_value.pdn__gw__ipv4__Address(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_pdn__gw__ipv4__Address.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".pdn_gw_ipv4_Address := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_pdn__gw__ipv4__Address.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.pdn__gw__ipv6__Address().ispresent()){
if(!single_value->field_pdn__gw__ipv6__Address.match(match_value.pdn__gw__ipv6__Address(), legacy)){
TTCN_Logger::log_logmatch_info(".pdn_gw_ipv6_Address");
single_value->field_pdn__gw__ipv6__Address.log_match(match_value.pdn__gw__ipv6__Address(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_pdn__gw__ipv6__Address.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".pdn_gw_ipv6_Address := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_pdn__gw__ipv6__Address.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.pdn__gw__name().ispresent()){
if(!single_value->field_pdn__gw__name.match(match_value.pdn__gw__name(), legacy)){
TTCN_Logger::log_logmatch_info(".pdn_gw_name");
single_value->field_pdn__gw__name.log_match(match_value.pdn__gw__name(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_pdn__gw__name.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".pdn_gw_name := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_pdn__gw__name.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
if (match_value.extensionContainer().ispresent()){
if(!single_value->field_extensionContainer.match(match_value.extensionContainer(), legacy)){
TTCN_Logger::log_logmatch_info(".extensionContainer");
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
} else {
if (!single_value->field_extensionContainer.match_omit(legacy)){
 TTCN_Logger::log_logmatch_info(".extensionContainer := omit with ");
TTCN_Logger::print_logmatch_buffer();
single_value->field_extensionContainer.log();
TTCN_Logger::log_event_str(" unmatched");
TTCN_Logger::set_logmatch_buffer_len(previous_size);
}
}
}else {
TTCN_Logger::print_logmatch_buffer();
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
TTCN_Logger::log_event_str(" unmatched");
}
}
return;
}
if (template_selection == SPECIFIC_VALUE) {
TTCN_Logger::log_event_str("{ pdn_gw_ipv4_Address := ");
if (match_value.pdn__gw__ipv4__Address().ispresent()) {
single_value->field_pdn__gw__ipv4__Address.log_match(match_value.pdn__gw__ipv4__Address(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_pdn__gw__ipv4__Address.log();
if (single_value->field_pdn__gw__ipv4__Address.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", pdn_gw_ipv6_Address := ");
if (match_value.pdn__gw__ipv6__Address().ispresent()) {
single_value->field_pdn__gw__ipv6__Address.log_match(match_value.pdn__gw__ipv6__Address(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_pdn__gw__ipv6__Address.log();
if (single_value->field_pdn__gw__ipv6__Address.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", pdn_gw_name := ");
if (match_value.pdn__gw__name().ispresent()) {
single_value->field_pdn__gw__name.log_match(match_value.pdn__gw__name(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_pdn__gw__name.log();
if (single_value->field_pdn__gw__name.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(", extensionContainer := ");
if (match_value.extensionContainer().ispresent()) {
single_value->field_extensionContainer.log_match(match_value.extensionContainer(), legacy);
} else {
TTCN_Logger::log_event_str("omit with ");
single_value->field_extensionContainer.log();
if (single_value->field_extensionContainer.match_omit(legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
TTCN_Logger::log_event_str(" }");
} else {
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value, legacy)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}
}

void PDN__GW__Identity_template::set_implicit_omit()
{
if (template_selection != SPECIFIC_VALUE) return;
if (!pdn__gw__ipv4__Address().is_bound()) pdn__gw__ipv4__Address() = OMIT_VALUE;
else pdn__gw__ipv4__Address().set_implicit_omit();
if (!pdn__gw__ipv6__Address().is_bound()) pdn__gw__ipv6__Address() = OMIT_VALUE;
else pdn__gw__ipv6__Address().set_implicit_omit();
if (!pdn__gw__name().is_bound()) pdn__gw__name() = OMIT_VALUE;
else pdn__gw__name().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
}

void PDN__GW__Identity_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value->field_pdn__gw__ipv4__Address.encode_text(text_buf);
single_value->field_pdn__gw__ipv6__Address.encode_text(text_buf);
single_value->field_pdn__gw__name.encode_text(text_buf);
single_value->field_extensionContainer.encode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of type @MAP-MS-DataTypes.PDN-GW-Identity.");
}
}

void PDN__GW__Identity_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
single_value->field_pdn__gw__ipv4__Address.decode_text(text_buf);
single_value->field_pdn__gw__ipv6__Address.decode_text(text_buf);
single_value->field_pdn__gw__name.decode_text(text_buf);
single_value->field_extensionContainer.decode_text(text_buf);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new PDN__GW__Identity_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received in a template of type @MAP-MS-DataTypes.PDN-GW-Identity.");
}
}

void PDN__GW__Identity_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "record template");
  switch (param.get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    PDN__GW__Identity_template new_temp;
    new_temp.set_type(param.get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (param.get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), param.get_size());
    for (size_t p_i=0; p_i<param.get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*param.get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record template of type @MAP-MS-DataTypes.PDN-GW-Identity has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) pdn__gw__ipv4__Address().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) pdn__gw__ipv6__Address().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) pdn__gw__name().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdn_gw_ipv4_Address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdn__gw__ipv4__Address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdn_gw_ipv6_Address")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdn__gw__ipv6__Address().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "pdn_gw_name")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          pdn__gw__name().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.PDN-GW-Identity: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  case Module_Param::MP_Implication_Template: {
    PDN__GW__Identity_template* precondition = new PDN__GW__Identity_template;
    precondition->set_param(*param.get_elem(0));
    PDN__GW__Identity_template* implied_template = new PDN__GW__Identity_template;
    implied_template->set_param(*param.get_elem(1));
    *this = PDN__GW__Identity_template(precondition, implied_template);
  } break;
  default:
    param.type_error("record template", "@MAP-MS-DataTypes.PDN-GW-Identity");
  }
  is_ifpresent = param.get_ifpresent();
}

void PDN__GW__Identity_template::check_restriction(template_res t_res, const char* t_name, boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_OMIT:
if (template_selection==OMIT_VALUE) return;
case TR_VALUE:
if (template_selection!=SPECIFIC_VALUE || is_ifpresent) break;
single_value->field_pdn__gw__ipv4__Address.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.PDN-GW-Identity");
single_value->field_pdn__gw__ipv6__Address.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.PDN-GW-Identity");
single_value->field_pdn__gw__name.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.PDN-GW-Identity");
single_value->field_extensionContainer.check_restriction(t_res, t_name ? t_name : "@MAP-MS-DataTypes.PDN-GW-Identity");
return;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.PDN-GW-Identity");
}

boolean PDN__GW__Identity_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean PDN__GW__Identity_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int l_idx=0; l_idx<value_list.n_values; l_idx++)
if (value_list.list_value[l_idx].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

Used__RAT__Type::Used__RAT__Type()
{
enum_value = UNBOUND_VALUE;
}

Used__RAT__Type::Used__RAT__Type(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @MAP-MS-DataTypes.Used-RAT-Type with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

Used__RAT__Type::Used__RAT__Type(enum_type other_value)
{
enum_value = other_value;
}

Used__RAT__Type::Used__RAT__Type(const Used__RAT__Type& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
enum_value = other_value.enum_value;
}

Used__RAT__Type& Used__RAT__Type::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

Used__RAT__Type& Used__RAT__Type::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

Used__RAT__Type& Used__RAT__Type::operator=(const Used__RAT__Type& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
enum_value = other_value.enum_value;
return *this;
}

boolean Used__RAT__Type::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @MAP-MS-DataTypes.Used-RAT-Type comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean Used__RAT__Type::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
return enum_value == other_value;
}

boolean Used__RAT__Type::operator==(const Used__RAT__Type& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
return enum_value == other_value.enum_value;
}

boolean Used__RAT__Type::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @MAP-MS-DataTypes.Used-RAT-Type comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean Used__RAT__Type::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
return enum_value < other_value;
}

boolean Used__RAT__Type::operator<(const Used__RAT__Type& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
return enum_value < other_value.enum_value;
}

boolean Used__RAT__Type::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @MAP-MS-DataTypes.Used-RAT-Type comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean Used__RAT__Type::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
return enum_value > other_value;
}

boolean Used__RAT__Type::operator>(const Used__RAT__Type& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
return enum_value > other_value.enum_value;
}

const char *Used__RAT__Type::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case utran: return "utran";
case geran: return "geran";
case gan: return "gan";
case i__hspa__evolution: return "i_hspa_evolution";
case e__utran: return "e_utran";
default:
return "<unknown>";
}
}

Used__RAT__Type::enum_type Used__RAT__Type::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "utran")) return utran;
if (!strcmp(str_par, "geran")) return geran;
if (!strcmp(str_par, "gan")) return gan;
if (!strcmp(str_par, "i_hspa_evolution")) return i__hspa__evolution;
if (!strcmp(str_par, "e_utran")) return e__utran;
}
return UNKNOWN_VALUE;
}

boolean Used__RAT__Type::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
case 2:
case 3:
case 4:
return TRUE;
default:
return FALSE;
}
}

int Used__RAT__Type::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int Used__RAT__Type::enum2int(const Used__RAT__Type& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void Used__RAT__Type::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.", int_val);
enum_value = (enum_type)int_val;
}

Used__RAT__Type::operator Used__RAT__Type::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
return enum_value;
}

void Used__RAT__Type::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void Used__RAT__Type::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@MAP-MS-DataTypes.Used-RAT-Type");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @MAP-MS-DataTypes.Used-RAT-Type.");
  }
}

void Used__RAT__Type::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
text_buf.push_int(enum_value);
}

void Used__RAT__Type::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @MAP-MS-DataTypes.Used-RAT-Type.", enum_value);
}

void Used__RAT__Type::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void Used__RAT__Type::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* Used__RAT__Type::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=BER_encode_chk_bound(is_bound());
  if(!new_tlv) {
    BER_encode_chk_enum_valid(p_td, is_valid_enum(enum_value), enum_value);
    new_tlv=BER_encode_TLV_INTEGER(p_coding, enum_value);
  }
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean Used__RAT__Type::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  enum_value = UNBOUND_VALUE;
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec("While decoding ENUMERATED type @MAP-MS-DataTypes.Used-RAT-Type: ");
  int tmp_mfr;
  if (BER_decode_TLV_INTEGER(stripped_tlv, L_form, tmp_mfr)) {
    BER_decode_chk_enum_valid(p_td, is_valid_enum(tmp_mfr), tmp_mfr);
    enum_value = (enum_type)tmp_mfr;
    return TRUE;
  } else return FALSE;
}

int Used__RAT__Type::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean) const
{
  if (enum_value == UNBOUND_VALUE) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
    return -1;
  }

  if (p_td.json->use_null) {
    return p_tok.put_next_token(JSON_TOKEN_LITERAL_NULL);
  }
  char* tmp_str;
  if (p_td.json->as_number) {
    tmp_str = mprintf("%d", enum_value);
  }
  else {
    boolean text_found = false;
    for (size_t i = 0; i < p_td.json->nof_enum_texts; ++i) {
      if (p_td.json->enum_texts[i].index == enum_value) {
        tmp_str = mprintf("\"%s\"", p_td.json->enum_texts[i].text);
        text_found = true;
        break;
      }
    }
    if (!text_found) {
      tmp_str = mprintf("\"%s\"", enum_to_str(enum_value));
    }
  }
  int enc_len = p_tok.put_next_token(p_td.json->as_number ? JSON_TOKEN_NUMBER : JSON_TOKEN_STRING, tmp_str);
  Free(tmp_str);
  return enc_len;
}

int Used__RAT__Type::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean, int)
{
  json_token_t token = JSON_TOKEN_NONE;
  char* value = 0;
  size_t value_len = 0;
  boolean error = FALSE;
  size_t dec_len = 0;
  boolean use_default = FALSE;
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const Used__RAT__Type*>(p_td.json->default_value.val);
    return dec_len;
  }
  if (p_td.json->default_value.type == JD_LEGACY && 0 == p_tok.get_buffer_length()) {
    value = const_cast<char*>(p_td.json->default_value.str);
    value_len = strlen(value);
    use_default = TRUE;
  } else {
    dec_len = p_tok.get_next_token(&token, &value, &value_len);
  }
  if (JSON_TOKEN_ERROR == token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_LITERAL_NULL == token && p_td.json->use_null) {
    enum_value = utran;
  }
  else if (!p_td.json->use_null && ((JSON_TOKEN_STRING == token && !p_td.json->as_number) || use_default)) {
    if (use_default || (value_len > 2 && value[0] == '\"' && value[value_len - 1] == '\"')) {
      if (!use_default) value[value_len - 1] = 0;
      boolean text_found = false;
      for (size_t i = 0; i < p_td.json->nof_enum_texts; ++i) {
        if (strcmp(p_td.json->enum_texts[i].text, value + (use_default ? 0 : 1)) == 0) {
          enum_value = static_cast<enum_type>(p_td.json->enum_texts[i].index);
          text_found = true;
          break;
        }
      }
      if (!text_found) {
        enum_value = str_to_enum(value + (use_default ? 0 : 1));
      }
      if (!use_default) value[value_len - 1] = '\"';
      if (UNKNOWN_VALUE == enum_value) {
        error = TRUE;
      }
    } else {
      error = TRUE;
    }
  }
  else if (!p_td.json->use_null && JSON_TOKEN_NUMBER == token && p_td.json->as_number) {
    char* value_str = mcopystrn(value, value_len);
    int number = atoi(value_str);
    if (strchr(value_str, '.') != NULL || strchr(value_str, 'e') != NULL || strchr(value_str, 'E') != NULL) {
      error = TRUE;
    }
    else if (is_valid_enum(number)) {
      enum_value = static_cast<enum_type>(number);
    }
    else {
      error = TRUE;
    }
    Free(value_str);
  }
  else {
    enum_value = UNBOUND_VALUE;
    return JSON_ERROR_INVALID_TOKEN;
  }

  if (error) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FORMAT_ERROR, p_td.json->as_number ? "number" : "string", "enumerated");
    enum_value = UNBOUND_VALUE;
    return JSON_ERROR_FATAL;
  }
  return (int)dec_len;
}

int Used__RAT__Type::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (enum_value == UNBOUND_VALUE) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
    return -1;
  }

  if (enum_value >= 0 && enum_value < 128) {
    char c = enum_value;
    p_buf.put_c(c);
  } else {
    INTEGER intval(enum_value);
    TTCN_Buffer buf;
    intval.OER_encode(INTEGER_descr_, buf);
    unsigned char* uc = const_cast<unsigned char*>(buf.get_data());
    *uc |= 1 << 7;
    p_buf.put_buf(buf);
  }
  return 0;
}

int Used__RAT__Type::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  if (!(uc[0] & 0x80)) {
    if (is_valid_enum(uc[0])) {
      enum_value = static_cast<enum_type>(uc[0]);
    } else {
      enum_value = UNKNOWN_VALUE;
    }
    p_buf.increase_pos(1);
  } else {
    unsigned char* uc2 = const_cast<unsigned char*>(p_buf.get_read_data());
    uc2[0] &= ~0x80;
    INTEGER intval;
    intval.OER_decode(INTEGER_descr_, p_buf, p_oer);
    if (is_valid_enum(intval.get_val().get_val())) {
      enum_value = static_cast<enum_type>(intval.get_val().get_val());
    } else {
      enum_value = UNKNOWN_VALUE;
    }
  }
  return 0;
}

void Used__RAT__Type::PER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options) const
{
INTEGER enc_val;
boolean ext_bit = FALSE;
switch (enum_value) {
case utran:
enc_val = 0;
ext_bit = FALSE;
break;
case geran:
enc_val = 1;
ext_bit = FALSE;
break;
case gan:
enc_val = 2;
ext_bit = FALSE;
break;
case i__hspa__evolution:
enc_val = 3;
ext_bit = FALSE;
break;
case e__utran:
enc_val = 4;
ext_bit = FALSE;
break;
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
 "Encoding an unbound or unknown value of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
}
p_buf.PER_put_bit(ext_bit);
if (ext_bit) enc_val.PER_encode_normally_small(p_buf, p_options);
else INTEGER::PER_encode_int(p_buf, enc_val, 3);
}

void Used__RAT__Type::PER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options)
{
INTEGER dec_val;
boolean ext_bit = p_buf.PER_get_bit();
if (ext_bit) dec_val.PER_decode_normally_small(p_buf, p_options);
else dec_val.PER_decode_unaligned_constrained(p_buf, 3, FALSE);
int dec_int = dec_val;
if (ext_bit) switch (dec_int) {
default: enum_value = UNBOUND_VALUE; break;
}
else switch (dec_int) {
case 0: enum_value = utran; break;
case 1: enum_value = geran; break;
case 2: enum_value = gan; break;
case 3: enum_value = i__hspa__evolution; break;
case 4: enum_value = e__utran; break;
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INVAL_MSG,
 "Decoded invalid number (%d) for enumerated type @MAP-MS-DataTypes.Used-RAT-Type.", dec_int);
break;
}
}

void Used__RAT__Type_template::copy_template(const Used__RAT__Type_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new Used__RAT__Type_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new Used__RAT__Type_template(*other_value.implication_.precondition);
implication_.implied_template = new Used__RAT__Type_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
}
}

Used__RAT__Type_template::Used__RAT__Type_template()
{
}

Used__RAT__Type_template::Used__RAT__Type_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

Used__RAT__Type_template::Used__RAT__Type_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!Used__RAT__Type::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @MAP-MS-DataTypes.Used-RAT-Type with unknown numeric value %d.", other_value);
single_value = (Used__RAT__Type::enum_type)other_value;
}

Used__RAT__Type_template::Used__RAT__Type_template(Used__RAT__Type::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

Used__RAT__Type_template::Used__RAT__Type_template(const Used__RAT__Type& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == Used__RAT__Type::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
single_value = other_value.enum_value;
}

Used__RAT__Type_template::Used__RAT__Type_template(const OPTIONAL<Used__RAT__Type>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (Used__RAT__Type::enum_type)(const Used__RAT__Type&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @MAP-MS-DataTypes.Used-RAT-Type from an unbound optional field.");
}
}

Used__RAT__Type_template::Used__RAT__Type_template(Used__RAT__Type_template* p_precondition, Used__RAT__Type_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

Used__RAT__Type_template::Used__RAT__Type_template(Dynamic_Match_Interface<Used__RAT__Type>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<Used__RAT__Type>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

Used__RAT__Type_template::Used__RAT__Type_template(const Used__RAT__Type_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

Used__RAT__Type_template::~Used__RAT__Type_template()
{
clean_up();
}

boolean Used__RAT__Type_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean Used__RAT__Type_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != Used__RAT__Type::UNBOUND_VALUE;
}

void Used__RAT__Type_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

Used__RAT__Type_template& Used__RAT__Type_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

Used__RAT__Type_template& Used__RAT__Type_template::operator=(int other_value)
{
if (!Used__RAT__Type::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (Used__RAT__Type::enum_type)other_value;
return *this;
}

Used__RAT__Type_template& Used__RAT__Type_template::operator=(Used__RAT__Type::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

Used__RAT__Type_template& Used__RAT__Type_template::operator=(const Used__RAT__Type& other_value)
{
if (other_value.enum_value == Used__RAT__Type::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @MAP-MS-DataTypes.Used-RAT-Type to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

Used__RAT__Type_template& Used__RAT__Type_template::operator=(const OPTIONAL<Used__RAT__Type>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (Used__RAT__Type::enum_type)(const Used__RAT__Type&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
}
return *this;
}

Used__RAT__Type_template& Used__RAT__Type_template::operator=(const Used__RAT__Type_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean Used__RAT__Type_template::match(Used__RAT__Type::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
}
return FALSE;
}

boolean Used__RAT__Type_template::match(const Used__RAT__Type& other_value, boolean) const
{
if (other_value.enum_value == Used__RAT__Type::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @MAP-MS-DataTypes.Used-RAT-Type with an unbound value.");
return match(other_value.enum_value);
}

Used__RAT__Type::enum_type Used__RAT__Type_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
return single_value;
}

void Used__RAT__Type_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new Used__RAT__Type_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
}
}

Used__RAT__Type_template& Used__RAT__Type_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
return value_list.list_value[list_index];
}

void Used__RAT__Type_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(Used__RAT__Type::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void Used__RAT__Type_template::log_match(const Used__RAT__Type& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void Used__RAT__Type_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
}
}

void Used__RAT__Type_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (Used__RAT__Type::enum_type)text_buf.pull_int().get_val();
if (!Used__RAT__Type::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new Used__RAT__Type_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @MAP-MS-DataTypes.Used-RAT-Type.");
}
}

boolean Used__RAT__Type_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean Used__RAT__Type_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void Used__RAT__Type_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    Used__RAT__Type_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    Used__RAT__Type::enum_type enum_val = Used__RAT__Type::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!Used__RAT__Type::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @MAP-MS-DataTypes.Used-RAT-Type.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    Used__RAT__Type_template* precondition = new Used__RAT__Type_template;
    precondition->set_param(*m_p->get_elem(0));
    Used__RAT__Type_template* implied_template = new Used__RAT__Type_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = Used__RAT__Type_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@MAP-MS-DataTypes.Used-RAT-Type");
  }
  is_ifpresent = param.get_ifpresent();
}

void Used__RAT__Type_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.Used-RAT-Type");
}

UE__SRVCC__Capability::UE__SRVCC__Capability()
{
enum_value = UNBOUND_VALUE;
}

UE__SRVCC__Capability::UE__SRVCC__Capability(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Initializing a variable of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability with invalid numeric value %d.", other_value);
enum_value = (enum_type)other_value;
}

UE__SRVCC__Capability::UE__SRVCC__Capability(enum_type other_value)
{
enum_value = other_value;
}

UE__SRVCC__Capability::UE__SRVCC__Capability(const UE__SRVCC__Capability& other_value)
: Base_Type()
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Copying an unbound value of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
enum_value = other_value.enum_value;
}

UE__SRVCC__Capability& UE__SRVCC__Capability::operator=(int other_value)
{
if (!is_valid_enum(other_value)) TTCN_error("Assigning unknown numeric value %d to a variable of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.", other_value);
enum_value = (enum_type)other_value;
return *this;
}

UE__SRVCC__Capability& UE__SRVCC__Capability::operator=(enum_type other_value)
{
enum_value = other_value;
return *this;
}

UE__SRVCC__Capability& UE__SRVCC__Capability::operator=(const UE__SRVCC__Capability& other_value)
{
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
enum_value = other_value.enum_value;
return *this;
}

boolean UE__SRVCC__Capability::operator==(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability comparison is an unknown numeric value %d", other_value);
return enum_value == other_value;
}

boolean UE__SRVCC__Capability::operator==(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
return enum_value == other_value;
}

boolean UE__SRVCC__Capability::operator==(const UE__SRVCC__Capability& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
return enum_value == other_value.enum_value;
}

boolean UE__SRVCC__Capability::operator<(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability comparison is an unknown numeric value %d", other_value);
return enum_value < other_value;
}

boolean UE__SRVCC__Capability::operator<(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
return enum_value < other_value;
}

boolean UE__SRVCC__Capability::operator<(const UE__SRVCC__Capability& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
return enum_value < other_value.enum_value;
}

boolean UE__SRVCC__Capability::operator>(int other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
if (!is_valid_enum(other_value)) TTCN_error("The right operand of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability comparison is an unknown numeric value %d", other_value);
return enum_value > other_value;
}

boolean UE__SRVCC__Capability::operator>(enum_type other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
return enum_value > other_value;
}

boolean UE__SRVCC__Capability::operator>(const UE__SRVCC__Capability& other_value) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("The left operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
if (other_value.enum_value == UNBOUND_VALUE) TTCN_error("The right operand of comparison is an unbound value of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
return enum_value > other_value.enum_value;
}

const char *UE__SRVCC__Capability::enum_to_str(enum_type enum_par)
{
switch (enum_par) {
case ue__srvcc__not__supported: return "ue_srvcc_not_supported";
case ue__srvcc__supported: return "ue_srvcc_supported";
default:
return "<unknown>";
}
}

UE__SRVCC__Capability::enum_type UE__SRVCC__Capability::str_to_enum(const char *str_par, const int* int_par, const int* int_par2)
{
if (int_par == NULL && int_par2 == NULL) {
if (!strcmp(str_par, "ue_srvcc_not_supported")) return ue__srvcc__not__supported;
if (!strcmp(str_par, "ue_srvcc_supported")) return ue__srvcc__supported;
}
return UNKNOWN_VALUE;
}

boolean UE__SRVCC__Capability::is_valid_enum(int int_par)
{
switch (int_par) {
case 0:
case 1:
return TRUE;
default:
return FALSE;
}
}

int UE__SRVCC__Capability::enum2int(enum_type enum_par)
{
if (enum_par==UNBOUND_VALUE || enum_par==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par;
}

int UE__SRVCC__Capability::enum2int(const UE__SRVCC__Capability& enum_par)
{
if (enum_par.enum_value==UNBOUND_VALUE || enum_par.enum_value==UNKNOWN_VALUE) TTCN_error("The argument of function enum2int() is an %s value of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.", enum_par==UNBOUND_VALUE?"unbound":"invalid");
return enum_par.enum_value;
}

void UE__SRVCC__Capability::int2enum(int int_val)
{
if (!is_valid_enum(int_val)) TTCN_error("Assigning invalid numeric value %d to a variable of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.", int_val);
enum_value = (enum_type)int_val;
}

UE__SRVCC__Capability::operator UE__SRVCC__Capability::enum_type() const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Using the value of an unbound variable of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
return enum_value;
}

void UE__SRVCC__Capability::log() const
{
if (enum_value != UNBOUND_VALUE) TTCN_Logger::log_event_enum(enum_to_str(enum_value), enum_value);
else TTCN_Logger::log_event_unbound();
}

void UE__SRVCC__Capability::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "enumerated value");
  if (param.get_type()!=Module_Param::MP_Enumerated) param.type_error("enumerated value", "@MAP-MS-DataTypes.UE-SRVCC-Capability");
  enum_value = str_to_enum(param.get_enumerated(), param.get_enumerated_value());
  if (!is_valid_enum(enum_value)) {
    param.error("Invalid enumerated value for type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
  }
}

void UE__SRVCC__Capability::encode_text(Text_Buf& text_buf) const
{
if (enum_value == UNBOUND_VALUE) TTCN_error("Text encoder: Encoding an unbound value of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
text_buf.push_int(enum_value);
}

void UE__SRVCC__Capability::decode_text(Text_Buf& text_buf)
{
enum_value = (enum_type)text_buf.pull_int().get_val();
if (!is_valid_enum(enum_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.", enum_value);
}

void UE__SRVCC__Capability::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(TRUE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void UE__SRVCC__Capability::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* UE__SRVCC__Capability::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=BER_encode_chk_bound(is_bound());
  if(!new_tlv) {
    BER_encode_chk_enum_valid(p_td, is_valid_enum(enum_value), enum_value);
    new_tlv=BER_encode_TLV_INTEGER(p_coding, enum_value);
  }
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean UE__SRVCC__Capability::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  enum_value = UNBOUND_VALUE;
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec("While decoding ENUMERATED type @MAP-MS-DataTypes.UE-SRVCC-Capability: ");
  int tmp_mfr;
  if (BER_decode_TLV_INTEGER(stripped_tlv, L_form, tmp_mfr)) {
    BER_decode_chk_enum_valid(p_td, is_valid_enum(tmp_mfr), tmp_mfr);
    enum_value = (enum_type)tmp_mfr;
    return TRUE;
  } else return FALSE;
}

int UE__SRVCC__Capability::JSON_encode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean) const
{
  if (enum_value == UNBOUND_VALUE) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
    return -1;
  }

  if (p_td.json->use_null) {
    return p_tok.put_next_token(JSON_TOKEN_LITERAL_NULL);
  }
  char* tmp_str;
  if (p_td.json->as_number) {
    tmp_str = mprintf("%d", enum_value);
  }
  else {
    boolean text_found = false;
    for (size_t i = 0; i < p_td.json->nof_enum_texts; ++i) {
      if (p_td.json->enum_texts[i].index == enum_value) {
        tmp_str = mprintf("\"%s\"", p_td.json->enum_texts[i].text);
        text_found = true;
        break;
      }
    }
    if (!text_found) {
      tmp_str = mprintf("\"%s\"", enum_to_str(enum_value));
    }
  }
  int enc_len = p_tok.put_next_token(p_td.json->as_number ? JSON_TOKEN_NUMBER : JSON_TOKEN_STRING, tmp_str);
  Free(tmp_str);
  return enc_len;
}

int UE__SRVCC__Capability::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean, int)
{
  json_token_t token = JSON_TOKEN_NONE;
  char* value = 0;
  size_t value_len = 0;
  boolean error = FALSE;
  size_t dec_len = 0;
  boolean use_default = FALSE;
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const UE__SRVCC__Capability*>(p_td.json->default_value.val);
    return dec_len;
  }
  if (p_td.json->default_value.type == JD_LEGACY && 0 == p_tok.get_buffer_length()) {
    value = const_cast<char*>(p_td.json->default_value.str);
    value_len = strlen(value);
    use_default = TRUE;
  } else {
    dec_len = p_tok.get_next_token(&token, &value, &value_len);
  }
  if (JSON_TOKEN_ERROR == token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_LITERAL_NULL == token && p_td.json->use_null) {
    enum_value = ue__srvcc__not__supported;
  }
  else if (!p_td.json->use_null && ((JSON_TOKEN_STRING == token && !p_td.json->as_number) || use_default)) {
    if (use_default || (value_len > 2 && value[0] == '\"' && value[value_len - 1] == '\"')) {
      if (!use_default) value[value_len - 1] = 0;
      boolean text_found = false;
      for (size_t i = 0; i < p_td.json->nof_enum_texts; ++i) {
        if (strcmp(p_td.json->enum_texts[i].text, value + (use_default ? 0 : 1)) == 0) {
          enum_value = static_cast<enum_type>(p_td.json->enum_texts[i].index);
          text_found = true;
          break;
        }
      }
      if (!text_found) {
        enum_value = str_to_enum(value + (use_default ? 0 : 1));
      }
      if (!use_default) value[value_len - 1] = '\"';
      if (UNKNOWN_VALUE == enum_value) {
        error = TRUE;
      }
    } else {
      error = TRUE;
    }
  }
  else if (!p_td.json->use_null && JSON_TOKEN_NUMBER == token && p_td.json->as_number) {
    char* value_str = mcopystrn(value, value_len);
    int number = atoi(value_str);
    if (strchr(value_str, '.') != NULL || strchr(value_str, 'e') != NULL || strchr(value_str, 'E') != NULL) {
      error = TRUE;
    }
    else if (is_valid_enum(number)) {
      enum_value = static_cast<enum_type>(number);
    }
    else {
      error = TRUE;
    }
    Free(value_str);
  }
  else {
    enum_value = UNBOUND_VALUE;
    return JSON_ERROR_INVALID_TOKEN;
  }

  if (error) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FORMAT_ERROR, p_td.json->as_number ? "number" : "string", "enumerated");
    enum_value = UNBOUND_VALUE;
    return JSON_ERROR_FATAL;
  }
  return (int)dec_len;
}

int UE__SRVCC__Capability::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (enum_value == UNBOUND_VALUE) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
    return -1;
  }

  if (enum_value >= 0 && enum_value < 128) {
    char c = enum_value;
    p_buf.put_c(c);
  } else {
    INTEGER intval(enum_value);
    TTCN_Buffer buf;
    intval.OER_encode(INTEGER_descr_, buf);
    unsigned char* uc = const_cast<unsigned char*>(buf.get_data());
    *uc |= 1 << 7;
    p_buf.put_buf(buf);
  }
  return 0;
}

int UE__SRVCC__Capability::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  if (!(uc[0] & 0x80)) {
    if (is_valid_enum(uc[0])) {
      enum_value = static_cast<enum_type>(uc[0]);
    } else {
      enum_value = UNKNOWN_VALUE;
    }
    p_buf.increase_pos(1);
  } else {
    unsigned char* uc2 = const_cast<unsigned char*>(p_buf.get_read_data());
    uc2[0] &= ~0x80;
    INTEGER intval;
    intval.OER_decode(INTEGER_descr_, p_buf, p_oer);
    if (is_valid_enum(intval.get_val().get_val())) {
      enum_value = static_cast<enum_type>(intval.get_val().get_val());
    } else {
      enum_value = UNKNOWN_VALUE;
    }
  }
  return 0;
}

void UE__SRVCC__Capability::PER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options) const
{
INTEGER enc_val;
boolean ext_bit = FALSE;
switch (enum_value) {
case ue__srvcc__not__supported:
enc_val = 0;
ext_bit = FALSE;
break;
case ue__srvcc__supported:
enc_val = 1;
ext_bit = FALSE;
break;
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
 "Encoding an unbound or unknown value of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
}
p_buf.PER_put_bit(ext_bit);
if (ext_bit) enc_val.PER_encode_normally_small(p_buf, p_options);
else INTEGER::PER_encode_int(p_buf, enc_val, 1);
}

void UE__SRVCC__Capability::PER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, int p_options)
{
INTEGER dec_val;
boolean ext_bit = p_buf.PER_get_bit();
if (ext_bit) dec_val.PER_decode_normally_small(p_buf, p_options);
else dec_val.PER_decode_unaligned_constrained(p_buf, 1, FALSE);
int dec_int = dec_val;
if (ext_bit) switch (dec_int) {
default: enum_value = UNBOUND_VALUE; break;
}
else switch (dec_int) {
case 0: enum_value = ue__srvcc__not__supported; break;
case 1: enum_value = ue__srvcc__supported; break;
default:
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_INVAL_MSG,
 "Decoded invalid number (%d) for enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.", dec_int);
break;
}
}

void UE__SRVCC__Capability_template::copy_template(const UE__SRVCC__Capability_template& other_value)
{
set_selection(other_value);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = other_value.single_value;
break;
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new UE__SRVCC__Capability_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new UE__SRVCC__Capability_template(*other_value.implication_.precondition);
implication_.implied_template = new UE__SRVCC__Capability_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
}
}

UE__SRVCC__Capability_template::UE__SRVCC__Capability_template()
{
}

UE__SRVCC__Capability_template::UE__SRVCC__Capability_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

UE__SRVCC__Capability_template::UE__SRVCC__Capability_template(int other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (!UE__SRVCC__Capability::is_valid_enum(other_value)) TTCN_error("Initializing a template of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability with unknown numeric value %d.", other_value);
single_value = (UE__SRVCC__Capability::enum_type)other_value;
}

UE__SRVCC__Capability_template::UE__SRVCC__Capability_template(UE__SRVCC__Capability::enum_type other_value)
 : Base_Template(SPECIFIC_VALUE)
{
single_value = other_value;
}

UE__SRVCC__Capability_template::UE__SRVCC__Capability_template(const UE__SRVCC__Capability& other_value)
 : Base_Template(SPECIFIC_VALUE)
{
if (other_value.enum_value == UE__SRVCC__Capability::UNBOUND_VALUE) TTCN_error("Creating a template from an unbound value of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
single_value = other_value.enum_value;
}

UE__SRVCC__Capability_template::UE__SRVCC__Capability_template(const OPTIONAL<UE__SRVCC__Capability>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (UE__SRVCC__Capability::enum_type)(const UE__SRVCC__Capability&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability from an unbound optional field.");
}
}

UE__SRVCC__Capability_template::UE__SRVCC__Capability_template(UE__SRVCC__Capability_template* p_precondition, UE__SRVCC__Capability_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

UE__SRVCC__Capability_template::UE__SRVCC__Capability_template(Dynamic_Match_Interface<UE__SRVCC__Capability>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<UE__SRVCC__Capability>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

UE__SRVCC__Capability_template::UE__SRVCC__Capability_template(const UE__SRVCC__Capability_template& other_value)
 : Base_Template()
{
copy_template(other_value);
}

UE__SRVCC__Capability_template::~UE__SRVCC__Capability_template()
{
clean_up();
}

boolean UE__SRVCC__Capability_template::is_bound() const
{
if (template_selection == UNINITIALIZED_TEMPLATE && !is_ifpresent) return FALSE;
return TRUE;
}

boolean UE__SRVCC__Capability_template::is_value() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) return FALSE;
return single_value != UE__SRVCC__Capability::UNBOUND_VALUE;
}

void UE__SRVCC__Capability_template::clean_up()
{
switch (template_selection) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
delete [] value_list.list_value;
break;
case IMPLICATION_MATCH:
delete implication_.precondition;
delete implication_.implied_template;
break;
case DYNAMIC_MATCH:
dyn_match->ref_count--;
if (dyn_match->ref_count == 0) {
delete dyn_match->ptr;
delete dyn_match;
}
break;
default:
break;
}
template_selection = UNINITIALIZED_TEMPLATE;
}

UE__SRVCC__Capability_template& UE__SRVCC__Capability_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

UE__SRVCC__Capability_template& UE__SRVCC__Capability_template::operator=(int other_value)
{
if (!UE__SRVCC__Capability::is_valid_enum(other_value)) TTCN_warning("Assigning unknown numeric value %d to a template of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.", other_value);
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = (UE__SRVCC__Capability::enum_type)other_value;
return *this;
}

UE__SRVCC__Capability_template& UE__SRVCC__Capability_template::operator=(UE__SRVCC__Capability::enum_type other_value)
{
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value;
return *this;
}

UE__SRVCC__Capability_template& UE__SRVCC__Capability_template::operator=(const UE__SRVCC__Capability& other_value)
{
if (other_value.enum_value == UE__SRVCC__Capability::UNBOUND_VALUE) TTCN_error("Assignment of an unbound value of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability to a template.");
clean_up();
set_selection(SPECIFIC_VALUE);
single_value = other_value.enum_value;
return *this;
}

UE__SRVCC__Capability_template& UE__SRVCC__Capability_template::operator=(const OPTIONAL<UE__SRVCC__Capability>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
set_selection(SPECIFIC_VALUE);
single_value = (UE__SRVCC__Capability::enum_type)(const UE__SRVCC__Capability&)other_value;
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
}
return *this;
}

UE__SRVCC__Capability_template& UE__SRVCC__Capability_template::operator=(const UE__SRVCC__Capability_template& other_value)
{
if (&other_value != this) {
clean_up();
copy_template(other_value);
}
return *this;
}

boolean UE__SRVCC__Capability_template::match(UE__SRVCC__Capability::enum_type other_value, boolean) const
{
switch (template_selection) {
case SPECIFIC_VALUE:
return single_value == other_value;
case OMIT_VALUE:
return FALSE;
case ANY_VALUE:
case ANY_OR_OMIT:
return TRUE;
case VALUE_LIST:
case COMPLEMENTED_LIST:
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
if (value_list.list_value[list_count].match(other_value)) return template_selection == VALUE_LIST;
return template_selection == COMPLEMENTED_LIST;
case CONJUNCTION_MATCH:
for (unsigned int i = 0; i < value_list.n_values; i++) {
if (!value_list.list_value[i].match(other_value)) {
return FALSE;
}
}
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match(other_value) || implication_.implied_template->match(other_value);
case DYNAMIC_MATCH:
return dyn_match->ptr->match(other_value);
default:
TTCN_error("Matching an uninitialized/unsupported template of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
}
return FALSE;
}

boolean UE__SRVCC__Capability_template::match(const UE__SRVCC__Capability& other_value, boolean) const
{
if (other_value.enum_value == UE__SRVCC__Capability::UNBOUND_VALUE) TTCN_error("Matching a template of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability with an unbound value.");
return match(other_value.enum_value);
}

UE__SRVCC__Capability::enum_type UE__SRVCC__Capability_template::valueof() const
{
if (template_selection != SPECIFIC_VALUE || is_ifpresent) TTCN_error("Performing a valueof or send operation on a non-specific template of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
return single_value;
}

void UE__SRVCC__Capability_template::set_type(template_sel template_type, unsigned int list_length)
{
clean_up();
switch (template_type) {
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
set_selection(template_type);
value_list.n_values = list_length;
value_list.list_value = new UE__SRVCC__Capability_template[list_length];
break;
default:
TTCN_error("Setting an invalid type for a template of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
}
}

UE__SRVCC__Capability_template& UE__SRVCC__Capability_template::list_item(unsigned int list_index)
{
if (template_selection != VALUE_LIST && template_selection != COMPLEMENTED_LIST && template_selection != CONJUNCTION_MATCH) TTCN_error("Accessing a list element in a non-list template of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
if (list_index >= value_list.n_values) TTCN_error("Index overflow in a value list template of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
return value_list.list_value[list_index];
}

void UE__SRVCC__Capability_template::log() const
{
switch (template_selection) {
case SPECIFIC_VALUE:
TTCN_Logger::log_event_enum(UE__SRVCC__Capability::enum_to_str(single_value), single_value);
break;
case COMPLEMENTED_LIST:
TTCN_Logger::log_event_str("complement");
case CONJUNCTION_MATCH:
if (template_selection == CONJUNCTION_MATCH) {
TTCN_Logger::log_event_str("conjunct");
}
case VALUE_LIST:
TTCN_Logger::log_char('(');
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++) {
if (elem_count > 0) TTCN_Logger::log_event_str(", ");
value_list.list_value[elem_count].log();
}
TTCN_Logger::log_char(')');
break;
case IMPLICATION_MATCH:
implication_.precondition->log();
TTCN_Logger::log_event_str(" implies ");
implication_.implied_template->log();
break;
case DYNAMIC_MATCH:
TTCN_Logger::log_event_str("@dynamic template");
break;
default:
log_generic();
}
log_ifpresent();
}

void UE__SRVCC__Capability_template::log_match(const UE__SRVCC__Capability& match_value, boolean) const
{
match_value.log();
TTCN_Logger::log_event_str(" with ");
log();
if (match(match_value)) TTCN_Logger::log_event_str(" matched");
else TTCN_Logger::log_event_str(" unmatched");
}

void UE__SRVCC__Capability_template::encode_text(Text_Buf& text_buf) const
{
encode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
text_buf.push_int(single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
text_buf.push_int(value_list.n_values);
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].encode_text(text_buf);
break;
default:
TTCN_error("Text encoder: Encoding an uninitialized/unsupported template of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
}
}

void UE__SRVCC__Capability_template::decode_text(Text_Buf& text_buf)
{
clean_up();
decode_text_base(text_buf);
switch (template_selection) {
case SPECIFIC_VALUE:
single_value = (UE__SRVCC__Capability::enum_type)text_buf.pull_int().get_val();
if (!UE__SRVCC__Capability::is_valid_enum(single_value)) TTCN_error("Text decoder: Unknown numeric value %d was received for a template of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.", single_value);
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
value_list.n_values = text_buf.pull_int().get_val();
value_list.list_value = new UE__SRVCC__Capability_template[value_list.n_values];
for (unsigned int elem_count = 0; elem_count < value_list.n_values; elem_count++)
value_list.list_value[elem_count].decode_text(text_buf);
break;
default:
TTCN_error("Text decoder: An unknown/unsupported selection was received for a template of enumerated type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
}
}

boolean UE__SRVCC__Capability_template::is_present(boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return FALSE;
return !match_omit(legacy);
}

boolean UE__SRVCC__Capability_template::match_omit(boolean legacy) const
{
if (is_ifpresent) return TRUE;
switch (template_selection) {
case OMIT_VALUE:
case ANY_OR_OMIT:
return TRUE;
case IMPLICATION_MATCH:
return !implication_.precondition->match_omit() || implication_.implied_template->match_omit();
case VALUE_LIST:
case COMPLEMENTED_LIST:
if (legacy) {
for (unsigned int i=0; i<value_list.n_values; i++)
if (value_list.list_value[i].match_omit())
return template_selection==VALUE_LIST;
return template_selection==COMPLEMENTED_LIST;
} // else fall through
default:
return FALSE;
}
return FALSE;
}

void UE__SRVCC__Capability_template::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_TEMPLATE, "enumerated template");
  Module_Param_Ptr m_p = &param;
  switch (m_p->get_type()) {
  case Module_Param::MP_Omit:
    *this = OMIT_VALUE;
    break;
  case Module_Param::MP_Any:
    *this = ANY_VALUE;
    break;
  case Module_Param::MP_AnyOrNone:
    *this = ANY_OR_OMIT;
    break;
  case Module_Param::MP_List_Template:
  case Module_Param::MP_ComplementList_Template:
  case Module_Param::MP_ConjunctList_Template: {
    UE__SRVCC__Capability_template new_temp;
    new_temp.set_type(m_p->get_type()==Module_Param::MP_List_Template ? VALUE_LIST : (m_p->get_type() == Module_Param::MP_ConjunctList_Template ? CONJUNCTION_MATCH : COMPLEMENTED_LIST), m_p->get_size());
    for (size_t p_i=0; p_i<m_p->get_size(); p_i++) {
      new_temp.list_item(p_i).set_param(*m_p->get_elem(p_i));
    }
    *this = new_temp;
    break; }
  case Module_Param::MP_Enumerated: {
    UE__SRVCC__Capability::enum_type enum_val = UE__SRVCC__Capability::str_to_enum(m_p->get_enumerated(), m_p->get_enumerated_value());
    if (!UE__SRVCC__Capability::is_valid_enum(enum_val)) {
      param.error("Invalid enumerated value for type @MAP-MS-DataTypes.UE-SRVCC-Capability.");
    }
    *this = enum_val;
  } break;
  case Module_Param::MP_Implication_Template: {
    UE__SRVCC__Capability_template* precondition = new UE__SRVCC__Capability_template;
    precondition->set_param(*m_p->get_elem(0));
    UE__SRVCC__Capability_template* implied_template = new UE__SRVCC__Capability_template;
    implied_template->set_param(*m_p->get_elem(1));
    *this = UE__SRVCC__Capability_template(precondition, implied_template);
  } break;
  default:
    param.type_error("enumerated template", "@MAP-MS-DataTypes.UE-SRVCC-Capability");
  }
  is_ifpresent = param.get_ifpresent();
}

void UE__SRVCC__Capability_template::check_restriction(template_res t_res, const char* t_name,
boolean legacy) const
{
if (template_selection==UNINITIALIZED_TEMPLATE) return;
switch ((t_name&&(t_res==TR_VALUE))?TR_OMIT:t_res) {
case TR_VALUE:
if (!is_ifpresent && template_selection==SPECIFIC_VALUE) return;
break;
case TR_OMIT:
if (!is_ifpresent && (template_selection==OMIT_VALUE || template_selection==SPECIFIC_VALUE)) return;
break;
case TR_PRESENT:
if (!match_omit(legacy)) return;
break;
default:
return;
}
TTCN_error("Restriction `%s' on template of type %s violated.", get_res_name(t_res), t_name ? t_name : "@MAP-MS-DataTypes.UE-SRVCC-Capability");
}

UpdateGprsLocationRes::UpdateGprsLocationRes()
{
}

UpdateGprsLocationRes::UpdateGprsLocationRes(const OCTETSTRING& par_hlr__Number,
    const OPTIONAL< MAP__ExtensionDataTypes::ExtensionContainer >& par_extensionContainer,
    const OPTIONAL< ASN_NULL >& par_add__Capability,
    const OPTIONAL< ASN_NULL >& par_sgsn__mmeSeparationSupported)
  :   field_hlr__Number(par_hlr__Number),
  field_extensionContainer(par_extensionContainer),
  field_add__Capability(par_add__Capability),
  field_sgsn__mmeSeparationSupported(par_sgsn__mmeSeparationSupported)
{
}

UpdateGprsLocationRes::UpdateGprsLocationRes(const UpdateGprsLocationRes& other_value)
{
if(!other_value.is_bound()) TTCN_error("Copying an unbound value of type @MAP-MS-DataTypes.UpdateGprsLocationRes.");
if (other_value.hlr__Number().is_bound()) field_hlr__Number = other_value.hlr__Number();
else field_hlr__Number.clean_up();
if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
else field_extensionContainer.clean_up();
if (other_value.add__Capability().is_bound()) field_add__Capability = other_value.add__Capability();
else field_add__Capability.clean_up();
if (other_value.sgsn__mmeSeparationSupported().is_bound()) field_sgsn__mmeSeparationSupported = other_value.sgsn__mmeSeparationSupported();
else field_sgsn__mmeSeparationSupported.clean_up();
}

void UpdateGprsLocationRes::clean_up()
{
field_hlr__Number.clean_up();
field_extensionContainer.clean_up();
field_add__Capability.clean_up();
field_sgsn__mmeSeparationSupported.clean_up();
}

const TTCN_Typedescriptor_t* UpdateGprsLocationRes::get_descriptor() const { return &UpdateGprsLocationRes_descr_; }
UpdateGprsLocationRes& UpdateGprsLocationRes::operator=(const UpdateGprsLocationRes& other_value)
{
if (this != &other_value) {
  if(!other_value.is_bound()) TTCN_error("Assignment of an unbound value of type @MAP-MS-DataTypes.UpdateGprsLocationRes.");
  if (other_value.hlr__Number().is_bound()) field_hlr__Number = other_value.hlr__Number();
  else field_hlr__Number.clean_up();
  if (other_value.extensionContainer().is_bound()) field_extensionContainer = other_value.extensionContainer();
  else field_extensionContainer.clean_up();
  if (other_value.add__Capability().is_bound()) field_add__Capability = other_value.add__Capability();
  else field_add__Capability.clean_up();
  if (other_value.sgsn__mmeSeparationSupported().is_bound()) field_sgsn__mmeSeparationSupported = other_value.sgsn__mmeSeparationSupported();
  else field_sgsn__mmeSeparationSupported.clean_up();
}
return *this;
}

boolean UpdateGprsLocationRes::operator==(const UpdateGprsLocationRes& other_value) const
{
return field_hlr__Number==other_value.field_hlr__Number
  && field_extensionContainer==other_value.field_extensionContainer
  && field_add__Capability==other_value.field_add__Capability
  && field_sgsn__mmeSeparationSupported==other_value.field_sgsn__mmeSeparationSupported;
}

boolean UpdateGprsLocationRes::is_bound() const
{
return (field_hlr__Number.is_bound())
  || (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_bound())
  || (OPTIONAL_OMIT == field_add__Capability.get_selection() || field_add__Capability.is_bound())
  || (OPTIONAL_OMIT == field_sgsn__mmeSeparationSupported.get_selection() || field_sgsn__mmeSeparationSupported.is_bound());
}
boolean UpdateGprsLocationRes::is_value() const
{
return field_hlr__Number.is_value()
  && (OPTIONAL_OMIT == field_extensionContainer.get_selection() || field_extensionContainer.is_value())
  && (OPTIONAL_OMIT == field_add__Capability.get_selection() || field_add__Capability.is_value())
  && (OPTIONAL_OMIT == field_sgsn__mmeSeparationSupported.get_selection() || field_sgsn__mmeSeparationSupported.is_value());
}
int UpdateGprsLocationRes::size_of() const
{
  int ret_val = 1;
  if (field_extensionContainer.ispresent()) ret_val++;
  if (field_add__Capability.ispresent()) ret_val++;
  if (field_sgsn__mmeSeparationSupported.ispresent()) ret_val++;
  return ret_val;
}

void UpdateGprsLocationRes::log() const
{
if (!is_bound()) {
TTCN_Logger::log_event_unbound();
return;
}
TTCN_Logger::log_event_str("{ hlr_Number := ");
field_hlr__Number.log();
TTCN_Logger::log_event_str(", extensionContainer := ");
field_extensionContainer.log();
TTCN_Logger::log_event_str(", add_Capability := ");
field_add__Capability.log();
TTCN_Logger::log_event_str(", sgsn_mmeSeparationSupported := ");
field_sgsn__mmeSeparationSupported.log();
TTCN_Logger::log_event_str(" }");
}

void UpdateGprsLocationRes::set_implicit_omit()
{
if (hlr__Number().is_bound()) hlr__Number().set_implicit_omit();
if (!extensionContainer().is_bound()) extensionContainer() = OMIT_VALUE;
else extensionContainer().set_implicit_omit();
if (!add__Capability().is_bound()) add__Capability() = OMIT_VALUE;
else add__Capability().set_implicit_omit();
if (!sgsn__mmeSeparationSupported().is_bound()) sgsn__mmeSeparationSupported() = OMIT_VALUE;
else sgsn__mmeSeparationSupported().set_implicit_omit();
}

void UpdateGprsLocationRes::set_param(Module_Param& param)
{
  param.basic_check(Module_Param::BC_VALUE, "record value");
  switch (param.get_type()) {
  case Module_Param::MP_Value_List:
    if (4<param.get_size()) {
      param.error("record value of type @MAP-MS-DataTypes.UpdateGprsLocationRes has 4 fields but list value has %d fields", (int)param.get_size());
    }
    if (param.get_size()>0 && param.get_elem(0)->get_type()!=Module_Param::MP_NotUsed) hlr__Number().set_param(*param.get_elem(0));
    if (param.get_size()>1 && param.get_elem(1)->get_type()!=Module_Param::MP_NotUsed) extensionContainer().set_param(*param.get_elem(1));
    if (param.get_size()>2 && param.get_elem(2)->get_type()!=Module_Param::MP_NotUsed) add__Capability().set_param(*param.get_elem(2));
    if (param.get_size()>3 && param.get_elem(3)->get_type()!=Module_Param::MP_NotUsed) sgsn__mmeSeparationSupported().set_param(*param.get_elem(3));
    break;
  case Module_Param::MP_Assignment_List: {
    Vector<bool> value_used(param.get_size());
    value_used.resize(param.get_size(), FALSE);
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "hlr_Number")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          hlr__Number().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "extensionContainer")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          extensionContainer().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "add_Capability")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          add__Capability().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      if (!strcmp(curr_param->get_id()->get_name(), "sgsn_mmeSeparationSupported")) {
        if (curr_param->get_type()!=Module_Param::MP_NotUsed) {
          sgsn__mmeSeparationSupported().set_param(*curr_param);
        }
        value_used[val_idx]=TRUE;
      }
    }
    for (size_t val_idx=0; val_idx<param.get_size(); val_idx++) if (!value_used[val_idx]) {
      Module_Param* const curr_param = param.get_elem(val_idx);
      curr_param->error("Non existent field name in type @MAP-MS-DataTypes.UpdateGprsLocationRes: %s", curr_param->get_id()->get_name());
      break;
    }
  } break;
  default:
    param.type_error("record value", "@MAP-MS-DataTypes.UpdateGprsLocationRes");
  }
}

void UpdateGprsLocationRes::encode_text(Text_Buf& text_buf) const
{
field_hlr__Number.encode_text(text_buf);
field_extensionContainer.encode_text(text_buf);
field_add__Capability.encode_text(text_buf);
field_sgsn__mmeSeparationSupported.encode_text(text_buf);
}

void UpdateGprsLocationRes::decode_text(Text_Buf& text_buf)
{
field_hlr__Number.decode_text(text_buf);
field_extensionContainer.decode_text(text_buf);
field_add__Capability.decode_text(text_buf);
field_sgsn__mmeSeparationSupported.decode_text(text_buf);
}

void UpdateGprsLocationRes::encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...) const
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-encoding type '%s': ", p_td.name);
    unsigned BER_coding=va_arg(pvar, unsigned);
    BER_encode_chk_coding(BER_coding);
    ASN_BER_TLV_t *tlv=BER_encode_TLV(p_td, BER_coding);
    tlv->put_in_buffer(p_buf);
    ASN_BER_TLV_t::destruct(tlv);
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-encoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    RAW_enc_tr_pos rp;
    rp.level=0;
    rp.pos=NULL;
    RAW_enc_tree root(FALSE, NULL, &rp, 1, p_td.raw);
    RAW_encode(p_td, root);
    root.put_to_buf(p_buf);
    break;}
  case TTCN_EncDec::CT_TEXT: {
    TTCN_EncDec_ErrorContext ec("While TEXT-encoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
      ("No TEXT descriptor available for type '%s'.", p_td.name);
    TEXT_encode(p_td,p_buf);
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-encoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XER_encode(*(p_td.xer),p_buf, XER_coding, 0, 0, 0);
    p_buf.put_c('\n');
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-encoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok(va_arg(pvar, int) != 0);
    JSON_encode(p_td, tok, FALSE);
    p_buf.put_s(tok.get_buffer_length(), (const unsigned char*)tok.get_buffer());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-encoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
    OER_encode(p_td, p_buf);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-encoding type '%s': ", p_td.name);
    if (!p_td.per) TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    PER_encode(p_td, p_buf, opt);
    break; }
  default:
    TTCN_error("Unknown coding method requested to encode type '%s'", p_td.name);
  }
  va_end(pvar);
}

void UpdateGprsLocationRes::decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_coding, ...)
{
  va_list pvar;
  va_start(pvar, p_coding);
  switch(p_coding) {
  case TTCN_EncDec::CT_BER: {
    TTCN_EncDec_ErrorContext ec("While BER-decoding type '%s': ", p_td.name);
    unsigned L_form=va_arg(pvar, unsigned);
    ASN_BER_TLV_t tlv;
    BER_decode_str2TLV(p_buf, tlv, L_form);
    BER_decode_TLV(p_td, tlv, L_form);
    if(tlv.isComplete) p_buf.increase_pos(tlv.get_len());
    break;}
  case TTCN_EncDec::CT_RAW: {
    TTCN_EncDec_ErrorContext ec("While RAW-decoding type '%s': ", p_td.name);
    if(!p_td.raw)
      TTCN_EncDec_ErrorContext::error_internal
        ("No RAW descriptor available for type '%s'.", p_td.name);
    raw_order_t r_order;
    switch(p_td.raw->top_bit_order) {
    case TOP_BIT_LEFT:
      r_order=ORDER_LSB;
      break;
    case TOP_BIT_RIGHT:
    default:
      r_order=ORDER_MSB;
    }
    int rawr = RAW_decode(p_td, p_buf, p_buf.get_len()*8, r_order);
    if(rawr<0) switch (-rawr) {
    case TTCN_EncDec::ET_INCOMPL_MSG:
    case TTCN_EncDec::ET_LEN_ERR:
      ec.error((TTCN_EncDec::error_type_t)-rawr, "Can not decode type '%s', because incomplete message was received", p_td.name);
      break;
    case 1:
    default:
      ec.error(TTCN_EncDec::ET_INVAL_MSG, "Can not decode type '%s', because invalid message was received", p_td.name);
      break;
    }
    break;}
  case TTCN_EncDec::CT_TEXT: {
    Limit_Token_List limit;
    TTCN_EncDec_ErrorContext ec("While TEXT-decoding type '%s': ", p_td.name);
    if(!p_td.text)
      TTCN_EncDec_ErrorContext::error_internal
        ("No TEXT descriptor available for type '%s'.", p_td.name);
    const unsigned char *b_data=p_buf.get_data();
    int null_added=0;
    if(b_data[p_buf.get_len()-1]!='\0'){
      null_added=1;
      p_buf.set_pos(p_buf.get_len());
      p_buf.put_zero(8,ORDER_LSB);
      p_buf.rewind();
    }
    if(TEXT_decode(p_td,p_buf,limit)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    if(null_added){
      size_t actpos=p_buf.get_pos();
      p_buf.set_pos(p_buf.get_len()-1);
      p_buf.cut_end();
      p_buf.set_pos(actpos);
    }
    break;}
  case TTCN_EncDec::CT_XER: {
    TTCN_EncDec_ErrorContext ec("While XER-decoding type '%s': ", p_td.name);
    unsigned XER_coding=va_arg(pvar, unsigned);
    XER_encode_chk_coding(XER_coding, p_td);
    XmlReaderWrap reader(p_buf);
    for (int rd_ok=reader.Read(); rd_ok==1; rd_ok=reader.Read()) {
      if (reader.NodeType() == XML_READER_TYPE_ELEMENT) break;
    }
    XER_decode(*(p_td.xer), reader, XER_coding | XER_TOPLEVEL, XER_NONE, 0);
    size_t bytes = reader.ByteConsumed();
    p_buf.set_pos(bytes);
    break;}
  case TTCN_EncDec::CT_JSON: {
    TTCN_EncDec_ErrorContext ec("While JSON-decoding type '%s': ", p_td.name);
    if(!p_td.json)
      TTCN_EncDec_ErrorContext::error_internal
        ("No JSON descriptor available for type '%s'.", p_td.name);
    JSON_Tokenizer tok((const char*)p_buf.get_data(), p_buf.get_len());
    if(JSON_decode(p_td, tok, FALSE, FALSE)<0)
      ec.error(TTCN_EncDec::ET_INCOMPL_MSG,"Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
    p_buf.set_pos(tok.get_buf_pos());
    break;}
  case TTCN_EncDec::CT_OER: {
    TTCN_EncDec_ErrorContext ec("While OER-decoding type '%s': ", p_td.name);
    if(!p_td.oer)
      TTCN_EncDec_ErrorContext::error_internal
        ("No OER descriptor available for type '%s'.", p_td.name);
     OER_struct p_oer;
    OER_decode(p_td, p_buf, p_oer);
    break;}
  case TTCN_EncDec::CT_PER: {
    TTCN_EncDec_ErrorContext ec("While PER-decoding type '%s': ", p_td.name);
    if(!p_td.per)  TTCN_EncDec_ErrorContext::error_internal(
      "No PER descriptor available for type '%s'.", p_td.name);
    int opt = va_arg(pvar, int);
    try {
      PER_decode(p_td, p_buf, opt);
      p_buf.PER_octet_align(FALSE);
    }
    catch (PER_Buffer_Exception) { }
    break; }
  default:
    TTCN_error("Unknown coding method requested to decode type '%s'", p_td.name);
  }
  va_end(pvar);
}

ASN_BER_TLV_t* UpdateGprsLocationRes::BER_encode_TLV(const TTCN_Typedescriptor_t& p_td, unsigned p_coding) const
{
  if (!is_bound()) TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound value.");
  BER_chk_descr(p_td);
  ASN_BER_TLV_t *new_tlv=ASN_BER_TLV_t::construct(NULL);
  TTCN_EncDec_ErrorContext ec_0("Component '");
  TTCN_EncDec_ErrorContext ec_1;
  ec_1.set_msg("hlr_Number': ");
  new_tlv->add_TLV(field_hlr__Number.BER_encode_TLV(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_coding));
  ec_1.set_msg("extensionContainer': ");
  new_tlv->add_TLV(field_extensionContainer.BER_encode_TLV(UpdateGprsLocationRes_extensionContainer_descr_, p_coding));
  ec_1.set_msg("add_Capability': ");
  new_tlv->add_TLV(field_add__Capability.BER_encode_TLV(ASN_NULL_descr_, p_coding));
  ec_1.set_msg("sgsn_mmeSeparationSupported': ");
  new_tlv->add_TLV(field_sgsn__mmeSeparationSupported.BER_encode_TLV(UpdateGprsLocationRes_sgsn__mmeSeparationSupported_descr_, p_coding));
  new_tlv=ASN_BER_V2TLV(new_tlv, p_td, p_coding);
  return new_tlv;
}

boolean UpdateGprsLocationRes::BER_decode_TLV(const TTCN_Typedescriptor_t& p_td, const ASN_BER_TLV_t& p_tlv, unsigned L_form)
{
  BER_chk_descr(p_td);
  ASN_BER_TLV_t stripped_tlv;
  BER_decode_strip_tags(*p_td.ber, p_tlv, L_form, stripped_tlv);
  TTCN_EncDec_ErrorContext ec_0("While decoding '@MAP-MS-DataTypes.UpdateGprsLocationRes' type: ");
  stripped_tlv.chk_constructed_flag(TRUE);
  size_t V_pos=0;
  ASN_BER_TLV_t tmp_tlv;
  boolean tlv_present=FALSE;
  {
    TTCN_EncDec_ErrorContext ec_1("Component '");
    TTCN_EncDec_ErrorContext ec_2;
    ec_2.set_msg("hlr_Number': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present){
      ec_2.error(TTCN_EncDec::ET_INCOMPL_MSG,"Invalid or incomplete message was received.");
      return FALSE;
    }
    field_hlr__Number.BER_decode_TLV(MAP__CommonDataTypes::ISDN__AddressString_descr_, tmp_tlv, L_form);
    tlv_present=FALSE;
    ec_2.set_msg("extensionContainer': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_extensionContainer=OMIT_VALUE;
    else {
      field_extensionContainer.BER_decode_TLV(UpdateGprsLocationRes_extensionContainer_descr_, tmp_tlv, L_form);
      if(field_extensionContainer.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("add_Capability': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_add__Capability=OMIT_VALUE;
    else {
      field_add__Capability.BER_decode_TLV(ASN_NULL_descr_, tmp_tlv, L_form);
      if(field_add__Capability.ispresent()) tlv_present=FALSE;
    }
    ec_2.set_msg("sgsn_mmeSeparationSupported': ");
    if(!tlv_present) tlv_present=BER_decode_constdTLV_next(stripped_tlv, V_pos, L_form, tmp_tlv);
    if(!tlv_present) field_sgsn__mmeSeparationSupported=OMIT_VALUE;
    else {
      field_sgsn__mmeSeparationSupported.BER_decode_TLV(UpdateGprsLocationRes_sgsn__mmeSeparationSupported_descr_, tmp_tlv, L_form);
      if(field_sgsn__mmeSeparationSupported.ispresent()) tlv_present=FALSE;
    }
  }
  BER_decode_constdTLV_end(stripped_tlv, V_pos, L_form, tmp_tlv, tlv_present);
  return TRUE;
}

int UpdateGprsLocationRes::JSON_encode(const TTCN_Typedescriptor_t&, JSON_Tokenizer& p_tok, boolean p_parent_is_map) const
{
  if (!is_bound()) {
    TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
      "Encoding an unbound value of type @MAP-MS-DataTypes.UpdateGprsLocationRes.");
    return -1;
  }

  int enc_len = p_tok.put_next_token(JSON_TOKEN_OBJECT_START, NULL);

  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "hlr_Number");
    enc_len += field_hlr__Number.JSON_encode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_tok, FALSE);
  }

  if (field_extensionContainer.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "extensionContainer");
    enc_len += field_extensionContainer.JSON_encode(UpdateGprsLocationRes_extensionContainer_descr_, p_tok, FALSE);
  }

  if (field_add__Capability.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "add_Capability");
    enc_len += field_add__Capability.JSON_encode(ASN_NULL_descr_, p_tok, FALSE);
  }

  if (field_sgsn__mmeSeparationSupported.is_present())
  {
    enc_len += p_tok.put_next_token(JSON_TOKEN_NAME, "sgsn_mmeSeparationSupported");
    enc_len += field_sgsn__mmeSeparationSupported.JSON_encode(UpdateGprsLocationRes_sgsn__mmeSeparationSupported_descr_, p_tok, FALSE);
  }

  enc_len += p_tok.put_next_token(JSON_TOKEN_OBJECT_END, NULL);
  return enc_len;
}

int UpdateGprsLocationRes::JSON_decode(const TTCN_Typedescriptor_t& p_td, JSON_Tokenizer& p_tok, boolean p_silent, boolean p_parent_is_map, int)
{
  if (p_td.json->default_value.type == JD_STANDARD && 0 == p_tok.get_buffer_length()) {
    *this = *static_cast<const UpdateGprsLocationRes*>(p_td.json->default_value.val);
    return 0;
  }
  json_token_t j_token = JSON_TOKEN_NONE;
  size_t dec_len = p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_ERROR == j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_BAD_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }
  else if (JSON_TOKEN_OBJECT_START != j_token) {
    return JSON_ERROR_INVALID_TOKEN;
  }
  boolean hlr__Number_found = FALSE;
  boolean extensionContainer_found = FALSE;
  boolean add__Capability_found = FALSE;
  boolean sgsn__mmeSeparationSupported_found = FALSE;

  while (TRUE) {
    char* fld_name = 0;
    size_t name_len = 0;
    size_t buf_pos = p_tok.get_buf_pos();
    dec_len += p_tok.get_next_token(&j_token, &fld_name, &name_len);
    if (JSON_TOKEN_ERROR == j_token) {
      JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_NAME_TOKEN_ERROR);
      return JSON_ERROR_FATAL;
    }
    else if (JSON_TOKEN_NAME != j_token) {
      p_tok.set_buf_pos(buf_pos);
      break;
    }
    else {
      if (10 == name_len && 0 == strncmp(fld_name, "hlr_Number", name_len)) {
        hlr__Number_found = TRUE;
         int ret_val = field_hlr__Number.JSON_decode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 10, "hlr_Number");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (18 == name_len && 0 == strncmp(fld_name, "extensionContainer", name_len)) {
        extensionContainer_found = TRUE;
         int ret_val = field_extensionContainer.JSON_decode(UpdateGprsLocationRes_extensionContainer_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 18, "extensionContainer");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (14 == name_len && 0 == strncmp(fld_name, "add_Capability", name_len)) {
        add__Capability_found = TRUE;
         int ret_val = field_add__Capability.JSON_decode(ASN_NULL_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 14, "add_Capability");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else if (27 == name_len && 0 == strncmp(fld_name, "sgsn_mmeSeparationSupported", name_len)) {
        sgsn__mmeSeparationSupported_found = TRUE;
         int ret_val = field_sgsn__mmeSeparationSupported.JSON_decode(UpdateGprsLocationRes_sgsn__mmeSeparationSupported_descr_, p_tok, p_silent, FALSE);
         if (0 > ret_val) {
           if (JSON_ERROR_INVALID_TOKEN == ret_val) {
             JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, 27, "sgsn_mmeSeparationSupported");
           }
           return JSON_ERROR_FATAL;
         }
         dec_len += (size_t)ret_val;
      }
      else {
        if (p_silent) {
          return JSON_ERROR_INVALID_TOKEN;
        }
        JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_INVALID_NAME_ERROR, (int)name_len, fld_name);
        dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
        if (JSON_TOKEN_NUMBER != j_token && JSON_TOKEN_STRING != j_token &&
            JSON_TOKEN_LITERAL_TRUE != j_token && JSON_TOKEN_LITERAL_FALSE != j_token &&
            JSON_TOKEN_LITERAL_NULL != j_token) {
          JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_FIELD_TOKEN_ERROR, (int)name_len, fld_name);
          return JSON_ERROR_FATAL;
        }
      }
    }
  }

  dec_len += p_tok.get_next_token(&j_token, NULL, NULL);
  if (JSON_TOKEN_OBJECT_END != j_token) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_OBJECT_END_TOKEN_ERROR, "");
    return JSON_ERROR_FATAL;
  }

  if (!hlr__Number_found) {
    JSON_ERROR(TTCN_EncDec::ET_INVAL_MSG, JSON_DEC_MISSING_FIELD_ERROR, "hlr_Number");
    return JSON_ERROR_FATAL;
  }
  if (!extensionContainer_found) {
    field_extensionContainer = OMIT_VALUE;
  }
  if (!add__Capability_found) {
    field_add__Capability = OMIT_VALUE;
  }
  if (!sgsn__mmeSeparationSupported_found) {
    field_sgsn__mmeSeparationSupported = OMIT_VALUE;
  }
  
  return (int)dec_len;
}

int UpdateGprsLocationRes::OER_encode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf) const
{
  if (!is_bound()) {
  TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND,
    "Encoding an unbound record value.");
  return -1;
  }
  boolean has_extension = FALSE;
  has_extension = has_extension || (field_add__Capability.is_bound() && field_add__Capability.is_present());
  has_extension = has_extension || (field_sgsn__mmeSeparationSupported.is_bound() && field_sgsn__mmeSeparationSupported.is_present());
  char c = 0;
  if (has_extension) {
    c |= 128;
  }
  if (field_extensionContainer.is_present()) {
    c |= 64;
  }
  p_buf.put_c(c);
  field_hlr__Number.OER_encode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_buf);
  if (field_extensionContainer.is_present())
    field_extensionContainer.OER_encode(UpdateGprsLocationRes_extensionContainer_descr_, p_buf);
  if (has_extension) {
    TTCN_Buffer tmp_buf;
    TTCN_Buffer tmp_buf2;
    TTCN_Buffer tmp_buf3;
    c = 0;
    if (field_add__Capability.is_present()) {
      c |= 128;
      field_add__Capability.OER_encode(ASN_NULL_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    if (field_sgsn__mmeSeparationSupported.is_present()) {
      c |= 64;
      field_sgsn__mmeSeparationSupported.OER_encode(UpdateGprsLocationRes_sgsn__mmeSeparationSupported_descr_, tmp_buf2);
      encode_oer_length(tmp_buf2.get_len(), tmp_buf, FALSE);
      tmp_buf.put_buf(tmp_buf2);
      tmp_buf2.clear();
    }
    tmp_buf3.put_c(c);
    encode_oer_length(2, p_buf, FALSE);
    p_buf.put_c(6);
    p_buf.put_buf(tmp_buf3);
    p_buf.put_buf(tmp_buf);
    tmp_buf.clear();
  }
  return 0;
}

int UpdateGprsLocationRes::OER_decode(const TTCN_Typedescriptor_t&, TTCN_Buffer& p_buf, OER_struct& p_oer)
{
  const unsigned char* uc = p_buf.get_read_data();
  p_buf.increase_pos(1);
  boolean has_extension = FALSE;
  if (uc[0] & 0x80) {
    has_extension = TRUE;
  }
  field_hlr__Number.OER_decode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_buf, p_oer);
  if (uc[0] & 64)
    field_extensionContainer.OER_decode(UpdateGprsLocationRes_extensionContainer_descr_, p_buf, p_oer);
 else
    field_extensionContainer = OMIT_VALUE;
  if (has_extension) {
    size_t bytes = decode_oer_length(p_buf, FALSE);
    uc = p_buf.get_read_data();
    p_buf.increase_pos(bytes);
    uc++;
    if (!(uc[0] & 128)) {
      field_add__Capability = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_add__Capability.OER_decode(ASN_NULL_descr_, p_buf, p_oer);
    }
    if (!(uc[0] & 64)) {
      field_sgsn__mmeSeparationSupported = OMIT_VALUE;
    } else {
      decode_oer_length(p_buf, FALSE);
      field_sgsn__mmeSeparationSupported.OER_decode(UpdateGprsLocationRes_sgsn__mmeSeparationSupported_descr_, p_buf, p_oer);
    }
  }
  else {
    field_add__Capability = OMIT_VALUE;
    field_sgsn__mmeSeparationSupported = OMIT_VALUE;
  }
  return 0;
}

void UpdateGprsLocationRes::PER_encode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options) const
{
if (!is_bound()) {
TTCN_EncDec_ErrorContext::error(TTCN_EncDec::ET_UNBOUND, "Encoding an unbound SEQUENCE value.");
return;
}
boolean ext_0_present = field_add__Capability.is_present();
boolean ext_1_present = field_sgsn__mmeSeparationSupported.is_present();
boolean ext_bit = ext_0_present || ext_1_present;
p_buf.PER_put_bit(ext_bit);
boolean field_extensionContainer_present = field_extensionContainer.is_present();
p_buf.PER_put_bit(field_extensionContainer_present);
field_hlr__Number.PER_encode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_encode(UpdateGprsLocationRes_extensionContainer_descr_, p_buf, p_options);
if (ext_bit) {
INTEGER length_(2);
length_.PER_encode_length(p_buf, p_options, TRUE);
p_buf.PER_put_bit(ext_0_present);
p_buf.PER_put_bit(ext_1_present);
if (ext_0_present) {
TTCN_Buffer ext_add_buf;
field_add__Capability.PER_encode(ASN_NULL_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
if (ext_1_present) {
TTCN_Buffer ext_add_buf;
field_sgsn__mmeSeparationSupported.PER_encode(UpdateGprsLocationRes_sgsn__mmeSeparationSupported_descr_, ext_add_buf, p_options);
PER_encode_opentype(p_buf, ext_add_buf, p_options);
}
}
}

void UpdateGprsLocationRes::PER_decode(const TTCN_Typedescriptor_t& p_td, TTCN_Buffer& p_buf, int p_options)
{
clean_up();
boolean ext_bit = p_buf.PER_get_bit();
boolean field_extensionContainer_present = p_buf.PER_get_bit();
field_hlr__Number.PER_decode(MAP__CommonDataTypes::ISDN__AddressString_descr_, p_buf, p_options);
if (field_extensionContainer_present) field_extensionContainer.PER_decode(UpdateGprsLocationRes_extensionContainer_descr_, p_buf, p_options);
else field_extensionContainer = OMIT_VALUE;
Vector<boolean> ext_presences;
if (ext_bit) {
INTEGER length_;
int normally_small_length = TRUE;
int mul_16k;
do {
mul_16k = length_.PER_decode_length(p_buf, p_options, normally_small_length);
if (mul_16k > 0) normally_small_length = FALSE;
for (int i = 0; i < length_; ++i) {
ext_presences.push_back(p_buf.PER_get_bit());
}
}
while (mul_16k > 0);
}
int nof_decoded_ext_adds = ext_presences.size();
if (nof_decoded_ext_adds < 2) {
for (int i = nof_decoded_ext_adds; i < 2; ++i) {
ext_presences.push_back(FALSE);
}
}
if (ext_presences[0]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_add__Capability.PER_decode(ASN_NULL_descr_, ext_add_buf, p_options);
}
else {
field_add__Capability = OMIT_VALUE;
}
if (ext_presences[1]) {
TTCN_Buffer ext_add_buf;
PER_decode_opentype(p_buf, ext_add_buf, p_options);
field_sgsn__mmeSeparationSupported.PER_decode(UpdateGprsLocationRes_sgsn__mmeSeparationSupported_descr_, ext_add_buf, p_options);
}
else {
field_sgsn__mmeSeparationSupported = OMIT_VALUE;
}
if (nof_decoded_ext_adds > 2) for (int i = 2; i < nof_decoded_ext_adds; ++i) {
if (ext_presences[i]) PER_skip_opentype(p_buf, p_options);
}
}

struct UpdateGprsLocationRes_template::single_value_struct {
OCTETSTRING_template field_hlr__Number;
MAP__ExtensionDataTypes::ExtensionContainer_template field_extensionContainer;
ASN_NULL_template field_add__Capability;
ASN_NULL_template field_sgsn__mmeSeparationSupported;
};

void UpdateGprsLocationRes_template::set_specific()
{
if (template_selection != SPECIFIC_VALUE) {
template_sel old_selection = template_selection;
clean_up();
single_value = new single_value_struct;
set_selection(SPECIFIC_VALUE);
if (old_selection == ANY_VALUE || old_selection == ANY_OR_OMIT) {
single_value->field_hlr__Number = ANY_VALUE;
single_value->field_extensionContainer = ANY_OR_OMIT;
single_value->field_add__Capability = ANY_OR_OMIT;
single_value->field_sgsn__mmeSeparationSupported = ANY_OR_OMIT;
}
}
}

void UpdateGprsLocationRes_template::copy_value(const UpdateGprsLocationRes& other_value)
{
single_value = new single_value_struct;
if (other_value.hlr__Number().is_bound()) {
  single_value->field_hlr__Number = other_value.hlr__Number();
} else {
  single_value->field_hlr__Number.clean_up();
}
if (other_value.extensionContainer().is_bound()) {
  if (other_value.extensionContainer().ispresent()) single_value->field_extensionContainer = other_value.extensionContainer()();
  else single_value->field_extensionContainer = OMIT_VALUE;
} else {
  single_value->field_extensionContainer.clean_up();
}
if (other_value.add__Capability().is_bound()) {
  if (other_value.add__Capability().ispresent()) single_value->field_add__Capability = other_value.add__Capability()();
  else single_value->field_add__Capability = OMIT_VALUE;
} else {
  single_value->field_add__Capability.clean_up();
}
if (other_value.sgsn__mmeSeparationSupported().is_bound()) {
  if (other_value.sgsn__mmeSeparationSupported().ispresent()) single_value->field_sgsn__mmeSeparationSupported = other_value.sgsn__mmeSeparationSupported()();
  else single_value->field_sgsn__mmeSeparationSupported = OMIT_VALUE;
} else {
  single_value->field_sgsn__mmeSeparationSupported.clean_up();
}
set_selection(SPECIFIC_VALUE);
}

void UpdateGprsLocationRes_template::copy_template(const UpdateGprsLocationRes_template& other_value)
{
switch (other_value.template_selection) {
case SPECIFIC_VALUE:
single_value = new single_value_struct;
if (UNINITIALIZED_TEMPLATE != other_value.hlr__Number().get_selection()) {
single_value->field_hlr__Number = other_value.hlr__Number();
} else {
single_value->field_hlr__Number.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.extensionContainer().get_selection()) {
single_value->field_extensionContainer = other_value.extensionContainer();
} else {
single_value->field_extensionContainer.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.add__Capability().get_selection()) {
single_value->field_add__Capability = other_value.add__Capability();
} else {
single_value->field_add__Capability.clean_up();
}
if (UNINITIALIZED_TEMPLATE != other_value.sgsn__mmeSeparationSupported().get_selection()) {
single_value->field_sgsn__mmeSeparationSupported = other_value.sgsn__mmeSeparationSupported();
} else {
single_value->field_sgsn__mmeSeparationSupported.clean_up();
}
case OMIT_VALUE:
case ANY_VALUE:
case ANY_OR_OMIT:
break;
case VALUE_LIST:
case COMPLEMENTED_LIST:
case CONJUNCTION_MATCH:
value_list.n_values = other_value.value_list.n_values;
value_list.list_value = new UpdateGprsLocationRes_template[value_list.n_values];
for (unsigned int list_count = 0; list_count < value_list.n_values; list_count++)
value_list.list_value[list_count].copy_template(other_value.value_list.list_value[list_count]);
break;
case IMPLICATION_MATCH:
implication_.precondition = new UpdateGprsLocationRes_template(*other_value.implication_.precondition);
implication_.implied_template = new UpdateGprsLocationRes_template(*other_value.implication_.implied_template);
break;
case DYNAMIC_MATCH:
dyn_match = other_value.dyn_match;
dyn_match->ref_count++;
break;
default:
TTCN_error("Copying an uninitialized/unsupported template of type @MAP-MS-DataTypes.UpdateGprsLocationRes.");
break;
}
set_selection(other_value);
}

UpdateGprsLocationRes_template::UpdateGprsLocationRes_template()
{
}

UpdateGprsLocationRes_template::UpdateGprsLocationRes_template(template_sel other_value)
 : Base_Template(other_value)
{
check_single_selection(other_value);
}

UpdateGprsLocationRes_template::UpdateGprsLocationRes_template(const UpdateGprsLocationRes& other_value)
{
copy_value(other_value);
}

UpdateGprsLocationRes_template::UpdateGprsLocationRes_template(const OPTIONAL<UpdateGprsLocationRes>& other_value)
{
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UpdateGprsLocationRes&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Creating a template of type @MAP-MS-DataTypes.UpdateGprsLocationRes from an unbound optional field.");
}
}

UpdateGprsLocationRes_template::UpdateGprsLocationRes_template(UpdateGprsLocationRes_template* p_precondition, UpdateGprsLocationRes_template* p_implied_template)
 : Base_Template(IMPLICATION_MATCH)
{
implication_.precondition = p_precondition;
implication_.implied_template = p_implied_template;
}

UpdateGprsLocationRes_template::UpdateGprsLocationRes_template(Dynamic_Match_Interface<UpdateGprsLocationRes>* p_dyn_match)
 : Base_Template(DYNAMIC_MATCH)
{
dyn_match = new dynmatch_struct<UpdateGprsLocationRes>;
dyn_match->ptr = p_dyn_match;
dyn_match->ref_count = 1;
}

UpdateGprsLocationRes_template::UpdateGprsLocationRes_template(const UpdateGprsLocationRes_template& other_value)
: Base_Template()
{
copy_template(other_value);
}

UpdateGprsLocationRes_template::~UpdateGprsLocationRes_template()
{
clean_up();
}

UpdateGprsLocationRes_template& UpdateGprsLocationRes_template::operator=(template_sel other_value)
{
check_single_selection(other_value);
clean_up();
set_selection(other_value);
return *this;
}

UpdateGprsLocationRes_template& UpdateGprsLocationRes_template::operator=(const UpdateGprsLocationRes& other_value)
{
clean_up();
copy_value(other_value);
return *this;
}

UpdateGprsLocationRes_template& UpdateGprsLocationRes_template::operator=(const OPTIONAL<UpdateGprsLocationRes>& other_value)
{
clean_up();
switch (other_value.get_selection()) {
case OPTIONAL_PRESENT:
copy_value((const UpdateGprsLocationRes&)other_value);
break;
case OPTIONAL_OMIT:
set_selection(OMIT_VALUE);
break;
default:
TTCN_error("Assignment of an unbound optional field to a template of type @MAP-MS-DataTypes.UpdateGprsLocationRes.");
}
return *this;
}

UpdateGprsLocationRes_template& UpdateGprsLocationRes_template::operator=(const UpdateGpr